import { Construct } from 'constructs';
import { EnvVar } from './envvar-ins';
export interface AwsLoadBalancerControllerOptions {
    /**
     * Extra labels to associate with resources.
     * @default - none
     */
    readonly labels?: {
        [name: string]: string;
    };
    /**
     * Default Namespace for aws-load-balancer-controller.
     * @default - kube-system
     */
    readonly namespace?: string;
    /**
     * Kubernetes Cluster Name for aws-load-balancer-controller.
     * @default - None
     */
    readonly clusterName: string;
    /**
     * Default Service Account Name for aws-load-balancer-controller.
     * @default - aws-load-balancer-controller
     */
    readonly serviceAccountName?: string;
    /**
     * Default image for aws-load-balancer-controller.
     * @default - docker.io/amazon/aws-aws-load-balancer-controller:v1.1.9
     */
    readonly image?: string;
    /**
     * Another Args for aws-load-balancer-controller.
     * @default - None
     */
    readonly args?: string[];
    /**
     * Another Args for aws-load-balancer-controller.
     * @default - None
     */
    readonly env?: EnvVar[];
    /**
     * Replicas for aws-load-balancer-controller.
     * @default - 1
     */
    readonly replicas?: number;
}
/**
 * Generate aws-load-balancer-controller config yaml.
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
*/
export declare class AwsLoadBalancerController extends Construct {
    /**
     * Service Account Name for aws-load-balancer-controller.
     */
    readonly serviceAccountName: string;
    /**
     * Kubernetes Cluster Name for aws-load-balancer-controller.
     */
    readonly clusterName: string;
    /**
     * Kubernetes Deployment Name for aws-load-balancer-controller.
     */
    readonly deploymentName: string;
    /**
     * Namespace for aws-load-balancer-controller.
     * @default - kube-system
     */
    readonly namespace: string;
    constructor(scope: Construct, id: string, options: AwsLoadBalancerControllerOptions);
    private argsFunc;
    private envFunc;
}
