# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['odoo_openupgrade_wizard',
 'odoo_openupgrade_wizard.cli',
 'odoo_openupgrade_wizard.tools']

package_data = \
{'': ['*'],
 'odoo_openupgrade_wizard': ['templates/*',
                             'templates/odoo/*',
                             'templates/scripts/*']}

install_requires = \
['GitPython>=3.1,<4.0',
 'click-loglevel>=0.4,<0.5',
 'click>=7.0,<8.0',
 'docker>=5.0,<6.0',
 'git-aggregator>=2.1,<3.0',
 'jinja2>=3.0,<4.0',
 'loguru>=0.6,<0.7',
 'odoorpc>=0.8,<0.9',
 'plumbum>=1.7,<2.0',
 'pygount>=1.4,<2.0',
 'pyyaml==5.4.1',
 'single-source>=0.3,<0.4']

entry_points = \
{'console_scripts': ['odoo-openupgrade-wizard = '
                     'odoo_openupgrade_wizard.cli.cli:main',
                     'oow = odoo_openupgrade_wizard.cli.cli:main']}

setup_kwargs = {
    'name': 'odoo-openupgrade-wizard',
    'version': '0.2.0',
    'description': 'CLI tool to manage Odoo Major Upgrades',
    'long_description': '[![Gitlab CI](https://gitlab.com/odoo-openupgrade-wizard/odoo-openupgrade-wizard/badges/main/pipeline.svg)](https://gitlab.com/odoo-openupgrade-wizard/odoo-openupgrade-wizard/-/pipelines)\n\n[![codecov](https://codecov.io/gl/odoo-openupgrade-wizard/odoo-openupgrade-wizard/branch/main/graph/badge.svg)](https://codecov.io/gl/odoo-openupgrade-wizard/odoo-openupgrade-wizard)\n\n[![License: AGPL v3](https://img.shields.io/badge/License-AGPL_v3-blue.svg)](https://www.gnu.org/licenses/agpl-3.0)\n\n\n\n# odoo-openupgrade-wizard\n\nOdoo Openupgrade Wizard is a tool that helps developpers to make major\nupgrade of Odoo Community Edition. (formely OpenERP).\nIt works with Openupgrade OCA tools. (https://github.com/oca/openupgrade)\n\nthis tool is useful for complex migrations:\n- migrate several versions\n- take advantage of the migration to install / uninstall modules\n- execute sql requests or click-odoo scripts between each migration\n- analyse workload\n\nIt will create a migration environment (with all the code available)\nand provides helpers to run (and replay) migrations until it works.\n\n* To develop and contribute to the library, refer to the ``DEVELOP.md`` file.\n* Refer to the ``ROADMAP.md`` file to see the current limitation, bugs, and task to do.\n* See authors in the ``CONTRIBUTORS.md`` file.\n\n# Installation\n\n**Prerequites**\n\n* You should have docker installed on your system\n* the tools run on debian system\n\n**Installation**\n\n``pipx install odoo-openupgrade-wizard``\n\n(coming soon. Not still deployed on pypi ! See alternative installation\nin ``DEVELOP.md`` file.)\n\n# Usage\n\n\n\n## ``odoo-openupgrade-wizard init``\n\n```\nodoo-openupgrade-wizard init\\\n  --initial-version=10.0\\\n  --final-version=12.0\\\n  --project-name=my-customer-10-12\\\n  --extra-repository=OCA/web,OCA/server-tools\n```\n\nInitialize a folder to make a migration from a 10.0 and a 12.0 database.\nThis will generate the following structure :\n\n```\nfilestore/\nlog/\n    2022_03_25__23_12_41__init.log\n    ...\npostgres_data/\nscripts/\n    step_1__update__10.0/\n        pre-migration.sql\n        post-migration.py\n    step_2__upgrade__11.0/\n        ...\n    step_3__upgrade__12.0/\n        ...\n    step_4__update__12.0/\n        ...\nsrc/\n    env_10.0/\n        debian_requirements.txt\n        Dockerfile\n        odoo.cfg\n        python_requirements.txt\n        repos.yml\n        src/\n    env_11.0/\n        ...\n    env_12.0/\n        ...\nconfig.yml\nmodules.csv\n```\n\n* ``config.yml`` is the main configuration file of your project.\n\n* ``modules.csv`` file is an optional file. You can fill it with the list\n  of your modules installed on your production. The first column of this\n  file should contain the technical name of the module.\n\n* ``log`` folder will contains all the log of the ``odoo-openupgrade-wizard``\n  and the logs of the odoo instance that will be executed.\n\n* ``filestore`` folder will contains the filestore of the odoo database(s)\n\n* ``postgres_data`` folder will be used by postgres docker image to store\n  database.\n\n* ``scripts`` folder contains a folder per migration step. In each step folder:\n  - ``pre-migration.sql`` can contains extra SQL queries you want to execute\n    before beginning the step.\n  - ``post-migration.py`` can contains extra python command to execute\n    after the execution of the step.\n    Script will be executed with ``click-odoo`` command. All the ORM is available\n    via the ``env`` variable.\n\n* ``src`` folder contains a folder per Odoo version. In each environment folder:\n\n    - ``repos.yml`` enumerates the list of the repositories to use to run the odoo instance.\n      The syntax should respect the ``gitaggregate`` command.\n      (See : https://pypi.org/project/git-aggregator/)\n      Repo files are pre-generated. You can update them with your custom settings.\n      (custom branches, extra PRs, git shallow options, etc...)\n\n    - ``python_requirements.txt`` enumerates the list of extra python librairies\n      required to run the odoo instance.\n      The syntax should respect the ``pip install -r`` command.\n      (See : https://pip.pypa.io/en/stable/reference/requirements-file-format/)\n\n    - ``debian_requirements.txt`` enumerates the list of extra system librairies\n      required to run the odoo instance.\n\n    - ``odoo.cfg`` file. Add here extra configuration required for your custom modules.\n      the classical keys (``db_host``, ``db_port``, etc...) are automatically\n      autogenerated.\n\nAt this step, you should change the autogenerated files.\nYou can use default files, if you have a very simple odoo instance without custom code,\nextra repositories, or dependencies...\n\n**Note:**\n- In your repos.yml, preserve ``openupgrade`` and ``server-tools`` repositories\n  to have all the features of the librairies available.\n\n\n## ``odoo-openupgrade-wizard get-code``\n\nPrerequites : init\n\n```\nodoo-openupgrade-wizard get-code\n```\n\nThis command will simply get all the Odoo code required to run all the steps\nfor your migration with the ``gitaggregate`` tools.\n\nThe code is defined in the ``repos.yml`` of each sub folders.\n\n**Note**\n\n* This step could take a big while !\n\n**Optional arguments**\n\nif you want to update the code of some given versions, you can provide an extra parameter:\n\n```\nodoo-openupgrade-wizard get-code --versions 10.0,11.0\n```\n\n\n\n## ``odoo-openupgrade-wizard docker-build``\n\nPrerequites : init + get-code\n\nThis will build local docker images that will be used in the following steps.\n\nThis script will pull official odoo docker images, defined in the ``Dockerfile`` of\neach folder, and build a custom images on top the official one, installing inside\ncustom librairies defined in ``debian_requirements.txt``, ``python_requirements.txt``.\n\nAt this end of this step executing the following command should show a docker image per version.\n\n\n```\n$ docker images --filter "reference=odoo-openupgrade-wizard-*"\n\nREPOSITORY                                                 TAG       IMAGE ID       CREATED       SIZE\nodoo-openupgrade-wizard-image---my-customer-10-12---12.0   latest    ef664c366208   2 weeks ago   1.39GB\nodoo-openupgrade-wizard-image---my-customer-10-12---11.0   latest    24e283fe4ae4   2 weeks ago   1.16GB\nodoo-openupgrade-wizard-image---my-customer-10-12---10.0   latest    9d94dce2bd4e   2 weeks ago   924MB\n```\n\n**Optional arguments**\n\n* if you want to (re)build an image for some given versions, you can provide\n  an extra parameter: ``--versions 10.0,12.0``\n\n**Note**\n\n* This step could take a big while also !\n\n\n\n## ``odoo-openupgrade-wizard run`` (BETA)\n\nPrerequites : init + get-code + build\n\n```\nodoo-openupgrade-wizard run\\\n    --step 1\\\n    --database DB_NAME\n```\n\nRun an Odoo instance with the environment defined by the step argument.\n\nThe database will be created, if it doesn\'t exists.\n\nif ``stop-after-init`` is disabled, the odoo instance will be available\nat your host, at the following url : http://localhost:9069\n(Port depends on your ``host_odoo_xmlrpc_port`` setting of your ``config.yml`` file)\n\n**Optional arguments**\n\n* You can add ``--init-modules=purchase,sale`` to install modules.\n\n* You can add ``stop-after-init`` flag to turn off the process at the end\n  of the installation.\n\n\n\n## ``odoo-openupgrade-wizard install-from-csv``\n\nPrerequites : init + get-code + build\n\n```\nodoo-openupgrade-wizard install-from-csv\\\n    --database DB_NAME\n```\n\nInstall the list of the modules defined in your ``modules.csv`` files on the\ngiven database.\n\nThe database will be created, if it doesn\'t exists.\n\nTo get a correct ``modules.csv`` file, the following query can be used:\n```\npsql -c "copy (select name, shortdesc from ir_module_module where state = \'installed\' order by 1) to stdout csv" coopiteasy\n```\n\n\n\n## ``odoo-openupgrade-wizard upgrade`` (BETA)\n\nPrerequites : init + get-code + build\n\n```\nodoo-openupgrade-wizard upgrade\\\n    --database DB_NAME\n```\n\nRealize an upgrade of the database from the initial version to\nthe final version, following the different steps.\n\nFor each step, it will :\n\n1. Execute the ``pre-migration.sql`` of the step.\n2. Realize an "update all" (in an upgrade or update context)\n3. Execute the scripts via XML-RPC (via ``odoorpc``) defined in\n   the ``post-migration.py`` file.\n\n**Optional arguments**\n\n* You can add ``--first-step=2`` to start at the second step.\n\n* You can add ``--last-step=3`` to end at the third step.\n\n\n\n## ``odoo-openupgrade-wizard generate-module-analysis`` (BETA)\n\nPrerequites : init + get-code + build\n\n```\nodoo-openupgrade-wizard generate-module-analysis\\\n    --database DB_NAME\n    --step 2\n    --modules MODULE_LIST\n```\n\nRealize an analyze between the target version (in parameter via the step argument)\nand the previous version. It will generate analysis_file.txt files present\nin OpenUpgrade project.\nYou can also use this fonction to analyze differences for custom / OCA modules\nbetween several versions, in case of refactoring.\n\n\n## ``odoo-openupgrade-wizard estimate-workload``\n\nPrerequites : init + get-code\n\n```\nodoo-openupgrade-wizard estimate-workload\n```\n\nGenerate an HTML file name ``analysis.html`` with all the information regarding\nthe work to do for the migration.\n- checks that the modules are present in each version. (by managing the\n  renaming or merging of modules)\n- check that the analysis and migration have been done for the official\n  modules present in odoo/odoo\n',
    'author': 'GRAP, Groupement Régional Alimentaire de Proximité',
    'author_email': None,
    'maintainer': 'Sylvain LE GAL',
    'maintainer_email': None,
    'url': 'https://gitlab.com/odoo-openupgrade-wizard/odoo-openupgrade-wizard',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.3,<4.0.0',
}


setup(**setup_kwargs)
