import re
from urllib.request import *
from .link_finder import LinkFinder
from . import main


class Spider:

    # Class variables (shared among all instances)
    project_name = ''
    base_url = ''
    domain_name = ''
    queue = set()
    crawled = set()

    def __init__(self, project_name, base_url, domain_name):
        Spider.project_name = project_name
        Spider.base_url = base_url
        Spider.domain_name = domain_name
        self.crawl_page('First spider', Spider.base_url)

    # @staticmethod
    # def boot():
    #     create_project_dir(Spider.project_name)
    #     create_data_files(Spider.project_name, Spider.base_url)
    #     Spider.queue = file_to_set(Spider.queue_file)
    #     Spider.crawled = file_to_set(Spider.crawled_file)

    @staticmethod
    def crawl_page(thread_name, page_url):
        if page_url not in Spider.crawled:
            print(thread_name + ' now crawling ' + page_url)
            Spider.queue.add(page_url)
            print('Queue ' + str(len(Spider.queue)) + ' | Crawled ' + str(len(Spider.crawled)))
            Spider.add_links_to_queue(Spider.gather_links(page_url))
        Spider.queue.remove(page_url)
        Spider.crawled.add(page_url)

    @staticmethod
    def gather_links(page_url):
        html_string = ''
        try:
            response = urlopen(page_url)
            if re.search('text/html', response.getheader('content-type')):
                html_bytes = response.read()
                html_string = html_bytes.decode("utf-8")
            finder = LinkFinder(Spider.base_url)
            finder.feed(html_string)
            return finder.page_links()
        except:
            print('Error: can not crawl page')
            return set()

    @staticmethod
    def add_links_to_queue(links):
        for url in links:
            if url in Spider.queue:
                continue
            if url in Spider.crawled:
                continue
            if Spider.domain_name not in url:
                continue
            if len(Spider.queue) < main.StartPoint.MAX_CRAWL:
                Spider.queue.add(url)

    # @staticmethod
    # def update_files():
    #     set_to_file(Spider.queue, Spider.queue_file)
    #     set_to_file(Spider.crawled, Spider.crawled_file)
