import * as tfe from "@cdktf/provider-tfe";
import { DataTfeOrganization, TfeProvider } from "@cdktf/provider-tfe";
import { TerraformStack } from "cdktf";
import { Construct, IConstruct } from "constructs";
export interface BaseStackOptions {
    readonly hostname?: string;
    readonly token?: string;
    readonly sslSkipVerify?: boolean;
}
export interface RemoteBackendOptionsWorkspace {
    readonly name: string;
}
export interface RemoteBackendOptions {
    readonly hostname?: string;
    readonly organization: string;
    readonly token?: string;
    readonly workspaces: RemoteBackendOptionsWorkspace;
}
export declare class BaseStack extends TerraformStack {
    private organizationName;
    private prefix;
    private options;
    static isBaseStack(x: any): x is BaseStack;
    static baseStackOf(construct: IConstruct): BaseStack;
    tfeProvider: TfeProvider;
    organization: DataTfeOrganization;
    constructor(scope: Construct, organizationName: string, prefix: string, options?: BaseStackOptions);
    getRemoteBackendOptions(stackName: string): RemoteBackendOptions;
    /**
     * If you want to have more control over the workspace name, you can override this method.
     */
    getWorkspaceName(stackName: string): string;
    bootstrapWorkspace(stackName: string): tfe.Workspace;
}
export declare class Stack extends TerraformStack {
    static isMultiStackStack(x: any): x is Stack;
    workspace: tfe.Workspace;
    constructor(scope: Construct, stackName: string);
    addDependency(dependency: TerraformStack): void;
}
