"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path = require("path");
/**
 * Builder
 */
class Builder {
    constructor(options) {
        this.entry = options.entry;
        this.outDir = options.outDir;
        this.buildCmd = options.buildCmd;
        this.handler = options.handler;
        this.extraEnv = options.extraEnv;
    }
    build() {
        try {
            const cmd = `${this.buildCmd} -o ${this.outDir}/${this.handler} ${this.entry}`;
            const cwd = path.dirname(this.entry);
            const goBuild = child_process_1.spawnSync(cmd, {
                env: { ...process.env, GOOS: 'linux', ...this.extraEnv },
                shell: true,
                cwd,
            });
            if (goBuild.error) {
                throw goBuild.error;
            }
            if (goBuild.status !== 0) {
                throw new Error(goBuild.stdout.toString().trim());
            }
        }
        catch (err) {
            throw new Error(`Failed to compile Go function at ${this.entry}: ${err}`);
        }
    }
}
exports.Builder = Builder;
//# sourceMappingURL=data:application/json;base64,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