"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// From https://github.com/errwischt/stacktrace-parser/blob/master/src/stack-trace-parser.js
const STACK_RE = /^\s*at (?:((?:\[object object\])?[^\\/]+(?: \[as \S+\])?) )?\(?(.*?):(\d+)(?::(\d+))?\)?\s*$/i;
/**
 * Parses the stack trace of an error
 */
function parseStackTrace(error) {
    const err = error || new Error();
    if (!err.stack) {
        return [];
    }
    const lines = err.stack.split('\n');
    const stackTrace = [];
    for (const line of lines) {
        const results = STACK_RE.exec(line);
        if (results) {
            stackTrace.push({
                file: results[2],
                methodName: results[1],
                lineNumber: parseInt(results[3], 10),
                column: parseInt(results[4], 10),
            });
        }
    }
    return stackTrace;
}
exports.parseStackTrace = parseStackTrace;
//# sourceMappingURL=data:application/json;base64,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