# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddCasterComponentRequest(TeaModel):
    def __init__(self, caption_layer_content=None, caster_id=None, component_layer=None, component_name=None,
                 component_type=None, effect=None, html_layer_content=None, image_layer_content=None, layer_order=None,
                 location_id=None, owner_id=None, text_layer_content=None):
        self.caption_layer_content = caption_layer_content  # type: str
        self.caster_id = caster_id  # type: str
        self.component_layer = component_layer  # type: str
        self.component_name = component_name  # type: str
        self.component_type = component_type  # type: str
        self.effect = effect  # type: str
        self.html_layer_content = html_layer_content  # type: str
        self.image_layer_content = image_layer_content  # type: str
        self.layer_order = layer_order  # type: str
        self.location_id = location_id  # type: str
        self.owner_id = owner_id  # type: long
        self.text_layer_content = text_layer_content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterComponentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption_layer_content is not None:
            result['CaptionLayerContent'] = self.caption_layer_content
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_layer is not None:
            result['ComponentLayer'] = self.component_layer
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.html_layer_content is not None:
            result['HtmlLayerContent'] = self.html_layer_content
        if self.image_layer_content is not None:
            result['ImageLayerContent'] = self.image_layer_content
        if self.layer_order is not None:
            result['LayerOrder'] = self.layer_order
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.text_layer_content is not None:
            result['TextLayerContent'] = self.text_layer_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaptionLayerContent') is not None:
            self.caption_layer_content = m.get('CaptionLayerContent')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentLayer') is not None:
            self.component_layer = m.get('ComponentLayer')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('HtmlLayerContent') is not None:
            self.html_layer_content = m.get('HtmlLayerContent')
        if m.get('ImageLayerContent') is not None:
            self.image_layer_content = m.get('ImageLayerContent')
        if m.get('LayerOrder') is not None:
            self.layer_order = m.get('LayerOrder')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('TextLayerContent') is not None:
            self.text_layer_content = m.get('TextLayerContent')
        return self


class AddCasterComponentResponseBody(TeaModel):
    def __init__(self, component_id=None, request_id=None):
        self.component_id = component_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterComponentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterComponentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCasterComponentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCasterComponentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeRequest(TeaModel):
    def __init__(self, caster_id=None, component_id=None, end_time=None, episode_name=None, episode_type=None,
                 owner_id=None, resource_id=None, start_time=None, switch_type=None):
        self.caster_id = caster_id  # type: str
        self.component_id = component_id  # type: list[str]
        self.end_time = end_time  # type: str
        self.episode_name = episode_name  # type: str
        self.episode_type = episode_type  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_id = resource_id  # type: str
        self.start_time = start_time  # type: str
        self.switch_type = switch_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterEpisodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        return self


class AddCasterEpisodeResponseBody(TeaModel):
    def __init__(self, episode_id=None, request_id=None):
        self.episode_id = episode_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterEpisodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterEpisodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCasterEpisodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCasterEpisodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeGroupRequestItem(TeaModel):
    def __init__(self, item_name=None, vod_url=None):
        self.item_name = item_name  # type: str
        self.vod_url = vod_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterEpisodeGroupRequestItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        return self


class AddCasterEpisodeGroupRequest(TeaModel):
    def __init__(self, callback_url=None, client_token=None, domain_name=None, item=None, owner_id=None,
                 repeat_num=None, side_output_url=None, start_time=None):
        self.callback_url = callback_url  # type: str
        self.client_token = client_token  # type: str
        self.domain_name = domain_name  # type: str
        self.item = item  # type: list[AddCasterEpisodeGroupRequestItem]
        self.owner_id = owner_id  # type: long
        self.repeat_num = repeat_num  # type: int
        self.side_output_url = side_output_url  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddCasterEpisodeGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.side_output_url is not None:
            result['SideOutputUrl'] = self.side_output_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = AddCasterEpisodeGroupRequestItem()
                self.item.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('SideOutputUrl') is not None:
            self.side_output_url = m.get('SideOutputUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class AddCasterEpisodeGroupResponseBodyItemIds(TeaModel):
    def __init__(self, item_id=None):
        self.item_id = item_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterEpisodeGroupResponseBodyItemIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        return self


class AddCasterEpisodeGroupResponseBody(TeaModel):
    def __init__(self, item_ids=None, program_id=None, request_id=None):
        self.item_ids = item_ids  # type: AddCasterEpisodeGroupResponseBodyItemIds
        self.program_id = program_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.item_ids:
            self.item_ids.validate()

    def to_map(self):
        _map = super(AddCasterEpisodeGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids.to_map()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemIds') is not None:
            temp_model = AddCasterEpisodeGroupResponseBodyItemIds()
            self.item_ids = temp_model.from_map(m['ItemIds'])
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterEpisodeGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCasterEpisodeGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCasterEpisodeGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterEpisodeGroupContentRequest(TeaModel):
    def __init__(self, client_token=None, content=None, owner_id=None):
        self.client_token = client_token  # type: str
        self.content = content  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterEpisodeGroupContentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.content is not None:
            result['Content'] = self.content
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class AddCasterEpisodeGroupContentResponseBodyItemIds(TeaModel):
    def __init__(self, item_id=None):
        self.item_id = item_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterEpisodeGroupContentResponseBodyItemIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        return self


class AddCasterEpisodeGroupContentResponseBody(TeaModel):
    def __init__(self, item_ids=None, program_id=None, request_id=None):
        self.item_ids = item_ids  # type: AddCasterEpisodeGroupContentResponseBodyItemIds
        self.program_id = program_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.item_ids:
            self.item_ids.validate()

    def to_map(self):
        _map = super(AddCasterEpisodeGroupContentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids.to_map()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemIds') is not None:
            temp_model = AddCasterEpisodeGroupContentResponseBodyItemIds()
            self.item_ids = temp_model.from_map(m['ItemIds'])
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterEpisodeGroupContentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCasterEpisodeGroupContentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCasterEpisodeGroupContentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterEpisodeGroupContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterLayoutRequestAudioLayer(TeaModel):
    def __init__(self, fixed_delay_duration=None, valid_channel=None, volume_rate=None):
        self.fixed_delay_duration = fixed_delay_duration  # type: int
        self.valid_channel = valid_channel  # type: str
        self.volume_rate = volume_rate  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterLayoutRequestAudioLayer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        return self


class AddCasterLayoutRequestVideoLayer(TeaModel):
    def __init__(self, fill_mode=None, fixed_delay_duration=None, height_normalized=None, position_normalized=None,
                 position_refer=None, width_normalized=None):
        self.fill_mode = fill_mode  # type: str
        self.fixed_delay_duration = fixed_delay_duration  # type: int
        self.height_normalized = height_normalized  # type: float
        self.position_normalized = position_normalized  # type: list[float]
        self.position_refer = position_refer  # type: str
        self.width_normalized = width_normalized  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterLayoutRequestVideoLayer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fill_mode is not None:
            result['FillMode'] = self.fill_mode
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_normalized is not None:
            result['PositionNormalized'] = self.position_normalized
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FillMode') is not None:
            self.fill_mode = m.get('FillMode')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionNormalized') is not None:
            self.position_normalized = m.get('PositionNormalized')
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class AddCasterLayoutRequest(TeaModel):
    def __init__(self, audio_layer=None, blend_list=None, caster_id=None, mix_list=None, owner_id=None,
                 video_layer=None):
        self.audio_layer = audio_layer  # type: list[AddCasterLayoutRequestAudioLayer]
        self.blend_list = blend_list  # type: list[str]
        self.caster_id = caster_id  # type: str
        self.mix_list = mix_list  # type: list[str]
        self.owner_id = owner_id  # type: long
        self.video_layer = video_layer  # type: list[AddCasterLayoutRequestVideoLayer]

    def validate(self):
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()
        if self.video_layer:
            for k in self.video_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddCasterLayoutRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        if self.blend_list is not None:
            result['BlendList'] = self.blend_list
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.mix_list is not None:
            result['MixList'] = self.mix_list
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        result['VideoLayer'] = []
        if self.video_layer is not None:
            for k in self.video_layer:
                result['VideoLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = AddCasterLayoutRequestAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        if m.get('BlendList') is not None:
            self.blend_list = m.get('BlendList')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('MixList') is not None:
            self.mix_list = m.get('MixList')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        self.video_layer = []
        if m.get('VideoLayer') is not None:
            for k in m.get('VideoLayer'):
                temp_model = AddCasterLayoutRequestVideoLayer()
                self.video_layer.append(temp_model.from_map(k))
        return self


class AddCasterLayoutResponseBody(TeaModel):
    def __init__(self, layout_id=None, request_id=None):
        self.layout_id = layout_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterLayoutResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterLayoutResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCasterLayoutResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCasterLayoutResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterProgramRequestEpisode(TeaModel):
    def __init__(self, component_id=None, end_time=None, episode_name=None, episode_type=None, resource_id=None,
                 start_time=None, switch_type=None):
        self.component_id = component_id  # type: list[str]
        self.end_time = end_time  # type: str
        self.episode_name = episode_name  # type: str
        self.episode_type = episode_type  # type: str
        self.resource_id = resource_id  # type: str
        self.start_time = start_time  # type: str
        self.switch_type = switch_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterProgramRequestEpisode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        return self


class AddCasterProgramRequest(TeaModel):
    def __init__(self, caster_id=None, episode=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.episode = episode  # type: list[AddCasterProgramRequestEpisode]
        self.owner_id = owner_id  # type: long

    def validate(self):
        if self.episode:
            for k in self.episode:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddCasterProgramRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        result['Episode'] = []
        if self.episode is not None:
            for k in self.episode:
                result['Episode'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        self.episode = []
        if m.get('Episode') is not None:
            for k in m.get('Episode'):
                temp_model = AddCasterProgramRequestEpisode()
                self.episode.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class AddCasterProgramResponseBodyEpisodeIdsEpisodeId(TeaModel):
    def __init__(self, episode_id=None):
        self.episode_id = episode_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterProgramResponseBodyEpisodeIdsEpisodeId, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        return self


class AddCasterProgramResponseBodyEpisodeIds(TeaModel):
    def __init__(self, episode_id=None):
        self.episode_id = episode_id  # type: list[AddCasterProgramResponseBodyEpisodeIdsEpisodeId]

    def validate(self):
        if self.episode_id:
            for k in self.episode_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddCasterProgramResponseBodyEpisodeIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EpisodeId'] = []
        if self.episode_id is not None:
            for k in self.episode_id:
                result['EpisodeId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.episode_id = []
        if m.get('EpisodeId') is not None:
            for k in m.get('EpisodeId'):
                temp_model = AddCasterProgramResponseBodyEpisodeIdsEpisodeId()
                self.episode_id.append(temp_model.from_map(k))
        return self


class AddCasterProgramResponseBody(TeaModel):
    def __init__(self, episode_ids=None, request_id=None):
        self.episode_ids = episode_ids  # type: AddCasterProgramResponseBodyEpisodeIds
        self.request_id = request_id  # type: str

    def validate(self):
        if self.episode_ids:
            self.episode_ids.validate()

    def to_map(self):
        _map = super(AddCasterProgramResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.episode_ids is not None:
            result['EpisodeIds'] = self.episode_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EpisodeIds') is not None:
            temp_model = AddCasterProgramResponseBodyEpisodeIds()
            self.episode_ids = temp_model.from_map(m['EpisodeIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCasterProgramResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCasterProgramResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCasterProgramResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCasterVideoResourceRequest(TeaModel):
    def __init__(self, begin_offset=None, caster_id=None, end_offset=None, fixed_delay_duration=None,
                 live_stream_url=None, location_id=None, material_id=None, owner_id=None, pts_callback_interval=None,
                 repeat_num=None, resource_name=None, stream_id=None, vod_url=None):
        self.begin_offset = begin_offset  # type: int
        self.caster_id = caster_id  # type: str
        self.end_offset = end_offset  # type: int
        self.fixed_delay_duration = fixed_delay_duration  # type: int
        self.live_stream_url = live_stream_url  # type: str
        self.location_id = location_id  # type: str
        self.material_id = material_id  # type: str
        self.owner_id = owner_id  # type: long
        self.pts_callback_interval = pts_callback_interval  # type: int
        self.repeat_num = repeat_num  # type: int
        self.resource_name = resource_name  # type: str
        self.stream_id = stream_id  # type: str
        self.vod_url = vod_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterVideoResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_offset is not None:
            result['BeginOffset'] = self.begin_offset
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.end_offset is not None:
            result['EndOffset'] = self.end_offset
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.live_stream_url is not None:
            result['LiveStreamUrl'] = self.live_stream_url
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pts_callback_interval is not None:
            result['PtsCallbackInterval'] = self.pts_callback_interval
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.stream_id is not None:
            result['StreamId'] = self.stream_id
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BeginOffset') is not None:
            self.begin_offset = m.get('BeginOffset')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EndOffset') is not None:
            self.end_offset = m.get('EndOffset')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('LiveStreamUrl') is not None:
            self.live_stream_url = m.get('LiveStreamUrl')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PtsCallbackInterval') is not None:
            self.pts_callback_interval = m.get('PtsCallbackInterval')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('StreamId') is not None:
            self.stream_id = m.get('StreamId')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        return self


class AddCasterVideoResourceResponseBody(TeaModel):
    def __init__(self, request_id=None, resource_id=None):
        self.request_id = request_id  # type: str
        self.resource_id = resource_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCasterVideoResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class AddCasterVideoResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCasterVideoResourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCasterVideoResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCasterVideoResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCustomLiveStreamTranscodeRequest(TeaModel):
    def __init__(self, app=None, audio_bitrate=None, audio_channel_num=None, audio_codec=None, audio_profile=None,
                 audio_rate=None, domain=None, encrypt_parameters=None, fps=None, gop=None, height=None,
                 kms_key_expire_interval=None, kms_key_id=None, kms_uid=None, owner_id=None, profile=None, template=None, template_type=None,
                 video_bitrate=None, width=None):
        self.app = app  # type: str
        self.audio_bitrate = audio_bitrate  # type: int
        self.audio_channel_num = audio_channel_num  # type: int
        self.audio_codec = audio_codec  # type: str
        self.audio_profile = audio_profile  # type: str
        self.audio_rate = audio_rate  # type: int
        self.domain = domain  # type: str
        self.encrypt_parameters = encrypt_parameters  # type: str
        self.fps = fps  # type: int
        self.gop = gop  # type: str
        self.height = height  # type: int
        self.kms_key_expire_interval = kms_key_expire_interval  # type: str
        self.kms_key_id = kms_key_id  # type: str
        self.kms_uid = kms_uid  # type: str
        self.owner_id = owner_id  # type: long
        self.profile = profile  # type: int
        self.template = template  # type: str
        self.template_type = template_type  # type: str
        self.video_bitrate = video_bitrate  # type: int
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCustomLiveStreamTranscodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.audio_bitrate is not None:
            result['AudioBitrate'] = self.audio_bitrate
        if self.audio_channel_num is not None:
            result['AudioChannelNum'] = self.audio_channel_num
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.audio_profile is not None:
            result['AudioProfile'] = self.audio_profile
        if self.audio_rate is not None:
            result['AudioRate'] = self.audio_rate
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.encrypt_parameters is not None:
            result['EncryptParameters'] = self.encrypt_parameters
        if self.fps is not None:
            result['FPS'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.kms_key_expire_interval is not None:
            result['KmsKeyExpireInterval'] = self.kms_key_expire_interval
        if self.kms_key_id is not None:
            result['KmsKeyID'] = self.kms_key_id
        if self.kms_uid is not None:
            result['KmsUID'] = self.kms_uid
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.template is not None:
            result['Template'] = self.template
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('AudioBitrate') is not None:
            self.audio_bitrate = m.get('AudioBitrate')
        if m.get('AudioChannelNum') is not None:
            self.audio_channel_num = m.get('AudioChannelNum')
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('AudioProfile') is not None:
            self.audio_profile = m.get('AudioProfile')
        if m.get('AudioRate') is not None:
            self.audio_rate = m.get('AudioRate')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EncryptParameters') is not None:
            self.encrypt_parameters = m.get('EncryptParameters')
        if m.get('FPS') is not None:
            self.fps = m.get('FPS')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('KmsKeyExpireInterval') is not None:
            self.kms_key_expire_interval = m.get('KmsKeyExpireInterval')
        if m.get('KmsKeyID') is not None:
            self.kms_key_id = m.get('KmsKeyID')
        if m.get('KmsUID') is not None:
            self.kms_uid = m.get('KmsUID')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddCustomLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddCustomLiveStreamTranscodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCustomLiveStreamTranscodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddCustomLiveStreamTranscodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddCustomLiveStreamTranscodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCustomLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAppRecordConfigRequestRecordFormat(TeaModel):
    def __init__(self, cycle_duration=None, format=None, oss_object_prefix=None, slice_duration=None,
                 slice_oss_object_prefix=None):
        self.cycle_duration = cycle_duration  # type: int
        self.format = format  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.slice_duration = slice_duration  # type: int
        self.slice_oss_object_prefix = slice_oss_object_prefix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAppRecordConfigRequestRecordFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class AddLiveAppRecordConfigRequestTranscodeRecordFormat(TeaModel):
    def __init__(self, cycle_duration=None, format=None, oss_object_prefix=None, slice_duration=None,
                 slice_oss_object_prefix=None):
        self.cycle_duration = cycle_duration  # type: int
        self.format = format  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.slice_duration = slice_duration  # type: int
        self.slice_oss_object_prefix = slice_oss_object_prefix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAppRecordConfigRequestTranscodeRecordFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class AddLiveAppRecordConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, on_demand=None, oss_bucket=None,
                 oss_endpoint=None, owner_id=None, record_format=None, security_token=None, start_time=None, stream_name=None,
                 transcode_record_format=None, transcode_templates=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.on_demand = on_demand  # type: int
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.owner_id = owner_id  # type: long
        self.record_format = record_format  # type: list[AddLiveAppRecordConfigRequestRecordFormat]
        self.security_token = security_token  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str
        self.transcode_record_format = transcode_record_format  # type: list[AddLiveAppRecordConfigRequestTranscodeRecordFormat]
        self.transcode_templates = transcode_templates  # type: list[str]

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()
        if self.transcode_record_format:
            for k in self.transcode_record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddLiveAppRecordConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.on_demand is not None:
            result['OnDemand'] = self.on_demand
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        result['TranscodeRecordFormat'] = []
        if self.transcode_record_format is not None:
            for k in self.transcode_record_format:
                result['TranscodeRecordFormat'].append(k.to_map() if k else None)
        if self.transcode_templates is not None:
            result['TranscodeTemplates'] = self.transcode_templates
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OnDemand') is not None:
            self.on_demand = m.get('OnDemand')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = AddLiveAppRecordConfigRequestRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        self.transcode_record_format = []
        if m.get('TranscodeRecordFormat') is not None:
            for k in m.get('TranscodeRecordFormat'):
                temp_model = AddLiveAppRecordConfigRequestTranscodeRecordFormat()
                self.transcode_record_format.append(temp_model.from_map(k))
        if m.get('TranscodeTemplates') is not None:
            self.transcode_templates = m.get('TranscodeTemplates')
        return self


class AddLiveAppRecordConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAppRecordConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAppRecordConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveAppRecordConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveAppRecordConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAppRecordConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAppSnapshotConfigRequest(TeaModel):
    def __init__(self, app_name=None, callback=None, domain_name=None, oss_bucket=None, oss_endpoint=None,
                 overwrite_oss_object=None, owner_id=None, security_token=None, sequence_oss_object=None, time_interval=None):
        self.app_name = app_name  # type: str
        self.callback = callback  # type: str
        self.domain_name = domain_name  # type: str
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.overwrite_oss_object = overwrite_oss_object  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.sequence_oss_object = sequence_oss_object  # type: str
        self.time_interval = time_interval  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAppSnapshotConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.callback is not None:
            result['Callback'] = self.callback
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.overwrite_oss_object is not None:
            result['OverwriteOssObject'] = self.overwrite_oss_object
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.sequence_oss_object is not None:
            result['SequenceOssObject'] = self.sequence_oss_object
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OverwriteOssObject') is not None:
            self.overwrite_oss_object = m.get('OverwriteOssObject')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('SequenceOssObject') is not None:
            self.sequence_oss_object = m.get('SequenceOssObject')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        return self


class AddLiveAppSnapshotConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAppSnapshotConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAppSnapshotConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveAppSnapshotConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveAppSnapshotConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAppSnapshotConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAudioAuditConfigRequest(TeaModel):
    def __init__(self, app_name=None, biz_type=None, domain_name=None, oss_bucket=None, oss_endpoint=None,
                 oss_object=None, owner_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.biz_type = biz_type  # type: str
        self.domain_name = domain_name  # type: str
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str
        self.owner_id = owner_id  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAudioAuditConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAudioAuditConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAudioAuditConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveAudioAuditConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveAudioAuditConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAudioAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveAudioAuditNotifyConfigRequest(TeaModel):
    def __init__(self, callback=None, callback_template=None, domain_name=None, owner_id=None):
        self.callback = callback  # type: str
        self.callback_template = callback_template  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAudioAuditNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback is not None:
            result['Callback'] = self.callback
        if self.callback_template is not None:
            result['CallbackTemplate'] = self.callback_template
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        if m.get('CallbackTemplate') is not None:
            self.callback_template = m.get('CallbackTemplate')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class AddLiveAudioAuditNotifyConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveAudioAuditNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveAudioAuditNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveAudioAuditNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveAudioAuditNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveAudioAuditNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDetectNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, notify_url=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.notify_url = notify_url  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveDetectNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class AddLiveDetectNotifyConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveDetectNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDetectNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveDetectNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveDetectNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveDetectNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainRequest(TeaModel):
    def __init__(self, check_url=None, domain_name=None, live_domain_type=None, owner_account=None, owner_id=None,
                 region=None, scope=None, security_token=None, top_level_domain=None):
        self.check_url = check_url  # type: str
        self.domain_name = domain_name  # type: str
        self.live_domain_type = live_domain_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region = region  # type: str
        self.scope = scope  # type: str
        self.security_token = security_token  # type: str
        self.top_level_domain = top_level_domain  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_url is not None:
            result['CheckUrl'] = self.check_url
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.live_domain_type is not None:
            result['LiveDomainType'] = self.live_domain_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.top_level_domain is not None:
            result['TopLevelDomain'] = self.top_level_domain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckUrl') is not None:
            self.check_url = m.get('CheckUrl')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LiveDomainType') is not None:
            self.live_domain_type = m.get('LiveDomainType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('TopLevelDomain') is not None:
            self.top_level_domain = m.get('TopLevelDomain')
        return self


class AddLiveDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainMappingRequest(TeaModel):
    def __init__(self, owner_id=None, pull_domain=None, push_domain=None, security_token=None):
        self.owner_id = owner_id  # type: long
        self.pull_domain = pull_domain  # type: str
        self.push_domain = push_domain  # type: str
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveDomainMappingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        if self.push_domain is not None:
            result['PushDomain'] = self.push_domain
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        if m.get('PushDomain') is not None:
            self.push_domain = m.get('PushDomain')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class AddLiveDomainMappingResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveDomainMappingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainMappingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveDomainMappingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveDomainMappingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveDomainMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveDomainPlayMappingRequest(TeaModel):
    def __init__(self, owner_id=None, play_domain=None, pull_domain=None):
        self.owner_id = owner_id  # type: long
        self.play_domain = play_domain  # type: str
        self.pull_domain = pull_domain  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveDomainPlayMappingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.play_domain is not None:
            result['PlayDomain'] = self.play_domain
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlayDomain') is not None:
            self.play_domain = m.get('PlayDomain')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        return self


class AddLiveDomainPlayMappingResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveDomainPlayMappingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveDomainPlayMappingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveDomainPlayMappingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveDomainPlayMappingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveDomainPlayMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLivePullStreamInfoConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, owner_id=None, source_url=None,
                 start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.source_url = source_url  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLivePullStreamInfoConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.source_url is not None:
            result['SourceUrl'] = self.source_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SourceUrl') is not None:
            self.source_url = m.get('SourceUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class AddLivePullStreamInfoConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLivePullStreamInfoConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLivePullStreamInfoConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLivePullStreamInfoConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLivePullStreamInfoConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLivePullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveRecordNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, need_status_notify=None, notify_url=None, on_demand_url=None,
                 owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.need_status_notify = need_status_notify  # type: bool
        self.notify_url = notify_url  # type: str
        self.on_demand_url = on_demand_url  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveRecordNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.need_status_notify is not None:
            result['NeedStatusNotify'] = self.need_status_notify
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.on_demand_url is not None:
            result['OnDemandUrl'] = self.on_demand_url
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NeedStatusNotify') is not None:
            self.need_status_notify = m.get('NeedStatusNotify')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('OnDemandUrl') is not None:
            self.on_demand_url = m.get('OnDemandUrl')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class AddLiveRecordNotifyConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveRecordNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveRecordNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveRecordNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveRecordNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveRecordNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveRecordVodConfigRequest(TeaModel):
    def __init__(self, app_name=None, auto_compose=None, compose_vod_transcode_group_id=None, cycle_duration=None,
                 domain_name=None, owner_id=None, storage_location=None, stream_name=None, vod_transcode_group_id=None):
        self.app_name = app_name  # type: str
        self.auto_compose = auto_compose  # type: str
        self.compose_vod_transcode_group_id = compose_vod_transcode_group_id  # type: str
        self.cycle_duration = cycle_duration  # type: int
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.storage_location = storage_location  # type: str
        self.stream_name = stream_name  # type: str
        self.vod_transcode_group_id = vod_transcode_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveRecordVodConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.auto_compose is not None:
            result['AutoCompose'] = self.auto_compose
        if self.compose_vod_transcode_group_id is not None:
            result['ComposeVodTranscodeGroupId'] = self.compose_vod_transcode_group_id
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.storage_location is not None:
            result['StorageLocation'] = self.storage_location
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.vod_transcode_group_id is not None:
            result['VodTranscodeGroupId'] = self.vod_transcode_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AutoCompose') is not None:
            self.auto_compose = m.get('AutoCompose')
        if m.get('ComposeVodTranscodeGroupId') is not None:
            self.compose_vod_transcode_group_id = m.get('ComposeVodTranscodeGroupId')
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StorageLocation') is not None:
            self.storage_location = m.get('StorageLocation')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('VodTranscodeGroupId') is not None:
            self.vod_transcode_group_id = m.get('VodTranscodeGroupId')
        return self


class AddLiveRecordVodConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveRecordVodConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveRecordVodConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveRecordVodConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveRecordVodConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveRecordVodConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveSnapshotDetectPornConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, interval=None, oss_bucket=None, oss_endpoint=None,
                 oss_object=None, owner_id=None, scene=None, security_token=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.interval = interval  # type: int
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str
        self.owner_id = owner_id  # type: long
        self.scene = scene  # type: list[str]
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveSnapshotDetectPornConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class AddLiveSnapshotDetectPornConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveSnapshotDetectPornConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveSnapshotDetectPornConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveSnapshotDetectPornConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveSnapshotDetectPornConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveSnapshotDetectPornConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveSnapshotNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, notify_auth_key=None, notify_req_auth=None, notify_url=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.notify_auth_key = notify_auth_key  # type: str
        self.notify_req_auth = notify_req_auth  # type: str
        self.notify_url = notify_url  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveSnapshotNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_auth_key is not None:
            result['NotifyAuthKey'] = self.notify_auth_key
        if self.notify_req_auth is not None:
            result['NotifyReqAuth'] = self.notify_req_auth
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyAuthKey') is not None:
            self.notify_auth_key = m.get('NotifyAuthKey')
        if m.get('NotifyReqAuth') is not None:
            self.notify_req_auth = m.get('NotifyReqAuth')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class AddLiveSnapshotNotifyConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveSnapshotNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveSnapshotNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveSnapshotNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveSnapshotNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveSnapshotNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveStreamTranscodeRequest(TeaModel):
    def __init__(self, app=None, domain=None, encrypt_parameters=None, lazy=None, owner_id=None, template=None):
        self.app = app  # type: str
        self.domain = domain  # type: str
        self.encrypt_parameters = encrypt_parameters  # type: str
        self.lazy = lazy  # type: str
        self.owner_id = owner_id  # type: long
        self.template = template  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveStreamTranscodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.encrypt_parameters is not None:
            result['EncryptParameters'] = self.encrypt_parameters
        if self.lazy is not None:
            result['Lazy'] = self.lazy
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EncryptParameters') is not None:
            self.encrypt_parameters = m.get('EncryptParameters')
        if m.get('Lazy') is not None:
            self.lazy = m.get('Lazy')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class AddLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveStreamTranscodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddLiveStreamTranscodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveStreamTranscodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveStreamTranscodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveStreamWatermarkRequest(TeaModel):
    def __init__(self, description=None, height=None, name=None, offset_corner=None, owner_id=None, picture_url=None,
                 ref_height=None, ref_width=None, transparency=None, type=None, xoffset=None, yoffset=None):
        self.description = description  # type: str
        self.height = height  # type: int
        self.name = name  # type: str
        self.offset_corner = offset_corner  # type: str
        self.owner_id = owner_id  # type: long
        self.picture_url = picture_url  # type: str
        self.ref_height = ref_height  # type: int
        self.ref_width = ref_width  # type: int
        self.transparency = transparency  # type: int
        self.type = type  # type: int
        self.xoffset = xoffset  # type: float
        self.yoffset = yoffset  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveStreamWatermarkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.height is not None:
            result['Height'] = self.height
        if self.name is not None:
            result['Name'] = self.name
        if self.offset_corner is not None:
            result['OffsetCorner'] = self.offset_corner
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.picture_url is not None:
            result['PictureUrl'] = self.picture_url
        if self.ref_height is not None:
            result['RefHeight'] = self.ref_height
        if self.ref_width is not None:
            result['RefWidth'] = self.ref_width
        if self.transparency is not None:
            result['Transparency'] = self.transparency
        if self.type is not None:
            result['Type'] = self.type
        if self.xoffset is not None:
            result['XOffset'] = self.xoffset
        if self.yoffset is not None:
            result['YOffset'] = self.yoffset
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OffsetCorner') is not None:
            self.offset_corner = m.get('OffsetCorner')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PictureUrl') is not None:
            self.picture_url = m.get('PictureUrl')
        if m.get('RefHeight') is not None:
            self.ref_height = m.get('RefHeight')
        if m.get('RefWidth') is not None:
            self.ref_width = m.get('RefWidth')
        if m.get('Transparency') is not None:
            self.transparency = m.get('Transparency')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('XOffset') is not None:
            self.xoffset = m.get('XOffset')
        if m.get('YOffset') is not None:
            self.yoffset = m.get('YOffset')
        return self


class AddLiveStreamWatermarkResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        self.request_id = request_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveStreamWatermarkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class AddLiveStreamWatermarkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveStreamWatermarkResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveStreamWatermarkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveStreamWatermarkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddLiveStreamWatermarkRuleRequest(TeaModel):
    def __init__(self, app=None, description=None, domain=None, name=None, owner_id=None, stream=None,
                 template_id=None):
        self.app = app  # type: str
        self.description = description  # type: str
        self.domain = domain  # type: str
        self.name = name  # type: str
        self.owner_id = owner_id  # type: long
        self.stream = stream  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveStreamWatermarkRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream is not None:
            result['Stream'] = self.stream
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class AddLiveStreamWatermarkRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, rule_id=None):
        self.request_id = request_id  # type: str
        self.rule_id = rule_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddLiveStreamWatermarkRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class AddLiveStreamWatermarkRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddLiveStreamWatermarkRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddLiveStreamWatermarkRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddLiveStreamWatermarkRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddMultiRateConfigRequest(TeaModel):
    def __init__(self, app=None, av_format=None, domain_name=None, group_id=None, is_lazy=None, is_time_align=None,
                 owner_id=None, templates=None):
        self.app = app  # type: str
        self.av_format = av_format  # type: str
        self.domain_name = domain_name  # type: str
        self.group_id = group_id  # type: str
        self.is_lazy = is_lazy  # type: str
        self.is_time_align = is_time_align  # type: str
        self.owner_id = owner_id  # type: long
        self.templates = templates  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMultiRateConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.av_format is not None:
            result['AvFormat'] = self.av_format
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.is_lazy is not None:
            result['IsLazy'] = self.is_lazy
        if self.is_time_align is not None:
            result['IsTimeAlign'] = self.is_time_align
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.templates is not None:
            result['Templates'] = self.templates
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('AvFormat') is not None:
            self.av_format = m.get('AvFormat')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('IsLazy') is not None:
            self.is_lazy = m.get('IsLazy')
        if m.get('IsTimeAlign') is not None:
            self.is_time_align = m.get('IsTimeAlign')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Templates') is not None:
            self.templates = m.get('Templates')
        return self


class AddMultiRateConfigResponseBodyBodyFailedTemplates(TeaModel):
    def __init__(self, audio_bitrate=None, audio_channel_num=None, audio_codec=None, audio_profile=None,
                 audio_rate=None, band_width=None, fps=None, gop=None, height=None, profile=None, template=None,
                 template_type=None, video_bitrate=None, width=None):
        self.audio_bitrate = audio_bitrate  # type: int
        self.audio_channel_num = audio_channel_num  # type: int
        self.audio_codec = audio_codec  # type: str
        self.audio_profile = audio_profile  # type: str
        self.audio_rate = audio_rate  # type: int
        self.band_width = band_width  # type: int
        self.fps = fps  # type: int
        self.gop = gop  # type: str
        self.height = height  # type: int
        self.profile = profile  # type: int
        self.template = template  # type: str
        self.template_type = template_type  # type: str
        self.video_bitrate = video_bitrate  # type: int
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddMultiRateConfigResponseBodyBodyFailedTemplates, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_bitrate is not None:
            result['AudioBitrate'] = self.audio_bitrate
        if self.audio_channel_num is not None:
            result['AudioChannelNum'] = self.audio_channel_num
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.audio_profile is not None:
            result['AudioProfile'] = self.audio_profile
        if self.audio_rate is not None:
            result['AudioRate'] = self.audio_rate
        if self.band_width is not None:
            result['BandWidth'] = self.band_width
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.template is not None:
            result['Template'] = self.template
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioBitrate') is not None:
            self.audio_bitrate = m.get('AudioBitrate')
        if m.get('AudioChannelNum') is not None:
            self.audio_channel_num = m.get('AudioChannelNum')
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('AudioProfile') is not None:
            self.audio_profile = m.get('AudioProfile')
        if m.get('AudioRate') is not None:
            self.audio_rate = m.get('AudioRate')
        if m.get('BandWidth') is not None:
            self.band_width = m.get('BandWidth')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddMultiRateConfigResponseBodyBody(TeaModel):
    def __init__(self, failed_templates=None):
        self.failed_templates = failed_templates  # type: list[AddMultiRateConfigResponseBodyBodyFailedTemplates]

    def validate(self):
        if self.failed_templates:
            for k in self.failed_templates:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddMultiRateConfigResponseBodyBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailedTemplates'] = []
        if self.failed_templates is not None:
            for k in self.failed_templates:
                result['FailedTemplates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.failed_templates = []
        if m.get('FailedTemplates') is not None:
            for k in m.get('FailedTemplates'):
                temp_model = AddMultiRateConfigResponseBodyBodyFailedTemplates()
                self.failed_templates.append(temp_model.from_map(k))
        return self


class AddMultiRateConfigResponseBody(TeaModel):
    def __init__(self, body=None, code=None, message=None, request_id=None):
        self.body = body  # type: AddMultiRateConfigResponseBodyBody
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddMultiRateConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.body is not None:
            result['Body'] = self.body.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Body') is not None:
            temp_model = AddMultiRateConfigResponseBodyBody()
            self.body = temp_model.from_map(m['Body'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddMultiRateConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddMultiRateConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddMultiRateConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddMultiRateConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPlaylistItemsRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None, program_config=None, program_id=None, program_items=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long
        self.program_config = program_config  # type: str
        self.program_id = program_id  # type: str
        self.program_items = program_items  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPlaylistItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_config is not None:
            result['ProgramConfig'] = self.program_config
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.program_items is not None:
            result['ProgramItems'] = self.program_items
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramConfig') is not None:
            self.program_config = m.get('ProgramConfig')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('ProgramItems') is not None:
            self.program_items = m.get('ProgramItems')
        return self


class AddPlaylistItemsResponseBodyItemsFailedItems(TeaModel):
    def __init__(self, item_id=None, item_name=None):
        self.item_id = item_id  # type: str
        self.item_name = item_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPlaylistItemsResponseBodyItemsFailedItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        return self


class AddPlaylistItemsResponseBodyItemsSuccessItems(TeaModel):
    def __init__(self, item_id=None, item_name=None):
        self.item_id = item_id  # type: str
        self.item_name = item_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddPlaylistItemsResponseBodyItemsSuccessItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        return self


class AddPlaylistItemsResponseBodyItems(TeaModel):
    def __init__(self, failed_items=None, success_items=None):
        self.failed_items = failed_items  # type: list[AddPlaylistItemsResponseBodyItemsFailedItems]
        self.success_items = success_items  # type: list[AddPlaylistItemsResponseBodyItemsSuccessItems]

    def validate(self):
        if self.failed_items:
            for k in self.failed_items:
                if k:
                    k.validate()
        if self.success_items:
            for k in self.success_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddPlaylistItemsResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailedItems'] = []
        if self.failed_items is not None:
            for k in self.failed_items:
                result['FailedItems'].append(k.to_map() if k else None)
        result['SuccessItems'] = []
        if self.success_items is not None:
            for k in self.success_items:
                result['SuccessItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.failed_items = []
        if m.get('FailedItems') is not None:
            for k in m.get('FailedItems'):
                temp_model = AddPlaylistItemsResponseBodyItemsFailedItems()
                self.failed_items.append(temp_model.from_map(k))
        self.success_items = []
        if m.get('SuccessItems') is not None:
            for k in m.get('SuccessItems'):
                temp_model = AddPlaylistItemsResponseBodyItemsSuccessItems()
                self.success_items.append(temp_model.from_map(k))
        return self


class AddPlaylistItemsResponseBody(TeaModel):
    def __init__(self, items=None, program_id=None, request_id=None):
        self.items = items  # type: AddPlaylistItemsResponseBodyItems
        self.program_id = program_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(AddPlaylistItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = AddPlaylistItemsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPlaylistItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddPlaylistItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddPlaylistItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPlaylistItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddRtsLiveStreamTranscodeRequest(TeaModel):
    def __init__(self, app=None, audio_bitrate=None, audio_channel_num=None, audio_codec=None, audio_profile=None,
                 audio_rate=None, delete_bframes=None, domain=None, fps=None, gop=None, height=None, lazy=None, opus=None,
                 owner_id=None, profile=None, template=None, template_type=None, video_bitrate=None, width=None):
        self.app = app  # type: str
        self.audio_bitrate = audio_bitrate  # type: int
        self.audio_channel_num = audio_channel_num  # type: int
        self.audio_codec = audio_codec  # type: str
        self.audio_profile = audio_profile  # type: str
        self.audio_rate = audio_rate  # type: int
        self.delete_bframes = delete_bframes  # type: bool
        self.domain = domain  # type: str
        self.fps = fps  # type: int
        self.gop = gop  # type: str
        self.height = height  # type: int
        self.lazy = lazy  # type: str
        self.opus = opus  # type: bool
        self.owner_id = owner_id  # type: long
        self.profile = profile  # type: int
        self.template = template  # type: str
        self.template_type = template_type  # type: str
        self.video_bitrate = video_bitrate  # type: int
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddRtsLiveStreamTranscodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.audio_bitrate is not None:
            result['AudioBitrate'] = self.audio_bitrate
        if self.audio_channel_num is not None:
            result['AudioChannelNum'] = self.audio_channel_num
        if self.audio_codec is not None:
            result['AudioCodec'] = self.audio_codec
        if self.audio_profile is not None:
            result['AudioProfile'] = self.audio_profile
        if self.audio_rate is not None:
            result['AudioRate'] = self.audio_rate
        if self.delete_bframes is not None:
            result['DeleteBframes'] = self.delete_bframes
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.fps is not None:
            result['FPS'] = self.fps
        if self.gop is not None:
            result['Gop'] = self.gop
        if self.height is not None:
            result['Height'] = self.height
        if self.lazy is not None:
            result['Lazy'] = self.lazy
        if self.opus is not None:
            result['Opus'] = self.opus
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.template is not None:
            result['Template'] = self.template
        if self.template_type is not None:
            result['TemplateType'] = self.template_type
        if self.video_bitrate is not None:
            result['VideoBitrate'] = self.video_bitrate
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('AudioBitrate') is not None:
            self.audio_bitrate = m.get('AudioBitrate')
        if m.get('AudioChannelNum') is not None:
            self.audio_channel_num = m.get('AudioChannelNum')
        if m.get('AudioCodec') is not None:
            self.audio_codec = m.get('AudioCodec')
        if m.get('AudioProfile') is not None:
            self.audio_profile = m.get('AudioProfile')
        if m.get('AudioRate') is not None:
            self.audio_rate = m.get('AudioRate')
        if m.get('DeleteBframes') is not None:
            self.delete_bframes = m.get('DeleteBframes')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('FPS') is not None:
            self.fps = m.get('FPS')
        if m.get('Gop') is not None:
            self.gop = m.get('Gop')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('Lazy') is not None:
            self.lazy = m.get('Lazy')
        if m.get('Opus') is not None:
            self.opus = m.get('Opus')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        if m.get('TemplateType') is not None:
            self.template_type = m.get('TemplateType')
        if m.get('VideoBitrate') is not None:
            self.video_bitrate = m.get('VideoBitrate')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class AddRtsLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddRtsLiveStreamTranscodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddRtsLiveStreamTranscodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddRtsLiveStreamTranscodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddRtsLiveStreamTranscodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddRtsLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddShowIntoShowListRequestShowList(TeaModel):
    def __init__(self, duration=None, live_input_type=None, repeat_times=None, resource_id=None, resource_type=None,
                 resource_url=None, show_name=None):
        self.duration = duration  # type: long
        self.live_input_type = live_input_type  # type: int
        self.repeat_times = repeat_times  # type: int
        self.resource_id = resource_id  # type: str
        self.resource_type = resource_type  # type: str
        self.resource_url = resource_url  # type: str
        self.show_name = show_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddShowIntoShowListRequestShowList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['duration'] = self.duration
        if self.live_input_type is not None:
            result['liveInputType'] = self.live_input_type
        if self.repeat_times is not None:
            result['repeatTimes'] = self.repeat_times
        if self.resource_id is not None:
            result['resourceId'] = self.resource_id
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.resource_url is not None:
            result['resourceUrl'] = self.resource_url
        if self.show_name is not None:
            result['showName'] = self.show_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('duration') is not None:
            self.duration = m.get('duration')
        if m.get('liveInputType') is not None:
            self.live_input_type = m.get('liveInputType')
        if m.get('repeatTimes') is not None:
            self.repeat_times = m.get('repeatTimes')
        if m.get('resourceId') is not None:
            self.resource_id = m.get('resourceId')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('resourceUrl') is not None:
            self.resource_url = m.get('resourceUrl')
        if m.get('showName') is not None:
            self.show_name = m.get('showName')
        return self


class AddShowIntoShowListRequest(TeaModel):
    def __init__(self, caster_id=None, duration=None, live_input_type=None, owner_id=None, repeat_times=None,
                 resource_id=None, resource_type=None, resource_url=None, show_name=None, spot=None, is_batch_mode=None,
                 show_list=None):
        self.caster_id = caster_id  # type: str
        self.duration = duration  # type: long
        self.live_input_type = live_input_type  # type: int
        self.owner_id = owner_id  # type: long
        self.repeat_times = repeat_times  # type: int
        self.resource_id = resource_id  # type: str
        self.resource_type = resource_type  # type: str
        self.resource_url = resource_url  # type: str
        self.show_name = show_name  # type: str
        self.spot = spot  # type: int
        self.is_batch_mode = is_batch_mode  # type: bool
        self.show_list = show_list  # type: list[AddShowIntoShowListRequestShowList]

    def validate(self):
        if self.show_list:
            for k in self.show_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddShowIntoShowListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.live_input_type is not None:
            result['LiveInputType'] = self.live_input_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.repeat_times is not None:
            result['RepeatTimes'] = self.repeat_times
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_url is not None:
            result['ResourceUrl'] = self.resource_url
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        if self.spot is not None:
            result['Spot'] = self.spot
        if self.is_batch_mode is not None:
            result['isBatchMode'] = self.is_batch_mode
        result['showList'] = []
        if self.show_list is not None:
            for k in self.show_list:
                result['showList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('LiveInputType') is not None:
            self.live_input_type = m.get('LiveInputType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RepeatTimes') is not None:
            self.repeat_times = m.get('RepeatTimes')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceUrl') is not None:
            self.resource_url = m.get('ResourceUrl')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        if m.get('Spot') is not None:
            self.spot = m.get('Spot')
        if m.get('isBatchMode') is not None:
            self.is_batch_mode = m.get('isBatchMode')
        self.show_list = []
        if m.get('showList') is not None:
            for k in m.get('showList'):
                temp_model = AddShowIntoShowListRequestShowList()
                self.show_list.append(temp_model.from_map(k))
        return self


class AddShowIntoShowListResponseBody(TeaModel):
    def __init__(self, request_id=None, show_id=None, failed_list=None, successful_show_ids=None):
        self.request_id = request_id  # type: str
        self.show_id = show_id  # type: str
        self.failed_list = failed_list  # type: str
        self.successful_show_ids = successful_show_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddShowIntoShowListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.show_id is not None:
            result['ShowId'] = self.show_id
        if self.failed_list is not None:
            result['failedList'] = self.failed_list
        if self.successful_show_ids is not None:
            result['successfulShowIds'] = self.successful_show_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ShowId') is not None:
            self.show_id = m.get('ShowId')
        if m.get('failedList') is not None:
            self.failed_list = m.get('failedList')
        if m.get('successfulShowIds') is not None:
            self.successful_show_ids = m.get('successfulShowIds')
        return self


class AddShowIntoShowListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddShowIntoShowListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddShowIntoShowListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddShowIntoShowListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddStudioLayoutRequest(TeaModel):
    def __init__(self, bg_image_config=None, caster_id=None, common_config=None, layer_order_config_list=None,
                 layout_name=None, layout_type=None, media_input_config_list=None, owner_id=None,
                 screen_input_config_list=None):
        self.bg_image_config = bg_image_config  # type: str
        self.caster_id = caster_id  # type: str
        self.common_config = common_config  # type: str
        self.layer_order_config_list = layer_order_config_list  # type: str
        self.layout_name = layout_name  # type: str
        self.layout_type = layout_type  # type: str
        self.media_input_config_list = media_input_config_list  # type: str
        self.owner_id = owner_id  # type: long
        self.screen_input_config_list = screen_input_config_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddStudioLayoutRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bg_image_config is not None:
            result['BgImageConfig'] = self.bg_image_config
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.common_config is not None:
            result['CommonConfig'] = self.common_config
        if self.layer_order_config_list is not None:
            result['LayerOrderConfigList'] = self.layer_order_config_list
        if self.layout_name is not None:
            result['LayoutName'] = self.layout_name
        if self.layout_type is not None:
            result['LayoutType'] = self.layout_type
        if self.media_input_config_list is not None:
            result['MediaInputConfigList'] = self.media_input_config_list
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.screen_input_config_list is not None:
            result['ScreenInputConfigList'] = self.screen_input_config_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BgImageConfig') is not None:
            self.bg_image_config = m.get('BgImageConfig')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CommonConfig') is not None:
            self.common_config = m.get('CommonConfig')
        if m.get('LayerOrderConfigList') is not None:
            self.layer_order_config_list = m.get('LayerOrderConfigList')
        if m.get('LayoutName') is not None:
            self.layout_name = m.get('LayoutName')
        if m.get('LayoutType') is not None:
            self.layout_type = m.get('LayoutType')
        if m.get('MediaInputConfigList') is not None:
            self.media_input_config_list = m.get('MediaInputConfigList')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ScreenInputConfigList') is not None:
            self.screen_input_config_list = m.get('ScreenInputConfigList')
        return self


class AddStudioLayoutResponseBody(TeaModel):
    def __init__(self, layout_id=None, request_id=None):
        self.layout_id = layout_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddStudioLayoutResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddStudioLayoutResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddStudioLayoutResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddStudioLayoutResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddStudioLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTrancodeSEIRequest(TeaModel):
    def __init__(self, app_name=None, delay=None, domain_name=None, owner_id=None, pattern=None, repeat=None,
                 stream_name=None, text=None):
        self.app_name = app_name  # type: str
        self.delay = delay  # type: int
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.pattern = pattern  # type: str
        self.repeat = repeat  # type: int
        self.stream_name = stream_name  # type: str
        self.text = text  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTrancodeSEIRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pattern is not None:
            result['Pattern'] = self.pattern
        if self.repeat is not None:
            result['Repeat'] = self.repeat
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Pattern') is not None:
            self.pattern = m.get('Pattern')
        if m.get('Repeat') is not None:
            self.repeat = m.get('Repeat')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class AddTrancodeSEIResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTrancodeSEIResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTrancodeSEIResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTrancodeSEIResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTrancodeSEIResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTrancodeSEIResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllowPushStreamRequest(TeaModel):
    def __init__(self, app_id=None, owner_id=None, room_id=None):
        self.app_id = app_id  # type: str
        self.owner_id = owner_id  # type: long
        self.room_id = room_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllowPushStreamRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class AllowPushStreamResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllowPushStreamResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllowPushStreamResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AllowPushStreamResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AllowPushStreamResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllowPushStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteLiveDomainConfigsRequest(TeaModel):
    def __init__(self, domain_names=None, function_names=None, owner_account=None, owner_id=None,
                 security_token=None):
        self.domain_names = domain_names  # type: str
        self.function_names = function_names  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteLiveDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchDeleteLiveDomainConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchDeleteLiveDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchDeleteLiveDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchDeleteLiveDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchDeleteLiveDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteLiveDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetLiveDomainConfigsRequest(TeaModel):
    def __init__(self, domain_names=None, functions=None, owner_account=None, owner_id=None, security_token=None):
        self.domain_names = domain_names  # type: str
        self.functions = functions  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetLiveDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.functions is not None:
            result['Functions'] = self.functions
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('Functions') is not None:
            self.functions = m.get('Functions')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class BatchSetLiveDomainConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchSetLiveDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchSetLiveDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchSetLiveDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchSetLiveDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchSetLiveDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelMuteAllGroupUserRequest(TeaModel):
    def __init__(self, app_id=None, group_id=None, operator_user_id=None):
        self.app_id = app_id  # type: str
        self.group_id = group_id  # type: str
        self.operator_user_id = operator_user_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelMuteAllGroupUserRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.operator_user_id is not None:
            result['OperatorUserId'] = self.operator_user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OperatorUserId') is not None:
            self.operator_user_id = m.get('OperatorUserId')
        return self


class CancelMuteAllGroupUserResponseBodyResult(TeaModel):
    def __init__(self, success=None):
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelMuteAllGroupUserResponseBodyResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelMuteAllGroupUserResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: CancelMuteAllGroupUserResponseBodyResult

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super(CancelMuteAllGroupUserResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CancelMuteAllGroupUserResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CancelMuteAllGroupUserResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelMuteAllGroupUserResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelMuteAllGroupUserResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelMuteAllGroupUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseLiveShiftRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloseLiveShiftRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class CloseLiveShiftResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CloseLiveShiftResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloseLiveShiftResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CloseLiveShiftResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CloseLiveShiftResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CloseLiveShiftResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCasterRequest(TeaModel):
    def __init__(self, caster_name=None, client_token=None, owner_id=None, src_caster_id=None):
        self.caster_name = caster_name  # type: str
        self.client_token = client_token  # type: str
        self.owner_id = owner_id  # type: long
        self.src_caster_id = src_caster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyCasterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.src_caster_id is not None:
            result['SrcCasterId'] = self.src_caster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SrcCasterId') is not None:
            self.src_caster_id = m.get('SrcCasterId')
        return self


class CopyCasterResponseBody(TeaModel):
    def __init__(self, caster_id=None, request_id=None):
        self.caster_id = caster_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyCasterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyCasterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CopyCasterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CopyCasterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyCasterSceneConfigRequest(TeaModel):
    def __init__(self, caster_id=None, from_scene_id=None, owner_id=None, to_scene_id=None):
        self.caster_id = caster_id  # type: str
        self.from_scene_id = from_scene_id  # type: str
        self.owner_id = owner_id  # type: long
        self.to_scene_id = to_scene_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyCasterSceneConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.from_scene_id is not None:
            result['FromSceneId'] = self.from_scene_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.to_scene_id is not None:
            result['ToSceneId'] = self.to_scene_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('FromSceneId') is not None:
            self.from_scene_id = m.get('FromSceneId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ToSceneId') is not None:
            self.to_scene_id = m.get('ToSceneId')
        return self


class CopyCasterSceneConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyCasterSceneConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyCasterSceneConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CopyCasterSceneConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CopyCasterSceneConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyCasterSceneConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCasterRequest(TeaModel):
    def __init__(self, caster_name=None, caster_template=None, charge_type=None, client_token=None,
                 expire_time=None, norm_type=None, owner_id=None, purchase_time=None):
        self.caster_name = caster_name  # type: str
        self.caster_template = caster_template  # type: str
        self.charge_type = charge_type  # type: str
        self.client_token = client_token  # type: str
        self.expire_time = expire_time  # type: str
        self.norm_type = norm_type  # type: int
        self.owner_id = owner_id  # type: long
        self.purchase_time = purchase_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCasterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.norm_type is not None:
            result['NormType'] = self.norm_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.purchase_time is not None:
            result['PurchaseTime'] = self.purchase_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('NormType') is not None:
            self.norm_type = m.get('NormType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PurchaseTime') is not None:
            self.purchase_time = m.get('PurchaseTime')
        return self


class CreateCasterResponseBody(TeaModel):
    def __init__(self, caster_id=None, request_id=None):
        self.caster_id = caster_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCasterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCasterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCasterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCasterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomTemplateRequest(TeaModel):
    def __init__(self, custom_template=None, owner_id=None, template=None):
        self.custom_template = custom_template  # type: str
        self.owner_id = owner_id  # type: long
        self.template = template  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_template is not None:
            result['CustomTemplate'] = self.custom_template
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomTemplate') is not None:
            self.custom_template = m.get('CustomTemplate')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class CreateCustomTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCustomTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveRealTimeLogDeliveryRequest(TeaModel):
    def __init__(self, domain_name=None, logstore=None, owner_id=None, project=None, region=None):
        self.domain_name = domain_name  # type: str
        self.logstore = logstore  # type: str
        self.owner_id = owner_id  # type: long
        self.project = project  # type: str
        self.region = region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveRealTimeLogDeliveryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class CreateLiveRealTimeLogDeliveryResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveRealTimeLogDeliveryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveRealTimeLogDeliveryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLiveRealTimeLogDeliveryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLiveRealTimeLogDeliveryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveRealTimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveStreamMonitorRequest(TeaModel):
    def __init__(self, app=None, domain=None, input_list=None, monitor_name=None, output_template=None,
                 owner_id=None, stream=None):
        self.app = app  # type: str
        self.domain = domain  # type: str
        self.input_list = input_list  # type: str
        self.monitor_name = monitor_name  # type: str
        self.output_template = output_template  # type: str
        self.owner_id = owner_id  # type: long
        self.stream = stream  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveStreamMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.input_list is not None:
            result['InputList'] = self.input_list
        if self.monitor_name is not None:
            result['MonitorName'] = self.monitor_name
        if self.output_template is not None:
            result['OutputTemplate'] = self.output_template
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream is not None:
            result['Stream'] = self.stream
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('InputList') is not None:
            self.input_list = m.get('InputList')
        if m.get('MonitorName') is not None:
            self.monitor_name = m.get('MonitorName')
        if m.get('OutputTemplate') is not None:
            self.output_template = m.get('OutputTemplate')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        return self


class CreateLiveStreamMonitorResponseBody(TeaModel):
    def __init__(self, monitor_id=None, request_id=None):
        self.monitor_id = monitor_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveStreamMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_id is not None:
            result['MonitorId'] = self.monitor_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MonitorId') is not None:
            self.monitor_id = m.get('MonitorId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveStreamMonitorResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLiveStreamMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLiveStreamMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveStreamMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveStreamRecordIndexFilesRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, oss_bucket=None, oss_endpoint=None,
                 oss_object=None, owner_id=None, security_token=None, start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveStreamRecordIndexFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo(TeaModel):
    def __init__(self, app_name=None, create_time=None, domain_name=None, duration=None, end_time=None, height=None,
                 oss_bucket=None, oss_endpoint=None, oss_object=None, record_id=None, record_url=None, start_time=None,
                 stream_name=None, width=None):
        self.app_name = app_name  # type: str
        self.create_time = create_time  # type: str
        self.domain_name = domain_name  # type: str
        self.duration = duration  # type: float
        self.end_time = end_time  # type: str
        self.height = height  # type: int
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str
        self.record_id = record_id  # type: str
        self.record_url = record_url  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.height is not None:
            result['Height'] = self.height
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class CreateLiveStreamRecordIndexFilesResponseBody(TeaModel):
    def __init__(self, record_info=None, request_id=None):
        self.record_info = record_info  # type: CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.record_info:
            self.record_info.validate()

    def to_map(self):
        _map = super(CreateLiveStreamRecordIndexFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_info is not None:
            result['RecordInfo'] = self.record_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecordInfo') is not None:
            temp_model = CreateLiveStreamRecordIndexFilesResponseBodyRecordInfo()
            self.record_info = temp_model.from_map(m['RecordInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLiveStreamRecordIndexFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLiveStreamRecordIndexFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLiveStreamRecordIndexFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveStreamRecordIndexFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLiveTranscodeTemplateRequest(TeaModel):
    def __init__(self, owner_id=None, security_token=None, template_config=None, type=None):
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.template_config = template_config  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.template_config is not None:
            result['TemplateConfig'] = self.template_config
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('TemplateConfig') is not None:
            self.template_config = m.get('TemplateConfig')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateLiveTranscodeTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, template_id=None):
        self.request_id = request_id  # type: str
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class CreateLiveTranscodeTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLiveTranscodeTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLiveTranscodeTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLiveTranscodeTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMessageAppRequest(TeaModel):
    def __init__(self, app_config=None, app_name=None, extension=None):
        self.app_config = app_config  # type: dict[str, str]
        self.app_name = app_name  # type: str
        self.extension = extension  # type: dict[str, str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMessageAppRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_config is not None:
            result['AppConfig'] = self.app_config
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppConfig') is not None:
            self.app_config = m.get('AppConfig')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class CreateMessageAppShrinkRequest(TeaModel):
    def __init__(self, app_config_shrink=None, app_name=None, extension_shrink=None):
        self.app_config_shrink = app_config_shrink  # type: str
        self.app_name = app_name  # type: str
        self.extension_shrink = extension_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMessageAppShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_config_shrink is not None:
            result['AppConfig'] = self.app_config_shrink
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.extension_shrink is not None:
            result['Extension'] = self.extension_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppConfig') is not None:
            self.app_config_shrink = m.get('AppConfig')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Extension') is not None:
            self.extension_shrink = m.get('Extension')
        return self


class CreateMessageAppResponseBodyResult(TeaModel):
    def __init__(self, app_id=None):
        self.app_id = app_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMessageAppResponseBodyResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class CreateMessageAppResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: CreateMessageAppResponseBodyResult

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super(CreateMessageAppResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CreateMessageAppResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CreateMessageAppResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMessageAppResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMessageAppResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMessageAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMessageGroupRequest(TeaModel):
    def __init__(self, app_id=None, creator_id=None, extension=None):
        self.app_id = app_id  # type: str
        self.creator_id = creator_id  # type: str
        self.extension = extension  # type: dict[str, str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMessageGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.extension is not None:
            result['Extension'] = self.extension
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        return self


class CreateMessageGroupShrinkRequest(TeaModel):
    def __init__(self, app_id=None, creator_id=None, extension_shrink=None):
        self.app_id = app_id  # type: str
        self.creator_id = creator_id  # type: str
        self.extension_shrink = extension_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMessageGroupShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.creator_id is not None:
            result['CreatorId'] = self.creator_id
        if self.extension_shrink is not None:
            result['Extension'] = self.extension_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreatorId') is not None:
            self.creator_id = m.get('CreatorId')
        if m.get('Extension') is not None:
            self.extension_shrink = m.get('Extension')
        return self


class CreateMessageGroupResponseBodyResult(TeaModel):
    def __init__(self, extension=None, group_id=None):
        self.extension = extension  # type: dict[str, any]
        self.group_id = group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMessageGroupResponseBodyResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extension is not None:
            result['Extension'] = self.extension
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Extension') is not None:
            self.extension = m.get('Extension')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateMessageGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: CreateMessageGroupResponseBodyResult

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super(CreateMessageGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = CreateMessageGroupResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class CreateMessageGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMessageGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMessageGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMessageGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMixStreamRequest(TeaModel):
    def __init__(self, callback_config=None, domain_name=None, input_stream_list=None, layout_id=None,
                 output_config=None, owner_id=None):
        self.callback_config = callback_config  # type: str
        self.domain_name = domain_name  # type: str
        self.input_stream_list = input_stream_list  # type: str
        self.layout_id = layout_id  # type: str
        self.output_config = output_config  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMixStreamRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_config is not None:
            result['CallbackConfig'] = self.callback_config
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.input_stream_list is not None:
            result['InputStreamList'] = self.input_stream_list
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.output_config is not None:
            result['OutputConfig'] = self.output_config
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallbackConfig') is not None:
            self.callback_config = m.get('CallbackConfig')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InputStreamList') is not None:
            self.input_stream_list = m.get('InputStreamList')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OutputConfig') is not None:
            self.output_config = m.get('OutputConfig')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class CreateMixStreamResponseBody(TeaModel):
    def __init__(self, mix_stream_id=None, request_id=None):
        self.mix_stream_id = mix_stream_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMixStreamResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMixStreamResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateMixStreamResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMixStreamResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateMixStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteCasterResponseBody(TeaModel):
    def __init__(self, caster_id=None, request_id=None):
        self.caster_id = caster_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCasterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCasterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterComponentRequest(TeaModel):
    def __init__(self, caster_id=None, component_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.component_id = component_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterComponentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteCasterComponentResponseBody(TeaModel):
    def __init__(self, caster_id=None, component_id=None, request_id=None):
        self.caster_id = caster_id  # type: str
        self.component_id = component_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterComponentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterComponentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCasterComponentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCasterComponentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterEpisodeRequest(TeaModel):
    def __init__(self, caster_id=None, episode_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.episode_id = episode_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterEpisodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteCasterEpisodeResponseBody(TeaModel):
    def __init__(self, caster_id=None, episode_id=None, request_id=None):
        self.caster_id = caster_id  # type: str
        self.episode_id = episode_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterEpisodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterEpisodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCasterEpisodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCasterEpisodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterEpisodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterEpisodeGroupRequest(TeaModel):
    def __init__(self, owner_id=None, program_id=None):
        self.owner_id = owner_id  # type: long
        self.program_id = program_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterEpisodeGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        return self


class DeleteCasterEpisodeGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterEpisodeGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterEpisodeGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCasterEpisodeGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCasterEpisodeGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterEpisodeGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterLayoutRequest(TeaModel):
    def __init__(self, caster_id=None, layout_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.layout_id = layout_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterLayoutRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteCasterLayoutResponseBody(TeaModel):
    def __init__(self, caster_id=None, layout_id=None, request_id=None):
        self.caster_id = caster_id  # type: str
        self.layout_id = layout_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterLayoutResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterLayoutResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCasterLayoutResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCasterLayoutResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterProgramRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterProgramRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteCasterProgramResponseBody(TeaModel):
    def __init__(self, caster_id=None, request_id=None):
        self.caster_id = caster_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterProgramResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterProgramResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCasterProgramResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCasterProgramResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterSceneConfigRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None, scene_id=None, type=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long
        self.scene_id = scene_id  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterSceneConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteCasterSceneConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterSceneConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterSceneConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCasterSceneConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCasterSceneConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterSceneConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCasterVideoResourceRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None, resource_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_id = resource_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterVideoResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DeleteCasterVideoResourceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCasterVideoResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCasterVideoResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCasterVideoResourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCasterVideoResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCasterVideoResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomTemplateRequest(TeaModel):
    def __init__(self, owner_id=None, template=None):
        self.owner_id = owner_id  # type: long
        self.template = template  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class DeleteCustomTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCustomTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCustomTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCustomTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAppRecordConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, security_token=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveAppRecordConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveAppRecordConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveAppRecordConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAppRecordConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveAppRecordConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveAppRecordConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAppRecordConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAppSnapshotConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, security_token=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveAppSnapshotConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveAppSnapshotConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveAppSnapshotConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAppSnapshotConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveAppSnapshotConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveAppSnapshotConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAppSnapshotConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAudioAuditConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveAudioAuditConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveAudioAuditConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAudioAuditConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveAudioAuditConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveAudioAuditConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAudioAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveAudioAuditNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveAudioAuditNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteLiveAudioAuditNotifyConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveAudioAuditNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveAudioAuditNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveAudioAuditNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveAudioAuditNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveAudioAuditNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDetectNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveDetectNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveDetectNotifyConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveDetectNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDetectNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveDetectNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveDetectNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDetectNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainRequest(TeaModel):
    def __init__(self, domain_name=None, owner_account=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainMappingRequest(TeaModel):
    def __init__(self, owner_id=None, pull_domain=None, push_domain=None, security_token=None):
        self.owner_id = owner_id  # type: long
        self.pull_domain = pull_domain  # type: str
        self.push_domain = push_domain  # type: str
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveDomainMappingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        if self.push_domain is not None:
            result['PushDomain'] = self.push_domain
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        if m.get('PushDomain') is not None:
            self.push_domain = m.get('PushDomain')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveDomainMappingResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveDomainMappingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainMappingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveDomainMappingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveDomainMappingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveDomainPlayMappingRequest(TeaModel):
    def __init__(self, owner_id=None, play_domain=None, pull_domain=None):
        self.owner_id = owner_id  # type: long
        self.play_domain = play_domain  # type: str
        self.pull_domain = pull_domain  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveDomainPlayMappingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.play_domain is not None:
            result['PlayDomain'] = self.play_domain
        if self.pull_domain is not None:
            result['PullDomain'] = self.pull_domain
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PlayDomain') is not None:
            self.play_domain = m.get('PlayDomain')
        if m.get('PullDomain') is not None:
            self.pull_domain = m.get('PullDomain')
        return self


class DeleteLiveDomainPlayMappingResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveDomainPlayMappingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveDomainPlayMappingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveDomainPlayMappingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveDomainPlayMappingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveDomainPlayMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveEdgeTransferRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveEdgeTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteLiveEdgeTransferResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveEdgeTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveEdgeTransferResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveEdgeTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveEdgeTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveEdgeTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveLazyPullStreamInfoConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveLazyPullStreamInfoConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteLiveLazyPullStreamInfoConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveLazyPullStreamInfoConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveLazyPullStreamInfoConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveLazyPullStreamInfoConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveLazyPullStreamInfoConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveLazyPullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLivePullStreamInfoConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLivePullStreamInfoConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLivePullStreamInfoConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLivePullStreamInfoConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLivePullStreamInfoConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLivePullStreamInfoConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLivePullStreamInfoConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLivePullStreamInfoConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRealTimeLogLogstoreRequest(TeaModel):
    def __init__(self, logstore=None, owner_id=None, project=None, region=None):
        self.logstore = logstore  # type: str
        self.owner_id = owner_id  # type: long
        self.project = project  # type: str
        self.region = region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRealTimeLogLogstoreRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DeleteLiveRealTimeLogLogstoreResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRealTimeLogLogstoreResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRealTimeLogLogstoreResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveRealTimeLogLogstoreResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveRealTimeLogLogstoreResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRealTimeLogLogstoreResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRealtimeLogDeliveryRequest(TeaModel):
    def __init__(self, domain_name=None, logstore=None, owner_id=None, project=None, region=None):
        self.domain_name = domain_name  # type: str
        self.logstore = logstore  # type: str
        self.owner_id = owner_id  # type: long
        self.project = project  # type: str
        self.region = region  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRealtimeLogDeliveryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        return self


class DeleteLiveRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRealtimeLogDeliveryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRealtimeLogDeliveryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveRealtimeLogDeliveryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveRealtimeLogDeliveryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRecordNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveRecordNotifyConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRecordNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveRecordNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveRecordNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveRecordVodConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRecordVodConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveRecordVodConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveRecordVodConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveRecordVodConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveRecordVodConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveRecordVodConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveRecordVodConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotDetectPornConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, security_token=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotDetectPornConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveSnapshotDetectPornConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotDetectPornConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotDetectPornConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveSnapshotDetectPornConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveSnapshotDetectPornConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotDetectPornConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSnapshotNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteLiveSnapshotNotifyConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSnapshotNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSnapshotNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveSnapshotNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveSnapshotNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSnapshotNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveSpecificStagingConfigRequest(TeaModel):
    def __init__(self, config_id=None, domain_name=None, owner_id=None, security_token=None):
        self.config_id = config_id  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSpecificStagingConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DeleteLiveSpecificStagingConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveSpecificStagingConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveSpecificStagingConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveSpecificStagingConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveSpecificStagingConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveSpecificStagingConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamMonitorRequest(TeaModel):
    def __init__(self, monitor_id=None, owner_id=None):
        self.monitor_id = monitor_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_id is not None:
            result['MonitorId'] = self.monitor_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MonitorId') is not None:
            self.monitor_id = m.get('MonitorId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteLiveStreamMonitorResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamMonitorResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveStreamMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveStreamMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamRecordIndexFilesRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, record_id=None, remove_file=None,
                 stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.record_id = record_id  # type: list[str]
        self.remove_file = remove_file  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamRecordIndexFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.remove_file is not None:
            result['RemoveFile'] = self.remove_file
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RemoveFile') is not None:
            self.remove_file = m.get('RemoveFile')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoListRecordDeleteInfo(TeaModel):
    def __init__(self, message=None, record_id=None):
        self.message = message  # type: str
        self.record_id = record_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoListRecordDeleteInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        return self


class DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoList(TeaModel):
    def __init__(self, record_delete_info=None):
        self.record_delete_info = record_delete_info  # type: list[DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoListRecordDeleteInfo]

    def validate(self):
        if self.record_delete_info:
            for k in self.record_delete_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordDeleteInfo'] = []
        if self.record_delete_info is not None:
            for k in self.record_delete_info:
                result['RecordDeleteInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.record_delete_info = []
        if m.get('RecordDeleteInfo') is not None:
            for k in m.get('RecordDeleteInfo'):
                temp_model = DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoListRecordDeleteInfo()
                self.record_delete_info.append(temp_model.from_map(k))
        return self


class DeleteLiveStreamRecordIndexFilesResponseBody(TeaModel):
    def __init__(self, code=None, message=None, record_delete_info_list=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.record_delete_info_list = record_delete_info_list  # type: DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.record_delete_info_list:
            self.record_delete_info_list.validate()

    def to_map(self):
        _map = super(DeleteLiveStreamRecordIndexFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.record_delete_info_list is not None:
            result['RecordDeleteInfoList'] = self.record_delete_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RecordDeleteInfoList') is not None:
            temp_model = DeleteLiveStreamRecordIndexFilesResponseBodyRecordDeleteInfoList()
            self.record_delete_info_list = temp_model.from_map(m['RecordDeleteInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamRecordIndexFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveStreamRecordIndexFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveStreamRecordIndexFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamRecordIndexFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamTranscodeRequest(TeaModel):
    def __init__(self, app=None, domain=None, owner_id=None, security_token=None, template=None):
        self.app = app  # type: str
        self.domain = domain  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.template = template  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamTranscodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.template is not None:
            result['Template'] = self.template
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('Template') is not None:
            self.template = m.get('Template')
        return self


class DeleteLiveStreamTranscodeResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamTranscodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamTranscodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveStreamTranscodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveStreamTranscodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamTranscodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamWatermarkRequest(TeaModel):
    def __init__(self, owner_id=None, template_id=None):
        self.owner_id = owner_id  # type: long
        self.template_id = template_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamWatermarkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteLiveStreamWatermarkResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamWatermarkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamWatermarkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveStreamWatermarkResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveStreamWatermarkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamWatermarkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamWatermarkRuleRequest(TeaModel):
    def __init__(self, app=None, domain=None, owner_id=None, rule_id=None, stream=None):
        self.app = app  # type: str
        self.domain = domain  # type: str
        self.owner_id = owner_id  # type: long
        self.rule_id = rule_id  # type: str
        self.stream = stream  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamWatermarkRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.stream is not None:
            result['Stream'] = self.stream
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        return self


class DeleteLiveStreamWatermarkRuleResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamWatermarkRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamWatermarkRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveStreamWatermarkRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveStreamWatermarkRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamWatermarkRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLiveStreamsNotifyUrlConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamsNotifyUrlConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteLiveStreamsNotifyUrlConfigResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLiveStreamsNotifyUrlConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLiveStreamsNotifyUrlConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLiveStreamsNotifyUrlConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLiveStreamsNotifyUrlConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLiveStreamsNotifyUrlConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMessageAppRequest(TeaModel):
    def __init__(self, app_id=None):
        self.app_id = app_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMessageAppRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DeleteMessageAppResponseBodyResult(TeaModel):
    def __init__(self, success=None):
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMessageAppResponseBodyResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteMessageAppResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: DeleteMessageAppResponseBodyResult

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super(DeleteMessageAppResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = DeleteMessageAppResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        return self


class DeleteMessageAppResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMessageAppResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMessageAppResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMessageAppResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMixStreamRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, mix_stream_id=None, owner_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.mix_stream_id = mix_stream_id  # type: str
        self.owner_id = owner_id  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMixStreamRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteMixStreamResponseBody(TeaModel):
    def __init__(self, mix_stream_id=None, request_id=None):
        self.mix_stream_id = mix_stream_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMixStreamResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mix_stream_id is not None:
            result['MixStreamId'] = self.mix_stream_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MixStreamId') is not None:
            self.mix_stream_id = m.get('MixStreamId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMixStreamResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMixStreamResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMixStreamResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMixStreamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteMultiRateConfigRequest(TeaModel):
    def __init__(self, app=None, delete_all=None, domain_name=None, group_id=None, owner_id=None, templates=None):
        self.app = app  # type: str
        self.delete_all = delete_all  # type: str
        self.domain_name = domain_name  # type: str
        self.group_id = group_id  # type: str
        self.owner_id = owner_id  # type: long
        self.templates = templates  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMultiRateConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.delete_all is not None:
            result['DeleteAll'] = self.delete_all
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.templates is not None:
            result['Templates'] = self.templates
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('DeleteAll') is not None:
            self.delete_all = m.get('DeleteAll')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Templates') is not None:
            self.templates = m.get('Templates')
        return self


class DeleteMultiRateConfigResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None):
        self.code = code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteMultiRateConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteMultiRateConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteMultiRateConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteMultiRateConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteMultiRateConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePlaylistRequest(TeaModel):
    def __init__(self, owner_id=None, program_id=None):
        self.owner_id = owner_id  # type: long
        self.program_id = program_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePlaylistRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        return self


class DeletePlaylistResponseBody(TeaModel):
    def __init__(self, program_id=None, request_id=None):
        self.program_id = program_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePlaylistResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePlaylistResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePlaylistResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePlaylistResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePlaylistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePlaylistItemsRequest(TeaModel):
    def __init__(self, owner_id=None, program_id=None, program_item_ids=None):
        self.owner_id = owner_id  # type: long
        self.program_id = program_id  # type: str
        self.program_item_ids = program_item_ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePlaylistItemsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.program_item_ids is not None:
            result['ProgramItemIds'] = self.program_item_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('ProgramItemIds') is not None:
            self.program_item_ids = m.get('ProgramItemIds')
        return self


class DeletePlaylistItemsResponseBody(TeaModel):
    def __init__(self, program_id=None, request_id=None):
        self.program_id = program_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePlaylistItemsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.program_id is not None:
            result['ProgramId'] = self.program_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProgramId') is not None:
            self.program_id = m.get('ProgramId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePlaylistItemsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePlaylistItemsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePlaylistItemsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePlaylistItemsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRoomRequest(TeaModel):
    def __init__(self, app_id=None, owner_id=None, room_id=None):
        self.app_id = app_id  # type: str
        self.owner_id = owner_id  # type: long
        self.room_id = room_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoomRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class DeleteRoomResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRoomResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRoomResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRoomResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRoomResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRoomResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotCallbackAuthRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSnapshotCallbackAuthRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteSnapshotCallbackAuthResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSnapshotCallbackAuthResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnapshotCallbackAuthResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSnapshotCallbackAuthResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSnapshotCallbackAuthResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotCallbackAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotFilesRequest(TeaModel):
    def __init__(self, app_name=None, create_timestamp_list=None, domain_name=None, owner_id=None, remove_file=None,
                 stream_name=None):
        self.app_name = app_name  # type: str
        self.create_timestamp_list = create_timestamp_list  # type: list[long]
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.remove_file = remove_file  # type: bool
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSnapshotFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_timestamp_list is not None:
            result['CreateTimestampList'] = self.create_timestamp_list
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.remove_file is not None:
            result['RemoveFile'] = self.remove_file
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTimestampList') is not None:
            self.create_timestamp_list = m.get('CreateTimestampList')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RemoveFile') is not None:
            self.remove_file = m.get('RemoveFile')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DeleteSnapshotFilesResponseBodySnapshotDeleteInfoListSnapshotDeleteInfo(TeaModel):
    def __init__(self, create_timestamp=None, message=None):
        self.create_timestamp = create_timestamp  # type: long
        self.message = message  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSnapshotFilesResponseBodySnapshotDeleteInfoListSnapshotDeleteInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DeleteSnapshotFilesResponseBodySnapshotDeleteInfoList(TeaModel):
    def __init__(self, snapshot_delete_info=None):
        self.snapshot_delete_info = snapshot_delete_info  # type: list[DeleteSnapshotFilesResponseBodySnapshotDeleteInfoListSnapshotDeleteInfo]

    def validate(self):
        if self.snapshot_delete_info:
            for k in self.snapshot_delete_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteSnapshotFilesResponseBodySnapshotDeleteInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SnapshotDeleteInfo'] = []
        if self.snapshot_delete_info is not None:
            for k in self.snapshot_delete_info:
                result['SnapshotDeleteInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.snapshot_delete_info = []
        if m.get('SnapshotDeleteInfo') is not None:
            for k in m.get('SnapshotDeleteInfo'):
                temp_model = DeleteSnapshotFilesResponseBodySnapshotDeleteInfoListSnapshotDeleteInfo()
                self.snapshot_delete_info.append(temp_model.from_map(k))
        return self


class DeleteSnapshotFilesResponseBody(TeaModel):
    def __init__(self, failure_count=None, request_id=None, snapshot_delete_info_list=None, success_count=None):
        self.failure_count = failure_count  # type: int
        self.request_id = request_id  # type: str
        self.snapshot_delete_info_list = snapshot_delete_info_list  # type: DeleteSnapshotFilesResponseBodySnapshotDeleteInfoList
        self.success_count = success_count  # type: int

    def validate(self):
        if self.snapshot_delete_info_list:
            self.snapshot_delete_info_list.validate()

    def to_map(self):
        _map = super(DeleteSnapshotFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_count is not None:
            result['FailureCount'] = self.failure_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_delete_info_list is not None:
            result['SnapshotDeleteInfoList'] = self.snapshot_delete_info_list.to_map()
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailureCount') is not None:
            self.failure_count = m.get('FailureCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotDeleteInfoList') is not None:
            temp_model = DeleteSnapshotFilesResponseBodySnapshotDeleteInfoList()
            self.snapshot_delete_info_list = temp_model.from_map(m['SnapshotDeleteInfoList'])
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class DeleteSnapshotFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSnapshotFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSnapshotFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStudioLayoutRequest(TeaModel):
    def __init__(self, caster_id=None, layout_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.layout_id = layout_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStudioLayoutRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DeleteStudioLayoutResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStudioLayoutResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStudioLayoutResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteStudioLayoutResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteStudioLayoutResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStudioLayoutResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoShowListTasksRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoShowListTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeAutoShowListTasksResponseBody(TeaModel):
    def __init__(self, auto_show_list_tasks=None, request_id=None):
        self.auto_show_list_tasks = auto_show_list_tasks  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoShowListTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_show_list_tasks is not None:
            result['AutoShowListTasks'] = self.auto_show_list_tasks
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoShowListTasks') is not None:
            self.auto_show_list_tasks = m.get('AutoShowListTasks')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoShowListTasksResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAutoShowListTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAutoShowListTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoShowListTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterChannelsRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterChannelsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeCasterChannelsResponseBodyChannelsChannel(TeaModel):
    def __init__(self, channel_id=None, face_beauty=None, resource_id=None, rtmp_url=None, stream_url=None):
        self.channel_id = channel_id  # type: str
        self.face_beauty = face_beauty  # type: str
        self.resource_id = resource_id  # type: str
        self.rtmp_url = rtmp_url  # type: str
        self.stream_url = stream_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterChannelsResponseBodyChannelsChannel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.face_beauty is not None:
            result['FaceBeauty'] = self.face_beauty
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.rtmp_url is not None:
            result['RtmpUrl'] = self.rtmp_url
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('FaceBeauty') is not None:
            self.face_beauty = m.get('FaceBeauty')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('RtmpUrl') is not None:
            self.rtmp_url = m.get('RtmpUrl')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterChannelsResponseBodyChannels(TeaModel):
    def __init__(self, channel=None):
        self.channel = channel  # type: list[DescribeCasterChannelsResponseBodyChannelsChannel]

    def validate(self):
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterChannelsResponseBodyChannels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = DescribeCasterChannelsResponseBodyChannelsChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class DescribeCasterChannelsResponseBody(TeaModel):
    def __init__(self, channels=None, request_id=None, total=None):
        self.channels = channels  # type: DescribeCasterChannelsResponseBodyChannels
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.channels:
            self.channels.validate()

    def to_map(self):
        _map = super(DescribeCasterChannelsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channels is not None:
            result['Channels'] = self.channels.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Channels') is not None:
            temp_model = DescribeCasterChannelsResponseBodyChannels()
            self.channels = temp_model.from_map(m['Channels'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterChannelsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterChannelsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterChannelsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterChannelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterComponentsRequest(TeaModel):
    def __init__(self, caster_id=None, component_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.component_id = component_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterComponentsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent(TeaModel):
    def __init__(self, border_color=None, border_width_normalized=None, color=None, font_name=None,
                 line_space_normalized=None, location_id=None, pts_offset=None, show_source_lan=None, size_normalized=None,
                 source_lan=None, target_lan=None, word_count_per_line=None, word_space_normalized=None, words_count=None):
        self.border_color = border_color  # type: str
        self.border_width_normalized = border_width_normalized  # type: float
        self.color = color  # type: str
        self.font_name = font_name  # type: str
        self.line_space_normalized = line_space_normalized  # type: float
        self.location_id = location_id  # type: str
        self.pts_offset = pts_offset  # type: int
        self.show_source_lan = show_source_lan  # type: bool
        self.size_normalized = size_normalized  # type: float
        self.source_lan = source_lan  # type: str
        self.target_lan = target_lan  # type: str
        self.word_count_per_line = word_count_per_line  # type: int
        self.word_space_normalized = word_space_normalized  # type: float
        self.words_count = words_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.color is not None:
            result['Color'] = self.color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.line_space_normalized is not None:
            result['LineSpaceNormalized'] = self.line_space_normalized
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.pts_offset is not None:
            result['PtsOffset'] = self.pts_offset
        if self.show_source_lan is not None:
            result['ShowSourceLan'] = self.show_source_lan
        if self.size_normalized is not None:
            result['SizeNormalized'] = self.size_normalized
        if self.source_lan is not None:
            result['SourceLan'] = self.source_lan
        if self.target_lan is not None:
            result['TargetLan'] = self.target_lan
        if self.word_count_per_line is not None:
            result['WordCountPerLine'] = self.word_count_per_line
        if self.word_space_normalized is not None:
            result['WordSpaceNormalized'] = self.word_space_normalized
        if self.words_count is not None:
            result['WordsCount'] = self.words_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('Color') is not None:
            self.color = m.get('Color')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('LineSpaceNormalized') is not None:
            self.line_space_normalized = m.get('LineSpaceNormalized')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('PtsOffset') is not None:
            self.pts_offset = m.get('PtsOffset')
        if m.get('ShowSourceLan') is not None:
            self.show_source_lan = m.get('ShowSourceLan')
        if m.get('SizeNormalized') is not None:
            self.size_normalized = m.get('SizeNormalized')
        if m.get('SourceLan') is not None:
            self.source_lan = m.get('SourceLan')
        if m.get('TargetLan') is not None:
            self.target_lan = m.get('TargetLan')
        if m.get('WordCountPerLine') is not None:
            self.word_count_per_line = m.get('WordCountPerLine')
        if m.get('WordSpaceNormalized') is not None:
            self.word_space_normalized = m.get('WordSpaceNormalized')
        if m.get('WordsCount') is not None:
            self.words_count = m.get('WordsCount')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds(TeaModel):
    def __init__(self, position=None):
        self.position = position  # type: list[float]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer(TeaModel):
    def __init__(self, height_normalized=None, position_normalizeds=None, position_refer=None, transparency=None,
                 width_normalized=None):
        self.height_normalized = height_normalized  # type: float
        self.position_normalizeds = position_normalizeds  # type: DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds
        self.position_refer = position_refer  # type: str
        self.transparency = transparency  # type: int
        self.width_normalized = width_normalized  # type: float

    def validate(self):
        if self.position_normalizeds:
            self.position_normalizeds.validate()

    def to_map(self):
        _map = super(DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_normalizeds is not None:
            result['PositionNormalizeds'] = self.position_normalizeds.to_map()
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.transparency is not None:
            result['Transparency'] = self.transparency
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionNormalizeds') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentComponentLayerPositionNormalizeds()
            self.position_normalizeds = temp_model.from_map(m['PositionNormalizeds'])
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('Transparency') is not None:
            self.transparency = m.get('Transparency')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent(TeaModel):
    def __init__(self, material_id=None):
        self.material_id = material_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent(TeaModel):
    def __init__(self, border_color=None, border_width_normalized=None, color=None, font_name=None,
                 size_normalized=None, text=None):
        self.border_color = border_color  # type: str
        self.border_width_normalized = border_width_normalized  # type: float
        self.color = color  # type: str
        self.font_name = font_name  # type: str
        self.size_normalized = size_normalized  # type: float
        self.text = text  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.border_color is not None:
            result['BorderColor'] = self.border_color
        if self.border_width_normalized is not None:
            result['BorderWidthNormalized'] = self.border_width_normalized
        if self.color is not None:
            result['Color'] = self.color
        if self.font_name is not None:
            result['FontName'] = self.font_name
        if self.size_normalized is not None:
            result['SizeNormalized'] = self.size_normalized
        if self.text is not None:
            result['Text'] = self.text
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BorderColor') is not None:
            self.border_color = m.get('BorderColor')
        if m.get('BorderWidthNormalized') is not None:
            self.border_width_normalized = m.get('BorderWidthNormalized')
        if m.get('Color') is not None:
            self.color = m.get('Color')
        if m.get('FontName') is not None:
            self.font_name = m.get('FontName')
        if m.get('SizeNormalized') is not None:
            self.size_normalized = m.get('SizeNormalized')
        if m.get('Text') is not None:
            self.text = m.get('Text')
        return self


class DescribeCasterComponentsResponseBodyComponentsComponent(TeaModel):
    def __init__(self, caption_layer_content=None, component_id=None, component_layer=None, component_name=None,
                 component_type=None, effect=None, image_layer_content=None, location_id=None, text_layer_content=None):
        self.caption_layer_content = caption_layer_content  # type: DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent
        self.component_id = component_id  # type: str
        self.component_layer = component_layer  # type: DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer
        self.component_name = component_name  # type: str
        self.component_type = component_type  # type: str
        self.effect = effect  # type: str
        self.image_layer_content = image_layer_content  # type: DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent
        self.location_id = location_id  # type: str
        self.text_layer_content = text_layer_content  # type: DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent

    def validate(self):
        if self.caption_layer_content:
            self.caption_layer_content.validate()
        if self.component_layer:
            self.component_layer.validate()
        if self.image_layer_content:
            self.image_layer_content.validate()
        if self.text_layer_content:
            self.text_layer_content.validate()

    def to_map(self):
        _map = super(DescribeCasterComponentsResponseBodyComponentsComponent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caption_layer_content is not None:
            result['CaptionLayerContent'] = self.caption_layer_content.to_map()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        if self.component_layer is not None:
            result['ComponentLayer'] = self.component_layer.to_map()
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.effect is not None:
            result['Effect'] = self.effect
        if self.image_layer_content is not None:
            result['ImageLayerContent'] = self.image_layer_content.to_map()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.text_layer_content is not None:
            result['TextLayerContent'] = self.text_layer_content.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaptionLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentCaptionLayerContent()
            self.caption_layer_content = temp_model.from_map(m['CaptionLayerContent'])
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        if m.get('ComponentLayer') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentComponentLayer()
            self.component_layer = temp_model.from_map(m['ComponentLayer'])
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('Effect') is not None:
            self.effect = m.get('Effect')
        if m.get('ImageLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentImageLayerContent()
            self.image_layer_content = temp_model.from_map(m['ImageLayerContent'])
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('TextLayerContent') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponentsComponentTextLayerContent()
            self.text_layer_content = temp_model.from_map(m['TextLayerContent'])
        return self


class DescribeCasterComponentsResponseBodyComponents(TeaModel):
    def __init__(self, component=None):
        self.component = component  # type: list[DescribeCasterComponentsResponseBodyComponentsComponent]

    def validate(self):
        if self.component:
            for k in self.component:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterComponentsResponseBodyComponents, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Component'] = []
        if self.component is not None:
            for k in self.component:
                result['Component'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.component = []
        if m.get('Component') is not None:
            for k in m.get('Component'):
                temp_model = DescribeCasterComponentsResponseBodyComponentsComponent()
                self.component.append(temp_model.from_map(k))
        return self


class DescribeCasterComponentsResponseBody(TeaModel):
    def __init__(self, components=None, request_id=None, total=None):
        self.components = components  # type: DescribeCasterComponentsResponseBodyComponents
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.components:
            self.components.validate()

    def to_map(self):
        _map = super(DescribeCasterComponentsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.components is not None:
            result['Components'] = self.components.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Components') is not None:
            temp_model = DescribeCasterComponentsResponseBodyComponents()
            self.components = temp_model.from_map(m['Components'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterComponentsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterComponentsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterComponentsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterComponentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterConfigRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat(TeaModel):
    def __init__(self, cycle_duration=None, format=None, oss_object_prefix=None, slice_oss_object_prefix=None):
        self.cycle_duration = cycle_duration  # type: int
        self.format = format  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.slice_oss_object_prefix = slice_oss_object_prefix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class DescribeCasterConfigResponseBodyRecordConfigRecordFormat(TeaModel):
    def __init__(self, record_format=None):
        self.record_format = record_format  # type: list[DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat]

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBodyRecordConfigRecordFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = DescribeCasterConfigResponseBodyRecordConfigRecordFormatRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class DescribeCasterConfigResponseBodyRecordConfig(TeaModel):
    def __init__(self, oss_bucket=None, oss_endpoint=None, record_format=None):
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.record_format = record_format  # type: DescribeCasterConfigResponseBodyRecordConfigRecordFormat

    def validate(self):
        if self.record_format:
            self.record_format.validate()

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBodyRecordConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.record_format is not None:
            result['RecordFormat'] = self.record_format.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('RecordFormat') is not None:
            temp_model = DescribeCasterConfigResponseBodyRecordConfigRecordFormat()
            self.record_format = temp_model.from_map(m['RecordFormat'])
        return self


class DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroupResourceIds(TeaModel):
    def __init__(self, resource_id=None):
        self.resource_id = resource_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroupResourceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroup(TeaModel):
    def __init__(self, host_resource_id=None, mode=None, resource_ids=None):
        self.host_resource_id = host_resource_id  # type: str
        self.mode = mode  # type: int
        self.resource_ids = resource_ids  # type: DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroupResourceIds

    def validate(self):
        if self.resource_ids:
            self.resource_ids.validate()

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_resource_id is not None:
            result['HostResourceId'] = self.host_resource_id
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HostResourceId') is not None:
            self.host_resource_id = m.get('HostResourceId')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ResourceIds') is not None:
            temp_model = DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroupResourceIds()
            self.resource_ids = temp_model.from_map(m['ResourceIds'])
        return self


class DescribeCasterConfigResponseBodySyncGroupsConfig(TeaModel):
    def __init__(self, sync_group=None):
        self.sync_group = sync_group  # type: list[DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroup]

    def validate(self):
        if self.sync_group:
            for k in self.sync_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBodySyncGroupsConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SyncGroup'] = []
        if self.sync_group is not None:
            for k in self.sync_group:
                result['SyncGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sync_group = []
        if m.get('SyncGroup') is not None:
            for k in m.get('SyncGroup'):
                temp_model = DescribeCasterConfigResponseBodySyncGroupsConfigSyncGroup()
                self.sync_group.append(temp_model.from_map(k))
        return self


class DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds(TeaModel):
    def __init__(self, location_id=None):
        self.location_id = location_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterConfigResponseBodyTranscodeConfig(TeaModel):
    def __init__(self, caster_template=None, live_template_ids=None):
        self.caster_template = caster_template  # type: str
        self.live_template_ids = live_template_ids  # type: DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds

    def validate(self):
        if self.live_template_ids:
            self.live_template_ids.validate()

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBodyTranscodeConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        if self.live_template_ids is not None:
            result['LiveTemplateIds'] = self.live_template_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        if m.get('LiveTemplateIds') is not None:
            temp_model = DescribeCasterConfigResponseBodyTranscodeConfigLiveTemplateIds()
            self.live_template_ids = temp_model.from_map(m['LiveTemplateIds'])
        return self


class DescribeCasterConfigResponseBody(TeaModel):
    def __init__(self, callback_url=None, caster_id=None, caster_name=None, channel_enable=None, delay=None,
                 domain_name=None, program_effect=None, program_name=None, record_config=None, request_id=None,
                 side_output_url=None, side_output_url_list=None, sync_groups_config=None, transcode_config=None,
                 urgent_live_stream_url=None, urgent_material_id=None):
        self.callback_url = callback_url  # type: str
        self.caster_id = caster_id  # type: str
        self.caster_name = caster_name  # type: str
        self.channel_enable = channel_enable  # type: int
        self.delay = delay  # type: float
        self.domain_name = domain_name  # type: str
        self.program_effect = program_effect  # type: int
        self.program_name = program_name  # type: str
        self.record_config = record_config  # type: DescribeCasterConfigResponseBodyRecordConfig
        self.request_id = request_id  # type: str
        self.side_output_url = side_output_url  # type: str
        self.side_output_url_list = side_output_url_list  # type: str
        self.sync_groups_config = sync_groups_config  # type: DescribeCasterConfigResponseBodySyncGroupsConfig
        self.transcode_config = transcode_config  # type: DescribeCasterConfigResponseBodyTranscodeConfig
        self.urgent_live_stream_url = urgent_live_stream_url  # type: str
        self.urgent_material_id = urgent_material_id  # type: str

    def validate(self):
        if self.record_config:
            self.record_config.validate()
        if self.sync_groups_config:
            self.sync_groups_config.validate()
        if self.transcode_config:
            self.transcode_config.validate()

    def to_map(self):
        _map = super(DescribeCasterConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback_url is not None:
            result['CallbackUrl'] = self.callback_url
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.channel_enable is not None:
            result['ChannelEnable'] = self.channel_enable
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.program_effect is not None:
            result['ProgramEffect'] = self.program_effect
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.record_config is not None:
            result['RecordConfig'] = self.record_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.side_output_url is not None:
            result['SideOutputUrl'] = self.side_output_url
        if self.side_output_url_list is not None:
            result['SideOutputUrlList'] = self.side_output_url_list
        if self.sync_groups_config is not None:
            result['SyncGroupsConfig'] = self.sync_groups_config.to_map()
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config.to_map()
        if self.urgent_live_stream_url is not None:
            result['UrgentLiveStreamUrl'] = self.urgent_live_stream_url
        if self.urgent_material_id is not None:
            result['UrgentMaterialId'] = self.urgent_material_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallbackUrl') is not None:
            self.callback_url = m.get('CallbackUrl')
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('ChannelEnable') is not None:
            self.channel_enable = m.get('ChannelEnable')
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ProgramEffect') is not None:
            self.program_effect = m.get('ProgramEffect')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('RecordConfig') is not None:
            temp_model = DescribeCasterConfigResponseBodyRecordConfig()
            self.record_config = temp_model.from_map(m['RecordConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SideOutputUrl') is not None:
            self.side_output_url = m.get('SideOutputUrl')
        if m.get('SideOutputUrlList') is not None:
            self.side_output_url_list = m.get('SideOutputUrlList')
        if m.get('SyncGroupsConfig') is not None:
            temp_model = DescribeCasterConfigResponseBodySyncGroupsConfig()
            self.sync_groups_config = temp_model.from_map(m['SyncGroupsConfig'])
        if m.get('TranscodeConfig') is not None:
            temp_model = DescribeCasterConfigResponseBodyTranscodeConfig()
            self.transcode_config = temp_model.from_map(m['TranscodeConfig'])
        if m.get('UrgentLiveStreamUrl') is not None:
            self.urgent_live_stream_url = m.get('UrgentLiveStreamUrl')
        if m.get('UrgentMaterialId') is not None:
            self.urgent_material_id = m.get('UrgentMaterialId')
        return self


class DescribeCasterConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterLayoutsRequest(TeaModel):
    def __init__(self, caster_id=None, layout_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.layout_id = layout_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterLayoutsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer(TeaModel):
    def __init__(self, fixed_delay_duration=None, valid_channel=None, volume_rate=None):
        self.fixed_delay_duration = fixed_delay_duration  # type: int
        self.valid_channel = valid_channel  # type: str
        self.volume_rate = volume_rate  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers(TeaModel):
    def __init__(self, audio_layer=None):
        self.audio_layer = audio_layer  # type: list[DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer]

    def validate(self):
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayersAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList(TeaModel):
    def __init__(self, location_id=None):
        self.location_id = location_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList(TeaModel):
    def __init__(self, location_id=None):
        self.location_id = location_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds(TeaModel):
    def __init__(self, position=None):
        self.position = position  # type: list[float]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.position is not None:
            result['Position'] = self.position
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Position') is not None:
            self.position = m.get('Position')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer(TeaModel):
    def __init__(self, fill_mode=None, fixed_delay_duration=None, height_normalized=None,
                 position_normalizeds=None, position_refer=None, width_normalized=None):
        self.fill_mode = fill_mode  # type: str
        self.fixed_delay_duration = fixed_delay_duration  # type: int
        self.height_normalized = height_normalized  # type: float
        self.position_normalizeds = position_normalizeds  # type: DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds
        self.position_refer = position_refer  # type: str
        self.width_normalized = width_normalized  # type: float

    def validate(self):
        if self.position_normalizeds:
            self.position_normalizeds.validate()

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fill_mode is not None:
            result['FillMode'] = self.fill_mode
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.height_normalized is not None:
            result['HeightNormalized'] = self.height_normalized
        if self.position_normalizeds is not None:
            result['PositionNormalizeds'] = self.position_normalizeds.to_map()
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.width_normalized is not None:
            result['WidthNormalized'] = self.width_normalized
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FillMode') is not None:
            self.fill_mode = m.get('FillMode')
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('HeightNormalized') is not None:
            self.height_normalized = m.get('HeightNormalized')
        if m.get('PositionNormalizeds') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayerPositionNormalizeds()
            self.position_normalizeds = temp_model.from_map(m['PositionNormalizeds'])
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('WidthNormalized') is not None:
            self.width_normalized = m.get('WidthNormalized')
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers(TeaModel):
    def __init__(self, video_layer=None):
        self.video_layer = video_layer  # type: list[DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer]

    def validate(self):
        if self.video_layer:
            for k in self.video_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoLayer'] = []
        if self.video_layer is not None:
            for k in self.video_layer:
                result['VideoLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_layer = []
        if m.get('VideoLayer') is not None:
            for k in m.get('VideoLayer'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayersVideoLayer()
                self.video_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBodyLayoutsLayout(TeaModel):
    def __init__(self, audio_layers=None, blend_list=None, layout_id=None, mix_list=None, video_layers=None):
        self.audio_layers = audio_layers  # type: DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers
        self.blend_list = blend_list  # type: DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList
        self.layout_id = layout_id  # type: str
        self.mix_list = mix_list  # type: DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList
        self.video_layers = video_layers  # type: DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers

    def validate(self):
        if self.audio_layers:
            self.audio_layers.validate()
        if self.blend_list:
            self.blend_list.validate()
        if self.mix_list:
            self.mix_list.validate()
        if self.video_layers:
            self.video_layers.validate()

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayoutsLayout, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_layers is not None:
            result['AudioLayers'] = self.audio_layers.to_map()
        if self.blend_list is not None:
            result['BlendList'] = self.blend_list.to_map()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.mix_list is not None:
            result['MixList'] = self.mix_list.to_map()
        if self.video_layers is not None:
            result['VideoLayers'] = self.video_layers.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioLayers') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutAudioLayers()
            self.audio_layers = temp_model.from_map(m['AudioLayers'])
        if m.get('BlendList') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutBlendList()
            self.blend_list = temp_model.from_map(m['BlendList'])
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('MixList') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutMixList()
            self.mix_list = temp_model.from_map(m['MixList'])
        if m.get('VideoLayers') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayoutVideoLayers()
            self.video_layers = temp_model.from_map(m['VideoLayers'])
        return self


class DescribeCasterLayoutsResponseBodyLayouts(TeaModel):
    def __init__(self, layout=None):
        self.layout = layout  # type: list[DescribeCasterLayoutsResponseBodyLayoutsLayout]

    def validate(self):
        if self.layout:
            for k in self.layout:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBodyLayouts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Layout'] = []
        if self.layout is not None:
            for k in self.layout:
                result['Layout'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.layout = []
        if m.get('Layout') is not None:
            for k in m.get('Layout'):
                temp_model = DescribeCasterLayoutsResponseBodyLayoutsLayout()
                self.layout.append(temp_model.from_map(k))
        return self


class DescribeCasterLayoutsResponseBody(TeaModel):
    def __init__(self, layouts=None, request_id=None, total=None):
        self.layouts = layouts  # type: DescribeCasterLayoutsResponseBodyLayouts
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.layouts:
            self.layouts.validate()

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.layouts is not None:
            result['Layouts'] = self.layouts.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Layouts') is not None:
            temp_model = DescribeCasterLayoutsResponseBodyLayouts()
            self.layouts = temp_model.from_map(m['Layouts'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterLayoutsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterLayoutsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterLayoutsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterLayoutsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterProgramRequest(TeaModel):
    def __init__(self, caster_id=None, end_time=None, episode_id=None, episode_type=None, owner_id=None,
                 page_num=None, page_size=None, start_time=None, status=None):
        self.caster_id = caster_id  # type: str
        self.end_time = end_time  # type: str
        self.episode_id = episode_id  # type: str
        self.episode_type = episode_type  # type: str
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterProgramRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds(TeaModel):
    def __init__(self, component_id=None):
        self.component_id = component_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_id is not None:
            result['ComponentId'] = self.component_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComponentId') is not None:
            self.component_id = m.get('ComponentId')
        return self


class DescribeCasterProgramResponseBodyEpisodesEpisode(TeaModel):
    def __init__(self, component_ids=None, end_time=None, episode_id=None, episode_name=None, episode_type=None,
                 resource_id=None, start_time=None, status=None, switch_type=None):
        self.component_ids = component_ids  # type: DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds
        self.end_time = end_time  # type: str
        self.episode_id = episode_id  # type: str
        self.episode_name = episode_name  # type: str
        self.episode_type = episode_type  # type: str
        self.resource_id = resource_id  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: int
        self.switch_type = switch_type  # type: str

    def validate(self):
        if self.component_ids:
            self.component_ids.validate()

    def to_map(self):
        _map = super(DescribeCasterProgramResponseBodyEpisodesEpisode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_ids is not None:
            result['ComponentIds'] = self.component_ids.to_map()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.episode_id is not None:
            result['EpisodeId'] = self.episode_id
        if self.episode_name is not None:
            result['EpisodeName'] = self.episode_name
        if self.episode_type is not None:
            result['EpisodeType'] = self.episode_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.switch_type is not None:
            result['SwitchType'] = self.switch_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComponentIds') is not None:
            temp_model = DescribeCasterProgramResponseBodyEpisodesEpisodeComponentIds()
            self.component_ids = temp_model.from_map(m['ComponentIds'])
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EpisodeId') is not None:
            self.episode_id = m.get('EpisodeId')
        if m.get('EpisodeName') is not None:
            self.episode_name = m.get('EpisodeName')
        if m.get('EpisodeType') is not None:
            self.episode_type = m.get('EpisodeType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SwitchType') is not None:
            self.switch_type = m.get('SwitchType')
        return self


class DescribeCasterProgramResponseBodyEpisodes(TeaModel):
    def __init__(self, episode=None):
        self.episode = episode  # type: list[DescribeCasterProgramResponseBodyEpisodesEpisode]

    def validate(self):
        if self.episode:
            for k in self.episode:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterProgramResponseBodyEpisodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Episode'] = []
        if self.episode is not None:
            for k in self.episode:
                result['Episode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.episode = []
        if m.get('Episode') is not None:
            for k in m.get('Episode'):
                temp_model = DescribeCasterProgramResponseBodyEpisodesEpisode()
                self.episode.append(temp_model.from_map(k))
        return self


class DescribeCasterProgramResponseBody(TeaModel):
    def __init__(self, caster_id=None, episodes=None, program_effect=None, program_name=None, request_id=None,
                 total=None):
        self.caster_id = caster_id  # type: str
        self.episodes = episodes  # type: DescribeCasterProgramResponseBodyEpisodes
        self.program_effect = program_effect  # type: int
        self.program_name = program_name  # type: str
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.episodes:
            self.episodes.validate()

    def to_map(self):
        _map = super(DescribeCasterProgramResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.episodes is not None:
            result['Episodes'] = self.episodes.to_map()
        if self.program_effect is not None:
            result['ProgramEffect'] = self.program_effect
        if self.program_name is not None:
            result['ProgramName'] = self.program_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('Episodes') is not None:
            temp_model = DescribeCasterProgramResponseBodyEpisodes()
            self.episodes = temp_model.from_map(m['Episodes'])
        if m.get('ProgramEffect') is not None:
            self.program_effect = m.get('ProgramEffect')
        if m.get('ProgramName') is not None:
            self.program_name = m.get('ProgramName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterProgramResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterProgramResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterProgramResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterProgramResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterSceneAudioRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None, scene_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long
        self.scene_id = scene_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterSceneAudioRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        return self


class DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer(TeaModel):
    def __init__(self, fixed_delay_duration=None, valid_channel=None, volume_rate=None):
        self.fixed_delay_duration = fixed_delay_duration  # type: int
        self.valid_channel = valid_channel  # type: str
        self.volume_rate = volume_rate  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fixed_delay_duration is not None:
            result['FixedDelayDuration'] = self.fixed_delay_duration
        if self.valid_channel is not None:
            result['ValidChannel'] = self.valid_channel
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FixedDelayDuration') is not None:
            self.fixed_delay_duration = m.get('FixedDelayDuration')
        if m.get('ValidChannel') is not None:
            self.valid_channel = m.get('ValidChannel')
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        return self


class DescribeCasterSceneAudioResponseBodyAudioLayers(TeaModel):
    def __init__(self, audio_layer=None):
        self.audio_layer = audio_layer  # type: list[DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer]

    def validate(self):
        if self.audio_layer:
            for k in self.audio_layer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterSceneAudioResponseBodyAudioLayers, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AudioLayer'] = []
        if self.audio_layer is not None:
            for k in self.audio_layer:
                result['AudioLayer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.audio_layer = []
        if m.get('AudioLayer') is not None:
            for k in m.get('AudioLayer'):
                temp_model = DescribeCasterSceneAudioResponseBodyAudioLayersAudioLayer()
                self.audio_layer.append(temp_model.from_map(k))
        return self


class DescribeCasterSceneAudioResponseBodyMixList(TeaModel):
    def __init__(self, location_id=None):
        self.location_id = location_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterSceneAudioResponseBodyMixList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        return self


class DescribeCasterSceneAudioResponseBody(TeaModel):
    def __init__(self, audio_layers=None, caster_id=None, follow_enable=None, mix_list=None, request_id=None):
        self.audio_layers = audio_layers  # type: DescribeCasterSceneAudioResponseBodyAudioLayers
        self.caster_id = caster_id  # type: str
        self.follow_enable = follow_enable  # type: int
        self.mix_list = mix_list  # type: DescribeCasterSceneAudioResponseBodyMixList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.audio_layers:
            self.audio_layers.validate()
        if self.mix_list:
            self.mix_list.validate()

    def to_map(self):
        _map = super(DescribeCasterSceneAudioResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_layers is not None:
            result['AudioLayers'] = self.audio_layers.to_map()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.follow_enable is not None:
            result['FollowEnable'] = self.follow_enable
        if self.mix_list is not None:
            result['MixList'] = self.mix_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioLayers') is not None:
            temp_model = DescribeCasterSceneAudioResponseBodyAudioLayers()
            self.audio_layers = temp_model.from_map(m['AudioLayers'])
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('FollowEnable') is not None:
            self.follow_enable = m.get('FollowEnable')
        if m.get('MixList') is not None:
            temp_model = DescribeCasterSceneAudioResponseBodyMixList()
            self.mix_list = temp_model.from_map(m['MixList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCasterSceneAudioResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterSceneAudioResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterSceneAudioResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterSceneAudioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterScenesRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None, scene_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long
        self.scene_id = scene_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterScenesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        return self


class DescribeCasterScenesResponseBodySceneListSceneComponentIds(TeaModel):
    def __init__(self, component_id=None):
        self.component_id = component_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterScenesResponseBodySceneListSceneComponentIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_id is not None:
            result['componentId'] = self.component_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('componentId') is not None:
            self.component_id = m.get('componentId')
        return self


class DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo(TeaModel):
    def __init__(self, output_stream_url=None, transcode_config=None, video_format=None):
        self.output_stream_url = output_stream_url  # type: str
        self.transcode_config = transcode_config  # type: str
        self.video_format = video_format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_stream_url is not None:
            result['OutputStreamUrl'] = self.output_stream_url
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config
        if self.video_format is not None:
            result['VideoFormat'] = self.video_format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OutputStreamUrl') is not None:
            self.output_stream_url = m.get('OutputStreamUrl')
        if m.get('TranscodeConfig') is not None:
            self.transcode_config = m.get('TranscodeConfig')
        if m.get('VideoFormat') is not None:
            self.video_format = m.get('VideoFormat')
        return self


class DescribeCasterScenesResponseBodySceneListSceneStreamInfos(TeaModel):
    def __init__(self, stream_info=None):
        self.stream_info = stream_info  # type: list[DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo]

    def validate(self):
        if self.stream_info:
            for k in self.stream_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterScenesResponseBodySceneListSceneStreamInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamInfo'] = []
        if self.stream_info is not None:
            for k in self.stream_info:
                result['StreamInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.stream_info = []
        if m.get('StreamInfo') is not None:
            for k in m.get('StreamInfo'):
                temp_model = DescribeCasterScenesResponseBodySceneListSceneStreamInfosStreamInfo()
                self.stream_info.append(temp_model.from_map(k))
        return self


class DescribeCasterScenesResponseBodySceneListScene(TeaModel):
    def __init__(self, component_ids=None, layout_id=None, output_type=None, scene_id=None, scene_name=None,
                 status=None, stream_infos=None, stream_url=None):
        self.component_ids = component_ids  # type: DescribeCasterScenesResponseBodySceneListSceneComponentIds
        self.layout_id = layout_id  # type: str
        self.output_type = output_type  # type: str
        self.scene_id = scene_id  # type: str
        self.scene_name = scene_name  # type: str
        self.status = status  # type: int
        self.stream_infos = stream_infos  # type: DescribeCasterScenesResponseBodySceneListSceneStreamInfos
        self.stream_url = stream_url  # type: str

    def validate(self):
        if self.component_ids:
            self.component_ids.validate()
        if self.stream_infos:
            self.stream_infos.validate()

    def to_map(self):
        _map = super(DescribeCasterScenesResponseBodySceneListScene, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_ids is not None:
            result['ComponentIds'] = self.component_ids.to_map()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.scene_name is not None:
            result['SceneName'] = self.scene_name
        if self.status is not None:
            result['Status'] = self.status
        if self.stream_infos is not None:
            result['StreamInfos'] = self.stream_infos.to_map()
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ComponentIds') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneListSceneComponentIds()
            self.component_ids = temp_model.from_map(m['ComponentIds'])
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('SceneName') is not None:
            self.scene_name = m.get('SceneName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StreamInfos') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneListSceneStreamInfos()
            self.stream_infos = temp_model.from_map(m['StreamInfos'])
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterScenesResponseBodySceneList(TeaModel):
    def __init__(self, scene=None):
        self.scene = scene  # type: list[DescribeCasterScenesResponseBodySceneListScene]

    def validate(self):
        if self.scene:
            for k in self.scene:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterScenesResponseBodySceneList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Scene'] = []
        if self.scene is not None:
            for k in self.scene:
                result['Scene'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.scene = []
        if m.get('Scene') is not None:
            for k in m.get('Scene'):
                temp_model = DescribeCasterScenesResponseBodySceneListScene()
                self.scene.append(temp_model.from_map(k))
        return self


class DescribeCasterScenesResponseBody(TeaModel):
    def __init__(self, request_id=None, scene_list=None, total=None):
        self.request_id = request_id  # type: str
        self.scene_list = scene_list  # type: DescribeCasterScenesResponseBodySceneList
        self.total = total  # type: int

    def validate(self):
        if self.scene_list:
            self.scene_list.validate()

    def to_map(self):
        _map = super(DescribeCasterScenesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scene_list is not None:
            result['SceneList'] = self.scene_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SceneList') is not None:
            temp_model = DescribeCasterScenesResponseBodySceneList()
            self.scene_list = temp_model.from_map(m['SceneList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterScenesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterScenesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterScenesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterScenesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterStreamUrlRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterStreamUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo(TeaModel):
    def __init__(self, output_stream_url=None, transcode_config=None, video_format=None):
        self.output_stream_url = output_stream_url  # type: str
        self.transcode_config = transcode_config  # type: str
        self.video_format = video_format  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_stream_url is not None:
            result['OutputStreamUrl'] = self.output_stream_url
        if self.transcode_config is not None:
            result['TranscodeConfig'] = self.transcode_config
        if self.video_format is not None:
            result['VideoFormat'] = self.video_format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OutputStreamUrl') is not None:
            self.output_stream_url = m.get('OutputStreamUrl')
        if m.get('TranscodeConfig') is not None:
            self.transcode_config = m.get('TranscodeConfig')
        if m.get('VideoFormat') is not None:
            self.video_format = m.get('VideoFormat')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos(TeaModel):
    def __init__(self, stream_info=None):
        self.stream_info = stream_info  # type: list[DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo]

    def validate(self):
        if self.stream_info:
            for k in self.stream_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamInfo'] = []
        if self.stream_info is not None:
            for k in self.stream_info:
                result['StreamInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.stream_info = []
        if m.get('StreamInfo') is not None:
            for k in m.get('StreamInfo'):
                temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfosStreamInfo()
                self.stream_info.append(temp_model.from_map(k))
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream(TeaModel):
    def __init__(self, output_type=None, rtmp_url=None, scene_id=None, stream_infos=None, stream_url=None):
        self.output_type = output_type  # type: int
        self.rtmp_url = rtmp_url  # type: str
        self.scene_id = scene_id  # type: str
        self.stream_infos = stream_infos  # type: DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos
        self.stream_url = stream_url  # type: str

    def validate(self):
        if self.stream_infos:
            self.stream_infos.validate()

    def to_map(self):
        _map = super(DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.rtmp_url is not None:
            result['RtmpUrl'] = self.rtmp_url
        if self.scene_id is not None:
            result['SceneId'] = self.scene_id
        if self.stream_infos is not None:
            result['StreamInfos'] = self.stream_infos.to_map()
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('RtmpUrl') is not None:
            self.rtmp_url = m.get('RtmpUrl')
        if m.get('SceneId') is not None:
            self.scene_id = m.get('SceneId')
        if m.get('StreamInfos') is not None:
            temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStreamStreamInfos()
            self.stream_infos = temp_model.from_map(m['StreamInfos'])
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        return self


class DescribeCasterStreamUrlResponseBodyCasterStreams(TeaModel):
    def __init__(self, caster_stream=None):
        self.caster_stream = caster_stream  # type: list[DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream]

    def validate(self):
        if self.caster_stream:
            for k in self.caster_stream:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterStreamUrlResponseBodyCasterStreams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CasterStream'] = []
        if self.caster_stream is not None:
            for k in self.caster_stream:
                result['CasterStream'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.caster_stream = []
        if m.get('CasterStream') is not None:
            for k in m.get('CasterStream'):
                temp_model = DescribeCasterStreamUrlResponseBodyCasterStreamsCasterStream()
                self.caster_stream.append(temp_model.from_map(k))
        return self


class DescribeCasterStreamUrlResponseBody(TeaModel):
    def __init__(self, caster_id=None, caster_streams=None, request_id=None, total=None):
        self.caster_id = caster_id  # type: str
        self.caster_streams = caster_streams  # type: DescribeCasterStreamUrlResponseBodyCasterStreams
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.caster_streams:
            self.caster_streams.validate()

    def to_map(self):
        _map = super(DescribeCasterStreamUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_streams is not None:
            result['CasterStreams'] = self.caster_streams.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterStreams') is not None:
            temp_model = DescribeCasterStreamUrlResponseBodyCasterStreams()
            self.caster_streams = temp_model.from_map(m['CasterStreams'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCasterStreamUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterStreamUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterStreamUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterStreamUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterSyncGroupRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterSyncGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroupResourceIds(TeaModel):
    def __init__(self, resource_id=None):
        self.resource_id = resource_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroupResourceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroup(TeaModel):
    def __init__(self, host_resource_id=None, mode=None, resource_ids=None):
        self.host_resource_id = host_resource_id  # type: str
        self.mode = mode  # type: int
        self.resource_ids = resource_ids  # type: DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroupResourceIds

    def validate(self):
        if self.resource_ids:
            self.resource_ids.validate()

    def to_map(self):
        _map = super(DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_resource_id is not None:
            result['HostResourceId'] = self.host_resource_id
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HostResourceId') is not None:
            self.host_resource_id = m.get('HostResourceId')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ResourceIds') is not None:
            temp_model = DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroupResourceIds()
            self.resource_ids = temp_model.from_map(m['ResourceIds'])
        return self


class DescribeCasterSyncGroupResponseBodySyncGroups(TeaModel):
    def __init__(self, sync_group=None):
        self.sync_group = sync_group  # type: list[DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroup]

    def validate(self):
        if self.sync_group:
            for k in self.sync_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterSyncGroupResponseBodySyncGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SyncGroup'] = []
        if self.sync_group is not None:
            for k in self.sync_group:
                result['SyncGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sync_group = []
        if m.get('SyncGroup') is not None:
            for k in m.get('SyncGroup'):
                temp_model = DescribeCasterSyncGroupResponseBodySyncGroupsSyncGroup()
                self.sync_group.append(temp_model.from_map(k))
        return self


class DescribeCasterSyncGroupResponseBody(TeaModel):
    def __init__(self, caster_id=None, request_id=None, sync_groups=None):
        self.caster_id = caster_id  # type: str
        self.request_id = request_id  # type: str
        self.sync_groups = sync_groups  # type: DescribeCasterSyncGroupResponseBodySyncGroups

    def validate(self):
        if self.sync_groups:
            self.sync_groups.validate()

    def to_map(self):
        _map = super(DescribeCasterSyncGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sync_groups is not None:
            result['SyncGroups'] = self.sync_groups.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SyncGroups') is not None:
            temp_model = DescribeCasterSyncGroupResponseBodySyncGroups()
            self.sync_groups = temp_model.from_map(m['SyncGroups'])
        return self


class DescribeCasterSyncGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterSyncGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterSyncGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterSyncGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCasterVideoResourcesRequest(TeaModel):
    def __init__(self, caster_id=None, owner_id=None):
        self.caster_id = caster_id  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterVideoResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource(TeaModel):
    def __init__(self, begin_offset=None, end_offset=None, flv_url=None, live_stream_url=None, location_id=None,
                 material_id=None, pts_callback_interval=None, repeat_num=None, resource_id=None, resource_name=None,
                 vod_url=None):
        self.begin_offset = begin_offset  # type: int
        self.end_offset = end_offset  # type: int
        self.flv_url = flv_url  # type: str
        self.live_stream_url = live_stream_url  # type: str
        self.location_id = location_id  # type: str
        self.material_id = material_id  # type: str
        self.pts_callback_interval = pts_callback_interval  # type: int
        self.repeat_num = repeat_num  # type: int
        self.resource_id = resource_id  # type: str
        self.resource_name = resource_name  # type: str
        self.vod_url = vod_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_offset is not None:
            result['BeginOffset'] = self.begin_offset
        if self.end_offset is not None:
            result['EndOffset'] = self.end_offset
        if self.flv_url is not None:
            result['FlvUrl'] = self.flv_url
        if self.live_stream_url is not None:
            result['LiveStreamUrl'] = self.live_stream_url
        if self.location_id is not None:
            result['LocationId'] = self.location_id
        if self.material_id is not None:
            result['MaterialId'] = self.material_id
        if self.pts_callback_interval is not None:
            result['PtsCallbackInterval'] = self.pts_callback_interval
        if self.repeat_num is not None:
            result['RepeatNum'] = self.repeat_num
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.vod_url is not None:
            result['VodUrl'] = self.vod_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BeginOffset') is not None:
            self.begin_offset = m.get('BeginOffset')
        if m.get('EndOffset') is not None:
            self.end_offset = m.get('EndOffset')
        if m.get('FlvUrl') is not None:
            self.flv_url = m.get('FlvUrl')
        if m.get('LiveStreamUrl') is not None:
            self.live_stream_url = m.get('LiveStreamUrl')
        if m.get('LocationId') is not None:
            self.location_id = m.get('LocationId')
        if m.get('MaterialId') is not None:
            self.material_id = m.get('MaterialId')
        if m.get('PtsCallbackInterval') is not None:
            self.pts_callback_interval = m.get('PtsCallbackInterval')
        if m.get('RepeatNum') is not None:
            self.repeat_num = m.get('RepeatNum')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('VodUrl') is not None:
            self.vod_url = m.get('VodUrl')
        return self


class DescribeCasterVideoResourcesResponseBodyVideoResources(TeaModel):
    def __init__(self, video_resource=None):
        self.video_resource = video_resource  # type: list[DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource]

    def validate(self):
        if self.video_resource:
            for k in self.video_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCasterVideoResourcesResponseBodyVideoResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VideoResource'] = []
        if self.video_resource is not None:
            for k in self.video_resource:
                result['VideoResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.video_resource = []
        if m.get('VideoResource') is not None:
            for k in m.get('VideoResource'):
                temp_model = DescribeCasterVideoResourcesResponseBodyVideoResourcesVideoResource()
                self.video_resource.append(temp_model.from_map(k))
        return self


class DescribeCasterVideoResourcesResponseBody(TeaModel):
    def __init__(self, request_id=None, total=None, video_resources=None):
        self.request_id = request_id  # type: str
        self.total = total  # type: int
        self.video_resources = video_resources  # type: DescribeCasterVideoResourcesResponseBodyVideoResources

    def validate(self):
        if self.video_resources:
            self.video_resources.validate()

    def to_map(self):
        _map = super(DescribeCasterVideoResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.video_resources is not None:
            result['VideoResources'] = self.video_resources.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('VideoResources') is not None:
            temp_model = DescribeCasterVideoResourcesResponseBodyVideoResources()
            self.video_resources = temp_model.from_map(m['VideoResources'])
        return self


class DescribeCasterVideoResourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCasterVideoResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCasterVideoResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCasterVideoResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCastersRequest(TeaModel):
    def __init__(self, caster_id=None, caster_name=None, charge_type=None, end_time=None, norm_type=None,
                 order_by_modify_asc=None, owner_id=None, page_num=None, page_size=None, start_time=None, status=None):
        self.caster_id = caster_id  # type: str
        self.caster_name = caster_name  # type: str
        self.charge_type = charge_type  # type: int
        self.end_time = end_time  # type: str
        self.norm_type = norm_type  # type: str
        self.order_by_modify_asc = order_by_modify_asc  # type: str
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCastersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.norm_type is not None:
            result['NormType'] = self.norm_type
        if self.order_by_modify_asc is not None:
            result['OrderByModifyAsc'] = self.order_by_modify_asc
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NormType') is not None:
            self.norm_type = m.get('NormType')
        if m.get('OrderByModifyAsc') is not None:
            self.order_by_modify_asc = m.get('OrderByModifyAsc')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCastersResponseBodyCasterListCaster(TeaModel):
    def __init__(self, caster_id=None, caster_name=None, caster_template=None, channel_enable=None,
                 charge_type=None, create_time=None, duration=None, expire_time=None, last_modified=None, norm_type=None,
                 purchase_time=None, start_time=None, status=None):
        self.caster_id = caster_id  # type: str
        self.caster_name = caster_name  # type: str
        self.caster_template = caster_template  # type: str
        self.channel_enable = channel_enable  # type: int
        self.charge_type = charge_type  # type: str
        self.create_time = create_time  # type: str
        self.duration = duration  # type: str
        self.expire_time = expire_time  # type: str
        self.last_modified = last_modified  # type: str
        self.norm_type = norm_type  # type: int
        self.purchase_time = purchase_time  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCastersResponseBodyCasterListCaster, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_id is not None:
            result['CasterId'] = self.caster_id
        if self.caster_name is not None:
            result['CasterName'] = self.caster_name
        if self.caster_template is not None:
            result['CasterTemplate'] = self.caster_template
        if self.channel_enable is not None:
            result['ChannelEnable'] = self.channel_enable
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.last_modified is not None:
            result['LastModified'] = self.last_modified
        if self.norm_type is not None:
            result['NormType'] = self.norm_type
        if self.purchase_time is not None:
            result['PurchaseTime'] = self.purchase_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterId') is not None:
            self.caster_id = m.get('CasterId')
        if m.get('CasterName') is not None:
            self.caster_name = m.get('CasterName')
        if m.get('CasterTemplate') is not None:
            self.caster_template = m.get('CasterTemplate')
        if m.get('ChannelEnable') is not None:
            self.channel_enable = m.get('ChannelEnable')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('LastModified') is not None:
            self.last_modified = m.get('LastModified')
        if m.get('NormType') is not None:
            self.norm_type = m.get('NormType')
        if m.get('PurchaseTime') is not None:
            self.purchase_time = m.get('PurchaseTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCastersResponseBodyCasterList(TeaModel):
    def __init__(self, caster=None):
        self.caster = caster  # type: list[DescribeCastersResponseBodyCasterListCaster]

    def validate(self):
        if self.caster:
            for k in self.caster:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCastersResponseBodyCasterList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Caster'] = []
        if self.caster is not None:
            for k in self.caster:
                result['Caster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.caster = []
        if m.get('Caster') is not None:
            for k in m.get('Caster'):
                temp_model = DescribeCastersResponseBodyCasterListCaster()
                self.caster.append(temp_model.from_map(k))
        return self


class DescribeCastersResponseBody(TeaModel):
    def __init__(self, caster_list=None, request_id=None, total=None):
        self.caster_list = caster_list  # type: DescribeCastersResponseBodyCasterList
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.caster_list:
            self.caster_list.validate()

    def to_map(self):
        _map = super(DescribeCastersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caster_list is not None:
            result['CasterList'] = self.caster_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CasterList') is not None:
            temp_model = DescribeCastersResponseBodyCasterList()
            self.caster_list = temp_model.from_map(m['CasterList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeCastersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCastersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCastersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCastersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainUsageDataRequest(TeaModel):
    def __init__(self, area=None, data_protocol=None, domain_name=None, end_time=None, field=None, interval=None,
                 owner_id=None, start_time=None, type=None):
        self.area = area  # type: str
        self.data_protocol = data_protocol  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.field = field  # type: str
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainUsageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.data_protocol is not None:
            result['DataProtocol'] = self.data_protocol
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.field is not None:
            result['Field'] = self.field
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DataProtocol') is not None:
            self.data_protocol = m.get('DataProtocol')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Field') is not None:
            self.field = m.get('Field')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        self.time_stamp = time_stamp  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDomainUsageDataResponseBodyUsageDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDomainUsageDataResponseBodyUsageDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeDomainUsageDataResponseBodyUsageDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeDomainUsageDataResponseBody(TeaModel):
    def __init__(self, area=None, data_interval=None, domain_name=None, end_time=None, request_id=None,
                 start_time=None, type=None, usage_data_per_interval=None):
        self.area = area  # type: str
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str
        self.type = type  # type: str
        self.usage_data_per_interval = usage_data_per_interval  # type: DescribeDomainUsageDataResponseBodyUsageDataPerInterval

    def validate(self):
        if self.usage_data_per_interval:
            self.usage_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeDomainUsageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area is not None:
            result['Area'] = self.area
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.usage_data_per_interval is not None:
            result['UsageDataPerInterval'] = self.usage_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Area') is not None:
            self.area = m.get('Area')
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UsageDataPerInterval') is not None:
            temp_model = DescribeDomainUsageDataResponseBodyUsageDataPerInterval()
            self.usage_data_per_interval = temp_model.from_map(m['UsageDataPerInterval'])
        return self


class DescribeDomainUsageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDomainUsageDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDomainUsageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainWithIntegrityRequest(TeaModel):
    def __init__(self, end_time=None, integrity=None, owner_id=None, start_time=None):
        self.end_time = end_time  # type: str
        self.integrity = integrity  # type: float
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainWithIntegrityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.integrity is not None:
            result['Integrity'] = self.integrity
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Integrity') is not None:
            self.integrity = m.get('Integrity')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDomainWithIntegrityResponseBodyContent(TeaModel):
    def __init__(self, columns=None, name=None, points=None):
        self.columns = columns  # type: list[str]
        self.name = name  # type: str
        self.points = points  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDomainWithIntegrityResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.columns is not None:
            result['Columns'] = self.columns
        if self.name is not None:
            result['Name'] = self.name
        if self.points is not None:
            result['Points'] = self.points
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Columns') is not None:
            self.columns = m.get('Columns')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Points') is not None:
            self.points = m.get('Points')
        return self


class DescribeDomainWithIntegrityResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        self.content = content  # type: list[DescribeDomainWithIntegrityResponseBodyContent]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            for k in self.content:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDomainWithIntegrityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Content'] = []
        if self.content is not None:
            for k in self.content:
                result['Content'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.content = []
        if m.get('Content') is not None:
            for k in m.get('Content'):
                temp_model = DescribeDomainWithIntegrityResponseBodyContent()
                self.content.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDomainWithIntegrityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDomainWithIntegrityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDomainWithIntegrityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainWithIntegrityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeForbidPushStreamRoomListRequest(TeaModel):
    def __init__(self, app_id=None, order=None, owner_id=None, page_num=None, page_size=None):
        self.app_id = app_id  # type: str
        self.order = order  # type: str
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeForbidPushStreamRoomListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.order is not None:
            result['Order'] = self.order
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeForbidPushStreamRoomListResponseBodyRoomList(TeaModel):
    def __init__(self, anchor_id=None, op_end_time=None, op_start_time=None, room_id=None):
        self.anchor_id = anchor_id  # type: str
        self.op_end_time = op_end_time  # type: str
        self.op_start_time = op_start_time  # type: str
        self.room_id = room_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeForbidPushStreamRoomListResponseBodyRoomList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.anchor_id is not None:
            result['AnchorId'] = self.anchor_id
        if self.op_end_time is not None:
            result['OpEndTime'] = self.op_end_time
        if self.op_start_time is not None:
            result['OpStartTime'] = self.op_start_time
        if self.room_id is not None:
            result['RoomId'] = self.room_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnchorId') is not None:
            self.anchor_id = m.get('AnchorId')
        if m.get('OpEndTime') is not None:
            self.op_end_time = m.get('OpEndTime')
        if m.get('OpStartTime') is not None:
            self.op_start_time = m.get('OpStartTime')
        if m.get('RoomId') is not None:
            self.room_id = m.get('RoomId')
        return self


class DescribeForbidPushStreamRoomListResponseBody(TeaModel):
    def __init__(self, request_id=None, room_list=None, total_num=None, total_page=None):
        self.request_id = request_id  # type: str
        self.room_list = room_list  # type: list[DescribeForbidPushStreamRoomListResponseBodyRoomList]
        self.total_num = total_num  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.room_list:
            for k in self.room_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeForbidPushStreamRoomListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RoomList'] = []
        if self.room_list is not None:
            for k in self.room_list:
                result['RoomList'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.room_list = []
        if m.get('RoomList') is not None:
            for k in m.get('RoomList'):
                temp_model = DescribeForbidPushStreamRoomListResponseBodyRoomList()
                self.room_list.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeForbidPushStreamRoomListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeForbidPushStreamRoomListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeForbidPushStreamRoomListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeForbidPushStreamRoomListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHlsLiveStreamRealTimeBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, time=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.time = time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHlsLiveStreamRealTimeBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos(TeaModel):
    def __init__(self, down_flow=None, online=None, rate=None):
        self.down_flow = down_flow  # type: float
        self.online = online  # type: float
        self.rate = rate  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.down_flow is not None:
            result['DownFlow'] = self.down_flow
        if self.online is not None:
            result['Online'] = self.online
        if self.rate is not None:
            result['Rate'] = self.rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DownFlow') is not None:
            self.down_flow = m.get('DownFlow')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('Rate') is not None:
            self.rate = m.get('Rate')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos(TeaModel):
    def __init__(self, infos=None, stream_name=None):
        self.infos = infos  # type: list[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos]
        self.stream_name = stream_name  # type: str

    def validate(self):
        if self.infos:
            for k in self.infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Infos'] = []
        if self.infos is not None:
            for k in self.infos:
                result['Infos'].append(k.to_map() if k else None)
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.infos = []
        if m.get('Infos') is not None:
            for k in m.get('Infos'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfosInfos()
                self.infos.append(temp_model.from_map(k))
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData(TeaModel):
    def __init__(self, domain_name=None, stream_infos=None):
        self.domain_name = domain_name  # type: str
        self.stream_infos = stream_infos  # type: list[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos]

    def validate(self):
        if self.stream_infos:
            for k in self.stream_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        result['StreamInfos'] = []
        if self.stream_infos is not None:
            for k in self.stream_infos:
                result['StreamInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        self.stream_infos = []
        if m.get('StreamInfos') is not None:
            for k in m.get('StreamInfos'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageDataStreamInfos()
                self.stream_infos.append(temp_model.from_map(k))
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponseBody(TeaModel):
    def __init__(self, request_id=None, time=None, usage_data=None):
        self.request_id = request_id  # type: str
        self.time = time  # type: str
        self.usage_data = usage_data  # type: list[DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData]

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHlsLiveStreamRealTimeBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time is not None:
            result['Time'] = self.time
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBodyUsageData()
                self.usage_data.append(temp_model.from_map(k))
        return self


class DescribeHlsLiveStreamRealTimeBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeHlsLiveStreamRealTimeBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHlsLiveStreamRealTimeBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHlsLiveStreamRealTimeBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAudioAuditConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveAudioAuditConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes(TeaModel):
    def __init__(self, scene=None):
        self.scene = scene  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig(TeaModel):
    def __init__(self, app_name=None, biz_type=None, domain_name=None, scenes=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.biz_type = biz_type  # type: str
        self.domain_name = domain_name  # type: str
        self.scenes = scenes  # type: DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes
        self.stream_name = stream_name  # type: str

    def validate(self):
        if self.scenes:
            self.scenes.validate()

    def to_map(self):
        _map = super(DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.scenes is not None:
            result['Scenes'] = self.scenes.to_map()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Scenes') is not None:
            temp_model = DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfigScenes()
            self.scenes = temp_model.from_map(m['Scenes'])
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList(TeaModel):
    def __init__(self, live_audio_audit_config=None):
        self.live_audio_audit_config = live_audio_audit_config  # type: list[DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig]

    def validate(self):
        if self.live_audio_audit_config:
            for k in self.live_audio_audit_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveAudioAuditConfig'] = []
        if self.live_audio_audit_config is not None:
            for k in self.live_audio_audit_config:
                result['LiveAudioAuditConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_audio_audit_config = []
        if m.get('LiveAudioAuditConfig') is not None:
            for k in m.get('LiveAudioAuditConfig'):
                temp_model = DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigListLiveAudioAuditConfig()
                self.live_audio_audit_config.append(temp_model.from_map(k))
        return self


class DescribeLiveAudioAuditConfigResponseBody(TeaModel):
    def __init__(self, live_audio_audit_config_list=None, request_id=None):
        self.live_audio_audit_config_list = live_audio_audit_config_list  # type: DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_audio_audit_config_list:
            self.live_audio_audit_config_list.validate()

    def to_map(self):
        _map = super(DescribeLiveAudioAuditConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_audio_audit_config_list is not None:
            result['LiveAudioAuditConfigList'] = self.live_audio_audit_config_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveAudioAuditConfigList') is not None:
            temp_model = DescribeLiveAudioAuditConfigResponseBodyLiveAudioAuditConfigList()
            self.live_audio_audit_config_list = temp_model.from_map(m['LiveAudioAuditConfigList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveAudioAuditConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveAudioAuditConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveAudioAuditConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveAudioAuditConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveAudioAuditNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveAudioAuditNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigListLiveAudioAuditNotifyConfig(TeaModel):
    def __init__(self, callback=None, callback_template=None, domain_name=None):
        self.callback = callback  # type: str
        self.callback_template = callback_template  # type: str
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigListLiveAudioAuditNotifyConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callback is not None:
            result['Callback'] = self.callback
        if self.callback_template is not None:
            result['CallbackTemplate'] = self.callback_template
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        if m.get('CallbackTemplate') is not None:
            self.callback_template = m.get('CallbackTemplate')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigList(TeaModel):
    def __init__(self, live_audio_audit_notify_config=None):
        self.live_audio_audit_notify_config = live_audio_audit_notify_config  # type: list[DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigListLiveAudioAuditNotifyConfig]

    def validate(self):
        if self.live_audio_audit_notify_config:
            for k in self.live_audio_audit_notify_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveAudioAuditNotifyConfig'] = []
        if self.live_audio_audit_notify_config is not None:
            for k in self.live_audio_audit_notify_config:
                result['LiveAudioAuditNotifyConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_audio_audit_notify_config = []
        if m.get('LiveAudioAuditNotifyConfig') is not None:
            for k in m.get('LiveAudioAuditNotifyConfig'):
                temp_model = DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigListLiveAudioAuditNotifyConfig()
                self.live_audio_audit_notify_config.append(temp_model.from_map(k))
        return self


class DescribeLiveAudioAuditNotifyConfigResponseBody(TeaModel):
    def __init__(self, live_audio_audit_notify_config_list=None, request_id=None):
        self.live_audio_audit_notify_config_list = live_audio_audit_notify_config_list  # type: DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_audio_audit_notify_config_list:
            self.live_audio_audit_notify_config_list.validate()

    def to_map(self):
        _map = super(DescribeLiveAudioAuditNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_audio_audit_notify_config_list is not None:
            result['LiveAudioAuditNotifyConfigList'] = self.live_audio_audit_notify_config_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveAudioAuditNotifyConfigList') is not None:
            temp_model = DescribeLiveAudioAuditNotifyConfigResponseBodyLiveAudioAuditNotifyConfigList()
            self.live_audio_audit_notify_config_list = temp_model.from_map(m['LiveAudioAuditNotifyConfigList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveAudioAuditNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveAudioAuditNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveAudioAuditNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveAudioAuditNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveCertificateDetailRequest(TeaModel):
    def __init__(self, cert_name=None, owner_id=None, security_token=None):
        self.cert_name = cert_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveCertificateDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeLiveCertificateDetailResponseBody(TeaModel):
    def __init__(self, cert=None, cert_id=None, cert_name=None, request_id=None):
        self.cert = cert  # type: str
        self.cert_id = cert_id  # type: long
        self.cert_name = cert_name  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveCertificateDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert is not None:
            result['Cert'] = self.cert
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cert') is not None:
            self.cert = m.get('Cert')
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveCertificateDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveCertificateDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveCertificateDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveCertificateDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveCertificateListRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveCertificateListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeLiveCertificateListResponseBodyCertificateListModelCertListCert(TeaModel):
    def __init__(self, cert_id=None, cert_name=None, common=None, fingerprint=None, issuer=None, last_time=None):
        self.cert_id = cert_id  # type: long
        self.cert_name = cert_name  # type: str
        self.common = common  # type: str
        self.fingerprint = fingerprint  # type: str
        self.issuer = issuer  # type: str
        self.last_time = last_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveCertificateListResponseBodyCertificateListModelCertListCert, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.common is not None:
            result['Common'] = self.common
        if self.fingerprint is not None:
            result['Fingerprint'] = self.fingerprint
        if self.issuer is not None:
            result['Issuer'] = self.issuer
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Common') is not None:
            self.common = m.get('Common')
        if m.get('Fingerprint') is not None:
            self.fingerprint = m.get('Fingerprint')
        if m.get('Issuer') is not None:
            self.issuer = m.get('Issuer')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        return self


class DescribeLiveCertificateListResponseBodyCertificateListModelCertList(TeaModel):
    def __init__(self, cert=None):
        self.cert = cert  # type: list[DescribeLiveCertificateListResponseBodyCertificateListModelCertListCert]

    def validate(self):
        if self.cert:
            for k in self.cert:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveCertificateListResponseBodyCertificateListModelCertList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cert'] = []
        if self.cert is not None:
            for k in self.cert:
                result['Cert'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert = []
        if m.get('Cert') is not None:
            for k in m.get('Cert'):
                temp_model = DescribeLiveCertificateListResponseBodyCertificateListModelCertListCert()
                self.cert.append(temp_model.from_map(k))
        return self


class DescribeLiveCertificateListResponseBodyCertificateListModel(TeaModel):
    def __init__(self, cert_list=None, count=None):
        self.cert_list = cert_list  # type: DescribeLiveCertificateListResponseBodyCertificateListModelCertList
        self.count = count  # type: int

    def validate(self):
        if self.cert_list:
            self.cert_list.validate()

    def to_map(self):
        _map = super(DescribeLiveCertificateListResponseBodyCertificateListModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_list is not None:
            result['CertList'] = self.cert_list.to_map()
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertList') is not None:
            temp_model = DescribeLiveCertificateListResponseBodyCertificateListModelCertList()
            self.cert_list = temp_model.from_map(m['CertList'])
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class DescribeLiveCertificateListResponseBody(TeaModel):
    def __init__(self, certificate_list_model=None, request_id=None):
        self.certificate_list_model = certificate_list_model  # type: DescribeLiveCertificateListResponseBodyCertificateListModel
        self.request_id = request_id  # type: str

    def validate(self):
        if self.certificate_list_model:
            self.certificate_list_model.validate()

    def to_map(self):
        _map = super(DescribeLiveCertificateListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.certificate_list_model is not None:
            result['CertificateListModel'] = self.certificate_list_model.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertificateListModel') is not None:
            temp_model = DescribeLiveCertificateListResponseBodyCertificateListModel()
            self.certificate_list_model = temp_model.from_map(m['CertificateListModel'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveCertificateListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveCertificateListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveCertificateListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveCertificateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDetectNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDetectNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeLiveDetectNotifyConfigResponseBodyLiveDetectNotifyConfig(TeaModel):
    def __init__(self, domain_name=None, notify_url=None):
        self.domain_name = domain_name  # type: str
        self.notify_url = notify_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDetectNotifyConfigResponseBodyLiveDetectNotifyConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        return self


class DescribeLiveDetectNotifyConfigResponseBody(TeaModel):
    def __init__(self, live_detect_notify_config=None, request_id=None):
        self.live_detect_notify_config = live_detect_notify_config  # type: DescribeLiveDetectNotifyConfigResponseBodyLiveDetectNotifyConfig
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_detect_notify_config:
            self.live_detect_notify_config.validate()

    def to_map(self):
        _map = super(DescribeLiveDetectNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_detect_notify_config is not None:
            result['LiveDetectNotifyConfig'] = self.live_detect_notify_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveDetectNotifyConfig') is not None:
            temp_model = DescribeLiveDetectNotifyConfigResponseBodyLiveDetectNotifyConfig()
            self.live_detect_notify_config = temp_model.from_map(m['LiveDetectNotifyConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDetectNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDetectNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDetectNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDetectNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDetectPornDataRequest(TeaModel):
    def __init__(self, app=None, domain_name=None, end_time=None, fee=None, owner_id=None, region=None, scene=None,
                 split_by=None, start_time=None, stream=None):
        self.app = app  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.fee = fee  # type: str
        self.owner_id = owner_id  # type: long
        self.region = region  # type: str
        self.scene = scene  # type: str
        self.split_by = split_by  # type: str
        self.start_time = start_time  # type: str
        self.stream = stream  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDetectPornDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.fee is not None:
            result['Fee'] = self.fee
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.split_by is not None:
            result['SplitBy'] = self.split_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream is not None:
            result['Stream'] = self.stream
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Fee') is not None:
            self.fee = m.get('Fee')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('SplitBy') is not None:
            self.split_by = m.get('SplitBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        return self


class DescribeLiveDetectPornDataResponseBodyDetectPornDataDataModule(TeaModel):
    def __init__(self, app=None, count=None, domain=None, fee=None, region=None, scene=None, stream=None,
                 time_stamp=None):
        self.app = app  # type: str
        self.count = count  # type: long
        self.domain = domain  # type: str
        self.fee = fee  # type: str
        self.region = region  # type: str
        self.scene = scene  # type: str
        self.stream = stream  # type: str
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDetectPornDataResponseBodyDetectPornDataDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app is not None:
            result['App'] = self.app
        if self.count is not None:
            result['Count'] = self.count
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.fee is not None:
            result['Fee'] = self.fee
        if self.region is not None:
            result['Region'] = self.region
        if self.scene is not None:
            result['Scene'] = self.scene
        if self.stream is not None:
            result['Stream'] = self.stream
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Fee') is not None:
            self.fee = m.get('Fee')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Scene') is not None:
            self.scene = m.get('Scene')
        if m.get('Stream') is not None:
            self.stream = m.get('Stream')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDetectPornDataResponseBodyDetectPornData(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDetectPornDataResponseBodyDetectPornDataDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDetectPornDataResponseBodyDetectPornData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDetectPornDataResponseBodyDetectPornDataDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDetectPornDataResponseBody(TeaModel):
    def __init__(self, detect_porn_data=None, request_id=None):
        self.detect_porn_data = detect_porn_data  # type: DescribeLiveDetectPornDataResponseBodyDetectPornData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.detect_porn_data:
            self.detect_porn_data.validate()

    def to_map(self):
        _map = super(DescribeLiveDetectPornDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detect_porn_data is not None:
            result['DetectPornData'] = self.detect_porn_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DetectPornData') is not None:
            temp_model = DescribeLiveDetectPornDataResponseBodyDetectPornData()
            self.detect_porn_data = temp_model.from_map(m['DetectPornData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDetectPornDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDetectPornDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDetectPornDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDetectPornDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainBpsDataResponseBodyBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, bps_value=None, http_bps_value=None, https_bps_value=None, time_stamp=None):
        self.bps_value = bps_value  # type: str
        self.http_bps_value = http_bps_value  # type: str
        self.https_bps_value = https_bps_value  # type: str
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataResponseBodyBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_value is not None:
            result['BpsValue'] = self.bps_value
        if self.http_bps_value is not None:
            result['HttpBpsValue'] = self.http_bps_value
        if self.https_bps_value is not None:
            result['HttpsBpsValue'] = self.https_bps_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsValue') is not None:
            self.bps_value = m.get('BpsValue')
        if m.get('HttpBpsValue') is not None:
            self.http_bps_value = m.get('HttpBpsValue')
        if m.get('HttpsBpsValue') is not None:
            self.https_bps_value = m.get('HttpsBpsValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainBpsDataResponseBodyBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainBpsDataResponseBodyBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataResponseBodyBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainBpsDataResponseBodyBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainBpsDataResponseBody(TeaModel):
    def __init__(self, bps_data_per_interval=None, data_interval=None, domain_name=None, end_time=None,
                 request_id=None, start_time=None):
        self.bps_data_per_interval = bps_data_per_interval  # type: DescribeLiveDomainBpsDataResponseBodyBpsDataPerInterval
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bps_data_per_interval:
            self.bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_per_interval is not None:
            result['BpsDataPerInterval'] = self.bps_data_per_interval.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataPerInterval') is not None:
            temp_model = DescribeLiveDomainBpsDataResponseBodyBpsDataPerInterval()
            self.bps_data_per_interval = temp_model.from_map(m['BpsDataPerInterval'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainBpsDataByLayerRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, layer=None,
                 location_name_en=None, owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.layer = layer  # type: str
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByLayerRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainBpsDataByLayerResponseBodyBpsDataIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, traffic_value=None, value=None):
        self.time_stamp = time_stamp  # type: str
        self.traffic_value = traffic_value  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByLayerResponseBodyBpsDataIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.traffic_value is not None:
            result['TrafficValue'] = self.traffic_value
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TrafficValue') is not None:
            self.traffic_value = m.get('TrafficValue')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLiveDomainBpsDataByLayerResponseBodyBpsDataInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainBpsDataByLayerResponseBodyBpsDataIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByLayerResponseBodyBpsDataInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainBpsDataByLayerResponseBodyBpsDataIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainBpsDataByLayerResponseBody(TeaModel):
    def __init__(self, bps_data_interval=None, data_interval=None, request_id=None):
        self.bps_data_interval = bps_data_interval  # type: DescribeLiveDomainBpsDataByLayerResponseBodyBpsDataInterval
        self.data_interval = data_interval  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.bps_data_interval:
            self.bps_data_interval.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByLayerResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_interval is not None:
            result['BpsDataInterval'] = self.bps_data_interval.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataInterval') is not None:
            temp_model = DescribeLiveDomainBpsDataByLayerResponseBodyBpsDataInterval()
            self.bps_data_interval = temp_model.from_map(m['BpsDataInterval'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainBpsDataByLayerResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainBpsDataByLayerResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByLayerResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainBpsDataByLayerResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainBpsDataByTimeStampRequest(TeaModel):
    def __init__(self, domain_name=None, isp_names=None, location_names=None, owner_id=None, time_point=None):
        self.domain_name = domain_name  # type: str
        self.isp_names = isp_names  # type: str
        self.location_names = location_names  # type: str
        self.owner_id = owner_id  # type: long
        self.time_point = time_point  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByTimeStampRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.isp_names is not None:
            result['IspNames'] = self.isp_names
        if self.location_names is not None:
            result['LocationNames'] = self.location_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('IspNames') is not None:
            self.isp_names = m.get('IspNames')
        if m.get('LocationNames') is not None:
            self.location_names = m.get('LocationNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataListBpsDataModel(TeaModel):
    def __init__(self, bps=None, isp_name=None, location_name=None, time_stamp=None):
        self.bps = bps  # type: long
        self.isp_name = isp_name  # type: str
        self.location_name = location_name  # type: str
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataListBpsDataModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        if self.location_name is not None:
            result['LocationName'] = self.location_name
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        if m.get('LocationName') is not None:
            self.location_name = m.get('LocationName')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataList(TeaModel):
    def __init__(self, bps_data_model=None):
        self.bps_data_model = bps_data_model  # type: list[DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataListBpsDataModel]

    def validate(self):
        if self.bps_data_model:
            for k in self.bps_data_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BpsDataModel'] = []
        if self.bps_data_model is not None:
            for k in self.bps_data_model:
                result['BpsDataModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bps_data_model = []
        if m.get('BpsDataModel') is not None:
            for k in m.get('BpsDataModel'):
                temp_model = DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataListBpsDataModel()
                self.bps_data_model.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainBpsDataByTimeStampResponseBody(TeaModel):
    def __init__(self, bps_data_list=None, domain_name=None, request_id=None, time_stamp=None):
        self.bps_data_list = bps_data_list  # type: DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataList
        self.domain_name = domain_name  # type: str
        self.request_id = request_id  # type: str
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        if self.bps_data_list:
            self.bps_data_list.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByTimeStampResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_list is not None:
            result['BpsDataList'] = self.bps_data_list.to_map()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataList') is not None:
            temp_model = DescribeLiveDomainBpsDataByTimeStampResponseBodyBpsDataList()
            self.bps_data_list = temp_model.from_map(m['BpsDataList'])
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainBpsDataByTimeStampResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainBpsDataByTimeStampResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainBpsDataByTimeStampResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainBpsDataByTimeStampResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainCertificateInfoRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainCertificateInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveDomainCertificateInfoResponseBodyCertInfosCertInfo(TeaModel):
    def __init__(self, cert_domain_name=None, cert_expire_time=None, cert_life=None, cert_name=None, cert_org=None,
                 cert_type=None, domain_name=None, sslprotocol=None, sslpub=None, status=None):
        self.cert_domain_name = cert_domain_name  # type: str
        self.cert_expire_time = cert_expire_time  # type: str
        self.cert_life = cert_life  # type: str
        self.cert_name = cert_name  # type: str
        self.cert_org = cert_org  # type: str
        self.cert_type = cert_type  # type: str
        self.domain_name = domain_name  # type: str
        self.sslprotocol = sslprotocol  # type: str
        self.sslpub = sslpub  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainCertificateInfoResponseBodyCertInfosCertInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_domain_name is not None:
            result['CertDomainName'] = self.cert_domain_name
        if self.cert_expire_time is not None:
            result['CertExpireTime'] = self.cert_expire_time
        if self.cert_life is not None:
            result['CertLife'] = self.cert_life
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cert_org is not None:
            result['CertOrg'] = self.cert_org
        if self.cert_type is not None:
            result['CertType'] = self.cert_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertDomainName') is not None:
            self.cert_domain_name = m.get('CertDomainName')
        if m.get('CertExpireTime') is not None:
            self.cert_expire_time = m.get('CertExpireTime')
        if m.get('CertLife') is not None:
            self.cert_life = m.get('CertLife')
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('CertOrg') is not None:
            self.cert_org = m.get('CertOrg')
        if m.get('CertType') is not None:
            self.cert_type = m.get('CertType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeLiveDomainCertificateInfoResponseBodyCertInfos(TeaModel):
    def __init__(self, cert_info=None):
        self.cert_info = cert_info  # type: list[DescribeLiveDomainCertificateInfoResponseBodyCertInfosCertInfo]

    def validate(self):
        if self.cert_info:
            for k in self.cert_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainCertificateInfoResponseBodyCertInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CertInfo'] = []
        if self.cert_info is not None:
            for k in self.cert_info:
                result['CertInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cert_info = []
        if m.get('CertInfo') is not None:
            for k in m.get('CertInfo'):
                temp_model = DescribeLiveDomainCertificateInfoResponseBodyCertInfosCertInfo()
                self.cert_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainCertificateInfoResponseBody(TeaModel):
    def __init__(self, cert_infos=None, request_id=None):
        self.cert_infos = cert_infos  # type: DescribeLiveDomainCertificateInfoResponseBodyCertInfos
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cert_infos:
            self.cert_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainCertificateInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_infos is not None:
            result['CertInfos'] = self.cert_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertInfos') is not None:
            temp_model = DescribeLiveDomainCertificateInfoResponseBodyCertInfos()
            self.cert_infos = temp_model.from_map(m['CertInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainCertificateInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainCertificateInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainCertificateInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainCertificateInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainConfigsRequest(TeaModel):
    def __init__(self, domain_name=None, function_names=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.function_names = function_names  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg(TeaModel):
    def __init__(self, arg_name=None, arg_value=None):
        self.arg_name = arg_name  # type: str
        self.arg_value = arg_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg_name is not None:
            result['ArgName'] = self.arg_name
        if self.arg_value is not None:
            result['ArgValue'] = self.arg_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArgName') is not None:
            self.arg_name = m.get('ArgName')
        if m.get('ArgValue') is not None:
            self.arg_value = m.get('ArgValue')
        return self


class DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs(TeaModel):
    def __init__(self, function_arg=None):
        self.function_arg = function_arg  # type: list[DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg]

    def validate(self):
        if self.function_arg:
            for k in self.function_arg:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FunctionArg'] = []
        if self.function_arg is not None:
            for k in self.function_arg:
                result['FunctionArg'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.function_arg = []
        if m.get('FunctionArg') is not None:
            for k in m.get('FunctionArg'):
                temp_model = DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgsFunctionArg()
                self.function_arg.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfig(TeaModel):
    def __init__(self, config_id=None, function_args=None, function_name=None, status=None):
        self.config_id = config_id  # type: str
        self.function_args = function_args  # type: DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs
        self.function_name = function_name  # type: str
        self.status = status  # type: str

    def validate(self):
        if self.function_args:
            self.function_args.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.function_args is not None:
            result['FunctionArgs'] = self.function_args.to_map()
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('FunctionArgs') is not None:
            temp_model = DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfigFunctionArgs()
            self.function_args = temp_model.from_map(m['FunctionArgs'])
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeLiveDomainConfigsResponseBodyDomainConfigs(TeaModel):
    def __init__(self, domain_config=None):
        self.domain_config = domain_config  # type: list[DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfig]

    def validate(self):
        if self.domain_config:
            for k in self.domain_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainConfigsResponseBodyDomainConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainConfig'] = []
        if self.domain_config is not None:
            for k in self.domain_config:
                result['DomainConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_config = []
        if m.get('DomainConfig') is not None:
            for k in m.get('DomainConfig'):
                temp_model = DescribeLiveDomainConfigsResponseBodyDomainConfigsDomainConfig()
                self.domain_config.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainConfigsResponseBody(TeaModel):
    def __init__(self, domain_configs=None, request_id=None):
        self.domain_configs = domain_configs  # type: DescribeLiveDomainConfigsResponseBodyDomainConfigs
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_configs:
            self.domain_configs.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_configs is not None:
            result['DomainConfigs'] = self.domain_configs.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainConfigs') is not None:
            temp_model = DescribeLiveDomainConfigsResponseBodyDomainConfigs()
            self.domain_configs = temp_model.from_map(m['DomainConfigs'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainDetailRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeLiveDomainDetailResponseBodyDomainDetail(TeaModel):
    def __init__(self, cert_name=None, cname=None, description=None, domain_name=None, domain_status=None,
                 gmt_created=None, gmt_modified=None, live_domain_type=None, region=None, sslprotocol=None, sslpub=None,
                 scope=None):
        self.cert_name = cert_name  # type: str
        self.cname = cname  # type: str
        self.description = description  # type: str
        self.domain_name = domain_name  # type: str
        self.domain_status = domain_status  # type: str
        self.gmt_created = gmt_created  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.live_domain_type = live_domain_type  # type: str
        self.region = region  # type: str
        self.sslprotocol = sslprotocol  # type: str
        self.sslpub = sslpub  # type: str
        self.scope = scope  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainDetailResponseBodyDomainDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.description is not None:
            result['Description'] = self.description
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_status is not None:
            result['DomainStatus'] = self.domain_status
        if self.gmt_created is not None:
            result['GmtCreated'] = self.gmt_created
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.live_domain_type is not None:
            result['LiveDomainType'] = self.live_domain_type
        if self.region is not None:
            result['Region'] = self.region
        if self.sslprotocol is not None:
            result['SSLProtocol'] = self.sslprotocol
        if self.sslpub is not None:
            result['SSLPub'] = self.sslpub
        if self.scope is not None:
            result['Scope'] = self.scope
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainStatus') is not None:
            self.domain_status = m.get('DomainStatus')
        if m.get('GmtCreated') is not None:
            self.gmt_created = m.get('GmtCreated')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('LiveDomainType') is not None:
            self.live_domain_type = m.get('LiveDomainType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SSLProtocol') is not None:
            self.sslprotocol = m.get('SSLProtocol')
        if m.get('SSLPub') is not None:
            self.sslpub = m.get('SSLPub')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        return self


class DescribeLiveDomainDetailResponseBody(TeaModel):
    def __init__(self, domain_detail=None, request_id=None):
        self.domain_detail = domain_detail  # type: DescribeLiveDomainDetailResponseBodyDomainDetail
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_detail:
            self.domain_detail.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_detail is not None:
            result['DomainDetail'] = self.domain_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainDetail') is not None:
            temp_model = DescribeLiveDomainDetailResponseBodyDomainDetail()
            self.domain_detail = temp_model.from_map(m['DomainDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainFrameRateAndBitRateDataRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, query_time=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.query_time = query_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainFrameRateAndBitRateDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.query_time is not None:
            result['QueryTime'] = self.query_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QueryTime') is not None:
            self.query_time = m.get('QueryTime')
        return self


class DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo(TeaModel):
    def __init__(self, audio_frame_rate=None, bit_rate=None, stream_url=None, video_frame_rate=None):
        self.audio_frame_rate = audio_frame_rate  # type: float
        self.bit_rate = bit_rate  # type: float
        self.stream_url = stream_url  # type: str
        self.video_frame_rate = video_frame_rate  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_frame_rate is not None:
            result['AudioFrameRate'] = self.audio_frame_rate
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        if self.video_frame_rate is not None:
            result['VideoFrameRate'] = self.video_frame_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFrameRate') is not None:
            self.audio_frame_rate = m.get('AudioFrameRate')
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        if m.get('VideoFrameRate') is not None:
            self.video_frame_rate = m.get('VideoFrameRate')
        return self


class DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos(TeaModel):
    def __init__(self, frame_rate_and_bit_rate_info=None):
        self.frame_rate_and_bit_rate_info = frame_rate_and_bit_rate_info  # type: list[DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo]

    def validate(self):
        if self.frame_rate_and_bit_rate_info:
            for k in self.frame_rate_and_bit_rate_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FrameRateAndBitRateInfo'] = []
        if self.frame_rate_and_bit_rate_info is not None:
            for k in self.frame_rate_and_bit_rate_info:
                result['FrameRateAndBitRateInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.frame_rate_and_bit_rate_info = []
        if m.get('FrameRateAndBitRateInfo') is not None:
            for k in m.get('FrameRateAndBitRateInfo'):
                temp_model = DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo()
                self.frame_rate_and_bit_rate_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainFrameRateAndBitRateDataResponseBody(TeaModel):
    def __init__(self, frame_rate_and_bit_rate_infos=None, request_id=None):
        self.frame_rate_and_bit_rate_infos = frame_rate_and_bit_rate_infos  # type: DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos
        self.request_id = request_id  # type: str

    def validate(self):
        if self.frame_rate_and_bit_rate_infos:
            self.frame_rate_and_bit_rate_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainFrameRateAndBitRateDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.frame_rate_and_bit_rate_infos is not None:
            result['FrameRateAndBitRateInfos'] = self.frame_rate_and_bit_rate_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FrameRateAndBitRateInfos') is not None:
            temp_model = DescribeLiveDomainFrameRateAndBitRateDataResponseBodyFrameRateAndBitRateInfos()
            self.frame_rate_and_bit_rate_infos = temp_model.from_map(m['FrameRateAndBitRateInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainFrameRateAndBitRateDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainFrameRateAndBitRateDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainFrameRateAndBitRateDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainFrameRateAndBitRateDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainLimitRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainLimitRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveDomainLimitResponseBodyLiveDomainLimitListLiveDomainLimit(TeaModel):
    def __init__(self, domain_name=None, limit_num=None, limit_transcode_num=None, limit_transfer_num=None):
        self.domain_name = domain_name  # type: str
        self.limit_num = limit_num  # type: int
        self.limit_transcode_num = limit_transcode_num  # type: int
        self.limit_transfer_num = limit_transfer_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainLimitResponseBodyLiveDomainLimitListLiveDomainLimit, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.limit_num is not None:
            result['LimitNum'] = self.limit_num
        if self.limit_transcode_num is not None:
            result['LimitTranscodeNum'] = self.limit_transcode_num
        if self.limit_transfer_num is not None:
            result['LimitTransferNum'] = self.limit_transfer_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LimitNum') is not None:
            self.limit_num = m.get('LimitNum')
        if m.get('LimitTranscodeNum') is not None:
            self.limit_transcode_num = m.get('LimitTranscodeNum')
        if m.get('LimitTransferNum') is not None:
            self.limit_transfer_num = m.get('LimitTransferNum')
        return self


class DescribeLiveDomainLimitResponseBodyLiveDomainLimitList(TeaModel):
    def __init__(self, live_domain_limit=None):
        self.live_domain_limit = live_domain_limit  # type: list[DescribeLiveDomainLimitResponseBodyLiveDomainLimitListLiveDomainLimit]

    def validate(self):
        if self.live_domain_limit:
            for k in self.live_domain_limit:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainLimitResponseBodyLiveDomainLimitList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveDomainLimit'] = []
        if self.live_domain_limit is not None:
            for k in self.live_domain_limit:
                result['LiveDomainLimit'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_domain_limit = []
        if m.get('LiveDomainLimit') is not None:
            for k in m.get('LiveDomainLimit'):
                temp_model = DescribeLiveDomainLimitResponseBodyLiveDomainLimitListLiveDomainLimit()
                self.live_domain_limit.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainLimitResponseBody(TeaModel):
    def __init__(self, live_domain_limit_list=None, request_id=None):
        self.live_domain_limit_list = live_domain_limit_list  # type: DescribeLiveDomainLimitResponseBodyLiveDomainLimitList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_domain_limit_list:
            self.live_domain_limit_list.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainLimitResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_domain_limit_list is not None:
            result['LiveDomainLimitList'] = self.live_domain_limit_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveDomainLimitList') is not None:
            temp_model = DescribeLiveDomainLimitResponseBodyLiveDomainLimitList()
            self.live_domain_limit_list = temp_model.from_map(m['LiveDomainLimitList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainLimitResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainLimitResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainLimitResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainLimitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainLogRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, owner_id=None, page_number=None, page_size=None,
                 start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail(TeaModel):
    def __init__(self, end_time=None, log_name=None, log_path=None, log_size=None, start_time=None):
        self.end_time = end_time  # type: str
        self.log_name = log_name  # type: str
        self.log_path = log_path  # type: str
        self.log_size = log_size  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.log_name is not None:
            result['LogName'] = self.log_name
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.log_size is not None:
            result['LogSize'] = self.log_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('LogName') is not None:
            self.log_name = m.get('LogName')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('LogSize') is not None:
            self.log_size = m.get('LogSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos(TeaModel):
    def __init__(self, log_info_detail=None):
        self.log_info_detail = log_info_detail  # type: list[DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail]

    def validate(self):
        if self.log_info_detail:
            for k in self.log_info_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogInfoDetail'] = []
        if self.log_info_detail is not None:
            for k in self.log_info_detail:
                result['LogInfoDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.log_info_detail = []
        if m.get('LogInfoDetail') is not None:
            for k in m.get('LogInfoDetail'):
                temp_model = DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfosLogInfoDetail()
                self.log_info_detail.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos(TeaModel):
    def __init__(self, page_index=None, page_size=None, total=None):
        self.page_index = page_index  # type: long
        self.page_size = page_size  # type: long
        self.total = total  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_index is not None:
            result['PageIndex'] = self.page_index
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageIndex') is not None:
            self.page_index = m.get('PageIndex')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetail(TeaModel):
    def __init__(self, log_count=None, log_infos=None, page_infos=None):
        self.log_count = log_count  # type: long
        self.log_infos = log_infos  # type: DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos
        self.page_infos = page_infos  # type: DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos

    def validate(self):
        if self.log_infos:
            self.log_infos.validate()
        if self.page_infos:
            self.page_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_count is not None:
            result['LogCount'] = self.log_count
        if self.log_infos is not None:
            result['LogInfos'] = self.log_infos.to_map()
        if self.page_infos is not None:
            result['PageInfos'] = self.page_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LogCount') is not None:
            self.log_count = m.get('LogCount')
        if m.get('LogInfos') is not None:
            temp_model = DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailLogInfos()
            self.log_infos = temp_model.from_map(m['LogInfos'])
        if m.get('PageInfos') is not None:
            temp_model = DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetailPageInfos()
            self.page_infos = temp_model.from_map(m['PageInfos'])
        return self


class DescribeLiveDomainLogResponseBodyDomainLogDetails(TeaModel):
    def __init__(self, domain_log_detail=None):
        self.domain_log_detail = domain_log_detail  # type: list[DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetail]

    def validate(self):
        if self.domain_log_detail:
            for k in self.domain_log_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainLogResponseBodyDomainLogDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainLogDetail'] = []
        if self.domain_log_detail is not None:
            for k in self.domain_log_detail:
                result['DomainLogDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_log_detail = []
        if m.get('DomainLogDetail') is not None:
            for k in m.get('DomainLogDetail'):
                temp_model = DescribeLiveDomainLogResponseBodyDomainLogDetailsDomainLogDetail()
                self.domain_log_detail.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainLogResponseBody(TeaModel):
    def __init__(self, domain_log_details=None, domain_name=None, request_id=None):
        self.domain_log_details = domain_log_details  # type: DescribeLiveDomainLogResponseBodyDomainLogDetails
        self.domain_name = domain_name  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_log_details:
            self.domain_log_details.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_log_details is not None:
            result['DomainLogDetails'] = self.domain_log_details.to_map()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainLogDetails') is not None:
            temp_model = DescribeLiveDomainLogResponseBodyDomainLogDetails()
            self.domain_log_details = temp_model.from_map(m['DomainLogDetails'])
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainMappingRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainMappingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveDomainMappingResponseBodyLiveDomainModelsLiveDomainModel(TeaModel):
    def __init__(self, domain_name=None, type=None):
        self.domain_name = domain_name  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainMappingResponseBodyLiveDomainModelsLiveDomainModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeLiveDomainMappingResponseBodyLiveDomainModels(TeaModel):
    def __init__(self, live_domain_model=None):
        self.live_domain_model = live_domain_model  # type: list[DescribeLiveDomainMappingResponseBodyLiveDomainModelsLiveDomainModel]

    def validate(self):
        if self.live_domain_model:
            for k in self.live_domain_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainMappingResponseBodyLiveDomainModels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveDomainModel'] = []
        if self.live_domain_model is not None:
            for k in self.live_domain_model:
                result['LiveDomainModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_domain_model = []
        if m.get('LiveDomainModel') is not None:
            for k in m.get('LiveDomainModel'):
                temp_model = DescribeLiveDomainMappingResponseBodyLiveDomainModelsLiveDomainModel()
                self.live_domain_model.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainMappingResponseBody(TeaModel):
    def __init__(self, live_domain_models=None, request_id=None):
        self.live_domain_models = live_domain_models  # type: DescribeLiveDomainMappingResponseBodyLiveDomainModels
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_domain_models:
            self.live_domain_models.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainMappingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_domain_models is not None:
            result['LiveDomainModels'] = self.live_domain_models.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveDomainModels') is not None:
            temp_model = DescribeLiveDomainMappingResponseBodyLiveDomainModels()
            self.live_domain_models = temp_model.from_map(m['LiveDomainModels'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainMappingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainMappingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainMappingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainMappingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainOnlineUserNumRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, query_time=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.query_time = query_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainOnlineUserNumRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.query_time is not None:
            result['QueryTime'] = self.query_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QueryTime') is not None:
            self.query_time = m.get('QueryTime')
        return self


class DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfosInfo(TeaModel):
    def __init__(self, transcode_template=None, user_number=None):
        self.transcode_template = transcode_template  # type: str
        self.user_number = user_number  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfosInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.transcode_template is not None:
            result['TranscodeTemplate'] = self.transcode_template
        if self.user_number is not None:
            result['UserNumber'] = self.user_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TranscodeTemplate') is not None:
            self.transcode_template = m.get('TranscodeTemplate')
        if m.get('UserNumber') is not None:
            self.user_number = m.get('UserNumber')
        return self


class DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfos(TeaModel):
    def __init__(self, info=None):
        self.info = info  # type: list[DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfosInfo]

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Info'] = []
        if self.info is not None:
            for k in self.info:
                result['Info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.info = []
        if m.get('Info') is not None:
            for k in m.get('Info'):
                temp_model = DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfosInfo()
                self.info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo(TeaModel):
    def __init__(self, infos=None, stream_name=None):
        self.infos = infos  # type: DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfos
        self.stream_name = stream_name  # type: str

    def validate(self):
        if self.infos:
            self.infos.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.infos is not None:
            result['Infos'] = self.infos.to_map()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Infos') is not None:
            temp_model = DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfoInfos()
            self.infos = temp_model.from_map(m['Infos'])
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfo(TeaModel):
    def __init__(self, live_stream_online_user_num_info=None):
        self.live_stream_online_user_num_info = live_stream_online_user_num_info  # type: list[DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo]

    def validate(self):
        if self.live_stream_online_user_num_info:
            for k in self.live_stream_online_user_num_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveStreamOnlineUserNumInfo'] = []
        if self.live_stream_online_user_num_info is not None:
            for k in self.live_stream_online_user_num_info:
                result['LiveStreamOnlineUserNumInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_stream_online_user_num_info = []
        if m.get('LiveStreamOnlineUserNumInfo') is not None:
            for k in m.get('LiveStreamOnlineUserNumInfo'):
                temp_model = DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfoLiveStreamOnlineUserNumInfo()
                self.live_stream_online_user_num_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainOnlineUserNumResponseBody(TeaModel):
    def __init__(self, online_user_info=None, request_id=None, stream_count=None, user_count=None):
        self.online_user_info = online_user_info  # type: DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfo
        self.request_id = request_id  # type: str
        self.stream_count = stream_count  # type: int
        self.user_count = user_count  # type: int

    def validate(self):
        if self.online_user_info:
            self.online_user_info.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainOnlineUserNumResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.online_user_info is not None:
            result['OnlineUserInfo'] = self.online_user_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stream_count is not None:
            result['StreamCount'] = self.stream_count
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OnlineUserInfo') is not None:
            temp_model = DescribeLiveDomainOnlineUserNumResponseBodyOnlineUserInfo()
            self.online_user_info = temp_model.from_map(m['OnlineUserInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StreamCount') is not None:
            self.stream_count = m.get('StreamCount')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class DescribeLiveDomainOnlineUserNumResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainOnlineUserNumResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainOnlineUserNumResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainOnlineUserNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainPushBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainPushBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, bps_value=None, time_stamp=None):
        self.bps_value = bps_value  # type: str
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_value is not None:
            result['BpsValue'] = self.bps_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsValue') is not None:
            self.bps_value = m.get('BpsValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainPushBpsDataResponseBody(TeaModel):
    def __init__(self, bps_data_per_interval=None, data_interval=None, domain_name=None, end_time=None,
                 request_id=None, start_time=None):
        self.bps_data_per_interval = bps_data_per_interval  # type: DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerInterval
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bps_data_per_interval:
            self.bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPushBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bps_data_per_interval is not None:
            result['BpsDataPerInterval'] = self.bps_data_per_interval.to_map()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BpsDataPerInterval') is not None:
            temp_model = DescribeLiveDomainPushBpsDataResponseBodyBpsDataPerInterval()
            self.bps_data_per_interval = temp_model.from_map(m['BpsDataPerInterval'])
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainPushBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainPushBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPushBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainPushBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainPushTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainPushTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, traffic_value=None):
        self.time_stamp = time_stamp  # type: str
        self.traffic_value = traffic_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.traffic_value is not None:
            result['TrafficValue'] = self.traffic_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TrafficValue') is not None:
            self.traffic_value = m.get('TrafficValue')
        return self


class DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainPushTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 traffic_data_per_interval=None):
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str
        self.traffic_data_per_interval = traffic_data_per_interval  # type: DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerInterval

    def validate(self):
        if self.traffic_data_per_interval:
            self.traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPushTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.traffic_data_per_interval is not None:
            result['TrafficDataPerInterval'] = self.traffic_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TrafficDataPerInterval') is not None:
            temp_model = DescribeLiveDomainPushTrafficDataResponseBodyTrafficDataPerInterval()
            self.traffic_data_per_interval = temp_model.from_map(m['TrafficDataPerInterval'])
        return self


class DescribeLiveDomainPushTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainPushTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPushTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainPushTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainPvUvDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainPvUvDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfosPvUvDataInfo(TeaModel):
    def __init__(self, pv=None, time_stamp=None, uv=None):
        self.pv = pv  # type: str
        self.time_stamp = time_stamp  # type: str
        self.uv = uv  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfosPvUvDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pv is not None:
            result['PV'] = self.pv
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.uv is not None:
            result['UV'] = self.uv
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PV') is not None:
            self.pv = m.get('PV')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('UV') is not None:
            self.uv = m.get('UV')
        return self


class DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfos(TeaModel):
    def __init__(self, pv_uv_data_info=None):
        self.pv_uv_data_info = pv_uv_data_info  # type: list[DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfosPvUvDataInfo]

    def validate(self):
        if self.pv_uv_data_info:
            for k in self.pv_uv_data_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PvUvDataInfo'] = []
        if self.pv_uv_data_info is not None:
            for k in self.pv_uv_data_info:
                result['PvUvDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.pv_uv_data_info = []
        if m.get('PvUvDataInfo') is not None:
            for k in m.get('PvUvDataInfo'):
                temp_model = DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfosPvUvDataInfo()
                self.pv_uv_data_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainPvUvDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, pv_uv_data_infos=None, request_id=None,
                 start_time=None):
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.pv_uv_data_infos = pv_uv_data_infos  # type: DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfos
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        if self.pv_uv_data_infos:
            self.pv_uv_data_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPvUvDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.pv_uv_data_infos is not None:
            result['PvUvDataInfos'] = self.pv_uv_data_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PvUvDataInfos') is not None:
            temp_model = DescribeLiveDomainPvUvDataResponseBodyPvUvDataInfos()
            self.pv_uv_data_infos = temp_model.from_map(m['PvUvDataInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainPvUvDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainPvUvDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainPvUvDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainPvUvDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRealTimeBpsDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, isp_name_en=None, location_name_en=None, owner_id=None,
                 start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeBpsDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        self.time_stamp = time_stamp  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRealTimeBpsDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, real_time_bps_data_per_interval=None,
                 request_id=None, start_time=None):
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.real_time_bps_data_per_interval = real_time_bps_data_per_interval  # type: DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerInterval
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        if self.real_time_bps_data_per_interval:
            self.real_time_bps_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeBpsDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_time_bps_data_per_interval is not None:
            result['RealTimeBpsDataPerInterval'] = self.real_time_bps_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTimeBpsDataPerInterval') is not None:
            temp_model = DescribeLiveDomainRealTimeBpsDataResponseBodyRealTimeBpsDataPerInterval()
            self.real_time_bps_data_per_interval = temp_model.from_map(m['RealTimeBpsDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainRealTimeBpsDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainRealTimeBpsDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeBpsDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRealTimeBpsDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRealTimeHttpCodeDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, isp_name_en=None, location_name_en=None, owner_id=None,
                 start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeHttpCodeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData(TeaModel):
    def __init__(self, code=None, count=None, proportion=None):
        self.code = code  # type: str
        self.count = count  # type: str
        self.proportion = proportion  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        if self.proportion is not None:
            result['Proportion'] = self.proportion
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Proportion') is not None:
            self.proportion = m.get('Proportion')
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue(TeaModel):
    def __init__(self, real_time_code_proportion_data=None):
        self.real_time_code_proportion_data = real_time_code_proportion_data  # type: list[DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData]

    def validate(self):
        if self.real_time_code_proportion_data:
            for k in self.real_time_code_proportion_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RealTimeCodeProportionData'] = []
        if self.real_time_code_proportion_data is not None:
            for k in self.real_time_code_proportion_data:
                result['RealTimeCodeProportionData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.real_time_code_proportion_data = []
        if m.get('RealTimeCodeProportionData') is not None:
            for k in m.get('RealTimeCodeProportionData'):
                temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValueRealTimeCodeProportionData()
                self.real_time_code_proportion_data.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        self.time_stamp = time_stamp  # type: str
        self.value = value  # type: DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue

    def validate(self):
        if self.value:
            self.value.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageDataValue()
            self.value = temp_model.from_map(m['Value'])
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData(TeaModel):
    def __init__(self, usage_data=None):
        self.usage_data = usage_data  # type: list[DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData]

    def validate(self):
        if self.usage_data:
            for k in self.usage_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UsageData'] = []
        if self.usage_data is not None:
            for k in self.usage_data:
                result['UsageData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.usage_data = []
        if m.get('UsageData') is not None:
            for k in m.get('UsageData'):
                temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeDataUsageData()
                self.usage_data.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, real_time_http_code_data=None,
                 request_id=None, start_time=None):
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.real_time_http_code_data = real_time_http_code_data  # type: DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        if self.real_time_http_code_data:
            self.real_time_http_code_data.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeHttpCodeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_time_http_code_data is not None:
            result['RealTimeHttpCodeData'] = self.real_time_http_code_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTimeHttpCodeData') is not None:
            temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBodyRealTimeHttpCodeData()
            self.real_time_http_code_data = temp_model.from_map(m['RealTimeHttpCodeData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainRealTimeHttpCodeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainRealTimeHttpCodeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeHttpCodeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRealTimeHttpCodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRealTimeTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, isp_name_en=None, location_name_en=None, owner_id=None,
                 start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, time_stamp=None, value=None):
        self.time_stamp = time_stamp  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRealTimeTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None,
                 real_time_traffic_data_per_interval=None, request_id=None, start_time=None):
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.real_time_traffic_data_per_interval = real_time_traffic_data_per_interval  # type: DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        if self.real_time_traffic_data_per_interval:
            self.real_time_traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_time_traffic_data_per_interval is not None:
            result['RealTimeTrafficDataPerInterval'] = self.real_time_traffic_data_per_interval.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTimeTrafficDataPerInterval') is not None:
            temp_model = DescribeLiveDomainRealTimeTrafficDataResponseBodyRealTimeTrafficDataPerInterval()
            self.real_time_traffic_data_per_interval = temp_model.from_map(m['RealTimeTrafficDataPerInterval'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainRealTimeTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainRealTimeTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealTimeTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRealTimeTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRealtimeLogDeliveryRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRealtimeLogDeliveryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveDomainRealtimeLogDeliveryResponseBody(TeaModel):
    def __init__(self, logstore=None, project=None, region=None, request_id=None, status=None):
        self.logstore = logstore  # type: str
        self.project = project  # type: str
        self.region = region  # type: str
        self.request_id = request_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRealtimeLogDeliveryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.project is not None:
            result['Project'] = self.project
        if self.region is not None:
            result['Region'] = self.region
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeLiveDomainRealtimeLogDeliveryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainRealtimeLogDeliveryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRealtimeLogDeliveryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRealtimeLogDeliveryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRecordDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, owner_id=None, record_type=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.record_type = record_type  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRecordDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfoDetail(TeaModel):
    def __init__(self, flv=None, mp4=None, ts=None):
        self.flv = flv  # type: int
        self.mp4 = mp4  # type: int
        self.ts = ts  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfoDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flv is not None:
            result['FLV'] = self.flv
        if self.mp4 is not None:
            result['MP4'] = self.mp4
        if self.ts is not None:
            result['TS'] = self.ts
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FLV') is not None:
            self.flv = m.get('FLV')
        if m.get('MP4') is not None:
            self.mp4 = m.get('MP4')
        if m.get('TS') is not None:
            self.ts = m.get('TS')
        return self


class DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfo(TeaModel):
    def __init__(self, date=None, detail=None, total=None):
        self.date = date  # type: str
        self.detail = detail  # type: DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfoDetail
        self.total = total  # type: int

    def validate(self):
        if self.detail:
            self.detail.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.detail is not None:
            result['Detail'] = self.detail.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Detail') is not None:
            temp_model = DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfoDetail()
            self.detail = temp_model.from_map(m['Detail'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveDomainRecordDataResponseBodyRecordDataInfos(TeaModel):
    def __init__(self, record_data_info=None):
        self.record_data_info = record_data_info  # type: list[DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfo]

    def validate(self):
        if self.record_data_info:
            for k in self.record_data_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRecordDataResponseBodyRecordDataInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordDataInfo'] = []
        if self.record_data_info is not None:
            for k in self.record_data_info:
                result['RecordDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.record_data_info = []
        if m.get('RecordDataInfo') is not None:
            for k in m.get('RecordDataInfo'):
                temp_model = DescribeLiveDomainRecordDataResponseBodyRecordDataInfosRecordDataInfo()
                self.record_data_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRecordDataResponseBody(TeaModel):
    def __init__(self, record_data_infos=None, request_id=None):
        self.record_data_infos = record_data_infos  # type: DescribeLiveDomainRecordDataResponseBodyRecordDataInfos
        self.request_id = request_id  # type: str

    def validate(self):
        if self.record_data_infos:
            self.record_data_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRecordDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_data_infos is not None:
            result['RecordDataInfos'] = self.record_data_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecordDataInfos') is not None:
            temp_model = DescribeLiveDomainRecordDataResponseBodyRecordDataInfos()
            self.record_data_infos = temp_model.from_map(m['RecordDataInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainRecordDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainRecordDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRecordDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRecordDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainRecordUsageDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, owner_id=None, split_by=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.split_by = split_by  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRecordUsageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.split_by is not None:
            result['SplitBy'] = self.split_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SplitBy') is not None:
            self.split_by = m.get('SplitBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainRecordUsageDataResponseBodyRecordUsageDataDataModule(TeaModel):
    def __init__(self, count=None, domain=None, duration=None, time_stamp=None, type=None):
        self.count = count  # type: long
        self.domain = domain  # type: str
        self.duration = duration  # type: long
        self.time_stamp = time_stamp  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainRecordUsageDataResponseBodyRecordUsageDataDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeLiveDomainRecordUsageDataResponseBodyRecordUsageData(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainRecordUsageDataResponseBodyRecordUsageDataDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRecordUsageDataResponseBodyRecordUsageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainRecordUsageDataResponseBodyRecordUsageDataDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainRecordUsageDataResponseBody(TeaModel):
    def __init__(self, record_usage_data=None, request_id=None):
        self.record_usage_data = record_usage_data  # type: DescribeLiveDomainRecordUsageDataResponseBodyRecordUsageData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.record_usage_data:
            self.record_usage_data.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRecordUsageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_usage_data is not None:
            result['RecordUsageData'] = self.record_usage_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecordUsageData') is not None:
            temp_model = DescribeLiveDomainRecordUsageDataResponseBodyRecordUsageData()
            self.record_usage_data = temp_model.from_map(m['RecordUsageData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainRecordUsageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainRecordUsageDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainRecordUsageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainRecordUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainSnapshotDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainSnapshotDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfosSnapshotDataInfo(TeaModel):
    def __init__(self, date=None, total=None):
        self.date = date  # type: str
        self.total = total  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfosSnapshotDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfos(TeaModel):
    def __init__(self, snapshot_data_info=None):
        self.snapshot_data_info = snapshot_data_info  # type: list[DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfosSnapshotDataInfo]

    def validate(self):
        if self.snapshot_data_info:
            for k in self.snapshot_data_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SnapshotDataInfo'] = []
        if self.snapshot_data_info is not None:
            for k in self.snapshot_data_info:
                result['SnapshotDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.snapshot_data_info = []
        if m.get('SnapshotDataInfo') is not None:
            for k in m.get('SnapshotDataInfo'):
                temp_model = DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfosSnapshotDataInfo()
                self.snapshot_data_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainSnapshotDataResponseBody(TeaModel):
    def __init__(self, request_id=None, snapshot_data_infos=None):
        self.request_id = request_id  # type: str
        self.snapshot_data_infos = snapshot_data_infos  # type: DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfos

    def validate(self):
        if self.snapshot_data_infos:
            self.snapshot_data_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainSnapshotDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_data_infos is not None:
            result['SnapshotDataInfos'] = self.snapshot_data_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotDataInfos') is not None:
            temp_model = DescribeLiveDomainSnapshotDataResponseBodySnapshotDataInfos()
            self.snapshot_data_infos = temp_model.from_map(m['SnapshotDataInfos'])
        return self


class DescribeLiveDomainSnapshotDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainSnapshotDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainSnapshotDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainSnapshotDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainStagingConfigRequest(TeaModel):
    def __init__(self, domain_name=None, function_names=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.function_names = function_names  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainStagingConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.function_names is not None:
            result['FunctionNames'] = self.function_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FunctionNames') is not None:
            self.function_names = m.get('FunctionNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveDomainStagingConfigResponseBodyDomainConfigsFunctionArgs(TeaModel):
    def __init__(self, arg_name=None, arg_value=None):
        self.arg_name = arg_name  # type: str
        self.arg_value = arg_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainStagingConfigResponseBodyDomainConfigsFunctionArgs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg_name is not None:
            result['ArgName'] = self.arg_name
        if self.arg_value is not None:
            result['ArgValue'] = self.arg_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ArgName') is not None:
            self.arg_name = m.get('ArgName')
        if m.get('ArgValue') is not None:
            self.arg_value = m.get('ArgValue')
        return self


class DescribeLiveDomainStagingConfigResponseBodyDomainConfigs(TeaModel):
    def __init__(self, config_id=None, function_args=None, function_name=None, status=None):
        self.config_id = config_id  # type: str
        self.function_args = function_args  # type: list[DescribeLiveDomainStagingConfigResponseBodyDomainConfigsFunctionArgs]
        self.function_name = function_name  # type: str
        self.status = status  # type: str

    def validate(self):
        if self.function_args:
            for k in self.function_args:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainStagingConfigResponseBodyDomainConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        result['FunctionArgs'] = []
        if self.function_args is not None:
            for k in self.function_args:
                result['FunctionArgs'].append(k.to_map() if k else None)
        if self.function_name is not None:
            result['FunctionName'] = self.function_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        self.function_args = []
        if m.get('FunctionArgs') is not None:
            for k in m.get('FunctionArgs'):
                temp_model = DescribeLiveDomainStagingConfigResponseBodyDomainConfigsFunctionArgs()
                self.function_args.append(temp_model.from_map(k))
        if m.get('FunctionName') is not None:
            self.function_name = m.get('FunctionName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeLiveDomainStagingConfigResponseBody(TeaModel):
    def __init__(self, domain_configs=None, request_id=None):
        self.domain_configs = domain_configs  # type: list[DescribeLiveDomainStagingConfigResponseBodyDomainConfigs]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.domain_configs:
            for k in self.domain_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainStagingConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainConfigs'] = []
        if self.domain_configs is not None:
            for k in self.domain_configs:
                result['DomainConfigs'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.domain_configs = []
        if m.get('DomainConfigs') is not None:
            for k in m.get('DomainConfigs'):
                temp_model = DescribeLiveDomainStagingConfigResponseBodyDomainConfigs()
                self.domain_configs.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDomainStagingConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainStagingConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainStagingConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainStagingConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainStreamTranscodeDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, owner_id=None, split=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        self.split = split  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainStreamTranscodeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.split is not None:
            result['Split'] = self.split
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Split') is not None:
            self.split = m.get('Split')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainStreamTranscodeDataResponseBodyTranscodeDataListTranscodeData(TeaModel):
    def __init__(self, domain=None, duration=None, fps=None, region=None, resolution=None, tanscode_type=None,
                 time_stamp=None):
        self.domain = domain  # type: str
        self.duration = duration  # type: int
        self.fps = fps  # type: str
        self.region = region  # type: str
        self.resolution = resolution  # type: str
        self.tanscode_type = tanscode_type  # type: str
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainStreamTranscodeDataResponseBodyTranscodeDataListTranscodeData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.fps is not None:
            result['Fps'] = self.fps
        if self.region is not None:
            result['Region'] = self.region
        if self.resolution is not None:
            result['Resolution'] = self.resolution
        if self.tanscode_type is not None:
            result['TanscodeType'] = self.tanscode_type
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Fps') is not None:
            self.fps = m.get('Fps')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Resolution') is not None:
            self.resolution = m.get('Resolution')
        if m.get('TanscodeType') is not None:
            self.tanscode_type = m.get('TanscodeType')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDomainStreamTranscodeDataResponseBodyTranscodeDataList(TeaModel):
    def __init__(self, transcode_data=None):
        self.transcode_data = transcode_data  # type: list[DescribeLiveDomainStreamTranscodeDataResponseBodyTranscodeDataListTranscodeData]

    def validate(self):
        if self.transcode_data:
            for k in self.transcode_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainStreamTranscodeDataResponseBodyTranscodeDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TranscodeData'] = []
        if self.transcode_data is not None:
            for k in self.transcode_data:
                result['TranscodeData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.transcode_data = []
        if m.get('TranscodeData') is not None:
            for k in m.get('TranscodeData'):
                temp_model = DescribeLiveDomainStreamTranscodeDataResponseBodyTranscodeDataListTranscodeData()
                self.transcode_data.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainStreamTranscodeDataResponseBody(TeaModel):
    def __init__(self, request_id=None, transcode_data_list=None):
        self.request_id = request_id  # type: str
        self.transcode_data_list = transcode_data_list  # type: DescribeLiveDomainStreamTranscodeDataResponseBodyTranscodeDataList

    def validate(self):
        if self.transcode_data_list:
            self.transcode_data_list.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainStreamTranscodeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_data_list is not None:
            result['TranscodeDataList'] = self.transcode_data_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeDataList') is not None:
            temp_model = DescribeLiveDomainStreamTranscodeDataResponseBodyTranscodeDataList()
            self.transcode_data_list = temp_model.from_map(m['TranscodeDataList'])
        return self


class DescribeLiveDomainStreamTranscodeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainStreamTranscodeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainStreamTranscodeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainStreamTranscodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainTimeShiftDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainTimeShiftDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftDataDataModule(TeaModel):
    def __init__(self, size=None, time_stamp=None, type=None):
        self.size = size  # type: str
        self.time_stamp = time_stamp  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftDataDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.size is not None:
            result['Size'] = self.size
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftData(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftDataDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftDataDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainTimeShiftDataResponseBody(TeaModel):
    def __init__(self, request_id=None, time_shift_data=None):
        self.request_id = request_id  # type: str
        self.time_shift_data = time_shift_data  # type: DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftData

    def validate(self):
        if self.time_shift_data:
            self.time_shift_data.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTimeShiftDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_shift_data is not None:
            result['TimeShiftData'] = self.time_shift_data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeShiftData') is not None:
            temp_model = DescribeLiveDomainTimeShiftDataResponseBodyTimeShiftData()
            self.time_shift_data = temp_model.from_map(m['TimeShiftData'])
        return self


class DescribeLiveDomainTimeShiftDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainTimeShiftDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTimeShiftDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainTimeShiftDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainTrafficDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, isp_name_en=None, location_name_en=None,
                 owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.isp_name_en = isp_name_en  # type: str
        self.location_name_en = location_name_en  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainTrafficDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_name_en is not None:
            result['IspNameEn'] = self.isp_name_en
        if self.location_name_en is not None:
            result['LocationNameEn'] = self.location_name_en
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspNameEn') is not None:
            self.isp_name_en = m.get('IspNameEn')
        if m.get('LocationNameEn') is not None:
            self.location_name_en = m.get('LocationNameEn')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule(TeaModel):
    def __init__(self, http_traffic_value=None, https_traffic_value=None, time_stamp=None, traffic_value=None):
        self.http_traffic_value = http_traffic_value  # type: str
        self.https_traffic_value = https_traffic_value  # type: str
        self.time_stamp = time_stamp  # type: str
        self.traffic_value = traffic_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_traffic_value is not None:
            result['HttpTrafficValue'] = self.http_traffic_value
        if self.https_traffic_value is not None:
            result['HttpsTrafficValue'] = self.https_traffic_value
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.traffic_value is not None:
            result['TrafficValue'] = self.traffic_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HttpTrafficValue') is not None:
            self.http_traffic_value = m.get('HttpTrafficValue')
        if m.get('HttpsTrafficValue') is not None:
            self.https_traffic_value = m.get('HttpsTrafficValue')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TrafficValue') is not None:
            self.traffic_value = m.get('TrafficValue')
        return self


class DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerInterval(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerInterval, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerIntervalDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainTrafficDataResponseBody(TeaModel):
    def __init__(self, data_interval=None, domain_name=None, end_time=None, request_id=None, start_time=None,
                 traffic_data_per_interval=None):
        self.data_interval = data_interval  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str
        self.traffic_data_per_interval = traffic_data_per_interval  # type: DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerInterval

    def validate(self):
        if self.traffic_data_per_interval:
            self.traffic_data_per_interval.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTrafficDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_interval is not None:
            result['DataInterval'] = self.data_interval
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.traffic_data_per_interval is not None:
            result['TrafficDataPerInterval'] = self.traffic_data_per_interval.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataInterval') is not None:
            self.data_interval = m.get('DataInterval')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TrafficDataPerInterval') is not None:
            temp_model = DescribeLiveDomainTrafficDataResponseBodyTrafficDataPerInterval()
            self.traffic_data_per_interval = temp_model.from_map(m['TrafficDataPerInterval'])
        return self


class DescribeLiveDomainTrafficDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainTrafficDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTrafficDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainTrafficDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDomainTranscodeDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, owner_id=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainTranscodeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfosTranscodeDataInfo(TeaModel):
    def __init__(self, date=None, detail=None, total=None):
        self.date = date  # type: str
        self.detail = detail  # type: str
        self.total = total  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfosTranscodeDataInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfos(TeaModel):
    def __init__(self, transcode_data_info=None):
        self.transcode_data_info = transcode_data_info  # type: list[DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfosTranscodeDataInfo]

    def validate(self):
        if self.transcode_data_info:
            for k in self.transcode_data_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TranscodeDataInfo'] = []
        if self.transcode_data_info is not None:
            for k in self.transcode_data_info:
                result['TranscodeDataInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.transcode_data_info = []
        if m.get('TranscodeDataInfo') is not None:
            for k in m.get('TranscodeDataInfo'):
                temp_model = DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfosTranscodeDataInfo()
                self.transcode_data_info.append(temp_model.from_map(k))
        return self


class DescribeLiveDomainTranscodeDataResponseBody(TeaModel):
    def __init__(self, request_id=None, transcode_data_infos=None):
        self.request_id = request_id  # type: str
        self.transcode_data_infos = transcode_data_infos  # type: DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfos

    def validate(self):
        if self.transcode_data_infos:
            self.transcode_data_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTranscodeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transcode_data_infos is not None:
            result['TranscodeDataInfos'] = self.transcode_data_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TranscodeDataInfos') is not None:
            temp_model = DescribeLiveDomainTranscodeDataResponseBodyTranscodeDataInfos()
            self.transcode_data_infos = temp_model.from_map(m['TranscodeDataInfos'])
        return self


class DescribeLiveDomainTranscodeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDomainTranscodeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDomainTranscodeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDomainTranscodeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveDrmUsageDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, owner_id=None, split_by=None, start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        self.split_by = split_by  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDrmUsageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.split_by is not None:
            result['SplitBy'] = self.split_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SplitBy') is not None:
            self.split_by = m.get('SplitBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveDrmUsageDataResponseBodyDrmUsageDataDataModule(TeaModel):
    def __init__(self, count=None, domain=None, drm_type=None, region=None, time_stamp=None):
        self.count = count  # type: long
        self.domain = domain  # type: str
        self.drm_type = drm_type  # type: str
        self.region = region  # type: str
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveDrmUsageDataResponseBodyDrmUsageDataDataModule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.drm_type is not None:
            result['DrmType'] = self.drm_type
        if self.region is not None:
            result['Region'] = self.region
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('DrmType') is not None:
            self.drm_type = m.get('DrmType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveDrmUsageDataResponseBodyDrmUsageData(TeaModel):
    def __init__(self, data_module=None):
        self.data_module = data_module  # type: list[DescribeLiveDrmUsageDataResponseBodyDrmUsageDataDataModule]

    def validate(self):
        if self.data_module:
            for k in self.data_module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveDrmUsageDataResponseBodyDrmUsageData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataModule'] = []
        if self.data_module is not None:
            for k in self.data_module:
                result['DataModule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_module = []
        if m.get('DataModule') is not None:
            for k in m.get('DataModule'):
                temp_model = DescribeLiveDrmUsageDataResponseBodyDrmUsageDataDataModule()
                self.data_module.append(temp_model.from_map(k))
        return self


class DescribeLiveDrmUsageDataResponseBody(TeaModel):
    def __init__(self, drm_usage_data=None, request_id=None):
        self.drm_usage_data = drm_usage_data  # type: DescribeLiveDrmUsageDataResponseBodyDrmUsageData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.drm_usage_data:
            self.drm_usage_data.validate()

    def to_map(self):
        _map = super(DescribeLiveDrmUsageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drm_usage_data is not None:
            result['DrmUsageData'] = self.drm_usage_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrmUsageData') is not None:
            temp_model = DescribeLiveDrmUsageDataResponseBodyDrmUsageData()
            self.drm_usage_data = temp_model.from_map(m['DrmUsageData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveDrmUsageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveDrmUsageDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveDrmUsageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveDrmUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveEdgeTransferRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveEdgeTransferRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveEdgeTransferResponseBody(TeaModel):
    def __init__(self, app_name=None, domain_name=None, http_dns=None, request_id=None, stream_name=None,
                 target_domain_list=None, transfer_args=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.http_dns = http_dns  # type: str
        self.request_id = request_id  # type: str
        self.stream_name = stream_name  # type: str
        self.target_domain_list = target_domain_list  # type: str
        self.transfer_args = transfer_args  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveEdgeTransferResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.http_dns is not None:
            result['HttpDns'] = self.http_dns
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.target_domain_list is not None:
            result['TargetDomainList'] = self.target_domain_list
        if self.transfer_args is not None:
            result['TransferArgs'] = self.transfer_args
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('HttpDns') is not None:
            self.http_dns = m.get('HttpDns')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('TargetDomainList') is not None:
            self.target_domain_list = m.get('TargetDomainList')
        if m.get('TransferArgs') is not None:
            self.transfer_args = m.get('TransferArgs')
        return self


class DescribeLiveEdgeTransferResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveEdgeTransferResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveEdgeTransferResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveEdgeTransferResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveLazyPullStreamConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveLazyPullStreamConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigListLiveLazyPullConfig(TeaModel):
    def __init__(self, app_name=None, domain_name=None, pull_app_name=None, pull_domain_name=None,
                 pull_protocol=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.pull_app_name = pull_app_name  # type: str
        self.pull_domain_name = pull_domain_name  # type: str
        self.pull_protocol = pull_protocol  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigListLiveLazyPullConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.pull_app_name is not None:
            result['PullAppName'] = self.pull_app_name
        if self.pull_domain_name is not None:
            result['PullDomainName'] = self.pull_domain_name
        if self.pull_protocol is not None:
            result['PullProtocol'] = self.pull_protocol
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('PullAppName') is not None:
            self.pull_app_name = m.get('PullAppName')
        if m.get('PullDomainName') is not None:
            self.pull_domain_name = m.get('PullDomainName')
        if m.get('PullProtocol') is not None:
            self.pull_protocol = m.get('PullProtocol')
        return self


class DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigList(TeaModel):
    def __init__(self, live_lazy_pull_config=None):
        self.live_lazy_pull_config = live_lazy_pull_config  # type: list[DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigListLiveLazyPullConfig]

    def validate(self):
        if self.live_lazy_pull_config:
            for k in self.live_lazy_pull_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveLazyPullConfig'] = []
        if self.live_lazy_pull_config is not None:
            for k in self.live_lazy_pull_config:
                result['LiveLazyPullConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_lazy_pull_config = []
        if m.get('LiveLazyPullConfig') is not None:
            for k in m.get('LiveLazyPullConfig'):
                temp_model = DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigListLiveLazyPullConfig()
                self.live_lazy_pull_config.append(temp_model.from_map(k))
        return self


class DescribeLiveLazyPullStreamConfigResponseBody(TeaModel):
    def __init__(self, live_lazy_pull_config_list=None, request_id=None):
        self.live_lazy_pull_config_list = live_lazy_pull_config_list  # type: DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_lazy_pull_config_list:
            self.live_lazy_pull_config_list.validate()

    def to_map(self):
        _map = super(DescribeLiveLazyPullStreamConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_lazy_pull_config_list is not None:
            result['LiveLazyPullConfigList'] = self.live_lazy_pull_config_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveLazyPullConfigList') is not None:
            temp_model = DescribeLiveLazyPullStreamConfigResponseBodyLiveLazyPullConfigList()
            self.live_lazy_pull_config_list = temp_model.from_map(m['LiveLazyPullConfigList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveLazyPullStreamConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveLazyPullStreamConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveLazyPullStreamConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveLazyPullStreamConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveProducerUsageDataRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, instance=None, interval=None, owner_id=None, region=None,
                 split_by=None, start_time=None, type=None, app=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.instance = instance  # type: str
        self.interval = interval  # type: str
        self.owner_id = owner_id  # type: long
        self.region = region  # type: str
        self.split_by = split_by  # type: str
        self.start_time = start_time  # type: str
        self.type = type  # type: str
        self.app = app  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveProducerUsageDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region is not None:
            result['Region'] = self.region
        if self.split_by is not None:
            result['SplitBy'] = self.split_by
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.app is not None:
            result['app'] = self.app
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SplitBy') is not None:
            self.split_by = m.get('SplitBy')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('app') is not None:
            self.app = m.get('app')
        return self


class DescribeLiveProducerUsageDataResponseBodyBillProducerDataBillProducerDataItem(TeaModel):
    def __init__(self, domain_name=None, instance=None, output_hd_duration=None, output_ld_duration=None,
                 output_sd_duration=None, region=None, time_stamp=None, tran_hd_duration=None, tran_ld_duration=None,
                 tran_sd_duration=None, type=None):
        self.domain_name = domain_name  # type: str
        self.instance = instance  # type: str
        self.output_hd_duration = output_hd_duration  # type: long
        self.output_ld_duration = output_ld_duration  # type: long
        self.output_sd_duration = output_sd_duration  # type: long
        self.region = region  # type: str
        self.time_stamp = time_stamp  # type: str
        self.tran_hd_duration = tran_hd_duration  # type: long
        self.tran_ld_duration = tran_ld_duration  # type: long
        self.tran_sd_duration = tran_sd_duration  # type: long
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveProducerUsageDataResponseBodyBillProducerDataBillProducerDataItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.instance is not None:
            result['Instance'] = self.instance
        if self.output_hd_duration is not None:
            result['OutputHdDuration'] = self.output_hd_duration
        if self.output_ld_duration is not None:
            result['OutputLdDuration'] = self.output_ld_duration
        if self.output_sd_duration is not None:
            result['OutputSdDuration'] = self.output_sd_duration
        if self.region is not None:
            result['Region'] = self.region
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.tran_hd_duration is not None:
            result['TranHdDuration'] = self.tran_hd_duration
        if self.tran_ld_duration is not None:
            result['TranLdDuration'] = self.tran_ld_duration
        if self.tran_sd_duration is not None:
            result['TranSdDuration'] = self.tran_sd_duration
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Instance') is not None:
            self.instance = m.get('Instance')
        if m.get('OutputHdDuration') is not None:
            self.output_hd_duration = m.get('OutputHdDuration')
        if m.get('OutputLdDuration') is not None:
            self.output_ld_duration = m.get('OutputLdDuration')
        if m.get('OutputSdDuration') is not None:
            self.output_sd_duration = m.get('OutputSdDuration')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('TranHdDuration') is not None:
            self.tran_hd_duration = m.get('TranHdDuration')
        if m.get('TranLdDuration') is not None:
            self.tran_ld_duration = m.get('TranLdDuration')
        if m.get('TranSdDuration') is not None:
            self.tran_sd_duration = m.get('TranSdDuration')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeLiveProducerUsageDataResponseBodyBillProducerData(TeaModel):
    def __init__(self, bill_producer_data_item=None):
        self.bill_producer_data_item = bill_producer_data_item  # type: list[DescribeLiveProducerUsageDataResponseBodyBillProducerDataBillProducerDataItem]

    def validate(self):
        if self.bill_producer_data_item:
            for k in self.bill_producer_data_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveProducerUsageDataResponseBodyBillProducerData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BillProducerDataItem'] = []
        if self.bill_producer_data_item is not None:
            for k in self.bill_producer_data_item:
                result['BillProducerDataItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bill_producer_data_item = []
        if m.get('BillProducerDataItem') is not None:
            for k in m.get('BillProducerDataItem'):
                temp_model = DescribeLiveProducerUsageDataResponseBodyBillProducerDataBillProducerDataItem()
                self.bill_producer_data_item.append(temp_model.from_map(k))
        return self


class DescribeLiveProducerUsageDataResponseBody(TeaModel):
    def __init__(self, bill_producer_data=None, end_time=None, request_id=None, start_time=None):
        self.bill_producer_data = bill_producer_data  # type: DescribeLiveProducerUsageDataResponseBodyBillProducerData
        self.end_time = end_time  # type: str
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        if self.bill_producer_data:
            self.bill_producer_data.validate()

    def to_map(self):
        _map = super(DescribeLiveProducerUsageDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_producer_data is not None:
            result['BillProducerData'] = self.bill_producer_data.to_map()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BillProducerData') is not None:
            temp_model = DescribeLiveProducerUsageDataResponseBodyBillProducerData()
            self.bill_producer_data = temp_model.from_map(m['BillProducerData'])
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveProducerUsageDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveProducerUsageDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveProducerUsageDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveProducerUsageDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLivePullStreamConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLivePullStreamConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLivePullStreamConfigResponseBodyLiveAppRecordListLiveAppRecord(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, source_url=None, source_using=None,
                 start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.source_url = source_url  # type: str
        self.source_using = source_using  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLivePullStreamConfigResponseBodyLiveAppRecordListLiveAppRecord, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.source_url is not None:
            result['SourceUrl'] = self.source_url
        if self.source_using is not None:
            result['SourceUsing'] = self.source_using
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('SourceUrl') is not None:
            self.source_url = m.get('SourceUrl')
        if m.get('SourceUsing') is not None:
            self.source_using = m.get('SourceUsing')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLivePullStreamConfigResponseBodyLiveAppRecordList(TeaModel):
    def __init__(self, live_app_record=None):
        self.live_app_record = live_app_record  # type: list[DescribeLivePullStreamConfigResponseBodyLiveAppRecordListLiveAppRecord]

    def validate(self):
        if self.live_app_record:
            for k in self.live_app_record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLivePullStreamConfigResponseBodyLiveAppRecordList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveAppRecord'] = []
        if self.live_app_record is not None:
            for k in self.live_app_record:
                result['LiveAppRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_app_record = []
        if m.get('LiveAppRecord') is not None:
            for k in m.get('LiveAppRecord'):
                temp_model = DescribeLivePullStreamConfigResponseBodyLiveAppRecordListLiveAppRecord()
                self.live_app_record.append(temp_model.from_map(k))
        return self


class DescribeLivePullStreamConfigResponseBody(TeaModel):
    def __init__(self, live_app_record_list=None, request_id=None):
        self.live_app_record_list = live_app_record_list  # type: DescribeLivePullStreamConfigResponseBodyLiveAppRecordList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_app_record_list:
            self.live_app_record_list.validate()

    def to_map(self):
        _map = super(DescribeLivePullStreamConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_app_record_list is not None:
            result['LiveAppRecordList'] = self.live_app_record_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveAppRecordList') is not None:
            temp_model = DescribeLivePullStreamConfigResponseBodyLiveAppRecordList()
            self.live_app_record_list = temp_model.from_map(m['LiveAppRecordList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLivePullStreamConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLivePullStreamConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLivePullStreamConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLivePullStreamConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRealtimeDeliveryAccRequest(TeaModel):
    def __init__(self, domain_name=None, end_time=None, interval=None, log_store=None, owner_id=None, project=None,
                 start_time=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.interval = interval  # type: str
        self.log_store = log_store  # type: str
        self.owner_id = owner_id  # type: long
        self.project = project  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRealtimeDeliveryAccRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.log_store is not None:
            result['LogStore'] = self.log_store
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project is not None:
            result['Project'] = self.project
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('LogStore') is not None:
            self.log_store = m.get('LogStore')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccDataAccData(TeaModel):
    def __init__(self, failed_num=None, success_num=None, time_stamp=None):
        self.failed_num = failed_num  # type: int
        self.success_num = success_num  # type: int
        self.time_stamp = time_stamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccDataAccData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_num is not None:
            result['FailedNum'] = self.failed_num
        if self.success_num is not None:
            result['SuccessNum'] = self.success_num
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailedNum') is not None:
            self.failed_num = m.get('FailedNum')
        if m.get('SuccessNum') is not None:
            self.success_num = m.get('SuccessNum')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        return self


class DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccData(TeaModel):
    def __init__(self, acc_data=None):
        self.acc_data = acc_data  # type: list[DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccDataAccData]

    def validate(self):
        if self.acc_data:
            for k in self.acc_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccData'] = []
        if self.acc_data is not None:
            for k in self.acc_data:
                result['AccData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.acc_data = []
        if m.get('AccData') is not None:
            for k in m.get('AccData'):
                temp_model = DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccDataAccData()
                self.acc_data.append(temp_model.from_map(k))
        return self


class DescribeLiveRealtimeDeliveryAccResponseBody(TeaModel):
    def __init__(self, real_time_delivery_acc_data=None, request_id=None):
        self.real_time_delivery_acc_data = real_time_delivery_acc_data  # type: DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccData
        self.request_id = request_id  # type: str

    def validate(self):
        if self.real_time_delivery_acc_data:
            self.real_time_delivery_acc_data.validate()

    def to_map(self):
        _map = super(DescribeLiveRealtimeDeliveryAccResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.real_time_delivery_acc_data is not None:
            result['RealTimeDeliveryAccData'] = self.real_time_delivery_acc_data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RealTimeDeliveryAccData') is not None:
            temp_model = DescribeLiveRealtimeDeliveryAccResponseBodyRealTimeDeliveryAccData()
            self.real_time_delivery_acc_data = temp_model.from_map(m['RealTimeDeliveryAccData'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveRealtimeDeliveryAccResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveRealtimeDeliveryAccResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveRealtimeDeliveryAccResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveRealtimeDeliveryAccResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRealtimeLogAuthorizedRequest(TeaModel):
    def __init__(self, live_openapi_reserve=None, owner_id=None):
        self.live_openapi_reserve = live_openapi_reserve  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRealtimeLogAuthorizedRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_openapi_reserve is not None:
            result['LiveOpenapiReserve'] = self.live_openapi_reserve
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveOpenapiReserve') is not None:
            self.live_openapi_reserve = m.get('LiveOpenapiReserve')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveRealtimeLogAuthorizedResponseBody(TeaModel):
    def __init__(self, authorized_status=None, request_id=None):
        self.authorized_status = authorized_status  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRealtimeLogAuthorizedResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorized_status is not None:
            result['AuthorizedStatus'] = self.authorized_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthorizedStatus') is not None:
            self.authorized_status = m.get('AuthorizedStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveRealtimeLogAuthorizedResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveRealtimeLogAuthorizedResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveRealtimeLogAuthorizedResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveRealtimeLogAuthorizedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRecordConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, order=None, owner_id=None, page_num=None, page_size=None,
                 security_token=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.order = order  # type: str
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.security_token = security_token  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRecordConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.order is not None:
            result['Order'] = self.order
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatListRecordFormat(TeaModel):
    def __init__(self, cycle_duration=None, format=None, oss_object_prefix=None, slice_duration=None,
                 slice_oss_object_prefix=None):
        self.cycle_duration = cycle_duration  # type: int
        self.format = format  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.slice_duration = slice_duration  # type: int
        self.slice_oss_object_prefix = slice_oss_object_prefix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatListRecordFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatList(TeaModel):
    def __init__(self, record_format=None):
        self.record_format = record_format  # type: list[DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatListRecordFormat]

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatListRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeRecordFormatListRecordFormat(TeaModel):
    def __init__(self, cycle_duration=None, format=None, oss_object_prefix=None, slice_duration=None,
                 slice_oss_object_prefix=None):
        self.cycle_duration = cycle_duration  # type: int
        self.format = format  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.slice_duration = slice_duration  # type: int
        self.slice_oss_object_prefix = slice_oss_object_prefix  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeRecordFormatListRecordFormat, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.format is not None:
            result['Format'] = self.format
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.slice_duration is not None:
            result['SliceDuration'] = self.slice_duration
        if self.slice_oss_object_prefix is not None:
            result['SliceOssObjectPrefix'] = self.slice_oss_object_prefix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('SliceDuration') is not None:
            self.slice_duration = m.get('SliceDuration')
        if m.get('SliceOssObjectPrefix') is not None:
            self.slice_oss_object_prefix = m.get('SliceOssObjectPrefix')
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeRecordFormatList(TeaModel):
    def __init__(self, record_format=None):
        self.record_format = record_format  # type: list[DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeRecordFormatListRecordFormat]

    def validate(self):
        if self.record_format:
            for k in self.record_format:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeRecordFormatList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordFormat'] = []
        if self.record_format is not None:
            for k in self.record_format:
                result['RecordFormat'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.record_format = []
        if m.get('RecordFormat') is not None:
            for k in m.get('RecordFormat'):
                temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeRecordFormatListRecordFormat()
                self.record_format.append(temp_model.from_map(k))
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeTemplates(TeaModel):
    def __init__(self, templates=None):
        self.templates = templates  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeTemplates, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.templates is not None:
            result['Templates'] = self.templates
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Templates') is not None:
            self.templates = m.get('Templates')
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecord(TeaModel):
    def __init__(self, app_name=None, create_time=None, domain_name=None, end_time=None, on_demond=None,
                 oss_bucket=None, oss_endpoint=None, record_format_list=None, start_time=None, stream_name=None,
                 transcode_record_format_list=None, transcode_templates=None):
        self.app_name = app_name  # type: str
        self.create_time = create_time  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.on_demond = on_demond  # type: int
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.record_format_list = record_format_list  # type: DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatList
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str
        self.transcode_record_format_list = transcode_record_format_list  # type: DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeRecordFormatList
        self.transcode_templates = transcode_templates  # type: DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeTemplates

    def validate(self):
        if self.record_format_list:
            self.record_format_list.validate()
        if self.transcode_record_format_list:
            self.transcode_record_format_list.validate()
        if self.transcode_templates:
            self.transcode_templates.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecord, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.on_demond is not None:
            result['OnDemond'] = self.on_demond
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.record_format_list is not None:
            result['RecordFormatList'] = self.record_format_list.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.transcode_record_format_list is not None:
            result['TranscodeRecordFormatList'] = self.transcode_record_format_list.to_map()
        if self.transcode_templates is not None:
            result['TranscodeTemplates'] = self.transcode_templates.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OnDemond') is not None:
            self.on_demond = m.get('OnDemond')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('RecordFormatList') is not None:
            temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordRecordFormatList()
            self.record_format_list = temp_model.from_map(m['RecordFormatList'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('TranscodeRecordFormatList') is not None:
            temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeRecordFormatList()
            self.transcode_record_format_list = temp_model.from_map(m['TranscodeRecordFormatList'])
        if m.get('TranscodeTemplates') is not None:
            temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecordTranscodeTemplates()
            self.transcode_templates = temp_model.from_map(m['TranscodeTemplates'])
        return self


class DescribeLiveRecordConfigResponseBodyLiveAppRecordList(TeaModel):
    def __init__(self, live_app_record=None):
        self.live_app_record = live_app_record  # type: list[DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecord]

    def validate(self):
        if self.live_app_record:
            for k in self.live_app_record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponseBodyLiveAppRecordList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveAppRecord'] = []
        if self.live_app_record is not None:
            for k in self.live_app_record:
                result['LiveAppRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_app_record = []
        if m.get('LiveAppRecord') is not None:
            for k in m.get('LiveAppRecord'):
                temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordListLiveAppRecord()
                self.live_app_record.append(temp_model.from_map(k))
        return self


class DescribeLiveRecordConfigResponseBody(TeaModel):
    def __init__(self, live_app_record_list=None, order=None, page_num=None, page_size=None, request_id=None,
                 total_num=None, total_page=None):
        self.live_app_record_list = live_app_record_list  # type: DescribeLiveRecordConfigResponseBodyLiveAppRecordList
        self.order = order  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_num = total_num  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.live_app_record_list:
            self.live_app_record_list.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_app_record_list is not None:
            result['LiveAppRecordList'] = self.live_app_record_list.to_map()
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveAppRecordList') is not None:
            temp_model = DescribeLiveRecordConfigResponseBodyLiveAppRecordList()
            self.live_app_record_list = temp_model.from_map(m['LiveAppRecordList'])
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeLiveRecordConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveRecordConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveRecordConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRecordNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, security_token=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRecordNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeLiveRecordNotifyConfigResponseBodyLiveRecordNotifyConfig(TeaModel):
    def __init__(self, domain_name=None, need_status_notify=None, notify_url=None, on_demand_url=None):
        self.domain_name = domain_name  # type: str
        self.need_status_notify = need_status_notify  # type: bool
        self.notify_url = notify_url  # type: str
        self.on_demand_url = on_demand_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRecordNotifyConfigResponseBodyLiveRecordNotifyConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.need_status_notify is not None:
            result['NeedStatusNotify'] = self.need_status_notify
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.on_demand_url is not None:
            result['OnDemandUrl'] = self.on_demand_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NeedStatusNotify') is not None:
            self.need_status_notify = m.get('NeedStatusNotify')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('OnDemandUrl') is not None:
            self.on_demand_url = m.get('OnDemandUrl')
        return self


class DescribeLiveRecordNotifyConfigResponseBody(TeaModel):
    def __init__(self, live_record_notify_config=None, request_id=None):
        self.live_record_notify_config = live_record_notify_config  # type: DescribeLiveRecordNotifyConfigResponseBodyLiveRecordNotifyConfig
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_record_notify_config:
            self.live_record_notify_config.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_record_notify_config is not None:
            result['LiveRecordNotifyConfig'] = self.live_record_notify_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveRecordNotifyConfig') is not None:
            temp_model = DescribeLiveRecordNotifyConfigResponseBodyLiveRecordNotifyConfig()
            self.live_record_notify_config = temp_model.from_map(m['LiveRecordNotifyConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveRecordNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveRecordNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveRecordNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveRecordVodConfigsRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, page_num=None, page_size=None,
                 stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRecordVodConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigsLiveRecordVodConfig(TeaModel):
    def __init__(self, app_name=None, auto_compose=None, compose_vod_transcode_group_id=None, create_time=None,
                 cycle_duration=None, domain_name=None, stream_name=None, vod_transcode_group_id=None):
        self.app_name = app_name  # type: str
        self.auto_compose = auto_compose  # type: str
        self.compose_vod_transcode_group_id = compose_vod_transcode_group_id  # type: str
        self.create_time = create_time  # type: str
        self.cycle_duration = cycle_duration  # type: int
        self.domain_name = domain_name  # type: str
        self.stream_name = stream_name  # type: str
        self.vod_transcode_group_id = vod_transcode_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigsLiveRecordVodConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.auto_compose is not None:
            result['AutoCompose'] = self.auto_compose
        if self.compose_vod_transcode_group_id is not None:
            result['ComposeVodTranscodeGroupId'] = self.compose_vod_transcode_group_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.cycle_duration is not None:
            result['CycleDuration'] = self.cycle_duration
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.vod_transcode_group_id is not None:
            result['VodTranscodeGroupId'] = self.vod_transcode_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AutoCompose') is not None:
            self.auto_compose = m.get('AutoCompose')
        if m.get('ComposeVodTranscodeGroupId') is not None:
            self.compose_vod_transcode_group_id = m.get('ComposeVodTranscodeGroupId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CycleDuration') is not None:
            self.cycle_duration = m.get('CycleDuration')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('VodTranscodeGroupId') is not None:
            self.vod_transcode_group_id = m.get('VodTranscodeGroupId')
        return self


class DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigs(TeaModel):
    def __init__(self, live_record_vod_config=None):
        self.live_record_vod_config = live_record_vod_config  # type: list[DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigsLiveRecordVodConfig]

    def validate(self):
        if self.live_record_vod_config:
            for k in self.live_record_vod_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveRecordVodConfig'] = []
        if self.live_record_vod_config is not None:
            for k in self.live_record_vod_config:
                result['LiveRecordVodConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_record_vod_config = []
        if m.get('LiveRecordVodConfig') is not None:
            for k in m.get('LiveRecordVodConfig'):
                temp_model = DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigsLiveRecordVodConfig()
                self.live_record_vod_config.append(temp_model.from_map(k))
        return self


class DescribeLiveRecordVodConfigsResponseBody(TeaModel):
    def __init__(self, live_record_vod_configs=None, page_num=None, page_size=None, request_id=None, total=None):
        self.live_record_vod_configs = live_record_vod_configs  # type: DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigs
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total = total  # type: str

    def validate(self):
        if self.live_record_vod_configs:
            self.live_record_vod_configs.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordVodConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_record_vod_configs is not None:
            result['LiveRecordVodConfigs'] = self.live_record_vod_configs.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveRecordVodConfigs') is not None:
            temp_model = DescribeLiveRecordVodConfigsResponseBodyLiveRecordVodConfigs()
            self.live_record_vod_configs = temp_model.from_map(m['LiveRecordVodConfigs'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveRecordVodConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveRecordVodConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveRecordVodConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveRecordVodConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveShiftConfigsRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveShiftConfigsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveShiftConfigsResponseBodyContentConfig(TeaModel):
    def __init__(self, app_name=None, domain_name=None, ignore_transcode=None, stream_name=None, vision=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.ignore_transcode = ignore_transcode  # type: bool
        self.stream_name = stream_name  # type: str
        self.vision = vision  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveShiftConfigsResponseBodyContentConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.ignore_transcode is not None:
            result['IgnoreTranscode'] = self.ignore_transcode
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.vision is not None:
            result['Vision'] = self.vision
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('IgnoreTranscode') is not None:
            self.ignore_transcode = m.get('IgnoreTranscode')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Vision') is not None:
            self.vision = m.get('Vision')
        return self


class DescribeLiveShiftConfigsResponseBodyContent(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[DescribeLiveShiftConfigsResponseBodyContentConfig]

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveShiftConfigsResponseBodyContent, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = DescribeLiveShiftConfigsResponseBodyContentConfig()
                self.config.append(temp_model.from_map(k))
        return self


class DescribeLiveShiftConfigsResponseBody(TeaModel):
    def __init__(self, content=None, request_id=None):
        self.content = content  # type: DescribeLiveShiftConfigsResponseBodyContent
        self.request_id = request_id  # type: str

    def validate(self):
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super(DescribeLiveShiftConfigsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            temp_model = DescribeLiveShiftConfigsResponseBodyContent()
            self.content = temp_model.from_map(m['Content'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveShiftConfigsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveShiftConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveShiftConfigsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveShiftConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveSnapshotConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, order=None, owner_id=None, page_num=None, page_size=None,
                 security_token=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.order = order  # type: str
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveSnapshotConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.order is not None:
            result['Order'] = self.order
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigListLiveStreamSnapshotConfig(TeaModel):
    def __init__(self, app_name=None, callback=None, create_time=None, domain_name=None, oss_bucket=None,
                 oss_endpoint=None, overwrite_oss_object=None, sequence_oss_object=None, time_interval=None):
        self.app_name = app_name  # type: str
        self.callback = callback  # type: str
        self.create_time = create_time  # type: str
        self.domain_name = domain_name  # type: str
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.overwrite_oss_object = overwrite_oss_object  # type: str
        self.sequence_oss_object = sequence_oss_object  # type: str
        self.time_interval = time_interval  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigListLiveStreamSnapshotConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.callback is not None:
            result['Callback'] = self.callback
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.overwrite_oss_object is not None:
            result['OverwriteOssObject'] = self.overwrite_oss_object
        if self.sequence_oss_object is not None:
            result['SequenceOssObject'] = self.sequence_oss_object
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Callback') is not None:
            self.callback = m.get('Callback')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OverwriteOssObject') is not None:
            self.overwrite_oss_object = m.get('OverwriteOssObject')
        if m.get('SequenceOssObject') is not None:
            self.sequence_oss_object = m.get('SequenceOssObject')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        return self


class DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigList(TeaModel):
    def __init__(self, live_stream_snapshot_config=None):
        self.live_stream_snapshot_config = live_stream_snapshot_config  # type: list[DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigListLiveStreamSnapshotConfig]

    def validate(self):
        if self.live_stream_snapshot_config:
            for k in self.live_stream_snapshot_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveStreamSnapshotConfig'] = []
        if self.live_stream_snapshot_config is not None:
            for k in self.live_stream_snapshot_config:
                result['LiveStreamSnapshotConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_stream_snapshot_config = []
        if m.get('LiveStreamSnapshotConfig') is not None:
            for k in m.get('LiveStreamSnapshotConfig'):
                temp_model = DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigListLiveStreamSnapshotConfig()
                self.live_stream_snapshot_config.append(temp_model.from_map(k))
        return self


class DescribeLiveSnapshotConfigResponseBody(TeaModel):
    def __init__(self, live_stream_snapshot_config_list=None, order=None, page_num=None, page_size=None,
                 request_id=None, total_num=None, total_page=None):
        self.live_stream_snapshot_config_list = live_stream_snapshot_config_list  # type: DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigList
        self.order = order  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_num = total_num  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.live_stream_snapshot_config_list:
            self.live_stream_snapshot_config_list.validate()

    def to_map(self):
        _map = super(DescribeLiveSnapshotConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_stream_snapshot_config_list is not None:
            result['LiveStreamSnapshotConfigList'] = self.live_stream_snapshot_config_list.to_map()
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveStreamSnapshotConfigList') is not None:
            temp_model = DescribeLiveSnapshotConfigResponseBodyLiveStreamSnapshotConfigList()
            self.live_stream_snapshot_config_list = temp_model.from_map(m['LiveStreamSnapshotConfigList'])
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeLiveSnapshotConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveSnapshotConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveSnapshotConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveSnapshotConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveSnapshotDetectPornConfigRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, order=None, owner_id=None, page_num=None, page_size=None,
                 security_token=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.order = order  # type: str
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.security_token = security_token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveSnapshotDetectPornConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.order is not None:
            result['Order'] = self.order
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        return self


class DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfigScenes(TeaModel):
    def __init__(self, scene=None):
        self.scene = scene  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfigScenes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scene is not None:
            result['scene'] = self.scene
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('scene') is not None:
            self.scene = m.get('scene')
        return self


class DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfig(TeaModel):
    def __init__(self, app_name=None, domain_name=None, interval=None, oss_bucket=None, oss_endpoint=None,
                 oss_object=None, scenes=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.interval = interval  # type: int
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str
        self.scenes = scenes  # type: DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfigScenes

    def validate(self):
        if self.scenes:
            self.scenes.validate()

    def to_map(self):
        _map = super(DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.scenes is not None:
            result['Scenes'] = self.scenes.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('Scenes') is not None:
            temp_model = DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfigScenes()
            self.scenes = temp_model.from_map(m['Scenes'])
        return self


class DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigList(TeaModel):
    def __init__(self, live_snapshot_detect_porn_config=None):
        self.live_snapshot_detect_porn_config = live_snapshot_detect_porn_config  # type: list[DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfig]

    def validate(self):
        if self.live_snapshot_detect_porn_config:
            for k in self.live_snapshot_detect_porn_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveSnapshotDetectPornConfig'] = []
        if self.live_snapshot_detect_porn_config is not None:
            for k in self.live_snapshot_detect_porn_config:
                result['LiveSnapshotDetectPornConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_snapshot_detect_porn_config = []
        if m.get('LiveSnapshotDetectPornConfig') is not None:
            for k in m.get('LiveSnapshotDetectPornConfig'):
                temp_model = DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigListLiveSnapshotDetectPornConfig()
                self.live_snapshot_detect_porn_config.append(temp_model.from_map(k))
        return self


class DescribeLiveSnapshotDetectPornConfigResponseBody(TeaModel):
    def __init__(self, live_snapshot_detect_porn_config_list=None, order=None, page_num=None, page_size=None,
                 request_id=None, total_num=None, total_page=None):
        self.live_snapshot_detect_porn_config_list = live_snapshot_detect_porn_config_list  # type: DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigList
        self.order = order  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_num = total_num  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.live_snapshot_detect_porn_config_list:
            self.live_snapshot_detect_porn_config_list.validate()

    def to_map(self):
        _map = super(DescribeLiveSnapshotDetectPornConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_snapshot_detect_porn_config_list is not None:
            result['LiveSnapshotDetectPornConfigList'] = self.live_snapshot_detect_porn_config_list.to_map()
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveSnapshotDetectPornConfigList') is not None:
            temp_model = DescribeLiveSnapshotDetectPornConfigResponseBodyLiveSnapshotDetectPornConfigList()
            self.live_snapshot_detect_porn_config_list = temp_model.from_map(m['LiveSnapshotDetectPornConfigList'])
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeLiveSnapshotDetectPornConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveSnapshotDetectPornConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveSnapshotDetectPornConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveSnapshotDetectPornConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveSnapshotNotifyConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveSnapshotNotifyConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveSnapshotNotifyConfigResponseBody(TeaModel):
    def __init__(self, domain_name=None, notify_auth_key=None, notify_req_auth=None, notify_url=None,
                 request_id=None):
        self.domain_name = domain_name  # type: str
        self.notify_auth_key = notify_auth_key  # type: str
        self.notify_req_auth = notify_req_auth  # type: str
        self.notify_url = notify_url  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveSnapshotNotifyConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.notify_auth_key is not None:
            result['NotifyAuthKey'] = self.notify_auth_key
        if self.notify_req_auth is not None:
            result['NotifyReqAuth'] = self.notify_req_auth
        if self.notify_url is not None:
            result['NotifyUrl'] = self.notify_url
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('NotifyAuthKey') is not None:
            self.notify_auth_key = m.get('NotifyAuthKey')
        if m.get('NotifyReqAuth') is not None:
            self.notify_req_auth = m.get('NotifyReqAuth')
        if m.get('NotifyUrl') is not None:
            self.notify_url = m.get('NotifyUrl')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveSnapshotNotifyConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveSnapshotNotifyConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveSnapshotNotifyConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveSnapshotNotifyConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamAuthCheckingRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None, url=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamAuthCheckingRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeLiveStreamAuthCheckingResponseBody(TeaModel):
    def __init__(self, description=None, request_id=None, status=None):
        self.description = description  # type: str
        self.request_id = request_id  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamAuthCheckingResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeLiveStreamAuthCheckingResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamAuthCheckingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamAuthCheckingResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamAuthCheckingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamBitRateDataRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, owner_id=None, security_token=None,
                 start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamBitRateDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo(TeaModel):
    def __init__(self, audio_frame_rate=None, bit_rate=None, stream_url=None, time=None, video_frame_rate=None):
        self.audio_frame_rate = audio_frame_rate  # type: float
        self.bit_rate = bit_rate  # type: float
        self.stream_url = stream_url  # type: str
        self.time = time  # type: str
        self.video_frame_rate = video_frame_rate  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_frame_rate is not None:
            result['AudioFrameRate'] = self.audio_frame_rate
        if self.bit_rate is not None:
            result['BitRate'] = self.bit_rate
        if self.stream_url is not None:
            result['StreamUrl'] = self.stream_url
        if self.time is not None:
            result['Time'] = self.time
        if self.video_frame_rate is not None:
            result['VideoFrameRate'] = self.video_frame_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFrameRate') is not None:
            self.audio_frame_rate = m.get('AudioFrameRate')
        if m.get('BitRate') is not None:
            self.bit_rate = m.get('BitRate')
        if m.get('StreamUrl') is not None:
            self.stream_url = m.get('StreamUrl')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('VideoFrameRate') is not None:
            self.video_frame_rate = m.get('VideoFrameRate')
        return self


class DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfos(TeaModel):
    def __init__(self, frame_rate_and_bit_rate_info=None):
        self.frame_rate_and_bit_rate_info = frame_rate_and_bit_rate_info  # type: list[DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo]

    def validate(self):
        if self.frame_rate_and_bit_rate_info:
            for k in self.frame_rate_and_bit_rate_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FrameRateAndBitRateInfo'] = []
        if self.frame_rate_and_bit_rate_info is not None:
            for k in self.frame_rate_and_bit_rate_info:
                result['FrameRateAndBitRateInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.frame_rate_and_bit_rate_info = []
        if m.get('FrameRateAndBitRateInfo') is not None:
            for k in m.get('FrameRateAndBitRateInfo'):
                temp_model = DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfosFrameRateAndBitRateInfo()
                self.frame_rate_and_bit_rate_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamBitRateDataResponseBody(TeaModel):
    def __init__(self, frame_rate_and_bit_rate_infos=None, request_id=None):
        self.frame_rate_and_bit_rate_infos = frame_rate_and_bit_rate_infos  # type: DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfos
        self.request_id = request_id  # type: str

    def validate(self):
        if self.frame_rate_and_bit_rate_infos:
            self.frame_rate_and_bit_rate_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamBitRateDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.frame_rate_and_bit_rate_infos is not None:
            result['FrameRateAndBitRateInfos'] = self.frame_rate_and_bit_rate_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FrameRateAndBitRateInfos') is not None:
            temp_model = DescribeLiveStreamBitRateDataResponseBodyFrameRateAndBitRateInfos()
            self.frame_rate_and_bit_rate_infos = temp_model.from_map(m['FrameRateAndBitRateInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamBitRateDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamBitRateDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamBitRateDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamBitRateDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamCountRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamCountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetailsStreamCountDetail(TeaModel):
    def __init__(self, count=None, format=None, video_data_rate=None):
        self.count = count  # type: long
        self.format = format  # type: str
        self.video_data_rate = video_data_rate  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetailsStreamCountDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.format is not None:
            result['Format'] = self.format
        if self.video_data_rate is not None:
            result['VideoDataRate'] = self.video_data_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('VideoDataRate') is not None:
            self.video_data_rate = m.get('VideoDataRate')
        return self


class DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetails(TeaModel):
    def __init__(self, stream_count_detail=None):
        self.stream_count_detail = stream_count_detail  # type: list[DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetailsStreamCountDetail]

    def validate(self):
        if self.stream_count_detail:
            for k in self.stream_count_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamCountDetail'] = []
        if self.stream_count_detail is not None:
            for k in self.stream_count_detail:
                result['StreamCountDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.stream_count_detail = []
        if m.get('StreamCountDetail') is not None:
            for k in m.get('StreamCountDetail'):
                temp_model = DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetailsStreamCountDetail()
                self.stream_count_detail.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfo(TeaModel):
    def __init__(self, count=None, limit=None, stream_count_details=None, type=None):
        self.count = count  # type: long
        self.limit = limit  # type: long
        self.stream_count_details = stream_count_details  # type: DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetails
        self.type = type  # type: str

    def validate(self):
        if self.stream_count_details:
            self.stream_count_details.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.stream_count_details is not None:
            result['StreamCountDetails'] = self.stream_count_details.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('StreamCountDetails') is not None:
            temp_model = DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfoStreamCountDetails()
            self.stream_count_details = temp_model.from_map(m['StreamCountDetails'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeLiveStreamCountResponseBodyStreamCountInfos(TeaModel):
    def __init__(self, stream_count_info=None):
        self.stream_count_info = stream_count_info  # type: list[DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfo]

    def validate(self):
        if self.stream_count_info:
            for k in self.stream_count_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamCountResponseBodyStreamCountInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamCountInfo'] = []
        if self.stream_count_info is not None:
            for k in self.stream_count_info:
                result['StreamCountInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.stream_count_info = []
        if m.get('StreamCountInfo') is not None:
            for k in m.get('StreamCountInfo'):
                temp_model = DescribeLiveStreamCountResponseBodyStreamCountInfosStreamCountInfo()
                self.stream_count_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamCountResponseBody(TeaModel):
    def __init__(self, request_id=None, stream_count_infos=None):
        self.request_id = request_id  # type: str
        self.stream_count_infos = stream_count_infos  # type: DescribeLiveStreamCountResponseBodyStreamCountInfos

    def validate(self):
        if self.stream_count_infos:
            self.stream_count_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamCountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stream_count_infos is not None:
            result['StreamCountInfos'] = self.stream_count_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StreamCountInfos') is not None:
            temp_model = DescribeLiveStreamCountResponseBodyStreamCountInfos()
            self.stream_count_infos = temp_model.from_map(m['StreamCountInfos'])
        return self


class DescribeLiveStreamCountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamCountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamCountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamDelayConfigRequest(TeaModel):
    def __init__(self, domain_name=None, owner_id=None):
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamDelayConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveStreamDelayConfigResponseBodyLiveStreamFlvDelayConfig(TeaModel):
    def __init__(self, delay=None, level=None):
        self.delay = delay  # type: int
        self.level = level  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamDelayConfigResponseBodyLiveStreamFlvDelayConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeLiveStreamDelayConfigResponseBodyLiveStreamHlsDelayConfig(TeaModel):
    def __init__(self, delay=None, level=None):
        self.delay = delay  # type: int
        self.level = level  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamDelayConfigResponseBodyLiveStreamHlsDelayConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeLiveStreamDelayConfigResponseBodyLiveStreamRtmpDelayConfig(TeaModel):
    def __init__(self, delay=None, level=None):
        self.delay = delay  # type: int
        self.level = level  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamDelayConfigResponseBodyLiveStreamRtmpDelayConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeLiveStreamDelayConfigResponseBody(TeaModel):
    def __init__(self, live_stream_flv_delay_config=None, live_stream_hls_delay_config=None,
                 live_stream_rtmp_delay_config=None, request_id=None):
        self.live_stream_flv_delay_config = live_stream_flv_delay_config  # type: DescribeLiveStreamDelayConfigResponseBodyLiveStreamFlvDelayConfig
        self.live_stream_hls_delay_config = live_stream_hls_delay_config  # type: DescribeLiveStreamDelayConfigResponseBodyLiveStreamHlsDelayConfig
        self.live_stream_rtmp_delay_config = live_stream_rtmp_delay_config  # type: DescribeLiveStreamDelayConfigResponseBodyLiveStreamRtmpDelayConfig
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_stream_flv_delay_config:
            self.live_stream_flv_delay_config.validate()
        if self.live_stream_hls_delay_config:
            self.live_stream_hls_delay_config.validate()
        if self.live_stream_rtmp_delay_config:
            self.live_stream_rtmp_delay_config.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamDelayConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_stream_flv_delay_config is not None:
            result['LiveStreamFlvDelayConfig'] = self.live_stream_flv_delay_config.to_map()
        if self.live_stream_hls_delay_config is not None:
            result['LiveStreamHlsDelayConfig'] = self.live_stream_hls_delay_config.to_map()
        if self.live_stream_rtmp_delay_config is not None:
            result['LiveStreamRtmpDelayConfig'] = self.live_stream_rtmp_delay_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveStreamFlvDelayConfig') is not None:
            temp_model = DescribeLiveStreamDelayConfigResponseBodyLiveStreamFlvDelayConfig()
            self.live_stream_flv_delay_config = temp_model.from_map(m['LiveStreamFlvDelayConfig'])
        if m.get('LiveStreamHlsDelayConfig') is not None:
            temp_model = DescribeLiveStreamDelayConfigResponseBodyLiveStreamHlsDelayConfig()
            self.live_stream_hls_delay_config = temp_model.from_map(m['LiveStreamHlsDelayConfig'])
        if m.get('LiveStreamRtmpDelayConfig') is not None:
            temp_model = DescribeLiveStreamDelayConfigResponseBodyLiveStreamRtmpDelayConfig()
            self.live_stream_rtmp_delay_config = temp_model.from_map(m['LiveStreamRtmpDelayConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamDelayConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamDelayConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamDelayConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamDelayConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamHistoryUserNumRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, owner_id=None, security_token=None,
                 start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamHistoryUserNumRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfosLiveStreamUserNumInfo(TeaModel):
    def __init__(self, stream_time=None, user_num=None):
        self.stream_time = stream_time  # type: str
        self.user_num = user_num  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfosLiveStreamUserNumInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stream_time is not None:
            result['StreamTime'] = self.stream_time
        if self.user_num is not None:
            result['UserNum'] = self.user_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('StreamTime') is not None:
            self.stream_time = m.get('StreamTime')
        if m.get('UserNum') is not None:
            self.user_num = m.get('UserNum')
        return self


class DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfos(TeaModel):
    def __init__(self, live_stream_user_num_info=None):
        self.live_stream_user_num_info = live_stream_user_num_info  # type: list[DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfosLiveStreamUserNumInfo]

    def validate(self):
        if self.live_stream_user_num_info:
            for k in self.live_stream_user_num_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveStreamUserNumInfo'] = []
        if self.live_stream_user_num_info is not None:
            for k in self.live_stream_user_num_info:
                result['LiveStreamUserNumInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_stream_user_num_info = []
        if m.get('LiveStreamUserNumInfo') is not None:
            for k in m.get('LiveStreamUserNumInfo'):
                temp_model = DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfosLiveStreamUserNumInfo()
                self.live_stream_user_num_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamHistoryUserNumResponseBody(TeaModel):
    def __init__(self, live_stream_user_num_infos=None, request_id=None):
        self.live_stream_user_num_infos = live_stream_user_num_infos  # type: DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfos
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_stream_user_num_infos:
            self.live_stream_user_num_infos.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamHistoryUserNumResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_stream_user_num_infos is not None:
            result['LiveStreamUserNumInfos'] = self.live_stream_user_num_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveStreamUserNumInfos') is not None:
            temp_model = DescribeLiveStreamHistoryUserNumResponseBodyLiveStreamUserNumInfos()
            self.live_stream_user_num_infos = temp_model.from_map(m['LiveStreamUserNumInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamHistoryUserNumResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamHistoryUserNumResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamHistoryUserNumResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamHistoryUserNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamMetricDetailDataRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, next_page_token=None, owner_id=None,
                 protocol=None, start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.next_page_token = next_page_token  # type: str
        self.owner_id = owner_id  # type: long
        self.protocol = protocol  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamMetricDetailDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveStreamMetricDetailDataResponseBodyStreamDetailDataStreamData(TeaModel):
    def __init__(self, app_name=None, bps=None, count=None, flv_bps=None, flv_count=None, flv_traffic=None,
                 hls_bps=None, hls_count=None, hls_traffic=None, p_2p_bps=None, p_2p_count=None, p_2p_traffic=None,
                 rtmp_bps=None, rtmp_count=None, rtmp_traffic=None, rts_bps=None, rts_count=None, rts_traffic=None,
                 stream_name=None, time_stamp=None, traffic=None):
        self.app_name = app_name  # type: str
        self.bps = bps  # type: float
        self.count = count  # type: long
        self.flv_bps = flv_bps  # type: float
        self.flv_count = flv_count  # type: long
        self.flv_traffic = flv_traffic  # type: long
        self.hls_bps = hls_bps  # type: float
        self.hls_count = hls_count  # type: long
        self.hls_traffic = hls_traffic  # type: long
        self.p_2p_bps = p_2p_bps  # type: float
        self.p_2p_count = p_2p_count  # type: long
        self.p_2p_traffic = p_2p_traffic  # type: long
        self.rtmp_bps = rtmp_bps  # type: float
        self.rtmp_count = rtmp_count  # type: long
        self.rtmp_traffic = rtmp_traffic  # type: long
        self.rts_bps = rts_bps  # type: float
        self.rts_count = rts_count  # type: long
        self.rts_traffic = rts_traffic  # type: long
        self.stream_name = stream_name  # type: str
        self.time_stamp = time_stamp  # type: str
        self.traffic = traffic  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamMetricDetailDataResponseBodyStreamDetailDataStreamData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.bps is not None:
            result['Bps'] = self.bps
        if self.count is not None:
            result['Count'] = self.count
        if self.flv_bps is not None:
            result['FlvBps'] = self.flv_bps
        if self.flv_count is not None:
            result['FlvCount'] = self.flv_count
        if self.flv_traffic is not None:
            result['FlvTraffic'] = self.flv_traffic
        if self.hls_bps is not None:
            result['HlsBps'] = self.hls_bps
        if self.hls_count is not None:
            result['HlsCount'] = self.hls_count
        if self.hls_traffic is not None:
            result['HlsTraffic'] = self.hls_traffic
        if self.p_2p_bps is not None:
            result['P2pBps'] = self.p_2p_bps
        if self.p_2p_count is not None:
            result['P2pCount'] = self.p_2p_count
        if self.p_2p_traffic is not None:
            result['P2pTraffic'] = self.p_2p_traffic
        if self.rtmp_bps is not None:
            result['RtmpBps'] = self.rtmp_bps
        if self.rtmp_count is not None:
            result['RtmpCount'] = self.rtmp_count
        if self.rtmp_traffic is not None:
            result['RtmpTraffic'] = self.rtmp_traffic
        if self.rts_bps is not None:
            result['RtsBps'] = self.rts_bps
        if self.rts_count is not None:
            result['RtsCount'] = self.rts_count
        if self.rts_traffic is not None:
            result['RtsTraffic'] = self.rts_traffic
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.time_stamp is not None:
            result['TimeStamp'] = self.time_stamp
        if self.traffic is not None:
            result['Traffic'] = self.traffic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Bps') is not None:
            self.bps = m.get('Bps')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('FlvBps') is not None:
            self.flv_bps = m.get('FlvBps')
        if m.get('FlvCount') is not None:
            self.flv_count = m.get('FlvCount')
        if m.get('FlvTraffic') is not None:
            self.flv_traffic = m.get('FlvTraffic')
        if m.get('HlsBps') is not None:
            self.hls_bps = m.get('HlsBps')
        if m.get('HlsCount') is not None:
            self.hls_count = m.get('HlsCount')
        if m.get('HlsTraffic') is not None:
            self.hls_traffic = m.get('HlsTraffic')
        if m.get('P2pBps') is not None:
            self.p_2p_bps = m.get('P2pBps')
        if m.get('P2pCount') is not None:
            self.p_2p_count = m.get('P2pCount')
        if m.get('P2pTraffic') is not None:
            self.p_2p_traffic = m.get('P2pTraffic')
        if m.get('RtmpBps') is not None:
            self.rtmp_bps = m.get('RtmpBps')
        if m.get('RtmpCount') is not None:
            self.rtmp_count = m.get('RtmpCount')
        if m.get('RtmpTraffic') is not None:
            self.rtmp_traffic = m.get('RtmpTraffic')
        if m.get('RtsBps') is not None:
            self.rts_bps = m.get('RtsBps')
        if m.get('RtsCount') is not None:
            self.rts_count = m.get('RtsCount')
        if m.get('RtsTraffic') is not None:
            self.rts_traffic = m.get('RtsTraffic')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('TimeStamp') is not None:
            self.time_stamp = m.get('TimeStamp')
        if m.get('Traffic') is not None:
            self.traffic = m.get('Traffic')
        return self


class DescribeLiveStreamMetricDetailDataResponseBodyStreamDetailData(TeaModel):
    def __init__(self, stream_data=None):
        self.stream_data = stream_data  # type: list[DescribeLiveStreamMetricDetailDataResponseBodyStreamDetailDataStreamData]

    def validate(self):
        if self.stream_data:
            for k in self.stream_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamMetricDetailDataResponseBodyStreamDetailData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['StreamData'] = []
        if self.stream_data is not None:
            for k in self.stream_data:
                result['StreamData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.stream_data = []
        if m.get('StreamData') is not None:
            for k in m.get('StreamData'):
                temp_model = DescribeLiveStreamMetricDetailDataResponseBodyStreamDetailDataStreamData()
                self.stream_data.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamMetricDetailDataResponseBody(TeaModel):
    def __init__(self, domain_name=None, end_time=None, next_page_token=None, page_size=None, request_id=None,
                 start_time=None, stream_detail_data=None):
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.next_page_token = next_page_token  # type: str
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.start_time = start_time  # type: str
        self.stream_detail_data = stream_detail_data  # type: DescribeLiveStreamMetricDetailDataResponseBodyStreamDetailData

    def validate(self):
        if self.stream_detail_data:
            self.stream_detail_data.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamMetricDetailDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.next_page_token is not None:
            result['NextPageToken'] = self.next_page_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_detail_data is not None:
            result['StreamDetailData'] = self.stream_detail_data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NextPageToken') is not None:
            self.next_page_token = m.get('NextPageToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamDetailData') is not None:
            temp_model = DescribeLiveStreamMetricDetailDataResponseBodyStreamDetailData()
            self.stream_detail_data = temp_model.from_map(m['StreamDetailData'])
        return self


class DescribeLiveStreamMetricDetailDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamMetricDetailDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamMetricDetailDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamMetricDetailDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamMonitorListRequest(TeaModel):
    def __init__(self, monitor_id=None, order_rule=None, owner_id=None, page_num=None, page_size=None, status=None):
        self.monitor_id = monitor_id  # type: str
        self.order_rule = order_rule  # type: int
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamMonitorListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_id is not None:
            result['MonitorId'] = self.monitor_id
        if self.order_rule is not None:
            result['OrderRule'] = self.order_rule
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MonitorId') is not None:
            self.monitor_id = m.get('MonitorId')
        if m.get('OrderRule') is not None:
            self.order_rule = m.get('OrderRule')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputListLayoutConfig(TeaModel):
    def __init__(self, fill_mode=None, position_normalized=None, position_refer=None, size_normalized=None):
        self.fill_mode = fill_mode  # type: str
        self.position_normalized = position_normalized  # type: list[float]
        self.position_refer = position_refer  # type: str
        self.size_normalized = size_normalized  # type: list[float]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputListLayoutConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fill_mode is not None:
            result['FillMode'] = self.fill_mode
        if self.position_normalized is not None:
            result['PositionNormalized'] = self.position_normalized
        if self.position_refer is not None:
            result['PositionRefer'] = self.position_refer
        if self.size_normalized is not None:
            result['SizeNormalized'] = self.size_normalized
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FillMode') is not None:
            self.fill_mode = m.get('FillMode')
        if m.get('PositionNormalized') is not None:
            self.position_normalized = m.get('PositionNormalized')
        if m.get('PositionRefer') is not None:
            self.position_refer = m.get('PositionRefer')
        if m.get('SizeNormalized') is not None:
            self.size_normalized = m.get('SizeNormalized')
        return self


class DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputListPlayConfig(TeaModel):
    def __init__(self, volume_rate=None):
        self.volume_rate = volume_rate  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputListPlayConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.volume_rate is not None:
            result['VolumeRate'] = self.volume_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VolumeRate') is not None:
            self.volume_rate = m.get('VolumeRate')
        return self


class DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputList(TeaModel):
    def __init__(self, index=None, input_url=None, layout_config=None, layout_id=None, play_config=None,
                 stream_name=None):
        self.index = index  # type: int
        self.input_url = input_url  # type: str
        self.layout_config = layout_config  # type: DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputListLayoutConfig
        self.layout_id = layout_id  # type: int
        self.play_config = play_config  # type: DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputListPlayConfig
        self.stream_name = stream_name  # type: str

    def validate(self):
        if self.layout_config:
            self.layout_config.validate()
        if self.play_config:
            self.play_config.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.input_url is not None:
            result['InputUrl'] = self.input_url
        if self.layout_config is not None:
            result['LayoutConfig'] = self.layout_config.to_map()
        if self.layout_id is not None:
            result['LayoutId'] = self.layout_id
        if self.play_config is not None:
            result['PlayConfig'] = self.play_config.to_map()
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('InputUrl') is not None:
            self.input_url = m.get('InputUrl')
        if m.get('LayoutConfig') is not None:
            temp_model = DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputListLayoutConfig()
            self.layout_config = temp_model.from_map(m['LayoutConfig'])
        if m.get('LayoutId') is not None:
            self.layout_id = m.get('LayoutId')
        if m.get('PlayConfig') is not None:
            temp_model = DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputListPlayConfig()
            self.play_config = temp_model.from_map(m['PlayConfig'])
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListOutputUrls(TeaModel):
    def __init__(self, flv_url=None, rtmp_url=None):
        self.flv_url = flv_url  # type: str
        self.rtmp_url = rtmp_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListOutputUrls, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flv_url is not None:
            result['FlvUrl'] = self.flv_url
        if self.rtmp_url is not None:
            result['RtmpUrl'] = self.rtmp_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FlvUrl') is not None:
            self.flv_url = m.get('FlvUrl')
        if m.get('RtmpUrl') is not None:
            self.rtmp_url = m.get('RtmpUrl')
        return self


class DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorList(TeaModel):
    def __init__(self, audio_from=None, domain=None, input_list=None, monitor_id=None, monitor_name=None,
                 output_template=None, output_urls=None, region=None, start_time=None, status=None, stop_time=None):
        self.audio_from = audio_from  # type: int
        self.domain = domain  # type: str
        self.input_list = input_list  # type: list[DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputList]
        self.monitor_id = monitor_id  # type: str
        self.monitor_name = monitor_name  # type: str
        self.output_template = output_template  # type: str
        self.output_urls = output_urls  # type: DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListOutputUrls
        self.region = region  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: int
        self.stop_time = stop_time  # type: str

    def validate(self):
        if self.input_list:
            for k in self.input_list:
                if k:
                    k.validate()
        if self.output_urls:
            self.output_urls.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_from is not None:
            result['AudioFrom'] = self.audio_from
        if self.domain is not None:
            result['Domain'] = self.domain
        result['InputList'] = []
        if self.input_list is not None:
            for k in self.input_list:
                result['InputList'].append(k.to_map() if k else None)
        if self.monitor_id is not None:
            result['MonitorId'] = self.monitor_id
        if self.monitor_name is not None:
            result['MonitorName'] = self.monitor_name
        if self.output_template is not None:
            result['OutputTemplate'] = self.output_template
        if self.output_urls is not None:
            result['OutputUrls'] = self.output_urls.to_map()
        if self.region is not None:
            result['Region'] = self.region
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AudioFrom') is not None:
            self.audio_from = m.get('AudioFrom')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        self.input_list = []
        if m.get('InputList') is not None:
            for k in m.get('InputList'):
                temp_model = DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListInputList()
                self.input_list.append(temp_model.from_map(k))
        if m.get('MonitorId') is not None:
            self.monitor_id = m.get('MonitorId')
        if m.get('MonitorName') is not None:
            self.monitor_name = m.get('MonitorName')
        if m.get('OutputTemplate') is not None:
            self.output_template = m.get('OutputTemplate')
        if m.get('OutputUrls') is not None:
            temp_model = DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorListOutputUrls()
            self.output_urls = temp_model.from_map(m['OutputUrls'])
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        return self


class DescribeLiveStreamMonitorListResponseBody(TeaModel):
    def __init__(self, live_stream_monitor_list=None, request_id=None, total=None):
        self.live_stream_monitor_list = live_stream_monitor_list  # type: list[DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorList]
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.live_stream_monitor_list:
            for k in self.live_stream_monitor_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamMonitorListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveStreamMonitorList'] = []
        if self.live_stream_monitor_list is not None:
            for k in self.live_stream_monitor_list:
                result['LiveStreamMonitorList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_stream_monitor_list = []
        if m.get('LiveStreamMonitorList') is not None:
            for k in m.get('LiveStreamMonitorList'):
                temp_model = DescribeLiveStreamMonitorListResponseBodyLiveStreamMonitorList()
                self.live_stream_monitor_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeLiveStreamMonitorListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamMonitorListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamMonitorListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamMonitorListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamOptimizedFeatureConfigRequest(TeaModel):
    def __init__(self, config_name=None, domain_name=None, owner_id=None):
        self.config_name = config_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamOptimizedFeatureConfigRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigListLiveStreamOptimizedFeatureConfig(TeaModel):
    def __init__(self, config_name=None, config_status=None, config_value=None, domain_name=None):
        self.config_name = config_name  # type: str
        self.config_status = config_status  # type: str
        self.config_value = config_value  # type: str
        self.domain_name = domain_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigListLiveStreamOptimizedFeatureConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.config_status is not None:
            result['ConfigStatus'] = self.config_status
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ConfigStatus') is not None:
            self.config_status = m.get('ConfigStatus')
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigList(TeaModel):
    def __init__(self, live_stream_optimized_feature_config=None):
        self.live_stream_optimized_feature_config = live_stream_optimized_feature_config  # type: list[DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigListLiveStreamOptimizedFeatureConfig]

    def validate(self):
        if self.live_stream_optimized_feature_config:
            for k in self.live_stream_optimized_feature_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveStreamOptimizedFeatureConfig'] = []
        if self.live_stream_optimized_feature_config is not None:
            for k in self.live_stream_optimized_feature_config:
                result['LiveStreamOptimizedFeatureConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_stream_optimized_feature_config = []
        if m.get('LiveStreamOptimizedFeatureConfig') is not None:
            for k in m.get('LiveStreamOptimizedFeatureConfig'):
                temp_model = DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigListLiveStreamOptimizedFeatureConfig()
                self.live_stream_optimized_feature_config.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamOptimizedFeatureConfigResponseBody(TeaModel):
    def __init__(self, live_stream_optimized_feature_config_list=None, request_id=None):
        self.live_stream_optimized_feature_config_list = live_stream_optimized_feature_config_list  # type: DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_stream_optimized_feature_config_list:
            self.live_stream_optimized_feature_config_list.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamOptimizedFeatureConfigResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_stream_optimized_feature_config_list is not None:
            result['LiveStreamOptimizedFeatureConfigList'] = self.live_stream_optimized_feature_config_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveStreamOptimizedFeatureConfigList') is not None:
            temp_model = DescribeLiveStreamOptimizedFeatureConfigResponseBodyLiveStreamOptimizedFeatureConfigList()
            self.live_stream_optimized_feature_config_list = temp_model.from_map(m['LiveStreamOptimizedFeatureConfigList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamOptimizedFeatureConfigResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamOptimizedFeatureConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamOptimizedFeatureConfigResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamOptimizedFeatureConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamRecordContentRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, owner_id=None, security_token=None,
                 start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamRecordContentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveStreamRecordContentResponseBodyRecordContentInfoListRecordContentInfo(TeaModel):
    def __init__(self, duration=None, end_time=None, oss_bucket=None, oss_endpoint=None, oss_object_prefix=None,
                 start_time=None):
        self.duration = duration  # type: float
        self.end_time = end_time  # type: str
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object_prefix = oss_object_prefix  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamRecordContentResponseBodyRecordContentInfoListRecordContentInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object_prefix is not None:
            result['OssObjectPrefix'] = self.oss_object_prefix
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObjectPrefix') is not None:
            self.oss_object_prefix = m.get('OssObjectPrefix')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeLiveStreamRecordContentResponseBodyRecordContentInfoList(TeaModel):
    def __init__(self, record_content_info=None):
        self.record_content_info = record_content_info  # type: list[DescribeLiveStreamRecordContentResponseBodyRecordContentInfoListRecordContentInfo]

    def validate(self):
        if self.record_content_info:
            for k in self.record_content_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamRecordContentResponseBodyRecordContentInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordContentInfo'] = []
        if self.record_content_info is not None:
            for k in self.record_content_info:
                result['RecordContentInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.record_content_info = []
        if m.get('RecordContentInfo') is not None:
            for k in m.get('RecordContentInfo'):
                temp_model = DescribeLiveStreamRecordContentResponseBodyRecordContentInfoListRecordContentInfo()
                self.record_content_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamRecordContentResponseBody(TeaModel):
    def __init__(self, record_content_info_list=None, request_id=None):
        self.record_content_info_list = record_content_info_list  # type: DescribeLiveStreamRecordContentResponseBodyRecordContentInfoList
        self.request_id = request_id  # type: str

    def validate(self):
        if self.record_content_info_list:
            self.record_content_info_list.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamRecordContentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_content_info_list is not None:
            result['RecordContentInfoList'] = self.record_content_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecordContentInfoList') is not None:
            temp_model = DescribeLiveStreamRecordContentResponseBodyRecordContentInfoList()
            self.record_content_info_list = temp_model.from_map(m['RecordContentInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamRecordContentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamRecordContentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamRecordContentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamRecordContentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamRecordIndexFileRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, record_id=None, security_token=None,
                 stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.record_id = record_id  # type: str
        self.security_token = security_token  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFileRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveStreamRecordIndexFileResponseBodyRecordIndexInfo(TeaModel):
    def __init__(self, app_name=None, create_time=None, domain_name=None, duration=None, end_time=None, height=None,
                 oss_bucket=None, oss_endpoint=None, oss_object=None, record_id=None, record_url=None, start_time=None,
                 stream_name=None, width=None):
        self.app_name = app_name  # type: str
        self.create_time = create_time  # type: str
        self.domain_name = domain_name  # type: str
        self.duration = duration  # type: float
        self.end_time = end_time  # type: str
        self.height = height  # type: int
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str
        self.record_id = record_id  # type: str
        self.record_url = record_url  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFileResponseBodyRecordIndexInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.height is not None:
            result['Height'] = self.height
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class DescribeLiveStreamRecordIndexFileResponseBody(TeaModel):
    def __init__(self, record_index_info=None, request_id=None):
        self.record_index_info = record_index_info  # type: DescribeLiveStreamRecordIndexFileResponseBodyRecordIndexInfo
        self.request_id = request_id  # type: str

    def validate(self):
        if self.record_index_info:
            self.record_index_info.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFileResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_index_info is not None:
            result['RecordIndexInfo'] = self.record_index_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RecordIndexInfo') is not None:
            temp_model = DescribeLiveStreamRecordIndexFileResponseBodyRecordIndexInfo()
            self.record_index_info = temp_model.from_map(m['RecordIndexInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamRecordIndexFileResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamRecordIndexFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFileResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamRecordIndexFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamRecordIndexFilesRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, order=None, owner_id=None, page_num=None,
                 page_size=None, security_token=None, start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.order = order  # type: str
        self.owner_id = owner_id  # type: long
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.security_token = security_token  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFilesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.order is not None:
            result['Order'] = self.order
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoListRecordIndexInfo(TeaModel):
    def __init__(self, app_name=None, create_time=None, domain_name=None, duration=None, end_time=None, height=None,
                 oss_bucket=None, oss_endpoint=None, oss_object=None, record_id=None, record_url=None, start_time=None,
                 stream_name=None, width=None):
        self.app_name = app_name  # type: str
        self.create_time = create_time  # type: str
        self.domain_name = domain_name  # type: str
        self.duration = duration  # type: float
        self.end_time = end_time  # type: str
        self.height = height  # type: int
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str
        self.record_id = record_id  # type: str
        self.record_url = record_url  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str
        self.width = width  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoListRecordIndexInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.height is not None:
            result['Height'] = self.height
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.record_url is not None:
            result['RecordUrl'] = self.record_url
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        if self.width is not None:
            result['Width'] = self.width
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Height') is not None:
            self.height = m.get('Height')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RecordUrl') is not None:
            self.record_url = m.get('RecordUrl')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        if m.get('Width') is not None:
            self.width = m.get('Width')
        return self


class DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoList(TeaModel):
    def __init__(self, record_index_info=None):
        self.record_index_info = record_index_info  # type: list[DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoListRecordIndexInfo]

    def validate(self):
        if self.record_index_info:
            for k in self.record_index_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordIndexInfo'] = []
        if self.record_index_info is not None:
            for k in self.record_index_info:
                result['RecordIndexInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.record_index_info = []
        if m.get('RecordIndexInfo') is not None:
            for k in m.get('RecordIndexInfo'):
                temp_model = DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoListRecordIndexInfo()
                self.record_index_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamRecordIndexFilesResponseBody(TeaModel):
    def __init__(self, order=None, page_num=None, page_size=None, record_index_info_list=None, request_id=None,
                 total_num=None, total_page=None):
        self.order = order  # type: str
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.record_index_info_list = record_index_info_list  # type: DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoList
        self.request_id = request_id  # type: str
        self.total_num = total_num  # type: int
        self.total_page = total_page  # type: int

    def validate(self):
        if self.record_index_info_list:
            self.record_index_info_list.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFilesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order is not None:
            result['Order'] = self.order
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_index_info_list is not None:
            result['RecordIndexInfoList'] = self.record_index_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordIndexInfoList') is not None:
            temp_model = DescribeLiveStreamRecordIndexFilesResponseBodyRecordIndexInfoList()
            self.record_index_info_list = temp_model.from_map(m['RecordIndexInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        return self


class DescribeLiveStreamRecordIndexFilesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamRecordIndexFilesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamRecordIndexFilesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamRecordIndexFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamSnapshotInfoRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, end_time=None, limit=None, order=None, owner_id=None,
                 security_token=None, start_time=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.end_time = end_time  # type: str
        self.limit = limit  # type: int
        self.order = order  # type: str
        self.owner_id = owner_id  # type: long
        self.security_token = security_token  # type: str
        self.start_time = start_time  # type: str
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamSnapshotInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.order is not None:
            result['Order'] = self.order
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.security_token is not None:
            result['SecurityToken'] = self.security_token
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SecurityToken') is not None:
            self.security_token = m.get('SecurityToken')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StreamName') is not None:
            self.stream_name = m.get('StreamName')
        return self


class DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoListLiveStreamSnapshotInfo(TeaModel):
    def __init__(self, create_time=None, create_timestamp=None, is_overlay=None, oss_bucket=None, oss_endpoint=None,
                 oss_object=None):
        self.create_time = create_time  # type: str
        self.create_timestamp = create_timestamp  # type: long
        self.is_overlay = is_overlay  # type: bool
        self.oss_bucket = oss_bucket  # type: str
        self.oss_endpoint = oss_endpoint  # type: str
        self.oss_object = oss_object  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoListLiveStreamSnapshotInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.is_overlay is not None:
            result['IsOverlay'] = self.is_overlay
        if self.oss_bucket is not None:
            result['OssBucket'] = self.oss_bucket
        if self.oss_endpoint is not None:
            result['OssEndpoint'] = self.oss_endpoint
        if self.oss_object is not None:
            result['OssObject'] = self.oss_object
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('IsOverlay') is not None:
            self.is_overlay = m.get('IsOverlay')
        if m.get('OssBucket') is not None:
            self.oss_bucket = m.get('OssBucket')
        if m.get('OssEndpoint') is not None:
            self.oss_endpoint = m.get('OssEndpoint')
        if m.get('OssObject') is not None:
            self.oss_object = m.get('OssObject')
        return self


class DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoList(TeaModel):
    def __init__(self, live_stream_snapshot_info=None):
        self.live_stream_snapshot_info = live_stream_snapshot_info  # type: list[DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoListLiveStreamSnapshotInfo]

    def validate(self):
        if self.live_stream_snapshot_info:
            for k in self.live_stream_snapshot_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LiveStreamSnapshotInfo'] = []
        if self.live_stream_snapshot_info is not None:
            for k in self.live_stream_snapshot_info:
                result['LiveStreamSnapshotInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.live_stream_snapshot_info = []
        if m.get('LiveStreamSnapshotInfo') is not None:
            for k in m.get('LiveStreamSnapshotInfo'):
                temp_model = DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoListLiveStreamSnapshotInfo()
                self.live_stream_snapshot_info.append(temp_model.from_map(k))
        return self


class DescribeLiveStreamSnapshotInfoResponseBody(TeaModel):
    def __init__(self, live_stream_snapshot_info_list=None, next_start_time=None, request_id=None):
        self.live_stream_snapshot_info_list = live_stream_snapshot_info_list  # type: DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoList
        self.next_start_time = next_start_time  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.live_stream_snapshot_info_list:
            self.live_stream_snapshot_info_list.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamSnapshotInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_stream_snapshot_info_list is not None:
            result['LiveStreamSnapshotInfoList'] = self.live_stream_snapshot_info_list.to_map()
        if self.next_start_time is not None:
            result['NextStartTime'] = self.next_start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LiveStreamSnapshotInfoList') is not None:
            temp_model = DescribeLiveStreamSnapshotInfoResponseBodyLiveStreamSnapshotInfoList()
            self.live_stream_snapshot_info_list = temp_model.from_map(m['LiveStreamSnapshotInfoList'])
        if m.get('NextStartTime') is not None:
            self.next_start_time = m.get('NextStartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeLiveStreamSnapshotInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeLiveStreamSnapshotInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeLiveStreamSnapshotInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLiveStreamSnapshotInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLiveStreamStateRequest(TeaModel):
    def __init__(self, app_name=None, domain_name=None, owner_id=None, stream_name=None):
        self.app_name = app_name  # type: str
        self.domain_name = domain_name  # type: str
        self.owner_id = owner_id  # type: long
        self.stream_name = stream_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeLiveStreamStateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.stream_name is not None:
            result['StreamName'] = self.stream_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
  