/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.error.Error;

public enum DatabaseType {
    DB_MEM("mem:"),
    DB_FILE("file:"),
    DB_RES("res:");

    private String value;

    private DatabaseType(String value) {
        this.value = value;
    }

    public static DatabaseType get(String value) {
        if (DatabaseType.DB_MEM.value.equals(value)) {
            return DB_MEM;
        }
        if (DatabaseType.DB_FILE.value.equals(value)) {
            return DB_FILE;
        }
        if (DatabaseType.DB_RES.value.equals(value)) {
            return DB_RES;
        }
        throw Error.runtimeError(201, "DatabaseType");
    }

    public String value() {
        return this.value;
    }

    public boolean isFileBased() {
        switch (this) {
            case DB_FILE: 
            case DB_RES: {
                return true;
            }
        }
        return false;
    }
}

