import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { Construct, IResource, Resource } from '@aws-cdk/core';
/**
 * Represents an APIGatewayV2 DomainName
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 */
export interface IDomainName extends IResource {
    /**
     * The custom domain name
     *
     * @attribute
     *
     */
    readonly domainName: string;
    /**
     * The domain name associated with the regional endpoint for this custom domain name.
     *
     * @attribute
     */
    readonly regionalDomainName: string;
    /**
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @attribute
     */
    readonly regionalHostedZoneId: string;
}
/**
 * custom domain name attributes
 */
export interface DomainNameAttributes {
    /**
     * domain name string
     */
    readonly domainName: string;
    /**
     * The domain name associated with the regional endpoint for this custom domain name.
     */
    readonly regionalDomainName: string;
    /**
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     */
    readonly regionalHostedZoneId: string;
}
/**
 * properties used for creating the DomainName
 */
export interface DomainNameProps {
    /**
     * The custom domain name
     */
    readonly domainName: string;
    /**
     * The ACM certificate for this domain name
     */
    readonly certificate: ICertificate;
}
/**
 * Custom domain resource for the API
 */
export declare class DomainName extends Resource implements IDomainName {
    /**
     * import from attributes
     */
    static fromDomainNameAttributes(scope: Construct, id: string, attrs: DomainNameAttributes): IDomainName;
    /**
     * The custom domain name for your API in Amazon API Gateway.
     *
     * @attribute
     */
    readonly domainName: string;
    /**
     * The domain name associated with the regional endpoint for this custom domain name.
     */
    readonly regionalDomainName: string;
    /**
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     */
    readonly regionalHostedZoneId: string;
    constructor(scope: Construct, id: string, props: DomainNameProps);
}
