"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiMapping = void 0;
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
/**
 * Create a new API mapping for API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class HttpApiMapping extends core_1.Resource {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id);
        if ((!((_a = props.stage) === null || _a === void 0 ? void 0 : _a.stageName)) && !props.api.defaultStage) {
            throw new Error('stage is required if default stage is not available');
        }
        const paramRe = '^[a-zA-Z0-9]*[-_.+!,$]?[a-zA-Z0-9]*$';
        if (props.apiMappingKey && !new RegExp(paramRe).test(props.apiMappingKey)) {
            throw new Error('An ApiMapping key may contain only letters, numbers and one of $-_.+!*\'(),');
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.httpApiId,
            domainName: props.domainName.domainName,
            stage: (_c = (_b = props.stage) === null || _b === void 0 ? void 0 : _b.stageName) !== null && _c !== void 0 ? _c : props.api.defaultStage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new apigatewayv2_generated_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        if (props.stage) {
            this.node.addDependency(props.stage);
        }
        // if stage not specified, we ensure the default stage is ready before we create the api mapping
        if (!((_d = props.stage) === null || _d === void 0 ? void 0 : _d.stageName) && props.api.defaultStage) {
            this.node.addDependency(props.api.defaultStage);
        }
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
    }
    /**
     * import from API ID
     */
    static fromHttpApiMappingAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpApiMapping = HttpApiMapping;
//# sourceMappingURL=data:application/json;base64,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