"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpProxyIntegration = void 0;
const integration_1 = require("../integration");
const route_1 = require("../route");
/**
 * The HTTP Proxy integration resource for HTTP API
 */
class HttpProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(_) {
        var _a;
        return {
            method: (_a = this.props.method) !== null && _a !== void 0 ? _a : route_1.HttpMethod.ANY,
            payloadFormatVersion: integration_1.PayloadFormatVersion.VERSION_1_0,
            type: integration_1.HttpIntegrationType.HTTP_PROXY,
            uri: this.props.url,
        };
    }
}
exports.HttpProxyIntegration = HttpProxyIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImh0dHAudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsZ0RBQStKO0FBQy9KLG9DQUFzQztBQWtCdEM7O0dBRUc7QUFDSCxNQUFhLG9CQUFvQjtJQUMvQixZQUE2QixLQUFnQztRQUFoQyxVQUFLLEdBQUwsS0FBSyxDQUEyQjtJQUM3RCxDQUFDO0lBRU0sSUFBSSxDQUFDLENBQWtDOztRQUM1QyxPQUFPO1lBQ0wsTUFBTSxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxtQ0FBSSxrQkFBVSxDQUFDLEdBQUc7WUFDM0Msb0JBQW9CLEVBQUUsa0NBQW9CLENBQUMsV0FBVztZQUN0RCxJQUFJLEVBQUUsaUNBQW1CLENBQUMsVUFBVTtZQUNwQyxHQUFHLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHO1NBQ3BCLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFaRCxvREFZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEh0dHBJbnRlZ3JhdGlvblR5cGUsIEh0dHBSb3V0ZUludGVncmF0aW9uQmluZE9wdGlvbnMsIEh0dHBSb3V0ZUludGVncmF0aW9uQ29uZmlnLCBJSHR0cFJvdXRlSW50ZWdyYXRpb24sIFBheWxvYWRGb3JtYXRWZXJzaW9uIH0gZnJvbSAnLi4vaW50ZWdyYXRpb24nO1xuaW1wb3J0IHsgSHR0cE1ldGhvZCB9IGZyb20gJy4uL3JvdXRlJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIHRvIGluaXRpYWxpemUgYSBuZXcgYEh0dHBQcm94eUludGVncmF0aW9uYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwUHJveHlJbnRlZ3JhdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBmdWxsLXF1YWxpZmllZCBIVFRQIFVSTCBmb3IgdGhlIEhUVFAgaW50ZWdyYXRpb25cbiAgICovXG4gIHJlYWRvbmx5IHVybDogc3RyaW5nXG5cbiAgLyoqXG4gICAqIFRoZSBIVFRQIG1ldGhvZCB0aGF0IG11c3QgYmUgdXNlZCB0byBpbnZva2UgdGhlIHVuZGVybHlpbmcgSFRUUCBwcm94eS5cbiAgICogQGRlZmF1bHQgSHR0cE1ldGhvZC5BTllcbiAgICovXG4gIHJlYWRvbmx5IG1ldGhvZD86IEh0dHBNZXRob2Q7XG59XG5cbi8qKlxuICogVGhlIEhUVFAgUHJveHkgaW50ZWdyYXRpb24gcmVzb3VyY2UgZm9yIEhUVFAgQVBJXG4gKi9cbmV4cG9ydCBjbGFzcyBIdHRwUHJveHlJbnRlZ3JhdGlvbiBpbXBsZW1lbnRzIElIdHRwUm91dGVJbnRlZ3JhdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IEh0dHBQcm94eUludGVncmF0aW9uUHJvcHMpIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF86IEh0dHBSb3V0ZUludGVncmF0aW9uQmluZE9wdGlvbnMpOiBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG1ldGhvZDogdGhpcy5wcm9wcy5tZXRob2QgPz8gSHR0cE1ldGhvZC5BTlksXG4gICAgICBwYXlsb2FkRm9ybWF0VmVyc2lvbjogUGF5bG9hZEZvcm1hdFZlcnNpb24uVkVSU0lPTl8xXzAsIC8vIDEuMCBpcyByZXF1aXJlZCBhbmQgaXMgdGhlIG9ubHkgc3VwcG9ydGVkIGZvcm1hdFxuICAgICAgdHlwZTogSHR0cEludGVncmF0aW9uVHlwZS5IVFRQX1BST1hZLFxuICAgICAgdXJpOiB0aGlzLnByb3BzLnVybCxcbiAgICB9O1xuICB9XG59Il19