"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaProxyIntegration = void 0;
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const integration_1 = require("../integration");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class LambdaProxyIntegration {
    constructor(props) {
        this.props = props;
    }
    bind(options) {
        var _a, _b;
        const route = options.route;
        this.props.handler.addPermission(`${route.node.uniqueId}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.httpApiId,
                resourceName: `*/*${(_a = route.path) !== null && _a !== void 0 ? _a : ''}`,
            }),
        });
        return {
            type: integration_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_b = this.props.payloadFormatVersion) !== null && _b !== void 0 ? _b : integration_1.PayloadFormatVersion.VERSION_2_0,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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