"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const acm = require("@aws-cdk/aws-certificatemanager");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'integ-http-proxy');
const handler = new lambda.Function(stack, 'echohandler', {
    runtime: lambda.Runtime.NODEJS_12_X,
    handler: 'index.handler',
    code: new lambda.InlineCode('exports.handler = async function(event, context) { return { statusCode: 200, headers: { "content-type": "application/json"  }, body: JSON.stringify(event) }; };'),
});
const certArn = 'arn:aws:acm:us-east-1:111111111111:certificate';
const domainName = 'apigv2.demo.com';
const dn = new lib_1.DomainName(stack, 'DN', {
    domainName,
    certificate: acm.Certificate.fromCertificateArn(stack, 'cert', certArn),
});
const prodApi = new lib_1.HttpApi(stack, 'HttpProxyProdApi', {
    defaultIntegration: new lib_1.LambdaProxyIntegration({ handler }),
    // https://${dn.domainName}/foo goes to prodApi $default stage
    defaultDomainMapping: {
        domainName: dn,
        mappingKey: 'foo',
    },
});
// beta stage
prodApi.addStage('BetaStage', {
    stageName: 'beta',
    autoDeploy: true,
    // https://${dn.domainName}/bar goes to the beta stage
    domainMapping: {
        domainName: dn,
        mappingKey: 'bar',
    },
});
// the Demo API
new lib_1.HttpApi(stack, 'DemoApi', {
    defaultIntegration: new lib_1.LambdaProxyIntegration({ handler }),
    // https://${dn.domainName}/demo goes to apiDemo $default stage
    defaultDomainMapping: {
        domainName: dn,
        mappingKey: 'demo',
    },
});
new core_1.CfnOutput(stack, 'RegionalDomainName', { value: dn.regionalDomainName });
new core_1.CfnOutput(stack, 'DomainName', { value: dn.domainName });
new core_1.CfnOutput(stack, 'CustomUDomainURL', { value: `https://${dn.domainName}` });
new core_1.CfnOutput(stack, 'ProdApiDefaultStageURL', { value: `https://${dn.domainName}/foo` });
new core_1.CfnOutput(stack, 'ProdApiBetaStageURL', { value: `https://${dn.domainName}/bar` });
new core_1.CfnOutput(stack, 'DemoApiDefaultStageURL', { value: `https://${dn.domainName}/demo` });
//# sourceMappingURL=data:application/json;base64,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