"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../../lib");
describe('HttpProxyIntegration', () => {
    test('default', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpRoute(stack, 'HttpProxyRoute', {
            httpApi: api,
            integration: new lib_1.HttpProxyIntegration({
                url: 'some-target-url',
            }),
            routeKey: lib_1.HttpRouteKey.with('/pets'),
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            IntegrationType: 'HTTP_PROXY',
            IntegrationUri: 'some-target-url',
            PayloadFormatVersion: '1.0',
            IntegrationMethod: 'ANY',
        });
    });
    test('method option is correctly recognized', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpRoute(stack, 'HttpProxyRoute', {
            httpApi: api,
            integration: new lib_1.HttpProxyIntegration({
                url: 'some-target-url',
                method: lib_1.HttpMethod.PATCH,
            }),
            routeKey: lib_1.HttpRouteKey.with('/pets'),
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            IntegrationMethod: 'PATCH',
        });
    });
    test('custom payload format version is allowed', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpIntegration(stack, 'HttpInteg', {
            payloadFormatVersion: lib_1.PayloadFormatVersion.custom('99.99'),
            httpApi: api,
            integrationType: lib_1.HttpIntegrationType.HTTP_PROXY,
            integrationUri: 'some-target-url',
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            IntegrationType: 'HTTP_PROXY',
            IntegrationUri: 'some-target-url',
            PayloadFormatVersion: '99.99',
        });
    });
    test('HttpIntegration without payloadFormatVersion is allowed', () => {
        const stack = new core_1.Stack();
        const api = new lib_1.HttpApi(stack, 'HttpApi');
        new lib_1.HttpIntegration(stack, 'HttpInteg', {
            httpApi: api,
            integrationType: lib_1.HttpIntegrationType.HTTP_PROXY,
            integrationUri: 'some-target-url',
        });
        expect(stack).toHaveResource('AWS::ApiGatewayV2::Integration', {
            IntegrationType: 'HTTP_PROXY',
            IntegrationUri: 'some-target-url',
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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