# coding: utf-8

"""
    Selling Partner API for Notifications

    The Selling Partner API for Notifications lets you subscribe to notifications that are relevant to a selling partner's business. Using this API you can create a destination to receive notifications, subscribe to notifications, delete notification subscriptions, and more.  # noqa: E501

    OpenAPI spec version: v1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class Subscription(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'subscription_id': 'str',
        'payload_version': 'str',
        'destination_id': 'str'
    }

    attribute_map = {
        'subscription_id': 'subscriptionId',
        'payload_version': 'payloadVersion',
        'destination_id': 'destinationId'
    }

    def __init__(self, subscription_id=None, payload_version=None, destination_id=None):  # noqa: E501
        """Subscription - a model defined in Swagger"""  # noqa: E501
        self._subscription_id = None
        self._payload_version = None
        self._destination_id = None
        self.discriminator = None
        self.subscription_id = subscription_id
        self.payload_version = payload_version
        self.destination_id = destination_id

    @property
    def subscription_id(self):
        """Gets the subscription_id of this Subscription.  # noqa: E501

        The subscription identifier generated when the subscription is created.  # noqa: E501

        :return: The subscription_id of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """Sets the subscription_id of this Subscription.

        The subscription identifier generated when the subscription is created.  # noqa: E501

        :param subscription_id: The subscription_id of this Subscription.  # noqa: E501
        :type: str
        """
        if subscription_id is None:
            raise ValueError("Invalid value for `subscription_id`, must not be `None`")  # noqa: E501

        self._subscription_id = subscription_id

    @property
    def payload_version(self):
        """Gets the payload_version of this Subscription.  # noqa: E501

        The version of the payload object to be used in the notification.  # noqa: E501

        :return: The payload_version of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._payload_version

    @payload_version.setter
    def payload_version(self, payload_version):
        """Sets the payload_version of this Subscription.

        The version of the payload object to be used in the notification.  # noqa: E501

        :param payload_version: The payload_version of this Subscription.  # noqa: E501
        :type: str
        """
        if payload_version is None:
            raise ValueError("Invalid value for `payload_version`, must not be `None`")  # noqa: E501

        self._payload_version = payload_version

    @property
    def destination_id(self):
        """Gets the destination_id of this Subscription.  # noqa: E501

        The identifier for the destination where notifications will be delivered.  # noqa: E501

        :return: The destination_id of this Subscription.  # noqa: E501
        :rtype: str
        """
        return self._destination_id

    @destination_id.setter
    def destination_id(self, destination_id):
        """Sets the destination_id of this Subscription.

        The identifier for the destination where notifications will be delivered.  # noqa: E501

        :param destination_id: The destination_id of this Subscription.  # noqa: E501
        :type: str
        """
        if destination_id is None:
            raise ValueError("Invalid value for `destination_id`, must not be `None`")  # noqa: E501

        self._destination_id = destination_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Subscription, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Subscription):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
