import { ComputeType } from '@aws-cdk/aws-codebuild';
import { ActionBindOptions, ActionConfig, Artifact, CommonAwsActionProps, IStage } from '@aws-cdk/aws-codepipeline';
import { Action } from '@aws-cdk/aws-codepipeline-actions';
import { Construct } from '@aws-cdk/core';
export interface CodePipelineAnchoreInlineScanActionProps extends CommonAwsActionProps {
    /**
     * The source to use as input for this action.
     */
    readonly input: Artifact;
    /**
     * Version of anchore ci-tools.
     *
     * @default v0.7.2
     */
    readonly version?: string;
    /**
     * Path to local Anchore policy bundle.
     *
     * @default ./policy_bundle.json
     */
    readonly policyBundlePath?: string;
    /**
     * Specify timeout for image scanning in seconds.
     *
     * @default 300
     */
    readonly timeout?: number;
    /**
     * The type of compute to use for backup the repositories.
     *
     * See the {@link ComputeType} enum for the possible values.
     *
     * @default taken from {@link LinuxBuildImage.STANDARD_4_0#defaultComputeType}
     */
    readonly computeType?: ComputeType;
}
export declare class CodePipelineAnchoreInlineScanAction extends Action {
    private readonly props;
    constructor(props: CodePipelineAnchoreInlineScanActionProps);
    /**
     * The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    protected bound(scope: Construct, _stage: IStage, options: ActionBindOptions): ActionConfig;
}
