"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineNotificationEvents = exports.Action = exports.GlobalVariables = exports.ActionCategory = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
var ActionCategory;
(function (ActionCategory) {
    ActionCategory["SOURCE"] = "Source";
    ActionCategory["BUILD"] = "Build";
    ActionCategory["TEST"] = "Test";
    ActionCategory["APPROVAL"] = "Approval";
    ActionCategory["DEPLOY"] = "Deploy";
    ActionCategory["INVOKE"] = "Invoke";
})(ActionCategory = exports.ActionCategory || (exports.ActionCategory = {}));
/**
 * The CodePipeline variables that are global,
 * not bound to a specific action.
 * This class defines a bunch of static fields that represent the different variables.
 * These can be used can be used in any action configuration.
 */
class GlobalVariables {
}
exports.GlobalVariables = GlobalVariables;
_a = JSII_RTTI_SYMBOL_1;
GlobalVariables[_a] = { fqn: "@aws-cdk/aws-codepipeline.GlobalVariables", version: "1.164.0" };
/** The identifier of the current pipeline execution. */
GlobalVariables.executionId = '#{codepipeline.PipelineExecutionId}';
/**
 * Low-level class for generic CodePipeline Actions implementing the {@link IAction} interface.
 * Contains some common logic that can be re-used by all {@link IAction} implementations.
 * If you're writing your own Action class,
 * feel free to extend this class.
 */
class Action {
    constructor() {
        this._variableReferenced = false;
        this._namespaceToken = core_1.Lazy.string({
            produce: () => {
                // make sure the action was bound (= added to a pipeline)
                if (this._actualNamespace === undefined) {
                    throw new Error(`Cannot reference variables of action '${this.actionProperties.actionName}', ` +
                        'as that action was never added to a pipeline');
                }
                else {
                    return this._customerProvidedNamespace !== undefined
                        // if a customer passed a namespace explicitly, always use that
                        ? this._customerProvidedNamespace
                        // otherwise, only return a namespace if any variable was referenced
                        : (this._variableReferenced ? this._actualNamespace : undefined);
                }
            },
        });
    }
    get actionProperties() {
        if (this.__actionProperties === undefined) {
            const actionProperties = this.providedActionProperties;
            this._customerProvidedNamespace = actionProperties.variablesNamespace;
            this.__actionProperties = {
                ...actionProperties,
                variablesNamespace: this._customerProvidedNamespace === undefined
                    ? this._namespaceToken
                    : this._customerProvidedNamespace,
            };
        }
        return this.__actionProperties;
    }
    bind(scope, stage, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.__pipeline = stage.pipeline;
        this.__stage = stage;
        this.__scope = scope;
        this._actualNamespace = this._customerProvidedNamespace === undefined
            // default a namespace name, based on the stage and action names
            ? `${stage.stageName}_${this.actionProperties.actionName}_NS`
            : this._customerProvidedNamespace;
        return this.bound(scope, stage, options);
    }
    onStateChange(name, target, options) {
        const rule = new events.Rule(this._scope, name, options);
        rule.addTarget(target);
        rule.addEventPattern({
            detailType: ['CodePipeline Action Execution State Change'],
            source: ['aws.codepipeline'],
            resources: [this._pipeline.pipelineArn],
            detail: {
                stage: [this._stage.stageName],
                action: [this.actionProperties.actionName],
            },
        });
        return rule;
    }
    variableExpression(variableName) {
        this._variableReferenced = true;
        return `#{${this._namespaceToken}.${variableName}}`;
    }
    get _pipeline() {
        if (this.__pipeline) {
            return this.__pipeline;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    get _stage() {
        if (this.__stage) {
            return this.__stage;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline before using onStateChange');
        }
    }
    /**
     * Retrieves the Construct scope of this Action.
     * Only available after the Action has been added to a Stage,
     * and that Stage to a Pipeline.
     */
    get _scope() {
        if (this.__scope) {
            return this.__scope;
        }
        else {
            throw new Error('Action must be added to a stage that is part of a pipeline first');
        }
    }
}
exports.Action = Action;
_b = JSII_RTTI_SYMBOL_1;
Action[_b] = { fqn: "@aws-cdk/aws-codepipeline.Action", version: "1.164.0" };
/**
 * The list of event types for AWS Codepipeline Pipeline
 * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline
 */
var PipelineNotificationEvents;
(function (PipelineNotificationEvents) {
    /**
     * Trigger notification when pipeline execution failed
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_FAILED"] = "codepipeline-pipeline-pipeline-execution-failed";
    /**
     * Trigger notification when pipeline execution canceled
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_CANCELED"] = "codepipeline-pipeline-pipeline-execution-canceled";
    /**
     * Trigger notification when pipeline execution started
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_STARTED"] = "codepipeline-pipeline-pipeline-execution-started";
    /**
     * Trigger notification when pipeline execution resumed
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_RESUMED"] = "codepipeline-pipeline-pipeline-execution-resumed";
    /**
     * Trigger notification when pipeline execution succeeded
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-pipeline-execution-succeeded";
    /**
     * Trigger notification when pipeline execution superseded
     */
    PipelineNotificationEvents["PIPELINE_EXECUTION_SUPERSEDED"] = "codepipeline-pipeline-pipeline-execution-superseded";
    /**
     * Trigger notification when pipeline stage execution started
     */
    PipelineNotificationEvents["STAGE_EXECUTION_STARTED"] = "codepipeline-pipeline-stage-execution-started";
    /**
    * Trigger notification when pipeline stage execution succeeded
    */
    PipelineNotificationEvents["STAGE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-stage-execution-succeeded";
    /**
    * Trigger notification when pipeline stage execution resumed
    */
    PipelineNotificationEvents["STAGE_EXECUTION_RESUMED"] = "codepipeline-pipeline-stage-execution-resumed";
    /**
    * Trigger notification when pipeline stage execution canceled
    */
    PipelineNotificationEvents["STAGE_EXECUTION_CANCELED"] = "codepipeline-pipeline-stage-execution-canceled";
    /**
    * Trigger notification when pipeline stage execution failed
    */
    PipelineNotificationEvents["STAGE_EXECUTION_FAILED"] = "codepipeline-pipeline-stage-execution-failed";
    /**
     * Trigger notification when pipeline action execution succeeded
     */
    PipelineNotificationEvents["ACTION_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-action-execution-succeeded";
    /**
     * Trigger notification when pipeline action execution failed
     */
    PipelineNotificationEvents["ACTION_EXECUTION_FAILED"] = "codepipeline-pipeline-action-execution-failed";
    /**
     * Trigger notification when pipeline action execution canceled
     */
    PipelineNotificationEvents["ACTION_EXECUTION_CANCELED"] = "codepipeline-pipeline-action-execution-canceled";
    /**
     * Trigger notification when pipeline action execution started
     */
    PipelineNotificationEvents["ACTION_EXECUTION_STARTED"] = "codepipeline-pipeline-action-execution-started";
    /**
     * Trigger notification when pipeline manual approval failed
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_FAILED"] = "codepipeline-pipeline-manual-approval-failed";
    /**
     * Trigger notification when pipeline manual approval needed
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_NEEDED"] = "codepipeline-pipeline-manual-approval-needed";
    /**
     * Trigger notification when pipeline manual approval succeeded
     */
    PipelineNotificationEvents["MANUAL_APPROVAL_SUCCEEDED"] = "codepipeline-pipeline-manual-approval-succeeded";
})(PipelineNotificationEvents = exports.PipelineNotificationEvents || (exports.PipelineNotificationEvents = {}));
//# sourceMappingURL=data:application/json;base64,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