"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKProject = void 0;
const projen_1 = require("projen");
const cdk_1 = require("projen/lib/cdk");
class PDKProject extends cdk_1.JsiiProject {
    constructor(options) {
        const nameWithUnderscore = options.name.replace("-", "_");
        const condensedName = options.name.replace("-", "");
        super({
            ...options,
            github: false,
            sampleCode: false,
            docgen: false,
            prettier: true,
            projenDevDependency: false,
            srcdir: "src",
            testdir: "test",
            readme: {
                contents: "TODO",
            },
            packageName: `@aws/pdk-${options.name}`,
            outdir: `packages/@aws/pdk-${options.name}`,
            publishToPypi: {
                distName: `aws_prototyping_sdk.${nameWithUnderscore}`,
                module: `aws_prototyping_sdk.${nameWithUnderscore}`,
            },
            publishToMaven: {
                mavenEndpoint: "https://aws.oss.sonatype.org",
                mavenGroupId: "software.aws.awsprototypingsdk",
                mavenArtifactId: `aws-pdk-${options.name}`,
                javaPackage: `software.aws.awsprototypingsdk.${condensedName}`,
            },
        });
        if (this.deps.all.find((dep) => "aws-prototyping-sdk" === dep.name)) {
            throw new Error("PDK Projects cannot have a dependency on the aws-prototyping-sdk!");
        }
        if (!this.name.match(/^[a-z-]+(?<!-)$/)) {
            throw new Error("name should be lowercase and include optional hyphens");
        }
        if (!this.parent) {
            throw new Error("parent must be provided!");
        }
        new projen_1.SampleDir(this, this.srcdir, {
            files: {
                "index.ts": 'export * as construct from "./construct";\nexport * as project from "./project";',
                "construct/index.ts": 'export default "IMPLEMENT ME";',
                "project/index.ts": 'export default "IMPLEMENT ME";',
            },
        });
        new projen_1.SampleDir(this, this.testdir, {
            files: {
                "construct/.gitkeep": "",
                "project/.gitkeep": "",
            },
        });
    }
}
exports.PDKProject = PDKProject;
//# sourceMappingURL=data:application/json;base64,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