"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineStack = void 0;
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const pipeline_1 = require("aws-prototyping-sdk/pipeline"); // eslint-disable-line
class PipelineStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.pipeline = new pipeline_1.PDKPipeline(this, 'ApplicationPipeline', {
            primarySynthDirectory: 'packages/infra/cdk.out',
            repositoryName: this.node.tryGetContext('repositoryName') || 'monorepo',
            publishAssetsInParallel: false,
            crossAccountKeys: true,
            synth: {},
            sonarCodeScannerConfig: this.node.tryGetContext('sonarqubeScannerConfig'),
        });
    }
}
exports.PipelineStack = PipelineStack;
//# sourceMappingURL=data:application/json;base64,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