# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_version_viewer',
 'django_version_viewer.templatetags',
 'django_version_viewer.tests']

package_data = \
{'': ['*'], 'django_version_viewer': ['templates/*']}

setup_kwargs = {
    'name': 'django-version-viewer',
    'version': '2.1.6',
    'description': 'Django app for viewing python packages and their versions',
    'long_description': '# Django Version Viewer\n\nVersion Viewer provides Django Admins (with appropriate permission)\nthe ability to view the Python packages and versions used within the project.\n\nThis tool can be used in several ways. It provides:\n\n - a template tag which inserts a link onto a template.\n   Clicking that link opens up a pop up modal displaying installed\n   Python packages.\n - a DjangoCMS toolbar entry. When clicked, a popup will display installed\n   Python packages.\n - a CSV export of installed Python packages.\n - a queryable endpoint that displays installed Python packages.\n\nYou may also configure which users have access to the link and endpoint.\n\n---------------------------------------\n## Installation\n---------------------------------------\n\nTo install the Django Version Viewer, simply:\n\n    pip install django-version-viewer\n\nAdd the following to `INSTALLED_APPS` in `settings.py`\n\n    INSTALLED_APPS = [\n        \'django_version_viewer\'\n    ]\n\n## Add django_version_viewer urls and extend `admin/index.html`\n\n\nDjango Version Viewer needs to extend the `admin/index.html` and append it\'s urls to your `urls.py`. In your `urls.py` add:\n\n    admin.site.index_template = \'admin/custom_index.html\'\n    admin.autodiscover()\n\n    urlpatterns = [\n        ...\n        url(r\'^django_version_viewer/\', include(\'django_version_viewer.urls\')),\n        ...\n    ]\n\n    # Note that you can now make a GET request to the route `r\'^django_version_viewer/\'` to see\n    # a list of your app\'s installed pip dependencies returned in JSON.\n\nIn your `templates/admin/` dir, create a `custom_index.html`.\n\n    <!-- custom_index.html -->\n    {% extends "admin/index.html" %}\n\n    {% load i18n pip_version_viewer_tags %}\n\n    {% block content %}\n    {% show_pip_package_versions %}\n    {{ block.super }}\n    {% endblock %}\n\n![Admin Integration](/images/version-viewer-admin-integration.jpg "Admin Integration")\n\n\n## Django CMS integration\n\nIf Django CMS is installed, a new menu item will be added to the CMS Toolbar\nPage Menu that will allow opening the version viewer popup.\n\n\n![CMS Integration](/images/version-viewer-cms-integration.jpg "CMS Integration")\n\n## Permissions\n\nYou can set your own access permissions on the template tag and route by\ndefining your own `Accessor` class. This class must have a `allow_access`\nmethod that returns a `boolean`. By defualt, django_version_viewer only\nallows superusers access to the route and template tag.\n\n    # Django Version Viewer settings:\n    ACCESSOR_CLASS_PATH = \'mypathto.my.AccessorClass\'\n\n    # the default class only allows superusers access\n    django_version_viewer.mixins.SuperuserAccessor\n\n\n## Running Tests\n\n    # in a virtualenv\n    pip install -e .[testing]\n    pip install django==2.2.27\n    flake8 .\n    ENABLE_DJANGOCMS=False coverage run ./example22/manage.py test django_version_viewer\n\n\n## Using the Example Project\n\nAn example project is provided to demonstrate the project.\n\n    # in a virtualenv\n    cd example22/\n    pip install -r requirements.txt\n    ./manage.py migrate\n    ./manage.py createsuperuser\n    ./manage.py runserver\n\n    # Run without DjangoCMS\n    ENABLE_DJANGOCMS=False ./manage.py runserver\n',
    'author': 'Imagescape',
    'author_email': 'info@imagescape.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ImaginaryLandscape/django-version-viewer',
    'packages': packages,
    'package_data': package_data,
}


setup(**setup_kwargs)
