"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.views = self.__class__.views(path + ["views"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        super().__init__(path, service)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)
    def parallel_setting(self, *args, **kwargs):
        """
        Enter the parallel processing menu.
        """
        return PyMenu(self.service, "/parallel_setting").execute(*args, **kwargs)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)

    class solution(TUIMenu):
        """
        Enter solution menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.run_calculation = self.__class__.run_calculation(path + ["run_calculation"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.methods = self.__class__.methods(path + ["methods"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.calculation_activities = self.__class__.calculation_activities(path + ["calculation_activities"], service)
            self.controls = self.__class__.controls(path + ["controls"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            super().__init__(path, service)

        class run_calculation(TUIMenu):
            """
            Enter run calculation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                super().__init__(path, service)
            def reporting_interval(self, *args, **kwargs):
                """
                Set number of solver iterations before returning to scheme.
                """
                return PyMenu(self.service, "/solution/run_calculation/reporting_interval").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solution/run_calculation/time_step").execute(*args, **kwargs)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/adaptive_time_stepping").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Set Solution Steering Parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/set_solution_steering").execute(*args, **kwargs)
            def mesh_motion(self, *args, **kwargs):
                """
                Perform mesh motion.
                """
                return PyMenu(self.service, "/solution/run_calculation/mesh_motion").execute(*args, **kwargs)
            def dual_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/dual_time_iterate").execute(*args, **kwargs)
            def multistage_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/multistage_time_iterate").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/variable_time_stepping").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Set the residual report verbosity.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_verbosity").execute(*args, **kwargs)
            def summary(self, *args, **kwargs):
                """
                Print report summary.
                """
                return PyMenu(self.service, "/solution/run_calculation/summary").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Set iteration options.
                """
                return PyMenu(self.service, "/solution/run_calculation/data_sampling").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enable solution steering for density-based solver.
                """
                return PyMenu(self.service, "/solution/run_calculation/solution_steering").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enter the residual tolerance menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_tolerance").execute(*args, **kwargs)
            def iterate(self, *args, **kwargs):
                """
                Perform a specified number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/iterate").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Set number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/number_of_iterations").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Set options for second-order time formulation.
                """
                return PyMenu(self.service, "/solution/run_calculation/second_order_time_options").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enter the max-corrections menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/max_corrections").execute(*args, **kwargs)
            def update_physical_time(self, *args, **kwargs):
                """
                Update the solution to the next physical time level.
                """
                return PyMenu(self.service, "/solution/run_calculation/update_physical_time").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enter into the transient controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Use specified time step or courant number.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/specified_time_step").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    Undo the previous time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/undo_timestep").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Set number of time step size for acoustic export.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Set Multiphase-specific adaptive time stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Set maximum flow time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_flow_time").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Activate the simulation status panel.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solution_status").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Set Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/incremental_time").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Set the physical time step size.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Improve prediction of flow field at time step n+1 for rotating mesh.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Set period- or frequency-based fixed time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enter the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Set Error-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Set Total Simulation Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_time").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Set Duration Specification Method: [0] Incremental Time Steps, [1] Total Time Steps, [2] Total Time, [3] Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Enable user-specified fixed time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Set the time-stepping parameters for user-defined time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/predict_next_time").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Set inceremtal number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Specify a different time step size for solid zones.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Set total number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Set Max Iterations/Time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Set Multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Include physics driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set verbosity to print multiphase specific time scales.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Set physics based time scale options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Include gravity based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Include acoustic time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Include viscous time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Include surface tension based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Data sampling options for statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_datasets").execute(*args, **kwargs)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    List dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/list_datasets").execute(*args, **kwargs)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Manage report definitions.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/list").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all report definition objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete_all").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/report_definitions/add").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solution/report_definitions/compute").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/edit").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/rename").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Makes a copy of selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/copy").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Enter the monitors menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                super().__init__(path, service)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solution/monitors/set_average_over").execute(*args, **kwargs)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solution/monitors/convergence_conditions").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/add").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/edit").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/plot").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/axes").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/curves").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/clear_data").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enter the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def criterion_type(self, *args, **kwargs):
                    """
                    Set convergence criterion type.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/criterion_type").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Enable/disable scaling of residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Scale the continuity residuals locally based on the enhanced formulation.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Renormalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/re_normalize").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/plot").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/print").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Set number of residuals to be saved with data.
                    History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_save").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Delete the residual history and reset iteration counter to unity.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/reset").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Choose whether or not to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalize").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Choose which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/monitor").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Set the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_display").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Set convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Choose which currently-monitored residuals
                    should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/check_convergence").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Set normalization factors for currently-monitored residuals.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Set relative convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Set the number of iterations through which normalization
                    factors will be maximized.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_maximize_norms").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete_all").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list_properties").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/add").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/clear_data").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list").execute(*args, **kwargs)

        class methods(TUIMenu):
            """
            Enter the methods menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                super().__init__(path, service)
            def p_v_coupling(self, *args, **kwargs):
                """
                Select the pressure velocity coupling scheme.
                """
                return PyMenu(self.service, "/solution/methods/p_v_coupling").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Set residual smoothing factor and number of iterations.
                """
                return PyMenu(self.service, "/solution/methods/residual_smoothing").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_1st_order").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enter the discretization-scheme menu.
                """
                return PyMenu(self.service, "/solution/methods/discretization_scheme").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Set solution methods to default values.
                """
                return PyMenu(self.service, "/solution/methods/set_solution_methods_to_default").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Set ggnb options.
                """
                return PyMenu(self.service, "/solution/methods/nb_gradient_boundary_option").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/solution/methods/frozen_flux").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Set phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solution/methods/phase_based_vof_discretization").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_global_time").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/solution/methods/noniterative_time_advance").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enable/disable accelerated non-iterative time marching.
                """
                return PyMenu(self.service, "/solution/methods/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Set VOF numeric options.
                """
                return PyMenu(self.service, "/solution/methods/vof_numerics").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Set gradient options.
                """
                return PyMenu(self.service, "/solution/methods/gradient_scheme").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solution/methods/flux_type").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enable convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solution/methods/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter methods query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def p_v_coupling(self, *args, **kwargs):
                    """
                    Get the pressure velocity coupling scheme.
                    """
                    return PyMenu(self.service, "/solution/methods/query/p_v_coupling").execute(*args, **kwargs)
                def discretization_scheme(self, *args, **kwargs):
                    """
                    Enter the discretization-scheme menu.
                    """
                    return PyMenu(self.service, "/solution/methods/query/discretization_scheme").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def reactions(self, *args, **kwargs):
                    """
                    Enable/disable the species reaction sources and set relaxation factor.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/reactions").execute(*args, **kwargs)
                def numerics(self, *args, **kwargs):
                    """
                    Set numeric options.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/numerics").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Enter the multiphase numerics options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    super().__init__(path, service)

                class solution_stabilization(TUIMenu):
                    """
                    VOF solution stabilization menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        super().__init__(path, service)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        Execute advanced stabilization for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        Execute additional stability controls for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Velocity limiting related stabiity controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def verbosity(self, *args, **kwargs):
                            """
                            Enable verbosity to print number of velocity limited cells during iterations.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Enter max velocity magnitude.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enable velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Additional advanced stability controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Blended Compressive discretization scheme for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)

                class boiling_parameters(TUIMenu):
                    """
                    Multiphase boiling parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def thin_film(self, *args, **kwargs):
                        """
                        Multiphase boiling thin film effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        Multiphase boiling liquid volume fraction effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Multiphase miscellaneous porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Multiphase relative permeability fix option.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Multiphase compressible numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Multiphase compressible flow BC alternate method.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Multiphase enhanced compressible flow numerics options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Stability controls for multiphase flow.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        super().__init__(path, service)

                    class hybrid_nita(TUIMenu):
                        """
                        Hybrid NITA stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Set number of outer iterations in hybrid nita.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Set hybrid nita start-up controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Set Hybrid NITA instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Set Courant Number limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Set number of outer iterations for unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Set Courant Number type for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enable instability detector for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Set velocity limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Equation Order Menu for Homogeneous Multiphase Flow Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            Solve flow equation at the end of iteration as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Anti Diffusion Menu for VOF/Multi-Fluid VOF Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Set maximum value of dynamic anti-diffusion strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Set cosine exponent in dynamic strength treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enable dynamic strength to reduce compression in the tangential direction to the interface.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Pressure velocity coupling controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            super().__init__(path, service)

                        class skewness_correction(TUIMenu):
                            """
                            Skewness correction related stabiity controls for multiphase flow.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Use limited pressure correction gradient in skewness corrections for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Set Rhie-Chow related stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Use low order velocity interpolation in flux calculation.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class coupled_vof(TUIMenu):
                            """
                            Set Coupled VOF stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Set buoynacy force linerization options in coupled vof.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Multiphase interphase heat and mass transfer numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Alternative treatment of latent heat source due to mass transfer.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Interfacial area density menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Interfacial area density gradient-symmetric mechanism.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Minimum vof seeding for non-zero area density in heat and mass transfer.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Cavitation numerics options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enable/disable turbulent diffusion treatment between phases participating in cavitation.
                            This treatment is generally recommended for better solution stability.
                            However, in case of numerical difficulties, it can be disabled.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Condensation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Evaporation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Minimum vapor pressure limit for cavitation model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Maximum limit on vapor pressure after turbulence and thermal correction.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Boiling advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Allow generalized two-resistance framework for boiling model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes expert options of min/max superheat along with wetting fraction controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Under-relaxation factor for boiling heat flux.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Multiphase default controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Activate multiphase defaults for loaded case.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Multiphase viscous flow numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Multiphase options for viscosity averaging.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Enter overset solver options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Choose the interpolation method for overset interface(s).
                    """
                    return PyMenu(self.service, "/solution/methods/overset/interpolation_method").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enable solver to run with orphans present.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/orphan_cell_treatment").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    High order pressure extrapolation at overset interface.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/high_order_pressure").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enter the nita expert controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Set skewness neighbor coupling for nita.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Select a hybrid NITA settings option for faster performance and better robustness.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set nita verbosity option.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/set_verbosity").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable/Disable High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets relaxation factor.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/expert").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Select Variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enter the pseudo time method menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enter the relaxation factors menu to set the pseudo time explicit relaxation factors for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def formulation(self, *args, **kwargs):
                    """
                    Select the pseudo time step size formulation for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/formulation").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enter the advanced options menu to define pseudo time settings for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the local time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the global time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set the verbosity for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/verbosity").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enter warped-face-gradient-correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable Warped-Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/enable").execute(*args, **kwargs)

        class expert(TUIMenu):
            """
            Enter expert options for solution.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                super().__init__(path, service)
            def linearized_mass_transfer_udf(self, *args, **kwargs):
                """
                Use linearized mass transfer UDFs?.
                """
                return PyMenu(self.service, "/solution/expert/linearized_mass_transfer_udf").execute(*args, **kwargs)
            def retain_cell_residuals(self, *args, **kwargs):
                """
                Retain cell residuals for postprocessing?.
                """
                return PyMenu(self.service, "/solution/expert/retain_cell_residuals").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Lock the temperature for all solid and shell cell zones in the domain.
                """
                return PyMenu(self.service, "/solution/expert/lock_solid_temperature").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Setting pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solution/expert/bc_pressure_extrapolations").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solution/expert/material_property_warnings").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Control the display of warning diagnostics for boundaries with reversed flow, etc.
                """
                return PyMenu(self.service, "/solution/expert/flow_warnings").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Set Explicit VOF controls.
                """
                return PyMenu(self.service, "/solution/expert/vof_explicit_controls").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Enable/Disable reconstruction. When disabled, accuracy will be first-order.
                """
                return PyMenu(self.service, "/solution/expert/disable_reconstruction").execute(*args, **kwargs)
            def alternate_wall_temp_formulation(self, *args, **kwargs):
                """
                Alternate formulation for wall temperatures?.
                """
                return PyMenu(self.service, "/solution/expert/alternate_wall_temp_formulation").execute(*args, **kwargs)
            def energy_numerical_noise_filter(self, *args, **kwargs):
                """
                The energy equation numerical noise filter can be enabled to eliminate non-physical numerical noise in the energy field.
                The numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present.
                Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive.
                """
                return PyMenu(self.service, "/solution/expert/energy_numerical_noise_filter").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Set surface-tension calculation options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Control the display of limiter warning diagnostics.
                """
                return PyMenu(self.service, "/solution/expert/limiter_warnings").execute(*args, **kwargs)
            def retain_temporary_solver_mem(self, *args, **kwargs):
                """
                Retain temporary solver memory?.
                """
                return PyMenu(self.service, "/solution/expert/retain_temporary_solver_mem").execute(*args, **kwargs)
            def correction_form(self, *args, **kwargs):
                """
                Discretize momentum equations in correction form for the pressure-based solver.
                """
                return PyMenu(self.service, "/solution/expert/correction_form").execute(*args, **kwargs)
            def bcd_weights_freeze(self, *args, **kwargs):
                """
                At each timestep, freeze BCD scheme weights after specified iteration
                in order to improve timestep convergence.
                """
                return PyMenu(self.service, "/solution/expert/bcd_weights_freeze").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Set all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solution/expert/set_all_species_together").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                Set additional open channel controls.
                """
                return PyMenu(self.service, "/solution/expert/open_channel_controls").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Set the equation order.
                """
                return PyMenu(self.service, "/solution/expert/equation_ordering").execute(*args, **kwargs)
            def singhal_et_al_cavitation_model(self, *args, **kwargs):
                """
                Use Singhal-et-al cavitation model?.
                """
                return PyMenu(self.service, "/solution/expert/singhal_et_al_cavitation_model").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension_expert").execute(*args, **kwargs)
            def bcd_boundedness(self, *args, **kwargs):
                """
                BCD scheme boundedness strength, constant or expression (0 to 1).
                """
                return PyMenu(self.service, "/solution/expert/bcd_boundedness").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Set anisotropic drag parameters for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Set reference density option for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_reference_density").execute(*args, **kwargs)
            def explicit_under_relaxation_value(self, *args, **kwargs):
                """
                Explicit under-relaxation value.
                """
                return PyMenu(self.service, "/solution/expert/explicit_under_relaxation_value").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Set damping function in flow direction.
                """
                return PyMenu(self.service, "/solution/expert/numerical_beach_controls").execute(*args, **kwargs)
            def show_all_discretization_schemes(self, *args, **kwargs):
                """
                Allow selection of all applicable discretization schemes?.
                """
                return PyMenu(self.service, "/solution/expert/show_all_discretization_schemes").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Enable/disable pressure-discontinuity-sensor visualization.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Expert high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/expert").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/enable").execute(*args, **kwargs)

            class non_reflecting_boundary_treatment(TUIMenu):
                """
                Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enter Poor Mesh Numerics Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    self.user_defined_on_register_auto = self.__class__.user_defined_on_register_auto(path + ["user_defined_on_register_auto"], service)
                    super().__init__(path, service)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on cell gradient quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Set quality threshold.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Print poor cells count.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Reset marking of poor cell elements.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Relocate select cell centroids, to improve orthogonality metrics and solution stability.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Include cells in register in poor mesh numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on solution and cell quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics on cells with low quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Solution correction on meshes of poor quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enable").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)

                class user_defined_on_register_auto(TUIMenu):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def set(self, *args, **kwargs):
                        """
                        Edit a definition for automatic poor mesh numerics.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register_auto/set").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        List the properties of a definition for automatic poor mesh numerics.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register_auto/list_properties").execute(*args, **kwargs)

            class secondary_gradient_limiting(TUIMenu):
                """
                Enter the Secondary Gradient Limiting Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def uds(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for user-defined scalars.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/uds").execute(*args, **kwargs)
                def energy(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for energy equation.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                def mesh_quality_limits(self, *args, **kwargs):
                    """
                    Specify minimum and maximum mesh quality limits.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enter the divergence prevention menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable divergence prevention.
                    """
                    return PyMenu(self.service, "/solution/expert/divergence_prevention/enable").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Enter the open-channel-wave-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Set bufer layer height between phases for segregated velocity inputs.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Set stokes wave theory variants.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Enter previous defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R2.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R3.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2022R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Manage Cell Registers.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/list").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/list_properties").execute(*args, **kwargs)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/coarsen").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/display").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/edit").execute(*args, **kwargs)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/adapt").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/cell_registers/add").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Apply poor mesh numerics to cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/refine").execute(*args, **kwargs)

        class calculation_activities(TUIMenu):
            """
            Enter calculation activities menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
                self.auto_save = self.__class__.auto_save(path + ["auto_save"], service)
                self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
                self.animate = self.__class__.animate(path + ["animate"], service)
                self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
                super().__init__(path, service)

            class cell_register_operations(TUIMenu):
                """
                Manage Cell Register Operations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/delete").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list_properties").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/edit").execute(*args, **kwargs)

            class auto_save(TUIMenu):
                """
                Enter the auto save menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def data_frequency(self, *args, **kwargs):
                    """
                    Set the iteration or time step increment for saving data files.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/data_frequency").execute(*args, **kwargs)
                def save_data_file_every(self, *args, **kwargs):
                    """
                    Set the auto save frequency type to either time-step or crank-angle and set the corresponding frequency.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/save_data_file_every").execute(*args, **kwargs)
                def root_name(self, *args, **kwargs):
                    """
                    Set the root name for auto-saved files. The number of iterations or time steps will be appended to this root name.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/root_name").execute(*args, **kwargs)
                def retain_most_recent_files(self, *args, **kwargs):
                    """
                    After the maximum (as in max-files) is reached, a file will be deleted for each file saved.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/retain_most_recent_files").execute(*args, **kwargs)
                def max_files(self, *args, **kwargs):
                    """
                    Set the maximum number of data files to save. After the maximum is reached, a file will be deleted for each file saved.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/max_files").execute(*args, **kwargs)
                def case_frequency(self, *args, **kwargs):
                    """
                    Set the preference for saving case files.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/case_frequency").execute(*args, **kwargs)
                def append_file_name_with(self, *args, **kwargs):
                    """
                    Set the suffix for auto-saved files. The file name can be appended by flow-time, time-step value or by user specified flags in file name.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/append_file_name_with").execute(*args, **kwargs)

            class solution_strategy(TUIMenu):
                """
                Enter the automatic initialization and case modification strategy menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.automatic_case_modification = self.__class__.automatic_case_modification(path + ["automatic_case_modification"], service)
                    super().__init__(path, service)
                def enable_strategy(self, *args, **kwargs):
                    """
                    Specify whether automatic initialization and case modification should be enabled.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_strategy").execute(*args, **kwargs)
                def enable_modification(self, *args, **kwargs):
                    """
                    Enable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_modification").execute(*args, **kwargs)
                def automatic_initialization(self, *args, **kwargs):
                    """
                    Define how the case is to be initialized automatically.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_initialization").execute(*args, **kwargs)
                def delete_modification(self, *args, **kwargs):
                    """
                    Delete a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/delete_modification").execute(*args, **kwargs)
                def execute_strategy(self, *args, **kwargs):
                    """
                    Execute the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/execute_strategy").execute(*args, **kwargs)
                def export_modifications(self, *args, **kwargs):
                    """
                    Export all case modifications to a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/export_modifications").execute(*args, **kwargs)
                def disable_modification(self, *args, **kwargs):
                    """
                    Disable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/disable_modification").execute(*args, **kwargs)
                def add_edit_modification(self, *args, **kwargs):
                    """
                    Define a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/add_edit_modification").execute(*args, **kwargs)
                def import_modifications(self, *args, **kwargs):
                    """
                    Import a list of case modifications from a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/import_modifications").execute(*args, **kwargs)
                def continue_strategy_execution(self, *args, **kwargs):
                    """
                    Continue execution of the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/continue_strategy_execution").execute(*args, **kwargs)
                def copy_modification(self, *args, **kwargs):
                    """
                    Copy a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/copy_modification").execute(*args, **kwargs)

                class automatic_case_modification(TUIMenu):
                    """
                    Define how the case is to be modified as the solution progresses.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def original_settings(self, *args, **kwargs):
                        """
                        Specify modification to be performed after initialization to restore to original settings.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/original_settings").execute(*args, **kwargs)
                    def modifications(self, *args, **kwargs):
                        """
                        Specify modifications to be performed during solution.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/modifications").execute(*args, **kwargs)
                    def before_init_modification(self, *args, **kwargs):
                        """
                        Specify modification to be performed before initialization.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/before_init_modification").execute(*args, **kwargs)

            class animate(TUIMenu):
                """
                Enter the animation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.objects = self.__class__.objects(path + ["objects"], service)
                    self.define = self.__class__.define(path + ["define"], service)
                    super().__init__(path, service)

                class objects(TUIMenu):
                    """
                    Enter to define, edit, delete solution animation objects.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def copy(self, *args, **kwargs):
                        """
                        Copy graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/copy").execute(*args, **kwargs)
                    def clear_history(self, *args, **kwargs):
                        """
                        Clear object history.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/clear_history").execute(*args, **kwargs)
                    def create(self, *args, **kwargs):
                        """
                        Create new graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/create").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/delete").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/edit").execute(*args, **kwargs)

                class define(TUIMenu):
                    """
                    Enter the animation definition menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def define_monitor(self, *args, **kwargs):
                        """
                        Define new animation.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/define_monitor").execute(*args, **kwargs)
                    def edit_monitor(self, *args, **kwargs):
                        """
                        Change animation monitor attributes.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/edit_monitor").execute(*args, **kwargs)

            class execute_commands(TUIMenu):
                """
                Enter the execute-monitor-commands menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def export(self, *args, **kwargs):
                    """
                    Export execute-commands to a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/export").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/delete").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/enable").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/copy").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/disable").execute(*args, **kwargs)
                def add_edit(self, *args, **kwargs):
                    """
                    Add or edit execute-commands.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/add_edit").execute(*args, **kwargs)
                def import_(self, *args, **kwargs):
                    """
                    Import execute-commands from a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/import").execute(*args, **kwargs)

        class controls(TUIMenu):
            """
            Enter the controls menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.query = self.__class__.query(path + ["query"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                super().__init__(path, service)
            def equations(self, *args, **kwargs):
                """
                Enter the equations menu.
                """
                return PyMenu(self.service, "/solution/controls/equations").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Set solver limits for the values of various solution variables.
                """
                return PyMenu(self.service, "/solution/controls/limits").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Set controls to default values.
                """
                return PyMenu(self.service, "/solution/controls/set_controls_to_default").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Set the fine mesh Courant number (time step factor).
                """
                return PyMenu(self.service, "/solution/controls/courant_number").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enter the under-relaxation menu.
                """
                return PyMenu(self.service, "/solution/controls/under_relaxation").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enter the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solution/controls/relaxation_factor").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Set P-V-Controls.
                """
                return PyMenu(self.service, "/solution/controls/p_v_controls").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enter menu for acoustics wave equation solver controls.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter menu for expert controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify under-relaxation factor to be used in
                        the diagonal matrix elements of implicit solver.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify explicit relaxation factor to be applied to
                        the solution correction when updating solution in the timestep iterations.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter controls query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                    self.advanced = self.__class__.advanced(path + ["advanced"], service)
                    super().__init__(path, service)
                def courant_number(self, *args, **kwargs):
                    """
                    Get the fine mesh Courant number (time step factor).
                    """
                    return PyMenu(self.service, "/solution/controls/query/courant_number").execute(*args, **kwargs)
                def p_v_controls(self, *args, **kwargs):
                    """
                    Get P-V-Controls.
                    """
                    return PyMenu(self.service, "/solution/controls/query/p_v_controls").execute(*args, **kwargs)
                def relaxation_factor(self, *args, **kwargs):
                    """
                    Enter the relaxation-factor menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/relaxation_factor").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Enter under relaxation menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/under_relaxation").execute(*args, **kwargs)
                def limits(self, *args, **kwargs):
                    """
                    Get solver limits for the values of various solution variables.
                    """
                    return PyMenu(self.service, "/solution/controls/query/limits").execute(*args, **kwargs)
                def equations(self, *args, **kwargs):
                    """
                    Enter the equations menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/equations").execute(*args, **kwargs)

                class acoustics_wave_equation_controls(TUIMenu):
                    """
                    Enter menu for acoustics wave equation solver controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def relative_convergence_criterion(self, *args, **kwargs):
                        """
                        Specify convergence tolerance for the timestep iterations
                        as the target residual reduction factor.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)
                    def max_iterations_per_timestep(self, *args, **kwargs):
                        """
                        Specify maximum number of iterations per timestep.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter menu for expert controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def under_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify under-relaxation factor to be used in
                            the diagonal matrix elements of implicit solver.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)
                        def explicit_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify explicit relaxation factor to be applied to
                            the solution correction when updating solution in the timestep iterations.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)

                class advanced(TUIMenu):
                    """
                    Controls advanced options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                        super().__init__(path, service)
                    def relaxation_method(self, *args, **kwargs):
                        """
                        Set the solver relaxation method.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/relaxation_method").execute(*args, **kwargs)
                    def multi_grid_controls(self, *args, **kwargs):
                        """
                        Enter the multi-grid-controls menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_controls").execute(*args, **kwargs)
                    def correction_tolerance(self, *args, **kwargs):
                        """
                        Enter the correction tolerance menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/correction_tolerance").execute(*args, **kwargs)
                    def multi_grid_fas(self, *args, **kwargs):
                        """
                        Get the coefficients that govern the FAS multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_fas").execute(*args, **kwargs)
                    def multi_stage(self, *args, **kwargs):
                        """
                        Set the multiple-stage time stepping scheme coefficients.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_stage").execute(*args, **kwargs)
                    def multi_grid_amg(self, *args, **kwargs):
                        """
                        Get the parameters that govern the algebraic multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_amg").execute(*args, **kwargs)

                    class amg_options(TUIMenu):
                        """
                        Enter AMG options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def aggressive_amg_coarsening(self, *args, **kwargs):
                            """
                            Use aggressive AMG coarsening.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)
                        def conservative_amg_coarsening(self, *args, **kwargs):
                            """
                            Use conservative AMG coarsening?.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                        def amg_gpgpu_options(self, *args, **kwargs):
                            """
                            Amg gpu options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                        def laplace_coarsening(self, *args, **kwargs):
                            """
                            Get AMG laplace coarsening options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/verbosity").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Controls advanced options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                    self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                    super().__init__(path, service)
                def multi_stage(self, *args, **kwargs):
                    """
                    Set the multiple-stage time stepping scheme coefficients.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_stage").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Set the solver relaxation method.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/relaxation_method").execute(*args, **kwargs)
                def slope_limiter_set(self, *args, **kwargs):
                    """
                    Enter the slope limiter set menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/slope_limiter_set").execute(*args, **kwargs)
                def multi_grid_controls(self, *args, **kwargs):
                    """
                    Enter the multi-grid-controls menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_controls").execute(*args, **kwargs)
                def correction_tolerance(self, *args, **kwargs):
                    """
                    Enter the correction tolerance menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/correction_tolerance").execute(*args, **kwargs)
                def multi_grid_fas(self, *args, **kwargs):
                    """
                    Set the coefficients that govern the FAS multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_fas").execute(*args, **kwargs)
                def multi_grid_amg(self, *args, **kwargs):
                    """
                    Set the parameters that govern the algebraic multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_amg").execute(*args, **kwargs)

                class amg_options(TUIMenu):
                    """
                    Enter AMG options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def amg_gpgpu_options(self, *args, **kwargs):
                        """
                        Set GPGPU AMG solver options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                    def laplace_coarsening(self, *args, **kwargs):
                        """
                        Set AMG laplace coarsening options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)
                    def conservative_amg_coarsening(self, *args, **kwargs):
                        """
                        Use conservative AMG coarsening?.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                    def aggressive_amg_coarsening(self, *args, **kwargs):
                        """
                        Use aggressive AMG coarsening.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

                class fast_transient_settings(TUIMenu):
                    """
                    Enter the fast transient settings menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rk2(self, *args, **kwargs):
                        """
                        Enable the use of a two-stage Runge-Kutta scheme for time integration.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/fast_transient_settings/rk2").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enter the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                super().__init__(path, service)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enter the settings for hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enter the set full-multigrid for initialization menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initialize using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/hyb_initialization").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initialize statistics.
                """
                return PyMenu(self.service, "/solution/initialize/init_flow_statistics").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initialize using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solution/initialize/fmg_initialization").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Enter the set defaults menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_defaults").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specify number of timesteps for ramping of sources
                and initialize acoustics model variables.
                During ramping the sound sources are multiplied by a factor smoothly growing from 0 to 1.
                """
                return PyMenu(self.service, "/solution/initialize/init_acoustics_options").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                List default values.
                """
                return PyMenu(self.service, "/solution/initialize/list_defaults").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/levelset_auto_init").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Delete wall film particles and initialize wall film variables to zero.
                """
                return PyMenu(self.service, "/solution/initialize/lwf_initialization").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initialize turbulent velocity fluctuations.
                """
                return PyMenu(self.service, "/solution/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Reset discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solution/initialize/dpm_reset").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initialize the flow field with the current default values.
                """
                return PyMenu(self.service, "/solution/initialize/initialize_flow").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solution/initialize/patch").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_time_sampled").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Correct wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solution/initialize/repair_wall_distance").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Set reference frame absolute or relative.
                """
                return PyMenu(self.service, "/solution/initialize/reference_frame").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Open channel automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/open_channel_auto_init").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enter the compute defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initialize the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/periodic").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Turbulent flow parameters for localized initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enter the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_options(self, *args, **kwargs):
                    """
                    Patch and smoothing options for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)

    class plot(TUIMenu):
        """
        Enter the XY plot menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
            self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
            self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
            super().__init__(path, service)
        def datasources(self, *args, **kwargs):
            """
            Enters the menu for creating and modifying plots containing multiple data sources.
            """
            return PyMenu(self.service, "/plot/datasources").execute(*args, **kwargs)
        def histogram_set(self, *args, **kwargs):
            """
            Sets histogram plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/histogram_set").execute(*args, **kwargs)
        def circum_avg_radial(self, *args, **kwargs):
            """
            Computes iso-radial band surfaces and plots data vs. radius on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_radial").execute(*args, **kwargs)
        def residuals_set(self, *args, **kwargs):
            """
            Sets residual plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/residuals_set").execute(*args, **kwargs)
        def solution_set(self, *args, **kwargs):
            """
            Sets solution plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/solution_set").execute(*args, **kwargs)
        def plot_direction(self, *args, **kwargs):
            """
            Sets plot direction for XY plot.
            """
            return PyMenu(self.service, "/plot/plot_direction").execute(*args, **kwargs)
        def label_alignment(self, *args, **kwargs):
            """
            Set the orientation of XY plot axis labels as either horizontal or axis-aligned.
            """
            return PyMenu(self.service, "/plot/label_alignment").execute(*args, **kwargs)
        def plot(self, *args, **kwargs):
            """
            Plots solution on surfaces.
            """
            return PyMenu(self.service, "/plot/plot").execute(*args, **kwargs)
        def file_set(self, *args, **kwargs):
            """
            Sets file plot parameters.
            """
            return PyMenu(self.service, "/plot/file_set").execute(*args, **kwargs)
        def circum_avg_axial(self, *args, **kwargs):
            """
            Computes iso-axial band surfaces and plots data vs. axial coordinate on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_axial").execute(*args, **kwargs)
        def set_boundary_val_off(self, *args, **kwargs):
            """
            Disables the use of boundary face values when node values are disabled in solution XY plots. This option is disabled by default, that is, boundary face values are used when node values are disabled.
            """
            return PyMenu(self.service, "/plot/set_boundary_val_off").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            Plots data from an external file.
            """
            return PyMenu(self.service, "/plot/file").execute(*args, **kwargs)
        def display_profile_data(self, *args, **kwargs):
            """
            Plots profile data.
            """
            return PyMenu(self.service, "/plot/display_profile_data").execute(*args, **kwargs)
        def change_fft_ref_pressure(self, *args, **kwargs):
            """
            Changes reference acoustic pressure.
            """
            return PyMenu(self.service, "/plot/change_fft_ref_pressure").execute(*args, **kwargs)
        def file_list(self, *args, **kwargs):
            """
            Plots data from multiple external files.
            """
            return PyMenu(self.service, "/plot/file_list").execute(*args, **kwargs)
        def fft_set(self, *args, **kwargs):
            """
            Enter the menu to set histogram plot parameters.
            """
            return PyMenu(self.service, "/plot/fft_set").execute(*args, **kwargs)
        def histogram(self, *args, **kwargs):
            """
            Plots a histogram of the specified solution variable using the defined range and number of intervals.
            """
            return PyMenu(self.service, "/plot/histogram").execute(*args, **kwargs)
        def residuals(self, *args, **kwargs):
            """
            Contains commands that allow you to select the variables for which you want to display XY plots of residual histories in the active graphics window.
            """
            return PyMenu(self.service, "/plot/residuals").execute(*args, **kwargs)
        def solution(self, *args, **kwargs):
            """
            Plots solution on surfaces and/or zones. Zone and surface names can be indicated using a  wildcard (\*).
            """
            return PyMenu(self.service, "/plot/solution").execute(*args, **kwargs)
        def fft(self, *args, **kwargs):
            """
            Plots fast Fourier transform (FFT) of file data. If you respond yes to Acoustic Analysis?, then additional Y axis functions are made available.
            """
            return PyMenu(self.service, "/plot/fft").execute(*args, **kwargs)

        class cumulative_plot(TUIMenu):
            """
            Plot the development of force, force coefficient, moment, or moment coefficient across the specified wall zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot(self, *args, **kwargs):
                """
                Plot a cumulative plot in the graphics window.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/plot").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print the names of the existing cumulative plot objects to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Set curves options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/curves").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/edit").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Create a new cumulative plot.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/add").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write a cumulative plot to a file.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/write").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Set axes options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/axes").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Print the properties of the specified cumulative plot object to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
            def print(self, *args, **kwargs):
                """
                Print the value of a cumulative plot to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/print").execute(*args, **kwargs)

        class ansys_sound_analysis(TUIMenu):
            """
            Enter the Ansys sound analysis menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_files(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before writing a WAV, output pressure, and/or acoustic indicators file.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)
            def print_indicators(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before printing the acoustics indicators.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)

        class flamelet_curves(TUIMenu):
            """
            Enters the flamelet curves menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_to_file(self, *args, **kwargs):
                """
                Writes curve to a file instead of plot.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)
            def plot_curves(self, *args, **kwargs):
                """
                Plots of a curve property.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)

    class mesh(TUIMenu):
        """
        Enter the mesh menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.polyhedra = self.__class__.polyhedra(path + ["polyhedra"], service)
            self.repair_improve = self.__class__.repair_improve(path + ["repair_improve"], service)
            self.surface_mesh = self.__class__.surface_mesh(path + ["surface_mesh"], service)
            self.reorder = self.__class__.reorder(path + ["reorder"], service)
            self.geometry = self.__class__.geometry(path + ["geometry"], service)
            self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
            self.adapt = self.__class__.adapt(path + ["adapt"], service)
            super().__init__(path, service)
        def scale(self, *args, **kwargs):
            """
            Prompts for the scaling factors in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/scale").execute(*args, **kwargs)
        def swap_mesh_faces(self, *args, **kwargs):
            """
            Swaps mesh faces.
            """
            return PyMenu(self.service, "/mesh/swap_mesh_faces").execute(*args, **kwargs)
        def replace(self, *args, **kwargs):
            """
            Replace mesh and interpolate data.
            """
            return PyMenu(self.service, "/mesh/replace").execute(*args, **kwargs)
        def translate(self, *args, **kwargs):
            """
            Prompts for the translation offset in each of the active Cartesian coordinate directions.
            """
            return PyMenu(self.service, "/mesh/translate").execute(*args, **kwargs)
        def check(self, *args, **kwargs):
            """
            Performs various mesh consistency checks and displays a report in the console that lists the domain extents, the volume statistics, the face area statistics, and any warnings, as well as details about the various checks and mesh failures (depending on the setting specified for mesh/check-verbosity).
            """
            return PyMenu(self.service, "/mesh/check").execute(*args, **kwargs)
        def check_before_solve(self, *args, **kwargs):
            """
            The default value for mesh/check-before-solve is “no”. If mesh/check-before-solve is set to “yes”, a mesh check operation will be invoked prior to starting solver. If grid check fails, solver will be interrupted, and relevant information will be printed in the Fluent console.
            """
            return PyMenu(self.service, "/mesh/check_before_solve").execute(*args, **kwargs)
        def set_unit_system(self, *args, **kwargs):
            """
            To apply standard set of units to all quantities.
            """
            return PyMenu(self.service, "/mesh/set_unit_system").execute(*args, **kwargs)
        def rotate(self, *args, **kwargs):
            """
            Rotates the mesh.
            """
            return PyMenu(self.service, "/mesh/rotate").execute(*args, **kwargs)
        def memory_usage(self, *args, **kwargs):
            """
            Reports solver memory use.
            """
            return PyMenu(self.service, "/mesh/memory_usage").execute(*args, **kwargs)
        def enhanced_orthogonal_quality(self, *args, **kwargs):
            """
            Enables / disables an enhanced definition when calculating the orthogonal quality. When enabled, the orthogonal quality is defined using a variety quality measures, including: the orthogonality of a face relative to a vector between the face and cell centroids; a metric that detects poor cell shape at a local edge (such as twisting and/or concavity); and the variation of normals between the faces that can be constructed from the cell face. This enhanced definition is optimal for evaluating thin prism cells.
            """
            return PyMenu(self.service, "/mesh/enhanced_orthogonal_quality").execute(*args, **kwargs)
        def check_verbosity(self, *args, **kwargs):
            """
            Sets the level of details that will be added to the mesh check report generated by mesh/check. A value of 0 (the default) notes when checks are being performed, but does not list them individually. A value of 1 lists the individual checks as they are performed. A value of 2 enables the availability of additional mesh field variables, lists the individual checks as they are performed, and provides additional details (for example, the location of the problem, the affected cells).  The check-verbosity text command can also be used to set the level of detail displayed in the mesh quality report generated by mesh/quality. A value of 0 (the default) or 1 lists the minimum orthogonal quality and the maximum aspect ratio. A value of 2 adds information about the zones that contain the cells with the lowest quality, and additional metrics such as the maximum cell squish index and the minimum expansion ratio.
            """
            return PyMenu(self.service, "/mesh/check_verbosity").execute(*args, **kwargs)
        def quality(self, *args, **kwargs):
            """
            Displays information about the quality of the mesh in the console, including the minimum orthogonal quality and the maximum aspect ratio. The level of detail displayed depends on the setting specified for mesh/check-verbosity.
            """
            return PyMenu(self.service, "/mesh/quality").execute(*args, **kwargs)
        def redistribute_boundary_layer(self, *args, **kwargs):
            """
            Redistributes the nodes in a boundary layer zone to achieve a desired growth rate after anisotropic adaption.
            """
            return PyMenu(self.service, "/mesh/redistribute_boundary_layer").execute(*args, **kwargs)
        def mesh_info(self, *args, **kwargs):
            """
            Prints zone information size.
            """
            return PyMenu(self.service, "/mesh/mesh_info").execute(*args, **kwargs)
        def adjacency(self, *args, **kwargs):
            """
            Views and renames face zones adjacent to selected cell  zones.
            """
            return PyMenu(self.service, "/mesh/adjacency").execute(*args, **kwargs)
        def size_info(self, *args, **kwargs):
            """
            Prints mesh size.
            """
            return PyMenu(self.service, "/mesh/size_info").execute(*args, **kwargs)
        def smooth_mesh(self, *args, **kwargs):
            """
            Smooths the mesh using quality-based, Laplacian, or skewness methods.
            """
            return PyMenu(self.service, "/mesh/smooth_mesh").execute(*args, **kwargs)
        def units(self, *args, **kwargs):
            """
            Set unit conversion factors.
            """
            return PyMenu(self.service, "/mesh/units").execute(*args, **kwargs)
        def show_periodic_shadow_zones(self, *args, **kwargs):
            """
            Option to show periodic shadow zones in user interface.
            """
            return PyMenu(self.service, "/mesh/show_periodic_shadow_zones").execute(*args, **kwargs)

        class polyhedra(TUIMenu):
            """
            Enters the polyhedra menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                super().__init__(path, service)
            def convert_skewed_cells(self, *args, **kwargs):
                """
                Converts skewed cells to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_skewed_cells").execute(*args, **kwargs)
            def convert_hanging_nodes_zones(self, *args, **kwargs):
                """
                Convert selected cell zones with hanging nodes and faces to polyhedra.
                The selected cell zones cannot be connected to other zones.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes_zones").execute(*args, **kwargs)
            def convert_hanging_nodes(self, *args, **kwargs):
                """
                Converts cells with hanging nodes/edges to polyhedra.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_hanging_nodes").execute(*args, **kwargs)
            def convert_domain(self, *args, **kwargs):
                """
                Converts the entire domain to polyhedra cells.
                """
                return PyMenu(self.service, "/mesh/polyhedra/convert_domain").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enters the polyhedra options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def migrate_and_reorder(self, *args, **kwargs):
                    """
                    Enables / disables the migration of newly created partitions to the compute-nodes and the reordering of the domain as part of polyhedra conversion. This is disabled by default, because it requires significant additional memory; when disabled, it is recommended that you save the case file after conversion, read it in a new Fluent session (so that the new / stored partitions become active), and then manually reorder using the mesh/reorder/reorder-domain text command. If you want to run the calculation in the current Fluent session you can enable the migrate-and-reorder? text command prior to conversion, but you must ensure that no more than half of the available memory of your system is currently used.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/migrate_and_reorder").execute(*args, **kwargs)
                def preserve_interior_zones(self, *args, **kwargs):
                    """
                    Enables the preservation of surfaces (that is, manifold zones of type interior) during the conversion of the domain to polyhedra. Note that only those zones with a name that includes the string you specify will be preserved.
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_interior_zones").execute(*args, **kwargs)
                def preserve_boundary_layer(self, *args, **kwargs):
                    """
                    Specifies whether boundary layer cells will be preserved when the domain is converted to polyhedra. When the value is set to 0 (default) ANSYS Fluent checks for high aspect ratio cells at the boundary layer and if any are found, Fluent asks if you want to preserve the boundary layer. When the value is set to 1, the boundary layer cells are never preserved; when it is set to 2, the boundary layer cells are always preserved (regardless of the aspect ratio of the boundary layer cells).
                    """
                    return PyMenu(self.service, "/mesh/polyhedra/options/preserve_boundary_layer").execute(*args, **kwargs)

        class repair_improve(TUIMenu):
            """
            Enter the repair and improve quality menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def report_poor_elements(self, *args, **kwargs):
                """
                Reports invalid and poor quality elements.
                """
                return PyMenu(self.service, "/mesh/repair_improve/report_poor_elements").execute(*args, **kwargs)
            def repair_periodic(self, *args, **kwargs):
                """
                Modifies the mesh to enforce a rotational angle or translational distance for periodic boundaries. For translationally periodic boundaries, the command computes an average translation distance and adjusts the node coordinates on the shadow face zone to match this distance. For rotationally periodic boundaries, the command prompts for an angle and adjusts the node coordinates on the shadow face zone using this angle and the defined rotational axis for the cell zone.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_periodic").execute(*args, **kwargs)
            def repair(self, *args, **kwargs):
                """
                Repairs mesh problems identified by the mesh check, if possible. The repairs include fixing cells that have the wrong node order, the wrong face handedness, faces that are small or nonexistent, or very poor quality. Only interior nodes are repositioned by default; boundary nodes may be repositioned if the  mesh/repair-improve/allow-repair-at-boundaries text command is enabled. Note that highly skewed cells may be converted into polyhedra, depending on whether the  mesh/repair-improve/include-local-polyhedra-conversion-in-repair text command is enabled.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair").execute(*args, **kwargs)
            def repair_face_node_order(self, *args, **kwargs):
                """
                Modifies face nodes to repair faces with improper face node order and, therefore, eliminates any resulting left-handed faces.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_node_order").execute(*args, **kwargs)
            def repair_face_handedness(self, *args, **kwargs):
                """
                Modifies cell centroids to repair meshes that contain left-handed faces without face node order problems.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_face_handedness").execute(*args, **kwargs)
            def include_local_polyhedra_conversion_in_repair(self, *args, **kwargs):
                """
                Enables/disables the local conversion of degenerate cells into polyhedra based on skewness criteria as part of the mesh repairs performed by the  mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/include_local_polyhedra_conversion_in_repair").execute(*args, **kwargs)
            def allow_repair_at_boundaries(self, *args, **kwargs):
                """
                Allows the adjustment of the positions of nodes on boundaries as part of the mesh repairs performed by the mesh/repair-improve/repair text command.
                """
                return PyMenu(self.service, "/mesh/repair_improve/allow_repair_at_boundaries").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improves poor quality cells in the mesh, if possible.
                """
                return PyMenu(self.service, "/mesh/repair_improve/improve_quality").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/mesh/repair_improve/repair_wall_distance").execute(*args, **kwargs)

        class surface_mesh(TUIMenu):
            """
            Enters the Surface Mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes surface mesh.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/delete").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                Reads surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/read").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Displays surface meshes.
                """
                return PyMenu(self.service, "/mesh/surface_mesh/display").execute(*args, **kwargs)

        class reorder(TUIMenu):
            """
            Reorders domain menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def band_width(self, *args, **kwargs):
                """
                Prints cell bandwidth.
                """
                return PyMenu(self.service, "/mesh/reorder/band_width").execute(*args, **kwargs)
            def reorder_domain(self, *args, **kwargs):
                """
                Reorders cells and faces using the reverse Cuthill-McKee algorithm. Note that you must save a new case file (and a data file, if data exists) after reordering with this text command, as well as recreate any ray files and/or surface cluster information.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_domain").execute(*args, **kwargs)
            def reorder_zones(self, *args, **kwargs):
                """
                Reorders zones by partition, type, and ID.
                """
                return PyMenu(self.service, "/mesh/reorder/reorder_zones").execute(*args, **kwargs)

        class geometry(TUIMenu):
            """
            Enter the geometry menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/mesh/geometry/add").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/mesh/geometry/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/mesh/geometry/list").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display geometry.
                """
                return PyMenu(self.service, "/mesh/geometry/display").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/mesh/geometry/list_properties").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/mesh/geometry/edit").execute(*args, **kwargs)

        class modify_zones(TUIMenu):
            """
            Enters the zone modification menu. For a description of the items in this menu, see define/boundary-conditions/modify-zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def orient_face_zone(self, *args, **kwargs):
                """
                Orient the face zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/orient_face_zone").execute(*args, **kwargs)
            def slit_interior_between_diff_solids(self, *args, **kwargs):
                """
                Slit interior created between different solids into coupled walls.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
            def append_mesh_data(self, *args, **kwargs):
                """
                Append new mesh with data.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh_data").execute(*args, **kwargs)
            def sep_cell_zone_mark(self, *args, **kwargs):
                """
                Separate a cell zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
            def extrude_face_zone_para(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
            def create_all_shell_threads(self, *args, **kwargs):
                """
                Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
            def recreate_all_shells(self, *args, **kwargs):
                """
                Create shell on all the walls where which were deleted using the command delete-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/recreate_all_shells").execute(*args, **kwargs)
            def mrf_to_sliding_mesh(self, *args, **kwargs):
                """
                Change motion specification from MRF to moving mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
            def matching_tolerance(self, *args, **kwargs):
                """
                Set the normalized tolerance used for finding coincident nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/matching_tolerance").execute(*args, **kwargs)
            def sep_face_zone_angle(self, *args, **kwargs):
                """
                Separate a face zone based on significant angle.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_type").execute(*args, **kwargs)
            def sep_face_zone_mark(self, *args, **kwargs):
                """
                Separate a face zone based on cell marking.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
            def sep_cell_zone_region(self, *args, **kwargs):
                """
                Separate a cell zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
            def change_zone_state(self, *args, **kwargs):
                """
                Change the realgas material state for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_state").execute(*args, **kwargs)
            def replace_zone(self, *args, **kwargs):
                """
                Replace a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/replace_zone").execute(*args, **kwargs)
            def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
            def delete_cell_zone(self, *args, **kwargs):
                """
                Delete a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_cell_zone").execute(*args, **kwargs)
            def slit_face_zone(self, *args, **kwargs):
                """
                Slit a two-sided wall into two connected wall zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_face_zone").execute(*args, **kwargs)
            def activate_cell_zone(self, *args, **kwargs):
                """
                Activate a cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/activate_cell_zone").execute(*args, **kwargs)
            def merge_zones(self, *args, **kwargs):
                """
                Merge zones of the same type and condition into one.
                """
                return PyMenu(self.service, "/mesh/modify_zones/merge_zones").execute(*args, **kwargs)
            def delete_all_shells(self, *args, **kwargs):
                """
                Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                """
                return PyMenu(self.service, "/mesh/modify_zones/delete_all_shells").execute(*args, **kwargs)
            def sep_face_zone_region(self, *args, **kwargs):
                """
                Separate a face zone based on contiguous regions.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
            def sep_face_zone_face(self, *args, **kwargs):
                """
                Separate each face in a zone into unique zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Attempt to establish conformal periodic face zone connectivity.
                """
                return PyMenu(self.service, "/mesh/modify_zones/make_periodic").execute(*args, **kwargs)
            def append_mesh(self, *args, **kwargs):
                """
                Append new mesh.
                """
                return PyMenu(self.service, "/mesh/modify_zones/append_mesh").execute(*args, **kwargs)
            def create_periodic_interface(self, *args, **kwargs):
                """
                Create a conformal or non-conformal periodic interface.
                """
                return PyMenu(self.service, "/mesh/modify_zones/create_periodic_interface").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/mesh/modify_zones/zone_name").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/mesh/modify_zones/list_zones").execute(*args, **kwargs)
            def fuse_face_zones(self, *args, **kwargs):
                """
                Attempt to fuse zones by removing duplicate faces and nodes.
                """
                return PyMenu(self.service, "/mesh/modify_zones/fuse_face_zones").execute(*args, **kwargs)
            def scale_zone(self, *args, **kwargs):
                """
                Scale nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/scale_zone").execute(*args, **kwargs)
            def translate_zone(self, *args, **kwargs):
                """
                Translate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/translate_zone").execute(*args, **kwargs)
            def extrude_face_zone_delta(self, *args, **kwargs):
                """
                Extrude a face thread a specified distance based on a list of deltas.
                """
                return PyMenu(self.service, "/mesh/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
            def deactivate_cell_zone(self, *args, **kwargs):
                """
                Deactivate cell thread.
                """
                return PyMenu(self.service, "/mesh/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
            def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                """
                Change all solid zones motion specification from MRF to solid motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
            def change_zone_phase(self, *args, **kwargs):
                """
                Change the realgas phase for a zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/change_zone_phase").execute(*args, **kwargs)
            def copy_move_cell_zone(self, *args, **kwargs):
                """
                Copy and translate or rotate a cell zone.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
            def slit_periodic(self, *args, **kwargs):
                """
                Slit a periodic zone into two symmetry zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/slit_periodic").execute(*args, **kwargs)
            def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                """
                Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                """
                return PyMenu(self.service, "/mesh/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
            def rotate_zone(self, *args, **kwargs):
                """
                Rotate nodal coordinates of input cell zones.
                """
                return PyMenu(self.service, "/mesh/modify_zones/rotate_zone").execute(*args, **kwargs)

        class adapt(TUIMenu):
            """
            Enters the mesh adaption menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.profile = self.__class__.profile(path + ["profile"], service)
                self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
                self.geometry = self.__class__.geometry(path + ["geometry"], service)
                self.multi_layer_refinement = self.__class__.multi_layer_refinement(path + ["multi_layer_refinement"], service)
                self.manage_criteria = self.__class__.manage_criteria(path + ["manage_criteria"], service)
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def refinement_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/refinement_criteria").execute(*args, **kwargs)
            def coarsening_criteria(self, *args, **kwargs):
                """
                Allows you to provide an expression for the coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/coarsening_criteria").execute(*args, **kwargs)
            def display_adaption_cells(self, *args, **kwargs):
                """
                Displays the cells that are marked for adaption in the graphics window.
                """
                return PyMenu(self.service, "/mesh/adapt/display_adaption_cells").execute(*args, **kwargs)
            def adapt_mesh(self, *args, **kwargs):
                """
                Performs manual adaption on the mesh according to the methods and settings that you specified.
                """
                return PyMenu(self.service, "/mesh/adapt/adapt_mesh").execute(*args, **kwargs)
            def manual_coarsening_criteria(self, *args, **kwargs):
                """
                Set expression for manual coarsening criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_coarsening_criteria").execute(*args, **kwargs)
            def anisotropic_adaption(self, *args, **kwargs):
                """
                Applies legacy anisotropic adaption to refine the boundary layers or registers. Cells will be split in the normal direction to the boundary face. Note that this text command is only available for 3D cases that have the adaption method set to hanging node.
                """
                return PyMenu(self.service, "/mesh/adapt/anisotropic_adaption").execute(*args, **kwargs)
            def manual_refinement_criteria(self, *args, **kwargs):
                """
                Set expression for manual refinement criterion.
                """
                return PyMenu(self.service, "/mesh/adapt/manual_refinement_criteria").execute(*args, **kwargs)
            def list_adaption_cells(self, *args, **kwargs):
                """
                Prints the number of cells marked for refinement, coarsening, and both to the console.
                """
                return PyMenu(self.service, "/mesh/adapt/list_adaption_cells").execute(*args, **kwargs)
            def free_hierarchy(self, *args, **kwargs):
                """
                Deletes the defined adaption hierarchy.
                """
                return PyMenu(self.service, "/mesh/adapt/free_hierarchy").execute(*args, **kwargs)

            class profile(TUIMenu):
                """
                Enters the profile menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/enable").execute(*args, **kwargs)
                def clear(self, *args, **kwargs):
                    """
                    Clears the adaption profiling counters.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/clear").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disables adaption profiling.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/disable").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Prints adaption profiling results.
                    """
                    return PyMenu(self.service, "/mesh/adapt/profile/print").execute(*args, **kwargs)

            class cell_registers(TUIMenu):
                """
                Enters the cell registers menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def coarsen(self, *args, **kwargs):
                    """
                    Coarsen the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/coarsen").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/add").execute(*args, **kwargs)
                def refine(self, *args, **kwargs):
                    """
                    Refine the mesh based on a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/refine").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/edit").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Displays a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/display").execute(*args, **kwargs)
                def apply_poor_mesh_numerics(self, *args, **kwargs):
                    """
                    Applies poor mesh numerics to the mesh of a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    Lists all of the currently defined cell registers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/list").execute(*args, **kwargs)
                def adapt(self, *args, **kwargs):
                    """
                    Adapt cell register objects.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/adapt").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes a cell register.
                    """
                    return PyMenu(self.service, "/mesh/adapt/cell_registers/delete").execute(*args, **kwargs)

            class geometry(TUIMenu):
                """
                Enters the geometry menu. Note that this text command menu is not available unless the adaption method is set to hanging node.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def reconstruct_geometry(self, *args, **kwargs):
                    """
                    Enables/disables geometry-based adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/reconstruct_geometry").execute(*args, **kwargs)
                def set_geometry_controls(self, *args, **kwargs):
                    """
                    Sets geometry controls for wall zones.
                    """
                    return PyMenu(self.service, "/mesh/adapt/geometry/set_geometry_controls").execute(*args, **kwargs)

            class multi_layer_refinement(TUIMenu):
                """
                Enter the multiple boundary layer refinement menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def parameters(self, *args, **kwargs):
                    """
                    Specify parameters for multiple boundary layer refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/parameters").execute(*args, **kwargs)
                def boundary_zones(self, *args, **kwargs):
                    """
                    Specify boundary zones for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/boundary_zones").execute(*args, **kwargs)
                def refine_mesh(self, *args, **kwargs):
                    """
                    Refine the mesh for multiple boundary layers.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/refine_mesh").execute(*args, **kwargs)
                def layer_count(self, *args, **kwargs):
                    """
                    Specify the layer count for refinement.
                    """
                    return PyMenu(self.service, "/mesh/adapt/multi_layer_refinement/layer_count").execute(*args, **kwargs)

            class manage_criteria(TUIMenu):
                """
                Enters the manage criteria menu, which provides text commands for managing automatic adaption criteria.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    Lists all the existing automatic adaption criteria.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    Lists the properties of an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/list_properties").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Adds a new automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes an existing automatic adaption criterion.
                    """
                    return PyMenu(self.service, "/mesh/adapt/manage_criteria/delete").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def method(self, *args, **kwargs):
                    """
                    Sets the adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/method").execute(*args, **kwargs)
                def overset_adapt_dead_cells(self, *args, **kwargs):
                    """
                    Enables/disables the adaption of dead cells in overset meshes.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/overset_adapt_dead_cells").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Allows you set how much information about the adaption is printed to the console.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/verbosity").execute(*args, **kwargs)
                def anisotropic_boundary_zones(self, *args, **kwargs):
                    """
                    Allows you to select the boundary zones that specify directions for anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_boundary_zones").execute(*args, **kwargs)
                def maximum_refinement_level(self, *args, **kwargs):
                    """
                    Controls the number of levels of refinement used to split cells during the adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                def additional_refinement_layers(self, *args, **kwargs):
                    """
                    Allows you to specify additional refinement layers (this is an advanced control).
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/additional_refinement_layers").execute(*args, **kwargs)
                def maximum_cell_count(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the total cell count of the mesh during adaption. Fluent uses this value to determine when to stop marking cells for refinement. A value of zero places no limits on the number of cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/maximum_cell_count").execute(*args, **kwargs)
                def dynamic_adaption(self, *args, **kwargs):
                    """
                    Adapt the mesh during solution.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption").execute(*args, **kwargs)
                def minimum_cell_quality(self, *args, **kwargs):
                    """
                    Sets the minimum value allowed for the orthogonal quality of cells during adaption. If your solution diverges, you may find that using a higher minimum quality value resolves the issue. This text command is only available with the PUMA 3D adaption method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_cell_quality").execute(*args, **kwargs)
                def anisotropic_adaption(self, *args, **kwargs):
                    """
                    Enables / disables anisotropic adaption for prismatic cells as part of manual adaption. Note that this text command requires that the adaption method is set to PUMA.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_adaption").execute(*args, **kwargs)
                def anisotropic_split_ratio(self, *args, **kwargs):
                    """
                    Sets the split ratio for the cells as part of anisotropic refinement with the PUMA method.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/anisotropic_split_ratio").execute(*args, **kwargs)
                def cell_zones(self, *args, **kwargs):
                    """
                    Sets cell zones to be used for marking adaption. An empty list specifies that all zones are considered for adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/cell_zones").execute(*args, **kwargs)
                def display_settings(self, *args, **kwargs):
                    """
                    Sets the graphics display options for the refinement, coarsening, and common cells.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/display_settings").execute(*args, **kwargs)
                def minimum_edge_length(self, *args, **kwargs):
                    """
                    Sets an approximate limit to the edge length for cells that are considered for refinement. Even if a cell is marked for refinement, it will not be refined if (for 3D) its volume is less than the cube of this field or (for 2D) its area is less than the square of this field. The default value of zero places no limits on the size of cells that are refined.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/minimum_edge_length").execute(*args, **kwargs)
                def encapsulate_children(self, *args, **kwargs):
                    """
                    Encapsulate all children of parent cells on the same partition.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/encapsulate_children").execute(*args, **kwargs)
                def dynamic_adaption_frequency(self, *args, **kwargs):
                    """
                    Set frequency for dynamic adaption.
                    """
                    return PyMenu(self.service, "/mesh/adapt/set/dynamic_adaption_frequency").execute(*args, **kwargs)

    class turbo_workflow(TUIMenu):
        """
        Enter the turbo workflow menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.workflow = self.__class__.workflow(path + ["workflow"], service)
            super().__init__(path, service)

        class workflow(TUIMenu):
            """
            Enter the workflow menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def reset(self, *args, **kwargs):
                """
                Reset the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/reset").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/disable").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/enable").execute(*args, **kwargs)

    class icing(TUIMenu):
        """
        FENSAP-ICE options.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def flow(self, *args, **kwargs):
            """
            Flow solver menu.
            """
            return PyMenu(self.service, "/icing/flow").execute(*args, **kwargs)
        def settings(self, *args, **kwargs):
            """
            Global settings menu.
            """
            return PyMenu(self.service, "/icing/settings").execute(*args, **kwargs)
        def multishot(self, *args, **kwargs):
            """
            Multi-shot accretion menu.
            """
            return PyMenu(self.service, "/icing/multishot").execute(*args, **kwargs)
        def ice(self, *args, **kwargs):
            """
            Ice accretion menu.
            """
            return PyMenu(self.service, "/icing/ice").execute(*args, **kwargs)
        def drop(self, *args, **kwargs):
            """
            Droplet impingement menu.
            """
            return PyMenu(self.service, "/icing/drop").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            File menu.
            """
            return PyMenu(self.service, "/icing/file").execute(*args, **kwargs)

    class adjoint(TUIMenu):
        """
        Adjoint.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def reporting(self, *args, **kwargs):
            """
            Menu to report sensitivity data from the adjoint solution.
            """
            return PyMenu(self.service, "/adjoint/reporting").execute(*args, **kwargs)
        def geometry(self, *args, **kwargs):
            """
            Geometry menu.
            """
            return PyMenu(self.service, "/adjoint/geometry").execute(*args, **kwargs)
        def expert(self, *args, **kwargs):
            """
            Provides text commands that allow you to undo enhancements to the default adjoint solver behavior.
            """
            return PyMenu(self.service, "/adjoint/expert").execute(*args, **kwargs)
        def postprocess_options(self, *args, **kwargs):
            """
            Postprocess options.
            """
            return PyMenu(self.service, "/adjoint/postprocess_options").execute(*args, **kwargs)
        def controls(self, *args, **kwargs):
            """
            Menu to configure adjoint solver controls.
            """
            return PyMenu(self.service, "/adjoint/controls").execute(*args, **kwargs)
        def observable(self, *args, **kwargs):
            """
            Menu to create and configure observables of interest.
            """
            return PyMenu(self.service, "/adjoint/observable").execute(*args, **kwargs)
        def multi_objective(self, *args, **kwargs):
            """
            Multi-Objective menu.
            """
            return PyMenu(self.service, "/adjoint/multi_objective").execute(*args, **kwargs)
        def design_tool(self, *args, **kwargs):
            """
            Enters the design-tool menu.
            """
            return PyMenu(self.service, "/adjoint/design_tool").execute(*args, **kwargs)
        def morphing(self, *args, **kwargs):
            """
            Morphing menu.
            """
            return PyMenu(self.service, "/adjoint/morphing").execute(*args, **kwargs)
        def run(self, *args, **kwargs):
            """
            Menu to initialize and compute the adjoint solution.
            """
            return PyMenu(self.service, "/adjoint/run").execute(*args, **kwargs)
        def methods(self, *args, **kwargs):
            """
            Menu to configure adjoint solver settings.
            """
            return PyMenu(self.service, "/adjoint/methods").execute(*args, **kwargs)
        def optimizer(self, *args, **kwargs):
            """
            Enters the optimizer menu, where you can use a gradient-based optimizer to optimize the geometry to meet multiple goals for multiple observables at multiple operating conditions.
            """
            return PyMenu(self.service, "/adjoint/optimizer").execute(*args, **kwargs)
        def utilities(self, *args, **kwargs):
            """
            Enters the utilities menu.
            """
            return PyMenu(self.service, "/adjoint/utilities").execute(*args, **kwargs)
        def monitors(self, *args, **kwargs):
            """
            Menu to configure monitors for the adjoint solver.
            """
            return PyMenu(self.service, "/adjoint/monitors").execute(*args, **kwargs)

    class report(TUIMenu):
        """
        Enter the report menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.forces = self.__class__.forces(path + ["forces"], service)
            self.dpm_histogram = self.__class__.dpm_histogram(path + ["dpm_histogram"], service)
            self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
            self.system = self.__class__.system(path + ["system"], service)
            self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
            self.fluxes = self.__class__.fluxes(path + ["fluxes"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
            self.icing = self.__class__.icing(path + ["icing"], service)
            self.modified_setting = self.__class__.modified_setting(path + ["modified_setting"], service)
            super().__init__(path, service)
        def particle_summary(self, *args, **kwargs):
            """
            Prints summary report for all current particles.
            """
            return PyMenu(self.service, "/report/particle_summary").execute(*args, **kwargs)
        def element_mass_flow(self, *args, **kwargs):
            """
            Prints list of element flow rate at inlets and outlets. This reports the mass flow rates of all chemical elements (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/element_mass_flow").execute(*args, **kwargs)
        def dpm_extended_summary(self, *args, **kwargs):
            """
            Create an extended discrete phase summary report of the discrete phase injection(s). You can choose whether you want to save the extended report to a file or print it in the console window. For unsteady tracking, you will be asked whether you want to include in-domain particle/tracks in the report. You will be also prompted whether you want to select a single injection for the summary report. By default, all injections are included. The output depends on whether you have enabled the report/dpm-zone-summaries-per-injection? text command, in which case additional information is printed for escaped particles, such as per-injection data. Note that, for unsteady particle tracking, it is necessary to enable the report/dpm-zone-summaries-per-injection? text command before any particle parcels are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_extended_summary").execute(*args, **kwargs)
        def dpm_summary(self, *args, **kwargs):
            """
            Prints discrete phase summary report.
            """
            return PyMenu(self.service, "/report/dpm_summary").execute(*args, **kwargs)
        def surface_integrals(self, *args, **kwargs):
            """
            Enters the surface integral menu.
            """
            return PyMenu(self.service, "/report/surface_integrals").execute(*args, **kwargs)
        def dpm_sample_output_udf(self, *args, **kwargs):
            """
            Allows you to hook a previously loaded DEFINE_DPM_OUTPUT UDF for file format specification for sampling of trajectories and VOF-to-DPM lump conversion transcripts.
            """
            return PyMenu(self.service, "/report/dpm_sample_output_udf").execute(*args, **kwargs)
        def uds_flow(self, *args, **kwargs):
            """
            Prints list of user-defined scalar flow rate at boundaries.
            """
            return PyMenu(self.service, "/report/uds_flow").execute(*args, **kwargs)
        def aero_optical_distortions(self, *args, **kwargs):
            """
            Optics report menu.
            """
            return PyMenu(self.service, "/report/aero_optical_distortions").execute(*args, **kwargs)
        def print_histogram(self, *args, **kwargs):
            """
            Prints a histogram of a scalar quantity.
            """
            return PyMenu(self.service, "/report/print_histogram").execute(*args, **kwargs)
        def mphase_summary(self, *args, **kwargs):
            """
            Prints summary report for a multiphase case setup.
            """
            return PyMenu(self.service, "/report/mphase_summary").execute(*args, **kwargs)
        def dpm_sample_sort_file(self, *args, **kwargs):
            """
            Enables/disables writing of sorted DPM sample files.
            """
            return PyMenu(self.service, "/report/dpm_sample_sort_file").execute(*args, **kwargs)
        def dpm_zone_summaries_per_injection(self, *args, **kwargs):
            """
            Enables/disables calculation of the escaped mass per injection. Note that for unsteady particle tracking, if you want to report the mass of escaped particles per injection, this text command must be enabled before any particles are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_zone_summaries_per_injection").execute(*args, **kwargs)
        def summary(self, *args, **kwargs):
            """
            Prints the current settings for physical models, boundary conditions, material properties, and solution parameters.
            """
            return PyMenu(self.service, "/report/summary").execute(*args, **kwargs)
        def write_histogram(self, *args, **kwargs):
            """
            Write a histogram of a scalar quantity to a file.
            """
            return PyMenu(self.service, "/report/write_histogram").execute(*args, **kwargs)
        def dpm_sample(self, *args, **kwargs):
            """
            Samples trajectories at boundaries and lines/planes.
            """
            return PyMenu(self.service, "/report/dpm_sample").execute(*args, **kwargs)
        def projected_surface_area(self, *args, **kwargs):
            """
            Computes the area of the projection of selected surfaces along the  ,  , or   axis.
            """
            return PyMenu(self.service, "/report/projected_surface_area").execute(*args, **kwargs)
        def volume_integrals(self, *args, **kwargs):
            """
            Enters the volume integral menu.
            """
            return PyMenu(self.service, "/report/volume_integrals").execute(*args, **kwargs)
        def species_mass_flow(self, *args, **kwargs):
            """
            Prints list of species mass flow rate at inlets and outlets. This reports the mass flow rates of all species (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/species_mass_flow").execute(*args, **kwargs)
        def path_line_summary(self, *args, **kwargs):
            """
            Prints pathline summary report.
            """
            return PyMenu(self.service, "/report/path_line_summary").execute(*args, **kwargs)

        class forces(TUIMenu):
            """
            Enters the forces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def wall_moments(self, *args, **kwargs):
                """
                Computes the moments about the specified moment center for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_moments").execute(*args, **kwargs)
            def wall_forces(self, *args, **kwargs):
                """
                Computes the forces along the specified force vector for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_forces").execute(*args, **kwargs)
            def pressure_center(self, *args, **kwargs):
                """
                Prints the center of pressure on wall zones.
                """
                return PyMenu(self.service, "/report/forces/pressure_center").execute(*args, **kwargs)

        class dpm_histogram(TUIMenu):
            """
            Enters the DPM histogram menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                self.setup_reduction = self.__class__.setup_reduction(path + ["setup_reduction"], service)
                super().__init__(path, service)
            def compute_sample(self, *args, **kwargs):
                """
                Computes the minimum/maximum of a sample variable.
                """
                return PyMenu(self.service, "/report/dpm_histogram/compute_sample").execute(*args, **kwargs)
            def read_sample(self, *args, **kwargs):
                """
                Reads a sample file and adds it to the sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/read_sample").execute(*args, **kwargs)
            def plot_sample(self, *args, **kwargs):
                """
                Plots a histogram of a loaded sample.
                """
                return PyMenu(self.service, "/report/dpm_histogram/plot_sample").execute(*args, **kwargs)
            def pick_sample_to_reduce(self, *args, **kwargs):
                """
                Select a sample to be reduced.
                """
                return PyMenu(self.service, "/report/dpm_histogram/pick_sample_to_reduce").execute(*args, **kwargs)
            def reduce_picked_sample(self, *args, **kwargs):
                """
                Reduce a sample as specified by the data reduction parameters. This command is available only after you selected the sample using the pick-sample-to-reduce text command.
                """
                return PyMenu(self.service, "/report/dpm_histogram/reduce_picked_sample").execute(*args, **kwargs)
            def list_samples(self, *args, **kwargs):
                """
                Shows all samples in a loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/list_samples").execute(*args, **kwargs)
            def delete_sample(self, *args, **kwargs):
                """
                Deletes a sample from the loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/delete_sample").execute(*args, **kwargs)
            def write_sample(self, *args, **kwargs):
                """
                Write a histogram of a loaded sample into a file.
                """
                return PyMenu(self.service, "/report/dpm_histogram/write_sample").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the settings menu for the histogram.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def weighting(self, *args, **kwargs):
                    """
                    Uses weighting with additional variables when sorting data into samples.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/weighting").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Enables/disables the use of logarithmic scaling on the abscissa of the histogram.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/logarithmic").execute(*args, **kwargs)
                def histogram_mode(self, *args, **kwargs):
                    """
                    Uses bars for the histogram plot or xy-style.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/histogram_mode").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Specifies the maximum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/maximum").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Specifies the number of bins.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/number_of_bins").execute(*args, **kwargs)
                def cumulation_curve(self, *args, **kwargs):
                    """
                    Computes a cumulative curve for the sampling variable or correlation variable when correlation? is specified.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/cumulation_curve").execute(*args, **kwargs)
                def percentage(self, *args, **kwargs):
                    """
                    Uses percentages of bins to be computed.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/percentage").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Specifies the minimum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/minimum").execute(*args, **kwargs)
                def diameter_statistics(self, *args, **kwargs):
                    """
                    Computes the Rosin Rammler parameters, Sauter, and other mean diameters.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/diameter_statistics").execute(*args, **kwargs)
                def variable_power_3(self, *args, **kwargs):
                    """
                    Use the cubic of the cumulation variable during computation of the cumulative curve.
                    When the particle mass was not sampled, the diameter can be used instead.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/variable_power_3").execute(*args, **kwargs)
                def correlation(self, *args, **kwargs):
                    """
                    Computes the correlation of the sampling variable with another variable.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/correlation").execute(*args, **kwargs)
                def auto_range(self, *args, **kwargs):
                    """
                    Automatically computes the range of the sampling variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/auto_range").execute(*args, **kwargs)

            class setup_reduction(TUIMenu):
                """
                Set up the sample data reduction by specifying all relevant options and setting parameters as desired.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_settings(self, *args, **kwargs):
                    """
                    List all user inputs for the sample picked for data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/list_settings").execute(*args, **kwargs)
                def all_variables_number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for ALL variables in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/all_variables_number_of_bins").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/number_of_bins").execute(*args, **kwargs)
                def make_steady_from_unsteady_file(self, *args, **kwargs):
                    """
                    Specify whether the unsteady sample is to be reduced into a steady-state injection file.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/make_steady_from_unsteady_file").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Set the minimum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/minimum").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Switch on or off logarithmic scaling to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/logarithmic").execute(*args, **kwargs)
                def use_weighting(self, *args, **kwargs):
                    """
                    Specify whether to use any weighting in the averaging that is done in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/use_weighting").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Set the maximum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/maximum").execute(*args, **kwargs)
                def weighting_variable(self, *args, **kwargs):
                    """
                    Choose the weighting variable for the averaging in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/weighting_variable").execute(*args, **kwargs)
                def reset_min_and_max(self, *args, **kwargs):
                    """
                    Reset the min and max values of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/reset_min_and_max").execute(*args, **kwargs)

        class simulation_reports(TUIMenu):
            """
            Enter the simulation reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
                super().__init__(path, service)
            def export_simulation_report_as_html(self, *args, **kwargs):
                """
                Export the provided simulation report as HTML.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
            def write_report_names_to_file(self, *args, **kwargs):
                """
                Write the list of currently generated report names to a txt file.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
            def rename_simulation_report(self, *args, **kwargs):
                """
                Rename a report which has already been generated.
                """
                return PyMenu(self.service, "/report/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
            def write_simulation_report_template_file(self, *args, **kwargs):
                """
                Write a JSON template file with this case's Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
            def delete_simulation_report(self, *args, **kwargs):
                """
                Delete the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
            def view_simulation_report(self, *args, **kwargs):
                """
                View a simulation report that has already been generated. In batch mode this will print the report's URL.
                """
                return PyMenu(self.service, "/report/simulation_reports/view_simulation_report").execute(*args, **kwargs)
            def export_simulation_report_as_pdf(self, *args, **kwargs):
                """
                Export the provided simulation report as a PDF file.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
            def generate_simulation_report(self, *args, **kwargs):
                """
                Generate a new simulation report or regenerate an existing simulation report with the provided name.
                """
                return PyMenu(self.service, "/report/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
            def read_simulation_report_template_file(self, *args, **kwargs):
                """
                Read a JSON template file with existing Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
            def reset_report_to_defaults(self, *args, **kwargs):
                """
                Reset all report settings to default for the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
            def list_simulation_reports(self, *args, **kwargs):
                """
                List all report names.
                """
                return PyMenu(self.service, "/report/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
            def duplicate_simulation_report(self, *args, **kwargs):
                """
                Duplicate a report and all of its settings to a new report.
                """
                return PyMenu(self.service, "/report/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)

            class parametric_study(TUIMenu):
                """
                Enter the parametric study menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def generate_parametric_report(self, *args, **kwargs):
                    """
                    Generate a parametric report for your study.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)
                def generate_design_point_report(self, *args, **kwargs):
                    """
                    Generate a simulation report for an updated design point.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)

        class system(TUIMenu):
            """
            Enters the system menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def time_stats(self, *args, **kwargs):
                """
                Timer information. This is used to report CPU timings for user and kernel processes and detailed solver timings.
                """
                return PyMenu(self.service, "/report/system/time_stats").execute(*args, **kwargs)
            def proc_stats(self, *args, **kwargs):
                """
                Prints ANSYS Fluent process information. This is used to report the memory usage of each of the ANSYS Fluent processes.
                """
                return PyMenu(self.service, "/report/system/proc_stats").execute(*args, **kwargs)
            def sys_stats(self, *args, **kwargs):
                """
                System information. This is used to report the CPU configuration of the machines where ANSYS Fluent processes have been spawned.
                """
                return PyMenu(self.service, "/report/system/sys_stats").execute(*args, **kwargs)
            def gpgpu_stats(self, *args, **kwargs):
                """
                Prints information about installed general purpose graphical processing units.
                """
                return PyMenu(self.service, "/report/system/gpgpu_stats").execute(*args, **kwargs)

        class population_balance(TUIMenu):
            """
            Population Balance menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def moments(self, *args, **kwargs):
                """
                Set moments for population balance.
                """
                return PyMenu(self.service, "/report/population_balance/moments").execute(*args, **kwargs)
            def number_density(self, *args, **kwargs):
                """
                Set number density functions.
                """
                return PyMenu(self.service, "/report/population_balance/number_density").execute(*args, **kwargs)

        class fluxes(TUIMenu):
            """
            Enters the fluxes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def heat_transfer_sensible(self, *args, **kwargs):
                """
                Prints the sensible heat transfer rate at the boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer_sensible").execute(*args, **kwargs)
            def mass_flow(self, *args, **kwargs):
                """
                Prints mass flow rate at inlets and outlets.
                """
                return PyMenu(self.service, "/report/fluxes/mass_flow").execute(*args, **kwargs)
            def pressure_work(self, *args, **kwargs):
                """
                Prints the pressure work rate at the boundaries. This text command is only available when the energy equation is enabled, the absolute velocity formulation is selected, and zone motion is enabled for a fluid cell zone.
                """
                return PyMenu(self.service, "/report/fluxes/pressure_work").execute(*args, **kwargs)
            def rad_heat_trans(self, *args, **kwargs):
                """
                Prints radiation heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/rad_heat_trans").execute(*args, **kwargs)
            def film_heat_transfer(self, *args, **kwargs):
                """
                Prints wall film heat transfer rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_heat_transfer").execute(*args, **kwargs)
            def film_mass_flow(self, *args, **kwargs):
                """
                Prints wall film mass flow rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_mass_flow").execute(*args, **kwargs)
            def viscous_work(self, *args, **kwargs):
                """
                Prints the viscous work rate at the boundaries. This text command is only available when the energy equation is enabled and the pressure-based solver is selected.
                """
                return PyMenu(self.service, "/report/fluxes/viscous_work").execute(*args, **kwargs)
            def heat_transfer(self, *args, **kwargs):
                """
                Prints heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer").execute(*args, **kwargs)

        class reference_values(TUIMenu):
            """
            Enters the reference value menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.compute = self.__class__.compute(path + ["compute"], service)
                super().__init__(path, service)
            def enthalpy(self, *args, **kwargs):
                """
                Sets reference enthalpy for enthalpy damping and normalization.
                """
                return PyMenu(self.service, "/report/reference_values/enthalpy").execute(*args, **kwargs)
            def temperature(self, *args, **kwargs):
                """
                Sets reference temperature for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/temperature").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists current reference values.
                """
                return PyMenu(self.service, "/report/reference_values/list").execute(*args, **kwargs)
            def zone(self, *args, **kwargs):
                """
                Sets reference zone.
                """
                return PyMenu(self.service, "/report/reference_values/zone").execute(*args, **kwargs)
            def length(self, *args, **kwargs):
                """
                Sets reference length for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/length").execute(*args, **kwargs)
            def depth(self, *args, **kwargs):
                """
                Sets reference depth for volume calculation.
                """
                return PyMenu(self.service, "/report/reference_values/depth").execute(*args, **kwargs)
            def area(self, *args, **kwargs):
                """
                Sets reference area for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/area").execute(*args, **kwargs)
            def density(self, *args, **kwargs):
                """
                Sets reference density for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/density").execute(*args, **kwargs)
            def velocity(self, *args, **kwargs):
                """
                Sets reference velocity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/velocity").execute(*args, **kwargs)
            def pressure(self, *args, **kwargs):
                """
                Sets reference pressure for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/pressure").execute(*args, **kwargs)
            def viscosity(self, *args, **kwargs):
                """
                Sets reference viscosity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/viscosity").execute(*args, **kwargs)
            def yplus(self, *args, **kwargs):
                """
                Sets reference yplus for calculation of Yplus Based Heat Transfer Coefficient.
                """
                return PyMenu(self.service, "/report/reference_values/yplus").execute(*args, **kwargs)

            class compute(TUIMenu):
                """
                Computes reference values from zone boundary conditions.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network_end").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/shadow").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/wall").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outflow").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/radiator").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/porous_jump").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/geometry").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/degassing").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/solid").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/periodic").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interface").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fluid").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/overset").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/axis").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fan").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/symmetry").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/intake_fan").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interior").execute(*args, **kwargs)

        class heat_exchanger(TUIMenu):
            """
            Enters the heat exchanger menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def inlet_temperature(self, *args, **kwargs):
                """
                Prints inlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/inlet_temperature").execute(*args, **kwargs)
            def outlet_temperature(self, *args, **kwargs):
                """
                Prints outlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/outlet_temperature").execute(*args, **kwargs)
            def computed_heat_rejection(self, *args, **kwargs):
                """
                Prints total heat rejection.
                """
                return PyMenu(self.service, "/report/heat_exchanger/computed_heat_rejection").execute(*args, **kwargs)
            def mass_flow_rate(self, *args, **kwargs):
                """
                Prints mass flow rate.
                """
                return PyMenu(self.service, "/report/heat_exchanger/mass_flow_rate").execute(*args, **kwargs)
            def specific_heat(self, *args, **kwargs):
                """
                Prints fluid’s specific heat.
                """
                return PyMenu(self.service, "/report/heat_exchanger/specific_heat").execute(*args, **kwargs)

        class icing(TUIMenu):
            """
            Icing reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def particles_droplets_collection_eff(self, *args, **kwargs):
                """
                Print Droplets Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_droplets_collection_eff").execute(*args, **kwargs)
            def icing_energy_of_conduction(self, *args, **kwargs):
                """
                Print Energy of Conduction.
                """
                return PyMenu(self.service, "/report/icing/icing_energy_of_conduction").execute(*args, **kwargs)
            def particles_crystals_collection_eff(self, *args, **kwargs):
                """
                Print Crystals Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_crystals_collection_eff").execute(*args, **kwargs)
            def energy_of_water_impinged(self, *args, **kwargs):
                """
                Print Energy of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/energy_of_water_impinged").execute(*args, **kwargs)
            def energy_of_ice_formation(self, *args, **kwargs):
                """
                Print Energy of Ice Formation.
                """
                return PyMenu(self.service, "/report/icing/energy_of_ice_formation").execute(*args, **kwargs)
            def mass_of_ice(self, *args, **kwargs):
                """
                Print Mass of Ice Accretion.
                """
                return PyMenu(self.service, "/report/icing/mass_of_ice").execute(*args, **kwargs)
            def mass_of_water_impinged(self, *args, **kwargs):
                """
                Print Mass of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/mass_of_water_impinged").execute(*args, **kwargs)

        class modified_setting(TUIMenu):
            """
            Enter the modified settings menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def modified_setting(self, *args, **kwargs):
                """
                Specify which areas of setup will be checked for non-default settings for generating the Modified Settings Summary table. The table is displayed tabbed with the graphics window.
                """
                return PyMenu(self.service, "/report/modified_setting/modified_setting").execute(*args, **kwargs)
            def write_user_setting(self, *args, **kwargs):
                """
                Write the contents of the Modified Settings Summary table to a file.
                """
                return PyMenu(self.service, "/report/modified_setting/write_user_setting").execute(*args, **kwargs)

    class display(TUIMenu):
        """
        Enter the display menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.define = self.__class__.define(path + ["define"], service)
            self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
            self.update_scene = self.__class__.update_scene(path + ["update_scene"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.views = self.__class__.views(path + ["views"], service)
            self.inverse_dft = self.__class__.inverse_dft(path + ["inverse_dft"], service)
            self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
            self.display_states = self.__class__.display_states(path + ["display_states"], service)
            self.flamelet_data = self.__class__.flamelet_data(path + ["flamelet_data"], service)
            self.pdf_data = self.__class__.pdf_data(path + ["pdf_data"], service)
            self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
            self.view_sync = self.__class__.view_sync(path + ["view_sync"], service)
            self.surface = self.__class__.surface(path + ["surface"], service)
            self.objects = self.__class__.objects(path + ["objects"], service)
            super().__init__(path, service)
        def annotate(self, *args, **kwargs):
            """
            Add a text annotation string to the active graphics window.
            """
            return PyMenu(self.service, "/display/annotate").execute(*args, **kwargs)
        def mesh_partition_boundary(self, *args, **kwargs):
            """
            Displays mesh partition boundaries.
            """
            return PyMenu(self.service, "/display/mesh_partition_boundary").execute(*args, **kwargs)
        def clear_annotations(self, *args, **kwargs):
            """
            Removes all annotations and attachment lines from the active graphics window.
            """
            return PyMenu(self.service, "/display/clear_annotations").execute(*args, **kwargs)
        def re_render(self, *args, **kwargs):
            """
            Re-renders the last contour, profile, or vector plot with updated surfaces, meshed, lights, colormap, rendering options, and so on, without recalculating the contour data.
            """
            return PyMenu(self.service, "/display/re_render").execute(*args, **kwargs)
        def vector(self, *args, **kwargs):
            """
            Displays vectors of a space vector variable.
            """
            return PyMenu(self.service, "/display/vector").execute(*args, **kwargs)
        def save_picture(self, *args, **kwargs):
            """
            Generate a "hardcopy" of the active window.
            """
            return PyMenu(self.service, "/display/save_picture").execute(*args, **kwargs)
        def surface_cells(self, *args, **kwargs):
            """
            Draws the cells on the specified surfaces. You can include a wildcard (\*) within the surface names.
            """
            return PyMenu(self.service, "/display/surface_cells").execute(*args, **kwargs)
        def hsf_file(self, *args, **kwargs):
            """
            Loads an HSF file for viewing.
            """
            return PyMenu(self.service, "/display/hsf_file").execute(*args, **kwargs)
        def open_window(self, *args, **kwargs):
            """
            Opens a graphics window.
            """
            return PyMenu(self.service, "/display/open_window").execute(*args, **kwargs)
        def switch_to_post_processing_volume(self, *args, **kwargs):
            """
            Switch to post processing volume.
            """
            return PyMenu(self.service, "/display/switch_to_post_processing_volume").execute(*args, **kwargs)
        def profile(self, *args, **kwargs):
            """
            Displays profiles of a flow variable.
            """
            return PyMenu(self.service, "/display/profile").execute(*args, **kwargs)
        def set_list_tree_separator(self, *args, **kwargs):
            """
            Set the separator character for list tree.
            """
            return PyMenu(self.service, "/display/set_list_tree_separator").execute(*args, **kwargs)
        def velocity_vector(self, *args, **kwargs):
            """
            Prompts for a scalar field by which to color the vectors, the minimum and maximum values, and the scale factor, and then draws the velocity vectors.
            """
            return PyMenu(self.service, "/display/velocity_vector").execute(*args, **kwargs)
        def switch_to_primary_volume(self, *args, **kwargs):
            """
            Switch to primary volume.
            """
            return PyMenu(self.service, "/display/switch_to_primary_volume").execute(*args, **kwargs)
        def contour(self, *args, **kwargs):
            """
            Prompts for a scalar field and minimum and maximum values, and then displays a contour plot.
            """
            return PyMenu(self.service, "/display/contour").execute(*args, **kwargs)
        def re_scale(self, *args, **kwargs):
            """
            Re-renders the last contour, profile, or vector plot with updated scale, surfaces, meshes, lights, colormap, rendering options, and so on, but without recalculating the field data.
            """
            return PyMenu(self.service, "/display/re_scale").execute(*args, **kwargs)
        def mesh_outline(self, *args, **kwargs):
            """
            Displays the mesh boundaries.
            """
            return PyMenu(self.service, "/display/mesh_outline").execute(*args, **kwargs)
        def reacting_channel_curves(self, *args, **kwargs):
            """
            Plots the reacting channel variables.
            """
            return PyMenu(self.service, "/display/reacting_channel_curves").execute(*args, **kwargs)
        def surface_mesh(self, *args, **kwargs):
            """
            Draws the mesh defined by the specified surfaces. You can include a wildcard (\*) within the surface names.
            """
            return PyMenu(self.service, "/display/surface_mesh").execute(*args, **kwargs)
        def update_layout(self, *args, **kwargs):
            """
            Update the fluent layout.
            """
            return PyMenu(self.service, "/display/update_layout").execute(*args, **kwargs)
        def set_window(self, *args, **kwargs):
            """
            Sets a "user" graphics window to be the active window. User windows are specified by number (1-50), with the associated number corresponding to the order, left-to-right, that the windows were created in.
            """
            return PyMenu(self.service, "/display/set_window").execute(*args, **kwargs)
        def mesh(self, *args, **kwargs):
            """
            Displays the entire mesh. For 3D, you will be asked to confirm that you really want to draw the entire mesh (not just themesh-outline).
            """
            return PyMenu(self.service, "/display/mesh").execute(*args, **kwargs)
        def graphics_window_layout(self, *args, **kwargs):
            """
            Arranges the graphics window layout.
            """
            return PyMenu(self.service, "/display/graphics_window_layout").execute(*args, **kwargs)
        def display_custom_vector(self, *args, **kwargs):
            """
            Displays custom vector.
            """
            return PyMenu(self.service, "/display/display_custom_vector").execute(*args, **kwargs)
        def zone_mesh(self, *args, **kwargs):
            """
            Draws the mesh defined by specified face zones. Zone names can be indicated using wildcards (\*).
            """
            return PyMenu(self.service, "/display/zone_mesh").execute(*args, **kwargs)
        def add_custom_vector(self, *args, **kwargs):
            """
            Adds new custom vector definition.
            """
            return PyMenu(self.service, "/display/add_custom_vector").execute(*args, **kwargs)
        def multigrid_coarsening(self, *args, **kwargs):
            """
            Displays a coarse mesh level from the last multigrid coarsening.
            """
            return PyMenu(self.service, "/display/multigrid_coarsening").execute(*args, **kwargs)
        def close_window(self, *args, **kwargs):
            """
            Close a "user" graphics window. User windows are specified by number (1-50), with the associated number corresponding to the order, left-to-right, that the windows were created in.
            """
            return PyMenu(self.service, "/display/close_window").execute(*args, **kwargs)
        def close_window_by_name(self, *args, **kwargs):
            """
            Close a reserved graphics window (windows used for residuals, report plots, and animation definitions).
            """
            return PyMenu(self.service, "/display/close_window_by_name").execute(*args, **kwargs)
        def set_window_by_name(self, *args, **kwargs):
            """
            Sets the specified graphics window as active. The graphics windows specified using this command are "reserved" windows, that is, residual monitors, report plots, and animation definitions. The name will match the name you provided when creating the object (report plots and animation definitions).
            """
            return PyMenu(self.service, "/display/set_window_by_name").execute(*args, **kwargs)

        class define(TUIMenu):
            """
            Enter Display define menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.material = self.__class__.material(path + ["material"], service)
                super().__init__(path, service)

            class material(TUIMenu):
                """
                Add, Edit, Remove materials in case file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit material.
                    """
                    return PyMenu(self.service, "/display/define/material/edit").execute(*args, **kwargs)
                def new(self, *args, **kwargs):
                    """
                    Create new material.
                    """
                    return PyMenu(self.service, "/display/define/material/new").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy to new material.
                    """
                    return PyMenu(self.service, "/display/define/material/copy").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Remove  material.
                    """
                    return PyMenu(self.service, "/display/define/material/delete").execute(*args, **kwargs)

        class embedded_windows(TUIMenu):
            """
            Enter the embedded window menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def close(self, *args, **kwargs):
                """
                Close an embedded window.
                """
                return PyMenu(self.service, "/display/embedded_windows/close").execute(*args, **kwargs)
            def move_out_all(self, *args, **kwargs):
                """
                Move all the embedded windows out of the specified parent window.
                """
                return PyMenu(self.service, "/display/embedded_windows/move_out_all").execute(*args, **kwargs)
            def move_out(self, *args, **kwargs):
                """
                Move an embedded window out of the parent window, returning the embedded window to a non-embedded state.
                """
                return PyMenu(self.service, "/display/embedded_windows/move_out").execute(*args, **kwargs)
            def close_all(self, *args, **kwargs):
                """
                Close all the embedded windows within the specified parent window.
                """
                return PyMenu(self.service, "/display/embedded_windows/close_all").execute(*args, **kwargs)
            def embed_in(self, *args, **kwargs):
                """
                Specify a window to embed and a parent window to receive the embedded window.
                """
                return PyMenu(self.service, "/display/embedded_windows/embed_in").execute(*args, **kwargs)

        class update_scene(TUIMenu):
            """
            Enter the scene options menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display(self, *args, **kwargs):
                """
                Display selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/display").execute(*args, **kwargs)
            def select_geometry(self, *args, **kwargs):
                """
                Select geometry to be updated.
                """
                return PyMenu(self.service, "/display/update_scene/select_geometry").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/delete").execute(*args, **kwargs)
            def pathline(self, *args, **kwargs):
                """
                Change pathline attributes.
                """
                return PyMenu(self.service, "/display/update_scene/pathline").execute(*args, **kwargs)
            def time(self, *args, **kwargs):
                """
                Change time-step value.
                """
                return PyMenu(self.service, "/display/update_scene/time").execute(*args, **kwargs)
            def draw_frame(self, *args, **kwargs):
                """
                Enable/disable drawing of the bounding frame.
                """
                return PyMenu(self.service, "/display/update_scene/draw_frame").execute(*args, **kwargs)
            def transform(self, *args, **kwargs):
                """
                Apply transformation matrix on selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/transform").execute(*args, **kwargs)
            def overlays(self, *args, **kwargs):
                """
                Enable/disable the overlays option.
                """
                return PyMenu(self.service, "/display/update_scene/overlays").execute(*args, **kwargs)
            def set_frame(self, *args, **kwargs):
                """
                Change frame options.
                """
                return PyMenu(self.service, "/display/update_scene/set_frame").execute(*args, **kwargs)
            def iso_sweep(self, *args, **kwargs):
                """
                Change iso-sweep values.
                """
                return PyMenu(self.service, "/display/update_scene/iso_sweep").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enter the set menu to set display parameters.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.velocity_vectors = self.__class__.velocity_vectors(path + ["velocity_vectors"], service)
                self.lights = self.__class__.lights(path + ["lights"], service)
                self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                self.contours = self.__class__.contours(path + ["contours"], service)
                self.windows = self.__class__.windows(path + ["windows"], service)
                self.titles = self.__class__.titles(path + ["titles"], service)
                self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                self.colors = self.__class__.colors(path + ["colors"], service)
                self.picture = self.__class__.picture(path + ["picture"], service)
                super().__init__(path, service)
            def filled_mesh(self, *args, **kwargs):
                """
                Determines whether the meshes are drawn as wireframe or solid.
                """
                return PyMenu(self.service, "/display/set/filled_mesh").execute(*args, **kwargs)
            def mirror_zones(self, *args, **kwargs):
                """
                Sets the zones about which the domain is mirrored (symmetry planes).
                """
                return PyMenu(self.service, "/display/set/mirror_zones").execute(*args, **kwargs)
            def mesh_zones(self, *args, **kwargs):
                """
                Sets zone IDs to be drawn as meshes.
                """
                return PyMenu(self.service, "/display/set/mesh_zones").execute(*args, **kwargs)
            def render_mesh(self, *args, **kwargs):
                """
                Enables/disables rendering the mesh on top of contours, vectors, and so on.
                """
                return PyMenu(self.service, "/display/set/render_mesh").execute(*args, **kwargs)
            def n_stream_func(self, *args, **kwargs):
                """
                Sets number of iterations used in computing stream function.
                """
                return PyMenu(self.service, "/display/set/n_stream_func").execute(*args, **kwargs)
            def marker_symbol(self, *args, **kwargs):
                """
                Sets the type of markers used to represent points.
                """
                return PyMenu(self.service, "/display/set/marker_symbol").execute(*args, **kwargs)
            def zero_angle_dir(self, *args, **kwargs):
                """
                Sets the vector having zero angular coordinates.
                """
                return PyMenu(self.service, "/display/set/zero_angle_dir").execute(*args, **kwargs)
            def element_shrink(self, *args, **kwargs):
                """
                Sets shrinkage of both faces and cells. A value of zero indicates no shrinkage, while a value of one will shrink each face or cell to a point.
                """
                return PyMenu(self.service, "/display/set/element_shrink").execute(*args, **kwargs)
            def reset_graphics(self, *args, **kwargs):
                """
                Reset the graphics system.
                """
                return PyMenu(self.service, "/display/set/reset_graphics").execute(*args, **kwargs)
            def duplicate_node_display(self, *args, **kwargs):
                """
                Set flag to remove duplicate nodes in mesh display.
                """
                return PyMenu(self.service, "/display/set/duplicate_node_display").execute(*args, **kwargs)
            def overlays(self, *args, **kwargs):
                """
                Enable/disable overlays.
                """
                return PyMenu(self.service, "/display/set/overlays").execute(*args, **kwargs)
            def marker_size(self, *args, **kwargs):
                """
                Sets the size of markers used to represent points.
                """
                return PyMenu(self.service, "/display/set/marker_size").execute(*args, **kwargs)
            def line_weight(self, *args, **kwargs):
                """
                Set the line-weight factor for the window.
                """
                return PyMenu(self.service, "/display/set/line_weight").execute(*args, **kwargs)
            def mesh_display_configuration(self, *args, **kwargs):
                """
                Changes the default mesh display. If set tomeshing, it draws the mesh on edges and faces of the outline surfaces, colored by their zone ID with lighting enabled. If set tosolution, it draws the mesh on edges and faces of the outline surfaces, colored by their zone type with lighting enabled. If set to post-processing, it draws the object outline with lighting disabled. If set toclassic, it draws the mesh on all edges of the outline surfaces.  This only applies for 3D cases.
                """
                return PyMenu(self.service, "/display/set/mesh_display_configuration").execute(*args, **kwargs)
            def color_map(self, *args, **kwargs):
                """
                Enters the color map menu, which contains names of predefined and user-defined (in the Colormap Editor panel) colormaps that can be selected. It prompts you for the name of the colormap to be used.
                """
                return PyMenu(self.service, "/display/set/color_map").execute(*args, **kwargs)
            def mesh_partitions(self, *args, **kwargs):
                """
                Enables/disables option to draw mesh partition boundaries.
                """
                return PyMenu(self.service, "/display/set/mesh_partitions").execute(*args, **kwargs)
            def proximity_zones(self, *args, **kwargs):
                """
                Sets zones to be used for boundary cell distance and boundary proximity.
                """
                return PyMenu(self.service, "/display/set/proximity_zones").execute(*args, **kwargs)
            def nodewt_based_interp(self, *args, **kwargs):
                """
                Disables/enables the use of node weights for node-based gradients in postprocessing.
                """
                return PyMenu(self.service, "/display/set/nodewt_based_interp").execute(*args, **kwargs)
            def periodic_instancing(self, *args, **kwargs):
                """
                Sets the number of periodic repetitions.
                """
                return PyMenu(self.service, "/display/set/periodic_instancing").execute(*args, **kwargs)
            def mesh_surfaces(self, *args, **kwargs):
                """
                Sets surface IDs to be drawn as meshes. You can include a wildcard  (\*) within the surface names.
                """
                return PyMenu(self.service, "/display/set/mesh_surfaces").execute(*args, **kwargs)
            def mesh_level(self, *args, **kwargs):
                """
                Sets coarse mesh level to be drawn.
                """
                return PyMenu(self.service, "/display/set/mesh_level").execute(*args, **kwargs)

            class velocity_vectors(TUIMenu):
                """
                Enters the menu to set parameters for display of velocity vectors.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def constant_length(self, *args, **kwargs):
                    """
                    Sets the option to draw velocity vectors of constant length. This shows only the direction of the velocity vectors.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/constant_length").execute(*args, **kwargs)
                def node_values(self, *args, **kwargs):
                    """
                    Enables/disables the plotting of node values. Cell values will be plotted if "no".
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/node_values").execute(*args, **kwargs)
                def component_x(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_x").execute(*args, **kwargs)
                def relative(self, *args, **kwargs):
                    """
                    Toggles the display of relative velocity vectors.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/relative").execute(*args, **kwargs)
                def color(self, *args, **kwargs):
                    """
                    Sets the color of all velocity vectors to the color specified. The color scale is ignored. This is useful when overlaying a vector plot over a contour plot.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/color").execute(*args, **kwargs)
                def component_z(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_z").execute(*args, **kwargs)
                def render_mesh(self, *args, **kwargs):
                    """
                    Enables/disables rendering the mesh on top of contours, vectors, and so on.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/render_mesh").execute(*args, **kwargs)
                def log_scale(self, *args, **kwargs):
                    """
                    Toggles whether color scale is logarithmic or linear.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/log_scale").execute(*args, **kwargs)
                def color_levels(self, *args, **kwargs):
                    """
                    Sets the number of colors used from the colormap.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/color_levels").execute(*args, **kwargs)
                def in_plane(self, *args, **kwargs):
                    """
                    Toggles the display of velocity vector components in the plane of the surface selected for display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/in_plane").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Specifies the vector style that will be used when the vectors are displayed. You can choose from:3d arrow,3d arrowhead, cone,filled-arrow, arrow,harpoon, or headless.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/style").execute(*args, **kwargs)
                def surfaces(self, *args, **kwargs):
                    """
                    Sets surfaces on which vectors are drawn. You can include a wildcard (\*) within the surface names.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/surfaces").execute(*args, **kwargs)
                def component_y(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_y").execute(*args, **kwargs)
                def scale_head(self, *args, **kwargs):
                    """
                    Sets the value by which the vector head will be scaled.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/scale_head").execute(*args, **kwargs)
                def auto_scale(self, *args, **kwargs):
                    """
                    Auto-scales all vectors so that vector overlap is minimal.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/auto_scale").execute(*args, **kwargs)
                def global_range(self, *args, **kwargs):
                    """
                    Turns global range for vectors on/off.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/global_range").execute(*args, **kwargs)
                def scale(self, *args, **kwargs):
                    """
                    Sets the value by which the vector length will be scaled.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/scale").execute(*args, **kwargs)

            class lights(TUIMenu):
                """
                Enter the lights menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def lighting_interpolation(self, *args, **kwargs):
                    """
                    Set lighting interpolation method.
                    """
                    return PyMenu(self.service, "/display/set/lights/lighting_interpolation").execute(*args, **kwargs)
                def set_ambient_color(self, *args, **kwargs):
                    """
                    Set the ambient light color for the scene.
                    """
                    return PyMenu(self.service, "/display/set/lights/set_ambient_color").execute(*args, **kwargs)
                def headlight_on(self, *args, **kwargs):
                    """
                    Turn the light that moves with the camera on or off.
                    """
                    return PyMenu(self.service, "/display/set/lights/headlight_on").execute(*args, **kwargs)
                def lights_on(self, *args, **kwargs):
                    """
                    Turn all active lighting on/off.
                    """
                    return PyMenu(self.service, "/display/set/lights/lights_on").execute(*args, **kwargs)
                def set_light(self, *args, **kwargs):
                    """
                    Add or modify a directional, colored light.
                    """
                    return PyMenu(self.service, "/display/set/lights/set_light").execute(*args, **kwargs)

            class path_lines(TUIMenu):
                """
                Sets parameters for display of pathlines.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def sphere_attrib(self, *args, **kwargs):
                    """
                    Specifies the size and number of slices to be used in drawing spheres.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/sphere_attrib").execute(*args, **kwargs)
                def line_width(self, *args, **kwargs):
                    """
                    Sets the width for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/line_width").execute(*args, **kwargs)
                def track_in_phase(self, *args, **kwargs):
                    """
                    Selects the phase in which particle pathlines will be computed (Multiphase Eulerian Model only).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/track_in_phase").execute(*args, **kwargs)
                def display_steps(self, *args, **kwargs):
                    """
                    Sets the display stepping for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/display_steps").execute(*args, **kwargs)
                def error_control(self, *args, **kwargs):
                    """
                    Sets error control during pathline computation.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/error_control").execute(*args, **kwargs)
                def maximum_steps(self, *args, **kwargs):
                    """
                    Sets the maximum number of steps to take for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/maximum_steps").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Selects the pathline style (line, point, ribbon, triangle, cylinder).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/style").execute(*args, **kwargs)
                def arrow_scale(self, *args, **kwargs):
                    """
                    Sets the scale factor for arrows drawn on pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/arrow_scale").execute(*args, **kwargs)
                def maximum_error(self, *args, **kwargs):
                    """
                    Sets the maximum error allowed while computing the pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/maximum_error").execute(*args, **kwargs)
                def relative_pathlines(self, *args, **kwargs):
                    """
                    Enables/disables the tracking of pathlines in a relative coordinate system.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/relative_pathlines").execute(*args, **kwargs)
                def arrow_space(self, *args, **kwargs):
                    """
                    Sets the spacing factor for arrows drawn on pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/arrow_space").execute(*args, **kwargs)
                def step_size(self, *args, **kwargs):
                    """
                    Sets the step length between particle positions for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/step_size").execute(*args, **kwargs)
                def radius(self, *args, **kwargs):
                    """
                    Sets the radius for pathline (ribbons/cylinder only) cross-section.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/radius").execute(*args, **kwargs)
                def marker_size(self, *args, **kwargs):
                    """
                    Sets the marker size for particle drawing.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/marker_size").execute(*args, **kwargs)
                def twist_factor(self, *args, **kwargs):
                    """
                    Sets the scale factor for twisting (ribbons only).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/twist_factor").execute(*args, **kwargs)
                def reverse(self, *args, **kwargs):
                    """
                    Sets direction of path tracking.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/reverse").execute(*args, **kwargs)

            class contours(TUIMenu):
                """
                Enters the contour options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def filled_contours(self, *args, **kwargs):
                    """
                    Turns the filled contours option on/off (deselects line-contours?).
                    """
                    return PyMenu(self.service, "/display/set/contours/filled_contours").execute(*args, **kwargs)
                def node_values(self, *args, **kwargs):
                    """
                    Sets the option to use scalar field at nodes when computing the contours.
                    """
                    return PyMenu(self.service, "/display/set/contours/node_values").execute(*args, **kwargs)
                def clip_to_range(self, *args, **kwargs):
                    """
                    Turns the clip to range option for filled contours on/off.
                    """
                    return PyMenu(self.service, "/display/set/contours/clip_to_range").execute(*args, **kwargs)
                def render_mesh(self, *args, **kwargs):
                    """
                    Determines whether or not to render the mesh on top of contours, vectors, and so on.
                    """
                    return PyMenu(self.service, "/display/set/contours/render_mesh").execute(*args, **kwargs)
                def line_contours(self, *args, **kwargs):
                    """
                    Turns the line contours option on/off (deselects filled-contours?).
                    """
                    return PyMenu(self.service, "/display/set/contours/line_contours").execute(*args, **kwargs)
                def surfaces(self, *args, **kwargs):
                    """
                    Sets the surfaces on which contours are drawn. You can include a wildcard (\*) within the surface names.
                    """
                    return PyMenu(self.service, "/display/set/contours/surfaces").execute(*args, **kwargs)
                def global_range(self, *args, **kwargs):
                    """
                    Turns the global range for contours on/off.
                    """
                    return PyMenu(self.service, "/display/set/contours/global_range").execute(*args, **kwargs)
                def n_contour(self, *args, **kwargs):
                    """
                    Sets the number of contour levels.
                    """
                    return PyMenu(self.service, "/display/set/contours/n_contour").execute(*args, **kwargs)
                def coloring(self, *args, **kwargs):
                    """
                    Specifies whether contours are displayed in bands or with smooth transitions. Note that you can only display smooth contours if node-values are enabled.
                    """
                    return PyMenu(self.service, "/display/set/contours/coloring").execute(*args, **kwargs)
                def auto_range(self, *args, **kwargs):
                    """
                    Enables/disables auto-computation of the contour range.
                    """
                    return PyMenu(self.service, "/display/set/contours/auto_range").execute(*args, **kwargs)
                def log_scale(self, *args, **kwargs):
                    """
                    Specifies a decimal or logarithmic color scale for contours.
                    """
                    return PyMenu(self.service, "/display/set/contours/log_scale").execute(*args, **kwargs)

            class windows(TUIMenu):
                """
                Enter the window options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    self.main = self.__class__.main(path + ["main"], service)
                    self.text = self.__class__.text(path + ["text"], service)
                    self.axes = self.__class__.axes(path + ["axes"], service)
                    self.scale = self.__class__.scale(path + ["scale"], service)
                    self.xy = self.__class__.xy(path + ["xy"], service)
                    super().__init__(path, service)
                def logo(self, *args, **kwargs):
                    """
                    Enable/disable visibility of the logo in graphics window.
                    """
                    return PyMenu(self.service, "/display/set/windows/logo").execute(*args, **kwargs)
                def aspect_ratio(self, *args, **kwargs):
                    """
                    Set the aspect ratio of the active window.
                    """
                    return PyMenu(self.service, "/display/set/windows/aspect_ratio").execute(*args, **kwargs)
                def ruler(self, *args, **kwargs):
                    """
                    Enable/disable ruler visibility.
                    """
                    return PyMenu(self.service, "/display/set/windows/ruler").execute(*args, **kwargs)
                def logo_color(self, *args, **kwargs):
                    """
                    Set logo color to white/black.
                    """
                    return PyMenu(self.service, "/display/set/windows/logo_color").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enter the video window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def color_filter(self, *args, **kwargs):
                        """
                        Set the color filter options for the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/color_filter").execute(*args, **kwargs)
                    def pixel_size(self, *args, **kwargs):
                        """
                        Set the window size in pixels.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/pixel_size").execute(*args, **kwargs)
                    def foreground(self, *args, **kwargs):
                        """
                        Set the foreground color in the video picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/foreground").execute(*args, **kwargs)
                    def on(self, *args, **kwargs):
                        """
                        Enable/disable video picture settings.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/on").execute(*args, **kwargs)
                    def background(self, *args, **kwargs):
                        """
                        Set the background color in the video picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/background").execute(*args, **kwargs)

                class main(TUIMenu):
                    """
                    Enter the main view window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        Set the top boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/top").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of borders around the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/border").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Set the left boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/left").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/right").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/bottom").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable visibility of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/visible").execute(*args, **kwargs)

                class text(TUIMenu):
                    """
                    Enter the text window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def clear(self, *args, **kwargs):
                        """
                        Enable/disable text window transparency.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/clear").execute(*args, **kwargs)
                    def company(self, *args, **kwargs):
                        """
                        Enable/disable the company name in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/company").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable text window transparency.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/visible").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of borders around the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/border").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/bottom").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Set the left boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/left").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/right").execute(*args, **kwargs)
                    def application(self, *args, **kwargs):
                        """
                        Enable/disable the application name in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/application").execute(*args, **kwargs)
                    def date(self, *args, **kwargs):
                        """
                        Enable/disable the date in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/date").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Set the top boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/top").execute(*args, **kwargs)

                class axes(TUIMenu):
                    """
                    Enter the axes window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def clear(self, *args, **kwargs):
                        """
                        Set the transparency of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/clear").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/bottom").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of a border around the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/border").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable axes visibility.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/visible").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/right").execute(*args, **kwargs)

                class scale(TUIMenu):
                    """
                    Enter the color scale window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/right").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of borders around the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/border").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Set the top boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/top").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set the number format of the color scale window (e.g. %0.2e).
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/format").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Set the left boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/left").execute(*args, **kwargs)
                    def margin(self, *args, **kwargs):
                        """
                        Set the margin of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/margin").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable visibility of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/visible").execute(*args, **kwargs)
                    def font_size(self, *args, **kwargs):
                        """
                        Set the font size of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/font_size").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/bottom").execute(*args, **kwargs)
                    def alignment(self, *args, **kwargs):
                        """
                        Set colormap to bottom/left/top/right.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/alignment").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Set the transparency of the scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/clear").execute(*args, **kwargs)

                class xy(TUIMenu):
                    """
                    Enter the X-Y plot window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def visible(self, *args, **kwargs):
                        """
                        Enable/disable X-Y plotter window visibility.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/visible").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Set the top boundary of the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/top").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Set the right boundary of the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/right").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Set the bottom boundary of the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/bottom").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Enable/disable drawing of a border around the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/border").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Set the left boundary of the X-Y plotter window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/left").execute(*args, **kwargs)

            class titles(TUIMenu):
                """
                Set problem title.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def right_bottom(self, *args, **kwargs):
                    """
                    Set the title text for right bottom in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_bottom").execute(*args, **kwargs)
                def right_middle(self, *args, **kwargs):
                    """
                    Set the title text for right middle in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_middle").execute(*args, **kwargs)
                def right_top(self, *args, **kwargs):
                    """
                    Set the title text for right top in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_top").execute(*args, **kwargs)
                def left_bottom(self, *args, **kwargs):
                    """
                    Set the title text for left bottom in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/left_bottom").execute(*args, **kwargs)
                def left_top(self, *args, **kwargs):
                    """
                    Set the title text for left top in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/left_top").execute(*args, **kwargs)

            class rendering_options(TUIMenu):
                """
                Enter the rendering options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def hidden_surfaces(self, *args, **kwargs):
                    """
                    Enable/disable hidden surface removal.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                def outer_face_cull(self, *args, **kwargs):
                    """
                    Enable/disable discarding outer faces during display.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/outer_face_cull").execute(*args, **kwargs)
                def double_buffering(self, *args, **kwargs):
                    """
                    Enable/disable double-buffering.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/double_buffering").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    Enable/Disable colormap.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/show_colormap").execute(*args, **kwargs)
                def color_map_alignment(self, *args, **kwargs):
                    """
                    Set the color bar alignment.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/color_map_alignment").execute(*args, **kwargs)
                def driver(self, *args, **kwargs):
                    """
                    Change the current graphics driver.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/driver").execute(*args, **kwargs)
                def hidden_surface_method(self, *args, **kwargs):
                    """
                    Specify the method to perform hidden line and hidden surface rendering.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                def set_rendering_options(self, *args, **kwargs):
                    """
                    Set the rendering options.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/set_rendering_options").execute(*args, **kwargs)
                def animation_option(self, *args, **kwargs):
                    """
                    Using Wireframe / All option during animation.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/animation_option").execute(*args, **kwargs)
                def help_text_color(self, *args, **kwargs):
                    """
                    Set the color of screen help text.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/help_text_color").execute(*args, **kwargs)
                def auto_spin(self, *args, **kwargs):
                    """
                    Enable/disable mouse view rotations to continue to spin the display after the button is released.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/auto_spin").execute(*args, **kwargs)
                def device_info(self, *args, **kwargs):
                    """
                    List information for the graphics device.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/device_info").execute(*args, **kwargs)
                def face_displacement(self, *args, **kwargs):
                    """
                    Set face displacement value in Z-buffer units along the Camera Z-axis.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/face_displacement").execute(*args, **kwargs)
                def surface_edge_visibility(self, *args, **kwargs):
                    """
                    Set edge visibility flags for surfaces.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/surface_edge_visibility").execute(*args, **kwargs)

            class particle_tracks(TUIMenu):
                """
                Enters the particle-tracks menu to set parameters for display of particle tracks.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.filter_settings = self.__class__.filter_settings(path + ["filter_settings"], service)
                    self.sphere_settings = self.__class__.sphere_settings(path + ["sphere_settings"], service)
                    self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                    super().__init__(path, service)
                def line_width(self, *args, **kwargs):
                    """
                    Sets the width for particle track.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/line_width").execute(*args, **kwargs)
                def report_variables(self, *args, **kwargs):
                    """
                    Sets the report variables.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_variables").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Determines whether particle tracks shall be displayed or only tracked.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/display").execute(*args, **kwargs)
                def report_type(self, *args, **kwargs):
                    """
                    Sets the report type for particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_type").execute(*args, **kwargs)
                def report_default_variables(self, *args, **kwargs):
                    """
                    Sets the report variables to default.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_default_variables").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Sets the display style for particle track (line/ribbon/cylinder/sphere).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/style").execute(*args, **kwargs)
                def radius(self, *args, **kwargs):
                    """
                    Sets the radius for particle track (ribbon/cylinder only) cross-section.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/radius").execute(*args, **kwargs)
                def arrow_scale(self, *args, **kwargs):
                    """
                    Sets the scale factor for arrows drawn on particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/arrow_scale").execute(*args, **kwargs)
                def track_single_particle_stream(self, *args, **kwargs):
                    """
                    Specifies the stream ID to be tracked.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/track_single_particle_stream").execute(*args, **kwargs)
                def sphere_attrib(self, *args, **kwargs):
                    """
                    Specifies the size and number of slices to be used in drawing spheres.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/sphere_attrib").execute(*args, **kwargs)
                def marker_size(self, *args, **kwargs):
                    """
                    Sets the size of markers used to represent particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/marker_size").execute(*args, **kwargs)
                def coarsen_factor(self, *args, **kwargs):
                    """
                    Sets the coarsening factor for particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/coarsen_factor").execute(*args, **kwargs)
                def twist_factor(self, *args, **kwargs):
                    """
                    Sets the scale factor for twisting (ribbons only).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/twist_factor").execute(*args, **kwargs)
                def history_filename(self, *args, **kwargs):
                    """
                    Specifies the name of the particle history file.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/history_filename").execute(*args, **kwargs)
                def particle_skip(self, *args, **kwargs):
                    """
                    Specifies how many particle tracks should be displayed.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/particle_skip").execute(*args, **kwargs)
                def report_to(self, *args, **kwargs):
                    """
                    Specifies the destination for the report (console, file, none).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_to").execute(*args, **kwargs)
                def arrow_space(self, *args, **kwargs):
                    """
                    Sets the spacing factor for arrows drawn on particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/arrow_space").execute(*args, **kwargs)

                class filter_settings(TUIMenu):
                    """
                    Set filter for particle display.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_filtering(self, *args, **kwargs):
                        """
                        Specifies whether particle display is filtered.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/enable_filtering").execute(*args, **kwargs)
                    def filter_variable(self, *args, **kwargs):
                        """
                        Selects a variable used for filtering of particles.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/filter_variable").execute(*args, **kwargs)
                    def inside(self, *args, **kwargs):
                        """
                        Specifies whether filter variable must be inside min/max to be displayed (else outside min/max).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/inside").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Specifies the upper bound for the filter variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/maximum").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Specifies the lower bound for the filter variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/minimum").execute(*args, **kwargs)

                class sphere_settings(TUIMenu):
                    """
                    Provide sphere specific input.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def scale_factor(self, *args, **kwargs):
                        """
                        Specifies a scale factor to enlarge/reduce the size of spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/scale_factor").execute(*args, **kwargs)
                    def vary_diameter(self, *args, **kwargs):
                        """
                        Specifies whether the spheres can vary with another variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/vary_diameter").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Sets the minimum value of the sphere to be displayed.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/minimum").execute(*args, **kwargs)
                    def smooth_parameter(self, *args, **kwargs):
                        """
                        Specifies number of slices to be used in drawing spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/smooth_parameter").execute(*args, **kwargs)
                    def size_variable(self, *args, **kwargs):
                        """
                        Selects a particle variable to size the spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/size_variable").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Sets the maximum value of the sphere to be displayed.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/maximum").execute(*args, **kwargs)
                    def diameter(self, *args, **kwargs):
                        """
                        Diameter of the spheres whenvary-diameter is disabled.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/diameter").execute(*args, **kwargs)
                    def auto_range(self, *args, **kwargs):
                        """
                        Specifies whether displayed spheres should include auto range of variable to size spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/auto_range").execute(*args, **kwargs)

                class vector_settings(TUIMenu):
                    """
                    Set vector specific input.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def style(self, *args, **kwargs):
                        """
                        Enables and sets the display style for particle vectors (none/vector/centered-vector/centered-cylinder).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/style").execute(*args, **kwargs)
                    def scale_factor(self, *args, **kwargs):
                        """
                        Specifies a scale factor to enlarge/reduce the length of vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/scale_factor").execute(*args, **kwargs)
                    def constant_color(self, *args, **kwargs):
                        """
                        Specifies a constant color for the vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/constant_color").execute(*args, **kwargs)
                    def length_to_head_ratio(self, *args, **kwargs):
                        """
                        Specifies ratio of length to head for vectors and length to diameter for cylinders.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/length_to_head_ratio").execute(*args, **kwargs)
                    def vector_variable(self, *args, **kwargs):
                        """
                        Selects a particle vector function to specify vector direction.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_variable").execute(*args, **kwargs)
                    def vector_length(self, *args, **kwargs):
                        """
                        Specifies the length of constant vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_length").execute(*args, **kwargs)
                    def vector_length_variable(self, *args, **kwargs):
                        """
                        Selects a particle variable to specify the length of vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_length_variable").execute(*args, **kwargs)
                    def length_variable(self, *args, **kwargs):
                        """
                        Specifies whether the displayed vectors have length varying with another variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/length_variable").execute(*args, **kwargs)
                    def color_variable(self, *args, **kwargs):
                        """
                        Specifies whether the vectors should be colored by variable specified in /display/particle-track/particle-track (if false use a constant color).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/color_variable").execute(*args, **kwargs)

            class colors(TUIMenu):
                """
                Enter the color options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.by_type = self.__class__.by_type(path + ["by_type"], service)
                    self.by_surface = self.__class__.by_surface(path + ["by_surface"], service)
                    super().__init__(path, service)
                def rans_les_interface_faces(self, *args, **kwargs):
                    """
                    Set the color of RANS/LES interface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/rans_les_interface_faces").execute(*args, **kwargs)
                def inlet_faces(self, *args, **kwargs):
                    """
                    Set the color of inlet faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/inlet_faces").execute(*args, **kwargs)
                def far_field_faces(self, *args, **kwargs):
                    """
                    Set the color of far field faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/far_field_faces").execute(*args, **kwargs)
                def interface_faces(self, *args, **kwargs):
                    """
                    Set the color of mesh Interfaces.
                    """
                    return PyMenu(self.service, "/display/set/colors/interface_faces").execute(*args, **kwargs)
                def background(self, *args, **kwargs):
                    """
                    Set the background (window) color.
                    """
                    return PyMenu(self.service, "/display/set/colors/background").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List available colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/list").execute(*args, **kwargs)
                def graphics_color_theme(self, *args, **kwargs):
                    """
                    Enter the graphics color theme menu.
                    """
                    return PyMenu(self.service, "/display/set/colors/graphics_color_theme").execute(*args, **kwargs)
                def color_by_type(self, *args, **kwargs):
                    """
                    Determine whether to color meshes by type or by surface (ID).
                    """
                    return PyMenu(self.service, "/display/set/colors/color_by_type").execute(*args, **kwargs)
                def free_surface_faces(self, *args, **kwargs):
                    """
                    Set the color of free-surface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/free_surface_faces").execute(*args, **kwargs)
                def periodic_faces(self, *args, **kwargs):
                    """
                    Set the color of periodic faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/periodic_faces").execute(*args, **kwargs)
                def user_color(self, *args, **kwargs):
                    """
                    Explicitly set color of display zone.
                    """
                    return PyMenu(self.service, "/display/set/colors/user_color").execute(*args, **kwargs)
                def overset_faces(self, *args, **kwargs):
                    """
                    Set the color of overset faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/overset_faces").execute(*args, **kwargs)
                def outlet_faces(self, *args, **kwargs):
                    """
                    Set the color of outlet faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/outlet_faces").execute(*args, **kwargs)
                def axis_faces(self, *args, **kwargs):
                    """
                    Set the color of axisymmetric faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/axis_faces").execute(*args, **kwargs)
                def interior_faces(self, *args, **kwargs):
                    """
                    Set the color of interior faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/interior_faces").execute(*args, **kwargs)
                def automatic_skip(self, *args, **kwargs):
                    """
                    Determine whether to skip labels in the colopmap scale automatically.
                    """
                    return PyMenu(self.service, "/display/set/colors/automatic_skip").execute(*args, **kwargs)
                def show_user_colors(self, *args, **kwargs):
                    """
                    List currently defined user colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/show_user_colors").execute(*args, **kwargs)
                def internal_faces(self, *args, **kwargs):
                    """
                    Set the color of internal interface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/internal_faces").execute(*args, **kwargs)
                def foreground(self, *args, **kwargs):
                    """
                    Set the foreground (text and window frame) color.
                    """
                    return PyMenu(self.service, "/display/set/colors/foreground").execute(*args, **kwargs)
                def symmetry_faces(self, *args, **kwargs):
                    """
                    Set the color of symmetric faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/symmetry_faces").execute(*args, **kwargs)
                def reset_colors(self, *args, **kwargs):
                    """
                    Reset individual mesh surface colors to the defaults.
                    """
                    return PyMenu(self.service, "/display/set/colors/reset_colors").execute(*args, **kwargs)
                def reset_user_colors(self, *args, **kwargs):
                    """
                    Reset all user colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/reset_user_colors").execute(*args, **kwargs)
                def wall_faces(self, *args, **kwargs):
                    """
                    Set the color of wall faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/wall_faces").execute(*args, **kwargs)
                def skip_label(self, *args, **kwargs):
                    """
                    Set the number of labels to be skipped in the colopmap scale.
                    """
                    return PyMenu(self.service, "/display/set/colors/skip_label").execute(*args, **kwargs)
                def traction_faces(self, *args, **kwargs):
                    """
                    Set the color of traction faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/traction_faces").execute(*args, **kwargs)
                def surface(self, *args, **kwargs):
                    """
                    Set the color of surfaces.
                    """
                    return PyMenu(self.service, "/display/set/colors/surface").execute(*args, **kwargs)

                class by_type(TUIMenu):
                    """
                    Enter the zone type color and material assignment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.type_name = self.__class__.type_name(path + ["type_name"], service)
                        super().__init__(path, service)
                    def reset(self, *args, **kwargs):
                        """
                        To reset colors and/or materials to the defaults.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_type/reset").execute(*args, **kwargs)
                    def only_list_case_boundaries(self, *args, **kwargs):
                        """
                        Only list the boundary types that are assigned in this case.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_type/only_list_case_boundaries").execute(*args, **kwargs)

                    class type_name(TUIMenu):
                        """
                        Select the boundary type to specify colors and/or materials.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def surface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/surface").execute(*args, **kwargs)
                        def outlet(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/outlet").execute(*args, **kwargs)
                        def interface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/interface").execute(*args, **kwargs)
                        def far_field(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/far_field").execute(*args, **kwargs)
                        def free_surface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/free_surface").execute(*args, **kwargs)
                        def traction(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/traction").execute(*args, **kwargs)
                        def internal(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/internal").execute(*args, **kwargs)
                        def rans_les_interface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/rans_les_interface").execute(*args, **kwargs)
                        def symmetry(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/symmetry").execute(*args, **kwargs)
                        def interior(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/interior").execute(*args, **kwargs)
                        def periodic(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/periodic").execute(*args, **kwargs)
                        def wall(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/wall").execute(*args, **kwargs)
                        def overset(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/overset").execute(*args, **kwargs)
                        def axis(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/axis").execute(*args, **kwargs)
                        def inlet(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/inlet").execute(*args, **kwargs)

                class by_surface(TUIMenu):
                    """
                    Enter the surface(s) color and material assignment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def reset(self, *args, **kwargs):
                        """
                        To reset colors and/or materials to the defaults.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/reset").execute(*args, **kwargs)
                    def surfaces(self, *args, **kwargs):
                        """
                        Select the surface(s) to specify colors and/or materials.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/surfaces").execute(*args, **kwargs)
                    def list_surfaces_by_material(self, *args, **kwargs):
                        """
                        To list the surfaces by its material.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/list_surfaces_by_material").execute(*args, **kwargs)
                    def list_surfaces_by_color(self, *args, **kwargs):
                        """
                        To list the surfaces by its color.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/list_surfaces_by_color").execute(*args, **kwargs)

            class picture(TUIMenu):
                """
                Enter the hardcopy/save-picture options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                    self.driver = self.__class__.driver(path + ["driver"], service)
                    super().__init__(path, service)
                def use_window_resolution(self, *args, **kwargs):
                    """
                    Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                    """
                    return PyMenu(self.service, "/display/set/picture/use_window_resolution").execute(*args, **kwargs)
                def preview(self, *args, **kwargs):
                    """
                    Display a preview image of a hardcopy.
                    """
                    return PyMenu(self.service, "/display/set/picture/preview").execute(*args, **kwargs)
                def invert_background(self, *args, **kwargs):
                    """
                    Use a white background when the picture is saved.
                    """
                    return PyMenu(self.service, "/display/set/picture/invert_background").execute(*args, **kwargs)
                def landscape(self, *args, **kwargs):
                    """
                    Plot hardcopies in landscape or portrait orientation.
                    """
                    return PyMenu(self.service, "/display/set/picture/landscape").execute(*args, **kwargs)
                def y_resolution(self, *args, **kwargs):
                    """
                    Set the height of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/display/set/picture/y_resolution").execute(*args, **kwargs)
                def jpeg_hardcopy_quality(self, *args, **kwargs):
                    """
                    To set jpeg hardcopy quality.
                    """
                    return PyMenu(self.service, "/display/set/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)
                def x_resolution(self, *args, **kwargs):
                    """
                    Set the width of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/display/set/picture/x_resolution").execute(*args, **kwargs)
                def dpi(self, *args, **kwargs):
                    """
                    Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                    """
                    return PyMenu(self.service, "/display/set/picture/dpi").execute(*args, **kwargs)
                def set_standard_resolution(self, *args, **kwargs):
                    """
                    Select from pre-defined resolution list.
                    """
                    return PyMenu(self.service, "/display/set/picture/set_standard_resolution").execute(*args, **kwargs)

                class color_mode(TUIMenu):
                    """
                    Enter the hardcopy color mode menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mono_chrome(self, *args, **kwargs):
                        """
                        Convert color to monochrome (black and white) for hardcopy.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/mono_chrome").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        Display the current hardcopy color mode.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/list").execute(*args, **kwargs)
                    def color(self, *args, **kwargs):
                        """
                        Plot hardcopies in color.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/color").execute(*args, **kwargs)
                    def gray_scale(self, *args, **kwargs):
                        """
                        Convert color to grayscale for hardcopy.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/gray_scale").execute(*args, **kwargs)

                class driver(TUIMenu):
                    """
                    Enter the set hardcopy driver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.post_format = self.__class__.post_format(path + ["post_format"], service)
                        super().__init__(path, service)
                    def eps(self, *args, **kwargs):
                        """
                        Produce encapsulated PostScript (EPS) output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/eps").execute(*args, **kwargs)
                    def ppm(self, *args, **kwargs):
                        """
                        Produce PPM output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/ppm").execute(*args, **kwargs)
                    def post_script(self, *args, **kwargs):
                        """
                        Produce PostScript output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/post_script").execute(*args, **kwargs)
                    def png(self, *args, **kwargs):
                        """
                        Use PNG output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/png").execute(*args, **kwargs)
                    def glb(self, *args, **kwargs):
                        """
                        Use GLB output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/glb").execute(*args, **kwargs)
                    def options(self, *args, **kwargs):
                        """
                        Set the hardcopy options. Available options are:
                        "no gamma correction", disables gamma correction of colors,
                        "physical size = (width,height)", where width and height
                        are the actual measurements of the printable area of the page
                        in centimeters.
                        "subscreen = (left,right,bottom,top)", where left,right,
                        bottom, and top are numbers in [-1,1] describing a subwindow on
                        the page in which to place the hardcopy.
                        The options may be combined by separating them with commas.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/options").execute(*args, **kwargs)
                    def dump_window(self, *args, **kwargs):
                        """
                        Set the command used to dump the graphics window to a file.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/dump_window").execute(*args, **kwargs)
                    def tiff(self, *args, **kwargs):
                        """
                        Use TIFF output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/tiff").execute(*args, **kwargs)
                    def hsf(self, *args, **kwargs):
                        """
                        Use HSF output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/hsf").execute(*args, **kwargs)
                    def jpeg(self, *args, **kwargs):
                        """
                        Produce JPEG output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/jpeg").execute(*args, **kwargs)
                    def avz(self, *args, **kwargs):
                        """
                        Use AVZ output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/avz").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the current hardcopy driver.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/list").execute(*args, **kwargs)
                    def vrml(self, *args, **kwargs):
                        """
                        Use VRML output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/vrml").execute(*args, **kwargs)

                    class post_format(TUIMenu):
                        """
                        Enter the PostScript driver format menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vector(self, *args, **kwargs):
                            """
                            Use vector format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/vector").execute(*args, **kwargs)
                        def raster(self, *args, **kwargs):
                            """
                            Use the original raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/raster").execute(*args, **kwargs)
                        def fast_raster(self, *args, **kwargs):
                            """
                            Use the new raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/fast_raster").execute(*args, **kwargs)
                        def rle_raster(self, *args, **kwargs):
                            """
                            Use the run-length encoded raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/rle_raster").execute(*args, **kwargs)

        class views(TUIMenu):
            """
            Enter the view manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.camera = self.__class__.camera(path + ["camera"], service)
                super().__init__(path, service)
            def save_view(self, *args, **kwargs):
                """
                Save the current view to the view list.
                """
                return PyMenu(self.service, "/display/views/save_view").execute(*args, **kwargs)
            def last_view(self, *args, **kwargs):
                """
                Return to the camera position before the last manipulation.
                """
                return PyMenu(self.service, "/display/views/last_view").execute(*args, **kwargs)
            def restore_view(self, *args, **kwargs):
                """
                Use a saved view.
                """
                return PyMenu(self.service, "/display/views/restore_view").execute(*args, **kwargs)
            def next_view(self, *args, **kwargs):
                """
                Return to the camera position after the current position in the stack.
                """
                return PyMenu(self.service, "/display/views/next_view").execute(*args, **kwargs)
            def delete_view(self, *args, **kwargs):
                """
                Remove a view from the list.
                """
                return PyMenu(self.service, "/display/views/delete_view").execute(*args, **kwargs)
            def default_view(self, *args, **kwargs):
                """
                Reset view to front and center.
                """
                return PyMenu(self.service, "/display/views/default_view").execute(*args, **kwargs)
            def write_views(self, *args, **kwargs):
                """
                Write selected views to a view file.
                """
                return PyMenu(self.service, "/display/views/write_views").execute(*args, **kwargs)
            def read_views(self, *args, **kwargs):
                """
                Read views from a view file.
                """
                return PyMenu(self.service, "/display/views/read_views").execute(*args, **kwargs)
            def auto_scale(self, *args, **kwargs):
                """
                Scale and center the current scene.
                """
                return PyMenu(self.service, "/display/views/auto_scale").execute(*args, **kwargs)
            def list_views(self, *args, **kwargs):
                """
                List predefined and saved views.
                """
                return PyMenu(self.service, "/display/views/list_views").execute(*args, **kwargs)

            class camera(TUIMenu):
                """
                Enter the camera menu to modify the current viewing parameters.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def roll_camera(self, *args, **kwargs):
                    """
                    Adjust the camera up-vector.
                    """
                    return PyMenu(self.service, "/display/views/camera/roll_camera").execute(*args, **kwargs)
                def position(self, *args, **kwargs):
                    """
                    Set the camera position.
                    """
                    return PyMenu(self.service, "/display/views/camera/position").execute(*args, **kwargs)
                def dolly_camera(self, *args, **kwargs):
                    """
                    Adjust the camera position and target.
                    """
                    return PyMenu(self.service, "/display/views/camera/dolly_camera").execute(*args, **kwargs)
                def pan_camera(self, *args, **kwargs):
                    """
                    Adjust the camera target without modifying the position.
                    """
                    return PyMenu(self.service, "/display/views/camera/pan_camera").execute(*args, **kwargs)
                def projection(self, *args, **kwargs):
                    """
                    Set the camera projection type.
                    """
                    return PyMenu(self.service, "/display/views/camera/projection").execute(*args, **kwargs)
                def zoom_camera(self, *args, **kwargs):
                    """
                    Adjust the camera field of view.
                    """
                    return PyMenu(self.service, "/display/views/camera/zoom_camera").execute(*args, **kwargs)
                def orbit_camera(self, *args, **kwargs):
                    """
                    Adjust the camera position without modifying the target.
                    """
                    return PyMenu(self.service, "/display/views/camera/orbit_camera").execute(*args, **kwargs)
                def up_vector(self, *args, **kwargs):
                    """
                    Set the camera up-vector.
                    """
                    return PyMenu(self.service, "/display/views/camera/up_vector").execute(*args, **kwargs)
                def target(self, *args, **kwargs):
                    """
                    Set the point to be the center of the camera view.
                    """
                    return PyMenu(self.service, "/display/views/camera/target").execute(*args, **kwargs)
                def field(self, *args, **kwargs):
                    """
                    Set the field of view (width and height).
                    """
                    return PyMenu(self.service, "/display/views/camera/field").execute(*args, **kwargs)

        class inverse_dft(TUIMenu):
            """
            Reconstruct DFT signal.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def reconstruct(self, *args, **kwargs):
                """
                Make inverse DFT recontruction.
                """
                return PyMenu(self.service, "/display/inverse_dft/reconstruct").execute(*args, **kwargs)
            def set(self, *args, **kwargs):
                """
                Set reconstruction parameters.
                """
                return PyMenu(self.service, "/display/inverse_dft/set").execute(*args, **kwargs)

        class particle_tracks(TUIMenu):
            """
            Enters the particle tracks menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_write_xy_plot(self, *args, **kwargs):
                """
                Plots or writes an XY plot of particle tracks.
                """
                return PyMenu(self.service, "/display/particle_tracks/plot_write_xy_plot").execute(*args, **kwargs)
            def particle_tracks(self, *args, **kwargs):
                """
                Calculates and displays particle tracks from defined injections.
                """
                return PyMenu(self.service, "/display/particle_tracks/particle_tracks").execute(*args, **kwargs)

        class display_states(TUIMenu):
            """
            Enter the display state manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                Print the names of the available display states to the console.
                """
                return PyMenu(self.service, "/display/display_states/list").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a new display state.
                """
                return PyMenu(self.service, "/display/display_states/create").execute(*args, **kwargs)
            def apply(self, *args, **kwargs):
                """
                Apply a display state to the active window.
                """
                return PyMenu(self.service, "/display/display_states/apply").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write display states to a file.
                """
                return PyMenu(self.service, "/display/display_states/write").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a display state.
                """
                return PyMenu(self.service, "/display/display_states/delete").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Create a new display state with settings copied from an existing display state.
                """
                return PyMenu(self.service, "/display/display_states/copy").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                Read display states from a file.
                """
                return PyMenu(self.service, "/display/display_states/read").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit a particular display state setting.
                """
                return PyMenu(self.service, "/display/display_states/edit").execute(*args, **kwargs)
            def use_active(self, *args, **kwargs):
                """
                Update an existing display state's settings to match those of the active graphics window.
                """
                return PyMenu(self.service, "/display/display_states/use_active").execute(*args, **kwargs)

        class flamelet_data(TUIMenu):
            """
            Displays flamelet data.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_to_file(self, *args, **kwargs):
                """
                Enables/disables writing the 1D-slice to file instead of plot.
                """
                return PyMenu(self.service, "/display/flamelet_data/write_to_file").execute(*args, **kwargs)
            def plot_1d_slice(self, *args, **kwargs):
                """
                Enables/disables plot of the 1D-slice.
                """
                return PyMenu(self.service, "/display/flamelet_data/plot_1d_slice").execute(*args, **kwargs)
            def draw_number_box(self, *args, **kwargs):
                """
                Enables/disables display of the numbers box.
                """
                return PyMenu(self.service, "/display/flamelet_data/draw_number_box").execute(*args, **kwargs)
            def carpet_plot(self, *args, **kwargs):
                """
                Enables/disables display of carpet plot of a property.
                """
                return PyMenu(self.service, "/display/flamelet_data/carpet_plot").execute(*args, **kwargs)

        class pdf_data(TUIMenu):
            """
            Enters the PDF data menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_to_file(self, *args, **kwargs):
                """
                Enables/disables writing the 1D-slice to file instead of plot.
                """
                return PyMenu(self.service, "/display/pdf_data/write_to_file").execute(*args, **kwargs)
            def carpet_plot(self, *args, **kwargs):
                """
                Enables/disables the display of a carpet plot of a property.
                """
                return PyMenu(self.service, "/display/pdf_data/carpet_plot").execute(*args, **kwargs)
            def plot_1d_slice(self, *args, **kwargs):
                """
                Enables/disables a plot of the 1D-slice.
                """
                return PyMenu(self.service, "/display/pdf_data/plot_1d_slice").execute(*args, **kwargs)
            def draw_number_box(self, *args, **kwargs):
                """
                Enables/disables the display of the numbers box.
                """
                return PyMenu(self.service, "/display/pdf_data/draw_number_box").execute(*args, **kwargs)

        class path_lines(TUIMenu):
            """
            Enters the pathlines menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_write_xy_plot(self, *args, **kwargs):
                """
                Plots or writes an XY plot of pathlines.
                """
                return PyMenu(self.service, "/display/path_lines/plot_write_xy_plot").execute(*args, **kwargs)
            def write_to_files(self, *args, **kwargs):
                """
                Writes pathlines to a file.
                """
                return PyMenu(self.service, "/display/path_lines/write_to_files").execute(*args, **kwargs)
            def path_lines(self, *args, **kwargs):
                """
                Displays pathlines from a surface.
                """
                return PyMenu(self.service, "/display/path_lines/path_lines").execute(*args, **kwargs)

        class view_sync(TUIMenu):
            """
            Synchronize window views.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                Print window ids of open windows.
                """
                return PyMenu(self.service, "/display/view_sync/list").execute(*args, **kwargs)
            def remove_all(self, *args, **kwargs):
                """
                Unsynchronize all windows.
                """
                return PyMenu(self.service, "/display/view_sync/remove_all").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add list of window ids for synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/add").execute(*args, **kwargs)
            def remove(self, *args, **kwargs):
                """
                Remove list of window ids from synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/remove").execute(*args, **kwargs)
            def add_all(self, *args, **kwargs):
                """
                Synchronize all windows.
                """
                return PyMenu(self.service, "/display/view_sync/add_all").execute(*args, **kwargs)
            def stop(self, *args, **kwargs):
                """
                Stop view synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/stop").execute(*args, **kwargs)
            def start(self, *args, **kwargs):
                """
                Start view synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/start").execute(*args, **kwargs)

        class surface(TUIMenu):
            """
            Enters the data surface-manipulation menu. For a description of the items in this menu, see surface/.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
                self.query = self.__class__.query(path + ["query"], service)
                super().__init__(path, service)
            def rake_surface(self, *args, **kwargs):
                """
                Define a "rake" surface by specifying the end points.
                """
                return PyMenu(self.service, "/display/surface/rake_surface").execute(*args, **kwargs)
            def iso_clip(self, *args, **kwargs):
                """
                Clip a data surface (surface, curve, or point) between two iso-values.
                """
                return PyMenu(self.service, "/display/surface/iso_clip").execute(*args, **kwargs)
            def mouse_line(self, *args, **kwargs):
                """
                Define a line surface using the mouse to select two points.
                """
                return PyMenu(self.service, "/display/surface/mouse_line").execute(*args, **kwargs)
            def create_imprint_surface(self, *args, **kwargs):
                """
                Imprint surface.
                """
                return PyMenu(self.service, "/display/surface/create_imprint_surface").execute(*args, **kwargs)
            def multiple_zone_surfaces(self, *args, **kwargs):
                """
                Create multiple data surfaces at a time.
                """
                return PyMenu(self.service, "/display/surface/multiple_zone_surfaces").execute(*args, **kwargs)
            def ellipsoid_slice(self, *args, **kwargs):
                """
                Extract a ellipsoid slice.
                """
                return PyMenu(self.service, "/display/surface/ellipsoid_slice").execute(*args, **kwargs)
            def surface_cells(self, *args, **kwargs):
                """
                Extract all cells intersected by a data surface.
                """
                return PyMenu(self.service, "/display/surface/surface_cells").execute(*args, **kwargs)
            def point_array(self, *args, **kwargs):
                """
                Extract a rectangular array of data points.
                """
                return PyMenu(self.service, "/display/surface/point_array").execute(*args, **kwargs)
            def plane_slice(self, *args, **kwargs):
                """
                Extract a planar slice.
                """
                return PyMenu(self.service, "/display/surface/plane_slice").execute(*args, **kwargs)
            def line_surface(self, *args, **kwargs):
                """
                Define a "line" surface by specifying the two endpoint coordinates.
                """
                return PyMenu(self.service, "/display/surface/line_surface").execute(*args, **kwargs)
            def group_surfaces(self, *args, **kwargs):
                """
                Group a set of surfaces.
                """
                return PyMenu(self.service, "/display/surface/group_surfaces").execute(*args, **kwargs)
            def mouse_plane(self, *args, **kwargs):
                """
                Define a plane surface using the mouse to select three points.
                """
                return PyMenu(self.service, "/display/surface/mouse_plane").execute(*args, **kwargs)
            def partition_surface(self, *args, **kwargs):
                """
                Define a data surface on mesh faces on the partition boundary.
                """
                return PyMenu(self.service, "/display/surface/partition_surface").execute(*args, **kwargs)
            def rename_surface(self, *args, **kwargs):
                """
                Rename a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/rename_surface").execute(*args, **kwargs)
            def zone_surface(self, *args, **kwargs):
                """
                Define a data surface on a mesh zone.
                """
                return PyMenu(self.service, "/display/surface/zone_surface").execute(*args, **kwargs)
            def plane(self, *args, **kwargs):
                """
                Create a plane given 3 points bounded by the domain.
                """
                return PyMenu(self.service, "/display/surface/plane").execute(*args, **kwargs)
            def ungroup_surface(self, *args, **kwargs):
                """
                Ungroup the surface(if grouped).
                """
                return PyMenu(self.service, "/display/surface/ungroup_surface").execute(*args, **kwargs)
            def multiple_plane_surfaces(self, *args, **kwargs):
                """
                Create multiple plane surfaces at specified spacing.
                """
                return PyMenu(self.service, "/display/surface/multiple_plane_surfaces").execute(*args, **kwargs)
            def transform_surface(self, *args, **kwargs):
                """
                Transform surface.
                """
                return PyMenu(self.service, "/display/surface/transform_surface").execute(*args, **kwargs)
            def plane_surface(self, *args, **kwargs):
                """
                Create a plane from a coordinate plane, point and normal, or three points.
                """
                return PyMenu(self.service, "/display/surface/plane_surface").execute(*args, **kwargs)
            def sphere_slice(self, *args, **kwargs):
                """
                Extract a spherical slice.
                """
                return PyMenu(self.service, "/display/surface/sphere_slice").execute(*args, **kwargs)
            def multiple_iso_surfaces(self, *args, **kwargs):
                """
                Create multiple iso-surfaces from the data field at specified spacing.
                """
                return PyMenu(self.service, "/display/surface/multiple_iso_surfaces").execute(*args, **kwargs)
            def structural_point_surface(self, *args, **kwargs):
                """
                Define a "structural point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/display/surface/structural_point_surface").execute(*args, **kwargs)
            def expression_volume(self, *args, **kwargs):
                """
                Create volume with boolean expression.
                """
                return PyMenu(self.service, "/display/surface/expression_volume").execute(*args, **kwargs)
            def edit_surface(self, *args, **kwargs):
                """
                Edit a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/edit_surface").execute(*args, **kwargs)
            def iso_surface(self, *args, **kwargs):
                """
                Extract an iso-surface (surface, curve, or point) from the curent data field.
                """
                return PyMenu(self.service, "/display/surface/iso_surface").execute(*args, **kwargs)
            def cone_slice(self, *args, **kwargs):
                """
                Extract a cone slice.
                """
                return PyMenu(self.service, "/display/surface/cone_slice").execute(*args, **kwargs)
            def quadric_slice(self, *args, **kwargs):
                """
                Extract a quadric slice.
                """
                return PyMenu(self.service, "/display/surface/quadric_slice").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List the number of facets in the defined surfaces.
                """
                return PyMenu(self.service, "/display/surface/list_surfaces").execute(*args, **kwargs)
            def mouse_rake(self, *args, **kwargs):
                """
                Define a "rake" surface using the mouse to select the end points.
                """
                return PyMenu(self.service, "/display/surface/mouse_rake").execute(*args, **kwargs)
            def reset_zone_surfaces(self, *args, **kwargs):
                """
                Reset case surface list.
                """
                return PyMenu(self.service, "/display/surface/reset_zone_surfaces").execute(*args, **kwargs)
            def delete_surface(self, *args, **kwargs):
                """
                Remove a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/delete_surface").execute(*args, **kwargs)
            def circle_slice(self, *args, **kwargs):
                """
                Extract a circular slice.
                """
                return PyMenu(self.service, "/display/surface/circle_slice").execute(*args, **kwargs)
            def line_slice(self, *args, **kwargs):
                """
                Extract a linear slice.
                """
                return PyMenu(self.service, "/display/surface/line_slice").execute(*args, **kwargs)
            def point_surface(self, *args, **kwargs):
                """
                Define a "point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/display/surface/point_surface").execute(*args, **kwargs)

            class post_processing_volume(TUIMenu):
                """
                Enter post-processing volume menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create_from_file(self, *args, **kwargs):
                    """
                    Read post-processing mesh from file.
                    """
                    return PyMenu(self.service, "/display/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)
                def create_octree(self, *args, **kwargs):
                    """
                    Create post-processing octree mesh based on current case.
                    """
                    return PyMenu(self.service, "/display/surface/post_processing_volume/create_octree").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter surface query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_surfaces(self, *args, **kwargs):
                    """
                    List surfaces.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_surfaces").execute(*args, **kwargs)
                def named_surface_list(self, *args, **kwargs):
                    """
                    Create named list of surfaces.
                    """
                    return PyMenu(self.service, "/display/surface/query/named_surface_list").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_queries").execute(*args, **kwargs)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/display/surface/query/delete_query").execute(*args, **kwargs)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of surface type.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_named_selection").execute(*args, **kwargs)

        class objects(TUIMenu):
            """
            Enter to add, edit, delete or display graphics objects.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def add_to_graphics(self, *args, **kwargs):
                """
                Add graphics object to existing graphics.
                """
                return PyMenu(self.service, "/display/objects/add_to_graphics").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit graphics object.
                """
                return PyMenu(self.service, "/display/objects/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete graphics object.
                """
                return PyMenu(self.service, "/display/objects/delete").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create new graphics object.
                """
                return PyMenu(self.service, "/display/objects/create").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display graphics object.
                """
                return PyMenu(self.service, "/display/objects/display").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy graphics object.
                """
                return PyMenu(self.service, "/display/objects/copy").execute(*args, **kwargs)

    class simulation_reports(TUIMenu):
        """
        Enter the simulation reports menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
            super().__init__(path, service)
        def write_report_names_to_file(self, *args, **kwargs):
            """
            Write the list of currently generated report names to a txt file.
            """
            return PyMenu(self.service, "/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
        def delete_simulation_report(self, *args, **kwargs):
            """
            Delete the provided simulation report.
            """
            return PyMenu(self.service, "/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
        def reset_report_to_defaults(self, *args, **kwargs):
            """
            Reset all report settings to default for the provided simulation report.
            """
            return PyMenu(self.service, "/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
        def duplicate_simulation_report(self, *args, **kwargs):
            """
            Duplicate a report and all of its settings to a new report.
            """
            return PyMenu(self.service, "/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
        def read_simulation_report_template_file(self, *args, **kwargs):
            """
            Read a JSON template file with existing Simulation Report settings.
            """
            return PyMenu(self.service, "/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)
        def view_simulation_report(self, *args, **kwargs):
            """
            View a simulation report that has already been generated. In batch mode this will print the report's URL.
            """
            return PyMenu(self.service, "/simulation_reports/view_simulation_report").execute(*args, **kwargs)
        def rename_simulation_report(self, *args, **kwargs):
            """
            Rename a report which has already been generated.
            """
            return PyMenu(self.service, "/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
        def generate_simulation_report(self, *args, **kwargs):
            """
            Generate a new simulation report or regenerate an existing simulation report with the provided name.
            """
            return PyMenu(self.service, "/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
        def export_simulation_report_as_pdf(self, *args, **kwargs):
            """
            Export the provided simulation report as a PDF file.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
        def list_simulation_reports(self, *args, **kwargs):
            """
            List all report names.
            """
            return PyMenu(self.service, "/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
        def write_simulation_report_template_file(self, *args, **kwargs):
            """
            Write a JSON template file with this case's Simulation Report settings.
            """
            return PyMenu(self.service, "/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
        def export_simulation_report_as_html(self, *args, **kwargs):
            """
            Export the provided simulation report as HTML.
            """
            return PyMenu(self.service, "/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)

        class parametric_study(TUIMenu):
            """
            Enter the parametric study menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def generate_parametric_report(self, *args, **kwargs):
                """
                Generate a parametric report for your study.
                """
                return PyMenu(self.service, "/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)
            def generate_design_point_report(self, *args, **kwargs):
                """
                Generate a simulation report for an updated design point.
                """
                return PyMenu(self.service, "/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)

    class setup(TUIMenu):
        """
        Enter setup menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            super().__init__(path, service)

        class mesh_interfaces(TUIMenu):
            """
            Enter the mesh-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mapped_interface_options = self.__class__.mapped_interface_options(path + ["mapped_interface_options"], service)
                self.non_conformal_interface_numerics = self.__class__.non_conformal_interface_numerics(path + ["non_conformal_interface_numerics"], service)
                self.auto_options = self.__class__.auto_options(path + ["auto_options"], service)
                super().__init__(path, service)
            def create(self, *args, **kwargs):
                """
                Create a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/create").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List all mesh-interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/list").execute(*args, **kwargs)
            def verbosity(self, *args, **kwargs):
                """
                Set mesh interface verbosity.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/verbosity").execute(*args, **kwargs)
            def remove_left_handed_interface_faces(self, *args, **kwargs):
                """
                Remove left-handed faces during mesh interface creation.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/remove_left_handed_interface_faces").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display specified mesh interface zone.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/display").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/delete").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all mesh interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/delete_all").execute(*args, **kwargs)
            def auto_pairing(self, *args, **kwargs):
                """
                Automatically pair and create mesh interfaces for some or all interface zones.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/auto_pairing").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_phaselag_from_periodic").execute(*args, **kwargs)
            def enable_si_with_nodes(self, *args, **kwargs):
                """
                Enable sliding interfaces with nodes.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enable_si_with_nodes").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def one_to_one_pairing(self, *args, **kwargs):
                """
                Use the default one-to-one interface creation method?.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/one_to_one_pairing").execute(*args, **kwargs)
            def non_overlapping_zone_name(self, *args, **kwargs):
                """
                Get non-overlapping zone name from the associated interface zone.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/non_overlapping_zone_name").execute(*args, **kwargs)
            def enforce_continuity_after_bc(self, *args, **kwargs):
                """
                Across the interface, enforces continuity over boundary condition.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enforce_continuity_after_bc").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Make interface zones periodic.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_periodic").execute(*args, **kwargs)
            def enforce_coupled_wall_between_solids(self, *args, **kwargs):
                """
                Create coupled wall interface between solids.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enforce_coupled_wall_between_solids").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Create a general turbo interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/turbo_create").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/edit").execute(*args, **kwargs)
            def enable_visualization_of_interfaces(self, *args, **kwargs):
                """
                Display facets on mesh interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enable_visualization_of_interfaces").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improve mesh interface quality.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/improve_quality").execute(*args, **kwargs)
            def transfer_motion_across_interfaces(self, *args, **kwargs):
                """
                Transfer motion from one side of the interface to the other when only one side undergoes user-defined or system-coupling motion.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/transfer_motion_across_interfaces").execute(*args, **kwargs)

            class mapped_interface_options(TUIMenu):
                """
                Enter the mapped-interface-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def tolerance(self, *args, **kwargs):
                    """
                    Specification of mapped interface tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/tolerance").execute(*args, **kwargs)
                def convert_to_mapped_interface(self, *args, **kwargs):
                    """
                    Convert non-conformal mesh interface to mapped mesh interfaces.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/convert_to_mapped_interface").execute(*args, **kwargs)
                def solution_controls(self, *args, **kwargs):
                    """
                    Specification of mapped frequency and under-relaxation factor for mapped interfaces.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/solution_controls").execute(*args, **kwargs)

            class non_conformal_interface_numerics(TUIMenu):
                """
                Setting non-conformal numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def change_numerics(self, *args, **kwargs):
                    """
                    Enable modified non-conformal interface numerics.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/non_conformal_interface_numerics/change_numerics").execute(*args, **kwargs)

            class auto_options(TUIMenu):
                """
                Enter auto-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_one_to_one_pairing_tolerance(self, *args, **kwargs):
                    """
                    Enable/disable one-to-one auto pairing tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/set_one_to_one_pairing_tolerance").execute(*args, **kwargs)
                def naming_option(self, *args, **kwargs):
                    """
                    Specify whether or not to include an informative suffix to the mesh interface name.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/naming_option").execute(*args, **kwargs)
                def pairing_between_interface_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones only.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/pairing_between_interface_zones_only").execute(*args, **kwargs)
                def pairing_between_different_cell_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones from different cell zones only.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/pairing_between_different_cell_zones_only").execute(*args, **kwargs)
                def keep_empty_interface(self, *args, **kwargs):
                    """
                    Keep empty interfaces during one-to-one mesh interface creation.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/keep_empty_interface").execute(*args, **kwargs)
                def set_default_name_prefix(self, *args, **kwargs):
                    """
                    Specification of auto pairing default name prefix.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/set_default_name_prefix").execute(*args, **kwargs)
                def proximity_tolerance(self, *args, **kwargs):
                    """
                    Specification of auto pairing tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/proximity_tolerance").execute(*args, **kwargs)

        class turbo_model(TUIMenu):
            """
            Turbo features menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.blade_flutter_harmonics = self.__class__.blade_flutter_harmonics(path + ["blade_flutter_harmonics"], service)
                self.general_turbo_interface_settings = self.__class__.general_turbo_interface_settings(path + ["general_turbo_interface_settings"], service)
                self.turbo_topology = self.__class__.turbo_topology(path + ["turbo_topology"], service)
                super().__init__(path, service)
            def isentropic_efficiency(self, *args, **kwargs):
                """
                Compute isentropic efficiency using general property functions for enthalpy.
                """
                return PyMenu(self.service, "/setup/turbo_model/isentropic_efficiency").execute(*args, **kwargs)
            def enable_turbo_model(self, *args, **kwargs):
                """
                Enable/disable turbo model menu.
                """
                return PyMenu(self.service, "/setup/turbo_model/enable_turbo_model").execute(*args, **kwargs)
            def graphics_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/graphics_extra_settings").execute(*args, **kwargs)
            def list_turbomachine_description(self, *args, **kwargs):
                """
                List turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_turbomachine_description").execute(*args, **kwargs)
            def create_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_graphics_spectral_content").execute(*args, **kwargs)
            def blade_flutter_row(self, *args, **kwargs):
                """
                Define the periodic displacement row.
                """
                return PyMenu(self.service, "/setup/turbo_model/blade_flutter_row").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/setup/turbo_model/make_phaselag_from_periodic").execute(*args, **kwargs)
            def delete_turbomachine_description(self, *args, **kwargs):
                """
                Delete turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_turbomachine_description").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Create a general turbo interface.
                """
                return PyMenu(self.service, "/setup/turbo_model/turbo_create").execute(*args, **kwargs)
            def append_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/append_phaselag_spectral_content").execute(*args, **kwargs)
            def list_graphics_spectral_content(self, *args, **kwargs):
                """
                List post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_graphics_spectral_content").execute(*args, **kwargs)
            def list_phaselag_state(self, *args, **kwargs):
                """
                List all phaselag related case settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_phaselag_state").execute(*args, **kwargs)
            def separate_nonoverlapping_interface_boundary(self, *args, **kwargs):
                """
                Split a general turbo interface non-overlapping zone.
                """
                return PyMenu(self.service, "/setup/turbo_model/separate_nonoverlapping_interface_boundary").execute(*args, **kwargs)
            def delete_phaselag_spectral_content(self, *args, **kwargs):
                """
                Delete phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_phaselag_spectral_content").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/setup/turbo_model/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def create_turbomachine_description(self, *args, **kwargs):
                """
                Define turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_turbomachine_description").execute(*args, **kwargs)
            def create_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_phaselag_spectral_content").execute(*args, **kwargs)
            def phaselag_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/phaselag_extra_settings").execute(*args, **kwargs)
            def delete_graphics_spectral_content(self, *args, **kwargs):
                """
                Delete post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_graphics_spectral_content").execute(*args, **kwargs)
            def append_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/append_graphics_spectral_content").execute(*args, **kwargs)

            class blade_flutter_harmonics(TUIMenu):
                """
                Enter the blade flutter harmonics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_aerodamping_vs_nodal_diameter(self, *args, **kwargs):
                    """
                    Reads report definition file and Writes influence coefficient aerodynamic damping values vs nodal diameter.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/write_aerodamping_vs_nodal_diameter").execute(*args, **kwargs)
                def enable_harmonic_exports(self, *args, **kwargs):
                    """
                    Calculates/Deletes flutter harmonic export data.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/enable_harmonic_exports").execute(*args, **kwargs)
                def write_harmonic_exports(self, *args, **kwargs):
                    """
                    Writes harmonic export data.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/write_harmonic_exports").execute(*args, **kwargs)

            class general_turbo_interface_settings(TUIMenu):
                """
                Set General Turbo Interface options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def expert(self, *args, **kwargs):
                    """
                    Set the expert parameters for turbo interfaces.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/expert").execute(*args, **kwargs)
                def mixing_plane_model_settings(self, *args, **kwargs):
                    """
                    Set the mixing plane model settings.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings").execute(*args, **kwargs)

            class turbo_topology(TUIMenu):
                """
                Define turbo topology.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def define_topology(self, *args, **kwargs):
                    """
                    Define a turbo topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/define_topology").execute(*args, **kwargs)
                def mesh_method(self, *args, **kwargs):
                    """
                    Set turbo structured mesh generation method.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/mesh_method").execute(*args, **kwargs)
                def search_method(self, *args, **kwargs):
                    """
                    Set search method for a topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/search_method").execute(*args, **kwargs)
                def projection_method(self, *args, **kwargs):
                    """
                    Set 2D projection method.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/projection_method").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete a turbo topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/delete").execute(*args, **kwargs)

        class overset_interfaces(TUIMenu):
            """
            Enter the overset-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.cut_control = self.__class__.cut_control(path + ["cut_control"], service)
                self.adapt = self.__class__.adapt(path + ["adapt"], service)
                self.options = self.__class__.options(path + ["options"], service)
                super().__init__(path, service)
            def grid_priorities(self, *args, **kwargs):
                """
                Edit grid priorities for an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/grid_priorities").execute(*args, **kwargs)
            def write_dci(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to a text file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_dci").execute(*args, **kwargs)
            def write_dci_to_case(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to case file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_dci_to_case").execute(*args, **kwargs)
            def mark_cells(self, *args, **kwargs):
                """
                Mark overset interface related cell types.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/mark_cells").execute(*args, **kwargs)
            def intersect_all(self, *args, **kwargs):
                """
                Intersect all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/intersect_all").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/delete").execute(*args, **kwargs)
            def mark_cell_change(self, *args, **kwargs):
                """
                Mark overset interface related cell type change.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/mark_cell_change").execute(*args, **kwargs)
            def debug_hole_cut(self, *args, **kwargs):
                """
                Debugging tool for overset hole cutting.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/debug_hole_cut").execute(*args, **kwargs)
            def read_dci_from_case(self, *args, **kwargs):
                """
                Read domain connectivity information (DCI) from case file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/read_dci_from_case").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/list").execute(*args, **kwargs)
            def intersect(self, *args, **kwargs):
                """
                Intersect an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/intersect").execute(*args, **kwargs)
            def clear_all(self, *args, **kwargs):
                """
                Clear all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/clear_all").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/create").execute(*args, **kwargs)
            def update_from_dci(self, *args, **kwargs):
                """
                Update all overset intrfaces from stored domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/update_from_dci").execute(*args, **kwargs)
            def write_cell_types(self, *args, **kwargs):
                """
                Write overset cell types into file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_cell_types").execute(*args, **kwargs)
            def find_all_bounding_cells(self, *args, **kwargs):
                """
                Find bounding cells for all cell centroids.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/find_all_bounding_cells").execute(*args, **kwargs)
            def set_mark_bounds(self, *args, **kwargs):
                """
                Set bounds (center, radius) for overset cell marking.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/set_mark_bounds").execute(*args, **kwargs)
            def fill_dci(self, *args, **kwargs):
                """
                Fill overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/fill_dci").execute(*args, **kwargs)
            def free_dci(self, *args, **kwargs):
                """
                Free overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/free_dci").execute(*args, **kwargs)
            def find_bounding_cell(self, *args, **kwargs):
                """
                Find bounding cell for given cell or search point.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/find_bounding_cell").execute(*args, **kwargs)
            def check(self, *args, **kwargs):
                """
                Check all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/check").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/delete_all").execute(*args, **kwargs)
            def clear(self, *args, **kwargs):
                """
                Clear an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/clear").execute(*args, **kwargs)
            def display_cells(self, *args, **kwargs):
                """
                Display the marked overset cells.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/display_cells").execute(*args, **kwargs)

            class cut_control(TUIMenu):
                """
                Enter the overset hole cut control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.cut_seeds = self.__class__.cut_seeds(path + ["cut_seeds"], service)
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    List the defined hole cut controls.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/list").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete the hole cut controls for all boundary zones.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/delete_all").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete hole cut control for a boundary zone.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/delete").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add hole cut control for a boundary zone.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/add").execute(*args, **kwargs)

                class cut_seeds(TUIMenu):
                    """
                    Enter the overset hole cut seed menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def cut_seeds_for_all_component_zones(self, *args, **kwargs):
                        """
                        Enable that all component zones get a cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/cut_seeds_for_all_component_zones").execute(*args, **kwargs)
                    def delete_all(self, *args, **kwargs):
                        """
                        Delete all hole cut seeds.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/delete_all").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a hole cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the defined hole cut seeds.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/list").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a hole cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/add").execute(*args, **kwargs)

            class adapt(TUIMenu):
                """
                Enter the overset adaption menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def adapt_mesh(self, *args, **kwargs):
                    """
                    Mark and adapt the mesh to remove orphan cells and large donor-receptor cell size differences.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/adapt/adapt_mesh").execute(*args, **kwargs)
                def mark_adaption(self, *args, **kwargs):
                    """
                    Mark cells for overset orphan adaption and donor-receptor size differences.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/adapt/mark_adaption").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the overset adaption set menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def anisotropic(self, *args, **kwargs):
                        """
                        Enable the option to use anisotropic adaption in prismatic cells.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/anisotropic").execute(*args, **kwargs)
                    def maximum_refinement_level(self, *args, **kwargs):
                        """
                        Set the maximum level of refinement in overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                    def gap_resolution(self, *args, **kwargs):
                        """
                        Set the target (minimum) gap resolution used when marking cells for gap adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/gap_resolution").execute(*args, **kwargs)
                    def automatic(self, *args, **kwargs):
                        """
                        Enable the option to automatically adapt overset meshes during solution update.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/automatic").execute(*args, **kwargs)
                    def mark_gaps(self, *args, **kwargs):
                        """
                        Enable the option to adapt underresolved gaps.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_gaps").execute(*args, **kwargs)
                    def mark_coarsening(self, *args, **kwargs):
                        """
                        Enable the option to coarsen the mesh during overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_coarsening").execute(*args, **kwargs)
                    def mark_fixed_orphans(self, *args, **kwargs):
                        """
                        Enable the option to adapt for orphans which were removed by accepting neighbor donors.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_fixed_orphans").execute(*args, **kwargs)
                    def mark_orphans(self, *args, **kwargs):
                        """
                        Enable the option to adapt for orphan reduction.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_orphans").execute(*args, **kwargs)
                    def length_ratio_max(self, *args, **kwargs):
                        """
                        Set the length scale ratio threshold used to determine which cells are marked for adaption based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/length_ratio_max").execute(*args, **kwargs)
                    def buffer_layers(self, *args, **kwargs):
                        """
                        Set the number of cell layers marked in addition to the cells marked for orphan adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/buffer_layers").execute(*args, **kwargs)
                    def mark_size(self, *args, **kwargs):
                        """
                        Enable the option to adapt for donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_size").execute(*args, **kwargs)
                    def adaption_sweeps(self, *args, **kwargs):
                        """
                        Set the number of adaption sweeps per overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/adaption_sweeps").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enter the overset interface options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def partial_cut_faces(self, *args, **kwargs):
                    """
                    Enable enhanced hole cutting where cut faces partially overlap.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/partial_cut_faces").execute(*args, **kwargs)
                def update_before_case_write(self, *args, **kwargs):
                    """
                    Enable update of overset interfaces before writing case file (CFF format only).
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/update_before_case_write").execute(*args, **kwargs)
                def node_connected_donors(self, *args, **kwargs):
                    """
                    Enable node or face connected donor cells.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/node_connected_donors").execute(*args, **kwargs)
                def parallel(self, *args, **kwargs):
                    """
                    Set options to control running overset in parallel.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/parallel").execute(*args, **kwargs)
                def minimize_overlap(self, *args, **kwargs):
                    """
                    Enable overlap minimization for overset interfaces.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/minimize_overlap").execute(*args, **kwargs)
                def transient_caching(self, *args, **kwargs):
                    """
                    Set options to control caching of entities in transient overset simulations.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/transient_caching").execute(*args, **kwargs)
                def render_receptor_cells(self, *args, **kwargs):
                    """
                    Set the option to include receptor cells in postprocessing.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/render_receptor_cells").execute(*args, **kwargs)
                def modified_donor_search(self, *args, **kwargs):
                    """
                    Enable modified and more extensive donor search.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/modified_donor_search").execute(*args, **kwargs)
                def mesh_interfaces(self, *args, **kwargs):
                    """
                    Allow mesh interfaces inside overset cell zones.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/mesh_interfaces").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enable additional overset options and tools.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/expert").execute(*args, **kwargs)
                def solve_island_removal(self, *args, **kwargs):
                    """
                    Set method used to control the removal of isolated patches of solve cells.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/solve_island_removal").execute(*args, **kwargs)
                def donor_priority_method(self, *args, **kwargs):
                    """
                    Set method used to evaludate the cell donor priority.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/donor_priority_method").execute(*args, **kwargs)
                def modified_hole_cutting(self, *args, **kwargs):
                    """
                    Enable modified hole cutting parameters.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/modified_hole_cutting").execute(*args, **kwargs)
                def dead_cell_update(self, *args, **kwargs):
                    """
                    Enable dead cell update in moving or dynamic mesh simulations.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/dead_cell_update").execute(*args, **kwargs)
                def overlap_boundaries(self, *args, **kwargs):
                    """
                    Enable overset topologies with overlap boundaries.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/overlap_boundaries").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set overset mesh reporting verbosity.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/verbosity").execute(*args, **kwargs)
                def auto_create(self, *args, **kwargs):
                    """
                    Enable automatic creation of default overset interface.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/auto_create").execute(*args, **kwargs)

        class reference_values(TUIMenu):
            """
            Reference value menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.compute = self.__class__.compute(path + ["compute"], service)
                super().__init__(path, service)
            def temperature(self, *args, **kwargs):
                """
                Set reference temperature for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/temperature").execute(*args, **kwargs)
            def yplus(self, *args, **kwargs):
                """
                Set reference yplus for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/yplus").execute(*args, **kwargs)
            def zone(self, *args, **kwargs):
                """
                Set reference zone.
                """
                return PyMenu(self.service, "/setup/reference_values/zone").execute(*args, **kwargs)
            def length(self, *args, **kwargs):
                """
                Set reference length for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/length").execute(*args, **kwargs)
            def viscosity(self, *args, **kwargs):
                """
                Set reference viscosity for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/viscosity").execute(*args, **kwargs)
            def density(self, *args, **kwargs):
                """
                Set reference density for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/density").execute(*args, **kwargs)
            def area(self, *args, **kwargs):
                """
                Set reference area for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/area").execute(*args, **kwargs)
            def enthalpy(self, *args, **kwargs):
                """
                Set reference enthalpy for enthalpy damping and normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/enthalpy").execute(*args, **kwargs)
            def velocity(self, *args, **kwargs):
                """
                Set reference velocity for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/velocity").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List current reference values.
                """
                return PyMenu(self.service, "/setup/reference_values/list").execute(*args, **kwargs)
            def depth(self, *args, **kwargs):
                """
                Set reference depth for volume calculation.
                """
                return PyMenu(self.service, "/setup/reference_values/depth").execute(*args, **kwargs)
            def pressure(self, *args, **kwargs):
                """
                Set reference pressure for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/pressure").execute(*args, **kwargs)

            class compute(TUIMenu):
                """
                Enter the compute menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/network_end").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/axis").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/periodic").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/geometry").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/interface").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/degassing").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/network").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/outflow").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/wall").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/intake_fan").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/radiator").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/solid").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/fan").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/porous_jump").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/overset").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/interior").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/shadow").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/fluid").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/symmetry").execute(*args, **kwargs)

        class mixing_planes(TUIMenu):
            """
            Enter the mixing planes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete a mixing plane.
                """
                return PyMenu(self.service, "/setup/mixing_planes/delete").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a mixing plane.
                """
                return PyMenu(self.service, "/setup/mixing_planes/create").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List defined mixing plane(s).
                """
                return PyMenu(self.service, "/setup/mixing_planes/list").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the mixing plane set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.conserve_total_enthalpy = self.__class__.conserve_total_enthalpy(path + ["conserve_total_enthalpy"], service)
                    self.conserve_swirl = self.__class__.conserve_swirl(path + ["conserve_swirl"], service)
                    super().__init__(path, service)
                def fix_pressure_level(self, *args, **kwargs):
                    """
                    Set fix pressure level using define/reference-pressure-location.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/fix_pressure_level").execute(*args, **kwargs)
                def averaging_method(self, *args, **kwargs):
                    """
                    Set mixing plane profile averaging method.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/averaging_method").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Set mixing plane under-relaxation factor.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/under_relaxation").execute(*args, **kwargs)

                class conserve_total_enthalpy(TUIMenu):
                    """
                    Enter the menu to set total enthalpy conservation in mixing plane menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable total enthalpy conservation in mixing plane.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_total_enthalpy/enable").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Enable/disable verbosity in total-enthalpy conservation calculations.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_total_enthalpy/verbosity").execute(*args, **kwargs)

                class conserve_swirl(TUIMenu):
                    """
                    Enter the mixing plane conserve-swirl menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def report_swirl_integration(self, *args, **kwargs):
                        """
                        Report swirl integration (torque) on inflow and outflow zones.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/report_swirl_integration").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable swirl conservation in mixing plane.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/enable").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Enable/disable verbosity in swirl conservation calculations.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/verbosity").execute(*args, **kwargs)

        class boundary_conditions(TUIMenu):
            """
            Enter the boudary conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                self.query = self.__class__.query(path + ["query"], service)
                self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                self.bc_settings = self.__class__.bc_settings(path + ["bc_settings"], service)
                self.profiles = self.__class__.profiles(path + ["profiles"], service)
                self.rename_zone = self.__class__.rename_zone(path + ["rename_zone"], service)
                super().__init__(path, service)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/list_zones").execute(*args, **kwargs)
            def interior(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/interior").execute(*args, **kwargs)
            def recirculation_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/recirculation_outlet").execute(*args, **kwargs)
            def symmetry(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/symmetry").execute(*args, **kwargs)
            def mass_flow_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/mass_flow_inlet").execute(*args, **kwargs)
            def network(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/network").execute(*args, **kwargs)
            def velocity_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/velocity_inlet").execute(*args, **kwargs)
            def shadow(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/shadow").execute(*args, **kwargs)
            def intake_fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/intake_fan").execute(*args, **kwargs)
            def fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/fan").execute(*args, **kwargs)
            def outlet_vent(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/outlet_vent").execute(*args, **kwargs)
            def pressure_far_field(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_far_field").execute(*args, **kwargs)
            def overset(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/overset").execute(*args, **kwargs)
            def recirculation_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/recirculation_inlet").execute(*args, **kwargs)
            def geometry(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/geometry").execute(*args, **kwargs)
            def inlet_vent(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/inlet_vent").execute(*args, **kwargs)
            def periodic(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/periodic").execute(*args, **kwargs)
            def radiator(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/radiator").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/zone_type").execute(*args, **kwargs)
            def degassing(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/degassing").execute(*args, **kwargs)
            def pressure_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_outlet").execute(*args, **kwargs)
            def copy_bc(self, *args, **kwargs):
                """
                Copy boundary conditions to another zone.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/copy_bc").execute(*args, **kwargs)
            def fluid(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/fluid").execute(*args, **kwargs)
            def pressure_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_inlet").execute(*args, **kwargs)
            def mass_flow_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/mass_flow_outlet").execute(*args, **kwargs)
            def solid(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/solid").execute(*args, **kwargs)
            def rans_les_interface(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/rans_les_interface").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/zone_name").execute(*args, **kwargs)
            def wall(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/wall").execute(*args, **kwargs)
            def network_end(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/network_end").execute(*args, **kwargs)
            def interface(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/interface").execute(*args, **kwargs)
            def axis(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/axis").execute(*args, **kwargs)
            def outflow(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/outflow").execute(*args, **kwargs)
            def porous_jump(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/porous_jump").execute(*args, **kwargs)
            def exhaust_fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/exhaust_fan").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the set boundary conditions menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/velocity_inlet").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/mass_flow_inlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/degassing").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/interface").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_outlet").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/fan").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/intake_fan").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/outflow").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/network").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/fluid").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/recirculation_inlet").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/solid").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/geometry").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_inlet").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/outlet_vent").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/mass_flow_outlet").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/symmetry").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/overset").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/radiator").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_far_field").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/interior").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/porous_jump").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/wall").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/inlet_vent").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/shadow").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/recirculation_outlet").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/rans_les_interface").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/exhaust_fan").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/network_end").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/periodic").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/axis").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter zone query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def radiator(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/radiator").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/fan").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/velocity_inlet").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/axis").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/porous_jump").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/exhaust_fan").execute(*args, **kwargs)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/delete_query").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/mass_flow_inlet").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/geometry").execute(*args, **kwargs)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of zone type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_named_selection").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/degassing").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_outlet").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/shadow").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/network_end").execute(*args, **kwargs)
                def list_cell_zone_conditions(self, *args, **kwargs):
                    """
                    List cell zone conditions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_cell_zone_conditions").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/outflow").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/wall").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/fluid").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/rans_les_interface").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/overset").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/interface").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_inlet").execute(*args, **kwargs)
                def named_zone_list(self, *args, **kwargs):
                    """
                    Create named list of zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/named_zone_list").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/mass_flow_outlet").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/solid").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/recirculation_outlet").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_far_field").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/interior").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/outlet_vent").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_queries").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/intake_fan").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/inlet_vent").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/symmetry").execute(*args, **kwargs)
                def list_boundary_conditions(self, *args, **kwargs):
                    """
                    List boundary conditions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_boundary_conditions").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/recirculation_inlet").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/periodic").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/network").execute(*args, **kwargs)

            class modify_zones(TUIMenu):
                """
                Enter the modify zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def sep_face_zone_angle(self, *args, **kwargs):
                    """
                    Separate a face zone based on significant angle.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
                def create_all_shell_threads(self, *args, **kwargs):
                    """
                    Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
                def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                    """
                    Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
                def activate_cell_zone(self, *args, **kwargs):
                    """
                    Activate a cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/activate_cell_zone").execute(*args, **kwargs)
                def list_zones(self, *args, **kwargs):
                    """
                    List zone IDs, types, kinds, and names.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/list_zones").execute(*args, **kwargs)
                def sep_cell_zone_region(self, *args, **kwargs):
                    """
                    Separate a cell zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
                def merge_zones(self, *args, **kwargs):
                    """
                    Merge zones of the same type and condition into one.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/merge_zones").execute(*args, **kwargs)
                def matching_tolerance(self, *args, **kwargs):
                    """
                    Set the normalized tolerance used for finding coincident nodes.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/matching_tolerance").execute(*args, **kwargs)
                def sep_face_zone_mark(self, *args, **kwargs):
                    """
                    Separate a face zone based on cell marking.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
                def change_zone_phase(self, *args, **kwargs):
                    """
                    Change the realgas phase for a zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/change_zone_phase").execute(*args, **kwargs)
                def sep_face_zone_region(self, *args, **kwargs):
                    """
                    Separate a face zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
                def append_mesh_data(self, *args, **kwargs):
                    """
                    Append new mesh with data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/append_mesh_data").execute(*args, **kwargs)
                def slit_interior_between_diff_solids(self, *args, **kwargs):
                    """
                    Slit interior created between different solids into coupled walls.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
                def fuse_face_zones(self, *args, **kwargs):
                    """
                    Attempt to fuse zones by removing duplicate faces and nodes.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/fuse_face_zones").execute(*args, **kwargs)
                def zone_type(self, *args, **kwargs):
                    """
                    Set a zone's type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/zone_type").execute(*args, **kwargs)
                def translate_zone(self, *args, **kwargs):
                    """
                    Translate nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/translate_zone").execute(*args, **kwargs)
                def create_periodic_interface(self, *args, **kwargs):
                    """
                    Create a conformal or non-conformal periodic interface.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/create_periodic_interface").execute(*args, **kwargs)
                def extrude_face_zone_delta(self, *args, **kwargs):
                    """
                    Extrude a face thread a specified distance based on a list of deltas.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
                def zone_name(self, *args, **kwargs):
                    """
                    Give a zone a new name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/zone_name").execute(*args, **kwargs)
                def extrude_face_zone_para(self, *args, **kwargs):
                    """
                    Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
                def copy_move_cell_zone(self, *args, **kwargs):
                    """
                    Copy and translate or rotate a cell zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
                def deactivate_cell_zone(self, *args, **kwargs):
                    """
                    Deactivate cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
                def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                    """
                    Change all solid zones motion specification from MRF to solid motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
                def append_mesh(self, *args, **kwargs):
                    """
                    Append new mesh.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/append_mesh").execute(*args, **kwargs)
                def sep_cell_zone_mark(self, *args, **kwargs):
                    """
                    Separate a cell zone based on cell marking.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
                def slit_face_zone(self, *args, **kwargs):
                    """
                    Slit a two-sided wall into two connected wall zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_face_zone").execute(*args, **kwargs)
                def orient_face_zone(self, *args, **kwargs):
                    """
                    Orient the face zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/orient_face_zone").execute(*args, **kwargs)
                def slit_periodic(self, *args, **kwargs):
                    """
                    Slit a periodic zone into two symmetry zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_periodic").execute(*args, **kwargs)
                def change_zone_state(self, *args, **kwargs):
                    """
                    Change the realgas material state for a zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/change_zone_state").execute(*args, **kwargs)
                def rotate_zone(self, *args, **kwargs):
                    """
                    Rotate nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/rotate_zone").execute(*args, **kwargs)
                def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                    """
                    Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
                def scale_zone(self, *args, **kwargs):
                    """
                    Scale nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/scale_zone").execute(*args, **kwargs)
                def mrf_to_sliding_mesh(self, *args, **kwargs):
                    """
                    Change motion specification from MRF to moving mesh.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
                def delete_all_shells(self, *args, **kwargs):
                    """
                    Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/delete_all_shells").execute(*args, **kwargs)
                def replace_zone(self, *args, **kwargs):
                    """
                    Replace a cell zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/replace_zone").execute(*args, **kwargs)
                def sep_face_zone_face(self, *args, **kwargs):
                    """
                    Separate each face in a zone into unique zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_face").execute(*args, **kwargs)
                def recreate_all_shells(self, *args, **kwargs):
                    """
                    Create shell on all the walls where which were deleted using the command delete-all-shells.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/recreate_all_shells").execute(*args, **kwargs)
                def make_periodic(self, *args, **kwargs):
                    """
                    Attempt to establish conformal periodic face zone connectivity.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/make_periodic").execute(*args, **kwargs)
                def delete_cell_zone(self, *args, **kwargs):
                    """
                    Delete a cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/delete_cell_zone").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert bc menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
                    self.perforated_walls = self.__class__.perforated_walls(path + ["perforated_walls"], service)
                    self.impedance_data_fitting = self.__class__.impedance_data_fitting(path + ["impedance_data_fitting"], service)
                    self.non_reflecting_bc = self.__class__.non_reflecting_bc(path + ["non_reflecting_bc"], service)
                    super().__init__(path, service)
                def openchannel_threads(self, *args, **kwargs):
                    """
                    List open channel group IDs, names, types, and variables.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/openchannel_threads").execute(*args, **kwargs)
                def target_mass_flow_rate_settings(self, *args, **kwargs):
                    """
                    Enter the targeted mass flow rate setting menu.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/target_mass_flow_rate_settings").execute(*args, **kwargs)
                def open_channel_wave_settings(self, *args, **kwargs):
                    """
                    Open channel wave input analysis.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/open_channel_wave_settings").execute(*args, **kwargs)
                def non_overlapping_zone_name(self, *args, **kwargs):
                    """
                    Get non-overlapping zone name from the associated interface zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/non_overlapping_zone_name").execute(*args, **kwargs)

                class periodic_conditions(TUIMenu):
                    """
                    Enter the periodic conditions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_gradient_specification(self, *args, **kwargs):
                        """
                        Enable/disable specification of pressure gradient at the periodic boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/periodic_conditions/pressure_gradient_specification").execute(*args, **kwargs)
                    def massflow_rate_specification(self, *args, **kwargs):
                        """
                        Enable/disable specification of mass flow rate at the periodic boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/periodic_conditions/massflow_rate_specification").execute(*args, **kwargs)

                class perforated_walls(TUIMenu):
                    """
                    Enter the perforated walls setting menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def read_input_file(self, *args, **kwargs):
                        """
                        Read an input file.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/perforated_walls/read_input_file").execute(*args, **kwargs)
                    def model_setup(self, *args, **kwargs):
                        """
                        Set up perforated walls.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/perforated_walls/model_setup").execute(*args, **kwargs)

                class impedance_data_fitting(TUIMenu):
                    """
                    Enter the impedance data fitting menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def reflection_data(self, *args, **kwargs):
                        """
                        Read experimental reflection coefficient data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/reflection_data").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the convergence tolerance for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/convergence_tolerance").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set verbosity level [0, 1] for fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/verbosity").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Set the number of iterations for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/iterations").execute(*args, **kwargs)
                    def import_parameters(self, *args, **kwargs):
                        """
                        Import impedance parameters into boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/import_parameters").execute(*args, **kwargs)
                    def residue_tolerance(self, *args, **kwargs):
                        """
                        Set the residue tolerance for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/residue_tolerance").execute(*args, **kwargs)
                    def impedance_data(self, *args, **kwargs):
                        """
                        Read experimental impedance data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/impedance_data").execute(*args, **kwargs)
                    def absorption_data(self, *args, **kwargs):
                        """
                        Read experimental absorption coefficient data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/absorption_data").execute(*args, **kwargs)

                class non_reflecting_bc(TUIMenu):
                    """
                    Enter the non-reflecting b.c. menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.general_nrbc = self.__class__.general_nrbc(path + ["general_nrbc"], service)
                        self.turbo_specific_nrbc = self.__class__.turbo_specific_nrbc(path + ["turbo_specific_nrbc"], service)
                        super().__init__(path, service)

                    class general_nrbc(TUIMenu):
                        """
                        Enter the menu for setting general non-reflecting boundary conditions.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.set = self.__class__.set(path + ["set"], service)
                            super().__init__(path, service)

                        class set(TUIMenu):
                            """
                            Enter the general non-reflecting b.c. menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def tangential_source(self, *args, **kwargs):
                                """
                                Include or not NRBC tangential source (default value #t).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/tangential_source").execute(*args, **kwargs)
                            def relax(self, *args, **kwargs):
                                """
                                Set NRBC relaxation factor (default value 0.5).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/relax").execute(*args, **kwargs)
                            def verbosity(self, *args, **kwargs):
                                """
                                Print boundary equations convergence info.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/verbosity").execute(*args, **kwargs)
                            def sigma2(self, *args, **kwargs):
                                """
                                Set nrbc sigma2 factor (default value 5.0).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/sigma2").execute(*args, **kwargs)
                            def sigma(self, *args, **kwargs):
                                """
                                Set nrbc sigma factor (default value 0.15).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/sigma").execute(*args, **kwargs)

                    class turbo_specific_nrbc(TUIMenu):
                        """
                        Enter the turbo-specific n.r.b.c. menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.set = self.__class__.set(path + ["set"], service)
                            super().__init__(path, service)
                        def initialize(self, *args, **kwargs):
                            """
                            Initialize turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/initialize").execute(*args, **kwargs)
                        def show_status(self, *args, **kwargs):
                            """
                            Show current status of turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/show_status").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enable/disable turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/enable").execute(*args, **kwargs)

                        class set(TUIMenu):
                            """
                            Enter the set menu for turbo-specific non-reflecting b.c. parameters.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def discretization(self, *args, **kwargs):
                                """
                                Enable use of higher-order reconstruction at boundaries if available.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/discretization").execute(*args, **kwargs)
                            def under_relaxation(self, *args, **kwargs):
                                """
                                Set turbo-specific non-reflecting b.c. under-relaxation factor.
                                specify < 0 => use P/a_ave
                                specify = 0 => use 1/N
                                specify > 0 => use specified.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/under_relaxation").execute(*args, **kwargs)
                            def verbosity(self, *args, **kwargs):
                                """
                                Set turbo-specific non-reflecting b.c. verbosity level.
                                0 : silent
                                1 : basic info. default
                                2 : detailed info. for debugging
                                .
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/verbosity").execute(*args, **kwargs)

            class bc_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.pressure_far_field = self.__class__.pressure_far_field(path + ["pressure_far_field"], service)
                    super().__init__(path, service)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Select pressure specification method on pressure-outlet boundaries.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_outlet").execute(*args, **kwargs)
                def mass_flow(self, *args, **kwargs):
                    """
                    Select method for setting the mass flow rate.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/mass_flow").execute(*args, **kwargs)

                class pressure_far_field(TUIMenu):
                    """
                    Select presure-far-field boundary-condition options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def type(self, *args, **kwargs):
                        """
                        Choose pressure-far-field boundary-condition type.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_far_field/type").execute(*args, **kwargs)
                    def riemann_invariants_tangency_correction(self, *args, **kwargs):
                        """
                        Apply a local correction where the flow is tangential to the boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_far_field/riemann_invariants_tangency_correction").execute(*args, **kwargs)

            class profiles(TUIMenu):
                """
                Enter the boundary profiles menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Choose the method for interpolation of profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/interpolation_method").execute(*args, **kwargs)
                def orient_profile(self, *args, **kwargs):
                    """
                    Orient Profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/orient_profile").execute(*args, **kwargs)
                def list_profiles(self, *args, **kwargs):
                    """
                    List all profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profiles").execute(*args, **kwargs)
                def morphing(self, *args, **kwargs):
                    """
                    Enable/disable profile morphing options in Orient Profile panel.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/morphing").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all boundary-profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/delete_all").execute(*args, **kwargs)
                def link_profile_to_reference_frame(self, *args, **kwargs):
                    """
                    Link profile to a reference frame.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/link_profile_to_reference_frame").execute(*args, **kwargs)
                def list_profile_parameters(self, *args, **kwargs):
                    """
                    List the parameters of a particular profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profile_parameters").execute(*args, **kwargs)
                def display_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Display Profile Point Cloud Data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/display_profile_point_cloud_data").execute(*args, **kwargs)
                def overlay_profile_surface(self, *args, **kwargs):
                    """
                    Overlay Profile Surface.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/overlay_profile_surface").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete a profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/delete").execute(*args, **kwargs)
                def replicate_profile(self, *args, **kwargs):
                    """
                    Replicate Profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/replicate_profile").execute(*args, **kwargs)
                def set_preference_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Set Preference Profile Point Cloud Data e.g., Point marker symbol,size,color.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/set_preference_profile_point_cloud_data").execute(*args, **kwargs)
                def list_profile_fields(self, *args, **kwargs):
                    """
                    List the fields of a particular profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profile_fields").execute(*args, **kwargs)
                def display_profile_surface(self, *args, **kwargs):
                    """
                    Display a profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/display_profile_surface").execute(*args, **kwargs)
                def update_interval(self, *args, **kwargs):
                    """
                    Set interval between updates of dynamic profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/update_interval").execute(*args, **kwargs)
                def overlay_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Overlay Profile Point Cloud Data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/overlay_profile_point_cloud_data").execute(*args, **kwargs)

            class rename_zone(TUIMenu):
                """
                Enter zone rename menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rename_by_adjacency(self, *args, **kwargs):
                    """
                    Rename zone to adjacent zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/rename_by_adjacency").execute(*args, **kwargs)
                def add_suffix_or_prefix(self, *args, **kwargs):
                    """
                    Add suffix or prefix to zone name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/add_suffix_or_prefix").execute(*args, **kwargs)
                def rename_to_default(self, *args, **kwargs):
                    """
                    Rename zone to default name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/rename_to_default").execute(*args, **kwargs)

        class reference_frames(TUIMenu):
            """
            Manage reference frames.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display_edit(self, *args, **kwargs):
                """
                Display and edit reference frame from graphics.
                """
                return PyMenu(self.service, "/setup/reference_frames/display_edit").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/setup/reference_frames/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/setup/reference_frames/list").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/delete").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display Reference Frame.
                """
                return PyMenu(self.service, "/setup/reference_frames/display").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/list_properties").execute(*args, **kwargs)
            def hide(self, *args, **kwargs):
                """
                Hide Reference Frame.
                """
                return PyMenu(self.service, "/setup/reference_frames/hide").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/edit").execute(*args, **kwargs)

        class materials(TUIMenu):
            """
            Enter the materials menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_base = self.__class__.data_base(path + ["data_base"], service)
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete a material from local storage.
                """
                return PyMenu(self.service, "/setup/materials/delete").execute(*args, **kwargs)
            def change_create(self, *args, **kwargs):
                """
                Change the properties of a locally-stored material or create a new material.
                """
                return PyMenu(self.service, "/setup/materials/change_create").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List the properties of a locally-stored material.
                """
                return PyMenu(self.service, "/setup/materials/list_properties").execute(*args, **kwargs)
            def copy_by_formula(self, *args, **kwargs):
                """
                Copy a material from the database by formula.
                """
                return PyMenu(self.service, "/setup/materials/copy_by_formula").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy a material from the database.
                """
                return PyMenu(self.service, "/setup/materials/copy").execute(*args, **kwargs)
            def list_materials(self, *args, **kwargs):
                """
                List all locally-stored materials.
                """
                return PyMenu(self.service, "/setup/materials/list_materials").execute(*args, **kwargs)

            class data_base(TUIMenu):
                """
                Enter the database menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_properties(self, *args, **kwargs):
                    """
                    List the properties of a material in the database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/list_properties").execute(*args, **kwargs)
                def list_materials(self, *args, **kwargs):
                    """
                    List all materials in the database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/list_materials").execute(*args, **kwargs)
                def database_type(self, *args, **kwargs):
                    """
                    Set the database type.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/database_type").execute(*args, **kwargs)
                def save(self, *args, **kwargs):
                    """
                    Save user-defined database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/save").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit a material.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/edit").execute(*args, **kwargs)
                def new(self, *args, **kwargs):
                    """
                    Define a new material.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/new").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enter the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                super().__init__(path, service)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Enable/disable Newmark unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_1st_order").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enable/disable the steady solution model.
                """
                return PyMenu(self.service, "/setup/models/steady").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/setup/models/vbm").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                Enable/disable the energy model.
                """
                return PyMenu(self.service, "/setup/models/energy").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Enable/disable the axisymmetric model.
                """
                return PyMenu(self.service, "/setup/models/axisymmetric").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Enable/disable Backward Euler unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_euler").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enable/disable the solidification and melting model.
                """
                return PyMenu(self.service, "/setup/models/solidification_melting").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_global_time").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enter the crevice model controls menu.
                """
                return PyMenu(self.service, "/setup/models/crevice_model_controls").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/setup/models/frozen_flux").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enable/disable axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/setup/models/swirl").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enable/disable the soot model.
                """
                return PyMenu(self.service, "/setup/models/soot").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enter battery model menu.
                """
                return PyMenu(self.service, "/setup/models/battery_model").execute(*args, **kwargs)
            def optics(self, *args, **kwargs):
                """
                Enter the optics model menu.
                """
                return PyMenu(self.service, "/setup/models/optics").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Load addon module.
                """
                return PyMenu(self.service, "/setup/models/addon_module").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enable/disable ablation model.
                """
                return PyMenu(self.service, "/setup/models/ablation").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/setup/models/noniterative_time_advance").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order").execute(*args, **kwargs)
            def nox(self, *args, **kwargs):
                """
                Enable/disable the NOx model.
                """
                return PyMenu(self.service, "/setup/models/nox").execute(*args, **kwargs)
            def crevice_model(self, *args, **kwargs):
                """
                Enable/disable the crevice model.
                """
                return PyMenu(self.service, "/setup/models/crevice_model").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enable/disable the electric-potential model.
                """
                return PyMenu(self.service, "/setup/models/potential_and_li_ion_battery").execute(*args, **kwargs)

            class nox_parameters(TUIMenu):
                """
                Enter the NOx parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nox_expert(self, *args, **kwargs):
                    """
                    Select additional nox equations.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_expert").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/inlet_diffusion").execute(*args, **kwargs)
                def nox_chemistry(self, *args, **kwargs):
                    """
                    Select NOx chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_chemistry").execute(*args, **kwargs)
                def nox_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set NOx-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_turbulence_interaction").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Define multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Mixture parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/mixture_parameters").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Body force formulation.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/body_force_formulation").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specify multiphase model.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/model").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Regime-transition-modeling-options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    VOF sub-models.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/vof_sub_models").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Coupled level set.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/coupled_level_set").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Interface Modeling Options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specify the number of phases.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/number_of_phases").execute(*args, **kwargs)

                class hybrid_models(TUIMenu):
                    """
                    Enter the menu to select hybrid models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ddpm(self, *args, **kwargs):
                        """
                        Enable the dense discrete phase model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/hybrid_models/ddpm").execute(*args, **kwargs)
                    def multi_fluid_vof(self, *args, **kwargs):
                        """
                        Enable the multi-fluid VOF model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/hybrid_models/multi_fluid_vof").execute(*args, **kwargs)

                class flow_regime_modeling(TUIMenu):
                    """
                    Flow Regime Modeling.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.aiad_parameters = self.__class__.aiad_parameters(path + ["aiad_parameters"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable flow regime modeling framework including phase state and morphology.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/enable").execute(*args, **kwargs)

                    class aiad_parameters(TUIMenu):
                        """
                        AIAD parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delta_vf(self, *args, **kwargs):
                            """
                            Parameter for transition width for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/delta_vf").execute(*args, **kwargs)
                        def critical_vf(self, *args, **kwargs):
                            """
                            Critical volume fraction for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/critical_vf").execute(*args, **kwargs)
                        def ncells_fs(self, *args, **kwargs):
                            """
                            Parameter for determining interfacial width.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/ncells_fs").execute(*args, **kwargs)
                        def delta_grad(self, *args, **kwargs):
                            """
                            Parameter for determining transition width for free surface blending factor.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/delta_grad").execute(*args, **kwargs)

                class population_balance(TUIMenu):
                    """
                    Enter the population balance model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.phenomena = self.__class__.phenomena(path + ["phenomena"], service)
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def size_calculator(self, *args, **kwargs):
                        """
                        Calculate fluid particle diameters using different methods.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/size_calculator").execute(*args, **kwargs)
                    def include_expansion(self, *args, **kwargs):
                        """
                        Set expansion.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/include_expansion").execute(*args, **kwargs)
                    def model(self, *args, **kwargs):
                        """
                        Select the population balance model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/model").execute(*args, **kwargs)

                    class phenomena(TUIMenu):
                        """
                        Enter the phenomena menu for population balance.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def aggregation(self, *args, **kwargs):
                            """
                            Set the aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation").execute(*args, **kwargs)
                        def breakage(self, *args, **kwargs):
                            """
                            Set the breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage").execute(*args, **kwargs)
                        def growth(self, *args, **kwargs):
                            """
                            Set the growth rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/growth").execute(*args, **kwargs)
                        def aggregation_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation_factor").execute(*args, **kwargs)
                        def breakage_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_factor").execute(*args, **kwargs)
                        def nucleation(self, *args, **kwargs):
                            """
                            Set the nucleantion rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/nucleation").execute(*args, **kwargs)
                        def breakage_aggregation_vof_cutoff(self, *args, **kwargs):
                            """
                            Control vof cut-off for breakage and aggregation.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_aggregation_vof_cutoff").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the expert menu for quadrature-based population balance method.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.qmom = self.__class__.qmom(path + ["qmom"], service)
                            super().__init__(path, service)

                        class qmom(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def realizable_moments(self, *args, **kwargs):
                                """
                                Set the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/realizable_moments").execute(*args, **kwargs)
                            def retain_qmom_sources_for_low_vof(self, *args, **kwargs):
                                """
                                Retain qmom source calculation for low secondary phase vof.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/retain_qmom_sources_for_low_vof").execute(*args, **kwargs)
                            def inversion_algorithm(self, *args, **kwargs):
                                """
                                Select the inversion algorithm for quadrature-based population balance method.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/inversion_algorithm").execute(*args, **kwargs)
                            def print_realizable_moment_warning(self, *args, **kwargs):
                                """
                                Print the information for realizable moments in the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/print_realizable_moment_warning").execute(*args, **kwargs)

                class wet_steam(TUIMenu):
                    """
                    Enter the wet steam model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)
                    def load_unload_user_defined_wetsteam_library(self, *args, **kwargs):
                        """
                        Load or unload user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/load_unload_user_defined_wetsteam_library").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable the wet steam model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/enable").execute(*args, **kwargs)
                    def compile_user_defined_wetsteam_functions(self, *args, **kwargs):
                        """
                        Compile user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/compile_user_defined_wetsteam_functions").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enter the set menu for setting wet steam model options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def droplet_growth_rate(self, *args, **kwargs):
                            """
                            Select the formula to model the droplet growth rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/droplet_growth_rate").execute(*args, **kwargs)
                        def virial_equation(self, *args, **kwargs):
                            """
                            Select the formulation of the virial equation of state and associated equations for thermodynamic properties of steam.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/virial_equation").execute(*args, **kwargs)
                        def zonal_phase_change(self, *args, **kwargs):
                            """
                            Select cell zones where phase change process is active.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/zonal_phase_change").execute(*args, **kwargs)
                        def max_liquid_mass_fraction(self, *args, **kwargs):
                            """
                            Set the maximum limit on the condensed liquid-phase mass-fraction to prevent divergence.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/max_liquid_mass_fraction").execute(*args, **kwargs)
                        def stagnation_conditions(self, *args, **kwargs):
                            """
                            If the gas phase is selected, zero wetness is assumed when evaluating total or static values of pressure and temperature.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/stagnation_conditions").execute(*args, **kwargs)
                        def rgp_tables(self, *args, **kwargs):
                            """
                            Select which properties to use: build-in or from RGP tables.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/rgp_tables").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        super().__init__(path, service)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                super().__init__(path, service)

                            class numerics(TUIMenu):
                                """
                                Enter the menu to set numerics models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)

                            class heat_mass_reactions(TUIMenu):
                                """
                                Enter the menu to set heat, mass-transfer, or reaction related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    super().__init__(path, service)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)

                            class interfacial_area(TUIMenu):
                                """
                                Enter the menu to set interfacial area models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    super().__init__(path, service)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)

                            class forces(TUIMenu):
                                """
                                Enter the menu to set interfacial forces related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_modeling").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)

                            class model_transition(TUIMenu):
                                """
                                Enter the menu to set model transition mechanisms.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    super().__init__(path, service)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)

                    class iac_expert(TUIMenu):
                        """
                        Enter the IAC expert setting menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def hibiki_ishii_model(self, *args, **kwargs):
                            """
                            Set hi model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/hibiki_ishii_model").execute(*args, **kwargs)
                        def ishii_kim_model(self, *args, **kwargs):
                            """
                            Set ik model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/ishii_kim_model").execute(*args, **kwargs)
                        def iac_pseudo_time_step(self, *args, **kwargs):
                            """
                            Set iac pseudo-time.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/iac_pseudo_time_step").execute(*args, **kwargs)
                        def yao_morel_model(self, *args, **kwargs):
                            """
                            Set ym model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/yao_morel_model").execute(*args, **kwargs)

                class explicit_expert_options(TUIMenu):
                    """
                    Expert options for explicit formulation.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.volume_fraction_filtering = self.__class__.volume_fraction_filtering(path + ["volume_fraction_filtering"], service)
                        super().__init__(path, service)
                    def sub_time_step_method(self, *args, **kwargs):
                        """
                        Select sub-time step method for the time integration in explicit formulation.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/sub_time_step_method").execute(*args, **kwargs)
                    def solve_vof_every_iter(self, *args, **kwargs):
                        """
                        Solve volume fraction equation every iteration for explicit formulation.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/solve_vof_every_iter").execute(*args, **kwargs)

                    class volume_fraction_filtering(TUIMenu):
                        """
                        Advanced volume fraction filtering controls for explicit formulation.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable(self, *args, **kwargs):
                            """
                            Enable volume fraction filtering treatment.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/enable").execute(*args, **kwargs)
                        def vol_frac_cutoff(self, *args, **kwargs):
                            """
                            Enter node-averaged volume fraction cutoff.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/vol_frac_cutoff").execute(*args, **kwargs)
                        def filtering_options(self, *args, **kwargs):
                            """
                            Select volume fraction filtering method.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/filtering_options").execute(*args, **kwargs)

                class sub_models(TUIMenu):
                    """
                    Enter the menu to select sub-models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling_options = self.__class__.boiling_options(path + ["boiling_options"], service)
                        super().__init__(path, service)
                    def boiling(self, *args, **kwargs):
                        """
                        Activate boiling model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling").execute(*args, **kwargs)

                    class boiling_options(TUIMenu):
                        """
                        Set boiling options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def nlbf_model(self, *args, **kwargs):
                            """
                            Set the non-local boundary field correction.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling_options/nlbf_model").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Choose the type of boiling model.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling_options/options").execute(*args, **kwargs)

            class viscous(TUIMenu):
                """
                Enter the viscous model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_turbulence = self.__class__.multiphase_turbulence(path + ["multiphase_turbulence"], service)
                    self.near_wall_treatment = self.__class__.near_wall_treatment(path + ["near_wall_treatment"], service)
                    self.turbulence_expert = self.__class__.turbulence_expert(path + ["turbulence_expert"], service)
                    self.geko_options = self.__class__.geko_options(path + ["geko_options"], service)
                    self.transition_model_options = self.__class__.transition_model_options(path + ["transition_model_options"], service)
                    super().__init__(path, service)
                def les_dynamic_energy_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Prandtl Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_energy_flux").execute(*args, **kwargs)
                def reynolds_stress_model(self, *args, **kwargs):
                    """
                    Enable/disable the RSM turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/reynolds_stress_model").execute(*args, **kwargs)
                def les_subgrid_wmles(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles").execute(*args, **kwargs)
                def rsm_omega_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-omega model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_omega_based").execute(*args, **kwargs)
                def les_subgrid_wmles_s_minus_omega(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES S-Omega subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles_s_minus_omega").execute(*args, **kwargs)
                def kw_wj_bsl_earsm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_wj_bsl_earsm").execute(*args, **kwargs)
                def kw_bsl(self, *args, **kwargs):
                    """
                    Enable/disable the BSL k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_bsl").execute(*args, **kwargs)
                def corner_flow_correction(self, *args, **kwargs):
                    """
                    Enable/disable the corner flow correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction").execute(*args, **kwargs)
                def curvature_correction(self, *args, **kwargs):
                    """
                    Enable/disable the curvature correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction").execute(*args, **kwargs)
                def v2f(self, *args, **kwargs):
                    """
                    Enable/disable the V2F turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/v2f").execute(*args, **kwargs)
                def kw_geko(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_geko").execute(*args, **kwargs)
                def sa_alternate_prod(self, *args, **kwargs):
                    """
                    Enable/disable strain/vorticity production in Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_alternate_prod").execute(*args, **kwargs)
                def user_defined_transition(self, *args, **kwargs):
                    """
                    Set user-defined transition correlations.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined_transition").execute(*args, **kwargs)
                def sa_damping(self, *args, **kwargs):
                    """
                    Enable/disable the full low-Reynolds number form of Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_damping").execute(*args, **kwargs)
                def kw_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_standard").execute(*args, **kwargs)
                def sas(self, *args, **kwargs):
                    """
                    Enable/disable the SAS turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sas").execute(*args, **kwargs)
                def ke_realizable(self, *args, **kwargs):
                    """
                    Enable/disable the realizable k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_realizable").execute(*args, **kwargs)
                def les_subgrid_wale(self, *args, **kwargs):
                    """
                    Enable/disable the WALE subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wale").execute(*args, **kwargs)
                def rng_swirl_model(self, *args, **kwargs):
                    """
                    Enable/disable swirl corrections for rng-model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_swirl_model").execute(*args, **kwargs)
                def les_dynamic_scalar_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Schmidt Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_scalar_flux").execute(*args, **kwargs)
                def transition_sst(self, *args, **kwargs):
                    """
                    Enable/disable the transition SST turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/transition_sst").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Select user-defined functions to define the turbulent viscosity and the turbulent Prandtl and Schmidt numbers.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined").execute(*args, **kwargs)
                def les_subgrid_tke(self, *args, **kwargs):
                    """
                    Enable/disable the kinetic energy transport subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_tke").execute(*args, **kwargs)
                def kw_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_easm").execute(*args, **kwargs)
                def rsm_or_earsm_geko_option(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO option for RSM or EARSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_or_earsm_geko_option").execute(*args, **kwargs)
                def rsm_ssg_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the quadratic pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_ssg_pressure_strain").execute(*args, **kwargs)
                def kw_shear_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega shear-flow correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_shear_correction").execute(*args, **kwargs)
                def trans_sst_roughness_correlation(self, *args, **kwargs):
                    """
                    Enable/disable the Transition-SST roughness correlation option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/trans_sst_roughness_correlation").execute(*args, **kwargs)
                def les_subgrid_dynamic_fvar(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                def corner_flow_correction_ccorner(self, *args, **kwargs):
                    """
                    Set the corner flow correction coefficient CCORNER.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction_ccorner").execute(*args, **kwargs)
                def turb_compressibility(self, *args, **kwargs):
                    """
                    Enable/disable the compressibility correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_compressibility").execute(*args, **kwargs)
                def les_subgrid_smagorinsky(self, *args, **kwargs):
                    """
                    Enable/disable the Smagorinsky-Lilly subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_smagorinsky").execute(*args, **kwargs)
                def curvature_correction_ccurv(self, *args, **kwargs):
                    """
                    Set the curvature correction coefficient CCURV.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction_ccurv").execute(*args, **kwargs)
                def ke_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_rng").execute(*args, **kwargs)
                def sa_enhanced_wall_treatment(self, *args, **kwargs):
                    """
                    Enable/disable the enhanced wall treatment for the Spalart-Allmaras model.
                    If disabled, no smooth blending between the viscous sublayer and the
                    log-law formulation is employed, as was done in versions previous to Fluent14.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_enhanced_wall_treatment").execute(*args, **kwargs)
                def k_kl_w(self, *args, **kwargs):
                    """
                    Enable/disable the k-kl-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/k_kl_w").execute(*args, **kwargs)
                def des_limiter_option(self, *args, **kwargs):
                    """
                    Select DES limiter option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/des_limiter_option").execute(*args, **kwargs)
                def ke_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_easm").execute(*args, **kwargs)
                def ke1e(self, *args, **kwargs):
                    """
                    Enable/disable the KE1E turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke1e").execute(*args, **kwargs)
                def spalart_allmaras(self, *args, **kwargs):
                    """
                    Enable/disable the Spalart-Allmaras turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/spalart_allmaras").execute(*args, **kwargs)
                def ke_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_standard").execute(*args, **kwargs)
                def rsm_wall_echo(self, *args, **kwargs):
                    """
                    Enable/disable wall-echo effects in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_wall_echo").execute(*args, **kwargs)
                def turb_buoyancy_effects(self, *args, **kwargs):
                    """
                    Select buoyancy effects on turbulence.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_buoyancy_effects").execute(*args, **kwargs)
                def rng_differential_visc(self, *args, **kwargs):
                    """
                    Enable/disable the differential-viscosity model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_differential_visc").execute(*args, **kwargs)
                def rsm_solve_tke(self, *args, **kwargs):
                    """
                    Enable/disable the solution of T.K.E. in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_solve_tke").execute(*args, **kwargs)
                def kw_low_re_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega low Re option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_low_re_correction").execute(*args, **kwargs)
                def inviscid(self, *args, **kwargs):
                    """
                    Enable/disable the inviscid flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/inviscid").execute(*args, **kwargs)
                def les_subgrid_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_rng").execute(*args, **kwargs)
                def mixing_length(self, *args, **kwargs):
                    """
                    Enable/disable the mixing-length (algebraic) turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/mixing_length").execute(*args, **kwargs)
                def large_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable large eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/large_eddy_simulation").execute(*args, **kwargs)
                def rsm_linear_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the linear pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_linear_pressure_strain").execute(*args, **kwargs)
                def kw_sst(self, *args, **kwargs):
                    """
                    Enable/disable the SST k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_sst").execute(*args, **kwargs)
                def laminar(self, *args, **kwargs):
                    """
                    Enable/disable the laminar flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/laminar").execute(*args, **kwargs)
                def add_transition_model(self, *args, **kwargs):
                    """
                    Enable/disable a transition model to account for transitional effects.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/add_transition_model").execute(*args, **kwargs)
                def zero_equation_hvac(self, *args, **kwargs):
                    """
                    Enable/disable the zero-equation HVAC turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/zero_equation_hvac").execute(*args, **kwargs)
                def low_pressure_boundary_slip(self, *args, **kwargs):
                    """
                    Enable/disable the slip boundary formulation for low-pressure gas systems.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/low_pressure_boundary_slip").execute(*args, **kwargs)
                def rsm_bsl_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-BSL model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_bsl_based").execute(*args, **kwargs)
                def detached_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable detached eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/detached_eddy_simulation").execute(*args, **kwargs)

                class multiphase_turbulence(TUIMenu):
                    """
                    Enter the multiphase turbulence menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turbulence_multiphase_models(self, *args, **kwargs):
                        """
                        Select the k-epsilon multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/turbulence_multiphase_models").execute(*args, **kwargs)
                    def subgrid_turbulence_contribution_aiad(self, *args, **kwargs):
                        """
                        Enable/disable the Subgrid Turbulence Contribution for the AIAD model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/subgrid_turbulence_contribution_aiad").execute(*args, **kwargs)
                    def rsm_multiphase_models(self, *args, **kwargs):
                        """
                        Enable/disable the Reynolds Stress multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/rsm_multiphase_models").execute(*args, **kwargs)
                    def multiphase_options(self, *args, **kwargs):
                        """
                        Enable/disable multiphase options.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/multiphase_options").execute(*args, **kwargs)

                class near_wall_treatment(TUIMenu):
                    """
                    Enter the near wall treatment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def werner_wengle_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable Werner-Wengle wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/werner_wengle_wall_fn").execute(*args, **kwargs)
                    def menter_lechner(self, *args, **kwargs):
                        """
                        Enable/disable near wall treatment Menter-Lechner.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/menter_lechner").execute(*args, **kwargs)
                    def wall_omega_treatment(self, *args, **kwargs):
                        """
                        Set wall omega treatment.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wall_omega_treatment").execute(*args, **kwargs)
                    def enhanced_wall_treatment(self, *args, **kwargs):
                        """
                        Enable/disable enhanced wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/enhanced_wall_treatment").execute(*args, **kwargs)
                    def scalable_wall_functions(self, *args, **kwargs):
                        """
                        Enable/disable scalable wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/scalable_wall_functions").execute(*args, **kwargs)
                    def wf_thermal_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function thermal effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_thermal_effects").execute(*args, **kwargs)
                    def wf_pressure_gradient_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function pressure-gradient effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_pressure_gradient_effects").execute(*args, **kwargs)
                    def user_defined_wall_functions(self, *args, **kwargs):
                        """
                        Enable user defined wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/user_defined_wall_functions").execute(*args, **kwargs)
                    def non_equilibrium_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable non-equilibrium wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/non_equilibrium_wall_fn").execute(*args, **kwargs)

                class turbulence_expert(TUIMenu):
                    """
                    Enter the turbulence expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def production_limiter(self, *args, **kwargs):
                        """
                        Enable/disable the Production Limiter.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/production_limiter").execute(*args, **kwargs)
                    def kw_add_sas(self, *args, **kwargs):
                        """
                        Enable/disable the SAS-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_sas").execute(*args, **kwargs)
                    def low_re_ke(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke").execute(*args, **kwargs)
                    def non_newtonian_modification(self, *args, **kwargs):
                        """
                        Enable/disable non-Newtonian modification for Lam-Bremhorst model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/non_newtonian_modification").execute(*args, **kwargs)
                    def sbes_les_subgrid_dynamic_fvar(self, *args, **kwargs):
                        """
                        Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                    def turb_add_sbes_sdes(self, *args, **kwargs):
                        """
                        Enable/disable SBES / SDES with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_add_sbes_sdes").execute(*args, **kwargs)
                    def low_re_ke_index(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon model version.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke_index").execute(*args, **kwargs)
                    def sbes_update_interval_k_omega(self, *args, **kwargs):
                        """
                        Set an integer value how often the k and omega equations are updated in a transient SBES run.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_update_interval_k_omega").execute(*args, **kwargs)
                    def turb_pk_compressible(self, *args, **kwargs):
                        """
                        Enable/disable turbulent production due to compressible divergence.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_pk_compressible").execute(*args, **kwargs)
                    def sbes_sdes_hybrid_model(self, *args, **kwargs):
                        """
                        Select the SBES / SDES hybrid model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sdes_hybrid_model").execute(*args, **kwargs)
                    def kw_add_des(self, *args, **kwargs):
                        """
                        Enable/disable DES-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_des").execute(*args, **kwargs)
                    def kw_vorticity_based_production(self, *args, **kwargs):
                        """
                        Enable/disable vorticity based production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_vorticity_based_production").execute(*args, **kwargs)
                    def kato_launder_model(self, *args, **kwargs):
                        """
                        Enable/disable Kato-Launder modification for production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kato_launder_model").execute(*args, **kwargs)
                    def sbes_sgs_option(self, *args, **kwargs):
                        """
                        Select SBES subgrid-scale model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sgs_option").execute(*args, **kwargs)
                    def thermal_p_function(self, *args, **kwargs):
                        """
                        Enable/disable the Jayatilleke P function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/thermal_p_function").execute(*args, **kwargs)
                    def turb_non_newtonian(self, *args, **kwargs):
                        """
                        Enable/disable turbulence for non-Newtonian fluids.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_non_newtonian").execute(*args, **kwargs)
                    def restore_sst_v61(self, *args, **kwargs):
                        """
                        Enable/disable SST formulation of v6.1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/restore_sst_v61").execute(*args, **kwargs)
                    def rke_cmu_rotation_term(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of omega in the Cmu definition.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/rke_cmu_rotation_term").execute(*args, **kwargs)
                    def turbulence_damping(self, *args, **kwargs):
                        """
                        Enable/disable turbulence damping and set turbulence damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turbulence_damping").execute(*args, **kwargs)

                class geko_options(TUIMenu):
                    """
                    Enter the GEKO options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def cbf_lam(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_LAM.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_lam").execute(*args, **kwargs)
                    def blending_function(self, *args, **kwargs):
                        """
                        Set the GEKO model blending function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/blending_function").execute(*args, **kwargs)
                    def cbf_tur(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_TUR.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_tur").execute(*args, **kwargs)
                    def cjet(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet").execute(*args, **kwargs)
                    def cmix(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CMIX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cmix").execute(*args, **kwargs)
                    def cnw_sub(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW_SUB.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw_sub").execute(*args, **kwargs)
                    def cnw(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw").execute(*args, **kwargs)
                    def wall_distance_free(self, *args, **kwargs):
                        """
                        Enable/disable wall-distance-free version of GEKO model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/wall_distance_free").execute(*args, **kwargs)
                    def geko_defaults(self, *args, **kwargs):
                        """
                        Set GEKO options to default.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/geko_defaults").execute(*args, **kwargs)
                    def csep(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CSEP.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/csep").execute(*args, **kwargs)
                    def cjet_aux(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET_AUX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet_aux").execute(*args, **kwargs)
                    def creal(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CREAL.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/creal").execute(*args, **kwargs)

                class transition_model_options(TUIMenu):
                    """
                    Enter the transition model options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rec_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c1").execute(*args, **kwargs)
                    def cfpg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_lowtu").execute(*args, **kwargs)
                    def capg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_hightu").execute(*args, **kwargs)
                    def cbubble_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c2").execute(*args, **kwargs)
                    def capg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_lowtu").execute(*args, **kwargs)
                    def rec_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c2").execute(*args, **kwargs)
                    def ctu_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_lowtu").execute(*args, **kwargs)
                    def rv1_switch(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient RV1_SWITCH.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rv1_switch").execute(*args, **kwargs)
                    def critical_reynolds_number_correlation(self, *args, **kwargs):
                        """
                        Set the critical Reynolds number correlation.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/critical_reynolds_number_correlation").execute(*args, **kwargs)
                    def ctu_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_hightu").execute(*args, **kwargs)
                    def clambda_scale(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CLAMBDA_SCALE.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/clambda_scale").execute(*args, **kwargs)
                    def cfpg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_hightu").execute(*args, **kwargs)
                    def rec_max(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_MAX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_max").execute(*args, **kwargs)
                    def crossflow_transition(self, *args, **kwargs):
                        """
                        Enable/disable crossflow transition for the intermittency transition model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/crossflow_transition").execute(*args, **kwargs)
                    def cbubble_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c1").execute(*args, **kwargs)

            class soot_parameters(TUIMenu):
                """
                Enter the soot parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def modify_schmidt_number(self, *args, **kwargs):
                    """
                    Change Turbulent Schmidt Number for Soot/Nuclei Equations.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/modify_schmidt_number").execute(*args, **kwargs)
                def soot_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set Soot-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_turbulence_interaction").execute(*args, **kwargs)
                def soot_model_udfs(self, *args, **kwargs):
                    """
                    User defined functions for soot model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_model_udfs").execute(*args, **kwargs)
                def soot_process_parameters(self, *args, **kwargs):
                    """
                    Set soot process parameters.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_process_parameters").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/inlet_diffusion").execute(*args, **kwargs)
                def soot_model_parameters(self, *args, **kwargs):
                    """
                    Enter the soot model parameters menu.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_model_parameters").execute(*args, **kwargs)
                def soot_radiation_interaction(self, *args, **kwargs):
                    """
                    Enable/disable the soot-radiation interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_radiation_interaction").execute(*args, **kwargs)

            class species(TUIMenu):
                """
                Enter the species models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.CHEMKIN_CFD_parameters = self.__class__.CHEMKIN_CFD_parameters(path + ["CHEMKIN_CFD_parameters"], service)
                    super().__init__(path, service)
                def electro_chemical_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable electrochemical surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/electro_chemical_surface_reactions").execute(*args, **kwargs)
                def mass_deposition_source(self, *args, **kwargs):
                    """
                    Enable/disable mass deposition source due to surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/mass_deposition_source").execute(*args, **kwargs)
                def set_premixed_combustion(self, *args, **kwargs):
                    """
                    Set premixed combustion parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_premixed_combustion").execute(*args, **kwargs)
                def pdf_transport_expert(self, *args, **kwargs):
                    """
                    Enable/disable PDF transport expert user.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport_expert").execute(*args, **kwargs)
                def init_unsteady_flamelet_prob(self, *args, **kwargs):
                    """
                    Initialize Unsteady Flamelet Probability.
                    """
                    return PyMenu(self.service, "/setup/models/species/init_unsteady_flamelet_prob").execute(*args, **kwargs)
                def liquid_micro_mixing(self, *args, **kwargs):
                    """
                    Enable/disable liquid micro mixing option.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_micro_mixing").execute(*args, **kwargs)
                def partially_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_parameters").execute(*args, **kwargs)
                def mixing_model(self, *args, **kwargs):
                    """
                    Set PDF transport mixing model.
                    """
                    return PyMenu(self.service, "/setup/models/species/mixing_model").execute(*args, **kwargs)
                def species_migration(self, *args, **kwargs):
                    """
                    Enable/disable ion species migration in electric field.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_migration").execute(*args, **kwargs)
                def premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_combustion").execute(*args, **kwargs)
                def reactor_network_model(self, *args, **kwargs):
                    """
                    Enable/disable the Reactor Network model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reactor_network_model").execute(*args, **kwargs)
                def non_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the non-premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion").execute(*args, **kwargs)
                def combustion_expert(self, *args, **kwargs):
                    """
                    Set combustion expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_expert").execute(*args, **kwargs)
                def pdf_transport(self, *args, **kwargs):
                    """
                    Enable/disable the composition PDF transport combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport").execute(*args, **kwargs)
                def multicomponent_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable multicomponent diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/multicomponent_diffusion").execute(*args, **kwargs)
                def inert_transport_model(self, *args, **kwargs):
                    """
                    Enable/disable the inert transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_model").execute(*args, **kwargs)
                def surf_reaction_aggressiveness_factor(self, *args, **kwargs):
                    """
                    Set the surface reaction aggressiveness factor.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_aggressiveness_factor").execute(*args, **kwargs)
                def set_multi_regime_fgm(self, *args, **kwargs):
                    """
                    Set-multi-regim-fgm-parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_multi_regime_fgm").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/species/inlet_diffusion").execute(*args, **kwargs)
                def ignition_model(self, *args, **kwargs):
                    """
                    Enable/disable the ignition model.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model").execute(*args, **kwargs)
                def CHEMKIN_CFD(self, *args, **kwargs):
                    """
                    Enable/disable CHEMKIN-CFD.
                    """
                    return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD").execute(*args, **kwargs)
                def full_tabulation(self, *args, **kwargs):
                    """
                    Enable/disable building of a full 2 mixture fraction table.
                    """
                    return PyMenu(self.service, "/setup/models/species/full_tabulation").execute(*args, **kwargs)
                def clear_isat_table(self, *args, **kwargs):
                    """
                    Clear the ISAT table.
                    """
                    return PyMenu(self.service, "/setup/models/species/clear_isat_table").execute(*args, **kwargs)
                def spark_model(self, *args, **kwargs):
                    """
                    Set spark model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/spark_model").execute(*args, **kwargs)
                def re_calc_par_premix_props(self, *args, **kwargs):
                    """
                    Re-calculate partially-premixed properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/re_calc_par_premix_props").execute(*args, **kwargs)
                def flamelet_expert(self, *args, **kwargs):
                    """
                    Set flamelet expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/flamelet_expert").execute(*args, **kwargs)
                def non_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_expert").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable solution of species models.
                    """
                    return PyMenu(self.service, "/setup/models/species/off").execute(*args, **kwargs)
                def stiff_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable stiff chemistry option.
                    """
                    return PyMenu(self.service, "/setup/models/species/stiff_chemistry").execute(*args, **kwargs)
                def inert_transport_controls(self, *args, **kwargs):
                    """
                    Set inert transport model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_controls").execute(*args, **kwargs)
                def partially_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable partially premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion").execute(*args, **kwargs)
                def diffusion_energy_source(self, *args, **kwargs):
                    """
                    Enable/disable diffusion energy source.
                    """
                    return PyMenu(self.service, "/setup/models/species/diffusion_energy_source").execute(*args, **kwargs)
                def wall_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable wall surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/wall_surface_reactions").execute(*args, **kwargs)
                def liquid_energy_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable energy diffusion for liquid regime.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_energy_diffusion").execute(*args, **kwargs)
                def save_gradients(self, *args, **kwargs):
                    """
                    Enable/disable storage of species mass fraction gradients.
                    """
                    return PyMenu(self.service, "/setup/models/species/save_gradients").execute(*args, **kwargs)
                def premixed_model(self, *args, **kwargs):
                    """
                    Set premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_model").execute(*args, **kwargs)
                def partially_premixed_combustion_grids(self, *args, **kwargs):
                    """
                    Set user specified grid parameters for PDF and flamelet.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_grids").execute(*args, **kwargs)
                def combustion_numerics(self, *args, **kwargs):
                    """
                    Set combustion numerics options.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_numerics").execute(*args, **kwargs)
                def reacting_channel_model_options(self, *args, **kwargs):
                    """
                    Set Reacting Channel Model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model_options").execute(*args, **kwargs)
                def partially_premixed_properties(self, *args, **kwargs):
                    """
                    Set/Change partially premixed mixture properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_properties").execute(*args, **kwargs)
                def relax_to_equil(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/relax_to_equil").execute(*args, **kwargs)
                def partially_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_expert").execute(*args, **kwargs)
                def thickened_flame_model(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/thickened_flame_model").execute(*args, **kwargs)
                def ignition_model_controls(self, *args, **kwargs):
                    """
                    Set ignition model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model_controls").execute(*args, **kwargs)
                def thermal_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable thermal diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/thermal_diffusion").execute(*args, **kwargs)
                def epdf_energy(self, *args, **kwargs):
                    """
                    Enable/disable EPDF energy  option.
                    """
                    return PyMenu(self.service, "/setup/models/species/epdf_energy").execute(*args, **kwargs)
                def integration_parameters(self, *args, **kwargs):
                    """
                    Set ISAT parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/integration_parameters").execute(*args, **kwargs)
                def set_turb_chem_interaction(self, *args, **kwargs):
                    """
                    Set Eddy-Dissipation Concept model constants.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_turb_chem_interaction").execute(*args, **kwargs)
                def decoupled_detailed_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable the Decoupled Detailed Chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/species/decoupled_detailed_chemistry").execute(*args, **kwargs)
                def volumetric_reactions(self, *args, **kwargs):
                    """
                    Enable/disable volumetric reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/volumetric_reactions").execute(*args, **kwargs)
                def reaction_diffusion_balance(self, *args, **kwargs):
                    """
                    Enable/disable reaction diffusion balance at reacting surface for surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/reaction_diffusion_balance").execute(*args, **kwargs)
                def species_transport_expert(self, *args, **kwargs):
                    """
                    Set species transport expert options.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport_expert").execute(*args, **kwargs)
                def coal_calculator(self, *args, **kwargs):
                    """
                    Set up coal modeling inputs.
                    """
                    return PyMenu(self.service, "/setup/models/species/coal_calculator").execute(*args, **kwargs)
                def particle_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable particle surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/particle_surface_reactions").execute(*args, **kwargs)
                def heat_of_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable heat of surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/heat_of_surface_reactions").execute(*args, **kwargs)
                def import_flamelet_for_restart(self, *args, **kwargs):
                    """
                    Import Flamelet File for Restart.
                    """
                    return PyMenu(self.service, "/setup/models/species/import_flamelet_for_restart").execute(*args, **kwargs)
                def surf_reaction_netm_params(self, *args, **kwargs):
                    """
                    Set the surface reaction parameters for the Non-Equilibrium Thermal Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_netm_params").execute(*args, **kwargs)
                def species_transport(self, *args, **kwargs):
                    """
                    Enable/disable the species transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport").execute(*args, **kwargs)
                def reacting_channel_model(self, *args, **kwargs):
                    """
                    Enable/Disable the Reacting Channel Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model").execute(*args, **kwargs)
                def non_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_parameters").execute(*args, **kwargs)

                class CHEMKIN_CFD_parameters(TUIMenu):
                    """
                    Enter the expert CHEMKIN-CFD parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def basic_options(self, *args, **kwargs):
                        """
                        Set basic parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/basic_options").execute(*args, **kwargs)
                    def add_cell_monitor(self, *args, **kwargs):
                        """
                        Add a monitor cell for debug output.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/add_cell_monitor").execute(*args, **kwargs)
                    def advanced_options(self, *args, **kwargs):
                        """
                        Set advanced parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/advanced_options").execute(*args, **kwargs)
                    def list_cell_monitors(self, *args, **kwargs):
                        """
                        List cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/list_cell_monitors").execute(*args, **kwargs)
                    def delete_cell_monitors(self, *args, **kwargs):
                        """
                        Delete cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/delete_cell_monitors").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enter the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    super().__init__(path, service)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/setup/models/structure/thermal_effects").execute(*args, **kwargs)
                def structure_off(self, *args, **kwargs):
                    """
                    Disable the structural model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/structure_off").execute(*args, **kwargs)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enable the linear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/linear_elasticity").execute(*args, **kwargs)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/nonlinear_elasticity").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of viscous fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enable explicit fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of operating p into fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enter the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Set structure damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/amg_stabilization").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/max_iter").execute(*args, **kwargs)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/enhanced_strain").execute(*args, **kwargs)

            class acoustics(TUIMenu):
                """
                Enter the acoustics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.sources_fft = self.__class__.sources_fft(path + ["sources_fft"], service)
                    self.far_field_parameters = self.__class__.far_field_parameters(path + ["far_field_parameters"], service)
                    self.sponge_layers = self.__class__.sponge_layers(path + ["sponge_layers"], service)
                    self.wave_equation_options = self.__class__.wave_equation_options(path + ["wave_equation_options"], service)
                    super().__init__(path, service)
                def display_flow_time(self, *args, **kwargs):
                    """
                    Enable/disable the display of flow time during read-and-compute.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/display_flow_time").execute(*args, **kwargs)
                def cylindrical_export(self, *args, **kwargs):
                    """
                    Enable/disable the export data in cylindrical coordinates.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/cylindrical_export").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable the acoustics model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/off").execute(*args, **kwargs)
                def sources(self, *args, **kwargs):
                    """
                    Set acoustic sources.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/sources").execute(*args, **kwargs)
                def export_source_data_cgns(self, *args, **kwargs):
                    """
                    Export acoustic source data in CGNS format.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_source_data_cgns").execute(*args, **kwargs)
                def display_frequencies(self, *args, **kwargs):
                    """
                    Display resonance frequencies.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/display_frequencies").execute(*args, **kwargs)
                def broad_band_noise(self, *args, **kwargs):
                    """
                    Enable/disable the broadband noise model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/broad_band_noise").execute(*args, **kwargs)
                def write_centroid_info(self, *args, **kwargs):
                    """
                    Write centroid info.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/write_centroid_info").execute(*args, **kwargs)
                def auto_prune(self, *args, **kwargs):
                    """
                    Enable/disable auto prune of the receiver signal(s) during read-and-compute.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/auto_prune").execute(*args, **kwargs)
                def read_compute_write(self, *args, **kwargs):
                    """
                    Read acoustic source data files and compute sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/read_compute_write").execute(*args, **kwargs)
                def export_volumetric_sources(self, *args, **kwargs):
                    """
                    Enable/disable the export of fluid zones.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_volumetric_sources").execute(*args, **kwargs)
                def write_acoustic_signals(self, *args, **kwargs):
                    """
                    Write on-the-fly sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/write_acoustic_signals").execute(*args, **kwargs)
                def export_source_data(self, *args, **kwargs):
                    """
                    Enable export acoustic source data in ASD format during the wave equation model run.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_source_data").execute(*args, **kwargs)
                def acoustic_modal_analysis(self, *args, **kwargs):
                    """
                    Iterate linear acoustic solver to compute the resonance frequencies and the acoustic modes.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/acoustic_modal_analysis").execute(*args, **kwargs)
                def ffowcs_williams(self, *args, **kwargs):
                    """
                    Enable/disable the Ffowcs-Williams-and-Hawkings model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/ffowcs_williams").execute(*args, **kwargs)
                def wave_equation(self, *args, **kwargs):
                    """
                    Enable/disable the wave equation model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/wave_equation").execute(*args, **kwargs)
                def moving_receiver(self, *args, **kwargs):
                    """
                    Enable/disable moving receiver option.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/moving_receiver").execute(*args, **kwargs)
                def export_volumetric_sources_cgns(self, *args, **kwargs):
                    """
                    Enable/disable the export of fluid zones.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_volumetric_sources_cgns").execute(*args, **kwargs)
                def receivers(self, *args, **kwargs):
                    """
                    Set acoustic receivers.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/receivers").execute(*args, **kwargs)
                def compute_write(self, *args, **kwargs):
                    """
                    Compute sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/compute_write").execute(*args, **kwargs)
                def modal_analysis(self, *args, **kwargs):
                    """
                    Enable/disable the modal analysis model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/modal_analysis").execute(*args, **kwargs)
                def convective_effects(self, *args, **kwargs):
                    """
                    Enable/disable convective effects option.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/convective_effects").execute(*args, **kwargs)

                class sources_fft(TUIMenu):
                    """
                    Enter the acoustic sources FFT menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.fft_surface_variables = self.__class__.fft_surface_variables(path + ["fft_surface_variables"], service)
                        super().__init__(path, service)
                    def read_asd_files(self, *args, **kwargs):
                        """
                        Read ASD files.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/read_asd_files").execute(*args, **kwargs)
                    def write_cgns_files(self, *args, **kwargs):
                        """
                        Write CGNS files.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/write_cgns_files").execute(*args, **kwargs)
                    def clean_up_storage_area(self, *args, **kwargs):
                        """
                        Clean up storage area.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/clean_up_storage_area").execute(*args, **kwargs)
                    def compute_fft_fields(self, *args, **kwargs):
                        """
                        Compute FFT fields.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/compute_fft_fields").execute(*args, **kwargs)

                    class fft_surface_variables(TUIMenu):
                        """
                        Enter the FFT surface variables menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def remove_variables(self, *args, **kwargs):
                            """
                            Remove variables.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/remove_variables").execute(*args, **kwargs)
                        def create_set_of_modes(self, *args, **kwargs):
                            """
                            Create set of modes.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_set_of_modes").execute(*args, **kwargs)
                        def create_octave_bands(self, *args, **kwargs):
                            """
                            Create octave bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_octave_bands").execute(*args, **kwargs)
                        def create_constant_width_bands(self, *args, **kwargs):
                            """
                            Create constant-width bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_constant_width_bands").execute(*args, **kwargs)
                        def create_third_bands(self, *args, **kwargs):
                            """
                            Create third bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_third_bands").execute(*args, **kwargs)

                class far_field_parameters(TUIMenu):
                    """
                    Enter the far field parameters menu for the wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def far_field_sound_speed(self, *args, **kwargs):
                        """
                        Specify far field speed of sound.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/far_field_parameters/far_field_sound_speed").execute(*args, **kwargs)
                    def far_field_density(self, *args, **kwargs):
                        """
                        Specify far field density.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/far_field_parameters/far_field_density").execute(*args, **kwargs)

                class sponge_layers(TUIMenu):
                    """
                    Manage sponge layers where density is blended to eliminate reflections from boundary zon