import { IDisposable } from "@phosphor/disposable";
import { ICommandPalette } from "@jupyterlab/apputils";
import { DocumentRegistry } from "@jupyterlab/docregistry";
import { INotebookModel, NotebookPanel } from "@jupyterlab/notebook";
import { ILayoutRestorer, JupyterFrontEnd, JupyterFrontEndPlugin } from "@jupyterlab/application";
import { IDocumentManager } from "@jupyterlab/docmanager";
import { IFileBrowserFactory } from "@jupyterlab/filebrowser";
import { ILauncher } from "@jupyterlab/launcher";
import { IMainMenu } from "@jupyterlab/mainmenu";
import { Widget } from "@phosphor/widgets";
import "../style/index.css";
declare const extension: JupyterFrontEndPlugin<void>;
export declare class AutoversionWidget extends Widget {
    constructor(app: JupyterFrontEnd, context: DocumentRegistry.IContext<INotebookModel>, id: string, path: string);
    getValue(): string;
    readonly inputNode: HTMLSelectElement;
}
export declare function autoversion(app: JupyterFrontEnd, context: DocumentRegistry.IContext<INotebookModel>): void;
export declare function revision(app: JupyterFrontEnd, context: DocumentRegistry.IContext<INotebookModel>, id: string, version: string): void;
export declare class AutoversionExtension implements DocumentRegistry.IWidgetExtension<NotebookPanel, INotebookModel> {
    readonly app: JupyterFrontEnd;
    constructor(app: JupyterFrontEnd);
    createNew(panel: NotebookPanel, context: DocumentRegistry.IContext<INotebookModel>): IDisposable;
}
declare function activate(app: JupyterFrontEnd, docManager: IDocumentManager, palette: ICommandPalette, restorer: ILayoutRestorer, mainMenu: IMainMenu, browser: IFileBrowserFactory, launcher: ILauncher | null): void;
export default extension;
export { activate as _activate };
