# Generated by Django 4.1.1 on 2022-09-22 11:49

from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Branch',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=200)),
                ('location', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('is_default', models.BooleanField(default=False)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
            ],
            options={
                'ordering': ['-created_at'],
                'permissions': (('access_branch', 'Access'), ('detail_branch', 'View'), ('view_branch', 'List'), ('change_branch', 'Edit'), ('delete_branch', 'Delete'), ('add_branch', 'Create')),
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='CustomGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(blank=True, max_length=150, null=True, verbose_name='name')),
                ('description', models.TextField(blank=True, null=True)),
                ('is_default', models.BooleanField(default=False)),
            ],
            options={
                'verbose_name': 'Group',
                'verbose_name_plural': 'Groups',
                'ordering': ['-created_at'],
                'permissions': (('access_customgroup', 'Access'), ('detail_customgroup', 'View'), ('view_customgroup', 'List'), ('change_customgroup', 'Edit'), ('delete_customgroup', 'Delete'), ('add_customgroup', 'Create')),
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='Organisation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('address', models.TextField(blank=True, null=True)),
                ('country', models.CharField(blank=True, max_length=50, null=True)),
            ],
            options={
                'ordering': ['-created_at'],
                'permissions': (('access_organisation', 'Access'), ('detail_organisation', 'View'), ('view_organisation', 'List'), ('change_organisation', 'Edit'), ('delete_organisation', 'Delete'), ('add_organisation', 'Create')),
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(blank=True, max_length=256, null=True, verbose_name='Username')),
                ('email', models.EmailField(max_length=60, unique=True, verbose_name='Email')),
                ('first_name', models.CharField(blank=True, max_length=256, null=True, verbose_name='First Name')),
                ('last_name', models.CharField(blank=True, max_length=256, null=True, verbose_name='Last Name')),
                ('mobile', phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True, region=None, unique=True, verbose_name='Mobile Number')),
                ('is_active', models.BooleanField(default=True)),
                ('is_staff', models.BooleanField(default=False)),
                ('is_org_staff', models.BooleanField(default=False)),
                ('is_owner', models.BooleanField(default=False)),
                ('is_customer', models.BooleanField(default=False)),
                ('is_reseller', models.BooleanField(default=False)),
                ('is_verified', models.BooleanField(default=False)),
                ('is_accepted', models.BooleanField(default=False)),
                ('date_joined', models.DateTimeField(auto_now_add=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='cleverstack_auth.customgroup', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_permissions', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'ordering': ['-created_at'],
                'permissions': (('access_user', 'Access'), ('detail_user', 'View'), ('view_user', 'List'), ('change_user', 'Edit'), ('delete_user', 'Delete'), ('add_user', 'Create')),
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='Role',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=100)),
                ('share_data', models.BooleanField(default=False)),
                ('description', models.TextField(blank=True, null=True)),
                ('is_default', models.BooleanField(default=False)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cleverstack_auth.user')),
                ('organisation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='cleverstack_auth.organisation')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='cleverstack_auth.role')),
            ],
            options={
                'ordering': ['-created_at'],
                'permissions': (('access_role', 'Access'), ('detail_role', 'View'), ('view_role', 'List'), ('change_role', 'Edit'), ('delete_role', 'Delete'), ('add_role', 'Create')),
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='GenerateToken',
            fields=[
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('key', models.CharField(db_index=True, max_length=64, unique=True, verbose_name='Key')),
                ('ip_address', models.GenericIPAddressField(blank=True, default='', null=True, verbose_name='The IP address of this session')),
                ('user_agent', models.CharField(blank=True, default='', max_length=256, verbose_name='HTTP User Agent')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='custom_password_reset_tokens', to='cleverstack_auth.user', verbose_name='The User which is associated to this password reset tokens')),
            ],
            options={
                'verbose_name': 'Password Reset Token',
                'verbose_name_plural': 'Password Reset Tokens',
                'ordering': ['-created_at'],
                'permissions': (('access_generatetoken', 'Access'), ('detail_generatetoken', 'View'), ('view_generatetoken', 'List'), ('change_generatetoken', 'Edit'), ('delete_generatetoken', 'Delete'), ('add_generatetoken', 'Create')),
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=200)),
                ('description', models.TextField(blank=True, null=True)),
                ('lft', models.PositiveIntegerField(editable=False)),
                ('rght', models.PositiveIntegerField(editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(editable=False)),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='departments', to='cleverstack_auth.branch')),
                ('manager', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='department_manager', to='cleverstack_auth.user')),
                ('organisation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='branch_departments', to='cleverstack_auth.organisation')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cleverstack_auth.department')),
            ],
            options={
                'ordering': ['-created_at'],
                'permissions': (('access_department', 'Access'), ('detail_department', 'View'), ('view_department', 'List'), ('change_department', 'Edit'), ('delete_department', 'Delete'), ('add_department', 'Create')),
                'default_permissions': [],
            },
        ),
        migrations.AddField(
            model_name='customgroup',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='groups_created_by', to='cleverstack_auth.user'),
        ),
        migrations.AddField(
            model_name='customgroup',
            name='default_permissions',
            field=models.ManyToManyField(blank=True, related_name='default_permissions', to='auth.permission'),
        ),
        migrations.AddField(
            model_name='customgroup',
            name='organisation',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='org_groups', to='cleverstack_auth.organisation'),
        ),
        migrations.AddField(
            model_name='customgroup',
            name='permissions',
            field=models.ManyToManyField(blank=True, related_name='permissions', to='auth.permission', verbose_name='permissions'),
        ),
        migrations.AddField(
            model_name='branch',
            name='manager',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='branch_managers', to='cleverstack_auth.user'),
        ),
        migrations.AddField(
            model_name='branch',
            name='organisation',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='org_branches', to='cleverstack_auth.organisation'),
        ),
        migrations.AddField(
            model_name='branch',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cleverstack_auth.branch'),
        ),
        migrations.CreateModel(
            name='BillingDetail',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
                ('mobile', phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True, region=None)),
                ('country', models.CharField(blank=True, max_length=255, null=True)),
                ('city', models.CharField(blank=True, max_length=255, null=True)),
                ('state', models.CharField(blank=True, max_length=255, null=True)),
                ('street_address', models.CharField(blank=True, max_length=255, null=True)),
                ('zip_code', models.CharField(blank=True, max_length=255, null=True)),
                ('organisation', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cleverstack_auth.organisation')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='user_billing_details', to='cleverstack_auth.user')),
            ],
            options={
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='APISettings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('title', models.CharField(max_length=1000)),
                ('apikey', models.CharField(blank=True, max_length=16)),
                ('website', models.URLField(default='', max_length=255)),
                ('created_by', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='settings_created_by', to='cleverstack_auth.user')),
                ('lead_assigned_to', models.ManyToManyField(related_name='lead_assignee_users', to='cleverstack_auth.user')),
                ('org', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cleverstack_auth.organisation')),
            ],
            options={
                'ordering': ['-created_at'],
                'permissions': (('access_apisettings', 'Access'), ('detail_apisettings', 'View'), ('view_apisettings', 'List'), ('change_apisettings', 'Edit'), ('delete_apisettings', 'Delete'), ('add_apisettings', 'Create')),
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to='user_images')),
                ('phone', phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True, region=None, unique=True)),
                ('alternate_phone', phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True, region=None)),
                ('is_active', models.BooleanField(default=True)),
                ('date_of_joining', models.DateField(auto_now_add=True, null=True)),
                ('activation_key', models.CharField(blank=True, max_length=150, null=True)),
                ('key_expires', models.DateTimeField(blank=True, null=True)),
                ('branch', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cleverstack_auth.branch')),
                ('department', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='cleverstack_auth.department')),
                ('org', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='cleverstack_auth.organisation')),
                ('role', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='user_role', to='cleverstack_auth.role')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='user_profile', to='cleverstack_auth.user')),
            ],
            options={
                'ordering': ['-created_at'],
                'permissions': (('access_profile', 'Access'), ('detail_profile', 'View'), ('view_profile', 'List'), ('change_profile', 'Edit'), ('delete_profile', 'Delete'), ('add_profile', 'Create')),
                'default_permissions': [],
                'unique_together': {('user', 'org')},
            },
        ),
    ]
