"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineCheckParameterAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codepipeline_1 = require("@aws-cdk/aws-codepipeline");
const aws_codepipeline_actions_1 = require("@aws-cdk/aws-codepipeline-actions");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const check_parameter_function_1 = require("./check-parameter-function");
/**
 * Represents a reference to a CodePipelineCheckParameterAction.
 */
class CodePipelineCheckParameterAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.INVOKE,
            provider: 'Lambda',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 0,
                minOutputs: 0,
                maxOutputs: 0,
            },
        });
        this.props = props;
    }
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     */
    bound(scope, _stage, options) {
        const { parameterName, regExp, logParameter = false, crossAccountRole } = this.props;
        const checkParameterFunction = new check_parameter_function_1.CheckParameterFunction(scope, 'CheckParamterFunction', {
            parameterName,
            crossAccountRole,
        });
        // allow pipeline to list functions
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:ListFunctions'],
            resources: ['*'],
        }));
        // allow pipeline to invoke this lambda functionn
        options.role.addToPolicy(new aws_iam_1.PolicyStatement({
            actions: ['lambda:InvokeFunction'],
            resources: [checkParameterFunction.functionArn],
        }));
        // allow lambda to put job results for this pipeline
        // CodePipeline requires this to be granted to '*'
        // (the Pipeline ARN will not be enough)
        checkParameterFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['codepipeline:PutJobSuccessResult', 'codepipeline:PutJobFailureResult'],
        }));
        return {
            configuration: {
                FunctionName: checkParameterFunction.functionName,
                UserParameters: core_1.Stack.of(scope).toJsonString({
                    parameterName,
                    regExp: regExp ? regExp.source : undefined,
                    logParameter,
                    crossAccountRole,
                }),
            },
        };
    }
}
exports.CodePipelineCheckParameterAction = CodePipelineCheckParameterAction;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineCheckParameterAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-check-parameter-action.CodePipelineCheckParameterAction", version: "1.25.1" };
//# sourceMappingURL=data:application/json;base64,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