# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_stomp_debug_callback']

package_data = \
{'': ['*']}

install_requires = \
['django', 'django-stomp>=5.0.0,<6.0.0']

setup_kwargs = {
    'name': 'django-stomp-debug-callback',
    'version': '1.0.0',
    'description': 'A simple view to help know what the callback is doing on django-stomp usage',
    'long_description': '# Django stomp debug callback\n\n[![Build Status](https://dev.azure.com/juntos-somos-mais-loyalty/python/_apis/build/status/django-stomp-debug-callback?branchName=master)](https://dev.azure.com/juntos-somos-mais-loyalty/python/_build/latest?definitionId=272&branchName=master)\n[![Maintainability](https://sonarcloud.io/api/project_badges/measure?project=juntossomosmais_django-stomp-debug-callback&metric=sqale_rating)](https://sonarcloud.io/dashboard?id=juntossomosmais_django-stomp-debug-callback)\n[![Test Coverage](https://sonarcloud.io/api/project_badges/measure?project=juntossomosmais_django-stomp-debug-callback&metric=coverage)](https://sonarcloud.io/dashboard?id=juntossomosmais_django-stomp-debug-callback)\n[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=juntossomosmais_django-stomp-debug-callback&metric=alert_status&token=edc3f4783b528b9c532e571bd14551c754b01d98)](https://sonarcloud.io/summary/new_code?id=juntossomosmais_django-stomp-debug-callback)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n[![PyPI version](https://badge.fury.io/py/django-stomp-debug-callback.svg)](https://badge.fury.io/py/django-stomp-debug-callback)\n[![GitHub](https://img.shields.io/github/license/mashape/apistatus.svg)](https://github.com/juntossomosmais/django-stomp-debug-callback/blob/master/LICENSE)\n\nThis functionality helps you comprehend and enhance your callback code used with the [Django STOMP](https://github.com/juntossomosmais/django-stomp) library.\n\nAs this project uses a [view](./django_stomp_debug_callback/views.py) to call your callback function, it\'s possible to extract quite essential data that you can use to optimize your implementation.\n\nSee an example of this approach in action thanks to [Django Debug Toolbar](https://django-debug-toolbar.readthedocs.io/en/latest/):\n\n![Django callback view utilization](docs/example.gif?raw=true)\n\n####  Installation\npip install `django-stomp-debug-callback`\n\n#### Django stomp debug callback configuration\n\nBasically the configuration is simple, just insert the `django_stomp_debug_callback` on `INSTALLED_APPS` and \nin your application\'s `urls` code include the debug callback view route.\n```python\nfrom django.conf import settings\nif settings.DEBUG:\n    urlpatterns += [\n        path("debug-callback/", include("django_stomp_debug_callback.urls")), # django stomp callback urls\n    ]\n```\n\n* Check if `django-stomp` stay into `INSTALLED_APPS` \n\n#### How to use ?\n\nThis route is a simple `POST` type route that expects to receive some parameters to trigger the callback function.\n\nbody parameter:\n* `callback_function_path`: The path to callback function to be called\n* `payload_body`: payload body to be sent to de callback function\n* `payload_headers`: headers to be sent to de callback function\n\ncurl example\n```curl\ncurl --request POST \\\n  --url http://0.0.0.0:8000/debug-callback/debug-function/ \\\n  --data \'{\n\t"callback_function_path": "path.to.the.callback.function",\n\t"payload_body": {\n\t\t"fake": "body"\n\t},\n\t"payload_headers": {\n\t\t"fake": "headers"\n\t}\n}\'\n```\n\n#### How to use with django-debug-toolbar ?\n\nConfiguration for the [django-debug-toolbar](https://django-debug-toolbar.readthedocs.io/en/latest/) here.\n\n* The first step is [install de django-debug-toolbar](https://django-debug-toolbar.readthedocs.io/en/latest/installation.html) in your app\n```python\npip install django-debug-toolbar\n```\n\n* The second step is to configure the urls (Recommended only insert this rule id `DEBUG` is `True`)\n```python\nfrom django.conf import settings\nif settings.DEBUG:\n    urlpatterns += [\n        path("debug-callback/", include("django_stomp_debug_callback.urls")), # django stomp callback urls\n        path("debug-toolbar/", include("debug_toolbar.urls")) # django debug toolbar\n    ]\n```\n\n* The third step is to check the settings, these settings will include the middleware and debug apps to main settings\n\nin your `.env`\n```shell\n##################\n#### DEBUG LIB CONFIGURATION\nDEBUG_APPS = debug_toolbar,django_stomp_debug_callback\nDEBUG_MIDDLEWARE = debug_toolbar.middleware.DebugToolbarMiddleware\n```\n\nin your `setting`\n```python\nimport os\nDEBUG = True # only to developer mode never in production app\n# DEBUG CONFIGURATION\nif DEBUG:\n    DEBUG_TOOLBAR_CONFIG = {"SHOW_TOOLBAR_CALLBACK": (lambda request: True)}\n    INTERNAL_IPS = ["0.0.0.0"]\n\n    DEBUG_APPS = os.getenv("DEBUG_APPS")\n    if DEBUG_APPS:\n        INSTALLED_APPS += DEBUG_APPS.split(",")\n\n    DEBUG_MIDDLEWARE = os.getenv("DEBUG_MIDDLEWARE")\n    if DEBUG_MIDDLEWARE:\n        MIDDLEWARE += DEBUG_MIDDLEWARE.split(",")\n```\n\nNow you can see the debug panel in your admin url (localhost:8000/admin) and you can choose the route you want to see the requests to the bank in a given view with timing details and explain options and see the most problematic query of your stream.\n\n#### Tests\nYou can run the tests with docker\n\n```shell\ndocker-compose up tests\n```\n\nOr using `tox`\n\n```shell\npipenv run tox\n```\n\n#### Lint + code formatter\nThe use of `.pre-commit-config.yaml` [flake8](https://github.com/pycqa/flake8), [black](https://black.readthedocs.io/en/stable/), [isort](https://pycqa.github.io/isort/) and [pylint](https://pylint.org/). \n\nYou can run the `.pre-commit-config.yaml` with docker\n\n```shell\ndocker-compose up lint-formatter\n```\n\nOr using `pre-commit`\n\n```shell\npre-commit run --all-files\n```',
    'author': 'Juntos Somos Mais',
    'author_email': 'labs@juntossomosmais.com.br',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/juntossomosmais/django-stomp-debug-callback',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
