# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RoaRequest
from aliyunsdksae.endpoint import endpoint_data

class DescribeAppServiceDetailRequest(RoaRequest):

	def __init__(self):
		RoaRequest.__init__(self, 'sae', '2019-05-06', 'DescribeAppServiceDetail','serverless')
		self.set_uri_pattern('/pop/v1/sam/service/describeAppServiceDetail')
		self.set_method('GET')
		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())


	def get_ServiceType(self):
		return self.get_query_params().get('ServiceType')

	def set_ServiceType(self,ServiceType):
		self.add_query_param('ServiceType',ServiceType)

	def get_AppId(self):
		return self.get_query_params().get('AppId')

	def set_AppId(self,AppId):
		self.add_query_param('AppId',AppId)

	def get_ServiceVersion(self):
		return self.get_query_params().get('ServiceVersion')

	def set_ServiceVersion(self,ServiceVersion):
		self.add_query_param('ServiceVersion',ServiceVersion)

	def get_ServiceName(self):
		return self.get_query_params().get('ServiceName')

	def set_ServiceName(self,ServiceName):
		self.add_query_param('ServiceName',ServiceName)

	def get_ServiceGroup(self):
		return self.get_query_params().get('ServiceGroup')

	def set_ServiceGroup(self,ServiceGroup):
		self.add_query_param('ServiceGroup',ServiceGroup)