
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	3250106f          	j	80001b30 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	200000ef          	jal	ra,8000026c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	04051663          	bnez	a0,800000c0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	14408093          	addi	ra,ra,324 # 800001d8 <no_reschedule>
	tail _Fault
8000009c:	1a50106f          	j	80001a40 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
800000ac:	00008297          	auipc	t0,0x8
800000b0:	62828293          	addi	t0,t0,1576 # 800086d4 <_offload_routine>
	lw t1, 0x00(t0)
800000b4:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
800000b8:	00031463          	bnez	t1,800000c0 <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000bc:	0900006f          	j	8000014c <reschedule>

800000c0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000c0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000c4:	00009397          	auipc	t2,0x9
800000c8:	c7838393          	addi	t2,t2,-904 # 80008d3c <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000cc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000d0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000d4:	00512023          	sw	t0,0(sp)

800000d8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000d8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000dc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000e0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000e4:	00030863          	beqz	t1,800000f4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000e8:	00000097          	auipc	ra,0x0
800000ec:	03c08093          	addi	ra,ra,60 # 80000124 <on_thread_stack>
	tail z_irq_do_offload
800000f0:	1dd0106f          	j	80001acc <z_irq_do_offload>

800000f4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000f4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000f8:	800002b7          	lui	t0,0x80000
800000fc:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
80000100:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
80000104:	158000ef          	jal	ra,8000025c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
80000108:	00007297          	auipc	t0,0x7
8000010c:	cd028293          	addi	t0,t0,-816 # 80006dd8 <_image_text_end>
	slli a0, a0, 3
80000110:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000114:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000118:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000011c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000120:	000300e7          	jalr	t1

80000124 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000124:	00009317          	auipc	t1,0x9
80000128:	c1830313          	addi	t1,t1,-1000 # 80008d3c <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000012c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000130:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000134:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000138:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000013c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000140:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000144:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000148:	087e0863          	beq	t3,t2,800001d8 <no_reschedule>

8000014c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000014c:	00009297          	auipc	t0,0x9
80000150:	bf028293          	addi	t0,t0,-1040 # 80008d3c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000154:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000158:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000015c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000160:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000164:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000168:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000016c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000170:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000174:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000178:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000017c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000180:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000184:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000188:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000018c:	00008397          	auipc	t2,0x8
80000190:	4e838393          	addi	t2,t2,1256 # 80008674 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000194:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000198:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000019c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
800001a0:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
800001a4:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
800001a8:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
800001ac:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001b0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001b4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001b8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001bc:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001c0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001c4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001c8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001cc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001d0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001d4:	05832d83          	lw	s11,88(t1)

800001d8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001d8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001dc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001e0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001e4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001e8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001ec:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001f0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001f4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001f8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001fc:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
80000200:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
80000204:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
80000208:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
8000020c:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000210:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000214:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000218:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000021c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000220:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000224:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000228:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000022c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000230:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000234:	30200073          	mret

80000238 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000238:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000023c:	00009297          	auipc	t0,0x9
80000240:	b0028293          	addi	t0,t0,-1280 # 80008d3c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000244:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000248:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000024c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000250:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000254:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000025c:	00100313          	li	t1,1
	sll t0, t1, a0
80000260:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000264:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000268:	00008067          	ret

8000026c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000026c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000270:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000274:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000278:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000027c:	00028463          	beqz	t0,80000284 <not_interrupt>
	addi a0, a0, 1
80000280:	00150513          	addi	a0,a0,1

80000284 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000284:	00008067          	ret

Disassembly of section text:

80000288 <__lshrdi3>:
80000288:	02060063          	beqz	a2,800002a8 <__lshrdi3+0x20>
8000028c:	02000793          	li	a5,32
80000290:	40c787b3          	sub	a5,a5,a2
80000294:	00f04c63          	bgtz	a5,800002ac <__lshrdi3+0x24>
80000298:	fe060513          	addi	a0,a2,-32
8000029c:	00000713          	li	a4,0
800002a0:	00a5d533          	srl	a0,a1,a0
800002a4:	00070593          	mv	a1,a4
800002a8:	00008067          	ret
800002ac:	00c5d733          	srl	a4,a1,a2
800002b0:	00c55533          	srl	a0,a0,a2
800002b4:	00f595b3          	sll	a1,a1,a5
800002b8:	00b56533          	or	a0,a0,a1
800002bc:	fe9ff06f          	j	800002a4 <__lshrdi3+0x1c>

800002c0 <__udivdi3>:
800002c0:	fd010113          	addi	sp,sp,-48
800002c4:	02912223          	sw	s1,36(sp)
800002c8:	01612823          	sw	s6,16(sp)
800002cc:	02112623          	sw	ra,44(sp)
800002d0:	02812423          	sw	s0,40(sp)
800002d4:	03212023          	sw	s2,32(sp)
800002d8:	01312e23          	sw	s3,28(sp)
800002dc:	01412c23          	sw	s4,24(sp)
800002e0:	01512a23          	sw	s5,20(sp)
800002e4:	01712623          	sw	s7,12(sp)
800002e8:	01812423          	sw	s8,8(sp)
800002ec:	01912223          	sw	s9,4(sp)
800002f0:	00050b13          	mv	s6,a0
800002f4:	00058493          	mv	s1,a1
800002f8:	38069c63          	bnez	a3,80000690 <__udivdi3+0x3d0>
800002fc:	00060413          	mv	s0,a2
80000300:	00050993          	mv	s3,a0
80000304:	00007917          	auipc	s2,0x7
80000308:	c6490913          	addi	s2,s2,-924 # 80006f68 <__clz_tab>
8000030c:	12c5f863          	bgeu	a1,a2,8000043c <__udivdi3+0x17c>
80000310:	000107b7          	lui	a5,0x10
80000314:	00058a93          	mv	s5,a1
80000318:	10f67863          	bgeu	a2,a5,80000428 <__udivdi3+0x168>
8000031c:	0ff00693          	li	a3,255
80000320:	00c6b6b3          	sltu	a3,a3,a2
80000324:	00369693          	slli	a3,a3,0x3
80000328:	00d657b3          	srl	a5,a2,a3
8000032c:	00f90933          	add	s2,s2,a5
80000330:	00094703          	lbu	a4,0(s2)
80000334:	00d706b3          	add	a3,a4,a3
80000338:	02000713          	li	a4,32
8000033c:	40d70733          	sub	a4,a4,a3
80000340:	00070c63          	beqz	a4,80000358 <__udivdi3+0x98>
80000344:	00e494b3          	sll	s1,s1,a4
80000348:	00db56b3          	srl	a3,s6,a3
8000034c:	00e61433          	sll	s0,a2,a4
80000350:	0096eab3          	or	s5,a3,s1
80000354:	00eb19b3          	sll	s3,s6,a4
80000358:	01045b13          	srli	s6,s0,0x10
8000035c:	000b0593          	mv	a1,s6
80000360:	000a8513          	mv	a0,s5
80000364:	634000ef          	jal	ra,80000998 <__umodsi3>
80000368:	00050913          	mv	s2,a0
8000036c:	000b0593          	mv	a1,s6
80000370:	01041b93          	slli	s7,s0,0x10
80000374:	000a8513          	mv	a0,s5
80000378:	5d8000ef          	jal	ra,80000950 <__udivsi3>
8000037c:	010bdb93          	srli	s7,s7,0x10
80000380:	00050493          	mv	s1,a0
80000384:	00050593          	mv	a1,a0
80000388:	000b8513          	mv	a0,s7
8000038c:	508000ef          	jal	ra,80000894 <__mulsi3>
80000390:	01091913          	slli	s2,s2,0x10
80000394:	0109d713          	srli	a4,s3,0x10
80000398:	00e96733          	or	a4,s2,a4
8000039c:	00048a13          	mv	s4,s1
800003a0:	00a77e63          	bgeu	a4,a0,800003bc <__udivdi3+0xfc>
800003a4:	00870733          	add	a4,a4,s0
800003a8:	fff48a13          	addi	s4,s1,-1
800003ac:	00876863          	bltu	a4,s0,800003bc <__udivdi3+0xfc>
800003b0:	00a77663          	bgeu	a4,a0,800003bc <__udivdi3+0xfc>
800003b4:	ffe48a13          	addi	s4,s1,-2
800003b8:	00870733          	add	a4,a4,s0
800003bc:	40a704b3          	sub	s1,a4,a0
800003c0:	000b0593          	mv	a1,s6
800003c4:	00048513          	mv	a0,s1
800003c8:	5d0000ef          	jal	ra,80000998 <__umodsi3>
800003cc:	00050913          	mv	s2,a0
800003d0:	000b0593          	mv	a1,s6
800003d4:	00048513          	mv	a0,s1
800003d8:	578000ef          	jal	ra,80000950 <__udivsi3>
800003dc:	01099993          	slli	s3,s3,0x10
800003e0:	00050493          	mv	s1,a0
800003e4:	00050593          	mv	a1,a0
800003e8:	01091913          	slli	s2,s2,0x10
800003ec:	000b8513          	mv	a0,s7
800003f0:	0109d993          	srli	s3,s3,0x10
800003f4:	4a0000ef          	jal	ra,80000894 <__mulsi3>
800003f8:	013969b3          	or	s3,s2,s3
800003fc:	00048613          	mv	a2,s1
80000400:	00a9fc63          	bgeu	s3,a0,80000418 <__udivdi3+0x158>
80000404:	013409b3          	add	s3,s0,s3
80000408:	fff48613          	addi	a2,s1,-1
8000040c:	0089e663          	bltu	s3,s0,80000418 <__udivdi3+0x158>
80000410:	00a9f463          	bgeu	s3,a0,80000418 <__udivdi3+0x158>
80000414:	ffe48613          	addi	a2,s1,-2
80000418:	010a1793          	slli	a5,s4,0x10
8000041c:	00c7e7b3          	or	a5,a5,a2
80000420:	00000a13          	li	s4,0
80000424:	1300006f          	j	80000554 <__udivdi3+0x294>
80000428:	010007b7          	lui	a5,0x1000
8000042c:	01000693          	li	a3,16
80000430:	eef66ce3          	bltu	a2,a5,80000328 <__udivdi3+0x68>
80000434:	01800693          	li	a3,24
80000438:	ef1ff06f          	j	80000328 <__udivdi3+0x68>
8000043c:	00068a13          	mv	s4,a3
80000440:	00061a63          	bnez	a2,80000454 <__udivdi3+0x194>
80000444:	00000593          	li	a1,0
80000448:	00100513          	li	a0,1
8000044c:	504000ef          	jal	ra,80000950 <__udivsi3>
80000450:	00050413          	mv	s0,a0
80000454:	000107b7          	lui	a5,0x10
80000458:	12f47c63          	bgeu	s0,a5,80000590 <__udivdi3+0x2d0>
8000045c:	0ff00793          	li	a5,255
80000460:	0087f463          	bgeu	a5,s0,80000468 <__udivdi3+0x1a8>
80000464:	00800a13          	li	s4,8
80000468:	014457b3          	srl	a5,s0,s4
8000046c:	00f90933          	add	s2,s2,a5
80000470:	00094683          	lbu	a3,0(s2)
80000474:	02000613          	li	a2,32
80000478:	014686b3          	add	a3,a3,s4
8000047c:	40d60633          	sub	a2,a2,a3
80000480:	12061263          	bnez	a2,800005a4 <__udivdi3+0x2e4>
80000484:	408484b3          	sub	s1,s1,s0
80000488:	00100a13          	li	s4,1
8000048c:	01045b13          	srli	s6,s0,0x10
80000490:	000b0593          	mv	a1,s6
80000494:	00048513          	mv	a0,s1
80000498:	500000ef          	jal	ra,80000998 <__umodsi3>
8000049c:	00050913          	mv	s2,a0
800004a0:	000b0593          	mv	a1,s6
800004a4:	00048513          	mv	a0,s1
800004a8:	01041b93          	slli	s7,s0,0x10
800004ac:	4a4000ef          	jal	ra,80000950 <__udivsi3>
800004b0:	010bdb93          	srli	s7,s7,0x10
800004b4:	00050493          	mv	s1,a0
800004b8:	00050593          	mv	a1,a0
800004bc:	000b8513          	mv	a0,s7
800004c0:	3d4000ef          	jal	ra,80000894 <__mulsi3>
800004c4:	01091913          	slli	s2,s2,0x10
800004c8:	0109d713          	srli	a4,s3,0x10
800004cc:	00e96733          	or	a4,s2,a4
800004d0:	00048a93          	mv	s5,s1
800004d4:	00a77e63          	bgeu	a4,a0,800004f0 <__udivdi3+0x230>
800004d8:	00870733          	add	a4,a4,s0
800004dc:	fff48a93          	addi	s5,s1,-1
800004e0:	00876863          	bltu	a4,s0,800004f0 <__udivdi3+0x230>
800004e4:	00a77663          	bgeu	a4,a0,800004f0 <__udivdi3+0x230>
800004e8:	ffe48a93          	addi	s5,s1,-2
800004ec:	00870733          	add	a4,a4,s0
800004f0:	40a704b3          	sub	s1,a4,a0
800004f4:	000b0593          	mv	a1,s6
800004f8:	00048513          	mv	a0,s1
800004fc:	49c000ef          	jal	ra,80000998 <__umodsi3>
80000500:	00050913          	mv	s2,a0
80000504:	000b0593          	mv	a1,s6
80000508:	00048513          	mv	a0,s1
8000050c:	444000ef          	jal	ra,80000950 <__udivsi3>
80000510:	01099993          	slli	s3,s3,0x10
80000514:	00050493          	mv	s1,a0
80000518:	00050593          	mv	a1,a0
8000051c:	01091913          	slli	s2,s2,0x10
80000520:	000b8513          	mv	a0,s7
80000524:	0109d993          	srli	s3,s3,0x10
80000528:	36c000ef          	jal	ra,80000894 <__mulsi3>
8000052c:	013969b3          	or	s3,s2,s3
80000530:	00048613          	mv	a2,s1
80000534:	00a9fc63          	bgeu	s3,a0,8000054c <__udivdi3+0x28c>
80000538:	013409b3          	add	s3,s0,s3
8000053c:	fff48613          	addi	a2,s1,-1
80000540:	0089e663          	bltu	s3,s0,8000054c <__udivdi3+0x28c>
80000544:	00a9f463          	bgeu	s3,a0,8000054c <__udivdi3+0x28c>
80000548:	ffe48613          	addi	a2,s1,-2
8000054c:	010a9793          	slli	a5,s5,0x10
80000550:	00c7e7b3          	or	a5,a5,a2
80000554:	00078513          	mv	a0,a5
80000558:	000a0593          	mv	a1,s4
8000055c:	02c12083          	lw	ra,44(sp)
80000560:	02812403          	lw	s0,40(sp)
80000564:	02412483          	lw	s1,36(sp)
80000568:	02012903          	lw	s2,32(sp)
8000056c:	01c12983          	lw	s3,28(sp)
80000570:	01812a03          	lw	s4,24(sp)
80000574:	01412a83          	lw	s5,20(sp)
80000578:	01012b03          	lw	s6,16(sp)
8000057c:	00c12b83          	lw	s7,12(sp)
80000580:	00812c03          	lw	s8,8(sp)
80000584:	00412c83          	lw	s9,4(sp)
80000588:	03010113          	addi	sp,sp,48
8000058c:	00008067          	ret
80000590:	010007b7          	lui	a5,0x1000
80000594:	01000a13          	li	s4,16
80000598:	ecf468e3          	bltu	s0,a5,80000468 <__udivdi3+0x1a8>
8000059c:	01800a13          	li	s4,24
800005a0:	ec9ff06f          	j	80000468 <__udivdi3+0x1a8>
800005a4:	00c41433          	sll	s0,s0,a2
800005a8:	00d4da33          	srl	s4,s1,a3
800005ac:	00cb19b3          	sll	s3,s6,a2
800005b0:	00db56b3          	srl	a3,s6,a3
800005b4:	01045b13          	srli	s6,s0,0x10
800005b8:	00c494b3          	sll	s1,s1,a2
800005bc:	000b0593          	mv	a1,s6
800005c0:	000a0513          	mv	a0,s4
800005c4:	0096eab3          	or	s5,a3,s1
800005c8:	3d0000ef          	jal	ra,80000998 <__umodsi3>
800005cc:	00050913          	mv	s2,a0
800005d0:	000b0593          	mv	a1,s6
800005d4:	000a0513          	mv	a0,s4
800005d8:	01041b93          	slli	s7,s0,0x10
800005dc:	374000ef          	jal	ra,80000950 <__udivsi3>
800005e0:	010bdb93          	srli	s7,s7,0x10
800005e4:	00050493          	mv	s1,a0
800005e8:	00050593          	mv	a1,a0
800005ec:	000b8513          	mv	a0,s7
800005f0:	2a4000ef          	jal	ra,80000894 <__mulsi3>
800005f4:	01091913          	slli	s2,s2,0x10
800005f8:	010ad713          	srli	a4,s5,0x10
800005fc:	00e96733          	or	a4,s2,a4
80000600:	00048a13          	mv	s4,s1
80000604:	00a77e63          	bgeu	a4,a0,80000620 <__udivdi3+0x360>
80000608:	00870733          	add	a4,a4,s0
8000060c:	fff48a13          	addi	s4,s1,-1
80000610:	00876863          	bltu	a4,s0,80000620 <__udivdi3+0x360>
80000614:	00a77663          	bgeu	a4,a0,80000620 <__udivdi3+0x360>
80000618:	ffe48a13          	addi	s4,s1,-2
8000061c:	00870733          	add	a4,a4,s0
80000620:	40a704b3          	sub	s1,a4,a0
80000624:	000b0593          	mv	a1,s6
80000628:	00048513          	mv	a0,s1
8000062c:	36c000ef          	jal	ra,80000998 <__umodsi3>
80000630:	00050913          	mv	s2,a0
80000634:	000b0593          	mv	a1,s6
80000638:	00048513          	mv	a0,s1
8000063c:	314000ef          	jal	ra,80000950 <__udivsi3>
80000640:	00050493          	mv	s1,a0
80000644:	00050593          	mv	a1,a0
80000648:	000b8513          	mv	a0,s7
8000064c:	248000ef          	jal	ra,80000894 <__mulsi3>
80000650:	010a9693          	slli	a3,s5,0x10
80000654:	01091913          	slli	s2,s2,0x10
80000658:	0106d693          	srli	a3,a3,0x10
8000065c:	00d967b3          	or	a5,s2,a3
80000660:	00048713          	mv	a4,s1
80000664:	00a7fe63          	bgeu	a5,a0,80000680 <__udivdi3+0x3c0>
80000668:	008787b3          	add	a5,a5,s0
8000066c:	fff48713          	addi	a4,s1,-1
80000670:	0087e863          	bltu	a5,s0,80000680 <__udivdi3+0x3c0>
80000674:	00a7f663          	bgeu	a5,a0,80000680 <__udivdi3+0x3c0>
80000678:	ffe48713          	addi	a4,s1,-2
8000067c:	008787b3          	add	a5,a5,s0
80000680:	010a1a13          	slli	s4,s4,0x10
80000684:	40a784b3          	sub	s1,a5,a0
80000688:	00ea6a33          	or	s4,s4,a4
8000068c:	e01ff06f          	j	8000048c <__udivdi3+0x1cc>
80000690:	1ed5ec63          	bltu	a1,a3,80000888 <__udivdi3+0x5c8>
80000694:	000107b7          	lui	a5,0x10
80000698:	04f6f463          	bgeu	a3,a5,800006e0 <__udivdi3+0x420>
8000069c:	0ff00593          	li	a1,255
800006a0:	00d5b533          	sltu	a0,a1,a3
800006a4:	00351513          	slli	a0,a0,0x3
800006a8:	00a6d733          	srl	a4,a3,a0
800006ac:	00007797          	auipc	a5,0x7
800006b0:	8bc78793          	addi	a5,a5,-1860 # 80006f68 <__clz_tab>
800006b4:	00e787b3          	add	a5,a5,a4
800006b8:	0007c583          	lbu	a1,0(a5)
800006bc:	02000a13          	li	s4,32
800006c0:	00a585b3          	add	a1,a1,a0
800006c4:	40ba0a33          	sub	s4,s4,a1
800006c8:	020a1663          	bnez	s4,800006f4 <__udivdi3+0x434>
800006cc:	00100793          	li	a5,1
800006d0:	e896e2e3          	bltu	a3,s1,80000554 <__udivdi3+0x294>
800006d4:	00cb3633          	sltu	a2,s6,a2
800006d8:	00164793          	xori	a5,a2,1
800006dc:	e79ff06f          	j	80000554 <__udivdi3+0x294>
800006e0:	010007b7          	lui	a5,0x1000
800006e4:	01000513          	li	a0,16
800006e8:	fcf6e0e3          	bltu	a3,a5,800006a8 <__udivdi3+0x3e8>
800006ec:	01800513          	li	a0,24
800006f0:	fb9ff06f          	j	800006a8 <__udivdi3+0x3e8>
800006f4:	00b65ab3          	srl	s5,a2,a1
800006f8:	014696b3          	sll	a3,a3,s4
800006fc:	00daeab3          	or	s5,s5,a3
80000700:	00b4d933          	srl	s2,s1,a1
80000704:	014497b3          	sll	a5,s1,s4
80000708:	00bb55b3          	srl	a1,s6,a1
8000070c:	010adb93          	srli	s7,s5,0x10
80000710:	00f5e4b3          	or	s1,a1,a5
80000714:	00090513          	mv	a0,s2
80000718:	000b8593          	mv	a1,s7
8000071c:	014619b3          	sll	s3,a2,s4
80000720:	278000ef          	jal	ra,80000998 <__umodsi3>
80000724:	00050413          	mv	s0,a0
80000728:	000b8593          	mv	a1,s7
8000072c:	00090513          	mv	a0,s2
80000730:	010a9c13          	slli	s8,s5,0x10
80000734:	21c000ef          	jal	ra,80000950 <__udivsi3>
80000738:	010c5c13          	srli	s8,s8,0x10
8000073c:	00050913          	mv	s2,a0
80000740:	00050593          	mv	a1,a0
80000744:	000c0513          	mv	a0,s8
80000748:	14c000ef          	jal	ra,80000894 <__mulsi3>
8000074c:	01041413          	slli	s0,s0,0x10
80000750:	0104d713          	srli	a4,s1,0x10
80000754:	00e46733          	or	a4,s0,a4
80000758:	00090c93          	mv	s9,s2
8000075c:	00a77e63          	bgeu	a4,a0,80000778 <__udivdi3+0x4b8>
80000760:	01570733          	add	a4,a4,s5
80000764:	fff90c93          	addi	s9,s2,-1
80000768:	01576863          	bltu	a4,s5,80000778 <__udivdi3+0x4b8>
8000076c:	00a77663          	bgeu	a4,a0,80000778 <__udivdi3+0x4b8>
80000770:	ffe90c93          	addi	s9,s2,-2
80000774:	01570733          	add	a4,a4,s5
80000778:	40a70933          	sub	s2,a4,a0
8000077c:	000b8593          	mv	a1,s7
80000780:	00090513          	mv	a0,s2
80000784:	214000ef          	jal	ra,80000998 <__umodsi3>
80000788:	00050413          	mv	s0,a0
8000078c:	000b8593          	mv	a1,s7
80000790:	00090513          	mv	a0,s2
80000794:	1bc000ef          	jal	ra,80000950 <__udivsi3>
80000798:	00050913          	mv	s2,a0
8000079c:	00050593          	mv	a1,a0
800007a0:	000c0513          	mv	a0,s8
800007a4:	0f0000ef          	jal	ra,80000894 <__mulsi3>
800007a8:	01049793          	slli	a5,s1,0x10
800007ac:	01041413          	slli	s0,s0,0x10
800007b0:	0107d793          	srli	a5,a5,0x10
800007b4:	00f46733          	or	a4,s0,a5
800007b8:	00090613          	mv	a2,s2
800007bc:	00a77e63          	bgeu	a4,a0,800007d8 <__udivdi3+0x518>
800007c0:	01570733          	add	a4,a4,s5
800007c4:	fff90613          	addi	a2,s2,-1
800007c8:	01576863          	bltu	a4,s5,800007d8 <__udivdi3+0x518>
800007cc:	00a77663          	bgeu	a4,a0,800007d8 <__udivdi3+0x518>
800007d0:	ffe90613          	addi	a2,s2,-2
800007d4:	01570733          	add	a4,a4,s5
800007d8:	010c9793          	slli	a5,s9,0x10
800007dc:	00010e37          	lui	t3,0x10
800007e0:	00c7e7b3          	or	a5,a5,a2
800007e4:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007e8:	0107f333          	and	t1,a5,a6
800007ec:	0109f833          	and	a6,s3,a6
800007f0:	40a70733          	sub	a4,a4,a0
800007f4:	0107de93          	srli	t4,a5,0x10
800007f8:	0109d993          	srli	s3,s3,0x10
800007fc:	00030513          	mv	a0,t1
80000800:	00080593          	mv	a1,a6
80000804:	090000ef          	jal	ra,80000894 <__mulsi3>
80000808:	00050893          	mv	a7,a0
8000080c:	00098593          	mv	a1,s3
80000810:	00030513          	mv	a0,t1
80000814:	080000ef          	jal	ra,80000894 <__mulsi3>
80000818:	00050313          	mv	t1,a0
8000081c:	00080593          	mv	a1,a6
80000820:	000e8513          	mv	a0,t4
80000824:	070000ef          	jal	ra,80000894 <__mulsi3>
80000828:	00050813          	mv	a6,a0
8000082c:	00098593          	mv	a1,s3
80000830:	000e8513          	mv	a0,t4
80000834:	060000ef          	jal	ra,80000894 <__mulsi3>
80000838:	0108d693          	srli	a3,a7,0x10
8000083c:	01030333          	add	t1,t1,a6
80000840:	006686b3          	add	a3,a3,t1
80000844:	0106f463          	bgeu	a3,a6,8000084c <__udivdi3+0x58c>
80000848:	01c50533          	add	a0,a0,t3
8000084c:	0106d613          	srli	a2,a3,0x10
80000850:	00a60533          	add	a0,a2,a0
80000854:	02a76663          	bltu	a4,a0,80000880 <__udivdi3+0x5c0>
80000858:	bca714e3          	bne	a4,a0,80000420 <__udivdi3+0x160>
8000085c:	00010737          	lui	a4,0x10
80000860:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000864:	00e6f6b3          	and	a3,a3,a4
80000868:	01069693          	slli	a3,a3,0x10
8000086c:	00e8f8b3          	and	a7,a7,a4
80000870:	014b1633          	sll	a2,s6,s4
80000874:	011686b3          	add	a3,a3,a7
80000878:	00000a13          	li	s4,0
8000087c:	ccd67ce3          	bgeu	a2,a3,80000554 <__udivdi3+0x294>
80000880:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
80000884:	b9dff06f          	j	80000420 <__udivdi3+0x160>
80000888:	00000a13          	li	s4,0
8000088c:	00000793          	li	a5,0
80000890:	cc5ff06f          	j	80000554 <__udivdi3+0x294>

80000894 <__mulsi3>:
80000894:	00050613          	mv	a2,a0
80000898:	00000513          	li	a0,0
8000089c:	0015f693          	andi	a3,a1,1
800008a0:	00068463          	beqz	a3,800008a8 <__mulsi3+0x14>
800008a4:	00c50533          	add	a0,a0,a2
800008a8:	0015d593          	srli	a1,a1,0x1
800008ac:	00161613          	slli	a2,a2,0x1
800008b0:	fe0596e3          	bnez	a1,8000089c <__mulsi3+0x8>
800008b4:	00008067          	ret

800008b8 <__muldi3>:
800008b8:	ff010113          	addi	sp,sp,-16
800008bc:	00068313          	mv	t1,a3
800008c0:	00112623          	sw	ra,12(sp)
800008c4:	00050e13          	mv	t3,a0
800008c8:	00050893          	mv	a7,a0
800008cc:	00060693          	mv	a3,a2
800008d0:	00000713          	li	a4,0
800008d4:	00000793          	li	a5,0
800008d8:	00000813          	li	a6,0
800008dc:	0016f513          	andi	a0,a3,1
800008e0:	00171e93          	slli	t4,a4,0x1
800008e4:	00050c63          	beqz	a0,800008fc <__muldi3+0x44>
800008e8:	01088533          	add	a0,a7,a6
800008ec:	01053833          	sltu	a6,a0,a6
800008f0:	00e787b3          	add	a5,a5,a4
800008f4:	00f807b3          	add	a5,a6,a5
800008f8:	00050813          	mv	a6,a0
800008fc:	01f8d713          	srli	a4,a7,0x1f
80000900:	0016d693          	srli	a3,a3,0x1
80000904:	00eee733          	or	a4,t4,a4
80000908:	00189893          	slli	a7,a7,0x1
8000090c:	fc0698e3          	bnez	a3,800008dc <__muldi3+0x24>
80000910:	00058863          	beqz	a1,80000920 <__muldi3+0x68>
80000914:	00060513          	mv	a0,a2
80000918:	f7dff0ef          	jal	ra,80000894 <__mulsi3>
8000091c:	00a787b3          	add	a5,a5,a0
80000920:	00030a63          	beqz	t1,80000934 <__muldi3+0x7c>
80000924:	000e0513          	mv	a0,t3
80000928:	00030593          	mv	a1,t1
8000092c:	f69ff0ef          	jal	ra,80000894 <__mulsi3>
80000930:	00f507b3          	add	a5,a0,a5
80000934:	00c12083          	lw	ra,12(sp)
80000938:	00080513          	mv	a0,a6
8000093c:	00078593          	mv	a1,a5
80000940:	01010113          	addi	sp,sp,16
80000944:	00008067          	ret

80000948 <__divsi3>:
80000948:	06054063          	bltz	a0,800009a8 <__umodsi3+0x10>
8000094c:	0605c663          	bltz	a1,800009b8 <__umodsi3+0x20>

80000950 <__udivsi3>:
80000950:	00058613          	mv	a2,a1
80000954:	00050593          	mv	a1,a0
80000958:	fff00513          	li	a0,-1
8000095c:	02060c63          	beqz	a2,80000994 <__udivsi3+0x44>
80000960:	00100693          	li	a3,1
80000964:	00b67a63          	bgeu	a2,a1,80000978 <__udivsi3+0x28>
80000968:	00c05863          	blez	a2,80000978 <__udivsi3+0x28>
8000096c:	00161613          	slli	a2,a2,0x1
80000970:	00169693          	slli	a3,a3,0x1
80000974:	feb66ae3          	bltu	a2,a1,80000968 <__udivsi3+0x18>
80000978:	00000513          	li	a0,0
8000097c:	00c5e663          	bltu	a1,a2,80000988 <__udivsi3+0x38>
80000980:	40c585b3          	sub	a1,a1,a2
80000984:	00d56533          	or	a0,a0,a3
80000988:	0016d693          	srli	a3,a3,0x1
8000098c:	00165613          	srli	a2,a2,0x1
80000990:	fe0696e3          	bnez	a3,8000097c <__udivsi3+0x2c>
80000994:	00008067          	ret

80000998 <__umodsi3>:
80000998:	00008293          	mv	t0,ra
8000099c:	fb5ff0ef          	jal	ra,80000950 <__udivsi3>
800009a0:	00058513          	mv	a0,a1
800009a4:	00028067          	jr	t0
800009a8:	40a00533          	neg	a0,a0
800009ac:	0005d863          	bgez	a1,800009bc <__umodsi3+0x24>
800009b0:	40b005b3          	neg	a1,a1
800009b4:	f9dff06f          	j	80000950 <__udivsi3>
800009b8:	40b005b3          	neg	a1,a1
800009bc:	00008293          	mv	t0,ra
800009c0:	f91ff0ef          	jal	ra,80000950 <__udivsi3>
800009c4:	40a00533          	neg	a0,a0
800009c8:	00028067          	jr	t0

800009cc <__modsi3>:
800009cc:	00008293          	mv	t0,ra
800009d0:	0005ca63          	bltz	a1,800009e4 <__modsi3+0x18>
800009d4:	00054c63          	bltz	a0,800009ec <__modsi3+0x20>
800009d8:	f79ff0ef          	jal	ra,80000950 <__udivsi3>
800009dc:	00058513          	mv	a0,a1
800009e0:	00028067          	jr	t0
800009e4:	40b005b3          	neg	a1,a1
800009e8:	fe0558e3          	bgez	a0,800009d8 <__modsi3+0xc>
800009ec:	40a00533          	neg	a0,a0
800009f0:	f61ff0ef          	jal	ra,80000950 <__udivsi3>
800009f4:	40b00533          	neg	a0,a1
800009f8:	00028067          	jr	t0

800009fc <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009fc:	00008067          	ret

80000a00 <thread_helper>:
 *
 * @return N/A
 */

static void thread_helper(void *arg1, void *arg2, void *arg3)
{
80000a00:	ff010113          	addi	sp,sp,-16
80000a04:	00812423          	sw	s0,8(sp)

	/*
	 * This thread starts off at a higher priority than thread_entry().
	 * Thus, it should execute immediately.
	 */
	thread_evidence++;
80000a08:	80008437          	lui	s0,0x80008
80000a0c:	6d040413          	addi	s0,s0,1744 # 800086d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086d1>
80000a10:	00042783          	lw	a5,0(s0)
{
80000a14:	00112623          	sw	ra,12(sp)
	thread_evidence++;
80000a18:	00178793          	addi	a5,a5,1
80000a1c:	00f42023          	sw	a5,0(s0)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000a20:	4ad040ef          	jal	ra,800056cc <z_impl_k_current_get>

	/* Test that helper will yield to a thread of equal priority */
	self_thread_id = k_current_get();

	/* Lower priority to that of thread_entry() */
	k_thread_priority_set(self_thread_id, self_thread_id->base.prio + 1);
80000a24:	00e50583          	lb	a1,14(a0)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)

K_SYSCALL_DECLARE1(K_SYSCALL_K_THREAD_PRIORITY_GET, k_thread_priority_get, int, k_tid_t, thread)

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000a28:	00158593          	addi	a1,a1,1
80000a2c:	798040ef          	jal	ra,800051c4 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80000a30:	065040ef          	jal	ra,80005294 <z_impl_k_yield>

	k_yield();      /* Yield to thread of equal priority */

	thread_evidence++;
80000a34:	00042783          	lw	a5,0(s0)
	/* thread_evidence should now be 2 */

}
80000a38:	00c12083          	lw	ra,12(sp)
	thread_evidence++;
80000a3c:	00178793          	addi	a5,a5,1
80000a40:	00f42023          	sw	a5,0(s0)
}
80000a44:	00812403          	lw	s0,8(sp)
80000a48:	01010113          	addi	sp,sp,16
80000a4c:	00008067          	ret

80000a50 <isr_handler_trigger>:
	irq_offload(isr_handler, NULL);
80000a50:	80001537          	lui	a0,0x80001
80000a54:	00000593          	li	a1,0
80000a58:	c0050513          	addi	a0,a0,-1024 # 80000c00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000c01>
80000a5c:	0980106f          	j	80001af4 <irq_offload>

80000a60 <test_kernel_cpu_idle>:
	ztest_test_skip();
80000a60:	0490206f          	j	800032a8 <ztest_test_skip>

80000a64 <delayed_thread>:
	k_sem_give(&reply_timeout);
}

/* a thread is started with a delay, then it reports that it ran via a fifo */
static void delayed_thread(void *num, void *arg2, void *arg3)
{
80000a64:	ff010113          	addi	sp,sp,-16
80000a68:	00812423          	sw	s0,8(sp)
	struct timeout_order *timeout = &timeouts[(int)num];

	ARG_UNUSED(arg2);
	ARG_UNUSED(arg3);

	TC_PRINT(" thread (q order: %d, t/o: %d) is running\n",
80000a6c:	80008437          	lui	s0,0x80008
80000a70:	00451513          	slli	a0,a0,0x4
80000a74:	5f040413          	addi	s0,s0,1520 # 800085f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800085f1>
80000a78:	00a40433          	add	s0,s0,a0
80000a7c:	00c42583          	lw	a1,12(s0)
80000a80:	00442603          	lw	a2,4(s0)
80000a84:	80007537          	lui	a0,0x80007
80000a88:	14050513          	addi	a0,a0,320 # 80007140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007141>
{
80000a8c:	00112623          	sw	ra,12(sp)
	TC_PRINT(" thread (q order: %d, t/o: %d) is running\n",
80000a90:	034020ef          	jal	ra,80002ac4 <printk>
		 timeout->q_order, timeout->timeout);

	k_fifo_put(&timeout_order_fifo, timeout);
80000a94:	00040593          	mv	a1,s0
}
80000a98:	00812403          	lw	s0,8(sp)
80000a9c:	00c12083          	lw	ra,12(sp)
	k_fifo_put(&timeout_order_fifo, timeout);
80000aa0:	80009537          	lui	a0,0x80009
80000aa4:	88c50513          	addi	a0,a0,-1908 # 8000888c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000888d>
}
80000aa8:	01010113          	addi	sp,sp,16
	k_fifo_put(&timeout_order_fifo, timeout);
80000aac:	0180306f          	j	80003ac4 <k_queue_append>

80000ab0 <thread_sleep>:
{
80000ab0:	fe010113          	addi	sp,sp,-32
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
80000ab4:	00050593          	mv	a1,a0
{
80000ab8:	00812c23          	sw	s0,24(sp)
80000abc:	00050413          	mv	s0,a0
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
80000ac0:	80008537          	lui	a0,0x80008
80000ac4:	a5050513          	addi	a0,a0,-1456 # 80007a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a51>
{
80000ac8:	00112e23          	sw	ra,28(sp)
80000acc:	00912a23          	sw	s1,20(sp)
80000ad0:	01212823          	sw	s2,16(sp)
80000ad4:	01312623          	sw	s3,12(sp)
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
80000ad8:	7ed010ef          	jal	ra,80002ac4 <printk>

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_TIMER_USER_DATA_SET, k_timer_user_data_set, struct k_timer *, timer, void *, user_data)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000adc:	6a5050ef          	jal	ra,80006980 <z_impl_k_uptime_get>
80000ae0:	00050993          	mv	s3,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000ae4:	00040513          	mv	a0,s0
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000ae8:	00058913          	mv	s2,a1
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000aec:	1a1040ef          	jal	ra,8000548c <z_impl_k_sleep>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000af0:	691050ef          	jal	ra,80006980 <z_impl_k_uptime_get>
	timestamp = k_uptime_get() - timestamp;
80000af4:	413509b3          	sub	s3,a0,s3
80000af8:	01353533          	sltu	a0,a0,s3
80000afc:	412585b3          	sub	a1,a1,s2
80000b00:	40a584b3          	sub	s1,a1,a0
	TC_PRINT(" thread back from sleep\n");
80000b04:	80008537          	lui	a0,0x80008
80000b08:	a7850513          	addi	a0,a0,-1416 # 80007a78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a79>
80000b0c:	7b9010ef          	jal	ra,80002ac4 <printk>
	if (timestamp < timeout || timestamp > timeout + __ticks_to_ms(2)) {
80000b10:	41f45793          	srai	a5,s0,0x1f
80000b14:	02f4c263          	blt	s1,a5,80000b38 <thread_sleep+0x88>
80000b18:	00979463          	bne	a5,s1,80000b20 <thread_sleep+0x70>
80000b1c:	0089ee63          	bltu	s3,s0,80000b38 <thread_sleep+0x88>
80000b20:	01440713          	addi	a4,s0,20
80000b24:	00873433          	sltu	s0,a4,s0
80000b28:	00f40433          	add	s0,s0,a5
80000b2c:	00946663          	bltu	s0,s1,80000b38 <thread_sleep+0x88>
80000b30:	04849863          	bne	s1,s0,80000b80 <thread_sleep+0xd0>
80000b34:	05377663          	bgeu	a4,s3,80000b80 <thread_sleep+0xd0>
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000b38:	80007637          	lui	a2,0x80007
80000b3c:	800085b7          	lui	a1,0x80008
80000b40:	80008537          	lui	a0,0x80008
80000b44:	a9458593          	addi	a1,a1,-1388 # 80007a94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a95>
80000b48:	a9c50513          	addi	a0,a0,-1380 # 80007a9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a9d>
80000b4c:	2be00693          	li	a3,702
80000b50:	0bc60613          	addi	a2,a2,188 # 800070bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070bd>
80000b54:	771010ef          	jal	ra,80002ac4 <printk>
}
80000b58:	01812403          	lw	s0,24(sp)
80000b5c:	01c12083          	lw	ra,28(sp)
80000b60:	01412483          	lw	s1,20(sp)
80000b64:	01012903          	lw	s2,16(sp)
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000b68:	00098593          	mv	a1,s3
}
80000b6c:	00c12983          	lw	s3,12(sp)
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000b70:	80008537          	lui	a0,0x80008
80000b74:	aac50513          	addi	a0,a0,-1364 # 80007aac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007aad>
}
80000b78:	02010113          	addi	sp,sp,32
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000b7c:	7490106f          	j	80002ac4 <printk>
}
80000b80:	01812403          	lw	s0,24(sp)
80000b84:	01c12083          	lw	ra,28(sp)
80000b88:	01412483          	lw	s1,20(sp)
80000b8c:	01012903          	lw	s2,16(sp)
80000b90:	00c12983          	lw	s3,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b94:	80008537          	lui	a0,0x80008
80000b98:	71c50513          	addi	a0,a0,1820 # 8000871c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000871d>
80000b9c:	02010113          	addi	sp,sp,32
80000ba0:	4010406f          	j	800057a0 <z_impl_k_sem_give>

80000ba4 <busy_wait_thread>:
{
80000ba4:	ff010113          	addi	sp,sp,-16
80000ba8:	00812423          	sw	s0,8(sp)
	usecs = (int)mseconds * 1000;
80000bac:	00551413          	slli	s0,a0,0x5
80000bb0:	40a40433          	sub	s0,s0,a0
80000bb4:	00241413          	slli	s0,s0,0x2
80000bb8:	00850533          	add	a0,a0,s0
80000bbc:	00351413          	slli	s0,a0,0x3
	TC_PRINT("Thread busy waiting for %d usecs\n", usecs);
80000bc0:	80007537          	lui	a0,0x80007
80000bc4:	00040593          	mv	a1,s0
80000bc8:	0fc50513          	addi	a0,a0,252 # 800070fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070fd>
{
80000bcc:	00112623          	sw	ra,12(sp)
	TC_PRINT("Thread busy waiting for %d usecs\n", usecs);
80000bd0:	6f5010ef          	jal	ra,80002ac4 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000bd4:	00040513          	mv	a0,s0
80000bd8:	6b9040ef          	jal	ra,80005a90 <z_impl_k_busy_wait>
	TC_PRINT("Thread busy waiting completed\n");
80000bdc:	80007537          	lui	a0,0x80007
80000be0:	12050513          	addi	a0,a0,288 # 80007120 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007121>
80000be4:	6e1010ef          	jal	ra,80002ac4 <printk>
}
80000be8:	00812403          	lw	s0,8(sp)
80000bec:	00c12083          	lw	ra,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000bf0:	80008537          	lui	a0,0x80008
80000bf4:	71c50513          	addi	a0,a0,1820 # 8000871c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000871d>
80000bf8:	01010113          	addi	sp,sp,16
80000bfc:	3a50406f          	j	800057a0 <z_impl_k_sem_give>

80000c00 <isr_handler>:
{
80000c00:	ff010113          	addi	sp,sp,-16
80000c04:	00812423          	sw	s0,8(sp)
	switch (isr_info.command) {
80000c08:	80008437          	lui	s0,0x80008
80000c0c:	71040413          	addi	s0,s0,1808 # 80008710 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008711>
{
80000c10:	00912223          	sw	s1,4(sp)
	switch (isr_info.command) {
80000c14:	00042483          	lw	s1,0(s0)
{
80000c18:	00112623          	sw	ra,12(sp)
80000c1c:	00048c63          	beqz	s1,80000c34 <isr_handler+0x34>
80000c20:	00100793          	li	a5,1
80000c24:	02f48663          	beq	s1,a5,80000c50 <isr_handler+0x50>
		isr_info.error = UNKNOWN_COMMAND;
80000c28:	fff00793          	li	a5,-1
80000c2c:	00f42223          	sw	a5,4(s0)
}
80000c30:	00c0006f          	j	80000c3c <isr_handler+0x3c>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000c34:	299040ef          	jal	ra,800056cc <z_impl_k_current_get>
		isr_info.data = (void *)k_current_get();
80000c38:	00a42423          	sw	a0,8(s0)
}
80000c3c:	00c12083          	lw	ra,12(sp)
80000c40:	00812403          	lw	s0,8(sp)
80000c44:	00412483          	lw	s1,4(sp)
80000c48:	01010113          	addi	sp,sp,16
80000c4c:	00008067          	ret
		if (k_is_in_isr()) {
80000c50:	61d040ef          	jal	ra,80005a6c <k_is_in_isr>
80000c54:	00050663          	beqz	a0,80000c60 <isr_handler+0x60>
			isr_info.value = K_ISR;
80000c58:	00042423          	sw	zero,8(s0)
			break;
80000c5c:	fe1ff06f          	j	80000c3c <isr_handler+0x3c>
		if (_current->base.prio < 0) {
80000c60:	800097b7          	lui	a5,0x80009
80000c64:	d447a783          	lw	a5,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
80000c68:	00e78783          	lb	a5,14(a5)
80000c6c:	0007d663          	bgez	a5,80000c78 <isr_handler+0x78>
			isr_info.value = K_COOP_THREAD;
80000c70:	00942423          	sw	s1,8(s0)
			break;
80000c74:	fc9ff06f          	j	80000c3c <isr_handler+0x3c>
		isr_info.value = K_PREEMPT_THREAD;
80000c78:	00200793          	li	a5,2
80000c7c:	00f42423          	sw	a5,8(s0)
		break;
80000c80:	fbdff06f          	j	80000c3c <isr_handler+0x3c>

80000c84 <z_zassert.constprop.2>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000c84:	fd010113          	addi	sp,sp,-48
80000c88:	00112e23          	sw	ra,28(sp)
80000c8c:	00812c23          	sw	s0,24(sp)
80000c90:	03012423          	sw	a6,40(sp)
80000c94:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000c98:	04051663          	bnez	a0,80000ce4 <z_zassert.constprop.2+0x60>
80000c9c:	00068613          	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000ca0:	80008537          	lui	a0,0x80008
80000ca4:	00070693          	mv	a3,a4
80000ca8:	00058713          	mv	a4,a1
80000cac:	800085b7          	lui	a1,0x80008
80000cb0:	00078413          	mv	s0,a5
80000cb4:	acc58593          	addi	a1,a1,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
		va_start(vargs, msg);
80000cb8:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000cbc:	af050513          	addi	a0,a0,-1296 # 80007af0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007af1>
		va_start(vargs, msg);
80000cc0:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000cc4:	601010ef          	jal	ra,80002ac4 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000cc8:	00c12583          	lw	a1,12(sp)
80000ccc:	00040513          	mv	a0,s0
80000cd0:	5c5010ef          	jal	ra,80002a94 <vprintk>
		printk("\n");
80000cd4:	80008537          	lui	a0,0x80008
80000cd8:	c6c50513          	addi	a0,a0,-916 # 80007c6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c6d>
80000cdc:	5e9010ef          	jal	ra,80002ac4 <printk>
		va_end(vargs);
		ztest_test_fail();
80000ce0:	598020ef          	jal	ra,80003278 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000ce4:	01c12083          	lw	ra,28(sp)
80000ce8:	01812403          	lw	s0,24(sp)
80000cec:	03010113          	addi	sp,sp,48
80000cf0:	00008067          	ret

80000cf4 <test_kernel_ctx_thread>:
{
80000cf4:	fe010113          	addi	sp,sp,-32
80000cf8:	00112e23          	sw	ra,28(sp)
80000cfc:	00812c23          	sw	s0,24(sp)
80000d00:	00912a23          	sw	s1,20(sp)
80000d04:	01212823          	sw	s2,16(sp)
80000d08:	01312623          	sw	s3,12(sp)
80000d0c:	01412423          	sw	s4,8(sp)
80000d10:	01512223          	sw	s5,4(sp)
80000d14:	1b9040ef          	jal	ra,800056cc <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000d18:	00000593          	li	a1,0
80000d1c:	4a8040ef          	jal	ra,800051c4 <z_impl_k_thread_priority_set>
	TC_PRINT("Testing k_current_get() from an ISR and thread\n");
80000d20:	80008537          	lui	a0,0x80008
80000d24:	83450513          	addi	a0,a0,-1996 # 80007834 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007835>
80000d28:	59d010ef          	jal	ra,80002ac4 <printk>
	isr_info.command = THREAD_SELF_CMD;
80000d2c:	80008437          	lui	s0,0x80008
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000d30:	19d040ef          	jal	ra,800056cc <z_impl_k_current_get>
80000d34:	71040413          	addi	s0,s0,1808 # 80008710 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008711>
80000d38:	00050a93          	mv	s5,a0
80000d3c:	00042023          	sw	zero,0(s0)
	isr_info.error = 0;
80000d40:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
80000d44:	d0dff0ef          	jal	ra,80000a50 <isr_handler_trigger>
	zassert_false(isr_info.error, "ISR detected an error");
80000d48:	00442503          	lw	a0,4(s0)
80000d4c:	80007937          	lui	s2,0x80007
80000d50:	800084b7          	lui	s1,0x80008
80000d54:	80008a37          	lui	s4,0x80008
80000d58:	800089b7          	lui	s3,0x80008
80000d5c:	864a0793          	addi	a5,s4,-1948 # 80007864 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007865>
80000d60:	08090713          	addi	a4,s2,128 # 80007080 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007081>
80000d64:	acc48613          	addi	a2,s1,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
80000d68:	87c98593          	addi	a1,s3,-1924 # 8000787c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000787d>
80000d6c:	1c400693          	li	a3,452
80000d70:	00153513          	seqz	a0,a0
80000d74:	f11ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	zassert_equal(isr_info.data, (void *)self_thread_id,
80000d78:	00842503          	lw	a0,8(s0)
80000d7c:	800087b7          	lui	a5,0x80008
80000d80:	800085b7          	lui	a1,0x80008
80000d84:	41550533          	sub	a0,a0,s5
80000d88:	08090713          	addi	a4,s2,128
80000d8c:	acc48613          	addi	a2,s1,-1332
80000d90:	1c700693          	li	a3,455
80000d94:	8b058593          	addi	a1,a1,-1872 # 800078b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078b1>
80000d98:	89878793          	addi	a5,a5,-1896 # 80007898 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007899>
80000d9c:	00153513          	seqz	a0,a0
80000da0:	ee5ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	TC_PRINT("Testing k_is_in_isr() from an ISR\n");
80000da4:	80008537          	lui	a0,0x80008
80000da8:	8e450513          	addi	a0,a0,-1820 # 800078e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078e5>
80000dac:	519010ef          	jal	ra,80002ac4 <printk>
	isr_info.command = EXEC_CTX_TYPE_CMD;
80000db0:	00100793          	li	a5,1
80000db4:	00f42023          	sw	a5,0(s0)
	isr_info.error = 0;
80000db8:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
80000dbc:	c95ff0ef          	jal	ra,80000a50 <isr_handler_trigger>
	zassert_false(isr_info.error, "ISR detected an error");
80000dc0:	00442503          	lw	a0,4(s0)
80000dc4:	864a0793          	addi	a5,s4,-1948
80000dc8:	08090713          	addi	a4,s2,128
80000dcc:	acc48613          	addi	a2,s1,-1332
80000dd0:	87c98593          	addi	a1,s3,-1924
80000dd4:	1ce00693          	li	a3,462
80000dd8:	00153513          	seqz	a0,a0
80000ddc:	ea9ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	zassert_equal(isr_info.value, K_ISR,
80000de0:	00842503          	lw	a0,8(s0)
80000de4:	800087b7          	lui	a5,0x80008
80000de8:	800085b7          	lui	a1,0x80008
80000dec:	08090713          	addi	a4,s2,128
80000df0:	acc48613          	addi	a2,s1,-1332
80000df4:	90878793          	addi	a5,a5,-1784 # 80007908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007909>
80000df8:	1d100693          	li	a3,465
80000dfc:	92858593          	addi	a1,a1,-1752 # 80007928 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007929>
80000e00:	00153513          	seqz	a0,a0
80000e04:	e81ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	TC_PRINT("Testing k_is_in_isr() from a preemptible thread\n");
80000e08:	80008537          	lui	a0,0x80008
80000e0c:	94c50513          	addi	a0,a0,-1716 # 8000794c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000794d>
80000e10:	4b5010ef          	jal	ra,80002ac4 <printk>
	zassert_false(k_is_in_isr(), "Should not be in ISR context");
80000e14:	459040ef          	jal	ra,80005a6c <k_is_in_isr>
80000e18:	00154513          	xori	a0,a0,1
80000e1c:	800087b7          	lui	a5,0x80008
80000e20:	800085b7          	lui	a1,0x80008
80000e24:	08090713          	addi	a4,s2,128
80000e28:	acc48613          	addi	a2,s1,-1332
80000e2c:	98078793          	addi	a5,a5,-1664 # 80007980 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007981>
80000e30:	1d400693          	li	a3,468
80000e34:	9a058593          	addi	a1,a1,-1632 # 800079a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079a1>
80000e38:	0ff57513          	andi	a0,a0,255
80000e3c:	e49ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	zassert_false(_current->base.prio < 0,
80000e40:	800097b7          	lui	a5,0x80009
80000e44:	d447a783          	lw	a5,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
}
80000e48:	01812403          	lw	s0,24(sp)
80000e4c:	01c12083          	lw	ra,28(sp)
	zassert_false(_current->base.prio < 0,
80000e50:	00e78803          	lb	a6,14(a5)
}
80000e54:	00c12983          	lw	s3,12(sp)
80000e58:	00812a03          	lw	s4,8(sp)
80000e5c:	00412a83          	lw	s5,4(sp)
	zassert_false(_current->base.prio < 0,
80000e60:	08090713          	addi	a4,s2,128
80000e64:	acc48613          	addi	a2,s1,-1332
}
80000e68:	01012903          	lw	s2,16(sp)
80000e6c:	01412483          	lw	s1,20(sp)
	zassert_false(_current->base.prio < 0,
80000e70:	fff84513          	not	a0,a6
80000e74:	800087b7          	lui	a5,0x80008
80000e78:	800085b7          	lui	a1,0x80008
80000e7c:	9b878793          	addi	a5,a5,-1608 # 800079b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079b9>
80000e80:	1d800693          	li	a3,472
80000e84:	9ec58593          	addi	a1,a1,-1556 # 800079ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079ed>
80000e88:	01f55513          	srli	a0,a0,0x1f
}
80000e8c:	02010113          	addi	sp,sp,32
	zassert_false(_current->base.prio < 0,
80000e90:	df5ff06f          	j	80000c84 <z_zassert.constprop.2>

80000e94 <test_kernel_interrupts>:
80000e94:	00008067          	ret

80000e98 <test_kernel_timer_interrupts>:
{
80000e98:	fe010113          	addi	sp,sp,-32
80000e9c:	01212823          	sw	s2,16(sp)
80000ea0:	00112e23          	sw	ra,28(sp)
80000ea4:	00812c23          	sw	s0,24(sp)
80000ea8:	00912a23          	sw	s1,20(sp)
80000eac:	01312623          	sw	s3,12(sp)
80000eb0:	01412423          	sw	s4,8(sp)
	tick = z_tick_get_32();
80000eb4:	2b5050ef          	jal	ra,80006968 <z_tick_get_32>
80000eb8:	00050913          	mv	s2,a0
	while (z_tick_get_32() == tick) {
80000ebc:	2ad050ef          	jal	ra,80006968 <z_tick_get_32>
80000ec0:	fea90ee3          	beq	s2,a0,80000ebc <test_kernel_timer_interrupts+0x24>
	tick++;
80000ec4:	00190913          	addi	s2,s2,1
	unsigned long long count = 0;
80000ec8:	00000493          	li	s1,0
80000ecc:	00000413          	li	s0,0
	while (z_tick_get_32() == tick) {
80000ed0:	299050ef          	jal	ra,80006968 <z_tick_get_32>
80000ed4:	0b250063          	beq	a0,s2,80000f74 <test_kernel_timer_interrupts+0xdc>
	count <<= 4;
80000ed8:	01c4d793          	srli	a5,s1,0x1c
	irq_disable(irq);
80000edc:	00700513          	li	a0,7
	count <<= 4;
80000ee0:	00441413          	slli	s0,s0,0x4
80000ee4:	0087e433          	or	s0,a5,s0
	irq_disable(irq);
80000ee8:	46d010ef          	jal	ra,80002b54 <z_arch_irq_disable>
	tick = z_tick_get_32();
80000eec:	27d050ef          	jal	ra,80006968 <z_tick_get_32>
	count <<= 4;
80000ef0:	00449493          	slli	s1,s1,0x4
	tick = z_tick_get_32();
80000ef4:	00050a13          	mv	s4,a0
	for (i = 0; i < count; i++) {
80000ef8:	00000913          	li	s2,0
80000efc:	00000993          	li	s3,0
80000f00:	09249463          	bne	s1,s2,80000f88 <test_kernel_timer_interrupts+0xf0>
80000f04:	09341263          	bne	s0,s3,80000f88 <test_kernel_timer_interrupts+0xf0>
	tick2 = z_tick_get_32();
80000f08:	261050ef          	jal	ra,80006968 <z_tick_get_32>
	irq_enable(irq);
80000f0c:	00700513          	li	a0,7
80000f10:	435010ef          	jal	ra,80002b44 <z_arch_irq_enable>
	for (i = 0; i < count; i++) {
80000f14:	00000413          	li	s0,0
80000f18:	00000493          	li	s1,0
80000f1c:	08891263          	bne	s2,s0,80000fa0 <test_kernel_timer_interrupts+0x108>
80000f20:	08999063          	bne	s3,s1,80000fa0 <test_kernel_timer_interrupts+0x108>
	tick2 = z_tick_get_32();
80000f24:	245050ef          	jal	ra,80006968 <z_tick_get_32>
}
80000f28:	01812403          	lw	s0,24(sp)
	zassert_not_equal(tick, tick2,
80000f2c:	40aa0533          	sub	a0,s4,a0
}
80000f30:	01c12083          	lw	ra,28(sp)
80000f34:	01412483          	lw	s1,20(sp)
80000f38:	01012903          	lw	s2,16(sp)
80000f3c:	00c12983          	lw	s3,12(sp)
80000f40:	00812a03          	lw	s4,8(sp)
	zassert_not_equal(tick, tick2,
80000f44:	800087b7          	lui	a5,0x80008
80000f48:	80007737          	lui	a4,0x80007
80000f4c:	80008637          	lui	a2,0x80008
80000f50:	800085b7          	lui	a1,0x80008
80000f54:	a1078793          	addi	a5,a5,-1520 # 80007a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a11>
80000f58:	06870713          	addi	a4,a4,104 # 80007068 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007069>
80000f5c:	17c00693          	li	a3,380
80000f60:	acc60613          	addi	a2,a2,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
80000f64:	a3058593          	addi	a1,a1,-1488 # 80007a30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a31>
80000f68:	00a03533          	snez	a0,a0
}
80000f6c:	02010113          	addi	sp,sp,32
	zassert_not_equal(tick, tick2,
80000f70:	d15ff06f          	j	80000c84 <z_zassert.constprop.2>
		count++;
80000f74:	00148793          	addi	a5,s1,1
80000f78:	0097b733          	sltu	a4,a5,s1
80000f7c:	00870433          	add	s0,a4,s0
80000f80:	00078493          	mv	s1,a5
80000f84:	f4dff06f          	j	80000ed0 <test_kernel_timer_interrupts+0x38>
		z_tick_get_32();
80000f88:	1e1050ef          	jal	ra,80006968 <z_tick_get_32>
	for (i = 0; i < count; i++) {
80000f8c:	00190793          	addi	a5,s2,1
80000f90:	0127b733          	sltu	a4,a5,s2
80000f94:	013709b3          	add	s3,a4,s3
80000f98:	00078913          	mv	s2,a5
80000f9c:	f65ff06f          	j	80000f00 <test_kernel_timer_interrupts+0x68>
		z_tick_get_32();
80000fa0:	1c9050ef          	jal	ra,80006968 <z_tick_get_32>
	for (i = 0; i < count; i++) {
80000fa4:	00140793          	addi	a5,s0,1
80000fa8:	0087b733          	sltu	a4,a5,s0
80000fac:	009704b3          	add	s1,a4,s1
80000fb0:	00078413          	mv	s0,a5
80000fb4:	f69ff06f          	j	80000f1c <test_kernel_timer_interrupts+0x84>

80000fb8 <test_kernel_cpu_idle_atomic>:
80000fb8:	2f00206f          	j	800032a8 <ztest_test_skip>

80000fbc <test_kernel_thread>:
 * @ingroup kernel_context_tests
 *
 * @see k_thread_create
 */
void test_kernel_thread(void)
{
80000fbc:	fe010113          	addi	sp,sp,-32
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000fc0:	800016b7          	lui	a3,0x80001
80000fc4:	800095b7          	lui	a1,0x80009
80000fc8:	80009537          	lui	a0,0x80009
80000fcc:	00012223          	sw	zero,4(sp)
80000fd0:	00012023          	sw	zero,0(sp)
80000fd4:	ff400893          	li	a7,-12
80000fd8:	00000813          	li	a6,0
80000fdc:	00000793          	li	a5,0
80000fe0:	00000713          	li	a4,0
80000fe4:	00868693          	addi	a3,a3,8 # 80001008 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001009>
80000fe8:	20000613          	li	a2,512
80000fec:	17058593          	addi	a1,a1,368 # 80009170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80009171>
80000ff0:	81c50513          	addi	a0,a0,-2020 # 8000881c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000881d>
80000ff4:	00112e23          	sw	ra,28(sp)
80000ff8:	5a9040ef          	jal	ra,80005da0 <z_impl_k_thread_create>

	k_thread_create(&thread_data3, thread_stack3, THREAD_STACKSIZE,
			kernel_thread_entry, NULL, NULL,
			NULL, K_PRIO_COOP(THREAD_PRIORITY), 0, 0);

}
80000ffc:	01c12083          	lw	ra,28(sp)
80001000:	02010113          	addi	sp,sp,32
80001004:	00008067          	ret

80001008 <kernel_thread_entry>:
	thread_evidence++;      /* Prove that the thread has run */
80001008:	800087b7          	lui	a5,0x80008
8000100c:	6d078793          	addi	a5,a5,1744 # 800086d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086d1>
80001010:	0007a703          	lw	a4,0(a5)
{
80001014:	fe010113          	addi	sp,sp,-32
80001018:	00812c23          	sw	s0,24(sp)
8000101c:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001020:	80008537          	lui	a0,0x80008
80001024:	00112e23          	sw	ra,28(sp)
	thread_evidence++;      /* Prove that the thread has run */
80001028:	00170713          	addi	a4,a4,1
{
8000102c:	00912a23          	sw	s1,20(sp)
80001030:	01212823          	sw	s2,16(sp)
80001034:	01312623          	sw	s3,12(sp)
80001038:	01412423          	sw	s4,8(sp)
8000103c:	fff00593          	li	a1,-1
80001040:	72c50513          	addi	a0,a0,1836 # 8000872c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000872d>
	thread_evidence++;      /* Prove that the thread has run */
80001044:	00e7a023          	sw	a4,0(a5)
80001048:	03d040ef          	jal	ra,80005884 <z_impl_k_sem_take>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000104c:	680040ef          	jal	ra,800056cc <z_impl_k_current_get>
80001050:	00050993          	mv	s3,a0
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80001054:	80007a37          	lui	s4,0x80007
80001058:	40a40533          	sub	a0,s0,a0
8000105c:	800077b7          	lui	a5,0x80007
	isr_info.command = THREAD_SELF_CMD;
80001060:	80008437          	lui	s0,0x80008
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80001064:	800084b7          	lui	s1,0x80008
80001068:	800075b7          	lui	a1,0x80007
	isr_info.command = THREAD_SELF_CMD;
8000106c:	71040913          	addi	s2,s0,1808 # 80008710 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008711>
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80001070:	2a478793          	addi	a5,a5,676 # 800072a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a5>
80001074:	00a03533          	snez	a0,a0
80001078:	098a0713          	addi	a4,s4,152 # 80007098 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007099>
8000107c:	1ea00693          	li	a3,490
80001080:	acc48613          	addi	a2,s1,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
80001084:	2c458593          	addi	a1,a1,708 # 800072c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c5>
80001088:	bfdff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	isr_info.command = THREAD_SELF_CMD;
8000108c:	00092023          	sw	zero,0(s2)
	isr_info.error = 0;
80001090:	00092223          	sw	zero,4(s2)
	isr_handler_trigger();
80001094:	9bdff0ef          	jal	ra,80000a50 <isr_handler_trigger>
	zassert_false((isr_info.error || (isr_info.data != (void *)self_thread_id)),
80001098:	00492783          	lw	a5,4(s2)
8000109c:	71040413          	addi	s0,s0,1808
800010a0:	00000513          	li	a0,0
800010a4:	00079863          	bnez	a5,800010b4 <kernel_thread_entry+0xac>
800010a8:	00842503          	lw	a0,8(s0)
800010ac:	41350533          	sub	a0,a0,s3
800010b0:	00153513          	seqz	a0,a0
800010b4:	800077b7          	lui	a5,0x80007
800010b8:	800075b7          	lui	a1,0x80007
800010bc:	098a0713          	addi	a4,s4,152
800010c0:	acc48613          	addi	a2,s1,-1332
800010c4:	1f400693          	li	a3,500
800010c8:	32058593          	addi	a1,a1,800 # 80007320 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007321>
800010cc:	2f078793          	addi	a5,a5,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800010d0:	bb5ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	isr_info.command = EXEC_CTX_TYPE_CMD;
800010d4:	00100793          	li	a5,1
800010d8:	00f42023          	sw	a5,0(s0)
	isr_info.error = 0;
800010dc:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
800010e0:	971ff0ef          	jal	ra,80000a50 <isr_handler_trigger>
	zassert_false((isr_info.error || (isr_info.value != K_ISR)),
800010e4:	00842783          	lw	a5,8(s0)
800010e8:	00442503          	lw	a0,4(s0)
800010ec:	800075b7          	lui	a1,0x80007
800010f0:	098a0713          	addi	a4,s4,152
800010f4:	00f56533          	or	a0,a0,a5
800010f8:	800077b7          	lui	a5,0x80007
800010fc:	acc48613          	addi	a2,s1,-1332
80001100:	36878793          	addi	a5,a5,872 # 80007368 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007369>
80001104:	1fa00693          	li	a3,506
80001108:	39858593          	addi	a1,a1,920 # 80007398 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007399>
8000110c:	00153513          	seqz	a0,a0
80001110:	b75ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	zassert_false(k_is_in_isr(), "k_is_in_isr() when called from a thread is true");
80001114:	159040ef          	jal	ra,80005a6c <k_is_in_isr>
80001118:	00154513          	xori	a0,a0,1
8000111c:	800077b7          	lui	a5,0x80007
80001120:	800085b7          	lui	a1,0x80008
80001124:	098a0713          	addi	a4,s4,152
80001128:	acc48613          	addi	a2,s1,-1332
8000112c:	3d078793          	addi	a5,a5,976 # 800073d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073d1>
80001130:	1fc00693          	li	a3,508
80001134:	9a058593          	addi	a1,a1,-1632 # 800079a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800079a1>
80001138:	0ff57513          	andi	a0,a0,255
8000113c:	b49ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	zassert_false((_current->base.prio >= 0),
80001140:	800097b7          	lui	a5,0x80009
80001144:	d447a783          	lw	a5,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
}
80001148:	01812403          	lw	s0,24(sp)
8000114c:	01c12083          	lw	ra,28(sp)
	zassert_false((_current->base.prio >= 0),
80001150:	00e78503          	lb	a0,14(a5)
}
80001154:	01012903          	lw	s2,16(sp)
80001158:	00c12983          	lw	s3,12(sp)
	zassert_false((_current->base.prio >= 0),
8000115c:	098a0713          	addi	a4,s4,152
80001160:	acc48613          	addi	a2,s1,-1332
}
80001164:	00812a03          	lw	s4,8(sp)
80001168:	01412483          	lw	s1,20(sp)
	zassert_false((_current->base.prio >= 0),
8000116c:	800077b7          	lui	a5,0x80007
80001170:	800075b7          	lui	a1,0x80007
80001174:	40078793          	addi	a5,a5,1024 # 80007400 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007401>
80001178:	1ff00693          	li	a3,511
8000117c:	42458593          	addi	a1,a1,1060 # 80007424 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007425>
80001180:	01f55513          	srli	a0,a0,0x1f
}
80001184:	02010113          	addi	sp,sp,32
	zassert_false((_current->base.prio >= 0),
80001188:	afdff06f          	j	80000c84 <z_zassert.constprop.2>

8000118c <test_busy_wait>:
{
8000118c:	fe010113          	addi	sp,sp,-32
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001190:	800016b7          	lui	a3,0x80001
80001194:	800095b7          	lui	a1,0x80009
80001198:	80009537          	lui	a0,0x80009
8000119c:	00000793          	li	a5,0
800011a0:	01400713          	li	a4,20
800011a4:	ba468693          	addi	a3,a3,-1116 # 80000ba4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000ba5>
800011a8:	18000613          	li	a2,384
800011ac:	00012223          	sw	zero,4(sp)
800011b0:	00012023          	sw	zero,0(sp)
800011b4:	ff400893          	li	a7,-12
800011b8:	00000813          	li	a6,0
800011bc:	37058593          	addi	a1,a1,880 # 80009370 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80009371>
800011c0:	8a050513          	addi	a0,a0,-1888 # 800088a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800088a1>
800011c4:	00112e23          	sw	ra,28(sp)
800011c8:	3d9040ef          	jal	ra,80005da0 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800011cc:	80008537          	lui	a0,0x80008
800011d0:	02800593          	li	a1,40
800011d4:	71c50513          	addi	a0,a0,1820 # 8000871c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000871d>
800011d8:	6ac040ef          	jal	ra,80005884 <z_impl_k_sem_take>
}
800011dc:	01c12083          	lw	ra,28(sp)
	zassert_false(rv, " *** thread timed out waiting for " "k_busy_wait()");
800011e0:	800077b7          	lui	a5,0x80007
800011e4:	80007737          	lui	a4,0x80007
800011e8:	80008637          	lui	a2,0x80008
800011ec:	800075b7          	lui	a1,0x80007
800011f0:	51478793          	addi	a5,a5,1300 # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
800011f4:	0cc70713          	addi	a4,a4,204 # 800070cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070cd>
800011f8:	2e800693          	li	a3,744
800011fc:	acc60613          	addi	a2,a2,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
80001200:	54458593          	addi	a1,a1,1348 # 80007544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007545>
80001204:	00153513          	seqz	a0,a0
}
80001208:	02010113          	addi	sp,sp,32
	zassert_false(rv, " *** thread timed out waiting for " "k_busy_wait()");
8000120c:	a79ff06f          	j	80000c84 <z_zassert.constprop.2>

80001210 <test_k_yield>:
{
80001210:	fe010113          	addi	sp,sp,-32
80001214:	00912a23          	sw	s1,20(sp)
	thread_evidence = 0;
80001218:	800084b7          	lui	s1,0x80008
8000121c:	6d048493          	addi	s1,s1,1744 # 800086d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086d1>
{
80001220:	00112e23          	sw	ra,28(sp)
80001224:	00812c23          	sw	s0,24(sp)
	thread_evidence = 0;
80001228:	0004a023          	sw	zero,0(s1)
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000122c:	4a0040ef          	jal	ra,800056cc <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80001230:	00000593          	li	a1,0
80001234:	791030ef          	jal	ra,800051c4 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001238:	80008437          	lui	s0,0x80008
8000123c:	72c40513          	addi	a0,s0,1836 # 8000872c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000872d>
80001240:	fff00613          	li	a2,-1
80001244:	00000593          	li	a1,0
80001248:	490040ef          	jal	ra,800056d8 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
8000124c:	800016b7          	lui	a3,0x80001
80001250:	800095b7          	lui	a1,0x80009
80001254:	80008537          	lui	a0,0x80008
80001258:	ff400893          	li	a7,-12
8000125c:	00012223          	sw	zero,4(sp)
80001260:	00012023          	sw	zero,0(sp)
80001264:	00000813          	li	a6,0
80001268:	00000793          	li	a5,0
8000126c:	00000713          	li	a4,0
80001270:	6f068693          	addi	a3,a3,1776 # 800016f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800016f1>
80001274:	20000613          	li	a2,512
80001278:	d7058593          	addi	a1,a1,-656 # 80008d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d71>
8000127c:	73c50513          	addi	a0,a0,1852 # 8000873c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000873d>
80001280:	321040ef          	jal	ra,80005da0 <z_impl_k_thread_create>
	zassert_equal(thread_evidence, 1,
80001284:	0004a803          	lw	a6,0(s1)
80001288:	800077b7          	lui	a5,0x80007
8000128c:	80007737          	lui	a4,0x80007
80001290:	fff80513          	addi	a0,a6,-1
80001294:	80008637          	lui	a2,0x80008
80001298:	800085b7          	lui	a1,0x80008
8000129c:	7e878793          	addi	a5,a5,2024 # 800077e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077e9>
800012a0:	0ec70713          	addi	a4,a4,236 # 800070ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070ed>
800012a4:	37c00693          	li	a3,892
800012a8:	acc60613          	addi	a2,a2,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
800012ac:	81058593          	addi	a1,a1,-2032 # 80007810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007811>
800012b0:	00153513          	seqz	a0,a0
800012b4:	9d1ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800012b8:	72c40513          	addi	a0,s0,1836
800012bc:	4e4040ef          	jal	ra,800057a0 <z_impl_k_sem_give>
800012c0:	72c40513          	addi	a0,s0,1836
800012c4:	4dc040ef          	jal	ra,800057a0 <z_impl_k_sem_give>
800012c8:	72c40513          	addi	a0,s0,1836
}
800012cc:	01812403          	lw	s0,24(sp)
800012d0:	01c12083          	lw	ra,28(sp)
800012d4:	01412483          	lw	s1,20(sp)
800012d8:	02010113          	addi	sp,sp,32
800012dc:	4c40406f          	j	800057a0 <z_impl_k_sem_give>

800012e0 <test_k_sleep>:
{
800012e0:	f7010113          	addi	sp,sp,-144
800012e4:	07312e23          	sw	s3,124(sp)
800012e8:	07412c23          	sw	s4,120(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800012ec:	800099b7          	lui	s3,0x80009
800012f0:	80009a37          	lui	s4,0x80009
800012f4:	800016b7          	lui	a3,0x80001
800012f8:	ff400893          	li	a7,-12
800012fc:	00000813          	li	a6,0
80001300:	00000793          	li	a5,0
80001304:	03200713          	li	a4,50
80001308:	ab068693          	addi	a3,a3,-1360 # 80000ab0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000ab1>
8000130c:	18000613          	li	a2,384
80001310:	37098593          	addi	a1,s3,880 # 80009370 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80009371>
80001314:	8a0a0513          	addi	a0,s4,-1888 # 800088a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800088a1>
80001318:	00012223          	sw	zero,4(sp)
8000131c:	00012023          	sw	zero,0(sp)
80001320:	08112623          	sw	ra,140(sp)
80001324:	08812423          	sw	s0,136(sp)
80001328:	08912223          	sw	s1,132(sp)
8000132c:	09212023          	sw	s2,128(sp)
80001330:	07512a23          	sw	s5,116(sp)
80001334:	07612823          	sw	s6,112(sp)
80001338:	07712623          	sw	s7,108(sp)
8000133c:	07812423          	sw	s8,104(sp)
80001340:	07912223          	sw	s9,100(sp)
80001344:	07a12023          	sw	s10,96(sp)
80001348:	05b12e23          	sw	s11,92(sp)
8000134c:	255040ef          	jal	ra,80005da0 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001350:	80008537          	lui	a0,0x80008
80001354:	06400593          	li	a1,100
80001358:	71c50513          	addi	a0,a0,1820 # 8000871c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000871d>
8000135c:	528040ef          	jal	ra,80005884 <z_impl_k_sem_take>
	zassert_equal(rv, 0, " *** thread timed out waiting for thread on "
80001360:	80007437          	lui	s0,0x80007
80001364:	800077b7          	lui	a5,0x80007
80001368:	800084b7          	lui	s1,0x80008
8000136c:	800075b7          	lui	a1,0x80007
80001370:	55478793          	addi	a5,a5,1364 # 80007554 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007555>
80001374:	0dc40713          	addi	a4,s0,220 # 800070dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070dd>
80001378:	30300693          	li	a3,771
8000137c:	acc48613          	addi	a2,s1,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
80001380:	58c58593          	addi	a1,a1,1420 # 8000758c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000758d>
80001384:	00153513          	seqz	a0,a0
80001388:	8fdff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	TC_PRINT("Testing k_thread_create() without cancellation\n");
8000138c:	80007537          	lui	a0,0x80007
80001390:	80008ab7          	lui	s5,0x80008
80001394:	5a050513          	addi	a0,a0,1440 # 800075a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075a1>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001398:	80001d37          	lui	s10,0x80001
8000139c:	5f0a8b13          	addi	s6,s5,1520 # 800085f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800085f1>
800013a0:	8a0a0b93          	addi	s7,s4,-1888
800013a4:	37098913          	addi	s2,s3,880
800013a8:	71c010ef          	jal	ra,80002ac4 <printk>
800013ac:	37098993          	addi	s3,s3,880
800013b0:	8a0a0a13          	addi	s4,s4,-1888
800013b4:	5f0a8a93          	addi	s5,s5,1520
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800013b8:	00000c13          	li	s8,0
800013bc:	00700d93          	li	s11,7
800013c0:	000d0c93          	mv	s9,s10
800013c4:	004aa783          	lw	a5,4(s5)
800013c8:	000c0713          	mv	a4,s8
800013cc:	00098593          	mv	a1,s3
800013d0:	00f12223          	sw	a5,4(sp)
800013d4:	000a0513          	mv	a0,s4
800013d8:	00012023          	sw	zero,0(sp)
800013dc:	ff500893          	li	a7,-11
800013e0:	00000813          	li	a6,0
800013e4:	00000793          	li	a5,0
800013e8:	a64d0693          	addi	a3,s10,-1436 # 80000a64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a65>
800013ec:	18000613          	li	a2,384
800013f0:	001c0c13          	addi	s8,s8,1
800013f4:	1ad040ef          	jal	ra,80005da0 <z_impl_k_thread_create>
800013f8:	010a8a93          	addi	s5,s5,16
800013fc:	070a0a13          	addi	s4,s4,112
80001400:	18098993          	addi	s3,s3,384
80001404:	fdbc10e3          	bne	s8,s11,800013c4 <test_k_sleep+0xe4>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80001408:	80009337          	lui	t1,0x80009
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
8000140c:	00000d93          	li	s11,0
		zassert_not_null(data, " *** timeout while waiting for"
80001410:	80007d37          	lui	s10,0x80007
80001414:	80007ab7          	lui	s5,0x80007
		zassert_equal(data->timeout_order, i,
80001418:	80007a37          	lui	s4,0x80007
8000141c:	00030c13          	mv	s8,t1
80001420:	88c30513          	addi	a0,t1,-1908 # 8000888c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000888d>
80001424:	2ee00593          	li	a1,750
80001428:	6ac020ef          	jal	ra,80003ad4 <z_impl_k_queue_get>
8000142c:	00050993          	mv	s3,a0
		zassert_not_null(data, " *** timeout while waiting for"
80001430:	5d0d0793          	addi	a5,s10,1488 # 800075d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075d1>
80001434:	0dc40713          	addi	a4,s0,220
80001438:	31300693          	li	a3,787
8000143c:	acc48613          	addi	a2,s1,-1332
80001440:	600a8593          	addi	a1,s5,1536 # 80007600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007601>
80001444:	00a03533          	snez	a0,a0
80001448:	83dff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
		zassert_equal(data->timeout_order, i,
8000144c:	0089a803          	lw	a6,8(s3)
80001450:	80007e37          	lui	t3,0x80007
80001454:	648e0593          	addi	a1,t3,1608 # 80007648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007649>
80001458:	41b80533          	sub	a0,a6,s11
8000145c:	000d8893          	mv	a7,s11
80001460:	610a0793          	addi	a5,s4,1552 # 80007610 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007611>
80001464:	0dc40713          	addi	a4,s0,220
80001468:	31700693          	li	a3,791
8000146c:	acc48613          	addi	a2,s1,-1332
80001470:	00153513          	seqz	a0,a0
80001474:	811ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
		TC_PRINT(" got thread (q order: %d, t/o: %d) as expected\n",
80001478:	0049a603          	lw	a2,4(s3)
8000147c:	00c9a583          	lw	a1,12(s3)
80001480:	80007537          	lui	a0,0x80007
80001484:	67050513          	addi	a0,a0,1648 # 80007670 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007671>
80001488:	63c010ef          	jal	ra,80002ac4 <printk>
8000148c:	80007e37          	lui	t3,0x80007
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001490:	001d8d93          	addi	s11,s11,1
80001494:	00700793          	li	a5,7
80001498:	01c12c23          	sw	t3,24(sp)
8000149c:	80009337          	lui	t1,0x80009
800014a0:	f8fd90e3          	bne	s11,a5,80001420 <test_k_sleep+0x140>
800014a4:	88c30513          	addi	a0,t1,-1908 # 8000888c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000888d>
800014a8:	2ee00593          	li	a1,750
800014ac:	628020ef          	jal	ra,80003ad4 <z_impl_k_queue_get>
	zassert_false(data, " *** got something unexpected in the fifo");
800014b0:	80007a37          	lui	s4,0x80007
800014b4:	80007ab7          	lui	s5,0x80007
800014b8:	6a0a0793          	addi	a5,s4,1696 # 800076a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a1>
800014bc:	0dc40713          	addi	a4,s0,220
800014c0:	32000693          	li	a3,800
800014c4:	acc48613          	addi	a2,s1,-1332
800014c8:	6cca8593          	addi	a1,s5,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
800014cc:	00153513          	seqz	a0,a0
800014d0:	fb4ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	TC_PRINT("Testing k_thread_create() with cancellations\n");
800014d4:	80007537          	lui	a0,0x80007
800014d8:	6dc50513          	addi	a0,a0,1756 # 800076dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076dd>
800014dc:	5e8010ef          	jal	ra,80002ac4 <printk>
	int cancellations[] = { 0, 3, 4, 6 };
800014e0:	800075b7          	lui	a1,0x80007
800014e4:	01000613          	li	a2,16
800014e8:	f5858593          	addi	a1,a1,-168 # 80006f58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f59>
800014ec:	02410513          	addi	a0,sp,36
800014f0:	3d1010ef          	jal	ra,800030c0 <memcpy>
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800014f4:	03410d93          	addi	s11,sp,52
	int cancellations[] = { 0, 3, 4, 6 };
800014f8:	000b0313          	mv	t1,s6
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800014fc:	00000d13          	li	s10,0
80001500:	00700993          	li	s3,7
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001504:	00432783          	lw	a5,4(t1)
80001508:	000d0713          	mv	a4,s10
8000150c:	00090593          	mv	a1,s2
80001510:	00f12223          	sw	a5,4(sp)
80001514:	000b8513          	mv	a0,s7
80001518:	00012023          	sw	zero,0(sp)
8000151c:	ff500893          	li	a7,-11
80001520:	00000813          	li	a6,0
80001524:	00000793          	li	a5,0
80001528:	a64c8693          	addi	a3,s9,-1436
8000152c:	18000613          	li	a2,384
80001530:	00612e23          	sw	t1,28(sp)
80001534:	06d040ef          	jal	ra,80005da0 <z_impl_k_thread_create>
		delayed_threads[i] = id;
80001538:	01c12303          	lw	t1,28(sp)
8000153c:	00ada023          	sw	a0,0(s11)
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001540:	001d0d13          	addi	s10,s10,1
80001544:	01030313          	addi	t1,t1,16
80001548:	070b8b93          	addi	s7,s7,112
8000154c:	18090913          	addi	s2,s2,384
80001550:	004d8d93          	addi	s11,s11,4
80001554:	fb3d18e3          	bne	s10,s3,80001504 <test_k_sleep+0x224>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80001558:	00001bb7          	lui	s7,0x1
8000155c:	000b0913          	mv	s2,s6
	int next_cancellation = 0;
80001560:	00000993          	li	s3,0
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001564:	00000d13          	li	s10,0
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
80001568:	00700c93          	li	s9,7
8000156c:	abeb8b93          	addi	s7,s7,-1346 # abe <CONFIG_ISR_STACK_SIZE+0x2be>
		if (i == cancellations[next_cancellation]) {
80001570:	00299793          	slli	a5,s3,0x2
80001574:	05010713          	addi	a4,sp,80
80001578:	00f707b3          	add	a5,a4,a5
8000157c:	fd47a783          	lw	a5,-44(a5)
80001580:	11a78e63          	beq	a5,s10,8000169c <test_k_sleep+0x3bc>
80001584:	000b8593          	mv	a1,s7
80001588:	88cc0513          	addi	a0,s8,-1908
8000158c:	548020ef          	jal	ra,80003ad4 <z_impl_k_queue_get>
		zassert_not_null(data, " *** timeout while waiting for"
80001590:	800077b7          	lui	a5,0x80007
80001594:	800075b7          	lui	a1,0x80007
80001598:	00050d93          	mv	s11,a0
8000159c:	5d078793          	addi	a5,a5,1488 # 800075d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075d1>
800015a0:	0dc40713          	addi	a4,s0,220
800015a4:	34e00693          	li	a3,846
800015a8:	acc48613          	addi	a2,s1,-1332
800015ac:	60058593          	addi	a1,a1,1536 # 80007600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007601>
800015b0:	00a03533          	snez	a0,a0
800015b4:	ed0ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
		zassert_equal(data->timeout_order, i,
800015b8:	008da803          	lw	a6,8(s11)
800015bc:	01812583          	lw	a1,24(sp)
800015c0:	800077b7          	lui	a5,0x80007
800015c4:	410d0533          	sub	a0,s10,a6
800015c8:	61078793          	addi	a5,a5,1552 # 80007610 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007611>
800015cc:	35200693          	li	a3,850
800015d0:	acc48613          	addi	a2,s1,-1332
800015d4:	64858593          	addi	a1,a1,1608
800015d8:	00153513          	seqz	a0,a0
800015dc:	000d0893          	mv	a7,s10
800015e0:	0dc40713          	addi	a4,s0,220
800015e4:	ea0ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
		TC_PRINT(" got (q order: %d, t/o: %d, t/o order %d) "
800015e8:	008da683          	lw	a3,8(s11)
800015ec:	004da603          	lw	a2,4(s11)
800015f0:	00cda583          	lw	a1,12(s11)
800015f4:	800077b7          	lui	a5,0x80007
800015f8:	70c78513          	addi	a0,a5,1804 # 8000770c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000770d>
800015fc:	4c8010ef          	jal	ra,80002ac4 <printk>
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001600:	001d0d13          	addi	s10,s10,1
80001604:	01090913          	addi	s2,s2,16
80001608:	f79d14e3          	bne	s10,s9,80001570 <test_k_sleep+0x290>
	zassert_equal(num_cancellations, next_cancellation,
8000160c:	ffc98513          	addi	a0,s3,-4
80001610:	800077b7          	lui	a5,0x80007
80001614:	800075b7          	lui	a1,0x80007
80001618:	0dc40713          	addi	a4,s0,220
8000161c:	acc48613          	addi	a2,s1,-1332
80001620:	00098893          	mv	a7,s3
80001624:	77878793          	addi	a5,a5,1912 # 80007778 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007779>
80001628:	35b00693          	li	a3,859
8000162c:	00400813          	li	a6,4
80001630:	7b458593          	addi	a1,a1,1972 # 800077b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077b5>
80001634:	00153513          	seqz	a0,a0
80001638:	e4cff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
8000163c:	2ee00593          	li	a1,750
80001640:	88cc0513          	addi	a0,s8,-1908
80001644:	490020ef          	jal	ra,80003ad4 <z_impl_k_queue_get>
	zassert_false(data, " *** got something unexpected in the fifo");
80001648:	0dc40713          	addi	a4,s0,220
}
8000164c:	08812403          	lw	s0,136(sp)
80001650:	08c12083          	lw	ra,140(sp)
80001654:	08012903          	lw	s2,128(sp)
80001658:	07c12983          	lw	s3,124(sp)
8000165c:	07012b03          	lw	s6,112(sp)
80001660:	06c12b83          	lw	s7,108(sp)
80001664:	06812c03          	lw	s8,104(sp)
80001668:	06412c83          	lw	s9,100(sp)
8000166c:	06012d03          	lw	s10,96(sp)
80001670:	05c12d83          	lw	s11,92(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
80001674:	6a0a0793          	addi	a5,s4,1696
80001678:	acc48613          	addi	a2,s1,-1332
}
8000167c:	07812a03          	lw	s4,120(sp)
80001680:	08412483          	lw	s1,132(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
80001684:	6cca8593          	addi	a1,s5,1740
}
80001688:	07412a83          	lw	s5,116(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
8000168c:	35f00693          	li	a3,863
80001690:	00153513          	seqz	a0,a0
}
80001694:	09010113          	addi	sp,sp,144
	zassert_false(data, " *** got something unexpected in the fifo");
80001698:	decff06f          	j	80000c84 <z_zassert.constprop.2>
			TC_PRINT(" cancelling "
8000169c:	00492603          	lw	a2,4(s2)
800016a0:	00c92583          	lw	a1,12(s2)
800016a4:	800077b7          	lui	a5,0x80007
800016a8:	74478513          	addi	a0,a5,1860 # 80007744 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007745>
800016ac:	000d0693          	mv	a3,s10
800016b0:	414010ef          	jal	ra,80002ac4 <printk>
800016b4:	000b0713          	mv	a4,s6
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
800016b8:	00000793          	li	a5,0
				if (timeouts[j].timeout_order == i) {
800016bc:	00872683          	lw	a3,8(a4)
800016c0:	01a68a63          	beq	a3,s10,800016d4 <test_k_sleep+0x3f4>
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
800016c4:	00178793          	addi	a5,a5,1
800016c8:	01070713          	addi	a4,a4,16
800016cc:	ff9798e3          	bne	a5,s9,800016bc <test_k_sleep+0x3dc>
800016d0:	eb5ff06f          	j	80001584 <test_k_sleep+0x2a4>
				k_thread_abort(delayed_threads[j]);
800016d4:	05010713          	addi	a4,sp,80
800016d8:	00279793          	slli	a5,a5,0x2
800016dc:	00f707b3          	add	a5,a4,a5
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800016e0:	fe47a503          	lw	a0,-28(a5)
				++next_cancellation;
800016e4:	00198993          	addi	s3,s3,1
800016e8:	05d040ef          	jal	ra,80005f44 <z_impl_k_thread_abort>
				continue;
800016ec:	f15ff06f          	j	80001600 <test_k_sleep+0x320>

800016f0 <k_yield_entry>:
{
800016f0:	fd010113          	addi	sp,sp,-48
800016f4:	02812423          	sw	s0,40(sp)
	thread_evidence++;      /* Prove that the thread has run */
800016f8:	80008437          	lui	s0,0x80008
800016fc:	6d040413          	addi	s0,s0,1744 # 800086d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086d1>
80001700:	00042783          	lw	a5,0(s0)
{
80001704:	01312e23          	sw	s3,28(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001708:	800089b7          	lui	s3,0x80008
	thread_evidence++;      /* Prove that the thread has run */
8000170c:	00178793          	addi	a5,a5,1
80001710:	fff00593          	li	a1,-1
80001714:	72c98513          	addi	a0,s3,1836 # 8000872c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000872d>
{
80001718:	02112623          	sw	ra,44(sp)
8000171c:	02912223          	sw	s1,36(sp)
80001720:	03212023          	sw	s2,32(sp)
80001724:	01412c23          	sw	s4,24(sp)
	thread_evidence++;      /* Prove that the thread has run */
80001728:	00f42023          	sw	a5,0(s0)
8000172c:	158040ef          	jal	ra,80005884 <z_impl_k_sem_take>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001730:	79d030ef          	jal	ra,800056cc <z_impl_k_current_get>
80001734:	00050a13          	mv	s4,a0
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001738:	800016b7          	lui	a3,0x80001
8000173c:	800095b7          	lui	a1,0x80009
80001740:	80008537          	lui	a0,0x80008
80001744:	ff300893          	li	a7,-13
80001748:	00000813          	li	a6,0
8000174c:	00012223          	sw	zero,4(sp)
80001750:	00012023          	sw	zero,0(sp)
80001754:	00000793          	li	a5,0
80001758:	00000713          	li	a4,0
8000175c:	a0068693          	addi	a3,a3,-1536 # 80000a00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a01>
80001760:	20000613          	li	a2,512
80001764:	f7058593          	addi	a1,a1,-144 # 80008f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008f71>
80001768:	7ac50513          	addi	a0,a0,1964 # 800087ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800087ad>
	thread_evidence = 0;
8000176c:	00042023          	sw	zero,0(s0)
80001770:	630040ef          	jal	ra,80005da0 <z_impl_k_thread_create>
	zassert_equal(thread_evidence, 0,
80001774:	00042503          	lw	a0,0(s0)
80001778:	80007937          	lui	s2,0x80007
8000177c:	800084b7          	lui	s1,0x80008
80001780:	800077b7          	lui	a5,0x80007
80001784:	800075b7          	lui	a1,0x80007
80001788:	0ac90713          	addi	a4,s2,172 # 800070ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070ad>
8000178c:	acc48613          	addi	a2,s1,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
80001790:	16c78793          	addi	a5,a5,364 # 8000716c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000716d>
80001794:	24800693          	li	a3,584
80001798:	1a058593          	addi	a1,a1,416 # 800071a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a1>
8000179c:	00153513          	seqz	a0,a0
800017a0:	ce4ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800017a4:	2f1030ef          	jal	ra,80005294 <z_impl_k_yield>
	zassert_not_equal(thread_evidence, 0,
800017a8:	00042803          	lw	a6,0(s0)
800017ac:	800077b7          	lui	a5,0x80007
800017b0:	800075b7          	lui	a1,0x80007
800017b4:	0ac90713          	addi	a4,s2,172
800017b8:	acc48613          	addi	a2,s1,-1332
800017bc:	01003533          	snez	a0,a6
800017c0:	1c478793          	addi	a5,a5,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800017c4:	25200693          	li	a3,594
800017c8:	1fc58593          	addi	a1,a1,508 # 800071fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071fd>
800017cc:	cb8ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	zassert_false((thread_evidence > 1),
800017d0:	00042803          	lw	a6,0(s0)
800017d4:	800077b7          	lui	a5,0x80007
800017d8:	800075b7          	lui	a1,0x80007
800017dc:	0ac90713          	addi	a4,s2,172
800017e0:	acc48613          	addi	a2,s1,-1332
800017e4:	00282513          	slti	a0,a6,2
800017e8:	21c78793          	addi	a5,a5,540 # 8000721c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000721d>
800017ec:	25600693          	li	a3,598
800017f0:	25458593          	addi	a1,a1,596 # 80007254 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007255>
800017f4:	c90ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
	k_thread_priority_set(self_thread_id, self_thread_id->base.prio - 1);
800017f8:	00ea0583          	lb	a1,14(s4)
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
800017fc:	000a0513          	mv	a0,s4
80001800:	fff58593          	addi	a1,a1,-1
80001804:	1c1030ef          	jal	ra,800051c4 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80001808:	28d030ef          	jal	ra,80005294 <z_impl_k_yield>
	zassert_equal(thread_evidence, 1,
8000180c:	00042503          	lw	a0,0(s0)
80001810:	800077b7          	lui	a5,0x80007
80001814:	800085b7          	lui	a1,0x80008
80001818:	fff50513          	addi	a0,a0,-1
8000181c:	0ac90713          	addi	a4,s2,172
80001820:	acc48613          	addi	a2,s1,-1332
80001824:	81058593          	addi	a1,a1,-2032 # 80007810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007811>
80001828:	00153513          	seqz	a0,a0
8000182c:	27478793          	addi	a5,a5,628 # 80007274 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007275>
80001830:	26000693          	li	a3,608
80001834:	c50ff0ef          	jal	ra,80000c84 <z_zassert.constprop.2>
}
80001838:	02812403          	lw	s0,40(sp)
8000183c:	02c12083          	lw	ra,44(sp)
80001840:	02412483          	lw	s1,36(sp)
80001844:	02012903          	lw	s2,32(sp)
80001848:	01812a03          	lw	s4,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
8000184c:	72c98513          	addi	a0,s3,1836
80001850:	01c12983          	lw	s3,28(sp)
80001854:	fff00593          	li	a1,-1
80001858:	03010113          	addi	sp,sp,48
8000185c:	0280406f          	j	80005884 <z_impl_k_sem_take>

80001860 <test_main>:
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001860:	80008537          	lui	a0,0x80008

/*test case main entry*/
void test_main(void)
{
80001864:	ff010113          	addi	sp,sp,-16
80001868:	fff00613          	li	a2,-1
8000186c:	00000593          	li	a1,0
80001870:	71c50513          	addi	a0,a0,1820 # 8000871c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000871d>
80001874:	00112623          	sw	ra,12(sp)
80001878:	661030ef          	jal	ra,800056d8 <z_impl_k_sem_init>
	k_timer_init(&timer, NULL, NULL);
8000187c:	80009537          	lui	a0,0x80009
80001880:	00000593          	li	a1,0
80001884:	00000613          	li	a2,0
80001888:	bb050513          	addi	a0,a0,-1104 # 80008bb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008bb1>
8000188c:	124050ef          	jal	ra,800069b0 <k_timer_init>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80001890:	80009537          	lui	a0,0x80009
80001894:	88c50513          	addi	a0,a0,-1908 # 8000888c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000888d>
80001898:	210020ef          	jal	ra,80003aa8 <z_impl_k_queue_init>
			 ztest_unit_test(test_kernel_cpu_idle),
			 ztest_unit_test(test_k_yield),
			 ztest_unit_test(test_kernel_thread)
			 );
	ztest_run_test_suite(context);
}
8000189c:	00c12083          	lw	ra,12(sp)
	ztest_run_test_suite(context);
800018a0:	800085b7          	lui	a1,0x80008
800018a4:	80008537          	lui	a0,0x80008
800018a8:	52858593          	addi	a1,a1,1320 # 80008528 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008529>
800018ac:	a4850513          	addi	a0,a0,-1464 # 80007a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a49>
}
800018b0:	01010113          	addi	sp,sp,16
	ztest_run_test_suite(context);
800018b4:	2250106f          	j	800032d8 <z_ztest_run_test_suite>

800018b8 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
800018b8:	ff010113          	addi	sp,sp,-16
800018bc:	00112623          	sw	ra,12(sp)
800018c0:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
800018c4:	00600793          	li	a5,6
800018c8:	02f50463          	beq	a0,a5,800018f0 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
800018cc:	1a0040ef          	jal	ra,80005a6c <k_is_in_isr>
800018d0:	02050463          	beqz	a0,800018f8 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
800018d4:	198040ef          	jal	ra,80005a6c <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
800018d8:	04051663          	bnez	a0,80001924 <z_SysFatalErrorHandler+0x6c>
800018dc:	800085b7          	lui	a1,0x80008
800018e0:	dc858593          	addi	a1,a1,-568 # 80007dc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dc9>
800018e4:	80008537          	lui	a0,0x80008
800018e8:	ddc50513          	addi	a0,a0,-548 # 80007ddc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ddd>
800018ec:	1d8010ef          	jal	ra,80002ac4 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
800018f0:	244010ef          	jal	ra,80002b34 <k_cpu_idle>
800018f4:	ffdff06f          	j	800018f0 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
800018f8:	184040ef          	jal	ra,80005a7c <z_is_thread_essential>
800018fc:	fc051ce3          	bnez	a0,800018d4 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80001900:	80009437          	lui	s0,0x80009
80001904:	d3c40413          	addi	s0,s0,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80001908:	00842583          	lw	a1,8(s0)
8000190c:	80008537          	lui	a0,0x80008
80001910:	dfc50513          	addi	a0,a0,-516 # 80007dfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dfd>
80001914:	1b0010ef          	jal	ra,80002ac4 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001918:	00842503          	lw	a0,8(s0)
8000191c:	628040ef          	jal	ra,80005f44 <z_impl_k_thread_abort>
80001920:	fd1ff06f          	j	800018f0 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80001924:	800085b7          	lui	a1,0x80008
80001928:	dc458593          	addi	a1,a1,-572 # 80007dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007dc5>
8000192c:	fb9ff06f          	j	800018e4 <z_SysFatalErrorHandler+0x2c>

80001930 <z_NanoFatalErrorHandler>:
{
80001930:	fb010113          	addi	sp,sp,-80
80001934:	04812423          	sw	s0,72(sp)
80001938:	04912223          	sw	s1,68(sp)
8000193c:	04112623          	sw	ra,76(sp)
	switch (reason) {
80001940:	00600793          	li	a5,6
{
80001944:	00050493          	mv	s1,a0
80001948:	00058413          	mv	s0,a1
	switch (reason) {
8000194c:	0ea7e063          	bltu	a5,a0,80001a2c <z_NanoFatalErrorHandler+0xfc>
80001950:	80008737          	lui	a4,0x80008
80001954:	00251793          	slli	a5,a0,0x2
80001958:	b1870713          	addi	a4,a4,-1256 # 80007b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b19>
8000195c:	00e787b3          	add	a5,a5,a4
80001960:	0007a783          	lw	a5,0(a5)
80001964:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80001968:	80008537          	lui	a0,0x80008
8000196c:	c4850513          	addi	a0,a0,-952 # 80007c48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c49>
		printk("***** Kernel OOPS! *****\n");
80001970:	154010ef          	jal	ra,80002ac4 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001974:	559030ef          	jal	ra,800056cc <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80001978:	04442783          	lw	a5,68(s0)
8000197c:	01042883          	lw	a7,16(s0)
80001980:	00c42803          	lw	a6,12(s0)
80001984:	02f12823          	sw	a5,48(sp)
80001988:	04042783          	lw	a5,64(s0)
8000198c:	00442703          	lw	a4,4(s0)
80001990:	00042683          	lw	a3,0(s0)
80001994:	02f12623          	sw	a5,44(sp)
80001998:	03c42783          	lw	a5,60(s0)
8000199c:	04842603          	lw	a2,72(s0)
800019a0:	00050593          	mv	a1,a0
800019a4:	02f12423          	sw	a5,40(sp)
800019a8:	03842783          	lw	a5,56(s0)
800019ac:	80008537          	lui	a0,0x80008
800019b0:	ccc50513          	addi	a0,a0,-820 # 80007ccc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ccd>
800019b4:	02f12223          	sw	a5,36(sp)
800019b8:	03442783          	lw	a5,52(s0)
800019bc:	02f12023          	sw	a5,32(sp)
800019c0:	03042783          	lw	a5,48(s0)
800019c4:	00f12e23          	sw	a5,28(sp)
800019c8:	02c42783          	lw	a5,44(s0)
800019cc:	00f12c23          	sw	a5,24(sp)
800019d0:	02842783          	lw	a5,40(s0)
800019d4:	00f12a23          	sw	a5,20(sp)
800019d8:	02442783          	lw	a5,36(s0)
800019dc:	00f12823          	sw	a5,16(sp)
800019e0:	02042783          	lw	a5,32(s0)
800019e4:	00f12623          	sw	a5,12(sp)
800019e8:	01c42783          	lw	a5,28(s0)
800019ec:	00f12423          	sw	a5,8(sp)
800019f0:	01842783          	lw	a5,24(s0)
800019f4:	00f12223          	sw	a5,4(sp)
800019f8:	01442783          	lw	a5,20(s0)
800019fc:	00f12023          	sw	a5,0(sp)
80001a00:	00842783          	lw	a5,8(s0)
80001a04:	0c0010ef          	jal	ra,80002ac4 <printk>
	z_SysFatalErrorHandler(reason, esf);
80001a08:	00040593          	mv	a1,s0
80001a0c:	00048513          	mv	a0,s1
80001a10:	ea9ff0ef          	jal	ra,800018b8 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80001a14:	80008537          	lui	a0,0x80008
80001a18:	c7050513          	addi	a0,a0,-912 # 80007c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c71>
80001a1c:	f55ff06f          	j	80001970 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80001a20:	80008537          	lui	a0,0x80008
80001a24:	c8c50513          	addi	a0,a0,-884 # 80007c8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c8d>
80001a28:	f49ff06f          	j	80001970 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80001a2c:	80008537          	lui	a0,0x80008
80001a30:	00048593          	mv	a1,s1
80001a34:	ca850513          	addi	a0,a0,-856 # 80007ca8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ca9>
80001a38:	08c010ef          	jal	ra,80002ac4 <printk>
		break;
80001a3c:	f39ff06f          	j	80001974 <z_NanoFatalErrorHandler+0x44>

80001a40 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80001a40:	ff010113          	addi	sp,sp,-16
80001a44:	00812423          	sw	s0,8(sp)
80001a48:	00112623          	sw	ra,12(sp)
80001a4c:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001a50:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80001a54:	00161613          	slli	a2,a2,0x1
80001a58:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80001a5c:	00500793          	li	a5,5
80001a60:	02c7e863          	bltu	a5,a2,80001a90 <_Fault+0x50>
80001a64:	80008737          	lui	a4,0x80008
80001a68:	00261793          	slli	a5,a2,0x2
80001a6c:	b3470713          	addi	a4,a4,-1228 # 80007b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b35>
80001a70:	00f707b3          	add	a5,a4,a5
80001a74:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001a78:	80008537          	lui	a0,0x80008
80001a7c:	b5450513          	addi	a0,a0,-1196 # 80007b54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b55>
80001a80:	044010ef          	jal	ra,80002ac4 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80001a84:	00040593          	mv	a1,s0
80001a88:	00000513          	li	a0,0
80001a8c:	ea5ff0ef          	jal	ra,80001930 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80001a90:	800085b7          	lui	a1,0x80008
80001a94:	b4c58593          	addi	a1,a1,-1204 # 80007b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b4d>
80001a98:	fe1ff06f          	j	80001a78 <_Fault+0x38>

80001a9c <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80001a9c:	ff010113          	addi	sp,sp,-16
80001aa0:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001aa4:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001aa8:	80008537          	lui	a0,0x80008
	mcause &= SOC_MCAUSE_EXP_MASK;
80001aac:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001ab0:	0015d593          	srli	a1,a1,0x1
80001ab4:	e2450513          	addi	a0,a0,-476 # 80007e24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e25>
80001ab8:	00c010ef          	jal	ra,80002ac4 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80001abc:	800085b7          	lui	a1,0x80008
80001ac0:	b7058593          	addi	a1,a1,-1168 # 80007b70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b71>
80001ac4:	00400513          	li	a0,4
80001ac8:	e69ff0ef          	jal	ra,80001930 <z_NanoFatalErrorHandler>

80001acc <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80001acc:	800087b7          	lui	a5,0x80008
80001ad0:	6d478793          	addi	a5,a5,1748 # 800086d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086d5>
80001ad4:	0007a703          	lw	a4,0(a5)
80001ad8:	00070c63          	beqz	a4,80001af0 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80001adc:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80001ae0:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80001ae4:	800087b7          	lui	a5,0x80008
80001ae8:	6d87a503          	lw	a0,1752(a5) # 800086d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086d9>
80001aec:	00030067          	jr	t1
}
80001af0:	00008067          	ret

80001af4 <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80001af4:	00800793          	li	a5,8
80001af8:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
80001afc:	80008737          	lui	a4,0x80008
80001b00:	6ca72a23          	sw	a0,1748(a4) # 800086d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086d5>
	offload_param = parameter;
80001b04:	80008737          	lui	a4,0x80008
80001b08:	6cb72c23          	sw	a1,1752(a4) # 800086d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086d9>

	__asm__ volatile ("ecall");
80001b0c:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80001b10:	0087f793          	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80001b14:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
80001b18:	00008067          	ret

80001b1c <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80001b1c:	ff010113          	addi	sp,sp,-16
80001b20:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80001b24:	369010ef          	jal	ra,8000368c <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80001b28:	03c010ef          	jal	ra,80002b64 <soc_interrupt_init>
#endif
	z_cstart();
80001b2c:	3cd010ef          	jal	ra,800036f8 <z_cstart>

80001b30 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80001b30:	00009117          	auipc	sp,0x9
80001b34:	ac010113          	addi	sp,sp,-1344 # 8000a5f0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80001b38:	000012b7          	lui	t0,0x1
80001b3c:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80001b40:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80001b44:	fd9ff0ef          	jal	ra,80001b1c <_PrepC>

80001b48 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80001b48:	1110006f          	j	80002458 <z_thread_entry>

80001b4c <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80001b4c:	fd010113          	addi	sp,sp,-48
80001b50:	02812423          	sw	s0,40(sp)
80001b54:	02912223          	sw	s1,36(sp)
80001b58:	03212023          	sw	s2,32(sp)
80001b5c:	01312e23          	sw	s3,28(sp)
80001b60:	01412c23          	sw	s4,24(sp)
80001b64:	01512a23          	sw	s5,20(sp)
80001b68:	01612823          	sw	s6,16(sp)
80001b6c:	01712623          	sw	s7,12(sp)
80001b70:	00078b13          	mv	s6,a5
80001b74:	02112623          	sw	ra,44(sp)
80001b78:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001b7c:	00f00793          	li	a5,15
{
80001b80:	00050493          	mv	s1,a0
80001b84:	00058413          	mv	s0,a1
80001b88:	00060993          	mv	s3,a2
80001b8c:	00068a13          	mv	s4,a3
80001b90:	00070b93          	mv	s7,a4
80001b94:	00080a93          	mv	s5,a6
80001b98:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001b9c:	08f89a63          	bne	a7,a5,80001c30 <z_new_thread+0xe4>
80001ba0:	800037b7          	lui	a5,0x80003
80001ba4:	65478793          	addi	a5,a5,1620 # 80003654 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003655>
80001ba8:	08f69a63          	bne	a3,a5,80001c3c <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80001bac:	03012683          	lw	a3,48(sp)
80001bb0:	00090593          	mv	a1,s2
80001bb4:	00048513          	mv	a0,s1
80001bb8:	00400613          	li	a2,4
80001bbc:	7e5030ef          	jal	ra,80005ba0 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80001bc0:	fb098593          	addi	a1,s3,-80
80001bc4:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001bc8:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80001bcc:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001bd0:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80001bd4:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001bd8:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80001bdc:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001be0:	800027b7          	lui	a5,0x80002

	thread->callee_saved.sp = (u32_t)stack_init;
}
80001be4:	02c12083          	lw	ra,44(sp)
80001be8:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001bec:	b4878793          	addi	a5,a5,-1208 # 80001b48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001b49>
	stack_init->a0 = (u32_t)thread_func;
80001bf0:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80001bf4:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80001bf8:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80001bfc:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001c00:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80001c04:	02b4a423          	sw	a1,40(s1)
}
80001c08:	02012903          	lw	s2,32(sp)
80001c0c:	02412483          	lw	s1,36(sp)
80001c10:	01c12983          	lw	s3,28(sp)
80001c14:	01812a03          	lw	s4,24(sp)
80001c18:	01412a83          	lw	s5,20(sp)
80001c1c:	01012b03          	lw	s6,16(sp)
80001c20:	00c12b83          	lw	s7,12(sp)
80001c24:	00812c03          	lw	s8,8(sp)
80001c28:	03010113          	addi	sp,sp,48
80001c2c:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001c30:	01088693          	addi	a3,a7,16
80001c34:	01e00793          	li	a5,30
80001c38:	f6d7fae3          	bgeu	a5,a3,80001bac <z_new_thread+0x60>
80001c3c:	80008c37          	lui	s8,0x80008
80001c40:	800085b7          	lui	a1,0x80008
80001c44:	80008537          	lui	a0,0x80008
80001c48:	e4cc0613          	addi	a2,s8,-436 # 80007e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e4d>
80001c4c:	01800693          	li	a3,24
80001c50:	e6c58593          	addi	a1,a1,-404 # 80007e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007e6d>
80001c54:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80001c58:	66d000ef          	jal	ra,80002ac4 <printk>
80001c5c:	80008537          	lui	a0,0x80008
80001c60:	00090593          	mv	a1,s2
80001c64:	ff000693          	li	a3,-16
80001c68:	00e00613          	li	a2,14
80001c6c:	f1850513          	addi	a0,a0,-232 # 80007f18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f19>
80001c70:	655000ef          	jal	ra,80002ac4 <printk>
80001c74:	01800593          	li	a1,24
80001c78:	e4cc0513          	addi	a0,s8,-436
80001c7c:	685000ef          	jal	ra,80002b00 <assert_post_action>
80001c80:	f2dff06f          	j	80001bac <z_new_thread+0x60>

80001c84 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80001c84:	00159793          	slli	a5,a1,0x1
80001c88:	00b787b3          	add	a5,a5,a1
80001c8c:	00279713          	slli	a4,a5,0x2
80001c90:	00c52783          	lw	a5,12(a0)
80001c94:	00e787b3          	add	a5,a5,a4
80001c98:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001c9c:	00b75463          	bge	a4,a1,80001ca4 <get_bit_ptr+0x20>
80001ca0:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001ca4:	41f65713          	srai	a4,a2,0x1f
80001ca8:	01f77713          	andi	a4,a4,31
80001cac:	00c70733          	add	a4,a4,a2
80001cb0:	40575713          	srai	a4,a4,0x5
80001cb4:	00271713          	slli	a4,a4,0x2
80001cb8:	00e787b3          	add	a5,a5,a4
80001cbc:	00f6a023          	sw	a5,0(a3)

	return bn & 0x1f;
}
80001cc0:	01f67513          	andi	a0,a2,31
80001cc4:	00008067          	ret

80001cc8 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001cc8:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001ccc:	00c10693          	addi	a3,sp,12
{
80001cd0:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001cd4:	fb1ff0ef          	jal	ra,80001c84 <get_bit_ptr>

	*word |= (1<<bit);
80001cd8:	00c12703          	lw	a4,12(sp)
80001cdc:	00100793          	li	a5,1
80001ce0:	00a79533          	sll	a0,a5,a0
80001ce4:	00072783          	lw	a5,0(a4)
}
80001ce8:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80001cec:	00a7e7b3          	or	a5,a5,a0
80001cf0:	00f72023          	sw	a5,0(a4)
}
80001cf4:	02010113          	addi	sp,sp,32
80001cf8:	00008067          	ret

80001cfc <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001cfc:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001d00:	00c10693          	addi	a3,sp,12
{
80001d04:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001d08:	f7dff0ef          	jal	ra,80001c84 <get_bit_ptr>

	*word &= ~(1<<bit);
80001d0c:	00c12703          	lw	a4,12(sp)
80001d10:	00100793          	li	a5,1
80001d14:	00a79533          	sll	a0,a5,a0
80001d18:	00072783          	lw	a5,0(a4)
}
80001d1c:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80001d20:	fff54513          	not	a0,a0
80001d24:	00a7f533          	and	a0,a5,a0
80001d28:	00a72023          	sw	a0,0(a4)
}
80001d2c:	02010113          	addi	sp,sp,32
80001d30:	00008067          	ret

80001d34 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80001d34:	fe010113          	addi	sp,sp,-32
80001d38:	00912a23          	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001d3c:	00452483          	lw	s1,4(a0)
{
80001d40:	00812c23          	sw	s0,24(sp)
80001d44:	00050413          	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001d48:	00855503          	lhu	a0,8(a0)
80001d4c:	00048593          	mv	a1,s1
{
80001d50:	01212823          	sw	s2,16(sp)
80001d54:	01312623          	sw	s3,12(sp)
80001d58:	01412423          	sw	s4,8(sp)
80001d5c:	01512223          	sw	s5,4(sp)
80001d60:	01612023          	sw	s6,0(sp)
80001d64:	00112e23          	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001d68:	b2dfe0ef          	jal	ra,80000894 <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001d6c:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001d70:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80001d74:	fff00793          	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001d78:	00050a13          	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001d7c:	00a989b3          	add	s3,s3,a0
	p->max_inline_level = -1;
80001d80:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001d84:	00000913          	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80001d88:	01f00b13          	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80001d8c:	03594c63          	blt	s2,s5,80001dc4 <z_sys_mem_pool_base_init+0x90>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001d90:	00000493          	li	s1,0
80001d94:	00845783          	lhu	a5,8(s0)
80001d98:	08f4cc63          	blt	s1,a5,80001e30 <z_sys_mem_pool_base_init+0xfc>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001d9c:	01c12083          	lw	ra,28(sp)
80001da0:	01812403          	lw	s0,24(sp)
80001da4:	01412483          	lw	s1,20(sp)
80001da8:	01012903          	lw	s2,16(sp)
80001dac:	00c12983          	lw	s3,12(sp)
80001db0:	00812a03          	lw	s4,8(sp)
80001db4:	00412a83          	lw	s5,4(sp)
80001db8:	00012b03          	lw	s6,0(sp)
80001dbc:	02010113          	addi	sp,sp,32
80001dc0:	00008067          	ret
		int nblocks = buflen / sz;
80001dc4:	00048593          	mv	a1,s1
80001dc8:	000a0513          	mv	a0,s4
80001dcc:	b85fe0ef          	jal	ra,80000950 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80001dd0:	00191713          	slli	a4,s2,0x1
80001dd4:	01270733          	add	a4,a4,s2
80001dd8:	00271793          	slli	a5,a4,0x2
80001ddc:	00c42703          	lw	a4,12(s0)
80001de0:	00f70733          	add	a4,a4,a5
80001de4:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001de8:	00f72223          	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80001dec:	00f72423          	sw	a5,8(a4)
		if (nblocks < 32) {
80001df0:	00ab4e63          	blt	s6,a0,80001e0c <z_sys_mem_pool_base_init+0xd8>
			p->max_inline_level = i;
80001df4:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
80001df8:	0024d493          	srli	s1,s1,0x2
80001dfc:	00348493          	addi	s1,s1,3
80001e00:	ffc4f493          	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
80001e04:	00190913          	addi	s2,s2,1
80001e08:	f85ff06f          	j	80001d8c <z_sys_mem_pool_base_init+0x58>
			bits += (nblocks + 31)/32;
80001e0c:	01f50513          	addi	a0,a0,31
80001e10:	41f55793          	srai	a5,a0,0x1f
80001e14:	01f7f793          	andi	a5,a5,31
80001e18:	00a787b3          	add	a5,a5,a0
80001e1c:	4057d793          	srai	a5,a5,0x5
80001e20:	00279793          	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80001e24:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80001e28:	00f989b3          	add	s3,s3,a5
80001e2c:	fcdff06f          	j	80001df8 <z_sys_mem_pool_base_init+0xc4>
	return (u8_t *)p->buf + lsz * block;
80001e30:	00442583          	lw	a1,4(s0)
80001e34:	00048513          	mv	a0,s1
80001e38:	a5dfe0ef          	jal	ra,80000894 <__mulsi3>
80001e3c:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001e40:	00048613          	mv	a2,s1
80001e44:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001e48:	00a78533          	add	a0,a5,a0
		sys_dlist_append(&p->levels[0].free_list, block);
80001e4c:	00c42783          	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001e50:	00148493          	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80001e54:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001e58:	00e52023          	sw	a4,0(a0)
	node->prev = list->tail;
80001e5c:	0087a703          	lw	a4,8(a5)
80001e60:	00e52223          	sw	a4,4(a0)

	list->tail->next = node;
80001e64:	0087a703          	lw	a4,8(a5)
80001e68:	00a72023          	sw	a0,0(a4)
	list->tail = node;
80001e6c:	00a7a423          	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80001e70:	00040513          	mv	a0,s0
80001e74:	e55ff0ef          	jal	ra,80001cc8 <set_free_bit>
80001e78:	f1dff06f          	j	80001d94 <z_sys_mem_pool_base_init+0x60>

80001e7c <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001e7c:	fa010113          	addi	sp,sp,-96
80001e80:	04812c23          	sw	s0,88(sp)
80001e84:	05512223          	sw	s5,68(sp)
80001e88:	04112e23          	sw	ra,92(sp)
80001e8c:	04912a23          	sw	s1,84(sp)
80001e90:	05212823          	sw	s2,80(sp)
80001e94:	05312623          	sw	s3,76(sp)
80001e98:	05412423          	sw	s4,72(sp)
80001e9c:	05612023          	sw	s6,64(sp)
80001ea0:	03712e23          	sw	s7,60(sp)
80001ea4:	03812c23          	sw	s8,56(sp)
80001ea8:	03912a23          	sw	s9,52(sp)
80001eac:	03a12823          	sw	s10,48(sp)
80001eb0:	03b12623          	sw	s11,44(sp)
80001eb4:	06010413          	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001eb8:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001ebc:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001ec0:	002e1793          	slli	a5,t3,0x2
80001ec4:	00f78793          	addi	a5,a5,15
80001ec8:	7f07f793          	andi	a5,a5,2032
80001ecc:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80001ed0:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001ed4:	00010a93          	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001ed8:	000a8313          	mv	t1,s5
80001edc:	00378793          	addi	a5,a5,3
80001ee0:	ffc7f793          	andi	a5,a5,-4
80001ee4:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
80001ee8:	fff88b13          	addi	s6,a7,-1
80001eec:	03c8d463          	bge	a7,t3,80001f14 <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
80001ef0:	00088c63          	beqz	a7,80001f08 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001ef4:	ffc32803          	lw	a6,-4(t1)
80001ef8:	00285813          	srli	a6,a6,0x2
80001efc:	00380813          	addi	a6,a6,3
80001f00:	ffc87813          	andi	a6,a6,-4
80001f04:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
80001f08:	00430313          	addi	t1,t1,4
80001f0c:	ffc32803          	lw	a6,-4(t1)
80001f10:	04b87a63          	bgeu	a6,a1,80001f64 <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80001f14:	fff00593          	li	a1,-1
80001f18:	04bb1a63          	bne	s6,a1,80001f6c <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
80001f1c:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
80001f20:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
80001f24:	fa040113          	addi	sp,s0,-96
80001f28:	05c12083          	lw	ra,92(sp)
80001f2c:	05812403          	lw	s0,88(sp)
80001f30:	05412483          	lw	s1,84(sp)
80001f34:	05012903          	lw	s2,80(sp)
80001f38:	04c12983          	lw	s3,76(sp)
80001f3c:	04812a03          	lw	s4,72(sp)
80001f40:	04412a83          	lw	s5,68(sp)
80001f44:	04012b03          	lw	s6,64(sp)
80001f48:	03c12b83          	lw	s7,60(sp)
80001f4c:	03812c03          	lw	s8,56(sp)
80001f50:	03412c83          	lw	s9,52(sp)
80001f54:	03012d03          	lw	s10,48(sp)
80001f58:	02c12d83          	lw	s11,44(sp)
80001f5c:	06010113          	addi	sp,sp,96
80001f60:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
80001f64:	00188893          	addi	a7,a7,1
80001f68:	f81ff06f          	j	80001ee8 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001f6c:	01054583          	lbu	a1,16(a0)
		return 0;
80001f70:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001f74:	0015f593          	andi	a1,a1,1
80001f78:	00058863          	beqz	a1,80001f88 <z_sys_mem_pool_block_alloc+0x10c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001f7c:	00800913          	li	s2,8
80001f80:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80001f84:	00897913          	andi	s2,s2,8
80001f88:	fae42a23          	sw	a4,-76(s0)
80001f8c:	001b1713          	slli	a4,s6,0x1
80001f90:	fad42c23          	sw	a3,-72(s0)
80001f94:	01670733          	add	a4,a4,s6
80001f98:	00c52683          	lw	a3,12(a0)
80001f9c:	00271713          	slli	a4,a4,0x2
80001fa0:	00470713          	addi	a4,a4,4
80001fa4:	00e68733          	add	a4,a3,a4
80001fa8:	fac42e23          	sw	a2,-68(s0)
80001fac:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80001fb0:	000b0a13          	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
80001fb4:	fff00693          	li	a3,-1
	return list->head == list;
80001fb8:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001fbc:	19370663          	beq	a4,s3,80002148 <z_sys_mem_pool_block_alloc+0x2cc>
		data = block_alloc(p, i, lsizes[i]);
80001fc0:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
80001fc4:	0049a683          	lw	a3,4(s3)
80001fc8:	00ea8cb3          	add	s9,s5,a4
80001fcc:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001fd0:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001fd4:	00800d13          	li	s10,8
80001fd8:	00e6a023          	sw	a4,0(a3)
	node->next->prev = node->prev;
80001fdc:	00d72223          	sw	a3,4(a4)
	node->next = NULL;
80001fe0:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80001fe4:	0009a223          	sw	zero,4(s3)
80001fe8:	0004a503          	lw	a0,0(s1)
80001fec:	40a98533          	sub	a0,s3,a0
80001ff0:	959fe0ef          	jal	ra,80000948 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
80001ff4:	00050613          	mv	a2,a0
80001ff8:	000a0593          	mv	a1,s4
80001ffc:	00048513          	mv	a0,s1
80002000:	cfdff0ef          	jal	ra,80001cfc <clear_free_bit>
		if (data != NULL) {
80002004:	001a0a13          	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
80002008:	fffa0693          	addi	a3,s4,-1
8000200c:	0566ca63          	blt	a3,s6,80002060 <z_sys_mem_pool_block_alloc+0x1e4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80002010:	0104c703          	lbu	a4,16(s1)
80002014:	00177713          	andi	a4,a4,1
80002018:	00070463          	beqz	a4,80002020 <z_sys_mem_pool_block_alloc+0x1a4>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000201c:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80002020:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
80002024:	ff400513          	li	a0,-12
	*data_p = data;
80002028:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
8000202c:	ee098ce3          	beqz	s3,80001f24 <z_sys_mem_pool_block_alloc+0xa8>
	*level_p = alloc_l;
80002030:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80002034:	0004a503          	lw	a0,0(s1)
	*level_p = alloc_l;
80002038:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
8000203c:	002b1793          	slli	a5,s6,0x2
80002040:	00fa8ab3          	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80002044:	000aa583          	lw	a1,0(s5)
80002048:	40a98533          	sub	a0,s3,a0
8000204c:	8fdfe0ef          	jal	ra,80000948 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
80002050:	fb842783          	lw	a5,-72(s0)
80002054:	00a7a023          	sw	a0,0(a5)
	return 0;
80002058:	00000513          	li	a0,0
8000205c:	ec9ff06f          	j	80001f24 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80002060:	0004a503          	lw	a0,0(s1)
80002064:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
80002068:	00100b93          	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000206c:	40a98533          	sub	a0,s3,a0
80002070:	8d9fe0ef          	jal	ra,80000948 <__divsi3>
80002074:	001a1893          	slli	a7,s4,0x1
80002078:	014888b3          	add	a7,a7,s4
		int lbn = 4*bn + i;
8000207c:	00251d93          	slli	s11,a0,0x2
80002080:	00289893          	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
80002084:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
80002088:	000b8593          	mv	a1,s7
8000208c:	fb142623          	sw	a7,-84(s0)
80002090:	00068513          	mv	a0,a3
80002094:	fad42823          	sw	a3,-80(s0)
80002098:	ffcfe0ef          	jal	ra,80000894 <__mulsi3>
8000209c:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
800020a0:	01bb8633          	add	a2,s7,s11
800020a4:	000a0593          	mv	a1,s4
800020a8:	00048513          	mv	a0,s1
800020ac:	c1dff0ef          	jal	ra,80001cc8 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800020b0:	fb042683          	lw	a3,-80(s0)
800020b4:	0004a603          	lw	a2,0(s1)
	return p->n_max * p->max_sz;
800020b8:	0044a583          	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800020bc:	fff68693          	addi	a3,a3,-1
	return p->n_max * p->max_sz;
800020c0:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800020c4:	00dc06b3          	add	a3,s8,a3
800020c8:	40c686b3          	sub	a3,a3,a2
800020cc:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
800020d0:	fc4fe0ef          	jal	ra,80000894 <__mulsi3>
		if (block_fits(p, block2, lsz)) {
800020d4:	fb042683          	lw	a3,-80(s0)
800020d8:	fac42883          	lw	a7,-84(s0)
800020dc:	02a6f463          	bgeu	a3,a0,80002104 <z_sys_mem_pool_block_alloc+0x288>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
800020e0:	00c4a683          	lw	a3,12(s1)
800020e4:	011686b3          	add	a3,a3,a7
800020e8:	00468613          	addi	a2,a3,4
	node->next = list;
800020ec:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
800020f0:	0086a603          	lw	a2,8(a3)
800020f4:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
800020f8:	0086a603          	lw	a2,8(a3)
800020fc:	01862023          	sw	s8,0(a2)
	list->tail = node;
80002100:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
80002104:	001b8b93          	addi	s7,s7,1
80002108:	00400793          	li	a5,4
8000210c:	f6fb9ce3          	bne	s7,a5,80002084 <z_sys_mem_pool_block_alloc+0x208>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80002110:	0104c683          	lbu	a3,16(s1)
80002114:	0016f693          	andi	a3,a3,1
80002118:	00069a63          	bnez	a3,8000212c <z_sys_mem_pool_block_alloc+0x2b0>
		return 0;
8000211c:	00000913          	li	s2,0
80002120:	001a0a13          	addi	s4,s4,1
80002124:	004c8c93          	addi	s9,s9,4
80002128:	ee1ff06f          	j	80002008 <z_sys_mem_pool_block_alloc+0x18c>
8000212c:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80002130:	0104c683          	lbu	a3,16(s1)
80002134:	0016f693          	andi	a3,a3,1
80002138:	fe0682e3          	beqz	a3,8000211c <z_sys_mem_pool_block_alloc+0x2a0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000213c:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
80002140:	00897913          	andi	s2,s2,8
80002144:	fddff06f          	j	80002120 <z_sys_mem_pool_block_alloc+0x2a4>
	for (i = alloc_l; i >= 0; i--) {
80002148:	fffa0a13          	addi	s4,s4,-1
8000214c:	ff498713          	addi	a4,s3,-12
80002150:	e6da14e3          	bne	s4,a3,80001fb8 <z_sys_mem_pool_block_alloc+0x13c>
80002154:	00000993          	li	s3,0
80002158:	eb9ff06f          	j	80002010 <z_sys_mem_pool_block_alloc+0x194>

8000215c <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
8000215c:	fa010113          	addi	sp,sp,-96
80002160:	04812c23          	sw	s0,88(sp)
80002164:	05412423          	sw	s4,72(sp)
80002168:	03912a23          	sw	s9,52(sp)
8000216c:	04112e23          	sw	ra,92(sp)
80002170:	04912a23          	sw	s1,84(sp)
80002174:	05212823          	sw	s2,80(sp)
80002178:	05312623          	sw	s3,76(sp)
8000217c:	05512223          	sw	s5,68(sp)
80002180:	05612023          	sw	s6,64(sp)
80002184:	03712e23          	sw	s7,60(sp)
80002188:	03812c23          	sw	s8,56(sp)
8000218c:	03a12823          	sw	s10,48(sp)
80002190:	03b12623          	sw	s11,44(sp)
80002194:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80002198:	00a54703          	lbu	a4,10(a0)
{
8000219c:	00050c93          	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800021a0:	00271713          	slli	a4,a4,0x2
800021a4:	00f70713          	addi	a4,a4,15
800021a8:	7f077713          	andi	a4,a4,2032
800021ac:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
800021b0:	00452703          	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800021b4:	00010a13          	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800021b8:	000a0693          	mv	a3,s4
800021bc:	00370713          	addi	a4,a4,3
800021c0:	ffc77713          	andi	a4,a4,-4
800021c4:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
800021c8:	00100513          	li	a0,1
800021cc:	00468693          	addi	a3,a3,4
800021d0:	0ca5f063          	bgeu	a1,a0,80002290 <z_sys_mem_pool_block_free+0x134>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800021d4:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
800021d8:	00058913          	mv	s2,a1
800021dc:	00060993          	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800021e0:	00177713          	andi	a4,a4,1
		return 0;
800021e4:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800021e8:	00070863          	beqz	a4,800021f8 <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800021ec:	00800493          	li	s1,8
800021f0:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
800021f4:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800021f8:	80008b37          	lui	s6,0x80008
	while (level >= 0) {
800021fc:	0a095863          	bgez	s2,800022ac <z_sys_mem_pool_block_free+0x150>
	__ASSERT(0, "out of levels");
80002200:	800084b7          	lui	s1,0x80008
80002204:	800085b7          	lui	a1,0x80008
80002208:	80008537          	lui	a0,0x80008
8000220c:	f4c48613          	addi	a2,s1,-180 # 80007f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f4d>
80002210:	0c000693          	li	a3,192
80002214:	fb458593          	addi	a1,a1,-76 # 80007fb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fb5>
80002218:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
8000221c:	0a9000ef          	jal	ra,80002ac4 <printk>
80002220:	80008537          	lui	a0,0x80008
80002224:	f8050513          	addi	a0,a0,-128 # 80007f80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f81>
80002228:	09d000ef          	jal	ra,80002ac4 <printk>
8000222c:	f4c48513          	addi	a0,s1,-180
80002230:	0c000593          	li	a1,192
80002234:	0cd000ef          	jal	ra,80002b00 <assert_post_action>
	return -1;
80002238:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000223c:	010cc783          	lbu	a5,16(s9)
80002240:	0017f793          	andi	a5,a5,1
80002244:	00078663          	beqz	a5,80002250 <z_sys_mem_pool_block_free+0xf4>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80002248:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000224c:	3004a4f3          	csrrs	s1,mstatus,s1
}
80002250:	fa040113          	addi	sp,s0,-96
80002254:	05c12083          	lw	ra,92(sp)
80002258:	05812403          	lw	s0,88(sp)
8000225c:	05412483          	lw	s1,84(sp)
80002260:	05012903          	lw	s2,80(sp)
80002264:	04c12983          	lw	s3,76(sp)
80002268:	04812a03          	lw	s4,72(sp)
8000226c:	04412a83          	lw	s5,68(sp)
80002270:	04012b03          	lw	s6,64(sp)
80002274:	03c12b83          	lw	s7,60(sp)
80002278:	03812c03          	lw	s8,56(sp)
8000227c:	03412c83          	lw	s9,52(sp)
80002280:	03012d03          	lw	s10,48(sp)
80002284:	02c12d83          	lw	s11,44(sp)
80002288:	06010113          	addi	sp,sp,96
8000228c:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80002290:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
80002294:	00150513          	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80002298:	00275713          	srli	a4,a4,0x2
8000229c:	00370713          	addi	a4,a4,3
800022a0:	ffc77713          	andi	a4,a4,-4
800022a4:	00e6a023          	sw	a4,0(a3)
800022a8:	f25ff06f          	j	800021cc <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
800022ac:	00291713          	slli	a4,s2,0x2
800022b0:	00ea0733          	add	a4,s4,a4
800022b4:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
800022b8:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
800022bc:	00098513          	mv	a0,s3
800022c0:	000a8593          	mv	a1,s5
800022c4:	dd0fe0ef          	jal	ra,80000894 <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800022c8:	fffa8b93          	addi	s7,s5,-1
800022cc:	01750d33          	add	s10,a0,s7
800022d0:	00ac0c33          	add	s8,s8,a0
	return p->n_max * p->max_sz;
800022d4:	004ca583          	lw	a1,4(s9)
800022d8:	008cd503          	lhu	a0,8(s9)
800022dc:	db8fe0ef          	jal	ra,80000894 <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
800022e0:	02ad6c63          	bltu	s10,a0,80002318 <z_sys_mem_pool_block_free+0x1bc>
800022e4:	800087b7          	lui	a5,0x80008
800022e8:	f6078593          	addi	a1,a5,-160 # 80007f60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f61>
800022ec:	800087b7          	lui	a5,0x80008
800022f0:	ef878513          	addi	a0,a5,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800022f4:	0a400693          	li	a3,164
800022f8:	f4cb0613          	addi	a2,s6,-180 # 80007f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f4d>
800022fc:	7c8000ef          	jal	ra,80002ac4 <printk>
80002300:	800087b7          	lui	a5,0x80008
80002304:	f7c78513          	addi	a0,a5,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
80002308:	7bc000ef          	jal	ra,80002ac4 <printk>
8000230c:	0a400593          	li	a1,164
80002310:	f4cb0513          	addi	a0,s6,-180
80002314:	7ec000ef          	jal	ra,80002b00 <assert_post_action>
		set_free_bit(p, level, bn);
80002318:	00098613          	mv	a2,s3
8000231c:	00090593          	mv	a1,s2
80002320:	000c8513          	mv	a0,s9
80002324:	9a5ff0ef          	jal	ra,80001cc8 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
80002328:	00191713          	slli	a4,s2,0x1
8000232c:	01270733          	add	a4,a4,s2
80002330:	00271693          	slli	a3,a4,0x2
80002334:	00cca703          	lw	a4,12(s9)
80002338:	00d70733          	add	a4,a4,a3
8000233c:	00470693          	addi	a3,a4,4
	node->next = list;
80002340:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
80002344:	00872683          	lw	a3,8(a4)
80002348:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
8000234c:	00872683          	lw	a3,8(a4)
80002350:	0186a023          	sw	s8,0(a3)
	list->tail = node;
80002354:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80002358:	010cc703          	lbu	a4,16(s9)
8000235c:	00177713          	andi	a4,a4,1
80002360:	0c071c63          	bnez	a4,80002438 <z_sys_mem_pool_block_free+0x2dc>
		return 0;
80002364:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80002368:	ec090ae3          	beqz	s2,8000223c <z_sys_mem_pool_block_free+0xe0>
	int bit = get_bit_ptr(p, level, bn, &word);
8000236c:	fbc40693          	addi	a3,s0,-68
80002370:	00098613          	mv	a2,s3
80002374:	00090593          	mv	a1,s2
80002378:	000c8513          	mv	a0,s9
8000237c:	909ff0ef          	jal	ra,80001c84 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80002380:	fbc42683          	lw	a3,-68(s0)
80002384:	41f55713          	srai	a4,a0,0x1f
80002388:	00377713          	andi	a4,a4,3
8000238c:	00a70733          	add	a4,a4,a0
80002390:	0006a503          	lw	a0,0(a3)
80002394:	ffc77713          	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80002398:	00f00793          	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
8000239c:	00e55733          	srl	a4,a0,a4
800023a0:	00f77713          	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800023a4:	e8f71ce3          	bne	a4,a5,8000223c <z_sys_mem_pool_block_free+0xe0>
		for (i = 0; i < 4; i++) {
800023a8:	00000d13          	li	s10,0
			int b = (bn & ~3) + i;
800023ac:	ffc9fd93          	andi	s11,s3,-4
800023b0:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
800023b4:	00060513          	mv	a0,a2
800023b8:	000a8593          	mv	a1,s5
800023bc:	fac42423          	sw	a2,-88(s0)
800023c0:	cd4fe0ef          	jal	ra,80000894 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800023c4:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
800023c8:	00050c13          	mv	s8,a0
	return p->n_max * p->max_sz;
800023cc:	004ca583          	lw	a1,4(s9)
800023d0:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800023d4:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
800023d8:	cbcfe0ef          	jal	ra,80000894 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800023dc:	fac42703          	lw	a4,-84(s0)
800023e0:	fa842603          	lw	a2,-88(s0)
800023e4:	02a77863          	bgeu	a4,a0,80002414 <z_sys_mem_pool_block_free+0x2b8>
				clear_free_bit(p, level, b);
800023e8:	00090593          	mv	a1,s2
800023ec:	000c8513          	mv	a0,s9
800023f0:	90dff0ef          	jal	ra,80001cfc <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
800023f4:	000ca703          	lw	a4,0(s9)
800023f8:	01870c33          	add	s8,a4,s8
	node->prev->next = node->next;
800023fc:	004c2603          	lw	a2,4(s8)
80002400:	000c2703          	lw	a4,0(s8)
80002404:	00e62023          	sw	a4,0(a2)
	node->next->prev = node->prev;
80002408:	00c72223          	sw	a2,4(a4)
	node->next = NULL;
8000240c:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80002410:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80002414:	001d0d13          	addi	s10,s10,1
80002418:	00400793          	li	a5,4
8000241c:	f8fd1ae3          	bne	s10,a5,800023b0 <z_sys_mem_pool_block_free+0x254>
		bn = bn / 4;
80002420:	41f9d613          	srai	a2,s3,0x1f
80002424:	00367613          	andi	a2,a2,3
80002428:	013609b3          	add	s3,a2,s3
		level = level - 1;
8000242c:	fff90913          	addi	s2,s2,-1
		bn = bn / 4;
80002430:	4029d993          	srai	s3,s3,0x2
80002434:	dc9ff06f          	j	800021fc <z_sys_mem_pool_block_free+0xa0>
80002438:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000243c:	010cc703          	lbu	a4,16(s9)
80002440:	00177713          	andi	a4,a4,1
80002444:	f20700e3          	beqz	a4,80002364 <z_sys_mem_pool_block_free+0x208>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002448:	00800793          	li	a5,8
8000244c:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
80002450:	0084f493          	andi	s1,s1,8
80002454:	f15ff06f          	j	80002368 <z_sys_mem_pool_block_free+0x20c>

80002458 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80002458:	ff010113          	addi	sp,sp,-16
8000245c:	00050793          	mv	a5,a0
80002460:	00058513          	mv	a0,a1
80002464:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80002468:	00068613          	mv	a2,a3
{
8000246c:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80002470:	000780e7          	jalr	a5
80002474:	258030ef          	jal	ra,800056cc <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002478:	2cd030ef          	jal	ra,80005f44 <z_impl_k_thread_abort>

8000247c <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
8000247c:	00000513          	li	a0,0
80002480:	00008067          	ret

80002484 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80002484:	ff010113          	addi	sp,sp,-16
80002488:	00812423          	sw	s0,8(sp)
8000248c:	00050413          	mv	s0,a0
	out('E', ctx);
80002490:	04500513          	li	a0,69
{
80002494:	00112623          	sw	ra,12(sp)
80002498:	00912223          	sw	s1,4(sp)
8000249c:	00058493          	mv	s1,a1
	out('E', ctx);
800024a0:	000400e7          	jalr	s0
	out('R', ctx);
800024a4:	00048593          	mv	a1,s1
800024a8:	05200513          	li	a0,82
800024ac:	000400e7          	jalr	s0
	out('R', ctx);
800024b0:	00040313          	mv	t1,s0
}
800024b4:	00812403          	lw	s0,8(sp)
800024b8:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
800024bc:	00048593          	mv	a1,s1
}
800024c0:	00412483          	lw	s1,4(sp)
	out('R', ctx);
800024c4:	05200513          	li	a0,82
}
800024c8:	01010113          	addi	sp,sp,16
	out('R', ctx);
800024cc:	00030067          	jr	t1

800024d0 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
800024d0:	0005a783          	lw	a5,0(a1)
800024d4:	00178793          	addi	a5,a5,1
800024d8:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
800024dc:	800087b7          	lui	a5,0x80008
800024e0:	6607a303          	lw	t1,1632(a5) # 80008660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008661>
800024e4:	00030067          	jr	t1

800024e8 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
800024e8:	fc010113          	addi	sp,sp,-64
800024ec:	02812c23          	sw	s0,56(sp)
800024f0:	03312623          	sw	s3,44(sp)
800024f4:	03412423          	sw	s4,40(sp)
800024f8:	03612023          	sw	s6,32(sp)
800024fc:	01a12823          	sw	s10,16(sp)
80002500:	02112e23          	sw	ra,60(sp)
80002504:	02912a23          	sw	s1,52(sp)
80002508:	03212823          	sw	s2,48(sp)
8000250c:	03512223          	sw	s5,36(sp)
80002510:	01712e23          	sw	s7,28(sp)
80002514:	01812c23          	sw	s8,24(sp)
80002518:	01912a23          	sw	s9,20(sp)
8000251c:	01b12623          	sw	s11,12(sp)
80002520:	00050993          	mv	s3,a0
80002524:	00058a13          	mv	s4,a1
80002528:	00060d13          	mv	s10,a2
8000252c:	00068b13          	mv	s6,a3
80002530:	00100413          	li	s0,1
80002534:	00e05463          	blez	a4,8000253c <_printk_dec_ulong+0x54>
80002538:	00070413          	mv	s0,a4
8000253c:	00100793          	li	a5,1
80002540:	02000c93          	li	s9,32
80002544:	00fb1463          	bne	s6,a5,8000254c <_printk_dec_ulong+0x64>
80002548:	03000c93          	li	s9,48
8000254c:	3b9ad4b7          	lui	s1,0x3b9ad
80002550:	00100913          	li	s2,1
80002554:	00a00a93          	li	s5,10
80002558:	00000c13          	li	s8,0
8000255c:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80002560:	00200d93          	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80002564:	00148b93          	addi	s7,s1,1
80002568:	000c1463          	bnez	s8,80002570 <_printk_dec_ulong+0x88>
8000256c:	0ba4f263          	bgeu	s1,s10,80002610 <_printk_dec_ulong+0x128>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80002570:	000b8593          	mv	a1,s7
80002574:	000d0513          	mv	a0,s10
80002578:	bd8fe0ef          	jal	ra,80000950 <__udivsi3>
8000257c:	000a0593          	mv	a1,s4
80002580:	03050513          	addi	a0,a0,48
80002584:	000980e7          	jalr	s3
			digits++;
80002588:	00190913          	addi	s2,s2,1
			found_largest_digit = 1;
8000258c:	00100c13          	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80002590:	000b8593          	mv	a1,s7
80002594:	000d0513          	mv	a0,s10
80002598:	c00fe0ef          	jal	ra,80000998 <__umodsi3>
8000259c:	00050d13          	mv	s10,a0
		pos /= 10;
800025a0:	00a00593          	li	a1,10
800025a4:	00048513          	mv	a0,s1
800025a8:	ba8fe0ef          	jal	ra,80000950 <__udivsi3>
		remaining--;
800025ac:	fffa8a93          	addi	s5,s5,-1
	while (pos >= 9) {
800025b0:	00100793          	li	a5,1
		pos /= 10;
800025b4:	00050493          	mv	s1,a0
	while (pos >= 9) {
800025b8:	fafa96e3          	bne	s5,a5,80002564 <_printk_dec_ulong+0x7c>
	}
	out((int)(remainder + 48), ctx);
800025bc:	000a0593          	mv	a1,s4
800025c0:	030d0513          	addi	a0,s10,48
800025c4:	000980e7          	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
800025c8:	00300793          	li	a5,3
		remaining = min_width - digits;
800025cc:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
800025d0:	06fb0663          	beq	s6,a5,8000263c <_printk_dec_ulong+0x154>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
800025d4:	03c12083          	lw	ra,60(sp)
800025d8:	03812403          	lw	s0,56(sp)
800025dc:	03412483          	lw	s1,52(sp)
800025e0:	03012903          	lw	s2,48(sp)
800025e4:	02c12983          	lw	s3,44(sp)
800025e8:	02812a03          	lw	s4,40(sp)
800025ec:	02412a83          	lw	s5,36(sp)
800025f0:	02012b03          	lw	s6,32(sp)
800025f4:	01c12b83          	lw	s7,28(sp)
800025f8:	01812c03          	lw	s8,24(sp)
800025fc:	01412c83          	lw	s9,20(sp)
80002600:	01012d03          	lw	s10,16(sp)
80002604:	00c12d83          	lw	s11,12(sp)
80002608:	04010113          	addi	sp,sp,64
8000260c:	00008067          	ret
		} else if (remaining <= min_width
80002610:	f95440e3          	blt	s0,s5,80002590 <_printk_dec_ulong+0xa8>
				&& padding < PAD_SPACE_AFTER) {
80002614:	f76deee3          	bltu	s11,s6,80002590 <_printk_dec_ulong+0xa8>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80002618:	000a0593          	mv	a1,s4
8000261c:	000c8513          	mv	a0,s9
80002620:	000980e7          	jalr	s3
			digits++;
80002624:	00190913          	addi	s2,s2,1
80002628:	f69ff06f          	j	80002590 <_printk_dec_ulong+0xa8>
			out(' ', ctx);
8000262c:	000a0593          	mv	a1,s4
80002630:	02000513          	li	a0,32
80002634:	000980e7          	jalr	s3
80002638:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
8000263c:	fe8048e3          	bgtz	s0,8000262c <_printk_dec_ulong+0x144>
80002640:	f95ff06f          	j	800025d4 <_printk_dec_ulong+0xec>

80002644 <__printk_hook_install>:
	_char_out = fn;
80002644:	800087b7          	lui	a5,0x80008
80002648:	66a7a023          	sw	a0,1632(a5) # 80008660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008661>
}
8000264c:	00008067          	ret

80002650 <z_vprintk>:
{
80002650:	fb010113          	addi	sp,sp,-80
80002654:	04812423          	sw	s0,72(sp)
80002658:	04912223          	sw	s1,68(sp)
8000265c:	05212023          	sw	s2,64(sp)
80002660:	03312e23          	sw	s3,60(sp)
80002664:	03412c23          	sw	s4,56(sp)
80002668:	03512a23          	sw	s5,52(sp)
8000266c:	03912223          	sw	s9,36(sp)
80002670:	03a12023          	sw	s10,32(sp)
80002674:	01b12e23          	sw	s11,28(sp)
80002678:	04112623          	sw	ra,76(sp)
8000267c:	03612823          	sw	s6,48(sp)
80002680:	03712623          	sw	s7,44(sp)
80002684:	03812423          	sw	s8,40(sp)
80002688:	00050413          	mv	s0,a0
8000268c:	00058493          	mv	s1,a1
80002690:	00060a93          	mv	s5,a2
80002694:	00068d13          	mv	s10,a3
	int long_ctr = 0;
80002698:	00000a13          	li	s4,0
	int min_width = -1;
8000269c:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
800026a0:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800026a4:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
800026a8:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800026ac:	000ac503          	lbu	a0,0(s5)
800026b0:	04051063          	bnez	a0,800026f0 <z_vprintk+0xa0>
}
800026b4:	04c12083          	lw	ra,76(sp)
800026b8:	04812403          	lw	s0,72(sp)
800026bc:	04412483          	lw	s1,68(sp)
800026c0:	04012903          	lw	s2,64(sp)
800026c4:	03c12983          	lw	s3,60(sp)
800026c8:	03812a03          	lw	s4,56(sp)
800026cc:	03412a83          	lw	s5,52(sp)
800026d0:	03012b03          	lw	s6,48(sp)
800026d4:	02c12b83          	lw	s7,44(sp)
800026d8:	02812c03          	lw	s8,40(sp)
800026dc:	02412c83          	lw	s9,36(sp)
800026e0:	02012d03          	lw	s10,32(sp)
800026e4:	01c12d83          	lw	s11,28(sp)
800026e8:	05010113          	addi	sp,sp,80
800026ec:	00008067          	ret
		if (!might_format) {
800026f0:	000c9e63          	bnez	s9,8000270c <z_vprintk+0xbc>
			if (*fmt != '%') {
800026f4:	02500693          	li	a3,37
800026f8:	36d50c63          	beq	a0,a3,80002a70 <z_vprintk+0x420>
				out((int)*fmt, ctx);
800026fc:	00048593          	mv	a1,s1
80002700:	000400e7          	jalr	s0
		++fmt;
80002704:	001a8a93          	addi	s5,s5,1
80002708:	fa5ff06f          	j	800026ac <z_vprintk+0x5c>
			switch (*fmt) {
8000270c:	06400693          	li	a3,100
80002710:	12d50063          	beq	a0,a3,80002830 <z_vprintk+0x1e0>
80002714:	06a6e263          	bltu	a3,a0,80002778 <z_vprintk+0x128>
80002718:	03900693          	li	a3,57
8000271c:	02a6ea63          	bltu	a3,a0,80002750 <z_vprintk+0x100>
80002720:	03100693          	li	a3,49
80002724:	0ed57463          	bgeu	a0,a3,8000280c <z_vprintk+0x1bc>
80002728:	02d00693          	li	a3,45
8000272c:	34d50c63          	beq	a0,a3,80002a84 <z_vprintk+0x434>
80002730:	03000793          	li	a5,48
80002734:	0cf50063          	beq	a0,a5,800027f4 <z_vprintk+0x1a4>
80002738:	02500713          	li	a4,37
8000273c:	02e51263          	bne	a0,a4,80002760 <z_vprintk+0x110>
				out((int)'%', ctx);
80002740:	00048593          	mv	a1,s1
80002744:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80002748:	000400e7          	jalr	s0
				break;
8000274c:	1600006f          	j	800028ac <z_vprintk+0x25c>
80002750:	05800693          	li	a3,88
80002754:	1cd50063          	beq	a0,a3,80002914 <z_vprintk+0x2c4>
80002758:	06300713          	li	a4,99
8000275c:	30e50063          	beq	a0,a4,80002a5c <z_vprintk+0x40c>
				out((int)'%', ctx);
80002760:	00048593          	mv	a1,s1
80002764:	02500513          	li	a0,37
80002768:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
8000276c:	00048593          	mv	a1,s1
80002770:	000ac503          	lbu	a0,0(s5)
80002774:	fd5ff06f          	j	80002748 <z_vprintk+0xf8>
80002778:	07000693          	li	a3,112
8000277c:	16d50c63          	beq	a0,a3,800028f4 <z_vprintk+0x2a4>
80002780:	02a6e063          	bltu	a3,a0,800027a0 <z_vprintk+0x150>
80002784:	06900693          	li	a3,105
80002788:	0ad50463          	beq	a0,a3,80002830 <z_vprintk+0x1e0>
8000278c:	06c00693          	li	a3,108
80002790:	08d50c63          	beq	a0,a3,80002828 <z_vprintk+0x1d8>
80002794:	06800693          	li	a3,104
80002798:	f6d506e3          	beq	a0,a3,80002704 <z_vprintk+0xb4>
8000279c:	fc5ff06f          	j	80002760 <z_vprintk+0x110>
800027a0:	07500693          	li	a3,117
800027a4:	10d50863          	beq	a0,a3,800028b4 <z_vprintk+0x264>
800027a8:	02a6ee63          	bltu	a3,a0,800027e4 <z_vprintk+0x194>
800027ac:	07300713          	li	a4,115
800027b0:	fae518e3          	bne	a0,a4,80002760 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
800027b4:	000d2c03          	lw	s8,0(s10)
800027b8:	004d0b13          	addi	s6,s10,4
800027bc:	000c0b93          	mv	s7,s8
				while (*s)
800027c0:	000bc503          	lbu	a0,0(s7)
800027c4:	26051a63          	bnez	a0,80002a38 <z_vprintk+0x3e8>
				if (padding == PAD_SPACE_AFTER) {
800027c8:	00300793          	li	a5,3
800027cc:	00f99863          	bne	s3,a5,800027dc <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
800027d0:	418b8bb3          	sub	s7,s7,s8
800027d4:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800027d8:	27704863          	bgtz	s7,80002a48 <z_vprintk+0x3f8>
				char *s = va_arg(ap, char *);
800027dc:	000b0d13          	mv	s10,s6
800027e0:	0cc0006f          	j	800028ac <z_vprintk+0x25c>
800027e4:	07800693          	li	a3,120
800027e8:	12d50663          	beq	a0,a3,80002914 <z_vprintk+0x2c4>
800027ec:	07a00693          	li	a3,122
800027f0:	fa9ff06f          	j	80002798 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
800027f4:	00095e63          	bgez	s2,80002810 <z_vprintk+0x1c0>
800027f8:	28098a63          	beqz	s3,80002a8c <z_vprintk+0x43c>
					min_width = *fmt - '0';
800027fc:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80002800:	f00992e3          	bnez	s3,80002704 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80002804:	00200993          	li	s3,2
80002808:	efdff06f          	j	80002704 <z_vprintk+0xb4>
				if (min_width < 0) {
8000280c:	fe0948e3          	bltz	s2,800027fc <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80002810:	00291693          	slli	a3,s2,0x2
80002814:	01268933          	add	s2,a3,s2
80002818:	00191913          	slli	s2,s2,0x1
8000281c:	fd090913          	addi	s2,s2,-48
80002820:	01250933          	add	s2,a0,s2
80002824:	fddff06f          	j	80002800 <z_vprintk+0x1b0>
				long_ctr++;
80002828:	001a0a13          	addi	s4,s4,1
8000282c:	ed9ff06f          	j	80002704 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80002830:	040a1263          	bnez	s4,80002874 <z_vprintk+0x224>
					long ld = va_arg(ap, long);
80002834:	000d2603          	lw	a2,0(s10)
80002838:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
8000283c:	02065063          	bgez	a2,8000285c <z_vprintk+0x20c>
					out((int)'-', ctx);
80002840:	00048593          	mv	a1,s1
80002844:	02d00513          	li	a0,45
80002848:	00c12023          	sw	a2,0(sp)
8000284c:	000400e7          	jalr	s0
					d = -d;
80002850:	00012603          	lw	a2,0(sp)
					min_width--;
80002854:	fff90913          	addi	s2,s2,-1
					d = -d;
80002858:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
8000285c:	00090713          	mv	a4,s2
80002860:	00098693          	mv	a3,s3
80002864:	00048593          	mv	a1,s1
80002868:	00040513          	mv	a0,s0
8000286c:	c7dff0ef          	jal	ra,800024e8 <_printk_dec_ulong>
				break;
80002870:	03c0006f          	j	800028ac <z_vprintk+0x25c>
				} else if (long_ctr == 1) {
80002874:	00100713          	li	a4,1
80002878:	faea0ee3          	beq	s4,a4,80002834 <z_vprintk+0x1e4>
					long long lld = va_arg(ap, long long);
8000287c:	007d0793          	addi	a5,s10,7
80002880:	ff87f713          	andi	a4,a5,-8
80002884:	00072603          	lw	a2,0(a4)
80002888:	00472683          	lw	a3,4(a4)
8000288c:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80002890:	01b60733          	add	a4,a2,s11
80002894:	00c73733          	sltu	a4,a4,a2
80002898:	00d70733          	add	a4,a4,a3
8000289c:	fa0700e3          	beqz	a4,8000283c <z_vprintk+0x1ec>
						print_err(out, ctx);
800028a0:	00048593          	mv	a1,s1
800028a4:	00040513          	mv	a0,s0
800028a8:	bddff0ef          	jal	ra,80002484 <print_err>
			might_format = 0;
800028ac:	00000c93          	li	s9,0
800028b0:	e55ff06f          	j	80002704 <z_vprintk+0xb4>
				if (long_ctr == 0) {
800028b4:	000a1863          	bnez	s4,800028c4 <z_vprintk+0x274>
					long lu = va_arg(ap, unsigned long);
800028b8:	000d2603          	lw	a2,0(s10)
800028bc:	004d0d13          	addi	s10,s10,4
800028c0:	f9dff06f          	j	8000285c <z_vprintk+0x20c>
				} else if (long_ctr == 1) {
800028c4:	00100713          	li	a4,1
800028c8:	feea08e3          	beq	s4,a4,800028b8 <z_vprintk+0x268>
					unsigned long long llu =
800028cc:	007d0793          	addi	a5,s10,7
800028d0:	ff87f713          	andi	a4,a5,-8
800028d4:	00870d13          	addi	s10,a4,8
800028d8:	00072603          	lw	a2,0(a4)
800028dc:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
800028e0:	fc0710e3          	bnez	a4,800028a0 <z_vprintk+0x250>
800028e4:	800007b7          	lui	a5,0x80000
800028e8:	fff7c793          	not	a5,a5
800028ec:	f6c7f8e3          	bgeu	a5,a2,8000285c <z_vprintk+0x20c>
800028f0:	fb1ff06f          	j	800028a0 <z_vprintk+0x250>
				  out('0', ctx);
800028f4:	00048593          	mv	a1,s1
800028f8:	03000513          	li	a0,48
800028fc:	000400e7          	jalr	s0
				  out('x', ctx);
80002900:	00048593          	mv	a1,s1
80002904:	07800513          	li	a0,120
80002908:	000400e7          	jalr	s0
				  min_width = 8;
8000290c:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80002910:	00100993          	li	s3,1
				if (long_ctr < 2) {
80002914:	00100693          	li	a3,1
80002918:	0b46c263          	blt	a3,s4,800029bc <z_vprintk+0x36c>
					x = va_arg(ap, unsigned long);
8000291c:	000d2783          	lw	a5,0(s10)
80002920:	00012423          	sw	zero,8(sp)
80002924:	004d0d13          	addi	s10,s10,4
80002928:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
8000292c:	01000c13          	li	s8,16
	int digits = 0;
80002930:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80002934:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80002938:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
8000293c:	00412503          	lw	a0,4(sp)
80002940:	00812583          	lw	a1,8(sp)
80002944:	fff88b13          	addi	s6,a7,-1
80002948:	002b1613          	slli	a2,s6,0x2
8000294c:	01112623          	sw	a7,12(sp)
80002950:	939fd0ef          	jal	ra,80000288 <__lshrdi3>
80002954:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002958:	08051863          	bnez	a0,800029e8 <z_vprintk+0x398>
8000295c:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80002960:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002964:	00079863          	bnez	a5,80002974 <z_vprintk+0x324>
80002968:	00c12883          	lw	a7,12(sp)
8000296c:	00100793          	li	a5,1
80002970:	08f89663          	bne	a7,a5,800029fc <z_vprintk+0x3ac>
			nibble += nibble > 9 ? 87 : 48;
80002974:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80002978:	01851513          	slli	a0,a0,0x18
8000297c:	00048593          	mv	a1,s1
80002980:	41855513          	srai	a0,a0,0x18
80002984:	000400e7          	jalr	s0
			digits++;
80002988:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
8000298c:	040b1863          	bnez	s6,800029dc <z_vprintk+0x38c>
	if (padding == PAD_SPACE_AFTER) {
80002990:	00300693          	li	a3,3
			might_format = 0;
80002994:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80002998:	d6d996e3          	bne	s3,a3,80002704 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
8000299c:	00191713          	slli	a4,s2,0x1
800029a0:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
800029a4:	f17054e3          	blez	s7,800028ac <z_vprintk+0x25c>
			out(' ', ctx);
800029a8:	00048593          	mv	a1,s1
800029ac:	02000513          	li	a0,32
800029b0:	000400e7          	jalr	s0
800029b4:	fffb8b93          	addi	s7,s7,-1
800029b8:	fedff06f          	j	800029a4 <z_vprintk+0x354>
					x = va_arg(ap, unsigned long long);
800029bc:	007d0793          	addi	a5,s10,7
800029c0:	ff87f693          	andi	a3,a5,-8
800029c4:	0006a783          	lw	a5,0(a3)
800029c8:	00868d13          	addi	s10,a3,8
800029cc:	00f12223          	sw	a5,4(sp)
800029d0:	0046a783          	lw	a5,4(a3)
800029d4:	00f12423          	sw	a5,8(sp)
800029d8:	f55ff06f          	j	8000292c <z_vprintk+0x2dc>
			found_largest_digit = 1;
800029dc:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800029e0:	000b0893          	mv	a7,s6
800029e4:	f59ff06f          	j	8000293c <z_vprintk+0x2ec>
			nibble += nibble > 9 ? 87 : 48;
800029e8:	00900793          	li	a5,9
800029ec:	05700693          	li	a3,87
800029f0:	f8a7e2e3          	bltu	a5,a0,80002974 <z_vprintk+0x324>
800029f4:	03000693          	li	a3,48
800029f8:	f7dff06f          	j	80002974 <z_vprintk+0x324>
		if (remaining-- <= min_width) {
800029fc:	fffc0793          	addi	a5,s8,-1
80002a00:	00f12623          	sw	a5,12(sp)
80002a04:	01894c63          	blt	s2,s8,80002a1c <z_vprintk+0x3cc>
			if (padding == PAD_ZERO_BEFORE) {
80002a08:	00100793          	li	a5,1
80002a0c:	00f99c63          	bne	s3,a5,80002a24 <z_vprintk+0x3d4>
				out('0', ctx);
80002a10:	00048593          	mv	a1,s1
80002a14:	03000513          	li	a0,48
				out(' ', ctx);
80002a18:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80002a1c:	00c12c03          	lw	s8,12(sp)
80002a20:	fc1ff06f          	j	800029e0 <z_vprintk+0x390>
			} else if (padding == PAD_SPACE_BEFORE) {
80002a24:	00200793          	li	a5,2
80002a28:	fef99ae3          	bne	s3,a5,80002a1c <z_vprintk+0x3cc>
				out(' ', ctx);
80002a2c:	00048593          	mv	a1,s1
80002a30:	02000513          	li	a0,32
80002a34:	fe5ff06f          	j	80002a18 <z_vprintk+0x3c8>
					out((int)(*s++), ctx);
80002a38:	00048593          	mv	a1,s1
80002a3c:	001b8b93          	addi	s7,s7,1
80002a40:	000400e7          	jalr	s0
80002a44:	d7dff06f          	j	800027c0 <z_vprintk+0x170>
						out(' ', ctx);
80002a48:	00048593          	mv	a1,s1
80002a4c:	02000513          	li	a0,32
80002a50:	000400e7          	jalr	s0
80002a54:	fffb8b93          	addi	s7,s7,-1
80002a58:	d81ff06f          	j	800027d8 <z_vprintk+0x188>
				out(c, ctx);
80002a5c:	000d2503          	lw	a0,0(s10)
80002a60:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80002a64:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80002a68:	000400e7          	jalr	s0
				break;
80002a6c:	d71ff06f          	j	800027dc <z_vprintk+0x18c>
				long_ctr = 0;
80002a70:	00000a13          	li	s4,0
				min_width = -1;
80002a74:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80002a78:	00000993          	li	s3,0
				might_format = 1;
80002a7c:	00100c93          	li	s9,1
80002a80:	c85ff06f          	j	80002704 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80002a84:	00300993          	li	s3,3
80002a88:	c7dff06f          	j	80002704 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80002a8c:	00100993          	li	s3,1
80002a90:	c75ff06f          	j	80002704 <z_vprintk+0xb4>

80002a94 <vprintk>:
{
80002a94:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80002a98:	00050613          	mv	a2,a0
80002a9c:	80002537          	lui	a0,0x80002
80002aa0:	00058693          	mv	a3,a1
80002aa4:	4d050513          	addi	a0,a0,1232 # 800024d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800024d1>
80002aa8:	00c10593          	addi	a1,sp,12
{
80002aac:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80002ab0:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80002ab4:	b9dff0ef          	jal	ra,80002650 <z_vprintk>
}
80002ab8:	01c12083          	lw	ra,28(sp)
80002abc:	02010113          	addi	sp,sp,32
80002ac0:	00008067          	ret

80002ac4 <printk>:
{
80002ac4:	fc010113          	addi	sp,sp,-64
80002ac8:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80002acc:	02410593          	addi	a1,sp,36
{
80002ad0:	00112e23          	sw	ra,28(sp)
80002ad4:	02c12423          	sw	a2,40(sp)
80002ad8:	02d12623          	sw	a3,44(sp)
80002adc:	02e12823          	sw	a4,48(sp)
80002ae0:	02f12a23          	sw	a5,52(sp)
80002ae4:	03012c23          	sw	a6,56(sp)
80002ae8:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80002aec:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80002af0:	fa5ff0ef          	jal	ra,80002a94 <vprintk>
}
80002af4:	01c12083          	lw	ra,28(sp)
80002af8:	04010113          	addi	sp,sp,64
80002afc:	00008067          	ret

80002b00 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80002b00:	800085b7          	lui	a1,0x80008
80002b04:	80008537          	lui	a0,0x80008
{
80002b08:	ff010113          	addi	sp,sp,-16
  k_panic();
80002b0c:	f9058593          	addi	a1,a1,-112 # 80007f90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f91>
80002b10:	fa450513          	addi	a0,a0,-92 # 80007fa4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fa5>
80002b14:	01e00613          	li	a2,30
{
80002b18:	00112623          	sw	ra,12(sp)
  k_panic();
80002b1c:	fa9ff0ef          	jal	ra,80002ac4 <printk>
80002b20:	800085b7          	lui	a1,0x80008
80002b24:	b7058593          	addi	a1,a1,-1168 # 80007b70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b71>
80002b28:	00600513          	li	a0,6
80002b2c:	e05fe0ef          	jal	ra,80001930 <z_NanoFatalErrorHandler>

80002b30 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80002b30:	00008067          	ret

80002b34 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b34:	00800793          	li	a5,8
80002b38:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80002b3c:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80002b40:	00008067          	ret

80002b44 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80002b44:	00100793          	li	a5,1
80002b48:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80002b4c:	30452573          	csrrs	a0,mie,a0
}
80002b50:	00008067          	ret

80002b54 <z_arch_irq_disable>:
	 * Use atomic instruction csrrc to disable device interrupt in mie CSR.
	 * (atomic read and clear bits in CSR register)
	 */
	__asm__ volatile ("csrrc %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80002b54:	00100793          	li	a5,1
80002b58:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrc %0, mie, %1\n"
80002b5c:	30453573          	csrrc	a0,mie,a0
};
80002b60:	00008067          	ret

80002b64 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002b64:	00800793          	li	a5,8
80002b68:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80002b6c:	30405073          	csrwi	mie,0
80002b70:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80002b74:	00008067          	ret

80002b78 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80002b78:	ff010113          	addi	sp,sp,-16
80002b7c:	00812423          	sw	s0,8(sp)
80002b80:	00912223          	sw	s1,4(sp)
80002b84:	80008437          	lui	s0,0x80008
80002b88:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80002b8c:	00a00793          	li	a5,10
{
80002b90:	00050493          	mv	s1,a0
80002b94:	6dc40413          	addi	s0,s0,1756 # 800086dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086dd>
	if ('\n' == c) {
80002b98:	00f51c63          	bne	a0,a5,80002bb0 <console_out+0x38>
80002b9c:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80002ba0:	00d00593          	li	a1,13
80002ba4:	00452783          	lw	a5,4(a0)
80002ba8:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80002bac:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80002bb0:	00042503          	lw	a0,0(s0)
80002bb4:	0ff4f593          	andi	a1,s1,255
80002bb8:	00452783          	lw	a5,4(a0)
80002bbc:	0047a783          	lw	a5,4(a5)
80002bc0:	000780e7          	jalr	a5

	return c;
}
80002bc4:	00c12083          	lw	ra,12(sp)
80002bc8:	00812403          	lw	s0,8(sp)
80002bcc:	00048513          	mv	a0,s1
80002bd0:	00412483          	lw	s1,4(sp)
80002bd4:	01010113          	addi	sp,sp,16
80002bd8:	00008067          	ret

80002bdc <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80002bdc:	ff010113          	addi	sp,sp,-16
80002be0:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80002be4:	80003437          	lui	s0,0x80003
80002be8:	b7840513          	addi	a0,s0,-1160 # 80002b78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002b79>
{
80002bec:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80002bf0:	5f0000ef          	jal	ra,800031e0 <__stdout_hook_install>
	__printk_hook_install(console_out);
80002bf4:	b7840513          	addi	a0,s0,-1160
}
80002bf8:	00812403          	lw	s0,8(sp)
80002bfc:	00c12083          	lw	ra,12(sp)
80002c00:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80002c04:	a41ff06f          	j	80002644 <__printk_hook_install>

80002c08 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80002c08:	80008537          	lui	a0,0x80008
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80002c0c:	ff010113          	addi	sp,sp,-16
80002c10:	fb050513          	addi	a0,a0,-80 # 80007fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fb1>
80002c14:	00112623          	sw	ra,12(sp)
80002c18:	1a1000ef          	jal	ra,800035b8 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80002c1c:	800087b7          	lui	a5,0x80008
80002c20:	6ca7ae23          	sw	a0,1756(a5) # 800086dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086dd>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80002c24:	fb9ff0ef          	jal	ra,80002bdc <uart_console_hook_install>

	return 0;
}
80002c28:	00c12083          	lw	ra,12(sp)
80002c2c:	00000513          	li	a0,0
80002c30:	01010113          	addi	sp,sp,16
80002c34:	00008067          	ret

80002c38 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80002c38:	f01007b7          	lui	a5,0xf0100
80002c3c:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80002c40:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80002c44:	f447a583          	lw	a1,-188(a5)
80002c48:	fee59ae3          	bne	a1,a4,80002c3c <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80002c4c:	00008067          	ret

80002c50 <timer_isr>:

static void timer_isr(void *arg)
{
80002c50:	fe010113          	addi	sp,sp,-32
80002c54:	00812c23          	sw	s0,24(sp)
80002c58:	00112e23          	sw	ra,28(sp)
80002c5c:	00912a23          	sw	s1,20(sp)
80002c60:	01212823          	sw	s2,16(sp)
80002c64:	01312623          	sw	s3,12(sp)
80002c68:	01412423          	sw	s4,8(sp)
80002c6c:	01512223          	sw	s5,4(sp)
80002c70:	00800413          	li	s0,8
80002c74:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002c78:	80008937          	lui	s2,0x80008
80002c7c:	6e090513          	addi	a0,s2,1760 # 800086e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002c80:	00847413          	andi	s0,s0,8
80002c84:	739020ef          	jal	ra,80005bbc <z_spin_lock_valid>
80002c88:	02051e63          	bnez	a0,80002cc4 <timer_isr+0x74>
80002c8c:	800084b7          	lui	s1,0x80008
80002c90:	800085b7          	lui	a1,0x80008
80002c94:	80008537          	lui	a0,0x80008
80002c98:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80002c9c:	04e00693          	li	a3,78
80002ca0:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80002ca4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80002ca8:	e1dff0ef          	jal	ra,80002ac4 <printk>
80002cac:	80008537          	lui	a0,0x80008
80002cb0:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80002cb4:	e11ff0ef          	jal	ra,80002ac4 <printk>
80002cb8:	04e00593          	li	a1,78
80002cbc:	fc448513          	addi	a0,s1,-60
80002cc0:	e41ff0ef          	jal	ra,80002b00 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80002cc4:	6e090513          	addi	a0,s2,1760
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002cc8:	800084b7          	lui	s1,0x80008
80002ccc:	749020ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
80002cd0:	6c048493          	addi	s1,s1,1728 # 800086c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086c1>
	u64_t now = mtime();
80002cd4:	f65ff0ef          	jal	ra,80002c38 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002cd8:	0004a983          	lw	s3,0(s1)
80002cdc:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80002ce0:	00050793          	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002ce4:	41350533          	sub	a0,a0,s3
80002ce8:	00a7b7b3          	sltu	a5,a5,a0
80002cec:	415585b3          	sub	a1,a1,s5
80002cf0:	0001d637          	lui	a2,0x1d
80002cf4:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002cf8:	00000693          	li	a3,0
80002cfc:	40f585b3          	sub	a1,a1,a5
80002d00:	dc0fd0ef          	jal	ra,800002c0 <__udivdi3>
80002d04:	00050a13          	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80002d08:	0001d5b7          	lui	a1,0x1d
80002d0c:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002d10:	000a0513          	mv	a0,s4
80002d14:	b81fd0ef          	jal	ra,80000894 <__mulsi3>
80002d18:	013509b3          	add	s3,a0,s3
80002d1c:	00a9b533          	sltu	a0,s3,a0
80002d20:	01550533          	add	a0,a0,s5
80002d24:	00a4a223          	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002d28:	6e090513          	addi	a0,s2,1760
80002d2c:	0134a023          	sw	s3,0(s1)
80002d30:	6b5020ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80002d34:	02051e63          	bnez	a0,80002d70 <timer_isr+0x120>
80002d38:	800084b7          	lui	s1,0x80008
80002d3c:	800085b7          	lui	a1,0x80008
80002d40:	80008537          	lui	a0,0x80008
80002d44:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80002d48:	06100693          	li	a3,97
80002d4c:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80002d50:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80002d54:	d71ff0ef          	jal	ra,80002ac4 <printk>
80002d58:	80008537          	lui	a0,0x80008
80002d5c:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80002d60:	d65ff0ef          	jal	ra,80002ac4 <printk>
80002d64:	06100593          	li	a1,97
80002d68:	fc448513          	addi	a0,s1,-60
80002d6c:	d95ff0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d70:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80002d74:	01812403          	lw	s0,24(sp)
80002d78:	01c12083          	lw	ra,28(sp)
80002d7c:	01412483          	lw	s1,20(sp)
80002d80:	01012903          	lw	s2,16(sp)
80002d84:	00c12983          	lw	s3,12(sp)
80002d88:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002d8c:	000a0513          	mv	a0,s4
}
80002d90:	00812a03          	lw	s4,8(sp)
80002d94:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002d98:	0710306f          	j	80006608 <z_clock_announce>

80002d9c <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002d9c:	ff010113          	addi	sp,sp,-16
80002da0:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002da4:	e95ff0ef          	jal	ra,80002c38 <mtime>
80002da8:	0001d7b7          	lui	a5,0x1d
80002dac:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80002db0:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002db4:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80002db8:	fff00693          	li	a3,-1
80002dbc:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002dc0:	00a7b533          	sltu	a0,a5,a0
80002dc4:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80002dc8:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002dcc:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80002dd0:	00700513          	li	a0,7
80002dd4:	d71ff0ef          	jal	ra,80002b44 <z_arch_irq_enable>
	return 0;
}
80002dd8:	00c12083          	lw	ra,12(sp)
80002ddc:	00000513          	li	a0,0
80002de0:	01010113          	addi	sp,sp,16
80002de4:	00008067          	ret

80002de8 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80002de8:	1a059263          	bnez	a1,80002f8c <z_clock_set_timeout+0x1a4>
{
80002dec:	fe010113          	addi	sp,sp,-32
80002df0:	00112e23          	sw	ra,28(sp)
80002df4:	00812c23          	sw	s0,24(sp)
80002df8:	00912a23          	sw	s1,20(sp)
80002dfc:	01212823          	sw	s2,16(sp)
80002e00:	01312623          	sw	s3,12(sp)
80002e04:	01412423          	sw	s4,8(sp)
80002e08:	01512223          	sw	s5,4(sp)
80002e0c:	01612023          	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80002e10:	fff00793          	li	a5,-1
80002e14:	00f51663          	bne	a0,a5,80002e20 <z_clock_set_timeout+0x38>
80002e18:	00009537          	lui	a0,0x9
80002e1c:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80002e20:	000097b7          	lui	a5,0x9
80002e24:	fff50413          	addi	s0,a0,-1
80002e28:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80002e2c:	1487da63          	bge	a5,s0,80002f80 <z_clock_set_timeout+0x198>
80002e30:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002e34:	00800913          	li	s2,8
80002e38:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002e3c:	80008ab7          	lui	s5,0x80008
80002e40:	6e0a8513          	addi	a0,s5,1760 # 800086e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002e44:	00897913          	andi	s2,s2,8
80002e48:	575020ef          	jal	ra,80005bbc <z_spin_lock_valid>
80002e4c:	02051e63          	bnez	a0,80002e88 <z_clock_set_timeout+0xa0>
80002e50:	800084b7          	lui	s1,0x80008
80002e54:	800085b7          	lui	a1,0x80008
80002e58:	80008537          	lui	a0,0x80008
80002e5c:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80002e60:	04e00693          	li	a3,78
80002e64:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80002e68:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80002e6c:	c59ff0ef          	jal	ra,80002ac4 <printk>
80002e70:	80008537          	lui	a0,0x80008
80002e74:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80002e78:	c4dff0ef          	jal	ra,80002ac4 <printk>
80002e7c:	04e00593          	li	a1,78
80002e80:	fc448513          	addi	a0,s1,-60
80002e84:	c7dff0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80002e88:	6e0a8513          	addi	a0,s5,1760
80002e8c:	589020ef          	jal	ra,80005c14 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002e90:	da9ff0ef          	jal	ra,80002c38 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002e94:	800087b7          	lui	a5,0x80008
80002e98:	6c078793          	addi	a5,a5,1728 # 800086c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086c1>
	u32_t cyc = ticks * CYC_PER_TICK;
80002e9c:	0001d4b7          	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002ea0:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80002ea4:	00050a13          	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80002ea8:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002eac:	00040513          	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002eb0:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002eb4:	9e1fd0ef          	jal	ra,80000894 <__mulsi3>
80002eb8:	4bf48793          	addi	a5,s1,1215
80002ebc:	413787b3          	sub	a5,a5,s3
80002ec0:	00f50533          	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002ec4:	4c048593          	addi	a1,s1,1216
80002ec8:	00aa0533          	add	a0,s4,a0
80002ecc:	a85fd0ef          	jal	ra,80000950 <__udivsi3>
80002ed0:	4c048593          	addi	a1,s1,1216
80002ed4:	9c1fd0ef          	jal	ra,80000894 <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002ed8:	41498a33          	sub	s4,s3,s4
80002edc:	00aa0a33          	add	s4,s4,a0
80002ee0:	3e700793          	li	a5,999
80002ee4:	0147c663          	blt	a5,s4,80002ef0 <z_clock_set_timeout+0x108>
		cyc += CYC_PER_TICK;
80002ee8:	4c048493          	addi	s1,s1,1216
80002eec:	00950533          	add	a0,a0,s1
	r[1] = 0xffffffff;
80002ef0:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002ef4:	013509b3          	add	s3,a0,s3
	r[1] = 0xffffffff;
80002ef8:	fff00713          	li	a4,-1
80002efc:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002f00:	00a9b533          	sltu	a0,s3,a0
80002f04:	01650533          	add	a0,a0,s6
	r[0] = (u32_t)time;
80002f08:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80002f0c:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002f10:	6e0a8513          	addi	a0,s5,1760
80002f14:	4d1020ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80002f18:	02051e63          	bnez	a0,80002f54 <z_clock_set_timeout+0x16c>
80002f1c:	80008437          	lui	s0,0x80008
80002f20:	800085b7          	lui	a1,0x80008
80002f24:	80008537          	lui	a0,0x80008
80002f28:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80002f2c:	06100693          	li	a3,97
80002f30:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80002f34:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80002f38:	b8dff0ef          	jal	ra,80002ac4 <printk>
80002f3c:	80008537          	lui	a0,0x80008
80002f40:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80002f44:	b81ff0ef          	jal	ra,80002ac4 <printk>
80002f48:	06100593          	li	a1,97
80002f4c:	fc440513          	addi	a0,s0,-60
80002f50:	bb1ff0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002f54:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80002f58:	01c12083          	lw	ra,28(sp)
80002f5c:	01812403          	lw	s0,24(sp)
80002f60:	01412483          	lw	s1,20(sp)
80002f64:	01012903          	lw	s2,16(sp)
80002f68:	00c12983          	lw	s3,12(sp)
80002f6c:	00812a03          	lw	s4,8(sp)
80002f70:	00412a83          	lw	s5,4(sp)
80002f74:	00012b03          	lw	s6,0(sp)
80002f78:	02010113          	addi	sp,sp,32
80002f7c:	00008067          	ret
80002f80:	ea045ae3          	bgez	s0,80002e34 <z_clock_set_timeout+0x4c>
80002f84:	00000413          	li	s0,0
80002f88:	eadff06f          	j	80002e34 <z_clock_set_timeout+0x4c>
80002f8c:	00008067          	ret

80002f90 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002f90:	ff010113          	addi	sp,sp,-16
80002f94:	00812423          	sw	s0,8(sp)
80002f98:	00112623          	sw	ra,12(sp)
80002f9c:	00912223          	sw	s1,4(sp)
80002fa0:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002fa4:	00800413          	li	s0,8
80002fa8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002fac:	800084b7          	lui	s1,0x80008
80002fb0:	6e048513          	addi	a0,s1,1760 # 800086e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002fb4:	00847413          	andi	s0,s0,8
80002fb8:	405020ef          	jal	ra,80005bbc <z_spin_lock_valid>
80002fbc:	02051e63          	bnez	a0,80002ff8 <z_clock_elapsed+0x68>
80002fc0:	80008937          	lui	s2,0x80008
80002fc4:	800085b7          	lui	a1,0x80008
80002fc8:	80008537          	lui	a0,0x80008
80002fcc:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80002fd0:	04e00693          	li	a3,78
80002fd4:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80002fd8:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80002fdc:	ae9ff0ef          	jal	ra,80002ac4 <printk>
80002fe0:	80008537          	lui	a0,0x80008
80002fe4:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80002fe8:	addff0ef          	jal	ra,80002ac4 <printk>
80002fec:	04e00593          	li	a1,78
80002ff0:	fc490513          	addi	a0,s2,-60
80002ff4:	b0dff0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80002ff8:	6e048513          	addi	a0,s1,1760
80002ffc:	419020ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80003000:	c39ff0ef          	jal	ra,80002c38 <mtime>
80003004:	800087b7          	lui	a5,0x80008
80003008:	6c07a783          	lw	a5,1728(a5) # 800086c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086c1>
8000300c:	0001d5b7          	lui	a1,0x1d
80003010:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80003014:	40f50533          	sub	a0,a0,a5
80003018:	939fd0ef          	jal	ra,80000950 <__udivsi3>
8000301c:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003020:	6e048513          	addi	a0,s1,1760
80003024:	3c1020ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80003028:	02051e63          	bnez	a0,80003064 <z_clock_elapsed+0xd4>
8000302c:	800084b7          	lui	s1,0x80008
80003030:	800085b7          	lui	a1,0x80008
80003034:	80008537          	lui	a0,0x80008
80003038:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
8000303c:	06100693          	li	a3,97
80003040:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003044:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003048:	a7dff0ef          	jal	ra,80002ac4 <printk>
8000304c:	80008537          	lui	a0,0x80008
80003050:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80003054:	a71ff0ef          	jal	ra,80002ac4 <printk>
80003058:	06100593          	li	a1,97
8000305c:	fc448513          	addi	a0,s1,-60
80003060:	aa1ff0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003064:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80003068:	00c12083          	lw	ra,12(sp)
8000306c:	00812403          	lw	s0,8(sp)
80003070:	00090513          	mv	a0,s2
80003074:	00412483          	lw	s1,4(sp)
80003078:	00012903          	lw	s2,0(sp)
8000307c:	01010113          	addi	sp,sp,16
80003080:	00008067          	ret

80003084 <z_timer_cycle_get_32>:

u32_t z_timer_cycle_get_32(void)
{
80003084:	ff010113          	addi	sp,sp,-16
80003088:	00112623          	sw	ra,12(sp)
	return (u32_t)mtime();
8000308c:	badff0ef          	jal	ra,80002c38 <mtime>
}
80003090:	00c12083          	lw	ra,12(sp)
80003094:	01010113          	addi	sp,sp,16
80003098:	00008067          	ret

8000309c <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
8000309c:	00054783          	lbu	a5,0(a0)
800030a0:	0005c703          	lbu	a4,0(a1)
800030a4:	00e79463          	bne	a5,a4,800030ac <strcmp+0x10>
800030a8:	00079663          	bnez	a5,800030b4 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
800030ac:	40e78533          	sub	a0,a5,a4
800030b0:	00008067          	ret
		s1++;
800030b4:	00150513          	addi	a0,a0,1
		s2++;
800030b8:	00158593          	addi	a1,a1,1
800030bc:	fe1ff06f          	j	8000309c <strcmp>

800030c0 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
800030c0:	00b547b3          	xor	a5,a0,a1
800030c4:	0037f793          	andi	a5,a5,3
800030c8:	04078c63          	beqz	a5,80003120 <memcpy+0x60>
	unsigned char *d_byte = (unsigned char *)d;
800030cc:	00050793          	mv	a5,a0
800030d0:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
800030d4:	06e61663          	bne	a2,a4,80003140 <memcpy+0x80>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
800030d8:	00008067          	ret
			if (n == 0) {
800030dc:	fe060ee3          	beqz	a2,800030d8 <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
800030e0:	00158593          	addi	a1,a1,1
800030e4:	fff5c703          	lbu	a4,-1(a1)
800030e8:	00178793          	addi	a5,a5,1
			n--;
800030ec:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
800030f0:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
800030f4:	0037f713          	andi	a4,a5,3
800030f8:	fe0712e3          	bnez	a4,800030dc <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
800030fc:	00300693          	li	a3,3
80003100:	40e60833          	sub	a6,a2,a4
80003104:	0306e263          	bltu	a3,a6,80003128 <memcpy+0x68>
80003108:	00265713          	srli	a4,a2,0x2
8000310c:	00271693          	slli	a3,a4,0x2
80003110:	40d60633          	sub	a2,a2,a3
80003114:	00d787b3          	add	a5,a5,a3
80003118:	00d585b3          	add	a1,a1,a3
8000311c:	fb5ff06f          	j	800030d0 <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
80003120:	00050793          	mv	a5,a0
80003124:	fd1ff06f          	j	800030f4 <memcpy+0x34>
			*(d_word++) = *(s_word++);
80003128:	00e588b3          	add	a7,a1,a4
8000312c:	0008a883          	lw	a7,0(a7)
80003130:	00e78833          	add	a6,a5,a4
80003134:	00470713          	addi	a4,a4,4
80003138:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
8000313c:	fc5ff06f          	j	80003100 <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
80003140:	00e58833          	add	a6,a1,a4
80003144:	00084803          	lbu	a6,0(a6)
80003148:	00e786b3          	add	a3,a5,a4
8000314c:	00170713          	addi	a4,a4,1
80003150:	01068023          	sb	a6,0(a3)
		n--;
80003154:	f81ff06f          	j	800030d4 <memcpy+0x14>

80003158 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80003158:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
8000315c:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80003160:	0037f713          	andi	a4,a5,3
80003164:	04071463          	bnez	a4,800031ac <memset+0x54>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80003168:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
8000316c:	00859713          	slli	a4,a1,0x8
80003170:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80003174:	01059713          	slli	a4,a1,0x10
80003178:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
8000317c:	00c78333          	add	t1,a5,a2
80003180:	00078713          	mv	a4,a5
80003184:	00300813          	li	a6,3
80003188:	40e308b3          	sub	a7,t1,a4
8000318c:	03186a63          	bltu	a6,a7,800031c0 <memset+0x68>
80003190:	00265713          	srli	a4,a2,0x2
80003194:	00271593          	slli	a1,a4,0x2
80003198:	00b787b3          	add	a5,a5,a1
8000319c:	40b60633          	sub	a2,a2,a1
800031a0:	00c78633          	add	a2,a5,a2

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
800031a4:	02c79463          	bne	a5,a2,800031cc <memset+0x74>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
800031a8:	00008067          	ret
		if (n == 0) {
800031ac:	fe060ee3          	beqz	a2,800031a8 <memset+0x50>
		*(d_byte++) = c_byte;
800031b0:	00178793          	addi	a5,a5,1
800031b4:	fed78fa3          	sb	a3,-1(a5)
		n--;
800031b8:	fff60613          	addi	a2,a2,-1
800031bc:	fa5ff06f          	j	80003160 <memset+0x8>
		*(d_word++) = c_word;
800031c0:	00470713          	addi	a4,a4,4
800031c4:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
800031c8:	fc1ff06f          	j	80003188 <memset+0x30>
		*(d_byte++) = c_byte;
800031cc:	00178793          	addi	a5,a5,1
800031d0:	fed78fa3          	sb	a3,-1(a5)
		n--;
800031d4:	fd1ff06f          	j	800031a4 <memset+0x4c>

800031d8 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
800031d8:	fff00513          	li	a0,-1
800031dc:	00008067          	ret

800031e0 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
800031e0:	800087b7          	lui	a5,0x80008
800031e4:	66a7a223          	sw	a0,1636(a5) # 80008664 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008665>
}
800031e8:	00008067          	ret

800031ec <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
800031ec:	fe010113          	addi	sp,sp,-32
800031f0:	00812c23          	sw	s0,24(sp)
	test->setup();
800031f4:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
800031f8:	80008437          	lui	s0,0x80008
{
800031fc:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80003200:	66840413          	addi	s0,s0,1640 # 80008668 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008669>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80003204:	800084b7          	lui	s1,0x80008
{
80003208:	00112e23          	sw	ra,28(sp)
8000320c:	01212823          	sw	s2,16(sp)
80003210:	01312623          	sw	s3,12(sp)
	test_result = 1;
80003214:	6e448493          	addi	s1,s1,1764 # 800086e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e5>
80003218:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
8000321c:	00042023          	sw	zero,0(s0)
{
80003220:	00050913          	mv	s2,a0
	test_result = 1;
80003224:	0134a023          	sw	s3,0(s1)
	test->setup();
80003228:	000780e7          	jalr	a5
	test->test();
8000322c:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80003230:	01342023          	sw	s3,0(s0)
	test->test();
80003234:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80003238:	00200793          	li	a5,2
8000323c:	00f42023          	sw	a5,0(s0)
	test->teardown();
80003240:	00c92783          	lw	a5,12(s2)
80003244:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80003248:	00300793          	li	a5,3
8000324c:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80003250:	01812403          	lw	s0,24(sp)
	test_result = 0;
80003254:	0004a023          	sw	zero,0(s1)
}
80003258:	01c12083          	lw	ra,28(sp)
8000325c:	01412483          	lw	s1,20(sp)
80003260:	01012903          	lw	s2,16(sp)
80003264:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80003268:	80009537          	lui	a0,0x80009
8000326c:	bdc50513          	addi	a0,a0,-1060 # 80008bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008bdd>
80003270:	02010113          	addi	sp,sp,32
80003274:	52c0206f          	j	800057a0 <z_impl_k_sem_give>

80003278 <ztest_test_fail>:
80003278:	80009537          	lui	a0,0x80009
{
8000327c:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80003280:	800087b7          	lui	a5,0x80008
80003284:	fff00713          	li	a4,-1
80003288:	bdc50513          	addi	a0,a0,-1060 # 80008bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008bdd>
{
8000328c:	00112623          	sw	ra,12(sp)
	test_result = -1;
80003290:	6ee7a223          	sw	a4,1764(a5) # 800086e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e5>
80003294:	50c020ef          	jal	ra,800057a0 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80003298:	434020ef          	jal	ra,800056cc <z_impl_k_current_get>
}
8000329c:	00c12083          	lw	ra,12(sp)
800032a0:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800032a4:	4a10206f          	j	80005f44 <z_impl_k_thread_abort>

800032a8 <ztest_test_skip>:
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800032a8:	80009537          	lui	a0,0x80009
{
800032ac:	ff010113          	addi	sp,sp,-16
	test_result = -2;
800032b0:	800087b7          	lui	a5,0x80008
800032b4:	ffe00713          	li	a4,-2
800032b8:	bdc50513          	addi	a0,a0,-1060 # 80008bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008bdd>
{
800032bc:	00112623          	sw	ra,12(sp)
	test_result = -2;
800032c0:	6ee7a223          	sw	a4,1764(a5) # 800086e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e5>
800032c4:	4dc020ef          	jal	ra,800057a0 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800032c8:	404020ef          	jal	ra,800056cc <z_impl_k_current_get>
}
800032cc:	00c12083          	lw	ra,12(sp)
800032d0:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800032d4:	4710206f          	j	80005f44 <z_impl_k_thread_abort>

800032d8 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
800032d8:	fa010113          	addi	sp,sp,-96
800032dc:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
800032e0:	800084b7          	lui	s1,0x80008
800032e4:	6e84a783          	lw	a5,1768(s1) # 800086e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e9>
{
800032e8:	04112e23          	sw	ra,92(sp)
800032ec:	04812c23          	sw	s0,88(sp)
800032f0:	05212823          	sw	s2,80(sp)
800032f4:	05312623          	sw	s3,76(sp)
800032f8:	05412423          	sw	s4,72(sp)
800032fc:	05512223          	sw	s5,68(sp)
80003300:	05612023          	sw	s6,64(sp)
80003304:	03712e23          	sw	s7,60(sp)
80003308:	03812c23          	sw	s8,56(sp)
8000330c:	03912a23          	sw	s9,52(sp)
80003310:	03a12823          	sw	s10,48(sp)
80003314:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
80003318:	0807c463          	bltz	a5,800033a0 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
8000331c:	80009437          	lui	s0,0x80009
80003320:	00100613          	li	a2,1
80003324:	00050993          	mv	s3,a0
80003328:	00058c13          	mv	s8,a1
8000332c:	bdc40513          	addi	a0,s0,-1060 # 80008bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008bdd>
80003330:	00000593          	li	a1,0
80003334:	3a4020ef          	jal	ra,800056d8 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80003338:	80008537          	lui	a0,0x80008
8000333c:	00098593          	mv	a1,s3
80003340:	07850513          	addi	a0,a0,120 # 80008078 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008079>
80003344:	f80ff0ef          	jal	ra,80002ac4 <printk>
	PRINT_LINE;
80003348:	80008937          	lui	s2,0x80008
8000334c:	09090513          	addi	a0,s2,144 # 80008090 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008091>
		Z_TC_END_RESULT(ret, test->name);
80003350:	80008ab7          	lui	s5,0x80008
	PRINT_LINE;
80003354:	f70ff0ef          	jal	ra,80002ac4 <printk>
80003358:	6e848493          	addi	s1,s1,1768
	int fail = 0;
8000335c:	00000a13          	li	s4,0
80003360:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80003364:	8000acb7          	lui	s9,0x8000a
80003368:	80009b37          	lui	s6,0x80009
8000336c:	80003d37          	lui	s10,0x80003
	if (test_result == -1) {
80003370:	80008db7          	lui	s11,0x80008
80003374:	80008bb7          	lui	s7,0x80008
		Z_TC_END_RESULT(ret, test->name);
80003378:	038a8a93          	addi	s5,s5,56 # 80008038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008039>
	while (suite->test) {
8000337c:	004c2783          	lw	a5,4(s8)
80003380:	04079e63          	bnez	a5,800033dc <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80003384:	00098593          	mv	a1,s3
	if (fail) {
80003388:	100a0663          	beqz	s4,80003494 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
8000338c:	80008537          	lui	a0,0x80008
80003390:	10050513          	addi	a0,a0,256 # 80008100 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008101>
80003394:	f30ff0ef          	jal	ra,80002ac4 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80003398:	00100793          	li	a5,1
8000339c:	00f4a023          	sw	a5,0(s1)
}
800033a0:	05c12083          	lw	ra,92(sp)
800033a4:	05812403          	lw	s0,88(sp)
800033a8:	05412483          	lw	s1,84(sp)
800033ac:	05012903          	lw	s2,80(sp)
800033b0:	04c12983          	lw	s3,76(sp)
800033b4:	04812a03          	lw	s4,72(sp)
800033b8:	04412a83          	lw	s5,68(sp)
800033bc:	04012b03          	lw	s6,64(sp)
800033c0:	03c12b83          	lw	s7,60(sp)
800033c4:	03812c03          	lw	s8,56(sp)
800033c8:	03412c83          	lw	s9,52(sp)
800033cc:	03012d03          	lw	s10,48(sp)
800033d0:	02c12d83          	lw	s11,44(sp)
800033d4:	06010113          	addi	sp,sp,96
800033d8:	00008067          	ret
	TC_START(test->name);
800033dc:	000c2583          	lw	a1,0(s8)
800033e0:	800087b7          	lui	a5,0x80008
800033e4:	0d878513          	addi	a0,a5,216 # 800080d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080d9>
800033e8:	edcff0ef          	jal	ra,80002ac4 <printk>
800033ec:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
800033f0:	010c2783          	lw	a5,16(s8)
800033f4:	000c0713          	mv	a4,s8
800033f8:	40000613          	li	a2,1024
800033fc:	0087e793          	ori	a5,a5,8
80003400:	fff00893          	li	a7,-1
80003404:	00000813          	li	a6,0
80003408:	1ecd0693          	addi	a3,s10,492 # 800031ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800031ed>
8000340c:	00f12023          	sw	a5,0(sp)
80003410:	df0c8593          	addi	a1,s9,-528 # 80009df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80009df1>
80003414:	00000793          	li	a5,0
80003418:	becb0513          	addi	a0,s6,-1044 # 80008bec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008bed>
8000341c:	185020ef          	jal	ra,80005da0 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80003420:	01c12783          	lw	a5,28(sp)
80003424:	fff00593          	li	a1,-1
80003428:	bdc78513          	addi	a0,a5,-1060
8000342c:	458020ef          	jal	ra,80005884 <z_impl_k_sem_take>
	if (test_result == -1) {
80003430:	6e4d8793          	addi	a5,s11,1764 # 800086e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e5>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80003434:	becb0513          	addi	a0,s6,-1044
80003438:	0007a403          	lw	s0,0(a5)
8000343c:	309020ef          	jal	ra,80005f44 <z_impl_k_thread_abort>
	if (test_result == -2) {
80003440:	800087b7          	lui	a5,0x80008
80003444:	6e478793          	addi	a5,a5,1764 # 800086e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e5>
80003448:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
8000344c:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80003450:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80003454:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80003458:	000c2603          	lw	a2,0(s8)
8000345c:	02f71463          	bne	a4,a5,80003484 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80003460:	800085b7          	lui	a1,0x80008
80003464:	0ec58593          	addi	a1,a1,236 # 800080ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080ed>
		Z_TC_END_RESULT(ret, test->name);
80003468:	0f4b8513          	addi	a0,s7,244 # 800080f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800080f5>
8000346c:	e58ff0ef          	jal	ra,80002ac4 <printk>
80003470:	09090513          	addi	a0,s2,144
80003474:	e50ff0ef          	jal	ra,80002ac4 <printk>
		fail += run_test(suite);
80003478:	008a0a33          	add	s4,s4,s0
		suite++;
8000347c:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80003480:	efdff06f          	j	8000337c <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80003484:	00241793          	slli	a5,s0,0x2
80003488:	00fa87b3          	add	a5,s5,a5
8000348c:	0007a583          	lw	a1,0(a5)
80003490:	fd9ff06f          	j	80003468 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80003494:	80008537          	lui	a0,0x80008
80003498:	11850513          	addi	a0,a0,280 # 80008118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008119>
8000349c:	e28ff0ef          	jal	ra,80002ac4 <printk>
	test_status = (test_status || fail) ? 1 : 0;
800034a0:	0004a783          	lw	a5,0(s1)
800034a4:	00f037b3          	snez	a5,a5
800034a8:	ef5ff06f          	j	8000339c <z_ztest_run_test_suite+0xc4>

800034ac <end_report>:

void end_report(void)
{
	if (test_status) {
800034ac:	800087b7          	lui	a5,0x80008
800034b0:	6e87a783          	lw	a5,1768(a5) # 800086e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086e9>
{
800034b4:	ff010113          	addi	sp,sp,-16
800034b8:	00812423          	sw	s0,8(sp)
800034bc:	80008537          	lui	a0,0x80008
800034c0:	00112623          	sw	ra,12(sp)
800034c4:	80008437          	lui	s0,0x80008
		TC_END_REPORT(TC_FAIL);
800034c8:	09050513          	addi	a0,a0,144 # 80008090 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008091>
	if (test_status) {
800034cc:	02078263          	beqz	a5,800034f0 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
800034d0:	df4ff0ef          	jal	ra,80002ac4 <printk>
800034d4:	800085b7          	lui	a1,0x80008
800034d8:	04458593          	addi	a1,a1,68 # 80008044 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008045>
	} else {
		TC_END_REPORT(TC_PASS);
800034dc:	04c40513          	addi	a0,s0,76 # 8000804c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000804d>
	}
}
800034e0:	00812403          	lw	s0,8(sp)
800034e4:	00c12083          	lw	ra,12(sp)
800034e8:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
800034ec:	dd8ff06f          	j	80002ac4 <printk>
800034f0:	dd4ff0ef          	jal	ra,80002ac4 <printk>
800034f4:	800085b7          	lui	a1,0x80008
800034f8:	06458593          	addi	a1,a1,100 # 80008064 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008065>
800034fc:	fe1ff06f          	j	800034dc <end_report+0x30>

80003500 <main>:

	return test_status;
}
#else
void main(void)
{
80003500:	ff010113          	addi	sp,sp,-16
80003504:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80003508:	b58fe0ef          	jal	ra,80001860 <test_main>
	end_report();
}
8000350c:	00c12083          	lw	ra,12(sp)
80003510:	01010113          	addi	sp,sp,16
	end_report();
80003514:	f99ff06f          	j	800034ac <end_report>

80003518 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80003518:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
8000351c:	00012623          	sw	zero,12(sp)
    i++;
80003520:	00c12783          	lw	a5,12(sp)
80003524:	00178793          	addi	a5,a5,1
80003528:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
8000352c:	f00107b7          	lui	a5,0xf0010
80003530:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80003534:	01010113          	addi	sp,sp,16
80003538:	00008067          	ret

8000353c <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
8000353c:	fff00513          	li	a0,-1
80003540:	00008067          	ret

80003544 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80003544:	00000513          	li	a0,0
80003548:	00008067          	ret

8000354c <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
8000354c:	00251713          	slli	a4,a0,0x2
80003550:	800087b7          	lui	a5,0x80008
80003554:	00150513          	addi	a0,a0,1
80003558:	14878793          	addi	a5,a5,328 # 80008148 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008149>
8000355c:	00251513          	slli	a0,a0,0x2
{
80003560:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80003564:	00e78733          	add	a4,a5,a4
80003568:	00a787b3          	add	a5,a5,a0
{
8000356c:	00812423          	sw	s0,8(sp)
80003570:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80003574:	00072403          	lw	s0,0(a4)
80003578:	0007a483          	lw	s1,0(a5)
{
8000357c:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80003580:	00946c63          	bltu	s0,s1,80003598 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80003584:	00c12083          	lw	ra,12(sp)
80003588:	00812403          	lw	s0,8(sp)
8000358c:	00412483          	lw	s1,4(sp)
80003590:	01010113          	addi	sp,sp,16
80003594:	00008067          	ret
		retval = device_conf->init(info);
80003598:	00042783          	lw	a5,0(s0)
8000359c:	00040513          	mv	a0,s0
800035a0:	0047a783          	lw	a5,4(a5)
800035a4:	000780e7          	jalr	a5
		if (retval != 0) {
800035a8:	00050463          	beqz	a0,800035b0 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
800035ac:	00042223          	sw	zero,4(s0)
								info++) {
800035b0:	00c40413          	addi	s0,s0,12
800035b4:	fcdff06f          	j	80003580 <z_sys_device_do_config_level+0x34>

800035b8 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800035b8:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
800035bc:	800087b7          	lui	a5,0x80008
{
800035c0:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800035c4:	800084b7          	lui	s1,0x80008
{
800035c8:	00812423          	sw	s0,8(sp)
800035cc:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800035d0:	67c78413          	addi	s0,a5,1660 # 8000867c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000867d>
{
800035d4:	01212023          	sw	s2,0(sp)
800035d8:	67c78793          	addi	a5,a5,1660
800035dc:	6ac48493          	addi	s1,s1,1708 # 800086ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ad>
	for (info = __device_init_start; info != __device_init_end; info++) {
800035e0:	00941c63          	bne	s0,s1,800035f8 <z_impl_device_get_binding+0x40>
800035e4:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
800035e8:	00078413          	mv	s0,a5
800035ec:	02941463          	bne	s0,s1,80003614 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
800035f0:	00000413          	li	s0,0
800035f4:	0440006f          	j	80003638 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
800035f8:	00442703          	lw	a4,4(s0)
800035fc:	00070863          	beqz	a4,8000360c <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80003600:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80003604:	00072703          	lw	a4,0(a4)
80003608:	02a70863          	beq	a4,a0,80003638 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
8000360c:	00c40413          	addi	s0,s0,12
80003610:	fd1ff06f          	j	800035e0 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80003614:	00442783          	lw	a5,4(s0)
80003618:	00079663          	bnez	a5,80003624 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
8000361c:	00c40413          	addi	s0,s0,12
80003620:	fcdff06f          	j	800035ec <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80003624:	00042783          	lw	a5,0(s0)
80003628:	00090513          	mv	a0,s2
8000362c:	0007a583          	lw	a1,0(a5)
80003630:	a6dff0ef          	jal	ra,8000309c <strcmp>
80003634:	fe0514e3          	bnez	a0,8000361c <z_impl_device_get_binding+0x64>
}
80003638:	00040513          	mv	a0,s0
8000363c:	00c12083          	lw	ra,12(sp)
80003640:	00812403          	lw	s0,8(sp)
80003644:	00412483          	lw	s1,4(sp)
80003648:	00012903          	lw	s2,0(sp)
8000364c:	01010113          	addi	sp,sp,16
80003650:	00008067          	ret

80003654 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80003654:	ff010113          	addi	sp,sp,-16
80003658:	00812423          	sw	s0,8(sp)
8000365c:	00912223          	sw	s1,4(sp)
80003660:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003664:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80003668:	00200493          	li	s1,2
8000366c:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80003670:	5b9020ef          	jal	ra,80006428 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80003674:	00a4c463          	blt	s1,a0,8000367c <idle+0x28>
80003678:	00100513          	li	a0,1
8000367c:	00100593          	li	a1,1
80003680:	685020ef          	jal	ra,80006504 <z_set_timeout_expiry>
	k_cpu_idle();
80003684:	cb0ff0ef          	jal	ra,80002b34 <k_cpu_idle>
80003688:	fe5ff06f          	j	8000366c <idle+0x18>

8000368c <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
8000368c:	80008537          	lui	a0,0x80008
80003690:	800097b7          	lui	a5,0x80009
80003694:	6c050613          	addi	a2,a0,1728 # 800086c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086c1>
80003698:	d6878793          	addi	a5,a5,-664 # 80008d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d69>
8000369c:	40c78633          	sub	a2,a5,a2
800036a0:	00000593          	li	a1,0
800036a4:	6c050513          	addi	a0,a0,1728
800036a8:	ab1ff06f          	j	80003158 <memset>

800036ac <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
800036ac:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800036b0:	00200513          	li	a0,2
{
800036b4:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800036b8:	e95ff0ef          	jal	ra,8000354c <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
800036bc:	80008537          	lui	a0,0x80008
800036c0:	15c50513          	addi	a0,a0,348 # 8000815c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000815d>
800036c4:	c00ff0ef          	jal	ra,80002ac4 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
800036c8:	00300513          	li	a0,3
800036cc:	e81ff0ef          	jal	ra,8000354c <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
800036d0:	7c4020ef          	jal	ra,80005e94 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
800036d4:	e2dff0ef          	jal	ra,80003500 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
800036d8:	800097b7          	lui	a5,0x80009
800036dc:	ccc78793          	addi	a5,a5,-820 # 80008ccc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008ccd>
800036e0:	00c7c703          	lbu	a4,12(a5)
800036e4:	ffe77713          	andi	a4,a4,-2
800036e8:	00e78623          	sb	a4,12(a5)
}
800036ec:	00c12083          	lw	ra,12(sp)
800036f0:	01010113          	addi	sp,sp,16
800036f4:	00008067          	ret

800036f8 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
800036f8:	f6010113          	addi	sp,sp,-160
800036fc:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80003700:	8000b7b7          	lui	a5,0x8000b
80003704:	80009437          	lui	s0,0x80009
80003708:	09312623          	sw	s3,140(sp)
8000370c:	df078793          	addi	a5,a5,-528 # 8000adf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000adf1>
80003710:	d3c40993          	addi	s3,s0,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80003714:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80003718:	01010793          	addi	a5,sp,16
8000371c:	07000613          	li	a2,112
80003720:	00000593          	li	a1,0
80003724:	00078513          	mv	a0,a5
{
80003728:	08112e23          	sw	ra,156(sp)
8000372c:	08912a23          	sw	s1,148(sp)
80003730:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80003734:	a25ff0ef          	jal	ra,80003158 <memset>
80003738:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
8000373c:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80003740:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80003744:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80003748:	e05ff0ef          	jal	ra,8000354c <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
8000374c:	00100513          	li	a0,1
80003750:	dfdff0ef          	jal	ra,8000354c <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80003754:	10100793          	li	a5,257
80003758:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
8000375c:	249010ef          	jal	ra,800051a4 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80003760:	800087b7          	lui	a5,0x80008
80003764:	1a078793          	addi	a5,a5,416 # 800081a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081a1>
	_kernel.ready_q.cache = _main_thread;
80003768:	80009937          	lui	s2,0x80009
	z_setup_new_thread(_main_thread, _main_stack,
8000376c:	00f12223          	sw	a5,4(sp)
80003770:	800036b7          	lui	a3,0x80003
80003774:	00100793          	li	a5,1
80003778:	8000a5b7          	lui	a1,0x8000a
	_kernel.ready_q.cache = _main_thread;
8000377c:	ccc90493          	addi	s1,s2,-820 # 80008ccc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008ccd>
	z_setup_new_thread(_main_thread, _main_stack,
80003780:	00f12023          	sw	a5,0(sp)
80003784:	00000713          	li	a4,0
80003788:	00000793          	li	a5,0
8000378c:	00000893          	li	a7,0
80003790:	00000813          	li	a6,0
80003794:	6ac68693          	addi	a3,a3,1708 # 800036ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800036ad>
80003798:	20000613          	li	a2,512
8000379c:	1f058593          	addi	a1,a1,496 # 8000a1f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000a1f1>
800037a0:	ccc90513          	addi	a0,s2,-820
	_kernel.ready_q.cache = _main_thread;
800037a4:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
800037a8:	348020ef          	jal	ra,80005af0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
800037ac:	00d4c783          	lbu	a5,13(s1)
800037b0:	d3c40413          	addi	s0,s0,-708
800037b4:	ffb7f713          	andi	a4,a5,-5
800037b8:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800037bc:	01b7f793          	andi	a5,a5,27
800037c0:	00079a63          	bnez	a5,800037d4 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
800037c4:	0184a783          	lw	a5,24(s1)
800037c8:	00079663          	bnez	a5,800037d4 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
800037cc:	ccc90513          	addi	a0,s2,-820
800037d0:	5a9000ef          	jal	ra,80004578 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
800037d4:	800077b7          	lui	a5,0x80007
800037d8:	4e878793          	addi	a5,a5,1256 # 800074e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074e9>
800037dc:	00f12223          	sw	a5,4(sp)
800037e0:	80009537          	lui	a0,0x80009
800037e4:	00100793          	li	a5,1
800037e8:	800036b7          	lui	a3,0x80003
800037ec:	8000a5b7          	lui	a1,0x8000a
800037f0:	c5c50493          	addi	s1,a0,-932 # 80008c5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008c5d>
800037f4:	00f12023          	sw	a5,0(sp)
800037f8:	00f00893          	li	a7,15
800037fc:	00000813          	li	a6,0
80003800:	00000793          	li	a5,0
80003804:	00000713          	li	a4,0
80003808:	65468693          	addi	a3,a3,1620 # 80003654 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003655>
8000380c:	20000613          	li	a2,512
80003810:	3f058593          	addi	a1,a1,1008 # 8000a3f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000a3f1>
80003814:	c5c50513          	addi	a0,a0,-932
80003818:	2d8020ef          	jal	ra,80005af0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
8000381c:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80003820:	00942623          	sw	s1,12(s0)
80003824:	00800513          	li	a0,8
80003828:	ffb7f793          	andi	a5,a5,-5
8000382c:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80003830:	800097b7          	lui	a5,0x80009
80003834:	d5478793          	addi	a5,a5,-684 # 80008d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d55>
80003838:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
8000383c:	00f42e23          	sw	a5,28(s0)
80003840:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80003844:	00857513          	andi	a0,a0,8
80003848:	9f1fc0ef          	jal	ra,80000238 <__swap>

8000384c <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000384c:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
80003850:	fe010113          	addi	sp,sp,-32
80003854:	00812c23          	sw	s0,24(sp)
80003858:	00112e23          	sw	ra,28(sp)
8000385c:	01f7f793          	andi	a5,a5,31
80003860:	00050413          	mv	s0,a0
80003864:	00079c63          	bnez	a5,8000387c <prepare_thread_to_run+0x30>
	if (z_is_thread_ready(thread)) {
80003868:	01852783          	lw	a5,24(a0)
8000386c:	00079863          	bnez	a5,8000387c <prepare_thread_to_run+0x30>
80003870:	00b12623          	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
80003874:	505000ef          	jal	ra,80004578 <z_add_thread_to_ready_q>
80003878:	00c12583          	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
8000387c:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
80003880:	00b42a23          	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
80003884:	01c12083          	lw	ra,28(sp)
80003888:	01812403          	lw	s0,24(sp)
8000388c:	02010113          	addi	sp,sp,32
80003890:	00008067          	ret

80003894 <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
80003894:	fe010113          	addi	sp,sp,-32
80003898:	00812c23          	sw	s0,24(sp)
8000389c:	00912a23          	sw	s1,20(sp)
800038a0:	01212823          	sw	s2,16(sp)
800038a4:	01312623          	sw	s3,12(sp)
800038a8:	01412423          	sw	s4,8(sp)
800038ac:	01612023          	sw	s6,0(sp)
800038b0:	00112e23          	sw	ra,28(sp)
800038b4:	01512223          	sw	s5,4(sp)
800038b8:	00050413          	mv	s0,a0
800038bc:	00058993          	mv	s3,a1
800038c0:	00060a13          	mv	s4,a2
800038c4:	00068b13          	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
800038c8:	00850913          	addi	s2,a0,8
800038cc:	00800493          	li	s1,8
800038d0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800038d4:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
800038d8:	0084f493          	andi	s1,s1,8
800038dc:	2e0020ef          	jal	ra,80005bbc <z_spin_lock_valid>
800038e0:	02051e63          	bnez	a0,8000391c <queue_insert+0x88>
800038e4:	80008ab7          	lui	s5,0x80008
800038e8:	800085b7          	lui	a1,0x80008
800038ec:	80008537          	lui	a0,0x80008
800038f0:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
800038f4:	04e00693          	li	a3,78
800038f8:	fc4a8613          	addi	a2,s5,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800038fc:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003900:	9c4ff0ef          	jal	ra,80002ac4 <printk>
80003904:	80008537          	lui	a0,0x80008
80003908:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
8000390c:	9b8ff0ef          	jal	ra,80002ac4 <printk>
80003910:	04e00593          	li	a1,78
80003914:	fc4a8513          	addi	a0,s5,-60
80003918:	9e8ff0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
8000391c:	00090513          	mv	a0,s2
80003920:	2f4020ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
80003924:	00c40513          	addi	a0,s0,12
80003928:	65c010ef          	jal	ra,80004f84 <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
8000392c:	02050063          	beqz	a0,8000394c <queue_insert+0xb8>
		prepare_thread_to_run(first_pending_thread, data);
80003930:	000a0593          	mv	a1,s4
80003934:	f19ff0ef          	jal	ra,8000384c <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
80003938:	00090513          	mv	a0,s2
8000393c:	00048593          	mv	a1,s1
80003940:	5ec000ef          	jal	ra,80003f2c <z_reschedule>
	return 0;
80003944:	00000513          	li	a0,0
80003948:	0600006f          	j	800039a8 <queue_insert+0x114>
	if (alloc) {
8000394c:	0a0b0e63          	beqz	s6,80003a08 <queue_insert+0x174>
		anode = z_thread_malloc(sizeof(*anode));
80003950:	00800513          	li	a0,8
80003954:	460030ef          	jal	ra,80006db4 <z_thread_malloc>
		if (anode == NULL) {
80003958:	06051c63          	bnez	a0,800039d0 <queue_insert+0x13c>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000395c:	00090513          	mv	a0,s2
80003960:	284020ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80003964:	02051e63          	bnez	a0,800039a0 <queue_insert+0x10c>
80003968:	80008437          	lui	s0,0x80008
8000396c:	800085b7          	lui	a1,0x80008
80003970:	80008537          	lui	a0,0x80008
80003974:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80003978:	06100693          	li	a3,97
8000397c:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003980:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003984:	940ff0ef          	jal	ra,80002ac4 <printk>
80003988:	80008537          	lui	a0,0x80008
8000398c:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80003990:	934ff0ef          	jal	ra,80002ac4 <printk>
80003994:	06100593          	li	a1,97
80003998:	fc440513          	addi	a0,s0,-60
8000399c:	964ff0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800039a0:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
800039a4:	ff400513          	li	a0,-12
}
800039a8:	01c12083          	lw	ra,28(sp)
800039ac:	01812403          	lw	s0,24(sp)
800039b0:	01412483          	lw	s1,20(sp)
800039b4:	01012903          	lw	s2,16(sp)
800039b8:	00c12983          	lw	s3,12(sp)
800039bc:	00812a03          	lw	s4,8(sp)
800039c0:	00412a83          	lw	s5,4(sp)
800039c4:	00012b03          	lw	s6,0(sp)
800039c8:	02010113          	addi	sp,sp,32
800039cc:	00008067          	ret
 * @param flags A value between 0 and 3 to set the flags value
 */
static inline void sys_sfnode_init(sys_sfnode_t *node, u8_t flags)
{
	__ASSERT((flags & ~SYS_SFLIST_FLAGS_MASK) == 0U, "flags too large");
	node->next_and_flags = flags;
800039d0:	00100793          	li	a5,1
		anode->data = data;
800039d4:	01452223          	sw	s4,4(a0)
800039d8:	00f52023          	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
800039dc:	00052783          	lw	a5,0(a0)
800039e0:	0037f793          	andi	a5,a5,3
800039e4:	02099863          	bnez	s3,80003a14 <queue_insert+0x180>
	parent->next_and_flags = cur_flags | (unative_t)child;
800039e8:	00042703          	lw	a4,0(s0)
800039ec:	00f767b3          	or	a5,a4,a5
800039f0:	00f52023          	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
800039f4:	00442783          	lw	a5,4(s0)
	list->head = node;
800039f8:	00a42023          	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
800039fc:	f2079ee3          	bnez	a5,80003938 <queue_insert+0xa4>
	list->tail = node;
80003a00:	00a42223          	sw	a0,4(s0)
80003a04:	f35ff06f          	j	80003938 <queue_insert+0xa4>
	node->next_and_flags = flags;
80003a08:	000a2023          	sw	zero,0(s4)
80003a0c:	000a0513          	mv	a0,s4
80003a10:	fcdff06f          	j	800039dc <queue_insert+0x148>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80003a14:	0009a703          	lw	a4,0(s3)
80003a18:	ffc77713          	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
80003a1c:	02071863          	bnez	a4,80003a4c <queue_insert+0x1b8>
Z_GENLIST_APPEND(sflist, sfnode)
80003a20:	00442703          	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
80003a24:	00f52023          	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
80003a28:	00071863          	bnez	a4,80003a38 <queue_insert+0x1a4>
	list->tail = node;
80003a2c:	00a42223          	sw	a0,4(s0)
	list->head = node;
80003a30:	00a42023          	sw	a0,0(s0)
80003a34:	f05ff06f          	j	80003938 <queue_insert+0xa4>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80003a38:	00072783          	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80003a3c:	0037f793          	andi	a5,a5,3
80003a40:	00f567b3          	or	a5,a0,a5
80003a44:	00f72023          	sw	a5,0(a4)
80003a48:	fb9ff06f          	j	80003a00 <queue_insert+0x16c>
80003a4c:	00e7e7b3          	or	a5,a5,a4
80003a50:	00f52023          	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80003a54:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
80003a58:	0037f793          	andi	a5,a5,3
80003a5c:	00f56533          	or	a0,a0,a5
80003a60:	00a9a023          	sw	a0,0(s3)
80003a64:	ed5ff06f          	j	80003938 <queue_insert+0xa4>

80003a68 <z_queue_node_peek>:
{
80003a68:	ff010113          	addi	sp,sp,-16
80003a6c:	00812423          	sw	s0,8(sp)
80003a70:	00112623          	sw	ra,12(sp)
80003a74:	00050413          	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
80003a78:	00050e63          	beqz	a0,80003a94 <z_queue_node_peek+0x2c>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80003a7c:	00052783          	lw	a5,0(a0)
80003a80:	0037f793          	andi	a5,a5,3
80003a84:	00078863          	beqz	a5,80003a94 <z_queue_node_peek+0x2c>
		ret = anode->data;
80003a88:	00452403          	lw	s0,4(a0)
		if (needs_free) {
80003a8c:	00058463          	beqz	a1,80003a94 <z_queue_node_peek+0x2c>
			k_free(anode);
80003a90:	314030ef          	jal	ra,80006da4 <k_free>
}
80003a94:	00040513          	mv	a0,s0
80003a98:	00c12083          	lw	ra,12(sp)
80003a9c:	00812403          	lw	s0,8(sp)
80003aa0:	01010113          	addi	sp,sp,16
80003aa4:	00008067          	ret

80003aa8 <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80003aa8:	00c50793          	addi	a5,a0,12
	list->head = NULL;
80003aac:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
80003ab0:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
80003ab4:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
80003ab8:	00f52623          	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
80003abc:	00f52823          	sw	a5,16(a0)
}
80003ac0:	00008067          	ret

80003ac4 <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
80003ac4:	00058613          	mv	a2,a1
80003ac8:	00452583          	lw	a1,4(a0)
80003acc:	00000693          	li	a3,0
80003ad0:	dc5ff06f          	j	80003894 <queue_insert>

80003ad4 <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
80003ad4:	fe010113          	addi	sp,sp,-32
80003ad8:	00812c23          	sw	s0,24(sp)
80003adc:	00912a23          	sw	s1,20(sp)
80003ae0:	01212823          	sw	s2,16(sp)
80003ae4:	01312623          	sw	s3,12(sp)
80003ae8:	00112e23          	sw	ra,28(sp)
80003aec:	01412423          	sw	s4,8(sp)
80003af0:	00050493          	mv	s1,a0
80003af4:	00058993          	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80003af8:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003afc:	00800413          	li	s0,8
80003b00:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003b04:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80003b08:	00847413          	andi	s0,s0,8
80003b0c:	0b0020ef          	jal	ra,80005bbc <z_spin_lock_valid>
80003b10:	02051e63          	bnez	a0,80003b4c <z_impl_k_queue_get+0x78>
80003b14:	80008a37          	lui	s4,0x80008
80003b18:	800085b7          	lui	a1,0x80008
80003b1c:	80008537          	lui	a0,0x80008
80003b20:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80003b24:	04e00693          	li	a3,78
80003b28:	fc4a0613          	addi	a2,s4,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003b2c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003b30:	f95fe0ef          	jal	ra,80002ac4 <printk>
80003b34:	80008537          	lui	a0,0x80008
80003b38:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80003b3c:	f89fe0ef          	jal	ra,80002ac4 <printk>
80003b40:	04e00593          	li	a1,78
80003b44:	fc4a0513          	addi	a0,s4,-60
80003b48:	fb9fe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b4c:	00090513          	mv	a0,s2
80003b50:	0c4020ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
80003b54:	0004a503          	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
80003b58:	08050a63          	beqz	a0,80003bec <z_impl_k_queue_get+0x118>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80003b5c:	00052783          	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80003b60:	0044a703          	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80003b64:	ffc7f793          	andi	a5,a5,-4
	list->head = node;
80003b68:	00f4a023          	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80003b6c:	00e51463          	bne	a0,a4,80003b74 <z_impl_k_queue_get+0xa0>
	list->tail = node;
80003b70:	00f4a223          	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
80003b74:	00100593          	li	a1,1
80003b78:	ef1ff0ef          	jal	ra,80003a68 <z_queue_node_peek>
80003b7c:	00050493          	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b80:	00090513          	mv	a0,s2
80003b84:	060020ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80003b88:	02051e63          	bnez	a0,80003bc4 <z_impl_k_queue_get+0xf0>
80003b8c:	80008937          	lui	s2,0x80008
80003b90:	800085b7          	lui	a1,0x80008
80003b94:	80008537          	lui	a0,0x80008
80003b98:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80003b9c:	06100693          	li	a3,97
80003ba0:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003ba4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003ba8:	f1dfe0ef          	jal	ra,80002ac4 <printk>
80003bac:	80008537          	lui	a0,0x80008
80003bb0:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80003bb4:	f11fe0ef          	jal	ra,80002ac4 <printk>
80003bb8:	06100593          	li	a1,97
80003bbc:	fc490513          	addi	a0,s2,-60
80003bc0:	f41fe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003bc4:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
80003bc8:	01c12083          	lw	ra,28(sp)
80003bcc:	01812403          	lw	s0,24(sp)
80003bd0:	00048513          	mv	a0,s1
80003bd4:	01012903          	lw	s2,16(sp)
80003bd8:	01412483          	lw	s1,20(sp)
80003bdc:	00c12983          	lw	s3,12(sp)
80003be0:	00812a03          	lw	s4,8(sp)
80003be4:	02010113          	addi	sp,sp,32
80003be8:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80003bec:	04099a63          	bnez	s3,80003c40 <z_impl_k_queue_get+0x16c>
80003bf0:	00090513          	mv	a0,s2
80003bf4:	7f1010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80003bf8:	02051e63          	bnez	a0,80003c34 <z_impl_k_queue_get+0x160>
80003bfc:	800084b7          	lui	s1,0x80008
80003c00:	800085b7          	lui	a1,0x80008
80003c04:	80008537          	lui	a0,0x80008
80003c08:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80003c0c:	06100693          	li	a3,97
80003c10:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003c14:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003c18:	eadfe0ef          	jal	ra,80002ac4 <printk>
80003c1c:	80008537          	lui	a0,0x80008
80003c20:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80003c24:	ea1fe0ef          	jal	ra,80002ac4 <printk>
80003c28:	06100593          	li	a1,97
80003c2c:	fc448513          	addi	a0,s1,-60
80003c30:	ed1fe0ef          	jal	ra,80002b00 <assert_post_action>
80003c34:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
80003c38:	00000493          	li	s1,0
80003c3c:	f8dff06f          	j	80003bc8 <z_impl_k_queue_get+0xf4>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80003c40:	00c48613          	addi	a2,s1,12
80003c44:	00098693          	mv	a3,s3
80003c48:	00040593          	mv	a1,s0
80003c4c:	00090513          	mv	a0,s2
80003c50:	0a0010ef          	jal	ra,80004cf0 <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
80003c54:	00000493          	li	s1,0
80003c58:	f60518e3          	bnez	a0,80003bc8 <z_impl_k_queue_get+0xf4>
80003c5c:	800097b7          	lui	a5,0x80009
80003c60:	d447a783          	lw	a5,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
80003c64:	0147a483          	lw	s1,20(a5)
80003c68:	f61ff06f          	j	80003bc8 <z_impl_k_queue_get+0xf4>

80003c6c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003c6c:	00d54783          	lbu	a5,13(a0)
80003c70:	01f7f793          	andi	a5,a5,31
80003c74:	00079863          	bnez	a5,80003c84 <z_is_thread_ready+0x18>
80003c78:	01852503          	lw	a0,24(a0)
80003c7c:	00153513          	seqz	a0,a0
80003c80:	00008067          	ret
80003c84:	00000513          	li	a0,0
}
80003c88:	00008067          	ret

80003c8c <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80003c8c:	ff010113          	addi	sp,sp,-16
80003c90:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80003c94:	afcff0ef          	jal	ra,80002f90 <z_clock_elapsed>
80003c98:	800087b7          	lui	a5,0x80008
80003c9c:	6f47a783          	lw	a5,1780(a5) # 800086f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086f5>

	z_set_timeout_expiry(slice_time, false);
}
80003ca0:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80003ca4:	80009737          	lui	a4,0x80009
80003ca8:	00a78533          	add	a0,a5,a0
80003cac:	d4a72623          	sw	a0,-692(a4) # 80008d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d4d>
	z_set_timeout_expiry(slice_time, false);
80003cb0:	00000593          	li	a1,0
80003cb4:	00078513          	mv	a0,a5
}
80003cb8:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80003cbc:	0490206f          	j	80006504 <z_set_timeout_expiry>

80003cc0 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80003cc0:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80003cc4:	ff010113          	addi	sp,sp,-16
80003cc8:	00812423          	sw	s0,8(sp)
80003ccc:	00112623          	sw	ra,12(sp)
80003cd0:	00912223          	sw	s1,4(sp)
80003cd4:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80003cd8:	02079863          	bnez	a5,80003d08 <pended_on.isra.15+0x48>
80003cdc:	800084b7          	lui	s1,0x80008
80003ce0:	800085b7          	lui	a1,0x80008
80003ce4:	80008537          	lui	a0,0x80008
80003ce8:	24058593          	addi	a1,a1,576 # 80008240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008241>
80003cec:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003cf0:	18300693          	li	a3,387
80003cf4:	22c48613          	addi	a2,s1,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80003cf8:	dcdfe0ef          	jal	ra,80002ac4 <printk>
80003cfc:	18300593          	li	a1,387
80003d00:	22c48513          	addi	a0,s1,556
80003d04:	dfdfe0ef          	jal	ra,80002b00 <assert_post_action>

	return thread->base.pended_on;
}
80003d08:	00042503          	lw	a0,0(s0)
80003d0c:	00c12083          	lw	ra,12(sp)
80003d10:	00812403          	lw	s0,8(sp)
80003d14:	00412483          	lw	s1,4(sp)
80003d18:	01010113          	addi	sp,sp,16
80003d1c:	00008067          	ret

80003d20 <k_sched_time_slice_set>:
{
80003d20:	fe010113          	addi	sp,sp,-32
80003d24:	00812c23          	sw	s0,24(sp)
80003d28:	01312623          	sw	s3,12(sp)
80003d2c:	01412423          	sw	s4,8(sp)
80003d30:	00112e23          	sw	ra,28(sp)
80003d34:	00912a23          	sw	s1,20(sp)
80003d38:	01212823          	sw	s2,16(sp)
80003d3c:	00050a13          	mv	s4,a0
80003d40:	00058993          	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d44:	00800413          	li	s0,8
80003d48:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d4c:	800084b7          	lui	s1,0x80008
80003d50:	6ec48513          	addi	a0,s1,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80003d54:	00847413          	andi	s0,s0,8
80003d58:	665010ef          	jal	ra,80005bbc <z_spin_lock_valid>
80003d5c:	02051e63          	bnez	a0,80003d98 <k_sched_time_slice_set+0x78>
80003d60:	80008937          	lui	s2,0x80008
80003d64:	800085b7          	lui	a1,0x80008
80003d68:	80008537          	lui	a0,0x80008
80003d6c:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80003d70:	04e00693          	li	a3,78
80003d74:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003d78:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003d7c:	d49fe0ef          	jal	ra,80002ac4 <printk>
80003d80:	80008537          	lui	a0,0x80008
80003d84:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80003d88:	d3dfe0ef          	jal	ra,80002ac4 <printk>
80003d8c:	04e00593          	li	a1,78
80003d90:	fc490513          	addi	a0,s2,-60
80003d94:	d6dfe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d98:	6ec48513          	addi	a0,s1,1772
80003d9c:	679010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80003da0:	800097b7          	lui	a5,0x80009
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80003da4:	00a00593          	li	a1,10
80003da8:	009a0513          	addi	a0,s4,9
80003dac:	d407a623          	sw	zero,-692(a5) # 80008d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d4d>
80003db0:	b99fc0ef          	jal	ra,80000948 <__divsi3>
		slice_max_prio = prio;
80003db4:	800087b7          	lui	a5,0x80008
		slice_time = z_ms_to_ticks(slice);
80003db8:	80008937          	lui	s2,0x80008
80003dbc:	6ea92a23          	sw	a0,1780(s2) # 800086f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086f5>
		slice_max_prio = prio;
80003dc0:	6f37a823          	sw	s3,1776(a5) # 800086f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086f1>
		reset_time_slice();
80003dc4:	ec9ff0ef          	jal	ra,80003c8c <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003dc8:	6ec48513          	addi	a0,s1,1772
80003dcc:	619010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80003dd0:	02051e63          	bnez	a0,80003e0c <k_sched_time_slice_set+0xec>
80003dd4:	800084b7          	lui	s1,0x80008
80003dd8:	800085b7          	lui	a1,0x80008
80003ddc:	80008537          	lui	a0,0x80008
80003de0:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80003de4:	06100693          	li	a3,97
80003de8:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003dec:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003df0:	cd5fe0ef          	jal	ra,80002ac4 <printk>
80003df4:	80008537          	lui	a0,0x80008
80003df8:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80003dfc:	cc9fe0ef          	jal	ra,80002ac4 <printk>
80003e00:	06100593          	li	a1,97
80003e04:	fc448513          	addi	a0,s1,-60
80003e08:	cf9fe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003e0c:	30042473          	csrrs	s0,mstatus,s0
}
80003e10:	01c12083          	lw	ra,28(sp)
80003e14:	01812403          	lw	s0,24(sp)
80003e18:	01412483          	lw	s1,20(sp)
80003e1c:	01012903          	lw	s2,16(sp)
80003e20:	00c12983          	lw	s3,12(sp)
80003e24:	00812a03          	lw	s4,8(sp)
80003e28:	02010113          	addi	sp,sp,32
80003e2c:	00008067          	ret

80003e30 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80003e30:	fe010113          	addi	sp,sp,-32
80003e34:	00812c23          	sw	s0,24(sp)
80003e38:	01212823          	sw	s2,16(sp)
80003e3c:	00112e23          	sw	ra,28(sp)
80003e40:	00912a23          	sw	s1,20(sp)
80003e44:	01312623          	sw	s3,12(sp)
80003e48:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e4c:	00800413          	li	s0,8
80003e50:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e54:	800084b7          	lui	s1,0x80008
80003e58:	6ec48513          	addi	a0,s1,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e5c:	00847413          	andi	s0,s0,8
80003e60:	55d010ef          	jal	ra,80005bbc <z_spin_lock_valid>
80003e64:	02051e63          	bnez	a0,80003ea0 <z_unpend_thread_no_timeout+0x70>
80003e68:	800089b7          	lui	s3,0x80008
80003e6c:	800085b7          	lui	a1,0x80008
80003e70:	80008537          	lui	a0,0x80008
80003e74:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80003e78:	04e00693          	li	a3,78
80003e7c:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003e80:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003e84:	c41fe0ef          	jal	ra,80002ac4 <printk>
80003e88:	80008537          	lui	a0,0x80008
80003e8c:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80003e90:	c35fe0ef          	jal	ra,80002ac4 <printk>
80003e94:	04e00593          	li	a1,78
80003e98:	fc498513          	addi	a0,s3,-60
80003e9c:	c65fe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80003ea0:	6ec48513          	addi	a0,s1,1772
80003ea4:	571010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003ea8:	00890513          	addi	a0,s2,8
80003eac:	e15ff0ef          	jal	ra,80003cc0 <pended_on.isra.15>
80003eb0:	00090593          	mv	a1,s2
80003eb4:	2f0000ef          	jal	ra,800041a4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003eb8:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ebc:	6ec48513          	addi	a0,s1,1772
80003ec0:	ffd7f793          	andi	a5,a5,-3
80003ec4:	00f906a3          	sb	a5,13(s2)
80003ec8:	51d010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80003ecc:	02051e63          	bnez	a0,80003f08 <z_unpend_thread_no_timeout+0xd8>
80003ed0:	800084b7          	lui	s1,0x80008
80003ed4:	800085b7          	lui	a1,0x80008
80003ed8:	80008537          	lui	a0,0x80008
80003edc:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80003ee0:	06100693          	li	a3,97
80003ee4:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003ee8:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003eec:	bd9fe0ef          	jal	ra,80002ac4 <printk>
80003ef0:	80008537          	lui	a0,0x80008
80003ef4:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80003ef8:	bcdfe0ef          	jal	ra,80002ac4 <printk>
80003efc:	06100593          	li	a1,97
80003f00:	fc448513          	addi	a0,s1,-60
80003f04:	bfdfe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f08:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80003f0c:	01c12083          	lw	ra,28(sp)
80003f10:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003f14:	00092423          	sw	zero,8(s2)
}
80003f18:	01412483          	lw	s1,20(sp)
80003f1c:	01012903          	lw	s2,16(sp)
80003f20:	00c12983          	lw	s3,12(sp)
80003f24:	02010113          	addi	sp,sp,32
80003f28:	00008067          	ret

80003f2c <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80003f2c:	800097b7          	lui	a5,0x80009
80003f30:	d3c7a783          	lw	a5,-708(a5) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
{
80003f34:	ff010113          	addi	sp,sp,-16
80003f38:	00812423          	sw	s0,8(sp)
80003f3c:	00112623          	sw	ra,12(sp)
80003f40:	00912223          	sw	s1,4(sp)
80003f44:	00058413          	mv	s0,a1
	if (resched()) {
80003f48:	04079e63          	bnez	a5,80003fa4 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f4c:	499010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80003f50:	02051e63          	bnez	a0,80003f8c <z_reschedule+0x60>
80003f54:	800084b7          	lui	s1,0x80008
80003f58:	800085b7          	lui	a1,0x80008
80003f5c:	80008537          	lui	a0,0x80008
80003f60:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80003f64:	07800693          	li	a3,120
80003f68:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003f6c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003f70:	b55fe0ef          	jal	ra,80002ac4 <printk>
80003f74:	80008537          	lui	a0,0x80008
80003f78:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80003f7c:	b49fe0ef          	jal	ra,80002ac4 <printk>
80003f80:	07800593          	li	a1,120
80003f84:	fc448513          	addi	a0,s1,-60
80003f88:	b79fe0ef          	jal	ra,80002b00 <assert_post_action>
80003f8c:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80003f90:	00812403          	lw	s0,8(sp)
80003f94:	00c12083          	lw	ra,12(sp)
80003f98:	00412483          	lw	s1,4(sp)
80003f9c:	01010113          	addi	sp,sp,16
80003fa0:	a98fc06f          	j	80000238 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003fa4:	441010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80003fa8:	02051e63          	bnez	a0,80003fe4 <z_reschedule+0xb8>
80003fac:	800084b7          	lui	s1,0x80008
80003fb0:	800085b7          	lui	a1,0x80008
80003fb4:	80008537          	lui	a0,0x80008
80003fb8:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80003fbc:	06100693          	li	a3,97
80003fc0:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80003fc4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80003fc8:	afdfe0ef          	jal	ra,80002ac4 <printk>
80003fcc:	80008537          	lui	a0,0x80008
80003fd0:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80003fd4:	af1fe0ef          	jal	ra,80002ac4 <printk>
80003fd8:	06100593          	li	a1,97
80003fdc:	fc448513          	addi	a0,s1,-60
80003fe0:	b21fe0ef          	jal	ra,80002b00 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003fe4:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003fe8:	30042473          	csrrs	s0,mstatus,s0
80003fec:	00c12083          	lw	ra,12(sp)
80003ff0:	00812403          	lw	s0,8(sp)
80003ff4:	00412483          	lw	s1,4(sp)
80003ff8:	01010113          	addi	sp,sp,16
80003ffc:	00008067          	ret

80004000 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80004000:	80009737          	lui	a4,0x80009
80004004:	d3c72703          	lw	a4,-708(a4) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80004008:	00071463          	bnez	a4,80004010 <z_reschedule_irqlock+0x10>
8000400c:	a2cfc06f          	j	80000238 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80004010:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004014:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80004018:	00008067          	ret

8000401c <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000401c:	00800513          	li	a0,8
80004020:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80004024:	00857513          	andi	a0,a0,8
80004028:	fd9ff06f          	j	80004000 <z_reschedule_irqlock>

8000402c <k_sched_lock>:

void k_sched_lock(void)
{
8000402c:	fe010113          	addi	sp,sp,-32
80004030:	00812c23          	sw	s0,24(sp)
80004034:	00112e23          	sw	ra,28(sp)
80004038:	00912a23          	sw	s1,20(sp)
8000403c:	01212823          	sw	s2,16(sp)
80004040:	01312623          	sw	s3,12(sp)
80004044:	00800413          	li	s0,8
80004048:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000404c:	800084b7          	lui	s1,0x80008
80004050:	6ec48513          	addi	a0,s1,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004054:	00847413          	andi	s0,s0,8
80004058:	365010ef          	jal	ra,80005bbc <z_spin_lock_valid>
8000405c:	02051e63          	bnez	a0,80004098 <k_sched_lock+0x6c>
80004060:	80008937          	lui	s2,0x80008
80004064:	800085b7          	lui	a1,0x80008
80004068:	80008537          	lui	a0,0x80008
8000406c:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80004070:	04e00693          	li	a3,78
80004074:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004078:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
8000407c:	a49fe0ef          	jal	ra,80002ac4 <printk>
80004080:	80008537          	lui	a0,0x80008
80004084:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80004088:	a3dfe0ef          	jal	ra,80002ac4 <printk>
8000408c:	04e00593          	li	a1,78
80004090:	fc490513          	addi	a0,s2,-60
80004094:	a6dfe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80004098:	6ec48513          	addi	a0,s1,1772
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
8000409c:	80009937          	lui	s2,0x80009
800040a0:	375010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
800040a4:	d3c92783          	lw	a5,-708(s2) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
800040a8:	d3c90913          	addi	s2,s2,-708
800040ac:	02078e63          	beqz	a5,800040e8 <k_sched_lock+0xbc>
800040b0:	800089b7          	lui	s3,0x80008
800040b4:	800085b7          	lui	a1,0x80008
800040b8:	80008537          	lui	a0,0x80008
800040bc:	1c458593          	addi	a1,a1,452 # 800081c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081c5>
800040c0:	10000693          	li	a3,256
800040c4:	1a898613          	addi	a2,s3,424 # 800081a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081a9>
800040c8:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800040cc:	9f9fe0ef          	jal	ra,80002ac4 <printk>
800040d0:	80008537          	lui	a0,0x80008
800040d4:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
800040d8:	9edfe0ef          	jal	ra,80002ac4 <printk>
800040dc:	10000593          	li	a1,256
800040e0:	1a898513          	addi	a0,s3,424
800040e4:	a1dfe0ef          	jal	ra,80002b00 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
800040e8:	00892783          	lw	a5,8(s2)
800040ec:	00f7c703          	lbu	a4,15(a5)
800040f0:	00100793          	li	a5,1
800040f4:	02f71e63          	bne	a4,a5,80004130 <k_sched_lock+0x104>
800040f8:	800089b7          	lui	s3,0x80008
800040fc:	800085b7          	lui	a1,0x80008
80004100:	80008537          	lui	a0,0x80008
80004104:	1dc58593          	addi	a1,a1,476 # 800081dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081dd>
80004108:	10100693          	li	a3,257
8000410c:	1a898613          	addi	a2,s3,424 # 800081a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081a9>
80004110:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004114:	9b1fe0ef          	jal	ra,80002ac4 <printk>
80004118:	80008537          	lui	a0,0x80008
8000411c:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
80004120:	9a5fe0ef          	jal	ra,80002ac4 <printk>
80004124:	10100593          	li	a1,257
80004128:	1a898513          	addi	a0,s3,424
8000412c:	9d5fe0ef          	jal	ra,80002b00 <assert_post_action>

	--_current->base.sched_locked;
80004130:	00892703          	lw	a4,8(s2)
80004134:	00f74783          	lbu	a5,15(a4)
80004138:	fff78793          	addi	a5,a5,-1
8000413c:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004140:	6ec48513          	addi	a0,s1,1772
80004144:	2a1010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80004148:	02051e63          	bnez	a0,80004184 <k_sched_lock+0x158>
8000414c:	800084b7          	lui	s1,0x80008
80004150:	800085b7          	lui	a1,0x80008
80004154:	80008537          	lui	a0,0x80008
80004158:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
8000415c:	06100693          	li	a3,97
80004160:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004164:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004168:	95dfe0ef          	jal	ra,80002ac4 <printk>
8000416c:	80008537          	lui	a0,0x80008
80004170:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80004174:	951fe0ef          	jal	ra,80002ac4 <printk>
80004178:	06100593          	li	a1,97
8000417c:	fc448513          	addi	a0,s1,-60
80004180:	981fe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004184:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80004188:	01c12083          	lw	ra,28(sp)
8000418c:	01812403          	lw	s0,24(sp)
80004190:	01412483          	lw	s1,20(sp)
80004194:	01012903          	lw	s2,16(sp)
80004198:	00c12983          	lw	s3,12(sp)
8000419c:	02010113          	addi	sp,sp,32
800041a0:	00008067          	ret

800041a4 <z_priq_dumb_remove>:
	return thread == _idle_thread;
800041a4:	800087b7          	lui	a5,0x80008
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800041a8:	6787a783          	lw	a5,1656(a5) # 80008678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008679>
{
800041ac:	ff010113          	addi	sp,sp,-16
800041b0:	00812423          	sw	s0,8(sp)
800041b4:	00112623          	sw	ra,12(sp)
800041b8:	00912223          	sw	s1,4(sp)
800041bc:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800041c0:	02f59863          	bne	a1,a5,800041f0 <z_priq_dumb_remove+0x4c>
800041c4:	800084b7          	lui	s1,0x80008
800041c8:	800085b7          	lui	a1,0x80008
800041cc:	80008537          	lui	a0,0x80008
800041d0:	34458593          	addi	a1,a1,836 # 80008344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008345>
800041d4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800041d8:	28c00693          	li	a3,652
800041dc:	22c48613          	addi	a2,s1,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
800041e0:	8e5fe0ef          	jal	ra,80002ac4 <printk>
800041e4:	28c00593          	li	a1,652
800041e8:	22c48513          	addi	a0,s1,556
800041ec:	915fe0ef          	jal	ra,80002b00 <assert_post_action>
	node->prev->next = node->next;
800041f0:	00442703          	lw	a4,4(s0)
800041f4:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
800041f8:	00c12083          	lw	ra,12(sp)
800041fc:	00412483          	lw	s1,4(sp)
80004200:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004204:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80004208:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
8000420c:	00042223          	sw	zero,4(s0)
80004210:	00812403          	lw	s0,8(sp)
80004214:	01010113          	addi	sp,sp,16
80004218:	00008067          	ret

8000421c <z_unpend_thread>:
{
8000421c:	fe010113          	addi	sp,sp,-32
80004220:	00812c23          	sw	s0,24(sp)
80004224:	00912a23          	sw	s1,20(sp)
80004228:	00112e23          	sw	ra,28(sp)
8000422c:	01212823          	sw	s2,16(sp)
80004230:	01312623          	sw	s3,12(sp)
80004234:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004238:	00800493          	li	s1,8
8000423c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004240:	80008937          	lui	s2,0x80008
80004244:	6ec90513          	addi	a0,s2,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004248:	0084f493          	andi	s1,s1,8
8000424c:	171010ef          	jal	ra,80005bbc <z_spin_lock_valid>
80004250:	02051e63          	bnez	a0,8000428c <z_unpend_thread+0x70>
80004254:	800089b7          	lui	s3,0x80008
80004258:	800085b7          	lui	a1,0x80008
8000425c:	80008537          	lui	a0,0x80008
80004260:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80004264:	04e00693          	li	a3,78
80004268:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
8000426c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004270:	855fe0ef          	jal	ra,80002ac4 <printk>
80004274:	80008537          	lui	a0,0x80008
80004278:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
8000427c:	849fe0ef          	jal	ra,80002ac4 <printk>
80004280:	04e00593          	li	a1,78
80004284:	fc498513          	addi	a0,s3,-60
80004288:	879fe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
8000428c:	6ec90513          	addi	a0,s2,1772
80004290:	185010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004294:	00840513          	addi	a0,s0,8
80004298:	a29ff0ef          	jal	ra,80003cc0 <pended_on.isra.15>
8000429c:	00040593          	mv	a1,s0
800042a0:	f05ff0ef          	jal	ra,800041a4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800042a4:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800042a8:	6ec90513          	addi	a0,s2,1772
800042ac:	ffd7f793          	andi	a5,a5,-3
800042b0:	00f406a3          	sb	a5,13(s0)
800042b4:	131010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800042b8:	02051e63          	bnez	a0,800042f4 <z_unpend_thread+0xd8>
800042bc:	80008937          	lui	s2,0x80008
800042c0:	800085b7          	lui	a1,0x80008
800042c4:	80008537          	lui	a0,0x80008
800042c8:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800042cc:	06100693          	li	a3,97
800042d0:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800042d4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800042d8:	fecfe0ef          	jal	ra,80002ac4 <printk>
800042dc:	80008537          	lui	a0,0x80008
800042e0:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800042e4:	fe0fe0ef          	jal	ra,80002ac4 <printk>
800042e8:	06100593          	li	a1,97
800042ec:	fc490513          	addi	a0,s2,-60
800042f0:	811fe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042f4:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800042f8:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800042fc:	01840513          	addi	a0,s0,24
}
80004300:	01812403          	lw	s0,24(sp)
80004304:	01c12083          	lw	ra,28(sp)
80004308:	01412483          	lw	s1,20(sp)
8000430c:	01012903          	lw	s2,16(sp)
80004310:	00c12983          	lw	s3,12(sp)
80004314:	02010113          	addi	sp,sp,32
80004318:	0180206f          	j	80006330 <z_abort_timeout>

8000431c <z_priq_dumb_best>:
	return list->head == list;
8000431c:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004320:	00f51463          	bne	a0,a5,80004328 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80004324:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80004328:	00078513          	mv	a0,a5
8000432c:	00008067          	ret

80004330 <update_cache>:
{
80004330:	ff010113          	addi	sp,sp,-16
80004334:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80004338:	80009437          	lui	s0,0x80009
{
8000433c:	01212023          	sw	s2,0(sp)
80004340:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80004344:	d3c40513          	addi	a0,s0,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80004348:	02450513          	addi	a0,a0,36
{
8000434c:	00912223          	sw	s1,4(sp)
80004350:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80004354:	fc9ff0ef          	jal	ra,8000431c <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80004358:	d3c40413          	addi	s0,s0,-708
8000435c:	00050493          	mv	s1,a0
80004360:	00051463          	bnez	a0,80004368 <update_cache+0x38>
80004364:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
80004368:	06091e63          	bnez	s2,800043e4 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
8000436c:	00842783          	lw	a5,8(s0)
80004370:	02079e63          	bnez	a5,800043ac <update_cache+0x7c>
80004374:	80008937          	lui	s2,0x80008
80004378:	800085b7          	lui	a1,0x80008
8000437c:	80008537          	lui	a0,0x80008
80004380:	25858593          	addi	a1,a1,600 # 80008258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008259>
80004384:	07f00693          	li	a3,127
80004388:	22c90613          	addi	a2,s2,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
8000438c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004390:	f34fe0ef          	jal	ra,80002ac4 <printk>
80004394:	80008537          	lui	a0,0x80008
80004398:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
8000439c:	f28fe0ef          	jal	ra,80002ac4 <printk>
800043a0:	07f00593          	li	a1,127
800043a4:	22c90513          	addi	a0,s2,556
800043a8:	f58fe0ef          	jal	ra,80002b00 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
800043ac:	00842783          	lw	a5,8(s0)
800043b0:	00d7c703          	lbu	a4,13(a5)
800043b4:	01f77713          	andi	a4,a4,31
800043b8:	02071663          	bnez	a4,800043e4 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
800043bc:	00e7d683          	lhu	a3,14(a5)
800043c0:	07f00713          	li	a4,127
800043c4:	02d77063          	bgeu	a4,a3,800043e4 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
800043c8:	02f42023          	sw	a5,32(s0)
}
800043cc:	00c12083          	lw	ra,12(sp)
800043d0:	00812403          	lw	s0,8(sp)
800043d4:	00412483          	lw	s1,4(sp)
800043d8:	00012903          	lw	s2,0(sp)
800043dc:	01010113          	addi	sp,sp,16
800043e0:	00008067          	ret
		if (th != _current) {
800043e4:	00842783          	lw	a5,8(s0)
800043e8:	00978463          	beq	a5,s1,800043f0 <update_cache+0xc0>
			reset_time_slice();
800043ec:	8a1ff0ef          	jal	ra,80003c8c <reset_time_slice>
		_kernel.ready_q.cache = th;
800043f0:	02942023          	sw	s1,32(s0)
}
800043f4:	fd9ff06f          	j	800043cc <update_cache+0x9c>

800043f8 <k_sched_unlock>:
{
800043f8:	fe010113          	addi	sp,sp,-32
800043fc:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80004400:	80009937          	lui	s2,0x80009
80004404:	d3c90793          	addi	a5,s2,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80004408:	0087a783          	lw	a5,8(a5)
{
8000440c:	00112e23          	sw	ra,28(sp)
80004410:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80004414:	00f7c783          	lbu	a5,15(a5)
{
80004418:	00912a23          	sw	s1,20(sp)
8000441c:	01312623          	sw	s3,12(sp)
80004420:	d3c90913          	addi	s2,s2,-708
	__ASSERT(_current->base.sched_locked != 0, "");
80004424:	02079e63          	bnez	a5,80004460 <k_sched_unlock+0x68>
80004428:	80008437          	lui	s0,0x80008
8000442c:	800085b7          	lui	a1,0x80008
80004430:	80008537          	lui	a0,0x80008
80004434:	20458593          	addi	a1,a1,516 # 80008204 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008205>
80004438:	22100693          	li	a3,545
8000443c:	22c40613          	addi	a2,s0,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80004440:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004444:	e80fe0ef          	jal	ra,80002ac4 <printk>
80004448:	80008537          	lui	a0,0x80008
8000444c:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
80004450:	e74fe0ef          	jal	ra,80002ac4 <printk>
80004454:	22100593          	li	a1,545
80004458:	22c40513          	addi	a0,s0,556
8000445c:	ea4fe0ef          	jal	ra,80002b00 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80004460:	00092783          	lw	a5,0(s2)
80004464:	02078e63          	beqz	a5,800044a0 <k_sched_unlock+0xa8>
80004468:	80008437          	lui	s0,0x80008
8000446c:	800085b7          	lui	a1,0x80008
80004470:	80008537          	lui	a0,0x80008
80004474:	1c458593          	addi	a1,a1,452 # 800081c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081c5>
80004478:	22200693          	li	a3,546
8000447c:	22c40613          	addi	a2,s0,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80004480:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004484:	e40fe0ef          	jal	ra,80002ac4 <printk>
80004488:	80008537          	lui	a0,0x80008
8000448c:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
80004490:	e34fe0ef          	jal	ra,80002ac4 <printk>
80004494:	22200593          	li	a1,546
80004498:	22c40513          	addi	a0,s0,556
8000449c:	e64fe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800044a0:	00800413          	li	s0,8
800044a4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800044a8:	800084b7          	lui	s1,0x80008
800044ac:	6ec48513          	addi	a0,s1,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
800044b0:	00847413          	andi	s0,s0,8
800044b4:	708010ef          	jal	ra,80005bbc <z_spin_lock_valid>
800044b8:	02051e63          	bnez	a0,800044f4 <k_sched_unlock+0xfc>
800044bc:	800089b7          	lui	s3,0x80008
800044c0:	800085b7          	lui	a1,0x80008
800044c4:	80008537          	lui	a0,0x80008
800044c8:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
800044cc:	04e00693          	li	a3,78
800044d0:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800044d4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800044d8:	decfe0ef          	jal	ra,80002ac4 <printk>
800044dc:	80008537          	lui	a0,0x80008
800044e0:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
800044e4:	de0fe0ef          	jal	ra,80002ac4 <printk>
800044e8:	04e00593          	li	a1,78
800044ec:	fc498513          	addi	a0,s3,-60
800044f0:	e10fe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
800044f4:	6ec48513          	addi	a0,s1,1772
800044f8:	71c010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
800044fc:	00892703          	lw	a4,8(s2)
		update_cache(1);
80004500:	00100513          	li	a0,1
		++_current->base.sched_locked;
80004504:	00f74783          	lbu	a5,15(a4)
80004508:	00178793          	addi	a5,a5,1
8000450c:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80004510:	e21ff0ef          	jal	ra,80004330 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004514:	6ec48513          	addi	a0,s1,1772
80004518:	6cc010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
8000451c:	02051e63          	bnez	a0,80004558 <k_sched_unlock+0x160>
80004520:	800084b7          	lui	s1,0x80008
80004524:	800085b7          	lui	a1,0x80008
80004528:	80008537          	lui	a0,0x80008
8000452c:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80004530:	06100693          	li	a3,97
80004534:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004538:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
8000453c:	d88fe0ef          	jal	ra,80002ac4 <printk>
80004540:	80008537          	lui	a0,0x80008
80004544:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80004548:	d7cfe0ef          	jal	ra,80002ac4 <printk>
8000454c:	06100593          	li	a1,97
80004550:	fc448513          	addi	a0,s1,-60
80004554:	dacfe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004558:	30042473          	csrrs	s0,mstatus,s0
}
8000455c:	01812403          	lw	s0,24(sp)
80004560:	01c12083          	lw	ra,28(sp)
80004564:	01412483          	lw	s1,20(sp)
80004568:	01012903          	lw	s2,16(sp)
8000456c:	00c12983          	lw	s3,12(sp)
80004570:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80004574:	aa9ff06f          	j	8000401c <z_reschedule_unlocked>

80004578 <z_add_thread_to_ready_q>:
{
80004578:	fe010113          	addi	sp,sp,-32
8000457c:	00812c23          	sw	s0,24(sp)
80004580:	00912a23          	sw	s1,20(sp)
80004584:	00112e23          	sw	ra,28(sp)
80004588:	01212823          	sw	s2,16(sp)
8000458c:	01312623          	sw	s3,12(sp)
80004590:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004594:	00800493          	li	s1,8
80004598:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000459c:	80008937          	lui	s2,0x80008
800045a0:	6ec90513          	addi	a0,s2,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
800045a4:	0084f493          	andi	s1,s1,8
800045a8:	614010ef          	jal	ra,80005bbc <z_spin_lock_valid>
800045ac:	02051e63          	bnez	a0,800045e8 <z_add_thread_to_ready_q+0x70>
800045b0:	800089b7          	lui	s3,0x80008
800045b4:	800085b7          	lui	a1,0x80008
800045b8:	80008537          	lui	a0,0x80008
800045bc:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
800045c0:	04e00693          	li	a3,78
800045c4:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800045c8:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800045cc:	cf8fe0ef          	jal	ra,80002ac4 <printk>
800045d0:	80008537          	lui	a0,0x80008
800045d4:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
800045d8:	cecfe0ef          	jal	ra,80002ac4 <printk>
800045dc:	04e00593          	li	a1,78
800045e0:	fc498513          	addi	a0,s3,-60
800045e4:	d1cfe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
800045e8:	6ec90513          	addi	a0,s2,1772
800045ec:	628010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	return thread == _idle_thread;
800045f0:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
800045f4:	6787a783          	lw	a5,1656(a5) # 80008678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008679>
800045f8:	02f41863          	bne	s0,a5,80004628 <z_add_thread_to_ready_q+0xb0>
800045fc:	800089b7          	lui	s3,0x80008
80004600:	800085b7          	lui	a1,0x80008
80004604:	80008537          	lui	a0,0x80008
80004608:	34458593          	addi	a1,a1,836 # 80008344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008345>
8000460c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004610:	27600693          	li	a3,630
80004614:	22c98613          	addi	a2,s3,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80004618:	cacfe0ef          	jal	ra,80002ac4 <printk>
8000461c:	27600593          	li	a1,630
80004620:	22c98513          	addi	a0,s3,556
80004624:	cdcfe0ef          	jal	ra,80002b00 <assert_post_action>
	return list->head == list;
80004628:	80009737          	lui	a4,0x80009
8000462c:	d3c70693          	addi	a3,a4,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80004630:	0246a783          	lw	a5,36(a3)
80004634:	0286a603          	lw	a2,40(a3)
80004638:	800096b7          	lui	a3,0x80009
8000463c:	d6068693          	addi	a3,a3,-672 # 80008d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d61>
80004640:	d3c70713          	addi	a4,a4,-708
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004644:	0ad78663          	beq	a5,a3,800046f0 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004648:	0a078463          	beqz	a5,800046f0 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
8000464c:	00e40583          	lb	a1,14(s0)
80004650:	00e78503          	lb	a0,14(a5)
80004654:	08a5d863          	bge	a1,a0,800046e4 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80004658:	0047a703          	lw	a4,4(a5)
	node->next = successor;
8000465c:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004660:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004664:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004668:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
8000466c:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80004670:	00000513          	li	a0,0
80004674:	0407e793          	ori	a5,a5,64
80004678:	00f406a3          	sb	a5,13(s0)
8000467c:	cb5ff0ef          	jal	ra,80004330 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004680:	6ec90513          	addi	a0,s2,1772
80004684:	560010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80004688:	02051e63          	bnez	a0,800046c4 <z_add_thread_to_ready_q+0x14c>
8000468c:	80008437          	lui	s0,0x80008
80004690:	800085b7          	lui	a1,0x80008
80004694:	80008537          	lui	a0,0x80008
80004698:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
8000469c:	06100693          	li	a3,97
800046a0:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800046a4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800046a8:	c1cfe0ef          	jal	ra,80002ac4 <printk>
800046ac:	80008537          	lui	a0,0x80008
800046b0:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800046b4:	c10fe0ef          	jal	ra,80002ac4 <printk>
800046b8:	06100593          	li	a1,97
800046bc:	fc440513          	addi	a0,s0,-60
800046c0:	c40fe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800046c4:	3004a4f3          	csrrs	s1,mstatus,s1
}
800046c8:	01c12083          	lw	ra,28(sp)
800046cc:	01812403          	lw	s0,24(sp)
800046d0:	01412483          	lw	s1,20(sp)
800046d4:	01012903          	lw	s2,16(sp)
800046d8:	00c12983          	lw	s3,12(sp)
800046dc:	02010113          	addi	sp,sp,32
800046e0:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
800046e4:	00f60663          	beq	a2,a5,800046f0 <z_add_thread_to_ready_q+0x178>
800046e8:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800046ec:	f60792e3          	bnez	a5,80004650 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
800046f0:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
800046f4:	02872783          	lw	a5,40(a4)
	node->next = list;
800046f8:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
800046fc:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004700:	02872423          	sw	s0,40(a4)
80004704:	f69ff06f          	j	8000466c <z_add_thread_to_ready_q+0xf4>

80004708 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80004708:	ff052783          	lw	a5,-16(a0)
{
8000470c:	fe010113          	addi	sp,sp,-32
80004710:	00812c23          	sw	s0,24(sp)
80004714:	01312623          	sw	s3,12(sp)
80004718:	00112e23          	sw	ra,28(sp)
8000471c:	00912a23          	sw	s1,20(sp)
80004720:	01212823          	sw	s2,16(sp)
80004724:	01412423          	sw	s4,8(sp)
80004728:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
8000472c:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80004730:	0c078463          	beqz	a5,800047f8 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004734:	00800493          	li	s1,8
80004738:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000473c:	80008937          	lui	s2,0x80008
80004740:	6ec90513          	addi	a0,s2,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004744:	0084f493          	andi	s1,s1,8
80004748:	474010ef          	jal	ra,80005bbc <z_spin_lock_valid>
8000474c:	02051e63          	bnez	a0,80004788 <z_thread_timeout+0x80>
80004750:	80008a37          	lui	s4,0x80008
80004754:	800085b7          	lui	a1,0x80008
80004758:	80008537          	lui	a0,0x80008
8000475c:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80004760:	04e00693          	li	a3,78
80004764:	fc4a0613          	addi	a2,s4,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004768:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
8000476c:	b58fe0ef          	jal	ra,80002ac4 <printk>
80004770:	80008537          	lui	a0,0x80008
80004774:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80004778:	b4cfe0ef          	jal	ra,80002ac4 <printk>
8000477c:	04e00593          	li	a1,78
80004780:	fc4a0513          	addi	a0,s4,-60
80004784:	b7cfe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80004788:	6ec90513          	addi	a0,s2,1772
8000478c:	488010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004790:	ff040513          	addi	a0,s0,-16
80004794:	d2cff0ef          	jal	ra,80003cc0 <pended_on.isra.15>
80004798:	00098593          	mv	a1,s3
8000479c:	a09ff0ef          	jal	ra,800041a4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800047a0:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800047a4:	6ec90513          	addi	a0,s2,1772
800047a8:	ffd7f793          	andi	a5,a5,-3
800047ac:	fef40aa3          	sb	a5,-11(s0)
800047b0:	434010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800047b4:	02051e63          	bnez	a0,800047f0 <z_thread_timeout+0xe8>
800047b8:	80008937          	lui	s2,0x80008
800047bc:	800085b7          	lui	a1,0x80008
800047c0:	80008537          	lui	a0,0x80008
800047c4:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800047c8:	06100693          	li	a3,97
800047cc:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800047d0:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800047d4:	af0fe0ef          	jal	ra,80002ac4 <printk>
800047d8:	80008537          	lui	a0,0x80008
800047dc:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800047e0:	ae4fe0ef          	jal	ra,80002ac4 <printk>
800047e4:	06100593          	li	a1,97
800047e8:	fc490513          	addi	a0,s2,-60
800047ec:	b14fe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800047f0:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800047f4:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800047f8:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
800047fc:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80004800:	feb7f793          	andi	a5,a5,-21
80004804:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80004808:	c64ff0ef          	jal	ra,80003c6c <z_is_thread_ready>
8000480c:	02050463          	beqz	a0,80004834 <z_thread_timeout+0x12c>
}
80004810:	01812403          	lw	s0,24(sp)
80004814:	01c12083          	lw	ra,28(sp)
80004818:	01412483          	lw	s1,20(sp)
8000481c:	01012903          	lw	s2,16(sp)
80004820:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80004824:	00098513          	mv	a0,s3
80004828:	00c12983          	lw	s3,12(sp)
8000482c:	02010113          	addi	sp,sp,32
80004830:	d49ff06f          	j	80004578 <z_add_thread_to_ready_q>
80004834:	01c12083          	lw	ra,28(sp)
80004838:	01812403          	lw	s0,24(sp)
8000483c:	01412483          	lw	s1,20(sp)
80004840:	01012903          	lw	s2,16(sp)
80004844:	00c12983          	lw	s3,12(sp)
80004848:	00812a03          	lw	s4,8(sp)
8000484c:	02010113          	addi	sp,sp,32
80004850:	00008067          	ret

80004854 <z_move_thread_to_end_of_prio_q>:
{
80004854:	fe010113          	addi	sp,sp,-32
80004858:	00812c23          	sw	s0,24(sp)
8000485c:	01212823          	sw	s2,16(sp)
80004860:	00112e23          	sw	ra,28(sp)
80004864:	00912a23          	sw	s1,20(sp)
80004868:	01312623          	sw	s3,12(sp)
8000486c:	01412423          	sw	s4,8(sp)
80004870:	01512223          	sw	s5,4(sp)
80004874:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004878:	00800913          	li	s2,8
8000487c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004880:	800089b7          	lui	s3,0x80008
80004884:	6ec98513          	addi	a0,s3,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004888:	00897913          	andi	s2,s2,8
8000488c:	330010ef          	jal	ra,80005bbc <z_spin_lock_valid>
80004890:	02051e63          	bnez	a0,800048cc <z_move_thread_to_end_of_prio_q+0x78>
80004894:	800084b7          	lui	s1,0x80008
80004898:	800085b7          	lui	a1,0x80008
8000489c:	80008537          	lui	a0,0x80008
800048a0:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
800048a4:	04e00693          	li	a3,78
800048a8:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800048ac:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800048b0:	a14fe0ef          	jal	ra,80002ac4 <printk>
800048b4:	80008537          	lui	a0,0x80008
800048b8:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
800048bc:	a08fe0ef          	jal	ra,80002ac4 <printk>
800048c0:	04e00593          	li	a1,78
800048c4:	fc448513          	addi	a0,s1,-60
800048c8:	a38fe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
800048cc:	6ec98513          	addi	a0,s3,1772
800048d0:	344010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800048d4:	800094b7          	lui	s1,0x80009
800048d8:	d3c48513          	addi	a0,s1,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
800048dc:	00040593          	mv	a1,s0
800048e0:	02450513          	addi	a0,a0,36
800048e4:	8c1ff0ef          	jal	ra,800041a4 <z_priq_dumb_remove>
	return thread == _idle_thread;
800048e8:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
800048ec:	6787a783          	lw	a5,1656(a5) # 80008678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008679>
800048f0:	80009a37          	lui	s4,0x80009
800048f4:	d3c48493          	addi	s1,s1,-708
800048f8:	d60a0a13          	addi	s4,s4,-672 # 80008d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d61>
800048fc:	02f41863          	bne	s0,a5,8000492c <z_move_thread_to_end_of_prio_q+0xd8>
80004900:	80008ab7          	lui	s5,0x80008
80004904:	800085b7          	lui	a1,0x80008
80004908:	80008537          	lui	a0,0x80008
8000490c:	34458593          	addi	a1,a1,836 # 80008344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008345>
80004910:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004914:	27600693          	li	a3,630
80004918:	22ca8613          	addi	a2,s5,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
8000491c:	9a8fe0ef          	jal	ra,80002ac4 <printk>
80004920:	27600593          	li	a1,630
80004924:	22ca8513          	addi	a0,s5,556
80004928:	9d8fe0ef          	jal	ra,80002b00 <assert_post_action>
	return list->head == list;
8000492c:	0244a783          	lw	a5,36(s1)
80004930:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004934:	0b478e63          	beq	a5,s4,800049f0 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004938:	0a078c63          	beqz	a5,800049f0 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
8000493c:	00e40683          	lb	a3,14(s0)
80004940:	00e78603          	lb	a2,14(a5)
80004944:	0ac6d063          	bge	a3,a2,800049e4 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80004948:	0047a703          	lw	a4,4(a5)
	node->next = successor;
8000494c:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004950:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004954:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004958:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
8000495c:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80004960:	0084a503          	lw	a0,8(s1)
80004964:	0407e793          	ori	a5,a5,64
80004968:	40850533          	sub	a0,a0,s0
8000496c:	00153513          	seqz	a0,a0
80004970:	00f406a3          	sb	a5,13(s0)
80004974:	9bdff0ef          	jal	ra,80004330 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004978:	6ec98513          	addi	a0,s3,1772
8000497c:	268010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80004980:	02051e63          	bnez	a0,800049bc <z_move_thread_to_end_of_prio_q+0x168>
80004984:	80008437          	lui	s0,0x80008
80004988:	800085b7          	lui	a1,0x80008
8000498c:	80008537          	lui	a0,0x80008
80004990:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80004994:	06100693          	li	a3,97
80004998:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
8000499c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800049a0:	924fe0ef          	jal	ra,80002ac4 <printk>
800049a4:	80008537          	lui	a0,0x80008
800049a8:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800049ac:	918fe0ef          	jal	ra,80002ac4 <printk>
800049b0:	06100593          	li	a1,97
800049b4:	fc440513          	addi	a0,s0,-60
800049b8:	948fe0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800049bc:	30092973          	csrrs	s2,mstatus,s2
}
800049c0:	01c12083          	lw	ra,28(sp)
800049c4:	01812403          	lw	s0,24(sp)
800049c8:	01412483          	lw	s1,20(sp)
800049cc:	01012903          	lw	s2,16(sp)
800049d0:	00c12983          	lw	s3,12(sp)
800049d4:	00812a03          	lw	s4,8(sp)
800049d8:	00412a83          	lw	s5,4(sp)
800049dc:	02010113          	addi	sp,sp,32
800049e0:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
800049e4:	00e78663          	beq	a5,a4,800049f0 <z_move_thread_to_end_of_prio_q+0x19c>
800049e8:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800049ec:	f4079ae3          	bnez	a5,80004940 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
800049f0:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
800049f4:	0284a783          	lw	a5,40(s1)
	node->next = list;
800049f8:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800049fc:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004a00:	0284a423          	sw	s0,40(s1)
80004a04:	f59ff06f          	j	8000495c <z_move_thread_to_end_of_prio_q+0x108>

80004a08 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80004a08:	800087b7          	lui	a5,0x80008
80004a0c:	6f47a783          	lw	a5,1780(a5) # 800086f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086f5>
80004a10:	06078663          	beqz	a5,80004a7c <z_time_slice+0x74>
80004a14:	800097b7          	lui	a5,0x80009
80004a18:	d3c78793          	addi	a5,a5,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80004a1c:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80004a20:	07f00693          	li	a3,127
80004a24:	00e75603          	lhu	a2,14(a4)
80004a28:	04c6ea63          	bltu	a3,a2,80004a7c <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80004a2c:	800086b7          	lui	a3,0x80008
80004a30:	00e70603          	lb	a2,14(a4)
80004a34:	6f06a683          	lw	a3,1776(a3) # 800086f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086f1>
80004a38:	04d64263          	blt	a2,a3,80004a7c <z_time_slice+0x74>
	return thread == _idle_thread;
80004a3c:	800086b7          	lui	a3,0x80008
		&& !is_idle(t)
80004a40:	6786a683          	lw	a3,1656(a3) # 80008678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008679>
80004a44:	02d70c63          	beq	a4,a3,80004a7c <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80004a48:	01872683          	lw	a3,24(a4)
80004a4c:	02069863          	bnez	a3,80004a7c <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80004a50:	0107a683          	lw	a3,16(a5)
80004a54:	02d54063          	blt	a0,a3,80004a74 <z_time_slice+0x6c>
{
80004a58:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80004a5c:	00070513          	mv	a0,a4
{
80004a60:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80004a64:	df1ff0ef          	jal	ra,80004854 <z_move_thread_to_end_of_prio_q>
}
80004a68:	00c12083          	lw	ra,12(sp)
80004a6c:	01010113          	addi	sp,sp,16
			reset_time_slice();
80004a70:	a1cff06f          	j	80003c8c <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80004a74:	40a686b3          	sub	a3,a3,a0
80004a78:	00d7a823          	sw	a3,16(a5)
80004a7c:	00008067          	ret

80004a80 <z_remove_thread_from_ready_q>:
{
80004a80:	fe010113          	addi	sp,sp,-32
80004a84:	00812c23          	sw	s0,24(sp)
80004a88:	01312623          	sw	s3,12(sp)
80004a8c:	00112e23          	sw	ra,28(sp)
80004a90:	00912a23          	sw	s1,20(sp)
80004a94:	01212823          	sw	s2,16(sp)
80004a98:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004a9c:	00800413          	li	s0,8
80004aa0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004aa4:	800084b7          	lui	s1,0x80008
80004aa8:	6ec48513          	addi	a0,s1,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004aac:	00847413          	andi	s0,s0,8
80004ab0:	10c010ef          	jal	ra,80005bbc <z_spin_lock_valid>
80004ab4:	02051e63          	bnez	a0,80004af0 <z_remove_thread_from_ready_q+0x70>
80004ab8:	80008937          	lui	s2,0x80008
80004abc:	800085b7          	lui	a1,0x80008
80004ac0:	80008537          	lui	a0,0x80008
80004ac4:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80004ac8:	04e00693          	li	a3,78
80004acc:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004ad0:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004ad4:	ff1fd0ef          	jal	ra,80002ac4 <printk>
80004ad8:	80008537          	lui	a0,0x80008
80004adc:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80004ae0:	fe5fd0ef          	jal	ra,80002ac4 <printk>
80004ae4:	04e00593          	li	a1,78
80004ae8:	fc490513          	addi	a0,s2,-60
80004aec:	814fe0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80004af0:	6ec48513          	addi	a0,s1,1772
80004af4:	120010ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80004af8:	00d9c783          	lbu	a5,13(s3)
80004afc:	80009937          	lui	s2,0x80009
80004b00:	d3c90913          	addi	s2,s2,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80004b04:	0407f793          	andi	a5,a5,64
80004b08:	00078e63          	beqz	a5,80004b24 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80004b0c:	00098593          	mv	a1,s3
80004b10:	02490513          	addi	a0,s2,36
80004b14:	e90ff0ef          	jal	ra,800041a4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80004b18:	00d9c783          	lbu	a5,13(s3)
80004b1c:	fbf7f793          	andi	a5,a5,-65
80004b20:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80004b24:	00892503          	lw	a0,8(s2)
80004b28:	41350533          	sub	a0,a0,s3
80004b2c:	00153513          	seqz	a0,a0
80004b30:	801ff0ef          	jal	ra,80004330 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004b34:	6ec48513          	addi	a0,s1,1772
80004b38:	0ac010ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80004b3c:	02051e63          	bnez	a0,80004b78 <z_remove_thread_from_ready_q+0xf8>
80004b40:	800084b7          	lui	s1,0x80008
80004b44:	800085b7          	lui	a1,0x80008
80004b48:	80008537          	lui	a0,0x80008
80004b4c:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80004b50:	06100693          	li	a3,97
80004b54:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004b58:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004b5c:	f69fd0ef          	jal	ra,80002ac4 <printk>
80004b60:	80008537          	lui	a0,0x80008
80004b64:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80004b68:	f5dfd0ef          	jal	ra,80002ac4 <printk>
80004b6c:	06100593          	li	a1,97
80004b70:	fc448513          	addi	a0,s1,-60
80004b74:	f8dfd0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004b78:	30042473          	csrrs	s0,mstatus,s0
}
80004b7c:	01c12083          	lw	ra,28(sp)
80004b80:	01812403          	lw	s0,24(sp)
80004b84:	01412483          	lw	s1,20(sp)
80004b88:	01012903          	lw	s2,16(sp)
80004b8c:	00c12983          	lw	s3,12(sp)
80004b90:	02010113          	addi	sp,sp,32
80004b94:	00008067          	ret

80004b98 <pend>:
{
80004b98:	fe010113          	addi	sp,sp,-32
80004b9c:	00812c23          	sw	s0,24(sp)
80004ba0:	00912a23          	sw	s1,20(sp)
80004ba4:	00050413          	mv	s0,a0
80004ba8:	01212823          	sw	s2,16(sp)
80004bac:	00112e23          	sw	ra,28(sp)
80004bb0:	01312623          	sw	s3,12(sp)
80004bb4:	00058493          	mv	s1,a1
80004bb8:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80004bbc:	ec5ff0ef          	jal	ra,80004a80 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80004bc0:	00d44783          	lbu	a5,13(s0)
80004bc4:	0027e793          	ori	a5,a5,2
80004bc8:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80004bcc:	06048663          	beqz	s1,80004c38 <pend+0xa0>
	return thread == _idle_thread;
80004bd0:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
80004bd4:	6787a783          	lw	a5,1656(a5) # 80008678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008679>
		thread->base.pended_on = wait_q;
80004bd8:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80004bdc:	02f41863          	bne	s0,a5,80004c0c <pend+0x74>
80004be0:	800089b7          	lui	s3,0x80008
80004be4:	800085b7          	lui	a1,0x80008
80004be8:	80008537          	lui	a0,0x80008
80004bec:	34458593          	addi	a1,a1,836 # 80008344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008345>
80004bf0:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004bf4:	27600693          	li	a3,630
80004bf8:	22c98613          	addi	a2,s3,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80004bfc:	ec9fd0ef          	jal	ra,80002ac4 <printk>
80004c00:	27600593          	li	a1,630
80004c04:	22c98513          	addi	a0,s3,556
80004c08:	ef9fd0ef          	jal	ra,80002b00 <assert_post_action>
	return list->head == list;
80004c0c:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004c10:	06f48c63          	beq	s1,a5,80004c88 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004c14:	06078a63          	beqz	a5,80004c88 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80004c18:	00e40703          	lb	a4,14(s0)
80004c1c:	00e78683          	lb	a3,14(a5)
80004c20:	04d75c63          	bge	a4,a3,80004c78 <pend+0xe0>
	node->prev = successor->prev;
80004c24:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004c28:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004c2c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004c30:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004c34:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80004c38:	fff00793          	li	a5,-1
80004c3c:	06f90463          	beq	s2,a5,80004ca4 <pend+0x10c>
80004c40:	00a00593          	li	a1,10
80004c44:	00990513          	addi	a0,s2,9
80004c48:	d01fb0ef          	jal	ra,80000948 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004c4c:	00150613          	addi	a2,a0,1
80004c50:	01840513          	addi	a0,s0,24
}
80004c54:	01812403          	lw	s0,24(sp)
80004c58:	01c12083          	lw	ra,28(sp)
80004c5c:	01412483          	lw	s1,20(sp)
80004c60:	01012903          	lw	s2,16(sp)
80004c64:	00c12983          	lw	s3,12(sp)
80004c68:	800045b7          	lui	a1,0x80004
80004c6c:	70858593          	addi	a1,a1,1800 # 80004708 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004709>
80004c70:	02010113          	addi	sp,sp,32
80004c74:	4900106f          	j	80006104 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80004c78:	0044a683          	lw	a3,4(s1)
80004c7c:	00d78663          	beq	a5,a3,80004c88 <pend+0xf0>
80004c80:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004c84:	f8079ce3          	bnez	a5,80004c1c <pend+0x84>
	node->prev = list->tail;
80004c88:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004c8c:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80004c90:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004c94:	0044a783          	lw	a5,4(s1)
80004c98:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004c9c:	0084a223          	sw	s0,4(s1)
80004ca0:	f99ff06f          	j	80004c38 <pend+0xa0>
}
80004ca4:	01c12083          	lw	ra,28(sp)
80004ca8:	01812403          	lw	s0,24(sp)
80004cac:	01412483          	lw	s1,20(sp)
80004cb0:	01012903          	lw	s2,16(sp)
80004cb4:	00c12983          	lw	s3,12(sp)
80004cb8:	02010113          	addi	sp,sp,32
80004cbc:	00008067          	ret

80004cc0 <z_pend_curr_irqlock>:
{
80004cc0:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80004cc4:	800097b7          	lui	a5,0x80009
{
80004cc8:	00812423          	sw	s0,8(sp)
80004ccc:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80004cd0:	d447a503          	lw	a0,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
{
80004cd4:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80004cd8:	ec1ff0ef          	jal	ra,80004b98 <pend>
80004cdc:	00040513          	mv	a0,s0
}
80004ce0:	00812403          	lw	s0,8(sp)
80004ce4:	00c12083          	lw	ra,12(sp)
80004ce8:	01010113          	addi	sp,sp,16
80004cec:	d4cfb06f          	j	80000238 <__swap>

80004cf0 <z_pend_curr>:
{
80004cf0:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80004cf4:	800097b7          	lui	a5,0x80009
{
80004cf8:	00812423          	sw	s0,8(sp)
80004cfc:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80004d00:	d447a503          	lw	a0,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
{
80004d04:	00912223          	sw	s1,4(sp)
80004d08:	00058493          	mv	s1,a1
80004d0c:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80004d10:	00068613          	mv	a2,a3
{
80004d14:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80004d18:	e81ff0ef          	jal	ra,80004b98 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004d1c:	00040513          	mv	a0,s0
80004d20:	6c5000ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80004d24:	02051e63          	bnez	a0,80004d60 <z_pend_curr+0x70>
80004d28:	80008437          	lui	s0,0x80008
80004d2c:	800085b7          	lui	a1,0x80008
80004d30:	80008537          	lui	a0,0x80008
80004d34:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80004d38:	07800693          	li	a3,120
80004d3c:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004d40:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004d44:	d81fd0ef          	jal	ra,80002ac4 <printk>
80004d48:	80008537          	lui	a0,0x80008
80004d4c:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80004d50:	d75fd0ef          	jal	ra,80002ac4 <printk>
80004d54:	07800593          	li	a1,120
80004d58:	fc440513          	addi	a0,s0,-60
80004d5c:	da5fd0ef          	jal	ra,80002b00 <assert_post_action>
}
80004d60:	00812403          	lw	s0,8(sp)
80004d64:	00c12083          	lw	ra,12(sp)
80004d68:	00048513          	mv	a0,s1
80004d6c:	00412483          	lw	s1,4(sp)
80004d70:	01010113          	addi	sp,sp,16
80004d74:	cc4fb06f          	j	80000238 <__swap>

80004d78 <z_thread_priority_set>:
{
80004d78:	fe010113          	addi	sp,sp,-32
80004d7c:	00812c23          	sw	s0,24(sp)
80004d80:	01212823          	sw	s2,16(sp)
80004d84:	01412423          	sw	s4,8(sp)
80004d88:	00112e23          	sw	ra,28(sp)
80004d8c:	00912a23          	sw	s1,20(sp)
80004d90:	01312623          	sw	s3,12(sp)
80004d94:	01512223          	sw	s5,4(sp)
80004d98:	01612023          	sw	s6,0(sp)
80004d9c:	00050413          	mv	s0,a0
80004da0:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004da4:	00800913          	li	s2,8
80004da8:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004dac:	800089b7          	lui	s3,0x80008
80004db0:	6ec98513          	addi	a0,s3,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004db4:	00897913          	andi	s2,s2,8
80004db8:	605000ef          	jal	ra,80005bbc <z_spin_lock_valid>
80004dbc:	02051e63          	bnez	a0,80004df8 <z_thread_priority_set+0x80>
80004dc0:	800084b7          	lui	s1,0x80008
80004dc4:	800085b7          	lui	a1,0x80008
80004dc8:	80008537          	lui	a0,0x80008
80004dcc:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80004dd0:	04e00693          	li	a3,78
80004dd4:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004dd8:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004ddc:	ce9fd0ef          	jal	ra,80002ac4 <printk>
80004de0:	80008537          	lui	a0,0x80008
80004de4:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80004de8:	cddfd0ef          	jal	ra,80002ac4 <printk>
80004dec:	04e00593          	li	a1,78
80004df0:	fc448513          	addi	a0,s1,-60
80004df4:	d0dfd0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80004df8:	6ec98513          	addi	a0,s3,1772
80004dfc:	619000ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		need_sched = z_is_thread_ready(thread);
80004e00:	00040513          	mv	a0,s0
80004e04:	e69fe0ef          	jal	ra,80003c6c <z_is_thread_ready>
80004e08:	018a1a13          	slli	s4,s4,0x18
80004e0c:	00050a93          	mv	s5,a0
		if (need_sched) {
80004e10:	418a5a13          	srai	s4,s4,0x18
80004e14:	14050063          	beqz	a0,80004f54 <z_thread_priority_set+0x1dc>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80004e18:	800094b7          	lui	s1,0x80009
80004e1c:	d3c48513          	addi	a0,s1,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80004e20:	00040593          	mv	a1,s0
80004e24:	02450513          	addi	a0,a0,36
80004e28:	b7cff0ef          	jal	ra,800041a4 <z_priq_dumb_remove>
	return thread == _idle_thread;
80004e2c:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
80004e30:	6787a783          	lw	a5,1656(a5) # 80008678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008679>
			thread->base.prio = prio;
80004e34:	01440723          	sb	s4,14(s0)
	return thread == _idle_thread;
80004e38:	80009a37          	lui	s4,0x80009
80004e3c:	d3c48493          	addi	s1,s1,-708
80004e40:	d60a0a13          	addi	s4,s4,-672 # 80008d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d61>
	__ASSERT_NO_MSG(!is_idle(thread));
80004e44:	02f41863          	bne	s0,a5,80004e74 <z_thread_priority_set+0xfc>
80004e48:	80008b37          	lui	s6,0x80008
80004e4c:	800085b7          	lui	a1,0x80008
80004e50:	80008537          	lui	a0,0x80008
80004e54:	34458593          	addi	a1,a1,836 # 80008344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008345>
80004e58:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004e5c:	27600693          	li	a3,630
80004e60:	22cb0613          	addi	a2,s6,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80004e64:	c61fd0ef          	jal	ra,80002ac4 <printk>
80004e68:	27600593          	li	a1,630
80004e6c:	22cb0513          	addi	a0,s6,556
80004e70:	c91fd0ef          	jal	ra,80002b00 <assert_post_action>
	return list->head == list;
80004e74:	0244a783          	lw	a5,36(s1)
80004e78:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004e7c:	0d478063          	beq	a5,s4,80004f3c <z_thread_priority_set+0x1c4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004e80:	0a078e63          	beqz	a5,80004f3c <z_thread_priority_set+0x1c4>
	if (t1->base.prio < t2->base.prio) {
80004e84:	00e40683          	lb	a3,14(s0)
80004e88:	00e78603          	lb	a2,14(a5)
80004e8c:	0ac6d263          	bge	a3,a2,80004f30 <z_thread_priority_set+0x1b8>
	node->prev = successor->prev;
80004e90:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004e94:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004e98:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004e9c:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004ea0:	0087a223          	sw	s0,4(a5)
			update_cache(1);
80004ea4:	00100513          	li	a0,1
80004ea8:	c88ff0ef          	jal	ra,80004330 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004eac:	6ec98513          	addi	a0,s3,1772
80004eb0:	535000ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80004eb4:	02051e63          	bnez	a0,80004ef0 <z_thread_priority_set+0x178>
80004eb8:	80008437          	lui	s0,0x80008
80004ebc:	800085b7          	lui	a1,0x80008
80004ec0:	80008537          	lui	a0,0x80008
80004ec4:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80004ec8:	06100693          	li	a3,97
80004ecc:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004ed0:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004ed4:	bf1fd0ef          	jal	ra,80002ac4 <printk>
80004ed8:	80008537          	lui	a0,0x80008
80004edc:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80004ee0:	be5fd0ef          	jal	ra,80002ac4 <printk>
80004ee4:	06100593          	li	a1,97
80004ee8:	fc440513          	addi	a0,s0,-60
80004eec:	c15fd0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004ef0:	30092973          	csrrs	s2,mstatus,s2
	if (need_sched && _current->base.sched_locked == 0) {
80004ef4:	060a8463          	beqz	s5,80004f5c <z_thread_priority_set+0x1e4>
80004ef8:	800097b7          	lui	a5,0x80009
80004efc:	d447a783          	lw	a5,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
80004f00:	00f7c783          	lbu	a5,15(a5)
80004f04:	04079c63          	bnez	a5,80004f5c <z_thread_priority_set+0x1e4>
}
80004f08:	01812403          	lw	s0,24(sp)
80004f0c:	01c12083          	lw	ra,28(sp)
80004f10:	01412483          	lw	s1,20(sp)
80004f14:	01012903          	lw	s2,16(sp)
80004f18:	00c12983          	lw	s3,12(sp)
80004f1c:	00812a03          	lw	s4,8(sp)
80004f20:	00412a83          	lw	s5,4(sp)
80004f24:	00012b03          	lw	s6,0(sp)
80004f28:	02010113          	addi	sp,sp,32
		z_reschedule_unlocked();
80004f2c:	8f0ff06f          	j	8000401c <z_reschedule_unlocked>
	return (node == list->tail) ? NULL : node->next;
80004f30:	00e78663          	beq	a5,a4,80004f3c <z_thread_priority_set+0x1c4>
80004f34:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004f38:	f40798e3          	bnez	a5,80004e88 <z_thread_priority_set+0x110>
	node->prev = list->tail;
80004f3c:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80004f40:	0284a783          	lw	a5,40(s1)
	node->next = list;
80004f44:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80004f48:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004f4c:	0284a423          	sw	s0,40(s1)
80004f50:	f55ff06f          	j	80004ea4 <z_thread_priority_set+0x12c>
			thread->base.prio = prio;
80004f54:	01440723          	sb	s4,14(s0)
80004f58:	f55ff06f          	j	80004eac <z_thread_priority_set+0x134>
}
80004f5c:	01c12083          	lw	ra,28(sp)
80004f60:	01812403          	lw	s0,24(sp)
80004f64:	01412483          	lw	s1,20(sp)
80004f68:	01012903          	lw	s2,16(sp)
80004f6c:	00c12983          	lw	s3,12(sp)
80004f70:	00812a03          	lw	s4,8(sp)
80004f74:	00412a83          	lw	s5,4(sp)
80004f78:	00012b03          	lw	s6,0(sp)
80004f7c:	02010113          	addi	sp,sp,32
80004f80:	00008067          	ret

80004f84 <z_unpend_first_thread>:
{
80004f84:	fe010113          	addi	sp,sp,-32
80004f88:	01212823          	sw	s2,16(sp)
80004f8c:	01312623          	sw	s3,12(sp)
80004f90:	00112e23          	sw	ra,28(sp)
80004f94:	00812c23          	sw	s0,24(sp)
80004f98:	00912a23          	sw	s1,20(sp)
80004f9c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004fa0:	00800913          	li	s2,8
80004fa4:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004fa8:	800084b7          	lui	s1,0x80008
80004fac:	6ec48513          	addi	a0,s1,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80004fb0:	00897913          	andi	s2,s2,8
80004fb4:	409000ef          	jal	ra,80005bbc <z_spin_lock_valid>
80004fb8:	02051e63          	bnez	a0,80004ff4 <z_unpend_first_thread+0x70>
80004fbc:	80008437          	lui	s0,0x80008
80004fc0:	800085b7          	lui	a1,0x80008
80004fc4:	80008537          	lui	a0,0x80008
80004fc8:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80004fcc:	04e00693          	li	a3,78
80004fd0:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80004fd4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80004fd8:	aedfd0ef          	jal	ra,80002ac4 <printk>
80004fdc:	80008537          	lui	a0,0x80008
80004fe0:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80004fe4:	ae1fd0ef          	jal	ra,80002ac4 <printk>
80004fe8:	04e00593          	li	a1,78
80004fec:	fc440513          	addi	a0,s0,-60
80004ff0:	b11fd0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ff4:	6ec48513          	addi	a0,s1,1772
80004ff8:	41d000ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80004ffc:	00098513          	mv	a0,s3
80005000:	b1cff0ef          	jal	ra,8000431c <z_priq_dumb_best>
80005004:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005008:	6ec48513          	addi	a0,s1,1772
8000500c:	3d9000ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80005010:	02051e63          	bnez	a0,8000504c <z_unpend_first_thread+0xc8>
80005014:	800089b7          	lui	s3,0x80008
80005018:	800085b7          	lui	a1,0x80008
8000501c:	80008537          	lui	a0,0x80008
80005020:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80005024:	06100693          	li	a3,97
80005028:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
8000502c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005030:	a95fd0ef          	jal	ra,80002ac4 <printk>
80005034:	80008537          	lui	a0,0x80008
80005038:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
8000503c:	a89fd0ef          	jal	ra,80002ac4 <printk>
80005040:	06100593          	li	a1,97
80005044:	fc498513          	addi	a0,s3,-60
80005048:	ab9fd0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000504c:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80005050:	0c040663          	beqz	s0,8000511c <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005054:	00800913          	li	s2,8
80005058:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000505c:	6ec48513          	addi	a0,s1,1772
	key = (mstatus & SOC_MSTATUS_IEN);
80005060:	00897913          	andi	s2,s2,8
80005064:	359000ef          	jal	ra,80005bbc <z_spin_lock_valid>
80005068:	02051e63          	bnez	a0,800050a4 <z_unpend_first_thread+0x120>
8000506c:	800089b7          	lui	s3,0x80008
80005070:	800085b7          	lui	a1,0x80008
80005074:	80008537          	lui	a0,0x80008
80005078:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
8000507c:	04e00693          	li	a3,78
80005080:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005084:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005088:	a3dfd0ef          	jal	ra,80002ac4 <printk>
8000508c:	80008537          	lui	a0,0x80008
80005090:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80005094:	a31fd0ef          	jal	ra,80002ac4 <printk>
80005098:	04e00593          	li	a1,78
8000509c:	fc498513          	addi	a0,s3,-60
800050a0:	a61fd0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
800050a4:	6ec48513          	addi	a0,s1,1772
800050a8:	36d000ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800050ac:	00840513          	addi	a0,s0,8
800050b0:	c11fe0ef          	jal	ra,80003cc0 <pended_on.isra.15>
800050b4:	00040593          	mv	a1,s0
800050b8:	8ecff0ef          	jal	ra,800041a4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800050bc:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800050c0:	6ec48513          	addi	a0,s1,1772
800050c4:	ffd7f793          	andi	a5,a5,-3
800050c8:	00f406a3          	sb	a5,13(s0)
800050cc:	319000ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800050d0:	02051e63          	bnez	a0,8000510c <z_unpend_first_thread+0x188>
800050d4:	800084b7          	lui	s1,0x80008
800050d8:	800085b7          	lui	a1,0x80008
800050dc:	80008537          	lui	a0,0x80008
800050e0:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800050e4:	06100693          	li	a3,97
800050e8:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800050ec:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800050f0:	9d5fd0ef          	jal	ra,80002ac4 <printk>
800050f4:	80008537          	lui	a0,0x80008
800050f8:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800050fc:	9c9fd0ef          	jal	ra,80002ac4 <printk>
80005100:	06100593          	li	a1,97
80005104:	fc448513          	addi	a0,s1,-60
80005108:	9f9fd0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000510c:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80005110:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80005114:	01840513          	addi	a0,s0,24
80005118:	218010ef          	jal	ra,80006330 <z_abort_timeout>
}
8000511c:	00040513          	mv	a0,s0
80005120:	01c12083          	lw	ra,28(sp)
80005124:	01812403          	lw	s0,24(sp)
80005128:	01412483          	lw	s1,20(sp)
8000512c:	01012903          	lw	s2,16(sp)
80005130:	00c12983          	lw	s3,12(sp)
80005134:	02010113          	addi	sp,sp,32
80005138:	00008067          	ret

8000513c <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
8000513c:	ff010113          	addi	sp,sp,-16
80005140:	00912223          	sw	s1,4(sp)
80005144:	01212023          	sw	s2,0(sp)
80005148:	00112623          	sw	ra,12(sp)
8000514c:	00812423          	sw	s0,8(sp)
80005150:	00050913          	mv	s2,a0
	int need_sched = 0;
80005154:	00000493          	li	s1,0
	return list->head == list;
80005158:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000515c:	00890463          	beq	s2,s0,80005164 <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80005160:	02041063          	bnez	s0,80005180 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80005164:	00c12083          	lw	ra,12(sp)
80005168:	00812403          	lw	s0,8(sp)
8000516c:	00048513          	mv	a0,s1
80005170:	00012903          	lw	s2,0(sp)
80005174:	00412483          	lw	s1,4(sp)
80005178:	01010113          	addi	sp,sp,16
8000517c:	00008067          	ret
		z_unpend_thread(th);
80005180:	00040513          	mv	a0,s0
80005184:	898ff0ef          	jal	ra,8000421c <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80005188:	00040513          	mv	a0,s0
8000518c:	ae1fe0ef          	jal	ra,80003c6c <z_is_thread_ready>
		need_sched = 1;
80005190:	00100493          	li	s1,1
80005194:	fc0502e3          	beqz	a0,80005158 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80005198:	00040513          	mv	a0,s0
8000519c:	bdcff0ef          	jal	ra,80004578 <z_add_thread_to_ready_q>
800051a0:	fb9ff06f          	j	80005158 <z_unpend_all+0x1c>

800051a4 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
800051a4:	800097b7          	lui	a5,0x80009
800051a8:	d3c78793          	addi	a5,a5,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
800051ac:	02478713          	addi	a4,a5,36
800051b0:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
800051b4:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
800051b8:	00000593          	li	a1,0
800051bc:	00000513          	li	a0,0
800051c0:	b61fe06f          	j	80003d20 <k_sched_time_slice_set>

800051c4 <z_impl_k_thread_priority_set>:
Z_SYSCALL_HANDLER1_SIMPLE(k_thread_priority_get, K_OBJ_THREAD,
			  struct k_thread *);
#endif

void z_impl_k_thread_priority_set(k_tid_t tid, int prio)
{
800051c4:	ff010113          	addi	sp,sp,-16
800051c8:	00812423          	sw	s0,8(sp)
800051cc:	01212023          	sw	s2,0(sp)
800051d0:	00112623          	sw	ra,12(sp)
800051d4:	00912223          	sw	s1,4(sp)
	/*
	 * Use NULL, since we cannot know what the entry point is (we do not
	 * keep track of it) and idle cannot change its priority.
	 */
	Z_ASSERT_VALID_PRIO(prio, NULL);
800051d8:	01058713          	addi	a4,a1,16
800051dc:	01e00793          	li	a5,30
{
800051e0:	00050913          	mv	s2,a0
800051e4:	00058413          	mv	s0,a1
	Z_ASSERT_VALID_PRIO(prio, NULL);
800051e8:	04e7f463          	bgeu	a5,a4,80005230 <z_impl_k_thread_priority_set+0x6c>
800051ec:	800084b7          	lui	s1,0x80008
800051f0:	800085b7          	lui	a1,0x80008
800051f4:	80008537          	lui	a0,0x80008
800051f8:	34500693          	li	a3,837
800051fc:	22c48613          	addi	a2,s1,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80005200:	2c458593          	addi	a1,a1,708 # 800082c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800082c5>
80005204:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005208:	8bdfd0ef          	jal	ra,80002ac4 <printk>
8000520c:	80008537          	lui	a0,0x80008
80005210:	00040593          	mv	a1,s0
80005214:	f1850513          	addi	a0,a0,-232 # 80007f18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f19>
80005218:	ff000693          	li	a3,-16
8000521c:	00e00613          	li	a2,14
80005220:	8a5fd0ef          	jal	ra,80002ac4 <printk>
80005224:	34500593          	li	a1,837
80005228:	22c48513          	addi	a0,s1,556
8000522c:	8d5fd0ef          	jal	ra,80002b00 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80005230:	800097b7          	lui	a5,0x80009
80005234:	d3c7a783          	lw	a5,-708(a5) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80005238:	02078e63          	beqz	a5,80005274 <z_impl_k_thread_priority_set+0xb0>
8000523c:	800084b7          	lui	s1,0x80008
80005240:	800085b7          	lui	a1,0x80008
80005244:	80008537          	lui	a0,0x80008
80005248:	1c458593          	addi	a1,a1,452 # 800081c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081c5>
8000524c:	34600693          	li	a3,838
80005250:	22c48613          	addi	a2,s1,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80005254:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005258:	86dfd0ef          	jal	ra,80002ac4 <printk>
8000525c:	80008537          	lui	a0,0x80008
80005260:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
80005264:	861fd0ef          	jal	ra,80002ac4 <printk>
80005268:	34600593          	li	a1,838
8000526c:	22c48513          	addi	a0,s1,556
80005270:	891fd0ef          	jal	ra,80002b00 <assert_post_action>

	struct k_thread *thread = (struct k_thread *)tid;

	z_thread_priority_set(thread, prio);
80005274:	00040593          	mv	a1,s0
}
80005278:	00812403          	lw	s0,8(sp)
8000527c:	00c12083          	lw	ra,12(sp)
80005280:	00412483          	lw	s1,4(sp)
	z_thread_priority_set(thread, prio);
80005284:	00090513          	mv	a0,s2
}
80005288:	00012903          	lw	s2,0(sp)
8000528c:	01010113          	addi	sp,sp,16
	z_thread_priority_set(thread, prio);
80005290:	ae9ff06f          	j	80004d78 <z_thread_priority_set>

80005294 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80005294:	fe010113          	addi	sp,sp,-32
80005298:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
8000529c:	80009437          	lui	s0,0x80009
800052a0:	d3c42783          	lw	a5,-708(s0) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
{
800052a4:	00112e23          	sw	ra,28(sp)
800052a8:	00912a23          	sw	s1,20(sp)
800052ac:	01212823          	sw	s2,16(sp)
800052b0:	01312623          	sw	s3,12(sp)
800052b4:	01412423          	sw	s4,8(sp)
800052b8:	01512223          	sw	s5,4(sp)
800052bc:	d3c40413          	addi	s0,s0,-708
	__ASSERT(!z_is_in_isr(), "");
800052c0:	02078e63          	beqz	a5,800052fc <z_impl_k_yield+0x68>
800052c4:	800084b7          	lui	s1,0x80008
800052c8:	800085b7          	lui	a1,0x80008
800052cc:	80008537          	lui	a0,0x80008
800052d0:	1c458593          	addi	a1,a1,452 # 800081c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081c5>
800052d4:	37e00693          	li	a3,894
800052d8:	22c48613          	addi	a2,s1,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
800052dc:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800052e0:	fe4fd0ef          	jal	ra,80002ac4 <printk>
800052e4:	80008537          	lui	a0,0x80008
800052e8:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
800052ec:	fd8fd0ef          	jal	ra,80002ac4 <printk>
800052f0:	37e00593          	li	a1,894
800052f4:	22c48513          	addi	a0,s1,556
800052f8:	809fd0ef          	jal	ra,80002b00 <assert_post_action>
	return thread == _idle_thread;
800052fc:	800087b7          	lui	a5,0x80008

	if (!is_idle(_current)) {
80005300:	00842683          	lw	a3,8(s0)
80005304:	6787a703          	lw	a4,1656(a5) # 80008678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008679>
80005308:	00078a13          	mv	s4,a5
8000530c:	12e68663          	beq	a3,a4,80005438 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005310:	00800913          	li	s2,8
80005314:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005318:	800089b7          	lui	s3,0x80008
8000531c:	6ec98513          	addi	a0,s3,1772 # 800086ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ed>
	key = (mstatus & SOC_MSTATUS_IEN);
80005320:	00897913          	andi	s2,s2,8
80005324:	099000ef          	jal	ra,80005bbc <z_spin_lock_valid>
80005328:	02051e63          	bnez	a0,80005364 <z_impl_k_yield+0xd0>
8000532c:	800084b7          	lui	s1,0x80008
80005330:	800085b7          	lui	a1,0x80008
80005334:	80008537          	lui	a0,0x80008
80005338:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
8000533c:	04e00693          	li	a3,78
80005340:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005344:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005348:	f7cfd0ef          	jal	ra,80002ac4 <printk>
8000534c:	80008537          	lui	a0,0x80008
80005350:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80005354:	f70fd0ef          	jal	ra,80002ac4 <printk>
80005358:	04e00593          	li	a1,78
8000535c:	fc448513          	addi	a0,s1,-60
80005360:	fa0fd0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80005364:	6ec98513          	addi	a0,s3,1772
80005368:	0ad000ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
8000536c:	00842583          	lw	a1,8(s0)
80005370:	02440513          	addi	a0,s0,36
80005374:	e31fe0ef          	jal	ra,800041a4 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80005378:	678a2783          	lw	a5,1656(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
8000537c:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
80005380:	80009a37          	lui	s4,0x80009
80005384:	d60a0a13          	addi	s4,s4,-672 # 80008d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d61>
	__ASSERT_NO_MSG(!is_idle(thread));
80005388:	02f49863          	bne	s1,a5,800053b8 <z_impl_k_yield+0x124>
8000538c:	80008ab7          	lui	s5,0x80008
80005390:	800085b7          	lui	a1,0x80008
80005394:	80008537          	lui	a0,0x80008
80005398:	34458593          	addi	a1,a1,836 # 80008344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008345>
8000539c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800053a0:	27600693          	li	a3,630
800053a4:	22ca8613          	addi	a2,s5,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
800053a8:	f1cfd0ef          	jal	ra,80002ac4 <printk>
800053ac:	27600593          	li	a1,630
800053b0:	22ca8513          	addi	a0,s5,556
800053b4:	f4cfd0ef          	jal	ra,80002b00 <assert_post_action>
	return list->head == list;
800053b8:	02442783          	lw	a5,36(s0)
800053bc:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800053c0:	0b478a63          	beq	a5,s4,80005474 <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800053c4:	0a078863          	beqz	a5,80005474 <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
800053c8:	00e48683          	lb	a3,14(s1)
800053cc:	00e78603          	lb	a2,14(a5)
800053d0:	08c6dc63          	bge	a3,a2,80005468 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
800053d4:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800053d8:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
800053dc:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
800053e0:	00972023          	sw	s1,0(a4)
	successor->prev = node;
800053e4:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
800053e8:	00100513          	li	a0,1
800053ec:	f45fe0ef          	jal	ra,80004330 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800053f0:	6ec98513          	addi	a0,s3,1772
800053f4:	7f0000ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800053f8:	02051e63          	bnez	a0,80005434 <z_impl_k_yield+0x1a0>
800053fc:	80008437          	lui	s0,0x80008
80005400:	800085b7          	lui	a1,0x80008
80005404:	80008537          	lui	a0,0x80008
80005408:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
8000540c:	06100693          	li	a3,97
80005410:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005414:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005418:	eacfd0ef          	jal	ra,80002ac4 <printk>
8000541c:	80008537          	lui	a0,0x80008
80005420:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80005424:	ea0fd0ef          	jal	ra,80002ac4 <printk>
80005428:	06100593          	li	a1,97
8000542c:	fc440513          	addi	a0,s0,-60
80005430:	ed0fd0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005434:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005438:	00800513          	li	a0,8
8000543c:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
80005440:	01812403          	lw	s0,24(sp)
80005444:	01c12083          	lw	ra,28(sp)
80005448:	01412483          	lw	s1,20(sp)
8000544c:	01012903          	lw	s2,16(sp)
80005450:	00c12983          	lw	s3,12(sp)
80005454:	00812a03          	lw	s4,8(sp)
80005458:	00412a83          	lw	s5,4(sp)
8000545c:	00857513          	andi	a0,a0,8
80005460:	02010113          	addi	sp,sp,32
80005464:	dd5fa06f          	j	80000238 <__swap>
	return (node == list->tail) ? NULL : node->next;
80005468:	00e78663          	beq	a5,a4,80005474 <z_impl_k_yield+0x1e0>
8000546c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80005470:	f4079ee3          	bnez	a5,800053cc <z_impl_k_yield+0x138>
	node->prev = list->tail;
80005474:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
80005478:	02842783          	lw	a5,40(s0)
	node->next = list;
8000547c:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
80005480:	0097a023          	sw	s1,0(a5)
	list->tail = node;
80005484:	02942423          	sw	s1,40(s0)
80005488:	f61ff06f          	j	800053e8 <z_impl_k_yield+0x154>

8000548c <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
8000548c:	fd010113          	addi	sp,sp,-48
80005490:	02812423          	sw	s0,40(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
80005494:	80009437          	lui	s0,0x80009
80005498:	d3c42783          	lw	a5,-708(s0) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
{
8000549c:	02912223          	sw	s1,36(sp)
800054a0:	02112623          	sw	ra,44(sp)
800054a4:	03212023          	sw	s2,32(sp)
800054a8:	01312e23          	sw	s3,28(sp)
800054ac:	01412c23          	sw	s4,24(sp)
800054b0:	00050493          	mv	s1,a0
800054b4:	d3c40413          	addi	s0,s0,-708
	__ASSERT(!z_is_in_isr(), "");
800054b8:	02078e63          	beqz	a5,800054f4 <z_impl_k_sleep+0x68>
800054bc:	80008937          	lui	s2,0x80008
800054c0:	800085b7          	lui	a1,0x80008
800054c4:	80008537          	lui	a0,0x80008
800054c8:	1c458593          	addi	a1,a1,452 # 800081c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081c5>
800054cc:	39900693          	li	a3,921
800054d0:	22c90613          	addi	a2,s2,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
800054d4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800054d8:	decfd0ef          	jal	ra,80002ac4 <printk>
800054dc:	80008537          	lui	a0,0x80008
800054e0:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
800054e4:	de0fd0ef          	jal	ra,80002ac4 <printk>
800054e8:	39900593          	li	a1,921
800054ec:	22c90513          	addi	a0,s2,556
800054f0:	e10fd0ef          	jal	ra,80002b00 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
800054f4:	fff00793          	li	a5,-1
800054f8:	1af49463          	bne	s1,a5,800056a0 <z_impl_k_sleep+0x214>
800054fc:	80008937          	lui	s2,0x80008
80005500:	800085b7          	lui	a1,0x80008
80005504:	80008537          	lui	a0,0x80008
80005508:	27858593          	addi	a1,a1,632 # 80008278 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008279>
8000550c:	39a00693          	li	a3,922
80005510:	22c90613          	addi	a2,s2,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
80005514:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005518:	dacfd0ef          	jal	ra,80002ac4 <printk>
8000551c:	80008537          	lui	a0,0x80008
80005520:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
80005524:	da0fd0ef          	jal	ra,80002ac4 <printk>
80005528:	39a00593          	li	a1,922
8000552c:	22c90513          	addi	a0,s2,556
80005530:	dd0fd0ef          	jal	ra,80002b00 <assert_post_action>
80005534:	00a00593          	li	a1,10
80005538:	00948513          	addi	a0,s1,9
8000553c:	c0cfb0ef          	jal	ra,80000948 <__divsi3>
	if (duration == 0) {
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80005540:	00150993          	addi	s3,a0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80005544:	424010ef          	jal	ra,80006968 <z_tick_get_32>
80005548:	00a98933          	add	s2,s3,a0

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
8000554c:	00012623          	sw	zero,12(sp)
80005550:	00800493          	li	s1,8
80005554:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005558:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
8000555c:	0084f493          	andi	s1,s1,8
80005560:	65c000ef          	jal	ra,80005bbc <z_spin_lock_valid>
80005564:	02051e63          	bnez	a0,800055a0 <z_impl_k_sleep+0x114>
80005568:	80008a37          	lui	s4,0x80008
8000556c:	800085b7          	lui	a1,0x80008
80005570:	80008537          	lui	a0,0x80008
80005574:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80005578:	04e00693          	li	a3,78
8000557c:	fc4a0613          	addi	a2,s4,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005580:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005584:	d40fd0ef          	jal	ra,80002ac4 <printk>
80005588:	80008537          	lui	a0,0x80008
8000558c:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80005590:	d34fd0ef          	jal	ra,80002ac4 <printk>
80005594:	04e00593          	li	a1,78
80005598:	fc4a0513          	addi	a0,s4,-60
8000559c:	d64fd0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
800055a0:	00c10513          	addi	a0,sp,12
800055a4:	670000ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
800055a8:	00842503          	lw	a0,8(s0)
800055ac:	cd4ff0ef          	jal	ra,80004a80 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800055b0:	00842503          	lw	a0,8(s0)
800055b4:	800045b7          	lui	a1,0x80004
800055b8:	00098613          	mv	a2,s3
800055bc:	01850513          	addi	a0,a0,24
800055c0:	70858593          	addi	a1,a1,1800 # 80004708 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004709>
800055c4:	341000ef          	jal	ra,80006104 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
800055c8:	00842703          	lw	a4,8(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800055cc:	00c10513          	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
800055d0:	00d74783          	lbu	a5,13(a4)
800055d4:	0107e793          	ori	a5,a5,16
800055d8:	00f706a3          	sb	a5,13(a4)
800055dc:	608000ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800055e0:	02051e63          	bnez	a0,8000561c <z_impl_k_sleep+0x190>
800055e4:	800089b7          	lui	s3,0x80008
800055e8:	800085b7          	lui	a1,0x80008
800055ec:	80008537          	lui	a0,0x80008
800055f0:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800055f4:	07800693          	li	a3,120
800055f8:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800055fc:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005600:	cc4fd0ef          	jal	ra,80002ac4 <printk>
80005604:	80008537          	lui	a0,0x80008
80005608:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
8000560c:	cb8fd0ef          	jal	ra,80002ac4 <printk>
80005610:	07800593          	li	a1,120
80005614:	fc498513          	addi	a0,s3,-60
80005618:	ce8fd0ef          	jal	ra,80002b00 <assert_post_action>
8000561c:	00048513          	mv	a0,s1
80005620:	c19fa0ef          	jal	ra,80000238 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
80005624:	00842783          	lw	a5,8(s0)
80005628:	00d7c783          	lbu	a5,13(a5)
8000562c:	0107f793          	andi	a5,a5,16
80005630:	02078e63          	beqz	a5,8000566c <z_impl_k_sleep+0x1e0>
80005634:	80008437          	lui	s0,0x80008
80005638:	800085b7          	lui	a1,0x80008
8000563c:	80008537          	lui	a0,0x80008
80005640:	28c58593          	addi	a1,a1,652 # 8000828c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000828d>
80005644:	3b700693          	li	a3,951
80005648:	22c40613          	addi	a2,s0,556 # 8000822c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000822d>
8000564c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005650:	c74fd0ef          	jal	ra,80002ac4 <printk>
80005654:	80008537          	lui	a0,0x80008
80005658:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
8000565c:	c68fd0ef          	jal	ra,80002ac4 <printk>
80005660:	3b700593          	li	a1,951
80005664:	22c40513          	addi	a0,s0,556
80005668:	c98fd0ef          	jal	ra,80002b00 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
8000566c:	2fc010ef          	jal	ra,80006968 <z_tick_get_32>
80005670:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
80005674:	00000493          	li	s1,0
	if (ticks > 0) {
80005678:	02a05863          	blez	a0,800056a8 <z_impl_k_sleep+0x21c>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000567c:	3e800613          	li	a2,1000
80005680:	00000693          	li	a3,0
80005684:	41f55593          	srai	a1,a0,0x1f
80005688:	a30fb0ef          	jal	ra,800008b8 <__muldi3>
8000568c:	06400613          	li	a2,100
80005690:	00000693          	li	a3,0
80005694:	c2dfa0ef          	jal	ra,800002c0 <__udivdi3>
80005698:	00050493          	mv	s1,a0
		return __ticks_to_ms(ticks);
8000569c:	00c0006f          	j	800056a8 <z_impl_k_sleep+0x21c>
	if (duration == 0) {
800056a0:	e8049ae3          	bnez	s1,80005534 <z_impl_k_sleep+0xa8>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800056a4:	bf1ff0ef          	jal	ra,80005294 <z_impl_k_yield>
}
800056a8:	02c12083          	lw	ra,44(sp)
800056ac:	02812403          	lw	s0,40(sp)
800056b0:	00048513          	mv	a0,s1
800056b4:	02012903          	lw	s2,32(sp)
800056b8:	02412483          	lw	s1,36(sp)
800056bc:	01c12983          	lw	s3,28(sp)
800056c0:	01812a03          	lw	s4,24(sp)
800056c4:	03010113          	addi	sp,sp,48
800056c8:	00008067          	ret

800056cc <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800056cc:	800097b7          	lui	a5,0x80009
800056d0:	d447a503          	lw	a0,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
800056d4:	00008067          	ret

800056d8 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800056d8:	fe010113          	addi	sp,sp,-32
800056dc:	00812c23          	sw	s0,24(sp)
800056e0:	00912a23          	sw	s1,20(sp)
800056e4:	01212823          	sw	s2,16(sp)
800056e8:	00112e23          	sw	ra,28(sp)
800056ec:	01312623          	sw	s3,12(sp)
800056f0:	00050413          	mv	s0,a0
800056f4:	00058913          	mv	s2,a1
800056f8:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
800056fc:	02061e63          	bnez	a2,80005738 <z_impl_k_sem_init+0x60>
80005700:	800089b7          	lui	s3,0x80008
80005704:	800085b7          	lui	a1,0x80008
80005708:	80008537          	lui	a0,0x80008
8000570c:	36858593          	addi	a1,a1,872 # 80008368 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008369>
80005710:	04600693          	li	a3,70
80005714:	35898613          	addi	a2,s3,856 # 80008358 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008359>
80005718:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
8000571c:	ba8fd0ef          	jal	ra,80002ac4 <printk>
80005720:	80008537          	lui	a0,0x80008
80005724:	37450513          	addi	a0,a0,884 # 80008374 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008375>
80005728:	b9cfd0ef          	jal	ra,80002ac4 <printk>
8000572c:	04600593          	li	a1,70
80005730:	35898513          	addi	a0,s3,856
80005734:	bccfd0ef          	jal	ra,80002b00 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80005738:	0324fe63          	bgeu	s1,s2,80005774 <z_impl_k_sem_init+0x9c>
8000573c:	800089b7          	lui	s3,0x80008
80005740:	800085b7          	lui	a1,0x80008
80005744:	80008537          	lui	a0,0x80008
80005748:	38c58593          	addi	a1,a1,908 # 8000838c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000838d>
8000574c:	04700693          	li	a3,71
80005750:	35898613          	addi	a2,s3,856 # 80008358 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008359>
80005754:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005758:	b6cfd0ef          	jal	ra,80002ac4 <printk>
8000575c:	80008537          	lui	a0,0x80008
80005760:	3a450513          	addi	a0,a0,932 # 800083a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800083a5>
80005764:	b60fd0ef          	jal	ra,80002ac4 <printk>
80005768:	04700593          	li	a1,71
8000576c:	35898513          	addi	a0,s3,856
80005770:	b90fd0ef          	jal	ra,80002b00 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80005774:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80005778:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
8000577c:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80005780:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80005784:	01c12083          	lw	ra,28(sp)
80005788:	01812403          	lw	s0,24(sp)
8000578c:	01412483          	lw	s1,20(sp)
80005790:	01012903          	lw	s2,16(sp)
80005794:	00c12983          	lw	s3,12(sp)
80005798:	02010113          	addi	sp,sp,32
8000579c:	00008067          	ret

800057a0 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800057a0:	fe010113          	addi	sp,sp,-32
800057a4:	00912a23          	sw	s1,20(sp)
800057a8:	01312623          	sw	s3,12(sp)
800057ac:	00112e23          	sw	ra,28(sp)
800057b0:	00812c23          	sw	s0,24(sp)
800057b4:	01212823          	sw	s2,16(sp)
800057b8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800057bc:	00800493          	li	s1,8
800057c0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800057c4:	80008437          	lui	s0,0x80008
800057c8:	6f840513          	addi	a0,s0,1784 # 800086f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086f9>
	key = (mstatus & SOC_MSTATUS_IEN);
800057cc:	0084f493          	andi	s1,s1,8
800057d0:	3ec000ef          	jal	ra,80005bbc <z_spin_lock_valid>
800057d4:	02051e63          	bnez	a0,80005810 <z_impl_k_sem_give+0x70>
800057d8:	80008937          	lui	s2,0x80008
800057dc:	800085b7          	lui	a1,0x80008
800057e0:	80008537          	lui	a0,0x80008
800057e4:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
800057e8:	04e00693          	li	a3,78
800057ec:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800057f0:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800057f4:	ad0fd0ef          	jal	ra,80002ac4 <printk>
800057f8:	80008537          	lui	a0,0x80008
800057fc:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80005800:	ac4fd0ef          	jal	ra,80002ac4 <printk>
80005804:	04e00593          	li	a1,78
80005808:	fc490513          	addi	a0,s2,-60
8000580c:	af4fd0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80005810:	6f840513          	addi	a0,s0,1784
80005814:	400000ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80005818:	00098513          	mv	a0,s3
8000581c:	f68ff0ef          	jal	ra,80004f84 <z_unpend_first_thread>
80005820:	00050913          	mv	s2,a0
	if (thread != NULL) {
80005824:	04050263          	beqz	a0,80005868 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005828:	00d54783          	lbu	a5,13(a0)
8000582c:	01f7f793          	andi	a5,a5,31
80005830:	00079863          	bnez	a5,80005840 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80005834:	01852783          	lw	a5,24(a0)
80005838:	00079463          	bnez	a5,80005840 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
8000583c:	d3dfe0ef          	jal	ra,80004578 <z_add_thread_to_ready_q>
80005840:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80005844:	6f840513          	addi	a0,s0,1784
}
80005848:	01812403          	lw	s0,24(sp)
8000584c:	01c12083          	lw	ra,28(sp)
80005850:	01012903          	lw	s2,16(sp)
80005854:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80005858:	00048593          	mv	a1,s1
}
8000585c:	01412483          	lw	s1,20(sp)
80005860:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80005864:	ec8fe06f          	j	80003f2c <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80005868:	0089a703          	lw	a4,8(s3)
8000586c:	00c9a783          	lw	a5,12(s3)
80005870:	40e787b3          	sub	a5,a5,a4
80005874:	00f037b3          	snez	a5,a5
80005878:	00e787b3          	add	a5,a5,a4
8000587c:	00f9a423          	sw	a5,8(s3)
80005880:	fc5ff06f          	j	80005844 <z_impl_k_sem_give+0xa4>

80005884 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80005884:	800097b7          	lui	a5,0x80009
80005888:	d3c7a783          	lw	a5,-708(a5) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
{
8000588c:	fe010113          	addi	sp,sp,-32
80005890:	01212823          	sw	s2,16(sp)
80005894:	01312623          	sw	s3,12(sp)
80005898:	00112e23          	sw	ra,28(sp)
8000589c:	00812c23          	sw	s0,24(sp)
800058a0:	00912a23          	sw	s1,20(sp)
800058a4:	01412423          	sw	s4,8(sp)
800058a8:	00050913          	mv	s2,a0
800058ac:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800058b0:	04078063          	beqz	a5,800058f0 <z_impl_k_sem_take+0x6c>
800058b4:	02058e63          	beqz	a1,800058f0 <z_impl_k_sem_take+0x6c>
800058b8:	80008437          	lui	s0,0x80008
800058bc:	800085b7          	lui	a1,0x80008
800058c0:	80008537          	lui	a0,0x80008
800058c4:	3cc58593          	addi	a1,a1,972 # 800083cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800083cd>
800058c8:	08c00693          	li	a3,140
800058cc:	35840613          	addi	a2,s0,856 # 80008358 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008359>
800058d0:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800058d4:	9f0fd0ef          	jal	ra,80002ac4 <printk>
800058d8:	80008537          	lui	a0,0x80008
800058dc:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
800058e0:	9e4fd0ef          	jal	ra,80002ac4 <printk>
800058e4:	08c00593          	li	a1,140
800058e8:	35840513          	addi	a0,s0,856
800058ec:	a14fd0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800058f0:	00800413          	li	s0,8
800058f4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800058f8:	800084b7          	lui	s1,0x80008
800058fc:	6f848513          	addi	a0,s1,1784 # 800086f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086f9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005900:	00847413          	andi	s0,s0,8
80005904:	2b8000ef          	jal	ra,80005bbc <z_spin_lock_valid>
80005908:	02051e63          	bnez	a0,80005944 <z_impl_k_sem_take+0xc0>
8000590c:	80008a37          	lui	s4,0x80008
80005910:	800085b7          	lui	a1,0x80008
80005914:	80008537          	lui	a0,0x80008
80005918:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
8000591c:	04e00693          	li	a3,78
80005920:	fc4a0613          	addi	a2,s4,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005924:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005928:	99cfd0ef          	jal	ra,80002ac4 <printk>
8000592c:	80008537          	lui	a0,0x80008
80005930:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80005934:	990fd0ef          	jal	ra,80002ac4 <printk>
80005938:	04e00593          	li	a1,78
8000593c:	fc4a0513          	addi	a0,s4,-60
80005940:	9c0fd0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80005944:	6f848513          	addi	a0,s1,1784
80005948:	2cc000ef          	jal	ra,80005c14 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
8000594c:	00892783          	lw	a5,8(s2)
80005950:	06078c63          	beqz	a5,800059c8 <z_impl_k_sem_take+0x144>
		sem->count--;
80005954:	fff78793          	addi	a5,a5,-1
80005958:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000595c:	6f848513          	addi	a0,s1,1784
80005960:	284000ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80005964:	02051e63          	bnez	a0,800059a0 <z_impl_k_sem_take+0x11c>
80005968:	800084b7          	lui	s1,0x80008
8000596c:	800085b7          	lui	a1,0x80008
80005970:	80008537          	lui	a0,0x80008
80005974:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80005978:	06100693          	li	a3,97
8000597c:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005980:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005984:	940fd0ef          	jal	ra,80002ac4 <printk>
80005988:	80008537          	lui	a0,0x80008
8000598c:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80005990:	934fd0ef          	jal	ra,80002ac4 <printk>
80005994:	06100593          	li	a1,97
80005998:	fc448513          	addi	a0,s1,-60
8000599c:	964fd0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800059a0:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
800059a4:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800059a8:	01c12083          	lw	ra,28(sp)
800059ac:	01812403          	lw	s0,24(sp)
800059b0:	01412483          	lw	s1,20(sp)
800059b4:	01012903          	lw	s2,16(sp)
800059b8:	00c12983          	lw	s3,12(sp)
800059bc:	00812a03          	lw	s4,8(sp)
800059c0:	02010113          	addi	sp,sp,32
800059c4:	00008067          	ret
	if (timeout == K_NO_WAIT) {
800059c8:	04099a63          	bnez	s3,80005a1c <z_impl_k_sem_take+0x198>
800059cc:	6f848513          	addi	a0,s1,1784
800059d0:	214000ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800059d4:	02051e63          	bnez	a0,80005a10 <z_impl_k_sem_take+0x18c>
800059d8:	800084b7          	lui	s1,0x80008
800059dc:	800085b7          	lui	a1,0x80008
800059e0:	80008537          	lui	a0,0x80008
800059e4:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800059e8:	06100693          	li	a3,97
800059ec:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800059f0:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800059f4:	8d0fd0ef          	jal	ra,80002ac4 <printk>
800059f8:	80008537          	lui	a0,0x80008
800059fc:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80005a00:	8c4fd0ef          	jal	ra,80002ac4 <printk>
80005a04:	06100593          	li	a1,97
80005a08:	fc448513          	addi	a0,s1,-60
80005a0c:	8f4fd0ef          	jal	ra,80002b00 <assert_post_action>
80005a10:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80005a14:	ff000513          	li	a0,-16
80005a18:	f91ff06f          	j	800059a8 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005a1c:	00040593          	mv	a1,s0
}
80005a20:	01812403          	lw	s0,24(sp)
80005a24:	01c12083          	lw	ra,28(sp)
80005a28:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005a2c:	00098693          	mv	a3,s3
80005a30:	00090613          	mv	a2,s2
}
80005a34:	00c12983          	lw	s3,12(sp)
80005a38:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005a3c:	6f848513          	addi	a0,s1,1784
}
80005a40:	01412483          	lw	s1,20(sp)
80005a44:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005a48:	aa8ff06f          	j	80004cf0 <z_pend_curr>

80005a4c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005a4c:	00d54783          	lbu	a5,13(a0)
80005a50:	01f7f793          	andi	a5,a5,31
80005a54:	00079863          	bnez	a5,80005a64 <z_is_thread_ready+0x18>
80005a58:	01852503          	lw	a0,24(a0)
80005a5c:	00153513          	seqz	a0,a0
80005a60:	00008067          	ret
80005a64:	00000513          	li	a0,0
}
80005a68:	00008067          	ret

80005a6c <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80005a6c:	800097b7          	lui	a5,0x80009
80005a70:	d3c7a503          	lw	a0,-708(a5) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
}
80005a74:	00a03533          	snez	a0,a0
80005a78:	00008067          	ret

80005a7c <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80005a7c:	800097b7          	lui	a5,0x80009
80005a80:	d447a783          	lw	a5,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
80005a84:	00c7c503          	lbu	a0,12(a5)
}
80005a88:	00157513          	andi	a0,a0,1
80005a8c:	00008067          	ret

80005a90 <z_impl_k_busy_wait>:
void z_impl_k_busy_wait(u32_t usec_to_wait)
{
#if !defined(CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT)
	/* use 64-bit math to prevent overflow when multiplying */
	u32_t cycles_to_wait = (u32_t)(
		(u64_t)usec_to_wait *
80005a90:	00b72637          	lui	a2,0xb72
{
80005a94:	ff010113          	addi	sp,sp,-16
		(u64_t)usec_to_wait *
80005a98:	b0060613          	addi	a2,a2,-1280 # b71b00 <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC>
80005a9c:	00000693          	li	a3,0
80005aa0:	00000593          	li	a1,0
{
80005aa4:	00112623          	sw	ra,12(sp)
80005aa8:	00812423          	sw	s0,8(sp)
80005aac:	00912223          	sw	s1,4(sp)
		(u64_t)usec_to_wait *
80005ab0:	e09fa0ef          	jal	ra,800008b8 <__muldi3>
		(u64_t)sys_clock_hw_cycles_per_sec() /
80005ab4:	000f4637          	lui	a2,0xf4
80005ab8:	24060613          	addi	a2,a2,576 # f4240 <CONFIG_RISCV_RAM_SIZE+0xb4240>
80005abc:	00000693          	li	a3,0
80005ac0:	801fa0ef          	jal	ra,800002c0 <__udivdi3>
80005ac4:	00050413          	mv	s0,a0
		(u64_t)USEC_PER_SEC
	);
	u32_t start_cycles = k_cycle_get_32();
80005ac8:	dbcfd0ef          	jal	ra,80003084 <z_timer_cycle_get_32>
80005acc:	00050493          	mv	s1,a0

	for (;;) {
		u32_t current_cycles = k_cycle_get_32();
80005ad0:	db4fd0ef          	jal	ra,80003084 <z_timer_cycle_get_32>

		/* this handles the rollover on an unsigned 32-bit value */
		if ((current_cycles - start_cycles) >= cycles_to_wait) {
80005ad4:	40950533          	sub	a0,a0,s1
80005ad8:	fe856ce3          	bltu	a0,s0,80005ad0 <z_impl_k_busy_wait+0x40>
		}
	}
#else
	z_arch_busy_wait(usec_to_wait);
#endif /* CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT */
}
80005adc:	00c12083          	lw	ra,12(sp)
80005ae0:	00812403          	lw	s0,8(sp)
80005ae4:	00412483          	lw	s1,4(sp)
80005ae8:	01010113          	addi	sp,sp,16
80005aec:	00008067          	ret

80005af0 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80005af0:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005af4:	02012303          	lw	t1,32(sp)
{
80005af8:	00812c23          	sw	s0,24(sp)
80005afc:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005b00:	00612023          	sw	t1,0(sp)
{
80005b04:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005b08:	844fc0ef          	jal	ra,80001b4c <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80005b0c:	800097b7          	lui	a5,0x80009
80005b10:	d447a783          	lw	a5,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
	sys_trace_thread_create(new_thread);
}
80005b14:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80005b18:	0687a783          	lw	a5,104(a5)
80005b1c:	06f42423          	sw	a5,104(s0)
}
80005b20:	01812403          	lw	s0,24(sp)
80005b24:	02010113          	addi	sp,sp,32
80005b28:	00008067          	ret

80005b2c <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80005b2c:	06052783          	lw	a5,96(a0)
{
80005b30:	ff010113          	addi	sp,sp,-16
80005b34:	00812423          	sw	s0,8(sp)
80005b38:	00112623          	sw	ra,12(sp)
80005b3c:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80005b40:	00078463          	beqz	a5,80005b48 <z_thread_single_abort+0x1c>
		thread->fn_abort();
80005b44:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80005b48:	00040513          	mv	a0,s0
80005b4c:	f01ff0ef          	jal	ra,80005a4c <z_is_thread_ready>
80005b50:	02050463          	beqz	a0,80005b78 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80005b54:	00040513          	mv	a0,s0
80005b58:	f29fe0ef          	jal	ra,80004a80 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80005b5c:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80005b60:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80005b64:	0087e793          	ori	a5,a5,8
80005b68:	00f406a3          	sb	a5,13(s0)
}
80005b6c:	00812403          	lw	s0,8(sp)
80005b70:	01010113          	addi	sp,sp,16
80005b74:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80005b78:	00d44783          	lbu	a5,13(s0)
80005b7c:	0027f793          	andi	a5,a5,2
80005b80:	00078663          	beqz	a5,80005b8c <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80005b84:	00040513          	mv	a0,s0
80005b88:	aa8fe0ef          	jal	ra,80003e30 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80005b8c:	01842783          	lw	a5,24(s0)
80005b90:	fc0786e3          	beqz	a5,80005b5c <z_thread_single_abort+0x30>
	return z_abort_timeout(&thread->base.timeout);
80005b94:	01840513          	addi	a0,s0,24
80005b98:	798000ef          	jal	ra,80006330 <z_abort_timeout>
80005b9c:	fc1ff06f          	j	80005b5c <z_thread_single_abort+0x30>

80005ba0 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80005ba0:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80005ba4:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80005ba8:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80005bac:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80005bb0:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80005bb4:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80005bb8:	00008067          	ret

80005bbc <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80005bbc:	00052503          	lw	a0,0(a0)
80005bc0:	00050e63          	beqz	a0,80005bdc <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80005bc4:	800097b7          	lui	a5,0x80009
80005bc8:	d507c783          	lbu	a5,-688(a5) # 80008d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d51>
80005bcc:	00357513          	andi	a0,a0,3
80005bd0:	40f50533          	sub	a0,a0,a5
80005bd4:	00a03533          	snez	a0,a0
80005bd8:	00008067          	ret
			return false;
		}
	}
	return true;
80005bdc:	00100513          	li	a0,1
}
80005be0:	00008067          	ret

80005be4 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80005be4:	800097b7          	lui	a5,0x80009
80005be8:	d3c78793          	addi	a5,a5,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80005bec:	0147c703          	lbu	a4,20(a5)
80005bf0:	0087a783          	lw	a5,8(a5)
80005bf4:	00e7e7b3          	or	a5,a5,a4
80005bf8:	00052703          	lw	a4,0(a0)
80005bfc:	00f71863          	bne	a4,a5,80005c0c <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80005c00:	00052023          	sw	zero,0(a0)
	return true;
80005c04:	00100513          	li	a0,1
80005c08:	00008067          	ret
		return false;
80005c0c:	00000513          	li	a0,0
}
80005c10:	00008067          	ret

80005c14 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80005c14:	800097b7          	lui	a5,0x80009
80005c18:	d3c78793          	addi	a5,a5,-708 # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
80005c1c:	0147c703          	lbu	a4,20(a5)
80005c20:	0087a783          	lw	a5,8(a5)
80005c24:	00e7e7b3          	or	a5,a5,a4
80005c28:	00f52023          	sw	a5,0(a0)
}
80005c2c:	00008067          	ret

80005c30 <z_impl_k_thread_start>:
{
80005c30:	fe010113          	addi	sp,sp,-32
80005c34:	00812c23          	sw	s0,24(sp)
80005c38:	01212823          	sw	s2,16(sp)
80005c3c:	00112e23          	sw	ra,28(sp)
80005c40:	00912a23          	sw	s1,20(sp)
80005c44:	01312623          	sw	s3,12(sp)
80005c48:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005c4c:	00800413          	li	s0,8
80005c50:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005c54:	800084b7          	lui	s1,0x80008
80005c58:	6fc48513          	addi	a0,s1,1788 # 800086fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086fd>
	key = (mstatus & SOC_MSTATUS_IEN);
80005c5c:	00847413          	andi	s0,s0,8
80005c60:	f5dff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
80005c64:	02051e63          	bnez	a0,80005ca0 <z_impl_k_thread_start+0x70>
80005c68:	800089b7          	lui	s3,0x80008
80005c6c:	800085b7          	lui	a1,0x80008
80005c70:	80008537          	lui	a0,0x80008
80005c74:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80005c78:	04e00693          	li	a3,78
80005c7c:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005c80:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005c84:	e41fc0ef          	jal	ra,80002ac4 <printk>
80005c88:	80008537          	lui	a0,0x80008
80005c8c:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80005c90:	e35fc0ef          	jal	ra,80002ac4 <printk>
80005c94:	04e00593          	li	a1,78
80005c98:	fc498513          	addi	a0,s3,-60
80005c9c:	e65fc0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80005ca0:	6fc48513          	addi	a0,s1,1788
80005ca4:	f71ff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80005ca8:	00d94783          	lbu	a5,13(s2)
80005cac:	0047f713          	andi	a4,a5,4
80005cb0:	06071463          	bnez	a4,80005d18 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005cb4:	6fc48513          	addi	a0,s1,1788
80005cb8:	f2dff0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80005cbc:	02051e63          	bnez	a0,80005cf8 <z_impl_k_thread_start+0xc8>
80005cc0:	800084b7          	lui	s1,0x80008
80005cc4:	800085b7          	lui	a1,0x80008
80005cc8:	80008537          	lui	a0,0x80008
80005ccc:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80005cd0:	06100693          	li	a3,97
80005cd4:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005cd8:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005cdc:	de9fc0ef          	jal	ra,80002ac4 <printk>
80005ce0:	80008537          	lui	a0,0x80008
80005ce4:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80005ce8:	dddfc0ef          	jal	ra,80002ac4 <printk>
80005cec:	06100593          	li	a1,97
80005cf0:	fc448513          	addi	a0,s1,-60
80005cf4:	e0dfc0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005cf8:	30042473          	csrrs	s0,mstatus,s0
}
80005cfc:	01c12083          	lw	ra,28(sp)
80005d00:	01812403          	lw	s0,24(sp)
80005d04:	01412483          	lw	s1,20(sp)
80005d08:	01012903          	lw	s2,16(sp)
80005d0c:	00c12983          	lw	s3,12(sp)
80005d10:	02010113          	addi	sp,sp,32
80005d14:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80005d18:	ffb7f793          	andi	a5,a5,-5
80005d1c:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80005d20:	00090513          	mv	a0,s2
80005d24:	d29ff0ef          	jal	ra,80005a4c <z_is_thread_ready>
80005d28:	00050663          	beqz	a0,80005d34 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80005d2c:	00090513          	mv	a0,s2
80005d30:	849fe0ef          	jal	ra,80004578 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80005d34:	00040593          	mv	a1,s0
}
80005d38:	01812403          	lw	s0,24(sp)
80005d3c:	01c12083          	lw	ra,28(sp)
80005d40:	01012903          	lw	s2,16(sp)
80005d44:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80005d48:	6fc48513          	addi	a0,s1,1788
}
80005d4c:	01412483          	lw	s1,20(sp)
80005d50:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80005d54:	9d8fe06f          	j	80003f2c <z_reschedule>

80005d58 <schedule_new_thread>:
	if (delay == 0) {
80005d58:	00059463          	bnez	a1,80005d60 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80005d5c:	ed5ff06f          	j	80005c30 <z_impl_k_thread_start>
{
80005d60:	ff010113          	addi	sp,sp,-16
80005d64:	00812423          	sw	s0,8(sp)
80005d68:	00050413          	mv	s0,a0
80005d6c:	00058513          	mv	a0,a1
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005d70:	00950513          	addi	a0,a0,9
80005d74:	00a00593          	li	a1,10
80005d78:	00112623          	sw	ra,12(sp)
80005d7c:	bcdfa0ef          	jal	ra,80000948 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80005d80:	00150613          	addi	a2,a0,1
80005d84:	01840513          	addi	a0,s0,24
}
80005d88:	00812403          	lw	s0,8(sp)
80005d8c:	00c12083          	lw	ra,12(sp)
80005d90:	800045b7          	lui	a1,0x80004
80005d94:	70858593          	addi	a1,a1,1800 # 80004708 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004709>
80005d98:	01010113          	addi	sp,sp,16
80005d9c:	3680006f          	j	80006104 <z_add_timeout>

80005da0 <z_impl_k_thread_create>:
{
80005da0:	fc010113          	addi	sp,sp,-64
80005da4:	03512223          	sw	s5,36(sp)
80005da8:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80005dac:	800096b7          	lui	a3,0x80009
80005db0:	d3c6a683          	lw	a3,-708(a3) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
{
80005db4:	02812c23          	sw	s0,56(sp)
80005db8:	02912a23          	sw	s1,52(sp)
80005dbc:	03312623          	sw	s3,44(sp)
80005dc0:	03412423          	sw	s4,40(sp)
80005dc4:	02112e23          	sw	ra,60(sp)
80005dc8:	03212823          	sw	s2,48(sp)
80005dcc:	00050413          	mv	s0,a0
80005dd0:	00058993          	mv	s3,a1
80005dd4:	00060a13          	mv	s4,a2
80005dd8:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80005ddc:	04068e63          	beqz	a3,80005e38 <z_impl_k_thread_create+0x98>
80005de0:	80008937          	lui	s2,0x80008
80005de4:	800085b7          	lui	a1,0x80008
80005de8:	80008537          	lui	a0,0x80008
80005dec:	1b200693          	li	a3,434
80005df0:	40090613          	addi	a2,s2,1024 # 80008400 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008401>
80005df4:	1c458593          	addi	a1,a1,452 # 800081c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800081c5>
80005df8:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005dfc:	01112e23          	sw	a7,28(sp)
80005e00:	01012c23          	sw	a6,24(sp)
80005e04:	00f12a23          	sw	a5,20(sp)
80005e08:	00e12823          	sw	a4,16(sp)
80005e0c:	cb9fc0ef          	jal	ra,80002ac4 <printk>
80005e10:	80008537          	lui	a0,0x80008
80005e14:	41450513          	addi	a0,a0,1044 # 80008414 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008415>
80005e18:	cadfc0ef          	jal	ra,80002ac4 <printk>
80005e1c:	1b200593          	li	a1,434
80005e20:	40090513          	addi	a0,s2,1024
80005e24:	cddfc0ef          	jal	ra,80002b00 <assert_post_action>
80005e28:	01c12883          	lw	a7,28(sp)
80005e2c:	01812803          	lw	a6,24(sp)
80005e30:	01412783          	lw	a5,20(sp)
80005e34:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80005e38:	04012683          	lw	a3,64(sp)
80005e3c:	00012223          	sw	zero,4(sp)
80005e40:	000a0613          	mv	a2,s4
80005e44:	00d12023          	sw	a3,0(sp)
80005e48:	00098593          	mv	a1,s3
80005e4c:	000a8693          	mv	a3,s5
80005e50:	00040513          	mv	a0,s0
80005e54:	c9dff0ef          	jal	ra,80005af0 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80005e58:	fff00793          	li	a5,-1
80005e5c:	00f48863          	beq	s1,a5,80005e6c <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80005e60:	00048593          	mv	a1,s1
80005e64:	00040513          	mv	a0,s0
80005e68:	ef1ff0ef          	jal	ra,80005d58 <schedule_new_thread>
}
80005e6c:	00040513          	mv	a0,s0
80005e70:	03c12083          	lw	ra,60(sp)
80005e74:	03812403          	lw	s0,56(sp)
80005e78:	03412483          	lw	s1,52(sp)
80005e7c:	03012903          	lw	s2,48(sp)
80005e80:	02c12983          	lw	s3,44(sp)
80005e84:	02812a03          	lw	s4,40(sp)
80005e88:	02412a83          	lw	s5,36(sp)
80005e8c:	04010113          	addi	sp,sp,64
80005e90:	00008067          	ret

80005e94 <z_init_static_threads>:
{
80005e94:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80005e98:	800087b7          	lui	a5,0x80008
{
80005e9c:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005ea0:	80008937          	lui	s2,0x80008
{
80005ea4:	00812c23          	sw	s0,24(sp)
80005ea8:	00912a23          	sw	s1,20(sp)
80005eac:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005eb0:	6ac78413          	addi	s0,a5,1708 # 800086ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ad>
80005eb4:	6ac78493          	addi	s1,a5,1708
80005eb8:	6ac90913          	addi	s2,s2,1708 # 800086ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ad>
80005ebc:	03246663          	bltu	s0,s2,80005ee8 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80005ec0:	00048413          	mv	s0,s1
	k_sched_lock();
80005ec4:	968fe0ef          	jal	ra,8000402c <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80005ec8:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80005ecc:	07246063          	bltu	s0,s2,80005f2c <z_init_static_threads+0x98>
}
80005ed0:	01812403          	lw	s0,24(sp)
80005ed4:	01c12083          	lw	ra,28(sp)
80005ed8:	01412483          	lw	s1,20(sp)
80005edc:	01012903          	lw	s2,16(sp)
80005ee0:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80005ee4:	d14fe06f          	j	800043f8 <k_sched_unlock>
		z_setup_new_thread(
80005ee8:	02c42783          	lw	a5,44(s0)
80005eec:	00f12223          	sw	a5,4(sp)
80005ef0:	02042783          	lw	a5,32(s0)
80005ef4:	00f12023          	sw	a5,0(sp)
80005ef8:	01442783          	lw	a5,20(s0)
80005efc:	01c42883          	lw	a7,28(s0)
80005f00:	01842803          	lw	a6,24(s0)
80005f04:	01042703          	lw	a4,16(s0)
80005f08:	00c42683          	lw	a3,12(s0)
80005f0c:	00842603          	lw	a2,8(s0)
80005f10:	00442583          	lw	a1,4(s0)
80005f14:	00042503          	lw	a0,0(s0)
80005f18:	bd9ff0ef          	jal	ra,80005af0 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80005f1c:	00042783          	lw	a5,0(s0)
80005f20:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80005f24:	03040413          	addi	s0,s0,48
80005f28:	f95ff06f          	j	80005ebc <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80005f2c:	02442583          	lw	a1,36(s0)
80005f30:	00958663          	beq	a1,s1,80005f3c <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80005f34:	00042503          	lw	a0,0(s0)
80005f38:	e21ff0ef          	jal	ra,80005d58 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80005f3c:	03040413          	addi	s0,s0,48
80005f40:	f8dff06f          	j	80005ecc <z_init_static_threads+0x38>

80005f44 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80005f44:	fe010113          	addi	sp,sp,-32
80005f48:	00812c23          	sw	s0,24(sp)
80005f4c:	00912a23          	sw	s1,20(sp)
80005f50:	00112e23          	sw	ra,28(sp)
80005f54:	01212823          	sw	s2,16(sp)
80005f58:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80005f5c:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005f60:	00800413          	li	s0,8
80005f64:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005f68:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80005f6c:	00847413          	andi	s0,s0,8
80005f70:	c4dff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
80005f74:	02051e63          	bnez	a0,80005fb0 <z_impl_k_thread_abort+0x6c>
80005f78:	80008937          	lui	s2,0x80008
80005f7c:	800085b7          	lui	a1,0x80008
80005f80:	80008537          	lui	a0,0x80008
80005f84:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80005f88:	04e00693          	li	a3,78
80005f8c:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80005f90:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005f94:	b31fc0ef          	jal	ra,80002ac4 <printk>
80005f98:	80008537          	lui	a0,0x80008
80005f9c:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80005fa0:	b25fc0ef          	jal	ra,80002ac4 <printk>
80005fa4:	04e00593          	li	a1,78
80005fa8:	fc490513          	addi	a0,s2,-60
80005fac:	b55fc0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80005fb0:	00c10513          	addi	a0,sp,12
80005fb4:	c61ff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80005fb8:	00c4c783          	lbu	a5,12(s1)
80005fbc:	0017f793          	andi	a5,a5,1
80005fc0:	02078e63          	beqz	a5,80005ffc <z_impl_k_thread_abort+0xb8>
80005fc4:	80008937          	lui	s2,0x80008
80005fc8:	800085b7          	lui	a1,0x80008
80005fcc:	80008537          	lui	a0,0x80008
80005fd0:	45458593          	addi	a1,a1,1108 # 80008454 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008455>
80005fd4:	02900693          	li	a3,41
80005fd8:	43c90613          	addi	a2,s2,1084 # 8000843c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000843d>
80005fdc:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80005fe0:	ae5fc0ef          	jal	ra,80002ac4 <printk>
80005fe4:	80008537          	lui	a0,0x80008
80005fe8:	48850513          	addi	a0,a0,1160 # 80008488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008489>
80005fec:	ad9fc0ef          	jal	ra,80002ac4 <printk>
80005ff0:	02900593          	li	a1,41
80005ff4:	43c90513          	addi	a0,s2,1084
80005ff8:	b09fc0ef          	jal	ra,80002b00 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80005ffc:	00048513          	mv	a0,s1
80006000:	b2dff0ef          	jal	ra,80005b2c <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80006004:	00040593          	mv	a1,s0
80006008:	00c10513          	addi	a0,sp,12
8000600c:	f21fd0ef          	jal	ra,80003f2c <z_reschedule>
}
80006010:	01c12083          	lw	ra,28(sp)
80006014:	01812403          	lw	s0,24(sp)
80006018:	01412483          	lw	s1,20(sp)
8000601c:	01012903          	lw	s2,16(sp)
80006020:	02010113          	addi	sp,sp,32
80006024:	00008067          	ret

80006028 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80006028:	800087b7          	lui	a5,0x80008
8000602c:	7007a783          	lw	a5,1792(a5) # 80008700 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008701>
80006030:	00079463          	bnez	a5,80006038 <elapsed+0x10>
80006034:	f5dfc06f          	j	80002f90 <z_clock_elapsed>
}
80006038:	00000513          	li	a0,0
8000603c:	00008067          	ret

80006040 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80006040:	00052783          	lw	a5,0(a0)
80006044:	02050263          	beqz	a0,80006068 <remove_timeout+0x28>
80006048:	80008737          	lui	a4,0x80008
	return (node == list->tail) ? NULL : node->next;
8000604c:	67072703          	lw	a4,1648(a4) # 80008670 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008671>
80006050:	00e50c63          	beq	a0,a4,80006068 <remove_timeout+0x28>
	if (next(t) != NULL) {
80006054:	00078a63          	beqz	a5,80006068 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80006058:	0087a703          	lw	a4,8(a5)
8000605c:	00852683          	lw	a3,8(a0)
80006060:	00d70733          	add	a4,a4,a3
80006064:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80006068:	00452703          	lw	a4,4(a0)
8000606c:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80006070:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80006074:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80006078:	00052223          	sw	zero,4(a0)
}
8000607c:	00008067          	ret

80006080 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80006080:	800087b7          	lui	a5,0x80008
80006084:	70c7c783          	lbu	a5,1804(a5) # 8000870c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000870d>
{
80006088:	ff010113          	addi	sp,sp,-16
8000608c:	00112623          	sw	ra,12(sp)
80006090:	00812423          	sw	s0,8(sp)
80006094:	00912223          	sw	s1,4(sp)
80006098:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
8000609c:	00079663          	bnez	a5,800060a8 <next_timeout+0x28>
800060a0:	80000537          	lui	a0,0x80000
800060a4:	fff54513          	not	a0,a0
	return list->head == list;
800060a8:	800087b7          	lui	a5,0x80008
800060ac:	66c78793          	addi	a5,a5,1644 # 8000866c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000866d>
800060b0:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800060b4:	02f40463          	beq	s0,a5,800060dc <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
800060b8:	02040263          	beqz	s0,800060dc <next_timeout+0x5c>
800060bc:	00842483          	lw	s1,8(s0)
800060c0:	f69ff0ef          	jal	ra,80006028 <elapsed>
800060c4:	40a484b3          	sub	s1,s1,a0
800060c8:	00000513          	li	a0,0
800060cc:	0004c863          	bltz	s1,800060dc <next_timeout+0x5c>
800060d0:	00842403          	lw	s0,8(s0)
800060d4:	f55ff0ef          	jal	ra,80006028 <elapsed>
800060d8:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
800060dc:	800097b7          	lui	a5,0x80009
800060e0:	d4c7a783          	lw	a5,-692(a5) # 80008d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d4d>
800060e4:	00078663          	beqz	a5,800060f0 <next_timeout+0x70>
800060e8:	00a7d463          	bge	a5,a0,800060f0 <next_timeout+0x70>
800060ec:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
800060f0:	00c12083          	lw	ra,12(sp)
800060f4:	00812403          	lw	s0,8(sp)
800060f8:	00412483          	lw	s1,4(sp)
800060fc:	01010113          	addi	sp,sp,16
80006100:	00008067          	ret

80006104 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80006104:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80006108:	fd010113          	addi	sp,sp,-48
8000610c:	02812423          	sw	s0,40(sp)
80006110:	02912223          	sw	s1,36(sp)
80006114:	01312e23          	sw	s3,28(sp)
80006118:	02112623          	sw	ra,44(sp)
8000611c:	03212023          	sw	s2,32(sp)
80006120:	01412c23          	sw	s4,24(sp)
80006124:	01512a23          	sw	s5,20(sp)
80006128:	01612823          	sw	s6,16(sp)
8000612c:	01712623          	sw	s7,12(sp)
80006130:	01812423          	sw	s8,8(sp)
80006134:	00050413          	mv	s0,a0
80006138:	00058993          	mv	s3,a1
8000613c:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80006140:	02078e63          	beqz	a5,8000617c <z_add_timeout+0x78>
80006144:	80008937          	lui	s2,0x80008
80006148:	800085b7          	lui	a1,0x80008
8000614c:	80008537          	lui	a0,0x80008
80006150:	4b858593          	addi	a1,a1,1208 # 800084b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800084b9>
80006154:	04d00693          	li	a3,77
80006158:	4a490613          	addi	a2,s2,1188 # 800084a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800084a5>
8000615c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006160:	965fc0ef          	jal	ra,80002ac4 <printk>
80006164:	80008537          	lui	a0,0x80008
80006168:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
8000616c:	959fc0ef          	jal	ra,80002ac4 <printk>
80006170:	04d00593          	li	a1,77
80006174:	4a490513          	addi	a0,s2,1188
80006178:	989fc0ef          	jal	ra,80002b00 <assert_post_action>
	to->fn = fn;
8000617c:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80006180:	00904463          	bgtz	s1,80006188 <z_add_timeout+0x84>
80006184:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006188:	00800993          	li	s3,8
8000618c:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006190:	80008a37          	lui	s4,0x80008
80006194:	704a0513          	addi	a0,s4,1796 # 80008704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008705>
	key = (mstatus & SOC_MSTATUS_IEN);
80006198:	0089f993          	andi	s3,s3,8
8000619c:	a21ff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
800061a0:	02051e63          	bnez	a0,800061dc <z_add_timeout+0xd8>
800061a4:	80008937          	lui	s2,0x80008
800061a8:	800085b7          	lui	a1,0x80008
800061ac:	80008537          	lui	a0,0x80008
800061b0:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
800061b4:	04e00693          	li	a3,78
800061b8:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800061bc:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800061c0:	905fc0ef          	jal	ra,80002ac4 <printk>
800061c4:	80008537          	lui	a0,0x80008
800061c8:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
800061cc:	8f9fc0ef          	jal	ra,80002ac4 <printk>
800061d0:	04e00593          	li	a1,78
800061d4:	fc490513          	addi	a0,s2,-60
800061d8:	929fc0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
800061dc:	704a0513          	addi	a0,s4,1796
800061e0:	a35ff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
800061e4:	e45ff0ef          	jal	ra,80006028 <elapsed>
800061e8:	00950533          	add	a0,a0,s1
	return list->head == list;
800061ec:	800084b7          	lui	s1,0x80008
800061f0:	66c4a903          	lw	s2,1644(s1) # 8000866c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000866d>
800061f4:	00a42423          	sw	a0,8(s0)
800061f8:	66c48493          	addi	s1,s1,1644
	return sys_dlist_is_empty(list) ? NULL : list->head;
800061fc:	00990c63          	beq	s2,s1,80006214 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80006200:	80008ab7          	lui	s5,0x80008
80006204:	80008b37          	lui	s6,0x80008
80006208:	80008bb7          	lui	s7,0x80008
8000620c:	80008c37          	lui	s8,0x80008
		for (t = first(); t != NULL; t = next(t)) {
80006210:	02091063          	bnez	s2,80006230 <z_add_timeout+0x12c>
	node->prev = list->tail;
80006214:	0044a783          	lw	a5,4(s1)
	node->next = list;
80006218:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
8000621c:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80006220:	0044a783          	lw	a5,4(s1)
80006224:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80006228:	0084a223          	sw	s0,4(s1)
8000622c:	05c0006f          	j	80006288 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80006230:	00892783          	lw	a5,8(s2)
80006234:	0207d663          	bgez	a5,80006260 <z_add_timeout+0x15c>
80006238:	4d8b0593          	addi	a1,s6,1240 # 800084d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800084d9>
8000623c:	05600693          	li	a3,86
80006240:	4a4a8613          	addi	a2,s5,1188 # 800084a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800084a5>
80006244:	ef8b8513          	addi	a0,s7,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006248:	87dfc0ef          	jal	ra,80002ac4 <printk>
8000624c:	f7cc0513          	addi	a0,s8,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
80006250:	875fc0ef          	jal	ra,80002ac4 <printk>
80006254:	05600593          	li	a1,86
80006258:	4a4a8513          	addi	a0,s5,1188
8000625c:	8a5fc0ef          	jal	ra,80002b00 <assert_post_action>

			if (t->dticks > to->dticks) {
80006260:	00892703          	lw	a4,8(s2)
80006264:	00842783          	lw	a5,8(s0)
80006268:	0ae7d863          	bge	a5,a4,80006318 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
8000626c:	40f707b3          	sub	a5,a4,a5
80006270:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80006274:	00492783          	lw	a5,4(s2)
	node->next = successor;
80006278:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
8000627c:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80006280:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80006284:	00892223          	sw	s0,4(s2)
	return list->head == list;
80006288:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000628c:	00978a63          	beq	a5,s1,800062a0 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80006290:	00f41863          	bne	s0,a5,800062a0 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80006294:	dedff0ef          	jal	ra,80006080 <next_timeout>
80006298:	00000593          	li	a1,0
8000629c:	b4dfc0ef          	jal	ra,80002de8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800062a0:	704a0513          	addi	a0,s4,1796
800062a4:	941ff0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800062a8:	02051e63          	bnez	a0,800062e4 <z_add_timeout+0x1e0>
800062ac:	80008437          	lui	s0,0x80008
800062b0:	800085b7          	lui	a1,0x80008
800062b4:	80008537          	lui	a0,0x80008
800062b8:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800062bc:	06100693          	li	a3,97
800062c0:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800062c4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800062c8:	ffcfc0ef          	jal	ra,80002ac4 <printk>
800062cc:	80008537          	lui	a0,0x80008
800062d0:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800062d4:	ff0fc0ef          	jal	ra,80002ac4 <printk>
800062d8:	06100593          	li	a1,97
800062dc:	fc440513          	addi	a0,s0,-60
800062e0:	821fc0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800062e4:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
800062e8:	02c12083          	lw	ra,44(sp)
800062ec:	02812403          	lw	s0,40(sp)
800062f0:	02412483          	lw	s1,36(sp)
800062f4:	02012903          	lw	s2,32(sp)
800062f8:	01c12983          	lw	s3,28(sp)
800062fc:	01812a03          	lw	s4,24(sp)
80006300:	01412a83          	lw	s5,20(sp)
80006304:	01012b03          	lw	s6,16(sp)
80006308:	00c12b83          	lw	s7,12(sp)
8000630c:	00812c03          	lw	s8,8(sp)
80006310:	03010113          	addi	sp,sp,48
80006314:	00008067          	ret
			to->dticks -= t->dticks;
80006318:	40e787b3          	sub	a5,a5,a4
8000631c:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80006320:	0044a783          	lw	a5,4(s1)
80006324:	ef2788e3          	beq	a5,s2,80006214 <z_add_timeout+0x110>
80006328:	00092903          	lw	s2,0(s2)
8000632c:	ee5ff06f          	j	80006210 <z_add_timeout+0x10c>

80006330 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80006330:	fe010113          	addi	sp,sp,-32
80006334:	00812c23          	sw	s0,24(sp)
80006338:	01312623          	sw	s3,12(sp)
8000633c:	00112e23          	sw	ra,28(sp)
80006340:	00912a23          	sw	s1,20(sp)
80006344:	01212823          	sw	s2,16(sp)
80006348:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000634c:	00800413          	li	s0,8
80006350:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006354:	800084b7          	lui	s1,0x80008
80006358:	70448513          	addi	a0,s1,1796 # 80008704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008705>
	key = (mstatus & SOC_MSTATUS_IEN);
8000635c:	00847413          	andi	s0,s0,8
80006360:	85dff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
80006364:	02051e63          	bnez	a0,800063a0 <z_abort_timeout+0x70>
80006368:	80008937          	lui	s2,0x80008
8000636c:	800085b7          	lui	a1,0x80008
80006370:	80008537          	lui	a0,0x80008
80006374:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80006378:	04e00693          	li	a3,78
8000637c:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80006380:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006384:	f40fc0ef          	jal	ra,80002ac4 <printk>
80006388:	80008537          	lui	a0,0x80008
8000638c:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80006390:	f34fc0ef          	jal	ra,80002ac4 <printk>
80006394:	04e00593          	li	a1,78
80006398:	fc490513          	addi	a0,s2,-60
8000639c:	f64fc0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
800063a0:	70448513          	addi	a0,s1,1796
800063a4:	871ff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
800063a8:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
800063ac:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
800063b0:	00078863          	beqz	a5,800063c0 <z_abort_timeout+0x90>
			remove_timeout(to);
800063b4:	00098513          	mv	a0,s3
800063b8:	c89ff0ef          	jal	ra,80006040 <remove_timeout>
			ret = 0;
800063bc:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800063c0:	70448513          	addi	a0,s1,1796
800063c4:	821ff0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800063c8:	02051e63          	bnez	a0,80006404 <z_abort_timeout+0xd4>
800063cc:	800084b7          	lui	s1,0x80008
800063d0:	800085b7          	lui	a1,0x80008
800063d4:	80008537          	lui	a0,0x80008
800063d8:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800063dc:	06100693          	li	a3,97
800063e0:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800063e4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800063e8:	edcfc0ef          	jal	ra,80002ac4 <printk>
800063ec:	80008537          	lui	a0,0x80008
800063f0:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800063f4:	ed0fc0ef          	jal	ra,80002ac4 <printk>
800063f8:	06100593          	li	a1,97
800063fc:	fc448513          	addi	a0,s1,-60
80006400:	f00fc0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006404:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80006408:	01c12083          	lw	ra,28(sp)
8000640c:	01812403          	lw	s0,24(sp)
80006410:	00090513          	mv	a0,s2
80006414:	01412483          	lw	s1,20(sp)
80006418:	01012903          	lw	s2,16(sp)
8000641c:	00c12983          	lw	s3,12(sp)
80006420:	02010113          	addi	sp,sp,32
80006424:	00008067          	ret

80006428 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80006428:	ff010113          	addi	sp,sp,-16
8000642c:	00812423          	sw	s0,8(sp)
80006430:	00112623          	sw	ra,12(sp)
80006434:	00912223          	sw	s1,4(sp)
80006438:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000643c:	00800413          	li	s0,8
80006440:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006444:	800084b7          	lui	s1,0x80008
80006448:	70448513          	addi	a0,s1,1796 # 80008704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008705>
	key = (mstatus & SOC_MSTATUS_IEN);
8000644c:	00847413          	andi	s0,s0,8
80006450:	f6cff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
80006454:	02051e63          	bnez	a0,80006490 <z_get_next_timeout_expiry+0x68>
80006458:	80008937          	lui	s2,0x80008
8000645c:	800085b7          	lui	a1,0x80008
80006460:	80008537          	lui	a0,0x80008
80006464:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80006468:	04e00693          	li	a3,78
8000646c:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80006470:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006474:	e50fc0ef          	jal	ra,80002ac4 <printk>
80006478:	80008537          	lui	a0,0x80008
8000647c:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80006480:	e44fc0ef          	jal	ra,80002ac4 <printk>
80006484:	04e00593          	li	a1,78
80006488:	fc490513          	addi	a0,s2,-60
8000648c:	e74fc0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80006490:	70448513          	addi	a0,s1,1796
80006494:	f80ff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80006498:	be9ff0ef          	jal	ra,80006080 <next_timeout>
8000649c:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800064a0:	70448513          	addi	a0,s1,1796
800064a4:	f40ff0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800064a8:	02051e63          	bnez	a0,800064e4 <z_get_next_timeout_expiry+0xbc>
800064ac:	800084b7          	lui	s1,0x80008
800064b0:	800085b7          	lui	a1,0x80008
800064b4:	80008537          	lui	a0,0x80008
800064b8:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800064bc:	06100693          	li	a3,97
800064c0:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800064c4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800064c8:	dfcfc0ef          	jal	ra,80002ac4 <printk>
800064cc:	80008537          	lui	a0,0x80008
800064d0:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800064d4:	df0fc0ef          	jal	ra,80002ac4 <printk>
800064d8:	06100593          	li	a1,97
800064dc:	fc448513          	addi	a0,s1,-60
800064e0:	e20fc0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800064e4:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800064e8:	00c12083          	lw	ra,12(sp)
800064ec:	00812403          	lw	s0,8(sp)
800064f0:	00090513          	mv	a0,s2
800064f4:	00412483          	lw	s1,4(sp)
800064f8:	00012903          	lw	s2,0(sp)
800064fc:	01010113          	addi	sp,sp,16
80006500:	00008067          	ret

80006504 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80006504:	fe010113          	addi	sp,sp,-32
80006508:	00812c23          	sw	s0,24(sp)
8000650c:	01212823          	sw	s2,16(sp)
80006510:	01412423          	sw	s4,8(sp)
80006514:	00112e23          	sw	ra,28(sp)
80006518:	00912a23          	sw	s1,20(sp)
8000651c:	01312623          	sw	s3,12(sp)
80006520:	00050913          	mv	s2,a0
80006524:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006528:	00800413          	li	s0,8
8000652c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006530:	800084b7          	lui	s1,0x80008
80006534:	70448513          	addi	a0,s1,1796 # 80008704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008705>
	key = (mstatus & SOC_MSTATUS_IEN);
80006538:	00847413          	andi	s0,s0,8
8000653c:	e80ff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
80006540:	02051e63          	bnez	a0,8000657c <z_set_timeout_expiry+0x78>
80006544:	800089b7          	lui	s3,0x80008
80006548:	800085b7          	lui	a1,0x80008
8000654c:	80008537          	lui	a0,0x80008
80006550:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80006554:	04e00693          	li	a3,78
80006558:	fc498613          	addi	a2,s3,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
8000655c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006560:	d64fc0ef          	jal	ra,80002ac4 <printk>
80006564:	80008537          	lui	a0,0x80008
80006568:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
8000656c:	d58fc0ef          	jal	ra,80002ac4 <printk>
80006570:	04e00593          	li	a1,78
80006574:	fc498513          	addi	a0,s3,-60
80006578:	d88fc0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
8000657c:	70448513          	addi	a0,s1,1796
80006580:	e94ff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80006584:	afdff0ef          	jal	ra,80006080 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80006588:	00a95c63          	bge	s2,a0,800065a0 <z_set_timeout_expiry+0x9c>
8000658c:	00100793          	li	a5,1
80006590:	00a7d863          	bge	a5,a0,800065a0 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80006594:	000a0593          	mv	a1,s4
80006598:	00090513          	mv	a0,s2
8000659c:	84dfc0ef          	jal	ra,80002de8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800065a0:	70448513          	addi	a0,s1,1796
800065a4:	e40ff0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800065a8:	02051e63          	bnez	a0,800065e4 <z_set_timeout_expiry+0xe0>
800065ac:	800084b7          	lui	s1,0x80008
800065b0:	800085b7          	lui	a1,0x80008
800065b4:	80008537          	lui	a0,0x80008
800065b8:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800065bc:	06100693          	li	a3,97
800065c0:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800065c4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800065c8:	cfcfc0ef          	jal	ra,80002ac4 <printk>
800065cc:	80008537          	lui	a0,0x80008
800065d0:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800065d4:	cf0fc0ef          	jal	ra,80002ac4 <printk>
800065d8:	06100593          	li	a1,97
800065dc:	fc448513          	addi	a0,s1,-60
800065e0:	d20fc0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800065e4:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800065e8:	01c12083          	lw	ra,28(sp)
800065ec:	01812403          	lw	s0,24(sp)
800065f0:	01412483          	lw	s1,20(sp)
800065f4:	01012903          	lw	s2,16(sp)
800065f8:	00c12983          	lw	s3,12(sp)
800065fc:	00812a03          	lw	s4,8(sp)
80006600:	02010113          	addi	sp,sp,32
80006604:	00008067          	ret

80006608 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80006608:	fd010113          	addi	sp,sp,-48
8000660c:	02812423          	sw	s0,40(sp)
80006610:	01412c23          	sw	s4,24(sp)
80006614:	02112623          	sw	ra,44(sp)
80006618:	02912223          	sw	s1,36(sp)
8000661c:	03212023          	sw	s2,32(sp)
80006620:	01312e23          	sw	s3,28(sp)
80006624:	01512a23          	sw	s5,20(sp)
80006628:	01612823          	sw	s6,16(sp)
8000662c:	01712623          	sw	s7,12(sp)
80006630:	01812423          	sw	s8,8(sp)
80006634:	01912223          	sw	s9,4(sp)
80006638:	01a12023          	sw	s10,0(sp)
8000663c:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006640:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80006644:	bc4fe0ef          	jal	ra,80004a08 <z_time_slice>
80006648:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000664c:	80008937          	lui	s2,0x80008
80006650:	70490513          	addi	a0,s2,1796 # 80008704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008705>
	key = (mstatus & SOC_MSTATUS_IEN);
80006654:	00847413          	andi	s0,s0,8
80006658:	d64ff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
8000665c:	02051e63          	bnez	a0,80006698 <z_clock_announce+0x90>
80006660:	800084b7          	lui	s1,0x80008
80006664:	800085b7          	lui	a1,0x80008
80006668:	80008537          	lui	a0,0x80008
8000666c:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80006670:	04e00693          	li	a3,78
80006674:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80006678:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
8000667c:	c48fc0ef          	jal	ra,80002ac4 <printk>
80006680:	80008537          	lui	a0,0x80008
80006684:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80006688:	c3cfc0ef          	jal	ra,80002ac4 <printk>
8000668c:	04e00593          	li	a1,78
80006690:	fc448513          	addi	a0,s1,-60
80006694:	c6cfc0ef          	jal	ra,80002b00 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80006698:	800089b7          	lui	s3,0x80008
	z_spin_lock_set_owner(l);
8000669c:	70490513          	addi	a0,s2,1796
800066a0:	d74ff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
800066a4:	800084b7          	lui	s1,0x80008
800066a8:	7149a023          	sw	s4,1792(s3) # 80008700 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008701>
	return list->head == list;
800066ac:	80008a37          	lui	s4,0x80008
800066b0:	70098993          	addi	s3,s3,1792
800066b4:	66ca0a13          	addi	s4,s4,1644 # 8000866c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000866d>
800066b8:	6c848493          	addi	s1,s1,1736 # 800086c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086c9>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800066bc:	80008ab7          	lui	s5,0x80008
800066c0:	80008bb7          	lui	s7,0x80008
800066c4:	80008b37          	lui	s6,0x80008
800066c8:	80008c37          	lui	s8,0x80008
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800066cc:	80008cb7          	lui	s9,0x80008
800066d0:	000a2d03          	lw	s10,0(s4)
800066d4:	0009a783          	lw	a5,0(s3)
800066d8:	0004a683          	lw	a3,0(s1)
800066dc:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800066e0:	014d0c63          	beq	s10,s4,800066f8 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
800066e4:	000d0a63          	beqz	s10,800066f8 <z_clock_announce+0xf0>
800066e8:	008d2703          	lw	a4,8(s10)
800066ec:	0ae7dc63          	bge	a5,a4,800067a4 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
800066f0:	40f70733          	sub	a4,a4,a5
800066f4:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
800066f8:	00d786b3          	add	a3,a5,a3
800066fc:	41f7d713          	srai	a4,a5,0x1f
80006700:	00a70733          	add	a4,a4,a0
80006704:	00f6b7b3          	sltu	a5,a3,a5
80006708:	00e787b3          	add	a5,a5,a4
8000670c:	00d4a023          	sw	a3,0(s1)
80006710:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80006714:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80006718:	969ff0ef          	jal	ra,80006080 <next_timeout>
8000671c:	00000593          	li	a1,0
80006720:	ec8fc0ef          	jal	ra,80002de8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006724:	70490513          	addi	a0,s2,1796
80006728:	cbcff0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
8000672c:	02051e63          	bnez	a0,80006768 <z_clock_announce+0x160>
80006730:	800084b7          	lui	s1,0x80008
80006734:	800085b7          	lui	a1,0x80008
80006738:	80008537          	lui	a0,0x80008
8000673c:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80006740:	06100693          	li	a3,97
80006744:	fc448613          	addi	a2,s1,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80006748:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
8000674c:	b78fc0ef          	jal	ra,80002ac4 <printk>
80006750:	80008537          	lui	a0,0x80008
80006754:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80006758:	b6cfc0ef          	jal	ra,80002ac4 <printk>
8000675c:	06100593          	li	a1,97
80006760:	fc448513          	addi	a0,s1,-60
80006764:	b9cfc0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006768:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
8000676c:	02c12083          	lw	ra,44(sp)
80006770:	02812403          	lw	s0,40(sp)
80006774:	02412483          	lw	s1,36(sp)
80006778:	02012903          	lw	s2,32(sp)
8000677c:	01c12983          	lw	s3,28(sp)
80006780:	01812a03          	lw	s4,24(sp)
80006784:	01412a83          	lw	s5,20(sp)
80006788:	01012b03          	lw	s6,16(sp)
8000678c:	00c12b83          	lw	s7,12(sp)
80006790:	00812c03          	lw	s8,8(sp)
80006794:	00412c83          	lw	s9,4(sp)
80006798:	00012d03          	lw	s10,0(sp)
8000679c:	03010113          	addi	sp,sp,48
800067a0:	00008067          	ret
		curr_tick += dt;
800067a4:	00d706b3          	add	a3,a4,a3
800067a8:	41f75593          	srai	a1,a4,0x1f
800067ac:	00a585b3          	add	a1,a1,a0
800067b0:	00e6b633          	sltu	a2,a3,a4
800067b4:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
800067b8:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
800067bc:	000d0513          	mv	a0,s10
		t->dticks = 0;
800067c0:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
800067c4:	00d4a023          	sw	a3,0(s1)
800067c8:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
800067cc:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
800067d0:	871ff0ef          	jal	ra,80006040 <remove_timeout>
800067d4:	70490513          	addi	a0,s2,1796
800067d8:	c0cff0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
800067dc:	02051663          	bnez	a0,80006808 <z_clock_announce+0x200>
800067e0:	00cb8593          	addi	a1,s7,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
800067e4:	06100693          	li	a3,97
800067e8:	fc4a8613          	addi	a2,s5,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800067ec:	ef8b0513          	addi	a0,s6,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800067f0:	ad4fc0ef          	jal	ra,80002ac4 <printk>
800067f4:	024c0513          	addi	a0,s8,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
800067f8:	accfc0ef          	jal	ra,80002ac4 <printk>
800067fc:	06100593          	li	a1,97
80006800:	fc4a8513          	addi	a0,s5,-60
80006804:	afcfc0ef          	jal	ra,80002b00 <assert_post_action>
80006808:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
8000680c:	00cd2783          	lw	a5,12(s10)
80006810:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006814:	00800413          	li	s0,8
80006818:	000780e7          	jalr	a5
8000681c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006820:	70490513          	addi	a0,s2,1796
	key = (mstatus & SOC_MSTATUS_IEN);
80006824:	00847413          	andi	s0,s0,8
80006828:	b94ff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
8000682c:	02051863          	bnez	a0,8000685c <z_clock_announce+0x254>
80006830:	fdcc8593          	addi	a1,s9,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80006834:	04e00693          	li	a3,78
80006838:	fc4a8613          	addi	a2,s5,-60
8000683c:	ef8b0513          	addi	a0,s6,-264
80006840:	a84fc0ef          	jal	ra,80002ac4 <printk>
80006844:	80008537          	lui	a0,0x80008
80006848:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
8000684c:	a78fc0ef          	jal	ra,80002ac4 <printk>
80006850:	04e00593          	li	a1,78
80006854:	fc4a8513          	addi	a0,s5,-60
80006858:	aa8fc0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
8000685c:	70490513          	addi	a0,s2,1796
80006860:	bb4ff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	return k;
80006864:	e6dff06f          	j	800066d0 <z_clock_announce+0xc8>

80006868 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80006868:	fe010113          	addi	sp,sp,-32
8000686c:	00912a23          	sw	s1,20(sp)
80006870:	00112e23          	sw	ra,28(sp)
80006874:	00812c23          	sw	s0,24(sp)
80006878:	01212823          	sw	s2,16(sp)
8000687c:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006880:	00800493          	li	s1,8
80006884:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006888:	80008937          	lui	s2,0x80008
8000688c:	70490513          	addi	a0,s2,1796 # 80008704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008705>
	key = (mstatus & SOC_MSTATUS_IEN);
80006890:	0084f493          	andi	s1,s1,8
80006894:	b28ff0ef          	jal	ra,80005bbc <z_spin_lock_valid>
80006898:	02051e63          	bnez	a0,800068d4 <z_tick_get+0x6c>
8000689c:	80008437          	lui	s0,0x80008
800068a0:	800085b7          	lui	a1,0x80008
800068a4:	80008537          	lui	a0,0x80008
800068a8:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
800068ac:	04e00693          	li	a3,78
800068b0:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
800068b4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
800068b8:	a0cfc0ef          	jal	ra,80002ac4 <printk>
800068bc:	80008537          	lui	a0,0x80008
800068c0:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
800068c4:	a00fc0ef          	jal	ra,80002ac4 <printk>
800068c8:	04e00593          	li	a1,78
800068cc:	fc440513          	addi	a0,s0,-60
800068d0:	a30fc0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
800068d4:	70490513          	addi	a0,s2,1796
800068d8:	b3cff0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
800068dc:	eb4fc0ef          	jal	ra,80002f90 <z_clock_elapsed>
800068e0:	800087b7          	lui	a5,0x80008
800068e4:	6c878793          	addi	a5,a5,1736 # 800086c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086c9>
800068e8:	0007a983          	lw	s3,0(a5)
800068ec:	0047a403          	lw	s0,4(a5)
800068f0:	013509b3          	add	s3,a0,s3
800068f4:	00a9b533          	sltu	a0,s3,a0
800068f8:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800068fc:	70490513          	addi	a0,s2,1796
80006900:	ae4ff0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80006904:	02051e63          	bnez	a0,80006940 <z_tick_get+0xd8>
80006908:	80008937          	lui	s2,0x80008
8000690c:	800085b7          	lui	a1,0x80008
80006910:	80008537          	lui	a0,0x80008
80006914:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80006918:	06100693          	li	a3,97
8000691c:	fc490613          	addi	a2,s2,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80006920:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006924:	9a0fc0ef          	jal	ra,80002ac4 <printk>
80006928:	80008537          	lui	a0,0x80008
8000692c:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80006930:	994fc0ef          	jal	ra,80002ac4 <printk>
80006934:	06100593          	li	a1,97
80006938:	fc490513          	addi	a0,s2,-60
8000693c:	9c4fc0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006940:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80006944:	00040593          	mv	a1,s0
80006948:	01c12083          	lw	ra,28(sp)
8000694c:	01812403          	lw	s0,24(sp)
80006950:	00098513          	mv	a0,s3
80006954:	01412483          	lw	s1,20(sp)
80006958:	01012903          	lw	s2,16(sp)
8000695c:	00c12983          	lw	s3,12(sp)
80006960:	02010113          	addi	sp,sp,32
80006964:	00008067          	ret

80006968 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80006968:	ff010113          	addi	sp,sp,-16
8000696c:	00112623          	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80006970:	ef9ff0ef          	jal	ra,80006868 <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80006974:	00c12083          	lw	ra,12(sp)
80006978:	01010113          	addi	sp,sp,16
8000697c:	00008067          	ret

80006980 <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
80006980:	ff010113          	addi	sp,sp,-16
80006984:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
80006988:	ee1ff0ef          	jal	ra,80006868 <z_tick_get>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000698c:	3e800613          	li	a2,1000
80006990:	00000693          	li	a3,0
80006994:	f25f90ef          	jal	ra,800008b8 <__muldi3>
80006998:	06400613          	li	a2,100
8000699c:	00000693          	li	a3,0
800069a0:	921f90ef          	jal	ra,800002c0 <__udivdi3>
}
800069a4:	00c12083          	lw	ra,12(sp)
800069a8:	01010113          	addi	sp,sp,16
800069ac:	00008067          	ret

800069b0 <k_timer_init>:
800069b0:	01050793          	addi	a5,a0,16

void k_timer_init(struct k_timer *timer,
			 k_timer_expiry_t expiry_fn,
			 k_timer_stop_t stop_fn)
{
	timer->expiry_fn = expiry_fn;
800069b4:	00b52c23          	sw	a1,24(a0)
	timer->stop_fn = stop_fn;
800069b8:	00c52e23          	sw	a2,28(a0)
	timer->status = 0U;
800069bc:	02052223          	sw	zero,36(a0)
	list->head = (sys_dnode_t *)list;
800069c0:	00f52823          	sw	a5,16(a0)
	list->tail = (sys_dnode_t *)list;
800069c4:	00f52a23          	sw	a5,20(a0)
	node->next = NULL;
800069c8:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800069cc:	00052223          	sw	zero,4(a0)

	z_waitq_init(&timer->wait_q);
	z_init_timeout(&timer->timeout, z_timer_expiration_handler);
	SYS_TRACING_OBJ_INIT(k_timer, timer);

	timer->user_data = NULL;
800069d0:	02052423          	sw	zero,40(a0)

	z_object_init(timer);
}
800069d4:	00008067          	ret

800069d8 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
800069d8:	ff010113          	addi	sp,sp,-16
800069dc:	00812423          	sw	s0,8(sp)
800069e0:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800069e4:	80008437          	lui	s0,0x80008
800069e8:	800084b7          	lui	s1,0x80008
{
800069ec:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800069f0:	6ac40413          	addi	s0,s0,1708 # 800086ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ad>
800069f4:	6ac48493          	addi	s1,s1,1708 # 800086ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ad>
800069f8:	00946e63          	bltu	s0,s1,80006a14 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
800069fc:	00c12083          	lw	ra,12(sp)
80006a00:	00812403          	lw	s0,8(sp)
80006a04:	00412483          	lw	s1,4(sp)
80006a08:	00000513          	li	a0,0
80006a0c:	01010113          	addi	sp,sp,16
80006a10:	00008067          	ret
80006a14:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80006a18:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80006a1c:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80006a20:	00f42c23          	sw	a5,24(s0)
80006a24:	b10fb0ef          	jal	ra,80001d34 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80006a28:	01c40413          	addi	s0,s0,28
80006a2c:	fcdff06f          	j	800069f8 <init_static_pools+0x20>

80006a30 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80006a30:	800097b7          	lui	a5,0x80009
80006a34:	d3c7a783          	lw	a5,-708(a5) # 80008d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d3d>
{
80006a38:	fb010113          	addi	sp,sp,-80
80006a3c:	04812423          	sw	s0,72(sp)
80006a40:	04912223          	sw	s1,68(sp)
80006a44:	03312e23          	sw	s3,60(sp)
80006a48:	03612823          	sw	s6,48(sp)
80006a4c:	04112623          	sw	ra,76(sp)
80006a50:	05212023          	sw	s2,64(sp)
80006a54:	03412c23          	sw	s4,56(sp)
80006a58:	03512a23          	sw	s5,52(sp)
80006a5c:	03712623          	sw	s7,44(sp)
80006a60:	03812423          	sw	s8,40(sp)
80006a64:	03912223          	sw	s9,36(sp)
80006a68:	03a12023          	sw	s10,32(sp)
80006a6c:	01b12e23          	sw	s11,28(sp)
80006a70:	00050993          	mv	s3,a0
80006a74:	00058493          	mv	s1,a1
80006a78:	00060b13          	mv	s6,a2
80006a7c:	00068413          	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80006a80:	16078263          	beqz	a5,80006be4 <k_mem_pool_alloc+0x1b4>
80006a84:	12069463          	bnez	a3,80006bac <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
80006a88:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80006a8c:	80008537          	lui	a0,0x80008
80006a90:	6ac50513          	addi	a0,a0,1708 # 800086ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ad>
80006a94:	40a98533          	sub	a0,s3,a0
80006a98:	b6db75b7          	lui	a1,0xb6db7
80006a9c:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
80006aa0:	40255513          	srai	a0,a0,0x2
80006aa4:	df1f90ef          	jal	ra,80000894 <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
80006aa8:	fffffa37          	lui	s4,0xfffff
		block->id.block = block_num;
80006aac:	00001ab7          	lui	s5,0x1
		block->id.pool = pool_id(p);
80006ab0:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
80006ab4:	ff500b93          	li	s7,-11
			ret = -ENOMEM;
80006ab8:	ff400c93          	li	s9,-12
		block->id.level = level_num;
80006abc:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80006ac0:	fffa8a93          	addi	s5,s5,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006ac4:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
80006ac8:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80006acc:	00048713          	mv	a4,s1
80006ad0:	00c10693          	addi	a3,sp,12
80006ad4:	00810613          	addi	a2,sp,8
80006ad8:	000b0593          	mv	a1,s6
80006adc:	00098513          	mv	a0,s3
80006ae0:	b9cfb0ef          	jal	ra,80001e7c <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80006ae4:	03751263          	bne	a0,s7,80006b08 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80006ae8:	00048713          	mv	a4,s1
80006aec:	00c10693          	addi	a3,sp,12
80006af0:	00810613          	addi	a2,sp,8
80006af4:	000b0593          	mv	a1,s6
80006af8:	00098513          	mv	a0,s3
80006afc:	b80fb0ef          	jal	ra,80001e7c <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80006b00:	01751463          	bne	a0,s7,80006b08 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
80006b04:	ff400513          	li	a0,-12
		block->id.level = level_num;
80006b08:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80006b0c:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
80006b10:	00f7f793          	andi	a5,a5,15
80006b14:	00879713          	slli	a4,a5,0x8
80006b18:	0044a783          	lw	a5,4(s1)
80006b1c:	0147f7b3          	and	a5,a5,s4
80006b20:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
80006b24:	00c12703          	lw	a4,12(sp)
80006b28:	0157f7b3          	and	a5,a5,s5
80006b2c:	00c71713          	slli	a4,a4,0xc
80006b30:	00e7e7b3          	or	a5,a5,a4
80006b34:	00f4a223          	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
80006b38:	02050c63          	beqz	a0,80006b70 <k_mem_pool_alloc+0x140>
80006b3c:	02040a63          	beqz	s0,80006b70 <k_mem_pool_alloc+0x140>
80006b40:	03951863          	bne	a0,s9,80006b70 <k_mem_pool_alloc+0x140>
80006b44:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
80006b48:	00040613          	mv	a2,s0
80006b4c:	000d8593          	mv	a1,s11
80006b50:	00857513          	andi	a0,a0,8
80006b54:	96cfe0ef          	jal	ra,80004cc0 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
80006b58:	fff00793          	li	a5,-1
80006b5c:	f6f408e3          	beq	s0,a5,80006acc <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
80006b60:	d09ff0ef          	jal	ra,80006868 <z_tick_get>
80006b64:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
80006b68:	f60452e3          	bgez	s0,80006acc <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
80006b6c:	ff500513          	li	a0,-11
}
80006b70:	04c12083          	lw	ra,76(sp)
80006b74:	04812403          	lw	s0,72(sp)
80006b78:	04412483          	lw	s1,68(sp)
80006b7c:	04012903          	lw	s2,64(sp)
80006b80:	03c12983          	lw	s3,60(sp)
80006b84:	03812a03          	lw	s4,56(sp)
80006b88:	03412a83          	lw	s5,52(sp)
80006b8c:	03012b03          	lw	s6,48(sp)
80006b90:	02c12b83          	lw	s7,44(sp)
80006b94:	02812c03          	lw	s8,40(sp)
80006b98:	02412c83          	lw	s9,36(sp)
80006b9c:	02012d03          	lw	s10,32(sp)
80006ba0:	01c12d83          	lw	s11,28(sp)
80006ba4:	05010113          	addi	sp,sp,80
80006ba8:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80006bac:	80008937          	lui	s2,0x80008
80006bb0:	800085b7          	lui	a1,0x80008
80006bb4:	80008537          	lui	a0,0x80008
80006bb8:	4fc58593          	addi	a1,a1,1276 # 800084fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800084fd>
80006bbc:	03900693          	li	a3,57
80006bc0:	4e890613          	addi	a2,s2,1256 # 800084e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800084e9>
80006bc4:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006bc8:	efdfb0ef          	jal	ra,80002ac4 <printk>
80006bcc:	80008537          	lui	a0,0x80008
80006bd0:	f7c50513          	addi	a0,a0,-132 # 80007f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f7d>
80006bd4:	ef1fb0ef          	jal	ra,80002ac4 <printk>
80006bd8:	03900593          	li	a1,57
80006bdc:	4e890513          	addi	a0,s2,1256
80006be0:	f21fb0ef          	jal	ra,80002b00 <assert_post_action>
	if (timeout > 0) {
80006be4:	ea8052e3          	blez	s0,80006a88 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80006be8:	c81ff0ef          	jal	ra,80006868 <z_tick_get>
80006bec:	00050913          	mv	s2,a0
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80006bf0:	00a00593          	li	a1,10
80006bf4:	00940513          	addi	a0,s0,9
80006bf8:	d51f90ef          	jal	ra,80000948 <__divsi3>
80006bfc:	01250933          	add	s2,a0,s2
80006c00:	e8dff06f          	j	80006a8c <k_mem_pool_alloc+0x5c>

80006c04 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006c04:	00054783          	lbu	a5,0(a0)
{
80006c08:	fe010113          	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006c0c:	00052603          	lw	a2,0(a0)
{
80006c10:	00812c23          	sw	s0,24(sp)
80006c14:	00379413          	slli	s0,a5,0x3
80006c18:	01212823          	sw	s2,16(sp)
80006c1c:	40f40433          	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006c20:	80008937          	lui	s2,0x80008
80006c24:	00241413          	slli	s0,s0,0x2
80006c28:	00865593          	srli	a1,a2,0x8
80006c2c:	6ac90513          	addi	a0,s2,1708 # 800086ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800086ad>
80006c30:	00c65613          	srli	a2,a2,0xc
80006c34:	00f5f593          	andi	a1,a1,15
80006c38:	00850533          	add	a0,a0,s0
{
80006c3c:	00112e23          	sw	ra,28(sp)
80006c40:	00912a23          	sw	s1,20(sp)
80006c44:	01312623          	sw	s3,12(sp)
80006c48:	01412423          	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80006c4c:	d10fb0ef          	jal	ra,8000215c <z_sys_mem_pool_block_free>
80006c50:	00800593          	li	a1,8
80006c54:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006c58:	800084b7          	lui	s1,0x80008
80006c5c:	70848513          	addi	a0,s1,1800 # 80008708 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008709>
	key = (mstatus & SOC_MSTATUS_IEN);
80006c60:	0085f993          	andi	s3,a1,8
80006c64:	f59fe0ef          	jal	ra,80005bbc <z_spin_lock_valid>
80006c68:	6ac90913          	addi	s2,s2,1708
80006c6c:	02051e63          	bnez	a0,80006ca8 <k_mem_pool_free_id+0xa4>
80006c70:	80008a37          	lui	s4,0x80008
80006c74:	800085b7          	lui	a1,0x80008
80006c78:	80008537          	lui	a0,0x80008
80006c7c:	fdc58593          	addi	a1,a1,-36 # 80007fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fdd>
80006c80:	04e00693          	li	a3,78
80006c84:	fc4a0613          	addi	a2,s4,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80006c88:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006c8c:	e39fb0ef          	jal	ra,80002ac4 <printk>
80006c90:	80008537          	lui	a0,0x80008
80006c94:	ff450513          	addi	a0,a0,-12 # 80007ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ff5>
80006c98:	e2dfb0ef          	jal	ra,80002ac4 <printk>
80006c9c:	04e00593          	li	a1,78
80006ca0:	fc4a0513          	addi	a0,s4,-60
80006ca4:	e5dfb0ef          	jal	ra,80002b00 <assert_post_action>
	z_spin_lock_set_owner(l);
80006ca8:	70848513          	addi	a0,s1,1800
80006cac:	f69fe0ef          	jal	ra,80005c14 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80006cb0:	01440513          	addi	a0,s0,20
80006cb4:	00a90533          	add	a0,s2,a0
80006cb8:	c84fe0ef          	jal	ra,8000513c <z_unpend_all>

	if (need_sched != 0) {
80006cbc:	02050663          	beqz	a0,80006ce8 <k_mem_pool_free_id+0xe4>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
80006cc0:	01812403          	lw	s0,24(sp)
80006cc4:	01c12083          	lw	ra,28(sp)
80006cc8:	01012903          	lw	s2,16(sp)
80006ccc:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80006cd0:	00098593          	mv	a1,s3
80006cd4:	70848513          	addi	a0,s1,1800
}
80006cd8:	00c12983          	lw	s3,12(sp)
80006cdc:	01412483          	lw	s1,20(sp)
80006ce0:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80006ce4:	a48fd06f          	j	80003f2c <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006ce8:	70848513          	addi	a0,s1,1800
80006cec:	ef9fe0ef          	jal	ra,80005be4 <z_spin_unlock_valid>
80006cf0:	02051e63          	bnez	a0,80006d2c <k_mem_pool_free_id+0x128>
80006cf4:	80008437          	lui	s0,0x80008
80006cf8:	800085b7          	lui	a1,0x80008
80006cfc:	80008537          	lui	a0,0x80008
80006d00:	00c58593          	addi	a1,a1,12 # 8000800c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000800d>
80006d04:	06100693          	li	a3,97
80006d08:	fc440613          	addi	a2,s0,-60 # 80007fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007fc5>
80006d0c:	ef850513          	addi	a0,a0,-264 # 80007ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef9>
80006d10:	db5fb0ef          	jal	ra,80002ac4 <printk>
80006d14:	80008537          	lui	a0,0x80008
80006d18:	02450513          	addi	a0,a0,36 # 80008024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008025>
80006d1c:	da9fb0ef          	jal	ra,80002ac4 <printk>
80006d20:	06100593          	li	a1,97
80006d24:	fc440513          	addi	a0,s0,-60
80006d28:	dd9fb0ef          	jal	ra,80002b00 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006d2c:	3009a5f3          	csrrs	a1,mstatus,s3
}
80006d30:	01c12083          	lw	ra,28(sp)
80006d34:	01812403          	lw	s0,24(sp)
80006d38:	01412483          	lw	s1,20(sp)
80006d3c:	01012903          	lw	s2,16(sp)
80006d40:	00c12983          	lw	s3,12(sp)
80006d44:	00812a03          	lw	s4,8(sp)
80006d48:	02010113          	addi	sp,sp,32
80006d4c:	00008067          	ret

80006d50 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
80006d50:	00458613          	addi	a2,a1,4
80006d54:	00b67e63          	bgeu	a2,a1,80006d70 <k_mem_pool_malloc+0x20>
				   &size)) {
		return NULL;
80006d58:	00000513          	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
80006d5c:	00008067          	ret
		return NULL;
80006d60:	00000513          	li	a0,0
}
80006d64:	01c12083          	lw	ra,28(sp)
80006d68:	02010113          	addi	sp,sp,32
80006d6c:	00008067          	ret
{
80006d70:	fe010113          	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80006d74:	00000693          	li	a3,0
80006d78:	00810593          	addi	a1,sp,8
{
80006d7c:	00112e23          	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80006d80:	cb1ff0ef          	jal	ra,80006a30 <k_mem_pool_alloc>
80006d84:	fc051ee3          	bnez	a0,80006d60 <k_mem_pool_malloc+0x10>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
80006d88:	00812503          	lw	a0,8(sp)
80006d8c:	00400613          	li	a2,4
80006d90:	00c10593          	addi	a1,sp,12
80006d94:	b2cfc0ef          	jal	ra,800030c0 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80006d98:	00812503          	lw	a0,8(sp)
80006d9c:	00450513          	addi	a0,a0,4
80006da0:	fc5ff06f          	j	80006d64 <k_mem_pool_malloc+0x14>

80006da4 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
80006da4:	00050663          	beqz	a0,80006db0 <k_free+0xc>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
80006da8:	ffc50513          	addi	a0,a0,-4
80006dac:	e59ff06f          	j	80006c04 <k_mem_pool_free_id>
	}
}
80006db0:	00008067          	ret

80006db4 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
80006db4:	800097b7          	lui	a5,0x80009
80006db8:	d447a783          	lw	a5,-700(a5) # 80008d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008d45>
{
80006dbc:	00050593          	mv	a1,a0
	if (_current->resource_pool != NULL) {
80006dc0:	0687a503          	lw	a0,104(a5)
80006dc4:	00050463          	beqz	a0,80006dcc <z_thread_malloc+0x18>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80006dc8:	f89ff06f          	j	80006d50 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
80006dcc:	00000513          	li	a0,0
80006dd0:	00008067          	ret

80006dd4 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80006dd4:	00008067          	ret
