
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01428293          	addi	t0,t0,20 # 80000014 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	1890006f          	j	80000994 <__initialize>
	...

Disassembly of section exceptions:

80000014 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000014:	715d                	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000016:	c006                	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	c20e                	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001a:	c412                	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
8000001c:	c616                	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
8000001e:	c81a                	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000020:	ca1e                	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
80000022:	cc72                	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000024:	ce76                	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000026:	d07a                	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000028:	d27e                	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000002a:	d42a                	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
8000002c:	d62e                	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
8000002e:	d832                	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000030:	da36                	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
80000032:	dc3a                	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000034:	de3e                	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000036:	c0c2                	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000038:	c2c6                	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000003a:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000003e:	c496                	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000040:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000044:	c696                	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
80000046:	1be000ef          	jal	ra,80000204 <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
8000004a:	00000313          	li	t1,0
	bnez a0, is_interrupt
8000004e:	e121                	bnez	a0,8000008e <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000050:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
80000054:	800003b7          	lui	t2,0x80000
80000058:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
8000005c:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000060:	432d                	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
80000062:	00628a63          	beq	t0,t1,80000076 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000066:	00010513          	mv	a0,sp
	la ra, no_reschedule
8000006a:	00000097          	auipc	ra,0x0
8000006e:	12e08093          	addi	ra,ra,302 # 80000198 <no_reschedule>
	tail _Fault
80000072:	5fe0106f          	j	80001670 <_Fault>

80000076 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000076:	42a6                	lw	t0,72(sp)
	addi t0, t0, 4
80000078:	0291                	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000007a:	c496                	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
8000007c:	00007297          	auipc	t0,0x7
80000080:	e2828293          	addi	t0,t0,-472 # 80006ea4 <_offload_routine>
	lw t1, 0x00(t0)
80000084:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
80000088:	00031363          	bnez	t1,8000008e <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
8000008c:	a041                	j	8000010c <reschedule>

8000008e <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
8000008e:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
80000092:	00007397          	auipc	t2,0x7
80000096:	47a38393          	addi	t2,t2,1146 # 8000750c <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
8000009a:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
8000009e:	1141                	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000a0:	c016                	sw	t0,0(sp)

800000a2 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000a2:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000a6:	0e05                	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000a8:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000ac:	00030863          	beqz	t1,800000bc <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000b0:	00000097          	auipc	ra,0x0
800000b4:	03808093          	addi	ra,ra,56 # 800000e8 <on_thread_stack>
	tail z_irq_do_offload
800000b8:	61e0106f          	j	800016d6 <z_irq_do_offload>

800000bc <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000bc:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000c0:	800002b7          	lui	t0,0x80000
800000c4:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000c8:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000cc:	128000ef          	jal	ra,800001f4 <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000d0:	00005297          	auipc	t0,0x5
800000d4:	4d828293          	addi	t0,t0,1240 # 800055a8 <_sw_isr_table>
	slli a0, a0, 3
800000d8:	050e                	slli	a0,a0,0x3
	add t0, t0, a0
800000da:	92aa                	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
800000dc:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
800000e0:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
800000e4:	000300e7          	jalr	t1

800000e8 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
800000e8:	00007317          	auipc	t1,0x7
800000ec:	42430313          	addi	t1,t1,1060 # 8000750c <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
800000f0:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
800000f4:	13fd                	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
800000f6:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
800000fa:	4282                	lw	t0,0(sp)
	addi sp, t0, 0
800000fc:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000100:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000104:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000108:	087e0863          	beq	t3,t2,80000198 <no_reschedule>

8000010c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000010c:	00007297          	auipc	t0,0x7
80000110:	40028293          	addi	t0,t0,1024 # 8000750c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000114:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000118:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000011c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000120:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000124:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000128:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000012c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000130:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000134:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000138:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000013c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000140:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000144:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000148:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000014c:	00007397          	auipc	t2,0x7
80000150:	cf838393          	addi	t2,t2,-776 # 80006e44 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000154:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000158:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000015c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000160:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000164:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000168:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000016c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
80000170:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
80000174:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
80000178:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
8000017c:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
80000180:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
80000184:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
80000188:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
8000018c:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
80000190:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
80000194:	05832d83          	lw	s11,88(t1)

80000198 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000198:	42a6                	lw	t0,72(sp)
	csrw mepc, t0
8000019a:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
8000019e:	42b6                	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001a0:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001a4:	4082                	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001a6:	4192                	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001a8:	4222                	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001aa:	42b2                	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001ac:	4342                	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ae:	43d2                	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001b0:	4e62                	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001b2:	4ef2                	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001b4:	5f02                	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001b6:	5f92                	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
800001b8:	5522                	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
800001ba:	55b2                	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
800001bc:	5642                	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
800001be:	56d2                	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
800001c0:	5762                	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
800001c2:	57f2                	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
800001c4:	4806                	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
800001c6:	4896                	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
800001c8:	6161                	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
800001ca:	30200073          	mret
	...

800001d0 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
800001d0:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
800001d4:	00007297          	auipc	t0,0x7
800001d8:	33828293          	addi	t0,t0,824 # 8000750c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
800001dc:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
800001e0:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
800001e4:	8921                	andi	a0,a0,8
	csrrs t0, mstatus, a0
800001e6:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
800001ea:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
800001ee:	00008067          	ret
	...

800001f4 <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
800001f4:	4305                	li	t1,1
	sll t0, t1, a0
800001f6:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
800001fa:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
800001fe:	00008067          	ret
	...

80000204 <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
80000204:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000208:	80000337          	lui	t1,0x80000
	and t0, t0, t1
8000020c:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000210:	00000513          	li	a0,0
	beqz t0, not_interrupt
80000214:	00028363          	beqz	t0,8000021a <not_interrupt>
	addi a0, a0, 1
80000218:	0505                	addi	a0,a0,1

8000021a <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
8000021a:	00008067          	ret

Disassembly of section text:

80000220 <__lshrdi3>:
80000220:	02060063          	beqz	a2,80000240 <__lshrdi3+0x20>
80000224:	02000793          	li	a5,32
80000228:	40c787b3          	sub	a5,a5,a2
8000022c:	00f04c63          	bgtz	a5,80000244 <__lshrdi3+0x24>
80000230:	fe060513          	addi	a0,a2,-32
80000234:	00000713          	li	a4,0
80000238:	00a5d533          	srl	a0,a1,a0
8000023c:	00070593          	mv	a1,a4
80000240:	00008067          	ret
80000244:	00c5d733          	srl	a4,a1,a2
80000248:	00c55533          	srl	a0,a0,a2
8000024c:	00f595b3          	sll	a1,a1,a5
80000250:	00b56533          	or	a0,a0,a1
80000254:	fe9ff06f          	j	8000023c <__lshrdi3+0x1c>

80000258 <__udivdi3>:
80000258:	fd010113          	addi	sp,sp,-48
8000025c:	02912223          	sw	s1,36(sp)
80000260:	01612823          	sw	s6,16(sp)
80000264:	02112623          	sw	ra,44(sp)
80000268:	02812423          	sw	s0,40(sp)
8000026c:	03212023          	sw	s2,32(sp)
80000270:	01312e23          	sw	s3,28(sp)
80000274:	01412c23          	sw	s4,24(sp)
80000278:	01512a23          	sw	s5,20(sp)
8000027c:	01712623          	sw	s7,12(sp)
80000280:	01812423          	sw	s8,8(sp)
80000284:	01912223          	sw	s9,4(sp)
80000288:	00050b13          	mv	s6,a0
8000028c:	00058493          	mv	s1,a1
80000290:	38069c63          	bnez	a3,80000628 <__udivdi3+0x3d0>
80000294:	00060413          	mv	s0,a2
80000298:	00050993          	mv	s3,a0
8000029c:	00005917          	auipc	s2,0x5
800002a0:	49c90913          	addi	s2,s2,1180 # 80005738 <__clz_tab>
800002a4:	12c5f863          	bgeu	a1,a2,800003d4 <__udivdi3+0x17c>
800002a8:	000107b7          	lui	a5,0x10
800002ac:	00058a93          	mv	s5,a1
800002b0:	10f67863          	bgeu	a2,a5,800003c0 <__udivdi3+0x168>
800002b4:	0ff00693          	li	a3,255
800002b8:	00c6b6b3          	sltu	a3,a3,a2
800002bc:	00369693          	slli	a3,a3,0x3
800002c0:	00d657b3          	srl	a5,a2,a3
800002c4:	00f90933          	add	s2,s2,a5
800002c8:	00094703          	lbu	a4,0(s2)
800002cc:	00d706b3          	add	a3,a4,a3
800002d0:	02000713          	li	a4,32
800002d4:	40d70733          	sub	a4,a4,a3
800002d8:	00070c63          	beqz	a4,800002f0 <__udivdi3+0x98>
800002dc:	00e494b3          	sll	s1,s1,a4
800002e0:	00db56b3          	srl	a3,s6,a3
800002e4:	00e61433          	sll	s0,a2,a4
800002e8:	0096eab3          	or	s5,a3,s1
800002ec:	00eb19b3          	sll	s3,s6,a4
800002f0:	01045b13          	srli	s6,s0,0x10
800002f4:	000b0593          	mv	a1,s6
800002f8:	000a8513          	mv	a0,s5
800002fc:	634000ef          	jal	ra,80000930 <__umodsi3>
80000300:	00050913          	mv	s2,a0
80000304:	000b0593          	mv	a1,s6
80000308:	01041b93          	slli	s7,s0,0x10
8000030c:	000a8513          	mv	a0,s5
80000310:	5d8000ef          	jal	ra,800008e8 <__udivsi3>
80000314:	010bdb93          	srli	s7,s7,0x10
80000318:	00050493          	mv	s1,a0
8000031c:	00050593          	mv	a1,a0
80000320:	000b8513          	mv	a0,s7
80000324:	508000ef          	jal	ra,8000082c <__mulsi3>
80000328:	01091913          	slli	s2,s2,0x10
8000032c:	0109d713          	srli	a4,s3,0x10
80000330:	00e96733          	or	a4,s2,a4
80000334:	00048a13          	mv	s4,s1
80000338:	00a77e63          	bgeu	a4,a0,80000354 <__udivdi3+0xfc>
8000033c:	00870733          	add	a4,a4,s0
80000340:	fff48a13          	addi	s4,s1,-1
80000344:	00876863          	bltu	a4,s0,80000354 <__udivdi3+0xfc>
80000348:	00a77663          	bgeu	a4,a0,80000354 <__udivdi3+0xfc>
8000034c:	ffe48a13          	addi	s4,s1,-2
80000350:	00870733          	add	a4,a4,s0
80000354:	40a704b3          	sub	s1,a4,a0
80000358:	000b0593          	mv	a1,s6
8000035c:	00048513          	mv	a0,s1
80000360:	5d0000ef          	jal	ra,80000930 <__umodsi3>
80000364:	00050913          	mv	s2,a0
80000368:	000b0593          	mv	a1,s6
8000036c:	00048513          	mv	a0,s1
80000370:	578000ef          	jal	ra,800008e8 <__udivsi3>
80000374:	01099993          	slli	s3,s3,0x10
80000378:	00050493          	mv	s1,a0
8000037c:	00050593          	mv	a1,a0
80000380:	01091913          	slli	s2,s2,0x10
80000384:	000b8513          	mv	a0,s7
80000388:	0109d993          	srli	s3,s3,0x10
8000038c:	4a0000ef          	jal	ra,8000082c <__mulsi3>
80000390:	013969b3          	or	s3,s2,s3
80000394:	00048613          	mv	a2,s1
80000398:	00a9fc63          	bgeu	s3,a0,800003b0 <__udivdi3+0x158>
8000039c:	013409b3          	add	s3,s0,s3
800003a0:	fff48613          	addi	a2,s1,-1
800003a4:	0089e663          	bltu	s3,s0,800003b0 <__udivdi3+0x158>
800003a8:	00a9f463          	bgeu	s3,a0,800003b0 <__udivdi3+0x158>
800003ac:	ffe48613          	addi	a2,s1,-2
800003b0:	010a1793          	slli	a5,s4,0x10
800003b4:	00c7e7b3          	or	a5,a5,a2
800003b8:	00000a13          	li	s4,0
800003bc:	1300006f          	j	800004ec <__udivdi3+0x294>
800003c0:	010007b7          	lui	a5,0x1000
800003c4:	01000693          	li	a3,16
800003c8:	eef66ce3          	bltu	a2,a5,800002c0 <__udivdi3+0x68>
800003cc:	01800693          	li	a3,24
800003d0:	ef1ff06f          	j	800002c0 <__udivdi3+0x68>
800003d4:	00068a13          	mv	s4,a3
800003d8:	00061a63          	bnez	a2,800003ec <__udivdi3+0x194>
800003dc:	00000593          	li	a1,0
800003e0:	00100513          	li	a0,1
800003e4:	504000ef          	jal	ra,800008e8 <__udivsi3>
800003e8:	00050413          	mv	s0,a0
800003ec:	000107b7          	lui	a5,0x10
800003f0:	12f47c63          	bgeu	s0,a5,80000528 <__udivdi3+0x2d0>
800003f4:	0ff00793          	li	a5,255
800003f8:	0087f463          	bgeu	a5,s0,80000400 <__udivdi3+0x1a8>
800003fc:	00800a13          	li	s4,8
80000400:	014457b3          	srl	a5,s0,s4
80000404:	00f90933          	add	s2,s2,a5
80000408:	00094683          	lbu	a3,0(s2)
8000040c:	02000613          	li	a2,32
80000410:	014686b3          	add	a3,a3,s4
80000414:	40d60633          	sub	a2,a2,a3
80000418:	12061263          	bnez	a2,8000053c <__udivdi3+0x2e4>
8000041c:	408484b3          	sub	s1,s1,s0
80000420:	00100a13          	li	s4,1
80000424:	01045b13          	srli	s6,s0,0x10
80000428:	000b0593          	mv	a1,s6
8000042c:	00048513          	mv	a0,s1
80000430:	500000ef          	jal	ra,80000930 <__umodsi3>
80000434:	00050913          	mv	s2,a0
80000438:	000b0593          	mv	a1,s6
8000043c:	00048513          	mv	a0,s1
80000440:	01041b93          	slli	s7,s0,0x10
80000444:	4a4000ef          	jal	ra,800008e8 <__udivsi3>
80000448:	010bdb93          	srli	s7,s7,0x10
8000044c:	00050493          	mv	s1,a0
80000450:	00050593          	mv	a1,a0
80000454:	000b8513          	mv	a0,s7
80000458:	3d4000ef          	jal	ra,8000082c <__mulsi3>
8000045c:	01091913          	slli	s2,s2,0x10
80000460:	0109d713          	srli	a4,s3,0x10
80000464:	00e96733          	or	a4,s2,a4
80000468:	00048a93          	mv	s5,s1
8000046c:	00a77e63          	bgeu	a4,a0,80000488 <__udivdi3+0x230>
80000470:	00870733          	add	a4,a4,s0
80000474:	fff48a93          	addi	s5,s1,-1
80000478:	00876863          	bltu	a4,s0,80000488 <__udivdi3+0x230>
8000047c:	00a77663          	bgeu	a4,a0,80000488 <__udivdi3+0x230>
80000480:	ffe48a93          	addi	s5,s1,-2
80000484:	00870733          	add	a4,a4,s0
80000488:	40a704b3          	sub	s1,a4,a0
8000048c:	000b0593          	mv	a1,s6
80000490:	00048513          	mv	a0,s1
80000494:	49c000ef          	jal	ra,80000930 <__umodsi3>
80000498:	00050913          	mv	s2,a0
8000049c:	000b0593          	mv	a1,s6
800004a0:	00048513          	mv	a0,s1
800004a4:	444000ef          	jal	ra,800008e8 <__udivsi3>
800004a8:	01099993          	slli	s3,s3,0x10
800004ac:	00050493          	mv	s1,a0
800004b0:	00050593          	mv	a1,a0
800004b4:	01091913          	slli	s2,s2,0x10
800004b8:	000b8513          	mv	a0,s7
800004bc:	0109d993          	srli	s3,s3,0x10
800004c0:	36c000ef          	jal	ra,8000082c <__mulsi3>
800004c4:	013969b3          	or	s3,s2,s3
800004c8:	00048613          	mv	a2,s1
800004cc:	00a9fc63          	bgeu	s3,a0,800004e4 <__udivdi3+0x28c>
800004d0:	013409b3          	add	s3,s0,s3
800004d4:	fff48613          	addi	a2,s1,-1
800004d8:	0089e663          	bltu	s3,s0,800004e4 <__udivdi3+0x28c>
800004dc:	00a9f463          	bgeu	s3,a0,800004e4 <__udivdi3+0x28c>
800004e0:	ffe48613          	addi	a2,s1,-2
800004e4:	010a9793          	slli	a5,s5,0x10
800004e8:	00c7e7b3          	or	a5,a5,a2
800004ec:	00078513          	mv	a0,a5
800004f0:	000a0593          	mv	a1,s4
800004f4:	02c12083          	lw	ra,44(sp)
800004f8:	02812403          	lw	s0,40(sp)
800004fc:	02412483          	lw	s1,36(sp)
80000500:	02012903          	lw	s2,32(sp)
80000504:	01c12983          	lw	s3,28(sp)
80000508:	01812a03          	lw	s4,24(sp)
8000050c:	01412a83          	lw	s5,20(sp)
80000510:	01012b03          	lw	s6,16(sp)
80000514:	00c12b83          	lw	s7,12(sp)
80000518:	00812c03          	lw	s8,8(sp)
8000051c:	00412c83          	lw	s9,4(sp)
80000520:	03010113          	addi	sp,sp,48
80000524:	00008067          	ret
80000528:	010007b7          	lui	a5,0x1000
8000052c:	01000a13          	li	s4,16
80000530:	ecf468e3          	bltu	s0,a5,80000400 <__udivdi3+0x1a8>
80000534:	01800a13          	li	s4,24
80000538:	ec9ff06f          	j	80000400 <__udivdi3+0x1a8>
8000053c:	00c41433          	sll	s0,s0,a2
80000540:	00d4da33          	srl	s4,s1,a3
80000544:	00cb19b3          	sll	s3,s6,a2
80000548:	00db56b3          	srl	a3,s6,a3
8000054c:	01045b13          	srli	s6,s0,0x10
80000550:	00c494b3          	sll	s1,s1,a2
80000554:	000b0593          	mv	a1,s6
80000558:	000a0513          	mv	a0,s4
8000055c:	0096eab3          	or	s5,a3,s1
80000560:	3d0000ef          	jal	ra,80000930 <__umodsi3>
80000564:	00050913          	mv	s2,a0
80000568:	000b0593          	mv	a1,s6
8000056c:	000a0513          	mv	a0,s4
80000570:	01041b93          	slli	s7,s0,0x10
80000574:	374000ef          	jal	ra,800008e8 <__udivsi3>
80000578:	010bdb93          	srli	s7,s7,0x10
8000057c:	00050493          	mv	s1,a0
80000580:	00050593          	mv	a1,a0
80000584:	000b8513          	mv	a0,s7
80000588:	2a4000ef          	jal	ra,8000082c <__mulsi3>
8000058c:	01091913          	slli	s2,s2,0x10
80000590:	010ad713          	srli	a4,s5,0x10
80000594:	00e96733          	or	a4,s2,a4
80000598:	00048a13          	mv	s4,s1
8000059c:	00a77e63          	bgeu	a4,a0,800005b8 <__udivdi3+0x360>
800005a0:	00870733          	add	a4,a4,s0
800005a4:	fff48a13          	addi	s4,s1,-1
800005a8:	00876863          	bltu	a4,s0,800005b8 <__udivdi3+0x360>
800005ac:	00a77663          	bgeu	a4,a0,800005b8 <__udivdi3+0x360>
800005b0:	ffe48a13          	addi	s4,s1,-2
800005b4:	00870733          	add	a4,a4,s0
800005b8:	40a704b3          	sub	s1,a4,a0
800005bc:	000b0593          	mv	a1,s6
800005c0:	00048513          	mv	a0,s1
800005c4:	36c000ef          	jal	ra,80000930 <__umodsi3>
800005c8:	00050913          	mv	s2,a0
800005cc:	000b0593          	mv	a1,s6
800005d0:	00048513          	mv	a0,s1
800005d4:	314000ef          	jal	ra,800008e8 <__udivsi3>
800005d8:	00050493          	mv	s1,a0
800005dc:	00050593          	mv	a1,a0
800005e0:	000b8513          	mv	a0,s7
800005e4:	248000ef          	jal	ra,8000082c <__mulsi3>
800005e8:	010a9693          	slli	a3,s5,0x10
800005ec:	01091913          	slli	s2,s2,0x10
800005f0:	0106d693          	srli	a3,a3,0x10
800005f4:	00d967b3          	or	a5,s2,a3
800005f8:	00048713          	mv	a4,s1
800005fc:	00a7fe63          	bgeu	a5,a0,80000618 <__udivdi3+0x3c0>
80000600:	008787b3          	add	a5,a5,s0
80000604:	fff48713          	addi	a4,s1,-1
80000608:	0087e863          	bltu	a5,s0,80000618 <__udivdi3+0x3c0>
8000060c:	00a7f663          	bgeu	a5,a0,80000618 <__udivdi3+0x3c0>
80000610:	ffe48713          	addi	a4,s1,-2
80000614:	008787b3          	add	a5,a5,s0
80000618:	010a1a13          	slli	s4,s4,0x10
8000061c:	40a784b3          	sub	s1,a5,a0
80000620:	00ea6a33          	or	s4,s4,a4
80000624:	e01ff06f          	j	80000424 <__udivdi3+0x1cc>
80000628:	1ed5ec63          	bltu	a1,a3,80000820 <__udivdi3+0x5c8>
8000062c:	000107b7          	lui	a5,0x10
80000630:	04f6f463          	bgeu	a3,a5,80000678 <__udivdi3+0x420>
80000634:	0ff00593          	li	a1,255
80000638:	00d5b533          	sltu	a0,a1,a3
8000063c:	00351513          	slli	a0,a0,0x3
80000640:	00a6d733          	srl	a4,a3,a0
80000644:	00005797          	auipc	a5,0x5
80000648:	0f478793          	addi	a5,a5,244 # 80005738 <__clz_tab>
8000064c:	00e787b3          	add	a5,a5,a4
80000650:	0007c583          	lbu	a1,0(a5)
80000654:	02000a13          	li	s4,32
80000658:	00a585b3          	add	a1,a1,a0
8000065c:	40ba0a33          	sub	s4,s4,a1
80000660:	020a1663          	bnez	s4,8000068c <__udivdi3+0x434>
80000664:	00100793          	li	a5,1
80000668:	e896e2e3          	bltu	a3,s1,800004ec <__udivdi3+0x294>
8000066c:	00cb3633          	sltu	a2,s6,a2
80000670:	00164793          	xori	a5,a2,1
80000674:	e79ff06f          	j	800004ec <__udivdi3+0x294>
80000678:	010007b7          	lui	a5,0x1000
8000067c:	01000513          	li	a0,16
80000680:	fcf6e0e3          	bltu	a3,a5,80000640 <__udivdi3+0x3e8>
80000684:	01800513          	li	a0,24
80000688:	fb9ff06f          	j	80000640 <__udivdi3+0x3e8>
8000068c:	00b65ab3          	srl	s5,a2,a1
80000690:	014696b3          	sll	a3,a3,s4
80000694:	00daeab3          	or	s5,s5,a3
80000698:	00b4d933          	srl	s2,s1,a1
8000069c:	014497b3          	sll	a5,s1,s4
800006a0:	00bb55b3          	srl	a1,s6,a1
800006a4:	010adb93          	srli	s7,s5,0x10
800006a8:	00f5e4b3          	or	s1,a1,a5
800006ac:	00090513          	mv	a0,s2
800006b0:	000b8593          	mv	a1,s7
800006b4:	014619b3          	sll	s3,a2,s4
800006b8:	278000ef          	jal	ra,80000930 <__umodsi3>
800006bc:	00050413          	mv	s0,a0
800006c0:	000b8593          	mv	a1,s7
800006c4:	00090513          	mv	a0,s2
800006c8:	010a9c13          	slli	s8,s5,0x10
800006cc:	21c000ef          	jal	ra,800008e8 <__udivsi3>
800006d0:	010c5c13          	srli	s8,s8,0x10
800006d4:	00050913          	mv	s2,a0
800006d8:	00050593          	mv	a1,a0
800006dc:	000c0513          	mv	a0,s8
800006e0:	14c000ef          	jal	ra,8000082c <__mulsi3>
800006e4:	01041413          	slli	s0,s0,0x10
800006e8:	0104d713          	srli	a4,s1,0x10
800006ec:	00e46733          	or	a4,s0,a4
800006f0:	00090c93          	mv	s9,s2
800006f4:	00a77e63          	bgeu	a4,a0,80000710 <__udivdi3+0x4b8>
800006f8:	01570733          	add	a4,a4,s5
800006fc:	fff90c93          	addi	s9,s2,-1
80000700:	01576863          	bltu	a4,s5,80000710 <__udivdi3+0x4b8>
80000704:	00a77663          	bgeu	a4,a0,80000710 <__udivdi3+0x4b8>
80000708:	ffe90c93          	addi	s9,s2,-2
8000070c:	01570733          	add	a4,a4,s5
80000710:	40a70933          	sub	s2,a4,a0
80000714:	000b8593          	mv	a1,s7
80000718:	00090513          	mv	a0,s2
8000071c:	214000ef          	jal	ra,80000930 <__umodsi3>
80000720:	00050413          	mv	s0,a0
80000724:	000b8593          	mv	a1,s7
80000728:	00090513          	mv	a0,s2
8000072c:	1bc000ef          	jal	ra,800008e8 <__udivsi3>
80000730:	00050913          	mv	s2,a0
80000734:	00050593          	mv	a1,a0
80000738:	000c0513          	mv	a0,s8
8000073c:	0f0000ef          	jal	ra,8000082c <__mulsi3>
80000740:	01049793          	slli	a5,s1,0x10
80000744:	01041413          	slli	s0,s0,0x10
80000748:	0107d793          	srli	a5,a5,0x10
8000074c:	00f46733          	or	a4,s0,a5
80000750:	00090613          	mv	a2,s2
80000754:	00a77e63          	bgeu	a4,a0,80000770 <__udivdi3+0x518>
80000758:	01570733          	add	a4,a4,s5
8000075c:	fff90613          	addi	a2,s2,-1
80000760:	01576863          	bltu	a4,s5,80000770 <__udivdi3+0x518>
80000764:	00a77663          	bgeu	a4,a0,80000770 <__udivdi3+0x518>
80000768:	ffe90613          	addi	a2,s2,-2
8000076c:	01570733          	add	a4,a4,s5
80000770:	010c9793          	slli	a5,s9,0x10
80000774:	00010e37          	lui	t3,0x10
80000778:	00c7e7b3          	or	a5,a5,a2
8000077c:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000780:	0107f333          	and	t1,a5,a6
80000784:	0109f833          	and	a6,s3,a6
80000788:	40a70733          	sub	a4,a4,a0
8000078c:	0107de93          	srli	t4,a5,0x10
80000790:	0109d993          	srli	s3,s3,0x10
80000794:	00030513          	mv	a0,t1
80000798:	00080593          	mv	a1,a6
8000079c:	090000ef          	jal	ra,8000082c <__mulsi3>
800007a0:	00050893          	mv	a7,a0
800007a4:	00098593          	mv	a1,s3
800007a8:	00030513          	mv	a0,t1
800007ac:	080000ef          	jal	ra,8000082c <__mulsi3>
800007b0:	00050313          	mv	t1,a0
800007b4:	00080593          	mv	a1,a6
800007b8:	000e8513          	mv	a0,t4
800007bc:	070000ef          	jal	ra,8000082c <__mulsi3>
800007c0:	00050813          	mv	a6,a0
800007c4:	00098593          	mv	a1,s3
800007c8:	000e8513          	mv	a0,t4
800007cc:	060000ef          	jal	ra,8000082c <__mulsi3>
800007d0:	0108d693          	srli	a3,a7,0x10
800007d4:	01030333          	add	t1,t1,a6
800007d8:	006686b3          	add	a3,a3,t1
800007dc:	0106f463          	bgeu	a3,a6,800007e4 <__udivdi3+0x58c>
800007e0:	01c50533          	add	a0,a0,t3
800007e4:	0106d613          	srli	a2,a3,0x10
800007e8:	00a60533          	add	a0,a2,a0
800007ec:	02a76663          	bltu	a4,a0,80000818 <__udivdi3+0x5c0>
800007f0:	bca714e3          	bne	a4,a0,800003b8 <__udivdi3+0x160>
800007f4:	00010737          	lui	a4,0x10
800007f8:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007fc:	00e6f6b3          	and	a3,a3,a4
80000800:	01069693          	slli	a3,a3,0x10
80000804:	00e8f8b3          	and	a7,a7,a4
80000808:	014b1633          	sll	a2,s6,s4
8000080c:	011686b3          	add	a3,a3,a7
80000810:	00000a13          	li	s4,0
80000814:	ccd67ce3          	bgeu	a2,a3,800004ec <__udivdi3+0x294>
80000818:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000081c:	b9dff06f          	j	800003b8 <__udivdi3+0x160>
80000820:	00000a13          	li	s4,0
80000824:	00000793          	li	a5,0
80000828:	cc5ff06f          	j	800004ec <__udivdi3+0x294>

8000082c <__mulsi3>:
8000082c:	00050613          	mv	a2,a0
80000830:	00000513          	li	a0,0
80000834:	0015f693          	andi	a3,a1,1
80000838:	00068463          	beqz	a3,80000840 <__mulsi3+0x14>
8000083c:	00c50533          	add	a0,a0,a2
80000840:	0015d593          	srli	a1,a1,0x1
80000844:	00161613          	slli	a2,a2,0x1
80000848:	fe0596e3          	bnez	a1,80000834 <__mulsi3+0x8>
8000084c:	00008067          	ret

80000850 <__muldi3>:
80000850:	ff010113          	addi	sp,sp,-16
80000854:	00068313          	mv	t1,a3
80000858:	00112623          	sw	ra,12(sp)
8000085c:	00050e13          	mv	t3,a0
80000860:	00050893          	mv	a7,a0
80000864:	00060693          	mv	a3,a2
80000868:	00000713          	li	a4,0
8000086c:	00000793          	li	a5,0
80000870:	00000813          	li	a6,0
80000874:	0016f513          	andi	a0,a3,1
80000878:	00171e93          	slli	t4,a4,0x1
8000087c:	00050c63          	beqz	a0,80000894 <__muldi3+0x44>
80000880:	01088533          	add	a0,a7,a6
80000884:	01053833          	sltu	a6,a0,a6
80000888:	00e787b3          	add	a5,a5,a4
8000088c:	00f807b3          	add	a5,a6,a5
80000890:	00050813          	mv	a6,a0
80000894:	01f8d713          	srli	a4,a7,0x1f
80000898:	0016d693          	srli	a3,a3,0x1
8000089c:	00eee733          	or	a4,t4,a4
800008a0:	00189893          	slli	a7,a7,0x1
800008a4:	fc0698e3          	bnez	a3,80000874 <__muldi3+0x24>
800008a8:	00058863          	beqz	a1,800008b8 <__muldi3+0x68>
800008ac:	00060513          	mv	a0,a2
800008b0:	f7dff0ef          	jal	ra,8000082c <__mulsi3>
800008b4:	00a787b3          	add	a5,a5,a0
800008b8:	00030a63          	beqz	t1,800008cc <__muldi3+0x7c>
800008bc:	000e0513          	mv	a0,t3
800008c0:	00030593          	mv	a1,t1
800008c4:	f69ff0ef          	jal	ra,8000082c <__mulsi3>
800008c8:	00f507b3          	add	a5,a0,a5
800008cc:	00c12083          	lw	ra,12(sp)
800008d0:	00080513          	mv	a0,a6
800008d4:	00078593          	mv	a1,a5
800008d8:	01010113          	addi	sp,sp,16
800008dc:	00008067          	ret

800008e0 <__divsi3>:
800008e0:	06054063          	bltz	a0,80000940 <__umodsi3+0x10>
800008e4:	0605c663          	bltz	a1,80000950 <__umodsi3+0x20>

800008e8 <__udivsi3>:
800008e8:	00058613          	mv	a2,a1
800008ec:	00050593          	mv	a1,a0
800008f0:	fff00513          	li	a0,-1
800008f4:	02060c63          	beqz	a2,8000092c <__udivsi3+0x44>
800008f8:	00100693          	li	a3,1
800008fc:	00b67a63          	bgeu	a2,a1,80000910 <__udivsi3+0x28>
80000900:	00c05863          	blez	a2,80000910 <__udivsi3+0x28>
80000904:	00161613          	slli	a2,a2,0x1
80000908:	00169693          	slli	a3,a3,0x1
8000090c:	feb66ae3          	bltu	a2,a1,80000900 <__udivsi3+0x18>
80000910:	00000513          	li	a0,0
80000914:	00c5e663          	bltu	a1,a2,80000920 <__udivsi3+0x38>
80000918:	40c585b3          	sub	a1,a1,a2
8000091c:	00d56533          	or	a0,a0,a3
80000920:	0016d693          	srli	a3,a3,0x1
80000924:	00165613          	srli	a2,a2,0x1
80000928:	fe0696e3          	bnez	a3,80000914 <__udivsi3+0x2c>
8000092c:	00008067          	ret

80000930 <__umodsi3>:
80000930:	00008293          	mv	t0,ra
80000934:	fb5ff0ef          	jal	ra,800008e8 <__udivsi3>
80000938:	00058513          	mv	a0,a1
8000093c:	00028067          	jr	t0
80000940:	40a00533          	neg	a0,a0
80000944:	0005d863          	bgez	a1,80000954 <__umodsi3+0x24>
80000948:	40b005b3          	neg	a1,a1
8000094c:	f9dff06f          	j	800008e8 <__udivsi3>
80000950:	40b005b3          	neg	a1,a1
80000954:	00008293          	mv	t0,ra
80000958:	f91ff0ef          	jal	ra,800008e8 <__udivsi3>
8000095c:	40a00533          	neg	a0,a0
80000960:	00028067          	jr	t0

80000964 <__modsi3>:
80000964:	00008293          	mv	t0,ra
80000968:	0005ca63          	bltz	a1,8000097c <__modsi3+0x18>
8000096c:	00054c63          	bltz	a0,80000984 <__modsi3+0x20>
80000970:	f79ff0ef          	jal	ra,800008e8 <__udivsi3>
80000974:	00058513          	mv	a0,a1
80000978:	00028067          	jr	t0
8000097c:	40b005b3          	neg	a1,a1
80000980:	fe0558e3          	bgez	a0,80000970 <__modsi3+0xc>
80000984:	40a00533          	neg	a0,a0
80000988:	f61ff0ef          	jal	ra,800008e8 <__udivsi3>
8000098c:	40b00533          	neg	a0,a1
80000990:	00028067          	jr	t0

80000994 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000994:	00008117          	auipc	sp,0x8
80000998:	42c10113          	addi	sp,sp,1068 # 80008dc0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
8000099c:	000012b7          	lui	t0,0x1
800009a0:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
800009a4:	9116                	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
800009a6:	573000ef          	jal	ra,80001718 <_PrepC>
	...

800009ac <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
800009ac:	3b60106f          	j	80001d62 <z_thread_entry>
	...

800009b2 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009b2:	8082                	ret

800009b4 <thread_helper>:
 *
 * @return N/A
 */

static void thread_helper(void *arg1, void *arg2, void *arg3)
{
800009b4:	1141                	addi	sp,sp,-16
800009b6:	c422                	sw	s0,8(sp)

	/*
	 * This thread starts off at a higher priority than thread_entry().
	 * Thus, it should execute immediately.
	 */
	thread_evidence++;
800009b8:	80007437          	lui	s0,0x80007
800009bc:	ea040413          	addi	s0,s0,-352 # 80006ea0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea1>
800009c0:	401c                	lw	a5,0(s0)
{
800009c2:	c606                	sw	ra,12(sp)
	thread_evidence++;
800009c4:	0785                	addi	a5,a5,1
800009c6:	c01c                	sw	a5,0(s0)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800009c8:	23b030ef          	jal	ra,80004402 <z_impl_k_current_get>

	/* Test that helper will yield to a thread of equal priority */
	self_thread_id = k_current_get();

	/* Lower priority to that of thread_entry() */
	k_thread_priority_set(self_thread_id, self_thread_id->base.prio + 1);
800009cc:	00e50583          	lb	a1,14(a0)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)

K_SYSCALL_DECLARE1(K_SYSCALL_K_THREAD_PRIORITY_GET, k_thread_priority_get, int, k_tid_t, thread)

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
800009d0:	0585                	addi	a1,a1,1
800009d2:	5fe030ef          	jal	ra,80003fd0 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800009d6:	6a4030ef          	jal	ra,8000407a <z_impl_k_yield>

	k_yield();      /* Yield to thread of equal priority */

	thread_evidence++;
800009da:	401c                	lw	a5,0(s0)
	/* thread_evidence should now be 2 */

}
800009dc:	40b2                	lw	ra,12(sp)
	thread_evidence++;
800009de:	0785                	addi	a5,a5,1
800009e0:	c01c                	sw	a5,0(s0)
}
800009e2:	4422                	lw	s0,8(sp)
800009e4:	0141                	addi	sp,sp,16
800009e6:	8082                	ret

800009e8 <isr_handler_trigger>:
	irq_offload(isr_handler, NULL);
800009e8:	80001537          	lui	a0,0x80001
800009ec:	4581                	li	a1,0
800009ee:	b3850513          	addi	a0,a0,-1224 # 80000b38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b39>
800009f2:	5050006f          	j	800016f6 <irq_offload>

800009f6 <test_kernel_cpu_idle>:
	ztest_test_skip();
800009f6:	5890106f          	j	8000277e <ztest_test_skip>

800009fa <delayed_thread>:
	k_sem_give(&reply_timeout);
}

/* a thread is started with a delay, then it reports that it ran via a fifo */
static void delayed_thread(void *num, void *arg2, void *arg3)
{
800009fa:	1141                	addi	sp,sp,-16
800009fc:	c422                	sw	s0,8(sp)
	struct timeout_order *timeout = &timeouts[(int)num];

	ARG_UNUSED(arg2);
	ARG_UNUSED(arg3);

	TC_PRINT(" thread (q order: %d, t/o: %d) is running\n",
800009fe:	80007437          	lui	s0,0x80007
80000a02:	0512                	slli	a0,a0,0x4
80000a04:	dc040413          	addi	s0,s0,-576 # 80006dc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dc1>
80000a08:	942a                	add	s0,s0,a0
80000a0a:	444c                	lw	a1,12(s0)
80000a0c:	4050                	lw	a2,4(s0)
80000a0e:	80006537          	lui	a0,0x80006
80000a12:	91050513          	addi	a0,a0,-1776 # 80005910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005911>
{
80000a16:	c606                	sw	ra,12(sp)
	TC_PRINT(" thread (q order: %d, t/o: %d) is running\n",
80000a18:	796010ef          	jal	ra,800021ae <printk>
		 timeout->q_order, timeout->timeout);

	k_fifo_put(&timeout_order_fifo, timeout);
80000a1c:	85a2                	mv	a1,s0
}
80000a1e:	4422                	lw	s0,8(sp)
80000a20:	40b2                	lw	ra,12(sp)
	k_fifo_put(&timeout_order_fifo, timeout);
80000a22:	80007537          	lui	a0,0x80007
80000a26:	05c50513          	addi	a0,a0,92 # 8000705c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000705d>
}
80000a2a:	0141                	addi	sp,sp,16
	k_fifo_put(&timeout_order_fifo, timeout);
80000a2c:	3080206f          	j	80002d34 <k_queue_append>

80000a30 <thread_sleep>:
{
80000a30:	1101                	addi	sp,sp,-32
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
80000a32:	85aa                	mv	a1,a0
{
80000a34:	cc22                	sw	s0,24(sp)
80000a36:	842a                	mv	s0,a0
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
80000a38:	80006537          	lui	a0,0x80006
80000a3c:	22050513          	addi	a0,a0,544 # 80006220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006221>
{
80000a40:	ce06                	sw	ra,28(sp)
80000a42:	ca26                	sw	s1,20(sp)
80000a44:	c84a                	sw	s2,16(sp)
80000a46:	c64e                	sw	s3,12(sp)
	TC_PRINT(" thread sleeping for %d milliseconds\n", timeout);
80000a48:	766010ef          	jal	ra,800021ae <printk>

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_TIMER_USER_DATA_SET, k_timer_user_data_set, struct k_timer *, timer, void *, user_data)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000a4c:	041040ef          	jal	ra,8000528c <z_impl_k_uptime_get>
80000a50:	89aa                	mv	s3,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000a52:	8522                	mv	a0,s0
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000a54:	892e                	mv	s2,a1
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000a56:	7c6030ef          	jal	ra,8000421c <z_impl_k_sleep>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000a5a:	033040ef          	jal	ra,8000528c <z_impl_k_uptime_get>
	timestamp = k_uptime_get() - timestamp;
80000a5e:	413509b3          	sub	s3,a0,s3
80000a62:	01353533          	sltu	a0,a0,s3
80000a66:	412585b3          	sub	a1,a1,s2
80000a6a:	40a584b3          	sub	s1,a1,a0
	TC_PRINT(" thread back from sleep\n");
80000a6e:	80006537          	lui	a0,0x80006
80000a72:	24850513          	addi	a0,a0,584 # 80006248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006249>
80000a76:	738010ef          	jal	ra,800021ae <printk>
	if (timestamp < timeout || timestamp > timeout + __ticks_to_ms(2)) {
80000a7a:	41f45793          	srai	a5,s0,0x1f
80000a7e:	02f4c163          	blt	s1,a5,80000aa0 <thread_sleep+0x70>
80000a82:	00979463          	bne	a5,s1,80000a8a <thread_sleep+0x5a>
80000a86:	0089ed63          	bltu	s3,s0,80000aa0 <thread_sleep+0x70>
80000a8a:	01440713          	addi	a4,s0,20
80000a8e:	00873433          	sltu	s0,a4,s0
80000a92:	943e                	add	s0,s0,a5
80000a94:	00946663          	bltu	s0,s1,80000aa0 <thread_sleep+0x70>
80000a98:	04849163          	bne	s1,s0,80000ada <thread_sleep+0xaa>
80000a9c:	03377f63          	bgeu	a4,s3,80000ada <thread_sleep+0xaa>
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000aa0:	80006637          	lui	a2,0x80006
80000aa4:	800065b7          	lui	a1,0x80006
80000aa8:	80006537          	lui	a0,0x80006
80000aac:	26458593          	addi	a1,a1,612 # 80006264 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006265>
80000ab0:	26c50513          	addi	a0,a0,620 # 8000626c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000626d>
80000ab4:	2be00693          	li	a3,702
80000ab8:	88c60613          	addi	a2,a2,-1908 # 8000588c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000588d>
80000abc:	6f2010ef          	jal	ra,800021ae <printk>
}
80000ac0:	4462                	lw	s0,24(sp)
80000ac2:	40f2                	lw	ra,28(sp)
80000ac4:	44d2                	lw	s1,20(sp)
80000ac6:	4942                	lw	s2,16(sp)
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000ac8:	85ce                	mv	a1,s3
}
80000aca:	49b2                	lw	s3,12(sp)
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000acc:	80006537          	lui	a0,0x80006
80000ad0:	27c50513          	addi	a0,a0,636 # 8000627c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000627d>
}
80000ad4:	6105                	addi	sp,sp,32
		TC_ERROR("timestamp out of range, got %d\n", (int)timestamp);
80000ad6:	6d80106f          	j	800021ae <printk>
}
80000ada:	4462                	lw	s0,24(sp)
80000adc:	40f2                	lw	ra,28(sp)
80000ade:	44d2                	lw	s1,20(sp)
80000ae0:	4942                	lw	s2,16(sp)
80000ae2:	49b2                	lw	s3,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000ae4:	80007537          	lui	a0,0x80007
80000ae8:	eec50513          	addi	a0,a0,-276 # 80006eec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eed>
80000aec:	6105                	addi	sp,sp,32
80000aee:	1bf0306f          	j	800044ac <z_impl_k_sem_give>

80000af2 <busy_wait_thread>:
{
80000af2:	1141                	addi	sp,sp,-16
80000af4:	c422                	sw	s0,8(sp)
	usecs = (int)mseconds * 1000;
80000af6:	00551413          	slli	s0,a0,0x5
80000afa:	8c09                	sub	s0,s0,a0
80000afc:	040a                	slli	s0,s0,0x2
80000afe:	9522                	add	a0,a0,s0
80000b00:	00351413          	slli	s0,a0,0x3
	TC_PRINT("Thread busy waiting for %d usecs\n", usecs);
80000b04:	80006537          	lui	a0,0x80006
80000b08:	85a2                	mv	a1,s0
80000b0a:	8cc50513          	addi	a0,a0,-1844 # 800058cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058cd>
{
80000b0e:	c606                	sw	ra,12(sp)
	TC_PRINT("Thread busy waiting for %d usecs\n", usecs);
80000b10:	69e010ef          	jal	ra,800021ae <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000b14:	8522                	mv	a0,s0
80000b16:	3e5030ef          	jal	ra,800046fa <z_impl_k_busy_wait>
	TC_PRINT("Thread busy waiting completed\n");
80000b1a:	80006537          	lui	a0,0x80006
80000b1e:	8f050513          	addi	a0,a0,-1808 # 800058f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f1>
80000b22:	68c010ef          	jal	ra,800021ae <printk>
}
80000b26:	4422                	lw	s0,8(sp)
80000b28:	40b2                	lw	ra,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b2a:	80007537          	lui	a0,0x80007
80000b2e:	eec50513          	addi	a0,a0,-276 # 80006eec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eed>
80000b32:	0141                	addi	sp,sp,16
80000b34:	1790306f          	j	800044ac <z_impl_k_sem_give>

80000b38 <isr_handler>:
{
80000b38:	1141                	addi	sp,sp,-16
80000b3a:	c422                	sw	s0,8(sp)
	switch (isr_info.command) {
80000b3c:	80007437          	lui	s0,0x80007
80000b40:	ee040413          	addi	s0,s0,-288 # 80006ee0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ee1>
{
80000b44:	c226                	sw	s1,4(sp)
	switch (isr_info.command) {
80000b46:	4004                	lw	s1,0(s0)
{
80000b48:	c606                	sw	ra,12(sp)
80000b4a:	c499                	beqz	s1,80000b58 <isr_handler+0x20>
80000b4c:	4785                	li	a5,1
80000b4e:	00f48d63          	beq	s1,a5,80000b68 <isr_handler+0x30>
		isr_info.error = UNKNOWN_COMMAND;
80000b52:	57fd                	li	a5,-1
80000b54:	c05c                	sw	a5,4(s0)
}
80000b56:	a021                	j	80000b5e <isr_handler+0x26>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000b58:	0ab030ef          	jal	ra,80004402 <z_impl_k_current_get>
		isr_info.data = (void *)k_current_get();
80000b5c:	c408                	sw	a0,8(s0)
}
80000b5e:	40b2                	lw	ra,12(sp)
80000b60:	4422                	lw	s0,8(sp)
80000b62:	4492                	lw	s1,4(sp)
80000b64:	0141                	addi	sp,sp,16
80000b66:	8082                	ret
		if (k_is_in_isr()) {
80000b68:	375030ef          	jal	ra,800046dc <k_is_in_isr>
80000b6c:	c501                	beqz	a0,80000b74 <isr_handler+0x3c>
			isr_info.value = K_ISR;
80000b6e:	00042423          	sw	zero,8(s0)
			break;
80000b72:	b7f5                	j	80000b5e <isr_handler+0x26>
		if (_current->base.prio < 0) {
80000b74:	800077b7          	lui	a5,0x80007
80000b78:	5147a783          	lw	a5,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80000b7c:	00e78783          	lb	a5,14(a5)
80000b80:	0007d463          	bgez	a5,80000b88 <isr_handler+0x50>
			isr_info.value = K_COOP_THREAD;
80000b84:	c404                	sw	s1,8(s0)
			break;
80000b86:	bfe1                	j	80000b5e <isr_handler+0x26>
		isr_info.value = K_PREEMPT_THREAD;
80000b88:	4789                	li	a5,2
80000b8a:	c41c                	sw	a5,8(s0)
		break;
80000b8c:	bfc9                	j	80000b5e <isr_handler+0x26>

80000b8e <z_zassert.constprop.2>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000b8e:	7179                	addi	sp,sp,-48
80000b90:	ce06                	sw	ra,28(sp)
80000b92:	cc22                	sw	s0,24(sp)
80000b94:	d442                	sw	a6,40(sp)
80000b96:	d646                	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000b98:	ed0d                	bnez	a0,80000bd2 <z_zassert.constprop.2+0x44>
80000b9a:	8636                	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000b9c:	80006537          	lui	a0,0x80006
80000ba0:	86ba                	mv	a3,a4
80000ba2:	872e                	mv	a4,a1
80000ba4:	800065b7          	lui	a1,0x80006
80000ba8:	843e                	mv	s0,a5
80000baa:	29c58593          	addi	a1,a1,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
		va_start(vargs, msg);
80000bae:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000bb0:	2c050513          	addi	a0,a0,704 # 800062c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062c1>
		va_start(vargs, msg);
80000bb4:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000bb6:	5f8010ef          	jal	ra,800021ae <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000bba:	45b2                	lw	a1,12(sp)
80000bbc:	8522                	mv	a0,s0
80000bbe:	5d4010ef          	jal	ra,80002192 <vprintk>
		printk("\n");
80000bc2:	80006537          	lui	a0,0x80006
80000bc6:	43c50513          	addi	a0,a0,1084 # 8000643c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000643d>
80000bca:	5e4010ef          	jal	ra,800021ae <printk>
		va_end(vargs);
		ztest_test_fail();
80000bce:	38b010ef          	jal	ra,80002758 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000bd2:	40f2                	lw	ra,28(sp)
80000bd4:	4462                	lw	s0,24(sp)
80000bd6:	6145                	addi	sp,sp,48
80000bd8:	8082                	ret

80000bda <test_kernel_ctx_thread>:
{
80000bda:	1101                	addi	sp,sp,-32
80000bdc:	ce06                	sw	ra,28(sp)
80000bde:	cc22                	sw	s0,24(sp)
80000be0:	ca26                	sw	s1,20(sp)
80000be2:	c84a                	sw	s2,16(sp)
80000be4:	c64e                	sw	s3,12(sp)
80000be6:	c452                	sw	s4,8(sp)
80000be8:	c256                	sw	s5,4(sp)
80000bea:	019030ef          	jal	ra,80004402 <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000bee:	4581                	li	a1,0
80000bf0:	3e0030ef          	jal	ra,80003fd0 <z_impl_k_thread_priority_set>
	TC_PRINT("Testing k_current_get() from an ISR and thread\n");
80000bf4:	80006537          	lui	a0,0x80006
80000bf8:	00450513          	addi	a0,a0,4 # 80006004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006005>
80000bfc:	5b2010ef          	jal	ra,800021ae <printk>
	isr_info.command = THREAD_SELF_CMD;
80000c00:	80007437          	lui	s0,0x80007
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000c04:	7fe030ef          	jal	ra,80004402 <z_impl_k_current_get>
80000c08:	ee040413          	addi	s0,s0,-288 # 80006ee0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ee1>
80000c0c:	8aaa                	mv	s5,a0
80000c0e:	00042023          	sw	zero,0(s0)
	isr_info.error = 0;
80000c12:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
80000c16:	3bc9                	jal	800009e8 <isr_handler_trigger>
	zassert_false(isr_info.error, "ISR detected an error");
80000c18:	4048                	lw	a0,4(s0)
80000c1a:	80006937          	lui	s2,0x80006
80000c1e:	800064b7          	lui	s1,0x80006
80000c22:	80006a37          	lui	s4,0x80006
80000c26:	800069b7          	lui	s3,0x80006
80000c2a:	034a0793          	addi	a5,s4,52 # 80006034 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006035>
80000c2e:	85090713          	addi	a4,s2,-1968 # 80005850 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005851>
80000c32:	29c48613          	addi	a2,s1,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80000c36:	04c98593          	addi	a1,s3,76 # 8000604c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000604d>
80000c3a:	1c400693          	li	a3,452
80000c3e:	00153513          	seqz	a0,a0
80000c42:	37b1                	jal	80000b8e <z_zassert.constprop.2>
	zassert_equal(isr_info.data, (void *)self_thread_id,
80000c44:	4408                	lw	a0,8(s0)
80000c46:	800067b7          	lui	a5,0x80006
80000c4a:	800065b7          	lui	a1,0x80006
80000c4e:	41550533          	sub	a0,a0,s5
80000c52:	85090713          	addi	a4,s2,-1968
80000c56:	29c48613          	addi	a2,s1,668
80000c5a:	1c700693          	li	a3,455
80000c5e:	08058593          	addi	a1,a1,128 # 80006080 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006081>
80000c62:	06878793          	addi	a5,a5,104 # 80006068 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006069>
80000c66:	00153513          	seqz	a0,a0
80000c6a:	3715                	jal	80000b8e <z_zassert.constprop.2>
	TC_PRINT("Testing k_is_in_isr() from an ISR\n");
80000c6c:	80006537          	lui	a0,0x80006
80000c70:	0b450513          	addi	a0,a0,180 # 800060b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060b5>
80000c74:	53a010ef          	jal	ra,800021ae <printk>
	isr_info.command = EXEC_CTX_TYPE_CMD;
80000c78:	4785                	li	a5,1
80000c7a:	c01c                	sw	a5,0(s0)
	isr_info.error = 0;
80000c7c:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
80000c80:	33a5                	jal	800009e8 <isr_handler_trigger>
	zassert_false(isr_info.error, "ISR detected an error");
80000c82:	4048                	lw	a0,4(s0)
80000c84:	034a0793          	addi	a5,s4,52
80000c88:	85090713          	addi	a4,s2,-1968
80000c8c:	29c48613          	addi	a2,s1,668
80000c90:	04c98593          	addi	a1,s3,76
80000c94:	1ce00693          	li	a3,462
80000c98:	00153513          	seqz	a0,a0
80000c9c:	3dcd                	jal	80000b8e <z_zassert.constprop.2>
	zassert_equal(isr_info.value, K_ISR,
80000c9e:	4408                	lw	a0,8(s0)
80000ca0:	800067b7          	lui	a5,0x80006
80000ca4:	800065b7          	lui	a1,0x80006
80000ca8:	85090713          	addi	a4,s2,-1968
80000cac:	29c48613          	addi	a2,s1,668
80000cb0:	0d878793          	addi	a5,a5,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
80000cb4:	1d100693          	li	a3,465
80000cb8:	0f858593          	addi	a1,a1,248 # 800060f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f9>
80000cbc:	00153513          	seqz	a0,a0
80000cc0:	35f9                	jal	80000b8e <z_zassert.constprop.2>
	TC_PRINT("Testing k_is_in_isr() from a preemptible thread\n");
80000cc2:	80006537          	lui	a0,0x80006
80000cc6:	11c50513          	addi	a0,a0,284 # 8000611c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000611d>
80000cca:	4e4010ef          	jal	ra,800021ae <printk>
	zassert_false(k_is_in_isr(), "Should not be in ISR context");
80000cce:	20f030ef          	jal	ra,800046dc <k_is_in_isr>
80000cd2:	00154513          	xori	a0,a0,1
80000cd6:	800067b7          	lui	a5,0x80006
80000cda:	800065b7          	lui	a1,0x80006
80000cde:	85090713          	addi	a4,s2,-1968
80000ce2:	29c48613          	addi	a2,s1,668
80000ce6:	15078793          	addi	a5,a5,336 # 80006150 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006151>
80000cea:	1d400693          	li	a3,468
80000cee:	17058593          	addi	a1,a1,368 # 80006170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006171>
80000cf2:	0ff57513          	andi	a0,a0,255
80000cf6:	3d61                	jal	80000b8e <z_zassert.constprop.2>
	zassert_false(_current->base.prio < 0,
80000cf8:	800077b7          	lui	a5,0x80007
80000cfc:	5147a783          	lw	a5,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
}
80000d00:	4462                	lw	s0,24(sp)
80000d02:	40f2                	lw	ra,28(sp)
	zassert_false(_current->base.prio < 0,
80000d04:	00e78803          	lb	a6,14(a5)
}
80000d08:	49b2                	lw	s3,12(sp)
80000d0a:	4a22                	lw	s4,8(sp)
80000d0c:	4a92                	lw	s5,4(sp)
	zassert_false(_current->base.prio < 0,
80000d0e:	85090713          	addi	a4,s2,-1968
80000d12:	29c48613          	addi	a2,s1,668
}
80000d16:	4942                	lw	s2,16(sp)
80000d18:	44d2                	lw	s1,20(sp)
	zassert_false(_current->base.prio < 0,
80000d1a:	fff84513          	not	a0,a6
80000d1e:	800067b7          	lui	a5,0x80006
80000d22:	800065b7          	lui	a1,0x80006
80000d26:	18878793          	addi	a5,a5,392 # 80006188 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006189>
80000d2a:	1d800693          	li	a3,472
80000d2e:	1bc58593          	addi	a1,a1,444 # 800061bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061bd>
80000d32:	817d                	srli	a0,a0,0x1f
}
80000d34:	6105                	addi	sp,sp,32
	zassert_false(_current->base.prio < 0,
80000d36:	bda1                	j	80000b8e <z_zassert.constprop.2>

80000d38 <test_kernel_interrupts>:
80000d38:	8082                	ret

80000d3a <test_kernel_timer_interrupts>:
{
80000d3a:	1101                	addi	sp,sp,-32
80000d3c:	c84a                	sw	s2,16(sp)
80000d3e:	ce06                	sw	ra,28(sp)
80000d40:	cc22                	sw	s0,24(sp)
80000d42:	ca26                	sw	s1,20(sp)
80000d44:	c64e                	sw	s3,12(sp)
80000d46:	c452                	sw	s4,8(sp)
	tick = z_tick_get_32();
80000d48:	536040ef          	jal	ra,8000527e <z_tick_get_32>
80000d4c:	892a                	mv	s2,a0
	while (z_tick_get_32() == tick) {
80000d4e:	530040ef          	jal	ra,8000527e <z_tick_get_32>
80000d52:	fea90ee3          	beq	s2,a0,80000d4e <test_kernel_timer_interrupts+0x14>
	tick++;
80000d56:	0905                	addi	s2,s2,1
	unsigned long long count = 0;
80000d58:	4481                	li	s1,0
80000d5a:	4401                	li	s0,0
	while (z_tick_get_32() == tick) {
80000d5c:	522040ef          	jal	ra,8000527e <z_tick_get_32>
80000d60:	07250e63          	beq	a0,s2,80000ddc <test_kernel_timer_interrupts+0xa2>
	count <<= 4;
80000d64:	01c4d793          	srli	a5,s1,0x1c
	irq_disable(irq);
80000d68:	451d                	li	a0,7
	count <<= 4;
80000d6a:	0412                	slli	s0,s0,0x4
80000d6c:	8c5d                	or	s0,s0,a5
	irq_disable(irq);
80000d6e:	49e010ef          	jal	ra,8000220c <z_arch_irq_disable>
	tick = z_tick_get_32();
80000d72:	50c040ef          	jal	ra,8000527e <z_tick_get_32>
	count <<= 4;
80000d76:	0492                	slli	s1,s1,0x4
	tick = z_tick_get_32();
80000d78:	8a2a                	mv	s4,a0
	for (i = 0; i < count; i++) {
80000d7a:	4901                	li	s2,0
80000d7c:	4981                	li	s3,0
80000d7e:	07249663          	bne	s1,s2,80000dea <test_kernel_timer_interrupts+0xb0>
80000d82:	07341463          	bne	s0,s3,80000dea <test_kernel_timer_interrupts+0xb0>
	tick2 = z_tick_get_32();
80000d86:	4f8040ef          	jal	ra,8000527e <z_tick_get_32>
	irq_enable(irq);
80000d8a:	451d                	li	a0,7
80000d8c:	474010ef          	jal	ra,80002200 <z_arch_irq_enable>
	for (i = 0; i < count; i++) {
80000d90:	4401                	li	s0,0
80000d92:	4481                	li	s1,0
80000d94:	06891463          	bne	s2,s0,80000dfc <test_kernel_timer_interrupts+0xc2>
80000d98:	06999263          	bne	s3,s1,80000dfc <test_kernel_timer_interrupts+0xc2>
	tick2 = z_tick_get_32();
80000d9c:	4e2040ef          	jal	ra,8000527e <z_tick_get_32>
}
80000da0:	4462                	lw	s0,24(sp)
	zassert_not_equal(tick, tick2,
80000da2:	40aa0533          	sub	a0,s4,a0
}
80000da6:	40f2                	lw	ra,28(sp)
80000da8:	44d2                	lw	s1,20(sp)
80000daa:	4942                	lw	s2,16(sp)
80000dac:	49b2                	lw	s3,12(sp)
80000dae:	4a22                	lw	s4,8(sp)
	zassert_not_equal(tick, tick2,
80000db0:	800067b7          	lui	a5,0x80006
80000db4:	80006737          	lui	a4,0x80006
80000db8:	80006637          	lui	a2,0x80006
80000dbc:	800065b7          	lui	a1,0x80006
80000dc0:	1e078793          	addi	a5,a5,480 # 800061e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061e1>
80000dc4:	83870713          	addi	a4,a4,-1992 # 80005838 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005839>
80000dc8:	17c00693          	li	a3,380
80000dcc:	29c60613          	addi	a2,a2,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80000dd0:	20058593          	addi	a1,a1,512 # 80006200 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006201>
80000dd4:	00a03533          	snez	a0,a0
}
80000dd8:	6105                	addi	sp,sp,32
	zassert_not_equal(tick, tick2,
80000dda:	bb55                	j	80000b8e <z_zassert.constprop.2>
		count++;
80000ddc:	00148793          	addi	a5,s1,1
80000de0:	0097b733          	sltu	a4,a5,s1
80000de4:	943a                	add	s0,s0,a4
80000de6:	84be                	mv	s1,a5
80000de8:	bf95                	j	80000d5c <test_kernel_timer_interrupts+0x22>
		z_tick_get_32();
80000dea:	494040ef          	jal	ra,8000527e <z_tick_get_32>
	for (i = 0; i < count; i++) {
80000dee:	00190793          	addi	a5,s2,1
80000df2:	0127b733          	sltu	a4,a5,s2
80000df6:	99ba                	add	s3,s3,a4
80000df8:	893e                	mv	s2,a5
80000dfa:	b751                	j	80000d7e <test_kernel_timer_interrupts+0x44>
		z_tick_get_32();
80000dfc:	482040ef          	jal	ra,8000527e <z_tick_get_32>
	for (i = 0; i < count; i++) {
80000e00:	00140793          	addi	a5,s0,1
80000e04:	0087b733          	sltu	a4,a5,s0
80000e08:	94ba                	add	s1,s1,a4
80000e0a:	843e                	mv	s0,a5
80000e0c:	b761                	j	80000d94 <test_kernel_timer_interrupts+0x5a>

80000e0e <test_kernel_cpu_idle_atomic>:
80000e0e:	1710106f          	j	8000277e <ztest_test_skip>

80000e12 <test_kernel_thread>:
 * @ingroup kernel_context_tests
 *
 * @see k_thread_create
 */
void test_kernel_thread(void)
{
80000e12:	1101                	addi	sp,sp,-32
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000e14:	800016b7          	lui	a3,0x80001
80000e18:	800085b7          	lui	a1,0x80008
80000e1c:	80007537          	lui	a0,0x80007
80000e20:	c202                	sw	zero,4(sp)
80000e22:	c002                	sw	zero,0(sp)
80000e24:	58d1                	li	a7,-12
80000e26:	4801                	li	a6,0
80000e28:	4781                	li	a5,0
80000e2a:	4701                	li	a4,0
80000e2c:	e4868693          	addi	a3,a3,-440 # 80000e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000e49>
80000e30:	20000613          	li	a2,512
80000e34:	94058593          	addi	a1,a1,-1728 # 80007940 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007941>
80000e38:	fec50513          	addi	a0,a0,-20 # 80006fec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fed>
80000e3c:	ce06                	sw	ra,28(sp)
80000e3e:	2f3030ef          	jal	ra,80004930 <z_impl_k_thread_create>

	k_thread_create(&thread_data3, thread_stack3, THREAD_STACKSIZE,
			kernel_thread_entry, NULL, NULL,
			NULL, K_PRIO_COOP(THREAD_PRIORITY), 0, 0);

}
80000e42:	40f2                	lw	ra,28(sp)
80000e44:	6105                	addi	sp,sp,32
80000e46:	8082                	ret

80000e48 <kernel_thread_entry>:
	thread_evidence++;      /* Prove that the thread has run */
80000e48:	800077b7          	lui	a5,0x80007
80000e4c:	ea078793          	addi	a5,a5,-352 # 80006ea0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea1>
80000e50:	4398                	lw	a4,0(a5)
{
80000e52:	1101                	addi	sp,sp,-32
80000e54:	cc22                	sw	s0,24(sp)
80000e56:	842a                	mv	s0,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000e58:	80007537          	lui	a0,0x80007
80000e5c:	ce06                	sw	ra,28(sp)
	thread_evidence++;      /* Prove that the thread has run */
80000e5e:	0705                	addi	a4,a4,1
{
80000e60:	ca26                	sw	s1,20(sp)
80000e62:	c84a                	sw	s2,16(sp)
80000e64:	c64e                	sw	s3,12(sp)
80000e66:	c452                	sw	s4,8(sp)
80000e68:	55fd                	li	a1,-1
80000e6a:	efc50513          	addi	a0,a0,-260 # 80006efc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006efd>
	thread_evidence++;      /* Prove that the thread has run */
80000e6e:	c398                	sw	a4,0(a5)
80000e70:	6e6030ef          	jal	ra,80004556 <z_impl_k_sem_take>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000e74:	58e030ef          	jal	ra,80004402 <z_impl_k_current_get>
80000e78:	89aa                	mv	s3,a0
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80000e7a:	80006a37          	lui	s4,0x80006
80000e7e:	40a40533          	sub	a0,s0,a0
80000e82:	800067b7          	lui	a5,0x80006
	isr_info.command = THREAD_SELF_CMD;
80000e86:	80007437          	lui	s0,0x80007
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80000e8a:	800064b7          	lui	s1,0x80006
80000e8e:	800065b7          	lui	a1,0x80006
	isr_info.command = THREAD_SELF_CMD;
80000e92:	ee040913          	addi	s2,s0,-288 # 80006ee0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ee1>
	zassert_true((self_thread_id != _thread_id), "thread id matches parent thread");
80000e96:	a7478793          	addi	a5,a5,-1420 # 80005a74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a75>
80000e9a:	00a03533          	snez	a0,a0
80000e9e:	868a0713          	addi	a4,s4,-1944 # 80005868 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005869>
80000ea2:	1ea00693          	li	a3,490
80000ea6:	29c48613          	addi	a2,s1,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80000eaa:	a9458593          	addi	a1,a1,-1388 # 80005a94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a95>
80000eae:	31c5                	jal	80000b8e <z_zassert.constprop.2>
	isr_info.command = THREAD_SELF_CMD;
80000eb0:	00092023          	sw	zero,0(s2)
	isr_info.error = 0;
80000eb4:	00092223          	sw	zero,4(s2)
	isr_handler_trigger();
80000eb8:	3e05                	jal	800009e8 <isr_handler_trigger>
	zassert_false((isr_info.error || (isr_info.data != (void *)self_thread_id)),
80000eba:	00492783          	lw	a5,4(s2)
80000ebe:	ee040413          	addi	s0,s0,-288
80000ec2:	4501                	li	a0,0
80000ec4:	e791                	bnez	a5,80000ed0 <kernel_thread_entry+0x88>
80000ec6:	4408                	lw	a0,8(s0)
80000ec8:	41350533          	sub	a0,a0,s3
80000ecc:	00153513          	seqz	a0,a0
80000ed0:	800067b7          	lui	a5,0x80006
80000ed4:	800065b7          	lui	a1,0x80006
80000ed8:	868a0713          	addi	a4,s4,-1944
80000edc:	29c48613          	addi	a2,s1,668
80000ee0:	1f400693          	li	a3,500
80000ee4:	af058593          	addi	a1,a1,-1296 # 80005af0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af1>
80000ee8:	ac078793          	addi	a5,a5,-1344 # 80005ac0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ac1>
80000eec:	314d                	jal	80000b8e <z_zassert.constprop.2>
	isr_info.command = EXEC_CTX_TYPE_CMD;
80000eee:	4785                	li	a5,1
80000ef0:	c01c                	sw	a5,0(s0)
	isr_info.error = 0;
80000ef2:	00042223          	sw	zero,4(s0)
	isr_handler_trigger();
80000ef6:	3ccd                	jal	800009e8 <isr_handler_trigger>
	zassert_false((isr_info.error || (isr_info.value != K_ISR)),
80000ef8:	441c                	lw	a5,8(s0)
80000efa:	4048                	lw	a0,4(s0)
80000efc:	800065b7          	lui	a1,0x80006
80000f00:	868a0713          	addi	a4,s4,-1944
80000f04:	8d5d                	or	a0,a0,a5
80000f06:	800067b7          	lui	a5,0x80006
80000f0a:	29c48613          	addi	a2,s1,668
80000f0e:	b3878793          	addi	a5,a5,-1224 # 80005b38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b39>
80000f12:	1fa00693          	li	a3,506
80000f16:	b6858593          	addi	a1,a1,-1176 # 80005b68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b69>
80000f1a:	00153513          	seqz	a0,a0
80000f1e:	3985                	jal	80000b8e <z_zassert.constprop.2>
	zassert_false(k_is_in_isr(), "k_is_in_isr() when called from a thread is true");
80000f20:	7bc030ef          	jal	ra,800046dc <k_is_in_isr>
80000f24:	00154513          	xori	a0,a0,1
80000f28:	800067b7          	lui	a5,0x80006
80000f2c:	800065b7          	lui	a1,0x80006
80000f30:	868a0713          	addi	a4,s4,-1944
80000f34:	29c48613          	addi	a2,s1,668
80000f38:	ba078793          	addi	a5,a5,-1120 # 80005ba0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ba1>
80000f3c:	1fc00693          	li	a3,508
80000f40:	17058593          	addi	a1,a1,368 # 80006170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006171>
80000f44:	0ff57513          	andi	a0,a0,255
80000f48:	3199                	jal	80000b8e <z_zassert.constprop.2>
	zassert_false((_current->base.prio >= 0),
80000f4a:	800077b7          	lui	a5,0x80007
80000f4e:	5147a783          	lw	a5,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
}
80000f52:	4462                	lw	s0,24(sp)
80000f54:	40f2                	lw	ra,28(sp)
	zassert_false((_current->base.prio >= 0),
80000f56:	00e78503          	lb	a0,14(a5)
}
80000f5a:	4942                	lw	s2,16(sp)
80000f5c:	49b2                	lw	s3,12(sp)
	zassert_false((_current->base.prio >= 0),
80000f5e:	868a0713          	addi	a4,s4,-1944
80000f62:	29c48613          	addi	a2,s1,668
}
80000f66:	4a22                	lw	s4,8(sp)
80000f68:	44d2                	lw	s1,20(sp)
	zassert_false((_current->base.prio >= 0),
80000f6a:	800067b7          	lui	a5,0x80006
80000f6e:	800065b7          	lui	a1,0x80006
80000f72:	bd078793          	addi	a5,a5,-1072 # 80005bd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bd1>
80000f76:	1ff00693          	li	a3,511
80000f7a:	bf458593          	addi	a1,a1,-1036 # 80005bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf5>
80000f7e:	817d                	srli	a0,a0,0x1f
}
80000f80:	6105                	addi	sp,sp,32
	zassert_false((_current->base.prio >= 0),
80000f82:	b131                	j	80000b8e <z_zassert.constprop.2>

80000f84 <test_busy_wait>:
{
80000f84:	1101                	addi	sp,sp,-32
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000f86:	800016b7          	lui	a3,0x80001
80000f8a:	800085b7          	lui	a1,0x80008
80000f8e:	80007537          	lui	a0,0x80007
80000f92:	4781                	li	a5,0
80000f94:	4751                	li	a4,20
80000f96:	af268693          	addi	a3,a3,-1294 # 80000af2 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000af3>
80000f9a:	18000613          	li	a2,384
80000f9e:	c202                	sw	zero,4(sp)
80000fa0:	c002                	sw	zero,0(sp)
80000fa2:	58d1                	li	a7,-12
80000fa4:	4801                	li	a6,0
80000fa6:	b4058593          	addi	a1,a1,-1216 # 80007b40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b41>
80000faa:	07050513          	addi	a0,a0,112 # 80007070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007071>
80000fae:	ce06                	sw	ra,28(sp)
80000fb0:	181030ef          	jal	ra,80004930 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000fb4:	80007537          	lui	a0,0x80007
80000fb8:	02800593          	li	a1,40
80000fbc:	eec50513          	addi	a0,a0,-276 # 80006eec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eed>
80000fc0:	596030ef          	jal	ra,80004556 <z_impl_k_sem_take>
}
80000fc4:	40f2                	lw	ra,28(sp)
	zassert_false(rv, " *** thread timed out waiting for " "k_busy_wait()");
80000fc6:	800067b7          	lui	a5,0x80006
80000fca:	80006737          	lui	a4,0x80006
80000fce:	80006637          	lui	a2,0x80006
80000fd2:	800065b7          	lui	a1,0x80006
80000fd6:	ce478793          	addi	a5,a5,-796 # 80005ce4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ce5>
80000fda:	89c70713          	addi	a4,a4,-1892 # 8000589c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000589d>
80000fde:	2e800693          	li	a3,744
80000fe2:	29c60613          	addi	a2,a2,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80000fe6:	d1458593          	addi	a1,a1,-748 # 80005d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d15>
80000fea:	00153513          	seqz	a0,a0
}
80000fee:	6105                	addi	sp,sp,32
	zassert_false(rv, " *** thread timed out waiting for " "k_busy_wait()");
80000ff0:	be79                	j	80000b8e <z_zassert.constprop.2>

80000ff2 <test_k_yield>:
{
80000ff2:	1101                	addi	sp,sp,-32
80000ff4:	ca26                	sw	s1,20(sp)
	thread_evidence = 0;
80000ff6:	800074b7          	lui	s1,0x80007
80000ffa:	ea048493          	addi	s1,s1,-352 # 80006ea0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea1>
{
80000ffe:	ce06                	sw	ra,28(sp)
80001000:	cc22                	sw	s0,24(sp)
	thread_evidence = 0;
80001002:	0004a023          	sw	zero,0(s1)
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001006:	3fc030ef          	jal	ra,80004402 <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
8000100a:	4581                	li	a1,0
8000100c:	7c5020ef          	jal	ra,80003fd0 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001010:	80007437          	lui	s0,0x80007
80001014:	efc40513          	addi	a0,s0,-260 # 80006efc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006efd>
80001018:	567d                	li	a2,-1
8000101a:	4581                	li	a1,0
8000101c:	3f0030ef          	jal	ra,8000440c <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001020:	800016b7          	lui	a3,0x80001
80001024:	800075b7          	lui	a1,0x80007
80001028:	80007537          	lui	a0,0x80007
8000102c:	58d1                	li	a7,-12
8000102e:	c202                	sw	zero,4(sp)
80001030:	c002                	sw	zero,0(sp)
80001032:	4801                	li	a6,0
80001034:	4781                	li	a5,0
80001036:	4701                	li	a4,0
80001038:	3e668693          	addi	a3,a3,998 # 800013e6 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800013e7>
8000103c:	20000613          	li	a2,512
80001040:	54058593          	addi	a1,a1,1344 # 80007540 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007541>
80001044:	f0c50513          	addi	a0,a0,-244 # 80006f0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f0d>
80001048:	0e9030ef          	jal	ra,80004930 <z_impl_k_thread_create>
	zassert_equal(thread_evidence, 1,
8000104c:	0004a803          	lw	a6,0(s1)
80001050:	800067b7          	lui	a5,0x80006
80001054:	80006737          	lui	a4,0x80006
80001058:	fff80513          	addi	a0,a6,-1
8000105c:	80006637          	lui	a2,0x80006
80001060:	800065b7          	lui	a1,0x80006
80001064:	fb878793          	addi	a5,a5,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80001068:	8bc70713          	addi	a4,a4,-1860 # 800058bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058bd>
8000106c:	37c00693          	li	a3,892
80001070:	29c60613          	addi	a2,a2,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80001074:	fe058593          	addi	a1,a1,-32 # 80005fe0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fe1>
80001078:	00153513          	seqz	a0,a0
8000107c:	3e09                	jal	80000b8e <z_zassert.constprop.2>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
8000107e:	efc40513          	addi	a0,s0,-260
80001082:	42a030ef          	jal	ra,800044ac <z_impl_k_sem_give>
80001086:	efc40513          	addi	a0,s0,-260
8000108a:	422030ef          	jal	ra,800044ac <z_impl_k_sem_give>
8000108e:	efc40513          	addi	a0,s0,-260
}
80001092:	4462                	lw	s0,24(sp)
80001094:	40f2                	lw	ra,28(sp)
80001096:	44d2                	lw	s1,20(sp)
80001098:	6105                	addi	sp,sp,32
8000109a:	4120306f          	j	800044ac <z_impl_k_sem_give>

8000109e <test_k_sleep>:
{
8000109e:	7175                	addi	sp,sp,-144
800010a0:	dece                	sw	s3,124(sp)
800010a2:	dcd2                	sw	s4,120(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800010a4:	800089b7          	lui	s3,0x80008
800010a8:	80007a37          	lui	s4,0x80007
800010ac:	800016b7          	lui	a3,0x80001
800010b0:	58d1                	li	a7,-12
800010b2:	4801                	li	a6,0
800010b4:	4781                	li	a5,0
800010b6:	03200713          	li	a4,50
800010ba:	a3068693          	addi	a3,a3,-1488 # 80000a30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a31>
800010be:	18000613          	li	a2,384
800010c2:	b4098593          	addi	a1,s3,-1216 # 80007b40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b41>
800010c6:	070a0513          	addi	a0,s4,112 # 80007070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007071>
800010ca:	c202                	sw	zero,4(sp)
800010cc:	c002                	sw	zero,0(sp)
800010ce:	c706                	sw	ra,140(sp)
800010d0:	c522                	sw	s0,136(sp)
800010d2:	c326                	sw	s1,132(sp)
800010d4:	c14a                	sw	s2,128(sp)
800010d6:	dad6                	sw	s5,116(sp)
800010d8:	d8da                	sw	s6,112(sp)
800010da:	d6de                	sw	s7,108(sp)
800010dc:	d4e2                	sw	s8,104(sp)
800010de:	d2e6                	sw	s9,100(sp)
800010e0:	d0ea                	sw	s10,96(sp)
800010e2:	ceee                	sw	s11,92(sp)
800010e4:	04d030ef          	jal	ra,80004930 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800010e8:	80007537          	lui	a0,0x80007
800010ec:	06400593          	li	a1,100
800010f0:	eec50513          	addi	a0,a0,-276 # 80006eec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eed>
800010f4:	462030ef          	jal	ra,80004556 <z_impl_k_sem_take>
	zassert_equal(rv, 0, " *** thread timed out waiting for thread on "
800010f8:	80006437          	lui	s0,0x80006
800010fc:	800067b7          	lui	a5,0x80006
80001100:	800064b7          	lui	s1,0x80006
80001104:	800065b7          	lui	a1,0x80006
80001108:	d2478793          	addi	a5,a5,-732 # 80005d24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d25>
8000110c:	8ac40713          	addi	a4,s0,-1876 # 800058ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058ad>
80001110:	30300693          	li	a3,771
80001114:	29c48613          	addi	a2,s1,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80001118:	d5c58593          	addi	a1,a1,-676 # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
8000111c:	00153513          	seqz	a0,a0
80001120:	34bd                	jal	80000b8e <z_zassert.constprop.2>
	TC_PRINT("Testing k_thread_create() without cancellation\n");
80001122:	80006537          	lui	a0,0x80006
80001126:	80007ab7          	lui	s5,0x80007
8000112a:	d7050513          	addi	a0,a0,-656 # 80005d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d71>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
8000112e:	80001d37          	lui	s10,0x80001
80001132:	dc0a8b13          	addi	s6,s5,-576 # 80006dc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dc1>
80001136:	070a0b93          	addi	s7,s4,112
8000113a:	b4098913          	addi	s2,s3,-1216
8000113e:	070010ef          	jal	ra,800021ae <printk>
80001142:	b4098993          	addi	s3,s3,-1216
80001146:	070a0a13          	addi	s4,s4,112
8000114a:	dc0a8a93          	addi	s5,s5,-576
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
8000114e:	4c01                	li	s8,0
80001150:	4d9d                	li	s11,7
80001152:	8cea                	mv	s9,s10
80001154:	004aa783          	lw	a5,4(s5)
80001158:	8762                	mv	a4,s8
8000115a:	85ce                	mv	a1,s3
8000115c:	c23e                	sw	a5,4(sp)
8000115e:	8552                	mv	a0,s4
80001160:	c002                	sw	zero,0(sp)
80001162:	58d5                	li	a7,-11
80001164:	4801                	li	a6,0
80001166:	4781                	li	a5,0
80001168:	9fad0693          	addi	a3,s10,-1542 # 800009fa <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009fb>
8000116c:	18000613          	li	a2,384
80001170:	0c05                	addi	s8,s8,1
80001172:	7be030ef          	jal	ra,80004930 <z_impl_k_thread_create>
80001176:	0ac1                	addi	s5,s5,16
80001178:	070a0a13          	addi	s4,s4,112
8000117c:	18098993          	addi	s3,s3,384
80001180:	fdbc1ae3          	bne	s8,s11,80001154 <test_k_sleep+0xb6>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80001184:	80007337          	lui	t1,0x80007
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001188:	4d81                	li	s11,0
		zassert_not_null(data, " *** timeout while waiting for"
8000118a:	80006d37          	lui	s10,0x80006
8000118e:	80006ab7          	lui	s5,0x80006
		zassert_equal(data->timeout_order, i,
80001192:	80006a37          	lui	s4,0x80006
80001196:	8c1a                	mv	s8,t1
80001198:	05c30513          	addi	a0,t1,92 # 8000705c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000705d>
8000119c:	2ee00593          	li	a1,750
800011a0:	39d010ef          	jal	ra,80002d3c <z_impl_k_queue_get>
800011a4:	89aa                	mv	s3,a0
		zassert_not_null(data, " *** timeout while waiting for"
800011a6:	da0d0793          	addi	a5,s10,-608 # 80005da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da1>
800011aa:	8ac40713          	addi	a4,s0,-1876
800011ae:	31300693          	li	a3,787
800011b2:	29c48613          	addi	a2,s1,668
800011b6:	dd0a8593          	addi	a1,s5,-560 # 80005dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd1>
800011ba:	00a03533          	snez	a0,a0
800011be:	3ac1                	jal	80000b8e <z_zassert.constprop.2>
		zassert_equal(data->timeout_order, i,
800011c0:	0089a803          	lw	a6,8(s3)
800011c4:	80006e37          	lui	t3,0x80006
800011c8:	e18e0593          	addi	a1,t3,-488 # 80005e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e19>
800011cc:	41b80533          	sub	a0,a6,s11
800011d0:	88ee                	mv	a7,s11
800011d2:	de0a0793          	addi	a5,s4,-544 # 80005de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005de1>
800011d6:	8ac40713          	addi	a4,s0,-1876
800011da:	31700693          	li	a3,791
800011de:	29c48613          	addi	a2,s1,668
800011e2:	00153513          	seqz	a0,a0
800011e6:	9a9ff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
		TC_PRINT(" got thread (q order: %d, t/o: %d) as expected\n",
800011ea:	0049a603          	lw	a2,4(s3)
800011ee:	00c9a583          	lw	a1,12(s3)
800011f2:	80006537          	lui	a0,0x80006
800011f6:	e4050513          	addi	a0,a0,-448 # 80005e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e41>
800011fa:	7b5000ef          	jal	ra,800021ae <printk>
800011fe:	80006e37          	lui	t3,0x80006
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001202:	0d85                	addi	s11,s11,1
80001204:	479d                	li	a5,7
80001206:	cc72                	sw	t3,24(sp)
80001208:	80007337          	lui	t1,0x80007
8000120c:	f8fd96e3          	bne	s11,a5,80001198 <test_k_sleep+0xfa>
80001210:	05c30513          	addi	a0,t1,92 # 8000705c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000705d>
80001214:	2ee00593          	li	a1,750
80001218:	325010ef          	jal	ra,80002d3c <z_impl_k_queue_get>
	zassert_false(data, " *** got something unexpected in the fifo");
8000121c:	80006a37          	lui	s4,0x80006
80001220:	80006ab7          	lui	s5,0x80006
80001224:	e70a0793          	addi	a5,s4,-400 # 80005e70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e71>
80001228:	8ac40713          	addi	a4,s0,-1876
8000122c:	32000693          	li	a3,800
80001230:	29c48613          	addi	a2,s1,668
80001234:	e9ca8593          	addi	a1,s5,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
80001238:	00153513          	seqz	a0,a0
8000123c:	953ff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
	TC_PRINT("Testing k_thread_create() with cancellations\n");
80001240:	80006537          	lui	a0,0x80006
80001244:	eac50513          	addi	a0,a0,-340 # 80005eac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ead>
80001248:	767000ef          	jal	ra,800021ae <printk>
	int cancellations[] = { 0, 3, 4, 6 };
8000124c:	800055b7          	lui	a1,0x80005
80001250:	4641                	li	a2,16
80001252:	72858593          	addi	a1,a1,1832 # 80005728 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005729>
80001256:	1048                	addi	a0,sp,36
80001258:	3c8010ef          	jal	ra,80002620 <memcpy>
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
8000125c:	03410d93          	addi	s11,sp,52
	int cancellations[] = { 0, 3, 4, 6 };
80001260:	835a                	mv	t1,s6
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001262:	4d01                	li	s10,0
80001264:	499d                	li	s3,7
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001266:	00432783          	lw	a5,4(t1)
8000126a:	876a                	mv	a4,s10
8000126c:	85ca                	mv	a1,s2
8000126e:	c23e                	sw	a5,4(sp)
80001270:	855e                	mv	a0,s7
80001272:	c002                	sw	zero,0(sp)
80001274:	58d5                	li	a7,-11
80001276:	4801                	li	a6,0
80001278:	4781                	li	a5,0
8000127a:	9fac8693          	addi	a3,s9,-1542
8000127e:	18000613          	li	a2,384
80001282:	ce1a                	sw	t1,28(sp)
80001284:	6ac030ef          	jal	ra,80004930 <z_impl_k_thread_create>
		delayed_threads[i] = id;
80001288:	4372                	lw	t1,28(sp)
8000128a:	00ada023          	sw	a0,0(s11)
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
8000128e:	0d05                	addi	s10,s10,1
80001290:	0341                	addi	t1,t1,16
80001292:	070b8b93          	addi	s7,s7,112
80001296:	18090913          	addi	s2,s2,384
8000129a:	0d91                	addi	s11,s11,4
8000129c:	fd3d15e3          	bne	s10,s3,80001266 <test_k_sleep+0x1c8>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
800012a0:	6b85                	lui	s7,0x1
800012a2:	895a                	mv	s2,s6
	int next_cancellation = 0;
800012a4:	4981                	li	s3,0
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
800012a6:	4d01                	li	s10,0
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
800012a8:	4c9d                	li	s9,7
800012aa:	abeb8b93          	addi	s7,s7,-1346 # abe <CONFIG_ISR_STACK_SIZE+0x2be>
		if (i == cancellations[next_cancellation]) {
800012ae:	00299793          	slli	a5,s3,0x2
800012b2:	0898                	addi	a4,sp,80
800012b4:	97ba                	add	a5,a5,a4
800012b6:	fd47a783          	lw	a5,-44(a5)
800012ba:	0fa78863          	beq	a5,s10,800013aa <test_k_sleep+0x30c>
800012be:	85de                	mv	a1,s7
800012c0:	05cc0513          	addi	a0,s8,92
800012c4:	279010ef          	jal	ra,80002d3c <z_impl_k_queue_get>
		zassert_not_null(data, " *** timeout while waiting for"
800012c8:	800067b7          	lui	a5,0x80006
800012cc:	800065b7          	lui	a1,0x80006
800012d0:	8daa                	mv	s11,a0
800012d2:	da078793          	addi	a5,a5,-608 # 80005da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005da1>
800012d6:	8ac40713          	addi	a4,s0,-1876
800012da:	34e00693          	li	a3,846
800012de:	29c48613          	addi	a2,s1,668
800012e2:	dd058593          	addi	a1,a1,-560 # 80005dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd1>
800012e6:	00a03533          	snez	a0,a0
800012ea:	8a5ff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
		zassert_equal(data->timeout_order, i,
800012ee:	008da803          	lw	a6,8(s11)
800012f2:	45e2                	lw	a1,24(sp)
800012f4:	800067b7          	lui	a5,0x80006
800012f8:	410d0533          	sub	a0,s10,a6
800012fc:	de078793          	addi	a5,a5,-544 # 80005de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005de1>
80001300:	35200693          	li	a3,850
80001304:	29c48613          	addi	a2,s1,668
80001308:	e1858593          	addi	a1,a1,-488
8000130c:	00153513          	seqz	a0,a0
80001310:	88ea                	mv	a7,s10
80001312:	8ac40713          	addi	a4,s0,-1876
80001316:	879ff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
		TC_PRINT(" got (q order: %d, t/o: %d, t/o order %d) "
8000131a:	008da683          	lw	a3,8(s11)
8000131e:	004da603          	lw	a2,4(s11)
80001322:	00cda583          	lw	a1,12(s11)
80001326:	800067b7          	lui	a5,0x80006
8000132a:	edc78513          	addi	a0,a5,-292 # 80005edc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005edd>
8000132e:	681000ef          	jal	ra,800021ae <printk>
	for (i = 0; i < NUM_TIMEOUT_THREADS; i++) {
80001332:	0d05                	addi	s10,s10,1
80001334:	0941                	addi	s2,s2,16
80001336:	f79d1ce3          	bne	s10,s9,800012ae <test_k_sleep+0x210>
	zassert_equal(num_cancellations, next_cancellation,
8000133a:	ffc98513          	addi	a0,s3,-4
8000133e:	800067b7          	lui	a5,0x80006
80001342:	800065b7          	lui	a1,0x80006
80001346:	8ac40713          	addi	a4,s0,-1876
8000134a:	29c48613          	addi	a2,s1,668
8000134e:	88ce                	mv	a7,s3
80001350:	f4878793          	addi	a5,a5,-184 # 80005f48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f49>
80001354:	35b00693          	li	a3,859
80001358:	4811                	li	a6,4
8000135a:	f8458593          	addi	a1,a1,-124 # 80005f84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f85>
8000135e:	00153513          	seqz	a0,a0
80001362:	82dff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
80001366:	2ee00593          	li	a1,750
8000136a:	05cc0513          	addi	a0,s8,92
8000136e:	1cf010ef          	jal	ra,80002d3c <z_impl_k_queue_get>
	zassert_false(data, " *** got something unexpected in the fifo");
80001372:	8ac40713          	addi	a4,s0,-1876
}
80001376:	442a                	lw	s0,136(sp)
80001378:	40ba                	lw	ra,140(sp)
8000137a:	490a                	lw	s2,128(sp)
8000137c:	59f6                	lw	s3,124(sp)
8000137e:	5b46                	lw	s6,112(sp)
80001380:	5bb6                	lw	s7,108(sp)
80001382:	5c26                	lw	s8,104(sp)
80001384:	5c96                	lw	s9,100(sp)
80001386:	5d06                	lw	s10,96(sp)
80001388:	4df6                	lw	s11,92(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
8000138a:	e70a0793          	addi	a5,s4,-400
8000138e:	29c48613          	addi	a2,s1,668
}
80001392:	5a66                	lw	s4,120(sp)
80001394:	449a                	lw	s1,132(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
80001396:	e9ca8593          	addi	a1,s5,-356
}
8000139a:	5ad6                	lw	s5,116(sp)
	zassert_false(data, " *** got something unexpected in the fifo");
8000139c:	35f00693          	li	a3,863
800013a0:	00153513          	seqz	a0,a0
}
800013a4:	6149                	addi	sp,sp,144
	zassert_false(data, " *** got something unexpected in the fifo");
800013a6:	fe8ff06f          	j	80000b8e <z_zassert.constprop.2>
			TC_PRINT(" cancelling "
800013aa:	00492603          	lw	a2,4(s2)
800013ae:	00c92583          	lw	a1,12(s2)
800013b2:	800067b7          	lui	a5,0x80006
800013b6:	f1478513          	addi	a0,a5,-236 # 80005f14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f15>
800013ba:	86ea                	mv	a3,s10
800013bc:	5f3000ef          	jal	ra,800021ae <printk>
800013c0:	875a                	mv	a4,s6
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
800013c2:	4781                	li	a5,0
				if (timeouts[j].timeout_order == i) {
800013c4:	4714                	lw	a3,8(a4)
800013c6:	01a68763          	beq	a3,s10,800013d4 <test_k_sleep+0x336>
			for (j = 0; j < NUM_TIMEOUT_THREADS; j++) {
800013ca:	0785                	addi	a5,a5,1
800013cc:	0741                	addi	a4,a4,16
800013ce:	ff979be3          	bne	a5,s9,800013c4 <test_k_sleep+0x326>
800013d2:	b5f5                	j	800012be <test_k_sleep+0x220>
				k_thread_abort(delayed_threads[j]);
800013d4:	0898                	addi	a4,sp,80
800013d6:	078a                	slli	a5,a5,0x2
800013d8:	97ba                	add	a5,a5,a4
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800013da:	fe47a503          	lw	a0,-28(a5)
				++next_cancellation;
800013de:	0985                	addi	s3,s3,1
800013e0:	668030ef          	jal	ra,80004a48 <z_impl_k_thread_abort>
				continue;
800013e4:	b7b9                	j	80001332 <test_k_sleep+0x294>

800013e6 <k_yield_entry>:
{
800013e6:	7179                	addi	sp,sp,-48
800013e8:	d422                	sw	s0,40(sp)
	thread_evidence++;      /* Prove that the thread has run */
800013ea:	80007437          	lui	s0,0x80007
800013ee:	ea040413          	addi	s0,s0,-352 # 80006ea0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea1>
800013f2:	401c                	lw	a5,0(s0)
{
800013f4:	ce4e                	sw	s3,28(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800013f6:	800079b7          	lui	s3,0x80007
	thread_evidence++;      /* Prove that the thread has run */
800013fa:	0785                	addi	a5,a5,1
800013fc:	55fd                	li	a1,-1
800013fe:	efc98513          	addi	a0,s3,-260 # 80006efc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006efd>
{
80001402:	d606                	sw	ra,44(sp)
80001404:	d226                	sw	s1,36(sp)
80001406:	d04a                	sw	s2,32(sp)
80001408:	cc52                	sw	s4,24(sp)
	thread_evidence++;      /* Prove that the thread has run */
8000140a:	c01c                	sw	a5,0(s0)
8000140c:	14a030ef          	jal	ra,80004556 <z_impl_k_sem_take>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001410:	7f3020ef          	jal	ra,80004402 <z_impl_k_current_get>
80001414:	8a2a                	mv	s4,a0
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001416:	800016b7          	lui	a3,0x80001
8000141a:	800075b7          	lui	a1,0x80007
8000141e:	80007537          	lui	a0,0x80007
80001422:	58cd                	li	a7,-13
80001424:	4801                	li	a6,0
80001426:	c202                	sw	zero,4(sp)
80001428:	c002                	sw	zero,0(sp)
8000142a:	4781                	li	a5,0
8000142c:	4701                	li	a4,0
8000142e:	9b468693          	addi	a3,a3,-1612 # 800009b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009b5>
80001432:	20000613          	li	a2,512
80001436:	74058593          	addi	a1,a1,1856 # 80007740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007741>
8000143a:	f7c50513          	addi	a0,a0,-132 # 80006f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f7d>
	thread_evidence = 0;
8000143e:	00042023          	sw	zero,0(s0)
80001442:	4ee030ef          	jal	ra,80004930 <z_impl_k_thread_create>
	zassert_equal(thread_evidence, 0,
80001446:	4008                	lw	a0,0(s0)
80001448:	80006937          	lui	s2,0x80006
8000144c:	800064b7          	lui	s1,0x80006
80001450:	800067b7          	lui	a5,0x80006
80001454:	800065b7          	lui	a1,0x80006
80001458:	87c90713          	addi	a4,s2,-1924 # 8000587c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000587d>
8000145c:	29c48613          	addi	a2,s1,668 # 8000629c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000629d>
80001460:	93c78793          	addi	a5,a5,-1732 # 8000593c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000593d>
80001464:	24800693          	li	a3,584
80001468:	97058593          	addi	a1,a1,-1680 # 80005970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005971>
8000146c:	00153513          	seqz	a0,a0
80001470:	f1eff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80001474:	407020ef          	jal	ra,8000407a <z_impl_k_yield>
	zassert_not_equal(thread_evidence, 0,
80001478:	00042803          	lw	a6,0(s0)
8000147c:	800067b7          	lui	a5,0x80006
80001480:	800065b7          	lui	a1,0x80006
80001484:	87c90713          	addi	a4,s2,-1924
80001488:	29c48613          	addi	a2,s1,668
8000148c:	01003533          	snez	a0,a6
80001490:	99478793          	addi	a5,a5,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80001494:	25200693          	li	a3,594
80001498:	9cc58593          	addi	a1,a1,-1588 # 800059cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059cd>
8000149c:	ef2ff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
	zassert_false((thread_evidence > 1),
800014a0:	00042803          	lw	a6,0(s0)
800014a4:	800067b7          	lui	a5,0x80006
800014a8:	800065b7          	lui	a1,0x80006
800014ac:	87c90713          	addi	a4,s2,-1924
800014b0:	29c48613          	addi	a2,s1,668
800014b4:	00282513          	slti	a0,a6,2
800014b8:	9ec78793          	addi	a5,a5,-1556 # 800059ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ed>
800014bc:	25600693          	li	a3,598
800014c0:	a2458593          	addi	a1,a1,-1500 # 80005a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a25>
800014c4:	ecaff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
	k_thread_priority_set(self_thread_id, self_thread_id->base.prio - 1);
800014c8:	00ea0583          	lb	a1,14(s4)
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
800014cc:	8552                	mv	a0,s4
800014ce:	15fd                	addi	a1,a1,-1
800014d0:	301020ef          	jal	ra,80003fd0 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800014d4:	3a7020ef          	jal	ra,8000407a <z_impl_k_yield>
	zassert_equal(thread_evidence, 1,
800014d8:	4008                	lw	a0,0(s0)
800014da:	800067b7          	lui	a5,0x80006
800014de:	800065b7          	lui	a1,0x80006
800014e2:	157d                	addi	a0,a0,-1
800014e4:	87c90713          	addi	a4,s2,-1924
800014e8:	29c48613          	addi	a2,s1,668
800014ec:	fe058593          	addi	a1,a1,-32 # 80005fe0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fe1>
800014f0:	00153513          	seqz	a0,a0
800014f4:	a4478793          	addi	a5,a5,-1468 # 80005a44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a45>
800014f8:	26000693          	li	a3,608
800014fc:	e92ff0ef          	jal	ra,80000b8e <z_zassert.constprop.2>
}
80001500:	5422                	lw	s0,40(sp)
80001502:	50b2                	lw	ra,44(sp)
80001504:	5492                	lw	s1,36(sp)
80001506:	5902                	lw	s2,32(sp)
80001508:	4a62                	lw	s4,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
8000150a:	efc98513          	addi	a0,s3,-260
8000150e:	49f2                	lw	s3,28(sp)
80001510:	55fd                	li	a1,-1
80001512:	6145                	addi	sp,sp,48
80001514:	0420306f          	j	80004556 <z_impl_k_sem_take>

80001518 <test_main>:
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001518:	80007537          	lui	a0,0x80007

/*test case main entry*/
void test_main(void)
{
8000151c:	1141                	addi	sp,sp,-16
8000151e:	567d                	li	a2,-1
80001520:	4581                	li	a1,0
80001522:	eec50513          	addi	a0,a0,-276 # 80006eec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eed>
80001526:	c606                	sw	ra,12(sp)
80001528:	6e5020ef          	jal	ra,8000440c <z_impl_k_sem_init>
	k_timer_init(&timer, NULL, NULL);
8000152c:	80007537          	lui	a0,0x80007
80001530:	4581                	li	a1,0
80001532:	4601                	li	a2,0
80001534:	38050513          	addi	a0,a0,896 # 80007380 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007381>
80001538:	577030ef          	jal	ra,800052ae <k_timer_init>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
8000153c:	80007537          	lui	a0,0x80007
80001540:	05c50513          	addi	a0,a0,92 # 8000705c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000705d>
80001544:	7da010ef          	jal	ra,80002d1e <z_impl_k_queue_init>
			 ztest_unit_test(test_kernel_cpu_idle),
			 ztest_unit_test(test_k_yield),
			 ztest_unit_test(test_kernel_thread)
			 );
	ztest_run_test_suite(context);
}
80001548:	40b2                	lw	ra,12(sp)
	ztest_run_test_suite(context);
8000154a:	800075b7          	lui	a1,0x80007
8000154e:	80006537          	lui	a0,0x80006
80001552:	cf858593          	addi	a1,a1,-776 # 80006cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf9>
80001556:	21850513          	addi	a0,a0,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
}
8000155a:	0141                	addi	sp,sp,16
	ztest_run_test_suite(context);
8000155c:	2480106f          	j	800027a4 <z_ztest_run_test_suite>

80001560 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80001560:	1141                	addi	sp,sp,-16
80001562:	c606                	sw	ra,12(sp)
80001564:	c422                	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80001566:	4799                	li	a5,6
80001568:	02f50263          	beq	a0,a5,8000158c <z_SysFatalErrorHandler+0x2c>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
8000156c:	170030ef          	jal	ra,800046dc <k_is_in_isr>
80001570:	c10d                	beqz	a0,80001592 <z_SysFatalErrorHandler+0x32>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80001572:	16a030ef          	jal	ra,800046dc <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80001576:	e121                	bnez	a0,800015b6 <z_SysFatalErrorHandler+0x56>
80001578:	800065b7          	lui	a1,0x80006
8000157c:	59858593          	addi	a1,a1,1432 # 80006598 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006599>
80001580:	80006537          	lui	a0,0x80006
80001584:	5ac50513          	addi	a0,a0,1452 # 800065ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065ad>
80001588:	427000ef          	jal	ra,800021ae <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
8000158c:	469000ef          	jal	ra,800021f4 <k_cpu_idle>
80001590:	bff5                	j	8000158c <z_SysFatalErrorHandler+0x2c>
	if (k_is_in_isr() || z_is_thread_essential()) {
80001592:	158030ef          	jal	ra,800046ea <z_is_thread_essential>
80001596:	fd71                	bnez	a0,80001572 <z_SysFatalErrorHandler+0x12>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80001598:	80007437          	lui	s0,0x80007
8000159c:	50c40413          	addi	s0,s0,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
800015a0:	440c                	lw	a1,8(s0)
800015a2:	80006537          	lui	a0,0x80006
800015a6:	5cc50513          	addi	a0,a0,1484 # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
800015aa:	405000ef          	jal	ra,800021ae <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800015ae:	4408                	lw	a0,8(s0)
800015b0:	498030ef          	jal	ra,80004a48 <z_impl_k_thread_abort>
800015b4:	bfe1                	j	8000158c <z_SysFatalErrorHandler+0x2c>
		printk("Fatal fault in %s! Spinning...\n",
800015b6:	800065b7          	lui	a1,0x80006
800015ba:	59458593          	addi	a1,a1,1428 # 80006594 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006595>
800015be:	b7c9                	j	80001580 <z_SysFatalErrorHandler+0x20>

800015c0 <z_NanoFatalErrorHandler>:
{
800015c0:	715d                	addi	sp,sp,-80
800015c2:	c4a2                	sw	s0,72(sp)
800015c4:	c2a6                	sw	s1,68(sp)
800015c6:	c686                	sw	ra,76(sp)
	switch (reason) {
800015c8:	4799                	li	a5,6
{
800015ca:	84aa                	mv	s1,a0
800015cc:	842e                	mv	s0,a1
	switch (reason) {
800015ce:	08a7e963          	bltu	a5,a0,80001660 <z_NanoFatalErrorHandler+0xa0>
800015d2:	80006737          	lui	a4,0x80006
800015d6:	00251793          	slli	a5,a0,0x2
800015da:	2e870713          	addi	a4,a4,744 # 800062e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062e9>
800015de:	97ba                	add	a5,a5,a4
800015e0:	439c                	lw	a5,0(a5)
800015e2:	8782                	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
800015e4:	80006537          	lui	a0,0x80006
800015e8:	41850513          	addi	a0,a0,1048 # 80006418 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006419>
		printk("***** Kernel OOPS! *****\n");
800015ec:	3c3000ef          	jal	ra,800021ae <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800015f0:	613020ef          	jal	ra,80004402 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
800015f4:	407c                	lw	a5,68(s0)
800015f6:	01042883          	lw	a7,16(s0)
800015fa:	00c42803          	lw	a6,12(s0)
800015fe:	d83e                	sw	a5,48(sp)
80001600:	403c                	lw	a5,64(s0)
80001602:	4058                	lw	a4,4(s0)
80001604:	4014                	lw	a3,0(s0)
80001606:	d63e                	sw	a5,44(sp)
80001608:	5c5c                	lw	a5,60(s0)
8000160a:	4430                	lw	a2,72(s0)
8000160c:	85aa                	mv	a1,a0
8000160e:	d43e                	sw	a5,40(sp)
80001610:	5c1c                	lw	a5,56(s0)
80001612:	80006537          	lui	a0,0x80006
80001616:	49c50513          	addi	a0,a0,1180 # 8000649c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000649d>
8000161a:	d23e                	sw	a5,36(sp)
8000161c:	585c                	lw	a5,52(s0)
8000161e:	d03e                	sw	a5,32(sp)
80001620:	581c                	lw	a5,48(s0)
80001622:	ce3e                	sw	a5,28(sp)
80001624:	545c                	lw	a5,44(s0)
80001626:	cc3e                	sw	a5,24(sp)
80001628:	541c                	lw	a5,40(s0)
8000162a:	ca3e                	sw	a5,20(sp)
8000162c:	505c                	lw	a5,36(s0)
8000162e:	c83e                	sw	a5,16(sp)
80001630:	501c                	lw	a5,32(s0)
80001632:	c63e                	sw	a5,12(sp)
80001634:	4c5c                	lw	a5,28(s0)
80001636:	c43e                	sw	a5,8(sp)
80001638:	4c1c                	lw	a5,24(s0)
8000163a:	c23e                	sw	a5,4(sp)
8000163c:	485c                	lw	a5,20(s0)
8000163e:	c03e                	sw	a5,0(sp)
80001640:	441c                	lw	a5,8(s0)
80001642:	36d000ef          	jal	ra,800021ae <printk>
	z_SysFatalErrorHandler(reason, esf);
80001646:	85a2                	mv	a1,s0
80001648:	8526                	mv	a0,s1
8000164a:	3f19                	jal	80001560 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
8000164c:	80006537          	lui	a0,0x80006
80001650:	44050513          	addi	a0,a0,1088 # 80006440 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006441>
80001654:	bf61                	j	800015ec <z_NanoFatalErrorHandler+0x2c>
		printk("***** Kernel Panic! *****\n");
80001656:	80006537          	lui	a0,0x80006
8000165a:	45c50513          	addi	a0,a0,1116 # 8000645c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000645d>
8000165e:	b779                	j	800015ec <z_NanoFatalErrorHandler+0x2c>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80001660:	80006537          	lui	a0,0x80006
80001664:	85a6                	mv	a1,s1
80001666:	47850513          	addi	a0,a0,1144 # 80006478 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006479>
8000166a:	345000ef          	jal	ra,800021ae <printk>
		break;
8000166e:	b749                	j	800015f0 <z_NanoFatalErrorHandler+0x30>

80001670 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80001670:	1141                	addi	sp,sp,-16
80001672:	c422                	sw	s0,8(sp)
80001674:	c606                	sw	ra,12(sp)
80001676:	842a                	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001678:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
8000167c:	0606                	slli	a2,a2,0x1
8000167e:	8205                	srli	a2,a2,0x1
	switch (cause) {
80001680:	4795                	li	a5,5
80001682:	02c7e363          	bltu	a5,a2,800016a8 <_Fault+0x38>
80001686:	80006737          	lui	a4,0x80006
8000168a:	00261793          	slli	a5,a2,0x2
8000168e:	30470713          	addi	a4,a4,772 # 80006304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006305>
80001692:	97ba                	add	a5,a5,a4
80001694:	438c                	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001696:	80006537          	lui	a0,0x80006
8000169a:	32450513          	addi	a0,a0,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
8000169e:	311000ef          	jal	ra,800021ae <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
800016a2:	85a2                	mv	a1,s0
800016a4:	4501                	li	a0,0
800016a6:	3f29                	jal	800015c0 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
800016a8:	800065b7          	lui	a1,0x80006
800016ac:	31c58593          	addi	a1,a1,796 # 8000631c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000631d>
800016b0:	b7dd                	j	80001696 <_Fault+0x26>

800016b2 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
800016b2:	1141                	addi	sp,sp,-16
800016b4:	c606                	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
800016b6:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
800016ba:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
800016be:	0586                	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
800016c0:	8185                	srli	a1,a1,0x1
800016c2:	5f450513          	addi	a0,a0,1524 # 800065f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065f5>
800016c6:	2e9000ef          	jal	ra,800021ae <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
800016ca:	800065b7          	lui	a1,0x80006
800016ce:	34058593          	addi	a1,a1,832 # 80006340 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006341>
800016d2:	4511                	li	a0,4
800016d4:	35f5                	jal	800015c0 <z_NanoFatalErrorHandler>

800016d6 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
800016d6:	800077b7          	lui	a5,0x80007
800016da:	ea478793          	addi	a5,a5,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800016de:	4398                	lw	a4,0(a5)
800016e0:	cb11                	beqz	a4,800016f4 <z_irq_do_offload+0x1e>
		return;

	tmp = _offload_routine;
800016e2:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
800016e6:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
800016ea:	800077b7          	lui	a5,0x80007
800016ee:	ea87a503          	lw	a0,-344(a5) # 80006ea8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea9>
800016f2:	8302                	jr	t1
}
800016f4:	8082                	ret

800016f6 <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
800016f6:	47a1                	li	a5,8
800016f8:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
800016fc:	80007737          	lui	a4,0x80007
80001700:	eaa72223          	sw	a0,-348(a4) # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
	offload_param = parameter;
80001704:	80007737          	lui	a4,0x80007
80001708:	eab72423          	sw	a1,-344(a4) # 80006ea8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea9>

	__asm__ volatile ("ecall");
8000170c:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80001710:	8ba1                	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80001712:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
80001716:	8082                	ret

80001718 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80001718:	1141                	addi	sp,sp,-16
8000171a:	c606                	sw	ra,12(sp)
	z_bss_zero();
8000171c:	318010ef          	jal	ra,80002a34 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80001720:	2f9000ef          	jal	ra,80002218 <soc_interrupt_init>
#endif
	z_cstart();
80001724:	364010ef          	jal	ra,80002a88 <z_cstart>

80001728 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80001728:	7179                	addi	sp,sp,-48
8000172a:	d422                	sw	s0,40(sp)
8000172c:	d226                	sw	s1,36(sp)
8000172e:	d04a                	sw	s2,32(sp)
80001730:	ce4e                	sw	s3,28(sp)
80001732:	cc52                	sw	s4,24(sp)
80001734:	ca56                	sw	s5,20(sp)
80001736:	c85a                	sw	s6,16(sp)
80001738:	c65e                	sw	s7,12(sp)
8000173a:	8b3e                	mv	s6,a5
8000173c:	d606                	sw	ra,44(sp)
8000173e:	c462                	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001740:	47bd                	li	a5,15
{
80001742:	84aa                	mv	s1,a0
80001744:	842e                	mv	s0,a1
80001746:	89b2                	mv	s3,a2
80001748:	8a36                	mv	s4,a3
8000174a:	8bba                	mv	s7,a4
8000174c:	8ac2                	mv	s5,a6
8000174e:	8946                	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001750:	06f89463          	bne	a7,a5,800017b8 <z_new_thread+0x90>
80001754:	800037b7          	lui	a5,0x80003
80001758:	a0e78793          	addi	a5,a5,-1522 # 80002a0e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002a0f>
8000175c:	06f69363          	bne	a3,a5,800017c2 <z_new_thread+0x9a>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80001760:	56c2                	lw	a3,48(sp)
80001762:	85ca                	mv	a1,s2
80001764:	8526                	mv	a0,s1
80001766:	4611                	li	a2,4
80001768:	042030ef          	jal	ra,800047aa <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
8000176c:	fb098593          	addi	a1,s3,-80
80001770:	95a2                	add	a1,a1,s0
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001772:	6789                	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80001774:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001778:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
8000177c:	99c1                	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
8000177e:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80001782:	c5fc                	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001784:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80001788:	50b2                	lw	ra,44(sp)
8000178a:	5422                	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
8000178c:	9ac78793          	addi	a5,a5,-1620 # 800009ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009ad>
	stack_init->a0 = (u32_t)thread_func;
80001790:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80001794:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80001798:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
8000179c:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800017a0:	c5bc                	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
800017a2:	d48c                	sw	a1,40(s1)
}
800017a4:	5902                	lw	s2,32(sp)
800017a6:	5492                	lw	s1,36(sp)
800017a8:	49f2                	lw	s3,28(sp)
800017aa:	4a62                	lw	s4,24(sp)
800017ac:	4ad2                	lw	s5,20(sp)
800017ae:	4b42                	lw	s6,16(sp)
800017b0:	4bb2                	lw	s7,12(sp)
800017b2:	4c22                	lw	s8,8(sp)
800017b4:	6145                	addi	sp,sp,48
800017b6:	8082                	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800017b8:	01088693          	addi	a3,a7,16
800017bc:	47f9                	li	a5,30
800017be:	fad7f1e3          	bgeu	a5,a3,80001760 <z_new_thread+0x38>
800017c2:	80006c37          	lui	s8,0x80006
800017c6:	800065b7          	lui	a1,0x80006
800017ca:	80006537          	lui	a0,0x80006
800017ce:	61cc0613          	addi	a2,s8,1564 # 8000661c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000661d>
800017d2:	46e1                	li	a3,24
800017d4:	63c58593          	addi	a1,a1,1596 # 8000663c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000663d>
800017d8:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800017dc:	1d3000ef          	jal	ra,800021ae <printk>
800017e0:	80006537          	lui	a0,0x80006
800017e4:	85ca                	mv	a1,s2
800017e6:	56c1                	li	a3,-16
800017e8:	4639                	li	a2,14
800017ea:	6e850513          	addi	a0,a0,1768 # 800066e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066e9>
800017ee:	1c1000ef          	jal	ra,800021ae <printk>
800017f2:	45e1                	li	a1,24
800017f4:	61cc0513          	addi	a0,s8,1564
800017f8:	1d5000ef          	jal	ra,800021cc <assert_post_action>
800017fc:	b795                	j	80001760 <z_new_thread+0x38>

800017fe <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
800017fe:	00159793          	slli	a5,a1,0x1
80001802:	97ae                	add	a5,a5,a1
80001804:	00279713          	slli	a4,a5,0x2
80001808:	455c                	lw	a5,12(a0)
8000180a:	97ba                	add	a5,a5,a4
8000180c:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001810:	00b75363          	bge	a4,a1,80001816 <get_bit_ptr+0x18>
80001814:	439c                	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001816:	41f65713          	srai	a4,a2,0x1f
8000181a:	8b7d                	andi	a4,a4,31
8000181c:	9732                	add	a4,a4,a2
8000181e:	8715                	srai	a4,a4,0x5
80001820:	070a                	slli	a4,a4,0x2
80001822:	97ba                	add	a5,a5,a4
80001824:	c29c                	sw	a5,0(a3)

	return bn & 0x1f;
}
80001826:	01f67513          	andi	a0,a2,31
8000182a:	8082                	ret

8000182c <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
8000182c:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
8000182e:	0074                	addi	a3,sp,12
{
80001830:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001832:	37f1                	jal	800017fe <get_bit_ptr>

	*word |= (1<<bit);
80001834:	4732                	lw	a4,12(sp)
80001836:	4785                	li	a5,1
80001838:	00a79533          	sll	a0,a5,a0
8000183c:	431c                	lw	a5,0(a4)
}
8000183e:	40f2                	lw	ra,28(sp)
	*word |= (1<<bit);
80001840:	8fc9                	or	a5,a5,a0
80001842:	c31c                	sw	a5,0(a4)
}
80001844:	6105                	addi	sp,sp,32
80001846:	8082                	ret

80001848 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001848:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
8000184a:	0074                	addi	a3,sp,12
{
8000184c:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
8000184e:	3f45                	jal	800017fe <get_bit_ptr>

	*word &= ~(1<<bit);
80001850:	4732                	lw	a4,12(sp)
80001852:	4785                	li	a5,1
80001854:	00a79533          	sll	a0,a5,a0
80001858:	431c                	lw	a5,0(a4)
}
8000185a:	40f2                	lw	ra,28(sp)
	*word &= ~(1<<bit);
8000185c:	fff54513          	not	a0,a0
80001860:	8d7d                	and	a0,a0,a5
80001862:	c308                	sw	a0,0(a4)
}
80001864:	6105                	addi	sp,sp,32
80001866:	8082                	ret

80001868 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80001868:	1101                	addi	sp,sp,-32
8000186a:	ca26                	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000186c:	4144                	lw	s1,4(a0)
{
8000186e:	cc22                	sw	s0,24(sp)
80001870:	842a                	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001872:	00855503          	lhu	a0,8(a0)
80001876:	85a6                	mv	a1,s1
{
80001878:	c84a                	sw	s2,16(sp)
8000187a:	c64e                	sw	s3,12(sp)
8000187c:	c452                	sw	s4,8(sp)
8000187e:	c256                	sw	s5,4(sp)
80001880:	c05a                	sw	s6,0(sp)
80001882:	ce06                	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001884:	fa9fe0ef          	jal	ra,8000082c <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001888:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
8000188c:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80001890:	57fd                	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001892:	8a2a                	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001894:	99aa                	add	s3,s3,a0
	p->max_inline_level = -1;
80001896:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
8000189a:	4901                	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
8000189c:	4b7d                	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
8000189e:	03594163          	blt	s2,s5,800018c0 <z_sys_mem_pool_base_init+0x58>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
800018a2:	4481                	li	s1,0
800018a4:	00845783          	lhu	a5,8(s0)
800018a8:	04f4cf63          	blt	s1,a5,80001906 <z_sys_mem_pool_base_init+0x9e>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
800018ac:	40f2                	lw	ra,28(sp)
800018ae:	4462                	lw	s0,24(sp)
800018b0:	44d2                	lw	s1,20(sp)
800018b2:	4942                	lw	s2,16(sp)
800018b4:	49b2                	lw	s3,12(sp)
800018b6:	4a22                	lw	s4,8(sp)
800018b8:	4a92                	lw	s5,4(sp)
800018ba:	4b02                	lw	s6,0(sp)
800018bc:	6105                	addi	sp,sp,32
800018be:	8082                	ret
		int nblocks = buflen / sz;
800018c0:	85a6                	mv	a1,s1
800018c2:	8552                	mv	a0,s4
800018c4:	824ff0ef          	jal	ra,800008e8 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
800018c8:	00191713          	slli	a4,s2,0x1
800018cc:	974a                	add	a4,a4,s2
800018ce:	00271793          	slli	a5,a4,0x2
800018d2:	4458                	lw	a4,12(s0)
800018d4:	973e                	add	a4,a4,a5
800018d6:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
800018da:	c35c                	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
800018dc:	c71c                	sw	a5,8(a4)
		if (nblocks < 32) {
800018de:	00ab4963          	blt	s6,a0,800018f0 <z_sys_mem_pool_base_init+0x88>
			p->max_inline_level = i;
800018e2:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
800018e6:	8089                	srli	s1,s1,0x2
800018e8:	048d                	addi	s1,s1,3
800018ea:	98f1                	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
800018ec:	0905                	addi	s2,s2,1
800018ee:	bf45                	j	8000189e <z_sys_mem_pool_base_init+0x36>
			bits += (nblocks + 31)/32;
800018f0:	057d                	addi	a0,a0,31
800018f2:	41f55793          	srai	a5,a0,0x1f
800018f6:	8bfd                	andi	a5,a5,31
800018f8:	97aa                	add	a5,a5,a0
800018fa:	8795                	srai	a5,a5,0x5
800018fc:	078a                	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
800018fe:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80001902:	99be                	add	s3,s3,a5
80001904:	b7cd                	j	800018e6 <z_sys_mem_pool_base_init+0x7e>
	return (u8_t *)p->buf + lsz * block;
80001906:	404c                	lw	a1,4(s0)
80001908:	8526                	mv	a0,s1
8000190a:	f23fe0ef          	jal	ra,8000082c <__mulsi3>
8000190e:	401c                	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001910:	8626                	mv	a2,s1
80001912:	4581                	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001914:	953e                	add	a0,a0,a5
		sys_dlist_append(&p->levels[0].free_list, block);
80001916:	445c                	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001918:	0485                	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
8000191a:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
8000191e:	c118                	sw	a4,0(a0)
	node->prev = list->tail;
80001920:	4798                	lw	a4,8(a5)
80001922:	c158                	sw	a4,4(a0)

	list->tail->next = node;
80001924:	4798                	lw	a4,8(a5)
80001926:	c308                	sw	a0,0(a4)
	list->tail = node;
80001928:	c788                	sw	a0,8(a5)
		set_free_bit(p, 0, i);
8000192a:	8522                	mv	a0,s0
8000192c:	3701                	jal	8000182c <set_free_bit>
8000192e:	bf9d                	j	800018a4 <z_sys_mem_pool_base_init+0x3c>

80001930 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001930:	711d                	addi	sp,sp,-96
80001932:	cca2                	sw	s0,88(sp)
80001934:	c2d6                	sw	s5,68(sp)
80001936:	ce86                	sw	ra,92(sp)
80001938:	caa6                	sw	s1,84(sp)
8000193a:	c8ca                	sw	s2,80(sp)
8000193c:	c6ce                	sw	s3,76(sp)
8000193e:	c4d2                	sw	s4,72(sp)
80001940:	c0da                	sw	s6,64(sp)
80001942:	de5e                	sw	s7,60(sp)
80001944:	dc62                	sw	s8,56(sp)
80001946:	da66                	sw	s9,52(sp)
80001948:	d86a                	sw	s10,48(sp)
8000194a:	d66e                	sw	s11,44(sp)
8000194c:	1080                	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000194e:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001952:	4881                	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001954:	002e1793          	slli	a5,t3,0x2
80001958:	07bd                	addi	a5,a5,15
8000195a:	7f07f793          	andi	a5,a5,2032
8000195e:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80001962:	415c                	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001964:	8a8a                	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001966:	8356                	mv	t1,s5
80001968:	078d                	addi	a5,a5,3
8000196a:	9bf1                	andi	a5,a5,-4
8000196c:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
80001970:	fff88b13          	addi	s6,a7,-1
80001974:	03c8d263          	bge	a7,t3,80001998 <z_sys_mem_pool_block_alloc+0x68>
		if (i > 0) {
80001978:	00088b63          	beqz	a7,8000198e <z_sys_mem_pool_block_alloc+0x5e>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000197c:	ffc32803          	lw	a6,-4(t1)
80001980:	00285813          	srli	a6,a6,0x2
80001984:	080d                	addi	a6,a6,3
80001986:	ffc87813          	andi	a6,a6,-4
8000198a:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
8000198e:	0311                	addi	t1,t1,4
80001990:	ffc32803          	lw	a6,-4(t1)
80001994:	02b87963          	bgeu	a6,a1,800019c6 <z_sys_mem_pool_block_alloc+0x96>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80001998:	55fd                	li	a1,-1
8000199a:	02bb1863          	bne	s6,a1,800019ca <z_sys_mem_pool_block_alloc+0x9a>
		*data_p = NULL;
8000199e:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
800019a2:	5551                	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
800019a4:	fa040113          	addi	sp,s0,-96
800019a8:	40f6                	lw	ra,92(sp)
800019aa:	4466                	lw	s0,88(sp)
800019ac:	44d6                	lw	s1,84(sp)
800019ae:	4946                	lw	s2,80(sp)
800019b0:	49b6                	lw	s3,76(sp)
800019b2:	4a26                	lw	s4,72(sp)
800019b4:	4a96                	lw	s5,68(sp)
800019b6:	4b06                	lw	s6,64(sp)
800019b8:	5bf2                	lw	s7,60(sp)
800019ba:	5c62                	lw	s8,56(sp)
800019bc:	5cd2                	lw	s9,52(sp)
800019be:	5d42                	lw	s10,48(sp)
800019c0:	5db2                	lw	s11,44(sp)
800019c2:	6125                	addi	sp,sp,96
800019c4:	8082                	ret
	for (i = 0; i < p->n_levels; i++) {
800019c6:	0885                	addi	a7,a7,1
800019c8:	b765                	j	80001970 <z_sys_mem_pool_block_alloc+0x40>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800019ca:	01054583          	lbu	a1,16(a0)
		return 0;
800019ce:	4901                	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800019d0:	8985                	andi	a1,a1,1
800019d2:	c591                	beqz	a1,800019de <z_sys_mem_pool_block_alloc+0xae>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800019d4:	4921                	li	s2,8
800019d6:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
800019da:	00897913          	andi	s2,s2,8
800019de:	fae42a23          	sw	a4,-76(s0)
800019e2:	001b1713          	slli	a4,s6,0x1
800019e6:	fad42c23          	sw	a3,-72(s0)
800019ea:	975a                	add	a4,a4,s6
800019ec:	4554                	lw	a3,12(a0)
800019ee:	070a                	slli	a4,a4,0x2
800019f0:	0711                	addi	a4,a4,4
800019f2:	9736                	add	a4,a4,a3
800019f4:	fac42e23          	sw	a2,-68(s0)
800019f8:	84aa                	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
800019fa:	8a5a                	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
800019fc:	56fd                	li	a3,-1
	return list->head == list;
800019fe:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001a02:	13370863          	beq	a4,s3,80001b32 <z_sys_mem_pool_block_alloc+0x202>
		data = block_alloc(p, i, lsizes[i]);
80001a06:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
80001a0a:	0049a683          	lw	a3,4(s3)
80001a0e:	00ea8cb3          	add	s9,s5,a4
80001a12:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a16:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001a1a:	4d21                	li	s10,8
80001a1c:	c298                	sw	a4,0(a3)
	node->next->prev = node->prev;
80001a1e:	c354                	sw	a3,4(a4)
	node->next = NULL;
80001a20:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80001a24:	0009a223          	sw	zero,4(s3)
80001a28:	4088                	lw	a0,0(s1)
80001a2a:	40a98533          	sub	a0,s3,a0
80001a2e:	eb3fe0ef          	jal	ra,800008e0 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
80001a32:	862a                	mv	a2,a0
80001a34:	85d2                	mv	a1,s4
80001a36:	8526                	mv	a0,s1
80001a38:	3d01                	jal	80001848 <clear_free_bit>
		if (data != NULL) {
80001a3a:	0a05                	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
80001a3c:	fffa0693          	addi	a3,s4,-1
80001a40:	0566c263          	blt	a3,s6,80001a84 <z_sys_mem_pool_block_alloc+0x154>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001a44:	0104c703          	lbu	a4,16(s1)
80001a48:	8b05                	andi	a4,a4,1
80001a4a:	c319                	beqz	a4,80001a50 <z_sys_mem_pool_block_alloc+0x120>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001a4c:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80001a50:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
80001a54:	5551                	li	a0,-12
	*data_p = data;
80001a56:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80001a5a:	f40985e3          	beqz	s3,800019a4 <z_sys_mem_pool_block_alloc+0x74>
	*level_p = alloc_l;
80001a5e:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a62:	4088                	lw	a0,0(s1)
	*level_p = alloc_l;
80001a64:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001a68:	002b1793          	slli	a5,s6,0x2
80001a6c:	9abe                	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a6e:	000aa583          	lw	a1,0(s5)
80001a72:	40a98533          	sub	a0,s3,a0
80001a76:	e6bfe0ef          	jal	ra,800008e0 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001a7a:	fb842783          	lw	a5,-72(s0)
80001a7e:	c388                	sw	a0,0(a5)
	return 0;
80001a80:	4501                	li	a0,0
80001a82:	b70d                	j	800019a4 <z_sys_mem_pool_block_alloc+0x74>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a84:	4088                	lw	a0,0(s1)
80001a86:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
80001a8a:	4b85                	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a8c:	40a98533          	sub	a0,s3,a0
80001a90:	e51fe0ef          	jal	ra,800008e0 <__divsi3>
80001a94:	001a1893          	slli	a7,s4,0x1
80001a98:	98d2                	add	a7,a7,s4
		int lbn = 4*bn + i;
80001a9a:	00251d93          	slli	s11,a0,0x2
80001a9e:	088a                	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
80001aa0:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
80001aa4:	85de                	mv	a1,s7
80001aa6:	fb142623          	sw	a7,-84(s0)
80001aaa:	8536                	mv	a0,a3
80001aac:	fad42823          	sw	a3,-80(s0)
80001ab0:	d7dfe0ef          	jal	ra,8000082c <__mulsi3>
80001ab4:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
80001ab8:	01bb8633          	add	a2,s7,s11
80001abc:	85d2                	mv	a1,s4
80001abe:	8526                	mv	a0,s1
80001ac0:	33b5                	jal	8000182c <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001ac2:	fb042683          	lw	a3,-80(s0)
80001ac6:	4090                	lw	a2,0(s1)
	return p->n_max * p->max_sz;
80001ac8:	40cc                	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001aca:	16fd                	addi	a3,a3,-1
	return p->n_max * p->max_sz;
80001acc:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001ad0:	96e2                	add	a3,a3,s8
80001ad2:	8e91                	sub	a3,a3,a2
80001ad4:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
80001ad8:	d55fe0ef          	jal	ra,8000082c <__mulsi3>
		if (block_fits(p, block2, lsz)) {
80001adc:	fb042683          	lw	a3,-80(s0)
80001ae0:	fac42883          	lw	a7,-84(s0)
80001ae4:	02a6f063          	bgeu	a3,a0,80001b04 <z_sys_mem_pool_block_alloc+0x1d4>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80001ae8:	44d4                	lw	a3,12(s1)
80001aea:	96c6                	add	a3,a3,a7
80001aec:	00468613          	addi	a2,a3,4
	node->next = list;
80001af0:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
80001af4:	4690                	lw	a2,8(a3)
80001af6:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
80001afa:	4690                	lw	a2,8(a3)
80001afc:	01862023          	sw	s8,0(a2)
	list->tail = node;
80001b00:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
80001b04:	0b85                	addi	s7,s7,1
80001b06:	4791                	li	a5,4
80001b08:	f8fb9ce3          	bne	s7,a5,80001aa0 <z_sys_mem_pool_block_alloc+0x170>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001b0c:	0104c683          	lbu	a3,16(s1)
80001b10:	8a85                	andi	a3,a3,1
80001b12:	e689                	bnez	a3,80001b1c <z_sys_mem_pool_block_alloc+0x1ec>
		return 0;
80001b14:	4901                	li	s2,0
80001b16:	0a05                	addi	s4,s4,1
80001b18:	0c91                	addi	s9,s9,4
80001b1a:	b70d                	j	80001a3c <z_sys_mem_pool_block_alloc+0x10c>
80001b1c:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001b20:	0104c683          	lbu	a3,16(s1)
80001b24:	8a85                	andi	a3,a3,1
80001b26:	d6fd                	beqz	a3,80001b14 <z_sys_mem_pool_block_alloc+0x1e4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001b28:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
80001b2c:	00897913          	andi	s2,s2,8
80001b30:	b7dd                	j	80001b16 <z_sys_mem_pool_block_alloc+0x1e6>
	for (i = alloc_l; i >= 0; i--) {
80001b32:	1a7d                	addi	s4,s4,-1
80001b34:	ff498713          	addi	a4,s3,-12
80001b38:	ecda13e3          	bne	s4,a3,800019fe <z_sys_mem_pool_block_alloc+0xce>
80001b3c:	4981                	li	s3,0
80001b3e:	b719                	j	80001a44 <z_sys_mem_pool_block_alloc+0x114>

80001b40 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001b40:	711d                	addi	sp,sp,-96
80001b42:	cca2                	sw	s0,88(sp)
80001b44:	c4d2                	sw	s4,72(sp)
80001b46:	da66                	sw	s9,52(sp)
80001b48:	ce86                	sw	ra,92(sp)
80001b4a:	caa6                	sw	s1,84(sp)
80001b4c:	c8ca                	sw	s2,80(sp)
80001b4e:	c6ce                	sw	s3,76(sp)
80001b50:	c2d6                	sw	s5,68(sp)
80001b52:	c0da                	sw	s6,64(sp)
80001b54:	de5e                	sw	s7,60(sp)
80001b56:	dc62                	sw	s8,56(sp)
80001b58:	d86a                	sw	s10,48(sp)
80001b5a:	d66e                	sw	s11,44(sp)
80001b5c:	1080                	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001b5e:	00a54703          	lbu	a4,10(a0)
{
80001b62:	8caa                	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001b64:	070a                	slli	a4,a4,0x2
80001b66:	073d                	addi	a4,a4,15
80001b68:	7f077713          	andi	a4,a4,2032
80001b6c:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
80001b70:	4158                	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001b72:	8a0a                	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001b74:	86d2                	mv	a3,s4
80001b76:	070d                	addi	a4,a4,3
80001b78:	9b71                	andi	a4,a4,-4
80001b7a:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
80001b7e:	4505                	li	a0,1
80001b80:	0691                	addi	a3,a3,4
80001b82:	08a5f363          	bgeu	a1,a0,80001c08 <z_sys_mem_pool_block_free+0xc8>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001b86:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001b8a:	892e                	mv	s2,a1
80001b8c:	89b2                	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001b8e:	8b05                	andi	a4,a4,1
		return 0;
80001b90:	4481                	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001b92:	c709                	beqz	a4,80001b9c <z_sys_mem_pool_block_free+0x5c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001b94:	44a1                	li	s1,8
80001b96:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80001b9a:	88a1                	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
80001b9c:	80006b37          	lui	s6,0x80006
	while (level >= 0) {
80001ba0:	06095c63          	bgez	s2,80001c18 <z_sys_mem_pool_block_free+0xd8>
	__ASSERT(0, "out of levels");
80001ba4:	800064b7          	lui	s1,0x80006
80001ba8:	800065b7          	lui	a1,0x80006
80001bac:	80006537          	lui	a0,0x80006
80001bb0:	71c48613          	addi	a2,s1,1820 # 8000671c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000671d>
80001bb4:	0c000693          	li	a3,192
80001bb8:	78458593          	addi	a1,a1,1924 # 80006784 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006785>
80001bbc:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80001bc0:	23fd                	jal	800021ae <printk>
80001bc2:	80006537          	lui	a0,0x80006
80001bc6:	75050513          	addi	a0,a0,1872 # 80006750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006751>
80001bca:	23d5                	jal	800021ae <printk>
80001bcc:	71c48513          	addi	a0,s1,1820
80001bd0:	0c000593          	li	a1,192
80001bd4:	2be5                	jal	800021cc <assert_post_action>
	return -1;
80001bd6:	54fd                	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001bd8:	010cc783          	lbu	a5,16(s9)
80001bdc:	8b85                	andi	a5,a5,1
80001bde:	c781                	beqz	a5,80001be6 <z_sys_mem_pool_block_free+0xa6>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80001be0:	88a1                	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001be2:	3004a4f3          	csrrs	s1,mstatus,s1
}
80001be6:	fa040113          	addi	sp,s0,-96
80001bea:	40f6                	lw	ra,92(sp)
80001bec:	4466                	lw	s0,88(sp)
80001bee:	44d6                	lw	s1,84(sp)
80001bf0:	4946                	lw	s2,80(sp)
80001bf2:	49b6                	lw	s3,76(sp)
80001bf4:	4a26                	lw	s4,72(sp)
80001bf6:	4a96                	lw	s5,68(sp)
80001bf8:	4b06                	lw	s6,64(sp)
80001bfa:	5bf2                	lw	s7,60(sp)
80001bfc:	5c62                	lw	s8,56(sp)
80001bfe:	5cd2                	lw	s9,52(sp)
80001c00:	5d42                	lw	s10,48(sp)
80001c02:	5db2                	lw	s11,44(sp)
80001c04:	6125                	addi	sp,sp,96
80001c06:	8082                	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001c08:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
80001c0c:	0505                	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001c0e:	8309                	srli	a4,a4,0x2
80001c10:	070d                	addi	a4,a4,3
80001c12:	9b71                	andi	a4,a4,-4
80001c14:	c298                	sw	a4,0(a3)
80001c16:	b7ad                	j	80001b80 <z_sys_mem_pool_block_free+0x40>
		int i, lsz = lsizes[level];
80001c18:	00291713          	slli	a4,s2,0x2
80001c1c:	9752                	add	a4,a4,s4
80001c1e:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
80001c22:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
80001c26:	854e                	mv	a0,s3
80001c28:	85d6                	mv	a1,s5
80001c2a:	c03fe0ef          	jal	ra,8000082c <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001c2e:	fffa8b93          	addi	s7,s5,-1
80001c32:	01750d33          	add	s10,a0,s7
80001c36:	9c2a                	add	s8,s8,a0
	return p->n_max * p->max_sz;
80001c38:	004ca583          	lw	a1,4(s9)
80001c3c:	008cd503          	lhu	a0,8(s9)
80001c40:	bedfe0ef          	jal	ra,8000082c <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
80001c44:	02ad6963          	bltu	s10,a0,80001c76 <z_sys_mem_pool_block_free+0x136>
80001c48:	800067b7          	lui	a5,0x80006
80001c4c:	73078593          	addi	a1,a5,1840 # 80006730 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006731>
80001c50:	800067b7          	lui	a5,0x80006
80001c54:	6c878513          	addi	a0,a5,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80001c58:	0a400693          	li	a3,164
80001c5c:	71cb0613          	addi	a2,s6,1820 # 8000671c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000671d>
80001c60:	23b9                	jal	800021ae <printk>
80001c62:	800067b7          	lui	a5,0x80006
80001c66:	74c78513          	addi	a0,a5,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80001c6a:	2391                	jal	800021ae <printk>
80001c6c:	0a400593          	li	a1,164
80001c70:	71cb0513          	addi	a0,s6,1820
80001c74:	2ba1                	jal	800021cc <assert_post_action>
		set_free_bit(p, level, bn);
80001c76:	864e                	mv	a2,s3
80001c78:	85ca                	mv	a1,s2
80001c7a:	8566                	mv	a0,s9
80001c7c:	3e45                	jal	8000182c <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
80001c7e:	00191713          	slli	a4,s2,0x1
80001c82:	974a                	add	a4,a4,s2
80001c84:	00271693          	slli	a3,a4,0x2
80001c88:	00cca703          	lw	a4,12(s9)
80001c8c:	9736                	add	a4,a4,a3
80001c8e:	00470693          	addi	a3,a4,4
	node->next = list;
80001c92:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
80001c96:	4714                	lw	a3,8(a4)
80001c98:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
80001c9c:	4714                	lw	a3,8(a4)
80001c9e:	0186a023          	sw	s8,0(a3)
	list->tail = node;
80001ca2:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001ca6:	010cc703          	lbu	a4,16(s9)
80001caa:	8b05                	andi	a4,a4,1
80001cac:	e345                	bnez	a4,80001d4c <z_sys_mem_pool_block_free+0x20c>
		return 0;
80001cae:	4481                	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001cb0:	f20904e3          	beqz	s2,80001bd8 <z_sys_mem_pool_block_free+0x98>
	int bit = get_bit_ptr(p, level, bn, &word);
80001cb4:	fbc40693          	addi	a3,s0,-68
80001cb8:	864e                	mv	a2,s3
80001cba:	85ca                	mv	a1,s2
80001cbc:	8566                	mv	a0,s9
80001cbe:	3681                	jal	800017fe <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80001cc0:	fbc42683          	lw	a3,-68(s0)
80001cc4:	41f55713          	srai	a4,a0,0x1f
80001cc8:	8b0d                	andi	a4,a4,3
80001cca:	972a                	add	a4,a4,a0
80001ccc:	4288                	lw	a0,0(a3)
80001cce:	9b71                	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001cd0:	47bd                	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
80001cd2:	00e55733          	srl	a4,a0,a4
80001cd6:	8b3d                	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001cd8:	f0f710e3          	bne	a4,a5,80001bd8 <z_sys_mem_pool_block_free+0x98>
		for (i = 0; i < 4; i++) {
80001cdc:	4d01                	li	s10,0
			int b = (bn & ~3) + i;
80001cde:	ffc9fd93          	andi	s11,s3,-4
80001ce2:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
80001ce6:	8532                	mv	a0,a2
80001ce8:	85d6                	mv	a1,s5
80001cea:	fac42423          	sw	a2,-88(s0)
80001cee:	b3ffe0ef          	jal	ra,8000082c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001cf2:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
80001cf6:	8c2a                	mv	s8,a0
	return p->n_max * p->max_sz;
80001cf8:	004ca583          	lw	a1,4(s9)
80001cfc:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001d00:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001d04:	b29fe0ef          	jal	ra,8000082c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001d08:	fac42703          	lw	a4,-84(s0)
80001d0c:	fa842603          	lw	a2,-88(s0)
80001d10:	02a77263          	bgeu	a4,a0,80001d34 <z_sys_mem_pool_block_free+0x1f4>
				clear_free_bit(p, level, b);
80001d14:	85ca                	mv	a1,s2
80001d16:	8566                	mv	a0,s9
80001d18:	3e05                	jal	80001848 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
80001d1a:	000ca703          	lw	a4,0(s9)
80001d1e:	9c3a                	add	s8,s8,a4
	node->prev->next = node->next;
80001d20:	004c2603          	lw	a2,4(s8)
80001d24:	000c2703          	lw	a4,0(s8)
80001d28:	c218                	sw	a4,0(a2)
	node->next->prev = node->prev;
80001d2a:	c350                	sw	a2,4(a4)
	node->next = NULL;
80001d2c:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80001d30:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80001d34:	0d05                	addi	s10,s10,1
80001d36:	4791                	li	a5,4
80001d38:	fafd15e3          	bne	s10,a5,80001ce2 <z_sys_mem_pool_block_free+0x1a2>
		bn = bn / 4;
80001d3c:	41f9d613          	srai	a2,s3,0x1f
80001d40:	8a0d                	andi	a2,a2,3
80001d42:	99b2                	add	s3,s3,a2
		level = level - 1;
80001d44:	197d                	addi	s2,s2,-1
		bn = bn / 4;
80001d46:	4029d993          	srai	s3,s3,0x2
80001d4a:	bd99                	j	80001ba0 <z_sys_mem_pool_block_free+0x60>
80001d4c:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001d50:	010cc703          	lbu	a4,16(s9)
80001d54:	8b05                	andi	a4,a4,1
80001d56:	df21                	beqz	a4,80001cae <z_sys_mem_pool_block_free+0x16e>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001d58:	47a1                	li	a5,8
80001d5a:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
80001d5e:	88a1                	andi	s1,s1,8
80001d60:	bf81                	j	80001cb0 <z_sys_mem_pool_block_free+0x170>

80001d62 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001d62:	1141                	addi	sp,sp,-16
80001d64:	87aa                	mv	a5,a0
80001d66:	852e                	mv	a0,a1
80001d68:	85b2                	mv	a1,a2
	entry(p1, p2, p3);
80001d6a:	8636                	mv	a2,a3
{
80001d6c:	c606                	sw	ra,12(sp)
	entry(p1, p2, p3);
80001d6e:	9782                	jalr	a5
80001d70:	692020ef          	jal	ra,80004402 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001d74:	4d5020ef          	jal	ra,80004a48 <z_impl_k_thread_abort>

80001d78 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001d78:	4501                	li	a0,0
80001d7a:	8082                	ret

80001d7c <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001d7c:	1141                	addi	sp,sp,-16
80001d7e:	c422                	sw	s0,8(sp)
80001d80:	842a                	mv	s0,a0
	out('E', ctx);
80001d82:	04500513          	li	a0,69
{
80001d86:	c606                	sw	ra,12(sp)
80001d88:	c226                	sw	s1,4(sp)
80001d8a:	84ae                	mv	s1,a1
	out('E', ctx);
80001d8c:	9402                	jalr	s0
	out('R', ctx);
80001d8e:	85a6                	mv	a1,s1
80001d90:	05200513          	li	a0,82
80001d94:	9402                	jalr	s0
	out('R', ctx);
80001d96:	8322                	mv	t1,s0
}
80001d98:	4422                	lw	s0,8(sp)
80001d9a:	40b2                	lw	ra,12(sp)
	out('R', ctx);
80001d9c:	85a6                	mv	a1,s1
}
80001d9e:	4492                	lw	s1,4(sp)
	out('R', ctx);
80001da0:	05200513          	li	a0,82
}
80001da4:	0141                	addi	sp,sp,16
	out('R', ctx);
80001da6:	8302                	jr	t1

80001da8 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001da8:	419c                	lw	a5,0(a1)
80001daa:	0785                	addi	a5,a5,1
80001dac:	c19c                	sw	a5,0(a1)
	return _char_out(c);
80001dae:	800077b7          	lui	a5,0x80007
80001db2:	e307a303          	lw	t1,-464(a5) # 80006e30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e31>
80001db6:	8302                	jr	t1

80001db8 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001db8:	7139                	addi	sp,sp,-64
80001dba:	dc22                	sw	s0,56(sp)
80001dbc:	d64e                	sw	s3,44(sp)
80001dbe:	d452                	sw	s4,40(sp)
80001dc0:	d05a                	sw	s6,32(sp)
80001dc2:	c86a                	sw	s10,16(sp)
80001dc4:	de06                	sw	ra,60(sp)
80001dc6:	da26                	sw	s1,52(sp)
80001dc8:	d84a                	sw	s2,48(sp)
80001dca:	d256                	sw	s5,36(sp)
80001dcc:	ce5e                	sw	s7,28(sp)
80001dce:	cc62                	sw	s8,24(sp)
80001dd0:	ca66                	sw	s9,20(sp)
80001dd2:	c66e                	sw	s11,12(sp)
80001dd4:	89aa                	mv	s3,a0
80001dd6:	8a2e                	mv	s4,a1
80001dd8:	8d32                	mv	s10,a2
80001dda:	8b36                	mv	s6,a3
80001ddc:	4405                	li	s0,1
80001dde:	00e05363          	blez	a4,80001de4 <_printk_dec_ulong+0x2c>
80001de2:	843a                	mv	s0,a4
80001de4:	4785                	li	a5,1
80001de6:	02000c93          	li	s9,32
80001dea:	00fb1463          	bne	s6,a5,80001df2 <_printk_dec_ulong+0x3a>
80001dee:	03000c93          	li	s9,48
80001df2:	3b9ad4b7          	lui	s1,0x3b9ad
80001df6:	4905                	li	s2,1
80001df8:	4aa9                	li	s5,10
80001dfa:	4c01                	li	s8,0
80001dfc:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001e00:	4d89                	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001e02:	00148b93          	addi	s7,s1,1
80001e06:	000c1463          	bnez	s8,80001e0e <_printk_dec_ulong+0x56>
80001e0a:	07a4f263          	bgeu	s1,s10,80001e6e <_printk_dec_ulong+0xb6>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001e0e:	85de                	mv	a1,s7
80001e10:	856a                	mv	a0,s10
80001e12:	ad7fe0ef          	jal	ra,800008e8 <__udivsi3>
80001e16:	85d2                	mv	a1,s4
80001e18:	03050513          	addi	a0,a0,48
80001e1c:	9982                	jalr	s3
			digits++;
80001e1e:	0905                	addi	s2,s2,1
			found_largest_digit = 1;
80001e20:	4c05                	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80001e22:	85de                	mv	a1,s7
80001e24:	856a                	mv	a0,s10
80001e26:	b0bfe0ef          	jal	ra,80000930 <__umodsi3>
80001e2a:	8d2a                	mv	s10,a0
		pos /= 10;
80001e2c:	45a9                	li	a1,10
80001e2e:	8526                	mv	a0,s1
80001e30:	ab9fe0ef          	jal	ra,800008e8 <__udivsi3>
		remaining--;
80001e34:	1afd                	addi	s5,s5,-1
	while (pos >= 9) {
80001e36:	4785                	li	a5,1
		pos /= 10;
80001e38:	84aa                	mv	s1,a0
	while (pos >= 9) {
80001e3a:	fcfa94e3          	bne	s5,a5,80001e02 <_printk_dec_ulong+0x4a>
	}
	out((int)(remainder + 48), ctx);
80001e3e:	85d2                	mv	a1,s4
80001e40:	030d0513          	addi	a0,s10,48
80001e44:	9982                	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001e46:	478d                	li	a5,3
		remaining = min_width - digits;
80001e48:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001e4c:	02fb0f63          	beq	s6,a5,80001e8a <_printk_dec_ulong+0xd2>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001e50:	50f2                	lw	ra,60(sp)
80001e52:	5462                	lw	s0,56(sp)
80001e54:	54d2                	lw	s1,52(sp)
80001e56:	5942                	lw	s2,48(sp)
80001e58:	59b2                	lw	s3,44(sp)
80001e5a:	5a22                	lw	s4,40(sp)
80001e5c:	5a92                	lw	s5,36(sp)
80001e5e:	5b02                	lw	s6,32(sp)
80001e60:	4bf2                	lw	s7,28(sp)
80001e62:	4c62                	lw	s8,24(sp)
80001e64:	4cd2                	lw	s9,20(sp)
80001e66:	4d42                	lw	s10,16(sp)
80001e68:	4db2                	lw	s11,12(sp)
80001e6a:	6121                	addi	sp,sp,64
80001e6c:	8082                	ret
		} else if (remaining <= min_width
80001e6e:	fb544ae3          	blt	s0,s5,80001e22 <_printk_dec_ulong+0x6a>
				&& padding < PAD_SPACE_AFTER) {
80001e72:	fb6de8e3          	bltu	s11,s6,80001e22 <_printk_dec_ulong+0x6a>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001e76:	85d2                	mv	a1,s4
80001e78:	8566                	mv	a0,s9
80001e7a:	9982                	jalr	s3
			digits++;
80001e7c:	0905                	addi	s2,s2,1
80001e7e:	b755                	j	80001e22 <_printk_dec_ulong+0x6a>
			out(' ', ctx);
80001e80:	85d2                	mv	a1,s4
80001e82:	02000513          	li	a0,32
80001e86:	9982                	jalr	s3
80001e88:	147d                	addi	s0,s0,-1
		while (remaining-- > 0) {
80001e8a:	fe804be3          	bgtz	s0,80001e80 <_printk_dec_ulong+0xc8>
80001e8e:	b7c9                	j	80001e50 <_printk_dec_ulong+0x98>

80001e90 <__printk_hook_install>:
	_char_out = fn;
80001e90:	800077b7          	lui	a5,0x80007
80001e94:	e2a7a823          	sw	a0,-464(a5) # 80006e30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e31>
}
80001e98:	8082                	ret

80001e9a <z_vprintk>:
{
80001e9a:	715d                	addi	sp,sp,-80
80001e9c:	c4a2                	sw	s0,72(sp)
80001e9e:	c2a6                	sw	s1,68(sp)
80001ea0:	c0ca                	sw	s2,64(sp)
80001ea2:	de4e                	sw	s3,60(sp)
80001ea4:	dc52                	sw	s4,56(sp)
80001ea6:	da56                	sw	s5,52(sp)
80001ea8:	d266                	sw	s9,36(sp)
80001eaa:	d06a                	sw	s10,32(sp)
80001eac:	ce6e                	sw	s11,28(sp)
80001eae:	c686                	sw	ra,76(sp)
80001eb0:	d85a                	sw	s6,48(sp)
80001eb2:	d65e                	sw	s7,44(sp)
80001eb4:	d462                	sw	s8,40(sp)
80001eb6:	842a                	mv	s0,a0
80001eb8:	84ae                	mv	s1,a1
80001eba:	8ab2                	mv	s5,a2
80001ebc:	8d36                	mv	s10,a3
	int long_ctr = 0;
80001ebe:	4a01                	li	s4,0
	int min_width = -1;
80001ec0:	597d                	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001ec2:	4981                	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001ec4:	4c81                	li	s9,0
					if (lld > INT32_MAX ||
80001ec6:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001eca:	000ac503          	lbu	a0,0(s5)
80001ece:	e105                	bnez	a0,80001eee <z_vprintk+0x54>
}
80001ed0:	40b6                	lw	ra,76(sp)
80001ed2:	4426                	lw	s0,72(sp)
80001ed4:	4496                	lw	s1,68(sp)
80001ed6:	4906                	lw	s2,64(sp)
80001ed8:	59f2                	lw	s3,60(sp)
80001eda:	5a62                	lw	s4,56(sp)
80001edc:	5ad2                	lw	s5,52(sp)
80001ede:	5b42                	lw	s6,48(sp)
80001ee0:	5bb2                	lw	s7,44(sp)
80001ee2:	5c22                	lw	s8,40(sp)
80001ee4:	5c92                	lw	s9,36(sp)
80001ee6:	5d02                	lw	s10,32(sp)
80001ee8:	4df2                	lw	s11,28(sp)
80001eea:	6161                	addi	sp,sp,80
80001eec:	8082                	ret
		if (!might_format) {
80001eee:	000c9a63          	bnez	s9,80001f02 <z_vprintk+0x68>
			if (*fmt != '%') {
80001ef2:	02500693          	li	a3,37
80001ef6:	28d50563          	beq	a0,a3,80002180 <z_vprintk+0x2e6>
				out((int)*fmt, ctx);
80001efa:	85a6                	mv	a1,s1
80001efc:	9402                	jalr	s0
		++fmt;
80001efe:	0a85                	addi	s5,s5,1
80001f00:	b7e9                	j	80001eca <z_vprintk+0x30>
			switch (*fmt) {
80001f02:	06400693          	li	a3,100
80001f06:	0ed50b63          	beq	a0,a3,80001ffc <z_vprintk+0x162>
80001f0a:	04a6eb63          	bltu	a3,a0,80001f60 <z_vprintk+0xc6>
80001f0e:	03900693          	li	a3,57
80001f12:	02a6e763          	bltu	a3,a0,80001f40 <z_vprintk+0xa6>
80001f16:	03100693          	li	a3,49
80001f1a:	0cd57563          	bgeu	a0,a3,80001fe4 <z_vprintk+0x14a>
80001f1e:	02d00693          	li	a3,45
80001f22:	26d50463          	beq	a0,a3,8000218a <z_vprintk+0x2f0>
80001f26:	03000793          	li	a5,48
80001f2a:	0af50363          	beq	a0,a5,80001fd0 <z_vprintk+0x136>
80001f2e:	02500713          	li	a4,37
80001f32:	00e51f63          	bne	a0,a4,80001f50 <z_vprintk+0xb6>
				out((int)'%', ctx);
80001f36:	85a6                	mv	a1,s1
80001f38:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001f3c:	9402                	jalr	s0
				break;
80001f3e:	aa09                	j	80002050 <z_vprintk+0x1b6>
80001f40:	05800693          	li	a3,88
80001f44:	14d50b63          	beq	a0,a3,8000209a <z_vprintk+0x200>
80001f48:	06300713          	li	a4,99
80001f4c:	22e50363          	beq	a0,a4,80002172 <z_vprintk+0x2d8>
				out((int)'%', ctx);
80001f50:	85a6                	mv	a1,s1
80001f52:	02500513          	li	a0,37
80001f56:	9402                	jalr	s0
				out((int)*fmt, ctx);
80001f58:	85a6                	mv	a1,s1
80001f5a:	000ac503          	lbu	a0,0(s5)
80001f5e:	bff9                	j	80001f3c <z_vprintk+0xa2>
80001f60:	07000693          	li	a3,112
80001f64:	12d50163          	beq	a0,a3,80002086 <z_vprintk+0x1ec>
80001f68:	00a6ef63          	bltu	a3,a0,80001f86 <z_vprintk+0xec>
80001f6c:	06900693          	li	a3,105
80001f70:	08d50663          	beq	a0,a3,80001ffc <z_vprintk+0x162>
80001f74:	06c00693          	li	a3,108
80001f78:	08d50063          	beq	a0,a3,80001ff8 <z_vprintk+0x15e>
80001f7c:	06800693          	li	a3,104
80001f80:	f6d50fe3          	beq	a0,a3,80001efe <z_vprintk+0x64>
80001f84:	b7f1                	j	80001f50 <z_vprintk+0xb6>
80001f86:	07500693          	li	a3,117
80001f8a:	0cd50563          	beq	a0,a3,80002054 <z_vprintk+0x1ba>
80001f8e:	02a6ea63          	bltu	a3,a0,80001fc2 <z_vprintk+0x128>
80001f92:	07300713          	li	a4,115
80001f96:	fae51de3          	bne	a0,a4,80001f50 <z_vprintk+0xb6>
				char *s = va_arg(ap, char *);
80001f9a:	000d2c03          	lw	s8,0(s10)
80001f9e:	004d0b13          	addi	s6,s10,4
80001fa2:	8be2                	mv	s7,s8
				while (*s)
80001fa4:	000bc503          	lbu	a0,0(s7)
80001fa8:	1a051b63          	bnez	a0,8000215e <z_vprintk+0x2c4>
				if (padding == PAD_SPACE_AFTER) {
80001fac:	478d                	li	a5,3
80001fae:	00f99863          	bne	s3,a5,80001fbe <z_vprintk+0x124>
					int remaining = min_width - (s - start);
80001fb2:	418b8bb3          	sub	s7,s7,s8
80001fb6:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001fba:	1b704663          	bgtz	s7,80002166 <z_vprintk+0x2cc>
				char *s = va_arg(ap, char *);
80001fbe:	8d5a                	mv	s10,s6
80001fc0:	a841                	j	80002050 <z_vprintk+0x1b6>
80001fc2:	07800693          	li	a3,120
80001fc6:	0cd50a63          	beq	a0,a3,8000209a <z_vprintk+0x200>
80001fca:	07a00693          	li	a3,122
80001fce:	bf4d                	j	80001f80 <z_vprintk+0xe6>
				if (min_width < 0 && padding == PAD_NONE) {
80001fd0:	00095c63          	bgez	s2,80001fe8 <z_vprintk+0x14e>
80001fd4:	1a098d63          	beqz	s3,8000218e <z_vprintk+0x2f4>
					min_width = *fmt - '0';
80001fd8:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001fdc:	f20991e3          	bnez	s3,80001efe <z_vprintk+0x64>
					padding = PAD_SPACE_BEFORE;
80001fe0:	4989                	li	s3,2
80001fe2:	bf31                	j	80001efe <z_vprintk+0x64>
				if (min_width < 0) {
80001fe4:	fe094ae3          	bltz	s2,80001fd8 <z_vprintk+0x13e>
					min_width = 10 * min_width + *fmt - '0';
80001fe8:	00291693          	slli	a3,s2,0x2
80001fec:	9936                	add	s2,s2,a3
80001fee:	0906                	slli	s2,s2,0x1
80001ff0:	fd090913          	addi	s2,s2,-48
80001ff4:	992a                	add	s2,s2,a0
80001ff6:	b7dd                	j	80001fdc <z_vprintk+0x142>
				long_ctr++;
80001ff8:	0a05                	addi	s4,s4,1
80001ffa:	b711                	j	80001efe <z_vprintk+0x64>
				if (long_ctr == 0) {
80001ffc:	020a1663          	bnez	s4,80002028 <z_vprintk+0x18e>
					long ld = va_arg(ap, long);
80002000:	000d2603          	lw	a2,0(s10)
80002004:	0d11                	addi	s10,s10,4
				if (d < 0) {
80002006:	00065b63          	bgez	a2,8000201c <z_vprintk+0x182>
					out((int)'-', ctx);
8000200a:	85a6                	mv	a1,s1
8000200c:	02d00513          	li	a0,45
80002010:	c032                	sw	a2,0(sp)
80002012:	9402                	jalr	s0
					d = -d;
80002014:	4602                	lw	a2,0(sp)
					min_width--;
80002016:	197d                	addi	s2,s2,-1
					d = -d;
80002018:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
8000201c:	874a                	mv	a4,s2
8000201e:	86ce                	mv	a3,s3
80002020:	85a6                	mv	a1,s1
80002022:	8522                	mv	a0,s0
80002024:	3b51                	jal	80001db8 <_printk_dec_ulong>
				break;
80002026:	a02d                	j	80002050 <z_vprintk+0x1b6>
				} else if (long_ctr == 1) {
80002028:	4705                	li	a4,1
8000202a:	fcea0be3          	beq	s4,a4,80002000 <z_vprintk+0x166>
					long long lld = va_arg(ap, long long);
8000202e:	007d0793          	addi	a5,s10,7
80002032:	ff87f713          	andi	a4,a5,-8
80002036:	4310                	lw	a2,0(a4)
80002038:	4354                	lw	a3,4(a4)
8000203a:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
8000203e:	01b60733          	add	a4,a2,s11
80002042:	00c73733          	sltu	a4,a4,a2
80002046:	9736                	add	a4,a4,a3
80002048:	df5d                	beqz	a4,80002006 <z_vprintk+0x16c>
						print_err(out, ctx);
8000204a:	85a6                	mv	a1,s1
8000204c:	8522                	mv	a0,s0
8000204e:	333d                	jal	80001d7c <print_err>
			might_format = 0;
80002050:	4c81                	li	s9,0
80002052:	b575                	j	80001efe <z_vprintk+0x64>
				if (long_ctr == 0) {
80002054:	000a1663          	bnez	s4,80002060 <z_vprintk+0x1c6>
					long lu = va_arg(ap, unsigned long);
80002058:	000d2603          	lw	a2,0(s10)
8000205c:	0d11                	addi	s10,s10,4
8000205e:	bf7d                	j	8000201c <z_vprintk+0x182>
				} else if (long_ctr == 1) {
80002060:	4705                	li	a4,1
80002062:	feea0be3          	beq	s4,a4,80002058 <z_vprintk+0x1be>
					unsigned long long llu =
80002066:	007d0793          	addi	a5,s10,7
8000206a:	ff87f713          	andi	a4,a5,-8
8000206e:	00870d13          	addi	s10,a4,8
80002072:	4310                	lw	a2,0(a4)
80002074:	4358                	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80002076:	fb71                	bnez	a4,8000204a <z_vprintk+0x1b0>
80002078:	800007b7          	lui	a5,0x80000
8000207c:	fff7c793          	not	a5,a5
80002080:	f8c7fee3          	bgeu	a5,a2,8000201c <z_vprintk+0x182>
80002084:	b7d9                	j	8000204a <z_vprintk+0x1b0>
				  out('0', ctx);
80002086:	85a6                	mv	a1,s1
80002088:	03000513          	li	a0,48
8000208c:	9402                	jalr	s0
				  out('x', ctx);
8000208e:	85a6                	mv	a1,s1
80002090:	07800513          	li	a0,120
80002094:	9402                	jalr	s0
				  min_width = 8;
80002096:	4921                	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80002098:	4985                	li	s3,1
				if (long_ctr < 2) {
8000209a:	4685                	li	a3,1
8000209c:	0746c663          	blt	a3,s4,80002108 <z_vprintk+0x26e>
					x = va_arg(ap, unsigned long);
800020a0:	000d2783          	lw	a5,0(s10)
800020a4:	c402                	sw	zero,8(sp)
800020a6:	0d11                	addi	s10,s10,4
800020a8:	c23e                	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
800020aa:	4c41                	li	s8,16
	int digits = 0;
800020ac:	4b81                	li	s7,0
	int found_largest_digit = 0;
800020ae:	c002                	sw	zero,0(sp)
	int size = sizeof(num) * 2;
800020b0:	48c1                	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800020b2:	4512                	lw	a0,4(sp)
800020b4:	45a2                	lw	a1,8(sp)
800020b6:	fff88b13          	addi	s6,a7,-1
800020ba:	002b1613          	slli	a2,s6,0x2
800020be:	c646                	sw	a7,12(sp)
800020c0:	960fe0ef          	jal	ra,80000220 <__lshrdi3>
800020c4:	893d                	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800020c6:	ed39                	bnez	a0,80002124 <z_vprintk+0x28a>
800020c8:	4782                	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
800020ca:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800020ce:	e789                	bnez	a5,800020d8 <z_vprintk+0x23e>
800020d0:	48b2                	lw	a7,12(sp)
800020d2:	4785                	li	a5,1
800020d4:	06f89063          	bne	a7,a5,80002134 <z_vprintk+0x29a>
			nibble += nibble > 9 ? 87 : 48;
800020d8:	9536                	add	a0,a0,a3
			out((int)nibble, ctx);
800020da:	0562                	slli	a0,a0,0x18
800020dc:	85a6                	mv	a1,s1
800020de:	8561                	srai	a0,a0,0x18
800020e0:	9402                	jalr	s0
			digits++;
800020e2:	0b85                	addi	s7,s7,1
	for (; size != 0; size--) {
800020e4:	020b1d63          	bnez	s6,8000211e <z_vprintk+0x284>
	if (padding == PAD_SPACE_AFTER) {
800020e8:	468d                	li	a3,3
			might_format = 0;
800020ea:	4c81                	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800020ec:	e0d999e3          	bne	s3,a3,80001efe <z_vprintk+0x64>
		remaining = min_width * 2 - digits;
800020f0:	00191713          	slli	a4,s2,0x1
800020f4:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
800020f8:	f5705ce3          	blez	s7,80002050 <z_vprintk+0x1b6>
			out(' ', ctx);
800020fc:	85a6                	mv	a1,s1
800020fe:	02000513          	li	a0,32
80002102:	9402                	jalr	s0
80002104:	1bfd                	addi	s7,s7,-1
80002106:	bfcd                	j	800020f8 <z_vprintk+0x25e>
					x = va_arg(ap, unsigned long long);
80002108:	007d0793          	addi	a5,s10,7
8000210c:	ff87f693          	andi	a3,a5,-8
80002110:	429c                	lw	a5,0(a3)
80002112:	00868d13          	addi	s10,a3,8
80002116:	c23e                	sw	a5,4(sp)
80002118:	42dc                	lw	a5,4(a3)
8000211a:	c43e                	sw	a5,8(sp)
8000211c:	b779                	j	800020aa <z_vprintk+0x210>
			found_largest_digit = 1;
8000211e:	c066                	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80002120:	88da                	mv	a7,s6
80002122:	bf41                	j	800020b2 <z_vprintk+0x218>
			nibble += nibble > 9 ? 87 : 48;
80002124:	47a5                	li	a5,9
80002126:	05700693          	li	a3,87
8000212a:	faa7e7e3          	bltu	a5,a0,800020d8 <z_vprintk+0x23e>
8000212e:	03000693          	li	a3,48
80002132:	b75d                	j	800020d8 <z_vprintk+0x23e>
		if (remaining-- <= min_width) {
80002134:	fffc0793          	addi	a5,s8,-1
80002138:	c63e                	sw	a5,12(sp)
8000213a:	01894963          	blt	s2,s8,8000214c <z_vprintk+0x2b2>
			if (padding == PAD_ZERO_BEFORE) {
8000213e:	4785                	li	a5,1
80002140:	00f99863          	bne	s3,a5,80002150 <z_vprintk+0x2b6>
				out('0', ctx);
80002144:	85a6                	mv	a1,s1
80002146:	03000513          	li	a0,48
				out(' ', ctx);
8000214a:	9402                	jalr	s0
					x = va_arg(ap, unsigned long);
8000214c:	4c32                	lw	s8,12(sp)
8000214e:	bfc9                	j	80002120 <z_vprintk+0x286>
			} else if (padding == PAD_SPACE_BEFORE) {
80002150:	4789                	li	a5,2
80002152:	fef99de3          	bne	s3,a5,8000214c <z_vprintk+0x2b2>
				out(' ', ctx);
80002156:	85a6                	mv	a1,s1
80002158:	02000513          	li	a0,32
8000215c:	b7fd                	j	8000214a <z_vprintk+0x2b0>
					out((int)(*s++), ctx);
8000215e:	85a6                	mv	a1,s1
80002160:	0b85                	addi	s7,s7,1
80002162:	9402                	jalr	s0
80002164:	b581                	j	80001fa4 <z_vprintk+0x10a>
						out(' ', ctx);
80002166:	85a6                	mv	a1,s1
80002168:	02000513          	li	a0,32
8000216c:	9402                	jalr	s0
8000216e:	1bfd                	addi	s7,s7,-1
80002170:	b5a9                	j	80001fba <z_vprintk+0x120>
				out(c, ctx);
80002172:	000d2503          	lw	a0,0(s10)
80002176:	85a6                	mv	a1,s1
				int c = va_arg(ap, int);
80002178:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
8000217c:	9402                	jalr	s0
				break;
8000217e:	b581                	j	80001fbe <z_vprintk+0x124>
				long_ctr = 0;
80002180:	4a01                	li	s4,0
				min_width = -1;
80002182:	597d                	li	s2,-1
				padding = PAD_NONE;
80002184:	4981                	li	s3,0
				might_format = 1;
80002186:	4c85                	li	s9,1
80002188:	bb9d                	j	80001efe <z_vprintk+0x64>
				padding = PAD_SPACE_AFTER;
8000218a:	498d                	li	s3,3
8000218c:	bb8d                	j	80001efe <z_vprintk+0x64>
					padding = PAD_ZERO_BEFORE;
8000218e:	4985                	li	s3,1
80002190:	b3bd                	j	80001efe <z_vprintk+0x64>

80002192 <vprintk>:
{
80002192:	1101                	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80002194:	862a                	mv	a2,a0
80002196:	80002537          	lui	a0,0x80002
8000219a:	86ae                	mv	a3,a1
8000219c:	da850513          	addi	a0,a0,-600 # 80001da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001da9>
800021a0:	006c                	addi	a1,sp,12
{
800021a2:	ce06                	sw	ra,28(sp)
	struct out_context ctx = { 0 };
800021a4:	c602                	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
800021a6:	39d5                	jal	80001e9a <z_vprintk>
}
800021a8:	40f2                	lw	ra,28(sp)
800021aa:	6105                	addi	sp,sp,32
800021ac:	8082                	ret

800021ae <printk>:
{
800021ae:	7139                	addi	sp,sp,-64
800021b0:	d22e                	sw	a1,36(sp)
	va_start(ap, fmt);
800021b2:	104c                	addi	a1,sp,36
{
800021b4:	ce06                	sw	ra,28(sp)
800021b6:	d432                	sw	a2,40(sp)
800021b8:	d636                	sw	a3,44(sp)
800021ba:	d83a                	sw	a4,48(sp)
800021bc:	da3e                	sw	a5,52(sp)
800021be:	dc42                	sw	a6,56(sp)
800021c0:	de46                	sw	a7,60(sp)
	va_start(ap, fmt);
800021c2:	c62e                	sw	a1,12(sp)
		vprintk(fmt, ap);
800021c4:	37f9                	jal	80002192 <vprintk>
}
800021c6:	40f2                	lw	ra,28(sp)
800021c8:	6121                	addi	sp,sp,64
800021ca:	8082                	ret

800021cc <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
800021cc:	800065b7          	lui	a1,0x80006
800021d0:	80006537          	lui	a0,0x80006
{
800021d4:	1141                	addi	sp,sp,-16
  k_panic();
800021d6:	76058593          	addi	a1,a1,1888 # 80006760 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006761>
800021da:	77450513          	addi	a0,a0,1908 # 80006774 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006775>
800021de:	4679                	li	a2,30
{
800021e0:	c606                	sw	ra,12(sp)
  k_panic();
800021e2:	37f1                	jal	800021ae <printk>
800021e4:	800065b7          	lui	a1,0x80006
800021e8:	34058593          	addi	a1,a1,832 # 80006340 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006341>
800021ec:	4519                	li	a0,6
800021ee:	bd2ff0ef          	jal	ra,800015c0 <z_NanoFatalErrorHandler>

800021f2 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800021f2:	8082                	ret

800021f4 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
800021f4:	47a1                	li	a5,8
800021f6:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
800021fa:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
800021fe:	8082                	ret

80002200 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80002200:	4785                	li	a5,1
80002202:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80002206:	30452573          	csrrs	a0,mie,a0
}
8000220a:	8082                	ret

8000220c <z_arch_irq_disable>:
	 * Use atomic instruction csrrc to disable device interrupt in mie CSR.
	 * (atomic read and clear bits in CSR register)
	 */
	__asm__ volatile ("csrrc %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
8000220c:	4785                	li	a5,1
8000220e:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrc %0, mie, %1\n"
80002212:	30453573          	csrrc	a0,mie,a0
};
80002216:	8082                	ret

80002218 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002218:	47a1                	li	a5,8
8000221a:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
8000221e:	30405073          	csrwi	mie,0
80002222:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80002226:	8082                	ret

80002228 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80002228:	1141                	addi	sp,sp,-16
8000222a:	c422                	sw	s0,8(sp)
8000222c:	c226                	sw	s1,4(sp)
8000222e:	80007437          	lui	s0,0x80007
80002232:	c606                	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80002234:	47a9                	li	a5,10
{
80002236:	84aa                	mv	s1,a0
80002238:	eac40413          	addi	s0,s0,-340 # 80006eac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ead>
	if ('\n' == c) {
8000223c:	00f51763          	bne	a0,a5,8000224a <console_out+0x22>
80002240:	4008                	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80002242:	45b5                	li	a1,13
80002244:	415c                	lw	a5,4(a0)
80002246:	43dc                	lw	a5,4(a5)
80002248:	9782                	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
8000224a:	4008                	lw	a0,0(s0)
8000224c:	0ff4f593          	andi	a1,s1,255
80002250:	415c                	lw	a5,4(a0)
80002252:	43dc                	lw	a5,4(a5)
80002254:	9782                	jalr	a5

	return c;
}
80002256:	40b2                	lw	ra,12(sp)
80002258:	4422                	lw	s0,8(sp)
8000225a:	8526                	mv	a0,s1
8000225c:	4492                	lw	s1,4(sp)
8000225e:	0141                	addi	sp,sp,16
80002260:	8082                	ret

80002262 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80002262:	1141                	addi	sp,sp,-16
80002264:	c422                	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80002266:	80002437          	lui	s0,0x80002
8000226a:	22840513          	addi	a0,s0,552 # 80002228 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002229>
{
8000226e:	c606                	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80002270:	29bd                	jal	800026ee <__stdout_hook_install>
	__printk_hook_install(console_out);
80002272:	22840513          	addi	a0,s0,552
}
80002276:	4422                	lw	s0,8(sp)
80002278:	40b2                	lw	ra,12(sp)
8000227a:	0141                	addi	sp,sp,16
	__printk_hook_install(console_out);
8000227c:	b911                	j	80001e90 <__printk_hook_install>

8000227e <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
8000227e:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80002282:	1141                	addi	sp,sp,-16
80002284:	78050513          	addi	a0,a0,1920 # 80006780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006781>
80002288:	c606                	sw	ra,12(sp)
8000228a:	724000ef          	jal	ra,800029ae <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
8000228e:	800077b7          	lui	a5,0x80007
80002292:	eaa7a623          	sw	a0,-340(a5) # 80006eac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ead>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80002296:	37f1                	jal	80002262 <uart_console_hook_install>

	return 0;
}
80002298:	40b2                	lw	ra,12(sp)
8000229a:	4501                	li	a0,0
8000229c:	0141                	addi	sp,sp,16
8000229e:	8082                	ret

800022a0 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
800022a0:	f01007b7          	lui	a5,0xf0100
800022a4:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
800022a8:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
800022ac:	f447a583          	lw	a1,-188(a5)
800022b0:	fee59ae3          	bne	a1,a4,800022a4 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
800022b4:	8082                	ret

800022b6 <timer_isr>:

static void timer_isr(void *arg)
{
800022b6:	1101                	addi	sp,sp,-32
800022b8:	cc22                	sw	s0,24(sp)
800022ba:	ce06                	sw	ra,28(sp)
800022bc:	ca26                	sw	s1,20(sp)
800022be:	c84a                	sw	s2,16(sp)
800022c0:	c64e                	sw	s3,12(sp)
800022c2:	c452                	sw	s4,8(sp)
800022c4:	c256                	sw	s5,4(sp)
800022c6:	4421                	li	s0,8
800022c8:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800022cc:	80007937          	lui	s2,0x80007
800022d0:	eb090513          	addi	a0,s2,-336 # 80006eb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb1>
	key = (mstatus & SOC_MSTATUS_IEN);
800022d4:	8821                	andi	s0,s0,8
800022d6:	4ee020ef          	jal	ra,800047c4 <z_spin_lock_valid>
800022da:	e915                	bnez	a0,8000230e <timer_isr+0x58>
800022dc:	800064b7          	lui	s1,0x80006
800022e0:	800065b7          	lui	a1,0x80006
800022e4:	80006537          	lui	a0,0x80006
800022e8:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
800022ec:	04e00693          	li	a3,78
800022f0:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800022f4:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800022f8:	3d5d                	jal	800021ae <printk>
800022fa:	80006537          	lui	a0,0x80006
800022fe:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80002302:	3575                	jal	800021ae <printk>
80002304:	04e00593          	li	a1,78
80002308:	79448513          	addi	a0,s1,1940
8000230c:	35c1                	jal	800021cc <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
8000230e:	eb090513          	addi	a0,s2,-336
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002312:	800074b7          	lui	s1,0x80007
80002316:	4ea020ef          	jal	ra,80004800 <z_spin_lock_set_owner>
8000231a:	e9048493          	addi	s1,s1,-368 # 80006e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e91>
	u64_t now = mtime();
8000231e:	3749                	jal	800022a0 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002320:	0004a983          	lw	s3,0(s1)
80002324:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80002328:	87aa                	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
8000232a:	41350533          	sub	a0,a0,s3
8000232e:	00a7b7b3          	sltu	a5,a5,a0
80002332:	415585b3          	sub	a1,a1,s5
80002336:	6675                	lui	a2,0x1d
80002338:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000233c:	4681                	li	a3,0
8000233e:	8d9d                	sub	a1,a1,a5
80002340:	f19fd0ef          	jal	ra,80000258 <__udivdi3>
80002344:	8a2a                	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80002346:	65f5                	lui	a1,0x1d
80002348:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000234c:	8552                	mv	a0,s4
8000234e:	cdefe0ef          	jal	ra,8000082c <__mulsi3>
80002352:	99aa                	add	s3,s3,a0
80002354:	00a9b533          	sltu	a0,s3,a0
80002358:	9556                	add	a0,a0,s5
8000235a:	c0c8                	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000235c:	eb090513          	addi	a0,s2,-336
80002360:	0134a023          	sw	s3,0(s1)
80002364:	47a020ef          	jal	ra,800047de <z_spin_unlock_valid>
80002368:	e915                	bnez	a0,8000239c <timer_isr+0xe6>
8000236a:	800064b7          	lui	s1,0x80006
8000236e:	800065b7          	lui	a1,0x80006
80002372:	80006537          	lui	a0,0x80006
80002376:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000237a:	06100693          	li	a3,97
8000237e:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80002382:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002386:	3525                	jal	800021ae <printk>
80002388:	80006537          	lui	a0,0x80006
8000238c:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80002390:	3d39                	jal	800021ae <printk>
80002392:	06100593          	li	a1,97
80002396:	79448513          	addi	a0,s1,1940
8000239a:	3d0d                	jal	800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000239c:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
800023a0:	4462                	lw	s0,24(sp)
800023a2:	40f2                	lw	ra,28(sp)
800023a4:	44d2                	lw	s1,20(sp)
800023a6:	4942                	lw	s2,16(sp)
800023a8:	49b2                	lw	s3,12(sp)
800023aa:	4a92                	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800023ac:	8552                	mv	a0,s4
}
800023ae:	4a22                	lw	s4,8(sp)
800023b0:	6105                	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800023b2:	4070206f          	j	80004fb8 <z_clock_announce>

800023b6 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
800023b6:	1141                	addi	sp,sp,-16
800023b8:	c606                	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
800023ba:	35dd                	jal	800022a0 <mtime>
800023bc:	67f5                	lui	a5,0x1d
800023be:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
800023c2:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
800023c6:	97aa                	add	a5,a5,a0
	r[1] = 0xffffffff;
800023c8:	56fd                	li	a3,-1
800023ca:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
800023ce:	00a7b533          	sltu	a0,a5,a0
800023d2:	952e                	add	a0,a0,a1
	r[0] = (u32_t)time;
800023d4:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
800023d8:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
800023dc:	451d                	li	a0,7
800023de:	350d                	jal	80002200 <z_arch_irq_enable>
	return 0;
}
800023e0:	40b2                	lw	ra,12(sp)
800023e2:	4501                	li	a0,0
800023e4:	0141                	addi	sp,sp,16
800023e6:	8082                	ret

800023e8 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
800023e8:	14059563          	bnez	a1,80002532 <z_clock_set_timeout+0x14a>
{
800023ec:	1101                	addi	sp,sp,-32
800023ee:	ce06                	sw	ra,28(sp)
800023f0:	cc22                	sw	s0,24(sp)
800023f2:	ca26                	sw	s1,20(sp)
800023f4:	c84a                	sw	s2,16(sp)
800023f6:	c64e                	sw	s3,12(sp)
800023f8:	c452                	sw	s4,8(sp)
800023fa:	c256                	sw	s5,4(sp)
800023fc:	c05a                	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
800023fe:	57fd                	li	a5,-1
80002400:	00f51563          	bne	a0,a5,8000240a <z_clock_set_timeout+0x22>
80002404:	6525                	lui	a0,0x9
80002406:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
8000240a:	67a5                	lui	a5,0x9
8000240c:	fff50413          	addi	s0,a0,-1
80002410:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80002414:	1087db63          	bge	a5,s0,8000252a <z_clock_set_timeout+0x142>
80002418:	843e                	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000241a:	4921                	li	s2,8
8000241c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002420:	80007ab7          	lui	s5,0x80007
80002424:	eb0a8513          	addi	a0,s5,-336 # 80006eb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002428:	00897913          	andi	s2,s2,8
8000242c:	398020ef          	jal	ra,800047c4 <z_spin_lock_valid>
80002430:	e915                	bnez	a0,80002464 <z_clock_set_timeout+0x7c>
80002432:	800064b7          	lui	s1,0x80006
80002436:	800065b7          	lui	a1,0x80006
8000243a:	80006537          	lui	a0,0x80006
8000243e:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80002442:	04e00693          	li	a3,78
80002446:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
8000244a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000244e:	3385                	jal	800021ae <printk>
80002450:	80006537          	lui	a0,0x80006
80002454:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80002458:	3b99                	jal	800021ae <printk>
8000245a:	04e00593          	li	a1,78
8000245e:	79448513          	addi	a0,s1,1940
80002462:	33ad                	jal	800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80002464:	eb0a8513          	addi	a0,s5,-336
80002468:	398020ef          	jal	ra,80004800 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
8000246c:	3d15                	jal	800022a0 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000246e:	800077b7          	lui	a5,0x80007
80002472:	e9078793          	addi	a5,a5,-368 # 80006e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e91>
	u32_t cyc = ticks * CYC_PER_TICK;
80002476:	64f5                	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002478:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
8000247c:	8a2a                	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
8000247e:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002482:	8522                	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002484:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002488:	ba4fe0ef          	jal	ra,8000082c <__mulsi3>
8000248c:	4bf48793          	addi	a5,s1,1215
80002490:	413787b3          	sub	a5,a5,s3
80002494:	953e                	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002496:	4c048593          	addi	a1,s1,1216
8000249a:	9552                	add	a0,a0,s4
8000249c:	c4cfe0ef          	jal	ra,800008e8 <__udivsi3>
800024a0:	4c048593          	addi	a1,s1,1216
800024a4:	b88fe0ef          	jal	ra,8000082c <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
800024a8:	41498a33          	sub	s4,s3,s4
800024ac:	9a2a                	add	s4,s4,a0
800024ae:	3e700793          	li	a5,999
800024b2:	0147c563          	blt	a5,s4,800024bc <z_clock_set_timeout+0xd4>
		cyc += CYC_PER_TICK;
800024b6:	4c048493          	addi	s1,s1,1216
800024ba:	9526                	add	a0,a0,s1
	r[1] = 0xffffffff;
800024bc:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
800024c0:	99aa                	add	s3,s3,a0
	r[1] = 0xffffffff;
800024c2:	577d                	li	a4,-1
800024c4:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
800024c8:	00a9b533          	sltu	a0,s3,a0
800024cc:	955a                	add	a0,a0,s6
	r[0] = (u32_t)time;
800024ce:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
800024d2:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800024d6:	eb0a8513          	addi	a0,s5,-336
800024da:	304020ef          	jal	ra,800047de <z_spin_unlock_valid>
800024de:	e915                	bnez	a0,80002512 <z_clock_set_timeout+0x12a>
800024e0:	80006437          	lui	s0,0x80006
800024e4:	800065b7          	lui	a1,0x80006
800024e8:	80006537          	lui	a0,0x80006
800024ec:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800024f0:	06100693          	li	a3,97
800024f4:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800024f8:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800024fc:	394d                	jal	800021ae <printk>
800024fe:	80006537          	lui	a0,0x80006
80002502:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80002506:	3165                	jal	800021ae <printk>
80002508:	06100593          	li	a1,97
8000250c:	79440513          	addi	a0,s0,1940
80002510:	3975                	jal	800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002512:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80002516:	40f2                	lw	ra,28(sp)
80002518:	4462                	lw	s0,24(sp)
8000251a:	44d2                	lw	s1,20(sp)
8000251c:	4942                	lw	s2,16(sp)
8000251e:	49b2                	lw	s3,12(sp)
80002520:	4a22                	lw	s4,8(sp)
80002522:	4a92                	lw	s5,4(sp)
80002524:	4b02                	lw	s6,0(sp)
80002526:	6105                	addi	sp,sp,32
80002528:	8082                	ret
8000252a:	ee0458e3          	bgez	s0,8000241a <z_clock_set_timeout+0x32>
8000252e:	4401                	li	s0,0
80002530:	b5ed                	j	8000241a <z_clock_set_timeout+0x32>
80002532:	8082                	ret

80002534 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002534:	1141                	addi	sp,sp,-16
80002536:	c422                	sw	s0,8(sp)
80002538:	c606                	sw	ra,12(sp)
8000253a:	c226                	sw	s1,4(sp)
8000253c:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000253e:	4421                	li	s0,8
80002540:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002544:	800074b7          	lui	s1,0x80007
80002548:	eb048513          	addi	a0,s1,-336 # 80006eb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000254c:	8821                	andi	s0,s0,8
8000254e:	276020ef          	jal	ra,800047c4 <z_spin_lock_valid>
80002552:	e915                	bnez	a0,80002586 <z_clock_elapsed+0x52>
80002554:	80006937          	lui	s2,0x80006
80002558:	800065b7          	lui	a1,0x80006
8000255c:	80006537          	lui	a0,0x80006
80002560:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80002564:	04e00693          	li	a3,78
80002568:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
8000256c:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002570:	393d                	jal	800021ae <printk>
80002572:	80006537          	lui	a0,0x80006
80002576:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
8000257a:	3915                	jal	800021ae <printk>
8000257c:	04e00593          	li	a1,78
80002580:	79490513          	addi	a0,s2,1940
80002584:	31a1                	jal	800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80002586:	eb048513          	addi	a0,s1,-336
8000258a:	276020ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
8000258e:	3b09                	jal	800022a0 <mtime>
80002590:	800077b7          	lui	a5,0x80007
80002594:	e907a783          	lw	a5,-368(a5) # 80006e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e91>
80002598:	65f5                	lui	a1,0x1d
8000259a:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000259e:	8d1d                	sub	a0,a0,a5
800025a0:	b48fe0ef          	jal	ra,800008e8 <__udivsi3>
800025a4:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800025a6:	eb048513          	addi	a0,s1,-336
800025aa:	234020ef          	jal	ra,800047de <z_spin_unlock_valid>
800025ae:	ed0d                	bnez	a0,800025e8 <z_clock_elapsed+0xb4>
800025b0:	800064b7          	lui	s1,0x80006
800025b4:	800065b7          	lui	a1,0x80006
800025b8:	80006537          	lui	a0,0x80006
800025bc:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800025c0:	06100693          	li	a3,97
800025c4:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800025c8:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800025cc:	be3ff0ef          	jal	ra,800021ae <printk>
800025d0:	80006537          	lui	a0,0x80006
800025d4:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800025d8:	bd7ff0ef          	jal	ra,800021ae <printk>
800025dc:	06100593          	li	a1,97
800025e0:	79448513          	addi	a0,s1,1940
800025e4:	be9ff0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800025e8:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
800025ec:	40b2                	lw	ra,12(sp)
800025ee:	4422                	lw	s0,8(sp)
800025f0:	854a                	mv	a0,s2
800025f2:	4492                	lw	s1,4(sp)
800025f4:	4902                	lw	s2,0(sp)
800025f6:	0141                	addi	sp,sp,16
800025f8:	8082                	ret

800025fa <z_timer_cycle_get_32>:

u32_t z_timer_cycle_get_32(void)
{
800025fa:	1141                	addi	sp,sp,-16
800025fc:	c606                	sw	ra,12(sp)
	return (u32_t)mtime();
800025fe:	314d                	jal	800022a0 <mtime>
}
80002600:	40b2                	lw	ra,12(sp)
80002602:	0141                	addi	sp,sp,16
80002604:	8082                	ret

80002606 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002606:	00054783          	lbu	a5,0(a0)
8000260a:	0005c703          	lbu	a4,0(a1)
8000260e:	00e79363          	bne	a5,a4,80002614 <strcmp+0xe>
80002612:	e781                	bnez	a5,8000261a <strcmp+0x14>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002614:	40e78533          	sub	a0,a5,a4
80002618:	8082                	ret
		s1++;
8000261a:	0505                	addi	a0,a0,1
		s2++;
8000261c:	0585                	addi	a1,a1,1
8000261e:	b7e5                	j	80002606 <strcmp>

80002620 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80002620:	00b547b3          	xor	a5,a0,a1
80002624:	8b8d                	andi	a5,a5,3
80002626:	cf95                	beqz	a5,80002662 <memcpy+0x42>
	unsigned char *d_byte = (unsigned char *)d;
80002628:	87aa                	mv	a5,a0
8000262a:	4701                	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
8000262c:	04e61763          	bne	a2,a4,8000267a <memcpy+0x5a>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80002630:	8082                	ret
			if (n == 0) {
80002632:	de7d                	beqz	a2,80002630 <memcpy+0x10>
			*(d_byte++) = *(s_byte++);
80002634:	0585                	addi	a1,a1,1
80002636:	fff5c703          	lbu	a4,-1(a1)
8000263a:	0785                	addi	a5,a5,1
			n--;
8000263c:	167d                	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
8000263e:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80002642:	0037f713          	andi	a4,a5,3
80002646:	f775                	bnez	a4,80002632 <memcpy+0x12>
		while (n >= sizeof(unsigned int)) {
80002648:	468d                	li	a3,3
8000264a:	40e60833          	sub	a6,a2,a4
8000264e:	0106ec63          	bltu	a3,a6,80002666 <memcpy+0x46>
80002652:	00265713          	srli	a4,a2,0x2
80002656:	00271693          	slli	a3,a4,0x2
8000265a:	8e15                	sub	a2,a2,a3
8000265c:	97b6                	add	a5,a5,a3
8000265e:	95b6                	add	a1,a1,a3
80002660:	b7e9                	j	8000262a <memcpy+0xa>
	unsigned char *d_byte = (unsigned char *)d;
80002662:	87aa                	mv	a5,a0
80002664:	bff9                	j	80002642 <memcpy+0x22>
			*(d_word++) = *(s_word++);
80002666:	00e588b3          	add	a7,a1,a4
8000266a:	0008a883          	lw	a7,0(a7)
8000266e:	00e78833          	add	a6,a5,a4
80002672:	0711                	addi	a4,a4,4
80002674:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80002678:	bfc9                	j	8000264a <memcpy+0x2a>
		*(d_byte++) = *(s_byte++);
8000267a:	00e58833          	add	a6,a1,a4
8000267e:	00084803          	lbu	a6,0(a6)
80002682:	00e786b3          	add	a3,a5,a4
80002686:	0705                	addi	a4,a4,1
80002688:	01068023          	sb	a6,0(a3)
		n--;
8000268c:	b745                	j	8000262c <memcpy+0xc>

8000268e <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
8000268e:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002692:	87aa                	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80002694:	0037f713          	andi	a4,a5,3
80002698:	eb1d                	bnez	a4,800026ce <memset+0x40>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
8000269a:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
8000269e:	00859713          	slli	a4,a1,0x8
800026a2:	8dd9                	or	a1,a1,a4
	c_word |= c_word << 16;
800026a4:	01059713          	slli	a4,a1,0x10
800026a8:	8dd9                	or	a1,a1,a4

	while (n >= sizeof(unsigned int)) {
800026aa:	00c78333          	add	t1,a5,a2
800026ae:	873e                	mv	a4,a5
800026b0:	480d                	li	a6,3
800026b2:	40e308b3          	sub	a7,t1,a4
800026b6:	03186263          	bltu	a6,a7,800026da <memset+0x4c>
800026ba:	00265713          	srli	a4,a2,0x2
800026be:	00271593          	slli	a1,a4,0x2
800026c2:	97ae                	add	a5,a5,a1
800026c4:	8e0d                	sub	a2,a2,a1
800026c6:	963e                	add	a2,a2,a5

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
800026c8:	00c79d63          	bne	a5,a2,800026e2 <memset+0x54>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
800026cc:	8082                	ret
		if (n == 0) {
800026ce:	de7d                	beqz	a2,800026cc <memset+0x3e>
		*(d_byte++) = c_byte;
800026d0:	0785                	addi	a5,a5,1
800026d2:	fed78fa3          	sb	a3,-1(a5)
		n--;
800026d6:	167d                	addi	a2,a2,-1
800026d8:	bf75                	j	80002694 <memset+0x6>
		*(d_word++) = c_word;
800026da:	0711                	addi	a4,a4,4
800026dc:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
800026e0:	bfc9                	j	800026b2 <memset+0x24>
		*(d_byte++) = c_byte;
800026e2:	0785                	addi	a5,a5,1
800026e4:	fed78fa3          	sb	a3,-1(a5)
		n--;
800026e8:	b7c5                	j	800026c8 <memset+0x3a>

800026ea <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
800026ea:	557d                	li	a0,-1
800026ec:	8082                	ret

800026ee <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
800026ee:	800077b7          	lui	a5,0x80007
800026f2:	e2a7aa23          	sw	a0,-460(a5) # 80006e34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e35>
}
800026f6:	8082                	ret

800026f8 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
800026f8:	1101                	addi	sp,sp,-32
800026fa:	cc22                	sw	s0,24(sp)
	test->setup();
800026fc:	451c                	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
800026fe:	80007437          	lui	s0,0x80007
{
80002702:	ca26                	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002704:	e3840413          	addi	s0,s0,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002708:	800074b7          	lui	s1,0x80007
{
8000270c:	ce06                	sw	ra,28(sp)
8000270e:	c84a                	sw	s2,16(sp)
80002710:	c64e                	sw	s3,12(sp)
	test_result = 1;
80002712:	eb448493          	addi	s1,s1,-332 # 80006eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb5>
80002716:	4985                	li	s3,1
	phase = TEST_PHASE_SETUP;
80002718:	00042023          	sw	zero,0(s0)
{
8000271c:	892a                	mv	s2,a0
	test_result = 1;
8000271e:	0134a023          	sw	s3,0(s1)
	test->setup();
80002722:	9782                	jalr	a5
	test->test();
80002724:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80002728:	01342023          	sw	s3,0(s0)
	test->test();
8000272c:	9782                	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
8000272e:	4789                	li	a5,2
80002730:	c01c                	sw	a5,0(s0)
	test->teardown();
80002732:	00c92783          	lw	a5,12(s2)
80002736:	9782                	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002738:	478d                	li	a5,3
8000273a:	c01c                	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
8000273c:	4462                	lw	s0,24(sp)
	test_result = 0;
8000273e:	0004a023          	sw	zero,0(s1)
}
80002742:	40f2                	lw	ra,28(sp)
80002744:	44d2                	lw	s1,20(sp)
80002746:	4942                	lw	s2,16(sp)
80002748:	49b2                	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
8000274a:	80007537          	lui	a0,0x80007
8000274e:	3ac50513          	addi	a0,a0,940 # 800073ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073ad>
80002752:	6105                	addi	sp,sp,32
80002754:	5590106f          	j	800044ac <z_impl_k_sem_give>

80002758 <ztest_test_fail>:
80002758:	80007537          	lui	a0,0x80007
{
8000275c:	1141                	addi	sp,sp,-16
	test_result = -1;
8000275e:	800077b7          	lui	a5,0x80007
80002762:	577d                	li	a4,-1
80002764:	3ac50513          	addi	a0,a0,940 # 800073ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073ad>
{
80002768:	c606                	sw	ra,12(sp)
	test_result = -1;
8000276a:	eae7aa23          	sw	a4,-332(a5) # 80006eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb5>
8000276e:	53f010ef          	jal	ra,800044ac <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002772:	491010ef          	jal	ra,80004402 <z_impl_k_current_get>
}
80002776:	40b2                	lw	ra,12(sp)
80002778:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000277a:	2ce0206f          	j	80004a48 <z_impl_k_thread_abort>

8000277e <ztest_test_skip>:
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
8000277e:	80007537          	lui	a0,0x80007
{
80002782:	1141                	addi	sp,sp,-16
	test_result = -2;
80002784:	800077b7          	lui	a5,0x80007
80002788:	5779                	li	a4,-2
8000278a:	3ac50513          	addi	a0,a0,940 # 800073ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073ad>
{
8000278e:	c606                	sw	ra,12(sp)
	test_result = -2;
80002790:	eae7aa23          	sw	a4,-332(a5) # 80006eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb5>
80002794:	519010ef          	jal	ra,800044ac <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002798:	46b010ef          	jal	ra,80004402 <z_impl_k_current_get>
}
8000279c:	40b2                	lw	ra,12(sp)
8000279e:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800027a0:	2a80206f          	j	80004a48 <z_impl_k_thread_abort>

800027a4 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
800027a4:	711d                	addi	sp,sp,-96
800027a6:	caa6                	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
800027a8:	800074b7          	lui	s1,0x80007
800027ac:	eb84a783          	lw	a5,-328(s1) # 80006eb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb9>
{
800027b0:	ce86                	sw	ra,92(sp)
800027b2:	cca2                	sw	s0,88(sp)
800027b4:	c8ca                	sw	s2,80(sp)
800027b6:	c6ce                	sw	s3,76(sp)
800027b8:	c4d2                	sw	s4,72(sp)
800027ba:	c2d6                	sw	s5,68(sp)
800027bc:	c0da                	sw	s6,64(sp)
800027be:	de5e                	sw	s7,60(sp)
800027c0:	dc62                	sw	s8,56(sp)
800027c2:	da66                	sw	s9,52(sp)
800027c4:	d86a                	sw	s10,48(sp)
800027c6:	d66e                	sw	s11,44(sp)
	if (test_status < 0) {
800027c8:	0607c963          	bltz	a5,8000283a <z_ztest_run_test_suite+0x96>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
800027cc:	80007437          	lui	s0,0x80007
800027d0:	4605                	li	a2,1
800027d2:	89aa                	mv	s3,a0
800027d4:	8c2e                	mv	s8,a1
800027d6:	3ac40513          	addi	a0,s0,940 # 800073ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073ad>
800027da:	4581                	li	a1,0
800027dc:	431010ef          	jal	ra,8000440c <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
800027e0:	80007537          	lui	a0,0x80007
800027e4:	85ce                	mv	a1,s3
800027e6:	84850513          	addi	a0,a0,-1976 # 80006848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006849>
800027ea:	9c5ff0ef          	jal	ra,800021ae <printk>
	PRINT_LINE;
800027ee:	80007937          	lui	s2,0x80007
800027f2:	86090513          	addi	a0,s2,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
		Z_TC_END_RESULT(ret, test->name);
800027f6:	80007ab7          	lui	s5,0x80007
	PRINT_LINE;
800027fa:	9b5ff0ef          	jal	ra,800021ae <printk>
800027fe:	eb848493          	addi	s1,s1,-328
	int fail = 0;
80002802:	4a01                	li	s4,0
80002804:	ce22                	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002806:	80008cb7          	lui	s9,0x80008
8000280a:	80007b37          	lui	s6,0x80007
8000280e:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80002812:	80007db7          	lui	s11,0x80007
80002816:	80007bb7          	lui	s7,0x80007
		Z_TC_END_RESULT(ret, test->name);
8000281a:	808a8a93          	addi	s5,s5,-2040 # 80006808 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006809>
	while (suite->test) {
8000281e:	004c2783          	lw	a5,4(s8)
80002822:	eb9d                	bnez	a5,80002858 <z_ztest_run_test_suite+0xb4>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002824:	85ce                	mv	a1,s3
	if (fail) {
80002826:	0c0a0363          	beqz	s4,800028ec <z_ztest_run_test_suite+0x148>
		TC_PRINT("Test suite %s failed.\n", name);
8000282a:	80007537          	lui	a0,0x80007
8000282e:	8d050513          	addi	a0,a0,-1840 # 800068d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d1>
80002832:	97dff0ef          	jal	ra,800021ae <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002836:	4785                	li	a5,1
80002838:	c09c                	sw	a5,0(s1)
}
8000283a:	40f6                	lw	ra,92(sp)
8000283c:	4466                	lw	s0,88(sp)
8000283e:	44d6                	lw	s1,84(sp)
80002840:	4946                	lw	s2,80(sp)
80002842:	49b6                	lw	s3,76(sp)
80002844:	4a26                	lw	s4,72(sp)
80002846:	4a96                	lw	s5,68(sp)
80002848:	4b06                	lw	s6,64(sp)
8000284a:	5bf2                	lw	s7,60(sp)
8000284c:	5c62                	lw	s8,56(sp)
8000284e:	5cd2                	lw	s9,52(sp)
80002850:	5d42                	lw	s10,48(sp)
80002852:	5db2                	lw	s11,44(sp)
80002854:	6125                	addi	sp,sp,96
80002856:	8082                	ret
	TC_START(test->name);
80002858:	000c2583          	lw	a1,0(s8)
8000285c:	800077b7          	lui	a5,0x80007
80002860:	8a878513          	addi	a0,a5,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80002864:	94bff0ef          	jal	ra,800021ae <printk>
80002868:	c202                	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
8000286a:	010c2783          	lw	a5,16(s8)
8000286e:	8762                	mv	a4,s8
80002870:	40000613          	li	a2,1024
80002874:	0087e793          	ori	a5,a5,8
80002878:	58fd                	li	a7,-1
8000287a:	4801                	li	a6,0
8000287c:	6f8d0693          	addi	a3,s10,1784 # 800026f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800026f9>
80002880:	c03e                	sw	a5,0(sp)
80002882:	5c0c8593          	addi	a1,s9,1472 # 800085c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800085c1>
80002886:	4781                	li	a5,0
80002888:	3bcb0513          	addi	a0,s6,956 # 800073bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073bd>
8000288c:	0a4020ef          	jal	ra,80004930 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002890:	47f2                	lw	a5,28(sp)
80002892:	55fd                	li	a1,-1
80002894:	3ac78513          	addi	a0,a5,940
80002898:	4bf010ef          	jal	ra,80004556 <z_impl_k_sem_take>
	if (test_result == -1) {
8000289c:	eb4d8793          	addi	a5,s11,-332 # 80006eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb5>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800028a0:	3bcb0513          	addi	a0,s6,956
800028a4:	4380                	lw	s0,0(a5)
800028a6:	1a2020ef          	jal	ra,80004a48 <z_impl_k_thread_abort>
	if (test_result == -2) {
800028aa:	800077b7          	lui	a5,0x80007
800028ae:	eb478793          	addi	a5,a5,-332 # 80006eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb5>
800028b2:	4398                	lw	a4,0(a5)
	if (test_result == -1) {
800028b4:	0405                	addi	s0,s0,1
	if (test_result == -2) {
800028b6:	57f9                	li	a5,-2
	if (test_result == -1) {
800028b8:	00143413          	seqz	s0,s0
	if (test_result == -2) {
800028bc:	000c2603          	lw	a2,0(s8)
800028c0:	02f71163          	bne	a4,a5,800028e2 <z_ztest_run_test_suite+0x13e>
		Z_TC_END_RESULT(TC_SKIP, test->name);
800028c4:	800075b7          	lui	a1,0x80007
800028c8:	8bc58593          	addi	a1,a1,-1860 # 800068bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068bd>
		Z_TC_END_RESULT(ret, test->name);
800028cc:	8c4b8513          	addi	a0,s7,-1852 # 800068c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c5>
800028d0:	8dfff0ef          	jal	ra,800021ae <printk>
800028d4:	86090513          	addi	a0,s2,-1952
800028d8:	8d7ff0ef          	jal	ra,800021ae <printk>
		fail += run_test(suite);
800028dc:	9a22                	add	s4,s4,s0
		suite++;
800028de:	0c51                	addi	s8,s8,20
		if (fail && FAIL_FAST) {
800028e0:	bf3d                	j	8000281e <z_ztest_run_test_suite+0x7a>
		Z_TC_END_RESULT(ret, test->name);
800028e2:	00241793          	slli	a5,s0,0x2
800028e6:	97d6                	add	a5,a5,s5
800028e8:	438c                	lw	a1,0(a5)
800028ea:	b7cd                	j	800028cc <z_ztest_run_test_suite+0x128>
		TC_PRINT("Test suite %s succeeded\n", name);
800028ec:	80007537          	lui	a0,0x80007
800028f0:	8e850513          	addi	a0,a0,-1816 # 800068e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e9>
800028f4:	8bbff0ef          	jal	ra,800021ae <printk>
	test_status = (test_status || fail) ? 1 : 0;
800028f8:	409c                	lw	a5,0(s1)
800028fa:	00f037b3          	snez	a5,a5
800028fe:	bf2d                	j	80002838 <z_ztest_run_test_suite+0x94>

80002900 <end_report>:

void end_report(void)
{
	if (test_status) {
80002900:	800077b7          	lui	a5,0x80007
80002904:	eb87a783          	lw	a5,-328(a5) # 80006eb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006eb9>
{
80002908:	1141                	addi	sp,sp,-16
8000290a:	c422                	sw	s0,8(sp)
8000290c:	80007537          	lui	a0,0x80007
80002910:	c606                	sw	ra,12(sp)
80002912:	80007437          	lui	s0,0x80007
		TC_END_REPORT(TC_FAIL);
80002916:	86050513          	addi	a0,a0,-1952 # 80006860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006861>
	if (test_status) {
8000291a:	cf91                	beqz	a5,80002936 <end_report+0x36>
		TC_END_REPORT(TC_FAIL);
8000291c:	893ff0ef          	jal	ra,800021ae <printk>
80002920:	800075b7          	lui	a1,0x80007
80002924:	81458593          	addi	a1,a1,-2028 # 80006814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006815>
	} else {
		TC_END_REPORT(TC_PASS);
80002928:	81c40513          	addi	a0,s0,-2020 # 8000681c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000681d>
	}
}
8000292c:	4422                	lw	s0,8(sp)
8000292e:	40b2                	lw	ra,12(sp)
80002930:	0141                	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002932:	87dff06f          	j	800021ae <printk>
80002936:	879ff0ef          	jal	ra,800021ae <printk>
8000293a:	800075b7          	lui	a1,0x80007
8000293e:	83458593          	addi	a1,a1,-1996 # 80006834 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006835>
80002942:	b7dd                	j	80002928 <end_report+0x28>

80002944 <main>:

	return test_status;
}
#else
void main(void)
{
80002944:	1141                	addi	sp,sp,-16
80002946:	c606                	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002948:	bd1fe0ef          	jal	ra,80001518 <test_main>
	end_report();
}
8000294c:	40b2                	lw	ra,12(sp)
8000294e:	0141                	addi	sp,sp,16
	end_report();
80002950:	bf45                	j	80002900 <end_report>

80002952 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80002952:	1141                	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002954:	c602                	sw	zero,12(sp)
    i++;
80002956:	47b2                	lw	a5,12(sp)
80002958:	0785                	addi	a5,a5,1
8000295a:	c63e                	sw	a5,12(sp)
    uart[0] = c;
8000295c:	f00107b7          	lui	a5,0xf0010
80002960:	c38c                	sw	a1,0(a5)
}
80002962:	0141                	addi	sp,sp,16
80002964:	8082                	ret

80002966 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002966:	557d                	li	a0,-1
80002968:	8082                	ret

8000296a <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
8000296a:	4501                	li	a0,0
8000296c:	8082                	ret

8000296e <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
8000296e:	00251713          	slli	a4,a0,0x2
80002972:	800077b7          	lui	a5,0x80007
80002976:	0505                	addi	a0,a0,1
80002978:	91878793          	addi	a5,a5,-1768 # 80006918 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006919>
8000297c:	050a                	slli	a0,a0,0x2
{
8000297e:	1141                	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002980:	973e                	add	a4,a4,a5
80002982:	97aa                	add	a5,a5,a0
{
80002984:	c422                	sw	s0,8(sp)
80002986:	c226                	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002988:	4300                	lw	s0,0(a4)
8000298a:	4384                	lw	s1,0(a5)
{
8000298c:	c606                	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
8000298e:	00946763          	bltu	s0,s1,8000299c <z_sys_device_do_config_level+0x2e>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002992:	40b2                	lw	ra,12(sp)
80002994:	4422                	lw	s0,8(sp)
80002996:	4492                	lw	s1,4(sp)
80002998:	0141                	addi	sp,sp,16
8000299a:	8082                	ret
		retval = device_conf->init(info);
8000299c:	401c                	lw	a5,0(s0)
8000299e:	8522                	mv	a0,s0
800029a0:	43dc                	lw	a5,4(a5)
800029a2:	9782                	jalr	a5
		if (retval != 0) {
800029a4:	c119                	beqz	a0,800029aa <z_sys_device_do_config_level+0x3c>
			info->driver_api = NULL;
800029a6:	00042223          	sw	zero,4(s0)
								info++) {
800029aa:	0431                	addi	s0,s0,12
800029ac:	b7cd                	j	8000298e <z_sys_device_do_config_level+0x20>

800029ae <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800029ae:	1141                	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
800029b0:	800077b7          	lui	a5,0x80007
{
800029b4:	c226                	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800029b6:	800074b7          	lui	s1,0x80007
{
800029ba:	c422                	sw	s0,8(sp)
800029bc:	c606                	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800029be:	e4c78413          	addi	s0,a5,-436 # 80006e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e4d>
{
800029c2:	c04a                	sw	s2,0(sp)
800029c4:	e4c78793          	addi	a5,a5,-436
800029c8:	e7c48493          	addi	s1,s1,-388 # 80006e7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e7d>
	for (info = __device_init_start; info != __device_init_end; info++) {
800029cc:	00941863          	bne	s0,s1,800029dc <z_impl_device_get_binding+0x2e>
800029d0:	892a                	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
800029d2:	843e                	mv	s0,a5
800029d4:	00941c63          	bne	s0,s1,800029ec <z_impl_device_get_binding+0x3e>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
800029d8:	4401                	li	s0,0
800029da:	a01d                	j	80002a00 <z_impl_device_get_binding+0x52>
		if ((info->driver_api != NULL) &&
800029dc:	4058                	lw	a4,4(s0)
800029de:	c709                	beqz	a4,800029e8 <z_impl_device_get_binding+0x3a>
		    (info->config->name == name)) {
800029e0:	4018                	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
800029e2:	4318                	lw	a4,0(a4)
800029e4:	00a70e63          	beq	a4,a0,80002a00 <z_impl_device_get_binding+0x52>
	for (info = __device_init_start; info != __device_init_end; info++) {
800029e8:	0431                	addi	s0,s0,12
800029ea:	b7cd                	j	800029cc <z_impl_device_get_binding+0x1e>
		if (info->driver_api == NULL) {
800029ec:	405c                	lw	a5,4(s0)
800029ee:	e399                	bnez	a5,800029f4 <z_impl_device_get_binding+0x46>
	for (info = __device_init_start; info != __device_init_end; info++) {
800029f0:	0431                	addi	s0,s0,12
800029f2:	b7cd                	j	800029d4 <z_impl_device_get_binding+0x26>
		if (strcmp(name, info->config->name) == 0) {
800029f4:	401c                	lw	a5,0(s0)
800029f6:	854a                	mv	a0,s2
800029f8:	438c                	lw	a1,0(a5)
800029fa:	c0dff0ef          	jal	ra,80002606 <strcmp>
800029fe:	f96d                	bnez	a0,800029f0 <z_impl_device_get_binding+0x42>
}
80002a00:	8522                	mv	a0,s0
80002a02:	40b2                	lw	ra,12(sp)
80002a04:	4422                	lw	s0,8(sp)
80002a06:	4492                	lw	s1,4(sp)
80002a08:	4902                	lw	s2,0(sp)
80002a0a:	0141                	addi	sp,sp,16
80002a0c:	8082                	ret

80002a0e <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002a0e:	1141                	addi	sp,sp,-16
80002a10:	c422                	sw	s0,8(sp)
80002a12:	c226                	sw	s1,4(sp)
80002a14:	c606                	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002a16:	4421                	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002a18:	4489                	li	s1,2
80002a1a:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80002a1e:	40c020ef          	jal	ra,80004e2a <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002a22:	00a4c363          	blt	s1,a0,80002a28 <idle+0x1a>
80002a26:	4505                	li	a0,1
80002a28:	4585                	li	a1,1
80002a2a:	4ba020ef          	jal	ra,80004ee4 <z_set_timeout_expiry>
	k_cpu_idle();
80002a2e:	fc6ff0ef          	jal	ra,800021f4 <k_cpu_idle>
80002a32:	b7e5                	j	80002a1a <idle+0xc>

80002a34 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002a34:	80007537          	lui	a0,0x80007
80002a38:	800077b7          	lui	a5,0x80007
80002a3c:	e9050613          	addi	a2,a0,-368 # 80006e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e91>
80002a40:	53878793          	addi	a5,a5,1336 # 80007538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007539>
80002a44:	40c78633          	sub	a2,a5,a2
80002a48:	4581                	li	a1,0
80002a4a:	e9050513          	addi	a0,a0,-368
80002a4e:	c41ff06f          	j	8000268e <memset>

80002a52 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002a52:	1141                	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002a54:	4509                	li	a0,2
{
80002a56:	c606                	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002a58:	3f19                	jal	8000296e <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002a5a:	80007537          	lui	a0,0x80007
80002a5e:	92c50513          	addi	a0,a0,-1748 # 8000692c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000692d>
80002a62:	f4cff0ef          	jal	ra,800021ae <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002a66:	450d                	li	a0,3
80002a68:	3719                	jal	8000296e <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002a6a:	767010ef          	jal	ra,800049d0 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002a6e:	3dd9                	jal	80002944 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002a70:	800077b7          	lui	a5,0x80007
80002a74:	49c78793          	addi	a5,a5,1180 # 8000749c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000749d>
80002a78:	00c7c703          	lbu	a4,12(a5)
80002a7c:	9b79                	andi	a4,a4,-2
80002a7e:	00e78623          	sb	a4,12(a5)
}
80002a82:	40b2                	lw	ra,12(sp)
80002a84:	0141                	addi	sp,sp,16
80002a86:	8082                	ret

80002a88 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002a88:	7135                	addi	sp,sp,-160
80002a8a:	cd22                	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002a8c:	800097b7          	lui	a5,0x80009
80002a90:	80007437          	lui	s0,0x80007
80002a94:	c74e                	sw	s3,140(sp)
80002a96:	5c078793          	addi	a5,a5,1472 # 800095c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800095c1>
80002a9a:	50c40993          	addi	s3,s0,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
80002a9e:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80002aa2:	081c                	addi	a5,sp,16
80002aa4:	07000613          	li	a2,112
80002aa8:	4581                	li	a1,0
80002aaa:	853e                	mv	a0,a5
{
80002aac:	cf06                	sw	ra,156(sp)
80002aae:	cb26                	sw	s1,148(sp)
80002ab0:	c94a                	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002ab2:	bddff0ef          	jal	ra,8000268e <memset>
80002ab6:	4705                	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80002ab8:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002abc:	4501                	li	a0,0
	struct k_thread dummy_thread = {
80002abe:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002ac2:	3575                	jal	8000296e <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002ac4:	4505                	li	a0,1
80002ac6:	3565                	jal	8000296e <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002ac8:	10100793          	li	a5,257
80002acc:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002ad0:	4e8010ef          	jal	ra,80003fb8 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002ad4:	800077b7          	lui	a5,0x80007
80002ad8:	97078793          	addi	a5,a5,-1680 # 80006970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006971>
	_kernel.ready_q.cache = _main_thread;
80002adc:	80007937          	lui	s2,0x80007
	z_setup_new_thread(_main_thread, _main_stack,
80002ae0:	c23e                	sw	a5,4(sp)
80002ae2:	800036b7          	lui	a3,0x80003
80002ae6:	4785                	li	a5,1
80002ae8:	800095b7          	lui	a1,0x80009
	_kernel.ready_q.cache = _main_thread;
80002aec:	49c90493          	addi	s1,s2,1180 # 8000749c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000749d>
	z_setup_new_thread(_main_thread, _main_stack,
80002af0:	c03e                	sw	a5,0(sp)
80002af2:	4701                	li	a4,0
80002af4:	4781                	li	a5,0
80002af6:	4881                	li	a7,0
80002af8:	4801                	li	a6,0
80002afa:	a5268693          	addi	a3,a3,-1454 # 80002a52 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002a53>
80002afe:	20000613          	li	a2,512
80002b02:	9c058593          	addi	a1,a1,-1600 # 800089c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800089c1>
80002b06:	49c90513          	addi	a0,s2,1180
	_kernel.ready_q.cache = _main_thread;
80002b0a:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002b0e:	42f010ef          	jal	ra,8000473c <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002b12:	00d4c783          	lbu	a5,13(s1)
80002b16:	50c40413          	addi	s0,s0,1292
80002b1a:	ffb7f713          	andi	a4,a5,-5
80002b1e:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002b22:	8bed                	andi	a5,a5,27
80002b24:	e799                	bnez	a5,80002b32 <z_cstart+0xaa>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002b26:	4c9c                	lw	a5,24(s1)
80002b28:	e789                	bnez	a5,80002b32 <z_cstart+0xaa>
		z_add_thread_to_ready_q(thread);
80002b2a:	49c90513          	addi	a0,s2,1180
80002b2e:	2c9000ef          	jal	ra,800035f6 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002b32:	800067b7          	lui	a5,0x80006
80002b36:	cb878793          	addi	a5,a5,-840 # 80005cb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cb9>
80002b3a:	c23e                	sw	a5,4(sp)
80002b3c:	80007537          	lui	a0,0x80007
80002b40:	4785                	li	a5,1
80002b42:	800036b7          	lui	a3,0x80003
80002b46:	800095b7          	lui	a1,0x80009
80002b4a:	42c50493          	addi	s1,a0,1068 # 8000742c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000742d>
80002b4e:	c03e                	sw	a5,0(sp)
80002b50:	48bd                	li	a7,15
80002b52:	4801                	li	a6,0
80002b54:	4781                	li	a5,0
80002b56:	4701                	li	a4,0
80002b58:	a0e68693          	addi	a3,a3,-1522 # 80002a0e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002a0f>
80002b5c:	20000613          	li	a2,512
80002b60:	bc058593          	addi	a1,a1,-1088 # 80008bc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008bc1>
80002b64:	42c50513          	addi	a0,a0,1068
80002b68:	3d5010ef          	jal	ra,8000473c <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002b6c:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80002b70:	c444                	sw	s1,12(s0)
80002b72:	4521                	li	a0,8
80002b74:	9bed                	andi	a5,a5,-5
80002b76:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002b7a:	800077b7          	lui	a5,0x80007
80002b7e:	52478793          	addi	a5,a5,1316 # 80007524 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007525>
80002b82:	cc1c                	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002b84:	cc5c                	sw	a5,28(s0)
80002b86:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002b8a:	8921                	andi	a0,a0,8
80002b8c:	e44fd0ef          	jal	ra,800001d0 <__swap>

80002b90 <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002b90:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
80002b94:	1101                	addi	sp,sp,-32
80002b96:	cc22                	sw	s0,24(sp)
80002b98:	ce06                	sw	ra,28(sp)
80002b9a:	8bfd                	andi	a5,a5,31
80002b9c:	842a                	mv	s0,a0
80002b9e:	e799                	bnez	a5,80002bac <prepare_thread_to_run+0x1c>
	if (z_is_thread_ready(thread)) {
80002ba0:	4d1c                	lw	a5,24(a0)
80002ba2:	e789                	bnez	a5,80002bac <prepare_thread_to_run+0x1c>
80002ba4:	c62e                	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
80002ba6:	251000ef          	jal	ra,800035f6 <z_add_thread_to_ready_q>
80002baa:	45b2                	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80002bac:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
80002bb0:	c84c                	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
80002bb2:	40f2                	lw	ra,28(sp)
80002bb4:	4462                	lw	s0,24(sp)
80002bb6:	6105                	addi	sp,sp,32
80002bb8:	8082                	ret

80002bba <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
80002bba:	1101                	addi	sp,sp,-32
80002bbc:	cc22                	sw	s0,24(sp)
80002bbe:	ca26                	sw	s1,20(sp)
80002bc0:	c84a                	sw	s2,16(sp)
80002bc2:	c64e                	sw	s3,12(sp)
80002bc4:	c452                	sw	s4,8(sp)
80002bc6:	c05a                	sw	s6,0(sp)
80002bc8:	ce06                	sw	ra,28(sp)
80002bca:	c256                	sw	s5,4(sp)
80002bcc:	842a                	mv	s0,a0
80002bce:	89ae                	mv	s3,a1
80002bd0:	8a32                	mv	s4,a2
80002bd2:	8b36                	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002bd4:	00850913          	addi	s2,a0,8
80002bd8:	44a1                	li	s1,8
80002bda:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002bde:	854a                	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002be0:	88a1                	andi	s1,s1,8
80002be2:	3e3010ef          	jal	ra,800047c4 <z_spin_lock_valid>
80002be6:	ed0d                	bnez	a0,80002c20 <queue_insert+0x66>
80002be8:	80006ab7          	lui	s5,0x80006
80002bec:	800065b7          	lui	a1,0x80006
80002bf0:	80006537          	lui	a0,0x80006
80002bf4:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80002bf8:	04e00693          	li	a3,78
80002bfc:	794a8613          	addi	a2,s5,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80002c00:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002c04:	daaff0ef          	jal	ra,800021ae <printk>
80002c08:	80006537          	lui	a0,0x80006
80002c0c:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80002c10:	d9eff0ef          	jal	ra,800021ae <printk>
80002c14:	04e00593          	li	a1,78
80002c18:	794a8513          	addi	a0,s5,1940
80002c1c:	db0ff0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80002c20:	854a                	mv	a0,s2
80002c22:	3df010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
80002c26:	00c40513          	addi	a0,s0,12
80002c2a:	1cc010ef          	jal	ra,80003df6 <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
80002c2e:	c901                	beqz	a0,80002c3e <queue_insert+0x84>
		prepare_thread_to_run(first_pending_thread, data);
80002c30:	85d2                	mv	a1,s4
80002c32:	3fb9                	jal	80002b90 <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
80002c34:	854a                	mv	a0,s2
80002c36:	85a6                	mv	a1,s1
80002c38:	298d                	jal	800030aa <z_reschedule>
	return 0;
80002c3a:	4501                	li	a0,0
80002c3c:	a891                	j	80002c90 <queue_insert+0xd6>
	if (alloc) {
80002c3e:	080b0363          	beqz	s6,80002cc4 <queue_insert+0x10a>
		anode = z_thread_malloc(sizeof(*anode));
80002c42:	4521                	li	a0,8
80002c44:	14b020ef          	jal	ra,8000558e <z_thread_malloc>
		if (anode == NULL) {
80002c48:	ed31                	bnez	a0,80002ca4 <queue_insert+0xea>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002c4a:	854a                	mv	a0,s2
80002c4c:	393010ef          	jal	ra,800047de <z_spin_unlock_valid>
80002c50:	ed0d                	bnez	a0,80002c8a <queue_insert+0xd0>
80002c52:	80006437          	lui	s0,0x80006
80002c56:	800065b7          	lui	a1,0x80006
80002c5a:	80006537          	lui	a0,0x80006
80002c5e:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002c62:	06100693          	li	a3,97
80002c66:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80002c6a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002c6e:	d40ff0ef          	jal	ra,800021ae <printk>
80002c72:	80006537          	lui	a0,0x80006
80002c76:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80002c7a:	d34ff0ef          	jal	ra,800021ae <printk>
80002c7e:	06100593          	li	a1,97
80002c82:	79440513          	addi	a0,s0,1940
80002c86:	d46ff0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002c8a:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
80002c8e:	5551                	li	a0,-12
}
80002c90:	40f2                	lw	ra,28(sp)
80002c92:	4462                	lw	s0,24(sp)
80002c94:	44d2                	lw	s1,20(sp)
80002c96:	4942                	lw	s2,16(sp)
80002c98:	49b2                	lw	s3,12(sp)
80002c9a:	4a22                	lw	s4,8(sp)
80002c9c:	4a92                	lw	s5,4(sp)
80002c9e:	4b02                	lw	s6,0(sp)
80002ca0:	6105                	addi	sp,sp,32
80002ca2:	8082                	ret
 * @param flags A value between 0 and 3 to set the flags value
 */
static inline void sys_sfnode_init(sys_sfnode_t *node, u8_t flags)
{
	__ASSERT((flags & ~SYS_SFLIST_FLAGS_MASK) == 0U, "flags too large");
	node->next_and_flags = flags;
80002ca4:	4785                	li	a5,1
		anode->data = data;
80002ca6:	01452223          	sw	s4,4(a0)
80002caa:	c11c                	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
80002cac:	411c                	lw	a5,0(a0)
80002cae:	8b8d                	andi	a5,a5,3
80002cb0:	00099e63          	bnez	s3,80002ccc <queue_insert+0x112>
	parent->next_and_flags = cur_flags | (unative_t)child;
80002cb4:	4018                	lw	a4,0(s0)
80002cb6:	8fd9                	or	a5,a5,a4
80002cb8:	c11c                	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
80002cba:	405c                	lw	a5,4(s0)
	list->head = node;
80002cbc:	c008                	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
80002cbe:	fbbd                	bnez	a5,80002c34 <queue_insert+0x7a>
	list->tail = node;
80002cc0:	c048                	sw	a0,4(s0)
80002cc2:	bf8d                	j	80002c34 <queue_insert+0x7a>
	node->next_and_flags = flags;
80002cc4:	000a2023          	sw	zero,0(s4)
80002cc8:	8552                	mv	a0,s4
80002cca:	b7cd                	j	80002cac <queue_insert+0xf2>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002ccc:	0009a703          	lw	a4,0(s3)
80002cd0:	9b71                	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
80002cd2:	ef01                	bnez	a4,80002cea <queue_insert+0x130>
Z_GENLIST_APPEND(sflist, sfnode)
80002cd4:	4058                	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002cd6:	c11c                	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
80002cd8:	e701                	bnez	a4,80002ce0 <queue_insert+0x126>
	list->tail = node;
80002cda:	c048                	sw	a0,4(s0)
	list->head = node;
80002cdc:	c008                	sw	a0,0(s0)
80002cde:	bf99                	j	80002c34 <queue_insert+0x7a>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002ce0:	431c                	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002ce2:	8b8d                	andi	a5,a5,3
80002ce4:	8fc9                	or	a5,a5,a0
80002ce6:	c31c                	sw	a5,0(a4)
80002ce8:	bfe1                	j	80002cc0 <queue_insert+0x106>
80002cea:	8fd9                	or	a5,a5,a4
80002cec:	c11c                	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002cee:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002cf2:	8b8d                	andi	a5,a5,3
80002cf4:	8d5d                	or	a0,a0,a5
80002cf6:	00a9a023          	sw	a0,0(s3)
80002cfa:	bf2d                	j	80002c34 <queue_insert+0x7a>

80002cfc <z_queue_node_peek>:
{
80002cfc:	1141                	addi	sp,sp,-16
80002cfe:	c422                	sw	s0,8(sp)
80002d00:	c606                	sw	ra,12(sp)
80002d02:	842a                	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
80002d04:	c901                	beqz	a0,80002d14 <z_queue_node_peek+0x18>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002d06:	411c                	lw	a5,0(a0)
80002d08:	8b8d                	andi	a5,a5,3
80002d0a:	c789                	beqz	a5,80002d14 <z_queue_node_peek+0x18>
		ret = anode->data;
80002d0c:	4140                	lw	s0,4(a0)
		if (needs_free) {
80002d0e:	c199                	beqz	a1,80002d14 <z_queue_node_peek+0x18>
			k_free(anode);
80002d10:	075020ef          	jal	ra,80005584 <k_free>
}
80002d14:	8522                	mv	a0,s0
80002d16:	40b2                	lw	ra,12(sp)
80002d18:	4422                	lw	s0,8(sp)
80002d1a:	0141                	addi	sp,sp,16
80002d1c:	8082                	ret

80002d1e <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80002d1e:	00c50793          	addi	a5,a0,12
	list->head = NULL;
80002d22:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
80002d26:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
80002d2a:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
80002d2e:	c55c                	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
80002d30:	c91c                	sw	a5,16(a0)
}
80002d32:	8082                	ret

80002d34 <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
80002d34:	862e                	mv	a2,a1
80002d36:	414c                	lw	a1,4(a0)
80002d38:	4681                	li	a3,0
80002d3a:	b541                	j	80002bba <queue_insert>

80002d3c <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
80002d3c:	1101                	addi	sp,sp,-32
80002d3e:	cc22                	sw	s0,24(sp)
80002d40:	ca26                	sw	s1,20(sp)
80002d42:	c84a                	sw	s2,16(sp)
80002d44:	c64e                	sw	s3,12(sp)
80002d46:	ce06                	sw	ra,28(sp)
80002d48:	c452                	sw	s4,8(sp)
80002d4a:	84aa                	mv	s1,a0
80002d4c:	89ae                	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002d4e:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002d52:	4421                	li	s0,8
80002d54:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002d58:	854a                	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002d5a:	8821                	andi	s0,s0,8
80002d5c:	269010ef          	jal	ra,800047c4 <z_spin_lock_valid>
80002d60:	ed0d                	bnez	a0,80002d9a <z_impl_k_queue_get+0x5e>
80002d62:	80006a37          	lui	s4,0x80006
80002d66:	800065b7          	lui	a1,0x80006
80002d6a:	80006537          	lui	a0,0x80006
80002d6e:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80002d72:	04e00693          	li	a3,78
80002d76:	794a0613          	addi	a2,s4,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80002d7a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002d7e:	c30ff0ef          	jal	ra,800021ae <printk>
80002d82:	80006537          	lui	a0,0x80006
80002d86:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80002d8a:	c24ff0ef          	jal	ra,800021ae <printk>
80002d8e:	04e00593          	li	a1,78
80002d92:	794a0513          	addi	a0,s4,1940
80002d96:	c36ff0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80002d9a:	854a                	mv	a0,s2
80002d9c:	265010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
80002da0:	4088                	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
80002da2:	c535                	beqz	a0,80002e0e <z_impl_k_queue_get+0xd2>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002da4:	411c                	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80002da6:	40d8                	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002da8:	9bf1                	andi	a5,a5,-4
	list->head = node;
80002daa:	c09c                	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80002dac:	00e51363          	bne	a0,a4,80002db2 <z_impl_k_queue_get+0x76>
	list->tail = node;
80002db0:	c0dc                	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
80002db2:	4585                	li	a1,1
80002db4:	37a1                	jal	80002cfc <z_queue_node_peek>
80002db6:	84aa                	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002db8:	854a                	mv	a0,s2
80002dba:	225010ef          	jal	ra,800047de <z_spin_unlock_valid>
80002dbe:	ed0d                	bnez	a0,80002df8 <z_impl_k_queue_get+0xbc>
80002dc0:	80006937          	lui	s2,0x80006
80002dc4:	800065b7          	lui	a1,0x80006
80002dc8:	80006537          	lui	a0,0x80006
80002dcc:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002dd0:	06100693          	li	a3,97
80002dd4:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80002dd8:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002ddc:	bd2ff0ef          	jal	ra,800021ae <printk>
80002de0:	80006537          	lui	a0,0x80006
80002de4:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80002de8:	bc6ff0ef          	jal	ra,800021ae <printk>
80002dec:	06100593          	li	a1,97
80002df0:	79490513          	addi	a0,s2,1940
80002df4:	bd8ff0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002df8:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
80002dfc:	40f2                	lw	ra,28(sp)
80002dfe:	4462                	lw	s0,24(sp)
80002e00:	8526                	mv	a0,s1
80002e02:	4942                	lw	s2,16(sp)
80002e04:	44d2                	lw	s1,20(sp)
80002e06:	49b2                	lw	s3,12(sp)
80002e08:	4a22                	lw	s4,8(sp)
80002e0a:	6105                	addi	sp,sp,32
80002e0c:	8082                	ret
	if (timeout == K_NO_WAIT) {
80002e0e:	04099663          	bnez	s3,80002e5a <z_impl_k_queue_get+0x11e>
80002e12:	854a                	mv	a0,s2
80002e14:	1cb010ef          	jal	ra,800047de <z_spin_unlock_valid>
80002e18:	ed0d                	bnez	a0,80002e52 <z_impl_k_queue_get+0x116>
80002e1a:	800064b7          	lui	s1,0x80006
80002e1e:	800065b7          	lui	a1,0x80006
80002e22:	80006537          	lui	a0,0x80006
80002e26:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002e2a:	06100693          	li	a3,97
80002e2e:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80002e32:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002e36:	b78ff0ef          	jal	ra,800021ae <printk>
80002e3a:	80006537          	lui	a0,0x80006
80002e3e:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80002e42:	b6cff0ef          	jal	ra,800021ae <printk>
80002e46:	06100593          	li	a1,97
80002e4a:	79448513          	addi	a0,s1,1940
80002e4e:	b7eff0ef          	jal	ra,800021cc <assert_post_action>
80002e52:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
80002e56:	4481                	li	s1,0
80002e58:	b755                	j	80002dfc <z_impl_k_queue_get+0xc0>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80002e5a:	00c48613          	addi	a2,s1,12
80002e5e:	86ce                	mv	a3,s3
80002e60:	85a2                	mv	a1,s0
80002e62:	854a                	mv	a0,s2
80002e64:	58b000ef          	jal	ra,80003bee <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
80002e68:	4481                	li	s1,0
80002e6a:	f949                	bnez	a0,80002dfc <z_impl_k_queue_get+0xc0>
80002e6c:	800077b7          	lui	a5,0x80007
80002e70:	5147a783          	lw	a5,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80002e74:	4bc4                	lw	s1,20(a5)
80002e76:	b759                	j	80002dfc <z_impl_k_queue_get+0xc0>

80002e78 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002e78:	00d54783          	lbu	a5,13(a0)
80002e7c:	8bfd                	andi	a5,a5,31
80002e7e:	e789                	bnez	a5,80002e88 <z_is_thread_ready+0x10>
80002e80:	4d08                	lw	a0,24(a0)
80002e82:	00153513          	seqz	a0,a0
80002e86:	8082                	ret
80002e88:	4501                	li	a0,0
}
80002e8a:	8082                	ret

80002e8c <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002e8c:	1141                	addi	sp,sp,-16
80002e8e:	c606                	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002e90:	ea4ff0ef          	jal	ra,80002534 <z_clock_elapsed>
80002e94:	800077b7          	lui	a5,0x80007
80002e98:	ec47a783          	lw	a5,-316(a5) # 80006ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec5>

	z_set_timeout_expiry(slice_time, false);
}
80002e9c:	40b2                	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002e9e:	80007737          	lui	a4,0x80007
80002ea2:	953e                	add	a0,a0,a5
80002ea4:	50a72e23          	sw	a0,1308(a4) # 8000751c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000751d>
	z_set_timeout_expiry(slice_time, false);
80002ea8:	4581                	li	a1,0
80002eaa:	853e                	mv	a0,a5
}
80002eac:	0141                	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002eae:	0360206f          	j	80004ee4 <z_set_timeout_expiry>

80002eb2 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002eb2:	411c                	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002eb4:	1141                	addi	sp,sp,-16
80002eb6:	c422                	sw	s0,8(sp)
80002eb8:	c606                	sw	ra,12(sp)
80002eba:	c226                	sw	s1,4(sp)
80002ebc:	842a                	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002ebe:	e79d                	bnez	a5,80002eec <pended_on.isra.15+0x3a>
80002ec0:	800074b7          	lui	s1,0x80007
80002ec4:	800075b7          	lui	a1,0x80007
80002ec8:	80006537          	lui	a0,0x80006
80002ecc:	a1058593          	addi	a1,a1,-1520 # 80006a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a11>
80002ed0:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002ed4:	18300693          	li	a3,387
80002ed8:	9fc48613          	addi	a2,s1,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80002edc:	ad2ff0ef          	jal	ra,800021ae <printk>
80002ee0:	18300593          	li	a1,387
80002ee4:	9fc48513          	addi	a0,s1,-1540
80002ee8:	ae4ff0ef          	jal	ra,800021cc <assert_post_action>

	return thread->base.pended_on;
}
80002eec:	4008                	lw	a0,0(s0)
80002eee:	40b2                	lw	ra,12(sp)
80002ef0:	4422                	lw	s0,8(sp)
80002ef2:	4492                	lw	s1,4(sp)
80002ef4:	0141                	addi	sp,sp,16
80002ef6:	8082                	ret

80002ef8 <k_sched_time_slice_set>:
{
80002ef8:	1101                	addi	sp,sp,-32
80002efa:	cc22                	sw	s0,24(sp)
80002efc:	c64e                	sw	s3,12(sp)
80002efe:	c452                	sw	s4,8(sp)
80002f00:	ce06                	sw	ra,28(sp)
80002f02:	ca26                	sw	s1,20(sp)
80002f04:	c84a                	sw	s2,16(sp)
80002f06:	8a2a                	mv	s4,a0
80002f08:	89ae                	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002f0a:	4421                	li	s0,8
80002f0c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f10:	800074b7          	lui	s1,0x80007
80002f14:	ebc48513          	addi	a0,s1,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80002f18:	8821                	andi	s0,s0,8
80002f1a:	0ab010ef          	jal	ra,800047c4 <z_spin_lock_valid>
80002f1e:	ed0d                	bnez	a0,80002f58 <k_sched_time_slice_set+0x60>
80002f20:	80006937          	lui	s2,0x80006
80002f24:	800065b7          	lui	a1,0x80006
80002f28:	80006537          	lui	a0,0x80006
80002f2c:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80002f30:	04e00693          	li	a3,78
80002f34:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80002f38:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002f3c:	a72ff0ef          	jal	ra,800021ae <printk>
80002f40:	80006537          	lui	a0,0x80006
80002f44:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80002f48:	a66ff0ef          	jal	ra,800021ae <printk>
80002f4c:	04e00593          	li	a1,78
80002f50:	79490513          	addi	a0,s2,1940
80002f54:	a78ff0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80002f58:	ebc48513          	addi	a0,s1,-324
80002f5c:	0a5010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002f60:	800077b7          	lui	a5,0x80007
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002f64:	45a9                	li	a1,10
80002f66:	009a0513          	addi	a0,s4,9
80002f6a:	5007ae23          	sw	zero,1308(a5) # 8000751c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000751d>
80002f6e:	973fd0ef          	jal	ra,800008e0 <__divsi3>
		slice_max_prio = prio;
80002f72:	800077b7          	lui	a5,0x80007
		slice_time = z_ms_to_ticks(slice);
80002f76:	80007937          	lui	s2,0x80007
80002f7a:	eca92223          	sw	a0,-316(s2) # 80006ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec5>
		slice_max_prio = prio;
80002f7e:	ed37a023          	sw	s3,-320(a5) # 80006ec0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec1>
		reset_time_slice();
80002f82:	3729                	jal	80002e8c <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002f84:	ebc48513          	addi	a0,s1,-324
80002f88:	057010ef          	jal	ra,800047de <z_spin_unlock_valid>
80002f8c:	ed0d                	bnez	a0,80002fc6 <k_sched_time_slice_set+0xce>
80002f8e:	800064b7          	lui	s1,0x80006
80002f92:	800065b7          	lui	a1,0x80006
80002f96:	80006537          	lui	a0,0x80006
80002f9a:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80002f9e:	06100693          	li	a3,97
80002fa2:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80002fa6:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80002faa:	a04ff0ef          	jal	ra,800021ae <printk>
80002fae:	80006537          	lui	a0,0x80006
80002fb2:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80002fb6:	9f8ff0ef          	jal	ra,800021ae <printk>
80002fba:	06100593          	li	a1,97
80002fbe:	79448513          	addi	a0,s1,1940
80002fc2:	a0aff0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002fc6:	30042473          	csrrs	s0,mstatus,s0
}
80002fca:	40f2                	lw	ra,28(sp)
80002fcc:	4462                	lw	s0,24(sp)
80002fce:	44d2                	lw	s1,20(sp)
80002fd0:	4942                	lw	s2,16(sp)
80002fd2:	49b2                	lw	s3,12(sp)
80002fd4:	4a22                	lw	s4,8(sp)
80002fd6:	6105                	addi	sp,sp,32
80002fd8:	8082                	ret

80002fda <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002fda:	1101                	addi	sp,sp,-32
80002fdc:	cc22                	sw	s0,24(sp)
80002fde:	c84a                	sw	s2,16(sp)
80002fe0:	ce06                	sw	ra,28(sp)
80002fe2:	ca26                	sw	s1,20(sp)
80002fe4:	c64e                	sw	s3,12(sp)
80002fe6:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002fe8:	4421                	li	s0,8
80002fea:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002fee:	800074b7          	lui	s1,0x80007
80002ff2:	ebc48513          	addi	a0,s1,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ff6:	8821                	andi	s0,s0,8
80002ff8:	7cc010ef          	jal	ra,800047c4 <z_spin_lock_valid>
80002ffc:	ed0d                	bnez	a0,80003036 <z_unpend_thread_no_timeout+0x5c>
80002ffe:	800069b7          	lui	s3,0x80006
80003002:	800065b7          	lui	a1,0x80006
80003006:	80006537          	lui	a0,0x80006
8000300a:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
8000300e:	04e00693          	li	a3,78
80003012:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003016:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000301a:	994ff0ef          	jal	ra,800021ae <printk>
8000301e:	80006537          	lui	a0,0x80006
80003022:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003026:	988ff0ef          	jal	ra,800021ae <printk>
8000302a:	04e00593          	li	a1,78
8000302e:	79498513          	addi	a0,s3,1940
80003032:	99aff0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80003036:	ebc48513          	addi	a0,s1,-324
8000303a:	7c6010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000303e:	00890513          	addi	a0,s2,8
80003042:	3d85                	jal	80002eb2 <pended_on.isra.15>
80003044:	85ca                	mv	a1,s2
80003046:	2451                	jal	800032ca <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003048:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000304c:	ebc48513          	addi	a0,s1,-324
80003050:	9bf5                	andi	a5,a5,-3
80003052:	00f906a3          	sb	a5,13(s2)
80003056:	788010ef          	jal	ra,800047de <z_spin_unlock_valid>
8000305a:	ed0d                	bnez	a0,80003094 <z_unpend_thread_no_timeout+0xba>
8000305c:	800064b7          	lui	s1,0x80006
80003060:	800065b7          	lui	a1,0x80006
80003064:	80006537          	lui	a0,0x80006
80003068:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000306c:	06100693          	li	a3,97
80003070:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003074:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003078:	936ff0ef          	jal	ra,800021ae <printk>
8000307c:	80006537          	lui	a0,0x80006
80003080:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80003084:	92aff0ef          	jal	ra,800021ae <printk>
80003088:	06100593          	li	a1,97
8000308c:	79448513          	addi	a0,s1,1940
80003090:	93cff0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003094:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80003098:	40f2                	lw	ra,28(sp)
8000309a:	4462                	lw	s0,24(sp)
	thread->base.pended_on = NULL;
8000309c:	00092423          	sw	zero,8(s2)
}
800030a0:	44d2                	lw	s1,20(sp)
800030a2:	4942                	lw	s2,16(sp)
800030a4:	49b2                	lw	s3,12(sp)
800030a6:	6105                	addi	sp,sp,32
800030a8:	8082                	ret

800030aa <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
800030aa:	800077b7          	lui	a5,0x80007
800030ae:	50c7a783          	lw	a5,1292(a5) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
{
800030b2:	1141                	addi	sp,sp,-16
800030b4:	c422                	sw	s0,8(sp)
800030b6:	c606                	sw	ra,12(sp)
800030b8:	c226                	sw	s1,4(sp)
800030ba:	842e                	mv	s0,a1
	if (resched()) {
800030bc:	e7b9                	bnez	a5,8000310a <z_reschedule+0x60>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800030be:	720010ef          	jal	ra,800047de <z_spin_unlock_valid>
800030c2:	ed0d                	bnez	a0,800030fc <z_reschedule+0x52>
800030c4:	800064b7          	lui	s1,0x80006
800030c8:	800065b7          	lui	a1,0x80006
800030cc:	80006537          	lui	a0,0x80006
800030d0:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800030d4:	07800693          	li	a3,120
800030d8:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800030dc:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800030e0:	8ceff0ef          	jal	ra,800021ae <printk>
800030e4:	80006537          	lui	a0,0x80006
800030e8:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800030ec:	8c2ff0ef          	jal	ra,800021ae <printk>
800030f0:	07800593          	li	a1,120
800030f4:	79448513          	addi	a0,s1,1940
800030f8:	8d4ff0ef          	jal	ra,800021cc <assert_post_action>
800030fc:	8522                	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
800030fe:	4422                	lw	s0,8(sp)
80003100:	40b2                	lw	ra,12(sp)
80003102:	4492                	lw	s1,4(sp)
80003104:	0141                	addi	sp,sp,16
80003106:	8cafd06f          	j	800001d0 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000310a:	6d4010ef          	jal	ra,800047de <z_spin_unlock_valid>
8000310e:	ed0d                	bnez	a0,80003148 <z_reschedule+0x9e>
80003110:	800064b7          	lui	s1,0x80006
80003114:	800065b7          	lui	a1,0x80006
80003118:	80006537          	lui	a0,0x80006
8000311c:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003120:	06100693          	li	a3,97
80003124:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003128:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000312c:	882ff0ef          	jal	ra,800021ae <printk>
80003130:	80006537          	lui	a0,0x80006
80003134:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80003138:	876ff0ef          	jal	ra,800021ae <printk>
8000313c:	06100593          	li	a1,97
80003140:	79448513          	addi	a0,s1,1940
80003144:	888ff0ef          	jal	ra,800021cc <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003148:	8821                	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000314a:	30042473          	csrrs	s0,mstatus,s0
8000314e:	40b2                	lw	ra,12(sp)
80003150:	4422                	lw	s0,8(sp)
80003152:	4492                	lw	s1,4(sp)
80003154:	0141                	addi	sp,sp,16
80003156:	8082                	ret

80003158 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003158:	80007737          	lui	a4,0x80007
8000315c:	50c72703          	lw	a4,1292(a4) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
80003160:	e319                	bnez	a4,80003166 <z_reschedule_irqlock+0xe>
80003162:	86efd06f          	j	800001d0 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003166:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000316a:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
8000316e:	8082                	ret

80003170 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003170:	4521                	li	a0,8
80003172:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80003176:	8921                	andi	a0,a0,8
80003178:	b7c5                	j	80003158 <z_reschedule_irqlock>

8000317a <k_sched_lock>:

void k_sched_lock(void)
{
8000317a:	1101                	addi	sp,sp,-32
8000317c:	cc22                	sw	s0,24(sp)
8000317e:	ce06                	sw	ra,28(sp)
80003180:	ca26                	sw	s1,20(sp)
80003182:	c84a                	sw	s2,16(sp)
80003184:	c64e                	sw	s3,12(sp)
80003186:	4421                	li	s0,8
80003188:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000318c:	800074b7          	lui	s1,0x80007
80003190:	ebc48513          	addi	a0,s1,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003194:	8821                	andi	s0,s0,8
80003196:	62e010ef          	jal	ra,800047c4 <z_spin_lock_valid>
8000319a:	ed0d                	bnez	a0,800031d4 <k_sched_lock+0x5a>
8000319c:	80006937          	lui	s2,0x80006
800031a0:	800065b7          	lui	a1,0x80006
800031a4:	80006537          	lui	a0,0x80006
800031a8:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
800031ac:	04e00693          	li	a3,78
800031b0:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800031b4:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800031b8:	ff7fe0ef          	jal	ra,800021ae <printk>
800031bc:	80006537          	lui	a0,0x80006
800031c0:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
800031c4:	febfe0ef          	jal	ra,800021ae <printk>
800031c8:	04e00593          	li	a1,78
800031cc:	79490513          	addi	a0,s2,1940
800031d0:	ffdfe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
800031d4:	ebc48513          	addi	a0,s1,-324
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
800031d8:	80007937          	lui	s2,0x80007
800031dc:	624010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
800031e0:	50c92783          	lw	a5,1292(s2) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
800031e4:	50c90913          	addi	s2,s2,1292
800031e8:	cf8d                	beqz	a5,80003222 <k_sched_lock+0xa8>
800031ea:	800079b7          	lui	s3,0x80007
800031ee:	800075b7          	lui	a1,0x80007
800031f2:	80006537          	lui	a0,0x80006
800031f6:	99458593          	addi	a1,a1,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
800031fa:	10000693          	li	a3,256
800031fe:	97898613          	addi	a2,s3,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
80003202:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003206:	fa9fe0ef          	jal	ra,800021ae <printk>
8000320a:	80006537          	lui	a0,0x80006
8000320e:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80003212:	f9dfe0ef          	jal	ra,800021ae <printk>
80003216:	10000593          	li	a1,256
8000321a:	97898513          	addi	a0,s3,-1672
8000321e:	faffe0ef          	jal	ra,800021cc <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80003222:	00892783          	lw	a5,8(s2)
80003226:	00f7c703          	lbu	a4,15(a5)
8000322a:	4785                	li	a5,1
8000322c:	02f71e63          	bne	a4,a5,80003268 <k_sched_lock+0xee>
80003230:	800079b7          	lui	s3,0x80007
80003234:	800075b7          	lui	a1,0x80007
80003238:	80006537          	lui	a0,0x80006
8000323c:	9ac58593          	addi	a1,a1,-1620 # 800069ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069ad>
80003240:	10100693          	li	a3,257
80003244:	97898613          	addi	a2,s3,-1672 # 80006978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006979>
80003248:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000324c:	f63fe0ef          	jal	ra,800021ae <printk>
80003250:	80006537          	lui	a0,0x80006
80003254:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80003258:	f57fe0ef          	jal	ra,800021ae <printk>
8000325c:	10100593          	li	a1,257
80003260:	97898513          	addi	a0,s3,-1672
80003264:	f69fe0ef          	jal	ra,800021cc <assert_post_action>

	--_current->base.sched_locked;
80003268:	00892703          	lw	a4,8(s2)
8000326c:	00f74783          	lbu	a5,15(a4)
80003270:	17fd                	addi	a5,a5,-1
80003272:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003276:	ebc48513          	addi	a0,s1,-324
8000327a:	564010ef          	jal	ra,800047de <z_spin_unlock_valid>
8000327e:	ed0d                	bnez	a0,800032b8 <k_sched_lock+0x13e>
80003280:	800064b7          	lui	s1,0x80006
80003284:	800065b7          	lui	a1,0x80006
80003288:	80006537          	lui	a0,0x80006
8000328c:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003290:	06100693          	li	a3,97
80003294:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003298:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000329c:	f13fe0ef          	jal	ra,800021ae <printk>
800032a0:	80006537          	lui	a0,0x80006
800032a4:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800032a8:	f07fe0ef          	jal	ra,800021ae <printk>
800032ac:	06100593          	li	a1,97
800032b0:	79448513          	addi	a0,s1,1940
800032b4:	f19fe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800032b8:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800032bc:	40f2                	lw	ra,28(sp)
800032be:	4462                	lw	s0,24(sp)
800032c0:	44d2                	lw	s1,20(sp)
800032c2:	4942                	lw	s2,16(sp)
800032c4:	49b2                	lw	s3,12(sp)
800032c6:	6105                	addi	sp,sp,32
800032c8:	8082                	ret

800032ca <z_priq_dumb_remove>:
	return thread == _idle_thread;
800032ca:	800077b7          	lui	a5,0x80007
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800032ce:	e487a783          	lw	a5,-440(a5) # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
{
800032d2:	1141                	addi	sp,sp,-16
800032d4:	c422                	sw	s0,8(sp)
800032d6:	c606                	sw	ra,12(sp)
800032d8:	c226                	sw	s1,4(sp)
800032da:	842e                	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800032dc:	02f59863          	bne	a1,a5,8000330c <z_priq_dumb_remove+0x42>
800032e0:	800074b7          	lui	s1,0x80007
800032e4:	800075b7          	lui	a1,0x80007
800032e8:	80006537          	lui	a0,0x80006
800032ec:	b1458593          	addi	a1,a1,-1260 # 80006b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b15>
800032f0:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800032f4:	28c00693          	li	a3,652
800032f8:	9fc48613          	addi	a2,s1,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
800032fc:	eb3fe0ef          	jal	ra,800021ae <printk>
80003300:	28c00593          	li	a1,652
80003304:	9fc48513          	addi	a0,s1,-1540
80003308:	ec5fe0ef          	jal	ra,800021cc <assert_post_action>
	node->prev->next = node->next;
8000330c:	4058                	lw	a4,4(s0)
8000330e:	401c                	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80003310:	40b2                	lw	ra,12(sp)
80003312:	4492                	lw	s1,4(sp)
80003314:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80003316:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80003318:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
8000331c:	00042223          	sw	zero,4(s0)
80003320:	4422                	lw	s0,8(sp)
80003322:	0141                	addi	sp,sp,16
80003324:	8082                	ret

80003326 <z_unpend_thread>:
{
80003326:	1101                	addi	sp,sp,-32
80003328:	cc22                	sw	s0,24(sp)
8000332a:	ca26                	sw	s1,20(sp)
8000332c:	ce06                	sw	ra,28(sp)
8000332e:	c84a                	sw	s2,16(sp)
80003330:	c64e                	sw	s3,12(sp)
80003332:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003334:	44a1                	li	s1,8
80003336:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000333a:	80007937          	lui	s2,0x80007
8000333e:	ebc90513          	addi	a0,s2,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003342:	88a1                	andi	s1,s1,8
80003344:	480010ef          	jal	ra,800047c4 <z_spin_lock_valid>
80003348:	ed0d                	bnez	a0,80003382 <z_unpend_thread+0x5c>
8000334a:	800069b7          	lui	s3,0x80006
8000334e:	800065b7          	lui	a1,0x80006
80003352:	80006537          	lui	a0,0x80006
80003356:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
8000335a:	04e00693          	li	a3,78
8000335e:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003362:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003366:	e49fe0ef          	jal	ra,800021ae <printk>
8000336a:	80006537          	lui	a0,0x80006
8000336e:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003372:	e3dfe0ef          	jal	ra,800021ae <printk>
80003376:	04e00593          	li	a1,78
8000337a:	79498513          	addi	a0,s3,1940
8000337e:	e4ffe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80003382:	ebc90513          	addi	a0,s2,-324
80003386:	47a010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000338a:	00840513          	addi	a0,s0,8
8000338e:	b25ff0ef          	jal	ra,80002eb2 <pended_on.isra.15>
80003392:	85a2                	mv	a1,s0
80003394:	3f1d                	jal	800032ca <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003396:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000339a:	ebc90513          	addi	a0,s2,-324
8000339e:	9bf5                	andi	a5,a5,-3
800033a0:	00f406a3          	sb	a5,13(s0)
800033a4:	43a010ef          	jal	ra,800047de <z_spin_unlock_valid>
800033a8:	ed0d                	bnez	a0,800033e2 <z_unpend_thread+0xbc>
800033aa:	80006937          	lui	s2,0x80006
800033ae:	800065b7          	lui	a1,0x80006
800033b2:	80006537          	lui	a0,0x80006
800033b6:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800033ba:	06100693          	li	a3,97
800033be:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800033c2:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800033c6:	de9fe0ef          	jal	ra,800021ae <printk>
800033ca:	80006537          	lui	a0,0x80006
800033ce:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800033d2:	dddfe0ef          	jal	ra,800021ae <printk>
800033d6:	06100593          	li	a1,97
800033da:	79490513          	addi	a0,s2,1940
800033de:	deffe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800033e2:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800033e6:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800033ea:	01840513          	addi	a0,s0,24
}
800033ee:	4462                	lw	s0,24(sp)
800033f0:	40f2                	lw	ra,28(sp)
800033f2:	44d2                	lw	s1,20(sp)
800033f4:	4942                	lw	s2,16(sp)
800033f6:	49b2                	lw	s3,12(sp)
800033f8:	6105                	addi	sp,sp,32
800033fa:	1670106f          	j	80004d60 <z_abort_timeout>

800033fe <z_priq_dumb_best>:
	return list->head == list;
800033fe:	411c                	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003400:	00f51363          	bne	a0,a5,80003406 <z_priq_dumb_best+0x8>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003404:	4781                	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80003406:	853e                	mv	a0,a5
80003408:	8082                	ret

8000340a <update_cache>:
{
8000340a:	1141                	addi	sp,sp,-16
8000340c:	c422                	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
8000340e:	80007437          	lui	s0,0x80007
{
80003412:	c04a                	sw	s2,0(sp)
80003414:	892a                	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003416:	50c40513          	addi	a0,s0,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
8000341a:	02450513          	addi	a0,a0,36
{
8000341e:	c226                	sw	s1,4(sp)
80003420:	c606                	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003422:	3ff1                	jal	800033fe <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80003424:	50c40413          	addi	s0,s0,1292
80003428:	84aa                	mv	s1,a0
8000342a:	e111                	bnez	a0,8000342e <update_cache+0x24>
8000342c:	4444                	lw	s1,12(s0)
	if (preempt_ok != 0) {
8000342e:	06091263          	bnez	s2,80003492 <update_cache+0x88>
	__ASSERT(_current != NULL, "");
80003432:	441c                	lw	a5,8(s0)
80003434:	ef8d                	bnez	a5,8000346e <update_cache+0x64>
80003436:	80007937          	lui	s2,0x80007
8000343a:	800075b7          	lui	a1,0x80007
8000343e:	80006537          	lui	a0,0x80006
80003442:	a2858593          	addi	a1,a1,-1496 # 80006a28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a29>
80003446:	07f00693          	li	a3,127
8000344a:	9fc90613          	addi	a2,s2,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
8000344e:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003452:	d5dfe0ef          	jal	ra,800021ae <printk>
80003456:	80006537          	lui	a0,0x80006
8000345a:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
8000345e:	d51fe0ef          	jal	ra,800021ae <printk>
80003462:	07f00593          	li	a1,127
80003466:	9fc90513          	addi	a0,s2,-1540
8000346a:	d63fe0ef          	jal	ra,800021cc <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
8000346e:	441c                	lw	a5,8(s0)
80003470:	00d7c703          	lbu	a4,13(a5)
80003474:	8b7d                	andi	a4,a4,31
80003476:	ef11                	bnez	a4,80003492 <update_cache+0x88>
	if (is_preempt(_current) || is_metairq(th)) {
80003478:	00e7d683          	lhu	a3,14(a5)
8000347c:	07f00713          	li	a4,127
80003480:	00d77963          	bgeu	a4,a3,80003492 <update_cache+0x88>
		_kernel.ready_q.cache = _current;
80003484:	d01c                	sw	a5,32(s0)
}
80003486:	40b2                	lw	ra,12(sp)
80003488:	4422                	lw	s0,8(sp)
8000348a:	4492                	lw	s1,4(sp)
8000348c:	4902                	lw	s2,0(sp)
8000348e:	0141                	addi	sp,sp,16
80003490:	8082                	ret
		if (th != _current) {
80003492:	441c                	lw	a5,8(s0)
80003494:	00978463          	beq	a5,s1,8000349c <update_cache+0x92>
			reset_time_slice();
80003498:	9f5ff0ef          	jal	ra,80002e8c <reset_time_slice>
		_kernel.ready_q.cache = th;
8000349c:	d004                	sw	s1,32(s0)
}
8000349e:	b7e5                	j	80003486 <update_cache+0x7c>

800034a0 <k_sched_unlock>:
{
800034a0:	1101                	addi	sp,sp,-32
800034a2:	c84a                	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800034a4:	80007937          	lui	s2,0x80007
800034a8:	50c90793          	addi	a5,s2,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
800034ac:	479c                	lw	a5,8(a5)
{
800034ae:	ce06                	sw	ra,28(sp)
800034b0:	cc22                	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800034b2:	00f7c783          	lbu	a5,15(a5)
{
800034b6:	ca26                	sw	s1,20(sp)
800034b8:	c64e                	sw	s3,12(sp)
800034ba:	50c90913          	addi	s2,s2,1292
	__ASSERT(_current->base.sched_locked != 0, "");
800034be:	ef8d                	bnez	a5,800034f8 <k_sched_unlock+0x58>
800034c0:	80007437          	lui	s0,0x80007
800034c4:	800075b7          	lui	a1,0x80007
800034c8:	80006537          	lui	a0,0x80006
800034cc:	9d458593          	addi	a1,a1,-1580 # 800069d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069d5>
800034d0:	22100693          	li	a3,545
800034d4:	9fc40613          	addi	a2,s0,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
800034d8:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800034dc:	cd3fe0ef          	jal	ra,800021ae <printk>
800034e0:	80006537          	lui	a0,0x80006
800034e4:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
800034e8:	cc7fe0ef          	jal	ra,800021ae <printk>
800034ec:	22100593          	li	a1,545
800034f0:	9fc40513          	addi	a0,s0,-1540
800034f4:	cd9fe0ef          	jal	ra,800021cc <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800034f8:	00092783          	lw	a5,0(s2)
800034fc:	cf8d                	beqz	a5,80003536 <k_sched_unlock+0x96>
800034fe:	80007437          	lui	s0,0x80007
80003502:	800075b7          	lui	a1,0x80007
80003506:	80006537          	lui	a0,0x80006
8000350a:	99458593          	addi	a1,a1,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
8000350e:	22200693          	li	a3,546
80003512:	9fc40613          	addi	a2,s0,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80003516:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000351a:	c95fe0ef          	jal	ra,800021ae <printk>
8000351e:	80006537          	lui	a0,0x80006
80003522:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80003526:	c89fe0ef          	jal	ra,800021ae <printk>
8000352a:	22200593          	li	a1,546
8000352e:	9fc40513          	addi	a0,s0,-1540
80003532:	c9bfe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003536:	4421                	li	s0,8
80003538:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000353c:	800074b7          	lui	s1,0x80007
80003540:	ebc48513          	addi	a0,s1,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003544:	8821                	andi	s0,s0,8
80003546:	27e010ef          	jal	ra,800047c4 <z_spin_lock_valid>
8000354a:	ed0d                	bnez	a0,80003584 <k_sched_unlock+0xe4>
8000354c:	800069b7          	lui	s3,0x80006
80003550:	800065b7          	lui	a1,0x80006
80003554:	80006537          	lui	a0,0x80006
80003558:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
8000355c:	04e00693          	li	a3,78
80003560:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003564:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003568:	c47fe0ef          	jal	ra,800021ae <printk>
8000356c:	80006537          	lui	a0,0x80006
80003570:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003574:	c3bfe0ef          	jal	ra,800021ae <printk>
80003578:	04e00593          	li	a1,78
8000357c:	79498513          	addi	a0,s3,1940
80003580:	c4dfe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80003584:	ebc48513          	addi	a0,s1,-324
80003588:	278010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
8000358c:	00892703          	lw	a4,8(s2)
		update_cache(1);
80003590:	4505                	li	a0,1
		++_current->base.sched_locked;
80003592:	00f74783          	lbu	a5,15(a4)
80003596:	0785                	addi	a5,a5,1
80003598:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
8000359c:	e6fff0ef          	jal	ra,8000340a <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800035a0:	ebc48513          	addi	a0,s1,-324
800035a4:	23a010ef          	jal	ra,800047de <z_spin_unlock_valid>
800035a8:	ed0d                	bnez	a0,800035e2 <k_sched_unlock+0x142>
800035aa:	800064b7          	lui	s1,0x80006
800035ae:	800065b7          	lui	a1,0x80006
800035b2:	80006537          	lui	a0,0x80006
800035b6:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800035ba:	06100693          	li	a3,97
800035be:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800035c2:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800035c6:	be9fe0ef          	jal	ra,800021ae <printk>
800035ca:	80006537          	lui	a0,0x80006
800035ce:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800035d2:	bddfe0ef          	jal	ra,800021ae <printk>
800035d6:	06100593          	li	a1,97
800035da:	79448513          	addi	a0,s1,1940
800035de:	beffe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800035e2:	30042473          	csrrs	s0,mstatus,s0
}
800035e6:	4462                	lw	s0,24(sp)
800035e8:	40f2                	lw	ra,28(sp)
800035ea:	44d2                	lw	s1,20(sp)
800035ec:	4942                	lw	s2,16(sp)
800035ee:	49b2                	lw	s3,12(sp)
800035f0:	6105                	addi	sp,sp,32
	z_reschedule_unlocked();
800035f2:	b7fff06f          	j	80003170 <z_reschedule_unlocked>

800035f6 <z_add_thread_to_ready_q>:
{
800035f6:	1101                	addi	sp,sp,-32
800035f8:	cc22                	sw	s0,24(sp)
800035fa:	ca26                	sw	s1,20(sp)
800035fc:	ce06                	sw	ra,28(sp)
800035fe:	c84a                	sw	s2,16(sp)
80003600:	c64e                	sw	s3,12(sp)
80003602:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003604:	44a1                	li	s1,8
80003606:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000360a:	80007937          	lui	s2,0x80007
8000360e:	ebc90513          	addi	a0,s2,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003612:	88a1                	andi	s1,s1,8
80003614:	1b0010ef          	jal	ra,800047c4 <z_spin_lock_valid>
80003618:	ed0d                	bnez	a0,80003652 <z_add_thread_to_ready_q+0x5c>
8000361a:	800069b7          	lui	s3,0x80006
8000361e:	800065b7          	lui	a1,0x80006
80003622:	80006537          	lui	a0,0x80006
80003626:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
8000362a:	04e00693          	li	a3,78
8000362e:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003632:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003636:	b79fe0ef          	jal	ra,800021ae <printk>
8000363a:	80006537          	lui	a0,0x80006
8000363e:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003642:	b6dfe0ef          	jal	ra,800021ae <printk>
80003646:	04e00593          	li	a1,78
8000364a:	79498513          	addi	a0,s3,1940
8000364e:	b7ffe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80003652:	ebc90513          	addi	a0,s2,-324
80003656:	1aa010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	return thread == _idle_thread;
8000365a:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
8000365e:	e487a783          	lw	a5,-440(a5) # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
80003662:	02f41863          	bne	s0,a5,80003692 <z_add_thread_to_ready_q+0x9c>
80003666:	800079b7          	lui	s3,0x80007
8000366a:	800075b7          	lui	a1,0x80007
8000366e:	80006537          	lui	a0,0x80006
80003672:	b1458593          	addi	a1,a1,-1260 # 80006b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b15>
80003676:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000367a:	27600693          	li	a3,630
8000367e:	9fc98613          	addi	a2,s3,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80003682:	b2dfe0ef          	jal	ra,800021ae <printk>
80003686:	27600593          	li	a1,630
8000368a:	9fc98513          	addi	a0,s3,-1540
8000368e:	b3ffe0ef          	jal	ra,800021cc <assert_post_action>
	return list->head == list;
80003692:	80007737          	lui	a4,0x80007
80003696:	50c70693          	addi	a3,a4,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
8000369a:	52dc                	lw	a5,36(a3)
8000369c:	5690                	lw	a2,40(a3)
8000369e:	800076b7          	lui	a3,0x80007
800036a2:	53068693          	addi	a3,a3,1328 # 80007530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007531>
800036a6:	50c70713          	addi	a4,a4,1292
	return sys_dlist_is_empty(list) ? NULL : list->head;
800036aa:	08d78563          	beq	a5,a3,80003734 <z_add_thread_to_ready_q+0x13e>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800036ae:	c3d9                	beqz	a5,80003734 <z_add_thread_to_ready_q+0x13e>
	if (t1->base.prio < t2->base.prio) {
800036b0:	00e40583          	lb	a1,14(s0)
800036b4:	00e78503          	lb	a0,14(a5)
800036b8:	06a5da63          	bge	a1,a0,8000372c <z_add_thread_to_ready_q+0x136>
	node->prev = successor->prev;
800036bc:	43d8                	lw	a4,4(a5)
	node->next = successor;
800036be:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
800036c0:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
800036c2:	c300                	sw	s0,0(a4)
	successor->prev = node;
800036c4:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
800036c6:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
800036ca:	4501                	li	a0,0
800036cc:	0407e793          	ori	a5,a5,64
800036d0:	00f406a3          	sb	a5,13(s0)
800036d4:	d37ff0ef          	jal	ra,8000340a <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800036d8:	ebc90513          	addi	a0,s2,-324
800036dc:	102010ef          	jal	ra,800047de <z_spin_unlock_valid>
800036e0:	ed0d                	bnez	a0,8000371a <z_add_thread_to_ready_q+0x124>
800036e2:	80006437          	lui	s0,0x80006
800036e6:	800065b7          	lui	a1,0x80006
800036ea:	80006537          	lui	a0,0x80006
800036ee:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800036f2:	06100693          	li	a3,97
800036f6:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800036fa:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800036fe:	ab1fe0ef          	jal	ra,800021ae <printk>
80003702:	80006537          	lui	a0,0x80006
80003706:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
8000370a:	aa5fe0ef          	jal	ra,800021ae <printk>
8000370e:	06100593          	li	a1,97
80003712:	79440513          	addi	a0,s0,1940
80003716:	ab7fe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000371a:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000371e:	40f2                	lw	ra,28(sp)
80003720:	4462                	lw	s0,24(sp)
80003722:	44d2                	lw	s1,20(sp)
80003724:	4942                	lw	s2,16(sp)
80003726:	49b2                	lw	s3,12(sp)
80003728:	6105                	addi	sp,sp,32
8000372a:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
8000372c:	00f60463          	beq	a2,a5,80003734 <z_add_thread_to_ready_q+0x13e>
80003730:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003732:	f3c9                	bnez	a5,800036b4 <z_add_thread_to_ready_q+0xbe>
	node->prev = list->tail;
80003734:	c050                	sw	a2,4(s0)
	list->tail->next = node;
80003736:	571c                	lw	a5,40(a4)
	node->next = list;
80003738:	c014                	sw	a3,0(s0)
	list->tail->next = node;
8000373a:	c380                	sw	s0,0(a5)
	list->tail = node;
8000373c:	d700                	sw	s0,40(a4)
8000373e:	b761                	j	800036c6 <z_add_thread_to_ready_q+0xd0>

80003740 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80003740:	ff052783          	lw	a5,-16(a0)
{
80003744:	1101                	addi	sp,sp,-32
80003746:	cc22                	sw	s0,24(sp)
80003748:	c64e                	sw	s3,12(sp)
8000374a:	ce06                	sw	ra,28(sp)
8000374c:	ca26                	sw	s1,20(sp)
8000374e:	c84a                	sw	s2,16(sp)
80003750:	c452                	sw	s4,8(sp)
80003752:	842a                	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80003754:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003758:	cfcd                	beqz	a5,80003812 <z_thread_timeout+0xd2>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000375a:	44a1                	li	s1,8
8000375c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003760:	80007937          	lui	s2,0x80007
80003764:	ebc90513          	addi	a0,s2,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003768:	88a1                	andi	s1,s1,8
8000376a:	05a010ef          	jal	ra,800047c4 <z_spin_lock_valid>
8000376e:	ed0d                	bnez	a0,800037a8 <z_thread_timeout+0x68>
80003770:	80006a37          	lui	s4,0x80006
80003774:	800065b7          	lui	a1,0x80006
80003778:	80006537          	lui	a0,0x80006
8000377c:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80003780:	04e00693          	li	a3,78
80003784:	794a0613          	addi	a2,s4,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003788:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000378c:	a23fe0ef          	jal	ra,800021ae <printk>
80003790:	80006537          	lui	a0,0x80006
80003794:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003798:	a17fe0ef          	jal	ra,800021ae <printk>
8000379c:	04e00593          	li	a1,78
800037a0:	794a0513          	addi	a0,s4,1940
800037a4:	a29fe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
800037a8:	ebc90513          	addi	a0,s2,-324
800037ac:	054010ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800037b0:	ff040513          	addi	a0,s0,-16
800037b4:	efeff0ef          	jal	ra,80002eb2 <pended_on.isra.15>
800037b8:	85ce                	mv	a1,s3
800037ba:	b11ff0ef          	jal	ra,800032ca <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800037be:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800037c2:	ebc90513          	addi	a0,s2,-324
800037c6:	9bf5                	andi	a5,a5,-3
800037c8:	fef40aa3          	sb	a5,-11(s0)
800037cc:	012010ef          	jal	ra,800047de <z_spin_unlock_valid>
800037d0:	ed0d                	bnez	a0,8000380a <z_thread_timeout+0xca>
800037d2:	80006937          	lui	s2,0x80006
800037d6:	800065b7          	lui	a1,0x80006
800037da:	80006537          	lui	a0,0x80006
800037de:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800037e2:	06100693          	li	a3,97
800037e6:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800037ea:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800037ee:	9c1fe0ef          	jal	ra,800021ae <printk>
800037f2:	80006537          	lui	a0,0x80006
800037f6:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800037fa:	9b5fe0ef          	jal	ra,800021ae <printk>
800037fe:	06100593          	li	a1,97
80003802:	79490513          	addi	a0,s2,1940
80003806:	9c7fe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000380a:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
8000380e:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003812:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003816:	854e                	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003818:	9bad                	andi	a5,a5,-21
8000381a:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
8000381e:	e5aff0ef          	jal	ra,80002e78 <z_is_thread_ready>
80003822:	c919                	beqz	a0,80003838 <z_thread_timeout+0xf8>
}
80003824:	4462                	lw	s0,24(sp)
80003826:	40f2                	lw	ra,28(sp)
80003828:	44d2                	lw	s1,20(sp)
8000382a:	4942                	lw	s2,16(sp)
8000382c:	4a22                	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
8000382e:	854e                	mv	a0,s3
80003830:	49b2                	lw	s3,12(sp)
80003832:	6105                	addi	sp,sp,32
80003834:	dc3ff06f          	j	800035f6 <z_add_thread_to_ready_q>
80003838:	40f2                	lw	ra,28(sp)
8000383a:	4462                	lw	s0,24(sp)
8000383c:	44d2                	lw	s1,20(sp)
8000383e:	4942                	lw	s2,16(sp)
80003840:	49b2                	lw	s3,12(sp)
80003842:	4a22                	lw	s4,8(sp)
80003844:	6105                	addi	sp,sp,32
80003846:	8082                	ret

80003848 <z_move_thread_to_end_of_prio_q>:
{
80003848:	1101                	addi	sp,sp,-32
8000384a:	cc22                	sw	s0,24(sp)
8000384c:	c84a                	sw	s2,16(sp)
8000384e:	ce06                	sw	ra,28(sp)
80003850:	ca26                	sw	s1,20(sp)
80003852:	c64e                	sw	s3,12(sp)
80003854:	c452                	sw	s4,8(sp)
80003856:	c256                	sw	s5,4(sp)
80003858:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000385a:	4921                	li	s2,8
8000385c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003860:	800079b7          	lui	s3,0x80007
80003864:	ebc98513          	addi	a0,s3,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003868:	00897913          	andi	s2,s2,8
8000386c:	759000ef          	jal	ra,800047c4 <z_spin_lock_valid>
80003870:	ed0d                	bnez	a0,800038aa <z_move_thread_to_end_of_prio_q+0x62>
80003872:	800064b7          	lui	s1,0x80006
80003876:	800065b7          	lui	a1,0x80006
8000387a:	80006537          	lui	a0,0x80006
8000387e:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80003882:	04e00693          	li	a3,78
80003886:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
8000388a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000388e:	921fe0ef          	jal	ra,800021ae <printk>
80003892:	80006537          	lui	a0,0x80006
80003896:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
8000389a:	915fe0ef          	jal	ra,800021ae <printk>
8000389e:	04e00593          	li	a1,78
800038a2:	79448513          	addi	a0,s1,1940
800038a6:	927fe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
800038aa:	ebc98513          	addi	a0,s3,-324
800038ae:	753000ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800038b2:	800074b7          	lui	s1,0x80007
800038b6:	50c48513          	addi	a0,s1,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
800038ba:	85a2                	mv	a1,s0
800038bc:	02450513          	addi	a0,a0,36
800038c0:	a0bff0ef          	jal	ra,800032ca <z_priq_dumb_remove>
	return thread == _idle_thread;
800038c4:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
800038c8:	e487a783          	lw	a5,-440(a5) # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
800038cc:	80007a37          	lui	s4,0x80007
800038d0:	50c48493          	addi	s1,s1,1292
800038d4:	530a0a13          	addi	s4,s4,1328 # 80007530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007531>
800038d8:	02f41863          	bne	s0,a5,80003908 <z_move_thread_to_end_of_prio_q+0xc0>
800038dc:	80007ab7          	lui	s5,0x80007
800038e0:	800075b7          	lui	a1,0x80007
800038e4:	80006537          	lui	a0,0x80006
800038e8:	b1458593          	addi	a1,a1,-1260 # 80006b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b15>
800038ec:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800038f0:	27600693          	li	a3,630
800038f4:	9fca8613          	addi	a2,s5,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
800038f8:	8b7fe0ef          	jal	ra,800021ae <printk>
800038fc:	27600593          	li	a1,630
80003900:	9fca8513          	addi	a0,s5,-1540
80003904:	8c9fe0ef          	jal	ra,800021cc <assert_post_action>
	return list->head == list;
80003908:	50dc                	lw	a5,36(s1)
8000390a:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000390c:	09478a63          	beq	a5,s4,800039a0 <z_move_thread_to_end_of_prio_q+0x158>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003910:	cbc1                	beqz	a5,800039a0 <z_move_thread_to_end_of_prio_q+0x158>
	if (t1->base.prio < t2->base.prio) {
80003912:	00e40683          	lb	a3,14(s0)
80003916:	00e78603          	lb	a2,14(a5)
8000391a:	06c6df63          	bge	a3,a2,80003998 <z_move_thread_to_end_of_prio_q+0x150>
	node->prev = successor->prev;
8000391e:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003920:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80003922:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80003924:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003926:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003928:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
8000392c:	4488                	lw	a0,8(s1)
8000392e:	0407e793          	ori	a5,a5,64
80003932:	8d01                	sub	a0,a0,s0
80003934:	00153513          	seqz	a0,a0
80003938:	00f406a3          	sb	a5,13(s0)
8000393c:	acfff0ef          	jal	ra,8000340a <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003940:	ebc98513          	addi	a0,s3,-324
80003944:	69b000ef          	jal	ra,800047de <z_spin_unlock_valid>
80003948:	ed0d                	bnez	a0,80003982 <z_move_thread_to_end_of_prio_q+0x13a>
8000394a:	80006437          	lui	s0,0x80006
8000394e:	800065b7          	lui	a1,0x80006
80003952:	80006537          	lui	a0,0x80006
80003956:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000395a:	06100693          	li	a3,97
8000395e:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003962:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003966:	849fe0ef          	jal	ra,800021ae <printk>
8000396a:	80006537          	lui	a0,0x80006
8000396e:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80003972:	83dfe0ef          	jal	ra,800021ae <printk>
80003976:	06100593          	li	a1,97
8000397a:	79440513          	addi	a0,s0,1940
8000397e:	84ffe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003982:	30092973          	csrrs	s2,mstatus,s2
}
80003986:	40f2                	lw	ra,28(sp)
80003988:	4462                	lw	s0,24(sp)
8000398a:	44d2                	lw	s1,20(sp)
8000398c:	4942                	lw	s2,16(sp)
8000398e:	49b2                	lw	s3,12(sp)
80003990:	4a22                	lw	s4,8(sp)
80003992:	4a92                	lw	s5,4(sp)
80003994:	6105                	addi	sp,sp,32
80003996:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
80003998:	00e78463          	beq	a5,a4,800039a0 <z_move_thread_to_end_of_prio_q+0x158>
8000399c:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000399e:	ffa5                	bnez	a5,80003916 <z_move_thread_to_end_of_prio_q+0xce>
	node->prev = list->tail;
800039a0:	c058                	sw	a4,4(s0)
	list->tail->next = node;
800039a2:	549c                	lw	a5,40(s1)
	node->next = list;
800039a4:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800039a8:	c380                	sw	s0,0(a5)
	list->tail = node;
800039aa:	d480                	sw	s0,40(s1)
800039ac:	bfb5                	j	80003928 <z_move_thread_to_end_of_prio_q+0xe0>

800039ae <z_time_slice>:
	if (slice_time && sliceable(_current)) {
800039ae:	800077b7          	lui	a5,0x80007
800039b2:	ec47a783          	lw	a5,-316(a5) # 80006ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec5>
800039b6:	cbb1                	beqz	a5,80003a0a <z_time_slice+0x5c>
800039b8:	800077b7          	lui	a5,0x80007
800039bc:	50c78793          	addi	a5,a5,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
800039c0:	4798                	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
800039c2:	07f00693          	li	a3,127
800039c6:	00e75603          	lhu	a2,14(a4)
800039ca:	04c6e063          	bltu	a3,a2,80003a0a <z_time_slice+0x5c>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
800039ce:	800076b7          	lui	a3,0x80007
800039d2:	00e70603          	lb	a2,14(a4)
800039d6:	ec06a683          	lw	a3,-320(a3) # 80006ec0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec1>
800039da:	02d64863          	blt	a2,a3,80003a0a <z_time_slice+0x5c>
	return thread == _idle_thread;
800039de:	800076b7          	lui	a3,0x80007
		&& !is_idle(t)
800039e2:	e486a683          	lw	a3,-440(a3) # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
800039e6:	02d70263          	beq	a4,a3,80003a0a <z_time_slice+0x5c>
		&& !z_is_thread_timeout_active(t);
800039ea:	4f14                	lw	a3,24(a4)
800039ec:	ee99                	bnez	a3,80003a0a <z_time_slice+0x5c>
		if (ticks >= _current_cpu->slice_ticks) {
800039ee:	4b94                	lw	a3,16(a5)
800039f0:	00d54b63          	blt	a0,a3,80003a06 <z_time_slice+0x58>
{
800039f4:	1141                	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
800039f6:	853a                	mv	a0,a4
{
800039f8:	c606                	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
800039fa:	e4fff0ef          	jal	ra,80003848 <z_move_thread_to_end_of_prio_q>
}
800039fe:	40b2                	lw	ra,12(sp)
80003a00:	0141                	addi	sp,sp,16
			reset_time_slice();
80003a02:	c8aff06f          	j	80002e8c <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003a06:	8e89                	sub	a3,a3,a0
80003a08:	cb94                	sw	a3,16(a5)
80003a0a:	8082                	ret

80003a0c <z_remove_thread_from_ready_q>:
{
80003a0c:	1101                	addi	sp,sp,-32
80003a0e:	cc22                	sw	s0,24(sp)
80003a10:	c64e                	sw	s3,12(sp)
80003a12:	ce06                	sw	ra,28(sp)
80003a14:	ca26                	sw	s1,20(sp)
80003a16:	c84a                	sw	s2,16(sp)
80003a18:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003a1a:	4421                	li	s0,8
80003a1c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a20:	800074b7          	lui	s1,0x80007
80003a24:	ebc48513          	addi	a0,s1,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a28:	8821                	andi	s0,s0,8
80003a2a:	59b000ef          	jal	ra,800047c4 <z_spin_lock_valid>
80003a2e:	ed0d                	bnez	a0,80003a68 <z_remove_thread_from_ready_q+0x5c>
80003a30:	80006937          	lui	s2,0x80006
80003a34:	800065b7          	lui	a1,0x80006
80003a38:	80006537          	lui	a0,0x80006
80003a3c:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80003a40:	04e00693          	li	a3,78
80003a44:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003a48:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003a4c:	f62fe0ef          	jal	ra,800021ae <printk>
80003a50:	80006537          	lui	a0,0x80006
80003a54:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003a58:	f56fe0ef          	jal	ra,800021ae <printk>
80003a5c:	04e00593          	li	a1,78
80003a60:	79490513          	addi	a0,s2,1940
80003a64:	f68fe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80003a68:	ebc48513          	addi	a0,s1,-324
80003a6c:	595000ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003a70:	00d9c783          	lbu	a5,13(s3)
80003a74:	80007937          	lui	s2,0x80007
80003a78:	50c90913          	addi	s2,s2,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
80003a7c:	0407f793          	andi	a5,a5,64
80003a80:	cf81                	beqz	a5,80003a98 <z_remove_thread_from_ready_q+0x8c>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003a82:	85ce                	mv	a1,s3
80003a84:	02490513          	addi	a0,s2,36
80003a88:	843ff0ef          	jal	ra,800032ca <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80003a8c:	00d9c783          	lbu	a5,13(s3)
80003a90:	fbf7f793          	andi	a5,a5,-65
80003a94:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003a98:	00892503          	lw	a0,8(s2)
80003a9c:	41350533          	sub	a0,a0,s3
80003aa0:	00153513          	seqz	a0,a0
80003aa4:	967ff0ef          	jal	ra,8000340a <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003aa8:	ebc48513          	addi	a0,s1,-324
80003aac:	533000ef          	jal	ra,800047de <z_spin_unlock_valid>
80003ab0:	ed0d                	bnez	a0,80003aea <z_remove_thread_from_ready_q+0xde>
80003ab2:	800064b7          	lui	s1,0x80006
80003ab6:	800065b7          	lui	a1,0x80006
80003aba:	80006537          	lui	a0,0x80006
80003abe:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003ac2:	06100693          	li	a3,97
80003ac6:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003aca:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003ace:	ee0fe0ef          	jal	ra,800021ae <printk>
80003ad2:	80006537          	lui	a0,0x80006
80003ad6:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80003ada:	ed4fe0ef          	jal	ra,800021ae <printk>
80003ade:	06100593          	li	a1,97
80003ae2:	79448513          	addi	a0,s1,1940
80003ae6:	ee6fe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003aea:	30042473          	csrrs	s0,mstatus,s0
}
80003aee:	40f2                	lw	ra,28(sp)
80003af0:	4462                	lw	s0,24(sp)
80003af2:	44d2                	lw	s1,20(sp)
80003af4:	4942                	lw	s2,16(sp)
80003af6:	49b2                	lw	s3,12(sp)
80003af8:	6105                	addi	sp,sp,32
80003afa:	8082                	ret

80003afc <pend>:
{
80003afc:	1101                	addi	sp,sp,-32
80003afe:	cc22                	sw	s0,24(sp)
80003b00:	ca26                	sw	s1,20(sp)
80003b02:	842a                	mv	s0,a0
80003b04:	c84a                	sw	s2,16(sp)
80003b06:	ce06                	sw	ra,28(sp)
80003b08:	c64e                	sw	s3,12(sp)
80003b0a:	84ae                	mv	s1,a1
80003b0c:	8932                	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003b0e:	effff0ef          	jal	ra,80003a0c <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003b12:	00d44783          	lbu	a5,13(s0)
80003b16:	0027e793          	ori	a5,a5,2
80003b1a:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003b1e:	cca9                	beqz	s1,80003b78 <pend+0x7c>
	return thread == _idle_thread;
80003b20:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003b24:	e487a783          	lw	a5,-440(a5) # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
		thread->base.pended_on = wait_q;
80003b28:	c404                	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003b2a:	02f41863          	bne	s0,a5,80003b5a <pend+0x5e>
80003b2e:	800079b7          	lui	s3,0x80007
80003b32:	800075b7          	lui	a1,0x80007
80003b36:	80006537          	lui	a0,0x80006
80003b3a:	b1458593          	addi	a1,a1,-1260 # 80006b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b15>
80003b3e:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003b42:	27600693          	li	a3,630
80003b46:	9fc98613          	addi	a2,s3,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80003b4a:	e64fe0ef          	jal	ra,800021ae <printk>
80003b4e:	27600593          	li	a1,630
80003b52:	9fc98513          	addi	a0,s3,-1540
80003b56:	e76fe0ef          	jal	ra,800021cc <assert_post_action>
	return list->head == list;
80003b5a:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003b5c:	04f48b63          	beq	s1,a5,80003bb2 <pend+0xb6>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003b60:	cba9                	beqz	a5,80003bb2 <pend+0xb6>
	if (t1->base.prio < t2->base.prio) {
80003b62:	00e40703          	lb	a4,14(s0)
80003b66:	00e78683          	lb	a3,14(a5)
80003b6a:	02d75f63          	bge	a4,a3,80003ba8 <pend+0xac>
	node->prev = successor->prev;
80003b6e:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003b70:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80003b72:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80003b74:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003b76:	c3c0                	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003b78:	57fd                	li	a5,-1
80003b7a:	04f90363          	beq	s2,a5,80003bc0 <pend+0xc4>
80003b7e:	45a9                	li	a1,10
80003b80:	00990513          	addi	a0,s2,9
80003b84:	d5dfc0ef          	jal	ra,800008e0 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003b88:	00150613          	addi	a2,a0,1
80003b8c:	01840513          	addi	a0,s0,24
}
80003b90:	4462                	lw	s0,24(sp)
80003b92:	40f2                	lw	ra,28(sp)
80003b94:	44d2                	lw	s1,20(sp)
80003b96:	4942                	lw	s2,16(sp)
80003b98:	49b2                	lw	s3,12(sp)
80003b9a:	800035b7          	lui	a1,0x80003
80003b9e:	74058593          	addi	a1,a1,1856 # 80003740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003741>
80003ba2:	6105                	addi	sp,sp,32
80003ba4:	7f50006f          	j	80004b98 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003ba8:	40d4                	lw	a3,4(s1)
80003baa:	00d78463          	beq	a5,a3,80003bb2 <pend+0xb6>
80003bae:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003bb0:	fbdd                	bnez	a5,80003b66 <pend+0x6a>
	node->prev = list->tail;
80003bb2:	40dc                	lw	a5,4(s1)
	node->next = list;
80003bb4:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80003bb6:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80003bb8:	40dc                	lw	a5,4(s1)
80003bba:	c380                	sw	s0,0(a5)
	list->tail = node;
80003bbc:	c0c0                	sw	s0,4(s1)
80003bbe:	bf6d                	j	80003b78 <pend+0x7c>
}
80003bc0:	40f2                	lw	ra,28(sp)
80003bc2:	4462                	lw	s0,24(sp)
80003bc4:	44d2                	lw	s1,20(sp)
80003bc6:	4942                	lw	s2,16(sp)
80003bc8:	49b2                	lw	s3,12(sp)
80003bca:	6105                	addi	sp,sp,32
80003bcc:	8082                	ret

80003bce <z_pend_curr_irqlock>:
{
80003bce:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003bd0:	800077b7          	lui	a5,0x80007
{
80003bd4:	c422                	sw	s0,8(sp)
80003bd6:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80003bd8:	5147a503          	lw	a0,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
{
80003bdc:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003bde:	f1fff0ef          	jal	ra,80003afc <pend>
80003be2:	8522                	mv	a0,s0
}
80003be4:	4422                	lw	s0,8(sp)
80003be6:	40b2                	lw	ra,12(sp)
80003be8:	0141                	addi	sp,sp,16
80003bea:	de6fc06f          	j	800001d0 <__swap>

80003bee <z_pend_curr>:
{
80003bee:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003bf0:	800077b7          	lui	a5,0x80007
{
80003bf4:	c422                	sw	s0,8(sp)
80003bf6:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80003bf8:	5147a503          	lw	a0,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
{
80003bfc:	c226                	sw	s1,4(sp)
80003bfe:	84ae                	mv	s1,a1
80003c00:	85b2                	mv	a1,a2
	pend(_current, wait_q, timeout);
80003c02:	8636                	mv	a2,a3
{
80003c04:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003c06:	ef7ff0ef          	jal	ra,80003afc <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003c0a:	8522                	mv	a0,s0
80003c0c:	3d3000ef          	jal	ra,800047de <z_spin_unlock_valid>
80003c10:	ed0d                	bnez	a0,80003c4a <z_pend_curr+0x5c>
80003c12:	80006437          	lui	s0,0x80006
80003c16:	800065b7          	lui	a1,0x80006
80003c1a:	80006537          	lui	a0,0x80006
80003c1e:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003c22:	07800693          	li	a3,120
80003c26:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003c2a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003c2e:	d80fe0ef          	jal	ra,800021ae <printk>
80003c32:	80006537          	lui	a0,0x80006
80003c36:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80003c3a:	d74fe0ef          	jal	ra,800021ae <printk>
80003c3e:	07800593          	li	a1,120
80003c42:	79440513          	addi	a0,s0,1940
80003c46:	d86fe0ef          	jal	ra,800021cc <assert_post_action>
}
80003c4a:	4422                	lw	s0,8(sp)
80003c4c:	40b2                	lw	ra,12(sp)
80003c4e:	8526                	mv	a0,s1
80003c50:	4492                	lw	s1,4(sp)
80003c52:	0141                	addi	sp,sp,16
80003c54:	d7cfc06f          	j	800001d0 <__swap>

80003c58 <z_thread_priority_set>:
{
80003c58:	1101                	addi	sp,sp,-32
80003c5a:	cc22                	sw	s0,24(sp)
80003c5c:	c84a                	sw	s2,16(sp)
80003c5e:	c452                	sw	s4,8(sp)
80003c60:	ce06                	sw	ra,28(sp)
80003c62:	ca26                	sw	s1,20(sp)
80003c64:	c64e                	sw	s3,12(sp)
80003c66:	c256                	sw	s5,4(sp)
80003c68:	c05a                	sw	s6,0(sp)
80003c6a:	842a                	mv	s0,a0
80003c6c:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c6e:	4921                	li	s2,8
80003c70:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c74:	800079b7          	lui	s3,0x80007
80003c78:	ebc98513          	addi	a0,s3,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c7c:	00897913          	andi	s2,s2,8
80003c80:	345000ef          	jal	ra,800047c4 <z_spin_lock_valid>
80003c84:	ed0d                	bnez	a0,80003cbe <z_thread_priority_set+0x66>
80003c86:	800064b7          	lui	s1,0x80006
80003c8a:	800065b7          	lui	a1,0x80006
80003c8e:	80006537          	lui	a0,0x80006
80003c92:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80003c96:	04e00693          	li	a3,78
80003c9a:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003c9e:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003ca2:	d0cfe0ef          	jal	ra,800021ae <printk>
80003ca6:	80006537          	lui	a0,0x80006
80003caa:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003cae:	d00fe0ef          	jal	ra,800021ae <printk>
80003cb2:	04e00593          	li	a1,78
80003cb6:	79448513          	addi	a0,s1,1940
80003cba:	d12fe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80003cbe:	ebc98513          	addi	a0,s3,-324
80003cc2:	33f000ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		need_sched = z_is_thread_ready(thread);
80003cc6:	8522                	mv	a0,s0
80003cc8:	9b0ff0ef          	jal	ra,80002e78 <z_is_thread_ready>
80003ccc:	0a62                	slli	s4,s4,0x18
80003cce:	8aaa                	mv	s5,a0
		if (need_sched) {
80003cd0:	418a5a13          	srai	s4,s4,0x18
80003cd4:	10050463          	beqz	a0,80003ddc <z_thread_priority_set+0x184>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003cd8:	800074b7          	lui	s1,0x80007
80003cdc:	50c48513          	addi	a0,s1,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
80003ce0:	85a2                	mv	a1,s0
80003ce2:	02450513          	addi	a0,a0,36
80003ce6:	de4ff0ef          	jal	ra,800032ca <z_priq_dumb_remove>
	return thread == _idle_thread;
80003cea:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003cee:	e487a783          	lw	a5,-440(a5) # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
			thread->base.prio = prio;
80003cf2:	01440723          	sb	s4,14(s0)
	return thread == _idle_thread;
80003cf6:	80007a37          	lui	s4,0x80007
80003cfa:	50c48493          	addi	s1,s1,1292
80003cfe:	530a0a13          	addi	s4,s4,1328 # 80007530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007531>
	__ASSERT_NO_MSG(!is_idle(thread));
80003d02:	02f41863          	bne	s0,a5,80003d32 <z_thread_priority_set+0xda>
80003d06:	80007b37          	lui	s6,0x80007
80003d0a:	800075b7          	lui	a1,0x80007
80003d0e:	80006537          	lui	a0,0x80006
80003d12:	b1458593          	addi	a1,a1,-1260 # 80006b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b15>
80003d16:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003d1a:	27600693          	li	a3,630
80003d1e:	9fcb0613          	addi	a2,s6,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80003d22:	c8cfe0ef          	jal	ra,800021ae <printk>
80003d26:	27600593          	li	a1,630
80003d2a:	9fcb0513          	addi	a0,s6,-1540
80003d2e:	c9efe0ef          	jal	ra,800021cc <assert_post_action>
	return list->head == list;
80003d32:	50dc                	lw	a5,36(s1)
80003d34:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003d36:	09478c63          	beq	a5,s4,80003dce <z_thread_priority_set+0x176>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003d3a:	cbd1                	beqz	a5,80003dce <z_thread_priority_set+0x176>
	if (t1->base.prio < t2->base.prio) {
80003d3c:	00e40683          	lb	a3,14(s0)
80003d40:	00e78603          	lb	a2,14(a5)
80003d44:	08c6d163          	bge	a3,a2,80003dc6 <z_thread_priority_set+0x16e>
	node->prev = successor->prev;
80003d48:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003d4a:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80003d4c:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80003d4e:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003d50:	c3c0                	sw	s0,4(a5)
			update_cache(1);
80003d52:	4505                	li	a0,1
80003d54:	eb6ff0ef          	jal	ra,8000340a <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003d58:	ebc98513          	addi	a0,s3,-324
80003d5c:	283000ef          	jal	ra,800047de <z_spin_unlock_valid>
80003d60:	ed0d                	bnez	a0,80003d9a <z_thread_priority_set+0x142>
80003d62:	80006437          	lui	s0,0x80006
80003d66:	800065b7          	lui	a1,0x80006
80003d6a:	80006537          	lui	a0,0x80006
80003d6e:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003d72:	06100693          	li	a3,97
80003d76:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003d7a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003d7e:	c30fe0ef          	jal	ra,800021ae <printk>
80003d82:	80006537          	lui	a0,0x80006
80003d86:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80003d8a:	c24fe0ef          	jal	ra,800021ae <printk>
80003d8e:	06100593          	li	a1,97
80003d92:	79440513          	addi	a0,s0,1940
80003d96:	c36fe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003d9a:	30092973          	csrrs	s2,mstatus,s2
	if (need_sched && _current->base.sched_locked == 0) {
80003d9e:	040a8263          	beqz	s5,80003de2 <z_thread_priority_set+0x18a>
80003da2:	800077b7          	lui	a5,0x80007
80003da6:	5147a783          	lw	a5,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80003daa:	00f7c783          	lbu	a5,15(a5)
80003dae:	eb95                	bnez	a5,80003de2 <z_thread_priority_set+0x18a>
}
80003db0:	4462                	lw	s0,24(sp)
80003db2:	40f2                	lw	ra,28(sp)
80003db4:	44d2                	lw	s1,20(sp)
80003db6:	4942                	lw	s2,16(sp)
80003db8:	49b2                	lw	s3,12(sp)
80003dba:	4a22                	lw	s4,8(sp)
80003dbc:	4a92                	lw	s5,4(sp)
80003dbe:	4b02                	lw	s6,0(sp)
80003dc0:	6105                	addi	sp,sp,32
		z_reschedule_unlocked();
80003dc2:	baeff06f          	j	80003170 <z_reschedule_unlocked>
	return (node == list->tail) ? NULL : node->next;
80003dc6:	00e78463          	beq	a5,a4,80003dce <z_thread_priority_set+0x176>
80003dca:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003dcc:	fbb5                	bnez	a5,80003d40 <z_thread_priority_set+0xe8>
	node->prev = list->tail;
80003dce:	c058                	sw	a4,4(s0)
	list->tail->next = node;
80003dd0:	549c                	lw	a5,40(s1)
	node->next = list;
80003dd2:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003dd6:	c380                	sw	s0,0(a5)
	list->tail = node;
80003dd8:	d480                	sw	s0,40(s1)
80003dda:	bfa5                	j	80003d52 <z_thread_priority_set+0xfa>
			thread->base.prio = prio;
80003ddc:	01440723          	sb	s4,14(s0)
80003de0:	bfa5                	j	80003d58 <z_thread_priority_set+0x100>
}
80003de2:	40f2                	lw	ra,28(sp)
80003de4:	4462                	lw	s0,24(sp)
80003de6:	44d2                	lw	s1,20(sp)
80003de8:	4942                	lw	s2,16(sp)
80003dea:	49b2                	lw	s3,12(sp)
80003dec:	4a22                	lw	s4,8(sp)
80003dee:	4a92                	lw	s5,4(sp)
80003df0:	4b02                	lw	s6,0(sp)
80003df2:	6105                	addi	sp,sp,32
80003df4:	8082                	ret

80003df6 <z_unpend_first_thread>:
{
80003df6:	1101                	addi	sp,sp,-32
80003df8:	c84a                	sw	s2,16(sp)
80003dfa:	c64e                	sw	s3,12(sp)
80003dfc:	ce06                	sw	ra,28(sp)
80003dfe:	cc22                	sw	s0,24(sp)
80003e00:	ca26                	sw	s1,20(sp)
80003e02:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e04:	4921                	li	s2,8
80003e06:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e0a:	800074b7          	lui	s1,0x80007
80003e0e:	ebc48513          	addi	a0,s1,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e12:	00897913          	andi	s2,s2,8
80003e16:	1af000ef          	jal	ra,800047c4 <z_spin_lock_valid>
80003e1a:	ed0d                	bnez	a0,80003e54 <z_unpend_first_thread+0x5e>
80003e1c:	80006437          	lui	s0,0x80006
80003e20:	800065b7          	lui	a1,0x80006
80003e24:	80006537          	lui	a0,0x80006
80003e28:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80003e2c:	04e00693          	li	a3,78
80003e30:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003e34:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003e38:	b76fe0ef          	jal	ra,800021ae <printk>
80003e3c:	80006537          	lui	a0,0x80006
80003e40:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003e44:	b6afe0ef          	jal	ra,800021ae <printk>
80003e48:	04e00593          	li	a1,78
80003e4c:	79440513          	addi	a0,s0,1940
80003e50:	b7cfe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80003e54:	ebc48513          	addi	a0,s1,-324
80003e58:	1a9000ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80003e5c:	854e                	mv	a0,s3
80003e5e:	da0ff0ef          	jal	ra,800033fe <z_priq_dumb_best>
80003e62:	842a                	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003e64:	ebc48513          	addi	a0,s1,-324
80003e68:	177000ef          	jal	ra,800047de <z_spin_unlock_valid>
80003e6c:	ed0d                	bnez	a0,80003ea6 <z_unpend_first_thread+0xb0>
80003e6e:	800069b7          	lui	s3,0x80006
80003e72:	800065b7          	lui	a1,0x80006
80003e76:	80006537          	lui	a0,0x80006
80003e7a:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003e7e:	06100693          	li	a3,97
80003e82:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003e86:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003e8a:	b24fe0ef          	jal	ra,800021ae <printk>
80003e8e:	80006537          	lui	a0,0x80006
80003e92:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80003e96:	b18fe0ef          	jal	ra,800021ae <printk>
80003e9a:	06100593          	li	a1,97
80003e9e:	79498513          	addi	a0,s3,1940
80003ea2:	b2afe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003ea6:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80003eaa:	c061                	beqz	s0,80003f6a <z_unpend_first_thread+0x174>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003eac:	4921                	li	s2,8
80003eae:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003eb2:	ebc48513          	addi	a0,s1,-324
	key = (mstatus & SOC_MSTATUS_IEN);
80003eb6:	00897913          	andi	s2,s2,8
80003eba:	10b000ef          	jal	ra,800047c4 <z_spin_lock_valid>
80003ebe:	ed0d                	bnez	a0,80003ef8 <z_unpend_first_thread+0x102>
80003ec0:	800069b7          	lui	s3,0x80006
80003ec4:	800065b7          	lui	a1,0x80006
80003ec8:	80006537          	lui	a0,0x80006
80003ecc:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80003ed0:	04e00693          	li	a3,78
80003ed4:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003ed8:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003edc:	ad2fe0ef          	jal	ra,800021ae <printk>
80003ee0:	80006537          	lui	a0,0x80006
80003ee4:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80003ee8:	ac6fe0ef          	jal	ra,800021ae <printk>
80003eec:	04e00593          	li	a1,78
80003ef0:	79498513          	addi	a0,s3,1940
80003ef4:	ad8fe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80003ef8:	ebc48513          	addi	a0,s1,-324
80003efc:	105000ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003f00:	00840513          	addi	a0,s0,8
80003f04:	faffe0ef          	jal	ra,80002eb2 <pended_on.isra.15>
80003f08:	85a2                	mv	a1,s0
80003f0a:	bc0ff0ef          	jal	ra,800032ca <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003f0e:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f12:	ebc48513          	addi	a0,s1,-324
80003f16:	9bf5                	andi	a5,a5,-3
80003f18:	00f406a3          	sb	a5,13(s0)
80003f1c:	0c3000ef          	jal	ra,800047de <z_spin_unlock_valid>
80003f20:	ed0d                	bnez	a0,80003f5a <z_unpend_first_thread+0x164>
80003f22:	800064b7          	lui	s1,0x80006
80003f26:	800065b7          	lui	a1,0x80006
80003f2a:	80006537          	lui	a0,0x80006
80003f2e:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80003f32:	06100693          	li	a3,97
80003f36:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80003f3a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003f3e:	a70fe0ef          	jal	ra,800021ae <printk>
80003f42:	80006537          	lui	a0,0x80006
80003f46:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80003f4a:	a64fe0ef          	jal	ra,800021ae <printk>
80003f4e:	06100593          	li	a1,97
80003f52:	79448513          	addi	a0,s1,1940
80003f56:	a76fe0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f5a:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80003f5e:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80003f62:	01840513          	addi	a0,s0,24
80003f66:	5fb000ef          	jal	ra,80004d60 <z_abort_timeout>
}
80003f6a:	8522                	mv	a0,s0
80003f6c:	40f2                	lw	ra,28(sp)
80003f6e:	4462                	lw	s0,24(sp)
80003f70:	44d2                	lw	s1,20(sp)
80003f72:	4942                	lw	s2,16(sp)
80003f74:	49b2                	lw	s3,12(sp)
80003f76:	6105                	addi	sp,sp,32
80003f78:	8082                	ret

80003f7a <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80003f7a:	1141                	addi	sp,sp,-16
80003f7c:	c226                	sw	s1,4(sp)
80003f7e:	c04a                	sw	s2,0(sp)
80003f80:	c606                	sw	ra,12(sp)
80003f82:	c422                	sw	s0,8(sp)
80003f84:	892a                	mv	s2,a0
	int need_sched = 0;
80003f86:	4481                	li	s1,0
	return list->head == list;
80003f88:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003f8c:	00890363          	beq	s2,s0,80003f92 <z_unpend_all+0x18>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80003f90:	e801                	bnez	s0,80003fa0 <z_unpend_all+0x26>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80003f92:	40b2                	lw	ra,12(sp)
80003f94:	4422                	lw	s0,8(sp)
80003f96:	8526                	mv	a0,s1
80003f98:	4902                	lw	s2,0(sp)
80003f9a:	4492                	lw	s1,4(sp)
80003f9c:	0141                	addi	sp,sp,16
80003f9e:	8082                	ret
		z_unpend_thread(th);
80003fa0:	8522                	mv	a0,s0
80003fa2:	b84ff0ef          	jal	ra,80003326 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80003fa6:	8522                	mv	a0,s0
80003fa8:	ed1fe0ef          	jal	ra,80002e78 <z_is_thread_ready>
		need_sched = 1;
80003fac:	4485                	li	s1,1
80003fae:	dd69                	beqz	a0,80003f88 <z_unpend_all+0xe>
		z_add_thread_to_ready_q(thread);
80003fb0:	8522                	mv	a0,s0
80003fb2:	e44ff0ef          	jal	ra,800035f6 <z_add_thread_to_ready_q>
80003fb6:	bfc9                	j	80003f88 <z_unpend_all+0xe>

80003fb8 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80003fb8:	800077b7          	lui	a5,0x80007
80003fbc:	50c78793          	addi	a5,a5,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
80003fc0:	02478713          	addi	a4,a5,36
80003fc4:	d3d8                	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003fc6:	d798                	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003fc8:	4581                	li	a1,0
80003fca:	4501                	li	a0,0
80003fcc:	f2dfe06f          	j	80002ef8 <k_sched_time_slice_set>

80003fd0 <z_impl_k_thread_priority_set>:
Z_SYSCALL_HANDLER1_SIMPLE(k_thread_priority_get, K_OBJ_THREAD,
			  struct k_thread *);
#endif

void z_impl_k_thread_priority_set(k_tid_t tid, int prio)
{
80003fd0:	1141                	addi	sp,sp,-16
80003fd2:	c422                	sw	s0,8(sp)
80003fd4:	c04a                	sw	s2,0(sp)
80003fd6:	c606                	sw	ra,12(sp)
80003fd8:	c226                	sw	s1,4(sp)
	/*
	 * Use NULL, since we cannot know what the entry point is (we do not
	 * keep track of it) and idle cannot change its priority.
	 */
	Z_ASSERT_VALID_PRIO(prio, NULL);
80003fda:	01058713          	addi	a4,a1,16
80003fde:	47f9                	li	a5,30
{
80003fe0:	892a                	mv	s2,a0
80003fe2:	842e                	mv	s0,a1
	Z_ASSERT_VALID_PRIO(prio, NULL);
80003fe4:	04e7f163          	bgeu	a5,a4,80004026 <z_impl_k_thread_priority_set+0x56>
80003fe8:	800074b7          	lui	s1,0x80007
80003fec:	800075b7          	lui	a1,0x80007
80003ff0:	80006537          	lui	a0,0x80006
80003ff4:	34500693          	li	a3,837
80003ff8:	9fc48613          	addi	a2,s1,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80003ffc:	a9458593          	addi	a1,a1,-1388 # 80006a94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a95>
80004000:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004004:	9aafe0ef          	jal	ra,800021ae <printk>
80004008:	80006537          	lui	a0,0x80006
8000400c:	85a2                	mv	a1,s0
8000400e:	6e850513          	addi	a0,a0,1768 # 800066e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066e9>
80004012:	56c1                	li	a3,-16
80004014:	4639                	li	a2,14
80004016:	998fe0ef          	jal	ra,800021ae <printk>
8000401a:	34500593          	li	a1,837
8000401e:	9fc48513          	addi	a0,s1,-1540
80004022:	9aafe0ef          	jal	ra,800021cc <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80004026:	800077b7          	lui	a5,0x80007
8000402a:	50c7a783          	lw	a5,1292(a5) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
8000402e:	cf8d                	beqz	a5,80004068 <z_impl_k_thread_priority_set+0x98>
80004030:	800074b7          	lui	s1,0x80007
80004034:	800075b7          	lui	a1,0x80007
80004038:	80006537          	lui	a0,0x80006
8000403c:	99458593          	addi	a1,a1,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
80004040:	34600693          	li	a3,838
80004044:	9fc48613          	addi	a2,s1,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80004048:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000404c:	962fe0ef          	jal	ra,800021ae <printk>
80004050:	80006537          	lui	a0,0x80006
80004054:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80004058:	956fe0ef          	jal	ra,800021ae <printk>
8000405c:	34600593          	li	a1,838
80004060:	9fc48513          	addi	a0,s1,-1540
80004064:	968fe0ef          	jal	ra,800021cc <assert_post_action>

	struct k_thread *thread = (struct k_thread *)tid;

	z_thread_priority_set(thread, prio);
80004068:	85a2                	mv	a1,s0
}
8000406a:	4422                	lw	s0,8(sp)
8000406c:	40b2                	lw	ra,12(sp)
8000406e:	4492                	lw	s1,4(sp)
	z_thread_priority_set(thread, prio);
80004070:	854a                	mv	a0,s2
}
80004072:	4902                	lw	s2,0(sp)
80004074:	0141                	addi	sp,sp,16
	z_thread_priority_set(thread, prio);
80004076:	be3ff06f          	j	80003c58 <z_thread_priority_set>

8000407a <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
8000407a:	1101                	addi	sp,sp,-32
8000407c:	cc22                	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
8000407e:	80007437          	lui	s0,0x80007
80004082:	50c42783          	lw	a5,1292(s0) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
{
80004086:	ce06                	sw	ra,28(sp)
80004088:	ca26                	sw	s1,20(sp)
8000408a:	c84a                	sw	s2,16(sp)
8000408c:	c64e                	sw	s3,12(sp)
8000408e:	c452                	sw	s4,8(sp)
80004090:	c256                	sw	s5,4(sp)
80004092:	50c40413          	addi	s0,s0,1292
	__ASSERT(!z_is_in_isr(), "");
80004096:	cf8d                	beqz	a5,800040d0 <z_impl_k_yield+0x56>
80004098:	800074b7          	lui	s1,0x80007
8000409c:	800075b7          	lui	a1,0x80007
800040a0:	80006537          	lui	a0,0x80006
800040a4:	99458593          	addi	a1,a1,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
800040a8:	37e00693          	li	a3,894
800040ac:	9fc48613          	addi	a2,s1,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
800040b0:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800040b4:	8fafe0ef          	jal	ra,800021ae <printk>
800040b8:	80006537          	lui	a0,0x80006
800040bc:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
800040c0:	8eefe0ef          	jal	ra,800021ae <printk>
800040c4:	37e00593          	li	a1,894
800040c8:	9fc48513          	addi	a0,s1,-1540
800040cc:	900fe0ef          	jal	ra,800021cc <assert_post_action>
	return thread == _idle_thread;
800040d0:	800077b7          	lui	a5,0x80007

	if (!is_idle(_current)) {
800040d4:	4414                	lw	a3,8(s0)
800040d6:	e487a703          	lw	a4,-440(a5) # 80006e48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e49>
800040da:	8a3e                	mv	s4,a5
800040dc:	10e68763          	beq	a3,a4,800041ea <z_impl_k_yield+0x170>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800040e0:	4921                	li	s2,8
800040e2:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800040e6:	800079b7          	lui	s3,0x80007
800040ea:	ebc98513          	addi	a0,s3,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
	key = (mstatus & SOC_MSTATUS_IEN);
800040ee:	00897913          	andi	s2,s2,8
800040f2:	6d2000ef          	jal	ra,800047c4 <z_spin_lock_valid>
800040f6:	ed0d                	bnez	a0,80004130 <z_impl_k_yield+0xb6>
800040f8:	800064b7          	lui	s1,0x80006
800040fc:	800065b7          	lui	a1,0x80006
80004100:	80006537          	lui	a0,0x80006
80004104:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80004108:	04e00693          	li	a3,78
8000410c:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004110:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004114:	89afe0ef          	jal	ra,800021ae <printk>
80004118:	80006537          	lui	a0,0x80006
8000411c:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80004120:	88efe0ef          	jal	ra,800021ae <printk>
80004124:	04e00593          	li	a1,78
80004128:	79448513          	addi	a0,s1,1940
8000412c:	8a0fe0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80004130:	ebc98513          	addi	a0,s3,-324
80004134:	6cc000ef          	jal	ra,80004800 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80004138:	440c                	lw	a1,8(s0)
8000413a:	02440513          	addi	a0,s0,36
8000413e:	98cff0ef          	jal	ra,800032ca <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80004142:	e48a2783          	lw	a5,-440(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80004146:	4404                	lw	s1,8(s0)
	return thread == _idle_thread;
80004148:	80007a37          	lui	s4,0x80007
8000414c:	530a0a13          	addi	s4,s4,1328 # 80007530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007531>
	__ASSERT_NO_MSG(!is_idle(thread));
80004150:	02f49863          	bne	s1,a5,80004180 <z_impl_k_yield+0x106>
80004154:	80007ab7          	lui	s5,0x80007
80004158:	800075b7          	lui	a1,0x80007
8000415c:	80006537          	lui	a0,0x80006
80004160:	b1458593          	addi	a1,a1,-1260 # 80006b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b15>
80004164:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004168:	27600693          	li	a3,630
8000416c:	9fca8613          	addi	a2,s5,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80004170:	83efe0ef          	jal	ra,800021ae <printk>
80004174:	27600593          	li	a1,630
80004178:	9fca8513          	addi	a0,s5,-1540
8000417c:	850fe0ef          	jal	ra,800021cc <assert_post_action>
	return list->head == list;
80004180:	505c                	lw	a5,36(s0)
80004182:	5418                	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004184:	09478563          	beq	a5,s4,8000420e <z_impl_k_yield+0x194>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004188:	c3d9                	beqz	a5,8000420e <z_impl_k_yield+0x194>
	if (t1->base.prio < t2->base.prio) {
8000418a:	00e48683          	lb	a3,14(s1)
8000418e:	00e78603          	lb	a2,14(a5)
80004192:	06c6da63          	bge	a3,a2,80004206 <z_impl_k_yield+0x18c>
	node->prev = successor->prev;
80004196:	43d8                	lw	a4,4(a5)
	node->next = successor;
80004198:	c09c                	sw	a5,0(s1)
	node->prev = successor->prev;
8000419a:	c0d8                	sw	a4,4(s1)
	successor->prev->next = node;
8000419c:	c304                	sw	s1,0(a4)
	successor->prev = node;
8000419e:	c3c4                	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
800041a0:	4505                	li	a0,1
800041a2:	a68ff0ef          	jal	ra,8000340a <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800041a6:	ebc98513          	addi	a0,s3,-324
800041aa:	2d15                	jal	800047de <z_spin_unlock_valid>
800041ac:	ed0d                	bnez	a0,800041e6 <z_impl_k_yield+0x16c>
800041ae:	80006437          	lui	s0,0x80006
800041b2:	800065b7          	lui	a1,0x80006
800041b6:	80006537          	lui	a0,0x80006
800041ba:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800041be:	06100693          	li	a3,97
800041c2:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800041c6:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800041ca:	fe5fd0ef          	jal	ra,800021ae <printk>
800041ce:	80006537          	lui	a0,0x80006
800041d2:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800041d6:	fd9fd0ef          	jal	ra,800021ae <printk>
800041da:	06100593          	li	a1,97
800041de:	79440513          	addi	a0,s0,1940
800041e2:	febfd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800041e6:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
800041ea:	4521                	li	a0,8
800041ec:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
800041f0:	4462                	lw	s0,24(sp)
800041f2:	40f2                	lw	ra,28(sp)
800041f4:	44d2                	lw	s1,20(sp)
800041f6:	4942                	lw	s2,16(sp)
800041f8:	49b2                	lw	s3,12(sp)
800041fa:	4a22                	lw	s4,8(sp)
800041fc:	4a92                	lw	s5,4(sp)
800041fe:	8921                	andi	a0,a0,8
80004200:	6105                	addi	sp,sp,32
80004202:	fcffb06f          	j	800001d0 <__swap>
	return (node == list->tail) ? NULL : node->next;
80004206:	00e78463          	beq	a5,a4,8000420e <z_impl_k_yield+0x194>
8000420a:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000420c:	f3c9                	bnez	a5,8000418e <z_impl_k_yield+0x114>
	node->prev = list->tail;
8000420e:	c0d8                	sw	a4,4(s1)
	list->tail->next = node;
80004210:	541c                	lw	a5,40(s0)
	node->next = list;
80004212:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
80004216:	c384                	sw	s1,0(a5)
	list->tail = node;
80004218:	d404                	sw	s1,40(s0)
8000421a:	b759                	j	800041a0 <z_impl_k_yield+0x126>

8000421c <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
8000421c:	7179                	addi	sp,sp,-48
8000421e:	d422                	sw	s0,40(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
80004220:	80007437          	lui	s0,0x80007
80004224:	50c42783          	lw	a5,1292(s0) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
{
80004228:	d226                	sw	s1,36(sp)
8000422a:	d606                	sw	ra,44(sp)
8000422c:	d04a                	sw	s2,32(sp)
8000422e:	ce4e                	sw	s3,28(sp)
80004230:	cc52                	sw	s4,24(sp)
80004232:	84aa                	mv	s1,a0
80004234:	50c40413          	addi	s0,s0,1292
	__ASSERT(!z_is_in_isr(), "");
80004238:	cf8d                	beqz	a5,80004272 <z_impl_k_sleep+0x56>
8000423a:	80007937          	lui	s2,0x80007
8000423e:	800075b7          	lui	a1,0x80007
80004242:	80006537          	lui	a0,0x80006
80004246:	99458593          	addi	a1,a1,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
8000424a:	39900693          	li	a3,921
8000424e:	9fc90613          	addi	a2,s2,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80004252:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004256:	f59fd0ef          	jal	ra,800021ae <printk>
8000425a:	80006537          	lui	a0,0x80006
8000425e:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80004262:	f4dfd0ef          	jal	ra,800021ae <printk>
80004266:	39900593          	li	a1,921
8000426a:	9fc90513          	addi	a0,s2,-1540
8000426e:	f5ffd0ef          	jal	ra,800021cc <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
80004272:	57fd                	li	a5,-1
80004274:	16f49a63          	bne	s1,a5,800043e8 <z_impl_k_sleep+0x1cc>
80004278:	80007937          	lui	s2,0x80007
8000427c:	800075b7          	lui	a1,0x80007
80004280:	80006537          	lui	a0,0x80006
80004284:	a4858593          	addi	a1,a1,-1464 # 80006a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a49>
80004288:	39a00693          	li	a3,922
8000428c:	9fc90613          	addi	a2,s2,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
80004290:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004294:	f1bfd0ef          	jal	ra,800021ae <printk>
80004298:	80006537          	lui	a0,0x80006
8000429c:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
800042a0:	f0ffd0ef          	jal	ra,800021ae <printk>
800042a4:	39a00593          	li	a1,922
800042a8:	9fc90513          	addi	a0,s2,-1540
800042ac:	f21fd0ef          	jal	ra,800021cc <assert_post_action>
800042b0:	45a9                	li	a1,10
800042b2:	00948513          	addi	a0,s1,9
800042b6:	e2afc0ef          	jal	ra,800008e0 <__divsi3>
	if (duration == 0) {
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
800042ba:	00150993          	addi	s3,a0,1
	expected_wakeup_time = ticks + z_tick_get_32();
800042be:	7c1000ef          	jal	ra,8000527e <z_tick_get_32>
800042c2:	00a98933          	add	s2,s3,a0

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
800042c6:	c602                	sw	zero,12(sp)
800042c8:	44a1                	li	s1,8
800042ca:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800042ce:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800042d0:	88a1                	andi	s1,s1,8
800042d2:	29cd                	jal	800047c4 <z_spin_lock_valid>
800042d4:	ed0d                	bnez	a0,8000430e <z_impl_k_sleep+0xf2>
800042d6:	80006a37          	lui	s4,0x80006
800042da:	800065b7          	lui	a1,0x80006
800042de:	80006537          	lui	a0,0x80006
800042e2:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
800042e6:	04e00693          	li	a3,78
800042ea:	794a0613          	addi	a2,s4,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800042ee:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800042f2:	ebdfd0ef          	jal	ra,800021ae <printk>
800042f6:	80006537          	lui	a0,0x80006
800042fa:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
800042fe:	eb1fd0ef          	jal	ra,800021ae <printk>
80004302:	04e00593          	li	a1,78
80004306:	794a0513          	addi	a0,s4,1940
8000430a:	ec3fd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
8000430e:	0068                	addi	a0,sp,12
80004310:	29c5                	jal	80004800 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
80004312:	4408                	lw	a0,8(s0)
80004314:	ef8ff0ef          	jal	ra,80003a0c <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004318:	4408                	lw	a0,8(s0)
8000431a:	800035b7          	lui	a1,0x80003
8000431e:	864e                	mv	a2,s3
80004320:	0561                	addi	a0,a0,24
80004322:	74058593          	addi	a1,a1,1856 # 80003740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003741>
80004326:	073000ef          	jal	ra,80004b98 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
8000432a:	4418                	lw	a4,8(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000432c:	0068                	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
8000432e:	00d74783          	lbu	a5,13(a4)
80004332:	0107e793          	ori	a5,a5,16
80004336:	00f706a3          	sb	a5,13(a4)
8000433a:	2155                	jal	800047de <z_spin_unlock_valid>
8000433c:	ed0d                	bnez	a0,80004376 <z_impl_k_sleep+0x15a>
8000433e:	800069b7          	lui	s3,0x80006
80004342:	800065b7          	lui	a1,0x80006
80004346:	80006537          	lui	a0,0x80006
8000434a:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000434e:	07800693          	li	a3,120
80004352:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004356:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000435a:	e55fd0ef          	jal	ra,800021ae <printk>
8000435e:	80006537          	lui	a0,0x80006
80004362:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80004366:	e49fd0ef          	jal	ra,800021ae <printk>
8000436a:	07800593          	li	a1,120
8000436e:	79498513          	addi	a0,s3,1940
80004372:	e5bfd0ef          	jal	ra,800021cc <assert_post_action>
80004376:	8526                	mv	a0,s1
80004378:	e59fb0ef          	jal	ra,800001d0 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
8000437c:	441c                	lw	a5,8(s0)
8000437e:	00d7c783          	lbu	a5,13(a5)
80004382:	8bc1                	andi	a5,a5,16
80004384:	cf8d                	beqz	a5,800043be <z_impl_k_sleep+0x1a2>
80004386:	80007437          	lui	s0,0x80007
8000438a:	800075b7          	lui	a1,0x80007
8000438e:	80006537          	lui	a0,0x80006
80004392:	a5c58593          	addi	a1,a1,-1444 # 80006a5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a5d>
80004396:	3b700693          	li	a3,951
8000439a:	9fc40613          	addi	a2,s0,-1540 # 800069fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069fd>
8000439e:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800043a2:	e0dfd0ef          	jal	ra,800021ae <printk>
800043a6:	80006537          	lui	a0,0x80006
800043aa:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
800043ae:	e01fd0ef          	jal	ra,800021ae <printk>
800043b2:	3b700593          	li	a1,951
800043b6:	9fc40513          	addi	a0,s0,-1540
800043ba:	e13fd0ef          	jal	ra,800021cc <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
800043be:	6c1000ef          	jal	ra,8000527e <z_tick_get_32>
800043c2:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
800043c6:	4481                	li	s1,0
	if (ticks > 0) {
800043c8:	02a05463          	blez	a0,800043f0 <z_impl_k_sleep+0x1d4>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
800043cc:	3e800613          	li	a2,1000
800043d0:	4681                	li	a3,0
800043d2:	41f55593          	srai	a1,a0,0x1f
800043d6:	c7afc0ef          	jal	ra,80000850 <__muldi3>
800043da:	06400613          	li	a2,100
800043de:	4681                	li	a3,0
800043e0:	e79fb0ef          	jal	ra,80000258 <__udivdi3>
800043e4:	84aa                	mv	s1,a0
		return __ticks_to_ms(ticks);
800043e6:	a029                	j	800043f0 <z_impl_k_sleep+0x1d4>
	if (duration == 0) {
800043e8:	ec0494e3          	bnez	s1,800042b0 <z_impl_k_sleep+0x94>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800043ec:	c8fff0ef          	jal	ra,8000407a <z_impl_k_yield>
}
800043f0:	50b2                	lw	ra,44(sp)
800043f2:	5422                	lw	s0,40(sp)
800043f4:	8526                	mv	a0,s1
800043f6:	5902                	lw	s2,32(sp)
800043f8:	5492                	lw	s1,36(sp)
800043fa:	49f2                	lw	s3,28(sp)
800043fc:	4a62                	lw	s4,24(sp)
800043fe:	6145                	addi	sp,sp,48
80004400:	8082                	ret

80004402 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80004402:	800077b7          	lui	a5,0x80007
80004406:	5147a503          	lw	a0,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
8000440a:	8082                	ret

8000440c <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
8000440c:	1101                	addi	sp,sp,-32
8000440e:	cc22                	sw	s0,24(sp)
80004410:	ca26                	sw	s1,20(sp)
80004412:	c84a                	sw	s2,16(sp)
80004414:	ce06                	sw	ra,28(sp)
80004416:	c64e                	sw	s3,12(sp)
80004418:	842a                	mv	s0,a0
8000441a:	892e                	mv	s2,a1
8000441c:	84b2                	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
8000441e:	ee0d                	bnez	a2,80004458 <z_impl_k_sem_init+0x4c>
80004420:	800079b7          	lui	s3,0x80007
80004424:	800075b7          	lui	a1,0x80007
80004428:	80006537          	lui	a0,0x80006
8000442c:	b3858593          	addi	a1,a1,-1224 # 80006b38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b39>
80004430:	04600693          	li	a3,70
80004434:	b2898613          	addi	a2,s3,-1240 # 80006b28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b29>
80004438:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000443c:	d73fd0ef          	jal	ra,800021ae <printk>
80004440:	80007537          	lui	a0,0x80007
80004444:	b4450513          	addi	a0,a0,-1212 # 80006b44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b45>
80004448:	d67fd0ef          	jal	ra,800021ae <printk>
8000444c:	04600593          	li	a1,70
80004450:	b2898513          	addi	a0,s3,-1240
80004454:	d79fd0ef          	jal	ra,800021cc <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80004458:	0324fe63          	bgeu	s1,s2,80004494 <z_impl_k_sem_init+0x88>
8000445c:	800079b7          	lui	s3,0x80007
80004460:	800075b7          	lui	a1,0x80007
80004464:	80006537          	lui	a0,0x80006
80004468:	b5c58593          	addi	a1,a1,-1188 # 80006b5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b5d>
8000446c:	04700693          	li	a3,71
80004470:	b2898613          	addi	a2,s3,-1240 # 80006b28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b29>
80004474:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004478:	d37fd0ef          	jal	ra,800021ae <printk>
8000447c:	80007537          	lui	a0,0x80007
80004480:	b7450513          	addi	a0,a0,-1164 # 80006b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b75>
80004484:	d2bfd0ef          	jal	ra,800021ae <printk>
80004488:	04700593          	li	a1,71
8000448c:	b2898513          	addi	a0,s3,-1240
80004490:	d3dfd0ef          	jal	ra,800021cc <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80004494:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80004498:	c444                	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
8000449a:	c000                	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
8000449c:	c040                	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
8000449e:	40f2                	lw	ra,28(sp)
800044a0:	4462                	lw	s0,24(sp)
800044a2:	44d2                	lw	s1,20(sp)
800044a4:	4942                	lw	s2,16(sp)
800044a6:	49b2                	lw	s3,12(sp)
800044a8:	6105                	addi	sp,sp,32
800044aa:	8082                	ret

800044ac <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800044ac:	1101                	addi	sp,sp,-32
800044ae:	ca26                	sw	s1,20(sp)
800044b0:	c64e                	sw	s3,12(sp)
800044b2:	ce06                	sw	ra,28(sp)
800044b4:	cc22                	sw	s0,24(sp)
800044b6:	c84a                	sw	s2,16(sp)
800044b8:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800044ba:	44a1                	li	s1,8
800044bc:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800044c0:	80007437          	lui	s0,0x80007
800044c4:	ec840513          	addi	a0,s0,-312 # 80006ec8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec9>
	key = (mstatus & SOC_MSTATUS_IEN);
800044c8:	88a1                	andi	s1,s1,8
800044ca:	2ced                	jal	800047c4 <z_spin_lock_valid>
800044cc:	ed0d                	bnez	a0,80004506 <z_impl_k_sem_give+0x5a>
800044ce:	80006937          	lui	s2,0x80006
800044d2:	800065b7          	lui	a1,0x80006
800044d6:	80006537          	lui	a0,0x80006
800044da:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
800044de:	04e00693          	li	a3,78
800044e2:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800044e6:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800044ea:	cc5fd0ef          	jal	ra,800021ae <printk>
800044ee:	80006537          	lui	a0,0x80006
800044f2:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
800044f6:	cb9fd0ef          	jal	ra,800021ae <printk>
800044fa:	04e00593          	li	a1,78
800044fe:	79490513          	addi	a0,s2,1940
80004502:	ccbfd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80004506:	ec840513          	addi	a0,s0,-312
8000450a:	2cdd                	jal	80004800 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
8000450c:	854e                	mv	a0,s3
8000450e:	8e9ff0ef          	jal	ra,80003df6 <z_unpend_first_thread>
80004512:	892a                	mv	s2,a0
	if (thread != NULL) {
80004514:	c515                	beqz	a0,80004540 <z_impl_k_sem_give+0x94>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004516:	00d54783          	lbu	a5,13(a0)
8000451a:	8bfd                	andi	a5,a5,31
8000451c:	e789                	bnez	a5,80004526 <z_impl_k_sem_give+0x7a>
	if (z_is_thread_ready(thread)) {
8000451e:	4d1c                	lw	a5,24(a0)
80004520:	e399                	bnez	a5,80004526 <z_impl_k_sem_give+0x7a>
		z_add_thread_to_ready_q(thread);
80004522:	8d4ff0ef          	jal	ra,800035f6 <z_add_thread_to_ready_q>
80004526:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
8000452a:	ec840513          	addi	a0,s0,-312
}
8000452e:	4462                	lw	s0,24(sp)
80004530:	40f2                	lw	ra,28(sp)
80004532:	4942                	lw	s2,16(sp)
80004534:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004536:	85a6                	mv	a1,s1
}
80004538:	44d2                	lw	s1,20(sp)
8000453a:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
8000453c:	b6ffe06f          	j	800030aa <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80004540:	0089a703          	lw	a4,8(s3)
80004544:	00c9a783          	lw	a5,12(s3)
80004548:	8f99                	sub	a5,a5,a4
8000454a:	00f037b3          	snez	a5,a5
8000454e:	97ba                	add	a5,a5,a4
80004550:	00f9a423          	sw	a5,8(s3)
80004554:	bfd9                	j	8000452a <z_impl_k_sem_give+0x7e>

80004556 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004556:	800077b7          	lui	a5,0x80007
8000455a:	50c7a783          	lw	a5,1292(a5) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
{
8000455e:	1101                	addi	sp,sp,-32
80004560:	c84a                	sw	s2,16(sp)
80004562:	c64e                	sw	s3,12(sp)
80004564:	ce06                	sw	ra,28(sp)
80004566:	cc22                	sw	s0,24(sp)
80004568:	ca26                	sw	s1,20(sp)
8000456a:	c452                	sw	s4,8(sp)
8000456c:	892a                	mv	s2,a0
8000456e:	89ae                	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004570:	cf95                	beqz	a5,800045ac <z_impl_k_sem_take+0x56>
80004572:	cd8d                	beqz	a1,800045ac <z_impl_k_sem_take+0x56>
80004574:	80007437          	lui	s0,0x80007
80004578:	800075b7          	lui	a1,0x80007
8000457c:	80006537          	lui	a0,0x80006
80004580:	b9c58593          	addi	a1,a1,-1124 # 80006b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b9d>
80004584:	08c00693          	li	a3,140
80004588:	b2840613          	addi	a2,s0,-1240 # 80006b28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b29>
8000458c:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004590:	c1ffd0ef          	jal	ra,800021ae <printk>
80004594:	80006537          	lui	a0,0x80006
80004598:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
8000459c:	c13fd0ef          	jal	ra,800021ae <printk>
800045a0:	08c00593          	li	a1,140
800045a4:	b2840513          	addi	a0,s0,-1240
800045a8:	c25fd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800045ac:	4421                	li	s0,8
800045ae:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800045b2:	800074b7          	lui	s1,0x80007
800045b6:	ec848513          	addi	a0,s1,-312 # 80006ec8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec9>
	key = (mstatus & SOC_MSTATUS_IEN);
800045ba:	8821                	andi	s0,s0,8
800045bc:	2421                	jal	800047c4 <z_spin_lock_valid>
800045be:	ed0d                	bnez	a0,800045f8 <z_impl_k_sem_take+0xa2>
800045c0:	80006a37          	lui	s4,0x80006
800045c4:	800065b7          	lui	a1,0x80006
800045c8:	80006537          	lui	a0,0x80006
800045cc:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
800045d0:	04e00693          	li	a3,78
800045d4:	794a0613          	addi	a2,s4,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800045d8:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800045dc:	bd3fd0ef          	jal	ra,800021ae <printk>
800045e0:	80006537          	lui	a0,0x80006
800045e4:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
800045e8:	bc7fd0ef          	jal	ra,800021ae <printk>
800045ec:	04e00593          	li	a1,78
800045f0:	794a0513          	addi	a0,s4,1940
800045f4:	bd9fd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
800045f8:	ec848513          	addi	a0,s1,-312
800045fc:	2411                	jal	80004800 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
800045fe:	00892783          	lw	a5,8(s2)
80004602:	cfb9                	beqz	a5,80004660 <z_impl_k_sem_take+0x10a>
		sem->count--;
80004604:	17fd                	addi	a5,a5,-1
80004606:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000460a:	ec848513          	addi	a0,s1,-312
8000460e:	2ac1                	jal	800047de <z_spin_unlock_valid>
80004610:	ed0d                	bnez	a0,8000464a <z_impl_k_sem_take+0xf4>
80004612:	800064b7          	lui	s1,0x80006
80004616:	800065b7          	lui	a1,0x80006
8000461a:	80006537          	lui	a0,0x80006
8000461e:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004622:	06100693          	li	a3,97
80004626:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
8000462a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000462e:	b81fd0ef          	jal	ra,800021ae <printk>
80004632:	80006537          	lui	a0,0x80006
80004636:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
8000463a:	b75fd0ef          	jal	ra,800021ae <printk>
8000463e:	06100593          	li	a1,97
80004642:	79448513          	addi	a0,s1,1940
80004646:	b87fd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000464a:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
8000464e:	4501                	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80004650:	40f2                	lw	ra,28(sp)
80004652:	4462                	lw	s0,24(sp)
80004654:	44d2                	lw	s1,20(sp)
80004656:	4942                	lw	s2,16(sp)
80004658:	49b2                	lw	s3,12(sp)
8000465a:	4a22                	lw	s4,8(sp)
8000465c:	6105                	addi	sp,sp,32
8000465e:	8082                	ret
	if (timeout == K_NO_WAIT) {
80004660:	04099663          	bnez	s3,800046ac <z_impl_k_sem_take+0x156>
80004664:	ec848513          	addi	a0,s1,-312
80004668:	2a9d                	jal	800047de <z_spin_unlock_valid>
8000466a:	ed0d                	bnez	a0,800046a4 <z_impl_k_sem_take+0x14e>
8000466c:	800064b7          	lui	s1,0x80006
80004670:	800065b7          	lui	a1,0x80006
80004674:	80006537          	lui	a0,0x80006
80004678:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000467c:	06100693          	li	a3,97
80004680:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004684:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004688:	b27fd0ef          	jal	ra,800021ae <printk>
8000468c:	80006537          	lui	a0,0x80006
80004690:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80004694:	b1bfd0ef          	jal	ra,800021ae <printk>
80004698:	06100593          	li	a1,97
8000469c:	79448513          	addi	a0,s1,1940
800046a0:	b2dfd0ef          	jal	ra,800021cc <assert_post_action>
800046a4:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800046a8:	5541                	li	a0,-16
800046aa:	b75d                	j	80004650 <z_impl_k_sem_take+0xfa>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800046ac:	85a2                	mv	a1,s0
}
800046ae:	4462                	lw	s0,24(sp)
800046b0:	40f2                	lw	ra,28(sp)
800046b2:	4a22                	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800046b4:	86ce                	mv	a3,s3
800046b6:	864a                	mv	a2,s2
}
800046b8:	49b2                	lw	s3,12(sp)
800046ba:	4942                	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800046bc:	ec848513          	addi	a0,s1,-312
}
800046c0:	44d2                	lw	s1,20(sp)
800046c2:	6105                	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800046c4:	d2aff06f          	j	80003bee <z_pend_curr>

800046c8 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800046c8:	00d54783          	lbu	a5,13(a0)
800046cc:	8bfd                	andi	a5,a5,31
800046ce:	e789                	bnez	a5,800046d8 <z_is_thread_ready+0x10>
800046d0:	4d08                	lw	a0,24(a0)
800046d2:	00153513          	seqz	a0,a0
800046d6:	8082                	ret
800046d8:	4501                	li	a0,0
}
800046da:	8082                	ret

800046dc <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800046dc:	800077b7          	lui	a5,0x80007
800046e0:	50c7a503          	lw	a0,1292(a5) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
}
800046e4:	00a03533          	snez	a0,a0
800046e8:	8082                	ret

800046ea <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800046ea:	800077b7          	lui	a5,0x80007
800046ee:	5147a783          	lw	a5,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
800046f2:	00c7c503          	lbu	a0,12(a5)
}
800046f6:	8905                	andi	a0,a0,1
800046f8:	8082                	ret

800046fa <z_impl_k_busy_wait>:
void z_impl_k_busy_wait(u32_t usec_to_wait)
{
#if !defined(CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT)
	/* use 64-bit math to prevent overflow when multiplying */
	u32_t cycles_to_wait = (u32_t)(
		(u64_t)usec_to_wait *
800046fa:	00b72637          	lui	a2,0xb72
{
800046fe:	1141                	addi	sp,sp,-16
		(u64_t)usec_to_wait *
80004700:	b0060613          	addi	a2,a2,-1280 # b71b00 <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC>
80004704:	4681                	li	a3,0
80004706:	4581                	li	a1,0
{
80004708:	c606                	sw	ra,12(sp)
8000470a:	c422                	sw	s0,8(sp)
8000470c:	c226                	sw	s1,4(sp)
		(u64_t)usec_to_wait *
8000470e:	942fc0ef          	jal	ra,80000850 <__muldi3>
		(u64_t)sys_clock_hw_cycles_per_sec() /
80004712:	000f4637          	lui	a2,0xf4
80004716:	24060613          	addi	a2,a2,576 # f4240 <CONFIG_RISCV_RAM_SIZE+0xb4240>
8000471a:	4681                	li	a3,0
8000471c:	b3dfb0ef          	jal	ra,80000258 <__udivdi3>
80004720:	842a                	mv	s0,a0
		(u64_t)USEC_PER_SEC
	);
	u32_t start_cycles = k_cycle_get_32();
80004722:	ed9fd0ef          	jal	ra,800025fa <z_timer_cycle_get_32>
80004726:	84aa                	mv	s1,a0

	for (;;) {
		u32_t current_cycles = k_cycle_get_32();
80004728:	ed3fd0ef          	jal	ra,800025fa <z_timer_cycle_get_32>

		/* this handles the rollover on an unsigned 32-bit value */
		if ((current_cycles - start_cycles) >= cycles_to_wait) {
8000472c:	8d05                	sub	a0,a0,s1
8000472e:	fe856de3          	bltu	a0,s0,80004728 <z_impl_k_busy_wait+0x2e>
		}
	}
#else
	z_arch_busy_wait(usec_to_wait);
#endif /* CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT */
}
80004732:	40b2                	lw	ra,12(sp)
80004734:	4422                	lw	s0,8(sp)
80004736:	4492                	lw	s1,4(sp)
80004738:	0141                	addi	sp,sp,16
8000473a:	8082                	ret

8000473c <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
8000473c:	1101                	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000473e:	5302                	lw	t1,32(sp)
{
80004740:	cc22                	sw	s0,24(sp)
80004742:	ce06                	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004744:	c01a                	sw	t1,0(sp)
{
80004746:	842a                	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004748:	fe1fc0ef          	jal	ra,80001728 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
8000474c:	800077b7          	lui	a5,0x80007
80004750:	5147a783          	lw	a5,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
	sys_trace_thread_create(new_thread);
}
80004754:	40f2                	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004756:	57bc                	lw	a5,104(a5)
80004758:	d43c                	sw	a5,104(s0)
}
8000475a:	4462                	lw	s0,24(sp)
8000475c:	6105                	addi	sp,sp,32
8000475e:	8082                	ret

80004760 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004760:	513c                	lw	a5,96(a0)
{
80004762:	1141                	addi	sp,sp,-16
80004764:	c422                	sw	s0,8(sp)
80004766:	c606                	sw	ra,12(sp)
80004768:	842a                	mv	s0,a0
	if (thread->fn_abort != NULL) {
8000476a:	c391                	beqz	a5,8000476e <z_thread_single_abort+0xe>
		thread->fn_abort();
8000476c:	9782                	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
8000476e:	8522                	mv	a0,s0
80004770:	f59ff0ef          	jal	ra,800046c8 <z_is_thread_ready>
80004774:	cd11                	beqz	a0,80004790 <z_thread_single_abort+0x30>
		z_remove_thread_from_ready_q(thread);
80004776:	8522                	mv	a0,s0
80004778:	a94ff0ef          	jal	ra,80003a0c <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
8000477c:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004780:	40b2                	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004782:	0087e793          	ori	a5,a5,8
80004786:	00f406a3          	sb	a5,13(s0)
}
8000478a:	4422                	lw	s0,8(sp)
8000478c:	0141                	addi	sp,sp,16
8000478e:	8082                	ret
		if (z_is_thread_pending(thread)) {
80004790:	00d44783          	lbu	a5,13(s0)
80004794:	8b89                	andi	a5,a5,2
80004796:	c781                	beqz	a5,8000479e <z_thread_single_abort+0x3e>
			z_unpend_thread_no_timeout(thread);
80004798:	8522                	mv	a0,s0
8000479a:	841fe0ef          	jal	ra,80002fda <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
8000479e:	4c1c                	lw	a5,24(s0)
800047a0:	dff1                	beqz	a5,8000477c <z_thread_single_abort+0x1c>
	return z_abort_timeout(&thread->base.timeout);
800047a2:	01840513          	addi	a0,s0,24
800047a6:	2b6d                	jal	80004d60 <z_abort_timeout>
800047a8:	bfd1                	j	8000477c <z_thread_single_abort+0x1c>

800047aa <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
800047aa:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
800047ae:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
800047b2:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
800047b6:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
800047ba:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
800047be:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
800047c2:	8082                	ret

800047c4 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
800047c4:	4108                	lw	a0,0(a0)
800047c6:	c911                	beqz	a0,800047da <z_spin_lock_valid+0x16>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800047c8:	800077b7          	lui	a5,0x80007
800047cc:	5207c783          	lbu	a5,1312(a5) # 80007520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007521>
800047d0:	890d                	andi	a0,a0,3
800047d2:	8d1d                	sub	a0,a0,a5
800047d4:	00a03533          	snez	a0,a0
800047d8:	8082                	ret
			return false;
		}
	}
	return true;
800047da:	4505                	li	a0,1
}
800047dc:	8082                	ret

800047de <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800047de:	800077b7          	lui	a5,0x80007
800047e2:	50c78793          	addi	a5,a5,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
800047e6:	0147c703          	lbu	a4,20(a5)
800047ea:	479c                	lw	a5,8(a5)
800047ec:	8fd9                	or	a5,a5,a4
800047ee:	4118                	lw	a4,0(a0)
800047f0:	00f71663          	bne	a4,a5,800047fc <z_spin_unlock_valid+0x1e>
		return false;
	}
	l->thread_cpu = 0;
800047f4:	00052023          	sw	zero,0(a0)
	return true;
800047f8:	4505                	li	a0,1
800047fa:	8082                	ret
		return false;
800047fc:	4501                	li	a0,0
}
800047fe:	8082                	ret

80004800 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004800:	800077b7          	lui	a5,0x80007
80004804:	50c78793          	addi	a5,a5,1292 # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
80004808:	0147c703          	lbu	a4,20(a5)
8000480c:	479c                	lw	a5,8(a5)
8000480e:	8fd9                	or	a5,a5,a4
80004810:	c11c                	sw	a5,0(a0)
}
80004812:	8082                	ret

80004814 <z_impl_k_thread_start>:
{
80004814:	1101                	addi	sp,sp,-32
80004816:	cc22                	sw	s0,24(sp)
80004818:	c84a                	sw	s2,16(sp)
8000481a:	ce06                	sw	ra,28(sp)
8000481c:	ca26                	sw	s1,20(sp)
8000481e:	c64e                	sw	s3,12(sp)
80004820:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004822:	4421                	li	s0,8
80004824:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004828:	800074b7          	lui	s1,0x80007
8000482c:	ecc48513          	addi	a0,s1,-308 # 80006ecc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ecd>
	key = (mstatus & SOC_MSTATUS_IEN);
80004830:	8821                	andi	s0,s0,8
80004832:	f93ff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80004836:	ed0d                	bnez	a0,80004870 <z_impl_k_thread_start+0x5c>
80004838:	800069b7          	lui	s3,0x80006
8000483c:	800065b7          	lui	a1,0x80006
80004840:	80006537          	lui	a0,0x80006
80004844:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80004848:	04e00693          	li	a3,78
8000484c:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004850:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004854:	95bfd0ef          	jal	ra,800021ae <printk>
80004858:	80006537          	lui	a0,0x80006
8000485c:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80004860:	94ffd0ef          	jal	ra,800021ae <printk>
80004864:	04e00593          	li	a1,78
80004868:	79498513          	addi	a0,s3,1940
8000486c:	961fd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80004870:	ecc48513          	addi	a0,s1,-308
80004874:	f8dff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004878:	00d94783          	lbu	a5,13(s2)
8000487c:	0047f713          	andi	a4,a5,4
80004880:	eb39                	bnez	a4,800048d6 <z_impl_k_thread_start+0xc2>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004882:	ecc48513          	addi	a0,s1,-308
80004886:	f59ff0ef          	jal	ra,800047de <z_spin_unlock_valid>
8000488a:	ed0d                	bnez	a0,800048c4 <z_impl_k_thread_start+0xb0>
8000488c:	800064b7          	lui	s1,0x80006
80004890:	800065b7          	lui	a1,0x80006
80004894:	80006537          	lui	a0,0x80006
80004898:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
8000489c:	06100693          	li	a3,97
800048a0:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800048a4:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800048a8:	907fd0ef          	jal	ra,800021ae <printk>
800048ac:	80006537          	lui	a0,0x80006
800048b0:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800048b4:	8fbfd0ef          	jal	ra,800021ae <printk>
800048b8:	06100593          	li	a1,97
800048bc:	79448513          	addi	a0,s1,1940
800048c0:	90dfd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800048c4:	30042473          	csrrs	s0,mstatus,s0
}
800048c8:	40f2                	lw	ra,28(sp)
800048ca:	4462                	lw	s0,24(sp)
800048cc:	44d2                	lw	s1,20(sp)
800048ce:	4942                	lw	s2,16(sp)
800048d0:	49b2                	lw	s3,12(sp)
800048d2:	6105                	addi	sp,sp,32
800048d4:	8082                	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
800048d6:	9bed                	andi	a5,a5,-5
800048d8:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
800048dc:	854a                	mv	a0,s2
800048de:	debff0ef          	jal	ra,800046c8 <z_is_thread_ready>
800048e2:	c501                	beqz	a0,800048ea <z_impl_k_thread_start+0xd6>
		z_add_thread_to_ready_q(thread);
800048e4:	854a                	mv	a0,s2
800048e6:	d11fe0ef          	jal	ra,800035f6 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
800048ea:	85a2                	mv	a1,s0
}
800048ec:	4462                	lw	s0,24(sp)
800048ee:	40f2                	lw	ra,28(sp)
800048f0:	4942                	lw	s2,16(sp)
800048f2:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
800048f4:	ecc48513          	addi	a0,s1,-308
}
800048f8:	44d2                	lw	s1,20(sp)
800048fa:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
800048fc:	faefe06f          	j	800030aa <z_reschedule>

80004900 <schedule_new_thread>:
	if (delay == 0) {
80004900:	e199                	bnez	a1,80004906 <schedule_new_thread+0x6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004902:	f13ff06f          	j	80004814 <z_impl_k_thread_start>
{
80004906:	1141                	addi	sp,sp,-16
80004908:	c422                	sw	s0,8(sp)
8000490a:	842a                	mv	s0,a0
8000490c:	852e                	mv	a0,a1
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
8000490e:	0525                	addi	a0,a0,9
80004910:	45a9                	li	a1,10
80004912:	c606                	sw	ra,12(sp)
80004914:	fcdfb0ef          	jal	ra,800008e0 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004918:	00150613          	addi	a2,a0,1
8000491c:	01840513          	addi	a0,s0,24
}
80004920:	4422                	lw	s0,8(sp)
80004922:	40b2                	lw	ra,12(sp)
80004924:	800035b7          	lui	a1,0x80003
80004928:	74058593          	addi	a1,a1,1856 # 80003740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003741>
8000492c:	0141                	addi	sp,sp,16
8000492e:	a4ad                	j	80004b98 <z_add_timeout>

80004930 <z_impl_k_thread_create>:
{
80004930:	7139                	addi	sp,sp,-64
80004932:	d256                	sw	s5,36(sp)
80004934:	8ab6                	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004936:	800076b7          	lui	a3,0x80007
8000493a:	50c6a683          	lw	a3,1292(a3) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
{
8000493e:	dc22                	sw	s0,56(sp)
80004940:	da26                	sw	s1,52(sp)
80004942:	d64e                	sw	s3,44(sp)
80004944:	d452                	sw	s4,40(sp)
80004946:	de06                	sw	ra,60(sp)
80004948:	d84a                	sw	s2,48(sp)
8000494a:	842a                	mv	s0,a0
8000494c:	89ae                	mv	s3,a1
8000494e:	8a32                	mv	s4,a2
80004950:	4496                	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004952:	c6a9                	beqz	a3,8000499c <z_impl_k_thread_create+0x6c>
80004954:	80007937          	lui	s2,0x80007
80004958:	800075b7          	lui	a1,0x80007
8000495c:	80006537          	lui	a0,0x80006
80004960:	1b200693          	li	a3,434
80004964:	bd090613          	addi	a2,s2,-1072 # 80006bd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bd1>
80004968:	99458593          	addi	a1,a1,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
8000496c:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004970:	ce46                	sw	a7,28(sp)
80004972:	cc42                	sw	a6,24(sp)
80004974:	ca3e                	sw	a5,20(sp)
80004976:	c83a                	sw	a4,16(sp)
80004978:	837fd0ef          	jal	ra,800021ae <printk>
8000497c:	80007537          	lui	a0,0x80007
80004980:	be450513          	addi	a0,a0,-1052 # 80006be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be5>
80004984:	82bfd0ef          	jal	ra,800021ae <printk>
80004988:	1b200593          	li	a1,434
8000498c:	bd090513          	addi	a0,s2,-1072
80004990:	83dfd0ef          	jal	ra,800021cc <assert_post_action>
80004994:	48f2                	lw	a7,28(sp)
80004996:	4862                	lw	a6,24(sp)
80004998:	47d2                	lw	a5,20(sp)
8000499a:	4742                	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000499c:	4686                	lw	a3,64(sp)
8000499e:	c202                	sw	zero,4(sp)
800049a0:	8652                	mv	a2,s4
800049a2:	c036                	sw	a3,0(sp)
800049a4:	85ce                	mv	a1,s3
800049a6:	86d6                	mv	a3,s5
800049a8:	8522                	mv	a0,s0
800049aa:	d93ff0ef          	jal	ra,8000473c <z_setup_new_thread>
	if (delay != K_FOREVER) {
800049ae:	57fd                	li	a5,-1
800049b0:	00f48663          	beq	s1,a5,800049bc <z_impl_k_thread_create+0x8c>
		schedule_new_thread(new_thread, delay);
800049b4:	85a6                	mv	a1,s1
800049b6:	8522                	mv	a0,s0
800049b8:	f49ff0ef          	jal	ra,80004900 <schedule_new_thread>
}
800049bc:	8522                	mv	a0,s0
800049be:	50f2                	lw	ra,60(sp)
800049c0:	5462                	lw	s0,56(sp)
800049c2:	54d2                	lw	s1,52(sp)
800049c4:	5942                	lw	s2,48(sp)
800049c6:	59b2                	lw	s3,44(sp)
800049c8:	5a22                	lw	s4,40(sp)
800049ca:	5a92                	lw	s5,36(sp)
800049cc:	6121                	addi	sp,sp,64
800049ce:	8082                	ret

800049d0 <z_init_static_threads>:
{
800049d0:	1101                	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
800049d2:	800077b7          	lui	a5,0x80007
{
800049d6:	c84a                	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
800049d8:	80007937          	lui	s2,0x80007
{
800049dc:	cc22                	sw	s0,24(sp)
800049de:	ca26                	sw	s1,20(sp)
800049e0:	ce06                	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
800049e2:	e7c78413          	addi	s0,a5,-388 # 80006e7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e7d>
800049e6:	e7c78493          	addi	s1,a5,-388
800049ea:	e7c90913          	addi	s2,s2,-388 # 80006e7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e7d>
800049ee:	01246f63          	bltu	s0,s2,80004a0c <z_init_static_threads+0x3c>
	_FOREACH_STATIC_THREAD(thread_data) {
800049f2:	8426                	mv	s0,s1
	k_sched_lock();
800049f4:	f86fe0ef          	jal	ra,8000317a <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
800049f8:	54fd                	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
800049fa:	03246e63          	bltu	s0,s2,80004a36 <z_init_static_threads+0x66>
}
800049fe:	4462                	lw	s0,24(sp)
80004a00:	40f2                	lw	ra,28(sp)
80004a02:	44d2                	lw	s1,20(sp)
80004a04:	4942                	lw	s2,16(sp)
80004a06:	6105                	addi	sp,sp,32
	k_sched_unlock();
80004a08:	a99fe06f          	j	800034a0 <k_sched_unlock>
		z_setup_new_thread(
80004a0c:	545c                	lw	a5,44(s0)
80004a0e:	c23e                	sw	a5,4(sp)
80004a10:	501c                	lw	a5,32(s0)
80004a12:	c03e                	sw	a5,0(sp)
80004a14:	485c                	lw	a5,20(s0)
80004a16:	01c42883          	lw	a7,28(s0)
80004a1a:	01842803          	lw	a6,24(s0)
80004a1e:	4818                	lw	a4,16(s0)
80004a20:	4454                	lw	a3,12(s0)
80004a22:	4410                	lw	a2,8(s0)
80004a24:	404c                	lw	a1,4(s0)
80004a26:	4008                	lw	a0,0(s0)
80004a28:	d15ff0ef          	jal	ra,8000473c <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004a2c:	401c                	lw	a5,0(s0)
80004a2e:	cfe0                	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004a30:	03040413          	addi	s0,s0,48
80004a34:	bf6d                	j	800049ee <z_init_static_threads+0x1e>
		if (thread_data->init_delay != K_FOREVER) {
80004a36:	504c                	lw	a1,36(s0)
80004a38:	00958563          	beq	a1,s1,80004a42 <z_init_static_threads+0x72>
			schedule_new_thread(thread_data->init_thread,
80004a3c:	4008                	lw	a0,0(s0)
80004a3e:	ec3ff0ef          	jal	ra,80004900 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004a42:	03040413          	addi	s0,s0,48
80004a46:	bf55                	j	800049fa <z_init_static_threads+0x2a>

80004a48 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004a48:	1101                	addi	sp,sp,-32
80004a4a:	cc22                	sw	s0,24(sp)
80004a4c:	ca26                	sw	s1,20(sp)
80004a4e:	ce06                	sw	ra,28(sp)
80004a50:	c84a                	sw	s2,16(sp)
80004a52:	84aa                	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004a54:	c602                	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004a56:	4421                	li	s0,8
80004a58:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004a5c:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004a5e:	8821                	andi	s0,s0,8
80004a60:	d65ff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80004a64:	ed0d                	bnez	a0,80004a9e <z_impl_k_thread_abort+0x56>
80004a66:	80006937          	lui	s2,0x80006
80004a6a:	800065b7          	lui	a1,0x80006
80004a6e:	80006537          	lui	a0,0x80006
80004a72:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80004a76:	04e00693          	li	a3,78
80004a7a:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004a7e:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004a82:	f2cfd0ef          	jal	ra,800021ae <printk>
80004a86:	80006537          	lui	a0,0x80006
80004a8a:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80004a8e:	f20fd0ef          	jal	ra,800021ae <printk>
80004a92:	04e00593          	li	a1,78
80004a96:	79490513          	addi	a0,s2,1940
80004a9a:	f32fd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80004a9e:	0068                	addi	a0,sp,12
80004aa0:	d61ff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004aa4:	00c4c783          	lbu	a5,12(s1)
80004aa8:	8b85                	andi	a5,a5,1
80004aaa:	cf8d                	beqz	a5,80004ae4 <z_impl_k_thread_abort+0x9c>
80004aac:	80007937          	lui	s2,0x80007
80004ab0:	800075b7          	lui	a1,0x80007
80004ab4:	80006537          	lui	a0,0x80006
80004ab8:	c2458593          	addi	a1,a1,-988 # 80006c24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c25>
80004abc:	02900693          	li	a3,41
80004ac0:	c0c90613          	addi	a2,s2,-1012 # 80006c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c0d>
80004ac4:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004ac8:	ee6fd0ef          	jal	ra,800021ae <printk>
80004acc:	80007537          	lui	a0,0x80007
80004ad0:	c5850513          	addi	a0,a0,-936 # 80006c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c59>
80004ad4:	edafd0ef          	jal	ra,800021ae <printk>
80004ad8:	02900593          	li	a1,41
80004adc:	c0c90513          	addi	a0,s2,-1012
80004ae0:	eecfd0ef          	jal	ra,800021cc <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004ae4:	8526                	mv	a0,s1
80004ae6:	c7bff0ef          	jal	ra,80004760 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004aea:	85a2                	mv	a1,s0
80004aec:	0068                	addi	a0,sp,12
80004aee:	dbcfe0ef          	jal	ra,800030aa <z_reschedule>
}
80004af2:	40f2                	lw	ra,28(sp)
80004af4:	4462                	lw	s0,24(sp)
80004af6:	44d2                	lw	s1,20(sp)
80004af8:	4942                	lw	s2,16(sp)
80004afa:	6105                	addi	sp,sp,32
80004afc:	8082                	ret

80004afe <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004afe:	800077b7          	lui	a5,0x80007
80004b02:	ed07a783          	lw	a5,-304(a5) # 80006ed0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed1>
80004b06:	e399                	bnez	a5,80004b0c <elapsed+0xe>
80004b08:	a2dfd06f          	j	80002534 <z_clock_elapsed>
}
80004b0c:	4501                	li	a0,0
80004b0e:	8082                	ret

80004b10 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004b10:	411c                	lw	a5,0(a0)
80004b12:	cd01                	beqz	a0,80004b2a <remove_timeout+0x1a>
80004b14:	80007737          	lui	a4,0x80007
	return (node == list->tail) ? NULL : node->next;
80004b18:	e4072703          	lw	a4,-448(a4) # 80006e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e41>
80004b1c:	00e50763          	beq	a0,a4,80004b2a <remove_timeout+0x1a>
	if (next(t) != NULL) {
80004b20:	c789                	beqz	a5,80004b2a <remove_timeout+0x1a>
		next(t)->dticks += t->dticks;
80004b22:	4798                	lw	a4,8(a5)
80004b24:	4514                	lw	a3,8(a0)
80004b26:	9736                	add	a4,a4,a3
80004b28:	c798                	sw	a4,8(a5)
	node->prev->next = node->next;
80004b2a:	4158                	lw	a4,4(a0)
80004b2c:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80004b2e:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80004b30:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004b34:	00052223          	sw	zero,4(a0)
}
80004b38:	8082                	ret

80004b3a <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004b3a:	800077b7          	lui	a5,0x80007
80004b3e:	edc7c783          	lbu	a5,-292(a5) # 80006edc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006edd>
{
80004b42:	1141                	addi	sp,sp,-16
80004b44:	c606                	sw	ra,12(sp)
80004b46:	c422                	sw	s0,8(sp)
80004b48:	c226                	sw	s1,4(sp)
80004b4a:	557d                	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004b4c:	e789                	bnez	a5,80004b56 <next_timeout+0x1c>
80004b4e:	80000537          	lui	a0,0x80000
80004b52:	fff54513          	not	a0,a0
	return list->head == list;
80004b56:	800077b7          	lui	a5,0x80007
80004b5a:	e3c78793          	addi	a5,a5,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
80004b5e:	4380                	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004b60:	00f40f63          	beq	s0,a5,80004b7e <next_timeout+0x44>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004b64:	cc09                	beqz	s0,80004b7e <next_timeout+0x44>
80004b66:	4404                	lw	s1,8(s0)
80004b68:	f97ff0ef          	jal	ra,80004afe <elapsed>
80004b6c:	8c89                	sub	s1,s1,a0
80004b6e:	4501                	li	a0,0
80004b70:	0004c763          	bltz	s1,80004b7e <next_timeout+0x44>
80004b74:	4400                	lw	s0,8(s0)
80004b76:	f89ff0ef          	jal	ra,80004afe <elapsed>
80004b7a:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004b7e:	800077b7          	lui	a5,0x80007
80004b82:	51c7a783          	lw	a5,1308(a5) # 8000751c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000751d>
80004b86:	c781                	beqz	a5,80004b8e <next_timeout+0x54>
80004b88:	00a7d363          	bge	a5,a0,80004b8e <next_timeout+0x54>
80004b8c:	853e                	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004b8e:	40b2                	lw	ra,12(sp)
80004b90:	4422                	lw	s0,8(sp)
80004b92:	4492                	lw	s1,4(sp)
80004b94:	0141                	addi	sp,sp,16
80004b96:	8082                	ret

80004b98 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004b98:	411c                	lw	a5,0(a0)
{
80004b9a:	7179                	addi	sp,sp,-48
80004b9c:	d422                	sw	s0,40(sp)
80004b9e:	d226                	sw	s1,36(sp)
80004ba0:	ce4e                	sw	s3,28(sp)
80004ba2:	d606                	sw	ra,44(sp)
80004ba4:	d04a                	sw	s2,32(sp)
80004ba6:	cc52                	sw	s4,24(sp)
80004ba8:	ca56                	sw	s5,20(sp)
80004baa:	c85a                	sw	s6,16(sp)
80004bac:	c65e                	sw	s7,12(sp)
80004bae:	c462                	sw	s8,8(sp)
80004bb0:	842a                	mv	s0,a0
80004bb2:	89ae                	mv	s3,a1
80004bb4:	84b2                	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004bb6:	cf8d                	beqz	a5,80004bf0 <z_add_timeout+0x58>
80004bb8:	80007937          	lui	s2,0x80007
80004bbc:	800075b7          	lui	a1,0x80007
80004bc0:	80006537          	lui	a0,0x80006
80004bc4:	c8858593          	addi	a1,a1,-888 # 80006c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c89>
80004bc8:	04d00693          	li	a3,77
80004bcc:	c7490613          	addi	a2,s2,-908 # 80006c74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c75>
80004bd0:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004bd4:	ddafd0ef          	jal	ra,800021ae <printk>
80004bd8:	80006537          	lui	a0,0x80006
80004bdc:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80004be0:	dcefd0ef          	jal	ra,800021ae <printk>
80004be4:	04d00593          	li	a1,77
80004be8:	c7490513          	addi	a0,s2,-908
80004bec:	de0fd0ef          	jal	ra,800021cc <assert_post_action>
	to->fn = fn;
80004bf0:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004bf4:	00904363          	bgtz	s1,80004bfa <z_add_timeout+0x62>
80004bf8:	4485                	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004bfa:	49a1                	li	s3,8
80004bfc:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004c00:	80007a37          	lui	s4,0x80007
80004c04:	ed4a0513          	addi	a0,s4,-300 # 80006ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed5>
	key = (mstatus & SOC_MSTATUS_IEN);
80004c08:	0089f993          	andi	s3,s3,8
80004c0c:	bb9ff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80004c10:	ed0d                	bnez	a0,80004c4a <z_add_timeout+0xb2>
80004c12:	80006937          	lui	s2,0x80006
80004c16:	800065b7          	lui	a1,0x80006
80004c1a:	80006537          	lui	a0,0x80006
80004c1e:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80004c22:	04e00693          	li	a3,78
80004c26:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004c2a:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004c2e:	d80fd0ef          	jal	ra,800021ae <printk>
80004c32:	80006537          	lui	a0,0x80006
80004c36:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80004c3a:	d74fd0ef          	jal	ra,800021ae <printk>
80004c3e:	04e00593          	li	a1,78
80004c42:	79490513          	addi	a0,s2,1940
80004c46:	d86fd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80004c4a:	ed4a0513          	addi	a0,s4,-300
80004c4e:	bb3ff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80004c52:	eadff0ef          	jal	ra,80004afe <elapsed>
80004c56:	9526                	add	a0,a0,s1
	return list->head == list;
80004c58:	800074b7          	lui	s1,0x80007
80004c5c:	e3c4a903          	lw	s2,-452(s1) # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
80004c60:	c408                	sw	a0,8(s0)
80004c62:	e3c48493          	addi	s1,s1,-452
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004c66:	00990c63          	beq	s2,s1,80004c7e <z_add_timeout+0xe6>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80004c6a:	80007ab7          	lui	s5,0x80007
80004c6e:	80007b37          	lui	s6,0x80007
80004c72:	80006bb7          	lui	s7,0x80006
80004c76:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
80004c7a:	00091963          	bnez	s2,80004c8c <z_add_timeout+0xf4>
	node->prev = list->tail;
80004c7e:	40dc                	lw	a5,4(s1)
	node->next = list;
80004c80:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80004c82:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80004c84:	40dc                	lw	a5,4(s1)
80004c86:	c380                	sw	s0,0(a5)
	list->tail = node;
80004c88:	c0c0                	sw	s0,4(s1)
80004c8a:	a891                	j	80004cde <z_add_timeout+0x146>
			__ASSERT(t->dticks >= 0, "");
80004c8c:	00892783          	lw	a5,8(s2)
80004c90:	0207d663          	bgez	a5,80004cbc <z_add_timeout+0x124>
80004c94:	ca8b0593          	addi	a1,s6,-856 # 80006ca8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ca9>
80004c98:	05600693          	li	a3,86
80004c9c:	c74a8613          	addi	a2,s5,-908 # 80006c74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c75>
80004ca0:	6c8b8513          	addi	a0,s7,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004ca4:	d0afd0ef          	jal	ra,800021ae <printk>
80004ca8:	74cc0513          	addi	a0,s8,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80004cac:	d02fd0ef          	jal	ra,800021ae <printk>
80004cb0:	05600593          	li	a1,86
80004cb4:	c74a8513          	addi	a0,s5,-908
80004cb8:	d14fd0ef          	jal	ra,800021cc <assert_post_action>

			if (t->dticks > to->dticks) {
80004cbc:	00892703          	lw	a4,8(s2)
80004cc0:	441c                	lw	a5,8(s0)
80004cc2:	08e7d763          	bge	a5,a4,80004d50 <z_add_timeout+0x1b8>
				t->dticks -= to->dticks;
80004cc6:	40f707b3          	sub	a5,a4,a5
80004cca:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80004cce:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004cd2:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80004cd6:	c05c                	sw	a5,4(s0)
	successor->prev->next = node;
80004cd8:	c380                	sw	s0,0(a5)
	successor->prev = node;
80004cda:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004cde:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004ce0:	00978963          	beq	a5,s1,80004cf2 <z_add_timeout+0x15a>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004ce4:	00f41763          	bne	s0,a5,80004cf2 <z_add_timeout+0x15a>
			z_clock_set_timeout(next_timeout(), false);
80004ce8:	e53ff0ef          	jal	ra,80004b3a <next_timeout>
80004cec:	4581                	li	a1,0
80004cee:	efafd0ef          	jal	ra,800023e8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004cf2:	ed4a0513          	addi	a0,s4,-300
80004cf6:	ae9ff0ef          	jal	ra,800047de <z_spin_unlock_valid>
80004cfa:	ed0d                	bnez	a0,80004d34 <z_add_timeout+0x19c>
80004cfc:	80006437          	lui	s0,0x80006
80004d00:	800065b7          	lui	a1,0x80006
80004d04:	80006537          	lui	a0,0x80006
80004d08:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004d0c:	06100693          	li	a3,97
80004d10:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004d14:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004d18:	c96fd0ef          	jal	ra,800021ae <printk>
80004d1c:	80006537          	lui	a0,0x80006
80004d20:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80004d24:	c8afd0ef          	jal	ra,800021ae <printk>
80004d28:	06100593          	li	a1,97
80004d2c:	79440513          	addi	a0,s0,1940
80004d30:	c9cfd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004d34:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80004d38:	50b2                	lw	ra,44(sp)
80004d3a:	5422                	lw	s0,40(sp)
80004d3c:	5492                	lw	s1,36(sp)
80004d3e:	5902                	lw	s2,32(sp)
80004d40:	49f2                	lw	s3,28(sp)
80004d42:	4a62                	lw	s4,24(sp)
80004d44:	4ad2                	lw	s5,20(sp)
80004d46:	4b42                	lw	s6,16(sp)
80004d48:	4bb2                	lw	s7,12(sp)
80004d4a:	4c22                	lw	s8,8(sp)
80004d4c:	6145                	addi	sp,sp,48
80004d4e:	8082                	ret
			to->dticks -= t->dticks;
80004d50:	8f99                	sub	a5,a5,a4
80004d52:	c41c                	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80004d54:	40dc                	lw	a5,4(s1)
80004d56:	f32784e3          	beq	a5,s2,80004c7e <z_add_timeout+0xe6>
80004d5a:	00092903          	lw	s2,0(s2)
80004d5e:	bf31                	j	80004c7a <z_add_timeout+0xe2>

80004d60 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004d60:	1101                	addi	sp,sp,-32
80004d62:	cc22                	sw	s0,24(sp)
80004d64:	c64e                	sw	s3,12(sp)
80004d66:	ce06                	sw	ra,28(sp)
80004d68:	ca26                	sw	s1,20(sp)
80004d6a:	c84a                	sw	s2,16(sp)
80004d6c:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004d6e:	4421                	li	s0,8
80004d70:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004d74:	800074b7          	lui	s1,0x80007
80004d78:	ed448513          	addi	a0,s1,-300 # 80006ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed5>
	key = (mstatus & SOC_MSTATUS_IEN);
80004d7c:	8821                	andi	s0,s0,8
80004d7e:	a47ff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80004d82:	ed0d                	bnez	a0,80004dbc <z_abort_timeout+0x5c>
80004d84:	80006937          	lui	s2,0x80006
80004d88:	800065b7          	lui	a1,0x80006
80004d8c:	80006537          	lui	a0,0x80006
80004d90:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80004d94:	04e00693          	li	a3,78
80004d98:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004d9c:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004da0:	c0efd0ef          	jal	ra,800021ae <printk>
80004da4:	80006537          	lui	a0,0x80006
80004da8:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80004dac:	c02fd0ef          	jal	ra,800021ae <printk>
80004db0:	04e00593          	li	a1,78
80004db4:	79490513          	addi	a0,s2,1940
80004db8:	c14fd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80004dbc:	ed448513          	addi	a0,s1,-300
80004dc0:	a41ff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80004dc4:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80004dc8:	5929                	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80004dca:	c789                	beqz	a5,80004dd4 <z_abort_timeout+0x74>
			remove_timeout(to);
80004dcc:	854e                	mv	a0,s3
80004dce:	d43ff0ef          	jal	ra,80004b10 <remove_timeout>
			ret = 0;
80004dd2:	4901                	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004dd4:	ed448513          	addi	a0,s1,-300
80004dd8:	a07ff0ef          	jal	ra,800047de <z_spin_unlock_valid>
80004ddc:	ed0d                	bnez	a0,80004e16 <z_abort_timeout+0xb6>
80004dde:	800064b7          	lui	s1,0x80006
80004de2:	800065b7          	lui	a1,0x80006
80004de6:	80006537          	lui	a0,0x80006
80004dea:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004dee:	06100693          	li	a3,97
80004df2:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004df6:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004dfa:	bb4fd0ef          	jal	ra,800021ae <printk>
80004dfe:	80006537          	lui	a0,0x80006
80004e02:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80004e06:	ba8fd0ef          	jal	ra,800021ae <printk>
80004e0a:	06100593          	li	a1,97
80004e0e:	79448513          	addi	a0,s1,1940
80004e12:	bbafd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004e16:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004e1a:	40f2                	lw	ra,28(sp)
80004e1c:	4462                	lw	s0,24(sp)
80004e1e:	854a                	mv	a0,s2
80004e20:	44d2                	lw	s1,20(sp)
80004e22:	4942                	lw	s2,16(sp)
80004e24:	49b2                	lw	s3,12(sp)
80004e26:	6105                	addi	sp,sp,32
80004e28:	8082                	ret

80004e2a <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80004e2a:	1141                	addi	sp,sp,-16
80004e2c:	c422                	sw	s0,8(sp)
80004e2e:	c606                	sw	ra,12(sp)
80004e30:	c226                	sw	s1,4(sp)
80004e32:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e34:	4421                	li	s0,8
80004e36:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e3a:	800074b7          	lui	s1,0x80007
80004e3e:	ed448513          	addi	a0,s1,-300 # 80006ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed5>
	key = (mstatus & SOC_MSTATUS_IEN);
80004e42:	8821                	andi	s0,s0,8
80004e44:	981ff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80004e48:	ed0d                	bnez	a0,80004e82 <z_get_next_timeout_expiry+0x58>
80004e4a:	80006937          	lui	s2,0x80006
80004e4e:	800065b7          	lui	a1,0x80006
80004e52:	80006537          	lui	a0,0x80006
80004e56:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80004e5a:	04e00693          	li	a3,78
80004e5e:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004e62:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004e66:	b48fd0ef          	jal	ra,800021ae <printk>
80004e6a:	80006537          	lui	a0,0x80006
80004e6e:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80004e72:	b3cfd0ef          	jal	ra,800021ae <printk>
80004e76:	04e00593          	li	a1,78
80004e7a:	79490513          	addi	a0,s2,1940
80004e7e:	b4efd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80004e82:	ed448513          	addi	a0,s1,-300
80004e86:	97bff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80004e8a:	cb1ff0ef          	jal	ra,80004b3a <next_timeout>
80004e8e:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004e90:	ed448513          	addi	a0,s1,-300
80004e94:	94bff0ef          	jal	ra,800047de <z_spin_unlock_valid>
80004e98:	ed0d                	bnez	a0,80004ed2 <z_get_next_timeout_expiry+0xa8>
80004e9a:	800064b7          	lui	s1,0x80006
80004e9e:	800065b7          	lui	a1,0x80006
80004ea2:	80006537          	lui	a0,0x80006
80004ea6:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004eaa:	06100693          	li	a3,97
80004eae:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004eb2:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004eb6:	af8fd0ef          	jal	ra,800021ae <printk>
80004eba:	80006537          	lui	a0,0x80006
80004ebe:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80004ec2:	aecfd0ef          	jal	ra,800021ae <printk>
80004ec6:	06100593          	li	a1,97
80004eca:	79448513          	addi	a0,s1,1940
80004ece:	afefd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004ed2:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80004ed6:	40b2                	lw	ra,12(sp)
80004ed8:	4422                	lw	s0,8(sp)
80004eda:	854a                	mv	a0,s2
80004edc:	4492                	lw	s1,4(sp)
80004ede:	4902                	lw	s2,0(sp)
80004ee0:	0141                	addi	sp,sp,16
80004ee2:	8082                	ret

80004ee4 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80004ee4:	1101                	addi	sp,sp,-32
80004ee6:	cc22                	sw	s0,24(sp)
80004ee8:	c84a                	sw	s2,16(sp)
80004eea:	c452                	sw	s4,8(sp)
80004eec:	ce06                	sw	ra,28(sp)
80004eee:	ca26                	sw	s1,20(sp)
80004ef0:	c64e                	sw	s3,12(sp)
80004ef2:	892a                	mv	s2,a0
80004ef4:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004ef6:	4421                	li	s0,8
80004ef8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004efc:	800074b7          	lui	s1,0x80007
80004f00:	ed448513          	addi	a0,s1,-300 # 80006ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed5>
	key = (mstatus & SOC_MSTATUS_IEN);
80004f04:	8821                	andi	s0,s0,8
80004f06:	8bfff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80004f0a:	ed0d                	bnez	a0,80004f44 <z_set_timeout_expiry+0x60>
80004f0c:	800069b7          	lui	s3,0x80006
80004f10:	800065b7          	lui	a1,0x80006
80004f14:	80006537          	lui	a0,0x80006
80004f18:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80004f1c:	04e00693          	li	a3,78
80004f20:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004f24:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004f28:	a86fd0ef          	jal	ra,800021ae <printk>
80004f2c:	80006537          	lui	a0,0x80006
80004f30:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80004f34:	a7afd0ef          	jal	ra,800021ae <printk>
80004f38:	04e00593          	li	a1,78
80004f3c:	79498513          	addi	a0,s3,1940
80004f40:	a8cfd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80004f44:	ed448513          	addi	a0,s1,-300
80004f48:	8b9ff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004f4c:	befff0ef          	jal	ra,80004b3a <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80004f50:	00a95963          	bge	s2,a0,80004f62 <z_set_timeout_expiry+0x7e>
80004f54:	4785                	li	a5,1
80004f56:	00a7d663          	bge	a5,a0,80004f62 <z_set_timeout_expiry+0x7e>
			z_clock_set_timeout(ticks, idle);
80004f5a:	85d2                	mv	a1,s4
80004f5c:	854a                	mv	a0,s2
80004f5e:	c8afd0ef          	jal	ra,800023e8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004f62:	ed448513          	addi	a0,s1,-300
80004f66:	879ff0ef          	jal	ra,800047de <z_spin_unlock_valid>
80004f6a:	ed0d                	bnez	a0,80004fa4 <z_set_timeout_expiry+0xc0>
80004f6c:	800064b7          	lui	s1,0x80006
80004f70:	800065b7          	lui	a1,0x80006
80004f74:	80006537          	lui	a0,0x80006
80004f78:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80004f7c:	06100693          	li	a3,97
80004f80:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004f84:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80004f88:	a26fd0ef          	jal	ra,800021ae <printk>
80004f8c:	80006537          	lui	a0,0x80006
80004f90:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80004f94:	a1afd0ef          	jal	ra,800021ae <printk>
80004f98:	06100593          	li	a1,97
80004f9c:	79448513          	addi	a0,s1,1940
80004fa0:	a2cfd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004fa4:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80004fa8:	40f2                	lw	ra,28(sp)
80004faa:	4462                	lw	s0,24(sp)
80004fac:	44d2                	lw	s1,20(sp)
80004fae:	4942                	lw	s2,16(sp)
80004fb0:	49b2                	lw	s3,12(sp)
80004fb2:	4a22                	lw	s4,8(sp)
80004fb4:	6105                	addi	sp,sp,32
80004fb6:	8082                	ret

80004fb8 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80004fb8:	7179                	addi	sp,sp,-48
80004fba:	d422                	sw	s0,40(sp)
80004fbc:	cc52                	sw	s4,24(sp)
80004fbe:	d606                	sw	ra,44(sp)
80004fc0:	d226                	sw	s1,36(sp)
80004fc2:	d04a                	sw	s2,32(sp)
80004fc4:	ce4e                	sw	s3,28(sp)
80004fc6:	ca56                	sw	s5,20(sp)
80004fc8:	c85a                	sw	s6,16(sp)
80004fca:	c65e                	sw	s7,12(sp)
80004fcc:	c462                	sw	s8,8(sp)
80004fce:	c266                	sw	s9,4(sp)
80004fd0:	c06a                	sw	s10,0(sp)
80004fd2:	8a2a                	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004fd4:	4421                	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80004fd6:	9d9fe0ef          	jal	ra,800039ae <z_time_slice>
80004fda:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004fde:	80007937          	lui	s2,0x80007
80004fe2:	ed490513          	addi	a0,s2,-300 # 80006ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed5>
	key = (mstatus & SOC_MSTATUS_IEN);
80004fe6:	8821                	andi	s0,s0,8
80004fe8:	fdcff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80004fec:	ed0d                	bnez	a0,80005026 <z_clock_announce+0x6e>
80004fee:	800064b7          	lui	s1,0x80006
80004ff2:	800065b7          	lui	a1,0x80006
80004ff6:	80006537          	lui	a0,0x80006
80004ffa:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80004ffe:	04e00693          	li	a3,78
80005002:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80005006:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000500a:	9a4fd0ef          	jal	ra,800021ae <printk>
8000500e:	80006537          	lui	a0,0x80006
80005012:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80005016:	998fd0ef          	jal	ra,800021ae <printk>
8000501a:	04e00593          	li	a1,78
8000501e:	79448513          	addi	a0,s1,1940
80005022:	9aafd0ef          	jal	ra,800021cc <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80005026:	800079b7          	lui	s3,0x80007
	z_spin_lock_set_owner(l);
8000502a:	ed490513          	addi	a0,s2,-300
8000502e:	fd2ff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
80005032:	800074b7          	lui	s1,0x80007
80005036:	ed49a823          	sw	s4,-304(s3) # 80006ed0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed1>
	return list->head == list;
8000503a:	80007a37          	lui	s4,0x80007
8000503e:	ed098993          	addi	s3,s3,-304
80005042:	e3ca0a13          	addi	s4,s4,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
80005046:	e9848493          	addi	s1,s1,-360 # 80006e98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e99>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000504a:	80006ab7          	lui	s5,0x80006
8000504e:	80006bb7          	lui	s7,0x80006
80005052:	80006b37          	lui	s6,0x80006
80005056:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000505a:	80006cb7          	lui	s9,0x80006
8000505e:	000a2d03          	lw	s10,0(s4)
80005062:	0009a783          	lw	a5,0(s3)
80005066:	4094                	lw	a3,0(s1)
80005068:	40c8                	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000506a:	014d0b63          	beq	s10,s4,80005080 <z_clock_announce+0xc8>

	while (first() != NULL && first()->dticks <= announce_remaining) {
8000506e:	000d0963          	beqz	s10,80005080 <z_clock_announce+0xc8>
80005072:	008d2703          	lw	a4,8(s10)
80005076:	08e7d663          	bge	a5,a4,80005102 <z_clock_announce+0x14a>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
8000507a:	8f1d                	sub	a4,a4,a5
8000507c:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80005080:	96be                	add	a3,a3,a5
80005082:	41f7d713          	srai	a4,a5,0x1f
80005086:	972a                	add	a4,a4,a0
80005088:	00f6b7b3          	sltu	a5,a3,a5
8000508c:	97ba                	add	a5,a5,a4
8000508e:	c094                	sw	a3,0(s1)
80005090:	c0dc                	sw	a5,4(s1)
	announce_remaining = 0;
80005092:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80005096:	aa5ff0ef          	jal	ra,80004b3a <next_timeout>
8000509a:	4581                	li	a1,0
8000509c:	b4cfd0ef          	jal	ra,800023e8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800050a0:	ed490513          	addi	a0,s2,-300
800050a4:	f3aff0ef          	jal	ra,800047de <z_spin_unlock_valid>
800050a8:	ed0d                	bnez	a0,800050e2 <z_clock_announce+0x12a>
800050aa:	800064b7          	lui	s1,0x80006
800050ae:	800065b7          	lui	a1,0x80006
800050b2:	80006537          	lui	a0,0x80006
800050b6:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
800050ba:	06100693          	li	a3,97
800050be:	79448613          	addi	a2,s1,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800050c2:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800050c6:	8e8fd0ef          	jal	ra,800021ae <printk>
800050ca:	80006537          	lui	a0,0x80006
800050ce:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
800050d2:	8dcfd0ef          	jal	ra,800021ae <printk>
800050d6:	06100593          	li	a1,97
800050da:	79448513          	addi	a0,s1,1940
800050de:	8eefd0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800050e2:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800050e6:	50b2                	lw	ra,44(sp)
800050e8:	5422                	lw	s0,40(sp)
800050ea:	5492                	lw	s1,36(sp)
800050ec:	5902                	lw	s2,32(sp)
800050ee:	49f2                	lw	s3,28(sp)
800050f0:	4a62                	lw	s4,24(sp)
800050f2:	4ad2                	lw	s5,20(sp)
800050f4:	4b42                	lw	s6,16(sp)
800050f6:	4bb2                	lw	s7,12(sp)
800050f8:	4c22                	lw	s8,8(sp)
800050fa:	4c92                	lw	s9,4(sp)
800050fc:	4d02                	lw	s10,0(sp)
800050fe:	6145                	addi	sp,sp,48
80005100:	8082                	ret
		curr_tick += dt;
80005102:	96ba                	add	a3,a3,a4
80005104:	41f75593          	srai	a1,a4,0x1f
80005108:	95aa                	add	a1,a1,a0
8000510a:	00e6b633          	sltu	a2,a3,a4
8000510e:	962e                	add	a2,a2,a1
		announce_remaining -= dt;
80005110:	8f99                	sub	a5,a5,a4
		remove_timeout(t);
80005112:	856a                	mv	a0,s10
		t->dticks = 0;
80005114:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80005118:	c094                	sw	a3,0(s1)
8000511a:	c0d0                	sw	a2,4(s1)
		announce_remaining -= dt;
8000511c:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80005120:	9f1ff0ef          	jal	ra,80004b10 <remove_timeout>
80005124:	ed490513          	addi	a0,s2,-300
80005128:	eb6ff0ef          	jal	ra,800047de <z_spin_unlock_valid>
8000512c:	e50d                	bnez	a0,80005156 <z_clock_announce+0x19e>
8000512e:	7dcb8593          	addi	a1,s7,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005132:	06100693          	li	a3,97
80005136:	794a8613          	addi	a2,s5,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
8000513a:	6c8b0513          	addi	a0,s6,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000513e:	870fd0ef          	jal	ra,800021ae <printk>
80005142:	7f4c0513          	addi	a0,s8,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80005146:	868fd0ef          	jal	ra,800021ae <printk>
8000514a:	06100593          	li	a1,97
8000514e:	794a8513          	addi	a0,s5,1940
80005152:	87afd0ef          	jal	ra,800021cc <assert_post_action>
80005156:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
8000515a:	00cd2783          	lw	a5,12(s10)
8000515e:	856a                	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005160:	4421                	li	s0,8
80005162:	9782                	jalr	a5
80005164:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005168:	ed490513          	addi	a0,s2,-300
	key = (mstatus & SOC_MSTATUS_IEN);
8000516c:	8821                	andi	s0,s0,8
8000516e:	e56ff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80005172:	e51d                	bnez	a0,800051a0 <z_clock_announce+0x1e8>
80005174:	7acc8593          	addi	a1,s9,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
80005178:	04e00693          	li	a3,78
8000517c:	794a8613          	addi	a2,s5,1940
80005180:	6c8b0513          	addi	a0,s6,1736
80005184:	82afd0ef          	jal	ra,800021ae <printk>
80005188:	80006537          	lui	a0,0x80006
8000518c:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
80005190:	81efd0ef          	jal	ra,800021ae <printk>
80005194:	04e00593          	li	a1,78
80005198:	794a8513          	addi	a0,s5,1940
8000519c:	830fd0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
800051a0:	ed490513          	addi	a0,s2,-300
800051a4:	e5cff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	return k;
800051a8:	bd5d                	j	8000505e <z_clock_announce+0xa6>

800051aa <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
800051aa:	1101                	addi	sp,sp,-32
800051ac:	ca26                	sw	s1,20(sp)
800051ae:	ce06                	sw	ra,28(sp)
800051b0:	cc22                	sw	s0,24(sp)
800051b2:	c84a                	sw	s2,16(sp)
800051b4:	c64e                	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800051b6:	44a1                	li	s1,8
800051b8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800051bc:	80007937          	lui	s2,0x80007
800051c0:	ed490513          	addi	a0,s2,-300 # 80006ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed5>
	key = (mstatus & SOC_MSTATUS_IEN);
800051c4:	88a1                	andi	s1,s1,8
800051c6:	dfeff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
800051ca:	ed0d                	bnez	a0,80005204 <z_tick_get+0x5a>
800051cc:	80006437          	lui	s0,0x80006
800051d0:	800065b7          	lui	a1,0x80006
800051d4:	80006537          	lui	a0,0x80006
800051d8:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
800051dc:	04e00693          	li	a3,78
800051e0:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800051e4:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800051e8:	fc7fc0ef          	jal	ra,800021ae <printk>
800051ec:	80006537          	lui	a0,0x80006
800051f0:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
800051f4:	fbbfc0ef          	jal	ra,800021ae <printk>
800051f8:	04e00593          	li	a1,78
800051fc:	79440513          	addi	a0,s0,1940
80005200:	fcdfc0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
80005204:	ed490513          	addi	a0,s2,-300
80005208:	df8ff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
8000520c:	b28fd0ef          	jal	ra,80002534 <z_clock_elapsed>
80005210:	800077b7          	lui	a5,0x80007
80005214:	e9878793          	addi	a5,a5,-360 # 80006e98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e99>
80005218:	0007a983          	lw	s3,0(a5)
8000521c:	43c0                	lw	s0,4(a5)
8000521e:	99aa                	add	s3,s3,a0
80005220:	00a9b533          	sltu	a0,s3,a0
80005224:	942a                	add	s0,s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005226:	ed490513          	addi	a0,s2,-300
8000522a:	db4ff0ef          	jal	ra,800047de <z_spin_unlock_valid>
8000522e:	ed0d                	bnez	a0,80005268 <z_tick_get+0xbe>
80005230:	80006937          	lui	s2,0x80006
80005234:	800065b7          	lui	a1,0x80006
80005238:	80006537          	lui	a0,0x80006
8000523c:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005240:	06100693          	li	a3,97
80005244:	79490613          	addi	a2,s2,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80005248:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
8000524c:	f63fc0ef          	jal	ra,800021ae <printk>
80005250:	80006537          	lui	a0,0x80006
80005254:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
80005258:	f57fc0ef          	jal	ra,800021ae <printk>
8000525c:	06100593          	li	a1,97
80005260:	79490513          	addi	a0,s2,1940
80005264:	f69fc0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005268:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
8000526c:	85a2                	mv	a1,s0
8000526e:	40f2                	lw	ra,28(sp)
80005270:	4462                	lw	s0,24(sp)
80005272:	854e                	mv	a0,s3
80005274:	44d2                	lw	s1,20(sp)
80005276:	4942                	lw	s2,16(sp)
80005278:	49b2                	lw	s3,12(sp)
8000527a:	6105                	addi	sp,sp,32
8000527c:	8082                	ret

8000527e <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
8000527e:	1141                	addi	sp,sp,-16
80005280:	c606                	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80005282:	f29ff0ef          	jal	ra,800051aa <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80005286:	40b2                	lw	ra,12(sp)
80005288:	0141                	addi	sp,sp,16
8000528a:	8082                	ret

8000528c <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
8000528c:	1141                	addi	sp,sp,-16
8000528e:	c606                	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
80005290:	f1bff0ef          	jal	ra,800051aa <z_tick_get>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80005294:	3e800613          	li	a2,1000
80005298:	4681                	li	a3,0
8000529a:	db6fb0ef          	jal	ra,80000850 <__muldi3>
8000529e:	06400613          	li	a2,100
800052a2:	4681                	li	a3,0
800052a4:	fb5fa0ef          	jal	ra,80000258 <__udivdi3>
}
800052a8:	40b2                	lw	ra,12(sp)
800052aa:	0141                	addi	sp,sp,16
800052ac:	8082                	ret

800052ae <k_timer_init>:
800052ae:	01050793          	addi	a5,a0,16

void k_timer_init(struct k_timer *timer,
			 k_timer_expiry_t expiry_fn,
			 k_timer_stop_t stop_fn)
{
	timer->expiry_fn = expiry_fn;
800052b2:	cd0c                	sw	a1,24(a0)
	timer->stop_fn = stop_fn;
800052b4:	cd50                	sw	a2,28(a0)
	timer->status = 0U;
800052b6:	02052223          	sw	zero,36(a0)
	list->head = (sys_dnode_t *)list;
800052ba:	c91c                	sw	a5,16(a0)
	list->tail = (sys_dnode_t *)list;
800052bc:	c95c                	sw	a5,20(a0)
	node->next = NULL;
800052be:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800052c2:	00052223          	sw	zero,4(a0)

	z_waitq_init(&timer->wait_q);
	z_init_timeout(&timer->timeout, z_timer_expiration_handler);
	SYS_TRACING_OBJ_INIT(k_timer, timer);

	timer->user_data = NULL;
800052c6:	02052423          	sw	zero,40(a0)

	z_object_init(timer);
}
800052ca:	8082                	ret

800052cc <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
800052cc:	1141                	addi	sp,sp,-16
800052ce:	c422                	sw	s0,8(sp)
800052d0:	c226                	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800052d2:	80007437          	lui	s0,0x80007
800052d6:	800074b7          	lui	s1,0x80007
{
800052da:	c606                	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800052dc:	e7c40413          	addi	s0,s0,-388 # 80006e7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e7d>
800052e0:	e7c48493          	addi	s1,s1,-388 # 80006e7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e7d>
800052e4:	00946863          	bltu	s0,s1,800052f4 <init_static_pools+0x28>
		k_mem_pool_init(p);
	}

	return 0;
}
800052e8:	40b2                	lw	ra,12(sp)
800052ea:	4422                	lw	s0,8(sp)
800052ec:	4492                	lw	s1,4(sp)
800052ee:	4501                	li	a0,0
800052f0:	0141                	addi	sp,sp,16
800052f2:	8082                	ret
800052f4:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
800052f8:	8522                	mv	a0,s0
	list->head = (sys_dnode_t *)list;
800052fa:	c85c                	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
800052fc:	cc1c                	sw	a5,24(s0)
800052fe:	d6afc0ef          	jal	ra,80001868 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005302:	0471                	addi	s0,s0,28
80005304:	b7c5                	j	800052e4 <init_static_pools+0x18>

80005306 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80005306:	800077b7          	lui	a5,0x80007
8000530a:	50c7a783          	lw	a5,1292(a5) # 8000750c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000750d>
{
8000530e:	715d                	addi	sp,sp,-80
80005310:	c4a2                	sw	s0,72(sp)
80005312:	c2a6                	sw	s1,68(sp)
80005314:	de4e                	sw	s3,60(sp)
80005316:	d85a                	sw	s6,48(sp)
80005318:	c686                	sw	ra,76(sp)
8000531a:	c0ca                	sw	s2,64(sp)
8000531c:	dc52                	sw	s4,56(sp)
8000531e:	da56                	sw	s5,52(sp)
80005320:	d65e                	sw	s7,44(sp)
80005322:	d462                	sw	s8,40(sp)
80005324:	d266                	sw	s9,36(sp)
80005326:	d06a                	sw	s10,32(sp)
80005328:	ce6e                	sw	s11,28(sp)
8000532a:	89aa                	mv	s3,a0
8000532c:	84ae                	mv	s1,a1
8000532e:	8b32                	mv	s6,a2
80005330:	8436                	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80005332:	10078063          	beqz	a5,80005432 <k_mem_pool_alloc+0x12c>
80005336:	e2f1                	bnez	a3,800053fa <k_mem_pool_alloc+0xf4>
	s64_t end = 0;
80005338:	4901                	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
8000533a:	80007537          	lui	a0,0x80007
8000533e:	e7c50513          	addi	a0,a0,-388 # 80006e7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e7d>
80005342:	40a98533          	sub	a0,s3,a0
80005346:	b6db75b7          	lui	a1,0xb6db7
8000534a:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
8000534e:	8509                	srai	a0,a0,0x2
80005350:	cdcfb0ef          	jal	ra,8000082c <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
80005354:	7a7d                	lui	s4,0xfffff
		block->id.block = block_num;
80005356:	6a85                	lui	s5,0x1
		block->id.pool = pool_id(p);
80005358:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
8000535c:	5bd5                	li	s7,-11
			ret = -ENOMEM;
8000535e:	5cd1                	li	s9,-12
		block->id.level = level_num;
80005360:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80005364:	1afd                	addi	s5,s5,-1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005366:	4d21                	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
80005368:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
8000536c:	8726                	mv	a4,s1
8000536e:	0074                	addi	a3,sp,12
80005370:	0030                	addi	a2,sp,8
80005372:	85da                	mv	a1,s6
80005374:	854e                	mv	a0,s3
80005376:	dbafc0ef          	jal	ra,80001930 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
8000537a:	01751c63          	bne	a0,s7,80005392 <k_mem_pool_alloc+0x8c>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
8000537e:	8726                	mv	a4,s1
80005380:	0074                	addi	a3,sp,12
80005382:	0030                	addi	a2,sp,8
80005384:	85da                	mv	a1,s6
80005386:	854e                	mv	a0,s3
80005388:	da8fc0ef          	jal	ra,80001930 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
8000538c:	01751363          	bne	a0,s7,80005392 <k_mem_pool_alloc+0x8c>
			ret = -ENOMEM;
80005390:	5551                	li	a0,-12
		block->id.level = level_num;
80005392:	47a2                	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80005394:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
80005398:	8bbd                	andi	a5,a5,15
8000539a:	00879713          	slli	a4,a5,0x8
8000539e:	40dc                	lw	a5,4(s1)
800053a0:	0147f7b3          	and	a5,a5,s4
800053a4:	8fd9                	or	a5,a5,a4
		block->id.block = block_num;
800053a6:	4732                	lw	a4,12(sp)
800053a8:	0157f7b3          	and	a5,a5,s5
800053ac:	0732                	slli	a4,a4,0xc
800053ae:	8fd9                	or	a5,a5,a4
800053b0:	c0dc                	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
800053b2:	c50d                	beqz	a0,800053dc <k_mem_pool_alloc+0xd6>
800053b4:	c405                	beqz	s0,800053dc <k_mem_pool_alloc+0xd6>
800053b6:	03951363          	bne	a0,s9,800053dc <k_mem_pool_alloc+0xd6>
800053ba:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
800053be:	8622                	mv	a2,s0
800053c0:	85ee                	mv	a1,s11
800053c2:	8921                	andi	a0,a0,8
800053c4:	80bfe0ef          	jal	ra,80003bce <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
800053c8:	57fd                	li	a5,-1
800053ca:	faf401e3          	beq	s0,a5,8000536c <k_mem_pool_alloc+0x66>
			timeout = end - z_tick_get();
800053ce:	dddff0ef          	jal	ra,800051aa <z_tick_get>
800053d2:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
800053d6:	f8045be3          	bgez	s0,8000536c <k_mem_pool_alloc+0x66>
				break;
			}
		}
	}

	return -EAGAIN;
800053da:	5555                	li	a0,-11
}
800053dc:	40b6                	lw	ra,76(sp)
800053de:	4426                	lw	s0,72(sp)
800053e0:	4496                	lw	s1,68(sp)
800053e2:	4906                	lw	s2,64(sp)
800053e4:	59f2                	lw	s3,60(sp)
800053e6:	5a62                	lw	s4,56(sp)
800053e8:	5ad2                	lw	s5,52(sp)
800053ea:	5b42                	lw	s6,48(sp)
800053ec:	5bb2                	lw	s7,44(sp)
800053ee:	5c22                	lw	s8,40(sp)
800053f0:	5c92                	lw	s9,36(sp)
800053f2:	5d02                	lw	s10,32(sp)
800053f4:	4df2                	lw	s11,28(sp)
800053f6:	6161                	addi	sp,sp,80
800053f8:	8082                	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800053fa:	80007937          	lui	s2,0x80007
800053fe:	800075b7          	lui	a1,0x80007
80005402:	80006537          	lui	a0,0x80006
80005406:	ccc58593          	addi	a1,a1,-820 # 80006ccc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ccd>
8000540a:	03900693          	li	a3,57
8000540e:	cb890613          	addi	a2,s2,-840 # 80006cb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb9>
80005412:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80005416:	d99fc0ef          	jal	ra,800021ae <printk>
8000541a:	80006537          	lui	a0,0x80006
8000541e:	74c50513          	addi	a0,a0,1868 # 8000674c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000674d>
80005422:	d8dfc0ef          	jal	ra,800021ae <printk>
80005426:	03900593          	li	a1,57
8000542a:	cb890513          	addi	a0,s2,-840
8000542e:	d9ffc0ef          	jal	ra,800021cc <assert_post_action>
	if (timeout > 0) {
80005432:	f08053e3          	blez	s0,80005338 <k_mem_pool_alloc+0x32>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80005436:	d75ff0ef          	jal	ra,800051aa <z_tick_get>
8000543a:	892a                	mv	s2,a0
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
8000543c:	45a9                	li	a1,10
8000543e:	00940513          	addi	a0,s0,9
80005442:	c9efb0ef          	jal	ra,800008e0 <__divsi3>
80005446:	992a                	add	s2,s2,a0
80005448:	bdcd                	j	8000533a <k_mem_pool_alloc+0x34>

8000544a <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
8000544a:	00054783          	lbu	a5,0(a0)
{
8000544e:	1101                	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005450:	4110                	lw	a2,0(a0)
{
80005452:	cc22                	sw	s0,24(sp)
80005454:	00379413          	slli	s0,a5,0x3
80005458:	c84a                	sw	s2,16(sp)
8000545a:	8c1d                	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
8000545c:	80007937          	lui	s2,0x80007
80005460:	040a                	slli	s0,s0,0x2
80005462:	00865593          	srli	a1,a2,0x8
80005466:	e7c90513          	addi	a0,s2,-388 # 80006e7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e7d>
8000546a:	8231                	srli	a2,a2,0xc
8000546c:	89bd                	andi	a1,a1,15
8000546e:	9522                	add	a0,a0,s0
{
80005470:	ce06                	sw	ra,28(sp)
80005472:	ca26                	sw	s1,20(sp)
80005474:	c64e                	sw	s3,12(sp)
80005476:	c452                	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005478:	ec8fc0ef          	jal	ra,80001b40 <z_sys_mem_pool_block_free>
8000547c:	45a1                	li	a1,8
8000547e:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005482:	800074b7          	lui	s1,0x80007
80005486:	ed848513          	addi	a0,s1,-296 # 80006ed8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ed9>
	key = (mstatus & SOC_MSTATUS_IEN);
8000548a:	0085f993          	andi	s3,a1,8
8000548e:	b36ff0ef          	jal	ra,800047c4 <z_spin_lock_valid>
80005492:	e7c90913          	addi	s2,s2,-388
80005496:	ed0d                	bnez	a0,800054d0 <k_mem_pool_free_id+0x86>
80005498:	80006a37          	lui	s4,0x80006
8000549c:	800065b7          	lui	a1,0x80006
800054a0:	80006537          	lui	a0,0x80006
800054a4:	7ac58593          	addi	a1,a1,1964 # 800067ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067ad>
800054a8:	04e00693          	li	a3,78
800054ac:	794a0613          	addi	a2,s4,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800054b0:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
800054b4:	cfbfc0ef          	jal	ra,800021ae <printk>
800054b8:	80006537          	lui	a0,0x80006
800054bc:	7c450513          	addi	a0,a0,1988 # 800067c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c5>
800054c0:	ceffc0ef          	jal	ra,800021ae <printk>
800054c4:	04e00593          	li	a1,78
800054c8:	794a0513          	addi	a0,s4,1940
800054cc:	d01fc0ef          	jal	ra,800021cc <assert_post_action>
	z_spin_lock_set_owner(l);
800054d0:	ed848513          	addi	a0,s1,-296
800054d4:	b2cff0ef          	jal	ra,80004800 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
800054d8:	01440513          	addi	a0,s0,20
800054dc:	954a                	add	a0,a0,s2
800054de:	a9dfe0ef          	jal	ra,80003f7a <z_unpend_all>

	if (need_sched != 0) {
800054e2:	cd09                	beqz	a0,800054fc <k_mem_pool_free_id+0xb2>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
800054e4:	4462                	lw	s0,24(sp)
800054e6:	40f2                	lw	ra,28(sp)
800054e8:	4942                	lw	s2,16(sp)
800054ea:	4a22                	lw	s4,8(sp)
		z_reschedule(&lock, key);
800054ec:	85ce                	mv	a1,s3
800054ee:	ed848513          	addi	a0,s1,-296
}
800054f2:	49b2                	lw	s3,12(sp)
800054f4:	44d2                	lw	s1,20(sp)
800054f6:	6105                	addi	sp,sp,32
		z_reschedule(&lock, key);
800054f8:	bb3fd06f          	j	800030aa <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800054fc:	ed848513          	addi	a0,s1,-296
80005500:	adeff0ef          	jal	ra,800047de <z_spin_unlock_valid>
80005504:	ed0d                	bnez	a0,8000553e <k_mem_pool_free_id+0xf4>
80005506:	80006437          	lui	s0,0x80006
8000550a:	800065b7          	lui	a1,0x80006
8000550e:	80006537          	lui	a0,0x80006
80005512:	7dc58593          	addi	a1,a1,2012 # 800067dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067dd>
80005516:	06100693          	li	a3,97
8000551a:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
8000551e:	6c850513          	addi	a0,a0,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80005522:	c8dfc0ef          	jal	ra,800021ae <printk>
80005526:	80006537          	lui	a0,0x80006
8000552a:	7f450513          	addi	a0,a0,2036 # 800067f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067f5>
8000552e:	c81fc0ef          	jal	ra,800021ae <printk>
80005532:	06100593          	li	a1,97
80005536:	79440513          	addi	a0,s0,1940
8000553a:	c93fc0ef          	jal	ra,800021cc <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000553e:	3009a5f3          	csrrs	a1,mstatus,s3
}
80005542:	40f2                	lw	ra,28(sp)
80005544:	4462                	lw	s0,24(sp)
80005546:	44d2                	lw	s1,20(sp)
80005548:	4942                	lw	s2,16(sp)
8000554a:	49b2                	lw	s3,12(sp)
8000554c:	4a22                	lw	s4,8(sp)
8000554e:	6105                	addi	sp,sp,32
80005550:	8082                	ret

80005552 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
80005552:	00458613          	addi	a2,a1,4
80005556:	00b67863          	bgeu	a2,a1,80005566 <k_mem_pool_malloc+0x14>
				   &size)) {
		return NULL;
8000555a:	4501                	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
8000555c:	8082                	ret
		return NULL;
8000555e:	4501                	li	a0,0
}
80005560:	40f2                	lw	ra,28(sp)
80005562:	6105                	addi	sp,sp,32
80005564:	8082                	ret
{
80005566:	1101                	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80005568:	4681                	li	a3,0
8000556a:	002c                	addi	a1,sp,8
{
8000556c:	ce06                	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
8000556e:	d99ff0ef          	jal	ra,80005306 <k_mem_pool_alloc>
80005572:	f575                	bnez	a0,8000555e <k_mem_pool_malloc+0xc>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
80005574:	4522                	lw	a0,8(sp)
80005576:	4611                	li	a2,4
80005578:	006c                	addi	a1,sp,12
8000557a:	8a6fd0ef          	jal	ra,80002620 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
8000557e:	4522                	lw	a0,8(sp)
80005580:	0511                	addi	a0,a0,4
80005582:	bff9                	j	80005560 <k_mem_pool_malloc+0xe>

80005584 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
80005584:	c501                	beqz	a0,8000558c <k_free+0x8>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
80005586:	1571                	addi	a0,a0,-4
80005588:	ec3ff06f          	j	8000544a <k_mem_pool_free_id>
	}
}
8000558c:	8082                	ret

8000558e <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
8000558e:	800077b7          	lui	a5,0x80007
80005592:	5147a783          	lw	a5,1300(a5) # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
{
80005596:	85aa                	mv	a1,a0
	if (_current->resource_pool != NULL) {
80005598:	57a8                	lw	a0,104(a5)
8000559a:	c119                	beqz	a0,800055a0 <z_thread_malloc+0x12>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
8000559c:	fb7ff06f          	j	80005552 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
800055a0:	4501                	li	a0,0
800055a2:	8082                	ret

800055a4 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
800055a4:	8082                	ret
