
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01428293          	addi	t0,t0,20 # 80000014 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	1790006f          	j	80000984 <__initialize>
	...

Disassembly of section exceptions:

80000014 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000014:	715d                	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000016:	c006                	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	c20e                	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001a:	c412                	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
8000001c:	c616                	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
8000001e:	c81a                	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000020:	ca1e                	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
80000022:	cc72                	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000024:	ce76                	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000026:	d07a                	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000028:	d27e                	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000002a:	d42a                	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
8000002c:	d62e                	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
8000002e:	d832                	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000030:	da36                	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
80000032:	dc3a                	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000034:	de3e                	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000036:	c0c2                	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000038:	c2c6                	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000003a:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000003e:	c496                	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000040:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000044:	c696                	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
80000046:	1ae000ef          	jal	ra,800001f4 <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
8000004a:	00000313          	li	t1,0
	bnez a0, is_interrupt
8000004e:	e905                	bnez	a0,8000007e <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000050:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
80000054:	800003b7          	lui	t2,0x80000
80000058:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
8000005c:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000060:	432d                	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
80000062:	00628a63          	beq	t0,t1,80000076 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000066:	00010513          	mv	a0,sp
	la ra, no_reschedule
8000006a:	00000097          	auipc	ra,0x0
8000006e:	11e08093          	addi	ra,ra,286 # 80000188 <no_reschedule>
	tail _Fault
80000072:	5750006f          	j	80000de6 <_Fault>

80000076 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000076:	42a6                	lw	t0,72(sp)
	addi t0, t0, 4
80000078:	0291                	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000007a:	c496                	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
8000007c:	a041                	j	800000fc <reschedule>

8000007e <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
8000007e:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
80000082:	00006397          	auipc	t2,0x6
80000086:	af238393          	addi	t2,t2,-1294 # 80005b74 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
8000008a:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
8000008e:	1141                	addi	sp,sp,-16
	sw t0, 0x00(sp)
80000090:	c016                	sw	t0,0(sp)

80000092 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
80000092:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
80000096:	0e05                	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
80000098:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
8000009c:	00030863          	beqz	t1,800000ac <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000a0:	00000097          	auipc	ra,0x0
800000a4:	03808093          	addi	ra,ra,56 # 800000d8 <on_thread_stack>
	tail z_irq_do_offload
800000a8:	5a50006f          	j	80000e4c <z_irq_do_offload>

800000ac <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000ac:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000b0:	800002b7          	lui	t0,0x80000
800000b4:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000b8:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000bc:	128000ef          	jal	ra,800001e4 <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000c0:	00005297          	auipc	t0,0x5
800000c4:	95828293          	addi	t0,t0,-1704 # 80004a18 <_sw_isr_table>
	slli a0, a0, 3
800000c8:	050e                	slli	a0,a0,0x3
	add t0, t0, a0
800000ca:	92aa                	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
800000cc:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
800000d0:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
800000d4:	000300e7          	jalr	t1

800000d8 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
800000d8:	00006317          	auipc	t1,0x6
800000dc:	a9c30313          	addi	t1,t1,-1380 # 80005b74 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
800000e0:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
800000e4:	13fd                	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
800000e6:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
800000ea:	4282                	lw	t0,0(sp)
	addi sp, t0, 0
800000ec:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
800000f0:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
800000f4:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
800000f8:	087e0863          	beq	t3,t2,80000188 <no_reschedule>

800000fc <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
800000fc:	00006297          	auipc	t0,0x6
80000100:	a7828293          	addi	t0,t0,-1416 # 80005b74 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000104:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000108:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000010c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000110:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000114:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000118:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000011c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000120:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000124:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000128:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000012c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000130:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000134:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000138:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000013c:	00005397          	auipc	t2,0x5
80000140:	69c38393          	addi	t2,t2,1692 # 800057d8 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000144:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000148:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000014c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000150:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000154:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000158:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000015c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
80000160:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
80000164:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
80000168:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
8000016c:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
80000170:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
80000174:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
80000178:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
8000017c:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
80000180:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
80000184:	05832d83          	lw	s11,88(t1)

80000188 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000188:	42a6                	lw	t0,72(sp)
	csrw mepc, t0
8000018a:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
8000018e:	42b6                	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
80000190:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
80000194:	4082                	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
80000196:	4192                	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
80000198:	4222                	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
8000019a:	42b2                	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
8000019c:	4342                	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
8000019e:	43d2                	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001a0:	4e62                	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001a2:	4ef2                	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001a4:	5f02                	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001a6:	5f92                	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
800001a8:	5522                	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
800001aa:	55b2                	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
800001ac:	5642                	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
800001ae:	56d2                	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
800001b0:	5762                	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
800001b2:	57f2                	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
800001b4:	4806                	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
800001b6:	4896                	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
800001b8:	6161                	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
800001ba:	30200073          	mret
	...

800001c0 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
800001c0:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
800001c4:	00006297          	auipc	t0,0x6
800001c8:	9b028293          	addi	t0,t0,-1616 # 80005b74 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
800001cc:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
800001d0:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
800001d4:	8921                	andi	a0,a0,8
	csrrs t0, mstatus, a0
800001d6:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
800001da:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
800001de:	00008067          	ret
	...

800001e4 <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
800001e4:	4305                	li	t1,1
	sll t0, t1, a0
800001e6:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
800001ea:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
800001ee:	00008067          	ret
	...

800001f4 <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
800001f4:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
800001f8:	80000337          	lui	t1,0x80000
	and t0, t0, t1
800001fc:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000200:	00000513          	li	a0,0
	beqz t0, not_interrupt
80000204:	00028363          	beqz	t0,8000020a <not_interrupt>
	addi a0, a0, 1
80000208:	0505                	addi	a0,a0,1

8000020a <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
8000020a:	00008067          	ret

Disassembly of section text:

80000210 <__lshrdi3>:
80000210:	02060063          	beqz	a2,80000230 <__lshrdi3+0x20>
80000214:	02000793          	li	a5,32
80000218:	40c787b3          	sub	a5,a5,a2
8000021c:	00f04c63          	bgtz	a5,80000234 <__lshrdi3+0x24>
80000220:	fe060513          	addi	a0,a2,-32
80000224:	00000713          	li	a4,0
80000228:	00a5d533          	srl	a0,a1,a0
8000022c:	00070593          	mv	a1,a4
80000230:	00008067          	ret
80000234:	00c5d733          	srl	a4,a1,a2
80000238:	00c55533          	srl	a0,a0,a2
8000023c:	00f595b3          	sll	a1,a1,a5
80000240:	00b56533          	or	a0,a0,a1
80000244:	fe9ff06f          	j	8000022c <__lshrdi3+0x1c>

80000248 <__udivdi3>:
80000248:	fd010113          	addi	sp,sp,-48
8000024c:	02912223          	sw	s1,36(sp)
80000250:	01612823          	sw	s6,16(sp)
80000254:	02112623          	sw	ra,44(sp)
80000258:	02812423          	sw	s0,40(sp)
8000025c:	03212023          	sw	s2,32(sp)
80000260:	01312e23          	sw	s3,28(sp)
80000264:	01412c23          	sw	s4,24(sp)
80000268:	01512a23          	sw	s5,20(sp)
8000026c:	01712623          	sw	s7,12(sp)
80000270:	01812423          	sw	s8,8(sp)
80000274:	01912223          	sw	s9,4(sp)
80000278:	00050b13          	mv	s6,a0
8000027c:	00058493          	mv	s1,a1
80000280:	38069c63          	bnez	a3,80000618 <__udivdi3+0x3d0>
80000284:	00060413          	mv	s0,a2
80000288:	00050993          	mv	s3,a0
8000028c:	00005917          	auipc	s2,0x5
80000290:	90c90913          	addi	s2,s2,-1780 # 80004b98 <__devconfig_end>
80000294:	12c5f863          	bgeu	a1,a2,800003c4 <__udivdi3+0x17c>
80000298:	000107b7          	lui	a5,0x10
8000029c:	00058a93          	mv	s5,a1
800002a0:	10f67863          	bgeu	a2,a5,800003b0 <__udivdi3+0x168>
800002a4:	0ff00693          	li	a3,255
800002a8:	00c6b6b3          	sltu	a3,a3,a2
800002ac:	00369693          	slli	a3,a3,0x3
800002b0:	00d657b3          	srl	a5,a2,a3
800002b4:	00f90933          	add	s2,s2,a5
800002b8:	00094703          	lbu	a4,0(s2)
800002bc:	00d706b3          	add	a3,a4,a3
800002c0:	02000713          	li	a4,32
800002c4:	40d70733          	sub	a4,a4,a3
800002c8:	00070c63          	beqz	a4,800002e0 <__udivdi3+0x98>
800002cc:	00e494b3          	sll	s1,s1,a4
800002d0:	00db56b3          	srl	a3,s6,a3
800002d4:	00e61433          	sll	s0,a2,a4
800002d8:	0096eab3          	or	s5,a3,s1
800002dc:	00eb19b3          	sll	s3,s6,a4
800002e0:	01045b13          	srli	s6,s0,0x10
800002e4:	000b0593          	mv	a1,s6
800002e8:	000a8513          	mv	a0,s5
800002ec:	634000ef          	jal	ra,80000920 <__umodsi3>
800002f0:	00050913          	mv	s2,a0
800002f4:	000b0593          	mv	a1,s6
800002f8:	01041b93          	slli	s7,s0,0x10
800002fc:	000a8513          	mv	a0,s5
80000300:	5d8000ef          	jal	ra,800008d8 <__udivsi3>
80000304:	010bdb93          	srli	s7,s7,0x10
80000308:	00050493          	mv	s1,a0
8000030c:	00050593          	mv	a1,a0
80000310:	000b8513          	mv	a0,s7
80000314:	508000ef          	jal	ra,8000081c <__mulsi3>
80000318:	01091913          	slli	s2,s2,0x10
8000031c:	0109d713          	srli	a4,s3,0x10
80000320:	00e96733          	or	a4,s2,a4
80000324:	00048a13          	mv	s4,s1
80000328:	00a77e63          	bgeu	a4,a0,80000344 <__udivdi3+0xfc>
8000032c:	00870733          	add	a4,a4,s0
80000330:	fff48a13          	addi	s4,s1,-1
80000334:	00876863          	bltu	a4,s0,80000344 <__udivdi3+0xfc>
80000338:	00a77663          	bgeu	a4,a0,80000344 <__udivdi3+0xfc>
8000033c:	ffe48a13          	addi	s4,s1,-2
80000340:	00870733          	add	a4,a4,s0
80000344:	40a704b3          	sub	s1,a4,a0
80000348:	000b0593          	mv	a1,s6
8000034c:	00048513          	mv	a0,s1
80000350:	5d0000ef          	jal	ra,80000920 <__umodsi3>
80000354:	00050913          	mv	s2,a0
80000358:	000b0593          	mv	a1,s6
8000035c:	00048513          	mv	a0,s1
80000360:	578000ef          	jal	ra,800008d8 <__udivsi3>
80000364:	01099993          	slli	s3,s3,0x10
80000368:	00050493          	mv	s1,a0
8000036c:	00050593          	mv	a1,a0
80000370:	01091913          	slli	s2,s2,0x10
80000374:	000b8513          	mv	a0,s7
80000378:	0109d993          	srli	s3,s3,0x10
8000037c:	4a0000ef          	jal	ra,8000081c <__mulsi3>
80000380:	013969b3          	or	s3,s2,s3
80000384:	00048613          	mv	a2,s1
80000388:	00a9fc63          	bgeu	s3,a0,800003a0 <__udivdi3+0x158>
8000038c:	013409b3          	add	s3,s0,s3
80000390:	fff48613          	addi	a2,s1,-1
80000394:	0089e663          	bltu	s3,s0,800003a0 <__udivdi3+0x158>
80000398:	00a9f463          	bgeu	s3,a0,800003a0 <__udivdi3+0x158>
8000039c:	ffe48613          	addi	a2,s1,-2
800003a0:	010a1793          	slli	a5,s4,0x10
800003a4:	00c7e7b3          	or	a5,a5,a2
800003a8:	00000a13          	li	s4,0
800003ac:	1300006f          	j	800004dc <__udivdi3+0x294>
800003b0:	010007b7          	lui	a5,0x1000
800003b4:	01000693          	li	a3,16
800003b8:	eef66ce3          	bltu	a2,a5,800002b0 <__udivdi3+0x68>
800003bc:	01800693          	li	a3,24
800003c0:	ef1ff06f          	j	800002b0 <__udivdi3+0x68>
800003c4:	00068a13          	mv	s4,a3
800003c8:	00061a63          	bnez	a2,800003dc <__udivdi3+0x194>
800003cc:	00000593          	li	a1,0
800003d0:	00100513          	li	a0,1
800003d4:	504000ef          	jal	ra,800008d8 <__udivsi3>
800003d8:	00050413          	mv	s0,a0
800003dc:	000107b7          	lui	a5,0x10
800003e0:	12f47c63          	bgeu	s0,a5,80000518 <__udivdi3+0x2d0>
800003e4:	0ff00793          	li	a5,255
800003e8:	0087f463          	bgeu	a5,s0,800003f0 <__udivdi3+0x1a8>
800003ec:	00800a13          	li	s4,8
800003f0:	014457b3          	srl	a5,s0,s4
800003f4:	00f90933          	add	s2,s2,a5
800003f8:	00094683          	lbu	a3,0(s2)
800003fc:	02000613          	li	a2,32
80000400:	014686b3          	add	a3,a3,s4
80000404:	40d60633          	sub	a2,a2,a3
80000408:	12061263          	bnez	a2,8000052c <__udivdi3+0x2e4>
8000040c:	408484b3          	sub	s1,s1,s0
80000410:	00100a13          	li	s4,1
80000414:	01045b13          	srli	s6,s0,0x10
80000418:	000b0593          	mv	a1,s6
8000041c:	00048513          	mv	a0,s1
80000420:	500000ef          	jal	ra,80000920 <__umodsi3>
80000424:	00050913          	mv	s2,a0
80000428:	000b0593          	mv	a1,s6
8000042c:	00048513          	mv	a0,s1
80000430:	01041b93          	slli	s7,s0,0x10
80000434:	4a4000ef          	jal	ra,800008d8 <__udivsi3>
80000438:	010bdb93          	srli	s7,s7,0x10
8000043c:	00050493          	mv	s1,a0
80000440:	00050593          	mv	a1,a0
80000444:	000b8513          	mv	a0,s7
80000448:	3d4000ef          	jal	ra,8000081c <__mulsi3>
8000044c:	01091913          	slli	s2,s2,0x10
80000450:	0109d713          	srli	a4,s3,0x10
80000454:	00e96733          	or	a4,s2,a4
80000458:	00048a93          	mv	s5,s1
8000045c:	00a77e63          	bgeu	a4,a0,80000478 <__udivdi3+0x230>
80000460:	00870733          	add	a4,a4,s0
80000464:	fff48a93          	addi	s5,s1,-1
80000468:	00876863          	bltu	a4,s0,80000478 <__udivdi3+0x230>
8000046c:	00a77663          	bgeu	a4,a0,80000478 <__udivdi3+0x230>
80000470:	ffe48a93          	addi	s5,s1,-2
80000474:	00870733          	add	a4,a4,s0
80000478:	40a704b3          	sub	s1,a4,a0
8000047c:	000b0593          	mv	a1,s6
80000480:	00048513          	mv	a0,s1
80000484:	49c000ef          	jal	ra,80000920 <__umodsi3>
80000488:	00050913          	mv	s2,a0
8000048c:	000b0593          	mv	a1,s6
80000490:	00048513          	mv	a0,s1
80000494:	444000ef          	jal	ra,800008d8 <__udivsi3>
80000498:	01099993          	slli	s3,s3,0x10
8000049c:	00050493          	mv	s1,a0
800004a0:	00050593          	mv	a1,a0
800004a4:	01091913          	slli	s2,s2,0x10
800004a8:	000b8513          	mv	a0,s7
800004ac:	0109d993          	srli	s3,s3,0x10
800004b0:	36c000ef          	jal	ra,8000081c <__mulsi3>
800004b4:	013969b3          	or	s3,s2,s3
800004b8:	00048613          	mv	a2,s1
800004bc:	00a9fc63          	bgeu	s3,a0,800004d4 <__udivdi3+0x28c>
800004c0:	013409b3          	add	s3,s0,s3
800004c4:	fff48613          	addi	a2,s1,-1
800004c8:	0089e663          	bltu	s3,s0,800004d4 <__udivdi3+0x28c>
800004cc:	00a9f463          	bgeu	s3,a0,800004d4 <__udivdi3+0x28c>
800004d0:	ffe48613          	addi	a2,s1,-2
800004d4:	010a9793          	slli	a5,s5,0x10
800004d8:	00c7e7b3          	or	a5,a5,a2
800004dc:	00078513          	mv	a0,a5
800004e0:	000a0593          	mv	a1,s4
800004e4:	02c12083          	lw	ra,44(sp)
800004e8:	02812403          	lw	s0,40(sp)
800004ec:	02412483          	lw	s1,36(sp)
800004f0:	02012903          	lw	s2,32(sp)
800004f4:	01c12983          	lw	s3,28(sp)
800004f8:	01812a03          	lw	s4,24(sp)
800004fc:	01412a83          	lw	s5,20(sp)
80000500:	01012b03          	lw	s6,16(sp)
80000504:	00c12b83          	lw	s7,12(sp)
80000508:	00812c03          	lw	s8,8(sp)
8000050c:	00412c83          	lw	s9,4(sp)
80000510:	03010113          	addi	sp,sp,48
80000514:	00008067          	ret
80000518:	010007b7          	lui	a5,0x1000
8000051c:	01000a13          	li	s4,16
80000520:	ecf468e3          	bltu	s0,a5,800003f0 <__udivdi3+0x1a8>
80000524:	01800a13          	li	s4,24
80000528:	ec9ff06f          	j	800003f0 <__udivdi3+0x1a8>
8000052c:	00c41433          	sll	s0,s0,a2
80000530:	00d4da33          	srl	s4,s1,a3
80000534:	00cb19b3          	sll	s3,s6,a2
80000538:	00db56b3          	srl	a3,s6,a3
8000053c:	01045b13          	srli	s6,s0,0x10
80000540:	00c494b3          	sll	s1,s1,a2
80000544:	000b0593          	mv	a1,s6
80000548:	000a0513          	mv	a0,s4
8000054c:	0096eab3          	or	s5,a3,s1
80000550:	3d0000ef          	jal	ra,80000920 <__umodsi3>
80000554:	00050913          	mv	s2,a0
80000558:	000b0593          	mv	a1,s6
8000055c:	000a0513          	mv	a0,s4
80000560:	01041b93          	slli	s7,s0,0x10
80000564:	374000ef          	jal	ra,800008d8 <__udivsi3>
80000568:	010bdb93          	srli	s7,s7,0x10
8000056c:	00050493          	mv	s1,a0
80000570:	00050593          	mv	a1,a0
80000574:	000b8513          	mv	a0,s7
80000578:	2a4000ef          	jal	ra,8000081c <__mulsi3>
8000057c:	01091913          	slli	s2,s2,0x10
80000580:	010ad713          	srli	a4,s5,0x10
80000584:	00e96733          	or	a4,s2,a4
80000588:	00048a13          	mv	s4,s1
8000058c:	00a77e63          	bgeu	a4,a0,800005a8 <__udivdi3+0x360>
80000590:	00870733          	add	a4,a4,s0
80000594:	fff48a13          	addi	s4,s1,-1
80000598:	00876863          	bltu	a4,s0,800005a8 <__udivdi3+0x360>
8000059c:	00a77663          	bgeu	a4,a0,800005a8 <__udivdi3+0x360>
800005a0:	ffe48a13          	addi	s4,s1,-2
800005a4:	00870733          	add	a4,a4,s0
800005a8:	40a704b3          	sub	s1,a4,a0
800005ac:	000b0593          	mv	a1,s6
800005b0:	00048513          	mv	a0,s1
800005b4:	36c000ef          	jal	ra,80000920 <__umodsi3>
800005b8:	00050913          	mv	s2,a0
800005bc:	000b0593          	mv	a1,s6
800005c0:	00048513          	mv	a0,s1
800005c4:	314000ef          	jal	ra,800008d8 <__udivsi3>
800005c8:	00050493          	mv	s1,a0
800005cc:	00050593          	mv	a1,a0
800005d0:	000b8513          	mv	a0,s7
800005d4:	248000ef          	jal	ra,8000081c <__mulsi3>
800005d8:	010a9693          	slli	a3,s5,0x10
800005dc:	01091913          	slli	s2,s2,0x10
800005e0:	0106d693          	srli	a3,a3,0x10
800005e4:	00d967b3          	or	a5,s2,a3
800005e8:	00048713          	mv	a4,s1
800005ec:	00a7fe63          	bgeu	a5,a0,80000608 <__udivdi3+0x3c0>
800005f0:	008787b3          	add	a5,a5,s0
800005f4:	fff48713          	addi	a4,s1,-1
800005f8:	0087e863          	bltu	a5,s0,80000608 <__udivdi3+0x3c0>
800005fc:	00a7f663          	bgeu	a5,a0,80000608 <__udivdi3+0x3c0>
80000600:	ffe48713          	addi	a4,s1,-2
80000604:	008787b3          	add	a5,a5,s0
80000608:	010a1a13          	slli	s4,s4,0x10
8000060c:	40a784b3          	sub	s1,a5,a0
80000610:	00ea6a33          	or	s4,s4,a4
80000614:	e01ff06f          	j	80000414 <__udivdi3+0x1cc>
80000618:	1ed5ec63          	bltu	a1,a3,80000810 <__udivdi3+0x5c8>
8000061c:	000107b7          	lui	a5,0x10
80000620:	04f6f463          	bgeu	a3,a5,80000668 <__udivdi3+0x420>
80000624:	0ff00593          	li	a1,255
80000628:	00d5b533          	sltu	a0,a1,a3
8000062c:	00351513          	slli	a0,a0,0x3
80000630:	00a6d733          	srl	a4,a3,a0
80000634:	00004797          	auipc	a5,0x4
80000638:	56478793          	addi	a5,a5,1380 # 80004b98 <__devconfig_end>
8000063c:	00e787b3          	add	a5,a5,a4
80000640:	0007c583          	lbu	a1,0(a5)
80000644:	02000a13          	li	s4,32
80000648:	00a585b3          	add	a1,a1,a0
8000064c:	40ba0a33          	sub	s4,s4,a1
80000650:	020a1663          	bnez	s4,8000067c <__udivdi3+0x434>
80000654:	00100793          	li	a5,1
80000658:	e896e2e3          	bltu	a3,s1,800004dc <__udivdi3+0x294>
8000065c:	00cb3633          	sltu	a2,s6,a2
80000660:	00164793          	xori	a5,a2,1
80000664:	e79ff06f          	j	800004dc <__udivdi3+0x294>
80000668:	010007b7          	lui	a5,0x1000
8000066c:	01000513          	li	a0,16
80000670:	fcf6e0e3          	bltu	a3,a5,80000630 <__udivdi3+0x3e8>
80000674:	01800513          	li	a0,24
80000678:	fb9ff06f          	j	80000630 <__udivdi3+0x3e8>
8000067c:	00b65ab3          	srl	s5,a2,a1
80000680:	014696b3          	sll	a3,a3,s4
80000684:	00daeab3          	or	s5,s5,a3
80000688:	00b4d933          	srl	s2,s1,a1
8000068c:	014497b3          	sll	a5,s1,s4
80000690:	00bb55b3          	srl	a1,s6,a1
80000694:	010adb93          	srli	s7,s5,0x10
80000698:	00f5e4b3          	or	s1,a1,a5
8000069c:	00090513          	mv	a0,s2
800006a0:	000b8593          	mv	a1,s7
800006a4:	014619b3          	sll	s3,a2,s4
800006a8:	278000ef          	jal	ra,80000920 <__umodsi3>
800006ac:	00050413          	mv	s0,a0
800006b0:	000b8593          	mv	a1,s7
800006b4:	00090513          	mv	a0,s2
800006b8:	010a9c13          	slli	s8,s5,0x10
800006bc:	21c000ef          	jal	ra,800008d8 <__udivsi3>
800006c0:	010c5c13          	srli	s8,s8,0x10
800006c4:	00050913          	mv	s2,a0
800006c8:	00050593          	mv	a1,a0
800006cc:	000c0513          	mv	a0,s8
800006d0:	14c000ef          	jal	ra,8000081c <__mulsi3>
800006d4:	01041413          	slli	s0,s0,0x10
800006d8:	0104d713          	srli	a4,s1,0x10
800006dc:	00e46733          	or	a4,s0,a4
800006e0:	00090c93          	mv	s9,s2
800006e4:	00a77e63          	bgeu	a4,a0,80000700 <__udivdi3+0x4b8>
800006e8:	01570733          	add	a4,a4,s5
800006ec:	fff90c93          	addi	s9,s2,-1
800006f0:	01576863          	bltu	a4,s5,80000700 <__udivdi3+0x4b8>
800006f4:	00a77663          	bgeu	a4,a0,80000700 <__udivdi3+0x4b8>
800006f8:	ffe90c93          	addi	s9,s2,-2
800006fc:	01570733          	add	a4,a4,s5
80000700:	40a70933          	sub	s2,a4,a0
80000704:	000b8593          	mv	a1,s7
80000708:	00090513          	mv	a0,s2
8000070c:	214000ef          	jal	ra,80000920 <__umodsi3>
80000710:	00050413          	mv	s0,a0
80000714:	000b8593          	mv	a1,s7
80000718:	00090513          	mv	a0,s2
8000071c:	1bc000ef          	jal	ra,800008d8 <__udivsi3>
80000720:	00050913          	mv	s2,a0
80000724:	00050593          	mv	a1,a0
80000728:	000c0513          	mv	a0,s8
8000072c:	0f0000ef          	jal	ra,8000081c <__mulsi3>
80000730:	01049793          	slli	a5,s1,0x10
80000734:	01041413          	slli	s0,s0,0x10
80000738:	0107d793          	srli	a5,a5,0x10
8000073c:	00f46733          	or	a4,s0,a5
80000740:	00090613          	mv	a2,s2
80000744:	00a77e63          	bgeu	a4,a0,80000760 <__udivdi3+0x518>
80000748:	01570733          	add	a4,a4,s5
8000074c:	fff90613          	addi	a2,s2,-1
80000750:	01576863          	bltu	a4,s5,80000760 <__udivdi3+0x518>
80000754:	00a77663          	bgeu	a4,a0,80000760 <__udivdi3+0x518>
80000758:	ffe90613          	addi	a2,s2,-2
8000075c:	01570733          	add	a4,a4,s5
80000760:	010c9793          	slli	a5,s9,0x10
80000764:	00010e37          	lui	t3,0x10
80000768:	00c7e7b3          	or	a5,a5,a2
8000076c:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000770:	0107f333          	and	t1,a5,a6
80000774:	0109f833          	and	a6,s3,a6
80000778:	40a70733          	sub	a4,a4,a0
8000077c:	0107de93          	srli	t4,a5,0x10
80000780:	0109d993          	srli	s3,s3,0x10
80000784:	00030513          	mv	a0,t1
80000788:	00080593          	mv	a1,a6
8000078c:	090000ef          	jal	ra,8000081c <__mulsi3>
80000790:	00050893          	mv	a7,a0
80000794:	00098593          	mv	a1,s3
80000798:	00030513          	mv	a0,t1
8000079c:	080000ef          	jal	ra,8000081c <__mulsi3>
800007a0:	00050313          	mv	t1,a0
800007a4:	00080593          	mv	a1,a6
800007a8:	000e8513          	mv	a0,t4
800007ac:	070000ef          	jal	ra,8000081c <__mulsi3>
800007b0:	00050813          	mv	a6,a0
800007b4:	00098593          	mv	a1,s3
800007b8:	000e8513          	mv	a0,t4
800007bc:	060000ef          	jal	ra,8000081c <__mulsi3>
800007c0:	0108d693          	srli	a3,a7,0x10
800007c4:	01030333          	add	t1,t1,a6
800007c8:	006686b3          	add	a3,a3,t1
800007cc:	0106f463          	bgeu	a3,a6,800007d4 <__udivdi3+0x58c>
800007d0:	01c50533          	add	a0,a0,t3
800007d4:	0106d613          	srli	a2,a3,0x10
800007d8:	00a60533          	add	a0,a2,a0
800007dc:	02a76663          	bltu	a4,a0,80000808 <__udivdi3+0x5c0>
800007e0:	bca714e3          	bne	a4,a0,800003a8 <__udivdi3+0x160>
800007e4:	00010737          	lui	a4,0x10
800007e8:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007ec:	00e6f6b3          	and	a3,a3,a4
800007f0:	01069693          	slli	a3,a3,0x10
800007f4:	00e8f8b3          	and	a7,a7,a4
800007f8:	014b1633          	sll	a2,s6,s4
800007fc:	011686b3          	add	a3,a3,a7
80000800:	00000a13          	li	s4,0
80000804:	ccd67ce3          	bgeu	a2,a3,800004dc <__udivdi3+0x294>
80000808:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000080c:	b9dff06f          	j	800003a8 <__udivdi3+0x160>
80000810:	00000a13          	li	s4,0
80000814:	00000793          	li	a5,0
80000818:	cc5ff06f          	j	800004dc <__udivdi3+0x294>

8000081c <__mulsi3>:
8000081c:	00050613          	mv	a2,a0
80000820:	00000513          	li	a0,0
80000824:	0015f693          	andi	a3,a1,1
80000828:	00068463          	beqz	a3,80000830 <__mulsi3+0x14>
8000082c:	00c50533          	add	a0,a0,a2
80000830:	0015d593          	srli	a1,a1,0x1
80000834:	00161613          	slli	a2,a2,0x1
80000838:	fe0596e3          	bnez	a1,80000824 <__mulsi3+0x8>
8000083c:	00008067          	ret

80000840 <__muldi3>:
80000840:	ff010113          	addi	sp,sp,-16
80000844:	00068313          	mv	t1,a3
80000848:	00112623          	sw	ra,12(sp)
8000084c:	00050e13          	mv	t3,a0
80000850:	00050893          	mv	a7,a0
80000854:	00060693          	mv	a3,a2
80000858:	00000713          	li	a4,0
8000085c:	00000793          	li	a5,0
80000860:	00000813          	li	a6,0
80000864:	0016f513          	andi	a0,a3,1
80000868:	00171e93          	slli	t4,a4,0x1
8000086c:	00050c63          	beqz	a0,80000884 <__muldi3+0x44>
80000870:	01088533          	add	a0,a7,a6
80000874:	01053833          	sltu	a6,a0,a6
80000878:	00e787b3          	add	a5,a5,a4
8000087c:	00f807b3          	add	a5,a6,a5
80000880:	00050813          	mv	a6,a0
80000884:	01f8d713          	srli	a4,a7,0x1f
80000888:	0016d693          	srli	a3,a3,0x1
8000088c:	00eee733          	or	a4,t4,a4
80000890:	00189893          	slli	a7,a7,0x1
80000894:	fc0698e3          	bnez	a3,80000864 <__muldi3+0x24>
80000898:	00058863          	beqz	a1,800008a8 <__muldi3+0x68>
8000089c:	00060513          	mv	a0,a2
800008a0:	f7dff0ef          	jal	ra,8000081c <__mulsi3>
800008a4:	00a787b3          	add	a5,a5,a0
800008a8:	00030a63          	beqz	t1,800008bc <__muldi3+0x7c>
800008ac:	000e0513          	mv	a0,t3
800008b0:	00030593          	mv	a1,t1
800008b4:	f69ff0ef          	jal	ra,8000081c <__mulsi3>
800008b8:	00f507b3          	add	a5,a0,a5
800008bc:	00c12083          	lw	ra,12(sp)
800008c0:	00080513          	mv	a0,a6
800008c4:	00078593          	mv	a1,a5
800008c8:	01010113          	addi	sp,sp,16
800008cc:	00008067          	ret

800008d0 <__divsi3>:
800008d0:	06054063          	bltz	a0,80000930 <__umodsi3+0x10>
800008d4:	0605c663          	bltz	a1,80000940 <__umodsi3+0x20>

800008d8 <__udivsi3>:
800008d8:	00058613          	mv	a2,a1
800008dc:	00050593          	mv	a1,a0
800008e0:	fff00513          	li	a0,-1
800008e4:	02060c63          	beqz	a2,8000091c <__udivsi3+0x44>
800008e8:	00100693          	li	a3,1
800008ec:	00b67a63          	bgeu	a2,a1,80000900 <__udivsi3+0x28>
800008f0:	00c05863          	blez	a2,80000900 <__udivsi3+0x28>
800008f4:	00161613          	slli	a2,a2,0x1
800008f8:	00169693          	slli	a3,a3,0x1
800008fc:	feb66ae3          	bltu	a2,a1,800008f0 <__udivsi3+0x18>
80000900:	00000513          	li	a0,0
80000904:	00c5e663          	bltu	a1,a2,80000910 <__udivsi3+0x38>
80000908:	40c585b3          	sub	a1,a1,a2
8000090c:	00d56533          	or	a0,a0,a3
80000910:	0016d693          	srli	a3,a3,0x1
80000914:	00165613          	srli	a2,a2,0x1
80000918:	fe0696e3          	bnez	a3,80000904 <__udivsi3+0x2c>
8000091c:	00008067          	ret

80000920 <__umodsi3>:
80000920:	00008293          	mv	t0,ra
80000924:	fb5ff0ef          	jal	ra,800008d8 <__udivsi3>
80000928:	00058513          	mv	a0,a1
8000092c:	00028067          	jr	t0
80000930:	40a00533          	neg	a0,a0
80000934:	0005d863          	bgez	a1,80000944 <__umodsi3+0x24>
80000938:	40b005b3          	neg	a1,a1
8000093c:	f9dff06f          	j	800008d8 <__udivsi3>
80000940:	40b005b3          	neg	a1,a1
80000944:	00008293          	mv	t0,ra
80000948:	f91ff0ef          	jal	ra,800008d8 <__udivsi3>
8000094c:	40a00533          	neg	a0,a0
80000950:	00028067          	jr	t0

80000954 <__modsi3>:
80000954:	00008293          	mv	t0,ra
80000958:	0005ca63          	bltz	a1,8000096c <__modsi3+0x18>
8000095c:	00054c63          	bltz	a0,80000974 <__modsi3+0x20>
80000960:	f79ff0ef          	jal	ra,800008d8 <__udivsi3>
80000964:	00058513          	mv	a0,a1
80000968:	00028067          	jr	t0
8000096c:	40b005b3          	neg	a1,a1
80000970:	fe0558e3          	bgez	a0,80000960 <__modsi3+0xc>
80000974:	40a00533          	neg	a0,a0
80000978:	f61ff0ef          	jal	ra,800008d8 <__udivsi3>
8000097c:	40b00533          	neg	a0,a1
80000980:	00028067          	jr	t0

80000984 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000984:	00006117          	auipc	sp,0x6
80000988:	61c10113          	addi	sp,sp,1564 # 80006fa0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
8000098c:	000012b7          	lui	t0,0x1
80000990:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000994:	9116                	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000996:	29d9                	jal	80000e6c <_PrepC>

80000998 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000998:	31f0006f          	j	800014b6 <z_thread_entry>
	...

8000099e <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
8000099e:	8082                	ret

800009a0 <critical_rtn>:
{
	volatile u32_t x;

	ARG_UNUSED(unused);

	x = critical_var;
800009a0:	800067b7          	lui	a5,0x80006
800009a4:	86c78793          	addi	a5,a5,-1940 # 8000586c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000586d>
800009a8:	4398                	lw	a4,0(a5)
{
800009aa:	1141                	addi	sp,sp,-16
	x = critical_var;
800009ac:	c63a                	sw	a4,12(sp)
	critical_var = x + 1;
800009ae:	4732                	lw	a4,12(sp)
800009b0:	0705                	addi	a4,a4,1
800009b2:	c398                	sw	a4,0(a5)

}
800009b4:	0141                	addi	sp,sp,16
800009b6:	8082                	ret

800009b8 <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
800009b8:	7179                	addi	sp,sp,-48
800009ba:	ce06                	sw	ra,28(sp)
800009bc:	cc22                	sw	s0,24(sp)
800009be:	d442                	sw	a6,40(sp)
800009c0:	d646                	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
800009c2:	ed0d                	bnez	a0,800009fc <z_zassert.constprop.0+0x44>
800009c4:	8636                	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009c6:	80005537          	lui	a0,0x80005
800009ca:	86ba                	mv	a3,a4
800009cc:	872e                	mv	a4,a1
800009ce:	800055b7          	lui	a1,0x80005
800009d2:	843e                	mv	s0,a5
800009d4:	df058593          	addi	a1,a1,-528 # 80004df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004df1>
		va_start(vargs, msg);
800009d8:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009da:	e1450513          	addi	a0,a0,-492 # 80004e14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e15>
		va_start(vargs, msg);
800009de:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009e0:	755000ef          	jal	ra,80001934 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
800009e4:	45b2                	lw	a1,12(sp)
800009e6:	8522                	mv	a0,s0
800009e8:	731000ef          	jal	ra,80001918 <vprintk>
		printk("\n");
800009ec:	80005537          	lui	a0,0x80005
800009f0:	f9050513          	addi	a0,a0,-112 # 80004f90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f91>
800009f4:	741000ef          	jal	ra,80001934 <printk>
		va_end(vargs);
		ztest_test_fail();
800009f8:	4c8010ef          	jal	ra,80001ec0 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
800009fc:	40f2                	lw	ra,28(sp)
800009fe:	4462                	lw	s0,24(sp)
80000a00:	6145                	addi	sp,sp,48
80000a02:	8082                	ret

80000a04 <test_critical>:

}

static void init_objects(void)
{
	critical_var = 0U;
80000a04:	800067b7          	lui	a5,0x80006
	alt_thread_iterations = 0U;
	k_work_q_start(&offload_work_q,
80000a08:	800065b7          	lui	a1,0x80006
80000a0c:	80006537          	lui	a0,0x80006
 * during context switch
 *
 * @ingroup kernel_critical_tests
 */
void test_critical(void)
{
80000a10:	1101                	addi	sp,sp,-32
	critical_var = 0U;
80000a12:	8607a623          	sw	zero,-1940(a5) # 8000586c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000586d>
	k_work_q_start(&offload_work_q,
80000a16:	56fd                	li	a3,-1
	alt_thread_iterations = 0U;
80000a18:	800067b7          	lui	a5,0x80006
	k_work_q_start(&offload_work_q,
80000a1c:	40000613          	li	a2,1024
80000a20:	ba058593          	addi	a1,a1,-1120 # 80005ba0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ba1>
80000a24:	8b050513          	addi	a0,a0,-1872 # 800058b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058b1>
{
80000a28:	ce06                	sw	ra,28(sp)
	alt_thread_iterations = 0U;
80000a2a:	8607a423          	sw	zero,-1944(a5) # 80005868 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005869>
	k_work_q_start(&offload_work_q,
80000a2e:	38a030ef          	jal	ra,80003db8 <k_work_q_start>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_OBJECT_RELEASE, k_object_release, void *, object)

K_SYSCALL_DECLARE1(K_SYSCALL_K_OBJECT_ALLOC, k_object_alloc, void *, enum k_objects, otype)

K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000a32:	800016b7          	lui	a3,0x80001
80000a36:	800065b7          	lui	a1,0x80006
80000a3a:	80006537          	lui	a0,0x80006
80000a3e:	c202                	sw	zero,4(sp)
80000a40:	c002                	sw	zero,0(sp)
80000a42:	48b1                	li	a7,12
80000a44:	4801                	li	a6,0
80000a46:	4781                	li	a5,0
80000a48:	4701                	li	a4,0
80000a4a:	b3a68693          	addi	a3,a3,-1222 # 80000b3a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b3b>
80000a4e:	40000613          	li	a2,1024
80000a52:	fa058593          	addi	a1,a1,-96 # 80005fa0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fa1>
80000a56:	93450513          	addi	a0,a0,-1740 # 80005934 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005935>
80000a5a:	190030ef          	jal	ra,80003bea <z_impl_k_thread_create>
80000a5e:	800016b7          	lui	a3,0x80001
80000a62:	800065b7          	lui	a1,0x80006
80000a66:	80006537          	lui	a0,0x80006
80000a6a:	4781                	li	a5,0
80000a6c:	4701                	li	a4,0
80000a6e:	b8e68693          	addi	a3,a3,-1138 # 80000b8e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b8f>
80000a72:	40000613          	li	a2,1024
80000a76:	c202                	sw	zero,4(sp)
80000a78:	c002                	sw	zero,0(sp)
80000a7a:	48b1                	li	a7,12
80000a7c:	4801                	li	a6,0
80000a7e:	3a058593          	addi	a1,a1,928 # 800063a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063a1>
80000a82:	9a450513          	addi	a0,a0,-1628 # 800059a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059a5>
80000a86:	164030ef          	jal	ra,80003bea <z_impl_k_thread_create>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000a8a:	65a9                	lui	a1,0xa
80000a8c:	80006537          	lui	a0,0x80006
80000a90:	c4058593          	addi	a1,a1,-960 # 9c40 <CONFIG_ISR_STACK_SIZE+0x9440>
80000a94:	83050513          	addi	a0,a0,-2000 # 80005830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005831>
80000a98:	5b9020ef          	jal	ra,80003850 <z_impl_k_sem_take>
	init_objects();
	start_threads();

	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
		     "Timed out waiting for TEST_SEM");
}
80000a9c:	40f2                	lw	ra,28(sp)
	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
80000a9e:	800057b7          	lui	a5,0x80005
80000aa2:	80005737          	lui	a4,0x80005
80000aa6:	80005637          	lui	a2,0x80005
80000aaa:	800055b7          	lui	a1,0x80005
80000aae:	d8878793          	addi	a5,a5,-632 # 80004d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d89>
80000ab2:	cac70713          	addi	a4,a4,-852 # 80004cac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cad>
80000ab6:	0dc00693          	li	a3,220
80000aba:	df060613          	addi	a2,a2,-528 # 80004df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004df1>
80000abe:	da858593          	addi	a1,a1,-600 # 80004da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da9>
80000ac2:	00153513          	seqz	a0,a0
}
80000ac6:	6105                	addi	sp,sp,32
	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
80000ac8:	bdc5                	j	800009b8 <z_zassert.constprop.0>

80000aca <critical_loop>:
{
80000aca:	7179                	addi	sp,sp,-48
80000acc:	d226                	sw	s1,36(sp)
	while (k_uptime_get() < mseconds + NUM_MILLISECONDS) {
80000ace:	6485                	lui	s1,0x1
{
80000ad0:	d422                	sw	s0,40(sp)
80000ad2:	d04a                	sw	s2,32(sp)
80000ad4:	ce4e                	sw	s3,28(sp)
80000ad6:	cc52                	sw	s4,24(sp)
80000ad8:	d606                	sw	ra,44(sp)
80000ada:	892a                	mv	s2,a0
	while (k_uptime_get() < mseconds + NUM_MILLISECONDS) {
80000adc:	38848493          	addi	s1,s1,904 # 1388 <CONFIG_ISR_STACK_SIZE+0xb88>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000ae0:	2a3030ef          	jal	ra,80004582 <z_impl_k_uptime_get>
80000ae4:	94aa                	add	s1,s1,a0
80000ae6:	00a4b433          	sltu	s0,s1,a0
 * @return N/A
 * @req K-WORK-001
 */
static inline void k_work_init(struct k_work *work, k_work_handler_t handler)
{
	*work = (struct k_work)Z_WORK_INITIALIZER(handler);
80000aea:	800019b7          	lui	s3,0x80001
80000aee:	942e                	add	s0,s0,a1
80000af0:	9a098993          	addi	s3,s3,-1632 # 800009a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009a1>
 */
static inline void k_work_submit_to_queue(struct k_work_q *work_q,
					  struct k_work *work)
{
	if (!atomic_test_and_set_bit(work->flags, K_WORK_STATE_PENDING)) {
		k_queue_append(&work_q->queue, work);
80000af4:	80006a37          	lui	s4,0x80006
80000af8:	28b030ef          	jal	ra,80004582 <z_impl_k_uptime_get>
80000afc:	0085cf63          	blt	a1,s0,80000b1a <critical_loop+0x50>
80000b00:	00b41463          	bne	s0,a1,80000b08 <critical_loop+0x3e>
80000b04:	00956b63          	bltu	a0,s1,80000b1a <critical_loop+0x50>
}
80000b08:	50b2                	lw	ra,44(sp)
80000b0a:	5422                	lw	s0,40(sp)
80000b0c:	854a                	mv	a0,s2
80000b0e:	5492                	lw	s1,36(sp)
80000b10:	5902                	lw	s2,32(sp)
80000b12:	49f2                	lw	s3,28(sp)
80000b14:	4a62                	lw	s4,24(sp)
80000b16:	6145                	addi	sp,sp,48
80000b18:	8082                	ret

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_SUB, atomic_sub, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_SET, atomic_set, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_OR, atomic_or, atomic_val_t, atomic_t *, target, atomic_val_t, value)
80000b1a:	4585                	li	a1,1
80000b1c:	0068                	addi	a0,sp,12
	*work = (struct k_work)Z_WORK_INITIALIZER(handler);
80000b1e:	c202                	sw	zero,4(sp)
80000b20:	c44e                	sw	s3,8(sp)
80000b22:	c602                	sw	zero,12(sp)
80000b24:	281030ef          	jal	ra,800045a4 <z_impl_atomic_or>
	atomic_val_t mask = ATOMIC_MASK(bit);
	atomic_val_t old;

	old = atomic_or(ATOMIC_ELEM(target, bit), mask);

	return (old & mask) != 0;
80000b28:	8905                	andi	a0,a0,1
	if (!atomic_test_and_set_bit(work->flags, K_WORK_STATE_PENDING)) {
80000b2a:	e511                	bnez	a0,80000b36 <critical_loop+0x6c>
		k_queue_append(&work_q->queue, work);
80000b2c:	004c                	addi	a1,sp,4
80000b2e:	8b0a0513          	addi	a0,s4,-1872 # 800058b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058b1>
80000b32:	13f010ef          	jal	ra,80002470 <k_queue_append>
		count++;
80000b36:	0905                	addi	s2,s2,1
80000b38:	b7c1                	j	80000af8 <critical_loop+0x2e>

80000b3a <alternate_thread>:
{
80000b3a:	1141                	addi	sp,sp,-16
80000b3c:	c04a                	sw	s2,0(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000b3e:	80006937          	lui	s2,0x80006
80000b42:	c422                	sw	s0,8(sp)
80000b44:	55fd                	li	a1,-1
80000b46:	81090513          	addi	a0,s2,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
	alt_thread_iterations = critical_loop(alt_thread_iterations);
80000b4a:	80006437          	lui	s0,0x80006
{
80000b4e:	c606                	sw	ra,12(sp)
80000b50:	c226                	sw	s1,4(sp)
	alt_thread_iterations = critical_loop(alt_thread_iterations);
80000b52:	86840413          	addi	s0,s0,-1944 # 80005868 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005869>
80000b56:	4fb020ef          	jal	ra,80003850 <z_impl_k_sem_take>
80000b5a:	4008                	lw	a0,0(s0)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b5c:	800064b7          	lui	s1,0x80006
80000b60:	37ad                	jal	80000aca <critical_loop>
80000b62:	c008                	sw	a0,0(s0)
80000b64:	82048513          	addi	a0,s1,-2016 # 80005820 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005821>
80000b68:	43f020ef          	jal	ra,800037a6 <z_impl_k_sem_give>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000b6c:	55fd                	li	a1,-1
80000b6e:	81090513          	addi	a0,s2,-2032
80000b72:	4df020ef          	jal	ra,80003850 <z_impl_k_sem_take>
	alt_thread_iterations = critical_loop(alt_thread_iterations);
80000b76:	4008                	lw	a0,0(s0)
80000b78:	3f89                	jal	80000aca <critical_loop>
80000b7a:	c008                	sw	a0,0(s0)
}
80000b7c:	4422                	lw	s0,8(sp)
80000b7e:	40b2                	lw	ra,12(sp)
80000b80:	4902                	lw	s2,0(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b82:	82048513          	addi	a0,s1,-2016
80000b86:	4492                	lw	s1,4(sp)
80000b88:	0141                	addi	sp,sp,16
80000b8a:	41d0206f          	j	800037a6 <z_impl_k_sem_give>

80000b8e <regression_thread>:
{
80000b8e:	7139                	addi	sp,sp,-64
80000b90:	c66e                	sw	s11,12(sp)
80000b92:	80006db7          	lui	s11,0x80006
80000b96:	810d8513          	addi	a0,s11,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
80000b9a:	de06                	sw	ra,60(sp)
80000b9c:	dc22                	sw	s0,56(sp)
80000b9e:	da26                	sw	s1,52(sp)
80000ba0:	d84a                	sw	s2,48(sp)
80000ba2:	d64e                	sw	s3,44(sp)
80000ba4:	d452                	sw	s4,40(sp)
80000ba6:	d256                	sw	s5,36(sp)
80000ba8:	d05a                	sw	s6,32(sp)
80000baa:	ce5e                	sw	s7,28(sp)
80000bac:	cc62                	sw	s8,24(sp)
80000bae:	ca66                	sw	s9,20(sp)
80000bb0:	c86a                	sw	s10,16(sp)
80000bb2:	3f5020ef          	jal	ra,800037a6 <z_impl_k_sem_give>
	ncalls = critical_loop(ncalls);
80000bb6:	4501                	li	a0,0
80000bb8:	3f09                	jal	80000aca <critical_loop>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000bba:	80006cb7          	lui	s9,0x80006
80000bbe:	6d15                	lui	s10,0x5
80000bc0:	842a                	mv	s0,a0
80000bc2:	e20d0593          	addi	a1,s10,-480 # 4e20 <CONFIG_ISR_STACK_SIZE+0x4620>
80000bc6:	820c8513          	addi	a0,s9,-2016 # 80005820 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005821>
80000bca:	487020ef          	jal	ra,80003850 <z_impl_k_sem_take>
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
80000bce:	80005937          	lui	s2,0x80005
80000bd2:	800054b7          	lui	s1,0x80005
80000bd6:	80005c37          	lui	s8,0x80005
80000bda:	80005bb7          	lui	s7,0x80005
80000bde:	cbcc0793          	addi	a5,s8,-836 # 80004cbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cbd>
80000be2:	c9890713          	addi	a4,s2,-872 # 80004c98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c99>
80000be6:	df048613          	addi	a2,s1,-528 # 80004df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004df1>
80000bea:	ce0b8593          	addi	a1,s7,-800 # 80004ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ce1>
80000bee:	0a300693          	li	a3,163
80000bf2:	00153513          	seqz	a0,a0
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000bf6:	80006a37          	lui	s4,0x80006
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
80000bfa:	3b7d                	jal	800009b8 <z_zassert.constprop.0>
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000bfc:	868a0a13          	addi	s4,s4,-1944 # 80005868 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005869>
80000c00:	800069b7          	lui	s3,0x80006
80000c04:	000a2503          	lw	a0,0(s4)
80000c08:	86c98993          	addi	s3,s3,-1940 # 8000586c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000586d>
80000c0c:	0009a783          	lw	a5,0(s3)
80000c10:	9522                	add	a0,a0,s0
80000c12:	80005b37          	lui	s6,0x80005
80000c16:	80005ab7          	lui	s5,0x80005
80000c1a:	8d1d                	sub	a0,a0,a5
80000c1c:	c9890713          	addi	a4,s2,-872
80000c20:	d18b0793          	addi	a5,s6,-744 # 80004d18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d19>
80000c24:	df048613          	addi	a2,s1,-528
80000c28:	0a600693          	li	a3,166
80000c2c:	d3ca8593          	addi	a1,s5,-708 # 80004d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d3d>
80000c30:	00153513          	seqz	a0,a0
80000c34:	3351                	jal	800009b8 <z_zassert.constprop.0>
	k_sched_time_slice_set(10, 10);
80000c36:	45a9                	li	a1,10
80000c38:	4529                	li	a0,10
80000c3a:	1fb010ef          	jal	ra,80002634 <k_sched_time_slice_set>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000c3e:	810d8513          	addi	a0,s11,-2032
80000c42:	365020ef          	jal	ra,800037a6 <z_impl_k_sem_give>
	ncalls = critical_loop(ncalls);
80000c46:	8522                	mv	a0,s0
80000c48:	3549                	jal	80000aca <critical_loop>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000c4a:	e20d0593          	addi	a1,s10,-480
80000c4e:	842a                	mv	s0,a0
80000c50:	820c8513          	addi	a0,s9,-2016
80000c54:	3fd020ef          	jal	ra,80003850 <z_impl_k_sem_take>
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
80000c58:	cbcc0793          	addi	a5,s8,-836
80000c5c:	c9890713          	addi	a4,s2,-872
80000c60:	df048613          	addi	a2,s1,-528
80000c64:	ce0b8593          	addi	a1,s7,-800
80000c68:	0b000693          	li	a3,176
80000c6c:	00153513          	seqz	a0,a0
80000c70:	33a1                	jal	800009b8 <z_zassert.constprop.0>
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000c72:	000a2503          	lw	a0,0(s4)
80000c76:	d18b0793          	addi	a5,s6,-744
80000c7a:	c9890713          	addi	a4,s2,-872
80000c7e:	942a                	add	s0,s0,a0
80000c80:	0009a503          	lw	a0,0(s3)
80000c84:	df048613          	addi	a2,s1,-528
80000c88:	d3ca8593          	addi	a1,s5,-708
80000c8c:	40a40533          	sub	a0,s0,a0
80000c90:	00153513          	seqz	a0,a0
80000c94:	0b300693          	li	a3,179
80000c98:	3305                	jal	800009b8 <z_zassert.constprop.0>
}
80000c9a:	5462                	lw	s0,56(sp)
80000c9c:	50f2                	lw	ra,60(sp)
80000c9e:	54d2                	lw	s1,52(sp)
80000ca0:	5942                	lw	s2,48(sp)
80000ca2:	59b2                	lw	s3,44(sp)
80000ca4:	5a22                	lw	s4,40(sp)
80000ca6:	5a92                	lw	s5,36(sp)
80000ca8:	5b02                	lw	s6,32(sp)
80000caa:	4bf2                	lw	s7,28(sp)
80000cac:	4c62                	lw	s8,24(sp)
80000cae:	4cd2                	lw	s9,20(sp)
80000cb0:	4d42                	lw	s10,16(sp)
80000cb2:	4db2                	lw	s11,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000cb4:	80006537          	lui	a0,0x80006
80000cb8:	83050513          	addi	a0,a0,-2000 # 80005830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005831>
80000cbc:	6121                	addi	sp,sp,64
80000cbe:	2e90206f          	j	800037a6 <z_impl_k_sem_give>

80000cc2 <test_main>:
void test_main(void)
{
	ztest_test_suite(kernel_critical,
			 ztest_unit_test(test_critical)
			 );
	ztest_run_test_suite(kernel_critical);
80000cc2:	800055b7          	lui	a1,0x80005
80000cc6:	80005537          	lui	a0,0x80005
80000cca:	79c58593          	addi	a1,a1,1948 # 8000579c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000579d>
80000cce:	de050513          	addi	a0,a0,-544 # 80004de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de1>
80000cd2:	2140106f          	j	80001ee6 <z_ztest_run_test_suite>

80000cd6 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000cd6:	1141                	addi	sp,sp,-16
80000cd8:	c606                	sw	ra,12(sp)
80000cda:	c422                	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000cdc:	4799                	li	a5,6
80000cde:	02f50263          	beq	a0,a5,80000d02 <z_SysFatalErrorHandler+0x2c>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000ce2:	4f5020ef          	jal	ra,800039d6 <k_is_in_isr>
80000ce6:	c10d                	beqz	a0,80000d08 <z_SysFatalErrorHandler+0x32>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000ce8:	4ef020ef          	jal	ra,800039d6 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000cec:	e121                	bnez	a0,80000d2c <z_SysFatalErrorHandler+0x56>
80000cee:	800055b7          	lui	a1,0x80005
80000cf2:	0ec58593          	addi	a1,a1,236 # 800050ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050ed>
80000cf6:	80005537          	lui	a0,0x80005
80000cfa:	10050513          	addi	a0,a0,256 # 80005100 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005101>
80000cfe:	437000ef          	jal	ra,80001934 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000d02:	479000ef          	jal	ra,8000197a <k_cpu_idle>
80000d06:	bff5                	j	80000d02 <z_SysFatalErrorHandler+0x2c>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000d08:	4dd020ef          	jal	ra,800039e4 <z_is_thread_essential>
80000d0c:	fd71                	bnez	a0,80000ce8 <z_SysFatalErrorHandler+0x12>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000d0e:	80006437          	lui	s0,0x80006
80000d12:	b7440413          	addi	s0,s0,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
80000d16:	440c                	lw	a1,8(s0)
80000d18:	80005537          	lui	a0,0x80005
80000d1c:	12050513          	addi	a0,a0,288 # 80005120 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005121>
80000d20:	415000ef          	jal	ra,80001934 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000d24:	4408                	lw	a0,8(s0)
80000d26:	7dd020ef          	jal	ra,80003d02 <z_impl_k_thread_abort>
80000d2a:	bfe1                	j	80000d02 <z_SysFatalErrorHandler+0x2c>
		printk("Fatal fault in %s! Spinning...\n",
80000d2c:	800055b7          	lui	a1,0x80005
80000d30:	0e858593          	addi	a1,a1,232 # 800050e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e9>
80000d34:	b7c9                	j	80000cf6 <z_SysFatalErrorHandler+0x20>

80000d36 <z_NanoFatalErrorHandler>:
{
80000d36:	715d                	addi	sp,sp,-80
80000d38:	c4a2                	sw	s0,72(sp)
80000d3a:	c2a6                	sw	s1,68(sp)
80000d3c:	c686                	sw	ra,76(sp)
	switch (reason) {
80000d3e:	4799                	li	a5,6
{
80000d40:	84aa                	mv	s1,a0
80000d42:	842e                	mv	s0,a1
	switch (reason) {
80000d44:	08a7e963          	bltu	a5,a0,80000dd6 <z_NanoFatalErrorHandler+0xa0>
80000d48:	80005737          	lui	a4,0x80005
80000d4c:	00251793          	slli	a5,a0,0x2
80000d50:	e3c70713          	addi	a4,a4,-452 # 80004e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e3d>
80000d54:	97ba                	add	a5,a5,a4
80000d56:	439c                	lw	a5,0(a5)
80000d58:	8782                	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000d5a:	80005537          	lui	a0,0x80005
80000d5e:	f6c50513          	addi	a0,a0,-148 # 80004f6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f6d>
		printk("***** Kernel OOPS! *****\n");
80000d62:	3d3000ef          	jal	ra,80001934 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000d66:	197020ef          	jal	ra,800036fc <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000d6a:	407c                	lw	a5,68(s0)
80000d6c:	01042883          	lw	a7,16(s0)
80000d70:	00c42803          	lw	a6,12(s0)
80000d74:	d83e                	sw	a5,48(sp)
80000d76:	403c                	lw	a5,64(s0)
80000d78:	4058                	lw	a4,4(s0)
80000d7a:	4014                	lw	a3,0(s0)
80000d7c:	d63e                	sw	a5,44(sp)
80000d7e:	5c5c                	lw	a5,60(s0)
80000d80:	4430                	lw	a2,72(s0)
80000d82:	85aa                	mv	a1,a0
80000d84:	d43e                	sw	a5,40(sp)
80000d86:	5c1c                	lw	a5,56(s0)
80000d88:	80005537          	lui	a0,0x80005
80000d8c:	ff050513          	addi	a0,a0,-16 # 80004ff0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ff1>
80000d90:	d23e                	sw	a5,36(sp)
80000d92:	585c                	lw	a5,52(s0)
80000d94:	d03e                	sw	a5,32(sp)
80000d96:	581c                	lw	a5,48(s0)
80000d98:	ce3e                	sw	a5,28(sp)
80000d9a:	545c                	lw	a5,44(s0)
80000d9c:	cc3e                	sw	a5,24(sp)
80000d9e:	541c                	lw	a5,40(s0)
80000da0:	ca3e                	sw	a5,20(sp)
80000da2:	505c                	lw	a5,36(s0)
80000da4:	c83e                	sw	a5,16(sp)
80000da6:	501c                	lw	a5,32(s0)
80000da8:	c63e                	sw	a5,12(sp)
80000daa:	4c5c                	lw	a5,28(s0)
80000dac:	c43e                	sw	a5,8(sp)
80000dae:	4c1c                	lw	a5,24(s0)
80000db0:	c23e                	sw	a5,4(sp)
80000db2:	485c                	lw	a5,20(s0)
80000db4:	c03e                	sw	a5,0(sp)
80000db6:	441c                	lw	a5,8(s0)
80000db8:	37d000ef          	jal	ra,80001934 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000dbc:	85a2                	mv	a1,s0
80000dbe:	8526                	mv	a0,s1
80000dc0:	3f19                	jal	80000cd6 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000dc2:	80005537          	lui	a0,0x80005
80000dc6:	f9450513          	addi	a0,a0,-108 # 80004f94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f95>
80000dca:	bf61                	j	80000d62 <z_NanoFatalErrorHandler+0x2c>
		printk("***** Kernel Panic! *****\n");
80000dcc:	80005537          	lui	a0,0x80005
80000dd0:	fb050513          	addi	a0,a0,-80 # 80004fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fb1>
80000dd4:	b779                	j	80000d62 <z_NanoFatalErrorHandler+0x2c>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000dd6:	80005537          	lui	a0,0x80005
80000dda:	85a6                	mv	a1,s1
80000ddc:	fcc50513          	addi	a0,a0,-52 # 80004fcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fcd>
80000de0:	355000ef          	jal	ra,80001934 <printk>
		break;
80000de4:	b749                	j	80000d66 <z_NanoFatalErrorHandler+0x30>

80000de6 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000de6:	1141                	addi	sp,sp,-16
80000de8:	c422                	sw	s0,8(sp)
80000dea:	c606                	sw	ra,12(sp)
80000dec:	842a                	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000dee:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000df2:	0606                	slli	a2,a2,0x1
80000df4:	8205                	srli	a2,a2,0x1
	switch (cause) {
80000df6:	4795                	li	a5,5
80000df8:	02c7e363          	bltu	a5,a2,80000e1e <_Fault+0x38>
80000dfc:	80005737          	lui	a4,0x80005
80000e00:	00261793          	slli	a5,a2,0x2
80000e04:	e5870713          	addi	a4,a4,-424 # 80004e58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e59>
80000e08:	97ba                	add	a5,a5,a4
80000e0a:	438c                	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000e0c:	80005537          	lui	a0,0x80005
80000e10:	e7850513          	addi	a0,a0,-392 # 80004e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e79>
80000e14:	321000ef          	jal	ra,80001934 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000e18:	85a2                	mv	a1,s0
80000e1a:	4501                	li	a0,0
80000e1c:	3f29                	jal	80000d36 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000e1e:	800055b7          	lui	a1,0x80005
80000e22:	e7058593          	addi	a1,a1,-400 # 80004e70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e71>
80000e26:	b7dd                	j	80000e0c <_Fault+0x26>

80000e28 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000e28:	1141                	addi	sp,sp,-16
80000e2a:	c606                	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000e2c:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000e30:	80005537          	lui	a0,0x80005
	mcause &= SOC_MCAUSE_EXP_MASK;
80000e34:	0586                	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000e36:	8185                	srli	a1,a1,0x1
80000e38:	14850513          	addi	a0,a0,328 # 80005148 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005149>
80000e3c:	2f9000ef          	jal	ra,80001934 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000e40:	800055b7          	lui	a1,0x80005
80000e44:	e9458593          	addi	a1,a1,-364 # 80004e94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e95>
80000e48:	4511                	li	a0,4
80000e4a:	35f5                	jal	80000d36 <z_NanoFatalErrorHandler>

80000e4c <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000e4c:	800067b7          	lui	a5,0x80006
80000e50:	87078793          	addi	a5,a5,-1936 # 80005870 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005871>
80000e54:	4398                	lw	a4,0(a5)
80000e56:	cb11                	beqz	a4,80000e6a <z_irq_do_offload+0x1e>
		return;

	tmp = _offload_routine;
80000e58:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000e5c:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000e60:	800067b7          	lui	a5,0x80006
80000e64:	8747a503          	lw	a0,-1932(a5) # 80005874 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005875>
80000e68:	8302                	jr	t1
}
80000e6a:	8082                	ret

80000e6c <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000e6c:	1141                	addi	sp,sp,-16
80000e6e:	c606                	sw	ra,12(sp)
	z_bss_zero();
80000e70:	304010ef          	jal	ra,80002174 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000e74:	31f000ef          	jal	ra,80001992 <soc_interrupt_init>
#endif
	z_cstart();
80000e78:	34e010ef          	jal	ra,800021c6 <z_cstart>

80000e7c <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000e7c:	7179                	addi	sp,sp,-48
80000e7e:	d422                	sw	s0,40(sp)
80000e80:	d226                	sw	s1,36(sp)
80000e82:	d04a                	sw	s2,32(sp)
80000e84:	ce4e                	sw	s3,28(sp)
80000e86:	cc52                	sw	s4,24(sp)
80000e88:	ca56                	sw	s5,20(sp)
80000e8a:	c85a                	sw	s6,16(sp)
80000e8c:	c65e                	sw	s7,12(sp)
80000e8e:	8b3e                	mv	s6,a5
80000e90:	d606                	sw	ra,44(sp)
80000e92:	c462                	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000e94:	47bd                	li	a5,15
{
80000e96:	84aa                	mv	s1,a0
80000e98:	842e                	mv	s0,a1
80000e9a:	89b2                	mv	s3,a2
80000e9c:	8a36                	mv	s4,a3
80000e9e:	8bba                	mv	s7,a4
80000ea0:	8ac2                	mv	s5,a6
80000ea2:	8946                	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000ea4:	06f89463          	bne	a7,a5,80000f0c <z_new_thread+0x90>
80000ea8:	800027b7          	lui	a5,0x80002
80000eac:	14e78793          	addi	a5,a5,334 # 8000214e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000214f>
80000eb0:	06f69363          	bne	a3,a5,80000f16 <z_new_thread+0x9a>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000eb4:	56c2                	lw	a3,48(sp)
80000eb6:	85ca                	mv	a1,s2
80000eb8:	8526                	mv	a0,s1
80000eba:	4611                	li	a2,4
80000ebc:	3a9020ef          	jal	ra,80003a64 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000ec0:	fb098593          	addi	a1,s3,-80
80000ec4:	95a2                	add	a1,a1,s0
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000ec6:	6789                	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000ec8:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000ecc:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000ed0:	99c1                	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000ed2:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000ed6:	c5fc                	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000ed8:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000edc:	50b2                	lw	ra,44(sp)
80000ede:	5422                	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000ee0:	99878793          	addi	a5,a5,-1640 # 80000998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000999>
	stack_init->a0 = (u32_t)thread_func;
80000ee4:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000ee8:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000eec:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000ef0:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000ef4:	c5bc                	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000ef6:	d48c                	sw	a1,40(s1)
}
80000ef8:	5902                	lw	s2,32(sp)
80000efa:	5492                	lw	s1,36(sp)
80000efc:	49f2                	lw	s3,28(sp)
80000efe:	4a62                	lw	s4,24(sp)
80000f00:	4ad2                	lw	s5,20(sp)
80000f02:	4b42                	lw	s6,16(sp)
80000f04:	4bb2                	lw	s7,12(sp)
80000f06:	4c22                	lw	s8,8(sp)
80000f08:	6145                	addi	sp,sp,48
80000f0a:	8082                	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000f0c:	01088693          	addi	a3,a7,16
80000f10:	47f9                	li	a5,30
80000f12:	fad7f1e3          	bgeu	a5,a3,80000eb4 <z_new_thread+0x38>
80000f16:	80005c37          	lui	s8,0x80005
80000f1a:	800055b7          	lui	a1,0x80005
80000f1e:	80005537          	lui	a0,0x80005
80000f22:	170c0613          	addi	a2,s8,368 # 80005170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005171>
80000f26:	46e1                	li	a3,24
80000f28:	19058593          	addi	a1,a1,400 # 80005190 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005191>
80000f2c:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80000f30:	205000ef          	jal	ra,80001934 <printk>
80000f34:	80005537          	lui	a0,0x80005
80000f38:	85ca                	mv	a1,s2
80000f3a:	56c1                	li	a3,-16
80000f3c:	4639                	li	a2,14
80000f3e:	23c50513          	addi	a0,a0,572 # 8000523c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000523d>
80000f42:	1f3000ef          	jal	ra,80001934 <printk>
80000f46:	45e1                	li	a1,24
80000f48:	170c0513          	addi	a0,s8,368
80000f4c:	207000ef          	jal	ra,80001952 <assert_post_action>
80000f50:	b795                	j	80000eb4 <z_new_thread+0x38>

80000f52 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80000f52:	00159793          	slli	a5,a1,0x1
80000f56:	97ae                	add	a5,a5,a1
80000f58:	00279713          	slli	a4,a5,0x2
80000f5c:	455c                	lw	a5,12(a0)
80000f5e:	97ba                	add	a5,a5,a4
80000f60:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80000f64:	00b75363          	bge	a4,a1,80000f6a <get_bit_ptr+0x18>
80000f68:	439c                	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80000f6a:	41f65713          	srai	a4,a2,0x1f
80000f6e:	8b7d                	andi	a4,a4,31
80000f70:	9732                	add	a4,a4,a2
80000f72:	8715                	srai	a4,a4,0x5
80000f74:	070a                	slli	a4,a4,0x2
80000f76:	97ba                	add	a5,a5,a4
80000f78:	c29c                	sw	a5,0(a3)

	return bn & 0x1f;
}
80000f7a:	01f67513          	andi	a0,a2,31
80000f7e:	8082                	ret

80000f80 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000f80:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000f82:	0074                	addi	a3,sp,12
{
80000f84:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000f86:	37f1                	jal	80000f52 <get_bit_ptr>

	*word |= (1<<bit);
80000f88:	4732                	lw	a4,12(sp)
80000f8a:	4785                	li	a5,1
80000f8c:	00a79533          	sll	a0,a5,a0
80000f90:	431c                	lw	a5,0(a4)
}
80000f92:	40f2                	lw	ra,28(sp)
	*word |= (1<<bit);
80000f94:	8fc9                	or	a5,a5,a0
80000f96:	c31c                	sw	a5,0(a4)
}
80000f98:	6105                	addi	sp,sp,32
80000f9a:	8082                	ret

80000f9c <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000f9c:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000f9e:	0074                	addi	a3,sp,12
{
80000fa0:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000fa2:	3f45                	jal	80000f52 <get_bit_ptr>

	*word &= ~(1<<bit);
80000fa4:	4732                	lw	a4,12(sp)
80000fa6:	4785                	li	a5,1
80000fa8:	00a79533          	sll	a0,a5,a0
80000fac:	431c                	lw	a5,0(a4)
}
80000fae:	40f2                	lw	ra,28(sp)
	*word &= ~(1<<bit);
80000fb0:	fff54513          	not	a0,a0
80000fb4:	8d7d                	and	a0,a0,a5
80000fb6:	c308                	sw	a0,0(a4)
}
80000fb8:	6105                	addi	sp,sp,32
80000fba:	8082                	ret

80000fbc <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80000fbc:	1101                	addi	sp,sp,-32
80000fbe:	ca26                	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000fc0:	4144                	lw	s1,4(a0)
{
80000fc2:	cc22                	sw	s0,24(sp)
80000fc4:	842a                	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000fc6:	00855503          	lhu	a0,8(a0)
80000fca:	85a6                	mv	a1,s1
{
80000fcc:	c84a                	sw	s2,16(sp)
80000fce:	c64e                	sw	s3,12(sp)
80000fd0:	c452                	sw	s4,8(sp)
80000fd2:	c256                	sw	s5,4(sp)
80000fd4:	c05a                	sw	s6,0(sp)
80000fd6:	ce06                	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000fd8:	845ff0ef          	jal	ra,8000081c <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000fdc:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80000fe0:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80000fe4:	57fd                	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000fe6:	8a2a                	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000fe8:	99aa                	add	s3,s3,a0
	p->max_inline_level = -1;
80000fea:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80000fee:	4901                	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80000ff0:	4b7d                	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80000ff2:	03594163          	blt	s2,s5,80001014 <z_sys_mem_pool_base_init+0x58>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80000ff6:	4481                	li	s1,0
80000ff8:	00845783          	lhu	a5,8(s0)
80000ffc:	04f4cf63          	blt	s1,a5,8000105a <z_sys_mem_pool_base_init+0x9e>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001000:	40f2                	lw	ra,28(sp)
80001002:	4462                	lw	s0,24(sp)
80001004:	44d2                	lw	s1,20(sp)
80001006:	4942                	lw	s2,16(sp)
80001008:	49b2                	lw	s3,12(sp)
8000100a:	4a22                	lw	s4,8(sp)
8000100c:	4a92                	lw	s5,4(sp)
8000100e:	4b02                	lw	s6,0(sp)
80001010:	6105                	addi	sp,sp,32
80001012:	8082                	ret
		int nblocks = buflen / sz;
80001014:	85a6                	mv	a1,s1
80001016:	8552                	mv	a0,s4
80001018:	8c1ff0ef          	jal	ra,800008d8 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
8000101c:	00191713          	slli	a4,s2,0x1
80001020:	974a                	add	a4,a4,s2
80001022:	00271793          	slli	a5,a4,0x2
80001026:	4458                	lw	a4,12(s0)
80001028:	973e                	add	a4,a4,a5
8000102a:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
8000102e:	c35c                	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80001030:	c71c                	sw	a5,8(a4)
		if (nblocks < 32) {
80001032:	00ab4963          	blt	s6,a0,80001044 <z_sys_mem_pool_base_init+0x88>
			p->max_inline_level = i;
80001036:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
8000103a:	8089                	srli	s1,s1,0x2
8000103c:	048d                	addi	s1,s1,3
8000103e:	98f1                	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
80001040:	0905                	addi	s2,s2,1
80001042:	bf45                	j	80000ff2 <z_sys_mem_pool_base_init+0x36>
			bits += (nblocks + 31)/32;
80001044:	057d                	addi	a0,a0,31
80001046:	41f55793          	srai	a5,a0,0x1f
8000104a:	8bfd                	andi	a5,a5,31
8000104c:	97aa                	add	a5,a5,a0
8000104e:	8795                	srai	a5,a5,0x5
80001050:	078a                	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80001052:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80001056:	99be                	add	s3,s3,a5
80001058:	b7cd                	j	8000103a <z_sys_mem_pool_base_init+0x7e>
	return (u8_t *)p->buf + lsz * block;
8000105a:	404c                	lw	a1,4(s0)
8000105c:	8526                	mv	a0,s1
8000105e:	fbeff0ef          	jal	ra,8000081c <__mulsi3>
80001062:	401c                	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001064:	8626                	mv	a2,s1
80001066:	4581                	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001068:	953e                	add	a0,a0,a5
		sys_dlist_append(&p->levels[0].free_list, block);
8000106a:	445c                	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
8000106c:	0485                	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
8000106e:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001072:	c118                	sw	a4,0(a0)
	node->prev = list->tail;
80001074:	4798                	lw	a4,8(a5)
80001076:	c158                	sw	a4,4(a0)

	list->tail->next = node;
80001078:	4798                	lw	a4,8(a5)
8000107a:	c308                	sw	a0,0(a4)
	list->tail = node;
8000107c:	c788                	sw	a0,8(a5)
		set_free_bit(p, 0, i);
8000107e:	8522                	mv	a0,s0
80001080:	3701                	jal	80000f80 <set_free_bit>
80001082:	bf9d                	j	80000ff8 <z_sys_mem_pool_base_init+0x3c>

80001084 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001084:	711d                	addi	sp,sp,-96
80001086:	cca2                	sw	s0,88(sp)
80001088:	c2d6                	sw	s5,68(sp)
8000108a:	ce86                	sw	ra,92(sp)
8000108c:	caa6                	sw	s1,84(sp)
8000108e:	c8ca                	sw	s2,80(sp)
80001090:	c6ce                	sw	s3,76(sp)
80001092:	c4d2                	sw	s4,72(sp)
80001094:	c0da                	sw	s6,64(sp)
80001096:	de5e                	sw	s7,60(sp)
80001098:	dc62                	sw	s8,56(sp)
8000109a:	da66                	sw	s9,52(sp)
8000109c:	d86a                	sw	s10,48(sp)
8000109e:	d66e                	sw	s11,44(sp)
800010a0:	1080                	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800010a2:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
800010a6:	4881                	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800010a8:	002e1793          	slli	a5,t3,0x2
800010ac:	07bd                	addi	a5,a5,15
800010ae:	7f07f793          	andi	a5,a5,2032
800010b2:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
800010b6:	415c                	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800010b8:	8a8a                	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800010ba:	8356                	mv	t1,s5
800010bc:	078d                	addi	a5,a5,3
800010be:	9bf1                	andi	a5,a5,-4
800010c0:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
800010c4:	fff88b13          	addi	s6,a7,-1
800010c8:	03c8d263          	bge	a7,t3,800010ec <z_sys_mem_pool_block_alloc+0x68>
		if (i > 0) {
800010cc:	00088b63          	beqz	a7,800010e2 <z_sys_mem_pool_block_alloc+0x5e>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800010d0:	ffc32803          	lw	a6,-4(t1) # 7ffffffc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x7ffffffd>
800010d4:	00285813          	srli	a6,a6,0x2
800010d8:	080d                	addi	a6,a6,3
800010da:	ffc87813          	andi	a6,a6,-4
800010de:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
800010e2:	0311                	addi	t1,t1,4
800010e4:	ffc32803          	lw	a6,-4(t1)
800010e8:	02b87963          	bgeu	a6,a1,8000111a <z_sys_mem_pool_block_alloc+0x96>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
800010ec:	55fd                	li	a1,-1
800010ee:	02bb1863          	bne	s6,a1,8000111e <z_sys_mem_pool_block_alloc+0x9a>
		*data_p = NULL;
800010f2:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
800010f6:	5551                	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
800010f8:	fa040113          	addi	sp,s0,-96
800010fc:	40f6                	lw	ra,92(sp)
800010fe:	4466                	lw	s0,88(sp)
80001100:	44d6                	lw	s1,84(sp)
80001102:	4946                	lw	s2,80(sp)
80001104:	49b6                	lw	s3,76(sp)
80001106:	4a26                	lw	s4,72(sp)
80001108:	4a96                	lw	s5,68(sp)
8000110a:	4b06                	lw	s6,64(sp)
8000110c:	5bf2                	lw	s7,60(sp)
8000110e:	5c62                	lw	s8,56(sp)
80001110:	5cd2                	lw	s9,52(sp)
80001112:	5d42                	lw	s10,48(sp)
80001114:	5db2                	lw	s11,44(sp)
80001116:	6125                	addi	sp,sp,96
80001118:	8082                	ret
	for (i = 0; i < p->n_levels; i++) {
8000111a:	0885                	addi	a7,a7,1
8000111c:	b765                	j	800010c4 <z_sys_mem_pool_block_alloc+0x40>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000111e:	01054583          	lbu	a1,16(a0)
		return 0;
80001122:	4901                	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001124:	8985                	andi	a1,a1,1
80001126:	c591                	beqz	a1,80001132 <z_sys_mem_pool_block_alloc+0xae>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80001128:	4921                	li	s2,8
8000112a:	30093973          	csrrc	s2,mstatus,s2
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
8000112e:	00897913          	andi	s2,s2,8
80001132:	fae42a23          	sw	a4,-76(s0)
80001136:	001b1713          	slli	a4,s6,0x1
8000113a:	fad42c23          	sw	a3,-72(s0)
8000113e:	975a                	add	a4,a4,s6
80001140:	4554                	lw	a3,12(a0)
80001142:	070a                	slli	a4,a4,0x2
80001144:	0711                	addi	a4,a4,4
80001146:	9736                	add	a4,a4,a3
80001148:	fac42e23          	sw	a2,-68(s0)
8000114c:	84aa                	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
8000114e:	8a5a                	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
80001150:	56fd                	li	a3,-1
	return list->head == list;
80001152:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001156:	13370863          	beq	a4,s3,80001286 <z_sys_mem_pool_block_alloc+0x202>
		data = block_alloc(p, i, lsizes[i]);
8000115a:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
8000115e:	0049a683          	lw	a3,4(s3)
80001162:	00ea8cb3          	add	s9,s5,a4
80001166:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000116a:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000116e:	4d21                	li	s10,8
80001170:	c298                	sw	a4,0(a3)
	node->next->prev = node->prev;
80001172:	c354                	sw	a3,4(a4)
	node->next = NULL;
80001174:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80001178:	0009a223          	sw	zero,4(s3)
8000117c:	4088                	lw	a0,0(s1)
8000117e:	40a98533          	sub	a0,s3,a0
80001182:	f4eff0ef          	jal	ra,800008d0 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
80001186:	862a                	mv	a2,a0
80001188:	85d2                	mv	a1,s4
8000118a:	8526                	mv	a0,s1
8000118c:	3d01                	jal	80000f9c <clear_free_bit>
		if (data != NULL) {
8000118e:	0a05                	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
80001190:	fffa0693          	addi	a3,s4,-1
80001194:	0566c263          	blt	a3,s6,800011d8 <z_sys_mem_pool_block_alloc+0x154>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001198:	0104c703          	lbu	a4,16(s1)
8000119c:	8b05                	andi	a4,a4,1
8000119e:	c319                	beqz	a4,800011a4 <z_sys_mem_pool_block_alloc+0x120>
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
800011a0:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
800011a4:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
800011a8:	5551                	li	a0,-12
	*data_p = data;
800011aa:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
800011ae:	f40985e3          	beqz	s3,800010f8 <z_sys_mem_pool_block_alloc+0x74>
	*level_p = alloc_l;
800011b2:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800011b6:	4088                	lw	a0,0(s1)
	*level_p = alloc_l;
800011b8:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
800011bc:	002b1793          	slli	a5,s6,0x2
800011c0:	9abe                	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800011c2:	000aa583          	lw	a1,0(s5)
800011c6:	40a98533          	sub	a0,s3,a0
800011ca:	f06ff0ef          	jal	ra,800008d0 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
800011ce:	fb842783          	lw	a5,-72(s0)
800011d2:	c388                	sw	a0,0(a5)
	return 0;
800011d4:	4501                	li	a0,0
800011d6:	b70d                	j	800010f8 <z_sys_mem_pool_block_alloc+0x74>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800011d8:	4088                	lw	a0,0(s1)
800011da:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
800011de:	4b85                	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800011e0:	40a98533          	sub	a0,s3,a0
800011e4:	eecff0ef          	jal	ra,800008d0 <__divsi3>
800011e8:	001a1893          	slli	a7,s4,0x1
800011ec:	98d2                	add	a7,a7,s4
		int lbn = 4*bn + i;
800011ee:	00251d93          	slli	s11,a0,0x2
800011f2:	088a                	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
800011f4:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
800011f8:	85de                	mv	a1,s7
800011fa:	fb142623          	sw	a7,-84(s0)
800011fe:	8536                	mv	a0,a3
80001200:	fad42823          	sw	a3,-80(s0)
80001204:	e18ff0ef          	jal	ra,8000081c <__mulsi3>
80001208:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
8000120c:	01bb8633          	add	a2,s7,s11
80001210:	85d2                	mv	a1,s4
80001212:	8526                	mv	a0,s1
80001214:	33b5                	jal	80000f80 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001216:	fb042683          	lw	a3,-80(s0)
8000121a:	4090                	lw	a2,0(s1)
	return p->n_max * p->max_sz;
8000121c:	40cc                	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000121e:	16fd                	addi	a3,a3,-1
	return p->n_max * p->max_sz;
80001220:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001224:	96e2                	add	a3,a3,s8
80001226:	8e91                	sub	a3,a3,a2
80001228:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
8000122c:	df0ff0ef          	jal	ra,8000081c <__mulsi3>
		if (block_fits(p, block2, lsz)) {
80001230:	fb042683          	lw	a3,-80(s0)
80001234:	fac42883          	lw	a7,-84(s0)
80001238:	02a6f063          	bgeu	a3,a0,80001258 <z_sys_mem_pool_block_alloc+0x1d4>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
8000123c:	44d4                	lw	a3,12(s1)
8000123e:	96c6                	add	a3,a3,a7
80001240:	00468613          	addi	a2,a3,4
	node->next = list;
80001244:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
80001248:	4690                	lw	a2,8(a3)
8000124a:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
8000124e:	4690                	lw	a2,8(a3)
80001250:	01862023          	sw	s8,0(a2)
	list->tail = node;
80001254:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
80001258:	0b85                	addi	s7,s7,1
8000125a:	4791                	li	a5,4
8000125c:	f8fb9ce3          	bne	s7,a5,800011f4 <z_sys_mem_pool_block_alloc+0x170>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001260:	0104c683          	lbu	a3,16(s1)
80001264:	8a85                	andi	a3,a3,1
80001266:	e689                	bnez	a3,80001270 <z_sys_mem_pool_block_alloc+0x1ec>
		return 0;
80001268:	4901                	li	s2,0
8000126a:	0a05                	addi	s4,s4,1
8000126c:	0c91                	addi	s9,s9,4
8000126e:	b70d                	j	80001190 <z_sys_mem_pool_block_alloc+0x10c>
80001270:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001274:	0104c683          	lbu	a3,16(s1)
80001278:	8a85                	andi	a3,a3,1
8000127a:	d6fd                	beqz	a3,80001268 <z_sys_mem_pool_block_alloc+0x1e4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000127c:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
80001280:	00897913          	andi	s2,s2,8
80001284:	b7dd                	j	8000126a <z_sys_mem_pool_block_alloc+0x1e6>
	for (i = alloc_l; i >= 0; i--) {
80001286:	1a7d                	addi	s4,s4,-1
80001288:	ff498713          	addi	a4,s3,-12
8000128c:	ecda13e3          	bne	s4,a3,80001152 <z_sys_mem_pool_block_alloc+0xce>
80001290:	4981                	li	s3,0
80001292:	b719                	j	80001198 <z_sys_mem_pool_block_alloc+0x114>

80001294 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001294:	711d                	addi	sp,sp,-96
80001296:	cca2                	sw	s0,88(sp)
80001298:	c4d2                	sw	s4,72(sp)
8000129a:	da66                	sw	s9,52(sp)
8000129c:	ce86                	sw	ra,92(sp)
8000129e:	caa6                	sw	s1,84(sp)
800012a0:	c8ca                	sw	s2,80(sp)
800012a2:	c6ce                	sw	s3,76(sp)
800012a4:	c2d6                	sw	s5,68(sp)
800012a6:	c0da                	sw	s6,64(sp)
800012a8:	de5e                	sw	s7,60(sp)
800012aa:	dc62                	sw	s8,56(sp)
800012ac:	d86a                	sw	s10,48(sp)
800012ae:	d66e                	sw	s11,44(sp)
800012b0:	1080                	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800012b2:	00a54703          	lbu	a4,10(a0)
{
800012b6:	8caa                	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800012b8:	070a                	slli	a4,a4,0x2
800012ba:	073d                	addi	a4,a4,15
800012bc:	7f077713          	andi	a4,a4,2032
800012c0:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
800012c4:	4158                	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800012c6:	8a0a                	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800012c8:	86d2                	mv	a3,s4
800012ca:	070d                	addi	a4,a4,3
800012cc:	9b71                	andi	a4,a4,-4
800012ce:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
800012d2:	4505                	li	a0,1
800012d4:	0691                	addi	a3,a3,4
800012d6:	08a5f363          	bgeu	a1,a0,8000135c <z_sys_mem_pool_block_free+0xc8>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800012da:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
800012de:	892e                	mv	s2,a1
800012e0:	89b2                	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800012e2:	8b05                	andi	a4,a4,1
		return 0;
800012e4:	4481                	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800012e6:	c709                	beqz	a4,800012f0 <z_sys_mem_pool_block_free+0x5c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800012e8:	44a1                	li	s1,8
800012ea:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
800012ee:	88a1                	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800012f0:	80005b37          	lui	s6,0x80005
	while (level >= 0) {
800012f4:	06095c63          	bgez	s2,8000136c <z_sys_mem_pool_block_free+0xd8>
	__ASSERT(0, "out of levels");
800012f8:	800054b7          	lui	s1,0x80005
800012fc:	800055b7          	lui	a1,0x80005
80001300:	80005537          	lui	a0,0x80005
80001304:	27048613          	addi	a2,s1,624 # 80005270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005271>
80001308:	0c000693          	li	a3,192
8000130c:	2d858593          	addi	a1,a1,728 # 800052d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d9>
80001310:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80001314:	2505                	jal	80001934 <printk>
80001316:	80005537          	lui	a0,0x80005
8000131a:	2a450513          	addi	a0,a0,676 # 800052a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a5>
8000131e:	2d19                	jal	80001934 <printk>
80001320:	27048513          	addi	a0,s1,624
80001324:	0c000593          	li	a1,192
80001328:	252d                	jal	80001952 <assert_post_action>
	return -1;
8000132a:	54fd                	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000132c:	010cc783          	lbu	a5,16(s9)
80001330:	8b85                	andi	a5,a5,1
80001332:	c781                	beqz	a5,8000133a <z_sys_mem_pool_block_free+0xa6>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80001334:	88a1                	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001336:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000133a:	fa040113          	addi	sp,s0,-96
8000133e:	40f6                	lw	ra,92(sp)
80001340:	4466                	lw	s0,88(sp)
80001342:	44d6                	lw	s1,84(sp)
80001344:	4946                	lw	s2,80(sp)
80001346:	49b6                	lw	s3,76(sp)
80001348:	4a26                	lw	s4,72(sp)
8000134a:	4a96                	lw	s5,68(sp)
8000134c:	4b06                	lw	s6,64(sp)
8000134e:	5bf2                	lw	s7,60(sp)
80001350:	5c62                	lw	s8,56(sp)
80001352:	5cd2                	lw	s9,52(sp)
80001354:	5d42                	lw	s10,48(sp)
80001356:	5db2                	lw	s11,44(sp)
80001358:	6125                	addi	sp,sp,96
8000135a:	8082                	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000135c:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
80001360:	0505                	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001362:	8309                	srli	a4,a4,0x2
80001364:	070d                	addi	a4,a4,3
80001366:	9b71                	andi	a4,a4,-4
80001368:	c298                	sw	a4,0(a3)
8000136a:	b7ad                	j	800012d4 <z_sys_mem_pool_block_free+0x40>
		int i, lsz = lsizes[level];
8000136c:	00291713          	slli	a4,s2,0x2
80001370:	9752                	add	a4,a4,s4
80001372:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
80001376:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
8000137a:	854e                	mv	a0,s3
8000137c:	85d6                	mv	a1,s5
8000137e:	c9eff0ef          	jal	ra,8000081c <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001382:	fffa8b93          	addi	s7,s5,-1
80001386:	01750d33          	add	s10,a0,s7
8000138a:	9c2a                	add	s8,s8,a0
	return p->n_max * p->max_sz;
8000138c:	004ca583          	lw	a1,4(s9)
80001390:	008cd503          	lhu	a0,8(s9)
80001394:	c88ff0ef          	jal	ra,8000081c <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
80001398:	02ad6963          	bltu	s10,a0,800013ca <z_sys_mem_pool_block_free+0x136>
8000139c:	800057b7          	lui	a5,0x80005
800013a0:	28478593          	addi	a1,a5,644 # 80005284 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005285>
800013a4:	800057b7          	lui	a5,0x80005
800013a8:	21c78513          	addi	a0,a5,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800013ac:	0a400693          	li	a3,164
800013b0:	270b0613          	addi	a2,s6,624 # 80005270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005271>
800013b4:	2341                	jal	80001934 <printk>
800013b6:	800057b7          	lui	a5,0x80005
800013ba:	2a078513          	addi	a0,a5,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
800013be:	2b9d                	jal	80001934 <printk>
800013c0:	0a400593          	li	a1,164
800013c4:	270b0513          	addi	a0,s6,624
800013c8:	2369                	jal	80001952 <assert_post_action>
		set_free_bit(p, level, bn);
800013ca:	864e                	mv	a2,s3
800013cc:	85ca                	mv	a1,s2
800013ce:	8566                	mv	a0,s9
800013d0:	3e45                	jal	80000f80 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
800013d2:	00191713          	slli	a4,s2,0x1
800013d6:	974a                	add	a4,a4,s2
800013d8:	00271693          	slli	a3,a4,0x2
800013dc:	00cca703          	lw	a4,12(s9)
800013e0:	9736                	add	a4,a4,a3
800013e2:	00470693          	addi	a3,a4,4
	node->next = list;
800013e6:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
800013ea:	4714                	lw	a3,8(a4)
800013ec:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
800013f0:	4714                	lw	a3,8(a4)
800013f2:	0186a023          	sw	s8,0(a3)
	list->tail = node;
800013f6:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013fa:	010cc703          	lbu	a4,16(s9)
800013fe:	8b05                	andi	a4,a4,1
80001400:	e345                	bnez	a4,800014a0 <z_sys_mem_pool_block_free+0x20c>
		return 0;
80001402:	4481                	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001404:	f20904e3          	beqz	s2,8000132c <z_sys_mem_pool_block_free+0x98>
	int bit = get_bit_ptr(p, level, bn, &word);
80001408:	fbc40693          	addi	a3,s0,-68
8000140c:	864e                	mv	a2,s3
8000140e:	85ca                	mv	a1,s2
80001410:	8566                	mv	a0,s9
80001412:	3681                	jal	80000f52 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80001414:	fbc42683          	lw	a3,-68(s0)
80001418:	41f55713          	srai	a4,a0,0x1f
8000141c:	8b0d                	andi	a4,a4,3
8000141e:	972a                	add	a4,a4,a0
80001420:	4288                	lw	a0,0(a3)
80001422:	9b71                	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001424:	47bd                	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
80001426:	00e55733          	srl	a4,a0,a4
8000142a:	8b3d                	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
8000142c:	f0f710e3          	bne	a4,a5,8000132c <z_sys_mem_pool_block_free+0x98>
		for (i = 0; i < 4; i++) {
80001430:	4d01                	li	s10,0
			int b = (bn & ~3) + i;
80001432:	ffc9fd93          	andi	s11,s3,-4
80001436:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
8000143a:	8532                	mv	a0,a2
8000143c:	85d6                	mv	a1,s5
8000143e:	fac42423          	sw	a2,-88(s0)
80001442:	bdaff0ef          	jal	ra,8000081c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001446:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
8000144a:	8c2a                	mv	s8,a0
	return p->n_max * p->max_sz;
8000144c:	004ca583          	lw	a1,4(s9)
80001450:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001454:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001458:	bc4ff0ef          	jal	ra,8000081c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
8000145c:	fac42703          	lw	a4,-84(s0)
80001460:	fa842603          	lw	a2,-88(s0)
80001464:	02a77263          	bgeu	a4,a0,80001488 <z_sys_mem_pool_block_free+0x1f4>
				clear_free_bit(p, level, b);
80001468:	85ca                	mv	a1,s2
8000146a:	8566                	mv	a0,s9
8000146c:	3e05                	jal	80000f9c <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
8000146e:	000ca703          	lw	a4,0(s9)
80001472:	9c3a                	add	s8,s8,a4
	node->prev->next = node->next;
80001474:	004c2603          	lw	a2,4(s8)
80001478:	000c2703          	lw	a4,0(s8)
8000147c:	c218                	sw	a4,0(a2)
	node->next->prev = node->prev;
8000147e:	c350                	sw	a2,4(a4)
	node->next = NULL;
80001480:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80001484:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80001488:	0d05                	addi	s10,s10,1
8000148a:	4791                	li	a5,4
8000148c:	fafd15e3          	bne	s10,a5,80001436 <z_sys_mem_pool_block_free+0x1a2>
		bn = bn / 4;
80001490:	41f9d613          	srai	a2,s3,0x1f
80001494:	8a0d                	andi	a2,a2,3
80001496:	99b2                	add	s3,s3,a2
		level = level - 1;
80001498:	197d                	addi	s2,s2,-1
		bn = bn / 4;
8000149a:	4029d993          	srai	s3,s3,0x2
8000149e:	bd99                	j	800012f4 <z_sys_mem_pool_block_free+0x60>
800014a0:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800014a4:	010cc703          	lbu	a4,16(s9)
800014a8:	8b05                	andi	a4,a4,1
800014aa:	df21                	beqz	a4,80001402 <z_sys_mem_pool_block_free+0x16e>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800014ac:	47a1                	li	a5,8
800014ae:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
800014b2:	88a1                	andi	s1,s1,8
800014b4:	bf81                	j	80001404 <z_sys_mem_pool_block_free+0x170>

800014b6 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
800014b6:	1141                	addi	sp,sp,-16
800014b8:	87aa                	mv	a5,a0
800014ba:	852e                	mv	a0,a1
800014bc:	85b2                	mv	a1,a2
	entry(p1, p2, p3);
800014be:	8636                	mv	a2,a3
{
800014c0:	c606                	sw	ra,12(sp)
	entry(p1, p2, p3);
800014c2:	9782                	jalr	a5
800014c4:	238020ef          	jal	ra,800036fc <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800014c8:	03b020ef          	jal	ra,80003d02 <z_impl_k_thread_abort>

800014cc <z_work_q_main>:

#include <kernel.h>
#define WORKQUEUE_THREAD_NAME	"workqueue"

void z_work_q_main(void *work_q_ptr, void *p2, void *p3)
{
800014cc:	1141                	addi	sp,sp,-16
800014ce:	c226                	sw	s1,4(sp)
800014d0:	c606                	sw	ra,12(sp)
800014d2:	c422                	sw	s0,8(sp)
800014d4:	c04a                	sw	s2,0(sp)
800014d6:	84aa                	mv	s1,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
800014d8:	55fd                	li	a1,-1
800014da:	8526                	mv	a0,s1
800014dc:	79d000ef          	jal	ra,80002478 <z_impl_k_queue_get>
800014e0:	842a                	mv	s0,a0
	while (true) {
		struct k_work *work;
		k_work_handler_t handler;

		work = k_queue_get(&work_q->queue, K_FOREVER);
		if (work == NULL) {
800014e2:	d97d                	beqz	a0,800014d8 <z_work_q_main+0xc>
			continue;
		}

		handler = work->handler;
800014e4:	00452903          	lw	s2,4(a0)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_XOR, atomic_xor, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_AND, atomic_and, atomic_val_t, atomic_t *, target, atomic_val_t, value)
800014e8:	55f9                	li	a1,-2
800014ea:	0521                	addi	a0,a0,8
800014ec:	184030ef          	jal	ra,80004670 <z_impl_atomic_and>
	return (old & mask) != 0;
800014f0:	8905                	andi	a0,a0,1

		/* Reset pending state so it can be resubmitted by handler */
		if (atomic_test_and_clear_bit(work->flags,
800014f2:	c119                	beqz	a0,800014f8 <z_work_q_main+0x2c>
					      K_WORK_STATE_PENDING)) {
			handler(work);
800014f4:	8522                	mv	a0,s0
800014f6:	9902                	jalr	s2
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800014f8:	066020ef          	jal	ra,8000355e <z_impl_k_yield>
800014fc:	bff1                	j	800014d8 <z_work_q_main+0xc>

800014fe <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
800014fe:	4501                	li	a0,0
80001500:	8082                	ret

80001502 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001502:	1141                	addi	sp,sp,-16
80001504:	c422                	sw	s0,8(sp)
80001506:	842a                	mv	s0,a0
	out('E', ctx);
80001508:	04500513          	li	a0,69
{
8000150c:	c606                	sw	ra,12(sp)
8000150e:	c226                	sw	s1,4(sp)
80001510:	84ae                	mv	s1,a1
	out('E', ctx);
80001512:	9402                	jalr	s0
	out('R', ctx);
80001514:	85a6                	mv	a1,s1
80001516:	05200513          	li	a0,82
8000151a:	9402                	jalr	s0
	out('R', ctx);
8000151c:	8322                	mv	t1,s0
}
8000151e:	4422                	lw	s0,8(sp)
80001520:	40b2                	lw	ra,12(sp)
	out('R', ctx);
80001522:	85a6                	mv	a1,s1
}
80001524:	4492                	lw	s1,4(sp)
	out('R', ctx);
80001526:	05200513          	li	a0,82
}
8000152a:	0141                	addi	sp,sp,16
	out('R', ctx);
8000152c:	8302                	jr	t1

8000152e <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
8000152e:	419c                	lw	a5,0(a1)
80001530:	0785                	addi	a5,a5,1
80001532:	c19c                	sw	a5,0(a1)
	return _char_out(c);
80001534:	800057b7          	lui	a5,0x80005
80001538:	7c47a303          	lw	t1,1988(a5) # 800057c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c5>
8000153c:	8302                	jr	t1

8000153e <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
8000153e:	7139                	addi	sp,sp,-64
80001540:	dc22                	sw	s0,56(sp)
80001542:	d64e                	sw	s3,44(sp)
80001544:	d452                	sw	s4,40(sp)
80001546:	d05a                	sw	s6,32(sp)
80001548:	c86a                	sw	s10,16(sp)
8000154a:	de06                	sw	ra,60(sp)
8000154c:	da26                	sw	s1,52(sp)
8000154e:	d84a                	sw	s2,48(sp)
80001550:	d256                	sw	s5,36(sp)
80001552:	ce5e                	sw	s7,28(sp)
80001554:	cc62                	sw	s8,24(sp)
80001556:	ca66                	sw	s9,20(sp)
80001558:	c66e                	sw	s11,12(sp)
8000155a:	89aa                	mv	s3,a0
8000155c:	8a2e                	mv	s4,a1
8000155e:	8d32                	mv	s10,a2
80001560:	8b36                	mv	s6,a3
80001562:	4405                	li	s0,1
80001564:	00e05363          	blez	a4,8000156a <_printk_dec_ulong+0x2c>
80001568:	843a                	mv	s0,a4
8000156a:	4785                	li	a5,1
8000156c:	02000c93          	li	s9,32
80001570:	00fb1463          	bne	s6,a5,80001578 <_printk_dec_ulong+0x3a>
80001574:	03000c93          	li	s9,48
80001578:	3b9ad4b7          	lui	s1,0x3b9ad
8000157c:	4905                	li	s2,1
8000157e:	4aa9                	li	s5,10
80001580:	4c01                	li	s8,0
80001582:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001586:	4d89                	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001588:	00148b93          	addi	s7,s1,1
8000158c:	000c1463          	bnez	s8,80001594 <_printk_dec_ulong+0x56>
80001590:	07a4f263          	bgeu	s1,s10,800015f4 <_printk_dec_ulong+0xb6>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001594:	85de                	mv	a1,s7
80001596:	856a                	mv	a0,s10
80001598:	b40ff0ef          	jal	ra,800008d8 <__udivsi3>
8000159c:	85d2                	mv	a1,s4
8000159e:	03050513          	addi	a0,a0,48
800015a2:	9982                	jalr	s3
			digits++;
800015a4:	0905                	addi	s2,s2,1
			found_largest_digit = 1;
800015a6:	4c05                	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
800015a8:	85de                	mv	a1,s7
800015aa:	856a                	mv	a0,s10
800015ac:	b74ff0ef          	jal	ra,80000920 <__umodsi3>
800015b0:	8d2a                	mv	s10,a0
		pos /= 10;
800015b2:	45a9                	li	a1,10
800015b4:	8526                	mv	a0,s1
800015b6:	b22ff0ef          	jal	ra,800008d8 <__udivsi3>
		remaining--;
800015ba:	1afd                	addi	s5,s5,-1
	while (pos >= 9) {
800015bc:	4785                	li	a5,1
		pos /= 10;
800015be:	84aa                	mv	s1,a0
	while (pos >= 9) {
800015c0:	fcfa94e3          	bne	s5,a5,80001588 <_printk_dec_ulong+0x4a>
	}
	out((int)(remainder + 48), ctx);
800015c4:	85d2                	mv	a1,s4
800015c6:	030d0513          	addi	a0,s10,48
800015ca:	9982                	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
800015cc:	478d                	li	a5,3
		remaining = min_width - digits;
800015ce:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
800015d2:	02fb0f63          	beq	s6,a5,80001610 <_printk_dec_ulong+0xd2>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
800015d6:	50f2                	lw	ra,60(sp)
800015d8:	5462                	lw	s0,56(sp)
800015da:	54d2                	lw	s1,52(sp)
800015dc:	5942                	lw	s2,48(sp)
800015de:	59b2                	lw	s3,44(sp)
800015e0:	5a22                	lw	s4,40(sp)
800015e2:	5a92                	lw	s5,36(sp)
800015e4:	5b02                	lw	s6,32(sp)
800015e6:	4bf2                	lw	s7,28(sp)
800015e8:	4c62                	lw	s8,24(sp)
800015ea:	4cd2                	lw	s9,20(sp)
800015ec:	4d42                	lw	s10,16(sp)
800015ee:	4db2                	lw	s11,12(sp)
800015f0:	6121                	addi	sp,sp,64
800015f2:	8082                	ret
		} else if (remaining <= min_width
800015f4:	fb544ae3          	blt	s0,s5,800015a8 <_printk_dec_ulong+0x6a>
				&& padding < PAD_SPACE_AFTER) {
800015f8:	fb6de8e3          	bltu	s11,s6,800015a8 <_printk_dec_ulong+0x6a>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
800015fc:	85d2                	mv	a1,s4
800015fe:	8566                	mv	a0,s9
80001600:	9982                	jalr	s3
			digits++;
80001602:	0905                	addi	s2,s2,1
80001604:	b755                	j	800015a8 <_printk_dec_ulong+0x6a>
			out(' ', ctx);
80001606:	85d2                	mv	a1,s4
80001608:	02000513          	li	a0,32
8000160c:	9982                	jalr	s3
8000160e:	147d                	addi	s0,s0,-1
		while (remaining-- > 0) {
80001610:	fe804be3          	bgtz	s0,80001606 <_printk_dec_ulong+0xc8>
80001614:	b7c9                	j	800015d6 <_printk_dec_ulong+0x98>

80001616 <__printk_hook_install>:
	_char_out = fn;
80001616:	800057b7          	lui	a5,0x80005
8000161a:	7ca7a223          	sw	a0,1988(a5) # 800057c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c5>
}
8000161e:	8082                	ret

80001620 <z_vprintk>:
{
80001620:	715d                	addi	sp,sp,-80
80001622:	c4a2                	sw	s0,72(sp)
80001624:	c2a6                	sw	s1,68(sp)
80001626:	c0ca                	sw	s2,64(sp)
80001628:	de4e                	sw	s3,60(sp)
8000162a:	dc52                	sw	s4,56(sp)
8000162c:	da56                	sw	s5,52(sp)
8000162e:	d266                	sw	s9,36(sp)
80001630:	d06a                	sw	s10,32(sp)
80001632:	ce6e                	sw	s11,28(sp)
80001634:	c686                	sw	ra,76(sp)
80001636:	d85a                	sw	s6,48(sp)
80001638:	d65e                	sw	s7,44(sp)
8000163a:	d462                	sw	s8,40(sp)
8000163c:	842a                	mv	s0,a0
8000163e:	84ae                	mv	s1,a1
80001640:	8ab2                	mv	s5,a2
80001642:	8d36                	mv	s10,a3
	int long_ctr = 0;
80001644:	4a01                	li	s4,0
	int min_width = -1;
80001646:	597d                	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001648:	4981                	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
8000164a:	4c81                	li	s9,0
					if (lld > INT32_MAX ||
8000164c:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001650:	000ac503          	lbu	a0,0(s5)
80001654:	e105                	bnez	a0,80001674 <z_vprintk+0x54>
}
80001656:	40b6                	lw	ra,76(sp)
80001658:	4426                	lw	s0,72(sp)
8000165a:	4496                	lw	s1,68(sp)
8000165c:	4906                	lw	s2,64(sp)
8000165e:	59f2                	lw	s3,60(sp)
80001660:	5a62                	lw	s4,56(sp)
80001662:	5ad2                	lw	s5,52(sp)
80001664:	5b42                	lw	s6,48(sp)
80001666:	5bb2                	lw	s7,44(sp)
80001668:	5c22                	lw	s8,40(sp)
8000166a:	5c92                	lw	s9,36(sp)
8000166c:	5d02                	lw	s10,32(sp)
8000166e:	4df2                	lw	s11,28(sp)
80001670:	6161                	addi	sp,sp,80
80001672:	8082                	ret
		if (!might_format) {
80001674:	000c9a63          	bnez	s9,80001688 <z_vprintk+0x68>
			if (*fmt != '%') {
80001678:	02500693          	li	a3,37
8000167c:	28d50563          	beq	a0,a3,80001906 <z_vprintk+0x2e6>
				out((int)*fmt, ctx);
80001680:	85a6                	mv	a1,s1
80001682:	9402                	jalr	s0
		++fmt;
80001684:	0a85                	addi	s5,s5,1
80001686:	b7e9                	j	80001650 <z_vprintk+0x30>
			switch (*fmt) {
80001688:	06400693          	li	a3,100
8000168c:	0ed50b63          	beq	a0,a3,80001782 <z_vprintk+0x162>
80001690:	04a6eb63          	bltu	a3,a0,800016e6 <z_vprintk+0xc6>
80001694:	03900693          	li	a3,57
80001698:	02a6e763          	bltu	a3,a0,800016c6 <z_vprintk+0xa6>
8000169c:	03100693          	li	a3,49
800016a0:	0cd57563          	bgeu	a0,a3,8000176a <z_vprintk+0x14a>
800016a4:	02d00693          	li	a3,45
800016a8:	26d50463          	beq	a0,a3,80001910 <z_vprintk+0x2f0>
800016ac:	03000793          	li	a5,48
800016b0:	0af50363          	beq	a0,a5,80001756 <z_vprintk+0x136>
800016b4:	02500713          	li	a4,37
800016b8:	00e51f63          	bne	a0,a4,800016d6 <z_vprintk+0xb6>
				out((int)'%', ctx);
800016bc:	85a6                	mv	a1,s1
800016be:	02500513          	li	a0,37
				out((int)*fmt, ctx);
800016c2:	9402                	jalr	s0
				break;
800016c4:	aa09                	j	800017d6 <z_vprintk+0x1b6>
800016c6:	05800693          	li	a3,88
800016ca:	14d50b63          	beq	a0,a3,80001820 <z_vprintk+0x200>
800016ce:	06300713          	li	a4,99
800016d2:	22e50363          	beq	a0,a4,800018f8 <z_vprintk+0x2d8>
				out((int)'%', ctx);
800016d6:	85a6                	mv	a1,s1
800016d8:	02500513          	li	a0,37
800016dc:	9402                	jalr	s0
				out((int)*fmt, ctx);
800016de:	85a6                	mv	a1,s1
800016e0:	000ac503          	lbu	a0,0(s5)
800016e4:	bff9                	j	800016c2 <z_vprintk+0xa2>
800016e6:	07000693          	li	a3,112
800016ea:	12d50163          	beq	a0,a3,8000180c <z_vprintk+0x1ec>
800016ee:	00a6ef63          	bltu	a3,a0,8000170c <z_vprintk+0xec>
800016f2:	06900693          	li	a3,105
800016f6:	08d50663          	beq	a0,a3,80001782 <z_vprintk+0x162>
800016fa:	06c00693          	li	a3,108
800016fe:	08d50063          	beq	a0,a3,8000177e <z_vprintk+0x15e>
80001702:	06800693          	li	a3,104
80001706:	f6d50fe3          	beq	a0,a3,80001684 <z_vprintk+0x64>
8000170a:	b7f1                	j	800016d6 <z_vprintk+0xb6>
8000170c:	07500693          	li	a3,117
80001710:	0cd50563          	beq	a0,a3,800017da <z_vprintk+0x1ba>
80001714:	02a6ea63          	bltu	a3,a0,80001748 <z_vprintk+0x128>
80001718:	07300713          	li	a4,115
8000171c:	fae51de3          	bne	a0,a4,800016d6 <z_vprintk+0xb6>
				char *s = va_arg(ap, char *);
80001720:	000d2c03          	lw	s8,0(s10)
80001724:	004d0b13          	addi	s6,s10,4
80001728:	8be2                	mv	s7,s8
				while (*s)
8000172a:	000bc503          	lbu	a0,0(s7)
8000172e:	1a051b63          	bnez	a0,800018e4 <z_vprintk+0x2c4>
				if (padding == PAD_SPACE_AFTER) {
80001732:	478d                	li	a5,3
80001734:	00f99863          	bne	s3,a5,80001744 <z_vprintk+0x124>
					int remaining = min_width - (s - start);
80001738:	418b8bb3          	sub	s7,s7,s8
8000173c:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001740:	1b704663          	bgtz	s7,800018ec <z_vprintk+0x2cc>
				char *s = va_arg(ap, char *);
80001744:	8d5a                	mv	s10,s6
80001746:	a841                	j	800017d6 <z_vprintk+0x1b6>
80001748:	07800693          	li	a3,120
8000174c:	0cd50a63          	beq	a0,a3,80001820 <z_vprintk+0x200>
80001750:	07a00693          	li	a3,122
80001754:	bf4d                	j	80001706 <z_vprintk+0xe6>
				if (min_width < 0 && padding == PAD_NONE) {
80001756:	00095c63          	bgez	s2,8000176e <z_vprintk+0x14e>
8000175a:	1a098d63          	beqz	s3,80001914 <z_vprintk+0x2f4>
					min_width = *fmt - '0';
8000175e:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001762:	f20991e3          	bnez	s3,80001684 <z_vprintk+0x64>
					padding = PAD_SPACE_BEFORE;
80001766:	4989                	li	s3,2
80001768:	bf31                	j	80001684 <z_vprintk+0x64>
				if (min_width < 0) {
8000176a:	fe094ae3          	bltz	s2,8000175e <z_vprintk+0x13e>
					min_width = 10 * min_width + *fmt - '0';
8000176e:	00291693          	slli	a3,s2,0x2
80001772:	9936                	add	s2,s2,a3
80001774:	0906                	slli	s2,s2,0x1
80001776:	fd090913          	addi	s2,s2,-48
8000177a:	992a                	add	s2,s2,a0
8000177c:	b7dd                	j	80001762 <z_vprintk+0x142>
				long_ctr++;
8000177e:	0a05                	addi	s4,s4,1
80001780:	b711                	j	80001684 <z_vprintk+0x64>
				if (long_ctr == 0) {
80001782:	020a1663          	bnez	s4,800017ae <z_vprintk+0x18e>
					long ld = va_arg(ap, long);
80001786:	000d2603          	lw	a2,0(s10)
8000178a:	0d11                	addi	s10,s10,4
				if (d < 0) {
8000178c:	00065b63          	bgez	a2,800017a2 <z_vprintk+0x182>
					out((int)'-', ctx);
80001790:	85a6                	mv	a1,s1
80001792:	02d00513          	li	a0,45
80001796:	c032                	sw	a2,0(sp)
80001798:	9402                	jalr	s0
					d = -d;
8000179a:	4602                	lw	a2,0(sp)
					min_width--;
8000179c:	197d                	addi	s2,s2,-1
					d = -d;
8000179e:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
800017a2:	874a                	mv	a4,s2
800017a4:	86ce                	mv	a3,s3
800017a6:	85a6                	mv	a1,s1
800017a8:	8522                	mv	a0,s0
800017aa:	3b51                	jal	8000153e <_printk_dec_ulong>
				break;
800017ac:	a02d                	j	800017d6 <z_vprintk+0x1b6>
				} else if (long_ctr == 1) {
800017ae:	4705                	li	a4,1
800017b0:	fcea0be3          	beq	s4,a4,80001786 <z_vprintk+0x166>
					long long lld = va_arg(ap, long long);
800017b4:	007d0793          	addi	a5,s10,7
800017b8:	ff87f713          	andi	a4,a5,-8
800017bc:	4310                	lw	a2,0(a4)
800017be:	4354                	lw	a3,4(a4)
800017c0:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
800017c4:	01b60733          	add	a4,a2,s11
800017c8:	00c73733          	sltu	a4,a4,a2
800017cc:	9736                	add	a4,a4,a3
800017ce:	df5d                	beqz	a4,8000178c <z_vprintk+0x16c>
						print_err(out, ctx);
800017d0:	85a6                	mv	a1,s1
800017d2:	8522                	mv	a0,s0
800017d4:	333d                	jal	80001502 <print_err>
			might_format = 0;
800017d6:	4c81                	li	s9,0
800017d8:	b575                	j	80001684 <z_vprintk+0x64>
				if (long_ctr == 0) {
800017da:	000a1663          	bnez	s4,800017e6 <z_vprintk+0x1c6>
					long lu = va_arg(ap, unsigned long);
800017de:	000d2603          	lw	a2,0(s10)
800017e2:	0d11                	addi	s10,s10,4
800017e4:	bf7d                	j	800017a2 <z_vprintk+0x182>
				} else if (long_ctr == 1) {
800017e6:	4705                	li	a4,1
800017e8:	feea0be3          	beq	s4,a4,800017de <z_vprintk+0x1be>
					unsigned long long llu =
800017ec:	007d0793          	addi	a5,s10,7
800017f0:	ff87f713          	andi	a4,a5,-8
800017f4:	00870d13          	addi	s10,a4,8
800017f8:	4310                	lw	a2,0(a4)
800017fa:	4358                	lw	a4,4(a4)
					if (llu > INT32_MAX) {
800017fc:	fb71                	bnez	a4,800017d0 <z_vprintk+0x1b0>
800017fe:	800007b7          	lui	a5,0x80000
80001802:	fff7c793          	not	a5,a5
80001806:	f8c7fee3          	bgeu	a5,a2,800017a2 <z_vprintk+0x182>
8000180a:	b7d9                	j	800017d0 <z_vprintk+0x1b0>
				  out('0', ctx);
8000180c:	85a6                	mv	a1,s1
8000180e:	03000513          	li	a0,48
80001812:	9402                	jalr	s0
				  out('x', ctx);
80001814:	85a6                	mv	a1,s1
80001816:	07800513          	li	a0,120
8000181a:	9402                	jalr	s0
				  min_width = 8;
8000181c:	4921                	li	s2,8
				  padding = PAD_ZERO_BEFORE;
8000181e:	4985                	li	s3,1
				if (long_ctr < 2) {
80001820:	4685                	li	a3,1
80001822:	0746c663          	blt	a3,s4,8000188e <z_vprintk+0x26e>
					x = va_arg(ap, unsigned long);
80001826:	000d2783          	lw	a5,0(s10)
8000182a:	c402                	sw	zero,8(sp)
8000182c:	0d11                	addi	s10,s10,4
8000182e:	c23e                	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001830:	4c41                	li	s8,16
	int digits = 0;
80001832:	4b81                	li	s7,0
	int found_largest_digit = 0;
80001834:	c002                	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001836:	48c1                	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001838:	4512                	lw	a0,4(sp)
8000183a:	45a2                	lw	a1,8(sp)
8000183c:	fff88b13          	addi	s6,a7,-1
80001840:	002b1613          	slli	a2,s6,0x2
80001844:	c646                	sw	a7,12(sp)
80001846:	9cbfe0ef          	jal	ra,80000210 <__lshrdi3>
8000184a:	893d                	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
8000184c:	ed39                	bnez	a0,800018aa <z_vprintk+0x28a>
8000184e:	4782                	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001850:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001854:	e789                	bnez	a5,8000185e <z_vprintk+0x23e>
80001856:	48b2                	lw	a7,12(sp)
80001858:	4785                	li	a5,1
8000185a:	06f89063          	bne	a7,a5,800018ba <z_vprintk+0x29a>
			nibble += nibble > 9 ? 87 : 48;
8000185e:	9536                	add	a0,a0,a3
			out((int)nibble, ctx);
80001860:	0562                	slli	a0,a0,0x18
80001862:	85a6                	mv	a1,s1
80001864:	8561                	srai	a0,a0,0x18
80001866:	9402                	jalr	s0
			digits++;
80001868:	0b85                	addi	s7,s7,1
	for (; size != 0; size--) {
8000186a:	020b1d63          	bnez	s6,800018a4 <z_vprintk+0x284>
	if (padding == PAD_SPACE_AFTER) {
8000186e:	468d                	li	a3,3
			might_format = 0;
80001870:	4c81                	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001872:	e0d999e3          	bne	s3,a3,80001684 <z_vprintk+0x64>
		remaining = min_width * 2 - digits;
80001876:	00191713          	slli	a4,s2,0x1
8000187a:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
8000187e:	f5705ce3          	blez	s7,800017d6 <z_vprintk+0x1b6>
			out(' ', ctx);
80001882:	85a6                	mv	a1,s1
80001884:	02000513          	li	a0,32
80001888:	9402                	jalr	s0
8000188a:	1bfd                	addi	s7,s7,-1
8000188c:	bfcd                	j	8000187e <z_vprintk+0x25e>
					x = va_arg(ap, unsigned long long);
8000188e:	007d0793          	addi	a5,s10,7
80001892:	ff87f693          	andi	a3,a5,-8
80001896:	429c                	lw	a5,0(a3)
80001898:	00868d13          	addi	s10,a3,8
8000189c:	c23e                	sw	a5,4(sp)
8000189e:	42dc                	lw	a5,4(a3)
800018a0:	c43e                	sw	a5,8(sp)
800018a2:	b779                	j	80001830 <z_vprintk+0x210>
			found_largest_digit = 1;
800018a4:	c066                	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800018a6:	88da                	mv	a7,s6
800018a8:	bf41                	j	80001838 <z_vprintk+0x218>
			nibble += nibble > 9 ? 87 : 48;
800018aa:	47a5                	li	a5,9
800018ac:	05700693          	li	a3,87
800018b0:	faa7e7e3          	bltu	a5,a0,8000185e <z_vprintk+0x23e>
800018b4:	03000693          	li	a3,48
800018b8:	b75d                	j	8000185e <z_vprintk+0x23e>
		if (remaining-- <= min_width) {
800018ba:	fffc0793          	addi	a5,s8,-1
800018be:	c63e                	sw	a5,12(sp)
800018c0:	01894963          	blt	s2,s8,800018d2 <z_vprintk+0x2b2>
			if (padding == PAD_ZERO_BEFORE) {
800018c4:	4785                	li	a5,1
800018c6:	00f99863          	bne	s3,a5,800018d6 <z_vprintk+0x2b6>
				out('0', ctx);
800018ca:	85a6                	mv	a1,s1
800018cc:	03000513          	li	a0,48
				out(' ', ctx);
800018d0:	9402                	jalr	s0
					x = va_arg(ap, unsigned long);
800018d2:	4c32                	lw	s8,12(sp)
800018d4:	bfc9                	j	800018a6 <z_vprintk+0x286>
			} else if (padding == PAD_SPACE_BEFORE) {
800018d6:	4789                	li	a5,2
800018d8:	fef99de3          	bne	s3,a5,800018d2 <z_vprintk+0x2b2>
				out(' ', ctx);
800018dc:	85a6                	mv	a1,s1
800018de:	02000513          	li	a0,32
800018e2:	b7fd                	j	800018d0 <z_vprintk+0x2b0>
					out((int)(*s++), ctx);
800018e4:	85a6                	mv	a1,s1
800018e6:	0b85                	addi	s7,s7,1
800018e8:	9402                	jalr	s0
800018ea:	b581                	j	8000172a <z_vprintk+0x10a>
						out(' ', ctx);
800018ec:	85a6                	mv	a1,s1
800018ee:	02000513          	li	a0,32
800018f2:	9402                	jalr	s0
800018f4:	1bfd                	addi	s7,s7,-1
800018f6:	b5a9                	j	80001740 <z_vprintk+0x120>
				out(c, ctx);
800018f8:	000d2503          	lw	a0,0(s10)
800018fc:	85a6                	mv	a1,s1
				int c = va_arg(ap, int);
800018fe:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001902:	9402                	jalr	s0
				break;
80001904:	b581                	j	80001744 <z_vprintk+0x124>
				long_ctr = 0;
80001906:	4a01                	li	s4,0
				min_width = -1;
80001908:	597d                	li	s2,-1
				padding = PAD_NONE;
8000190a:	4981                	li	s3,0
				might_format = 1;
8000190c:	4c85                	li	s9,1
8000190e:	bb9d                	j	80001684 <z_vprintk+0x64>
				padding = PAD_SPACE_AFTER;
80001910:	498d                	li	s3,3
80001912:	bb8d                	j	80001684 <z_vprintk+0x64>
					padding = PAD_ZERO_BEFORE;
80001914:	4985                	li	s3,1
80001916:	b3bd                	j	80001684 <z_vprintk+0x64>

80001918 <vprintk>:
{
80001918:	1101                	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
8000191a:	862a                	mv	a2,a0
8000191c:	80001537          	lui	a0,0x80001
80001920:	86ae                	mv	a3,a1
80001922:	52e50513          	addi	a0,a0,1326 # 8000152e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000152f>
80001926:	006c                	addi	a1,sp,12
{
80001928:	ce06                	sw	ra,28(sp)
	struct out_context ctx = { 0 };
8000192a:	c602                	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
8000192c:	39d5                	jal	80001620 <z_vprintk>
}
8000192e:	40f2                	lw	ra,28(sp)
80001930:	6105                	addi	sp,sp,32
80001932:	8082                	ret

80001934 <printk>:
{
80001934:	7139                	addi	sp,sp,-64
80001936:	d22e                	sw	a1,36(sp)
	va_start(ap, fmt);
80001938:	104c                	addi	a1,sp,36
{
8000193a:	ce06                	sw	ra,28(sp)
8000193c:	d432                	sw	a2,40(sp)
8000193e:	d636                	sw	a3,44(sp)
80001940:	d83a                	sw	a4,48(sp)
80001942:	da3e                	sw	a5,52(sp)
80001944:	dc42                	sw	a6,56(sp)
80001946:	de46                	sw	a7,60(sp)
	va_start(ap, fmt);
80001948:	c62e                	sw	a1,12(sp)
		vprintk(fmt, ap);
8000194a:	37f9                	jal	80001918 <vprintk>
}
8000194c:	40f2                	lw	ra,28(sp)
8000194e:	6121                	addi	sp,sp,64
80001950:	8082                	ret

80001952 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001952:	800055b7          	lui	a1,0x80005
80001956:	80005537          	lui	a0,0x80005
{
8000195a:	1141                	addi	sp,sp,-16
  k_panic();
8000195c:	2b458593          	addi	a1,a1,692 # 800052b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b5>
80001960:	2c850513          	addi	a0,a0,712 # 800052c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c9>
80001964:	4679                	li	a2,30
{
80001966:	c606                	sw	ra,12(sp)
  k_panic();
80001968:	37f1                	jal	80001934 <printk>
8000196a:	800055b7          	lui	a1,0x80005
8000196e:	e9458593          	addi	a1,a1,-364 # 80004e94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e95>
80001972:	4519                	li	a0,6
80001974:	bc2ff0ef          	jal	ra,80000d36 <z_NanoFatalErrorHandler>

80001978 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001978:	8082                	ret

8000197a <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000197a:	47a1                	li	a5,8
8000197c:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001980:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001984:	8082                	ret

80001986 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001986:	4785                	li	a5,1
80001988:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
8000198c:	30452573          	csrrs	a0,mie,a0
}
80001990:	8082                	ret

80001992 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001992:	47a1                	li	a5,8
80001994:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001998:	30405073          	csrwi	mie,0
8000199c:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
800019a0:	8082                	ret

800019a2 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
800019a2:	1141                	addi	sp,sp,-16
800019a4:	c422                	sw	s0,8(sp)
800019a6:	c226                	sw	s1,4(sp)
800019a8:	80006437          	lui	s0,0x80006
800019ac:	c606                	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
800019ae:	47a9                	li	a5,10
{
800019b0:	84aa                	mv	s1,a0
800019b2:	87840413          	addi	s0,s0,-1928 # 80005878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005879>
	if ('\n' == c) {
800019b6:	00f51763          	bne	a0,a5,800019c4 <console_out+0x22>
800019ba:	4008                	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
800019bc:	45b5                	li	a1,13
800019be:	415c                	lw	a5,4(a0)
800019c0:	43dc                	lw	a5,4(a5)
800019c2:	9782                	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
800019c4:	4008                	lw	a0,0(s0)
800019c6:	0ff4f593          	andi	a1,s1,255
800019ca:	415c                	lw	a5,4(a0)
800019cc:	43dc                	lw	a5,4(a5)
800019ce:	9782                	jalr	a5

	return c;
}
800019d0:	40b2                	lw	ra,12(sp)
800019d2:	4422                	lw	s0,8(sp)
800019d4:	8526                	mv	a0,s1
800019d6:	4492                	lw	s1,4(sp)
800019d8:	0141                	addi	sp,sp,16
800019da:	8082                	ret

800019dc <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
800019dc:	1141                	addi	sp,sp,-16
800019de:	c422                	sw	s0,8(sp)
	__stdout_hook_install(console_out);
800019e0:	80002437          	lui	s0,0x80002
800019e4:	9a240513          	addi	a0,s0,-1630 # 800019a2 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800019a3>
{
800019e8:	c606                	sw	ra,12(sp)
	__stdout_hook_install(console_out);
800019ea:	21b5                	jal	80001e56 <__stdout_hook_install>
	__printk_hook_install(console_out);
800019ec:	9a240513          	addi	a0,s0,-1630
}
800019f0:	4422                	lw	s0,8(sp)
800019f2:	40b2                	lw	ra,12(sp)
800019f4:	0141                	addi	sp,sp,16
	__printk_hook_install(console_out);
800019f6:	b105                	j	80001616 <__printk_hook_install>

800019f8 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
800019f8:	80005537          	lui	a0,0x80005
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
800019fc:	1141                	addi	sp,sp,-16
800019fe:	2d450513          	addi	a0,a0,724 # 800052d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d5>
80001a02:	c606                	sw	ra,12(sp)
80001a04:	6ec000ef          	jal	ra,800020f0 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001a08:	800067b7          	lui	a5,0x80006
80001a0c:	86a7ac23          	sw	a0,-1928(a5) # 80005878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005879>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001a10:	37f1                	jal	800019dc <uart_console_hook_install>

	return 0;
}
80001a12:	40b2                	lw	ra,12(sp)
80001a14:	4501                	li	a0,0
80001a16:	0141                	addi	sp,sp,16
80001a18:	8082                	ret

80001a1a <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001a1a:	f01007b7          	lui	a5,0xf0100
80001a1e:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001a22:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001a26:	f447a583          	lw	a1,-188(a5)
80001a2a:	fee59ae3          	bne	a1,a4,80001a1e <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001a2e:	8082                	ret

80001a30 <timer_isr>:

static void timer_isr(void *arg)
{
80001a30:	1101                	addi	sp,sp,-32
80001a32:	cc22                	sw	s0,24(sp)
80001a34:	ce06                	sw	ra,28(sp)
80001a36:	ca26                	sw	s1,20(sp)
80001a38:	c84a                	sw	s2,16(sp)
80001a3a:	c64e                	sw	s3,12(sp)
80001a3c:	c452                	sw	s4,8(sp)
80001a3e:	c256                	sw	s5,4(sp)
80001a40:	4421                	li	s0,8
80001a42:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001a46:	80006937          	lui	s2,0x80006
80001a4a:	87c90513          	addi	a0,s2,-1924 # 8000587c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000587d>
	key = (mstatus & SOC_MSTATUS_IEN);
80001a4e:	8821                	andi	s0,s0,8
80001a50:	02e020ef          	jal	ra,80003a7e <z_spin_lock_valid>
80001a54:	e915                	bnez	a0,80001a88 <timer_isr+0x58>
80001a56:	800054b7          	lui	s1,0x80005
80001a5a:	800055b7          	lui	a1,0x80005
80001a5e:	80005537          	lui	a0,0x80005
80001a62:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80001a66:	04e00693          	li	a3,78
80001a6a:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80001a6e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80001a72:	35c9                	jal	80001934 <printk>
80001a74:	80005537          	lui	a0,0x80005
80001a78:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80001a7c:	3d65                	jal	80001934 <printk>
80001a7e:	04e00593          	li	a1,78
80001a82:	2e848513          	addi	a0,s1,744
80001a86:	35f1                	jal	80001952 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001a88:	87c90513          	addi	a0,s2,-1924
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001a8c:	800064b7          	lui	s1,0x80006
80001a90:	02a020ef          	jal	ra,80003aba <z_spin_lock_set_owner>
80001a94:	85848493          	addi	s1,s1,-1960 # 80005858 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005859>
	u64_t now = mtime();
80001a98:	3749                	jal	80001a1a <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001a9a:	0004a983          	lw	s3,0(s1)
80001a9e:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001aa2:	87aa                	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001aa4:	41350533          	sub	a0,a0,s3
80001aa8:	00a7b7b3          	sltu	a5,a5,a0
80001aac:	415585b3          	sub	a1,a1,s5
80001ab0:	6675                	lui	a2,0x1d
80001ab2:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001ab6:	4681                	li	a3,0
80001ab8:	8d9d                	sub	a1,a1,a5
80001aba:	f8efe0ef          	jal	ra,80000248 <__udivdi3>
80001abe:	8a2a                	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80001ac0:	65f5                	lui	a1,0x1d
80001ac2:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001ac6:	8552                	mv	a0,s4
80001ac8:	d55fe0ef          	jal	ra,8000081c <__mulsi3>
80001acc:	99aa                	add	s3,s3,a0
80001ace:	00a9b533          	sltu	a0,s3,a0
80001ad2:	9556                	add	a0,a0,s5
80001ad4:	c0c8                	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001ad6:	87c90513          	addi	a0,s2,-1924
80001ada:	0134a023          	sw	s3,0(s1)
80001ade:	7bb010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80001ae2:	e915                	bnez	a0,80001b16 <timer_isr+0xe6>
80001ae4:	800054b7          	lui	s1,0x80005
80001ae8:	800055b7          	lui	a1,0x80005
80001aec:	80005537          	lui	a0,0x80005
80001af0:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80001af4:	06100693          	li	a3,97
80001af8:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80001afc:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80001b00:	3d15                	jal	80001934 <printk>
80001b02:	80005537          	lui	a0,0x80005
80001b06:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80001b0a:	352d                	jal	80001934 <printk>
80001b0c:	06100593          	li	a1,97
80001b10:	2e848513          	addi	a0,s1,744
80001b14:	3d3d                	jal	80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001b16:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80001b1a:	4462                	lw	s0,24(sp)
80001b1c:	40f2                	lw	ra,28(sp)
80001b1e:	44d2                	lw	s1,20(sp)
80001b20:	4942                	lw	s2,16(sp)
80001b22:	49b2                	lw	s3,12(sp)
80001b24:	4a92                	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001b26:	8552                	mv	a0,s4
}
80001b28:	4a22                	lw	s4,8(sp)
80001b2a:	6105                	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001b2c:	7900206f          	j	800042bc <z_clock_announce>

80001b30 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80001b30:	1141                	addi	sp,sp,-16
80001b32:	c606                	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001b34:	35dd                	jal	80001a1a <mtime>
80001b36:	67f5                	lui	a5,0x1d
80001b38:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001b3c:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001b40:	97aa                	add	a5,a5,a0
	r[1] = 0xffffffff;
80001b42:	56fd                	li	a3,-1
80001b44:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001b48:	00a7b533          	sltu	a0,a5,a0
80001b4c:	952e                	add	a0,a0,a1
	r[0] = (u32_t)time;
80001b4e:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001b52:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80001b56:	451d                	li	a0,7
80001b58:	353d                	jal	80001986 <z_arch_irq_enable>
	return 0;
}
80001b5a:	40b2                	lw	ra,12(sp)
80001b5c:	4501                	li	a0,0
80001b5e:	0141                	addi	sp,sp,16
80001b60:	8082                	ret

80001b62 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001b62:	14059563          	bnez	a1,80001cac <z_clock_set_timeout+0x14a>
{
80001b66:	1101                	addi	sp,sp,-32
80001b68:	ce06                	sw	ra,28(sp)
80001b6a:	cc22                	sw	s0,24(sp)
80001b6c:	ca26                	sw	s1,20(sp)
80001b6e:	c84a                	sw	s2,16(sp)
80001b70:	c64e                	sw	s3,12(sp)
80001b72:	c452                	sw	s4,8(sp)
80001b74:	c256                	sw	s5,4(sp)
80001b76:	c05a                	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80001b78:	57fd                	li	a5,-1
80001b7a:	00f51563          	bne	a0,a5,80001b84 <z_clock_set_timeout+0x22>
80001b7e:	6525                	lui	a0,0x9
80001b80:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80001b84:	67a5                	lui	a5,0x9
80001b86:	fff50413          	addi	s0,a0,-1
80001b8a:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80001b8e:	1087db63          	bge	a5,s0,80001ca4 <z_clock_set_timeout+0x142>
80001b92:	843e                	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001b94:	4921                	li	s2,8
80001b96:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001b9a:	80006ab7          	lui	s5,0x80006
80001b9e:	87ca8513          	addi	a0,s5,-1924 # 8000587c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000587d>
	key = (mstatus & SOC_MSTATUS_IEN);
80001ba2:	00897913          	andi	s2,s2,8
80001ba6:	6d9010ef          	jal	ra,80003a7e <z_spin_lock_valid>
80001baa:	e915                	bnez	a0,80001bde <z_clock_set_timeout+0x7c>
80001bac:	800054b7          	lui	s1,0x80005
80001bb0:	800055b7          	lui	a1,0x80005
80001bb4:	80005537          	lui	a0,0x80005
80001bb8:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80001bbc:	04e00693          	li	a3,78
80001bc0:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80001bc4:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80001bc8:	33b5                	jal	80001934 <printk>
80001bca:	80005537          	lui	a0,0x80005
80001bce:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80001bd2:	338d                	jal	80001934 <printk>
80001bd4:	04e00593          	li	a1,78
80001bd8:	2e848513          	addi	a0,s1,744
80001bdc:	3b9d                	jal	80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80001bde:	87ca8513          	addi	a0,s5,-1924
80001be2:	6d9010ef          	jal	ra,80003aba <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80001be6:	3d15                	jal	80001a1a <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001be8:	800067b7          	lui	a5,0x80006
80001bec:	85878793          	addi	a5,a5,-1960 # 80005858 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005859>
	u32_t cyc = ticks * CYC_PER_TICK;
80001bf0:	64f5                	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001bf2:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80001bf6:	8a2a                	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80001bf8:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001bfc:	8522                	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001bfe:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001c02:	c1bfe0ef          	jal	ra,8000081c <__mulsi3>
80001c06:	4bf48793          	addi	a5,s1,1215
80001c0a:	413787b3          	sub	a5,a5,s3
80001c0e:	953e                	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001c10:	4c048593          	addi	a1,s1,1216
80001c14:	9552                	add	a0,a0,s4
80001c16:	cc3fe0ef          	jal	ra,800008d8 <__udivsi3>
80001c1a:	4c048593          	addi	a1,s1,1216
80001c1e:	bfffe0ef          	jal	ra,8000081c <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001c22:	41498a33          	sub	s4,s3,s4
80001c26:	9a2a                	add	s4,s4,a0
80001c28:	3e700793          	li	a5,999
80001c2c:	0147c563          	blt	a5,s4,80001c36 <z_clock_set_timeout+0xd4>
		cyc += CYC_PER_TICK;
80001c30:	4c048493          	addi	s1,s1,1216
80001c34:	9526                	add	a0,a0,s1
	r[1] = 0xffffffff;
80001c36:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80001c3a:	99aa                	add	s3,s3,a0
	r[1] = 0xffffffff;
80001c3c:	577d                	li	a4,-1
80001c3e:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80001c42:	00a9b533          	sltu	a0,s3,a0
80001c46:	955a                	add	a0,a0,s6
	r[0] = (u32_t)time;
80001c48:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80001c4c:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001c50:	87ca8513          	addi	a0,s5,-1924
80001c54:	645010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80001c58:	e915                	bnez	a0,80001c8c <z_clock_set_timeout+0x12a>
80001c5a:	80005437          	lui	s0,0x80005
80001c5e:	800055b7          	lui	a1,0x80005
80001c62:	80005537          	lui	a0,0x80005
80001c66:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80001c6a:	06100693          	li	a3,97
80001c6e:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80001c72:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80001c76:	397d                	jal	80001934 <printk>
80001c78:	80005537          	lui	a0,0x80005
80001c7c:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80001c80:	3955                	jal	80001934 <printk>
80001c82:	06100593          	li	a1,97
80001c86:	2e840513          	addi	a0,s0,744
80001c8a:	31e1                	jal	80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001c8c:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80001c90:	40f2                	lw	ra,28(sp)
80001c92:	4462                	lw	s0,24(sp)
80001c94:	44d2                	lw	s1,20(sp)
80001c96:	4942                	lw	s2,16(sp)
80001c98:	49b2                	lw	s3,12(sp)
80001c9a:	4a22                	lw	s4,8(sp)
80001c9c:	4a92                	lw	s5,4(sp)
80001c9e:	4b02                	lw	s6,0(sp)
80001ca0:	6105                	addi	sp,sp,32
80001ca2:	8082                	ret
80001ca4:	ee0458e3          	bgez	s0,80001b94 <z_clock_set_timeout+0x32>
80001ca8:	4401                	li	s0,0
80001caa:	b5ed                	j	80001b94 <z_clock_set_timeout+0x32>
80001cac:	8082                	ret

80001cae <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80001cae:	1141                	addi	sp,sp,-16
80001cb0:	c422                	sw	s0,8(sp)
80001cb2:	c606                	sw	ra,12(sp)
80001cb4:	c226                	sw	s1,4(sp)
80001cb6:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001cb8:	4421                	li	s0,8
80001cba:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001cbe:	800064b7          	lui	s1,0x80006
80001cc2:	87c48513          	addi	a0,s1,-1924 # 8000587c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000587d>
	key = (mstatus & SOC_MSTATUS_IEN);
80001cc6:	8821                	andi	s0,s0,8
80001cc8:	5b7010ef          	jal	ra,80003a7e <z_spin_lock_valid>
80001ccc:	e915                	bnez	a0,80001d00 <z_clock_elapsed+0x52>
80001cce:	80005937          	lui	s2,0x80005
80001cd2:	800055b7          	lui	a1,0x80005
80001cd6:	80005537          	lui	a0,0x80005
80001cda:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80001cde:	04e00693          	li	a3,78
80001ce2:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80001ce6:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80001cea:	31a9                	jal	80001934 <printk>
80001cec:	80005537          	lui	a0,0x80005
80001cf0:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80001cf4:	3181                	jal	80001934 <printk>
80001cf6:	04e00593          	li	a1,78
80001cfa:	2e890513          	addi	a0,s2,744
80001cfe:	3991                	jal	80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80001d00:	87c48513          	addi	a0,s1,-1924
80001d04:	5b7010ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80001d08:	3b09                	jal	80001a1a <mtime>
80001d0a:	800067b7          	lui	a5,0x80006
80001d0e:	8587a783          	lw	a5,-1960(a5) # 80005858 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005859>
80001d12:	65f5                	lui	a1,0x1d
80001d14:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001d18:	8d1d                	sub	a0,a0,a5
80001d1a:	bbffe0ef          	jal	ra,800008d8 <__udivsi3>
80001d1e:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001d20:	87c48513          	addi	a0,s1,-1924
80001d24:	575010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80001d28:	e915                	bnez	a0,80001d5c <z_clock_elapsed+0xae>
80001d2a:	800054b7          	lui	s1,0x80005
80001d2e:	800055b7          	lui	a1,0x80005
80001d32:	80005537          	lui	a0,0x80005
80001d36:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80001d3a:	06100693          	li	a3,97
80001d3e:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80001d42:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80001d46:	36fd                	jal	80001934 <printk>
80001d48:	80005537          	lui	a0,0x80005
80001d4c:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80001d50:	36d5                	jal	80001934 <printk>
80001d52:	06100593          	li	a1,97
80001d56:	2e848513          	addi	a0,s1,744
80001d5a:	3ee5                	jal	80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001d5c:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80001d60:	40b2                	lw	ra,12(sp)
80001d62:	4422                	lw	s0,8(sp)
80001d64:	854a                	mv	a0,s2
80001d66:	4492                	lw	s1,4(sp)
80001d68:	4902                	lw	s2,0(sp)
80001d6a:	0141                	addi	sp,sp,16
80001d6c:	8082                	ret

80001d6e <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80001d6e:	00054783          	lbu	a5,0(a0)
80001d72:	0005c703          	lbu	a4,0(a1)
80001d76:	00e79363          	bne	a5,a4,80001d7c <strcmp+0xe>
80001d7a:	e781                	bnez	a5,80001d82 <strcmp+0x14>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80001d7c:	40e78533          	sub	a0,a5,a4
80001d80:	8082                	ret
		s1++;
80001d82:	0505                	addi	a0,a0,1
		s2++;
80001d84:	0585                	addi	a1,a1,1
80001d86:	b7e5                	j	80001d6e <strcmp>

80001d88 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80001d88:	00b547b3          	xor	a5,a0,a1
80001d8c:	8b8d                	andi	a5,a5,3
80001d8e:	cf95                	beqz	a5,80001dca <memcpy+0x42>
	unsigned char *d_byte = (unsigned char *)d;
80001d90:	87aa                	mv	a5,a0
80001d92:	4701                	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80001d94:	04e61763          	bne	a2,a4,80001de2 <memcpy+0x5a>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80001d98:	8082                	ret
			if (n == 0) {
80001d9a:	de7d                	beqz	a2,80001d98 <memcpy+0x10>
			*(d_byte++) = *(s_byte++);
80001d9c:	0585                	addi	a1,a1,1
80001d9e:	fff5c703          	lbu	a4,-1(a1)
80001da2:	0785                	addi	a5,a5,1
			n--;
80001da4:	167d                	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80001da6:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80001daa:	0037f713          	andi	a4,a5,3
80001dae:	f775                	bnez	a4,80001d9a <memcpy+0x12>
		while (n >= sizeof(unsigned int)) {
80001db0:	468d                	li	a3,3
80001db2:	40e60833          	sub	a6,a2,a4
80001db6:	0106ec63          	bltu	a3,a6,80001dce <memcpy+0x46>
80001dba:	00265713          	srli	a4,a2,0x2
80001dbe:	00271693          	slli	a3,a4,0x2
80001dc2:	8e15                	sub	a2,a2,a3
80001dc4:	97b6                	add	a5,a5,a3
80001dc6:	95b6                	add	a1,a1,a3
80001dc8:	b7e9                	j	80001d92 <memcpy+0xa>
	unsigned char *d_byte = (unsigned char *)d;
80001dca:	87aa                	mv	a5,a0
80001dcc:	bff9                	j	80001daa <memcpy+0x22>
			*(d_word++) = *(s_word++);
80001dce:	00e588b3          	add	a7,a1,a4
80001dd2:	0008a883          	lw	a7,0(a7)
80001dd6:	00e78833          	add	a6,a5,a4
80001dda:	0711                	addi	a4,a4,4
80001ddc:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80001de0:	bfc9                	j	80001db2 <memcpy+0x2a>
		*(d_byte++) = *(s_byte++);
80001de2:	00e58833          	add	a6,a1,a4
80001de6:	00084803          	lbu	a6,0(a6)
80001dea:	00e786b3          	add	a3,a5,a4
80001dee:	0705                	addi	a4,a4,1
80001df0:	01068023          	sb	a6,0(a3)
		n--;
80001df4:	b745                	j	80001d94 <memcpy+0xc>

80001df6 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80001df6:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80001dfa:	87aa                	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80001dfc:	0037f713          	andi	a4,a5,3
80001e00:	eb1d                	bnez	a4,80001e36 <memset+0x40>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80001e02:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80001e06:	00859713          	slli	a4,a1,0x8
80001e0a:	8dd9                	or	a1,a1,a4
	c_word |= c_word << 16;
80001e0c:	01059713          	slli	a4,a1,0x10
80001e10:	8dd9                	or	a1,a1,a4

	while (n >= sizeof(unsigned int)) {
80001e12:	00c78333          	add	t1,a5,a2
80001e16:	873e                	mv	a4,a5
80001e18:	480d                	li	a6,3
80001e1a:	40e308b3          	sub	a7,t1,a4
80001e1e:	03186263          	bltu	a6,a7,80001e42 <memset+0x4c>
80001e22:	00265713          	srli	a4,a2,0x2
80001e26:	00271593          	slli	a1,a4,0x2
80001e2a:	97ae                	add	a5,a5,a1
80001e2c:	8e0d                	sub	a2,a2,a1
80001e2e:	963e                	add	a2,a2,a5

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80001e30:	00c79d63          	bne	a5,a2,80001e4a <memset+0x54>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80001e34:	8082                	ret
		if (n == 0) {
80001e36:	de7d                	beqz	a2,80001e34 <memset+0x3e>
		*(d_byte++) = c_byte;
80001e38:	0785                	addi	a5,a5,1
80001e3a:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001e3e:	167d                	addi	a2,a2,-1
80001e40:	bf75                	j	80001dfc <memset+0x6>
		*(d_word++) = c_word;
80001e42:	0711                	addi	a4,a4,4
80001e44:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80001e48:	bfc9                	j	80001e1a <memset+0x24>
		*(d_byte++) = c_byte;
80001e4a:	0785                	addi	a5,a5,1
80001e4c:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001e50:	b7c5                	j	80001e30 <memset+0x3a>

80001e52 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80001e52:	557d                	li	a0,-1
80001e54:	8082                	ret

80001e56 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80001e56:	800057b7          	lui	a5,0x80005
80001e5a:	7ca7a423          	sw	a0,1992(a5) # 800057c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c9>
}
80001e5e:	8082                	ret

80001e60 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80001e60:	1101                	addi	sp,sp,-32
80001e62:	cc22                	sw	s0,24(sp)
	test->setup();
80001e64:	451c                	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80001e66:	80005437          	lui	s0,0x80005
{
80001e6a:	ca26                	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80001e6c:	7cc40413          	addi	s0,s0,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80001e70:	800064b7          	lui	s1,0x80006
{
80001e74:	ce06                	sw	ra,28(sp)
80001e76:	c84a                	sw	s2,16(sp)
80001e78:	c64e                	sw	s3,12(sp)
	test_result = 1;
80001e7a:	88048493          	addi	s1,s1,-1920 # 80005880 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005881>
80001e7e:	4985                	li	s3,1
	phase = TEST_PHASE_SETUP;
80001e80:	00042023          	sw	zero,0(s0)
{
80001e84:	892a                	mv	s2,a0
	test_result = 1;
80001e86:	0134a023          	sw	s3,0(s1)
	test->setup();
80001e8a:	9782                	jalr	a5
	test->test();
80001e8c:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80001e90:	01342023          	sw	s3,0(s0)
	test->test();
80001e94:	9782                	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80001e96:	4789                	li	a5,2
80001e98:	c01c                	sw	a5,0(s0)
	test->teardown();
80001e9a:	00c92783          	lw	a5,12(s2)
80001e9e:	9782                	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80001ea0:	478d                	li	a5,3
80001ea2:	c01c                	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80001ea4:	4462                	lw	s0,24(sp)
	test_result = 0;
80001ea6:	0004a023          	sw	zero,0(s1)
}
80001eaa:	40f2                	lw	ra,28(sp)
80001eac:	44d2                	lw	s1,20(sp)
80001eae:	4942                	lw	s2,16(sp)
80001eb0:	49b2                	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80001eb2:	80006537          	lui	a0,0x80006
80001eb6:	a1450513          	addi	a0,a0,-1516 # 80005a14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a15>
80001eba:	6105                	addi	sp,sp,32
80001ebc:	0eb0106f          	j	800037a6 <z_impl_k_sem_give>

80001ec0 <ztest_test_fail>:
80001ec0:	80006537          	lui	a0,0x80006
{
80001ec4:	1141                	addi	sp,sp,-16
	test_result = -1;
80001ec6:	800067b7          	lui	a5,0x80006
80001eca:	577d                	li	a4,-1
80001ecc:	a1450513          	addi	a0,a0,-1516 # 80005a14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a15>
{
80001ed0:	c606                	sw	ra,12(sp)
	test_result = -1;
80001ed2:	88e7a023          	sw	a4,-1920(a5) # 80005880 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005881>
80001ed6:	0d1010ef          	jal	ra,800037a6 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001eda:	023010ef          	jal	ra,800036fc <z_impl_k_current_get>
}
80001ede:	40b2                	lw	ra,12(sp)
80001ee0:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001ee2:	6210106f          	j	80003d02 <z_impl_k_thread_abort>

80001ee6 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80001ee6:	711d                	addi	sp,sp,-96
80001ee8:	caa6                	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80001eea:	800064b7          	lui	s1,0x80006
80001eee:	8844a783          	lw	a5,-1916(s1) # 80005884 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005885>
{
80001ef2:	ce86                	sw	ra,92(sp)
80001ef4:	cca2                	sw	s0,88(sp)
80001ef6:	c8ca                	sw	s2,80(sp)
80001ef8:	c6ce                	sw	s3,76(sp)
80001efa:	c4d2                	sw	s4,72(sp)
80001efc:	c2d6                	sw	s5,68(sp)
80001efe:	c0da                	sw	s6,64(sp)
80001f00:	de5e                	sw	s7,60(sp)
80001f02:	dc62                	sw	s8,56(sp)
80001f04:	da66                	sw	s9,52(sp)
80001f06:	d86a                	sw	s10,48(sp)
80001f08:	d66e                	sw	s11,44(sp)
	if (test_status < 0) {
80001f0a:	0607c963          	bltz	a5,80001f7c <z_ztest_run_test_suite+0x96>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001f0e:	80006437          	lui	s0,0x80006
80001f12:	4605                	li	a2,1
80001f14:	89aa                	mv	s3,a0
80001f16:	8c2e                	mv	s8,a1
80001f18:	a1440513          	addi	a0,s0,-1516 # 80005a14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a15>
80001f1c:	4581                	li	a1,0
80001f1e:	7e8010ef          	jal	ra,80003706 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80001f22:	80005537          	lui	a0,0x80005
80001f26:	85ce                	mv	a1,s3
80001f28:	3a450513          	addi	a0,a0,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
80001f2c:	a09ff0ef          	jal	ra,80001934 <printk>
	PRINT_LINE;
80001f30:	80005937          	lui	s2,0x80005
80001f34:	3bc90513          	addi	a0,s2,956 # 800053bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053bd>
		Z_TC_END_RESULT(ret, test->name);
80001f38:	80005ab7          	lui	s5,0x80005
	PRINT_LINE;
80001f3c:	9f9ff0ef          	jal	ra,80001934 <printk>
80001f40:	88448493          	addi	s1,s1,-1916
	int fail = 0;
80001f44:	4a01                	li	s4,0
80001f46:	ce22                	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001f48:	80006cb7          	lui	s9,0x80006
80001f4c:	80006b37          	lui	s6,0x80006
80001f50:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80001f54:	80006db7          	lui	s11,0x80006
80001f58:	80005bb7          	lui	s7,0x80005
		Z_TC_END_RESULT(ret, test->name);
80001f5c:	35ca8a93          	addi	s5,s5,860 # 8000535c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000535d>
	while (suite->test) {
80001f60:	004c2783          	lw	a5,4(s8)
80001f64:	eb9d                	bnez	a5,80001f9a <z_ztest_run_test_suite+0xb4>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80001f66:	85ce                	mv	a1,s3
	if (fail) {
80001f68:	0c0a0363          	beqz	s4,8000202e <z_ztest_run_test_suite+0x148>
		TC_PRINT("Test suite %s failed.\n", name);
80001f6c:	80005537          	lui	a0,0x80005
80001f70:	42c50513          	addi	a0,a0,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
80001f74:	9c1ff0ef          	jal	ra,80001934 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80001f78:	4785                	li	a5,1
80001f7a:	c09c                	sw	a5,0(s1)
}
80001f7c:	40f6                	lw	ra,92(sp)
80001f7e:	4466                	lw	s0,88(sp)
80001f80:	44d6                	lw	s1,84(sp)
80001f82:	4946                	lw	s2,80(sp)
80001f84:	49b6                	lw	s3,76(sp)
80001f86:	4a26                	lw	s4,72(sp)
80001f88:	4a96                	lw	s5,68(sp)
80001f8a:	4b06                	lw	s6,64(sp)
80001f8c:	5bf2                	lw	s7,60(sp)
80001f8e:	5c62                	lw	s8,56(sp)
80001f90:	5cd2                	lw	s9,52(sp)
80001f92:	5d42                	lw	s10,48(sp)
80001f94:	5db2                	lw	s11,44(sp)
80001f96:	6125                	addi	sp,sp,96
80001f98:	8082                	ret
	TC_START(test->name);
80001f9a:	000c2583          	lw	a1,0(s8)
80001f9e:	800057b7          	lui	a5,0x80005
80001fa2:	40478513          	addi	a0,a5,1028 # 80005404 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005405>
80001fa6:	98fff0ef          	jal	ra,80001934 <printk>
80001faa:	c202                	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80001fac:	010c2783          	lw	a5,16(s8)
80001fb0:	8762                	mv	a4,s8
80001fb2:	40000613          	li	a2,1024
80001fb6:	0087e793          	ori	a5,a5,8
80001fba:	58fd                	li	a7,-1
80001fbc:	4801                	li	a6,0
80001fbe:	e60d0693          	addi	a3,s10,-416 # 80001e60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001e61>
80001fc2:	c03e                	sw	a5,0(sp)
80001fc4:	7a0c8593          	addi	a1,s9,1952 # 800067a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067a1>
80001fc8:	4781                	li	a5,0
80001fca:	a24b0513          	addi	a0,s6,-1500 # 80005a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a25>
80001fce:	41d010ef          	jal	ra,80003bea <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001fd2:	47f2                	lw	a5,28(sp)
80001fd4:	55fd                	li	a1,-1
80001fd6:	a1478513          	addi	a0,a5,-1516
80001fda:	077010ef          	jal	ra,80003850 <z_impl_k_sem_take>
	if (test_result == -1) {
80001fde:	880d8793          	addi	a5,s11,-1920 # 80005880 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005881>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001fe2:	a24b0513          	addi	a0,s6,-1500
80001fe6:	4380                	lw	s0,0(a5)
80001fe8:	51b010ef          	jal	ra,80003d02 <z_impl_k_thread_abort>
	if (test_result == -2) {
80001fec:	800067b7          	lui	a5,0x80006
80001ff0:	88078793          	addi	a5,a5,-1920 # 80005880 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005881>
80001ff4:	4398                	lw	a4,0(a5)
	if (test_result == -1) {
80001ff6:	0405                	addi	s0,s0,1
	if (test_result == -2) {
80001ff8:	57f9                	li	a5,-2
	if (test_result == -1) {
80001ffa:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80001ffe:	000c2603          	lw	a2,0(s8)
80002002:	02f71163          	bne	a4,a5,80002024 <z_ztest_run_test_suite+0x13e>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002006:	800055b7          	lui	a1,0x80005
8000200a:	41858593          	addi	a1,a1,1048 # 80005418 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005419>
		Z_TC_END_RESULT(ret, test->name);
8000200e:	420b8513          	addi	a0,s7,1056 # 80005420 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005421>
80002012:	923ff0ef          	jal	ra,80001934 <printk>
80002016:	3bc90513          	addi	a0,s2,956
8000201a:	91bff0ef          	jal	ra,80001934 <printk>
		fail += run_test(suite);
8000201e:	9a22                	add	s4,s4,s0
		suite++;
80002020:	0c51                	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002022:	bf3d                	j	80001f60 <z_ztest_run_test_suite+0x7a>
		Z_TC_END_RESULT(ret, test->name);
80002024:	00241793          	slli	a5,s0,0x2
80002028:	97d6                	add	a5,a5,s5
8000202a:	438c                	lw	a1,0(a5)
8000202c:	b7cd                	j	8000200e <z_ztest_run_test_suite+0x128>
		TC_PRINT("Test suite %s succeeded\n", name);
8000202e:	80005537          	lui	a0,0x80005
80002032:	44450513          	addi	a0,a0,1092 # 80005444 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005445>
80002036:	8ffff0ef          	jal	ra,80001934 <printk>
	test_status = (test_status || fail) ? 1 : 0;
8000203a:	409c                	lw	a5,0(s1)
8000203c:	00f037b3          	snez	a5,a5
80002040:	bf2d                	j	80001f7a <z_ztest_run_test_suite+0x94>

80002042 <end_report>:

void end_report(void)
{
	if (test_status) {
80002042:	800067b7          	lui	a5,0x80006
80002046:	8847a783          	lw	a5,-1916(a5) # 80005884 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005885>
{
8000204a:	1141                	addi	sp,sp,-16
8000204c:	c422                	sw	s0,8(sp)
8000204e:	80005537          	lui	a0,0x80005
80002052:	c606                	sw	ra,12(sp)
80002054:	80005437          	lui	s0,0x80005
		TC_END_REPORT(TC_FAIL);
80002058:	3bc50513          	addi	a0,a0,956 # 800053bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053bd>
	if (test_status) {
8000205c:	cf91                	beqz	a5,80002078 <end_report+0x36>
		TC_END_REPORT(TC_FAIL);
8000205e:	8d7ff0ef          	jal	ra,80001934 <printk>
80002062:	800055b7          	lui	a1,0x80005
80002066:	36858593          	addi	a1,a1,872 # 80005368 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005369>
	} else {
		TC_END_REPORT(TC_PASS);
8000206a:	37040513          	addi	a0,s0,880 # 80005370 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005371>
	}
}
8000206e:	4422                	lw	s0,8(sp)
80002070:	40b2                	lw	ra,12(sp)
80002072:	0141                	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002074:	8c1ff06f          	j	80001934 <printk>
80002078:	8bdff0ef          	jal	ra,80001934 <printk>
8000207c:	800055b7          	lui	a1,0x80005
80002080:	38858593          	addi	a1,a1,904 # 80005388 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005389>
80002084:	b7dd                	j	8000206a <end_report+0x28>

80002086 <main>:

	return test_status;
}
#else
void main(void)
{
80002086:	1141                	addi	sp,sp,-16
80002088:	c606                	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
8000208a:	c39fe0ef          	jal	ra,80000cc2 <test_main>
	end_report();
}
8000208e:	40b2                	lw	ra,12(sp)
80002090:	0141                	addi	sp,sp,16
	end_report();
80002092:	bf45                	j	80002042 <end_report>

80002094 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80002094:	1141                	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002096:	c602                	sw	zero,12(sp)
    i++;
80002098:	47b2                	lw	a5,12(sp)
8000209a:	0785                	addi	a5,a5,1
8000209c:	c63e                	sw	a5,12(sp)
    uart[0] = c;
8000209e:	f00107b7          	lui	a5,0xf0010
800020a2:	c38c                	sw	a1,0(a5)
}
800020a4:	0141                	addi	sp,sp,16
800020a6:	8082                	ret

800020a8 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
800020a8:	557d                	li	a0,-1
800020aa:	8082                	ret

800020ac <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
800020ac:	4501                	li	a0,0
800020ae:	8082                	ret

800020b0 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
800020b0:	00251713          	slli	a4,a0,0x2
800020b4:	800057b7          	lui	a5,0x80005
800020b8:	0505                	addi	a0,a0,1
800020ba:	47478793          	addi	a5,a5,1140 # 80005474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005475>
800020be:	050a                	slli	a0,a0,0x2
{
800020c0:	1141                	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800020c2:	973e                	add	a4,a4,a5
800020c4:	97aa                	add	a5,a5,a0
{
800020c6:	c422                	sw	s0,8(sp)
800020c8:	c226                	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800020ca:	4300                	lw	s0,0(a4)
800020cc:	4384                	lw	s1,0(a5)
{
800020ce:	c606                	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800020d0:	00946763          	bltu	s0,s1,800020de <z_sys_device_do_config_level+0x2e>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
800020d4:	40b2                	lw	ra,12(sp)
800020d6:	4422                	lw	s0,8(sp)
800020d8:	4492                	lw	s1,4(sp)
800020da:	0141                	addi	sp,sp,16
800020dc:	8082                	ret
		retval = device_conf->init(info);
800020de:	401c                	lw	a5,0(s0)
800020e0:	8522                	mv	a0,s0
800020e2:	43dc                	lw	a5,4(a5)
800020e4:	9782                	jalr	a5
		if (retval != 0) {
800020e6:	c119                	beqz	a0,800020ec <z_sys_device_do_config_level+0x3c>
			info->driver_api = NULL;
800020e8:	00042223          	sw	zero,4(s0)
								info++) {
800020ec:	0431                	addi	s0,s0,12
800020ee:	b7cd                	j	800020d0 <z_sys_device_do_config_level+0x20>

800020f0 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800020f0:	1141                	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
800020f2:	800057b7          	lui	a5,0x80005
{
800020f6:	c226                	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800020f8:	800064b7          	lui	s1,0x80006
{
800020fc:	c422                	sw	s0,8(sp)
800020fe:	c606                	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002100:	7e078413          	addi	s0,a5,2016 # 800057e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e1>
{
80002104:	c04a                	sw	s2,0(sp)
80002106:	7e078793          	addi	a5,a5,2016
8000210a:	81048493          	addi	s1,s1,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
	for (info = __device_init_start; info != __device_init_end; info++) {
8000210e:	00941863          	bne	s0,s1,8000211e <z_impl_device_get_binding+0x2e>
80002112:	892a                	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002114:	843e                	mv	s0,a5
80002116:	00941c63          	bne	s0,s1,8000212e <z_impl_device_get_binding+0x3e>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
8000211a:	4401                	li	s0,0
8000211c:	a015                	j	80002140 <z_impl_device_get_binding+0x50>
		if ((info->driver_api != NULL) &&
8000211e:	4058                	lw	a4,4(s0)
80002120:	c709                	beqz	a4,8000212a <z_impl_device_get_binding+0x3a>
		    (info->config->name == name)) {
80002122:	4018                	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002124:	4318                	lw	a4,0(a4)
80002126:	00a70d63          	beq	a4,a0,80002140 <z_impl_device_get_binding+0x50>
	for (info = __device_init_start; info != __device_init_end; info++) {
8000212a:	0431                	addi	s0,s0,12
8000212c:	b7cd                	j	8000210e <z_impl_device_get_binding+0x1e>
		if (info->driver_api == NULL) {
8000212e:	405c                	lw	a5,4(s0)
80002130:	e399                	bnez	a5,80002136 <z_impl_device_get_binding+0x46>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002132:	0431                	addi	s0,s0,12
80002134:	b7cd                	j	80002116 <z_impl_device_get_binding+0x26>
		if (strcmp(name, info->config->name) == 0) {
80002136:	401c                	lw	a5,0(s0)
80002138:	854a                	mv	a0,s2
8000213a:	438c                	lw	a1,0(a5)
8000213c:	390d                	jal	80001d6e <strcmp>
8000213e:	f975                	bnez	a0,80002132 <z_impl_device_get_binding+0x42>
}
80002140:	8522                	mv	a0,s0
80002142:	40b2                	lw	ra,12(sp)
80002144:	4422                	lw	s0,8(sp)
80002146:	4492                	lw	s1,4(sp)
80002148:	4902                	lw	s2,0(sp)
8000214a:	0141                	addi	sp,sp,16
8000214c:	8082                	ret

8000214e <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
8000214e:	1141                	addi	sp,sp,-16
80002150:	c422                	sw	s0,8(sp)
80002152:	c226                	sw	s1,4(sp)
80002154:	c606                	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002156:	4421                	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002158:	4489                	li	s1,2
8000215a:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
8000215e:	7d1010ef          	jal	ra,8000412e <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002162:	00a4c363          	blt	s1,a0,80002168 <idle+0x1a>
80002166:	4505                	li	a0,1
80002168:	4585                	li	a1,1
8000216a:	07e020ef          	jal	ra,800041e8 <z_set_timeout_expiry>
	k_cpu_idle();
8000216e:	80dff0ef          	jal	ra,8000197a <k_cpu_idle>
80002172:	b7e5                	j	8000215a <idle+0xc>

80002174 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002174:	80006537          	lui	a0,0x80006
80002178:	800067b7          	lui	a5,0x80006
8000217c:	85850613          	addi	a2,a0,-1960 # 80005858 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005859>
80002180:	ba078793          	addi	a5,a5,-1120 # 80005ba0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ba1>
80002184:	40c78633          	sub	a2,a5,a2
80002188:	4581                	li	a1,0
8000218a:	85850513          	addi	a0,a0,-1960
8000218e:	b1a5                	j	80001df6 <memset>

80002190 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002190:	1141                	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002192:	4509                	li	a0,2
{
80002194:	c606                	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002196:	3f29                	jal	800020b0 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002198:	80005537          	lui	a0,0x80005
8000219c:	48850513          	addi	a0,a0,1160 # 80005488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005489>
800021a0:	f94ff0ef          	jal	ra,80001934 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
800021a4:	450d                	li	a0,3
800021a6:	3729                	jal	800020b0 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
800021a8:	2e3010ef          	jal	ra,80003c8a <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
800021ac:	3de9                	jal	80002086 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
800021ae:	800067b7          	lui	a5,0x80006
800021b2:	b0478793          	addi	a5,a5,-1276 # 80005b04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b05>
800021b6:	00c7c703          	lbu	a4,12(a5)
800021ba:	9b79                	andi	a4,a4,-2
800021bc:	00e78623          	sb	a4,12(a5)
}
800021c0:	40b2                	lw	ra,12(sp)
800021c2:	0141                	addi	sp,sp,16
800021c4:	8082                	ret

800021c6 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
800021c6:	7135                	addi	sp,sp,-160
800021c8:	cd22                	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
800021ca:	800077b7          	lui	a5,0x80007
800021ce:	80006437          	lui	s0,0x80006
800021d2:	c74e                	sw	s3,140(sp)
800021d4:	7a078793          	addi	a5,a5,1952 # 800077a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077a1>
800021d8:	b7440993          	addi	s3,s0,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
800021dc:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
800021e0:	081c                	addi	a5,sp,16
800021e2:	07000613          	li	a2,112
800021e6:	4581                	li	a1,0
800021e8:	853e                	mv	a0,a5
{
800021ea:	cf06                	sw	ra,156(sp)
800021ec:	cb26                	sw	s1,148(sp)
800021ee:	c94a                	sw	s2,144(sp)
	struct k_thread dummy_thread = {
800021f0:	3119                	jal	80001df6 <memset>
800021f2:	4705                	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800021f4:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800021f8:	4501                	li	a0,0
	struct k_thread dummy_thread = {
800021fa:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800021fe:	3d4d                	jal	800020b0 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002200:	4505                	li	a0,1
80002202:	357d                	jal	800020b0 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002204:	10100793          	li	a5,257
80002208:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
8000220c:	33a010ef          	jal	ra,80003546 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002210:	800057b7          	lui	a5,0x80005
80002214:	4cc78793          	addi	a5,a5,1228 # 800054cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054cd>
	_kernel.ready_q.cache = _main_thread;
80002218:	80006937          	lui	s2,0x80006
	z_setup_new_thread(_main_thread, _main_stack,
8000221c:	c23e                	sw	a5,4(sp)
8000221e:	800026b7          	lui	a3,0x80002
80002222:	4785                	li	a5,1
80002224:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002228:	b0490493          	addi	s1,s2,-1276 # 80005b04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b05>
	z_setup_new_thread(_main_thread, _main_stack,
8000222c:	c03e                	sw	a5,0(sp)
8000222e:	4701                	li	a4,0
80002230:	4781                	li	a5,0
80002232:	4881                	li	a7,0
80002234:	4801                	li	a6,0
80002236:	19068693          	addi	a3,a3,400 # 80002190 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002191>
8000223a:	20000613          	li	a2,512
8000223e:	ba058593          	addi	a1,a1,-1120 # 80006ba0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ba1>
80002242:	b0490513          	addi	a0,s2,-1276
	_kernel.ready_q.cache = _main_thread;
80002246:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
8000224a:	7ac010ef          	jal	ra,800039f6 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
8000224e:	00d4c783          	lbu	a5,13(s1)
80002252:	b7440413          	addi	s0,s0,-1164
80002256:	ffb7f713          	andi	a4,a5,-5
8000225a:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000225e:	8bed                	andi	a5,a5,27
80002260:	e799                	bnez	a5,8000226e <z_cstart+0xa8>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002262:	4c9c                	lw	a5,24(s1)
80002264:	e789                	bnez	a5,8000226e <z_cstart+0xa8>
		z_add_thread_to_ready_q(thread);
80002266:	b0490513          	addi	a0,s2,-1276
8000226a:	2c7000ef          	jal	ra,80002d30 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
8000226e:	800057b7          	lui	a5,0x80005
80002272:	4d478793          	addi	a5,a5,1236 # 800054d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054d5>
80002276:	c23e                	sw	a5,4(sp)
80002278:	80006537          	lui	a0,0x80006
8000227c:	4785                	li	a5,1
8000227e:	800026b7          	lui	a3,0x80002
80002282:	800075b7          	lui	a1,0x80007
80002286:	a9450493          	addi	s1,a0,-1388 # 80005a94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a95>
8000228a:	c03e                	sw	a5,0(sp)
8000228c:	48bd                	li	a7,15
8000228e:	4801                	li	a6,0
80002290:	4781                	li	a5,0
80002292:	4701                	li	a4,0
80002294:	14e68693          	addi	a3,a3,334 # 8000214e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000214f>
80002298:	20000613          	li	a2,512
8000229c:	da058593          	addi	a1,a1,-608 # 80006da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006da1>
800022a0:	a9450513          	addi	a0,a0,-1388
800022a4:	752010ef          	jal	ra,800039f6 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
800022a8:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
800022ac:	c444                	sw	s1,12(s0)
800022ae:	4521                	li	a0,8
800022b0:	9bed                	andi	a5,a5,-5
800022b2:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
800022b6:	800067b7          	lui	a5,0x80006
800022ba:	b8c78793          	addi	a5,a5,-1140 # 80005b8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b8d>
800022be:	cc1c                	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800022c0:	cc5c                	sw	a5,28(s0)
800022c2:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
800022c6:	8921                	andi	a0,a0,8
800022c8:	ef9fd0ef          	jal	ra,800001c0 <__swap>

800022cc <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800022cc:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
800022d0:	1101                	addi	sp,sp,-32
800022d2:	cc22                	sw	s0,24(sp)
800022d4:	ce06                	sw	ra,28(sp)
800022d6:	8bfd                	andi	a5,a5,31
800022d8:	842a                	mv	s0,a0
800022da:	e799                	bnez	a5,800022e8 <prepare_thread_to_run+0x1c>
	if (z_is_thread_ready(thread)) {
800022dc:	4d1c                	lw	a5,24(a0)
800022de:	e789                	bnez	a5,800022e8 <prepare_thread_to_run+0x1c>
800022e0:	c62e                	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
800022e2:	24f000ef          	jal	ra,80002d30 <z_add_thread_to_ready_q>
800022e6:	45b2                	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
800022e8:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
800022ec:	c84c                	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
800022ee:	40f2                	lw	ra,28(sp)
800022f0:	4462                	lw	s0,24(sp)
800022f2:	6105                	addi	sp,sp,32
800022f4:	8082                	ret

800022f6 <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
800022f6:	1101                	addi	sp,sp,-32
800022f8:	cc22                	sw	s0,24(sp)
800022fa:	ca26                	sw	s1,20(sp)
800022fc:	c84a                	sw	s2,16(sp)
800022fe:	c64e                	sw	s3,12(sp)
80002300:	c452                	sw	s4,8(sp)
80002302:	c05a                	sw	s6,0(sp)
80002304:	ce06                	sw	ra,28(sp)
80002306:	c256                	sw	s5,4(sp)
80002308:	842a                	mv	s0,a0
8000230a:	89ae                	mv	s3,a1
8000230c:	8a32                	mv	s4,a2
8000230e:	8b36                	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002310:	00850913          	addi	s2,a0,8
80002314:	44a1                	li	s1,8
80002316:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000231a:	854a                	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
8000231c:	88a1                	andi	s1,s1,8
8000231e:	760010ef          	jal	ra,80003a7e <z_spin_lock_valid>
80002322:	ed0d                	bnez	a0,8000235c <queue_insert+0x66>
80002324:	80005ab7          	lui	s5,0x80005
80002328:	800055b7          	lui	a1,0x80005
8000232c:	80005537          	lui	a0,0x80005
80002330:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80002334:	04e00693          	li	a3,78
80002338:	2e8a8613          	addi	a2,s5,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000233c:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002340:	df4ff0ef          	jal	ra,80001934 <printk>
80002344:	80005537          	lui	a0,0x80005
80002348:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
8000234c:	de8ff0ef          	jal	ra,80001934 <printk>
80002350:	04e00593          	li	a1,78
80002354:	2e8a8513          	addi	a0,s5,744
80002358:	dfaff0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
8000235c:	854a                	mv	a0,s2
8000235e:	75c010ef          	jal	ra,80003aba <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
80002362:	00c40513          	addi	a0,s0,12
80002366:	026010ef          	jal	ra,8000338c <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
8000236a:	c901                	beqz	a0,8000237a <queue_insert+0x84>
		prepare_thread_to_run(first_pending_thread, data);
8000236c:	85d2                	mv	a1,s4
8000236e:	3fb9                	jal	800022cc <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
80002370:	854a                	mv	a0,s2
80002372:	85a6                	mv	a1,s1
80002374:	298d                	jal	800027e6 <z_reschedule>
	return 0;
80002376:	4501                	li	a0,0
80002378:	a891                	j	800023cc <queue_insert+0xd6>
	if (alloc) {
8000237a:	080b0363          	beqz	s6,80002400 <queue_insert+0x10a>
		anode = z_thread_malloc(sizeof(*anode));
8000237e:	4521                	li	a0,8
80002380:	67e020ef          	jal	ra,800049fe <z_thread_malloc>
		if (anode == NULL) {
80002384:	ed31                	bnez	a0,800023e0 <queue_insert+0xea>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002386:	854a                	mv	a0,s2
80002388:	710010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
8000238c:	ed0d                	bnez	a0,800023c6 <queue_insert+0xd0>
8000238e:	80005437          	lui	s0,0x80005
80002392:	800055b7          	lui	a1,0x80005
80002396:	80005537          	lui	a0,0x80005
8000239a:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
8000239e:	06100693          	li	a3,97
800023a2:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800023a6:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800023aa:	d8aff0ef          	jal	ra,80001934 <printk>
800023ae:	80005537          	lui	a0,0x80005
800023b2:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800023b6:	d7eff0ef          	jal	ra,80001934 <printk>
800023ba:	06100593          	li	a1,97
800023be:	2e840513          	addi	a0,s0,744
800023c2:	d90ff0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800023c6:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
800023ca:	5551                	li	a0,-12
}
800023cc:	40f2                	lw	ra,28(sp)
800023ce:	4462                	lw	s0,24(sp)
800023d0:	44d2                	lw	s1,20(sp)
800023d2:	4942                	lw	s2,16(sp)
800023d4:	49b2                	lw	s3,12(sp)
800023d6:	4a22                	lw	s4,8(sp)
800023d8:	4a92                	lw	s5,4(sp)
800023da:	4b02                	lw	s6,0(sp)
800023dc:	6105                	addi	sp,sp,32
800023de:	8082                	ret
 * @param flags A value between 0 and 3 to set the flags value
 */
static inline void sys_sfnode_init(sys_sfnode_t *node, u8_t flags)
{
	__ASSERT((flags & ~SYS_SFLIST_FLAGS_MASK) == 0U, "flags too large");
	node->next_and_flags = flags;
800023e0:	4785                	li	a5,1
		anode->data = data;
800023e2:	01452223          	sw	s4,4(a0)
800023e6:	c11c                	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
800023e8:	411c                	lw	a5,0(a0)
800023ea:	8b8d                	andi	a5,a5,3
800023ec:	00099e63          	bnez	s3,80002408 <queue_insert+0x112>
	parent->next_and_flags = cur_flags | (unative_t)child;
800023f0:	4018                	lw	a4,0(s0)
800023f2:	8fd9                	or	a5,a5,a4
800023f4:	c11c                	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
800023f6:	405c                	lw	a5,4(s0)
	list->head = node;
800023f8:	c008                	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
800023fa:	fbbd                	bnez	a5,80002370 <queue_insert+0x7a>
	list->tail = node;
800023fc:	c048                	sw	a0,4(s0)
800023fe:	bf8d                	j	80002370 <queue_insert+0x7a>
	node->next_and_flags = flags;
80002400:	000a2023          	sw	zero,0(s4)
80002404:	8552                	mv	a0,s4
80002406:	b7cd                	j	800023e8 <queue_insert+0xf2>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002408:	0009a703          	lw	a4,0(s3)
8000240c:	9b71                	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
8000240e:	ef01                	bnez	a4,80002426 <queue_insert+0x130>
Z_GENLIST_APPEND(sflist, sfnode)
80002410:	4058                	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002412:	c11c                	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
80002414:	e701                	bnez	a4,8000241c <queue_insert+0x126>
	list->tail = node;
80002416:	c048                	sw	a0,4(s0)
	list->head = node;
80002418:	c008                	sw	a0,0(s0)
8000241a:	bf99                	j	80002370 <queue_insert+0x7a>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
8000241c:	431c                	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
8000241e:	8b8d                	andi	a5,a5,3
80002420:	8fc9                	or	a5,a5,a0
80002422:	c31c                	sw	a5,0(a4)
80002424:	bfe1                	j	800023fc <queue_insert+0x106>
80002426:	8fd9                	or	a5,a5,a4
80002428:	c11c                	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
8000242a:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
8000242e:	8b8d                	andi	a5,a5,3
80002430:	8d5d                	or	a0,a0,a5
80002432:	00a9a023          	sw	a0,0(s3)
80002436:	bf2d                	j	80002370 <queue_insert+0x7a>

80002438 <z_queue_node_peek>:
{
80002438:	1141                	addi	sp,sp,-16
8000243a:	c422                	sw	s0,8(sp)
8000243c:	c606                	sw	ra,12(sp)
8000243e:	842a                	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
80002440:	c901                	beqz	a0,80002450 <z_queue_node_peek+0x18>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002442:	411c                	lw	a5,0(a0)
80002444:	8b8d                	andi	a5,a5,3
80002446:	c789                	beqz	a5,80002450 <z_queue_node_peek+0x18>
		ret = anode->data;
80002448:	4140                	lw	s0,4(a0)
		if (needs_free) {
8000244a:	c199                	beqz	a1,80002450 <z_queue_node_peek+0x18>
			k_free(anode);
8000244c:	5a8020ef          	jal	ra,800049f4 <k_free>
}
80002450:	8522                	mv	a0,s0
80002452:	40b2                	lw	ra,12(sp)
80002454:	4422                	lw	s0,8(sp)
80002456:	0141                	addi	sp,sp,16
80002458:	8082                	ret

8000245a <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
8000245a:	00c50793          	addi	a5,a0,12
	list->head = NULL;
8000245e:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
80002462:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
80002466:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
8000246a:	c55c                	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
8000246c:	c91c                	sw	a5,16(a0)
}
8000246e:	8082                	ret

80002470 <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
80002470:	862e                	mv	a2,a1
80002472:	414c                	lw	a1,4(a0)
80002474:	4681                	li	a3,0
80002476:	b541                	j	800022f6 <queue_insert>

80002478 <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
80002478:	1101                	addi	sp,sp,-32
8000247a:	cc22                	sw	s0,24(sp)
8000247c:	ca26                	sw	s1,20(sp)
8000247e:	c84a                	sw	s2,16(sp)
80002480:	c64e                	sw	s3,12(sp)
80002482:	ce06                	sw	ra,28(sp)
80002484:	c452                	sw	s4,8(sp)
80002486:	84aa                	mv	s1,a0
80002488:	89ae                	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
8000248a:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000248e:	4421                	li	s0,8
80002490:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002494:	854a                	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002496:	8821                	andi	s0,s0,8
80002498:	5e6010ef          	jal	ra,80003a7e <z_spin_lock_valid>
8000249c:	ed0d                	bnez	a0,800024d6 <z_impl_k_queue_get+0x5e>
8000249e:	80005a37          	lui	s4,0x80005
800024a2:	800055b7          	lui	a1,0x80005
800024a6:	80005537          	lui	a0,0x80005
800024aa:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800024ae:	04e00693          	li	a3,78
800024b2:	2e8a0613          	addi	a2,s4,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800024b6:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800024ba:	c7aff0ef          	jal	ra,80001934 <printk>
800024be:	80005537          	lui	a0,0x80005
800024c2:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
800024c6:	c6eff0ef          	jal	ra,80001934 <printk>
800024ca:	04e00593          	li	a1,78
800024ce:	2e8a0513          	addi	a0,s4,744
800024d2:	c80ff0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
800024d6:	854a                	mv	a0,s2
800024d8:	5e2010ef          	jal	ra,80003aba <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
800024dc:	4088                	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
800024de:	c535                	beqz	a0,8000254a <z_impl_k_queue_get+0xd2>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
800024e0:	411c                	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
800024e2:	40d8                	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
800024e4:	9bf1                	andi	a5,a5,-4
	list->head = node;
800024e6:	c09c                	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
800024e8:	00e51363          	bne	a0,a4,800024ee <z_impl_k_queue_get+0x76>
	list->tail = node;
800024ec:	c0dc                	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
800024ee:	4585                	li	a1,1
800024f0:	37a1                	jal	80002438 <z_queue_node_peek>
800024f2:	84aa                	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800024f4:	854a                	mv	a0,s2
800024f6:	5a2010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
800024fa:	ed0d                	bnez	a0,80002534 <z_impl_k_queue_get+0xbc>
800024fc:	80005937          	lui	s2,0x80005
80002500:	800055b7          	lui	a1,0x80005
80002504:	80005537          	lui	a0,0x80005
80002508:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
8000250c:	06100693          	li	a3,97
80002510:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002514:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002518:	c1cff0ef          	jal	ra,80001934 <printk>
8000251c:	80005537          	lui	a0,0x80005
80002520:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80002524:	c10ff0ef          	jal	ra,80001934 <printk>
80002528:	06100593          	li	a1,97
8000252c:	2e890513          	addi	a0,s2,744
80002530:	c22ff0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002534:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
80002538:	40f2                	lw	ra,28(sp)
8000253a:	4462                	lw	s0,24(sp)
8000253c:	8526                	mv	a0,s1
8000253e:	4942                	lw	s2,16(sp)
80002540:	44d2                	lw	s1,20(sp)
80002542:	49b2                	lw	s3,12(sp)
80002544:	4a22                	lw	s4,8(sp)
80002546:	6105                	addi	sp,sp,32
80002548:	8082                	ret
	if (timeout == K_NO_WAIT) {
8000254a:	04099663          	bnez	s3,80002596 <z_impl_k_queue_get+0x11e>
8000254e:	854a                	mv	a0,s2
80002550:	548010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80002554:	ed0d                	bnez	a0,8000258e <z_impl_k_queue_get+0x116>
80002556:	800054b7          	lui	s1,0x80005
8000255a:	800055b7          	lui	a1,0x80005
8000255e:	80005537          	lui	a0,0x80005
80002562:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80002566:	06100693          	li	a3,97
8000256a:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000256e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002572:	bc2ff0ef          	jal	ra,80001934 <printk>
80002576:	80005537          	lui	a0,0x80005
8000257a:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000257e:	bb6ff0ef          	jal	ra,80001934 <printk>
80002582:	06100593          	li	a1,97
80002586:	2e848513          	addi	a0,s1,744
8000258a:	bc8ff0ef          	jal	ra,80001952 <assert_post_action>
8000258e:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
80002592:	4481                	li	s1,0
80002594:	b755                	j	80002538 <z_impl_k_queue_get+0xc0>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80002596:	00c48613          	addi	a2,s1,12
8000259a:	86ce                	mv	a3,s3
8000259c:	85a2                	mv	a1,s0
8000259e:	854a                	mv	a0,s2
800025a0:	585000ef          	jal	ra,80003324 <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
800025a4:	4481                	li	s1,0
800025a6:	f949                	bnez	a0,80002538 <z_impl_k_queue_get+0xc0>
800025a8:	800067b7          	lui	a5,0x80006
800025ac:	b7c7a783          	lw	a5,-1156(a5) # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800025b0:	4bc4                	lw	s1,20(a5)
800025b2:	b759                	j	80002538 <z_impl_k_queue_get+0xc0>

800025b4 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800025b4:	00d54783          	lbu	a5,13(a0)
800025b8:	8bfd                	andi	a5,a5,31
800025ba:	e789                	bnez	a5,800025c4 <z_is_thread_ready+0x10>
800025bc:	4d08                	lw	a0,24(a0)
800025be:	00153513          	seqz	a0,a0
800025c2:	8082                	ret
800025c4:	4501                	li	a0,0
}
800025c6:	8082                	ret

800025c8 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
800025c8:	1141                	addi	sp,sp,-16
800025ca:	c606                	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800025cc:	ee2ff0ef          	jal	ra,80001cae <z_clock_elapsed>
800025d0:	800067b7          	lui	a5,0x80006
800025d4:	8907a783          	lw	a5,-1904(a5) # 80005890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005891>

	z_set_timeout_expiry(slice_time, false);
}
800025d8:	40b2                	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800025da:	80006737          	lui	a4,0x80006
800025de:	953e                	add	a0,a0,a5
800025e0:	b8a72223          	sw	a0,-1148(a4) # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
	z_set_timeout_expiry(slice_time, false);
800025e4:	4581                	li	a1,0
800025e6:	853e                	mv	a0,a5
}
800025e8:	0141                	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
800025ea:	3ff0106f          	j	800041e8 <z_set_timeout_expiry>

800025ee <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
800025ee:	411c                	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
800025f0:	1141                	addi	sp,sp,-16
800025f2:	c422                	sw	s0,8(sp)
800025f4:	c606                	sw	ra,12(sp)
800025f6:	c226                	sw	s1,4(sp)
800025f8:	842a                	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
800025fa:	e79d                	bnez	a5,80002628 <pended_on.isra.15+0x3a>
800025fc:	800054b7          	lui	s1,0x80005
80002600:	800055b7          	lui	a1,0x80005
80002604:	80005537          	lui	a0,0x80005
80002608:	57458593          	addi	a1,a1,1396 # 80005574 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005575>
8000260c:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002610:	18300693          	li	a3,387
80002614:	56048613          	addi	a2,s1,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80002618:	b1cff0ef          	jal	ra,80001934 <printk>
8000261c:	18300593          	li	a1,387
80002620:	56048513          	addi	a0,s1,1376
80002624:	b2eff0ef          	jal	ra,80001952 <assert_post_action>

	return thread->base.pended_on;
}
80002628:	4008                	lw	a0,0(s0)
8000262a:	40b2                	lw	ra,12(sp)
8000262c:	4422                	lw	s0,8(sp)
8000262e:	4492                	lw	s1,4(sp)
80002630:	0141                	addi	sp,sp,16
80002632:	8082                	ret

80002634 <k_sched_time_slice_set>:
{
80002634:	1101                	addi	sp,sp,-32
80002636:	cc22                	sw	s0,24(sp)
80002638:	c64e                	sw	s3,12(sp)
8000263a:	c452                	sw	s4,8(sp)
8000263c:	ce06                	sw	ra,28(sp)
8000263e:	ca26                	sw	s1,20(sp)
80002640:	c84a                	sw	s2,16(sp)
80002642:	8a2a                	mv	s4,a0
80002644:	89ae                	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002646:	4421                	li	s0,8
80002648:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000264c:	800064b7          	lui	s1,0x80006
80002650:	88848513          	addi	a0,s1,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
80002654:	8821                	andi	s0,s0,8
80002656:	428010ef          	jal	ra,80003a7e <z_spin_lock_valid>
8000265a:	ed0d                	bnez	a0,80002694 <k_sched_time_slice_set+0x60>
8000265c:	80005937          	lui	s2,0x80005
80002660:	800055b7          	lui	a1,0x80005
80002664:	80005537          	lui	a0,0x80005
80002668:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
8000266c:	04e00693          	li	a3,78
80002670:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002674:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002678:	abcff0ef          	jal	ra,80001934 <printk>
8000267c:	80005537          	lui	a0,0x80005
80002680:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002684:	ab0ff0ef          	jal	ra,80001934 <printk>
80002688:	04e00593          	li	a1,78
8000268c:	2e890513          	addi	a0,s2,744
80002690:	ac2ff0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80002694:	88848513          	addi	a0,s1,-1912
80002698:	422010ef          	jal	ra,80003aba <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
8000269c:	800067b7          	lui	a5,0x80006
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800026a0:	45a9                	li	a1,10
800026a2:	009a0513          	addi	a0,s4,9
800026a6:	b807a223          	sw	zero,-1148(a5) # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
800026aa:	a26fe0ef          	jal	ra,800008d0 <__divsi3>
		slice_max_prio = prio;
800026ae:	800067b7          	lui	a5,0x80006
		slice_time = z_ms_to_ticks(slice);
800026b2:	80006937          	lui	s2,0x80006
800026b6:	88a92823          	sw	a0,-1904(s2) # 80005890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005891>
		slice_max_prio = prio;
800026ba:	8937a623          	sw	s3,-1908(a5) # 8000588c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000588d>
		reset_time_slice();
800026be:	3729                	jal	800025c8 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800026c0:	88848513          	addi	a0,s1,-1912
800026c4:	3d4010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
800026c8:	ed0d                	bnez	a0,80002702 <k_sched_time_slice_set+0xce>
800026ca:	800054b7          	lui	s1,0x80005
800026ce:	800055b7          	lui	a1,0x80005
800026d2:	80005537          	lui	a0,0x80005
800026d6:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800026da:	06100693          	li	a3,97
800026de:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800026e2:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800026e6:	a4eff0ef          	jal	ra,80001934 <printk>
800026ea:	80005537          	lui	a0,0x80005
800026ee:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800026f2:	a42ff0ef          	jal	ra,80001934 <printk>
800026f6:	06100593          	li	a1,97
800026fa:	2e848513          	addi	a0,s1,744
800026fe:	a54ff0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002702:	30042473          	csrrs	s0,mstatus,s0
}
80002706:	40f2                	lw	ra,28(sp)
80002708:	4462                	lw	s0,24(sp)
8000270a:	44d2                	lw	s1,20(sp)
8000270c:	4942                	lw	s2,16(sp)
8000270e:	49b2                	lw	s3,12(sp)
80002710:	4a22                	lw	s4,8(sp)
80002712:	6105                	addi	sp,sp,32
80002714:	8082                	ret

80002716 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002716:	1101                	addi	sp,sp,-32
80002718:	cc22                	sw	s0,24(sp)
8000271a:	c84a                	sw	s2,16(sp)
8000271c:	ce06                	sw	ra,28(sp)
8000271e:	ca26                	sw	s1,20(sp)
80002720:	c64e                	sw	s3,12(sp)
80002722:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002724:	4421                	li	s0,8
80002726:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000272a:	800064b7          	lui	s1,0x80006
8000272e:	88848513          	addi	a0,s1,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
80002732:	8821                	andi	s0,s0,8
80002734:	34a010ef          	jal	ra,80003a7e <z_spin_lock_valid>
80002738:	ed0d                	bnez	a0,80002772 <z_unpend_thread_no_timeout+0x5c>
8000273a:	800059b7          	lui	s3,0x80005
8000273e:	800055b7          	lui	a1,0x80005
80002742:	80005537          	lui	a0,0x80005
80002746:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
8000274a:	04e00693          	li	a3,78
8000274e:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002752:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002756:	9deff0ef          	jal	ra,80001934 <printk>
8000275a:	80005537          	lui	a0,0x80005
8000275e:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002762:	9d2ff0ef          	jal	ra,80001934 <printk>
80002766:	04e00593          	li	a1,78
8000276a:	2e898513          	addi	a0,s3,744
8000276e:	9e4ff0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80002772:	88848513          	addi	a0,s1,-1912
80002776:	344010ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000277a:	00890513          	addi	a0,s2,8
8000277e:	3d85                	jal	800025ee <pended_on.isra.15>
80002780:	85ca                	mv	a1,s2
80002782:	2451                	jal	80002a06 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002784:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002788:	88848513          	addi	a0,s1,-1912
8000278c:	9bf5                	andi	a5,a5,-3
8000278e:	00f906a3          	sb	a5,13(s2)
80002792:	306010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80002796:	ed0d                	bnez	a0,800027d0 <z_unpend_thread_no_timeout+0xba>
80002798:	800054b7          	lui	s1,0x80005
8000279c:	800055b7          	lui	a1,0x80005
800027a0:	80005537          	lui	a0,0x80005
800027a4:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800027a8:	06100693          	li	a3,97
800027ac:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800027b0:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800027b4:	980ff0ef          	jal	ra,80001934 <printk>
800027b8:	80005537          	lui	a0,0x80005
800027bc:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800027c0:	974ff0ef          	jal	ra,80001934 <printk>
800027c4:	06100593          	li	a1,97
800027c8:	2e848513          	addi	a0,s1,744
800027cc:	986ff0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800027d0:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
800027d4:	40f2                	lw	ra,28(sp)
800027d6:	4462                	lw	s0,24(sp)
	thread->base.pended_on = NULL;
800027d8:	00092423          	sw	zero,8(s2)
}
800027dc:	44d2                	lw	s1,20(sp)
800027de:	4942                	lw	s2,16(sp)
800027e0:	49b2                	lw	s3,12(sp)
800027e2:	6105                	addi	sp,sp,32
800027e4:	8082                	ret

800027e6 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
800027e6:	800067b7          	lui	a5,0x80006
800027ea:	b747a783          	lw	a5,-1164(a5) # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
{
800027ee:	1141                	addi	sp,sp,-16
800027f0:	c422                	sw	s0,8(sp)
800027f2:	c606                	sw	ra,12(sp)
800027f4:	c226                	sw	s1,4(sp)
800027f6:	842e                	mv	s0,a1
	if (resched()) {
800027f8:	e7b9                	bnez	a5,80002846 <z_reschedule+0x60>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800027fa:	29e010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
800027fe:	ed0d                	bnez	a0,80002838 <z_reschedule+0x52>
80002800:	800054b7          	lui	s1,0x80005
80002804:	800055b7          	lui	a1,0x80005
80002808:	80005537          	lui	a0,0x80005
8000280c:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80002810:	07800693          	li	a3,120
80002814:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002818:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000281c:	918ff0ef          	jal	ra,80001934 <printk>
80002820:	80005537          	lui	a0,0x80005
80002824:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80002828:	90cff0ef          	jal	ra,80001934 <printk>
8000282c:	07800593          	li	a1,120
80002830:	2e848513          	addi	a0,s1,744
80002834:	91eff0ef          	jal	ra,80001952 <assert_post_action>
80002838:	8522                	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
8000283a:	4422                	lw	s0,8(sp)
8000283c:	40b2                	lw	ra,12(sp)
8000283e:	4492                	lw	s1,4(sp)
80002840:	0141                	addi	sp,sp,16
80002842:	97ffd06f          	j	800001c0 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002846:	252010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
8000284a:	ed0d                	bnez	a0,80002884 <z_reschedule+0x9e>
8000284c:	800054b7          	lui	s1,0x80005
80002850:	800055b7          	lui	a1,0x80005
80002854:	80005537          	lui	a0,0x80005
80002858:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
8000285c:	06100693          	li	a3,97
80002860:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002864:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002868:	8ccff0ef          	jal	ra,80001934 <printk>
8000286c:	80005537          	lui	a0,0x80005
80002870:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80002874:	8c0ff0ef          	jal	ra,80001934 <printk>
80002878:	06100593          	li	a1,97
8000287c:	2e848513          	addi	a0,s1,744
80002880:	8d2ff0ef          	jal	ra,80001952 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80002884:	8821                	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002886:	30042473          	csrrs	s0,mstatus,s0
8000288a:	40b2                	lw	ra,12(sp)
8000288c:	4422                	lw	s0,8(sp)
8000288e:	4492                	lw	s1,4(sp)
80002890:	0141                	addi	sp,sp,16
80002892:	8082                	ret

80002894 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80002894:	80006737          	lui	a4,0x80006
80002898:	b7472703          	lw	a4,-1164(a4) # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
8000289c:	e319                	bnez	a4,800028a2 <z_reschedule_irqlock+0xe>
8000289e:	923fd06f          	j	800001c0 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
800028a2:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800028a6:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
800028aa:	8082                	ret

800028ac <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800028ac:	4521                	li	a0,8
800028ae:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
800028b2:	8921                	andi	a0,a0,8
800028b4:	b7c5                	j	80002894 <z_reschedule_irqlock>

800028b6 <k_sched_lock>:

void k_sched_lock(void)
{
800028b6:	1101                	addi	sp,sp,-32
800028b8:	cc22                	sw	s0,24(sp)
800028ba:	ce06                	sw	ra,28(sp)
800028bc:	ca26                	sw	s1,20(sp)
800028be:	c84a                	sw	s2,16(sp)
800028c0:	c64e                	sw	s3,12(sp)
800028c2:	4421                	li	s0,8
800028c4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800028c8:	800064b7          	lui	s1,0x80006
800028cc:	88848513          	addi	a0,s1,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
800028d0:	8821                	andi	s0,s0,8
800028d2:	1ac010ef          	jal	ra,80003a7e <z_spin_lock_valid>
800028d6:	ed0d                	bnez	a0,80002910 <k_sched_lock+0x5a>
800028d8:	80005937          	lui	s2,0x80005
800028dc:	800055b7          	lui	a1,0x80005
800028e0:	80005537          	lui	a0,0x80005
800028e4:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800028e8:	04e00693          	li	a3,78
800028ec:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800028f0:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800028f4:	840ff0ef          	jal	ra,80001934 <printk>
800028f8:	80005537          	lui	a0,0x80005
800028fc:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002900:	834ff0ef          	jal	ra,80001934 <printk>
80002904:	04e00593          	li	a1,78
80002908:	2e890513          	addi	a0,s2,744
8000290c:	846ff0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80002910:	88848513          	addi	a0,s1,-1912
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80002914:	80006937          	lui	s2,0x80006
80002918:	1a2010ef          	jal	ra,80003aba <z_spin_lock_set_owner>
8000291c:	b7492783          	lw	a5,-1164(s2) # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
80002920:	b7490913          	addi	s2,s2,-1164
80002924:	cf8d                	beqz	a5,8000295e <k_sched_lock+0xa8>
80002926:	800059b7          	lui	s3,0x80005
8000292a:	800055b7          	lui	a1,0x80005
8000292e:	80005537          	lui	a0,0x80005
80002932:	4f858593          	addi	a1,a1,1272 # 800054f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054f9>
80002936:	10000693          	li	a3,256
8000293a:	4dc98613          	addi	a2,s3,1244 # 800054dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054dd>
8000293e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002942:	ff3fe0ef          	jal	ra,80001934 <printk>
80002946:	80005537          	lui	a0,0x80005
8000294a:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
8000294e:	fe7fe0ef          	jal	ra,80001934 <printk>
80002952:	10000593          	li	a1,256
80002956:	4dc98513          	addi	a0,s3,1244
8000295a:	ff9fe0ef          	jal	ra,80001952 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
8000295e:	00892783          	lw	a5,8(s2)
80002962:	00f7c703          	lbu	a4,15(a5)
80002966:	4785                	li	a5,1
80002968:	02f71e63          	bne	a4,a5,800029a4 <k_sched_lock+0xee>
8000296c:	800059b7          	lui	s3,0x80005
80002970:	800055b7          	lui	a1,0x80005
80002974:	80005537          	lui	a0,0x80005
80002978:	51058593          	addi	a1,a1,1296 # 80005510 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005511>
8000297c:	10100693          	li	a3,257
80002980:	4dc98613          	addi	a2,s3,1244 # 800054dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054dd>
80002984:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002988:	fadfe0ef          	jal	ra,80001934 <printk>
8000298c:	80005537          	lui	a0,0x80005
80002990:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
80002994:	fa1fe0ef          	jal	ra,80001934 <printk>
80002998:	10100593          	li	a1,257
8000299c:	4dc98513          	addi	a0,s3,1244
800029a0:	fb3fe0ef          	jal	ra,80001952 <assert_post_action>

	--_current->base.sched_locked;
800029a4:	00892703          	lw	a4,8(s2)
800029a8:	00f74783          	lbu	a5,15(a4)
800029ac:	17fd                	addi	a5,a5,-1
800029ae:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800029b2:	88848513          	addi	a0,s1,-1912
800029b6:	0e2010ef          	jal	ra,80003a98 <z_spin_unlock_valid>
800029ba:	ed0d                	bnez	a0,800029f4 <k_sched_lock+0x13e>
800029bc:	800054b7          	lui	s1,0x80005
800029c0:	800055b7          	lui	a1,0x80005
800029c4:	80005537          	lui	a0,0x80005
800029c8:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800029cc:	06100693          	li	a3,97
800029d0:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800029d4:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800029d8:	f5dfe0ef          	jal	ra,80001934 <printk>
800029dc:	80005537          	lui	a0,0x80005
800029e0:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800029e4:	f51fe0ef          	jal	ra,80001934 <printk>
800029e8:	06100593          	li	a1,97
800029ec:	2e848513          	addi	a0,s1,744
800029f0:	f63fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800029f4:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800029f8:	40f2                	lw	ra,28(sp)
800029fa:	4462                	lw	s0,24(sp)
800029fc:	44d2                	lw	s1,20(sp)
800029fe:	4942                	lw	s2,16(sp)
80002a00:	49b2                	lw	s3,12(sp)
80002a02:	6105                	addi	sp,sp,32
80002a04:	8082                	ret

80002a06 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80002a06:	800057b7          	lui	a5,0x80005
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80002a0a:	7dc7a783          	lw	a5,2012(a5) # 800057dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057dd>
{
80002a0e:	1141                	addi	sp,sp,-16
80002a10:	c422                	sw	s0,8(sp)
80002a12:	c606                	sw	ra,12(sp)
80002a14:	c226                	sw	s1,4(sp)
80002a16:	842e                	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80002a18:	02f59863          	bne	a1,a5,80002a48 <z_priq_dumb_remove+0x42>
80002a1c:	800054b7          	lui	s1,0x80005
80002a20:	800055b7          	lui	a1,0x80005
80002a24:	80005537          	lui	a0,0x80005
80002a28:	5ac58593          	addi	a1,a1,1452 # 800055ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055ad>
80002a2c:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002a30:	28c00693          	li	a3,652
80002a34:	56048613          	addi	a2,s1,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80002a38:	efdfe0ef          	jal	ra,80001934 <printk>
80002a3c:	28c00593          	li	a1,652
80002a40:	56048513          	addi	a0,s1,1376
80002a44:	f0ffe0ef          	jal	ra,80001952 <assert_post_action>
	node->prev->next = node->next;
80002a48:	4058                	lw	a4,4(s0)
80002a4a:	401c                	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80002a4c:	40b2                	lw	ra,12(sp)
80002a4e:	4492                	lw	s1,4(sp)
80002a50:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80002a52:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80002a54:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80002a58:	00042223          	sw	zero,4(s0)
80002a5c:	4422                	lw	s0,8(sp)
80002a5e:	0141                	addi	sp,sp,16
80002a60:	8082                	ret

80002a62 <z_unpend_thread>:
{
80002a62:	1101                	addi	sp,sp,-32
80002a64:	cc22                	sw	s0,24(sp)
80002a66:	ca26                	sw	s1,20(sp)
80002a68:	ce06                	sw	ra,28(sp)
80002a6a:	c84a                	sw	s2,16(sp)
80002a6c:	c64e                	sw	s3,12(sp)
80002a6e:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002a70:	44a1                	li	s1,8
80002a72:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002a76:	80006937          	lui	s2,0x80006
80002a7a:	88890513          	addi	a0,s2,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
80002a7e:	88a1                	andi	s1,s1,8
80002a80:	7ff000ef          	jal	ra,80003a7e <z_spin_lock_valid>
80002a84:	ed0d                	bnez	a0,80002abe <z_unpend_thread+0x5c>
80002a86:	800059b7          	lui	s3,0x80005
80002a8a:	800055b7          	lui	a1,0x80005
80002a8e:	80005537          	lui	a0,0x80005
80002a92:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80002a96:	04e00693          	li	a3,78
80002a9a:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002a9e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002aa2:	e93fe0ef          	jal	ra,80001934 <printk>
80002aa6:	80005537          	lui	a0,0x80005
80002aaa:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002aae:	e87fe0ef          	jal	ra,80001934 <printk>
80002ab2:	04e00593          	li	a1,78
80002ab6:	2e898513          	addi	a0,s3,744
80002aba:	e99fe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80002abe:	88890513          	addi	a0,s2,-1912
80002ac2:	7f9000ef          	jal	ra,80003aba <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002ac6:	00840513          	addi	a0,s0,8
80002aca:	b25ff0ef          	jal	ra,800025ee <pended_on.isra.15>
80002ace:	85a2                	mv	a1,s0
80002ad0:	3f1d                	jal	80002a06 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002ad2:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ad6:	88890513          	addi	a0,s2,-1912
80002ada:	9bf5                	andi	a5,a5,-3
80002adc:	00f406a3          	sb	a5,13(s0)
80002ae0:	7b9000ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80002ae4:	ed0d                	bnez	a0,80002b1e <z_unpend_thread+0xbc>
80002ae6:	80005937          	lui	s2,0x80005
80002aea:	800055b7          	lui	a1,0x80005
80002aee:	80005537          	lui	a0,0x80005
80002af2:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80002af6:	06100693          	li	a3,97
80002afa:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002afe:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002b02:	e33fe0ef          	jal	ra,80001934 <printk>
80002b06:	80005537          	lui	a0,0x80005
80002b0a:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80002b0e:	e27fe0ef          	jal	ra,80001934 <printk>
80002b12:	06100593          	li	a1,97
80002b16:	2e890513          	addi	a0,s2,744
80002b1a:	e39fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b1e:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80002b22:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80002b26:	01840513          	addi	a0,s0,24
}
80002b2a:	4462                	lw	s0,24(sp)
80002b2c:	40f2                	lw	ra,28(sp)
80002b2e:	44d2                	lw	s1,20(sp)
80002b30:	4942                	lw	s2,16(sp)
80002b32:	49b2                	lw	s3,12(sp)
80002b34:	6105                	addi	sp,sp,32
80002b36:	52e0106f          	j	80004064 <z_abort_timeout>

80002b3a <z_priq_dumb_best>:
	return list->head == list;
80002b3a:	411c                	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002b3c:	00f51363          	bne	a0,a5,80002b42 <z_priq_dumb_best+0x8>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80002b40:	4781                	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80002b42:	853e                	mv	a0,a5
80002b44:	8082                	ret

80002b46 <update_cache>:
{
80002b46:	1141                	addi	sp,sp,-16
80002b48:	c422                	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002b4a:	80006437          	lui	s0,0x80006
{
80002b4e:	c04a                	sw	s2,0(sp)
80002b50:	892a                	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002b52:	b7440513          	addi	a0,s0,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
80002b56:	02450513          	addi	a0,a0,36
{
80002b5a:	c226                	sw	s1,4(sp)
80002b5c:	c606                	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002b5e:	3ff1                	jal	80002b3a <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80002b60:	b7440413          	addi	s0,s0,-1164
80002b64:	84aa                	mv	s1,a0
80002b66:	e111                	bnez	a0,80002b6a <update_cache+0x24>
80002b68:	4444                	lw	s1,12(s0)
	if (preempt_ok != 0) {
80002b6a:	06091263          	bnez	s2,80002bce <update_cache+0x88>
	__ASSERT(_current != NULL, "");
80002b6e:	441c                	lw	a5,8(s0)
80002b70:	ef8d                	bnez	a5,80002baa <update_cache+0x64>
80002b72:	80005937          	lui	s2,0x80005
80002b76:	800055b7          	lui	a1,0x80005
80002b7a:	80005537          	lui	a0,0x80005
80002b7e:	58c58593          	addi	a1,a1,1420 # 8000558c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000558d>
80002b82:	07f00693          	li	a3,127
80002b86:	56090613          	addi	a2,s2,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80002b8a:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002b8e:	da7fe0ef          	jal	ra,80001934 <printk>
80002b92:	80005537          	lui	a0,0x80005
80002b96:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
80002b9a:	d9bfe0ef          	jal	ra,80001934 <printk>
80002b9e:	07f00593          	li	a1,127
80002ba2:	56090513          	addi	a0,s2,1376
80002ba6:	dadfe0ef          	jal	ra,80001952 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80002baa:	441c                	lw	a5,8(s0)
80002bac:	00d7c703          	lbu	a4,13(a5)
80002bb0:	8b7d                	andi	a4,a4,31
80002bb2:	ef11                	bnez	a4,80002bce <update_cache+0x88>
	if (is_preempt(_current) || is_metairq(th)) {
80002bb4:	00e7d683          	lhu	a3,14(a5)
80002bb8:	07f00713          	li	a4,127
80002bbc:	00d77963          	bgeu	a4,a3,80002bce <update_cache+0x88>
		_kernel.ready_q.cache = _current;
80002bc0:	d01c                	sw	a5,32(s0)
}
80002bc2:	40b2                	lw	ra,12(sp)
80002bc4:	4422                	lw	s0,8(sp)
80002bc6:	4492                	lw	s1,4(sp)
80002bc8:	4902                	lw	s2,0(sp)
80002bca:	0141                	addi	sp,sp,16
80002bcc:	8082                	ret
		if (th != _current) {
80002bce:	441c                	lw	a5,8(s0)
80002bd0:	00978463          	beq	a5,s1,80002bd8 <update_cache+0x92>
			reset_time_slice();
80002bd4:	9f5ff0ef          	jal	ra,800025c8 <reset_time_slice>
		_kernel.ready_q.cache = th;
80002bd8:	d004                	sw	s1,32(s0)
}
80002bda:	b7e5                	j	80002bc2 <update_cache+0x7c>

80002bdc <k_sched_unlock>:
{
80002bdc:	1101                	addi	sp,sp,-32
80002bde:	c84a                	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002be0:	80006937          	lui	s2,0x80006
80002be4:	b7490793          	addi	a5,s2,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
80002be8:	479c                	lw	a5,8(a5)
{
80002bea:	ce06                	sw	ra,28(sp)
80002bec:	cc22                	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002bee:	00f7c783          	lbu	a5,15(a5)
{
80002bf2:	ca26                	sw	s1,20(sp)
80002bf4:	c64e                	sw	s3,12(sp)
80002bf6:	b7490913          	addi	s2,s2,-1164
	__ASSERT(_current->base.sched_locked != 0, "");
80002bfa:	ef8d                	bnez	a5,80002c34 <k_sched_unlock+0x58>
80002bfc:	80005437          	lui	s0,0x80005
80002c00:	800055b7          	lui	a1,0x80005
80002c04:	80005537          	lui	a0,0x80005
80002c08:	53858593          	addi	a1,a1,1336 # 80005538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005539>
80002c0c:	22100693          	li	a3,545
80002c10:	56040613          	addi	a2,s0,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80002c14:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002c18:	d1dfe0ef          	jal	ra,80001934 <printk>
80002c1c:	80005537          	lui	a0,0x80005
80002c20:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
80002c24:	d11fe0ef          	jal	ra,80001934 <printk>
80002c28:	22100593          	li	a1,545
80002c2c:	56040513          	addi	a0,s0,1376
80002c30:	d23fe0ef          	jal	ra,80001952 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80002c34:	00092783          	lw	a5,0(s2)
80002c38:	cf8d                	beqz	a5,80002c72 <k_sched_unlock+0x96>
80002c3a:	80005437          	lui	s0,0x80005
80002c3e:	800055b7          	lui	a1,0x80005
80002c42:	80005537          	lui	a0,0x80005
80002c46:	4f858593          	addi	a1,a1,1272 # 800054f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054f9>
80002c4a:	22200693          	li	a3,546
80002c4e:	56040613          	addi	a2,s0,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80002c52:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002c56:	cdffe0ef          	jal	ra,80001934 <printk>
80002c5a:	80005537          	lui	a0,0x80005
80002c5e:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
80002c62:	cd3fe0ef          	jal	ra,80001934 <printk>
80002c66:	22200593          	li	a1,546
80002c6a:	56040513          	addi	a0,s0,1376
80002c6e:	ce5fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002c72:	4421                	li	s0,8
80002c74:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002c78:	800064b7          	lui	s1,0x80006
80002c7c:	88848513          	addi	a0,s1,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
80002c80:	8821                	andi	s0,s0,8
80002c82:	5fd000ef          	jal	ra,80003a7e <z_spin_lock_valid>
80002c86:	ed0d                	bnez	a0,80002cc0 <k_sched_unlock+0xe4>
80002c88:	800059b7          	lui	s3,0x80005
80002c8c:	800055b7          	lui	a1,0x80005
80002c90:	80005537          	lui	a0,0x80005
80002c94:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80002c98:	04e00693          	li	a3,78
80002c9c:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002ca0:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002ca4:	c91fe0ef          	jal	ra,80001934 <printk>
80002ca8:	80005537          	lui	a0,0x80005
80002cac:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002cb0:	c85fe0ef          	jal	ra,80001934 <printk>
80002cb4:	04e00593          	li	a1,78
80002cb8:	2e898513          	addi	a0,s3,744
80002cbc:	c97fe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80002cc0:	88848513          	addi	a0,s1,-1912
80002cc4:	5f7000ef          	jal	ra,80003aba <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80002cc8:	00892703          	lw	a4,8(s2)
		update_cache(1);
80002ccc:	4505                	li	a0,1
		++_current->base.sched_locked;
80002cce:	00f74783          	lbu	a5,15(a4)
80002cd2:	0785                	addi	a5,a5,1
80002cd4:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80002cd8:	35bd                	jal	80002b46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002cda:	88848513          	addi	a0,s1,-1912
80002cde:	5bb000ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80002ce2:	ed0d                	bnez	a0,80002d1c <k_sched_unlock+0x140>
80002ce4:	800054b7          	lui	s1,0x80005
80002ce8:	800055b7          	lui	a1,0x80005
80002cec:	80005537          	lui	a0,0x80005
80002cf0:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80002cf4:	06100693          	li	a3,97
80002cf8:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002cfc:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002d00:	c35fe0ef          	jal	ra,80001934 <printk>
80002d04:	80005537          	lui	a0,0x80005
80002d08:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80002d0c:	c29fe0ef          	jal	ra,80001934 <printk>
80002d10:	06100593          	li	a1,97
80002d14:	2e848513          	addi	a0,s1,744
80002d18:	c3bfe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d1c:	30042473          	csrrs	s0,mstatus,s0
}
80002d20:	4462                	lw	s0,24(sp)
80002d22:	40f2                	lw	ra,28(sp)
80002d24:	44d2                	lw	s1,20(sp)
80002d26:	4942                	lw	s2,16(sp)
80002d28:	49b2                	lw	s3,12(sp)
80002d2a:	6105                	addi	sp,sp,32
	z_reschedule_unlocked();
80002d2c:	b81ff06f          	j	800028ac <z_reschedule_unlocked>

80002d30 <z_add_thread_to_ready_q>:
{
80002d30:	1101                	addi	sp,sp,-32
80002d32:	cc22                	sw	s0,24(sp)
80002d34:	ca26                	sw	s1,20(sp)
80002d36:	ce06                	sw	ra,28(sp)
80002d38:	c84a                	sw	s2,16(sp)
80002d3a:	c64e                	sw	s3,12(sp)
80002d3c:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002d3e:	44a1                	li	s1,8
80002d40:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002d44:	80006937          	lui	s2,0x80006
80002d48:	88890513          	addi	a0,s2,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
80002d4c:	88a1                	andi	s1,s1,8
80002d4e:	531000ef          	jal	ra,80003a7e <z_spin_lock_valid>
80002d52:	ed0d                	bnez	a0,80002d8c <z_add_thread_to_ready_q+0x5c>
80002d54:	800059b7          	lui	s3,0x80005
80002d58:	800055b7          	lui	a1,0x80005
80002d5c:	80005537          	lui	a0,0x80005
80002d60:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80002d64:	04e00693          	li	a3,78
80002d68:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002d6c:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002d70:	bc5fe0ef          	jal	ra,80001934 <printk>
80002d74:	80005537          	lui	a0,0x80005
80002d78:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002d7c:	bb9fe0ef          	jal	ra,80001934 <printk>
80002d80:	04e00593          	li	a1,78
80002d84:	2e898513          	addi	a0,s3,744
80002d88:	bcbfe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80002d8c:	88890513          	addi	a0,s2,-1912
80002d90:	52b000ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	return thread == _idle_thread;
80002d94:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002d98:	7dc7a783          	lw	a5,2012(a5) # 800057dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057dd>
80002d9c:	02f41863          	bne	s0,a5,80002dcc <z_add_thread_to_ready_q+0x9c>
80002da0:	800059b7          	lui	s3,0x80005
80002da4:	800055b7          	lui	a1,0x80005
80002da8:	80005537          	lui	a0,0x80005
80002dac:	5ac58593          	addi	a1,a1,1452 # 800055ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055ad>
80002db0:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002db4:	27600693          	li	a3,630
80002db8:	56098613          	addi	a2,s3,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80002dbc:	b79fe0ef          	jal	ra,80001934 <printk>
80002dc0:	27600593          	li	a1,630
80002dc4:	56098513          	addi	a0,s3,1376
80002dc8:	b8bfe0ef          	jal	ra,80001952 <assert_post_action>
	return list->head == list;
80002dcc:	80006737          	lui	a4,0x80006
80002dd0:	b7470693          	addi	a3,a4,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
80002dd4:	52dc                	lw	a5,36(a3)
80002dd6:	5690                	lw	a2,40(a3)
80002dd8:	800066b7          	lui	a3,0x80006
80002ddc:	b9868693          	addi	a3,a3,-1128 # 80005b98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b99>
80002de0:	b7470713          	addi	a4,a4,-1164
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002de4:	08d78563          	beq	a5,a3,80002e6e <z_add_thread_to_ready_q+0x13e>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002de8:	c3d9                	beqz	a5,80002e6e <z_add_thread_to_ready_q+0x13e>
	if (t1->base.prio < t2->base.prio) {
80002dea:	00e40583          	lb	a1,14(s0)
80002dee:	00e78503          	lb	a0,14(a5)
80002df2:	06a5da63          	bge	a1,a0,80002e66 <z_add_thread_to_ready_q+0x136>
	node->prev = successor->prev;
80002df6:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002df8:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002dfa:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002dfc:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002dfe:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002e00:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80002e04:	4501                	li	a0,0
80002e06:	0407e793          	ori	a5,a5,64
80002e0a:	00f406a3          	sb	a5,13(s0)
80002e0e:	d39ff0ef          	jal	ra,80002b46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002e12:	88890513          	addi	a0,s2,-1912
80002e16:	483000ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80002e1a:	ed0d                	bnez	a0,80002e54 <z_add_thread_to_ready_q+0x124>
80002e1c:	80005437          	lui	s0,0x80005
80002e20:	800055b7          	lui	a1,0x80005
80002e24:	80005537          	lui	a0,0x80005
80002e28:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80002e2c:	06100693          	li	a3,97
80002e30:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002e34:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002e38:	afdfe0ef          	jal	ra,80001934 <printk>
80002e3c:	80005537          	lui	a0,0x80005
80002e40:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80002e44:	af1fe0ef          	jal	ra,80001934 <printk>
80002e48:	06100593          	li	a1,97
80002e4c:	2e840513          	addi	a0,s0,744
80002e50:	b03fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002e54:	3004a4f3          	csrrs	s1,mstatus,s1
}
80002e58:	40f2                	lw	ra,28(sp)
80002e5a:	4462                	lw	s0,24(sp)
80002e5c:	44d2                	lw	s1,20(sp)
80002e5e:	4942                	lw	s2,16(sp)
80002e60:	49b2                	lw	s3,12(sp)
80002e62:	6105                	addi	sp,sp,32
80002e64:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
80002e66:	00f60463          	beq	a2,a5,80002e6e <z_add_thread_to_ready_q+0x13e>
80002e6a:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002e6c:	f3c9                	bnez	a5,80002dee <z_add_thread_to_ready_q+0xbe>
	node->prev = list->tail;
80002e6e:	c050                	sw	a2,4(s0)
	list->tail->next = node;
80002e70:	571c                	lw	a5,40(a4)
	node->next = list;
80002e72:	c014                	sw	a3,0(s0)
	list->tail->next = node;
80002e74:	c380                	sw	s0,0(a5)
	list->tail = node;
80002e76:	d700                	sw	s0,40(a4)
80002e78:	b761                	j	80002e00 <z_add_thread_to_ready_q+0xd0>

80002e7a <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80002e7a:	ff052783          	lw	a5,-16(a0)
{
80002e7e:	1101                	addi	sp,sp,-32
80002e80:	cc22                	sw	s0,24(sp)
80002e82:	c64e                	sw	s3,12(sp)
80002e84:	ce06                	sw	ra,28(sp)
80002e86:	ca26                	sw	s1,20(sp)
80002e88:	c84a                	sw	s2,16(sp)
80002e8a:	c452                	sw	s4,8(sp)
80002e8c:	842a                	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80002e8e:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80002e92:	cfcd                	beqz	a5,80002f4c <z_thread_timeout+0xd2>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002e94:	44a1                	li	s1,8
80002e96:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002e9a:	80006937          	lui	s2,0x80006
80002e9e:	88890513          	addi	a0,s2,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ea2:	88a1                	andi	s1,s1,8
80002ea4:	3db000ef          	jal	ra,80003a7e <z_spin_lock_valid>
80002ea8:	ed0d                	bnez	a0,80002ee2 <z_thread_timeout+0x68>
80002eaa:	80005a37          	lui	s4,0x80005
80002eae:	800055b7          	lui	a1,0x80005
80002eb2:	80005537          	lui	a0,0x80005
80002eb6:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80002eba:	04e00693          	li	a3,78
80002ebe:	2e8a0613          	addi	a2,s4,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002ec2:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002ec6:	a6ffe0ef          	jal	ra,80001934 <printk>
80002eca:	80005537          	lui	a0,0x80005
80002ece:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002ed2:	a63fe0ef          	jal	ra,80001934 <printk>
80002ed6:	04e00593          	li	a1,78
80002eda:	2e8a0513          	addi	a0,s4,744
80002ede:	a75fe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80002ee2:	88890513          	addi	a0,s2,-1912
80002ee6:	3d5000ef          	jal	ra,80003aba <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002eea:	ff040513          	addi	a0,s0,-16
80002eee:	f00ff0ef          	jal	ra,800025ee <pended_on.isra.15>
80002ef2:	85ce                	mv	a1,s3
80002ef4:	b13ff0ef          	jal	ra,80002a06 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002ef8:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002efc:	88890513          	addi	a0,s2,-1912
80002f00:	9bf5                	andi	a5,a5,-3
80002f02:	fef40aa3          	sb	a5,-11(s0)
80002f06:	393000ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80002f0a:	ed0d                	bnez	a0,80002f44 <z_thread_timeout+0xca>
80002f0c:	80005937          	lui	s2,0x80005
80002f10:	800055b7          	lui	a1,0x80005
80002f14:	80005537          	lui	a0,0x80005
80002f18:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80002f1c:	06100693          	li	a3,97
80002f20:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002f24:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002f28:	a0dfe0ef          	jal	ra,80001934 <printk>
80002f2c:	80005537          	lui	a0,0x80005
80002f30:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80002f34:	a01fe0ef          	jal	ra,80001934 <printk>
80002f38:	06100593          	li	a1,97
80002f3c:	2e890513          	addi	a0,s2,744
80002f40:	a13fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002f44:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80002f48:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002f4c:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002f50:	854e                	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002f52:	9bad                	andi	a5,a5,-21
80002f54:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002f58:	e5cff0ef          	jal	ra,800025b4 <z_is_thread_ready>
80002f5c:	c919                	beqz	a0,80002f72 <z_thread_timeout+0xf8>
}
80002f5e:	4462                	lw	s0,24(sp)
80002f60:	40f2                	lw	ra,28(sp)
80002f62:	44d2                	lw	s1,20(sp)
80002f64:	4942                	lw	s2,16(sp)
80002f66:	4a22                	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80002f68:	854e                	mv	a0,s3
80002f6a:	49b2                	lw	s3,12(sp)
80002f6c:	6105                	addi	sp,sp,32
80002f6e:	dc3ff06f          	j	80002d30 <z_add_thread_to_ready_q>
80002f72:	40f2                	lw	ra,28(sp)
80002f74:	4462                	lw	s0,24(sp)
80002f76:	44d2                	lw	s1,20(sp)
80002f78:	4942                	lw	s2,16(sp)
80002f7a:	49b2                	lw	s3,12(sp)
80002f7c:	4a22                	lw	s4,8(sp)
80002f7e:	6105                	addi	sp,sp,32
80002f80:	8082                	ret

80002f82 <z_move_thread_to_end_of_prio_q>:
{
80002f82:	1101                	addi	sp,sp,-32
80002f84:	cc22                	sw	s0,24(sp)
80002f86:	c84a                	sw	s2,16(sp)
80002f88:	ce06                	sw	ra,28(sp)
80002f8a:	ca26                	sw	s1,20(sp)
80002f8c:	c64e                	sw	s3,12(sp)
80002f8e:	c452                	sw	s4,8(sp)
80002f90:	c256                	sw	s5,4(sp)
80002f92:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002f94:	4921                	li	s2,8
80002f96:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f9a:	800069b7          	lui	s3,0x80006
80002f9e:	88898513          	addi	a0,s3,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
80002fa2:	00897913          	andi	s2,s2,8
80002fa6:	2d9000ef          	jal	ra,80003a7e <z_spin_lock_valid>
80002faa:	ed0d                	bnez	a0,80002fe4 <z_move_thread_to_end_of_prio_q+0x62>
80002fac:	800054b7          	lui	s1,0x80005
80002fb0:	800055b7          	lui	a1,0x80005
80002fb4:	80005537          	lui	a0,0x80005
80002fb8:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80002fbc:	04e00693          	li	a3,78
80002fc0:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80002fc4:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80002fc8:	96dfe0ef          	jal	ra,80001934 <printk>
80002fcc:	80005537          	lui	a0,0x80005
80002fd0:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80002fd4:	961fe0ef          	jal	ra,80001934 <printk>
80002fd8:	04e00593          	li	a1,78
80002fdc:	2e848513          	addi	a0,s1,744
80002fe0:	973fe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80002fe4:	88898513          	addi	a0,s3,-1912
80002fe8:	2d3000ef          	jal	ra,80003aba <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80002fec:	800064b7          	lui	s1,0x80006
80002ff0:	b7448513          	addi	a0,s1,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
80002ff4:	85a2                	mv	a1,s0
80002ff6:	02450513          	addi	a0,a0,36
80002ffa:	a0dff0ef          	jal	ra,80002a06 <z_priq_dumb_remove>
	return thread == _idle_thread;
80002ffe:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80003002:	7dc7a783          	lw	a5,2012(a5) # 800057dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057dd>
80003006:	80006a37          	lui	s4,0x80006
8000300a:	b7448493          	addi	s1,s1,-1164
8000300e:	b98a0a13          	addi	s4,s4,-1128 # 80005b98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b99>
80003012:	02f41863          	bne	s0,a5,80003042 <z_move_thread_to_end_of_prio_q+0xc0>
80003016:	80005ab7          	lui	s5,0x80005
8000301a:	800055b7          	lui	a1,0x80005
8000301e:	80005537          	lui	a0,0x80005
80003022:	5ac58593          	addi	a1,a1,1452 # 800055ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055ad>
80003026:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000302a:	27600693          	li	a3,630
8000302e:	560a8613          	addi	a2,s5,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80003032:	903fe0ef          	jal	ra,80001934 <printk>
80003036:	27600593          	li	a1,630
8000303a:	560a8513          	addi	a0,s5,1376
8000303e:	915fe0ef          	jal	ra,80001952 <assert_post_action>
	return list->head == list;
80003042:	50dc                	lw	a5,36(s1)
80003044:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003046:	09478a63          	beq	a5,s4,800030da <z_move_thread_to_end_of_prio_q+0x158>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000304a:	cbc1                	beqz	a5,800030da <z_move_thread_to_end_of_prio_q+0x158>
	if (t1->base.prio < t2->base.prio) {
8000304c:	00e40683          	lb	a3,14(s0)
80003050:	00e78603          	lb	a2,14(a5)
80003054:	06c6df63          	bge	a3,a2,800030d2 <z_move_thread_to_end_of_prio_q+0x150>
	node->prev = successor->prev;
80003058:	43d8                	lw	a4,4(a5)
	node->next = successor;
8000305a:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
8000305c:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
8000305e:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003060:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003062:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003066:	4488                	lw	a0,8(s1)
80003068:	0407e793          	ori	a5,a5,64
8000306c:	8d01                	sub	a0,a0,s0
8000306e:	00153513          	seqz	a0,a0
80003072:	00f406a3          	sb	a5,13(s0)
80003076:	ad1ff0ef          	jal	ra,80002b46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000307a:	88898513          	addi	a0,s3,-1912
8000307e:	21b000ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80003082:	ed0d                	bnez	a0,800030bc <z_move_thread_to_end_of_prio_q+0x13a>
80003084:	80005437          	lui	s0,0x80005
80003088:	800055b7          	lui	a1,0x80005
8000308c:	80005537          	lui	a0,0x80005
80003090:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80003094:	06100693          	li	a3,97
80003098:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000309c:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800030a0:	895fe0ef          	jal	ra,80001934 <printk>
800030a4:	80005537          	lui	a0,0x80005
800030a8:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800030ac:	889fe0ef          	jal	ra,80001934 <printk>
800030b0:	06100593          	li	a1,97
800030b4:	2e840513          	addi	a0,s0,744
800030b8:	89bfe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800030bc:	30092973          	csrrs	s2,mstatus,s2
}
800030c0:	40f2                	lw	ra,28(sp)
800030c2:	4462                	lw	s0,24(sp)
800030c4:	44d2                	lw	s1,20(sp)
800030c6:	4942                	lw	s2,16(sp)
800030c8:	49b2                	lw	s3,12(sp)
800030ca:	4a22                	lw	s4,8(sp)
800030cc:	4a92                	lw	s5,4(sp)
800030ce:	6105                	addi	sp,sp,32
800030d0:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
800030d2:	00e78463          	beq	a5,a4,800030da <z_move_thread_to_end_of_prio_q+0x158>
800030d6:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800030d8:	ffa5                	bnez	a5,80003050 <z_move_thread_to_end_of_prio_q+0xce>
	node->prev = list->tail;
800030da:	c058                	sw	a4,4(s0)
	list->tail->next = node;
800030dc:	549c                	lw	a5,40(s1)
	node->next = list;
800030de:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800030e2:	c380                	sw	s0,0(a5)
	list->tail = node;
800030e4:	d480                	sw	s0,40(s1)
800030e6:	bfb5                	j	80003062 <z_move_thread_to_end_of_prio_q+0xe0>

800030e8 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
800030e8:	800067b7          	lui	a5,0x80006
800030ec:	8907a783          	lw	a5,-1904(a5) # 80005890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005891>
800030f0:	cbb1                	beqz	a5,80003144 <z_time_slice+0x5c>
800030f2:	800067b7          	lui	a5,0x80006
800030f6:	b7478793          	addi	a5,a5,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
800030fa:	4798                	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
800030fc:	07f00693          	li	a3,127
80003100:	00e75603          	lhu	a2,14(a4)
80003104:	04c6e063          	bltu	a3,a2,80003144 <z_time_slice+0x5c>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003108:	800066b7          	lui	a3,0x80006
8000310c:	00e70603          	lb	a2,14(a4)
80003110:	88c6a683          	lw	a3,-1908(a3) # 8000588c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000588d>
80003114:	02d64863          	blt	a2,a3,80003144 <z_time_slice+0x5c>
	return thread == _idle_thread;
80003118:	800056b7          	lui	a3,0x80005
		&& !is_idle(t)
8000311c:	7dc6a683          	lw	a3,2012(a3) # 800057dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057dd>
80003120:	02d70263          	beq	a4,a3,80003144 <z_time_slice+0x5c>
		&& !z_is_thread_timeout_active(t);
80003124:	4f14                	lw	a3,24(a4)
80003126:	ee99                	bnez	a3,80003144 <z_time_slice+0x5c>
		if (ticks >= _current_cpu->slice_ticks) {
80003128:	4b94                	lw	a3,16(a5)
8000312a:	00d54b63          	blt	a0,a3,80003140 <z_time_slice+0x58>
{
8000312e:	1141                	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003130:	853a                	mv	a0,a4
{
80003132:	c606                	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003134:	e4fff0ef          	jal	ra,80002f82 <z_move_thread_to_end_of_prio_q>
}
80003138:	40b2                	lw	ra,12(sp)
8000313a:	0141                	addi	sp,sp,16
			reset_time_slice();
8000313c:	c8cff06f          	j	800025c8 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003140:	8e89                	sub	a3,a3,a0
80003142:	cb94                	sw	a3,16(a5)
80003144:	8082                	ret

80003146 <z_remove_thread_from_ready_q>:
{
80003146:	1101                	addi	sp,sp,-32
80003148:	cc22                	sw	s0,24(sp)
8000314a:	c64e                	sw	s3,12(sp)
8000314c:	ce06                	sw	ra,28(sp)
8000314e:	ca26                	sw	s1,20(sp)
80003150:	c84a                	sw	s2,16(sp)
80003152:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003154:	4421                	li	s0,8
80003156:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000315a:	800064b7          	lui	s1,0x80006
8000315e:	88848513          	addi	a0,s1,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
80003162:	8821                	andi	s0,s0,8
80003164:	11b000ef          	jal	ra,80003a7e <z_spin_lock_valid>
80003168:	ed0d                	bnez	a0,800031a2 <z_remove_thread_from_ready_q+0x5c>
8000316a:	80005937          	lui	s2,0x80005
8000316e:	800055b7          	lui	a1,0x80005
80003172:	80005537          	lui	a0,0x80005
80003176:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
8000317a:	04e00693          	li	a3,78
8000317e:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80003182:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003186:	faefe0ef          	jal	ra,80001934 <printk>
8000318a:	80005537          	lui	a0,0x80005
8000318e:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80003192:	fa2fe0ef          	jal	ra,80001934 <printk>
80003196:	04e00593          	li	a1,78
8000319a:	2e890513          	addi	a0,s2,744
8000319e:	fb4fe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
800031a2:	88848513          	addi	a0,s1,-1912
800031a6:	115000ef          	jal	ra,80003aba <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
800031aa:	00d9c783          	lbu	a5,13(s3)
800031ae:	80006937          	lui	s2,0x80006
800031b2:	b7490913          	addi	s2,s2,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
800031b6:	0407f793          	andi	a5,a5,64
800031ba:	cf81                	beqz	a5,800031d2 <z_remove_thread_from_ready_q+0x8c>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
800031bc:	85ce                	mv	a1,s3
800031be:	02490513          	addi	a0,s2,36
800031c2:	845ff0ef          	jal	ra,80002a06 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
800031c6:	00d9c783          	lbu	a5,13(s3)
800031ca:	fbf7f793          	andi	a5,a5,-65
800031ce:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
800031d2:	00892503          	lw	a0,8(s2)
800031d6:	41350533          	sub	a0,a0,s3
800031da:	00153513          	seqz	a0,a0
800031de:	969ff0ef          	jal	ra,80002b46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800031e2:	88848513          	addi	a0,s1,-1912
800031e6:	0b3000ef          	jal	ra,80003a98 <z_spin_unlock_valid>
800031ea:	ed0d                	bnez	a0,80003224 <z_remove_thread_from_ready_q+0xde>
800031ec:	800054b7          	lui	s1,0x80005
800031f0:	800055b7          	lui	a1,0x80005
800031f4:	80005537          	lui	a0,0x80005
800031f8:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800031fc:	06100693          	li	a3,97
80003200:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80003204:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003208:	f2cfe0ef          	jal	ra,80001934 <printk>
8000320c:	80005537          	lui	a0,0x80005
80003210:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80003214:	f20fe0ef          	jal	ra,80001934 <printk>
80003218:	06100593          	li	a1,97
8000321c:	2e848513          	addi	a0,s1,744
80003220:	f32fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003224:	30042473          	csrrs	s0,mstatus,s0
}
80003228:	40f2                	lw	ra,28(sp)
8000322a:	4462                	lw	s0,24(sp)
8000322c:	44d2                	lw	s1,20(sp)
8000322e:	4942                	lw	s2,16(sp)
80003230:	49b2                	lw	s3,12(sp)
80003232:	6105                	addi	sp,sp,32
80003234:	8082                	ret

80003236 <pend>:
{
80003236:	1101                	addi	sp,sp,-32
80003238:	cc22                	sw	s0,24(sp)
8000323a:	ca26                	sw	s1,20(sp)
8000323c:	842a                	mv	s0,a0
8000323e:	c84a                	sw	s2,16(sp)
80003240:	ce06                	sw	ra,28(sp)
80003242:	c64e                	sw	s3,12(sp)
80003244:	84ae                	mv	s1,a1
80003246:	8932                	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003248:	3dfd                	jal	80003146 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
8000324a:	00d44783          	lbu	a5,13(s0)
8000324e:	0027e793          	ori	a5,a5,2
80003252:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003256:	cca9                	beqz	s1,800032b0 <pend+0x7a>
	return thread == _idle_thread;
80003258:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
8000325c:	7dc7a783          	lw	a5,2012(a5) # 800057dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057dd>
		thread->base.pended_on = wait_q;
80003260:	c404                	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003262:	02f41863          	bne	s0,a5,80003292 <pend+0x5c>
80003266:	800059b7          	lui	s3,0x80005
8000326a:	800055b7          	lui	a1,0x80005
8000326e:	80005537          	lui	a0,0x80005
80003272:	5ac58593          	addi	a1,a1,1452 # 800055ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055ad>
80003276:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000327a:	27600693          	li	a3,630
8000327e:	56098613          	addi	a2,s3,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80003282:	eb2fe0ef          	jal	ra,80001934 <printk>
80003286:	27600593          	li	a1,630
8000328a:	56098513          	addi	a0,s3,1376
8000328e:	ec4fe0ef          	jal	ra,80001952 <assert_post_action>
	return list->head == list;
80003292:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003294:	04f48b63          	beq	s1,a5,800032ea <pend+0xb4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003298:	cba9                	beqz	a5,800032ea <pend+0xb4>
	if (t1->base.prio < t2->base.prio) {
8000329a:	00e40703          	lb	a4,14(s0)
8000329e:	00e78683          	lb	a3,14(a5)
800032a2:	02d75f63          	bge	a4,a3,800032e0 <pend+0xaa>
	node->prev = successor->prev;
800032a6:	43d8                	lw	a4,4(a5)
	node->next = successor;
800032a8:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
800032aa:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
800032ac:	c300                	sw	s0,0(a4)
	successor->prev = node;
800032ae:	c3c0                	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
800032b0:	57fd                	li	a5,-1
800032b2:	04f90363          	beq	s2,a5,800032f8 <pend+0xc2>
800032b6:	45a9                	li	a1,10
800032b8:	00990513          	addi	a0,s2,9
800032bc:	e14fd0ef          	jal	ra,800008d0 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800032c0:	00150613          	addi	a2,a0,1
800032c4:	01840513          	addi	a0,s0,24
}
800032c8:	4462                	lw	s0,24(sp)
800032ca:	40f2                	lw	ra,28(sp)
800032cc:	44d2                	lw	s1,20(sp)
800032ce:	4942                	lw	s2,16(sp)
800032d0:	49b2                	lw	s3,12(sp)
800032d2:	800035b7          	lui	a1,0x80003
800032d6:	e7a58593          	addi	a1,a1,-390 # 80002e7a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002e7b>
800032da:	6105                	addi	sp,sp,32
800032dc:	3c10006f          	j	80003e9c <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
800032e0:	40d4                	lw	a3,4(s1)
800032e2:	00d78463          	beq	a5,a3,800032ea <pend+0xb4>
800032e6:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800032e8:	fbdd                	bnez	a5,8000329e <pend+0x68>
	node->prev = list->tail;
800032ea:	40dc                	lw	a5,4(s1)
	node->next = list;
800032ec:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
800032ee:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
800032f0:	40dc                	lw	a5,4(s1)
800032f2:	c380                	sw	s0,0(a5)
	list->tail = node;
800032f4:	c0c0                	sw	s0,4(s1)
800032f6:	bf6d                	j	800032b0 <pend+0x7a>
}
800032f8:	40f2                	lw	ra,28(sp)
800032fa:	4462                	lw	s0,24(sp)
800032fc:	44d2                	lw	s1,20(sp)
800032fe:	4942                	lw	s2,16(sp)
80003300:	49b2                	lw	s3,12(sp)
80003302:	6105                	addi	sp,sp,32
80003304:	8082                	ret

80003306 <z_pend_curr_irqlock>:
{
80003306:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003308:	800067b7          	lui	a5,0x80006
{
8000330c:	c422                	sw	s0,8(sp)
8000330e:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80003310:	b7c7a503          	lw	a0,-1156(a5) # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
{
80003314:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003316:	3705                	jal	80003236 <pend>
80003318:	8522                	mv	a0,s0
}
8000331a:	4422                	lw	s0,8(sp)
8000331c:	40b2                	lw	ra,12(sp)
8000331e:	0141                	addi	sp,sp,16
80003320:	ea1fc06f          	j	800001c0 <__swap>

80003324 <z_pend_curr>:
{
80003324:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003326:	800067b7          	lui	a5,0x80006
{
8000332a:	c422                	sw	s0,8(sp)
8000332c:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
8000332e:	b7c7a503          	lw	a0,-1156(a5) # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
{
80003332:	c226                	sw	s1,4(sp)
80003334:	84ae                	mv	s1,a1
80003336:	85b2                	mv	a1,a2
	pend(_current, wait_q, timeout);
80003338:	8636                	mv	a2,a3
{
8000333a:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
8000333c:	3ded                	jal	80003236 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000333e:	8522                	mv	a0,s0
80003340:	758000ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80003344:	ed0d                	bnez	a0,8000337e <z_pend_curr+0x5a>
80003346:	80005437          	lui	s0,0x80005
8000334a:	800055b7          	lui	a1,0x80005
8000334e:	80005537          	lui	a0,0x80005
80003352:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80003356:	07800693          	li	a3,120
8000335a:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000335e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003362:	dd2fe0ef          	jal	ra,80001934 <printk>
80003366:	80005537          	lui	a0,0x80005
8000336a:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000336e:	dc6fe0ef          	jal	ra,80001934 <printk>
80003372:	07800593          	li	a1,120
80003376:	2e840513          	addi	a0,s0,744
8000337a:	dd8fe0ef          	jal	ra,80001952 <assert_post_action>
}
8000337e:	4422                	lw	s0,8(sp)
80003380:	40b2                	lw	ra,12(sp)
80003382:	8526                	mv	a0,s1
80003384:	4492                	lw	s1,4(sp)
80003386:	0141                	addi	sp,sp,16
80003388:	e39fc06f          	j	800001c0 <__swap>

8000338c <z_unpend_first_thread>:
{
8000338c:	1101                	addi	sp,sp,-32
8000338e:	c84a                	sw	s2,16(sp)
80003390:	c64e                	sw	s3,12(sp)
80003392:	ce06                	sw	ra,28(sp)
80003394:	cc22                	sw	s0,24(sp)
80003396:	ca26                	sw	s1,20(sp)
80003398:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000339a:	4921                	li	s2,8
8000339c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033a0:	800064b7          	lui	s1,0x80006
800033a4:	88848513          	addi	a0,s1,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
800033a8:	00897913          	andi	s2,s2,8
800033ac:	6d2000ef          	jal	ra,80003a7e <z_spin_lock_valid>
800033b0:	ed0d                	bnez	a0,800033ea <z_unpend_first_thread+0x5e>
800033b2:	80005437          	lui	s0,0x80005
800033b6:	800055b7          	lui	a1,0x80005
800033ba:	80005537          	lui	a0,0x80005
800033be:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800033c2:	04e00693          	li	a3,78
800033c6:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800033ca:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800033ce:	d66fe0ef          	jal	ra,80001934 <printk>
800033d2:	80005537          	lui	a0,0x80005
800033d6:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
800033da:	d5afe0ef          	jal	ra,80001934 <printk>
800033de:	04e00593          	li	a1,78
800033e2:	2e840513          	addi	a0,s0,744
800033e6:	d6cfe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
800033ea:	88848513          	addi	a0,s1,-1912
800033ee:	6cc000ef          	jal	ra,80003aba <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
800033f2:	854e                	mv	a0,s3
800033f4:	f46ff0ef          	jal	ra,80002b3a <z_priq_dumb_best>
800033f8:	842a                	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800033fa:	88848513          	addi	a0,s1,-1912
800033fe:	2d69                	jal	80003a98 <z_spin_unlock_valid>
80003400:	ed0d                	bnez	a0,8000343a <z_unpend_first_thread+0xae>
80003402:	800059b7          	lui	s3,0x80005
80003406:	800055b7          	lui	a1,0x80005
8000340a:	80005537          	lui	a0,0x80005
8000340e:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80003412:	06100693          	li	a3,97
80003416:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000341a:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000341e:	d16fe0ef          	jal	ra,80001934 <printk>
80003422:	80005537          	lui	a0,0x80005
80003426:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000342a:	d0afe0ef          	jal	ra,80001934 <printk>
8000342e:	06100593          	li	a1,97
80003432:	2e898513          	addi	a0,s3,744
80003436:	d1cfe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000343a:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
8000343e:	cc4d                	beqz	s0,800034f8 <z_unpend_first_thread+0x16c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003440:	4921                	li	s2,8
80003442:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003446:	88848513          	addi	a0,s1,-1912
	key = (mstatus & SOC_MSTATUS_IEN);
8000344a:	00897913          	andi	s2,s2,8
8000344e:	2d05                	jal	80003a7e <z_spin_lock_valid>
80003450:	ed0d                	bnez	a0,8000348a <z_unpend_first_thread+0xfe>
80003452:	800059b7          	lui	s3,0x80005
80003456:	800055b7          	lui	a1,0x80005
8000345a:	80005537          	lui	a0,0x80005
8000345e:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80003462:	04e00693          	li	a3,78
80003466:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000346a:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000346e:	cc6fe0ef          	jal	ra,80001934 <printk>
80003472:	80005537          	lui	a0,0x80005
80003476:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
8000347a:	cbafe0ef          	jal	ra,80001934 <printk>
8000347e:	04e00593          	li	a1,78
80003482:	2e898513          	addi	a0,s3,744
80003486:	cccfe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
8000348a:	88848513          	addi	a0,s1,-1912
8000348e:	2535                	jal	80003aba <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003490:	00840513          	addi	a0,s0,8
80003494:	95aff0ef          	jal	ra,800025ee <pended_on.isra.15>
80003498:	85a2                	mv	a1,s0
8000349a:	d6cff0ef          	jal	ra,80002a06 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000349e:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800034a2:	88848513          	addi	a0,s1,-1912
800034a6:	9bf5                	andi	a5,a5,-3
800034a8:	00f406a3          	sb	a5,13(s0)
800034ac:	23f5                	jal	80003a98 <z_spin_unlock_valid>
800034ae:	ed0d                	bnez	a0,800034e8 <z_unpend_first_thread+0x15c>
800034b0:	800054b7          	lui	s1,0x80005
800034b4:	800055b7          	lui	a1,0x80005
800034b8:	80005537          	lui	a0,0x80005
800034bc:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800034c0:	06100693          	li	a3,97
800034c4:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800034c8:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800034cc:	c68fe0ef          	jal	ra,80001934 <printk>
800034d0:	80005537          	lui	a0,0x80005
800034d4:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800034d8:	c5cfe0ef          	jal	ra,80001934 <printk>
800034dc:	06100593          	li	a1,97
800034e0:	2e848513          	addi	a0,s1,744
800034e4:	c6efe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800034e8:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
800034ec:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
800034f0:	01840513          	addi	a0,s0,24
800034f4:	371000ef          	jal	ra,80004064 <z_abort_timeout>
}
800034f8:	8522                	mv	a0,s0
800034fa:	40f2                	lw	ra,28(sp)
800034fc:	4462                	lw	s0,24(sp)
800034fe:	44d2                	lw	s1,20(sp)
80003500:	4942                	lw	s2,16(sp)
80003502:	49b2                	lw	s3,12(sp)
80003504:	6105                	addi	sp,sp,32
80003506:	8082                	ret

80003508 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80003508:	1141                	addi	sp,sp,-16
8000350a:	c226                	sw	s1,4(sp)
8000350c:	c04a                	sw	s2,0(sp)
8000350e:	c606                	sw	ra,12(sp)
80003510:	c422                	sw	s0,8(sp)
80003512:	892a                	mv	s2,a0
	int need_sched = 0;
80003514:	4481                	li	s1,0
	return list->head == list;
80003516:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000351a:	00890363          	beq	s2,s0,80003520 <z_unpend_all+0x18>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
8000351e:	e801                	bnez	s0,8000352e <z_unpend_all+0x26>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80003520:	40b2                	lw	ra,12(sp)
80003522:	4422                	lw	s0,8(sp)
80003524:	8526                	mv	a0,s1
80003526:	4902                	lw	s2,0(sp)
80003528:	4492                	lw	s1,4(sp)
8000352a:	0141                	addi	sp,sp,16
8000352c:	8082                	ret
		z_unpend_thread(th);
8000352e:	8522                	mv	a0,s0
80003530:	d32ff0ef          	jal	ra,80002a62 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80003534:	8522                	mv	a0,s0
80003536:	87eff0ef          	jal	ra,800025b4 <z_is_thread_ready>
		need_sched = 1;
8000353a:	4485                	li	s1,1
8000353c:	dd69                	beqz	a0,80003516 <z_unpend_all+0xe>
		z_add_thread_to_ready_q(thread);
8000353e:	8522                	mv	a0,s0
80003540:	ff0ff0ef          	jal	ra,80002d30 <z_add_thread_to_ready_q>
80003544:	bfc9                	j	80003516 <z_unpend_all+0xe>

80003546 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80003546:	800067b7          	lui	a5,0x80006
8000354a:	b7478793          	addi	a5,a5,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
8000354e:	02478713          	addi	a4,a5,36
80003552:	d3d8                	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003554:	d798                	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003556:	4581                	li	a1,0
80003558:	4501                	li	a0,0
8000355a:	8daff06f          	j	80002634 <k_sched_time_slice_set>

8000355e <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
8000355e:	1101                	addi	sp,sp,-32
80003560:	cc22                	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80003562:	80006437          	lui	s0,0x80006
80003566:	b7442783          	lw	a5,-1164(s0) # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
{
8000356a:	ce06                	sw	ra,28(sp)
8000356c:	ca26                	sw	s1,20(sp)
8000356e:	c84a                	sw	s2,16(sp)
80003570:	c64e                	sw	s3,12(sp)
80003572:	c452                	sw	s4,8(sp)
80003574:	c256                	sw	s5,4(sp)
80003576:	b7440413          	addi	s0,s0,-1164
	__ASSERT(!z_is_in_isr(), "");
8000357a:	cf8d                	beqz	a5,800035b4 <z_impl_k_yield+0x56>
8000357c:	800054b7          	lui	s1,0x80005
80003580:	800055b7          	lui	a1,0x80005
80003584:	80005537          	lui	a0,0x80005
80003588:	4f858593          	addi	a1,a1,1272 # 800054f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054f9>
8000358c:	37e00693          	li	a3,894
80003590:	56048613          	addi	a2,s1,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80003594:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003598:	b9cfe0ef          	jal	ra,80001934 <printk>
8000359c:	80005537          	lui	a0,0x80005
800035a0:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
800035a4:	b90fe0ef          	jal	ra,80001934 <printk>
800035a8:	37e00593          	li	a1,894
800035ac:	56048513          	addi	a0,s1,1376
800035b0:	ba2fe0ef          	jal	ra,80001952 <assert_post_action>
	return thread == _idle_thread;
800035b4:	800057b7          	lui	a5,0x80005

	if (!is_idle(_current)) {
800035b8:	4414                	lw	a3,8(s0)
800035ba:	7dc7a703          	lw	a4,2012(a5) # 800057dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057dd>
800035be:	8a3e                	mv	s4,a5
800035c0:	10e68563          	beq	a3,a4,800036ca <z_impl_k_yield+0x16c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800035c4:	4921                	li	s2,8
800035c6:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800035ca:	800069b7          	lui	s3,0x80006
800035ce:	88898513          	addi	a0,s3,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	key = (mstatus & SOC_MSTATUS_IEN);
800035d2:	00897913          	andi	s2,s2,8
800035d6:	2165                	jal	80003a7e <z_spin_lock_valid>
800035d8:	ed0d                	bnez	a0,80003612 <z_impl_k_yield+0xb4>
800035da:	800054b7          	lui	s1,0x80005
800035de:	800055b7          	lui	a1,0x80005
800035e2:	80005537          	lui	a0,0x80005
800035e6:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800035ea:	04e00693          	li	a3,78
800035ee:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800035f2:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800035f6:	b3efe0ef          	jal	ra,80001934 <printk>
800035fa:	80005537          	lui	a0,0x80005
800035fe:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80003602:	b32fe0ef          	jal	ra,80001934 <printk>
80003606:	04e00593          	li	a1,78
8000360a:	2e848513          	addi	a0,s1,744
8000360e:	b44fe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80003612:	88898513          	addi	a0,s3,-1912
80003616:	2155                	jal	80003aba <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80003618:	440c                	lw	a1,8(s0)
8000361a:	02440513          	addi	a0,s0,36
8000361e:	be8ff0ef          	jal	ra,80002a06 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80003622:	7dca2783          	lw	a5,2012(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80003626:	4404                	lw	s1,8(s0)
	return thread == _idle_thread;
80003628:	80006a37          	lui	s4,0x80006
8000362c:	b98a0a13          	addi	s4,s4,-1128 # 80005b98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b99>
	__ASSERT_NO_MSG(!is_idle(thread));
80003630:	02f49863          	bne	s1,a5,80003660 <z_impl_k_yield+0x102>
80003634:	80005ab7          	lui	s5,0x80005
80003638:	800055b7          	lui	a1,0x80005
8000363c:	80005537          	lui	a0,0x80005
80003640:	5ac58593          	addi	a1,a1,1452 # 800055ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055ad>
80003644:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003648:	27600693          	li	a3,630
8000364c:	560a8613          	addi	a2,s5,1376 # 80005560 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005561>
80003650:	ae4fe0ef          	jal	ra,80001934 <printk>
80003654:	27600593          	li	a1,630
80003658:	560a8513          	addi	a0,s5,1376
8000365c:	af6fe0ef          	jal	ra,80001952 <assert_post_action>
	return list->head == list;
80003660:	505c                	lw	a5,36(s0)
80003662:	5418                	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003664:	09478563          	beq	a5,s4,800036ee <z_impl_k_yield+0x190>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003668:	c3d9                	beqz	a5,800036ee <z_impl_k_yield+0x190>
	if (t1->base.prio < t2->base.prio) {
8000366a:	00e48683          	lb	a3,14(s1)
8000366e:	00e78603          	lb	a2,14(a5)
80003672:	06c6da63          	bge	a3,a2,800036e6 <z_impl_k_yield+0x188>
	node->prev = successor->prev;
80003676:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003678:	c09c                	sw	a5,0(s1)
	node->prev = successor->prev;
8000367a:	c0d8                	sw	a4,4(s1)
	successor->prev->next = node;
8000367c:	c304                	sw	s1,0(a4)
	successor->prev = node;
8000367e:	c3c4                	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80003680:	4505                	li	a0,1
80003682:	cc4ff0ef          	jal	ra,80002b46 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003686:	88898513          	addi	a0,s3,-1912
8000368a:	2139                	jal	80003a98 <z_spin_unlock_valid>
8000368c:	ed0d                	bnez	a0,800036c6 <z_impl_k_yield+0x168>
8000368e:	80005437          	lui	s0,0x80005
80003692:	800055b7          	lui	a1,0x80005
80003696:	80005537          	lui	a0,0x80005
8000369a:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
8000369e:	06100693          	li	a3,97
800036a2:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800036a6:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800036aa:	a8afe0ef          	jal	ra,80001934 <printk>
800036ae:	80005537          	lui	a0,0x80005
800036b2:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800036b6:	a7efe0ef          	jal	ra,80001934 <printk>
800036ba:	06100593          	li	a1,97
800036be:	2e840513          	addi	a0,s0,744
800036c2:	a90fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800036c6:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
800036ca:	4521                	li	a0,8
800036cc:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
800036d0:	4462                	lw	s0,24(sp)
800036d2:	40f2                	lw	ra,28(sp)
800036d4:	44d2                	lw	s1,20(sp)
800036d6:	4942                	lw	s2,16(sp)
800036d8:	49b2                	lw	s3,12(sp)
800036da:	4a22                	lw	s4,8(sp)
800036dc:	4a92                	lw	s5,4(sp)
800036de:	8921                	andi	a0,a0,8
800036e0:	6105                	addi	sp,sp,32
800036e2:	adffc06f          	j	800001c0 <__swap>
	return (node == list->tail) ? NULL : node->next;
800036e6:	00e78463          	beq	a5,a4,800036ee <z_impl_k_yield+0x190>
800036ea:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800036ec:	f3c9                	bnez	a5,8000366e <z_impl_k_yield+0x110>
	node->prev = list->tail;
800036ee:	c0d8                	sw	a4,4(s1)
	list->tail->next = node;
800036f0:	541c                	lw	a5,40(s0)
	node->next = list;
800036f2:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
800036f6:	c384                	sw	s1,0(a5)
	list->tail = node;
800036f8:	d404                	sw	s1,40(s0)
800036fa:	b759                	j	80003680 <z_impl_k_yield+0x122>

800036fc <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800036fc:	800067b7          	lui	a5,0x80006
80003700:	b7c7a503          	lw	a0,-1156(a5) # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003704:	8082                	ret

80003706 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80003706:	1101                	addi	sp,sp,-32
80003708:	cc22                	sw	s0,24(sp)
8000370a:	ca26                	sw	s1,20(sp)
8000370c:	c84a                	sw	s2,16(sp)
8000370e:	ce06                	sw	ra,28(sp)
80003710:	c64e                	sw	s3,12(sp)
80003712:	842a                	mv	s0,a0
80003714:	892e                	mv	s2,a1
80003716:	84b2                	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80003718:	ee0d                	bnez	a2,80003752 <z_impl_k_sem_init+0x4c>
8000371a:	800059b7          	lui	s3,0x80005
8000371e:	800055b7          	lui	a1,0x80005
80003722:	80005537          	lui	a0,0x80005
80003726:	5d058593          	addi	a1,a1,1488 # 800055d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055d1>
8000372a:	04600693          	li	a3,70
8000372e:	5c098613          	addi	a2,s3,1472 # 800055c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055c1>
80003732:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003736:	9fefe0ef          	jal	ra,80001934 <printk>
8000373a:	80005537          	lui	a0,0x80005
8000373e:	5dc50513          	addi	a0,a0,1500 # 800055dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055dd>
80003742:	9f2fe0ef          	jal	ra,80001934 <printk>
80003746:	04600593          	li	a1,70
8000374a:	5c098513          	addi	a0,s3,1472
8000374e:	a04fe0ef          	jal	ra,80001952 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003752:	0324fe63          	bgeu	s1,s2,8000378e <z_impl_k_sem_init+0x88>
80003756:	800059b7          	lui	s3,0x80005
8000375a:	800055b7          	lui	a1,0x80005
8000375e:	80005537          	lui	a0,0x80005
80003762:	5f458593          	addi	a1,a1,1524 # 800055f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055f5>
80003766:	04700693          	li	a3,71
8000376a:	5c098613          	addi	a2,s3,1472 # 800055c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055c1>
8000376e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003772:	9c2fe0ef          	jal	ra,80001934 <printk>
80003776:	80005537          	lui	a0,0x80005
8000377a:	60c50513          	addi	a0,a0,1548 # 8000560c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000560d>
8000377e:	9b6fe0ef          	jal	ra,80001934 <printk>
80003782:	04700593          	li	a1,71
80003786:	5c098513          	addi	a0,s3,1472
8000378a:	9c8fe0ef          	jal	ra,80001952 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
8000378e:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80003792:	c444                	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80003794:	c000                	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80003796:	c040                	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80003798:	40f2                	lw	ra,28(sp)
8000379a:	4462                	lw	s0,24(sp)
8000379c:	44d2                	lw	s1,20(sp)
8000379e:	4942                	lw	s2,16(sp)
800037a0:	49b2                	lw	s3,12(sp)
800037a2:	6105                	addi	sp,sp,32
800037a4:	8082                	ret

800037a6 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800037a6:	1101                	addi	sp,sp,-32
800037a8:	ca26                	sw	s1,20(sp)
800037aa:	c64e                	sw	s3,12(sp)
800037ac:	ce06                	sw	ra,28(sp)
800037ae:	cc22                	sw	s0,24(sp)
800037b0:	c84a                	sw	s2,16(sp)
800037b2:	89aa                	mv	s3,a0
800037b4:	44a1                	li	s1,8
800037b6:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800037ba:	80006437          	lui	s0,0x80006
800037be:	89440513          	addi	a0,s0,-1900 # 80005894 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005895>
	key = (mstatus & SOC_MSTATUS_IEN);
800037c2:	88a1                	andi	s1,s1,8
800037c4:	2c6d                	jal	80003a7e <z_spin_lock_valid>
800037c6:	ed0d                	bnez	a0,80003800 <z_impl_k_sem_give+0x5a>
800037c8:	80005937          	lui	s2,0x80005
800037cc:	800055b7          	lui	a1,0x80005
800037d0:	80005537          	lui	a0,0x80005
800037d4:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800037d8:	04e00693          	li	a3,78
800037dc:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800037e0:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800037e4:	950fe0ef          	jal	ra,80001934 <printk>
800037e8:	80005537          	lui	a0,0x80005
800037ec:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
800037f0:	944fe0ef          	jal	ra,80001934 <printk>
800037f4:	04e00593          	li	a1,78
800037f8:	2e890513          	addi	a0,s2,744
800037fc:	956fe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80003800:	89440513          	addi	a0,s0,-1900
80003804:	2c5d                	jal	80003aba <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80003806:	854e                	mv	a0,s3
80003808:	b85ff0ef          	jal	ra,8000338c <z_unpend_first_thread>
8000380c:	892a                	mv	s2,a0
	if (thread != NULL) {
8000380e:	c515                	beqz	a0,8000383a <z_impl_k_sem_give+0x94>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003810:	00d54783          	lbu	a5,13(a0)
80003814:	8bfd                	andi	a5,a5,31
80003816:	e789                	bnez	a5,80003820 <z_impl_k_sem_give+0x7a>
	if (z_is_thread_ready(thread)) {
80003818:	4d1c                	lw	a5,24(a0)
8000381a:	e399                	bnez	a5,80003820 <z_impl_k_sem_give+0x7a>
		z_add_thread_to_ready_q(thread);
8000381c:	d14ff0ef          	jal	ra,80002d30 <z_add_thread_to_ready_q>
80003820:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80003824:	89440513          	addi	a0,s0,-1900
}
80003828:	4462                	lw	s0,24(sp)
8000382a:	40f2                	lw	ra,28(sp)
8000382c:	4942                	lw	s2,16(sp)
8000382e:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003830:	85a6                	mv	a1,s1
}
80003832:	44d2                	lw	s1,20(sp)
80003834:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003836:	fb1fe06f          	j	800027e6 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
8000383a:	0089a703          	lw	a4,8(s3)
8000383e:	00c9a783          	lw	a5,12(s3)
80003842:	8f99                	sub	a5,a5,a4
80003844:	00f037b3          	snez	a5,a5
80003848:	97ba                	add	a5,a5,a4
8000384a:	00f9a423          	sw	a5,8(s3)
8000384e:	bfd9                	j	80003824 <z_impl_k_sem_give+0x7e>

80003850 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003850:	800067b7          	lui	a5,0x80006
80003854:	b747a783          	lw	a5,-1164(a5) # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
{
80003858:	1101                	addi	sp,sp,-32
8000385a:	c84a                	sw	s2,16(sp)
8000385c:	c64e                	sw	s3,12(sp)
8000385e:	ce06                	sw	ra,28(sp)
80003860:	cc22                	sw	s0,24(sp)
80003862:	ca26                	sw	s1,20(sp)
80003864:	c452                	sw	s4,8(sp)
80003866:	892a                	mv	s2,a0
80003868:	89ae                	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000386a:	cf95                	beqz	a5,800038a6 <z_impl_k_sem_take+0x56>
8000386c:	cd8d                	beqz	a1,800038a6 <z_impl_k_sem_take+0x56>
8000386e:	80005437          	lui	s0,0x80005
80003872:	800055b7          	lui	a1,0x80005
80003876:	80005537          	lui	a0,0x80005
8000387a:	63458593          	addi	a1,a1,1588 # 80005634 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005635>
8000387e:	08c00693          	li	a3,140
80003882:	5c040613          	addi	a2,s0,1472 # 800055c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055c1>
80003886:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000388a:	8aafe0ef          	jal	ra,80001934 <printk>
8000388e:	80005537          	lui	a0,0x80005
80003892:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
80003896:	89efe0ef          	jal	ra,80001934 <printk>
8000389a:	08c00593          	li	a1,140
8000389e:	5c040513          	addi	a0,s0,1472
800038a2:	8b0fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800038a6:	4421                	li	s0,8
800038a8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800038ac:	800064b7          	lui	s1,0x80006
800038b0:	89448513          	addi	a0,s1,-1900 # 80005894 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005895>
	key = (mstatus & SOC_MSTATUS_IEN);
800038b4:	8821                	andi	s0,s0,8
800038b6:	22e1                	jal	80003a7e <z_spin_lock_valid>
800038b8:	ed0d                	bnez	a0,800038f2 <z_impl_k_sem_take+0xa2>
800038ba:	80005a37          	lui	s4,0x80005
800038be:	800055b7          	lui	a1,0x80005
800038c2:	80005537          	lui	a0,0x80005
800038c6:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800038ca:	04e00693          	li	a3,78
800038ce:	2e8a0613          	addi	a2,s4,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800038d2:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800038d6:	85efe0ef          	jal	ra,80001934 <printk>
800038da:	80005537          	lui	a0,0x80005
800038de:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
800038e2:	852fe0ef          	jal	ra,80001934 <printk>
800038e6:	04e00593          	li	a1,78
800038ea:	2e8a0513          	addi	a0,s4,744
800038ee:	864fe0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
800038f2:	89448513          	addi	a0,s1,-1900
800038f6:	22d1                	jal	80003aba <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
800038f8:	00892783          	lw	a5,8(s2)
800038fc:	cfb9                	beqz	a5,8000395a <z_impl_k_sem_take+0x10a>
		sem->count--;
800038fe:	17fd                	addi	a5,a5,-1
80003900:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003904:	89448513          	addi	a0,s1,-1900
80003908:	2a41                	jal	80003a98 <z_spin_unlock_valid>
8000390a:	ed0d                	bnez	a0,80003944 <z_impl_k_sem_take+0xf4>
8000390c:	800054b7          	lui	s1,0x80005
80003910:	800055b7          	lui	a1,0x80005
80003914:	80005537          	lui	a0,0x80005
80003918:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
8000391c:	06100693          	li	a3,97
80003920:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80003924:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003928:	80cfe0ef          	jal	ra,80001934 <printk>
8000392c:	80005537          	lui	a0,0x80005
80003930:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80003934:	800fe0ef          	jal	ra,80001934 <printk>
80003938:	06100593          	li	a1,97
8000393c:	2e848513          	addi	a0,s1,744
80003940:	812fe0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003944:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80003948:	4501                	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
8000394a:	40f2                	lw	ra,28(sp)
8000394c:	4462                	lw	s0,24(sp)
8000394e:	44d2                	lw	s1,20(sp)
80003950:	4942                	lw	s2,16(sp)
80003952:	49b2                	lw	s3,12(sp)
80003954:	4a22                	lw	s4,8(sp)
80003956:	6105                	addi	sp,sp,32
80003958:	8082                	ret
	if (timeout == K_NO_WAIT) {
8000395a:	04099663          	bnez	s3,800039a6 <z_impl_k_sem_take+0x156>
8000395e:	89448513          	addi	a0,s1,-1900
80003962:	2a1d                	jal	80003a98 <z_spin_unlock_valid>
80003964:	ed0d                	bnez	a0,8000399e <z_impl_k_sem_take+0x14e>
80003966:	800054b7          	lui	s1,0x80005
8000396a:	800055b7          	lui	a1,0x80005
8000396e:	80005537          	lui	a0,0x80005
80003972:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80003976:	06100693          	li	a3,97
8000397a:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000397e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003982:	fb3fd0ef          	jal	ra,80001934 <printk>
80003986:	80005537          	lui	a0,0x80005
8000398a:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000398e:	fa7fd0ef          	jal	ra,80001934 <printk>
80003992:	06100593          	li	a1,97
80003996:	2e848513          	addi	a0,s1,744
8000399a:	fb9fd0ef          	jal	ra,80001952 <assert_post_action>
8000399e:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800039a2:	5541                	li	a0,-16
800039a4:	b75d                	j	8000394a <z_impl_k_sem_take+0xfa>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800039a6:	85a2                	mv	a1,s0
}
800039a8:	4462                	lw	s0,24(sp)
800039aa:	40f2                	lw	ra,28(sp)
800039ac:	4a22                	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800039ae:	86ce                	mv	a3,s3
800039b0:	864a                	mv	a2,s2
}
800039b2:	49b2                	lw	s3,12(sp)
800039b4:	4942                	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800039b6:	89448513          	addi	a0,s1,-1900
}
800039ba:	44d2                	lw	s1,20(sp)
800039bc:	6105                	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800039be:	967ff06f          	j	80003324 <z_pend_curr>

800039c2 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800039c2:	00d54783          	lbu	a5,13(a0)
800039c6:	8bfd                	andi	a5,a5,31
800039c8:	e789                	bnez	a5,800039d2 <z_is_thread_ready+0x10>
800039ca:	4d08                	lw	a0,24(a0)
800039cc:	00153513          	seqz	a0,a0
800039d0:	8082                	ret
800039d2:	4501                	li	a0,0
}
800039d4:	8082                	ret

800039d6 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800039d6:	800067b7          	lui	a5,0x80006
800039da:	b747a503          	lw	a0,-1164(a5) # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
}
800039de:	00a03533          	snez	a0,a0
800039e2:	8082                	ret

800039e4 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800039e4:	800067b7          	lui	a5,0x80006
800039e8:	b7c7a783          	lw	a5,-1156(a5) # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800039ec:	00c7c503          	lbu	a0,12(a5)
}
800039f0:	8905                	andi	a0,a0,1
800039f2:	8082                	ret

800039f4 <z_impl_k_thread_name_set>:
#else
void z_impl_k_thread_name_set(k_tid_t thread_id, const char *value)
{
	ARG_UNUSED(thread_id);
	ARG_UNUSED(value);
}
800039f4:	8082                	ret

800039f6 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
800039f6:	1101                	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800039f8:	5302                	lw	t1,32(sp)
{
800039fa:	cc22                	sw	s0,24(sp)
800039fc:	ce06                	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800039fe:	c01a                	sw	t1,0(sp)
{
80003a00:	842a                	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003a02:	c7afd0ef          	jal	ra,80000e7c <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80003a06:	800067b7          	lui	a5,0x80006
80003a0a:	b7c7a783          	lw	a5,-1156(a5) # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
	sys_trace_thread_create(new_thread);
}
80003a0e:	40f2                	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80003a10:	57bc                	lw	a5,104(a5)
80003a12:	d43c                	sw	a5,104(s0)
}
80003a14:	4462                	lw	s0,24(sp)
80003a16:	6105                	addi	sp,sp,32
80003a18:	8082                	ret

80003a1a <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80003a1a:	513c                	lw	a5,96(a0)
{
80003a1c:	1141                	addi	sp,sp,-16
80003a1e:	c422                	sw	s0,8(sp)
80003a20:	c606                	sw	ra,12(sp)
80003a22:	842a                	mv	s0,a0
	if (thread->fn_abort != NULL) {
80003a24:	c391                	beqz	a5,80003a28 <z_thread_single_abort+0xe>
		thread->fn_abort();
80003a26:	9782                	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80003a28:	8522                	mv	a0,s0
80003a2a:	f99ff0ef          	jal	ra,800039c2 <z_is_thread_ready>
80003a2e:	cd11                	beqz	a0,80003a4a <z_thread_single_abort+0x30>
		z_remove_thread_from_ready_q(thread);
80003a30:	8522                	mv	a0,s0
80003a32:	f14ff0ef          	jal	ra,80003146 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80003a36:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80003a3a:	40b2                	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80003a3c:	0087e793          	ori	a5,a5,8
80003a40:	00f406a3          	sb	a5,13(s0)
}
80003a44:	4422                	lw	s0,8(sp)
80003a46:	0141                	addi	sp,sp,16
80003a48:	8082                	ret
		if (z_is_thread_pending(thread)) {
80003a4a:	00d44783          	lbu	a5,13(s0)
80003a4e:	8b89                	andi	a5,a5,2
80003a50:	c781                	beqz	a5,80003a58 <z_thread_single_abort+0x3e>
			z_unpend_thread_no_timeout(thread);
80003a52:	8522                	mv	a0,s0
80003a54:	cc3fe0ef          	jal	ra,80002716 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80003a58:	4c1c                	lw	a5,24(s0)
80003a5a:	dff1                	beqz	a5,80003a36 <z_thread_single_abort+0x1c>
80003a5c:	01840513          	addi	a0,s0,24
80003a60:	2511                	jal	80004064 <z_abort_timeout>
80003a62:	bfd1                	j	80003a36 <z_thread_single_abort+0x1c>

80003a64 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80003a64:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80003a68:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80003a6c:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80003a70:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80003a74:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80003a78:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80003a7c:	8082                	ret

80003a7e <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80003a7e:	4108                	lw	a0,0(a0)
80003a80:	c911                	beqz	a0,80003a94 <z_spin_lock_valid+0x16>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80003a82:	800067b7          	lui	a5,0x80006
80003a86:	b887c783          	lbu	a5,-1144(a5) # 80005b88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b89>
80003a8a:	890d                	andi	a0,a0,3
80003a8c:	8d1d                	sub	a0,a0,a5
80003a8e:	00a03533          	snez	a0,a0
80003a92:	8082                	ret
			return false;
		}
	}
	return true;
80003a94:	4505                	li	a0,1
}
80003a96:	8082                	ret

80003a98 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80003a98:	800067b7          	lui	a5,0x80006
80003a9c:	b7478793          	addi	a5,a5,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
80003aa0:	0147c703          	lbu	a4,20(a5)
80003aa4:	479c                	lw	a5,8(a5)
80003aa6:	8fd9                	or	a5,a5,a4
80003aa8:	4118                	lw	a4,0(a0)
80003aaa:	00f71663          	bne	a4,a5,80003ab6 <z_spin_unlock_valid+0x1e>
		return false;
	}
	l->thread_cpu = 0;
80003aae:	00052023          	sw	zero,0(a0)
	return true;
80003ab2:	4505                	li	a0,1
80003ab4:	8082                	ret
		return false;
80003ab6:	4501                	li	a0,0
}
80003ab8:	8082                	ret

80003aba <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80003aba:	800067b7          	lui	a5,0x80006
80003abe:	b7478793          	addi	a5,a5,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
80003ac2:	0147c703          	lbu	a4,20(a5)
80003ac6:	479c                	lw	a5,8(a5)
80003ac8:	8fd9                	or	a5,a5,a4
80003aca:	c11c                	sw	a5,0(a0)
}
80003acc:	8082                	ret

80003ace <z_impl_k_thread_start>:
{
80003ace:	1101                	addi	sp,sp,-32
80003ad0:	cc22                	sw	s0,24(sp)
80003ad2:	c84a                	sw	s2,16(sp)
80003ad4:	ce06                	sw	ra,28(sp)
80003ad6:	ca26                	sw	s1,20(sp)
80003ad8:	c64e                	sw	s3,12(sp)
80003ada:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003adc:	4421                	li	s0,8
80003ade:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003ae2:	800064b7          	lui	s1,0x80006
80003ae6:	89848513          	addi	a0,s1,-1896 # 80005898 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005899>
	key = (mstatus & SOC_MSTATUS_IEN);
80003aea:	8821                	andi	s0,s0,8
80003aec:	f93ff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
80003af0:	ed0d                	bnez	a0,80003b2a <z_impl_k_thread_start+0x5c>
80003af2:	800059b7          	lui	s3,0x80005
80003af6:	800055b7          	lui	a1,0x80005
80003afa:	80005537          	lui	a0,0x80005
80003afe:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80003b02:	04e00693          	li	a3,78
80003b06:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80003b0a:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003b0e:	e27fd0ef          	jal	ra,80001934 <printk>
80003b12:	80005537          	lui	a0,0x80005
80003b16:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80003b1a:	e1bfd0ef          	jal	ra,80001934 <printk>
80003b1e:	04e00593          	li	a1,78
80003b22:	2e898513          	addi	a0,s3,744
80003b26:	e2dfd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b2a:	89848513          	addi	a0,s1,-1896
80003b2e:	f8dff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80003b32:	00d94783          	lbu	a5,13(s2)
80003b36:	0047f713          	andi	a4,a5,4
80003b3a:	eb39                	bnez	a4,80003b90 <z_impl_k_thread_start+0xc2>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b3c:	89848513          	addi	a0,s1,-1896
80003b40:	f59ff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80003b44:	ed0d                	bnez	a0,80003b7e <z_impl_k_thread_start+0xb0>
80003b46:	800054b7          	lui	s1,0x80005
80003b4a:	800055b7          	lui	a1,0x80005
80003b4e:	80005537          	lui	a0,0x80005
80003b52:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80003b56:	06100693          	li	a3,97
80003b5a:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80003b5e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003b62:	dd3fd0ef          	jal	ra,80001934 <printk>
80003b66:	80005537          	lui	a0,0x80005
80003b6a:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80003b6e:	dc7fd0ef          	jal	ra,80001934 <printk>
80003b72:	06100593          	li	a1,97
80003b76:	2e848513          	addi	a0,s1,744
80003b7a:	dd9fd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003b7e:	30042473          	csrrs	s0,mstatus,s0
}
80003b82:	40f2                	lw	ra,28(sp)
80003b84:	4462                	lw	s0,24(sp)
80003b86:	44d2                	lw	s1,20(sp)
80003b88:	4942                	lw	s2,16(sp)
80003b8a:	49b2                	lw	s3,12(sp)
80003b8c:	6105                	addi	sp,sp,32
80003b8e:	8082                	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003b90:	9bed                	andi	a5,a5,-5
80003b92:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80003b96:	854a                	mv	a0,s2
80003b98:	e2bff0ef          	jal	ra,800039c2 <z_is_thread_ready>
80003b9c:	c501                	beqz	a0,80003ba4 <z_impl_k_thread_start+0xd6>
		z_add_thread_to_ready_q(thread);
80003b9e:	854a                	mv	a0,s2
80003ba0:	990ff0ef          	jal	ra,80002d30 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80003ba4:	85a2                	mv	a1,s0
}
80003ba6:	4462                	lw	s0,24(sp)
80003ba8:	40f2                	lw	ra,28(sp)
80003baa:	4942                	lw	s2,16(sp)
80003bac:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003bae:	89848513          	addi	a0,s1,-1896
}
80003bb2:	44d2                	lw	s1,20(sp)
80003bb4:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003bb6:	c31fe06f          	j	800027e6 <z_reschedule>

80003bba <schedule_new_thread>:
	if (delay == 0) {
80003bba:	e199                	bnez	a1,80003bc0 <schedule_new_thread+0x6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80003bbc:	f13ff06f          	j	80003ace <z_impl_k_thread_start>
{
80003bc0:	1141                	addi	sp,sp,-16
80003bc2:	c422                	sw	s0,8(sp)
80003bc4:	842a                	mv	s0,a0
80003bc6:	852e                	mv	a0,a1
80003bc8:	0525                	addi	a0,a0,9
80003bca:	45a9                	li	a1,10
80003bcc:	c606                	sw	ra,12(sp)
80003bce:	d03fc0ef          	jal	ra,800008d0 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003bd2:	00150613          	addi	a2,a0,1
80003bd6:	01840513          	addi	a0,s0,24
}
80003bda:	4422                	lw	s0,8(sp)
80003bdc:	40b2                	lw	ra,12(sp)
80003bde:	800035b7          	lui	a1,0x80003
80003be2:	e7a58593          	addi	a1,a1,-390 # 80002e7a <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002e7b>
80003be6:	0141                	addi	sp,sp,16
80003be8:	ac55                	j	80003e9c <z_add_timeout>

80003bea <z_impl_k_thread_create>:
{
80003bea:	7139                	addi	sp,sp,-64
80003bec:	d256                	sw	s5,36(sp)
80003bee:	8ab6                	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003bf0:	800066b7          	lui	a3,0x80006
80003bf4:	b746a683          	lw	a3,-1164(a3) # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
{
80003bf8:	dc22                	sw	s0,56(sp)
80003bfa:	da26                	sw	s1,52(sp)
80003bfc:	d64e                	sw	s3,44(sp)
80003bfe:	d452                	sw	s4,40(sp)
80003c00:	de06                	sw	ra,60(sp)
80003c02:	d84a                	sw	s2,48(sp)
80003c04:	842a                	mv	s0,a0
80003c06:	89ae                	mv	s3,a1
80003c08:	8a32                	mv	s4,a2
80003c0a:	4496                	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003c0c:	c6a9                	beqz	a3,80003c56 <z_impl_k_thread_create+0x6c>
80003c0e:	80005937          	lui	s2,0x80005
80003c12:	800055b7          	lui	a1,0x80005
80003c16:	80005537          	lui	a0,0x80005
80003c1a:	1b200693          	li	a3,434
80003c1e:	66890613          	addi	a2,s2,1640 # 80005668 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005669>
80003c22:	4f858593          	addi	a1,a1,1272 # 800054f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054f9>
80003c26:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003c2a:	ce46                	sw	a7,28(sp)
80003c2c:	cc42                	sw	a6,24(sp)
80003c2e:	ca3e                	sw	a5,20(sp)
80003c30:	c83a                	sw	a4,16(sp)
80003c32:	d03fd0ef          	jal	ra,80001934 <printk>
80003c36:	80005537          	lui	a0,0x80005
80003c3a:	67c50513          	addi	a0,a0,1660 # 8000567c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000567d>
80003c3e:	cf7fd0ef          	jal	ra,80001934 <printk>
80003c42:	1b200593          	li	a1,434
80003c46:	66890513          	addi	a0,s2,1640
80003c4a:	d09fd0ef          	jal	ra,80001952 <assert_post_action>
80003c4e:	48f2                	lw	a7,28(sp)
80003c50:	4862                	lw	a6,24(sp)
80003c52:	47d2                	lw	a5,20(sp)
80003c54:	4742                	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003c56:	4686                	lw	a3,64(sp)
80003c58:	c202                	sw	zero,4(sp)
80003c5a:	8652                	mv	a2,s4
80003c5c:	c036                	sw	a3,0(sp)
80003c5e:	85ce                	mv	a1,s3
80003c60:	86d6                	mv	a3,s5
80003c62:	8522                	mv	a0,s0
80003c64:	d93ff0ef          	jal	ra,800039f6 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80003c68:	57fd                	li	a5,-1
80003c6a:	00f48663          	beq	s1,a5,80003c76 <z_impl_k_thread_create+0x8c>
		schedule_new_thread(new_thread, delay);
80003c6e:	85a6                	mv	a1,s1
80003c70:	8522                	mv	a0,s0
80003c72:	f49ff0ef          	jal	ra,80003bba <schedule_new_thread>
}
80003c76:	8522                	mv	a0,s0
80003c78:	50f2                	lw	ra,60(sp)
80003c7a:	5462                	lw	s0,56(sp)
80003c7c:	54d2                	lw	s1,52(sp)
80003c7e:	5942                	lw	s2,48(sp)
80003c80:	59b2                	lw	s3,44(sp)
80003c82:	5a22                	lw	s4,40(sp)
80003c84:	5a92                	lw	s5,36(sp)
80003c86:	6121                	addi	sp,sp,64
80003c88:	8082                	ret

80003c8a <z_init_static_threads>:
{
80003c8a:	1101                	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80003c8c:	800067b7          	lui	a5,0x80006
{
80003c90:	c84a                	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80003c92:	80006937          	lui	s2,0x80006
{
80003c96:	cc22                	sw	s0,24(sp)
80003c98:	ca26                	sw	s1,20(sp)
80003c9a:	ce06                	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80003c9c:	81078413          	addi	s0,a5,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
80003ca0:	81078493          	addi	s1,a5,-2032
80003ca4:	81090913          	addi	s2,s2,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
80003ca8:	01246f63          	bltu	s0,s2,80003cc6 <z_init_static_threads+0x3c>
	_FOREACH_STATIC_THREAD(thread_data) {
80003cac:	8426                	mv	s0,s1
	k_sched_lock();
80003cae:	c09fe0ef          	jal	ra,800028b6 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80003cb2:	54fd                	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80003cb4:	03246e63          	bltu	s0,s2,80003cf0 <z_init_static_threads+0x66>
}
80003cb8:	4462                	lw	s0,24(sp)
80003cba:	40f2                	lw	ra,28(sp)
80003cbc:	44d2                	lw	s1,20(sp)
80003cbe:	4942                	lw	s2,16(sp)
80003cc0:	6105                	addi	sp,sp,32
	k_sched_unlock();
80003cc2:	f1bfe06f          	j	80002bdc <k_sched_unlock>
		z_setup_new_thread(
80003cc6:	545c                	lw	a5,44(s0)
80003cc8:	c23e                	sw	a5,4(sp)
80003cca:	501c                	lw	a5,32(s0)
80003ccc:	c03e                	sw	a5,0(sp)
80003cce:	485c                	lw	a5,20(s0)
80003cd0:	01c42883          	lw	a7,28(s0)
80003cd4:	01842803          	lw	a6,24(s0)
80003cd8:	4818                	lw	a4,16(s0)
80003cda:	4454                	lw	a3,12(s0)
80003cdc:	4410                	lw	a2,8(s0)
80003cde:	404c                	lw	a1,4(s0)
80003ce0:	4008                	lw	a0,0(s0)
80003ce2:	d15ff0ef          	jal	ra,800039f6 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80003ce6:	401c                	lw	a5,0(s0)
80003ce8:	cfe0                	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80003cea:	03040413          	addi	s0,s0,48
80003cee:	bf6d                	j	80003ca8 <z_init_static_threads+0x1e>
		if (thread_data->init_delay != K_FOREVER) {
80003cf0:	504c                	lw	a1,36(s0)
80003cf2:	00958563          	beq	a1,s1,80003cfc <z_init_static_threads+0x72>
			schedule_new_thread(thread_data->init_thread,
80003cf6:	4008                	lw	a0,0(s0)
80003cf8:	ec3ff0ef          	jal	ra,80003bba <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80003cfc:	03040413          	addi	s0,s0,48
80003d00:	bf55                	j	80003cb4 <z_init_static_threads+0x2a>

80003d02 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80003d02:	1101                	addi	sp,sp,-32
80003d04:	cc22                	sw	s0,24(sp)
80003d06:	ca26                	sw	s1,20(sp)
80003d08:	ce06                	sw	ra,28(sp)
80003d0a:	c84a                	sw	s2,16(sp)
80003d0c:	84aa                	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80003d0e:	c602                	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d10:	4421                	li	s0,8
80003d12:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d16:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80003d18:	8821                	andi	s0,s0,8
80003d1a:	d65ff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
80003d1e:	ed0d                	bnez	a0,80003d58 <z_impl_k_thread_abort+0x56>
80003d20:	80005937          	lui	s2,0x80005
80003d24:	800055b7          	lui	a1,0x80005
80003d28:	80005537          	lui	a0,0x80005
80003d2c:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80003d30:	04e00693          	li	a3,78
80003d34:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80003d38:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003d3c:	bf9fd0ef          	jal	ra,80001934 <printk>
80003d40:	80005537          	lui	a0,0x80005
80003d44:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80003d48:	bedfd0ef          	jal	ra,80001934 <printk>
80003d4c:	04e00593          	li	a1,78
80003d50:	2e890513          	addi	a0,s2,744
80003d54:	bfffd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d58:	0068                	addi	a0,sp,12
80003d5a:	d61ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80003d5e:	00c4c783          	lbu	a5,12(s1)
80003d62:	8b85                	andi	a5,a5,1
80003d64:	cf8d                	beqz	a5,80003d9e <z_impl_k_thread_abort+0x9c>
80003d66:	80005937          	lui	s2,0x80005
80003d6a:	800055b7          	lui	a1,0x80005
80003d6e:	80005537          	lui	a0,0x80005
80003d72:	6bc58593          	addi	a1,a1,1724 # 800056bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056bd>
80003d76:	02900693          	li	a3,41
80003d7a:	6a490613          	addi	a2,s2,1700 # 800056a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056a5>
80003d7e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003d82:	bb3fd0ef          	jal	ra,80001934 <printk>
80003d86:	80005537          	lui	a0,0x80005
80003d8a:	6f050513          	addi	a0,a0,1776 # 800056f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056f1>
80003d8e:	ba7fd0ef          	jal	ra,80001934 <printk>
80003d92:	02900593          	li	a1,41
80003d96:	6a490513          	addi	a0,s2,1700
80003d9a:	bb9fd0ef          	jal	ra,80001952 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80003d9e:	8526                	mv	a0,s1
80003da0:	c7bff0ef          	jal	ra,80003a1a <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80003da4:	85a2                	mv	a1,s0
80003da6:	0068                	addi	a0,sp,12
80003da8:	a3ffe0ef          	jal	ra,800027e6 <z_reschedule>
}
80003dac:	40f2                	lw	ra,28(sp)
80003dae:	4462                	lw	s0,24(sp)
80003db0:	44d2                	lw	s1,20(sp)
80003db2:	4942                	lw	s2,16(sp)
80003db4:	6105                	addi	sp,sp,32
80003db6:	8082                	ret

80003db8 <k_work_q_start>:

extern void z_work_q_main(void *work_q_ptr, void *p2, void *p3);

void k_work_q_start(struct k_work_q *work_q, k_thread_stack_t *stack,
		    size_t stack_size, int prio)
{
80003db8:	7179                	addi	sp,sp,-48
80003dba:	d606                	sw	ra,44(sp)
80003dbc:	d422                	sw	s0,40(sp)
80003dbe:	ce2a                	sw	a0,28(sp)
80003dc0:	cc2e                	sw	a1,24(sp)
80003dc2:	ca32                	sw	a2,20(sp)
80003dc4:	c836                	sw	a3,16(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80003dc6:	e94fe0ef          	jal	ra,8000245a <z_impl_k_queue_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80003dca:	46c2                	lw	a3,16(sp)
	k_queue_init(&work_q->queue);
	(void)k_thread_create(&work_q->thread, stack, stack_size, z_work_q_main,
80003dcc:	4772                	lw	a4,28(sp)
80003dce:	45e2                	lw	a1,24(sp)
80003dd0:	4652                	lw	a2,20(sp)
80003dd2:	01470413          	addi	s0,a4,20
80003dd6:	88b6                	mv	a7,a3
80003dd8:	800016b7          	lui	a3,0x80001
80003ddc:	c202                	sw	zero,4(sp)
80003dde:	c002                	sw	zero,0(sp)
80003de0:	8522                	mv	a0,s0
80003de2:	4801                	li	a6,0
80003de4:	4781                	li	a5,0
80003de6:	4cc68693          	addi	a3,a3,1228 # 800014cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800014cd>
80003dea:	e01ff0ef          	jal	ra,80003bea <z_impl_k_thread_create>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_NAME_SET, k_thread_name_set, k_tid_t, thread_id, const char *, value)
80003dee:	8522                	mv	a0,s0
			work_q, NULL, NULL, prio, 0, 0);

	k_thread_name_set(&work_q->thread, WORKQUEUE_THREAD_NAME);
}
80003df0:	5422                	lw	s0,40(sp)
80003df2:	50b2                	lw	ra,44(sp)
80003df4:	800055b7          	lui	a1,0x80005
80003df8:	70c58593          	addi	a1,a1,1804 # 8000570c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000570d>
80003dfc:	6145                	addi	sp,sp,48
80003dfe:	bf7ff06f          	j	800039f4 <z_impl_k_thread_name_set>

80003e02 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80003e02:	800067b7          	lui	a5,0x80006
80003e06:	89c7a783          	lw	a5,-1892(a5) # 8000589c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000589d>
80003e0a:	e399                	bnez	a5,80003e10 <elapsed+0xe>
80003e0c:	ea3fd06f          	j	80001cae <z_clock_elapsed>
}
80003e10:	4501                	li	a0,0
80003e12:	8082                	ret

80003e14 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80003e14:	411c                	lw	a5,0(a0)
80003e16:	cd01                	beqz	a0,80003e2e <remove_timeout+0x1a>
80003e18:	80005737          	lui	a4,0x80005
	return (node == list->tail) ? NULL : node->next;
80003e1c:	7d472703          	lw	a4,2004(a4) # 800057d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d5>
80003e20:	00e50763          	beq	a0,a4,80003e2e <remove_timeout+0x1a>
	if (next(t) != NULL) {
80003e24:	c789                	beqz	a5,80003e2e <remove_timeout+0x1a>
		next(t)->dticks += t->dticks;
80003e26:	4798                	lw	a4,8(a5)
80003e28:	4514                	lw	a3,8(a0)
80003e2a:	9736                	add	a4,a4,a3
80003e2c:	c798                	sw	a4,8(a5)
	node->prev->next = node->next;
80003e2e:	4158                	lw	a4,4(a0)
80003e30:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80003e32:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80003e34:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80003e38:	00052223          	sw	zero,4(a0)
}
80003e3c:	8082                	ret

80003e3e <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80003e3e:	800067b7          	lui	a5,0x80006
80003e42:	8ac7c783          	lbu	a5,-1876(a5) # 800058ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058ad>
{
80003e46:	1141                	addi	sp,sp,-16
80003e48:	c606                	sw	ra,12(sp)
80003e4a:	c422                	sw	s0,8(sp)
80003e4c:	c226                	sw	s1,4(sp)
80003e4e:	557d                	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80003e50:	e789                	bnez	a5,80003e5a <next_timeout+0x1c>
80003e52:	80000537          	lui	a0,0x80000
80003e56:	fff54513          	not	a0,a0
	return list->head == list;
80003e5a:	800057b7          	lui	a5,0x80005
80003e5e:	7d078793          	addi	a5,a5,2000 # 800057d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d1>
80003e62:	4380                	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003e64:	00f40f63          	beq	s0,a5,80003e82 <next_timeout+0x44>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80003e68:	cc09                	beqz	s0,80003e82 <next_timeout+0x44>
80003e6a:	4404                	lw	s1,8(s0)
80003e6c:	f97ff0ef          	jal	ra,80003e02 <elapsed>
80003e70:	8c89                	sub	s1,s1,a0
80003e72:	4501                	li	a0,0
80003e74:	0004c763          	bltz	s1,80003e82 <next_timeout+0x44>
80003e78:	4400                	lw	s0,8(s0)
80003e7a:	f89ff0ef          	jal	ra,80003e02 <elapsed>
80003e7e:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80003e82:	800067b7          	lui	a5,0x80006
80003e86:	b847a783          	lw	a5,-1148(a5) # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
80003e8a:	c781                	beqz	a5,80003e92 <next_timeout+0x54>
80003e8c:	00a7d363          	bge	a5,a0,80003e92 <next_timeout+0x54>
80003e90:	853e                	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80003e92:	40b2                	lw	ra,12(sp)
80003e94:	4422                	lw	s0,8(sp)
80003e96:	4492                	lw	s1,4(sp)
80003e98:	0141                	addi	sp,sp,16
80003e9a:	8082                	ret

80003e9c <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003e9c:	411c                	lw	a5,0(a0)
{
80003e9e:	7179                	addi	sp,sp,-48
80003ea0:	d422                	sw	s0,40(sp)
80003ea2:	d226                	sw	s1,36(sp)
80003ea4:	ce4e                	sw	s3,28(sp)
80003ea6:	d606                	sw	ra,44(sp)
80003ea8:	d04a                	sw	s2,32(sp)
80003eaa:	cc52                	sw	s4,24(sp)
80003eac:	ca56                	sw	s5,20(sp)
80003eae:	c85a                	sw	s6,16(sp)
80003eb0:	c65e                	sw	s7,12(sp)
80003eb2:	c462                	sw	s8,8(sp)
80003eb4:	842a                	mv	s0,a0
80003eb6:	89ae                	mv	s3,a1
80003eb8:	84b2                	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003eba:	cf8d                	beqz	a5,80003ef4 <z_add_timeout+0x58>
80003ebc:	80005937          	lui	s2,0x80005
80003ec0:	800055b7          	lui	a1,0x80005
80003ec4:	80005537          	lui	a0,0x80005
80003ec8:	72c58593          	addi	a1,a1,1836 # 8000572c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000572d>
80003ecc:	04d00693          	li	a3,77
80003ed0:	71890613          	addi	a2,s2,1816 # 80005718 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005719>
80003ed4:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003ed8:	a5dfd0ef          	jal	ra,80001934 <printk>
80003edc:	80005537          	lui	a0,0x80005
80003ee0:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
80003ee4:	a51fd0ef          	jal	ra,80001934 <printk>
80003ee8:	04d00593          	li	a1,77
80003eec:	71890513          	addi	a0,s2,1816
80003ef0:	a63fd0ef          	jal	ra,80001952 <assert_post_action>
	to->fn = fn;
80003ef4:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80003ef8:	00904363          	bgtz	s1,80003efe <z_add_timeout+0x62>
80003efc:	4485                	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003efe:	49a1                	li	s3,8
80003f00:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f04:	80006a37          	lui	s4,0x80006
80003f08:	8a0a0513          	addi	a0,s4,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f0c:	0089f993          	andi	s3,s3,8
80003f10:	b6fff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
80003f14:	ed0d                	bnez	a0,80003f4e <z_add_timeout+0xb2>
80003f16:	80005937          	lui	s2,0x80005
80003f1a:	800055b7          	lui	a1,0x80005
80003f1e:	80005537          	lui	a0,0x80005
80003f22:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80003f26:	04e00693          	li	a3,78
80003f2a:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80003f2e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003f32:	a03fd0ef          	jal	ra,80001934 <printk>
80003f36:	80005537          	lui	a0,0x80005
80003f3a:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80003f3e:	9f7fd0ef          	jal	ra,80001934 <printk>
80003f42:	04e00593          	li	a1,78
80003f46:	2e890513          	addi	a0,s2,744
80003f4a:	a09fd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80003f4e:	8a0a0513          	addi	a0,s4,-1888
80003f52:	b69ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80003f56:	eadff0ef          	jal	ra,80003e02 <elapsed>
80003f5a:	9526                	add	a0,a0,s1
	return list->head == list;
80003f5c:	800054b7          	lui	s1,0x80005
80003f60:	7d04a903          	lw	s2,2000(s1) # 800057d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d1>
80003f64:	c408                	sw	a0,8(s0)
80003f66:	7d048493          	addi	s1,s1,2000
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003f6a:	00990c63          	beq	s2,s1,80003f82 <z_add_timeout+0xe6>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80003f6e:	80005ab7          	lui	s5,0x80005
80003f72:	80005b37          	lui	s6,0x80005
80003f76:	80005bb7          	lui	s7,0x80005
80003f7a:	80005c37          	lui	s8,0x80005
		for (t = first(); t != NULL; t = next(t)) {
80003f7e:	00091963          	bnez	s2,80003f90 <z_add_timeout+0xf4>
	node->prev = list->tail;
80003f82:	40dc                	lw	a5,4(s1)
	node->next = list;
80003f84:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80003f86:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80003f88:	40dc                	lw	a5,4(s1)
80003f8a:	c380                	sw	s0,0(a5)
	list->tail = node;
80003f8c:	c0c0                	sw	s0,4(s1)
80003f8e:	a891                	j	80003fe2 <z_add_timeout+0x146>
			__ASSERT(t->dticks >= 0, "");
80003f90:	00892783          	lw	a5,8(s2)
80003f94:	0207d663          	bgez	a5,80003fc0 <z_add_timeout+0x124>
80003f98:	74cb0593          	addi	a1,s6,1868 # 8000574c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000574d>
80003f9c:	05600693          	li	a3,86
80003fa0:	718a8613          	addi	a2,s5,1816 # 80005718 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005719>
80003fa4:	21cb8513          	addi	a0,s7,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80003fa8:	98dfd0ef          	jal	ra,80001934 <printk>
80003fac:	2a0c0513          	addi	a0,s8,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
80003fb0:	985fd0ef          	jal	ra,80001934 <printk>
80003fb4:	05600593          	li	a1,86
80003fb8:	718a8513          	addi	a0,s5,1816
80003fbc:	997fd0ef          	jal	ra,80001952 <assert_post_action>

			if (t->dticks > to->dticks) {
80003fc0:	00892703          	lw	a4,8(s2)
80003fc4:	441c                	lw	a5,8(s0)
80003fc6:	08e7d763          	bge	a5,a4,80004054 <z_add_timeout+0x1b8>
				t->dticks -= to->dticks;
80003fca:	40f707b3          	sub	a5,a4,a5
80003fce:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80003fd2:	00492783          	lw	a5,4(s2)
	node->next = successor;
80003fd6:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80003fda:	c05c                	sw	a5,4(s0)
	successor->prev->next = node;
80003fdc:	c380                	sw	s0,0(a5)
	successor->prev = node;
80003fde:	00892223          	sw	s0,4(s2)
	return list->head == list;
80003fe2:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003fe4:	00978963          	beq	a5,s1,80003ff6 <z_add_timeout+0x15a>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80003fe8:	00f41763          	bne	s0,a5,80003ff6 <z_add_timeout+0x15a>
			z_clock_set_timeout(next_timeout(), false);
80003fec:	e53ff0ef          	jal	ra,80003e3e <next_timeout>
80003ff0:	4581                	li	a1,0
80003ff2:	b71fd0ef          	jal	ra,80001b62 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ff6:	8a0a0513          	addi	a0,s4,-1888
80003ffa:	a9fff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80003ffe:	ed0d                	bnez	a0,80004038 <z_add_timeout+0x19c>
80004000:	80005437          	lui	s0,0x80005
80004004:	800055b7          	lui	a1,0x80005
80004008:	80005537          	lui	a0,0x80005
8000400c:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80004010:	06100693          	li	a3,97
80004014:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80004018:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000401c:	919fd0ef          	jal	ra,80001934 <printk>
80004020:	80005537          	lui	a0,0x80005
80004024:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80004028:	90dfd0ef          	jal	ra,80001934 <printk>
8000402c:	06100593          	li	a1,97
80004030:	2e840513          	addi	a0,s0,744
80004034:	91ffd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004038:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
8000403c:	50b2                	lw	ra,44(sp)
8000403e:	5422                	lw	s0,40(sp)
80004040:	5492                	lw	s1,36(sp)
80004042:	5902                	lw	s2,32(sp)
80004044:	49f2                	lw	s3,28(sp)
80004046:	4a62                	lw	s4,24(sp)
80004048:	4ad2                	lw	s5,20(sp)
8000404a:	4b42                	lw	s6,16(sp)
8000404c:	4bb2                	lw	s7,12(sp)
8000404e:	4c22                	lw	s8,8(sp)
80004050:	6145                	addi	sp,sp,48
80004052:	8082                	ret
			to->dticks -= t->dticks;
80004054:	8f99                	sub	a5,a5,a4
80004056:	c41c                	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80004058:	40dc                	lw	a5,4(s1)
8000405a:	f32784e3          	beq	a5,s2,80003f82 <z_add_timeout+0xe6>
8000405e:	00092903          	lw	s2,0(s2)
80004062:	bf31                	j	80003f7e <z_add_timeout+0xe2>

80004064 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004064:	1101                	addi	sp,sp,-32
80004066:	cc22                	sw	s0,24(sp)
80004068:	c64e                	sw	s3,12(sp)
8000406a:	ce06                	sw	ra,28(sp)
8000406c:	ca26                	sw	s1,20(sp)
8000406e:	c84a                	sw	s2,16(sp)
80004070:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004072:	4421                	li	s0,8
80004074:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004078:	800064b7          	lui	s1,0x80006
8000407c:	8a048513          	addi	a0,s1,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004080:	8821                	andi	s0,s0,8
80004082:	9fdff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
80004086:	ed0d                	bnez	a0,800040c0 <z_abort_timeout+0x5c>
80004088:	80005937          	lui	s2,0x80005
8000408c:	800055b7          	lui	a1,0x80005
80004090:	80005537          	lui	a0,0x80005
80004094:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80004098:	04e00693          	li	a3,78
8000409c:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800040a0:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800040a4:	891fd0ef          	jal	ra,80001934 <printk>
800040a8:	80005537          	lui	a0,0x80005
800040ac:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
800040b0:	885fd0ef          	jal	ra,80001934 <printk>
800040b4:	04e00593          	li	a1,78
800040b8:	2e890513          	addi	a0,s2,744
800040bc:	897fd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
800040c0:	8a048513          	addi	a0,s1,-1888
800040c4:	9f7ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
800040c8:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
800040cc:	5929                	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
800040ce:	c789                	beqz	a5,800040d8 <z_abort_timeout+0x74>
			remove_timeout(to);
800040d0:	854e                	mv	a0,s3
800040d2:	d43ff0ef          	jal	ra,80003e14 <remove_timeout>
			ret = 0;
800040d6:	4901                	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800040d8:	8a048513          	addi	a0,s1,-1888
800040dc:	9bdff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
800040e0:	ed0d                	bnez	a0,8000411a <z_abort_timeout+0xb6>
800040e2:	800054b7          	lui	s1,0x80005
800040e6:	800055b7          	lui	a1,0x80005
800040ea:	80005537          	lui	a0,0x80005
800040ee:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800040f2:	06100693          	li	a3,97
800040f6:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800040fa:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800040fe:	837fd0ef          	jal	ra,80001934 <printk>
80004102:	80005537          	lui	a0,0x80005
80004106:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000410a:	82bfd0ef          	jal	ra,80001934 <printk>
8000410e:	06100593          	li	a1,97
80004112:	2e848513          	addi	a0,s1,744
80004116:	83dfd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000411a:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
8000411e:	40f2                	lw	ra,28(sp)
80004120:	4462                	lw	s0,24(sp)
80004122:	854a                	mv	a0,s2
80004124:	44d2                	lw	s1,20(sp)
80004126:	4942                	lw	s2,16(sp)
80004128:	49b2                	lw	s3,12(sp)
8000412a:	6105                	addi	sp,sp,32
8000412c:	8082                	ret

8000412e <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
8000412e:	1141                	addi	sp,sp,-16
80004130:	c422                	sw	s0,8(sp)
80004132:	c606                	sw	ra,12(sp)
80004134:	c226                	sw	s1,4(sp)
80004136:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004138:	4421                	li	s0,8
8000413a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000413e:	800064b7          	lui	s1,0x80006
80004142:	8a048513          	addi	a0,s1,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004146:	8821                	andi	s0,s0,8
80004148:	937ff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
8000414c:	ed0d                	bnez	a0,80004186 <z_get_next_timeout_expiry+0x58>
8000414e:	80005937          	lui	s2,0x80005
80004152:	800055b7          	lui	a1,0x80005
80004156:	80005537          	lui	a0,0x80005
8000415a:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
8000415e:	04e00693          	li	a3,78
80004162:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80004166:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000416a:	fcafd0ef          	jal	ra,80001934 <printk>
8000416e:	80005537          	lui	a0,0x80005
80004172:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80004176:	fbefd0ef          	jal	ra,80001934 <printk>
8000417a:	04e00593          	li	a1,78
8000417e:	2e890513          	addi	a0,s2,744
80004182:	fd0fd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80004186:	8a048513          	addi	a0,s1,-1888
8000418a:	931ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
8000418e:	cb1ff0ef          	jal	ra,80003e3e <next_timeout>
80004192:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004194:	8a048513          	addi	a0,s1,-1888
80004198:	901ff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
8000419c:	ed0d                	bnez	a0,800041d6 <z_get_next_timeout_expiry+0xa8>
8000419e:	800054b7          	lui	s1,0x80005
800041a2:	800055b7          	lui	a1,0x80005
800041a6:	80005537          	lui	a0,0x80005
800041aa:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800041ae:	06100693          	li	a3,97
800041b2:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800041b6:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800041ba:	f7afd0ef          	jal	ra,80001934 <printk>
800041be:	80005537          	lui	a0,0x80005
800041c2:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800041c6:	f6efd0ef          	jal	ra,80001934 <printk>
800041ca:	06100593          	li	a1,97
800041ce:	2e848513          	addi	a0,s1,744
800041d2:	f80fd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800041d6:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800041da:	40b2                	lw	ra,12(sp)
800041dc:	4422                	lw	s0,8(sp)
800041de:	854a                	mv	a0,s2
800041e0:	4492                	lw	s1,4(sp)
800041e2:	4902                	lw	s2,0(sp)
800041e4:	0141                	addi	sp,sp,16
800041e6:	8082                	ret

800041e8 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
800041e8:	1101                	addi	sp,sp,-32
800041ea:	cc22                	sw	s0,24(sp)
800041ec:	c84a                	sw	s2,16(sp)
800041ee:	c452                	sw	s4,8(sp)
800041f0:	ce06                	sw	ra,28(sp)
800041f2:	ca26                	sw	s1,20(sp)
800041f4:	c64e                	sw	s3,12(sp)
800041f6:	892a                	mv	s2,a0
800041f8:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800041fa:	4421                	li	s0,8
800041fc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004200:	800064b7          	lui	s1,0x80006
80004204:	8a048513          	addi	a0,s1,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004208:	8821                	andi	s0,s0,8
8000420a:	875ff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
8000420e:	ed0d                	bnez	a0,80004248 <z_set_timeout_expiry+0x60>
80004210:	800059b7          	lui	s3,0x80005
80004214:	800055b7          	lui	a1,0x80005
80004218:	80005537          	lui	a0,0x80005
8000421c:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80004220:	04e00693          	li	a3,78
80004224:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80004228:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000422c:	f08fd0ef          	jal	ra,80001934 <printk>
80004230:	80005537          	lui	a0,0x80005
80004234:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80004238:	efcfd0ef          	jal	ra,80001934 <printk>
8000423c:	04e00593          	li	a1,78
80004240:	2e898513          	addi	a0,s3,744
80004244:	f0efd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80004248:	8a048513          	addi	a0,s1,-1888
8000424c:	86fff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004250:	befff0ef          	jal	ra,80003e3e <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80004254:	00a95963          	bge	s2,a0,80004266 <z_set_timeout_expiry+0x7e>
80004258:	4785                	li	a5,1
8000425a:	00a7d663          	bge	a5,a0,80004266 <z_set_timeout_expiry+0x7e>
			z_clock_set_timeout(ticks, idle);
8000425e:	85d2                	mv	a1,s4
80004260:	854a                	mv	a0,s2
80004262:	901fd0ef          	jal	ra,80001b62 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004266:	8a048513          	addi	a0,s1,-1888
8000426a:	82fff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
8000426e:	ed0d                	bnez	a0,800042a8 <z_set_timeout_expiry+0xc0>
80004270:	800054b7          	lui	s1,0x80005
80004274:	800055b7          	lui	a1,0x80005
80004278:	80005537          	lui	a0,0x80005
8000427c:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80004280:	06100693          	li	a3,97
80004284:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80004288:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000428c:	ea8fd0ef          	jal	ra,80001934 <printk>
80004290:	80005537          	lui	a0,0x80005
80004294:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80004298:	e9cfd0ef          	jal	ra,80001934 <printk>
8000429c:	06100593          	li	a1,97
800042a0:	2e848513          	addi	a0,s1,744
800042a4:	eaefd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042a8:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800042ac:	40f2                	lw	ra,28(sp)
800042ae:	4462                	lw	s0,24(sp)
800042b0:	44d2                	lw	s1,20(sp)
800042b2:	4942                	lw	s2,16(sp)
800042b4:	49b2                	lw	s3,12(sp)
800042b6:	4a22                	lw	s4,8(sp)
800042b8:	6105                	addi	sp,sp,32
800042ba:	8082                	ret

800042bc <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
800042bc:	7179                	addi	sp,sp,-48
800042be:	d422                	sw	s0,40(sp)
800042c0:	cc52                	sw	s4,24(sp)
800042c2:	d606                	sw	ra,44(sp)
800042c4:	d226                	sw	s1,36(sp)
800042c6:	d04a                	sw	s2,32(sp)
800042c8:	ce4e                	sw	s3,28(sp)
800042ca:	ca56                	sw	s5,20(sp)
800042cc:	c85a                	sw	s6,16(sp)
800042ce:	c65e                	sw	s7,12(sp)
800042d0:	c462                	sw	s8,8(sp)
800042d2:	c266                	sw	s9,4(sp)
800042d4:	c06a                	sw	s10,0(sp)
800042d6:	8a2a                	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800042d8:	4421                	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
800042da:	e0ffe0ef          	jal	ra,800030e8 <z_time_slice>
800042de:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800042e2:	80006937          	lui	s2,0x80006
800042e6:	8a090513          	addi	a0,s2,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
	key = (mstatus & SOC_MSTATUS_IEN);
800042ea:	8821                	andi	s0,s0,8
800042ec:	f92ff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
800042f0:	ed0d                	bnez	a0,8000432a <z_clock_announce+0x6e>
800042f2:	800054b7          	lui	s1,0x80005
800042f6:	800055b7          	lui	a1,0x80005
800042fa:	80005537          	lui	a0,0x80005
800042fe:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80004302:	04e00693          	li	a3,78
80004306:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000430a:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000430e:	e26fd0ef          	jal	ra,80001934 <printk>
80004312:	80005537          	lui	a0,0x80005
80004316:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
8000431a:	e1afd0ef          	jal	ra,80001934 <printk>
8000431e:	04e00593          	li	a1,78
80004322:	2e848513          	addi	a0,s1,744
80004326:	e2cfd0ef          	jal	ra,80001952 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
8000432a:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
8000432e:	8a090513          	addi	a0,s2,-1888
80004332:	f88ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
80004336:	800064b7          	lui	s1,0x80006
8000433a:	8949ae23          	sw	s4,-1892(s3) # 8000589c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000589d>
	return list->head == list;
8000433e:	80005a37          	lui	s4,0x80005
80004342:	89c98993          	addi	s3,s3,-1892
80004346:	7d0a0a13          	addi	s4,s4,2000 # 800057d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d1>
8000434a:	86048493          	addi	s1,s1,-1952 # 80005860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005861>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000434e:	80005ab7          	lui	s5,0x80005
80004352:	80005bb7          	lui	s7,0x80005
80004356:	80005b37          	lui	s6,0x80005
8000435a:	80005c37          	lui	s8,0x80005
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000435e:	80005cb7          	lui	s9,0x80005
80004362:	000a2d03          	lw	s10,0(s4)
80004366:	0009a783          	lw	a5,0(s3)
8000436a:	4094                	lw	a3,0(s1)
8000436c:	40c8                	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000436e:	014d0b63          	beq	s10,s4,80004384 <z_clock_announce+0xc8>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80004372:	000d0963          	beqz	s10,80004384 <z_clock_announce+0xc8>
80004376:	008d2703          	lw	a4,8(s10)
8000437a:	08e7d663          	bge	a5,a4,80004406 <z_clock_announce+0x14a>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
8000437e:	8f1d                	sub	a4,a4,a5
80004380:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80004384:	96be                	add	a3,a3,a5
80004386:	41f7d713          	srai	a4,a5,0x1f
8000438a:	972a                	add	a4,a4,a0
8000438c:	00f6b7b3          	sltu	a5,a3,a5
80004390:	97ba                	add	a5,a5,a4
80004392:	c094                	sw	a3,0(s1)
80004394:	c0dc                	sw	a5,4(s1)
	announce_remaining = 0;
80004396:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
8000439a:	aa5ff0ef          	jal	ra,80003e3e <next_timeout>
8000439e:	4581                	li	a1,0
800043a0:	fc2fd0ef          	jal	ra,80001b62 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800043a4:	8a090513          	addi	a0,s2,-1888
800043a8:	ef0ff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
800043ac:	ed0d                	bnez	a0,800043e6 <z_clock_announce+0x12a>
800043ae:	800054b7          	lui	s1,0x80005
800043b2:	800055b7          	lui	a1,0x80005
800043b6:	80005537          	lui	a0,0x80005
800043ba:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800043be:	06100693          	li	a3,97
800043c2:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800043c6:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800043ca:	d6afd0ef          	jal	ra,80001934 <printk>
800043ce:	80005537          	lui	a0,0x80005
800043d2:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
800043d6:	d5efd0ef          	jal	ra,80001934 <printk>
800043da:	06100593          	li	a1,97
800043de:	2e848513          	addi	a0,s1,744
800043e2:	d70fd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800043e6:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800043ea:	50b2                	lw	ra,44(sp)
800043ec:	5422                	lw	s0,40(sp)
800043ee:	5492                	lw	s1,36(sp)
800043f0:	5902                	lw	s2,32(sp)
800043f2:	49f2                	lw	s3,28(sp)
800043f4:	4a62                	lw	s4,24(sp)
800043f6:	4ad2                	lw	s5,20(sp)
800043f8:	4b42                	lw	s6,16(sp)
800043fa:	4bb2                	lw	s7,12(sp)
800043fc:	4c22                	lw	s8,8(sp)
800043fe:	4c92                	lw	s9,4(sp)
80004400:	4d02                	lw	s10,0(sp)
80004402:	6145                	addi	sp,sp,48
80004404:	8082                	ret
		curr_tick += dt;
80004406:	96ba                	add	a3,a3,a4
80004408:	41f75593          	srai	a1,a4,0x1f
8000440c:	95aa                	add	a1,a1,a0
8000440e:	00e6b633          	sltu	a2,a3,a4
80004412:	962e                	add	a2,a2,a1
		announce_remaining -= dt;
80004414:	8f99                	sub	a5,a5,a4
		remove_timeout(t);
80004416:	856a                	mv	a0,s10
		t->dticks = 0;
80004418:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
8000441c:	c094                	sw	a3,0(s1)
8000441e:	c0d0                	sw	a2,4(s1)
		announce_remaining -= dt;
80004420:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80004424:	9f1ff0ef          	jal	ra,80003e14 <remove_timeout>
80004428:	8a090513          	addi	a0,s2,-1888
8000442c:	e6cff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80004430:	e50d                	bnez	a0,8000445a <z_clock_announce+0x19e>
80004432:	330b8593          	addi	a1,s7,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80004436:	06100693          	li	a3,97
8000443a:	2e8a8613          	addi	a2,s5,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000443e:	21cb0513          	addi	a0,s6,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80004442:	cf2fd0ef          	jal	ra,80001934 <printk>
80004446:	348c0513          	addi	a0,s8,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000444a:	ceafd0ef          	jal	ra,80001934 <printk>
8000444e:	06100593          	li	a1,97
80004452:	2e8a8513          	addi	a0,s5,744
80004456:	cfcfd0ef          	jal	ra,80001952 <assert_post_action>
8000445a:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
8000445e:	00cd2783          	lw	a5,12(s10)
80004462:	856a                	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004464:	4421                	li	s0,8
80004466:	9782                	jalr	a5
80004468:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000446c:	8a090513          	addi	a0,s2,-1888
	key = (mstatus & SOC_MSTATUS_IEN);
80004470:	8821                	andi	s0,s0,8
80004472:	e0cff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
80004476:	e51d                	bnez	a0,800044a4 <z_clock_announce+0x1e8>
80004478:	300c8593          	addi	a1,s9,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
8000447c:	04e00693          	li	a3,78
80004480:	2e8a8613          	addi	a2,s5,744
80004484:	21cb0513          	addi	a0,s6,540
80004488:	cacfd0ef          	jal	ra,80001934 <printk>
8000448c:	80005537          	lui	a0,0x80005
80004490:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80004494:	ca0fd0ef          	jal	ra,80001934 <printk>
80004498:	04e00593          	li	a1,78
8000449c:	2e8a8513          	addi	a0,s5,744
800044a0:	cb2fd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
800044a4:	8a090513          	addi	a0,s2,-1888
800044a8:	e12ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	return k;
800044ac:	bd5d                	j	80004362 <z_clock_announce+0xa6>

800044ae <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
800044ae:	1101                	addi	sp,sp,-32
800044b0:	ca26                	sw	s1,20(sp)
800044b2:	ce06                	sw	ra,28(sp)
800044b4:	cc22                	sw	s0,24(sp)
800044b6:	c84a                	sw	s2,16(sp)
800044b8:	c64e                	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800044ba:	44a1                	li	s1,8
800044bc:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800044c0:	80006937          	lui	s2,0x80006
800044c4:	8a090513          	addi	a0,s2,-1888 # 800058a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a1>
	key = (mstatus & SOC_MSTATUS_IEN);
800044c8:	88a1                	andi	s1,s1,8
800044ca:	db4ff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
800044ce:	ed0d                	bnez	a0,80004508 <z_tick_get+0x5a>
800044d0:	80005437          	lui	s0,0x80005
800044d4:	800055b7          	lui	a1,0x80005
800044d8:	80005537          	lui	a0,0x80005
800044dc:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800044e0:	04e00693          	li	a3,78
800044e4:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800044e8:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800044ec:	c48fd0ef          	jal	ra,80001934 <printk>
800044f0:	80005537          	lui	a0,0x80005
800044f4:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
800044f8:	c3cfd0ef          	jal	ra,80001934 <printk>
800044fc:	04e00593          	li	a1,78
80004500:	2e840513          	addi	a0,s0,744
80004504:	c4efd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80004508:	8a090513          	addi	a0,s2,-1888
8000450c:	daeff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80004510:	f9efd0ef          	jal	ra,80001cae <z_clock_elapsed>
80004514:	800067b7          	lui	a5,0x80006
80004518:	86078793          	addi	a5,a5,-1952 # 80005860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005861>
8000451c:	0007a983          	lw	s3,0(a5)
80004520:	43c0                	lw	s0,4(a5)
80004522:	99aa                	add	s3,s3,a0
80004524:	00a9b533          	sltu	a0,s3,a0
80004528:	942a                	add	s0,s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000452a:	8a090513          	addi	a0,s2,-1888
8000452e:	d6aff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80004532:	ed0d                	bnez	a0,8000456c <z_tick_get+0xbe>
80004534:	80005937          	lui	s2,0x80005
80004538:	800055b7          	lui	a1,0x80005
8000453c:	80005537          	lui	a0,0x80005
80004540:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80004544:	06100693          	li	a3,97
80004548:	2e890613          	addi	a2,s2,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000454c:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80004550:	be4fd0ef          	jal	ra,80001934 <printk>
80004554:	80005537          	lui	a0,0x80005
80004558:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000455c:	bd8fd0ef          	jal	ra,80001934 <printk>
80004560:	06100593          	li	a1,97
80004564:	2e890513          	addi	a0,s2,744
80004568:	beafd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000456c:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80004570:	85a2                	mv	a1,s0
80004572:	40f2                	lw	ra,28(sp)
80004574:	4462                	lw	s0,24(sp)
80004576:	854e                	mv	a0,s3
80004578:	44d2                	lw	s1,20(sp)
8000457a:	4942                	lw	s2,16(sp)
8000457c:	49b2                	lw	s3,12(sp)
8000457e:	6105                	addi	sp,sp,32
80004580:	8082                	ret

80004582 <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
80004582:	1141                	addi	sp,sp,-16
80004584:	c606                	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
80004586:	f29ff0ef          	jal	ra,800044ae <z_tick_get>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000458a:	3e800613          	li	a2,1000
8000458e:	4681                	li	a3,0
80004590:	ab0fc0ef          	jal	ra,80000840 <__muldi3>
80004594:	06400613          	li	a2,100
80004598:	4681                	li	a3,0
8000459a:	caffb0ef          	jal	ra,80000248 <__udivdi3>
}
8000459e:	40b2                	lw	ra,12(sp)
800045a0:	0141                	addi	sp,sp,16
800045a2:	8082                	ret

800045a4 <z_impl_atomic_or>:
 * @param value the value to OR
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_or(atomic_t *target, atomic_val_t value)
{
800045a4:	1101                	addi	sp,sp,-32
800045a6:	cc22                	sw	s0,24(sp)
800045a8:	c84a                	sw	s2,16(sp)
800045aa:	c452                	sw	s4,8(sp)
800045ac:	ce06                	sw	ra,28(sp)
800045ae:	ca26                	sw	s1,20(sp)
800045b0:	c64e                	sw	s3,12(sp)
800045b2:	8a2a                	mv	s4,a0
800045b4:	892e                	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800045b6:	4421                	li	s0,8
800045b8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800045bc:	800064b7          	lui	s1,0x80006
800045c0:	8a448513          	addi	a0,s1,-1884 # 800058a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a5>
	key = (mstatus & SOC_MSTATUS_IEN);
800045c4:	8821                	andi	s0,s0,8
800045c6:	cb8ff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
800045ca:	ed0d                	bnez	a0,80004604 <z_impl_atomic_or+0x60>
800045cc:	800059b7          	lui	s3,0x80005
800045d0:	800055b7          	lui	a1,0x80005
800045d4:	80005537          	lui	a0,0x80005
800045d8:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800045dc:	04e00693          	li	a3,78
800045e0:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800045e4:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800045e8:	b4cfd0ef          	jal	ra,80001934 <printk>
800045ec:	80005537          	lui	a0,0x80005
800045f0:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
800045f4:	b40fd0ef          	jal	ra,80001934 <printk>
800045f8:	04e00593          	li	a1,78
800045fc:	2e898513          	addi	a0,s3,744
80004600:	b52fd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80004604:	8a448513          	addi	a0,s1,-1884
80004608:	cb2ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
8000460c:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004610:	8a448513          	addi	a0,s1,-1884
	*target |= value;
80004614:	0129e933          	or	s2,s3,s2
80004618:	012a2023          	sw	s2,0(s4)
8000461c:	c7cff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80004620:	ed0d                	bnez	a0,8000465a <z_impl_atomic_or+0xb6>
80004622:	800054b7          	lui	s1,0x80005
80004626:	800055b7          	lui	a1,0x80005
8000462a:	80005537          	lui	a0,0x80005
8000462e:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80004632:	06100693          	li	a3,97
80004636:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000463a:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000463e:	af6fd0ef          	jal	ra,80001934 <printk>
80004642:	80005537          	lui	a0,0x80005
80004646:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000464a:	aeafd0ef          	jal	ra,80001934 <printk>
8000464e:	06100593          	li	a1,97
80004652:	2e848513          	addi	a0,s1,744
80004656:	afcfd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000465a:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
8000465e:	40f2                	lw	ra,28(sp)
80004660:	4462                	lw	s0,24(sp)
80004662:	854e                	mv	a0,s3
80004664:	44d2                	lw	s1,20(sp)
80004666:	4942                	lw	s2,16(sp)
80004668:	49b2                	lw	s3,12(sp)
8000466a:	4a22                	lw	s4,8(sp)
8000466c:	6105                	addi	sp,sp,32
8000466e:	8082                	ret

80004670 <z_impl_atomic_and>:
 * @param value the value to AND
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_and(atomic_t *target, atomic_val_t value)
{
80004670:	1101                	addi	sp,sp,-32
80004672:	cc22                	sw	s0,24(sp)
80004674:	c84a                	sw	s2,16(sp)
80004676:	c452                	sw	s4,8(sp)
80004678:	ce06                	sw	ra,28(sp)
8000467a:	ca26                	sw	s1,20(sp)
8000467c:	c64e                	sw	s3,12(sp)
8000467e:	8a2a                	mv	s4,a0
80004680:	892e                	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004682:	4421                	li	s0,8
80004684:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004688:	800064b7          	lui	s1,0x80006
8000468c:	8a448513          	addi	a0,s1,-1884 # 800058a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a5>
	key = (mstatus & SOC_MSTATUS_IEN);
80004690:	8821                	andi	s0,s0,8
80004692:	becff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
80004696:	ed0d                	bnez	a0,800046d0 <z_impl_atomic_and+0x60>
80004698:	800059b7          	lui	s3,0x80005
8000469c:	800055b7          	lui	a1,0x80005
800046a0:	80005537          	lui	a0,0x80005
800046a4:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
800046a8:	04e00693          	li	a3,78
800046ac:	2e898613          	addi	a2,s3,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800046b0:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
800046b4:	a80fd0ef          	jal	ra,80001934 <printk>
800046b8:	80005537          	lui	a0,0x80005
800046bc:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
800046c0:	a74fd0ef          	jal	ra,80001934 <printk>
800046c4:	04e00593          	li	a1,78
800046c8:	2e898513          	addi	a0,s3,744
800046cc:	a86fd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
800046d0:	8a448513          	addi	a0,s1,-1884
800046d4:	be6ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
800046d8:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800046dc:	8a448513          	addi	a0,s1,-1884
	*target &= value;
800046e0:	0129f933          	and	s2,s3,s2
800046e4:	012a2023          	sw	s2,0(s4)
800046e8:	bb0ff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
800046ec:	ed0d                	bnez	a0,80004726 <z_impl_atomic_and+0xb6>
800046ee:	800054b7          	lui	s1,0x80005
800046f2:	800055b7          	lui	a1,0x80005
800046f6:	80005537          	lui	a0,0x80005
800046fa:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
800046fe:	06100693          	li	a3,97
80004702:	2e848613          	addi	a2,s1,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80004706:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
8000470a:	a2afd0ef          	jal	ra,80001934 <printk>
8000470e:	80005537          	lui	a0,0x80005
80004712:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
80004716:	a1efd0ef          	jal	ra,80001934 <printk>
8000471a:	06100593          	li	a1,97
8000471e:	2e848513          	addi	a0,s1,744
80004722:	a30fd0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004726:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
8000472a:	40f2                	lw	ra,28(sp)
8000472c:	4462                	lw	s0,24(sp)
8000472e:	854e                	mv	a0,s3
80004730:	44d2                	lw	s1,20(sp)
80004732:	4942                	lw	s2,16(sp)
80004734:	49b2                	lw	s3,12(sp)
80004736:	4a22                	lw	s4,8(sp)
80004738:	6105                	addi	sp,sp,32
8000473a:	8082                	ret

8000473c <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
8000473c:	1141                	addi	sp,sp,-16
8000473e:	c422                	sw	s0,8(sp)
80004740:	c226                	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004742:	80006437          	lui	s0,0x80006
80004746:	800064b7          	lui	s1,0x80006
{
8000474a:	c606                	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000474c:	81040413          	addi	s0,s0,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
80004750:	81048493          	addi	s1,s1,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
80004754:	00946863          	bltu	s0,s1,80004764 <init_static_pools+0x28>
		k_mem_pool_init(p);
	}

	return 0;
}
80004758:	40b2                	lw	ra,12(sp)
8000475a:	4422                	lw	s0,8(sp)
8000475c:	4492                	lw	s1,4(sp)
8000475e:	4501                	li	a0,0
80004760:	0141                	addi	sp,sp,16
80004762:	8082                	ret
80004764:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80004768:	8522                	mv	a0,s0
	list->head = (sys_dnode_t *)list;
8000476a:	c85c                	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
8000476c:	cc1c                	sw	a5,24(s0)
8000476e:	84ffc0ef          	jal	ra,80000fbc <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004772:	0471                	addi	s0,s0,28
80004774:	b7c5                	j	80004754 <init_static_pools+0x18>

80004776 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80004776:	800067b7          	lui	a5,0x80006
8000477a:	b747a783          	lw	a5,-1164(a5) # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
{
8000477e:	715d                	addi	sp,sp,-80
80004780:	c4a2                	sw	s0,72(sp)
80004782:	c2a6                	sw	s1,68(sp)
80004784:	de4e                	sw	s3,60(sp)
80004786:	d85a                	sw	s6,48(sp)
80004788:	c686                	sw	ra,76(sp)
8000478a:	c0ca                	sw	s2,64(sp)
8000478c:	dc52                	sw	s4,56(sp)
8000478e:	da56                	sw	s5,52(sp)
80004790:	d65e                	sw	s7,44(sp)
80004792:	d462                	sw	s8,40(sp)
80004794:	d266                	sw	s9,36(sp)
80004796:	d06a                	sw	s10,32(sp)
80004798:	ce6e                	sw	s11,28(sp)
8000479a:	89aa                	mv	s3,a0
8000479c:	84ae                	mv	s1,a1
8000479e:	8b32                	mv	s6,a2
800047a0:	8436                	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800047a2:	10078063          	beqz	a5,800048a2 <k_mem_pool_alloc+0x12c>
800047a6:	e2f1                	bnez	a3,8000486a <k_mem_pool_alloc+0xf4>
	s64_t end = 0;
800047a8:	4901                	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
800047aa:	80006537          	lui	a0,0x80006
800047ae:	81050513          	addi	a0,a0,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
800047b2:	40a98533          	sub	a0,s3,a0
800047b6:	b6db75b7          	lui	a1,0xb6db7
800047ba:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
800047be:	8509                	srai	a0,a0,0x2
800047c0:	85cfc0ef          	jal	ra,8000081c <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
800047c4:	7a7d                	lui	s4,0xfffff
		block->id.block = block_num;
800047c6:	6a85                	lui	s5,0x1
		block->id.pool = pool_id(p);
800047c8:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
800047cc:	5bd5                	li	s7,-11
			ret = -ENOMEM;
800047ce:	5cd1                	li	s9,-12
		block->id.level = level_num;
800047d0:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
800047d4:	1afd                	addi	s5,s5,-1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800047d6:	4d21                	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
800047d8:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
800047dc:	8726                	mv	a4,s1
800047de:	0074                	addi	a3,sp,12
800047e0:	0030                	addi	a2,sp,8
800047e2:	85da                	mv	a1,s6
800047e4:	854e                	mv	a0,s3
800047e6:	89ffc0ef          	jal	ra,80001084 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
800047ea:	01751c63          	bne	a0,s7,80004802 <k_mem_pool_alloc+0x8c>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
800047ee:	8726                	mv	a4,s1
800047f0:	0074                	addi	a3,sp,12
800047f2:	0030                	addi	a2,sp,8
800047f4:	85da                	mv	a1,s6
800047f6:	854e                	mv	a0,s3
800047f8:	88dfc0ef          	jal	ra,80001084 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
800047fc:	01751363          	bne	a0,s7,80004802 <k_mem_pool_alloc+0x8c>
			ret = -ENOMEM;
80004800:	5551                	li	a0,-12
		block->id.level = level_num;
80004802:	47a2                	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80004804:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
80004808:	8bbd                	andi	a5,a5,15
8000480a:	00879713          	slli	a4,a5,0x8
8000480e:	40dc                	lw	a5,4(s1)
80004810:	0147f7b3          	and	a5,a5,s4
80004814:	8fd9                	or	a5,a5,a4
		block->id.block = block_num;
80004816:	4732                	lw	a4,12(sp)
80004818:	0157f7b3          	and	a5,a5,s5
8000481c:	0732                	slli	a4,a4,0xc
8000481e:	8fd9                	or	a5,a5,a4
80004820:	c0dc                	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
80004822:	c50d                	beqz	a0,8000484c <k_mem_pool_alloc+0xd6>
80004824:	c405                	beqz	s0,8000484c <k_mem_pool_alloc+0xd6>
80004826:	03951363          	bne	a0,s9,8000484c <k_mem_pool_alloc+0xd6>
8000482a:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
8000482e:	8622                	mv	a2,s0
80004830:	85ee                	mv	a1,s11
80004832:	8921                	andi	a0,a0,8
80004834:	ad3fe0ef          	jal	ra,80003306 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
80004838:	57fd                	li	a5,-1
8000483a:	faf401e3          	beq	s0,a5,800047dc <k_mem_pool_alloc+0x66>
			timeout = end - z_tick_get();
8000483e:	c71ff0ef          	jal	ra,800044ae <z_tick_get>
80004842:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
80004846:	f8045be3          	bgez	s0,800047dc <k_mem_pool_alloc+0x66>
				break;
			}
		}
	}

	return -EAGAIN;
8000484a:	5555                	li	a0,-11
}
8000484c:	40b6                	lw	ra,76(sp)
8000484e:	4426                	lw	s0,72(sp)
80004850:	4496                	lw	s1,68(sp)
80004852:	4906                	lw	s2,64(sp)
80004854:	59f2                	lw	s3,60(sp)
80004856:	5a62                	lw	s4,56(sp)
80004858:	5ad2                	lw	s5,52(sp)
8000485a:	5b42                	lw	s6,48(sp)
8000485c:	5bb2                	lw	s7,44(sp)
8000485e:	5c22                	lw	s8,40(sp)
80004860:	5c92                	lw	s9,36(sp)
80004862:	5d02                	lw	s10,32(sp)
80004864:	4df2                	lw	s11,28(sp)
80004866:	6161                	addi	sp,sp,80
80004868:	8082                	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
8000486a:	80005937          	lui	s2,0x80005
8000486e:	800055b7          	lui	a1,0x80005
80004872:	80005537          	lui	a0,0x80005
80004876:	77058593          	addi	a1,a1,1904 # 80005770 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005771>
8000487a:	03900693          	li	a3,57
8000487e:	75c90613          	addi	a2,s2,1884 # 8000575c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000575d>
80004882:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80004886:	8aefd0ef          	jal	ra,80001934 <printk>
8000488a:	80005537          	lui	a0,0x80005
8000488e:	2a050513          	addi	a0,a0,672 # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
80004892:	8a2fd0ef          	jal	ra,80001934 <printk>
80004896:	03900593          	li	a1,57
8000489a:	75c90513          	addi	a0,s2,1884
8000489e:	8b4fd0ef          	jal	ra,80001952 <assert_post_action>
	if (timeout > 0) {
800048a2:	f08053e3          	blez	s0,800047a8 <k_mem_pool_alloc+0x32>
		end = z_tick_get() + z_ms_to_ticks(timeout);
800048a6:	c09ff0ef          	jal	ra,800044ae <z_tick_get>
800048aa:	892a                	mv	s2,a0
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800048ac:	45a9                	li	a1,10
800048ae:	00940513          	addi	a0,s0,9
800048b2:	81efc0ef          	jal	ra,800008d0 <__divsi3>
800048b6:	992a                	add	s2,s2,a0
800048b8:	bdcd                	j	800047aa <k_mem_pool_alloc+0x34>

800048ba <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800048ba:	00054783          	lbu	a5,0(a0)
{
800048be:	1101                	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800048c0:	4110                	lw	a2,0(a0)
{
800048c2:	cc22                	sw	s0,24(sp)
800048c4:	00379413          	slli	s0,a5,0x3
800048c8:	c84a                	sw	s2,16(sp)
800048ca:	8c1d                	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800048cc:	80006937          	lui	s2,0x80006
800048d0:	040a                	slli	s0,s0,0x2
800048d2:	00865593          	srli	a1,a2,0x8
800048d6:	81090513          	addi	a0,s2,-2032 # 80005810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005811>
800048da:	8231                	srli	a2,a2,0xc
800048dc:	89bd                	andi	a1,a1,15
800048de:	9522                	add	a0,a0,s0
{
800048e0:	ce06                	sw	ra,28(sp)
800048e2:	ca26                	sw	s1,20(sp)
800048e4:	c64e                	sw	s3,12(sp)
800048e6:	c452                	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800048e8:	9adfc0ef          	jal	ra,80001294 <z_sys_mem_pool_block_free>
800048ec:	45a1                	li	a1,8
800048ee:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800048f2:	800064b7          	lui	s1,0x80006
800048f6:	8a848513          	addi	a0,s1,-1880 # 800058a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058a9>
	key = (mstatus & SOC_MSTATUS_IEN);
800048fa:	0085f993          	andi	s3,a1,8
800048fe:	980ff0ef          	jal	ra,80003a7e <z_spin_lock_valid>
80004902:	81090913          	addi	s2,s2,-2032
80004906:	ed0d                	bnez	a0,80004940 <k_mem_pool_free_id+0x86>
80004908:	80005a37          	lui	s4,0x80005
8000490c:	800055b7          	lui	a1,0x80005
80004910:	80005537          	lui	a0,0x80005
80004914:	30058593          	addi	a1,a1,768 # 80005300 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005301>
80004918:	04e00693          	li	a3,78
8000491c:	2e8a0613          	addi	a2,s4,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
80004920:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80004924:	810fd0ef          	jal	ra,80001934 <printk>
80004928:	80005537          	lui	a0,0x80005
8000492c:	31850513          	addi	a0,a0,792 # 80005318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005319>
80004930:	804fd0ef          	jal	ra,80001934 <printk>
80004934:	04e00593          	li	a1,78
80004938:	2e8a0513          	addi	a0,s4,744
8000493c:	816fd0ef          	jal	ra,80001952 <assert_post_action>
	z_spin_lock_set_owner(l);
80004940:	8a848513          	addi	a0,s1,-1880
80004944:	976ff0ef          	jal	ra,80003aba <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80004948:	01440513          	addi	a0,s0,20
8000494c:	954a                	add	a0,a0,s2
8000494e:	bbbfe0ef          	jal	ra,80003508 <z_unpend_all>

	if (need_sched != 0) {
80004952:	cd09                	beqz	a0,8000496c <k_mem_pool_free_id+0xb2>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
80004954:	4462                	lw	s0,24(sp)
80004956:	40f2                	lw	ra,28(sp)
80004958:	4942                	lw	s2,16(sp)
8000495a:	4a22                	lw	s4,8(sp)
		z_reschedule(&lock, key);
8000495c:	85ce                	mv	a1,s3
8000495e:	8a848513          	addi	a0,s1,-1880
}
80004962:	49b2                	lw	s3,12(sp)
80004964:	44d2                	lw	s1,20(sp)
80004966:	6105                	addi	sp,sp,32
		z_reschedule(&lock, key);
80004968:	e7ffd06f          	j	800027e6 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000496c:	8a848513          	addi	a0,s1,-1880
80004970:	928ff0ef          	jal	ra,80003a98 <z_spin_unlock_valid>
80004974:	ed0d                	bnez	a0,800049ae <k_mem_pool_free_id+0xf4>
80004976:	80005437          	lui	s0,0x80005
8000497a:	800055b7          	lui	a1,0x80005
8000497e:	80005537          	lui	a0,0x80005
80004982:	33058593          	addi	a1,a1,816 # 80005330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005331>
80004986:	06100693          	li	a3,97
8000498a:	2e840613          	addi	a2,s0,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
8000498e:	21c50513          	addi	a0,a0,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80004992:	fa3fc0ef          	jal	ra,80001934 <printk>
80004996:	80005537          	lui	a0,0x80005
8000499a:	34850513          	addi	a0,a0,840 # 80005348 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005349>
8000499e:	f97fc0ef          	jal	ra,80001934 <printk>
800049a2:	06100593          	li	a1,97
800049a6:	2e840513          	addi	a0,s0,744
800049aa:	fa9fc0ef          	jal	ra,80001952 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800049ae:	3009a5f3          	csrrs	a1,mstatus,s3
}
800049b2:	40f2                	lw	ra,28(sp)
800049b4:	4462                	lw	s0,24(sp)
800049b6:	44d2                	lw	s1,20(sp)
800049b8:	4942                	lw	s2,16(sp)
800049ba:	49b2                	lw	s3,12(sp)
800049bc:	4a22                	lw	s4,8(sp)
800049be:	6105                	addi	sp,sp,32
800049c0:	8082                	ret

800049c2 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
800049c2:	00458613          	addi	a2,a1,4
800049c6:	00b67863          	bgeu	a2,a1,800049d6 <k_mem_pool_malloc+0x14>
				   &size)) {
		return NULL;
800049ca:	4501                	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
800049cc:	8082                	ret
		return NULL;
800049ce:	4501                	li	a0,0
}
800049d0:	40f2                	lw	ra,28(sp)
800049d2:	6105                	addi	sp,sp,32
800049d4:	8082                	ret
{
800049d6:	1101                	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
800049d8:	4681                	li	a3,0
800049da:	002c                	addi	a1,sp,8
{
800049dc:	ce06                	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
800049de:	d99ff0ef          	jal	ra,80004776 <k_mem_pool_alloc>
800049e2:	f575                	bnez	a0,800049ce <k_mem_pool_malloc+0xc>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
800049e4:	4522                	lw	a0,8(sp)
800049e6:	4611                	li	a2,4
800049e8:	006c                	addi	a1,sp,12
800049ea:	b9efd0ef          	jal	ra,80001d88 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
800049ee:	4522                	lw	a0,8(sp)
800049f0:	0511                	addi	a0,a0,4
800049f2:	bff9                	j	800049d0 <k_mem_pool_malloc+0xe>

800049f4 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
800049f4:	c501                	beqz	a0,800049fc <k_free+0x8>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
800049f6:	1571                	addi	a0,a0,-4
800049f8:	ec3ff06f          	j	800048ba <k_mem_pool_free_id>
	}
}
800049fc:	8082                	ret

800049fe <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
800049fe:	800067b7          	lui	a5,0x80006
80004a02:	b7c7a783          	lw	a5,-1156(a5) # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
{
80004a06:	85aa                	mv	a1,a0
	if (_current->resource_pool != NULL) {
80004a08:	57a8                	lw	a0,104(a5)
80004a0a:	c119                	beqz	a0,80004a10 <z_thread_malloc+0x12>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80004a0c:	fb7ff06f          	j	800049c2 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
80004a10:	4501                	li	a0,0
80004a12:	8082                	ret

80004a14 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80004a14:	8082                	ret
