
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	5750006f          	j	80000d80 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	1f0000ef          	jal	ra,8000025c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	02051e63          	bnez	a0,800000b0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	13408093          	addi	ra,ra,308 # 800001c8 <no_reschedule>
	tail _Fault
8000009c:	41d0006f          	j	80000cb8 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000ac:	0900006f          	j	8000013c <reschedule>

800000b0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000b0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000b4:	00007397          	auipc	t2,0x7
800000b8:	c9038393          	addi	t2,t2,-880 # 80006d44 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000bc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000c0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000c4:	00512023          	sw	t0,0(sp)

800000c8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000c8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000cc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000d0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000d4:	00030863          	beqz	t1,800000e4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000d8:	00000097          	auipc	ra,0x0
800000dc:	03c08093          	addi	ra,ra,60 # 80000114 <on_thread_stack>
	tail z_irq_do_offload
800000e0:	4650006f          	j	80000d44 <z_irq_do_offload>

800000e4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000e4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000e8:	800002b7          	lui	t0,0x80000
800000ec:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000f0:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000f4:	158000ef          	jal	ra,8000024c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000f8:	00006297          	auipc	t0,0x6
800000fc:	af428293          	addi	t0,t0,-1292 # 80005bec <_image_text_end>
	slli a0, a0, 3
80000100:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000104:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000108:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000010c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000110:	000300e7          	jalr	t1

80000114 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000114:	00007317          	auipc	t1,0x7
80000118:	c3030313          	addi	t1,t1,-976 # 80006d44 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000011c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000120:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000124:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000128:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000012c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000130:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000134:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000138:	087e0863          	beq	t3,t2,800001c8 <no_reschedule>

8000013c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000013c:	00007297          	auipc	t0,0x7
80000140:	c0828293          	addi	t0,t0,-1016 # 80006d44 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000144:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000148:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000014c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000150:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000154:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000158:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000015c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000160:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000164:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000168:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000016c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000170:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000174:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000178:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000017c:	00007397          	auipc	t2,0x7
80000180:	83038393          	addi	t2,t2,-2000 # 800069ac <_k_neg_eagain>
	lw t3, 0x00(t2)
80000184:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000188:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000018c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000190:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000194:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000198:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000019c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001a0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001a4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001a8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001ac:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001b0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001b4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001b8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001bc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001c0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001c4:	05832d83          	lw	s11,88(t1)

800001c8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001c8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001cc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001d0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001d4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001d8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001dc:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001e0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001e4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001e8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ec:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001f0:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001f4:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001f8:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001fc:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000200:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000204:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000208:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000020c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000210:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000214:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000218:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000021c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000220:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000224:	30200073          	mret

80000228 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000228:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000022c:	00007297          	auipc	t0,0x7
80000230:	b1828293          	addi	t0,t0,-1256 # 80006d44 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000234:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000238:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000023c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000240:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000244:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000248:	00008067          	ret

8000024c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000024c:	00100313          	li	t1,1
	sll t0, t1, a0
80000250:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000254:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000025c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000260:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000264:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000268:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000026c:	00028463          	beqz	t0,80000274 <not_interrupt>
	addi a0, a0, 1
80000270:	00150513          	addi	a0,a0,1

80000274 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000274:	00008067          	ret

Disassembly of section text:

80000278 <__lshrdi3>:
80000278:	02060063          	beqz	a2,80000298 <__lshrdi3+0x20>
8000027c:	02000793          	li	a5,32
80000280:	40c787b3          	sub	a5,a5,a2
80000284:	00f04c63          	bgtz	a5,8000029c <__lshrdi3+0x24>
80000288:	fe060513          	addi	a0,a2,-32
8000028c:	00000713          	li	a4,0
80000290:	00a5d533          	srl	a0,a1,a0
80000294:	00070593          	mv	a1,a4
80000298:	00008067          	ret
8000029c:	00c5d733          	srl	a4,a1,a2
800002a0:	00c55533          	srl	a0,a0,a2
800002a4:	00f595b3          	sll	a1,a1,a5
800002a8:	00b56533          	or	a0,a0,a1
800002ac:	fe9ff06f          	j	80000294 <__lshrdi3+0x1c>

800002b0 <__udivdi3>:
800002b0:	00058793          	mv	a5,a1
800002b4:	00060813          	mv	a6,a2
800002b8:	00068713          	mv	a4,a3
800002bc:	00050313          	mv	t1,a0
800002c0:	28069663          	bnez	a3,8000054c <__udivdi3+0x29c>
800002c4:	00006897          	auipc	a7,0x6
800002c8:	aa888893          	addi	a7,a7,-1368 # 80005d6c <__devconfig_end>
800002cc:	0ec5f663          	bgeu	a1,a2,800003b8 <__udivdi3+0x108>
800002d0:	00010737          	lui	a4,0x10
800002d4:	0ce67863          	bgeu	a2,a4,800003a4 <__udivdi3+0xf4>
800002d8:	0ff00713          	li	a4,255
800002dc:	00c73733          	sltu	a4,a4,a2
800002e0:	00371713          	slli	a4,a4,0x3
800002e4:	00e656b3          	srl	a3,a2,a4
800002e8:	00d888b3          	add	a7,a7,a3
800002ec:	0008c683          	lbu	a3,0(a7)
800002f0:	00e68733          	add	a4,a3,a4
800002f4:	02000693          	li	a3,32
800002f8:	40e686b3          	sub	a3,a3,a4
800002fc:	00068c63          	beqz	a3,80000314 <__udivdi3+0x64>
80000300:	00d797b3          	sll	a5,a5,a3
80000304:	00e55733          	srl	a4,a0,a4
80000308:	00d61833          	sll	a6,a2,a3
8000030c:	00f765b3          	or	a1,a4,a5
80000310:	00d51333          	sll	t1,a0,a3
80000314:	01085513          	srli	a0,a6,0x10
80000318:	02a5f733          	remu	a4,a1,a0
8000031c:	01081613          	slli	a2,a6,0x10
80000320:	01065613          	srli	a2,a2,0x10
80000324:	01035693          	srli	a3,t1,0x10
80000328:	02a5d5b3          	divu	a1,a1,a0
8000032c:	01071713          	slli	a4,a4,0x10
80000330:	00d766b3          	or	a3,a4,a3
80000334:	02b607b3          	mul	a5,a2,a1
80000338:	00058713          	mv	a4,a1
8000033c:	00f6fe63          	bgeu	a3,a5,80000358 <__udivdi3+0xa8>
80000340:	010686b3          	add	a3,a3,a6
80000344:	fff58713          	addi	a4,a1,-1
80000348:	0106e863          	bltu	a3,a6,80000358 <__udivdi3+0xa8>
8000034c:	00f6f663          	bgeu	a3,a5,80000358 <__udivdi3+0xa8>
80000350:	ffe58713          	addi	a4,a1,-2
80000354:	010686b3          	add	a3,a3,a6
80000358:	40f686b3          	sub	a3,a3,a5
8000035c:	02a6f7b3          	remu	a5,a3,a0
80000360:	01031313          	slli	t1,t1,0x10
80000364:	01035313          	srli	t1,t1,0x10
80000368:	02a6d6b3          	divu	a3,a3,a0
8000036c:	01079793          	slli	a5,a5,0x10
80000370:	0067e333          	or	t1,a5,t1
80000374:	02d605b3          	mul	a1,a2,a3
80000378:	00068513          	mv	a0,a3
8000037c:	00b37c63          	bgeu	t1,a1,80000394 <__udivdi3+0xe4>
80000380:	00680333          	add	t1,a6,t1
80000384:	fff68513          	addi	a0,a3,-1
80000388:	01036663          	bltu	t1,a6,80000394 <__udivdi3+0xe4>
8000038c:	00b37463          	bgeu	t1,a1,80000394 <__udivdi3+0xe4>
80000390:	ffe68513          	addi	a0,a3,-2
80000394:	01071713          	slli	a4,a4,0x10
80000398:	00a76733          	or	a4,a4,a0
8000039c:	00000593          	li	a1,0
800003a0:	0e40006f          	j	80000484 <__udivdi3+0x1d4>
800003a4:	010006b7          	lui	a3,0x1000
800003a8:	01000713          	li	a4,16
800003ac:	f2d66ce3          	bltu	a2,a3,800002e4 <__udivdi3+0x34>
800003b0:	01800713          	li	a4,24
800003b4:	f31ff06f          	j	800002e4 <__udivdi3+0x34>
800003b8:	00061663          	bnez	a2,800003c4 <__udivdi3+0x114>
800003bc:	00100693          	li	a3,1
800003c0:	02c6d833          	divu	a6,a3,a2
800003c4:	000106b7          	lui	a3,0x10
800003c8:	0cd87263          	bgeu	a6,a3,8000048c <__udivdi3+0x1dc>
800003cc:	0ff00693          	li	a3,255
800003d0:	0106f463          	bgeu	a3,a6,800003d8 <__udivdi3+0x128>
800003d4:	00800713          	li	a4,8
800003d8:	00e856b3          	srl	a3,a6,a4
800003dc:	00d888b3          	add	a7,a7,a3
800003e0:	0008c683          	lbu	a3,0(a7)
800003e4:	00e686b3          	add	a3,a3,a4
800003e8:	02000713          	li	a4,32
800003ec:	40d70733          	sub	a4,a4,a3
800003f0:	0a071863          	bnez	a4,800004a0 <__udivdi3+0x1f0>
800003f4:	410787b3          	sub	a5,a5,a6
800003f8:	00100593          	li	a1,1
800003fc:	01085613          	srli	a2,a6,0x10
80000400:	01081893          	slli	a7,a6,0x10
80000404:	0108d893          	srli	a7,a7,0x10
80000408:	01035693          	srli	a3,t1,0x10
8000040c:	02c7f733          	remu	a4,a5,a2
80000410:	02c7d7b3          	divu	a5,a5,a2
80000414:	01071713          	slli	a4,a4,0x10
80000418:	00d766b3          	or	a3,a4,a3
8000041c:	02f88533          	mul	a0,a7,a5
80000420:	00078713          	mv	a4,a5
80000424:	00a6fe63          	bgeu	a3,a0,80000440 <__udivdi3+0x190>
80000428:	010686b3          	add	a3,a3,a6
8000042c:	fff78713          	addi	a4,a5,-1
80000430:	0106e863          	bltu	a3,a6,80000440 <__udivdi3+0x190>
80000434:	00a6f663          	bgeu	a3,a0,80000440 <__udivdi3+0x190>
80000438:	ffe78713          	addi	a4,a5,-2
8000043c:	010686b3          	add	a3,a3,a6
80000440:	40a686b3          	sub	a3,a3,a0
80000444:	02c6f7b3          	remu	a5,a3,a2
80000448:	01031313          	slli	t1,t1,0x10
8000044c:	01035313          	srli	t1,t1,0x10
80000450:	02c6d6b3          	divu	a3,a3,a2
80000454:	01079793          	slli	a5,a5,0x10
80000458:	0067e333          	or	t1,a5,t1
8000045c:	02d888b3          	mul	a7,a7,a3
80000460:	00068513          	mv	a0,a3
80000464:	01137c63          	bgeu	t1,a7,8000047c <__udivdi3+0x1cc>
80000468:	00680333          	add	t1,a6,t1
8000046c:	fff68513          	addi	a0,a3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000470:	01036663          	bltu	t1,a6,8000047c <__udivdi3+0x1cc>
80000474:	01137463          	bgeu	t1,a7,8000047c <__udivdi3+0x1cc>
80000478:	ffe68513          	addi	a0,a3,-2
8000047c:	01071713          	slli	a4,a4,0x10
80000480:	00a76733          	or	a4,a4,a0
80000484:	00070513          	mv	a0,a4
80000488:	00008067          	ret
8000048c:	010006b7          	lui	a3,0x1000
80000490:	01000713          	li	a4,16
80000494:	f4d862e3          	bltu	a6,a3,800003d8 <__udivdi3+0x128>
80000498:	01800713          	li	a4,24
8000049c:	f3dff06f          	j	800003d8 <__udivdi3+0x128>
800004a0:	00e81833          	sll	a6,a6,a4
800004a4:	00d7d5b3          	srl	a1,a5,a3
800004a8:	00e51333          	sll	t1,a0,a4
800004ac:	00d556b3          	srl	a3,a0,a3
800004b0:	01085513          	srli	a0,a6,0x10
800004b4:	00e797b3          	sll	a5,a5,a4
800004b8:	02a5f733          	remu	a4,a1,a0
800004bc:	00f6e8b3          	or	a7,a3,a5
800004c0:	01081793          	slli	a5,a6,0x10
800004c4:	0107d793          	srli	a5,a5,0x10
800004c8:	0108d613          	srli	a2,a7,0x10
800004cc:	02a5d5b3          	divu	a1,a1,a0
800004d0:	01071713          	slli	a4,a4,0x10
800004d4:	00c76733          	or	a4,a4,a2
800004d8:	02b786b3          	mul	a3,a5,a1
800004dc:	00058613          	mv	a2,a1
800004e0:	00d77e63          	bgeu	a4,a3,800004fc <__udivdi3+0x24c>
800004e4:	01070733          	add	a4,a4,a6
800004e8:	fff58613          	addi	a2,a1,-1
800004ec:	01076863          	bltu	a4,a6,800004fc <__udivdi3+0x24c>
800004f0:	00d77663          	bgeu	a4,a3,800004fc <__udivdi3+0x24c>
800004f4:	ffe58613          	addi	a2,a1,-2
800004f8:	01070733          	add	a4,a4,a6
800004fc:	40d706b3          	sub	a3,a4,a3
80000500:	02a6f733          	remu	a4,a3,a0
80000504:	01089893          	slli	a7,a7,0x10
80000508:	0108d893          	srli	a7,a7,0x10
8000050c:	02a6d6b3          	divu	a3,a3,a0
80000510:	01071713          	slli	a4,a4,0x10
80000514:	02d785b3          	mul	a1,a5,a3
80000518:	011767b3          	or	a5,a4,a7
8000051c:	00068713          	mv	a4,a3
80000520:	00b7fe63          	bgeu	a5,a1,8000053c <__udivdi3+0x28c>
80000524:	010787b3          	add	a5,a5,a6
80000528:	fff68713          	addi	a4,a3,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000052c:	0107e863          	bltu	a5,a6,8000053c <__udivdi3+0x28c>
80000530:	00b7f663          	bgeu	a5,a1,8000053c <__udivdi3+0x28c>
80000534:	ffe68713          	addi	a4,a3,-2
80000538:	010787b3          	add	a5,a5,a6
8000053c:	40b787b3          	sub	a5,a5,a1
80000540:	01061593          	slli	a1,a2,0x10
80000544:	00e5e5b3          	or	a1,a1,a4
80000548:	eb5ff06f          	j	800003fc <__udivdi3+0x14c>
8000054c:	18d5e663          	bltu	a1,a3,800006d8 <__udivdi3+0x428>
80000550:	00010737          	lui	a4,0x10
80000554:	04e6f463          	bgeu	a3,a4,8000059c <__udivdi3+0x2ec>
80000558:	0ff00813          	li	a6,255
8000055c:	00d83733          	sltu	a4,a6,a3
80000560:	00371713          	slli	a4,a4,0x3
80000564:	00e6d833          	srl	a6,a3,a4
80000568:	00006597          	auipc	a1,0x6
8000056c:	80458593          	addi	a1,a1,-2044 # 80005d6c <__devconfig_end>
80000570:	010585b3          	add	a1,a1,a6
80000574:	0005c803          	lbu	a6,0(a1)
80000578:	02000593          	li	a1,32
8000057c:	00e80833          	add	a6,a6,a4
80000580:	410585b3          	sub	a1,a1,a6
80000584:	02059663          	bnez	a1,800005b0 <__udivdi3+0x300>
80000588:	00100713          	li	a4,1
8000058c:	eef6ece3          	bltu	a3,a5,80000484 <__udivdi3+0x1d4>
80000590:	00c53533          	sltu	a0,a0,a2
80000594:	00154713          	xori	a4,a0,1
80000598:	eedff06f          	j	80000484 <__udivdi3+0x1d4>
8000059c:	010005b7          	lui	a1,0x1000
800005a0:	01000713          	li	a4,16
800005a4:	fcb6e0e3          	bltu	a3,a1,80000564 <__udivdi3+0x2b4>
800005a8:	01800713          	li	a4,24
800005ac:	fb9ff06f          	j	80000564 <__udivdi3+0x2b4>
800005b0:	01065733          	srl	a4,a2,a6
800005b4:	00b696b3          	sll	a3,a3,a1
800005b8:	00d766b3          	or	a3,a4,a3
800005bc:	0106de93          	srli	t4,a3,0x10
800005c0:	0107d733          	srl	a4,a5,a6
800005c4:	03d778b3          	remu	a7,a4,t4
800005c8:	00b797b3          	sll	a5,a5,a1
800005cc:	01055833          	srl	a6,a0,a6
800005d0:	00f86333          	or	t1,a6,a5
800005d4:	01069793          	slli	a5,a3,0x10
800005d8:	0107d793          	srli	a5,a5,0x10
800005dc:	01035813          	srli	a6,t1,0x10
800005e0:	00b61633          	sll	a2,a2,a1
800005e4:	03d75733          	divu	a4,a4,t4
800005e8:	01089893          	slli	a7,a7,0x10
800005ec:	0108e833          	or	a6,a7,a6
800005f0:	02e78f33          	mul	t5,a5,a4
800005f4:	00070e13          	mv	t3,a4
800005f8:	01e87e63          	bgeu	a6,t5,80000614 <__udivdi3+0x364>
800005fc:	00d80833          	add	a6,a6,a3
80000600:	fff70e13          	addi	t3,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000604:	00d86863          	bltu	a6,a3,80000614 <__udivdi3+0x364>
80000608:	01e87663          	bgeu	a6,t5,80000614 <__udivdi3+0x364>
8000060c:	ffe70e13          	addi	t3,a4,-2
80000610:	00d80833          	add	a6,a6,a3
80000614:	41e80833          	sub	a6,a6,t5
80000618:	03d878b3          	remu	a7,a6,t4
8000061c:	03d85833          	divu	a6,a6,t4
80000620:	01089893          	slli	a7,a7,0x10
80000624:	03078eb3          	mul	t4,a5,a6
80000628:	01031793          	slli	a5,t1,0x10
8000062c:	0107d793          	srli	a5,a5,0x10
80000630:	00f8e7b3          	or	a5,a7,a5
80000634:	00080713          	mv	a4,a6
80000638:	01d7fe63          	bgeu	a5,t4,80000654 <__udivdi3+0x3a4>
8000063c:	00d787b3          	add	a5,a5,a3
80000640:	fff80713          	addi	a4,a6,-1
80000644:	00d7e863          	bltu	a5,a3,80000654 <__udivdi3+0x3a4>
80000648:	01d7f663          	bgeu	a5,t4,80000654 <__udivdi3+0x3a4>
8000064c:	ffe80713          	addi	a4,a6,-2
80000650:	00d787b3          	add	a5,a5,a3
80000654:	010e1e13          	slli	t3,t3,0x10
80000658:	41d787b3          	sub	a5,a5,t4
8000065c:	00010eb7          	lui	t4,0x10
80000660:	00ee6733          	or	a4,t3,a4
80000664:	fffe8813          	addi	a6,t4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000668:	01077333          	and	t1,a4,a6
8000066c:	01075893          	srli	a7,a4,0x10
80000670:	01067833          	and	a6,a2,a6
80000674:	01065613          	srli	a2,a2,0x10
80000678:	03030e33          	mul	t3,t1,a6
8000067c:	03088833          	mul	a6,a7,a6
80000680:	010e5693          	srli	a3,t3,0x10
80000684:	02c30333          	mul	t1,t1,a2
80000688:	01030333          	add	t1,t1,a6
8000068c:	006686b3          	add	a3,a3,t1
80000690:	02c888b3          	mul	a7,a7,a2
80000694:	0106f463          	bgeu	a3,a6,8000069c <__udivdi3+0x3ec>
80000698:	01d888b3          	add	a7,a7,t4
8000069c:	0106d613          	srli	a2,a3,0x10
800006a0:	011608b3          	add	a7,a2,a7
800006a4:	0317e663          	bltu	a5,a7,800006d0 <__udivdi3+0x420>
800006a8:	cf179ae3          	bne	a5,a7,8000039c <__udivdi3+0xec>
800006ac:	000107b7          	lui	a5,0x10
800006b0:	fff78793          	addi	a5,a5,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800006b4:	00f6f6b3          	and	a3,a3,a5
800006b8:	01069693          	slli	a3,a3,0x10
800006bc:	00fe7e33          	and	t3,t3,a5
800006c0:	00b51533          	sll	a0,a0,a1
800006c4:	01c686b3          	add	a3,a3,t3
800006c8:	00000593          	li	a1,0
800006cc:	dad57ce3          	bgeu	a0,a3,80000484 <__udivdi3+0x1d4>
800006d0:	fff70713          	addi	a4,a4,-1
800006d4:	cc9ff06f          	j	8000039c <__udivdi3+0xec>
800006d8:	00000593          	li	a1,0
800006dc:	00000713          	li	a4,0
800006e0:	da5ff06f          	j	80000484 <__udivdi3+0x1d4>

800006e4 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800006e4:	00008067          	ret

800006e8 <critical_rtn>:
{
	volatile u32_t x;

	ARG_UNUSED(unused);

	x = critical_var;
800006e8:	800077b7          	lui	a5,0x80007
800006ec:	a3c78793          	addi	a5,a5,-1476 # 80006a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a3d>
800006f0:	0007a703          	lw	a4,0(a5)
{
800006f4:	ff010113          	addi	sp,sp,-16
	x = critical_var;
800006f8:	00e12623          	sw	a4,12(sp)
	critical_var = x + 1;
800006fc:	00c12703          	lw	a4,12(sp)
80000700:	00170713          	addi	a4,a4,1
80000704:	00e7a023          	sw	a4,0(a5)

}
80000708:	01010113          	addi	sp,sp,16
8000070c:	00008067          	ret

80000710 <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000710:	fd010113          	addi	sp,sp,-48
80000714:	00112e23          	sw	ra,28(sp)
80000718:	00812c23          	sw	s0,24(sp)
8000071c:	03012423          	sw	a6,40(sp)
80000720:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000724:	04051663          	bnez	a0,80000770 <z_zassert.constprop.0+0x60>
80000728:	00068613          	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000072c:	80006537          	lui	a0,0x80006
80000730:	00070693          	mv	a3,a4
80000734:	00058713          	mv	a4,a1
80000738:	800065b7          	lui	a1,0x80006
8000073c:	00078413          	mv	s0,a5
80000740:	fc458593          	addi	a1,a1,-60 # 80005fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fc5>
		va_start(vargs, msg);
80000744:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000748:	fe850513          	addi	a0,a0,-24 # 80005fe8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fe9>
		va_start(vargs, msg);
8000074c:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000750:	578010ef          	jal	ra,80001cc8 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000754:	00c12583          	lw	a1,12(sp)
80000758:	00040513          	mv	a0,s0
8000075c:	53c010ef          	jal	ra,80001c98 <vprintk>
		printk("\n");
80000760:	80006537          	lui	a0,0x80006
80000764:	16450513          	addi	a0,a0,356 # 80006164 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006165>
80000768:	560010ef          	jal	ra,80001cc8 <printk>
		va_end(vargs);
		ztest_test_fail();
8000076c:	4c5010ef          	jal	ra,80002430 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000770:	01c12083          	lw	ra,28(sp)
80000774:	01812403          	lw	s0,24(sp)
80000778:	03010113          	addi	sp,sp,48
8000077c:	00008067          	ret

80000780 <test_critical>:

}

static void init_objects(void)
{
	critical_var = 0U;
80000780:	800077b7          	lui	a5,0x80007
	alt_thread_iterations = 0U;
	k_work_q_start(&offload_work_q,
80000784:	800075b7          	lui	a1,0x80007
80000788:	80007537          	lui	a0,0x80007
 * during context switch
 *
 * @ingroup kernel_critical_tests
 */
void test_critical(void)
{
8000078c:	fe010113          	addi	sp,sp,-32
	critical_var = 0U;
80000790:	a207ae23          	sw	zero,-1476(a5) # 80006a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a3d>
	k_work_q_start(&offload_work_q,
80000794:	fff00693          	li	a3,-1
	alt_thread_iterations = 0U;
80000798:	800077b7          	lui	a5,0x80007
	k_work_q_start(&offload_work_q,
8000079c:	40000613          	li	a2,1024
800007a0:	d7058593          	addi	a1,a1,-656 # 80006d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d71>
800007a4:	a8050513          	addi	a0,a0,-1408 # 80006a80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a81>
{
800007a8:	00112e23          	sw	ra,28(sp)
	alt_thread_iterations = 0U;
800007ac:	a207ac23          	sw	zero,-1480(a5) # 80006a38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a39>
	k_work_q_start(&offload_work_q,
800007b0:	468040ef          	jal	ra,80004c18 <k_work_q_start>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_OBJECT_RELEASE, k_object_release, void *, object)

K_SYSCALL_DECLARE1(K_SYSCALL_K_OBJECT_ALLOC, k_object_alloc, void *, enum k_objects, otype)

K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800007b4:	800016b7          	lui	a3,0x80001
800007b8:	800075b7          	lui	a1,0x80007
800007bc:	80007537          	lui	a0,0x80007
800007c0:	00012223          	sw	zero,4(sp)
800007c4:	00012023          	sw	zero,0(sp)
800007c8:	00c00893          	li	a7,12
800007cc:	00000813          	li	a6,0
800007d0:	00000793          	li	a5,0
800007d4:	00000713          	li	a4,0
800007d8:	91868693          	addi	a3,a3,-1768 # 80000918 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000919>
800007dc:	40000613          	li	a2,1024
800007e0:	17058593          	addi	a1,a1,368 # 80007170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007171>
800007e4:	b0450513          	addi	a0,a0,-1276 # 80006b04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b05>
800007e8:	1a8040ef          	jal	ra,80004990 <z_impl_k_thread_create>
800007ec:	800016b7          	lui	a3,0x80001
800007f0:	800075b7          	lui	a1,0x80007
800007f4:	80007537          	lui	a0,0x80007
800007f8:	00000793          	li	a5,0
800007fc:	00000713          	li	a4,0
80000800:	99068693          	addi	a3,a3,-1648 # 80000990 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000991>
80000804:	40000613          	li	a2,1024
80000808:	00012223          	sw	zero,4(sp)
8000080c:	00012023          	sw	zero,0(sp)
80000810:	00c00893          	li	a7,12
80000814:	00000813          	li	a6,0
80000818:	57058593          	addi	a1,a1,1392 # 80007570 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007571>
8000081c:	b7450513          	addi	a0,a0,-1164 # 80006b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b75>
80000820:	170040ef          	jal	ra,80004990 <z_impl_k_thread_create>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000824:	0000a5b7          	lui	a1,0xa
80000828:	80007537          	lui	a0,0x80007
8000082c:	c4058593          	addi	a1,a1,-960 # 9c40 <CONFIG_ISR_STACK_SIZE+0x9440>
80000830:	a0450513          	addi	a0,a0,-1532 # 80006a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a05>
80000834:	4bd030ef          	jal	ra,800044f0 <z_impl_k_sem_take>
	init_objects();
	start_threads();

	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
		     "Timed out waiting for TEST_SEM");
}
80000838:	01c12083          	lw	ra,28(sp)
	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
8000083c:	800067b7          	lui	a5,0x80006
80000840:	80006737          	lui	a4,0x80006
80000844:	80006637          	lui	a2,0x80006
80000848:	800065b7          	lui	a1,0x80006
8000084c:	f5c78793          	addi	a5,a5,-164 # 80005f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f5d>
80000850:	e8070713          	addi	a4,a4,-384 # 80005e80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e81>
80000854:	0dc00693          	li	a3,220
80000858:	fc460613          	addi	a2,a2,-60 # 80005fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fc5>
8000085c:	f7c58593          	addi	a1,a1,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
80000860:	00153513          	seqz	a0,a0
}
80000864:	02010113          	addi	sp,sp,32
	zassert_true(k_sem_take(&TEST_SEM, TEST_TIMEOUT * 2) == 0,
80000868:	ea9ff06f          	j	80000710 <z_zassert.constprop.0>

8000086c <critical_loop>:
{
8000086c:	fd010113          	addi	sp,sp,-48
80000870:	02912223          	sw	s1,36(sp)
	while (k_uptime_get() < mseconds + NUM_MILLISECONDS) {
80000874:	000014b7          	lui	s1,0x1
{
80000878:	02812423          	sw	s0,40(sp)
8000087c:	03212023          	sw	s2,32(sp)
80000880:	01312e23          	sw	s3,28(sp)
80000884:	01412c23          	sw	s4,24(sp)
80000888:	02112623          	sw	ra,44(sp)
8000088c:	00050913          	mv	s2,a0
	while (k_uptime_get() < mseconds + NUM_MILLISECONDS) {
80000890:	38848493          	addi	s1,s1,904 # 1388 <CONFIG_ISR_STACK_SIZE+0xb88>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80000894:	539040ef          	jal	ra,800055cc <z_impl_k_uptime_get>
80000898:	009504b3          	add	s1,a0,s1
8000089c:	00a4b433          	sltu	s0,s1,a0
 * @return N/A
 * @req K-WORK-001
 */
static inline void k_work_init(struct k_work *work, k_work_handler_t handler)
{
	*work = (struct k_work)Z_WORK_INITIALIZER(handler);
800008a0:	800009b7          	lui	s3,0x80000
800008a4:	00b40433          	add	s0,s0,a1
800008a8:	6e898993          	addi	s3,s3,1768 # 800006e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800006e9>
 */
static inline void k_work_submit_to_queue(struct k_work_q *work_q,
					  struct k_work *work)
{
	if (!atomic_test_and_set_bit(work->flags, K_WORK_STATE_PENDING)) {
		k_queue_append(&work_q->queue, work);
800008ac:	80007a37          	lui	s4,0x80007
800008b0:	51d040ef          	jal	ra,800055cc <z_impl_k_uptime_get>
800008b4:	0285c863          	blt	a1,s0,800008e4 <critical_loop+0x78>
800008b8:	00b41463          	bne	s0,a1,800008c0 <critical_loop+0x54>
800008bc:	02956463          	bltu	a0,s1,800008e4 <critical_loop+0x78>
}
800008c0:	02c12083          	lw	ra,44(sp)
800008c4:	02812403          	lw	s0,40(sp)
800008c8:	00090513          	mv	a0,s2
800008cc:	02412483          	lw	s1,36(sp)
800008d0:	02012903          	lw	s2,32(sp)
800008d4:	01c12983          	lw	s3,28(sp)
800008d8:	01812a03          	lw	s4,24(sp)
800008dc:	03010113          	addi	sp,sp,48
800008e0:	00008067          	ret

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_SUB, atomic_sub, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_SET, atomic_set, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_OR, atomic_or, atomic_val_t, atomic_t *, target, atomic_val_t, value)
800008e4:	00100593          	li	a1,1
800008e8:	00c10513          	addi	a0,sp,12
	*work = (struct k_work)Z_WORK_INITIALIZER(handler);
800008ec:	00012223          	sw	zero,4(sp)
800008f0:	01312423          	sw	s3,8(sp)
800008f4:	00012623          	sw	zero,12(sp)
800008f8:	50d040ef          	jal	ra,80005604 <z_impl_atomic_or>
	atomic_val_t mask = ATOMIC_MASK(bit);
	atomic_val_t old;

	old = atomic_or(ATOMIC_ELEM(target, bit), mask);

	return (old & mask) != 0;
800008fc:	00157513          	andi	a0,a0,1
	if (!atomic_test_and_set_bit(work->flags, K_WORK_STATE_PENDING)) {
80000900:	00051863          	bnez	a0,80000910 <critical_loop+0xa4>
		k_queue_append(&work_q->queue, work);
80000904:	00410593          	addi	a1,sp,4
80000908:	a80a0513          	addi	a0,s4,-1408 # 80006a80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a81>
8000090c:	340020ef          	jal	ra,80002c4c <k_queue_append>
		count++;
80000910:	00190913          	addi	s2,s2,1
80000914:	f9dff06f          	j	800008b0 <critical_loop+0x44>

80000918 <alternate_thread>:
{
80000918:	ff010113          	addi	sp,sp,-16
8000091c:	01212023          	sw	s2,0(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000920:	80007937          	lui	s2,0x80007
80000924:	00812423          	sw	s0,8(sp)
80000928:	fff00593          	li	a1,-1
8000092c:	9e490513          	addi	a0,s2,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
	alt_thread_iterations = critical_loop(alt_thread_iterations);
80000930:	80007437          	lui	s0,0x80007
{
80000934:	00112623          	sw	ra,12(sp)
80000938:	00912223          	sw	s1,4(sp)
	alt_thread_iterations = critical_loop(alt_thread_iterations);
8000093c:	a3840413          	addi	s0,s0,-1480 # 80006a38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a39>
80000940:	3b1030ef          	jal	ra,800044f0 <z_impl_k_sem_take>
80000944:	00042503          	lw	a0,0(s0)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000948:	800074b7          	lui	s1,0x80007
8000094c:	f21ff0ef          	jal	ra,8000086c <critical_loop>
80000950:	00a42023          	sw	a0,0(s0)
80000954:	9f448513          	addi	a0,s1,-1548 # 800069f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069f5>
80000958:	2b5030ef          	jal	ra,8000440c <z_impl_k_sem_give>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
8000095c:	fff00593          	li	a1,-1
80000960:	9e490513          	addi	a0,s2,-1564
80000964:	38d030ef          	jal	ra,800044f0 <z_impl_k_sem_take>
	alt_thread_iterations = critical_loop(alt_thread_iterations);
80000968:	00042503          	lw	a0,0(s0)
8000096c:	f01ff0ef          	jal	ra,8000086c <critical_loop>
80000970:	00a42023          	sw	a0,0(s0)
}
80000974:	00812403          	lw	s0,8(sp)
80000978:	00c12083          	lw	ra,12(sp)
8000097c:	00012903          	lw	s2,0(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000980:	9f448513          	addi	a0,s1,-1548
80000984:	00412483          	lw	s1,4(sp)
80000988:	01010113          	addi	sp,sp,16
8000098c:	2810306f          	j	8000440c <z_impl_k_sem_give>

80000990 <regression_thread>:
{
80000990:	fc010113          	addi	sp,sp,-64
80000994:	01b12623          	sw	s11,12(sp)
80000998:	80007db7          	lui	s11,0x80007
8000099c:	9e4d8513          	addi	a0,s11,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
800009a0:	02112e23          	sw	ra,60(sp)
800009a4:	02812c23          	sw	s0,56(sp)
800009a8:	02912a23          	sw	s1,52(sp)
800009ac:	03212823          	sw	s2,48(sp)
800009b0:	03312623          	sw	s3,44(sp)
800009b4:	03412423          	sw	s4,40(sp)
800009b8:	03512223          	sw	s5,36(sp)
800009bc:	03612023          	sw	s6,32(sp)
800009c0:	01712e23          	sw	s7,28(sp)
800009c4:	01812c23          	sw	s8,24(sp)
800009c8:	01912a23          	sw	s9,20(sp)
800009cc:	01a12823          	sw	s10,16(sp)
800009d0:	23d030ef          	jal	ra,8000440c <z_impl_k_sem_give>
	ncalls = critical_loop(ncalls);
800009d4:	00000513          	li	a0,0
800009d8:	e95ff0ef          	jal	ra,8000086c <critical_loop>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800009dc:	80007cb7          	lui	s9,0x80007
800009e0:	00005d37          	lui	s10,0x5
800009e4:	00050413          	mv	s0,a0
800009e8:	e20d0593          	addi	a1,s10,-480 # 4e20 <CONFIG_ISR_STACK_SIZE+0x4620>
800009ec:	9f4c8513          	addi	a0,s9,-1548 # 800069f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069f5>
800009f0:	301030ef          	jal	ra,800044f0 <z_impl_k_sem_take>
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
800009f4:	80006937          	lui	s2,0x80006
800009f8:	800064b7          	lui	s1,0x80006
800009fc:	80006c37          	lui	s8,0x80006
80000a00:	80006bb7          	lui	s7,0x80006
80000a04:	e90c0793          	addi	a5,s8,-368 # 80005e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e91>
80000a08:	e6c90713          	addi	a4,s2,-404 # 80005e6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e6d>
80000a0c:	fc448613          	addi	a2,s1,-60 # 80005fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fc5>
80000a10:	eb4b8593          	addi	a1,s7,-332 # 80005eb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eb5>
80000a14:	0a300693          	li	a3,163
80000a18:	00153513          	seqz	a0,a0
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000a1c:	80007a37          	lui	s4,0x80007
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
80000a20:	cf1ff0ef          	jal	ra,80000710 <z_zassert.constprop.0>
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000a24:	a38a0a13          	addi	s4,s4,-1480 # 80006a38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a39>
80000a28:	800079b7          	lui	s3,0x80007
80000a2c:	000a2503          	lw	a0,0(s4)
80000a30:	a3c98993          	addi	s3,s3,-1476 # 80006a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a3d>
80000a34:	0009a783          	lw	a5,0(s3)
80000a38:	00a40533          	add	a0,s0,a0
80000a3c:	80006b37          	lui	s6,0x80006
80000a40:	80006ab7          	lui	s5,0x80006
80000a44:	40f50533          	sub	a0,a0,a5
80000a48:	e6c90713          	addi	a4,s2,-404
80000a4c:	eecb0793          	addi	a5,s6,-276 # 80005eec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005eed>
80000a50:	fc448613          	addi	a2,s1,-60
80000a54:	0a600693          	li	a3,166
80000a58:	f10a8593          	addi	a1,s5,-240 # 80005f10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f11>
80000a5c:	00153513          	seqz	a0,a0
80000a60:	cb1ff0ef          	jal	ra,80000710 <z_zassert.constprop.0>
	k_sched_time_slice_set(10, 10);
80000a64:	00a00593          	li	a1,10
80000a68:	00a00513          	li	a0,10
80000a6c:	43c020ef          	jal	ra,80002ea8 <k_sched_time_slice_set>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000a70:	9e4d8513          	addi	a0,s11,-1564
80000a74:	199030ef          	jal	ra,8000440c <z_impl_k_sem_give>
	ncalls = critical_loop(ncalls);
80000a78:	00040513          	mv	a0,s0
80000a7c:	df1ff0ef          	jal	ra,8000086c <critical_loop>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000a80:	e20d0593          	addi	a1,s10,-480
80000a84:	00050413          	mv	s0,a0
80000a88:	9f4c8513          	addi	a0,s9,-1548
80000a8c:	265030ef          	jal	ra,800044f0 <z_impl_k_sem_take>
	zassert_true(k_sem_take(&REGRESS_SEM, TEST_TIMEOUT) == 0,
80000a90:	e90c0793          	addi	a5,s8,-368
80000a94:	e6c90713          	addi	a4,s2,-404
80000a98:	fc448613          	addi	a2,s1,-60
80000a9c:	eb4b8593          	addi	a1,s7,-332
80000aa0:	0b000693          	li	a3,176
80000aa4:	00153513          	seqz	a0,a0
80000aa8:	c69ff0ef          	jal	ra,80000710 <z_zassert.constprop.0>
	zassert_equal(critical_var, ncalls + alt_thread_iterations,
80000aac:	000a2503          	lw	a0,0(s4)
80000ab0:	eecb0793          	addi	a5,s6,-276
80000ab4:	e6c90713          	addi	a4,s2,-404
80000ab8:	00a40433          	add	s0,s0,a0
80000abc:	0009a503          	lw	a0,0(s3)
80000ac0:	fc448613          	addi	a2,s1,-60
80000ac4:	f10a8593          	addi	a1,s5,-240
80000ac8:	40a40533          	sub	a0,s0,a0
80000acc:	00153513          	seqz	a0,a0
80000ad0:	0b300693          	li	a3,179
80000ad4:	c3dff0ef          	jal	ra,80000710 <z_zassert.constprop.0>
}
80000ad8:	03812403          	lw	s0,56(sp)
80000adc:	03c12083          	lw	ra,60(sp)
80000ae0:	03412483          	lw	s1,52(sp)
80000ae4:	03012903          	lw	s2,48(sp)
80000ae8:	02c12983          	lw	s3,44(sp)
80000aec:	02812a03          	lw	s4,40(sp)
80000af0:	02412a83          	lw	s5,36(sp)
80000af4:	02012b03          	lw	s6,32(sp)
80000af8:	01c12b83          	lw	s7,28(sp)
80000afc:	01812c03          	lw	s8,24(sp)
80000b00:	01412c83          	lw	s9,20(sp)
80000b04:	01012d03          	lw	s10,16(sp)
80000b08:	00c12d83          	lw	s11,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b0c:	80007537          	lui	a0,0x80007
80000b10:	a0450513          	addi	a0,a0,-1532 # 80006a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a05>
80000b14:	04010113          	addi	sp,sp,64
80000b18:	0f50306f          	j	8000440c <z_impl_k_sem_give>

80000b1c <test_main>:
void test_main(void)
{
	ztest_test_suite(kernel_critical,
			 ztest_unit_test(test_critical)
			 );
	ztest_run_test_suite(kernel_critical);
80000b1c:	800075b7          	lui	a1,0x80007
80000b20:	80006537          	lui	a0,0x80006
80000b24:	97058593          	addi	a1,a1,-1680 # 80006970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006971>
80000b28:	fb450513          	addi	a0,a0,-76 # 80005fb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb5>
80000b2c:	1350106f          	j	80002460 <z_ztest_run_test_suite>

80000b30 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000b30:	ff010113          	addi	sp,sp,-16
80000b34:	00112623          	sw	ra,12(sp)
80000b38:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000b3c:	00600793          	li	a5,6
80000b40:	02f50463          	beq	a0,a5,80000b68 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000b44:	395030ef          	jal	ra,800046d8 <k_is_in_isr>
80000b48:	02050463          	beqz	a0,80000b70 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000b4c:	38d030ef          	jal	ra,800046d8 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000b50:	04051663          	bnez	a0,80000b9c <z_SysFatalErrorHandler+0x6c>
80000b54:	800065b7          	lui	a1,0x80006
80000b58:	2c058593          	addi	a1,a1,704 # 800062c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062c1>
80000b5c:	80006537          	lui	a0,0x80006
80000b60:	2d450513          	addi	a0,a0,724 # 800062d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d5>
80000b64:	164010ef          	jal	ra,80001cc8 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000b68:	1d0010ef          	jal	ra,80001d38 <k_cpu_idle>
80000b6c:	ffdff06f          	j	80000b68 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000b70:	379030ef          	jal	ra,800046e8 <z_is_thread_essential>
80000b74:	fc051ce3          	bnez	a0,80000b4c <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000b78:	80007437          	lui	s0,0x80007
80000b7c:	d4440413          	addi	s0,s0,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
80000b80:	00842583          	lw	a1,8(s0)
80000b84:	80006537          	lui	a0,0x80006
80000b88:	2f450513          	addi	a0,a0,756 # 800062f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f5>
80000b8c:	13c010ef          	jal	ra,80001cc8 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000b90:	00842503          	lw	a0,8(s0)
80000b94:	7a1030ef          	jal	ra,80004b34 <z_impl_k_thread_abort>
80000b98:	fd1ff06f          	j	80000b68 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000b9c:	800065b7          	lui	a1,0x80006
80000ba0:	2bc58593          	addi	a1,a1,700 # 800062bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062bd>
80000ba4:	fb9ff06f          	j	80000b5c <z_SysFatalErrorHandler+0x2c>

80000ba8 <z_NanoFatalErrorHandler>:
{
80000ba8:	fb010113          	addi	sp,sp,-80
80000bac:	04812423          	sw	s0,72(sp)
80000bb0:	04912223          	sw	s1,68(sp)
80000bb4:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000bb8:	00600793          	li	a5,6
{
80000bbc:	00050493          	mv	s1,a0
80000bc0:	00058413          	mv	s0,a1
	switch (reason) {
80000bc4:	0ea7e063          	bltu	a5,a0,80000ca4 <z_NanoFatalErrorHandler+0xfc>
80000bc8:	80006737          	lui	a4,0x80006
80000bcc:	00251793          	slli	a5,a0,0x2
80000bd0:	01070713          	addi	a4,a4,16 # 80006010 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006011>
80000bd4:	00e787b3          	add	a5,a5,a4
80000bd8:	0007a783          	lw	a5,0(a5)
80000bdc:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000be0:	80006537          	lui	a0,0x80006
80000be4:	14050513          	addi	a0,a0,320 # 80006140 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006141>
		printk("***** Kernel OOPS! *****\n");
80000be8:	0e0010ef          	jal	ra,80001cc8 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000bec:	74c030ef          	jal	ra,80004338 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000bf0:	04442783          	lw	a5,68(s0)
80000bf4:	01042883          	lw	a7,16(s0)
80000bf8:	00c42803          	lw	a6,12(s0)
80000bfc:	02f12823          	sw	a5,48(sp)
80000c00:	04042783          	lw	a5,64(s0)
80000c04:	00442703          	lw	a4,4(s0)
80000c08:	00042683          	lw	a3,0(s0)
80000c0c:	02f12623          	sw	a5,44(sp)
80000c10:	03c42783          	lw	a5,60(s0)
80000c14:	04842603          	lw	a2,72(s0)
80000c18:	00050593          	mv	a1,a0
80000c1c:	02f12423          	sw	a5,40(sp)
80000c20:	03842783          	lw	a5,56(s0)
80000c24:	80006537          	lui	a0,0x80006
80000c28:	1c450513          	addi	a0,a0,452 # 800061c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061c5>
80000c2c:	02f12223          	sw	a5,36(sp)
80000c30:	03442783          	lw	a5,52(s0)
80000c34:	02f12023          	sw	a5,32(sp)
80000c38:	03042783          	lw	a5,48(s0)
80000c3c:	00f12e23          	sw	a5,28(sp)
80000c40:	02c42783          	lw	a5,44(s0)
80000c44:	00f12c23          	sw	a5,24(sp)
80000c48:	02842783          	lw	a5,40(s0)
80000c4c:	00f12a23          	sw	a5,20(sp)
80000c50:	02442783          	lw	a5,36(s0)
80000c54:	00f12823          	sw	a5,16(sp)
80000c58:	02042783          	lw	a5,32(s0)
80000c5c:	00f12623          	sw	a5,12(sp)
80000c60:	01c42783          	lw	a5,28(s0)
80000c64:	00f12423          	sw	a5,8(sp)
80000c68:	01842783          	lw	a5,24(s0)
80000c6c:	00f12223          	sw	a5,4(sp)
80000c70:	01442783          	lw	a5,20(s0)
80000c74:	00f12023          	sw	a5,0(sp)
80000c78:	00842783          	lw	a5,8(s0)
80000c7c:	04c010ef          	jal	ra,80001cc8 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000c80:	00040593          	mv	a1,s0
80000c84:	00048513          	mv	a0,s1
80000c88:	ea9ff0ef          	jal	ra,80000b30 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000c8c:	80006537          	lui	a0,0x80006
80000c90:	16850513          	addi	a0,a0,360 # 80006168 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006169>
80000c94:	f55ff06f          	j	80000be8 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80000c98:	80006537          	lui	a0,0x80006
80000c9c:	18450513          	addi	a0,a0,388 # 80006184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006185>
80000ca0:	f49ff06f          	j	80000be8 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000ca4:	80006537          	lui	a0,0x80006
80000ca8:	00048593          	mv	a1,s1
80000cac:	1a050513          	addi	a0,a0,416 # 800061a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061a1>
80000cb0:	018010ef          	jal	ra,80001cc8 <printk>
		break;
80000cb4:	f39ff06f          	j	80000bec <z_NanoFatalErrorHandler+0x44>

80000cb8 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000cb8:	ff010113          	addi	sp,sp,-16
80000cbc:	00812423          	sw	s0,8(sp)
80000cc0:	00112623          	sw	ra,12(sp)
80000cc4:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000cc8:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000ccc:	00161613          	slli	a2,a2,0x1
80000cd0:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80000cd4:	00500793          	li	a5,5
80000cd8:	02c7e863          	bltu	a5,a2,80000d08 <_Fault+0x50>
80000cdc:	80006737          	lui	a4,0x80006
80000ce0:	00261793          	slli	a5,a2,0x2
80000ce4:	02c70713          	addi	a4,a4,44 # 8000602c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000602d>
80000ce8:	00f707b3          	add	a5,a4,a5
80000cec:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000cf0:	80006537          	lui	a0,0x80006
80000cf4:	04c50513          	addi	a0,a0,76 # 8000604c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000604d>
80000cf8:	7d1000ef          	jal	ra,80001cc8 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000cfc:	00040593          	mv	a1,s0
80000d00:	00000513          	li	a0,0
80000d04:	ea5ff0ef          	jal	ra,80000ba8 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000d08:	800065b7          	lui	a1,0x80006
80000d0c:	04458593          	addi	a1,a1,68 # 80006044 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006045>
80000d10:	fe1ff06f          	j	80000cf0 <_Fault+0x38>

80000d14 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000d14:	ff010113          	addi	sp,sp,-16
80000d18:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000d1c:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000d20:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80000d24:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000d28:	0015d593          	srli	a1,a1,0x1
80000d2c:	31c50513          	addi	a0,a0,796 # 8000631c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000631d>
80000d30:	799000ef          	jal	ra,80001cc8 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000d34:	800065b7          	lui	a1,0x80006
80000d38:	06858593          	addi	a1,a1,104 # 80006068 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006069>
80000d3c:	00400513          	li	a0,4
80000d40:	e69ff0ef          	jal	ra,80000ba8 <z_NanoFatalErrorHandler>

80000d44 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000d44:	800077b7          	lui	a5,0x80007
80000d48:	a4078793          	addi	a5,a5,-1472 # 80006a40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a41>
80000d4c:	0007a703          	lw	a4,0(a5)
80000d50:	00070c63          	beqz	a4,80000d68 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80000d54:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000d58:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000d5c:	800077b7          	lui	a5,0x80007
80000d60:	a447a503          	lw	a0,-1468(a5) # 80006a44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a45>
80000d64:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80000d68:	00008067          	ret

80000d6c <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000d6c:	ff010113          	addi	sp,sp,-16
80000d70:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80000d74:	2a1010ef          	jal	ra,80002814 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000d78:	7e1000ef          	jal	ra,80001d58 <soc_interrupt_init>
#endif
	z_cstart();
80000d7c:	305010ef          	jal	ra,80002880 <z_cstart>

80000d80 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000d80:	00007117          	auipc	sp,0x7
80000d84:	3f010113          	addi	sp,sp,1008 # 80008170 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80000d88:	000012b7          	lui	t0,0x1
80000d8c:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000d90:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000d94:	fd9ff0ef          	jal	ra,80000d6c <_PrepC>

80000d98 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000d98:	0890006f          	j	80001620 <z_thread_entry>

80000d9c <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000d9c:	fd010113          	addi	sp,sp,-48
80000da0:	02812423          	sw	s0,40(sp)
80000da4:	02912223          	sw	s1,36(sp)
80000da8:	03212023          	sw	s2,32(sp)
80000dac:	01312e23          	sw	s3,28(sp)
80000db0:	01412c23          	sw	s4,24(sp)
80000db4:	01512a23          	sw	s5,20(sp)
80000db8:	01612823          	sw	s6,16(sp)
80000dbc:	01712623          	sw	s7,12(sp)
80000dc0:	00078b13          	mv	s6,a5
80000dc4:	02112623          	sw	ra,44(sp)
80000dc8:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000dcc:	00f00793          	li	a5,15
{
80000dd0:	00050493          	mv	s1,a0
80000dd4:	00058413          	mv	s0,a1
80000dd8:	00060993          	mv	s3,a2
80000ddc:	00068a13          	mv	s4,a3
80000de0:	00070b93          	mv	s7,a4
80000de4:	00080a93          	mv	s5,a6
80000de8:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000dec:	08f89a63          	bne	a7,a5,80000e80 <z_new_thread+0xe4>
80000df0:	800027b7          	lui	a5,0x80002
80000df4:	7dc78793          	addi	a5,a5,2012 # 800027dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800027dd>
80000df8:	08f69a63          	bne	a3,a5,80000e8c <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000dfc:	03012683          	lw	a3,48(sp)
80000e00:	00090593          	mv	a1,s2
80000e04:	00048513          	mv	a0,s1
80000e08:	00400613          	li	a2,4
80000e0c:	1a5030ef          	jal	ra,800047b0 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000e10:	fb098593          	addi	a1,s3,-80
80000e14:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000e18:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000e1c:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000e20:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000e24:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000e28:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000e2c:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000e30:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000e34:	02c12083          	lw	ra,44(sp)
80000e38:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000e3c:	d9878793          	addi	a5,a5,-616 # 80000d98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000d99>
	stack_init->a0 = (u32_t)thread_func;
80000e40:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000e44:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000e48:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000e4c:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000e50:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000e54:	02b4a423          	sw	a1,40(s1)
}
80000e58:	02012903          	lw	s2,32(sp)
80000e5c:	02412483          	lw	s1,36(sp)
80000e60:	01c12983          	lw	s3,28(sp)
80000e64:	01812a03          	lw	s4,24(sp)
80000e68:	01412a83          	lw	s5,20(sp)
80000e6c:	01012b03          	lw	s6,16(sp)
80000e70:	00c12b83          	lw	s7,12(sp)
80000e74:	00812c03          	lw	s8,8(sp)
80000e78:	03010113          	addi	sp,sp,48
80000e7c:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000e80:	01088693          	addi	a3,a7,16
80000e84:	01e00793          	li	a5,30
80000e88:	f6d7fae3          	bgeu	a5,a3,80000dfc <z_new_thread+0x60>
80000e8c:	80006c37          	lui	s8,0x80006
80000e90:	800065b7          	lui	a1,0x80006
80000e94:	80006537          	lui	a0,0x80006
80000e98:	344c0613          	addi	a2,s8,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
80000e9c:	01800693          	li	a3,24
80000ea0:	36458593          	addi	a1,a1,868 # 80006364 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006365>
80000ea4:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80000ea8:	621000ef          	jal	ra,80001cc8 <printk>
80000eac:	80006537          	lui	a0,0x80006
80000eb0:	00090593          	mv	a1,s2
80000eb4:	ff000693          	li	a3,-16
80000eb8:	00e00613          	li	a2,14
80000ebc:	41050513          	addi	a0,a0,1040 # 80006410 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006411>
80000ec0:	609000ef          	jal	ra,80001cc8 <printk>
80000ec4:	01800593          	li	a1,24
80000ec8:	344c0513          	addi	a0,s8,836
80000ecc:	639000ef          	jal	ra,80001d04 <assert_post_action>
80000ed0:	f2dff06f          	j	80000dfc <z_new_thread+0x60>

80000ed4 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80000ed4:	00c00793          	li	a5,12
80000ed8:	02f58733          	mul	a4,a1,a5
80000edc:	00c52783          	lw	a5,12(a0)
80000ee0:	00e787b3          	add	a5,a5,a4
80000ee4:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80000ee8:	00b75463          	bge	a4,a1,80000ef0 <get_bit_ptr+0x1c>
80000eec:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80000ef0:	02000713          	li	a4,32
80000ef4:	02e64733          	div	a4,a2,a4

	return bn & 0x1f;
}
80000ef8:	01f67513          	andi	a0,a2,31
	*word = &bitarray[bn / 32];
80000efc:	00271713          	slli	a4,a4,0x2
80000f00:	00e787b3          	add	a5,a5,a4
80000f04:	00f6a023          	sw	a5,0(a3)
}
80000f08:	00008067          	ret

80000f0c <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000f0c:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000f10:	00c10693          	addi	a3,sp,12
{
80000f14:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000f18:	fbdff0ef          	jal	ra,80000ed4 <get_bit_ptr>

	*word |= (1<<bit);
80000f1c:	00c12703          	lw	a4,12(sp)
80000f20:	00100793          	li	a5,1
80000f24:	00a79533          	sll	a0,a5,a0
80000f28:	00072783          	lw	a5,0(a4)
}
80000f2c:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80000f30:	00a7e7b3          	or	a5,a5,a0
80000f34:	00f72023          	sw	a5,0(a4)
}
80000f38:	02010113          	addi	sp,sp,32
80000f3c:	00008067          	ret

80000f40 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000f40:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000f44:	00c10693          	addi	a3,sp,12
{
80000f48:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000f4c:	f89ff0ef          	jal	ra,80000ed4 <get_bit_ptr>

	*word &= ~(1<<bit);
80000f50:	00c12703          	lw	a4,12(sp)
80000f54:	00100793          	li	a5,1
80000f58:	00a79533          	sll	a0,a5,a0
80000f5c:	00072783          	lw	a5,0(a4)
}
80000f60:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80000f64:	fff54513          	not	a0,a0
80000f68:	00a7f533          	and	a0,a5,a0
80000f6c:	00a72023          	sw	a0,0(a4)
}
80000f70:	02010113          	addi	sp,sp,32
80000f74:	00008067          	ret

80000f78 <z_sys_mem_pool_base_init>:
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000f78:	00452783          	lw	a5,4(a0)
80000f7c:	00855803          	lhu	a6,8(a0)
{
80000f80:	ff010113          	addi	sp,sp,-16
80000f84:	00812423          	sw	s0,8(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000f88:	02f80833          	mul	a6,a6,a5
{
80000f8c:	00050413          	mv	s0,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000f90:	00052503          	lw	a0,0(a0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80000f94:	00a44883          	lbu	a7,10(s0)
	p->max_inline_level = -1;
80000f98:	fff00713          	li	a4,-1
{
80000f9c:	00112623          	sw	ra,12(sp)
80000fa0:	00912223          	sw	s1,4(sp)
	p->max_inline_level = -1;
80000fa4:	00e405a3          	sb	a4,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80000fa8:	00000593          	li	a1,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);
80000fac:	00c00313          	li	t1,12
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000fb0:	01050533          	add	a0,a0,a6

		if (nblocks < 32) {
80000fb4:	01f00e13          	li	t3,31
			p->max_inline_level = i;
		} else {
			p->levels[i].bits_p = bits;
			bits += (nblocks + 31)/32;
80000fb8:	02000e93          	li	t4,32
	for (i = 0; i < p->n_levels; i++) {
80000fbc:	0315c263          	blt	a1,a7,80000fe0 <z_sys_mem_pool_base_init+0x68>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80000fc0:	00000493          	li	s1,0
80000fc4:	00845783          	lhu	a5,8(s0)
80000fc8:	06f4c463          	blt	s1,a5,80001030 <z_sys_mem_pool_base_init+0xb8>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80000fcc:	00c12083          	lw	ra,12(sp)
80000fd0:	00812403          	lw	s0,8(sp)
80000fd4:	00412483          	lw	s1,4(sp)
80000fd8:	01010113          	addi	sp,sp,16
80000fdc:	00008067          	ret
		int nblocks = buflen / sz;
80000fe0:	02f85733          	divu	a4,a6,a5
		sys_dlist_init(&p->levels[i].free_list);
80000fe4:	00c42603          	lw	a2,12(s0)
80000fe8:	026586b3          	mul	a3,a1,t1
80000fec:	00d606b3          	add	a3,a2,a3
80000ff0:	00468613          	addi	a2,a3,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80000ff4:	00c6a223          	sw	a2,4(a3)
	list->tail = (sys_dnode_t *)list;
80000ff8:	00c6a423          	sw	a2,8(a3)
		if (nblocks < 32) {
80000ffc:	00ee4e63          	blt	t3,a4,80001018 <z_sys_mem_pool_base_init+0xa0>
			p->max_inline_level = i;
80001000:	00b405a3          	sb	a1,11(s0)
		sz = _ALIGN4(sz / 4);
80001004:	0027d793          	srli	a5,a5,0x2
80001008:	00378793          	addi	a5,a5,3
8000100c:	ffc7f793          	andi	a5,a5,-4
	for (i = 0; i < p->n_levels; i++) {
80001010:	00158593          	addi	a1,a1,1
80001014:	fa9ff06f          	j	80000fbc <z_sys_mem_pool_base_init+0x44>
			bits += (nblocks + 31)/32;
80001018:	01f70713          	addi	a4,a4,31
8000101c:	03d74733          	div	a4,a4,t4
			p->levels[i].bits_p = bits;
80001020:	00a6a023          	sw	a0,0(a3)
			bits += (nblocks + 31)/32;
80001024:	00271713          	slli	a4,a4,0x2
80001028:	00e50533          	add	a0,a0,a4
8000102c:	fd9ff06f          	j	80001004 <z_sys_mem_pool_base_init+0x8c>
	return (u8_t *)p->buf + lsz * block;
80001030:	00442783          	lw	a5,4(s0)
		set_free_bit(p, 0, i);
80001034:	00048613          	mv	a2,s1
80001038:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
8000103c:	02f48733          	mul	a4,s1,a5
80001040:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001044:	00040513          	mv	a0,s0
	for (i = 0; i < p->n_max; i++) {
80001048:	00148493          	addi	s1,s1,1
	return (u8_t *)p->buf + lsz * block;
8000104c:	00e787b3          	add	a5,a5,a4
		sys_dlist_append(&p->levels[0].free_list, block);
80001050:	00c42703          	lw	a4,12(s0)
80001054:	00470693          	addi	a3,a4,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001058:	00d7a023          	sw	a3,0(a5)
	node->prev = list->tail;
8000105c:	00872683          	lw	a3,8(a4)
80001060:	00d7a223          	sw	a3,4(a5)

	list->tail->next = node;
80001064:	00872683          	lw	a3,8(a4)
80001068:	00f6a023          	sw	a5,0(a3)
	list->tail = node;
8000106c:	00f72423          	sw	a5,8(a4)
		set_free_bit(p, 0, i);
80001070:	e9dff0ef          	jal	ra,80000f0c <set_free_bit>
80001074:	f51ff06f          	j	80000fc4 <z_sys_mem_pool_base_init+0x4c>

80001078 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001078:	fb010113          	addi	sp,sp,-80
8000107c:	04812423          	sw	s0,72(sp)
80001080:	03712623          	sw	s7,44(sp)
80001084:	04112623          	sw	ra,76(sp)
80001088:	04912223          	sw	s1,68(sp)
8000108c:	05212023          	sw	s2,64(sp)
80001090:	03312e23          	sw	s3,60(sp)
80001094:	03412c23          	sw	s4,56(sp)
80001098:	03512a23          	sw	s5,52(sp)
8000109c:	03612823          	sw	s6,48(sp)
800010a0:	03812423          	sw	s8,40(sp)
800010a4:	03912223          	sw	s9,36(sp)
800010a8:	03a12023          	sw	s10,32(sp)
800010ac:	01b12e23          	sw	s11,28(sp)
800010b0:	05010413          	addi	s0,sp,80
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800010b4:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
800010b8:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800010bc:	002e1793          	slli	a5,t3,0x2
800010c0:	00f78793          	addi	a5,a5,15
800010c4:	7f07f793          	andi	a5,a5,2032
800010c8:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
800010cc:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800010d0:	00010b93          	mv	s7,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800010d4:	000b8313          	mv	t1,s7
800010d8:	00378793          	addi	a5,a5,3
800010dc:	ffc7f793          	andi	a5,a5,-4
800010e0:	00fba023          	sw	a5,0(s7)
	for (i = 0; i < p->n_levels; i++) {
800010e4:	fff88c13          	addi	s8,a7,-1
800010e8:	03c8d463          	bge	a7,t3,80001110 <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
800010ec:	00088c63          	beqz	a7,80001104 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800010f0:	ffc32783          	lw	a5,-4(t1)
800010f4:	0027d793          	srli	a5,a5,0x2
800010f8:	00378793          	addi	a5,a5,3
800010fc:	ffc7f793          	andi	a5,a5,-4
80001100:	00f32023          	sw	a5,0(t1)
		}

		if (lsizes[i] < size) {
80001104:	00430313          	addi	t1,t1,4
80001108:	ffc32783          	lw	a5,-4(t1)
8000110c:	04b7fa63          	bgeu	a5,a1,80001160 <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80001110:	fff00793          	li	a5,-1
80001114:	04fc1a63          	bne	s8,a5,80001168 <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
80001118:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
8000111c:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
80001120:	fb040113          	addi	sp,s0,-80
80001124:	04c12083          	lw	ra,76(sp)
80001128:	04812403          	lw	s0,72(sp)
8000112c:	04412483          	lw	s1,68(sp)
80001130:	04012903          	lw	s2,64(sp)
80001134:	03c12983          	lw	s3,60(sp)
80001138:	03812a03          	lw	s4,56(sp)
8000113c:	03412a83          	lw	s5,52(sp)
80001140:	03012b03          	lw	s6,48(sp)
80001144:	02c12b83          	lw	s7,44(sp)
80001148:	02812c03          	lw	s8,40(sp)
8000114c:	02412c83          	lw	s9,36(sp)
80001150:	02012d03          	lw	s10,32(sp)
80001154:	01c12d83          	lw	s11,28(sp)
80001158:	05010113          	addi	sp,sp,80
8000115c:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
80001160:	00188893          	addi	a7,a7,1
80001164:	f81ff06f          	j	800010e4 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001168:	01054783          	lbu	a5,16(a0)
		return 0;
8000116c:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001170:	0017f793          	andi	a5,a5,1
80001174:	00078863          	beqz	a5,80001184 <z_sys_mem_pool_block_alloc+0x10c>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80001178:	00800913          	li	s2,8
8000117c:	30093973          	csrrc	s2,mstatus,s2
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80001180:	00897913          	andi	s2,s2,8
80001184:	00c00793          	li	a5,12
80001188:	02fc07b3          	mul	a5,s8,a5
8000118c:	fae42e23          	sw	a4,-68(s0)
80001190:	00068d13          	mv	s10,a3
80001194:	00060c93          	mv	s9,a2
80001198:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
8000119c:	000c0a13          	mv	s4,s8
800011a0:	00478713          	addi	a4,a5,4
800011a4:	00c52783          	lw	a5,12(a0)
800011a8:	00e787b3          	add	a5,a5,a4
	for (i = alloc_l; i >= 0; i--) {
800011ac:	fff00713          	li	a4,-1
	return list->head == list;
800011b0:	0007a983          	lw	s3,0(a5)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
800011b4:	17378c63          	beq	a5,s3,8000132c <z_sys_mem_pool_block_alloc+0x2b4>
	node->prev->next = node->next;
800011b8:	0009a783          	lw	a5,0(s3)
800011bc:	0049a703          	lw	a4,4(s3)
		data = block_alloc(p, i, lsizes[i]);
800011c0:	002a1a93          	slli	s5,s4,0x2
800011c4:	015b8ab3          	add	s5,s7,s5
800011c8:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
800011cc:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
800011d0:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
800011d4:	0009a223          	sw	zero,4(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800011d8:	0004a783          	lw	a5,0(s1)
		data = block_alloc(p, i, lsizes[i]);
800011dc:	000aa603          	lw	a2,0(s5)
		clear_free_bit(p, l, block_num(p, block, lsz));
800011e0:	000a0593          	mv	a1,s4
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800011e4:	40f987b3          	sub	a5,s3,a5
		clear_free_bit(p, l, block_num(p, block, lsz));
800011e8:	02c7c633          	div	a2,a5,a2
800011ec:	00048513          	mv	a0,s1
800011f0:	001a0a13          	addi	s4,s4,1
800011f4:	d4dff0ef          	jal	ra,80000f40 <clear_free_bit>
		if (data != NULL) {
800011f8:	00c00693          	li	a3,12
			for (from_l = i; from_l < alloc_l; from_l++) {
800011fc:	fffa0793          	addi	a5,s4,-1
80001200:	0587c663          	blt	a5,s8,8000124c <z_sys_mem_pool_block_alloc+0x1d4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001204:	0104c783          	lbu	a5,16(s1)
80001208:	0017f793          	andi	a5,a5,1
8000120c:	00078463          	beqz	a5,80001214 <z_sys_mem_pool_block_alloc+0x19c>
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80001210:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80001214:	fbc42783          	lw	a5,-68(s0)
		return -ENOMEM;
80001218:	ff400513          	li	a0,-12
	*data_p = data;
8000121c:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80001220:	f00980e3          	beqz	s3,80001120 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001224:	0004a783          	lw	a5,0(s1)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001228:	002c1813          	slli	a6,s8,0x2
8000122c:	010b8bb3          	add	s7,s7,a6
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001230:	40f989b3          	sub	s3,s3,a5
80001234:	000ba783          	lw	a5,0(s7)
	*level_p = alloc_l;
80001238:	018ca023          	sw	s8,0(s9)
	return 0;
8000123c:	00000513          	li	a0,0
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001240:	02f9c9b3          	div	s3,s3,a5
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001244:	013d2023          	sw	s3,0(s10)
	return 0;
80001248:	ed9ff06f          	j	80001120 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000124c:	0004ad83          	lw	s11,0(s1)
80001250:	000aa783          	lw	a5,0(s5)
80001254:	02da0eb3          	mul	t4,s4,a3
80001258:	41b98db3          	sub	s11,s3,s11
	for (i = 1; i < 4; i++) {
8000125c:	00100713          	li	a4,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001260:	02fdcdb3          	div	s11,s11,a5
		int lbn = 4*bn + i;
80001264:	002d9d93          	slli	s11,s11,0x2
		int lsz = lsizes[l + 1];
80001268:	004aab03          	lw	s6,4(s5)
		set_free_bit(p, l + 1, lbn);
8000126c:	01b70633          	add	a2,a4,s11
80001270:	000a0593          	mv	a1,s4
		void *block2 = (lsz * i) + (char *)block;
80001274:	02eb0e33          	mul	t3,s6,a4
		set_free_bit(p, l + 1, lbn);
80001278:	00048513          	mv	a0,s1
8000127c:	fbd42823          	sw	t4,-80(s0)
80001280:	fae42c23          	sw	a4,-72(s0)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001284:	fffb0b13          	addi	s6,s6,-1
		void *block2 = (lsz * i) + (char *)block;
80001288:	01c98e33          	add	t3,s3,t3
8000128c:	fbc42a23          	sw	t3,-76(s0)
		set_free_bit(p, l + 1, lbn);
80001290:	c7dff0ef          	jal	ra,80000f0c <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001294:	fb442e03          	lw	t3,-76(s0)
80001298:	0004a783          	lw	a5,0(s1)
	return p->n_max * p->max_sz;
8000129c:	0044a603          	lw	a2,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800012a0:	016e0b33          	add	s6,t3,s6
800012a4:	40fb0b33          	sub	s6,s6,a5
	return p->n_max * p->max_sz;
800012a8:	0084d783          	lhu	a5,8(s1)
		if (block_fits(p, block2, lsz)) {
800012ac:	fb842703          	lw	a4,-72(s0)
800012b0:	fb042e83          	lw	t4,-80(s0)
	return p->n_max * p->max_sz;
800012b4:	02c787b3          	mul	a5,a5,a2
		if (block_fits(p, block2, lsz)) {
800012b8:	00c00693          	li	a3,12
800012bc:	00400893          	li	a7,4
800012c0:	00800313          	li	t1,8
800012c4:	02fb7463          	bgeu	s6,a5,800012ec <z_sys_mem_pool_block_alloc+0x274>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
800012c8:	00c4a783          	lw	a5,12(s1)
800012cc:	01d787b3          	add	a5,a5,t4
800012d0:	00478613          	addi	a2,a5,4
	node->next = list;
800012d4:	00ce2023          	sw	a2,0(t3)
	node->prev = list->tail;
800012d8:	0087a603          	lw	a2,8(a5)
800012dc:	00ce2223          	sw	a2,4(t3)
	list->tail->next = node;
800012e0:	0087a603          	lw	a2,8(a5)
800012e4:	01c62023          	sw	t3,0(a2)
	list->tail = node;
800012e8:	01c7a423          	sw	t3,8(a5)
	for (i = 1; i < 4; i++) {
800012ec:	00170713          	addi	a4,a4,1
800012f0:	f7171ce3          	bne	a4,a7,80001268 <z_sys_mem_pool_block_alloc+0x1f0>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800012f4:	0104c783          	lbu	a5,16(s1)
800012f8:	0017f793          	andi	a5,a5,1
800012fc:	00079a63          	bnez	a5,80001310 <z_sys_mem_pool_block_alloc+0x298>
		return 0;
80001300:	00000913          	li	s2,0
80001304:	001a0a13          	addi	s4,s4,1
80001308:	004a8a93          	addi	s5,s5,4
8000130c:	ef1ff06f          	j	800011fc <z_sys_mem_pool_block_alloc+0x184>
80001310:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001314:	0104c783          	lbu	a5,16(s1)
80001318:	0017f793          	andi	a5,a5,1
8000131c:	fe0782e3          	beqz	a5,80001300 <z_sys_mem_pool_block_alloc+0x288>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001320:	30033973          	csrrc	s2,mstatus,t1
	key = (mstatus & SOC_MSTATUS_IEN);
80001324:	00897913          	andi	s2,s2,8
80001328:	fddff06f          	j	80001304 <z_sys_mem_pool_block_alloc+0x28c>
	for (i = alloc_l; i >= 0; i--) {
8000132c:	fffa0a13          	addi	s4,s4,-1
80001330:	ff498793          	addi	a5,s3,-12
80001334:	e6ea1ee3          	bne	s4,a4,800011b0 <z_sys_mem_pool_block_alloc+0x138>
80001338:	00000993          	li	s3,0
8000133c:	ec9ff06f          	j	80001204 <z_sys_mem_pool_block_alloc+0x18c>

80001340 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001340:	fa010113          	addi	sp,sp,-96
80001344:	04812c23          	sw	s0,88(sp)
80001348:	05312623          	sw	s3,76(sp)
8000134c:	03712e23          	sw	s7,60(sp)
80001350:	04112e23          	sw	ra,92(sp)
80001354:	04912a23          	sw	s1,84(sp)
80001358:	05212823          	sw	s2,80(sp)
8000135c:	05412423          	sw	s4,72(sp)
80001360:	05512223          	sw	s5,68(sp)
80001364:	05612023          	sw	s6,64(sp)
80001368:	03812c23          	sw	s8,56(sp)
8000136c:	03912a23          	sw	s9,52(sp)
80001370:	03a12823          	sw	s10,48(sp)
80001374:	03b12623          	sw	s11,44(sp)
80001378:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000137c:	00a54683          	lbu	a3,10(a0)
{
80001380:	00050b93          	mv	s7,a0
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 1; i <= level; i++) {
80001384:	00100813          	li	a6,1
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001388:	00269693          	slli	a3,a3,0x2
8000138c:	00f68693          	addi	a3,a3,15
80001390:	7f06f693          	andi	a3,a3,2032
80001394:	40d10133          	sub	sp,sp,a3
	lsizes[0] = _ALIGN4(p->max_sz);
80001398:	00452683          	lw	a3,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000139c:	00010993          	mv	s3,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800013a0:	00098513          	mv	a0,s3
800013a4:	00368693          	addi	a3,a3,3
800013a8:	ffc6f693          	andi	a3,a3,-4
800013ac:	00d9a023          	sw	a3,0(s3)
	for (i = 1; i <= level; i++) {
800013b0:	00450513          	addi	a0,a0,4
800013b4:	0d05f463          	bgeu	a1,a6,8000147c <z_sys_mem_pool_block_free+0x13c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013b8:	010bc683          	lbu	a3,16(s7)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
800013bc:	00058c13          	mv	s8,a1
800013c0:	00060913          	mv	s2,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013c4:	0016f693          	andi	a3,a3,1
		return 0;
800013c8:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013cc:	00068863          	beqz	a3,800013dc <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800013d0:	00800493          	li	s1,8
800013d4:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
800013d8:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800013dc:	80006ab7          	lui	s5,0x80006
		sys_dlist_append(&p->levels[level].free_list, block);
800013e0:	00c00d13          	li	s10,12
	__asm__ volatile ("csrrc %0, mstatus, %1"
800013e4:	00800d93          	li	s11,8
	while (level >= 0) {
800013e8:	0a0c5863          	bgez	s8,80001498 <z_sys_mem_pool_block_free+0x158>
	__ASSERT(0, "out of levels");
800013ec:	800064b7          	lui	s1,0x80006
800013f0:	800065b7          	lui	a1,0x80006
800013f4:	80006537          	lui	a0,0x80006
800013f8:	44448613          	addi	a2,s1,1092 # 80006444 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006445>
800013fc:	0c000693          	li	a3,192
80001400:	4ac58593          	addi	a1,a1,1196 # 800064ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ad>
80001404:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80001408:	0c1000ef          	jal	ra,80001cc8 <printk>
8000140c:	80006537          	lui	a0,0x80006
80001410:	47850513          	addi	a0,a0,1144 # 80006478 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006479>
80001414:	0b5000ef          	jal	ra,80001cc8 <printk>
80001418:	44448513          	addi	a0,s1,1092
8000141c:	0c000593          	li	a1,192
80001420:	0e5000ef          	jal	ra,80001d04 <assert_post_action>
	return -1;
80001424:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001428:	010bc783          	lbu	a5,16(s7)
8000142c:	0017f793          	andi	a5,a5,1
80001430:	00078663          	beqz	a5,8000143c <z_sys_mem_pool_block_free+0xfc>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80001434:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001438:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000143c:	fa040113          	addi	sp,s0,-96
80001440:	05c12083          	lw	ra,92(sp)
80001444:	05812403          	lw	s0,88(sp)
80001448:	05412483          	lw	s1,84(sp)
8000144c:	05012903          	lw	s2,80(sp)
80001450:	04c12983          	lw	s3,76(sp)
80001454:	04812a03          	lw	s4,72(sp)
80001458:	04412a83          	lw	s5,68(sp)
8000145c:	04012b03          	lw	s6,64(sp)
80001460:	03c12b83          	lw	s7,60(sp)
80001464:	03812c03          	lw	s8,56(sp)
80001468:	03412c83          	lw	s9,52(sp)
8000146c:	03012d03          	lw	s10,48(sp)
80001470:	02c12d83          	lw	s11,44(sp)
80001474:	06010113          	addi	sp,sp,96
80001478:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000147c:	ffc52683          	lw	a3,-4(a0)
	for (i = 1; i <= level; i++) {
80001480:	00180813          	addi	a6,a6,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001484:	0026d693          	srli	a3,a3,0x2
80001488:	00368693          	addi	a3,a3,3
8000148c:	ffc6f693          	andi	a3,a3,-4
80001490:	00d52023          	sw	a3,0(a0)
80001494:	f1dff06f          	j	800013b0 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
80001498:	002c1693          	slli	a3,s8,0x2
8000149c:	00d986b3          	add	a3,s3,a3
800014a0:	0006aa03          	lw	s4,0(a3)
	return p->n_max * p->max_sz;
800014a4:	008bd603          	lhu	a2,8(s7)
800014a8:	004ba583          	lw	a1,4(s7)
	return (u8_t *)p->buf + lsz * block;
800014ac:	034906b3          	mul	a3,s2,s4
		void *block = block_ptr(p, lsz, bn);
800014b0:	000ba803          	lw	a6,0(s7)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800014b4:	fffa0b13          	addi	s6,s4,-1
	return p->n_max * p->max_sz;
800014b8:	02b60633          	mul	a2,a2,a1
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800014bc:	00d80cb3          	add	s9,a6,a3
800014c0:	00db06b3          	add	a3,s6,a3
		__ASSERT(block_fits(p, block, lsz), "");
800014c4:	02c6ec63          	bltu	a3,a2,800014fc <z_sys_mem_pool_block_free+0x1bc>
800014c8:	800067b7          	lui	a5,0x80006
800014cc:	45878593          	addi	a1,a5,1112 # 80006458 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006459>
800014d0:	800067b7          	lui	a5,0x80006
800014d4:	3f078513          	addi	a0,a5,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800014d8:	0a400693          	li	a3,164
800014dc:	444a8613          	addi	a2,s5,1092 # 80006444 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006445>
800014e0:	7e8000ef          	jal	ra,80001cc8 <printk>
800014e4:	800067b7          	lui	a5,0x80006
800014e8:	47478513          	addi	a0,a5,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
800014ec:	7dc000ef          	jal	ra,80001cc8 <printk>
800014f0:	0a400593          	li	a1,164
800014f4:	444a8513          	addi	a0,s5,1092
800014f8:	00d000ef          	jal	ra,80001d04 <assert_post_action>
		set_free_bit(p, level, bn);
800014fc:	00090613          	mv	a2,s2
80001500:	000c0593          	mv	a1,s8
80001504:	000b8513          	mv	a0,s7
80001508:	a05ff0ef          	jal	ra,80000f0c <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
8000150c:	03ac06b3          	mul	a3,s8,s10
80001510:	00cba603          	lw	a2,12(s7)
80001514:	00d606b3          	add	a3,a2,a3
80001518:	00468613          	addi	a2,a3,4
	node->next = list;
8000151c:	00cca023          	sw	a2,0(s9)
	node->prev = list->tail;
80001520:	0086a603          	lw	a2,8(a3)
80001524:	00cca223          	sw	a2,4(s9)
	list->tail->next = node;
80001528:	0086a603          	lw	a2,8(a3)
8000152c:	01962023          	sw	s9,0(a2)
	list->tail = node;
80001530:	0196a423          	sw	s9,8(a3)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001534:	010bc683          	lbu	a3,16(s7)
80001538:	0016f693          	andi	a3,a3,1
8000153c:	0c069463          	bnez	a3,80001604 <z_sys_mem_pool_block_free+0x2c4>
		return 0;
80001540:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001544:	ee0c02e3          	beqz	s8,80001428 <z_sys_mem_pool_block_free+0xe8>
	int bit = get_bit_ptr(p, level, bn, &word);
80001548:	fbc40693          	addi	a3,s0,-68
8000154c:	00090613          	mv	a2,s2
80001550:	000c0593          	mv	a1,s8
80001554:	000b8513          	mv	a0,s7
80001558:	97dff0ef          	jal	ra,80000ed4 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
8000155c:	00400693          	li	a3,4
80001560:	02d546b3          	div	a3,a0,a3
80001564:	fbc42603          	lw	a2,-68(s0)
80001568:	00062503          	lw	a0,0(a2)
8000156c:	00269693          	slli	a3,a3,0x2
80001570:	00d55533          	srl	a0,a0,a3
80001574:	00f57513          	andi	a0,a0,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001578:	00f00693          	li	a3,15
8000157c:	ead516e3          	bne	a0,a3,80001428 <z_sys_mem_pool_block_free+0xe8>
		for (i = 0; i < 4; i++) {
80001580:	00000813          	li	a6,0
			int b = (bn & ~3) + i;
80001584:	ffc97e13          	andi	t3,s2,-4
		for (i = 0; i < 4; i++) {
80001588:	00400313          	li	t1,4
	return p->n_max * p->max_sz;
8000158c:	008bd583          	lhu	a1,8(s7)
80001590:	004ba503          	lw	a0,4(s7)
			int b = (bn & ~3) + i;
80001594:	010e0633          	add	a2,t3,a6
	return (u8_t *)p->buf + lsz * block;
80001598:	034608b3          	mul	a7,a2,s4
	return p->n_max * p->max_sz;
8000159c:	02a585b3          	mul	a1,a1,a0
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800015a0:	016886b3          	add	a3,a7,s6
800015a4:	04b6f663          	bgeu	a3,a1,800015f0 <z_sys_mem_pool_block_free+0x2b0>
				clear_free_bit(p, level, b);
800015a8:	000c0593          	mv	a1,s8
800015ac:	000b8513          	mv	a0,s7
800015b0:	fbc42223          	sw	t3,-92(s0)
800015b4:	fb042423          	sw	a6,-88(s0)
800015b8:	fb142623          	sw	a7,-84(s0)
800015bc:	985ff0ef          	jal	ra,80000f40 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
800015c0:	000ba683          	lw	a3,0(s7)
800015c4:	fac42883          	lw	a7,-84(s0)
	node->prev = NULL;
800015c8:	fa442e03          	lw	t3,-92(s0)
800015cc:	fa842803          	lw	a6,-88(s0)
800015d0:	011686b3          	add	a3,a3,a7
	node->prev->next = node->next;
800015d4:	0046a583          	lw	a1,4(a3)
800015d8:	0006a603          	lw	a2,0(a3)
	node->prev = NULL;
800015dc:	00400313          	li	t1,4
	node->prev->next = node->next;
800015e0:	00c5a023          	sw	a2,0(a1)
	node->next->prev = node->prev;
800015e4:	00b62223          	sw	a1,4(a2)
	node->next = NULL;
800015e8:	0006a023          	sw	zero,0(a3)
	node->prev = NULL;
800015ec:	0006a223          	sw	zero,4(a3)
		for (i = 0; i < 4; i++) {
800015f0:	00180813          	addi	a6,a6,1
800015f4:	f8681ce3          	bne	a6,t1,8000158c <z_sys_mem_pool_block_free+0x24c>
		level = level - 1;
800015f8:	fffc0c13          	addi	s8,s8,-1
		bn = bn / 4;
800015fc:	03094933          	div	s2,s2,a6
80001600:	de9ff06f          	j	800013e8 <z_sys_mem_pool_block_free+0xa8>
80001604:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001608:	010bc683          	lbu	a3,16(s7)
8000160c:	0016f693          	andi	a3,a3,1
80001610:	f20688e3          	beqz	a3,80001540 <z_sys_mem_pool_block_free+0x200>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001614:	300db4f3          	csrrc	s1,mstatus,s11
	key = (mstatus & SOC_MSTATUS_IEN);
80001618:	0084f493          	andi	s1,s1,8
8000161c:	f29ff06f          	j	80001544 <z_sys_mem_pool_block_free+0x204>

80001620 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001620:	ff010113          	addi	sp,sp,-16
80001624:	00050793          	mv	a5,a0
80001628:	00058513          	mv	a0,a1
8000162c:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001630:	00068613          	mv	a2,a3
{
80001634:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001638:	000780e7          	jalr	a5
8000163c:	4fd020ef          	jal	ra,80004338 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001640:	4f4030ef          	jal	ra,80004b34 <z_impl_k_thread_abort>

80001644 <z_work_q_main>:

#include <kernel.h>
#define WORKQUEUE_THREAD_NAME	"workqueue"

void z_work_q_main(void *work_q_ptr, void *p2, void *p3)
{
80001644:	ff010113          	addi	sp,sp,-16
80001648:	00912223          	sw	s1,4(sp)
8000164c:	00112623          	sw	ra,12(sp)
80001650:	00812423          	sw	s0,8(sp)
80001654:	01212023          	sw	s2,0(sp)
80001658:	00050493          	mv	s1,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
8000165c:	fff00593          	li	a1,-1
80001660:	00048513          	mv	a0,s1
80001664:	5f8010ef          	jal	ra,80002c5c <z_impl_k_queue_get>
80001668:	00050413          	mv	s0,a0
	while (true) {
		struct k_work *work;
		k_work_handler_t handler;

		work = k_queue_get(&work_q->queue, K_FOREVER);
		if (work == NULL) {
8000166c:	fe0508e3          	beqz	a0,8000165c <z_work_q_main+0x18>
			continue;
		}

		handler = work->handler;
80001670:	00452903          	lw	s2,4(a0)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_XOR, atomic_xor, atomic_val_t, atomic_t *, target, atomic_val_t, value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_AND, atomic_and, atomic_val_t, atomic_t *, target, atomic_val_t, value)
80001674:	ffe00593          	li	a1,-2
80001678:	00850513          	addi	a0,a0,8
8000167c:	080040ef          	jal	ra,800056fc <z_impl_atomic_and>
	return (old & mask) != 0;
80001680:	00157513          	andi	a0,a0,1

		/* Reset pending state so it can be resubmitted by handler */
		if (atomic_test_and_clear_bit(work->flags,
80001684:	00050663          	beqz	a0,80001690 <z_work_q_main+0x4c>
					      K_WORK_STATE_PENDING)) {
			handler(work);
80001688:	00040513          	mv	a0,s0
8000168c:	000900e7          	jalr	s2
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80001690:	2b1020ef          	jal	ra,80004140 <z_impl_k_yield>
80001694:	fc9ff06f          	j	8000165c <z_work_q_main+0x18>

80001698 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001698:	00000513          	li	a0,0
8000169c:	00008067          	ret

800016a0 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
800016a0:	ff010113          	addi	sp,sp,-16
800016a4:	00812423          	sw	s0,8(sp)
800016a8:	00050413          	mv	s0,a0
	out('E', ctx);
800016ac:	04500513          	li	a0,69
{
800016b0:	00112623          	sw	ra,12(sp)
800016b4:	00912223          	sw	s1,4(sp)
800016b8:	00058493          	mv	s1,a1
	out('E', ctx);
800016bc:	000400e7          	jalr	s0
	out('R', ctx);
800016c0:	00048593          	mv	a1,s1
800016c4:	05200513          	li	a0,82
800016c8:	000400e7          	jalr	s0
	out('R', ctx);
800016cc:	00040313          	mv	t1,s0
}
800016d0:	00812403          	lw	s0,8(sp)
800016d4:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
800016d8:	00048593          	mv	a1,s1
}
800016dc:	00412483          	lw	s1,4(sp)
	out('R', ctx);
800016e0:	05200513          	li	a0,82
}
800016e4:	01010113          	addi	sp,sp,16
	out('R', ctx);
800016e8:	00030067          	jr	t1

800016ec <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
800016ec:	0005a783          	lw	a5,0(a1)
800016f0:	00178793          	addi	a5,a5,1
800016f4:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
800016f8:	800077b7          	lui	a5,0x80007
800016fc:	9987a303          	lw	t1,-1640(a5) # 80006998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006999>
80001700:	00030067          	jr	t1

80001704 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001704:	fb010113          	addi	sp,sp,-80
80001708:	04812423          	sw	s0,72(sp)
8000170c:	03312e23          	sw	s3,60(sp)
80001710:	03412c23          	sw	s4,56(sp)
80001714:	03512a23          	sw	s5,52(sp)
80001718:	03612823          	sw	s6,48(sp)
8000171c:	04112623          	sw	ra,76(sp)
80001720:	04912223          	sw	s1,68(sp)
80001724:	05212023          	sw	s2,64(sp)
80001728:	03712623          	sw	s7,44(sp)
8000172c:	03812423          	sw	s8,40(sp)
80001730:	03912223          	sw	s9,36(sp)
80001734:	03a12023          	sw	s10,32(sp)
80001738:	01b12e23          	sw	s11,28(sp)
8000173c:	00050a13          	mv	s4,a0
80001740:	00058a93          	mv	s5,a1
80001744:	00060993          	mv	s3,a2
80001748:	00068b13          	mv	s6,a3
8000174c:	00100413          	li	s0,1
80001750:	00e05463          	blez	a4,80001758 <_printk_dec_ulong+0x54>
80001754:	00070413          	mv	s0,a4
80001758:	00100793          	li	a5,1
8000175c:	02000c13          	li	s8,32
80001760:	00fb1463          	bne	s6,a5,80001768 <_printk_dec_ulong+0x64>
80001764:	03000c13          	li	s8,48
80001768:	3b9ad4b7          	lui	s1,0x3b9ad
8000176c:	00100913          	li	s2,1
80001770:	00a00c93          	li	s9,10
80001774:	00000713          	li	a4,0
80001778:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
8000177c:	00200d93          	li	s11,2
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
		pos /= 10;
80001780:	00a00d13          	li	s10,10
		if (found_largest_digit != 0 || remainder > pos) {
80001784:	00148b93          	addi	s7,s1,1
80001788:	00071463          	bnez	a4,80001790 <_printk_dec_ulong+0x8c>
8000178c:	0934f263          	bgeu	s1,s3,80001810 <_printk_dec_ulong+0x10c>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001790:	0379d533          	divu	a0,s3,s7
80001794:	000a8593          	mv	a1,s5
			digits++;
80001798:	00190913          	addi	s2,s2,1
			out((int)((remainder / (pos + 1)) + 48), ctx);
8000179c:	03050513          	addi	a0,a0,48
800017a0:	000a00e7          	jalr	s4
			found_largest_digit = 1;
800017a4:	00100713          	li	a4,1
		remaining--;
800017a8:	fffc8c93          	addi	s9,s9,-1
	while (pos >= 9) {
800017ac:	00100793          	li	a5,1
		remainder %= (pos + 1);
800017b0:	0379f9b3          	remu	s3,s3,s7
		pos /= 10;
800017b4:	03a4d4b3          	divu	s1,s1,s10
	while (pos >= 9) {
800017b8:	fcfc96e3          	bne	s9,a5,80001784 <_printk_dec_ulong+0x80>
	}
	out((int)(remainder + 48), ctx);
800017bc:	000a8593          	mv	a1,s5
800017c0:	03098513          	addi	a0,s3,48
800017c4:	000a00e7          	jalr	s4

	if (padding == PAD_SPACE_AFTER) {
800017c8:	00300793          	li	a5,3
		remaining = min_width - digits;
800017cc:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
800017d0:	06fb0a63          	beq	s6,a5,80001844 <_printk_dec_ulong+0x140>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
800017d4:	04c12083          	lw	ra,76(sp)
800017d8:	04812403          	lw	s0,72(sp)
800017dc:	04412483          	lw	s1,68(sp)
800017e0:	04012903          	lw	s2,64(sp)
800017e4:	03c12983          	lw	s3,60(sp)
800017e8:	03812a03          	lw	s4,56(sp)
800017ec:	03412a83          	lw	s5,52(sp)
800017f0:	03012b03          	lw	s6,48(sp)
800017f4:	02c12b83          	lw	s7,44(sp)
800017f8:	02812c03          	lw	s8,40(sp)
800017fc:	02412c83          	lw	s9,36(sp)
80001800:	02012d03          	lw	s10,32(sp)
80001804:	01c12d83          	lw	s11,28(sp)
80001808:	05010113          	addi	sp,sp,80
8000180c:	00008067          	ret
		} else if (remaining <= min_width
80001810:	f9944ce3          	blt	s0,s9,800017a8 <_printk_dec_ulong+0xa4>
				&& padding < PAD_SPACE_AFTER) {
80001814:	f96deae3          	bltu	s11,s6,800017a8 <_printk_dec_ulong+0xa4>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001818:	000a8593          	mv	a1,s5
8000181c:	000c0513          	mv	a0,s8
80001820:	00e12623          	sw	a4,12(sp)
80001824:	000a00e7          	jalr	s4
			digits++;
80001828:	00190913          	addi	s2,s2,1
8000182c:	00c12703          	lw	a4,12(sp)
80001830:	f79ff06f          	j	800017a8 <_printk_dec_ulong+0xa4>
			out(' ', ctx);
80001834:	000a8593          	mv	a1,s5
80001838:	02000513          	li	a0,32
8000183c:	000a00e7          	jalr	s4
80001840:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
80001844:	fe8048e3          	bgtz	s0,80001834 <_printk_dec_ulong+0x130>
80001848:	f8dff06f          	j	800017d4 <_printk_dec_ulong+0xd0>

8000184c <__printk_hook_install>:
	_char_out = fn;
8000184c:	800077b7          	lui	a5,0x80007
80001850:	98a7ac23          	sw	a0,-1640(a5) # 80006998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006999>
}
80001854:	00008067          	ret

80001858 <z_vprintk>:
{
80001858:	fb010113          	addi	sp,sp,-80
8000185c:	04812423          	sw	s0,72(sp)
80001860:	04912223          	sw	s1,68(sp)
80001864:	05212023          	sw	s2,64(sp)
80001868:	03312e23          	sw	s3,60(sp)
8000186c:	03412c23          	sw	s4,56(sp)
80001870:	03512a23          	sw	s5,52(sp)
80001874:	03912223          	sw	s9,36(sp)
80001878:	03a12023          	sw	s10,32(sp)
8000187c:	01b12e23          	sw	s11,28(sp)
80001880:	04112623          	sw	ra,76(sp)
80001884:	03612823          	sw	s6,48(sp)
80001888:	03712623          	sw	s7,44(sp)
8000188c:	03812423          	sw	s8,40(sp)
80001890:	00050413          	mv	s0,a0
80001894:	00058493          	mv	s1,a1
80001898:	00060a93          	mv	s5,a2
8000189c:	00068d13          	mv	s10,a3
	int long_ctr = 0;
800018a0:	00000a13          	li	s4,0
	int min_width = -1;
800018a4:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
800018a8:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800018ac:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
800018b0:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800018b4:	000ac503          	lbu	a0,0(s5)
800018b8:	04051063          	bnez	a0,800018f8 <z_vprintk+0xa0>
}
800018bc:	04c12083          	lw	ra,76(sp)
800018c0:	04812403          	lw	s0,72(sp)
800018c4:	04412483          	lw	s1,68(sp)
800018c8:	04012903          	lw	s2,64(sp)
800018cc:	03c12983          	lw	s3,60(sp)
800018d0:	03812a03          	lw	s4,56(sp)
800018d4:	03412a83          	lw	s5,52(sp)
800018d8:	03012b03          	lw	s6,48(sp)
800018dc:	02c12b83          	lw	s7,44(sp)
800018e0:	02812c03          	lw	s8,40(sp)
800018e4:	02412c83          	lw	s9,36(sp)
800018e8:	02012d03          	lw	s10,32(sp)
800018ec:	01c12d83          	lw	s11,28(sp)
800018f0:	05010113          	addi	sp,sp,80
800018f4:	00008067          	ret
		if (!might_format) {
800018f8:	000c9e63          	bnez	s9,80001914 <z_vprintk+0xbc>
			if (*fmt != '%') {
800018fc:	02500693          	li	a3,37
80001900:	36d50a63          	beq	a0,a3,80001c74 <z_vprintk+0x41c>
				out((int)*fmt, ctx);
80001904:	00048593          	mv	a1,s1
80001908:	000400e7          	jalr	s0
		++fmt;
8000190c:	001a8a93          	addi	s5,s5,1
80001910:	fa5ff06f          	j	800018b4 <z_vprintk+0x5c>
			switch (*fmt) {
80001914:	06400693          	li	a3,100
80001918:	10d50e63          	beq	a0,a3,80001a34 <z_vprintk+0x1dc>
8000191c:	06a6e263          	bltu	a3,a0,80001980 <z_vprintk+0x128>
80001920:	03900693          	li	a3,57
80001924:	02a6ea63          	bltu	a3,a0,80001958 <z_vprintk+0x100>
80001928:	03100693          	li	a3,49
8000192c:	0ed57463          	bgeu	a0,a3,80001a14 <z_vprintk+0x1bc>
80001930:	02d00693          	li	a3,45
80001934:	34d50a63          	beq	a0,a3,80001c88 <z_vprintk+0x430>
80001938:	03000793          	li	a5,48
8000193c:	0cf50063          	beq	a0,a5,800019fc <z_vprintk+0x1a4>
80001940:	02500713          	li	a4,37
80001944:	02e51263          	bne	a0,a4,80001968 <z_vprintk+0x110>
				out((int)'%', ctx);
80001948:	00048593          	mv	a1,s1
8000194c:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001950:	000400e7          	jalr	s0
				break;
80001954:	15c0006f          	j	80001ab0 <z_vprintk+0x258>
80001958:	05800693          	li	a3,88
8000195c:	1ad50e63          	beq	a0,a3,80001b18 <z_vprintk+0x2c0>
80001960:	06300713          	li	a4,99
80001964:	2ee50e63          	beq	a0,a4,80001c60 <z_vprintk+0x408>
				out((int)'%', ctx);
80001968:	00048593          	mv	a1,s1
8000196c:	02500513          	li	a0,37
80001970:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001974:	00048593          	mv	a1,s1
80001978:	000ac503          	lbu	a0,0(s5)
8000197c:	fd5ff06f          	j	80001950 <z_vprintk+0xf8>
80001980:	07000693          	li	a3,112
80001984:	16d50a63          	beq	a0,a3,80001af8 <z_vprintk+0x2a0>
80001988:	02a6e063          	bltu	a3,a0,800019a8 <z_vprintk+0x150>
8000198c:	06900693          	li	a3,105
80001990:	0ad50263          	beq	a0,a3,80001a34 <z_vprintk+0x1dc>
80001994:	06c00693          	li	a3,108
80001998:	08d50a63          	beq	a0,a3,80001a2c <z_vprintk+0x1d4>
8000199c:	06800693          	li	a3,104
800019a0:	f6d506e3          	beq	a0,a3,8000190c <z_vprintk+0xb4>
800019a4:	fc5ff06f          	j	80001968 <z_vprintk+0x110>
800019a8:	07500693          	li	a3,117
800019ac:	10d50663          	beq	a0,a3,80001ab8 <z_vprintk+0x260>
800019b0:	02a6ee63          	bltu	a3,a0,800019ec <z_vprintk+0x194>
800019b4:	07300713          	li	a4,115
800019b8:	fae518e3          	bne	a0,a4,80001968 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
800019bc:	000d2c03          	lw	s8,0(s10)
800019c0:	004d0b13          	addi	s6,s10,4
800019c4:	000c0b93          	mv	s7,s8
				while (*s)
800019c8:	000bc503          	lbu	a0,0(s7)
800019cc:	26051863          	bnez	a0,80001c3c <z_vprintk+0x3e4>
				if (padding == PAD_SPACE_AFTER) {
800019d0:	00300793          	li	a5,3
800019d4:	00f99863          	bne	s3,a5,800019e4 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
800019d8:	418b8bb3          	sub	s7,s7,s8
800019dc:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800019e0:	27704663          	bgtz	s7,80001c4c <z_vprintk+0x3f4>
				char *s = va_arg(ap, char *);
800019e4:	000b0d13          	mv	s10,s6
800019e8:	0c80006f          	j	80001ab0 <z_vprintk+0x258>
800019ec:	07800693          	li	a3,120
800019f0:	12d50463          	beq	a0,a3,80001b18 <z_vprintk+0x2c0>
800019f4:	07a00693          	li	a3,122
800019f8:	fa9ff06f          	j	800019a0 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
800019fc:	00095e63          	bgez	s2,80001a18 <z_vprintk+0x1c0>
80001a00:	28098863          	beqz	s3,80001c90 <z_vprintk+0x438>
					min_width = *fmt - '0';
80001a04:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001a08:	f00992e3          	bnez	s3,8000190c <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001a0c:	00200993          	li	s3,2
80001a10:	efdff06f          	j	8000190c <z_vprintk+0xb4>
				if (min_width < 0) {
80001a14:	fe0948e3          	bltz	s2,80001a04 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001a18:	00a00693          	li	a3,10
80001a1c:	02d90933          	mul	s2,s2,a3
80001a20:	fd090913          	addi	s2,s2,-48
80001a24:	01250933          	add	s2,a0,s2
80001a28:	fe1ff06f          	j	80001a08 <z_vprintk+0x1b0>
				long_ctr++;
80001a2c:	001a0a13          	addi	s4,s4,1
80001a30:	eddff06f          	j	8000190c <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001a34:	040a1263          	bnez	s4,80001a78 <z_vprintk+0x220>
					long ld = va_arg(ap, long);
80001a38:	000d2603          	lw	a2,0(s10)
80001a3c:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001a40:	02065063          	bgez	a2,80001a60 <z_vprintk+0x208>
					out((int)'-', ctx);
80001a44:	00048593          	mv	a1,s1
80001a48:	02d00513          	li	a0,45
80001a4c:	00c12023          	sw	a2,0(sp)
80001a50:	000400e7          	jalr	s0
					d = -d;
80001a54:	00012603          	lw	a2,0(sp)
					min_width--;
80001a58:	fff90913          	addi	s2,s2,-1
					d = -d;
80001a5c:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001a60:	00090713          	mv	a4,s2
80001a64:	00098693          	mv	a3,s3
80001a68:	00048593          	mv	a1,s1
80001a6c:	00040513          	mv	a0,s0
80001a70:	c95ff0ef          	jal	ra,80001704 <_printk_dec_ulong>
				break;
80001a74:	03c0006f          	j	80001ab0 <z_vprintk+0x258>
				} else if (long_ctr == 1) {
80001a78:	00100713          	li	a4,1
80001a7c:	faea0ee3          	beq	s4,a4,80001a38 <z_vprintk+0x1e0>
					long long lld = va_arg(ap, long long);
80001a80:	007d0793          	addi	a5,s10,7
80001a84:	ff87f713          	andi	a4,a5,-8
80001a88:	00072603          	lw	a2,0(a4)
80001a8c:	00472683          	lw	a3,4(a4)
80001a90:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001a94:	01b60733          	add	a4,a2,s11
80001a98:	00c73733          	sltu	a4,a4,a2
80001a9c:	00d70733          	add	a4,a4,a3
80001aa0:	fa0700e3          	beqz	a4,80001a40 <z_vprintk+0x1e8>
						print_err(out, ctx);
80001aa4:	00048593          	mv	a1,s1
80001aa8:	00040513          	mv	a0,s0
80001aac:	bf5ff0ef          	jal	ra,800016a0 <print_err>
			might_format = 0;
80001ab0:	00000c93          	li	s9,0
80001ab4:	e59ff06f          	j	8000190c <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001ab8:	000a1863          	bnez	s4,80001ac8 <z_vprintk+0x270>
					long lu = va_arg(ap, unsigned long);
80001abc:	000d2603          	lw	a2,0(s10)
80001ac0:	004d0d13          	addi	s10,s10,4
80001ac4:	f9dff06f          	j	80001a60 <z_vprintk+0x208>
				} else if (long_ctr == 1) {
80001ac8:	00100713          	li	a4,1
80001acc:	feea08e3          	beq	s4,a4,80001abc <z_vprintk+0x264>
					unsigned long long llu =
80001ad0:	007d0793          	addi	a5,s10,7
80001ad4:	ff87f713          	andi	a4,a5,-8
80001ad8:	00870d13          	addi	s10,a4,8
80001adc:	00072603          	lw	a2,0(a4)
80001ae0:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001ae4:	fc0710e3          	bnez	a4,80001aa4 <z_vprintk+0x24c>
80001ae8:	800007b7          	lui	a5,0x80000
80001aec:	fff7c793          	not	a5,a5
80001af0:	f6c7f8e3          	bgeu	a5,a2,80001a60 <z_vprintk+0x208>
80001af4:	fb1ff06f          	j	80001aa4 <z_vprintk+0x24c>
				  out('0', ctx);
80001af8:	00048593          	mv	a1,s1
80001afc:	03000513          	li	a0,48
80001b00:	000400e7          	jalr	s0
				  out('x', ctx);
80001b04:	00048593          	mv	a1,s1
80001b08:	07800513          	li	a0,120
80001b0c:	000400e7          	jalr	s0
				  min_width = 8;
80001b10:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001b14:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001b18:	00100693          	li	a3,1
80001b1c:	0b46c263          	blt	a3,s4,80001bc0 <z_vprintk+0x368>
					x = va_arg(ap, unsigned long);
80001b20:	000d2783          	lw	a5,0(s10)
80001b24:	00012423          	sw	zero,8(sp)
80001b28:	004d0d13          	addi	s10,s10,4
80001b2c:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001b30:	01000c13          	li	s8,16
	int digits = 0;
80001b34:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80001b38:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001b3c:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001b40:	00412503          	lw	a0,4(sp)
80001b44:	00812583          	lw	a1,8(sp)
80001b48:	fff88b13          	addi	s6,a7,-1
80001b4c:	002b1613          	slli	a2,s6,0x2
80001b50:	01112623          	sw	a7,12(sp)
80001b54:	f24fe0ef          	jal	ra,80000278 <__lshrdi3>
80001b58:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001b5c:	08051863          	bnez	a0,80001bec <z_vprintk+0x394>
80001b60:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001b64:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001b68:	00079863          	bnez	a5,80001b78 <z_vprintk+0x320>
80001b6c:	00c12883          	lw	a7,12(sp)
80001b70:	00100793          	li	a5,1
80001b74:	08f89663          	bne	a7,a5,80001c00 <z_vprintk+0x3a8>
			nibble += nibble > 9 ? 87 : 48;
80001b78:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80001b7c:	01851513          	slli	a0,a0,0x18
80001b80:	00048593          	mv	a1,s1
80001b84:	41855513          	srai	a0,a0,0x18
80001b88:	000400e7          	jalr	s0
			digits++;
80001b8c:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
80001b90:	040b1863          	bnez	s6,80001be0 <z_vprintk+0x388>
	if (padding == PAD_SPACE_AFTER) {
80001b94:	00300693          	li	a3,3
			might_format = 0;
80001b98:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001b9c:	d6d998e3          	bne	s3,a3,8000190c <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
80001ba0:	00191713          	slli	a4,s2,0x1
80001ba4:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001ba8:	f17054e3          	blez	s7,80001ab0 <z_vprintk+0x258>
			out(' ', ctx);
80001bac:	00048593          	mv	a1,s1
80001bb0:	02000513          	li	a0,32
80001bb4:	000400e7          	jalr	s0
80001bb8:	fffb8b93          	addi	s7,s7,-1
80001bbc:	fedff06f          	j	80001ba8 <z_vprintk+0x350>
					x = va_arg(ap, unsigned long long);
80001bc0:	007d0793          	addi	a5,s10,7
80001bc4:	ff87f693          	andi	a3,a5,-8
80001bc8:	0006a783          	lw	a5,0(a3)
80001bcc:	00868d13          	addi	s10,a3,8
80001bd0:	00f12223          	sw	a5,4(sp)
80001bd4:	0046a783          	lw	a5,4(a3)
80001bd8:	00f12423          	sw	a5,8(sp)
80001bdc:	f55ff06f          	j	80001b30 <z_vprintk+0x2d8>
			found_largest_digit = 1;
80001be0:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001be4:	000b0893          	mv	a7,s6
80001be8:	f59ff06f          	j	80001b40 <z_vprintk+0x2e8>
			nibble += nibble > 9 ? 87 : 48;
80001bec:	00900793          	li	a5,9
80001bf0:	05700693          	li	a3,87
80001bf4:	f8a7e2e3          	bltu	a5,a0,80001b78 <z_vprintk+0x320>
80001bf8:	03000693          	li	a3,48
80001bfc:	f7dff06f          	j	80001b78 <z_vprintk+0x320>
		if (remaining-- <= min_width) {
80001c00:	fffc0793          	addi	a5,s8,-1
80001c04:	00f12623          	sw	a5,12(sp)
80001c08:	01894c63          	blt	s2,s8,80001c20 <z_vprintk+0x3c8>
			if (padding == PAD_ZERO_BEFORE) {
80001c0c:	00100793          	li	a5,1
80001c10:	00f99c63          	bne	s3,a5,80001c28 <z_vprintk+0x3d0>
				out('0', ctx);
80001c14:	00048593          	mv	a1,s1
80001c18:	03000513          	li	a0,48
				out(' ', ctx);
80001c1c:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80001c20:	00c12c03          	lw	s8,12(sp)
80001c24:	fc1ff06f          	j	80001be4 <z_vprintk+0x38c>
			} else if (padding == PAD_SPACE_BEFORE) {
80001c28:	00200793          	li	a5,2
80001c2c:	fef99ae3          	bne	s3,a5,80001c20 <z_vprintk+0x3c8>
				out(' ', ctx);
80001c30:	00048593          	mv	a1,s1
80001c34:	02000513          	li	a0,32
80001c38:	fe5ff06f          	j	80001c1c <z_vprintk+0x3c4>
					out((int)(*s++), ctx);
80001c3c:	00048593          	mv	a1,s1
80001c40:	001b8b93          	addi	s7,s7,1
80001c44:	000400e7          	jalr	s0
80001c48:	d81ff06f          	j	800019c8 <z_vprintk+0x170>
						out(' ', ctx);
80001c4c:	00048593          	mv	a1,s1
80001c50:	02000513          	li	a0,32
80001c54:	000400e7          	jalr	s0
80001c58:	fffb8b93          	addi	s7,s7,-1
80001c5c:	d85ff06f          	j	800019e0 <z_vprintk+0x188>
				out(c, ctx);
80001c60:	000d2503          	lw	a0,0(s10)
80001c64:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80001c68:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001c6c:	000400e7          	jalr	s0
				break;
80001c70:	d75ff06f          	j	800019e4 <z_vprintk+0x18c>
				long_ctr = 0;
80001c74:	00000a13          	li	s4,0
				min_width = -1;
80001c78:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80001c7c:	00000993          	li	s3,0
				might_format = 1;
80001c80:	00100c93          	li	s9,1
80001c84:	c89ff06f          	j	8000190c <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80001c88:	00300993          	li	s3,3
80001c8c:	c81ff06f          	j	8000190c <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80001c90:	00100993          	li	s3,1
80001c94:	c79ff06f          	j	8000190c <z_vprintk+0xb4>

80001c98 <vprintk>:
{
80001c98:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001c9c:	00050613          	mv	a2,a0
80001ca0:	80001537          	lui	a0,0x80001
80001ca4:	00058693          	mv	a3,a1
80001ca8:	6ec50513          	addi	a0,a0,1772 # 800016ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800016ed>
80001cac:	00c10593          	addi	a1,sp,12
{
80001cb0:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001cb4:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001cb8:	ba1ff0ef          	jal	ra,80001858 <z_vprintk>
}
80001cbc:	01c12083          	lw	ra,28(sp)
80001cc0:	02010113          	addi	sp,sp,32
80001cc4:	00008067          	ret

80001cc8 <printk>:
{
80001cc8:	fc010113          	addi	sp,sp,-64
80001ccc:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80001cd0:	02410593          	addi	a1,sp,36
{
80001cd4:	00112e23          	sw	ra,28(sp)
80001cd8:	02c12423          	sw	a2,40(sp)
80001cdc:	02d12623          	sw	a3,44(sp)
80001ce0:	02e12823          	sw	a4,48(sp)
80001ce4:	02f12a23          	sw	a5,52(sp)
80001ce8:	03012c23          	sw	a6,56(sp)
80001cec:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80001cf0:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80001cf4:	fa5ff0ef          	jal	ra,80001c98 <vprintk>
}
80001cf8:	01c12083          	lw	ra,28(sp)
80001cfc:	04010113          	addi	sp,sp,64
80001d00:	00008067          	ret

80001d04 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001d04:	800065b7          	lui	a1,0x80006
80001d08:	80006537          	lui	a0,0x80006
{
80001d0c:	ff010113          	addi	sp,sp,-16
  k_panic();
80001d10:	48858593          	addi	a1,a1,1160 # 80006488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006489>
80001d14:	49c50513          	addi	a0,a0,1180 # 8000649c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000649d>
80001d18:	01e00613          	li	a2,30
{
80001d1c:	00112623          	sw	ra,12(sp)
  k_panic();
80001d20:	fa9ff0ef          	jal	ra,80001cc8 <printk>
80001d24:	800065b7          	lui	a1,0x80006
80001d28:	06858593          	addi	a1,a1,104 # 80006068 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006069>
80001d2c:	00600513          	li	a0,6
80001d30:	e79fe0ef          	jal	ra,80000ba8 <z_NanoFatalErrorHandler>

80001d34 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001d34:	00008067          	ret

80001d38 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001d38:	00800793          	li	a5,8
80001d3c:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001d40:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001d44:	00008067          	ret

80001d48 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001d48:	00100793          	li	a5,1
80001d4c:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001d50:	30452573          	csrrs	a0,mie,a0
}
80001d54:	00008067          	ret

80001d58 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001d58:	00800793          	li	a5,8
80001d5c:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001d60:	30405073          	csrwi	mie,0
80001d64:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001d68:	00008067          	ret

80001d6c <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001d6c:	ff010113          	addi	sp,sp,-16
80001d70:	00812423          	sw	s0,8(sp)
80001d74:	00912223          	sw	s1,4(sp)
80001d78:	80007437          	lui	s0,0x80007
80001d7c:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001d80:	00a00793          	li	a5,10
{
80001d84:	00050493          	mv	s1,a0
80001d88:	a4840413          	addi	s0,s0,-1464 # 80006a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a49>
	if ('\n' == c) {
80001d8c:	00f51c63          	bne	a0,a5,80001da4 <console_out+0x38>
80001d90:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001d94:	00d00593          	li	a1,13
80001d98:	00452783          	lw	a5,4(a0)
80001d9c:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80001da0:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001da4:	00042503          	lw	a0,0(s0)
80001da8:	0ff4f593          	andi	a1,s1,255
80001dac:	00452783          	lw	a5,4(a0)
80001db0:	0047a783          	lw	a5,4(a5)
80001db4:	000780e7          	jalr	a5

	return c;
}
80001db8:	00c12083          	lw	ra,12(sp)
80001dbc:	00812403          	lw	s0,8(sp)
80001dc0:	00048513          	mv	a0,s1
80001dc4:	00412483          	lw	s1,4(sp)
80001dc8:	01010113          	addi	sp,sp,16
80001dcc:	00008067          	ret

80001dd0 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001dd0:	ff010113          	addi	sp,sp,-16
80001dd4:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001dd8:	80002437          	lui	s0,0x80002
80001ddc:	d6c40513          	addi	a0,s0,-660 # 80001d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001d6d>
{
80001de0:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001de4:	5b4000ef          	jal	ra,80002398 <__stdout_hook_install>
	__printk_hook_install(console_out);
80001de8:	d6c40513          	addi	a0,s0,-660
}
80001dec:	00812403          	lw	s0,8(sp)
80001df0:	00c12083          	lw	ra,12(sp)
80001df4:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80001df8:	a55ff06f          	j	8000184c <__printk_hook_install>

80001dfc <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001dfc:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001e00:	ff010113          	addi	sp,sp,-16
80001e04:	4a850513          	addi	a0,a0,1192 # 800064a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064a9>
80001e08:	00112623          	sw	ra,12(sp)
80001e0c:	135000ef          	jal	ra,80002740 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001e10:	800077b7          	lui	a5,0x80007
80001e14:	a4a7a423          	sw	a0,-1464(a5) # 80006a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a49>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001e18:	fb9ff0ef          	jal	ra,80001dd0 <uart_console_hook_install>

	return 0;
}
80001e1c:	00c12083          	lw	ra,12(sp)
80001e20:	00000513          	li	a0,0
80001e24:	01010113          	addi	sp,sp,16
80001e28:	00008067          	ret

80001e2c <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001e2c:	f01007b7          	lui	a5,0xf0100
80001e30:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001e34:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001e38:	f447a583          	lw	a1,-188(a5)
80001e3c:	fee59ae3          	bne	a1,a4,80001e30 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001e40:	00008067          	ret

80001e44 <timer_isr>:

static void timer_isr(void *arg)
{
80001e44:	fe010113          	addi	sp,sp,-32
80001e48:	00812c23          	sw	s0,24(sp)
80001e4c:	00112e23          	sw	ra,28(sp)
80001e50:	00912a23          	sw	s1,20(sp)
80001e54:	01212823          	sw	s2,16(sp)
80001e58:	01312623          	sw	s3,12(sp)
80001e5c:	01412423          	sw	s4,8(sp)
80001e60:	01512223          	sw	s5,4(sp)
80001e64:	00800413          	li	s0,8
80001e68:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001e6c:	80007937          	lui	s2,0x80007
80001e70:	a4c90513          	addi	a0,s2,-1460 # 80006a4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a4d>
	key = (mstatus & SOC_MSTATUS_IEN);
80001e74:	00847413          	andi	s0,s0,8
80001e78:	155020ef          	jal	ra,800047cc <z_spin_lock_valid>
80001e7c:	02051e63          	bnez	a0,80001eb8 <timer_isr+0x74>
80001e80:	800064b7          	lui	s1,0x80006
80001e84:	800065b7          	lui	a1,0x80006
80001e88:	80006537          	lui	a0,0x80006
80001e8c:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80001e90:	04e00693          	li	a3,78
80001e94:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80001e98:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80001e9c:	e2dff0ef          	jal	ra,80001cc8 <printk>
80001ea0:	80006537          	lui	a0,0x80006
80001ea4:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80001ea8:	e21ff0ef          	jal	ra,80001cc8 <printk>
80001eac:	04e00593          	li	a1,78
80001eb0:	4bc48513          	addi	a0,s1,1212
80001eb4:	e51ff0ef          	jal	ra,80001d04 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001eb8:	a4c90513          	addi	a0,s2,-1460
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001ebc:	800074b7          	lui	s1,0x80007
80001ec0:	165020ef          	jal	ra,80004824 <z_spin_lock_set_owner>
80001ec4:	a2848493          	addi	s1,s1,-1496 # 80006a28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a29>
	u64_t now = mtime();
80001ec8:	f65ff0ef          	jal	ra,80001e2c <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001ecc:	0004a983          	lw	s3,0(s1)
80001ed0:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001ed4:	00050713          	mv	a4,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001ed8:	41350533          	sub	a0,a0,s3
80001edc:	00a73733          	sltu	a4,a4,a0
80001ee0:	415585b3          	sub	a1,a1,s5
80001ee4:	0001d637          	lui	a2,0x1d
80001ee8:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001eec:	00000693          	li	a3,0
80001ef0:	40e585b3          	sub	a1,a1,a4
80001ef4:	bbcfe0ef          	jal	ra,800002b0 <__udivdi3>

	last_count += dticks * CYC_PER_TICK;
80001ef8:	0001d7b7          	lui	a5,0x1d
80001efc:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001f00:	02a787b3          	mul	a5,a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001f04:	00050a13          	mv	s4,a0
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001f08:	a4c90513          	addi	a0,s2,-1460
	last_count += dticks * CYC_PER_TICK;
80001f0c:	013789b3          	add	s3,a5,s3
80001f10:	00f9b7b3          	sltu	a5,s3,a5
80001f14:	015787b3          	add	a5,a5,s5
80001f18:	0134a023          	sw	s3,0(s1)
80001f1c:	00f4a223          	sw	a5,4(s1)
80001f20:	0d5020ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80001f24:	02051e63          	bnez	a0,80001f60 <timer_isr+0x11c>
80001f28:	800064b7          	lui	s1,0x80006
80001f2c:	800065b7          	lui	a1,0x80006
80001f30:	80006537          	lui	a0,0x80006
80001f34:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80001f38:	06100693          	li	a3,97
80001f3c:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80001f40:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80001f44:	d85ff0ef          	jal	ra,80001cc8 <printk>
80001f48:	80006537          	lui	a0,0x80006
80001f4c:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80001f50:	d79ff0ef          	jal	ra,80001cc8 <printk>
80001f54:	06100593          	li	a1,97
80001f58:	4bc48513          	addi	a0,s1,1212
80001f5c:	da9ff0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001f60:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80001f64:	01812403          	lw	s0,24(sp)
80001f68:	01c12083          	lw	ra,28(sp)
80001f6c:	01412483          	lw	s1,20(sp)
80001f70:	01012903          	lw	s2,16(sp)
80001f74:	00c12983          	lw	s3,12(sp)
80001f78:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001f7c:	000a0513          	mv	a0,s4
}
80001f80:	00812a03          	lw	s4,8(sp)
80001f84:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001f88:	2e40306f          	j	8000526c <z_clock_announce>

80001f8c <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80001f8c:	ff010113          	addi	sp,sp,-16
80001f90:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001f94:	e99ff0ef          	jal	ra,80001e2c <mtime>
80001f98:	0001d7b7          	lui	a5,0x1d
80001f9c:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001fa0:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001fa4:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80001fa8:	fff00693          	li	a3,-1
80001fac:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001fb0:	00a7b533          	sltu	a0,a5,a0
80001fb4:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80001fb8:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001fbc:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80001fc0:	00700513          	li	a0,7
80001fc4:	d85ff0ef          	jal	ra,80001d48 <z_arch_irq_enable>
	return 0;
}
80001fc8:	00c12083          	lw	ra,12(sp)
80001fcc:	00000513          	li	a0,0
80001fd0:	01010113          	addi	sp,sp,16
80001fd4:	00008067          	ret

80001fd8 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001fd8:	16059c63          	bnez	a1,80002150 <z_clock_set_timeout+0x178>
{
80001fdc:	fe010113          	addi	sp,sp,-32
80001fe0:	00112e23          	sw	ra,28(sp)
80001fe4:	00812c23          	sw	s0,24(sp)
80001fe8:	00912a23          	sw	s1,20(sp)
80001fec:	01212823          	sw	s2,16(sp)
80001ff0:	01312623          	sw	s3,12(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80001ff4:	fff00793          	li	a5,-1
80001ff8:	00f51663          	bne	a0,a5,80002004 <z_clock_set_timeout+0x2c>
80001ffc:	00009537          	lui	a0,0x9
80002000:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80002004:	000097b7          	lui	a5,0x9
80002008:	fff50413          	addi	s0,a0,-1
8000200c:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80002010:	1287da63          	bge	a5,s0,80002144 <z_clock_set_timeout+0x16c>
80002014:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002018:	00800493          	li	s1,8
8000201c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002020:	80007937          	lui	s2,0x80007
80002024:	a4c90513          	addi	a0,s2,-1460 # 80006a4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a4d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002028:	0084f493          	andi	s1,s1,8
8000202c:	7a0020ef          	jal	ra,800047cc <z_spin_lock_valid>
80002030:	02051e63          	bnez	a0,8000206c <z_clock_set_timeout+0x94>
80002034:	800069b7          	lui	s3,0x80006
80002038:	800065b7          	lui	a1,0x80006
8000203c:	80006537          	lui	a0,0x80006
80002040:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80002044:	04e00693          	li	a3,78
80002048:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000204c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002050:	c79ff0ef          	jal	ra,80001cc8 <printk>
80002054:	80006537          	lui	a0,0x80006
80002058:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
8000205c:	c6dff0ef          	jal	ra,80001cc8 <printk>
80002060:	04e00593          	li	a1,78
80002064:	4bc98513          	addi	a0,s3,1212
80002068:	c9dff0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
8000206c:	a4c90513          	addi	a0,s2,-1460
80002070:	7b4020ef          	jal	ra,80004824 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002074:	db9ff0ef          	jal	ra,80001e2c <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;
80002078:	0001d6b7          	lui	a3,0x1d

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000207c:	800077b7          	lui	a5,0x80007
	u32_t cyc = ticks * CYC_PER_TICK;
80002080:	4c068613          	addi	a2,a3,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002084:	a2878793          	addi	a5,a5,-1496 # 80006a28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a29>
80002088:	0007a703          	lw	a4,0(a5)
8000208c:	0047a583          	lw	a1,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002090:	02c407b3          	mul	a5,s0,a2
80002094:	4bf68693          	addi	a3,a3,1215
80002098:	40e68433          	sub	s0,a3,a4
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
8000209c:	3e700693          	li	a3,999
800020a0:	008787b3          	add	a5,a5,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
800020a4:	00f507b3          	add	a5,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
800020a8:	02c7d7b3          	divu	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
800020ac:	40a70533          	sub	a0,a4,a0
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
800020b0:	02c787b3          	mul	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
800020b4:	00f50533          	add	a0,a0,a5
800020b8:	00a6c463          	blt	a3,a0,800020c0 <z_clock_set_timeout+0xe8>
		cyc += CYC_PER_TICK;
800020bc:	00c787b3          	add	a5,a5,a2
	r[1] = 0xffffffff;
800020c0:	f01006b7          	lui	a3,0xf0100
	}

	set_mtimecmp(cyc + last_count);
800020c4:	00e78733          	add	a4,a5,a4
	r[1] = 0xffffffff;
800020c8:	fff00613          	li	a2,-1
800020cc:	f4c6a623          	sw	a2,-180(a3) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
800020d0:	00f737b3          	sltu	a5,a4,a5
800020d4:	00b787b3          	add	a5,a5,a1
	r[0] = (u32_t)time;
800020d8:	f4e6a423          	sw	a4,-184(a3)
	r[1] = (u32_t)(time >> 32);
800020dc:	f4f6a623          	sw	a5,-180(a3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800020e0:	a4c90513          	addi	a0,s2,-1460
800020e4:	710020ef          	jal	ra,800047f4 <z_spin_unlock_valid>
800020e8:	02051e63          	bnez	a0,80002124 <z_clock_set_timeout+0x14c>
800020ec:	80006437          	lui	s0,0x80006
800020f0:	800065b7          	lui	a1,0x80006
800020f4:	80006537          	lui	a0,0x80006
800020f8:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800020fc:	06100693          	li	a3,97
80002100:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002104:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002108:	bc1ff0ef          	jal	ra,80001cc8 <printk>
8000210c:	80006537          	lui	a0,0x80006
80002110:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80002114:	bb5ff0ef          	jal	ra,80001cc8 <printk>
80002118:	06100593          	li	a1,97
8000211c:	4bc40513          	addi	a0,s0,1212
80002120:	be5ff0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002124:	3004a4f3          	csrrs	s1,mstatus,s1
	k_spin_unlock(&lock, key);
#endif
}
80002128:	01c12083          	lw	ra,28(sp)
8000212c:	01812403          	lw	s0,24(sp)
80002130:	01412483          	lw	s1,20(sp)
80002134:	01012903          	lw	s2,16(sp)
80002138:	00c12983          	lw	s3,12(sp)
8000213c:	02010113          	addi	sp,sp,32
80002140:	00008067          	ret
80002144:	ec045ae3          	bgez	s0,80002018 <z_clock_set_timeout+0x40>
80002148:	00000413          	li	s0,0
8000214c:	ecdff06f          	j	80002018 <z_clock_set_timeout+0x40>
80002150:	00008067          	ret

80002154 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002154:	ff010113          	addi	sp,sp,-16
80002158:	00812423          	sw	s0,8(sp)
8000215c:	00112623          	sw	ra,12(sp)
80002160:	00912223          	sw	s1,4(sp)
80002164:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002168:	00800413          	li	s0,8
8000216c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002170:	80007937          	lui	s2,0x80007
80002174:	a4c90513          	addi	a0,s2,-1460 # 80006a4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a4d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002178:	00847413          	andi	s0,s0,8
8000217c:	650020ef          	jal	ra,800047cc <z_spin_lock_valid>
80002180:	02051e63          	bnez	a0,800021bc <z_clock_elapsed+0x68>
80002184:	800064b7          	lui	s1,0x80006
80002188:	800065b7          	lui	a1,0x80006
8000218c:	80006537          	lui	a0,0x80006
80002190:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80002194:	04e00693          	li	a3,78
80002198:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000219c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800021a0:	b29ff0ef          	jal	ra,80001cc8 <printk>
800021a4:	80006537          	lui	a0,0x80006
800021a8:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
800021ac:	b1dff0ef          	jal	ra,80001cc8 <printk>
800021b0:	04e00593          	li	a1,78
800021b4:	4bc48513          	addi	a0,s1,1212
800021b8:	b4dff0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
800021bc:	a4c90513          	addi	a0,s2,-1460
800021c0:	664020ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
800021c4:	c69ff0ef          	jal	ra,80001e2c <mtime>
800021c8:	800077b7          	lui	a5,0x80007
800021cc:	a287a483          	lw	s1,-1496(a5) # 80006a28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a29>
800021d0:	409504b3          	sub	s1,a0,s1
800021d4:	0001d537          	lui	a0,0x1d
800021d8:	4c050513          	addi	a0,a0,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800021dc:	02a4d4b3          	divu	s1,s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800021e0:	a4c90513          	addi	a0,s2,-1460
800021e4:	610020ef          	jal	ra,800047f4 <z_spin_unlock_valid>
800021e8:	02051e63          	bnez	a0,80002224 <z_clock_elapsed+0xd0>
800021ec:	80006937          	lui	s2,0x80006
800021f0:	800065b7          	lui	a1,0x80006
800021f4:	80006537          	lui	a0,0x80006
800021f8:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800021fc:	06100693          	li	a3,97
80002200:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002204:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002208:	ac1ff0ef          	jal	ra,80001cc8 <printk>
8000220c:	80006537          	lui	a0,0x80006
80002210:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80002214:	ab5ff0ef          	jal	ra,80001cc8 <printk>
80002218:	06100593          	li	a1,97
8000221c:	4bc90513          	addi	a0,s2,1212
80002220:	ae5ff0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002224:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002228:	00c12083          	lw	ra,12(sp)
8000222c:	00812403          	lw	s0,8(sp)
80002230:	00048513          	mv	a0,s1
80002234:	00012903          	lw	s2,0(sp)
80002238:	00412483          	lw	s1,4(sp)
8000223c:	01010113          	addi	sp,sp,16
80002240:	00008067          	ret

80002244 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002244:	00054783          	lbu	a5,0(a0)
80002248:	0005c703          	lbu	a4,0(a1)
8000224c:	00e79463          	bne	a5,a4,80002254 <strcmp+0x10>
80002250:	00079663          	bnez	a5,8000225c <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002254:	40e78533          	sub	a0,a5,a4
80002258:	00008067          	ret
		s1++;
8000225c:	00150513          	addi	a0,a0,1
		s2++;
80002260:	00158593          	addi	a1,a1,1
80002264:	fe1ff06f          	j	80002244 <strcmp>

80002268 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80002268:	00b547b3          	xor	a5,a0,a1
8000226c:	0037f793          	andi	a5,a5,3
80002270:	06078063          	beqz	a5,800022d0 <memcpy+0x68>
	unsigned char *d_byte = (unsigned char *)d;
80002274:	00050793          	mv	a5,a0
80002278:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
8000227c:	06e61a63          	bne	a2,a4,800022f0 <memcpy+0x88>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80002280:	00008067          	ret
			if (n == 0) {
80002284:	fe060ee3          	beqz	a2,80002280 <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
80002288:	00158593          	addi	a1,a1,1
8000228c:	fff5c703          	lbu	a4,-1(a1)
80002290:	00178793          	addi	a5,a5,1
			n--;
80002294:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80002298:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
8000229c:	0037f713          	andi	a4,a5,3
800022a0:	fe0712e3          	bnez	a4,80002284 <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
800022a4:	00300693          	li	a3,3
800022a8:	40e60833          	sub	a6,a2,a4
800022ac:	0306e663          	bltu	a3,a6,800022d8 <memcpy+0x70>
800022b0:	00265713          	srli	a4,a2,0x2
800022b4:	ffc00693          	li	a3,-4
800022b8:	02d706b3          	mul	a3,a4,a3
800022bc:	00271713          	slli	a4,a4,0x2
800022c0:	00e787b3          	add	a5,a5,a4
800022c4:	00e585b3          	add	a1,a1,a4
800022c8:	00d60633          	add	a2,a2,a3
800022cc:	fadff06f          	j	80002278 <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
800022d0:	00050793          	mv	a5,a0
800022d4:	fc9ff06f          	j	8000229c <memcpy+0x34>
			*(d_word++) = *(s_word++);
800022d8:	00e588b3          	add	a7,a1,a4
800022dc:	0008a883          	lw	a7,0(a7)
800022e0:	00e78833          	add	a6,a5,a4
800022e4:	00470713          	addi	a4,a4,4
800022e8:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
800022ec:	fbdff06f          	j	800022a8 <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
800022f0:	00e58833          	add	a6,a1,a4
800022f4:	00084803          	lbu	a6,0(a6)
800022f8:	00e786b3          	add	a3,a5,a4
800022fc:	00170713          	addi	a4,a4,1
80002300:	01068023          	sb	a6,0(a3)
		n--;
80002304:	f79ff06f          	j	8000227c <memcpy+0x14>

80002308 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002308:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
8000230c:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80002310:	0037f713          	andi	a4,a5,3
80002314:	04071863          	bnez	a4,80002364 <memset+0x5c>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002318:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
8000231c:	00859713          	slli	a4,a1,0x8
80002320:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002324:	01059713          	slli	a4,a1,0x10
80002328:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
8000232c:	00c78333          	add	t1,a5,a2
80002330:	00078713          	mv	a4,a5
80002334:	00300813          	li	a6,3
80002338:	40e308b3          	sub	a7,t1,a4
8000233c:	03186e63          	bltu	a6,a7,80002378 <memset+0x70>
80002340:	00265713          	srli	a4,a2,0x2
80002344:	00271593          	slli	a1,a4,0x2
80002348:	00b787b3          	add	a5,a5,a1
8000234c:	ffc00593          	li	a1,-4
80002350:	02b70733          	mul	a4,a4,a1
80002354:	00c70733          	add	a4,a4,a2
80002358:	00e78733          	add	a4,a5,a4

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
8000235c:	02e79463          	bne	a5,a4,80002384 <memset+0x7c>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002360:	00008067          	ret
		if (n == 0) {
80002364:	fe060ee3          	beqz	a2,80002360 <memset+0x58>
		*(d_byte++) = c_byte;
80002368:	00178793          	addi	a5,a5,1
8000236c:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002370:	fff60613          	addi	a2,a2,-1
80002374:	f9dff06f          	j	80002310 <memset+0x8>
		*(d_word++) = c_word;
80002378:	00470713          	addi	a4,a4,4
8000237c:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80002380:	fb9ff06f          	j	80002338 <memset+0x30>
		*(d_byte++) = c_byte;
80002384:	00178793          	addi	a5,a5,1
80002388:	fed78fa3          	sb	a3,-1(a5)
		n--;
8000238c:	fd1ff06f          	j	8000235c <memset+0x54>

80002390 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80002390:	fff00513          	li	a0,-1
80002394:	00008067          	ret

80002398 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002398:	800077b7          	lui	a5,0x80007
8000239c:	98a7ae23          	sw	a0,-1636(a5) # 8000699c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000699d>
}
800023a0:	00008067          	ret

800023a4 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
800023a4:	fe010113          	addi	sp,sp,-32
800023a8:	00812c23          	sw	s0,24(sp)
	test->setup();
800023ac:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
800023b0:	80007437          	lui	s0,0x80007
{
800023b4:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
800023b8:	9a040413          	addi	s0,s0,-1632 # 800069a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a1>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
800023bc:	800074b7          	lui	s1,0x80007
{
800023c0:	00112e23          	sw	ra,28(sp)
800023c4:	01212823          	sw	s2,16(sp)
800023c8:	01312623          	sw	s3,12(sp)
	test_result = 1;
800023cc:	a5048493          	addi	s1,s1,-1456 # 80006a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a51>
800023d0:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
800023d4:	00042023          	sw	zero,0(s0)
{
800023d8:	00050913          	mv	s2,a0
	test_result = 1;
800023dc:	0134a023          	sw	s3,0(s1)
	test->setup();
800023e0:	000780e7          	jalr	a5
	test->test();
800023e4:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
800023e8:	01342023          	sw	s3,0(s0)
	test->test();
800023ec:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
800023f0:	00200793          	li	a5,2
800023f4:	00f42023          	sw	a5,0(s0)
	test->teardown();
800023f8:	00c92783          	lw	a5,12(s2)
800023fc:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002400:	00300793          	li	a5,3
80002404:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002408:	01812403          	lw	s0,24(sp)
	test_result = 0;
8000240c:	0004a023          	sw	zero,0(s1)
}
80002410:	01c12083          	lw	ra,28(sp)
80002414:	01412483          	lw	s1,20(sp)
80002418:	01012903          	lw	s2,16(sp)
8000241c:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002420:	80007537          	lui	a0,0x80007
80002424:	be450513          	addi	a0,a0,-1052 # 80006be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be5>
80002428:	02010113          	addi	sp,sp,32
8000242c:	7e10106f          	j	8000440c <z_impl_k_sem_give>

80002430 <ztest_test_fail>:
80002430:	80007537          	lui	a0,0x80007
{
80002434:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80002438:	800077b7          	lui	a5,0x80007
8000243c:	fff00713          	li	a4,-1
80002440:	be450513          	addi	a0,a0,-1052 # 80006be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be5>
{
80002444:	00112623          	sw	ra,12(sp)
	test_result = -1;
80002448:	a4e7a823          	sw	a4,-1456(a5) # 80006a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a51>
8000244c:	7c1010ef          	jal	ra,8000440c <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002450:	6e9010ef          	jal	ra,80004338 <z_impl_k_current_get>
}
80002454:	00c12083          	lw	ra,12(sp)
80002458:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000245c:	6d80206f          	j	80004b34 <z_impl_k_thread_abort>

80002460 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80002460:	fa010113          	addi	sp,sp,-96
80002464:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002468:	800074b7          	lui	s1,0x80007
8000246c:	a544a783          	lw	a5,-1452(s1) # 80006a54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a55>
{
80002470:	04112e23          	sw	ra,92(sp)
80002474:	04812c23          	sw	s0,88(sp)
80002478:	05212823          	sw	s2,80(sp)
8000247c:	05312623          	sw	s3,76(sp)
80002480:	05412423          	sw	s4,72(sp)
80002484:	05512223          	sw	s5,68(sp)
80002488:	05612023          	sw	s6,64(sp)
8000248c:	03712e23          	sw	s7,60(sp)
80002490:	03812c23          	sw	s8,56(sp)
80002494:	03912a23          	sw	s9,52(sp)
80002498:	03a12823          	sw	s10,48(sp)
8000249c:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
800024a0:	0807c463          	bltz	a5,80002528 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
800024a4:	80007437          	lui	s0,0x80007
800024a8:	00100613          	li	a2,1
800024ac:	00050993          	mv	s3,a0
800024b0:	00058c13          	mv	s8,a1
800024b4:	be440513          	addi	a0,s0,-1052 # 80006be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be5>
800024b8:	00000593          	li	a1,0
800024bc:	689010ef          	jal	ra,80004344 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
800024c0:	80006537          	lui	a0,0x80006
800024c4:	00098593          	mv	a1,s3
800024c8:	57850513          	addi	a0,a0,1400 # 80006578 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006579>
800024cc:	ffcff0ef          	jal	ra,80001cc8 <printk>
	PRINT_LINE;
800024d0:	80006937          	lui	s2,0x80006
800024d4:	59090513          	addi	a0,s2,1424 # 80006590 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006591>
		Z_TC_END_RESULT(ret, test->name);
800024d8:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
800024dc:	fecff0ef          	jal	ra,80001cc8 <printk>
800024e0:	a5448493          	addi	s1,s1,-1452
	int fail = 0;
800024e4:	00000a13          	li	s4,0
800024e8:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800024ec:	80008cb7          	lui	s9,0x80008
800024f0:	80007b37          	lui	s6,0x80007
800024f4:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
800024f8:	80007db7          	lui	s11,0x80007
800024fc:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
80002500:	530a8a93          	addi	s5,s5,1328 # 80006530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006531>
	while (suite->test) {
80002504:	004c2783          	lw	a5,4(s8)
80002508:	04079e63          	bnez	a5,80002564 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
8000250c:	00098593          	mv	a1,s3
	if (fail) {
80002510:	100a0663          	beqz	s4,8000261c <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002514:	80006537          	lui	a0,0x80006
80002518:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
8000251c:	facff0ef          	jal	ra,80001cc8 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002520:	00100793          	li	a5,1
80002524:	00f4a023          	sw	a5,0(s1)
}
80002528:	05c12083          	lw	ra,92(sp)
8000252c:	05812403          	lw	s0,88(sp)
80002530:	05412483          	lw	s1,84(sp)
80002534:	05012903          	lw	s2,80(sp)
80002538:	04c12983          	lw	s3,76(sp)
8000253c:	04812a03          	lw	s4,72(sp)
80002540:	04412a83          	lw	s5,68(sp)
80002544:	04012b03          	lw	s6,64(sp)
80002548:	03c12b83          	lw	s7,60(sp)
8000254c:	03812c03          	lw	s8,56(sp)
80002550:	03412c83          	lw	s9,52(sp)
80002554:	03012d03          	lw	s10,48(sp)
80002558:	02c12d83          	lw	s11,44(sp)
8000255c:	06010113          	addi	sp,sp,96
80002560:	00008067          	ret
	TC_START(test->name);
80002564:	000c2583          	lw	a1,0(s8)
80002568:	800067b7          	lui	a5,0x80006
8000256c:	5d878513          	addi	a0,a5,1496 # 800065d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d9>
80002570:	f58ff0ef          	jal	ra,80001cc8 <printk>
80002574:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002578:	010c2783          	lw	a5,16(s8)
8000257c:	000c0713          	mv	a4,s8
80002580:	40000613          	li	a2,1024
80002584:	0087e793          	ori	a5,a5,8
80002588:	fff00893          	li	a7,-1
8000258c:	00000813          	li	a6,0
80002590:	3a4d0693          	addi	a3,s10,932 # 800023a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800023a5>
80002594:	00f12023          	sw	a5,0(sp)
80002598:	970c8593          	addi	a1,s9,-1680 # 80007970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007971>
8000259c:	00000793          	li	a5,0
800025a0:	bf4b0513          	addi	a0,s6,-1036 # 80006bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bf5>
800025a4:	3ec020ef          	jal	ra,80004990 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800025a8:	01c12783          	lw	a5,28(sp)
800025ac:	fff00593          	li	a1,-1
800025b0:	be478513          	addi	a0,a5,-1052
800025b4:	73d010ef          	jal	ra,800044f0 <z_impl_k_sem_take>
	if (test_result == -1) {
800025b8:	a50d8793          	addi	a5,s11,-1456 # 80006a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a51>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800025bc:	bf4b0513          	addi	a0,s6,-1036
800025c0:	0007a403          	lw	s0,0(a5)
800025c4:	570020ef          	jal	ra,80004b34 <z_impl_k_thread_abort>
	if (test_result == -2) {
800025c8:	800077b7          	lui	a5,0x80007
800025cc:	a5078793          	addi	a5,a5,-1456 # 80006a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a51>
800025d0:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
800025d4:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
800025d8:	ffe00793          	li	a5,-2
	if (test_result == -1) {
800025dc:	00143413          	seqz	s0,s0
	if (test_result == -2) {
800025e0:	000c2603          	lw	a2,0(s8)
800025e4:	02f71463          	bne	a4,a5,8000260c <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
800025e8:	800065b7          	lui	a1,0x80006
800025ec:	5ec58593          	addi	a1,a1,1516 # 800065ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065ed>
		Z_TC_END_RESULT(ret, test->name);
800025f0:	5f4b8513          	addi	a0,s7,1524 # 800065f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065f5>
800025f4:	ed4ff0ef          	jal	ra,80001cc8 <printk>
800025f8:	59090513          	addi	a0,s2,1424
800025fc:	eccff0ef          	jal	ra,80001cc8 <printk>
		fail += run_test(suite);
80002600:	008a0a33          	add	s4,s4,s0
		suite++;
80002604:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002608:	efdff06f          	j	80002504 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
8000260c:	00241793          	slli	a5,s0,0x2
80002610:	00fa87b3          	add	a5,s5,a5
80002614:	0007a583          	lw	a1,0(a5)
80002618:	fd9ff06f          	j	800025f0 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
8000261c:	80006537          	lui	a0,0x80006
80002620:	61850513          	addi	a0,a0,1560 # 80006618 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006619>
80002624:	ea4ff0ef          	jal	ra,80001cc8 <printk>
	test_status = (test_status || fail) ? 1 : 0;
80002628:	0004a783          	lw	a5,0(s1)
8000262c:	00f037b3          	snez	a5,a5
80002630:	ef5ff06f          	j	80002524 <z_ztest_run_test_suite+0xc4>

80002634 <end_report>:

void end_report(void)
{
	if (test_status) {
80002634:	800077b7          	lui	a5,0x80007
80002638:	a547a783          	lw	a5,-1452(a5) # 80006a54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a55>
{
8000263c:	ff010113          	addi	sp,sp,-16
80002640:	00812423          	sw	s0,8(sp)
80002644:	80006537          	lui	a0,0x80006
80002648:	00112623          	sw	ra,12(sp)
8000264c:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
80002650:	59050513          	addi	a0,a0,1424 # 80006590 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006591>
	if (test_status) {
80002654:	02078263          	beqz	a5,80002678 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002658:	e70ff0ef          	jal	ra,80001cc8 <printk>
8000265c:	800065b7          	lui	a1,0x80006
80002660:	53c58593          	addi	a1,a1,1340 # 8000653c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000653d>
	} else {
		TC_END_REPORT(TC_PASS);
80002664:	54440513          	addi	a0,s0,1348 # 80006544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006545>
	}
}
80002668:	00812403          	lw	s0,8(sp)
8000266c:	00c12083          	lw	ra,12(sp)
80002670:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002674:	e54ff06f          	j	80001cc8 <printk>
80002678:	e50ff0ef          	jal	ra,80001cc8 <printk>
8000267c:	800065b7          	lui	a1,0x80006
80002680:	55c58593          	addi	a1,a1,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
80002684:	fe1ff06f          	j	80002664 <end_report+0x30>

80002688 <main>:

	return test_status;
}
#else
void main(void)
{
80002688:	ff010113          	addi	sp,sp,-16
8000268c:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002690:	c8cfe0ef          	jal	ra,80000b1c <test_main>
	end_report();
}
80002694:	00c12083          	lw	ra,12(sp)
80002698:	01010113          	addi	sp,sp,16
	end_report();
8000269c:	f99ff06f          	j	80002634 <end_report>

800026a0 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
800026a0:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
800026a4:	00012623          	sw	zero,12(sp)
    i++;
800026a8:	00c12783          	lw	a5,12(sp)
800026ac:	00178793          	addi	a5,a5,1
800026b0:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
800026b4:	f00107b7          	lui	a5,0xf0010
800026b8:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
800026bc:	01010113          	addi	sp,sp,16
800026c0:	00008067          	ret

800026c4 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
800026c4:	fff00513          	li	a0,-1
800026c8:	00008067          	ret

800026cc <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
800026cc:	00000513          	li	a0,0
800026d0:	00008067          	ret

800026d4 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
800026d4:	00251713          	slli	a4,a0,0x2
800026d8:	800067b7          	lui	a5,0x80006
800026dc:	00150513          	addi	a0,a0,1
800026e0:	64878793          	addi	a5,a5,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800026e4:	00251513          	slli	a0,a0,0x2
{
800026e8:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800026ec:	00e78733          	add	a4,a5,a4
800026f0:	00a787b3          	add	a5,a5,a0
{
800026f4:	00812423          	sw	s0,8(sp)
800026f8:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800026fc:	00072403          	lw	s0,0(a4)
80002700:	0007a483          	lw	s1,0(a5)
{
80002704:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002708:	00946c63          	bltu	s0,s1,80002720 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
8000270c:	00c12083          	lw	ra,12(sp)
80002710:	00812403          	lw	s0,8(sp)
80002714:	00412483          	lw	s1,4(sp)
80002718:	01010113          	addi	sp,sp,16
8000271c:	00008067          	ret
		retval = device_conf->init(info);
80002720:	00042783          	lw	a5,0(s0)
80002724:	00040513          	mv	a0,s0
80002728:	0047a783          	lw	a5,4(a5)
8000272c:	000780e7          	jalr	a5
		if (retval != 0) {
80002730:	00050463          	beqz	a0,80002738 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002734:	00042223          	sw	zero,4(s0)
								info++) {
80002738:	00c40413          	addi	s0,s0,12
8000273c:	fcdff06f          	j	80002708 <z_sys_device_do_config_level+0x34>

80002740 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002740:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002744:	800077b7          	lui	a5,0x80007
{
80002748:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
8000274c:	800074b7          	lui	s1,0x80007
{
80002750:	00812423          	sw	s0,8(sp)
80002754:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002758:	9b478413          	addi	s0,a5,-1612 # 800069b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b5>
{
8000275c:	01212023          	sw	s2,0(sp)
80002760:	9b478793          	addi	a5,a5,-1612
80002764:	9e448493          	addi	s1,s1,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002768:	00941c63          	bne	s0,s1,80002780 <z_impl_device_get_binding+0x40>
8000276c:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002770:	00078413          	mv	s0,a5
80002774:	02941463          	bne	s0,s1,8000279c <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002778:	00000413          	li	s0,0
8000277c:	0440006f          	j	800027c0 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80002780:	00442703          	lw	a4,4(s0)
80002784:	00070863          	beqz	a4,80002794 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002788:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
8000278c:	00072703          	lw	a4,0(a4)
80002790:	02a70863          	beq	a4,a0,800027c0 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002794:	00c40413          	addi	s0,s0,12
80002798:	fd1ff06f          	j	80002768 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
8000279c:	00442783          	lw	a5,4(s0)
800027a0:	00079663          	bnez	a5,800027ac <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
800027a4:	00c40413          	addi	s0,s0,12
800027a8:	fcdff06f          	j	80002774 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
800027ac:	00042783          	lw	a5,0(s0)
800027b0:	00090513          	mv	a0,s2
800027b4:	0007a583          	lw	a1,0(a5)
800027b8:	a8dff0ef          	jal	ra,80002244 <strcmp>
800027bc:	fe0514e3          	bnez	a0,800027a4 <z_impl_device_get_binding+0x64>
}
800027c0:	00040513          	mv	a0,s0
800027c4:	00c12083          	lw	ra,12(sp)
800027c8:	00812403          	lw	s0,8(sp)
800027cc:	00412483          	lw	s1,4(sp)
800027d0:	00012903          	lw	s2,0(sp)
800027d4:	01010113          	addi	sp,sp,16
800027d8:	00008067          	ret

800027dc <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
800027dc:	ff010113          	addi	sp,sp,-16
800027e0:	00812423          	sw	s0,8(sp)
800027e4:	00912223          	sw	s1,4(sp)
800027e8:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800027ec:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800027f0:	00200493          	li	s1,2
800027f4:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
800027f8:	095020ef          	jal	ra,8000508c <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800027fc:	00a4c463          	blt	s1,a0,80002804 <idle+0x28>
80002800:	00100513          	li	a0,1
80002804:	00100593          	li	a1,1
80002808:	161020ef          	jal	ra,80005168 <z_set_timeout_expiry>
	k_cpu_idle();
8000280c:	d2cff0ef          	jal	ra,80001d38 <k_cpu_idle>
80002810:	fe5ff06f          	j	800027f4 <idle+0x18>

80002814 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002814:	80007537          	lui	a0,0x80007
80002818:	800077b7          	lui	a5,0x80007
8000281c:	a2850613          	addi	a2,a0,-1496 # 80006a28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a29>
80002820:	d7078793          	addi	a5,a5,-656 # 80006d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d71>
80002824:	40c78633          	sub	a2,a5,a2
80002828:	00000593          	li	a1,0
8000282c:	a2850513          	addi	a0,a0,-1496
80002830:	ad9ff06f          	j	80002308 <memset>

80002834 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002834:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002838:	00200513          	li	a0,2
{
8000283c:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002840:	e95ff0ef          	jal	ra,800026d4 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002844:	80006537          	lui	a0,0x80006
80002848:	65c50513          	addi	a0,a0,1628 # 8000665c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000665d>
8000284c:	c7cff0ef          	jal	ra,80001cc8 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002850:	00300513          	li	a0,3
80002854:	e81ff0ef          	jal	ra,800026d4 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002858:	22c020ef          	jal	ra,80004a84 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
8000285c:	e2dff0ef          	jal	ra,80002688 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002860:	800077b7          	lui	a5,0x80007
80002864:	cd478793          	addi	a5,a5,-812 # 80006cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd5>
80002868:	00c7c703          	lbu	a4,12(a5)
8000286c:	ffe77713          	andi	a4,a4,-2
80002870:	00e78623          	sb	a4,12(a5)
}
80002874:	00c12083          	lw	ra,12(sp)
80002878:	01010113          	addi	sp,sp,16
8000287c:	00008067          	ret

80002880 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002880:	f6010113          	addi	sp,sp,-160
80002884:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002888:	800097b7          	lui	a5,0x80009
8000288c:	80007437          	lui	s0,0x80007
80002890:	09312623          	sw	s3,140(sp)
80002894:	97078793          	addi	a5,a5,-1680 # 80008970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008971>
80002898:	d4440993          	addi	s3,s0,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
8000289c:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
800028a0:	01010793          	addi	a5,sp,16
800028a4:	07000613          	li	a2,112
800028a8:	00000593          	li	a1,0
800028ac:	00078513          	mv	a0,a5
{
800028b0:	08112e23          	sw	ra,156(sp)
800028b4:	08912a23          	sw	s1,148(sp)
800028b8:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
800028bc:	a4dff0ef          	jal	ra,80002308 <memset>
800028c0:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800028c4:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800028c8:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
800028cc:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800028d0:	e05ff0ef          	jal	ra,800026d4 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
800028d4:	00100513          	li	a0,1
800028d8:	dfdff0ef          	jal	ra,800026d4 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
800028dc:	10100793          	li	a5,257
800028e0:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
800028e4:	03d010ef          	jal	ra,80004120 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
800028e8:	800067b7          	lui	a5,0x80006
800028ec:	6a078793          	addi	a5,a5,1696 # 800066a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a1>
	_kernel.ready_q.cache = _main_thread;
800028f0:	80007937          	lui	s2,0x80007
	z_setup_new_thread(_main_thread, _main_stack,
800028f4:	00f12223          	sw	a5,4(sp)
800028f8:	800036b7          	lui	a3,0x80003
800028fc:	00100793          	li	a5,1
80002900:	800085b7          	lui	a1,0x80008
	_kernel.ready_q.cache = _main_thread;
80002904:	cd490493          	addi	s1,s2,-812 # 80006cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd5>
	z_setup_new_thread(_main_thread, _main_stack,
80002908:	00f12023          	sw	a5,0(sp)
8000290c:	00000713          	li	a4,0
80002910:	00000793          	li	a5,0
80002914:	00000893          	li	a7,0
80002918:	00000813          	li	a6,0
8000291c:	83468693          	addi	a3,a3,-1996 # 80002834 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002835>
80002920:	20000613          	li	a2,512
80002924:	d7058593          	addi	a1,a1,-656 # 80007d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d71>
80002928:	cd490513          	addi	a0,s2,-812
	_kernel.ready_q.cache = _main_thread;
8000292c:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002930:	5d1010ef          	jal	ra,80004700 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002934:	00d4c783          	lbu	a5,13(s1)
80002938:	d4440413          	addi	s0,s0,-700
8000293c:	ffb7f713          	andi	a4,a5,-5
80002940:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002944:	01b7f793          	andi	a5,a5,27
80002948:	00079a63          	bnez	a5,8000295c <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
8000294c:	0184a783          	lw	a5,24(s1)
80002950:	00079663          	bnez	a5,8000295c <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002954:	cd490513          	addi	a0,s2,-812
80002958:	5a9000ef          	jal	ra,80003700 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
8000295c:	800067b7          	lui	a5,0x80006
80002960:	6a878793          	addi	a5,a5,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80002964:	00f12223          	sw	a5,4(sp)
80002968:	80007537          	lui	a0,0x80007
8000296c:	00100793          	li	a5,1
80002970:	800026b7          	lui	a3,0x80002
80002974:	800085b7          	lui	a1,0x80008
80002978:	c6450493          	addi	s1,a0,-924 # 80006c64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c65>
8000297c:	00f12023          	sw	a5,0(sp)
80002980:	00f00893          	li	a7,15
80002984:	00000813          	li	a6,0
80002988:	00000793          	li	a5,0
8000298c:	00000713          	li	a4,0
80002990:	7dc68693          	addi	a3,a3,2012 # 800027dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800027dd>
80002994:	20000613          	li	a2,512
80002998:	f7058593          	addi	a1,a1,-144 # 80007f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f71>
8000299c:	c6450513          	addi	a0,a0,-924
800029a0:	561010ef          	jal	ra,80004700 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
800029a4:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
800029a8:	00942623          	sw	s1,12(s0)
800029ac:	00800513          	li	a0,8
800029b0:	ffb7f793          	andi	a5,a5,-5
800029b4:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
800029b8:	800077b7          	lui	a5,0x80007
800029bc:	d5c78793          	addi	a5,a5,-676 # 80006d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d5d>
800029c0:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800029c4:	00f42e23          	sw	a5,28(s0)
800029c8:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
800029cc:	00857513          	andi	a0,a0,8
800029d0:	859fd0ef          	jal	ra,80000228 <__swap>

800029d4 <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800029d4:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
800029d8:	fe010113          	addi	sp,sp,-32
800029dc:	00812c23          	sw	s0,24(sp)
800029e0:	00112e23          	sw	ra,28(sp)
800029e4:	01f7f793          	andi	a5,a5,31
800029e8:	00050413          	mv	s0,a0
800029ec:	00079c63          	bnez	a5,80002a04 <prepare_thread_to_run+0x30>
	if (z_is_thread_ready(thread)) {
800029f0:	01852783          	lw	a5,24(a0)
800029f4:	00079863          	bnez	a5,80002a04 <prepare_thread_to_run+0x30>
800029f8:	00b12623          	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
800029fc:	505000ef          	jal	ra,80003700 <z_add_thread_to_ready_q>
80002a00:	00c12583          	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80002a04:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
80002a08:	00b42a23          	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
80002a0c:	01c12083          	lw	ra,28(sp)
80002a10:	01812403          	lw	s0,24(sp)
80002a14:	02010113          	addi	sp,sp,32
80002a18:	00008067          	ret

80002a1c <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
80002a1c:	fe010113          	addi	sp,sp,-32
80002a20:	00812c23          	sw	s0,24(sp)
80002a24:	00912a23          	sw	s1,20(sp)
80002a28:	01212823          	sw	s2,16(sp)
80002a2c:	01312623          	sw	s3,12(sp)
80002a30:	01412423          	sw	s4,8(sp)
80002a34:	01612023          	sw	s6,0(sp)
80002a38:	00112e23          	sw	ra,28(sp)
80002a3c:	01512223          	sw	s5,4(sp)
80002a40:	00050413          	mv	s0,a0
80002a44:	00058993          	mv	s3,a1
80002a48:	00060a13          	mv	s4,a2
80002a4c:	00068b13          	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002a50:	00850913          	addi	s2,a0,8
80002a54:	00800493          	li	s1,8
80002a58:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002a5c:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002a60:	0084f493          	andi	s1,s1,8
80002a64:	569010ef          	jal	ra,800047cc <z_spin_lock_valid>
80002a68:	02051e63          	bnez	a0,80002aa4 <queue_insert+0x88>
80002a6c:	80006ab7          	lui	s5,0x80006
80002a70:	800065b7          	lui	a1,0x80006
80002a74:	80006537          	lui	a0,0x80006
80002a78:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80002a7c:	04e00693          	li	a3,78
80002a80:	4bca8613          	addi	a2,s5,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002a84:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002a88:	a40ff0ef          	jal	ra,80001cc8 <printk>
80002a8c:	80006537          	lui	a0,0x80006
80002a90:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80002a94:	a34ff0ef          	jal	ra,80001cc8 <printk>
80002a98:	04e00593          	li	a1,78
80002a9c:	4bca8513          	addi	a0,s5,1212
80002aa0:	a64ff0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80002aa4:	00090513          	mv	a0,s2
80002aa8:	57d010ef          	jal	ra,80004824 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
80002aac:	00c40513          	addi	a0,s0,12
80002ab0:	450010ef          	jal	ra,80003f00 <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
80002ab4:	02050063          	beqz	a0,80002ad4 <queue_insert+0xb8>
		prepare_thread_to_run(first_pending_thread, data);
80002ab8:	000a0593          	mv	a1,s4
80002abc:	f19ff0ef          	jal	ra,800029d4 <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
80002ac0:	00090513          	mv	a0,s2
80002ac4:	00048593          	mv	a1,s1
80002ac8:	5ec000ef          	jal	ra,800030b4 <z_reschedule>
	return 0;
80002acc:	00000513          	li	a0,0
80002ad0:	0600006f          	j	80002b30 <queue_insert+0x114>
	if (alloc) {
80002ad4:	0a0b0e63          	beqz	s6,80002b90 <queue_insert+0x174>
		anode = z_thread_malloc(sizeof(*anode));
80002ad8:	00800513          	li	a0,8
80002adc:	0ec030ef          	jal	ra,80005bc8 <z_thread_malloc>
		if (anode == NULL) {
80002ae0:	06051c63          	bnez	a0,80002b58 <queue_insert+0x13c>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ae4:	00090513          	mv	a0,s2
80002ae8:	50d010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80002aec:	02051e63          	bnez	a0,80002b28 <queue_insert+0x10c>
80002af0:	80006437          	lui	s0,0x80006
80002af4:	800065b7          	lui	a1,0x80006
80002af8:	80006537          	lui	a0,0x80006
80002afc:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80002b00:	06100693          	li	a3,97
80002b04:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002b08:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002b0c:	9bcff0ef          	jal	ra,80001cc8 <printk>
80002b10:	80006537          	lui	a0,0x80006
80002b14:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80002b18:	9b0ff0ef          	jal	ra,80001cc8 <printk>
80002b1c:	06100593          	li	a1,97
80002b20:	4bc40513          	addi	a0,s0,1212
80002b24:	9e0ff0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b28:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
80002b2c:	ff400513          	li	a0,-12
}
80002b30:	01c12083          	lw	ra,28(sp)
80002b34:	01812403          	lw	s0,24(sp)
80002b38:	01412483          	lw	s1,20(sp)
80002b3c:	01012903          	lw	s2,16(sp)
80002b40:	00c12983          	lw	s3,12(sp)
80002b44:	00812a03          	lw	s4,8(sp)
80002b48:	00412a83          	lw	s5,4(sp)
80002b4c:	00012b03          	lw	s6,0(sp)
80002b50:	02010113          	addi	sp,sp,32
80002b54:	00008067          	ret
 * @param flags A value between 0 and 3 to set the flags value
 */
static inline void sys_sfnode_init(sys_sfnode_t *node, u8_t flags)
{
	__ASSERT((flags & ~SYS_SFLIST_FLAGS_MASK) == 0U, "flags too large");
	node->next_and_flags = flags;
80002b58:	00100793          	li	a5,1
		anode->data = data;
80002b5c:	01452223          	sw	s4,4(a0)
80002b60:	00f52023          	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
80002b64:	00052783          	lw	a5,0(a0)
80002b68:	0037f793          	andi	a5,a5,3
80002b6c:	02099863          	bnez	s3,80002b9c <queue_insert+0x180>
	parent->next_and_flags = cur_flags | (unative_t)child;
80002b70:	00042703          	lw	a4,0(s0)
80002b74:	00f767b3          	or	a5,a4,a5
80002b78:	00f52023          	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
80002b7c:	00442783          	lw	a5,4(s0)
	list->head = node;
80002b80:	00a42023          	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
80002b84:	f2079ee3          	bnez	a5,80002ac0 <queue_insert+0xa4>
	list->tail = node;
80002b88:	00a42223          	sw	a0,4(s0)
80002b8c:	f35ff06f          	j	80002ac0 <queue_insert+0xa4>
	node->next_and_flags = flags;
80002b90:	000a2023          	sw	zero,0(s4)
80002b94:	000a0513          	mv	a0,s4
80002b98:	fcdff06f          	j	80002b64 <queue_insert+0x148>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002b9c:	0009a703          	lw	a4,0(s3)
80002ba0:	ffc77713          	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
80002ba4:	02071863          	bnez	a4,80002bd4 <queue_insert+0x1b8>
Z_GENLIST_APPEND(sflist, sfnode)
80002ba8:	00442703          	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002bac:	00f52023          	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
80002bb0:	00071863          	bnez	a4,80002bc0 <queue_insert+0x1a4>
	list->tail = node;
80002bb4:	00a42223          	sw	a0,4(s0)
	list->head = node;
80002bb8:	00a42023          	sw	a0,0(s0)
80002bbc:	f05ff06f          	j	80002ac0 <queue_insert+0xa4>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002bc0:	00072783          	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002bc4:	0037f793          	andi	a5,a5,3
80002bc8:	00f567b3          	or	a5,a0,a5
80002bcc:	00f72023          	sw	a5,0(a4)
80002bd0:	fb9ff06f          	j	80002b88 <queue_insert+0x16c>
80002bd4:	00e7e7b3          	or	a5,a5,a4
80002bd8:	00f52023          	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002bdc:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
80002be0:	0037f793          	andi	a5,a5,3
80002be4:	00f56533          	or	a0,a0,a5
80002be8:	00a9a023          	sw	a0,0(s3)
80002bec:	ed5ff06f          	j	80002ac0 <queue_insert+0xa4>

80002bf0 <z_queue_node_peek>:
{
80002bf0:	ff010113          	addi	sp,sp,-16
80002bf4:	00812423          	sw	s0,8(sp)
80002bf8:	00112623          	sw	ra,12(sp)
80002bfc:	00050413          	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
80002c00:	00050e63          	beqz	a0,80002c1c <z_queue_node_peek+0x2c>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80002c04:	00052783          	lw	a5,0(a0)
80002c08:	0037f793          	andi	a5,a5,3
80002c0c:	00078863          	beqz	a5,80002c1c <z_queue_node_peek+0x2c>
		ret = anode->data;
80002c10:	00452403          	lw	s0,4(a0)
		if (needs_free) {
80002c14:	00058463          	beqz	a1,80002c1c <z_queue_node_peek+0x2c>
			k_free(anode);
80002c18:	7a1020ef          	jal	ra,80005bb8 <k_free>
}
80002c1c:	00040513          	mv	a0,s0
80002c20:	00c12083          	lw	ra,12(sp)
80002c24:	00812403          	lw	s0,8(sp)
80002c28:	01010113          	addi	sp,sp,16
80002c2c:	00008067          	ret

80002c30 <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80002c30:	00c50793          	addi	a5,a0,12
	list->head = NULL;
80002c34:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
80002c38:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
80002c3c:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
80002c40:	00f52623          	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
80002c44:	00f52823          	sw	a5,16(a0)
}
80002c48:	00008067          	ret

80002c4c <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
80002c4c:	00058613          	mv	a2,a1
80002c50:	00452583          	lw	a1,4(a0)
80002c54:	00000693          	li	a3,0
80002c58:	dc5ff06f          	j	80002a1c <queue_insert>

80002c5c <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
80002c5c:	fe010113          	addi	sp,sp,-32
80002c60:	00812c23          	sw	s0,24(sp)
80002c64:	00912a23          	sw	s1,20(sp)
80002c68:	01212823          	sw	s2,16(sp)
80002c6c:	01312623          	sw	s3,12(sp)
80002c70:	00112e23          	sw	ra,28(sp)
80002c74:	01412423          	sw	s4,8(sp)
80002c78:	00050493          	mv	s1,a0
80002c7c:	00058993          	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80002c80:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002c84:	00800413          	li	s0,8
80002c88:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002c8c:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002c90:	00847413          	andi	s0,s0,8
80002c94:	339010ef          	jal	ra,800047cc <z_spin_lock_valid>
80002c98:	02051e63          	bnez	a0,80002cd4 <z_impl_k_queue_get+0x78>
80002c9c:	80006a37          	lui	s4,0x80006
80002ca0:	800065b7          	lui	a1,0x80006
80002ca4:	80006537          	lui	a0,0x80006
80002ca8:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80002cac:	04e00693          	li	a3,78
80002cb0:	4bca0613          	addi	a2,s4,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002cb4:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002cb8:	810ff0ef          	jal	ra,80001cc8 <printk>
80002cbc:	80006537          	lui	a0,0x80006
80002cc0:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80002cc4:	804ff0ef          	jal	ra,80001cc8 <printk>
80002cc8:	04e00593          	li	a1,78
80002ccc:	4bca0513          	addi	a0,s4,1212
80002cd0:	834ff0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80002cd4:	00090513          	mv	a0,s2
80002cd8:	34d010ef          	jal	ra,80004824 <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
80002cdc:	0004a503          	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
80002ce0:	08050a63          	beqz	a0,80002d74 <z_impl_k_queue_get+0x118>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002ce4:	00052783          	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80002ce8:	0044a703          	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80002cec:	ffc7f793          	andi	a5,a5,-4
	list->head = node;
80002cf0:	00f4a023          	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80002cf4:	00e51463          	bne	a0,a4,80002cfc <z_impl_k_queue_get+0xa0>
	list->tail = node;
80002cf8:	00f4a223          	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
80002cfc:	00100593          	li	a1,1
80002d00:	ef1ff0ef          	jal	ra,80002bf0 <z_queue_node_peek>
80002d04:	00050493          	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002d08:	00090513          	mv	a0,s2
80002d0c:	2e9010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80002d10:	02051e63          	bnez	a0,80002d4c <z_impl_k_queue_get+0xf0>
80002d14:	80006937          	lui	s2,0x80006
80002d18:	800065b7          	lui	a1,0x80006
80002d1c:	80006537          	lui	a0,0x80006
80002d20:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80002d24:	06100693          	li	a3,97
80002d28:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002d2c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002d30:	f99fe0ef          	jal	ra,80001cc8 <printk>
80002d34:	80006537          	lui	a0,0x80006
80002d38:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80002d3c:	f8dfe0ef          	jal	ra,80001cc8 <printk>
80002d40:	06100593          	li	a1,97
80002d44:	4bc90513          	addi	a0,s2,1212
80002d48:	fbdfe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d4c:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
80002d50:	01c12083          	lw	ra,28(sp)
80002d54:	01812403          	lw	s0,24(sp)
80002d58:	00048513          	mv	a0,s1
80002d5c:	01012903          	lw	s2,16(sp)
80002d60:	01412483          	lw	s1,20(sp)
80002d64:	00c12983          	lw	s3,12(sp)
80002d68:	00812a03          	lw	s4,8(sp)
80002d6c:	02010113          	addi	sp,sp,32
80002d70:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80002d74:	04099a63          	bnez	s3,80002dc8 <z_impl_k_queue_get+0x16c>
80002d78:	00090513          	mv	a0,s2
80002d7c:	279010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80002d80:	02051e63          	bnez	a0,80002dbc <z_impl_k_queue_get+0x160>
80002d84:	800064b7          	lui	s1,0x80006
80002d88:	800065b7          	lui	a1,0x80006
80002d8c:	80006537          	lui	a0,0x80006
80002d90:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80002d94:	06100693          	li	a3,97
80002d98:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002d9c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002da0:	f29fe0ef          	jal	ra,80001cc8 <printk>
80002da4:	80006537          	lui	a0,0x80006
80002da8:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80002dac:	f1dfe0ef          	jal	ra,80001cc8 <printk>
80002db0:	06100593          	li	a1,97
80002db4:	4bc48513          	addi	a0,s1,1212
80002db8:	f4dfe0ef          	jal	ra,80001d04 <assert_post_action>
80002dbc:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
80002dc0:	00000493          	li	s1,0
80002dc4:	f8dff06f          	j	80002d50 <z_impl_k_queue_get+0xf4>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80002dc8:	00c48613          	addi	a2,s1,12
80002dcc:	00098693          	mv	a3,s3
80002dd0:	00040593          	mv	a1,s0
80002dd4:	00090513          	mv	a0,s2
80002dd8:	0a0010ef          	jal	ra,80003e78 <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
80002ddc:	00000493          	li	s1,0
80002de0:	f60518e3          	bnez	a0,80002d50 <z_impl_k_queue_get+0xf4>
80002de4:	800077b7          	lui	a5,0x80007
80002de8:	d4c7a783          	lw	a5,-692(a5) # 80006d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d4d>
80002dec:	0147a483          	lw	s1,20(a5)
80002df0:	f61ff06f          	j	80002d50 <z_impl_k_queue_get+0xf4>

80002df4 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002df4:	00d54783          	lbu	a5,13(a0)
80002df8:	01f7f793          	andi	a5,a5,31
80002dfc:	00079863          	bnez	a5,80002e0c <z_is_thread_ready+0x18>
80002e00:	01852503          	lw	a0,24(a0)
80002e04:	00153513          	seqz	a0,a0
80002e08:	00008067          	ret
80002e0c:	00000513          	li	a0,0
}
80002e10:	00008067          	ret

80002e14 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002e14:	ff010113          	addi	sp,sp,-16
80002e18:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002e1c:	b38ff0ef          	jal	ra,80002154 <z_clock_elapsed>
80002e20:	800077b7          	lui	a5,0x80007
80002e24:	a607a783          	lw	a5,-1440(a5) # 80006a60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a61>

	z_set_timeout_expiry(slice_time, false);
}
80002e28:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002e2c:	80007737          	lui	a4,0x80007
80002e30:	00a78533          	add	a0,a5,a0
80002e34:	d4a72a23          	sw	a0,-684(a4) # 80006d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d55>
	z_set_timeout_expiry(slice_time, false);
80002e38:	00000593          	li	a1,0
80002e3c:	00078513          	mv	a0,a5
}
80002e40:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002e44:	3240206f          	j	80005168 <z_set_timeout_expiry>

80002e48 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002e48:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002e4c:	ff010113          	addi	sp,sp,-16
80002e50:	00812423          	sw	s0,8(sp)
80002e54:	00112623          	sw	ra,12(sp)
80002e58:	00912223          	sw	s1,4(sp)
80002e5c:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002e60:	02079863          	bnez	a5,80002e90 <pended_on.isra.15+0x48>
80002e64:	800064b7          	lui	s1,0x80006
80002e68:	800065b7          	lui	a1,0x80006
80002e6c:	80006537          	lui	a0,0x80006
80002e70:	74858593          	addi	a1,a1,1864 # 80006748 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006749>
80002e74:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002e78:	18300693          	li	a3,387
80002e7c:	73448613          	addi	a2,s1,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
80002e80:	e49fe0ef          	jal	ra,80001cc8 <printk>
80002e84:	18300593          	li	a1,387
80002e88:	73448513          	addi	a0,s1,1844
80002e8c:	e79fe0ef          	jal	ra,80001d04 <assert_post_action>

	return thread->base.pended_on;
}
80002e90:	00042503          	lw	a0,0(s0)
80002e94:	00c12083          	lw	ra,12(sp)
80002e98:	00812403          	lw	s0,8(sp)
80002e9c:	00412483          	lw	s1,4(sp)
80002ea0:	01010113          	addi	sp,sp,16
80002ea4:	00008067          	ret

80002ea8 <k_sched_time_slice_set>:
{
80002ea8:	fe010113          	addi	sp,sp,-32
80002eac:	00812c23          	sw	s0,24(sp)
80002eb0:	01212823          	sw	s2,16(sp)
80002eb4:	01412423          	sw	s4,8(sp)
80002eb8:	00112e23          	sw	ra,28(sp)
80002ebc:	00912a23          	sw	s1,20(sp)
80002ec0:	01312623          	sw	s3,12(sp)
80002ec4:	00050913          	mv	s2,a0
80002ec8:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002ecc:	00800413          	li	s0,8
80002ed0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002ed4:	800074b7          	lui	s1,0x80007
80002ed8:	a5848513          	addi	a0,s1,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
80002edc:	00847413          	andi	s0,s0,8
80002ee0:	0ed010ef          	jal	ra,800047cc <z_spin_lock_valid>
80002ee4:	02051e63          	bnez	a0,80002f20 <k_sched_time_slice_set+0x78>
80002ee8:	800069b7          	lui	s3,0x80006
80002eec:	800065b7          	lui	a1,0x80006
80002ef0:	80006537          	lui	a0,0x80006
80002ef4:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80002ef8:	04e00693          	li	a3,78
80002efc:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002f00:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002f04:	dc5fe0ef          	jal	ra,80001cc8 <printk>
80002f08:	80006537          	lui	a0,0x80006
80002f0c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80002f10:	db9fe0ef          	jal	ra,80001cc8 <printk>
80002f14:	04e00593          	li	a1,78
80002f18:	4bc98513          	addi	a0,s3,1212
80002f1c:	de9fe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80002f20:	a5848513          	addi	a0,s1,-1448
80002f24:	101010ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002f28:	800077b7          	lui	a5,0x80007
80002f2c:	d407aa23          	sw	zero,-684(a5) # 80006d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d55>
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002f30:	00990913          	addi	s2,s2,9
80002f34:	00a00793          	li	a5,10
80002f38:	02f94933          	div	s2,s2,a5
		slice_time = z_ms_to_ticks(slice);
80002f3c:	800077b7          	lui	a5,0x80007
80002f40:	a727a023          	sw	s2,-1440(a5) # 80006a60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a61>
		slice_max_prio = prio;
80002f44:	800077b7          	lui	a5,0x80007
80002f48:	a547ae23          	sw	s4,-1444(a5) # 80006a5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a5d>
		reset_time_slice();
80002f4c:	ec9ff0ef          	jal	ra,80002e14 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002f50:	a5848513          	addi	a0,s1,-1448
80002f54:	0a1010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80002f58:	02051e63          	bnez	a0,80002f94 <k_sched_time_slice_set+0xec>
80002f5c:	800064b7          	lui	s1,0x80006
80002f60:	800065b7          	lui	a1,0x80006
80002f64:	80006537          	lui	a0,0x80006
80002f68:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80002f6c:	06100693          	li	a3,97
80002f70:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80002f74:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80002f78:	d51fe0ef          	jal	ra,80001cc8 <printk>
80002f7c:	80006537          	lui	a0,0x80006
80002f80:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80002f84:	d45fe0ef          	jal	ra,80001cc8 <printk>
80002f88:	06100593          	li	a1,97
80002f8c:	4bc48513          	addi	a0,s1,1212
80002f90:	d75fe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002f94:	30042473          	csrrs	s0,mstatus,s0
}
80002f98:	01c12083          	lw	ra,28(sp)
80002f9c:	01812403          	lw	s0,24(sp)
80002fa0:	01412483          	lw	s1,20(sp)
80002fa4:	01012903          	lw	s2,16(sp)
80002fa8:	00c12983          	lw	s3,12(sp)
80002fac:	00812a03          	lw	s4,8(sp)
80002fb0:	02010113          	addi	sp,sp,32
80002fb4:	00008067          	ret

80002fb8 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002fb8:	fe010113          	addi	sp,sp,-32
80002fbc:	00812c23          	sw	s0,24(sp)
80002fc0:	01212823          	sw	s2,16(sp)
80002fc4:	00112e23          	sw	ra,28(sp)
80002fc8:	00912a23          	sw	s1,20(sp)
80002fcc:	01312623          	sw	s3,12(sp)
80002fd0:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002fd4:	00800413          	li	s0,8
80002fd8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002fdc:	800074b7          	lui	s1,0x80007
80002fe0:	a5848513          	addi	a0,s1,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
80002fe4:	00847413          	andi	s0,s0,8
80002fe8:	7e4010ef          	jal	ra,800047cc <z_spin_lock_valid>
80002fec:	02051e63          	bnez	a0,80003028 <z_unpend_thread_no_timeout+0x70>
80002ff0:	800069b7          	lui	s3,0x80006
80002ff4:	800065b7          	lui	a1,0x80006
80002ff8:	80006537          	lui	a0,0x80006
80002ffc:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80003000:	04e00693          	li	a3,78
80003004:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003008:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000300c:	cbdfe0ef          	jal	ra,80001cc8 <printk>
80003010:	80006537          	lui	a0,0x80006
80003014:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80003018:	cb1fe0ef          	jal	ra,80001cc8 <printk>
8000301c:	04e00593          	li	a1,78
80003020:	4bc98513          	addi	a0,s3,1212
80003024:	ce1fe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80003028:	a5848513          	addi	a0,s1,-1448
8000302c:	7f8010ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003030:	00890513          	addi	a0,s2,8
80003034:	e15ff0ef          	jal	ra,80002e48 <pended_on.isra.15>
80003038:	00090593          	mv	a1,s2
8000303c:	2f0000ef          	jal	ra,8000332c <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003040:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003044:	a5848513          	addi	a0,s1,-1448
80003048:	ffd7f793          	andi	a5,a5,-3
8000304c:	00f906a3          	sb	a5,13(s2)
80003050:	7a4010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80003054:	02051e63          	bnez	a0,80003090 <z_unpend_thread_no_timeout+0xd8>
80003058:	800064b7          	lui	s1,0x80006
8000305c:	800065b7          	lui	a1,0x80006
80003060:	80006537          	lui	a0,0x80006
80003064:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003068:	06100693          	li	a3,97
8000306c:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003070:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003074:	c55fe0ef          	jal	ra,80001cc8 <printk>
80003078:	80006537          	lui	a0,0x80006
8000307c:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80003080:	c49fe0ef          	jal	ra,80001cc8 <printk>
80003084:	06100593          	li	a1,97
80003088:	4bc48513          	addi	a0,s1,1212
8000308c:	c79fe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003090:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80003094:	01c12083          	lw	ra,28(sp)
80003098:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
8000309c:	00092423          	sw	zero,8(s2)
}
800030a0:	01412483          	lw	s1,20(sp)
800030a4:	01012903          	lw	s2,16(sp)
800030a8:	00c12983          	lw	s3,12(sp)
800030ac:	02010113          	addi	sp,sp,32
800030b0:	00008067          	ret

800030b4 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
800030b4:	800077b7          	lui	a5,0x80007
800030b8:	d447a783          	lw	a5,-700(a5) # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
{
800030bc:	ff010113          	addi	sp,sp,-16
800030c0:	00812423          	sw	s0,8(sp)
800030c4:	00112623          	sw	ra,12(sp)
800030c8:	00912223          	sw	s1,4(sp)
800030cc:	00058413          	mv	s0,a1
	if (resched()) {
800030d0:	04079e63          	bnez	a5,8000312c <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800030d4:	720010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
800030d8:	02051e63          	bnez	a0,80003114 <z_reschedule+0x60>
800030dc:	800064b7          	lui	s1,0x80006
800030e0:	800065b7          	lui	a1,0x80006
800030e4:	80006537          	lui	a0,0x80006
800030e8:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800030ec:	07800693          	li	a3,120
800030f0:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800030f4:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800030f8:	bd1fe0ef          	jal	ra,80001cc8 <printk>
800030fc:	80006537          	lui	a0,0x80006
80003100:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80003104:	bc5fe0ef          	jal	ra,80001cc8 <printk>
80003108:	07800593          	li	a1,120
8000310c:	4bc48513          	addi	a0,s1,1212
80003110:	bf5fe0ef          	jal	ra,80001d04 <assert_post_action>
80003114:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80003118:	00812403          	lw	s0,8(sp)
8000311c:	00c12083          	lw	ra,12(sp)
80003120:	00412483          	lw	s1,4(sp)
80003124:	01010113          	addi	sp,sp,16
80003128:	900fd06f          	j	80000228 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000312c:	6c8010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80003130:	02051e63          	bnez	a0,8000316c <z_reschedule+0xb8>
80003134:	800064b7          	lui	s1,0x80006
80003138:	800065b7          	lui	a1,0x80006
8000313c:	80006537          	lui	a0,0x80006
80003140:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003144:	06100693          	li	a3,97
80003148:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000314c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003150:	b79fe0ef          	jal	ra,80001cc8 <printk>
80003154:	80006537          	lui	a0,0x80006
80003158:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
8000315c:	b6dfe0ef          	jal	ra,80001cc8 <printk>
80003160:	06100593          	li	a1,97
80003164:	4bc48513          	addi	a0,s1,1212
80003168:	b9dfe0ef          	jal	ra,80001d04 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
8000316c:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003170:	30042473          	csrrs	s0,mstatus,s0
80003174:	00c12083          	lw	ra,12(sp)
80003178:	00812403          	lw	s0,8(sp)
8000317c:	00412483          	lw	s1,4(sp)
80003180:	01010113          	addi	sp,sp,16
80003184:	00008067          	ret

80003188 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003188:	80007737          	lui	a4,0x80007
8000318c:	d4472703          	lw	a4,-700(a4) # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
80003190:	00071463          	bnez	a4,80003198 <z_reschedule_irqlock+0x10>
80003194:	894fd06f          	j	80000228 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003198:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000319c:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
800031a0:	00008067          	ret

800031a4 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800031a4:	00800513          	li	a0,8
800031a8:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
800031ac:	00857513          	andi	a0,a0,8
800031b0:	fd9ff06f          	j	80003188 <z_reschedule_irqlock>

800031b4 <k_sched_lock>:

void k_sched_lock(void)
{
800031b4:	fe010113          	addi	sp,sp,-32
800031b8:	00812c23          	sw	s0,24(sp)
800031bc:	00112e23          	sw	ra,28(sp)
800031c0:	00912a23          	sw	s1,20(sp)
800031c4:	01212823          	sw	s2,16(sp)
800031c8:	01312623          	sw	s3,12(sp)
800031cc:	00800413          	li	s0,8
800031d0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800031d4:	800074b7          	lui	s1,0x80007
800031d8:	a5848513          	addi	a0,s1,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
800031dc:	00847413          	andi	s0,s0,8
800031e0:	5ec010ef          	jal	ra,800047cc <z_spin_lock_valid>
800031e4:	02051e63          	bnez	a0,80003220 <k_sched_lock+0x6c>
800031e8:	80006937          	lui	s2,0x80006
800031ec:	800065b7          	lui	a1,0x80006
800031f0:	80006537          	lui	a0,0x80006
800031f4:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
800031f8:	04e00693          	li	a3,78
800031fc:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003200:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003204:	ac5fe0ef          	jal	ra,80001cc8 <printk>
80003208:	80006537          	lui	a0,0x80006
8000320c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80003210:	ab9fe0ef          	jal	ra,80001cc8 <printk>
80003214:	04e00593          	li	a1,78
80003218:	4bc90513          	addi	a0,s2,1212
8000321c:	ae9fe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80003220:	a5848513          	addi	a0,s1,-1448
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80003224:	80007937          	lui	s2,0x80007
80003228:	5fc010ef          	jal	ra,80004824 <z_spin_lock_set_owner>
8000322c:	d4492783          	lw	a5,-700(s2) # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
80003230:	d4490913          	addi	s2,s2,-700
80003234:	02078e63          	beqz	a5,80003270 <k_sched_lock+0xbc>
80003238:	800069b7          	lui	s3,0x80006
8000323c:	800065b7          	lui	a1,0x80006
80003240:	80006537          	lui	a0,0x80006
80003244:	6cc58593          	addi	a1,a1,1740 # 800066cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066cd>
80003248:	10000693          	li	a3,256
8000324c:	6b098613          	addi	a2,s3,1712 # 800066b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b1>
80003250:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003254:	a75fe0ef          	jal	ra,80001cc8 <printk>
80003258:	80006537          	lui	a0,0x80006
8000325c:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
80003260:	a69fe0ef          	jal	ra,80001cc8 <printk>
80003264:	10000593          	li	a1,256
80003268:	6b098513          	addi	a0,s3,1712
8000326c:	a99fe0ef          	jal	ra,80001d04 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80003270:	00892783          	lw	a5,8(s2)
80003274:	00f7c703          	lbu	a4,15(a5)
80003278:	00100793          	li	a5,1
8000327c:	02f71e63          	bne	a4,a5,800032b8 <k_sched_lock+0x104>
80003280:	800069b7          	lui	s3,0x80006
80003284:	800065b7          	lui	a1,0x80006
80003288:	80006537          	lui	a0,0x80006
8000328c:	6e458593          	addi	a1,a1,1764 # 800066e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066e5>
80003290:	10100693          	li	a3,257
80003294:	6b098613          	addi	a2,s3,1712 # 800066b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b1>
80003298:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000329c:	a2dfe0ef          	jal	ra,80001cc8 <printk>
800032a0:	80006537          	lui	a0,0x80006
800032a4:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
800032a8:	a21fe0ef          	jal	ra,80001cc8 <printk>
800032ac:	10100593          	li	a1,257
800032b0:	6b098513          	addi	a0,s3,1712
800032b4:	a51fe0ef          	jal	ra,80001d04 <assert_post_action>

	--_current->base.sched_locked;
800032b8:	00892703          	lw	a4,8(s2)
800032bc:	00f74783          	lbu	a5,15(a4)
800032c0:	fff78793          	addi	a5,a5,-1
800032c4:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800032c8:	a5848513          	addi	a0,s1,-1448
800032cc:	528010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
800032d0:	02051e63          	bnez	a0,8000330c <k_sched_lock+0x158>
800032d4:	800064b7          	lui	s1,0x80006
800032d8:	800065b7          	lui	a1,0x80006
800032dc:	80006537          	lui	a0,0x80006
800032e0:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800032e4:	06100693          	li	a3,97
800032e8:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800032ec:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800032f0:	9d9fe0ef          	jal	ra,80001cc8 <printk>
800032f4:	80006537          	lui	a0,0x80006
800032f8:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
800032fc:	9cdfe0ef          	jal	ra,80001cc8 <printk>
80003300:	06100593          	li	a1,97
80003304:	4bc48513          	addi	a0,s1,1212
80003308:	9fdfe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000330c:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80003310:	01c12083          	lw	ra,28(sp)
80003314:	01812403          	lw	s0,24(sp)
80003318:	01412483          	lw	s1,20(sp)
8000331c:	01012903          	lw	s2,16(sp)
80003320:	00c12983          	lw	s3,12(sp)
80003324:	02010113          	addi	sp,sp,32
80003328:	00008067          	ret

8000332c <z_priq_dumb_remove>:
	return thread == _idle_thread;
8000332c:	800077b7          	lui	a5,0x80007
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80003330:	9b07a783          	lw	a5,-1616(a5) # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
{
80003334:	ff010113          	addi	sp,sp,-16
80003338:	00812423          	sw	s0,8(sp)
8000333c:	00112623          	sw	ra,12(sp)
80003340:	00912223          	sw	s1,4(sp)
80003344:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80003348:	02f59863          	bne	a1,a5,80003378 <z_priq_dumb_remove+0x4c>
8000334c:	800064b7          	lui	s1,0x80006
80003350:	800065b7          	lui	a1,0x80006
80003354:	80006537          	lui	a0,0x80006
80003358:	78058593          	addi	a1,a1,1920 # 80006780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006781>
8000335c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003360:	28c00693          	li	a3,652
80003364:	73448613          	addi	a2,s1,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
80003368:	961fe0ef          	jal	ra,80001cc8 <printk>
8000336c:	28c00593          	li	a1,652
80003370:	73448513          	addi	a0,s1,1844
80003374:	991fe0ef          	jal	ra,80001d04 <assert_post_action>
	node->prev->next = node->next;
80003378:	00442703          	lw	a4,4(s0)
8000337c:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80003380:	00c12083          	lw	ra,12(sp)
80003384:	00412483          	lw	s1,4(sp)
80003388:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
8000338c:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80003390:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80003394:	00042223          	sw	zero,4(s0)
80003398:	00812403          	lw	s0,8(sp)
8000339c:	01010113          	addi	sp,sp,16
800033a0:	00008067          	ret

800033a4 <z_unpend_thread>:
{
800033a4:	fe010113          	addi	sp,sp,-32
800033a8:	00812c23          	sw	s0,24(sp)
800033ac:	00912a23          	sw	s1,20(sp)
800033b0:	00112e23          	sw	ra,28(sp)
800033b4:	01212823          	sw	s2,16(sp)
800033b8:	01312623          	sw	s3,12(sp)
800033bc:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033c0:	00800493          	li	s1,8
800033c4:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033c8:	80007937          	lui	s2,0x80007
800033cc:	a5890513          	addi	a0,s2,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
800033d0:	0084f493          	andi	s1,s1,8
800033d4:	3f8010ef          	jal	ra,800047cc <z_spin_lock_valid>
800033d8:	02051e63          	bnez	a0,80003414 <z_unpend_thread+0x70>
800033dc:	800069b7          	lui	s3,0x80006
800033e0:	800065b7          	lui	a1,0x80006
800033e4:	80006537          	lui	a0,0x80006
800033e8:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
800033ec:	04e00693          	li	a3,78
800033f0:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800033f4:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800033f8:	8d1fe0ef          	jal	ra,80001cc8 <printk>
800033fc:	80006537          	lui	a0,0x80006
80003400:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80003404:	8c5fe0ef          	jal	ra,80001cc8 <printk>
80003408:	04e00593          	li	a1,78
8000340c:	4bc98513          	addi	a0,s3,1212
80003410:	8f5fe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80003414:	a5890513          	addi	a0,s2,-1448
80003418:	40c010ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000341c:	00840513          	addi	a0,s0,8
80003420:	a29ff0ef          	jal	ra,80002e48 <pended_on.isra.15>
80003424:	00040593          	mv	a1,s0
80003428:	f05ff0ef          	jal	ra,8000332c <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000342c:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003430:	a5890513          	addi	a0,s2,-1448
80003434:	ffd7f793          	andi	a5,a5,-3
80003438:	00f406a3          	sb	a5,13(s0)
8000343c:	3b8010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80003440:	02051e63          	bnez	a0,8000347c <z_unpend_thread+0xd8>
80003444:	80006937          	lui	s2,0x80006
80003448:	800065b7          	lui	a1,0x80006
8000344c:	80006537          	lui	a0,0x80006
80003450:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003454:	06100693          	li	a3,97
80003458:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000345c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003460:	869fe0ef          	jal	ra,80001cc8 <printk>
80003464:	80006537          	lui	a0,0x80006
80003468:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
8000346c:	85dfe0ef          	jal	ra,80001cc8 <printk>
80003470:	06100593          	li	a1,97
80003474:	4bc90513          	addi	a0,s2,1212
80003478:	88dfe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000347c:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003480:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003484:	01840513          	addi	a0,s0,24
}
80003488:	01812403          	lw	s0,24(sp)
8000348c:	01c12083          	lw	ra,28(sp)
80003490:	01412483          	lw	s1,20(sp)
80003494:	01012903          	lw	s2,16(sp)
80003498:	00c12983          	lw	s3,12(sp)
8000349c:	02010113          	addi	sp,sp,32
800034a0:	2f50106f          	j	80004f94 <z_abort_timeout>

800034a4 <z_priq_dumb_best>:
	return list->head == list;
800034a4:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800034a8:	00f51463          	bne	a0,a5,800034b0 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
800034ac:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
800034b0:	00078513          	mv	a0,a5
800034b4:	00008067          	ret

800034b8 <update_cache>:
{
800034b8:	ff010113          	addi	sp,sp,-16
800034bc:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800034c0:	80007437          	lui	s0,0x80007
{
800034c4:	01212023          	sw	s2,0(sp)
800034c8:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800034cc:	d4440513          	addi	a0,s0,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
800034d0:	02450513          	addi	a0,a0,36
{
800034d4:	00912223          	sw	s1,4(sp)
800034d8:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800034dc:	fc9ff0ef          	jal	ra,800034a4 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
800034e0:	d4440413          	addi	s0,s0,-700
800034e4:	00050493          	mv	s1,a0
800034e8:	00051463          	bnez	a0,800034f0 <update_cache+0x38>
800034ec:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
800034f0:	06091e63          	bnez	s2,8000356c <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
800034f4:	00842783          	lw	a5,8(s0)
800034f8:	02079e63          	bnez	a5,80003534 <update_cache+0x7c>
800034fc:	80006937          	lui	s2,0x80006
80003500:	800065b7          	lui	a1,0x80006
80003504:	80006537          	lui	a0,0x80006
80003508:	76058593          	addi	a1,a1,1888 # 80006760 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006761>
8000350c:	07f00693          	li	a3,127
80003510:	73490613          	addi	a2,s2,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
80003514:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003518:	fb0fe0ef          	jal	ra,80001cc8 <printk>
8000351c:	80006537          	lui	a0,0x80006
80003520:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
80003524:	fa4fe0ef          	jal	ra,80001cc8 <printk>
80003528:	07f00593          	li	a1,127
8000352c:	73490513          	addi	a0,s2,1844
80003530:	fd4fe0ef          	jal	ra,80001d04 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80003534:	00842783          	lw	a5,8(s0)
80003538:	00d7c703          	lbu	a4,13(a5)
8000353c:	01f77713          	andi	a4,a4,31
80003540:	02071663          	bnez	a4,8000356c <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
80003544:	00e7d683          	lhu	a3,14(a5)
80003548:	07f00713          	li	a4,127
8000354c:	02d77063          	bgeu	a4,a3,8000356c <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
80003550:	02f42023          	sw	a5,32(s0)
}
80003554:	00c12083          	lw	ra,12(sp)
80003558:	00812403          	lw	s0,8(sp)
8000355c:	00412483          	lw	s1,4(sp)
80003560:	00012903          	lw	s2,0(sp)
80003564:	01010113          	addi	sp,sp,16
80003568:	00008067          	ret
		if (th != _current) {
8000356c:	00842783          	lw	a5,8(s0)
80003570:	00978463          	beq	a5,s1,80003578 <update_cache+0xc0>
			reset_time_slice();
80003574:	8a1ff0ef          	jal	ra,80002e14 <reset_time_slice>
		_kernel.ready_q.cache = th;
80003578:	02942023          	sw	s1,32(s0)
}
8000357c:	fd9ff06f          	j	80003554 <update_cache+0x9c>

80003580 <k_sched_unlock>:
{
80003580:	fe010113          	addi	sp,sp,-32
80003584:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003588:	80007937          	lui	s2,0x80007
8000358c:	d4490793          	addi	a5,s2,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
80003590:	0087a783          	lw	a5,8(a5)
{
80003594:	00112e23          	sw	ra,28(sp)
80003598:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
8000359c:	00f7c783          	lbu	a5,15(a5)
{
800035a0:	00912a23          	sw	s1,20(sp)
800035a4:	01312623          	sw	s3,12(sp)
800035a8:	d4490913          	addi	s2,s2,-700
	__ASSERT(_current->base.sched_locked != 0, "");
800035ac:	02079e63          	bnez	a5,800035e8 <k_sched_unlock+0x68>
800035b0:	80006437          	lui	s0,0x80006
800035b4:	800065b7          	lui	a1,0x80006
800035b8:	80006537          	lui	a0,0x80006
800035bc:	70c58593          	addi	a1,a1,1804 # 8000670c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000670d>
800035c0:	22100693          	li	a3,545
800035c4:	73440613          	addi	a2,s0,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
800035c8:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800035cc:	efcfe0ef          	jal	ra,80001cc8 <printk>
800035d0:	80006537          	lui	a0,0x80006
800035d4:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
800035d8:	ef0fe0ef          	jal	ra,80001cc8 <printk>
800035dc:	22100593          	li	a1,545
800035e0:	73440513          	addi	a0,s0,1844
800035e4:	f20fe0ef          	jal	ra,80001d04 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800035e8:	00092783          	lw	a5,0(s2)
800035ec:	02078e63          	beqz	a5,80003628 <k_sched_unlock+0xa8>
800035f0:	80006437          	lui	s0,0x80006
800035f4:	800065b7          	lui	a1,0x80006
800035f8:	80006537          	lui	a0,0x80006
800035fc:	6cc58593          	addi	a1,a1,1740 # 800066cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066cd>
80003600:	22200693          	li	a3,546
80003604:	73440613          	addi	a2,s0,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
80003608:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000360c:	ebcfe0ef          	jal	ra,80001cc8 <printk>
80003610:	80006537          	lui	a0,0x80006
80003614:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
80003618:	eb0fe0ef          	jal	ra,80001cc8 <printk>
8000361c:	22200593          	li	a1,546
80003620:	73440513          	addi	a0,s0,1844
80003624:	ee0fe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003628:	00800413          	li	s0,8
8000362c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003630:	800074b7          	lui	s1,0x80007
80003634:	a5848513          	addi	a0,s1,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003638:	00847413          	andi	s0,s0,8
8000363c:	190010ef          	jal	ra,800047cc <z_spin_lock_valid>
80003640:	02051e63          	bnez	a0,8000367c <k_sched_unlock+0xfc>
80003644:	800069b7          	lui	s3,0x80006
80003648:	800065b7          	lui	a1,0x80006
8000364c:	80006537          	lui	a0,0x80006
80003650:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80003654:	04e00693          	li	a3,78
80003658:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000365c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003660:	e68fe0ef          	jal	ra,80001cc8 <printk>
80003664:	80006537          	lui	a0,0x80006
80003668:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
8000366c:	e5cfe0ef          	jal	ra,80001cc8 <printk>
80003670:	04e00593          	li	a1,78
80003674:	4bc98513          	addi	a0,s3,1212
80003678:	e8cfe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
8000367c:	a5848513          	addi	a0,s1,-1448
80003680:	1a4010ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80003684:	00892703          	lw	a4,8(s2)
		update_cache(1);
80003688:	00100513          	li	a0,1
		++_current->base.sched_locked;
8000368c:	00f74783          	lbu	a5,15(a4)
80003690:	00178793          	addi	a5,a5,1
80003694:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80003698:	e21ff0ef          	jal	ra,800034b8 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000369c:	a5848513          	addi	a0,s1,-1448
800036a0:	154010ef          	jal	ra,800047f4 <z_spin_unlock_valid>
800036a4:	02051e63          	bnez	a0,800036e0 <k_sched_unlock+0x160>
800036a8:	800064b7          	lui	s1,0x80006
800036ac:	800065b7          	lui	a1,0x80006
800036b0:	80006537          	lui	a0,0x80006
800036b4:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800036b8:	06100693          	li	a3,97
800036bc:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800036c0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800036c4:	e04fe0ef          	jal	ra,80001cc8 <printk>
800036c8:	80006537          	lui	a0,0x80006
800036cc:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
800036d0:	df8fe0ef          	jal	ra,80001cc8 <printk>
800036d4:	06100593          	li	a1,97
800036d8:	4bc48513          	addi	a0,s1,1212
800036dc:	e28fe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800036e0:	30042473          	csrrs	s0,mstatus,s0
}
800036e4:	01812403          	lw	s0,24(sp)
800036e8:	01c12083          	lw	ra,28(sp)
800036ec:	01412483          	lw	s1,20(sp)
800036f0:	01012903          	lw	s2,16(sp)
800036f4:	00c12983          	lw	s3,12(sp)
800036f8:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
800036fc:	aa9ff06f          	j	800031a4 <z_reschedule_unlocked>

80003700 <z_add_thread_to_ready_q>:
{
80003700:	fe010113          	addi	sp,sp,-32
80003704:	00812c23          	sw	s0,24(sp)
80003708:	00912a23          	sw	s1,20(sp)
8000370c:	00112e23          	sw	ra,28(sp)
80003710:	01212823          	sw	s2,16(sp)
80003714:	01312623          	sw	s3,12(sp)
80003718:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000371c:	00800493          	li	s1,8
80003720:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003724:	80007937          	lui	s2,0x80007
80003728:	a5890513          	addi	a0,s2,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
8000372c:	0084f493          	andi	s1,s1,8
80003730:	09c010ef          	jal	ra,800047cc <z_spin_lock_valid>
80003734:	02051e63          	bnez	a0,80003770 <z_add_thread_to_ready_q+0x70>
80003738:	800069b7          	lui	s3,0x80006
8000373c:	800065b7          	lui	a1,0x80006
80003740:	80006537          	lui	a0,0x80006
80003744:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80003748:	04e00693          	li	a3,78
8000374c:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003750:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003754:	d74fe0ef          	jal	ra,80001cc8 <printk>
80003758:	80006537          	lui	a0,0x80006
8000375c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80003760:	d68fe0ef          	jal	ra,80001cc8 <printk>
80003764:	04e00593          	li	a1,78
80003768:	4bc98513          	addi	a0,s3,1212
8000376c:	d98fe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80003770:	a5890513          	addi	a0,s2,-1448
80003774:	0b0010ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003778:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
8000377c:	9b07a783          	lw	a5,-1616(a5) # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
80003780:	02f41863          	bne	s0,a5,800037b0 <z_add_thread_to_ready_q+0xb0>
80003784:	800069b7          	lui	s3,0x80006
80003788:	800065b7          	lui	a1,0x80006
8000378c:	80006537          	lui	a0,0x80006
80003790:	78058593          	addi	a1,a1,1920 # 80006780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006781>
80003794:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003798:	27600693          	li	a3,630
8000379c:	73498613          	addi	a2,s3,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
800037a0:	d28fe0ef          	jal	ra,80001cc8 <printk>
800037a4:	27600593          	li	a1,630
800037a8:	73498513          	addi	a0,s3,1844
800037ac:	d58fe0ef          	jal	ra,80001d04 <assert_post_action>
	return list->head == list;
800037b0:	80007737          	lui	a4,0x80007
800037b4:	d4470693          	addi	a3,a4,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
800037b8:	0246a783          	lw	a5,36(a3)
800037bc:	0286a603          	lw	a2,40(a3)
800037c0:	800076b7          	lui	a3,0x80007
800037c4:	d6868693          	addi	a3,a3,-664 # 80006d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d69>
800037c8:	d4470713          	addi	a4,a4,-700
	return sys_dlist_is_empty(list) ? NULL : list->head;
800037cc:	0ad78663          	beq	a5,a3,80003878 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800037d0:	0a078463          	beqz	a5,80003878 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
800037d4:	00e40583          	lb	a1,14(s0)
800037d8:	00e78503          	lb	a0,14(a5)
800037dc:	08a5d863          	bge	a1,a0,8000386c <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
800037e0:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800037e4:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
800037e8:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800037ec:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800037f0:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
800037f4:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
800037f8:	00000513          	li	a0,0
800037fc:	0407e793          	ori	a5,a5,64
80003800:	00f406a3          	sb	a5,13(s0)
80003804:	cb5ff0ef          	jal	ra,800034b8 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003808:	a5890513          	addi	a0,s2,-1448
8000380c:	7e9000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80003810:	02051e63          	bnez	a0,8000384c <z_add_thread_to_ready_q+0x14c>
80003814:	80006437          	lui	s0,0x80006
80003818:	800065b7          	lui	a1,0x80006
8000381c:	80006537          	lui	a0,0x80006
80003820:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003824:	06100693          	li	a3,97
80003828:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000382c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003830:	c98fe0ef          	jal	ra,80001cc8 <printk>
80003834:	80006537          	lui	a0,0x80006
80003838:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
8000383c:	c8cfe0ef          	jal	ra,80001cc8 <printk>
80003840:	06100593          	li	a1,97
80003844:	4bc40513          	addi	a0,s0,1212
80003848:	cbcfe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000384c:	3004a4f3          	csrrs	s1,mstatus,s1
}
80003850:	01c12083          	lw	ra,28(sp)
80003854:	01812403          	lw	s0,24(sp)
80003858:	01412483          	lw	s1,20(sp)
8000385c:	01012903          	lw	s2,16(sp)
80003860:	00c12983          	lw	s3,12(sp)
80003864:	02010113          	addi	sp,sp,32
80003868:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
8000386c:	00f60663          	beq	a2,a5,80003878 <z_add_thread_to_ready_q+0x178>
80003870:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003874:	f60792e3          	bnez	a5,800037d8 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80003878:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
8000387c:	02872783          	lw	a5,40(a4)
	node->next = list;
80003880:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80003884:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003888:	02872423          	sw	s0,40(a4)
8000388c:	f69ff06f          	j	800037f4 <z_add_thread_to_ready_q+0xf4>

80003890 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80003890:	ff052783          	lw	a5,-16(a0)
{
80003894:	fe010113          	addi	sp,sp,-32
80003898:	00812c23          	sw	s0,24(sp)
8000389c:	01312623          	sw	s3,12(sp)
800038a0:	00112e23          	sw	ra,28(sp)
800038a4:	00912a23          	sw	s1,20(sp)
800038a8:	01212823          	sw	s2,16(sp)
800038ac:	01412423          	sw	s4,8(sp)
800038b0:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
800038b4:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
800038b8:	0c078463          	beqz	a5,80003980 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800038bc:	00800493          	li	s1,8
800038c0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800038c4:	80007937          	lui	s2,0x80007
800038c8:	a5890513          	addi	a0,s2,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
800038cc:	0084f493          	andi	s1,s1,8
800038d0:	6fd000ef          	jal	ra,800047cc <z_spin_lock_valid>
800038d4:	02051e63          	bnez	a0,80003910 <z_thread_timeout+0x80>
800038d8:	80006a37          	lui	s4,0x80006
800038dc:	800065b7          	lui	a1,0x80006
800038e0:	80006537          	lui	a0,0x80006
800038e4:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
800038e8:	04e00693          	li	a3,78
800038ec:	4bca0613          	addi	a2,s4,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800038f0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800038f4:	bd4fe0ef          	jal	ra,80001cc8 <printk>
800038f8:	80006537          	lui	a0,0x80006
800038fc:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80003900:	bc8fe0ef          	jal	ra,80001cc8 <printk>
80003904:	04e00593          	li	a1,78
80003908:	4bca0513          	addi	a0,s4,1212
8000390c:	bf8fe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80003910:	a5890513          	addi	a0,s2,-1448
80003914:	711000ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003918:	ff040513          	addi	a0,s0,-16
8000391c:	d2cff0ef          	jal	ra,80002e48 <pended_on.isra.15>
80003920:	00098593          	mv	a1,s3
80003924:	a09ff0ef          	jal	ra,8000332c <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003928:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000392c:	a5890513          	addi	a0,s2,-1448
80003930:	ffd7f793          	andi	a5,a5,-3
80003934:	fef40aa3          	sb	a5,-11(s0)
80003938:	6bd000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
8000393c:	02051e63          	bnez	a0,80003978 <z_thread_timeout+0xe8>
80003940:	80006937          	lui	s2,0x80006
80003944:	800065b7          	lui	a1,0x80006
80003948:	80006537          	lui	a0,0x80006
8000394c:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003950:	06100693          	li	a3,97
80003954:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003958:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000395c:	b6cfe0ef          	jal	ra,80001cc8 <printk>
80003960:	80006537          	lui	a0,0x80006
80003964:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80003968:	b60fe0ef          	jal	ra,80001cc8 <printk>
8000396c:	06100593          	li	a1,97
80003970:	4bc90513          	addi	a0,s2,1212
80003974:	b90fe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003978:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
8000397c:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003980:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003984:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003988:	feb7f793          	andi	a5,a5,-21
8000398c:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003990:	c64ff0ef          	jal	ra,80002df4 <z_is_thread_ready>
80003994:	02050463          	beqz	a0,800039bc <z_thread_timeout+0x12c>
}
80003998:	01812403          	lw	s0,24(sp)
8000399c:	01c12083          	lw	ra,28(sp)
800039a0:	01412483          	lw	s1,20(sp)
800039a4:	01012903          	lw	s2,16(sp)
800039a8:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
800039ac:	00098513          	mv	a0,s3
800039b0:	00c12983          	lw	s3,12(sp)
800039b4:	02010113          	addi	sp,sp,32
800039b8:	d49ff06f          	j	80003700 <z_add_thread_to_ready_q>
800039bc:	01c12083          	lw	ra,28(sp)
800039c0:	01812403          	lw	s0,24(sp)
800039c4:	01412483          	lw	s1,20(sp)
800039c8:	01012903          	lw	s2,16(sp)
800039cc:	00c12983          	lw	s3,12(sp)
800039d0:	00812a03          	lw	s4,8(sp)
800039d4:	02010113          	addi	sp,sp,32
800039d8:	00008067          	ret

800039dc <z_move_thread_to_end_of_prio_q>:
{
800039dc:	fe010113          	addi	sp,sp,-32
800039e0:	00812c23          	sw	s0,24(sp)
800039e4:	01212823          	sw	s2,16(sp)
800039e8:	00112e23          	sw	ra,28(sp)
800039ec:	00912a23          	sw	s1,20(sp)
800039f0:	01312623          	sw	s3,12(sp)
800039f4:	01412423          	sw	s4,8(sp)
800039f8:	01512223          	sw	s5,4(sp)
800039fc:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003a00:	00800913          	li	s2,8
80003a04:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a08:	800079b7          	lui	s3,0x80007
80003a0c:	a5898513          	addi	a0,s3,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a10:	00897913          	andi	s2,s2,8
80003a14:	5b9000ef          	jal	ra,800047cc <z_spin_lock_valid>
80003a18:	02051e63          	bnez	a0,80003a54 <z_move_thread_to_end_of_prio_q+0x78>
80003a1c:	800064b7          	lui	s1,0x80006
80003a20:	800065b7          	lui	a1,0x80006
80003a24:	80006537          	lui	a0,0x80006
80003a28:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80003a2c:	04e00693          	li	a3,78
80003a30:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003a34:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003a38:	a90fe0ef          	jal	ra,80001cc8 <printk>
80003a3c:	80006537          	lui	a0,0x80006
80003a40:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80003a44:	a84fe0ef          	jal	ra,80001cc8 <printk>
80003a48:	04e00593          	li	a1,78
80003a4c:	4bc48513          	addi	a0,s1,1212
80003a50:	ab4fe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80003a54:	a5898513          	addi	a0,s3,-1448
80003a58:	5cd000ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80003a5c:	800074b7          	lui	s1,0x80007
80003a60:	d4448513          	addi	a0,s1,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
80003a64:	00040593          	mv	a1,s0
80003a68:	02450513          	addi	a0,a0,36
80003a6c:	8c1ff0ef          	jal	ra,8000332c <z_priq_dumb_remove>
	return thread == _idle_thread;
80003a70:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003a74:	9b07a783          	lw	a5,-1616(a5) # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
80003a78:	80007a37          	lui	s4,0x80007
80003a7c:	d4448493          	addi	s1,s1,-700
80003a80:	d68a0a13          	addi	s4,s4,-664 # 80006d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d69>
80003a84:	02f41863          	bne	s0,a5,80003ab4 <z_move_thread_to_end_of_prio_q+0xd8>
80003a88:	80006ab7          	lui	s5,0x80006
80003a8c:	800065b7          	lui	a1,0x80006
80003a90:	80006537          	lui	a0,0x80006
80003a94:	78058593          	addi	a1,a1,1920 # 80006780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006781>
80003a98:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003a9c:	27600693          	li	a3,630
80003aa0:	734a8613          	addi	a2,s5,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
80003aa4:	a24fe0ef          	jal	ra,80001cc8 <printk>
80003aa8:	27600593          	li	a1,630
80003aac:	734a8513          	addi	a0,s5,1844
80003ab0:	a54fe0ef          	jal	ra,80001d04 <assert_post_action>
	return list->head == list;
80003ab4:	0244a783          	lw	a5,36(s1)
80003ab8:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003abc:	0b478e63          	beq	a5,s4,80003b78 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ac0:	0a078c63          	beqz	a5,80003b78 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003ac4:	00e40683          	lb	a3,14(s0)
80003ac8:	00e78603          	lb	a2,14(a5)
80003acc:	0ac6d063          	bge	a3,a2,80003b6c <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80003ad0:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003ad4:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003ad8:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003adc:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003ae0:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003ae4:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003ae8:	0084a503          	lw	a0,8(s1)
80003aec:	0407e793          	ori	a5,a5,64
80003af0:	40850533          	sub	a0,a0,s0
80003af4:	00153513          	seqz	a0,a0
80003af8:	00f406a3          	sb	a5,13(s0)
80003afc:	9bdff0ef          	jal	ra,800034b8 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b00:	a5898513          	addi	a0,s3,-1448
80003b04:	4f1000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80003b08:	02051e63          	bnez	a0,80003b44 <z_move_thread_to_end_of_prio_q+0x168>
80003b0c:	80006437          	lui	s0,0x80006
80003b10:	800065b7          	lui	a1,0x80006
80003b14:	80006537          	lui	a0,0x80006
80003b18:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003b1c:	06100693          	li	a3,97
80003b20:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003b24:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003b28:	9a0fe0ef          	jal	ra,80001cc8 <printk>
80003b2c:	80006537          	lui	a0,0x80006
80003b30:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80003b34:	994fe0ef          	jal	ra,80001cc8 <printk>
80003b38:	06100593          	li	a1,97
80003b3c:	4bc40513          	addi	a0,s0,1212
80003b40:	9c4fe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003b44:	30092973          	csrrs	s2,mstatus,s2
}
80003b48:	01c12083          	lw	ra,28(sp)
80003b4c:	01812403          	lw	s0,24(sp)
80003b50:	01412483          	lw	s1,20(sp)
80003b54:	01012903          	lw	s2,16(sp)
80003b58:	00c12983          	lw	s3,12(sp)
80003b5c:	00812a03          	lw	s4,8(sp)
80003b60:	00412a83          	lw	s5,4(sp)
80003b64:	02010113          	addi	sp,sp,32
80003b68:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003b6c:	00e78663          	beq	a5,a4,80003b78 <z_move_thread_to_end_of_prio_q+0x19c>
80003b70:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003b74:	f4079ae3          	bnez	a5,80003ac8 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003b78:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003b7c:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003b80:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003b84:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003b88:	0284a423          	sw	s0,40(s1)
80003b8c:	f59ff06f          	j	80003ae4 <z_move_thread_to_end_of_prio_q+0x108>

80003b90 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003b90:	800077b7          	lui	a5,0x80007
80003b94:	a607a783          	lw	a5,-1440(a5) # 80006a60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a61>
80003b98:	06078663          	beqz	a5,80003c04 <z_time_slice+0x74>
80003b9c:	800077b7          	lui	a5,0x80007
80003ba0:	d4478793          	addi	a5,a5,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
80003ba4:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003ba8:	07f00693          	li	a3,127
80003bac:	00e75603          	lhu	a2,14(a4)
80003bb0:	04c6ea63          	bltu	a3,a2,80003c04 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003bb4:	800076b7          	lui	a3,0x80007
80003bb8:	00e70603          	lb	a2,14(a4)
80003bbc:	a5c6a683          	lw	a3,-1444(a3) # 80006a5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a5d>
80003bc0:	04d64263          	blt	a2,a3,80003c04 <z_time_slice+0x74>
	return thread == _idle_thread;
80003bc4:	800076b7          	lui	a3,0x80007
		&& !is_idle(t)
80003bc8:	9b06a683          	lw	a3,-1616(a3) # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
80003bcc:	02d70c63          	beq	a4,a3,80003c04 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80003bd0:	01872683          	lw	a3,24(a4)
80003bd4:	02069863          	bnez	a3,80003c04 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003bd8:	0107a683          	lw	a3,16(a5)
80003bdc:	02d54063          	blt	a0,a3,80003bfc <z_time_slice+0x6c>
{
80003be0:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003be4:	00070513          	mv	a0,a4
{
80003be8:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003bec:	df1ff0ef          	jal	ra,800039dc <z_move_thread_to_end_of_prio_q>
}
80003bf0:	00c12083          	lw	ra,12(sp)
80003bf4:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003bf8:	a1cff06f          	j	80002e14 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003bfc:	40a686b3          	sub	a3,a3,a0
80003c00:	00d7a823          	sw	a3,16(a5)
80003c04:	00008067          	ret

80003c08 <z_remove_thread_from_ready_q>:
{
80003c08:	fe010113          	addi	sp,sp,-32
80003c0c:	00812c23          	sw	s0,24(sp)
80003c10:	01312623          	sw	s3,12(sp)
80003c14:	00112e23          	sw	ra,28(sp)
80003c18:	00912a23          	sw	s1,20(sp)
80003c1c:	01212823          	sw	s2,16(sp)
80003c20:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c24:	00800413          	li	s0,8
80003c28:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c2c:	800074b7          	lui	s1,0x80007
80003c30:	a5848513          	addi	a0,s1,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c34:	00847413          	andi	s0,s0,8
80003c38:	395000ef          	jal	ra,800047cc <z_spin_lock_valid>
80003c3c:	02051e63          	bnez	a0,80003c78 <z_remove_thread_from_ready_q+0x70>
80003c40:	80006937          	lui	s2,0x80006
80003c44:	800065b7          	lui	a1,0x80006
80003c48:	80006537          	lui	a0,0x80006
80003c4c:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80003c50:	04e00693          	li	a3,78
80003c54:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003c58:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003c5c:	86cfe0ef          	jal	ra,80001cc8 <printk>
80003c60:	80006537          	lui	a0,0x80006
80003c64:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80003c68:	860fe0ef          	jal	ra,80001cc8 <printk>
80003c6c:	04e00593          	li	a1,78
80003c70:	4bc90513          	addi	a0,s2,1212
80003c74:	890fe0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80003c78:	a5848513          	addi	a0,s1,-1448
80003c7c:	3a9000ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003c80:	00d9c783          	lbu	a5,13(s3)
80003c84:	80007937          	lui	s2,0x80007
80003c88:	d4490913          	addi	s2,s2,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
80003c8c:	0407f793          	andi	a5,a5,64
80003c90:	00078e63          	beqz	a5,80003cac <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003c94:	00098593          	mv	a1,s3
80003c98:	02490513          	addi	a0,s2,36
80003c9c:	e90ff0ef          	jal	ra,8000332c <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80003ca0:	00d9c783          	lbu	a5,13(s3)
80003ca4:	fbf7f793          	andi	a5,a5,-65
80003ca8:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003cac:	00892503          	lw	a0,8(s2)
80003cb0:	41350533          	sub	a0,a0,s3
80003cb4:	00153513          	seqz	a0,a0
80003cb8:	801ff0ef          	jal	ra,800034b8 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003cbc:	a5848513          	addi	a0,s1,-1448
80003cc0:	335000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80003cc4:	02051e63          	bnez	a0,80003d00 <z_remove_thread_from_ready_q+0xf8>
80003cc8:	800064b7          	lui	s1,0x80006
80003ccc:	800065b7          	lui	a1,0x80006
80003cd0:	80006537          	lui	a0,0x80006
80003cd4:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003cd8:	06100693          	li	a3,97
80003cdc:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003ce0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003ce4:	fe5fd0ef          	jal	ra,80001cc8 <printk>
80003ce8:	80006537          	lui	a0,0x80006
80003cec:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80003cf0:	fd9fd0ef          	jal	ra,80001cc8 <printk>
80003cf4:	06100593          	li	a1,97
80003cf8:	4bc48513          	addi	a0,s1,1212
80003cfc:	808fe0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003d00:	30042473          	csrrs	s0,mstatus,s0
}
80003d04:	01c12083          	lw	ra,28(sp)
80003d08:	01812403          	lw	s0,24(sp)
80003d0c:	01412483          	lw	s1,20(sp)
80003d10:	01012903          	lw	s2,16(sp)
80003d14:	00c12983          	lw	s3,12(sp)
80003d18:	02010113          	addi	sp,sp,32
80003d1c:	00008067          	ret

80003d20 <pend>:
{
80003d20:	fe010113          	addi	sp,sp,-32
80003d24:	00812c23          	sw	s0,24(sp)
80003d28:	00912a23          	sw	s1,20(sp)
80003d2c:	00050413          	mv	s0,a0
80003d30:	01212823          	sw	s2,16(sp)
80003d34:	00112e23          	sw	ra,28(sp)
80003d38:	01312623          	sw	s3,12(sp)
80003d3c:	00058493          	mv	s1,a1
80003d40:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003d44:	ec5ff0ef          	jal	ra,80003c08 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003d48:	00d44783          	lbu	a5,13(s0)
80003d4c:	0027e793          	ori	a5,a5,2
80003d50:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003d54:	06048663          	beqz	s1,80003dc0 <pend+0xa0>
	return thread == _idle_thread;
80003d58:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003d5c:	9b07a783          	lw	a5,-1616(a5) # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
		thread->base.pended_on = wait_q;
80003d60:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003d64:	02f41863          	bne	s0,a5,80003d94 <pend+0x74>
80003d68:	800069b7          	lui	s3,0x80006
80003d6c:	800065b7          	lui	a1,0x80006
80003d70:	80006537          	lui	a0,0x80006
80003d74:	78058593          	addi	a1,a1,1920 # 80006780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006781>
80003d78:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003d7c:	27600693          	li	a3,630
80003d80:	73498613          	addi	a2,s3,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
80003d84:	f45fd0ef          	jal	ra,80001cc8 <printk>
80003d88:	27600593          	li	a1,630
80003d8c:	73498513          	addi	a0,s3,1844
80003d90:	f75fd0ef          	jal	ra,80001d04 <assert_post_action>
	return list->head == list;
80003d94:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003d98:	06f48c63          	beq	s1,a5,80003e10 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003d9c:	06078a63          	beqz	a5,80003e10 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80003da0:	00e40703          	lb	a4,14(s0)
80003da4:	00e78683          	lb	a3,14(a5)
80003da8:	04d75c63          	bge	a4,a3,80003e00 <pend+0xe0>
	node->prev = successor->prev;
80003dac:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003db0:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003db4:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003db8:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003dbc:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003dc0:	fff00793          	li	a5,-1
80003dc4:	06f90463          	beq	s2,a5,80003e2c <pend+0x10c>
80003dc8:	00990913          	addi	s2,s2,9
80003dcc:	00a00613          	li	a2,10
80003dd0:	02c94633          	div	a2,s2,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003dd4:	01840513          	addi	a0,s0,24
}
80003dd8:	01812403          	lw	s0,24(sp)
80003ddc:	01c12083          	lw	ra,28(sp)
80003de0:	01412483          	lw	s1,20(sp)
80003de4:	01012903          	lw	s2,16(sp)
80003de8:	00c12983          	lw	s3,12(sp)
80003dec:	800045b7          	lui	a1,0x80004
80003df0:	89058593          	addi	a1,a1,-1904 # 80003890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003891>
80003df4:	02010113          	addi	sp,sp,32
80003df8:	00160613          	addi	a2,a2,1
80003dfc:	76d0006f          	j	80004d68 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003e00:	0044a683          	lw	a3,4(s1)
80003e04:	00d78663          	beq	a5,a3,80003e10 <pend+0xf0>
80003e08:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003e0c:	f8079ce3          	bnez	a5,80003da4 <pend+0x84>
	node->prev = list->tail;
80003e10:	0044a783          	lw	a5,4(s1)
	node->next = list;
80003e14:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80003e18:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80003e1c:	0044a783          	lw	a5,4(s1)
80003e20:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003e24:	0084a223          	sw	s0,4(s1)
80003e28:	f99ff06f          	j	80003dc0 <pend+0xa0>
}
80003e2c:	01c12083          	lw	ra,28(sp)
80003e30:	01812403          	lw	s0,24(sp)
80003e34:	01412483          	lw	s1,20(sp)
80003e38:	01012903          	lw	s2,16(sp)
80003e3c:	00c12983          	lw	s3,12(sp)
80003e40:	02010113          	addi	sp,sp,32
80003e44:	00008067          	ret

80003e48 <z_pend_curr_irqlock>:
{
80003e48:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003e4c:	800077b7          	lui	a5,0x80007
{
80003e50:	00812423          	sw	s0,8(sp)
80003e54:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003e58:	d4c7a503          	lw	a0,-692(a5) # 80006d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d4d>
{
80003e5c:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003e60:	ec1ff0ef          	jal	ra,80003d20 <pend>
80003e64:	00040513          	mv	a0,s0
}
80003e68:	00812403          	lw	s0,8(sp)
80003e6c:	00c12083          	lw	ra,12(sp)
80003e70:	01010113          	addi	sp,sp,16
80003e74:	bb4fc06f          	j	80000228 <__swap>

80003e78 <z_pend_curr>:
{
80003e78:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003e7c:	800077b7          	lui	a5,0x80007
{
80003e80:	00812423          	sw	s0,8(sp)
80003e84:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003e88:	d4c7a503          	lw	a0,-692(a5) # 80006d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d4d>
{
80003e8c:	00912223          	sw	s1,4(sp)
80003e90:	00058493          	mv	s1,a1
80003e94:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80003e98:	00068613          	mv	a2,a3
{
80003e9c:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003ea0:	e81ff0ef          	jal	ra,80003d20 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ea4:	00040513          	mv	a0,s0
80003ea8:	14d000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80003eac:	02051e63          	bnez	a0,80003ee8 <z_pend_curr+0x70>
80003eb0:	80006437          	lui	s0,0x80006
80003eb4:	800065b7          	lui	a1,0x80006
80003eb8:	80006537          	lui	a0,0x80006
80003ebc:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003ec0:	07800693          	li	a3,120
80003ec4:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003ec8:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003ecc:	dfdfd0ef          	jal	ra,80001cc8 <printk>
80003ed0:	80006537          	lui	a0,0x80006
80003ed4:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80003ed8:	df1fd0ef          	jal	ra,80001cc8 <printk>
80003edc:	07800593          	li	a1,120
80003ee0:	4bc40513          	addi	a0,s0,1212
80003ee4:	e21fd0ef          	jal	ra,80001d04 <assert_post_action>
}
80003ee8:	00812403          	lw	s0,8(sp)
80003eec:	00c12083          	lw	ra,12(sp)
80003ef0:	00048513          	mv	a0,s1
80003ef4:	00412483          	lw	s1,4(sp)
80003ef8:	01010113          	addi	sp,sp,16
80003efc:	b2cfc06f          	j	80000228 <__swap>

80003f00 <z_unpend_first_thread>:
{
80003f00:	fe010113          	addi	sp,sp,-32
80003f04:	01212823          	sw	s2,16(sp)
80003f08:	01312623          	sw	s3,12(sp)
80003f0c:	00112e23          	sw	ra,28(sp)
80003f10:	00812c23          	sw	s0,24(sp)
80003f14:	00912a23          	sw	s1,20(sp)
80003f18:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f1c:	00800913          	li	s2,8
80003f20:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f24:	800074b7          	lui	s1,0x80007
80003f28:	a5848513          	addi	a0,s1,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f2c:	00897913          	andi	s2,s2,8
80003f30:	09d000ef          	jal	ra,800047cc <z_spin_lock_valid>
80003f34:	02051e63          	bnez	a0,80003f70 <z_unpend_first_thread+0x70>
80003f38:	80006437          	lui	s0,0x80006
80003f3c:	800065b7          	lui	a1,0x80006
80003f40:	80006537          	lui	a0,0x80006
80003f44:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80003f48:	04e00693          	li	a3,78
80003f4c:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003f50:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003f54:	d75fd0ef          	jal	ra,80001cc8 <printk>
80003f58:	80006537          	lui	a0,0x80006
80003f5c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80003f60:	d69fd0ef          	jal	ra,80001cc8 <printk>
80003f64:	04e00593          	li	a1,78
80003f68:	4bc40513          	addi	a0,s0,1212
80003f6c:	d99fd0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80003f70:	a5848513          	addi	a0,s1,-1448
80003f74:	0b1000ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80003f78:	00098513          	mv	a0,s3
80003f7c:	d28ff0ef          	jal	ra,800034a4 <z_priq_dumb_best>
80003f80:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f84:	a5848513          	addi	a0,s1,-1448
80003f88:	06d000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80003f8c:	02051e63          	bnez	a0,80003fc8 <z_unpend_first_thread+0xc8>
80003f90:	800069b7          	lui	s3,0x80006
80003f94:	800065b7          	lui	a1,0x80006
80003f98:	80006537          	lui	a0,0x80006
80003f9c:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80003fa0:	06100693          	li	a3,97
80003fa4:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80003fa8:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80003fac:	d1dfd0ef          	jal	ra,80001cc8 <printk>
80003fb0:	80006537          	lui	a0,0x80006
80003fb4:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80003fb8:	d11fd0ef          	jal	ra,80001cc8 <printk>
80003fbc:	06100593          	li	a1,97
80003fc0:	4bc98513          	addi	a0,s3,1212
80003fc4:	d41fd0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003fc8:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80003fcc:	0c040663          	beqz	s0,80004098 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003fd0:	00800913          	li	s2,8
80003fd4:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003fd8:	a5848513          	addi	a0,s1,-1448
	key = (mstatus & SOC_MSTATUS_IEN);
80003fdc:	00897913          	andi	s2,s2,8
80003fe0:	7ec000ef          	jal	ra,800047cc <z_spin_lock_valid>
80003fe4:	02051e63          	bnez	a0,80004020 <z_unpend_first_thread+0x120>
80003fe8:	800069b7          	lui	s3,0x80006
80003fec:	800065b7          	lui	a1,0x80006
80003ff0:	80006537          	lui	a0,0x80006
80003ff4:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80003ff8:	04e00693          	li	a3,78
80003ffc:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004000:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004004:	cc5fd0ef          	jal	ra,80001cc8 <printk>
80004008:	80006537          	lui	a0,0x80006
8000400c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80004010:	cb9fd0ef          	jal	ra,80001cc8 <printk>
80004014:	04e00593          	li	a1,78
80004018:	4bc98513          	addi	a0,s3,1212
8000401c:	ce9fd0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80004020:	a5848513          	addi	a0,s1,-1448
80004024:	001000ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004028:	00840513          	addi	a0,s0,8
8000402c:	e1dfe0ef          	jal	ra,80002e48 <pended_on.isra.15>
80004030:	00040593          	mv	a1,s0
80004034:	af8ff0ef          	jal	ra,8000332c <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80004038:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000403c:	a5848513          	addi	a0,s1,-1448
80004040:	ffd7f793          	andi	a5,a5,-3
80004044:	00f406a3          	sb	a5,13(s0)
80004048:	7ac000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
8000404c:	02051e63          	bnez	a0,80004088 <z_unpend_first_thread+0x188>
80004050:	800064b7          	lui	s1,0x80006
80004054:	800065b7          	lui	a1,0x80006
80004058:	80006537          	lui	a0,0x80006
8000405c:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80004060:	06100693          	li	a3,97
80004064:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004068:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000406c:	c5dfd0ef          	jal	ra,80001cc8 <printk>
80004070:	80006537          	lui	a0,0x80006
80004074:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80004078:	c51fd0ef          	jal	ra,80001cc8 <printk>
8000407c:	06100593          	li	a1,97
80004080:	4bc48513          	addi	a0,s1,1212
80004084:	c81fd0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004088:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
8000408c:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80004090:	01840513          	addi	a0,s0,24
80004094:	701000ef          	jal	ra,80004f94 <z_abort_timeout>
}
80004098:	00040513          	mv	a0,s0
8000409c:	01c12083          	lw	ra,28(sp)
800040a0:	01812403          	lw	s0,24(sp)
800040a4:	01412483          	lw	s1,20(sp)
800040a8:	01012903          	lw	s2,16(sp)
800040ac:	00c12983          	lw	s3,12(sp)
800040b0:	02010113          	addi	sp,sp,32
800040b4:	00008067          	ret

800040b8 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
800040b8:	ff010113          	addi	sp,sp,-16
800040bc:	00912223          	sw	s1,4(sp)
800040c0:	01212023          	sw	s2,0(sp)
800040c4:	00112623          	sw	ra,12(sp)
800040c8:	00812423          	sw	s0,8(sp)
800040cc:	00050913          	mv	s2,a0
	int need_sched = 0;
800040d0:	00000493          	li	s1,0
	return list->head == list;
800040d4:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800040d8:	00890463          	beq	s2,s0,800040e0 <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
800040dc:	02041063          	bnez	s0,800040fc <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
800040e0:	00c12083          	lw	ra,12(sp)
800040e4:	00812403          	lw	s0,8(sp)
800040e8:	00048513          	mv	a0,s1
800040ec:	00012903          	lw	s2,0(sp)
800040f0:	00412483          	lw	s1,4(sp)
800040f4:	01010113          	addi	sp,sp,16
800040f8:	00008067          	ret
		z_unpend_thread(th);
800040fc:	00040513          	mv	a0,s0
80004100:	aa4ff0ef          	jal	ra,800033a4 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80004104:	00040513          	mv	a0,s0
80004108:	cedfe0ef          	jal	ra,80002df4 <z_is_thread_ready>
		need_sched = 1;
8000410c:	00100493          	li	s1,1
80004110:	fc0502e3          	beqz	a0,800040d4 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80004114:	00040513          	mv	a0,s0
80004118:	de8ff0ef          	jal	ra,80003700 <z_add_thread_to_ready_q>
8000411c:	fb9ff06f          	j	800040d4 <z_unpend_all+0x1c>

80004120 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80004120:	800077b7          	lui	a5,0x80007
80004124:	d4478793          	addi	a5,a5,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
80004128:	02478713          	addi	a4,a5,36
8000412c:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80004130:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80004134:	00000593          	li	a1,0
80004138:	00000513          	li	a0,0
8000413c:	d6dfe06f          	j	80002ea8 <k_sched_time_slice_set>

80004140 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80004140:	fe010113          	addi	sp,sp,-32
80004144:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80004148:	80007437          	lui	s0,0x80007
8000414c:	d4442783          	lw	a5,-700(s0) # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
{
80004150:	00112e23          	sw	ra,28(sp)
80004154:	00912a23          	sw	s1,20(sp)
80004158:	01212823          	sw	s2,16(sp)
8000415c:	01312623          	sw	s3,12(sp)
80004160:	01412423          	sw	s4,8(sp)
80004164:	01512223          	sw	s5,4(sp)
80004168:	d4440413          	addi	s0,s0,-700
	__ASSERT(!z_is_in_isr(), "");
8000416c:	02078e63          	beqz	a5,800041a8 <z_impl_k_yield+0x68>
80004170:	800064b7          	lui	s1,0x80006
80004174:	800065b7          	lui	a1,0x80006
80004178:	80006537          	lui	a0,0x80006
8000417c:	6cc58593          	addi	a1,a1,1740 # 800066cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066cd>
80004180:	37e00693          	li	a3,894
80004184:	73448613          	addi	a2,s1,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
80004188:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000418c:	b3dfd0ef          	jal	ra,80001cc8 <printk>
80004190:	80006537          	lui	a0,0x80006
80004194:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
80004198:	b31fd0ef          	jal	ra,80001cc8 <printk>
8000419c:	37e00593          	li	a1,894
800041a0:	73448513          	addi	a0,s1,1844
800041a4:	b61fd0ef          	jal	ra,80001d04 <assert_post_action>
	return thread == _idle_thread;
800041a8:	800077b7          	lui	a5,0x80007

	if (!is_idle(_current)) {
800041ac:	00842683          	lw	a3,8(s0)
800041b0:	9b07a703          	lw	a4,-1616(a5) # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
800041b4:	00078a13          	mv	s4,a5
800041b8:	12e68663          	beq	a3,a4,800042e4 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800041bc:	00800913          	li	s2,8
800041c0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800041c4:	800079b7          	lui	s3,0x80007
800041c8:	a5898513          	addi	a0,s3,-1448 # 80006a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a59>
	key = (mstatus & SOC_MSTATUS_IEN);
800041cc:	00897913          	andi	s2,s2,8
800041d0:	5fc000ef          	jal	ra,800047cc <z_spin_lock_valid>
800041d4:	02051e63          	bnez	a0,80004210 <z_impl_k_yield+0xd0>
800041d8:	800064b7          	lui	s1,0x80006
800041dc:	800065b7          	lui	a1,0x80006
800041e0:	80006537          	lui	a0,0x80006
800041e4:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
800041e8:	04e00693          	li	a3,78
800041ec:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800041f0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800041f4:	ad5fd0ef          	jal	ra,80001cc8 <printk>
800041f8:	80006537          	lui	a0,0x80006
800041fc:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80004200:	ac9fd0ef          	jal	ra,80001cc8 <printk>
80004204:	04e00593          	li	a1,78
80004208:	4bc48513          	addi	a0,s1,1212
8000420c:	af9fd0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80004210:	a5898513          	addi	a0,s3,-1448
80004214:	610000ef          	jal	ra,80004824 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80004218:	00842583          	lw	a1,8(s0)
8000421c:	02440513          	addi	a0,s0,36
80004220:	90cff0ef          	jal	ra,8000332c <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80004224:	9b0a2783          	lw	a5,-1616(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80004228:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
8000422c:	80007a37          	lui	s4,0x80007
80004230:	d68a0a13          	addi	s4,s4,-664 # 80006d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d69>
	__ASSERT_NO_MSG(!is_idle(thread));
80004234:	02f49863          	bne	s1,a5,80004264 <z_impl_k_yield+0x124>
80004238:	80006ab7          	lui	s5,0x80006
8000423c:	800065b7          	lui	a1,0x80006
80004240:	80006537          	lui	a0,0x80006
80004244:	78058593          	addi	a1,a1,1920 # 80006780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006781>
80004248:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000424c:	27600693          	li	a3,630
80004250:	734a8613          	addi	a2,s5,1844 # 80006734 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006735>
80004254:	a75fd0ef          	jal	ra,80001cc8 <printk>
80004258:	27600593          	li	a1,630
8000425c:	734a8513          	addi	a0,s5,1844
80004260:	aa5fd0ef          	jal	ra,80001d04 <assert_post_action>
	return list->head == list;
80004264:	02442783          	lw	a5,36(s0)
80004268:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000426c:	0b478a63          	beq	a5,s4,80004320 <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004270:	0a078863          	beqz	a5,80004320 <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
80004274:	00e48683          	lb	a3,14(s1)
80004278:	00e78603          	lb	a2,14(a5)
8000427c:	08c6dc63          	bge	a3,a2,80004314 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
80004280:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004284:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
80004288:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
8000428c:	00972023          	sw	s1,0(a4)
	successor->prev = node;
80004290:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80004294:	00100513          	li	a0,1
80004298:	a20ff0ef          	jal	ra,800034b8 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000429c:	a5898513          	addi	a0,s3,-1448
800042a0:	554000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
800042a4:	02051e63          	bnez	a0,800042e0 <z_impl_k_yield+0x1a0>
800042a8:	80006437          	lui	s0,0x80006
800042ac:	800065b7          	lui	a1,0x80006
800042b0:	80006537          	lui	a0,0x80006
800042b4:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800042b8:	06100693          	li	a3,97
800042bc:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800042c0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800042c4:	a05fd0ef          	jal	ra,80001cc8 <printk>
800042c8:	80006537          	lui	a0,0x80006
800042cc:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
800042d0:	9f9fd0ef          	jal	ra,80001cc8 <printk>
800042d4:	06100593          	li	a1,97
800042d8:	4bc40513          	addi	a0,s0,1212
800042dc:	a29fd0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042e0:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
800042e4:	00800513          	li	a0,8
800042e8:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
800042ec:	01812403          	lw	s0,24(sp)
800042f0:	01c12083          	lw	ra,28(sp)
800042f4:	01412483          	lw	s1,20(sp)
800042f8:	01012903          	lw	s2,16(sp)
800042fc:	00c12983          	lw	s3,12(sp)
80004300:	00812a03          	lw	s4,8(sp)
80004304:	00412a83          	lw	s5,4(sp)
80004308:	00857513          	andi	a0,a0,8
8000430c:	02010113          	addi	sp,sp,32
80004310:	f19fb06f          	j	80000228 <__swap>
	return (node == list->tail) ? NULL : node->next;
80004314:	00e78663          	beq	a5,a4,80004320 <z_impl_k_yield+0x1e0>
80004318:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000431c:	f4079ee3          	bnez	a5,80004278 <z_impl_k_yield+0x138>
	node->prev = list->tail;
80004320:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
80004324:	02842783          	lw	a5,40(s0)
	node->next = list;
80004328:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
8000432c:	0097a023          	sw	s1,0(a5)
	list->tail = node;
80004330:	02942423          	sw	s1,40(s0)
80004334:	f61ff06f          	j	80004294 <z_impl_k_yield+0x154>

80004338 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80004338:	800077b7          	lui	a5,0x80007
8000433c:	d4c7a503          	lw	a0,-692(a5) # 80006d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d4d>
80004340:	00008067          	ret

80004344 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80004344:	fe010113          	addi	sp,sp,-32
80004348:	00812c23          	sw	s0,24(sp)
8000434c:	00912a23          	sw	s1,20(sp)
80004350:	01212823          	sw	s2,16(sp)
80004354:	00112e23          	sw	ra,28(sp)
80004358:	01312623          	sw	s3,12(sp)
8000435c:	00050413          	mv	s0,a0
80004360:	00058913          	mv	s2,a1
80004364:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80004368:	02061e63          	bnez	a2,800043a4 <z_impl_k_sem_init+0x60>
8000436c:	800069b7          	lui	s3,0x80006
80004370:	800065b7          	lui	a1,0x80006
80004374:	80006537          	lui	a0,0x80006
80004378:	7a458593          	addi	a1,a1,1956 # 800067a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067a5>
8000437c:	04600693          	li	a3,70
80004380:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
80004384:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004388:	941fd0ef          	jal	ra,80001cc8 <printk>
8000438c:	80006537          	lui	a0,0x80006
80004390:	7b050513          	addi	a0,a0,1968 # 800067b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067b1>
80004394:	935fd0ef          	jal	ra,80001cc8 <printk>
80004398:	04600593          	li	a1,70
8000439c:	79498513          	addi	a0,s3,1940
800043a0:	965fd0ef          	jal	ra,80001d04 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
800043a4:	0324fe63          	bgeu	s1,s2,800043e0 <z_impl_k_sem_init+0x9c>
800043a8:	800069b7          	lui	s3,0x80006
800043ac:	800065b7          	lui	a1,0x80006
800043b0:	80006537          	lui	a0,0x80006
800043b4:	7c858593          	addi	a1,a1,1992 # 800067c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067c9>
800043b8:	04700693          	li	a3,71
800043bc:	79498613          	addi	a2,s3,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
800043c0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800043c4:	905fd0ef          	jal	ra,80001cc8 <printk>
800043c8:	80006537          	lui	a0,0x80006
800043cc:	7e050513          	addi	a0,a0,2016 # 800067e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067e1>
800043d0:	8f9fd0ef          	jal	ra,80001cc8 <printk>
800043d4:	04700593          	li	a1,71
800043d8:	79498513          	addi	a0,s3,1940
800043dc:	929fd0ef          	jal	ra,80001d04 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
800043e0:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
800043e4:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
800043e8:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
800043ec:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
800043f0:	01c12083          	lw	ra,28(sp)
800043f4:	01812403          	lw	s0,24(sp)
800043f8:	01412483          	lw	s1,20(sp)
800043fc:	01012903          	lw	s2,16(sp)
80004400:	00c12983          	lw	s3,12(sp)
80004404:	02010113          	addi	sp,sp,32
80004408:	00008067          	ret

8000440c <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
8000440c:	fe010113          	addi	sp,sp,-32
80004410:	00912a23          	sw	s1,20(sp)
80004414:	01312623          	sw	s3,12(sp)
80004418:	00112e23          	sw	ra,28(sp)
8000441c:	00812c23          	sw	s0,24(sp)
80004420:	01212823          	sw	s2,16(sp)
80004424:	00050993          	mv	s3,a0
80004428:	00800493          	li	s1,8
8000442c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004430:	80007437          	lui	s0,0x80007
80004434:	a6440513          	addi	a0,s0,-1436 # 80006a64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a65>
	key = (mstatus & SOC_MSTATUS_IEN);
80004438:	0084f493          	andi	s1,s1,8
8000443c:	390000ef          	jal	ra,800047cc <z_spin_lock_valid>
80004440:	02051e63          	bnez	a0,8000447c <z_impl_k_sem_give+0x70>
80004444:	80006937          	lui	s2,0x80006
80004448:	800065b7          	lui	a1,0x80006
8000444c:	80006537          	lui	a0,0x80006
80004450:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80004454:	04e00693          	li	a3,78
80004458:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000445c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004460:	869fd0ef          	jal	ra,80001cc8 <printk>
80004464:	80006537          	lui	a0,0x80006
80004468:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
8000446c:	85dfd0ef          	jal	ra,80001cc8 <printk>
80004470:	04e00593          	li	a1,78
80004474:	4bc90513          	addi	a0,s2,1212
80004478:	88dfd0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
8000447c:	a6440513          	addi	a0,s0,-1436
80004480:	3a4000ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80004484:	00098513          	mv	a0,s3
80004488:	a79ff0ef          	jal	ra,80003f00 <z_unpend_first_thread>
8000448c:	00050913          	mv	s2,a0
	if (thread != NULL) {
80004490:	04050263          	beqz	a0,800044d4 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004494:	00d54783          	lbu	a5,13(a0)
80004498:	01f7f793          	andi	a5,a5,31
8000449c:	00079863          	bnez	a5,800044ac <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
800044a0:	01852783          	lw	a5,24(a0)
800044a4:	00079463          	bnez	a5,800044ac <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
800044a8:	a58ff0ef          	jal	ra,80003700 <z_add_thread_to_ready_q>
800044ac:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
800044b0:	a6440513          	addi	a0,s0,-1436
}
800044b4:	01812403          	lw	s0,24(sp)
800044b8:	01c12083          	lw	ra,28(sp)
800044bc:	01012903          	lw	s2,16(sp)
800044c0:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
800044c4:	00048593          	mv	a1,s1
}
800044c8:	01412483          	lw	s1,20(sp)
800044cc:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
800044d0:	be5fe06f          	j	800030b4 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
800044d4:	0089a703          	lw	a4,8(s3)
800044d8:	00c9a783          	lw	a5,12(s3)
800044dc:	40e787b3          	sub	a5,a5,a4
800044e0:	00f037b3          	snez	a5,a5
800044e4:	00e787b3          	add	a5,a5,a4
800044e8:	00f9a423          	sw	a5,8(s3)
800044ec:	fc5ff06f          	j	800044b0 <z_impl_k_sem_give+0xa4>

800044f0 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800044f0:	800077b7          	lui	a5,0x80007
800044f4:	d447a783          	lw	a5,-700(a5) # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
{
800044f8:	fe010113          	addi	sp,sp,-32
800044fc:	01212823          	sw	s2,16(sp)
80004500:	01312623          	sw	s3,12(sp)
80004504:	00112e23          	sw	ra,28(sp)
80004508:	00812c23          	sw	s0,24(sp)
8000450c:	00912a23          	sw	s1,20(sp)
80004510:	01412423          	sw	s4,8(sp)
80004514:	00050913          	mv	s2,a0
80004518:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000451c:	04078063          	beqz	a5,8000455c <z_impl_k_sem_take+0x6c>
80004520:	02058e63          	beqz	a1,8000455c <z_impl_k_sem_take+0x6c>
80004524:	80006437          	lui	s0,0x80006
80004528:	800075b7          	lui	a1,0x80007
8000452c:	80006537          	lui	a0,0x80006
80004530:	80858593          	addi	a1,a1,-2040 # 80006808 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006809>
80004534:	08c00693          	li	a3,140
80004538:	79440613          	addi	a2,s0,1940 # 80006794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006795>
8000453c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004540:	f88fd0ef          	jal	ra,80001cc8 <printk>
80004544:	80006537          	lui	a0,0x80006
80004548:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
8000454c:	f7cfd0ef          	jal	ra,80001cc8 <printk>
80004550:	08c00593          	li	a1,140
80004554:	79440513          	addi	a0,s0,1940
80004558:	facfd0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000455c:	00800413          	li	s0,8
80004560:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004564:	800074b7          	lui	s1,0x80007
80004568:	a6448513          	addi	a0,s1,-1436 # 80006a64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a65>
	key = (mstatus & SOC_MSTATUS_IEN);
8000456c:	00847413          	andi	s0,s0,8
80004570:	25c000ef          	jal	ra,800047cc <z_spin_lock_valid>
80004574:	02051e63          	bnez	a0,800045b0 <z_impl_k_sem_take+0xc0>
80004578:	80006a37          	lui	s4,0x80006
8000457c:	800065b7          	lui	a1,0x80006
80004580:	80006537          	lui	a0,0x80006
80004584:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80004588:	04e00693          	li	a3,78
8000458c:	4bca0613          	addi	a2,s4,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004590:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004594:	f34fd0ef          	jal	ra,80001cc8 <printk>
80004598:	80006537          	lui	a0,0x80006
8000459c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
800045a0:	f28fd0ef          	jal	ra,80001cc8 <printk>
800045a4:	04e00593          	li	a1,78
800045a8:	4bca0513          	addi	a0,s4,1212
800045ac:	f58fd0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
800045b0:	a6448513          	addi	a0,s1,-1436
800045b4:	270000ef          	jal	ra,80004824 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
800045b8:	00892783          	lw	a5,8(s2)
800045bc:	06078c63          	beqz	a5,80004634 <z_impl_k_sem_take+0x144>
		sem->count--;
800045c0:	fff78793          	addi	a5,a5,-1
800045c4:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800045c8:	a6448513          	addi	a0,s1,-1436
800045cc:	228000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
800045d0:	02051e63          	bnez	a0,8000460c <z_impl_k_sem_take+0x11c>
800045d4:	800064b7          	lui	s1,0x80006
800045d8:	800065b7          	lui	a1,0x80006
800045dc:	80006537          	lui	a0,0x80006
800045e0:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800045e4:	06100693          	li	a3,97
800045e8:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800045ec:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800045f0:	ed8fd0ef          	jal	ra,80001cc8 <printk>
800045f4:	80006537          	lui	a0,0x80006
800045f8:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
800045fc:	eccfd0ef          	jal	ra,80001cc8 <printk>
80004600:	06100593          	li	a1,97
80004604:	4bc48513          	addi	a0,s1,1212
80004608:	efcfd0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000460c:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80004610:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80004614:	01c12083          	lw	ra,28(sp)
80004618:	01812403          	lw	s0,24(sp)
8000461c:	01412483          	lw	s1,20(sp)
80004620:	01012903          	lw	s2,16(sp)
80004624:	00c12983          	lw	s3,12(sp)
80004628:	00812a03          	lw	s4,8(sp)
8000462c:	02010113          	addi	sp,sp,32
80004630:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80004634:	04099a63          	bnez	s3,80004688 <z_impl_k_sem_take+0x198>
80004638:	a6448513          	addi	a0,s1,-1436
8000463c:	1b8000ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80004640:	02051e63          	bnez	a0,8000467c <z_impl_k_sem_take+0x18c>
80004644:	800064b7          	lui	s1,0x80006
80004648:	800065b7          	lui	a1,0x80006
8000464c:	80006537          	lui	a0,0x80006
80004650:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80004654:	06100693          	li	a3,97
80004658:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000465c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004660:	e68fd0ef          	jal	ra,80001cc8 <printk>
80004664:	80006537          	lui	a0,0x80006
80004668:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
8000466c:	e5cfd0ef          	jal	ra,80001cc8 <printk>
80004670:	06100593          	li	a1,97
80004674:	4bc48513          	addi	a0,s1,1212
80004678:	e8cfd0ef          	jal	ra,80001d04 <assert_post_action>
8000467c:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80004680:	ff000513          	li	a0,-16
80004684:	f91ff06f          	j	80004614 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004688:	00040593          	mv	a1,s0
}
8000468c:	01812403          	lw	s0,24(sp)
80004690:	01c12083          	lw	ra,28(sp)
80004694:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004698:	00098693          	mv	a3,s3
8000469c:	00090613          	mv	a2,s2
}
800046a0:	00c12983          	lw	s3,12(sp)
800046a4:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800046a8:	a6448513          	addi	a0,s1,-1436
}
800046ac:	01412483          	lw	s1,20(sp)
800046b0:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800046b4:	fc4ff06f          	j	80003e78 <z_pend_curr>

800046b8 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800046b8:	00d54783          	lbu	a5,13(a0)
800046bc:	01f7f793          	andi	a5,a5,31
800046c0:	00079863          	bnez	a5,800046d0 <z_is_thread_ready+0x18>
800046c4:	01852503          	lw	a0,24(a0)
800046c8:	00153513          	seqz	a0,a0
800046cc:	00008067          	ret
800046d0:	00000513          	li	a0,0
}
800046d4:	00008067          	ret

800046d8 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800046d8:	800077b7          	lui	a5,0x80007
800046dc:	d447a503          	lw	a0,-700(a5) # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
}
800046e0:	00a03533          	snez	a0,a0
800046e4:	00008067          	ret

800046e8 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800046e8:	800077b7          	lui	a5,0x80007
800046ec:	d4c7a783          	lw	a5,-692(a5) # 80006d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d4d>
800046f0:	00c7c503          	lbu	a0,12(a5)
}
800046f4:	00157513          	andi	a0,a0,1
800046f8:	00008067          	ret

800046fc <z_impl_k_thread_name_set>:
#else
void z_impl_k_thread_name_set(k_tid_t thread_id, const char *value)
{
	ARG_UNUSED(thread_id);
	ARG_UNUSED(value);
}
800046fc:	00008067          	ret

80004700 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004700:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004704:	02012303          	lw	t1,32(sp)
{
80004708:	00812c23          	sw	s0,24(sp)
8000470c:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004710:	00612023          	sw	t1,0(sp)
{
80004714:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004718:	e84fc0ef          	jal	ra,80000d9c <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
8000471c:	800077b7          	lui	a5,0x80007
80004720:	d4c7a783          	lw	a5,-692(a5) # 80006d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d4d>
	sys_trace_thread_create(new_thread);
}
80004724:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004728:	0687a783          	lw	a5,104(a5)
8000472c:	06f42423          	sw	a5,104(s0)
}
80004730:	01812403          	lw	s0,24(sp)
80004734:	02010113          	addi	sp,sp,32
80004738:	00008067          	ret

8000473c <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
8000473c:	06052783          	lw	a5,96(a0)
{
80004740:	ff010113          	addi	sp,sp,-16
80004744:	00812423          	sw	s0,8(sp)
80004748:	00112623          	sw	ra,12(sp)
8000474c:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004750:	00078463          	beqz	a5,80004758 <z_thread_single_abort+0x1c>
		thread->fn_abort();
80004754:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80004758:	00040513          	mv	a0,s0
8000475c:	f5dff0ef          	jal	ra,800046b8 <z_is_thread_ready>
80004760:	02050463          	beqz	a0,80004788 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80004764:	00040513          	mv	a0,s0
80004768:	ca0ff0ef          	jal	ra,80003c08 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
8000476c:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004770:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004774:	0087e793          	ori	a5,a5,8
80004778:	00f406a3          	sb	a5,13(s0)
}
8000477c:	00812403          	lw	s0,8(sp)
80004780:	01010113          	addi	sp,sp,16
80004784:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004788:	00d44783          	lbu	a5,13(s0)
8000478c:	0027f793          	andi	a5,a5,2
80004790:	00078663          	beqz	a5,8000479c <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80004794:	00040513          	mv	a0,s0
80004798:	821fe0ef          	jal	ra,80002fb8 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
8000479c:	01842783          	lw	a5,24(s0)
800047a0:	fc0786e3          	beqz	a5,8000476c <z_thread_single_abort+0x30>
800047a4:	01840513          	addi	a0,s0,24
800047a8:	7ec000ef          	jal	ra,80004f94 <z_abort_timeout>
800047ac:	fc1ff06f          	j	8000476c <z_thread_single_abort+0x30>

800047b0 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
800047b0:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
800047b4:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
800047b8:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
800047bc:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
800047c0:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
800047c4:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
800047c8:	00008067          	ret

800047cc <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
800047cc:	00052503          	lw	a0,0(a0)
800047d0:	00050e63          	beqz	a0,800047ec <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800047d4:	800077b7          	lui	a5,0x80007
800047d8:	d587c783          	lbu	a5,-680(a5) # 80006d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d59>
800047dc:	00357513          	andi	a0,a0,3
800047e0:	40f50533          	sub	a0,a0,a5
800047e4:	00a03533          	snez	a0,a0
800047e8:	00008067          	ret
			return false;
		}
	}
	return true;
800047ec:	00100513          	li	a0,1
}
800047f0:	00008067          	ret

800047f4 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800047f4:	800077b7          	lui	a5,0x80007
800047f8:	d4478793          	addi	a5,a5,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
800047fc:	0147c703          	lbu	a4,20(a5)
80004800:	0087a783          	lw	a5,8(a5)
80004804:	00e7e7b3          	or	a5,a5,a4
80004808:	00052703          	lw	a4,0(a0)
8000480c:	00f71863          	bne	a4,a5,8000481c <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004810:	00052023          	sw	zero,0(a0)
	return true;
80004814:	00100513          	li	a0,1
80004818:	00008067          	ret
		return false;
8000481c:	00000513          	li	a0,0
}
80004820:	00008067          	ret

80004824 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004824:	800077b7          	lui	a5,0x80007
80004828:	d4478793          	addi	a5,a5,-700 # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
8000482c:	0147c703          	lbu	a4,20(a5)
80004830:	0087a783          	lw	a5,8(a5)
80004834:	00e7e7b3          	or	a5,a5,a4
80004838:	00f52023          	sw	a5,0(a0)
}
8000483c:	00008067          	ret

80004840 <z_impl_k_thread_start>:
{
80004840:	fe010113          	addi	sp,sp,-32
80004844:	00812c23          	sw	s0,24(sp)
80004848:	01212823          	sw	s2,16(sp)
8000484c:	00112e23          	sw	ra,28(sp)
80004850:	00912a23          	sw	s1,20(sp)
80004854:	01312623          	sw	s3,12(sp)
80004858:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000485c:	00800413          	li	s0,8
80004860:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004864:	800074b7          	lui	s1,0x80007
80004868:	a6848513          	addi	a0,s1,-1432 # 80006a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a69>
	key = (mstatus & SOC_MSTATUS_IEN);
8000486c:	00847413          	andi	s0,s0,8
80004870:	f5dff0ef          	jal	ra,800047cc <z_spin_lock_valid>
80004874:	02051e63          	bnez	a0,800048b0 <z_impl_k_thread_start+0x70>
80004878:	800069b7          	lui	s3,0x80006
8000487c:	800065b7          	lui	a1,0x80006
80004880:	80006537          	lui	a0,0x80006
80004884:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80004888:	04e00693          	li	a3,78
8000488c:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004890:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004894:	c34fd0ef          	jal	ra,80001cc8 <printk>
80004898:	80006537          	lui	a0,0x80006
8000489c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
800048a0:	c28fd0ef          	jal	ra,80001cc8 <printk>
800048a4:	04e00593          	li	a1,78
800048a8:	4bc98513          	addi	a0,s3,1212
800048ac:	c58fd0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
800048b0:	a6848513          	addi	a0,s1,-1432
800048b4:	f71ff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
800048b8:	00d94783          	lbu	a5,13(s2)
800048bc:	0047f713          	andi	a4,a5,4
800048c0:	06071463          	bnez	a4,80004928 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800048c4:	a6848513          	addi	a0,s1,-1432
800048c8:	f2dff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
800048cc:	02051e63          	bnez	a0,80004908 <z_impl_k_thread_start+0xc8>
800048d0:	800064b7          	lui	s1,0x80006
800048d4:	800065b7          	lui	a1,0x80006
800048d8:	80006537          	lui	a0,0x80006
800048dc:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800048e0:	06100693          	li	a3,97
800048e4:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800048e8:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800048ec:	bdcfd0ef          	jal	ra,80001cc8 <printk>
800048f0:	80006537          	lui	a0,0x80006
800048f4:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
800048f8:	bd0fd0ef          	jal	ra,80001cc8 <printk>
800048fc:	06100593          	li	a1,97
80004900:	4bc48513          	addi	a0,s1,1212
80004904:	c00fd0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004908:	30042473          	csrrs	s0,mstatus,s0
}
8000490c:	01c12083          	lw	ra,28(sp)
80004910:	01812403          	lw	s0,24(sp)
80004914:	01412483          	lw	s1,20(sp)
80004918:	01012903          	lw	s2,16(sp)
8000491c:	00c12983          	lw	s3,12(sp)
80004920:	02010113          	addi	sp,sp,32
80004924:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004928:	ffb7f793          	andi	a5,a5,-5
8000492c:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004930:	00090513          	mv	a0,s2
80004934:	d85ff0ef          	jal	ra,800046b8 <z_is_thread_ready>
80004938:	00050663          	beqz	a0,80004944 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
8000493c:	00090513          	mv	a0,s2
80004940:	dc1fe0ef          	jal	ra,80003700 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80004944:	00040593          	mv	a1,s0
}
80004948:	01812403          	lw	s0,24(sp)
8000494c:	01c12083          	lw	ra,28(sp)
80004950:	01012903          	lw	s2,16(sp)
80004954:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004958:	a6848513          	addi	a0,s1,-1432
}
8000495c:	01412483          	lw	s1,20(sp)
80004960:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004964:	f50fe06f          	j	800030b4 <z_reschedule>

80004968 <schedule_new_thread>:
	if (delay == 0) {
80004968:	00059463          	bnez	a1,80004970 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
8000496c:	ed5ff06f          	j	80004840 <z_impl_k_thread_start>
80004970:	00958593          	addi	a1,a1,9
80004974:	00a00613          	li	a2,10
80004978:	02c5c633          	div	a2,a1,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
8000497c:	800045b7          	lui	a1,0x80004
80004980:	89058593          	addi	a1,a1,-1904 # 80003890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003891>
80004984:	01850513          	addi	a0,a0,24
80004988:	00160613          	addi	a2,a2,1
8000498c:	3dc0006f          	j	80004d68 <z_add_timeout>

80004990 <z_impl_k_thread_create>:
{
80004990:	fc010113          	addi	sp,sp,-64
80004994:	03512223          	sw	s5,36(sp)
80004998:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
8000499c:	800076b7          	lui	a3,0x80007
800049a0:	d446a683          	lw	a3,-700(a3) # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
{
800049a4:	02812c23          	sw	s0,56(sp)
800049a8:	02912a23          	sw	s1,52(sp)
800049ac:	03312623          	sw	s3,44(sp)
800049b0:	03412423          	sw	s4,40(sp)
800049b4:	02112e23          	sw	ra,60(sp)
800049b8:	03212823          	sw	s2,48(sp)
800049bc:	00050413          	mv	s0,a0
800049c0:	00058993          	mv	s3,a1
800049c4:	00060a13          	mv	s4,a2
800049c8:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800049cc:	04068e63          	beqz	a3,80004a28 <z_impl_k_thread_create+0x98>
800049d0:	80007937          	lui	s2,0x80007
800049d4:	800065b7          	lui	a1,0x80006
800049d8:	80006537          	lui	a0,0x80006
800049dc:	1b200693          	li	a3,434
800049e0:	83c90613          	addi	a2,s2,-1988 # 8000683c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000683d>
800049e4:	6cc58593          	addi	a1,a1,1740 # 800066cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066cd>
800049e8:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800049ec:	01112e23          	sw	a7,28(sp)
800049f0:	01012c23          	sw	a6,24(sp)
800049f4:	00f12a23          	sw	a5,20(sp)
800049f8:	00e12823          	sw	a4,16(sp)
800049fc:	accfd0ef          	jal	ra,80001cc8 <printk>
80004a00:	80007537          	lui	a0,0x80007
80004a04:	85050513          	addi	a0,a0,-1968 # 80006850 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006851>
80004a08:	ac0fd0ef          	jal	ra,80001cc8 <printk>
80004a0c:	1b200593          	li	a1,434
80004a10:	83c90513          	addi	a0,s2,-1988
80004a14:	af0fd0ef          	jal	ra,80001d04 <assert_post_action>
80004a18:	01c12883          	lw	a7,28(sp)
80004a1c:	01812803          	lw	a6,24(sp)
80004a20:	01412783          	lw	a5,20(sp)
80004a24:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004a28:	04012683          	lw	a3,64(sp)
80004a2c:	00012223          	sw	zero,4(sp)
80004a30:	000a0613          	mv	a2,s4
80004a34:	00d12023          	sw	a3,0(sp)
80004a38:	00098593          	mv	a1,s3
80004a3c:	000a8693          	mv	a3,s5
80004a40:	00040513          	mv	a0,s0
80004a44:	cbdff0ef          	jal	ra,80004700 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004a48:	fff00793          	li	a5,-1
80004a4c:	00f48863          	beq	s1,a5,80004a5c <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80004a50:	00048593          	mv	a1,s1
80004a54:	00040513          	mv	a0,s0
80004a58:	f11ff0ef          	jal	ra,80004968 <schedule_new_thread>
}
80004a5c:	00040513          	mv	a0,s0
80004a60:	03c12083          	lw	ra,60(sp)
80004a64:	03812403          	lw	s0,56(sp)
80004a68:	03412483          	lw	s1,52(sp)
80004a6c:	03012903          	lw	s2,48(sp)
80004a70:	02c12983          	lw	s3,44(sp)
80004a74:	02812a03          	lw	s4,40(sp)
80004a78:	02412a83          	lw	s5,36(sp)
80004a7c:	04010113          	addi	sp,sp,64
80004a80:	00008067          	ret

80004a84 <z_init_static_threads>:
{
80004a84:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004a88:	800077b7          	lui	a5,0x80007
{
80004a8c:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004a90:	80007937          	lui	s2,0x80007
{
80004a94:	00812c23          	sw	s0,24(sp)
80004a98:	00912a23          	sw	s1,20(sp)
80004a9c:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004aa0:	9e478413          	addi	s0,a5,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
80004aa4:	9e478493          	addi	s1,a5,-1564
80004aa8:	9e490913          	addi	s2,s2,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
80004aac:	03246663          	bltu	s0,s2,80004ad8 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004ab0:	00048413          	mv	s0,s1
	k_sched_lock();
80004ab4:	f00fe0ef          	jal	ra,800031b4 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004ab8:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004abc:	07246063          	bltu	s0,s2,80004b1c <z_init_static_threads+0x98>
}
80004ac0:	01812403          	lw	s0,24(sp)
80004ac4:	01c12083          	lw	ra,28(sp)
80004ac8:	01412483          	lw	s1,20(sp)
80004acc:	01012903          	lw	s2,16(sp)
80004ad0:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004ad4:	aadfe06f          	j	80003580 <k_sched_unlock>
		z_setup_new_thread(
80004ad8:	02c42783          	lw	a5,44(s0)
80004adc:	00f12223          	sw	a5,4(sp)
80004ae0:	02042783          	lw	a5,32(s0)
80004ae4:	00f12023          	sw	a5,0(sp)
80004ae8:	01442783          	lw	a5,20(s0)
80004aec:	01c42883          	lw	a7,28(s0)
80004af0:	01842803          	lw	a6,24(s0)
80004af4:	01042703          	lw	a4,16(s0)
80004af8:	00c42683          	lw	a3,12(s0)
80004afc:	00842603          	lw	a2,8(s0)
80004b00:	00442583          	lw	a1,4(s0)
80004b04:	00042503          	lw	a0,0(s0)
80004b08:	bf9ff0ef          	jal	ra,80004700 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004b0c:	00042783          	lw	a5,0(s0)
80004b10:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004b14:	03040413          	addi	s0,s0,48
80004b18:	f95ff06f          	j	80004aac <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004b1c:	02442583          	lw	a1,36(s0)
80004b20:	00958663          	beq	a1,s1,80004b2c <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80004b24:	00042503          	lw	a0,0(s0)
80004b28:	e41ff0ef          	jal	ra,80004968 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004b2c:	03040413          	addi	s0,s0,48
80004b30:	f8dff06f          	j	80004abc <z_init_static_threads+0x38>

80004b34 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004b34:	fe010113          	addi	sp,sp,-32
80004b38:	00812c23          	sw	s0,24(sp)
80004b3c:	00912a23          	sw	s1,20(sp)
80004b40:	00112e23          	sw	ra,28(sp)
80004b44:	01212823          	sw	s2,16(sp)
80004b48:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004b4c:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b50:	00800413          	li	s0,8
80004b54:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b58:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004b5c:	00847413          	andi	s0,s0,8
80004b60:	c6dff0ef          	jal	ra,800047cc <z_spin_lock_valid>
80004b64:	02051e63          	bnez	a0,80004ba0 <z_impl_k_thread_abort+0x6c>
80004b68:	80006937          	lui	s2,0x80006
80004b6c:	800065b7          	lui	a1,0x80006
80004b70:	80006537          	lui	a0,0x80006
80004b74:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80004b78:	04e00693          	li	a3,78
80004b7c:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004b80:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004b84:	944fd0ef          	jal	ra,80001cc8 <printk>
80004b88:	80006537          	lui	a0,0x80006
80004b8c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80004b90:	938fd0ef          	jal	ra,80001cc8 <printk>
80004b94:	04e00593          	li	a1,78
80004b98:	4bc90513          	addi	a0,s2,1212
80004b9c:	968fd0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ba0:	00c10513          	addi	a0,sp,12
80004ba4:	c81ff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004ba8:	00c4c783          	lbu	a5,12(s1)
80004bac:	0017f793          	andi	a5,a5,1
80004bb0:	02078e63          	beqz	a5,80004bec <z_impl_k_thread_abort+0xb8>
80004bb4:	80007937          	lui	s2,0x80007
80004bb8:	800075b7          	lui	a1,0x80007
80004bbc:	80006537          	lui	a0,0x80006
80004bc0:	89058593          	addi	a1,a1,-1904 # 80006890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006891>
80004bc4:	02900693          	li	a3,41
80004bc8:	87890613          	addi	a2,s2,-1928 # 80006878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006879>
80004bcc:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004bd0:	8f8fd0ef          	jal	ra,80001cc8 <printk>
80004bd4:	80007537          	lui	a0,0x80007
80004bd8:	8c450513          	addi	a0,a0,-1852 # 800068c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c5>
80004bdc:	8ecfd0ef          	jal	ra,80001cc8 <printk>
80004be0:	02900593          	li	a1,41
80004be4:	87890513          	addi	a0,s2,-1928
80004be8:	91cfd0ef          	jal	ra,80001d04 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004bec:	00048513          	mv	a0,s1
80004bf0:	b4dff0ef          	jal	ra,8000473c <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004bf4:	00040593          	mv	a1,s0
80004bf8:	00c10513          	addi	a0,sp,12
80004bfc:	cb8fe0ef          	jal	ra,800030b4 <z_reschedule>
}
80004c00:	01c12083          	lw	ra,28(sp)
80004c04:	01812403          	lw	s0,24(sp)
80004c08:	01412483          	lw	s1,20(sp)
80004c0c:	01012903          	lw	s2,16(sp)
80004c10:	02010113          	addi	sp,sp,32
80004c14:	00008067          	ret

80004c18 <k_work_q_start>:

extern void z_work_q_main(void *work_q_ptr, void *p2, void *p3);

void k_work_q_start(struct k_work_q *work_q, k_thread_stack_t *stack,
		    size_t stack_size, int prio)
{
80004c18:	fd010113          	addi	sp,sp,-48
80004c1c:	02112623          	sw	ra,44(sp)
80004c20:	02812423          	sw	s0,40(sp)
80004c24:	00a12e23          	sw	a0,28(sp)
80004c28:	00b12c23          	sw	a1,24(sp)
80004c2c:	00c12a23          	sw	a2,20(sp)
80004c30:	00d12823          	sw	a3,16(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80004c34:	ffdfd0ef          	jal	ra,80002c30 <z_impl_k_queue_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80004c38:	01012683          	lw	a3,16(sp)
	k_queue_init(&work_q->queue);
	(void)k_thread_create(&work_q->thread, stack, stack_size, z_work_q_main,
80004c3c:	01c12703          	lw	a4,28(sp)
80004c40:	01812583          	lw	a1,24(sp)
80004c44:	01412603          	lw	a2,20(sp)
80004c48:	01470413          	addi	s0,a4,20
80004c4c:	00068893          	mv	a7,a3
80004c50:	800016b7          	lui	a3,0x80001
80004c54:	00012223          	sw	zero,4(sp)
80004c58:	00012023          	sw	zero,0(sp)
80004c5c:	00040513          	mv	a0,s0
80004c60:	00000813          	li	a6,0
80004c64:	00000793          	li	a5,0
80004c68:	64468693          	addi	a3,a3,1604 # 80001644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001645>
80004c6c:	d25ff0ef          	jal	ra,80004990 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_NAME_SET, k_thread_name_set, k_tid_t, thread_id, const char *, value)
80004c70:	00040513          	mv	a0,s0
			work_q, NULL, NULL, prio, 0, 0);

	k_thread_name_set(&work_q->thread, WORKQUEUE_THREAD_NAME);
}
80004c74:	02812403          	lw	s0,40(sp)
80004c78:	02c12083          	lw	ra,44(sp)
80004c7c:	800075b7          	lui	a1,0x80007
80004c80:	8e058593          	addi	a1,a1,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
80004c84:	03010113          	addi	sp,sp,48
80004c88:	a75ff06f          	j	800046fc <z_impl_k_thread_name_set>

80004c8c <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004c8c:	800077b7          	lui	a5,0x80007
80004c90:	a6c7a783          	lw	a5,-1428(a5) # 80006a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a6d>
80004c94:	00079463          	bnez	a5,80004c9c <elapsed+0x10>
80004c98:	cbcfd06f          	j	80002154 <z_clock_elapsed>
}
80004c9c:	00000513          	li	a0,0
80004ca0:	00008067          	ret

80004ca4 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004ca4:	00052783          	lw	a5,0(a0)
80004ca8:	02050263          	beqz	a0,80004ccc <remove_timeout+0x28>
80004cac:	80007737          	lui	a4,0x80007
	return (node == list->tail) ? NULL : node->next;
80004cb0:	9a872703          	lw	a4,-1624(a4) # 800069a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a9>
80004cb4:	00e50c63          	beq	a0,a4,80004ccc <remove_timeout+0x28>
	if (next(t) != NULL) {
80004cb8:	00078a63          	beqz	a5,80004ccc <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80004cbc:	0087a703          	lw	a4,8(a5)
80004cc0:	00852683          	lw	a3,8(a0)
80004cc4:	00d70733          	add	a4,a4,a3
80004cc8:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80004ccc:	00452703          	lw	a4,4(a0)
80004cd0:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004cd4:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80004cd8:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004cdc:	00052223          	sw	zero,4(a0)
}
80004ce0:	00008067          	ret

80004ce4 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004ce4:	800077b7          	lui	a5,0x80007
80004ce8:	a7c7c783          	lbu	a5,-1412(a5) # 80006a7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a7d>
{
80004cec:	ff010113          	addi	sp,sp,-16
80004cf0:	00112623          	sw	ra,12(sp)
80004cf4:	00812423          	sw	s0,8(sp)
80004cf8:	00912223          	sw	s1,4(sp)
80004cfc:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004d00:	00079663          	bnez	a5,80004d0c <next_timeout+0x28>
80004d04:	80000537          	lui	a0,0x80000
80004d08:	fff54513          	not	a0,a0
	return list->head == list;
80004d0c:	800077b7          	lui	a5,0x80007
80004d10:	9a478793          	addi	a5,a5,-1628 # 800069a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a5>
80004d14:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004d18:	02f40463          	beq	s0,a5,80004d40 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004d1c:	02040263          	beqz	s0,80004d40 <next_timeout+0x5c>
80004d20:	00842483          	lw	s1,8(s0)
80004d24:	f69ff0ef          	jal	ra,80004c8c <elapsed>
80004d28:	40a484b3          	sub	s1,s1,a0
80004d2c:	00000513          	li	a0,0
80004d30:	0004c863          	bltz	s1,80004d40 <next_timeout+0x5c>
80004d34:	00842403          	lw	s0,8(s0)
80004d38:	f55ff0ef          	jal	ra,80004c8c <elapsed>
80004d3c:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004d40:	800077b7          	lui	a5,0x80007
80004d44:	d547a783          	lw	a5,-684(a5) # 80006d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d55>
80004d48:	00078663          	beqz	a5,80004d54 <next_timeout+0x70>
80004d4c:	00a7d463          	bge	a5,a0,80004d54 <next_timeout+0x70>
80004d50:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004d54:	00c12083          	lw	ra,12(sp)
80004d58:	00812403          	lw	s0,8(sp)
80004d5c:	00412483          	lw	s1,4(sp)
80004d60:	01010113          	addi	sp,sp,16
80004d64:	00008067          	ret

80004d68 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004d68:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80004d6c:	fd010113          	addi	sp,sp,-48
80004d70:	02812423          	sw	s0,40(sp)
80004d74:	02912223          	sw	s1,36(sp)
80004d78:	01312e23          	sw	s3,28(sp)
80004d7c:	02112623          	sw	ra,44(sp)
80004d80:	03212023          	sw	s2,32(sp)
80004d84:	01412c23          	sw	s4,24(sp)
80004d88:	01512a23          	sw	s5,20(sp)
80004d8c:	01612823          	sw	s6,16(sp)
80004d90:	01712623          	sw	s7,12(sp)
80004d94:	01812423          	sw	s8,8(sp)
80004d98:	00050413          	mv	s0,a0
80004d9c:	00058993          	mv	s3,a1
80004da0:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004da4:	02078e63          	beqz	a5,80004de0 <z_add_timeout+0x78>
80004da8:	80007937          	lui	s2,0x80007
80004dac:	800075b7          	lui	a1,0x80007
80004db0:	80006537          	lui	a0,0x80006
80004db4:	90058593          	addi	a1,a1,-1792 # 80006900 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006901>
80004db8:	04d00693          	li	a3,77
80004dbc:	8ec90613          	addi	a2,s2,-1812 # 800068ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068ed>
80004dc0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004dc4:	f05fc0ef          	jal	ra,80001cc8 <printk>
80004dc8:	80006537          	lui	a0,0x80006
80004dcc:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
80004dd0:	ef9fc0ef          	jal	ra,80001cc8 <printk>
80004dd4:	04d00593          	li	a1,77
80004dd8:	8ec90513          	addi	a0,s2,-1812
80004ddc:	f29fc0ef          	jal	ra,80001d04 <assert_post_action>
	to->fn = fn;
80004de0:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004de4:	00904463          	bgtz	s1,80004dec <z_add_timeout+0x84>
80004de8:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004dec:	00800993          	li	s3,8
80004df0:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004df4:	80007a37          	lui	s4,0x80007
80004df8:	a70a0513          	addi	a0,s4,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
	key = (mstatus & SOC_MSTATUS_IEN);
80004dfc:	0089f993          	andi	s3,s3,8
80004e00:	9cdff0ef          	jal	ra,800047cc <z_spin_lock_valid>
80004e04:	02051e63          	bnez	a0,80004e40 <z_add_timeout+0xd8>
80004e08:	80006937          	lui	s2,0x80006
80004e0c:	800065b7          	lui	a1,0x80006
80004e10:	80006537          	lui	a0,0x80006
80004e14:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80004e18:	04e00693          	li	a3,78
80004e1c:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004e20:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004e24:	ea5fc0ef          	jal	ra,80001cc8 <printk>
80004e28:	80006537          	lui	a0,0x80006
80004e2c:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80004e30:	e99fc0ef          	jal	ra,80001cc8 <printk>
80004e34:	04e00593          	li	a1,78
80004e38:	4bc90513          	addi	a0,s2,1212
80004e3c:	ec9fc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80004e40:	a70a0513          	addi	a0,s4,-1424
80004e44:	9e1ff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80004e48:	e45ff0ef          	jal	ra,80004c8c <elapsed>
80004e4c:	00950533          	add	a0,a0,s1
	return list->head == list;
80004e50:	800074b7          	lui	s1,0x80007
80004e54:	9a44a903          	lw	s2,-1628(s1) # 800069a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a5>
80004e58:	00a42423          	sw	a0,8(s0)
80004e5c:	9a448493          	addi	s1,s1,-1628
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004e60:	00990c63          	beq	s2,s1,80004e78 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80004e64:	80007ab7          	lui	s5,0x80007
80004e68:	80007b37          	lui	s6,0x80007
80004e6c:	80006bb7          	lui	s7,0x80006
80004e70:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
80004e74:	02091063          	bnez	s2,80004e94 <z_add_timeout+0x12c>
	node->prev = list->tail;
80004e78:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004e7c:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80004e80:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004e84:	0044a783          	lw	a5,4(s1)
80004e88:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004e8c:	0084a223          	sw	s0,4(s1)
80004e90:	05c0006f          	j	80004eec <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80004e94:	00892783          	lw	a5,8(s2)
80004e98:	0207d663          	bgez	a5,80004ec4 <z_add_timeout+0x15c>
80004e9c:	920b0593          	addi	a1,s6,-1760 # 80006920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006921>
80004ea0:	05600693          	li	a3,86
80004ea4:	8eca8613          	addi	a2,s5,-1812 # 800068ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068ed>
80004ea8:	3f0b8513          	addi	a0,s7,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004eac:	e1dfc0ef          	jal	ra,80001cc8 <printk>
80004eb0:	474c0513          	addi	a0,s8,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
80004eb4:	e15fc0ef          	jal	ra,80001cc8 <printk>
80004eb8:	05600593          	li	a1,86
80004ebc:	8eca8513          	addi	a0,s5,-1812
80004ec0:	e45fc0ef          	jal	ra,80001d04 <assert_post_action>

			if (t->dticks > to->dticks) {
80004ec4:	00892703          	lw	a4,8(s2)
80004ec8:	00842783          	lw	a5,8(s0)
80004ecc:	0ae7d863          	bge	a5,a4,80004f7c <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80004ed0:	40f707b3          	sub	a5,a4,a5
80004ed4:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80004ed8:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004edc:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80004ee0:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80004ee4:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80004ee8:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004eec:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004ef0:	00978a63          	beq	a5,s1,80004f04 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004ef4:	00f41863          	bne	s0,a5,80004f04 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80004ef8:	dedff0ef          	jal	ra,80004ce4 <next_timeout>
80004efc:	00000593          	li	a1,0
80004f00:	8d8fd0ef          	jal	ra,80001fd8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004f04:	a70a0513          	addi	a0,s4,-1424
80004f08:	8edff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80004f0c:	02051e63          	bnez	a0,80004f48 <z_add_timeout+0x1e0>
80004f10:	80006437          	lui	s0,0x80006
80004f14:	800065b7          	lui	a1,0x80006
80004f18:	80006537          	lui	a0,0x80006
80004f1c:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80004f20:	06100693          	li	a3,97
80004f24:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004f28:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004f2c:	d9dfc0ef          	jal	ra,80001cc8 <printk>
80004f30:	80006537          	lui	a0,0x80006
80004f34:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80004f38:	d91fc0ef          	jal	ra,80001cc8 <printk>
80004f3c:	06100593          	li	a1,97
80004f40:	4bc40513          	addi	a0,s0,1212
80004f44:	dc1fc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004f48:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80004f4c:	02c12083          	lw	ra,44(sp)
80004f50:	02812403          	lw	s0,40(sp)
80004f54:	02412483          	lw	s1,36(sp)
80004f58:	02012903          	lw	s2,32(sp)
80004f5c:	01c12983          	lw	s3,28(sp)
80004f60:	01812a03          	lw	s4,24(sp)
80004f64:	01412a83          	lw	s5,20(sp)
80004f68:	01012b03          	lw	s6,16(sp)
80004f6c:	00c12b83          	lw	s7,12(sp)
80004f70:	00812c03          	lw	s8,8(sp)
80004f74:	03010113          	addi	sp,sp,48
80004f78:	00008067          	ret
			to->dticks -= t->dticks;
80004f7c:	40e787b3          	sub	a5,a5,a4
80004f80:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80004f84:	0044a783          	lw	a5,4(s1)
80004f88:	ef2788e3          	beq	a5,s2,80004e78 <z_add_timeout+0x110>
80004f8c:	00092903          	lw	s2,0(s2)
80004f90:	ee5ff06f          	j	80004e74 <z_add_timeout+0x10c>

80004f94 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004f94:	fe010113          	addi	sp,sp,-32
80004f98:	00812c23          	sw	s0,24(sp)
80004f9c:	01312623          	sw	s3,12(sp)
80004fa0:	00112e23          	sw	ra,28(sp)
80004fa4:	00912a23          	sw	s1,20(sp)
80004fa8:	01212823          	sw	s2,16(sp)
80004fac:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004fb0:	00800413          	li	s0,8
80004fb4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004fb8:	800074b7          	lui	s1,0x80007
80004fbc:	a7048513          	addi	a0,s1,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
	key = (mstatus & SOC_MSTATUS_IEN);
80004fc0:	00847413          	andi	s0,s0,8
80004fc4:	809ff0ef          	jal	ra,800047cc <z_spin_lock_valid>
80004fc8:	02051e63          	bnez	a0,80005004 <z_abort_timeout+0x70>
80004fcc:	80006937          	lui	s2,0x80006
80004fd0:	800065b7          	lui	a1,0x80006
80004fd4:	80006537          	lui	a0,0x80006
80004fd8:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80004fdc:	04e00693          	li	a3,78
80004fe0:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80004fe4:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80004fe8:	ce1fc0ef          	jal	ra,80001cc8 <printk>
80004fec:	80006537          	lui	a0,0x80006
80004ff0:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80004ff4:	cd5fc0ef          	jal	ra,80001cc8 <printk>
80004ff8:	04e00593          	li	a1,78
80004ffc:	4bc90513          	addi	a0,s2,1212
80005000:	d05fc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80005004:	a7048513          	addi	a0,s1,-1424
80005008:	81dff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
8000500c:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80005010:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80005014:	00078863          	beqz	a5,80005024 <z_abort_timeout+0x90>
			remove_timeout(to);
80005018:	00098513          	mv	a0,s3
8000501c:	c89ff0ef          	jal	ra,80004ca4 <remove_timeout>
			ret = 0;
80005020:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005024:	a7048513          	addi	a0,s1,-1424
80005028:	fccff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
8000502c:	02051e63          	bnez	a0,80005068 <z_abort_timeout+0xd4>
80005030:	800064b7          	lui	s1,0x80006
80005034:	800065b7          	lui	a1,0x80006
80005038:	80006537          	lui	a0,0x80006
8000503c:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80005040:	06100693          	li	a3,97
80005044:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005048:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000504c:	c7dfc0ef          	jal	ra,80001cc8 <printk>
80005050:	80006537          	lui	a0,0x80006
80005054:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80005058:	c71fc0ef          	jal	ra,80001cc8 <printk>
8000505c:	06100593          	li	a1,97
80005060:	4bc48513          	addi	a0,s1,1212
80005064:	ca1fc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005068:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
8000506c:	01c12083          	lw	ra,28(sp)
80005070:	01812403          	lw	s0,24(sp)
80005074:	00090513          	mv	a0,s2
80005078:	01412483          	lw	s1,20(sp)
8000507c:	01012903          	lw	s2,16(sp)
80005080:	00c12983          	lw	s3,12(sp)
80005084:	02010113          	addi	sp,sp,32
80005088:	00008067          	ret

8000508c <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
8000508c:	ff010113          	addi	sp,sp,-16
80005090:	00812423          	sw	s0,8(sp)
80005094:	00112623          	sw	ra,12(sp)
80005098:	00912223          	sw	s1,4(sp)
8000509c:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800050a0:	00800413          	li	s0,8
800050a4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800050a8:	800074b7          	lui	s1,0x80007
800050ac:	a7048513          	addi	a0,s1,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
	key = (mstatus & SOC_MSTATUS_IEN);
800050b0:	00847413          	andi	s0,s0,8
800050b4:	f18ff0ef          	jal	ra,800047cc <z_spin_lock_valid>
800050b8:	02051e63          	bnez	a0,800050f4 <z_get_next_timeout_expiry+0x68>
800050bc:	80006937          	lui	s2,0x80006
800050c0:	800065b7          	lui	a1,0x80006
800050c4:	80006537          	lui	a0,0x80006
800050c8:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
800050cc:	04e00693          	li	a3,78
800050d0:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800050d4:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800050d8:	bf1fc0ef          	jal	ra,80001cc8 <printk>
800050dc:	80006537          	lui	a0,0x80006
800050e0:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
800050e4:	be5fc0ef          	jal	ra,80001cc8 <printk>
800050e8:	04e00593          	li	a1,78
800050ec:	4bc90513          	addi	a0,s2,1212
800050f0:	c15fc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
800050f4:	a7048513          	addi	a0,s1,-1424
800050f8:	f2cff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
800050fc:	be9ff0ef          	jal	ra,80004ce4 <next_timeout>
80005100:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005104:	a7048513          	addi	a0,s1,-1424
80005108:	eecff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
8000510c:	02051e63          	bnez	a0,80005148 <z_get_next_timeout_expiry+0xbc>
80005110:	800064b7          	lui	s1,0x80006
80005114:	800065b7          	lui	a1,0x80006
80005118:	80006537          	lui	a0,0x80006
8000511c:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80005120:	06100693          	li	a3,97
80005124:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005128:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000512c:	b9dfc0ef          	jal	ra,80001cc8 <printk>
80005130:	80006537          	lui	a0,0x80006
80005134:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80005138:	b91fc0ef          	jal	ra,80001cc8 <printk>
8000513c:	06100593          	li	a1,97
80005140:	4bc48513          	addi	a0,s1,1212
80005144:	bc1fc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005148:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
8000514c:	00c12083          	lw	ra,12(sp)
80005150:	00812403          	lw	s0,8(sp)
80005154:	00090513          	mv	a0,s2
80005158:	00412483          	lw	s1,4(sp)
8000515c:	00012903          	lw	s2,0(sp)
80005160:	01010113          	addi	sp,sp,16
80005164:	00008067          	ret

80005168 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80005168:	fe010113          	addi	sp,sp,-32
8000516c:	00812c23          	sw	s0,24(sp)
80005170:	01212823          	sw	s2,16(sp)
80005174:	01412423          	sw	s4,8(sp)
80005178:	00112e23          	sw	ra,28(sp)
8000517c:	00912a23          	sw	s1,20(sp)
80005180:	01312623          	sw	s3,12(sp)
80005184:	00050913          	mv	s2,a0
80005188:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000518c:	00800413          	li	s0,8
80005190:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005194:	800074b7          	lui	s1,0x80007
80005198:	a7048513          	addi	a0,s1,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
	key = (mstatus & SOC_MSTATUS_IEN);
8000519c:	00847413          	andi	s0,s0,8
800051a0:	e2cff0ef          	jal	ra,800047cc <z_spin_lock_valid>
800051a4:	02051e63          	bnez	a0,800051e0 <z_set_timeout_expiry+0x78>
800051a8:	800069b7          	lui	s3,0x80006
800051ac:	800065b7          	lui	a1,0x80006
800051b0:	80006537          	lui	a0,0x80006
800051b4:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
800051b8:	04e00693          	li	a3,78
800051bc:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800051c0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800051c4:	b05fc0ef          	jal	ra,80001cc8 <printk>
800051c8:	80006537          	lui	a0,0x80006
800051cc:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
800051d0:	af9fc0ef          	jal	ra,80001cc8 <printk>
800051d4:	04e00593          	li	a1,78
800051d8:	4bc98513          	addi	a0,s3,1212
800051dc:	b29fc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
800051e0:	a7048513          	addi	a0,s1,-1424
800051e4:	e40ff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
800051e8:	afdff0ef          	jal	ra,80004ce4 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
800051ec:	00a95c63          	bge	s2,a0,80005204 <z_set_timeout_expiry+0x9c>
800051f0:	00100793          	li	a5,1
800051f4:	00a7d863          	bge	a5,a0,80005204 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
800051f8:	000a0593          	mv	a1,s4
800051fc:	00090513          	mv	a0,s2
80005200:	dd9fc0ef          	jal	ra,80001fd8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005204:	a7048513          	addi	a0,s1,-1424
80005208:	decff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
8000520c:	02051e63          	bnez	a0,80005248 <z_set_timeout_expiry+0xe0>
80005210:	800064b7          	lui	s1,0x80006
80005214:	800065b7          	lui	a1,0x80006
80005218:	80006537          	lui	a0,0x80006
8000521c:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80005220:	06100693          	li	a3,97
80005224:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005228:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000522c:	a9dfc0ef          	jal	ra,80001cc8 <printk>
80005230:	80006537          	lui	a0,0x80006
80005234:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80005238:	a91fc0ef          	jal	ra,80001cc8 <printk>
8000523c:	06100593          	li	a1,97
80005240:	4bc48513          	addi	a0,s1,1212
80005244:	ac1fc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005248:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
8000524c:	01c12083          	lw	ra,28(sp)
80005250:	01812403          	lw	s0,24(sp)
80005254:	01412483          	lw	s1,20(sp)
80005258:	01012903          	lw	s2,16(sp)
8000525c:	00c12983          	lw	s3,12(sp)
80005260:	00812a03          	lw	s4,8(sp)
80005264:	02010113          	addi	sp,sp,32
80005268:	00008067          	ret

8000526c <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
8000526c:	fd010113          	addi	sp,sp,-48
80005270:	02812423          	sw	s0,40(sp)
80005274:	01412c23          	sw	s4,24(sp)
80005278:	02112623          	sw	ra,44(sp)
8000527c:	02912223          	sw	s1,36(sp)
80005280:	03212023          	sw	s2,32(sp)
80005284:	01312e23          	sw	s3,28(sp)
80005288:	01512a23          	sw	s5,20(sp)
8000528c:	01612823          	sw	s6,16(sp)
80005290:	01712623          	sw	s7,12(sp)
80005294:	01812423          	sw	s8,8(sp)
80005298:	01912223          	sw	s9,4(sp)
8000529c:	01a12023          	sw	s10,0(sp)
800052a0:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800052a4:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
800052a8:	8e9fe0ef          	jal	ra,80003b90 <z_time_slice>
800052ac:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800052b0:	80007937          	lui	s2,0x80007
800052b4:	a7090513          	addi	a0,s2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
	key = (mstatus & SOC_MSTATUS_IEN);
800052b8:	00847413          	andi	s0,s0,8
800052bc:	d10ff0ef          	jal	ra,800047cc <z_spin_lock_valid>
800052c0:	02051e63          	bnez	a0,800052fc <z_clock_announce+0x90>
800052c4:	800064b7          	lui	s1,0x80006
800052c8:	800065b7          	lui	a1,0x80006
800052cc:	80006537          	lui	a0,0x80006
800052d0:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
800052d4:	04e00693          	li	a3,78
800052d8:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800052dc:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800052e0:	9e9fc0ef          	jal	ra,80001cc8 <printk>
800052e4:	80006537          	lui	a0,0x80006
800052e8:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
800052ec:	9ddfc0ef          	jal	ra,80001cc8 <printk>
800052f0:	04e00593          	li	a1,78
800052f4:	4bc48513          	addi	a0,s1,1212
800052f8:	a0dfc0ef          	jal	ra,80001d04 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
800052fc:	800079b7          	lui	s3,0x80007
	z_spin_lock_set_owner(l);
80005300:	a7090513          	addi	a0,s2,-1424
80005304:	d20ff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
80005308:	800074b7          	lui	s1,0x80007
8000530c:	a749a623          	sw	s4,-1428(s3) # 80006a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a6d>
	return list->head == list;
80005310:	80007a37          	lui	s4,0x80007
80005314:	a6c98993          	addi	s3,s3,-1428
80005318:	9a4a0a13          	addi	s4,s4,-1628 # 800069a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a5>
8000531c:	a3048493          	addi	s1,s1,-1488 # 80006a30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a31>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005320:	80006ab7          	lui	s5,0x80006
80005324:	80006bb7          	lui	s7,0x80006
80005328:	80006b37          	lui	s6,0x80006
8000532c:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005330:	80006cb7          	lui	s9,0x80006
80005334:	000a2d03          	lw	s10,0(s4)
80005338:	0009a783          	lw	a5,0(s3)
8000533c:	0004a683          	lw	a3,0(s1)
80005340:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005344:	014d0c63          	beq	s10,s4,8000535c <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80005348:	000d0a63          	beqz	s10,8000535c <z_clock_announce+0xf0>
8000534c:	008d2703          	lw	a4,8(s10)
80005350:	0ae7dc63          	bge	a5,a4,80005408 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80005354:	40f70733          	sub	a4,a4,a5
80005358:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
8000535c:	00d786b3          	add	a3,a5,a3
80005360:	41f7d713          	srai	a4,a5,0x1f
80005364:	00a70733          	add	a4,a4,a0
80005368:	00f6b7b3          	sltu	a5,a3,a5
8000536c:	00e787b3          	add	a5,a5,a4
80005370:	00d4a023          	sw	a3,0(s1)
80005374:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005378:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
8000537c:	969ff0ef          	jal	ra,80004ce4 <next_timeout>
80005380:	00000593          	li	a1,0
80005384:	c55fc0ef          	jal	ra,80001fd8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005388:	a7090513          	addi	a0,s2,-1424
8000538c:	c68ff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80005390:	02051e63          	bnez	a0,800053cc <z_clock_announce+0x160>
80005394:	800064b7          	lui	s1,0x80006
80005398:	800065b7          	lui	a1,0x80006
8000539c:	80006537          	lui	a0,0x80006
800053a0:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800053a4:	06100693          	li	a3,97
800053a8:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800053ac:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800053b0:	919fc0ef          	jal	ra,80001cc8 <printk>
800053b4:	80006537          	lui	a0,0x80006
800053b8:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
800053bc:	90dfc0ef          	jal	ra,80001cc8 <printk>
800053c0:	06100593          	li	a1,97
800053c4:	4bc48513          	addi	a0,s1,1212
800053c8:	93dfc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800053cc:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800053d0:	02c12083          	lw	ra,44(sp)
800053d4:	02812403          	lw	s0,40(sp)
800053d8:	02412483          	lw	s1,36(sp)
800053dc:	02012903          	lw	s2,32(sp)
800053e0:	01c12983          	lw	s3,28(sp)
800053e4:	01812a03          	lw	s4,24(sp)
800053e8:	01412a83          	lw	s5,20(sp)
800053ec:	01012b03          	lw	s6,16(sp)
800053f0:	00c12b83          	lw	s7,12(sp)
800053f4:	00812c03          	lw	s8,8(sp)
800053f8:	00412c83          	lw	s9,4(sp)
800053fc:	00012d03          	lw	s10,0(sp)
80005400:	03010113          	addi	sp,sp,48
80005404:	00008067          	ret
		curr_tick += dt;
80005408:	00d706b3          	add	a3,a4,a3
8000540c:	41f75593          	srai	a1,a4,0x1f
80005410:	00a585b3          	add	a1,a1,a0
80005414:	00e6b633          	sltu	a2,a3,a4
80005418:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
8000541c:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
80005420:	000d0513          	mv	a0,s10
		t->dticks = 0;
80005424:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80005428:	00d4a023          	sw	a3,0(s1)
8000542c:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
80005430:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80005434:	871ff0ef          	jal	ra,80004ca4 <remove_timeout>
80005438:	a7090513          	addi	a0,s2,-1424
8000543c:	bb8ff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80005440:	02051663          	bnez	a0,8000546c <z_clock_announce+0x200>
80005444:	504b8593          	addi	a1,s7,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80005448:	06100693          	li	a3,97
8000544c:	4bca8613          	addi	a2,s5,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005450:	3f0b0513          	addi	a0,s6,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80005454:	875fc0ef          	jal	ra,80001cc8 <printk>
80005458:	51cc0513          	addi	a0,s8,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
8000545c:	86dfc0ef          	jal	ra,80001cc8 <printk>
80005460:	06100593          	li	a1,97
80005464:	4bca8513          	addi	a0,s5,1212
80005468:	89dfc0ef          	jal	ra,80001d04 <assert_post_action>
8000546c:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80005470:	00cd2783          	lw	a5,12(s10)
80005474:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005478:	00800413          	li	s0,8
8000547c:	000780e7          	jalr	a5
80005480:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005484:	a7090513          	addi	a0,s2,-1424
	key = (mstatus & SOC_MSTATUS_IEN);
80005488:	00847413          	andi	s0,s0,8
8000548c:	b40ff0ef          	jal	ra,800047cc <z_spin_lock_valid>
80005490:	02051863          	bnez	a0,800054c0 <z_clock_announce+0x254>
80005494:	4d4c8593          	addi	a1,s9,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80005498:	04e00693          	li	a3,78
8000549c:	4bca8613          	addi	a2,s5,1212
800054a0:	3f0b0513          	addi	a0,s6,1008
800054a4:	825fc0ef          	jal	ra,80001cc8 <printk>
800054a8:	80006537          	lui	a0,0x80006
800054ac:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
800054b0:	819fc0ef          	jal	ra,80001cc8 <printk>
800054b4:	04e00593          	li	a1,78
800054b8:	4bca8513          	addi	a0,s5,1212
800054bc:	849fc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
800054c0:	a7090513          	addi	a0,s2,-1424
800054c4:	b60ff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	return k;
800054c8:	e6dff06f          	j	80005334 <z_clock_announce+0xc8>

800054cc <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
800054cc:	fe010113          	addi	sp,sp,-32
800054d0:	00912a23          	sw	s1,20(sp)
800054d4:	00112e23          	sw	ra,28(sp)
800054d8:	00812c23          	sw	s0,24(sp)
800054dc:	01212823          	sw	s2,16(sp)
800054e0:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800054e4:	00800493          	li	s1,8
800054e8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800054ec:	80007937          	lui	s2,0x80007
800054f0:	a7090513          	addi	a0,s2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
	key = (mstatus & SOC_MSTATUS_IEN);
800054f4:	0084f493          	andi	s1,s1,8
800054f8:	ad4ff0ef          	jal	ra,800047cc <z_spin_lock_valid>
800054fc:	02051e63          	bnez	a0,80005538 <z_tick_get+0x6c>
80005500:	80006437          	lui	s0,0x80006
80005504:	800065b7          	lui	a1,0x80006
80005508:	80006537          	lui	a0,0x80006
8000550c:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80005510:	04e00693          	li	a3,78
80005514:	4bc40613          	addi	a2,s0,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005518:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
8000551c:	facfc0ef          	jal	ra,80001cc8 <printk>
80005520:	80006537          	lui	a0,0x80006
80005524:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80005528:	fa0fc0ef          	jal	ra,80001cc8 <printk>
8000552c:	04e00593          	li	a1,78
80005530:	4bc40513          	addi	a0,s0,1212
80005534:	fd0fc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80005538:	a7090513          	addi	a0,s2,-1424
8000553c:	ae8ff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80005540:	c15fc0ef          	jal	ra,80002154 <z_clock_elapsed>
80005544:	800077b7          	lui	a5,0x80007
80005548:	a3078793          	addi	a5,a5,-1488 # 80006a30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a31>
8000554c:	0007a983          	lw	s3,0(a5)
80005550:	0047a403          	lw	s0,4(a5)
80005554:	013509b3          	add	s3,a0,s3
80005558:	00a9b533          	sltu	a0,s3,a0
8000555c:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005560:	a7090513          	addi	a0,s2,-1424
80005564:	a90ff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80005568:	02051e63          	bnez	a0,800055a4 <z_tick_get+0xd8>
8000556c:	80006937          	lui	s2,0x80006
80005570:	800065b7          	lui	a1,0x80006
80005574:	80006537          	lui	a0,0x80006
80005578:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
8000557c:	06100693          	li	a3,97
80005580:	4bc90613          	addi	a2,s2,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005584:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80005588:	f40fc0ef          	jal	ra,80001cc8 <printk>
8000558c:	80006537          	lui	a0,0x80006
80005590:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80005594:	f34fc0ef          	jal	ra,80001cc8 <printk>
80005598:	06100593          	li	a1,97
8000559c:	4bc90513          	addi	a0,s2,1212
800055a0:	f64fc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800055a4:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
800055a8:	00040593          	mv	a1,s0
800055ac:	01c12083          	lw	ra,28(sp)
800055b0:	01812403          	lw	s0,24(sp)
800055b4:	00098513          	mv	a0,s3
800055b8:	01412483          	lw	s1,20(sp)
800055bc:	01012903          	lw	s2,16(sp)
800055c0:	00c12983          	lw	s3,12(sp)
800055c4:	02010113          	addi	sp,sp,32
800055c8:	00008067          	ret

800055cc <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
800055cc:	ff010113          	addi	sp,sp,-16
800055d0:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
800055d4:	ef9ff0ef          	jal	ra,800054cc <z_tick_get>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
800055d8:	3e800793          	li	a5,1000
800055dc:	02a7b733          	mulhu	a4,a5,a0
800055e0:	06400613          	li	a2,100
800055e4:	00000693          	li	a3,0
800055e8:	02b785b3          	mul	a1,a5,a1
800055ec:	02a78533          	mul	a0,a5,a0
800055f0:	00e585b3          	add	a1,a1,a4
800055f4:	cbdfa0ef          	jal	ra,800002b0 <__udivdi3>
}
800055f8:	00c12083          	lw	ra,12(sp)
800055fc:	01010113          	addi	sp,sp,16
80005600:	00008067          	ret

80005604 <z_impl_atomic_or>:
 * @param value the value to OR
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_or(atomic_t *target, atomic_val_t value)
{
80005604:	fe010113          	addi	sp,sp,-32
80005608:	00812c23          	sw	s0,24(sp)
8000560c:	01212823          	sw	s2,16(sp)
80005610:	01412423          	sw	s4,8(sp)
80005614:	00112e23          	sw	ra,28(sp)
80005618:	00912a23          	sw	s1,20(sp)
8000561c:	01312623          	sw	s3,12(sp)
80005620:	00050a13          	mv	s4,a0
80005624:	00058913          	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005628:	00800413          	li	s0,8
8000562c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005630:	800074b7          	lui	s1,0x80007
80005634:	a7448513          	addi	a0,s1,-1420 # 80006a74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a75>
	key = (mstatus & SOC_MSTATUS_IEN);
80005638:	00847413          	andi	s0,s0,8
8000563c:	990ff0ef          	jal	ra,800047cc <z_spin_lock_valid>
80005640:	02051e63          	bnez	a0,8000567c <z_impl_atomic_or+0x78>
80005644:	800069b7          	lui	s3,0x80006
80005648:	800065b7          	lui	a1,0x80006
8000564c:	80006537          	lui	a0,0x80006
80005650:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80005654:	04e00693          	li	a3,78
80005658:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
8000565c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80005660:	e68fc0ef          	jal	ra,80001cc8 <printk>
80005664:	80006537          	lui	a0,0x80006
80005668:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
8000566c:	e5cfc0ef          	jal	ra,80001cc8 <printk>
80005670:	04e00593          	li	a1,78
80005674:	4bc98513          	addi	a0,s3,1212
80005678:	e8cfc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
8000567c:	a7448513          	addi	a0,s1,-1420
80005680:	9a4ff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
80005684:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005688:	a7448513          	addi	a0,s1,-1420
	*target |= value;
8000568c:	0129e933          	or	s2,s3,s2
80005690:	012a2023          	sw	s2,0(s4)
80005694:	960ff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80005698:	02051e63          	bnez	a0,800056d4 <z_impl_atomic_or+0xd0>
8000569c:	800064b7          	lui	s1,0x80006
800056a0:	800065b7          	lui	a1,0x80006
800056a4:	80006537          	lui	a0,0x80006
800056a8:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800056ac:	06100693          	li	a3,97
800056b0:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800056b4:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800056b8:	e10fc0ef          	jal	ra,80001cc8 <printk>
800056bc:	80006537          	lui	a0,0x80006
800056c0:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
800056c4:	e04fc0ef          	jal	ra,80001cc8 <printk>
800056c8:	06100593          	li	a1,97
800056cc:	4bc48513          	addi	a0,s1,1212
800056d0:	e34fc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800056d4:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
800056d8:	01c12083          	lw	ra,28(sp)
800056dc:	01812403          	lw	s0,24(sp)
800056e0:	00098513          	mv	a0,s3
800056e4:	01412483          	lw	s1,20(sp)
800056e8:	01012903          	lw	s2,16(sp)
800056ec:	00c12983          	lw	s3,12(sp)
800056f0:	00812a03          	lw	s4,8(sp)
800056f4:	02010113          	addi	sp,sp,32
800056f8:	00008067          	ret

800056fc <z_impl_atomic_and>:
 * @param value the value to AND
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_and(atomic_t *target, atomic_val_t value)
{
800056fc:	fe010113          	addi	sp,sp,-32
80005700:	00812c23          	sw	s0,24(sp)
80005704:	01212823          	sw	s2,16(sp)
80005708:	01412423          	sw	s4,8(sp)
8000570c:	00112e23          	sw	ra,28(sp)
80005710:	00912a23          	sw	s1,20(sp)
80005714:	01312623          	sw	s3,12(sp)
80005718:	00050a13          	mv	s4,a0
8000571c:	00058913          	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005720:	00800413          	li	s0,8
80005724:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005728:	800074b7          	lui	s1,0x80007
8000572c:	a7448513          	addi	a0,s1,-1420 # 80006a74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a75>
	key = (mstatus & SOC_MSTATUS_IEN);
80005730:	00847413          	andi	s0,s0,8
80005734:	898ff0ef          	jal	ra,800047cc <z_spin_lock_valid>
80005738:	02051e63          	bnez	a0,80005774 <z_impl_atomic_and+0x78>
8000573c:	800069b7          	lui	s3,0x80006
80005740:	800065b7          	lui	a1,0x80006
80005744:	80006537          	lui	a0,0x80006
80005748:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
8000574c:	04e00693          	li	a3,78
80005750:	4bc98613          	addi	a2,s3,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005754:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80005758:	d70fc0ef          	jal	ra,80001cc8 <printk>
8000575c:	80006537          	lui	a0,0x80006
80005760:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80005764:	d64fc0ef          	jal	ra,80001cc8 <printk>
80005768:	04e00593          	li	a1,78
8000576c:	4bc98513          	addi	a0,s3,1212
80005770:	d94fc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80005774:	a7448513          	addi	a0,s1,-1420
80005778:	8acff0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
8000577c:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005780:	a7448513          	addi	a0,s1,-1420
	*target &= value;
80005784:	0129f933          	and	s2,s3,s2
80005788:	012a2023          	sw	s2,0(s4)
8000578c:	868ff0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80005790:	02051e63          	bnez	a0,800057cc <z_impl_atomic_and+0xd0>
80005794:	800064b7          	lui	s1,0x80006
80005798:	800065b7          	lui	a1,0x80006
8000579c:	80006537          	lui	a0,0x80006
800057a0:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
800057a4:	06100693          	li	a3,97
800057a8:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
800057ac:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800057b0:	d18fc0ef          	jal	ra,80001cc8 <printk>
800057b4:	80006537          	lui	a0,0x80006
800057b8:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
800057bc:	d0cfc0ef          	jal	ra,80001cc8 <printk>
800057c0:	06100593          	li	a1,97
800057c4:	4bc48513          	addi	a0,s1,1212
800057c8:	d3cfc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800057cc:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
800057d0:	01c12083          	lw	ra,28(sp)
800057d4:	01812403          	lw	s0,24(sp)
800057d8:	00098513          	mv	a0,s3
800057dc:	01412483          	lw	s1,20(sp)
800057e0:	01012903          	lw	s2,16(sp)
800057e4:	00c12983          	lw	s3,12(sp)
800057e8:	00812a03          	lw	s4,8(sp)
800057ec:	02010113          	addi	sp,sp,32
800057f0:	00008067          	ret

800057f4 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
800057f4:	ff010113          	addi	sp,sp,-16
800057f8:	00812423          	sw	s0,8(sp)
800057fc:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005800:	80007437          	lui	s0,0x80007
80005804:	800074b7          	lui	s1,0x80007
{
80005808:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000580c:	9e440413          	addi	s0,s0,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
80005810:	9e448493          	addi	s1,s1,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
80005814:	00946e63          	bltu	s0,s1,80005830 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80005818:	00c12083          	lw	ra,12(sp)
8000581c:	00812403          	lw	s0,8(sp)
80005820:	00412483          	lw	s1,4(sp)
80005824:	00000513          	li	a0,0
80005828:	01010113          	addi	sp,sp,16
8000582c:	00008067          	ret
80005830:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80005834:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80005838:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
8000583c:	00f42c23          	sw	a5,24(s0)
80005840:	f38fb0ef          	jal	ra,80000f78 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005844:	01c40413          	addi	s0,s0,28
80005848:	fcdff06f          	j	80005814 <init_static_pools+0x20>

8000584c <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
8000584c:	800077b7          	lui	a5,0x80007
80005850:	d447a783          	lw	a5,-700(a5) # 80006d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d45>
{
80005854:	fb010113          	addi	sp,sp,-80
80005858:	04912223          	sw	s1,68(sp)
8000585c:	03312e23          	sw	s3,60(sp)
80005860:	03412c23          	sw	s4,56(sp)
80005864:	03712623          	sw	s7,44(sp)
80005868:	04112623          	sw	ra,76(sp)
8000586c:	04812423          	sw	s0,72(sp)
80005870:	05212023          	sw	s2,64(sp)
80005874:	03512a23          	sw	s5,52(sp)
80005878:	03612823          	sw	s6,48(sp)
8000587c:	03812423          	sw	s8,40(sp)
80005880:	03912223          	sw	s9,36(sp)
80005884:	03a12023          	sw	s10,32(sp)
80005888:	01b12e23          	sw	s11,28(sp)
8000588c:	00050a13          	mv	s4,a0
80005890:	00058993          	mv	s3,a1
80005894:	00060b93          	mv	s7,a2
80005898:	00068493          	mv	s1,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
8000589c:	16078263          	beqz	a5,80005a00 <k_mem_pool_alloc+0x1b4>
800058a0:	12069463          	bnez	a3,800059c8 <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
800058a4:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
800058a8:	80007437          	lui	s0,0x80007
800058ac:	9e440413          	addi	s0,s0,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
800058b0:	408a0433          	sub	s0,s4,s0
800058b4:	b6db77b7          	lui	a5,0xb6db7
800058b8:	40245413          	srai	s0,s0,0x2
800058bc:	db778793          	addi	a5,a5,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
800058c0:	02f40433          	mul	s0,s0,a5
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
800058c4:	fffffab7          	lui	s5,0xfffff
		block->id.block = block_num;
800058c8:	00001b37          	lui	s6,0x1
			if (ret != -EAGAIN) {
800058cc:	ff500c13          	li	s8,-11
			ret = -ENOMEM;
800058d0:	ff400c93          	li	s9,-12
		block->id.level = level_num;
800058d4:	0ffa8a93          	addi	s5,s5,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
800058d8:	fffb0b13          	addi	s6,s6,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800058dc:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
800058e0:	014a0d93          	addi	s11,s4,20
		block->id.pool = pool_id(p);
800058e4:	0ff47413          	andi	s0,s0,255
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
800058e8:	00098713          	mv	a4,s3
800058ec:	00c10693          	addi	a3,sp,12
800058f0:	00810613          	addi	a2,sp,8
800058f4:	000b8593          	mv	a1,s7
800058f8:	000a0513          	mv	a0,s4
800058fc:	f7cfb0ef          	jal	ra,80001078 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80005900:	03851263          	bne	a0,s8,80005924 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80005904:	00098713          	mv	a4,s3
80005908:	00c10693          	addi	a3,sp,12
8000590c:	00810613          	addi	a2,sp,8
80005910:	000b8593          	mv	a1,s7
80005914:	000a0513          	mv	a0,s4
80005918:	f60fb0ef          	jal	ra,80001078 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
8000591c:	01851463          	bne	a0,s8,80005924 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
80005920:	ff400513          	li	a0,-12
		block->id.level = level_num;
80005924:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80005928:	00898223          	sb	s0,4(s3)
		block->id.level = level_num;
8000592c:	00f7f793          	andi	a5,a5,15
80005930:	00879713          	slli	a4,a5,0x8
80005934:	0049a783          	lw	a5,4(s3)
80005938:	0157f7b3          	and	a5,a5,s5
8000593c:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
80005940:	00c12703          	lw	a4,12(sp)
80005944:	0167f7b3          	and	a5,a5,s6
80005948:	00c71713          	slli	a4,a4,0xc
8000594c:	00e7e7b3          	or	a5,a5,a4
80005950:	00f9a223          	sw	a5,4(s3)
		if (ret == 0 || timeout == K_NO_WAIT ||
80005954:	02050c63          	beqz	a0,8000598c <k_mem_pool_alloc+0x140>
80005958:	02048a63          	beqz	s1,8000598c <k_mem_pool_alloc+0x140>
8000595c:	03951863          	bne	a0,s9,8000598c <k_mem_pool_alloc+0x140>
80005960:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
80005964:	00048613          	mv	a2,s1
80005968:	000d8593          	mv	a1,s11
8000596c:	00857513          	andi	a0,a0,8
80005970:	cd8fe0ef          	jal	ra,80003e48 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
80005974:	fff00793          	li	a5,-1
80005978:	f6f488e3          	beq	s1,a5,800058e8 <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
8000597c:	b51ff0ef          	jal	ra,800054cc <z_tick_get>
80005980:	40a904b3          	sub	s1,s2,a0

			if (timeout < 0) {
80005984:	f604d2e3          	bgez	s1,800058e8 <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
80005988:	ff500513          	li	a0,-11
}
8000598c:	04c12083          	lw	ra,76(sp)
80005990:	04812403          	lw	s0,72(sp)
80005994:	04412483          	lw	s1,68(sp)
80005998:	04012903          	lw	s2,64(sp)
8000599c:	03c12983          	lw	s3,60(sp)
800059a0:	03812a03          	lw	s4,56(sp)
800059a4:	03412a83          	lw	s5,52(sp)
800059a8:	03012b03          	lw	s6,48(sp)
800059ac:	02c12b83          	lw	s7,44(sp)
800059b0:	02812c03          	lw	s8,40(sp)
800059b4:	02412c83          	lw	s9,36(sp)
800059b8:	02012d03          	lw	s10,32(sp)
800059bc:	01c12d83          	lw	s11,28(sp)
800059c0:	05010113          	addi	sp,sp,80
800059c4:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800059c8:	80007437          	lui	s0,0x80007
800059cc:	800075b7          	lui	a1,0x80007
800059d0:	80006537          	lui	a0,0x80006
800059d4:	94458593          	addi	a1,a1,-1724 # 80006944 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006945>
800059d8:	03900693          	li	a3,57
800059dc:	93040613          	addi	a2,s0,-1744 # 80006930 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006931>
800059e0:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
800059e4:	ae4fc0ef          	jal	ra,80001cc8 <printk>
800059e8:	80006537          	lui	a0,0x80006
800059ec:	47450513          	addi	a0,a0,1140 # 80006474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006475>
800059f0:	ad8fc0ef          	jal	ra,80001cc8 <printk>
800059f4:	03900593          	li	a1,57
800059f8:	93040513          	addi	a0,s0,-1744
800059fc:	b08fc0ef          	jal	ra,80001d04 <assert_post_action>
	if (timeout > 0) {
80005a00:	ea9052e3          	blez	s1,800058a4 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80005a04:	ac9ff0ef          	jal	ra,800054cc <z_tick_get>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005a08:	00948913          	addi	s2,s1,9
80005a0c:	00a00793          	li	a5,10
80005a10:	02f94933          	div	s2,s2,a5
80005a14:	00a90933          	add	s2,s2,a0
80005a18:	e91ff06f          	j	800058a8 <k_mem_pool_alloc+0x5c>

80005a1c <k_mem_pool_free_id>:

void k_mem_pool_free_id(struct k_mem_block_id *id)
{
80005a1c:	fe010113          	addi	sp,sp,-32
80005a20:	01212823          	sw	s2,16(sp)
80005a24:	00054903          	lbu	s2,0(a0)
80005a28:	01c00793          	li	a5,28
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005a2c:	00052603          	lw	a2,0(a0)
80005a30:	02f90933          	mul	s2,s2,a5
{
80005a34:	01312623          	sw	s3,12(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005a38:	800079b7          	lui	s3,0x80007
80005a3c:	00865593          	srli	a1,a2,0x8
80005a40:	9e498513          	addi	a0,s3,-1564 # 800069e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e5>
80005a44:	00c65613          	srli	a2,a2,0xc
80005a48:	00f5f593          	andi	a1,a1,15
{
80005a4c:	00812c23          	sw	s0,24(sp)
80005a50:	00112e23          	sw	ra,28(sp)
80005a54:	00912a23          	sw	s1,20(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005a58:	01250533          	add	a0,a0,s2
{
80005a5c:	01412423          	sw	s4,8(sp)
80005a60:	00800413          	li	s0,8
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005a64:	8ddfb0ef          	jal	ra,80001340 <z_sys_mem_pool_block_free>
80005a68:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005a6c:	800074b7          	lui	s1,0x80007
80005a70:	a7848513          	addi	a0,s1,-1416 # 80006a78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a79>
80005a74:	d59fe0ef          	jal	ra,800047cc <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
80005a78:	00847413          	andi	s0,s0,8
80005a7c:	9e498993          	addi	s3,s3,-1564
80005a80:	02051e63          	bnez	a0,80005abc <k_mem_pool_free_id+0xa0>
80005a84:	80006a37          	lui	s4,0x80006
80005a88:	800065b7          	lui	a1,0x80006
80005a8c:	80006537          	lui	a0,0x80006
80005a90:	4d458593          	addi	a1,a1,1236 # 800064d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d5>
80005a94:	04e00693          	li	a3,78
80005a98:	4bca0613          	addi	a2,s4,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005a9c:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80005aa0:	a28fc0ef          	jal	ra,80001cc8 <printk>
80005aa4:	80006537          	lui	a0,0x80006
80005aa8:	4ec50513          	addi	a0,a0,1260 # 800064ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064ed>
80005aac:	a1cfc0ef          	jal	ra,80001cc8 <printk>
80005ab0:	04e00593          	li	a1,78
80005ab4:	4bca0513          	addi	a0,s4,1212
80005ab8:	a4cfc0ef          	jal	ra,80001d04 <assert_post_action>
	z_spin_lock_set_owner(l);
80005abc:	a7848513          	addi	a0,s1,-1416
80005ac0:	d65fe0ef          	jal	ra,80004824 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80005ac4:	01490513          	addi	a0,s2,20
80005ac8:	00a98533          	add	a0,s3,a0
80005acc:	decfe0ef          	jal	ra,800040b8 <z_unpend_all>

	if (need_sched != 0) {
80005ad0:	02050663          	beqz	a0,80005afc <k_mem_pool_free_id+0xe0>
		z_reschedule(&lock, key);
80005ad4:	00040593          	mv	a1,s0
	} else {
		k_spin_unlock(&lock, key);
	}
}
80005ad8:	01812403          	lw	s0,24(sp)
80005adc:	01c12083          	lw	ra,28(sp)
80005ae0:	01012903          	lw	s2,16(sp)
80005ae4:	00c12983          	lw	s3,12(sp)
80005ae8:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80005aec:	a7848513          	addi	a0,s1,-1416
}
80005af0:	01412483          	lw	s1,20(sp)
80005af4:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80005af8:	dbcfd06f          	j	800030b4 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005afc:	a7848513          	addi	a0,s1,-1416
80005b00:	cf5fe0ef          	jal	ra,800047f4 <z_spin_unlock_valid>
80005b04:	02051e63          	bnez	a0,80005b40 <k_mem_pool_free_id+0x124>
80005b08:	800064b7          	lui	s1,0x80006
80005b0c:	800065b7          	lui	a1,0x80006
80005b10:	80006537          	lui	a0,0x80006
80005b14:	50458593          	addi	a1,a1,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80005b18:	06100693          	li	a3,97
80005b1c:	4bc48613          	addi	a2,s1,1212 # 800064bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064bd>
80005b20:	3f050513          	addi	a0,a0,1008 # 800063f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063f1>
80005b24:	9a4fc0ef          	jal	ra,80001cc8 <printk>
80005b28:	80006537          	lui	a0,0x80006
80005b2c:	51c50513          	addi	a0,a0,1308 # 8000651c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000651d>
80005b30:	998fc0ef          	jal	ra,80001cc8 <printk>
80005b34:	06100593          	li	a1,97
80005b38:	4bc48513          	addi	a0,s1,1212
80005b3c:	9c8fc0ef          	jal	ra,80001d04 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005b40:	30042473          	csrrs	s0,mstatus,s0
}
80005b44:	01c12083          	lw	ra,28(sp)
80005b48:	01812403          	lw	s0,24(sp)
80005b4c:	01412483          	lw	s1,20(sp)
80005b50:	01012903          	lw	s2,16(sp)
80005b54:	00c12983          	lw	s3,12(sp)
80005b58:	00812a03          	lw	s4,8(sp)
80005b5c:	02010113          	addi	sp,sp,32
80005b60:	00008067          	ret

80005b64 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
80005b64:	00458613          	addi	a2,a1,4
80005b68:	00b67e63          	bgeu	a2,a1,80005b84 <k_mem_pool_malloc+0x20>
				   &size)) {
		return NULL;
80005b6c:	00000513          	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
80005b70:	00008067          	ret
		return NULL;
80005b74:	00000513          	li	a0,0
}
80005b78:	01c12083          	lw	ra,28(sp)
80005b7c:	02010113          	addi	sp,sp,32
80005b80:	00008067          	ret
{
80005b84:	fe010113          	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80005b88:	00000693          	li	a3,0
80005b8c:	00810593          	addi	a1,sp,8
{
80005b90:	00112e23          	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80005b94:	cb9ff0ef          	jal	ra,8000584c <k_mem_pool_alloc>
80005b98:	fc051ee3          	bnez	a0,80005b74 <k_mem_pool_malloc+0x10>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
80005b9c:	00812503          	lw	a0,8(sp)
80005ba0:	00400613          	li	a2,4
80005ba4:	00c10593          	addi	a1,sp,12
80005ba8:	ec0fc0ef          	jal	ra,80002268 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80005bac:	00812503          	lw	a0,8(sp)
80005bb0:	00450513          	addi	a0,a0,4
80005bb4:	fc5ff06f          	j	80005b78 <k_mem_pool_malloc+0x14>

80005bb8 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
80005bb8:	00050663          	beqz	a0,80005bc4 <k_free+0xc>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
80005bbc:	ffc50513          	addi	a0,a0,-4
80005bc0:	e5dff06f          	j	80005a1c <k_mem_pool_free_id>
	}
}
80005bc4:	00008067          	ret

80005bc8 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
80005bc8:	800077b7          	lui	a5,0x80007
80005bcc:	d4c7a783          	lw	a5,-692(a5) # 80006d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d4d>
{
80005bd0:	00050593          	mv	a1,a0
	if (_current->resource_pool != NULL) {
80005bd4:	0687a503          	lw	a0,104(a5)
80005bd8:	00050463          	beqz	a0,80005be0 <z_thread_malloc+0x18>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80005bdc:	f89ff06f          	j	80005b64 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
80005be0:	00000513          	li	a0,0
80005be4:	00008067          	ret

80005be8 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80005be8:	00008067          	ret
