
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	7190006f          	j	80000f24 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	1f0000ef          	jal	ra,8000025c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	02051e63          	bnez	a0,800000b0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	13408093          	addi	ra,ra,308 # 800001c8 <no_reschedule>
	tail _Fault
8000009c:	5c10006f          	j	80000e5c <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000ac:	0900006f          	j	8000013c <reschedule>

800000b0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000b0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000b4:	00007397          	auipc	t2,0x7
800000b8:	8d038393          	addi	t2,t2,-1840 # 80006984 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000bc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000c0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000c4:	00512023          	sw	t0,0(sp)

800000c8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000c8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000cc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000d0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000d4:	00030863          	beqz	t1,800000e4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000d8:	00000097          	auipc	ra,0x0
800000dc:	03c08093          	addi	ra,ra,60 # 80000114 <on_thread_stack>
	tail z_irq_do_offload
800000e0:	6090006f          	j	80000ee8 <z_irq_do_offload>

800000e4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000e4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000e8:	800002b7          	lui	t0,0x80000
800000ec:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000f0:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000f4:	158000ef          	jal	ra,8000024c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000f8:	00005297          	auipc	t0,0x5
800000fc:	6b028293          	addi	t0,t0,1712 # 800057a8 <_image_text_end>
	slli a0, a0, 3
80000100:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000104:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000108:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000010c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000110:	000300e7          	jalr	t1

80000114 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000114:	00007317          	auipc	t1,0x7
80000118:	87030313          	addi	t1,t1,-1936 # 80006984 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000011c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000120:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000124:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000128:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000012c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000130:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000134:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000138:	087e0863          	beq	t3,t2,800001c8 <no_reschedule>

8000013c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000013c:	00007297          	auipc	t0,0x7
80000140:	84828293          	addi	t0,t0,-1976 # 80006984 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000144:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000148:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000014c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000150:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000154:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000158:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000015c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000160:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000164:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000168:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000016c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000170:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000174:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000178:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000017c:	00006397          	auipc	t2,0x6
80000180:	46038393          	addi	t2,t2,1120 # 800065dc <_k_neg_eagain>
	lw t3, 0x00(t2)
80000184:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000188:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000018c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000190:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000194:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000198:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000019c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001a0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001a4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001a8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001ac:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001b0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001b4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001b8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001bc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001c0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001c4:	05832d83          	lw	s11,88(t1)

800001c8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001c8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001cc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001d0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001d4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001d8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001dc:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001e0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001e4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001e8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ec:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001f0:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001f4:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001f8:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001fc:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000200:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000204:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000208:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000020c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000210:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000214:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000218:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000021c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000220:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000224:	30200073          	mret

80000228 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000228:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000022c:	00006297          	auipc	t0,0x6
80000230:	75828293          	addi	t0,t0,1880 # 80006984 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000234:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000238:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000023c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000240:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000244:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000248:	00008067          	ret

8000024c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000024c:	00100313          	li	t1,1
	sll t0, t1, a0
80000250:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000254:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000025c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000260:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000264:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000268:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000026c:	00028463          	beqz	t0,80000274 <not_interrupt>
	addi a0, a0, 1
80000270:	00150513          	addi	a0,a0,1

80000274 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000274:	00008067          	ret

Disassembly of section text:

80000278 <__lshrdi3>:
80000278:	02060063          	beqz	a2,80000298 <__lshrdi3+0x20>
8000027c:	02000793          	li	a5,32
80000280:	40c787b3          	sub	a5,a5,a2
80000284:	00f04c63          	bgtz	a5,8000029c <__lshrdi3+0x24>
80000288:	fe060513          	addi	a0,a2,-32
8000028c:	00000713          	li	a4,0
80000290:	00a5d533          	srl	a0,a1,a0
80000294:	00070593          	mv	a1,a4
80000298:	00008067          	ret
8000029c:	00c5d733          	srl	a4,a1,a2
800002a0:	00c55533          	srl	a0,a0,a2
800002a4:	00f595b3          	sll	a1,a1,a5
800002a8:	00b56533          	or	a0,a0,a1
800002ac:	fe9ff06f          	j	80000294 <__lshrdi3+0x1c>

800002b0 <__udivdi3>:
800002b0:	fd010113          	addi	sp,sp,-48
800002b4:	02912223          	sw	s1,36(sp)
800002b8:	01612823          	sw	s6,16(sp)
800002bc:	02112623          	sw	ra,44(sp)
800002c0:	02812423          	sw	s0,40(sp)
800002c4:	03212023          	sw	s2,32(sp)
800002c8:	01312e23          	sw	s3,28(sp)
800002cc:	01412c23          	sw	s4,24(sp)
800002d0:	01512a23          	sw	s5,20(sp)
800002d4:	01712623          	sw	s7,12(sp)
800002d8:	01812423          	sw	s8,8(sp)
800002dc:	01912223          	sw	s9,4(sp)
800002e0:	00050b13          	mv	s6,a0
800002e4:	00058493          	mv	s1,a1
800002e8:	38069c63          	bnez	a3,80000680 <__udivdi3+0x3d0>
800002ec:	00060413          	mv	s0,a2
800002f0:	00050993          	mv	s3,a0
800002f4:	00005917          	auipc	s2,0x5
800002f8:	64090913          	addi	s2,s2,1600 # 80005934 <__devconfig_end>
800002fc:	12c5f863          	bgeu	a1,a2,8000042c <__udivdi3+0x17c>
80000300:	000107b7          	lui	a5,0x10
80000304:	00058a93          	mv	s5,a1
80000308:	10f67863          	bgeu	a2,a5,80000418 <__udivdi3+0x168>
8000030c:	0ff00693          	li	a3,255
80000310:	00c6b6b3          	sltu	a3,a3,a2
80000314:	00369693          	slli	a3,a3,0x3
80000318:	00d657b3          	srl	a5,a2,a3
8000031c:	00f90933          	add	s2,s2,a5
80000320:	00094703          	lbu	a4,0(s2)
80000324:	00d706b3          	add	a3,a4,a3
80000328:	02000713          	li	a4,32
8000032c:	40d70733          	sub	a4,a4,a3
80000330:	00070c63          	beqz	a4,80000348 <__udivdi3+0x98>
80000334:	00e494b3          	sll	s1,s1,a4
80000338:	00db56b3          	srl	a3,s6,a3
8000033c:	00e61433          	sll	s0,a2,a4
80000340:	0096eab3          	or	s5,a3,s1
80000344:	00eb19b3          	sll	s3,s6,a4
80000348:	01045b13          	srli	s6,s0,0x10
8000034c:	000b0593          	mv	a1,s6
80000350:	000a8513          	mv	a0,s5
80000354:	5a4000ef          	jal	ra,800008f8 <__umodsi3>
80000358:	00050913          	mv	s2,a0
8000035c:	000b0593          	mv	a1,s6
80000360:	01041b93          	slli	s7,s0,0x10
80000364:	000a8513          	mv	a0,s5
80000368:	548000ef          	jal	ra,800008b0 <__udivsi3>
8000036c:	010bdb93          	srli	s7,s7,0x10
80000370:	00050493          	mv	s1,a0
80000374:	00050593          	mv	a1,a0
80000378:	000b8513          	mv	a0,s7
8000037c:	508000ef          	jal	ra,80000884 <__mulsi3>
80000380:	01091913          	slli	s2,s2,0x10
80000384:	0109d713          	srli	a4,s3,0x10
80000388:	00e96733          	or	a4,s2,a4
8000038c:	00048a13          	mv	s4,s1
80000390:	00a77e63          	bgeu	a4,a0,800003ac <__udivdi3+0xfc>
80000394:	00870733          	add	a4,a4,s0
80000398:	fff48a13          	addi	s4,s1,-1
8000039c:	00876863          	bltu	a4,s0,800003ac <__udivdi3+0xfc>
800003a0:	00a77663          	bgeu	a4,a0,800003ac <__udivdi3+0xfc>
800003a4:	ffe48a13          	addi	s4,s1,-2
800003a8:	00870733          	add	a4,a4,s0
800003ac:	40a704b3          	sub	s1,a4,a0
800003b0:	000b0593          	mv	a1,s6
800003b4:	00048513          	mv	a0,s1
800003b8:	540000ef          	jal	ra,800008f8 <__umodsi3>
800003bc:	00050913          	mv	s2,a0
800003c0:	000b0593          	mv	a1,s6
800003c4:	00048513          	mv	a0,s1
800003c8:	4e8000ef          	jal	ra,800008b0 <__udivsi3>
800003cc:	01099993          	slli	s3,s3,0x10
800003d0:	00050493          	mv	s1,a0
800003d4:	00050593          	mv	a1,a0
800003d8:	01091913          	slli	s2,s2,0x10
800003dc:	000b8513          	mv	a0,s7
800003e0:	0109d993          	srli	s3,s3,0x10
800003e4:	4a0000ef          	jal	ra,80000884 <__mulsi3>
800003e8:	013969b3          	or	s3,s2,s3
800003ec:	00048613          	mv	a2,s1
800003f0:	00a9fc63          	bgeu	s3,a0,80000408 <__udivdi3+0x158>
800003f4:	013409b3          	add	s3,s0,s3
800003f8:	fff48613          	addi	a2,s1,-1
800003fc:	0089e663          	bltu	s3,s0,80000408 <__udivdi3+0x158>
80000400:	00a9f463          	bgeu	s3,a0,80000408 <__udivdi3+0x158>
80000404:	ffe48613          	addi	a2,s1,-2
80000408:	010a1793          	slli	a5,s4,0x10
8000040c:	00c7e7b3          	or	a5,a5,a2
80000410:	00000a13          	li	s4,0
80000414:	1300006f          	j	80000544 <__udivdi3+0x294>
80000418:	010007b7          	lui	a5,0x1000
8000041c:	01000693          	li	a3,16
80000420:	eef66ce3          	bltu	a2,a5,80000318 <__udivdi3+0x68>
80000424:	01800693          	li	a3,24
80000428:	ef1ff06f          	j	80000318 <__udivdi3+0x68>
8000042c:	00068a13          	mv	s4,a3
80000430:	00061a63          	bnez	a2,80000444 <__udivdi3+0x194>
80000434:	00000593          	li	a1,0
80000438:	00100513          	li	a0,1
8000043c:	474000ef          	jal	ra,800008b0 <__udivsi3>
80000440:	00050413          	mv	s0,a0
80000444:	000107b7          	lui	a5,0x10
80000448:	12f47c63          	bgeu	s0,a5,80000580 <__udivdi3+0x2d0>
8000044c:	0ff00793          	li	a5,255
80000450:	0087f463          	bgeu	a5,s0,80000458 <__udivdi3+0x1a8>
80000454:	00800a13          	li	s4,8
80000458:	014457b3          	srl	a5,s0,s4
8000045c:	00f90933          	add	s2,s2,a5
80000460:	00094683          	lbu	a3,0(s2)
80000464:	02000613          	li	a2,32
80000468:	014686b3          	add	a3,a3,s4
8000046c:	40d60633          	sub	a2,a2,a3
80000470:	12061263          	bnez	a2,80000594 <__udivdi3+0x2e4>
80000474:	408484b3          	sub	s1,s1,s0
80000478:	00100a13          	li	s4,1
8000047c:	01045b13          	srli	s6,s0,0x10
80000480:	000b0593          	mv	a1,s6
80000484:	00048513          	mv	a0,s1
80000488:	470000ef          	jal	ra,800008f8 <__umodsi3>
8000048c:	00050913          	mv	s2,a0
80000490:	000b0593          	mv	a1,s6
80000494:	00048513          	mv	a0,s1
80000498:	01041b93          	slli	s7,s0,0x10
8000049c:	414000ef          	jal	ra,800008b0 <__udivsi3>
800004a0:	010bdb93          	srli	s7,s7,0x10
800004a4:	00050493          	mv	s1,a0
800004a8:	00050593          	mv	a1,a0
800004ac:	000b8513          	mv	a0,s7
800004b0:	3d4000ef          	jal	ra,80000884 <__mulsi3>
800004b4:	01091913          	slli	s2,s2,0x10
800004b8:	0109d713          	srli	a4,s3,0x10
800004bc:	00e96733          	or	a4,s2,a4
800004c0:	00048a93          	mv	s5,s1
800004c4:	00a77e63          	bgeu	a4,a0,800004e0 <__udivdi3+0x230>
800004c8:	00870733          	add	a4,a4,s0
800004cc:	fff48a93          	addi	s5,s1,-1
800004d0:	00876863          	bltu	a4,s0,800004e0 <__udivdi3+0x230>
800004d4:	00a77663          	bgeu	a4,a0,800004e0 <__udivdi3+0x230>
800004d8:	ffe48a93          	addi	s5,s1,-2
800004dc:	00870733          	add	a4,a4,s0
800004e0:	40a704b3          	sub	s1,a4,a0
800004e4:	000b0593          	mv	a1,s6
800004e8:	00048513          	mv	a0,s1
800004ec:	40c000ef          	jal	ra,800008f8 <__umodsi3>
800004f0:	00050913          	mv	s2,a0
800004f4:	000b0593          	mv	a1,s6
800004f8:	00048513          	mv	a0,s1
800004fc:	3b4000ef          	jal	ra,800008b0 <__udivsi3>
80000500:	01099993          	slli	s3,s3,0x10
80000504:	00050493          	mv	s1,a0
80000508:	00050593          	mv	a1,a0
8000050c:	01091913          	slli	s2,s2,0x10
80000510:	000b8513          	mv	a0,s7
80000514:	0109d993          	srli	s3,s3,0x10
80000518:	36c000ef          	jal	ra,80000884 <__mulsi3>
8000051c:	013969b3          	or	s3,s2,s3
80000520:	00048613          	mv	a2,s1
80000524:	00a9fc63          	bgeu	s3,a0,8000053c <__udivdi3+0x28c>
80000528:	013409b3          	add	s3,s0,s3
8000052c:	fff48613          	addi	a2,s1,-1
80000530:	0089e663          	bltu	s3,s0,8000053c <__udivdi3+0x28c>
80000534:	00a9f463          	bgeu	s3,a0,8000053c <__udivdi3+0x28c>
80000538:	ffe48613          	addi	a2,s1,-2
8000053c:	010a9793          	slli	a5,s5,0x10
80000540:	00c7e7b3          	or	a5,a5,a2
80000544:	00078513          	mv	a0,a5
80000548:	000a0593          	mv	a1,s4
8000054c:	02c12083          	lw	ra,44(sp)
80000550:	02812403          	lw	s0,40(sp)
80000554:	02412483          	lw	s1,36(sp)
80000558:	02012903          	lw	s2,32(sp)
8000055c:	01c12983          	lw	s3,28(sp)
80000560:	01812a03          	lw	s4,24(sp)
80000564:	01412a83          	lw	s5,20(sp)
80000568:	01012b03          	lw	s6,16(sp)
8000056c:	00c12b83          	lw	s7,12(sp)
80000570:	00812c03          	lw	s8,8(sp)
80000574:	00412c83          	lw	s9,4(sp)
80000578:	03010113          	addi	sp,sp,48
8000057c:	00008067          	ret
80000580:	010007b7          	lui	a5,0x1000
80000584:	01000a13          	li	s4,16
80000588:	ecf468e3          	bltu	s0,a5,80000458 <__udivdi3+0x1a8>
8000058c:	01800a13          	li	s4,24
80000590:	ec9ff06f          	j	80000458 <__udivdi3+0x1a8>
80000594:	00c41433          	sll	s0,s0,a2
80000598:	00d4da33          	srl	s4,s1,a3
8000059c:	00cb19b3          	sll	s3,s6,a2
800005a0:	00db56b3          	srl	a3,s6,a3
800005a4:	01045b13          	srli	s6,s0,0x10
800005a8:	00c494b3          	sll	s1,s1,a2
800005ac:	000b0593          	mv	a1,s6
800005b0:	000a0513          	mv	a0,s4
800005b4:	0096eab3          	or	s5,a3,s1
800005b8:	340000ef          	jal	ra,800008f8 <__umodsi3>
800005bc:	00050913          	mv	s2,a0
800005c0:	000b0593          	mv	a1,s6
800005c4:	000a0513          	mv	a0,s4
800005c8:	01041b93          	slli	s7,s0,0x10
800005cc:	2e4000ef          	jal	ra,800008b0 <__udivsi3>
800005d0:	010bdb93          	srli	s7,s7,0x10
800005d4:	00050493          	mv	s1,a0
800005d8:	00050593          	mv	a1,a0
800005dc:	000b8513          	mv	a0,s7
800005e0:	2a4000ef          	jal	ra,80000884 <__mulsi3>
800005e4:	01091913          	slli	s2,s2,0x10
800005e8:	010ad713          	srli	a4,s5,0x10
800005ec:	00e96733          	or	a4,s2,a4
800005f0:	00048a13          	mv	s4,s1
800005f4:	00a77e63          	bgeu	a4,a0,80000610 <__udivdi3+0x360>
800005f8:	00870733          	add	a4,a4,s0
800005fc:	fff48a13          	addi	s4,s1,-1
80000600:	00876863          	bltu	a4,s0,80000610 <__udivdi3+0x360>
80000604:	00a77663          	bgeu	a4,a0,80000610 <__udivdi3+0x360>
80000608:	ffe48a13          	addi	s4,s1,-2
8000060c:	00870733          	add	a4,a4,s0
80000610:	40a704b3          	sub	s1,a4,a0
80000614:	000b0593          	mv	a1,s6
80000618:	00048513          	mv	a0,s1
8000061c:	2dc000ef          	jal	ra,800008f8 <__umodsi3>
80000620:	00050913          	mv	s2,a0
80000624:	000b0593          	mv	a1,s6
80000628:	00048513          	mv	a0,s1
8000062c:	284000ef          	jal	ra,800008b0 <__udivsi3>
80000630:	00050493          	mv	s1,a0
80000634:	00050593          	mv	a1,a0
80000638:	000b8513          	mv	a0,s7
8000063c:	248000ef          	jal	ra,80000884 <__mulsi3>
80000640:	010a9693          	slli	a3,s5,0x10
80000644:	01091913          	slli	s2,s2,0x10
80000648:	0106d693          	srli	a3,a3,0x10
8000064c:	00d967b3          	or	a5,s2,a3
80000650:	00048713          	mv	a4,s1
80000654:	00a7fe63          	bgeu	a5,a0,80000670 <__udivdi3+0x3c0>
80000658:	008787b3          	add	a5,a5,s0
8000065c:	fff48713          	addi	a4,s1,-1
80000660:	0087e863          	bltu	a5,s0,80000670 <__udivdi3+0x3c0>
80000664:	00a7f663          	bgeu	a5,a0,80000670 <__udivdi3+0x3c0>
80000668:	ffe48713          	addi	a4,s1,-2
8000066c:	008787b3          	add	a5,a5,s0
80000670:	010a1a13          	slli	s4,s4,0x10
80000674:	40a784b3          	sub	s1,a5,a0
80000678:	00ea6a33          	or	s4,s4,a4
8000067c:	e01ff06f          	j	8000047c <__udivdi3+0x1cc>
80000680:	1ed5ec63          	bltu	a1,a3,80000878 <__udivdi3+0x5c8>
80000684:	000107b7          	lui	a5,0x10
80000688:	04f6f463          	bgeu	a3,a5,800006d0 <__udivdi3+0x420>
8000068c:	0ff00593          	li	a1,255
80000690:	00d5b533          	sltu	a0,a1,a3
80000694:	00351513          	slli	a0,a0,0x3
80000698:	00a6d733          	srl	a4,a3,a0
8000069c:	00005797          	auipc	a5,0x5
800006a0:	29878793          	addi	a5,a5,664 # 80005934 <__devconfig_end>
800006a4:	00e787b3          	add	a5,a5,a4
800006a8:	0007c583          	lbu	a1,0(a5)
800006ac:	02000a13          	li	s4,32
800006b0:	00a585b3          	add	a1,a1,a0
800006b4:	40ba0a33          	sub	s4,s4,a1
800006b8:	020a1663          	bnez	s4,800006e4 <__udivdi3+0x434>
800006bc:	00100793          	li	a5,1
800006c0:	e896e2e3          	bltu	a3,s1,80000544 <__udivdi3+0x294>
800006c4:	00cb3633          	sltu	a2,s6,a2
800006c8:	00164793          	xori	a5,a2,1
800006cc:	e79ff06f          	j	80000544 <__udivdi3+0x294>
800006d0:	010007b7          	lui	a5,0x1000
800006d4:	01000513          	li	a0,16
800006d8:	fcf6e0e3          	bltu	a3,a5,80000698 <__udivdi3+0x3e8>
800006dc:	01800513          	li	a0,24
800006e0:	fb9ff06f          	j	80000698 <__udivdi3+0x3e8>
800006e4:	00b65ab3          	srl	s5,a2,a1
800006e8:	014696b3          	sll	a3,a3,s4
800006ec:	00daeab3          	or	s5,s5,a3
800006f0:	00b4d933          	srl	s2,s1,a1
800006f4:	014497b3          	sll	a5,s1,s4
800006f8:	00bb55b3          	srl	a1,s6,a1
800006fc:	010adb93          	srli	s7,s5,0x10
80000700:	00f5e4b3          	or	s1,a1,a5
80000704:	00090513          	mv	a0,s2
80000708:	000b8593          	mv	a1,s7
8000070c:	014619b3          	sll	s3,a2,s4
80000710:	1e8000ef          	jal	ra,800008f8 <__umodsi3>
80000714:	00050413          	mv	s0,a0
80000718:	000b8593          	mv	a1,s7
8000071c:	00090513          	mv	a0,s2
80000720:	010a9c13          	slli	s8,s5,0x10
80000724:	18c000ef          	jal	ra,800008b0 <__udivsi3>
80000728:	010c5c13          	srli	s8,s8,0x10
8000072c:	00050913          	mv	s2,a0
80000730:	00050593          	mv	a1,a0
80000734:	000c0513          	mv	a0,s8
80000738:	14c000ef          	jal	ra,80000884 <__mulsi3>
8000073c:	01041413          	slli	s0,s0,0x10
80000740:	0104d713          	srli	a4,s1,0x10
80000744:	00e46733          	or	a4,s0,a4
80000748:	00090c93          	mv	s9,s2
8000074c:	00a77e63          	bgeu	a4,a0,80000768 <__udivdi3+0x4b8>
80000750:	01570733          	add	a4,a4,s5
80000754:	fff90c93          	addi	s9,s2,-1
80000758:	01576863          	bltu	a4,s5,80000768 <__udivdi3+0x4b8>
8000075c:	00a77663          	bgeu	a4,a0,80000768 <__udivdi3+0x4b8>
80000760:	ffe90c93          	addi	s9,s2,-2
80000764:	01570733          	add	a4,a4,s5
80000768:	40a70933          	sub	s2,a4,a0
8000076c:	000b8593          	mv	a1,s7
80000770:	00090513          	mv	a0,s2
80000774:	184000ef          	jal	ra,800008f8 <__umodsi3>
80000778:	00050413          	mv	s0,a0
8000077c:	000b8593          	mv	a1,s7
80000780:	00090513          	mv	a0,s2
80000784:	12c000ef          	jal	ra,800008b0 <__udivsi3>
80000788:	00050913          	mv	s2,a0
8000078c:	00050593          	mv	a1,a0
80000790:	000c0513          	mv	a0,s8
80000794:	0f0000ef          	jal	ra,80000884 <__mulsi3>
80000798:	01049793          	slli	a5,s1,0x10
8000079c:	01041413          	slli	s0,s0,0x10
800007a0:	0107d793          	srli	a5,a5,0x10
800007a4:	00f46733          	or	a4,s0,a5
800007a8:	00090613          	mv	a2,s2
800007ac:	00a77e63          	bgeu	a4,a0,800007c8 <__udivdi3+0x518>
800007b0:	01570733          	add	a4,a4,s5
800007b4:	fff90613          	addi	a2,s2,-1
800007b8:	01576863          	bltu	a4,s5,800007c8 <__udivdi3+0x518>
800007bc:	00a77663          	bgeu	a4,a0,800007c8 <__udivdi3+0x518>
800007c0:	ffe90613          	addi	a2,s2,-2
800007c4:	01570733          	add	a4,a4,s5
800007c8:	010c9793          	slli	a5,s9,0x10
800007cc:	00010e37          	lui	t3,0x10
800007d0:	00c7e7b3          	or	a5,a5,a2
800007d4:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007d8:	0107f333          	and	t1,a5,a6
800007dc:	0109f833          	and	a6,s3,a6
800007e0:	40a70733          	sub	a4,a4,a0
800007e4:	0107de93          	srli	t4,a5,0x10
800007e8:	0109d993          	srli	s3,s3,0x10
800007ec:	00030513          	mv	a0,t1
800007f0:	00080593          	mv	a1,a6
800007f4:	090000ef          	jal	ra,80000884 <__mulsi3>
800007f8:	00050893          	mv	a7,a0
800007fc:	00098593          	mv	a1,s3
80000800:	00030513          	mv	a0,t1
80000804:	080000ef          	jal	ra,80000884 <__mulsi3>
80000808:	00050313          	mv	t1,a0
8000080c:	00080593          	mv	a1,a6
80000810:	000e8513          	mv	a0,t4
80000814:	070000ef          	jal	ra,80000884 <__mulsi3>
80000818:	00050813          	mv	a6,a0
8000081c:	00098593          	mv	a1,s3
80000820:	000e8513          	mv	a0,t4
80000824:	060000ef          	jal	ra,80000884 <__mulsi3>
80000828:	0108d693          	srli	a3,a7,0x10
8000082c:	01030333          	add	t1,t1,a6
80000830:	006686b3          	add	a3,a3,t1
80000834:	0106f463          	bgeu	a3,a6,8000083c <__udivdi3+0x58c>
80000838:	01c50533          	add	a0,a0,t3
8000083c:	0106d613          	srli	a2,a3,0x10
80000840:	00a60533          	add	a0,a2,a0
80000844:	02a76663          	bltu	a4,a0,80000870 <__udivdi3+0x5c0>
80000848:	bca714e3          	bne	a4,a0,80000410 <__udivdi3+0x160>
8000084c:	00010737          	lui	a4,0x10
80000850:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000854:	00e6f6b3          	and	a3,a3,a4
80000858:	01069693          	slli	a3,a3,0x10
8000085c:	00e8f8b3          	and	a7,a7,a4
80000860:	014b1633          	sll	a2,s6,s4
80000864:	011686b3          	add	a3,a3,a7
80000868:	00000a13          	li	s4,0
8000086c:	ccd67ce3          	bgeu	a2,a3,80000544 <__udivdi3+0x294>
80000870:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
80000874:	b9dff06f          	j	80000410 <__udivdi3+0x160>
80000878:	00000a13          	li	s4,0
8000087c:	00000793          	li	a5,0
80000880:	cc5ff06f          	j	80000544 <__udivdi3+0x294>

80000884 <__mulsi3>:
80000884:	00050613          	mv	a2,a0
80000888:	00000513          	li	a0,0
8000088c:	0015f693          	andi	a3,a1,1
80000890:	00068463          	beqz	a3,80000898 <__mulsi3+0x14>
80000894:	00c50533          	add	a0,a0,a2
80000898:	0015d593          	srli	a1,a1,0x1
8000089c:	00161613          	slli	a2,a2,0x1
800008a0:	fe0596e3          	bnez	a1,8000088c <__mulsi3+0x8>
800008a4:	00008067          	ret

800008a8 <__divsi3>:
800008a8:	06054063          	bltz	a0,80000908 <__umodsi3+0x10>
800008ac:	0605c663          	bltz	a1,80000918 <__umodsi3+0x20>

800008b0 <__udivsi3>:
800008b0:	00058613          	mv	a2,a1
800008b4:	00050593          	mv	a1,a0
800008b8:	fff00513          	li	a0,-1
800008bc:	02060c63          	beqz	a2,800008f4 <__udivsi3+0x44>
800008c0:	00100693          	li	a3,1
800008c4:	00b67a63          	bgeu	a2,a1,800008d8 <__udivsi3+0x28>
800008c8:	00c05863          	blez	a2,800008d8 <__udivsi3+0x28>
800008cc:	00161613          	slli	a2,a2,0x1
800008d0:	00169693          	slli	a3,a3,0x1
800008d4:	feb66ae3          	bltu	a2,a1,800008c8 <__udivsi3+0x18>
800008d8:	00000513          	li	a0,0
800008dc:	00c5e663          	bltu	a1,a2,800008e8 <__udivsi3+0x38>
800008e0:	40c585b3          	sub	a1,a1,a2
800008e4:	00d56533          	or	a0,a0,a3
800008e8:	0016d693          	srli	a3,a3,0x1
800008ec:	00165613          	srli	a2,a2,0x1
800008f0:	fe0696e3          	bnez	a3,800008dc <__udivsi3+0x2c>
800008f4:	00008067          	ret

800008f8 <__umodsi3>:
800008f8:	00008293          	mv	t0,ra
800008fc:	fb5ff0ef          	jal	ra,800008b0 <__udivsi3>
80000900:	00058513          	mv	a0,a1
80000904:	00028067          	jr	t0
80000908:	40a00533          	neg	a0,a0
8000090c:	0005d863          	bgez	a1,8000091c <__umodsi3+0x24>
80000910:	40b005b3          	neg	a1,a1
80000914:	f9dff06f          	j	800008b0 <__udivsi3>
80000918:	40b005b3          	neg	a1,a1
8000091c:	00008293          	mv	t0,ra
80000920:	f91ff0ef          	jal	ra,800008b0 <__udivsi3>
80000924:	40a00533          	neg	a0,a0
80000928:	00028067          	jr	t0

8000092c <__modsi3>:
8000092c:	00008293          	mv	t0,ra
80000930:	0005ca63          	bltz	a1,80000944 <__modsi3+0x18>
80000934:	00054c63          	bltz	a0,8000094c <__modsi3+0x20>
80000938:	f79ff0ef          	jal	ra,800008b0 <__udivsi3>
8000093c:	00058513          	mv	a0,a1
80000940:	00028067          	jr	t0
80000944:	40b005b3          	neg	a1,a1
80000948:	fe0558e3          	bgez	a0,80000938 <__modsi3+0xc>
8000094c:	40a00533          	neg	a0,a0
80000950:	f61ff0ef          	jal	ra,800008b0 <__udivsi3>
80000954:	40b00533          	neg	a0,a1
80000958:	00028067          	jr	t0

8000095c <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
8000095c:	00008067          	ret

80000960 <z_zassert.constprop.3>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000960:	fd010113          	addi	sp,sp,-48
80000964:	00112e23          	sw	ra,28(sp)
80000968:	03012423          	sw	a6,40(sp)
8000096c:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000970:	04051863          	bnez	a0,800009c0 <z_zassert.constprop.3+0x60>
80000974:	00068613          	mv	a2,a3
80000978:	00058713          	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000097c:	800066b7          	lui	a3,0x80006
80000980:	800065b7          	lui	a1,0x80006
80000984:	80006537          	lui	a0,0x80006
		va_start(vargs, msg);
80000988:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000098c:	a3468693          	addi	a3,a3,-1484 # 80005a34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a35>
80000990:	b4058593          	addi	a1,a1,-1216 # 80005b40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b41>
80000994:	b6c50513          	addi	a0,a0,-1172 # 80005b6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b6d>
		va_start(vargs, msg);
80000998:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000099c:	23c010ef          	jal	ra,80001bd8 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
800009a0:	00c12583          	lw	a1,12(sp)
800009a4:	80006537          	lui	a0,0x80006
800009a8:	be850513          	addi	a0,a0,-1048 # 80005be8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005be9>
800009ac:	1fc010ef          	jal	ra,80001ba8 <vprintk>
		printk("\n");
800009b0:	80006537          	lui	a0,0x80006
800009b4:	ce850513          	addi	a0,a0,-792 # 80005ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ce9>
800009b8:	220010ef          	jal	ra,80001bd8 <printk>
		va_end(vargs);
		ztest_test_fail();
800009bc:	1a9010ef          	jal	ra,80002364 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
800009c0:	01c12083          	lw	ra,28(sp)
800009c4:	03010113          	addi	sp,sp,48
800009c8:	00008067          	ret

800009cc <test_send>:

	k_sem_init(&sync_sema, 0, 1);
}

void test_send(void *p1, void *p2, void *p3)
{
800009cc:	fc010113          	addi	sp,sp,-64
800009d0:	02812c23          	sw	s0,56(sp)
	(void)memset(&mmsg, 0, sizeof(mmsg));
800009d4:	02c00613          	li	a2,44
{
800009d8:	00050413          	mv	s0,a0
	(void)memset(&mmsg, 0, sizeof(mmsg));
800009dc:	00000593          	li	a1,0
800009e0:	00410513          	addi	a0,sp,4
{
800009e4:	02112e23          	sw	ra,60(sp)
	(void)memset(&mmsg, 0, sizeof(mmsg));
800009e8:	05d010ef          	jal	ra,80002244 <memset>
	switch (info_type) {
800009ec:	800067b7          	lui	a5,0x80006
800009f0:	6987a783          	lw	a5,1688(a5) # 80006698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006699>
800009f4:	02079063          	bnez	a5,80000a14 <test_send+0x48>
			k_mbox_put(pmbox, &mmsg, K_NO_WAIT);
800009f8:	00000613          	li	a2,0
800009fc:	00410593          	addi	a1,sp,4
80000a00:	00040513          	mv	a0,s0
		mmsg.info = PUT_GET_NULL;
80000a04:	00012623          	sw	zero,12(sp)
		mmsg.size = 0;
80000a08:	00012423          	sw	zero,8(sp)
		mmsg.tx_data = NULL;
80000a0c:	00012823          	sw	zero,16(sp)
			k_mbox_put(pmbox, &mmsg, K_NO_WAIT);
80000a10:	328020ef          	jal	ra,80002d38 <k_mbox_put>
	msg_sender((struct k_mbox *)p1, K_NO_WAIT);
}
80000a14:	03c12083          	lw	ra,60(sp)
80000a18:	03812403          	lw	s0,56(sp)
80000a1c:	04010113          	addi	sp,sp,64
80000a20:	00008067          	ret

80000a24 <test_send_un>:
	msg_receiver(&mbox, K_ANY, 2);
	k_thread_abort(tid);
}

void test_send_un(void *p1, void *p2, void *p3)
{
80000a24:	fc010113          	addi	sp,sp,-64
80000a28:	02812c23          	sw	s0,56(sp)
80000a2c:	00050413          	mv	s0,a0
	TC_PRINT("Sender UNLIMITED\n");
80000a30:	80006537          	lui	a0,0x80006
80000a34:	b2c50513          	addi	a0,a0,-1236 # 80005b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b2d>
{
80000a38:	02112e23          	sw	ra,60(sp)
	TC_PRINT("Sender UNLIMITED\n");
80000a3c:	19c010ef          	jal	ra,80001bd8 <printk>
	(void)memset(&mmsg, 0, sizeof(mmsg));
80000a40:	02c00613          	li	a2,44
80000a44:	00000593          	li	a1,0
80000a48:	00410513          	addi	a0,sp,4
80000a4c:	7f8010ef          	jal	ra,80002244 <memset>
	switch (info_type) {
80000a50:	800067b7          	lui	a5,0x80006
80000a54:	6987a783          	lw	a5,1688(a5) # 80006698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006699>
80000a58:	02079063          	bnez	a5,80000a78 <test_send_un+0x54>
			k_mbox_put(pmbox, &mmsg, K_FOREVER);
80000a5c:	fff00613          	li	a2,-1
80000a60:	00410593          	addi	a1,sp,4
80000a64:	00040513          	mv	a0,s0
		mmsg.info = PUT_GET_NULL;
80000a68:	00012623          	sw	zero,12(sp)
		mmsg.size = 0;
80000a6c:	00012423          	sw	zero,8(sp)
		mmsg.tx_data = NULL;
80000a70:	00012823          	sw	zero,16(sp)
			k_mbox_put(pmbox, &mmsg, K_FOREVER);
80000a74:	2c4020ef          	jal	ra,80002d38 <k_mbox_put>
	msg_sender((struct k_mbox *)p1, K_FOREVER);
}
80000a78:	03c12083          	lw	ra,60(sp)
80000a7c:	03812403          	lw	s0,56(sp)
80000a80:	04010113          	addi	sp,sp,64
80000a84:	00008067          	ret

80000a88 <msg_receiver_unlimited>:

/* Receive message from thread tid1 */
void msg_receiver_unlimited(void)
{
80000a88:	f7010113          	addi	sp,sp,-144
80000a8c:	08812423          	sw	s0,136(sp)
	info_type = PUT_GET_NULL;
80000a90:	80006437          	lui	s0,0x80006
{
80000a94:	08112623          	sw	ra,140(sp)
80000a98:	08912223          	sw	s1,132(sp)
	info_type = PUT_GET_NULL;
80000a9c:	69840413          	addi	s0,s0,1688 # 80006698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006699>
80000aa0:	00042023          	sw	zero,0(s0)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000aa4:	231030ef          	jal	ra,800044d4 <z_impl_k_current_get>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000aa8:	800064b7          	lui	s1,0x80006
80000aac:	800016b7          	lui	a3,0x80001
80000ab0:	800075b7          	lui	a1,0x80007
80000ab4:	80006537          	lui	a0,0x80006
80000ab8:	00000793          	li	a5,0
80000abc:	79048713          	addi	a4,s1,1936 # 80006790 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006791>
80000ac0:	00012223          	sw	zero,4(sp)
80000ac4:	00012023          	sw	zero,0(sp)
80000ac8:	00000893          	li	a7,0
80000acc:	00000813          	li	a6,0
80000ad0:	a2468693          	addi	a3,a3,-1500 # 80000a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a25>
80000ad4:	20000613          	li	a2,512
80000ad8:	9b058593          	addi	a1,a1,-1616 # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
80000adc:	7b450513          	addi	a0,a0,1972 # 800067b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067b5>
80000ae0:	1fc040ef          	jal	ra,80004cdc <z_impl_k_thread_create>
	switch (info_type) {
80000ae4:	00042703          	lw	a4,0(s0)

	receiver_tid = k_current_get();
	tid1 = k_thread_create(&tdata, tstack, STACK_SIZE,
80000ae8:	800067b7          	lui	a5,0x80006
80000aec:	6aa7a023          	sw	a0,1696(a5) # 800066a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a1>
	switch (info_type) {
80000af0:	6a078413          	addi	s0,a5,1696
80000af4:	04071863          	bnez	a4,80000b44 <msg_receiver_unlimited+0xbc>
		mmsg.size = sizeof(rxdata);
80000af8:	04000793          	li	a5,64
		mmsg.rx_source_thread = thd_id;
80000afc:	02a12823          	sw	a0,48(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000b00:	fff00693          	li	a3,-1
80000b04:	04010613          	addi	a2,sp,64
80000b08:	01410593          	addi	a1,sp,20
80000b0c:	79048513          	addi	a0,s1,1936
		mmsg.size = sizeof(rxdata);
80000b10:	00f12c23          	sw	a5,24(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000b14:	27c020ef          	jal	ra,80002d90 <k_mbox_get>
80000b18:	800067b7          	lui	a5,0x80006
80000b1c:	80006737          	lui	a4,0x80006
80000b20:	80006637          	lui	a2,0x80006
80000b24:	800065b7          	lui	a1,0x80006
80000b28:	be878793          	addi	a5,a5,-1048 # 80005be8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005be9>
80000b2c:	a3470713          	addi	a4,a4,-1484 # 80005a34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a35>
80000b30:	04300693          	li	a3,67
80000b34:	b4060613          	addi	a2,a2,-1216 # 80005b40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b41>
80000b38:	a4458593          	addi	a1,a1,-1468 # 80005a44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a45>
80000b3c:	00153513          	seqz	a0,a0
80000b40:	e21ff0ef          	jal	ra,80000960 <z_zassert.constprop.3>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000b44:	00042503          	lw	a0,0(s0)
80000b48:	338040ef          	jal	ra,80004e80 <z_impl_k_thread_abort>
			      test_send_un, &mbox, NULL, NULL,
			      K_PRIO_PREEMPT(0), 0, K_NO_WAIT);

	msg_receiver(&mbox, tid1, K_FOREVER);
	k_thread_abort(tid1);
}
80000b4c:	08c12083          	lw	ra,140(sp)
80000b50:	08812403          	lw	s0,136(sp)
80000b54:	08412483          	lw	s1,132(sp)
80000b58:	09010113          	addi	sp,sp,144
80000b5c:	00008067          	ret

80000b60 <test_msg_receiver>:
{
80000b60:	f6010113          	addi	sp,sp,-160
80000b64:	08812c23          	sw	s0,152(sp)
80000b68:	08912a23          	sw	s1,148(sp)
	info_type = PUT_GET_NULL;
80000b6c:	80006437          	lui	s0,0x80006
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000b70:	800064b7          	lui	s1,0x80006
{
80000b74:	08112e23          	sw	ra,156(sp)
80000b78:	09212823          	sw	s2,144(sp)
80000b7c:	09312623          	sw	s3,140(sp)
80000b80:	09412423          	sw	s4,136(sp)
80000b84:	09512223          	sw	s5,132(sp)
	info_type = PUT_GET_NULL;
80000b88:	69840413          	addi	s0,s0,1688 # 80006698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006699>
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000b8c:	00000693          	li	a3,0
80000b90:	04010613          	addi	a2,sp,64
80000b94:	01410593          	addi	a1,sp,20
		mmsg.size = sizeof(rxdata);
80000b98:	04000a93          	li	s5,64
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000b9c:	79048513          	addi	a0,s1,1936 # 80006790 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006791>
	info_type = PUT_GET_NULL;
80000ba0:	00042023          	sw	zero,0(s0)
		mmsg.size = sizeof(rxdata);
80000ba4:	01512c23          	sw	s5,24(sp)
		mmsg.rx_source_thread = thd_id;
80000ba8:	02012823          	sw	zero,48(sp)
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000bac:	1e4020ef          	jal	ra,80002d90 <k_mbox_get>
80000bb0:	800069b7          	lui	s3,0x80006
80000bb4:	80006a37          	lui	s4,0x80006
80000bb8:	80006937          	lui	s2,0x80006
80000bbc:	800065b7          	lui	a1,0x80006
80000bc0:	be8a0793          	addi	a5,s4,-1048 # 80005be8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005be9>
80000bc4:	a3498713          	addi	a4,s3,-1484 # 80005a34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a35>
80000bc8:	04600693          	li	a3,70
80000bcc:	b4090613          	addi	a2,s2,-1216 # 80005b40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b41>
80000bd0:	ab858593          	addi	a1,a1,-1352 # 80005ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ab9>
80000bd4:	00a03533          	snez	a0,a0
80000bd8:	d89ff0ef          	jal	ra,80000960 <z_zassert.constprop.3>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000bdc:	800016b7          	lui	a3,0x80001
80000be0:	800075b7          	lui	a1,0x80007
80000be4:	80006537          	lui	a0,0x80006
80000be8:	00000793          	li	a5,0
80000bec:	79048713          	addi	a4,s1,1936
80000bf0:	00012223          	sw	zero,4(sp)
80000bf4:	00012023          	sw	zero,0(sp)
80000bf8:	00000893          	li	a7,0
80000bfc:	00000813          	li	a6,0
80000c00:	9cc68693          	addi	a3,a3,-1588 # 800009cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009cd>
80000c04:	20000613          	li	a2,512
80000c08:	9b058593          	addi	a1,a1,-1616 # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
80000c0c:	7b450513          	addi	a0,a0,1972 # 800067b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067b5>
80000c10:	0cc040ef          	jal	ra,80004cdc <z_impl_k_thread_create>
	switch (info_type) {
80000c14:	00042703          	lw	a4,0(s0)
	tid = k_thread_create(&tdata, tstack, STACK_SIZE,
80000c18:	800067b7          	lui	a5,0x80006
80000c1c:	68a7ae23          	sw	a0,1692(a5) # 8000669c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000669d>
	switch (info_type) {
80000c20:	69c78413          	addi	s0,a5,1692
80000c24:	04071063          	bnez	a4,80000c64 <test_msg_receiver+0x104>
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000c28:	00200693          	li	a3,2
80000c2c:	04010613          	addi	a2,sp,64
80000c30:	01410593          	addi	a1,sp,20
80000c34:	79048513          	addi	a0,s1,1936
		mmsg.size = sizeof(rxdata);
80000c38:	01512c23          	sw	s5,24(sp)
		mmsg.rx_source_thread = thd_id;
80000c3c:	02012823          	sw	zero,48(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000c40:	150020ef          	jal	ra,80002d90 <k_mbox_get>
80000c44:	800065b7          	lui	a1,0x80006
80000c48:	be8a0793          	addi	a5,s4,-1048
80000c4c:	a3498713          	addi	a4,s3,-1484
80000c50:	04900693          	li	a3,73
80000c54:	b4090613          	addi	a2,s2,-1216
80000c58:	af458593          	addi	a1,a1,-1292 # 80005af4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af5>
80000c5c:	00153513          	seqz	a0,a0
80000c60:	d01ff0ef          	jal	ra,80000960 <z_zassert.constprop.3>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000c64:	00042503          	lw	a0,0(s0)
80000c68:	218040ef          	jal	ra,80004e80 <z_impl_k_thread_abort>
}
80000c6c:	09c12083          	lw	ra,156(sp)
80000c70:	09812403          	lw	s0,152(sp)
80000c74:	09412483          	lw	s1,148(sp)
80000c78:	09012903          	lw	s2,144(sp)
80000c7c:	08c12983          	lw	s3,140(sp)
80000c80:	08812a03          	lw	s4,136(sp)
80000c84:	08412a83          	lw	s5,132(sp)
80000c88:	0a010113          	addi	sp,sp,160
80000c8c:	00008067          	ret

80000c90 <test_main>:
	k_mbox_init(&mbox);
80000c90:	80006537          	lui	a0,0x80006

/*test case main entry*/
void test_main(void)
{
80000c94:	ff010113          	addi	sp,sp,-16
	k_mbox_init(&mbox);
80000c98:	79050513          	addi	a0,a0,1936 # 80006790 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006791>
{
80000c9c:	00112623          	sw	ra,12(sp)
	k_mbox_init(&mbox);
80000ca0:	07c020ef          	jal	ra,80002d1c <k_mbox_init>

K_SYSCALL_DECLARE2(K_SYSCALL_K_MUTEX_LOCK, k_mutex_lock, int, struct k_mutex *, mutex, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000ca4:	80006537          	lui	a0,0x80006
80000ca8:	00000593          	li	a1,0
80000cac:	7a450513          	addi	a0,a0,1956 # 800067a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067a5>
80000cb0:	00100613          	li	a2,1
80000cb4:	02d030ef          	jal	ra,800044e0 <z_impl_k_sem_init>
	test_mbox_init();
	ztest_test_suite(test_mbox,
			 ztest_unit_test(test_msg_receiver),
			 ztest_unit_test(msg_receiver_unlimited));
	ztest_run_test_suite(test_mbox);
}
80000cb8:	00c12083          	lw	ra,12(sp)
	ztest_run_test_suite(test_mbox);
80000cbc:	800065b7          	lui	a1,0x80006
80000cc0:	80006537          	lui	a0,0x80006
80000cc4:	58c58593          	addi	a1,a1,1420 # 8000658c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000658d>
80000cc8:	aac50513          	addi	a0,a0,-1364 # 80005aac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aad>
}
80000ccc:	01010113          	addi	sp,sp,16
	ztest_run_test_suite(test_mbox);
80000cd0:	6c40106f          	j	80002394 <z_ztest_run_test_suite>

80000cd4 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000cd4:	ff010113          	addi	sp,sp,-16
80000cd8:	00112623          	sw	ra,12(sp)
80000cdc:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000ce0:	00600793          	li	a5,6
80000ce4:	02f50463          	beq	a0,a5,80000d0c <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000ce8:	521030ef          	jal	ra,80004a08 <k_is_in_isr>
80000cec:	02050463          	beqz	a0,80000d14 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000cf0:	519030ef          	jal	ra,80004a08 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000cf4:	04051663          	bnez	a0,80000d40 <z_SysFatalErrorHandler+0x6c>
80000cf8:	800065b7          	lui	a1,0x80006
80000cfc:	e4458593          	addi	a1,a1,-444 # 80005e44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e45>
80000d00:	80006537          	lui	a0,0x80006
80000d04:	e5850513          	addi	a0,a0,-424 # 80005e58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e59>
80000d08:	6d1000ef          	jal	ra,80001bd8 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000d0c:	73d000ef          	jal	ra,80001c48 <k_cpu_idle>
80000d10:	ffdff06f          	j	80000d0c <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000d14:	505030ef          	jal	ra,80004a18 <z_is_thread_essential>
80000d18:	fc051ce3          	bnez	a0,80000cf0 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000d1c:	80007437          	lui	s0,0x80007
80000d20:	98440413          	addi	s0,s0,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80000d24:	00842583          	lw	a1,8(s0)
80000d28:	80006537          	lui	a0,0x80006
80000d2c:	e7850513          	addi	a0,a0,-392 # 80005e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e79>
80000d30:	6a9000ef          	jal	ra,80001bd8 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000d34:	00842503          	lw	a0,8(s0)
80000d38:	148040ef          	jal	ra,80004e80 <z_impl_k_thread_abort>
80000d3c:	fd1ff06f          	j	80000d0c <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000d40:	800065b7          	lui	a1,0x80006
80000d44:	e4058593          	addi	a1,a1,-448 # 80005e40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e41>
80000d48:	fb9ff06f          	j	80000d00 <z_SysFatalErrorHandler+0x2c>

80000d4c <z_NanoFatalErrorHandler>:
{
80000d4c:	fb010113          	addi	sp,sp,-80
80000d50:	04812423          	sw	s0,72(sp)
80000d54:	04912223          	sw	s1,68(sp)
80000d58:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000d5c:	00600793          	li	a5,6
{
80000d60:	00050493          	mv	s1,a0
80000d64:	00058413          	mv	s0,a1
	switch (reason) {
80000d68:	0ea7e063          	bltu	a5,a0,80000e48 <z_NanoFatalErrorHandler+0xfc>
80000d6c:	80006737          	lui	a4,0x80006
80000d70:	00251793          	slli	a5,a0,0x2
80000d74:	b9470713          	addi	a4,a4,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80000d78:	00e787b3          	add	a5,a5,a4
80000d7c:	0007a783          	lw	a5,0(a5)
80000d80:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000d84:	80006537          	lui	a0,0x80006
80000d88:	cc450513          	addi	a0,a0,-828 # 80005cc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cc5>
		printk("***** Kernel OOPS! *****\n");
80000d8c:	64d000ef          	jal	ra,80001bd8 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000d90:	744030ef          	jal	ra,800044d4 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000d94:	04442783          	lw	a5,68(s0)
80000d98:	01042883          	lw	a7,16(s0)
80000d9c:	00c42803          	lw	a6,12(s0)
80000da0:	02f12823          	sw	a5,48(sp)
80000da4:	04042783          	lw	a5,64(s0)
80000da8:	00442703          	lw	a4,4(s0)
80000dac:	00042683          	lw	a3,0(s0)
80000db0:	02f12623          	sw	a5,44(sp)
80000db4:	03c42783          	lw	a5,60(s0)
80000db8:	04842603          	lw	a2,72(s0)
80000dbc:	00050593          	mv	a1,a0
80000dc0:	02f12423          	sw	a5,40(sp)
80000dc4:	03842783          	lw	a5,56(s0)
80000dc8:	80006537          	lui	a0,0x80006
80000dcc:	d4850513          	addi	a0,a0,-696 # 80005d48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d49>
80000dd0:	02f12223          	sw	a5,36(sp)
80000dd4:	03442783          	lw	a5,52(s0)
80000dd8:	02f12023          	sw	a5,32(sp)
80000ddc:	03042783          	lw	a5,48(s0)
80000de0:	00f12e23          	sw	a5,28(sp)
80000de4:	02c42783          	lw	a5,44(s0)
80000de8:	00f12c23          	sw	a5,24(sp)
80000dec:	02842783          	lw	a5,40(s0)
80000df0:	00f12a23          	sw	a5,20(sp)
80000df4:	02442783          	lw	a5,36(s0)
80000df8:	00f12823          	sw	a5,16(sp)
80000dfc:	02042783          	lw	a5,32(s0)
80000e00:	00f12623          	sw	a5,12(sp)
80000e04:	01c42783          	lw	a5,28(s0)
80000e08:	00f12423          	sw	a5,8(sp)
80000e0c:	01842783          	lw	a5,24(s0)
80000e10:	00f12223          	sw	a5,4(sp)
80000e14:	01442783          	lw	a5,20(s0)
80000e18:	00f12023          	sw	a5,0(sp)
80000e1c:	00842783          	lw	a5,8(s0)
80000e20:	5b9000ef          	jal	ra,80001bd8 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000e24:	00040593          	mv	a1,s0
80000e28:	00048513          	mv	a0,s1
80000e2c:	ea9ff0ef          	jal	ra,80000cd4 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000e30:	80006537          	lui	a0,0x80006
80000e34:	cec50513          	addi	a0,a0,-788 # 80005cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ced>
80000e38:	f55ff06f          	j	80000d8c <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80000e3c:	80006537          	lui	a0,0x80006
80000e40:	d0850513          	addi	a0,a0,-760 # 80005d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d09>
80000e44:	f49ff06f          	j	80000d8c <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000e48:	80006537          	lui	a0,0x80006
80000e4c:	00048593          	mv	a1,s1
80000e50:	d2450513          	addi	a0,a0,-732 # 80005d24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d25>
80000e54:	585000ef          	jal	ra,80001bd8 <printk>
		break;
80000e58:	f39ff06f          	j	80000d90 <z_NanoFatalErrorHandler+0x44>

80000e5c <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000e5c:	ff010113          	addi	sp,sp,-16
80000e60:	00812423          	sw	s0,8(sp)
80000e64:	00112623          	sw	ra,12(sp)
80000e68:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000e6c:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000e70:	00161613          	slli	a2,a2,0x1
80000e74:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80000e78:	00500793          	li	a5,5
80000e7c:	02c7e863          	bltu	a5,a2,80000eac <_Fault+0x50>
80000e80:	80006737          	lui	a4,0x80006
80000e84:	00261793          	slli	a5,a2,0x2
80000e88:	bb070713          	addi	a4,a4,-1104 # 80005bb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bb1>
80000e8c:	00f707b3          	add	a5,a4,a5
80000e90:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000e94:	80006537          	lui	a0,0x80006
80000e98:	bd050513          	addi	a0,a0,-1072 # 80005bd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bd1>
80000e9c:	53d000ef          	jal	ra,80001bd8 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000ea0:	00040593          	mv	a1,s0
80000ea4:	00000513          	li	a0,0
80000ea8:	ea5ff0ef          	jal	ra,80000d4c <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000eac:	800065b7          	lui	a1,0x80006
80000eb0:	bc858593          	addi	a1,a1,-1080 # 80005bc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bc9>
80000eb4:	fe1ff06f          	j	80000e94 <_Fault+0x38>

80000eb8 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000eb8:	ff010113          	addi	sp,sp,-16
80000ebc:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000ec0:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000ec4:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80000ec8:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000ecc:	0015d593          	srli	a1,a1,0x1
80000ed0:	ea050513          	addi	a0,a0,-352 # 80005ea0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ea1>
80000ed4:	505000ef          	jal	ra,80001bd8 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000ed8:	800065b7          	lui	a1,0x80006
80000edc:	bec58593          	addi	a1,a1,-1044 # 80005bec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bed>
80000ee0:	00400513          	li	a0,4
80000ee4:	e69ff0ef          	jal	ra,80000d4c <z_NanoFatalErrorHandler>

80000ee8 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000ee8:	800067b7          	lui	a5,0x80006
80000eec:	6a478793          	addi	a5,a5,1700 # 800066a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a5>
80000ef0:	0007a703          	lw	a4,0(a5)
80000ef4:	00070c63          	beqz	a4,80000f0c <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80000ef8:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000efc:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000f00:	800067b7          	lui	a5,0x80006
80000f04:	6a87a503          	lw	a0,1704(a5) # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000f08:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80000f0c:	00008067          	ret

80000f10 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000f10:	ff010113          	addi	sp,sp,-16
80000f14:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80000f18:	031010ef          	jal	ra,80002748 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000f1c:	54d000ef          	jal	ra,80001c68 <soc_interrupt_init>
#endif
	z_cstart();
80000f20:	095010ef          	jal	ra,800027b4 <z_cstart>

80000f24 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000f24:	00006117          	auipc	sp,0x6
80000f28:	48c10113          	addi	sp,sp,1164 # 800073b0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80000f2c:	000012b7          	lui	t0,0x1
80000f30:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000f34:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000f38:	fd9ff0ef          	jal	ra,80000f10 <_PrepC>

80000f3c <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000f3c:	6300006f          	j	8000156c <z_thread_entry>

80000f40 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000f40:	fd010113          	addi	sp,sp,-48
80000f44:	02812423          	sw	s0,40(sp)
80000f48:	02912223          	sw	s1,36(sp)
80000f4c:	03212023          	sw	s2,32(sp)
80000f50:	01312e23          	sw	s3,28(sp)
80000f54:	01412c23          	sw	s4,24(sp)
80000f58:	01512a23          	sw	s5,20(sp)
80000f5c:	01612823          	sw	s6,16(sp)
80000f60:	01712623          	sw	s7,12(sp)
80000f64:	00078b13          	mv	s6,a5
80000f68:	02112623          	sw	ra,44(sp)
80000f6c:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000f70:	00f00793          	li	a5,15
{
80000f74:	00050493          	mv	s1,a0
80000f78:	00058413          	mv	s0,a1
80000f7c:	00060993          	mv	s3,a2
80000f80:	00068a13          	mv	s4,a3
80000f84:	00070b93          	mv	s7,a4
80000f88:	00080a93          	mv	s5,a6
80000f8c:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000f90:	08f89a63          	bne	a7,a5,80001024 <z_new_thread+0xe4>
80000f94:	800027b7          	lui	a5,0x80002
80000f98:	71078793          	addi	a5,a5,1808 # 80002710 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002711>
80000f9c:	08f69a63          	bne	a3,a5,80001030 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000fa0:	03012683          	lw	a3,48(sp)
80000fa4:	00090593          	mv	a1,s2
80000fa8:	00048513          	mv	a0,s1
80000fac:	00400613          	li	a2,4
80000fb0:	32d030ef          	jal	ra,80004adc <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000fb4:	fb098593          	addi	a1,s3,-80
80000fb8:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000fbc:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000fc0:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000fc4:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000fc8:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000fcc:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000fd0:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000fd4:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000fd8:	02c12083          	lw	ra,44(sp)
80000fdc:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000fe0:	f3c78793          	addi	a5,a5,-196 # 80000f3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000f3d>
	stack_init->a0 = (u32_t)thread_func;
80000fe4:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000fe8:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000fec:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000ff0:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000ff4:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000ff8:	02b4a423          	sw	a1,40(s1)
}
80000ffc:	02012903          	lw	s2,32(sp)
80001000:	02412483          	lw	s1,36(sp)
80001004:	01c12983          	lw	s3,28(sp)
80001008:	01812a03          	lw	s4,24(sp)
8000100c:	01412a83          	lw	s5,20(sp)
80001010:	01012b03          	lw	s6,16(sp)
80001014:	00c12b83          	lw	s7,12(sp)
80001018:	00812c03          	lw	s8,8(sp)
8000101c:	03010113          	addi	sp,sp,48
80001020:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001024:	01088693          	addi	a3,a7,16
80001028:	01e00793          	li	a5,30
8000102c:	f6d7fae3          	bgeu	a5,a3,80000fa0 <z_new_thread+0x60>
80001030:	80006c37          	lui	s8,0x80006
80001034:	800065b7          	lui	a1,0x80006
80001038:	80006537          	lui	a0,0x80006
8000103c:	ec8c0613          	addi	a2,s8,-312 # 80005ec8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ec9>
80001040:	01800693          	li	a3,24
80001044:	ee858593          	addi	a1,a1,-280 # 80005ee8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee9>
80001048:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000104c:	38d000ef          	jal	ra,80001bd8 <printk>
80001050:	80006537          	lui	a0,0x80006
80001054:	00090593          	mv	a1,s2
80001058:	ff000693          	li	a3,-16
8000105c:	00e00613          	li	a2,14
80001060:	f9450513          	addi	a0,a0,-108 # 80005f94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f95>
80001064:	375000ef          	jal	ra,80001bd8 <printk>
80001068:	01800593          	li	a1,24
8000106c:	ec8c0513          	addi	a0,s8,-312
80001070:	3a5000ef          	jal	ra,80001c14 <assert_post_action>
80001074:	f2dff06f          	j	80000fa0 <z_new_thread+0x60>

80001078 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80001078:	00159793          	slli	a5,a1,0x1
8000107c:	00b787b3          	add	a5,a5,a1
80001080:	00279713          	slli	a4,a5,0x2
80001084:	00c52783          	lw	a5,12(a0)
80001088:	00e787b3          	add	a5,a5,a4
8000108c:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001090:	00b75463          	bge	a4,a1,80001098 <get_bit_ptr+0x20>
80001094:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001098:	41f65713          	srai	a4,a2,0x1f
8000109c:	01f77713          	andi	a4,a4,31
800010a0:	00c70733          	add	a4,a4,a2
800010a4:	40575713          	srai	a4,a4,0x5
800010a8:	00271713          	slli	a4,a4,0x2
800010ac:	00e787b3          	add	a5,a5,a4
800010b0:	00f6a023          	sw	a5,0(a3)

	return bn & 0x1f;
}
800010b4:	01f67513          	andi	a0,a2,31
800010b8:	00008067          	ret

800010bc <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800010bc:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800010c0:	00c10693          	addi	a3,sp,12
{
800010c4:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800010c8:	fb1ff0ef          	jal	ra,80001078 <get_bit_ptr>

	*word |= (1<<bit);
800010cc:	00c12703          	lw	a4,12(sp)
800010d0:	00100793          	li	a5,1
800010d4:	00a79533          	sll	a0,a5,a0
800010d8:	00072783          	lw	a5,0(a4)
}
800010dc:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
800010e0:	00a7e7b3          	or	a5,a5,a0
800010e4:	00f72023          	sw	a5,0(a4)
}
800010e8:	02010113          	addi	sp,sp,32
800010ec:	00008067          	ret

800010f0 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800010f0:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800010f4:	00c10693          	addi	a3,sp,12
{
800010f8:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800010fc:	f7dff0ef          	jal	ra,80001078 <get_bit_ptr>

	*word &= ~(1<<bit);
80001100:	00c12703          	lw	a4,12(sp)
80001104:	00100793          	li	a5,1
80001108:	00a79533          	sll	a0,a5,a0
8000110c:	00072783          	lw	a5,0(a4)
}
80001110:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80001114:	fff54513          	not	a0,a0
80001118:	00a7f533          	and	a0,a5,a0
8000111c:	00a72023          	sw	a0,0(a4)
}
80001120:	02010113          	addi	sp,sp,32
80001124:	00008067          	ret

80001128 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80001128:	fe010113          	addi	sp,sp,-32
8000112c:	00912a23          	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001130:	00452483          	lw	s1,4(a0)
{
80001134:	00812c23          	sw	s0,24(sp)
80001138:	00050413          	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000113c:	00855503          	lhu	a0,8(a0)
80001140:	00048593          	mv	a1,s1
{
80001144:	01212823          	sw	s2,16(sp)
80001148:	01312623          	sw	s3,12(sp)
8000114c:	01412423          	sw	s4,8(sp)
80001150:	01512223          	sw	s5,4(sp)
80001154:	01612023          	sw	s6,0(sp)
80001158:	00112e23          	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000115c:	f28ff0ef          	jal	ra,80000884 <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001160:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001164:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80001168:	fff00793          	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000116c:	00050a13          	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001170:	00a989b3          	add	s3,s3,a0
	p->max_inline_level = -1;
80001174:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001178:	00000913          	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
8000117c:	01f00b13          	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80001180:	03594c63          	blt	s2,s5,800011b8 <z_sys_mem_pool_base_init+0x90>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001184:	00000493          	li	s1,0
80001188:	00845783          	lhu	a5,8(s0)
8000118c:	08f4cc63          	blt	s1,a5,80001224 <z_sys_mem_pool_base_init+0xfc>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001190:	01c12083          	lw	ra,28(sp)
80001194:	01812403          	lw	s0,24(sp)
80001198:	01412483          	lw	s1,20(sp)
8000119c:	01012903          	lw	s2,16(sp)
800011a0:	00c12983          	lw	s3,12(sp)
800011a4:	00812a03          	lw	s4,8(sp)
800011a8:	00412a83          	lw	s5,4(sp)
800011ac:	00012b03          	lw	s6,0(sp)
800011b0:	02010113          	addi	sp,sp,32
800011b4:	00008067          	ret
		int nblocks = buflen / sz;
800011b8:	00048593          	mv	a1,s1
800011bc:	000a0513          	mv	a0,s4
800011c0:	ef0ff0ef          	jal	ra,800008b0 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
800011c4:	00191713          	slli	a4,s2,0x1
800011c8:	01270733          	add	a4,a4,s2
800011cc:	00271793          	slli	a5,a4,0x2
800011d0:	00c42703          	lw	a4,12(s0)
800011d4:	00f70733          	add	a4,a4,a5
800011d8:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
800011dc:	00f72223          	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
800011e0:	00f72423          	sw	a5,8(a4)
		if (nblocks < 32) {
800011e4:	00ab4e63          	blt	s6,a0,80001200 <z_sys_mem_pool_base_init+0xd8>
			p->max_inline_level = i;
800011e8:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
800011ec:	0024d493          	srli	s1,s1,0x2
800011f0:	00348493          	addi	s1,s1,3
800011f4:	ffc4f493          	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
800011f8:	00190913          	addi	s2,s2,1
800011fc:	f85ff06f          	j	80001180 <z_sys_mem_pool_base_init+0x58>
			bits += (nblocks + 31)/32;
80001200:	01f50513          	addi	a0,a0,31
80001204:	41f55793          	srai	a5,a0,0x1f
80001208:	01f7f793          	andi	a5,a5,31
8000120c:	00a787b3          	add	a5,a5,a0
80001210:	4057d793          	srai	a5,a5,0x5
80001214:	00279793          	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80001218:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
8000121c:	00f989b3          	add	s3,s3,a5
80001220:	fcdff06f          	j	800011ec <z_sys_mem_pool_base_init+0xc4>
	return (u8_t *)p->buf + lsz * block;
80001224:	00442583          	lw	a1,4(s0)
80001228:	00048513          	mv	a0,s1
8000122c:	e58ff0ef          	jal	ra,80000884 <__mulsi3>
80001230:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001234:	00048613          	mv	a2,s1
80001238:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
8000123c:	00a78533          	add	a0,a5,a0
		sys_dlist_append(&p->levels[0].free_list, block);
80001240:	00c42783          	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001244:	00148493          	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80001248:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
8000124c:	00e52023          	sw	a4,0(a0)
	node->prev = list->tail;
80001250:	0087a703          	lw	a4,8(a5)
80001254:	00e52223          	sw	a4,4(a0)

	list->tail->next = node;
80001258:	0087a703          	lw	a4,8(a5)
8000125c:	00a72023          	sw	a0,0(a4)
	list->tail = node;
80001260:	00a7a423          	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80001264:	00040513          	mv	a0,s0
80001268:	e55ff0ef          	jal	ra,800010bc <set_free_bit>
8000126c:	f1dff06f          	j	80001188 <z_sys_mem_pool_base_init+0x60>

80001270 <z_sys_mem_pool_block_free>:
	return 0;
}

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001270:	fa010113          	addi	sp,sp,-96
80001274:	04812c23          	sw	s0,88(sp)
80001278:	05412423          	sw	s4,72(sp)
8000127c:	03912a23          	sw	s9,52(sp)
80001280:	04112e23          	sw	ra,92(sp)
80001284:	04912a23          	sw	s1,84(sp)
80001288:	05212823          	sw	s2,80(sp)
8000128c:	05312623          	sw	s3,76(sp)
80001290:	05512223          	sw	s5,68(sp)
80001294:	05612023          	sw	s6,64(sp)
80001298:	03712e23          	sw	s7,60(sp)
8000129c:	03812c23          	sw	s8,56(sp)
800012a0:	03a12823          	sw	s10,48(sp)
800012a4:	03b12623          	sw	s11,44(sp)
800012a8:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800012ac:	00a54703          	lbu	a4,10(a0)
{
800012b0:	00050c93          	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800012b4:	00271713          	slli	a4,a4,0x2
800012b8:	00f70713          	addi	a4,a4,15
800012bc:	7f077713          	andi	a4,a4,2032
800012c0:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
800012c4:	00452703          	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
800012c8:	00010a13          	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
800012cc:	000a0693          	mv	a3,s4
800012d0:	00370713          	addi	a4,a4,3
800012d4:	ffc77713          	andi	a4,a4,-4
800012d8:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
800012dc:	00100513          	li	a0,1
800012e0:	00468693          	addi	a3,a3,4
800012e4:	0ca5f063          	bgeu	a1,a0,800013a4 <z_sys_mem_pool_block_free+0x134>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800012e8:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
800012ec:	00058913          	mv	s2,a1
800012f0:	00060993          	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800012f4:	00177713          	andi	a4,a4,1
		return 0;
800012f8:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800012fc:	00070863          	beqz	a4,8000130c <z_sys_mem_pool_block_free+0x9c>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80001300:	00800493          	li	s1,8
80001304:	3004b4f3          	csrrc	s1,mstatus,s1
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80001308:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
8000130c:	80006b37          	lui	s6,0x80006
	while (level >= 0) {
80001310:	0a095863          	bgez	s2,800013c0 <z_sys_mem_pool_block_free+0x150>
	__ASSERT(0, "out of levels");
80001314:	800064b7          	lui	s1,0x80006
80001318:	800065b7          	lui	a1,0x80006
8000131c:	80006537          	lui	a0,0x80006
80001320:	fc848613          	addi	a2,s1,-56 # 80005fc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fc9>
80001324:	0c000693          	li	a3,192
80001328:	03058593          	addi	a1,a1,48 # 80006030 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006031>
8000132c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80001330:	0a9000ef          	jal	ra,80001bd8 <printk>
80001334:	80006537          	lui	a0,0x80006
80001338:	ffc50513          	addi	a0,a0,-4 # 80005ffc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ffd>
8000133c:	09d000ef          	jal	ra,80001bd8 <printk>
80001340:	fc848513          	addi	a0,s1,-56
80001344:	0c000593          	li	a1,192
80001348:	0cd000ef          	jal	ra,80001c14 <assert_post_action>
	return -1;
8000134c:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001350:	010cc783          	lbu	a5,16(s9)
80001354:	0017f793          	andi	a5,a5,1
80001358:	00078663          	beqz	a5,80001364 <z_sys_mem_pool_block_free+0xf4>
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
8000135c:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001360:	3004a4f3          	csrrs	s1,mstatus,s1
}
80001364:	fa040113          	addi	sp,s0,-96
80001368:	05c12083          	lw	ra,92(sp)
8000136c:	05812403          	lw	s0,88(sp)
80001370:	05412483          	lw	s1,84(sp)
80001374:	05012903          	lw	s2,80(sp)
80001378:	04c12983          	lw	s3,76(sp)
8000137c:	04812a03          	lw	s4,72(sp)
80001380:	04412a83          	lw	s5,68(sp)
80001384:	04012b03          	lw	s6,64(sp)
80001388:	03c12b83          	lw	s7,60(sp)
8000138c:	03812c03          	lw	s8,56(sp)
80001390:	03412c83          	lw	s9,52(sp)
80001394:	03012d03          	lw	s10,48(sp)
80001398:	02c12d83          	lw	s11,44(sp)
8000139c:	06010113          	addi	sp,sp,96
800013a0:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800013a4:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
800013a8:	00150513          	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800013ac:	00275713          	srli	a4,a4,0x2
800013b0:	00370713          	addi	a4,a4,3
800013b4:	ffc77713          	andi	a4,a4,-4
800013b8:	00e6a023          	sw	a4,0(a3)
800013bc:	f25ff06f          	j	800012e0 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
800013c0:	00291713          	slli	a4,s2,0x2
800013c4:	00ea0733          	add	a4,s4,a4
800013c8:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
800013cc:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
800013d0:	00098513          	mv	a0,s3
800013d4:	000a8593          	mv	a1,s5
800013d8:	cacff0ef          	jal	ra,80000884 <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
800013dc:	fffa8b93          	addi	s7,s5,-1
800013e0:	01750d33          	add	s10,a0,s7
800013e4:	00ac0c33          	add	s8,s8,a0
	return p->n_max * p->max_sz;
800013e8:	004ca583          	lw	a1,4(s9)
800013ec:	008cd503          	lhu	a0,8(s9)
800013f0:	c94ff0ef          	jal	ra,80000884 <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
800013f4:	02ad6c63          	bltu	s10,a0,8000142c <z_sys_mem_pool_block_free+0x1bc>
800013f8:	800067b7          	lui	a5,0x80006
800013fc:	fdc78593          	addi	a1,a5,-36 # 80005fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fdd>
80001400:	800067b7          	lui	a5,0x80006
80001404:	f7478513          	addi	a0,a5,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80001408:	0a400693          	li	a3,164
8000140c:	fc8b0613          	addi	a2,s6,-56 # 80005fc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fc9>
80001410:	7c8000ef          	jal	ra,80001bd8 <printk>
80001414:	800067b7          	lui	a5,0x80006
80001418:	ff878513          	addi	a0,a5,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
8000141c:	7bc000ef          	jal	ra,80001bd8 <printk>
80001420:	0a400593          	li	a1,164
80001424:	fc8b0513          	addi	a0,s6,-56
80001428:	7ec000ef          	jal	ra,80001c14 <assert_post_action>
		set_free_bit(p, level, bn);
8000142c:	00098613          	mv	a2,s3
80001430:	00090593          	mv	a1,s2
80001434:	000c8513          	mv	a0,s9
80001438:	c85ff0ef          	jal	ra,800010bc <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
8000143c:	00191713          	slli	a4,s2,0x1
80001440:	01270733          	add	a4,a4,s2
80001444:	00271693          	slli	a3,a4,0x2
80001448:	00cca703          	lw	a4,12(s9)
8000144c:	00d70733          	add	a4,a4,a3
80001450:	00470693          	addi	a3,a4,4
	node->next = list;
80001454:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
80001458:	00872683          	lw	a3,8(a4)
8000145c:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
80001460:	00872683          	lw	a3,8(a4)
80001464:	0186a023          	sw	s8,0(a3)
	list->tail = node;
80001468:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000146c:	010cc703          	lbu	a4,16(s9)
80001470:	00177713          	andi	a4,a4,1
80001474:	0c071c63          	bnez	a4,8000154c <z_sys_mem_pool_block_free+0x2dc>
		return 0;
80001478:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
8000147c:	ec090ae3          	beqz	s2,80001350 <z_sys_mem_pool_block_free+0xe0>
	int bit = get_bit_ptr(p, level, bn, &word);
80001480:	fbc40693          	addi	a3,s0,-68
80001484:	00098613          	mv	a2,s3
80001488:	00090593          	mv	a1,s2
8000148c:	000c8513          	mv	a0,s9
80001490:	be9ff0ef          	jal	ra,80001078 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80001494:	fbc42683          	lw	a3,-68(s0)
80001498:	41f55713          	srai	a4,a0,0x1f
8000149c:	00377713          	andi	a4,a4,3
800014a0:	00a70733          	add	a4,a4,a0
800014a4:	0006a503          	lw	a0,0(a3)
800014a8:	ffc77713          	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800014ac:	00f00793          	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
800014b0:	00e55733          	srl	a4,a0,a4
800014b4:	00f77713          	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800014b8:	e8f71ce3          	bne	a4,a5,80001350 <z_sys_mem_pool_block_free+0xe0>
		for (i = 0; i < 4; i++) {
800014bc:	00000d13          	li	s10,0
			int b = (bn & ~3) + i;
800014c0:	ffc9fd93          	andi	s11,s3,-4
800014c4:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
800014c8:	00060513          	mv	a0,a2
800014cc:	000a8593          	mv	a1,s5
800014d0:	fac42423          	sw	a2,-88(s0)
800014d4:	bb0ff0ef          	jal	ra,80000884 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800014d8:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
800014dc:	00050c13          	mv	s8,a0
	return p->n_max * p->max_sz;
800014e0:	004ca583          	lw	a1,4(s9)
800014e4:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800014e8:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
800014ec:	b98ff0ef          	jal	ra,80000884 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800014f0:	fac42703          	lw	a4,-84(s0)
800014f4:	fa842603          	lw	a2,-88(s0)
800014f8:	02a77863          	bgeu	a4,a0,80001528 <z_sys_mem_pool_block_free+0x2b8>
				clear_free_bit(p, level, b);
800014fc:	00090593          	mv	a1,s2
80001500:	000c8513          	mv	a0,s9
80001504:	bedff0ef          	jal	ra,800010f0 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
80001508:	000ca703          	lw	a4,0(s9)
8000150c:	01870c33          	add	s8,a4,s8
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
80001510:	004c2603          	lw	a2,4(s8)
80001514:	000c2703          	lw	a4,0(s8)
80001518:	00e62023          	sw	a4,0(a2)
	node->next->prev = node->prev;
8000151c:	00c72223          	sw	a2,4(a4)
	node->next = NULL;
80001520:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80001524:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80001528:	001d0d13          	addi	s10,s10,1
8000152c:	00400793          	li	a5,4
80001530:	f8fd1ae3          	bne	s10,a5,800014c4 <z_sys_mem_pool_block_free+0x254>
		bn = bn / 4;
80001534:	41f9d613          	srai	a2,s3,0x1f
80001538:	00367613          	andi	a2,a2,3
8000153c:	013609b3          	add	s3,a2,s3
		level = level - 1;
80001540:	fff90913          	addi	s2,s2,-1
		bn = bn / 4;
80001544:	4029d993          	srai	s3,s3,0x2
80001548:	dc9ff06f          	j	80001310 <z_sys_mem_pool_block_free+0xa0>
8000154c:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001550:	010cc703          	lbu	a4,16(s9)
80001554:	00177713          	andi	a4,a4,1
80001558:	f20700e3          	beqz	a4,80001478 <z_sys_mem_pool_block_free+0x208>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000155c:	00800793          	li	a5,8
80001560:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
80001564:	0084f493          	andi	s1,s1,8
80001568:	f15ff06f          	j	8000147c <z_sys_mem_pool_block_free+0x20c>

8000156c <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
8000156c:	ff010113          	addi	sp,sp,-16
80001570:	00050793          	mv	a5,a0
80001574:	00058513          	mv	a0,a1
80001578:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
8000157c:	00068613          	mv	a2,a3
{
80001580:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001584:	000780e7          	jalr	a5
80001588:	74d020ef          	jal	ra,800044d4 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000158c:	0f5030ef          	jal	ra,80004e80 <z_impl_k_thread_abort>

80001590 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001590:	00000513          	li	a0,0
80001594:	00008067          	ret

80001598 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001598:	ff010113          	addi	sp,sp,-16
8000159c:	00812423          	sw	s0,8(sp)
800015a0:	00050413          	mv	s0,a0
	out('E', ctx);
800015a4:	04500513          	li	a0,69
{
800015a8:	00112623          	sw	ra,12(sp)
800015ac:	00912223          	sw	s1,4(sp)
800015b0:	00058493          	mv	s1,a1
	out('E', ctx);
800015b4:	000400e7          	jalr	s0
	out('R', ctx);
800015b8:	00048593          	mv	a1,s1
800015bc:	05200513          	li	a0,82
800015c0:	000400e7          	jalr	s0
	out('R', ctx);
800015c4:	00040313          	mv	t1,s0
}
800015c8:	00812403          	lw	s0,8(sp)
800015cc:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
800015d0:	00048593          	mv	a1,s1
}
800015d4:	00412483          	lw	s1,4(sp)
	out('R', ctx);
800015d8:	05200513          	li	a0,82
}
800015dc:	01010113          	addi	sp,sp,16
	out('R', ctx);
800015e0:	00030067          	jr	t1

800015e4 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
800015e4:	0005a783          	lw	a5,0(a1)
800015e8:	00178793          	addi	a5,a5,1
800015ec:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
800015f0:	800067b7          	lui	a5,0x80006
800015f4:	5c87a303          	lw	t1,1480(a5) # 800065c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c9>
800015f8:	00030067          	jr	t1

800015fc <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
800015fc:	fc010113          	addi	sp,sp,-64
80001600:	02812c23          	sw	s0,56(sp)
80001604:	03312623          	sw	s3,44(sp)
80001608:	03412423          	sw	s4,40(sp)
8000160c:	03612023          	sw	s6,32(sp)
80001610:	01a12823          	sw	s10,16(sp)
80001614:	02112e23          	sw	ra,60(sp)
80001618:	02912a23          	sw	s1,52(sp)
8000161c:	03212823          	sw	s2,48(sp)
80001620:	03512223          	sw	s5,36(sp)
80001624:	01712e23          	sw	s7,28(sp)
80001628:	01812c23          	sw	s8,24(sp)
8000162c:	01912a23          	sw	s9,20(sp)
80001630:	01b12623          	sw	s11,12(sp)
80001634:	00050993          	mv	s3,a0
80001638:	00058a13          	mv	s4,a1
8000163c:	00060d13          	mv	s10,a2
80001640:	00068b13          	mv	s6,a3
80001644:	00100413          	li	s0,1
80001648:	00e05463          	blez	a4,80001650 <_printk_dec_ulong+0x54>
8000164c:	00070413          	mv	s0,a4
80001650:	00100793          	li	a5,1
80001654:	02000c93          	li	s9,32
80001658:	00fb1463          	bne	s6,a5,80001660 <_printk_dec_ulong+0x64>
8000165c:	03000c93          	li	s9,48
80001660:	3b9ad4b7          	lui	s1,0x3b9ad
80001664:	00100913          	li	s2,1
80001668:	00a00a93          	li	s5,10
8000166c:	00000c13          	li	s8,0
80001670:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001674:	00200d93          	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001678:	00148b93          	addi	s7,s1,1
8000167c:	000c1463          	bnez	s8,80001684 <_printk_dec_ulong+0x88>
80001680:	0ba4f263          	bgeu	s1,s10,80001724 <_printk_dec_ulong+0x128>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001684:	000b8593          	mv	a1,s7
80001688:	000d0513          	mv	a0,s10
8000168c:	a24ff0ef          	jal	ra,800008b0 <__udivsi3>
80001690:	000a0593          	mv	a1,s4
80001694:	03050513          	addi	a0,a0,48
80001698:	000980e7          	jalr	s3
			digits++;
8000169c:	00190913          	addi	s2,s2,1
			found_largest_digit = 1;
800016a0:	00100c13          	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
800016a4:	000b8593          	mv	a1,s7
800016a8:	000d0513          	mv	a0,s10
800016ac:	a4cff0ef          	jal	ra,800008f8 <__umodsi3>
800016b0:	00050d13          	mv	s10,a0
		pos /= 10;
800016b4:	00a00593          	li	a1,10
800016b8:	00048513          	mv	a0,s1
800016bc:	9f4ff0ef          	jal	ra,800008b0 <__udivsi3>
		remaining--;
800016c0:	fffa8a93          	addi	s5,s5,-1
	while (pos >= 9) {
800016c4:	00100793          	li	a5,1
		pos /= 10;
800016c8:	00050493          	mv	s1,a0
	while (pos >= 9) {
800016cc:	fafa96e3          	bne	s5,a5,80001678 <_printk_dec_ulong+0x7c>
	}
	out((int)(remainder + 48), ctx);
800016d0:	000a0593          	mv	a1,s4
800016d4:	030d0513          	addi	a0,s10,48
800016d8:	000980e7          	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
800016dc:	00300793          	li	a5,3
		remaining = min_width - digits;
800016e0:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
800016e4:	06fb0663          	beq	s6,a5,80001750 <_printk_dec_ulong+0x154>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
800016e8:	03c12083          	lw	ra,60(sp)
800016ec:	03812403          	lw	s0,56(sp)
800016f0:	03412483          	lw	s1,52(sp)
800016f4:	03012903          	lw	s2,48(sp)
800016f8:	02c12983          	lw	s3,44(sp)
800016fc:	02812a03          	lw	s4,40(sp)
80001700:	02412a83          	lw	s5,36(sp)
80001704:	02012b03          	lw	s6,32(sp)
80001708:	01c12b83          	lw	s7,28(sp)
8000170c:	01812c03          	lw	s8,24(sp)
80001710:	01412c83          	lw	s9,20(sp)
80001714:	01012d03          	lw	s10,16(sp)
80001718:	00c12d83          	lw	s11,12(sp)
8000171c:	04010113          	addi	sp,sp,64
80001720:	00008067          	ret
		} else if (remaining <= min_width
80001724:	f95440e3          	blt	s0,s5,800016a4 <_printk_dec_ulong+0xa8>
				&& padding < PAD_SPACE_AFTER) {
80001728:	f76deee3          	bltu	s11,s6,800016a4 <_printk_dec_ulong+0xa8>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
8000172c:	000a0593          	mv	a1,s4
80001730:	000c8513          	mv	a0,s9
80001734:	000980e7          	jalr	s3
			digits++;
80001738:	00190913          	addi	s2,s2,1
8000173c:	f69ff06f          	j	800016a4 <_printk_dec_ulong+0xa8>
			out(' ', ctx);
80001740:	000a0593          	mv	a1,s4
80001744:	02000513          	li	a0,32
80001748:	000980e7          	jalr	s3
8000174c:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
80001750:	fe8048e3          	bgtz	s0,80001740 <_printk_dec_ulong+0x144>
80001754:	f95ff06f          	j	800016e8 <_printk_dec_ulong+0xec>

80001758 <__printk_hook_install>:
	_char_out = fn;
80001758:	800067b7          	lui	a5,0x80006
8000175c:	5ca7a423          	sw	a0,1480(a5) # 800065c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065c9>
}
80001760:	00008067          	ret

80001764 <z_vprintk>:
{
80001764:	fb010113          	addi	sp,sp,-80
80001768:	04812423          	sw	s0,72(sp)
8000176c:	04912223          	sw	s1,68(sp)
80001770:	05212023          	sw	s2,64(sp)
80001774:	03312e23          	sw	s3,60(sp)
80001778:	03412c23          	sw	s4,56(sp)
8000177c:	03512a23          	sw	s5,52(sp)
80001780:	03912223          	sw	s9,36(sp)
80001784:	03a12023          	sw	s10,32(sp)
80001788:	01b12e23          	sw	s11,28(sp)
8000178c:	04112623          	sw	ra,76(sp)
80001790:	03612823          	sw	s6,48(sp)
80001794:	03712623          	sw	s7,44(sp)
80001798:	03812423          	sw	s8,40(sp)
8000179c:	00050413          	mv	s0,a0
800017a0:	00058493          	mv	s1,a1
800017a4:	00060a93          	mv	s5,a2
800017a8:	00068d13          	mv	s10,a3
	int long_ctr = 0;
800017ac:	00000a13          	li	s4,0
	int min_width = -1;
800017b0:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
800017b4:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800017b8:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
800017bc:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800017c0:	000ac503          	lbu	a0,0(s5)
800017c4:	04051063          	bnez	a0,80001804 <z_vprintk+0xa0>
}
800017c8:	04c12083          	lw	ra,76(sp)
800017cc:	04812403          	lw	s0,72(sp)
800017d0:	04412483          	lw	s1,68(sp)
800017d4:	04012903          	lw	s2,64(sp)
800017d8:	03c12983          	lw	s3,60(sp)
800017dc:	03812a03          	lw	s4,56(sp)
800017e0:	03412a83          	lw	s5,52(sp)
800017e4:	03012b03          	lw	s6,48(sp)
800017e8:	02c12b83          	lw	s7,44(sp)
800017ec:	02812c03          	lw	s8,40(sp)
800017f0:	02412c83          	lw	s9,36(sp)
800017f4:	02012d03          	lw	s10,32(sp)
800017f8:	01c12d83          	lw	s11,28(sp)
800017fc:	05010113          	addi	sp,sp,80
80001800:	00008067          	ret
		if (!might_format) {
80001804:	000c9e63          	bnez	s9,80001820 <z_vprintk+0xbc>
			if (*fmt != '%') {
80001808:	02500693          	li	a3,37
8000180c:	36d50c63          	beq	a0,a3,80001b84 <z_vprintk+0x420>
				out((int)*fmt, ctx);
80001810:	00048593          	mv	a1,s1
80001814:	000400e7          	jalr	s0
		++fmt;
80001818:	001a8a93          	addi	s5,s5,1
8000181c:	fa5ff06f          	j	800017c0 <z_vprintk+0x5c>
			switch (*fmt) {
80001820:	06400693          	li	a3,100
80001824:	12d50063          	beq	a0,a3,80001944 <z_vprintk+0x1e0>
80001828:	06a6e263          	bltu	a3,a0,8000188c <z_vprintk+0x128>
8000182c:	03900693          	li	a3,57
80001830:	02a6ea63          	bltu	a3,a0,80001864 <z_vprintk+0x100>
80001834:	03100693          	li	a3,49
80001838:	0ed57463          	bgeu	a0,a3,80001920 <z_vprintk+0x1bc>
8000183c:	02d00693          	li	a3,45
80001840:	34d50c63          	beq	a0,a3,80001b98 <z_vprintk+0x434>
80001844:	03000793          	li	a5,48
80001848:	0cf50063          	beq	a0,a5,80001908 <z_vprintk+0x1a4>
8000184c:	02500713          	li	a4,37
80001850:	02e51263          	bne	a0,a4,80001874 <z_vprintk+0x110>
				out((int)'%', ctx);
80001854:	00048593          	mv	a1,s1
80001858:	02500513          	li	a0,37
				out((int)*fmt, ctx);
8000185c:	000400e7          	jalr	s0
				break;
80001860:	1600006f          	j	800019c0 <z_vprintk+0x25c>
80001864:	05800693          	li	a3,88
80001868:	1cd50063          	beq	a0,a3,80001a28 <z_vprintk+0x2c4>
8000186c:	06300713          	li	a4,99
80001870:	30e50063          	beq	a0,a4,80001b70 <z_vprintk+0x40c>
				out((int)'%', ctx);
80001874:	00048593          	mv	a1,s1
80001878:	02500513          	li	a0,37
8000187c:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001880:	00048593          	mv	a1,s1
80001884:	000ac503          	lbu	a0,0(s5)
80001888:	fd5ff06f          	j	8000185c <z_vprintk+0xf8>
8000188c:	07000693          	li	a3,112
80001890:	16d50c63          	beq	a0,a3,80001a08 <z_vprintk+0x2a4>
80001894:	02a6e063          	bltu	a3,a0,800018b4 <z_vprintk+0x150>
80001898:	06900693          	li	a3,105
8000189c:	0ad50463          	beq	a0,a3,80001944 <z_vprintk+0x1e0>
800018a0:	06c00693          	li	a3,108
800018a4:	08d50c63          	beq	a0,a3,8000193c <z_vprintk+0x1d8>
800018a8:	06800693          	li	a3,104
800018ac:	f6d506e3          	beq	a0,a3,80001818 <z_vprintk+0xb4>
800018b0:	fc5ff06f          	j	80001874 <z_vprintk+0x110>
800018b4:	07500693          	li	a3,117
800018b8:	10d50863          	beq	a0,a3,800019c8 <z_vprintk+0x264>
800018bc:	02a6ee63          	bltu	a3,a0,800018f8 <z_vprintk+0x194>
800018c0:	07300713          	li	a4,115
800018c4:	fae518e3          	bne	a0,a4,80001874 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
800018c8:	000d2c03          	lw	s8,0(s10)
800018cc:	004d0b13          	addi	s6,s10,4
800018d0:	000c0b93          	mv	s7,s8
				while (*s)
800018d4:	000bc503          	lbu	a0,0(s7)
800018d8:	26051a63          	bnez	a0,80001b4c <z_vprintk+0x3e8>
				if (padding == PAD_SPACE_AFTER) {
800018dc:	00300793          	li	a5,3
800018e0:	00f99863          	bne	s3,a5,800018f0 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
800018e4:	418b8bb3          	sub	s7,s7,s8
800018e8:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800018ec:	27704863          	bgtz	s7,80001b5c <z_vprintk+0x3f8>
				char *s = va_arg(ap, char *);
800018f0:	000b0d13          	mv	s10,s6
800018f4:	0cc0006f          	j	800019c0 <z_vprintk+0x25c>
800018f8:	07800693          	li	a3,120
800018fc:	12d50663          	beq	a0,a3,80001a28 <z_vprintk+0x2c4>
80001900:	07a00693          	li	a3,122
80001904:	fa9ff06f          	j	800018ac <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80001908:	00095e63          	bgez	s2,80001924 <z_vprintk+0x1c0>
8000190c:	28098a63          	beqz	s3,80001ba0 <z_vprintk+0x43c>
					min_width = *fmt - '0';
80001910:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001914:	f00992e3          	bnez	s3,80001818 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001918:	00200993          	li	s3,2
8000191c:	efdff06f          	j	80001818 <z_vprintk+0xb4>
				if (min_width < 0) {
80001920:	fe0948e3          	bltz	s2,80001910 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001924:	00291693          	slli	a3,s2,0x2
80001928:	01268933          	add	s2,a3,s2
8000192c:	00191913          	slli	s2,s2,0x1
80001930:	fd090913          	addi	s2,s2,-48
80001934:	01250933          	add	s2,a0,s2
80001938:	fddff06f          	j	80001914 <z_vprintk+0x1b0>
				long_ctr++;
8000193c:	001a0a13          	addi	s4,s4,1
80001940:	ed9ff06f          	j	80001818 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001944:	040a1263          	bnez	s4,80001988 <z_vprintk+0x224>
					long ld = va_arg(ap, long);
80001948:	000d2603          	lw	a2,0(s10)
8000194c:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001950:	02065063          	bgez	a2,80001970 <z_vprintk+0x20c>
					out((int)'-', ctx);
80001954:	00048593          	mv	a1,s1
80001958:	02d00513          	li	a0,45
8000195c:	00c12023          	sw	a2,0(sp)
80001960:	000400e7          	jalr	s0
					d = -d;
80001964:	00012603          	lw	a2,0(sp)
					min_width--;
80001968:	fff90913          	addi	s2,s2,-1
					d = -d;
8000196c:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001970:	00090713          	mv	a4,s2
80001974:	00098693          	mv	a3,s3
80001978:	00048593          	mv	a1,s1
8000197c:	00040513          	mv	a0,s0
80001980:	c7dff0ef          	jal	ra,800015fc <_printk_dec_ulong>
				break;
80001984:	03c0006f          	j	800019c0 <z_vprintk+0x25c>
				} else if (long_ctr == 1) {
80001988:	00100713          	li	a4,1
8000198c:	faea0ee3          	beq	s4,a4,80001948 <z_vprintk+0x1e4>
					long long lld = va_arg(ap, long long);
80001990:	007d0793          	addi	a5,s10,7
80001994:	ff87f713          	andi	a4,a5,-8
80001998:	00072603          	lw	a2,0(a4)
8000199c:	00472683          	lw	a3,4(a4)
800019a0:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
800019a4:	01b60733          	add	a4,a2,s11
800019a8:	00c73733          	sltu	a4,a4,a2
800019ac:	00d70733          	add	a4,a4,a3
800019b0:	fa0700e3          	beqz	a4,80001950 <z_vprintk+0x1ec>
						print_err(out, ctx);
800019b4:	00048593          	mv	a1,s1
800019b8:	00040513          	mv	a0,s0
800019bc:	bddff0ef          	jal	ra,80001598 <print_err>
			might_format = 0;
800019c0:	00000c93          	li	s9,0
800019c4:	e55ff06f          	j	80001818 <z_vprintk+0xb4>
				if (long_ctr == 0) {
800019c8:	000a1863          	bnez	s4,800019d8 <z_vprintk+0x274>
					long lu = va_arg(ap, unsigned long);
800019cc:	000d2603          	lw	a2,0(s10)
800019d0:	004d0d13          	addi	s10,s10,4
800019d4:	f9dff06f          	j	80001970 <z_vprintk+0x20c>
				} else if (long_ctr == 1) {
800019d8:	00100713          	li	a4,1
800019dc:	feea08e3          	beq	s4,a4,800019cc <z_vprintk+0x268>
					unsigned long long llu =
800019e0:	007d0793          	addi	a5,s10,7
800019e4:	ff87f713          	andi	a4,a5,-8
800019e8:	00870d13          	addi	s10,a4,8
800019ec:	00072603          	lw	a2,0(a4)
800019f0:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
800019f4:	fc0710e3          	bnez	a4,800019b4 <z_vprintk+0x250>
800019f8:	800007b7          	lui	a5,0x80000
800019fc:	fff7c793          	not	a5,a5
80001a00:	f6c7f8e3          	bgeu	a5,a2,80001970 <z_vprintk+0x20c>
80001a04:	fb1ff06f          	j	800019b4 <z_vprintk+0x250>
				  out('0', ctx);
80001a08:	00048593          	mv	a1,s1
80001a0c:	03000513          	li	a0,48
80001a10:	000400e7          	jalr	s0
				  out('x', ctx);
80001a14:	00048593          	mv	a1,s1
80001a18:	07800513          	li	a0,120
80001a1c:	000400e7          	jalr	s0
				  min_width = 8;
80001a20:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001a24:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001a28:	00100693          	li	a3,1
80001a2c:	0b46c263          	blt	a3,s4,80001ad0 <z_vprintk+0x36c>
					x = va_arg(ap, unsigned long);
80001a30:	000d2783          	lw	a5,0(s10)
80001a34:	00012423          	sw	zero,8(sp)
80001a38:	004d0d13          	addi	s10,s10,4
80001a3c:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001a40:	01000c13          	li	s8,16
	int digits = 0;
80001a44:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80001a48:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001a4c:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001a50:	00412503          	lw	a0,4(sp)
80001a54:	00812583          	lw	a1,8(sp)
80001a58:	fff88b13          	addi	s6,a7,-1
80001a5c:	002b1613          	slli	a2,s6,0x2
80001a60:	01112623          	sw	a7,12(sp)
80001a64:	815fe0ef          	jal	ra,80000278 <__lshrdi3>
80001a68:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001a6c:	08051863          	bnez	a0,80001afc <z_vprintk+0x398>
80001a70:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001a74:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001a78:	00079863          	bnez	a5,80001a88 <z_vprintk+0x324>
80001a7c:	00c12883          	lw	a7,12(sp)
80001a80:	00100793          	li	a5,1
80001a84:	08f89663          	bne	a7,a5,80001b10 <z_vprintk+0x3ac>
			nibble += nibble > 9 ? 87 : 48;
80001a88:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80001a8c:	01851513          	slli	a0,a0,0x18
80001a90:	00048593          	mv	a1,s1
80001a94:	41855513          	srai	a0,a0,0x18
80001a98:	000400e7          	jalr	s0
			digits++;
80001a9c:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
80001aa0:	040b1863          	bnez	s6,80001af0 <z_vprintk+0x38c>
	if (padding == PAD_SPACE_AFTER) {
80001aa4:	00300693          	li	a3,3
			might_format = 0;
80001aa8:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001aac:	d6d996e3          	bne	s3,a3,80001818 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
80001ab0:	00191713          	slli	a4,s2,0x1
80001ab4:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001ab8:	f17054e3          	blez	s7,800019c0 <z_vprintk+0x25c>
			out(' ', ctx);
80001abc:	00048593          	mv	a1,s1
80001ac0:	02000513          	li	a0,32
80001ac4:	000400e7          	jalr	s0
80001ac8:	fffb8b93          	addi	s7,s7,-1
80001acc:	fedff06f          	j	80001ab8 <z_vprintk+0x354>
					x = va_arg(ap, unsigned long long);
80001ad0:	007d0793          	addi	a5,s10,7
80001ad4:	ff87f693          	andi	a3,a5,-8
80001ad8:	0006a783          	lw	a5,0(a3)
80001adc:	00868d13          	addi	s10,a3,8
80001ae0:	00f12223          	sw	a5,4(sp)
80001ae4:	0046a783          	lw	a5,4(a3)
80001ae8:	00f12423          	sw	a5,8(sp)
80001aec:	f55ff06f          	j	80001a40 <z_vprintk+0x2dc>
			found_largest_digit = 1;
80001af0:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001af4:	000b0893          	mv	a7,s6
80001af8:	f59ff06f          	j	80001a50 <z_vprintk+0x2ec>
			nibble += nibble > 9 ? 87 : 48;
80001afc:	00900793          	li	a5,9
80001b00:	05700693          	li	a3,87
80001b04:	f8a7e2e3          	bltu	a5,a0,80001a88 <z_vprintk+0x324>
80001b08:	03000693          	li	a3,48
80001b0c:	f7dff06f          	j	80001a88 <z_vprintk+0x324>
		if (remaining-- <= min_width) {
80001b10:	fffc0793          	addi	a5,s8,-1
80001b14:	00f12623          	sw	a5,12(sp)
80001b18:	01894c63          	blt	s2,s8,80001b30 <z_vprintk+0x3cc>
			if (padding == PAD_ZERO_BEFORE) {
80001b1c:	00100793          	li	a5,1
80001b20:	00f99c63          	bne	s3,a5,80001b38 <z_vprintk+0x3d4>
				out('0', ctx);
80001b24:	00048593          	mv	a1,s1
80001b28:	03000513          	li	a0,48
				out(' ', ctx);
80001b2c:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80001b30:	00c12c03          	lw	s8,12(sp)
80001b34:	fc1ff06f          	j	80001af4 <z_vprintk+0x390>
			} else if (padding == PAD_SPACE_BEFORE) {
80001b38:	00200793          	li	a5,2
80001b3c:	fef99ae3          	bne	s3,a5,80001b30 <z_vprintk+0x3cc>
				out(' ', ctx);
80001b40:	00048593          	mv	a1,s1
80001b44:	02000513          	li	a0,32
80001b48:	fe5ff06f          	j	80001b2c <z_vprintk+0x3c8>
					out((int)(*s++), ctx);
80001b4c:	00048593          	mv	a1,s1
80001b50:	001b8b93          	addi	s7,s7,1
80001b54:	000400e7          	jalr	s0
80001b58:	d7dff06f          	j	800018d4 <z_vprintk+0x170>
						out(' ', ctx);
80001b5c:	00048593          	mv	a1,s1
80001b60:	02000513          	li	a0,32
80001b64:	000400e7          	jalr	s0
80001b68:	fffb8b93          	addi	s7,s7,-1
80001b6c:	d81ff06f          	j	800018ec <z_vprintk+0x188>
				out(c, ctx);
80001b70:	000d2503          	lw	a0,0(s10)
80001b74:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80001b78:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001b7c:	000400e7          	jalr	s0
				break;
80001b80:	d71ff06f          	j	800018f0 <z_vprintk+0x18c>
				long_ctr = 0;
80001b84:	00000a13          	li	s4,0
				min_width = -1;
80001b88:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80001b8c:	00000993          	li	s3,0
				might_format = 1;
80001b90:	00100c93          	li	s9,1
80001b94:	c85ff06f          	j	80001818 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80001b98:	00300993          	li	s3,3
80001b9c:	c7dff06f          	j	80001818 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80001ba0:	00100993          	li	s3,1
80001ba4:	c75ff06f          	j	80001818 <z_vprintk+0xb4>

80001ba8 <vprintk>:
{
80001ba8:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001bac:	00050613          	mv	a2,a0
80001bb0:	80001537          	lui	a0,0x80001
80001bb4:	00058693          	mv	a3,a1
80001bb8:	5e450513          	addi	a0,a0,1508 # 800015e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800015e5>
80001bbc:	00c10593          	addi	a1,sp,12
{
80001bc0:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001bc4:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001bc8:	b9dff0ef          	jal	ra,80001764 <z_vprintk>
}
80001bcc:	01c12083          	lw	ra,28(sp)
80001bd0:	02010113          	addi	sp,sp,32
80001bd4:	00008067          	ret

80001bd8 <printk>:
{
80001bd8:	fc010113          	addi	sp,sp,-64
80001bdc:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80001be0:	02410593          	addi	a1,sp,36
{
80001be4:	00112e23          	sw	ra,28(sp)
80001be8:	02c12423          	sw	a2,40(sp)
80001bec:	02d12623          	sw	a3,44(sp)
80001bf0:	02e12823          	sw	a4,48(sp)
80001bf4:	02f12a23          	sw	a5,52(sp)
80001bf8:	03012c23          	sw	a6,56(sp)
80001bfc:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80001c00:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80001c04:	fa5ff0ef          	jal	ra,80001ba8 <vprintk>
}
80001c08:	01c12083          	lw	ra,28(sp)
80001c0c:	04010113          	addi	sp,sp,64
80001c10:	00008067          	ret

80001c14 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001c14:	800065b7          	lui	a1,0x80006
80001c18:	80006537          	lui	a0,0x80006
{
80001c1c:	ff010113          	addi	sp,sp,-16
  k_panic();
80001c20:	00c58593          	addi	a1,a1,12 # 8000600c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000600d>
80001c24:	02050513          	addi	a0,a0,32 # 80006020 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006021>
80001c28:	01e00613          	li	a2,30
{
80001c2c:	00112623          	sw	ra,12(sp)
  k_panic();
80001c30:	fa9ff0ef          	jal	ra,80001bd8 <printk>
80001c34:	800065b7          	lui	a1,0x80006
80001c38:	bec58593          	addi	a1,a1,-1044 # 80005bec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bed>
80001c3c:	00600513          	li	a0,6
80001c40:	90cff0ef          	jal	ra,80000d4c <z_NanoFatalErrorHandler>

80001c44 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001c44:	00008067          	ret

80001c48 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001c48:	00800793          	li	a5,8
80001c4c:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001c50:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001c54:	00008067          	ret

80001c58 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001c58:	00100793          	li	a5,1
80001c5c:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001c60:	30452573          	csrrs	a0,mie,a0
}
80001c64:	00008067          	ret

80001c68 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001c68:	00800793          	li	a5,8
80001c6c:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001c70:	30405073          	csrwi	mie,0
80001c74:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001c78:	00008067          	ret

80001c7c <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001c7c:	ff010113          	addi	sp,sp,-16
80001c80:	00812423          	sw	s0,8(sp)
80001c84:	00912223          	sw	s1,4(sp)
80001c88:	80006437          	lui	s0,0x80006
80001c8c:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001c90:	00a00793          	li	a5,10
{
80001c94:	00050493          	mv	s1,a0
80001c98:	6ac40413          	addi	s0,s0,1708 # 800066ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066ad>
	if ('\n' == c) {
80001c9c:	00f51c63          	bne	a0,a5,80001cb4 <console_out+0x38>
80001ca0:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001ca4:	00d00593          	li	a1,13
80001ca8:	00452783          	lw	a5,4(a0)
80001cac:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80001cb0:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001cb4:	00042503          	lw	a0,0(s0)
80001cb8:	0ff4f593          	andi	a1,s1,255
80001cbc:	00452783          	lw	a5,4(a0)
80001cc0:	0047a783          	lw	a5,4(a5)
80001cc4:	000780e7          	jalr	a5

	return c;
}
80001cc8:	00c12083          	lw	ra,12(sp)
80001ccc:	00812403          	lw	s0,8(sp)
80001cd0:	00048513          	mv	a0,s1
80001cd4:	00412483          	lw	s1,4(sp)
80001cd8:	01010113          	addi	sp,sp,16
80001cdc:	00008067          	ret

80001ce0 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001ce0:	ff010113          	addi	sp,sp,-16
80001ce4:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001ce8:	80002437          	lui	s0,0x80002
80001cec:	c7c40513          	addi	a0,s0,-900 # 80001c7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001c7d>
{
80001cf0:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001cf4:	5d8000ef          	jal	ra,800022cc <__stdout_hook_install>
	__printk_hook_install(console_out);
80001cf8:	c7c40513          	addi	a0,s0,-900
}
80001cfc:	00812403          	lw	s0,8(sp)
80001d00:	00c12083          	lw	ra,12(sp)
80001d04:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80001d08:	a51ff06f          	j	80001758 <__printk_hook_install>

80001d0c <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001d0c:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001d10:	ff010113          	addi	sp,sp,-16
80001d14:	02c50513          	addi	a0,a0,44 # 8000602c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000602d>
80001d18:	00112623          	sw	ra,12(sp)
80001d1c:	159000ef          	jal	ra,80002674 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001d20:	800067b7          	lui	a5,0x80006
80001d24:	6aa7a623          	sw	a0,1708(a5) # 800066ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066ad>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001d28:	fb9ff0ef          	jal	ra,80001ce0 <uart_console_hook_install>

	return 0;
}
80001d2c:	00c12083          	lw	ra,12(sp)
80001d30:	00000513          	li	a0,0
80001d34:	01010113          	addi	sp,sp,16
80001d38:	00008067          	ret

80001d3c <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001d3c:	f01007b7          	lui	a5,0xf0100
80001d40:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001d44:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001d48:	f447a583          	lw	a1,-188(a5)
80001d4c:	fee59ae3          	bne	a1,a4,80001d40 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001d50:	00008067          	ret

80001d54 <timer_isr>:

static void timer_isr(void *arg)
{
80001d54:	fe010113          	addi	sp,sp,-32
80001d58:	00812c23          	sw	s0,24(sp)
80001d5c:	00112e23          	sw	ra,28(sp)
80001d60:	00912a23          	sw	s1,20(sp)
80001d64:	01212823          	sw	s2,16(sp)
80001d68:	01312623          	sw	s3,12(sp)
80001d6c:	01412423          	sw	s4,8(sp)
80001d70:	01512223          	sw	s5,4(sp)
80001d74:	00800413          	li	s0,8
80001d78:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001d7c:	80006937          	lui	s2,0x80006
80001d80:	6b090513          	addi	a0,s2,1712 # 800066b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b1>
	key = (mstatus & SOC_MSTATUS_IEN);
80001d84:	00847413          	andi	s0,s0,8
80001d88:	571020ef          	jal	ra,80004af8 <z_spin_lock_valid>
80001d8c:	02051e63          	bnez	a0,80001dc8 <timer_isr+0x74>
80001d90:	800064b7          	lui	s1,0x80006
80001d94:	800065b7          	lui	a1,0x80006
80001d98:	80006537          	lui	a0,0x80006
80001d9c:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80001da0:	04e00693          	li	a3,78
80001da4:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80001da8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80001dac:	e2dff0ef          	jal	ra,80001bd8 <printk>
80001db0:	80006537          	lui	a0,0x80006
80001db4:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80001db8:	e21ff0ef          	jal	ra,80001bd8 <printk>
80001dbc:	04e00593          	li	a1,78
80001dc0:	04048513          	addi	a0,s1,64
80001dc4:	e51ff0ef          	jal	ra,80001c14 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001dc8:	6b090513          	addi	a0,s2,1712
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001dcc:	800064b7          	lui	s1,0x80006
80001dd0:	581020ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
80001dd4:	68848493          	addi	s1,s1,1672 # 80006688 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006689>
	u64_t now = mtime();
80001dd8:	f65ff0ef          	jal	ra,80001d3c <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001ddc:	0004a983          	lw	s3,0(s1)
80001de0:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001de4:	00050793          	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001de8:	41350533          	sub	a0,a0,s3
80001dec:	00a7b7b3          	sltu	a5,a5,a0
80001df0:	415585b3          	sub	a1,a1,s5
80001df4:	0001d637          	lui	a2,0x1d
80001df8:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001dfc:	00000693          	li	a3,0
80001e00:	40f585b3          	sub	a1,a1,a5
80001e04:	cacfe0ef          	jal	ra,800002b0 <__udivdi3>
80001e08:	00050a13          	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80001e0c:	0001d5b7          	lui	a1,0x1d
80001e10:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001e14:	000a0513          	mv	a0,s4
80001e18:	a6dfe0ef          	jal	ra,80000884 <__mulsi3>
80001e1c:	013509b3          	add	s3,a0,s3
80001e20:	00a9b533          	sltu	a0,s3,a0
80001e24:	01550533          	add	a0,a0,s5
80001e28:	00a4a223          	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001e2c:	6b090513          	addi	a0,s2,1712
80001e30:	0134a023          	sw	s3,0(s1)
80001e34:	4ed020ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80001e38:	02051e63          	bnez	a0,80001e74 <timer_isr+0x120>
80001e3c:	800064b7          	lui	s1,0x80006
80001e40:	800065b7          	lui	a1,0x80006
80001e44:	80006537          	lui	a0,0x80006
80001e48:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80001e4c:	06100693          	li	a3,97
80001e50:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80001e54:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80001e58:	d81ff0ef          	jal	ra,80001bd8 <printk>
80001e5c:	80006537          	lui	a0,0x80006
80001e60:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80001e64:	d75ff0ef          	jal	ra,80001bd8 <printk>
80001e68:	06100593          	li	a1,97
80001e6c:	04048513          	addi	a0,s1,64
80001e70:	da5ff0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001e74:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80001e78:	01812403          	lw	s0,24(sp)
80001e7c:	01c12083          	lw	ra,28(sp)
80001e80:	01412483          	lw	s1,20(sp)
80001e84:	01012903          	lw	s2,16(sp)
80001e88:	00c12983          	lw	s3,12(sp)
80001e8c:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001e90:	000a0513          	mv	a0,s4
}
80001e94:	00812a03          	lw	s4,8(sp)
80001e98:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001e9c:	6a80306f          	j	80005544 <z_clock_announce>

80001ea0 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80001ea0:	ff010113          	addi	sp,sp,-16
80001ea4:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001ea8:	e95ff0ef          	jal	ra,80001d3c <mtime>
80001eac:	0001d7b7          	lui	a5,0x1d
80001eb0:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001eb4:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001eb8:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80001ebc:	fff00693          	li	a3,-1
80001ec0:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001ec4:	00a7b533          	sltu	a0,a5,a0
80001ec8:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80001ecc:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001ed0:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80001ed4:	00700513          	li	a0,7
80001ed8:	d81ff0ef          	jal	ra,80001c58 <z_arch_irq_enable>
	return 0;
}
80001edc:	00c12083          	lw	ra,12(sp)
80001ee0:	00000513          	li	a0,0
80001ee4:	01010113          	addi	sp,sp,16
80001ee8:	00008067          	ret

80001eec <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001eec:	1a059263          	bnez	a1,80002090 <z_clock_set_timeout+0x1a4>
{
80001ef0:	fe010113          	addi	sp,sp,-32
80001ef4:	00112e23          	sw	ra,28(sp)
80001ef8:	00812c23          	sw	s0,24(sp)
80001efc:	00912a23          	sw	s1,20(sp)
80001f00:	01212823          	sw	s2,16(sp)
80001f04:	01312623          	sw	s3,12(sp)
80001f08:	01412423          	sw	s4,8(sp)
80001f0c:	01512223          	sw	s5,4(sp)
80001f10:	01612023          	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80001f14:	fff00793          	li	a5,-1
80001f18:	00f51663          	bne	a0,a5,80001f24 <z_clock_set_timeout+0x38>
80001f1c:	00009537          	lui	a0,0x9
80001f20:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80001f24:	000097b7          	lui	a5,0x9
80001f28:	fff50413          	addi	s0,a0,-1
80001f2c:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80001f30:	1487da63          	bge	a5,s0,80002084 <z_clock_set_timeout+0x198>
80001f34:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001f38:	00800913          	li	s2,8
80001f3c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001f40:	80006ab7          	lui	s5,0x80006
80001f44:	6b0a8513          	addi	a0,s5,1712 # 800066b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b1>
	key = (mstatus & SOC_MSTATUS_IEN);
80001f48:	00897913          	andi	s2,s2,8
80001f4c:	3ad020ef          	jal	ra,80004af8 <z_spin_lock_valid>
80001f50:	02051e63          	bnez	a0,80001f8c <z_clock_set_timeout+0xa0>
80001f54:	800064b7          	lui	s1,0x80006
80001f58:	800065b7          	lui	a1,0x80006
80001f5c:	80006537          	lui	a0,0x80006
80001f60:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80001f64:	04e00693          	li	a3,78
80001f68:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80001f6c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80001f70:	c69ff0ef          	jal	ra,80001bd8 <printk>
80001f74:	80006537          	lui	a0,0x80006
80001f78:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80001f7c:	c5dff0ef          	jal	ra,80001bd8 <printk>
80001f80:	04e00593          	li	a1,78
80001f84:	04048513          	addi	a0,s1,64
80001f88:	c8dff0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80001f8c:	6b0a8513          	addi	a0,s5,1712
80001f90:	3c1020ef          	jal	ra,80004b50 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80001f94:	da9ff0ef          	jal	ra,80001d3c <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001f98:	800067b7          	lui	a5,0x80006
80001f9c:	68878793          	addi	a5,a5,1672 # 80006688 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006689>
	u32_t cyc = ticks * CYC_PER_TICK;
80001fa0:	0001d4b7          	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001fa4:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80001fa8:	00050a13          	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80001fac:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001fb0:	00040513          	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001fb4:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001fb8:	8cdfe0ef          	jal	ra,80000884 <__mulsi3>
80001fbc:	4bf48793          	addi	a5,s1,1215
80001fc0:	413787b3          	sub	a5,a5,s3
80001fc4:	00f50533          	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001fc8:	4c048593          	addi	a1,s1,1216
80001fcc:	00aa0533          	add	a0,s4,a0
80001fd0:	8e1fe0ef          	jal	ra,800008b0 <__udivsi3>
80001fd4:	4c048593          	addi	a1,s1,1216
80001fd8:	8adfe0ef          	jal	ra,80000884 <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001fdc:	41498a33          	sub	s4,s3,s4
80001fe0:	00aa0a33          	add	s4,s4,a0
80001fe4:	3e700793          	li	a5,999
80001fe8:	0147c663          	blt	a5,s4,80001ff4 <z_clock_set_timeout+0x108>
		cyc += CYC_PER_TICK;
80001fec:	4c048493          	addi	s1,s1,1216
80001ff0:	00950533          	add	a0,a0,s1
	r[1] = 0xffffffff;
80001ff4:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80001ff8:	013509b3          	add	s3,a0,s3
	r[1] = 0xffffffff;
80001ffc:	fff00713          	li	a4,-1
80002000:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002004:	00a9b533          	sltu	a0,s3,a0
80002008:	01650533          	add	a0,a0,s6
	r[0] = (u32_t)time;
8000200c:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80002010:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002014:	6b0a8513          	addi	a0,s5,1712
80002018:	309020ef          	jal	ra,80004b20 <z_spin_unlock_valid>
8000201c:	02051e63          	bnez	a0,80002058 <z_clock_set_timeout+0x16c>
80002020:	80006437          	lui	s0,0x80006
80002024:	800065b7          	lui	a1,0x80006
80002028:	80006537          	lui	a0,0x80006
8000202c:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80002030:	06100693          	li	a3,97
80002034:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80002038:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000203c:	b9dff0ef          	jal	ra,80001bd8 <printk>
80002040:	80006537          	lui	a0,0x80006
80002044:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80002048:	b91ff0ef          	jal	ra,80001bd8 <printk>
8000204c:	06100593          	li	a1,97
80002050:	04040513          	addi	a0,s0,64
80002054:	bc1ff0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002058:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
8000205c:	01c12083          	lw	ra,28(sp)
80002060:	01812403          	lw	s0,24(sp)
80002064:	01412483          	lw	s1,20(sp)
80002068:	01012903          	lw	s2,16(sp)
8000206c:	00c12983          	lw	s3,12(sp)
80002070:	00812a03          	lw	s4,8(sp)
80002074:	00412a83          	lw	s5,4(sp)
80002078:	00012b03          	lw	s6,0(sp)
8000207c:	02010113          	addi	sp,sp,32
80002080:	00008067          	ret
80002084:	ea045ae3          	bgez	s0,80001f38 <z_clock_set_timeout+0x4c>
80002088:	00000413          	li	s0,0
8000208c:	eadff06f          	j	80001f38 <z_clock_set_timeout+0x4c>
80002090:	00008067          	ret

80002094 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002094:	ff010113          	addi	sp,sp,-16
80002098:	00812423          	sw	s0,8(sp)
8000209c:	00112623          	sw	ra,12(sp)
800020a0:	00912223          	sw	s1,4(sp)
800020a4:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800020a8:	00800413          	li	s0,8
800020ac:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800020b0:	800064b7          	lui	s1,0x80006
800020b4:	6b048513          	addi	a0,s1,1712 # 800066b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b1>
	key = (mstatus & SOC_MSTATUS_IEN);
800020b8:	00847413          	andi	s0,s0,8
800020bc:	23d020ef          	jal	ra,80004af8 <z_spin_lock_valid>
800020c0:	02051e63          	bnez	a0,800020fc <z_clock_elapsed+0x68>
800020c4:	80006937          	lui	s2,0x80006
800020c8:	800065b7          	lui	a1,0x80006
800020cc:	80006537          	lui	a0,0x80006
800020d0:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800020d4:	04e00693          	li	a3,78
800020d8:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800020dc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800020e0:	af9ff0ef          	jal	ra,80001bd8 <printk>
800020e4:	80006537          	lui	a0,0x80006
800020e8:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
800020ec:	aedff0ef          	jal	ra,80001bd8 <printk>
800020f0:	04e00593          	li	a1,78
800020f4:	04090513          	addi	a0,s2,64
800020f8:	b1dff0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
800020fc:	6b048513          	addi	a0,s1,1712
80002100:	251020ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80002104:	c39ff0ef          	jal	ra,80001d3c <mtime>
80002108:	800067b7          	lui	a5,0x80006
8000210c:	6887a783          	lw	a5,1672(a5) # 80006688 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006689>
80002110:	0001d5b7          	lui	a1,0x1d
80002114:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002118:	40f50533          	sub	a0,a0,a5
8000211c:	f94fe0ef          	jal	ra,800008b0 <__udivsi3>
80002120:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002124:	6b048513          	addi	a0,s1,1712
80002128:	1f9020ef          	jal	ra,80004b20 <z_spin_unlock_valid>
8000212c:	02051e63          	bnez	a0,80002168 <z_clock_elapsed+0xd4>
80002130:	800064b7          	lui	s1,0x80006
80002134:	800065b7          	lui	a1,0x80006
80002138:	80006537          	lui	a0,0x80006
8000213c:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80002140:	06100693          	li	a3,97
80002144:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80002148:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000214c:	a8dff0ef          	jal	ra,80001bd8 <printk>
80002150:	80006537          	lui	a0,0x80006
80002154:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80002158:	a81ff0ef          	jal	ra,80001bd8 <printk>
8000215c:	06100593          	li	a1,97
80002160:	04048513          	addi	a0,s1,64
80002164:	ab1ff0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002168:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
8000216c:	00c12083          	lw	ra,12(sp)
80002170:	00812403          	lw	s0,8(sp)
80002174:	00090513          	mv	a0,s2
80002178:	00412483          	lw	s1,4(sp)
8000217c:	00012903          	lw	s2,0(sp)
80002180:	01010113          	addi	sp,sp,16
80002184:	00008067          	ret

80002188 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002188:	00054783          	lbu	a5,0(a0)
8000218c:	0005c703          	lbu	a4,0(a1)
80002190:	00e79463          	bne	a5,a4,80002198 <strcmp+0x10>
80002194:	00079663          	bnez	a5,800021a0 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002198:	40e78533          	sub	a0,a5,a4
8000219c:	00008067          	ret
		s1++;
800021a0:	00150513          	addi	a0,a0,1
		s2++;
800021a4:	00158593          	addi	a1,a1,1
800021a8:	fe1ff06f          	j	80002188 <strcmp>

800021ac <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
800021ac:	00b547b3          	xor	a5,a0,a1
800021b0:	0037f793          	andi	a5,a5,3
800021b4:	04078c63          	beqz	a5,8000220c <memcpy+0x60>
	unsigned char *d_byte = (unsigned char *)d;
800021b8:	00050793          	mv	a5,a0
800021bc:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
800021c0:	06e61663          	bne	a2,a4,8000222c <memcpy+0x80>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
800021c4:	00008067          	ret
			if (n == 0) {
800021c8:	fe060ee3          	beqz	a2,800021c4 <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
800021cc:	00158593          	addi	a1,a1,1
800021d0:	fff5c703          	lbu	a4,-1(a1)
800021d4:	00178793          	addi	a5,a5,1
			n--;
800021d8:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
800021dc:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
800021e0:	0037f713          	andi	a4,a5,3
800021e4:	fe0712e3          	bnez	a4,800021c8 <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
800021e8:	00300693          	li	a3,3
800021ec:	40e60833          	sub	a6,a2,a4
800021f0:	0306e263          	bltu	a3,a6,80002214 <memcpy+0x68>
800021f4:	00265713          	srli	a4,a2,0x2
800021f8:	00271693          	slli	a3,a4,0x2
800021fc:	40d60633          	sub	a2,a2,a3
80002200:	00d787b3          	add	a5,a5,a3
80002204:	00d585b3          	add	a1,a1,a3
80002208:	fb5ff06f          	j	800021bc <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
8000220c:	00050793          	mv	a5,a0
80002210:	fd1ff06f          	j	800021e0 <memcpy+0x34>
			*(d_word++) = *(s_word++);
80002214:	00e588b3          	add	a7,a1,a4
80002218:	0008a883          	lw	a7,0(a7)
8000221c:	00e78833          	add	a6,a5,a4
80002220:	00470713          	addi	a4,a4,4
80002224:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80002228:	fc5ff06f          	j	800021ec <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
8000222c:	00e58833          	add	a6,a1,a4
80002230:	00084803          	lbu	a6,0(a6)
80002234:	00e786b3          	add	a3,a5,a4
80002238:	00170713          	addi	a4,a4,1
8000223c:	01068023          	sb	a6,0(a3)
		n--;
80002240:	f81ff06f          	j	800021c0 <memcpy+0x14>

80002244 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002244:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002248:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
8000224c:	0037f713          	andi	a4,a5,3
80002250:	04071463          	bnez	a4,80002298 <memset+0x54>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002254:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002258:	00859713          	slli	a4,a1,0x8
8000225c:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002260:	01059713          	slli	a4,a1,0x10
80002264:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002268:	00c78333          	add	t1,a5,a2
8000226c:	00078713          	mv	a4,a5
80002270:	00300813          	li	a6,3
80002274:	40e308b3          	sub	a7,t1,a4
80002278:	03186a63          	bltu	a6,a7,800022ac <memset+0x68>
8000227c:	00265713          	srli	a4,a2,0x2
80002280:	00271593          	slli	a1,a4,0x2
80002284:	00b787b3          	add	a5,a5,a1
80002288:	40b60633          	sub	a2,a2,a1
8000228c:	00c78633          	add	a2,a5,a2

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002290:	02c79463          	bne	a5,a2,800022b8 <memset+0x74>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002294:	00008067          	ret
		if (n == 0) {
80002298:	fe060ee3          	beqz	a2,80002294 <memset+0x50>
		*(d_byte++) = c_byte;
8000229c:	00178793          	addi	a5,a5,1
800022a0:	fed78fa3          	sb	a3,-1(a5)
		n--;
800022a4:	fff60613          	addi	a2,a2,-1
800022a8:	fa5ff06f          	j	8000224c <memset+0x8>
		*(d_word++) = c_word;
800022ac:	00470713          	addi	a4,a4,4
800022b0:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
800022b4:	fc1ff06f          	j	80002274 <memset+0x30>
		*(d_byte++) = c_byte;
800022b8:	00178793          	addi	a5,a5,1
800022bc:	fed78fa3          	sb	a3,-1(a5)
		n--;
800022c0:	fd1ff06f          	j	80002290 <memset+0x4c>

800022c4 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
800022c4:	fff00513          	li	a0,-1
800022c8:	00008067          	ret

800022cc <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
800022cc:	800067b7          	lui	a5,0x80006
800022d0:	5ca7a623          	sw	a0,1484(a5) # 800065cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065cd>
}
800022d4:	00008067          	ret

800022d8 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
800022d8:	fe010113          	addi	sp,sp,-32
800022dc:	00812c23          	sw	s0,24(sp)
	test->setup();
800022e0:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
800022e4:	80006437          	lui	s0,0x80006
{
800022e8:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
800022ec:	5d040413          	addi	s0,s0,1488 # 800065d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d1>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
800022f0:	800064b7          	lui	s1,0x80006
{
800022f4:	00112e23          	sw	ra,28(sp)
800022f8:	01212823          	sw	s2,16(sp)
800022fc:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002300:	6b448493          	addi	s1,s1,1716 # 800066b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b5>
80002304:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80002308:	00042023          	sw	zero,0(s0)
{
8000230c:	00050913          	mv	s2,a0
	test_result = 1;
80002310:	0134a023          	sw	s3,0(s1)
	test->setup();
80002314:	000780e7          	jalr	a5
	test->test();
80002318:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
8000231c:	01342023          	sw	s3,0(s0)
	test->test();
80002320:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80002324:	00200793          	li	a5,2
80002328:	00f42023          	sw	a5,0(s0)
	test->teardown();
8000232c:	00c92783          	lw	a5,12(s2)
80002330:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002334:	00300793          	li	a5,3
80002338:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
8000233c:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002340:	0004a023          	sw	zero,0(s1)
}
80002344:	01c12083          	lw	ra,28(sp)
80002348:	01412483          	lw	s1,20(sp)
8000234c:	01012903          	lw	s2,16(sp)
80002350:	00c12983          	lw	s3,12(sp)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002354:	80007537          	lui	a0,0x80007
80002358:	82450513          	addi	a0,a0,-2012 # 80006824 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006825>
8000235c:	02010113          	addi	sp,sp,32
80002360:	2480206f          	j	800045a8 <z_impl_k_sem_give>

80002364 <ztest_test_fail>:
80002364:	80007537          	lui	a0,0x80007
{
80002368:	ff010113          	addi	sp,sp,-16
	test_result = -1;
8000236c:	800067b7          	lui	a5,0x80006
80002370:	fff00713          	li	a4,-1
80002374:	82450513          	addi	a0,a0,-2012 # 80006824 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006825>
{
80002378:	00112623          	sw	ra,12(sp)
	test_result = -1;
8000237c:	6ae7aa23          	sw	a4,1716(a5) # 800066b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b5>
80002380:	228020ef          	jal	ra,800045a8 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002384:	150020ef          	jal	ra,800044d4 <z_impl_k_current_get>
}
80002388:	00c12083          	lw	ra,12(sp)
8000238c:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002390:	2f10206f          	j	80004e80 <z_impl_k_thread_abort>

80002394 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80002394:	fa010113          	addi	sp,sp,-96
80002398:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
8000239c:	800064b7          	lui	s1,0x80006
800023a0:	6b84a783          	lw	a5,1720(s1) # 800066b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b9>
{
800023a4:	04112e23          	sw	ra,92(sp)
800023a8:	04812c23          	sw	s0,88(sp)
800023ac:	05212823          	sw	s2,80(sp)
800023b0:	05312623          	sw	s3,76(sp)
800023b4:	05412423          	sw	s4,72(sp)
800023b8:	05512223          	sw	s5,68(sp)
800023bc:	05612023          	sw	s6,64(sp)
800023c0:	03712e23          	sw	s7,60(sp)
800023c4:	03812c23          	sw	s8,56(sp)
800023c8:	03912a23          	sw	s9,52(sp)
800023cc:	03a12823          	sw	s10,48(sp)
800023d0:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
800023d4:	0807c463          	bltz	a5,8000245c <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
800023d8:	80007437          	lui	s0,0x80007
800023dc:	00100613          	li	a2,1
800023e0:	00050993          	mv	s3,a0
800023e4:	00058c13          	mv	s8,a1
800023e8:	82440513          	addi	a0,s0,-2012 # 80006824 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006825>
800023ec:	00000593          	li	a1,0
800023f0:	0f0020ef          	jal	ra,800044e0 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
800023f4:	80006537          	lui	a0,0x80006
800023f8:	00098593          	mv	a1,s3
800023fc:	0fc50513          	addi	a0,a0,252 # 800060fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060fd>
80002400:	fd8ff0ef          	jal	ra,80001bd8 <printk>
	PRINT_LINE;
80002404:	80006937          	lui	s2,0x80006
80002408:	11490513          	addi	a0,s2,276 # 80006114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006115>
		Z_TC_END_RESULT(ret, test->name);
8000240c:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
80002410:	fc8ff0ef          	jal	ra,80001bd8 <printk>
80002414:	6b848493          	addi	s1,s1,1720
	int fail = 0;
80002418:	00000a13          	li	s4,0
8000241c:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002420:	80007cb7          	lui	s9,0x80007
80002424:	80007b37          	lui	s6,0x80007
80002428:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
8000242c:	80006db7          	lui	s11,0x80006
80002430:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
80002434:	0b4a8a93          	addi	s5,s5,180 # 800060b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060b5>
	while (suite->test) {
80002438:	004c2783          	lw	a5,4(s8)
8000243c:	04079e63          	bnez	a5,80002498 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002440:	00098593          	mv	a1,s3
	if (fail) {
80002444:	100a0663          	beqz	s4,80002550 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002448:	80006537          	lui	a0,0x80006
8000244c:	18450513          	addi	a0,a0,388 # 80006184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006185>
80002450:	f88ff0ef          	jal	ra,80001bd8 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002454:	00100793          	li	a5,1
80002458:	00f4a023          	sw	a5,0(s1)
}
8000245c:	05c12083          	lw	ra,92(sp)
80002460:	05812403          	lw	s0,88(sp)
80002464:	05412483          	lw	s1,84(sp)
80002468:	05012903          	lw	s2,80(sp)
8000246c:	04c12983          	lw	s3,76(sp)
80002470:	04812a03          	lw	s4,72(sp)
80002474:	04412a83          	lw	s5,68(sp)
80002478:	04012b03          	lw	s6,64(sp)
8000247c:	03c12b83          	lw	s7,60(sp)
80002480:	03812c03          	lw	s8,56(sp)
80002484:	03412c83          	lw	s9,52(sp)
80002488:	03012d03          	lw	s10,48(sp)
8000248c:	02c12d83          	lw	s11,44(sp)
80002490:	06010113          	addi	sp,sp,96
80002494:	00008067          	ret
	TC_START(test->name);
80002498:	000c2583          	lw	a1,0(s8)
8000249c:	800067b7          	lui	a5,0x80006
800024a0:	15c78513          	addi	a0,a5,348 # 8000615c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000615d>
800024a4:	f34ff0ef          	jal	ra,80001bd8 <printk>
800024a8:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
800024ac:	010c2783          	lw	a5,16(s8)
800024b0:	000c0713          	mv	a4,s8
800024b4:	40000613          	li	a2,1024
800024b8:	0087e793          	ori	a5,a5,8
800024bc:	fff00893          	li	a7,-1
800024c0:	00000813          	li	a6,0
800024c4:	2d8d0693          	addi	a3,s10,728 # 800022d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800022d9>
800024c8:	00f12023          	sw	a5,0(sp)
800024cc:	bb0c8593          	addi	a1,s9,-1104 # 80006bb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bb1>
800024d0:	00000793          	li	a5,0
800024d4:	834b0513          	addi	a0,s6,-1996 # 80006834 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006835>
800024d8:	005020ef          	jal	ra,80004cdc <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800024dc:	01c12783          	lw	a5,28(sp)
800024e0:	fff00593          	li	a1,-1
800024e4:	82478513          	addi	a0,a5,-2012
800024e8:	1a4020ef          	jal	ra,8000468c <z_impl_k_sem_take>
	if (test_result == -1) {
800024ec:	6b4d8793          	addi	a5,s11,1716 # 800066b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b5>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800024f0:	834b0513          	addi	a0,s6,-1996
800024f4:	0007a403          	lw	s0,0(a5)
800024f8:	189020ef          	jal	ra,80004e80 <z_impl_k_thread_abort>
	if (test_result == -2) {
800024fc:	800067b7          	lui	a5,0x80006
80002500:	6b478793          	addi	a5,a5,1716 # 800066b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b5>
80002504:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80002508:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
8000250c:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80002510:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80002514:	000c2603          	lw	a2,0(s8)
80002518:	02f71463          	bne	a4,a5,80002540 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
8000251c:	800065b7          	lui	a1,0x80006
80002520:	17058593          	addi	a1,a1,368 # 80006170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006171>
		Z_TC_END_RESULT(ret, test->name);
80002524:	178b8513          	addi	a0,s7,376 # 80006178 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006179>
80002528:	eb0ff0ef          	jal	ra,80001bd8 <printk>
8000252c:	11490513          	addi	a0,s2,276
80002530:	ea8ff0ef          	jal	ra,80001bd8 <printk>
		fail += run_test(suite);
80002534:	008a0a33          	add	s4,s4,s0
		suite++;
80002538:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
8000253c:	efdff06f          	j	80002438 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80002540:	00241793          	slli	a5,s0,0x2
80002544:	00fa87b3          	add	a5,s5,a5
80002548:	0007a583          	lw	a1,0(a5)
8000254c:	fd9ff06f          	j	80002524 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80002550:	80006537          	lui	a0,0x80006
80002554:	19c50513          	addi	a0,a0,412 # 8000619c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000619d>
80002558:	e80ff0ef          	jal	ra,80001bd8 <printk>
	test_status = (test_status || fail) ? 1 : 0;
8000255c:	0004a783          	lw	a5,0(s1)
80002560:	00f037b3          	snez	a5,a5
80002564:	ef5ff06f          	j	80002458 <z_ztest_run_test_suite+0xc4>

80002568 <end_report>:

void end_report(void)
{
	if (test_status) {
80002568:	800067b7          	lui	a5,0x80006
8000256c:	6b87a783          	lw	a5,1720(a5) # 800066b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066b9>
{
80002570:	ff010113          	addi	sp,sp,-16
80002574:	00812423          	sw	s0,8(sp)
80002578:	80006537          	lui	a0,0x80006
8000257c:	00112623          	sw	ra,12(sp)
80002580:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
80002584:	11450513          	addi	a0,a0,276 # 80006114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006115>
	if (test_status) {
80002588:	02078263          	beqz	a5,800025ac <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
8000258c:	e4cff0ef          	jal	ra,80001bd8 <printk>
80002590:	800065b7          	lui	a1,0x80006
80002594:	0c058593          	addi	a1,a1,192 # 800060c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c1>
	} else {
		TC_END_REPORT(TC_PASS);
80002598:	0c840513          	addi	a0,s0,200 # 800060c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c9>
	}
}
8000259c:	00812403          	lw	s0,8(sp)
800025a0:	00c12083          	lw	ra,12(sp)
800025a4:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
800025a8:	e30ff06f          	j	80001bd8 <printk>
800025ac:	e2cff0ef          	jal	ra,80001bd8 <printk>
800025b0:	800065b7          	lui	a1,0x80006
800025b4:	0e058593          	addi	a1,a1,224 # 800060e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e1>
800025b8:	fe1ff06f          	j	80002598 <end_report+0x30>

800025bc <main>:

	return test_status;
}
#else
void main(void)
{
800025bc:	ff010113          	addi	sp,sp,-16
800025c0:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
800025c4:	eccfe0ef          	jal	ra,80000c90 <test_main>
	end_report();
}
800025c8:	00c12083          	lw	ra,12(sp)
800025cc:	01010113          	addi	sp,sp,16
	end_report();
800025d0:	f99ff06f          	j	80002568 <end_report>

800025d4 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
800025d4:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
800025d8:	00012623          	sw	zero,12(sp)
    i++;
800025dc:	00c12783          	lw	a5,12(sp)
800025e0:	00178793          	addi	a5,a5,1
800025e4:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
800025e8:	f00107b7          	lui	a5,0xf0010
800025ec:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
800025f0:	01010113          	addi	sp,sp,16
800025f4:	00008067          	ret

800025f8 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
800025f8:	fff00513          	li	a0,-1
800025fc:	00008067          	ret

80002600 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002600:	00000513          	li	a0,0
80002604:	00008067          	ret

80002608 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002608:	00251713          	slli	a4,a0,0x2
8000260c:	800067b7          	lui	a5,0x80006
80002610:	00150513          	addi	a0,a0,1
80002614:	1cc78793          	addi	a5,a5,460 # 800061cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061cd>
80002618:	00251513          	slli	a0,a0,0x2
{
8000261c:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002620:	00e78733          	add	a4,a5,a4
80002624:	00a787b3          	add	a5,a5,a0
{
80002628:	00812423          	sw	s0,8(sp)
8000262c:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002630:	00072403          	lw	s0,0(a4)
80002634:	0007a483          	lw	s1,0(a5)
{
80002638:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
8000263c:	00946c63          	bltu	s0,s1,80002654 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002640:	00c12083          	lw	ra,12(sp)
80002644:	00812403          	lw	s0,8(sp)
80002648:	00412483          	lw	s1,4(sp)
8000264c:	01010113          	addi	sp,sp,16
80002650:	00008067          	ret
		retval = device_conf->init(info);
80002654:	00042783          	lw	a5,0(s0)
80002658:	00040513          	mv	a0,s0
8000265c:	0047a783          	lw	a5,4(a5)
80002660:	000780e7          	jalr	a5
		if (retval != 0) {
80002664:	00050463          	beqz	a0,8000266c <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002668:	00042223          	sw	zero,4(s0)
								info++) {
8000266c:	00c40413          	addi	s0,s0,12
80002670:	fcdff06f          	j	8000263c <z_sys_device_do_config_level+0x34>

80002674 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002674:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002678:	800067b7          	lui	a5,0x80006
{
8000267c:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002680:	800064b7          	lui	s1,0x80006
{
80002684:	00812423          	sw	s0,8(sp)
80002688:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
8000268c:	5e478413          	addi	s0,a5,1508 # 800065e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e5>
{
80002690:	01212023          	sw	s2,0(sp)
80002694:	5e478793          	addi	a5,a5,1508
80002698:	62048493          	addi	s1,s1,1568 # 80006620 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006621>
	for (info = __device_init_start; info != __device_init_end; info++) {
8000269c:	00941c63          	bne	s0,s1,800026b4 <z_impl_device_get_binding+0x40>
800026a0:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
800026a4:	00078413          	mv	s0,a5
800026a8:	02941463          	bne	s0,s1,800026d0 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
800026ac:	00000413          	li	s0,0
800026b0:	0440006f          	j	800026f4 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
800026b4:	00442703          	lw	a4,4(s0)
800026b8:	00070863          	beqz	a4,800026c8 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
800026bc:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
800026c0:	00072703          	lw	a4,0(a4)
800026c4:	02a70863          	beq	a4,a0,800026f4 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
800026c8:	00c40413          	addi	s0,s0,12
800026cc:	fd1ff06f          	j	8000269c <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
800026d0:	00442783          	lw	a5,4(s0)
800026d4:	00079663          	bnez	a5,800026e0 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
800026d8:	00c40413          	addi	s0,s0,12
800026dc:	fcdff06f          	j	800026a8 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
800026e0:	00042783          	lw	a5,0(s0)
800026e4:	00090513          	mv	a0,s2
800026e8:	0007a583          	lw	a1,0(a5)
800026ec:	a9dff0ef          	jal	ra,80002188 <strcmp>
800026f0:	fe0514e3          	bnez	a0,800026d8 <z_impl_device_get_binding+0x64>
}
800026f4:	00040513          	mv	a0,s0
800026f8:	00c12083          	lw	ra,12(sp)
800026fc:	00812403          	lw	s0,8(sp)
80002700:	00412483          	lw	s1,4(sp)
80002704:	00012903          	lw	s2,0(sp)
80002708:	01010113          	addi	sp,sp,16
8000270c:	00008067          	ret

80002710 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002710:	ff010113          	addi	sp,sp,-16
80002714:	00812423          	sw	s0,8(sp)
80002718:	00912223          	sw	s1,4(sp)
8000271c:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002720:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002724:	00200493          	li	s1,2
80002728:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
8000272c:	439020ef          	jal	ra,80005364 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002730:	00a4c463          	blt	s1,a0,80002738 <idle+0x28>
80002734:	00100513          	li	a0,1
80002738:	00100593          	li	a1,1
8000273c:	505020ef          	jal	ra,80005440 <z_set_timeout_expiry>
	k_cpu_idle();
80002740:	d08ff0ef          	jal	ra,80001c48 <k_cpu_idle>
80002744:	fe5ff06f          	j	80002728 <idle+0x18>

80002748 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002748:	80006537          	lui	a0,0x80006
8000274c:	800077b7          	lui	a5,0x80007
80002750:	68850613          	addi	a2,a0,1672 # 80006688 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006689>
80002754:	9b078793          	addi	a5,a5,-1616 # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
80002758:	40c78633          	sub	a2,a5,a2
8000275c:	00000593          	li	a1,0
80002760:	68850513          	addi	a0,a0,1672
80002764:	ae1ff06f          	j	80002244 <memset>

80002768 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002768:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
8000276c:	00200513          	li	a0,2
{
80002770:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002774:	e95ff0ef          	jal	ra,80002608 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002778:	80006537          	lui	a0,0x80006
8000277c:	1e050513          	addi	a0,a0,480 # 800061e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061e1>
80002780:	c58ff0ef          	jal	ra,80001bd8 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002784:	00300513          	li	a0,3
80002788:	e81ff0ef          	jal	ra,80002608 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
8000278c:	644020ef          	jal	ra,80004dd0 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002790:	e2dff0ef          	jal	ra,800025bc <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002794:	800077b7          	lui	a5,0x80007
80002798:	91478793          	addi	a5,a5,-1772 # 80006914 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006915>
8000279c:	00c7c703          	lbu	a4,12(a5)
800027a0:	ffe77713          	andi	a4,a4,-2
800027a4:	00e78623          	sb	a4,12(a5)
}
800027a8:	00c12083          	lw	ra,12(sp)
800027ac:	01010113          	addi	sp,sp,16
800027b0:	00008067          	ret

800027b4 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
800027b4:	f6010113          	addi	sp,sp,-160
800027b8:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
800027bc:	800087b7          	lui	a5,0x80008
800027c0:	80007437          	lui	s0,0x80007
800027c4:	09312623          	sw	s3,140(sp)
800027c8:	bb078793          	addi	a5,a5,-1104 # 80007bb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bb1>
800027cc:	98440993          	addi	s3,s0,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
800027d0:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
800027d4:	01010793          	addi	a5,sp,16
800027d8:	07000613          	li	a2,112
800027dc:	00000593          	li	a1,0
800027e0:	00078513          	mv	a0,a5
{
800027e4:	08112e23          	sw	ra,156(sp)
800027e8:	08912a23          	sw	s1,148(sp)
800027ec:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
800027f0:	a55ff0ef          	jal	ra,80002244 <memset>
800027f4:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800027f8:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800027fc:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80002800:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002804:	e05ff0ef          	jal	ra,80002608 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002808:	00100513          	li	a0,1
8000280c:	dfdff0ef          	jal	ra,80002608 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002810:	10100793          	li	a5,257
80002814:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002818:	49d010ef          	jal	ra,800044b4 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
8000281c:	800067b7          	lui	a5,0x80006
80002820:	22478793          	addi	a5,a5,548 # 80006224 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006225>
	_kernel.ready_q.cache = _main_thread;
80002824:	80007937          	lui	s2,0x80007
	z_setup_new_thread(_main_thread, _main_stack,
80002828:	00f12223          	sw	a5,4(sp)
8000282c:	800026b7          	lui	a3,0x80002
80002830:	00100793          	li	a5,1
80002834:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002838:	91490493          	addi	s1,s2,-1772 # 80006914 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006915>
	z_setup_new_thread(_main_thread, _main_stack,
8000283c:	00f12023          	sw	a5,0(sp)
80002840:	00000713          	li	a4,0
80002844:	00000793          	li	a5,0
80002848:	00000893          	li	a7,0
8000284c:	00000813          	li	a6,0
80002850:	76868693          	addi	a3,a3,1896 # 80002768 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002769>
80002854:	20000613          	li	a2,512
80002858:	fb058593          	addi	a1,a1,-80 # 80006fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fb1>
8000285c:	91490513          	addi	a0,s2,-1772
	_kernel.ready_q.cache = _main_thread;
80002860:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002864:	1c8020ef          	jal	ra,80004a2c <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002868:	00d4c783          	lbu	a5,13(s1)
8000286c:	98440413          	addi	s0,s0,-1660
80002870:	ffb7f713          	andi	a4,a5,-5
80002874:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002878:	01b7f793          	andi	a5,a5,27
8000287c:	00079a63          	bnez	a5,80002890 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002880:	0184a783          	lw	a5,24(s1)
80002884:	00079663          	bnez	a5,80002890 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002888:	91490513          	addi	a0,s2,-1772
8000288c:	1a8010ef          	jal	ra,80003a34 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002890:	800067b7          	lui	a5,0x80006
80002894:	22c78793          	addi	a5,a5,556 # 8000622c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000622d>
80002898:	00f12223          	sw	a5,4(sp)
8000289c:	80007537          	lui	a0,0x80007
800028a0:	00100793          	li	a5,1
800028a4:	800026b7          	lui	a3,0x80002
800028a8:	800075b7          	lui	a1,0x80007
800028ac:	8a450493          	addi	s1,a0,-1884 # 800068a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a5>
800028b0:	00f12023          	sw	a5,0(sp)
800028b4:	00f00893          	li	a7,15
800028b8:	00000813          	li	a6,0
800028bc:	00000793          	li	a5,0
800028c0:	00000713          	li	a4,0
800028c4:	71068693          	addi	a3,a3,1808 # 80002710 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002711>
800028c8:	20000613          	li	a2,512
800028cc:	1b058593          	addi	a1,a1,432 # 800071b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071b1>
800028d0:	8a450513          	addi	a0,a0,-1884
800028d4:	158020ef          	jal	ra,80004a2c <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
800028d8:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
800028dc:	00942623          	sw	s1,12(s0)
800028e0:	00800513          	li	a0,8
800028e4:	ffb7f793          	andi	a5,a5,-5
800028e8:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
800028ec:	800077b7          	lui	a5,0x80007
800028f0:	99c78793          	addi	a5,a5,-1636 # 8000699c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000699d>
800028f4:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800028f8:	00f42e23          	sw	a5,28(s0)
800028fc:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002900:	00857513          	andi	a0,a0,8
80002904:	925fd0ef          	jal	ra,80000228 <__swap>

80002908 <mbox_message_match>:
static int mbox_message_match(struct k_mbox_msg *tx_msg,
			       struct k_mbox_msg *rx_msg)
{
	u32_t temp_info;

	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
80002908:	02052703          	lw	a4,32(a0)
{
8000290c:	00050793          	mv	a5,a0
	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
80002910:	00070863          	beqz	a4,80002920 <mbox_message_match+0x18>
80002914:	0205a683          	lw	a3,32(a1)
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;

		return 0;
	}

	return -1;
80002918:	fff00513          	li	a0,-1
	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
8000291c:	06d71863          	bne	a4,a3,8000298c <mbox_message_match+0x84>
	    ((rx_msg->rx_source_thread == (k_tid_t)K_ANY) ||
80002920:	01c5a683          	lw	a3,28(a1)
80002924:	01c7a703          	lw	a4,28(a5)
	     (tx_msg->tx_target_thread == rx_msg->tx_target_thread)) &&
80002928:	00068663          	beqz	a3,80002934 <mbox_message_match+0x2c>
	return -1;
8000292c:	fff00513          	li	a0,-1
	    ((rx_msg->rx_source_thread == (k_tid_t)K_ANY) ||
80002930:	04e69e63          	bne	a3,a4,8000298c <mbox_message_match+0x84>
		rx_msg->rx_source_thread = tx_msg->rx_source_thread;
80002934:	00e5ae23          	sw	a4,28(a1)
		tx_msg->tx_target_thread = rx_msg->tx_target_thread;
80002938:	0205a703          	lw	a4,32(a1)
		rx_msg->info = tx_msg->info;
8000293c:	0087a683          	lw	a3,8(a5)
		tx_msg->tx_target_thread = rx_msg->tx_target_thread;
80002940:	02e7a023          	sw	a4,32(a5)
		temp_info = rx_msg->info;
80002944:	0085a703          	lw	a4,8(a1)
		rx_msg->info = tx_msg->info;
80002948:	00d5a423          	sw	a3,8(a1)
		if (rx_msg->size > tx_msg->size) {
8000294c:	0045a683          	lw	a3,4(a1)
		tx_msg->info = temp_info;
80002950:	00e7a423          	sw	a4,8(a5)
		if (rx_msg->size > tx_msg->size) {
80002954:	0047a703          	lw	a4,4(a5)
80002958:	00d77463          	bgeu	a4,a3,80002960 <mbox_message_match+0x58>
			rx_msg->size = tx_msg->size;
8000295c:	00e5a223          	sw	a4,4(a1)
		rx_msg->tx_block = tx_msg->tx_block;
80002960:	0147a703          	lw	a4,20(a5)
		rx_msg->tx_data = tx_msg->tx_data;
80002964:	00c7a683          	lw	a3,12(a5)
		rx_msg->tx_block = tx_msg->tx_block;
80002968:	00e5aa23          	sw	a4,20(a1)
8000296c:	0187a603          	lw	a2,24(a5)
		rx_msg->tx_data = tx_msg->tx_data;
80002970:	00d5a623          	sw	a3,12(a1)
		rx_msg->tx_block = tx_msg->tx_block;
80002974:	00c5ac23          	sw	a2,24(a1)
		if (rx_msg->tx_data != NULL) {
80002978:	00068c63          	beqz	a3,80002990 <mbox_message_match+0x88>
			rx_msg->tx_block.data = NULL;
8000297c:	0005aa23          	sw	zero,20(a1)
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;
80002980:	0247a783          	lw	a5,36(a5)
		return 0;
80002984:	00000513          	li	a0,0
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;
80002988:	02f5a223          	sw	a5,36(a1)
}
8000298c:	00008067          	ret
		} else if (rx_msg->tx_block.data != NULL) {
80002990:	fe0708e3          	beqz	a4,80002980 <mbox_message_match+0x78>
			rx_msg->tx_data = rx_msg->tx_block.data;
80002994:	00e5a623          	sw	a4,12(a1)
80002998:	fe9ff06f          	j	80002980 <mbox_message_match+0x78>

8000299c <init_mbox_module>:
{
8000299c:	ff010113          	addi	sp,sp,-16
800029a0:	00812423          	sw	s0,8(sp)
800029a4:	80008437          	lui	s0,0x80008
800029a8:	bd840413          	addi	s0,s0,-1064 # 80007bd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007bd9>
800029ac:	00912223          	sw	s1,4(sp)
800029b0:	01212023          	sw	s2,0(sp)
800029b4:	00112623          	sw	ra,12(sp)
800029b8:	34840493          	addi	s1,s0,840
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_STACK_PUSH, k_stack_push, struct k_stack *, stack, u32_t, data)
800029bc:	80006937          	lui	s2,0x80006
		z_init_thread_base(&async_msg[i].thread, 0, _THREAD_DUMMY, 0);
800029c0:	00040513          	mv	a0,s0
800029c4:	00000693          	li	a3,0
800029c8:	00100613          	li	a2,1
800029cc:	00000593          	li	a1,0
800029d0:	10c020ef          	jal	ra,80004adc <z_init_thread_base>
800029d4:	00040593          	mv	a1,s0
800029d8:	66c90513          	addi	a0,s2,1644 # 8000666c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000666d>
800029dc:	05440413          	addi	s0,s0,84
800029e0:	675010ef          	jal	ra,80004854 <z_impl_k_stack_push>
	for (i = 0; i < CONFIG_NUM_MBOX_ASYNC_MSGS; i++) {
800029e4:	fc941ee3          	bne	s0,s1,800029c0 <init_mbox_module+0x24>
}
800029e8:	00c12083          	lw	ra,12(sp)
800029ec:	00812403          	lw	s0,8(sp)
800029f0:	00412483          	lw	s1,4(sp)
800029f4:	00012903          	lw	s2,0(sp)
800029f8:	00000513          	li	a0,0
800029fc:	01010113          	addi	sp,sp,16
80002a00:	00008067          	ret

80002a04 <mbox_message_put>:
	struct k_thread *receiving_thread;
	struct k_mbox_msg *rx_msg;
	k_spinlock_key_t key;

	/* save sender id so it can be used during message matching */
	tx_msg->rx_source_thread = _current;
80002a04:	800077b7          	lui	a5,0x80007
{
80002a08:	fd010113          	addi	sp,sp,-48
	tx_msg->rx_source_thread = _current;
80002a0c:	98c7a783          	lw	a5,-1652(a5) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
{
80002a10:	01512a23          	sw	s5,20(sp)

	/* finish readying sending thread (actual or dummy) for send */
	sending_thread = tx_msg->_syncing_thread;
80002a14:	0245aa83          	lw	s5,36(a1)
{
80002a18:	02912223          	sw	s1,36(sp)
80002a1c:	03212023          	sw	s2,32(sp)
80002a20:	01312e23          	sw	s3,28(sp)
80002a24:	01612823          	sw	s6,16(sp)
80002a28:	01712623          	sw	s7,12(sp)
80002a2c:	02112623          	sw	ra,44(sp)
80002a30:	02812423          	sw	s0,40(sp)
80002a34:	01412c23          	sw	s4,24(sp)
	tx_msg->rx_source_thread = _current;
80002a38:	00f5ae23          	sw	a5,28(a1)
{
80002a3c:	00050993          	mv	s3,a0
80002a40:	00058b13          	mv	s6,a1
80002a44:	00060b93          	mv	s7,a2
	sending_thread->base.swap_data = tx_msg;
80002a48:	00baaa23          	sw	a1,20(s5)

	/* search mailbox's rx queue for a compatible receiver */
	key = k_spin_lock(&mbox->lock);
80002a4c:	01050913          	addi	s2,a0,16
80002a50:	00800493          	li	s1,8
80002a54:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002a58:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002a5c:	0084f493          	andi	s1,s1,8
80002a60:	098020ef          	jal	ra,80004af8 <z_spin_lock_valid>
80002a64:	02051e63          	bnez	a0,80002aa0 <mbox_message_put+0x9c>
80002a68:	80006437          	lui	s0,0x80006
80002a6c:	800065b7          	lui	a1,0x80006
80002a70:	80006537          	lui	a0,0x80006
80002a74:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80002a78:	04e00693          	li	a3,78
80002a7c:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80002a80:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80002a84:	954ff0ef          	jal	ra,80001bd8 <printk>
80002a88:	80006537          	lui	a0,0x80006
80002a8c:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80002a90:	948ff0ef          	jal	ra,80001bd8 <printk>
80002a94:	04e00593          	li	a1,78
80002a98:	04040513          	addi	a0,s0,64
80002a9c:	978ff0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80002aa0:	00090513          	mv	a0,s2
80002aa4:	0ac020ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	return list->head == list;
80002aa8:	0089a403          	lw	s0,8(s3)

	_WAIT_Q_FOR_EACH(&mbox->rx_msg_queue, receiving_thread) {
80002aac:	00898793          	addi	a5,s3,8
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002ab0:	0af41063          	bne	s0,a5,80002b50 <mbox_message_put+0x14c>

		}
	}

	/* didn't find a matching receiver: don't wait for one */
	if (timeout == K_NO_WAIT) {
80002ab4:	120b9263          	bnez	s7,80002bd8 <mbox_message_put+0x1d4>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ab8:	00090513          	mv	a0,s2
80002abc:	064020ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80002ac0:	02051e63          	bnez	a0,80002afc <mbox_message_put+0xf8>
80002ac4:	80006437          	lui	s0,0x80006
80002ac8:	800065b7          	lui	a1,0x80006
80002acc:	80006537          	lui	a0,0x80006
80002ad0:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80002ad4:	06100693          	li	a3,97
80002ad8:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80002adc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80002ae0:	8f8ff0ef          	jal	ra,80001bd8 <printk>
80002ae4:	80006537          	lui	a0,0x80006
80002ae8:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80002aec:	8ecff0ef          	jal	ra,80001bd8 <printk>
80002af0:	06100593          	li	a1,97
80002af4:	04040513          	addi	a0,s0,64
80002af8:	91cff0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002afc:	3004a4f3          	csrrs	s1,mstatus,s1
		k_spin_unlock(&mbox->lock, key);
		return -ENOMSG;
80002b00:	fb000a13          	li	s4,-80
80002b04:	0a40006f          	j	80002ba8 <mbox_message_put+0x1a4>
			return z_pend_curr(&mbox->lock, key, NULL, K_FOREVER);
80002b08:	fff00693          	li	a3,-1
80002b0c:	00000613          	li	a2,0
	}
#endif

	/* synchronous send: sender waits on tx queue for receiver or timeout */
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
}
80002b10:	02812403          	lw	s0,40(sp)
80002b14:	02c12083          	lw	ra,44(sp)
80002b18:	01c12983          	lw	s3,28(sp)
80002b1c:	01812a03          	lw	s4,24(sp)
80002b20:	01412a83          	lw	s5,20(sp)
80002b24:	01012b03          	lw	s6,16(sp)
80002b28:	00c12b83          	lw	s7,12(sp)
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
80002b2c:	00048593          	mv	a1,s1
80002b30:	00090513          	mv	a0,s2
}
80002b34:	02412483          	lw	s1,36(sp)
80002b38:	02012903          	lw	s2,32(sp)
80002b3c:	03010113          	addi	sp,sp,48
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
80002b40:	6cc0106f          	j	8000420c <z_pend_curr>
	return (node == list->tail) ? NULL : node->next;
80002b44:	00c9a783          	lw	a5,12(s3)
80002b48:	f6f406e3          	beq	s0,a5,80002ab4 <mbox_message_put+0xb0>
80002b4c:	00042403          	lw	s0,0(s0)
	_WAIT_Q_FOR_EACH(&mbox->rx_msg_queue, receiving_thread) {
80002b50:	f60402e3          	beqz	s0,80002ab4 <mbox_message_put+0xb0>
		if (mbox_message_match(tx_msg, rx_msg) == 0) {
80002b54:	01442583          	lw	a1,20(s0)
80002b58:	000b0513          	mv	a0,s6
80002b5c:	dadff0ef          	jal	ra,80002908 <mbox_message_match>
80002b60:	00050a13          	mv	s4,a0
80002b64:	fe0510e3          	bnez	a0,80002b44 <mbox_message_put+0x140>
			z_unpend_thread(receiving_thread);
80002b68:	00040513          	mv	a0,s0
80002b6c:	36d000ef          	jal	ra,800036d8 <z_unpend_thread>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002b70:	00d44783          	lbu	a5,13(s0)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80002b74:	06042623          	sw	zero,108(s0)
80002b78:	01f7f793          	andi	a5,a5,31
80002b7c:	00079a63          	bnez	a5,80002b90 <mbox_message_put+0x18c>
	if (z_is_thread_ready(thread)) {
80002b80:	01842783          	lw	a5,24(s0)
80002b84:	00079663          	bnez	a5,80002b90 <mbox_message_put+0x18c>
		z_add_thread_to_ready_q(thread);
80002b88:	00040513          	mv	a0,s0
80002b8c:	6a9000ef          	jal	ra,80003a34 <z_add_thread_to_ready_q>
			if ((sending_thread->base.thread_state & _THREAD_DUMMY)
80002b90:	00dac783          	lbu	a5,13(s5)
80002b94:	0017f793          	andi	a5,a5,1
80002b98:	f60788e3          	beqz	a5,80002b08 <mbox_message_put+0x104>
				z_reschedule(&mbox->lock, key);
80002b9c:	00048593          	mv	a1,s1
80002ba0:	00090513          	mv	a0,s2
80002ba4:	045000ef          	jal	ra,800033e8 <z_reschedule>
}
80002ba8:	02c12083          	lw	ra,44(sp)
80002bac:	02812403          	lw	s0,40(sp)
80002bb0:	000a0513          	mv	a0,s4
80002bb4:	02412483          	lw	s1,36(sp)
80002bb8:	02012903          	lw	s2,32(sp)
80002bbc:	01c12983          	lw	s3,28(sp)
80002bc0:	01812a03          	lw	s4,24(sp)
80002bc4:	01412a83          	lw	s5,20(sp)
80002bc8:	01012b03          	lw	s6,16(sp)
80002bcc:	00c12b83          	lw	s7,12(sp)
80002bd0:	03010113          	addi	sp,sp,48
80002bd4:	00008067          	ret
	if ((sending_thread->base.thread_state & _THREAD_DUMMY) != 0U) {
80002bd8:	00dac783          	lbu	a5,13(s5)
80002bdc:	0017f793          	andi	a5,a5,1
80002be0:	06078263          	beqz	a5,80002c44 <mbox_message_put+0x240>
		z_pend_thread(sending_thread, &mbox->tx_msg_queue, K_FOREVER);
80002be4:	000a8513          	mv	a0,s5
80002be8:	fff00613          	li	a2,-1
80002bec:	00098593          	mv	a1,s3
80002bf0:	58c010ef          	jal	ra,8000417c <z_pend_thread>
80002bf4:	00090513          	mv	a0,s2
80002bf8:	729010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80002bfc:	02051e63          	bnez	a0,80002c38 <mbox_message_put+0x234>
80002c00:	80006437          	lui	s0,0x80006
80002c04:	800065b7          	lui	a1,0x80006
80002c08:	80006537          	lui	a0,0x80006
80002c0c:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80002c10:	06100693          	li	a3,97
80002c14:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80002c18:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80002c1c:	fbdfe0ef          	jal	ra,80001bd8 <printk>
80002c20:	80006537          	lui	a0,0x80006
80002c24:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80002c28:	fb1fe0ef          	jal	ra,80001bd8 <printk>
80002c2c:	06100593          	li	a1,97
80002c30:	04040513          	addi	a0,s0,64
80002c34:	fe1fe0ef          	jal	ra,80001c14 <assert_post_action>
80002c38:	3004a4f3          	csrrs	s1,mstatus,s1
		return 0;
80002c3c:	00000a13          	li	s4,0
80002c40:	f69ff06f          	j	80002ba8 <mbox_message_put+0x1a4>
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
80002c44:	000b8693          	mv	a3,s7
80002c48:	00098613          	mv	a2,s3
80002c4c:	ec5ff06f          	j	80002b10 <mbox_message_put+0x10c>

80002c50 <mbox_message_dispose>:
	if (rx_msg->_syncing_thread == NULL) {
80002c50:	02452783          	lw	a5,36(a0)
80002c54:	0c078263          	beqz	a5,80002d18 <mbox_message_dispose+0xc8>
	if (rx_msg->tx_block.data != NULL) {
80002c58:	01452783          	lw	a5,20(a0)
{
80002c5c:	ff010113          	addi	sp,sp,-16
80002c60:	00812423          	sw	s0,8(sp)
80002c64:	00112623          	sw	ra,12(sp)
80002c68:	00050413          	mv	s0,a0
	if (rx_msg->tx_block.data != NULL) {
80002c6c:	00078863          	beqz	a5,80002c7c <mbox_message_dispose+0x2c>
		k_mem_pool_free(&rx_msg->tx_block);
80002c70:	01450513          	addi	a0,a0,20
80002c74:	4ac000ef          	jal	ra,80003120 <k_mem_pool_free>
		rx_msg->tx_block.data = NULL;
80002c78:	00042a23          	sw	zero,20(s0)
	sending_thread = rx_msg->_syncing_thread;
80002c7c:	02442583          	lw	a1,36(s0)
	tx_msg->size = rx_msg->size;
80002c80:	00442783          	lw	a5,4(s0)
	rx_msg->_syncing_thread = NULL;
80002c84:	02042223          	sw	zero,36(s0)
	tx_msg = (struct k_mbox_msg *)sending_thread->base.swap_data;
80002c88:	0145a703          	lw	a4,20(a1)
	tx_msg->size = rx_msg->size;
80002c8c:	00f72223          	sw	a5,4(a4)
	if ((sending_thread->base.thread_state & _THREAD_DUMMY) != 0U) {
80002c90:	00d5c783          	lbu	a5,13(a1)
80002c94:	0017f793          	andi	a5,a5,1
80002c98:	02078663          	beqz	a5,80002cc4 <mbox_message_dispose+0x74>
		struct k_sem *async_sem = tx_msg->_async_sem;
80002c9c:	02872403          	lw	s0,40(a4)
80002ca0:	80006537          	lui	a0,0x80006
80002ca4:	66c50513          	addi	a0,a0,1644 # 8000666c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000666d>
80002ca8:	3ad010ef          	jal	ra,80004854 <z_impl_k_stack_push>
		if (async_sem != NULL) {
80002cac:	04040e63          	beqz	s0,80002d08 <mbox_message_dispose+0xb8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002cb0:	00040513          	mv	a0,s0
}
80002cb4:	00812403          	lw	s0,8(sp)
80002cb8:	00c12083          	lw	ra,12(sp)
80002cbc:	01010113          	addi	sp,sp,16
80002cc0:	0e90106f          	j	800045a8 <z_impl_k_sem_give>
80002cc4:	00d5c783          	lbu	a5,13(a1)
80002cc8:	0605a623          	sw	zero,108(a1)
	thread->base.thread_state &= ~_THREAD_PENDING;
80002ccc:	ffd7f713          	andi	a4,a5,-3
80002cd0:	00e586a3          	sb	a4,13(a1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002cd4:	01d7f793          	andi	a5,a5,29
80002cd8:	00079a63          	bnez	a5,80002cec <mbox_message_dispose+0x9c>
	if (z_is_thread_ready(thread)) {
80002cdc:	0185a783          	lw	a5,24(a1)
80002ce0:	00079663          	bnez	a5,80002cec <mbox_message_dispose+0x9c>
		z_add_thread_to_ready_q(thread);
80002ce4:	00058513          	mv	a0,a1
80002ce8:	54d000ef          	jal	ra,80003a34 <z_add_thread_to_ready_q>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002cec:	00800513          	li	a0,8
80002cf0:	30053573          	csrrc	a0,mstatus,a0
80002cf4:	00812403          	lw	s0,8(sp)
80002cf8:	00c12083          	lw	ra,12(sp)
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80002cfc:	00857513          	andi	a0,a0,8
80002d00:	01010113          	addi	sp,sp,16
80002d04:	7b80006f          	j	800034bc <z_reschedule_irqlock>
80002d08:	00c12083          	lw	ra,12(sp)
80002d0c:	00812403          	lw	s0,8(sp)
80002d10:	01010113          	addi	sp,sp,16
80002d14:	00008067          	ret
80002d18:	00008067          	ret

80002d1c <k_mbox_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80002d1c:	00850793          	addi	a5,a0,8
	list->head = (sys_dnode_t *)list;
80002d20:	00a52023          	sw	a0,0(a0)
	list->tail = (sys_dnode_t *)list;
80002d24:	00a52223          	sw	a0,4(a0)
	list->head = (sys_dnode_t *)list;
80002d28:	00f52423          	sw	a5,8(a0)
	list->tail = (sys_dnode_t *)list;
80002d2c:	00f52623          	sw	a5,12(a0)
	mbox_ptr->lock = (struct k_spinlock) {};
80002d30:	00052823          	sw	zero,16(a0)
}
80002d34:	00008067          	ret

80002d38 <k_mbox_put>:

int k_mbox_put(struct k_mbox *mbox, struct k_mbox_msg *tx_msg, s32_t timeout)
{
	/* configure things for a synchronous send, then send the message */
	tx_msg->_syncing_thread = _current;
80002d38:	800077b7          	lui	a5,0x80007
80002d3c:	98c7a783          	lw	a5,-1652(a5) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
80002d40:	02f5a223          	sw	a5,36(a1)

	return mbox_message_put(mbox, tx_msg, timeout);
80002d44:	cc1ff06f          	j	80002a04 <mbox_message_put>

80002d48 <k_mbox_data_get>:
	(void)mbox_message_put(mbox, &async->tx_msg, K_FOREVER);
}
#endif

void k_mbox_data_get(struct k_mbox_msg *rx_msg, void *buffer)
{
80002d48:	ff010113          	addi	sp,sp,-16
80002d4c:	00812423          	sw	s0,8(sp)
80002d50:	00112623          	sw	ra,12(sp)
80002d54:	00050413          	mv	s0,a0
	/* handle case where data is to be discarded */
	if (buffer == NULL) {
80002d58:	00059c63          	bnez	a1,80002d70 <k_mbox_data_get+0x28>
		rx_msg->size = 0;
80002d5c:	00052223          	sw	zero,4(a0)
	/* copy message data to buffer, then dispose of message */
	if ((rx_msg->tx_data != NULL) && (rx_msg->size > 0)) {
		(void)memcpy(buffer, rx_msg->tx_data, rx_msg->size);
	}
	mbox_message_dispose(rx_msg);
}
80002d60:	00812403          	lw	s0,8(sp)
80002d64:	00c12083          	lw	ra,12(sp)
80002d68:	01010113          	addi	sp,sp,16
	mbox_message_dispose(rx_msg);
80002d6c:	ee5ff06f          	j	80002c50 <mbox_message_dispose>
80002d70:	00058513          	mv	a0,a1
	if ((rx_msg->tx_data != NULL) && (rx_msg->size > 0)) {
80002d74:	00c42583          	lw	a1,12(s0)
80002d78:	00058863          	beqz	a1,80002d88 <k_mbox_data_get+0x40>
80002d7c:	00442603          	lw	a2,4(s0)
80002d80:	00060463          	beqz	a2,80002d88 <k_mbox_data_get+0x40>
		(void)memcpy(buffer, rx_msg->tx_data, rx_msg->size);
80002d84:	c28ff0ef          	jal	ra,800021ac <memcpy>
	mbox_message_dispose(rx_msg);
80002d88:	00040513          	mv	a0,s0
80002d8c:	fd5ff06f          	j	80002d60 <k_mbox_data_get+0x18>

80002d90 <k_mbox_get>:
	return 0;
}

int k_mbox_get(struct k_mbox *mbox, struct k_mbox_msg *rx_msg, void *buffer,
	       s32_t timeout)
{
80002d90:	fd010113          	addi	sp,sp,-48
80002d94:	01612823          	sw	s6,16(sp)
	struct k_mbox_msg *tx_msg;
	k_spinlock_key_t key;
	int result;

	/* save receiver id so it can be used during message matching */
	rx_msg->tx_target_thread = _current;
80002d98:	80007b37          	lui	s6,0x80007
80002d9c:	984b0793          	addi	a5,s6,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80002da0:	0087a783          	lw	a5,8(a5)
{
80002da4:	02812423          	sw	s0,40(sp)
80002da8:	03212023          	sw	s2,32(sp)
80002dac:	01312e23          	sw	s3,28(sp)
80002db0:	01412c23          	sw	s4,24(sp)
80002db4:	01512a23          	sw	s5,20(sp)
80002db8:	01712623          	sw	s7,12(sp)
80002dbc:	02112623          	sw	ra,44(sp)
80002dc0:	02912223          	sw	s1,36(sp)
80002dc4:	00050a13          	mv	s4,a0
80002dc8:	00058913          	mv	s2,a1
80002dcc:	00060a93          	mv	s5,a2
80002dd0:	00068b93          	mv	s7,a3
	rx_msg->tx_target_thread = _current;
80002dd4:	02f5a023          	sw	a5,32(a1)

	/* search mailbox's tx queue for a compatible sender */
	key = k_spin_lock(&mbox->lock);
80002dd8:	01050993          	addi	s3,a0,16
80002ddc:	00800413          	li	s0,8
80002de0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002de4:	00098513          	mv	a0,s3
80002de8:	511010ef          	jal	ra,80004af8 <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
80002dec:	00847413          	andi	s0,s0,8
80002df0:	984b0b13          	addi	s6,s6,-1660
80002df4:	02051e63          	bnez	a0,80002e30 <k_mbox_get+0xa0>
80002df8:	800064b7          	lui	s1,0x80006
80002dfc:	800065b7          	lui	a1,0x80006
80002e00:	80006537          	lui	a0,0x80006
80002e04:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80002e08:	04e00693          	li	a3,78
80002e0c:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80002e10:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80002e14:	dc5fe0ef          	jal	ra,80001bd8 <printk>
80002e18:	80006537          	lui	a0,0x80006
80002e1c:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80002e20:	db9fe0ef          	jal	ra,80001bd8 <printk>
80002e24:	04e00593          	li	a1,78
80002e28:	04048513          	addi	a0,s1,64
80002e2c:	de9fe0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80002e30:	00098513          	mv	a0,s3
80002e34:	51d010ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	return list->head == list;
80002e38:	000a2483          	lw	s1,0(s4)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002e3c:	069a1c63          	bne	s4,s1,80002eb4 <k_mbox_get+0x124>
		}
	}

	/* didn't find a matching sender */

	if (timeout == K_NO_WAIT) {
80002e40:	100b9c63          	bnez	s7,80002f58 <k_mbox_get+0x1c8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002e44:	00098513          	mv	a0,s3
80002e48:	4d9010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80002e4c:	02051e63          	bnez	a0,80002e88 <k_mbox_get+0xf8>
80002e50:	800064b7          	lui	s1,0x80006
80002e54:	800065b7          	lui	a1,0x80006
80002e58:	80006537          	lui	a0,0x80006
80002e5c:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80002e60:	06100693          	li	a3,97
80002e64:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80002e68:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80002e6c:	d6dfe0ef          	jal	ra,80001bd8 <printk>
80002e70:	80006537          	lui	a0,0x80006
80002e74:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80002e78:	d61fe0ef          	jal	ra,80001bd8 <printk>
80002e7c:	06100593          	li	a1,97
80002e80:	04048513          	addi	a0,s1,64
80002e84:	d91fe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002e88:	30042473          	csrrs	s0,mstatus,s0
		/* don't wait for a matching sender to appear */
		k_spin_unlock(&mbox->lock, key);
		return -ENOMSG;
80002e8c:	fb000513          	li	a0,-80
80002e90:	09c0006f          	j	80002f2c <k_mbox_get+0x19c>
	} else if (rx_msg->size == 0) {
80002e94:	00492783          	lw	a5,4(s2)
80002e98:	08079863          	bnez	a5,80002f28 <k_mbox_get+0x198>
		mbox_message_dispose(rx_msg);
80002e9c:	00090513          	mv	a0,s2
80002ea0:	db1ff0ef          	jal	ra,80002c50 <mbox_message_dispose>
80002ea4:	0840006f          	j	80002f28 <k_mbox_get+0x198>
	return (node == list->tail) ? NULL : node->next;
80002ea8:	004a2783          	lw	a5,4(s4)
80002eac:	f8f48ae3          	beq	s1,a5,80002e40 <k_mbox_get+0xb0>
80002eb0:	0004a483          	lw	s1,0(s1)
	_WAIT_Q_FOR_EACH(&mbox->tx_msg_queue, sending_thread) {
80002eb4:	f80486e3          	beqz	s1,80002e40 <k_mbox_get+0xb0>
		if (mbox_message_match(tx_msg, rx_msg) == 0) {
80002eb8:	0144a503          	lw	a0,20(s1)
80002ebc:	00090593          	mv	a1,s2
80002ec0:	a49ff0ef          	jal	ra,80002908 <mbox_message_match>
80002ec4:	fe0512e3          	bnez	a0,80002ea8 <k_mbox_get+0x118>
			z_unpend_thread(sending_thread);
80002ec8:	00048513          	mv	a0,s1
80002ecc:	00d000ef          	jal	ra,800036d8 <z_unpend_thread>
80002ed0:	00098513          	mv	a0,s3
80002ed4:	44d010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80002ed8:	02051e63          	bnez	a0,80002f14 <k_mbox_get+0x184>
80002edc:	800064b7          	lui	s1,0x80006
80002ee0:	800065b7          	lui	a1,0x80006
80002ee4:	80006537          	lui	a0,0x80006
80002ee8:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80002eec:	06100693          	li	a3,97
80002ef0:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80002ef4:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80002ef8:	ce1fe0ef          	jal	ra,80001bd8 <printk>
80002efc:	80006537          	lui	a0,0x80006
80002f00:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80002f04:	cd5fe0ef          	jal	ra,80001bd8 <printk>
80002f08:	06100593          	li	a1,97
80002f0c:	04048513          	addi	a0,s1,64
80002f10:	d05fe0ef          	jal	ra,80001c14 <assert_post_action>
80002f14:	30042473          	csrrs	s0,mstatus,s0
	if (buffer != NULL) {
80002f18:	f60a8ee3          	beqz	s5,80002e94 <k_mbox_get+0x104>
		k_mbox_data_get(rx_msg, buffer);
80002f1c:	000a8593          	mv	a1,s5
80002f20:	00090513          	mv	a0,s2
80002f24:	e25ff0ef          	jal	ra,80002d48 <k_mbox_data_get>
			return mbox_message_data_check(rx_msg, buffer);
80002f28:	00000513          	li	a0,0
	if (result == 0) {
		result = mbox_message_data_check(rx_msg, buffer);
	}

	return result;
}
80002f2c:	02c12083          	lw	ra,44(sp)
80002f30:	02812403          	lw	s0,40(sp)
80002f34:	02412483          	lw	s1,36(sp)
80002f38:	02012903          	lw	s2,32(sp)
80002f3c:	01c12983          	lw	s3,28(sp)
80002f40:	01812a03          	lw	s4,24(sp)
80002f44:	01412a83          	lw	s5,20(sp)
80002f48:	01012b03          	lw	s6,16(sp)
80002f4c:	00c12b83          	lw	s7,12(sp)
80002f50:	03010113          	addi	sp,sp,48
80002f54:	00008067          	ret
	_current->base.swap_data = rx_msg;
80002f58:	008b2783          	lw	a5,8(s6)
	result = z_pend_curr(&mbox->lock, key, &mbox->rx_msg_queue, timeout);
80002f5c:	000b8693          	mv	a3,s7
80002f60:	008a0613          	addi	a2,s4,8
	_current->base.swap_data = rx_msg;
80002f64:	0127aa23          	sw	s2,20(a5)
	result = z_pend_curr(&mbox->lock, key, &mbox->rx_msg_queue, timeout);
80002f68:	00040593          	mv	a1,s0
80002f6c:	00098513          	mv	a0,s3
80002f70:	29c010ef          	jal	ra,8000420c <z_pend_curr>
	if (result == 0) {
80002f74:	fa051ce3          	bnez	a0,80002f2c <k_mbox_get+0x19c>
80002f78:	fa1ff06f          	j	80002f18 <k_mbox_get+0x188>

80002f7c <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80002f7c:	ff010113          	addi	sp,sp,-16
80002f80:	00812423          	sw	s0,8(sp)
80002f84:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80002f88:	80006437          	lui	s0,0x80006
80002f8c:	800064b7          	lui	s1,0x80006
{
80002f90:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80002f94:	62040413          	addi	s0,s0,1568 # 80006620 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006621>
80002f98:	65848493          	addi	s1,s1,1624 # 80006658 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006659>
80002f9c:	00946e63          	bltu	s0,s1,80002fb8 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80002fa0:	00c12083          	lw	ra,12(sp)
80002fa4:	00812403          	lw	s0,8(sp)
80002fa8:	00412483          	lw	s1,4(sp)
80002fac:	00000513          	li	a0,0
80002fb0:	01010113          	addi	sp,sp,16
80002fb4:	00008067          	ret
80002fb8:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80002fbc:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80002fc0:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80002fc4:	00f42c23          	sw	a5,24(s0)
80002fc8:	960fe0ef          	jal	ra,80001128 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80002fcc:	01c40413          	addi	s0,s0,28
80002fd0:	fcdff06f          	j	80002f9c <init_static_pools+0x20>

80002fd4 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002fd4:	00054783          	lbu	a5,0(a0)
{
80002fd8:	fe010113          	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002fdc:	00052603          	lw	a2,0(a0)
{
80002fe0:	00812c23          	sw	s0,24(sp)
80002fe4:	00379413          	slli	s0,a5,0x3
80002fe8:	01212823          	sw	s2,16(sp)
80002fec:	40f40433          	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002ff0:	80006937          	lui	s2,0x80006
80002ff4:	00241413          	slli	s0,s0,0x2
80002ff8:	00865593          	srli	a1,a2,0x8
80002ffc:	62090513          	addi	a0,s2,1568 # 80006620 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006621>
80003000:	00c65613          	srli	a2,a2,0xc
80003004:	00f5f593          	andi	a1,a1,15
80003008:	00850533          	add	a0,a0,s0
{
8000300c:	00112e23          	sw	ra,28(sp)
80003010:	00912a23          	sw	s1,20(sp)
80003014:	01312623          	sw	s3,12(sp)
80003018:	01412423          	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
8000301c:	a54fe0ef          	jal	ra,80001270 <z_sys_mem_pool_block_free>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003020:	00800593          	li	a1,8
80003024:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003028:	800064b7          	lui	s1,0x80006
8000302c:	6bc48513          	addi	a0,s1,1724 # 800066bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066bd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003030:	0085f993          	andi	s3,a1,8
80003034:	2c5010ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003038:	62090913          	addi	s2,s2,1568
8000303c:	02051e63          	bnez	a0,80003078 <k_mem_pool_free_id+0xa4>
80003040:	80006a37          	lui	s4,0x80006
80003044:	800065b7          	lui	a1,0x80006
80003048:	80006537          	lui	a0,0x80006
8000304c:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80003050:	04e00693          	li	a3,78
80003054:	040a0613          	addi	a2,s4,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003058:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000305c:	b7dfe0ef          	jal	ra,80001bd8 <printk>
80003060:	80006537          	lui	a0,0x80006
80003064:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80003068:	b71fe0ef          	jal	ra,80001bd8 <printk>
8000306c:	04e00593          	li	a1,78
80003070:	040a0513          	addi	a0,s4,64
80003074:	ba1fe0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80003078:	6bc48513          	addi	a0,s1,1724
8000307c:	2d5010ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80003080:	01440513          	addi	a0,s0,20
80003084:	00a90533          	add	a0,s2,a0
80003088:	3c4010ef          	jal	ra,8000444c <z_unpend_all>

	if (need_sched != 0) {
8000308c:	02050663          	beqz	a0,800030b8 <k_mem_pool_free_id+0xe4>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
80003090:	01812403          	lw	s0,24(sp)
80003094:	01c12083          	lw	ra,28(sp)
80003098:	01012903          	lw	s2,16(sp)
8000309c:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
800030a0:	00098593          	mv	a1,s3
800030a4:	6bc48513          	addi	a0,s1,1724
}
800030a8:	00c12983          	lw	s3,12(sp)
800030ac:	01412483          	lw	s1,20(sp)
800030b0:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
800030b4:	3340006f          	j	800033e8 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800030b8:	6bc48513          	addi	a0,s1,1724
800030bc:	265010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
800030c0:	02051e63          	bnez	a0,800030fc <k_mem_pool_free_id+0x128>
800030c4:	80006437          	lui	s0,0x80006
800030c8:	800065b7          	lui	a1,0x80006
800030cc:	80006537          	lui	a0,0x80006
800030d0:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
800030d4:	06100693          	li	a3,97
800030d8:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800030dc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800030e0:	af9fe0ef          	jal	ra,80001bd8 <printk>
800030e4:	80006537          	lui	a0,0x80006
800030e8:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
800030ec:	aedfe0ef          	jal	ra,80001bd8 <printk>
800030f0:	06100593          	li	a1,97
800030f4:	04040513          	addi	a0,s0,64
800030f8:	b1dfe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800030fc:	3009a5f3          	csrrs	a1,mstatus,s3
}
80003100:	01c12083          	lw	ra,28(sp)
80003104:	01812403          	lw	s0,24(sp)
80003108:	01412483          	lw	s1,20(sp)
8000310c:	01012903          	lw	s2,16(sp)
80003110:	00c12983          	lw	s3,12(sp)
80003114:	00812a03          	lw	s4,8(sp)
80003118:	02010113          	addi	sp,sp,32
8000311c:	00008067          	ret

80003120 <k_mem_pool_free>:

void k_mem_pool_free(struct k_mem_block *block)
{
	k_mem_pool_free_id(&block->id);
80003120:	00450513          	addi	a0,a0,4
80003124:	eb1ff06f          	j	80002fd4 <k_mem_pool_free_id>

80003128 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003128:	00d54783          	lbu	a5,13(a0)
8000312c:	01f7f793          	andi	a5,a5,31
80003130:	00079863          	bnez	a5,80003140 <z_is_thread_ready+0x18>
80003134:	01852503          	lw	a0,24(a0)
80003138:	00153513          	seqz	a0,a0
8000313c:	00008067          	ret
80003140:	00000513          	li	a0,0
}
80003144:	00008067          	ret

80003148 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80003148:	ff010113          	addi	sp,sp,-16
8000314c:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80003150:	f45fe0ef          	jal	ra,80002094 <z_clock_elapsed>
80003154:	800067b7          	lui	a5,0x80006
80003158:	6c87a783          	lw	a5,1736(a5) # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>

	z_set_timeout_expiry(slice_time, false);
}
8000315c:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80003160:	80007737          	lui	a4,0x80007
80003164:	00a78533          	add	a0,a5,a0
80003168:	98a72a23          	sw	a0,-1644(a4) # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
	z_set_timeout_expiry(slice_time, false);
8000316c:	00000593          	li	a1,0
80003170:	00078513          	mv	a0,a5
}
80003174:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80003178:	2c80206f          	j	80005440 <z_set_timeout_expiry>

8000317c <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
8000317c:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80003180:	ff010113          	addi	sp,sp,-16
80003184:	00812423          	sw	s0,8(sp)
80003188:	00112623          	sw	ra,12(sp)
8000318c:	00912223          	sw	s1,4(sp)
80003190:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80003194:	02079863          	bnez	a5,800031c4 <pended_on.isra.15+0x48>
80003198:	800064b7          	lui	s1,0x80006
8000319c:	800065b7          	lui	a1,0x80006
800031a0:	80006537          	lui	a0,0x80006
800031a4:	30c58593          	addi	a1,a1,780 # 8000630c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000630d>
800031a8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800031ac:	18300693          	li	a3,387
800031b0:	2f848613          	addi	a2,s1,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
800031b4:	a25fe0ef          	jal	ra,80001bd8 <printk>
800031b8:	18300593          	li	a1,387
800031bc:	2f848513          	addi	a0,s1,760
800031c0:	a55fe0ef          	jal	ra,80001c14 <assert_post_action>

	return thread->base.pended_on;
}
800031c4:	00042503          	lw	a0,0(s0)
800031c8:	00c12083          	lw	ra,12(sp)
800031cc:	00812403          	lw	s0,8(sp)
800031d0:	00412483          	lw	s1,4(sp)
800031d4:	01010113          	addi	sp,sp,16
800031d8:	00008067          	ret

800031dc <k_sched_time_slice_set>:
{
800031dc:	fe010113          	addi	sp,sp,-32
800031e0:	00812c23          	sw	s0,24(sp)
800031e4:	01312623          	sw	s3,12(sp)
800031e8:	01412423          	sw	s4,8(sp)
800031ec:	00112e23          	sw	ra,28(sp)
800031f0:	00912a23          	sw	s1,20(sp)
800031f4:	01212823          	sw	s2,16(sp)
800031f8:	00050a13          	mv	s4,a0
800031fc:	00058993          	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003200:	00800413          	li	s0,8
80003204:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003208:	800064b7          	lui	s1,0x80006
8000320c:	6c048513          	addi	a0,s1,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003210:	00847413          	andi	s0,s0,8
80003214:	0e5010ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003218:	02051e63          	bnez	a0,80003254 <k_sched_time_slice_set+0x78>
8000321c:	80006937          	lui	s2,0x80006
80003220:	800065b7          	lui	a1,0x80006
80003224:	80006537          	lui	a0,0x80006
80003228:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
8000322c:	04e00693          	li	a3,78
80003230:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003234:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003238:	9a1fe0ef          	jal	ra,80001bd8 <printk>
8000323c:	80006537          	lui	a0,0x80006
80003240:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80003244:	995fe0ef          	jal	ra,80001bd8 <printk>
80003248:	04e00593          	li	a1,78
8000324c:	04090513          	addi	a0,s2,64
80003250:	9c5fe0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80003254:	6c048513          	addi	a0,s1,1728
80003258:	0f9010ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
8000325c:	800077b7          	lui	a5,0x80007
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80003260:	00a00593          	li	a1,10
80003264:	009a0513          	addi	a0,s4,9
80003268:	9807aa23          	sw	zero,-1644(a5) # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
8000326c:	e3cfd0ef          	jal	ra,800008a8 <__divsi3>
		slice_max_prio = prio;
80003270:	800067b7          	lui	a5,0x80006
		slice_time = z_ms_to_ticks(slice);
80003274:	80006937          	lui	s2,0x80006
80003278:	6ca92423          	sw	a0,1736(s2) # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
		slice_max_prio = prio;
8000327c:	6d37a223          	sw	s3,1732(a5) # 800066c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c5>
		reset_time_slice();
80003280:	ec9ff0ef          	jal	ra,80003148 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003284:	6c048513          	addi	a0,s1,1728
80003288:	099010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
8000328c:	02051e63          	bnez	a0,800032c8 <k_sched_time_slice_set+0xec>
80003290:	800064b7          	lui	s1,0x80006
80003294:	800065b7          	lui	a1,0x80006
80003298:	80006537          	lui	a0,0x80006
8000329c:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
800032a0:	06100693          	li	a3,97
800032a4:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800032a8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800032ac:	92dfe0ef          	jal	ra,80001bd8 <printk>
800032b0:	80006537          	lui	a0,0x80006
800032b4:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
800032b8:	921fe0ef          	jal	ra,80001bd8 <printk>
800032bc:	06100593          	li	a1,97
800032c0:	04048513          	addi	a0,s1,64
800032c4:	951fe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800032c8:	30042473          	csrrs	s0,mstatus,s0
}
800032cc:	01c12083          	lw	ra,28(sp)
800032d0:	01812403          	lw	s0,24(sp)
800032d4:	01412483          	lw	s1,20(sp)
800032d8:	01012903          	lw	s2,16(sp)
800032dc:	00c12983          	lw	s3,12(sp)
800032e0:	00812a03          	lw	s4,8(sp)
800032e4:	02010113          	addi	sp,sp,32
800032e8:	00008067          	ret

800032ec <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
800032ec:	fe010113          	addi	sp,sp,-32
800032f0:	00812c23          	sw	s0,24(sp)
800032f4:	01212823          	sw	s2,16(sp)
800032f8:	00112e23          	sw	ra,28(sp)
800032fc:	00912a23          	sw	s1,20(sp)
80003300:	01312623          	sw	s3,12(sp)
80003304:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003308:	00800413          	li	s0,8
8000330c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003310:	800064b7          	lui	s1,0x80006
80003314:	6c048513          	addi	a0,s1,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003318:	00847413          	andi	s0,s0,8
8000331c:	7dc010ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003320:	02051e63          	bnez	a0,8000335c <z_unpend_thread_no_timeout+0x70>
80003324:	800069b7          	lui	s3,0x80006
80003328:	800065b7          	lui	a1,0x80006
8000332c:	80006537          	lui	a0,0x80006
80003330:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80003334:	04e00693          	li	a3,78
80003338:	04098613          	addi	a2,s3,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
8000333c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003340:	899fe0ef          	jal	ra,80001bd8 <printk>
80003344:	80006537          	lui	a0,0x80006
80003348:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
8000334c:	88dfe0ef          	jal	ra,80001bd8 <printk>
80003350:	04e00593          	li	a1,78
80003354:	04098513          	addi	a0,s3,64
80003358:	8bdfe0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
8000335c:	6c048513          	addi	a0,s1,1728
80003360:	7f0010ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003364:	00890513          	addi	a0,s2,8
80003368:	e15ff0ef          	jal	ra,8000317c <pended_on.isra.15>
8000336c:	00090593          	mv	a1,s2
80003370:	2f0000ef          	jal	ra,80003660 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003374:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003378:	6c048513          	addi	a0,s1,1728
8000337c:	ffd7f793          	andi	a5,a5,-3
80003380:	00f906a3          	sb	a5,13(s2)
80003384:	79c010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80003388:	02051e63          	bnez	a0,800033c4 <z_unpend_thread_no_timeout+0xd8>
8000338c:	800064b7          	lui	s1,0x80006
80003390:	800065b7          	lui	a1,0x80006
80003394:	80006537          	lui	a0,0x80006
80003398:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
8000339c:	06100693          	li	a3,97
800033a0:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800033a4:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800033a8:	831fe0ef          	jal	ra,80001bd8 <printk>
800033ac:	80006537          	lui	a0,0x80006
800033b0:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
800033b4:	825fe0ef          	jal	ra,80001bd8 <printk>
800033b8:	06100593          	li	a1,97
800033bc:	04048513          	addi	a0,s1,64
800033c0:	855fe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800033c4:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
800033c8:	01c12083          	lw	ra,28(sp)
800033cc:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
800033d0:	00092423          	sw	zero,8(s2)
}
800033d4:	01412483          	lw	s1,20(sp)
800033d8:	01012903          	lw	s2,16(sp)
800033dc:	00c12983          	lw	s3,12(sp)
800033e0:	02010113          	addi	sp,sp,32
800033e4:	00008067          	ret

800033e8 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
800033e8:	800077b7          	lui	a5,0x80007
800033ec:	9847a783          	lw	a5,-1660(a5) # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
{
800033f0:	ff010113          	addi	sp,sp,-16
800033f4:	00812423          	sw	s0,8(sp)
800033f8:	00112623          	sw	ra,12(sp)
800033fc:	00912223          	sw	s1,4(sp)
80003400:	00058413          	mv	s0,a1
	if (resched()) {
80003404:	04079e63          	bnez	a5,80003460 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003408:	718010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
8000340c:	02051e63          	bnez	a0,80003448 <z_reschedule+0x60>
80003410:	800064b7          	lui	s1,0x80006
80003414:	800065b7          	lui	a1,0x80006
80003418:	80006537          	lui	a0,0x80006
8000341c:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80003420:	07800693          	li	a3,120
80003424:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003428:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000342c:	facfe0ef          	jal	ra,80001bd8 <printk>
80003430:	80006537          	lui	a0,0x80006
80003434:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80003438:	fa0fe0ef          	jal	ra,80001bd8 <printk>
8000343c:	07800593          	li	a1,120
80003440:	04048513          	addi	a0,s1,64
80003444:	fd0fe0ef          	jal	ra,80001c14 <assert_post_action>
80003448:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
8000344c:	00812403          	lw	s0,8(sp)
80003450:	00c12083          	lw	ra,12(sp)
80003454:	00412483          	lw	s1,4(sp)
80003458:	01010113          	addi	sp,sp,16
8000345c:	dcdfc06f          	j	80000228 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003460:	6c0010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80003464:	02051e63          	bnez	a0,800034a0 <z_reschedule+0xb8>
80003468:	800064b7          	lui	s1,0x80006
8000346c:	800065b7          	lui	a1,0x80006
80003470:	80006537          	lui	a0,0x80006
80003474:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80003478:	06100693          	li	a3,97
8000347c:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003480:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003484:	f54fe0ef          	jal	ra,80001bd8 <printk>
80003488:	80006537          	lui	a0,0x80006
8000348c:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80003490:	f48fe0ef          	jal	ra,80001bd8 <printk>
80003494:	06100593          	li	a1,97
80003498:	04048513          	addi	a0,s1,64
8000349c:	f78fe0ef          	jal	ra,80001c14 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
800034a0:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800034a4:	30042473          	csrrs	s0,mstatus,s0
800034a8:	00c12083          	lw	ra,12(sp)
800034ac:	00812403          	lw	s0,8(sp)
800034b0:	00412483          	lw	s1,4(sp)
800034b4:	01010113          	addi	sp,sp,16
800034b8:	00008067          	ret

800034bc <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
800034bc:	80007737          	lui	a4,0x80007
800034c0:	98472703          	lw	a4,-1660(a4) # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
800034c4:	00071463          	bnez	a4,800034cc <z_reschedule_irqlock+0x10>
800034c8:	d61fc06f          	j	80000228 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
800034cc:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800034d0:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
800034d4:	00008067          	ret

800034d8 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800034d8:	00800513          	li	a0,8
800034dc:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
800034e0:	00857513          	andi	a0,a0,8
800034e4:	fd9ff06f          	j	800034bc <z_reschedule_irqlock>

800034e8 <k_sched_lock>:

void k_sched_lock(void)
{
800034e8:	fe010113          	addi	sp,sp,-32
800034ec:	00812c23          	sw	s0,24(sp)
800034f0:	00112e23          	sw	ra,28(sp)
800034f4:	00912a23          	sw	s1,20(sp)
800034f8:	01212823          	sw	s2,16(sp)
800034fc:	01312623          	sw	s3,12(sp)
80003500:	00800413          	li	s0,8
80003504:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003508:	800064b7          	lui	s1,0x80006
8000350c:	6c048513          	addi	a0,s1,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003510:	00847413          	andi	s0,s0,8
80003514:	5e4010ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003518:	02051e63          	bnez	a0,80003554 <k_sched_lock+0x6c>
8000351c:	80006937          	lui	s2,0x80006
80003520:	800065b7          	lui	a1,0x80006
80003524:	80006537          	lui	a0,0x80006
80003528:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
8000352c:	04e00693          	li	a3,78
80003530:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003534:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003538:	ea0fe0ef          	jal	ra,80001bd8 <printk>
8000353c:	80006537          	lui	a0,0x80006
80003540:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80003544:	e94fe0ef          	jal	ra,80001bd8 <printk>
80003548:	04e00593          	li	a1,78
8000354c:	04090513          	addi	a0,s2,64
80003550:	ec4fe0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80003554:	6c048513          	addi	a0,s1,1728
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80003558:	80007937          	lui	s2,0x80007
8000355c:	5f4010ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
80003560:	98492783          	lw	a5,-1660(s2) # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80003564:	98490913          	addi	s2,s2,-1660
80003568:	02078e63          	beqz	a5,800035a4 <k_sched_lock+0xbc>
8000356c:	800069b7          	lui	s3,0x80006
80003570:	800065b7          	lui	a1,0x80006
80003574:	80006537          	lui	a0,0x80006
80003578:	29058593          	addi	a1,a1,656 # 80006290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006291>
8000357c:	10000693          	li	a3,256
80003580:	27498613          	addi	a2,s3,628 # 80006274 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006275>
80003584:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003588:	e50fe0ef          	jal	ra,80001bd8 <printk>
8000358c:	80006537          	lui	a0,0x80006
80003590:	ff850513          	addi	a0,a0,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
80003594:	e44fe0ef          	jal	ra,80001bd8 <printk>
80003598:	10000593          	li	a1,256
8000359c:	27498513          	addi	a0,s3,628
800035a0:	e74fe0ef          	jal	ra,80001c14 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
800035a4:	00892783          	lw	a5,8(s2)
800035a8:	00f7c703          	lbu	a4,15(a5)
800035ac:	00100793          	li	a5,1
800035b0:	02f71e63          	bne	a4,a5,800035ec <k_sched_lock+0x104>
800035b4:	800069b7          	lui	s3,0x80006
800035b8:	800065b7          	lui	a1,0x80006
800035bc:	80006537          	lui	a0,0x80006
800035c0:	2a858593          	addi	a1,a1,680 # 800062a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062a9>
800035c4:	10100693          	li	a3,257
800035c8:	27498613          	addi	a2,s3,628 # 80006274 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006275>
800035cc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800035d0:	e08fe0ef          	jal	ra,80001bd8 <printk>
800035d4:	80006537          	lui	a0,0x80006
800035d8:	ff850513          	addi	a0,a0,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
800035dc:	dfcfe0ef          	jal	ra,80001bd8 <printk>
800035e0:	10100593          	li	a1,257
800035e4:	27498513          	addi	a0,s3,628
800035e8:	e2cfe0ef          	jal	ra,80001c14 <assert_post_action>

	--_current->base.sched_locked;
800035ec:	00892703          	lw	a4,8(s2)
800035f0:	00f74783          	lbu	a5,15(a4)
800035f4:	fff78793          	addi	a5,a5,-1
800035f8:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800035fc:	6c048513          	addi	a0,s1,1728
80003600:	520010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80003604:	02051e63          	bnez	a0,80003640 <k_sched_lock+0x158>
80003608:	800064b7          	lui	s1,0x80006
8000360c:	800065b7          	lui	a1,0x80006
80003610:	80006537          	lui	a0,0x80006
80003614:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80003618:	06100693          	li	a3,97
8000361c:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003620:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003624:	db4fe0ef          	jal	ra,80001bd8 <printk>
80003628:	80006537          	lui	a0,0x80006
8000362c:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80003630:	da8fe0ef          	jal	ra,80001bd8 <printk>
80003634:	06100593          	li	a1,97
80003638:	04048513          	addi	a0,s1,64
8000363c:	dd8fe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003640:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80003644:	01c12083          	lw	ra,28(sp)
80003648:	01812403          	lw	s0,24(sp)
8000364c:	01412483          	lw	s1,20(sp)
80003650:	01012903          	lw	s2,16(sp)
80003654:	00c12983          	lw	s3,12(sp)
80003658:	02010113          	addi	sp,sp,32
8000365c:	00008067          	ret

80003660 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80003660:	800067b7          	lui	a5,0x80006
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80003664:	5e07a783          	lw	a5,1504(a5) # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
{
80003668:	ff010113          	addi	sp,sp,-16
8000366c:	00812423          	sw	s0,8(sp)
80003670:	00112623          	sw	ra,12(sp)
80003674:	00912223          	sw	s1,4(sp)
80003678:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
8000367c:	02f59863          	bne	a1,a5,800036ac <z_priq_dumb_remove+0x4c>
80003680:	800064b7          	lui	s1,0x80006
80003684:	800065b7          	lui	a1,0x80006
80003688:	80006537          	lui	a0,0x80006
8000368c:	37c58593          	addi	a1,a1,892 # 8000637c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000637d>
80003690:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003694:	28c00693          	li	a3,652
80003698:	2f848613          	addi	a2,s1,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
8000369c:	d3cfe0ef          	jal	ra,80001bd8 <printk>
800036a0:	28c00593          	li	a1,652
800036a4:	2f848513          	addi	a0,s1,760
800036a8:	d6cfe0ef          	jal	ra,80001c14 <assert_post_action>
	node->prev->next = node->next;
800036ac:	00442703          	lw	a4,4(s0)
800036b0:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
800036b4:	00c12083          	lw	ra,12(sp)
800036b8:	00412483          	lw	s1,4(sp)
800036bc:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
800036c0:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
800036c4:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
800036c8:	00042223          	sw	zero,4(s0)
800036cc:	00812403          	lw	s0,8(sp)
800036d0:	01010113          	addi	sp,sp,16
800036d4:	00008067          	ret

800036d8 <z_unpend_thread>:
{
800036d8:	fe010113          	addi	sp,sp,-32
800036dc:	00812c23          	sw	s0,24(sp)
800036e0:	00912a23          	sw	s1,20(sp)
800036e4:	00112e23          	sw	ra,28(sp)
800036e8:	01212823          	sw	s2,16(sp)
800036ec:	01312623          	sw	s3,12(sp)
800036f0:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800036f4:	00800493          	li	s1,8
800036f8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800036fc:	80006937          	lui	s2,0x80006
80003700:	6c090513          	addi	a0,s2,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003704:	0084f493          	andi	s1,s1,8
80003708:	3f0010ef          	jal	ra,80004af8 <z_spin_lock_valid>
8000370c:	02051e63          	bnez	a0,80003748 <z_unpend_thread+0x70>
80003710:	800069b7          	lui	s3,0x80006
80003714:	800065b7          	lui	a1,0x80006
80003718:	80006537          	lui	a0,0x80006
8000371c:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80003720:	04e00693          	li	a3,78
80003724:	04098613          	addi	a2,s3,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003728:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000372c:	cacfe0ef          	jal	ra,80001bd8 <printk>
80003730:	80006537          	lui	a0,0x80006
80003734:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80003738:	ca0fe0ef          	jal	ra,80001bd8 <printk>
8000373c:	04e00593          	li	a1,78
80003740:	04098513          	addi	a0,s3,64
80003744:	cd0fe0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80003748:	6c090513          	addi	a0,s2,1728
8000374c:	404010ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003750:	00840513          	addi	a0,s0,8
80003754:	a29ff0ef          	jal	ra,8000317c <pended_on.isra.15>
80003758:	00040593          	mv	a1,s0
8000375c:	f05ff0ef          	jal	ra,80003660 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003760:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003764:	6c090513          	addi	a0,s2,1728
80003768:	ffd7f793          	andi	a5,a5,-3
8000376c:	00f406a3          	sb	a5,13(s0)
80003770:	3b0010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80003774:	02051e63          	bnez	a0,800037b0 <z_unpend_thread+0xd8>
80003778:	80006937          	lui	s2,0x80006
8000377c:	800065b7          	lui	a1,0x80006
80003780:	80006537          	lui	a0,0x80006
80003784:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80003788:	06100693          	li	a3,97
8000378c:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003790:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003794:	c44fe0ef          	jal	ra,80001bd8 <printk>
80003798:	80006537          	lui	a0,0x80006
8000379c:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
800037a0:	c38fe0ef          	jal	ra,80001bd8 <printk>
800037a4:	06100593          	li	a1,97
800037a8:	04090513          	addi	a0,s2,64
800037ac:	c68fe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800037b0:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800037b4:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800037b8:	01840513          	addi	a0,s0,24
}
800037bc:	01812403          	lw	s0,24(sp)
800037c0:	01c12083          	lw	ra,28(sp)
800037c4:	01412483          	lw	s1,20(sp)
800037c8:	01012903          	lw	s2,16(sp)
800037cc:	00c12983          	lw	s3,12(sp)
800037d0:	02010113          	addi	sp,sp,32
800037d4:	2990106f          	j	8000526c <z_abort_timeout>

800037d8 <z_priq_dumb_best>:
	return list->head == list;
800037d8:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800037dc:	00f51463          	bne	a0,a5,800037e4 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
800037e0:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
800037e4:	00078513          	mv	a0,a5
800037e8:	00008067          	ret

800037ec <update_cache>:
{
800037ec:	ff010113          	addi	sp,sp,-16
800037f0:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800037f4:	80007437          	lui	s0,0x80007
{
800037f8:	01212023          	sw	s2,0(sp)
800037fc:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003800:	98440513          	addi	a0,s0,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80003804:	02450513          	addi	a0,a0,36
{
80003808:	00912223          	sw	s1,4(sp)
8000380c:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003810:	fc9ff0ef          	jal	ra,800037d8 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80003814:	98440413          	addi	s0,s0,-1660
80003818:	00050493          	mv	s1,a0
8000381c:	00051463          	bnez	a0,80003824 <update_cache+0x38>
80003820:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
80003824:	06091e63          	bnez	s2,800038a0 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80003828:	00842783          	lw	a5,8(s0)
8000382c:	02079e63          	bnez	a5,80003868 <update_cache+0x7c>
80003830:	80006937          	lui	s2,0x80006
80003834:	800065b7          	lui	a1,0x80006
80003838:	80006537          	lui	a0,0x80006
8000383c:	32458593          	addi	a1,a1,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
80003840:	07f00693          	li	a3,127
80003844:	2f890613          	addi	a2,s2,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
80003848:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000384c:	b8cfe0ef          	jal	ra,80001bd8 <printk>
80003850:	80006537          	lui	a0,0x80006
80003854:	ff850513          	addi	a0,a0,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
80003858:	b80fe0ef          	jal	ra,80001bd8 <printk>
8000385c:	07f00593          	li	a1,127
80003860:	2f890513          	addi	a0,s2,760
80003864:	bb0fe0ef          	jal	ra,80001c14 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80003868:	00842783          	lw	a5,8(s0)
8000386c:	00d7c703          	lbu	a4,13(a5)
80003870:	01f77713          	andi	a4,a4,31
80003874:	02071663          	bnez	a4,800038a0 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
80003878:	00e7d683          	lhu	a3,14(a5)
8000387c:	07f00713          	li	a4,127
80003880:	02d77063          	bgeu	a4,a3,800038a0 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
80003884:	02f42023          	sw	a5,32(s0)
}
80003888:	00c12083          	lw	ra,12(sp)
8000388c:	00812403          	lw	s0,8(sp)
80003890:	00412483          	lw	s1,4(sp)
80003894:	00012903          	lw	s2,0(sp)
80003898:	01010113          	addi	sp,sp,16
8000389c:	00008067          	ret
		if (th != _current) {
800038a0:	00842783          	lw	a5,8(s0)
800038a4:	00978463          	beq	a5,s1,800038ac <update_cache+0xc0>
			reset_time_slice();
800038a8:	8a1ff0ef          	jal	ra,80003148 <reset_time_slice>
		_kernel.ready_q.cache = th;
800038ac:	02942023          	sw	s1,32(s0)
}
800038b0:	fd9ff06f          	j	80003888 <update_cache+0x9c>

800038b4 <k_sched_unlock>:
{
800038b4:	fe010113          	addi	sp,sp,-32
800038b8:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800038bc:	80007937          	lui	s2,0x80007
800038c0:	98490793          	addi	a5,s2,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
800038c4:	0087a783          	lw	a5,8(a5)
{
800038c8:	00112e23          	sw	ra,28(sp)
800038cc:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800038d0:	00f7c783          	lbu	a5,15(a5)
{
800038d4:	00912a23          	sw	s1,20(sp)
800038d8:	01312623          	sw	s3,12(sp)
800038dc:	98490913          	addi	s2,s2,-1660
	__ASSERT(_current->base.sched_locked != 0, "");
800038e0:	02079e63          	bnez	a5,8000391c <k_sched_unlock+0x68>
800038e4:	80006437          	lui	s0,0x80006
800038e8:	800065b7          	lui	a1,0x80006
800038ec:	80006537          	lui	a0,0x80006
800038f0:	2d058593          	addi	a1,a1,720 # 800062d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062d1>
800038f4:	22100693          	li	a3,545
800038f8:	2f840613          	addi	a2,s0,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
800038fc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003900:	ad8fe0ef          	jal	ra,80001bd8 <printk>
80003904:	80006537          	lui	a0,0x80006
80003908:	ff850513          	addi	a0,a0,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
8000390c:	accfe0ef          	jal	ra,80001bd8 <printk>
80003910:	22100593          	li	a1,545
80003914:	2f840513          	addi	a0,s0,760
80003918:	afcfe0ef          	jal	ra,80001c14 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
8000391c:	00092783          	lw	a5,0(s2)
80003920:	02078e63          	beqz	a5,8000395c <k_sched_unlock+0xa8>
80003924:	80006437          	lui	s0,0x80006
80003928:	800065b7          	lui	a1,0x80006
8000392c:	80006537          	lui	a0,0x80006
80003930:	29058593          	addi	a1,a1,656 # 80006290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006291>
80003934:	22200693          	li	a3,546
80003938:	2f840613          	addi	a2,s0,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
8000393c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003940:	a98fe0ef          	jal	ra,80001bd8 <printk>
80003944:	80006537          	lui	a0,0x80006
80003948:	ff850513          	addi	a0,a0,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
8000394c:	a8cfe0ef          	jal	ra,80001bd8 <printk>
80003950:	22200593          	li	a1,546
80003954:	2f840513          	addi	a0,s0,760
80003958:	abcfe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000395c:	00800413          	li	s0,8
80003960:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003964:	800064b7          	lui	s1,0x80006
80003968:	6c048513          	addi	a0,s1,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000396c:	00847413          	andi	s0,s0,8
80003970:	188010ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003974:	02051e63          	bnez	a0,800039b0 <k_sched_unlock+0xfc>
80003978:	800069b7          	lui	s3,0x80006
8000397c:	800065b7          	lui	a1,0x80006
80003980:	80006537          	lui	a0,0x80006
80003984:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80003988:	04e00693          	li	a3,78
8000398c:	04098613          	addi	a2,s3,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003990:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003994:	a44fe0ef          	jal	ra,80001bd8 <printk>
80003998:	80006537          	lui	a0,0x80006
8000399c:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
800039a0:	a38fe0ef          	jal	ra,80001bd8 <printk>
800039a4:	04e00593          	li	a1,78
800039a8:	04098513          	addi	a0,s3,64
800039ac:	a68fe0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
800039b0:	6c048513          	addi	a0,s1,1728
800039b4:	19c010ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
800039b8:	00892703          	lw	a4,8(s2)
		update_cache(1);
800039bc:	00100513          	li	a0,1
		++_current->base.sched_locked;
800039c0:	00f74783          	lbu	a5,15(a4)
800039c4:	00178793          	addi	a5,a5,1
800039c8:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
800039cc:	e21ff0ef          	jal	ra,800037ec <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800039d0:	6c048513          	addi	a0,s1,1728
800039d4:	14c010ef          	jal	ra,80004b20 <z_spin_unlock_valid>
800039d8:	02051e63          	bnez	a0,80003a14 <k_sched_unlock+0x160>
800039dc:	800064b7          	lui	s1,0x80006
800039e0:	800065b7          	lui	a1,0x80006
800039e4:	80006537          	lui	a0,0x80006
800039e8:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
800039ec:	06100693          	li	a3,97
800039f0:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800039f4:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800039f8:	9e0fe0ef          	jal	ra,80001bd8 <printk>
800039fc:	80006537          	lui	a0,0x80006
80003a00:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80003a04:	9d4fe0ef          	jal	ra,80001bd8 <printk>
80003a08:	06100593          	li	a1,97
80003a0c:	04048513          	addi	a0,s1,64
80003a10:	a04fe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003a14:	30042473          	csrrs	s0,mstatus,s0
}
80003a18:	01812403          	lw	s0,24(sp)
80003a1c:	01c12083          	lw	ra,28(sp)
80003a20:	01412483          	lw	s1,20(sp)
80003a24:	01012903          	lw	s2,16(sp)
80003a28:	00c12983          	lw	s3,12(sp)
80003a2c:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80003a30:	aa9ff06f          	j	800034d8 <z_reschedule_unlocked>

80003a34 <z_add_thread_to_ready_q>:
{
80003a34:	fe010113          	addi	sp,sp,-32
80003a38:	00812c23          	sw	s0,24(sp)
80003a3c:	00912a23          	sw	s1,20(sp)
80003a40:	00112e23          	sw	ra,28(sp)
80003a44:	01212823          	sw	s2,16(sp)
80003a48:	01312623          	sw	s3,12(sp)
80003a4c:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003a50:	00800493          	li	s1,8
80003a54:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a58:	80006937          	lui	s2,0x80006
80003a5c:	6c090513          	addi	a0,s2,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a60:	0084f493          	andi	s1,s1,8
80003a64:	094010ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003a68:	02051e63          	bnez	a0,80003aa4 <z_add_thread_to_ready_q+0x70>
80003a6c:	800069b7          	lui	s3,0x80006
80003a70:	800065b7          	lui	a1,0x80006
80003a74:	80006537          	lui	a0,0x80006
80003a78:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80003a7c:	04e00693          	li	a3,78
80003a80:	04098613          	addi	a2,s3,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003a84:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003a88:	950fe0ef          	jal	ra,80001bd8 <printk>
80003a8c:	80006537          	lui	a0,0x80006
80003a90:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80003a94:	944fe0ef          	jal	ra,80001bd8 <printk>
80003a98:	04e00593          	li	a1,78
80003a9c:	04098513          	addi	a0,s3,64
80003aa0:	974fe0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80003aa4:	6c090513          	addi	a0,s2,1728
80003aa8:	0a8010ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003aac:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003ab0:	5e07a783          	lw	a5,1504(a5) # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
80003ab4:	02f41863          	bne	s0,a5,80003ae4 <z_add_thread_to_ready_q+0xb0>
80003ab8:	800069b7          	lui	s3,0x80006
80003abc:	800065b7          	lui	a1,0x80006
80003ac0:	80006537          	lui	a0,0x80006
80003ac4:	37c58593          	addi	a1,a1,892 # 8000637c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000637d>
80003ac8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003acc:	27600693          	li	a3,630
80003ad0:	2f898613          	addi	a2,s3,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
80003ad4:	904fe0ef          	jal	ra,80001bd8 <printk>
80003ad8:	27600593          	li	a1,630
80003adc:	2f898513          	addi	a0,s3,760
80003ae0:	934fe0ef          	jal	ra,80001c14 <assert_post_action>
	return list->head == list;
80003ae4:	80007737          	lui	a4,0x80007
80003ae8:	98470693          	addi	a3,a4,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80003aec:	0246a783          	lw	a5,36(a3)
80003af0:	0286a603          	lw	a2,40(a3)
80003af4:	800076b7          	lui	a3,0x80007
80003af8:	9a868693          	addi	a3,a3,-1624 # 800069a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a9>
80003afc:	98470713          	addi	a4,a4,-1660
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003b00:	0ad78663          	beq	a5,a3,80003bac <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003b04:	0a078463          	beqz	a5,80003bac <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80003b08:	00e40583          	lb	a1,14(s0)
80003b0c:	00e78503          	lb	a0,14(a5)
80003b10:	08a5d863          	bge	a1,a0,80003ba0 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80003b14:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003b18:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003b1c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003b20:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003b24:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003b28:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80003b2c:	00000513          	li	a0,0
80003b30:	0407e793          	ori	a5,a5,64
80003b34:	00f406a3          	sb	a5,13(s0)
80003b38:	cb5ff0ef          	jal	ra,800037ec <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b3c:	6c090513          	addi	a0,s2,1728
80003b40:	7e1000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80003b44:	02051e63          	bnez	a0,80003b80 <z_add_thread_to_ready_q+0x14c>
80003b48:	80006437          	lui	s0,0x80006
80003b4c:	800065b7          	lui	a1,0x80006
80003b50:	80006537          	lui	a0,0x80006
80003b54:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80003b58:	06100693          	li	a3,97
80003b5c:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003b60:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003b64:	874fe0ef          	jal	ra,80001bd8 <printk>
80003b68:	80006537          	lui	a0,0x80006
80003b6c:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80003b70:	868fe0ef          	jal	ra,80001bd8 <printk>
80003b74:	06100593          	li	a1,97
80003b78:	04040513          	addi	a0,s0,64
80003b7c:	898fe0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003b80:	3004a4f3          	csrrs	s1,mstatus,s1
}
80003b84:	01c12083          	lw	ra,28(sp)
80003b88:	01812403          	lw	s0,24(sp)
80003b8c:	01412483          	lw	s1,20(sp)
80003b90:	01012903          	lw	s2,16(sp)
80003b94:	00c12983          	lw	s3,12(sp)
80003b98:	02010113          	addi	sp,sp,32
80003b9c:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003ba0:	00f60663          	beq	a2,a5,80003bac <z_add_thread_to_ready_q+0x178>
80003ba4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ba8:	f60792e3          	bnez	a5,80003b0c <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80003bac:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80003bb0:	02872783          	lw	a5,40(a4)
	node->next = list;
80003bb4:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80003bb8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003bbc:	02872423          	sw	s0,40(a4)
80003bc0:	f69ff06f          	j	80003b28 <z_add_thread_to_ready_q+0xf4>

80003bc4 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80003bc4:	ff052783          	lw	a5,-16(a0)
{
80003bc8:	fe010113          	addi	sp,sp,-32
80003bcc:	00812c23          	sw	s0,24(sp)
80003bd0:	01312623          	sw	s3,12(sp)
80003bd4:	00112e23          	sw	ra,28(sp)
80003bd8:	00912a23          	sw	s1,20(sp)
80003bdc:	01212823          	sw	s2,16(sp)
80003be0:	01412423          	sw	s4,8(sp)
80003be4:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80003be8:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003bec:	0c078463          	beqz	a5,80003cb4 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003bf0:	00800493          	li	s1,8
80003bf4:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003bf8:	80006937          	lui	s2,0x80006
80003bfc:	6c090513          	addi	a0,s2,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c00:	0084f493          	andi	s1,s1,8
80003c04:	6f5000ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003c08:	02051e63          	bnez	a0,80003c44 <z_thread_timeout+0x80>
80003c0c:	80006a37          	lui	s4,0x80006
80003c10:	800065b7          	lui	a1,0x80006
80003c14:	80006537          	lui	a0,0x80006
80003c18:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80003c1c:	04e00693          	li	a3,78
80003c20:	040a0613          	addi	a2,s4,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003c24:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003c28:	fb1fd0ef          	jal	ra,80001bd8 <printk>
80003c2c:	80006537          	lui	a0,0x80006
80003c30:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80003c34:	fa5fd0ef          	jal	ra,80001bd8 <printk>
80003c38:	04e00593          	li	a1,78
80003c3c:	040a0513          	addi	a0,s4,64
80003c40:	fd5fd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80003c44:	6c090513          	addi	a0,s2,1728
80003c48:	709000ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003c4c:	ff040513          	addi	a0,s0,-16
80003c50:	d2cff0ef          	jal	ra,8000317c <pended_on.isra.15>
80003c54:	00098593          	mv	a1,s3
80003c58:	a09ff0ef          	jal	ra,80003660 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003c5c:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003c60:	6c090513          	addi	a0,s2,1728
80003c64:	ffd7f793          	andi	a5,a5,-3
80003c68:	fef40aa3          	sb	a5,-11(s0)
80003c6c:	6b5000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80003c70:	02051e63          	bnez	a0,80003cac <z_thread_timeout+0xe8>
80003c74:	80006937          	lui	s2,0x80006
80003c78:	800065b7          	lui	a1,0x80006
80003c7c:	80006537          	lui	a0,0x80006
80003c80:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80003c84:	06100693          	li	a3,97
80003c88:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003c8c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003c90:	f49fd0ef          	jal	ra,80001bd8 <printk>
80003c94:	80006537          	lui	a0,0x80006
80003c98:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80003c9c:	f3dfd0ef          	jal	ra,80001bd8 <printk>
80003ca0:	06100593          	li	a1,97
80003ca4:	04090513          	addi	a0,s2,64
80003ca8:	f6dfd0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003cac:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003cb0:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003cb4:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003cb8:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003cbc:	feb7f793          	andi	a5,a5,-21
80003cc0:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003cc4:	c64ff0ef          	jal	ra,80003128 <z_is_thread_ready>
80003cc8:	02050463          	beqz	a0,80003cf0 <z_thread_timeout+0x12c>
}
80003ccc:	01812403          	lw	s0,24(sp)
80003cd0:	01c12083          	lw	ra,28(sp)
80003cd4:	01412483          	lw	s1,20(sp)
80003cd8:	01012903          	lw	s2,16(sp)
80003cdc:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80003ce0:	00098513          	mv	a0,s3
80003ce4:	00c12983          	lw	s3,12(sp)
80003ce8:	02010113          	addi	sp,sp,32
80003cec:	d49ff06f          	j	80003a34 <z_add_thread_to_ready_q>
80003cf0:	01c12083          	lw	ra,28(sp)
80003cf4:	01812403          	lw	s0,24(sp)
80003cf8:	01412483          	lw	s1,20(sp)
80003cfc:	01012903          	lw	s2,16(sp)
80003d00:	00c12983          	lw	s3,12(sp)
80003d04:	00812a03          	lw	s4,8(sp)
80003d08:	02010113          	addi	sp,sp,32
80003d0c:	00008067          	ret

80003d10 <z_move_thread_to_end_of_prio_q>:
{
80003d10:	fe010113          	addi	sp,sp,-32
80003d14:	00812c23          	sw	s0,24(sp)
80003d18:	01212823          	sw	s2,16(sp)
80003d1c:	00112e23          	sw	ra,28(sp)
80003d20:	00912a23          	sw	s1,20(sp)
80003d24:	01312623          	sw	s3,12(sp)
80003d28:	01412423          	sw	s4,8(sp)
80003d2c:	01512223          	sw	s5,4(sp)
80003d30:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d34:	00800913          	li	s2,8
80003d38:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d3c:	800069b7          	lui	s3,0x80006
80003d40:	6c098513          	addi	a0,s3,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003d44:	00897913          	andi	s2,s2,8
80003d48:	5b1000ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003d4c:	02051e63          	bnez	a0,80003d88 <z_move_thread_to_end_of_prio_q+0x78>
80003d50:	800064b7          	lui	s1,0x80006
80003d54:	800065b7          	lui	a1,0x80006
80003d58:	80006537          	lui	a0,0x80006
80003d5c:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80003d60:	04e00693          	li	a3,78
80003d64:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003d68:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003d6c:	e6dfd0ef          	jal	ra,80001bd8 <printk>
80003d70:	80006537          	lui	a0,0x80006
80003d74:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80003d78:	e61fd0ef          	jal	ra,80001bd8 <printk>
80003d7c:	04e00593          	li	a1,78
80003d80:	04048513          	addi	a0,s1,64
80003d84:	e91fd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d88:	6c098513          	addi	a0,s3,1728
80003d8c:	5c5000ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80003d90:	800074b7          	lui	s1,0x80007
80003d94:	98448513          	addi	a0,s1,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80003d98:	00040593          	mv	a1,s0
80003d9c:	02450513          	addi	a0,a0,36
80003da0:	8c1ff0ef          	jal	ra,80003660 <z_priq_dumb_remove>
	return thread == _idle_thread;
80003da4:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003da8:	5e07a783          	lw	a5,1504(a5) # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
80003dac:	80007a37          	lui	s4,0x80007
80003db0:	98448493          	addi	s1,s1,-1660
80003db4:	9a8a0a13          	addi	s4,s4,-1624 # 800069a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a9>
80003db8:	02f41863          	bne	s0,a5,80003de8 <z_move_thread_to_end_of_prio_q+0xd8>
80003dbc:	80006ab7          	lui	s5,0x80006
80003dc0:	800065b7          	lui	a1,0x80006
80003dc4:	80006537          	lui	a0,0x80006
80003dc8:	37c58593          	addi	a1,a1,892 # 8000637c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000637d>
80003dcc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003dd0:	27600693          	li	a3,630
80003dd4:	2f8a8613          	addi	a2,s5,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
80003dd8:	e01fd0ef          	jal	ra,80001bd8 <printk>
80003ddc:	27600593          	li	a1,630
80003de0:	2f8a8513          	addi	a0,s5,760
80003de4:	e31fd0ef          	jal	ra,80001c14 <assert_post_action>
	return list->head == list;
80003de8:	0244a783          	lw	a5,36(s1)
80003dec:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003df0:	0b478e63          	beq	a5,s4,80003eac <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003df4:	0a078c63          	beqz	a5,80003eac <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003df8:	00e40683          	lb	a3,14(s0)
80003dfc:	00e78603          	lb	a2,14(a5)
80003e00:	0ac6d063          	bge	a3,a2,80003ea0 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80003e04:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003e08:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003e0c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003e10:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003e14:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003e18:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003e1c:	0084a503          	lw	a0,8(s1)
80003e20:	0407e793          	ori	a5,a5,64
80003e24:	40850533          	sub	a0,a0,s0
80003e28:	00153513          	seqz	a0,a0
80003e2c:	00f406a3          	sb	a5,13(s0)
80003e30:	9bdff0ef          	jal	ra,800037ec <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003e34:	6c098513          	addi	a0,s3,1728
80003e38:	4e9000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80003e3c:	02051e63          	bnez	a0,80003e78 <z_move_thread_to_end_of_prio_q+0x168>
80003e40:	80006437          	lui	s0,0x80006
80003e44:	800065b7          	lui	a1,0x80006
80003e48:	80006537          	lui	a0,0x80006
80003e4c:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80003e50:	06100693          	li	a3,97
80003e54:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003e58:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003e5c:	d7dfd0ef          	jal	ra,80001bd8 <printk>
80003e60:	80006537          	lui	a0,0x80006
80003e64:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80003e68:	d71fd0ef          	jal	ra,80001bd8 <printk>
80003e6c:	06100593          	li	a1,97
80003e70:	04040513          	addi	a0,s0,64
80003e74:	da1fd0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003e78:	30092973          	csrrs	s2,mstatus,s2
}
80003e7c:	01c12083          	lw	ra,28(sp)
80003e80:	01812403          	lw	s0,24(sp)
80003e84:	01412483          	lw	s1,20(sp)
80003e88:	01012903          	lw	s2,16(sp)
80003e8c:	00c12983          	lw	s3,12(sp)
80003e90:	00812a03          	lw	s4,8(sp)
80003e94:	00412a83          	lw	s5,4(sp)
80003e98:	02010113          	addi	sp,sp,32
80003e9c:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003ea0:	00e78663          	beq	a5,a4,80003eac <z_move_thread_to_end_of_prio_q+0x19c>
80003ea4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ea8:	f4079ae3          	bnez	a5,80003dfc <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003eac:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003eb0:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003eb4:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003eb8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003ebc:	0284a423          	sw	s0,40(s1)
80003ec0:	f59ff06f          	j	80003e18 <z_move_thread_to_end_of_prio_q+0x108>

80003ec4 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003ec4:	800067b7          	lui	a5,0x80006
80003ec8:	6c87a783          	lw	a5,1736(a5) # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
80003ecc:	06078663          	beqz	a5,80003f38 <z_time_slice+0x74>
80003ed0:	800077b7          	lui	a5,0x80007
80003ed4:	98478793          	addi	a5,a5,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80003ed8:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003edc:	07f00693          	li	a3,127
80003ee0:	00e75603          	lhu	a2,14(a4)
80003ee4:	04c6ea63          	bltu	a3,a2,80003f38 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003ee8:	800066b7          	lui	a3,0x80006
80003eec:	00e70603          	lb	a2,14(a4)
80003ef0:	6c46a683          	lw	a3,1732(a3) # 800066c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c5>
80003ef4:	04d64263          	blt	a2,a3,80003f38 <z_time_slice+0x74>
	return thread == _idle_thread;
80003ef8:	800066b7          	lui	a3,0x80006
		&& !is_idle(t)
80003efc:	5e06a683          	lw	a3,1504(a3) # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
80003f00:	02d70c63          	beq	a4,a3,80003f38 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80003f04:	01872683          	lw	a3,24(a4)
80003f08:	02069863          	bnez	a3,80003f38 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003f0c:	0107a683          	lw	a3,16(a5)
80003f10:	02d54063          	blt	a0,a3,80003f30 <z_time_slice+0x6c>
{
80003f14:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003f18:	00070513          	mv	a0,a4
{
80003f1c:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003f20:	df1ff0ef          	jal	ra,80003d10 <z_move_thread_to_end_of_prio_q>
}
80003f24:	00c12083          	lw	ra,12(sp)
80003f28:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003f2c:	a1cff06f          	j	80003148 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003f30:	40a686b3          	sub	a3,a3,a0
80003f34:	00d7a823          	sw	a3,16(a5)
80003f38:	00008067          	ret

80003f3c <z_remove_thread_from_ready_q>:
{
80003f3c:	fe010113          	addi	sp,sp,-32
80003f40:	00812c23          	sw	s0,24(sp)
80003f44:	01312623          	sw	s3,12(sp)
80003f48:	00112e23          	sw	ra,28(sp)
80003f4c:	00912a23          	sw	s1,20(sp)
80003f50:	01212823          	sw	s2,16(sp)
80003f54:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f58:	00800413          	li	s0,8
80003f5c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f60:	800064b7          	lui	s1,0x80006
80003f64:	6c048513          	addi	a0,s1,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f68:	00847413          	andi	s0,s0,8
80003f6c:	38d000ef          	jal	ra,80004af8 <z_spin_lock_valid>
80003f70:	02051e63          	bnez	a0,80003fac <z_remove_thread_from_ready_q+0x70>
80003f74:	80006937          	lui	s2,0x80006
80003f78:	800065b7          	lui	a1,0x80006
80003f7c:	80006537          	lui	a0,0x80006
80003f80:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80003f84:	04e00693          	li	a3,78
80003f88:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80003f8c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80003f90:	c49fd0ef          	jal	ra,80001bd8 <printk>
80003f94:	80006537          	lui	a0,0x80006
80003f98:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80003f9c:	c3dfd0ef          	jal	ra,80001bd8 <printk>
80003fa0:	04e00593          	li	a1,78
80003fa4:	04090513          	addi	a0,s2,64
80003fa8:	c6dfd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80003fac:	6c048513          	addi	a0,s1,1728
80003fb0:	3a1000ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003fb4:	00d9c783          	lbu	a5,13(s3)
80003fb8:	80007937          	lui	s2,0x80007
80003fbc:	98490913          	addi	s2,s2,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80003fc0:	0407f793          	andi	a5,a5,64
80003fc4:	00078e63          	beqz	a5,80003fe0 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003fc8:	00098593          	mv	a1,s3
80003fcc:	02490513          	addi	a0,s2,36
80003fd0:	e90ff0ef          	jal	ra,80003660 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80003fd4:	00d9c783          	lbu	a5,13(s3)
80003fd8:	fbf7f793          	andi	a5,a5,-65
80003fdc:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003fe0:	00892503          	lw	a0,8(s2)
80003fe4:	41350533          	sub	a0,a0,s3
80003fe8:	00153513          	seqz	a0,a0
80003fec:	801ff0ef          	jal	ra,800037ec <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ff0:	6c048513          	addi	a0,s1,1728
80003ff4:	32d000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80003ff8:	02051e63          	bnez	a0,80004034 <z_remove_thread_from_ready_q+0xf8>
80003ffc:	800064b7          	lui	s1,0x80006
80004000:	800065b7          	lui	a1,0x80006
80004004:	80006537          	lui	a0,0x80006
80004008:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
8000400c:	06100693          	li	a3,97
80004010:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80004014:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004018:	bc1fd0ef          	jal	ra,80001bd8 <printk>
8000401c:	80006537          	lui	a0,0x80006
80004020:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80004024:	bb5fd0ef          	jal	ra,80001bd8 <printk>
80004028:	06100593          	li	a1,97
8000402c:	04048513          	addi	a0,s1,64
80004030:	be5fd0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004034:	30042473          	csrrs	s0,mstatus,s0
}
80004038:	01c12083          	lw	ra,28(sp)
8000403c:	01812403          	lw	s0,24(sp)
80004040:	01412483          	lw	s1,20(sp)
80004044:	01012903          	lw	s2,16(sp)
80004048:	00c12983          	lw	s3,12(sp)
8000404c:	02010113          	addi	sp,sp,32
80004050:	00008067          	ret

80004054 <pend>:
{
80004054:	fe010113          	addi	sp,sp,-32
80004058:	00812c23          	sw	s0,24(sp)
8000405c:	00912a23          	sw	s1,20(sp)
80004060:	00050413          	mv	s0,a0
80004064:	01212823          	sw	s2,16(sp)
80004068:	00112e23          	sw	ra,28(sp)
8000406c:	01312623          	sw	s3,12(sp)
80004070:	00058493          	mv	s1,a1
80004074:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80004078:	ec5ff0ef          	jal	ra,80003f3c <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
8000407c:	00d44783          	lbu	a5,13(s0)
80004080:	0027e793          	ori	a5,a5,2
80004084:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80004088:	06048663          	beqz	s1,800040f4 <pend+0xa0>
	return thread == _idle_thread;
8000408c:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80004090:	5e07a783          	lw	a5,1504(a5) # 800065e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e1>
		thread->base.pended_on = wait_q;
80004094:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80004098:	02f41863          	bne	s0,a5,800040c8 <pend+0x74>
8000409c:	800069b7          	lui	s3,0x80006
800040a0:	800065b7          	lui	a1,0x80006
800040a4:	80006537          	lui	a0,0x80006
800040a8:	37c58593          	addi	a1,a1,892 # 8000637c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000637d>
800040ac:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800040b0:	27600693          	li	a3,630
800040b4:	2f898613          	addi	a2,s3,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
800040b8:	b21fd0ef          	jal	ra,80001bd8 <printk>
800040bc:	27600593          	li	a1,630
800040c0:	2f898513          	addi	a0,s3,760
800040c4:	b51fd0ef          	jal	ra,80001c14 <assert_post_action>
	return list->head == list;
800040c8:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800040cc:	06f48c63          	beq	s1,a5,80004144 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800040d0:	06078a63          	beqz	a5,80004144 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
800040d4:	00e40703          	lb	a4,14(s0)
800040d8:	00e78683          	lb	a3,14(a5)
800040dc:	04d75c63          	bge	a4,a3,80004134 <pend+0xe0>
	node->prev = successor->prev;
800040e0:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800040e4:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
800040e8:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800040ec:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800040f0:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
800040f4:	fff00793          	li	a5,-1
800040f8:	06f90463          	beq	s2,a5,80004160 <pend+0x10c>
800040fc:	00a00593          	li	a1,10
80004100:	00990513          	addi	a0,s2,9
80004104:	fa4fc0ef          	jal	ra,800008a8 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004108:	00150613          	addi	a2,a0,1
8000410c:	01840513          	addi	a0,s0,24
}
80004110:	01812403          	lw	s0,24(sp)
80004114:	01c12083          	lw	ra,28(sp)
80004118:	01412483          	lw	s1,20(sp)
8000411c:	01012903          	lw	s2,16(sp)
80004120:	00c12983          	lw	s3,12(sp)
80004124:	800045b7          	lui	a1,0x80004
80004128:	bc458593          	addi	a1,a1,-1084 # 80003bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003bc5>
8000412c:	02010113          	addi	sp,sp,32
80004130:	7110006f          	j	80005040 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80004134:	0044a683          	lw	a3,4(s1)
80004138:	00d78663          	beq	a5,a3,80004144 <pend+0xf0>
8000413c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004140:	f8079ce3          	bnez	a5,800040d8 <pend+0x84>
	node->prev = list->tail;
80004144:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004148:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
8000414c:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004150:	0044a783          	lw	a5,4(s1)
80004154:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004158:	0084a223          	sw	s0,4(s1)
8000415c:	f99ff06f          	j	800040f4 <pend+0xa0>
}
80004160:	01c12083          	lw	ra,28(sp)
80004164:	01812403          	lw	s0,24(sp)
80004168:	01412483          	lw	s1,20(sp)
8000416c:	01012903          	lw	s2,16(sp)
80004170:	00c12983          	lw	s3,12(sp)
80004174:	02010113          	addi	sp,sp,32
80004178:	00008067          	ret

8000417c <z_pend_thread>:
	__ASSERT_NO_MSG(thread == _current || is_thread_dummy(thread));
8000417c:	800077b7          	lui	a5,0x80007
80004180:	98c7a783          	lw	a5,-1652(a5) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
{
80004184:	fe010113          	addi	sp,sp,-32
80004188:	00812c23          	sw	s0,24(sp)
8000418c:	01212823          	sw	s2,16(sp)
80004190:	01312623          	sw	s3,12(sp)
80004194:	00112e23          	sw	ra,28(sp)
80004198:	00912a23          	sw	s1,20(sp)
8000419c:	00050413          	mv	s0,a0
800041a0:	00058913          	mv	s2,a1
800041a4:	00060993          	mv	s3,a2
	__ASSERT_NO_MSG(thread == _current || is_thread_dummy(thread));
800041a8:	02a78e63          	beq	a5,a0,800041e4 <z_pend_thread+0x68>
800041ac:	00d54783          	lbu	a5,13(a0)
800041b0:	0017f793          	andi	a5,a5,1
800041b4:	02079863          	bnez	a5,800041e4 <z_pend_thread+0x68>
800041b8:	800064b7          	lui	s1,0x80006
800041bc:	800065b7          	lui	a1,0x80006
800041c0:	80006537          	lui	a0,0x80006
800041c4:	34458593          	addi	a1,a1,836 # 80006344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006345>
800041c8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800041cc:	17d00693          	li	a3,381
800041d0:	2f848613          	addi	a2,s1,760 # 800062f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f9>
800041d4:	a05fd0ef          	jal	ra,80001bd8 <printk>
800041d8:	17d00593          	li	a1,381
800041dc:	2f848513          	addi	a0,s1,760
800041e0:	a35fd0ef          	jal	ra,80001c14 <assert_post_action>
	pend(thread, wait_q, timeout);
800041e4:	00040513          	mv	a0,s0
}
800041e8:	01812403          	lw	s0,24(sp)
800041ec:	01c12083          	lw	ra,28(sp)
800041f0:	01412483          	lw	s1,20(sp)
	pend(thread, wait_q, timeout);
800041f4:	00098613          	mv	a2,s3
800041f8:	00090593          	mv	a1,s2
}
800041fc:	00c12983          	lw	s3,12(sp)
80004200:	01012903          	lw	s2,16(sp)
80004204:	02010113          	addi	sp,sp,32
	pend(thread, wait_q, timeout);
80004208:	e4dff06f          	j	80004054 <pend>

8000420c <z_pend_curr>:
{
8000420c:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80004210:	800077b7          	lui	a5,0x80007
{
80004214:	00812423          	sw	s0,8(sp)
80004218:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
8000421c:	98c7a503          	lw	a0,-1652(a5) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
{
80004220:	00912223          	sw	s1,4(sp)
80004224:	00058493          	mv	s1,a1
80004228:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
8000422c:	00068613          	mv	a2,a3
{
80004230:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80004234:	e21ff0ef          	jal	ra,80004054 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004238:	00040513          	mv	a0,s0
8000423c:	0e5000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80004240:	02051e63          	bnez	a0,8000427c <z_pend_curr+0x70>
80004244:	80006437          	lui	s0,0x80006
80004248:	800065b7          	lui	a1,0x80006
8000424c:	80006537          	lui	a0,0x80006
80004250:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80004254:	07800693          	li	a3,120
80004258:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
8000425c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004260:	979fd0ef          	jal	ra,80001bd8 <printk>
80004264:	80006537          	lui	a0,0x80006
80004268:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
8000426c:	96dfd0ef          	jal	ra,80001bd8 <printk>
80004270:	07800593          	li	a1,120
80004274:	04040513          	addi	a0,s0,64
80004278:	99dfd0ef          	jal	ra,80001c14 <assert_post_action>
}
8000427c:	00812403          	lw	s0,8(sp)
80004280:	00c12083          	lw	ra,12(sp)
80004284:	00048513          	mv	a0,s1
80004288:	00412483          	lw	s1,4(sp)
8000428c:	01010113          	addi	sp,sp,16
80004290:	f99fb06f          	j	80000228 <__swap>

80004294 <z_unpend_first_thread>:
{
80004294:	fe010113          	addi	sp,sp,-32
80004298:	01212823          	sw	s2,16(sp)
8000429c:	01312623          	sw	s3,12(sp)
800042a0:	00112e23          	sw	ra,28(sp)
800042a4:	00812c23          	sw	s0,24(sp)
800042a8:	00912a23          	sw	s1,20(sp)
800042ac:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800042b0:	00800913          	li	s2,8
800042b4:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800042b8:	800064b7          	lui	s1,0x80006
800042bc:	6c048513          	addi	a0,s1,1728 # 800066c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c1>
	key = (mstatus & SOC_MSTATUS_IEN);
800042c0:	00897913          	andi	s2,s2,8
800042c4:	035000ef          	jal	ra,80004af8 <z_spin_lock_valid>
800042c8:	02051e63          	bnez	a0,80004304 <z_unpend_first_thread+0x70>
800042cc:	80006437          	lui	s0,0x80006
800042d0:	800065b7          	lui	a1,0x80006
800042d4:	80006537          	lui	a0,0x80006
800042d8:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800042dc:	04e00693          	li	a3,78
800042e0:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800042e4:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800042e8:	8f1fd0ef          	jal	ra,80001bd8 <printk>
800042ec:	80006537          	lui	a0,0x80006
800042f0:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
800042f4:	8e5fd0ef          	jal	ra,80001bd8 <printk>
800042f8:	04e00593          	li	a1,78
800042fc:	04040513          	addi	a0,s0,64
80004300:	915fd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80004304:	6c048513          	addi	a0,s1,1728
80004308:	049000ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
8000430c:	00098513          	mv	a0,s3
80004310:	cc8ff0ef          	jal	ra,800037d8 <z_priq_dumb_best>
80004314:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004318:	6c048513          	addi	a0,s1,1728
8000431c:	005000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80004320:	02051e63          	bnez	a0,8000435c <z_unpend_first_thread+0xc8>
80004324:	800069b7          	lui	s3,0x80006
80004328:	800065b7          	lui	a1,0x80006
8000432c:	80006537          	lui	a0,0x80006
80004330:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80004334:	06100693          	li	a3,97
80004338:	04098613          	addi	a2,s3,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
8000433c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004340:	899fd0ef          	jal	ra,80001bd8 <printk>
80004344:	80006537          	lui	a0,0x80006
80004348:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
8000434c:	88dfd0ef          	jal	ra,80001bd8 <printk>
80004350:	06100593          	li	a1,97
80004354:	04098513          	addi	a0,s3,64
80004358:	8bdfd0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000435c:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80004360:	0c040663          	beqz	s0,8000442c <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004364:	00800913          	li	s2,8
80004368:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000436c:	6c048513          	addi	a0,s1,1728
	key = (mstatus & SOC_MSTATUS_IEN);
80004370:	00897913          	andi	s2,s2,8
80004374:	784000ef          	jal	ra,80004af8 <z_spin_lock_valid>
80004378:	02051e63          	bnez	a0,800043b4 <z_unpend_first_thread+0x120>
8000437c:	800069b7          	lui	s3,0x80006
80004380:	800065b7          	lui	a1,0x80006
80004384:	80006537          	lui	a0,0x80006
80004388:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
8000438c:	04e00693          	li	a3,78
80004390:	04098613          	addi	a2,s3,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80004394:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004398:	841fd0ef          	jal	ra,80001bd8 <printk>
8000439c:	80006537          	lui	a0,0x80006
800043a0:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
800043a4:	835fd0ef          	jal	ra,80001bd8 <printk>
800043a8:	04e00593          	li	a1,78
800043ac:	04098513          	addi	a0,s3,64
800043b0:	865fd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
800043b4:	6c048513          	addi	a0,s1,1728
800043b8:	798000ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800043bc:	00840513          	addi	a0,s0,8
800043c0:	dbdfe0ef          	jal	ra,8000317c <pended_on.isra.15>
800043c4:	00040593          	mv	a1,s0
800043c8:	a98ff0ef          	jal	ra,80003660 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800043cc:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800043d0:	6c048513          	addi	a0,s1,1728
800043d4:	ffd7f793          	andi	a5,a5,-3
800043d8:	00f406a3          	sb	a5,13(s0)
800043dc:	744000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
800043e0:	02051e63          	bnez	a0,8000441c <z_unpend_first_thread+0x188>
800043e4:	800064b7          	lui	s1,0x80006
800043e8:	800065b7          	lui	a1,0x80006
800043ec:	80006537          	lui	a0,0x80006
800043f0:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
800043f4:	06100693          	li	a3,97
800043f8:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800043fc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004400:	fd8fd0ef          	jal	ra,80001bd8 <printk>
80004404:	80006537          	lui	a0,0x80006
80004408:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
8000440c:	fccfd0ef          	jal	ra,80001bd8 <printk>
80004410:	06100593          	li	a1,97
80004414:	04048513          	addi	a0,s1,64
80004418:	ffcfd0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000441c:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80004420:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80004424:	01840513          	addi	a0,s0,24
80004428:	645000ef          	jal	ra,8000526c <z_abort_timeout>
}
8000442c:	00040513          	mv	a0,s0
80004430:	01c12083          	lw	ra,28(sp)
80004434:	01812403          	lw	s0,24(sp)
80004438:	01412483          	lw	s1,20(sp)
8000443c:	01012903          	lw	s2,16(sp)
80004440:	00c12983          	lw	s3,12(sp)
80004444:	02010113          	addi	sp,sp,32
80004448:	00008067          	ret

8000444c <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
8000444c:	ff010113          	addi	sp,sp,-16
80004450:	00912223          	sw	s1,4(sp)
80004454:	01212023          	sw	s2,0(sp)
80004458:	00112623          	sw	ra,12(sp)
8000445c:	00812423          	sw	s0,8(sp)
80004460:	00050913          	mv	s2,a0
	int need_sched = 0;
80004464:	00000493          	li	s1,0
	return list->head == list;
80004468:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000446c:	00890463          	beq	s2,s0,80004474 <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80004470:	02041063          	bnez	s0,80004490 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80004474:	00c12083          	lw	ra,12(sp)
80004478:	00812403          	lw	s0,8(sp)
8000447c:	00048513          	mv	a0,s1
80004480:	00012903          	lw	s2,0(sp)
80004484:	00412483          	lw	s1,4(sp)
80004488:	01010113          	addi	sp,sp,16
8000448c:	00008067          	ret
		z_unpend_thread(th);
80004490:	00040513          	mv	a0,s0
80004494:	a44ff0ef          	jal	ra,800036d8 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80004498:	00040513          	mv	a0,s0
8000449c:	c8dfe0ef          	jal	ra,80003128 <z_is_thread_ready>
		need_sched = 1;
800044a0:	00100493          	li	s1,1
800044a4:	fc0502e3          	beqz	a0,80004468 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
800044a8:	00040513          	mv	a0,s0
800044ac:	d88ff0ef          	jal	ra,80003a34 <z_add_thread_to_ready_q>
800044b0:	fb9ff06f          	j	80004468 <z_unpend_all+0x1c>

800044b4 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
800044b4:	800077b7          	lui	a5,0x80007
800044b8:	98478793          	addi	a5,a5,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
800044bc:	02478713          	addi	a4,a5,36
800044c0:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
800044c4:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
800044c8:	00000593          	li	a1,0
800044cc:	00000513          	li	a0,0
800044d0:	d0dfe06f          	j	800031dc <k_sched_time_slice_set>

800044d4 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800044d4:	800077b7          	lui	a5,0x80007
800044d8:	98c7a503          	lw	a0,-1652(a5) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
800044dc:	00008067          	ret

800044e0 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800044e0:	fe010113          	addi	sp,sp,-32
800044e4:	00812c23          	sw	s0,24(sp)
800044e8:	00912a23          	sw	s1,20(sp)
800044ec:	01212823          	sw	s2,16(sp)
800044f0:	00112e23          	sw	ra,28(sp)
800044f4:	01312623          	sw	s3,12(sp)
800044f8:	00050413          	mv	s0,a0
800044fc:	00058913          	mv	s2,a1
80004500:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80004504:	02061e63          	bnez	a2,80004540 <z_impl_k_sem_init+0x60>
80004508:	800069b7          	lui	s3,0x80006
8000450c:	800065b7          	lui	a1,0x80006
80004510:	80006537          	lui	a0,0x80006
80004514:	3a058593          	addi	a1,a1,928 # 800063a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063a1>
80004518:	04600693          	li	a3,70
8000451c:	39098613          	addi	a2,s3,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
80004520:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004524:	eb4fd0ef          	jal	ra,80001bd8 <printk>
80004528:	80006537          	lui	a0,0x80006
8000452c:	3ac50513          	addi	a0,a0,940 # 800063ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063ad>
80004530:	ea8fd0ef          	jal	ra,80001bd8 <printk>
80004534:	04600593          	li	a1,70
80004538:	39098513          	addi	a0,s3,912
8000453c:	ed8fd0ef          	jal	ra,80001c14 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80004540:	0324fe63          	bgeu	s1,s2,8000457c <z_impl_k_sem_init+0x9c>
80004544:	800069b7          	lui	s3,0x80006
80004548:	800065b7          	lui	a1,0x80006
8000454c:	80006537          	lui	a0,0x80006
80004550:	3c458593          	addi	a1,a1,964 # 800063c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063c5>
80004554:	04700693          	li	a3,71
80004558:	39098613          	addi	a2,s3,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
8000455c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004560:	e78fd0ef          	jal	ra,80001bd8 <printk>
80004564:	80006537          	lui	a0,0x80006
80004568:	3dc50513          	addi	a0,a0,988 # 800063dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063dd>
8000456c:	e6cfd0ef          	jal	ra,80001bd8 <printk>
80004570:	04700593          	li	a1,71
80004574:	39098513          	addi	a0,s3,912
80004578:	e9cfd0ef          	jal	ra,80001c14 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
8000457c:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80004580:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80004584:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80004588:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
8000458c:	01c12083          	lw	ra,28(sp)
80004590:	01812403          	lw	s0,24(sp)
80004594:	01412483          	lw	s1,20(sp)
80004598:	01012903          	lw	s2,16(sp)
8000459c:	00c12983          	lw	s3,12(sp)
800045a0:	02010113          	addi	sp,sp,32
800045a4:	00008067          	ret

800045a8 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800045a8:	fe010113          	addi	sp,sp,-32
800045ac:	00912a23          	sw	s1,20(sp)
800045b0:	01312623          	sw	s3,12(sp)
800045b4:	00112e23          	sw	ra,28(sp)
800045b8:	00812c23          	sw	s0,24(sp)
800045bc:	01212823          	sw	s2,16(sp)
800045c0:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800045c4:	00800493          	li	s1,8
800045c8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800045cc:	80006437          	lui	s0,0x80006
800045d0:	6cc40513          	addi	a0,s0,1740 # 800066cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066cd>
	key = (mstatus & SOC_MSTATUS_IEN);
800045d4:	0084f493          	andi	s1,s1,8
800045d8:	520000ef          	jal	ra,80004af8 <z_spin_lock_valid>
800045dc:	02051e63          	bnez	a0,80004618 <z_impl_k_sem_give+0x70>
800045e0:	80006937          	lui	s2,0x80006
800045e4:	800065b7          	lui	a1,0x80006
800045e8:	80006537          	lui	a0,0x80006
800045ec:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800045f0:	04e00693          	li	a3,78
800045f4:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800045f8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800045fc:	ddcfd0ef          	jal	ra,80001bd8 <printk>
80004600:	80006537          	lui	a0,0x80006
80004604:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80004608:	dd0fd0ef          	jal	ra,80001bd8 <printk>
8000460c:	04e00593          	li	a1,78
80004610:	04090513          	addi	a0,s2,64
80004614:	e00fd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80004618:	6cc40513          	addi	a0,s0,1740
8000461c:	534000ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80004620:	00098513          	mv	a0,s3
80004624:	c71ff0ef          	jal	ra,80004294 <z_unpend_first_thread>
80004628:	00050913          	mv	s2,a0
	if (thread != NULL) {
8000462c:	04050263          	beqz	a0,80004670 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004630:	00d54783          	lbu	a5,13(a0)
80004634:	01f7f793          	andi	a5,a5,31
80004638:	00079863          	bnez	a5,80004648 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
8000463c:	01852783          	lw	a5,24(a0)
80004640:	00079463          	bnez	a5,80004648 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80004644:	bf0ff0ef          	jal	ra,80003a34 <z_add_thread_to_ready_q>
80004648:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
8000464c:	6cc40513          	addi	a0,s0,1740
}
80004650:	01812403          	lw	s0,24(sp)
80004654:	01c12083          	lw	ra,28(sp)
80004658:	01012903          	lw	s2,16(sp)
8000465c:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004660:	00048593          	mv	a1,s1
}
80004664:	01412483          	lw	s1,20(sp)
80004668:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
8000466c:	d7dfe06f          	j	800033e8 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80004670:	0089a703          	lw	a4,8(s3)
80004674:	00c9a783          	lw	a5,12(s3)
80004678:	40e787b3          	sub	a5,a5,a4
8000467c:	00f037b3          	snez	a5,a5
80004680:	00e787b3          	add	a5,a5,a4
80004684:	00f9a423          	sw	a5,8(s3)
80004688:	fc5ff06f          	j	8000464c <z_impl_k_sem_give+0xa4>

8000468c <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000468c:	800077b7          	lui	a5,0x80007
80004690:	9847a783          	lw	a5,-1660(a5) # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
{
80004694:	fe010113          	addi	sp,sp,-32
80004698:	01212823          	sw	s2,16(sp)
8000469c:	01312623          	sw	s3,12(sp)
800046a0:	00112e23          	sw	ra,28(sp)
800046a4:	00812c23          	sw	s0,24(sp)
800046a8:	00912a23          	sw	s1,20(sp)
800046ac:	01412423          	sw	s4,8(sp)
800046b0:	00050913          	mv	s2,a0
800046b4:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800046b8:	04078063          	beqz	a5,800046f8 <z_impl_k_sem_take+0x6c>
800046bc:	02058e63          	beqz	a1,800046f8 <z_impl_k_sem_take+0x6c>
800046c0:	80006437          	lui	s0,0x80006
800046c4:	800065b7          	lui	a1,0x80006
800046c8:	80006537          	lui	a0,0x80006
800046cc:	40458593          	addi	a1,a1,1028 # 80006404 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006405>
800046d0:	08c00693          	li	a3,140
800046d4:	39040613          	addi	a2,s0,912 # 80006390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006391>
800046d8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800046dc:	cfcfd0ef          	jal	ra,80001bd8 <printk>
800046e0:	80006537          	lui	a0,0x80006
800046e4:	ff850513          	addi	a0,a0,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
800046e8:	cf0fd0ef          	jal	ra,80001bd8 <printk>
800046ec:	08c00593          	li	a1,140
800046f0:	39040513          	addi	a0,s0,912
800046f4:	d20fd0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800046f8:	00800413          	li	s0,8
800046fc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004700:	800064b7          	lui	s1,0x80006
80004704:	6cc48513          	addi	a0,s1,1740 # 800066cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066cd>
	key = (mstatus & SOC_MSTATUS_IEN);
80004708:	00847413          	andi	s0,s0,8
8000470c:	3ec000ef          	jal	ra,80004af8 <z_spin_lock_valid>
80004710:	02051e63          	bnez	a0,8000474c <z_impl_k_sem_take+0xc0>
80004714:	80006a37          	lui	s4,0x80006
80004718:	800065b7          	lui	a1,0x80006
8000471c:	80006537          	lui	a0,0x80006
80004720:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80004724:	04e00693          	li	a3,78
80004728:	040a0613          	addi	a2,s4,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
8000472c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004730:	ca8fd0ef          	jal	ra,80001bd8 <printk>
80004734:	80006537          	lui	a0,0x80006
80004738:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
8000473c:	c9cfd0ef          	jal	ra,80001bd8 <printk>
80004740:	04e00593          	li	a1,78
80004744:	040a0513          	addi	a0,s4,64
80004748:	cccfd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
8000474c:	6cc48513          	addi	a0,s1,1740
80004750:	400000ef          	jal	ra,80004b50 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80004754:	00892783          	lw	a5,8(s2)
80004758:	06078c63          	beqz	a5,800047d0 <z_impl_k_sem_take+0x144>
		sem->count--;
8000475c:	fff78793          	addi	a5,a5,-1
80004760:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004764:	6cc48513          	addi	a0,s1,1740
80004768:	3b8000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
8000476c:	02051e63          	bnez	a0,800047a8 <z_impl_k_sem_take+0x11c>
80004770:	800064b7          	lui	s1,0x80006
80004774:	800065b7          	lui	a1,0x80006
80004778:	80006537          	lui	a0,0x80006
8000477c:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80004780:	06100693          	li	a3,97
80004784:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80004788:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000478c:	c4cfd0ef          	jal	ra,80001bd8 <printk>
80004790:	80006537          	lui	a0,0x80006
80004794:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80004798:	c40fd0ef          	jal	ra,80001bd8 <printk>
8000479c:	06100593          	li	a1,97
800047a0:	04048513          	addi	a0,s1,64
800047a4:	c70fd0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800047a8:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
800047ac:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800047b0:	01c12083          	lw	ra,28(sp)
800047b4:	01812403          	lw	s0,24(sp)
800047b8:	01412483          	lw	s1,20(sp)
800047bc:	01012903          	lw	s2,16(sp)
800047c0:	00c12983          	lw	s3,12(sp)
800047c4:	00812a03          	lw	s4,8(sp)
800047c8:	02010113          	addi	sp,sp,32
800047cc:	00008067          	ret
	if (timeout == K_NO_WAIT) {
800047d0:	04099a63          	bnez	s3,80004824 <z_impl_k_sem_take+0x198>
800047d4:	6cc48513          	addi	a0,s1,1740
800047d8:	348000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
800047dc:	02051e63          	bnez	a0,80004818 <z_impl_k_sem_take+0x18c>
800047e0:	800064b7          	lui	s1,0x80006
800047e4:	800065b7          	lui	a1,0x80006
800047e8:	80006537          	lui	a0,0x80006
800047ec:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
800047f0:	06100693          	li	a3,97
800047f4:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800047f8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800047fc:	bdcfd0ef          	jal	ra,80001bd8 <printk>
80004800:	80006537          	lui	a0,0x80006
80004804:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80004808:	bd0fd0ef          	jal	ra,80001bd8 <printk>
8000480c:	06100593          	li	a1,97
80004810:	04048513          	addi	a0,s1,64
80004814:	c00fd0ef          	jal	ra,80001c14 <assert_post_action>
80004818:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
8000481c:	ff000513          	li	a0,-16
80004820:	f91ff06f          	j	800047b0 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004824:	00040593          	mv	a1,s0
}
80004828:	01812403          	lw	s0,24(sp)
8000482c:	01c12083          	lw	ra,28(sp)
80004830:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004834:	00098693          	mv	a3,s3
80004838:	00090613          	mv	a2,s2
}
8000483c:	00c12983          	lw	s3,12(sp)
80004840:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004844:	6cc48513          	addi	a0,s1,1740
}
80004848:	01412483          	lw	s1,20(sp)
8000484c:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004850:	9bdff06f          	j	8000420c <z_pend_curr>

80004854 <z_impl_k_stack_push>:
void z_impl_k_stack_push(struct k_stack *stack, u32_t data)
{
	struct k_thread *first_pending_thread;
	k_spinlock_key_t key;

	__ASSERT(stack->next != stack->top, "stack is full");
80004854:	01052703          	lw	a4,16(a0)
80004858:	01452783          	lw	a5,20(a0)
{
8000485c:	fe010113          	addi	sp,sp,-32
80004860:	00912a23          	sw	s1,20(sp)
80004864:	01412423          	sw	s4,8(sp)
80004868:	00112e23          	sw	ra,28(sp)
8000486c:	00812c23          	sw	s0,24(sp)
80004870:	01212823          	sw	s2,16(sp)
80004874:	01312623          	sw	s3,12(sp)
80004878:	00050493          	mv	s1,a0
8000487c:	00058a13          	mv	s4,a1
	__ASSERT(stack->next != stack->top, "stack is full");
80004880:	02f71e63          	bne	a4,a5,800048bc <z_impl_k_stack_push+0x68>
80004884:	80006437          	lui	s0,0x80006
80004888:	800065b7          	lui	a1,0x80006
8000488c:	80006537          	lui	a0,0x80006
80004890:	47858593          	addi	a1,a1,1144 # 80006478 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006479>
80004894:	06800693          	li	a3,104
80004898:	43840613          	addi	a2,s0,1080 # 80006438 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006439>
8000489c:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800048a0:	b38fd0ef          	jal	ra,80001bd8 <printk>
800048a4:	80006537          	lui	a0,0x80006
800048a8:	49450513          	addi	a0,a0,1172 # 80006494 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006495>
800048ac:	b2cfd0ef          	jal	ra,80001bd8 <printk>
800048b0:	06800593          	li	a1,104
800048b4:	43840513          	addi	a0,s0,1080
800048b8:	b5cfd0ef          	jal	ra,80001c14 <assert_post_action>

	key = k_spin_lock(&stack->lock);
800048bc:	00848993          	addi	s3,s1,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
800048c0:	00800413          	li	s0,8
800048c4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800048c8:	00098513          	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
800048cc:	00847413          	andi	s0,s0,8
800048d0:	228000ef          	jal	ra,80004af8 <z_spin_lock_valid>
800048d4:	02051e63          	bnez	a0,80004910 <z_impl_k_stack_push+0xbc>
800048d8:	80006937          	lui	s2,0x80006
800048dc:	800065b7          	lui	a1,0x80006
800048e0:	80006537          	lui	a0,0x80006
800048e4:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800048e8:	04e00693          	li	a3,78
800048ec:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800048f0:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800048f4:	ae4fd0ef          	jal	ra,80001bd8 <printk>
800048f8:	80006537          	lui	a0,0x80006
800048fc:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80004900:	ad8fd0ef          	jal	ra,80001bd8 <printk>
80004904:	04e00593          	li	a1,78
80004908:	04090513          	addi	a0,s2,64
8000490c:	b08fd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80004910:	00098513          	mv	a0,s3
80004914:	23c000ef          	jal	ra,80004b50 <z_spin_lock_set_owner>

	first_pending_thread = z_unpend_first_thread(&stack->wait_q);
80004918:	00048513          	mv	a0,s1
8000491c:	979ff0ef          	jal	ra,80004294 <z_unpend_first_thread>
80004920:	00050913          	mv	s2,a0

	if (first_pending_thread != NULL) {
80004924:	04050663          	beqz	a0,80004970 <z_impl_k_stack_push+0x11c>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004928:	00d54783          	lbu	a5,13(a0)
8000492c:	01f7f793          	andi	a5,a5,31
80004930:	00079863          	bnez	a5,80004940 <z_impl_k_stack_push+0xec>
	if (z_is_thread_ready(thread)) {
80004934:	01852783          	lw	a5,24(a0)
80004938:	00079463          	bnez	a5,80004940 <z_impl_k_stack_push+0xec>
		z_add_thread_to_ready_q(thread);
8000493c:	8f8ff0ef          	jal	ra,80003a34 <z_add_thread_to_ready_q>
		z_ready_thread(first_pending_thread);

		z_set_thread_return_value_with_data(first_pending_thread,
						   0, (void *)data);
		z_reschedule(&stack->lock, key);
80004940:	00040593          	mv	a1,s0
		*(stack->next) = data;
		stack->next++;
		k_spin_unlock(&stack->lock, key);
	}

}
80004944:	01812403          	lw	s0,24(sp)
	thread->base.swap_data = data;
80004948:	01492a23          	sw	s4,20(s2)
8000494c:	06092623          	sw	zero,108(s2)
80004950:	01c12083          	lw	ra,28(sp)
80004954:	01412483          	lw	s1,20(sp)
80004958:	01012903          	lw	s2,16(sp)
8000495c:	00812a03          	lw	s4,8(sp)
		z_reschedule(&stack->lock, key);
80004960:	00098513          	mv	a0,s3
}
80004964:	00c12983          	lw	s3,12(sp)
80004968:	02010113          	addi	sp,sp,32
		z_reschedule(&stack->lock, key);
8000496c:	a7dfe06f          	j	800033e8 <z_reschedule>
		*(stack->next) = data;
80004970:	0104a783          	lw	a5,16(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004974:	00098513          	mv	a0,s3
80004978:	0147a023          	sw	s4,0(a5)
		stack->next++;
8000497c:	00478793          	addi	a5,a5,4
80004980:	00f4a823          	sw	a5,16(s1)
80004984:	19c000ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80004988:	02051e63          	bnez	a0,800049c4 <z_impl_k_stack_push+0x170>
8000498c:	800064b7          	lui	s1,0x80006
80004990:	800065b7          	lui	a1,0x80006
80004994:	80006537          	lui	a0,0x80006
80004998:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
8000499c:	06100693          	li	a3,97
800049a0:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800049a4:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800049a8:	a30fd0ef          	jal	ra,80001bd8 <printk>
800049ac:	80006537          	lui	a0,0x80006
800049b0:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
800049b4:	a24fd0ef          	jal	ra,80001bd8 <printk>
800049b8:	06100593          	li	a1,97
800049bc:	04048513          	addi	a0,s1,64
800049c0:	a54fd0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800049c4:	30042473          	csrrs	s0,mstatus,s0
}
800049c8:	01c12083          	lw	ra,28(sp)
800049cc:	01812403          	lw	s0,24(sp)
800049d0:	01412483          	lw	s1,20(sp)
800049d4:	01012903          	lw	s2,16(sp)
800049d8:	00c12983          	lw	s3,12(sp)
800049dc:	00812a03          	lw	s4,8(sp)
800049e0:	02010113          	addi	sp,sp,32
800049e4:	00008067          	ret

800049e8 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800049e8:	00d54783          	lbu	a5,13(a0)
800049ec:	01f7f793          	andi	a5,a5,31
800049f0:	00079863          	bnez	a5,80004a00 <z_is_thread_ready+0x18>
800049f4:	01852503          	lw	a0,24(a0)
800049f8:	00153513          	seqz	a0,a0
800049fc:	00008067          	ret
80004a00:	00000513          	li	a0,0
}
80004a04:	00008067          	ret

80004a08 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80004a08:	800077b7          	lui	a5,0x80007
80004a0c:	9847a503          	lw	a0,-1660(a5) # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
}
80004a10:	00a03533          	snez	a0,a0
80004a14:	00008067          	ret

80004a18 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80004a18:	800077b7          	lui	a5,0x80007
80004a1c:	98c7a783          	lw	a5,-1652(a5) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
80004a20:	00c7c503          	lbu	a0,12(a5)
}
80004a24:	00157513          	andi	a0,a0,1
80004a28:	00008067          	ret

80004a2c <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004a2c:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004a30:	02012303          	lw	t1,32(sp)
{
80004a34:	00812c23          	sw	s0,24(sp)
80004a38:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004a3c:	00612023          	sw	t1,0(sp)
{
80004a40:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004a44:	cfcfc0ef          	jal	ra,80000f40 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004a48:	800077b7          	lui	a5,0x80007
80004a4c:	98c7a783          	lw	a5,-1652(a5) # 8000698c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000698d>
	sys_trace_thread_create(new_thread);
}
80004a50:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004a54:	0687a783          	lw	a5,104(a5)
80004a58:	06f42423          	sw	a5,104(s0)
}
80004a5c:	01812403          	lw	s0,24(sp)
80004a60:	02010113          	addi	sp,sp,32
80004a64:	00008067          	ret

80004a68 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004a68:	06052783          	lw	a5,96(a0)
{
80004a6c:	ff010113          	addi	sp,sp,-16
80004a70:	00812423          	sw	s0,8(sp)
80004a74:	00112623          	sw	ra,12(sp)
80004a78:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004a7c:	00078463          	beqz	a5,80004a84 <z_thread_single_abort+0x1c>
		thread->fn_abort();
80004a80:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80004a84:	00040513          	mv	a0,s0
80004a88:	f61ff0ef          	jal	ra,800049e8 <z_is_thread_ready>
80004a8c:	02050463          	beqz	a0,80004ab4 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80004a90:	00040513          	mv	a0,s0
80004a94:	ca8ff0ef          	jal	ra,80003f3c <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80004a98:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004a9c:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004aa0:	0087e793          	ori	a5,a5,8
80004aa4:	00f406a3          	sb	a5,13(s0)
}
80004aa8:	00812403          	lw	s0,8(sp)
80004aac:	01010113          	addi	sp,sp,16
80004ab0:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004ab4:	00d44783          	lbu	a5,13(s0)
80004ab8:	0027f793          	andi	a5,a5,2
80004abc:	00078663          	beqz	a5,80004ac8 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80004ac0:	00040513          	mv	a0,s0
80004ac4:	829fe0ef          	jal	ra,800032ec <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80004ac8:	01842783          	lw	a5,24(s0)
80004acc:	fc0786e3          	beqz	a5,80004a98 <z_thread_single_abort+0x30>
80004ad0:	01840513          	addi	a0,s0,24
80004ad4:	798000ef          	jal	ra,8000526c <z_abort_timeout>
80004ad8:	fc1ff06f          	j	80004a98 <z_thread_single_abort+0x30>

80004adc <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80004adc:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80004ae0:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004ae4:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004ae8:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004aec:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80004af0:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004af4:	00008067          	ret

80004af8 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004af8:	00052503          	lw	a0,0(a0)
80004afc:	00050e63          	beqz	a0,80004b18 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80004b00:	800077b7          	lui	a5,0x80007
80004b04:	9987c783          	lbu	a5,-1640(a5) # 80006998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006999>
80004b08:	00357513          	andi	a0,a0,3
80004b0c:	40f50533          	sub	a0,a0,a5
80004b10:	00a03533          	snez	a0,a0
80004b14:	00008067          	ret
			return false;
		}
	}
	return true;
80004b18:	00100513          	li	a0,1
}
80004b1c:	00008067          	ret

80004b20 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80004b20:	800077b7          	lui	a5,0x80007
80004b24:	98478793          	addi	a5,a5,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80004b28:	0147c703          	lbu	a4,20(a5)
80004b2c:	0087a783          	lw	a5,8(a5)
80004b30:	00e7e7b3          	or	a5,a5,a4
80004b34:	00052703          	lw	a4,0(a0)
80004b38:	00f71863          	bne	a4,a5,80004b48 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004b3c:	00052023          	sw	zero,0(a0)
	return true;
80004b40:	00100513          	li	a0,1
80004b44:	00008067          	ret
		return false;
80004b48:	00000513          	li	a0,0
}
80004b4c:	00008067          	ret

80004b50 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004b50:	800077b7          	lui	a5,0x80007
80004b54:	98478793          	addi	a5,a5,-1660 # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
80004b58:	0147c703          	lbu	a4,20(a5)
80004b5c:	0087a783          	lw	a5,8(a5)
80004b60:	00e7e7b3          	or	a5,a5,a4
80004b64:	00f52023          	sw	a5,0(a0)
}
80004b68:	00008067          	ret

80004b6c <z_impl_k_thread_start>:
{
80004b6c:	fe010113          	addi	sp,sp,-32
80004b70:	00812c23          	sw	s0,24(sp)
80004b74:	01212823          	sw	s2,16(sp)
80004b78:	00112e23          	sw	ra,28(sp)
80004b7c:	00912a23          	sw	s1,20(sp)
80004b80:	01312623          	sw	s3,12(sp)
80004b84:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b88:	00800413          	li	s0,8
80004b8c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b90:	800064b7          	lui	s1,0x80006
80004b94:	6d048513          	addi	a0,s1,1744 # 800066d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004b98:	00847413          	andi	s0,s0,8
80004b9c:	f5dff0ef          	jal	ra,80004af8 <z_spin_lock_valid>
80004ba0:	02051e63          	bnez	a0,80004bdc <z_impl_k_thread_start+0x70>
80004ba4:	800069b7          	lui	s3,0x80006
80004ba8:	800065b7          	lui	a1,0x80006
80004bac:	80006537          	lui	a0,0x80006
80004bb0:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80004bb4:	04e00693          	li	a3,78
80004bb8:	04098613          	addi	a2,s3,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80004bbc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004bc0:	818fd0ef          	jal	ra,80001bd8 <printk>
80004bc4:	80006537          	lui	a0,0x80006
80004bc8:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80004bcc:	80cfd0ef          	jal	ra,80001bd8 <printk>
80004bd0:	04e00593          	li	a1,78
80004bd4:	04098513          	addi	a0,s3,64
80004bd8:	83cfd0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80004bdc:	6d048513          	addi	a0,s1,1744
80004be0:	f71ff0ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004be4:	00d94783          	lbu	a5,13(s2)
80004be8:	0047f713          	andi	a4,a5,4
80004bec:	06071463          	bnez	a4,80004c54 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004bf0:	6d048513          	addi	a0,s1,1744
80004bf4:	f2dff0ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80004bf8:	02051e63          	bnez	a0,80004c34 <z_impl_k_thread_start+0xc8>
80004bfc:	800064b7          	lui	s1,0x80006
80004c00:	800065b7          	lui	a1,0x80006
80004c04:	80006537          	lui	a0,0x80006
80004c08:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80004c0c:	06100693          	li	a3,97
80004c10:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80004c14:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004c18:	fc1fc0ef          	jal	ra,80001bd8 <printk>
80004c1c:	80006537          	lui	a0,0x80006
80004c20:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80004c24:	fb5fc0ef          	jal	ra,80001bd8 <printk>
80004c28:	06100593          	li	a1,97
80004c2c:	04048513          	addi	a0,s1,64
80004c30:	fe5fc0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004c34:	30042473          	csrrs	s0,mstatus,s0
}
80004c38:	01c12083          	lw	ra,28(sp)
80004c3c:	01812403          	lw	s0,24(sp)
80004c40:	01412483          	lw	s1,20(sp)
80004c44:	01012903          	lw	s2,16(sp)
80004c48:	00c12983          	lw	s3,12(sp)
80004c4c:	02010113          	addi	sp,sp,32
80004c50:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004c54:	ffb7f793          	andi	a5,a5,-5
80004c58:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004c5c:	00090513          	mv	a0,s2
80004c60:	d89ff0ef          	jal	ra,800049e8 <z_is_thread_ready>
80004c64:	00050663          	beqz	a0,80004c70 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004c68:	00090513          	mv	a0,s2
80004c6c:	dc9fe0ef          	jal	ra,80003a34 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80004c70:	00040593          	mv	a1,s0
}
80004c74:	01812403          	lw	s0,24(sp)
80004c78:	01c12083          	lw	ra,28(sp)
80004c7c:	01012903          	lw	s2,16(sp)
80004c80:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004c84:	6d048513          	addi	a0,s1,1744
}
80004c88:	01412483          	lw	s1,20(sp)
80004c8c:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004c90:	f58fe06f          	j	800033e8 <z_reschedule>

80004c94 <schedule_new_thread>:
	if (delay == 0) {
80004c94:	00059463          	bnez	a1,80004c9c <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004c98:	ed5ff06f          	j	80004b6c <z_impl_k_thread_start>
{
80004c9c:	ff010113          	addi	sp,sp,-16
80004ca0:	00812423          	sw	s0,8(sp)
80004ca4:	00050413          	mv	s0,a0
80004ca8:	00058513          	mv	a0,a1
80004cac:	00950513          	addi	a0,a0,9
80004cb0:	00a00593          	li	a1,10
80004cb4:	00112623          	sw	ra,12(sp)
80004cb8:	bf1fb0ef          	jal	ra,800008a8 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004cbc:	00150613          	addi	a2,a0,1
80004cc0:	01840513          	addi	a0,s0,24
}
80004cc4:	00812403          	lw	s0,8(sp)
80004cc8:	00c12083          	lw	ra,12(sp)
80004ccc:	800045b7          	lui	a1,0x80004
80004cd0:	bc458593          	addi	a1,a1,-1084 # 80003bc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003bc5>
80004cd4:	01010113          	addi	sp,sp,16
80004cd8:	3680006f          	j	80005040 <z_add_timeout>

80004cdc <z_impl_k_thread_create>:
{
80004cdc:	fc010113          	addi	sp,sp,-64
80004ce0:	03512223          	sw	s5,36(sp)
80004ce4:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004ce8:	800076b7          	lui	a3,0x80007
80004cec:	9846a683          	lw	a3,-1660(a3) # 80006984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006985>
{
80004cf0:	02812c23          	sw	s0,56(sp)
80004cf4:	02912a23          	sw	s1,52(sp)
80004cf8:	03312623          	sw	s3,44(sp)
80004cfc:	03412423          	sw	s4,40(sp)
80004d00:	02112e23          	sw	ra,60(sp)
80004d04:	03212823          	sw	s2,48(sp)
80004d08:	00050413          	mv	s0,a0
80004d0c:	00058993          	mv	s3,a1
80004d10:	00060a13          	mv	s4,a2
80004d14:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004d18:	04068e63          	beqz	a3,80004d74 <z_impl_k_thread_create+0x98>
80004d1c:	80006937          	lui	s2,0x80006
80004d20:	800065b7          	lui	a1,0x80006
80004d24:	80006537          	lui	a0,0x80006
80004d28:	1b200693          	li	a3,434
80004d2c:	4a490613          	addi	a2,s2,1188 # 800064a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064a5>
80004d30:	29058593          	addi	a1,a1,656 # 80006290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006291>
80004d34:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004d38:	01112e23          	sw	a7,28(sp)
80004d3c:	01012c23          	sw	a6,24(sp)
80004d40:	00f12a23          	sw	a5,20(sp)
80004d44:	00e12823          	sw	a4,16(sp)
80004d48:	e91fc0ef          	jal	ra,80001bd8 <printk>
80004d4c:	80006537          	lui	a0,0x80006
80004d50:	4b850513          	addi	a0,a0,1208 # 800064b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064b9>
80004d54:	e85fc0ef          	jal	ra,80001bd8 <printk>
80004d58:	1b200593          	li	a1,434
80004d5c:	4a490513          	addi	a0,s2,1188
80004d60:	eb5fc0ef          	jal	ra,80001c14 <assert_post_action>
80004d64:	01c12883          	lw	a7,28(sp)
80004d68:	01812803          	lw	a6,24(sp)
80004d6c:	01412783          	lw	a5,20(sp)
80004d70:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004d74:	04012683          	lw	a3,64(sp)
80004d78:	00012223          	sw	zero,4(sp)
80004d7c:	000a0613          	mv	a2,s4
80004d80:	00d12023          	sw	a3,0(sp)
80004d84:	00098593          	mv	a1,s3
80004d88:	000a8693          	mv	a3,s5
80004d8c:	00040513          	mv	a0,s0
80004d90:	c9dff0ef          	jal	ra,80004a2c <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004d94:	fff00793          	li	a5,-1
80004d98:	00f48863          	beq	s1,a5,80004da8 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80004d9c:	00048593          	mv	a1,s1
80004da0:	00040513          	mv	a0,s0
80004da4:	ef1ff0ef          	jal	ra,80004c94 <schedule_new_thread>
}
80004da8:	00040513          	mv	a0,s0
80004dac:	03c12083          	lw	ra,60(sp)
80004db0:	03812403          	lw	s0,56(sp)
80004db4:	03412483          	lw	s1,52(sp)
80004db8:	03012903          	lw	s2,48(sp)
80004dbc:	02c12983          	lw	s3,44(sp)
80004dc0:	02812a03          	lw	s4,40(sp)
80004dc4:	02412a83          	lw	s5,36(sp)
80004dc8:	04010113          	addi	sp,sp,64
80004dcc:	00008067          	ret

80004dd0 <z_init_static_threads>:
{
80004dd0:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004dd4:	800067b7          	lui	a5,0x80006
{
80004dd8:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004ddc:	80006937          	lui	s2,0x80006
{
80004de0:	00812c23          	sw	s0,24(sp)
80004de4:	00912a23          	sw	s1,20(sp)
80004de8:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004dec:	62078413          	addi	s0,a5,1568 # 80006620 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006621>
80004df0:	62078493          	addi	s1,a5,1568
80004df4:	62090913          	addi	s2,s2,1568 # 80006620 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006621>
80004df8:	03246663          	bltu	s0,s2,80004e24 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004dfc:	00048413          	mv	s0,s1
	k_sched_lock();
80004e00:	ee8fe0ef          	jal	ra,800034e8 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004e04:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004e08:	07246063          	bltu	s0,s2,80004e68 <z_init_static_threads+0x98>
}
80004e0c:	01812403          	lw	s0,24(sp)
80004e10:	01c12083          	lw	ra,28(sp)
80004e14:	01412483          	lw	s1,20(sp)
80004e18:	01012903          	lw	s2,16(sp)
80004e1c:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004e20:	a95fe06f          	j	800038b4 <k_sched_unlock>
		z_setup_new_thread(
80004e24:	02c42783          	lw	a5,44(s0)
80004e28:	00f12223          	sw	a5,4(sp)
80004e2c:	02042783          	lw	a5,32(s0)
80004e30:	00f12023          	sw	a5,0(sp)
80004e34:	01442783          	lw	a5,20(s0)
80004e38:	01c42883          	lw	a7,28(s0)
80004e3c:	01842803          	lw	a6,24(s0)
80004e40:	01042703          	lw	a4,16(s0)
80004e44:	00c42683          	lw	a3,12(s0)
80004e48:	00842603          	lw	a2,8(s0)
80004e4c:	00442583          	lw	a1,4(s0)
80004e50:	00042503          	lw	a0,0(s0)
80004e54:	bd9ff0ef          	jal	ra,80004a2c <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004e58:	00042783          	lw	a5,0(s0)
80004e5c:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004e60:	03040413          	addi	s0,s0,48
80004e64:	f95ff06f          	j	80004df8 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004e68:	02442583          	lw	a1,36(s0)
80004e6c:	00958663          	beq	a1,s1,80004e78 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80004e70:	00042503          	lw	a0,0(s0)
80004e74:	e21ff0ef          	jal	ra,80004c94 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004e78:	03040413          	addi	s0,s0,48
80004e7c:	f8dff06f          	j	80004e08 <z_init_static_threads+0x38>

80004e80 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004e80:	fe010113          	addi	sp,sp,-32
80004e84:	00812c23          	sw	s0,24(sp)
80004e88:	00912a23          	sw	s1,20(sp)
80004e8c:	00112e23          	sw	ra,28(sp)
80004e90:	01212823          	sw	s2,16(sp)
80004e94:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004e98:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e9c:	00800413          	li	s0,8
80004ea0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ea4:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004ea8:	00847413          	andi	s0,s0,8
80004eac:	c4dff0ef          	jal	ra,80004af8 <z_spin_lock_valid>
80004eb0:	02051e63          	bnez	a0,80004eec <z_impl_k_thread_abort+0x6c>
80004eb4:	80006937          	lui	s2,0x80006
80004eb8:	800065b7          	lui	a1,0x80006
80004ebc:	80006537          	lui	a0,0x80006
80004ec0:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80004ec4:	04e00693          	li	a3,78
80004ec8:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80004ecc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004ed0:	d09fc0ef          	jal	ra,80001bd8 <printk>
80004ed4:	80006537          	lui	a0,0x80006
80004ed8:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80004edc:	cfdfc0ef          	jal	ra,80001bd8 <printk>
80004ee0:	04e00593          	li	a1,78
80004ee4:	04090513          	addi	a0,s2,64
80004ee8:	d2dfc0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80004eec:	00c10513          	addi	a0,sp,12
80004ef0:	c61ff0ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004ef4:	00c4c783          	lbu	a5,12(s1)
80004ef8:	0017f793          	andi	a5,a5,1
80004efc:	02078e63          	beqz	a5,80004f38 <z_impl_k_thread_abort+0xb8>
80004f00:	80006937          	lui	s2,0x80006
80004f04:	800065b7          	lui	a1,0x80006
80004f08:	80006537          	lui	a0,0x80006
80004f0c:	4f858593          	addi	a1,a1,1272 # 800064f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f9>
80004f10:	02900693          	li	a3,41
80004f14:	4e090613          	addi	a2,s2,1248 # 800064e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064e1>
80004f18:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80004f1c:	cbdfc0ef          	jal	ra,80001bd8 <printk>
80004f20:	80006537          	lui	a0,0x80006
80004f24:	52c50513          	addi	a0,a0,1324 # 8000652c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000652d>
80004f28:	cb1fc0ef          	jal	ra,80001bd8 <printk>
80004f2c:	02900593          	li	a1,41
80004f30:	4e090513          	addi	a0,s2,1248
80004f34:	ce1fc0ef          	jal	ra,80001c14 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004f38:	00048513          	mv	a0,s1
80004f3c:	b2dff0ef          	jal	ra,80004a68 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004f40:	00040593          	mv	a1,s0
80004f44:	00c10513          	addi	a0,sp,12
80004f48:	ca0fe0ef          	jal	ra,800033e8 <z_reschedule>
}
80004f4c:	01c12083          	lw	ra,28(sp)
80004f50:	01812403          	lw	s0,24(sp)
80004f54:	01412483          	lw	s1,20(sp)
80004f58:	01012903          	lw	s2,16(sp)
80004f5c:	02010113          	addi	sp,sp,32
80004f60:	00008067          	ret

80004f64 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004f64:	800067b7          	lui	a5,0x80006
80004f68:	6d47a783          	lw	a5,1748(a5) # 800066d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d5>
80004f6c:	00079463          	bnez	a5,80004f74 <elapsed+0x10>
80004f70:	924fd06f          	j	80002094 <z_clock_elapsed>
}
80004f74:	00000513          	li	a0,0
80004f78:	00008067          	ret

80004f7c <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004f7c:	00052783          	lw	a5,0(a0)
80004f80:	02050263          	beqz	a0,80004fa4 <remove_timeout+0x28>
80004f84:	80006737          	lui	a4,0x80006
	return (node == list->tail) ? NULL : node->next;
80004f88:	5d872703          	lw	a4,1496(a4) # 800065d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d9>
80004f8c:	00e50c63          	beq	a0,a4,80004fa4 <remove_timeout+0x28>
	if (next(t) != NULL) {
80004f90:	00078a63          	beqz	a5,80004fa4 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80004f94:	0087a703          	lw	a4,8(a5)
80004f98:	00852683          	lw	a3,8(a0)
80004f9c:	00d70733          	add	a4,a4,a3
80004fa0:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80004fa4:	00452703          	lw	a4,4(a0)
80004fa8:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004fac:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80004fb0:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004fb4:	00052223          	sw	zero,4(a0)
}
80004fb8:	00008067          	ret

80004fbc <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004fbc:	800067b7          	lui	a5,0x80006
80004fc0:	6dc7c783          	lbu	a5,1756(a5) # 800066dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066dd>
{
80004fc4:	ff010113          	addi	sp,sp,-16
80004fc8:	00112623          	sw	ra,12(sp)
80004fcc:	00812423          	sw	s0,8(sp)
80004fd0:	00912223          	sw	s1,4(sp)
80004fd4:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004fd8:	00079663          	bnez	a5,80004fe4 <next_timeout+0x28>
80004fdc:	80000537          	lui	a0,0x80000
80004fe0:	fff54513          	not	a0,a0
	return list->head == list;
80004fe4:	800067b7          	lui	a5,0x80006
80004fe8:	5d478793          	addi	a5,a5,1492 # 800065d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d5>
80004fec:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004ff0:	02f40463          	beq	s0,a5,80005018 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004ff4:	02040263          	beqz	s0,80005018 <next_timeout+0x5c>
80004ff8:	00842483          	lw	s1,8(s0)
80004ffc:	f69ff0ef          	jal	ra,80004f64 <elapsed>
80005000:	40a484b3          	sub	s1,s1,a0
80005004:	00000513          	li	a0,0
80005008:	0004c863          	bltz	s1,80005018 <next_timeout+0x5c>
8000500c:	00842403          	lw	s0,8(s0)
80005010:	f55ff0ef          	jal	ra,80004f64 <elapsed>
80005014:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80005018:	800077b7          	lui	a5,0x80007
8000501c:	9947a783          	lw	a5,-1644(a5) # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
80005020:	00078663          	beqz	a5,8000502c <next_timeout+0x70>
80005024:	00a7d463          	bge	a5,a0,8000502c <next_timeout+0x70>
80005028:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
8000502c:	00c12083          	lw	ra,12(sp)
80005030:	00812403          	lw	s0,8(sp)
80005034:	00412483          	lw	s1,4(sp)
80005038:	01010113          	addi	sp,sp,16
8000503c:	00008067          	ret

80005040 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005040:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80005044:	fd010113          	addi	sp,sp,-48
80005048:	02812423          	sw	s0,40(sp)
8000504c:	02912223          	sw	s1,36(sp)
80005050:	01312e23          	sw	s3,28(sp)
80005054:	02112623          	sw	ra,44(sp)
80005058:	03212023          	sw	s2,32(sp)
8000505c:	01412c23          	sw	s4,24(sp)
80005060:	01512a23          	sw	s5,20(sp)
80005064:	01612823          	sw	s6,16(sp)
80005068:	01712623          	sw	s7,12(sp)
8000506c:	01812423          	sw	s8,8(sp)
80005070:	00050413          	mv	s0,a0
80005074:	00058993          	mv	s3,a1
80005078:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
8000507c:	02078e63          	beqz	a5,800050b8 <z_add_timeout+0x78>
80005080:	80006937          	lui	s2,0x80006
80005084:	800065b7          	lui	a1,0x80006
80005088:	80006537          	lui	a0,0x80006
8000508c:	55c58593          	addi	a1,a1,1372 # 8000655c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000655d>
80005090:	04d00693          	li	a3,77
80005094:	54890613          	addi	a2,s2,1352 # 80006548 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006549>
80005098:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000509c:	b3dfc0ef          	jal	ra,80001bd8 <printk>
800050a0:	80006537          	lui	a0,0x80006
800050a4:	ff850513          	addi	a0,a0,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
800050a8:	b31fc0ef          	jal	ra,80001bd8 <printk>
800050ac:	04d00593          	li	a1,77
800050b0:	54890513          	addi	a0,s2,1352
800050b4:	b61fc0ef          	jal	ra,80001c14 <assert_post_action>
	to->fn = fn;
800050b8:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
800050bc:	00904463          	bgtz	s1,800050c4 <z_add_timeout+0x84>
800050c0:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800050c4:	00800993          	li	s3,8
800050c8:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800050cc:	80006a37          	lui	s4,0x80006
800050d0:	6d8a0513          	addi	a0,s4,1752 # 800066d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d9>
	key = (mstatus & SOC_MSTATUS_IEN);
800050d4:	0089f993          	andi	s3,s3,8
800050d8:	a21ff0ef          	jal	ra,80004af8 <z_spin_lock_valid>
800050dc:	02051e63          	bnez	a0,80005118 <z_add_timeout+0xd8>
800050e0:	80006937          	lui	s2,0x80006
800050e4:	800065b7          	lui	a1,0x80006
800050e8:	80006537          	lui	a0,0x80006
800050ec:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800050f0:	04e00693          	li	a3,78
800050f4:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800050f8:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800050fc:	addfc0ef          	jal	ra,80001bd8 <printk>
80005100:	80006537          	lui	a0,0x80006
80005104:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80005108:	ad1fc0ef          	jal	ra,80001bd8 <printk>
8000510c:	04e00593          	li	a1,78
80005110:	04090513          	addi	a0,s2,64
80005114:	b01fc0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80005118:	6d8a0513          	addi	a0,s4,1752
8000511c:	a35ff0ef          	jal	ra,80004b50 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80005120:	e45ff0ef          	jal	ra,80004f64 <elapsed>
80005124:	00950533          	add	a0,a0,s1
	return list->head == list;
80005128:	800064b7          	lui	s1,0x80006
8000512c:	5d44a903          	lw	s2,1492(s1) # 800065d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d5>
80005130:	00a42423          	sw	a0,8(s0)
80005134:	5d448493          	addi	s1,s1,1492
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005138:	00990c63          	beq	s2,s1,80005150 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
8000513c:	80006ab7          	lui	s5,0x80006
80005140:	80006b37          	lui	s6,0x80006
80005144:	80006bb7          	lui	s7,0x80006
80005148:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
8000514c:	02091063          	bnez	s2,8000516c <z_add_timeout+0x12c>
	node->prev = list->tail;
80005150:	0044a783          	lw	a5,4(s1)
	node->next = list;
80005154:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80005158:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
8000515c:	0044a783          	lw	a5,4(s1)
80005160:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80005164:	0084a223          	sw	s0,4(s1)
80005168:	05c0006f          	j	800051c4 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
8000516c:	00892783          	lw	a5,8(s2)
80005170:	0207d663          	bgez	a5,8000519c <z_add_timeout+0x15c>
80005174:	57cb0593          	addi	a1,s6,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005178:	05600693          	li	a3,86
8000517c:	548a8613          	addi	a2,s5,1352 # 80006548 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006549>
80005180:	f74b8513          	addi	a0,s7,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80005184:	a55fc0ef          	jal	ra,80001bd8 <printk>
80005188:	ff8c0513          	addi	a0,s8,-8 # 80005ff8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff9>
8000518c:	a4dfc0ef          	jal	ra,80001bd8 <printk>
80005190:	05600593          	li	a1,86
80005194:	548a8513          	addi	a0,s5,1352
80005198:	a7dfc0ef          	jal	ra,80001c14 <assert_post_action>

			if (t->dticks > to->dticks) {
8000519c:	00892703          	lw	a4,8(s2)
800051a0:	00842783          	lw	a5,8(s0)
800051a4:	0ae7d863          	bge	a5,a4,80005254 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
800051a8:	40f707b3          	sub	a5,a4,a5
800051ac:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
800051b0:	00492783          	lw	a5,4(s2)
	node->next = successor;
800051b4:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
800051b8:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
800051bc:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
800051c0:	00892223          	sw	s0,4(s2)
	return list->head == list;
800051c4:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800051c8:	00978a63          	beq	a5,s1,800051dc <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
800051cc:	00f41863          	bne	s0,a5,800051dc <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
800051d0:	dedff0ef          	jal	ra,80004fbc <next_timeout>
800051d4:	00000593          	li	a1,0
800051d8:	d15fc0ef          	jal	ra,80001eec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800051dc:	6d8a0513          	addi	a0,s4,1752
800051e0:	941ff0ef          	jal	ra,80004b20 <z_spin_unlock_valid>
800051e4:	02051e63          	bnez	a0,80005220 <z_add_timeout+0x1e0>
800051e8:	80006437          	lui	s0,0x80006
800051ec:	800065b7          	lui	a1,0x80006
800051f0:	80006537          	lui	a0,0x80006
800051f4:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
800051f8:	06100693          	li	a3,97
800051fc:	04040613          	addi	a2,s0,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80005200:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80005204:	9d5fc0ef          	jal	ra,80001bd8 <printk>
80005208:	80006537          	lui	a0,0x80006
8000520c:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80005210:	9c9fc0ef          	jal	ra,80001bd8 <printk>
80005214:	06100593          	li	a1,97
80005218:	04040513          	addi	a0,s0,64
8000521c:	9f9fc0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005220:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80005224:	02c12083          	lw	ra,44(sp)
80005228:	02812403          	lw	s0,40(sp)
8000522c:	02412483          	lw	s1,36(sp)
80005230:	02012903          	lw	s2,32(sp)
80005234:	01c12983          	lw	s3,28(sp)
80005238:	01812a03          	lw	s4,24(sp)
8000523c:	01412a83          	lw	s5,20(sp)
80005240:	01012b03          	lw	s6,16(sp)
80005244:	00c12b83          	lw	s7,12(sp)
80005248:	00812c03          	lw	s8,8(sp)
8000524c:	03010113          	addi	sp,sp,48
80005250:	00008067          	ret
			to->dticks -= t->dticks;
80005254:	40e787b3          	sub	a5,a5,a4
80005258:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
8000525c:	0044a783          	lw	a5,4(s1)
80005260:	ef2788e3          	beq	a5,s2,80005150 <z_add_timeout+0x110>
80005264:	00092903          	lw	s2,0(s2)
80005268:	ee5ff06f          	j	8000514c <z_add_timeout+0x10c>

8000526c <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
8000526c:	fe010113          	addi	sp,sp,-32
80005270:	00812c23          	sw	s0,24(sp)
80005274:	01312623          	sw	s3,12(sp)
80005278:	00112e23          	sw	ra,28(sp)
8000527c:	00912a23          	sw	s1,20(sp)
80005280:	01212823          	sw	s2,16(sp)
80005284:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005288:	00800413          	li	s0,8
8000528c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005290:	800064b7          	lui	s1,0x80006
80005294:	6d848513          	addi	a0,s1,1752 # 800066d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005298:	00847413          	andi	s0,s0,8
8000529c:	85dff0ef          	jal	ra,80004af8 <z_spin_lock_valid>
800052a0:	02051e63          	bnez	a0,800052dc <z_abort_timeout+0x70>
800052a4:	80006937          	lui	s2,0x80006
800052a8:	800065b7          	lui	a1,0x80006
800052ac:	80006537          	lui	a0,0x80006
800052b0:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800052b4:	04e00693          	li	a3,78
800052b8:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800052bc:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800052c0:	919fc0ef          	jal	ra,80001bd8 <printk>
800052c4:	80006537          	lui	a0,0x80006
800052c8:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
800052cc:	90dfc0ef          	jal	ra,80001bd8 <printk>
800052d0:	04e00593          	li	a1,78
800052d4:	04090513          	addi	a0,s2,64
800052d8:	93dfc0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
800052dc:	6d848513          	addi	a0,s1,1752
800052e0:	871ff0ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
800052e4:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
800052e8:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
800052ec:	00078863          	beqz	a5,800052fc <z_abort_timeout+0x90>
			remove_timeout(to);
800052f0:	00098513          	mv	a0,s3
800052f4:	c89ff0ef          	jal	ra,80004f7c <remove_timeout>
			ret = 0;
800052f8:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800052fc:	6d848513          	addi	a0,s1,1752
80005300:	821ff0ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80005304:	02051e63          	bnez	a0,80005340 <z_abort_timeout+0xd4>
80005308:	800064b7          	lui	s1,0x80006
8000530c:	800065b7          	lui	a1,0x80006
80005310:	80006537          	lui	a0,0x80006
80005314:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80005318:	06100693          	li	a3,97
8000531c:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80005320:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80005324:	8b5fc0ef          	jal	ra,80001bd8 <printk>
80005328:	80006537          	lui	a0,0x80006
8000532c:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80005330:	8a9fc0ef          	jal	ra,80001bd8 <printk>
80005334:	06100593          	li	a1,97
80005338:	04048513          	addi	a0,s1,64
8000533c:	8d9fc0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005340:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80005344:	01c12083          	lw	ra,28(sp)
80005348:	01812403          	lw	s0,24(sp)
8000534c:	00090513          	mv	a0,s2
80005350:	01412483          	lw	s1,20(sp)
80005354:	01012903          	lw	s2,16(sp)
80005358:	00c12983          	lw	s3,12(sp)
8000535c:	02010113          	addi	sp,sp,32
80005360:	00008067          	ret

80005364 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80005364:	ff010113          	addi	sp,sp,-16
80005368:	00812423          	sw	s0,8(sp)
8000536c:	00112623          	sw	ra,12(sp)
80005370:	00912223          	sw	s1,4(sp)
80005374:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005378:	00800413          	li	s0,8
8000537c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005380:	800064b7          	lui	s1,0x80006
80005384:	6d848513          	addi	a0,s1,1752 # 800066d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005388:	00847413          	andi	s0,s0,8
8000538c:	f6cff0ef          	jal	ra,80004af8 <z_spin_lock_valid>
80005390:	02051e63          	bnez	a0,800053cc <z_get_next_timeout_expiry+0x68>
80005394:	80006937          	lui	s2,0x80006
80005398:	800065b7          	lui	a1,0x80006
8000539c:	80006537          	lui	a0,0x80006
800053a0:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800053a4:	04e00693          	li	a3,78
800053a8:	04090613          	addi	a2,s2,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800053ac:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800053b0:	829fc0ef          	jal	ra,80001bd8 <printk>
800053b4:	80006537          	lui	a0,0x80006
800053b8:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
800053bc:	81dfc0ef          	jal	ra,80001bd8 <printk>
800053c0:	04e00593          	li	a1,78
800053c4:	04090513          	addi	a0,s2,64
800053c8:	84dfc0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
800053cc:	6d848513          	addi	a0,s1,1752
800053d0:	f80ff0ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
800053d4:	be9ff0ef          	jal	ra,80004fbc <next_timeout>
800053d8:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800053dc:	6d848513          	addi	a0,s1,1752
800053e0:	f40ff0ef          	jal	ra,80004b20 <z_spin_unlock_valid>
800053e4:	02051e63          	bnez	a0,80005420 <z_get_next_timeout_expiry+0xbc>
800053e8:	800064b7          	lui	s1,0x80006
800053ec:	800065b7          	lui	a1,0x80006
800053f0:	80006537          	lui	a0,0x80006
800053f4:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
800053f8:	06100693          	li	a3,97
800053fc:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80005400:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80005404:	fd4fc0ef          	jal	ra,80001bd8 <printk>
80005408:	80006537          	lui	a0,0x80006
8000540c:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80005410:	fc8fc0ef          	jal	ra,80001bd8 <printk>
80005414:	06100593          	li	a1,97
80005418:	04048513          	addi	a0,s1,64
8000541c:	ff8fc0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005420:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80005424:	00c12083          	lw	ra,12(sp)
80005428:	00812403          	lw	s0,8(sp)
8000542c:	00090513          	mv	a0,s2
80005430:	00412483          	lw	s1,4(sp)
80005434:	00012903          	lw	s2,0(sp)
80005438:	01010113          	addi	sp,sp,16
8000543c:	00008067          	ret

80005440 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80005440:	fe010113          	addi	sp,sp,-32
80005444:	00812c23          	sw	s0,24(sp)
80005448:	01212823          	sw	s2,16(sp)
8000544c:	01412423          	sw	s4,8(sp)
80005450:	00112e23          	sw	ra,28(sp)
80005454:	00912a23          	sw	s1,20(sp)
80005458:	01312623          	sw	s3,12(sp)
8000545c:	00050913          	mv	s2,a0
80005460:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005464:	00800413          	li	s0,8
80005468:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000546c:	800064b7          	lui	s1,0x80006
80005470:	6d848513          	addi	a0,s1,1752 # 800066d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005474:	00847413          	andi	s0,s0,8
80005478:	e80ff0ef          	jal	ra,80004af8 <z_spin_lock_valid>
8000547c:	02051e63          	bnez	a0,800054b8 <z_set_timeout_expiry+0x78>
80005480:	800069b7          	lui	s3,0x80006
80005484:	800065b7          	lui	a1,0x80006
80005488:	80006537          	lui	a0,0x80006
8000548c:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80005490:	04e00693          	li	a3,78
80005494:	04098613          	addi	a2,s3,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80005498:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000549c:	f3cfc0ef          	jal	ra,80001bd8 <printk>
800054a0:	80006537          	lui	a0,0x80006
800054a4:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
800054a8:	f30fc0ef          	jal	ra,80001bd8 <printk>
800054ac:	04e00593          	li	a1,78
800054b0:	04098513          	addi	a0,s3,64
800054b4:	f60fc0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
800054b8:	6d848513          	addi	a0,s1,1752
800054bc:	e94ff0ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
800054c0:	afdff0ef          	jal	ra,80004fbc <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
800054c4:	00a95c63          	bge	s2,a0,800054dc <z_set_timeout_expiry+0x9c>
800054c8:	00100793          	li	a5,1
800054cc:	00a7d863          	bge	a5,a0,800054dc <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
800054d0:	000a0593          	mv	a1,s4
800054d4:	00090513          	mv	a0,s2
800054d8:	a15fc0ef          	jal	ra,80001eec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800054dc:	6d848513          	addi	a0,s1,1752
800054e0:	e40ff0ef          	jal	ra,80004b20 <z_spin_unlock_valid>
800054e4:	02051e63          	bnez	a0,80005520 <z_set_timeout_expiry+0xe0>
800054e8:	800064b7          	lui	s1,0x80006
800054ec:	800065b7          	lui	a1,0x80006
800054f0:	80006537          	lui	a0,0x80006
800054f4:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
800054f8:	06100693          	li	a3,97
800054fc:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80005500:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80005504:	ed4fc0ef          	jal	ra,80001bd8 <printk>
80005508:	80006537          	lui	a0,0x80006
8000550c:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80005510:	ec8fc0ef          	jal	ra,80001bd8 <printk>
80005514:	06100593          	li	a1,97
80005518:	04048513          	addi	a0,s1,64
8000551c:	ef8fc0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005520:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80005524:	01c12083          	lw	ra,28(sp)
80005528:	01812403          	lw	s0,24(sp)
8000552c:	01412483          	lw	s1,20(sp)
80005530:	01012903          	lw	s2,16(sp)
80005534:	00c12983          	lw	s3,12(sp)
80005538:	00812a03          	lw	s4,8(sp)
8000553c:	02010113          	addi	sp,sp,32
80005540:	00008067          	ret

80005544 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80005544:	fd010113          	addi	sp,sp,-48
80005548:	02812423          	sw	s0,40(sp)
8000554c:	01412c23          	sw	s4,24(sp)
80005550:	02112623          	sw	ra,44(sp)
80005554:	02912223          	sw	s1,36(sp)
80005558:	03212023          	sw	s2,32(sp)
8000555c:	01312e23          	sw	s3,28(sp)
80005560:	01512a23          	sw	s5,20(sp)
80005564:	01612823          	sw	s6,16(sp)
80005568:	01712623          	sw	s7,12(sp)
8000556c:	01812423          	sw	s8,8(sp)
80005570:	01912223          	sw	s9,4(sp)
80005574:	01a12023          	sw	s10,0(sp)
80005578:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000557c:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80005580:	945fe0ef          	jal	ra,80003ec4 <z_time_slice>
80005584:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005588:	80006937          	lui	s2,0x80006
8000558c:	6d890513          	addi	a0,s2,1752 # 800066d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005590:	00847413          	andi	s0,s0,8
80005594:	d64ff0ef          	jal	ra,80004af8 <z_spin_lock_valid>
80005598:	02051e63          	bnez	a0,800055d4 <z_clock_announce+0x90>
8000559c:	800064b7          	lui	s1,0x80006
800055a0:	800065b7          	lui	a1,0x80006
800055a4:	80006537          	lui	a0,0x80006
800055a8:	05858593          	addi	a1,a1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800055ac:	04e00693          	li	a3,78
800055b0:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
800055b4:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
800055b8:	e20fc0ef          	jal	ra,80001bd8 <printk>
800055bc:	80006537          	lui	a0,0x80006
800055c0:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
800055c4:	e14fc0ef          	jal	ra,80001bd8 <printk>
800055c8:	04e00593          	li	a1,78
800055cc:	04048513          	addi	a0,s1,64
800055d0:	e44fc0ef          	jal	ra,80001c14 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
800055d4:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
800055d8:	6d890513          	addi	a0,s2,1752
800055dc:	d74ff0ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
800055e0:	800064b7          	lui	s1,0x80006
800055e4:	6d49aa23          	sw	s4,1748(s3) # 800066d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d5>
	return list->head == list;
800055e8:	80006a37          	lui	s4,0x80006
800055ec:	6d498993          	addi	s3,s3,1748
800055f0:	5d4a0a13          	addi	s4,s4,1492 # 800065d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d5>
800055f4:	69048493          	addi	s1,s1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800055f8:	80006ab7          	lui	s5,0x80006
800055fc:	80006bb7          	lui	s7,0x80006
80005600:	80006b37          	lui	s6,0x80006
80005604:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005608:	80006cb7          	lui	s9,0x80006
8000560c:	000a2d03          	lw	s10,0(s4)
80005610:	0009a783          	lw	a5,0(s3)
80005614:	0004a683          	lw	a3,0(s1)
80005618:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000561c:	014d0c63          	beq	s10,s4,80005634 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80005620:	000d0a63          	beqz	s10,80005634 <z_clock_announce+0xf0>
80005624:	008d2703          	lw	a4,8(s10)
80005628:	0ae7dc63          	bge	a5,a4,800056e0 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
8000562c:	40f70733          	sub	a4,a4,a5
80005630:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80005634:	00d786b3          	add	a3,a5,a3
80005638:	41f7d713          	srai	a4,a5,0x1f
8000563c:	00a70733          	add	a4,a4,a0
80005640:	00f6b7b3          	sltu	a5,a3,a5
80005644:	00e787b3          	add	a5,a5,a4
80005648:	00d4a023          	sw	a3,0(s1)
8000564c:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005650:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80005654:	969ff0ef          	jal	ra,80004fbc <next_timeout>
80005658:	00000593          	li	a1,0
8000565c:	891fc0ef          	jal	ra,80001eec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005660:	6d890513          	addi	a0,s2,1752
80005664:	cbcff0ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80005668:	02051e63          	bnez	a0,800056a4 <z_clock_announce+0x160>
8000566c:	800064b7          	lui	s1,0x80006
80005670:	800065b7          	lui	a1,0x80006
80005674:	80006537          	lui	a0,0x80006
80005678:	08858593          	addi	a1,a1,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
8000567c:	06100693          	li	a3,97
80005680:	04048613          	addi	a2,s1,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80005684:	f7450513          	addi	a0,a0,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
80005688:	d50fc0ef          	jal	ra,80001bd8 <printk>
8000568c:	80006537          	lui	a0,0x80006
80005690:	0a050513          	addi	a0,a0,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80005694:	d44fc0ef          	jal	ra,80001bd8 <printk>
80005698:	06100593          	li	a1,97
8000569c:	04048513          	addi	a0,s1,64
800056a0:	d74fc0ef          	jal	ra,80001c14 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800056a4:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800056a8:	02c12083          	lw	ra,44(sp)
800056ac:	02812403          	lw	s0,40(sp)
800056b0:	02412483          	lw	s1,36(sp)
800056b4:	02012903          	lw	s2,32(sp)
800056b8:	01c12983          	lw	s3,28(sp)
800056bc:	01812a03          	lw	s4,24(sp)
800056c0:	01412a83          	lw	s5,20(sp)
800056c4:	01012b03          	lw	s6,16(sp)
800056c8:	00c12b83          	lw	s7,12(sp)
800056cc:	00812c03          	lw	s8,8(sp)
800056d0:	00412c83          	lw	s9,4(sp)
800056d4:	00012d03          	lw	s10,0(sp)
800056d8:	03010113          	addi	sp,sp,48
800056dc:	00008067          	ret
		curr_tick += dt;
800056e0:	00d706b3          	add	a3,a4,a3
800056e4:	41f75593          	srai	a1,a4,0x1f
800056e8:	00a585b3          	add	a1,a1,a0
800056ec:	00e6b633          	sltu	a2,a3,a4
800056f0:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
800056f4:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
800056f8:	000d0513          	mv	a0,s10
		t->dticks = 0;
800056fc:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80005700:	00d4a023          	sw	a3,0(s1)
80005704:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
80005708:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
8000570c:	871ff0ef          	jal	ra,80004f7c <remove_timeout>
80005710:	6d890513          	addi	a0,s2,1752
80005714:	c0cff0ef          	jal	ra,80004b20 <z_spin_unlock_valid>
80005718:	02051663          	bnez	a0,80005744 <z_clock_announce+0x200>
8000571c:	088b8593          	addi	a1,s7,136 # 80006088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006089>
80005720:	06100693          	li	a3,97
80005724:	040a8613          	addi	a2,s5,64 # 80006040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006041>
80005728:	f74b0513          	addi	a0,s6,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
8000572c:	cacfc0ef          	jal	ra,80001bd8 <printk>
80005730:	0a0c0513          	addi	a0,s8,160 # 800060a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a1>
80005734:	ca4fc0ef          	jal	ra,80001bd8 <printk>
80005738:	06100593          	li	a1,97
8000573c:	040a8513          	addi	a0,s5,64
80005740:	cd4fc0ef          	jal	ra,80001c14 <assert_post_action>
80005744:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80005748:	00cd2783          	lw	a5,12(s10)
8000574c:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005750:	00800413          	li	s0,8
80005754:	000780e7          	jalr	a5
80005758:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000575c:	6d890513          	addi	a0,s2,1752
	key = (mstatus & SOC_MSTATUS_IEN);
80005760:	00847413          	andi	s0,s0,8
80005764:	b94ff0ef          	jal	ra,80004af8 <z_spin_lock_valid>
80005768:	02051863          	bnez	a0,80005798 <z_clock_announce+0x254>
8000576c:	058c8593          	addi	a1,s9,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80005770:	04e00693          	li	a3,78
80005774:	040a8613          	addi	a2,s5,64
80005778:	f74b0513          	addi	a0,s6,-140
8000577c:	c5cfc0ef          	jal	ra,80001bd8 <printk>
80005780:	80006537          	lui	a0,0x80006
80005784:	07050513          	addi	a0,a0,112 # 80006070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006071>
80005788:	c50fc0ef          	jal	ra,80001bd8 <printk>
8000578c:	04e00593          	li	a1,78
80005790:	040a8513          	addi	a0,s5,64
80005794:	c80fc0ef          	jal	ra,80001c14 <assert_post_action>
	z_spin_lock_set_owner(l);
80005798:	6d890513          	addi	a0,s2,1752
8000579c:	bb4ff0ef          	jal	ra,80004b50 <z_spin_lock_set_owner>
	return k;
800057a0:	e6dff06f          	j	8000560c <z_clock_announce+0xc8>

800057a4 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
800057a4:	00008067          	ret
