
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01428293          	addi	t0,t0,20 # 80000014 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	0e90006f          	j	800008f4 <__initialize>
	...

Disassembly of section exceptions:

80000014 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000014:	715d                	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000016:	c006                	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	c20e                	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001a:	c412                	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
8000001c:	c616                	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
8000001e:	c81a                	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000020:	ca1e                	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
80000022:	cc72                	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000024:	ce76                	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000026:	d07a                	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000028:	d27e                	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000002a:	d42a                	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
8000002c:	d62e                	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
8000002e:	d832                	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000030:	da36                	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
80000032:	dc3a                	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000034:	de3e                	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000036:	c0c2                	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000038:	c2c6                	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000003a:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000003e:	c496                	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000040:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000044:	c696                	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
80000046:	1ae000ef          	jal	ra,800001f4 <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
8000004a:	00000313          	li	t1,0
	bnez a0, is_interrupt
8000004e:	e905                	bnez	a0,8000007e <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000050:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
80000054:	800003b7          	lui	t2,0x80000
80000058:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
8000005c:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000060:	432d                	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
80000062:	00628a63          	beq	t0,t1,80000076 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000066:	00010513          	mv	a0,sp
	la ra, no_reschedule
8000006a:	00000097          	auipc	ra,0x0
8000006e:	11e08093          	addi	ra,ra,286 # 80000188 <no_reschedule>
	tail _Fault
80000072:	32b0006f          	j	80000b9c <_Fault>

80000076 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000076:	42a6                	lw	t0,72(sp)
	addi t0, t0, 4
80000078:	0291                	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000007a:	c496                	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
8000007c:	a041                	j	800000fc <reschedule>

8000007e <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
8000007e:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
80000082:	00005397          	auipc	t2,0x5
80000086:	0fa38393          	addi	t2,t2,250 # 8000517c <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
8000008a:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
8000008e:	1141                	addi	sp,sp,-16
	sw t0, 0x00(sp)
80000090:	c016                	sw	t0,0(sp)

80000092 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
80000092:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
80000096:	0e05                	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
80000098:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
8000009c:	00030863          	beqz	t1,800000ac <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000a0:	00000097          	auipc	ra,0x0
800000a4:	03808093          	addi	ra,ra,56 # 800000d8 <on_thread_stack>
	tail z_irq_do_offload
800000a8:	35b0006f          	j	80000c02 <z_irq_do_offload>

800000ac <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000ac:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000b0:	800002b7          	lui	t0,0x80000
800000b4:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000b8:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000bc:	128000ef          	jal	ra,800001e4 <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000c0:	00004297          	auipc	t0,0x4
800000c4:	01828293          	addi	t0,t0,24 # 800040d8 <_image_text_end>
	slli a0, a0, 3
800000c8:	050e                	slli	a0,a0,0x3
	add t0, t0, a0
800000ca:	92aa                	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
800000cc:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
800000d0:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
800000d4:	000300e7          	jalr	t1

800000d8 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
800000d8:	00005317          	auipc	t1,0x5
800000dc:	0a430313          	addi	t1,t1,164 # 8000517c <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
800000e0:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
800000e4:	13fd                	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
800000e6:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
800000ea:	4282                	lw	t0,0(sp)
	addi sp, t0, 0
800000ec:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
800000f0:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
800000f4:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
800000f8:	087e0863          	beq	t3,t2,80000188 <no_reschedule>

800000fc <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
800000fc:	00005297          	auipc	t0,0x5
80000100:	08028293          	addi	t0,t0,128 # 8000517c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000104:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000108:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000010c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000110:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000114:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000118:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000011c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000120:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000124:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000128:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000012c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000130:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000134:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000138:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000013c:	00005397          	auipc	t2,0x5
80000140:	be038393          	addi	t2,t2,-1056 # 80004d1c <_k_neg_eagain>
	lw t3, 0x00(t2)
80000144:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000148:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000014c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000150:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000154:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000158:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000015c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
80000160:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
80000164:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
80000168:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
8000016c:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
80000170:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
80000174:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
80000178:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
8000017c:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
80000180:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
80000184:	05832d83          	lw	s11,88(t1)

80000188 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000188:	42a6                	lw	t0,72(sp)
	csrw mepc, t0
8000018a:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
8000018e:	42b6                	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
80000190:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
80000194:	4082                	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
80000196:	4192                	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
80000198:	4222                	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
8000019a:	42b2                	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
8000019c:	4342                	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
8000019e:	43d2                	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001a0:	4e62                	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001a2:	4ef2                	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001a4:	5f02                	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001a6:	5f92                	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
800001a8:	5522                	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
800001aa:	55b2                	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
800001ac:	5642                	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
800001ae:	56d2                	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
800001b0:	5762                	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
800001b2:	57f2                	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
800001b4:	4806                	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
800001b6:	4896                	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
800001b8:	6161                	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
800001ba:	30200073          	mret
	...

800001c0 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
800001c0:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
800001c4:	00005297          	auipc	t0,0x5
800001c8:	fb828293          	addi	t0,t0,-72 # 8000517c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
800001cc:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
800001d0:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
800001d4:	8921                	andi	a0,a0,8
	csrrs t0, mstatus, a0
800001d6:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
800001da:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
800001de:	00008067          	ret
	...

800001e4 <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
800001e4:	4305                	li	t1,1
	sll t0, t1, a0
800001e6:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
800001ea:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
800001ee:	00008067          	ret
	...

800001f4 <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
800001f4:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
800001f8:	80000337          	lui	t1,0x80000
	and t0, t0, t1
800001fc:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000200:	00000513          	li	a0,0
	beqz t0, not_interrupt
80000204:	00028363          	beqz	t0,8000020a <not_interrupt>
	addi a0, a0, 1
80000208:	0505                	addi	a0,a0,1

8000020a <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
8000020a:	00008067          	ret

Disassembly of section text:

80000210 <__lshrdi3>:
80000210:	02060063          	beqz	a2,80000230 <__lshrdi3+0x20>
80000214:	02000793          	li	a5,32
80000218:	40c787b3          	sub	a5,a5,a2
8000021c:	00f04c63          	bgtz	a5,80000234 <__lshrdi3+0x24>
80000220:	fe060513          	addi	a0,a2,-32
80000224:	00000713          	li	a4,0
80000228:	00a5d533          	srl	a0,a1,a0
8000022c:	00070593          	mv	a1,a4
80000230:	00008067          	ret
80000234:	00c5d733          	srl	a4,a1,a2
80000238:	00c55533          	srl	a0,a0,a2
8000023c:	00f595b3          	sll	a1,a1,a5
80000240:	00b56533          	or	a0,a0,a1
80000244:	fe9ff06f          	j	8000022c <__lshrdi3+0x1c>

80000248 <__udivdi3>:
80000248:	fd010113          	addi	sp,sp,-48
8000024c:	02912223          	sw	s1,36(sp)
80000250:	01612823          	sw	s6,16(sp)
80000254:	02112623          	sw	ra,44(sp)
80000258:	02812423          	sw	s0,40(sp)
8000025c:	03212023          	sw	s2,32(sp)
80000260:	01312e23          	sw	s3,28(sp)
80000264:	01412c23          	sw	s4,24(sp)
80000268:	01512a23          	sw	s5,20(sp)
8000026c:	01712623          	sw	s7,12(sp)
80000270:	01812423          	sw	s8,8(sp)
80000274:	01912223          	sw	s9,4(sp)
80000278:	00050b13          	mv	s6,a0
8000027c:	00058493          	mv	s1,a1
80000280:	38069c63          	bnez	a3,80000618 <__udivdi3+0x3d0>
80000284:	00060413          	mv	s0,a2
80000288:	00050993          	mv	s3,a0
8000028c:	00004917          	auipc	s2,0x4
80000290:	fcc90913          	addi	s2,s2,-52 # 80004258 <__devconfig_end>
80000294:	12c5f863          	bgeu	a1,a2,800003c4 <__udivdi3+0x17c>
80000298:	000107b7          	lui	a5,0x10
8000029c:	00058a93          	mv	s5,a1
800002a0:	10f67863          	bgeu	a2,a5,800003b0 <__udivdi3+0x168>
800002a4:	0ff00693          	li	a3,255
800002a8:	00c6b6b3          	sltu	a3,a3,a2
800002ac:	00369693          	slli	a3,a3,0x3
800002b0:	00d657b3          	srl	a5,a2,a3
800002b4:	00f90933          	add	s2,s2,a5
800002b8:	00094703          	lbu	a4,0(s2)
800002bc:	00d706b3          	add	a3,a4,a3
800002c0:	02000713          	li	a4,32
800002c4:	40d70733          	sub	a4,a4,a3
800002c8:	00070c63          	beqz	a4,800002e0 <__udivdi3+0x98>
800002cc:	00e494b3          	sll	s1,s1,a4
800002d0:	00db56b3          	srl	a3,s6,a3
800002d4:	00e61433          	sll	s0,a2,a4
800002d8:	0096eab3          	or	s5,a3,s1
800002dc:	00eb19b3          	sll	s3,s6,a4
800002e0:	01045b13          	srli	s6,s0,0x10
800002e4:	000b0593          	mv	a1,s6
800002e8:	000a8513          	mv	a0,s5
800002ec:	5a4000ef          	jal	ra,80000890 <__umodsi3>
800002f0:	00050913          	mv	s2,a0
800002f4:	000b0593          	mv	a1,s6
800002f8:	01041b93          	slli	s7,s0,0x10
800002fc:	000a8513          	mv	a0,s5
80000300:	548000ef          	jal	ra,80000848 <__udivsi3>
80000304:	010bdb93          	srli	s7,s7,0x10
80000308:	00050493          	mv	s1,a0
8000030c:	00050593          	mv	a1,a0
80000310:	000b8513          	mv	a0,s7
80000314:	508000ef          	jal	ra,8000081c <__mulsi3>
80000318:	01091913          	slli	s2,s2,0x10
8000031c:	0109d713          	srli	a4,s3,0x10
80000320:	00e96733          	or	a4,s2,a4
80000324:	00048a13          	mv	s4,s1
80000328:	00a77e63          	bgeu	a4,a0,80000344 <__udivdi3+0xfc>
8000032c:	00870733          	add	a4,a4,s0
80000330:	fff48a13          	addi	s4,s1,-1
80000334:	00876863          	bltu	a4,s0,80000344 <__udivdi3+0xfc>
80000338:	00a77663          	bgeu	a4,a0,80000344 <__udivdi3+0xfc>
8000033c:	ffe48a13          	addi	s4,s1,-2
80000340:	00870733          	add	a4,a4,s0
80000344:	40a704b3          	sub	s1,a4,a0
80000348:	000b0593          	mv	a1,s6
8000034c:	00048513          	mv	a0,s1
80000350:	540000ef          	jal	ra,80000890 <__umodsi3>
80000354:	00050913          	mv	s2,a0
80000358:	000b0593          	mv	a1,s6
8000035c:	00048513          	mv	a0,s1
80000360:	4e8000ef          	jal	ra,80000848 <__udivsi3>
80000364:	01099993          	slli	s3,s3,0x10
80000368:	00050493          	mv	s1,a0
8000036c:	00050593          	mv	a1,a0
80000370:	01091913          	slli	s2,s2,0x10
80000374:	000b8513          	mv	a0,s7
80000378:	0109d993          	srli	s3,s3,0x10
8000037c:	4a0000ef          	jal	ra,8000081c <__mulsi3>
80000380:	013969b3          	or	s3,s2,s3
80000384:	00048613          	mv	a2,s1
80000388:	00a9fc63          	bgeu	s3,a0,800003a0 <__udivdi3+0x158>
8000038c:	013409b3          	add	s3,s0,s3
80000390:	fff48613          	addi	a2,s1,-1
80000394:	0089e663          	bltu	s3,s0,800003a0 <__udivdi3+0x158>
80000398:	00a9f463          	bgeu	s3,a0,800003a0 <__udivdi3+0x158>
8000039c:	ffe48613          	addi	a2,s1,-2
800003a0:	010a1793          	slli	a5,s4,0x10
800003a4:	00c7e7b3          	or	a5,a5,a2
800003a8:	00000a13          	li	s4,0
800003ac:	1300006f          	j	800004dc <__udivdi3+0x294>
800003b0:	010007b7          	lui	a5,0x1000
800003b4:	01000693          	li	a3,16
800003b8:	eef66ce3          	bltu	a2,a5,800002b0 <__udivdi3+0x68>
800003bc:	01800693          	li	a3,24
800003c0:	ef1ff06f          	j	800002b0 <__udivdi3+0x68>
800003c4:	00068a13          	mv	s4,a3
800003c8:	00061a63          	bnez	a2,800003dc <__udivdi3+0x194>
800003cc:	00000593          	li	a1,0
800003d0:	00100513          	li	a0,1
800003d4:	474000ef          	jal	ra,80000848 <__udivsi3>
800003d8:	00050413          	mv	s0,a0
800003dc:	000107b7          	lui	a5,0x10
800003e0:	12f47c63          	bgeu	s0,a5,80000518 <__udivdi3+0x2d0>
800003e4:	0ff00793          	li	a5,255
800003e8:	0087f463          	bgeu	a5,s0,800003f0 <__udivdi3+0x1a8>
800003ec:	00800a13          	li	s4,8
800003f0:	014457b3          	srl	a5,s0,s4
800003f4:	00f90933          	add	s2,s2,a5
800003f8:	00094683          	lbu	a3,0(s2)
800003fc:	02000613          	li	a2,32
80000400:	014686b3          	add	a3,a3,s4
80000404:	40d60633          	sub	a2,a2,a3
80000408:	12061263          	bnez	a2,8000052c <__udivdi3+0x2e4>
8000040c:	408484b3          	sub	s1,s1,s0
80000410:	00100a13          	li	s4,1
80000414:	01045b13          	srli	s6,s0,0x10
80000418:	000b0593          	mv	a1,s6
8000041c:	00048513          	mv	a0,s1
80000420:	470000ef          	jal	ra,80000890 <__umodsi3>
80000424:	00050913          	mv	s2,a0
80000428:	000b0593          	mv	a1,s6
8000042c:	00048513          	mv	a0,s1
80000430:	01041b93          	slli	s7,s0,0x10
80000434:	414000ef          	jal	ra,80000848 <__udivsi3>
80000438:	010bdb93          	srli	s7,s7,0x10
8000043c:	00050493          	mv	s1,a0
80000440:	00050593          	mv	a1,a0
80000444:	000b8513          	mv	a0,s7
80000448:	3d4000ef          	jal	ra,8000081c <__mulsi3>
8000044c:	01091913          	slli	s2,s2,0x10
80000450:	0109d713          	srli	a4,s3,0x10
80000454:	00e96733          	or	a4,s2,a4
80000458:	00048a93          	mv	s5,s1
8000045c:	00a77e63          	bgeu	a4,a0,80000478 <__udivdi3+0x230>
80000460:	00870733          	add	a4,a4,s0
80000464:	fff48a93          	addi	s5,s1,-1
80000468:	00876863          	bltu	a4,s0,80000478 <__udivdi3+0x230>
8000046c:	00a77663          	bgeu	a4,a0,80000478 <__udivdi3+0x230>
80000470:	ffe48a93          	addi	s5,s1,-2
80000474:	00870733          	add	a4,a4,s0
80000478:	40a704b3          	sub	s1,a4,a0
8000047c:	000b0593          	mv	a1,s6
80000480:	00048513          	mv	a0,s1
80000484:	40c000ef          	jal	ra,80000890 <__umodsi3>
80000488:	00050913          	mv	s2,a0
8000048c:	000b0593          	mv	a1,s6
80000490:	00048513          	mv	a0,s1
80000494:	3b4000ef          	jal	ra,80000848 <__udivsi3>
80000498:	01099993          	slli	s3,s3,0x10
8000049c:	00050493          	mv	s1,a0
800004a0:	00050593          	mv	a1,a0
800004a4:	01091913          	slli	s2,s2,0x10
800004a8:	000b8513          	mv	a0,s7
800004ac:	0109d993          	srli	s3,s3,0x10
800004b0:	36c000ef          	jal	ra,8000081c <__mulsi3>
800004b4:	013969b3          	or	s3,s2,s3
800004b8:	00048613          	mv	a2,s1
800004bc:	00a9fc63          	bgeu	s3,a0,800004d4 <__udivdi3+0x28c>
800004c0:	013409b3          	add	s3,s0,s3
800004c4:	fff48613          	addi	a2,s1,-1
800004c8:	0089e663          	bltu	s3,s0,800004d4 <__udivdi3+0x28c>
800004cc:	00a9f463          	bgeu	s3,a0,800004d4 <__udivdi3+0x28c>
800004d0:	ffe48613          	addi	a2,s1,-2
800004d4:	010a9793          	slli	a5,s5,0x10
800004d8:	00c7e7b3          	or	a5,a5,a2
800004dc:	00078513          	mv	a0,a5
800004e0:	000a0593          	mv	a1,s4
800004e4:	02c12083          	lw	ra,44(sp)
800004e8:	02812403          	lw	s0,40(sp)
800004ec:	02412483          	lw	s1,36(sp)
800004f0:	02012903          	lw	s2,32(sp)
800004f4:	01c12983          	lw	s3,28(sp)
800004f8:	01812a03          	lw	s4,24(sp)
800004fc:	01412a83          	lw	s5,20(sp)
80000500:	01012b03          	lw	s6,16(sp)
80000504:	00c12b83          	lw	s7,12(sp)
80000508:	00812c03          	lw	s8,8(sp)
8000050c:	00412c83          	lw	s9,4(sp)
80000510:	03010113          	addi	sp,sp,48
80000514:	00008067          	ret
80000518:	010007b7          	lui	a5,0x1000
8000051c:	01000a13          	li	s4,16
80000520:	ecf468e3          	bltu	s0,a5,800003f0 <__udivdi3+0x1a8>
80000524:	01800a13          	li	s4,24
80000528:	ec9ff06f          	j	800003f0 <__udivdi3+0x1a8>
8000052c:	00c41433          	sll	s0,s0,a2
80000530:	00d4da33          	srl	s4,s1,a3
80000534:	00cb19b3          	sll	s3,s6,a2
80000538:	00db56b3          	srl	a3,s6,a3
8000053c:	01045b13          	srli	s6,s0,0x10
80000540:	00c494b3          	sll	s1,s1,a2
80000544:	000b0593          	mv	a1,s6
80000548:	000a0513          	mv	a0,s4
8000054c:	0096eab3          	or	s5,a3,s1
80000550:	340000ef          	jal	ra,80000890 <__umodsi3>
80000554:	00050913          	mv	s2,a0
80000558:	000b0593          	mv	a1,s6
8000055c:	000a0513          	mv	a0,s4
80000560:	01041b93          	slli	s7,s0,0x10
80000564:	2e4000ef          	jal	ra,80000848 <__udivsi3>
80000568:	010bdb93          	srli	s7,s7,0x10
8000056c:	00050493          	mv	s1,a0
80000570:	00050593          	mv	a1,a0
80000574:	000b8513          	mv	a0,s7
80000578:	2a4000ef          	jal	ra,8000081c <__mulsi3>
8000057c:	01091913          	slli	s2,s2,0x10
80000580:	010ad713          	srli	a4,s5,0x10
80000584:	00e96733          	or	a4,s2,a4
80000588:	00048a13          	mv	s4,s1
8000058c:	00a77e63          	bgeu	a4,a0,800005a8 <__udivdi3+0x360>
80000590:	00870733          	add	a4,a4,s0
80000594:	fff48a13          	addi	s4,s1,-1
80000598:	00876863          	bltu	a4,s0,800005a8 <__udivdi3+0x360>
8000059c:	00a77663          	bgeu	a4,a0,800005a8 <__udivdi3+0x360>
800005a0:	ffe48a13          	addi	s4,s1,-2
800005a4:	00870733          	add	a4,a4,s0
800005a8:	40a704b3          	sub	s1,a4,a0
800005ac:	000b0593          	mv	a1,s6
800005b0:	00048513          	mv	a0,s1
800005b4:	2dc000ef          	jal	ra,80000890 <__umodsi3>
800005b8:	00050913          	mv	s2,a0
800005bc:	000b0593          	mv	a1,s6
800005c0:	00048513          	mv	a0,s1
800005c4:	284000ef          	jal	ra,80000848 <__udivsi3>
800005c8:	00050493          	mv	s1,a0
800005cc:	00050593          	mv	a1,a0
800005d0:	000b8513          	mv	a0,s7
800005d4:	248000ef          	jal	ra,8000081c <__mulsi3>
800005d8:	010a9693          	slli	a3,s5,0x10
800005dc:	01091913          	slli	s2,s2,0x10
800005e0:	0106d693          	srli	a3,a3,0x10
800005e4:	00d967b3          	or	a5,s2,a3
800005e8:	00048713          	mv	a4,s1
800005ec:	00a7fe63          	bgeu	a5,a0,80000608 <__udivdi3+0x3c0>
800005f0:	008787b3          	add	a5,a5,s0
800005f4:	fff48713          	addi	a4,s1,-1
800005f8:	0087e863          	bltu	a5,s0,80000608 <__udivdi3+0x3c0>
800005fc:	00a7f663          	bgeu	a5,a0,80000608 <__udivdi3+0x3c0>
80000600:	ffe48713          	addi	a4,s1,-2
80000604:	008787b3          	add	a5,a5,s0
80000608:	010a1a13          	slli	s4,s4,0x10
8000060c:	40a784b3          	sub	s1,a5,a0
80000610:	00ea6a33          	or	s4,s4,a4
80000614:	e01ff06f          	j	80000414 <__udivdi3+0x1cc>
80000618:	1ed5ec63          	bltu	a1,a3,80000810 <__udivdi3+0x5c8>
8000061c:	000107b7          	lui	a5,0x10
80000620:	04f6f463          	bgeu	a3,a5,80000668 <__udivdi3+0x420>
80000624:	0ff00593          	li	a1,255
80000628:	00d5b533          	sltu	a0,a1,a3
8000062c:	00351513          	slli	a0,a0,0x3
80000630:	00a6d733          	srl	a4,a3,a0
80000634:	00004797          	auipc	a5,0x4
80000638:	c2478793          	addi	a5,a5,-988 # 80004258 <__devconfig_end>
8000063c:	00e787b3          	add	a5,a5,a4
80000640:	0007c583          	lbu	a1,0(a5)
80000644:	02000a13          	li	s4,32
80000648:	00a585b3          	add	a1,a1,a0
8000064c:	40ba0a33          	sub	s4,s4,a1
80000650:	020a1663          	bnez	s4,8000067c <__udivdi3+0x434>
80000654:	00100793          	li	a5,1
80000658:	e896e2e3          	bltu	a3,s1,800004dc <__udivdi3+0x294>
8000065c:	00cb3633          	sltu	a2,s6,a2
80000660:	00164793          	xori	a5,a2,1
80000664:	e79ff06f          	j	800004dc <__udivdi3+0x294>
80000668:	010007b7          	lui	a5,0x1000
8000066c:	01000513          	li	a0,16
80000670:	fcf6e0e3          	bltu	a3,a5,80000630 <__udivdi3+0x3e8>
80000674:	01800513          	li	a0,24
80000678:	fb9ff06f          	j	80000630 <__udivdi3+0x3e8>
8000067c:	00b65ab3          	srl	s5,a2,a1
80000680:	014696b3          	sll	a3,a3,s4
80000684:	00daeab3          	or	s5,s5,a3
80000688:	00b4d933          	srl	s2,s1,a1
8000068c:	014497b3          	sll	a5,s1,s4
80000690:	00bb55b3          	srl	a1,s6,a1
80000694:	010adb93          	srli	s7,s5,0x10
80000698:	00f5e4b3          	or	s1,a1,a5
8000069c:	00090513          	mv	a0,s2
800006a0:	000b8593          	mv	a1,s7
800006a4:	014619b3          	sll	s3,a2,s4
800006a8:	1e8000ef          	jal	ra,80000890 <__umodsi3>
800006ac:	00050413          	mv	s0,a0
800006b0:	000b8593          	mv	a1,s7
800006b4:	00090513          	mv	a0,s2
800006b8:	010a9c13          	slli	s8,s5,0x10
800006bc:	18c000ef          	jal	ra,80000848 <__udivsi3>
800006c0:	010c5c13          	srli	s8,s8,0x10
800006c4:	00050913          	mv	s2,a0
800006c8:	00050593          	mv	a1,a0
800006cc:	000c0513          	mv	a0,s8
800006d0:	14c000ef          	jal	ra,8000081c <__mulsi3>
800006d4:	01041413          	slli	s0,s0,0x10
800006d8:	0104d713          	srli	a4,s1,0x10
800006dc:	00e46733          	or	a4,s0,a4
800006e0:	00090c93          	mv	s9,s2
800006e4:	00a77e63          	bgeu	a4,a0,80000700 <__udivdi3+0x4b8>
800006e8:	01570733          	add	a4,a4,s5
800006ec:	fff90c93          	addi	s9,s2,-1
800006f0:	01576863          	bltu	a4,s5,80000700 <__udivdi3+0x4b8>
800006f4:	00a77663          	bgeu	a4,a0,80000700 <__udivdi3+0x4b8>
800006f8:	ffe90c93          	addi	s9,s2,-2
800006fc:	01570733          	add	a4,a4,s5
80000700:	40a70933          	sub	s2,a4,a0
80000704:	000b8593          	mv	a1,s7
80000708:	00090513          	mv	a0,s2
8000070c:	184000ef          	jal	ra,80000890 <__umodsi3>
80000710:	00050413          	mv	s0,a0
80000714:	000b8593          	mv	a1,s7
80000718:	00090513          	mv	a0,s2
8000071c:	12c000ef          	jal	ra,80000848 <__udivsi3>
80000720:	00050913          	mv	s2,a0
80000724:	00050593          	mv	a1,a0
80000728:	000c0513          	mv	a0,s8
8000072c:	0f0000ef          	jal	ra,8000081c <__mulsi3>
80000730:	01049793          	slli	a5,s1,0x10
80000734:	01041413          	slli	s0,s0,0x10
80000738:	0107d793          	srli	a5,a5,0x10
8000073c:	00f46733          	or	a4,s0,a5
80000740:	00090613          	mv	a2,s2
80000744:	00a77e63          	bgeu	a4,a0,80000760 <__udivdi3+0x518>
80000748:	01570733          	add	a4,a4,s5
8000074c:	fff90613          	addi	a2,s2,-1
80000750:	01576863          	bltu	a4,s5,80000760 <__udivdi3+0x518>
80000754:	00a77663          	bgeu	a4,a0,80000760 <__udivdi3+0x518>
80000758:	ffe90613          	addi	a2,s2,-2
8000075c:	01570733          	add	a4,a4,s5
80000760:	010c9793          	slli	a5,s9,0x10
80000764:	00010e37          	lui	t3,0x10
80000768:	00c7e7b3          	or	a5,a5,a2
8000076c:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000770:	0107f333          	and	t1,a5,a6
80000774:	0109f833          	and	a6,s3,a6
80000778:	40a70733          	sub	a4,a4,a0
8000077c:	0107de93          	srli	t4,a5,0x10
80000780:	0109d993          	srli	s3,s3,0x10
80000784:	00030513          	mv	a0,t1
80000788:	00080593          	mv	a1,a6
8000078c:	090000ef          	jal	ra,8000081c <__mulsi3>
80000790:	00050893          	mv	a7,a0
80000794:	00098593          	mv	a1,s3
80000798:	00030513          	mv	a0,t1
8000079c:	080000ef          	jal	ra,8000081c <__mulsi3>
800007a0:	00050313          	mv	t1,a0
800007a4:	00080593          	mv	a1,a6
800007a8:	000e8513          	mv	a0,t4
800007ac:	070000ef          	jal	ra,8000081c <__mulsi3>
800007b0:	00050813          	mv	a6,a0
800007b4:	00098593          	mv	a1,s3
800007b8:	000e8513          	mv	a0,t4
800007bc:	060000ef          	jal	ra,8000081c <__mulsi3>
800007c0:	0108d693          	srli	a3,a7,0x10
800007c4:	01030333          	add	t1,t1,a6
800007c8:	006686b3          	add	a3,a3,t1
800007cc:	0106f463          	bgeu	a3,a6,800007d4 <__udivdi3+0x58c>
800007d0:	01c50533          	add	a0,a0,t3
800007d4:	0106d613          	srli	a2,a3,0x10
800007d8:	00a60533          	add	a0,a2,a0
800007dc:	02a76663          	bltu	a4,a0,80000808 <__udivdi3+0x5c0>
800007e0:	bca714e3          	bne	a4,a0,800003a8 <__udivdi3+0x160>
800007e4:	00010737          	lui	a4,0x10
800007e8:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007ec:	00e6f6b3          	and	a3,a3,a4
800007f0:	01069693          	slli	a3,a3,0x10
800007f4:	00e8f8b3          	and	a7,a7,a4
800007f8:	014b1633          	sll	a2,s6,s4
800007fc:	011686b3          	add	a3,a3,a7
80000800:	00000a13          	li	s4,0
80000804:	ccd67ce3          	bgeu	a2,a3,800004dc <__udivdi3+0x294>
80000808:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000080c:	b9dff06f          	j	800003a8 <__udivdi3+0x160>
80000810:	00000a13          	li	s4,0
80000814:	00000793          	li	a5,0
80000818:	cc5ff06f          	j	800004dc <__udivdi3+0x294>

8000081c <__mulsi3>:
8000081c:	00050613          	mv	a2,a0
80000820:	00000513          	li	a0,0
80000824:	0015f693          	andi	a3,a1,1
80000828:	00068463          	beqz	a3,80000830 <__mulsi3+0x14>
8000082c:	00c50533          	add	a0,a0,a2
80000830:	0015d593          	srli	a1,a1,0x1
80000834:	00161613          	slli	a2,a2,0x1
80000838:	fe0596e3          	bnez	a1,80000824 <__mulsi3+0x8>
8000083c:	00008067          	ret

80000840 <__divsi3>:
80000840:	06054063          	bltz	a0,800008a0 <__umodsi3+0x10>
80000844:	0605c663          	bltz	a1,800008b0 <__umodsi3+0x20>

80000848 <__udivsi3>:
80000848:	00058613          	mv	a2,a1
8000084c:	00050593          	mv	a1,a0
80000850:	fff00513          	li	a0,-1
80000854:	02060c63          	beqz	a2,8000088c <__udivsi3+0x44>
80000858:	00100693          	li	a3,1
8000085c:	00b67a63          	bgeu	a2,a1,80000870 <__udivsi3+0x28>
80000860:	00c05863          	blez	a2,80000870 <__udivsi3+0x28>
80000864:	00161613          	slli	a2,a2,0x1
80000868:	00169693          	slli	a3,a3,0x1
8000086c:	feb66ae3          	bltu	a2,a1,80000860 <__udivsi3+0x18>
80000870:	00000513          	li	a0,0
80000874:	00c5e663          	bltu	a1,a2,80000880 <__udivsi3+0x38>
80000878:	40c585b3          	sub	a1,a1,a2
8000087c:	00d56533          	or	a0,a0,a3
80000880:	0016d693          	srli	a3,a3,0x1
80000884:	00165613          	srli	a2,a2,0x1
80000888:	fe0696e3          	bnez	a3,80000874 <__udivsi3+0x2c>
8000088c:	00008067          	ret

80000890 <__umodsi3>:
80000890:	00008293          	mv	t0,ra
80000894:	fb5ff0ef          	jal	ra,80000848 <__udivsi3>
80000898:	00058513          	mv	a0,a1
8000089c:	00028067          	jr	t0
800008a0:	40a00533          	neg	a0,a0
800008a4:	0005d863          	bgez	a1,800008b4 <__umodsi3+0x24>
800008a8:	40b005b3          	neg	a1,a1
800008ac:	f9dff06f          	j	80000848 <__udivsi3>
800008b0:	40b005b3          	neg	a1,a1
800008b4:	00008293          	mv	t0,ra
800008b8:	f91ff0ef          	jal	ra,80000848 <__udivsi3>
800008bc:	40a00533          	neg	a0,a0
800008c0:	00028067          	jr	t0

800008c4 <__modsi3>:
800008c4:	00008293          	mv	t0,ra
800008c8:	0005ca63          	bltz	a1,800008dc <__modsi3+0x18>
800008cc:	00054c63          	bltz	a0,800008e4 <__modsi3+0x20>
800008d0:	f79ff0ef          	jal	ra,80000848 <__udivsi3>
800008d4:	00058513          	mv	a0,a1
800008d8:	00028067          	jr	t0
800008dc:	40b005b3          	neg	a1,a1
800008e0:	fe0558e3          	bgez	a0,800008d0 <__modsi3+0xc>
800008e4:	40a00533          	neg	a0,a0
800008e8:	f61ff0ef          	jal	ra,80000848 <__udivsi3>
800008ec:	40b00533          	neg	a0,a1
800008f0:	00028067          	jr	t0

800008f4 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
800008f4:	00006117          	auipc	sp,0x6
800008f8:	8bc10113          	addi	sp,sp,-1860 # 800061b0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
800008fc:	000012b7          	lui	t0,0x1
80000900:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000904:	9116                	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000906:	2e31                	jal	80000c22 <_PrepC>

80000908 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000908:	15f0006f          	j	80001266 <z_thread_entry>
	...

8000090e <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
8000090e:	8082                	ret

80000910 <test_mpool_threadsafe>:
 * Each thread allocates 4 blocks of size 4 bytes (all blocks
 * in memory pool) with timeout of 200 ms and frees up all the
 * blocks
 */
void test_mpool_threadsafe(void)
{
80000910:	7139                	addi	sp,sp,-64
80000912:	dc22                	sw	s0,56(sp)
80000914:	d64e                	sw	s3,44(sp)
80000916:	80005437          	lui	s0,0x80005

K_SYSCALL_DECLARE2(K_SYSCALL_K_MUTEX_LOCK, k_mutex_lock, int, struct k_mutex *, mutex, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
8000091a:	800059b7          	lui	s3,0x80005
8000091e:	da26                	sw	s1,52(sp)
80000920:	d84a                	sw	s2,48(sp)
80000922:	4611                	li	a2,4
80000924:	4581                	li	a1,0
80000926:	e4c98513          	addi	a0,s3,-436 # 80004e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e4d>
8000092a:	e5c40413          	addi	s0,s0,-420 # 80004e5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e5d>
8000092e:	80005937          	lui	s2,0x80005
80000932:	0804                	addi	s1,sp,16
80000934:	d452                	sw	s4,40(sp)
80000936:	d256                	sw	s5,36(sp)
80000938:	d05a                	sw	s6,32(sp)
8000093a:	de06                	sw	ra,60(sp)
8000093c:	1b090913          	addi	s2,s2,432 # 800051b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b1>
80000940:	0a5020ef          	jal	ra,800031e4 <z_impl_k_sem_init>
	k_tid_t tid[THREAD_NUM];

	k_sem_init(&sync_sema, 0, THREAD_NUM);

	/* create multiple threads to invoke same memory pool APIs*/
	for (int i = 0; i < THREAD_NUM; i++) {
80000944:	1c040a93          	addi	s5,s0,448
80000948:	8a26                	mv	s4,s1
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
8000094a:	80001b37          	lui	s6,0x80001
8000094e:	85ca                	mv	a1,s2
80000950:	8522                	mv	a0,s0
80000952:	c202                	sw	zero,4(sp)
80000954:	c002                	sw	zero,0(sp)
80000956:	4885                	li	a7,1
80000958:	4801                	li	a6,0
8000095a:	4781                	li	a5,0
8000095c:	4701                	li	a4,0
8000095e:	9b0b0693          	addi	a3,s6,-1616 # 800009b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009b1>
80000962:	20000613          	li	a2,512
80000966:	559020ef          	jal	ra,800036be <z_impl_k_thread_create>
		tid[i] = k_thread_create(&tdata[i], tstack[i], STACK_SIZE,
8000096a:	00aa2023          	sw	a0,0(s4)
8000096e:	07040413          	addi	s0,s0,112
80000972:	20090913          	addi	s2,s2,512
80000976:	0a11                	addi	s4,s4,4
	for (int i = 0; i < THREAD_NUM; i++) {
80000978:	fd541be3          	bne	s0,s5,8000094e <test_mpool_threadsafe+0x3e>
8000097c:	4411                	li	s0,4

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
8000097e:	55fd                	li	a1,-1
80000980:	e4c98513          	addi	a0,s3,-436
80000984:	147d                	addi	s0,s0,-1
80000986:	1a9020ef          	jal	ra,8000332e <z_impl_k_sem_take>
					 tmpool_api, NULL, NULL, NULL,
					 K_PRIO_PREEMPT(1), 0, 0);
	}
	/* TESTPOINT: all threads complete and exit the entry function*/
	for (int i = 0; i < THREAD_NUM; i++) {
8000098a:	f875                	bnez	s0,8000097e <test_mpool_threadsafe+0x6e>
8000098c:	01048413          	addi	s0,s1,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000990:	4088                	lw	a0,0(s1)
80000992:	0491                	addi	s1,s1,4
80000994:	643020ef          	jal	ra,800037d6 <z_impl_k_thread_abort>
		k_sem_take(&sync_sema, K_FOREVER);
	}

	/* test case tear down*/
	for (int i = 0; i < THREAD_NUM; i++) {
80000998:	fe849ce3          	bne	s1,s0,80000990 <test_mpool_threadsafe+0x80>
		k_thread_abort(tid[i]);
	}
}
8000099c:	50f2                	lw	ra,60(sp)
8000099e:	5462                	lw	s0,56(sp)
800009a0:	54d2                	lw	s1,52(sp)
800009a2:	5942                	lw	s2,48(sp)
800009a4:	59b2                	lw	s3,44(sp)
800009a6:	5a22                	lw	s4,40(sp)
800009a8:	5a92                	lw	s5,36(sp)
800009aa:	5b02                	lw	s6,32(sp)
800009ac:	6121                	addi	sp,sp,64
800009ae:	8082                	ret

800009b0 <tmpool_api>:
extern "C" {
#endif

K_SYSCALL_DECLARE3(K_SYSCALL_ATOMIC_CAS, atomic_cas, int, atomic_t *, target, atomic_val_t, old_value, atomic_val_t, new_value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_ADD, atomic_add, atomic_val_t, atomic_t *, target, atomic_val_t, value)
800009b0:	80005537          	lui	a0,0x80005
{
800009b4:	7119                	addi	sp,sp,-128
800009b6:	4585                	li	a1,1
800009b8:	db050513          	addi	a0,a0,-592 # 80004db0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004db1>
800009bc:	de86                	sw	ra,124(sp)
800009be:	dca2                	sw	s0,120(sp)
800009c0:	daa6                	sw	s1,116(sp)
800009c2:	d8ca                	sw	s2,112(sp)
800009c4:	d6ce                	sw	s3,108(sp)
800009c6:	d4d2                	sw	s4,104(sp)
800009c8:	d2d6                	sw	s5,100(sp)
800009ca:	d0da                	sw	s6,96(sp)
800009cc:	640030ef          	jal	ra,8000400c <z_impl_atomic_add>
	struct k_mem_pool *pool = pools[atomic_inc(&pool_id) % POOL_NUM];
800009d0:	800007b7          	lui	a5,0x80000
800009d4:	0785                	addi	a5,a5,1
800009d6:	8d7d                	and	a0,a0,a5
800009d8:	00055663          	bgez	a0,800009e4 <tmpool_api+0x34>
800009dc:	157d                	addi	a0,a0,-1
800009de:	ffe56513          	ori	a0,a0,-2
800009e2:	0505                	addi	a0,a0,1
800009e4:	800057b7          	lui	a5,0x80005
800009e8:	d1478793          	addi	a5,a5,-748 # 80004d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d15>
800009ec:	050a                	slli	a0,a0,0x2
800009ee:	953e                	add	a0,a0,a5
800009f0:	00052a03          	lw	s4,0(a0)
	(void)memset(block, 0, sizeof(block));
800009f4:	04000613          	li	a2,64
800009f8:	4581                	li	a1,0
800009fa:	1008                	addi	a0,sp,32
800009fc:	108010ef          	jal	ra,80001b04 <memset>
80000a00:	49a9                	li	s3,10
80000a02:	04010a93          	addi	s5,sp,64
		for (int i = 0; i < 5; i++) {
80000a06:	4b15                	li	s6,5
80000a08:	848a                	mv	s1,sp
{
80000a0a:	8926                	mv	s2,s1
80000a0c:	1000                	addi	s0,sp,32
			ret[i] = k_mem_pool_alloc(pool, &block[i],
80000a0e:	85a2                	mv	a1,s0
80000a10:	0c800693          	li	a3,200
80000a14:	4611                	li	a2,4
80000a16:	8552                	mv	a0,s4
80000a18:	5d6010ef          	jal	ra,80001fee <k_mem_pool_alloc>
80000a1c:	00a92023          	sw	a0,0(s2)
80000a20:	0421                	addi	s0,s0,8
80000a22:	0911                	addi	s2,s2,4
		for (int i = 0; i < 4; i++) {
80000a24:	ff5415e3          	bne	s0,s5,80000a0e <tmpool_api+0x5e>
		ret[4] = k_mem_pool_alloc(pool, &block[4], BLK_SIZE_MAX,
80000a28:	0c800693          	li	a3,200
80000a2c:	4641                	li	a2,16
80000a2e:	85d6                	mv	a1,s5
80000a30:	8552                	mv	a0,s4
80000a32:	5bc010ef          	jal	ra,80001fee <k_mem_pool_alloc>
80000a36:	c82a                	sw	a0,16(sp)
		for (int i = 0; i < 5; i++) {
80000a38:	4401                	li	s0,0
			if (ret[i] == 0) {
80000a3a:	409c                	lw	a5,0(s1)
80000a3c:	e799                	bnez	a5,80000a4a <tmpool_api+0x9a>
				k_mem_pool_free(&block[i]);
80000a3e:	00341513          	slli	a0,s0,0x3
80000a42:	101c                	addi	a5,sp,32
80000a44:	953e                	add	a0,a0,a5
80000a46:	7f2010ef          	jal	ra,80002238 <k_mem_pool_free>
		for (int i = 0; i < 5; i++) {
80000a4a:	0405                	addi	s0,s0,1
80000a4c:	0491                	addi	s1,s1,4
80000a4e:	ff6416e3          	bne	s0,s6,80000a3a <tmpool_api+0x8a>
80000a52:	19fd                	addi	s3,s3,-1
	for (int loops = 0; loops < LOOPS; loops++) {
80000a54:	fa099ae3          	bnez	s3,80000a08 <tmpool_api+0x58>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000a58:	80005537          	lui	a0,0x80005
80000a5c:	e4c50513          	addi	a0,a0,-436 # 80004e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e4d>
80000a60:	025020ef          	jal	ra,80003284 <z_impl_k_sem_give>
}
80000a64:	50f6                	lw	ra,124(sp)
80000a66:	5466                	lw	s0,120(sp)
80000a68:	54d6                	lw	s1,116(sp)
80000a6a:	5946                	lw	s2,112(sp)
80000a6c:	59b6                	lw	s3,108(sp)
80000a6e:	5a26                	lw	s4,104(sp)
80000a70:	5a96                	lw	s5,100(sp)
80000a72:	5b06                	lw	s6,96(sp)
80000a74:	6109                	addi	sp,sp,128
80000a76:	8082                	ret

80000a78 <test_main>:

void test_main(void)
{
	ztest_test_suite(mpool_threadsafe,
			 ztest_unit_test(test_mpool_threadsafe));
	ztest_run_test_suite(mpool_threadsafe);
80000a78:	800055b7          	lui	a1,0x80005
80000a7c:	80004537          	lui	a0,0x80004
80000a80:	cd858593          	addi	a1,a1,-808 # 80004cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cd9>
80000a84:	37050513          	addi	a0,a0,880 # 80004370 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004371>
80000a88:	1460106f          	j	80001bce <z_ztest_run_test_suite>

80000a8c <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000a8c:	1141                	addi	sp,sp,-16
80000a8e:	c606                	sw	ra,12(sp)
80000a90:	c422                	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000a92:	4799                	li	a5,6
80000a94:	02f50263          	beq	a0,a5,80000ab8 <z_SysFatalErrorHandler+0x2c>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000a98:	21d020ef          	jal	ra,800034b4 <k_is_in_isr>
80000a9c:	c10d                	beqz	a0,80000abe <z_SysFatalErrorHandler+0x32>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000a9e:	217020ef          	jal	ra,800034b4 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000aa2:	e121                	bnez	a0,80000ae2 <z_SysFatalErrorHandler+0x56>
80000aa4:	800045b7          	lui	a1,0x80004
80000aa8:	63458593          	addi	a1,a1,1588 # 80004634 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004635>
80000aac:	80004537          	lui	a0,0x80004
80000ab0:	64850513          	addi	a0,a0,1608 # 80004648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004649>
80000ab4:	3ff000ef          	jal	ra,800016b2 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000ab8:	441000ef          	jal	ra,800016f8 <k_cpu_idle>
80000abc:	bff5                	j	80000ab8 <z_SysFatalErrorHandler+0x2c>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000abe:	205020ef          	jal	ra,800034c2 <z_is_thread_essential>
80000ac2:	fd71                	bnez	a0,80000a9e <z_SysFatalErrorHandler+0x12>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000ac4:	80005437          	lui	s0,0x80005
80000ac8:	17c40413          	addi	s0,s0,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80000acc:	440c                	lw	a1,8(s0)
80000ace:	80004537          	lui	a0,0x80004
80000ad2:	66850513          	addi	a0,a0,1640 # 80004668 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004669>
80000ad6:	3dd000ef          	jal	ra,800016b2 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000ada:	4408                	lw	a0,8(s0)
80000adc:	4fb020ef          	jal	ra,800037d6 <z_impl_k_thread_abort>
80000ae0:	bfe1                	j	80000ab8 <z_SysFatalErrorHandler+0x2c>
		printk("Fatal fault in %s! Spinning...\n",
80000ae2:	800045b7          	lui	a1,0x80004
80000ae6:	63058593          	addi	a1,a1,1584 # 80004630 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004631>
80000aea:	b7c9                	j	80000aac <z_SysFatalErrorHandler+0x20>

80000aec <z_NanoFatalErrorHandler>:
{
80000aec:	715d                	addi	sp,sp,-80
80000aee:	c4a2                	sw	s0,72(sp)
80000af0:	c2a6                	sw	s1,68(sp)
80000af2:	c686                	sw	ra,76(sp)
	switch (reason) {
80000af4:	4799                	li	a5,6
{
80000af6:	84aa                	mv	s1,a0
80000af8:	842e                	mv	s0,a1
	switch (reason) {
80000afa:	08a7e963          	bltu	a5,a0,80000b8c <z_NanoFatalErrorHandler+0xa0>
80000afe:	80004737          	lui	a4,0x80004
80000b02:	00251793          	slli	a5,a0,0x2
80000b06:	38470713          	addi	a4,a4,900 # 80004384 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004385>
80000b0a:	97ba                	add	a5,a5,a4
80000b0c:	439c                	lw	a5,0(a5)
80000b0e:	8782                	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000b10:	80004537          	lui	a0,0x80004
80000b14:	4b450513          	addi	a0,a0,1204 # 800044b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800044b5>
		printk("***** Kernel OOPS! *****\n");
80000b18:	39b000ef          	jal	ra,800016b2 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000b1c:	6be020ef          	jal	ra,800031da <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000b20:	407c                	lw	a5,68(s0)
80000b22:	01042883          	lw	a7,16(s0)
80000b26:	00c42803          	lw	a6,12(s0)
80000b2a:	d83e                	sw	a5,48(sp)
80000b2c:	403c                	lw	a5,64(s0)
80000b2e:	4058                	lw	a4,4(s0)
80000b30:	4014                	lw	a3,0(s0)
80000b32:	d63e                	sw	a5,44(sp)
80000b34:	5c5c                	lw	a5,60(s0)
80000b36:	4430                	lw	a2,72(s0)
80000b38:	85aa                	mv	a1,a0
80000b3a:	d43e                	sw	a5,40(sp)
80000b3c:	5c1c                	lw	a5,56(s0)
80000b3e:	80004537          	lui	a0,0x80004
80000b42:	53850513          	addi	a0,a0,1336 # 80004538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004539>
80000b46:	d23e                	sw	a5,36(sp)
80000b48:	585c                	lw	a5,52(s0)
80000b4a:	d03e                	sw	a5,32(sp)
80000b4c:	581c                	lw	a5,48(s0)
80000b4e:	ce3e                	sw	a5,28(sp)
80000b50:	545c                	lw	a5,44(s0)
80000b52:	cc3e                	sw	a5,24(sp)
80000b54:	541c                	lw	a5,40(s0)
80000b56:	ca3e                	sw	a5,20(sp)
80000b58:	505c                	lw	a5,36(s0)
80000b5a:	c83e                	sw	a5,16(sp)
80000b5c:	501c                	lw	a5,32(s0)
80000b5e:	c63e                	sw	a5,12(sp)
80000b60:	4c5c                	lw	a5,28(s0)
80000b62:	c43e                	sw	a5,8(sp)
80000b64:	4c1c                	lw	a5,24(s0)
80000b66:	c23e                	sw	a5,4(sp)
80000b68:	485c                	lw	a5,20(s0)
80000b6a:	c03e                	sw	a5,0(sp)
80000b6c:	441c                	lw	a5,8(s0)
80000b6e:	345000ef          	jal	ra,800016b2 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000b72:	85a2                	mv	a1,s0
80000b74:	8526                	mv	a0,s1
80000b76:	3f19                	jal	80000a8c <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000b78:	80004537          	lui	a0,0x80004
80000b7c:	4dc50513          	addi	a0,a0,1244 # 800044dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800044dd>
80000b80:	bf61                	j	80000b18 <z_NanoFatalErrorHandler+0x2c>
		printk("***** Kernel Panic! *****\n");
80000b82:	80004537          	lui	a0,0x80004
80000b86:	4f850513          	addi	a0,a0,1272 # 800044f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800044f9>
80000b8a:	b779                	j	80000b18 <z_NanoFatalErrorHandler+0x2c>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000b8c:	80004537          	lui	a0,0x80004
80000b90:	85a6                	mv	a1,s1
80000b92:	51450513          	addi	a0,a0,1300 # 80004514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004515>
80000b96:	31d000ef          	jal	ra,800016b2 <printk>
		break;
80000b9a:	b749                	j	80000b1c <z_NanoFatalErrorHandler+0x30>

80000b9c <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000b9c:	1141                	addi	sp,sp,-16
80000b9e:	c422                	sw	s0,8(sp)
80000ba0:	c606                	sw	ra,12(sp)
80000ba2:	842a                	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000ba4:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000ba8:	0606                	slli	a2,a2,0x1
80000baa:	8205                	srli	a2,a2,0x1
	switch (cause) {
80000bac:	4795                	li	a5,5
80000bae:	02c7e363          	bltu	a5,a2,80000bd4 <_Fault+0x38>
80000bb2:	80004737          	lui	a4,0x80004
80000bb6:	00261793          	slli	a5,a2,0x2
80000bba:	3a070713          	addi	a4,a4,928 # 800043a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800043a1>
80000bbe:	97ba                	add	a5,a5,a4
80000bc0:	438c                	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000bc2:	80004537          	lui	a0,0x80004
80000bc6:	3c050513          	addi	a0,a0,960 # 800043c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800043c1>
80000bca:	2e9000ef          	jal	ra,800016b2 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000bce:	85a2                	mv	a1,s0
80000bd0:	4501                	li	a0,0
80000bd2:	3f29                	jal	80000aec <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000bd4:	800045b7          	lui	a1,0x80004
80000bd8:	3b858593          	addi	a1,a1,952 # 800043b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800043b9>
80000bdc:	b7dd                	j	80000bc2 <_Fault+0x26>

80000bde <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000bde:	1141                	addi	sp,sp,-16
80000be0:	c606                	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000be2:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000be6:	80004537          	lui	a0,0x80004
	mcause &= SOC_MCAUSE_EXP_MASK;
80000bea:	0586                	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000bec:	8185                	srli	a1,a1,0x1
80000bee:	69050513          	addi	a0,a0,1680 # 80004690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004691>
80000bf2:	2c1000ef          	jal	ra,800016b2 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000bf6:	800045b7          	lui	a1,0x80004
80000bfa:	3dc58593          	addi	a1,a1,988 # 800043dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800043dd>
80000bfe:	4511                	li	a0,4
80000c00:	35f5                	jal	80000aec <z_NanoFatalErrorHandler>

80000c02 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000c02:	800057b7          	lui	a5,0x80005
80000c06:	db478793          	addi	a5,a5,-588 # 80004db4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004db5>
80000c0a:	4398                	lw	a4,0(a5)
80000c0c:	cb11                	beqz	a4,80000c20 <z_irq_do_offload+0x1e>
		return;

	tmp = _offload_routine;
80000c0e:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000c12:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000c16:	800057b7          	lui	a5,0x80005
80000c1a:	db87a503          	lw	a0,-584(a5) # 80004db8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004db9>
80000c1e:	8302                	jr	t1
}
80000c20:	8082                	ret

80000c22 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000c22:	1141                	addi	sp,sp,-16
80000c24:	c606                	sw	ra,12(sp)
	z_bss_zero();
80000c26:	236010ef          	jal	ra,80001e5c <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000c2a:	2e7000ef          	jal	ra,80001710 <soc_interrupt_init>
#endif
	z_cstart();
80000c2e:	280010ef          	jal	ra,80001eae <z_cstart>

80000c32 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000c32:	7179                	addi	sp,sp,-48
80000c34:	d422                	sw	s0,40(sp)
80000c36:	d226                	sw	s1,36(sp)
80000c38:	d04a                	sw	s2,32(sp)
80000c3a:	ce4e                	sw	s3,28(sp)
80000c3c:	cc52                	sw	s4,24(sp)
80000c3e:	ca56                	sw	s5,20(sp)
80000c40:	c85a                	sw	s6,16(sp)
80000c42:	c65e                	sw	s7,12(sp)
80000c44:	8b3e                	mv	s6,a5
80000c46:	d606                	sw	ra,44(sp)
80000c48:	c462                	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000c4a:	47bd                	li	a5,15
{
80000c4c:	84aa                	mv	s1,a0
80000c4e:	842e                	mv	s0,a1
80000c50:	89b2                	mv	s3,a2
80000c52:	8a36                	mv	s4,a3
80000c54:	8bba                	mv	s7,a4
80000c56:	8ac2                	mv	s5,a6
80000c58:	8946                	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000c5a:	06f89463          	bne	a7,a5,80000cc2 <z_new_thread+0x90>
80000c5e:	800027b7          	lui	a5,0x80002
80000c62:	e3678793          	addi	a5,a5,-458 # 80001e36 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001e37>
80000c66:	06f69363          	bne	a3,a5,80000ccc <z_new_thread+0x9a>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000c6a:	56c2                	lw	a3,48(sp)
80000c6c:	85ca                	mv	a1,s2
80000c6e:	8526                	mv	a0,s1
80000c70:	4611                	li	a2,4
80000c72:	0cd020ef          	jal	ra,8000353e <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000c76:	fb098593          	addi	a1,s3,-80
80000c7a:	95a2                	add	a1,a1,s0
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000c7c:	6789                	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000c7e:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000c82:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000c86:	99c1                	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000c88:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000c8c:	c5fc                	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000c8e:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000c92:	50b2                	lw	ra,44(sp)
80000c94:	5422                	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000c96:	90878793          	addi	a5,a5,-1784 # 80000908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000909>
	stack_init->a0 = (u32_t)thread_func;
80000c9a:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000c9e:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000ca2:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000ca6:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000caa:	c5bc                	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000cac:	d48c                	sw	a1,40(s1)
}
80000cae:	5902                	lw	s2,32(sp)
80000cb0:	5492                	lw	s1,36(sp)
80000cb2:	49f2                	lw	s3,28(sp)
80000cb4:	4a62                	lw	s4,24(sp)
80000cb6:	4ad2                	lw	s5,20(sp)
80000cb8:	4b42                	lw	s6,16(sp)
80000cba:	4bb2                	lw	s7,12(sp)
80000cbc:	4c22                	lw	s8,8(sp)
80000cbe:	6145                	addi	sp,sp,48
80000cc0:	8082                	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000cc2:	01088693          	addi	a3,a7,16
80000cc6:	47f9                	li	a5,30
80000cc8:	fad7f1e3          	bgeu	a5,a3,80000c6a <z_new_thread+0x38>
80000ccc:	80004c37          	lui	s8,0x80004
80000cd0:	800045b7          	lui	a1,0x80004
80000cd4:	80004537          	lui	a0,0x80004
80000cd8:	6b8c0613          	addi	a2,s8,1720 # 800046b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046b9>
80000cdc:	46e1                	li	a3,24
80000cde:	6d858593          	addi	a1,a1,1752 # 800046d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046d9>
80000ce2:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80000ce6:	1cd000ef          	jal	ra,800016b2 <printk>
80000cea:	80004537          	lui	a0,0x80004
80000cee:	85ca                	mv	a1,s2
80000cf0:	56c1                	li	a3,-16
80000cf2:	4639                	li	a2,14
80000cf4:	78450513          	addi	a0,a0,1924 # 80004784 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004785>
80000cf8:	1bb000ef          	jal	ra,800016b2 <printk>
80000cfc:	45e1                	li	a1,24
80000cfe:	6b8c0513          	addi	a0,s8,1720
80000d02:	1cf000ef          	jal	ra,800016d0 <assert_post_action>
80000d06:	b795                	j	80000c6a <z_new_thread+0x38>

80000d08 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80000d08:	00159793          	slli	a5,a1,0x1
80000d0c:	97ae                	add	a5,a5,a1
80000d0e:	00279713          	slli	a4,a5,0x2
80000d12:	455c                	lw	a5,12(a0)
80000d14:	97ba                	add	a5,a5,a4
80000d16:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80000d1a:	00b75363          	bge	a4,a1,80000d20 <get_bit_ptr+0x18>
80000d1e:	439c                	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80000d20:	41f65713          	srai	a4,a2,0x1f
80000d24:	8b7d                	andi	a4,a4,31
80000d26:	9732                	add	a4,a4,a2
80000d28:	8715                	srai	a4,a4,0x5
80000d2a:	070a                	slli	a4,a4,0x2
80000d2c:	97ba                	add	a5,a5,a4
80000d2e:	c29c                	sw	a5,0(a3)

	return bn & 0x1f;
}
80000d30:	01f67513          	andi	a0,a2,31
80000d34:	8082                	ret

80000d36 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000d36:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000d38:	0074                	addi	a3,sp,12
{
80000d3a:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000d3c:	37f1                	jal	80000d08 <get_bit_ptr>

	*word |= (1<<bit);
80000d3e:	4732                	lw	a4,12(sp)
80000d40:	4785                	li	a5,1
80000d42:	00a79533          	sll	a0,a5,a0
80000d46:	431c                	lw	a5,0(a4)
}
80000d48:	40f2                	lw	ra,28(sp)
	*word |= (1<<bit);
80000d4a:	8fc9                	or	a5,a5,a0
80000d4c:	c31c                	sw	a5,0(a4)
}
80000d4e:	6105                	addi	sp,sp,32
80000d50:	8082                	ret

80000d52 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000d52:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000d54:	0074                	addi	a3,sp,12
{
80000d56:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000d58:	3f45                	jal	80000d08 <get_bit_ptr>

	*word &= ~(1<<bit);
80000d5a:	4732                	lw	a4,12(sp)
80000d5c:	4785                	li	a5,1
80000d5e:	00a79533          	sll	a0,a5,a0
80000d62:	431c                	lw	a5,0(a4)
}
80000d64:	40f2                	lw	ra,28(sp)
	*word &= ~(1<<bit);
80000d66:	fff54513          	not	a0,a0
80000d6a:	8d7d                	and	a0,a0,a5
80000d6c:	c308                	sw	a0,0(a4)
}
80000d6e:	6105                	addi	sp,sp,32
80000d70:	8082                	ret

80000d72 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80000d72:	1101                	addi	sp,sp,-32
80000d74:	ca26                	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000d76:	4144                	lw	s1,4(a0)
{
80000d78:	cc22                	sw	s0,24(sp)
80000d7a:	842a                	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000d7c:	00855503          	lhu	a0,8(a0)
80000d80:	85a6                	mv	a1,s1
{
80000d82:	c84a                	sw	s2,16(sp)
80000d84:	c64e                	sw	s3,12(sp)
80000d86:	c452                	sw	s4,8(sp)
80000d88:	c256                	sw	s5,4(sp)
80000d8a:	c05a                	sw	s6,0(sp)
80000d8c:	ce06                	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000d8e:	3479                	jal	8000081c <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000d90:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80000d94:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80000d98:	57fd                	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000d9a:	8a2a                	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000d9c:	99aa                	add	s3,s3,a0
	p->max_inline_level = -1;
80000d9e:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80000da2:	4901                	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80000da4:	4b7d                	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80000da6:	03594163          	blt	s2,s5,80000dc8 <z_sys_mem_pool_base_init+0x56>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80000daa:	4481                	li	s1,0
80000dac:	00845783          	lhu	a5,8(s0)
80000db0:	04f4ce63          	blt	s1,a5,80000e0c <z_sys_mem_pool_base_init+0x9a>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80000db4:	40f2                	lw	ra,28(sp)
80000db6:	4462                	lw	s0,24(sp)
80000db8:	44d2                	lw	s1,20(sp)
80000dba:	4942                	lw	s2,16(sp)
80000dbc:	49b2                	lw	s3,12(sp)
80000dbe:	4a22                	lw	s4,8(sp)
80000dc0:	4a92                	lw	s5,4(sp)
80000dc2:	4b02                	lw	s6,0(sp)
80000dc4:	6105                	addi	sp,sp,32
80000dc6:	8082                	ret
		int nblocks = buflen / sz;
80000dc8:	85a6                	mv	a1,s1
80000dca:	8552                	mv	a0,s4
80000dcc:	3cb5                	jal	80000848 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80000dce:	00191713          	slli	a4,s2,0x1
80000dd2:	974a                	add	a4,a4,s2
80000dd4:	00271793          	slli	a5,a4,0x2
80000dd8:	4458                	lw	a4,12(s0)
80000dda:	973e                	add	a4,a4,a5
80000ddc:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80000de0:	c35c                	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80000de2:	c71c                	sw	a5,8(a4)
		if (nblocks < 32) {
80000de4:	00ab4963          	blt	s6,a0,80000df6 <z_sys_mem_pool_base_init+0x84>
			p->max_inline_level = i;
80000de8:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
80000dec:	8089                	srli	s1,s1,0x2
80000dee:	048d                	addi	s1,s1,3
80000df0:	98f1                	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
80000df2:	0905                	addi	s2,s2,1
80000df4:	bf4d                	j	80000da6 <z_sys_mem_pool_base_init+0x34>
			bits += (nblocks + 31)/32;
80000df6:	057d                	addi	a0,a0,31
80000df8:	41f55793          	srai	a5,a0,0x1f
80000dfc:	8bfd                	andi	a5,a5,31
80000dfe:	97aa                	add	a5,a5,a0
80000e00:	8795                	srai	a5,a5,0x5
80000e02:	078a                	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80000e04:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80000e08:	99be                	add	s3,s3,a5
80000e0a:	b7cd                	j	80000dec <z_sys_mem_pool_base_init+0x7a>
	return (u8_t *)p->buf + lsz * block;
80000e0c:	404c                	lw	a1,4(s0)
80000e0e:	8526                	mv	a0,s1
80000e10:	3431                	jal	8000081c <__mulsi3>
80000e12:	401c                	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80000e14:	8626                	mv	a2,s1
80000e16:	4581                	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80000e18:	953e                	add	a0,a0,a5
		sys_dlist_append(&p->levels[0].free_list, block);
80000e1a:	445c                	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80000e1c:	0485                	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80000e1e:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80000e22:	c118                	sw	a4,0(a0)
	node->prev = list->tail;
80000e24:	4798                	lw	a4,8(a5)
80000e26:	c158                	sw	a4,4(a0)

	list->tail->next = node;
80000e28:	4798                	lw	a4,8(a5)
80000e2a:	c308                	sw	a0,0(a4)
	list->tail = node;
80000e2c:	c788                	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80000e2e:	8522                	mv	a0,s0
80000e30:	3719                	jal	80000d36 <set_free_bit>
80000e32:	bfad                	j	80000dac <z_sys_mem_pool_base_init+0x3a>

80000e34 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80000e34:	711d                	addi	sp,sp,-96
80000e36:	cca2                	sw	s0,88(sp)
80000e38:	c2d6                	sw	s5,68(sp)
80000e3a:	ce86                	sw	ra,92(sp)
80000e3c:	caa6                	sw	s1,84(sp)
80000e3e:	c8ca                	sw	s2,80(sp)
80000e40:	c6ce                	sw	s3,76(sp)
80000e42:	c4d2                	sw	s4,72(sp)
80000e44:	c0da                	sw	s6,64(sp)
80000e46:	de5e                	sw	s7,60(sp)
80000e48:	dc62                	sw	s8,56(sp)
80000e4a:	da66                	sw	s9,52(sp)
80000e4c:	d86a                	sw	s10,48(sp)
80000e4e:	d66e                	sw	s11,44(sp)
80000e50:	1080                	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000e52:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80000e56:	4881                	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000e58:	002e1793          	slli	a5,t3,0x2
80000e5c:	07bd                	addi	a5,a5,15
80000e5e:	7f07f793          	andi	a5,a5,2032
80000e62:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80000e66:	415c                	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000e68:	8a8a                	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80000e6a:	8356                	mv	t1,s5
80000e6c:	078d                	addi	a5,a5,3
80000e6e:	9bf1                	andi	a5,a5,-4
80000e70:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
80000e74:	fff88b13          	addi	s6,a7,-1
80000e78:	03c8d263          	bge	a7,t3,80000e9c <z_sys_mem_pool_block_alloc+0x68>
		if (i > 0) {
80000e7c:	00088b63          	beqz	a7,80000e92 <z_sys_mem_pool_block_alloc+0x5e>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80000e80:	ffc32803          	lw	a6,-4(t1) # 7ffffffc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x7ffffffd>
80000e84:	00285813          	srli	a6,a6,0x2
80000e88:	080d                	addi	a6,a6,3
80000e8a:	ffc87813          	andi	a6,a6,-4
80000e8e:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
80000e92:	0311                	addi	t1,t1,4
80000e94:	ffc32803          	lw	a6,-4(t1)
80000e98:	02b87963          	bgeu	a6,a1,80000eca <z_sys_mem_pool_block_alloc+0x96>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80000e9c:	55fd                	li	a1,-1
80000e9e:	02bb1863          	bne	s6,a1,80000ece <z_sys_mem_pool_block_alloc+0x9a>
		*data_p = NULL;
80000ea2:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
80000ea6:	5551                	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
80000ea8:	fa040113          	addi	sp,s0,-96
80000eac:	40f6                	lw	ra,92(sp)
80000eae:	4466                	lw	s0,88(sp)
80000eb0:	44d6                	lw	s1,84(sp)
80000eb2:	4946                	lw	s2,80(sp)
80000eb4:	49b6                	lw	s3,76(sp)
80000eb6:	4a26                	lw	s4,72(sp)
80000eb8:	4a96                	lw	s5,68(sp)
80000eba:	4b06                	lw	s6,64(sp)
80000ebc:	5bf2                	lw	s7,60(sp)
80000ebe:	5c62                	lw	s8,56(sp)
80000ec0:	5cd2                	lw	s9,52(sp)
80000ec2:	5d42                	lw	s10,48(sp)
80000ec4:	5db2                	lw	s11,44(sp)
80000ec6:	6125                	addi	sp,sp,96
80000ec8:	8082                	ret
	for (i = 0; i < p->n_levels; i++) {
80000eca:	0885                	addi	a7,a7,1
80000ecc:	b765                	j	80000e74 <z_sys_mem_pool_block_alloc+0x40>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000ece:	01054583          	lbu	a1,16(a0)
		return 0;
80000ed2:	4901                	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000ed4:	8985                	andi	a1,a1,1
80000ed6:	c591                	beqz	a1,80000ee2 <z_sys_mem_pool_block_alloc+0xae>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80000ed8:	4921                	li	s2,8
80000eda:	30093973          	csrrc	s2,mstatus,s2
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80000ede:	00897913          	andi	s2,s2,8
80000ee2:	fae42a23          	sw	a4,-76(s0)
80000ee6:	001b1713          	slli	a4,s6,0x1
80000eea:	fad42c23          	sw	a3,-72(s0)
80000eee:	975a                	add	a4,a4,s6
80000ef0:	4554                	lw	a3,12(a0)
80000ef2:	070a                	slli	a4,a4,0x2
80000ef4:	0711                	addi	a4,a4,4
80000ef6:	9736                	add	a4,a4,a3
80000ef8:	fac42e23          	sw	a2,-68(s0)
80000efc:	84aa                	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80000efe:	8a5a                	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
80000f00:	56fd                	li	a3,-1
	return list->head == list;
80000f02:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80000f06:	13370863          	beq	a4,s3,80001036 <z_sys_mem_pool_block_alloc+0x202>
		data = block_alloc(p, i, lsizes[i]);
80000f0a:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
80000f0e:	0049a683          	lw	a3,4(s3)
80000f12:	00ea8cb3          	add	s9,s5,a4
80000f16:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80000f1a:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80000f1e:	4d21                	li	s10,8
80000f20:	c298                	sw	a4,0(a3)
	node->next->prev = node->prev;
80000f22:	c354                	sw	a3,4(a4)
	node->next = NULL;
80000f24:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80000f28:	0009a223          	sw	zero,4(s3)
80000f2c:	4088                	lw	a0,0(s1)
80000f2e:	40a98533          	sub	a0,s3,a0
80000f32:	90fff0ef          	jal	ra,80000840 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
80000f36:	862a                	mv	a2,a0
80000f38:	85d2                	mv	a1,s4
80000f3a:	8526                	mv	a0,s1
80000f3c:	3d19                	jal	80000d52 <clear_free_bit>
		if (data != NULL) {
80000f3e:	0a05                	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
80000f40:	fffa0693          	addi	a3,s4,-1
80000f44:	0566c263          	blt	a3,s6,80000f88 <z_sys_mem_pool_block_alloc+0x154>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000f48:	0104c703          	lbu	a4,16(s1)
80000f4c:	8b05                	andi	a4,a4,1
80000f4e:	c319                	beqz	a4,80000f54 <z_sys_mem_pool_block_alloc+0x120>
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80000f50:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80000f54:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
80000f58:	5551                	li	a0,-12
	*data_p = data;
80000f5a:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80000f5e:	f40985e3          	beqz	s3,80000ea8 <z_sys_mem_pool_block_alloc+0x74>
	*level_p = alloc_l;
80000f62:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80000f66:	4088                	lw	a0,0(s1)
	*level_p = alloc_l;
80000f68:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80000f6c:	002b1793          	slli	a5,s6,0x2
80000f70:	9abe                	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80000f72:	000aa583          	lw	a1,0(s5)
80000f76:	40a98533          	sub	a0,s3,a0
80000f7a:	8c7ff0ef          	jal	ra,80000840 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
80000f7e:	fb842783          	lw	a5,-72(s0)
80000f82:	c388                	sw	a0,0(a5)
	return 0;
80000f84:	4501                	li	a0,0
80000f86:	b70d                	j	80000ea8 <z_sys_mem_pool_block_alloc+0x74>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80000f88:	4088                	lw	a0,0(s1)
80000f8a:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
80000f8e:	4b85                	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80000f90:	40a98533          	sub	a0,s3,a0
80000f94:	8adff0ef          	jal	ra,80000840 <__divsi3>
80000f98:	001a1893          	slli	a7,s4,0x1
80000f9c:	98d2                	add	a7,a7,s4
		int lbn = 4*bn + i;
80000f9e:	00251d93          	slli	s11,a0,0x2
80000fa2:	088a                	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
80000fa4:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
80000fa8:	85de                	mv	a1,s7
80000faa:	fb142623          	sw	a7,-84(s0)
80000fae:	8536                	mv	a0,a3
80000fb0:	fad42823          	sw	a3,-80(s0)
80000fb4:	869ff0ef          	jal	ra,8000081c <__mulsi3>
80000fb8:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
80000fbc:	01bb8633          	add	a2,s7,s11
80000fc0:	85d2                	mv	a1,s4
80000fc2:	8526                	mv	a0,s1
80000fc4:	3b8d                	jal	80000d36 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80000fc6:	fb042683          	lw	a3,-80(s0)
80000fca:	4090                	lw	a2,0(s1)
	return p->n_max * p->max_sz;
80000fcc:	40cc                	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80000fce:	16fd                	addi	a3,a3,-1
	return p->n_max * p->max_sz;
80000fd0:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80000fd4:	96e2                	add	a3,a3,s8
80000fd6:	8e91                	sub	a3,a3,a2
80000fd8:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
80000fdc:	841ff0ef          	jal	ra,8000081c <__mulsi3>
		if (block_fits(p, block2, lsz)) {
80000fe0:	fb042683          	lw	a3,-80(s0)
80000fe4:	fac42883          	lw	a7,-84(s0)
80000fe8:	02a6f063          	bgeu	a3,a0,80001008 <z_sys_mem_pool_block_alloc+0x1d4>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80000fec:	44d4                	lw	a3,12(s1)
80000fee:	96c6                	add	a3,a3,a7
80000ff0:	00468613          	addi	a2,a3,4
	node->next = list;
80000ff4:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
80000ff8:	4690                	lw	a2,8(a3)
80000ffa:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
80000ffe:	4690                	lw	a2,8(a3)
80001000:	01862023          	sw	s8,0(a2)
	list->tail = node;
80001004:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
80001008:	0b85                	addi	s7,s7,1
8000100a:	4791                	li	a5,4
8000100c:	f8fb9ce3          	bne	s7,a5,80000fa4 <z_sys_mem_pool_block_alloc+0x170>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001010:	0104c683          	lbu	a3,16(s1)
80001014:	8a85                	andi	a3,a3,1
80001016:	e689                	bnez	a3,80001020 <z_sys_mem_pool_block_alloc+0x1ec>
		return 0;
80001018:	4901                	li	s2,0
8000101a:	0a05                	addi	s4,s4,1
8000101c:	0c91                	addi	s9,s9,4
8000101e:	b70d                	j	80000f40 <z_sys_mem_pool_block_alloc+0x10c>
80001020:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001024:	0104c683          	lbu	a3,16(s1)
80001028:	8a85                	andi	a3,a3,1
8000102a:	d6fd                	beqz	a3,80001018 <z_sys_mem_pool_block_alloc+0x1e4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000102c:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
80001030:	00897913          	andi	s2,s2,8
80001034:	b7dd                	j	8000101a <z_sys_mem_pool_block_alloc+0x1e6>
	for (i = alloc_l; i >= 0; i--) {
80001036:	1a7d                	addi	s4,s4,-1
80001038:	ff498713          	addi	a4,s3,-12
8000103c:	ecda13e3          	bne	s4,a3,80000f02 <z_sys_mem_pool_block_alloc+0xce>
80001040:	4981                	li	s3,0
80001042:	b719                	j	80000f48 <z_sys_mem_pool_block_alloc+0x114>

80001044 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001044:	711d                	addi	sp,sp,-96
80001046:	cca2                	sw	s0,88(sp)
80001048:	c4d2                	sw	s4,72(sp)
8000104a:	da66                	sw	s9,52(sp)
8000104c:	ce86                	sw	ra,92(sp)
8000104e:	caa6                	sw	s1,84(sp)
80001050:	c8ca                	sw	s2,80(sp)
80001052:	c6ce                	sw	s3,76(sp)
80001054:	c2d6                	sw	s5,68(sp)
80001056:	c0da                	sw	s6,64(sp)
80001058:	de5e                	sw	s7,60(sp)
8000105a:	dc62                	sw	s8,56(sp)
8000105c:	d86a                	sw	s10,48(sp)
8000105e:	d66e                	sw	s11,44(sp)
80001060:	1080                	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001062:	00a54703          	lbu	a4,10(a0)
{
80001066:	8caa                	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001068:	070a                	slli	a4,a4,0x2
8000106a:	073d                	addi	a4,a4,15
8000106c:	7f077713          	andi	a4,a4,2032
80001070:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
80001074:	4158                	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001076:	8a0a                	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001078:	86d2                	mv	a3,s4
8000107a:	070d                	addi	a4,a4,3
8000107c:	9b71                	andi	a4,a4,-4
8000107e:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
80001082:	4505                	li	a0,1
80001084:	0691                	addi	a3,a3,4
80001086:	08a5f363          	bgeu	a1,a0,8000110c <z_sys_mem_pool_block_free+0xc8>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000108a:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
8000108e:	892e                	mv	s2,a1
80001090:	89b2                	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001092:	8b05                	andi	a4,a4,1
		return 0;
80001094:	4481                	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001096:	c709                	beqz	a4,800010a0 <z_sys_mem_pool_block_free+0x5c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001098:	44a1                	li	s1,8
8000109a:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
8000109e:	88a1                	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800010a0:	80004b37          	lui	s6,0x80004
	while (level >= 0) {
800010a4:	06095c63          	bgez	s2,8000111c <z_sys_mem_pool_block_free+0xd8>
	__ASSERT(0, "out of levels");
800010a8:	800044b7          	lui	s1,0x80004
800010ac:	800055b7          	lui	a1,0x80005
800010b0:	80004537          	lui	a0,0x80004
800010b4:	7b848613          	addi	a2,s1,1976 # 800047b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047b9>
800010b8:	0c000693          	li	a3,192
800010bc:	82058593          	addi	a1,a1,-2016 # 80004820 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004821>
800010c0:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800010c4:	23fd                	jal	800016b2 <printk>
800010c6:	80004537          	lui	a0,0x80004
800010ca:	7ec50513          	addi	a0,a0,2028 # 800047ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047ed>
800010ce:	23d5                	jal	800016b2 <printk>
800010d0:	7b848513          	addi	a0,s1,1976
800010d4:	0c000593          	li	a1,192
800010d8:	2be5                	jal	800016d0 <assert_post_action>
	return -1;
800010da:	54fd                	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800010dc:	010cc783          	lbu	a5,16(s9)
800010e0:	8b85                	andi	a5,a5,1
800010e2:	c781                	beqz	a5,800010ea <z_sys_mem_pool_block_free+0xa6>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
800010e4:	88a1                	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800010e6:	3004a4f3          	csrrs	s1,mstatus,s1
}
800010ea:	fa040113          	addi	sp,s0,-96
800010ee:	40f6                	lw	ra,92(sp)
800010f0:	4466                	lw	s0,88(sp)
800010f2:	44d6                	lw	s1,84(sp)
800010f4:	4946                	lw	s2,80(sp)
800010f6:	49b6                	lw	s3,76(sp)
800010f8:	4a26                	lw	s4,72(sp)
800010fa:	4a96                	lw	s5,68(sp)
800010fc:	4b06                	lw	s6,64(sp)
800010fe:	5bf2                	lw	s7,60(sp)
80001100:	5c62                	lw	s8,56(sp)
80001102:	5cd2                	lw	s9,52(sp)
80001104:	5d42                	lw	s10,48(sp)
80001106:	5db2                	lw	s11,44(sp)
80001108:	6125                	addi	sp,sp,96
8000110a:	8082                	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000110c:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
80001110:	0505                	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001112:	8309                	srli	a4,a4,0x2
80001114:	070d                	addi	a4,a4,3
80001116:	9b71                	andi	a4,a4,-4
80001118:	c298                	sw	a4,0(a3)
8000111a:	b7ad                	j	80001084 <z_sys_mem_pool_block_free+0x40>
		int i, lsz = lsizes[level];
8000111c:	00291713          	slli	a4,s2,0x2
80001120:	9752                	add	a4,a4,s4
80001122:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
80001126:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
8000112a:	854e                	mv	a0,s3
8000112c:	85d6                	mv	a1,s5
8000112e:	eeeff0ef          	jal	ra,8000081c <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001132:	fffa8b93          	addi	s7,s5,-1
80001136:	01750d33          	add	s10,a0,s7
8000113a:	9c2a                	add	s8,s8,a0
	return p->n_max * p->max_sz;
8000113c:	004ca583          	lw	a1,4(s9)
80001140:	008cd503          	lhu	a0,8(s9)
80001144:	ed8ff0ef          	jal	ra,8000081c <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
80001148:	02ad6963          	bltu	s10,a0,8000117a <z_sys_mem_pool_block_free+0x136>
8000114c:	800047b7          	lui	a5,0x80004
80001150:	7cc78593          	addi	a1,a5,1996 # 800047cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047cd>
80001154:	800047b7          	lui	a5,0x80004
80001158:	76478513          	addi	a0,a5,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000115c:	0a400693          	li	a3,164
80001160:	7b8b0613          	addi	a2,s6,1976 # 800047b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047b9>
80001164:	23b9                	jal	800016b2 <printk>
80001166:	800047b7          	lui	a5,0x80004
8000116a:	7e878513          	addi	a0,a5,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
8000116e:	2391                	jal	800016b2 <printk>
80001170:	0a400593          	li	a1,164
80001174:	7b8b0513          	addi	a0,s6,1976
80001178:	2ba1                	jal	800016d0 <assert_post_action>
		set_free_bit(p, level, bn);
8000117a:	864e                	mv	a2,s3
8000117c:	85ca                	mv	a1,s2
8000117e:	8566                	mv	a0,s9
80001180:	3e5d                	jal	80000d36 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
80001182:	00191713          	slli	a4,s2,0x1
80001186:	974a                	add	a4,a4,s2
80001188:	00271693          	slli	a3,a4,0x2
8000118c:	00cca703          	lw	a4,12(s9)
80001190:	9736                	add	a4,a4,a3
80001192:	00470693          	addi	a3,a4,4
	node->next = list;
80001196:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
8000119a:	4714                	lw	a3,8(a4)
8000119c:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
800011a0:	4714                	lw	a3,8(a4)
800011a2:	0186a023          	sw	s8,0(a3)
	list->tail = node;
800011a6:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800011aa:	010cc703          	lbu	a4,16(s9)
800011ae:	8b05                	andi	a4,a4,1
800011b0:	e345                	bnez	a4,80001250 <z_sys_mem_pool_block_free+0x20c>
		return 0;
800011b2:	4481                	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800011b4:	f20904e3          	beqz	s2,800010dc <z_sys_mem_pool_block_free+0x98>
	int bit = get_bit_ptr(p, level, bn, &word);
800011b8:	fbc40693          	addi	a3,s0,-68
800011bc:	864e                	mv	a2,s3
800011be:	85ca                	mv	a1,s2
800011c0:	8566                	mv	a0,s9
800011c2:	3699                	jal	80000d08 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
800011c4:	fbc42683          	lw	a3,-68(s0)
800011c8:	41f55713          	srai	a4,a0,0x1f
800011cc:	8b0d                	andi	a4,a4,3
800011ce:	972a                	add	a4,a4,a0
800011d0:	4288                	lw	a0,0(a3)
800011d2:	9b71                	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800011d4:	47bd                	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
800011d6:	00e55733          	srl	a4,a0,a4
800011da:	8b3d                	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800011dc:	f0f710e3          	bne	a4,a5,800010dc <z_sys_mem_pool_block_free+0x98>
		for (i = 0; i < 4; i++) {
800011e0:	4d01                	li	s10,0
			int b = (bn & ~3) + i;
800011e2:	ffc9fd93          	andi	s11,s3,-4
800011e6:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
800011ea:	8532                	mv	a0,a2
800011ec:	85d6                	mv	a1,s5
800011ee:	fac42423          	sw	a2,-88(s0)
800011f2:	e2aff0ef          	jal	ra,8000081c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800011f6:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
800011fa:	8c2a                	mv	s8,a0
	return p->n_max * p->max_sz;
800011fc:	004ca583          	lw	a1,4(s9)
80001200:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001204:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001208:	e14ff0ef          	jal	ra,8000081c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
8000120c:	fac42703          	lw	a4,-84(s0)
80001210:	fa842603          	lw	a2,-88(s0)
80001214:	02a77263          	bgeu	a4,a0,80001238 <z_sys_mem_pool_block_free+0x1f4>
				clear_free_bit(p, level, b);
80001218:	85ca                	mv	a1,s2
8000121a:	8566                	mv	a0,s9
8000121c:	3e1d                	jal	80000d52 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
8000121e:	000ca703          	lw	a4,0(s9)
80001222:	9c3a                	add	s8,s8,a4
	node->prev->next = node->next;
80001224:	004c2603          	lw	a2,4(s8)
80001228:	000c2703          	lw	a4,0(s8)
8000122c:	c218                	sw	a4,0(a2)
	node->next->prev = node->prev;
8000122e:	c350                	sw	a2,4(a4)
	node->next = NULL;
80001230:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80001234:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80001238:	0d05                	addi	s10,s10,1
8000123a:	4791                	li	a5,4
8000123c:	fafd15e3          	bne	s10,a5,800011e6 <z_sys_mem_pool_block_free+0x1a2>
		bn = bn / 4;
80001240:	41f9d613          	srai	a2,s3,0x1f
80001244:	8a0d                	andi	a2,a2,3
80001246:	99b2                	add	s3,s3,a2
		level = level - 1;
80001248:	197d                	addi	s2,s2,-1
		bn = bn / 4;
8000124a:	4029d993          	srai	s3,s3,0x2
8000124e:	bd99                	j	800010a4 <z_sys_mem_pool_block_free+0x60>
80001250:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001254:	010cc703          	lbu	a4,16(s9)
80001258:	8b05                	andi	a4,a4,1
8000125a:	df21                	beqz	a4,800011b2 <z_sys_mem_pool_block_free+0x16e>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000125c:	47a1                	li	a5,8
8000125e:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
80001262:	88a1                	andi	s1,s1,8
80001264:	bf81                	j	800011b4 <z_sys_mem_pool_block_free+0x170>

80001266 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001266:	1141                	addi	sp,sp,-16
80001268:	87aa                	mv	a5,a0
8000126a:	852e                	mv	a0,a1
8000126c:	85b2                	mv	a1,a2
	entry(p1, p2, p3);
8000126e:	8636                	mv	a2,a3
{
80001270:	c606                	sw	ra,12(sp)
	entry(p1, p2, p3);
80001272:	9782                	jalr	a5
80001274:	767010ef          	jal	ra,800031da <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001278:	55e020ef          	jal	ra,800037d6 <z_impl_k_thread_abort>

8000127c <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
8000127c:	4501                	li	a0,0
8000127e:	8082                	ret

80001280 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001280:	1141                	addi	sp,sp,-16
80001282:	c422                	sw	s0,8(sp)
80001284:	842a                	mv	s0,a0
	out('E', ctx);
80001286:	04500513          	li	a0,69
{
8000128a:	c606                	sw	ra,12(sp)
8000128c:	c226                	sw	s1,4(sp)
8000128e:	84ae                	mv	s1,a1
	out('E', ctx);
80001290:	9402                	jalr	s0
	out('R', ctx);
80001292:	85a6                	mv	a1,s1
80001294:	05200513          	li	a0,82
80001298:	9402                	jalr	s0
	out('R', ctx);
8000129a:	8322                	mv	t1,s0
}
8000129c:	4422                	lw	s0,8(sp)
8000129e:	40b2                	lw	ra,12(sp)
	out('R', ctx);
800012a0:	85a6                	mv	a1,s1
}
800012a2:	4492                	lw	s1,4(sp)
	out('R', ctx);
800012a4:	05200513          	li	a0,82
}
800012a8:	0141                	addi	sp,sp,16
	out('R', ctx);
800012aa:	8302                	jr	t1

800012ac <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
800012ac:	419c                	lw	a5,0(a1)
800012ae:	0785                	addi	a5,a5,1
800012b0:	c19c                	sw	a5,0(a1)
	return _char_out(c);
800012b2:	800057b7          	lui	a5,0x80005
800012b6:	d007a303          	lw	t1,-768(a5) # 80004d00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d01>
800012ba:	8302                	jr	t1

800012bc <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
800012bc:	7139                	addi	sp,sp,-64
800012be:	dc22                	sw	s0,56(sp)
800012c0:	d64e                	sw	s3,44(sp)
800012c2:	d452                	sw	s4,40(sp)
800012c4:	d05a                	sw	s6,32(sp)
800012c6:	c86a                	sw	s10,16(sp)
800012c8:	de06                	sw	ra,60(sp)
800012ca:	da26                	sw	s1,52(sp)
800012cc:	d84a                	sw	s2,48(sp)
800012ce:	d256                	sw	s5,36(sp)
800012d0:	ce5e                	sw	s7,28(sp)
800012d2:	cc62                	sw	s8,24(sp)
800012d4:	ca66                	sw	s9,20(sp)
800012d6:	c66e                	sw	s11,12(sp)
800012d8:	89aa                	mv	s3,a0
800012da:	8a2e                	mv	s4,a1
800012dc:	8d32                	mv	s10,a2
800012de:	8b36                	mv	s6,a3
800012e0:	4405                	li	s0,1
800012e2:	00e05363          	blez	a4,800012e8 <_printk_dec_ulong+0x2c>
800012e6:	843a                	mv	s0,a4
800012e8:	4785                	li	a5,1
800012ea:	02000c93          	li	s9,32
800012ee:	00fb1463          	bne	s6,a5,800012f6 <_printk_dec_ulong+0x3a>
800012f2:	03000c93          	li	s9,48
800012f6:	3b9ad4b7          	lui	s1,0x3b9ad
800012fa:	4905                	li	s2,1
800012fc:	4aa9                	li	s5,10
800012fe:	4c01                	li	s8,0
80001300:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001304:	4d89                	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001306:	00148b93          	addi	s7,s1,1
8000130a:	000c1463          	bnez	s8,80001312 <_printk_dec_ulong+0x56>
8000130e:	07a4f263          	bgeu	s1,s10,80001372 <_printk_dec_ulong+0xb6>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001312:	85de                	mv	a1,s7
80001314:	856a                	mv	a0,s10
80001316:	d32ff0ef          	jal	ra,80000848 <__udivsi3>
8000131a:	85d2                	mv	a1,s4
8000131c:	03050513          	addi	a0,a0,48
80001320:	9982                	jalr	s3
			digits++;
80001322:	0905                	addi	s2,s2,1
			found_largest_digit = 1;
80001324:	4c05                	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80001326:	85de                	mv	a1,s7
80001328:	856a                	mv	a0,s10
8000132a:	d66ff0ef          	jal	ra,80000890 <__umodsi3>
8000132e:	8d2a                	mv	s10,a0
		pos /= 10;
80001330:	45a9                	li	a1,10
80001332:	8526                	mv	a0,s1
80001334:	d14ff0ef          	jal	ra,80000848 <__udivsi3>
		remaining--;
80001338:	1afd                	addi	s5,s5,-1
	while (pos >= 9) {
8000133a:	4785                	li	a5,1
		pos /= 10;
8000133c:	84aa                	mv	s1,a0
	while (pos >= 9) {
8000133e:	fcfa94e3          	bne	s5,a5,80001306 <_printk_dec_ulong+0x4a>
	}
	out((int)(remainder + 48), ctx);
80001342:	85d2                	mv	a1,s4
80001344:	030d0513          	addi	a0,s10,48
80001348:	9982                	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
8000134a:	478d                	li	a5,3
		remaining = min_width - digits;
8000134c:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001350:	02fb0f63          	beq	s6,a5,8000138e <_printk_dec_ulong+0xd2>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001354:	50f2                	lw	ra,60(sp)
80001356:	5462                	lw	s0,56(sp)
80001358:	54d2                	lw	s1,52(sp)
8000135a:	5942                	lw	s2,48(sp)
8000135c:	59b2                	lw	s3,44(sp)
8000135e:	5a22                	lw	s4,40(sp)
80001360:	5a92                	lw	s5,36(sp)
80001362:	5b02                	lw	s6,32(sp)
80001364:	4bf2                	lw	s7,28(sp)
80001366:	4c62                	lw	s8,24(sp)
80001368:	4cd2                	lw	s9,20(sp)
8000136a:	4d42                	lw	s10,16(sp)
8000136c:	4db2                	lw	s11,12(sp)
8000136e:	6121                	addi	sp,sp,64
80001370:	8082                	ret
		} else if (remaining <= min_width
80001372:	fb544ae3          	blt	s0,s5,80001326 <_printk_dec_ulong+0x6a>
				&& padding < PAD_SPACE_AFTER) {
80001376:	fb6de8e3          	bltu	s11,s6,80001326 <_printk_dec_ulong+0x6a>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
8000137a:	85d2                	mv	a1,s4
8000137c:	8566                	mv	a0,s9
8000137e:	9982                	jalr	s3
			digits++;
80001380:	0905                	addi	s2,s2,1
80001382:	b755                	j	80001326 <_printk_dec_ulong+0x6a>
			out(' ', ctx);
80001384:	85d2                	mv	a1,s4
80001386:	02000513          	li	a0,32
8000138a:	9982                	jalr	s3
8000138c:	147d                	addi	s0,s0,-1
		while (remaining-- > 0) {
8000138e:	fe804be3          	bgtz	s0,80001384 <_printk_dec_ulong+0xc8>
80001392:	b7c9                	j	80001354 <_printk_dec_ulong+0x98>

80001394 <__printk_hook_install>:
	_char_out = fn;
80001394:	800057b7          	lui	a5,0x80005
80001398:	d0a7a023          	sw	a0,-768(a5) # 80004d00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d01>
}
8000139c:	8082                	ret

8000139e <z_vprintk>:
{
8000139e:	715d                	addi	sp,sp,-80
800013a0:	c4a2                	sw	s0,72(sp)
800013a2:	c2a6                	sw	s1,68(sp)
800013a4:	c0ca                	sw	s2,64(sp)
800013a6:	de4e                	sw	s3,60(sp)
800013a8:	dc52                	sw	s4,56(sp)
800013aa:	da56                	sw	s5,52(sp)
800013ac:	d266                	sw	s9,36(sp)
800013ae:	d06a                	sw	s10,32(sp)
800013b0:	ce6e                	sw	s11,28(sp)
800013b2:	c686                	sw	ra,76(sp)
800013b4:	d85a                	sw	s6,48(sp)
800013b6:	d65e                	sw	s7,44(sp)
800013b8:	d462                	sw	s8,40(sp)
800013ba:	842a                	mv	s0,a0
800013bc:	84ae                	mv	s1,a1
800013be:	8ab2                	mv	s5,a2
800013c0:	8d36                	mv	s10,a3
	int long_ctr = 0;
800013c2:	4a01                	li	s4,0
	int min_width = -1;
800013c4:	597d                	li	s2,-1
	enum pad_type padding = PAD_NONE;
800013c6:	4981                	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800013c8:	4c81                	li	s9,0
					if (lld > INT32_MAX ||
800013ca:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800013ce:	000ac503          	lbu	a0,0(s5)
800013d2:	e105                	bnez	a0,800013f2 <z_vprintk+0x54>
}
800013d4:	40b6                	lw	ra,76(sp)
800013d6:	4426                	lw	s0,72(sp)
800013d8:	4496                	lw	s1,68(sp)
800013da:	4906                	lw	s2,64(sp)
800013dc:	59f2                	lw	s3,60(sp)
800013de:	5a62                	lw	s4,56(sp)
800013e0:	5ad2                	lw	s5,52(sp)
800013e2:	5b42                	lw	s6,48(sp)
800013e4:	5bb2                	lw	s7,44(sp)
800013e6:	5c22                	lw	s8,40(sp)
800013e8:	5c92                	lw	s9,36(sp)
800013ea:	5d02                	lw	s10,32(sp)
800013ec:	4df2                	lw	s11,28(sp)
800013ee:	6161                	addi	sp,sp,80
800013f0:	8082                	ret
		if (!might_format) {
800013f2:	000c9a63          	bnez	s9,80001406 <z_vprintk+0x68>
			if (*fmt != '%') {
800013f6:	02500693          	li	a3,37
800013fa:	28d50563          	beq	a0,a3,80001684 <z_vprintk+0x2e6>
				out((int)*fmt, ctx);
800013fe:	85a6                	mv	a1,s1
80001400:	9402                	jalr	s0
		++fmt;
80001402:	0a85                	addi	s5,s5,1
80001404:	b7e9                	j	800013ce <z_vprintk+0x30>
			switch (*fmt) {
80001406:	06400693          	li	a3,100
8000140a:	0ed50b63          	beq	a0,a3,80001500 <z_vprintk+0x162>
8000140e:	04a6eb63          	bltu	a3,a0,80001464 <z_vprintk+0xc6>
80001412:	03900693          	li	a3,57
80001416:	02a6e763          	bltu	a3,a0,80001444 <z_vprintk+0xa6>
8000141a:	03100693          	li	a3,49
8000141e:	0cd57563          	bgeu	a0,a3,800014e8 <z_vprintk+0x14a>
80001422:	02d00693          	li	a3,45
80001426:	26d50463          	beq	a0,a3,8000168e <z_vprintk+0x2f0>
8000142a:	03000793          	li	a5,48
8000142e:	0af50363          	beq	a0,a5,800014d4 <z_vprintk+0x136>
80001432:	02500713          	li	a4,37
80001436:	00e51f63          	bne	a0,a4,80001454 <z_vprintk+0xb6>
				out((int)'%', ctx);
8000143a:	85a6                	mv	a1,s1
8000143c:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001440:	9402                	jalr	s0
				break;
80001442:	aa09                	j	80001554 <z_vprintk+0x1b6>
80001444:	05800693          	li	a3,88
80001448:	14d50b63          	beq	a0,a3,8000159e <z_vprintk+0x200>
8000144c:	06300713          	li	a4,99
80001450:	22e50363          	beq	a0,a4,80001676 <z_vprintk+0x2d8>
				out((int)'%', ctx);
80001454:	85a6                	mv	a1,s1
80001456:	02500513          	li	a0,37
8000145a:	9402                	jalr	s0
				out((int)*fmt, ctx);
8000145c:	85a6                	mv	a1,s1
8000145e:	000ac503          	lbu	a0,0(s5)
80001462:	bff9                	j	80001440 <z_vprintk+0xa2>
80001464:	07000693          	li	a3,112
80001468:	12d50163          	beq	a0,a3,8000158a <z_vprintk+0x1ec>
8000146c:	00a6ef63          	bltu	a3,a0,8000148a <z_vprintk+0xec>
80001470:	06900693          	li	a3,105
80001474:	08d50663          	beq	a0,a3,80001500 <z_vprintk+0x162>
80001478:	06c00693          	li	a3,108
8000147c:	08d50063          	beq	a0,a3,800014fc <z_vprintk+0x15e>
80001480:	06800693          	li	a3,104
80001484:	f6d50fe3          	beq	a0,a3,80001402 <z_vprintk+0x64>
80001488:	b7f1                	j	80001454 <z_vprintk+0xb6>
8000148a:	07500693          	li	a3,117
8000148e:	0cd50563          	beq	a0,a3,80001558 <z_vprintk+0x1ba>
80001492:	02a6ea63          	bltu	a3,a0,800014c6 <z_vprintk+0x128>
80001496:	07300713          	li	a4,115
8000149a:	fae51de3          	bne	a0,a4,80001454 <z_vprintk+0xb6>
				char *s = va_arg(ap, char *);
8000149e:	000d2c03          	lw	s8,0(s10)
800014a2:	004d0b13          	addi	s6,s10,4
800014a6:	8be2                	mv	s7,s8
				while (*s)
800014a8:	000bc503          	lbu	a0,0(s7)
800014ac:	1a051b63          	bnez	a0,80001662 <z_vprintk+0x2c4>
				if (padding == PAD_SPACE_AFTER) {
800014b0:	478d                	li	a5,3
800014b2:	00f99863          	bne	s3,a5,800014c2 <z_vprintk+0x124>
					int remaining = min_width - (s - start);
800014b6:	418b8bb3          	sub	s7,s7,s8
800014ba:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800014be:	1b704663          	bgtz	s7,8000166a <z_vprintk+0x2cc>
				char *s = va_arg(ap, char *);
800014c2:	8d5a                	mv	s10,s6
800014c4:	a841                	j	80001554 <z_vprintk+0x1b6>
800014c6:	07800693          	li	a3,120
800014ca:	0cd50a63          	beq	a0,a3,8000159e <z_vprintk+0x200>
800014ce:	07a00693          	li	a3,122
800014d2:	bf4d                	j	80001484 <z_vprintk+0xe6>
				if (min_width < 0 && padding == PAD_NONE) {
800014d4:	00095c63          	bgez	s2,800014ec <z_vprintk+0x14e>
800014d8:	1a098d63          	beqz	s3,80001692 <z_vprintk+0x2f4>
					min_width = *fmt - '0';
800014dc:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
800014e0:	f20991e3          	bnez	s3,80001402 <z_vprintk+0x64>
					padding = PAD_SPACE_BEFORE;
800014e4:	4989                	li	s3,2
800014e6:	bf31                	j	80001402 <z_vprintk+0x64>
				if (min_width < 0) {
800014e8:	fe094ae3          	bltz	s2,800014dc <z_vprintk+0x13e>
					min_width = 10 * min_width + *fmt - '0';
800014ec:	00291693          	slli	a3,s2,0x2
800014f0:	9936                	add	s2,s2,a3
800014f2:	0906                	slli	s2,s2,0x1
800014f4:	fd090913          	addi	s2,s2,-48
800014f8:	992a                	add	s2,s2,a0
800014fa:	b7dd                	j	800014e0 <z_vprintk+0x142>
				long_ctr++;
800014fc:	0a05                	addi	s4,s4,1
800014fe:	b711                	j	80001402 <z_vprintk+0x64>
				if (long_ctr == 0) {
80001500:	020a1663          	bnez	s4,8000152c <z_vprintk+0x18e>
					long ld = va_arg(ap, long);
80001504:	000d2603          	lw	a2,0(s10)
80001508:	0d11                	addi	s10,s10,4
				if (d < 0) {
8000150a:	00065b63          	bgez	a2,80001520 <z_vprintk+0x182>
					out((int)'-', ctx);
8000150e:	85a6                	mv	a1,s1
80001510:	02d00513          	li	a0,45
80001514:	c032                	sw	a2,0(sp)
80001516:	9402                	jalr	s0
					d = -d;
80001518:	4602                	lw	a2,0(sp)
					min_width--;
8000151a:	197d                	addi	s2,s2,-1
					d = -d;
8000151c:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001520:	874a                	mv	a4,s2
80001522:	86ce                	mv	a3,s3
80001524:	85a6                	mv	a1,s1
80001526:	8522                	mv	a0,s0
80001528:	3b51                	jal	800012bc <_printk_dec_ulong>
				break;
8000152a:	a02d                	j	80001554 <z_vprintk+0x1b6>
				} else if (long_ctr == 1) {
8000152c:	4705                	li	a4,1
8000152e:	fcea0be3          	beq	s4,a4,80001504 <z_vprintk+0x166>
					long long lld = va_arg(ap, long long);
80001532:	007d0793          	addi	a5,s10,7
80001536:	ff87f713          	andi	a4,a5,-8
8000153a:	4310                	lw	a2,0(a4)
8000153c:	4354                	lw	a3,4(a4)
8000153e:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001542:	01b60733          	add	a4,a2,s11
80001546:	00c73733          	sltu	a4,a4,a2
8000154a:	9736                	add	a4,a4,a3
8000154c:	df5d                	beqz	a4,8000150a <z_vprintk+0x16c>
						print_err(out, ctx);
8000154e:	85a6                	mv	a1,s1
80001550:	8522                	mv	a0,s0
80001552:	333d                	jal	80001280 <print_err>
			might_format = 0;
80001554:	4c81                	li	s9,0
80001556:	b575                	j	80001402 <z_vprintk+0x64>
				if (long_ctr == 0) {
80001558:	000a1663          	bnez	s4,80001564 <z_vprintk+0x1c6>
					long lu = va_arg(ap, unsigned long);
8000155c:	000d2603          	lw	a2,0(s10)
80001560:	0d11                	addi	s10,s10,4
80001562:	bf7d                	j	80001520 <z_vprintk+0x182>
				} else if (long_ctr == 1) {
80001564:	4705                	li	a4,1
80001566:	feea0be3          	beq	s4,a4,8000155c <z_vprintk+0x1be>
					unsigned long long llu =
8000156a:	007d0793          	addi	a5,s10,7
8000156e:	ff87f713          	andi	a4,a5,-8
80001572:	00870d13          	addi	s10,a4,8
80001576:	4310                	lw	a2,0(a4)
80001578:	4358                	lw	a4,4(a4)
					if (llu > INT32_MAX) {
8000157a:	fb71                	bnez	a4,8000154e <z_vprintk+0x1b0>
8000157c:	800007b7          	lui	a5,0x80000
80001580:	fff7c793          	not	a5,a5
80001584:	f8c7fee3          	bgeu	a5,a2,80001520 <z_vprintk+0x182>
80001588:	b7d9                	j	8000154e <z_vprintk+0x1b0>
				  out('0', ctx);
8000158a:	85a6                	mv	a1,s1
8000158c:	03000513          	li	a0,48
80001590:	9402                	jalr	s0
				  out('x', ctx);
80001592:	85a6                	mv	a1,s1
80001594:	07800513          	li	a0,120
80001598:	9402                	jalr	s0
				  min_width = 8;
8000159a:	4921                	li	s2,8
				  padding = PAD_ZERO_BEFORE;
8000159c:	4985                	li	s3,1
				if (long_ctr < 2) {
8000159e:	4685                	li	a3,1
800015a0:	0746c663          	blt	a3,s4,8000160c <z_vprintk+0x26e>
					x = va_arg(ap, unsigned long);
800015a4:	000d2783          	lw	a5,0(s10)
800015a8:	c402                	sw	zero,8(sp)
800015aa:	0d11                	addi	s10,s10,4
800015ac:	c23e                	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
800015ae:	4c41                	li	s8,16
	int digits = 0;
800015b0:	4b81                	li	s7,0
	int found_largest_digit = 0;
800015b2:	c002                	sw	zero,0(sp)
	int size = sizeof(num) * 2;
800015b4:	48c1                	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800015b6:	4512                	lw	a0,4(sp)
800015b8:	45a2                	lw	a1,8(sp)
800015ba:	fff88b13          	addi	s6,a7,-1
800015be:	002b1613          	slli	a2,s6,0x2
800015c2:	c646                	sw	a7,12(sp)
800015c4:	c4dfe0ef          	jal	ra,80000210 <__lshrdi3>
800015c8:	893d                	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800015ca:	ed39                	bnez	a0,80001628 <z_vprintk+0x28a>
800015cc:	4782                	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
800015ce:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800015d2:	e789                	bnez	a5,800015dc <z_vprintk+0x23e>
800015d4:	48b2                	lw	a7,12(sp)
800015d6:	4785                	li	a5,1
800015d8:	06f89063          	bne	a7,a5,80001638 <z_vprintk+0x29a>
			nibble += nibble > 9 ? 87 : 48;
800015dc:	9536                	add	a0,a0,a3
			out((int)nibble, ctx);
800015de:	0562                	slli	a0,a0,0x18
800015e0:	85a6                	mv	a1,s1
800015e2:	8561                	srai	a0,a0,0x18
800015e4:	9402                	jalr	s0
			digits++;
800015e6:	0b85                	addi	s7,s7,1
	for (; size != 0; size--) {
800015e8:	020b1d63          	bnez	s6,80001622 <z_vprintk+0x284>
	if (padding == PAD_SPACE_AFTER) {
800015ec:	468d                	li	a3,3
			might_format = 0;
800015ee:	4c81                	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800015f0:	e0d999e3          	bne	s3,a3,80001402 <z_vprintk+0x64>
		remaining = min_width * 2 - digits;
800015f4:	00191713          	slli	a4,s2,0x1
800015f8:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
800015fc:	f5705ce3          	blez	s7,80001554 <z_vprintk+0x1b6>
			out(' ', ctx);
80001600:	85a6                	mv	a1,s1
80001602:	02000513          	li	a0,32
80001606:	9402                	jalr	s0
80001608:	1bfd                	addi	s7,s7,-1
8000160a:	bfcd                	j	800015fc <z_vprintk+0x25e>
					x = va_arg(ap, unsigned long long);
8000160c:	007d0793          	addi	a5,s10,7
80001610:	ff87f693          	andi	a3,a5,-8
80001614:	429c                	lw	a5,0(a3)
80001616:	00868d13          	addi	s10,a3,8
8000161a:	c23e                	sw	a5,4(sp)
8000161c:	42dc                	lw	a5,4(a3)
8000161e:	c43e                	sw	a5,8(sp)
80001620:	b779                	j	800015ae <z_vprintk+0x210>
			found_largest_digit = 1;
80001622:	c066                	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001624:	88da                	mv	a7,s6
80001626:	bf41                	j	800015b6 <z_vprintk+0x218>
			nibble += nibble > 9 ? 87 : 48;
80001628:	47a5                	li	a5,9
8000162a:	05700693          	li	a3,87
8000162e:	faa7e7e3          	bltu	a5,a0,800015dc <z_vprintk+0x23e>
80001632:	03000693          	li	a3,48
80001636:	b75d                	j	800015dc <z_vprintk+0x23e>
		if (remaining-- <= min_width) {
80001638:	fffc0793          	addi	a5,s8,-1
8000163c:	c63e                	sw	a5,12(sp)
8000163e:	01894963          	blt	s2,s8,80001650 <z_vprintk+0x2b2>
			if (padding == PAD_ZERO_BEFORE) {
80001642:	4785                	li	a5,1
80001644:	00f99863          	bne	s3,a5,80001654 <z_vprintk+0x2b6>
				out('0', ctx);
80001648:	85a6                	mv	a1,s1
8000164a:	03000513          	li	a0,48
				out(' ', ctx);
8000164e:	9402                	jalr	s0
					x = va_arg(ap, unsigned long);
80001650:	4c32                	lw	s8,12(sp)
80001652:	bfc9                	j	80001624 <z_vprintk+0x286>
			} else if (padding == PAD_SPACE_BEFORE) {
80001654:	4789                	li	a5,2
80001656:	fef99de3          	bne	s3,a5,80001650 <z_vprintk+0x2b2>
				out(' ', ctx);
8000165a:	85a6                	mv	a1,s1
8000165c:	02000513          	li	a0,32
80001660:	b7fd                	j	8000164e <z_vprintk+0x2b0>
					out((int)(*s++), ctx);
80001662:	85a6                	mv	a1,s1
80001664:	0b85                	addi	s7,s7,1
80001666:	9402                	jalr	s0
80001668:	b581                	j	800014a8 <z_vprintk+0x10a>
						out(' ', ctx);
8000166a:	85a6                	mv	a1,s1
8000166c:	02000513          	li	a0,32
80001670:	9402                	jalr	s0
80001672:	1bfd                	addi	s7,s7,-1
80001674:	b5a9                	j	800014be <z_vprintk+0x120>
				out(c, ctx);
80001676:	000d2503          	lw	a0,0(s10)
8000167a:	85a6                	mv	a1,s1
				int c = va_arg(ap, int);
8000167c:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001680:	9402                	jalr	s0
				break;
80001682:	b581                	j	800014c2 <z_vprintk+0x124>
				long_ctr = 0;
80001684:	4a01                	li	s4,0
				min_width = -1;
80001686:	597d                	li	s2,-1
				padding = PAD_NONE;
80001688:	4981                	li	s3,0
				might_format = 1;
8000168a:	4c85                	li	s9,1
8000168c:	bb9d                	j	80001402 <z_vprintk+0x64>
				padding = PAD_SPACE_AFTER;
8000168e:	498d                	li	s3,3
80001690:	bb8d                	j	80001402 <z_vprintk+0x64>
					padding = PAD_ZERO_BEFORE;
80001692:	4985                	li	s3,1
80001694:	b3bd                	j	80001402 <z_vprintk+0x64>

80001696 <vprintk>:
{
80001696:	1101                	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001698:	862a                	mv	a2,a0
8000169a:	80001537          	lui	a0,0x80001
8000169e:	86ae                	mv	a3,a1
800016a0:	2ac50513          	addi	a0,a0,684 # 800012ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800012ad>
800016a4:	006c                	addi	a1,sp,12
{
800016a6:	ce06                	sw	ra,28(sp)
	struct out_context ctx = { 0 };
800016a8:	c602                	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
800016aa:	39d5                	jal	8000139e <z_vprintk>
}
800016ac:	40f2                	lw	ra,28(sp)
800016ae:	6105                	addi	sp,sp,32
800016b0:	8082                	ret

800016b2 <printk>:
{
800016b2:	7139                	addi	sp,sp,-64
800016b4:	d22e                	sw	a1,36(sp)
	va_start(ap, fmt);
800016b6:	104c                	addi	a1,sp,36
{
800016b8:	ce06                	sw	ra,28(sp)
800016ba:	d432                	sw	a2,40(sp)
800016bc:	d636                	sw	a3,44(sp)
800016be:	d83a                	sw	a4,48(sp)
800016c0:	da3e                	sw	a5,52(sp)
800016c2:	dc42                	sw	a6,56(sp)
800016c4:	de46                	sw	a7,60(sp)
	va_start(ap, fmt);
800016c6:	c62e                	sw	a1,12(sp)
		vprintk(fmt, ap);
800016c8:	37f9                	jal	80001696 <vprintk>
}
800016ca:	40f2                	lw	ra,28(sp)
800016cc:	6121                	addi	sp,sp,64
800016ce:	8082                	ret

800016d0 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
800016d0:	800045b7          	lui	a1,0x80004
800016d4:	80005537          	lui	a0,0x80005
{
800016d8:	1141                	addi	sp,sp,-16
  k_panic();
800016da:	7fc58593          	addi	a1,a1,2044 # 800047fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047fd>
800016de:	81050513          	addi	a0,a0,-2032 # 80004810 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004811>
800016e2:	4679                	li	a2,30
{
800016e4:	c606                	sw	ra,12(sp)
  k_panic();
800016e6:	37f1                	jal	800016b2 <printk>
800016e8:	800045b7          	lui	a1,0x80004
800016ec:	3dc58593          	addi	a1,a1,988 # 800043dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800043dd>
800016f0:	4519                	li	a0,6
800016f2:	bfaff0ef          	jal	ra,80000aec <z_NanoFatalErrorHandler>

800016f6 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800016f6:	8082                	ret

800016f8 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
800016f8:	47a1                	li	a5,8
800016fa:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
800016fe:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001702:	8082                	ret

80001704 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001704:	4785                	li	a5,1
80001706:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
8000170a:	30452573          	csrrs	a0,mie,a0
}
8000170e:	8082                	ret

80001710 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001710:	47a1                	li	a5,8
80001712:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001716:	30405073          	csrwi	mie,0
8000171a:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
8000171e:	8082                	ret

80001720 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001720:	1141                	addi	sp,sp,-16
80001722:	c422                	sw	s0,8(sp)
80001724:	c226                	sw	s1,4(sp)
80001726:	80005437          	lui	s0,0x80005
8000172a:	c606                	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
8000172c:	47a9                	li	a5,10
{
8000172e:	84aa                	mv	s1,a0
80001730:	dbc40413          	addi	s0,s0,-580 # 80004dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dbd>
	if ('\n' == c) {
80001734:	00f51763          	bne	a0,a5,80001742 <console_out+0x22>
80001738:	4008                	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
8000173a:	45b5                	li	a1,13
8000173c:	415c                	lw	a5,4(a0)
8000173e:	43dc                	lw	a5,4(a5)
80001740:	9782                	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001742:	4008                	lw	a0,0(s0)
80001744:	0ff4f593          	andi	a1,s1,255
80001748:	415c                	lw	a5,4(a0)
8000174a:	43dc                	lw	a5,4(a5)
8000174c:	9782                	jalr	a5

	return c;
}
8000174e:	40b2                	lw	ra,12(sp)
80001750:	4422                	lw	s0,8(sp)
80001752:	8526                	mv	a0,s1
80001754:	4492                	lw	s1,4(sp)
80001756:	0141                	addi	sp,sp,16
80001758:	8082                	ret

8000175a <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
8000175a:	1141                	addi	sp,sp,-16
8000175c:	c422                	sw	s0,8(sp)
	__stdout_hook_install(console_out);
8000175e:	80001437          	lui	s0,0x80001
80001762:	72040513          	addi	a0,s0,1824 # 80001720 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001721>
{
80001766:	c606                	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001768:	2ef5                	jal	80001b64 <__stdout_hook_install>
	__printk_hook_install(console_out);
8000176a:	72040513          	addi	a0,s0,1824
}
8000176e:	4422                	lw	s0,8(sp)
80001770:	40b2                	lw	ra,12(sp)
80001772:	0141                	addi	sp,sp,16
	__printk_hook_install(console_out);
80001774:	b105                	j	80001394 <__printk_hook_install>

80001776 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001776:	80005537          	lui	a0,0x80005
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
8000177a:	1141                	addi	sp,sp,-16
8000177c:	81c50513          	addi	a0,a0,-2020 # 8000481c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000481d>
80001780:	c606                	sw	ra,12(sp)
80001782:	2d99                	jal	80001dd8 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001784:	800057b7          	lui	a5,0x80005
80001788:	daa7ae23          	sw	a0,-580(a5) # 80004dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dbd>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
8000178c:	37f9                	jal	8000175a <uart_console_hook_install>

	return 0;
}
8000178e:	40b2                	lw	ra,12(sp)
80001790:	4501                	li	a0,0
80001792:	0141                	addi	sp,sp,16
80001794:	8082                	ret

80001796 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001796:	f01007b7          	lui	a5,0xf0100
8000179a:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
8000179e:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
800017a2:	f447a583          	lw	a1,-188(a5)
800017a6:	fee59ae3          	bne	a1,a4,8000179a <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
800017aa:	8082                	ret

800017ac <timer_isr>:

static void timer_isr(void *arg)
{
800017ac:	1101                	addi	sp,sp,-32
800017ae:	cc22                	sw	s0,24(sp)
800017b0:	ce06                	sw	ra,28(sp)
800017b2:	ca26                	sw	s1,20(sp)
800017b4:	c84a                	sw	s2,16(sp)
800017b6:	c64e                	sw	s3,12(sp)
800017b8:	c452                	sw	s4,8(sp)
800017ba:	c256                	sw	s5,4(sp)
800017bc:	4421                	li	s0,8
800017be:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800017c2:	80005937          	lui	s2,0x80005
800017c6:	dc090513          	addi	a0,s2,-576 # 80004dc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dc1>
	key = (mstatus & SOC_MSTATUS_IEN);
800017ca:	8821                	andi	s0,s0,8
800017cc:	58d010ef          	jal	ra,80003558 <z_spin_lock_valid>
800017d0:	e915                	bnez	a0,80001804 <timer_isr+0x58>
800017d2:	800054b7          	lui	s1,0x80005
800017d6:	800055b7          	lui	a1,0x80005
800017da:	80004537          	lui	a0,0x80004
800017de:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800017e2:	04e00693          	li	a3,78
800017e6:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800017ea:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800017ee:	35d1                	jal	800016b2 <printk>
800017f0:	80005537          	lui	a0,0x80005
800017f4:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
800017f8:	3d6d                	jal	800016b2 <printk>
800017fa:	04e00593          	li	a1,78
800017fe:	83048513          	addi	a0,s1,-2000
80001802:	35f9                	jal	800016d0 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001804:	dc090513          	addi	a0,s2,-576
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001808:	800054b7          	lui	s1,0x80005
8000180c:	589010ef          	jal	ra,80003594 <z_spin_lock_set_owner>
80001810:	da048493          	addi	s1,s1,-608 # 80004da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da1>
	u64_t now = mtime();
80001814:	3749                	jal	80001796 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001816:	0004a983          	lw	s3,0(s1)
8000181a:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
8000181e:	87aa                	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001820:	41350533          	sub	a0,a0,s3
80001824:	00a7b7b3          	sltu	a5,a5,a0
80001828:	415585b3          	sub	a1,a1,s5
8000182c:	6675                	lui	a2,0x1d
8000182e:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001832:	4681                	li	a3,0
80001834:	8d9d                	sub	a1,a1,a5
80001836:	a13fe0ef          	jal	ra,80000248 <__udivdi3>
8000183a:	8a2a                	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
8000183c:	65f5                	lui	a1,0x1d
8000183e:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001842:	8552                	mv	a0,s4
80001844:	fd9fe0ef          	jal	ra,8000081c <__mulsi3>
80001848:	99aa                	add	s3,s3,a0
8000184a:	00a9b533          	sltu	a0,s3,a0
8000184e:	9556                	add	a0,a0,s5
80001850:	c0c8                	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001852:	dc090513          	addi	a0,s2,-576
80001856:	0134a023          	sw	s3,0(s1)
8000185a:	519010ef          	jal	ra,80003572 <z_spin_unlock_valid>
8000185e:	e915                	bnez	a0,80001892 <timer_isr+0xe6>
80001860:	800054b7          	lui	s1,0x80005
80001864:	800055b7          	lui	a1,0x80005
80001868:	80004537          	lui	a0,0x80004
8000186c:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80001870:	06100693          	li	a3,97
80001874:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80001878:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000187c:	3d1d                	jal	800016b2 <printk>
8000187e:	80005537          	lui	a0,0x80005
80001882:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80001886:	3535                	jal	800016b2 <printk>
80001888:	06100593          	li	a1,97
8000188c:	83048513          	addi	a0,s1,-2000
80001890:	3581                	jal	800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001892:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80001896:	4462                	lw	s0,24(sp)
80001898:	40f2                	lw	ra,28(sp)
8000189a:	44d2                	lw	s1,20(sp)
8000189c:	4942                	lw	s2,16(sp)
8000189e:	49b2                	lw	s3,12(sp)
800018a0:	4a92                	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800018a2:	8552                	mv	a0,s4
}
800018a4:	4a22                	lw	s4,8(sp)
800018a6:	6105                	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800018a8:	49e0206f          	j	80003d46 <z_clock_announce>

800018ac <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
800018ac:	1141                	addi	sp,sp,-16
800018ae:	c606                	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
800018b0:	35dd                	jal	80001796 <mtime>
800018b2:	67f5                	lui	a5,0x1d
800018b4:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
800018b8:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
800018bc:	97aa                	add	a5,a5,a0
	r[1] = 0xffffffff;
800018be:	56fd                	li	a3,-1
800018c0:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
800018c4:	00a7b533          	sltu	a0,a5,a0
800018c8:	952e                	add	a0,a0,a1
	r[0] = (u32_t)time;
800018ca:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
800018ce:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
800018d2:	451d                	li	a0,7
800018d4:	3d05                	jal	80001704 <z_arch_irq_enable>
	return 0;
}
800018d6:	40b2                	lw	ra,12(sp)
800018d8:	4501                	li	a0,0
800018da:	0141                	addi	sp,sp,16
800018dc:	8082                	ret

800018de <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
800018de:	14059563          	bnez	a1,80001a28 <z_clock_set_timeout+0x14a>
{
800018e2:	1101                	addi	sp,sp,-32
800018e4:	ce06                	sw	ra,28(sp)
800018e6:	cc22                	sw	s0,24(sp)
800018e8:	ca26                	sw	s1,20(sp)
800018ea:	c84a                	sw	s2,16(sp)
800018ec:	c64e                	sw	s3,12(sp)
800018ee:	c452                	sw	s4,8(sp)
800018f0:	c256                	sw	s5,4(sp)
800018f2:	c05a                	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
800018f4:	57fd                	li	a5,-1
800018f6:	00f51563          	bne	a0,a5,80001900 <z_clock_set_timeout+0x22>
800018fa:	6525                	lui	a0,0x9
800018fc:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80001900:	67a5                	lui	a5,0x9
80001902:	fff50413          	addi	s0,a0,-1
80001906:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
8000190a:	1087db63          	bge	a5,s0,80001a20 <z_clock_set_timeout+0x142>
8000190e:	843e                	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001910:	4921                	li	s2,8
80001912:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001916:	80005ab7          	lui	s5,0x80005
8000191a:	dc0a8513          	addi	a0,s5,-576 # 80004dc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dc1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000191e:	00897913          	andi	s2,s2,8
80001922:	437010ef          	jal	ra,80003558 <z_spin_lock_valid>
80001926:	e915                	bnez	a0,8000195a <z_clock_set_timeout+0x7c>
80001928:	800054b7          	lui	s1,0x80005
8000192c:	800055b7          	lui	a1,0x80005
80001930:	80004537          	lui	a0,0x80004
80001934:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80001938:	04e00693          	li	a3,78
8000193c:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80001940:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80001944:	33bd                	jal	800016b2 <printk>
80001946:	80005537          	lui	a0,0x80005
8000194a:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
8000194e:	3395                	jal	800016b2 <printk>
80001950:	04e00593          	li	a1,78
80001954:	83048513          	addi	a0,s1,-2000
80001958:	3ba5                	jal	800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
8000195a:	dc0a8513          	addi	a0,s5,-576
8000195e:	437010ef          	jal	ra,80003594 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80001962:	3d15                	jal	80001796 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001964:	800057b7          	lui	a5,0x80005
80001968:	da078793          	addi	a5,a5,-608 # 80004da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da1>
	u32_t cyc = ticks * CYC_PER_TICK;
8000196c:	64f5                	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000196e:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80001972:	8a2a                	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80001974:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001978:	8522                	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000197a:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
8000197e:	e9ffe0ef          	jal	ra,8000081c <__mulsi3>
80001982:	4bf48793          	addi	a5,s1,1215
80001986:	413787b3          	sub	a5,a5,s3
8000198a:	953e                	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
8000198c:	4c048593          	addi	a1,s1,1216
80001990:	9552                	add	a0,a0,s4
80001992:	eb7fe0ef          	jal	ra,80000848 <__udivsi3>
80001996:	4c048593          	addi	a1,s1,1216
8000199a:	e83fe0ef          	jal	ra,8000081c <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
8000199e:	41498a33          	sub	s4,s3,s4
800019a2:	9a2a                	add	s4,s4,a0
800019a4:	3e700793          	li	a5,999
800019a8:	0147c563          	blt	a5,s4,800019b2 <z_clock_set_timeout+0xd4>
		cyc += CYC_PER_TICK;
800019ac:	4c048493          	addi	s1,s1,1216
800019b0:	9526                	add	a0,a0,s1
	r[1] = 0xffffffff;
800019b2:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
800019b6:	99aa                	add	s3,s3,a0
	r[1] = 0xffffffff;
800019b8:	577d                	li	a4,-1
800019ba:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
800019be:	00a9b533          	sltu	a0,s3,a0
800019c2:	955a                	add	a0,a0,s6
	r[0] = (u32_t)time;
800019c4:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
800019c8:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800019cc:	dc0a8513          	addi	a0,s5,-576
800019d0:	3a3010ef          	jal	ra,80003572 <z_spin_unlock_valid>
800019d4:	e915                	bnez	a0,80001a08 <z_clock_set_timeout+0x12a>
800019d6:	80005437          	lui	s0,0x80005
800019da:	800055b7          	lui	a1,0x80005
800019de:	80004537          	lui	a0,0x80004
800019e2:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
800019e6:	06100693          	li	a3,97
800019ea:	83040613          	addi	a2,s0,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800019ee:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800019f2:	31c1                	jal	800016b2 <printk>
800019f4:	80005537          	lui	a0,0x80005
800019f8:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
800019fc:	395d                	jal	800016b2 <printk>
800019fe:	06100593          	li	a1,97
80001a02:	83040513          	addi	a0,s0,-2000
80001a06:	31e9                	jal	800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001a08:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80001a0c:	40f2                	lw	ra,28(sp)
80001a0e:	4462                	lw	s0,24(sp)
80001a10:	44d2                	lw	s1,20(sp)
80001a12:	4942                	lw	s2,16(sp)
80001a14:	49b2                	lw	s3,12(sp)
80001a16:	4a22                	lw	s4,8(sp)
80001a18:	4a92                	lw	s5,4(sp)
80001a1a:	4b02                	lw	s6,0(sp)
80001a1c:	6105                	addi	sp,sp,32
80001a1e:	8082                	ret
80001a20:	ee0458e3          	bgez	s0,80001910 <z_clock_set_timeout+0x32>
80001a24:	4401                	li	s0,0
80001a26:	b5ed                	j	80001910 <z_clock_set_timeout+0x32>
80001a28:	8082                	ret

80001a2a <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80001a2a:	1141                	addi	sp,sp,-16
80001a2c:	c422                	sw	s0,8(sp)
80001a2e:	c606                	sw	ra,12(sp)
80001a30:	c226                	sw	s1,4(sp)
80001a32:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001a34:	4421                	li	s0,8
80001a36:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001a3a:	800054b7          	lui	s1,0x80005
80001a3e:	dc048513          	addi	a0,s1,-576 # 80004dc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dc1>
	key = (mstatus & SOC_MSTATUS_IEN);
80001a42:	8821                	andi	s0,s0,8
80001a44:	315010ef          	jal	ra,80003558 <z_spin_lock_valid>
80001a48:	e915                	bnez	a0,80001a7c <z_clock_elapsed+0x52>
80001a4a:	80005937          	lui	s2,0x80005
80001a4e:	800055b7          	lui	a1,0x80005
80001a52:	80004537          	lui	a0,0x80004
80001a56:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80001a5a:	04e00693          	li	a3,78
80001a5e:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80001a62:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80001a66:	31b1                	jal	800016b2 <printk>
80001a68:	80005537          	lui	a0,0x80005
80001a6c:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80001a70:	3189                	jal	800016b2 <printk>
80001a72:	04e00593          	li	a1,78
80001a76:	83090513          	addi	a0,s2,-2000
80001a7a:	3999                	jal	800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80001a7c:	dc048513          	addi	a0,s1,-576
80001a80:	315010ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80001a84:	3b09                	jal	80001796 <mtime>
80001a86:	800057b7          	lui	a5,0x80005
80001a8a:	da07a783          	lw	a5,-608(a5) # 80004da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da1>
80001a8e:	65f5                	lui	a1,0x1d
80001a90:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001a94:	8d1d                	sub	a0,a0,a5
80001a96:	db3fe0ef          	jal	ra,80000848 <__udivsi3>
80001a9a:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001a9c:	dc048513          	addi	a0,s1,-576
80001aa0:	2d3010ef          	jal	ra,80003572 <z_spin_unlock_valid>
80001aa4:	e915                	bnez	a0,80001ad8 <z_clock_elapsed+0xae>
80001aa6:	800054b7          	lui	s1,0x80005
80001aaa:	800055b7          	lui	a1,0x80005
80001aae:	80004537          	lui	a0,0x80004
80001ab2:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80001ab6:	06100693          	li	a3,97
80001aba:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80001abe:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80001ac2:	3ec5                	jal	800016b2 <printk>
80001ac4:	80005537          	lui	a0,0x80005
80001ac8:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80001acc:	36dd                	jal	800016b2 <printk>
80001ace:	06100593          	li	a1,97
80001ad2:	83048513          	addi	a0,s1,-2000
80001ad6:	3eed                	jal	800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ad8:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80001adc:	40b2                	lw	ra,12(sp)
80001ade:	4422                	lw	s0,8(sp)
80001ae0:	854a                	mv	a0,s2
80001ae2:	4492                	lw	s1,4(sp)
80001ae4:	4902                	lw	s2,0(sp)
80001ae6:	0141                	addi	sp,sp,16
80001ae8:	8082                	ret

80001aea <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80001aea:	00054783          	lbu	a5,0(a0)
80001aee:	0005c703          	lbu	a4,0(a1)
80001af2:	00e79363          	bne	a5,a4,80001af8 <strcmp+0xe>
80001af6:	e781                	bnez	a5,80001afe <strcmp+0x14>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80001af8:	40e78533          	sub	a0,a5,a4
80001afc:	8082                	ret
		s1++;
80001afe:	0505                	addi	a0,a0,1
		s2++;
80001b00:	0585                	addi	a1,a1,1
80001b02:	b7e5                	j	80001aea <strcmp>

80001b04 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80001b04:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80001b08:	87aa                	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80001b0a:	0037f713          	andi	a4,a5,3
80001b0e:	eb1d                	bnez	a4,80001b44 <memset+0x40>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80001b10:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80001b14:	00859713          	slli	a4,a1,0x8
80001b18:	8dd9                	or	a1,a1,a4
	c_word |= c_word << 16;
80001b1a:	01059713          	slli	a4,a1,0x10
80001b1e:	8dd9                	or	a1,a1,a4

	while (n >= sizeof(unsigned int)) {
80001b20:	00c78333          	add	t1,a5,a2
80001b24:	873e                	mv	a4,a5
80001b26:	480d                	li	a6,3
80001b28:	40e308b3          	sub	a7,t1,a4
80001b2c:	03186263          	bltu	a6,a7,80001b50 <memset+0x4c>
80001b30:	00265713          	srli	a4,a2,0x2
80001b34:	00271593          	slli	a1,a4,0x2
80001b38:	97ae                	add	a5,a5,a1
80001b3a:	8e0d                	sub	a2,a2,a1
80001b3c:	963e                	add	a2,a2,a5

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80001b3e:	00c79d63          	bne	a5,a2,80001b58 <memset+0x54>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80001b42:	8082                	ret
		if (n == 0) {
80001b44:	de7d                	beqz	a2,80001b42 <memset+0x3e>
		*(d_byte++) = c_byte;
80001b46:	0785                	addi	a5,a5,1
80001b48:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001b4c:	167d                	addi	a2,a2,-1
80001b4e:	bf75                	j	80001b0a <memset+0x6>
		*(d_word++) = c_word;
80001b50:	0711                	addi	a4,a4,4
80001b52:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80001b56:	bfc9                	j	80001b28 <memset+0x24>
		*(d_byte++) = c_byte;
80001b58:	0785                	addi	a5,a5,1
80001b5a:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001b5e:	b7c5                	j	80001b3e <memset+0x3a>

80001b60 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80001b60:	557d                	li	a0,-1
80001b62:	8082                	ret

80001b64 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80001b64:	800057b7          	lui	a5,0x80005
80001b68:	d0a7a223          	sw	a0,-764(a5) # 80004d04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d05>
}
80001b6c:	8082                	ret

80001b6e <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80001b6e:	1101                	addi	sp,sp,-32
80001b70:	cc22                	sw	s0,24(sp)
	test->setup();
80001b72:	451c                	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80001b74:	80005437          	lui	s0,0x80005
{
80001b78:	ca26                	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80001b7a:	d0840413          	addi	s0,s0,-760 # 80004d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d09>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80001b7e:	800054b7          	lui	s1,0x80005
{
80001b82:	ce06                	sw	ra,28(sp)
80001b84:	c84a                	sw	s2,16(sp)
80001b86:	c64e                	sw	s3,12(sp)
	test_result = 1;
80001b88:	dc448493          	addi	s1,s1,-572 # 80004dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dc5>
80001b8c:	4985                	li	s3,1
	phase = TEST_PHASE_SETUP;
80001b8e:	00042023          	sw	zero,0(s0)
{
80001b92:	892a                	mv	s2,a0
	test_result = 1;
80001b94:	0134a023          	sw	s3,0(s1)
	test->setup();
80001b98:	9782                	jalr	a5
	test->test();
80001b9a:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80001b9e:	01342023          	sw	s3,0(s0)
	test->test();
80001ba2:	9782                	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80001ba4:	4789                	li	a5,2
80001ba6:	c01c                	sw	a5,0(s0)
	test->teardown();
80001ba8:	00c92783          	lw	a5,12(s2)
80001bac:	9782                	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80001bae:	478d                	li	a5,3
80001bb0:	c01c                	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80001bb2:	4462                	lw	s0,24(sp)
	test_result = 0;
80001bb4:	0004a023          	sw	zero,0(s1)
}
80001bb8:	40f2                	lw	ra,28(sp)
80001bba:	44d2                	lw	s1,20(sp)
80001bbc:	4942                	lw	s2,16(sp)
80001bbe:	49b2                	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80001bc0:	80005537          	lui	a0,0x80005
80001bc4:	01c50513          	addi	a0,a0,28 # 8000501c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000501d>
80001bc8:	6105                	addi	sp,sp,32
80001bca:	6ba0106f          	j	80003284 <z_impl_k_sem_give>

80001bce <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80001bce:	711d                	addi	sp,sp,-96
80001bd0:	caa6                	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80001bd2:	800054b7          	lui	s1,0x80005
80001bd6:	dc84a783          	lw	a5,-568(s1) # 80004dc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dc9>
{
80001bda:	ce86                	sw	ra,92(sp)
80001bdc:	cca2                	sw	s0,88(sp)
80001bde:	c8ca                	sw	s2,80(sp)
80001be0:	c6ce                	sw	s3,76(sp)
80001be2:	c4d2                	sw	s4,72(sp)
80001be4:	c2d6                	sw	s5,68(sp)
80001be6:	c0da                	sw	s6,64(sp)
80001be8:	de5e                	sw	s7,60(sp)
80001bea:	dc62                	sw	s8,56(sp)
80001bec:	da66                	sw	s9,52(sp)
80001bee:	d86a                	sw	s10,48(sp)
80001bf0:	d66e                	sw	s11,44(sp)
	if (test_status < 0) {
80001bf2:	0607c963          	bltz	a5,80001c64 <z_ztest_run_test_suite+0x96>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001bf6:	80005437          	lui	s0,0x80005
80001bfa:	4605                	li	a2,1
80001bfc:	89aa                	mv	s3,a0
80001bfe:	8c2e                	mv	s8,a1
80001c00:	01c40513          	addi	a0,s0,28 # 8000501c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000501d>
80001c04:	4581                	li	a1,0
80001c06:	5de010ef          	jal	ra,800031e4 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80001c0a:	80005537          	lui	a0,0x80005
80001c0e:	85ce                	mv	a1,s3
80001c10:	8ec50513          	addi	a0,a0,-1812 # 800048ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048ed>
80001c14:	a9fff0ef          	jal	ra,800016b2 <printk>
	PRINT_LINE;
80001c18:	80005937          	lui	s2,0x80005
80001c1c:	90490513          	addi	a0,s2,-1788 # 80004904 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004905>
		Z_TC_END_RESULT(ret, test->name);
80001c20:	80005ab7          	lui	s5,0x80005
	PRINT_LINE;
80001c24:	a8fff0ef          	jal	ra,800016b2 <printk>
80001c28:	dc848493          	addi	s1,s1,-568
	int fail = 0;
80001c2c:	4a01                	li	s4,0
80001c2e:	ce22                	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001c30:	80006cb7          	lui	s9,0x80006
80001c34:	80005b37          	lui	s6,0x80005
80001c38:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80001c3c:	80005db7          	lui	s11,0x80005
80001c40:	80005bb7          	lui	s7,0x80005
		Z_TC_END_RESULT(ret, test->name);
80001c44:	8a4a8a93          	addi	s5,s5,-1884 # 800048a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048a5>
	while (suite->test) {
80001c48:	004c2783          	lw	a5,4(s8)
80001c4c:	eb9d                	bnez	a5,80001c82 <z_ztest_run_test_suite+0xb4>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80001c4e:	85ce                	mv	a1,s3
	if (fail) {
80001c50:	0c0a0363          	beqz	s4,80001d16 <z_ztest_run_test_suite+0x148>
		TC_PRINT("Test suite %s failed.\n", name);
80001c54:	80005537          	lui	a0,0x80005
80001c58:	97450513          	addi	a0,a0,-1676 # 80004974 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004975>
80001c5c:	a57ff0ef          	jal	ra,800016b2 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80001c60:	4785                	li	a5,1
80001c62:	c09c                	sw	a5,0(s1)
}
80001c64:	40f6                	lw	ra,92(sp)
80001c66:	4466                	lw	s0,88(sp)
80001c68:	44d6                	lw	s1,84(sp)
80001c6a:	4946                	lw	s2,80(sp)
80001c6c:	49b6                	lw	s3,76(sp)
80001c6e:	4a26                	lw	s4,72(sp)
80001c70:	4a96                	lw	s5,68(sp)
80001c72:	4b06                	lw	s6,64(sp)
80001c74:	5bf2                	lw	s7,60(sp)
80001c76:	5c62                	lw	s8,56(sp)
80001c78:	5cd2                	lw	s9,52(sp)
80001c7a:	5d42                	lw	s10,48(sp)
80001c7c:	5db2                	lw	s11,44(sp)
80001c7e:	6125                	addi	sp,sp,96
80001c80:	8082                	ret
	TC_START(test->name);
80001c82:	000c2583          	lw	a1,0(s8)
80001c86:	800057b7          	lui	a5,0x80005
80001c8a:	94c78513          	addi	a0,a5,-1716 # 8000494c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000494d>
80001c8e:	a25ff0ef          	jal	ra,800016b2 <printk>
80001c92:	c202                	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80001c94:	010c2783          	lw	a5,16(s8)
80001c98:	8762                	mv	a4,s8
80001c9a:	40000613          	li	a2,1024
80001c9e:	0087e793          	ori	a5,a5,8
80001ca2:	58fd                	li	a7,-1
80001ca4:	4801                	li	a6,0
80001ca6:	b6ed0693          	addi	a3,s10,-1170 # 80001b6e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001b6f>
80001caa:	c03e                	sw	a5,0(sp)
80001cac:	9b0c8593          	addi	a1,s9,-1616 # 800059b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059b1>
80001cb0:	4781                	li	a5,0
80001cb2:	02cb0513          	addi	a0,s6,44 # 8000502c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000502d>
80001cb6:	209010ef          	jal	ra,800036be <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001cba:	47f2                	lw	a5,28(sp)
80001cbc:	55fd                	li	a1,-1
80001cbe:	01c78513          	addi	a0,a5,28
80001cc2:	66c010ef          	jal	ra,8000332e <z_impl_k_sem_take>
	if (test_result == -1) {
80001cc6:	dc4d8793          	addi	a5,s11,-572 # 80004dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dc5>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001cca:	02cb0513          	addi	a0,s6,44
80001cce:	4380                	lw	s0,0(a5)
80001cd0:	307010ef          	jal	ra,800037d6 <z_impl_k_thread_abort>
	if (test_result == -2) {
80001cd4:	800057b7          	lui	a5,0x80005
80001cd8:	dc478793          	addi	a5,a5,-572 # 80004dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dc5>
80001cdc:	4398                	lw	a4,0(a5)
	if (test_result == -1) {
80001cde:	0405                	addi	s0,s0,1
	if (test_result == -2) {
80001ce0:	57f9                	li	a5,-2
	if (test_result == -1) {
80001ce2:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80001ce6:	000c2603          	lw	a2,0(s8)
80001cea:	02f71163          	bne	a4,a5,80001d0c <z_ztest_run_test_suite+0x13e>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80001cee:	800055b7          	lui	a1,0x80005
80001cf2:	96058593          	addi	a1,a1,-1696 # 80004960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004961>
		Z_TC_END_RESULT(ret, test->name);
80001cf6:	968b8513          	addi	a0,s7,-1688 # 80004968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004969>
80001cfa:	9b9ff0ef          	jal	ra,800016b2 <printk>
80001cfe:	90490513          	addi	a0,s2,-1788
80001d02:	9b1ff0ef          	jal	ra,800016b2 <printk>
		fail += run_test(suite);
80001d06:	9a22                	add	s4,s4,s0
		suite++;
80001d08:	0c51                	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80001d0a:	bf3d                	j	80001c48 <z_ztest_run_test_suite+0x7a>
		Z_TC_END_RESULT(ret, test->name);
80001d0c:	00241793          	slli	a5,s0,0x2
80001d10:	97d6                	add	a5,a5,s5
80001d12:	438c                	lw	a1,0(a5)
80001d14:	b7cd                	j	80001cf6 <z_ztest_run_test_suite+0x128>
		TC_PRINT("Test suite %s succeeded\n", name);
80001d16:	80005537          	lui	a0,0x80005
80001d1a:	98c50513          	addi	a0,a0,-1652 # 8000498c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000498d>
80001d1e:	995ff0ef          	jal	ra,800016b2 <printk>
	test_status = (test_status || fail) ? 1 : 0;
80001d22:	409c                	lw	a5,0(s1)
80001d24:	00f037b3          	snez	a5,a5
80001d28:	bf2d                	j	80001c62 <z_ztest_run_test_suite+0x94>

80001d2a <end_report>:

void end_report(void)
{
	if (test_status) {
80001d2a:	800057b7          	lui	a5,0x80005
80001d2e:	dc87a783          	lw	a5,-568(a5) # 80004dc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dc9>
{
80001d32:	1141                	addi	sp,sp,-16
80001d34:	c422                	sw	s0,8(sp)
80001d36:	80005537          	lui	a0,0x80005
80001d3a:	c606                	sw	ra,12(sp)
80001d3c:	80005437          	lui	s0,0x80005
		TC_END_REPORT(TC_FAIL);
80001d40:	90450513          	addi	a0,a0,-1788 # 80004904 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004905>
	if (test_status) {
80001d44:	cf91                	beqz	a5,80001d60 <end_report+0x36>
		TC_END_REPORT(TC_FAIL);
80001d46:	96dff0ef          	jal	ra,800016b2 <printk>
80001d4a:	800055b7          	lui	a1,0x80005
80001d4e:	8b058593          	addi	a1,a1,-1872 # 800048b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048b1>
	} else {
		TC_END_REPORT(TC_PASS);
80001d52:	8b840513          	addi	a0,s0,-1864 # 800048b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048b9>
	}
}
80001d56:	4422                	lw	s0,8(sp)
80001d58:	40b2                	lw	ra,12(sp)
80001d5a:	0141                	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80001d5c:	957ff06f          	j	800016b2 <printk>
80001d60:	953ff0ef          	jal	ra,800016b2 <printk>
80001d64:	800055b7          	lui	a1,0x80005
80001d68:	8d058593          	addi	a1,a1,-1840 # 800048d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048d1>
80001d6c:	b7dd                	j	80001d52 <end_report+0x28>

80001d6e <main>:

	return test_status;
}
#else
void main(void)
{
80001d6e:	1141                	addi	sp,sp,-16
80001d70:	c606                	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80001d72:	d07fe0ef          	jal	ra,80000a78 <test_main>
	end_report();
}
80001d76:	40b2                	lw	ra,12(sp)
80001d78:	0141                	addi	sp,sp,16
	end_report();
80001d7a:	bf45                	j	80001d2a <end_report>

80001d7c <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80001d7c:	1141                	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80001d7e:	c602                	sw	zero,12(sp)
    i++;
80001d80:	47b2                	lw	a5,12(sp)
80001d82:	0785                	addi	a5,a5,1
80001d84:	c63e                	sw	a5,12(sp)
    uart[0] = c;
80001d86:	f00107b7          	lui	a5,0xf0010
80001d8a:	c38c                	sw	a1,0(a5)
}
80001d8c:	0141                	addi	sp,sp,16
80001d8e:	8082                	ret

80001d90 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80001d90:	557d                	li	a0,-1
80001d92:	8082                	ret

80001d94 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80001d94:	4501                	li	a0,0
80001d96:	8082                	ret

80001d98 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80001d98:	00251713          	slli	a4,a0,0x2
80001d9c:	800057b7          	lui	a5,0x80005
80001da0:	0505                	addi	a0,a0,1
80001da2:	9bc78793          	addi	a5,a5,-1604 # 800049bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800049bd>
80001da6:	050a                	slli	a0,a0,0x2
{
80001da8:	1141                	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80001daa:	973e                	add	a4,a4,a5
80001dac:	97aa                	add	a5,a5,a0
{
80001dae:	c422                	sw	s0,8(sp)
80001db0:	c226                	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80001db2:	4300                	lw	s0,0(a4)
80001db4:	4384                	lw	s1,0(a5)
{
80001db6:	c606                	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80001db8:	00946763          	bltu	s0,s1,80001dc6 <z_sys_device_do_config_level+0x2e>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80001dbc:	40b2                	lw	ra,12(sp)
80001dbe:	4422                	lw	s0,8(sp)
80001dc0:	4492                	lw	s1,4(sp)
80001dc2:	0141                	addi	sp,sp,16
80001dc4:	8082                	ret
		retval = device_conf->init(info);
80001dc6:	401c                	lw	a5,0(s0)
80001dc8:	8522                	mv	a0,s0
80001dca:	43dc                	lw	a5,4(a5)
80001dcc:	9782                	jalr	a5
		if (retval != 0) {
80001dce:	c119                	beqz	a0,80001dd4 <z_sys_device_do_config_level+0x3c>
			info->driver_api = NULL;
80001dd0:	00042223          	sw	zero,4(s0)
								info++) {
80001dd4:	0431                	addi	s0,s0,12
80001dd6:	b7cd                	j	80001db8 <z_sys_device_do_config_level+0x20>

80001dd8 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80001dd8:	1141                	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80001dda:	800057b7          	lui	a5,0x80005
{
80001dde:	c226                	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80001de0:	800054b7          	lui	s1,0x80005
{
80001de4:	c422                	sw	s0,8(sp)
80001de6:	c606                	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80001de8:	d2478413          	addi	s0,a5,-732 # 80004d24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d25>
{
80001dec:	c04a                	sw	s2,0(sp)
80001dee:	d2478793          	addi	a5,a5,-732
80001df2:	d5448493          	addi	s1,s1,-684 # 80004d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d55>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001df6:	00941863          	bne	s0,s1,80001e06 <z_impl_device_get_binding+0x2e>
80001dfa:	892a                	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80001dfc:	843e                	mv	s0,a5
80001dfe:	00941c63          	bne	s0,s1,80001e16 <z_impl_device_get_binding+0x3e>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80001e02:	4401                	li	s0,0
80001e04:	a015                	j	80001e28 <z_impl_device_get_binding+0x50>
		if ((info->driver_api != NULL) &&
80001e06:	4058                	lw	a4,4(s0)
80001e08:	c709                	beqz	a4,80001e12 <z_impl_device_get_binding+0x3a>
		    (info->config->name == name)) {
80001e0a:	4018                	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80001e0c:	4318                	lw	a4,0(a4)
80001e0e:	00a70d63          	beq	a4,a0,80001e28 <z_impl_device_get_binding+0x50>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001e12:	0431                	addi	s0,s0,12
80001e14:	b7cd                	j	80001df6 <z_impl_device_get_binding+0x1e>
		if (info->driver_api == NULL) {
80001e16:	405c                	lw	a5,4(s0)
80001e18:	e399                	bnez	a5,80001e1e <z_impl_device_get_binding+0x46>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001e1a:	0431                	addi	s0,s0,12
80001e1c:	b7cd                	j	80001dfe <z_impl_device_get_binding+0x26>
		if (strcmp(name, info->config->name) == 0) {
80001e1e:	401c                	lw	a5,0(s0)
80001e20:	854a                	mv	a0,s2
80001e22:	438c                	lw	a1,0(a5)
80001e24:	31d9                	jal	80001aea <strcmp>
80001e26:	f975                	bnez	a0,80001e1a <z_impl_device_get_binding+0x42>
}
80001e28:	8522                	mv	a0,s0
80001e2a:	40b2                	lw	ra,12(sp)
80001e2c:	4422                	lw	s0,8(sp)
80001e2e:	4492                	lw	s1,4(sp)
80001e30:	4902                	lw	s2,0(sp)
80001e32:	0141                	addi	sp,sp,16
80001e34:	8082                	ret

80001e36 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80001e36:	1141                	addi	sp,sp,-16
80001e38:	c422                	sw	s0,8(sp)
80001e3a:	c226                	sw	s1,4(sp)
80001e3c:	c606                	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001e3e:	4421                	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80001e40:	4489                	li	s1,2
80001e42:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80001e46:	573010ef          	jal	ra,80003bb8 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80001e4a:	00a4c363          	blt	s1,a0,80001e50 <idle+0x1a>
80001e4e:	4505                	li	a0,1
80001e50:	4585                	li	a1,1
80001e52:	621010ef          	jal	ra,80003c72 <z_set_timeout_expiry>
	k_cpu_idle();
80001e56:	8a3ff0ef          	jal	ra,800016f8 <k_cpu_idle>
80001e5a:	b7e5                	j	80001e42 <idle+0xc>

80001e5c <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80001e5c:	80005537          	lui	a0,0x80005
80001e60:	800057b7          	lui	a5,0x80005
80001e64:	da050613          	addi	a2,a0,-608 # 80004da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da1>
80001e68:	1a878793          	addi	a5,a5,424 # 800051a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a9>
80001e6c:	40c78633          	sub	a2,a5,a2
80001e70:	4581                	li	a1,0
80001e72:	da050513          	addi	a0,a0,-608
80001e76:	b179                	j	80001b04 <memset>

80001e78 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80001e78:	1141                	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80001e7a:	4509                	li	a0,2
{
80001e7c:	c606                	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80001e7e:	3f29                	jal	80001d98 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80001e80:	80005537          	lui	a0,0x80005
80001e84:	9d050513          	addi	a0,a0,-1584 # 800049d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800049d1>
80001e88:	82bff0ef          	jal	ra,800016b2 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80001e8c:	450d                	li	a0,3
80001e8e:	3729                	jal	80001d98 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80001e90:	0cf010ef          	jal	ra,8000375e <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80001e94:	3de9                	jal	80001d6e <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80001e96:	800057b7          	lui	a5,0x80005
80001e9a:	10c78793          	addi	a5,a5,268 # 8000510c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000510d>
80001e9e:	00c7c703          	lbu	a4,12(a5)
80001ea2:	9b79                	andi	a4,a4,-2
80001ea4:	00e78623          	sb	a4,12(a5)
}
80001ea8:	40b2                	lw	ra,12(sp)
80001eaa:	0141                	addi	sp,sp,16
80001eac:	8082                	ret

80001eae <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80001eae:	7135                	addi	sp,sp,-160
80001eb0:	cd22                	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80001eb2:	800077b7          	lui	a5,0x80007
80001eb6:	80005437          	lui	s0,0x80005
80001eba:	c74e                	sw	s3,140(sp)
80001ebc:	9b078793          	addi	a5,a5,-1616 # 800069b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b1>
80001ec0:	17c40993          	addi	s3,s0,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80001ec4:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80001ec8:	081c                	addi	a5,sp,16
80001eca:	07000613          	li	a2,112
80001ece:	4581                	li	a1,0
80001ed0:	853e                	mv	a0,a5
{
80001ed2:	cf06                	sw	ra,156(sp)
80001ed4:	cb26                	sw	s1,148(sp)
80001ed6:	c94a                	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80001ed8:	3135                	jal	80001b04 <memset>
80001eda:	4705                	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80001edc:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80001ee0:	4501                	li	a0,0
	struct k_thread dummy_thread = {
80001ee2:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80001ee6:	3d4d                	jal	80001d98 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80001ee8:	4505                	li	a0,1
80001eea:	357d                	jal	80001d98 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80001eec:	10100793          	li	a5,257
80001ef0:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80001ef4:	2ce010ef          	jal	ra,800031c2 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80001ef8:	800057b7          	lui	a5,0x80005
80001efc:	a1478793          	addi	a5,a5,-1516 # 80004a14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a15>
	_kernel.ready_q.cache = _main_thread;
80001f00:	80005937          	lui	s2,0x80005
	z_setup_new_thread(_main_thread, _main_stack,
80001f04:	c23e                	sw	a5,4(sp)
80001f06:	800026b7          	lui	a3,0x80002
80001f0a:	4785                	li	a5,1
80001f0c:	800065b7          	lui	a1,0x80006
	_kernel.ready_q.cache = _main_thread;
80001f10:	10c90493          	addi	s1,s2,268 # 8000510c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000510d>
	z_setup_new_thread(_main_thread, _main_stack,
80001f14:	c03e                	sw	a5,0(sp)
80001f16:	4701                	li	a4,0
80001f18:	4781                	li	a5,0
80001f1a:	4881                	li	a7,0
80001f1c:	4801                	li	a6,0
80001f1e:	e7868693          	addi	a3,a3,-392 # 80001e78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001e79>
80001f22:	20000613          	li	a2,512
80001f26:	db058593          	addi	a1,a1,-592 # 80005db0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005db1>
80001f2a:	10c90513          	addi	a0,s2,268
	_kernel.ready_q.cache = _main_thread;
80001f2e:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80001f32:	5a0010ef          	jal	ra,800034d2 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80001f36:	00d4c783          	lbu	a5,13(s1)
80001f3a:	17c40413          	addi	s0,s0,380
80001f3e:	ffb7f713          	andi	a4,a5,-5
80001f42:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80001f46:	8bed                	andi	a5,a5,27
80001f48:	e799                	bnez	a5,80001f56 <z_cstart+0xa8>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80001f4a:	4c9c                	lw	a5,24(s1)
80001f4c:	e789                	bnez	a5,80001f56 <z_cstart+0xa8>
		z_add_thread_to_ready_q(thread);
80001f4e:	10c90513          	addi	a0,s2,268
80001f52:	267000ef          	jal	ra,800029b8 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80001f56:	800057b7          	lui	a5,0x80005
80001f5a:	a1c78793          	addi	a5,a5,-1508 # 80004a1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a1d>
80001f5e:	c23e                	sw	a5,4(sp)
80001f60:	80005537          	lui	a0,0x80005
80001f64:	4785                	li	a5,1
80001f66:	800026b7          	lui	a3,0x80002
80001f6a:	800065b7          	lui	a1,0x80006
80001f6e:	09c50493          	addi	s1,a0,156 # 8000509c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000509d>
80001f72:	c03e                	sw	a5,0(sp)
80001f74:	48bd                	li	a7,15
80001f76:	4801                	li	a6,0
80001f78:	4781                	li	a5,0
80001f7a:	4701                	li	a4,0
80001f7c:	e3668693          	addi	a3,a3,-458 # 80001e36 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001e37>
80001f80:	20000613          	li	a2,512
80001f84:	fb058593          	addi	a1,a1,-80 # 80005fb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb1>
80001f88:	09c50513          	addi	a0,a0,156
80001f8c:	546010ef          	jal	ra,800034d2 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80001f90:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80001f94:	c444                	sw	s1,12(s0)
80001f96:	4521                	li	a0,8
80001f98:	9bed                	andi	a5,a5,-5
80001f9a:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80001f9e:	800057b7          	lui	a5,0x80005
80001fa2:	19478793          	addi	a5,a5,404 # 80005194 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005195>
80001fa6:	cc1c                	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80001fa8:	cc5c                	sw	a5,28(s0)
80001faa:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80001fae:	8921                	andi	a0,a0,8
80001fb0:	a10fe0ef          	jal	ra,800001c0 <__swap>

80001fb4 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80001fb4:	1141                	addi	sp,sp,-16
80001fb6:	c422                	sw	s0,8(sp)
80001fb8:	c226                	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80001fba:	80005437          	lui	s0,0x80005
80001fbe:	800054b7          	lui	s1,0x80005
{
80001fc2:	c606                	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80001fc4:	d5440413          	addi	s0,s0,-684 # 80004d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d55>
80001fc8:	d8c48493          	addi	s1,s1,-628 # 80004d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d8d>
80001fcc:	00946863          	bltu	s0,s1,80001fdc <init_static_pools+0x28>
		k_mem_pool_init(p);
	}

	return 0;
}
80001fd0:	40b2                	lw	ra,12(sp)
80001fd2:	4422                	lw	s0,8(sp)
80001fd4:	4492                	lw	s1,4(sp)
80001fd6:	4501                	li	a0,0
80001fd8:	0141                	addi	sp,sp,16
80001fda:	8082                	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80001fdc:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80001fe0:	8522                	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80001fe2:	c85c                	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80001fe4:	cc1c                	sw	a5,24(s0)
80001fe6:	d8dfe0ef          	jal	ra,80000d72 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80001fea:	0471                	addi	s0,s0,28
80001fec:	b7c5                	j	80001fcc <init_static_pools+0x18>

80001fee <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80001fee:	800057b7          	lui	a5,0x80005
80001ff2:	17c7a783          	lw	a5,380(a5) # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
{
80001ff6:	715d                	addi	sp,sp,-80
80001ff8:	c4a2                	sw	s0,72(sp)
80001ffa:	c2a6                	sw	s1,68(sp)
80001ffc:	de4e                	sw	s3,60(sp)
80001ffe:	d85a                	sw	s6,48(sp)
80002000:	c686                	sw	ra,76(sp)
80002002:	c0ca                	sw	s2,64(sp)
80002004:	dc52                	sw	s4,56(sp)
80002006:	da56                	sw	s5,52(sp)
80002008:	d65e                	sw	s7,44(sp)
8000200a:	d462                	sw	s8,40(sp)
8000200c:	d266                	sw	s9,36(sp)
8000200e:	d06a                	sw	s10,32(sp)
80002010:	ce6e                	sw	s11,28(sp)
80002012:	89aa                	mv	s3,a0
80002014:	84ae                	mv	s1,a1
80002016:	8b32                	mv	s6,a2
80002018:	8436                	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
8000201a:	10078063          	beqz	a5,8000211a <k_mem_pool_alloc+0x12c>
8000201e:	e2f1                	bnez	a3,800020e2 <k_mem_pool_alloc+0xf4>
	s64_t end = 0;
80002020:	4901                	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80002022:	80005537          	lui	a0,0x80005
80002026:	d5450513          	addi	a0,a0,-684 # 80004d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d55>
8000202a:	40a98533          	sub	a0,s3,a0
8000202e:	b6db75b7          	lui	a1,0xb6db7
80002032:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
80002036:	8509                	srai	a0,a0,0x2
80002038:	fe4fe0ef          	jal	ra,8000081c <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
8000203c:	7a7d                	lui	s4,0xfffff
		block->id.block = block_num;
8000203e:	6a85                	lui	s5,0x1
		block->id.pool = pool_id(p);
80002040:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
80002044:	5bd5                	li	s7,-11
			ret = -ENOMEM;
80002046:	5cd1                	li	s9,-12
		block->id.level = level_num;
80002048:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
8000204c:	1afd                	addi	s5,s5,-1
8000204e:	4d21                	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
80002050:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80002054:	8726                	mv	a4,s1
80002056:	0074                	addi	a3,sp,12
80002058:	0030                	addi	a2,sp,8
8000205a:	85da                	mv	a1,s6
8000205c:	854e                	mv	a0,s3
8000205e:	dd7fe0ef          	jal	ra,80000e34 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80002062:	01751c63          	bne	a0,s7,8000207a <k_mem_pool_alloc+0x8c>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80002066:	8726                	mv	a4,s1
80002068:	0074                	addi	a3,sp,12
8000206a:	0030                	addi	a2,sp,8
8000206c:	85da                	mv	a1,s6
8000206e:	854e                	mv	a0,s3
80002070:	dc5fe0ef          	jal	ra,80000e34 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80002074:	01751363          	bne	a0,s7,8000207a <k_mem_pool_alloc+0x8c>
			ret = -ENOMEM;
80002078:	5551                	li	a0,-12
		block->id.level = level_num;
8000207a:	47a2                	lw	a5,8(sp)
		block->id.pool = pool_id(p);
8000207c:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
80002080:	8bbd                	andi	a5,a5,15
80002082:	00879713          	slli	a4,a5,0x8
80002086:	40dc                	lw	a5,4(s1)
80002088:	0147f7b3          	and	a5,a5,s4
8000208c:	8fd9                	or	a5,a5,a4
		block->id.block = block_num;
8000208e:	4732                	lw	a4,12(sp)
80002090:	0157f7b3          	and	a5,a5,s5
80002094:	0732                	slli	a4,a4,0xc
80002096:	8fd9                	or	a5,a5,a4
80002098:	c0dc                	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
8000209a:	c50d                	beqz	a0,800020c4 <k_mem_pool_alloc+0xd6>
8000209c:	c405                	beqz	s0,800020c4 <k_mem_pool_alloc+0xd6>
8000209e:	03951363          	bne	a0,s9,800020c4 <k_mem_pool_alloc+0xd6>
800020a2:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
800020a6:	8622                	mv	a2,s0
800020a8:	85ee                	mv	a1,s11
800020aa:	8921                	andi	a0,a0,8
800020ac:	6dd000ef          	jal	ra,80002f88 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
800020b0:	57fd                	li	a5,-1
800020b2:	faf401e3          	beq	s0,a5,80002054 <k_mem_pool_alloc+0x66>
			timeout = end - z_tick_get();
800020b6:	683010ef          	jal	ra,80003f38 <z_tick_get>
800020ba:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
800020be:	f8045be3          	bgez	s0,80002054 <k_mem_pool_alloc+0x66>
				break;
			}
		}
	}

	return -EAGAIN;
800020c2:	5555                	li	a0,-11
}
800020c4:	40b6                	lw	ra,76(sp)
800020c6:	4426                	lw	s0,72(sp)
800020c8:	4496                	lw	s1,68(sp)
800020ca:	4906                	lw	s2,64(sp)
800020cc:	59f2                	lw	s3,60(sp)
800020ce:	5a62                	lw	s4,56(sp)
800020d0:	5ad2                	lw	s5,52(sp)
800020d2:	5b42                	lw	s6,48(sp)
800020d4:	5bb2                	lw	s7,44(sp)
800020d6:	5c22                	lw	s8,40(sp)
800020d8:	5c92                	lw	s9,36(sp)
800020da:	5d02                	lw	s10,32(sp)
800020dc:	4df2                	lw	s11,28(sp)
800020de:	6161                	addi	sp,sp,80
800020e0:	8082                	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800020e2:	80005937          	lui	s2,0x80005
800020e6:	800055b7          	lui	a1,0x80005
800020ea:	80004537          	lui	a0,0x80004
800020ee:	a3858593          	addi	a1,a1,-1480 # 80004a38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a39>
800020f2:	03900693          	li	a3,57
800020f6:	a2490613          	addi	a2,s2,-1500 # 80004a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a25>
800020fa:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800020fe:	db4ff0ef          	jal	ra,800016b2 <printk>
80002102:	80004537          	lui	a0,0x80004
80002106:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
8000210a:	da8ff0ef          	jal	ra,800016b2 <printk>
8000210e:	03900593          	li	a1,57
80002112:	a2490513          	addi	a0,s2,-1500
80002116:	dbaff0ef          	jal	ra,800016d0 <assert_post_action>
	if (timeout > 0) {
8000211a:	f08053e3          	blez	s0,80002020 <k_mem_pool_alloc+0x32>
		end = z_tick_get() + z_ms_to_ticks(timeout);
8000211e:	61b010ef          	jal	ra,80003f38 <z_tick_get>
80002122:	892a                	mv	s2,a0
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002124:	45a9                	li	a1,10
80002126:	00940513          	addi	a0,s0,9
8000212a:	f16fe0ef          	jal	ra,80000840 <__divsi3>
8000212e:	992a                	add	s2,s2,a0
80002130:	bdcd                	j	80002022 <k_mem_pool_alloc+0x34>

80002132 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002132:	00054783          	lbu	a5,0(a0)
{
80002136:	1101                	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002138:	4110                	lw	a2,0(a0)
{
8000213a:	cc22                	sw	s0,24(sp)
8000213c:	00379413          	slli	s0,a5,0x3
80002140:	c84a                	sw	s2,16(sp)
80002142:	8c1d                	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002144:	80005937          	lui	s2,0x80005
80002148:	040a                	slli	s0,s0,0x2
8000214a:	00865593          	srli	a1,a2,0x8
8000214e:	d5490513          	addi	a0,s2,-684 # 80004d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d55>
80002152:	8231                	srli	a2,a2,0xc
80002154:	89bd                	andi	a1,a1,15
80002156:	9522                	add	a0,a0,s0
{
80002158:	ce06                	sw	ra,28(sp)
8000215a:	ca26                	sw	s1,20(sp)
8000215c:	c64e                	sw	s3,12(sp)
8000215e:	c452                	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002160:	ee5fe0ef          	jal	ra,80001044 <z_sys_mem_pool_block_free>
80002164:	45a1                	li	a1,8
80002166:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000216a:	800054b7          	lui	s1,0x80005
8000216e:	dcc48513          	addi	a0,s1,-564 # 80004dcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dcd>
	key = (mstatus & SOC_MSTATUS_IEN);
80002172:	0085f993          	andi	s3,a1,8
80002176:	3e2010ef          	jal	ra,80003558 <z_spin_lock_valid>
8000217a:	d5490913          	addi	s2,s2,-684
8000217e:	ed0d                	bnez	a0,800021b8 <k_mem_pool_free_id+0x86>
80002180:	80005a37          	lui	s4,0x80005
80002184:	800055b7          	lui	a1,0x80005
80002188:	80004537          	lui	a0,0x80004
8000218c:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80002190:	04e00693          	li	a3,78
80002194:	830a0613          	addi	a2,s4,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002198:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000219c:	d16ff0ef          	jal	ra,800016b2 <printk>
800021a0:	80005537          	lui	a0,0x80005
800021a4:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
800021a8:	d0aff0ef          	jal	ra,800016b2 <printk>
800021ac:	04e00593          	li	a1,78
800021b0:	830a0513          	addi	a0,s4,-2000
800021b4:	d1cff0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
800021b8:	dcc48513          	addi	a0,s1,-564
800021bc:	3d8010ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
800021c0:	01440513          	addi	a0,s0,20
800021c4:	954a                	add	a0,a0,s2
800021c6:	7bf000ef          	jal	ra,80003184 <z_unpend_all>

	if (need_sched != 0) {
800021ca:	cd01                	beqz	a0,800021e2 <k_mem_pool_free_id+0xb0>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
800021cc:	4462                	lw	s0,24(sp)
800021ce:	40f2                	lw	ra,28(sp)
800021d0:	4942                	lw	s2,16(sp)
800021d2:	4a22                	lw	s4,8(sp)
		z_reschedule(&lock, key);
800021d4:	85ce                	mv	a1,s3
800021d6:	dcc48513          	addi	a0,s1,-564
}
800021da:	49b2                	lw	s3,12(sp)
800021dc:	44d2                	lw	s1,20(sp)
800021de:	6105                	addi	sp,sp,32
		z_reschedule(&lock, key);
800021e0:	a479                	j	8000246e <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800021e2:	dcc48513          	addi	a0,s1,-564
800021e6:	38c010ef          	jal	ra,80003572 <z_spin_unlock_valid>
800021ea:	ed0d                	bnez	a0,80002224 <k_mem_pool_free_id+0xf2>
800021ec:	80005437          	lui	s0,0x80005
800021f0:	800055b7          	lui	a1,0x80005
800021f4:	80004537          	lui	a0,0x80004
800021f8:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
800021fc:	06100693          	li	a3,97
80002200:	83040613          	addi	a2,s0,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002204:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002208:	caaff0ef          	jal	ra,800016b2 <printk>
8000220c:	80005537          	lui	a0,0x80005
80002210:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002214:	c9eff0ef          	jal	ra,800016b2 <printk>
80002218:	06100593          	li	a1,97
8000221c:	83040513          	addi	a0,s0,-2000
80002220:	cb0ff0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002224:	3009a5f3          	csrrs	a1,mstatus,s3
}
80002228:	40f2                	lw	ra,28(sp)
8000222a:	4462                	lw	s0,24(sp)
8000222c:	44d2                	lw	s1,20(sp)
8000222e:	4942                	lw	s2,16(sp)
80002230:	49b2                	lw	s3,12(sp)
80002232:	4a22                	lw	s4,8(sp)
80002234:	6105                	addi	sp,sp,32
80002236:	8082                	ret

80002238 <k_mem_pool_free>:

void k_mem_pool_free(struct k_mem_block *block)
{
	k_mem_pool_free_id(&block->id);
80002238:	0511                	addi	a0,a0,4
8000223a:	bde5                	j	80002132 <k_mem_pool_free_id>

8000223c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000223c:	00d54783          	lbu	a5,13(a0)
80002240:	8bfd                	andi	a5,a5,31
80002242:	e789                	bnez	a5,8000224c <z_is_thread_ready+0x10>
80002244:	4d08                	lw	a0,24(a0)
80002246:	00153513          	seqz	a0,a0
8000224a:	8082                	ret
8000224c:	4501                	li	a0,0
}
8000224e:	8082                	ret

80002250 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002250:	1141                	addi	sp,sp,-16
80002252:	c606                	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002254:	fd6ff0ef          	jal	ra,80001a2a <z_clock_elapsed>
80002258:	800057b7          	lui	a5,0x80005
8000225c:	dd87a783          	lw	a5,-552(a5) # 80004dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd9>

	z_set_timeout_expiry(slice_time, false);
}
80002260:	40b2                	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002262:	80005737          	lui	a4,0x80005
80002266:	953e                	add	a0,a0,a5
80002268:	18a72623          	sw	a0,396(a4) # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
	z_set_timeout_expiry(slice_time, false);
8000226c:	4581                	li	a1,0
8000226e:	853e                	mv	a0,a5
}
80002270:	0141                	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002272:	2010106f          	j	80003c72 <z_set_timeout_expiry>

80002276 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002276:	411c                	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002278:	1141                	addi	sp,sp,-16
8000227a:	c422                	sw	s0,8(sp)
8000227c:	c606                	sw	ra,12(sp)
8000227e:	c226                	sw	s1,4(sp)
80002280:	842a                	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002282:	e79d                	bnez	a5,800022b0 <pended_on.isra.15+0x3a>
80002284:	800054b7          	lui	s1,0x80005
80002288:	800055b7          	lui	a1,0x80005
8000228c:	80004537          	lui	a0,0x80004
80002290:	afc58593          	addi	a1,a1,-1284 # 80004afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004afd>
80002294:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002298:	18300693          	li	a3,387
8000229c:	ae848613          	addi	a2,s1,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
800022a0:	c12ff0ef          	jal	ra,800016b2 <printk>
800022a4:	18300593          	li	a1,387
800022a8:	ae848513          	addi	a0,s1,-1304
800022ac:	c24ff0ef          	jal	ra,800016d0 <assert_post_action>

	return thread->base.pended_on;
}
800022b0:	4008                	lw	a0,0(s0)
800022b2:	40b2                	lw	ra,12(sp)
800022b4:	4422                	lw	s0,8(sp)
800022b6:	4492                	lw	s1,4(sp)
800022b8:	0141                	addi	sp,sp,16
800022ba:	8082                	ret

800022bc <k_sched_time_slice_set>:
{
800022bc:	1101                	addi	sp,sp,-32
800022be:	cc22                	sw	s0,24(sp)
800022c0:	c64e                	sw	s3,12(sp)
800022c2:	c452                	sw	s4,8(sp)
800022c4:	ce06                	sw	ra,28(sp)
800022c6:	ca26                	sw	s1,20(sp)
800022c8:	c84a                	sw	s2,16(sp)
800022ca:	8a2a                	mv	s4,a0
800022cc:	89ae                	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800022ce:	4421                	li	s0,8
800022d0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800022d4:	800054b7          	lui	s1,0x80005
800022d8:	dd048513          	addi	a0,s1,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
800022dc:	8821                	andi	s0,s0,8
800022de:	27a010ef          	jal	ra,80003558 <z_spin_lock_valid>
800022e2:	ed0d                	bnez	a0,8000231c <k_sched_time_slice_set+0x60>
800022e4:	80005937          	lui	s2,0x80005
800022e8:	800055b7          	lui	a1,0x80005
800022ec:	80004537          	lui	a0,0x80004
800022f0:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800022f4:	04e00693          	li	a3,78
800022f8:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800022fc:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002300:	bb2ff0ef          	jal	ra,800016b2 <printk>
80002304:	80005537          	lui	a0,0x80005
80002308:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
8000230c:	ba6ff0ef          	jal	ra,800016b2 <printk>
80002310:	04e00593          	li	a1,78
80002314:	83090513          	addi	a0,s2,-2000
80002318:	bb8ff0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
8000231c:	dd048513          	addi	a0,s1,-560
80002320:	274010ef          	jal	ra,80003594 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002324:	800057b7          	lui	a5,0x80005
80002328:	45a9                	li	a1,10
8000232a:	009a0513          	addi	a0,s4,9
8000232e:	1807a623          	sw	zero,396(a5) # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80002332:	d0efe0ef          	jal	ra,80000840 <__divsi3>
		slice_max_prio = prio;
80002336:	800057b7          	lui	a5,0x80005
		slice_time = z_ms_to_ticks(slice);
8000233a:	80005937          	lui	s2,0x80005
8000233e:	dca92c23          	sw	a0,-552(s2) # 80004dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd9>
		slice_max_prio = prio;
80002342:	dd37aa23          	sw	s3,-556(a5) # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
		reset_time_slice();
80002346:	3729                	jal	80002250 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002348:	dd048513          	addi	a0,s1,-560
8000234c:	226010ef          	jal	ra,80003572 <z_spin_unlock_valid>
80002350:	ed0d                	bnez	a0,8000238a <k_sched_time_slice_set+0xce>
80002352:	800054b7          	lui	s1,0x80005
80002356:	800055b7          	lui	a1,0x80005
8000235a:	80004537          	lui	a0,0x80004
8000235e:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002362:	06100693          	li	a3,97
80002366:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
8000236a:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000236e:	b44ff0ef          	jal	ra,800016b2 <printk>
80002372:	80005537          	lui	a0,0x80005
80002376:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
8000237a:	b38ff0ef          	jal	ra,800016b2 <printk>
8000237e:	06100593          	li	a1,97
80002382:	83048513          	addi	a0,s1,-2000
80002386:	b4aff0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000238a:	30042473          	csrrs	s0,mstatus,s0
}
8000238e:	40f2                	lw	ra,28(sp)
80002390:	4462                	lw	s0,24(sp)
80002392:	44d2                	lw	s1,20(sp)
80002394:	4942                	lw	s2,16(sp)
80002396:	49b2                	lw	s3,12(sp)
80002398:	4a22                	lw	s4,8(sp)
8000239a:	6105                	addi	sp,sp,32
8000239c:	8082                	ret

8000239e <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
8000239e:	1101                	addi	sp,sp,-32
800023a0:	cc22                	sw	s0,24(sp)
800023a2:	c84a                	sw	s2,16(sp)
800023a4:	ce06                	sw	ra,28(sp)
800023a6:	ca26                	sw	s1,20(sp)
800023a8:	c64e                	sw	s3,12(sp)
800023aa:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800023ac:	4421                	li	s0,8
800023ae:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800023b2:	800054b7          	lui	s1,0x80005
800023b6:	dd048513          	addi	a0,s1,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
800023ba:	8821                	andi	s0,s0,8
800023bc:	19c010ef          	jal	ra,80003558 <z_spin_lock_valid>
800023c0:	ed0d                	bnez	a0,800023fa <z_unpend_thread_no_timeout+0x5c>
800023c2:	800059b7          	lui	s3,0x80005
800023c6:	800055b7          	lui	a1,0x80005
800023ca:	80004537          	lui	a0,0x80004
800023ce:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800023d2:	04e00693          	li	a3,78
800023d6:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800023da:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800023de:	ad4ff0ef          	jal	ra,800016b2 <printk>
800023e2:	80005537          	lui	a0,0x80005
800023e6:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
800023ea:	ac8ff0ef          	jal	ra,800016b2 <printk>
800023ee:	04e00593          	li	a1,78
800023f2:	83098513          	addi	a0,s3,-2000
800023f6:	adaff0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
800023fa:	dd048513          	addi	a0,s1,-560
800023fe:	196010ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002402:	00890513          	addi	a0,s2,8
80002406:	3d85                	jal	80002276 <pended_on.isra.15>
80002408:	85ca                	mv	a1,s2
8000240a:	2451                	jal	8000268e <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000240c:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002410:	dd048513          	addi	a0,s1,-560
80002414:	9bf5                	andi	a5,a5,-3
80002416:	00f906a3          	sb	a5,13(s2)
8000241a:	158010ef          	jal	ra,80003572 <z_spin_unlock_valid>
8000241e:	ed0d                	bnez	a0,80002458 <z_unpend_thread_no_timeout+0xba>
80002420:	800054b7          	lui	s1,0x80005
80002424:	800055b7          	lui	a1,0x80005
80002428:	80004537          	lui	a0,0x80004
8000242c:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002430:	06100693          	li	a3,97
80002434:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002438:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000243c:	a76ff0ef          	jal	ra,800016b2 <printk>
80002440:	80005537          	lui	a0,0x80005
80002444:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002448:	a6aff0ef          	jal	ra,800016b2 <printk>
8000244c:	06100593          	li	a1,97
80002450:	83048513          	addi	a0,s1,-2000
80002454:	a7cff0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002458:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
8000245c:	40f2                	lw	ra,28(sp)
8000245e:	4462                	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80002460:	00092423          	sw	zero,8(s2)
}
80002464:	44d2                	lw	s1,20(sp)
80002466:	4942                	lw	s2,16(sp)
80002468:	49b2                	lw	s3,12(sp)
8000246a:	6105                	addi	sp,sp,32
8000246c:	8082                	ret

8000246e <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
8000246e:	800057b7          	lui	a5,0x80005
80002472:	17c7a783          	lw	a5,380(a5) # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
{
80002476:	1141                	addi	sp,sp,-16
80002478:	c422                	sw	s0,8(sp)
8000247a:	c606                	sw	ra,12(sp)
8000247c:	c226                	sw	s1,4(sp)
8000247e:	842e                	mv	s0,a1
	if (resched()) {
80002480:	e7b9                	bnez	a5,800024ce <z_reschedule+0x60>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002482:	0f0010ef          	jal	ra,80003572 <z_spin_unlock_valid>
80002486:	ed0d                	bnez	a0,800024c0 <z_reschedule+0x52>
80002488:	800054b7          	lui	s1,0x80005
8000248c:	800055b7          	lui	a1,0x80005
80002490:	80004537          	lui	a0,0x80004
80002494:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002498:	07800693          	li	a3,120
8000249c:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800024a0:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800024a4:	a0eff0ef          	jal	ra,800016b2 <printk>
800024a8:	80005537          	lui	a0,0x80005
800024ac:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
800024b0:	a02ff0ef          	jal	ra,800016b2 <printk>
800024b4:	07800593          	li	a1,120
800024b8:	83048513          	addi	a0,s1,-2000
800024bc:	a14ff0ef          	jal	ra,800016d0 <assert_post_action>
800024c0:	8522                	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
800024c2:	4422                	lw	s0,8(sp)
800024c4:	40b2                	lw	ra,12(sp)
800024c6:	4492                	lw	s1,4(sp)
800024c8:	0141                	addi	sp,sp,16
800024ca:	cf7fd06f          	j	800001c0 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800024ce:	0a4010ef          	jal	ra,80003572 <z_spin_unlock_valid>
800024d2:	ed0d                	bnez	a0,8000250c <z_reschedule+0x9e>
800024d4:	800054b7          	lui	s1,0x80005
800024d8:	800055b7          	lui	a1,0x80005
800024dc:	80004537          	lui	a0,0x80004
800024e0:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
800024e4:	06100693          	li	a3,97
800024e8:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800024ec:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800024f0:	9c2ff0ef          	jal	ra,800016b2 <printk>
800024f4:	80005537          	lui	a0,0x80005
800024f8:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
800024fc:	9b6ff0ef          	jal	ra,800016b2 <printk>
80002500:	06100593          	li	a1,97
80002504:	83048513          	addi	a0,s1,-2000
80002508:	9c8ff0ef          	jal	ra,800016d0 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
8000250c:	8821                	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000250e:	30042473          	csrrs	s0,mstatus,s0
80002512:	40b2                	lw	ra,12(sp)
80002514:	4422                	lw	s0,8(sp)
80002516:	4492                	lw	s1,4(sp)
80002518:	0141                	addi	sp,sp,16
8000251a:	8082                	ret

8000251c <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
8000251c:	80005737          	lui	a4,0x80005
80002520:	17c72703          	lw	a4,380(a4) # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80002524:	e319                	bnez	a4,8000252a <z_reschedule_irqlock+0xe>
80002526:	c9bfd06f          	j	800001c0 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
8000252a:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000252e:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80002532:	8082                	ret

80002534 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002534:	4521                	li	a0,8
80002536:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
8000253a:	8921                	andi	a0,a0,8
8000253c:	b7c5                	j	8000251c <z_reschedule_irqlock>

8000253e <k_sched_lock>:

void k_sched_lock(void)
{
8000253e:	1101                	addi	sp,sp,-32
80002540:	cc22                	sw	s0,24(sp)
80002542:	ce06                	sw	ra,28(sp)
80002544:	ca26                	sw	s1,20(sp)
80002546:	c84a                	sw	s2,16(sp)
80002548:	c64e                	sw	s3,12(sp)
8000254a:	4421                	li	s0,8
8000254c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002550:	800054b7          	lui	s1,0x80005
80002554:	dd048513          	addi	a0,s1,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002558:	8821                	andi	s0,s0,8
8000255a:	7ff000ef          	jal	ra,80003558 <z_spin_lock_valid>
8000255e:	ed0d                	bnez	a0,80002598 <k_sched_lock+0x5a>
80002560:	80005937          	lui	s2,0x80005
80002564:	800055b7          	lui	a1,0x80005
80002568:	80004537          	lui	a0,0x80004
8000256c:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80002570:	04e00693          	li	a3,78
80002574:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002578:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000257c:	936ff0ef          	jal	ra,800016b2 <printk>
80002580:	80005537          	lui	a0,0x80005
80002584:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80002588:	92aff0ef          	jal	ra,800016b2 <printk>
8000258c:	04e00593          	li	a1,78
80002590:	83090513          	addi	a0,s2,-2000
80002594:	93cff0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002598:	dd048513          	addi	a0,s1,-560
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
8000259c:	80005937          	lui	s2,0x80005
800025a0:	7f5000ef          	jal	ra,80003594 <z_spin_lock_set_owner>
800025a4:	17c92783          	lw	a5,380(s2) # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
800025a8:	17c90913          	addi	s2,s2,380
800025ac:	cf8d                	beqz	a5,800025e6 <k_sched_lock+0xa8>
800025ae:	800059b7          	lui	s3,0x80005
800025b2:	800055b7          	lui	a1,0x80005
800025b6:	80004537          	lui	a0,0x80004
800025ba:	a8058593          	addi	a1,a1,-1408 # 80004a80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a81>
800025be:	10000693          	li	a3,256
800025c2:	a6498613          	addi	a2,s3,-1436 # 80004a64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a65>
800025c6:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800025ca:	8e8ff0ef          	jal	ra,800016b2 <printk>
800025ce:	80004537          	lui	a0,0x80004
800025d2:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
800025d6:	8dcff0ef          	jal	ra,800016b2 <printk>
800025da:	10000593          	li	a1,256
800025de:	a6498513          	addi	a0,s3,-1436
800025e2:	8eeff0ef          	jal	ra,800016d0 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
800025e6:	00892783          	lw	a5,8(s2)
800025ea:	00f7c703          	lbu	a4,15(a5)
800025ee:	4785                	li	a5,1
800025f0:	02f71e63          	bne	a4,a5,8000262c <k_sched_lock+0xee>
800025f4:	800059b7          	lui	s3,0x80005
800025f8:	800055b7          	lui	a1,0x80005
800025fc:	80004537          	lui	a0,0x80004
80002600:	a9858593          	addi	a1,a1,-1384 # 80004a98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a99>
80002604:	10100693          	li	a3,257
80002608:	a6498613          	addi	a2,s3,-1436 # 80004a64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a65>
8000260c:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002610:	8a2ff0ef          	jal	ra,800016b2 <printk>
80002614:	80004537          	lui	a0,0x80004
80002618:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
8000261c:	896ff0ef          	jal	ra,800016b2 <printk>
80002620:	10100593          	li	a1,257
80002624:	a6498513          	addi	a0,s3,-1436
80002628:	8a8ff0ef          	jal	ra,800016d0 <assert_post_action>

	--_current->base.sched_locked;
8000262c:	00892703          	lw	a4,8(s2)
80002630:	00f74783          	lbu	a5,15(a4)
80002634:	17fd                	addi	a5,a5,-1
80002636:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000263a:	dd048513          	addi	a0,s1,-560
8000263e:	735000ef          	jal	ra,80003572 <z_spin_unlock_valid>
80002642:	ed0d                	bnez	a0,8000267c <k_sched_lock+0x13e>
80002644:	800054b7          	lui	s1,0x80005
80002648:	800055b7          	lui	a1,0x80005
8000264c:	80004537          	lui	a0,0x80004
80002650:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002654:	06100693          	li	a3,97
80002658:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
8000265c:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002660:	852ff0ef          	jal	ra,800016b2 <printk>
80002664:	80005537          	lui	a0,0x80005
80002668:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
8000266c:	846ff0ef          	jal	ra,800016b2 <printk>
80002670:	06100593          	li	a1,97
80002674:	83048513          	addi	a0,s1,-2000
80002678:	858ff0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000267c:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80002680:	40f2                	lw	ra,28(sp)
80002682:	4462                	lw	s0,24(sp)
80002684:	44d2                	lw	s1,20(sp)
80002686:	4942                	lw	s2,16(sp)
80002688:	49b2                	lw	s3,12(sp)
8000268a:	6105                	addi	sp,sp,32
8000268c:	8082                	ret

8000268e <z_priq_dumb_remove>:
	return thread == _idle_thread;
8000268e:	800057b7          	lui	a5,0x80005
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80002692:	d207a783          	lw	a5,-736(a5) # 80004d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d21>
{
80002696:	1141                	addi	sp,sp,-16
80002698:	c422                	sw	s0,8(sp)
8000269a:	c606                	sw	ra,12(sp)
8000269c:	c226                	sw	s1,4(sp)
8000269e:	842e                	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800026a0:	02f59863          	bne	a1,a5,800026d0 <z_priq_dumb_remove+0x42>
800026a4:	800054b7          	lui	s1,0x80005
800026a8:	800055b7          	lui	a1,0x80005
800026ac:	80004537          	lui	a0,0x80004
800026b0:	b3458593          	addi	a1,a1,-1228 # 80004b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b35>
800026b4:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800026b8:	28c00693          	li	a3,652
800026bc:	ae848613          	addi	a2,s1,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
800026c0:	ff3fe0ef          	jal	ra,800016b2 <printk>
800026c4:	28c00593          	li	a1,652
800026c8:	ae848513          	addi	a0,s1,-1304
800026cc:	804ff0ef          	jal	ra,800016d0 <assert_post_action>
	node->prev->next = node->next;
800026d0:	4058                	lw	a4,4(s0)
800026d2:	401c                	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
800026d4:	40b2                	lw	ra,12(sp)
800026d6:	4492                	lw	s1,4(sp)
800026d8:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
800026da:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
800026dc:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
800026e0:	00042223          	sw	zero,4(s0)
800026e4:	4422                	lw	s0,8(sp)
800026e6:	0141                	addi	sp,sp,16
800026e8:	8082                	ret

800026ea <z_unpend_thread>:
{
800026ea:	1101                	addi	sp,sp,-32
800026ec:	cc22                	sw	s0,24(sp)
800026ee:	ca26                	sw	s1,20(sp)
800026f0:	ce06                	sw	ra,28(sp)
800026f2:	c84a                	sw	s2,16(sp)
800026f4:	c64e                	sw	s3,12(sp)
800026f6:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800026f8:	44a1                	li	s1,8
800026fa:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800026fe:	80005937          	lui	s2,0x80005
80002702:	dd090513          	addi	a0,s2,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002706:	88a1                	andi	s1,s1,8
80002708:	651000ef          	jal	ra,80003558 <z_spin_lock_valid>
8000270c:	ed0d                	bnez	a0,80002746 <z_unpend_thread+0x5c>
8000270e:	800059b7          	lui	s3,0x80005
80002712:	800055b7          	lui	a1,0x80005
80002716:	80004537          	lui	a0,0x80004
8000271a:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
8000271e:	04e00693          	li	a3,78
80002722:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002726:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000272a:	f89fe0ef          	jal	ra,800016b2 <printk>
8000272e:	80005537          	lui	a0,0x80005
80002732:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80002736:	f7dfe0ef          	jal	ra,800016b2 <printk>
8000273a:	04e00593          	li	a1,78
8000273e:	83098513          	addi	a0,s3,-2000
80002742:	f8ffe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002746:	dd090513          	addi	a0,s2,-560
8000274a:	64b000ef          	jal	ra,80003594 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000274e:	00840513          	addi	a0,s0,8
80002752:	b25ff0ef          	jal	ra,80002276 <pended_on.isra.15>
80002756:	85a2                	mv	a1,s0
80002758:	3f1d                	jal	8000268e <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000275a:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000275e:	dd090513          	addi	a0,s2,-560
80002762:	9bf5                	andi	a5,a5,-3
80002764:	00f406a3          	sb	a5,13(s0)
80002768:	60b000ef          	jal	ra,80003572 <z_spin_unlock_valid>
8000276c:	ed0d                	bnez	a0,800027a6 <z_unpend_thread+0xbc>
8000276e:	80005937          	lui	s2,0x80005
80002772:	800055b7          	lui	a1,0x80005
80002776:	80004537          	lui	a0,0x80004
8000277a:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
8000277e:	06100693          	li	a3,97
80002782:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002786:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000278a:	f29fe0ef          	jal	ra,800016b2 <printk>
8000278e:	80005537          	lui	a0,0x80005
80002792:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002796:	f1dfe0ef          	jal	ra,800016b2 <printk>
8000279a:	06100593          	li	a1,97
8000279e:	83090513          	addi	a0,s2,-2000
800027a2:	f2ffe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800027a6:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800027aa:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800027ae:	01840513          	addi	a0,s0,24
}
800027b2:	4462                	lw	s0,24(sp)
800027b4:	40f2                	lw	ra,28(sp)
800027b6:	44d2                	lw	s1,20(sp)
800027b8:	4942                	lw	s2,16(sp)
800027ba:	49b2                	lw	s3,12(sp)
800027bc:	6105                	addi	sp,sp,32
800027be:	3300106f          	j	80003aee <z_abort_timeout>

800027c2 <z_priq_dumb_best>:
	return list->head == list;
800027c2:	411c                	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800027c4:	00f51363          	bne	a0,a5,800027ca <z_priq_dumb_best+0x8>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
800027c8:	4781                	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
800027ca:	853e                	mv	a0,a5
800027cc:	8082                	ret

800027ce <update_cache>:
{
800027ce:	1141                	addi	sp,sp,-16
800027d0:	c422                	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800027d2:	80005437          	lui	s0,0x80005
{
800027d6:	c04a                	sw	s2,0(sp)
800027d8:	892a                	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800027da:	17c40513          	addi	a0,s0,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
800027de:	02450513          	addi	a0,a0,36
{
800027e2:	c226                	sw	s1,4(sp)
800027e4:	c606                	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800027e6:	3ff1                	jal	800027c2 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
800027e8:	17c40413          	addi	s0,s0,380
800027ec:	84aa                	mv	s1,a0
800027ee:	e111                	bnez	a0,800027f2 <update_cache+0x24>
800027f0:	4444                	lw	s1,12(s0)
	if (preempt_ok != 0) {
800027f2:	06091263          	bnez	s2,80002856 <update_cache+0x88>
	__ASSERT(_current != NULL, "");
800027f6:	441c                	lw	a5,8(s0)
800027f8:	ef8d                	bnez	a5,80002832 <update_cache+0x64>
800027fa:	80005937          	lui	s2,0x80005
800027fe:	800055b7          	lui	a1,0x80005
80002802:	80004537          	lui	a0,0x80004
80002806:	b1458593          	addi	a1,a1,-1260 # 80004b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b15>
8000280a:	07f00693          	li	a3,127
8000280e:	ae890613          	addi	a2,s2,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
80002812:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002816:	e9dfe0ef          	jal	ra,800016b2 <printk>
8000281a:	80004537          	lui	a0,0x80004
8000281e:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
80002822:	e91fe0ef          	jal	ra,800016b2 <printk>
80002826:	07f00593          	li	a1,127
8000282a:	ae890513          	addi	a0,s2,-1304
8000282e:	ea3fe0ef          	jal	ra,800016d0 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80002832:	441c                	lw	a5,8(s0)
80002834:	00d7c703          	lbu	a4,13(a5)
80002838:	8b7d                	andi	a4,a4,31
8000283a:	ef11                	bnez	a4,80002856 <update_cache+0x88>
	if (is_preempt(_current) || is_metairq(th)) {
8000283c:	00e7d683          	lhu	a3,14(a5)
80002840:	07f00713          	li	a4,127
80002844:	00d77963          	bgeu	a4,a3,80002856 <update_cache+0x88>
		_kernel.ready_q.cache = _current;
80002848:	d01c                	sw	a5,32(s0)
}
8000284a:	40b2                	lw	ra,12(sp)
8000284c:	4422                	lw	s0,8(sp)
8000284e:	4492                	lw	s1,4(sp)
80002850:	4902                	lw	s2,0(sp)
80002852:	0141                	addi	sp,sp,16
80002854:	8082                	ret
		if (th != _current) {
80002856:	441c                	lw	a5,8(s0)
80002858:	00978463          	beq	a5,s1,80002860 <update_cache+0x92>
			reset_time_slice();
8000285c:	9f5ff0ef          	jal	ra,80002250 <reset_time_slice>
		_kernel.ready_q.cache = th;
80002860:	d004                	sw	s1,32(s0)
}
80002862:	b7e5                	j	8000284a <update_cache+0x7c>

80002864 <k_sched_unlock>:
{
80002864:	1101                	addi	sp,sp,-32
80002866:	c84a                	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002868:	80005937          	lui	s2,0x80005
8000286c:	17c90793          	addi	a5,s2,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80002870:	479c                	lw	a5,8(a5)
{
80002872:	ce06                	sw	ra,28(sp)
80002874:	cc22                	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002876:	00f7c783          	lbu	a5,15(a5)
{
8000287a:	ca26                	sw	s1,20(sp)
8000287c:	c64e                	sw	s3,12(sp)
8000287e:	17c90913          	addi	s2,s2,380
	__ASSERT(_current->base.sched_locked != 0, "");
80002882:	ef8d                	bnez	a5,800028bc <k_sched_unlock+0x58>
80002884:	80005437          	lui	s0,0x80005
80002888:	800055b7          	lui	a1,0x80005
8000288c:	80004537          	lui	a0,0x80004
80002890:	ac058593          	addi	a1,a1,-1344 # 80004ac0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ac1>
80002894:	22100693          	li	a3,545
80002898:	ae840613          	addi	a2,s0,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
8000289c:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800028a0:	e13fe0ef          	jal	ra,800016b2 <printk>
800028a4:	80004537          	lui	a0,0x80004
800028a8:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
800028ac:	e07fe0ef          	jal	ra,800016b2 <printk>
800028b0:	22100593          	li	a1,545
800028b4:	ae840513          	addi	a0,s0,-1304
800028b8:	e19fe0ef          	jal	ra,800016d0 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800028bc:	00092783          	lw	a5,0(s2)
800028c0:	cf8d                	beqz	a5,800028fa <k_sched_unlock+0x96>
800028c2:	80005437          	lui	s0,0x80005
800028c6:	800055b7          	lui	a1,0x80005
800028ca:	80004537          	lui	a0,0x80004
800028ce:	a8058593          	addi	a1,a1,-1408 # 80004a80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a81>
800028d2:	22200693          	li	a3,546
800028d6:	ae840613          	addi	a2,s0,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
800028da:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800028de:	dd5fe0ef          	jal	ra,800016b2 <printk>
800028e2:	80004537          	lui	a0,0x80004
800028e6:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
800028ea:	dc9fe0ef          	jal	ra,800016b2 <printk>
800028ee:	22200593          	li	a1,546
800028f2:	ae840513          	addi	a0,s0,-1304
800028f6:	ddbfe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800028fa:	4421                	li	s0,8
800028fc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002900:	800054b7          	lui	s1,0x80005
80002904:	dd048513          	addi	a0,s1,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002908:	8821                	andi	s0,s0,8
8000290a:	44f000ef          	jal	ra,80003558 <z_spin_lock_valid>
8000290e:	ed0d                	bnez	a0,80002948 <k_sched_unlock+0xe4>
80002910:	800059b7          	lui	s3,0x80005
80002914:	800055b7          	lui	a1,0x80005
80002918:	80004537          	lui	a0,0x80004
8000291c:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80002920:	04e00693          	li	a3,78
80002924:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002928:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000292c:	d87fe0ef          	jal	ra,800016b2 <printk>
80002930:	80005537          	lui	a0,0x80005
80002934:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80002938:	d7bfe0ef          	jal	ra,800016b2 <printk>
8000293c:	04e00593          	li	a1,78
80002940:	83098513          	addi	a0,s3,-2000
80002944:	d8dfe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002948:	dd048513          	addi	a0,s1,-560
8000294c:	449000ef          	jal	ra,80003594 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80002950:	00892703          	lw	a4,8(s2)
		update_cache(1);
80002954:	4505                	li	a0,1
		++_current->base.sched_locked;
80002956:	00f74783          	lbu	a5,15(a4)
8000295a:	0785                	addi	a5,a5,1
8000295c:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80002960:	35bd                	jal	800027ce <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002962:	dd048513          	addi	a0,s1,-560
80002966:	40d000ef          	jal	ra,80003572 <z_spin_unlock_valid>
8000296a:	ed0d                	bnez	a0,800029a4 <k_sched_unlock+0x140>
8000296c:	800054b7          	lui	s1,0x80005
80002970:	800055b7          	lui	a1,0x80005
80002974:	80004537          	lui	a0,0x80004
80002978:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
8000297c:	06100693          	li	a3,97
80002980:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002984:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002988:	d2bfe0ef          	jal	ra,800016b2 <printk>
8000298c:	80005537          	lui	a0,0x80005
80002990:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002994:	d1ffe0ef          	jal	ra,800016b2 <printk>
80002998:	06100593          	li	a1,97
8000299c:	83048513          	addi	a0,s1,-2000
800029a0:	d31fe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800029a4:	30042473          	csrrs	s0,mstatus,s0
}
800029a8:	4462                	lw	s0,24(sp)
800029aa:	40f2                	lw	ra,28(sp)
800029ac:	44d2                	lw	s1,20(sp)
800029ae:	4942                	lw	s2,16(sp)
800029b0:	49b2                	lw	s3,12(sp)
800029b2:	6105                	addi	sp,sp,32
	z_reschedule_unlocked();
800029b4:	b81ff06f          	j	80002534 <z_reschedule_unlocked>

800029b8 <z_add_thread_to_ready_q>:
{
800029b8:	1101                	addi	sp,sp,-32
800029ba:	cc22                	sw	s0,24(sp)
800029bc:	ca26                	sw	s1,20(sp)
800029be:	ce06                	sw	ra,28(sp)
800029c0:	c84a                	sw	s2,16(sp)
800029c2:	c64e                	sw	s3,12(sp)
800029c4:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800029c6:	44a1                	li	s1,8
800029c8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800029cc:	80005937          	lui	s2,0x80005
800029d0:	dd090513          	addi	a0,s2,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
800029d4:	88a1                	andi	s1,s1,8
800029d6:	383000ef          	jal	ra,80003558 <z_spin_lock_valid>
800029da:	ed0d                	bnez	a0,80002a14 <z_add_thread_to_ready_q+0x5c>
800029dc:	800059b7          	lui	s3,0x80005
800029e0:	800055b7          	lui	a1,0x80005
800029e4:	80004537          	lui	a0,0x80004
800029e8:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800029ec:	04e00693          	li	a3,78
800029f0:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800029f4:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800029f8:	cbbfe0ef          	jal	ra,800016b2 <printk>
800029fc:	80005537          	lui	a0,0x80005
80002a00:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80002a04:	caffe0ef          	jal	ra,800016b2 <printk>
80002a08:	04e00593          	li	a1,78
80002a0c:	83098513          	addi	a0,s3,-2000
80002a10:	cc1fe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002a14:	dd090513          	addi	a0,s2,-560
80002a18:	37d000ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80002a1c:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002a20:	d207a783          	lw	a5,-736(a5) # 80004d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d21>
80002a24:	02f41863          	bne	s0,a5,80002a54 <z_add_thread_to_ready_q+0x9c>
80002a28:	800059b7          	lui	s3,0x80005
80002a2c:	800055b7          	lui	a1,0x80005
80002a30:	80004537          	lui	a0,0x80004
80002a34:	b3458593          	addi	a1,a1,-1228 # 80004b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b35>
80002a38:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002a3c:	27600693          	li	a3,630
80002a40:	ae898613          	addi	a2,s3,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
80002a44:	c6ffe0ef          	jal	ra,800016b2 <printk>
80002a48:	27600593          	li	a1,630
80002a4c:	ae898513          	addi	a0,s3,-1304
80002a50:	c81fe0ef          	jal	ra,800016d0 <assert_post_action>
	return list->head == list;
80002a54:	80005737          	lui	a4,0x80005
80002a58:	17c70693          	addi	a3,a4,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80002a5c:	52dc                	lw	a5,36(a3)
80002a5e:	5690                	lw	a2,40(a3)
80002a60:	800056b7          	lui	a3,0x80005
80002a64:	1a068693          	addi	a3,a3,416 # 800051a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a1>
80002a68:	17c70713          	addi	a4,a4,380
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002a6c:	08d78463          	beq	a5,a3,80002af4 <z_add_thread_to_ready_q+0x13c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002a70:	c3d1                	beqz	a5,80002af4 <z_add_thread_to_ready_q+0x13c>
	if (t1->base.prio < t2->base.prio) {
80002a72:	00e40583          	lb	a1,14(s0)
80002a76:	00e78503          	lb	a0,14(a5)
80002a7a:	06a5d963          	bge	a1,a0,80002aec <z_add_thread_to_ready_q+0x134>
	node->prev = successor->prev;
80002a7e:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002a80:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002a82:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002a84:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002a86:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002a88:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80002a8c:	4501                	li	a0,0
80002a8e:	0407e793          	ori	a5,a5,64
80002a92:	00f406a3          	sb	a5,13(s0)
80002a96:	3b25                	jal	800027ce <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002a98:	dd090513          	addi	a0,s2,-560
80002a9c:	2d7000ef          	jal	ra,80003572 <z_spin_unlock_valid>
80002aa0:	ed0d                	bnez	a0,80002ada <z_add_thread_to_ready_q+0x122>
80002aa2:	80005437          	lui	s0,0x80005
80002aa6:	800055b7          	lui	a1,0x80005
80002aaa:	80004537          	lui	a0,0x80004
80002aae:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002ab2:	06100693          	li	a3,97
80002ab6:	83040613          	addi	a2,s0,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002aba:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002abe:	bf5fe0ef          	jal	ra,800016b2 <printk>
80002ac2:	80005537          	lui	a0,0x80005
80002ac6:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002aca:	be9fe0ef          	jal	ra,800016b2 <printk>
80002ace:	06100593          	li	a1,97
80002ad2:	83040513          	addi	a0,s0,-2000
80002ad6:	bfbfe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ada:	3004a4f3          	csrrs	s1,mstatus,s1
}
80002ade:	40f2                	lw	ra,28(sp)
80002ae0:	4462                	lw	s0,24(sp)
80002ae2:	44d2                	lw	s1,20(sp)
80002ae4:	4942                	lw	s2,16(sp)
80002ae6:	49b2                	lw	s3,12(sp)
80002ae8:	6105                	addi	sp,sp,32
80002aea:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
80002aec:	00f60463          	beq	a2,a5,80002af4 <z_add_thread_to_ready_q+0x13c>
80002af0:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002af2:	f3d1                	bnez	a5,80002a76 <z_add_thread_to_ready_q+0xbe>
	node->prev = list->tail;
80002af4:	c050                	sw	a2,4(s0)
	list->tail->next = node;
80002af6:	571c                	lw	a5,40(a4)
	node->next = list;
80002af8:	c014                	sw	a3,0(s0)
	list->tail->next = node;
80002afa:	c380                	sw	s0,0(a5)
	list->tail = node;
80002afc:	d700                	sw	s0,40(a4)
80002afe:	b769                	j	80002a88 <z_add_thread_to_ready_q+0xd0>

80002b00 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80002b00:	ff052783          	lw	a5,-16(a0)
{
80002b04:	1101                	addi	sp,sp,-32
80002b06:	cc22                	sw	s0,24(sp)
80002b08:	c64e                	sw	s3,12(sp)
80002b0a:	ce06                	sw	ra,28(sp)
80002b0c:	ca26                	sw	s1,20(sp)
80002b0e:	c84a                	sw	s2,16(sp)
80002b10:	c452                	sw	s4,8(sp)
80002b12:	842a                	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80002b14:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80002b18:	cfcd                	beqz	a5,80002bd2 <z_thread_timeout+0xd2>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002b1a:	44a1                	li	s1,8
80002b1c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002b20:	80005937          	lui	s2,0x80005
80002b24:	dd090513          	addi	a0,s2,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002b28:	88a1                	andi	s1,s1,8
80002b2a:	22f000ef          	jal	ra,80003558 <z_spin_lock_valid>
80002b2e:	ed0d                	bnez	a0,80002b68 <z_thread_timeout+0x68>
80002b30:	80005a37          	lui	s4,0x80005
80002b34:	800055b7          	lui	a1,0x80005
80002b38:	80004537          	lui	a0,0x80004
80002b3c:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80002b40:	04e00693          	li	a3,78
80002b44:	830a0613          	addi	a2,s4,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002b48:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002b4c:	b67fe0ef          	jal	ra,800016b2 <printk>
80002b50:	80005537          	lui	a0,0x80005
80002b54:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80002b58:	b5bfe0ef          	jal	ra,800016b2 <printk>
80002b5c:	04e00593          	li	a1,78
80002b60:	830a0513          	addi	a0,s4,-2000
80002b64:	b6dfe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002b68:	dd090513          	addi	a0,s2,-560
80002b6c:	229000ef          	jal	ra,80003594 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002b70:	ff040513          	addi	a0,s0,-16
80002b74:	f02ff0ef          	jal	ra,80002276 <pended_on.isra.15>
80002b78:	85ce                	mv	a1,s3
80002b7a:	b15ff0ef          	jal	ra,8000268e <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002b7e:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002b82:	dd090513          	addi	a0,s2,-560
80002b86:	9bf5                	andi	a5,a5,-3
80002b88:	fef40aa3          	sb	a5,-11(s0)
80002b8c:	1e7000ef          	jal	ra,80003572 <z_spin_unlock_valid>
80002b90:	ed0d                	bnez	a0,80002bca <z_thread_timeout+0xca>
80002b92:	80005937          	lui	s2,0x80005
80002b96:	800055b7          	lui	a1,0x80005
80002b9a:	80004537          	lui	a0,0x80004
80002b9e:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002ba2:	06100693          	li	a3,97
80002ba6:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002baa:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002bae:	b05fe0ef          	jal	ra,800016b2 <printk>
80002bb2:	80005537          	lui	a0,0x80005
80002bb6:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002bba:	af9fe0ef          	jal	ra,800016b2 <printk>
80002bbe:	06100593          	li	a1,97
80002bc2:	83090513          	addi	a0,s2,-2000
80002bc6:	b0bfe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002bca:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80002bce:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002bd2:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002bd6:	854e                	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002bd8:	9bad                	andi	a5,a5,-21
80002bda:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002bde:	e5eff0ef          	jal	ra,8000223c <z_is_thread_ready>
80002be2:	c911                	beqz	a0,80002bf6 <z_thread_timeout+0xf6>
}
80002be4:	4462                	lw	s0,24(sp)
80002be6:	40f2                	lw	ra,28(sp)
80002be8:	44d2                	lw	s1,20(sp)
80002bea:	4942                	lw	s2,16(sp)
80002bec:	4a22                	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80002bee:	854e                	mv	a0,s3
80002bf0:	49b2                	lw	s3,12(sp)
80002bf2:	6105                	addi	sp,sp,32
80002bf4:	b3d1                	j	800029b8 <z_add_thread_to_ready_q>
80002bf6:	40f2                	lw	ra,28(sp)
80002bf8:	4462                	lw	s0,24(sp)
80002bfa:	44d2                	lw	s1,20(sp)
80002bfc:	4942                	lw	s2,16(sp)
80002bfe:	49b2                	lw	s3,12(sp)
80002c00:	4a22                	lw	s4,8(sp)
80002c02:	6105                	addi	sp,sp,32
80002c04:	8082                	ret

80002c06 <z_move_thread_to_end_of_prio_q>:
{
80002c06:	1101                	addi	sp,sp,-32
80002c08:	cc22                	sw	s0,24(sp)
80002c0a:	c84a                	sw	s2,16(sp)
80002c0c:	ce06                	sw	ra,28(sp)
80002c0e:	ca26                	sw	s1,20(sp)
80002c10:	c64e                	sw	s3,12(sp)
80002c12:	c452                	sw	s4,8(sp)
80002c14:	c256                	sw	s5,4(sp)
80002c16:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002c18:	4921                	li	s2,8
80002c1a:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002c1e:	800059b7          	lui	s3,0x80005
80002c22:	dd098513          	addi	a0,s3,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002c26:	00897913          	andi	s2,s2,8
80002c2a:	12f000ef          	jal	ra,80003558 <z_spin_lock_valid>
80002c2e:	ed0d                	bnez	a0,80002c68 <z_move_thread_to_end_of_prio_q+0x62>
80002c30:	800054b7          	lui	s1,0x80005
80002c34:	800055b7          	lui	a1,0x80005
80002c38:	80004537          	lui	a0,0x80004
80002c3c:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80002c40:	04e00693          	li	a3,78
80002c44:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002c48:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002c4c:	a67fe0ef          	jal	ra,800016b2 <printk>
80002c50:	80005537          	lui	a0,0x80005
80002c54:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80002c58:	a5bfe0ef          	jal	ra,800016b2 <printk>
80002c5c:	04e00593          	li	a1,78
80002c60:	83048513          	addi	a0,s1,-2000
80002c64:	a6dfe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002c68:	dd098513          	addi	a0,s3,-560
80002c6c:	129000ef          	jal	ra,80003594 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80002c70:	800054b7          	lui	s1,0x80005
80002c74:	17c48513          	addi	a0,s1,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80002c78:	85a2                	mv	a1,s0
80002c7a:	02450513          	addi	a0,a0,36
80002c7e:	a11ff0ef          	jal	ra,8000268e <z_priq_dumb_remove>
	return thread == _idle_thread;
80002c82:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002c86:	d207a783          	lw	a5,-736(a5) # 80004d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d21>
80002c8a:	80005a37          	lui	s4,0x80005
80002c8e:	17c48493          	addi	s1,s1,380
80002c92:	1a0a0a13          	addi	s4,s4,416 # 800051a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a1>
80002c96:	02f41863          	bne	s0,a5,80002cc6 <z_move_thread_to_end_of_prio_q+0xc0>
80002c9a:	80005ab7          	lui	s5,0x80005
80002c9e:	800055b7          	lui	a1,0x80005
80002ca2:	80004537          	lui	a0,0x80004
80002ca6:	b3458593          	addi	a1,a1,-1228 # 80004b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b35>
80002caa:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002cae:	27600693          	li	a3,630
80002cb2:	ae8a8613          	addi	a2,s5,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
80002cb6:	9fdfe0ef          	jal	ra,800016b2 <printk>
80002cba:	27600593          	li	a1,630
80002cbe:	ae8a8513          	addi	a0,s5,-1304
80002cc2:	a0ffe0ef          	jal	ra,800016d0 <assert_post_action>
	return list->head == list;
80002cc6:	50dc                	lw	a5,36(s1)
80002cc8:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002cca:	09478a63          	beq	a5,s4,80002d5e <z_move_thread_to_end_of_prio_q+0x158>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002cce:	cbc1                	beqz	a5,80002d5e <z_move_thread_to_end_of_prio_q+0x158>
	if (t1->base.prio < t2->base.prio) {
80002cd0:	00e40683          	lb	a3,14(s0)
80002cd4:	00e78603          	lb	a2,14(a5)
80002cd8:	06c6df63          	bge	a3,a2,80002d56 <z_move_thread_to_end_of_prio_q+0x150>
	node->prev = successor->prev;
80002cdc:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002cde:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002ce0:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002ce2:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002ce4:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002ce6:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80002cea:	4488                	lw	a0,8(s1)
80002cec:	0407e793          	ori	a5,a5,64
80002cf0:	8d01                	sub	a0,a0,s0
80002cf2:	00153513          	seqz	a0,a0
80002cf6:	00f406a3          	sb	a5,13(s0)
80002cfa:	ad5ff0ef          	jal	ra,800027ce <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002cfe:	dd098513          	addi	a0,s3,-560
80002d02:	071000ef          	jal	ra,80003572 <z_spin_unlock_valid>
80002d06:	ed0d                	bnez	a0,80002d40 <z_move_thread_to_end_of_prio_q+0x13a>
80002d08:	80005437          	lui	s0,0x80005
80002d0c:	800055b7          	lui	a1,0x80005
80002d10:	80004537          	lui	a0,0x80004
80002d14:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002d18:	06100693          	li	a3,97
80002d1c:	83040613          	addi	a2,s0,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002d20:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002d24:	98ffe0ef          	jal	ra,800016b2 <printk>
80002d28:	80005537          	lui	a0,0x80005
80002d2c:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002d30:	983fe0ef          	jal	ra,800016b2 <printk>
80002d34:	06100593          	li	a1,97
80002d38:	83040513          	addi	a0,s0,-2000
80002d3c:	995fe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d40:	30092973          	csrrs	s2,mstatus,s2
}
80002d44:	40f2                	lw	ra,28(sp)
80002d46:	4462                	lw	s0,24(sp)
80002d48:	44d2                	lw	s1,20(sp)
80002d4a:	4942                	lw	s2,16(sp)
80002d4c:	49b2                	lw	s3,12(sp)
80002d4e:	4a22                	lw	s4,8(sp)
80002d50:	4a92                	lw	s5,4(sp)
80002d52:	6105                	addi	sp,sp,32
80002d54:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
80002d56:	00e78463          	beq	a5,a4,80002d5e <z_move_thread_to_end_of_prio_q+0x158>
80002d5a:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002d5c:	ffa5                	bnez	a5,80002cd4 <z_move_thread_to_end_of_prio_q+0xce>
	node->prev = list->tail;
80002d5e:	c058                	sw	a4,4(s0)
	list->tail->next = node;
80002d60:	549c                	lw	a5,40(s1)
	node->next = list;
80002d62:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80002d66:	c380                	sw	s0,0(a5)
	list->tail = node;
80002d68:	d480                	sw	s0,40(s1)
80002d6a:	bfb5                	j	80002ce6 <z_move_thread_to_end_of_prio_q+0xe0>

80002d6c <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80002d6c:	800057b7          	lui	a5,0x80005
80002d70:	dd87a783          	lw	a5,-552(a5) # 80004dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd9>
80002d74:	cba9                	beqz	a5,80002dc6 <z_time_slice+0x5a>
80002d76:	800057b7          	lui	a5,0x80005
80002d7a:	17c78793          	addi	a5,a5,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80002d7e:	4798                	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80002d80:	07f00693          	li	a3,127
80002d84:	00e75603          	lhu	a2,14(a4)
80002d88:	02c6ef63          	bltu	a3,a2,80002dc6 <z_time_slice+0x5a>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80002d8c:	800056b7          	lui	a3,0x80005
80002d90:	00e70603          	lb	a2,14(a4)
80002d94:	dd46a683          	lw	a3,-556(a3) # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80002d98:	02d64763          	blt	a2,a3,80002dc6 <z_time_slice+0x5a>
	return thread == _idle_thread;
80002d9c:	800056b7          	lui	a3,0x80005
		&& !is_idle(t)
80002da0:	d206a683          	lw	a3,-736(a3) # 80004d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d21>
80002da4:	02d70163          	beq	a4,a3,80002dc6 <z_time_slice+0x5a>
		&& !z_is_thread_timeout_active(t);
80002da8:	4f14                	lw	a3,24(a4)
80002daa:	ee91                	bnez	a3,80002dc6 <z_time_slice+0x5a>
		if (ticks >= _current_cpu->slice_ticks) {
80002dac:	4b94                	lw	a3,16(a5)
80002dae:	00d54a63          	blt	a0,a3,80002dc2 <z_time_slice+0x56>
{
80002db2:	1141                	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80002db4:	853a                	mv	a0,a4
{
80002db6:	c606                	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80002db8:	35b9                	jal	80002c06 <z_move_thread_to_end_of_prio_q>
}
80002dba:	40b2                	lw	ra,12(sp)
80002dbc:	0141                	addi	sp,sp,16
			reset_time_slice();
80002dbe:	c92ff06f          	j	80002250 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80002dc2:	8e89                	sub	a3,a3,a0
80002dc4:	cb94                	sw	a3,16(a5)
80002dc6:	8082                	ret

80002dc8 <z_remove_thread_from_ready_q>:
{
80002dc8:	1101                	addi	sp,sp,-32
80002dca:	cc22                	sw	s0,24(sp)
80002dcc:	c64e                	sw	s3,12(sp)
80002dce:	ce06                	sw	ra,28(sp)
80002dd0:	ca26                	sw	s1,20(sp)
80002dd2:	c84a                	sw	s2,16(sp)
80002dd4:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002dd6:	4421                	li	s0,8
80002dd8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002ddc:	800054b7          	lui	s1,0x80005
80002de0:	dd048513          	addi	a0,s1,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002de4:	8821                	andi	s0,s0,8
80002de6:	772000ef          	jal	ra,80003558 <z_spin_lock_valid>
80002dea:	ed0d                	bnez	a0,80002e24 <z_remove_thread_from_ready_q+0x5c>
80002dec:	80005937          	lui	s2,0x80005
80002df0:	800055b7          	lui	a1,0x80005
80002df4:	80004537          	lui	a0,0x80004
80002df8:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80002dfc:	04e00693          	li	a3,78
80002e00:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002e04:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002e08:	8abfe0ef          	jal	ra,800016b2 <printk>
80002e0c:	80005537          	lui	a0,0x80005
80002e10:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80002e14:	89ffe0ef          	jal	ra,800016b2 <printk>
80002e18:	04e00593          	li	a1,78
80002e1c:	83090513          	addi	a0,s2,-2000
80002e20:	8b1fe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80002e24:	dd048513          	addi	a0,s1,-560
80002e28:	76c000ef          	jal	ra,80003594 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80002e2c:	00d9c783          	lbu	a5,13(s3)
80002e30:	80005937          	lui	s2,0x80005
80002e34:	17c90913          	addi	s2,s2,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80002e38:	0407f793          	andi	a5,a5,64
80002e3c:	cf81                	beqz	a5,80002e54 <z_remove_thread_from_ready_q+0x8c>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80002e3e:	85ce                	mv	a1,s3
80002e40:	02490513          	addi	a0,s2,36
80002e44:	84bff0ef          	jal	ra,8000268e <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80002e48:	00d9c783          	lbu	a5,13(s3)
80002e4c:	fbf7f793          	andi	a5,a5,-65
80002e50:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80002e54:	00892503          	lw	a0,8(s2)
80002e58:	41350533          	sub	a0,a0,s3
80002e5c:	00153513          	seqz	a0,a0
80002e60:	96fff0ef          	jal	ra,800027ce <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002e64:	dd048513          	addi	a0,s1,-560
80002e68:	70a000ef          	jal	ra,80003572 <z_spin_unlock_valid>
80002e6c:	ed0d                	bnez	a0,80002ea6 <z_remove_thread_from_ready_q+0xde>
80002e6e:	800054b7          	lui	s1,0x80005
80002e72:	800055b7          	lui	a1,0x80005
80002e76:	80004537          	lui	a0,0x80004
80002e7a:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002e7e:	06100693          	li	a3,97
80002e82:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002e86:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002e8a:	829fe0ef          	jal	ra,800016b2 <printk>
80002e8e:	80005537          	lui	a0,0x80005
80002e92:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002e96:	81dfe0ef          	jal	ra,800016b2 <printk>
80002e9a:	06100593          	li	a1,97
80002e9e:	83048513          	addi	a0,s1,-2000
80002ea2:	82ffe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ea6:	30042473          	csrrs	s0,mstatus,s0
}
80002eaa:	40f2                	lw	ra,28(sp)
80002eac:	4462                	lw	s0,24(sp)
80002eae:	44d2                	lw	s1,20(sp)
80002eb0:	4942                	lw	s2,16(sp)
80002eb2:	49b2                	lw	s3,12(sp)
80002eb4:	6105                	addi	sp,sp,32
80002eb6:	8082                	ret

80002eb8 <pend>:
{
80002eb8:	1101                	addi	sp,sp,-32
80002eba:	cc22                	sw	s0,24(sp)
80002ebc:	ca26                	sw	s1,20(sp)
80002ebe:	842a                	mv	s0,a0
80002ec0:	c84a                	sw	s2,16(sp)
80002ec2:	ce06                	sw	ra,28(sp)
80002ec4:	c64e                	sw	s3,12(sp)
80002ec6:	84ae                	mv	s1,a1
80002ec8:	8932                	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80002eca:	3dfd                	jal	80002dc8 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80002ecc:	00d44783          	lbu	a5,13(s0)
80002ed0:	0027e793          	ori	a5,a5,2
80002ed4:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80002ed8:	cca9                	beqz	s1,80002f32 <pend+0x7a>
	return thread == _idle_thread;
80002eda:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002ede:	d207a783          	lw	a5,-736(a5) # 80004d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d21>
		thread->base.pended_on = wait_q;
80002ee2:	c404                	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80002ee4:	02f41863          	bne	s0,a5,80002f14 <pend+0x5c>
80002ee8:	800059b7          	lui	s3,0x80005
80002eec:	800055b7          	lui	a1,0x80005
80002ef0:	80004537          	lui	a0,0x80004
80002ef4:	b3458593          	addi	a1,a1,-1228 # 80004b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b35>
80002ef8:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002efc:	27600693          	li	a3,630
80002f00:	ae898613          	addi	a2,s3,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
80002f04:	faefe0ef          	jal	ra,800016b2 <printk>
80002f08:	27600593          	li	a1,630
80002f0c:	ae898513          	addi	a0,s3,-1304
80002f10:	fc0fe0ef          	jal	ra,800016d0 <assert_post_action>
	return list->head == list;
80002f14:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002f16:	04f48b63          	beq	s1,a5,80002f6c <pend+0xb4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002f1a:	cba9                	beqz	a5,80002f6c <pend+0xb4>
	if (t1->base.prio < t2->base.prio) {
80002f1c:	00e40703          	lb	a4,14(s0)
80002f20:	00e78683          	lb	a3,14(a5)
80002f24:	02d75f63          	bge	a4,a3,80002f62 <pend+0xaa>
	node->prev = successor->prev;
80002f28:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002f2a:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002f2c:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002f2e:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002f30:	c3c0                	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80002f32:	57fd                	li	a5,-1
80002f34:	04f90363          	beq	s2,a5,80002f7a <pend+0xc2>
80002f38:	45a9                	li	a1,10
80002f3a:	00990513          	addi	a0,s2,9
80002f3e:	903fd0ef          	jal	ra,80000840 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80002f42:	00150613          	addi	a2,a0,1
80002f46:	01840513          	addi	a0,s0,24
}
80002f4a:	4462                	lw	s0,24(sp)
80002f4c:	40f2                	lw	ra,28(sp)
80002f4e:	44d2                	lw	s1,20(sp)
80002f50:	4942                	lw	s2,16(sp)
80002f52:	49b2                	lw	s3,12(sp)
80002f54:	800035b7          	lui	a1,0x80003
80002f58:	b0058593          	addi	a1,a1,-1280 # 80002b00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002b01>
80002f5c:	6105                	addi	sp,sp,32
80002f5e:	1c90006f          	j	80003926 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80002f62:	40d4                	lw	a3,4(s1)
80002f64:	00d78463          	beq	a5,a3,80002f6c <pend+0xb4>
80002f68:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002f6a:	fbdd                	bnez	a5,80002f20 <pend+0x68>
	node->prev = list->tail;
80002f6c:	40dc                	lw	a5,4(s1)
	node->next = list;
80002f6e:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80002f70:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80002f72:	40dc                	lw	a5,4(s1)
80002f74:	c380                	sw	s0,0(a5)
	list->tail = node;
80002f76:	c0c0                	sw	s0,4(s1)
80002f78:	bf6d                	j	80002f32 <pend+0x7a>
}
80002f7a:	40f2                	lw	ra,28(sp)
80002f7c:	4462                	lw	s0,24(sp)
80002f7e:	44d2                	lw	s1,20(sp)
80002f80:	4942                	lw	s2,16(sp)
80002f82:	49b2                	lw	s3,12(sp)
80002f84:	6105                	addi	sp,sp,32
80002f86:	8082                	ret

80002f88 <z_pend_curr_irqlock>:
{
80002f88:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80002f8a:	800057b7          	lui	a5,0x80005
{
80002f8e:	c422                	sw	s0,8(sp)
80002f90:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80002f92:	1847a503          	lw	a0,388(a5) # 80005184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005185>
{
80002f96:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80002f98:	3705                	jal	80002eb8 <pend>
80002f9a:	8522                	mv	a0,s0
}
80002f9c:	4422                	lw	s0,8(sp)
80002f9e:	40b2                	lw	ra,12(sp)
80002fa0:	0141                	addi	sp,sp,16
80002fa2:	a1efd06f          	j	800001c0 <__swap>

80002fa6 <z_pend_curr>:
{
80002fa6:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80002fa8:	800057b7          	lui	a5,0x80005
{
80002fac:	c422                	sw	s0,8(sp)
80002fae:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80002fb0:	1847a503          	lw	a0,388(a5) # 80005184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005185>
{
80002fb4:	c226                	sw	s1,4(sp)
80002fb6:	84ae                	mv	s1,a1
80002fb8:	85b2                	mv	a1,a2
	pend(_current, wait_q, timeout);
80002fba:	8636                	mv	a2,a3
{
80002fbc:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80002fbe:	3ded                	jal	80002eb8 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002fc0:	8522                	mv	a0,s0
80002fc2:	2b45                	jal	80003572 <z_spin_unlock_valid>
80002fc4:	ed0d                	bnez	a0,80002ffe <z_pend_curr+0x58>
80002fc6:	80005437          	lui	s0,0x80005
80002fca:	800055b7          	lui	a1,0x80005
80002fce:	80004537          	lui	a0,0x80004
80002fd2:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80002fd6:	07800693          	li	a3,120
80002fda:	83040613          	addi	a2,s0,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80002fde:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80002fe2:	ed0fe0ef          	jal	ra,800016b2 <printk>
80002fe6:	80005537          	lui	a0,0x80005
80002fea:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80002fee:	ec4fe0ef          	jal	ra,800016b2 <printk>
80002ff2:	07800593          	li	a1,120
80002ff6:	83040513          	addi	a0,s0,-2000
80002ffa:	ed6fe0ef          	jal	ra,800016d0 <assert_post_action>
}
80002ffe:	4422                	lw	s0,8(sp)
80003000:	40b2                	lw	ra,12(sp)
80003002:	8526                	mv	a0,s1
80003004:	4492                	lw	s1,4(sp)
80003006:	0141                	addi	sp,sp,16
80003008:	9b8fd06f          	j	800001c0 <__swap>

8000300c <z_unpend_first_thread>:
{
8000300c:	1101                	addi	sp,sp,-32
8000300e:	c84a                	sw	s2,16(sp)
80003010:	c64e                	sw	s3,12(sp)
80003012:	ce06                	sw	ra,28(sp)
80003014:	cc22                	sw	s0,24(sp)
80003016:	ca26                	sw	s1,20(sp)
80003018:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000301a:	4921                	li	s2,8
8000301c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003020:	800054b7          	lui	s1,0x80005
80003024:	dd048513          	addi	a0,s1,-560 # 80004dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003028:	00897913          	andi	s2,s2,8
8000302c:	2335                	jal	80003558 <z_spin_lock_valid>
8000302e:	ed0d                	bnez	a0,80003068 <z_unpend_first_thread+0x5c>
80003030:	80005437          	lui	s0,0x80005
80003034:	800055b7          	lui	a1,0x80005
80003038:	80004537          	lui	a0,0x80004
8000303c:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80003040:	04e00693          	li	a3,78
80003044:	83040613          	addi	a2,s0,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003048:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000304c:	e66fe0ef          	jal	ra,800016b2 <printk>
80003050:	80005537          	lui	a0,0x80005
80003054:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80003058:	e5afe0ef          	jal	ra,800016b2 <printk>
8000305c:	04e00593          	li	a1,78
80003060:	83040513          	addi	a0,s0,-2000
80003064:	e6cfe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003068:	dd048513          	addi	a0,s1,-560
8000306c:	2325                	jal	80003594 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
8000306e:	854e                	mv	a0,s3
80003070:	f52ff0ef          	jal	ra,800027c2 <z_priq_dumb_best>
80003074:	842a                	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003076:	dd048513          	addi	a0,s1,-560
8000307a:	29e5                	jal	80003572 <z_spin_unlock_valid>
8000307c:	ed0d                	bnez	a0,800030b6 <z_unpend_first_thread+0xaa>
8000307e:	800059b7          	lui	s3,0x80005
80003082:	800055b7          	lui	a1,0x80005
80003086:	80004537          	lui	a0,0x80004
8000308a:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
8000308e:	06100693          	li	a3,97
80003092:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003096:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
8000309a:	e18fe0ef          	jal	ra,800016b2 <printk>
8000309e:	80005537          	lui	a0,0x80005
800030a2:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
800030a6:	e0cfe0ef          	jal	ra,800016b2 <printk>
800030aa:	06100593          	li	a1,97
800030ae:	83098513          	addi	a0,s3,-2000
800030b2:	e1efe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800030b6:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
800030ba:	cc4d                	beqz	s0,80003174 <z_unpend_first_thread+0x168>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800030bc:	4921                	li	s2,8
800030be:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800030c2:	dd048513          	addi	a0,s1,-560
	key = (mstatus & SOC_MSTATUS_IEN);
800030c6:	00897913          	andi	s2,s2,8
800030ca:	2179                	jal	80003558 <z_spin_lock_valid>
800030cc:	ed0d                	bnez	a0,80003106 <z_unpend_first_thread+0xfa>
800030ce:	800059b7          	lui	s3,0x80005
800030d2:	800055b7          	lui	a1,0x80005
800030d6:	80004537          	lui	a0,0x80004
800030da:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800030de:	04e00693          	li	a3,78
800030e2:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800030e6:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800030ea:	dc8fe0ef          	jal	ra,800016b2 <printk>
800030ee:	80005537          	lui	a0,0x80005
800030f2:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
800030f6:	dbcfe0ef          	jal	ra,800016b2 <printk>
800030fa:	04e00593          	li	a1,78
800030fe:	83098513          	addi	a0,s3,-2000
80003102:	dcefe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003106:	dd048513          	addi	a0,s1,-560
8000310a:	2169                	jal	80003594 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000310c:	00840513          	addi	a0,s0,8
80003110:	966ff0ef          	jal	ra,80002276 <pended_on.isra.15>
80003114:	85a2                	mv	a1,s0
80003116:	d78ff0ef          	jal	ra,8000268e <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000311a:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000311e:	dd048513          	addi	a0,s1,-560
80003122:	9bf5                	andi	a5,a5,-3
80003124:	00f406a3          	sb	a5,13(s0)
80003128:	21a9                	jal	80003572 <z_spin_unlock_valid>
8000312a:	ed0d                	bnez	a0,80003164 <z_unpend_first_thread+0x158>
8000312c:	800054b7          	lui	s1,0x80005
80003130:	800055b7          	lui	a1,0x80005
80003134:	80004537          	lui	a0,0x80004
80003138:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
8000313c:	06100693          	li	a3,97
80003140:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003144:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003148:	d6afe0ef          	jal	ra,800016b2 <printk>
8000314c:	80005537          	lui	a0,0x80005
80003150:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003154:	d5efe0ef          	jal	ra,800016b2 <printk>
80003158:	06100593          	li	a1,97
8000315c:	83048513          	addi	a0,s1,-2000
80003160:	d70fe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003164:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80003168:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
8000316c:	01840513          	addi	a0,s0,24
80003170:	17f000ef          	jal	ra,80003aee <z_abort_timeout>
}
80003174:	8522                	mv	a0,s0
80003176:	40f2                	lw	ra,28(sp)
80003178:	4462                	lw	s0,24(sp)
8000317a:	44d2                	lw	s1,20(sp)
8000317c:	4942                	lw	s2,16(sp)
8000317e:	49b2                	lw	s3,12(sp)
80003180:	6105                	addi	sp,sp,32
80003182:	8082                	ret

80003184 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80003184:	1141                	addi	sp,sp,-16
80003186:	c226                	sw	s1,4(sp)
80003188:	c04a                	sw	s2,0(sp)
8000318a:	c606                	sw	ra,12(sp)
8000318c:	c422                	sw	s0,8(sp)
8000318e:	892a                	mv	s2,a0
	int need_sched = 0;
80003190:	4481                	li	s1,0
	return list->head == list;
80003192:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003196:	00890363          	beq	s2,s0,8000319c <z_unpend_all+0x18>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
8000319a:	e801                	bnez	s0,800031aa <z_unpend_all+0x26>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
8000319c:	40b2                	lw	ra,12(sp)
8000319e:	4422                	lw	s0,8(sp)
800031a0:	8526                	mv	a0,s1
800031a2:	4902                	lw	s2,0(sp)
800031a4:	4492                	lw	s1,4(sp)
800031a6:	0141                	addi	sp,sp,16
800031a8:	8082                	ret
		z_unpend_thread(th);
800031aa:	8522                	mv	a0,s0
800031ac:	d3eff0ef          	jal	ra,800026ea <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
800031b0:	8522                	mv	a0,s0
800031b2:	88aff0ef          	jal	ra,8000223c <z_is_thread_ready>
		need_sched = 1;
800031b6:	4485                	li	s1,1
800031b8:	dd69                	beqz	a0,80003192 <z_unpend_all+0xe>
		z_add_thread_to_ready_q(thread);
800031ba:	8522                	mv	a0,s0
800031bc:	ffcff0ef          	jal	ra,800029b8 <z_add_thread_to_ready_q>
800031c0:	bfc9                	j	80003192 <z_unpend_all+0xe>

800031c2 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
800031c2:	800057b7          	lui	a5,0x80005
800031c6:	17c78793          	addi	a5,a5,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
800031ca:	02478713          	addi	a4,a5,36
800031ce:	d3d8                	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
800031d0:	d798                	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
800031d2:	4581                	li	a1,0
800031d4:	4505                	li	a0,1
800031d6:	8e6ff06f          	j	800022bc <k_sched_time_slice_set>

800031da <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800031da:	800057b7          	lui	a5,0x80005
800031de:	1847a503          	lw	a0,388(a5) # 80005184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005185>
800031e2:	8082                	ret

800031e4 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800031e4:	1101                	addi	sp,sp,-32
800031e6:	cc22                	sw	s0,24(sp)
800031e8:	ca26                	sw	s1,20(sp)
800031ea:	c84a                	sw	s2,16(sp)
800031ec:	ce06                	sw	ra,28(sp)
800031ee:	c64e                	sw	s3,12(sp)
800031f0:	842a                	mv	s0,a0
800031f2:	892e                	mv	s2,a1
800031f4:	84b2                	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
800031f6:	ee0d                	bnez	a2,80003230 <z_impl_k_sem_init+0x4c>
800031f8:	800059b7          	lui	s3,0x80005
800031fc:	800055b7          	lui	a1,0x80005
80003200:	80004537          	lui	a0,0x80004
80003204:	b5858593          	addi	a1,a1,-1192 # 80004b58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b59>
80003208:	04600693          	li	a3,70
8000320c:	b4898613          	addi	a2,s3,-1208 # 80004b48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b49>
80003210:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003214:	c9efe0ef          	jal	ra,800016b2 <printk>
80003218:	80005537          	lui	a0,0x80005
8000321c:	b6450513          	addi	a0,a0,-1180 # 80004b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b65>
80003220:	c92fe0ef          	jal	ra,800016b2 <printk>
80003224:	04600593          	li	a1,70
80003228:	b4898513          	addi	a0,s3,-1208
8000322c:	ca4fe0ef          	jal	ra,800016d0 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003230:	0324fe63          	bgeu	s1,s2,8000326c <z_impl_k_sem_init+0x88>
80003234:	800059b7          	lui	s3,0x80005
80003238:	800055b7          	lui	a1,0x80005
8000323c:	80004537          	lui	a0,0x80004
80003240:	b7c58593          	addi	a1,a1,-1156 # 80004b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b7d>
80003244:	04700693          	li	a3,71
80003248:	b4898613          	addi	a2,s3,-1208 # 80004b48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b49>
8000324c:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003250:	c62fe0ef          	jal	ra,800016b2 <printk>
80003254:	80005537          	lui	a0,0x80005
80003258:	b9450513          	addi	a0,a0,-1132 # 80004b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b95>
8000325c:	c56fe0ef          	jal	ra,800016b2 <printk>
80003260:	04700593          	li	a1,71
80003264:	b4898513          	addi	a0,s3,-1208
80003268:	c68fe0ef          	jal	ra,800016d0 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
8000326c:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80003270:	c444                	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80003272:	c000                	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80003274:	c040                	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80003276:	40f2                	lw	ra,28(sp)
80003278:	4462                	lw	s0,24(sp)
8000327a:	44d2                	lw	s1,20(sp)
8000327c:	4942                	lw	s2,16(sp)
8000327e:	49b2                	lw	s3,12(sp)
80003280:	6105                	addi	sp,sp,32
80003282:	8082                	ret

80003284 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80003284:	1101                	addi	sp,sp,-32
80003286:	ca26                	sw	s1,20(sp)
80003288:	c64e                	sw	s3,12(sp)
8000328a:	ce06                	sw	ra,28(sp)
8000328c:	cc22                	sw	s0,24(sp)
8000328e:	c84a                	sw	s2,16(sp)
80003290:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003292:	44a1                	li	s1,8
80003294:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003298:	80005437          	lui	s0,0x80005
8000329c:	ddc40513          	addi	a0,s0,-548 # 80004ddc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ddd>
	key = (mstatus & SOC_MSTATUS_IEN);
800032a0:	88a1                	andi	s1,s1,8
800032a2:	2c5d                	jal	80003558 <z_spin_lock_valid>
800032a4:	ed0d                	bnez	a0,800032de <z_impl_k_sem_give+0x5a>
800032a6:	80005937          	lui	s2,0x80005
800032aa:	800055b7          	lui	a1,0x80005
800032ae:	80004537          	lui	a0,0x80004
800032b2:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800032b6:	04e00693          	li	a3,78
800032ba:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800032be:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800032c2:	bf0fe0ef          	jal	ra,800016b2 <printk>
800032c6:	80005537          	lui	a0,0x80005
800032ca:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
800032ce:	be4fe0ef          	jal	ra,800016b2 <printk>
800032d2:	04e00593          	li	a1,78
800032d6:	83090513          	addi	a0,s2,-2000
800032da:	bf6fe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
800032de:	ddc40513          	addi	a0,s0,-548
800032e2:	2c4d                	jal	80003594 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
800032e4:	854e                	mv	a0,s3
800032e6:	d27ff0ef          	jal	ra,8000300c <z_unpend_first_thread>
800032ea:	892a                	mv	s2,a0
	if (thread != NULL) {
800032ec:	c515                	beqz	a0,80003318 <z_impl_k_sem_give+0x94>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800032ee:	00d54783          	lbu	a5,13(a0)
800032f2:	8bfd                	andi	a5,a5,31
800032f4:	e789                	bnez	a5,800032fe <z_impl_k_sem_give+0x7a>
	if (z_is_thread_ready(thread)) {
800032f6:	4d1c                	lw	a5,24(a0)
800032f8:	e399                	bnez	a5,800032fe <z_impl_k_sem_give+0x7a>
		z_add_thread_to_ready_q(thread);
800032fa:	ebeff0ef          	jal	ra,800029b8 <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
800032fe:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80003302:	ddc40513          	addi	a0,s0,-548
}
80003306:	4462                	lw	s0,24(sp)
80003308:	40f2                	lw	ra,28(sp)
8000330a:	4942                	lw	s2,16(sp)
8000330c:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
8000330e:	85a6                	mv	a1,s1
}
80003310:	44d2                	lw	s1,20(sp)
80003312:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003314:	95aff06f          	j	8000246e <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80003318:	0089a703          	lw	a4,8(s3)
8000331c:	00c9a783          	lw	a5,12(s3)
80003320:	8f99                	sub	a5,a5,a4
80003322:	00f037b3          	snez	a5,a5
80003326:	97ba                	add	a5,a5,a4
80003328:	00f9a423          	sw	a5,8(s3)
8000332c:	bfd9                	j	80003302 <z_impl_k_sem_give+0x7e>

8000332e <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000332e:	800057b7          	lui	a5,0x80005
80003332:	17c7a783          	lw	a5,380(a5) # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
{
80003336:	1101                	addi	sp,sp,-32
80003338:	c84a                	sw	s2,16(sp)
8000333a:	c64e                	sw	s3,12(sp)
8000333c:	ce06                	sw	ra,28(sp)
8000333e:	cc22                	sw	s0,24(sp)
80003340:	ca26                	sw	s1,20(sp)
80003342:	c452                	sw	s4,8(sp)
80003344:	892a                	mv	s2,a0
80003346:	89ae                	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003348:	cf95                	beqz	a5,80003384 <z_impl_k_sem_take+0x56>
8000334a:	cd8d                	beqz	a1,80003384 <z_impl_k_sem_take+0x56>
8000334c:	80005437          	lui	s0,0x80005
80003350:	800055b7          	lui	a1,0x80005
80003354:	80004537          	lui	a0,0x80004
80003358:	bbc58593          	addi	a1,a1,-1092 # 80004bbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bbd>
8000335c:	08c00693          	li	a3,140
80003360:	b4840613          	addi	a2,s0,-1208 # 80004b48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b49>
80003364:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003368:	b4afe0ef          	jal	ra,800016b2 <printk>
8000336c:	80004537          	lui	a0,0x80004
80003370:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
80003374:	b3efe0ef          	jal	ra,800016b2 <printk>
80003378:	08c00593          	li	a1,140
8000337c:	b4840513          	addi	a0,s0,-1208
80003380:	b50fe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003384:	4421                	li	s0,8
80003386:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000338a:	800054b7          	lui	s1,0x80005
8000338e:	ddc48513          	addi	a0,s1,-548 # 80004ddc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ddd>
	key = (mstatus & SOC_MSTATUS_IEN);
80003392:	8821                	andi	s0,s0,8
80003394:	22d1                	jal	80003558 <z_spin_lock_valid>
80003396:	ed0d                	bnez	a0,800033d0 <z_impl_k_sem_take+0xa2>
80003398:	80005a37          	lui	s4,0x80005
8000339c:	800055b7          	lui	a1,0x80005
800033a0:	80004537          	lui	a0,0x80004
800033a4:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800033a8:	04e00693          	li	a3,78
800033ac:	830a0613          	addi	a2,s4,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800033b0:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800033b4:	afefe0ef          	jal	ra,800016b2 <printk>
800033b8:	80005537          	lui	a0,0x80005
800033bc:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
800033c0:	af2fe0ef          	jal	ra,800016b2 <printk>
800033c4:	04e00593          	li	a1,78
800033c8:	830a0513          	addi	a0,s4,-2000
800033cc:	b04fe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
800033d0:	ddc48513          	addi	a0,s1,-548
800033d4:	22c1                	jal	80003594 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
800033d6:	00892783          	lw	a5,8(s2)
800033da:	cfb9                	beqz	a5,80003438 <z_impl_k_sem_take+0x10a>
		sem->count--;
800033dc:	17fd                	addi	a5,a5,-1
800033de:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800033e2:	ddc48513          	addi	a0,s1,-548
800033e6:	2271                	jal	80003572 <z_spin_unlock_valid>
800033e8:	ed0d                	bnez	a0,80003422 <z_impl_k_sem_take+0xf4>
800033ea:	800054b7          	lui	s1,0x80005
800033ee:	800055b7          	lui	a1,0x80005
800033f2:	80004537          	lui	a0,0x80004
800033f6:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
800033fa:	06100693          	li	a3,97
800033fe:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003402:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003406:	aacfe0ef          	jal	ra,800016b2 <printk>
8000340a:	80005537          	lui	a0,0x80005
8000340e:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003412:	aa0fe0ef          	jal	ra,800016b2 <printk>
80003416:	06100593          	li	a1,97
8000341a:	83048513          	addi	a0,s1,-2000
8000341e:	ab2fe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003422:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80003426:	4501                	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80003428:	40f2                	lw	ra,28(sp)
8000342a:	4462                	lw	s0,24(sp)
8000342c:	44d2                	lw	s1,20(sp)
8000342e:	4942                	lw	s2,16(sp)
80003430:	49b2                	lw	s3,12(sp)
80003432:	4a22                	lw	s4,8(sp)
80003434:	6105                	addi	sp,sp,32
80003436:	8082                	ret
	if (timeout == K_NO_WAIT) {
80003438:	04099663          	bnez	s3,80003484 <z_impl_k_sem_take+0x156>
8000343c:	ddc48513          	addi	a0,s1,-548
80003440:	2a0d                	jal	80003572 <z_spin_unlock_valid>
80003442:	ed0d                	bnez	a0,8000347c <z_impl_k_sem_take+0x14e>
80003444:	800054b7          	lui	s1,0x80005
80003448:	800055b7          	lui	a1,0x80005
8000344c:	80004537          	lui	a0,0x80004
80003450:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80003454:	06100693          	li	a3,97
80003458:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
8000345c:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003460:	a52fe0ef          	jal	ra,800016b2 <printk>
80003464:	80005537          	lui	a0,0x80005
80003468:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
8000346c:	a46fe0ef          	jal	ra,800016b2 <printk>
80003470:	06100593          	li	a1,97
80003474:	83048513          	addi	a0,s1,-2000
80003478:	a58fe0ef          	jal	ra,800016d0 <assert_post_action>
8000347c:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80003480:	5541                	li	a0,-16
80003482:	b75d                	j	80003428 <z_impl_k_sem_take+0xfa>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80003484:	85a2                	mv	a1,s0
}
80003486:	4462                	lw	s0,24(sp)
80003488:	40f2                	lw	ra,28(sp)
8000348a:	4a22                	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000348c:	86ce                	mv	a3,s3
8000348e:	864a                	mv	a2,s2
}
80003490:	49b2                	lw	s3,12(sp)
80003492:	4942                	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80003494:	ddc48513          	addi	a0,s1,-548
}
80003498:	44d2                	lw	s1,20(sp)
8000349a:	6105                	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000349c:	b0bff06f          	j	80002fa6 <z_pend_curr>

800034a0 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800034a0:	00d54783          	lbu	a5,13(a0)
800034a4:	8bfd                	andi	a5,a5,31
800034a6:	e789                	bnez	a5,800034b0 <z_is_thread_ready+0x10>
800034a8:	4d08                	lw	a0,24(a0)
800034aa:	00153513          	seqz	a0,a0
800034ae:	8082                	ret
800034b0:	4501                	li	a0,0
}
800034b2:	8082                	ret

800034b4 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800034b4:	800057b7          	lui	a5,0x80005
800034b8:	17c7a503          	lw	a0,380(a5) # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
}
800034bc:	00a03533          	snez	a0,a0
800034c0:	8082                	ret

800034c2 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800034c2:	800057b7          	lui	a5,0x80005
800034c6:	1847a783          	lw	a5,388(a5) # 80005184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005185>
800034ca:	00c7c503          	lbu	a0,12(a5)
}
800034ce:	8905                	andi	a0,a0,1
800034d0:	8082                	ret

800034d2 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
800034d2:	1101                	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800034d4:	5302                	lw	t1,32(sp)
{
800034d6:	cc22                	sw	s0,24(sp)
800034d8:	ce06                	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800034da:	c01a                	sw	t1,0(sp)
{
800034dc:	842a                	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800034de:	f54fd0ef          	jal	ra,80000c32 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
800034e2:	800057b7          	lui	a5,0x80005
800034e6:	1847a783          	lw	a5,388(a5) # 80005184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005185>
	sys_trace_thread_create(new_thread);
}
800034ea:	40f2                	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
800034ec:	57bc                	lw	a5,104(a5)
800034ee:	d43c                	sw	a5,104(s0)
}
800034f0:	4462                	lw	s0,24(sp)
800034f2:	6105                	addi	sp,sp,32
800034f4:	8082                	ret

800034f6 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
800034f6:	513c                	lw	a5,96(a0)
{
800034f8:	1141                	addi	sp,sp,-16
800034fa:	c422                	sw	s0,8(sp)
800034fc:	c606                	sw	ra,12(sp)
800034fe:	842a                	mv	s0,a0
	if (thread->fn_abort != NULL) {
80003500:	c391                	beqz	a5,80003504 <z_thread_single_abort+0xe>
		thread->fn_abort();
80003502:	9782                	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80003504:	8522                	mv	a0,s0
80003506:	3f69                	jal	800034a0 <z_is_thread_ready>
80003508:	cd11                	beqz	a0,80003524 <z_thread_single_abort+0x2e>
		z_remove_thread_from_ready_q(thread);
8000350a:	8522                	mv	a0,s0
8000350c:	8bdff0ef          	jal	ra,80002dc8 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80003510:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80003514:	40b2                	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80003516:	0087e793          	ori	a5,a5,8
8000351a:	00f406a3          	sb	a5,13(s0)
}
8000351e:	4422                	lw	s0,8(sp)
80003520:	0141                	addi	sp,sp,16
80003522:	8082                	ret
		if (z_is_thread_pending(thread)) {
80003524:	00d44783          	lbu	a5,13(s0)
80003528:	8b89                	andi	a5,a5,2
8000352a:	c781                	beqz	a5,80003532 <z_thread_single_abort+0x3c>
			z_unpend_thread_no_timeout(thread);
8000352c:	8522                	mv	a0,s0
8000352e:	e71fe0ef          	jal	ra,8000239e <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80003532:	4c1c                	lw	a5,24(s0)
80003534:	dff1                	beqz	a5,80003510 <z_thread_single_abort+0x1a>
80003536:	01840513          	addi	a0,s0,24
8000353a:	2b55                	jal	80003aee <z_abort_timeout>
8000353c:	bfd1                	j	80003510 <z_thread_single_abort+0x1a>

8000353e <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
8000353e:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80003542:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80003546:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
8000354a:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
8000354e:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80003552:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80003556:	8082                	ret

80003558 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80003558:	4108                	lw	a0,0(a0)
8000355a:	c911                	beqz	a0,8000356e <z_spin_lock_valid+0x16>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
8000355c:	800057b7          	lui	a5,0x80005
80003560:	1907c783          	lbu	a5,400(a5) # 80005190 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005191>
80003564:	890d                	andi	a0,a0,3
80003566:	8d1d                	sub	a0,a0,a5
80003568:	00a03533          	snez	a0,a0
8000356c:	8082                	ret
			return false;
		}
	}
	return true;
8000356e:	4505                	li	a0,1
}
80003570:	8082                	ret

80003572 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80003572:	800057b7          	lui	a5,0x80005
80003576:	17c78793          	addi	a5,a5,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
8000357a:	0147c703          	lbu	a4,20(a5)
8000357e:	479c                	lw	a5,8(a5)
80003580:	8fd9                	or	a5,a5,a4
80003582:	4118                	lw	a4,0(a0)
80003584:	00f71663          	bne	a4,a5,80003590 <z_spin_unlock_valid+0x1e>
		return false;
	}
	l->thread_cpu = 0;
80003588:	00052023          	sw	zero,0(a0)
	return true;
8000358c:	4505                	li	a0,1
8000358e:	8082                	ret
		return false;
80003590:	4501                	li	a0,0
}
80003592:	8082                	ret

80003594 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80003594:	800057b7          	lui	a5,0x80005
80003598:	17c78793          	addi	a5,a5,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
8000359c:	0147c703          	lbu	a4,20(a5)
800035a0:	479c                	lw	a5,8(a5)
800035a2:	8fd9                	or	a5,a5,a4
800035a4:	c11c                	sw	a5,0(a0)
}
800035a6:	8082                	ret

800035a8 <z_impl_k_thread_start>:
{
800035a8:	1101                	addi	sp,sp,-32
800035aa:	cc22                	sw	s0,24(sp)
800035ac:	c84a                	sw	s2,16(sp)
800035ae:	ce06                	sw	ra,28(sp)
800035b0:	ca26                	sw	s1,20(sp)
800035b2:	c64e                	sw	s3,12(sp)
800035b4:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800035b6:	4421                	li	s0,8
800035b8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800035bc:	800054b7          	lui	s1,0x80005
800035c0:	de048513          	addi	a0,s1,-544 # 80004de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de1>
	key = (mstatus & SOC_MSTATUS_IEN);
800035c4:	8821                	andi	s0,s0,8
800035c6:	3f49                	jal	80003558 <z_spin_lock_valid>
800035c8:	ed0d                	bnez	a0,80003602 <z_impl_k_thread_start+0x5a>
800035ca:	800059b7          	lui	s3,0x80005
800035ce:	800055b7          	lui	a1,0x80005
800035d2:	80004537          	lui	a0,0x80004
800035d6:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800035da:	04e00693          	li	a3,78
800035de:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800035e2:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800035e6:	8ccfe0ef          	jal	ra,800016b2 <printk>
800035ea:	80005537          	lui	a0,0x80005
800035ee:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
800035f2:	8c0fe0ef          	jal	ra,800016b2 <printk>
800035f6:	04e00593          	li	a1,78
800035fa:	83098513          	addi	a0,s3,-2000
800035fe:	8d2fe0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003602:	de048513          	addi	a0,s1,-544
80003606:	3779                	jal	80003594 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80003608:	00d94783          	lbu	a5,13(s2)
8000360c:	0047f713          	andi	a4,a5,4
80003610:	eb31                	bnez	a4,80003664 <z_impl_k_thread_start+0xbc>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003612:	de048513          	addi	a0,s1,-544
80003616:	3fb1                	jal	80003572 <z_spin_unlock_valid>
80003618:	ed0d                	bnez	a0,80003652 <z_impl_k_thread_start+0xaa>
8000361a:	800054b7          	lui	s1,0x80005
8000361e:	800055b7          	lui	a1,0x80005
80003622:	80004537          	lui	a0,0x80004
80003626:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
8000362a:	06100693          	li	a3,97
8000362e:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003632:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003636:	87cfe0ef          	jal	ra,800016b2 <printk>
8000363a:	80005537          	lui	a0,0x80005
8000363e:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003642:	870fe0ef          	jal	ra,800016b2 <printk>
80003646:	06100593          	li	a1,97
8000364a:	83048513          	addi	a0,s1,-2000
8000364e:	882fe0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003652:	30042473          	csrrs	s0,mstatus,s0
}
80003656:	40f2                	lw	ra,28(sp)
80003658:	4462                	lw	s0,24(sp)
8000365a:	44d2                	lw	s1,20(sp)
8000365c:	4942                	lw	s2,16(sp)
8000365e:	49b2                	lw	s3,12(sp)
80003660:	6105                	addi	sp,sp,32
80003662:	8082                	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003664:	9bed                	andi	a5,a5,-5
80003666:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
8000366a:	854a                	mv	a0,s2
8000366c:	e35ff0ef          	jal	ra,800034a0 <z_is_thread_ready>
80003670:	c501                	beqz	a0,80003678 <z_impl_k_thread_start+0xd0>
		z_add_thread_to_ready_q(thread);
80003672:	854a                	mv	a0,s2
80003674:	b44ff0ef          	jal	ra,800029b8 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80003678:	85a2                	mv	a1,s0
}
8000367a:	4462                	lw	s0,24(sp)
8000367c:	40f2                	lw	ra,28(sp)
8000367e:	4942                	lw	s2,16(sp)
80003680:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003682:	de048513          	addi	a0,s1,-544
}
80003686:	44d2                	lw	s1,20(sp)
80003688:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
8000368a:	de5fe06f          	j	8000246e <z_reschedule>

8000368e <schedule_new_thread>:
	if (delay == 0) {
8000368e:	e199                	bnez	a1,80003694 <schedule_new_thread+0x6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80003690:	f19ff06f          	j	800035a8 <z_impl_k_thread_start>
{
80003694:	1141                	addi	sp,sp,-16
80003696:	c422                	sw	s0,8(sp)
80003698:	842a                	mv	s0,a0
8000369a:	852e                	mv	a0,a1
8000369c:	0525                	addi	a0,a0,9
8000369e:	45a9                	li	a1,10
800036a0:	c606                	sw	ra,12(sp)
800036a2:	99efd0ef          	jal	ra,80000840 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800036a6:	00150613          	addi	a2,a0,1
800036aa:	01840513          	addi	a0,s0,24
}
800036ae:	4422                	lw	s0,8(sp)
800036b0:	40b2                	lw	ra,12(sp)
800036b2:	800035b7          	lui	a1,0x80003
800036b6:	b0058593          	addi	a1,a1,-1280 # 80002b00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002b01>
800036ba:	0141                	addi	sp,sp,16
800036bc:	a4ad                	j	80003926 <z_add_timeout>

800036be <z_impl_k_thread_create>:
{
800036be:	7139                	addi	sp,sp,-64
800036c0:	d256                	sw	s5,36(sp)
800036c2:	8ab6                	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800036c4:	800056b7          	lui	a3,0x80005
800036c8:	17c6a683          	lw	a3,380(a3) # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
{
800036cc:	dc22                	sw	s0,56(sp)
800036ce:	da26                	sw	s1,52(sp)
800036d0:	d64e                	sw	s3,44(sp)
800036d2:	d452                	sw	s4,40(sp)
800036d4:	de06                	sw	ra,60(sp)
800036d6:	d84a                	sw	s2,48(sp)
800036d8:	842a                	mv	s0,a0
800036da:	89ae                	mv	s3,a1
800036dc:	8a32                	mv	s4,a2
800036de:	4496                	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800036e0:	c6a9                	beqz	a3,8000372a <z_impl_k_thread_create+0x6c>
800036e2:	80005937          	lui	s2,0x80005
800036e6:	800055b7          	lui	a1,0x80005
800036ea:	80004537          	lui	a0,0x80004
800036ee:	1b200693          	li	a3,434
800036f2:	bf090613          	addi	a2,s2,-1040 # 80004bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf1>
800036f6:	a8058593          	addi	a1,a1,-1408 # 80004a80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a81>
800036fa:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800036fe:	ce46                	sw	a7,28(sp)
80003700:	cc42                	sw	a6,24(sp)
80003702:	ca3e                	sw	a5,20(sp)
80003704:	c83a                	sw	a4,16(sp)
80003706:	fadfd0ef          	jal	ra,800016b2 <printk>
8000370a:	80005537          	lui	a0,0x80005
8000370e:	c0450513          	addi	a0,a0,-1020 # 80004c04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c05>
80003712:	fa1fd0ef          	jal	ra,800016b2 <printk>
80003716:	1b200593          	li	a1,434
8000371a:	bf090513          	addi	a0,s2,-1040
8000371e:	fb3fd0ef          	jal	ra,800016d0 <assert_post_action>
80003722:	48f2                	lw	a7,28(sp)
80003724:	4862                	lw	a6,24(sp)
80003726:	47d2                	lw	a5,20(sp)
80003728:	4742                	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000372a:	4686                	lw	a3,64(sp)
8000372c:	c202                	sw	zero,4(sp)
8000372e:	8652                	mv	a2,s4
80003730:	c036                	sw	a3,0(sp)
80003732:	85ce                	mv	a1,s3
80003734:	86d6                	mv	a3,s5
80003736:	8522                	mv	a0,s0
80003738:	d9bff0ef          	jal	ra,800034d2 <z_setup_new_thread>
	if (delay != K_FOREVER) {
8000373c:	57fd                	li	a5,-1
8000373e:	00f48663          	beq	s1,a5,8000374a <z_impl_k_thread_create+0x8c>
		schedule_new_thread(new_thread, delay);
80003742:	85a6                	mv	a1,s1
80003744:	8522                	mv	a0,s0
80003746:	f49ff0ef          	jal	ra,8000368e <schedule_new_thread>
}
8000374a:	8522                	mv	a0,s0
8000374c:	50f2                	lw	ra,60(sp)
8000374e:	5462                	lw	s0,56(sp)
80003750:	54d2                	lw	s1,52(sp)
80003752:	5942                	lw	s2,48(sp)
80003754:	59b2                	lw	s3,44(sp)
80003756:	5a22                	lw	s4,40(sp)
80003758:	5a92                	lw	s5,36(sp)
8000375a:	6121                	addi	sp,sp,64
8000375c:	8082                	ret

8000375e <z_init_static_threads>:
{
8000375e:	1101                	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80003760:	800057b7          	lui	a5,0x80005
{
80003764:	c84a                	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80003766:	80005937          	lui	s2,0x80005
{
8000376a:	cc22                	sw	s0,24(sp)
8000376c:	ca26                	sw	s1,20(sp)
8000376e:	ce06                	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80003770:	d5478413          	addi	s0,a5,-684 # 80004d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d55>
80003774:	d5478493          	addi	s1,a5,-684
80003778:	d5490913          	addi	s2,s2,-684 # 80004d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d55>
8000377c:	01246f63          	bltu	s0,s2,8000379a <z_init_static_threads+0x3c>
	_FOREACH_STATIC_THREAD(thread_data) {
80003780:	8426                	mv	s0,s1
	k_sched_lock();
80003782:	dbdfe0ef          	jal	ra,8000253e <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80003786:	54fd                	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80003788:	03246e63          	bltu	s0,s2,800037c4 <z_init_static_threads+0x66>
}
8000378c:	4462                	lw	s0,24(sp)
8000378e:	40f2                	lw	ra,28(sp)
80003790:	44d2                	lw	s1,20(sp)
80003792:	4942                	lw	s2,16(sp)
80003794:	6105                	addi	sp,sp,32
	k_sched_unlock();
80003796:	8ceff06f          	j	80002864 <k_sched_unlock>
		z_setup_new_thread(
8000379a:	545c                	lw	a5,44(s0)
8000379c:	c23e                	sw	a5,4(sp)
8000379e:	501c                	lw	a5,32(s0)
800037a0:	c03e                	sw	a5,0(sp)
800037a2:	485c                	lw	a5,20(s0)
800037a4:	01c42883          	lw	a7,28(s0)
800037a8:	01842803          	lw	a6,24(s0)
800037ac:	4818                	lw	a4,16(s0)
800037ae:	4454                	lw	a3,12(s0)
800037b0:	4410                	lw	a2,8(s0)
800037b2:	404c                	lw	a1,4(s0)
800037b4:	4008                	lw	a0,0(s0)
800037b6:	d1dff0ef          	jal	ra,800034d2 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
800037ba:	401c                	lw	a5,0(s0)
800037bc:	cfe0                	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
800037be:	03040413          	addi	s0,s0,48
800037c2:	bf6d                	j	8000377c <z_init_static_threads+0x1e>
		if (thread_data->init_delay != K_FOREVER) {
800037c4:	504c                	lw	a1,36(s0)
800037c6:	00958563          	beq	a1,s1,800037d0 <z_init_static_threads+0x72>
			schedule_new_thread(thread_data->init_thread,
800037ca:	4008                	lw	a0,0(s0)
800037cc:	ec3ff0ef          	jal	ra,8000368e <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
800037d0:	03040413          	addi	s0,s0,48
800037d4:	bf55                	j	80003788 <z_init_static_threads+0x2a>

800037d6 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
800037d6:	1101                	addi	sp,sp,-32
800037d8:	cc22                	sw	s0,24(sp)
800037da:	ca26                	sw	s1,20(sp)
800037dc:	ce06                	sw	ra,28(sp)
800037de:	c84a                	sw	s2,16(sp)
800037e0:	84aa                	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
800037e2:	c602                	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800037e4:	4421                	li	s0,8
800037e6:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800037ea:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800037ec:	8821                	andi	s0,s0,8
800037ee:	d6bff0ef          	jal	ra,80003558 <z_spin_lock_valid>
800037f2:	ed0d                	bnez	a0,8000382c <z_impl_k_thread_abort+0x56>
800037f4:	80005937          	lui	s2,0x80005
800037f8:	800055b7          	lui	a1,0x80005
800037fc:	80004537          	lui	a0,0x80004
80003800:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80003804:	04e00693          	li	a3,78
80003808:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
8000380c:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003810:	ea3fd0ef          	jal	ra,800016b2 <printk>
80003814:	80005537          	lui	a0,0x80005
80003818:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
8000381c:	e97fd0ef          	jal	ra,800016b2 <printk>
80003820:	04e00593          	li	a1,78
80003824:	83090513          	addi	a0,s2,-2000
80003828:	ea9fd0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
8000382c:	0068                	addi	a0,sp,12
8000382e:	d67ff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80003832:	00c4c783          	lbu	a5,12(s1)
80003836:	8b85                	andi	a5,a5,1
80003838:	cf8d                	beqz	a5,80003872 <z_impl_k_thread_abort+0x9c>
8000383a:	80005937          	lui	s2,0x80005
8000383e:	800055b7          	lui	a1,0x80005
80003842:	80004537          	lui	a0,0x80004
80003846:	c4458593          	addi	a1,a1,-956 # 80004c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c45>
8000384a:	02900693          	li	a3,41
8000384e:	c2c90613          	addi	a2,s2,-980 # 80004c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c2d>
80003852:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003856:	e5dfd0ef          	jal	ra,800016b2 <printk>
8000385a:	80005537          	lui	a0,0x80005
8000385e:	c7850513          	addi	a0,a0,-904 # 80004c78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c79>
80003862:	e51fd0ef          	jal	ra,800016b2 <printk>
80003866:	02900593          	li	a1,41
8000386a:	c2c90513          	addi	a0,s2,-980
8000386e:	e63fd0ef          	jal	ra,800016d0 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80003872:	8526                	mv	a0,s1
80003874:	c83ff0ef          	jal	ra,800034f6 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80003878:	85a2                	mv	a1,s0
8000387a:	0068                	addi	a0,sp,12
8000387c:	bf3fe0ef          	jal	ra,8000246e <z_reschedule>
}
80003880:	40f2                	lw	ra,28(sp)
80003882:	4462                	lw	s0,24(sp)
80003884:	44d2                	lw	s1,20(sp)
80003886:	4942                	lw	s2,16(sp)
80003888:	6105                	addi	sp,sp,32
8000388a:	8082                	ret

8000388c <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
8000388c:	800057b7          	lui	a5,0x80005
80003890:	de47a783          	lw	a5,-540(a5) # 80004de4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de5>
80003894:	e399                	bnez	a5,8000389a <elapsed+0xe>
80003896:	994fe06f          	j	80001a2a <z_clock_elapsed>
}
8000389a:	4501                	li	a0,0
8000389c:	8082                	ret

8000389e <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
8000389e:	411c                	lw	a5,0(a0)
800038a0:	cd01                	beqz	a0,800038b8 <remove_timeout+0x1a>
800038a2:	80005737          	lui	a4,0x80005
	return (node == list->tail) ? NULL : node->next;
800038a6:	d1072703          	lw	a4,-752(a4) # 80004d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d11>
800038aa:	00e50763          	beq	a0,a4,800038b8 <remove_timeout+0x1a>
	if (next(t) != NULL) {
800038ae:	c789                	beqz	a5,800038b8 <remove_timeout+0x1a>
		next(t)->dticks += t->dticks;
800038b0:	4798                	lw	a4,8(a5)
800038b2:	4514                	lw	a3,8(a0)
800038b4:	9736                	add	a4,a4,a3
800038b6:	c798                	sw	a4,8(a5)
	node->prev->next = node->next;
800038b8:	4158                	lw	a4,4(a0)
800038ba:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
800038bc:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
800038be:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800038c2:	00052223          	sw	zero,4(a0)
}
800038c6:	8082                	ret

800038c8 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800038c8:	800057b7          	lui	a5,0x80005
800038cc:	df07c783          	lbu	a5,-528(a5) # 80004df0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004df1>
{
800038d0:	1141                	addi	sp,sp,-16
800038d2:	c606                	sw	ra,12(sp)
800038d4:	c422                	sw	s0,8(sp)
800038d6:	c226                	sw	s1,4(sp)
800038d8:	557d                	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800038da:	e789                	bnez	a5,800038e4 <next_timeout+0x1c>
800038dc:	80000537          	lui	a0,0x80000
800038e0:	fff54513          	not	a0,a0
	return list->head == list;
800038e4:	800057b7          	lui	a5,0x80005
800038e8:	d0c78793          	addi	a5,a5,-756 # 80004d0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d0d>
800038ec:	4380                	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800038ee:	00f40f63          	beq	s0,a5,8000390c <next_timeout+0x44>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
800038f2:	cc09                	beqz	s0,8000390c <next_timeout+0x44>
800038f4:	4404                	lw	s1,8(s0)
800038f6:	f97ff0ef          	jal	ra,8000388c <elapsed>
800038fa:	8c89                	sub	s1,s1,a0
800038fc:	4501                	li	a0,0
800038fe:	0004c763          	bltz	s1,8000390c <next_timeout+0x44>
80003902:	4400                	lw	s0,8(s0)
80003904:	f89ff0ef          	jal	ra,8000388c <elapsed>
80003908:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
8000390c:	800057b7          	lui	a5,0x80005
80003910:	18c7a783          	lw	a5,396(a5) # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80003914:	c781                	beqz	a5,8000391c <next_timeout+0x54>
80003916:	00a7d363          	bge	a5,a0,8000391c <next_timeout+0x54>
8000391a:	853e                	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
8000391c:	40b2                	lw	ra,12(sp)
8000391e:	4422                	lw	s0,8(sp)
80003920:	4492                	lw	s1,4(sp)
80003922:	0141                	addi	sp,sp,16
80003924:	8082                	ret

80003926 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003926:	411c                	lw	a5,0(a0)
{
80003928:	7179                	addi	sp,sp,-48
8000392a:	d422                	sw	s0,40(sp)
8000392c:	d226                	sw	s1,36(sp)
8000392e:	ce4e                	sw	s3,28(sp)
80003930:	d606                	sw	ra,44(sp)
80003932:	d04a                	sw	s2,32(sp)
80003934:	cc52                	sw	s4,24(sp)
80003936:	ca56                	sw	s5,20(sp)
80003938:	c85a                	sw	s6,16(sp)
8000393a:	c65e                	sw	s7,12(sp)
8000393c:	c462                	sw	s8,8(sp)
8000393e:	842a                	mv	s0,a0
80003940:	89ae                	mv	s3,a1
80003942:	84b2                	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003944:	cf8d                	beqz	a5,8000397e <z_add_timeout+0x58>
80003946:	80005937          	lui	s2,0x80005
8000394a:	800055b7          	lui	a1,0x80005
8000394e:	80004537          	lui	a0,0x80004
80003952:	ca858593          	addi	a1,a1,-856 # 80004ca8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca9>
80003956:	04d00693          	li	a3,77
8000395a:	c9490613          	addi	a2,s2,-876 # 80004c94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c95>
8000395e:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003962:	d51fd0ef          	jal	ra,800016b2 <printk>
80003966:	80004537          	lui	a0,0x80004
8000396a:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
8000396e:	d45fd0ef          	jal	ra,800016b2 <printk>
80003972:	04d00593          	li	a1,77
80003976:	c9490513          	addi	a0,s2,-876
8000397a:	d57fd0ef          	jal	ra,800016d0 <assert_post_action>
	to->fn = fn;
8000397e:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80003982:	00904363          	bgtz	s1,80003988 <z_add_timeout+0x62>
80003986:	4485                	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003988:	49a1                	li	s3,8
8000398a:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000398e:	80005a37          	lui	s4,0x80005
80003992:	de8a0513          	addi	a0,s4,-536 # 80004de8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003996:	0089f993          	andi	s3,s3,8
8000399a:	bbfff0ef          	jal	ra,80003558 <z_spin_lock_valid>
8000399e:	ed0d                	bnez	a0,800039d8 <z_add_timeout+0xb2>
800039a0:	80005937          	lui	s2,0x80005
800039a4:	800055b7          	lui	a1,0x80005
800039a8:	80004537          	lui	a0,0x80004
800039ac:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
800039b0:	04e00693          	li	a3,78
800039b4:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800039b8:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800039bc:	cf7fd0ef          	jal	ra,800016b2 <printk>
800039c0:	80005537          	lui	a0,0x80005
800039c4:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
800039c8:	cebfd0ef          	jal	ra,800016b2 <printk>
800039cc:	04e00593          	li	a1,78
800039d0:	83090513          	addi	a0,s2,-2000
800039d4:	cfdfd0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
800039d8:	de8a0513          	addi	a0,s4,-536
800039dc:	bb9ff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
800039e0:	eadff0ef          	jal	ra,8000388c <elapsed>
800039e4:	9526                	add	a0,a0,s1
	return list->head == list;
800039e6:	800054b7          	lui	s1,0x80005
800039ea:	d0c4a903          	lw	s2,-756(s1) # 80004d0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d0d>
800039ee:	c408                	sw	a0,8(s0)
800039f0:	d0c48493          	addi	s1,s1,-756
	return sys_dlist_is_empty(list) ? NULL : list->head;
800039f4:	00990c63          	beq	s2,s1,80003a0c <z_add_timeout+0xe6>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
800039f8:	80005ab7          	lui	s5,0x80005
800039fc:	80005b37          	lui	s6,0x80005
80003a00:	80004bb7          	lui	s7,0x80004
80003a04:	80004c37          	lui	s8,0x80004
		for (t = first(); t != NULL; t = next(t)) {
80003a08:	00091963          	bnez	s2,80003a1a <z_add_timeout+0xf4>
	node->prev = list->tail;
80003a0c:	40dc                	lw	a5,4(s1)
	node->next = list;
80003a0e:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80003a10:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80003a12:	40dc                	lw	a5,4(s1)
80003a14:	c380                	sw	s0,0(a5)
	list->tail = node;
80003a16:	c0c0                	sw	s0,4(s1)
80003a18:	a891                	j	80003a6c <z_add_timeout+0x146>
			__ASSERT(t->dticks >= 0, "");
80003a1a:	00892783          	lw	a5,8(s2)
80003a1e:	0207d663          	bgez	a5,80003a4a <z_add_timeout+0x124>
80003a22:	cc8b0593          	addi	a1,s6,-824 # 80004cc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cc9>
80003a26:	05600693          	li	a3,86
80003a2a:	c94a8613          	addi	a2,s5,-876 # 80004c94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c95>
80003a2e:	764b8513          	addi	a0,s7,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003a32:	c81fd0ef          	jal	ra,800016b2 <printk>
80003a36:	7e8c0513          	addi	a0,s8,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
80003a3a:	c79fd0ef          	jal	ra,800016b2 <printk>
80003a3e:	05600593          	li	a1,86
80003a42:	c94a8513          	addi	a0,s5,-876
80003a46:	c8bfd0ef          	jal	ra,800016d0 <assert_post_action>

			if (t->dticks > to->dticks) {
80003a4a:	00892703          	lw	a4,8(s2)
80003a4e:	441c                	lw	a5,8(s0)
80003a50:	08e7d763          	bge	a5,a4,80003ade <z_add_timeout+0x1b8>
				t->dticks -= to->dticks;
80003a54:	40f707b3          	sub	a5,a4,a5
80003a58:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80003a5c:	00492783          	lw	a5,4(s2)
	node->next = successor;
80003a60:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80003a64:	c05c                	sw	a5,4(s0)
	successor->prev->next = node;
80003a66:	c380                	sw	s0,0(a5)
	successor->prev = node;
80003a68:	00892223          	sw	s0,4(s2)
	return list->head == list;
80003a6c:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003a6e:	00978963          	beq	a5,s1,80003a80 <z_add_timeout+0x15a>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80003a72:	00f41763          	bne	s0,a5,80003a80 <z_add_timeout+0x15a>
			z_clock_set_timeout(next_timeout(), false);
80003a76:	e53ff0ef          	jal	ra,800038c8 <next_timeout>
80003a7a:	4581                	li	a1,0
80003a7c:	e63fd0ef          	jal	ra,800018de <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a80:	de8a0513          	addi	a0,s4,-536
80003a84:	aefff0ef          	jal	ra,80003572 <z_spin_unlock_valid>
80003a88:	ed0d                	bnez	a0,80003ac2 <z_add_timeout+0x19c>
80003a8a:	80005437          	lui	s0,0x80005
80003a8e:	800055b7          	lui	a1,0x80005
80003a92:	80004537          	lui	a0,0x80004
80003a96:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80003a9a:	06100693          	li	a3,97
80003a9e:	83040613          	addi	a2,s0,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003aa2:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003aa6:	c0dfd0ef          	jal	ra,800016b2 <printk>
80003aaa:	80005537          	lui	a0,0x80005
80003aae:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003ab2:	c01fd0ef          	jal	ra,800016b2 <printk>
80003ab6:	06100593          	li	a1,97
80003aba:	83040513          	addi	a0,s0,-2000
80003abe:	c13fd0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003ac2:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80003ac6:	50b2                	lw	ra,44(sp)
80003ac8:	5422                	lw	s0,40(sp)
80003aca:	5492                	lw	s1,36(sp)
80003acc:	5902                	lw	s2,32(sp)
80003ace:	49f2                	lw	s3,28(sp)
80003ad0:	4a62                	lw	s4,24(sp)
80003ad2:	4ad2                	lw	s5,20(sp)
80003ad4:	4b42                	lw	s6,16(sp)
80003ad6:	4bb2                	lw	s7,12(sp)
80003ad8:	4c22                	lw	s8,8(sp)
80003ada:	6145                	addi	sp,sp,48
80003adc:	8082                	ret
			to->dticks -= t->dticks;
80003ade:	8f99                	sub	a5,a5,a4
80003ae0:	c41c                	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80003ae2:	40dc                	lw	a5,4(s1)
80003ae4:	f32784e3          	beq	a5,s2,80003a0c <z_add_timeout+0xe6>
80003ae8:	00092903          	lw	s2,0(s2)
80003aec:	bf31                	j	80003a08 <z_add_timeout+0xe2>

80003aee <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80003aee:	1101                	addi	sp,sp,-32
80003af0:	cc22                	sw	s0,24(sp)
80003af2:	c64e                	sw	s3,12(sp)
80003af4:	ce06                	sw	ra,28(sp)
80003af6:	ca26                	sw	s1,20(sp)
80003af8:	c84a                	sw	s2,16(sp)
80003afa:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003afc:	4421                	li	s0,8
80003afe:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003b02:	800054b7          	lui	s1,0x80005
80003b06:	de848513          	addi	a0,s1,-536 # 80004de8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003b0a:	8821                	andi	s0,s0,8
80003b0c:	a4dff0ef          	jal	ra,80003558 <z_spin_lock_valid>
80003b10:	ed0d                	bnez	a0,80003b4a <z_abort_timeout+0x5c>
80003b12:	80005937          	lui	s2,0x80005
80003b16:	800055b7          	lui	a1,0x80005
80003b1a:	80004537          	lui	a0,0x80004
80003b1e:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80003b22:	04e00693          	li	a3,78
80003b26:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003b2a:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003b2e:	b85fd0ef          	jal	ra,800016b2 <printk>
80003b32:	80005537          	lui	a0,0x80005
80003b36:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80003b3a:	b79fd0ef          	jal	ra,800016b2 <printk>
80003b3e:	04e00593          	li	a1,78
80003b42:	83090513          	addi	a0,s2,-2000
80003b46:	b8bfd0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b4a:	de848513          	addi	a0,s1,-536
80003b4e:	a47ff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80003b52:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80003b56:	5929                	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80003b58:	c789                	beqz	a5,80003b62 <z_abort_timeout+0x74>
			remove_timeout(to);
80003b5a:	854e                	mv	a0,s3
80003b5c:	d43ff0ef          	jal	ra,8000389e <remove_timeout>
			ret = 0;
80003b60:	4901                	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b62:	de848513          	addi	a0,s1,-536
80003b66:	a0dff0ef          	jal	ra,80003572 <z_spin_unlock_valid>
80003b6a:	ed0d                	bnez	a0,80003ba4 <z_abort_timeout+0xb6>
80003b6c:	800054b7          	lui	s1,0x80005
80003b70:	800055b7          	lui	a1,0x80005
80003b74:	80004537          	lui	a0,0x80004
80003b78:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80003b7c:	06100693          	li	a3,97
80003b80:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003b84:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003b88:	b2bfd0ef          	jal	ra,800016b2 <printk>
80003b8c:	80005537          	lui	a0,0x80005
80003b90:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003b94:	b1ffd0ef          	jal	ra,800016b2 <printk>
80003b98:	06100593          	li	a1,97
80003b9c:	83048513          	addi	a0,s1,-2000
80003ba0:	b31fd0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003ba4:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80003ba8:	40f2                	lw	ra,28(sp)
80003baa:	4462                	lw	s0,24(sp)
80003bac:	854a                	mv	a0,s2
80003bae:	44d2                	lw	s1,20(sp)
80003bb0:	4942                	lw	s2,16(sp)
80003bb2:	49b2                	lw	s3,12(sp)
80003bb4:	6105                	addi	sp,sp,32
80003bb6:	8082                	ret

80003bb8 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80003bb8:	1141                	addi	sp,sp,-16
80003bba:	c422                	sw	s0,8(sp)
80003bbc:	c606                	sw	ra,12(sp)
80003bbe:	c226                	sw	s1,4(sp)
80003bc0:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003bc2:	4421                	li	s0,8
80003bc4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003bc8:	800054b7          	lui	s1,0x80005
80003bcc:	de848513          	addi	a0,s1,-536 # 80004de8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003bd0:	8821                	andi	s0,s0,8
80003bd2:	987ff0ef          	jal	ra,80003558 <z_spin_lock_valid>
80003bd6:	ed0d                	bnez	a0,80003c10 <z_get_next_timeout_expiry+0x58>
80003bd8:	80005937          	lui	s2,0x80005
80003bdc:	800055b7          	lui	a1,0x80005
80003be0:	80004537          	lui	a0,0x80004
80003be4:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80003be8:	04e00693          	li	a3,78
80003bec:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003bf0:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003bf4:	abffd0ef          	jal	ra,800016b2 <printk>
80003bf8:	80005537          	lui	a0,0x80005
80003bfc:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80003c00:	ab3fd0ef          	jal	ra,800016b2 <printk>
80003c04:	04e00593          	li	a1,78
80003c08:	83090513          	addi	a0,s2,-2000
80003c0c:	ac5fd0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003c10:	de848513          	addi	a0,s1,-536
80003c14:	981ff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80003c18:	cb1ff0ef          	jal	ra,800038c8 <next_timeout>
80003c1c:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003c1e:	de848513          	addi	a0,s1,-536
80003c22:	951ff0ef          	jal	ra,80003572 <z_spin_unlock_valid>
80003c26:	ed0d                	bnez	a0,80003c60 <z_get_next_timeout_expiry+0xa8>
80003c28:	800054b7          	lui	s1,0x80005
80003c2c:	800055b7          	lui	a1,0x80005
80003c30:	80004537          	lui	a0,0x80004
80003c34:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80003c38:	06100693          	li	a3,97
80003c3c:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003c40:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003c44:	a6ffd0ef          	jal	ra,800016b2 <printk>
80003c48:	80005537          	lui	a0,0x80005
80003c4c:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003c50:	a63fd0ef          	jal	ra,800016b2 <printk>
80003c54:	06100593          	li	a1,97
80003c58:	83048513          	addi	a0,s1,-2000
80003c5c:	a75fd0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c60:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80003c64:	40b2                	lw	ra,12(sp)
80003c66:	4422                	lw	s0,8(sp)
80003c68:	854a                	mv	a0,s2
80003c6a:	4492                	lw	s1,4(sp)
80003c6c:	4902                	lw	s2,0(sp)
80003c6e:	0141                	addi	sp,sp,16
80003c70:	8082                	ret

80003c72 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80003c72:	1101                	addi	sp,sp,-32
80003c74:	cc22                	sw	s0,24(sp)
80003c76:	c84a                	sw	s2,16(sp)
80003c78:	c452                	sw	s4,8(sp)
80003c7a:	ce06                	sw	ra,28(sp)
80003c7c:	ca26                	sw	s1,20(sp)
80003c7e:	c64e                	sw	s3,12(sp)
80003c80:	892a                	mv	s2,a0
80003c82:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c84:	4421                	li	s0,8
80003c86:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c8a:	800054b7          	lui	s1,0x80005
80003c8e:	de848513          	addi	a0,s1,-536 # 80004de8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c92:	8821                	andi	s0,s0,8
80003c94:	8c5ff0ef          	jal	ra,80003558 <z_spin_lock_valid>
80003c98:	ed0d                	bnez	a0,80003cd2 <z_set_timeout_expiry+0x60>
80003c9a:	800059b7          	lui	s3,0x80005
80003c9e:	800055b7          	lui	a1,0x80005
80003ca2:	80004537          	lui	a0,0x80004
80003ca6:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80003caa:	04e00693          	li	a3,78
80003cae:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003cb2:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003cb6:	9fdfd0ef          	jal	ra,800016b2 <printk>
80003cba:	80005537          	lui	a0,0x80005
80003cbe:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80003cc2:	9f1fd0ef          	jal	ra,800016b2 <printk>
80003cc6:	04e00593          	li	a1,78
80003cca:	83098513          	addi	a0,s3,-2000
80003cce:	a03fd0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003cd2:	de848513          	addi	a0,s1,-536
80003cd6:	8bfff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80003cda:	befff0ef          	jal	ra,800038c8 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80003cde:	00a95963          	bge	s2,a0,80003cf0 <z_set_timeout_expiry+0x7e>
80003ce2:	4785                	li	a5,1
80003ce4:	00a7d663          	bge	a5,a0,80003cf0 <z_set_timeout_expiry+0x7e>
			z_clock_set_timeout(ticks, idle);
80003ce8:	85d2                	mv	a1,s4
80003cea:	854a                	mv	a0,s2
80003cec:	bf3fd0ef          	jal	ra,800018de <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003cf0:	de848513          	addi	a0,s1,-536
80003cf4:	87fff0ef          	jal	ra,80003572 <z_spin_unlock_valid>
80003cf8:	ed0d                	bnez	a0,80003d32 <z_set_timeout_expiry+0xc0>
80003cfa:	800054b7          	lui	s1,0x80005
80003cfe:	800055b7          	lui	a1,0x80005
80003d02:	80004537          	lui	a0,0x80004
80003d06:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80003d0a:	06100693          	li	a3,97
80003d0e:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003d12:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003d16:	99dfd0ef          	jal	ra,800016b2 <printk>
80003d1a:	80005537          	lui	a0,0x80005
80003d1e:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003d22:	991fd0ef          	jal	ra,800016b2 <printk>
80003d26:	06100593          	li	a1,97
80003d2a:	83048513          	addi	a0,s1,-2000
80003d2e:	9a3fd0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003d32:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80003d36:	40f2                	lw	ra,28(sp)
80003d38:	4462                	lw	s0,24(sp)
80003d3a:	44d2                	lw	s1,20(sp)
80003d3c:	4942                	lw	s2,16(sp)
80003d3e:	49b2                	lw	s3,12(sp)
80003d40:	4a22                	lw	s4,8(sp)
80003d42:	6105                	addi	sp,sp,32
80003d44:	8082                	ret

80003d46 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80003d46:	7179                	addi	sp,sp,-48
80003d48:	d422                	sw	s0,40(sp)
80003d4a:	cc52                	sw	s4,24(sp)
80003d4c:	d606                	sw	ra,44(sp)
80003d4e:	d226                	sw	s1,36(sp)
80003d50:	d04a                	sw	s2,32(sp)
80003d52:	ce4e                	sw	s3,28(sp)
80003d54:	ca56                	sw	s5,20(sp)
80003d56:	c85a                	sw	s6,16(sp)
80003d58:	c65e                	sw	s7,12(sp)
80003d5a:	c462                	sw	s8,8(sp)
80003d5c:	c266                	sw	s9,4(sp)
80003d5e:	c06a                	sw	s10,0(sp)
80003d60:	8a2a                	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d62:	4421                	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80003d64:	808ff0ef          	jal	ra,80002d6c <z_time_slice>
80003d68:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d6c:	80005937          	lui	s2,0x80005
80003d70:	de890513          	addi	a0,s2,-536 # 80004de8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003d74:	8821                	andi	s0,s0,8
80003d76:	fe2ff0ef          	jal	ra,80003558 <z_spin_lock_valid>
80003d7a:	ed0d                	bnez	a0,80003db4 <z_clock_announce+0x6e>
80003d7c:	800054b7          	lui	s1,0x80005
80003d80:	800055b7          	lui	a1,0x80005
80003d84:	80004537          	lui	a0,0x80004
80003d88:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80003d8c:	04e00693          	li	a3,78
80003d90:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003d94:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003d98:	91bfd0ef          	jal	ra,800016b2 <printk>
80003d9c:	80005537          	lui	a0,0x80005
80003da0:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80003da4:	90ffd0ef          	jal	ra,800016b2 <printk>
80003da8:	04e00593          	li	a1,78
80003dac:	83048513          	addi	a0,s1,-2000
80003db0:	921fd0ef          	jal	ra,800016d0 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80003db4:	800059b7          	lui	s3,0x80005
	z_spin_lock_set_owner(l);
80003db8:	de890513          	addi	a0,s2,-536
80003dbc:	fd8ff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>
80003dc0:	800054b7          	lui	s1,0x80005
80003dc4:	df49a223          	sw	s4,-540(s3) # 80004de4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de5>
	return list->head == list;
80003dc8:	80005a37          	lui	s4,0x80005
80003dcc:	de498993          	addi	s3,s3,-540
80003dd0:	d0ca0a13          	addi	s4,s4,-756 # 80004d0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d0d>
80003dd4:	da848493          	addi	s1,s1,-600 # 80004da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da9>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003dd8:	80005ab7          	lui	s5,0x80005
80003ddc:	80005bb7          	lui	s7,0x80005
80003de0:	80004b37          	lui	s6,0x80004
80003de4:	80005c37          	lui	s8,0x80005
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003de8:	80005cb7          	lui	s9,0x80005
80003dec:	000a2d03          	lw	s10,0(s4)
80003df0:	0009a783          	lw	a5,0(s3)
80003df4:	4094                	lw	a3,0(s1)
80003df6:	40c8                	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003df8:	014d0b63          	beq	s10,s4,80003e0e <z_clock_announce+0xc8>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80003dfc:	000d0963          	beqz	s10,80003e0e <z_clock_announce+0xc8>
80003e00:	008d2703          	lw	a4,8(s10)
80003e04:	08e7d663          	bge	a5,a4,80003e90 <z_clock_announce+0x14a>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80003e08:	8f1d                	sub	a4,a4,a5
80003e0a:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80003e0e:	96be                	add	a3,a3,a5
80003e10:	41f7d713          	srai	a4,a5,0x1f
80003e14:	972a                	add	a4,a4,a0
80003e16:	00f6b7b3          	sltu	a5,a3,a5
80003e1a:	97ba                	add	a5,a5,a4
80003e1c:	c094                	sw	a3,0(s1)
80003e1e:	c0dc                	sw	a5,4(s1)
	announce_remaining = 0;
80003e20:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80003e24:	aa5ff0ef          	jal	ra,800038c8 <next_timeout>
80003e28:	4581                	li	a1,0
80003e2a:	ab5fd0ef          	jal	ra,800018de <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003e2e:	de890513          	addi	a0,s2,-536
80003e32:	f40ff0ef          	jal	ra,80003572 <z_spin_unlock_valid>
80003e36:	ed0d                	bnez	a0,80003e70 <z_clock_announce+0x12a>
80003e38:	800054b7          	lui	s1,0x80005
80003e3c:	800055b7          	lui	a1,0x80005
80003e40:	80004537          	lui	a0,0x80004
80003e44:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80003e48:	06100693          	li	a3,97
80003e4c:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003e50:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003e54:	85ffd0ef          	jal	ra,800016b2 <printk>
80003e58:	80005537          	lui	a0,0x80005
80003e5c:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003e60:	853fd0ef          	jal	ra,800016b2 <printk>
80003e64:	06100593          	li	a1,97
80003e68:	83048513          	addi	a0,s1,-2000
80003e6c:	865fd0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003e70:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80003e74:	50b2                	lw	ra,44(sp)
80003e76:	5422                	lw	s0,40(sp)
80003e78:	5492                	lw	s1,36(sp)
80003e7a:	5902                	lw	s2,32(sp)
80003e7c:	49f2                	lw	s3,28(sp)
80003e7e:	4a62                	lw	s4,24(sp)
80003e80:	4ad2                	lw	s5,20(sp)
80003e82:	4b42                	lw	s6,16(sp)
80003e84:	4bb2                	lw	s7,12(sp)
80003e86:	4c22                	lw	s8,8(sp)
80003e88:	4c92                	lw	s9,4(sp)
80003e8a:	4d02                	lw	s10,0(sp)
80003e8c:	6145                	addi	sp,sp,48
80003e8e:	8082                	ret
		curr_tick += dt;
80003e90:	96ba                	add	a3,a3,a4
80003e92:	41f75593          	srai	a1,a4,0x1f
80003e96:	95aa                	add	a1,a1,a0
80003e98:	00e6b633          	sltu	a2,a3,a4
80003e9c:	962e                	add	a2,a2,a1
		announce_remaining -= dt;
80003e9e:	8f99                	sub	a5,a5,a4
		remove_timeout(t);
80003ea0:	856a                	mv	a0,s10
		t->dticks = 0;
80003ea2:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80003ea6:	c094                	sw	a3,0(s1)
80003ea8:	c0d0                	sw	a2,4(s1)
		announce_remaining -= dt;
80003eaa:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80003eae:	9f1ff0ef          	jal	ra,8000389e <remove_timeout>
80003eb2:	de890513          	addi	a0,s2,-536
80003eb6:	ebcff0ef          	jal	ra,80003572 <z_spin_unlock_valid>
80003eba:	e50d                	bnez	a0,80003ee4 <z_clock_announce+0x19e>
80003ebc:	878b8593          	addi	a1,s7,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80003ec0:	06100693          	li	a3,97
80003ec4:	830a8613          	addi	a2,s5,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003ec8:	764b0513          	addi	a0,s6,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003ecc:	fe6fd0ef          	jal	ra,800016b2 <printk>
80003ed0:	890c0513          	addi	a0,s8,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003ed4:	fdefd0ef          	jal	ra,800016b2 <printk>
80003ed8:	06100593          	li	a1,97
80003edc:	830a8513          	addi	a0,s5,-2000
80003ee0:	ff0fd0ef          	jal	ra,800016d0 <assert_post_action>
80003ee4:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80003ee8:	00cd2783          	lw	a5,12(s10)
80003eec:	856a                	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003eee:	4421                	li	s0,8
80003ef0:	9782                	jalr	a5
80003ef2:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003ef6:	de890513          	addi	a0,s2,-536
	key = (mstatus & SOC_MSTATUS_IEN);
80003efa:	8821                	andi	s0,s0,8
80003efc:	e5cff0ef          	jal	ra,80003558 <z_spin_lock_valid>
80003f00:	e51d                	bnez	a0,80003f2e <z_clock_announce+0x1e8>
80003f02:	848c8593          	addi	a1,s9,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80003f06:	04e00693          	li	a3,78
80003f0a:	830a8613          	addi	a2,s5,-2000
80003f0e:	764b0513          	addi	a0,s6,1892
80003f12:	fa0fd0ef          	jal	ra,800016b2 <printk>
80003f16:	80005537          	lui	a0,0x80005
80003f1a:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80003f1e:	f94fd0ef          	jal	ra,800016b2 <printk>
80003f22:	04e00593          	li	a1,78
80003f26:	830a8513          	addi	a0,s5,-2000
80003f2a:	fa6fd0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003f2e:	de890513          	addi	a0,s2,-536
80003f32:	e62ff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	return k;
80003f36:	bd5d                	j	80003dec <z_clock_announce+0xa6>

80003f38 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80003f38:	1101                	addi	sp,sp,-32
80003f3a:	ca26                	sw	s1,20(sp)
80003f3c:	ce06                	sw	ra,28(sp)
80003f3e:	cc22                	sw	s0,24(sp)
80003f40:	c84a                	sw	s2,16(sp)
80003f42:	c64e                	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f44:	44a1                	li	s1,8
80003f46:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f4a:	80005937          	lui	s2,0x80005
80003f4e:	de890513          	addi	a0,s2,-536 # 80004de8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f52:	88a1                	andi	s1,s1,8
80003f54:	e04ff0ef          	jal	ra,80003558 <z_spin_lock_valid>
80003f58:	ed0d                	bnez	a0,80003f92 <z_tick_get+0x5a>
80003f5a:	80005437          	lui	s0,0x80005
80003f5e:	800055b7          	lui	a1,0x80005
80003f62:	80004537          	lui	a0,0x80004
80003f66:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80003f6a:	04e00693          	li	a3,78
80003f6e:	83040613          	addi	a2,s0,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003f72:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003f76:	f3cfd0ef          	jal	ra,800016b2 <printk>
80003f7a:	80005537          	lui	a0,0x80005
80003f7e:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
80003f82:	f30fd0ef          	jal	ra,800016b2 <printk>
80003f86:	04e00593          	li	a1,78
80003f8a:	83040513          	addi	a0,s0,-2000
80003f8e:	f42fd0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
80003f92:	de890513          	addi	a0,s2,-536
80003f96:	dfeff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80003f9a:	a91fd0ef          	jal	ra,80001a2a <z_clock_elapsed>
80003f9e:	800057b7          	lui	a5,0x80005
80003fa2:	da878793          	addi	a5,a5,-600 # 80004da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da9>
80003fa6:	0007a983          	lw	s3,0(a5)
80003faa:	43c0                	lw	s0,4(a5)
80003fac:	99aa                	add	s3,s3,a0
80003fae:	00a9b533          	sltu	a0,s3,a0
80003fb2:	942a                	add	s0,s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003fb4:	de890513          	addi	a0,s2,-536
80003fb8:	dbaff0ef          	jal	ra,80003572 <z_spin_unlock_valid>
80003fbc:	ed0d                	bnez	a0,80003ff6 <z_tick_get+0xbe>
80003fbe:	80005937          	lui	s2,0x80005
80003fc2:	800055b7          	lui	a1,0x80005
80003fc6:	80004537          	lui	a0,0x80004
80003fca:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80003fce:	06100693          	li	a3,97
80003fd2:	83090613          	addi	a2,s2,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
80003fd6:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80003fda:	ed8fd0ef          	jal	ra,800016b2 <printk>
80003fde:	80005537          	lui	a0,0x80005
80003fe2:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
80003fe6:	eccfd0ef          	jal	ra,800016b2 <printk>
80003fea:	06100593          	li	a1,97
80003fee:	83090513          	addi	a0,s2,-2000
80003ff2:	edefd0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003ff6:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80003ffa:	85a2                	mv	a1,s0
80003ffc:	40f2                	lw	ra,28(sp)
80003ffe:	4462                	lw	s0,24(sp)
80004000:	854e                	mv	a0,s3
80004002:	44d2                	lw	s1,20(sp)
80004004:	4942                	lw	s2,16(sp)
80004006:	49b2                	lw	s3,12(sp)
80004008:	6105                	addi	sp,sp,32
8000400a:	8082                	ret

8000400c <z_impl_atomic_add>:
 * @param value the value to add
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_add(atomic_t *target, atomic_val_t value)
{
8000400c:	1101                	addi	sp,sp,-32
8000400e:	cc22                	sw	s0,24(sp)
80004010:	c84a                	sw	s2,16(sp)
80004012:	c452                	sw	s4,8(sp)
80004014:	ce06                	sw	ra,28(sp)
80004016:	ca26                	sw	s1,20(sp)
80004018:	c64e                	sw	s3,12(sp)
8000401a:	8a2a                	mv	s4,a0
8000401c:	892e                	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000401e:	4421                	li	s0,8
80004020:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004024:	800054b7          	lui	s1,0x80005
80004028:	dec48513          	addi	a0,s1,-532 # 80004dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ded>
	key = (mstatus & SOC_MSTATUS_IEN);
8000402c:	8821                	andi	s0,s0,8
8000402e:	d2aff0ef          	jal	ra,80003558 <z_spin_lock_valid>
80004032:	ed0d                	bnez	a0,8000406c <z_impl_atomic_add+0x60>
80004034:	800059b7          	lui	s3,0x80005
80004038:	800055b7          	lui	a1,0x80005
8000403c:	80004537          	lui	a0,0x80004
80004040:	84858593          	addi	a1,a1,-1976 # 80004848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004849>
80004044:	04e00693          	li	a3,78
80004048:	83098613          	addi	a2,s3,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
8000404c:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
80004050:	e62fd0ef          	jal	ra,800016b2 <printk>
80004054:	80005537          	lui	a0,0x80005
80004058:	86050513          	addi	a0,a0,-1952 # 80004860 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004861>
8000405c:	e56fd0ef          	jal	ra,800016b2 <printk>
80004060:	04e00593          	li	a1,78
80004064:	83098513          	addi	a0,s3,-2000
80004068:	e68fd0ef          	jal	ra,800016d0 <assert_post_action>
	z_spin_lock_set_owner(l);
8000406c:	dec48513          	addi	a0,s1,-532
80004070:	d24ff0ef          	jal	ra,80003594 <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
80004074:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004078:	dec48513          	addi	a0,s1,-532
	*target += value;
8000407c:	994e                	add	s2,s2,s3
8000407e:	012a2023          	sw	s2,0(s4)
80004082:	cf0ff0ef          	jal	ra,80003572 <z_spin_unlock_valid>
80004086:	ed0d                	bnez	a0,800040c0 <z_impl_atomic_add+0xb4>
80004088:	800054b7          	lui	s1,0x80005
8000408c:	800055b7          	lui	a1,0x80005
80004090:	80004537          	lui	a0,0x80004
80004094:	87858593          	addi	a1,a1,-1928 # 80004878 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004879>
80004098:	06100693          	li	a3,97
8000409c:	83048613          	addi	a2,s1,-2000 # 80004830 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004831>
800040a0:	76450513          	addi	a0,a0,1892 # 80004764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004765>
800040a4:	e0efd0ef          	jal	ra,800016b2 <printk>
800040a8:	80005537          	lui	a0,0x80005
800040ac:	89050513          	addi	a0,a0,-1904 # 80004890 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004891>
800040b0:	e02fd0ef          	jal	ra,800016b2 <printk>
800040b4:	06100593          	li	a1,97
800040b8:	83048513          	addi	a0,s1,-2000
800040bc:	e14fd0ef          	jal	ra,800016d0 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800040c0:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
800040c4:	40f2                	lw	ra,28(sp)
800040c6:	4462                	lw	s0,24(sp)
800040c8:	854e                	mv	a0,s3
800040ca:	44d2                	lw	s1,20(sp)
800040cc:	4942                	lw	s2,16(sp)
800040ce:	49b2                	lw	s3,12(sp)
800040d0:	4a22                	lw	s4,8(sp)
800040d2:	6105                	addi	sp,sp,32
800040d4:	8082                	ret

800040d6 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
800040d6:	8082                	ret
