
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	6150006f          	j	80000e20 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	200000ef          	jal	ra,8000026c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	04051663          	bnez	a0,800000c0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	14408093          	addi	ra,ra,324 # 800001d8 <no_reschedule>
	tail _Fault
8000009c:	4950006f          	j	80000d30 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
800000ac:	00006297          	auipc	t0,0x6
800000b0:	ea028293          	addi	t0,t0,-352 # 80005f4c <_offload_routine>
	lw t1, 0x00(t0)
800000b4:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
800000b8:	00031463          	bnez	t1,800000c0 <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000bc:	0900006f          	j	8000014c <reschedule>

800000c0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000c0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000c4:	00006397          	auipc	t2,0x6
800000c8:	13038393          	addi	t2,t2,304 # 800061f4 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000cc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000d0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000d4:	00512023          	sw	t0,0(sp)

800000d8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000d8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000dc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000e0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000e4:	00030863          	beqz	t1,800000f4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000e8:	00000097          	auipc	ra,0x0
800000ec:	03c08093          	addi	ra,ra,60 # 80000124 <on_thread_stack>
	tail z_irq_do_offload
800000f0:	4cd0006f          	j	80000dbc <z_irq_do_offload>

800000f4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000f4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000f8:	800002b7          	lui	t0,0x80000
800000fc:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
80000100:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
80000104:	158000ef          	jal	ra,8000025c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
80000108:	00005297          	auipc	t0,0x5
8000010c:	e9428293          	addi	t0,t0,-364 # 80004f9c <_image_text_end>
	slli a0, a0, 3
80000110:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000114:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000118:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000011c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000120:	000300e7          	jalr	t1

80000124 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000124:	00006317          	auipc	t1,0x6
80000128:	0d030313          	addi	t1,t1,208 # 800061f4 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000012c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000130:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000134:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000138:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000013c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000140:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000144:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000148:	087e0863          	beq	t3,t2,800001d8 <no_reschedule>

8000014c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000014c:	00006297          	auipc	t0,0x6
80000150:	0a828293          	addi	t0,t0,168 # 800061f4 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000154:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000158:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000015c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000160:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000164:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000168:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000016c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000170:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000174:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000178:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000017c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000180:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000184:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000188:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000018c:	00006397          	auipc	t2,0x6
80000190:	d6038393          	addi	t2,t2,-672 # 80005eec <_k_neg_eagain>
	lw t3, 0x00(t2)
80000194:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000198:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000019c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
800001a0:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
800001a4:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
800001a8:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
800001ac:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001b0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001b4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001b8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001bc:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001c0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001c4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001c8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001cc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001d0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001d4:	05832d83          	lw	s11,88(t1)

800001d8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001d8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001dc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001e0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001e4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001e8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001ec:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001f0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001f4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001f8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001fc:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
80000200:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
80000204:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
80000208:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
8000020c:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000210:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000214:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000218:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000021c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000220:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000224:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000228:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000022c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000230:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000234:	30200073          	mret

80000238 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000238:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000023c:	00006297          	auipc	t0,0x6
80000240:	fb828293          	addi	t0,t0,-72 # 800061f4 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000244:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000248:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000024c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000250:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000254:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000025c:	00100313          	li	t1,1
	sll t0, t1, a0
80000260:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000264:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000268:	00008067          	ret

8000026c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000026c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000270:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000274:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000278:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000027c:	00028463          	beqz	t0,80000284 <not_interrupt>
	addi a0, a0, 1
80000280:	00150513          	addi	a0,a0,1

80000284 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000284:	00008067          	ret

Disassembly of section text:

80000288 <__lshrdi3>:
80000288:	02060063          	beqz	a2,800002a8 <__lshrdi3+0x20>
8000028c:	02000793          	li	a5,32
80000290:	40c787b3          	sub	a5,a5,a2
80000294:	00f04c63          	bgtz	a5,800002ac <__lshrdi3+0x24>
80000298:	fe060513          	addi	a0,a2,-32
8000029c:	00000713          	li	a4,0
800002a0:	00a5d533          	srl	a0,a1,a0
800002a4:	00070593          	mv	a1,a4
800002a8:	00008067          	ret
800002ac:	00c5d733          	srl	a4,a1,a2
800002b0:	00c55533          	srl	a0,a0,a2
800002b4:	00f595b3          	sll	a1,a1,a5
800002b8:	00b56533          	or	a0,a0,a1
800002bc:	fe9ff06f          	j	800002a4 <__lshrdi3+0x1c>

800002c0 <__udivdi3>:
800002c0:	00058793          	mv	a5,a1
800002c4:	00060813          	mv	a6,a2
800002c8:	00068713          	mv	a4,a3
800002cc:	00050313          	mv	t1,a0
800002d0:	28069663          	bnez	a3,8000055c <__udivdi3+0x29c>
800002d4:	00005897          	auipc	a7,0x5
800002d8:	e4888893          	addi	a7,a7,-440 # 8000511c <__devconfig_end>
800002dc:	0ec5f663          	bgeu	a1,a2,800003c8 <__udivdi3+0x108>
800002e0:	00010737          	lui	a4,0x10
800002e4:	0ce67863          	bgeu	a2,a4,800003b4 <__udivdi3+0xf4>
800002e8:	0ff00713          	li	a4,255
800002ec:	00c73733          	sltu	a4,a4,a2
800002f0:	00371713          	slli	a4,a4,0x3
800002f4:	00e656b3          	srl	a3,a2,a4
800002f8:	00d888b3          	add	a7,a7,a3
800002fc:	0008c683          	lbu	a3,0(a7)
80000300:	00e68733          	add	a4,a3,a4
80000304:	02000693          	li	a3,32
80000308:	40e686b3          	sub	a3,a3,a4
8000030c:	00068c63          	beqz	a3,80000324 <__udivdi3+0x64>
80000310:	00d797b3          	sll	a5,a5,a3
80000314:	00e55733          	srl	a4,a0,a4
80000318:	00d61833          	sll	a6,a2,a3
8000031c:	00f765b3          	or	a1,a4,a5
80000320:	00d51333          	sll	t1,a0,a3
80000324:	01085513          	srli	a0,a6,0x10
80000328:	02a5f733          	remu	a4,a1,a0
8000032c:	01081613          	slli	a2,a6,0x10
80000330:	01065613          	srli	a2,a2,0x10
80000334:	01035693          	srli	a3,t1,0x10
80000338:	02a5d5b3          	divu	a1,a1,a0
8000033c:	01071713          	slli	a4,a4,0x10
80000340:	00d766b3          	or	a3,a4,a3
80000344:	02b607b3          	mul	a5,a2,a1
80000348:	00058713          	mv	a4,a1
8000034c:	00f6fe63          	bgeu	a3,a5,80000368 <__udivdi3+0xa8>
80000350:	010686b3          	add	a3,a3,a6
80000354:	fff58713          	addi	a4,a1,-1
80000358:	0106e863          	bltu	a3,a6,80000368 <__udivdi3+0xa8>
8000035c:	00f6f663          	bgeu	a3,a5,80000368 <__udivdi3+0xa8>
80000360:	ffe58713          	addi	a4,a1,-2
80000364:	010686b3          	add	a3,a3,a6
80000368:	40f686b3          	sub	a3,a3,a5
8000036c:	02a6f7b3          	remu	a5,a3,a0
80000370:	01031313          	slli	t1,t1,0x10
80000374:	01035313          	srli	t1,t1,0x10
80000378:	02a6d6b3          	divu	a3,a3,a0
8000037c:	01079793          	slli	a5,a5,0x10
80000380:	0067e333          	or	t1,a5,t1
80000384:	02d605b3          	mul	a1,a2,a3
80000388:	00068513          	mv	a0,a3
8000038c:	00b37c63          	bgeu	t1,a1,800003a4 <__udivdi3+0xe4>
80000390:	00680333          	add	t1,a6,t1
80000394:	fff68513          	addi	a0,a3,-1
80000398:	01036663          	bltu	t1,a6,800003a4 <__udivdi3+0xe4>
8000039c:	00b37463          	bgeu	t1,a1,800003a4 <__udivdi3+0xe4>
800003a0:	ffe68513          	addi	a0,a3,-2
800003a4:	01071713          	slli	a4,a4,0x10
800003a8:	00a76733          	or	a4,a4,a0
800003ac:	00000593          	li	a1,0
800003b0:	0e40006f          	j	80000494 <__udivdi3+0x1d4>
800003b4:	010006b7          	lui	a3,0x1000
800003b8:	01000713          	li	a4,16
800003bc:	f2d66ce3          	bltu	a2,a3,800002f4 <__udivdi3+0x34>
800003c0:	01800713          	li	a4,24
800003c4:	f31ff06f          	j	800002f4 <__udivdi3+0x34>
800003c8:	00061663          	bnez	a2,800003d4 <__udivdi3+0x114>
800003cc:	00100693          	li	a3,1
800003d0:	02c6d833          	divu	a6,a3,a2
800003d4:	000106b7          	lui	a3,0x10
800003d8:	0cd87263          	bgeu	a6,a3,8000049c <__udivdi3+0x1dc>
800003dc:	0ff00693          	li	a3,255
800003e0:	0106f463          	bgeu	a3,a6,800003e8 <__udivdi3+0x128>
800003e4:	00800713          	li	a4,8
800003e8:	00e856b3          	srl	a3,a6,a4
800003ec:	00d888b3          	add	a7,a7,a3
800003f0:	0008c683          	lbu	a3,0(a7)
800003f4:	00e686b3          	add	a3,a3,a4
800003f8:	02000713          	li	a4,32
800003fc:	40d70733          	sub	a4,a4,a3
80000400:	0a071863          	bnez	a4,800004b0 <__udivdi3+0x1f0>
80000404:	410787b3          	sub	a5,a5,a6
80000408:	00100593          	li	a1,1
8000040c:	01085613          	srli	a2,a6,0x10
80000410:	01081893          	slli	a7,a6,0x10
80000414:	0108d893          	srli	a7,a7,0x10
80000418:	01035693          	srli	a3,t1,0x10
8000041c:	02c7f733          	remu	a4,a5,a2
80000420:	02c7d7b3          	divu	a5,a5,a2
80000424:	01071713          	slli	a4,a4,0x10
80000428:	00d766b3          	or	a3,a4,a3
8000042c:	02f88533          	mul	a0,a7,a5
80000430:	00078713          	mv	a4,a5
80000434:	00a6fe63          	bgeu	a3,a0,80000450 <__udivdi3+0x190>
80000438:	010686b3          	add	a3,a3,a6
8000043c:	fff78713          	addi	a4,a5,-1
80000440:	0106e863          	bltu	a3,a6,80000450 <__udivdi3+0x190>
80000444:	00a6f663          	bgeu	a3,a0,80000450 <__udivdi3+0x190>
80000448:	ffe78713          	addi	a4,a5,-2
8000044c:	010686b3          	add	a3,a3,a6
80000450:	40a686b3          	sub	a3,a3,a0
80000454:	02c6f7b3          	remu	a5,a3,a2
80000458:	01031313          	slli	t1,t1,0x10
8000045c:	01035313          	srli	t1,t1,0x10
80000460:	02c6d6b3          	divu	a3,a3,a2
80000464:	01079793          	slli	a5,a5,0x10
80000468:	0067e333          	or	t1,a5,t1
8000046c:	02d888b3          	mul	a7,a7,a3
80000470:	00068513          	mv	a0,a3
80000474:	01137c63          	bgeu	t1,a7,8000048c <__udivdi3+0x1cc>
80000478:	00680333          	add	t1,a6,t1
8000047c:	fff68513          	addi	a0,a3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000480:	01036663          	bltu	t1,a6,8000048c <__udivdi3+0x1cc>
80000484:	01137463          	bgeu	t1,a7,8000048c <__udivdi3+0x1cc>
80000488:	ffe68513          	addi	a0,a3,-2
8000048c:	01071713          	slli	a4,a4,0x10
80000490:	00a76733          	or	a4,a4,a0
80000494:	00070513          	mv	a0,a4
80000498:	00008067          	ret
8000049c:	010006b7          	lui	a3,0x1000
800004a0:	01000713          	li	a4,16
800004a4:	f4d862e3          	bltu	a6,a3,800003e8 <__udivdi3+0x128>
800004a8:	01800713          	li	a4,24
800004ac:	f3dff06f          	j	800003e8 <__udivdi3+0x128>
800004b0:	00e81833          	sll	a6,a6,a4
800004b4:	00d7d5b3          	srl	a1,a5,a3
800004b8:	00e51333          	sll	t1,a0,a4
800004bc:	00d556b3          	srl	a3,a0,a3
800004c0:	01085513          	srli	a0,a6,0x10
800004c4:	00e797b3          	sll	a5,a5,a4
800004c8:	02a5f733          	remu	a4,a1,a0
800004cc:	00f6e8b3          	or	a7,a3,a5
800004d0:	01081793          	slli	a5,a6,0x10
800004d4:	0107d793          	srli	a5,a5,0x10
800004d8:	0108d613          	srli	a2,a7,0x10
800004dc:	02a5d5b3          	divu	a1,a1,a0
800004e0:	01071713          	slli	a4,a4,0x10
800004e4:	00c76733          	or	a4,a4,a2
800004e8:	02b786b3          	mul	a3,a5,a1
800004ec:	00058613          	mv	a2,a1
800004f0:	00d77e63          	bgeu	a4,a3,8000050c <__udivdi3+0x24c>
800004f4:	01070733          	add	a4,a4,a6
800004f8:	fff58613          	addi	a2,a1,-1
800004fc:	01076863          	bltu	a4,a6,8000050c <__udivdi3+0x24c>
80000500:	00d77663          	bgeu	a4,a3,8000050c <__udivdi3+0x24c>
80000504:	ffe58613          	addi	a2,a1,-2
80000508:	01070733          	add	a4,a4,a6
8000050c:	40d706b3          	sub	a3,a4,a3
80000510:	02a6f733          	remu	a4,a3,a0
80000514:	01089893          	slli	a7,a7,0x10
80000518:	0108d893          	srli	a7,a7,0x10
8000051c:	02a6d6b3          	divu	a3,a3,a0
80000520:	01071713          	slli	a4,a4,0x10
80000524:	02d785b3          	mul	a1,a5,a3
80000528:	011767b3          	or	a5,a4,a7
8000052c:	00068713          	mv	a4,a3
80000530:	00b7fe63          	bgeu	a5,a1,8000054c <__udivdi3+0x28c>
80000534:	010787b3          	add	a5,a5,a6
80000538:	fff68713          	addi	a4,a3,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000053c:	0107e863          	bltu	a5,a6,8000054c <__udivdi3+0x28c>
80000540:	00b7f663          	bgeu	a5,a1,8000054c <__udivdi3+0x28c>
80000544:	ffe68713          	addi	a4,a3,-2
80000548:	010787b3          	add	a5,a5,a6
8000054c:	40b787b3          	sub	a5,a5,a1
80000550:	01061593          	slli	a1,a2,0x10
80000554:	00e5e5b3          	or	a1,a1,a4
80000558:	eb5ff06f          	j	8000040c <__udivdi3+0x14c>
8000055c:	18d5e663          	bltu	a1,a3,800006e8 <__udivdi3+0x428>
80000560:	00010737          	lui	a4,0x10
80000564:	04e6f463          	bgeu	a3,a4,800005ac <__udivdi3+0x2ec>
80000568:	0ff00813          	li	a6,255
8000056c:	00d83733          	sltu	a4,a6,a3
80000570:	00371713          	slli	a4,a4,0x3
80000574:	00e6d833          	srl	a6,a3,a4
80000578:	00005597          	auipc	a1,0x5
8000057c:	ba458593          	addi	a1,a1,-1116 # 8000511c <__devconfig_end>
80000580:	010585b3          	add	a1,a1,a6
80000584:	0005c803          	lbu	a6,0(a1)
80000588:	02000593          	li	a1,32
8000058c:	00e80833          	add	a6,a6,a4
80000590:	410585b3          	sub	a1,a1,a6
80000594:	02059663          	bnez	a1,800005c0 <__udivdi3+0x300>
80000598:	00100713          	li	a4,1
8000059c:	eef6ece3          	bltu	a3,a5,80000494 <__udivdi3+0x1d4>
800005a0:	00c53533          	sltu	a0,a0,a2
800005a4:	00154713          	xori	a4,a0,1
800005a8:	eedff06f          	j	80000494 <__udivdi3+0x1d4>
800005ac:	010005b7          	lui	a1,0x1000
800005b0:	01000713          	li	a4,16
800005b4:	fcb6e0e3          	bltu	a3,a1,80000574 <__udivdi3+0x2b4>
800005b8:	01800713          	li	a4,24
800005bc:	fb9ff06f          	j	80000574 <__udivdi3+0x2b4>
800005c0:	01065733          	srl	a4,a2,a6
800005c4:	00b696b3          	sll	a3,a3,a1
800005c8:	00d766b3          	or	a3,a4,a3
800005cc:	0106de93          	srli	t4,a3,0x10
800005d0:	0107d733          	srl	a4,a5,a6
800005d4:	03d778b3          	remu	a7,a4,t4
800005d8:	00b797b3          	sll	a5,a5,a1
800005dc:	01055833          	srl	a6,a0,a6
800005e0:	00f86333          	or	t1,a6,a5
800005e4:	01069793          	slli	a5,a3,0x10
800005e8:	0107d793          	srli	a5,a5,0x10
800005ec:	01035813          	srli	a6,t1,0x10
800005f0:	00b61633          	sll	a2,a2,a1
800005f4:	03d75733          	divu	a4,a4,t4
800005f8:	01089893          	slli	a7,a7,0x10
800005fc:	0108e833          	or	a6,a7,a6
80000600:	02e78f33          	mul	t5,a5,a4
80000604:	00070e13          	mv	t3,a4
80000608:	01e87e63          	bgeu	a6,t5,80000624 <__udivdi3+0x364>
8000060c:	00d80833          	add	a6,a6,a3
80000610:	fff70e13          	addi	t3,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000614:	00d86863          	bltu	a6,a3,80000624 <__udivdi3+0x364>
80000618:	01e87663          	bgeu	a6,t5,80000624 <__udivdi3+0x364>
8000061c:	ffe70e13          	addi	t3,a4,-2
80000620:	00d80833          	add	a6,a6,a3
80000624:	41e80833          	sub	a6,a6,t5
80000628:	03d878b3          	remu	a7,a6,t4
8000062c:	03d85833          	divu	a6,a6,t4
80000630:	01089893          	slli	a7,a7,0x10
80000634:	03078eb3          	mul	t4,a5,a6
80000638:	01031793          	slli	a5,t1,0x10
8000063c:	0107d793          	srli	a5,a5,0x10
80000640:	00f8e7b3          	or	a5,a7,a5
80000644:	00080713          	mv	a4,a6
80000648:	01d7fe63          	bgeu	a5,t4,80000664 <__udivdi3+0x3a4>
8000064c:	00d787b3          	add	a5,a5,a3
80000650:	fff80713          	addi	a4,a6,-1
80000654:	00d7e863          	bltu	a5,a3,80000664 <__udivdi3+0x3a4>
80000658:	01d7f663          	bgeu	a5,t4,80000664 <__udivdi3+0x3a4>
8000065c:	ffe80713          	addi	a4,a6,-2
80000660:	00d787b3          	add	a5,a5,a3
80000664:	010e1e13          	slli	t3,t3,0x10
80000668:	41d787b3          	sub	a5,a5,t4
8000066c:	00010eb7          	lui	t4,0x10
80000670:	00ee6733          	or	a4,t3,a4
80000674:	fffe8813          	addi	a6,t4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000678:	01077333          	and	t1,a4,a6
8000067c:	01075893          	srli	a7,a4,0x10
80000680:	01067833          	and	a6,a2,a6
80000684:	01065613          	srli	a2,a2,0x10
80000688:	03030e33          	mul	t3,t1,a6
8000068c:	03088833          	mul	a6,a7,a6
80000690:	010e5693          	srli	a3,t3,0x10
80000694:	02c30333          	mul	t1,t1,a2
80000698:	01030333          	add	t1,t1,a6
8000069c:	006686b3          	add	a3,a3,t1
800006a0:	02c888b3          	mul	a7,a7,a2
800006a4:	0106f463          	bgeu	a3,a6,800006ac <__udivdi3+0x3ec>
800006a8:	01d888b3          	add	a7,a7,t4
800006ac:	0106d613          	srli	a2,a3,0x10
800006b0:	011608b3          	add	a7,a2,a7
800006b4:	0317e663          	bltu	a5,a7,800006e0 <__udivdi3+0x420>
800006b8:	cf179ae3          	bne	a5,a7,800003ac <__udivdi3+0xec>
800006bc:	000107b7          	lui	a5,0x10
800006c0:	fff78793          	addi	a5,a5,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800006c4:	00f6f6b3          	and	a3,a3,a5
800006c8:	01069693          	slli	a3,a3,0x10
800006cc:	00fe7e33          	and	t3,t3,a5
800006d0:	00b51533          	sll	a0,a0,a1
800006d4:	01c686b3          	add	a3,a3,t3
800006d8:	00000593          	li	a1,0
800006dc:	dad57ce3          	bgeu	a0,a3,80000494 <__udivdi3+0x1d4>
800006e0:	fff70713          	addi	a4,a4,-1
800006e4:	cc9ff06f          	j	800003ac <__udivdi3+0xec>
800006e8:	00000593          	li	a1,0
800006ec:	00000713          	li	a4,0
800006f0:	da5ff06f          	j	80000494 <__udivdi3+0x1d4>

800006f4 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800006f4:	00008067          	ret

800006f8 <irq_offload_isr>:

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
800006f8:	56c0306f          	j	80003c64 <z_impl_k_wakeup>

800006fc <align_to_tick_boundary>:

	TC_PRINT("Kernel objects initialized\n");
}

static void align_to_tick_boundary(void)
{
800006fc:	ff010113          	addi	sp,sp,-16
80000700:	00812423          	sw	s0,8(sp)
80000704:	00112623          	sw	ra,12(sp)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)

K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000708:	009040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
8000070c:	00050413          	mv	s0,a0
80000710:	001040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
	u32_t tick;

	tick = k_uptime_get_32();
	while (k_uptime_get_32() == tick) {
80000714:	fea40ee3          	beq	s0,a0,80000710 <align_to_tick_boundary+0x14>
#if defined(CONFIG_ARCH_POSIX)
		k_busy_wait(50);
#endif
	}

}
80000718:	00c12083          	lw	ra,12(sp)
8000071c:	00812403          	lw	s0,8(sp)
80000720:	01010113          	addi	sp,sp,16
80000724:	00008067          	ret

80000728 <z_zassert.constprop.2>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000728:	fd010113          	addi	sp,sp,-48
8000072c:	00112e23          	sw	ra,28(sp)
80000730:	00812c23          	sw	s0,24(sp)
80000734:	03012423          	sw	a6,40(sp)
80000738:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
8000073c:	04051863          	bnez	a0,8000078c <z_zassert.constprop.2+0x64>
80000740:	00068613          	mv	a2,a3
80000744:	00058713          	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000748:	800056b7          	lui	a3,0x80005
8000074c:	800055b7          	lui	a1,0x80005
80000750:	80005537          	lui	a0,0x80005
80000754:	22868693          	addi	a3,a3,552 # 80005228 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005229>
80000758:	00078413          	mv	s0,a5
8000075c:	4cc58593          	addi	a1,a1,1228 # 800054cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054cd>
		va_start(vargs, msg);
80000760:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000764:	4ec50513          	addi	a0,a0,1260 # 800054ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054ed>
		va_start(vargs, msg);
80000768:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000076c:	7c9000ef          	jal	ra,80001734 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000770:	00c12583          	lw	a1,12(sp)
80000774:	00040513          	mv	a0,s0
80000778:	78d000ef          	jal	ra,80001704 <vprintk>
		printk("\n");
8000077c:	80005537          	lui	a0,0x80005
80000780:	2e450513          	addi	a0,a0,740 # 800052e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e5>
80000784:	7b1000ef          	jal	ra,80001734 <printk>
		va_end(vargs);
		ztest_test_fail();
80000788:	674010ef          	jal	ra,80001dfc <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
8000078c:	01c12083          	lw	ra,28(sp)
80000790:	01812403          	lw	s0,24(sp)
80000794:	03010113          	addi	sp,sp,48
80000798:	00008067          	ret

8000079c <helper_thread>:

	k_wakeup((k_tid_t) arg);
}

static void helper_thread(int arg1, int arg2)
{
8000079c:	ff010113          	addi	sp,sp,-16
800007a0:	00912223          	sw	s1,4(sp)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800007a4:	800064b7          	lui	s1,0x80006
800007a8:	00812423          	sw	s0,8(sp)
800007ac:	fff00593          	li	a1,-1
800007b0:	ff448513          	addi	a0,s1,-12 # 80005ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff5>

	k_sem_take(&helper_thread_sem, K_FOREVER);
	/* Wake the test thread */
	k_wakeup(test_thread_id);
800007b4:	80006437          	lui	s0,0x80006
{
800007b8:	00112623          	sw	ra,12(sp)
	k_wakeup(test_thread_id);
800007bc:	f4840413          	addi	s0,s0,-184 # 80005f48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f49>
800007c0:	6d4030ef          	jal	ra,80003e94 <z_impl_k_sem_take>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
800007c4:	00042503          	lw	a0,0(s0)
800007c8:	49c030ef          	jal	ra,80003c64 <z_impl_k_wakeup>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800007cc:	fff00593          	li	a1,-1
800007d0:	ff448513          	addi	a0,s1,-12
800007d4:	6c0030ef          	jal	ra,80003e94 <z_impl_k_sem_take>
	k_sem_take(&helper_thread_sem, K_FOREVER);
	/* Wake the test thread from an ISR */
	irq_offload(irq_offload_isr, (void *)test_thread_id);
800007d8:	00042583          	lw	a1,0(s0)
}
800007dc:	00812403          	lw	s0,8(sp)
800007e0:	00c12083          	lw	ra,12(sp)
800007e4:	00412483          	lw	s1,4(sp)
	irq_offload(irq_offload_isr, (void *)test_thread_id);
800007e8:	80000537          	lui	a0,0x80000
800007ec:	6f850513          	addi	a0,a0,1784 # 800006f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800006f9>
}
800007f0:	01010113          	addi	sp,sp,16
	irq_offload(irq_offload_isr, (void *)test_thread_id);
800007f4:	5f00006f          	j	80000de4 <irq_offload>

800007f8 <test_sleep>:
 * @ingroup kernel_sleep_tests
 *
 * @see k_sleep(), k_wakeup(), k_uptime_get_32()
 */
void test_sleep(void)
{
800007f8:	fe010113          	addi	sp,sp,-32
800007fc:	00112e23          	sw	ra,28(sp)
80000800:	00812c23          	sw	s0,24(sp)
80000804:	00912a23          	sw	s1,20(sp)
80000808:	01212823          	sw	s2,16(sp)
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000080c:	4d0030ef          	jal	ra,80003cdc <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000810:	00000593          	li	a1,0
80000814:	74d020ef          	jal	ra,80003760 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000818:	80006937          	lui	s2,0x80006
8000081c:	08490513          	addi	a0,s2,132 # 80006084 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006085>
80000820:	fff00613          	li	a2,-1
80000824:	00000593          	li	a1,0
80000828:	4c0030ef          	jal	ra,80003ce8 <z_impl_k_sem_init>
8000082c:	80006537          	lui	a0,0x80006
80000830:	fff00613          	li	a2,-1
80000834:	00000593          	li	a1,0
80000838:	ff450513          	addi	a0,a0,-12 # 80005ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff5>
8000083c:	4ac030ef          	jal	ra,80003ce8 <z_impl_k_sem_init>
80000840:	800064b7          	lui	s1,0x80006
80000844:	fff00613          	li	a2,-1
80000848:	00000593          	li	a1,0
8000084c:	00448513          	addi	a0,s1,4 # 80006004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006005>
80000850:	498030ef          	jal	ra,80003ce8 <z_impl_k_sem_init>
	TC_PRINT("Kernel objects initialized\n");
80000854:	80005537          	lui	a0,0x80005
80000858:	24850513          	addi	a0,a0,584 # 80005248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005249>
8000085c:	6d9000ef          	jal	ra,80001734 <printk>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000860:	800016b7          	lui	a3,0x80001
80000864:	800065b7          	lui	a1,0x80006
80000868:	80006537          	lui	a0,0x80006
8000086c:	ffc00893          	li	a7,-4
80000870:	00000813          	li	a6,0
80000874:	00000793          	li	a5,0
80000878:	00000713          	li	a4,0
8000087c:	9b468693          	addi	a3,a3,-1612 # 800009b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009b5>
80000880:	18000613          	li	a2,384
80000884:	00012223          	sw	zero,4(sp)
80000888:	00012023          	sw	zero,0(sp)
8000088c:	22058593          	addi	a1,a1,544 # 80006220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006221>
80000890:	01450513          	addi	a0,a0,20 # 80006014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006015>
	 * threads run at same priority level.
	 */
	k_thread_priority_set(k_current_get(), 0);
	test_objects_init();

	test_thread_id = k_thread_create(&test_thread_data, test_thread_stack,
80000894:	80006437          	lui	s0,0x80006
80000898:	299030ef          	jal	ra,80004330 <z_impl_k_thread_create>
8000089c:	f4840413          	addi	s0,s0,-184 # 80005f48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f49>
800008a0:	00050593          	mv	a1,a0
800008a4:	00a42023          	sw	a0,0(s0)
					 THREAD_STACK,
					 (k_thread_entry_t) test_thread,
					 0, 0, NULL, TEST_THREAD_PRIORITY,
					 0, 0);

	TC_PRINT("Test thread started: id = %p\n", test_thread_id);
800008a8:	80005537          	lui	a0,0x80005
800008ac:	26450513          	addi	a0,a0,612 # 80005264 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005265>
800008b0:	685000ef          	jal	ra,80001734 <printk>
800008b4:	800006b7          	lui	a3,0x80000
800008b8:	800065b7          	lui	a1,0x80006
800008bc:	80006537          	lui	a0,0x80006
800008c0:	ff600893          	li	a7,-10
800008c4:	00000813          	li	a6,0
800008c8:	00000793          	li	a5,0
800008cc:	00000713          	li	a4,0
800008d0:	79c68693          	addi	a3,a3,1948 # 8000079c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000079d>
800008d4:	18000613          	li	a2,384
800008d8:	00012223          	sw	zero,4(sp)
800008dc:	00012023          	sw	zero,0(sp)
800008e0:	3a058593          	addi	a1,a1,928 # 800063a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063a1>
800008e4:	f8450513          	addi	a0,a0,-124 # 80005f84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f85>
800008e8:	249030ef          	jal	ra,80004330 <z_impl_k_thread_create>
					   helper_thread_stack, THREAD_STACK,
					   (k_thread_entry_t) helper_thread,
					   0, 0, NULL, HELPER_THREAD_PRIORITY,
					   0, 0);

	TC_PRINT("Helper thread started: id = %p\n", helper_thread_id);
800008ec:	00050593          	mv	a1,a0
800008f0:	80005537          	lui	a0,0x80005
800008f4:	28450513          	addi	a0,a0,644 # 80005284 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005285>
800008f8:	63d000ef          	jal	ra,80001734 <printk>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800008fc:	08490513          	addi	a0,s2,132
80000900:	4b0030ef          	jal	ra,80003db0 <z_impl_k_sem_give>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000904:	fff00593          	li	a1,-1
80000908:	00448513          	addi	a0,s1,4
8000090c:	588030ef          	jal	ra,80003e94 <z_impl_k_sem_take>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
80000910:	00042503          	lw	a0,0(s0)
	k_sem_take(&task_sem, K_FOREVER);

	/* Wake the test thread */
	k_wakeup(test_thread_id);

	zassert_false(test_failure, "test failure");
80000914:	80005937          	lui	s2,0x80005
80000918:	800054b7          	lui	s1,0x80005
8000091c:	348030ef          	jal	ra,80003c64 <z_impl_k_wakeup>
80000920:	800067b7          	lui	a5,0x80006
80000924:	ee87c503          	lbu	a0,-280(a5) # 80005ee8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee9>
80000928:	800055b7          	lui	a1,0x80005
8000092c:	800057b7          	lui	a5,0x80005
80000930:	22890713          	addi	a4,s2,552 # 80005228 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005229>
80000934:	4cc48613          	addi	a2,s1,1228 # 800054cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054cd>
80000938:	2a478793          	addi	a5,a5,676 # 800052a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a5>
8000093c:	0de00693          	li	a3,222
80000940:	2b458593          	addi	a1,a1,692 # 800052b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b5>
80000944:	00154513          	xori	a0,a0,1
80000948:	de1ff0ef          	jal	ra,80000728 <z_zassert.constprop.2>

	TC_PRINT("Testing kernel k_sleep()\n");
8000094c:	80005537          	lui	a0,0x80005
80000950:	2cc50513          	addi	a0,a0,716 # 800052cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052cd>
80000954:	5e1000ef          	jal	ra,80001734 <printk>
	align_to_tick_boundary();
80000958:	da5ff0ef          	jal	ra,800006fc <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
8000095c:	5b4040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
80000960:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000964:	3e800513          	li	a0,1000
80000968:	0c0030ef          	jal	ra,80003a28 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
8000096c:	5a4040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
	u32_t dt = end - start;
80000970:	40850833          	sub	a6,a0,s0
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
		     "k_sleep() slept for %d ticks, not %d\n",
		     end_tick - start_tick, ONE_SECOND_ALIGNED);

	status = TC_PASS;
}
80000974:	01812403          	lw	s0,24(sp)
80000978:	01c12083          	lw	ra,28(sp)
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
8000097c:	22890713          	addi	a4,s2,552
80000980:	4cc48613          	addi	a2,s1,1228
}
80000984:	01012903          	lw	s2,16(sp)
80000988:	01412483          	lw	s1,20(sp)
	return dt >= dur && dt <= (dur + 1);
8000098c:	c0e80513          	addi	a0,a6,-1010
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
80000990:	800057b7          	lui	a5,0x80005
80000994:	800055b7          	lui	a1,0x80005
80000998:	3f200893          	li	a7,1010
8000099c:	2e878793          	addi	a5,a5,744 # 800052e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052e9>
800009a0:	0e700693          	li	a3,231
800009a4:	31058593          	addi	a1,a1,784 # 80005310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005311>
800009a8:	00253513          	sltiu	a0,a0,2
}
800009ac:	02010113          	addi	sp,sp,32
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
800009b0:	d79ff06f          	j	80000728 <z_zassert.constprop.2>

800009b4 <test_thread>:
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800009b4:	80006537          	lui	a0,0x80006
{
800009b8:	ff010113          	addi	sp,sp,-16
800009bc:	fff00593          	li	a1,-1
800009c0:	08450513          	addi	a0,a0,132 # 80006084 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006085>
800009c4:	00112623          	sw	ra,12(sp)
800009c8:	00812423          	sw	s0,8(sp)
800009cc:	00912223          	sw	s1,4(sp)
800009d0:	01212023          	sw	s2,0(sp)
800009d4:	4c0030ef          	jal	ra,80003e94 <z_impl_k_sem_take>
	TC_PRINT("Testing normal expiration of k_sleep()\n");
800009d8:	80005537          	lui	a0,0x80005
800009dc:	35850513          	addi	a0,a0,856 # 80005358 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005359>
800009e0:	555000ef          	jal	ra,80001734 <printk>
	align_to_tick_boundary();
800009e4:	d19ff0ef          	jal	ra,800006fc <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
800009e8:	528040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
800009ec:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
800009f0:	3e800513          	li	a0,1000
800009f4:	034030ef          	jal	ra,80003a28 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
800009f8:	518040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
	u32_t dt = end - start;
800009fc:	40850433          	sub	s0,a0,s0
	return dt >= dur && dt <= (dur + 1);
80000a00:	c0e40793          	addi	a5,s0,-1010
80000a04:	00100493          	li	s1,1
80000a08:	08f4e063          	bltu	s1,a5,80000a88 <test_thread+0xd4>
	TC_PRINT("Testing: test thread sleep + helper thread wakeup test\n");
80000a0c:	80005537          	lui	a0,0x80005
80000a10:	38050513          	addi	a0,a0,896 # 80005380 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005381>
80000a14:	521000ef          	jal	ra,80001734 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000a18:	80006937          	lui	s2,0x80006
80000a1c:	ff490513          	addi	a0,s2,-12 # 80005ff4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ff5>
80000a20:	390030ef          	jal	ra,80003db0 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000a24:	cd9ff0ef          	jal	ra,800006fc <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000a28:	4e8040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
80000a2c:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000a30:	3e800513          	li	a0,1000
80000a34:	7f5020ef          	jal	ra,80003a28 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000a38:	4d8040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000a3c:	40850433          	sub	s0,a0,s0
80000a40:	0884f863          	bgeu	s1,s0,80000ad0 <test_thread+0x11c>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000a44:	07d00693          	li	a3,125
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000a48:	80005637          	lui	a2,0x80005
80000a4c:	800055b7          	lui	a1,0x80005
80000a50:	80005537          	lui	a0,0x80005
80000a54:	3b858593          	addi	a1,a1,952 # 800053b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053b9>
80000a58:	3c050513          	addi	a0,a0,960 # 800053c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053c1>
80000a5c:	21c60613          	addi	a2,a2,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80000a60:	4d5000ef          	jal	ra,80001734 <printk>
80000a64:	80005537          	lui	a0,0x80005
80000a68:	00040593          	mv	a1,s0
80000a6c:	3fc50513          	addi	a0,a0,1020 # 800053fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053fd>
}
80000a70:	00812403          	lw	s0,8(sp)
80000a74:	00c12083          	lw	ra,12(sp)
80000a78:	00412483          	lw	s1,4(sp)
80000a7c:	00012903          	lw	s2,0(sp)
80000a80:	01010113          	addi	sp,sp,16
		TC_ERROR(" *** k_wakeup() took too long (%d ticks) at LAST\n",
80000a84:	4b10006f          	j	80001734 <printk>
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000a88:	80005637          	lui	a2,0x80005
80000a8c:	800055b7          	lui	a1,0x80005
80000a90:	80005537          	lui	a0,0x80005
80000a94:	21c60613          	addi	a2,a2,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80000a98:	3b858593          	addi	a1,a1,952 # 800053b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053b9>
80000a9c:	3c050513          	addi	a0,a0,960 # 800053c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053c1>
80000aa0:	06e00693          	li	a3,110
80000aa4:	491000ef          	jal	ra,80001734 <printk>
80000aa8:	00040593          	mv	a1,s0
}
80000aac:	00812403          	lw	s0,8(sp)
80000ab0:	00c12083          	lw	ra,12(sp)
80000ab4:	00412483          	lw	s1,4(sp)
80000ab8:	00012903          	lw	s2,0(sp)
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000abc:	80005537          	lui	a0,0x80005
80000ac0:	3f200613          	li	a2,1010
80000ac4:	3d050513          	addi	a0,a0,976 # 800053d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053d1>
}
80000ac8:	01010113          	addi	sp,sp,16
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000acc:	4690006f          	j	80001734 <printk>
	TC_PRINT("Testing: test thread sleep + isr offload wakeup test\n");
80000ad0:	80005537          	lui	a0,0x80005
80000ad4:	42850513          	addi	a0,a0,1064 # 80005428 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005429>
80000ad8:	45d000ef          	jal	ra,80001734 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000adc:	ff490513          	addi	a0,s2,-12
80000ae0:	2d0030ef          	jal	ra,80003db0 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000ae4:	c19ff0ef          	jal	ra,800006fc <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000ae8:	428040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
80000aec:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000af0:	3e800513          	li	a0,1000
80000af4:	735020ef          	jal	ra,80003a28 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000af8:	418040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000afc:	40850433          	sub	s0,a0,s0
80000b00:	0084f663          	bgeu	s1,s0,80000b0c <test_thread+0x158>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000b04:	08b00693          	li	a3,139
80000b08:	f41ff06f          	j	80000a48 <test_thread+0x94>
	TC_PRINT("Testing: test thread sleep + main wakeup test thread\n");
80000b0c:	80005537          	lui	a0,0x80005
80000b10:	46050513          	addi	a0,a0,1120 # 80005460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005461>
80000b14:	421000ef          	jal	ra,80001734 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b18:	80006537          	lui	a0,0x80006
80000b1c:	00450513          	addi	a0,a0,4 # 80006004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006005>
80000b20:	290030ef          	jal	ra,80003db0 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000b24:	bd9ff0ef          	jal	ra,800006fc <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000b28:	3e8040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
80000b2c:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000b30:	3e800513          	li	a0,1000
80000b34:	6f5020ef          	jal	ra,80003a28 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000b38:	3d8040ef          	jal	ra,80004f10 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000b3c:	40850433          	sub	s0,a0,s0
80000b40:	0284fa63          	bgeu	s1,s0,80000b74 <test_thread+0x1c0>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks) at LAST\n",
80000b44:	80005637          	lui	a2,0x80005
80000b48:	800055b7          	lui	a1,0x80005
80000b4c:	80005537          	lui	a0,0x80005
80000b50:	3b858593          	addi	a1,a1,952 # 800053b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053b9>
80000b54:	3c050513          	addi	a0,a0,960 # 800053c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053c1>
80000b58:	09900693          	li	a3,153
80000b5c:	21c60613          	addi	a2,a2,540 # 8000521c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000521d>
80000b60:	3d5000ef          	jal	ra,80001734 <printk>
80000b64:	80005537          	lui	a0,0x80005
80000b68:	00040593          	mv	a1,s0
80000b6c:	49850513          	addi	a0,a0,1176 # 80005498 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005499>
80000b70:	f01ff06f          	j	80000a70 <test_thread+0xbc>
}
80000b74:	00c12083          	lw	ra,12(sp)
80000b78:	00812403          	lw	s0,8(sp)
	test_failure = false;
80000b7c:	800067b7          	lui	a5,0x80006
80000b80:	ee078423          	sb	zero,-280(a5) # 80005ee8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee9>
}
80000b84:	00412483          	lw	s1,4(sp)
80000b88:	00012903          	lw	s2,0(sp)
80000b8c:	01010113          	addi	sp,sp,16
80000b90:	00008067          	ret

80000b94 <test_main>:
/*test case main entry*/
void test_main(void)
{
	ztest_test_suite(sleep,
			 ztest_unit_test(test_sleep));
	ztest_run_test_suite(sleep);
80000b94:	800065b7          	lui	a1,0x80006
80000b98:	80005537          	lui	a0,0x80005
80000b9c:	eac58593          	addi	a1,a1,-340 # 80005eac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ead>
80000ba0:	24050513          	addi	a0,a0,576 # 80005240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005241>
80000ba4:	2880106f          	j	80001e2c <z_ztest_run_test_suite>

80000ba8 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000ba8:	ff010113          	addi	sp,sp,-16
80000bac:	00112623          	sw	ra,12(sp)
80000bb0:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000bb4:	00600793          	li	a5,6
80000bb8:	02f50463          	beq	a0,a5,80000be0 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000bbc:	4c0030ef          	jal	ra,8000407c <k_is_in_isr>
80000bc0:	02050463          	beqz	a0,80000be8 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000bc4:	4b8030ef          	jal	ra,8000407c <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000bc8:	04051663          	bnez	a0,80000c14 <z_SysFatalErrorHandler+0x6c>
80000bcc:	800055b7          	lui	a1,0x80005
80000bd0:	7c458593          	addi	a1,a1,1988 # 800057c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c5>
80000bd4:	80005537          	lui	a0,0x80005
80000bd8:	7d850513          	addi	a0,a0,2008 # 800057d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057d9>
80000bdc:	359000ef          	jal	ra,80001734 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000be0:	3c5000ef          	jal	ra,800017a4 <k_cpu_idle>
80000be4:	ffdff06f          	j	80000be0 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000be8:	4a4030ef          	jal	ra,8000408c <z_is_thread_essential>
80000bec:	fc051ce3          	bnez	a0,80000bc4 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000bf0:	80006437          	lui	s0,0x80006
80000bf4:	1f440413          	addi	s0,s0,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80000bf8:	00842583          	lw	a1,8(s0)
80000bfc:	80005537          	lui	a0,0x80005
80000c00:	7f850513          	addi	a0,a0,2040 # 800057f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057f9>
80000c04:	331000ef          	jal	ra,80001734 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000c08:	00842503          	lw	a0,8(s0)
80000c0c:	0c9030ef          	jal	ra,800044d4 <z_impl_k_thread_abort>
80000c10:	fd1ff06f          	j	80000be0 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000c14:	800055b7          	lui	a1,0x80005
80000c18:	7c058593          	addi	a1,a1,1984 # 800057c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057c1>
80000c1c:	fb9ff06f          	j	80000bd4 <z_SysFatalErrorHandler+0x2c>

80000c20 <z_NanoFatalErrorHandler>:
{
80000c20:	fb010113          	addi	sp,sp,-80
80000c24:	04812423          	sw	s0,72(sp)
80000c28:	04912223          	sw	s1,68(sp)
80000c2c:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000c30:	00600793          	li	a5,6
{
80000c34:	00050493          	mv	s1,a0
80000c38:	00058413          	mv	s0,a1
	switch (reason) {
80000c3c:	0ea7e063          	bltu	a5,a0,80000d1c <z_NanoFatalErrorHandler+0xfc>
80000c40:	80005737          	lui	a4,0x80005
80000c44:	00251793          	slli	a5,a0,0x2
80000c48:	51470713          	addi	a4,a4,1300 # 80005514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005515>
80000c4c:	00e787b3          	add	a5,a5,a4
80000c50:	0007a783          	lw	a5,0(a5)
80000c54:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000c58:	80005537          	lui	a0,0x80005
80000c5c:	64450513          	addi	a0,a0,1604 # 80005644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005645>
		printk("***** Kernel OOPS! *****\n");
80000c60:	2d5000ef          	jal	ra,80001734 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000c64:	078030ef          	jal	ra,80003cdc <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000c68:	04442783          	lw	a5,68(s0)
80000c6c:	01042883          	lw	a7,16(s0)
80000c70:	00c42803          	lw	a6,12(s0)
80000c74:	02f12823          	sw	a5,48(sp)
80000c78:	04042783          	lw	a5,64(s0)
80000c7c:	00442703          	lw	a4,4(s0)
80000c80:	00042683          	lw	a3,0(s0)
80000c84:	02f12623          	sw	a5,44(sp)
80000c88:	03c42783          	lw	a5,60(s0)
80000c8c:	04842603          	lw	a2,72(s0)
80000c90:	00050593          	mv	a1,a0
80000c94:	02f12423          	sw	a5,40(sp)
80000c98:	03842783          	lw	a5,56(s0)
80000c9c:	80005537          	lui	a0,0x80005
80000ca0:	6c850513          	addi	a0,a0,1736 # 800056c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056c9>
80000ca4:	02f12223          	sw	a5,36(sp)
80000ca8:	03442783          	lw	a5,52(s0)
80000cac:	02f12023          	sw	a5,32(sp)
80000cb0:	03042783          	lw	a5,48(s0)
80000cb4:	00f12e23          	sw	a5,28(sp)
80000cb8:	02c42783          	lw	a5,44(s0)
80000cbc:	00f12c23          	sw	a5,24(sp)
80000cc0:	02842783          	lw	a5,40(s0)
80000cc4:	00f12a23          	sw	a5,20(sp)
80000cc8:	02442783          	lw	a5,36(s0)
80000ccc:	00f12823          	sw	a5,16(sp)
80000cd0:	02042783          	lw	a5,32(s0)
80000cd4:	00f12623          	sw	a5,12(sp)
80000cd8:	01c42783          	lw	a5,28(s0)
80000cdc:	00f12423          	sw	a5,8(sp)
80000ce0:	01842783          	lw	a5,24(s0)
80000ce4:	00f12223          	sw	a5,4(sp)
80000ce8:	01442783          	lw	a5,20(s0)
80000cec:	00f12023          	sw	a5,0(sp)
80000cf0:	00842783          	lw	a5,8(s0)
80000cf4:	241000ef          	jal	ra,80001734 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000cf8:	00040593          	mv	a1,s0
80000cfc:	00048513          	mv	a0,s1
80000d00:	ea9ff0ef          	jal	ra,80000ba8 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000d04:	80005537          	lui	a0,0x80005
80000d08:	66c50513          	addi	a0,a0,1644 # 8000566c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000566d>
80000d0c:	f55ff06f          	j	80000c60 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80000d10:	80005537          	lui	a0,0x80005
80000d14:	68850513          	addi	a0,a0,1672 # 80005688 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005689>
80000d18:	f49ff06f          	j	80000c60 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000d1c:	80005537          	lui	a0,0x80005
80000d20:	00048593          	mv	a1,s1
80000d24:	6a450513          	addi	a0,a0,1700 # 800056a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056a5>
80000d28:	20d000ef          	jal	ra,80001734 <printk>
		break;
80000d2c:	f39ff06f          	j	80000c64 <z_NanoFatalErrorHandler+0x44>

80000d30 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000d30:	ff010113          	addi	sp,sp,-16
80000d34:	00812423          	sw	s0,8(sp)
80000d38:	00112623          	sw	ra,12(sp)
80000d3c:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000d40:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000d44:	00161613          	slli	a2,a2,0x1
80000d48:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80000d4c:	00500793          	li	a5,5
80000d50:	02c7e863          	bltu	a5,a2,80000d80 <_Fault+0x50>
80000d54:	80005737          	lui	a4,0x80005
80000d58:	00261793          	slli	a5,a2,0x2
80000d5c:	53070713          	addi	a4,a4,1328 # 80005530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005531>
80000d60:	00f707b3          	add	a5,a4,a5
80000d64:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000d68:	80005537          	lui	a0,0x80005
80000d6c:	55050513          	addi	a0,a0,1360 # 80005550 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005551>
80000d70:	1c5000ef          	jal	ra,80001734 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000d74:	00040593          	mv	a1,s0
80000d78:	00000513          	li	a0,0
80000d7c:	ea5ff0ef          	jal	ra,80000c20 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000d80:	800055b7          	lui	a1,0x80005
80000d84:	54858593          	addi	a1,a1,1352 # 80005548 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005549>
80000d88:	fe1ff06f          	j	80000d68 <_Fault+0x38>

80000d8c <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000d8c:	ff010113          	addi	sp,sp,-16
80000d90:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000d94:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000d98:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80000d9c:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000da0:	0015d593          	srli	a1,a1,0x1
80000da4:	82050513          	addi	a0,a0,-2016 # 80005820 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005821>
80000da8:	18d000ef          	jal	ra,80001734 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000dac:	800055b7          	lui	a1,0x80005
80000db0:	56c58593          	addi	a1,a1,1388 # 8000556c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000556d>
80000db4:	00400513          	li	a0,4
80000db8:	e69ff0ef          	jal	ra,80000c20 <z_NanoFatalErrorHandler>

80000dbc <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000dbc:	800067b7          	lui	a5,0x80006
80000dc0:	f4c78793          	addi	a5,a5,-180 # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
80000dc4:	0007a703          	lw	a4,0(a5)
80000dc8:	00070c63          	beqz	a4,80000de0 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80000dcc:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000dd0:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000dd4:	800067b7          	lui	a5,0x80006
80000dd8:	f507a503          	lw	a0,-176(a5) # 80005f50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f51>
80000ddc:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80000de0:	00008067          	ret

80000de4 <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80000de4:	00800793          	li	a5,8
80000de8:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
80000dec:	80006737          	lui	a4,0x80006
80000df0:	f4a72623          	sw	a0,-180(a4) # 80005f4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f4d>
	offload_param = parameter;
80000df4:	80006737          	lui	a4,0x80006
80000df8:	f4b72823          	sw	a1,-176(a4) # 80005f50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f51>

	__asm__ volatile ("ecall");
80000dfc:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80000e00:	0087f793          	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80000e04:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
80000e08:	00008067          	ret

80000e0c <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000e0c:	ff010113          	addi	sp,sp,-16
80000e10:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80000e14:	3cc010ef          	jal	ra,800021e0 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000e18:	1ad000ef          	jal	ra,800017c4 <soc_interrupt_init>
#endif
	z_cstart();
80000e1c:	430010ef          	jal	ra,8000224c <z_cstart>

80000e20 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000e20:	00006117          	auipc	sp,0x6
80000e24:	f0010113          	addi	sp,sp,-256 # 80006d20 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80000e28:	000012b7          	lui	t0,0x1
80000e2c:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000e30:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000e34:	fd9ff0ef          	jal	ra,80000e0c <_PrepC>

80000e38 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000e38:	2a80006f          	j	800010e0 <z_thread_entry>

80000e3c <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000e3c:	fd010113          	addi	sp,sp,-48
80000e40:	02812423          	sw	s0,40(sp)
80000e44:	02912223          	sw	s1,36(sp)
80000e48:	03212023          	sw	s2,32(sp)
80000e4c:	01312e23          	sw	s3,28(sp)
80000e50:	01412c23          	sw	s4,24(sp)
80000e54:	01512a23          	sw	s5,20(sp)
80000e58:	01612823          	sw	s6,16(sp)
80000e5c:	01712623          	sw	s7,12(sp)
80000e60:	00078b13          	mv	s6,a5
80000e64:	02112623          	sw	ra,44(sp)
80000e68:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000e6c:	00f00793          	li	a5,15
{
80000e70:	00050493          	mv	s1,a0
80000e74:	00058413          	mv	s0,a1
80000e78:	00060993          	mv	s3,a2
80000e7c:	00068a13          	mv	s4,a3
80000e80:	00070b93          	mv	s7,a4
80000e84:	00080a93          	mv	s5,a6
80000e88:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000e8c:	08f89a63          	bne	a7,a5,80000f20 <z_new_thread+0xe4>
80000e90:	800027b7          	lui	a5,0x80002
80000e94:	1a878793          	addi	a5,a5,424 # 800021a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800021a9>
80000e98:	08f69a63          	bne	a3,a5,80000f2c <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000e9c:	03012683          	lw	a3,48(sp)
80000ea0:	00090593          	mv	a1,s2
80000ea4:	00048513          	mv	a0,s1
80000ea8:	00400613          	li	a2,4
80000eac:	2a4030ef          	jal	ra,80004150 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000eb0:	fb098593          	addi	a1,s3,-80
80000eb4:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000eb8:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000ebc:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000ec0:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000ec4:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000ec8:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000ecc:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000ed0:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000ed4:	02c12083          	lw	ra,44(sp)
80000ed8:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000edc:	e3878793          	addi	a5,a5,-456 # 80000e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000e39>
	stack_init->a0 = (u32_t)thread_func;
80000ee0:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000ee4:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000ee8:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000eec:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000ef0:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000ef4:	02b4a423          	sw	a1,40(s1)
}
80000ef8:	02012903          	lw	s2,32(sp)
80000efc:	02412483          	lw	s1,36(sp)
80000f00:	01c12983          	lw	s3,28(sp)
80000f04:	01812a03          	lw	s4,24(sp)
80000f08:	01412a83          	lw	s5,20(sp)
80000f0c:	01012b03          	lw	s6,16(sp)
80000f10:	00c12b83          	lw	s7,12(sp)
80000f14:	00812c03          	lw	s8,8(sp)
80000f18:	03010113          	addi	sp,sp,48
80000f1c:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000f20:	01088693          	addi	a3,a7,16
80000f24:	01e00793          	li	a5,30
80000f28:	f6d7fae3          	bgeu	a5,a3,80000e9c <z_new_thread+0x60>
80000f2c:	80006c37          	lui	s8,0x80006
80000f30:	800065b7          	lui	a1,0x80006
80000f34:	80006537          	lui	a0,0x80006
80000f38:	848c0613          	addi	a2,s8,-1976 # 80005848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005849>
80000f3c:	01800693          	li	a3,24
80000f40:	86858593          	addi	a1,a1,-1944 # 80005868 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005869>
80000f44:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80000f48:	7ec000ef          	jal	ra,80001734 <printk>
80000f4c:	80006537          	lui	a0,0x80006
80000f50:	00090593          	mv	a1,s2
80000f54:	ff000693          	li	a3,-16
80000f58:	00e00613          	li	a2,14
80000f5c:	91450513          	addi	a0,a0,-1772 # 80005914 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005915>
80000f60:	7d4000ef          	jal	ra,80001734 <printk>
80000f64:	01800593          	li	a1,24
80000f68:	848c0513          	addi	a0,s8,-1976
80000f6c:	005000ef          	jal	ra,80001770 <assert_post_action>
80000f70:	f2dff06f          	j	80000e9c <z_new_thread+0x60>

80000f74 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80000f74:	00c00793          	li	a5,12
80000f78:	02f58733          	mul	a4,a1,a5
80000f7c:	00c52783          	lw	a5,12(a0)
80000f80:	00e787b3          	add	a5,a5,a4
80000f84:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80000f88:	00b75463          	bge	a4,a1,80000f90 <get_bit_ptr+0x1c>
80000f8c:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80000f90:	02000713          	li	a4,32
80000f94:	02e64733          	div	a4,a2,a4

	return bn & 0x1f;
}
80000f98:	01f67513          	andi	a0,a2,31
	*word = &bitarray[bn / 32];
80000f9c:	00271713          	slli	a4,a4,0x2
80000fa0:	00e787b3          	add	a5,a5,a4
80000fa4:	00f6a023          	sw	a5,0(a3)
}
80000fa8:	00008067          	ret

80000fac <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000fac:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000fb0:	00c10693          	addi	a3,sp,12
{
80000fb4:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000fb8:	fbdff0ef          	jal	ra,80000f74 <get_bit_ptr>

	*word |= (1<<bit);
80000fbc:	00c12703          	lw	a4,12(sp)
80000fc0:	00100793          	li	a5,1
80000fc4:	00a79533          	sll	a0,a5,a0
80000fc8:	00072783          	lw	a5,0(a4)
}
80000fcc:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80000fd0:	00a7e7b3          	or	a5,a5,a0
80000fd4:	00f72023          	sw	a5,0(a4)
}
80000fd8:	02010113          	addi	sp,sp,32
80000fdc:	00008067          	ret

80000fe0 <z_sys_mem_pool_base_init>:
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000fe0:	00452783          	lw	a5,4(a0)
80000fe4:	00855803          	lhu	a6,8(a0)
{
80000fe8:	ff010113          	addi	sp,sp,-16
80000fec:	00812423          	sw	s0,8(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000ff0:	02f80833          	mul	a6,a6,a5
{
80000ff4:	00050413          	mv	s0,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000ff8:	00052503          	lw	a0,0(a0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80000ffc:	00a44883          	lbu	a7,10(s0)
	p->max_inline_level = -1;
80001000:	fff00713          	li	a4,-1
{
80001004:	00112623          	sw	ra,12(sp)
80001008:	00912223          	sw	s1,4(sp)
	p->max_inline_level = -1;
8000100c:	00e405a3          	sb	a4,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001010:	00000593          	li	a1,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);
80001014:	00c00313          	li	t1,12
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001018:	01050533          	add	a0,a0,a6

		if (nblocks < 32) {
8000101c:	01f00e13          	li	t3,31
			p->max_inline_level = i;
		} else {
			p->levels[i].bits_p = bits;
			bits += (nblocks + 31)/32;
80001020:	02000e93          	li	t4,32
	for (i = 0; i < p->n_levels; i++) {
80001024:	0315c263          	blt	a1,a7,80001048 <z_sys_mem_pool_base_init+0x68>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001028:	00000493          	li	s1,0
8000102c:	00845783          	lhu	a5,8(s0)
80001030:	06f4c463          	blt	s1,a5,80001098 <z_sys_mem_pool_base_init+0xb8>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001034:	00c12083          	lw	ra,12(sp)
80001038:	00812403          	lw	s0,8(sp)
8000103c:	00412483          	lw	s1,4(sp)
80001040:	01010113          	addi	sp,sp,16
80001044:	00008067          	ret
		int nblocks = buflen / sz;
80001048:	02f85733          	divu	a4,a6,a5
		sys_dlist_init(&p->levels[i].free_list);
8000104c:	00c42603          	lw	a2,12(s0)
80001050:	026586b3          	mul	a3,a1,t1
80001054:	00d606b3          	add	a3,a2,a3
80001058:	00468613          	addi	a2,a3,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
8000105c:	00c6a223          	sw	a2,4(a3)
	list->tail = (sys_dnode_t *)list;
80001060:	00c6a423          	sw	a2,8(a3)
		if (nblocks < 32) {
80001064:	00ee4e63          	blt	t3,a4,80001080 <z_sys_mem_pool_base_init+0xa0>
			p->max_inline_level = i;
80001068:	00b405a3          	sb	a1,11(s0)
		sz = _ALIGN4(sz / 4);
8000106c:	0027d793          	srli	a5,a5,0x2
80001070:	00378793          	addi	a5,a5,3
80001074:	ffc7f793          	andi	a5,a5,-4
	for (i = 0; i < p->n_levels; i++) {
80001078:	00158593          	addi	a1,a1,1
8000107c:	fa9ff06f          	j	80001024 <z_sys_mem_pool_base_init+0x44>
			bits += (nblocks + 31)/32;
80001080:	01f70713          	addi	a4,a4,31
80001084:	03d74733          	div	a4,a4,t4
			p->levels[i].bits_p = bits;
80001088:	00a6a023          	sw	a0,0(a3)
			bits += (nblocks + 31)/32;
8000108c:	00271713          	slli	a4,a4,0x2
80001090:	00e50533          	add	a0,a0,a4
80001094:	fd9ff06f          	j	8000106c <z_sys_mem_pool_base_init+0x8c>
	return (u8_t *)p->buf + lsz * block;
80001098:	00442783          	lw	a5,4(s0)
		set_free_bit(p, 0, i);
8000109c:	00048613          	mv	a2,s1
800010a0:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
800010a4:	02f48733          	mul	a4,s1,a5
800010a8:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
800010ac:	00040513          	mv	a0,s0
	for (i = 0; i < p->n_max; i++) {
800010b0:	00148493          	addi	s1,s1,1
	return (u8_t *)p->buf + lsz * block;
800010b4:	00e787b3          	add	a5,a5,a4
		sys_dlist_append(&p->levels[0].free_list, block);
800010b8:	00c42703          	lw	a4,12(s0)
800010bc:	00470693          	addi	a3,a4,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
800010c0:	00d7a023          	sw	a3,0(a5)
	node->prev = list->tail;
800010c4:	00872683          	lw	a3,8(a4)
800010c8:	00d7a223          	sw	a3,4(a5)

	list->tail->next = node;
800010cc:	00872683          	lw	a3,8(a4)
800010d0:	00f6a023          	sw	a5,0(a3)
	list->tail = node;
800010d4:	00f72423          	sw	a5,8(a4)
		set_free_bit(p, 0, i);
800010d8:	ed5ff0ef          	jal	ra,80000fac <set_free_bit>
800010dc:	f51ff06f          	j	8000102c <z_sys_mem_pool_base_init+0x4c>

800010e0 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
800010e0:	ff010113          	addi	sp,sp,-16
800010e4:	00050793          	mv	a5,a0
800010e8:	00058513          	mv	a0,a1
800010ec:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
800010f0:	00068613          	mv	a2,a3
{
800010f4:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
800010f8:	000780e7          	jalr	a5
800010fc:	3e1020ef          	jal	ra,80003cdc <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001100:	3d4030ef          	jal	ra,800044d4 <z_impl_k_thread_abort>

80001104 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001104:	00000513          	li	a0,0
80001108:	00008067          	ret

8000110c <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
8000110c:	ff010113          	addi	sp,sp,-16
80001110:	00812423          	sw	s0,8(sp)
80001114:	00050413          	mv	s0,a0
	out('E', ctx);
80001118:	04500513          	li	a0,69
{
8000111c:	00112623          	sw	ra,12(sp)
80001120:	00912223          	sw	s1,4(sp)
80001124:	00058493          	mv	s1,a1
	out('E', ctx);
80001128:	000400e7          	jalr	s0
	out('R', ctx);
8000112c:	00048593          	mv	a1,s1
80001130:	05200513          	li	a0,82
80001134:	000400e7          	jalr	s0
	out('R', ctx);
80001138:	00040313          	mv	t1,s0
}
8000113c:	00812403          	lw	s0,8(sp)
80001140:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001144:	00048593          	mv	a1,s1
}
80001148:	00412483          	lw	s1,4(sp)
	out('R', ctx);
8000114c:	05200513          	li	a0,82
}
80001150:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001154:	00030067          	jr	t1

80001158 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001158:	0005a783          	lw	a5,0(a1)
8000115c:	00178793          	addi	a5,a5,1
80001160:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001164:	800067b7          	lui	a5,0x80006
80001168:	ed47a303          	lw	t1,-300(a5) # 80005ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ed5>
8000116c:	00030067          	jr	t1

80001170 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001170:	fb010113          	addi	sp,sp,-80
80001174:	04812423          	sw	s0,72(sp)
80001178:	03312e23          	sw	s3,60(sp)
8000117c:	03412c23          	sw	s4,56(sp)
80001180:	03512a23          	sw	s5,52(sp)
80001184:	03612823          	sw	s6,48(sp)
80001188:	04112623          	sw	ra,76(sp)
8000118c:	04912223          	sw	s1,68(sp)
80001190:	05212023          	sw	s2,64(sp)
80001194:	03712623          	sw	s7,44(sp)
80001198:	03812423          	sw	s8,40(sp)
8000119c:	03912223          	sw	s9,36(sp)
800011a0:	03a12023          	sw	s10,32(sp)
800011a4:	01b12e23          	sw	s11,28(sp)
800011a8:	00050a13          	mv	s4,a0
800011ac:	00058a93          	mv	s5,a1
800011b0:	00060993          	mv	s3,a2
800011b4:	00068b13          	mv	s6,a3
800011b8:	00100413          	li	s0,1
800011bc:	00e05463          	blez	a4,800011c4 <_printk_dec_ulong+0x54>
800011c0:	00070413          	mv	s0,a4
800011c4:	00100793          	li	a5,1
800011c8:	02000c13          	li	s8,32
800011cc:	00fb1463          	bne	s6,a5,800011d4 <_printk_dec_ulong+0x64>
800011d0:	03000c13          	li	s8,48
800011d4:	3b9ad4b7          	lui	s1,0x3b9ad
800011d8:	00100913          	li	s2,1
800011dc:	00a00c93          	li	s9,10
800011e0:	00000713          	li	a4,0
800011e4:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
800011e8:	00200d93          	li	s11,2
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
		pos /= 10;
800011ec:	00a00d13          	li	s10,10
		if (found_largest_digit != 0 || remainder > pos) {
800011f0:	00148b93          	addi	s7,s1,1
800011f4:	00071463          	bnez	a4,800011fc <_printk_dec_ulong+0x8c>
800011f8:	0934f263          	bgeu	s1,s3,8000127c <_printk_dec_ulong+0x10c>
			out((int)((remainder / (pos + 1)) + 48), ctx);
800011fc:	0379d533          	divu	a0,s3,s7
80001200:	000a8593          	mv	a1,s5
			digits++;
80001204:	00190913          	addi	s2,s2,1
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001208:	03050513          	addi	a0,a0,48
8000120c:	000a00e7          	jalr	s4
			found_largest_digit = 1;
80001210:	00100713          	li	a4,1
		remaining--;
80001214:	fffc8c93          	addi	s9,s9,-1
	while (pos >= 9) {
80001218:	00100793          	li	a5,1
		remainder %= (pos + 1);
8000121c:	0379f9b3          	remu	s3,s3,s7
		pos /= 10;
80001220:	03a4d4b3          	divu	s1,s1,s10
	while (pos >= 9) {
80001224:	fcfc96e3          	bne	s9,a5,800011f0 <_printk_dec_ulong+0x80>
	}
	out((int)(remainder + 48), ctx);
80001228:	000a8593          	mv	a1,s5
8000122c:	03098513          	addi	a0,s3,48
80001230:	000a00e7          	jalr	s4

	if (padding == PAD_SPACE_AFTER) {
80001234:	00300793          	li	a5,3
		remaining = min_width - digits;
80001238:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
8000123c:	06fb0a63          	beq	s6,a5,800012b0 <_printk_dec_ulong+0x140>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001240:	04c12083          	lw	ra,76(sp)
80001244:	04812403          	lw	s0,72(sp)
80001248:	04412483          	lw	s1,68(sp)
8000124c:	04012903          	lw	s2,64(sp)
80001250:	03c12983          	lw	s3,60(sp)
80001254:	03812a03          	lw	s4,56(sp)
80001258:	03412a83          	lw	s5,52(sp)
8000125c:	03012b03          	lw	s6,48(sp)
80001260:	02c12b83          	lw	s7,44(sp)
80001264:	02812c03          	lw	s8,40(sp)
80001268:	02412c83          	lw	s9,36(sp)
8000126c:	02012d03          	lw	s10,32(sp)
80001270:	01c12d83          	lw	s11,28(sp)
80001274:	05010113          	addi	sp,sp,80
80001278:	00008067          	ret
		} else if (remaining <= min_width
8000127c:	f9944ce3          	blt	s0,s9,80001214 <_printk_dec_ulong+0xa4>
				&& padding < PAD_SPACE_AFTER) {
80001280:	f96deae3          	bltu	s11,s6,80001214 <_printk_dec_ulong+0xa4>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001284:	000a8593          	mv	a1,s5
80001288:	000c0513          	mv	a0,s8
8000128c:	00e12623          	sw	a4,12(sp)
80001290:	000a00e7          	jalr	s4
			digits++;
80001294:	00190913          	addi	s2,s2,1
80001298:	00c12703          	lw	a4,12(sp)
8000129c:	f79ff06f          	j	80001214 <_printk_dec_ulong+0xa4>
			out(' ', ctx);
800012a0:	000a8593          	mv	a1,s5
800012a4:	02000513          	li	a0,32
800012a8:	000a00e7          	jalr	s4
800012ac:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
800012b0:	fe8048e3          	bgtz	s0,800012a0 <_printk_dec_ulong+0x130>
800012b4:	f8dff06f          	j	80001240 <_printk_dec_ulong+0xd0>

800012b8 <__printk_hook_install>:
	_char_out = fn;
800012b8:	800067b7          	lui	a5,0x80006
800012bc:	eca7aa23          	sw	a0,-300(a5) # 80005ed4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ed5>
}
800012c0:	00008067          	ret

800012c4 <z_vprintk>:
{
800012c4:	fb010113          	addi	sp,sp,-80
800012c8:	04812423          	sw	s0,72(sp)
800012cc:	04912223          	sw	s1,68(sp)
800012d0:	05212023          	sw	s2,64(sp)
800012d4:	03312e23          	sw	s3,60(sp)
800012d8:	03412c23          	sw	s4,56(sp)
800012dc:	03512a23          	sw	s5,52(sp)
800012e0:	03912223          	sw	s9,36(sp)
800012e4:	03a12023          	sw	s10,32(sp)
800012e8:	01b12e23          	sw	s11,28(sp)
800012ec:	04112623          	sw	ra,76(sp)
800012f0:	03612823          	sw	s6,48(sp)
800012f4:	03712623          	sw	s7,44(sp)
800012f8:	03812423          	sw	s8,40(sp)
800012fc:	00050413          	mv	s0,a0
80001300:	00058493          	mv	s1,a1
80001304:	00060a93          	mv	s5,a2
80001308:	00068d13          	mv	s10,a3
	int long_ctr = 0;
8000130c:	00000a13          	li	s4,0
	int min_width = -1;
80001310:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001314:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001318:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
8000131c:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001320:	000ac503          	lbu	a0,0(s5)
80001324:	04051063          	bnez	a0,80001364 <z_vprintk+0xa0>
}
80001328:	04c12083          	lw	ra,76(sp)
8000132c:	04812403          	lw	s0,72(sp)
80001330:	04412483          	lw	s1,68(sp)
80001334:	04012903          	lw	s2,64(sp)
80001338:	03c12983          	lw	s3,60(sp)
8000133c:	03812a03          	lw	s4,56(sp)
80001340:	03412a83          	lw	s5,52(sp)
80001344:	03012b03          	lw	s6,48(sp)
80001348:	02c12b83          	lw	s7,44(sp)
8000134c:	02812c03          	lw	s8,40(sp)
80001350:	02412c83          	lw	s9,36(sp)
80001354:	02012d03          	lw	s10,32(sp)
80001358:	01c12d83          	lw	s11,28(sp)
8000135c:	05010113          	addi	sp,sp,80
80001360:	00008067          	ret
		if (!might_format) {
80001364:	000c9e63          	bnez	s9,80001380 <z_vprintk+0xbc>
			if (*fmt != '%') {
80001368:	02500693          	li	a3,37
8000136c:	36d50a63          	beq	a0,a3,800016e0 <z_vprintk+0x41c>
				out((int)*fmt, ctx);
80001370:	00048593          	mv	a1,s1
80001374:	000400e7          	jalr	s0
		++fmt;
80001378:	001a8a93          	addi	s5,s5,1
8000137c:	fa5ff06f          	j	80001320 <z_vprintk+0x5c>
			switch (*fmt) {
80001380:	06400693          	li	a3,100
80001384:	10d50e63          	beq	a0,a3,800014a0 <z_vprintk+0x1dc>
80001388:	06a6e263          	bltu	a3,a0,800013ec <z_vprintk+0x128>
8000138c:	03900693          	li	a3,57
80001390:	02a6ea63          	bltu	a3,a0,800013c4 <z_vprintk+0x100>
80001394:	03100693          	li	a3,49
80001398:	0ed57463          	bgeu	a0,a3,80001480 <z_vprintk+0x1bc>
8000139c:	02d00693          	li	a3,45
800013a0:	34d50a63          	beq	a0,a3,800016f4 <z_vprintk+0x430>
800013a4:	03000793          	li	a5,48
800013a8:	0cf50063          	beq	a0,a5,80001468 <z_vprintk+0x1a4>
800013ac:	02500713          	li	a4,37
800013b0:	02e51263          	bne	a0,a4,800013d4 <z_vprintk+0x110>
				out((int)'%', ctx);
800013b4:	00048593          	mv	a1,s1
800013b8:	02500513          	li	a0,37
				out((int)*fmt, ctx);
800013bc:	000400e7          	jalr	s0
				break;
800013c0:	15c0006f          	j	8000151c <z_vprintk+0x258>
800013c4:	05800693          	li	a3,88
800013c8:	1ad50e63          	beq	a0,a3,80001584 <z_vprintk+0x2c0>
800013cc:	06300713          	li	a4,99
800013d0:	2ee50e63          	beq	a0,a4,800016cc <z_vprintk+0x408>
				out((int)'%', ctx);
800013d4:	00048593          	mv	a1,s1
800013d8:	02500513          	li	a0,37
800013dc:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
800013e0:	00048593          	mv	a1,s1
800013e4:	000ac503          	lbu	a0,0(s5)
800013e8:	fd5ff06f          	j	800013bc <z_vprintk+0xf8>
800013ec:	07000693          	li	a3,112
800013f0:	16d50a63          	beq	a0,a3,80001564 <z_vprintk+0x2a0>
800013f4:	02a6e063          	bltu	a3,a0,80001414 <z_vprintk+0x150>
800013f8:	06900693          	li	a3,105
800013fc:	0ad50263          	beq	a0,a3,800014a0 <z_vprintk+0x1dc>
80001400:	06c00693          	li	a3,108
80001404:	08d50a63          	beq	a0,a3,80001498 <z_vprintk+0x1d4>
80001408:	06800693          	li	a3,104
8000140c:	f6d506e3          	beq	a0,a3,80001378 <z_vprintk+0xb4>
80001410:	fc5ff06f          	j	800013d4 <z_vprintk+0x110>
80001414:	07500693          	li	a3,117
80001418:	10d50663          	beq	a0,a3,80001524 <z_vprintk+0x260>
8000141c:	02a6ee63          	bltu	a3,a0,80001458 <z_vprintk+0x194>
80001420:	07300713          	li	a4,115
80001424:	fae518e3          	bne	a0,a4,800013d4 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80001428:	000d2c03          	lw	s8,0(s10)
8000142c:	004d0b13          	addi	s6,s10,4
80001430:	000c0b93          	mv	s7,s8
				while (*s)
80001434:	000bc503          	lbu	a0,0(s7)
80001438:	26051863          	bnez	a0,800016a8 <z_vprintk+0x3e4>
				if (padding == PAD_SPACE_AFTER) {
8000143c:	00300793          	li	a5,3
80001440:	00f99863          	bne	s3,a5,80001450 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80001444:	418b8bb3          	sub	s7,s7,s8
80001448:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
8000144c:	27704663          	bgtz	s7,800016b8 <z_vprintk+0x3f4>
				char *s = va_arg(ap, char *);
80001450:	000b0d13          	mv	s10,s6
80001454:	0c80006f          	j	8000151c <z_vprintk+0x258>
80001458:	07800693          	li	a3,120
8000145c:	12d50463          	beq	a0,a3,80001584 <z_vprintk+0x2c0>
80001460:	07a00693          	li	a3,122
80001464:	fa9ff06f          	j	8000140c <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80001468:	00095e63          	bgez	s2,80001484 <z_vprintk+0x1c0>
8000146c:	28098863          	beqz	s3,800016fc <z_vprintk+0x438>
					min_width = *fmt - '0';
80001470:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001474:	f00992e3          	bnez	s3,80001378 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001478:	00200993          	li	s3,2
8000147c:	efdff06f          	j	80001378 <z_vprintk+0xb4>
				if (min_width < 0) {
80001480:	fe0948e3          	bltz	s2,80001470 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001484:	00a00693          	li	a3,10
80001488:	02d90933          	mul	s2,s2,a3
8000148c:	fd090913          	addi	s2,s2,-48
80001490:	01250933          	add	s2,a0,s2
80001494:	fe1ff06f          	j	80001474 <z_vprintk+0x1b0>
				long_ctr++;
80001498:	001a0a13          	addi	s4,s4,1
8000149c:	eddff06f          	j	80001378 <z_vprintk+0xb4>
				if (long_ctr == 0) {
800014a0:	040a1263          	bnez	s4,800014e4 <z_vprintk+0x220>
					long ld = va_arg(ap, long);
800014a4:	000d2603          	lw	a2,0(s10)
800014a8:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
800014ac:	02065063          	bgez	a2,800014cc <z_vprintk+0x208>
					out((int)'-', ctx);
800014b0:	00048593          	mv	a1,s1
800014b4:	02d00513          	li	a0,45
800014b8:	00c12023          	sw	a2,0(sp)
800014bc:	000400e7          	jalr	s0
					d = -d;
800014c0:	00012603          	lw	a2,0(sp)
					min_width--;
800014c4:	fff90913          	addi	s2,s2,-1
					d = -d;
800014c8:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
800014cc:	00090713          	mv	a4,s2
800014d0:	00098693          	mv	a3,s3
800014d4:	00048593          	mv	a1,s1
800014d8:	00040513          	mv	a0,s0
800014dc:	c95ff0ef          	jal	ra,80001170 <_printk_dec_ulong>
				break;
800014e0:	03c0006f          	j	8000151c <z_vprintk+0x258>
				} else if (long_ctr == 1) {
800014e4:	00100713          	li	a4,1
800014e8:	faea0ee3          	beq	s4,a4,800014a4 <z_vprintk+0x1e0>
					long long lld = va_arg(ap, long long);
800014ec:	007d0793          	addi	a5,s10,7
800014f0:	ff87f713          	andi	a4,a5,-8
800014f4:	00072603          	lw	a2,0(a4)
800014f8:	00472683          	lw	a3,4(a4)
800014fc:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001500:	01b60733          	add	a4,a2,s11
80001504:	00c73733          	sltu	a4,a4,a2
80001508:	00d70733          	add	a4,a4,a3
8000150c:	fa0700e3          	beqz	a4,800014ac <z_vprintk+0x1e8>
						print_err(out, ctx);
80001510:	00048593          	mv	a1,s1
80001514:	00040513          	mv	a0,s0
80001518:	bf5ff0ef          	jal	ra,8000110c <print_err>
			might_format = 0;
8000151c:	00000c93          	li	s9,0
80001520:	e59ff06f          	j	80001378 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001524:	000a1863          	bnez	s4,80001534 <z_vprintk+0x270>
					long lu = va_arg(ap, unsigned long);
80001528:	000d2603          	lw	a2,0(s10)
8000152c:	004d0d13          	addi	s10,s10,4
80001530:	f9dff06f          	j	800014cc <z_vprintk+0x208>
				} else if (long_ctr == 1) {
80001534:	00100713          	li	a4,1
80001538:	feea08e3          	beq	s4,a4,80001528 <z_vprintk+0x264>
					unsigned long long llu =
8000153c:	007d0793          	addi	a5,s10,7
80001540:	ff87f713          	andi	a4,a5,-8
80001544:	00870d13          	addi	s10,a4,8
80001548:	00072603          	lw	a2,0(a4)
8000154c:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001550:	fc0710e3          	bnez	a4,80001510 <z_vprintk+0x24c>
80001554:	800007b7          	lui	a5,0x80000
80001558:	fff7c793          	not	a5,a5
8000155c:	f6c7f8e3          	bgeu	a5,a2,800014cc <z_vprintk+0x208>
80001560:	fb1ff06f          	j	80001510 <z_vprintk+0x24c>
				  out('0', ctx);
80001564:	00048593          	mv	a1,s1
80001568:	03000513          	li	a0,48
8000156c:	000400e7          	jalr	s0
				  out('x', ctx);
80001570:	00048593          	mv	a1,s1
80001574:	07800513          	li	a0,120
80001578:	000400e7          	jalr	s0
				  min_width = 8;
8000157c:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001580:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001584:	00100693          	li	a3,1
80001588:	0b46c263          	blt	a3,s4,8000162c <z_vprintk+0x368>
					x = va_arg(ap, unsigned long);
8000158c:	000d2783          	lw	a5,0(s10)
80001590:	00012423          	sw	zero,8(sp)
80001594:	004d0d13          	addi	s10,s10,4
80001598:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
8000159c:	01000c13          	li	s8,16
	int digits = 0;
800015a0:	00000b93          	li	s7,0
	int found_largest_digit = 0;
800015a4:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
800015a8:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800015ac:	00412503          	lw	a0,4(sp)
800015b0:	00812583          	lw	a1,8(sp)
800015b4:	fff88b13          	addi	s6,a7,-1
800015b8:	002b1613          	slli	a2,s6,0x2
800015bc:	01112623          	sw	a7,12(sp)
800015c0:	cc9fe0ef          	jal	ra,80000288 <__lshrdi3>
800015c4:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800015c8:	08051863          	bnez	a0,80001658 <z_vprintk+0x394>
800015cc:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
800015d0:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800015d4:	00079863          	bnez	a5,800015e4 <z_vprintk+0x320>
800015d8:	00c12883          	lw	a7,12(sp)
800015dc:	00100793          	li	a5,1
800015e0:	08f89663          	bne	a7,a5,8000166c <z_vprintk+0x3a8>
			nibble += nibble > 9 ? 87 : 48;
800015e4:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
800015e8:	01851513          	slli	a0,a0,0x18
800015ec:	00048593          	mv	a1,s1
800015f0:	41855513          	srai	a0,a0,0x18
800015f4:	000400e7          	jalr	s0
			digits++;
800015f8:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
800015fc:	040b1863          	bnez	s6,8000164c <z_vprintk+0x388>
	if (padding == PAD_SPACE_AFTER) {
80001600:	00300693          	li	a3,3
			might_format = 0;
80001604:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001608:	d6d998e3          	bne	s3,a3,80001378 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
8000160c:	00191713          	slli	a4,s2,0x1
80001610:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001614:	f17054e3          	blez	s7,8000151c <z_vprintk+0x258>
			out(' ', ctx);
80001618:	00048593          	mv	a1,s1
8000161c:	02000513          	li	a0,32
80001620:	000400e7          	jalr	s0
80001624:	fffb8b93          	addi	s7,s7,-1
80001628:	fedff06f          	j	80001614 <z_vprintk+0x350>
					x = va_arg(ap, unsigned long long);
8000162c:	007d0793          	addi	a5,s10,7
80001630:	ff87f693          	andi	a3,a5,-8
80001634:	0006a783          	lw	a5,0(a3)
80001638:	00868d13          	addi	s10,a3,8
8000163c:	00f12223          	sw	a5,4(sp)
80001640:	0046a783          	lw	a5,4(a3)
80001644:	00f12423          	sw	a5,8(sp)
80001648:	f55ff06f          	j	8000159c <z_vprintk+0x2d8>
			found_largest_digit = 1;
8000164c:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001650:	000b0893          	mv	a7,s6
80001654:	f59ff06f          	j	800015ac <z_vprintk+0x2e8>
			nibble += nibble > 9 ? 87 : 48;
80001658:	00900793          	li	a5,9
8000165c:	05700693          	li	a3,87
80001660:	f8a7e2e3          	bltu	a5,a0,800015e4 <z_vprintk+0x320>
80001664:	03000693          	li	a3,48
80001668:	f7dff06f          	j	800015e4 <z_vprintk+0x320>
		if (remaining-- <= min_width) {
8000166c:	fffc0793          	addi	a5,s8,-1
80001670:	00f12623          	sw	a5,12(sp)
80001674:	01894c63          	blt	s2,s8,8000168c <z_vprintk+0x3c8>
			if (padding == PAD_ZERO_BEFORE) {
80001678:	00100793          	li	a5,1
8000167c:	00f99c63          	bne	s3,a5,80001694 <z_vprintk+0x3d0>
				out('0', ctx);
80001680:	00048593          	mv	a1,s1
80001684:	03000513          	li	a0,48
				out(' ', ctx);
80001688:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
8000168c:	00c12c03          	lw	s8,12(sp)
80001690:	fc1ff06f          	j	80001650 <z_vprintk+0x38c>
			} else if (padding == PAD_SPACE_BEFORE) {
80001694:	00200793          	li	a5,2
80001698:	fef99ae3          	bne	s3,a5,8000168c <z_vprintk+0x3c8>
				out(' ', ctx);
8000169c:	00048593          	mv	a1,s1
800016a0:	02000513          	li	a0,32
800016a4:	fe5ff06f          	j	80001688 <z_vprintk+0x3c4>
					out((int)(*s++), ctx);
800016a8:	00048593          	mv	a1,s1
800016ac:	001b8b93          	addi	s7,s7,1
800016b0:	000400e7          	jalr	s0
800016b4:	d81ff06f          	j	80001434 <z_vprintk+0x170>
						out(' ', ctx);
800016b8:	00048593          	mv	a1,s1
800016bc:	02000513          	li	a0,32
800016c0:	000400e7          	jalr	s0
800016c4:	fffb8b93          	addi	s7,s7,-1
800016c8:	d85ff06f          	j	8000144c <z_vprintk+0x188>
				out(c, ctx);
800016cc:	000d2503          	lw	a0,0(s10)
800016d0:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
800016d4:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
800016d8:	000400e7          	jalr	s0
				break;
800016dc:	d75ff06f          	j	80001450 <z_vprintk+0x18c>
				long_ctr = 0;
800016e0:	00000a13          	li	s4,0
				min_width = -1;
800016e4:	fff00913          	li	s2,-1
				padding = PAD_NONE;
800016e8:	00000993          	li	s3,0
				might_format = 1;
800016ec:	00100c93          	li	s9,1
800016f0:	c89ff06f          	j	80001378 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
800016f4:	00300993          	li	s3,3
800016f8:	c81ff06f          	j	80001378 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
800016fc:	00100993          	li	s3,1
80001700:	c79ff06f          	j	80001378 <z_vprintk+0xb4>

80001704 <vprintk>:
{
80001704:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001708:	00050613          	mv	a2,a0
8000170c:	80001537          	lui	a0,0x80001
80001710:	00058693          	mv	a3,a1
80001714:	15850513          	addi	a0,a0,344 # 80001158 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001159>
80001718:	00c10593          	addi	a1,sp,12
{
8000171c:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001720:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001724:	ba1ff0ef          	jal	ra,800012c4 <z_vprintk>
}
80001728:	01c12083          	lw	ra,28(sp)
8000172c:	02010113          	addi	sp,sp,32
80001730:	00008067          	ret

80001734 <printk>:
{
80001734:	fc010113          	addi	sp,sp,-64
80001738:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
8000173c:	02410593          	addi	a1,sp,36
{
80001740:	00112e23          	sw	ra,28(sp)
80001744:	02c12423          	sw	a2,40(sp)
80001748:	02d12623          	sw	a3,44(sp)
8000174c:	02e12823          	sw	a4,48(sp)
80001750:	02f12a23          	sw	a5,52(sp)
80001754:	03012c23          	sw	a6,56(sp)
80001758:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
8000175c:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80001760:	fa5ff0ef          	jal	ra,80001704 <vprintk>
}
80001764:	01c12083          	lw	ra,28(sp)
80001768:	04010113          	addi	sp,sp,64
8000176c:	00008067          	ret

80001770 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001770:	800065b7          	lui	a1,0x80006
80001774:	80006537          	lui	a0,0x80006
{
80001778:	ff010113          	addi	sp,sp,-16
  k_panic();
8000177c:	94858593          	addi	a1,a1,-1720 # 80005948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005949>
80001780:	95c50513          	addi	a0,a0,-1700 # 8000595c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000595d>
80001784:	01e00613          	li	a2,30
{
80001788:	00112623          	sw	ra,12(sp)
  k_panic();
8000178c:	fa9ff0ef          	jal	ra,80001734 <printk>
80001790:	800055b7          	lui	a1,0x80005
80001794:	56c58593          	addi	a1,a1,1388 # 8000556c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000556d>
80001798:	00600513          	li	a0,6
8000179c:	c84ff0ef          	jal	ra,80000c20 <z_NanoFatalErrorHandler>

800017a0 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800017a0:	00008067          	ret

800017a4 <k_cpu_idle>:
800017a4:	00800793          	li	a5,8
800017a8:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
800017ac:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
800017b0:	00008067          	ret

800017b4 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
800017b4:	00100793          	li	a5,1
800017b8:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
800017bc:	30452573          	csrrs	a0,mie,a0
}
800017c0:	00008067          	ret

800017c4 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800017c4:	00800793          	li	a5,8
800017c8:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
800017cc:	30405073          	csrwi	mie,0
800017d0:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
800017d4:	00008067          	ret

800017d8 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
800017d8:	ff010113          	addi	sp,sp,-16
800017dc:	00812423          	sw	s0,8(sp)
800017e0:	00912223          	sw	s1,4(sp)
800017e4:	80006437          	lui	s0,0x80006
800017e8:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
800017ec:	00a00793          	li	a5,10
{
800017f0:	00050493          	mv	s1,a0
800017f4:	f5440413          	addi	s0,s0,-172 # 80005f54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f55>
	if ('\n' == c) {
800017f8:	00f51c63          	bne	a0,a5,80001810 <console_out+0x38>
800017fc:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001800:	00d00593          	li	a1,13
80001804:	00452783          	lw	a5,4(a0)
80001808:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
8000180c:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001810:	00042503          	lw	a0,0(s0)
80001814:	0ff4f593          	andi	a1,s1,255
80001818:	00452783          	lw	a5,4(a0)
8000181c:	0047a783          	lw	a5,4(a5)
80001820:	000780e7          	jalr	a5

	return c;
}
80001824:	00c12083          	lw	ra,12(sp)
80001828:	00812403          	lw	s0,8(sp)
8000182c:	00048513          	mv	a0,s1
80001830:	00412483          	lw	s1,4(sp)
80001834:	01010113          	addi	sp,sp,16
80001838:	00008067          	ret

8000183c <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
8000183c:	ff010113          	addi	sp,sp,-16
80001840:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001844:	80001437          	lui	s0,0x80001
80001848:	7d840513          	addi	a0,s0,2008 # 800017d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800017d9>
{
8000184c:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001850:	514000ef          	jal	ra,80001d64 <__stdout_hook_install>
	__printk_hook_install(console_out);
80001854:	7d840513          	addi	a0,s0,2008
}
80001858:	00812403          	lw	s0,8(sp)
8000185c:	00c12083          	lw	ra,12(sp)
80001860:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80001864:	a55ff06f          	j	800012b8 <__printk_hook_install>

80001868 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001868:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
8000186c:	ff010113          	addi	sp,sp,-16
80001870:	96850513          	addi	a0,a0,-1688 # 80005968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005969>
80001874:	00112623          	sw	ra,12(sp)
80001878:	095000ef          	jal	ra,8000210c <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
8000187c:	800067b7          	lui	a5,0x80006
80001880:	f4a7aa23          	sw	a0,-172(a5) # 80005f54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f55>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001884:	fb9ff0ef          	jal	ra,8000183c <uart_console_hook_install>

	return 0;
}
80001888:	00c12083          	lw	ra,12(sp)
8000188c:	00000513          	li	a0,0
80001890:	01010113          	addi	sp,sp,16
80001894:	00008067          	ret

80001898 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001898:	f01007b7          	lui	a5,0xf0100
8000189c:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
800018a0:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
800018a4:	f447a583          	lw	a1,-188(a5)
800018a8:	fee59ae3          	bne	a1,a4,8000189c <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
800018ac:	00008067          	ret

800018b0 <timer_isr>:

static void timer_isr(void *arg)
{
800018b0:	fe010113          	addi	sp,sp,-32
800018b4:	00812c23          	sw	s0,24(sp)
800018b8:	00112e23          	sw	ra,28(sp)
800018bc:	00912a23          	sw	s1,20(sp)
800018c0:	01212823          	sw	s2,16(sp)
800018c4:	01312623          	sw	s3,12(sp)
800018c8:	01412423          	sw	s4,8(sp)
800018cc:	01512223          	sw	s5,4(sp)
800018d0:	00800413          	li	s0,8
800018d4:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800018d8:	80006937          	lui	s2,0x80006
800018dc:	f5890513          	addi	a0,s2,-168 # 80005f58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f59>
	key = (mstatus & SOC_MSTATUS_IEN);
800018e0:	00847413          	andi	s0,s0,8
800018e4:	089020ef          	jal	ra,8000416c <z_spin_lock_valid>
800018e8:	02051e63          	bnez	a0,80001924 <timer_isr+0x74>
800018ec:	800064b7          	lui	s1,0x80006
800018f0:	800065b7          	lui	a1,0x80006
800018f4:	80006537          	lui	a0,0x80006
800018f8:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800018fc:	04e00693          	li	a3,78
80001900:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80001904:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80001908:	e2dff0ef          	jal	ra,80001734 <printk>
8000190c:	80006537          	lui	a0,0x80006
80001910:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80001914:	e21ff0ef          	jal	ra,80001734 <printk>
80001918:	04e00593          	li	a1,78
8000191c:	97c48513          	addi	a0,s1,-1668
80001920:	e51ff0ef          	jal	ra,80001770 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001924:	f5890513          	addi	a0,s2,-168
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001928:	800064b7          	lui	s1,0x80006
8000192c:	099020ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
80001930:	f3848493          	addi	s1,s1,-200 # 80005f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f39>
	u64_t now = mtime();
80001934:	f65ff0ef          	jal	ra,80001898 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001938:	0004a983          	lw	s3,0(s1)
8000193c:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001940:	00050713          	mv	a4,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001944:	41350533          	sub	a0,a0,s3
80001948:	00a73733          	sltu	a4,a4,a0
8000194c:	415585b3          	sub	a1,a1,s5
80001950:	0001d637          	lui	a2,0x1d
80001954:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001958:	00000693          	li	a3,0
8000195c:	40e585b3          	sub	a1,a1,a4
80001960:	961fe0ef          	jal	ra,800002c0 <__udivdi3>

	last_count += dticks * CYC_PER_TICK;
80001964:	0001d7b7          	lui	a5,0x1d
80001968:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000196c:	02a787b3          	mul	a5,a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001970:	00050a13          	mv	s4,a0
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001974:	f5890513          	addi	a0,s2,-168
	last_count += dticks * CYC_PER_TICK;
80001978:	013789b3          	add	s3,a5,s3
8000197c:	00f9b7b3          	sltu	a5,s3,a5
80001980:	015787b3          	add	a5,a5,s5
80001984:	0134a023          	sw	s3,0(s1)
80001988:	00f4a223          	sw	a5,4(s1)
8000198c:	009020ef          	jal	ra,80004194 <z_spin_unlock_valid>
80001990:	02051e63          	bnez	a0,800019cc <timer_isr+0x11c>
80001994:	800064b7          	lui	s1,0x80006
80001998:	800065b7          	lui	a1,0x80006
8000199c:	80006537          	lui	a0,0x80006
800019a0:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
800019a4:	06100693          	li	a3,97
800019a8:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800019ac:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800019b0:	d85ff0ef          	jal	ra,80001734 <printk>
800019b4:	80006537          	lui	a0,0x80006
800019b8:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
800019bc:	d79ff0ef          	jal	ra,80001734 <printk>
800019c0:	06100593          	li	a1,97
800019c4:	97c48513          	addi	a0,s1,-1668
800019c8:	da9ff0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800019cc:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
800019d0:	01812403          	lw	s0,24(sp)
800019d4:	01c12083          	lw	ra,28(sp)
800019d8:	01412483          	lw	s1,20(sp)
800019dc:	01012903          	lw	s2,16(sp)
800019e0:	00c12983          	lw	s3,12(sp)
800019e4:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800019e8:	000a0513          	mv	a0,s4
}
800019ec:	00812a03          	lw	s4,8(sp)
800019f0:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800019f4:	1a40306f          	j	80004b98 <z_clock_announce>

800019f8 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
800019f8:	ff010113          	addi	sp,sp,-16
800019fc:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001a00:	e99ff0ef          	jal	ra,80001898 <mtime>
80001a04:	0001d7b7          	lui	a5,0x1d
80001a08:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001a0c:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001a10:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80001a14:	fff00693          	li	a3,-1
80001a18:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001a1c:	00a7b533          	sltu	a0,a5,a0
80001a20:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80001a24:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001a28:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80001a2c:	00700513          	li	a0,7
80001a30:	d85ff0ef          	jal	ra,800017b4 <z_arch_irq_enable>
	return 0;
}
80001a34:	00c12083          	lw	ra,12(sp)
80001a38:	00000513          	li	a0,0
80001a3c:	01010113          	addi	sp,sp,16
80001a40:	00008067          	ret

80001a44 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001a44:	16059c63          	bnez	a1,80001bbc <z_clock_set_timeout+0x178>
{
80001a48:	fe010113          	addi	sp,sp,-32
80001a4c:	00112e23          	sw	ra,28(sp)
80001a50:	00812c23          	sw	s0,24(sp)
80001a54:	00912a23          	sw	s1,20(sp)
80001a58:	01212823          	sw	s2,16(sp)
80001a5c:	01312623          	sw	s3,12(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80001a60:	fff00793          	li	a5,-1
80001a64:	00f51663          	bne	a0,a5,80001a70 <z_clock_set_timeout+0x2c>
80001a68:	00009537          	lui	a0,0x9
80001a6c:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80001a70:	000097b7          	lui	a5,0x9
80001a74:	fff50413          	addi	s0,a0,-1
80001a78:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80001a7c:	1287da63          	bge	a5,s0,80001bb0 <z_clock_set_timeout+0x16c>
80001a80:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001a84:	00800493          	li	s1,8
80001a88:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001a8c:	80006937          	lui	s2,0x80006
80001a90:	f5890513          	addi	a0,s2,-168 # 80005f58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f59>
	key = (mstatus & SOC_MSTATUS_IEN);
80001a94:	0084f493          	andi	s1,s1,8
80001a98:	6d4020ef          	jal	ra,8000416c <z_spin_lock_valid>
80001a9c:	02051e63          	bnez	a0,80001ad8 <z_clock_set_timeout+0x94>
80001aa0:	800069b7          	lui	s3,0x80006
80001aa4:	800065b7          	lui	a1,0x80006
80001aa8:	80006537          	lui	a0,0x80006
80001aac:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80001ab0:	04e00693          	li	a3,78
80001ab4:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80001ab8:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80001abc:	c79ff0ef          	jal	ra,80001734 <printk>
80001ac0:	80006537          	lui	a0,0x80006
80001ac4:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80001ac8:	c6dff0ef          	jal	ra,80001734 <printk>
80001acc:	04e00593          	li	a1,78
80001ad0:	97c98513          	addi	a0,s3,-1668
80001ad4:	c9dff0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80001ad8:	f5890513          	addi	a0,s2,-168
80001adc:	6e8020ef          	jal	ra,800041c4 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80001ae0:	db9ff0ef          	jal	ra,80001898 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;
80001ae4:	0001d6b7          	lui	a3,0x1d

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001ae8:	800067b7          	lui	a5,0x80006
	u32_t cyc = ticks * CYC_PER_TICK;
80001aec:	4c068613          	addi	a2,a3,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001af0:	f3878793          	addi	a5,a5,-200 # 80005f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f39>
80001af4:	0007a703          	lw	a4,0(a5)
80001af8:	0047a583          	lw	a1,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001afc:	02c407b3          	mul	a5,s0,a2
80001b00:	4bf68693          	addi	a3,a3,1215
80001b04:	40e68433          	sub	s0,a3,a4
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001b08:	3e700693          	li	a3,999
80001b0c:	008787b3          	add	a5,a5,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001b10:	00f507b3          	add	a5,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001b14:	02c7d7b3          	divu	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001b18:	40a70533          	sub	a0,a4,a0
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001b1c:	02c787b3          	mul	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001b20:	00f50533          	add	a0,a0,a5
80001b24:	00a6c463          	blt	a3,a0,80001b2c <z_clock_set_timeout+0xe8>
		cyc += CYC_PER_TICK;
80001b28:	00c787b3          	add	a5,a5,a2
	r[1] = 0xffffffff;
80001b2c:	f01006b7          	lui	a3,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80001b30:	00e78733          	add	a4,a5,a4
	r[1] = 0xffffffff;
80001b34:	fff00613          	li	a2,-1
80001b38:	f4c6a623          	sw	a2,-180(a3) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80001b3c:	00f737b3          	sltu	a5,a4,a5
80001b40:	00b787b3          	add	a5,a5,a1
	r[0] = (u32_t)time;
80001b44:	f4e6a423          	sw	a4,-184(a3)
	r[1] = (u32_t)(time >> 32);
80001b48:	f4f6a623          	sw	a5,-180(a3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001b4c:	f5890513          	addi	a0,s2,-168
80001b50:	644020ef          	jal	ra,80004194 <z_spin_unlock_valid>
80001b54:	02051e63          	bnez	a0,80001b90 <z_clock_set_timeout+0x14c>
80001b58:	80006437          	lui	s0,0x80006
80001b5c:	800065b7          	lui	a1,0x80006
80001b60:	80006537          	lui	a0,0x80006
80001b64:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80001b68:	06100693          	li	a3,97
80001b6c:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80001b70:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80001b74:	bc1ff0ef          	jal	ra,80001734 <printk>
80001b78:	80006537          	lui	a0,0x80006
80001b7c:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80001b80:	bb5ff0ef          	jal	ra,80001734 <printk>
80001b84:	06100593          	li	a1,97
80001b88:	97c40513          	addi	a0,s0,-1668
80001b8c:	be5ff0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001b90:	3004a4f3          	csrrs	s1,mstatus,s1
	k_spin_unlock(&lock, key);
#endif
}
80001b94:	01c12083          	lw	ra,28(sp)
80001b98:	01812403          	lw	s0,24(sp)
80001b9c:	01412483          	lw	s1,20(sp)
80001ba0:	01012903          	lw	s2,16(sp)
80001ba4:	00c12983          	lw	s3,12(sp)
80001ba8:	02010113          	addi	sp,sp,32
80001bac:	00008067          	ret
80001bb0:	ec045ae3          	bgez	s0,80001a84 <z_clock_set_timeout+0x40>
80001bb4:	00000413          	li	s0,0
80001bb8:	ecdff06f          	j	80001a84 <z_clock_set_timeout+0x40>
80001bbc:	00008067          	ret

80001bc0 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80001bc0:	ff010113          	addi	sp,sp,-16
80001bc4:	00812423          	sw	s0,8(sp)
80001bc8:	00112623          	sw	ra,12(sp)
80001bcc:	00912223          	sw	s1,4(sp)
80001bd0:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001bd4:	00800413          	li	s0,8
80001bd8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001bdc:	80006937          	lui	s2,0x80006
80001be0:	f5890513          	addi	a0,s2,-168 # 80005f58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f59>
	key = (mstatus & SOC_MSTATUS_IEN);
80001be4:	00847413          	andi	s0,s0,8
80001be8:	584020ef          	jal	ra,8000416c <z_spin_lock_valid>
80001bec:	02051e63          	bnez	a0,80001c28 <z_clock_elapsed+0x68>
80001bf0:	800064b7          	lui	s1,0x80006
80001bf4:	800065b7          	lui	a1,0x80006
80001bf8:	80006537          	lui	a0,0x80006
80001bfc:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80001c00:	04e00693          	li	a3,78
80001c04:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80001c08:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80001c0c:	b29ff0ef          	jal	ra,80001734 <printk>
80001c10:	80006537          	lui	a0,0x80006
80001c14:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80001c18:	b1dff0ef          	jal	ra,80001734 <printk>
80001c1c:	04e00593          	li	a1,78
80001c20:	97c48513          	addi	a0,s1,-1668
80001c24:	b4dff0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80001c28:	f5890513          	addi	a0,s2,-168
80001c2c:	598020ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80001c30:	c69ff0ef          	jal	ra,80001898 <mtime>
80001c34:	800067b7          	lui	a5,0x80006
80001c38:	f387a483          	lw	s1,-200(a5) # 80005f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f39>
80001c3c:	409504b3          	sub	s1,a0,s1
80001c40:	0001d537          	lui	a0,0x1d
80001c44:	4c050513          	addi	a0,a0,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001c48:	02a4d4b3          	divu	s1,s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001c4c:	f5890513          	addi	a0,s2,-168
80001c50:	544020ef          	jal	ra,80004194 <z_spin_unlock_valid>
80001c54:	02051e63          	bnez	a0,80001c90 <z_clock_elapsed+0xd0>
80001c58:	80006937          	lui	s2,0x80006
80001c5c:	800065b7          	lui	a1,0x80006
80001c60:	80006537          	lui	a0,0x80006
80001c64:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80001c68:	06100693          	li	a3,97
80001c6c:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80001c70:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80001c74:	ac1ff0ef          	jal	ra,80001734 <printk>
80001c78:	80006537          	lui	a0,0x80006
80001c7c:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80001c80:	ab5ff0ef          	jal	ra,80001734 <printk>
80001c84:	06100593          	li	a1,97
80001c88:	97c90513          	addi	a0,s2,-1668
80001c8c:	ae5ff0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001c90:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80001c94:	00c12083          	lw	ra,12(sp)
80001c98:	00812403          	lw	s0,8(sp)
80001c9c:	00048513          	mv	a0,s1
80001ca0:	00012903          	lw	s2,0(sp)
80001ca4:	00412483          	lw	s1,4(sp)
80001ca8:	01010113          	addi	sp,sp,16
80001cac:	00008067          	ret

80001cb0 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80001cb0:	00054783          	lbu	a5,0(a0)
80001cb4:	0005c703          	lbu	a4,0(a1)
80001cb8:	00e79463          	bne	a5,a4,80001cc0 <strcmp+0x10>
80001cbc:	00079663          	bnez	a5,80001cc8 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80001cc0:	40e78533          	sub	a0,a5,a4
80001cc4:	00008067          	ret
		s1++;
80001cc8:	00150513          	addi	a0,a0,1
		s2++;
80001ccc:	00158593          	addi	a1,a1,1
80001cd0:	fe1ff06f          	j	80001cb0 <strcmp>

80001cd4 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80001cd4:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80001cd8:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80001cdc:	0037f713          	andi	a4,a5,3
80001ce0:	04071863          	bnez	a4,80001d30 <memset+0x5c>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80001ce4:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80001ce8:	00859713          	slli	a4,a1,0x8
80001cec:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80001cf0:	01059713          	slli	a4,a1,0x10
80001cf4:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80001cf8:	00c78333          	add	t1,a5,a2
80001cfc:	00078713          	mv	a4,a5
80001d00:	00300813          	li	a6,3
80001d04:	40e308b3          	sub	a7,t1,a4
80001d08:	03186e63          	bltu	a6,a7,80001d44 <memset+0x70>
80001d0c:	00265713          	srli	a4,a2,0x2
80001d10:	00271593          	slli	a1,a4,0x2
80001d14:	00b787b3          	add	a5,a5,a1
80001d18:	ffc00593          	li	a1,-4
80001d1c:	02b70733          	mul	a4,a4,a1
80001d20:	00c70733          	add	a4,a4,a2
80001d24:	00e78733          	add	a4,a5,a4

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80001d28:	02e79463          	bne	a5,a4,80001d50 <memset+0x7c>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80001d2c:	00008067          	ret
		if (n == 0) {
80001d30:	fe060ee3          	beqz	a2,80001d2c <memset+0x58>
		*(d_byte++) = c_byte;
80001d34:	00178793          	addi	a5,a5,1
80001d38:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001d3c:	fff60613          	addi	a2,a2,-1
80001d40:	f9dff06f          	j	80001cdc <memset+0x8>
		*(d_word++) = c_word;
80001d44:	00470713          	addi	a4,a4,4
80001d48:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80001d4c:	fb9ff06f          	j	80001d04 <memset+0x30>
		*(d_byte++) = c_byte;
80001d50:	00178793          	addi	a5,a5,1
80001d54:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001d58:	fd1ff06f          	j	80001d28 <memset+0x54>

80001d5c <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80001d5c:	fff00513          	li	a0,-1
80001d60:	00008067          	ret

80001d64 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80001d64:	800067b7          	lui	a5,0x80006
80001d68:	eca7ac23          	sw	a0,-296(a5) # 80005ed8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ed9>
}
80001d6c:	00008067          	ret

80001d70 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80001d70:	fe010113          	addi	sp,sp,-32
80001d74:	00812c23          	sw	s0,24(sp)
	test->setup();
80001d78:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80001d7c:	80006437          	lui	s0,0x80006
{
80001d80:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80001d84:	edc40413          	addi	s0,s0,-292 # 80005edc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005edd>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80001d88:	800064b7          	lui	s1,0x80006
{
80001d8c:	00112e23          	sw	ra,28(sp)
80001d90:	01212823          	sw	s2,16(sp)
80001d94:	01312623          	sw	s3,12(sp)
	test_result = 1;
80001d98:	f5c48493          	addi	s1,s1,-164 # 80005f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f5d>
80001d9c:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80001da0:	00042023          	sw	zero,0(s0)
{
80001da4:	00050913          	mv	s2,a0
	test_result = 1;
80001da8:	0134a023          	sw	s3,0(s1)
	test->setup();
80001dac:	000780e7          	jalr	a5
	test->test();
80001db0:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80001db4:	01342023          	sw	s3,0(s0)
	test->test();
80001db8:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80001dbc:	00200793          	li	a5,2
80001dc0:	00f42023          	sw	a5,0(s0)
	test->teardown();
80001dc4:	00c92783          	lw	a5,12(s2)
80001dc8:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80001dcc:	00300793          	li	a5,3
80001dd0:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80001dd4:	01812403          	lw	s0,24(sp)
	test_result = 0;
80001dd8:	0004a023          	sw	zero,0(s1)
}
80001ddc:	01c12083          	lw	ra,28(sp)
80001de0:	01412483          	lw	s1,20(sp)
80001de4:	01012903          	lw	s2,16(sp)
80001de8:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80001dec:	80006537          	lui	a0,0x80006
80001df0:	09450513          	addi	a0,a0,148 # 80006094 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006095>
80001df4:	02010113          	addi	sp,sp,32
80001df8:	7b90106f          	j	80003db0 <z_impl_k_sem_give>

80001dfc <ztest_test_fail>:
80001dfc:	80006537          	lui	a0,0x80006
{
80001e00:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80001e04:	800067b7          	lui	a5,0x80006
80001e08:	fff00713          	li	a4,-1
80001e0c:	09450513          	addi	a0,a0,148 # 80006094 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006095>
{
80001e10:	00112623          	sw	ra,12(sp)
	test_result = -1;
80001e14:	f4e7ae23          	sw	a4,-164(a5) # 80005f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f5d>
80001e18:	799010ef          	jal	ra,80003db0 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001e1c:	6c1010ef          	jal	ra,80003cdc <z_impl_k_current_get>
}
80001e20:	00c12083          	lw	ra,12(sp)
80001e24:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001e28:	6ac0206f          	j	800044d4 <z_impl_k_thread_abort>

80001e2c <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80001e2c:	fa010113          	addi	sp,sp,-96
80001e30:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80001e34:	800064b7          	lui	s1,0x80006
80001e38:	f604a783          	lw	a5,-160(s1) # 80005f60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f61>
{
80001e3c:	04112e23          	sw	ra,92(sp)
80001e40:	04812c23          	sw	s0,88(sp)
80001e44:	05212823          	sw	s2,80(sp)
80001e48:	05312623          	sw	s3,76(sp)
80001e4c:	05412423          	sw	s4,72(sp)
80001e50:	05512223          	sw	s5,68(sp)
80001e54:	05612023          	sw	s6,64(sp)
80001e58:	03712e23          	sw	s7,60(sp)
80001e5c:	03812c23          	sw	s8,56(sp)
80001e60:	03912a23          	sw	s9,52(sp)
80001e64:	03a12823          	sw	s10,48(sp)
80001e68:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
80001e6c:	0807c463          	bltz	a5,80001ef4 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001e70:	80006437          	lui	s0,0x80006
80001e74:	00100613          	li	a2,1
80001e78:	00050993          	mv	s3,a0
80001e7c:	00058c13          	mv	s8,a1
80001e80:	09440513          	addi	a0,s0,148 # 80006094 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006095>
80001e84:	00000593          	li	a1,0
80001e88:	661010ef          	jal	ra,80003ce8 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80001e8c:	80006537          	lui	a0,0x80006
80001e90:	00098593          	mv	a1,s3
80001e94:	a3050513          	addi	a0,a0,-1488 # 80005a30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a31>
80001e98:	89dff0ef          	jal	ra,80001734 <printk>
	PRINT_LINE;
80001e9c:	80006937          	lui	s2,0x80006
80001ea0:	a4890513          	addi	a0,s2,-1464 # 80005a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a49>
		Z_TC_END_RESULT(ret, test->name);
80001ea4:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
80001ea8:	88dff0ef          	jal	ra,80001734 <printk>
80001eac:	f6048493          	addi	s1,s1,-160
	int fail = 0;
80001eb0:	00000a13          	li	s4,0
80001eb4:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001eb8:	80006cb7          	lui	s9,0x80006
80001ebc:	80006b37          	lui	s6,0x80006
80001ec0:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80001ec4:	80006db7          	lui	s11,0x80006
80001ec8:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
80001ecc:	9f0a8a93          	addi	s5,s5,-1552 # 800059f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059f1>
	while (suite->test) {
80001ed0:	004c2783          	lw	a5,4(s8)
80001ed4:	04079e63          	bnez	a5,80001f30 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80001ed8:	00098593          	mv	a1,s3
	if (fail) {
80001edc:	100a0663          	beqz	s4,80001fe8 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80001ee0:	80006537          	lui	a0,0x80006
80001ee4:	ab850513          	addi	a0,a0,-1352 # 80005ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ab9>
80001ee8:	84dff0ef          	jal	ra,80001734 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80001eec:	00100793          	li	a5,1
80001ef0:	00f4a023          	sw	a5,0(s1)
}
80001ef4:	05c12083          	lw	ra,92(sp)
80001ef8:	05812403          	lw	s0,88(sp)
80001efc:	05412483          	lw	s1,84(sp)
80001f00:	05012903          	lw	s2,80(sp)
80001f04:	04c12983          	lw	s3,76(sp)
80001f08:	04812a03          	lw	s4,72(sp)
80001f0c:	04412a83          	lw	s5,68(sp)
80001f10:	04012b03          	lw	s6,64(sp)
80001f14:	03c12b83          	lw	s7,60(sp)
80001f18:	03812c03          	lw	s8,56(sp)
80001f1c:	03412c83          	lw	s9,52(sp)
80001f20:	03012d03          	lw	s10,48(sp)
80001f24:	02c12d83          	lw	s11,44(sp)
80001f28:	06010113          	addi	sp,sp,96
80001f2c:	00008067          	ret
	TC_START(test->name);
80001f30:	000c2583          	lw	a1,0(s8)
80001f34:	800067b7          	lui	a5,0x80006
80001f38:	a9078513          	addi	a0,a5,-1392 # 80005a90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a91>
80001f3c:	ff8ff0ef          	jal	ra,80001734 <printk>
80001f40:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80001f44:	010c2783          	lw	a5,16(s8)
80001f48:	000c0713          	mv	a4,s8
80001f4c:	40000613          	li	a2,1024
80001f50:	0087e793          	ori	a5,a5,8
80001f54:	fff00893          	li	a7,-1
80001f58:	00000813          	li	a6,0
80001f5c:	d70d0693          	addi	a3,s10,-656 # 80001d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001d71>
80001f60:	00f12023          	sw	a5,0(sp)
80001f64:	520c8593          	addi	a1,s9,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
80001f68:	00000793          	li	a5,0
80001f6c:	0a4b0513          	addi	a0,s6,164 # 800060a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a5>
80001f70:	3c0020ef          	jal	ra,80004330 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001f74:	01c12783          	lw	a5,28(sp)
80001f78:	fff00593          	li	a1,-1
80001f7c:	09478513          	addi	a0,a5,148
80001f80:	715010ef          	jal	ra,80003e94 <z_impl_k_sem_take>
	if (test_result == -1) {
80001f84:	f5cd8793          	addi	a5,s11,-164 # 80005f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f5d>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001f88:	0a4b0513          	addi	a0,s6,164
80001f8c:	0007a403          	lw	s0,0(a5)
80001f90:	544020ef          	jal	ra,800044d4 <z_impl_k_thread_abort>
	if (test_result == -2) {
80001f94:	800067b7          	lui	a5,0x80006
80001f98:	f5c78793          	addi	a5,a5,-164 # 80005f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f5d>
80001f9c:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80001fa0:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80001fa4:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80001fa8:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80001fac:	000c2603          	lw	a2,0(s8)
80001fb0:	02f71463          	bne	a4,a5,80001fd8 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80001fb4:	800065b7          	lui	a1,0x80006
80001fb8:	aa458593          	addi	a1,a1,-1372 # 80005aa4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aa5>
		Z_TC_END_RESULT(ret, test->name);
80001fbc:	aacb8513          	addi	a0,s7,-1364 # 80005aac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aad>
80001fc0:	f74ff0ef          	jal	ra,80001734 <printk>
80001fc4:	a4890513          	addi	a0,s2,-1464
80001fc8:	f6cff0ef          	jal	ra,80001734 <printk>
		fail += run_test(suite);
80001fcc:	008a0a33          	add	s4,s4,s0
		suite++;
80001fd0:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80001fd4:	efdff06f          	j	80001ed0 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80001fd8:	00241793          	slli	a5,s0,0x2
80001fdc:	00fa87b3          	add	a5,s5,a5
80001fe0:	0007a583          	lw	a1,0(a5)
80001fe4:	fd9ff06f          	j	80001fbc <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80001fe8:	80006537          	lui	a0,0x80006
80001fec:	ad050513          	addi	a0,a0,-1328 # 80005ad0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ad1>
80001ff0:	f44ff0ef          	jal	ra,80001734 <printk>
	test_status = (test_status || fail) ? 1 : 0;
80001ff4:	0004a783          	lw	a5,0(s1)
80001ff8:	00f037b3          	snez	a5,a5
80001ffc:	ef5ff06f          	j	80001ef0 <z_ztest_run_test_suite+0xc4>

80002000 <end_report>:

void end_report(void)
{
	if (test_status) {
80002000:	800067b7          	lui	a5,0x80006
80002004:	f607a783          	lw	a5,-160(a5) # 80005f60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f61>
{
80002008:	ff010113          	addi	sp,sp,-16
8000200c:	00812423          	sw	s0,8(sp)
80002010:	80006537          	lui	a0,0x80006
80002014:	00112623          	sw	ra,12(sp)
80002018:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
8000201c:	a4850513          	addi	a0,a0,-1464 # 80005a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a49>
	if (test_status) {
80002020:	02078263          	beqz	a5,80002044 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002024:	f10ff0ef          	jal	ra,80001734 <printk>
80002028:	800065b7          	lui	a1,0x80006
8000202c:	9fc58593          	addi	a1,a1,-1540 # 800059fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059fd>
	} else {
		TC_END_REPORT(TC_PASS);
80002030:	a0440513          	addi	a0,s0,-1532 # 80005a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a05>
	}
}
80002034:	00812403          	lw	s0,8(sp)
80002038:	00c12083          	lw	ra,12(sp)
8000203c:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002040:	ef4ff06f          	j	80001734 <printk>
80002044:	ef0ff0ef          	jal	ra,80001734 <printk>
80002048:	800065b7          	lui	a1,0x80006
8000204c:	a1c58593          	addi	a1,a1,-1508 # 80005a1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a1d>
80002050:	fe1ff06f          	j	80002030 <end_report+0x30>

80002054 <main>:

	return test_status;
}
#else
void main(void)
{
80002054:	ff010113          	addi	sp,sp,-16
80002058:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
8000205c:	b39fe0ef          	jal	ra,80000b94 <test_main>
	end_report();
}
80002060:	00c12083          	lw	ra,12(sp)
80002064:	01010113          	addi	sp,sp,16
	end_report();
80002068:	f99ff06f          	j	80002000 <end_report>

8000206c <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
8000206c:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002070:	00012623          	sw	zero,12(sp)
    i++;
80002074:	00c12783          	lw	a5,12(sp)
80002078:	00178793          	addi	a5,a5,1
8000207c:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002080:	f00107b7          	lui	a5,0xf0010
80002084:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002088:	01010113          	addi	sp,sp,16
8000208c:	00008067          	ret

80002090 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002090:	fff00513          	li	a0,-1
80002094:	00008067          	ret

80002098 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002098:	00000513          	li	a0,0
8000209c:	00008067          	ret

800020a0 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
800020a0:	00251713          	slli	a4,a0,0x2
800020a4:	800067b7          	lui	a5,0x80006
800020a8:	00150513          	addi	a0,a0,1
800020ac:	b0078793          	addi	a5,a5,-1280 # 80005b00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b01>
800020b0:	00251513          	slli	a0,a0,0x2
{
800020b4:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800020b8:	00e78733          	add	a4,a5,a4
800020bc:	00a787b3          	add	a5,a5,a0
{
800020c0:	00812423          	sw	s0,8(sp)
800020c4:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800020c8:	00072403          	lw	s0,0(a4)
800020cc:	0007a483          	lw	s1,0(a5)
{
800020d0:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800020d4:	00946c63          	bltu	s0,s1,800020ec <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
800020d8:	00c12083          	lw	ra,12(sp)
800020dc:	00812403          	lw	s0,8(sp)
800020e0:	00412483          	lw	s1,4(sp)
800020e4:	01010113          	addi	sp,sp,16
800020e8:	00008067          	ret
		retval = device_conf->init(info);
800020ec:	00042783          	lw	a5,0(s0)
800020f0:	00040513          	mv	a0,s0
800020f4:	0047a783          	lw	a5,4(a5)
800020f8:	000780e7          	jalr	a5
		if (retval != 0) {
800020fc:	00050463          	beqz	a0,80002104 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002100:	00042223          	sw	zero,4(s0)
								info++) {
80002104:	00c40413          	addi	s0,s0,12
80002108:	fcdff06f          	j	800020d4 <z_sys_device_do_config_level+0x34>

8000210c <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
8000210c:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002110:	800067b7          	lui	a5,0x80006
{
80002114:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002118:	800064b7          	lui	s1,0x80006
{
8000211c:	00812423          	sw	s0,8(sp)
80002120:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002124:	ef478413          	addi	s0,a5,-268 # 80005ef4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef5>
{
80002128:	01212023          	sw	s2,0(sp)
8000212c:	ef478793          	addi	a5,a5,-268
80002130:	f2448493          	addi	s1,s1,-220 # 80005f24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f25>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002134:	00941c63          	bne	s0,s1,8000214c <z_impl_device_get_binding+0x40>
80002138:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
8000213c:	00078413          	mv	s0,a5
80002140:	02941463          	bne	s0,s1,80002168 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002144:	00000413          	li	s0,0
80002148:	0440006f          	j	8000218c <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
8000214c:	00442703          	lw	a4,4(s0)
80002150:	00070863          	beqz	a4,80002160 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002154:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002158:	00072703          	lw	a4,0(a4)
8000215c:	02a70863          	beq	a4,a0,8000218c <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002160:	00c40413          	addi	s0,s0,12
80002164:	fd1ff06f          	j	80002134 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80002168:	00442783          	lw	a5,4(s0)
8000216c:	00079663          	bnez	a5,80002178 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002170:	00c40413          	addi	s0,s0,12
80002174:	fcdff06f          	j	80002140 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80002178:	00042783          	lw	a5,0(s0)
8000217c:	00090513          	mv	a0,s2
80002180:	0007a583          	lw	a1,0(a5)
80002184:	b2dff0ef          	jal	ra,80001cb0 <strcmp>
80002188:	fe0514e3          	bnez	a0,80002170 <z_impl_device_get_binding+0x64>
}
8000218c:	00040513          	mv	a0,s0
80002190:	00c12083          	lw	ra,12(sp)
80002194:	00812403          	lw	s0,8(sp)
80002198:	00412483          	lw	s1,4(sp)
8000219c:	00012903          	lw	s2,0(sp)
800021a0:	01010113          	addi	sp,sp,16
800021a4:	00008067          	ret

800021a8 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
800021a8:	ff010113          	addi	sp,sp,-16
800021ac:	00812423          	sw	s0,8(sp)
800021b0:	00912223          	sw	s1,4(sp)
800021b4:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800021b8:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800021bc:	00200493          	li	s1,2
800021c0:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
800021c4:	7f4020ef          	jal	ra,800049b8 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800021c8:	00a4c463          	blt	s1,a0,800021d0 <idle+0x28>
800021cc:	00100513          	li	a0,1
800021d0:	00100593          	li	a1,1
800021d4:	0c1020ef          	jal	ra,80004a94 <z_set_timeout_expiry>
	k_cpu_idle();
800021d8:	dccff0ef          	jal	ra,800017a4 <k_cpu_idle>
800021dc:	fe5ff06f          	j	800021c0 <idle+0x18>

800021e0 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
800021e0:	80006537          	lui	a0,0x80006
800021e4:	800067b7          	lui	a5,0x80006
800021e8:	f3850613          	addi	a2,a0,-200 # 80005f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f39>
800021ec:	22078793          	addi	a5,a5,544 # 80006220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006221>
800021f0:	40c78633          	sub	a2,a5,a2
800021f4:	00000593          	li	a1,0
800021f8:	f3850513          	addi	a0,a0,-200
800021fc:	ad9ff06f          	j	80001cd4 <memset>

80002200 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002200:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002204:	00200513          	li	a0,2
{
80002208:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
8000220c:	e95ff0ef          	jal	ra,800020a0 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002210:	80006537          	lui	a0,0x80006
80002214:	b1450513          	addi	a0,a0,-1260 # 80005b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b15>
80002218:	d1cff0ef          	jal	ra,80001734 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
8000221c:	00300513          	li	a0,3
80002220:	e81ff0ef          	jal	ra,800020a0 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002224:	200020ef          	jal	ra,80004424 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002228:	e2dff0ef          	jal	ra,80002054 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
8000222c:	800067b7          	lui	a5,0x80006
80002230:	18478793          	addi	a5,a5,388 # 80006184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006185>
80002234:	00c7c703          	lbu	a4,12(a5)
80002238:	ffe77713          	andi	a4,a4,-2
8000223c:	00e78623          	sb	a4,12(a5)
}
80002240:	00c12083          	lw	ra,12(sp)
80002244:	01010113          	addi	sp,sp,16
80002248:	00008067          	ret

8000224c <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
8000224c:	f6010113          	addi	sp,sp,-160
80002250:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002254:	800077b7          	lui	a5,0x80007
80002258:	80006437          	lui	s0,0x80006
8000225c:	09312623          	sw	s3,140(sp)
80002260:	52078793          	addi	a5,a5,1312 # 80007520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007521>
80002264:	1f440993          	addi	s3,s0,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80002268:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
8000226c:	01010793          	addi	a5,sp,16
80002270:	07000613          	li	a2,112
80002274:	00000593          	li	a1,0
80002278:	00078513          	mv	a0,a5
{
8000227c:	08112e23          	sw	ra,156(sp)
80002280:	08912a23          	sw	s1,148(sp)
80002284:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002288:	a4dff0ef          	jal	ra,80001cd4 <memset>
8000228c:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80002290:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002294:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80002298:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
8000229c:	e05ff0ef          	jal	ra,800020a0 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
800022a0:	00100513          	li	a0,1
800022a4:	dfdff0ef          	jal	ra,800020a0 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
800022a8:	10100793          	li	a5,257
800022ac:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
800022b0:	490010ef          	jal	ra,80003740 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
800022b4:	800067b7          	lui	a5,0x80006
800022b8:	b5878793          	addi	a5,a5,-1192 # 80005b58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b59>
	_kernel.ready_q.cache = _main_thread;
800022bc:	80006937          	lui	s2,0x80006
	z_setup_new_thread(_main_thread, _main_stack,
800022c0:	00f12223          	sw	a5,4(sp)
800022c4:	800026b7          	lui	a3,0x80002
800022c8:	00100793          	li	a5,1
800022cc:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
800022d0:	18490493          	addi	s1,s2,388 # 80006184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006185>
	z_setup_new_thread(_main_thread, _main_stack,
800022d4:	00f12023          	sw	a5,0(sp)
800022d8:	00000713          	li	a4,0
800022dc:	00000793          	li	a5,0
800022e0:	00000893          	li	a7,0
800022e4:	00000813          	li	a6,0
800022e8:	20068693          	addi	a3,a3,512 # 80002200 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002201>
800022ec:	20000613          	li	a2,512
800022f0:	92058593          	addi	a1,a1,-1760 # 80006920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006921>
800022f4:	18490513          	addi	a0,s2,388
	_kernel.ready_q.cache = _main_thread;
800022f8:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
800022fc:	5a5010ef          	jal	ra,800040a0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002300:	00d4c783          	lbu	a5,13(s1)
80002304:	1f440413          	addi	s0,s0,500
80002308:	ffb7f713          	andi	a4,a5,-5
8000230c:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002310:	01b7f793          	andi	a5,a5,27
80002314:	00079a63          	bnez	a5,80002328 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002318:	0184a783          	lw	a5,24(s1)
8000231c:	00079663          	bnez	a5,80002328 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002320:	18490513          	addi	a0,s2,388
80002324:	089000ef          	jal	ra,80002bac <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002328:	800067b7          	lui	a5,0x80006
8000232c:	b6078793          	addi	a5,a5,-1184 # 80005b60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b61>
80002330:	00f12223          	sw	a5,4(sp)
80002334:	80006537          	lui	a0,0x80006
80002338:	00100793          	li	a5,1
8000233c:	800026b7          	lui	a3,0x80002
80002340:	800075b7          	lui	a1,0x80007
80002344:	11450493          	addi	s1,a0,276 # 80006114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006115>
80002348:	00f12023          	sw	a5,0(sp)
8000234c:	00f00893          	li	a7,15
80002350:	00000813          	li	a6,0
80002354:	00000793          	li	a5,0
80002358:	00000713          	li	a4,0
8000235c:	1a868693          	addi	a3,a3,424 # 800021a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800021a9>
80002360:	20000613          	li	a2,512
80002364:	b2058593          	addi	a1,a1,-1248 # 80006b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b21>
80002368:	11450513          	addi	a0,a0,276
8000236c:	535010ef          	jal	ra,800040a0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002370:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80002374:	00942623          	sw	s1,12(s0)
80002378:	00800513          	li	a0,8
8000237c:	ffb7f793          	andi	a5,a5,-5
80002380:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002384:	800067b7          	lui	a5,0x80006
80002388:	20c78793          	addi	a5,a5,524 # 8000620c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000620d>
8000238c:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002390:	00f42e23          	sw	a5,28(s0)
80002394:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002398:	00857513          	andi	a0,a0,8
8000239c:	e9dfd0ef          	jal	ra,80000238 <__swap>

800023a0 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800023a0:	00d54783          	lbu	a5,13(a0)
800023a4:	01f7f793          	andi	a5,a5,31
800023a8:	00079863          	bnez	a5,800023b8 <z_is_thread_ready+0x18>
800023ac:	01852503          	lw	a0,24(a0)
800023b0:	00153513          	seqz	a0,a0
800023b4:	00008067          	ret
800023b8:	00000513          	li	a0,0
}
800023bc:	00008067          	ret

800023c0 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
800023c0:	ff010113          	addi	sp,sp,-16
800023c4:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800023c8:	ff8ff0ef          	jal	ra,80001bc0 <z_clock_elapsed>
800023cc:	800067b7          	lui	a5,0x80006
800023d0:	f6c7a783          	lw	a5,-148(a5) # 80005f6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f6d>

	z_set_timeout_expiry(slice_time, false);
}
800023d4:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800023d8:	80006737          	lui	a4,0x80006
800023dc:	00a78533          	add	a0,a5,a0
800023e0:	20a72223          	sw	a0,516(a4) # 80006204 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006205>
	z_set_timeout_expiry(slice_time, false);
800023e4:	00000593          	li	a1,0
800023e8:	00078513          	mv	a0,a5
}
800023ec:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
800023f0:	6a40206f          	j	80004a94 <z_set_timeout_expiry>

800023f4 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
800023f4:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
800023f8:	ff010113          	addi	sp,sp,-16
800023fc:	00812423          	sw	s0,8(sp)
80002400:	00112623          	sw	ra,12(sp)
80002404:	00912223          	sw	s1,4(sp)
80002408:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
8000240c:	02079863          	bnez	a5,8000243c <pended_on.isra.15+0x48>
80002410:	800064b7          	lui	s1,0x80006
80002414:	800065b7          	lui	a1,0x80006
80002418:	80006537          	lui	a0,0x80006
8000241c:	c0458593          	addi	a1,a1,-1020 # 80005c04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c05>
80002420:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002424:	18300693          	li	a3,387
80002428:	bf048613          	addi	a2,s1,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
8000242c:	b08ff0ef          	jal	ra,80001734 <printk>
80002430:	18300593          	li	a1,387
80002434:	bf048513          	addi	a0,s1,-1040
80002438:	b38ff0ef          	jal	ra,80001770 <assert_post_action>

	return thread->base.pended_on;
}
8000243c:	00042503          	lw	a0,0(s0)
80002440:	00c12083          	lw	ra,12(sp)
80002444:	00812403          	lw	s0,8(sp)
80002448:	00412483          	lw	s1,4(sp)
8000244c:	01010113          	addi	sp,sp,16
80002450:	00008067          	ret

80002454 <k_sched_time_slice_set>:
{
80002454:	fe010113          	addi	sp,sp,-32
80002458:	00812c23          	sw	s0,24(sp)
8000245c:	01212823          	sw	s2,16(sp)
80002460:	01412423          	sw	s4,8(sp)
80002464:	00112e23          	sw	ra,28(sp)
80002468:	00912a23          	sw	s1,20(sp)
8000246c:	01312623          	sw	s3,12(sp)
80002470:	00050913          	mv	s2,a0
80002474:	00058a13          	mv	s4,a1
80002478:	00800413          	li	s0,8
8000247c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002480:	800064b7          	lui	s1,0x80006
80002484:	f6448513          	addi	a0,s1,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
80002488:	00847413          	andi	s0,s0,8
8000248c:	4e1010ef          	jal	ra,8000416c <z_spin_lock_valid>
80002490:	02051e63          	bnez	a0,800024cc <k_sched_time_slice_set+0x78>
80002494:	800069b7          	lui	s3,0x80006
80002498:	800065b7          	lui	a1,0x80006
8000249c:	80006537          	lui	a0,0x80006
800024a0:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800024a4:	04e00693          	li	a3,78
800024a8:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800024ac:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800024b0:	a84ff0ef          	jal	ra,80001734 <printk>
800024b4:	80006537          	lui	a0,0x80006
800024b8:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
800024bc:	a78ff0ef          	jal	ra,80001734 <printk>
800024c0:	04e00593          	li	a1,78
800024c4:	97c98513          	addi	a0,s3,-1668
800024c8:	aa8ff0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
800024cc:	f6448513          	addi	a0,s1,-156
800024d0:	4f5010ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
800024d4:	800067b7          	lui	a5,0x80006
800024d8:	2007a223          	sw	zero,516(a5) # 80006204 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006205>
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800024dc:	00990913          	addi	s2,s2,9
800024e0:	00a00793          	li	a5,10
800024e4:	02f94933          	div	s2,s2,a5
		slice_time = z_ms_to_ticks(slice);
800024e8:	800067b7          	lui	a5,0x80006
800024ec:	f727a623          	sw	s2,-148(a5) # 80005f6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f6d>
		slice_max_prio = prio;
800024f0:	800067b7          	lui	a5,0x80006
800024f4:	f747a423          	sw	s4,-152(a5) # 80005f68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f69>
		reset_time_slice();
800024f8:	ec9ff0ef          	jal	ra,800023c0 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800024fc:	f6448513          	addi	a0,s1,-156
80002500:	495010ef          	jal	ra,80004194 <z_spin_unlock_valid>
80002504:	02051e63          	bnez	a0,80002540 <k_sched_time_slice_set+0xec>
80002508:	800064b7          	lui	s1,0x80006
8000250c:	800065b7          	lui	a1,0x80006
80002510:	80006537          	lui	a0,0x80006
80002514:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80002518:	06100693          	li	a3,97
8000251c:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002520:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002524:	a10ff0ef          	jal	ra,80001734 <printk>
80002528:	80006537          	lui	a0,0x80006
8000252c:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80002530:	a04ff0ef          	jal	ra,80001734 <printk>
80002534:	06100593          	li	a1,97
80002538:	97c48513          	addi	a0,s1,-1668
8000253c:	a34ff0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002540:	30042473          	csrrs	s0,mstatus,s0
}
80002544:	01c12083          	lw	ra,28(sp)
80002548:	01812403          	lw	s0,24(sp)
8000254c:	01412483          	lw	s1,20(sp)
80002550:	01012903          	lw	s2,16(sp)
80002554:	00c12983          	lw	s3,12(sp)
80002558:	00812a03          	lw	s4,8(sp)
8000255c:	02010113          	addi	sp,sp,32
80002560:	00008067          	ret

80002564 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002564:	fe010113          	addi	sp,sp,-32
80002568:	00812c23          	sw	s0,24(sp)
8000256c:	01212823          	sw	s2,16(sp)
80002570:	00112e23          	sw	ra,28(sp)
80002574:	00912a23          	sw	s1,20(sp)
80002578:	01312623          	sw	s3,12(sp)
8000257c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002580:	00800413          	li	s0,8
80002584:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002588:	800064b7          	lui	s1,0x80006
8000258c:	f6448513          	addi	a0,s1,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
80002590:	00847413          	andi	s0,s0,8
80002594:	3d9010ef          	jal	ra,8000416c <z_spin_lock_valid>
80002598:	02051e63          	bnez	a0,800025d4 <z_unpend_thread_no_timeout+0x70>
8000259c:	800069b7          	lui	s3,0x80006
800025a0:	800065b7          	lui	a1,0x80006
800025a4:	80006537          	lui	a0,0x80006
800025a8:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800025ac:	04e00693          	li	a3,78
800025b0:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800025b4:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800025b8:	97cff0ef          	jal	ra,80001734 <printk>
800025bc:	80006537          	lui	a0,0x80006
800025c0:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
800025c4:	970ff0ef          	jal	ra,80001734 <printk>
800025c8:	04e00593          	li	a1,78
800025cc:	97c98513          	addi	a0,s3,-1668
800025d0:	9a0ff0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
800025d4:	f6448513          	addi	a0,s1,-156
800025d8:	3ed010ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800025dc:	00890513          	addi	a0,s2,8
800025e0:	e15ff0ef          	jal	ra,800023f4 <pended_on.isra.15>
800025e4:	00090593          	mv	a1,s2
800025e8:	2f0000ef          	jal	ra,800028d8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800025ec:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800025f0:	f6448513          	addi	a0,s1,-156
800025f4:	ffd7f793          	andi	a5,a5,-3
800025f8:	00f906a3          	sb	a5,13(s2)
800025fc:	399010ef          	jal	ra,80004194 <z_spin_unlock_valid>
80002600:	02051e63          	bnez	a0,8000263c <z_unpend_thread_no_timeout+0xd8>
80002604:	800064b7          	lui	s1,0x80006
80002608:	800065b7          	lui	a1,0x80006
8000260c:	80006537          	lui	a0,0x80006
80002610:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80002614:	06100693          	li	a3,97
80002618:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
8000261c:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002620:	914ff0ef          	jal	ra,80001734 <printk>
80002624:	80006537          	lui	a0,0x80006
80002628:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
8000262c:	908ff0ef          	jal	ra,80001734 <printk>
80002630:	06100593          	li	a1,97
80002634:	97c48513          	addi	a0,s1,-1668
80002638:	938ff0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000263c:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80002640:	01c12083          	lw	ra,28(sp)
80002644:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80002648:	00092423          	sw	zero,8(s2)
}
8000264c:	01412483          	lw	s1,20(sp)
80002650:	01012903          	lw	s2,16(sp)
80002654:	00c12983          	lw	s3,12(sp)
80002658:	02010113          	addi	sp,sp,32
8000265c:	00008067          	ret

80002660 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80002660:	800067b7          	lui	a5,0x80006
80002664:	1f47a783          	lw	a5,500(a5) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
{
80002668:	ff010113          	addi	sp,sp,-16
8000266c:	00812423          	sw	s0,8(sp)
80002670:	00112623          	sw	ra,12(sp)
80002674:	00912223          	sw	s1,4(sp)
80002678:	00058413          	mv	s0,a1
	if (resched()) {
8000267c:	04079e63          	bnez	a5,800026d8 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002680:	315010ef          	jal	ra,80004194 <z_spin_unlock_valid>
80002684:	02051e63          	bnez	a0,800026c0 <z_reschedule+0x60>
80002688:	800064b7          	lui	s1,0x80006
8000268c:	800065b7          	lui	a1,0x80006
80002690:	80006537          	lui	a0,0x80006
80002694:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80002698:	07800693          	li	a3,120
8000269c:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800026a0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800026a4:	890ff0ef          	jal	ra,80001734 <printk>
800026a8:	80006537          	lui	a0,0x80006
800026ac:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
800026b0:	884ff0ef          	jal	ra,80001734 <printk>
800026b4:	07800593          	li	a1,120
800026b8:	97c48513          	addi	a0,s1,-1668
800026bc:	8b4ff0ef          	jal	ra,80001770 <assert_post_action>
800026c0:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
800026c4:	00812403          	lw	s0,8(sp)
800026c8:	00c12083          	lw	ra,12(sp)
800026cc:	00412483          	lw	s1,4(sp)
800026d0:	01010113          	addi	sp,sp,16
800026d4:	b65fd06f          	j	80000238 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800026d8:	2bd010ef          	jal	ra,80004194 <z_spin_unlock_valid>
800026dc:	02051e63          	bnez	a0,80002718 <z_reschedule+0xb8>
800026e0:	800064b7          	lui	s1,0x80006
800026e4:	800065b7          	lui	a1,0x80006
800026e8:	80006537          	lui	a0,0x80006
800026ec:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
800026f0:	06100693          	li	a3,97
800026f4:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800026f8:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800026fc:	838ff0ef          	jal	ra,80001734 <printk>
80002700:	80006537          	lui	a0,0x80006
80002704:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80002708:	82cff0ef          	jal	ra,80001734 <printk>
8000270c:	06100593          	li	a1,97
80002710:	97c48513          	addi	a0,s1,-1668
80002714:	85cff0ef          	jal	ra,80001770 <assert_post_action>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80002718:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000271c:	30042473          	csrrs	s0,mstatus,s0
80002720:	00c12083          	lw	ra,12(sp)
80002724:	00812403          	lw	s0,8(sp)
80002728:	00412483          	lw	s1,4(sp)
8000272c:	01010113          	addi	sp,sp,16
80002730:	00008067          	ret

80002734 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80002734:	80006737          	lui	a4,0x80006
80002738:	1f472703          	lw	a4,500(a4) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
8000273c:	00071463          	bnez	a4,80002744 <z_reschedule_irqlock+0x10>
80002740:	af9fd06f          	j	80000238 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80002744:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002748:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
8000274c:	00008067          	ret

80002750 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002750:	00800513          	li	a0,8
80002754:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80002758:	00857513          	andi	a0,a0,8
8000275c:	fd9ff06f          	j	80002734 <z_reschedule_irqlock>

80002760 <k_sched_lock>:

void k_sched_lock(void)
{
80002760:	fe010113          	addi	sp,sp,-32
80002764:	00812c23          	sw	s0,24(sp)
80002768:	00112e23          	sw	ra,28(sp)
8000276c:	00912a23          	sw	s1,20(sp)
80002770:	01212823          	sw	s2,16(sp)
80002774:	01312623          	sw	s3,12(sp)
80002778:	00800413          	li	s0,8
8000277c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002780:	800064b7          	lui	s1,0x80006
80002784:	f6448513          	addi	a0,s1,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
80002788:	00847413          	andi	s0,s0,8
8000278c:	1e1010ef          	jal	ra,8000416c <z_spin_lock_valid>
80002790:	02051e63          	bnez	a0,800027cc <k_sched_lock+0x6c>
80002794:	80006937          	lui	s2,0x80006
80002798:	800065b7          	lui	a1,0x80006
8000279c:	80006537          	lui	a0,0x80006
800027a0:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800027a4:	04e00693          	li	a3,78
800027a8:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800027ac:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800027b0:	f85fe0ef          	jal	ra,80001734 <printk>
800027b4:	80006537          	lui	a0,0x80006
800027b8:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
800027bc:	f79fe0ef          	jal	ra,80001734 <printk>
800027c0:	04e00593          	li	a1,78
800027c4:	97c90513          	addi	a0,s2,-1668
800027c8:	fa9fe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
800027cc:	f6448513          	addi	a0,s1,-156
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
800027d0:	80006937          	lui	s2,0x80006
800027d4:	1f1010ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
800027d8:	1f492783          	lw	a5,500(s2) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
800027dc:	1f490913          	addi	s2,s2,500
800027e0:	02078e63          	beqz	a5,8000281c <k_sched_lock+0xbc>
800027e4:	800069b7          	lui	s3,0x80006
800027e8:	800065b7          	lui	a1,0x80006
800027ec:	80006537          	lui	a0,0x80006
800027f0:	b8458593          	addi	a1,a1,-1148 # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
800027f4:	10000693          	li	a3,256
800027f8:	b6898613          	addi	a2,s3,-1176 # 80005b68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b69>
800027fc:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002800:	f35fe0ef          	jal	ra,80001734 <printk>
80002804:	80006537          	lui	a0,0x80006
80002808:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
8000280c:	f29fe0ef          	jal	ra,80001734 <printk>
80002810:	10000593          	li	a1,256
80002814:	b6898513          	addi	a0,s3,-1176
80002818:	f59fe0ef          	jal	ra,80001770 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
8000281c:	00892783          	lw	a5,8(s2)
80002820:	00f7c703          	lbu	a4,15(a5)
80002824:	00100793          	li	a5,1
80002828:	02f71e63          	bne	a4,a5,80002864 <k_sched_lock+0x104>
8000282c:	800069b7          	lui	s3,0x80006
80002830:	800065b7          	lui	a1,0x80006
80002834:	80006537          	lui	a0,0x80006
80002838:	ba058593          	addi	a1,a1,-1120 # 80005ba0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ba1>
8000283c:	10100693          	li	a3,257
80002840:	b6898613          	addi	a2,s3,-1176 # 80005b68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b69>
80002844:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002848:	eedfe0ef          	jal	ra,80001734 <printk>
8000284c:	80006537          	lui	a0,0x80006
80002850:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80002854:	ee1fe0ef          	jal	ra,80001734 <printk>
80002858:	10100593          	li	a1,257
8000285c:	b6898513          	addi	a0,s3,-1176
80002860:	f11fe0ef          	jal	ra,80001770 <assert_post_action>

	--_current->base.sched_locked;
80002864:	00892703          	lw	a4,8(s2)
80002868:	00f74783          	lbu	a5,15(a4)
8000286c:	fff78793          	addi	a5,a5,-1
80002870:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002874:	f6448513          	addi	a0,s1,-156
80002878:	11d010ef          	jal	ra,80004194 <z_spin_unlock_valid>
8000287c:	02051e63          	bnez	a0,800028b8 <k_sched_lock+0x158>
80002880:	800064b7          	lui	s1,0x80006
80002884:	800065b7          	lui	a1,0x80006
80002888:	80006537          	lui	a0,0x80006
8000288c:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80002890:	06100693          	li	a3,97
80002894:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002898:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
8000289c:	e99fe0ef          	jal	ra,80001734 <printk>
800028a0:	80006537          	lui	a0,0x80006
800028a4:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
800028a8:	e8dfe0ef          	jal	ra,80001734 <printk>
800028ac:	06100593          	li	a1,97
800028b0:	97c48513          	addi	a0,s1,-1668
800028b4:	ebdfe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800028b8:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800028bc:	01c12083          	lw	ra,28(sp)
800028c0:	01812403          	lw	s0,24(sp)
800028c4:	01412483          	lw	s1,20(sp)
800028c8:	01012903          	lw	s2,16(sp)
800028cc:	00c12983          	lw	s3,12(sp)
800028d0:	02010113          	addi	sp,sp,32
800028d4:	00008067          	ret

800028d8 <z_priq_dumb_remove>:
	return thread == _idle_thread;
800028d8:	800067b7          	lui	a5,0x80006
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800028dc:	ef07a783          	lw	a5,-272(a5) # 80005ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef1>
{
800028e0:	ff010113          	addi	sp,sp,-16
800028e4:	00812423          	sw	s0,8(sp)
800028e8:	00112623          	sw	ra,12(sp)
800028ec:	00912223          	sw	s1,4(sp)
800028f0:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800028f4:	02f59863          	bne	a1,a5,80002924 <z_priq_dumb_remove+0x4c>
800028f8:	800064b7          	lui	s1,0x80006
800028fc:	800065b7          	lui	a1,0x80006
80002900:	80006537          	lui	a0,0x80006
80002904:	d0858593          	addi	a1,a1,-760 # 80005d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d09>
80002908:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
8000290c:	28c00693          	li	a3,652
80002910:	bf048613          	addi	a2,s1,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80002914:	e21fe0ef          	jal	ra,80001734 <printk>
80002918:	28c00593          	li	a1,652
8000291c:	bf048513          	addi	a0,s1,-1040
80002920:	e51fe0ef          	jal	ra,80001770 <assert_post_action>
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
80002924:	00442703          	lw	a4,4(s0)
80002928:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
8000292c:	00c12083          	lw	ra,12(sp)
80002930:	00412483          	lw	s1,4(sp)
80002934:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80002938:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
8000293c:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80002940:	00042223          	sw	zero,4(s0)
80002944:	00812403          	lw	s0,8(sp)
80002948:	01010113          	addi	sp,sp,16
8000294c:	00008067          	ret

80002950 <z_priq_dumb_best>:
	return list->head == list;
80002950:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002954:	00f51463          	bne	a0,a5,8000295c <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80002958:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
8000295c:	00078513          	mv	a0,a5
80002960:	00008067          	ret

80002964 <update_cache>:
{
80002964:	ff010113          	addi	sp,sp,-16
80002968:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
8000296c:	80006437          	lui	s0,0x80006
{
80002970:	01212023          	sw	s2,0(sp)
80002974:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002978:	1f440513          	addi	a0,s0,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
8000297c:	02450513          	addi	a0,a0,36
{
80002980:	00912223          	sw	s1,4(sp)
80002984:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002988:	fc9ff0ef          	jal	ra,80002950 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
8000298c:	1f440413          	addi	s0,s0,500
80002990:	00050493          	mv	s1,a0
80002994:	00051463          	bnez	a0,8000299c <update_cache+0x38>
80002998:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
8000299c:	06091e63          	bnez	s2,80002a18 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
800029a0:	00842783          	lw	a5,8(s0)
800029a4:	02079e63          	bnez	a5,800029e0 <update_cache+0x7c>
800029a8:	80006937          	lui	s2,0x80006
800029ac:	800065b7          	lui	a1,0x80006
800029b0:	80006537          	lui	a0,0x80006
800029b4:	c1c58593          	addi	a1,a1,-996 # 80005c1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c1d>
800029b8:	07f00693          	li	a3,127
800029bc:	bf090613          	addi	a2,s2,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
800029c0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800029c4:	d71fe0ef          	jal	ra,80001734 <printk>
800029c8:	80006537          	lui	a0,0x80006
800029cc:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
800029d0:	d65fe0ef          	jal	ra,80001734 <printk>
800029d4:	07f00593          	li	a1,127
800029d8:	bf090513          	addi	a0,s2,-1040
800029dc:	d95fe0ef          	jal	ra,80001770 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
800029e0:	00842783          	lw	a5,8(s0)
800029e4:	00d7c703          	lbu	a4,13(a5)
800029e8:	01f77713          	andi	a4,a4,31
800029ec:	02071663          	bnez	a4,80002a18 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
800029f0:	00e7d683          	lhu	a3,14(a5)
800029f4:	07f00713          	li	a4,127
800029f8:	02d77063          	bgeu	a4,a3,80002a18 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
800029fc:	02f42023          	sw	a5,32(s0)
}
80002a00:	00c12083          	lw	ra,12(sp)
80002a04:	00812403          	lw	s0,8(sp)
80002a08:	00412483          	lw	s1,4(sp)
80002a0c:	00012903          	lw	s2,0(sp)
80002a10:	01010113          	addi	sp,sp,16
80002a14:	00008067          	ret
		if (th != _current) {
80002a18:	00842783          	lw	a5,8(s0)
80002a1c:	00978463          	beq	a5,s1,80002a24 <update_cache+0xc0>
			reset_time_slice();
80002a20:	9a1ff0ef          	jal	ra,800023c0 <reset_time_slice>
		_kernel.ready_q.cache = th;
80002a24:	02942023          	sw	s1,32(s0)
}
80002a28:	fd9ff06f          	j	80002a00 <update_cache+0x9c>

80002a2c <k_sched_unlock>:
{
80002a2c:	fe010113          	addi	sp,sp,-32
80002a30:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002a34:	80006937          	lui	s2,0x80006
80002a38:	1f490793          	addi	a5,s2,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80002a3c:	0087a783          	lw	a5,8(a5)
{
80002a40:	00112e23          	sw	ra,28(sp)
80002a44:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002a48:	00f7c783          	lbu	a5,15(a5)
{
80002a4c:	00912a23          	sw	s1,20(sp)
80002a50:	01312623          	sw	s3,12(sp)
80002a54:	1f490913          	addi	s2,s2,500
	__ASSERT(_current->base.sched_locked != 0, "");
80002a58:	02079e63          	bnez	a5,80002a94 <k_sched_unlock+0x68>
80002a5c:	80006437          	lui	s0,0x80006
80002a60:	800065b7          	lui	a1,0x80006
80002a64:	80006537          	lui	a0,0x80006
80002a68:	bc858593          	addi	a1,a1,-1080 # 80005bc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bc9>
80002a6c:	22100693          	li	a3,545
80002a70:	bf040613          	addi	a2,s0,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80002a74:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002a78:	cbdfe0ef          	jal	ra,80001734 <printk>
80002a7c:	80006537          	lui	a0,0x80006
80002a80:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80002a84:	cb1fe0ef          	jal	ra,80001734 <printk>
80002a88:	22100593          	li	a1,545
80002a8c:	bf040513          	addi	a0,s0,-1040
80002a90:	ce1fe0ef          	jal	ra,80001770 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80002a94:	00092783          	lw	a5,0(s2)
80002a98:	02078e63          	beqz	a5,80002ad4 <k_sched_unlock+0xa8>
80002a9c:	80006437          	lui	s0,0x80006
80002aa0:	800065b7          	lui	a1,0x80006
80002aa4:	80006537          	lui	a0,0x80006
80002aa8:	b8458593          	addi	a1,a1,-1148 # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
80002aac:	22200693          	li	a3,546
80002ab0:	bf040613          	addi	a2,s0,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80002ab4:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002ab8:	c7dfe0ef          	jal	ra,80001734 <printk>
80002abc:	80006537          	lui	a0,0x80006
80002ac0:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80002ac4:	c71fe0ef          	jal	ra,80001734 <printk>
80002ac8:	22200593          	li	a1,546
80002acc:	bf040513          	addi	a0,s0,-1040
80002ad0:	ca1fe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002ad4:	00800413          	li	s0,8
80002ad8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002adc:	800064b7          	lui	s1,0x80006
80002ae0:	f6448513          	addi	a0,s1,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ae4:	00847413          	andi	s0,s0,8
80002ae8:	684010ef          	jal	ra,8000416c <z_spin_lock_valid>
80002aec:	02051e63          	bnez	a0,80002b28 <k_sched_unlock+0xfc>
80002af0:	800069b7          	lui	s3,0x80006
80002af4:	800065b7          	lui	a1,0x80006
80002af8:	80006537          	lui	a0,0x80006
80002afc:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80002b00:	04e00693          	li	a3,78
80002b04:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002b08:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002b0c:	c29fe0ef          	jal	ra,80001734 <printk>
80002b10:	80006537          	lui	a0,0x80006
80002b14:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80002b18:	c1dfe0ef          	jal	ra,80001734 <printk>
80002b1c:	04e00593          	li	a1,78
80002b20:	97c98513          	addi	a0,s3,-1668
80002b24:	c4dfe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80002b28:	f6448513          	addi	a0,s1,-156
80002b2c:	698010ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80002b30:	00892703          	lw	a4,8(s2)
		update_cache(1);
80002b34:	00100513          	li	a0,1
		++_current->base.sched_locked;
80002b38:	00f74783          	lbu	a5,15(a4)
80002b3c:	00178793          	addi	a5,a5,1
80002b40:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80002b44:	e21ff0ef          	jal	ra,80002964 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002b48:	f6448513          	addi	a0,s1,-156
80002b4c:	648010ef          	jal	ra,80004194 <z_spin_unlock_valid>
80002b50:	02051e63          	bnez	a0,80002b8c <k_sched_unlock+0x160>
80002b54:	800064b7          	lui	s1,0x80006
80002b58:	800065b7          	lui	a1,0x80006
80002b5c:	80006537          	lui	a0,0x80006
80002b60:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80002b64:	06100693          	li	a3,97
80002b68:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002b6c:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002b70:	bc5fe0ef          	jal	ra,80001734 <printk>
80002b74:	80006537          	lui	a0,0x80006
80002b78:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80002b7c:	bb9fe0ef          	jal	ra,80001734 <printk>
80002b80:	06100593          	li	a1,97
80002b84:	97c48513          	addi	a0,s1,-1668
80002b88:	be9fe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b8c:	30042473          	csrrs	s0,mstatus,s0
}
80002b90:	01812403          	lw	s0,24(sp)
80002b94:	01c12083          	lw	ra,28(sp)
80002b98:	01412483          	lw	s1,20(sp)
80002b9c:	01012903          	lw	s2,16(sp)
80002ba0:	00c12983          	lw	s3,12(sp)
80002ba4:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80002ba8:	ba9ff06f          	j	80002750 <z_reschedule_unlocked>

80002bac <z_add_thread_to_ready_q>:
{
80002bac:	fe010113          	addi	sp,sp,-32
80002bb0:	00812c23          	sw	s0,24(sp)
80002bb4:	00912a23          	sw	s1,20(sp)
80002bb8:	00112e23          	sw	ra,28(sp)
80002bbc:	01212823          	sw	s2,16(sp)
80002bc0:	01312623          	sw	s3,12(sp)
80002bc4:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002bc8:	00800493          	li	s1,8
80002bcc:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002bd0:	80006937          	lui	s2,0x80006
80002bd4:	f6490513          	addi	a0,s2,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
80002bd8:	0084f493          	andi	s1,s1,8
80002bdc:	590010ef          	jal	ra,8000416c <z_spin_lock_valid>
80002be0:	02051e63          	bnez	a0,80002c1c <z_add_thread_to_ready_q+0x70>
80002be4:	800069b7          	lui	s3,0x80006
80002be8:	800065b7          	lui	a1,0x80006
80002bec:	80006537          	lui	a0,0x80006
80002bf0:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80002bf4:	04e00693          	li	a3,78
80002bf8:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002bfc:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002c00:	b35fe0ef          	jal	ra,80001734 <printk>
80002c04:	80006537          	lui	a0,0x80006
80002c08:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80002c0c:	b29fe0ef          	jal	ra,80001734 <printk>
80002c10:	04e00593          	li	a1,78
80002c14:	97c98513          	addi	a0,s3,-1668
80002c18:	b59fe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80002c1c:	f6490513          	addi	a0,s2,-156
80002c20:	5a4010ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80002c24:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80002c28:	ef07a783          	lw	a5,-272(a5) # 80005ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef1>
80002c2c:	02f41863          	bne	s0,a5,80002c5c <z_add_thread_to_ready_q+0xb0>
80002c30:	800069b7          	lui	s3,0x80006
80002c34:	800065b7          	lui	a1,0x80006
80002c38:	80006537          	lui	a0,0x80006
80002c3c:	d0858593          	addi	a1,a1,-760 # 80005d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d09>
80002c40:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002c44:	27600693          	li	a3,630
80002c48:	bf098613          	addi	a2,s3,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80002c4c:	ae9fe0ef          	jal	ra,80001734 <printk>
80002c50:	27600593          	li	a1,630
80002c54:	bf098513          	addi	a0,s3,-1040
80002c58:	b19fe0ef          	jal	ra,80001770 <assert_post_action>
	return list->head == list;
80002c5c:	80006737          	lui	a4,0x80006
80002c60:	1f470693          	addi	a3,a4,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80002c64:	0246a783          	lw	a5,36(a3)
80002c68:	0286a603          	lw	a2,40(a3)
80002c6c:	800066b7          	lui	a3,0x80006
80002c70:	21868693          	addi	a3,a3,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002c74:	1f470713          	addi	a4,a4,500
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002c78:	0ad78663          	beq	a5,a3,80002d24 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002c7c:	0a078463          	beqz	a5,80002d24 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80002c80:	00e40583          	lb	a1,14(s0)
80002c84:	00e78503          	lb	a0,14(a5)
80002c88:	08a5d863          	bge	a1,a0,80002d18 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80002c8c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80002c90:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80002c94:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80002c98:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80002c9c:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002ca0:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80002ca4:	00000513          	li	a0,0
80002ca8:	0407e793          	ori	a5,a5,64
80002cac:	00f406a3          	sb	a5,13(s0)
80002cb0:	cb5ff0ef          	jal	ra,80002964 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002cb4:	f6490513          	addi	a0,s2,-156
80002cb8:	4dc010ef          	jal	ra,80004194 <z_spin_unlock_valid>
80002cbc:	02051e63          	bnez	a0,80002cf8 <z_add_thread_to_ready_q+0x14c>
80002cc0:	80006437          	lui	s0,0x80006
80002cc4:	800065b7          	lui	a1,0x80006
80002cc8:	80006537          	lui	a0,0x80006
80002ccc:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80002cd0:	06100693          	li	a3,97
80002cd4:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002cd8:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002cdc:	a59fe0ef          	jal	ra,80001734 <printk>
80002ce0:	80006537          	lui	a0,0x80006
80002ce4:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80002ce8:	a4dfe0ef          	jal	ra,80001734 <printk>
80002cec:	06100593          	li	a1,97
80002cf0:	97c40513          	addi	a0,s0,-1668
80002cf4:	a7dfe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002cf8:	3004a4f3          	csrrs	s1,mstatus,s1
}
80002cfc:	01c12083          	lw	ra,28(sp)
80002d00:	01812403          	lw	s0,24(sp)
80002d04:	01412483          	lw	s1,20(sp)
80002d08:	01012903          	lw	s2,16(sp)
80002d0c:	00c12983          	lw	s3,12(sp)
80002d10:	02010113          	addi	sp,sp,32
80002d14:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80002d18:	00f60663          	beq	a2,a5,80002d24 <z_add_thread_to_ready_q+0x178>
80002d1c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002d20:	f60792e3          	bnez	a5,80002c84 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80002d24:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80002d28:	02872783          	lw	a5,40(a4)
	node->next = list;
80002d2c:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80002d30:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80002d34:	02872423          	sw	s0,40(a4)
80002d38:	f69ff06f          	j	80002ca0 <z_add_thread_to_ready_q+0xf4>

80002d3c <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80002d3c:	ff052783          	lw	a5,-16(a0)
{
80002d40:	fe010113          	addi	sp,sp,-32
80002d44:	00812c23          	sw	s0,24(sp)
80002d48:	01312623          	sw	s3,12(sp)
80002d4c:	00112e23          	sw	ra,28(sp)
80002d50:	00912a23          	sw	s1,20(sp)
80002d54:	01212823          	sw	s2,16(sp)
80002d58:	01412423          	sw	s4,8(sp)
80002d5c:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80002d60:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80002d64:	0c078463          	beqz	a5,80002e2c <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002d68:	00800493          	li	s1,8
80002d6c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002d70:	80006937          	lui	s2,0x80006
80002d74:	f6490513          	addi	a0,s2,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
80002d78:	0084f493          	andi	s1,s1,8
80002d7c:	3f0010ef          	jal	ra,8000416c <z_spin_lock_valid>
80002d80:	02051e63          	bnez	a0,80002dbc <z_thread_timeout+0x80>
80002d84:	80006a37          	lui	s4,0x80006
80002d88:	800065b7          	lui	a1,0x80006
80002d8c:	80006537          	lui	a0,0x80006
80002d90:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80002d94:	04e00693          	li	a3,78
80002d98:	97ca0613          	addi	a2,s4,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002d9c:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002da0:	995fe0ef          	jal	ra,80001734 <printk>
80002da4:	80006537          	lui	a0,0x80006
80002da8:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80002dac:	989fe0ef          	jal	ra,80001734 <printk>
80002db0:	04e00593          	li	a1,78
80002db4:	97ca0513          	addi	a0,s4,-1668
80002db8:	9b9fe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80002dbc:	f6490513          	addi	a0,s2,-156
80002dc0:	404010ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002dc4:	ff040513          	addi	a0,s0,-16
80002dc8:	e2cff0ef          	jal	ra,800023f4 <pended_on.isra.15>
80002dcc:	00098593          	mv	a1,s3
80002dd0:	b09ff0ef          	jal	ra,800028d8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002dd4:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002dd8:	f6490513          	addi	a0,s2,-156
80002ddc:	ffd7f793          	andi	a5,a5,-3
80002de0:	fef40aa3          	sb	a5,-11(s0)
80002de4:	3b0010ef          	jal	ra,80004194 <z_spin_unlock_valid>
80002de8:	02051e63          	bnez	a0,80002e24 <z_thread_timeout+0xe8>
80002dec:	80006937          	lui	s2,0x80006
80002df0:	800065b7          	lui	a1,0x80006
80002df4:	80006537          	lui	a0,0x80006
80002df8:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80002dfc:	06100693          	li	a3,97
80002e00:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002e04:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002e08:	92dfe0ef          	jal	ra,80001734 <printk>
80002e0c:	80006537          	lui	a0,0x80006
80002e10:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80002e14:	921fe0ef          	jal	ra,80001734 <printk>
80002e18:	06100593          	li	a1,97
80002e1c:	97c90513          	addi	a0,s2,-1668
80002e20:	951fe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002e24:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80002e28:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002e2c:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002e30:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002e34:	feb7f793          	andi	a5,a5,-21
80002e38:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002e3c:	d64ff0ef          	jal	ra,800023a0 <z_is_thread_ready>
80002e40:	02050463          	beqz	a0,80002e68 <z_thread_timeout+0x12c>
}
80002e44:	01812403          	lw	s0,24(sp)
80002e48:	01c12083          	lw	ra,28(sp)
80002e4c:	01412483          	lw	s1,20(sp)
80002e50:	01012903          	lw	s2,16(sp)
80002e54:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80002e58:	00098513          	mv	a0,s3
80002e5c:	00c12983          	lw	s3,12(sp)
80002e60:	02010113          	addi	sp,sp,32
80002e64:	d49ff06f          	j	80002bac <z_add_thread_to_ready_q>
80002e68:	01c12083          	lw	ra,28(sp)
80002e6c:	01812403          	lw	s0,24(sp)
80002e70:	01412483          	lw	s1,20(sp)
80002e74:	01012903          	lw	s2,16(sp)
80002e78:	00c12983          	lw	s3,12(sp)
80002e7c:	00812a03          	lw	s4,8(sp)
80002e80:	02010113          	addi	sp,sp,32
80002e84:	00008067          	ret

80002e88 <z_move_thread_to_end_of_prio_q>:
{
80002e88:	fe010113          	addi	sp,sp,-32
80002e8c:	00812c23          	sw	s0,24(sp)
80002e90:	01212823          	sw	s2,16(sp)
80002e94:	00112e23          	sw	ra,28(sp)
80002e98:	00912a23          	sw	s1,20(sp)
80002e9c:	01312623          	sw	s3,12(sp)
80002ea0:	01412423          	sw	s4,8(sp)
80002ea4:	01512223          	sw	s5,4(sp)
80002ea8:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002eac:	00800913          	li	s2,8
80002eb0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002eb4:	800069b7          	lui	s3,0x80006
80002eb8:	f6498513          	addi	a0,s3,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ebc:	00897913          	andi	s2,s2,8
80002ec0:	2ac010ef          	jal	ra,8000416c <z_spin_lock_valid>
80002ec4:	02051e63          	bnez	a0,80002f00 <z_move_thread_to_end_of_prio_q+0x78>
80002ec8:	800064b7          	lui	s1,0x80006
80002ecc:	800065b7          	lui	a1,0x80006
80002ed0:	80006537          	lui	a0,0x80006
80002ed4:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80002ed8:	04e00693          	li	a3,78
80002edc:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002ee0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002ee4:	851fe0ef          	jal	ra,80001734 <printk>
80002ee8:	80006537          	lui	a0,0x80006
80002eec:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80002ef0:	845fe0ef          	jal	ra,80001734 <printk>
80002ef4:	04e00593          	li	a1,78
80002ef8:	97c48513          	addi	a0,s1,-1668
80002efc:	875fe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80002f00:	f6498513          	addi	a0,s3,-156
80002f04:	2c0010ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80002f08:	800064b7          	lui	s1,0x80006
80002f0c:	1f448513          	addi	a0,s1,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80002f10:	00040593          	mv	a1,s0
80002f14:	02450513          	addi	a0,a0,36
80002f18:	9c1ff0ef          	jal	ra,800028d8 <z_priq_dumb_remove>
	return thread == _idle_thread;
80002f1c:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80002f20:	ef07a783          	lw	a5,-272(a5) # 80005ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef1>
80002f24:	80006a37          	lui	s4,0x80006
80002f28:	1f448493          	addi	s1,s1,500
80002f2c:	218a0a13          	addi	s4,s4,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
80002f30:	02f41863          	bne	s0,a5,80002f60 <z_move_thread_to_end_of_prio_q+0xd8>
80002f34:	80006ab7          	lui	s5,0x80006
80002f38:	800065b7          	lui	a1,0x80006
80002f3c:	80006537          	lui	a0,0x80006
80002f40:	d0858593          	addi	a1,a1,-760 # 80005d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d09>
80002f44:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002f48:	27600693          	li	a3,630
80002f4c:	bf0a8613          	addi	a2,s5,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80002f50:	fe4fe0ef          	jal	ra,80001734 <printk>
80002f54:	27600593          	li	a1,630
80002f58:	bf0a8513          	addi	a0,s5,-1040
80002f5c:	815fe0ef          	jal	ra,80001770 <assert_post_action>
	return list->head == list;
80002f60:	0244a783          	lw	a5,36(s1)
80002f64:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002f68:	0b478e63          	beq	a5,s4,80003024 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002f6c:	0a078c63          	beqz	a5,80003024 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80002f70:	00e40683          	lb	a3,14(s0)
80002f74:	00e78603          	lb	a2,14(a5)
80002f78:	0ac6d063          	bge	a3,a2,80003018 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80002f7c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80002f80:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80002f84:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80002f88:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80002f8c:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002f90:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80002f94:	0084a503          	lw	a0,8(s1)
80002f98:	0407e793          	ori	a5,a5,64
80002f9c:	40850533          	sub	a0,a0,s0
80002fa0:	00153513          	seqz	a0,a0
80002fa4:	00f406a3          	sb	a5,13(s0)
80002fa8:	9bdff0ef          	jal	ra,80002964 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002fac:	f6498513          	addi	a0,s3,-156
80002fb0:	1e4010ef          	jal	ra,80004194 <z_spin_unlock_valid>
80002fb4:	02051e63          	bnez	a0,80002ff0 <z_move_thread_to_end_of_prio_q+0x168>
80002fb8:	80006437          	lui	s0,0x80006
80002fbc:	800065b7          	lui	a1,0x80006
80002fc0:	80006537          	lui	a0,0x80006
80002fc4:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80002fc8:	06100693          	li	a3,97
80002fcc:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80002fd0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80002fd4:	f60fe0ef          	jal	ra,80001734 <printk>
80002fd8:	80006537          	lui	a0,0x80006
80002fdc:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80002fe0:	f54fe0ef          	jal	ra,80001734 <printk>
80002fe4:	06100593          	li	a1,97
80002fe8:	97c40513          	addi	a0,s0,-1668
80002fec:	f84fe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ff0:	30092973          	csrrs	s2,mstatus,s2
}
80002ff4:	01c12083          	lw	ra,28(sp)
80002ff8:	01812403          	lw	s0,24(sp)
80002ffc:	01412483          	lw	s1,20(sp)
80003000:	01012903          	lw	s2,16(sp)
80003004:	00c12983          	lw	s3,12(sp)
80003008:	00812a03          	lw	s4,8(sp)
8000300c:	00412a83          	lw	s5,4(sp)
80003010:	02010113          	addi	sp,sp,32
80003014:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003018:	00e78663          	beq	a5,a4,80003024 <z_move_thread_to_end_of_prio_q+0x19c>
8000301c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003020:	f4079ae3          	bnez	a5,80002f74 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003024:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003028:	0284a783          	lw	a5,40(s1)
	node->next = list;
8000302c:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003030:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003034:	0284a423          	sw	s0,40(s1)
80003038:	f59ff06f          	j	80002f90 <z_move_thread_to_end_of_prio_q+0x108>

8000303c <z_time_slice>:
	if (slice_time && sliceable(_current)) {
8000303c:	800067b7          	lui	a5,0x80006
80003040:	f6c7a783          	lw	a5,-148(a5) # 80005f6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f6d>
80003044:	06078663          	beqz	a5,800030b0 <z_time_slice+0x74>
80003048:	800067b7          	lui	a5,0x80006
8000304c:	1f478793          	addi	a5,a5,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80003050:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003054:	07f00693          	li	a3,127
80003058:	00e75603          	lhu	a2,14(a4)
8000305c:	04c6ea63          	bltu	a3,a2,800030b0 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003060:	800066b7          	lui	a3,0x80006
80003064:	00e70603          	lb	a2,14(a4)
80003068:	f686a683          	lw	a3,-152(a3) # 80005f68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f69>
8000306c:	04d64263          	blt	a2,a3,800030b0 <z_time_slice+0x74>
	return thread == _idle_thread;
80003070:	800066b7          	lui	a3,0x80006
		&& !is_idle(t)
80003074:	ef06a683          	lw	a3,-272(a3) # 80005ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef1>
80003078:	02d70c63          	beq	a4,a3,800030b0 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
8000307c:	01872683          	lw	a3,24(a4)
80003080:	02069863          	bnez	a3,800030b0 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003084:	0107a683          	lw	a3,16(a5)
80003088:	02d54063          	blt	a0,a3,800030a8 <z_time_slice+0x6c>
{
8000308c:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003090:	00070513          	mv	a0,a4
{
80003094:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003098:	df1ff0ef          	jal	ra,80002e88 <z_move_thread_to_end_of_prio_q>
}
8000309c:	00c12083          	lw	ra,12(sp)
800030a0:	01010113          	addi	sp,sp,16
			reset_time_slice();
800030a4:	b1cff06f          	j	800023c0 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
800030a8:	40a686b3          	sub	a3,a3,a0
800030ac:	00d7a823          	sw	a3,16(a5)
800030b0:	00008067          	ret

800030b4 <z_remove_thread_from_ready_q>:
{
800030b4:	fe010113          	addi	sp,sp,-32
800030b8:	00812c23          	sw	s0,24(sp)
800030bc:	01312623          	sw	s3,12(sp)
800030c0:	00112e23          	sw	ra,28(sp)
800030c4:	00912a23          	sw	s1,20(sp)
800030c8:	01212823          	sw	s2,16(sp)
800030cc:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800030d0:	00800413          	li	s0,8
800030d4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800030d8:	800064b7          	lui	s1,0x80006
800030dc:	f6448513          	addi	a0,s1,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
800030e0:	00847413          	andi	s0,s0,8
800030e4:	088010ef          	jal	ra,8000416c <z_spin_lock_valid>
800030e8:	02051e63          	bnez	a0,80003124 <z_remove_thread_from_ready_q+0x70>
800030ec:	80006937          	lui	s2,0x80006
800030f0:	800065b7          	lui	a1,0x80006
800030f4:	80006537          	lui	a0,0x80006
800030f8:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800030fc:	04e00693          	li	a3,78
80003100:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003104:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003108:	e2cfe0ef          	jal	ra,80001734 <printk>
8000310c:	80006537          	lui	a0,0x80006
80003110:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80003114:	e20fe0ef          	jal	ra,80001734 <printk>
80003118:	04e00593          	li	a1,78
8000311c:	97c90513          	addi	a0,s2,-1668
80003120:	e50fe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80003124:	f6448513          	addi	a0,s1,-156
80003128:	09c010ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
8000312c:	00d9c783          	lbu	a5,13(s3)
80003130:	80006937          	lui	s2,0x80006
80003134:	1f490913          	addi	s2,s2,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80003138:	0407f793          	andi	a5,a5,64
8000313c:	00078e63          	beqz	a5,80003158 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003140:	00098593          	mv	a1,s3
80003144:	02490513          	addi	a0,s2,36
80003148:	f90ff0ef          	jal	ra,800028d8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
8000314c:	00d9c783          	lbu	a5,13(s3)
80003150:	fbf7f793          	andi	a5,a5,-65
80003154:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003158:	00892503          	lw	a0,8(s2)
8000315c:	41350533          	sub	a0,a0,s3
80003160:	00153513          	seqz	a0,a0
80003164:	801ff0ef          	jal	ra,80002964 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003168:	f6448513          	addi	a0,s1,-156
8000316c:	028010ef          	jal	ra,80004194 <z_spin_unlock_valid>
80003170:	02051e63          	bnez	a0,800031ac <z_remove_thread_from_ready_q+0xf8>
80003174:	800064b7          	lui	s1,0x80006
80003178:	800065b7          	lui	a1,0x80006
8000317c:	80006537          	lui	a0,0x80006
80003180:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80003184:	06100693          	li	a3,97
80003188:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
8000318c:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003190:	da4fe0ef          	jal	ra,80001734 <printk>
80003194:	80006537          	lui	a0,0x80006
80003198:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
8000319c:	d98fe0ef          	jal	ra,80001734 <printk>
800031a0:	06100593          	li	a1,97
800031a4:	97c48513          	addi	a0,s1,-1668
800031a8:	dc8fe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800031ac:	30042473          	csrrs	s0,mstatus,s0
}
800031b0:	01c12083          	lw	ra,28(sp)
800031b4:	01812403          	lw	s0,24(sp)
800031b8:	01412483          	lw	s1,20(sp)
800031bc:	01012903          	lw	s2,16(sp)
800031c0:	00c12983          	lw	s3,12(sp)
800031c4:	02010113          	addi	sp,sp,32
800031c8:	00008067          	ret

800031cc <pend>:
{
800031cc:	fe010113          	addi	sp,sp,-32
800031d0:	00812c23          	sw	s0,24(sp)
800031d4:	00912a23          	sw	s1,20(sp)
800031d8:	00050413          	mv	s0,a0
800031dc:	01212823          	sw	s2,16(sp)
800031e0:	00112e23          	sw	ra,28(sp)
800031e4:	01312623          	sw	s3,12(sp)
800031e8:	00058493          	mv	s1,a1
800031ec:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
800031f0:	ec5ff0ef          	jal	ra,800030b4 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
800031f4:	00d44783          	lbu	a5,13(s0)
800031f8:	0027e793          	ori	a5,a5,2
800031fc:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003200:	06048663          	beqz	s1,8000326c <pend+0xa0>
	return thread == _idle_thread;
80003204:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003208:	ef07a783          	lw	a5,-272(a5) # 80005ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef1>
		thread->base.pended_on = wait_q;
8000320c:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003210:	02f41863          	bne	s0,a5,80003240 <pend+0x74>
80003214:	800069b7          	lui	s3,0x80006
80003218:	800065b7          	lui	a1,0x80006
8000321c:	80006537          	lui	a0,0x80006
80003220:	d0858593          	addi	a1,a1,-760 # 80005d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d09>
80003224:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003228:	27600693          	li	a3,630
8000322c:	bf098613          	addi	a2,s3,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80003230:	d04fe0ef          	jal	ra,80001734 <printk>
80003234:	27600593          	li	a1,630
80003238:	bf098513          	addi	a0,s3,-1040
8000323c:	d34fe0ef          	jal	ra,80001770 <assert_post_action>
	return list->head == list;
80003240:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003244:	06f48c63          	beq	s1,a5,800032bc <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003248:	06078a63          	beqz	a5,800032bc <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
8000324c:	00e40703          	lb	a4,14(s0)
80003250:	00e78683          	lb	a3,14(a5)
80003254:	04d75c63          	bge	a4,a3,800032ac <pend+0xe0>
	node->prev = successor->prev;
80003258:	0047a703          	lw	a4,4(a5)
	node->next = successor;
8000325c:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003260:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003264:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003268:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
8000326c:	fff00793          	li	a5,-1
80003270:	06f90463          	beq	s2,a5,800032d8 <pend+0x10c>
80003274:	00990913          	addi	s2,s2,9
80003278:	00a00613          	li	a2,10
8000327c:	02c94633          	div	a2,s2,a2

extern void z_thread_timeout(struct _timeout *to);

static inline void z_add_thread_timeout(struct k_thread *th, s32_t ticks)
{
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003280:	01840513          	addi	a0,s0,24
}
80003284:	01812403          	lw	s0,24(sp)
80003288:	01c12083          	lw	ra,28(sp)
8000328c:	01412483          	lw	s1,20(sp)
80003290:	01012903          	lw	s2,16(sp)
80003294:	00c12983          	lw	s3,12(sp)
80003298:	800035b7          	lui	a1,0x80003
8000329c:	d3c58593          	addi	a1,a1,-708 # 80002d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002d3d>
800032a0:	02010113          	addi	sp,sp,32
800032a4:	00160613          	addi	a2,a2,1
800032a8:	3ec0106f          	j	80004694 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
800032ac:	0044a683          	lw	a3,4(s1)
800032b0:	00d78663          	beq	a5,a3,800032bc <pend+0xf0>
800032b4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800032b8:	f8079ce3          	bnez	a5,80003250 <pend+0x84>
	node->prev = list->tail;
800032bc:	0044a783          	lw	a5,4(s1)
	node->next = list;
800032c0:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
800032c4:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
800032c8:	0044a783          	lw	a5,4(s1)
800032cc:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800032d0:	0084a223          	sw	s0,4(s1)
800032d4:	f99ff06f          	j	8000326c <pend+0xa0>
}
800032d8:	01c12083          	lw	ra,28(sp)
800032dc:	01812403          	lw	s0,24(sp)
800032e0:	01412483          	lw	s1,20(sp)
800032e4:	01012903          	lw	s2,16(sp)
800032e8:	00c12983          	lw	s3,12(sp)
800032ec:	02010113          	addi	sp,sp,32
800032f0:	00008067          	ret

800032f4 <z_pend_curr>:
{
800032f4:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
800032f8:	800067b7          	lui	a5,0x80006
{
800032fc:	00812423          	sw	s0,8(sp)
80003300:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003304:	1fc7a503          	lw	a0,508(a5) # 800061fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061fd>
{
80003308:	00912223          	sw	s1,4(sp)
8000330c:	00058493          	mv	s1,a1
80003310:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80003314:	00068613          	mv	a2,a3
{
80003318:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
8000331c:	eb1ff0ef          	jal	ra,800031cc <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003320:	00040513          	mv	a0,s0
80003324:	671000ef          	jal	ra,80004194 <z_spin_unlock_valid>
80003328:	02051e63          	bnez	a0,80003364 <z_pend_curr+0x70>
8000332c:	80006437          	lui	s0,0x80006
80003330:	800065b7          	lui	a1,0x80006
80003334:	80006537          	lui	a0,0x80006
80003338:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
8000333c:	07800693          	li	a3,120
80003340:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003344:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003348:	becfe0ef          	jal	ra,80001734 <printk>
8000334c:	80006537          	lui	a0,0x80006
80003350:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80003354:	be0fe0ef          	jal	ra,80001734 <printk>
80003358:	07800593          	li	a1,120
8000335c:	97c40513          	addi	a0,s0,-1668
80003360:	c10fe0ef          	jal	ra,80001770 <assert_post_action>
}
80003364:	00812403          	lw	s0,8(sp)
80003368:	00c12083          	lw	ra,12(sp)
8000336c:	00048513          	mv	a0,s1
80003370:	00412483          	lw	s1,4(sp)
80003374:	01010113          	addi	sp,sp,16
80003378:	ec1fc06f          	j	80000238 <__swap>

8000337c <z_thread_priority_set>:
{
8000337c:	fe010113          	addi	sp,sp,-32
80003380:	00812c23          	sw	s0,24(sp)
80003384:	01212823          	sw	s2,16(sp)
80003388:	01412423          	sw	s4,8(sp)
8000338c:	00112e23          	sw	ra,28(sp)
80003390:	00912a23          	sw	s1,20(sp)
80003394:	01312623          	sw	s3,12(sp)
80003398:	01512223          	sw	s5,4(sp)
8000339c:	01612023          	sw	s6,0(sp)
800033a0:	00050413          	mv	s0,a0
800033a4:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033a8:	00800913          	li	s2,8
800033ac:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033b0:	800069b7          	lui	s3,0x80006
800033b4:	f6498513          	addi	a0,s3,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
800033b8:	00897913          	andi	s2,s2,8
800033bc:	5b1000ef          	jal	ra,8000416c <z_spin_lock_valid>
800033c0:	02051e63          	bnez	a0,800033fc <z_thread_priority_set+0x80>
800033c4:	800064b7          	lui	s1,0x80006
800033c8:	800065b7          	lui	a1,0x80006
800033cc:	80006537          	lui	a0,0x80006
800033d0:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800033d4:	04e00693          	li	a3,78
800033d8:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800033dc:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800033e0:	b54fe0ef          	jal	ra,80001734 <printk>
800033e4:	80006537          	lui	a0,0x80006
800033e8:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
800033ec:	b48fe0ef          	jal	ra,80001734 <printk>
800033f0:	04e00593          	li	a1,78
800033f4:	97c48513          	addi	a0,s1,-1668
800033f8:	b78fe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
800033fc:	f6498513          	addi	a0,s3,-156
80003400:	5c5000ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		need_sched = z_is_thread_ready(thread);
80003404:	00040513          	mv	a0,s0
80003408:	f99fe0ef          	jal	ra,800023a0 <z_is_thread_ready>
8000340c:	018a1a13          	slli	s4,s4,0x18
80003410:	00050a93          	mv	s5,a0
		if (need_sched) {
80003414:	418a5a13          	srai	s4,s4,0x18
80003418:	14050063          	beqz	a0,80003558 <z_thread_priority_set+0x1dc>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
8000341c:	800064b7          	lui	s1,0x80006
80003420:	1f448513          	addi	a0,s1,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80003424:	00040593          	mv	a1,s0
80003428:	02450513          	addi	a0,a0,36
8000342c:	cacff0ef          	jal	ra,800028d8 <z_priq_dumb_remove>
	return thread == _idle_thread;
80003430:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003434:	ef07a783          	lw	a5,-272(a5) # 80005ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef1>
			thread->base.prio = prio;
80003438:	01440723          	sb	s4,14(s0)
	return thread == _idle_thread;
8000343c:	80006a37          	lui	s4,0x80006
80003440:	1f448493          	addi	s1,s1,500
80003444:	218a0a13          	addi	s4,s4,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
	__ASSERT_NO_MSG(!is_idle(thread));
80003448:	02f41863          	bne	s0,a5,80003478 <z_thread_priority_set+0xfc>
8000344c:	80006b37          	lui	s6,0x80006
80003450:	800065b7          	lui	a1,0x80006
80003454:	80006537          	lui	a0,0x80006
80003458:	d0858593          	addi	a1,a1,-760 # 80005d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d09>
8000345c:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003460:	27600693          	li	a3,630
80003464:	bf0b0613          	addi	a2,s6,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80003468:	accfe0ef          	jal	ra,80001734 <printk>
8000346c:	27600593          	li	a1,630
80003470:	bf0b0513          	addi	a0,s6,-1040
80003474:	afcfe0ef          	jal	ra,80001770 <assert_post_action>
	return list->head == list;
80003478:	0244a783          	lw	a5,36(s1)
8000347c:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003480:	0d478063          	beq	a5,s4,80003540 <z_thread_priority_set+0x1c4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003484:	0a078e63          	beqz	a5,80003540 <z_thread_priority_set+0x1c4>
	if (t1->base.prio < t2->base.prio) {
80003488:	00e40683          	lb	a3,14(s0)
8000348c:	00e78603          	lb	a2,14(a5)
80003490:	0ac6d263          	bge	a3,a2,80003534 <z_thread_priority_set+0x1b8>
	node->prev = successor->prev;
80003494:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003498:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
8000349c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800034a0:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800034a4:	0087a223          	sw	s0,4(a5)
			update_cache(1);
800034a8:	00100513          	li	a0,1
800034ac:	cb8ff0ef          	jal	ra,80002964 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800034b0:	f6498513          	addi	a0,s3,-156
800034b4:	4e1000ef          	jal	ra,80004194 <z_spin_unlock_valid>
800034b8:	02051e63          	bnez	a0,800034f4 <z_thread_priority_set+0x178>
800034bc:	80006437          	lui	s0,0x80006
800034c0:	800065b7          	lui	a1,0x80006
800034c4:	80006537          	lui	a0,0x80006
800034c8:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
800034cc:	06100693          	li	a3,97
800034d0:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800034d4:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800034d8:	a5cfe0ef          	jal	ra,80001734 <printk>
800034dc:	80006537          	lui	a0,0x80006
800034e0:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
800034e4:	a50fe0ef          	jal	ra,80001734 <printk>
800034e8:	06100593          	li	a1,97
800034ec:	97c40513          	addi	a0,s0,-1668
800034f0:	a80fe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800034f4:	30092973          	csrrs	s2,mstatus,s2
	if (need_sched && _current->base.sched_locked == 0) {
800034f8:	060a8463          	beqz	s5,80003560 <z_thread_priority_set+0x1e4>
800034fc:	800067b7          	lui	a5,0x80006
80003500:	1fc7a783          	lw	a5,508(a5) # 800061fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061fd>
80003504:	00f7c783          	lbu	a5,15(a5)
80003508:	04079c63          	bnez	a5,80003560 <z_thread_priority_set+0x1e4>
}
8000350c:	01812403          	lw	s0,24(sp)
80003510:	01c12083          	lw	ra,28(sp)
80003514:	01412483          	lw	s1,20(sp)
80003518:	01012903          	lw	s2,16(sp)
8000351c:	00c12983          	lw	s3,12(sp)
80003520:	00812a03          	lw	s4,8(sp)
80003524:	00412a83          	lw	s5,4(sp)
80003528:	00012b03          	lw	s6,0(sp)
8000352c:	02010113          	addi	sp,sp,32
		z_reschedule_unlocked();
80003530:	a20ff06f          	j	80002750 <z_reschedule_unlocked>
	return (node == list->tail) ? NULL : node->next;
80003534:	00e78663          	beq	a5,a4,80003540 <z_thread_priority_set+0x1c4>
80003538:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000353c:	f40798e3          	bnez	a5,8000348c <z_thread_priority_set+0x110>
	node->prev = list->tail;
80003540:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003544:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003548:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
8000354c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003550:	0284a423          	sw	s0,40(s1)
80003554:	f55ff06f          	j	800034a8 <z_thread_priority_set+0x12c>
			thread->base.prio = prio;
80003558:	01440723          	sb	s4,14(s0)
8000355c:	f55ff06f          	j	800034b0 <z_thread_priority_set+0x134>
}
80003560:	01c12083          	lw	ra,28(sp)
80003564:	01812403          	lw	s0,24(sp)
80003568:	01412483          	lw	s1,20(sp)
8000356c:	01012903          	lw	s2,16(sp)
80003570:	00c12983          	lw	s3,12(sp)
80003574:	00812a03          	lw	s4,8(sp)
80003578:	00412a83          	lw	s5,4(sp)
8000357c:	00012b03          	lw	s6,0(sp)
80003580:	02010113          	addi	sp,sp,32
80003584:	00008067          	ret

80003588 <z_unpend_first_thread>:
{
80003588:	fe010113          	addi	sp,sp,-32
8000358c:	01212823          	sw	s2,16(sp)
80003590:	01312623          	sw	s3,12(sp)
80003594:	00112e23          	sw	ra,28(sp)
80003598:	00812c23          	sw	s0,24(sp)
8000359c:	00912a23          	sw	s1,20(sp)
800035a0:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800035a4:	00800913          	li	s2,8
800035a8:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800035ac:	800064b7          	lui	s1,0x80006
800035b0:	f6448513          	addi	a0,s1,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
800035b4:	00897913          	andi	s2,s2,8
800035b8:	3b5000ef          	jal	ra,8000416c <z_spin_lock_valid>
800035bc:	02051e63          	bnez	a0,800035f8 <z_unpend_first_thread+0x70>
800035c0:	80006437          	lui	s0,0x80006
800035c4:	800065b7          	lui	a1,0x80006
800035c8:	80006537          	lui	a0,0x80006
800035cc:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800035d0:	04e00693          	li	a3,78
800035d4:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800035d8:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800035dc:	958fe0ef          	jal	ra,80001734 <printk>
800035e0:	80006537          	lui	a0,0x80006
800035e4:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
800035e8:	94cfe0ef          	jal	ra,80001734 <printk>
800035ec:	04e00593          	li	a1,78
800035f0:	97c40513          	addi	a0,s0,-1668
800035f4:	97cfe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
800035f8:	f6448513          	addi	a0,s1,-156
800035fc:	3c9000ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80003600:	00098513          	mv	a0,s3
80003604:	b4cff0ef          	jal	ra,80002950 <z_priq_dumb_best>
80003608:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000360c:	f6448513          	addi	a0,s1,-156
80003610:	385000ef          	jal	ra,80004194 <z_spin_unlock_valid>
80003614:	02051e63          	bnez	a0,80003650 <z_unpend_first_thread+0xc8>
80003618:	800069b7          	lui	s3,0x80006
8000361c:	800065b7          	lui	a1,0x80006
80003620:	80006537          	lui	a0,0x80006
80003624:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80003628:	06100693          	li	a3,97
8000362c:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003630:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003634:	900fe0ef          	jal	ra,80001734 <printk>
80003638:	80006537          	lui	a0,0x80006
8000363c:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80003640:	8f4fe0ef          	jal	ra,80001734 <printk>
80003644:	06100593          	li	a1,97
80003648:	97c98513          	addi	a0,s3,-1668
8000364c:	924fe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003650:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80003654:	0c040663          	beqz	s0,80003720 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003658:	00800913          	li	s2,8
8000365c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003660:	f6448513          	addi	a0,s1,-156
	key = (mstatus & SOC_MSTATUS_IEN);
80003664:	00897913          	andi	s2,s2,8
80003668:	305000ef          	jal	ra,8000416c <z_spin_lock_valid>
8000366c:	02051e63          	bnez	a0,800036a8 <z_unpend_first_thread+0x120>
80003670:	800069b7          	lui	s3,0x80006
80003674:	800065b7          	lui	a1,0x80006
80003678:	80006537          	lui	a0,0x80006
8000367c:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80003680:	04e00693          	li	a3,78
80003684:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003688:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
8000368c:	8a8fe0ef          	jal	ra,80001734 <printk>
80003690:	80006537          	lui	a0,0x80006
80003694:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80003698:	89cfe0ef          	jal	ra,80001734 <printk>
8000369c:	04e00593          	li	a1,78
800036a0:	97c98513          	addi	a0,s3,-1668
800036a4:	8ccfe0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
800036a8:	f6448513          	addi	a0,s1,-156
800036ac:	319000ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800036b0:	00840513          	addi	a0,s0,8
800036b4:	d41fe0ef          	jal	ra,800023f4 <pended_on.isra.15>
800036b8:	00040593          	mv	a1,s0
800036bc:	a1cff0ef          	jal	ra,800028d8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800036c0:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800036c4:	f6448513          	addi	a0,s1,-156
800036c8:	ffd7f793          	andi	a5,a5,-3
800036cc:	00f406a3          	sb	a5,13(s0)
800036d0:	2c5000ef          	jal	ra,80004194 <z_spin_unlock_valid>
800036d4:	02051e63          	bnez	a0,80003710 <z_unpend_first_thread+0x188>
800036d8:	800064b7          	lui	s1,0x80006
800036dc:	800065b7          	lui	a1,0x80006
800036e0:	80006537          	lui	a0,0x80006
800036e4:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
800036e8:	06100693          	li	a3,97
800036ec:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800036f0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800036f4:	840fe0ef          	jal	ra,80001734 <printk>
800036f8:	80006537          	lui	a0,0x80006
800036fc:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80003700:	834fe0ef          	jal	ra,80001734 <printk>
80003704:	06100593          	li	a1,97
80003708:	97c48513          	addi	a0,s1,-1668
8000370c:	864fe0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003710:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80003714:	00042423          	sw	zero,8(s0)
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003718:	01840513          	addi	a0,s0,24
8000371c:	1a4010ef          	jal	ra,800048c0 <z_abort_timeout>
}
80003720:	00040513          	mv	a0,s0
80003724:	01c12083          	lw	ra,28(sp)
80003728:	01812403          	lw	s0,24(sp)
8000372c:	01412483          	lw	s1,20(sp)
80003730:	01012903          	lw	s2,16(sp)
80003734:	00c12983          	lw	s3,12(sp)
80003738:	02010113          	addi	sp,sp,32
8000373c:	00008067          	ret

80003740 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80003740:	800067b7          	lui	a5,0x80006
80003744:	1f478793          	addi	a5,a5,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80003748:	02478713          	addi	a4,a5,36
8000374c:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003750:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003754:	00000593          	li	a1,0
80003758:	00000513          	li	a0,0
8000375c:	cf9fe06f          	j	80002454 <k_sched_time_slice_set>

80003760 <z_impl_k_thread_priority_set>:
Z_SYSCALL_HANDLER1_SIMPLE(k_thread_priority_get, K_OBJ_THREAD,
			  struct k_thread *);
#endif

void z_impl_k_thread_priority_set(k_tid_t tid, int prio)
{
80003760:	ff010113          	addi	sp,sp,-16
80003764:	00812423          	sw	s0,8(sp)
80003768:	01212023          	sw	s2,0(sp)
8000376c:	00112623          	sw	ra,12(sp)
80003770:	00912223          	sw	s1,4(sp)
	/*
	 * Use NULL, since we cannot know what the entry point is (we do not
	 * keep track of it) and idle cannot change its priority.
	 */
	Z_ASSERT_VALID_PRIO(prio, NULL);
80003774:	01058713          	addi	a4,a1,16
80003778:	01e00793          	li	a5,30
{
8000377c:	00050913          	mv	s2,a0
80003780:	00058413          	mv	s0,a1
	Z_ASSERT_VALID_PRIO(prio, NULL);
80003784:	04e7f463          	bgeu	a5,a4,800037cc <z_impl_k_thread_priority_set+0x6c>
80003788:	800064b7          	lui	s1,0x80006
8000378c:	800065b7          	lui	a1,0x80006
80003790:	80006537          	lui	a0,0x80006
80003794:	34500693          	li	a3,837
80003798:	bf048613          	addi	a2,s1,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
8000379c:	c8858593          	addi	a1,a1,-888 # 80005c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c89>
800037a0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800037a4:	f91fd0ef          	jal	ra,80001734 <printk>
800037a8:	80006537          	lui	a0,0x80006
800037ac:	00040593          	mv	a1,s0
800037b0:	91450513          	addi	a0,a0,-1772 # 80005914 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005915>
800037b4:	ff000693          	li	a3,-16
800037b8:	00e00613          	li	a2,14
800037bc:	f79fd0ef          	jal	ra,80001734 <printk>
800037c0:	34500593          	li	a1,837
800037c4:	bf048513          	addi	a0,s1,-1040
800037c8:	fa9fd0ef          	jal	ra,80001770 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800037cc:	800067b7          	lui	a5,0x80006
800037d0:	1f47a783          	lw	a5,500(a5) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
800037d4:	02078e63          	beqz	a5,80003810 <z_impl_k_thread_priority_set+0xb0>
800037d8:	800064b7          	lui	s1,0x80006
800037dc:	800065b7          	lui	a1,0x80006
800037e0:	80006537          	lui	a0,0x80006
800037e4:	b8458593          	addi	a1,a1,-1148 # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
800037e8:	34600693          	li	a3,838
800037ec:	bf048613          	addi	a2,s1,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
800037f0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800037f4:	f41fd0ef          	jal	ra,80001734 <printk>
800037f8:	80006537          	lui	a0,0x80006
800037fc:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80003800:	f35fd0ef          	jal	ra,80001734 <printk>
80003804:	34600593          	li	a1,838
80003808:	bf048513          	addi	a0,s1,-1040
8000380c:	f65fd0ef          	jal	ra,80001770 <assert_post_action>

	struct k_thread *thread = (struct k_thread *)tid;

	z_thread_priority_set(thread, prio);
80003810:	00040593          	mv	a1,s0
}
80003814:	00812403          	lw	s0,8(sp)
80003818:	00c12083          	lw	ra,12(sp)
8000381c:	00412483          	lw	s1,4(sp)
	z_thread_priority_set(thread, prio);
80003820:	00090513          	mv	a0,s2
}
80003824:	00012903          	lw	s2,0(sp)
80003828:	01010113          	addi	sp,sp,16
	z_thread_priority_set(thread, prio);
8000382c:	b51ff06f          	j	8000337c <z_thread_priority_set>

80003830 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80003830:	fe010113          	addi	sp,sp,-32
80003834:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80003838:	80006437          	lui	s0,0x80006
8000383c:	1f442783          	lw	a5,500(s0) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
{
80003840:	00112e23          	sw	ra,28(sp)
80003844:	00912a23          	sw	s1,20(sp)
80003848:	01212823          	sw	s2,16(sp)
8000384c:	01312623          	sw	s3,12(sp)
80003850:	01412423          	sw	s4,8(sp)
80003854:	01512223          	sw	s5,4(sp)
80003858:	1f440413          	addi	s0,s0,500
	__ASSERT(!z_is_in_isr(), "");
8000385c:	02078e63          	beqz	a5,80003898 <z_impl_k_yield+0x68>
80003860:	800064b7          	lui	s1,0x80006
80003864:	800065b7          	lui	a1,0x80006
80003868:	80006537          	lui	a0,0x80006
8000386c:	b8458593          	addi	a1,a1,-1148 # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
80003870:	37e00693          	li	a3,894
80003874:	bf048613          	addi	a2,s1,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80003878:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
8000387c:	eb9fd0ef          	jal	ra,80001734 <printk>
80003880:	80006537          	lui	a0,0x80006
80003884:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80003888:	eadfd0ef          	jal	ra,80001734 <printk>
8000388c:	37e00593          	li	a1,894
80003890:	bf048513          	addi	a0,s1,-1040
80003894:	eddfd0ef          	jal	ra,80001770 <assert_post_action>
	return thread == _idle_thread;
80003898:	800067b7          	lui	a5,0x80006

	if (!is_idle(_current)) {
8000389c:	00842683          	lw	a3,8(s0)
800038a0:	ef07a703          	lw	a4,-272(a5) # 80005ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef1>
800038a4:	00078a13          	mv	s4,a5
800038a8:	12e68663          	beq	a3,a4,800039d4 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800038ac:	00800913          	li	s2,8
800038b0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800038b4:	800069b7          	lui	s3,0x80006
800038b8:	f6498513          	addi	a0,s3,-156 # 80005f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f65>
	key = (mstatus & SOC_MSTATUS_IEN);
800038bc:	00897913          	andi	s2,s2,8
800038c0:	0ad000ef          	jal	ra,8000416c <z_spin_lock_valid>
800038c4:	02051e63          	bnez	a0,80003900 <z_impl_k_yield+0xd0>
800038c8:	800064b7          	lui	s1,0x80006
800038cc:	800065b7          	lui	a1,0x80006
800038d0:	80006537          	lui	a0,0x80006
800038d4:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800038d8:	04e00693          	li	a3,78
800038dc:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800038e0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800038e4:	e51fd0ef          	jal	ra,80001734 <printk>
800038e8:	80006537          	lui	a0,0x80006
800038ec:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
800038f0:	e45fd0ef          	jal	ra,80001734 <printk>
800038f4:	04e00593          	li	a1,78
800038f8:	97c48513          	addi	a0,s1,-1668
800038fc:	e75fd0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80003900:	f6498513          	addi	a0,s3,-156
80003904:	0c1000ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80003908:	00842583          	lw	a1,8(s0)
8000390c:	02440513          	addi	a0,s0,36
80003910:	fc9fe0ef          	jal	ra,800028d8 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80003914:	ef0a2783          	lw	a5,-272(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80003918:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
8000391c:	80006a37          	lui	s4,0x80006
80003920:	218a0a13          	addi	s4,s4,536 # 80006218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006219>
	__ASSERT_NO_MSG(!is_idle(thread));
80003924:	02f49863          	bne	s1,a5,80003954 <z_impl_k_yield+0x124>
80003928:	80006ab7          	lui	s5,0x80006
8000392c:	800065b7          	lui	a1,0x80006
80003930:	80006537          	lui	a0,0x80006
80003934:	d0858593          	addi	a1,a1,-760 # 80005d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d09>
80003938:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
8000393c:	27600693          	li	a3,630
80003940:	bf0a8613          	addi	a2,s5,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80003944:	df1fd0ef          	jal	ra,80001734 <printk>
80003948:	27600593          	li	a1,630
8000394c:	bf0a8513          	addi	a0,s5,-1040
80003950:	e21fd0ef          	jal	ra,80001770 <assert_post_action>
	return list->head == list;
80003954:	02442783          	lw	a5,36(s0)
80003958:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000395c:	0b478a63          	beq	a5,s4,80003a10 <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003960:	0a078863          	beqz	a5,80003a10 <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
80003964:	00e48683          	lb	a3,14(s1)
80003968:	00e78603          	lb	a2,14(a5)
8000396c:	08c6dc63          	bge	a3,a2,80003a04 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
80003970:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003974:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
80003978:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
8000397c:	00972023          	sw	s1,0(a4)
	successor->prev = node;
80003980:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80003984:	00100513          	li	a0,1
80003988:	fddfe0ef          	jal	ra,80002964 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000398c:	f6498513          	addi	a0,s3,-156
80003990:	005000ef          	jal	ra,80004194 <z_spin_unlock_valid>
80003994:	02051e63          	bnez	a0,800039d0 <z_impl_k_yield+0x1a0>
80003998:	80006437          	lui	s0,0x80006
8000399c:	800065b7          	lui	a1,0x80006
800039a0:	80006537          	lui	a0,0x80006
800039a4:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
800039a8:	06100693          	li	a3,97
800039ac:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
800039b0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800039b4:	d81fd0ef          	jal	ra,80001734 <printk>
800039b8:	80006537          	lui	a0,0x80006
800039bc:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
800039c0:	d75fd0ef          	jal	ra,80001734 <printk>
800039c4:	06100593          	li	a1,97
800039c8:	97c40513          	addi	a0,s0,-1668
800039cc:	da5fd0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800039d0:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
800039d4:	00800513          	li	a0,8
800039d8:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
800039dc:	01812403          	lw	s0,24(sp)
800039e0:	01c12083          	lw	ra,28(sp)
800039e4:	01412483          	lw	s1,20(sp)
800039e8:	01012903          	lw	s2,16(sp)
800039ec:	00c12983          	lw	s3,12(sp)
800039f0:	00812a03          	lw	s4,8(sp)
800039f4:	00412a83          	lw	s5,4(sp)
800039f8:	00857513          	andi	a0,a0,8
800039fc:	02010113          	addi	sp,sp,32
80003a00:	839fc06f          	j	80000238 <__swap>
	return (node == list->tail) ? NULL : node->next;
80003a04:	00e78663          	beq	a5,a4,80003a10 <z_impl_k_yield+0x1e0>
80003a08:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003a0c:	f4079ee3          	bnez	a5,80003968 <z_impl_k_yield+0x138>
	node->prev = list->tail;
80003a10:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
80003a14:	02842783          	lw	a5,40(s0)
	node->next = list;
80003a18:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
80003a1c:	0097a023          	sw	s1,0(a5)
	list->tail = node;
80003a20:	02942423          	sw	s1,40(s0)
80003a24:	f61ff06f          	j	80003984 <z_impl_k_yield+0x154>

80003a28 <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
80003a28:	fd010113          	addi	sp,sp,-48
80003a2c:	02912223          	sw	s1,36(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
80003a30:	800064b7          	lui	s1,0x80006
80003a34:	1f44a783          	lw	a5,500(s1) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
{
80003a38:	02812423          	sw	s0,40(sp)
80003a3c:	02112623          	sw	ra,44(sp)
80003a40:	03212023          	sw	s2,32(sp)
80003a44:	01312e23          	sw	s3,28(sp)
80003a48:	01412c23          	sw	s4,24(sp)
80003a4c:	00050413          	mv	s0,a0
80003a50:	1f448493          	addi	s1,s1,500
	__ASSERT(!z_is_in_isr(), "");
80003a54:	02078e63          	beqz	a5,80003a90 <z_impl_k_sleep+0x68>
80003a58:	80006937          	lui	s2,0x80006
80003a5c:	800065b7          	lui	a1,0x80006
80003a60:	80006537          	lui	a0,0x80006
80003a64:	b8458593          	addi	a1,a1,-1148 # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
80003a68:	39900693          	li	a3,921
80003a6c:	bf090613          	addi	a2,s2,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80003a70:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003a74:	cc1fd0ef          	jal	ra,80001734 <printk>
80003a78:	80006537          	lui	a0,0x80006
80003a7c:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80003a80:	cb5fd0ef          	jal	ra,80001734 <printk>
80003a84:	39900593          	li	a1,921
80003a88:	bf090513          	addi	a0,s2,-1040
80003a8c:	ce5fd0ef          	jal	ra,80001770 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
80003a90:	fff00793          	li	a5,-1
80003a94:	1af41263          	bne	s0,a5,80003c38 <z_impl_k_sleep+0x210>
80003a98:	80006937          	lui	s2,0x80006
80003a9c:	800065b7          	lui	a1,0x80006
80003aa0:	80006537          	lui	a0,0x80006
80003aa4:	c3c58593          	addi	a1,a1,-964 # 80005c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c3d>
80003aa8:	39a00693          	li	a3,922
80003aac:	bf090613          	addi	a2,s2,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80003ab0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003ab4:	c81fd0ef          	jal	ra,80001734 <printk>
80003ab8:	80006537          	lui	a0,0x80006
80003abc:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80003ac0:	c75fd0ef          	jal	ra,80001734 <printk>
80003ac4:	39a00593          	li	a1,922
80003ac8:	bf090513          	addi	a0,s2,-1040
80003acc:	ca5fd0ef          	jal	ra,80001770 <assert_post_action>
80003ad0:	00a00793          	li	a5,10
80003ad4:	00940413          	addi	s0,s0,9
80003ad8:	02f44433          	div	s0,s0,a5
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
	expected_wakeup_time = ticks + z_tick_get_32();
80003adc:	41c010ef          	jal	ra,80004ef8 <z_tick_get_32>
80003ae0:	00800993          	li	s3,8

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
80003ae4:	00012623          	sw	zero,12(sp)
	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80003ae8:	00140413          	addi	s0,s0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80003aec:	00a40933          	add	s2,s0,a0
80003af0:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003af4:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80003af8:	0089f993          	andi	s3,s3,8
80003afc:	670000ef          	jal	ra,8000416c <z_spin_lock_valid>
80003b00:	02051e63          	bnez	a0,80003b3c <z_impl_k_sleep+0x114>
80003b04:	80006a37          	lui	s4,0x80006
80003b08:	800065b7          	lui	a1,0x80006
80003b0c:	80006537          	lui	a0,0x80006
80003b10:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80003b14:	04e00693          	li	a3,78
80003b18:	97ca0613          	addi	a2,s4,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003b1c:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003b20:	c15fd0ef          	jal	ra,80001734 <printk>
80003b24:	80006537          	lui	a0,0x80006
80003b28:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80003b2c:	c09fd0ef          	jal	ra,80001734 <printk>
80003b30:	04e00593          	li	a1,78
80003b34:	97ca0513          	addi	a0,s4,-1668
80003b38:	c39fd0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b3c:	00c10513          	addi	a0,sp,12
80003b40:	684000ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
80003b44:	0084a503          	lw	a0,8(s1)
80003b48:	d6cff0ef          	jal	ra,800030b4 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003b4c:	0084a503          	lw	a0,8(s1)
80003b50:	800035b7          	lui	a1,0x80003
80003b54:	00040613          	mv	a2,s0
80003b58:	01850513          	addi	a0,a0,24
80003b5c:	d3c58593          	addi	a1,a1,-708 # 80002d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002d3d>
80003b60:	335000ef          	jal	ra,80004694 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
80003b64:	0084a703          	lw	a4,8(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b68:	00c10513          	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
80003b6c:	00d74783          	lbu	a5,13(a4)
80003b70:	0107e793          	ori	a5,a5,16
80003b74:	00f706a3          	sb	a5,13(a4)
80003b78:	61c000ef          	jal	ra,80004194 <z_spin_unlock_valid>
80003b7c:	02051e63          	bnez	a0,80003bb8 <z_impl_k_sleep+0x190>
80003b80:	80006437          	lui	s0,0x80006
80003b84:	800065b7          	lui	a1,0x80006
80003b88:	80006537          	lui	a0,0x80006
80003b8c:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80003b90:	07800693          	li	a3,120
80003b94:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003b98:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003b9c:	b99fd0ef          	jal	ra,80001734 <printk>
80003ba0:	80006537          	lui	a0,0x80006
80003ba4:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80003ba8:	b8dfd0ef          	jal	ra,80001734 <printk>
80003bac:	07800593          	li	a1,120
80003bb0:	97c40513          	addi	a0,s0,-1668
80003bb4:	bbdfd0ef          	jal	ra,80001770 <assert_post_action>
80003bb8:	00098513          	mv	a0,s3
80003bbc:	e7cfc0ef          	jal	ra,80000238 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
80003bc0:	0084a783          	lw	a5,8(s1)
80003bc4:	00d7c783          	lbu	a5,13(a5)
80003bc8:	0107f793          	andi	a5,a5,16
80003bcc:	02078e63          	beqz	a5,80003c08 <z_impl_k_sleep+0x1e0>
80003bd0:	80006437          	lui	s0,0x80006
80003bd4:	800065b7          	lui	a1,0x80006
80003bd8:	80006537          	lui	a0,0x80006
80003bdc:	c5058593          	addi	a1,a1,-944 # 80005c50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c51>
80003be0:	3b700693          	li	a3,951
80003be4:	bf040613          	addi	a2,s0,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
80003be8:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003bec:	b49fd0ef          	jal	ra,80001734 <printk>
80003bf0:	80006537          	lui	a0,0x80006
80003bf4:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80003bf8:	b3dfd0ef          	jal	ra,80001734 <printk>
80003bfc:	3b700593          	li	a1,951
80003c00:	bf040513          	addi	a0,s0,-1040
80003c04:	b6dfd0ef          	jal	ra,80001770 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
80003c08:	2f0010ef          	jal	ra,80004ef8 <z_tick_get_32>
80003c0c:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
80003c10:	00000413          	li	s0,0
	if (ticks > 0) {
80003c14:	02a05663          	blez	a0,80003c40 <z_impl_k_sleep+0x218>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80003c18:	3e800793          	li	a5,1000
80003c1c:	02f515b3          	mulh	a1,a0,a5
80003c20:	06400613          	li	a2,100
80003c24:	00000693          	li	a3,0
80003c28:	02f50533          	mul	a0,a0,a5
80003c2c:	e94fc0ef          	jal	ra,800002c0 <__udivdi3>
80003c30:	00050413          	mv	s0,a0
		return __ticks_to_ms(ticks);
80003c34:	00c0006f          	j	80003c40 <z_impl_k_sleep+0x218>
	if (duration == 0) {
80003c38:	e8041ce3          	bnez	s0,80003ad0 <z_impl_k_sleep+0xa8>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80003c3c:	bf5ff0ef          	jal	ra,80003830 <z_impl_k_yield>
}
80003c40:	00040513          	mv	a0,s0
80003c44:	02c12083          	lw	ra,44(sp)
80003c48:	02812403          	lw	s0,40(sp)
80003c4c:	02412483          	lw	s1,36(sp)
80003c50:	02012903          	lw	s2,32(sp)
80003c54:	01c12983          	lw	s3,28(sp)
80003c58:	01812a03          	lw	s4,24(sp)
80003c5c:	03010113          	addi	sp,sp,48
80003c60:	00008067          	ret

80003c64 <z_impl_k_wakeup>:
}
#endif

void z_impl_k_wakeup(k_tid_t thread)
{
	if (z_is_thread_pending(thread)) {
80003c64:	00d54783          	lbu	a5,13(a0)
80003c68:	0027f793          	andi	a5,a5,2
80003c6c:	06079663          	bnez	a5,80003cd8 <z_impl_k_wakeup+0x74>
{
80003c70:	ff010113          	addi	sp,sp,-16
80003c74:	00812423          	sw	s0,8(sp)
80003c78:	00050413          	mv	s0,a0
	return z_abort_timeout(&thread->base.timeout);
80003c7c:	01850513          	addi	a0,a0,24
80003c80:	00112623          	sw	ra,12(sp)
80003c84:	43d000ef          	jal	ra,800048c0 <z_abort_timeout>
		return;
	}

	if (z_abort_thread_timeout(thread) < 0) {
80003c88:	04054063          	bltz	a0,80003cc8 <z_impl_k_wakeup+0x64>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003c8c:	00d44783          	lbu	a5,13(s0)
	if (z_is_thread_ready(thread)) {
80003c90:	00040513          	mv	a0,s0
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003c94:	fef7f793          	andi	a5,a5,-17
80003c98:	00f406a3          	sb	a5,13(s0)
	if (z_is_thread_ready(thread)) {
80003c9c:	f04fe0ef          	jal	ra,800023a0 <z_is_thread_ready>
80003ca0:	00050663          	beqz	a0,80003cac <z_impl_k_wakeup+0x48>
		z_add_thread_to_ready_q(thread);
80003ca4:	00040513          	mv	a0,s0
80003ca8:	f05fe0ef          	jal	ra,80002bac <z_add_thread_to_ready_q>
	}

	z_mark_thread_as_not_suspended(thread);
	z_ready_thread(thread);

	if (!z_is_in_isr()) {
80003cac:	800067b7          	lui	a5,0x80006
80003cb0:	1f47a783          	lw	a5,500(a5) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
80003cb4:	00079a63          	bnez	a5,80003cc8 <z_impl_k_wakeup+0x64>

	if (IS_ENABLED(CONFIG_SMP) &&
	    !IS_ENABLED(CONFIG_SCHED_IPI_SUPPORTED)) {
		z_sched_ipi();
	}
}
80003cb8:	00812403          	lw	s0,8(sp)
80003cbc:	00c12083          	lw	ra,12(sp)
80003cc0:	01010113          	addi	sp,sp,16
		z_reschedule_unlocked();
80003cc4:	a8dfe06f          	j	80002750 <z_reschedule_unlocked>
}
80003cc8:	00c12083          	lw	ra,12(sp)
80003ccc:	00812403          	lw	s0,8(sp)
80003cd0:	01010113          	addi	sp,sp,16
80003cd4:	00008067          	ret
80003cd8:	00008067          	ret

80003cdc <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80003cdc:	800067b7          	lui	a5,0x80006
80003ce0:	1fc7a503          	lw	a0,508(a5) # 800061fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061fd>
80003ce4:	00008067          	ret

80003ce8 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80003ce8:	fe010113          	addi	sp,sp,-32
80003cec:	00812c23          	sw	s0,24(sp)
80003cf0:	00912a23          	sw	s1,20(sp)
80003cf4:	01212823          	sw	s2,16(sp)
80003cf8:	00112e23          	sw	ra,28(sp)
80003cfc:	01312623          	sw	s3,12(sp)
80003d00:	00050413          	mv	s0,a0
80003d04:	00058913          	mv	s2,a1
80003d08:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80003d0c:	02061e63          	bnez	a2,80003d48 <z_impl_k_sem_init+0x60>
80003d10:	800069b7          	lui	s3,0x80006
80003d14:	800065b7          	lui	a1,0x80006
80003d18:	80006537          	lui	a0,0x80006
80003d1c:	d2c58593          	addi	a1,a1,-724 # 80005d2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d2d>
80003d20:	04600693          	li	a3,70
80003d24:	d1c98613          	addi	a2,s3,-740 # 80005d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d1d>
80003d28:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003d2c:	a09fd0ef          	jal	ra,80001734 <printk>
80003d30:	80006537          	lui	a0,0x80006
80003d34:	d3850513          	addi	a0,a0,-712 # 80005d38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d39>
80003d38:	9fdfd0ef          	jal	ra,80001734 <printk>
80003d3c:	04600593          	li	a1,70
80003d40:	d1c98513          	addi	a0,s3,-740
80003d44:	a2dfd0ef          	jal	ra,80001770 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003d48:	0324fe63          	bgeu	s1,s2,80003d84 <z_impl_k_sem_init+0x9c>
80003d4c:	800069b7          	lui	s3,0x80006
80003d50:	800065b7          	lui	a1,0x80006
80003d54:	80006537          	lui	a0,0x80006
80003d58:	d5058593          	addi	a1,a1,-688 # 80005d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d51>
80003d5c:	04700693          	li	a3,71
80003d60:	d1c98613          	addi	a2,s3,-740 # 80005d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d1d>
80003d64:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003d68:	9cdfd0ef          	jal	ra,80001734 <printk>
80003d6c:	80006537          	lui	a0,0x80006
80003d70:	d6850513          	addi	a0,a0,-664 # 80005d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d69>
80003d74:	9c1fd0ef          	jal	ra,80001734 <printk>
80003d78:	04700593          	li	a1,71
80003d7c:	d1c98513          	addi	a0,s3,-740
80003d80:	9f1fd0ef          	jal	ra,80001770 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80003d84:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80003d88:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80003d8c:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80003d90:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80003d94:	01c12083          	lw	ra,28(sp)
80003d98:	01812403          	lw	s0,24(sp)
80003d9c:	01412483          	lw	s1,20(sp)
80003da0:	01012903          	lw	s2,16(sp)
80003da4:	00c12983          	lw	s3,12(sp)
80003da8:	02010113          	addi	sp,sp,32
80003dac:	00008067          	ret

80003db0 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80003db0:	fe010113          	addi	sp,sp,-32
80003db4:	00912a23          	sw	s1,20(sp)
80003db8:	01312623          	sw	s3,12(sp)
80003dbc:	00112e23          	sw	ra,28(sp)
80003dc0:	00812c23          	sw	s0,24(sp)
80003dc4:	01212823          	sw	s2,16(sp)
80003dc8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003dcc:	00800493          	li	s1,8
80003dd0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003dd4:	80006437          	lui	s0,0x80006
80003dd8:	f7040513          	addi	a0,s0,-144 # 80005f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f71>
	key = (mstatus & SOC_MSTATUS_IEN);
80003ddc:	0084f493          	andi	s1,s1,8
80003de0:	38c000ef          	jal	ra,8000416c <z_spin_lock_valid>
80003de4:	02051e63          	bnez	a0,80003e20 <z_impl_k_sem_give+0x70>
80003de8:	80006937          	lui	s2,0x80006
80003dec:	800065b7          	lui	a1,0x80006
80003df0:	80006537          	lui	a0,0x80006
80003df4:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80003df8:	04e00693          	li	a3,78
80003dfc:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003e00:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003e04:	931fd0ef          	jal	ra,80001734 <printk>
80003e08:	80006537          	lui	a0,0x80006
80003e0c:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80003e10:	925fd0ef          	jal	ra,80001734 <printk>
80003e14:	04e00593          	li	a1,78
80003e18:	97c90513          	addi	a0,s2,-1668
80003e1c:	955fd0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80003e20:	f7040513          	addi	a0,s0,-144
80003e24:	3a0000ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80003e28:	00098513          	mv	a0,s3
80003e2c:	f5cff0ef          	jal	ra,80003588 <z_unpend_first_thread>
80003e30:	00050913          	mv	s2,a0
	if (thread != NULL) {
80003e34:	04050263          	beqz	a0,80003e78 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003e38:	00d54783          	lbu	a5,13(a0)
80003e3c:	01f7f793          	andi	a5,a5,31
80003e40:	00079863          	bnez	a5,80003e50 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80003e44:	01852783          	lw	a5,24(a0)
80003e48:	00079463          	bnez	a5,80003e50 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80003e4c:	d61fe0ef          	jal	ra,80002bac <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80003e50:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80003e54:	f7040513          	addi	a0,s0,-144
}
80003e58:	01812403          	lw	s0,24(sp)
80003e5c:	01c12083          	lw	ra,28(sp)
80003e60:	01012903          	lw	s2,16(sp)
80003e64:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003e68:	00048593          	mv	a1,s1
}
80003e6c:	01412483          	lw	s1,20(sp)
80003e70:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80003e74:	fecfe06f          	j	80002660 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80003e78:	0089a703          	lw	a4,8(s3)
80003e7c:	00c9a783          	lw	a5,12(s3)
80003e80:	40e787b3          	sub	a5,a5,a4
80003e84:	00f037b3          	snez	a5,a5
80003e88:	00e787b3          	add	a5,a5,a4
80003e8c:	00f9a423          	sw	a5,8(s3)
80003e90:	fc5ff06f          	j	80003e54 <z_impl_k_sem_give+0xa4>

80003e94 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003e94:	800067b7          	lui	a5,0x80006
80003e98:	1f47a783          	lw	a5,500(a5) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
{
80003e9c:	fe010113          	addi	sp,sp,-32
80003ea0:	01212823          	sw	s2,16(sp)
80003ea4:	01312623          	sw	s3,12(sp)
80003ea8:	00112e23          	sw	ra,28(sp)
80003eac:	00812c23          	sw	s0,24(sp)
80003eb0:	00912a23          	sw	s1,20(sp)
80003eb4:	01412423          	sw	s4,8(sp)
80003eb8:	00050913          	mv	s2,a0
80003ebc:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003ec0:	04078063          	beqz	a5,80003f00 <z_impl_k_sem_take+0x6c>
80003ec4:	02058e63          	beqz	a1,80003f00 <z_impl_k_sem_take+0x6c>
80003ec8:	80006437          	lui	s0,0x80006
80003ecc:	800065b7          	lui	a1,0x80006
80003ed0:	80006537          	lui	a0,0x80006
80003ed4:	d9058593          	addi	a1,a1,-624 # 80005d90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d91>
80003ed8:	08c00693          	li	a3,140
80003edc:	d1c40613          	addi	a2,s0,-740 # 80005d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d1d>
80003ee0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003ee4:	851fd0ef          	jal	ra,80001734 <printk>
80003ee8:	80006537          	lui	a0,0x80006
80003eec:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
80003ef0:	845fd0ef          	jal	ra,80001734 <printk>
80003ef4:	08c00593          	li	a1,140
80003ef8:	d1c40513          	addi	a0,s0,-740
80003efc:	875fd0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f00:	00800413          	li	s0,8
80003f04:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f08:	800064b7          	lui	s1,0x80006
80003f0c:	f7048513          	addi	a0,s1,-144 # 80005f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f71>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f10:	00847413          	andi	s0,s0,8
80003f14:	258000ef          	jal	ra,8000416c <z_spin_lock_valid>
80003f18:	02051e63          	bnez	a0,80003f54 <z_impl_k_sem_take+0xc0>
80003f1c:	80006a37          	lui	s4,0x80006
80003f20:	800065b7          	lui	a1,0x80006
80003f24:	80006537          	lui	a0,0x80006
80003f28:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80003f2c:	04e00693          	li	a3,78
80003f30:	97ca0613          	addi	a2,s4,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003f34:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003f38:	ffcfd0ef          	jal	ra,80001734 <printk>
80003f3c:	80006537          	lui	a0,0x80006
80003f40:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80003f44:	ff0fd0ef          	jal	ra,80001734 <printk>
80003f48:	04e00593          	li	a1,78
80003f4c:	97ca0513          	addi	a0,s4,-1668
80003f50:	821fd0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80003f54:	f7048513          	addi	a0,s1,-144
80003f58:	26c000ef          	jal	ra,800041c4 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80003f5c:	00892783          	lw	a5,8(s2)
80003f60:	06078c63          	beqz	a5,80003fd8 <z_impl_k_sem_take+0x144>
		sem->count--;
80003f64:	fff78793          	addi	a5,a5,-1
80003f68:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f6c:	f7048513          	addi	a0,s1,-144
80003f70:	224000ef          	jal	ra,80004194 <z_spin_unlock_valid>
80003f74:	02051e63          	bnez	a0,80003fb0 <z_impl_k_sem_take+0x11c>
80003f78:	800064b7          	lui	s1,0x80006
80003f7c:	800065b7          	lui	a1,0x80006
80003f80:	80006537          	lui	a0,0x80006
80003f84:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80003f88:	06100693          	li	a3,97
80003f8c:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80003f90:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80003f94:	fa0fd0ef          	jal	ra,80001734 <printk>
80003f98:	80006537          	lui	a0,0x80006
80003f9c:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80003fa0:	f94fd0ef          	jal	ra,80001734 <printk>
80003fa4:	06100593          	li	a1,97
80003fa8:	97c48513          	addi	a0,s1,-1668
80003fac:	fc4fd0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003fb0:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80003fb4:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80003fb8:	01c12083          	lw	ra,28(sp)
80003fbc:	01812403          	lw	s0,24(sp)
80003fc0:	01412483          	lw	s1,20(sp)
80003fc4:	01012903          	lw	s2,16(sp)
80003fc8:	00c12983          	lw	s3,12(sp)
80003fcc:	00812a03          	lw	s4,8(sp)
80003fd0:	02010113          	addi	sp,sp,32
80003fd4:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80003fd8:	04099a63          	bnez	s3,8000402c <z_impl_k_sem_take+0x198>
80003fdc:	f7048513          	addi	a0,s1,-144
80003fe0:	1b4000ef          	jal	ra,80004194 <z_spin_unlock_valid>
80003fe4:	02051e63          	bnez	a0,80004020 <z_impl_k_sem_take+0x18c>
80003fe8:	800064b7          	lui	s1,0x80006
80003fec:	800065b7          	lui	a1,0x80006
80003ff0:	80006537          	lui	a0,0x80006
80003ff4:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80003ff8:	06100693          	li	a3,97
80003ffc:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004000:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004004:	f30fd0ef          	jal	ra,80001734 <printk>
80004008:	80006537          	lui	a0,0x80006
8000400c:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004010:	f24fd0ef          	jal	ra,80001734 <printk>
80004014:	06100593          	li	a1,97
80004018:	97c48513          	addi	a0,s1,-1668
8000401c:	f54fd0ef          	jal	ra,80001770 <assert_post_action>
80004020:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80004024:	ff000513          	li	a0,-16
80004028:	f91ff06f          	j	80003fb8 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000402c:	00040593          	mv	a1,s0
}
80004030:	01812403          	lw	s0,24(sp)
80004034:	01c12083          	lw	ra,28(sp)
80004038:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000403c:	00098693          	mv	a3,s3
80004040:	00090613          	mv	a2,s2
}
80004044:	00c12983          	lw	s3,12(sp)
80004048:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000404c:	f7048513          	addi	a0,s1,-144
}
80004050:	01412483          	lw	s1,20(sp)
80004054:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004058:	a9cff06f          	j	800032f4 <z_pend_curr>

8000405c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000405c:	00d54783          	lbu	a5,13(a0)
80004060:	01f7f793          	andi	a5,a5,31
80004064:	00079863          	bnez	a5,80004074 <z_is_thread_ready+0x18>
80004068:	01852503          	lw	a0,24(a0)
8000406c:	00153513          	seqz	a0,a0
80004070:	00008067          	ret
80004074:	00000513          	li	a0,0
}
80004078:	00008067          	ret

8000407c <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
8000407c:	800067b7          	lui	a5,0x80006
80004080:	1f47a503          	lw	a0,500(a5) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
}
80004084:	00a03533          	snez	a0,a0
80004088:	00008067          	ret

8000408c <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
8000408c:	800067b7          	lui	a5,0x80006
80004090:	1fc7a783          	lw	a5,508(a5) # 800061fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061fd>
80004094:	00c7c503          	lbu	a0,12(a5)
}
80004098:	00157513          	andi	a0,a0,1
8000409c:	00008067          	ret

800040a0 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
800040a0:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800040a4:	02012303          	lw	t1,32(sp)
{
800040a8:	00812c23          	sw	s0,24(sp)
800040ac:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800040b0:	00612023          	sw	t1,0(sp)
{
800040b4:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800040b8:	d85fc0ef          	jal	ra,80000e3c <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
800040bc:	800067b7          	lui	a5,0x80006
800040c0:	1fc7a783          	lw	a5,508(a5) # 800061fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061fd>
	sys_trace_thread_create(new_thread);
}
800040c4:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
800040c8:	0687a783          	lw	a5,104(a5)
800040cc:	06f42423          	sw	a5,104(s0)
}
800040d0:	01812403          	lw	s0,24(sp)
800040d4:	02010113          	addi	sp,sp,32
800040d8:	00008067          	ret

800040dc <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
800040dc:	06052783          	lw	a5,96(a0)
{
800040e0:	ff010113          	addi	sp,sp,-16
800040e4:	00812423          	sw	s0,8(sp)
800040e8:	00112623          	sw	ra,12(sp)
800040ec:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
800040f0:	00078463          	beqz	a5,800040f8 <z_thread_single_abort+0x1c>
		thread->fn_abort();
800040f4:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
800040f8:	00040513          	mv	a0,s0
800040fc:	f61ff0ef          	jal	ra,8000405c <z_is_thread_ready>
80004100:	02050463          	beqz	a0,80004128 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80004104:	00040513          	mv	a0,s0
80004108:	fadfe0ef          	jal	ra,800030b4 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
8000410c:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004110:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004114:	0087e793          	ori	a5,a5,8
80004118:	00f406a3          	sb	a5,13(s0)
}
8000411c:	00812403          	lw	s0,8(sp)
80004120:	01010113          	addi	sp,sp,16
80004124:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004128:	00d44783          	lbu	a5,13(s0)
8000412c:	0027f793          	andi	a5,a5,2
80004130:	00078663          	beqz	a5,8000413c <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80004134:	00040513          	mv	a0,s0
80004138:	c2cfe0ef          	jal	ra,80002564 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
8000413c:	01842783          	lw	a5,24(s0)
80004140:	fc0786e3          	beqz	a5,8000410c <z_thread_single_abort+0x30>
80004144:	01840513          	addi	a0,s0,24
80004148:	778000ef          	jal	ra,800048c0 <z_abort_timeout>
8000414c:	fc1ff06f          	j	8000410c <z_thread_single_abort+0x30>

80004150 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80004150:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80004154:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004158:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
8000415c:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004160:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80004164:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004168:	00008067          	ret

8000416c <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
8000416c:	00052503          	lw	a0,0(a0)
80004170:	00050e63          	beqz	a0,8000418c <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80004174:	800067b7          	lui	a5,0x80006
80004178:	2087c783          	lbu	a5,520(a5) # 80006208 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006209>
8000417c:	00357513          	andi	a0,a0,3
80004180:	40f50533          	sub	a0,a0,a5
80004184:	00a03533          	snez	a0,a0
80004188:	00008067          	ret
			return false;
		}
	}
	return true;
8000418c:	00100513          	li	a0,1
}
80004190:	00008067          	ret

80004194 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80004194:	800067b7          	lui	a5,0x80006
80004198:	1f478793          	addi	a5,a5,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
8000419c:	0147c703          	lbu	a4,20(a5)
800041a0:	0087a783          	lw	a5,8(a5)
800041a4:	00e7e7b3          	or	a5,a5,a4
800041a8:	00052703          	lw	a4,0(a0)
800041ac:	00f71863          	bne	a4,a5,800041bc <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
800041b0:	00052023          	sw	zero,0(a0)
	return true;
800041b4:	00100513          	li	a0,1
800041b8:	00008067          	ret
		return false;
800041bc:	00000513          	li	a0,0
}
800041c0:	00008067          	ret

800041c4 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
800041c4:	800067b7          	lui	a5,0x80006
800041c8:	1f478793          	addi	a5,a5,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
800041cc:	0147c703          	lbu	a4,20(a5)
800041d0:	0087a783          	lw	a5,8(a5)
800041d4:	00e7e7b3          	or	a5,a5,a4
800041d8:	00f52023          	sw	a5,0(a0)
}
800041dc:	00008067          	ret

800041e0 <z_impl_k_thread_start>:
{
800041e0:	fe010113          	addi	sp,sp,-32
800041e4:	00812c23          	sw	s0,24(sp)
800041e8:	01212823          	sw	s2,16(sp)
800041ec:	00112e23          	sw	ra,28(sp)
800041f0:	00912a23          	sw	s1,20(sp)
800041f4:	01312623          	sw	s3,12(sp)
800041f8:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800041fc:	00800413          	li	s0,8
80004200:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004204:	800064b7          	lui	s1,0x80006
80004208:	f7448513          	addi	a0,s1,-140 # 80005f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f75>
	key = (mstatus & SOC_MSTATUS_IEN);
8000420c:	00847413          	andi	s0,s0,8
80004210:	f5dff0ef          	jal	ra,8000416c <z_spin_lock_valid>
80004214:	02051e63          	bnez	a0,80004250 <z_impl_k_thread_start+0x70>
80004218:	800069b7          	lui	s3,0x80006
8000421c:	800065b7          	lui	a1,0x80006
80004220:	80006537          	lui	a0,0x80006
80004224:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80004228:	04e00693          	li	a3,78
8000422c:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004230:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004234:	d00fd0ef          	jal	ra,80001734 <printk>
80004238:	80006537          	lui	a0,0x80006
8000423c:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80004240:	cf4fd0ef          	jal	ra,80001734 <printk>
80004244:	04e00593          	li	a1,78
80004248:	97c98513          	addi	a0,s3,-1668
8000424c:	d24fd0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80004250:	f7448513          	addi	a0,s1,-140
80004254:	f71ff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004258:	00d94783          	lbu	a5,13(s2)
8000425c:	0047f713          	andi	a4,a5,4
80004260:	06071463          	bnez	a4,800042c8 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004264:	f7448513          	addi	a0,s1,-140
80004268:	f2dff0ef          	jal	ra,80004194 <z_spin_unlock_valid>
8000426c:	02051e63          	bnez	a0,800042a8 <z_impl_k_thread_start+0xc8>
80004270:	800064b7          	lui	s1,0x80006
80004274:	800065b7          	lui	a1,0x80006
80004278:	80006537          	lui	a0,0x80006
8000427c:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80004280:	06100693          	li	a3,97
80004284:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004288:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
8000428c:	ca8fd0ef          	jal	ra,80001734 <printk>
80004290:	80006537          	lui	a0,0x80006
80004294:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004298:	c9cfd0ef          	jal	ra,80001734 <printk>
8000429c:	06100593          	li	a1,97
800042a0:	97c48513          	addi	a0,s1,-1668
800042a4:	cccfd0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042a8:	30042473          	csrrs	s0,mstatus,s0
}
800042ac:	01c12083          	lw	ra,28(sp)
800042b0:	01812403          	lw	s0,24(sp)
800042b4:	01412483          	lw	s1,20(sp)
800042b8:	01012903          	lw	s2,16(sp)
800042bc:	00c12983          	lw	s3,12(sp)
800042c0:	02010113          	addi	sp,sp,32
800042c4:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
800042c8:	ffb7f793          	andi	a5,a5,-5
800042cc:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
800042d0:	00090513          	mv	a0,s2
800042d4:	d89ff0ef          	jal	ra,8000405c <z_is_thread_ready>
800042d8:	00050663          	beqz	a0,800042e4 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
800042dc:	00090513          	mv	a0,s2
800042e0:	8cdfe0ef          	jal	ra,80002bac <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
800042e4:	00040593          	mv	a1,s0
}
800042e8:	01812403          	lw	s0,24(sp)
800042ec:	01c12083          	lw	ra,28(sp)
800042f0:	01012903          	lw	s2,16(sp)
800042f4:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
800042f8:	f7448513          	addi	a0,s1,-140
}
800042fc:	01412483          	lw	s1,20(sp)
80004300:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004304:	b5cfe06f          	j	80002660 <z_reschedule>

80004308 <schedule_new_thread>:
	if (delay == 0) {
80004308:	00059463          	bnez	a1,80004310 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
8000430c:	ed5ff06f          	j	800041e0 <z_impl_k_thread_start>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80004310:	00958593          	addi	a1,a1,9
80004314:	00a00613          	li	a2,10
80004318:	02c5c633          	div	a2,a1,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
8000431c:	800035b7          	lui	a1,0x80003
80004320:	d3c58593          	addi	a1,a1,-708 # 80002d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002d3d>
80004324:	01850513          	addi	a0,a0,24
80004328:	00160613          	addi	a2,a2,1
8000432c:	3680006f          	j	80004694 <z_add_timeout>

80004330 <z_impl_k_thread_create>:
{
80004330:	fc010113          	addi	sp,sp,-64
80004334:	03512223          	sw	s5,36(sp)
80004338:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
8000433c:	800066b7          	lui	a3,0x80006
80004340:	1f46a683          	lw	a3,500(a3) # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
{
80004344:	02812c23          	sw	s0,56(sp)
80004348:	02912a23          	sw	s1,52(sp)
8000434c:	03312623          	sw	s3,44(sp)
80004350:	03412423          	sw	s4,40(sp)
80004354:	02112e23          	sw	ra,60(sp)
80004358:	03212823          	sw	s2,48(sp)
8000435c:	00050413          	mv	s0,a0
80004360:	00058993          	mv	s3,a1
80004364:	00060a13          	mv	s4,a2
80004368:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
8000436c:	04068e63          	beqz	a3,800043c8 <z_impl_k_thread_create+0x98>
80004370:	80006937          	lui	s2,0x80006
80004374:	800065b7          	lui	a1,0x80006
80004378:	80006537          	lui	a0,0x80006
8000437c:	1b200693          	li	a3,434
80004380:	dc490613          	addi	a2,s2,-572 # 80005dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dc5>
80004384:	b8458593          	addi	a1,a1,-1148 # 80005b84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b85>
80004388:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
8000438c:	01112e23          	sw	a7,28(sp)
80004390:	01012c23          	sw	a6,24(sp)
80004394:	00f12a23          	sw	a5,20(sp)
80004398:	00e12823          	sw	a4,16(sp)
8000439c:	b98fd0ef          	jal	ra,80001734 <printk>
800043a0:	80006537          	lui	a0,0x80006
800043a4:	dd850513          	addi	a0,a0,-552 # 80005dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd9>
800043a8:	b8cfd0ef          	jal	ra,80001734 <printk>
800043ac:	1b200593          	li	a1,434
800043b0:	dc490513          	addi	a0,s2,-572
800043b4:	bbcfd0ef          	jal	ra,80001770 <assert_post_action>
800043b8:	01c12883          	lw	a7,28(sp)
800043bc:	01812803          	lw	a6,24(sp)
800043c0:	01412783          	lw	a5,20(sp)
800043c4:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800043c8:	04012683          	lw	a3,64(sp)
800043cc:	00012223          	sw	zero,4(sp)
800043d0:	000a0613          	mv	a2,s4
800043d4:	00d12023          	sw	a3,0(sp)
800043d8:	00098593          	mv	a1,s3
800043dc:	000a8693          	mv	a3,s5
800043e0:	00040513          	mv	a0,s0
800043e4:	cbdff0ef          	jal	ra,800040a0 <z_setup_new_thread>
	if (delay != K_FOREVER) {
800043e8:	fff00793          	li	a5,-1
800043ec:	00f48863          	beq	s1,a5,800043fc <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
800043f0:	00048593          	mv	a1,s1
800043f4:	00040513          	mv	a0,s0
800043f8:	f11ff0ef          	jal	ra,80004308 <schedule_new_thread>
}
800043fc:	00040513          	mv	a0,s0
80004400:	03c12083          	lw	ra,60(sp)
80004404:	03812403          	lw	s0,56(sp)
80004408:	03412483          	lw	s1,52(sp)
8000440c:	03012903          	lw	s2,48(sp)
80004410:	02c12983          	lw	s3,44(sp)
80004414:	02812a03          	lw	s4,40(sp)
80004418:	02412a83          	lw	s5,36(sp)
8000441c:	04010113          	addi	sp,sp,64
80004420:	00008067          	ret

80004424 <z_init_static_threads>:
{
80004424:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004428:	800067b7          	lui	a5,0x80006
{
8000442c:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004430:	80006937          	lui	s2,0x80006
{
80004434:	00812c23          	sw	s0,24(sp)
80004438:	00912a23          	sw	s1,20(sp)
8000443c:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004440:	f2478413          	addi	s0,a5,-220 # 80005f24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f25>
80004444:	f2478493          	addi	s1,a5,-220
80004448:	f2490913          	addi	s2,s2,-220 # 80005f24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f25>
8000444c:	03246663          	bltu	s0,s2,80004478 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004450:	00048413          	mv	s0,s1
	k_sched_lock();
80004454:	b0cfe0ef          	jal	ra,80002760 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004458:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
8000445c:	07246063          	bltu	s0,s2,800044bc <z_init_static_threads+0x98>
}
80004460:	01812403          	lw	s0,24(sp)
80004464:	01c12083          	lw	ra,28(sp)
80004468:	01412483          	lw	s1,20(sp)
8000446c:	01012903          	lw	s2,16(sp)
80004470:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004474:	db8fe06f          	j	80002a2c <k_sched_unlock>
		z_setup_new_thread(
80004478:	02c42783          	lw	a5,44(s0)
8000447c:	00f12223          	sw	a5,4(sp)
80004480:	02042783          	lw	a5,32(s0)
80004484:	00f12023          	sw	a5,0(sp)
80004488:	01442783          	lw	a5,20(s0)
8000448c:	01c42883          	lw	a7,28(s0)
80004490:	01842803          	lw	a6,24(s0)
80004494:	01042703          	lw	a4,16(s0)
80004498:	00c42683          	lw	a3,12(s0)
8000449c:	00842603          	lw	a2,8(s0)
800044a0:	00442583          	lw	a1,4(s0)
800044a4:	00042503          	lw	a0,0(s0)
800044a8:	bf9ff0ef          	jal	ra,800040a0 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
800044ac:	00042783          	lw	a5,0(s0)
800044b0:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
800044b4:	03040413          	addi	s0,s0,48
800044b8:	f95ff06f          	j	8000444c <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
800044bc:	02442583          	lw	a1,36(s0)
800044c0:	00958663          	beq	a1,s1,800044cc <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
800044c4:	00042503          	lw	a0,0(s0)
800044c8:	e41ff0ef          	jal	ra,80004308 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
800044cc:	03040413          	addi	s0,s0,48
800044d0:	f8dff06f          	j	8000445c <z_init_static_threads+0x38>

800044d4 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
800044d4:	fe010113          	addi	sp,sp,-32
800044d8:	00812c23          	sw	s0,24(sp)
800044dc:	00912a23          	sw	s1,20(sp)
800044e0:	00112e23          	sw	ra,28(sp)
800044e4:	01212823          	sw	s2,16(sp)
800044e8:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
800044ec:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800044f0:	00800413          	li	s0,8
800044f4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800044f8:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800044fc:	00847413          	andi	s0,s0,8
80004500:	c6dff0ef          	jal	ra,8000416c <z_spin_lock_valid>
80004504:	02051e63          	bnez	a0,80004540 <z_impl_k_thread_abort+0x6c>
80004508:	80006937          	lui	s2,0x80006
8000450c:	800065b7          	lui	a1,0x80006
80004510:	80006537          	lui	a0,0x80006
80004514:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80004518:	04e00693          	li	a3,78
8000451c:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004520:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004524:	a10fd0ef          	jal	ra,80001734 <printk>
80004528:	80006537          	lui	a0,0x80006
8000452c:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80004530:	a04fd0ef          	jal	ra,80001734 <printk>
80004534:	04e00593          	li	a1,78
80004538:	97c90513          	addi	a0,s2,-1668
8000453c:	a34fd0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80004540:	00c10513          	addi	a0,sp,12
80004544:	c81ff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004548:	00c4c783          	lbu	a5,12(s1)
8000454c:	0017f793          	andi	a5,a5,1
80004550:	02078e63          	beqz	a5,8000458c <z_impl_k_thread_abort+0xb8>
80004554:	80006937          	lui	s2,0x80006
80004558:	800065b7          	lui	a1,0x80006
8000455c:	80006537          	lui	a0,0x80006
80004560:	e1858593          	addi	a1,a1,-488 # 80005e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e19>
80004564:	02900693          	li	a3,41
80004568:	e0090613          	addi	a2,s2,-512 # 80005e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e01>
8000456c:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004570:	9c4fd0ef          	jal	ra,80001734 <printk>
80004574:	80006537          	lui	a0,0x80006
80004578:	e4c50513          	addi	a0,a0,-436 # 80005e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e4d>
8000457c:	9b8fd0ef          	jal	ra,80001734 <printk>
80004580:	02900593          	li	a1,41
80004584:	e0090513          	addi	a0,s2,-512
80004588:	9e8fd0ef          	jal	ra,80001770 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
8000458c:	00048513          	mv	a0,s1
80004590:	b4dff0ef          	jal	ra,800040dc <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004594:	00040593          	mv	a1,s0
80004598:	00c10513          	addi	a0,sp,12
8000459c:	8c4fe0ef          	jal	ra,80002660 <z_reschedule>
}
800045a0:	01c12083          	lw	ra,28(sp)
800045a4:	01812403          	lw	s0,24(sp)
800045a8:	01412483          	lw	s1,20(sp)
800045ac:	01012903          	lw	s2,16(sp)
800045b0:	02010113          	addi	sp,sp,32
800045b4:	00008067          	ret

800045b8 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
800045b8:	800067b7          	lui	a5,0x80006
800045bc:	f787a783          	lw	a5,-136(a5) # 80005f78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f79>
800045c0:	00079463          	bnez	a5,800045c8 <elapsed+0x10>
800045c4:	dfcfd06f          	j	80001bc0 <z_clock_elapsed>
}
800045c8:	00000513          	li	a0,0
800045cc:	00008067          	ret

800045d0 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
800045d0:	00052783          	lw	a5,0(a0)
800045d4:	02050263          	beqz	a0,800045f8 <remove_timeout+0x28>
800045d8:	80006737          	lui	a4,0x80006
	return (node == list->tail) ? NULL : node->next;
800045dc:	ee472703          	lw	a4,-284(a4) # 80005ee4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee5>
800045e0:	00e50c63          	beq	a0,a4,800045f8 <remove_timeout+0x28>
	if (next(t) != NULL) {
800045e4:	00078a63          	beqz	a5,800045f8 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
800045e8:	0087a703          	lw	a4,8(a5)
800045ec:	00852683          	lw	a3,8(a0)
800045f0:	00d70733          	add	a4,a4,a3
800045f4:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
800045f8:	00452703          	lw	a4,4(a0)
800045fc:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004600:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80004604:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004608:	00052223          	sw	zero,4(a0)
}
8000460c:	00008067          	ret

80004610 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004610:	800067b7          	lui	a5,0x80006
80004614:	f807c783          	lbu	a5,-128(a5) # 80005f80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f81>
{
80004618:	ff010113          	addi	sp,sp,-16
8000461c:	00112623          	sw	ra,12(sp)
80004620:	00812423          	sw	s0,8(sp)
80004624:	00912223          	sw	s1,4(sp)
80004628:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
8000462c:	00079663          	bnez	a5,80004638 <next_timeout+0x28>
80004630:	80000537          	lui	a0,0x80000
80004634:	fff54513          	not	a0,a0
	return list->head == list;
80004638:	800067b7          	lui	a5,0x80006
8000463c:	ee078793          	addi	a5,a5,-288 # 80005ee0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee1>
80004640:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004644:	02f40463          	beq	s0,a5,8000466c <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004648:	02040263          	beqz	s0,8000466c <next_timeout+0x5c>
8000464c:	00842483          	lw	s1,8(s0)
80004650:	f69ff0ef          	jal	ra,800045b8 <elapsed>
80004654:	40a484b3          	sub	s1,s1,a0
80004658:	00000513          	li	a0,0
8000465c:	0004c863          	bltz	s1,8000466c <next_timeout+0x5c>
80004660:	00842403          	lw	s0,8(s0)
80004664:	f55ff0ef          	jal	ra,800045b8 <elapsed>
80004668:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
8000466c:	800067b7          	lui	a5,0x80006
80004670:	2047a783          	lw	a5,516(a5) # 80006204 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006205>
80004674:	00078663          	beqz	a5,80004680 <next_timeout+0x70>
80004678:	00a7d463          	bge	a5,a0,80004680 <next_timeout+0x70>
8000467c:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004680:	00c12083          	lw	ra,12(sp)
80004684:	00812403          	lw	s0,8(sp)
80004688:	00412483          	lw	s1,4(sp)
8000468c:	01010113          	addi	sp,sp,16
80004690:	00008067          	ret

80004694 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004694:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80004698:	fd010113          	addi	sp,sp,-48
8000469c:	02812423          	sw	s0,40(sp)
800046a0:	02912223          	sw	s1,36(sp)
800046a4:	01312e23          	sw	s3,28(sp)
800046a8:	02112623          	sw	ra,44(sp)
800046ac:	03212023          	sw	s2,32(sp)
800046b0:	01412c23          	sw	s4,24(sp)
800046b4:	01512a23          	sw	s5,20(sp)
800046b8:	01612823          	sw	s6,16(sp)
800046bc:	01712623          	sw	s7,12(sp)
800046c0:	01812423          	sw	s8,8(sp)
800046c4:	00050413          	mv	s0,a0
800046c8:	00058993          	mv	s3,a1
800046cc:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
800046d0:	02078e63          	beqz	a5,8000470c <z_add_timeout+0x78>
800046d4:	80006937          	lui	s2,0x80006
800046d8:	800065b7          	lui	a1,0x80006
800046dc:	80006537          	lui	a0,0x80006
800046e0:	e7c58593          	addi	a1,a1,-388 # 80005e7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e7d>
800046e4:	04d00693          	li	a3,77
800046e8:	e6890613          	addi	a2,s2,-408 # 80005e68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e69>
800046ec:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800046f0:	844fd0ef          	jal	ra,80001734 <printk>
800046f4:	80006537          	lui	a0,0x80006
800046f8:	b9c50513          	addi	a0,a0,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
800046fc:	838fd0ef          	jal	ra,80001734 <printk>
80004700:	04d00593          	li	a1,77
80004704:	e6890513          	addi	a0,s2,-408
80004708:	868fd0ef          	jal	ra,80001770 <assert_post_action>
	to->fn = fn;
8000470c:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004710:	00904463          	bgtz	s1,80004718 <z_add_timeout+0x84>
80004714:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004718:	00800993          	li	s3,8
8000471c:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004720:	80006a37          	lui	s4,0x80006
80004724:	f7ca0513          	addi	a0,s4,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
	key = (mstatus & SOC_MSTATUS_IEN);
80004728:	0089f993          	andi	s3,s3,8
8000472c:	a41ff0ef          	jal	ra,8000416c <z_spin_lock_valid>
80004730:	02051e63          	bnez	a0,8000476c <z_add_timeout+0xd8>
80004734:	80006937          	lui	s2,0x80006
80004738:	800065b7          	lui	a1,0x80006
8000473c:	80006537          	lui	a0,0x80006
80004740:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80004744:	04e00693          	li	a3,78
80004748:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
8000474c:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004750:	fe5fc0ef          	jal	ra,80001734 <printk>
80004754:	80006537          	lui	a0,0x80006
80004758:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
8000475c:	fd9fc0ef          	jal	ra,80001734 <printk>
80004760:	04e00593          	li	a1,78
80004764:	97c90513          	addi	a0,s2,-1668
80004768:	808fd0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
8000476c:	f7ca0513          	addi	a0,s4,-132
80004770:	a55ff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80004774:	e45ff0ef          	jal	ra,800045b8 <elapsed>
80004778:	00950533          	add	a0,a0,s1
	return list->head == list;
8000477c:	800064b7          	lui	s1,0x80006
80004780:	ee04a903          	lw	s2,-288(s1) # 80005ee0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee1>
80004784:	00a42423          	sw	a0,8(s0)
80004788:	ee048493          	addi	s1,s1,-288
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000478c:	00990c63          	beq	s2,s1,800047a4 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80004790:	80006ab7          	lui	s5,0x80006
80004794:	80006b37          	lui	s6,0x80006
80004798:	80006bb7          	lui	s7,0x80006
8000479c:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
800047a0:	02091063          	bnez	s2,800047c0 <z_add_timeout+0x12c>
	node->prev = list->tail;
800047a4:	0044a783          	lw	a5,4(s1)
	node->next = list;
800047a8:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
800047ac:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
800047b0:	0044a783          	lw	a5,4(s1)
800047b4:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800047b8:	0084a223          	sw	s0,4(s1)
800047bc:	05c0006f          	j	80004818 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
800047c0:	00892783          	lw	a5,8(s2)
800047c4:	0207d663          	bgez	a5,800047f0 <z_add_timeout+0x15c>
800047c8:	e9cb0593          	addi	a1,s6,-356 # 80005e9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e9d>
800047cc:	05600693          	li	a3,86
800047d0:	e68a8613          	addi	a2,s5,-408 # 80005e68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e69>
800047d4:	8f4b8513          	addi	a0,s7,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
800047d8:	f5dfc0ef          	jal	ra,80001734 <printk>
800047dc:	b9cc0513          	addi	a0,s8,-1124 # 80005b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b9d>
800047e0:	f55fc0ef          	jal	ra,80001734 <printk>
800047e4:	05600593          	li	a1,86
800047e8:	e68a8513          	addi	a0,s5,-408
800047ec:	f85fc0ef          	jal	ra,80001770 <assert_post_action>

			if (t->dticks > to->dticks) {
800047f0:	00892703          	lw	a4,8(s2)
800047f4:	00842783          	lw	a5,8(s0)
800047f8:	0ae7d863          	bge	a5,a4,800048a8 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
800047fc:	40f707b3          	sub	a5,a4,a5
80004800:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80004804:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004808:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
8000480c:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80004810:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80004814:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004818:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000481c:	00978a63          	beq	a5,s1,80004830 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004820:	00f41863          	bne	s0,a5,80004830 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80004824:	dedff0ef          	jal	ra,80004610 <next_timeout>
80004828:	00000593          	li	a1,0
8000482c:	a18fd0ef          	jal	ra,80001a44 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004830:	f7ca0513          	addi	a0,s4,-132
80004834:	961ff0ef          	jal	ra,80004194 <z_spin_unlock_valid>
80004838:	02051e63          	bnez	a0,80004874 <z_add_timeout+0x1e0>
8000483c:	80006437          	lui	s0,0x80006
80004840:	800065b7          	lui	a1,0x80006
80004844:	80006537          	lui	a0,0x80006
80004848:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
8000484c:	06100693          	li	a3,97
80004850:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004854:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004858:	eddfc0ef          	jal	ra,80001734 <printk>
8000485c:	80006537          	lui	a0,0x80006
80004860:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004864:	ed1fc0ef          	jal	ra,80001734 <printk>
80004868:	06100593          	li	a1,97
8000486c:	97c40513          	addi	a0,s0,-1668
80004870:	f01fc0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004874:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80004878:	02c12083          	lw	ra,44(sp)
8000487c:	02812403          	lw	s0,40(sp)
80004880:	02412483          	lw	s1,36(sp)
80004884:	02012903          	lw	s2,32(sp)
80004888:	01c12983          	lw	s3,28(sp)
8000488c:	01812a03          	lw	s4,24(sp)
80004890:	01412a83          	lw	s5,20(sp)
80004894:	01012b03          	lw	s6,16(sp)
80004898:	00c12b83          	lw	s7,12(sp)
8000489c:	00812c03          	lw	s8,8(sp)
800048a0:	03010113          	addi	sp,sp,48
800048a4:	00008067          	ret
			to->dticks -= t->dticks;
800048a8:	40e787b3          	sub	a5,a5,a4
800048ac:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
800048b0:	0044a783          	lw	a5,4(s1)
800048b4:	ef2788e3          	beq	a5,s2,800047a4 <z_add_timeout+0x110>
800048b8:	00092903          	lw	s2,0(s2)
800048bc:	ee5ff06f          	j	800047a0 <z_add_timeout+0x10c>

800048c0 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
800048c0:	fe010113          	addi	sp,sp,-32
800048c4:	00812c23          	sw	s0,24(sp)
800048c8:	01312623          	sw	s3,12(sp)
800048cc:	00112e23          	sw	ra,28(sp)
800048d0:	00912a23          	sw	s1,20(sp)
800048d4:	01212823          	sw	s2,16(sp)
800048d8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800048dc:	00800413          	li	s0,8
800048e0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800048e4:	800064b7          	lui	s1,0x80006
800048e8:	f7c48513          	addi	a0,s1,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
	key = (mstatus & SOC_MSTATUS_IEN);
800048ec:	00847413          	andi	s0,s0,8
800048f0:	87dff0ef          	jal	ra,8000416c <z_spin_lock_valid>
800048f4:	02051e63          	bnez	a0,80004930 <z_abort_timeout+0x70>
800048f8:	80006937          	lui	s2,0x80006
800048fc:	800065b7          	lui	a1,0x80006
80004900:	80006537          	lui	a0,0x80006
80004904:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80004908:	04e00693          	li	a3,78
8000490c:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004910:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004914:	e21fc0ef          	jal	ra,80001734 <printk>
80004918:	80006537          	lui	a0,0x80006
8000491c:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80004920:	e15fc0ef          	jal	ra,80001734 <printk>
80004924:	04e00593          	li	a1,78
80004928:	97c90513          	addi	a0,s2,-1668
8000492c:	e45fc0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80004930:	f7c48513          	addi	a0,s1,-132
80004934:	891ff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80004938:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
8000493c:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80004940:	00078863          	beqz	a5,80004950 <z_abort_timeout+0x90>
			remove_timeout(to);
80004944:	00098513          	mv	a0,s3
80004948:	c89ff0ef          	jal	ra,800045d0 <remove_timeout>
			ret = 0;
8000494c:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004950:	f7c48513          	addi	a0,s1,-132
80004954:	841ff0ef          	jal	ra,80004194 <z_spin_unlock_valid>
80004958:	02051e63          	bnez	a0,80004994 <z_abort_timeout+0xd4>
8000495c:	800064b7          	lui	s1,0x80006
80004960:	800065b7          	lui	a1,0x80006
80004964:	80006537          	lui	a0,0x80006
80004968:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
8000496c:	06100693          	li	a3,97
80004970:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004974:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004978:	dbdfc0ef          	jal	ra,80001734 <printk>
8000497c:	80006537          	lui	a0,0x80006
80004980:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004984:	db1fc0ef          	jal	ra,80001734 <printk>
80004988:	06100593          	li	a1,97
8000498c:	97c48513          	addi	a0,s1,-1668
80004990:	de1fc0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004994:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004998:	01c12083          	lw	ra,28(sp)
8000499c:	01812403          	lw	s0,24(sp)
800049a0:	00090513          	mv	a0,s2
800049a4:	01412483          	lw	s1,20(sp)
800049a8:	01012903          	lw	s2,16(sp)
800049ac:	00c12983          	lw	s3,12(sp)
800049b0:	02010113          	addi	sp,sp,32
800049b4:	00008067          	ret

800049b8 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
800049b8:	ff010113          	addi	sp,sp,-16
800049bc:	00812423          	sw	s0,8(sp)
800049c0:	00112623          	sw	ra,12(sp)
800049c4:	00912223          	sw	s1,4(sp)
800049c8:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800049cc:	00800413          	li	s0,8
800049d0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800049d4:	800064b7          	lui	s1,0x80006
800049d8:	f7c48513          	addi	a0,s1,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
	key = (mstatus & SOC_MSTATUS_IEN);
800049dc:	00847413          	andi	s0,s0,8
800049e0:	f8cff0ef          	jal	ra,8000416c <z_spin_lock_valid>
800049e4:	02051e63          	bnez	a0,80004a20 <z_get_next_timeout_expiry+0x68>
800049e8:	80006937          	lui	s2,0x80006
800049ec:	800065b7          	lui	a1,0x80006
800049f0:	80006537          	lui	a0,0x80006
800049f4:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
800049f8:	04e00693          	li	a3,78
800049fc:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004a00:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004a04:	d31fc0ef          	jal	ra,80001734 <printk>
80004a08:	80006537          	lui	a0,0x80006
80004a0c:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80004a10:	d25fc0ef          	jal	ra,80001734 <printk>
80004a14:	04e00593          	li	a1,78
80004a18:	97c90513          	addi	a0,s2,-1668
80004a1c:	d55fc0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80004a20:	f7c48513          	addi	a0,s1,-132
80004a24:	fa0ff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80004a28:	be9ff0ef          	jal	ra,80004610 <next_timeout>
80004a2c:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004a30:	f7c48513          	addi	a0,s1,-132
80004a34:	f60ff0ef          	jal	ra,80004194 <z_spin_unlock_valid>
80004a38:	02051e63          	bnez	a0,80004a74 <z_get_next_timeout_expiry+0xbc>
80004a3c:	800064b7          	lui	s1,0x80006
80004a40:	800065b7          	lui	a1,0x80006
80004a44:	80006537          	lui	a0,0x80006
80004a48:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80004a4c:	06100693          	li	a3,97
80004a50:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004a54:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004a58:	cddfc0ef          	jal	ra,80001734 <printk>
80004a5c:	80006537          	lui	a0,0x80006
80004a60:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004a64:	cd1fc0ef          	jal	ra,80001734 <printk>
80004a68:	06100593          	li	a1,97
80004a6c:	97c48513          	addi	a0,s1,-1668
80004a70:	d01fc0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004a74:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80004a78:	00c12083          	lw	ra,12(sp)
80004a7c:	00812403          	lw	s0,8(sp)
80004a80:	00090513          	mv	a0,s2
80004a84:	00412483          	lw	s1,4(sp)
80004a88:	00012903          	lw	s2,0(sp)
80004a8c:	01010113          	addi	sp,sp,16
80004a90:	00008067          	ret

80004a94 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80004a94:	fe010113          	addi	sp,sp,-32
80004a98:	00812c23          	sw	s0,24(sp)
80004a9c:	01212823          	sw	s2,16(sp)
80004aa0:	01412423          	sw	s4,8(sp)
80004aa4:	00112e23          	sw	ra,28(sp)
80004aa8:	00912a23          	sw	s1,20(sp)
80004aac:	01312623          	sw	s3,12(sp)
80004ab0:	00050913          	mv	s2,a0
80004ab4:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004ab8:	00800413          	li	s0,8
80004abc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ac0:	800064b7          	lui	s1,0x80006
80004ac4:	f7c48513          	addi	a0,s1,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
	key = (mstatus & SOC_MSTATUS_IEN);
80004ac8:	00847413          	andi	s0,s0,8
80004acc:	ea0ff0ef          	jal	ra,8000416c <z_spin_lock_valid>
80004ad0:	02051e63          	bnez	a0,80004b0c <z_set_timeout_expiry+0x78>
80004ad4:	800069b7          	lui	s3,0x80006
80004ad8:	800065b7          	lui	a1,0x80006
80004adc:	80006537          	lui	a0,0x80006
80004ae0:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80004ae4:	04e00693          	li	a3,78
80004ae8:	97c98613          	addi	a2,s3,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004aec:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004af0:	c45fc0ef          	jal	ra,80001734 <printk>
80004af4:	80006537          	lui	a0,0x80006
80004af8:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80004afc:	c39fc0ef          	jal	ra,80001734 <printk>
80004b00:	04e00593          	li	a1,78
80004b04:	97c98513          	addi	a0,s3,-1668
80004b08:	c69fc0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80004b0c:	f7c48513          	addi	a0,s1,-132
80004b10:	eb4ff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004b14:	afdff0ef          	jal	ra,80004610 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80004b18:	00a95c63          	bge	s2,a0,80004b30 <z_set_timeout_expiry+0x9c>
80004b1c:	00100793          	li	a5,1
80004b20:	00a7d863          	bge	a5,a0,80004b30 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80004b24:	000a0593          	mv	a1,s4
80004b28:	00090513          	mv	a0,s2
80004b2c:	f19fc0ef          	jal	ra,80001a44 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004b30:	f7c48513          	addi	a0,s1,-132
80004b34:	e60ff0ef          	jal	ra,80004194 <z_spin_unlock_valid>
80004b38:	02051e63          	bnez	a0,80004b74 <z_set_timeout_expiry+0xe0>
80004b3c:	800064b7          	lui	s1,0x80006
80004b40:	800065b7          	lui	a1,0x80006
80004b44:	80006537          	lui	a0,0x80006
80004b48:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80004b4c:	06100693          	li	a3,97
80004b50:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004b54:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004b58:	bddfc0ef          	jal	ra,80001734 <printk>
80004b5c:	80006537          	lui	a0,0x80006
80004b60:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004b64:	bd1fc0ef          	jal	ra,80001734 <printk>
80004b68:	06100593          	li	a1,97
80004b6c:	97c48513          	addi	a0,s1,-1668
80004b70:	c01fc0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004b74:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80004b78:	01c12083          	lw	ra,28(sp)
80004b7c:	01812403          	lw	s0,24(sp)
80004b80:	01412483          	lw	s1,20(sp)
80004b84:	01012903          	lw	s2,16(sp)
80004b88:	00c12983          	lw	s3,12(sp)
80004b8c:	00812a03          	lw	s4,8(sp)
80004b90:	02010113          	addi	sp,sp,32
80004b94:	00008067          	ret

80004b98 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80004b98:	fd010113          	addi	sp,sp,-48
80004b9c:	02812423          	sw	s0,40(sp)
80004ba0:	01412c23          	sw	s4,24(sp)
80004ba4:	02112623          	sw	ra,44(sp)
80004ba8:	02912223          	sw	s1,36(sp)
80004bac:	03212023          	sw	s2,32(sp)
80004bb0:	01312e23          	sw	s3,28(sp)
80004bb4:	01512a23          	sw	s5,20(sp)
80004bb8:	01612823          	sw	s6,16(sp)
80004bbc:	01712623          	sw	s7,12(sp)
80004bc0:	01812423          	sw	s8,8(sp)
80004bc4:	01912223          	sw	s9,4(sp)
80004bc8:	01a12023          	sw	s10,0(sp)
80004bcc:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004bd0:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80004bd4:	c68fe0ef          	jal	ra,8000303c <z_time_slice>
80004bd8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004bdc:	80006937          	lui	s2,0x80006
80004be0:	f7c90513          	addi	a0,s2,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
	key = (mstatus & SOC_MSTATUS_IEN);
80004be4:	00847413          	andi	s0,s0,8
80004be8:	d84ff0ef          	jal	ra,8000416c <z_spin_lock_valid>
80004bec:	02051e63          	bnez	a0,80004c28 <z_clock_announce+0x90>
80004bf0:	800064b7          	lui	s1,0x80006
80004bf4:	800065b7          	lui	a1,0x80006
80004bf8:	80006537          	lui	a0,0x80006
80004bfc:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80004c00:	04e00693          	li	a3,78
80004c04:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004c08:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004c0c:	b29fc0ef          	jal	ra,80001734 <printk>
80004c10:	80006537          	lui	a0,0x80006
80004c14:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80004c18:	b1dfc0ef          	jal	ra,80001734 <printk>
80004c1c:	04e00593          	li	a1,78
80004c20:	97c48513          	addi	a0,s1,-1668
80004c24:	b4dfc0ef          	jal	ra,80001770 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80004c28:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
80004c2c:	f7c90513          	addi	a0,s2,-132
80004c30:	d94ff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
80004c34:	800064b7          	lui	s1,0x80006
80004c38:	f749ac23          	sw	s4,-136(s3) # 80005f78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f79>
	return list->head == list;
80004c3c:	80006a37          	lui	s4,0x80006
80004c40:	f7898993          	addi	s3,s3,-136
80004c44:	ee0a0a13          	addi	s4,s4,-288 # 80005ee0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ee1>
80004c48:	f4048493          	addi	s1,s1,-192 # 80005f40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f41>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004c4c:	80006ab7          	lui	s5,0x80006
80004c50:	80006bb7          	lui	s7,0x80006
80004c54:	80006b37          	lui	s6,0x80006
80004c58:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004c5c:	80006cb7          	lui	s9,0x80006
80004c60:	000a2d03          	lw	s10,0(s4)
80004c64:	0009a783          	lw	a5,0(s3)
80004c68:	0004a683          	lw	a3,0(s1)
80004c6c:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004c70:	014d0c63          	beq	s10,s4,80004c88 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80004c74:	000d0a63          	beqz	s10,80004c88 <z_clock_announce+0xf0>
80004c78:	008d2703          	lw	a4,8(s10)
80004c7c:	0ae7dc63          	bge	a5,a4,80004d34 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80004c80:	40f70733          	sub	a4,a4,a5
80004c84:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80004c88:	00d786b3          	add	a3,a5,a3
80004c8c:	41f7d713          	srai	a4,a5,0x1f
80004c90:	00a70733          	add	a4,a4,a0
80004c94:	00f6b7b3          	sltu	a5,a3,a5
80004c98:	00e787b3          	add	a5,a5,a4
80004c9c:	00d4a023          	sw	a3,0(s1)
80004ca0:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80004ca4:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80004ca8:	969ff0ef          	jal	ra,80004610 <next_timeout>
80004cac:	00000593          	li	a1,0
80004cb0:	d95fc0ef          	jal	ra,80001a44 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004cb4:	f7c90513          	addi	a0,s2,-132
80004cb8:	cdcff0ef          	jal	ra,80004194 <z_spin_unlock_valid>
80004cbc:	02051e63          	bnez	a0,80004cf8 <z_clock_announce+0x160>
80004cc0:	800064b7          	lui	s1,0x80006
80004cc4:	800065b7          	lui	a1,0x80006
80004cc8:	80006537          	lui	a0,0x80006
80004ccc:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80004cd0:	06100693          	li	a3,97
80004cd4:	97c48613          	addi	a2,s1,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004cd8:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004cdc:	a59fc0ef          	jal	ra,80001734 <printk>
80004ce0:	80006537          	lui	a0,0x80006
80004ce4:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004ce8:	a4dfc0ef          	jal	ra,80001734 <printk>
80004cec:	06100593          	li	a1,97
80004cf0:	97c48513          	addi	a0,s1,-1668
80004cf4:	a7dfc0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004cf8:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80004cfc:	02c12083          	lw	ra,44(sp)
80004d00:	02812403          	lw	s0,40(sp)
80004d04:	02412483          	lw	s1,36(sp)
80004d08:	02012903          	lw	s2,32(sp)
80004d0c:	01c12983          	lw	s3,28(sp)
80004d10:	01812a03          	lw	s4,24(sp)
80004d14:	01412a83          	lw	s5,20(sp)
80004d18:	01012b03          	lw	s6,16(sp)
80004d1c:	00c12b83          	lw	s7,12(sp)
80004d20:	00812c03          	lw	s8,8(sp)
80004d24:	00412c83          	lw	s9,4(sp)
80004d28:	00012d03          	lw	s10,0(sp)
80004d2c:	03010113          	addi	sp,sp,48
80004d30:	00008067          	ret
		curr_tick += dt;
80004d34:	00d706b3          	add	a3,a4,a3
80004d38:	41f75593          	srai	a1,a4,0x1f
80004d3c:	00a585b3          	add	a1,a1,a0
80004d40:	00e6b633          	sltu	a2,a3,a4
80004d44:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
80004d48:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
80004d4c:	000d0513          	mv	a0,s10
		t->dticks = 0;
80004d50:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80004d54:	00d4a023          	sw	a3,0(s1)
80004d58:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
80004d5c:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80004d60:	871ff0ef          	jal	ra,800045d0 <remove_timeout>
80004d64:	f7c90513          	addi	a0,s2,-132
80004d68:	c2cff0ef          	jal	ra,80004194 <z_spin_unlock_valid>
80004d6c:	02051663          	bnez	a0,80004d98 <z_clock_announce+0x200>
80004d70:	9c4b8593          	addi	a1,s7,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80004d74:	06100693          	li	a3,97
80004d78:	97ca8613          	addi	a2,s5,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004d7c:	8f4b0513          	addi	a0,s6,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004d80:	9b5fc0ef          	jal	ra,80001734 <printk>
80004d84:	9dcc0513          	addi	a0,s8,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004d88:	9adfc0ef          	jal	ra,80001734 <printk>
80004d8c:	06100593          	li	a1,97
80004d90:	97ca8513          	addi	a0,s5,-1668
80004d94:	9ddfc0ef          	jal	ra,80001770 <assert_post_action>
80004d98:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80004d9c:	00cd2783          	lw	a5,12(s10)
80004da0:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004da4:	00800413          	li	s0,8
80004da8:	000780e7          	jalr	a5
80004dac:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004db0:	f7c90513          	addi	a0,s2,-132
	key = (mstatus & SOC_MSTATUS_IEN);
80004db4:	00847413          	andi	s0,s0,8
80004db8:	bb4ff0ef          	jal	ra,8000416c <z_spin_lock_valid>
80004dbc:	02051863          	bnez	a0,80004dec <z_clock_announce+0x254>
80004dc0:	994c8593          	addi	a1,s9,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80004dc4:	04e00693          	li	a3,78
80004dc8:	97ca8613          	addi	a2,s5,-1668
80004dcc:	8f4b0513          	addi	a0,s6,-1804
80004dd0:	965fc0ef          	jal	ra,80001734 <printk>
80004dd4:	80006537          	lui	a0,0x80006
80004dd8:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80004ddc:	959fc0ef          	jal	ra,80001734 <printk>
80004de0:	04e00593          	li	a1,78
80004de4:	97ca8513          	addi	a0,s5,-1668
80004de8:	989fc0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80004dec:	f7c90513          	addi	a0,s2,-132
80004df0:	bd4ff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	return k;
80004df4:	e6dff06f          	j	80004c60 <z_clock_announce+0xc8>

80004df8 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80004df8:	fe010113          	addi	sp,sp,-32
80004dfc:	00912a23          	sw	s1,20(sp)
80004e00:	00112e23          	sw	ra,28(sp)
80004e04:	00812c23          	sw	s0,24(sp)
80004e08:	01212823          	sw	s2,16(sp)
80004e0c:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e10:	00800493          	li	s1,8
80004e14:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e18:	80006937          	lui	s2,0x80006
80004e1c:	f7c90513          	addi	a0,s2,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
	key = (mstatus & SOC_MSTATUS_IEN);
80004e20:	0084f493          	andi	s1,s1,8
80004e24:	b48ff0ef          	jal	ra,8000416c <z_spin_lock_valid>
80004e28:	02051e63          	bnez	a0,80004e64 <z_tick_get+0x6c>
80004e2c:	80006437          	lui	s0,0x80006
80004e30:	800065b7          	lui	a1,0x80006
80004e34:	80006537          	lui	a0,0x80006
80004e38:	99458593          	addi	a1,a1,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80004e3c:	04e00693          	li	a3,78
80004e40:	97c40613          	addi	a2,s0,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004e44:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004e48:	8edfc0ef          	jal	ra,80001734 <printk>
80004e4c:	80006537          	lui	a0,0x80006
80004e50:	9ac50513          	addi	a0,a0,-1620 # 800059ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059ad>
80004e54:	8e1fc0ef          	jal	ra,80001734 <printk>
80004e58:	04e00593          	li	a1,78
80004e5c:	97c40513          	addi	a0,s0,-1668
80004e60:	911fc0ef          	jal	ra,80001770 <assert_post_action>
	z_spin_lock_set_owner(l);
80004e64:	f7c90513          	addi	a0,s2,-132
80004e68:	b5cff0ef          	jal	ra,800041c4 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80004e6c:	d55fc0ef          	jal	ra,80001bc0 <z_clock_elapsed>
80004e70:	800067b7          	lui	a5,0x80006
80004e74:	f4078793          	addi	a5,a5,-192 # 80005f40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f41>
80004e78:	0007a983          	lw	s3,0(a5)
80004e7c:	0047a403          	lw	s0,4(a5)
80004e80:	013509b3          	add	s3,a0,s3
80004e84:	00a9b533          	sltu	a0,s3,a0
80004e88:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004e8c:	f7c90513          	addi	a0,s2,-132
80004e90:	b04ff0ef          	jal	ra,80004194 <z_spin_unlock_valid>
80004e94:	02051e63          	bnez	a0,80004ed0 <z_tick_get+0xd8>
80004e98:	80006937          	lui	s2,0x80006
80004e9c:	800065b7          	lui	a1,0x80006
80004ea0:	80006537          	lui	a0,0x80006
80004ea4:	9c458593          	addi	a1,a1,-1596 # 800059c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059c5>
80004ea8:	06100693          	li	a3,97
80004eac:	97c90613          	addi	a2,s2,-1668 # 8000597c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000597d>
80004eb0:	8f450513          	addi	a0,a0,-1804 # 800058f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f5>
80004eb4:	881fc0ef          	jal	ra,80001734 <printk>
80004eb8:	80006537          	lui	a0,0x80006
80004ebc:	9dc50513          	addi	a0,a0,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80004ec0:	875fc0ef          	jal	ra,80001734 <printk>
80004ec4:	06100593          	li	a1,97
80004ec8:	97c90513          	addi	a0,s2,-1668
80004ecc:	8a5fc0ef          	jal	ra,80001770 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004ed0:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80004ed4:	00040593          	mv	a1,s0
80004ed8:	01c12083          	lw	ra,28(sp)
80004edc:	01812403          	lw	s0,24(sp)
80004ee0:	00098513          	mv	a0,s3
80004ee4:	01412483          	lw	s1,20(sp)
80004ee8:	01012903          	lw	s2,16(sp)
80004eec:	00c12983          	lw	s3,12(sp)
80004ef0:	02010113          	addi	sp,sp,32
80004ef4:	00008067          	ret

80004ef8 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80004ef8:	ff010113          	addi	sp,sp,-16
80004efc:	00112623          	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80004f00:	ef9ff0ef          	jal	ra,80004df8 <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80004f04:	00c12083          	lw	ra,12(sp)
80004f08:	01010113          	addi	sp,sp,16
80004f0c:	00008067          	ret

80004f10 <z_impl_k_uptime_get_32>:

u32_t z_impl_k_uptime_get_32(void)
{
80004f10:	ff010113          	addi	sp,sp,-16
80004f14:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get_32());
80004f18:	fe1ff0ef          	jal	ra,80004ef8 <z_tick_get_32>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80004f1c:	3e800793          	li	a5,1000
80004f20:	02f535b3          	mulhu	a1,a0,a5
80004f24:	06400613          	li	a2,100
80004f28:	00000693          	li	a3,0
80004f2c:	02f50533          	mul	a0,a0,a5
80004f30:	b90fb0ef          	jal	ra,800002c0 <__udivdi3>
}
80004f34:	00c12083          	lw	ra,12(sp)
80004f38:	01010113          	addi	sp,sp,16
80004f3c:	00008067          	ret

80004f40 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80004f40:	ff010113          	addi	sp,sp,-16
80004f44:	00812423          	sw	s0,8(sp)
80004f48:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004f4c:	80006437          	lui	s0,0x80006
80004f50:	800064b7          	lui	s1,0x80006
{
80004f54:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004f58:	f2440413          	addi	s0,s0,-220 # 80005f24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f25>
80004f5c:	f2448493          	addi	s1,s1,-220 # 80005f24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f25>
80004f60:	00946e63          	bltu	s0,s1,80004f7c <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80004f64:	00c12083          	lw	ra,12(sp)
80004f68:	00812403          	lw	s0,8(sp)
80004f6c:	00412483          	lw	s1,4(sp)
80004f70:	00000513          	li	a0,0
80004f74:	01010113          	addi	sp,sp,16
80004f78:	00008067          	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80004f7c:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80004f80:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80004f84:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80004f88:	00f42c23          	sw	a5,24(s0)
80004f8c:	854fc0ef          	jal	ra,80000fe0 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80004f90:	01c40413          	addi	s0,s0,28
80004f94:	fcdff06f          	j	80004f60 <init_static_pools+0x20>

80004f98 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80004f98:	00008067          	ret
