
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	1cc0106f          	j	800011d8 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	200000ef          	jal	ra,8000026c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	04051663          	bnez	a0,800000c0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	14408093          	addi	ra,ra,324 # 800001d8 <no_reschedule>
	tail _Fault
8000009c:	04c0106f          	j	800010e8 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
800000ac:	00007297          	auipc	t0,0x7
800000b0:	c1c28293          	addi	t0,t0,-996 # 80006cc8 <_offload_routine>
	lw t1, 0x00(t0)
800000b4:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
800000b8:	00031463          	bnez	t1,800000c0 <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000bc:	0900006f          	j	8000014c <reschedule>

800000c0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000c0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000c4:	00007397          	auipc	t2,0x7
800000c8:	f4838393          	addi	t2,t2,-184 # 8000700c <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000cc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000d0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000d4:	00512023          	sw	t0,0(sp)

800000d8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000d8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000dc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000e0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000e4:	00030863          	beqz	t1,800000f4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000e8:	00000097          	auipc	ra,0x0
800000ec:	03c08093          	addi	ra,ra,60 # 80000124 <on_thread_stack>
	tail z_irq_do_offload
800000f0:	0840106f          	j	80001174 <z_irq_do_offload>

800000f4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000f4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000f8:	800002b7          	lui	t0,0x80000
800000fc:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
80000100:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
80000104:	158000ef          	jal	ra,8000025c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
80000108:	00006297          	auipc	t0,0x6
8000010c:	b7428293          	addi	t0,t0,-1164 # 80005c7c <_image_text_end>
	slli a0, a0, 3
80000110:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000114:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000118:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000011c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000120:	000300e7          	jalr	t1

80000124 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000124:	00007317          	auipc	t1,0x7
80000128:	ee830313          	addi	t1,t1,-280 # 8000700c <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000012c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000130:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000134:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000138:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000013c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000140:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000144:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000148:	087e0863          	beq	t3,t2,800001d8 <no_reschedule>

8000014c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000014c:	00007297          	auipc	t0,0x7
80000150:	ec028293          	addi	t0,t0,-320 # 8000700c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000154:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000158:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000015c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000160:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000164:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000168:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000016c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000170:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000174:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000178:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000017c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000180:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000184:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000188:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000018c:	00007397          	auipc	t2,0x7
80000190:	a8038393          	addi	t2,t2,-1408 # 80006c0c <_k_neg_eagain>
	lw t3, 0x00(t2)
80000194:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000198:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000019c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
800001a0:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
800001a4:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
800001a8:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
800001ac:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001b0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001b4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001b8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001bc:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001c0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001c4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001c8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001cc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001d0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001d4:	05832d83          	lw	s11,88(t1)

800001d8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001d8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001dc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001e0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001e4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001e8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001ec:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001f0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001f4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001f8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001fc:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
80000200:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
80000204:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
80000208:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
8000020c:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000210:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000214:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000218:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000021c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000220:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000224:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000228:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000022c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000230:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000234:	30200073          	mret

80000238 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000238:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000023c:	00007297          	auipc	t0,0x7
80000240:	dd028293          	addi	t0,t0,-560 # 8000700c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000244:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000248:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000024c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000250:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000254:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000025c:	00100313          	li	t1,1
	sll t0, t1, a0
80000260:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000264:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000268:	00008067          	ret

8000026c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000026c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000270:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000274:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000278:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000027c:	00028463          	beqz	t0,80000284 <not_interrupt>
	addi a0, a0, 1
80000280:	00150513          	addi	a0,a0,1

80000284 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000284:	00008067          	ret

Disassembly of section text:

80000288 <__lshrdi3>:
80000288:	02060063          	beqz	a2,800002a8 <__lshrdi3+0x20>
8000028c:	02000793          	li	a5,32
80000290:	40c787b3          	sub	a5,a5,a2
80000294:	00f04c63          	bgtz	a5,800002ac <__lshrdi3+0x24>
80000298:	fe060513          	addi	a0,a2,-32
8000029c:	00000713          	li	a4,0
800002a0:	00a5d533          	srl	a0,a1,a0
800002a4:	00070593          	mv	a1,a4
800002a8:	00008067          	ret
800002ac:	00c5d733          	srl	a4,a1,a2
800002b0:	00c55533          	srl	a0,a0,a2
800002b4:	00f595b3          	sll	a1,a1,a5
800002b8:	00b56533          	or	a0,a0,a1
800002bc:	fe9ff06f          	j	800002a4 <__lshrdi3+0x1c>

800002c0 <__udivdi3>:
800002c0:	fd010113          	addi	sp,sp,-48
800002c4:	02912223          	sw	s1,36(sp)
800002c8:	01612823          	sw	s6,16(sp)
800002cc:	02112623          	sw	ra,44(sp)
800002d0:	02812423          	sw	s0,40(sp)
800002d4:	03212023          	sw	s2,32(sp)
800002d8:	01312e23          	sw	s3,28(sp)
800002dc:	01412c23          	sw	s4,24(sp)
800002e0:	01512a23          	sw	s5,20(sp)
800002e4:	01712623          	sw	s7,12(sp)
800002e8:	01812423          	sw	s8,8(sp)
800002ec:	01912223          	sw	s9,4(sp)
800002f0:	00050b13          	mv	s6,a0
800002f4:	00058493          	mv	s1,a1
800002f8:	38069c63          	bnez	a3,80000690 <__udivdi3+0x3d0>
800002fc:	00060413          	mv	s0,a2
80000300:	00050993          	mv	s3,a0
80000304:	00006917          	auipc	s2,0x6
80000308:	af890913          	addi	s2,s2,-1288 # 80005dfc <__devconfig_end>
8000030c:	12c5f863          	bgeu	a1,a2,8000043c <__udivdi3+0x17c>
80000310:	000107b7          	lui	a5,0x10
80000314:	00058a93          	mv	s5,a1
80000318:	10f67863          	bgeu	a2,a5,80000428 <__udivdi3+0x168>
8000031c:	0ff00693          	li	a3,255
80000320:	00c6b6b3          	sltu	a3,a3,a2
80000324:	00369693          	slli	a3,a3,0x3
80000328:	00d657b3          	srl	a5,a2,a3
8000032c:	00f90933          	add	s2,s2,a5
80000330:	00094703          	lbu	a4,0(s2)
80000334:	00d706b3          	add	a3,a4,a3
80000338:	02000713          	li	a4,32
8000033c:	40d70733          	sub	a4,a4,a3
80000340:	00070c63          	beqz	a4,80000358 <__udivdi3+0x98>
80000344:	00e494b3          	sll	s1,s1,a4
80000348:	00db56b3          	srl	a3,s6,a3
8000034c:	00e61433          	sll	s0,a2,a4
80000350:	0096eab3          	or	s5,a3,s1
80000354:	00eb19b3          	sll	s3,s6,a4
80000358:	01045b13          	srli	s6,s0,0x10
8000035c:	000b0593          	mv	a1,s6
80000360:	000a8513          	mv	a0,s5
80000364:	5a4000ef          	jal	ra,80000908 <__umodsi3>
80000368:	00050913          	mv	s2,a0
8000036c:	000b0593          	mv	a1,s6
80000370:	01041b93          	slli	s7,s0,0x10
80000374:	000a8513          	mv	a0,s5
80000378:	548000ef          	jal	ra,800008c0 <__udivsi3>
8000037c:	010bdb93          	srli	s7,s7,0x10
80000380:	00050493          	mv	s1,a0
80000384:	00050593          	mv	a1,a0
80000388:	000b8513          	mv	a0,s7
8000038c:	508000ef          	jal	ra,80000894 <__mulsi3>
80000390:	01091913          	slli	s2,s2,0x10
80000394:	0109d713          	srli	a4,s3,0x10
80000398:	00e96733          	or	a4,s2,a4
8000039c:	00048a13          	mv	s4,s1
800003a0:	00a77e63          	bgeu	a4,a0,800003bc <__udivdi3+0xfc>
800003a4:	00870733          	add	a4,a4,s0
800003a8:	fff48a13          	addi	s4,s1,-1
800003ac:	00876863          	bltu	a4,s0,800003bc <__udivdi3+0xfc>
800003b0:	00a77663          	bgeu	a4,a0,800003bc <__udivdi3+0xfc>
800003b4:	ffe48a13          	addi	s4,s1,-2
800003b8:	00870733          	add	a4,a4,s0
800003bc:	40a704b3          	sub	s1,a4,a0
800003c0:	000b0593          	mv	a1,s6
800003c4:	00048513          	mv	a0,s1
800003c8:	540000ef          	jal	ra,80000908 <__umodsi3>
800003cc:	00050913          	mv	s2,a0
800003d0:	000b0593          	mv	a1,s6
800003d4:	00048513          	mv	a0,s1
800003d8:	4e8000ef          	jal	ra,800008c0 <__udivsi3>
800003dc:	01099993          	slli	s3,s3,0x10
800003e0:	00050493          	mv	s1,a0
800003e4:	00050593          	mv	a1,a0
800003e8:	01091913          	slli	s2,s2,0x10
800003ec:	000b8513          	mv	a0,s7
800003f0:	0109d993          	srli	s3,s3,0x10
800003f4:	4a0000ef          	jal	ra,80000894 <__mulsi3>
800003f8:	013969b3          	or	s3,s2,s3
800003fc:	00048613          	mv	a2,s1
80000400:	00a9fc63          	bgeu	s3,a0,80000418 <__udivdi3+0x158>
80000404:	013409b3          	add	s3,s0,s3
80000408:	fff48613          	addi	a2,s1,-1
8000040c:	0089e663          	bltu	s3,s0,80000418 <__udivdi3+0x158>
80000410:	00a9f463          	bgeu	s3,a0,80000418 <__udivdi3+0x158>
80000414:	ffe48613          	addi	a2,s1,-2
80000418:	010a1793          	slli	a5,s4,0x10
8000041c:	00c7e7b3          	or	a5,a5,a2
80000420:	00000a13          	li	s4,0
80000424:	1300006f          	j	80000554 <__udivdi3+0x294>
80000428:	010007b7          	lui	a5,0x1000
8000042c:	01000693          	li	a3,16
80000430:	eef66ce3          	bltu	a2,a5,80000328 <__udivdi3+0x68>
80000434:	01800693          	li	a3,24
80000438:	ef1ff06f          	j	80000328 <__udivdi3+0x68>
8000043c:	00068a13          	mv	s4,a3
80000440:	00061a63          	bnez	a2,80000454 <__udivdi3+0x194>
80000444:	00000593          	li	a1,0
80000448:	00100513          	li	a0,1
8000044c:	474000ef          	jal	ra,800008c0 <__udivsi3>
80000450:	00050413          	mv	s0,a0
80000454:	000107b7          	lui	a5,0x10
80000458:	12f47c63          	bgeu	s0,a5,80000590 <__udivdi3+0x2d0>
8000045c:	0ff00793          	li	a5,255
80000460:	0087f463          	bgeu	a5,s0,80000468 <__udivdi3+0x1a8>
80000464:	00800a13          	li	s4,8
80000468:	014457b3          	srl	a5,s0,s4
8000046c:	00f90933          	add	s2,s2,a5
80000470:	00094683          	lbu	a3,0(s2)
80000474:	02000613          	li	a2,32
80000478:	014686b3          	add	a3,a3,s4
8000047c:	40d60633          	sub	a2,a2,a3
80000480:	12061263          	bnez	a2,800005a4 <__udivdi3+0x2e4>
80000484:	408484b3          	sub	s1,s1,s0
80000488:	00100a13          	li	s4,1
8000048c:	01045b13          	srli	s6,s0,0x10
80000490:	000b0593          	mv	a1,s6
80000494:	00048513          	mv	a0,s1
80000498:	470000ef          	jal	ra,80000908 <__umodsi3>
8000049c:	00050913          	mv	s2,a0
800004a0:	000b0593          	mv	a1,s6
800004a4:	00048513          	mv	a0,s1
800004a8:	01041b93          	slli	s7,s0,0x10
800004ac:	414000ef          	jal	ra,800008c0 <__udivsi3>
800004b0:	010bdb93          	srli	s7,s7,0x10
800004b4:	00050493          	mv	s1,a0
800004b8:	00050593          	mv	a1,a0
800004bc:	000b8513          	mv	a0,s7
800004c0:	3d4000ef          	jal	ra,80000894 <__mulsi3>
800004c4:	01091913          	slli	s2,s2,0x10
800004c8:	0109d713          	srli	a4,s3,0x10
800004cc:	00e96733          	or	a4,s2,a4
800004d0:	00048a93          	mv	s5,s1
800004d4:	00a77e63          	bgeu	a4,a0,800004f0 <__udivdi3+0x230>
800004d8:	00870733          	add	a4,a4,s0
800004dc:	fff48a93          	addi	s5,s1,-1
800004e0:	00876863          	bltu	a4,s0,800004f0 <__udivdi3+0x230>
800004e4:	00a77663          	bgeu	a4,a0,800004f0 <__udivdi3+0x230>
800004e8:	ffe48a93          	addi	s5,s1,-2
800004ec:	00870733          	add	a4,a4,s0
800004f0:	40a704b3          	sub	s1,a4,a0
800004f4:	000b0593          	mv	a1,s6
800004f8:	00048513          	mv	a0,s1
800004fc:	40c000ef          	jal	ra,80000908 <__umodsi3>
80000500:	00050913          	mv	s2,a0
80000504:	000b0593          	mv	a1,s6
80000508:	00048513          	mv	a0,s1
8000050c:	3b4000ef          	jal	ra,800008c0 <__udivsi3>
80000510:	01099993          	slli	s3,s3,0x10
80000514:	00050493          	mv	s1,a0
80000518:	00050593          	mv	a1,a0
8000051c:	01091913          	slli	s2,s2,0x10
80000520:	000b8513          	mv	a0,s7
80000524:	0109d993          	srli	s3,s3,0x10
80000528:	36c000ef          	jal	ra,80000894 <__mulsi3>
8000052c:	013969b3          	or	s3,s2,s3
80000530:	00048613          	mv	a2,s1
80000534:	00a9fc63          	bgeu	s3,a0,8000054c <__udivdi3+0x28c>
80000538:	013409b3          	add	s3,s0,s3
8000053c:	fff48613          	addi	a2,s1,-1
80000540:	0089e663          	bltu	s3,s0,8000054c <__udivdi3+0x28c>
80000544:	00a9f463          	bgeu	s3,a0,8000054c <__udivdi3+0x28c>
80000548:	ffe48613          	addi	a2,s1,-2
8000054c:	010a9793          	slli	a5,s5,0x10
80000550:	00c7e7b3          	or	a5,a5,a2
80000554:	00078513          	mv	a0,a5
80000558:	000a0593          	mv	a1,s4
8000055c:	02c12083          	lw	ra,44(sp)
80000560:	02812403          	lw	s0,40(sp)
80000564:	02412483          	lw	s1,36(sp)
80000568:	02012903          	lw	s2,32(sp)
8000056c:	01c12983          	lw	s3,28(sp)
80000570:	01812a03          	lw	s4,24(sp)
80000574:	01412a83          	lw	s5,20(sp)
80000578:	01012b03          	lw	s6,16(sp)
8000057c:	00c12b83          	lw	s7,12(sp)
80000580:	00812c03          	lw	s8,8(sp)
80000584:	00412c83          	lw	s9,4(sp)
80000588:	03010113          	addi	sp,sp,48
8000058c:	00008067          	ret
80000590:	010007b7          	lui	a5,0x1000
80000594:	01000a13          	li	s4,16
80000598:	ecf468e3          	bltu	s0,a5,80000468 <__udivdi3+0x1a8>
8000059c:	01800a13          	li	s4,24
800005a0:	ec9ff06f          	j	80000468 <__udivdi3+0x1a8>
800005a4:	00c41433          	sll	s0,s0,a2
800005a8:	00d4da33          	srl	s4,s1,a3
800005ac:	00cb19b3          	sll	s3,s6,a2
800005b0:	00db56b3          	srl	a3,s6,a3
800005b4:	01045b13          	srli	s6,s0,0x10
800005b8:	00c494b3          	sll	s1,s1,a2
800005bc:	000b0593          	mv	a1,s6
800005c0:	000a0513          	mv	a0,s4
800005c4:	0096eab3          	or	s5,a3,s1
800005c8:	340000ef          	jal	ra,80000908 <__umodsi3>
800005cc:	00050913          	mv	s2,a0
800005d0:	000b0593          	mv	a1,s6
800005d4:	000a0513          	mv	a0,s4
800005d8:	01041b93          	slli	s7,s0,0x10
800005dc:	2e4000ef          	jal	ra,800008c0 <__udivsi3>
800005e0:	010bdb93          	srli	s7,s7,0x10
800005e4:	00050493          	mv	s1,a0
800005e8:	00050593          	mv	a1,a0
800005ec:	000b8513          	mv	a0,s7
800005f0:	2a4000ef          	jal	ra,80000894 <__mulsi3>
800005f4:	01091913          	slli	s2,s2,0x10
800005f8:	010ad713          	srli	a4,s5,0x10
800005fc:	00e96733          	or	a4,s2,a4
80000600:	00048a13          	mv	s4,s1
80000604:	00a77e63          	bgeu	a4,a0,80000620 <__udivdi3+0x360>
80000608:	00870733          	add	a4,a4,s0
8000060c:	fff48a13          	addi	s4,s1,-1
80000610:	00876863          	bltu	a4,s0,80000620 <__udivdi3+0x360>
80000614:	00a77663          	bgeu	a4,a0,80000620 <__udivdi3+0x360>
80000618:	ffe48a13          	addi	s4,s1,-2
8000061c:	00870733          	add	a4,a4,s0
80000620:	40a704b3          	sub	s1,a4,a0
80000624:	000b0593          	mv	a1,s6
80000628:	00048513          	mv	a0,s1
8000062c:	2dc000ef          	jal	ra,80000908 <__umodsi3>
80000630:	00050913          	mv	s2,a0
80000634:	000b0593          	mv	a1,s6
80000638:	00048513          	mv	a0,s1
8000063c:	284000ef          	jal	ra,800008c0 <__udivsi3>
80000640:	00050493          	mv	s1,a0
80000644:	00050593          	mv	a1,a0
80000648:	000b8513          	mv	a0,s7
8000064c:	248000ef          	jal	ra,80000894 <__mulsi3>
80000650:	010a9693          	slli	a3,s5,0x10
80000654:	01091913          	slli	s2,s2,0x10
80000658:	0106d693          	srli	a3,a3,0x10
8000065c:	00d967b3          	or	a5,s2,a3
80000660:	00048713          	mv	a4,s1
80000664:	00a7fe63          	bgeu	a5,a0,80000680 <__udivdi3+0x3c0>
80000668:	008787b3          	add	a5,a5,s0
8000066c:	fff48713          	addi	a4,s1,-1
80000670:	0087e863          	bltu	a5,s0,80000680 <__udivdi3+0x3c0>
80000674:	00a7f663          	bgeu	a5,a0,80000680 <__udivdi3+0x3c0>
80000678:	ffe48713          	addi	a4,s1,-2
8000067c:	008787b3          	add	a5,a5,s0
80000680:	010a1a13          	slli	s4,s4,0x10
80000684:	40a784b3          	sub	s1,a5,a0
80000688:	00ea6a33          	or	s4,s4,a4
8000068c:	e01ff06f          	j	8000048c <__udivdi3+0x1cc>
80000690:	1ed5ec63          	bltu	a1,a3,80000888 <__udivdi3+0x5c8>
80000694:	000107b7          	lui	a5,0x10
80000698:	04f6f463          	bgeu	a3,a5,800006e0 <__udivdi3+0x420>
8000069c:	0ff00593          	li	a1,255
800006a0:	00d5b533          	sltu	a0,a1,a3
800006a4:	00351513          	slli	a0,a0,0x3
800006a8:	00a6d733          	srl	a4,a3,a0
800006ac:	00005797          	auipc	a5,0x5
800006b0:	75078793          	addi	a5,a5,1872 # 80005dfc <__devconfig_end>
800006b4:	00e787b3          	add	a5,a5,a4
800006b8:	0007c583          	lbu	a1,0(a5)
800006bc:	02000a13          	li	s4,32
800006c0:	00a585b3          	add	a1,a1,a0
800006c4:	40ba0a33          	sub	s4,s4,a1
800006c8:	020a1663          	bnez	s4,800006f4 <__udivdi3+0x434>
800006cc:	00100793          	li	a5,1
800006d0:	e896e2e3          	bltu	a3,s1,80000554 <__udivdi3+0x294>
800006d4:	00cb3633          	sltu	a2,s6,a2
800006d8:	00164793          	xori	a5,a2,1
800006dc:	e79ff06f          	j	80000554 <__udivdi3+0x294>
800006e0:	010007b7          	lui	a5,0x1000
800006e4:	01000513          	li	a0,16
800006e8:	fcf6e0e3          	bltu	a3,a5,800006a8 <__udivdi3+0x3e8>
800006ec:	01800513          	li	a0,24
800006f0:	fb9ff06f          	j	800006a8 <__udivdi3+0x3e8>
800006f4:	00b65ab3          	srl	s5,a2,a1
800006f8:	014696b3          	sll	a3,a3,s4
800006fc:	00daeab3          	or	s5,s5,a3
80000700:	00b4d933          	srl	s2,s1,a1
80000704:	014497b3          	sll	a5,s1,s4
80000708:	00bb55b3          	srl	a1,s6,a1
8000070c:	010adb93          	srli	s7,s5,0x10
80000710:	00f5e4b3          	or	s1,a1,a5
80000714:	00090513          	mv	a0,s2
80000718:	000b8593          	mv	a1,s7
8000071c:	014619b3          	sll	s3,a2,s4
80000720:	1e8000ef          	jal	ra,80000908 <__umodsi3>
80000724:	00050413          	mv	s0,a0
80000728:	000b8593          	mv	a1,s7
8000072c:	00090513          	mv	a0,s2
80000730:	010a9c13          	slli	s8,s5,0x10
80000734:	18c000ef          	jal	ra,800008c0 <__udivsi3>
80000738:	010c5c13          	srli	s8,s8,0x10
8000073c:	00050913          	mv	s2,a0
80000740:	00050593          	mv	a1,a0
80000744:	000c0513          	mv	a0,s8
80000748:	14c000ef          	jal	ra,80000894 <__mulsi3>
8000074c:	01041413          	slli	s0,s0,0x10
80000750:	0104d713          	srli	a4,s1,0x10
80000754:	00e46733          	or	a4,s0,a4
80000758:	00090c93          	mv	s9,s2
8000075c:	00a77e63          	bgeu	a4,a0,80000778 <__udivdi3+0x4b8>
80000760:	01570733          	add	a4,a4,s5
80000764:	fff90c93          	addi	s9,s2,-1
80000768:	01576863          	bltu	a4,s5,80000778 <__udivdi3+0x4b8>
8000076c:	00a77663          	bgeu	a4,a0,80000778 <__udivdi3+0x4b8>
80000770:	ffe90c93          	addi	s9,s2,-2
80000774:	01570733          	add	a4,a4,s5
80000778:	40a70933          	sub	s2,a4,a0
8000077c:	000b8593          	mv	a1,s7
80000780:	00090513          	mv	a0,s2
80000784:	184000ef          	jal	ra,80000908 <__umodsi3>
80000788:	00050413          	mv	s0,a0
8000078c:	000b8593          	mv	a1,s7
80000790:	00090513          	mv	a0,s2
80000794:	12c000ef          	jal	ra,800008c0 <__udivsi3>
80000798:	00050913          	mv	s2,a0
8000079c:	00050593          	mv	a1,a0
800007a0:	000c0513          	mv	a0,s8
800007a4:	0f0000ef          	jal	ra,80000894 <__mulsi3>
800007a8:	01049793          	slli	a5,s1,0x10
800007ac:	01041413          	slli	s0,s0,0x10
800007b0:	0107d793          	srli	a5,a5,0x10
800007b4:	00f46733          	or	a4,s0,a5
800007b8:	00090613          	mv	a2,s2
800007bc:	00a77e63          	bgeu	a4,a0,800007d8 <__udivdi3+0x518>
800007c0:	01570733          	add	a4,a4,s5
800007c4:	fff90613          	addi	a2,s2,-1
800007c8:	01576863          	bltu	a4,s5,800007d8 <__udivdi3+0x518>
800007cc:	00a77663          	bgeu	a4,a0,800007d8 <__udivdi3+0x518>
800007d0:	ffe90613          	addi	a2,s2,-2
800007d4:	01570733          	add	a4,a4,s5
800007d8:	010c9793          	slli	a5,s9,0x10
800007dc:	00010e37          	lui	t3,0x10
800007e0:	00c7e7b3          	or	a5,a5,a2
800007e4:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007e8:	0107f333          	and	t1,a5,a6
800007ec:	0109f833          	and	a6,s3,a6
800007f0:	40a70733          	sub	a4,a4,a0
800007f4:	0107de93          	srli	t4,a5,0x10
800007f8:	0109d993          	srli	s3,s3,0x10
800007fc:	00030513          	mv	a0,t1
80000800:	00080593          	mv	a1,a6
80000804:	090000ef          	jal	ra,80000894 <__mulsi3>
80000808:	00050893          	mv	a7,a0
8000080c:	00098593          	mv	a1,s3
80000810:	00030513          	mv	a0,t1
80000814:	080000ef          	jal	ra,80000894 <__mulsi3>
80000818:	00050313          	mv	t1,a0
8000081c:	00080593          	mv	a1,a6
80000820:	000e8513          	mv	a0,t4
80000824:	070000ef          	jal	ra,80000894 <__mulsi3>
80000828:	00050813          	mv	a6,a0
8000082c:	00098593          	mv	a1,s3
80000830:	000e8513          	mv	a0,t4
80000834:	060000ef          	jal	ra,80000894 <__mulsi3>
80000838:	0108d693          	srli	a3,a7,0x10
8000083c:	01030333          	add	t1,t1,a6
80000840:	006686b3          	add	a3,a3,t1
80000844:	0106f463          	bgeu	a3,a6,8000084c <__udivdi3+0x58c>
80000848:	01c50533          	add	a0,a0,t3
8000084c:	0106d613          	srli	a2,a3,0x10
80000850:	00a60533          	add	a0,a2,a0
80000854:	02a76663          	bltu	a4,a0,80000880 <__udivdi3+0x5c0>
80000858:	bca714e3          	bne	a4,a0,80000420 <__udivdi3+0x160>
8000085c:	00010737          	lui	a4,0x10
80000860:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000864:	00e6f6b3          	and	a3,a3,a4
80000868:	01069693          	slli	a3,a3,0x10
8000086c:	00e8f8b3          	and	a7,a7,a4
80000870:	014b1633          	sll	a2,s6,s4
80000874:	011686b3          	add	a3,a3,a7
80000878:	00000a13          	li	s4,0
8000087c:	ccd67ce3          	bgeu	a2,a3,80000554 <__udivdi3+0x294>
80000880:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
80000884:	b9dff06f          	j	80000420 <__udivdi3+0x160>
80000888:	00000a13          	li	s4,0
8000088c:	00000793          	li	a5,0
80000890:	cc5ff06f          	j	80000554 <__udivdi3+0x294>

80000894 <__mulsi3>:
80000894:	00050613          	mv	a2,a0
80000898:	00000513          	li	a0,0
8000089c:	0015f693          	andi	a3,a1,1
800008a0:	00068463          	beqz	a3,800008a8 <__mulsi3+0x14>
800008a4:	00c50533          	add	a0,a0,a2
800008a8:	0015d593          	srli	a1,a1,0x1
800008ac:	00161613          	slli	a2,a2,0x1
800008b0:	fe0596e3          	bnez	a1,8000089c <__mulsi3+0x8>
800008b4:	00008067          	ret

800008b8 <__divsi3>:
800008b8:	06054063          	bltz	a0,80000918 <__umodsi3+0x10>
800008bc:	0605c663          	bltz	a1,80000928 <__umodsi3+0x20>

800008c0 <__udivsi3>:
800008c0:	00058613          	mv	a2,a1
800008c4:	00050593          	mv	a1,a0
800008c8:	fff00513          	li	a0,-1
800008cc:	02060c63          	beqz	a2,80000904 <__udivsi3+0x44>
800008d0:	00100693          	li	a3,1
800008d4:	00b67a63          	bgeu	a2,a1,800008e8 <__udivsi3+0x28>
800008d8:	00c05863          	blez	a2,800008e8 <__udivsi3+0x28>
800008dc:	00161613          	slli	a2,a2,0x1
800008e0:	00169693          	slli	a3,a3,0x1
800008e4:	feb66ae3          	bltu	a2,a1,800008d8 <__udivsi3+0x18>
800008e8:	00000513          	li	a0,0
800008ec:	00c5e663          	bltu	a1,a2,800008f8 <__udivsi3+0x38>
800008f0:	40c585b3          	sub	a1,a1,a2
800008f4:	00d56533          	or	a0,a0,a3
800008f8:	0016d693          	srli	a3,a3,0x1
800008fc:	00165613          	srli	a2,a2,0x1
80000900:	fe0696e3          	bnez	a3,800008ec <__udivsi3+0x2c>
80000904:	00008067          	ret

80000908 <__umodsi3>:
80000908:	00008293          	mv	t0,ra
8000090c:	fb5ff0ef          	jal	ra,800008c0 <__udivsi3>
80000910:	00058513          	mv	a0,a1
80000914:	00028067          	jr	t0
80000918:	40a00533          	neg	a0,a0
8000091c:	0005d863          	bgez	a1,8000092c <__umodsi3+0x24>
80000920:	40b005b3          	neg	a1,a1
80000924:	f9dff06f          	j	800008c0 <__udivsi3>
80000928:	40b005b3          	neg	a1,a1
8000092c:	00008293          	mv	t0,ra
80000930:	f91ff0ef          	jal	ra,800008c0 <__udivsi3>
80000934:	40a00533          	neg	a0,a0
80000938:	00028067          	jr	t0

8000093c <__modsi3>:
8000093c:	00008293          	mv	t0,ra
80000940:	0005ca63          	bltz	a1,80000954 <__modsi3+0x18>
80000944:	00054c63          	bltz	a0,8000095c <__modsi3+0x20>
80000948:	f79ff0ef          	jal	ra,800008c0 <__udivsi3>
8000094c:	00058513          	mv	a0,a1
80000950:	00028067          	jr	t0
80000954:	40b005b3          	neg	a1,a1
80000958:	fe0558e3          	bgez	a0,80000948 <__modsi3+0xc>
8000095c:	40a00533          	neg	a0,a0
80000960:	f61ff0ef          	jal	ra,800008c0 <__udivsi3>
80000964:	40b00533          	neg	a0,a1
80000968:	00028067          	jr	t0

8000096c <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
8000096c:	00008067          	ret

80000970 <test_stack_user_thread2thread>:
	static void _name(void)	   \
	{			   \
		ztest_test_skip(); \
	}

dummy_test(test_stack_user_thread2thread);
80000970:	7b90106f          	j	80002928 <ztest_test_skip>

80000974 <test_stack_user_pop_fail>:
80000974:	7b50106f          	j	80002928 <ztest_test_skip>

80000978 <test_main>:
 * @{
 * @}
 */
/*test case main entry*/
void test_main(void)
{
80000978:	ff010113          	addi	sp,sp,-16
8000097c:	00112623          	sw	ra,12(sp)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000980:	099030ef          	jal	ra,80004218 <z_impl_k_current_get>
80000984:	095030ef          	jal	ra,80004218 <z_impl_k_current_get>
80000988:	091030ef          	jal	ra,80004218 <z_impl_k_current_get>
8000098c:	08d030ef          	jal	ra,80004218 <z_impl_k_current_get>
80000990:	089030ef          	jal	ra,80004218 <z_impl_k_current_get>
80000994:	085030ef          	jal	ra,80004218 <z_impl_k_current_get>
 * @req K-THREAD-005
 */
static inline void k_thread_resource_pool_assign(struct k_thread *thread,
						 struct k_mem_pool *pool)
{
	thread->resource_pool = pool;
80000998:	800077b7          	lui	a5,0x80007
			 ztest_unit_test(test_stack_thread2isr),
			 ztest_unit_test(test_stack_pop_fail),
			 ztest_user_unit_test(test_stack_user_pop_fail),
			 ztest_unit_test(test_stack_alloc_thread2thread));
	ztest_run_test_suite(stack_api);
}
8000099c:	00c12083          	lw	ra,12(sp)
800009a0:	c4478793          	addi	a5,a5,-956 # 80006c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c45>
800009a4:	06f52423          	sw	a5,104(a0)
	ztest_run_test_suite(stack_api);
800009a8:	800075b7          	lui	a1,0x80007
800009ac:	80006537          	lui	a0,0x80006
800009b0:	b5c58593          	addi	a1,a1,-1188 # 80006b5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b5d>
800009b4:	fa050513          	addi	a0,a0,-96 # 80005fa0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fa1>
}
800009b8:	01010113          	addi	sp,sp,16
	ztest_run_test_suite(stack_api);
800009bc:	79d0106f          	j	80002958 <z_ztest_run_test_suite>

800009c0 <tstack_push>:
struct k_thread thread_data;
static ZTEST_DMEM u32_t data[STACK_LEN] = { 0xABCD, 0x1234 };
struct k_sem end_sema;

static void tstack_push(struct k_stack *pstack)
{
800009c0:	ff010113          	addi	sp,sp,-16
800009c4:	00812423          	sw	s0,8(sp)
800009c8:	80007437          	lui	s0,0x80007
800009cc:	be840413          	addi	s0,s0,-1048 # 80006be8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be9>
800009d0:	00912223          	sw	s1,4(sp)
800009d4:	01212023          	sw	s2,0(sp)
800009d8:	00112623          	sw	ra,12(sp)
800009dc:	00050913          	mv	s2,a0
800009e0:	01040493          	addi	s1,s0,16

K_SYSCALL_DECLARE1(K_SYSCALL_K_QUEUE_PEEK_TAIL, k_queue_peek_tail, void *, struct k_queue *, queue)

K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_STACK_PUSH, k_stack_push, struct k_stack *, stack, u32_t, data)
800009e4:	00042583          	lw	a1,0(s0)
800009e8:	00090513          	mv	a0,s2
800009ec:	00440413          	addi	s0,s0,4
800009f0:	4a5030ef          	jal	ra,80004694 <z_impl_k_stack_push>
	for (int i = 0; i < STACK_LEN; i++) {
800009f4:	fe9418e3          	bne	s0,s1,800009e4 <tstack_push+0x24>
		/**TESTPOINT: stack push*/
		k_stack_push(pstack, data[i]);
	}
}
800009f8:	00c12083          	lw	ra,12(sp)
800009fc:	00812403          	lw	s0,8(sp)
80000a00:	00412483          	lw	s1,4(sp)
80000a04:	00012903          	lw	s2,0(sp)
80000a08:	01010113          	addi	sp,sp,16
80000a0c:	00008067          	ret

80000a10 <tIsr_entry_push>:
}

/*entry of contexts*/
static void tIsr_entry_push(void *p)
{
	tstack_push((struct k_stack *)p);
80000a10:	fb1ff06f          	j	800009c0 <tstack_push>

80000a14 <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000a14:	fd010113          	addi	sp,sp,-48
80000a18:	00112e23          	sw	ra,28(sp)
80000a1c:	00812c23          	sw	s0,24(sp)
80000a20:	03012423          	sw	a6,40(sp)
80000a24:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000a28:	04051663          	bnez	a0,80000a74 <z_zassert.constprop.0+0x60>
80000a2c:	00068613          	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a30:	80006537          	lui	a0,0x80006
80000a34:	00070693          	mv	a3,a4
80000a38:	00058713          	mv	a4,a1
80000a3c:	800065b7          	lui	a1,0x80006
80000a40:	00078413          	mv	s0,a5
80000a44:	07858593          	addi	a1,a1,120 # 80006078 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006079>
		va_start(vargs, msg);
80000a48:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a4c:	0b450513          	addi	a0,a0,180 # 800060b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060b5>
		va_start(vargs, msg);
80000a50:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000a54:	718010ef          	jal	ra,8000216c <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000a58:	00c12583          	lw	a1,12(sp)
80000a5c:	00040513          	mv	a0,s0
80000a60:	6dc010ef          	jal	ra,8000213c <vprintk>
		printk("\n");
80000a64:	80006537          	lui	a0,0x80006
80000a68:	2f050513          	addi	a0,a0,752 # 800062f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f1>
80000a6c:	700010ef          	jal	ra,8000216c <printk>
		va_end(vargs);
		ztest_test_fail();
80000a70:	689010ef          	jal	ra,800028f8 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000a74:	01c12083          	lw	ra,28(sp)
80000a78:	01812403          	lw	s0,24(sp)
80000a7c:	03010113          	addi	sp,sp,48
80000a80:	00008067          	ret

80000a84 <tstack_pop>:
{
80000a84:	fc010113          	addi	sp,sp,-64
80000a88:	02812c23          	sw	s0,56(sp)
80000a8c:	80007437          	lui	s0,0x80007
80000a90:	be840413          	addi	s0,s0,-1048 # 80006be8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be9>
80000a94:	02912a23          	sw	s1,52(sp)
80000a98:	03212823          	sw	s2,48(sp)
80000a9c:	03312623          	sw	s3,44(sp)
80000aa0:	03412423          	sw	s4,40(sp)
80000aa4:	03512223          	sw	s5,36(sp)
80000aa8:	03612023          	sw	s6,32(sp)
80000aac:	01712e23          	sw	s7,28(sp)
80000ab0:	02112e23          	sw	ra,60(sp)
80000ab4:	00050b93          	mv	s7,a0
80000ab8:	ff040a13          	addi	s4,s0,-16
		zassert_false(k_stack_pop(pstack, &rx_data, K_NO_WAIT), NULL);
80000abc:	80006937          	lui	s2,0x80006
80000ac0:	800069b7          	lui	s3,0x80006
80000ac4:	800064b7          	lui	s1,0x80006
80000ac8:	80006b37          	lui	s6,0x80006
		zassert_equal(rx_data, data[i], NULL);
80000acc:	80006ab7          	lui	s5,0x80006

K_SYSCALL_DECLARE3(K_SYSCALL_K_STACK_POP, k_stack_pop, int, struct k_stack *, stack, u32_t *, data, s32_t, timeout)
80000ad0:	00000613          	li	a2,0
80000ad4:	00c10593          	addi	a1,sp,12
80000ad8:	000b8513          	mv	a0,s7
80000adc:	54d030ef          	jal	ra,80004828 <z_impl_k_stack_pop>
		zassert_false(k_stack_pop(pstack, &rx_data, K_NO_WAIT), NULL);
80000ae0:	1f098793          	addi	a5,s3,496 # 800061f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f1>
80000ae4:	fac90713          	addi	a4,s2,-84 # 80005fac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fad>
80000ae8:	02400693          	li	a3,36
80000aec:	07848613          	addi	a2,s1,120 # 80006078 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006079>
80000af0:	024b0593          	addi	a1,s6,36 # 80006024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006025>
80000af4:	00153513          	seqz	a0,a0
80000af8:	f1dff0ef          	jal	ra,80000a14 <z_zassert.constprop.0>
		zassert_equal(rx_data, data[i], NULL);
80000afc:	00c42503          	lw	a0,12(s0)
80000b00:	00c12783          	lw	a5,12(sp)
80000b04:	fac90713          	addi	a4,s2,-84
80000b08:	02500693          	li	a3,37
80000b0c:	40f50533          	sub	a0,a0,a5
80000b10:	07848613          	addi	a2,s1,120
80000b14:	1f098793          	addi	a5,s3,496
80000b18:	058a8593          	addi	a1,s5,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80000b1c:	00153513          	seqz	a0,a0
80000b20:	ffc40413          	addi	s0,s0,-4
80000b24:	ef1ff0ef          	jal	ra,80000a14 <z_zassert.constprop.0>
	for (int i = STACK_LEN - 1; i >= 0; i--) {
80000b28:	fb4414e3          	bne	s0,s4,80000ad0 <tstack_pop+0x4c>
}
80000b2c:	03c12083          	lw	ra,60(sp)
80000b30:	03812403          	lw	s0,56(sp)
80000b34:	03412483          	lw	s1,52(sp)
80000b38:	03012903          	lw	s2,48(sp)
80000b3c:	02c12983          	lw	s3,44(sp)
80000b40:	02812a03          	lw	s4,40(sp)
80000b44:	02412a83          	lw	s5,36(sp)
80000b48:	02012b03          	lw	s6,32(sp)
80000b4c:	01c12b83          	lw	s7,28(sp)
80000b50:	04010113          	addi	sp,sp,64
80000b54:	00008067          	ret

80000b58 <tThread_entry>:
{
	tstack_pop((struct k_stack *)p);
}

static void tThread_entry(void *p1, void *p2, void *p3)
{
80000b58:	ff010113          	addi	sp,sp,-16
80000b5c:	00112623          	sw	ra,12(sp)
80000b60:	00812423          	sw	s0,8(sp)
80000b64:	00912223          	sw	s1,4(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b68:	80007437          	lui	s0,0x80007
80000b6c:	00050493          	mv	s1,a0
	tstack_pop((struct k_stack *)p1);
80000b70:	f15ff0ef          	jal	ra,80000a84 <tstack_pop>
80000b74:	e1040513          	addi	a0,s0,-496 # 80006e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e11>
80000b78:	774030ef          	jal	ra,800042ec <z_impl_k_sem_give>
	k_sem_give(&end_sema);
	tstack_push((struct k_stack *)p1);
80000b7c:	00048513          	mv	a0,s1
80000b80:	e41ff0ef          	jal	ra,800009c0 <tstack_push>
80000b84:	e1040513          	addi	a0,s0,-496
	k_sem_give(&end_sema);
}
80000b88:	00812403          	lw	s0,8(sp)
80000b8c:	00c12083          	lw	ra,12(sp)
80000b90:	00412483          	lw	s1,4(sp)
80000b94:	01010113          	addi	sp,sp,16
80000b98:	7540306f          	j	800042ec <z_impl_k_sem_give>

80000b9c <tIsr_entry_pop>:
	tstack_pop((struct k_stack *)p);
80000b9c:	ee9ff06f          	j	80000a84 <tstack_pop>

80000ba0 <tstack_thread_isr>:
	/* clear the spawn thread to avoid side effect */
	k_thread_abort(tid);
}

static void tstack_thread_isr(struct k_stack *pstack)
{
80000ba0:	ff010113          	addi	sp,sp,-16
80000ba4:	00812423          	sw	s0,8(sp)
80000ba8:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000bac:	80007537          	lui	a0,0x80007
80000bb0:	00100613          	li	a2,1
80000bb4:	00000593          	li	a1,0
80000bb8:	e1050513          	addi	a0,a0,-496 # 80006e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e11>
80000bbc:	00112623          	sw	ra,12(sp)
80000bc0:	664030ef          	jal	ra,80004224 <z_impl_k_sem_init>
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: thread-isr data passing via stack*/
	irq_offload(tIsr_entry_push, pstack);
80000bc4:	80001537          	lui	a0,0x80001
80000bc8:	00040593          	mv	a1,s0
80000bcc:	a1050513          	addi	a0,a0,-1520 # 80000a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a11>
80000bd0:	5cc000ef          	jal	ra,8000119c <irq_offload>
	tstack_pop(pstack);
80000bd4:	00040513          	mv	a0,s0
80000bd8:	eadff0ef          	jal	ra,80000a84 <tstack_pop>

	tstack_push(pstack);
80000bdc:	00040513          	mv	a0,s0
80000be0:	de1ff0ef          	jal	ra,800009c0 <tstack_push>
	irq_offload(tIsr_entry_pop, pstack);
80000be4:	00040593          	mv	a1,s0
}
80000be8:	00812403          	lw	s0,8(sp)
80000bec:	00c12083          	lw	ra,12(sp)
	irq_offload(tIsr_entry_pop, pstack);
80000bf0:	80001537          	lui	a0,0x80001
80000bf4:	b9c50513          	addi	a0,a0,-1124 # 80000b9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b9d>
}
80000bf8:	01010113          	addi	sp,sp,16
	irq_offload(tIsr_entry_pop, pstack);
80000bfc:	5a00006f          	j	8000119c <irq_offload>

80000c00 <tstack_thread_thread>:
{
80000c00:	fe010113          	addi	sp,sp,-32
80000c04:	00912a23          	sw	s1,20(sp)
80000c08:	800074b7          	lui	s1,0x80007
80000c0c:	00812c23          	sw	s0,24(sp)
80000c10:	00100613          	li	a2,1
80000c14:	00050413          	mv	s0,a0
80000c18:	00000593          	li	a1,0
80000c1c:	e1048513          	addi	a0,s1,-496 # 80006e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e11>
80000c20:	00112e23          	sw	ra,28(sp)
80000c24:	01212823          	sw	s2,16(sp)
80000c28:	5fc030ef          	jal	ra,80004224 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000c2c:	00c00793          	li	a5,12
80000c30:	800016b7          	lui	a3,0x80001
80000c34:	800075b7          	lui	a1,0x80007
80000c38:	80007537          	lui	a0,0x80007
80000c3c:	00040713          	mv	a4,s0
80000c40:	00000893          	li	a7,0
80000c44:	00000813          	li	a6,0
80000c48:	b5868693          	addi	a3,a3,-1192 # 80000b58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b59>
80000c4c:	20000613          	li	a2,512
80000c50:	00f12023          	sw	a5,0(sp)
80000c54:	04058593          	addi	a1,a1,64 # 80007040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007041>
80000c58:	00000793          	li	a5,0
80000c5c:	00012223          	sw	zero,4(sp)
80000c60:	e3c50513          	addi	a0,a0,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
80000c64:	050040ef          	jal	ra,80004cb4 <z_impl_k_thread_create>
80000c68:	00050913          	mv	s2,a0
	tstack_push(pstack);
80000c6c:	00040513          	mv	a0,s0
80000c70:	d51ff0ef          	jal	ra,800009c0 <tstack_push>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000c74:	fff00593          	li	a1,-1
80000c78:	e1048513          	addi	a0,s1,-496
80000c7c:	754030ef          	jal	ra,800043d0 <z_impl_k_sem_take>
80000c80:	fff00593          	li	a1,-1
80000c84:	e1048513          	addi	a0,s1,-496
80000c88:	748030ef          	jal	ra,800043d0 <z_impl_k_sem_take>
	tstack_pop(pstack);
80000c8c:	00040513          	mv	a0,s0
80000c90:	df5ff0ef          	jal	ra,80000a84 <tstack_pop>
}
80000c94:	01812403          	lw	s0,24(sp)
80000c98:	01c12083          	lw	ra,28(sp)
80000c9c:	01412483          	lw	s1,20(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000ca0:	00090513          	mv	a0,s2
80000ca4:	01012903          	lw	s2,16(sp)
80000ca8:	02010113          	addi	sp,sp,32
80000cac:	1ac0406f          	j	80004e58 <z_impl_k_thread_abort>

80000cb0 <test_stack_thread2thread>:
/**
 * @brief Test to verify data passing between threads via stack
 * @see k_stack_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop()
 */
void test_stack_thread2thread(void)
{
80000cb0:	ff010113          	addi	sp,sp,-16
80000cb4:	00812423          	sw	s0,8(sp)
	/**TESTPOINT: test k_stack_init stack*/
	k_stack_init(&stack, data, STACK_LEN);
80000cb8:	800075b7          	lui	a1,0x80007
80000cbc:	80007437          	lui	s0,0x80007
80000cc0:	e2040513          	addi	a0,s0,-480 # 80006e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e21>
80000cc4:	00400613          	li	a2,4
80000cc8:	be858593          	addi	a1,a1,-1048 # 80006be8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be9>
{
80000ccc:	00112623          	sw	ra,12(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000cd0:	0c9030ef          	jal	ra,80004598 <k_stack_init>
	tstack_thread_thread(&stack);
80000cd4:	e2040513          	addi	a0,s0,-480
80000cd8:	f29ff0ef          	jal	ra,80000c00 <tstack_thread_thread>

	/**TESTPOINT: test K_STACK_DEFINE stack*/
	tstack_thread_thread(&kstack);
}
80000cdc:	00812403          	lw	s0,8(sp)
80000ce0:	00c12083          	lw	ra,12(sp)
	tstack_thread_thread(&kstack);
80000ce4:	80007537          	lui	a0,0x80007
80000ce8:	c7450513          	addi	a0,a0,-908 # 80006c74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c75>
}
80000cec:	01010113          	addi	sp,sp,16
	tstack_thread_thread(&kstack);
80000cf0:	f11ff06f          	j	80000c00 <tstack_thread_thread>

80000cf4 <test_stack_thread2isr>:
/**
 * @brief Verifies data passing between thread and ISR via stack
 * @see k_stack_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop()
 */
void test_stack_thread2isr(void)
{
80000cf4:	ff010113          	addi	sp,sp,-16
80000cf8:	00812423          	sw	s0,8(sp)
	/**TESTPOINT: test k_stack_init stack*/
	k_stack_init(&stack, data, STACK_LEN);
80000cfc:	800075b7          	lui	a1,0x80007
80000d00:	80007437          	lui	s0,0x80007
80000d04:	e2040513          	addi	a0,s0,-480 # 80006e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e21>
80000d08:	00400613          	li	a2,4
80000d0c:	be858593          	addi	a1,a1,-1048 # 80006be8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006be9>
{
80000d10:	00112623          	sw	ra,12(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000d14:	085030ef          	jal	ra,80004598 <k_stack_init>
	tstack_thread_isr(&stack);
80000d18:	e2040513          	addi	a0,s0,-480
80000d1c:	e85ff0ef          	jal	ra,80000ba0 <tstack_thread_isr>

	/**TESTPOINT: test K_STACK_DEFINE stack*/
	tstack_thread_isr(&kstack);
}
80000d20:	00812403          	lw	s0,8(sp)
80000d24:	00c12083          	lw	ra,12(sp)
	tstack_thread_isr(&kstack);
80000d28:	80007537          	lui	a0,0x80007
80000d2c:	c7450513          	addi	a0,a0,-908 # 80006c74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c75>
}
80000d30:	01010113          	addi	sp,sp,16
	tstack_thread_isr(&kstack);
80000d34:	e6dff06f          	j	80000ba0 <tstack_thread_isr>

80000d38 <test_stack_alloc_thread2thread>:
/**
 * @see k_stack_alloc_init(), k_stack_push(), #K_STACK_DEFINE(x), k_stack_pop(),
 * k_stack_cleanup()
 */
void test_stack_alloc_thread2thread(void)
{
80000d38:	fe010113          	addi	sp,sp,-32
80000d3c:	00812c23          	sw	s0,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000d40:	80007437          	lui	s0,0x80007
80000d44:	00400593          	li	a1,4
80000d48:	c9040513          	addi	a0,s0,-880 # 80006c90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c91>
80000d4c:	00112e23          	sw	ra,28(sp)
80000d50:	00912a23          	sw	s1,20(sp)
80000d54:	01212823          	sw	s2,16(sp)
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000d58:	800074b7          	lui	s1,0x80007
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000d5c:	061030ef          	jal	ra,800045bc <z_impl_k_stack_alloc_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000d60:	e1048513          	addi	a0,s1,-496 # 80006e10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e11>
80000d64:	00100613          	li	a2,1
80000d68:	00000593          	li	a1,0
80000d6c:	4b8030ef          	jal	ra,80004224 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000d70:	800016b7          	lui	a3,0x80001
80000d74:	800075b7          	lui	a1,0x80007
80000d78:	80007537          	lui	a0,0x80007
80000d7c:	c9040713          	addi	a4,s0,-880
80000d80:	00000793          	li	a5,0
80000d84:	b5868693          	addi	a3,a3,-1192 # 80000b58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b59>
80000d88:	20000613          	li	a2,512
80000d8c:	00000893          	li	a7,0
80000d90:	00000813          	li	a6,0
80000d94:	04058593          	addi	a1,a1,64 # 80007040 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007041>
80000d98:	00012223          	sw	zero,4(sp)
80000d9c:	00012023          	sw	zero,0(sp)
80000da0:	e3c50513          	addi	a0,a0,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
80000da4:	711030ef          	jal	ra,80004cb4 <z_impl_k_thread_create>
80000da8:	00050913          	mv	s2,a0
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: thread-thread data passing via stack*/
	k_tid_t tid = k_thread_create(&thread_data, threadstack, STACK_SIZE,
					tThread_entry, &kstack_test_alloc,
					NULL, NULL, K_PRIO_PREEMPT(0), 0, 0);
	tstack_push(&kstack_test_alloc);
80000dac:	c9040513          	addi	a0,s0,-880
80000db0:	c11ff0ef          	jal	ra,800009c0 <tstack_push>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000db4:	fff00593          	li	a1,-1
80000db8:	e1048513          	addi	a0,s1,-496
80000dbc:	614030ef          	jal	ra,800043d0 <z_impl_k_sem_take>
80000dc0:	fff00593          	li	a1,-1
80000dc4:	e1048513          	addi	a0,s1,-496
80000dc8:	608030ef          	jal	ra,800043d0 <z_impl_k_sem_take>
	k_sem_take(&end_sema, K_FOREVER);

	k_sem_take(&end_sema, K_FOREVER);
	tstack_pop(&kstack_test_alloc);
80000dcc:	c9040513          	addi	a0,s0,-880
80000dd0:	cb5ff0ef          	jal	ra,80000a84 <tstack_pop>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000dd4:	00090513          	mv	a0,s2
80000dd8:	080040ef          	jal	ra,80004e58 <z_impl_k_thread_abort>

	/* clear the spawn thread to avoid side effect */
	k_thread_abort(tid);
	k_stack_cleanup(&kstack_test_alloc);
80000ddc:	c9040513          	addi	a0,s0,-880
80000de0:	031030ef          	jal	ra,80004610 <k_stack_cleanup>
K_SYSCALL_DECLARE2(K_SYSCALL_K_STACK_ALLOC_INIT, k_stack_alloc_init, s32_t, struct k_stack *, stack, u32_t, num_entries)
80000de4:	10100593          	li	a1,257
80000de8:	c9040513          	addi	a0,s0,-880
80000dec:	7d0030ef          	jal	ra,800045bc <z_impl_k_stack_alloc_init>

	/** Requested buffer allocation from the test pool.*/
	ret = k_stack_alloc_init(&kstack_test_alloc, (STACK_SIZE/2)+1);
	zassert_true(ret == -ENOMEM,
			"resource pool is smaller then requested buffer");
}
80000df0:	01812403          	lw	s0,24(sp)
80000df4:	01c12083          	lw	ra,28(sp)
80000df8:	01412483          	lw	s1,20(sp)
80000dfc:	01012903          	lw	s2,16(sp)
	zassert_true(ret == -ENOMEM,
80000e00:	00c50513          	addi	a0,a0,12
80000e04:	800067b7          	lui	a5,0x80006
80000e08:	80006737          	lui	a4,0x80006
80000e0c:	80006637          	lui	a2,0x80006
80000e10:	800065b7          	lui	a1,0x80006
80000e14:	fd878793          	addi	a5,a5,-40 # 80005fd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fd9>
80000e18:	fb870713          	addi	a4,a4,-72 # 80005fb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb9>
80000e1c:	0a700693          	li	a3,167
80000e20:	07860613          	addi	a2,a2,120 # 80006078 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006079>
80000e24:	00858593          	addi	a1,a1,8 # 80006008 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006009>
80000e28:	00153513          	seqz	a0,a0
}
80000e2c:	02010113          	addi	sp,sp,32
	zassert_true(ret == -ENOMEM,
80000e30:	be5ff06f          	j	80000a14 <z_zassert.constprop.0>

80000e34 <z_zassert.constprop.1>:
static inline void z_zassert(int cond,
80000e34:	fd010113          	addi	sp,sp,-48
80000e38:	00112e23          	sw	ra,28(sp)
80000e3c:	03012423          	sw	a6,40(sp)
80000e40:	03112623          	sw	a7,44(sp)
	if (!(cond)) {
80000e44:	04051863          	bnez	a0,80000e94 <z_zassert.constprop.1+0x60>
80000e48:	00068613          	mv	a2,a3
80000e4c:	00058713          	mv	a4,a1
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000e50:	800066b7          	lui	a3,0x80006
80000e54:	800065b7          	lui	a1,0x80006
80000e58:	80006537          	lui	a0,0x80006
		va_start(vargs, msg);
80000e5c:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000e60:	0dc68693          	addi	a3,a3,220 # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
80000e64:	16458593          	addi	a1,a1,356 # 80006164 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006165>
80000e68:	0b450513          	addi	a0,a0,180 # 800060b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060b5>
		va_start(vargs, msg);
80000e6c:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000e70:	2fc010ef          	jal	ra,8000216c <printk>
		vprintk(msg, vargs);
80000e74:	00c12583          	lw	a1,12(sp)
80000e78:	80006537          	lui	a0,0x80006
80000e7c:	1f050513          	addi	a0,a0,496 # 800061f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f1>
80000e80:	2bc010ef          	jal	ra,8000213c <vprintk>
		printk("\n");
80000e84:	80006537          	lui	a0,0x80006
80000e88:	2f050513          	addi	a0,a0,752 # 800062f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f1>
80000e8c:	2e0010ef          	jal	ra,8000216c <printk>
		ztest_test_fail();
80000e90:	269010ef          	jal	ra,800028f8 <ztest_test_fail>
}
80000e94:	01c12083          	lw	ra,28(sp)
80000e98:	03010113          	addi	sp,sp,48
80000e9c:	00008067          	ret

80000ea0 <test_stack_pop_fail>:
/**
 * @brief Verifies stack pop functionality
 * @see k_stack_init(), k_stack_pop()
 */
void test_stack_pop_fail(void)
{
80000ea0:	fd010113          	addi	sp,sp,-48
80000ea4:	02812423          	sw	s0,40(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000ea8:	800075b7          	lui	a1,0x80007
80000eac:	80007437          	lui	s0,0x80007
80000eb0:	e2040513          	addi	a0,s0,-480 # 80006e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e21>
80000eb4:	00200613          	li	a2,2
80000eb8:	cc058593          	addi	a1,a1,-832 # 80006cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cc1>
{
80000ebc:	02112623          	sw	ra,44(sp)
80000ec0:	02912223          	sw	s1,36(sp)
80000ec4:	03212023          	sw	s2,32(sp)
80000ec8:	01312e23          	sw	s3,28(sp)
	k_stack_init(&stack, data, STACK_LEN);
80000ecc:	6cc030ef          	jal	ra,80004598 <k_stack_init>
K_SYSCALL_DECLARE3(K_SYSCALL_K_STACK_POP, k_stack_pop, int, struct k_stack *, stack, u32_t *, data, s32_t, timeout)
80000ed0:	00c10593          	addi	a1,sp,12
80000ed4:	00000613          	li	a2,0
80000ed8:	e2040513          	addi	a0,s0,-480
80000edc:	14d030ef          	jal	ra,80004828 <z_impl_k_stack_pop>
	zassert_equal(k_stack_pop(stack, &rx_data, K_NO_WAIT), -EBUSY, NULL);
80000ee0:	80006937          	lui	s2,0x80006
80000ee4:	800069b7          	lui	s3,0x80006
80000ee8:	800064b7          	lui	s1,0x80006
80000eec:	01050513          	addi	a0,a0,16
80000ef0:	800065b7          	lui	a1,0x80006
80000ef4:	1f098793          	addi	a5,s3,496 # 800061f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f1>
80000ef8:	0dc90713          	addi	a4,s2,220 # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
80000efc:	01500693          	li	a3,21
80000f00:	16448613          	addi	a2,s1,356 # 80006164 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006165>
80000f04:	0ec58593          	addi	a1,a1,236 # 800060ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060ed>
80000f08:	00153513          	seqz	a0,a0
80000f0c:	f29ff0ef          	jal	ra,80000e34 <z_zassert.constprop.1>
80000f10:	00c10593          	addi	a1,sp,12
80000f14:	06400613          	li	a2,100
80000f18:	e2040513          	addi	a0,s0,-480
80000f1c:	10d030ef          	jal	ra,80004828 <z_impl_k_stack_pop>
	zassert_equal(k_stack_pop(stack, &rx_data, TIMEOUT), -EAGAIN, NULL);
80000f20:	00b50513          	addi	a0,a0,11
80000f24:	800065b7          	lui	a1,0x80006
80000f28:	1f098793          	addi	a5,s3,496
80000f2c:	0dc90713          	addi	a4,s2,220
80000f30:	16448613          	addi	a2,s1,356
80000f34:	01700693          	li	a3,23
80000f38:	12858593          	addi	a1,a1,296 # 80006128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006129>
80000f3c:	00153513          	seqz	a0,a0
80000f40:	ef5ff0ef          	jal	ra,80000e34 <z_zassert.constprop.1>

	stack_pop_fail(&stack);
}
80000f44:	02c12083          	lw	ra,44(sp)
80000f48:	02812403          	lw	s0,40(sp)
80000f4c:	02412483          	lw	s1,36(sp)
80000f50:	02012903          	lw	s2,32(sp)
80000f54:	01c12983          	lw	s3,28(sp)
80000f58:	03010113          	addi	sp,sp,48
80000f5c:	00008067          	ret

80000f60 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000f60:	ff010113          	addi	sp,sp,-16
80000f64:	00112623          	sw	ra,12(sp)
80000f68:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000f6c:	00600793          	li	a5,6
80000f70:	02f50463          	beq	a0,a5,80000f98 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000f74:	26d030ef          	jal	ra,800049e0 <k_is_in_isr>
80000f78:	02050463          	beqz	a0,80000fa0 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000f7c:	265030ef          	jal	ra,800049e0 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000f80:	04051663          	bnez	a0,80000fcc <z_SysFatalErrorHandler+0x6c>
80000f84:	800065b7          	lui	a1,0x80006
80000f88:	44c58593          	addi	a1,a1,1100 # 8000644c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000644d>
80000f8c:	80006537          	lui	a0,0x80006
80000f90:	46050513          	addi	a0,a0,1120 # 80006460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006461>
80000f94:	1d8010ef          	jal	ra,8000216c <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000f98:	244010ef          	jal	ra,800021dc <k_cpu_idle>
80000f9c:	ffdff06f          	j	80000f98 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000fa0:	251030ef          	jal	ra,800049f0 <z_is_thread_essential>
80000fa4:	fc051ce3          	bnez	a0,80000f7c <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000fa8:	80007437          	lui	s0,0x80007
80000fac:	00c40413          	addi	s0,s0,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80000fb0:	00842583          	lw	a1,8(s0)
80000fb4:	80006537          	lui	a0,0x80006
80000fb8:	48050513          	addi	a0,a0,1152 # 80006480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006481>
80000fbc:	1b0010ef          	jal	ra,8000216c <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000fc0:	00842503          	lw	a0,8(s0)
80000fc4:	695030ef          	jal	ra,80004e58 <z_impl_k_thread_abort>
80000fc8:	fd1ff06f          	j	80000f98 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000fcc:	800065b7          	lui	a1,0x80006
80000fd0:	44858593          	addi	a1,a1,1096 # 80006448 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006449>
80000fd4:	fb9ff06f          	j	80000f8c <z_SysFatalErrorHandler+0x2c>

80000fd8 <z_NanoFatalErrorHandler>:
{
80000fd8:	fb010113          	addi	sp,sp,-80
80000fdc:	04812423          	sw	s0,72(sp)
80000fe0:	04912223          	sw	s1,68(sp)
80000fe4:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000fe8:	00600793          	li	a5,6
{
80000fec:	00050493          	mv	s1,a0
80000ff0:	00058413          	mv	s0,a1
	switch (reason) {
80000ff4:	0ea7e063          	bltu	a5,a0,800010d4 <z_NanoFatalErrorHandler+0xfc>
80000ff8:	80006737          	lui	a4,0x80006
80000ffc:	00251793          	slli	a5,a0,0x2
80001000:	19c70713          	addi	a4,a4,412 # 8000619c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000619d>
80001004:	00e787b3          	add	a5,a5,a4
80001008:	0007a783          	lw	a5,0(a5)
8000100c:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80001010:	80006537          	lui	a0,0x80006
80001014:	2cc50513          	addi	a0,a0,716 # 800062cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062cd>
		printk("***** Kernel OOPS! *****\n");
80001018:	154010ef          	jal	ra,8000216c <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000101c:	1fc030ef          	jal	ra,80004218 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80001020:	04442783          	lw	a5,68(s0)
80001024:	01042883          	lw	a7,16(s0)
80001028:	00c42803          	lw	a6,12(s0)
8000102c:	02f12823          	sw	a5,48(sp)
80001030:	04042783          	lw	a5,64(s0)
80001034:	00442703          	lw	a4,4(s0)
80001038:	00042683          	lw	a3,0(s0)
8000103c:	02f12623          	sw	a5,44(sp)
80001040:	03c42783          	lw	a5,60(s0)
80001044:	04842603          	lw	a2,72(s0)
80001048:	00050593          	mv	a1,a0
8000104c:	02f12423          	sw	a5,40(sp)
80001050:	03842783          	lw	a5,56(s0)
80001054:	80006537          	lui	a0,0x80006
80001058:	35050513          	addi	a0,a0,848 # 80006350 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006351>
8000105c:	02f12223          	sw	a5,36(sp)
80001060:	03442783          	lw	a5,52(s0)
80001064:	02f12023          	sw	a5,32(sp)
80001068:	03042783          	lw	a5,48(s0)
8000106c:	00f12e23          	sw	a5,28(sp)
80001070:	02c42783          	lw	a5,44(s0)
80001074:	00f12c23          	sw	a5,24(sp)
80001078:	02842783          	lw	a5,40(s0)
8000107c:	00f12a23          	sw	a5,20(sp)
80001080:	02442783          	lw	a5,36(s0)
80001084:	00f12823          	sw	a5,16(sp)
80001088:	02042783          	lw	a5,32(s0)
8000108c:	00f12623          	sw	a5,12(sp)
80001090:	01c42783          	lw	a5,28(s0)
80001094:	00f12423          	sw	a5,8(sp)
80001098:	01842783          	lw	a5,24(s0)
8000109c:	00f12223          	sw	a5,4(sp)
800010a0:	01442783          	lw	a5,20(s0)
800010a4:	00f12023          	sw	a5,0(sp)
800010a8:	00842783          	lw	a5,8(s0)
800010ac:	0c0010ef          	jal	ra,8000216c <printk>
	z_SysFatalErrorHandler(reason, esf);
800010b0:	00040593          	mv	a1,s0
800010b4:	00048513          	mv	a0,s1
800010b8:	ea9ff0ef          	jal	ra,80000f60 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
800010bc:	80006537          	lui	a0,0x80006
800010c0:	2f450513          	addi	a0,a0,756 # 800062f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800062f5>
800010c4:	f55ff06f          	j	80001018 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
800010c8:	80006537          	lui	a0,0x80006
800010cc:	31050513          	addi	a0,a0,784 # 80006310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006311>
800010d0:	f49ff06f          	j	80001018 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
800010d4:	80006537          	lui	a0,0x80006
800010d8:	00048593          	mv	a1,s1
800010dc:	32c50513          	addi	a0,a0,812 # 8000632c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000632d>
800010e0:	08c010ef          	jal	ra,8000216c <printk>
		break;
800010e4:	f39ff06f          	j	8000101c <z_NanoFatalErrorHandler+0x44>

800010e8 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
800010e8:	ff010113          	addi	sp,sp,-16
800010ec:	00812423          	sw	s0,8(sp)
800010f0:	00112623          	sw	ra,12(sp)
800010f4:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
800010f8:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
800010fc:	00161613          	slli	a2,a2,0x1
80001100:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80001104:	00500793          	li	a5,5
80001108:	02c7e863          	bltu	a5,a2,80001138 <_Fault+0x50>
8000110c:	80006737          	lui	a4,0x80006
80001110:	00261793          	slli	a5,a2,0x2
80001114:	1b870713          	addi	a4,a4,440 # 800061b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061b9>
80001118:	00f707b3          	add	a5,a4,a5
8000111c:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001120:	80006537          	lui	a0,0x80006
80001124:	1d850513          	addi	a0,a0,472 # 800061d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061d9>
80001128:	044010ef          	jal	ra,8000216c <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
8000112c:	00040593          	mv	a1,s0
80001130:	00000513          	li	a0,0
80001134:	ea5ff0ef          	jal	ra,80000fd8 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80001138:	800065b7          	lui	a1,0x80006
8000113c:	1d058593          	addi	a1,a1,464 # 800061d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061d1>
80001140:	fe1ff06f          	j	80001120 <_Fault+0x38>

80001144 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80001144:	ff010113          	addi	sp,sp,-16
80001148:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
8000114c:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001150:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80001154:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001158:	0015d593          	srli	a1,a1,0x1
8000115c:	4a850513          	addi	a0,a0,1192 # 800064a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064a9>
80001160:	00c010ef          	jal	ra,8000216c <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80001164:	800065b7          	lui	a1,0x80006
80001168:	1f458593          	addi	a1,a1,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
8000116c:	00400513          	li	a0,4
80001170:	e69ff0ef          	jal	ra,80000fd8 <z_NanoFatalErrorHandler>

80001174 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80001174:	800077b7          	lui	a5,0x80007
80001178:	cc878793          	addi	a5,a5,-824 # 80006cc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cc9>
8000117c:	0007a703          	lw	a4,0(a5)
80001180:	00070c63          	beqz	a4,80001198 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80001184:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80001188:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
8000118c:	800077b7          	lui	a5,0x80007
80001190:	ccc7a503          	lw	a0,-820(a5) # 80006ccc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ccd>
80001194:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80001198:	00008067          	ret

8000119c <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
8000119c:	00800793          	li	a5,8
800011a0:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
800011a4:	80007737          	lui	a4,0x80007
800011a8:	cca72423          	sw	a0,-824(a4) # 80006cc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cc9>
	offload_param = parameter;
800011ac:	80007737          	lui	a4,0x80007
800011b0:	ccb72623          	sw	a1,-820(a4) # 80006ccc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ccd>

	__asm__ volatile ("ecall");
800011b4:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
800011b8:	0087f793          	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
800011bc:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
800011c0:	00008067          	ret

800011c4 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
800011c4:	ff010113          	addi	sp,sp,-16
800011c8:	00112623          	sw	ra,12(sp)
	z_bss_zero();
800011cc:	341010ef          	jal	ra,80002d0c <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
800011d0:	02c010ef          	jal	ra,800021fc <soc_interrupt_init>
#endif
	z_cstart();
800011d4:	3a5010ef          	jal	ra,80002d78 <z_cstart>

800011d8 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
800011d8:	00007117          	auipc	sp,0x7
800011dc:	86810113          	addi	sp,sp,-1944 # 80007a40 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
800011e0:	000012b7          	lui	t0,0x1
800011e4:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
800011e8:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
800011ec:	fd9ff0ef          	jal	ra,800011c4 <_PrepC>

800011f0 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
800011f0:	1110006f          	j	80001b00 <z_thread_entry>

800011f4 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
800011f4:	fd010113          	addi	sp,sp,-48
800011f8:	02812423          	sw	s0,40(sp)
800011fc:	02912223          	sw	s1,36(sp)
80001200:	03212023          	sw	s2,32(sp)
80001204:	01312e23          	sw	s3,28(sp)
80001208:	01412c23          	sw	s4,24(sp)
8000120c:	01512a23          	sw	s5,20(sp)
80001210:	01612823          	sw	s6,16(sp)
80001214:	01712623          	sw	s7,12(sp)
80001218:	00078b13          	mv	s6,a5
8000121c:	02112623          	sw	ra,44(sp)
80001220:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001224:	00f00793          	li	a5,15
{
80001228:	00050493          	mv	s1,a0
8000122c:	00058413          	mv	s0,a1
80001230:	00060993          	mv	s3,a2
80001234:	00068a13          	mv	s4,a3
80001238:	00070b93          	mv	s7,a4
8000123c:	00080a93          	mv	s5,a6
80001240:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001244:	08f89a63          	bne	a7,a5,800012d8 <z_new_thread+0xe4>
80001248:	800037b7          	lui	a5,0x80003
8000124c:	cd478793          	addi	a5,a5,-812 # 80002cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002cd5>
80001250:	08f69a63          	bne	a3,a5,800012e4 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80001254:	03012683          	lw	a3,48(sp)
80001258:	00090593          	mv	a1,s2
8000125c:	00048513          	mv	a0,s1
80001260:	00400613          	li	a2,4
80001264:	051030ef          	jal	ra,80004ab4 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80001268:	fb098593          	addi	a1,s3,-80
8000126c:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001270:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80001274:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001278:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
8000127c:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001280:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80001284:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001288:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
8000128c:	02c12083          	lw	ra,44(sp)
80001290:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001294:	1f078793          	addi	a5,a5,496 # 800011f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800011f1>
	stack_init->a0 = (u32_t)thread_func;
80001298:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
8000129c:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
800012a0:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
800012a4:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800012a8:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
800012ac:	02b4a423          	sw	a1,40(s1)
}
800012b0:	02012903          	lw	s2,32(sp)
800012b4:	02412483          	lw	s1,36(sp)
800012b8:	01c12983          	lw	s3,28(sp)
800012bc:	01812a03          	lw	s4,24(sp)
800012c0:	01412a83          	lw	s5,20(sp)
800012c4:	01012b03          	lw	s6,16(sp)
800012c8:	00c12b83          	lw	s7,12(sp)
800012cc:	00812c03          	lw	s8,8(sp)
800012d0:	03010113          	addi	sp,sp,48
800012d4:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800012d8:	01088693          	addi	a3,a7,16
800012dc:	01e00793          	li	a5,30
800012e0:	f6d7fae3          	bgeu	a5,a3,80001254 <z_new_thread+0x60>
800012e4:	80006c37          	lui	s8,0x80006
800012e8:	800065b7          	lui	a1,0x80006
800012ec:	80006537          	lui	a0,0x80006
800012f0:	4d0c0613          	addi	a2,s8,1232 # 800064d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064d1>
800012f4:	01800693          	li	a3,24
800012f8:	4f058593          	addi	a1,a1,1264 # 800064f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f1>
800012fc:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80001300:	66d000ef          	jal	ra,8000216c <printk>
80001304:	80006537          	lui	a0,0x80006
80001308:	00090593          	mv	a1,s2
8000130c:	ff000693          	li	a3,-16
80001310:	00e00613          	li	a2,14
80001314:	59c50513          	addi	a0,a0,1436 # 8000659c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000659d>
80001318:	655000ef          	jal	ra,8000216c <printk>
8000131c:	01800593          	li	a1,24
80001320:	4d0c0513          	addi	a0,s8,1232
80001324:	685000ef          	jal	ra,800021a8 <assert_post_action>
80001328:	f2dff06f          	j	80001254 <z_new_thread+0x60>

8000132c <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
8000132c:	00159793          	slli	a5,a1,0x1
80001330:	00b787b3          	add	a5,a5,a1
80001334:	00279713          	slli	a4,a5,0x2
80001338:	00c52783          	lw	a5,12(a0)
8000133c:	00e787b3          	add	a5,a5,a4
80001340:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001344:	00b75463          	bge	a4,a1,8000134c <get_bit_ptr+0x20>
80001348:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
8000134c:	41f65713          	srai	a4,a2,0x1f
80001350:	01f77713          	andi	a4,a4,31
80001354:	00c70733          	add	a4,a4,a2
80001358:	40575713          	srai	a4,a4,0x5
8000135c:	00271713          	slli	a4,a4,0x2
80001360:	00e787b3          	add	a5,a5,a4
80001364:	00f6a023          	sw	a5,0(a3)

	return bn & 0x1f;
}
80001368:	01f67513          	andi	a0,a2,31
8000136c:	00008067          	ret

80001370 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001370:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001374:	00c10693          	addi	a3,sp,12
{
80001378:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
8000137c:	fb1ff0ef          	jal	ra,8000132c <get_bit_ptr>

	*word |= (1<<bit);
80001380:	00c12703          	lw	a4,12(sp)
80001384:	00100793          	li	a5,1
80001388:	00a79533          	sll	a0,a5,a0
8000138c:	00072783          	lw	a5,0(a4)
}
80001390:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80001394:	00a7e7b3          	or	a5,a5,a0
80001398:	00f72023          	sw	a5,0(a4)
}
8000139c:	02010113          	addi	sp,sp,32
800013a0:	00008067          	ret

800013a4 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800013a4:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800013a8:	00c10693          	addi	a3,sp,12
{
800013ac:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800013b0:	f7dff0ef          	jal	ra,8000132c <get_bit_ptr>

	*word &= ~(1<<bit);
800013b4:	00c12703          	lw	a4,12(sp)
800013b8:	00100793          	li	a5,1
800013bc:	00a79533          	sll	a0,a5,a0
800013c0:	00072783          	lw	a5,0(a4)
}
800013c4:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
800013c8:	fff54513          	not	a0,a0
800013cc:	00a7f533          	and	a0,a5,a0
800013d0:	00a72023          	sw	a0,0(a4)
}
800013d4:	02010113          	addi	sp,sp,32
800013d8:	00008067          	ret

800013dc <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
800013dc:	fe010113          	addi	sp,sp,-32
800013e0:	00912a23          	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800013e4:	00452483          	lw	s1,4(a0)
{
800013e8:	00812c23          	sw	s0,24(sp)
800013ec:	00050413          	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800013f0:	00855503          	lhu	a0,8(a0)
800013f4:	00048593          	mv	a1,s1
{
800013f8:	01212823          	sw	s2,16(sp)
800013fc:	01312623          	sw	s3,12(sp)
80001400:	01412423          	sw	s4,8(sp)
80001404:	01512223          	sw	s5,4(sp)
80001408:	01612023          	sw	s6,0(sp)
8000140c:	00112e23          	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001410:	c84ff0ef          	jal	ra,80000894 <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001414:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001418:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
8000141c:	fff00793          	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001420:	00050a13          	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001424:	00a989b3          	add	s3,s3,a0
	p->max_inline_level = -1;
80001428:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
8000142c:	00000913          	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80001430:	01f00b13          	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80001434:	03594c63          	blt	s2,s5,8000146c <z_sys_mem_pool_base_init+0x90>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001438:	00000493          	li	s1,0
8000143c:	00845783          	lhu	a5,8(s0)
80001440:	08f4cc63          	blt	s1,a5,800014d8 <z_sys_mem_pool_base_init+0xfc>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001444:	01c12083          	lw	ra,28(sp)
80001448:	01812403          	lw	s0,24(sp)
8000144c:	01412483          	lw	s1,20(sp)
80001450:	01012903          	lw	s2,16(sp)
80001454:	00c12983          	lw	s3,12(sp)
80001458:	00812a03          	lw	s4,8(sp)
8000145c:	00412a83          	lw	s5,4(sp)
80001460:	00012b03          	lw	s6,0(sp)
80001464:	02010113          	addi	sp,sp,32
80001468:	00008067          	ret
		int nblocks = buflen / sz;
8000146c:	00048593          	mv	a1,s1
80001470:	000a0513          	mv	a0,s4
80001474:	c4cff0ef          	jal	ra,800008c0 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80001478:	00191713          	slli	a4,s2,0x1
8000147c:	01270733          	add	a4,a4,s2
80001480:	00271793          	slli	a5,a4,0x2
80001484:	00c42703          	lw	a4,12(s0)
80001488:	00f70733          	add	a4,a4,a5
8000148c:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001490:	00f72223          	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80001494:	00f72423          	sw	a5,8(a4)
		if (nblocks < 32) {
80001498:	00ab4e63          	blt	s6,a0,800014b4 <z_sys_mem_pool_base_init+0xd8>
			p->max_inline_level = i;
8000149c:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
800014a0:	0024d493          	srli	s1,s1,0x2
800014a4:	00348493          	addi	s1,s1,3
800014a8:	ffc4f493          	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
800014ac:	00190913          	addi	s2,s2,1
800014b0:	f85ff06f          	j	80001434 <z_sys_mem_pool_base_init+0x58>
			bits += (nblocks + 31)/32;
800014b4:	01f50513          	addi	a0,a0,31
800014b8:	41f55793          	srai	a5,a0,0x1f
800014bc:	01f7f793          	andi	a5,a5,31
800014c0:	00a787b3          	add	a5,a5,a0
800014c4:	4057d793          	srai	a5,a5,0x5
800014c8:	00279793          	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
800014cc:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
800014d0:	00f989b3          	add	s3,s3,a5
800014d4:	fcdff06f          	j	800014a0 <z_sys_mem_pool_base_init+0xc4>
	return (u8_t *)p->buf + lsz * block;
800014d8:	00442583          	lw	a1,4(s0)
800014dc:	00048513          	mv	a0,s1
800014e0:	bb4ff0ef          	jal	ra,80000894 <__mulsi3>
800014e4:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
800014e8:	00048613          	mv	a2,s1
800014ec:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
800014f0:	00a78533          	add	a0,a5,a0
		sys_dlist_append(&p->levels[0].free_list, block);
800014f4:	00c42783          	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
800014f8:	00148493          	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
800014fc:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001500:	00e52023          	sw	a4,0(a0)
	node->prev = list->tail;
80001504:	0087a703          	lw	a4,8(a5)
80001508:	00e52223          	sw	a4,4(a0)

	list->tail->next = node;
8000150c:	0087a703          	lw	a4,8(a5)
80001510:	00a72023          	sw	a0,0(a4)
	list->tail = node;
80001514:	00a7a423          	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80001518:	00040513          	mv	a0,s0
8000151c:	e55ff0ef          	jal	ra,80001370 <set_free_bit>
80001520:	f1dff06f          	j	8000143c <z_sys_mem_pool_base_init+0x60>

80001524 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001524:	fa010113          	addi	sp,sp,-96
80001528:	04812c23          	sw	s0,88(sp)
8000152c:	05512223          	sw	s5,68(sp)
80001530:	04112e23          	sw	ra,92(sp)
80001534:	04912a23          	sw	s1,84(sp)
80001538:	05212823          	sw	s2,80(sp)
8000153c:	05312623          	sw	s3,76(sp)
80001540:	05412423          	sw	s4,72(sp)
80001544:	05612023          	sw	s6,64(sp)
80001548:	03712e23          	sw	s7,60(sp)
8000154c:	03812c23          	sw	s8,56(sp)
80001550:	03912a23          	sw	s9,52(sp)
80001554:	03a12823          	sw	s10,48(sp)
80001558:	03b12623          	sw	s11,44(sp)
8000155c:	06010413          	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001560:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001564:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001568:	002e1793          	slli	a5,t3,0x2
8000156c:	00f78793          	addi	a5,a5,15
80001570:	7f07f793          	andi	a5,a5,2032
80001574:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80001578:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000157c:	00010a93          	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001580:	000a8313          	mv	t1,s5
80001584:	00378793          	addi	a5,a5,3
80001588:	ffc7f793          	andi	a5,a5,-4
8000158c:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
80001590:	fff88b13          	addi	s6,a7,-1
80001594:	03c8d463          	bge	a7,t3,800015bc <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
80001598:	00088c63          	beqz	a7,800015b0 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000159c:	ffc32803          	lw	a6,-4(t1)
800015a0:	00285813          	srli	a6,a6,0x2
800015a4:	00380813          	addi	a6,a6,3
800015a8:	ffc87813          	andi	a6,a6,-4
800015ac:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
800015b0:	00430313          	addi	t1,t1,4
800015b4:	ffc32803          	lw	a6,-4(t1)
800015b8:	04b87a63          	bgeu	a6,a1,8000160c <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
800015bc:	fff00593          	li	a1,-1
800015c0:	04bb1a63          	bne	s6,a1,80001614 <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
800015c4:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
800015c8:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
800015cc:	fa040113          	addi	sp,s0,-96
800015d0:	05c12083          	lw	ra,92(sp)
800015d4:	05812403          	lw	s0,88(sp)
800015d8:	05412483          	lw	s1,84(sp)
800015dc:	05012903          	lw	s2,80(sp)
800015e0:	04c12983          	lw	s3,76(sp)
800015e4:	04812a03          	lw	s4,72(sp)
800015e8:	04412a83          	lw	s5,68(sp)
800015ec:	04012b03          	lw	s6,64(sp)
800015f0:	03c12b83          	lw	s7,60(sp)
800015f4:	03812c03          	lw	s8,56(sp)
800015f8:	03412c83          	lw	s9,52(sp)
800015fc:	03012d03          	lw	s10,48(sp)
80001600:	02c12d83          	lw	s11,44(sp)
80001604:	06010113          	addi	sp,sp,96
80001608:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
8000160c:	00188893          	addi	a7,a7,1
80001610:	f81ff06f          	j	80001590 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001614:	01054583          	lbu	a1,16(a0)
		return 0;
80001618:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000161c:	0015f593          	andi	a1,a1,1
80001620:	00058863          	beqz	a1,80001630 <z_sys_mem_pool_block_alloc+0x10c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001624:	00800913          	li	s2,8
80001628:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
8000162c:	00897913          	andi	s2,s2,8
80001630:	fae42a23          	sw	a4,-76(s0)
80001634:	001b1713          	slli	a4,s6,0x1
80001638:	fad42c23          	sw	a3,-72(s0)
8000163c:	01670733          	add	a4,a4,s6
80001640:	00c52683          	lw	a3,12(a0)
80001644:	00271713          	slli	a4,a4,0x2
80001648:	00470713          	addi	a4,a4,4
8000164c:	00e68733          	add	a4,a3,a4
80001650:	fac42e23          	sw	a2,-68(s0)
80001654:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80001658:	000b0a13          	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
8000165c:	fff00693          	li	a3,-1
	return list->head == list;
80001660:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001664:	19370663          	beq	a4,s3,800017f0 <z_sys_mem_pool_block_alloc+0x2cc>
		data = block_alloc(p, i, lsizes[i]);
80001668:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
8000166c:	0049a683          	lw	a3,4(s3)
80001670:	00ea8cb3          	add	s9,s5,a4
80001674:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001678:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000167c:	00800d13          	li	s10,8
80001680:	00e6a023          	sw	a4,0(a3)
	node->next->prev = node->prev;
80001684:	00d72223          	sw	a3,4(a4)
	node->next = NULL;
80001688:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
8000168c:	0009a223          	sw	zero,4(s3)
80001690:	0004a503          	lw	a0,0(s1)
80001694:	40a98533          	sub	a0,s3,a0
80001698:	a20ff0ef          	jal	ra,800008b8 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
8000169c:	00050613          	mv	a2,a0
800016a0:	000a0593          	mv	a1,s4
800016a4:	00048513          	mv	a0,s1
800016a8:	cfdff0ef          	jal	ra,800013a4 <clear_free_bit>
		if (data != NULL) {
800016ac:	001a0a13          	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
800016b0:	fffa0693          	addi	a3,s4,-1
800016b4:	0566ca63          	blt	a3,s6,80001708 <z_sys_mem_pool_block_alloc+0x1e4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800016b8:	0104c703          	lbu	a4,16(s1)
800016bc:	00177713          	andi	a4,a4,1
800016c0:	00070463          	beqz	a4,800016c8 <z_sys_mem_pool_block_alloc+0x1a4>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800016c4:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
800016c8:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
800016cc:	ff400513          	li	a0,-12
	*data_p = data;
800016d0:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
800016d4:	ee098ce3          	beqz	s3,800015cc <z_sys_mem_pool_block_alloc+0xa8>
	*level_p = alloc_l;
800016d8:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800016dc:	0004a503          	lw	a0,0(s1)
	*level_p = alloc_l;
800016e0:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
800016e4:	002b1793          	slli	a5,s6,0x2
800016e8:	00fa8ab3          	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800016ec:	000aa583          	lw	a1,0(s5)
800016f0:	40a98533          	sub	a0,s3,a0
800016f4:	9c4ff0ef          	jal	ra,800008b8 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
800016f8:	fb842783          	lw	a5,-72(s0)
800016fc:	00a7a023          	sw	a0,0(a5)
	return 0;
80001700:	00000513          	li	a0,0
80001704:	ec9ff06f          	j	800015cc <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001708:	0004a503          	lw	a0,0(s1)
8000170c:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
80001710:	00100b93          	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001714:	40a98533          	sub	a0,s3,a0
80001718:	9a0ff0ef          	jal	ra,800008b8 <__divsi3>
8000171c:	001a1893          	slli	a7,s4,0x1
80001720:	014888b3          	add	a7,a7,s4
		int lbn = 4*bn + i;
80001724:	00251d93          	slli	s11,a0,0x2
80001728:	00289893          	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
8000172c:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
80001730:	000b8593          	mv	a1,s7
80001734:	fb142623          	sw	a7,-84(s0)
80001738:	00068513          	mv	a0,a3
8000173c:	fad42823          	sw	a3,-80(s0)
80001740:	954ff0ef          	jal	ra,80000894 <__mulsi3>
80001744:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
80001748:	01bb8633          	add	a2,s7,s11
8000174c:	000a0593          	mv	a1,s4
80001750:	00048513          	mv	a0,s1
80001754:	c1dff0ef          	jal	ra,80001370 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001758:	fb042683          	lw	a3,-80(s0)
8000175c:	0004a603          	lw	a2,0(s1)
	return p->n_max * p->max_sz;
80001760:	0044a583          	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001764:	fff68693          	addi	a3,a3,-1
	return p->n_max * p->max_sz;
80001768:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000176c:	00dc06b3          	add	a3,s8,a3
80001770:	40c686b3          	sub	a3,a3,a2
80001774:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
80001778:	91cff0ef          	jal	ra,80000894 <__mulsi3>
		if (block_fits(p, block2, lsz)) {
8000177c:	fb042683          	lw	a3,-80(s0)
80001780:	fac42883          	lw	a7,-84(s0)
80001784:	02a6f463          	bgeu	a3,a0,800017ac <z_sys_mem_pool_block_alloc+0x288>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80001788:	00c4a683          	lw	a3,12(s1)
8000178c:	011686b3          	add	a3,a3,a7
80001790:	00468613          	addi	a2,a3,4
	node->next = list;
80001794:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
80001798:	0086a603          	lw	a2,8(a3)
8000179c:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
800017a0:	0086a603          	lw	a2,8(a3)
800017a4:	01862023          	sw	s8,0(a2)
	list->tail = node;
800017a8:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
800017ac:	001b8b93          	addi	s7,s7,1
800017b0:	00400793          	li	a5,4
800017b4:	f6fb9ce3          	bne	s7,a5,8000172c <z_sys_mem_pool_block_alloc+0x208>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800017b8:	0104c683          	lbu	a3,16(s1)
800017bc:	0016f693          	andi	a3,a3,1
800017c0:	00069a63          	bnez	a3,800017d4 <z_sys_mem_pool_block_alloc+0x2b0>
		return 0;
800017c4:	00000913          	li	s2,0
800017c8:	001a0a13          	addi	s4,s4,1
800017cc:	004c8c93          	addi	s9,s9,4
800017d0:	ee1ff06f          	j	800016b0 <z_sys_mem_pool_block_alloc+0x18c>
800017d4:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800017d8:	0104c683          	lbu	a3,16(s1)
800017dc:	0016f693          	andi	a3,a3,1
800017e0:	fe0682e3          	beqz	a3,800017c4 <z_sys_mem_pool_block_alloc+0x2a0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800017e4:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
800017e8:	00897913          	andi	s2,s2,8
800017ec:	fddff06f          	j	800017c8 <z_sys_mem_pool_block_alloc+0x2a4>
	for (i = alloc_l; i >= 0; i--) {
800017f0:	fffa0a13          	addi	s4,s4,-1
800017f4:	ff498713          	addi	a4,s3,-12
800017f8:	e6da14e3          	bne	s4,a3,80001660 <z_sys_mem_pool_block_alloc+0x13c>
800017fc:	00000993          	li	s3,0
80001800:	eb9ff06f          	j	800016b8 <z_sys_mem_pool_block_alloc+0x194>

80001804 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001804:	fa010113          	addi	sp,sp,-96
80001808:	04812c23          	sw	s0,88(sp)
8000180c:	05412423          	sw	s4,72(sp)
80001810:	03912a23          	sw	s9,52(sp)
80001814:	04112e23          	sw	ra,92(sp)
80001818:	04912a23          	sw	s1,84(sp)
8000181c:	05212823          	sw	s2,80(sp)
80001820:	05312623          	sw	s3,76(sp)
80001824:	05512223          	sw	s5,68(sp)
80001828:	05612023          	sw	s6,64(sp)
8000182c:	03712e23          	sw	s7,60(sp)
80001830:	03812c23          	sw	s8,56(sp)
80001834:	03a12823          	sw	s10,48(sp)
80001838:	03b12623          	sw	s11,44(sp)
8000183c:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001840:	00a54703          	lbu	a4,10(a0)
{
80001844:	00050c93          	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001848:	00271713          	slli	a4,a4,0x2
8000184c:	00f70713          	addi	a4,a4,15
80001850:	7f077713          	andi	a4,a4,2032
80001854:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
80001858:	00452703          	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000185c:	00010a13          	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001860:	000a0693          	mv	a3,s4
80001864:	00370713          	addi	a4,a4,3
80001868:	ffc77713          	andi	a4,a4,-4
8000186c:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
80001870:	00100513          	li	a0,1
80001874:	00468693          	addi	a3,a3,4
80001878:	0ca5f063          	bgeu	a1,a0,80001938 <z_sys_mem_pool_block_free+0x134>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000187c:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001880:	00058913          	mv	s2,a1
80001884:	00060993          	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001888:	00177713          	andi	a4,a4,1
		return 0;
8000188c:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001890:	00070863          	beqz	a4,800018a0 <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001894:	00800493          	li	s1,8
80001898:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
8000189c:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800018a0:	80006b37          	lui	s6,0x80006
	while (level >= 0) {
800018a4:	0a095863          	bgez	s2,80001954 <z_sys_mem_pool_block_free+0x150>
	__ASSERT(0, "out of levels");
800018a8:	800064b7          	lui	s1,0x80006
800018ac:	800065b7          	lui	a1,0x80006
800018b0:	80006537          	lui	a0,0x80006
800018b4:	5d048613          	addi	a2,s1,1488 # 800065d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d1>
800018b8:	0c000693          	li	a3,192
800018bc:	63858593          	addi	a1,a1,1592 # 80006638 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006639>
800018c0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800018c4:	0a9000ef          	jal	ra,8000216c <printk>
800018c8:	80006537          	lui	a0,0x80006
800018cc:	60450513          	addi	a0,a0,1540 # 80006604 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006605>
800018d0:	09d000ef          	jal	ra,8000216c <printk>
800018d4:	5d048513          	addi	a0,s1,1488
800018d8:	0c000593          	li	a1,192
800018dc:	0cd000ef          	jal	ra,800021a8 <assert_post_action>
	return -1;
800018e0:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800018e4:	010cc783          	lbu	a5,16(s9)
800018e8:	0017f793          	andi	a5,a5,1
800018ec:	00078663          	beqz	a5,800018f8 <z_sys_mem_pool_block_free+0xf4>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
800018f0:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800018f4:	3004a4f3          	csrrs	s1,mstatus,s1
}
800018f8:	fa040113          	addi	sp,s0,-96
800018fc:	05c12083          	lw	ra,92(sp)
80001900:	05812403          	lw	s0,88(sp)
80001904:	05412483          	lw	s1,84(sp)
80001908:	05012903          	lw	s2,80(sp)
8000190c:	04c12983          	lw	s3,76(sp)
80001910:	04812a03          	lw	s4,72(sp)
80001914:	04412a83          	lw	s5,68(sp)
80001918:	04012b03          	lw	s6,64(sp)
8000191c:	03c12b83          	lw	s7,60(sp)
80001920:	03812c03          	lw	s8,56(sp)
80001924:	03412c83          	lw	s9,52(sp)
80001928:	03012d03          	lw	s10,48(sp)
8000192c:	02c12d83          	lw	s11,44(sp)
80001930:	06010113          	addi	sp,sp,96
80001934:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001938:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
8000193c:	00150513          	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001940:	00275713          	srli	a4,a4,0x2
80001944:	00370713          	addi	a4,a4,3
80001948:	ffc77713          	andi	a4,a4,-4
8000194c:	00e6a023          	sw	a4,0(a3)
80001950:	f25ff06f          	j	80001874 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
80001954:	00291713          	slli	a4,s2,0x2
80001958:	00ea0733          	add	a4,s4,a4
8000195c:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
80001960:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
80001964:	00098513          	mv	a0,s3
80001968:	000a8593          	mv	a1,s5
8000196c:	f29fe0ef          	jal	ra,80000894 <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001970:	fffa8b93          	addi	s7,s5,-1
80001974:	01750d33          	add	s10,a0,s7
80001978:	00ac0c33          	add	s8,s8,a0
	return p->n_max * p->max_sz;
8000197c:	004ca583          	lw	a1,4(s9)
80001980:	008cd503          	lhu	a0,8(s9)
80001984:	f11fe0ef          	jal	ra,80000894 <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
80001988:	02ad6c63          	bltu	s10,a0,800019c0 <z_sys_mem_pool_block_free+0x1bc>
8000198c:	800067b7          	lui	a5,0x80006
80001990:	5e478593          	addi	a1,a5,1508 # 800065e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e5>
80001994:	800067b7          	lui	a5,0x80006
80001998:	57c78513          	addi	a0,a5,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
8000199c:	0a400693          	li	a3,164
800019a0:	5d0b0613          	addi	a2,s6,1488 # 800065d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d1>
800019a4:	7c8000ef          	jal	ra,8000216c <printk>
800019a8:	800067b7          	lui	a5,0x80006
800019ac:	60078513          	addi	a0,a5,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
800019b0:	7bc000ef          	jal	ra,8000216c <printk>
800019b4:	0a400593          	li	a1,164
800019b8:	5d0b0513          	addi	a0,s6,1488
800019bc:	7ec000ef          	jal	ra,800021a8 <assert_post_action>
		set_free_bit(p, level, bn);
800019c0:	00098613          	mv	a2,s3
800019c4:	00090593          	mv	a1,s2
800019c8:	000c8513          	mv	a0,s9
800019cc:	9a5ff0ef          	jal	ra,80001370 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
800019d0:	00191713          	slli	a4,s2,0x1
800019d4:	01270733          	add	a4,a4,s2
800019d8:	00271693          	slli	a3,a4,0x2
800019dc:	00cca703          	lw	a4,12(s9)
800019e0:	00d70733          	add	a4,a4,a3
800019e4:	00470693          	addi	a3,a4,4
	node->next = list;
800019e8:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
800019ec:	00872683          	lw	a3,8(a4)
800019f0:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
800019f4:	00872683          	lw	a3,8(a4)
800019f8:	0186a023          	sw	s8,0(a3)
	list->tail = node;
800019fc:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001a00:	010cc703          	lbu	a4,16(s9)
80001a04:	00177713          	andi	a4,a4,1
80001a08:	0c071c63          	bnez	a4,80001ae0 <z_sys_mem_pool_block_free+0x2dc>
		return 0;
80001a0c:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001a10:	ec090ae3          	beqz	s2,800018e4 <z_sys_mem_pool_block_free+0xe0>
	int bit = get_bit_ptr(p, level, bn, &word);
80001a14:	fbc40693          	addi	a3,s0,-68
80001a18:	00098613          	mv	a2,s3
80001a1c:	00090593          	mv	a1,s2
80001a20:	000c8513          	mv	a0,s9
80001a24:	909ff0ef          	jal	ra,8000132c <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80001a28:	fbc42683          	lw	a3,-68(s0)
80001a2c:	41f55713          	srai	a4,a0,0x1f
80001a30:	00377713          	andi	a4,a4,3
80001a34:	00a70733          	add	a4,a4,a0
80001a38:	0006a503          	lw	a0,0(a3)
80001a3c:	ffc77713          	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001a40:	00f00793          	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
80001a44:	00e55733          	srl	a4,a0,a4
80001a48:	00f77713          	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001a4c:	e8f71ce3          	bne	a4,a5,800018e4 <z_sys_mem_pool_block_free+0xe0>
		for (i = 0; i < 4; i++) {
80001a50:	00000d13          	li	s10,0
			int b = (bn & ~3) + i;
80001a54:	ffc9fd93          	andi	s11,s3,-4
80001a58:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
80001a5c:	00060513          	mv	a0,a2
80001a60:	000a8593          	mv	a1,s5
80001a64:	fac42423          	sw	a2,-88(s0)
80001a68:	e2dfe0ef          	jal	ra,80000894 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001a6c:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
80001a70:	00050c13          	mv	s8,a0
	return p->n_max * p->max_sz;
80001a74:	004ca583          	lw	a1,4(s9)
80001a78:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001a7c:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001a80:	e15fe0ef          	jal	ra,80000894 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001a84:	fac42703          	lw	a4,-84(s0)
80001a88:	fa842603          	lw	a2,-88(s0)
80001a8c:	02a77863          	bgeu	a4,a0,80001abc <z_sys_mem_pool_block_free+0x2b8>
				clear_free_bit(p, level, b);
80001a90:	00090593          	mv	a1,s2
80001a94:	000c8513          	mv	a0,s9
80001a98:	90dff0ef          	jal	ra,800013a4 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
80001a9c:	000ca703          	lw	a4,0(s9)
80001aa0:	01870c33          	add	s8,a4,s8
	node->prev->next = node->next;
80001aa4:	004c2603          	lw	a2,4(s8)
80001aa8:	000c2703          	lw	a4,0(s8)
80001aac:	00e62023          	sw	a4,0(a2)
	node->next->prev = node->prev;
80001ab0:	00c72223          	sw	a2,4(a4)
	node->next = NULL;
80001ab4:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
80001ab8:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80001abc:	001d0d13          	addi	s10,s10,1
80001ac0:	00400793          	li	a5,4
80001ac4:	f8fd1ae3          	bne	s10,a5,80001a58 <z_sys_mem_pool_block_free+0x254>
		bn = bn / 4;
80001ac8:	41f9d613          	srai	a2,s3,0x1f
80001acc:	00367613          	andi	a2,a2,3
80001ad0:	013609b3          	add	s3,a2,s3
		level = level - 1;
80001ad4:	fff90913          	addi	s2,s2,-1
		bn = bn / 4;
80001ad8:	4029d993          	srai	s3,s3,0x2
80001adc:	dc9ff06f          	j	800018a4 <z_sys_mem_pool_block_free+0xa0>
80001ae0:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001ae4:	010cc703          	lbu	a4,16(s9)
80001ae8:	00177713          	andi	a4,a4,1
80001aec:	f20700e3          	beqz	a4,80001a0c <z_sys_mem_pool_block_free+0x208>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001af0:	00800793          	li	a5,8
80001af4:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
80001af8:	0084f493          	andi	s1,s1,8
80001afc:	f15ff06f          	j	80001a10 <z_sys_mem_pool_block_free+0x20c>

80001b00 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001b00:	ff010113          	addi	sp,sp,-16
80001b04:	00050793          	mv	a5,a0
80001b08:	00058513          	mv	a0,a1
80001b0c:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001b10:	00068613          	mv	a2,a3
{
80001b14:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001b18:	000780e7          	jalr	a5
80001b1c:	6fc020ef          	jal	ra,80004218 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001b20:	338030ef          	jal	ra,80004e58 <z_impl_k_thread_abort>

80001b24 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001b24:	00000513          	li	a0,0
80001b28:	00008067          	ret

80001b2c <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001b2c:	ff010113          	addi	sp,sp,-16
80001b30:	00812423          	sw	s0,8(sp)
80001b34:	00050413          	mv	s0,a0
	out('E', ctx);
80001b38:	04500513          	li	a0,69
{
80001b3c:	00112623          	sw	ra,12(sp)
80001b40:	00912223          	sw	s1,4(sp)
80001b44:	00058493          	mv	s1,a1
	out('E', ctx);
80001b48:	000400e7          	jalr	s0
	out('R', ctx);
80001b4c:	00048593          	mv	a1,s1
80001b50:	05200513          	li	a0,82
80001b54:	000400e7          	jalr	s0
	out('R', ctx);
80001b58:	00040313          	mv	t1,s0
}
80001b5c:	00812403          	lw	s0,8(sp)
80001b60:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001b64:	00048593          	mv	a1,s1
}
80001b68:	00412483          	lw	s1,4(sp)
	out('R', ctx);
80001b6c:	05200513          	li	a0,82
}
80001b70:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001b74:	00030067          	jr	t1

80001b78 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001b78:	0005a783          	lw	a5,0(a1)
80001b7c:	00178793          	addi	a5,a5,1
80001b80:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001b84:	800077b7          	lui	a5,0x80007
80001b88:	bf87a303          	lw	t1,-1032(a5) # 80006bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bf9>
80001b8c:	00030067          	jr	t1

80001b90 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001b90:	fc010113          	addi	sp,sp,-64
80001b94:	02812c23          	sw	s0,56(sp)
80001b98:	03312623          	sw	s3,44(sp)
80001b9c:	03412423          	sw	s4,40(sp)
80001ba0:	03612023          	sw	s6,32(sp)
80001ba4:	01a12823          	sw	s10,16(sp)
80001ba8:	02112e23          	sw	ra,60(sp)
80001bac:	02912a23          	sw	s1,52(sp)
80001bb0:	03212823          	sw	s2,48(sp)
80001bb4:	03512223          	sw	s5,36(sp)
80001bb8:	01712e23          	sw	s7,28(sp)
80001bbc:	01812c23          	sw	s8,24(sp)
80001bc0:	01912a23          	sw	s9,20(sp)
80001bc4:	01b12623          	sw	s11,12(sp)
80001bc8:	00050993          	mv	s3,a0
80001bcc:	00058a13          	mv	s4,a1
80001bd0:	00060d13          	mv	s10,a2
80001bd4:	00068b13          	mv	s6,a3
80001bd8:	00100413          	li	s0,1
80001bdc:	00e05463          	blez	a4,80001be4 <_printk_dec_ulong+0x54>
80001be0:	00070413          	mv	s0,a4
80001be4:	00100793          	li	a5,1
80001be8:	02000c93          	li	s9,32
80001bec:	00fb1463          	bne	s6,a5,80001bf4 <_printk_dec_ulong+0x64>
80001bf0:	03000c93          	li	s9,48
80001bf4:	3b9ad4b7          	lui	s1,0x3b9ad
80001bf8:	00100913          	li	s2,1
80001bfc:	00a00a93          	li	s5,10
80001c00:	00000c13          	li	s8,0
80001c04:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001c08:	00200d93          	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001c0c:	00148b93          	addi	s7,s1,1
80001c10:	000c1463          	bnez	s8,80001c18 <_printk_dec_ulong+0x88>
80001c14:	0ba4f263          	bgeu	s1,s10,80001cb8 <_printk_dec_ulong+0x128>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001c18:	000b8593          	mv	a1,s7
80001c1c:	000d0513          	mv	a0,s10
80001c20:	ca1fe0ef          	jal	ra,800008c0 <__udivsi3>
80001c24:	000a0593          	mv	a1,s4
80001c28:	03050513          	addi	a0,a0,48
80001c2c:	000980e7          	jalr	s3
			digits++;
80001c30:	00190913          	addi	s2,s2,1
			found_largest_digit = 1;
80001c34:	00100c13          	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
80001c38:	000b8593          	mv	a1,s7
80001c3c:	000d0513          	mv	a0,s10
80001c40:	cc9fe0ef          	jal	ra,80000908 <__umodsi3>
80001c44:	00050d13          	mv	s10,a0
		pos /= 10;
80001c48:	00a00593          	li	a1,10
80001c4c:	00048513          	mv	a0,s1
80001c50:	c71fe0ef          	jal	ra,800008c0 <__udivsi3>
		remaining--;
80001c54:	fffa8a93          	addi	s5,s5,-1
	while (pos >= 9) {
80001c58:	00100793          	li	a5,1
		pos /= 10;
80001c5c:	00050493          	mv	s1,a0
	while (pos >= 9) {
80001c60:	fafa96e3          	bne	s5,a5,80001c0c <_printk_dec_ulong+0x7c>
	}
	out((int)(remainder + 48), ctx);
80001c64:	000a0593          	mv	a1,s4
80001c68:	030d0513          	addi	a0,s10,48
80001c6c:	000980e7          	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001c70:	00300793          	li	a5,3
		remaining = min_width - digits;
80001c74:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001c78:	06fb0663          	beq	s6,a5,80001ce4 <_printk_dec_ulong+0x154>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001c7c:	03c12083          	lw	ra,60(sp)
80001c80:	03812403          	lw	s0,56(sp)
80001c84:	03412483          	lw	s1,52(sp)
80001c88:	03012903          	lw	s2,48(sp)
80001c8c:	02c12983          	lw	s3,44(sp)
80001c90:	02812a03          	lw	s4,40(sp)
80001c94:	02412a83          	lw	s5,36(sp)
80001c98:	02012b03          	lw	s6,32(sp)
80001c9c:	01c12b83          	lw	s7,28(sp)
80001ca0:	01812c03          	lw	s8,24(sp)
80001ca4:	01412c83          	lw	s9,20(sp)
80001ca8:	01012d03          	lw	s10,16(sp)
80001cac:	00c12d83          	lw	s11,12(sp)
80001cb0:	04010113          	addi	sp,sp,64
80001cb4:	00008067          	ret
		} else if (remaining <= min_width
80001cb8:	f95440e3          	blt	s0,s5,80001c38 <_printk_dec_ulong+0xa8>
				&& padding < PAD_SPACE_AFTER) {
80001cbc:	f76deee3          	bltu	s11,s6,80001c38 <_printk_dec_ulong+0xa8>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001cc0:	000a0593          	mv	a1,s4
80001cc4:	000c8513          	mv	a0,s9
80001cc8:	000980e7          	jalr	s3
			digits++;
80001ccc:	00190913          	addi	s2,s2,1
80001cd0:	f69ff06f          	j	80001c38 <_printk_dec_ulong+0xa8>
			out(' ', ctx);
80001cd4:	000a0593          	mv	a1,s4
80001cd8:	02000513          	li	a0,32
80001cdc:	000980e7          	jalr	s3
80001ce0:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
80001ce4:	fe8048e3          	bgtz	s0,80001cd4 <_printk_dec_ulong+0x144>
80001ce8:	f95ff06f          	j	80001c7c <_printk_dec_ulong+0xec>

80001cec <__printk_hook_install>:
	_char_out = fn;
80001cec:	800077b7          	lui	a5,0x80007
80001cf0:	bea7ac23          	sw	a0,-1032(a5) # 80006bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bf9>
}
80001cf4:	00008067          	ret

80001cf8 <z_vprintk>:
{
80001cf8:	fb010113          	addi	sp,sp,-80
80001cfc:	04812423          	sw	s0,72(sp)
80001d00:	04912223          	sw	s1,68(sp)
80001d04:	05212023          	sw	s2,64(sp)
80001d08:	03312e23          	sw	s3,60(sp)
80001d0c:	03412c23          	sw	s4,56(sp)
80001d10:	03512a23          	sw	s5,52(sp)
80001d14:	03912223          	sw	s9,36(sp)
80001d18:	03a12023          	sw	s10,32(sp)
80001d1c:	01b12e23          	sw	s11,28(sp)
80001d20:	04112623          	sw	ra,76(sp)
80001d24:	03612823          	sw	s6,48(sp)
80001d28:	03712623          	sw	s7,44(sp)
80001d2c:	03812423          	sw	s8,40(sp)
80001d30:	00050413          	mv	s0,a0
80001d34:	00058493          	mv	s1,a1
80001d38:	00060a93          	mv	s5,a2
80001d3c:	00068d13          	mv	s10,a3
	int long_ctr = 0;
80001d40:	00000a13          	li	s4,0
	int min_width = -1;
80001d44:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001d48:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001d4c:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
80001d50:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001d54:	000ac503          	lbu	a0,0(s5)
80001d58:	04051063          	bnez	a0,80001d98 <z_vprintk+0xa0>
}
80001d5c:	04c12083          	lw	ra,76(sp)
80001d60:	04812403          	lw	s0,72(sp)
80001d64:	04412483          	lw	s1,68(sp)
80001d68:	04012903          	lw	s2,64(sp)
80001d6c:	03c12983          	lw	s3,60(sp)
80001d70:	03812a03          	lw	s4,56(sp)
80001d74:	03412a83          	lw	s5,52(sp)
80001d78:	03012b03          	lw	s6,48(sp)
80001d7c:	02c12b83          	lw	s7,44(sp)
80001d80:	02812c03          	lw	s8,40(sp)
80001d84:	02412c83          	lw	s9,36(sp)
80001d88:	02012d03          	lw	s10,32(sp)
80001d8c:	01c12d83          	lw	s11,28(sp)
80001d90:	05010113          	addi	sp,sp,80
80001d94:	00008067          	ret
		if (!might_format) {
80001d98:	000c9e63          	bnez	s9,80001db4 <z_vprintk+0xbc>
			if (*fmt != '%') {
80001d9c:	02500693          	li	a3,37
80001da0:	36d50c63          	beq	a0,a3,80002118 <z_vprintk+0x420>
				out((int)*fmt, ctx);
80001da4:	00048593          	mv	a1,s1
80001da8:	000400e7          	jalr	s0
		++fmt;
80001dac:	001a8a93          	addi	s5,s5,1
80001db0:	fa5ff06f          	j	80001d54 <z_vprintk+0x5c>
			switch (*fmt) {
80001db4:	06400693          	li	a3,100
80001db8:	12d50063          	beq	a0,a3,80001ed8 <z_vprintk+0x1e0>
80001dbc:	06a6e263          	bltu	a3,a0,80001e20 <z_vprintk+0x128>
80001dc0:	03900693          	li	a3,57
80001dc4:	02a6ea63          	bltu	a3,a0,80001df8 <z_vprintk+0x100>
80001dc8:	03100693          	li	a3,49
80001dcc:	0ed57463          	bgeu	a0,a3,80001eb4 <z_vprintk+0x1bc>
80001dd0:	02d00693          	li	a3,45
80001dd4:	34d50c63          	beq	a0,a3,8000212c <z_vprintk+0x434>
80001dd8:	03000793          	li	a5,48
80001ddc:	0cf50063          	beq	a0,a5,80001e9c <z_vprintk+0x1a4>
80001de0:	02500713          	li	a4,37
80001de4:	02e51263          	bne	a0,a4,80001e08 <z_vprintk+0x110>
				out((int)'%', ctx);
80001de8:	00048593          	mv	a1,s1
80001dec:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001df0:	000400e7          	jalr	s0
				break;
80001df4:	1600006f          	j	80001f54 <z_vprintk+0x25c>
80001df8:	05800693          	li	a3,88
80001dfc:	1cd50063          	beq	a0,a3,80001fbc <z_vprintk+0x2c4>
80001e00:	06300713          	li	a4,99
80001e04:	30e50063          	beq	a0,a4,80002104 <z_vprintk+0x40c>
				out((int)'%', ctx);
80001e08:	00048593          	mv	a1,s1
80001e0c:	02500513          	li	a0,37
80001e10:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001e14:	00048593          	mv	a1,s1
80001e18:	000ac503          	lbu	a0,0(s5)
80001e1c:	fd5ff06f          	j	80001df0 <z_vprintk+0xf8>
80001e20:	07000693          	li	a3,112
80001e24:	16d50c63          	beq	a0,a3,80001f9c <z_vprintk+0x2a4>
80001e28:	02a6e063          	bltu	a3,a0,80001e48 <z_vprintk+0x150>
80001e2c:	06900693          	li	a3,105
80001e30:	0ad50463          	beq	a0,a3,80001ed8 <z_vprintk+0x1e0>
80001e34:	06c00693          	li	a3,108
80001e38:	08d50c63          	beq	a0,a3,80001ed0 <z_vprintk+0x1d8>
80001e3c:	06800693          	li	a3,104
80001e40:	f6d506e3          	beq	a0,a3,80001dac <z_vprintk+0xb4>
80001e44:	fc5ff06f          	j	80001e08 <z_vprintk+0x110>
80001e48:	07500693          	li	a3,117
80001e4c:	10d50863          	beq	a0,a3,80001f5c <z_vprintk+0x264>
80001e50:	02a6ee63          	bltu	a3,a0,80001e8c <z_vprintk+0x194>
80001e54:	07300713          	li	a4,115
80001e58:	fae518e3          	bne	a0,a4,80001e08 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80001e5c:	000d2c03          	lw	s8,0(s10)
80001e60:	004d0b13          	addi	s6,s10,4
80001e64:	000c0b93          	mv	s7,s8
				while (*s)
80001e68:	000bc503          	lbu	a0,0(s7)
80001e6c:	26051a63          	bnez	a0,800020e0 <z_vprintk+0x3e8>
				if (padding == PAD_SPACE_AFTER) {
80001e70:	00300793          	li	a5,3
80001e74:	00f99863          	bne	s3,a5,80001e84 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80001e78:	418b8bb3          	sub	s7,s7,s8
80001e7c:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001e80:	27704863          	bgtz	s7,800020f0 <z_vprintk+0x3f8>
				char *s = va_arg(ap, char *);
80001e84:	000b0d13          	mv	s10,s6
80001e88:	0cc0006f          	j	80001f54 <z_vprintk+0x25c>
80001e8c:	07800693          	li	a3,120
80001e90:	12d50663          	beq	a0,a3,80001fbc <z_vprintk+0x2c4>
80001e94:	07a00693          	li	a3,122
80001e98:	fa9ff06f          	j	80001e40 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80001e9c:	00095e63          	bgez	s2,80001eb8 <z_vprintk+0x1c0>
80001ea0:	28098a63          	beqz	s3,80002134 <z_vprintk+0x43c>
					min_width = *fmt - '0';
80001ea4:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001ea8:	f00992e3          	bnez	s3,80001dac <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001eac:	00200993          	li	s3,2
80001eb0:	efdff06f          	j	80001dac <z_vprintk+0xb4>
				if (min_width < 0) {
80001eb4:	fe0948e3          	bltz	s2,80001ea4 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001eb8:	00291693          	slli	a3,s2,0x2
80001ebc:	01268933          	add	s2,a3,s2
80001ec0:	00191913          	slli	s2,s2,0x1
80001ec4:	fd090913          	addi	s2,s2,-48
80001ec8:	01250933          	add	s2,a0,s2
80001ecc:	fddff06f          	j	80001ea8 <z_vprintk+0x1b0>
				long_ctr++;
80001ed0:	001a0a13          	addi	s4,s4,1
80001ed4:	ed9ff06f          	j	80001dac <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001ed8:	040a1263          	bnez	s4,80001f1c <z_vprintk+0x224>
					long ld = va_arg(ap, long);
80001edc:	000d2603          	lw	a2,0(s10)
80001ee0:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001ee4:	02065063          	bgez	a2,80001f04 <z_vprintk+0x20c>
					out((int)'-', ctx);
80001ee8:	00048593          	mv	a1,s1
80001eec:	02d00513          	li	a0,45
80001ef0:	00c12023          	sw	a2,0(sp)
80001ef4:	000400e7          	jalr	s0
					d = -d;
80001ef8:	00012603          	lw	a2,0(sp)
					min_width--;
80001efc:	fff90913          	addi	s2,s2,-1
					d = -d;
80001f00:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001f04:	00090713          	mv	a4,s2
80001f08:	00098693          	mv	a3,s3
80001f0c:	00048593          	mv	a1,s1
80001f10:	00040513          	mv	a0,s0
80001f14:	c7dff0ef          	jal	ra,80001b90 <_printk_dec_ulong>
				break;
80001f18:	03c0006f          	j	80001f54 <z_vprintk+0x25c>
				} else if (long_ctr == 1) {
80001f1c:	00100713          	li	a4,1
80001f20:	faea0ee3          	beq	s4,a4,80001edc <z_vprintk+0x1e4>
					long long lld = va_arg(ap, long long);
80001f24:	007d0793          	addi	a5,s10,7
80001f28:	ff87f713          	andi	a4,a5,-8
80001f2c:	00072603          	lw	a2,0(a4)
80001f30:	00472683          	lw	a3,4(a4)
80001f34:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001f38:	01b60733          	add	a4,a2,s11
80001f3c:	00c73733          	sltu	a4,a4,a2
80001f40:	00d70733          	add	a4,a4,a3
80001f44:	fa0700e3          	beqz	a4,80001ee4 <z_vprintk+0x1ec>
						print_err(out, ctx);
80001f48:	00048593          	mv	a1,s1
80001f4c:	00040513          	mv	a0,s0
80001f50:	bddff0ef          	jal	ra,80001b2c <print_err>
			might_format = 0;
80001f54:	00000c93          	li	s9,0
80001f58:	e55ff06f          	j	80001dac <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001f5c:	000a1863          	bnez	s4,80001f6c <z_vprintk+0x274>
					long lu = va_arg(ap, unsigned long);
80001f60:	000d2603          	lw	a2,0(s10)
80001f64:	004d0d13          	addi	s10,s10,4
80001f68:	f9dff06f          	j	80001f04 <z_vprintk+0x20c>
				} else if (long_ctr == 1) {
80001f6c:	00100713          	li	a4,1
80001f70:	feea08e3          	beq	s4,a4,80001f60 <z_vprintk+0x268>
					unsigned long long llu =
80001f74:	007d0793          	addi	a5,s10,7
80001f78:	ff87f713          	andi	a4,a5,-8
80001f7c:	00870d13          	addi	s10,a4,8
80001f80:	00072603          	lw	a2,0(a4)
80001f84:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001f88:	fc0710e3          	bnez	a4,80001f48 <z_vprintk+0x250>
80001f8c:	800007b7          	lui	a5,0x80000
80001f90:	fff7c793          	not	a5,a5
80001f94:	f6c7f8e3          	bgeu	a5,a2,80001f04 <z_vprintk+0x20c>
80001f98:	fb1ff06f          	j	80001f48 <z_vprintk+0x250>
				  out('0', ctx);
80001f9c:	00048593          	mv	a1,s1
80001fa0:	03000513          	li	a0,48
80001fa4:	000400e7          	jalr	s0
				  out('x', ctx);
80001fa8:	00048593          	mv	a1,s1
80001fac:	07800513          	li	a0,120
80001fb0:	000400e7          	jalr	s0
				  min_width = 8;
80001fb4:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001fb8:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001fbc:	00100693          	li	a3,1
80001fc0:	0b46c263          	blt	a3,s4,80002064 <z_vprintk+0x36c>
					x = va_arg(ap, unsigned long);
80001fc4:	000d2783          	lw	a5,0(s10)
80001fc8:	00012423          	sw	zero,8(sp)
80001fcc:	004d0d13          	addi	s10,s10,4
80001fd0:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001fd4:	01000c13          	li	s8,16
	int digits = 0;
80001fd8:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80001fdc:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001fe0:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001fe4:	00412503          	lw	a0,4(sp)
80001fe8:	00812583          	lw	a1,8(sp)
80001fec:	fff88b13          	addi	s6,a7,-1
80001ff0:	002b1613          	slli	a2,s6,0x2
80001ff4:	01112623          	sw	a7,12(sp)
80001ff8:	a90fe0ef          	jal	ra,80000288 <__lshrdi3>
80001ffc:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002000:	08051863          	bnez	a0,80002090 <z_vprintk+0x398>
80002004:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80002008:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
8000200c:	00079863          	bnez	a5,8000201c <z_vprintk+0x324>
80002010:	00c12883          	lw	a7,12(sp)
80002014:	00100793          	li	a5,1
80002018:	08f89663          	bne	a7,a5,800020a4 <z_vprintk+0x3ac>
			nibble += nibble > 9 ? 87 : 48;
8000201c:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80002020:	01851513          	slli	a0,a0,0x18
80002024:	00048593          	mv	a1,s1
80002028:	41855513          	srai	a0,a0,0x18
8000202c:	000400e7          	jalr	s0
			digits++;
80002030:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
80002034:	040b1863          	bnez	s6,80002084 <z_vprintk+0x38c>
	if (padding == PAD_SPACE_AFTER) {
80002038:	00300693          	li	a3,3
			might_format = 0;
8000203c:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80002040:	d6d996e3          	bne	s3,a3,80001dac <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
80002044:	00191713          	slli	a4,s2,0x1
80002048:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
8000204c:	f17054e3          	blez	s7,80001f54 <z_vprintk+0x25c>
			out(' ', ctx);
80002050:	00048593          	mv	a1,s1
80002054:	02000513          	li	a0,32
80002058:	000400e7          	jalr	s0
8000205c:	fffb8b93          	addi	s7,s7,-1
80002060:	fedff06f          	j	8000204c <z_vprintk+0x354>
					x = va_arg(ap, unsigned long long);
80002064:	007d0793          	addi	a5,s10,7
80002068:	ff87f693          	andi	a3,a5,-8
8000206c:	0006a783          	lw	a5,0(a3)
80002070:	00868d13          	addi	s10,a3,8
80002074:	00f12223          	sw	a5,4(sp)
80002078:	0046a783          	lw	a5,4(a3)
8000207c:	00f12423          	sw	a5,8(sp)
80002080:	f55ff06f          	j	80001fd4 <z_vprintk+0x2dc>
			found_largest_digit = 1;
80002084:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80002088:	000b0893          	mv	a7,s6
8000208c:	f59ff06f          	j	80001fe4 <z_vprintk+0x2ec>
			nibble += nibble > 9 ? 87 : 48;
80002090:	00900793          	li	a5,9
80002094:	05700693          	li	a3,87
80002098:	f8a7e2e3          	bltu	a5,a0,8000201c <z_vprintk+0x324>
8000209c:	03000693          	li	a3,48
800020a0:	f7dff06f          	j	8000201c <z_vprintk+0x324>
		if (remaining-- <= min_width) {
800020a4:	fffc0793          	addi	a5,s8,-1
800020a8:	00f12623          	sw	a5,12(sp)
800020ac:	01894c63          	blt	s2,s8,800020c4 <z_vprintk+0x3cc>
			if (padding == PAD_ZERO_BEFORE) {
800020b0:	00100793          	li	a5,1
800020b4:	00f99c63          	bne	s3,a5,800020cc <z_vprintk+0x3d4>
				out('0', ctx);
800020b8:	00048593          	mv	a1,s1
800020bc:	03000513          	li	a0,48
				out(' ', ctx);
800020c0:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
800020c4:	00c12c03          	lw	s8,12(sp)
800020c8:	fc1ff06f          	j	80002088 <z_vprintk+0x390>
			} else if (padding == PAD_SPACE_BEFORE) {
800020cc:	00200793          	li	a5,2
800020d0:	fef99ae3          	bne	s3,a5,800020c4 <z_vprintk+0x3cc>
				out(' ', ctx);
800020d4:	00048593          	mv	a1,s1
800020d8:	02000513          	li	a0,32
800020dc:	fe5ff06f          	j	800020c0 <z_vprintk+0x3c8>
					out((int)(*s++), ctx);
800020e0:	00048593          	mv	a1,s1
800020e4:	001b8b93          	addi	s7,s7,1
800020e8:	000400e7          	jalr	s0
800020ec:	d7dff06f          	j	80001e68 <z_vprintk+0x170>
						out(' ', ctx);
800020f0:	00048593          	mv	a1,s1
800020f4:	02000513          	li	a0,32
800020f8:	000400e7          	jalr	s0
800020fc:	fffb8b93          	addi	s7,s7,-1
80002100:	d81ff06f          	j	80001e80 <z_vprintk+0x188>
				out(c, ctx);
80002104:	000d2503          	lw	a0,0(s10)
80002108:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
8000210c:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80002110:	000400e7          	jalr	s0
				break;
80002114:	d71ff06f          	j	80001e84 <z_vprintk+0x18c>
				long_ctr = 0;
80002118:	00000a13          	li	s4,0
				min_width = -1;
8000211c:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80002120:	00000993          	li	s3,0
				might_format = 1;
80002124:	00100c93          	li	s9,1
80002128:	c85ff06f          	j	80001dac <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
8000212c:	00300993          	li	s3,3
80002130:	c7dff06f          	j	80001dac <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80002134:	00100993          	li	s3,1
80002138:	c75ff06f          	j	80001dac <z_vprintk+0xb4>

8000213c <vprintk>:
{
8000213c:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80002140:	00050613          	mv	a2,a0
80002144:	80002537          	lui	a0,0x80002
80002148:	00058693          	mv	a3,a1
8000214c:	b7850513          	addi	a0,a0,-1160 # 80001b78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001b79>
80002150:	00c10593          	addi	a1,sp,12
{
80002154:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80002158:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
8000215c:	b9dff0ef          	jal	ra,80001cf8 <z_vprintk>
}
80002160:	01c12083          	lw	ra,28(sp)
80002164:	02010113          	addi	sp,sp,32
80002168:	00008067          	ret

8000216c <printk>:
{
8000216c:	fc010113          	addi	sp,sp,-64
80002170:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80002174:	02410593          	addi	a1,sp,36
{
80002178:	00112e23          	sw	ra,28(sp)
8000217c:	02c12423          	sw	a2,40(sp)
80002180:	02d12623          	sw	a3,44(sp)
80002184:	02e12823          	sw	a4,48(sp)
80002188:	02f12a23          	sw	a5,52(sp)
8000218c:	03012c23          	sw	a6,56(sp)
80002190:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80002194:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80002198:	fa5ff0ef          	jal	ra,8000213c <vprintk>
}
8000219c:	01c12083          	lw	ra,28(sp)
800021a0:	04010113          	addi	sp,sp,64
800021a4:	00008067          	ret

800021a8 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
800021a8:	800065b7          	lui	a1,0x80006
800021ac:	80006537          	lui	a0,0x80006
{
800021b0:	ff010113          	addi	sp,sp,-16
  k_panic();
800021b4:	61458593          	addi	a1,a1,1556 # 80006614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006615>
800021b8:	62850513          	addi	a0,a0,1576 # 80006628 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006629>
800021bc:	01e00613          	li	a2,30
{
800021c0:	00112623          	sw	ra,12(sp)
  k_panic();
800021c4:	fa9ff0ef          	jal	ra,8000216c <printk>
800021c8:	800065b7          	lui	a1,0x80006
800021cc:	1f458593          	addi	a1,a1,500 # 800061f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800061f5>
800021d0:	00600513          	li	a0,6
800021d4:	e05fe0ef          	jal	ra,80000fd8 <z_NanoFatalErrorHandler>

800021d8 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800021d8:	00008067          	ret

800021dc <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
800021dc:	00800793          	li	a5,8
800021e0:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
800021e4:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
800021e8:	00008067          	ret

800021ec <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
800021ec:	00100793          	li	a5,1
800021f0:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
800021f4:	30452573          	csrrs	a0,mie,a0
}
800021f8:	00008067          	ret

800021fc <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800021fc:	00800793          	li	a5,8
80002200:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80002204:	30405073          	csrwi	mie,0
80002208:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
8000220c:	00008067          	ret

80002210 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80002210:	ff010113          	addi	sp,sp,-16
80002214:	00812423          	sw	s0,8(sp)
80002218:	00912223          	sw	s1,4(sp)
8000221c:	80007437          	lui	s0,0x80007
80002220:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80002224:	00a00793          	li	a5,10
{
80002228:	00050493          	mv	s1,a0
8000222c:	cd040413          	addi	s0,s0,-816 # 80006cd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd1>
	if ('\n' == c) {
80002230:	00f51c63          	bne	a0,a5,80002248 <console_out+0x38>
80002234:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80002238:	00d00593          	li	a1,13
8000223c:	00452783          	lw	a5,4(a0)
80002240:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80002244:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80002248:	00042503          	lw	a0,0(s0)
8000224c:	0ff4f593          	andi	a1,s1,255
80002250:	00452783          	lw	a5,4(a0)
80002254:	0047a783          	lw	a5,4(a5)
80002258:	000780e7          	jalr	a5

	return c;
}
8000225c:	00c12083          	lw	ra,12(sp)
80002260:	00812403          	lw	s0,8(sp)
80002264:	00048513          	mv	a0,s1
80002268:	00412483          	lw	s1,4(sp)
8000226c:	01010113          	addi	sp,sp,16
80002270:	00008067          	ret

80002274 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80002274:	ff010113          	addi	sp,sp,-16
80002278:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
8000227c:	80002437          	lui	s0,0x80002
80002280:	21040513          	addi	a0,s0,528 # 80002210 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002211>
{
80002284:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80002288:	5d8000ef          	jal	ra,80002860 <__stdout_hook_install>
	__printk_hook_install(console_out);
8000228c:	21040513          	addi	a0,s0,528
}
80002290:	00812403          	lw	s0,8(sp)
80002294:	00c12083          	lw	ra,12(sp)
80002298:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
8000229c:	a51ff06f          	j	80001cec <__printk_hook_install>

800022a0 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
800022a0:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
800022a4:	ff010113          	addi	sp,sp,-16
800022a8:	63450513          	addi	a0,a0,1588 # 80006634 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006635>
800022ac:	00112623          	sw	ra,12(sp)
800022b0:	189000ef          	jal	ra,80002c38 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
800022b4:	800077b7          	lui	a5,0x80007
800022b8:	cca7a823          	sw	a0,-816(a5) # 80006cd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd1>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
800022bc:	fb9ff0ef          	jal	ra,80002274 <uart_console_hook_install>

	return 0;
}
800022c0:	00c12083          	lw	ra,12(sp)
800022c4:	00000513          	li	a0,0
800022c8:	01010113          	addi	sp,sp,16
800022cc:	00008067          	ret

800022d0 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
800022d0:	f01007b7          	lui	a5,0xf0100
800022d4:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
800022d8:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
800022dc:	f447a583          	lw	a1,-188(a5)
800022e0:	fee59ae3          	bne	a1,a4,800022d4 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
800022e4:	00008067          	ret

800022e8 <timer_isr>:

static void timer_isr(void *arg)
{
800022e8:	fe010113          	addi	sp,sp,-32
800022ec:	00812c23          	sw	s0,24(sp)
800022f0:	00112e23          	sw	ra,28(sp)
800022f4:	00912a23          	sw	s1,20(sp)
800022f8:	01212823          	sw	s2,16(sp)
800022fc:	01312623          	sw	s3,12(sp)
80002300:	01412423          	sw	s4,8(sp)
80002304:	01512223          	sw	s5,4(sp)
80002308:	00800413          	li	s0,8
8000230c:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002310:	80007937          	lui	s2,0x80007
80002314:	cd490513          	addi	a0,s2,-812 # 80006cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd5>
	key = (mstatus & SOC_MSTATUS_IEN);
80002318:	00847413          	andi	s0,s0,8
8000231c:	7b4020ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80002320:	02051e63          	bnez	a0,8000235c <timer_isr+0x74>
80002324:	800064b7          	lui	s1,0x80006
80002328:	800065b7          	lui	a1,0x80006
8000232c:	80006537          	lui	a0,0x80006
80002330:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80002334:	04e00693          	li	a3,78
80002338:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
8000233c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80002340:	e2dff0ef          	jal	ra,8000216c <printk>
80002344:	80006537          	lui	a0,0x80006
80002348:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
8000234c:	e21ff0ef          	jal	ra,8000216c <printk>
80002350:	04e00593          	li	a1,78
80002354:	64848513          	addi	a0,s1,1608
80002358:	e51ff0ef          	jal	ra,800021a8 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
8000235c:	cd490513          	addi	a0,s2,-812
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002360:	800074b7          	lui	s1,0x80007
80002364:	7c4020ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
80002368:	cb048493          	addi	s1,s1,-848 # 80006cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb1>
	u64_t now = mtime();
8000236c:	f65ff0ef          	jal	ra,800022d0 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002370:	0004a983          	lw	s3,0(s1)
80002374:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80002378:	00050793          	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
8000237c:	41350533          	sub	a0,a0,s3
80002380:	00a7b7b3          	sltu	a5,a5,a0
80002384:	415585b3          	sub	a1,a1,s5
80002388:	0001d637          	lui	a2,0x1d
8000238c:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002390:	00000693          	li	a3,0
80002394:	40f585b3          	sub	a1,a1,a5
80002398:	f29fd0ef          	jal	ra,800002c0 <__udivdi3>
8000239c:	00050a13          	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
800023a0:	0001d5b7          	lui	a1,0x1d
800023a4:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800023a8:	000a0513          	mv	a0,s4
800023ac:	ce8fe0ef          	jal	ra,80000894 <__mulsi3>
800023b0:	013509b3          	add	s3,a0,s3
800023b4:	00a9b533          	sltu	a0,s3,a0
800023b8:	01550533          	add	a0,a0,s5
800023bc:	00a4a223          	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800023c0:	cd490513          	addi	a0,s2,-812
800023c4:	0134a023          	sw	s3,0(s1)
800023c8:	730020ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800023cc:	02051e63          	bnez	a0,80002408 <timer_isr+0x120>
800023d0:	800064b7          	lui	s1,0x80006
800023d4:	800065b7          	lui	a1,0x80006
800023d8:	80006537          	lui	a0,0x80006
800023dc:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800023e0:	06100693          	li	a3,97
800023e4:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800023e8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800023ec:	d81ff0ef          	jal	ra,8000216c <printk>
800023f0:	80006537          	lui	a0,0x80006
800023f4:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800023f8:	d75ff0ef          	jal	ra,8000216c <printk>
800023fc:	06100593          	li	a1,97
80002400:	64848513          	addi	a0,s1,1608
80002404:	da5ff0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002408:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
8000240c:	01812403          	lw	s0,24(sp)
80002410:	01c12083          	lw	ra,28(sp)
80002414:	01412483          	lw	s1,20(sp)
80002418:	01012903          	lw	s2,16(sp)
8000241c:	00c12983          	lw	s3,12(sp)
80002420:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002424:	000a0513          	mv	a0,s4
}
80002428:	00812a03          	lw	s4,8(sp)
8000242c:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002430:	0ec0306f          	j	8000551c <z_clock_announce>

80002434 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002434:	ff010113          	addi	sp,sp,-16
80002438:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
8000243c:	e95ff0ef          	jal	ra,800022d0 <mtime>
80002440:	0001d7b7          	lui	a5,0x1d
80002444:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80002448:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
8000244c:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80002450:	fff00693          	li	a3,-1
80002454:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002458:	00a7b533          	sltu	a0,a5,a0
8000245c:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80002460:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002464:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80002468:	00700513          	li	a0,7
8000246c:	d81ff0ef          	jal	ra,800021ec <z_arch_irq_enable>
	return 0;
}
80002470:	00c12083          	lw	ra,12(sp)
80002474:	00000513          	li	a0,0
80002478:	01010113          	addi	sp,sp,16
8000247c:	00008067          	ret

80002480 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80002480:	1a059263          	bnez	a1,80002624 <z_clock_set_timeout+0x1a4>
{
80002484:	fe010113          	addi	sp,sp,-32
80002488:	00112e23          	sw	ra,28(sp)
8000248c:	00812c23          	sw	s0,24(sp)
80002490:	00912a23          	sw	s1,20(sp)
80002494:	01212823          	sw	s2,16(sp)
80002498:	01312623          	sw	s3,12(sp)
8000249c:	01412423          	sw	s4,8(sp)
800024a0:	01512223          	sw	s5,4(sp)
800024a4:	01612023          	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
800024a8:	fff00793          	li	a5,-1
800024ac:	00f51663          	bne	a0,a5,800024b8 <z_clock_set_timeout+0x38>
800024b0:	00009537          	lui	a0,0x9
800024b4:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
800024b8:	000097b7          	lui	a5,0x9
800024bc:	fff50413          	addi	s0,a0,-1
800024c0:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
800024c4:	1487da63          	bge	a5,s0,80002618 <z_clock_set_timeout+0x198>
800024c8:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
800024cc:	00800913          	li	s2,8
800024d0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800024d4:	80007ab7          	lui	s5,0x80007
800024d8:	cd4a8513          	addi	a0,s5,-812 # 80006cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd5>
	key = (mstatus & SOC_MSTATUS_IEN);
800024dc:	00897913          	andi	s2,s2,8
800024e0:	5f0020ef          	jal	ra,80004ad0 <z_spin_lock_valid>
800024e4:	02051e63          	bnez	a0,80002520 <z_clock_set_timeout+0xa0>
800024e8:	800064b7          	lui	s1,0x80006
800024ec:	800065b7          	lui	a1,0x80006
800024f0:	80006537          	lui	a0,0x80006
800024f4:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800024f8:	04e00693          	li	a3,78
800024fc:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80002500:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80002504:	c69ff0ef          	jal	ra,8000216c <printk>
80002508:	80006537          	lui	a0,0x80006
8000250c:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80002510:	c5dff0ef          	jal	ra,8000216c <printk>
80002514:	04e00593          	li	a1,78
80002518:	64848513          	addi	a0,s1,1608
8000251c:	c8dff0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002520:	cd4a8513          	addi	a0,s5,-812
80002524:	604020ef          	jal	ra,80004b28 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002528:	da9ff0ef          	jal	ra,800022d0 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000252c:	800077b7          	lui	a5,0x80007
80002530:	cb078793          	addi	a5,a5,-848 # 80006cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb1>
	u32_t cyc = ticks * CYC_PER_TICK;
80002534:	0001d4b7          	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002538:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
8000253c:	00050a13          	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80002540:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002544:	00040513          	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002548:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
8000254c:	b48fe0ef          	jal	ra,80000894 <__mulsi3>
80002550:	4bf48793          	addi	a5,s1,1215
80002554:	413787b3          	sub	a5,a5,s3
80002558:	00f50533          	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
8000255c:	4c048593          	addi	a1,s1,1216
80002560:	00aa0533          	add	a0,s4,a0
80002564:	b5cfe0ef          	jal	ra,800008c0 <__udivsi3>
80002568:	4c048593          	addi	a1,s1,1216
8000256c:	b28fe0ef          	jal	ra,80000894 <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002570:	41498a33          	sub	s4,s3,s4
80002574:	00aa0a33          	add	s4,s4,a0
80002578:	3e700793          	li	a5,999
8000257c:	0147c663          	blt	a5,s4,80002588 <z_clock_set_timeout+0x108>
		cyc += CYC_PER_TICK;
80002580:	4c048493          	addi	s1,s1,1216
80002584:	00950533          	add	a0,a0,s1
	r[1] = 0xffffffff;
80002588:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
8000258c:	013509b3          	add	s3,a0,s3
	r[1] = 0xffffffff;
80002590:	fff00713          	li	a4,-1
80002594:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002598:	00a9b533          	sltu	a0,s3,a0
8000259c:	01650533          	add	a0,a0,s6
	r[0] = (u32_t)time;
800025a0:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
800025a4:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800025a8:	cd4a8513          	addi	a0,s5,-812
800025ac:	54c020ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800025b0:	02051e63          	bnez	a0,800025ec <z_clock_set_timeout+0x16c>
800025b4:	80006437          	lui	s0,0x80006
800025b8:	800065b7          	lui	a1,0x80006
800025bc:	80006537          	lui	a0,0x80006
800025c0:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800025c4:	06100693          	li	a3,97
800025c8:	64840613          	addi	a2,s0,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800025cc:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800025d0:	b9dff0ef          	jal	ra,8000216c <printk>
800025d4:	80006537          	lui	a0,0x80006
800025d8:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800025dc:	b91ff0ef          	jal	ra,8000216c <printk>
800025e0:	06100593          	li	a1,97
800025e4:	64840513          	addi	a0,s0,1608
800025e8:	bc1ff0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800025ec:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
800025f0:	01c12083          	lw	ra,28(sp)
800025f4:	01812403          	lw	s0,24(sp)
800025f8:	01412483          	lw	s1,20(sp)
800025fc:	01012903          	lw	s2,16(sp)
80002600:	00c12983          	lw	s3,12(sp)
80002604:	00812a03          	lw	s4,8(sp)
80002608:	00412a83          	lw	s5,4(sp)
8000260c:	00012b03          	lw	s6,0(sp)
80002610:	02010113          	addi	sp,sp,32
80002614:	00008067          	ret
80002618:	ea045ae3          	bgez	s0,800024cc <z_clock_set_timeout+0x4c>
8000261c:	00000413          	li	s0,0
80002620:	eadff06f          	j	800024cc <z_clock_set_timeout+0x4c>
80002624:	00008067          	ret

80002628 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002628:	ff010113          	addi	sp,sp,-16
8000262c:	00812423          	sw	s0,8(sp)
80002630:	00112623          	sw	ra,12(sp)
80002634:	00912223          	sw	s1,4(sp)
80002638:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000263c:	00800413          	li	s0,8
80002640:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002644:	800074b7          	lui	s1,0x80007
80002648:	cd448513          	addi	a0,s1,-812 # 80006cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd5>
	key = (mstatus & SOC_MSTATUS_IEN);
8000264c:	00847413          	andi	s0,s0,8
80002650:	480020ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80002654:	02051e63          	bnez	a0,80002690 <z_clock_elapsed+0x68>
80002658:	80006937          	lui	s2,0x80006
8000265c:	800065b7          	lui	a1,0x80006
80002660:	80006537          	lui	a0,0x80006
80002664:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80002668:	04e00693          	li	a3,78
8000266c:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80002670:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80002674:	af9ff0ef          	jal	ra,8000216c <printk>
80002678:	80006537          	lui	a0,0x80006
8000267c:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80002680:	aedff0ef          	jal	ra,8000216c <printk>
80002684:	04e00593          	li	a1,78
80002688:	64890513          	addi	a0,s2,1608
8000268c:	b1dff0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002690:	cd448513          	addi	a0,s1,-812
80002694:	494020ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80002698:	c39ff0ef          	jal	ra,800022d0 <mtime>
8000269c:	800077b7          	lui	a5,0x80007
800026a0:	cb07a783          	lw	a5,-848(a5) # 80006cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb1>
800026a4:	0001d5b7          	lui	a1,0x1d
800026a8:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800026ac:	40f50533          	sub	a0,a0,a5
800026b0:	a10fe0ef          	jal	ra,800008c0 <__udivsi3>
800026b4:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800026b8:	cd448513          	addi	a0,s1,-812
800026bc:	43c020ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800026c0:	02051e63          	bnez	a0,800026fc <z_clock_elapsed+0xd4>
800026c4:	800064b7          	lui	s1,0x80006
800026c8:	800065b7          	lui	a1,0x80006
800026cc:	80006537          	lui	a0,0x80006
800026d0:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800026d4:	06100693          	li	a3,97
800026d8:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800026dc:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800026e0:	a8dff0ef          	jal	ra,8000216c <printk>
800026e4:	80006537          	lui	a0,0x80006
800026e8:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800026ec:	a81ff0ef          	jal	ra,8000216c <printk>
800026f0:	06100593          	li	a1,97
800026f4:	64848513          	addi	a0,s1,1608
800026f8:	ab1ff0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800026fc:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002700:	00c12083          	lw	ra,12(sp)
80002704:	00812403          	lw	s0,8(sp)
80002708:	00090513          	mv	a0,s2
8000270c:	00412483          	lw	s1,4(sp)
80002710:	00012903          	lw	s2,0(sp)
80002714:	01010113          	addi	sp,sp,16
80002718:	00008067          	ret

8000271c <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
8000271c:	00054783          	lbu	a5,0(a0)
80002720:	0005c703          	lbu	a4,0(a1)
80002724:	00e79463          	bne	a5,a4,8000272c <strcmp+0x10>
80002728:	00079663          	bnez	a5,80002734 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
8000272c:	40e78533          	sub	a0,a5,a4
80002730:	00008067          	ret
		s1++;
80002734:	00150513          	addi	a0,a0,1
		s2++;
80002738:	00158593          	addi	a1,a1,1
8000273c:	fe1ff06f          	j	8000271c <strcmp>

80002740 <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80002740:	00b547b3          	xor	a5,a0,a1
80002744:	0037f793          	andi	a5,a5,3
80002748:	04078c63          	beqz	a5,800027a0 <memcpy+0x60>
	unsigned char *d_byte = (unsigned char *)d;
8000274c:	00050793          	mv	a5,a0
80002750:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80002754:	06e61663          	bne	a2,a4,800027c0 <memcpy+0x80>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80002758:	00008067          	ret
			if (n == 0) {
8000275c:	fe060ee3          	beqz	a2,80002758 <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
80002760:	00158593          	addi	a1,a1,1
80002764:	fff5c703          	lbu	a4,-1(a1)
80002768:	00178793          	addi	a5,a5,1
			n--;
8000276c:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80002770:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80002774:	0037f713          	andi	a4,a5,3
80002778:	fe0712e3          	bnez	a4,8000275c <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
8000277c:	00300693          	li	a3,3
80002780:	40e60833          	sub	a6,a2,a4
80002784:	0306e263          	bltu	a3,a6,800027a8 <memcpy+0x68>
80002788:	00265713          	srli	a4,a2,0x2
8000278c:	00271693          	slli	a3,a4,0x2
80002790:	40d60633          	sub	a2,a2,a3
80002794:	00d787b3          	add	a5,a5,a3
80002798:	00d585b3          	add	a1,a1,a3
8000279c:	fb5ff06f          	j	80002750 <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
800027a0:	00050793          	mv	a5,a0
800027a4:	fd1ff06f          	j	80002774 <memcpy+0x34>
			*(d_word++) = *(s_word++);
800027a8:	00e588b3          	add	a7,a1,a4
800027ac:	0008a883          	lw	a7,0(a7)
800027b0:	00e78833          	add	a6,a5,a4
800027b4:	00470713          	addi	a4,a4,4
800027b8:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
800027bc:	fc5ff06f          	j	80002780 <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
800027c0:	00e58833          	add	a6,a1,a4
800027c4:	00084803          	lbu	a6,0(a6)
800027c8:	00e786b3          	add	a3,a5,a4
800027cc:	00170713          	addi	a4,a4,1
800027d0:	01068023          	sb	a6,0(a3)
		n--;
800027d4:	f81ff06f          	j	80002754 <memcpy+0x14>

800027d8 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
800027d8:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
800027dc:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
800027e0:	0037f713          	andi	a4,a5,3
800027e4:	04071463          	bnez	a4,8000282c <memset+0x54>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
800027e8:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
800027ec:	00859713          	slli	a4,a1,0x8
800027f0:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
800027f4:	01059713          	slli	a4,a1,0x10
800027f8:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
800027fc:	00c78333          	add	t1,a5,a2
80002800:	00078713          	mv	a4,a5
80002804:	00300813          	li	a6,3
80002808:	40e308b3          	sub	a7,t1,a4
8000280c:	03186a63          	bltu	a6,a7,80002840 <memset+0x68>
80002810:	00265713          	srli	a4,a2,0x2
80002814:	00271593          	slli	a1,a4,0x2
80002818:	00b787b3          	add	a5,a5,a1
8000281c:	40b60633          	sub	a2,a2,a1
80002820:	00c78633          	add	a2,a5,a2

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002824:	02c79463          	bne	a5,a2,8000284c <memset+0x74>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002828:	00008067          	ret
		if (n == 0) {
8000282c:	fe060ee3          	beqz	a2,80002828 <memset+0x50>
		*(d_byte++) = c_byte;
80002830:	00178793          	addi	a5,a5,1
80002834:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002838:	fff60613          	addi	a2,a2,-1
8000283c:	fa5ff06f          	j	800027e0 <memset+0x8>
		*(d_word++) = c_word;
80002840:	00470713          	addi	a4,a4,4
80002844:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80002848:	fc1ff06f          	j	80002808 <memset+0x30>
		*(d_byte++) = c_byte;
8000284c:	00178793          	addi	a5,a5,1
80002850:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002854:	fd1ff06f          	j	80002824 <memset+0x4c>

80002858 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80002858:	fff00513          	li	a0,-1
8000285c:	00008067          	ret

80002860 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002860:	800077b7          	lui	a5,0x80007
80002864:	bea7ae23          	sw	a0,-1028(a5) # 80006bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bfd>
}
80002868:	00008067          	ret

8000286c <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
8000286c:	fe010113          	addi	sp,sp,-32
80002870:	00812c23          	sw	s0,24(sp)
	test->setup();
80002874:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80002878:	80007437          	lui	s0,0x80007
{
8000287c:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002880:	c0040413          	addi	s0,s0,-1024 # 80006c00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c01>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002884:	800074b7          	lui	s1,0x80007
{
80002888:	00112e23          	sw	ra,28(sp)
8000288c:	01212823          	sw	s2,16(sp)
80002890:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002894:	cd848493          	addi	s1,s1,-808 # 80006cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd9>
80002898:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
8000289c:	00042023          	sw	zero,0(s0)
{
800028a0:	00050913          	mv	s2,a0
	test_result = 1;
800028a4:	0134a023          	sw	s3,0(s1)
	test->setup();
800028a8:	000780e7          	jalr	a5
	test->test();
800028ac:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
800028b0:	01342023          	sw	s3,0(s0)
	test->test();
800028b4:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
800028b8:	00200793          	li	a5,2
800028bc:	00f42023          	sw	a5,0(s0)
	test->teardown();
800028c0:	00c92783          	lw	a5,12(s2)
800028c4:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
800028c8:	00300793          	li	a5,3
800028cc:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
800028d0:	01812403          	lw	s0,24(sp)
	test_result = 0;
800028d4:	0004a023          	sw	zero,0(s1)
}
800028d8:	01c12083          	lw	ra,28(sp)
800028dc:	01412483          	lw	s1,20(sp)
800028e0:	01012903          	lw	s2,16(sp)
800028e4:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800028e8:	80007537          	lui	a0,0x80007
800028ec:	eac50513          	addi	a0,a0,-340 # 80006eac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ead>
800028f0:	02010113          	addi	sp,sp,32
800028f4:	1f90106f          	j	800042ec <z_impl_k_sem_give>

800028f8 <ztest_test_fail>:
800028f8:	80007537          	lui	a0,0x80007
{
800028fc:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80002900:	800077b7          	lui	a5,0x80007
80002904:	fff00713          	li	a4,-1
80002908:	eac50513          	addi	a0,a0,-340 # 80006eac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ead>
{
8000290c:	00112623          	sw	ra,12(sp)
	test_result = -1;
80002910:	cce7ac23          	sw	a4,-808(a5) # 80006cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd9>
80002914:	1d9010ef          	jal	ra,800042ec <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002918:	101010ef          	jal	ra,80004218 <z_impl_k_current_get>
}
8000291c:	00c12083          	lw	ra,12(sp)
80002920:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002924:	5340206f          	j	80004e58 <z_impl_k_thread_abort>

80002928 <ztest_test_skip>:
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002928:	80007537          	lui	a0,0x80007
{
8000292c:	ff010113          	addi	sp,sp,-16
	test_result = -2;
80002930:	800077b7          	lui	a5,0x80007
80002934:	ffe00713          	li	a4,-2
80002938:	eac50513          	addi	a0,a0,-340 # 80006eac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ead>
{
8000293c:	00112623          	sw	ra,12(sp)
	test_result = -2;
80002940:	cce7ac23          	sw	a4,-808(a5) # 80006cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd9>
80002944:	1a9010ef          	jal	ra,800042ec <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002948:	0d1010ef          	jal	ra,80004218 <z_impl_k_current_get>
}
8000294c:	00c12083          	lw	ra,12(sp)
80002950:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002954:	5040206f          	j	80004e58 <z_impl_k_thread_abort>

80002958 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80002958:	fa010113          	addi	sp,sp,-96
8000295c:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002960:	800074b7          	lui	s1,0x80007
80002964:	cdc4a783          	lw	a5,-804(s1) # 80006cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cdd>
{
80002968:	04112e23          	sw	ra,92(sp)
8000296c:	04812c23          	sw	s0,88(sp)
80002970:	05212823          	sw	s2,80(sp)
80002974:	05312623          	sw	s3,76(sp)
80002978:	05412423          	sw	s4,72(sp)
8000297c:	05512223          	sw	s5,68(sp)
80002980:	05612023          	sw	s6,64(sp)
80002984:	03712e23          	sw	s7,60(sp)
80002988:	03812c23          	sw	s8,56(sp)
8000298c:	03912a23          	sw	s9,52(sp)
80002990:	03a12823          	sw	s10,48(sp)
80002994:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
80002998:	0807c463          	bltz	a5,80002a20 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
8000299c:	80007437          	lui	s0,0x80007
800029a0:	00100613          	li	a2,1
800029a4:	00050993          	mv	s3,a0
800029a8:	00058c13          	mv	s8,a1
800029ac:	eac40513          	addi	a0,s0,-340 # 80006eac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ead>
800029b0:	00000593          	li	a1,0
800029b4:	071010ef          	jal	ra,80004224 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
800029b8:	80006537          	lui	a0,0x80006
800029bc:	00098593          	mv	a1,s3
800029c0:	70450513          	addi	a0,a0,1796 # 80006704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006705>
800029c4:	fa8ff0ef          	jal	ra,8000216c <printk>
	PRINT_LINE;
800029c8:	80006937          	lui	s2,0x80006
800029cc:	71c90513          	addi	a0,s2,1820 # 8000671c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000671d>
		Z_TC_END_RESULT(ret, test->name);
800029d0:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
800029d4:	f98ff0ef          	jal	ra,8000216c <printk>
800029d8:	cdc48493          	addi	s1,s1,-804
	int fail = 0;
800029dc:	00000a13          	li	s4,0
800029e0:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800029e4:	80007cb7          	lui	s9,0x80007
800029e8:	80007b37          	lui	s6,0x80007
800029ec:	80003d37          	lui	s10,0x80003
	if (test_result == -1) {
800029f0:	80007db7          	lui	s11,0x80007
800029f4:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
800029f8:	6bca8a93          	addi	s5,s5,1724 # 800066bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066bd>
	while (suite->test) {
800029fc:	004c2783          	lw	a5,4(s8)
80002a00:	04079e63          	bnez	a5,80002a5c <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002a04:	00098593          	mv	a1,s3
	if (fail) {
80002a08:	100a0663          	beqz	s4,80002b14 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002a0c:	80006537          	lui	a0,0x80006
80002a10:	78c50513          	addi	a0,a0,1932 # 8000678c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000678d>
80002a14:	f58ff0ef          	jal	ra,8000216c <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002a18:	00100793          	li	a5,1
80002a1c:	00f4a023          	sw	a5,0(s1)
}
80002a20:	05c12083          	lw	ra,92(sp)
80002a24:	05812403          	lw	s0,88(sp)
80002a28:	05412483          	lw	s1,84(sp)
80002a2c:	05012903          	lw	s2,80(sp)
80002a30:	04c12983          	lw	s3,76(sp)
80002a34:	04812a03          	lw	s4,72(sp)
80002a38:	04412a83          	lw	s5,68(sp)
80002a3c:	04012b03          	lw	s6,64(sp)
80002a40:	03c12b83          	lw	s7,60(sp)
80002a44:	03812c03          	lw	s8,56(sp)
80002a48:	03412c83          	lw	s9,52(sp)
80002a4c:	03012d03          	lw	s10,48(sp)
80002a50:	02c12d83          	lw	s11,44(sp)
80002a54:	06010113          	addi	sp,sp,96
80002a58:	00008067          	ret
	TC_START(test->name);
80002a5c:	000c2583          	lw	a1,0(s8)
80002a60:	800067b7          	lui	a5,0x80006
80002a64:	76478513          	addi	a0,a5,1892 # 80006764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006765>
80002a68:	f04ff0ef          	jal	ra,8000216c <printk>
80002a6c:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002a70:	010c2783          	lw	a5,16(s8)
80002a74:	000c0713          	mv	a4,s8
80002a78:	40000613          	li	a2,1024
80002a7c:	0087e793          	ori	a5,a5,8
80002a80:	fff00893          	li	a7,-1
80002a84:	00000813          	li	a6,0
80002a88:	86cd0693          	addi	a3,s10,-1940 # 8000286c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000286d>
80002a8c:	00f12023          	sw	a5,0(sp)
80002a90:	240c8593          	addi	a1,s9,576 # 80007240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007241>
80002a94:	00000793          	li	a5,0
80002a98:	ebcb0513          	addi	a0,s6,-324 # 80006ebc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ebd>
80002a9c:	218020ef          	jal	ra,80004cb4 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002aa0:	01c12783          	lw	a5,28(sp)
80002aa4:	fff00593          	li	a1,-1
80002aa8:	eac78513          	addi	a0,a5,-340
80002aac:	125010ef          	jal	ra,800043d0 <z_impl_k_sem_take>
	if (test_result == -1) {
80002ab0:	cd8d8793          	addi	a5,s11,-808 # 80006cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd9>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002ab4:	ebcb0513          	addi	a0,s6,-324
80002ab8:	0007a403          	lw	s0,0(a5)
80002abc:	39c020ef          	jal	ra,80004e58 <z_impl_k_thread_abort>
	if (test_result == -2) {
80002ac0:	800077b7          	lui	a5,0x80007
80002ac4:	cd878793          	addi	a5,a5,-808 # 80006cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cd9>
80002ac8:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80002acc:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80002ad0:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80002ad4:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80002ad8:	000c2603          	lw	a2,0(s8)
80002adc:	02f71463          	bne	a4,a5,80002b04 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002ae0:	800065b7          	lui	a1,0x80006
80002ae4:	77858593          	addi	a1,a1,1912 # 80006778 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006779>
		Z_TC_END_RESULT(ret, test->name);
80002ae8:	780b8513          	addi	a0,s7,1920 # 80006780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006781>
80002aec:	e80ff0ef          	jal	ra,8000216c <printk>
80002af0:	71c90513          	addi	a0,s2,1820
80002af4:	e78ff0ef          	jal	ra,8000216c <printk>
		fail += run_test(suite);
80002af8:	008a0a33          	add	s4,s4,s0
		suite++;
80002afc:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002b00:	efdff06f          	j	800029fc <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80002b04:	00241793          	slli	a5,s0,0x2
80002b08:	00fa87b3          	add	a5,s5,a5
80002b0c:	0007a583          	lw	a1,0(a5)
80002b10:	fd9ff06f          	j	80002ae8 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80002b14:	80006537          	lui	a0,0x80006
80002b18:	7a450513          	addi	a0,a0,1956 # 800067a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067a5>
80002b1c:	e50ff0ef          	jal	ra,8000216c <printk>
	test_status = (test_status || fail) ? 1 : 0;
80002b20:	0004a783          	lw	a5,0(s1)
80002b24:	00f037b3          	snez	a5,a5
80002b28:	ef5ff06f          	j	80002a1c <z_ztest_run_test_suite+0xc4>

80002b2c <end_report>:

void end_report(void)
{
	if (test_status) {
80002b2c:	800077b7          	lui	a5,0x80007
80002b30:	cdc7a783          	lw	a5,-804(a5) # 80006cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cdd>
{
80002b34:	ff010113          	addi	sp,sp,-16
80002b38:	00812423          	sw	s0,8(sp)
80002b3c:	80006537          	lui	a0,0x80006
80002b40:	00112623          	sw	ra,12(sp)
80002b44:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
80002b48:	71c50513          	addi	a0,a0,1820 # 8000671c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000671d>
	if (test_status) {
80002b4c:	02078263          	beqz	a5,80002b70 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002b50:	e1cff0ef          	jal	ra,8000216c <printk>
80002b54:	800065b7          	lui	a1,0x80006
80002b58:	6c858593          	addi	a1,a1,1736 # 800066c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066c9>
	} else {
		TC_END_REPORT(TC_PASS);
80002b5c:	6d040513          	addi	a0,s0,1744 # 800066d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d1>
	}
}
80002b60:	00812403          	lw	s0,8(sp)
80002b64:	00c12083          	lw	ra,12(sp)
80002b68:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002b6c:	e00ff06f          	j	8000216c <printk>
80002b70:	dfcff0ef          	jal	ra,8000216c <printk>
80002b74:	800065b7          	lui	a1,0x80006
80002b78:	6e858593          	addi	a1,a1,1768 # 800066e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066e9>
80002b7c:	fe1ff06f          	j	80002b5c <end_report+0x30>

80002b80 <main>:

	return test_status;
}
#else
void main(void)
{
80002b80:	ff010113          	addi	sp,sp,-16
80002b84:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002b88:	df1fd0ef          	jal	ra,80000978 <test_main>
	end_report();
}
80002b8c:	00c12083          	lw	ra,12(sp)
80002b90:	01010113          	addi	sp,sp,16
	end_report();
80002b94:	f99ff06f          	j	80002b2c <end_report>

80002b98 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80002b98:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002b9c:	00012623          	sw	zero,12(sp)
    i++;
80002ba0:	00c12783          	lw	a5,12(sp)
80002ba4:	00178793          	addi	a5,a5,1
80002ba8:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002bac:	f00107b7          	lui	a5,0xf0010
80002bb0:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002bb4:	01010113          	addi	sp,sp,16
80002bb8:	00008067          	ret

80002bbc <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002bbc:	fff00513          	li	a0,-1
80002bc0:	00008067          	ret

80002bc4 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002bc4:	00000513          	li	a0,0
80002bc8:	00008067          	ret

80002bcc <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002bcc:	00251713          	slli	a4,a0,0x2
80002bd0:	800067b7          	lui	a5,0x80006
80002bd4:	00150513          	addi	a0,a0,1
80002bd8:	7d478793          	addi	a5,a5,2004 # 800067d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067d5>
80002bdc:	00251513          	slli	a0,a0,0x2
{
80002be0:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002be4:	00e78733          	add	a4,a5,a4
80002be8:	00a787b3          	add	a5,a5,a0
{
80002bec:	00812423          	sw	s0,8(sp)
80002bf0:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002bf4:	00072403          	lw	s0,0(a4)
80002bf8:	0007a483          	lw	s1,0(a5)
{
80002bfc:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002c00:	00946c63          	bltu	s0,s1,80002c18 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002c04:	00c12083          	lw	ra,12(sp)
80002c08:	00812403          	lw	s0,8(sp)
80002c0c:	00412483          	lw	s1,4(sp)
80002c10:	01010113          	addi	sp,sp,16
80002c14:	00008067          	ret
		retval = device_conf->init(info);
80002c18:	00042783          	lw	a5,0(s0)
80002c1c:	00040513          	mv	a0,s0
80002c20:	0047a783          	lw	a5,4(a5)
80002c24:	000780e7          	jalr	a5
		if (retval != 0) {
80002c28:	00050463          	beqz	a0,80002c30 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002c2c:	00042223          	sw	zero,4(s0)
								info++) {
80002c30:	00c40413          	addi	s0,s0,12
80002c34:	fcdff06f          	j	80002c00 <z_sys_device_do_config_level+0x34>

80002c38 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002c38:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c3c:	800077b7          	lui	a5,0x80007
{
80002c40:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c44:	800074b7          	lui	s1,0x80007
{
80002c48:	00812423          	sw	s0,8(sp)
80002c4c:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c50:	c1478413          	addi	s0,a5,-1004 # 80006c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c15>
{
80002c54:	01212023          	sw	s2,0(sp)
80002c58:	c1478793          	addi	a5,a5,-1004
80002c5c:	c4448493          	addi	s1,s1,-956 # 80006c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c45>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c60:	00941c63          	bne	s0,s1,80002c78 <z_impl_device_get_binding+0x40>
80002c64:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002c68:	00078413          	mv	s0,a5
80002c6c:	02941463          	bne	s0,s1,80002c94 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002c70:	00000413          	li	s0,0
80002c74:	0440006f          	j	80002cb8 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80002c78:	00442703          	lw	a4,4(s0)
80002c7c:	00070863          	beqz	a4,80002c8c <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002c80:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002c84:	00072703          	lw	a4,0(a4)
80002c88:	02a70863          	beq	a4,a0,80002cb8 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c8c:	00c40413          	addi	s0,s0,12
80002c90:	fd1ff06f          	j	80002c60 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80002c94:	00442783          	lw	a5,4(s0)
80002c98:	00079663          	bnez	a5,80002ca4 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002c9c:	00c40413          	addi	s0,s0,12
80002ca0:	fcdff06f          	j	80002c6c <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80002ca4:	00042783          	lw	a5,0(s0)
80002ca8:	00090513          	mv	a0,s2
80002cac:	0007a583          	lw	a1,0(a5)
80002cb0:	a6dff0ef          	jal	ra,8000271c <strcmp>
80002cb4:	fe0514e3          	bnez	a0,80002c9c <z_impl_device_get_binding+0x64>
}
80002cb8:	00040513          	mv	a0,s0
80002cbc:	00c12083          	lw	ra,12(sp)
80002cc0:	00812403          	lw	s0,8(sp)
80002cc4:	00412483          	lw	s1,4(sp)
80002cc8:	00012903          	lw	s2,0(sp)
80002ccc:	01010113          	addi	sp,sp,16
80002cd0:	00008067          	ret

80002cd4 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002cd4:	ff010113          	addi	sp,sp,-16
80002cd8:	00812423          	sw	s0,8(sp)
80002cdc:	00912223          	sw	s1,4(sp)
80002ce0:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002ce4:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002ce8:	00200493          	li	s1,2
80002cec:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80002cf0:	64c020ef          	jal	ra,8000533c <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002cf4:	00a4c463          	blt	s1,a0,80002cfc <idle+0x28>
80002cf8:	00100513          	li	a0,1
80002cfc:	00100593          	li	a1,1
80002d00:	718020ef          	jal	ra,80005418 <z_set_timeout_expiry>
	k_cpu_idle();
80002d04:	cd8ff0ef          	jal	ra,800021dc <k_cpu_idle>
80002d08:	fe5ff06f          	j	80002cec <idle+0x18>

80002d0c <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002d0c:	80007537          	lui	a0,0x80007
80002d10:	800077b7          	lui	a5,0x80007
80002d14:	cb050613          	addi	a2,a0,-848 # 80006cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb1>
80002d18:	03878793          	addi	a5,a5,56 # 80007038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007039>
80002d1c:	40c78633          	sub	a2,a5,a2
80002d20:	00000593          	li	a1,0
80002d24:	cb050513          	addi	a0,a0,-848
80002d28:	ab1ff06f          	j	800027d8 <memset>

80002d2c <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002d2c:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002d30:	00200513          	li	a0,2
{
80002d34:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002d38:	e95ff0ef          	jal	ra,80002bcc <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002d3c:	80006537          	lui	a0,0x80006
80002d40:	7e850513          	addi	a0,a0,2024 # 800067e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067e9>
80002d44:	c28ff0ef          	jal	ra,8000216c <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002d48:	00300513          	li	a0,3
80002d4c:	e81ff0ef          	jal	ra,80002bcc <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002d50:	058020ef          	jal	ra,80004da8 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002d54:	e2dff0ef          	jal	ra,80002b80 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002d58:	800077b7          	lui	a5,0x80007
80002d5c:	f9c78793          	addi	a5,a5,-100 # 80006f9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f9d>
80002d60:	00c7c703          	lbu	a4,12(a5)
80002d64:	ffe77713          	andi	a4,a4,-2
80002d68:	00e78623          	sb	a4,12(a5)
}
80002d6c:	00c12083          	lw	ra,12(sp)
80002d70:	01010113          	addi	sp,sp,16
80002d74:	00008067          	ret

80002d78 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002d78:	f6010113          	addi	sp,sp,-160
80002d7c:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002d80:	800087b7          	lui	a5,0x80008
80002d84:	80007437          	lui	s0,0x80007
80002d88:	09312623          	sw	s3,140(sp)
80002d8c:	24078793          	addi	a5,a5,576 # 80008240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008241>
80002d90:	00c40993          	addi	s3,s0,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80002d94:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80002d98:	01010793          	addi	a5,sp,16
80002d9c:	07000613          	li	a2,112
80002da0:	00000593          	li	a1,0
80002da4:	00078513          	mv	a0,a5
{
80002da8:	08112e23          	sw	ra,156(sp)
80002dac:	08912a23          	sw	s1,148(sp)
80002db0:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002db4:	a25ff0ef          	jal	ra,800027d8 <memset>
80002db8:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80002dbc:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002dc0:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80002dc4:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002dc8:	e05ff0ef          	jal	ra,80002bcc <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002dcc:	00100513          	li	a0,1
80002dd0:	dfdff0ef          	jal	ra,80002bcc <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002dd4:	10100793          	li	a5,257
80002dd8:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002ddc:	41c010ef          	jal	ra,800041f8 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002de0:	800077b7          	lui	a5,0x80007
80002de4:	82c78793          	addi	a5,a5,-2004 # 8000682c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000682d>
	_kernel.ready_q.cache = _main_thread;
80002de8:	80007937          	lui	s2,0x80007
	z_setup_new_thread(_main_thread, _main_stack,
80002dec:	00f12223          	sw	a5,4(sp)
80002df0:	800036b7          	lui	a3,0x80003
80002df4:	00100793          	li	a5,1
80002df8:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002dfc:	f9c90493          	addi	s1,s2,-100 # 80006f9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f9d>
	z_setup_new_thread(_main_thread, _main_stack,
80002e00:	00f12023          	sw	a5,0(sp)
80002e04:	00000713          	li	a4,0
80002e08:	00000793          	li	a5,0
80002e0c:	00000893          	li	a7,0
80002e10:	00000813          	li	a6,0
80002e14:	d2c68693          	addi	a3,a3,-724 # 80002d2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002d2d>
80002e18:	20000613          	li	a2,512
80002e1c:	64058593          	addi	a1,a1,1600 # 80007640 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007641>
80002e20:	f9c90513          	addi	a0,s2,-100
	_kernel.ready_q.cache = _main_thread;
80002e24:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002e28:	3dd010ef          	jal	ra,80004a04 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002e2c:	00d4c783          	lbu	a5,13(s1)
80002e30:	00c40413          	addi	s0,s0,12
80002e34:	ffb7f713          	andi	a4,a5,-5
80002e38:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002e3c:	01b7f793          	andi	a5,a5,27
80002e40:	00079a63          	bnez	a5,80002e54 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002e44:	0184a783          	lw	a5,24(s1)
80002e48:	00079663          	bnez	a5,80002e54 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002e4c:	f9c90513          	addi	a0,s2,-100
80002e50:	189000ef          	jal	ra,800037d8 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002e54:	800077b7          	lui	a5,0x80007
80002e58:	83478793          	addi	a5,a5,-1996 # 80006834 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006835>
80002e5c:	00f12223          	sw	a5,4(sp)
80002e60:	80007537          	lui	a0,0x80007
80002e64:	00100793          	li	a5,1
80002e68:	800036b7          	lui	a3,0x80003
80002e6c:	800085b7          	lui	a1,0x80008
80002e70:	f2c50493          	addi	s1,a0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80002e74:	00f12023          	sw	a5,0(sp)
80002e78:	00f00893          	li	a7,15
80002e7c:	00000813          	li	a6,0
80002e80:	00000793          	li	a5,0
80002e84:	00000713          	li	a4,0
80002e88:	cd468693          	addi	a3,a3,-812 # 80002cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002cd5>
80002e8c:	20000613          	li	a2,512
80002e90:	84058593          	addi	a1,a1,-1984 # 80007840 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007841>
80002e94:	f2c50513          	addi	a0,a0,-212
80002e98:	36d010ef          	jal	ra,80004a04 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002e9c:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80002ea0:	00942623          	sw	s1,12(s0)
80002ea4:	00800513          	li	a0,8
80002ea8:	ffb7f793          	andi	a5,a5,-5
80002eac:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002eb0:	800077b7          	lui	a5,0x80007
80002eb4:	02478793          	addi	a5,a5,36 # 80007024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007025>
80002eb8:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002ebc:	00f42e23          	sw	a5,28(s0)
80002ec0:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002ec4:	00857513          	andi	a0,a0,8
80002ec8:	b70fd0ef          	jal	ra,80000238 <__swap>

80002ecc <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002ecc:	00d54783          	lbu	a5,13(a0)
80002ed0:	01f7f793          	andi	a5,a5,31
80002ed4:	00079863          	bnez	a5,80002ee4 <z_is_thread_ready+0x18>
80002ed8:	01852503          	lw	a0,24(a0)
80002edc:	00153513          	seqz	a0,a0
80002ee0:	00008067          	ret
80002ee4:	00000513          	li	a0,0
}
80002ee8:	00008067          	ret

80002eec <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002eec:	ff010113          	addi	sp,sp,-16
80002ef0:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002ef4:	f34ff0ef          	jal	ra,80002628 <z_clock_elapsed>
80002ef8:	800077b7          	lui	a5,0x80007
80002efc:	ce87a783          	lw	a5,-792(a5) # 80006ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce9>

	z_set_timeout_expiry(slice_time, false);
}
80002f00:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002f04:	80007737          	lui	a4,0x80007
80002f08:	00a78533          	add	a0,a5,a0
80002f0c:	00a72e23          	sw	a0,28(a4) # 8000701c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000701d>
	z_set_timeout_expiry(slice_time, false);
80002f10:	00000593          	li	a1,0
80002f14:	00078513          	mv	a0,a5
}
80002f18:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002f1c:	4fc0206f          	j	80005418 <z_set_timeout_expiry>

80002f20 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002f20:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002f24:	ff010113          	addi	sp,sp,-16
80002f28:	00812423          	sw	s0,8(sp)
80002f2c:	00112623          	sw	ra,12(sp)
80002f30:	00912223          	sw	s1,4(sp)
80002f34:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002f38:	02079863          	bnez	a5,80002f68 <pended_on.isra.15+0x48>
80002f3c:	800074b7          	lui	s1,0x80007
80002f40:	800075b7          	lui	a1,0x80007
80002f44:	80006537          	lui	a0,0x80006
80002f48:	8d458593          	addi	a1,a1,-1836 # 800068d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068d5>
80002f4c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80002f50:	18300693          	li	a3,387
80002f54:	8c048613          	addi	a2,s1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80002f58:	a14ff0ef          	jal	ra,8000216c <printk>
80002f5c:	18300593          	li	a1,387
80002f60:	8c048513          	addi	a0,s1,-1856
80002f64:	a44ff0ef          	jal	ra,800021a8 <assert_post_action>

	return thread->base.pended_on;
}
80002f68:	00042503          	lw	a0,0(s0)
80002f6c:	00c12083          	lw	ra,12(sp)
80002f70:	00812403          	lw	s0,8(sp)
80002f74:	00412483          	lw	s1,4(sp)
80002f78:	01010113          	addi	sp,sp,16
80002f7c:	00008067          	ret

80002f80 <k_sched_time_slice_set>:
{
80002f80:	fe010113          	addi	sp,sp,-32
80002f84:	00812c23          	sw	s0,24(sp)
80002f88:	01312623          	sw	s3,12(sp)
80002f8c:	01412423          	sw	s4,8(sp)
80002f90:	00112e23          	sw	ra,28(sp)
80002f94:	00912a23          	sw	s1,20(sp)
80002f98:	01212823          	sw	s2,16(sp)
80002f9c:	00050a13          	mv	s4,a0
80002fa0:	00058993          	mv	s3,a1
80002fa4:	00800413          	li	s0,8
80002fa8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002fac:	800074b7          	lui	s1,0x80007
80002fb0:	ce048513          	addi	a0,s1,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002fb4:	00847413          	andi	s0,s0,8
80002fb8:	319010ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80002fbc:	02051e63          	bnez	a0,80002ff8 <k_sched_time_slice_set+0x78>
80002fc0:	80006937          	lui	s2,0x80006
80002fc4:	800065b7          	lui	a1,0x80006
80002fc8:	80006537          	lui	a0,0x80006
80002fcc:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80002fd0:	04e00693          	li	a3,78
80002fd4:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80002fd8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80002fdc:	990ff0ef          	jal	ra,8000216c <printk>
80002fe0:	80006537          	lui	a0,0x80006
80002fe4:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80002fe8:	984ff0ef          	jal	ra,8000216c <printk>
80002fec:	04e00593          	li	a1,78
80002ff0:	64890513          	addi	a0,s2,1608
80002ff4:	9b4ff0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002ff8:	ce048513          	addi	a0,s1,-800
80002ffc:	32d010ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80003000:	800077b7          	lui	a5,0x80007
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80003004:	00a00593          	li	a1,10
80003008:	009a0513          	addi	a0,s4,9
8000300c:	0007ae23          	sw	zero,28(a5) # 8000701c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000701d>
80003010:	8a9fd0ef          	jal	ra,800008b8 <__divsi3>
		slice_max_prio = prio;
80003014:	800077b7          	lui	a5,0x80007
		slice_time = z_ms_to_ticks(slice);
80003018:	80007937          	lui	s2,0x80007
8000301c:	cea92423          	sw	a0,-792(s2) # 80006ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce9>
		slice_max_prio = prio;
80003020:	cf37a223          	sw	s3,-796(a5) # 80006ce4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce5>
		reset_time_slice();
80003024:	ec9ff0ef          	jal	ra,80002eec <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003028:	ce048513          	addi	a0,s1,-800
8000302c:	2cd010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80003030:	02051e63          	bnez	a0,8000306c <k_sched_time_slice_set+0xec>
80003034:	800064b7          	lui	s1,0x80006
80003038:	800065b7          	lui	a1,0x80006
8000303c:	80006537          	lui	a0,0x80006
80003040:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80003044:	06100693          	li	a3,97
80003048:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
8000304c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003050:	91cff0ef          	jal	ra,8000216c <printk>
80003054:	80006537          	lui	a0,0x80006
80003058:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
8000305c:	910ff0ef          	jal	ra,8000216c <printk>
80003060:	06100593          	li	a1,97
80003064:	64848513          	addi	a0,s1,1608
80003068:	940ff0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000306c:	30042473          	csrrs	s0,mstatus,s0
}
80003070:	01c12083          	lw	ra,28(sp)
80003074:	01812403          	lw	s0,24(sp)
80003078:	01412483          	lw	s1,20(sp)
8000307c:	01012903          	lw	s2,16(sp)
80003080:	00c12983          	lw	s3,12(sp)
80003084:	00812a03          	lw	s4,8(sp)
80003088:	02010113          	addi	sp,sp,32
8000308c:	00008067          	ret

80003090 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80003090:	fe010113          	addi	sp,sp,-32
80003094:	00812c23          	sw	s0,24(sp)
80003098:	01212823          	sw	s2,16(sp)
8000309c:	00112e23          	sw	ra,28(sp)
800030a0:	00912a23          	sw	s1,20(sp)
800030a4:	01312623          	sw	s3,12(sp)
800030a8:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800030ac:	00800413          	li	s0,8
800030b0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800030b4:	800074b7          	lui	s1,0x80007
800030b8:	ce048513          	addi	a0,s1,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
800030bc:	00847413          	andi	s0,s0,8
800030c0:	211010ef          	jal	ra,80004ad0 <z_spin_lock_valid>
800030c4:	02051e63          	bnez	a0,80003100 <z_unpend_thread_no_timeout+0x70>
800030c8:	800069b7          	lui	s3,0x80006
800030cc:	800065b7          	lui	a1,0x80006
800030d0:	80006537          	lui	a0,0x80006
800030d4:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800030d8:	04e00693          	li	a3,78
800030dc:	64898613          	addi	a2,s3,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800030e0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800030e4:	888ff0ef          	jal	ra,8000216c <printk>
800030e8:	80006537          	lui	a0,0x80006
800030ec:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
800030f0:	87cff0ef          	jal	ra,8000216c <printk>
800030f4:	04e00593          	li	a1,78
800030f8:	64898513          	addi	a0,s3,1608
800030fc:	8acff0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003100:	ce048513          	addi	a0,s1,-800
80003104:	225010ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003108:	00890513          	addi	a0,s2,8
8000310c:	e15ff0ef          	jal	ra,80002f20 <pended_on.isra.15>
80003110:	00090593          	mv	a1,s2
80003114:	2f0000ef          	jal	ra,80003404 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003118:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000311c:	ce048513          	addi	a0,s1,-800
80003120:	ffd7f793          	andi	a5,a5,-3
80003124:	00f906a3          	sb	a5,13(s2)
80003128:	1d1010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
8000312c:	02051e63          	bnez	a0,80003168 <z_unpend_thread_no_timeout+0xd8>
80003130:	800064b7          	lui	s1,0x80006
80003134:	800065b7          	lui	a1,0x80006
80003138:	80006537          	lui	a0,0x80006
8000313c:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80003140:	06100693          	li	a3,97
80003144:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003148:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
8000314c:	820ff0ef          	jal	ra,8000216c <printk>
80003150:	80006537          	lui	a0,0x80006
80003154:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80003158:	814ff0ef          	jal	ra,8000216c <printk>
8000315c:	06100593          	li	a1,97
80003160:	64848513          	addi	a0,s1,1608
80003164:	844ff0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003168:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
8000316c:	01c12083          	lw	ra,28(sp)
80003170:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003174:	00092423          	sw	zero,8(s2)
}
80003178:	01412483          	lw	s1,20(sp)
8000317c:	01012903          	lw	s2,16(sp)
80003180:	00c12983          	lw	s3,12(sp)
80003184:	02010113          	addi	sp,sp,32
80003188:	00008067          	ret

8000318c <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
8000318c:	800077b7          	lui	a5,0x80007
80003190:	00c7a783          	lw	a5,12(a5) # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
{
80003194:	ff010113          	addi	sp,sp,-16
80003198:	00812423          	sw	s0,8(sp)
8000319c:	00112623          	sw	ra,12(sp)
800031a0:	00912223          	sw	s1,4(sp)
800031a4:	00058413          	mv	s0,a1
	if (resched()) {
800031a8:	04079e63          	bnez	a5,80003204 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800031ac:	14d010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800031b0:	02051e63          	bnez	a0,800031ec <z_reschedule+0x60>
800031b4:	800064b7          	lui	s1,0x80006
800031b8:	800065b7          	lui	a1,0x80006
800031bc:	80006537          	lui	a0,0x80006
800031c0:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800031c4:	07800693          	li	a3,120
800031c8:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800031cc:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800031d0:	f9dfe0ef          	jal	ra,8000216c <printk>
800031d4:	80006537          	lui	a0,0x80006
800031d8:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800031dc:	f91fe0ef          	jal	ra,8000216c <printk>
800031e0:	07800593          	li	a1,120
800031e4:	64848513          	addi	a0,s1,1608
800031e8:	fc1fe0ef          	jal	ra,800021a8 <assert_post_action>
800031ec:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
800031f0:	00812403          	lw	s0,8(sp)
800031f4:	00c12083          	lw	ra,12(sp)
800031f8:	00412483          	lw	s1,4(sp)
800031fc:	01010113          	addi	sp,sp,16
80003200:	838fd06f          	j	80000238 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003204:	0f5010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80003208:	02051e63          	bnez	a0,80003244 <z_reschedule+0xb8>
8000320c:	800064b7          	lui	s1,0x80006
80003210:	800065b7          	lui	a1,0x80006
80003214:	80006537          	lui	a0,0x80006
80003218:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
8000321c:	06100693          	li	a3,97
80003220:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003224:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003228:	f45fe0ef          	jal	ra,8000216c <printk>
8000322c:	80006537          	lui	a0,0x80006
80003230:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80003234:	f39fe0ef          	jal	ra,8000216c <printk>
80003238:	06100593          	li	a1,97
8000323c:	64848513          	addi	a0,s1,1608
80003240:	f69fe0ef          	jal	ra,800021a8 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003244:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003248:	30042473          	csrrs	s0,mstatus,s0
8000324c:	00c12083          	lw	ra,12(sp)
80003250:	00812403          	lw	s0,8(sp)
80003254:	00412483          	lw	s1,4(sp)
80003258:	01010113          	addi	sp,sp,16
8000325c:	00008067          	ret

80003260 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003260:	80007737          	lui	a4,0x80007
80003264:	00c72703          	lw	a4,12(a4) # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80003268:	00071463          	bnez	a4,80003270 <z_reschedule_irqlock+0x10>
8000326c:	fcdfc06f          	j	80000238 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003270:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003274:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80003278:	00008067          	ret

8000327c <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000327c:	00800513          	li	a0,8
80003280:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80003284:	00857513          	andi	a0,a0,8
80003288:	fd9ff06f          	j	80003260 <z_reschedule_irqlock>

8000328c <k_sched_lock>:

void k_sched_lock(void)
{
8000328c:	fe010113          	addi	sp,sp,-32
80003290:	00812c23          	sw	s0,24(sp)
80003294:	00112e23          	sw	ra,28(sp)
80003298:	00912a23          	sw	s1,20(sp)
8000329c:	01212823          	sw	s2,16(sp)
800032a0:	01312623          	sw	s3,12(sp)
800032a4:	00800413          	li	s0,8
800032a8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800032ac:	800074b7          	lui	s1,0x80007
800032b0:	ce048513          	addi	a0,s1,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
800032b4:	00847413          	andi	s0,s0,8
800032b8:	019010ef          	jal	ra,80004ad0 <z_spin_lock_valid>
800032bc:	02051e63          	bnez	a0,800032f8 <k_sched_lock+0x6c>
800032c0:	80006937          	lui	s2,0x80006
800032c4:	800065b7          	lui	a1,0x80006
800032c8:	80006537          	lui	a0,0x80006
800032cc:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800032d0:	04e00693          	li	a3,78
800032d4:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800032d8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800032dc:	e91fe0ef          	jal	ra,8000216c <printk>
800032e0:	80006537          	lui	a0,0x80006
800032e4:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
800032e8:	e85fe0ef          	jal	ra,8000216c <printk>
800032ec:	04e00593          	li	a1,78
800032f0:	64890513          	addi	a0,s2,1608
800032f4:	eb5fe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800032f8:	ce048513          	addi	a0,s1,-800
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
800032fc:	80007937          	lui	s2,0x80007
80003300:	029010ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
80003304:	00c92783          	lw	a5,12(s2) # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80003308:	00c90913          	addi	s2,s2,12
8000330c:	02078e63          	beqz	a5,80003348 <k_sched_lock+0xbc>
80003310:	800079b7          	lui	s3,0x80007
80003314:	800075b7          	lui	a1,0x80007
80003318:	80006537          	lui	a0,0x80006
8000331c:	85858593          	addi	a1,a1,-1960 # 80006858 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006859>
80003320:	10000693          	li	a3,256
80003324:	83c98613          	addi	a2,s3,-1988 # 8000683c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000683d>
80003328:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
8000332c:	e41fe0ef          	jal	ra,8000216c <printk>
80003330:	80006537          	lui	a0,0x80006
80003334:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
80003338:	e35fe0ef          	jal	ra,8000216c <printk>
8000333c:	10000593          	li	a1,256
80003340:	83c98513          	addi	a0,s3,-1988
80003344:	e65fe0ef          	jal	ra,800021a8 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80003348:	00892783          	lw	a5,8(s2)
8000334c:	00f7c703          	lbu	a4,15(a5)
80003350:	00100793          	li	a5,1
80003354:	02f71e63          	bne	a4,a5,80003390 <k_sched_lock+0x104>
80003358:	800079b7          	lui	s3,0x80007
8000335c:	800075b7          	lui	a1,0x80007
80003360:	80006537          	lui	a0,0x80006
80003364:	87058593          	addi	a1,a1,-1936 # 80006870 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006871>
80003368:	10100693          	li	a3,257
8000336c:	83c98613          	addi	a2,s3,-1988 # 8000683c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000683d>
80003370:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003374:	df9fe0ef          	jal	ra,8000216c <printk>
80003378:	80006537          	lui	a0,0x80006
8000337c:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
80003380:	dedfe0ef          	jal	ra,8000216c <printk>
80003384:	10100593          	li	a1,257
80003388:	83c98513          	addi	a0,s3,-1988
8000338c:	e1dfe0ef          	jal	ra,800021a8 <assert_post_action>

	--_current->base.sched_locked;
80003390:	00892703          	lw	a4,8(s2)
80003394:	00f74783          	lbu	a5,15(a4)
80003398:	fff78793          	addi	a5,a5,-1
8000339c:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800033a0:	ce048513          	addi	a0,s1,-800
800033a4:	754010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800033a8:	02051e63          	bnez	a0,800033e4 <k_sched_lock+0x158>
800033ac:	800064b7          	lui	s1,0x80006
800033b0:	800065b7          	lui	a1,0x80006
800033b4:	80006537          	lui	a0,0x80006
800033b8:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800033bc:	06100693          	li	a3,97
800033c0:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800033c4:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800033c8:	da5fe0ef          	jal	ra,8000216c <printk>
800033cc:	80006537          	lui	a0,0x80006
800033d0:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800033d4:	d99fe0ef          	jal	ra,8000216c <printk>
800033d8:	06100593          	li	a1,97
800033dc:	64848513          	addi	a0,s1,1608
800033e0:	dc9fe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800033e4:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800033e8:	01c12083          	lw	ra,28(sp)
800033ec:	01812403          	lw	s0,24(sp)
800033f0:	01412483          	lw	s1,20(sp)
800033f4:	01012903          	lw	s2,16(sp)
800033f8:	00c12983          	lw	s3,12(sp)
800033fc:	02010113          	addi	sp,sp,32
80003400:	00008067          	ret

80003404 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80003404:	800077b7          	lui	a5,0x80007
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80003408:	c107a783          	lw	a5,-1008(a5) # 80006c10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c11>
{
8000340c:	ff010113          	addi	sp,sp,-16
80003410:	00812423          	sw	s0,8(sp)
80003414:	00112623          	sw	ra,12(sp)
80003418:	00912223          	sw	s1,4(sp)
8000341c:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80003420:	02f59863          	bne	a1,a5,80003450 <z_priq_dumb_remove+0x4c>
80003424:	800074b7          	lui	s1,0x80007
80003428:	800075b7          	lui	a1,0x80007
8000342c:	80006537          	lui	a0,0x80006
80003430:	90c58593          	addi	a1,a1,-1780 # 8000690c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000690d>
80003434:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003438:	28c00693          	li	a3,652
8000343c:	8c048613          	addi	a2,s1,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003440:	d2dfe0ef          	jal	ra,8000216c <printk>
80003444:	28c00593          	li	a1,652
80003448:	8c048513          	addi	a0,s1,-1856
8000344c:	d5dfe0ef          	jal	ra,800021a8 <assert_post_action>
	node->prev->next = node->next;
80003450:	00442703          	lw	a4,4(s0)
80003454:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80003458:	00c12083          	lw	ra,12(sp)
8000345c:	00412483          	lw	s1,4(sp)
80003460:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80003464:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80003468:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
8000346c:	00042223          	sw	zero,4(s0)
80003470:	00812403          	lw	s0,8(sp)
80003474:	01010113          	addi	sp,sp,16
80003478:	00008067          	ret

8000347c <z_unpend_thread>:
{
8000347c:	fe010113          	addi	sp,sp,-32
80003480:	00812c23          	sw	s0,24(sp)
80003484:	00912a23          	sw	s1,20(sp)
80003488:	00112e23          	sw	ra,28(sp)
8000348c:	01212823          	sw	s2,16(sp)
80003490:	01312623          	sw	s3,12(sp)
80003494:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003498:	00800493          	li	s1,8
8000349c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800034a0:	80007937          	lui	s2,0x80007
800034a4:	ce090513          	addi	a0,s2,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
800034a8:	0084f493          	andi	s1,s1,8
800034ac:	624010ef          	jal	ra,80004ad0 <z_spin_lock_valid>
800034b0:	02051e63          	bnez	a0,800034ec <z_unpend_thread+0x70>
800034b4:	800069b7          	lui	s3,0x80006
800034b8:	800065b7          	lui	a1,0x80006
800034bc:	80006537          	lui	a0,0x80006
800034c0:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800034c4:	04e00693          	li	a3,78
800034c8:	64898613          	addi	a2,s3,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800034cc:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800034d0:	c9dfe0ef          	jal	ra,8000216c <printk>
800034d4:	80006537          	lui	a0,0x80006
800034d8:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
800034dc:	c91fe0ef          	jal	ra,8000216c <printk>
800034e0:	04e00593          	li	a1,78
800034e4:	64898513          	addi	a0,s3,1608
800034e8:	cc1fe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800034ec:	ce090513          	addi	a0,s2,-800
800034f0:	638010ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800034f4:	00840513          	addi	a0,s0,8
800034f8:	a29ff0ef          	jal	ra,80002f20 <pended_on.isra.15>
800034fc:	00040593          	mv	a1,s0
80003500:	f05ff0ef          	jal	ra,80003404 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003504:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003508:	ce090513          	addi	a0,s2,-800
8000350c:	ffd7f793          	andi	a5,a5,-3
80003510:	00f406a3          	sb	a5,13(s0)
80003514:	5e4010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80003518:	02051e63          	bnez	a0,80003554 <z_unpend_thread+0xd8>
8000351c:	80006937          	lui	s2,0x80006
80003520:	800065b7          	lui	a1,0x80006
80003524:	80006537          	lui	a0,0x80006
80003528:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
8000352c:	06100693          	li	a3,97
80003530:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003534:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003538:	c35fe0ef          	jal	ra,8000216c <printk>
8000353c:	80006537          	lui	a0,0x80006
80003540:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80003544:	c29fe0ef          	jal	ra,8000216c <printk>
80003548:	06100593          	li	a1,97
8000354c:	64890513          	addi	a0,s2,1608
80003550:	c59fe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003554:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003558:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
8000355c:	01840513          	addi	a0,s0,24
}
80003560:	01812403          	lw	s0,24(sp)
80003564:	01c12083          	lw	ra,28(sp)
80003568:	01412483          	lw	s1,20(sp)
8000356c:	01012903          	lw	s2,16(sp)
80003570:	00c12983          	lw	s3,12(sp)
80003574:	02010113          	addi	sp,sp,32
80003578:	4cd0106f          	j	80005244 <z_abort_timeout>

8000357c <z_priq_dumb_best>:
	return list->head == list;
8000357c:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003580:	00f51463          	bne	a0,a5,80003588 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003584:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80003588:	00078513          	mv	a0,a5
8000358c:	00008067          	ret

80003590 <update_cache>:
{
80003590:	ff010113          	addi	sp,sp,-16
80003594:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003598:	80007437          	lui	s0,0x80007
{
8000359c:	01212023          	sw	s2,0(sp)
800035a0:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800035a4:	00c40513          	addi	a0,s0,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
800035a8:	02450513          	addi	a0,a0,36
{
800035ac:	00912223          	sw	s1,4(sp)
800035b0:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800035b4:	fc9ff0ef          	jal	ra,8000357c <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
800035b8:	00c40413          	addi	s0,s0,12
800035bc:	00050493          	mv	s1,a0
800035c0:	00051463          	bnez	a0,800035c8 <update_cache+0x38>
800035c4:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
800035c8:	06091e63          	bnez	s2,80003644 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
800035cc:	00842783          	lw	a5,8(s0)
800035d0:	02079e63          	bnez	a5,8000360c <update_cache+0x7c>
800035d4:	80007937          	lui	s2,0x80007
800035d8:	800075b7          	lui	a1,0x80007
800035dc:	80006537          	lui	a0,0x80006
800035e0:	8ec58593          	addi	a1,a1,-1812 # 800068ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068ed>
800035e4:	07f00693          	li	a3,127
800035e8:	8c090613          	addi	a2,s2,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800035ec:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800035f0:	b7dfe0ef          	jal	ra,8000216c <printk>
800035f4:	80006537          	lui	a0,0x80006
800035f8:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
800035fc:	b71fe0ef          	jal	ra,8000216c <printk>
80003600:	07f00593          	li	a1,127
80003604:	8c090513          	addi	a0,s2,-1856
80003608:	ba1fe0ef          	jal	ra,800021a8 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
8000360c:	00842783          	lw	a5,8(s0)
80003610:	00d7c703          	lbu	a4,13(a5)
80003614:	01f77713          	andi	a4,a4,31
80003618:	02071663          	bnez	a4,80003644 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
8000361c:	00e7d683          	lhu	a3,14(a5)
80003620:	07f00713          	li	a4,127
80003624:	02d77063          	bgeu	a4,a3,80003644 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
80003628:	02f42023          	sw	a5,32(s0)
}
8000362c:	00c12083          	lw	ra,12(sp)
80003630:	00812403          	lw	s0,8(sp)
80003634:	00412483          	lw	s1,4(sp)
80003638:	00012903          	lw	s2,0(sp)
8000363c:	01010113          	addi	sp,sp,16
80003640:	00008067          	ret
		if (th != _current) {
80003644:	00842783          	lw	a5,8(s0)
80003648:	00978463          	beq	a5,s1,80003650 <update_cache+0xc0>
			reset_time_slice();
8000364c:	8a1ff0ef          	jal	ra,80002eec <reset_time_slice>
		_kernel.ready_q.cache = th;
80003650:	02942023          	sw	s1,32(s0)
}
80003654:	fd9ff06f          	j	8000362c <update_cache+0x9c>

80003658 <k_sched_unlock>:
{
80003658:	fe010113          	addi	sp,sp,-32
8000365c:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003660:	80007937          	lui	s2,0x80007
80003664:	00c90793          	addi	a5,s2,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80003668:	0087a783          	lw	a5,8(a5)
{
8000366c:	00112e23          	sw	ra,28(sp)
80003670:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003674:	00f7c783          	lbu	a5,15(a5)
{
80003678:	00912a23          	sw	s1,20(sp)
8000367c:	01312623          	sw	s3,12(sp)
80003680:	00c90913          	addi	s2,s2,12
	__ASSERT(_current->base.sched_locked != 0, "");
80003684:	02079e63          	bnez	a5,800036c0 <k_sched_unlock+0x68>
80003688:	80007437          	lui	s0,0x80007
8000368c:	800075b7          	lui	a1,0x80007
80003690:	80006537          	lui	a0,0x80006
80003694:	89858593          	addi	a1,a1,-1896 # 80006898 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006899>
80003698:	22100693          	li	a3,545
8000369c:	8c040613          	addi	a2,s0,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800036a0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800036a4:	ac9fe0ef          	jal	ra,8000216c <printk>
800036a8:	80006537          	lui	a0,0x80006
800036ac:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
800036b0:	abdfe0ef          	jal	ra,8000216c <printk>
800036b4:	22100593          	li	a1,545
800036b8:	8c040513          	addi	a0,s0,-1856
800036bc:	aedfe0ef          	jal	ra,800021a8 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800036c0:	00092783          	lw	a5,0(s2)
800036c4:	02078e63          	beqz	a5,80003700 <k_sched_unlock+0xa8>
800036c8:	80007437          	lui	s0,0x80007
800036cc:	800075b7          	lui	a1,0x80007
800036d0:	80006537          	lui	a0,0x80006
800036d4:	85858593          	addi	a1,a1,-1960 # 80006858 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006859>
800036d8:	22200693          	li	a3,546
800036dc:	8c040613          	addi	a2,s0,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
800036e0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800036e4:	a89fe0ef          	jal	ra,8000216c <printk>
800036e8:	80006537          	lui	a0,0x80006
800036ec:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
800036f0:	a7dfe0ef          	jal	ra,8000216c <printk>
800036f4:	22200593          	li	a1,546
800036f8:	8c040513          	addi	a0,s0,-1856
800036fc:	aadfe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003700:	00800413          	li	s0,8
80003704:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003708:	800074b7          	lui	s1,0x80007
8000370c:	ce048513          	addi	a0,s1,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003710:	00847413          	andi	s0,s0,8
80003714:	3bc010ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80003718:	02051e63          	bnez	a0,80003754 <k_sched_unlock+0xfc>
8000371c:	800069b7          	lui	s3,0x80006
80003720:	800065b7          	lui	a1,0x80006
80003724:	80006537          	lui	a0,0x80006
80003728:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
8000372c:	04e00693          	li	a3,78
80003730:	64898613          	addi	a2,s3,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003734:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003738:	a35fe0ef          	jal	ra,8000216c <printk>
8000373c:	80006537          	lui	a0,0x80006
80003740:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80003744:	a29fe0ef          	jal	ra,8000216c <printk>
80003748:	04e00593          	li	a1,78
8000374c:	64898513          	addi	a0,s3,1608
80003750:	a59fe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003754:	ce048513          	addi	a0,s1,-800
80003758:	3d0010ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
8000375c:	00892703          	lw	a4,8(s2)
		update_cache(1);
80003760:	00100513          	li	a0,1
		++_current->base.sched_locked;
80003764:	00f74783          	lbu	a5,15(a4)
80003768:	00178793          	addi	a5,a5,1
8000376c:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80003770:	e21ff0ef          	jal	ra,80003590 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003774:	ce048513          	addi	a0,s1,-800
80003778:	380010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
8000377c:	02051e63          	bnez	a0,800037b8 <k_sched_unlock+0x160>
80003780:	800064b7          	lui	s1,0x80006
80003784:	800065b7          	lui	a1,0x80006
80003788:	80006537          	lui	a0,0x80006
8000378c:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80003790:	06100693          	li	a3,97
80003794:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003798:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
8000379c:	9d1fe0ef          	jal	ra,8000216c <printk>
800037a0:	80006537          	lui	a0,0x80006
800037a4:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800037a8:	9c5fe0ef          	jal	ra,8000216c <printk>
800037ac:	06100593          	li	a1,97
800037b0:	64848513          	addi	a0,s1,1608
800037b4:	9f5fe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800037b8:	30042473          	csrrs	s0,mstatus,s0
}
800037bc:	01812403          	lw	s0,24(sp)
800037c0:	01c12083          	lw	ra,28(sp)
800037c4:	01412483          	lw	s1,20(sp)
800037c8:	01012903          	lw	s2,16(sp)
800037cc:	00c12983          	lw	s3,12(sp)
800037d0:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
800037d4:	aa9ff06f          	j	8000327c <z_reschedule_unlocked>

800037d8 <z_add_thread_to_ready_q>:
{
800037d8:	fe010113          	addi	sp,sp,-32
800037dc:	00812c23          	sw	s0,24(sp)
800037e0:	00912a23          	sw	s1,20(sp)
800037e4:	00112e23          	sw	ra,28(sp)
800037e8:	01212823          	sw	s2,16(sp)
800037ec:	01312623          	sw	s3,12(sp)
800037f0:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800037f4:	00800493          	li	s1,8
800037f8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800037fc:	80007937          	lui	s2,0x80007
80003800:	ce090513          	addi	a0,s2,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003804:	0084f493          	andi	s1,s1,8
80003808:	2c8010ef          	jal	ra,80004ad0 <z_spin_lock_valid>
8000380c:	02051e63          	bnez	a0,80003848 <z_add_thread_to_ready_q+0x70>
80003810:	800069b7          	lui	s3,0x80006
80003814:	800065b7          	lui	a1,0x80006
80003818:	80006537          	lui	a0,0x80006
8000381c:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80003820:	04e00693          	li	a3,78
80003824:	64898613          	addi	a2,s3,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003828:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
8000382c:	941fe0ef          	jal	ra,8000216c <printk>
80003830:	80006537          	lui	a0,0x80006
80003834:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80003838:	935fe0ef          	jal	ra,8000216c <printk>
8000383c:	04e00593          	li	a1,78
80003840:	64898513          	addi	a0,s3,1608
80003844:	965fe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003848:	ce090513          	addi	a0,s2,-800
8000384c:	2dc010ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003850:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003854:	c107a783          	lw	a5,-1008(a5) # 80006c10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c11>
80003858:	02f41863          	bne	s0,a5,80003888 <z_add_thread_to_ready_q+0xb0>
8000385c:	800079b7          	lui	s3,0x80007
80003860:	800075b7          	lui	a1,0x80007
80003864:	80006537          	lui	a0,0x80006
80003868:	90c58593          	addi	a1,a1,-1780 # 8000690c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000690d>
8000386c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003870:	27600693          	li	a3,630
80003874:	8c098613          	addi	a2,s3,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003878:	8f5fe0ef          	jal	ra,8000216c <printk>
8000387c:	27600593          	li	a1,630
80003880:	8c098513          	addi	a0,s3,-1856
80003884:	925fe0ef          	jal	ra,800021a8 <assert_post_action>
	return list->head == list;
80003888:	80007737          	lui	a4,0x80007
8000388c:	00c70693          	addi	a3,a4,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80003890:	0246a783          	lw	a5,36(a3)
80003894:	0286a603          	lw	a2,40(a3)
80003898:	800076b7          	lui	a3,0x80007
8000389c:	03068693          	addi	a3,a3,48 # 80007030 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007031>
800038a0:	00c70713          	addi	a4,a4,12
	return sys_dlist_is_empty(list) ? NULL : list->head;
800038a4:	0ad78663          	beq	a5,a3,80003950 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800038a8:	0a078463          	beqz	a5,80003950 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
800038ac:	00e40583          	lb	a1,14(s0)
800038b0:	00e78503          	lb	a0,14(a5)
800038b4:	08a5d863          	bge	a1,a0,80003944 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
800038b8:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800038bc:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
800038c0:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800038c4:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800038c8:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
800038cc:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
800038d0:	00000513          	li	a0,0
800038d4:	0407e793          	ori	a5,a5,64
800038d8:	00f406a3          	sb	a5,13(s0)
800038dc:	cb5ff0ef          	jal	ra,80003590 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800038e0:	ce090513          	addi	a0,s2,-800
800038e4:	214010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800038e8:	02051e63          	bnez	a0,80003924 <z_add_thread_to_ready_q+0x14c>
800038ec:	80006437          	lui	s0,0x80006
800038f0:	800065b7          	lui	a1,0x80006
800038f4:	80006537          	lui	a0,0x80006
800038f8:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800038fc:	06100693          	li	a3,97
80003900:	64840613          	addi	a2,s0,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003904:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003908:	865fe0ef          	jal	ra,8000216c <printk>
8000390c:	80006537          	lui	a0,0x80006
80003910:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80003914:	859fe0ef          	jal	ra,8000216c <printk>
80003918:	06100593          	li	a1,97
8000391c:	64840513          	addi	a0,s0,1608
80003920:	889fe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003924:	3004a4f3          	csrrs	s1,mstatus,s1
}
80003928:	01c12083          	lw	ra,28(sp)
8000392c:	01812403          	lw	s0,24(sp)
80003930:	01412483          	lw	s1,20(sp)
80003934:	01012903          	lw	s2,16(sp)
80003938:	00c12983          	lw	s3,12(sp)
8000393c:	02010113          	addi	sp,sp,32
80003940:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003944:	00f60663          	beq	a2,a5,80003950 <z_add_thread_to_ready_q+0x178>
80003948:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000394c:	f60792e3          	bnez	a5,800038b0 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80003950:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80003954:	02872783          	lw	a5,40(a4)
	node->next = list;
80003958:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
8000395c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003960:	02872423          	sw	s0,40(a4)
80003964:	f69ff06f          	j	800038cc <z_add_thread_to_ready_q+0xf4>

80003968 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80003968:	ff052783          	lw	a5,-16(a0)
{
8000396c:	fe010113          	addi	sp,sp,-32
80003970:	00812c23          	sw	s0,24(sp)
80003974:	01312623          	sw	s3,12(sp)
80003978:	00112e23          	sw	ra,28(sp)
8000397c:	00912a23          	sw	s1,20(sp)
80003980:	01212823          	sw	s2,16(sp)
80003984:	01412423          	sw	s4,8(sp)
80003988:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
8000398c:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003990:	0c078463          	beqz	a5,80003a58 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003994:	00800493          	li	s1,8
80003998:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000399c:	80007937          	lui	s2,0x80007
800039a0:	ce090513          	addi	a0,s2,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
800039a4:	0084f493          	andi	s1,s1,8
800039a8:	128010ef          	jal	ra,80004ad0 <z_spin_lock_valid>
800039ac:	02051e63          	bnez	a0,800039e8 <z_thread_timeout+0x80>
800039b0:	80006a37          	lui	s4,0x80006
800039b4:	800065b7          	lui	a1,0x80006
800039b8:	80006537          	lui	a0,0x80006
800039bc:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800039c0:	04e00693          	li	a3,78
800039c4:	648a0613          	addi	a2,s4,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800039c8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800039cc:	fa0fe0ef          	jal	ra,8000216c <printk>
800039d0:	80006537          	lui	a0,0x80006
800039d4:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
800039d8:	f94fe0ef          	jal	ra,8000216c <printk>
800039dc:	04e00593          	li	a1,78
800039e0:	648a0513          	addi	a0,s4,1608
800039e4:	fc4fe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800039e8:	ce090513          	addi	a0,s2,-800
800039ec:	13c010ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800039f0:	ff040513          	addi	a0,s0,-16
800039f4:	d2cff0ef          	jal	ra,80002f20 <pended_on.isra.15>
800039f8:	00098593          	mv	a1,s3
800039fc:	a09ff0ef          	jal	ra,80003404 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003a00:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a04:	ce090513          	addi	a0,s2,-800
80003a08:	ffd7f793          	andi	a5,a5,-3
80003a0c:	fef40aa3          	sb	a5,-11(s0)
80003a10:	0e8010ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80003a14:	02051e63          	bnez	a0,80003a50 <z_thread_timeout+0xe8>
80003a18:	80006937          	lui	s2,0x80006
80003a1c:	800065b7          	lui	a1,0x80006
80003a20:	80006537          	lui	a0,0x80006
80003a24:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80003a28:	06100693          	li	a3,97
80003a2c:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003a30:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003a34:	f38fe0ef          	jal	ra,8000216c <printk>
80003a38:	80006537          	lui	a0,0x80006
80003a3c:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80003a40:	f2cfe0ef          	jal	ra,8000216c <printk>
80003a44:	06100593          	li	a1,97
80003a48:	64890513          	addi	a0,s2,1608
80003a4c:	f5cfe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003a50:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003a54:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003a58:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003a5c:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003a60:	feb7f793          	andi	a5,a5,-21
80003a64:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003a68:	c64ff0ef          	jal	ra,80002ecc <z_is_thread_ready>
80003a6c:	02050463          	beqz	a0,80003a94 <z_thread_timeout+0x12c>
}
80003a70:	01812403          	lw	s0,24(sp)
80003a74:	01c12083          	lw	ra,28(sp)
80003a78:	01412483          	lw	s1,20(sp)
80003a7c:	01012903          	lw	s2,16(sp)
80003a80:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80003a84:	00098513          	mv	a0,s3
80003a88:	00c12983          	lw	s3,12(sp)
80003a8c:	02010113          	addi	sp,sp,32
80003a90:	d49ff06f          	j	800037d8 <z_add_thread_to_ready_q>
80003a94:	01c12083          	lw	ra,28(sp)
80003a98:	01812403          	lw	s0,24(sp)
80003a9c:	01412483          	lw	s1,20(sp)
80003aa0:	01012903          	lw	s2,16(sp)
80003aa4:	00c12983          	lw	s3,12(sp)
80003aa8:	00812a03          	lw	s4,8(sp)
80003aac:	02010113          	addi	sp,sp,32
80003ab0:	00008067          	ret

80003ab4 <z_move_thread_to_end_of_prio_q>:
{
80003ab4:	fe010113          	addi	sp,sp,-32
80003ab8:	00812c23          	sw	s0,24(sp)
80003abc:	01212823          	sw	s2,16(sp)
80003ac0:	00112e23          	sw	ra,28(sp)
80003ac4:	00912a23          	sw	s1,20(sp)
80003ac8:	01312623          	sw	s3,12(sp)
80003acc:	01412423          	sw	s4,8(sp)
80003ad0:	01512223          	sw	s5,4(sp)
80003ad4:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ad8:	00800913          	li	s2,8
80003adc:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003ae0:	800079b7          	lui	s3,0x80007
80003ae4:	ce098513          	addi	a0,s3,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003ae8:	00897913          	andi	s2,s2,8
80003aec:	7e5000ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80003af0:	02051e63          	bnez	a0,80003b2c <z_move_thread_to_end_of_prio_q+0x78>
80003af4:	800064b7          	lui	s1,0x80006
80003af8:	800065b7          	lui	a1,0x80006
80003afc:	80006537          	lui	a0,0x80006
80003b00:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80003b04:	04e00693          	li	a3,78
80003b08:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003b0c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003b10:	e5cfe0ef          	jal	ra,8000216c <printk>
80003b14:	80006537          	lui	a0,0x80006
80003b18:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80003b1c:	e50fe0ef          	jal	ra,8000216c <printk>
80003b20:	04e00593          	li	a1,78
80003b24:	64848513          	addi	a0,s1,1608
80003b28:	e80fe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b2c:	ce098513          	addi	a0,s3,-800
80003b30:	7f9000ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80003b34:	800074b7          	lui	s1,0x80007
80003b38:	00c48513          	addi	a0,s1,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80003b3c:	00040593          	mv	a1,s0
80003b40:	02450513          	addi	a0,a0,36
80003b44:	8c1ff0ef          	jal	ra,80003404 <z_priq_dumb_remove>
	return thread == _idle_thread;
80003b48:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003b4c:	c107a783          	lw	a5,-1008(a5) # 80006c10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c11>
80003b50:	80007a37          	lui	s4,0x80007
80003b54:	00c48493          	addi	s1,s1,12
80003b58:	030a0a13          	addi	s4,s4,48 # 80007030 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007031>
80003b5c:	02f41863          	bne	s0,a5,80003b8c <z_move_thread_to_end_of_prio_q+0xd8>
80003b60:	80007ab7          	lui	s5,0x80007
80003b64:	800075b7          	lui	a1,0x80007
80003b68:	80006537          	lui	a0,0x80006
80003b6c:	90c58593          	addi	a1,a1,-1780 # 8000690c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000690d>
80003b70:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003b74:	27600693          	li	a3,630
80003b78:	8c0a8613          	addi	a2,s5,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003b7c:	df0fe0ef          	jal	ra,8000216c <printk>
80003b80:	27600593          	li	a1,630
80003b84:	8c0a8513          	addi	a0,s5,-1856
80003b88:	e20fe0ef          	jal	ra,800021a8 <assert_post_action>
	return list->head == list;
80003b8c:	0244a783          	lw	a5,36(s1)
80003b90:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003b94:	0b478e63          	beq	a5,s4,80003c50 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003b98:	0a078c63          	beqz	a5,80003c50 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003b9c:	00e40683          	lb	a3,14(s0)
80003ba0:	00e78603          	lb	a2,14(a5)
80003ba4:	0ac6d063          	bge	a3,a2,80003c44 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80003ba8:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003bac:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003bb0:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003bb4:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003bb8:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003bbc:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003bc0:	0084a503          	lw	a0,8(s1)
80003bc4:	0407e793          	ori	a5,a5,64
80003bc8:	40850533          	sub	a0,a0,s0
80003bcc:	00153513          	seqz	a0,a0
80003bd0:	00f406a3          	sb	a5,13(s0)
80003bd4:	9bdff0ef          	jal	ra,80003590 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003bd8:	ce098513          	addi	a0,s3,-800
80003bdc:	71d000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80003be0:	02051e63          	bnez	a0,80003c1c <z_move_thread_to_end_of_prio_q+0x168>
80003be4:	80006437          	lui	s0,0x80006
80003be8:	800065b7          	lui	a1,0x80006
80003bec:	80006537          	lui	a0,0x80006
80003bf0:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80003bf4:	06100693          	li	a3,97
80003bf8:	64840613          	addi	a2,s0,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003bfc:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003c00:	d6cfe0ef          	jal	ra,8000216c <printk>
80003c04:	80006537          	lui	a0,0x80006
80003c08:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80003c0c:	d60fe0ef          	jal	ra,8000216c <printk>
80003c10:	06100593          	li	a1,97
80003c14:	64840513          	addi	a0,s0,1608
80003c18:	d90fe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c1c:	30092973          	csrrs	s2,mstatus,s2
}
80003c20:	01c12083          	lw	ra,28(sp)
80003c24:	01812403          	lw	s0,24(sp)
80003c28:	01412483          	lw	s1,20(sp)
80003c2c:	01012903          	lw	s2,16(sp)
80003c30:	00c12983          	lw	s3,12(sp)
80003c34:	00812a03          	lw	s4,8(sp)
80003c38:	00412a83          	lw	s5,4(sp)
80003c3c:	02010113          	addi	sp,sp,32
80003c40:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003c44:	00e78663          	beq	a5,a4,80003c50 <z_move_thread_to_end_of_prio_q+0x19c>
80003c48:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003c4c:	f4079ae3          	bnez	a5,80003ba0 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003c50:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003c54:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003c58:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003c5c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003c60:	0284a423          	sw	s0,40(s1)
80003c64:	f59ff06f          	j	80003bbc <z_move_thread_to_end_of_prio_q+0x108>

80003c68 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003c68:	800077b7          	lui	a5,0x80007
80003c6c:	ce87a783          	lw	a5,-792(a5) # 80006ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce9>
80003c70:	06078663          	beqz	a5,80003cdc <z_time_slice+0x74>
80003c74:	800077b7          	lui	a5,0x80007
80003c78:	00c78793          	addi	a5,a5,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80003c7c:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003c80:	07f00693          	li	a3,127
80003c84:	00e75603          	lhu	a2,14(a4)
80003c88:	04c6ea63          	bltu	a3,a2,80003cdc <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003c8c:	800076b7          	lui	a3,0x80007
80003c90:	00e70603          	lb	a2,14(a4)
80003c94:	ce46a683          	lw	a3,-796(a3) # 80006ce4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce5>
80003c98:	04d64263          	blt	a2,a3,80003cdc <z_time_slice+0x74>
	return thread == _idle_thread;
80003c9c:	800076b7          	lui	a3,0x80007
		&& !is_idle(t)
80003ca0:	c106a683          	lw	a3,-1008(a3) # 80006c10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c11>
80003ca4:	02d70c63          	beq	a4,a3,80003cdc <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80003ca8:	01872683          	lw	a3,24(a4)
80003cac:	02069863          	bnez	a3,80003cdc <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003cb0:	0107a683          	lw	a3,16(a5)
80003cb4:	02d54063          	blt	a0,a3,80003cd4 <z_time_slice+0x6c>
{
80003cb8:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003cbc:	00070513          	mv	a0,a4
{
80003cc0:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003cc4:	df1ff0ef          	jal	ra,80003ab4 <z_move_thread_to_end_of_prio_q>
}
80003cc8:	00c12083          	lw	ra,12(sp)
80003ccc:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003cd0:	a1cff06f          	j	80002eec <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003cd4:	40a686b3          	sub	a3,a3,a0
80003cd8:	00d7a823          	sw	a3,16(a5)
80003cdc:	00008067          	ret

80003ce0 <z_remove_thread_from_ready_q>:
{
80003ce0:	fe010113          	addi	sp,sp,-32
80003ce4:	00812c23          	sw	s0,24(sp)
80003ce8:	01312623          	sw	s3,12(sp)
80003cec:	00112e23          	sw	ra,28(sp)
80003cf0:	00912a23          	sw	s1,20(sp)
80003cf4:	01212823          	sw	s2,16(sp)
80003cf8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003cfc:	00800413          	li	s0,8
80003d00:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d04:	800074b7          	lui	s1,0x80007
80003d08:	ce048513          	addi	a0,s1,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003d0c:	00847413          	andi	s0,s0,8
80003d10:	5c1000ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80003d14:	02051e63          	bnez	a0,80003d50 <z_remove_thread_from_ready_q+0x70>
80003d18:	80006937          	lui	s2,0x80006
80003d1c:	800065b7          	lui	a1,0x80006
80003d20:	80006537          	lui	a0,0x80006
80003d24:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80003d28:	04e00693          	li	a3,78
80003d2c:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003d30:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003d34:	c38fe0ef          	jal	ra,8000216c <printk>
80003d38:	80006537          	lui	a0,0x80006
80003d3c:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80003d40:	c2cfe0ef          	jal	ra,8000216c <printk>
80003d44:	04e00593          	li	a1,78
80003d48:	64890513          	addi	a0,s2,1608
80003d4c:	c5cfe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d50:	ce048513          	addi	a0,s1,-800
80003d54:	5d5000ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003d58:	00d9c783          	lbu	a5,13(s3)
80003d5c:	80007937          	lui	s2,0x80007
80003d60:	00c90913          	addi	s2,s2,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80003d64:	0407f793          	andi	a5,a5,64
80003d68:	00078e63          	beqz	a5,80003d84 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003d6c:	00098593          	mv	a1,s3
80003d70:	02490513          	addi	a0,s2,36
80003d74:	e90ff0ef          	jal	ra,80003404 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80003d78:	00d9c783          	lbu	a5,13(s3)
80003d7c:	fbf7f793          	andi	a5,a5,-65
80003d80:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003d84:	00892503          	lw	a0,8(s2)
80003d88:	41350533          	sub	a0,a0,s3
80003d8c:	00153513          	seqz	a0,a0
80003d90:	801ff0ef          	jal	ra,80003590 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003d94:	ce048513          	addi	a0,s1,-800
80003d98:	561000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80003d9c:	02051e63          	bnez	a0,80003dd8 <z_remove_thread_from_ready_q+0xf8>
80003da0:	800064b7          	lui	s1,0x80006
80003da4:	800065b7          	lui	a1,0x80006
80003da8:	80006537          	lui	a0,0x80006
80003dac:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80003db0:	06100693          	li	a3,97
80003db4:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003db8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003dbc:	bb0fe0ef          	jal	ra,8000216c <printk>
80003dc0:	80006537          	lui	a0,0x80006
80003dc4:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80003dc8:	ba4fe0ef          	jal	ra,8000216c <printk>
80003dcc:	06100593          	li	a1,97
80003dd0:	64848513          	addi	a0,s1,1608
80003dd4:	bd4fe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003dd8:	30042473          	csrrs	s0,mstatus,s0
}
80003ddc:	01c12083          	lw	ra,28(sp)
80003de0:	01812403          	lw	s0,24(sp)
80003de4:	01412483          	lw	s1,20(sp)
80003de8:	01012903          	lw	s2,16(sp)
80003dec:	00c12983          	lw	s3,12(sp)
80003df0:	02010113          	addi	sp,sp,32
80003df4:	00008067          	ret

80003df8 <pend>:
{
80003df8:	fe010113          	addi	sp,sp,-32
80003dfc:	00812c23          	sw	s0,24(sp)
80003e00:	00912a23          	sw	s1,20(sp)
80003e04:	00050413          	mv	s0,a0
80003e08:	01212823          	sw	s2,16(sp)
80003e0c:	00112e23          	sw	ra,28(sp)
80003e10:	01312623          	sw	s3,12(sp)
80003e14:	00058493          	mv	s1,a1
80003e18:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003e1c:	ec5ff0ef          	jal	ra,80003ce0 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003e20:	00d44783          	lbu	a5,13(s0)
80003e24:	0027e793          	ori	a5,a5,2
80003e28:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003e2c:	06048663          	beqz	s1,80003e98 <pend+0xa0>
	return thread == _idle_thread;
80003e30:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003e34:	c107a783          	lw	a5,-1008(a5) # 80006c10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c11>
		thread->base.pended_on = wait_q;
80003e38:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003e3c:	02f41863          	bne	s0,a5,80003e6c <pend+0x74>
80003e40:	800079b7          	lui	s3,0x80007
80003e44:	800075b7          	lui	a1,0x80007
80003e48:	80006537          	lui	a0,0x80006
80003e4c:	90c58593          	addi	a1,a1,-1780 # 8000690c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000690d>
80003e50:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003e54:	27600693          	li	a3,630
80003e58:	8c098613          	addi	a2,s3,-1856 # 800068c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068c1>
80003e5c:	b10fe0ef          	jal	ra,8000216c <printk>
80003e60:	27600593          	li	a1,630
80003e64:	8c098513          	addi	a0,s3,-1856
80003e68:	b40fe0ef          	jal	ra,800021a8 <assert_post_action>
	return list->head == list;
80003e6c:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003e70:	06f48c63          	beq	s1,a5,80003ee8 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003e74:	06078a63          	beqz	a5,80003ee8 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80003e78:	00e40703          	lb	a4,14(s0)
80003e7c:	00e78683          	lb	a3,14(a5)
80003e80:	04d75c63          	bge	a4,a3,80003ed8 <pend+0xe0>
	node->prev = successor->prev;
80003e84:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003e88:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003e8c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003e90:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003e94:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003e98:	fff00793          	li	a5,-1
80003e9c:	06f90463          	beq	s2,a5,80003f04 <pend+0x10c>
80003ea0:	00a00593          	li	a1,10
80003ea4:	00990513          	addi	a0,s2,9
80003ea8:	a11fc0ef          	jal	ra,800008b8 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003eac:	00150613          	addi	a2,a0,1
80003eb0:	01840513          	addi	a0,s0,24
}
80003eb4:	01812403          	lw	s0,24(sp)
80003eb8:	01c12083          	lw	ra,28(sp)
80003ebc:	01412483          	lw	s1,20(sp)
80003ec0:	01012903          	lw	s2,16(sp)
80003ec4:	00c12983          	lw	s3,12(sp)
80003ec8:	800045b7          	lui	a1,0x80004
80003ecc:	96858593          	addi	a1,a1,-1688 # 80003968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003969>
80003ed0:	02010113          	addi	sp,sp,32
80003ed4:	1440106f          	j	80005018 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003ed8:	0044a683          	lw	a3,4(s1)
80003edc:	00d78663          	beq	a5,a3,80003ee8 <pend+0xf0>
80003ee0:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ee4:	f8079ce3          	bnez	a5,80003e7c <pend+0x84>
	node->prev = list->tail;
80003ee8:	0044a783          	lw	a5,4(s1)
	node->next = list;
80003eec:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80003ef0:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80003ef4:	0044a783          	lw	a5,4(s1)
80003ef8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003efc:	0084a223          	sw	s0,4(s1)
80003f00:	f99ff06f          	j	80003e98 <pend+0xa0>
}
80003f04:	01c12083          	lw	ra,28(sp)
80003f08:	01812403          	lw	s0,24(sp)
80003f0c:	01412483          	lw	s1,20(sp)
80003f10:	01012903          	lw	s2,16(sp)
80003f14:	00c12983          	lw	s3,12(sp)
80003f18:	02010113          	addi	sp,sp,32
80003f1c:	00008067          	ret

80003f20 <z_pend_curr_irqlock>:
{
80003f20:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003f24:	800077b7          	lui	a5,0x80007
{
80003f28:	00812423          	sw	s0,8(sp)
80003f2c:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003f30:	0147a503          	lw	a0,20(a5) # 80007014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007015>
{
80003f34:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003f38:	ec1ff0ef          	jal	ra,80003df8 <pend>
80003f3c:	00040513          	mv	a0,s0
}
80003f40:	00812403          	lw	s0,8(sp)
80003f44:	00c12083          	lw	ra,12(sp)
80003f48:	01010113          	addi	sp,sp,16
80003f4c:	aecfc06f          	j	80000238 <__swap>

80003f50 <z_pend_curr>:
{
80003f50:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003f54:	800077b7          	lui	a5,0x80007
{
80003f58:	00812423          	sw	s0,8(sp)
80003f5c:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003f60:	0147a503          	lw	a0,20(a5) # 80007014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007015>
{
80003f64:	00912223          	sw	s1,4(sp)
80003f68:	00058493          	mv	s1,a1
80003f6c:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80003f70:	00068613          	mv	a2,a3
{
80003f74:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003f78:	e81ff0ef          	jal	ra,80003df8 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f7c:	00040513          	mv	a0,s0
80003f80:	379000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80003f84:	02051e63          	bnez	a0,80003fc0 <z_pend_curr+0x70>
80003f88:	80006437          	lui	s0,0x80006
80003f8c:	800065b7          	lui	a1,0x80006
80003f90:	80006537          	lui	a0,0x80006
80003f94:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80003f98:	07800693          	li	a3,120
80003f9c:	64840613          	addi	a2,s0,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80003fa0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80003fa4:	9c8fe0ef          	jal	ra,8000216c <printk>
80003fa8:	80006537          	lui	a0,0x80006
80003fac:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80003fb0:	9bcfe0ef          	jal	ra,8000216c <printk>
80003fb4:	07800593          	li	a1,120
80003fb8:	64840513          	addi	a0,s0,1608
80003fbc:	9ecfe0ef          	jal	ra,800021a8 <assert_post_action>
}
80003fc0:	00812403          	lw	s0,8(sp)
80003fc4:	00c12083          	lw	ra,12(sp)
80003fc8:	00048513          	mv	a0,s1
80003fcc:	00412483          	lw	s1,4(sp)
80003fd0:	01010113          	addi	sp,sp,16
80003fd4:	a64fc06f          	j	80000238 <__swap>

80003fd8 <z_unpend_first_thread>:
{
80003fd8:	fe010113          	addi	sp,sp,-32
80003fdc:	01212823          	sw	s2,16(sp)
80003fe0:	01312623          	sw	s3,12(sp)
80003fe4:	00112e23          	sw	ra,28(sp)
80003fe8:	00812c23          	sw	s0,24(sp)
80003fec:	00912a23          	sw	s1,20(sp)
80003ff0:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ff4:	00800913          	li	s2,8
80003ff8:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003ffc:	800074b7          	lui	s1,0x80007
80004000:	ce048513          	addi	a0,s1,-800 # 80006ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ce1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004004:	00897913          	andi	s2,s2,8
80004008:	2c9000ef          	jal	ra,80004ad0 <z_spin_lock_valid>
8000400c:	02051e63          	bnez	a0,80004048 <z_unpend_first_thread+0x70>
80004010:	80006437          	lui	s0,0x80006
80004014:	800065b7          	lui	a1,0x80006
80004018:	80006537          	lui	a0,0x80006
8000401c:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80004020:	04e00693          	li	a3,78
80004024:	64840613          	addi	a2,s0,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004028:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
8000402c:	940fe0ef          	jal	ra,8000216c <printk>
80004030:	80006537          	lui	a0,0x80006
80004034:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80004038:	934fe0ef          	jal	ra,8000216c <printk>
8000403c:	04e00593          	li	a1,78
80004040:	64840513          	addi	a0,s0,1608
80004044:	964fe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004048:	ce048513          	addi	a0,s1,-800
8000404c:	2dd000ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80004050:	00098513          	mv	a0,s3
80004054:	d28ff0ef          	jal	ra,8000357c <z_priq_dumb_best>
80004058:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000405c:	ce048513          	addi	a0,s1,-800
80004060:	299000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80004064:	02051e63          	bnez	a0,800040a0 <z_unpend_first_thread+0xc8>
80004068:	800069b7          	lui	s3,0x80006
8000406c:	800065b7          	lui	a1,0x80006
80004070:	80006537          	lui	a0,0x80006
80004074:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80004078:	06100693          	li	a3,97
8000407c:	64898613          	addi	a2,s3,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004080:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004084:	8e8fe0ef          	jal	ra,8000216c <printk>
80004088:	80006537          	lui	a0,0x80006
8000408c:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80004090:	8dcfe0ef          	jal	ra,8000216c <printk>
80004094:	06100593          	li	a1,97
80004098:	64898513          	addi	a0,s3,1608
8000409c:	90cfe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800040a0:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
800040a4:	0c040663          	beqz	s0,80004170 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800040a8:	00800913          	li	s2,8
800040ac:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800040b0:	ce048513          	addi	a0,s1,-800
	key = (mstatus & SOC_MSTATUS_IEN);
800040b4:	00897913          	andi	s2,s2,8
800040b8:	219000ef          	jal	ra,80004ad0 <z_spin_lock_valid>
800040bc:	02051e63          	bnez	a0,800040f8 <z_unpend_first_thread+0x120>
800040c0:	800069b7          	lui	s3,0x80006
800040c4:	800065b7          	lui	a1,0x80006
800040c8:	80006537          	lui	a0,0x80006
800040cc:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800040d0:	04e00693          	li	a3,78
800040d4:	64898613          	addi	a2,s3,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800040d8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800040dc:	890fe0ef          	jal	ra,8000216c <printk>
800040e0:	80006537          	lui	a0,0x80006
800040e4:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
800040e8:	884fe0ef          	jal	ra,8000216c <printk>
800040ec:	04e00593          	li	a1,78
800040f0:	64898513          	addi	a0,s3,1608
800040f4:	8b4fe0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800040f8:	ce048513          	addi	a0,s1,-800
800040fc:	22d000ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004100:	00840513          	addi	a0,s0,8
80004104:	e1dfe0ef          	jal	ra,80002f20 <pended_on.isra.15>
80004108:	00040593          	mv	a1,s0
8000410c:	af8ff0ef          	jal	ra,80003404 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80004110:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004114:	ce048513          	addi	a0,s1,-800
80004118:	ffd7f793          	andi	a5,a5,-3
8000411c:	00f406a3          	sb	a5,13(s0)
80004120:	1d9000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80004124:	02051e63          	bnez	a0,80004160 <z_unpend_first_thread+0x188>
80004128:	800064b7          	lui	s1,0x80006
8000412c:	800065b7          	lui	a1,0x80006
80004130:	80006537          	lui	a0,0x80006
80004134:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80004138:	06100693          	li	a3,97
8000413c:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004140:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004144:	828fe0ef          	jal	ra,8000216c <printk>
80004148:	80006537          	lui	a0,0x80006
8000414c:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80004150:	81cfe0ef          	jal	ra,8000216c <printk>
80004154:	06100593          	li	a1,97
80004158:	64848513          	addi	a0,s1,1608
8000415c:	84cfe0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004160:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80004164:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80004168:	01840513          	addi	a0,s0,24
8000416c:	0d8010ef          	jal	ra,80005244 <z_abort_timeout>
}
80004170:	00040513          	mv	a0,s0
80004174:	01c12083          	lw	ra,28(sp)
80004178:	01812403          	lw	s0,24(sp)
8000417c:	01412483          	lw	s1,20(sp)
80004180:	01012903          	lw	s2,16(sp)
80004184:	00c12983          	lw	s3,12(sp)
80004188:	02010113          	addi	sp,sp,32
8000418c:	00008067          	ret

80004190 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80004190:	ff010113          	addi	sp,sp,-16
80004194:	00912223          	sw	s1,4(sp)
80004198:	01212023          	sw	s2,0(sp)
8000419c:	00112623          	sw	ra,12(sp)
800041a0:	00812423          	sw	s0,8(sp)
800041a4:	00050913          	mv	s2,a0
	int need_sched = 0;
800041a8:	00000493          	li	s1,0
	return list->head == list;
800041ac:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800041b0:	00890463          	beq	s2,s0,800041b8 <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
800041b4:	02041063          	bnez	s0,800041d4 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
800041b8:	00c12083          	lw	ra,12(sp)
800041bc:	00812403          	lw	s0,8(sp)
800041c0:	00048513          	mv	a0,s1
800041c4:	00012903          	lw	s2,0(sp)
800041c8:	00412483          	lw	s1,4(sp)
800041cc:	01010113          	addi	sp,sp,16
800041d0:	00008067          	ret
		z_unpend_thread(th);
800041d4:	00040513          	mv	a0,s0
800041d8:	aa4ff0ef          	jal	ra,8000347c <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
800041dc:	00040513          	mv	a0,s0
800041e0:	cedfe0ef          	jal	ra,80002ecc <z_is_thread_ready>
		need_sched = 1;
800041e4:	00100493          	li	s1,1
800041e8:	fc0502e3          	beqz	a0,800041ac <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
800041ec:	00040513          	mv	a0,s0
800041f0:	de8ff0ef          	jal	ra,800037d8 <z_add_thread_to_ready_q>
800041f4:	fb9ff06f          	j	800041ac <z_unpend_all+0x1c>

800041f8 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
800041f8:	800077b7          	lui	a5,0x80007
800041fc:	00c78793          	addi	a5,a5,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80004200:	02478713          	addi	a4,a5,36
80004204:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80004208:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
8000420c:	00000593          	li	a1,0
80004210:	00000513          	li	a0,0
80004214:	d6dfe06f          	j	80002f80 <k_sched_time_slice_set>

80004218 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80004218:	800077b7          	lui	a5,0x80007
8000421c:	0147a503          	lw	a0,20(a5) # 80007014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007015>
80004220:	00008067          	ret

80004224 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80004224:	fe010113          	addi	sp,sp,-32
80004228:	00812c23          	sw	s0,24(sp)
8000422c:	00912a23          	sw	s1,20(sp)
80004230:	01212823          	sw	s2,16(sp)
80004234:	00112e23          	sw	ra,28(sp)
80004238:	01312623          	sw	s3,12(sp)
8000423c:	00050413          	mv	s0,a0
80004240:	00058913          	mv	s2,a1
80004244:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80004248:	02061e63          	bnez	a2,80004284 <z_impl_k_sem_init+0x60>
8000424c:	800079b7          	lui	s3,0x80007
80004250:	800075b7          	lui	a1,0x80007
80004254:	80006537          	lui	a0,0x80006
80004258:	93058593          	addi	a1,a1,-1744 # 80006930 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006931>
8000425c:	04600693          	li	a3,70
80004260:	92098613          	addi	a2,s3,-1760 # 80006920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006921>
80004264:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004268:	f05fd0ef          	jal	ra,8000216c <printk>
8000426c:	80007537          	lui	a0,0x80007
80004270:	93c50513          	addi	a0,a0,-1732 # 8000693c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000693d>
80004274:	ef9fd0ef          	jal	ra,8000216c <printk>
80004278:	04600593          	li	a1,70
8000427c:	92098513          	addi	a0,s3,-1760
80004280:	f29fd0ef          	jal	ra,800021a8 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80004284:	0324fe63          	bgeu	s1,s2,800042c0 <z_impl_k_sem_init+0x9c>
80004288:	800079b7          	lui	s3,0x80007
8000428c:	800075b7          	lui	a1,0x80007
80004290:	80006537          	lui	a0,0x80006
80004294:	95458593          	addi	a1,a1,-1708 # 80006954 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006955>
80004298:	04700693          	li	a3,71
8000429c:	92098613          	addi	a2,s3,-1760 # 80006920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006921>
800042a0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800042a4:	ec9fd0ef          	jal	ra,8000216c <printk>
800042a8:	80007537          	lui	a0,0x80007
800042ac:	96c50513          	addi	a0,a0,-1684 # 8000696c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000696d>
800042b0:	ebdfd0ef          	jal	ra,8000216c <printk>
800042b4:	04700593          	li	a1,71
800042b8:	92098513          	addi	a0,s3,-1760
800042bc:	eedfd0ef          	jal	ra,800021a8 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
800042c0:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
800042c4:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
800042c8:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
800042cc:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
800042d0:	01c12083          	lw	ra,28(sp)
800042d4:	01812403          	lw	s0,24(sp)
800042d8:	01412483          	lw	s1,20(sp)
800042dc:	01012903          	lw	s2,16(sp)
800042e0:	00c12983          	lw	s3,12(sp)
800042e4:	02010113          	addi	sp,sp,32
800042e8:	00008067          	ret

800042ec <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800042ec:	fe010113          	addi	sp,sp,-32
800042f0:	00912a23          	sw	s1,20(sp)
800042f4:	01312623          	sw	s3,12(sp)
800042f8:	00112e23          	sw	ra,28(sp)
800042fc:	00812c23          	sw	s0,24(sp)
80004300:	01212823          	sw	s2,16(sp)
80004304:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004308:	00800493          	li	s1,8
8000430c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004310:	80007437          	lui	s0,0x80007
80004314:	cec40513          	addi	a0,s0,-788 # 80006cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ced>
	key = (mstatus & SOC_MSTATUS_IEN);
80004318:	0084f493          	andi	s1,s1,8
8000431c:	7b4000ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80004320:	02051e63          	bnez	a0,8000435c <z_impl_k_sem_give+0x70>
80004324:	80006937          	lui	s2,0x80006
80004328:	800065b7          	lui	a1,0x80006
8000432c:	80006537          	lui	a0,0x80006
80004330:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80004334:	04e00693          	li	a3,78
80004338:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
8000433c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004340:	e2dfd0ef          	jal	ra,8000216c <printk>
80004344:	80006537          	lui	a0,0x80006
80004348:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
8000434c:	e21fd0ef          	jal	ra,8000216c <printk>
80004350:	04e00593          	li	a1,78
80004354:	64890513          	addi	a0,s2,1608
80004358:	e51fd0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000435c:	cec40513          	addi	a0,s0,-788
80004360:	7c8000ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80004364:	00098513          	mv	a0,s3
80004368:	c71ff0ef          	jal	ra,80003fd8 <z_unpend_first_thread>
8000436c:	00050913          	mv	s2,a0
	if (thread != NULL) {
80004370:	04050263          	beqz	a0,800043b4 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004374:	00d54783          	lbu	a5,13(a0)
80004378:	01f7f793          	andi	a5,a5,31
8000437c:	00079863          	bnez	a5,8000438c <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80004380:	01852783          	lw	a5,24(a0)
80004384:	00079463          	bnez	a5,8000438c <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80004388:	c50ff0ef          	jal	ra,800037d8 <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
8000438c:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80004390:	cec40513          	addi	a0,s0,-788
}
80004394:	01812403          	lw	s0,24(sp)
80004398:	01c12083          	lw	ra,28(sp)
8000439c:	01012903          	lw	s2,16(sp)
800043a0:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
800043a4:	00048593          	mv	a1,s1
}
800043a8:	01412483          	lw	s1,20(sp)
800043ac:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
800043b0:	dddfe06f          	j	8000318c <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
800043b4:	0089a703          	lw	a4,8(s3)
800043b8:	00c9a783          	lw	a5,12(s3)
800043bc:	40e787b3          	sub	a5,a5,a4
800043c0:	00f037b3          	snez	a5,a5
800043c4:	00e787b3          	add	a5,a5,a4
800043c8:	00f9a423          	sw	a5,8(s3)
800043cc:	fc5ff06f          	j	80004390 <z_impl_k_sem_give+0xa4>

800043d0 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800043d0:	800077b7          	lui	a5,0x80007
800043d4:	00c7a783          	lw	a5,12(a5) # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
{
800043d8:	fe010113          	addi	sp,sp,-32
800043dc:	01212823          	sw	s2,16(sp)
800043e0:	01312623          	sw	s3,12(sp)
800043e4:	00112e23          	sw	ra,28(sp)
800043e8:	00812c23          	sw	s0,24(sp)
800043ec:	00912a23          	sw	s1,20(sp)
800043f0:	01412423          	sw	s4,8(sp)
800043f4:	00050913          	mv	s2,a0
800043f8:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800043fc:	04078063          	beqz	a5,8000443c <z_impl_k_sem_take+0x6c>
80004400:	02058e63          	beqz	a1,8000443c <z_impl_k_sem_take+0x6c>
80004404:	80007437          	lui	s0,0x80007
80004408:	800075b7          	lui	a1,0x80007
8000440c:	80006537          	lui	a0,0x80006
80004410:	99458593          	addi	a1,a1,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
80004414:	08c00693          	li	a3,140
80004418:	92040613          	addi	a2,s0,-1760 # 80006920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006921>
8000441c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004420:	d4dfd0ef          	jal	ra,8000216c <printk>
80004424:	80006537          	lui	a0,0x80006
80004428:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
8000442c:	d41fd0ef          	jal	ra,8000216c <printk>
80004430:	08c00593          	li	a1,140
80004434:	92040513          	addi	a0,s0,-1760
80004438:	d71fd0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000443c:	00800413          	li	s0,8
80004440:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004444:	800074b7          	lui	s1,0x80007
80004448:	cec48513          	addi	a0,s1,-788 # 80006cec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ced>
	key = (mstatus & SOC_MSTATUS_IEN);
8000444c:	00847413          	andi	s0,s0,8
80004450:	680000ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80004454:	02051e63          	bnez	a0,80004490 <z_impl_k_sem_take+0xc0>
80004458:	80006a37          	lui	s4,0x80006
8000445c:	800065b7          	lui	a1,0x80006
80004460:	80006537          	lui	a0,0x80006
80004464:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80004468:	04e00693          	li	a3,78
8000446c:	648a0613          	addi	a2,s4,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004470:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004474:	cf9fd0ef          	jal	ra,8000216c <printk>
80004478:	80006537          	lui	a0,0x80006
8000447c:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80004480:	cedfd0ef          	jal	ra,8000216c <printk>
80004484:	04e00593          	li	a1,78
80004488:	648a0513          	addi	a0,s4,1608
8000448c:	d1dfd0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004490:	cec48513          	addi	a0,s1,-788
80004494:	694000ef          	jal	ra,80004b28 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80004498:	00892783          	lw	a5,8(s2)
8000449c:	06078c63          	beqz	a5,80004514 <z_impl_k_sem_take+0x144>
		sem->count--;
800044a0:	fff78793          	addi	a5,a5,-1
800044a4:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800044a8:	cec48513          	addi	a0,s1,-788
800044ac:	64c000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800044b0:	02051e63          	bnez	a0,800044ec <z_impl_k_sem_take+0x11c>
800044b4:	800064b7          	lui	s1,0x80006
800044b8:	800065b7          	lui	a1,0x80006
800044bc:	80006537          	lui	a0,0x80006
800044c0:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800044c4:	06100693          	li	a3,97
800044c8:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800044cc:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800044d0:	c9dfd0ef          	jal	ra,8000216c <printk>
800044d4:	80006537          	lui	a0,0x80006
800044d8:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800044dc:	c91fd0ef          	jal	ra,8000216c <printk>
800044e0:	06100593          	li	a1,97
800044e4:	64848513          	addi	a0,s1,1608
800044e8:	cc1fd0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800044ec:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
800044f0:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800044f4:	01c12083          	lw	ra,28(sp)
800044f8:	01812403          	lw	s0,24(sp)
800044fc:	01412483          	lw	s1,20(sp)
80004500:	01012903          	lw	s2,16(sp)
80004504:	00c12983          	lw	s3,12(sp)
80004508:	00812a03          	lw	s4,8(sp)
8000450c:	02010113          	addi	sp,sp,32
80004510:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80004514:	04099a63          	bnez	s3,80004568 <z_impl_k_sem_take+0x198>
80004518:	cec48513          	addi	a0,s1,-788
8000451c:	5dc000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80004520:	02051e63          	bnez	a0,8000455c <z_impl_k_sem_take+0x18c>
80004524:	800064b7          	lui	s1,0x80006
80004528:	800065b7          	lui	a1,0x80006
8000452c:	80006537          	lui	a0,0x80006
80004530:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80004534:	06100693          	li	a3,97
80004538:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
8000453c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004540:	c2dfd0ef          	jal	ra,8000216c <printk>
80004544:	80006537          	lui	a0,0x80006
80004548:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
8000454c:	c21fd0ef          	jal	ra,8000216c <printk>
80004550:	06100593          	li	a1,97
80004554:	64848513          	addi	a0,s1,1608
80004558:	c51fd0ef          	jal	ra,800021a8 <assert_post_action>
8000455c:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80004560:	ff000513          	li	a0,-16
80004564:	f91ff06f          	j	800044f4 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004568:	00040593          	mv	a1,s0
}
8000456c:	01812403          	lw	s0,24(sp)
80004570:	01c12083          	lw	ra,28(sp)
80004574:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004578:	00098693          	mv	a3,s3
8000457c:	00090613          	mv	a2,s2
}
80004580:	00c12983          	lw	s3,12(sp)
80004584:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004588:	cec48513          	addi	a0,s1,-788
}
8000458c:	01412483          	lw	s1,20(sp)
80004590:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004594:	9bdff06f          	j	80003f50 <z_pend_curr>

80004598 <k_stack_init>:
		  u32_t num_entries)
{
	z_waitq_init(&stack->wait_q);
	stack->lock = (struct k_spinlock) {};
	stack->next = stack->base = buffer;
	stack->top = stack->base + num_entries;
80004598:	00261613          	slli	a2,a2,0x2
	stack->next = stack->base = buffer;
8000459c:	00b52623          	sw	a1,12(a0)
800045a0:	00b52823          	sw	a1,16(a0)
	stack->top = stack->base + num_entries;
800045a4:	00c585b3          	add	a1,a1,a2
	list->head = (sys_dnode_t *)list;
800045a8:	00a52023          	sw	a0,0(a0)
	list->tail = (sys_dnode_t *)list;
800045ac:	00a52223          	sw	a0,4(a0)
	stack->lock = (struct k_spinlock) {};
800045b0:	00052423          	sw	zero,8(a0)
	stack->top = stack->base + num_entries;
800045b4:	00b52a23          	sw	a1,20(a0)

	SYS_TRACING_OBJ_INIT(k_stack, stack);
	z_object_init(stack);
}
800045b8:	00008067          	ret

800045bc <z_impl_k_stack_alloc_init>:

s32_t z_impl_k_stack_alloc_init(struct k_stack *stack, u32_t num_entries)
{
800045bc:	fe010113          	addi	sp,sp,-32
800045c0:	00812c23          	sw	s0,24(sp)
800045c4:	00050413          	mv	s0,a0
	void *buffer;
	s32_t ret;

	buffer = z_thread_malloc(num_entries);
800045c8:	00058513          	mv	a0,a1
{
800045cc:	00112e23          	sw	ra,28(sp)
	buffer = z_thread_malloc(num_entries);
800045d0:	00b12623          	sw	a1,12(sp)
800045d4:	684010ef          	jal	ra,80005c58 <z_thread_malloc>
	if (buffer != NULL) {
800045d8:	02050863          	beqz	a0,80004608 <z_impl_k_stack_alloc_init+0x4c>
		k_stack_init(stack, buffer, num_entries);
800045dc:	00c12603          	lw	a2,12(sp)
800045e0:	00050593          	mv	a1,a0
800045e4:	00040513          	mv	a0,s0
800045e8:	fb1ff0ef          	jal	ra,80004598 <k_stack_init>
		stack->flags = K_STACK_FLAG_ALLOC;
800045ec:	00100793          	li	a5,1
800045f0:	00f40c23          	sb	a5,24(s0)
		ret = (s32_t)0;
800045f4:	00000513          	li	a0,0
	} else {
		ret = -ENOMEM;
	}

	return ret;
}
800045f8:	01c12083          	lw	ra,28(sp)
800045fc:	01812403          	lw	s0,24(sp)
80004600:	02010113          	addi	sp,sp,32
80004604:	00008067          	ret
		ret = -ENOMEM;
80004608:	ff400513          	li	a0,-12
	return ret;
8000460c:	fedff06f          	j	800045f8 <z_impl_k_stack_alloc_init+0x3c>

80004610 <k_stack_cleanup>:
	return list->head == list;
80004610:	00052783          	lw	a5,0(a0)
	return z_impl_k_stack_alloc_init((struct k_stack *)stack, num_entries);
}
#endif

void k_stack_cleanup(struct k_stack *stack)
{
80004614:	ff010113          	addi	sp,sp,-16
80004618:	00812423          	sw	s0,8(sp)
8000461c:	00112623          	sw	ra,12(sp)
80004620:	00912223          	sw	s1,4(sp)
80004624:	00050413          	mv	s0,a0
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004628:	02f50a63          	beq	a0,a5,8000465c <k_stack_cleanup+0x4c>
	__ASSERT_NO_MSG(z_waitq_head(&stack->wait_q) == NULL);
8000462c:	02078863          	beqz	a5,8000465c <k_stack_cleanup+0x4c>
80004630:	800074b7          	lui	s1,0x80007
80004634:	800075b7          	lui	a1,0x80007
80004638:	80006537          	lui	a0,0x80006
8000463c:	9dc58593          	addi	a1,a1,-1572 # 800069dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069dd>
80004640:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004644:	05a00693          	li	a3,90
80004648:	9c848613          	addi	a2,s1,-1592 # 800069c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069c9>
8000464c:	b21fd0ef          	jal	ra,8000216c <printk>
80004650:	05a00593          	li	a1,90
80004654:	9c848513          	addi	a0,s1,-1592
80004658:	b51fd0ef          	jal	ra,800021a8 <assert_post_action>

	if ((stack->flags & K_STACK_FLAG_ALLOC) != (u8_t)0) {
8000465c:	01844783          	lbu	a5,24(s0)
80004660:	0017f793          	andi	a5,a5,1
80004664:	00078e63          	beqz	a5,80004680 <k_stack_cleanup+0x70>
		k_free(stack->base);
80004668:	00c42503          	lw	a0,12(s0)
8000466c:	5dc010ef          	jal	ra,80005c48 <k_free>
		stack->base = NULL;
		stack->flags &= ~K_STACK_FLAG_ALLOC;
80004670:	01844783          	lbu	a5,24(s0)
		stack->base = NULL;
80004674:	00042623          	sw	zero,12(s0)
		stack->flags &= ~K_STACK_FLAG_ALLOC;
80004678:	ffe7f793          	andi	a5,a5,-2
8000467c:	00f40c23          	sb	a5,24(s0)
	}
}
80004680:	00c12083          	lw	ra,12(sp)
80004684:	00812403          	lw	s0,8(sp)
80004688:	00412483          	lw	s1,4(sp)
8000468c:	01010113          	addi	sp,sp,16
80004690:	00008067          	ret

80004694 <z_impl_k_stack_push>:
void z_impl_k_stack_push(struct k_stack *stack, u32_t data)
{
	struct k_thread *first_pending_thread;
	k_spinlock_key_t key;

	__ASSERT(stack->next != stack->top, "stack is full");
80004694:	01052703          	lw	a4,16(a0)
80004698:	01452783          	lw	a5,20(a0)
{
8000469c:	fe010113          	addi	sp,sp,-32
800046a0:	00912a23          	sw	s1,20(sp)
800046a4:	01412423          	sw	s4,8(sp)
800046a8:	00112e23          	sw	ra,28(sp)
800046ac:	00812c23          	sw	s0,24(sp)
800046b0:	01212823          	sw	s2,16(sp)
800046b4:	01312623          	sw	s3,12(sp)
800046b8:	00050493          	mv	s1,a0
800046bc:	00058a13          	mv	s4,a1
	__ASSERT(stack->next != stack->top, "stack is full");
800046c0:	02f71e63          	bne	a4,a5,800046fc <z_impl_k_stack_push+0x68>
800046c4:	80007437          	lui	s0,0x80007
800046c8:	800075b7          	lui	a1,0x80007
800046cc:	80006537          	lui	a0,0x80006
800046d0:	a0858593          	addi	a1,a1,-1528 # 80006a08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a09>
800046d4:	06800693          	li	a3,104
800046d8:	9c840613          	addi	a2,s0,-1592 # 800069c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069c9>
800046dc:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800046e0:	a8dfd0ef          	jal	ra,8000216c <printk>
800046e4:	80007537          	lui	a0,0x80007
800046e8:	a2450513          	addi	a0,a0,-1500 # 80006a24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a25>
800046ec:	a81fd0ef          	jal	ra,8000216c <printk>
800046f0:	06800593          	li	a1,104
800046f4:	9c840513          	addi	a0,s0,-1592
800046f8:	ab1fd0ef          	jal	ra,800021a8 <assert_post_action>

	key = k_spin_lock(&stack->lock);
800046fc:	00848993          	addi	s3,s1,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004700:	00800413          	li	s0,8
80004704:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004708:	00098513          	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
8000470c:	00847413          	andi	s0,s0,8
80004710:	3c0000ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80004714:	02051e63          	bnez	a0,80004750 <z_impl_k_stack_push+0xbc>
80004718:	80006937          	lui	s2,0x80006
8000471c:	800065b7          	lui	a1,0x80006
80004720:	80006537          	lui	a0,0x80006
80004724:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80004728:	04e00693          	li	a3,78
8000472c:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004730:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004734:	a39fd0ef          	jal	ra,8000216c <printk>
80004738:	80006537          	lui	a0,0x80006
8000473c:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80004740:	a2dfd0ef          	jal	ra,8000216c <printk>
80004744:	04e00593          	li	a1,78
80004748:	64890513          	addi	a0,s2,1608
8000474c:	a5dfd0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004750:	00098513          	mv	a0,s3
80004754:	3d4000ef          	jal	ra,80004b28 <z_spin_lock_set_owner>

	first_pending_thread = z_unpend_first_thread(&stack->wait_q);
80004758:	00048513          	mv	a0,s1
8000475c:	87dff0ef          	jal	ra,80003fd8 <z_unpend_first_thread>
80004760:	00050913          	mv	s2,a0

	if (first_pending_thread != NULL) {
80004764:	04050663          	beqz	a0,800047b0 <z_impl_k_stack_push+0x11c>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004768:	00d54783          	lbu	a5,13(a0)
8000476c:	01f7f793          	andi	a5,a5,31
80004770:	00079863          	bnez	a5,80004780 <z_impl_k_stack_push+0xec>
	if (z_is_thread_ready(thread)) {
80004774:	01852783          	lw	a5,24(a0)
80004778:	00079463          	bnez	a5,80004780 <z_impl_k_stack_push+0xec>
		z_add_thread_to_ready_q(thread);
8000477c:	85cff0ef          	jal	ra,800037d8 <z_add_thread_to_ready_q>
		z_ready_thread(first_pending_thread);

		z_set_thread_return_value_with_data(first_pending_thread,
						   0, (void *)data);
		z_reschedule(&stack->lock, key);
80004780:	00040593          	mv	a1,s0
		*(stack->next) = data;
		stack->next++;
		k_spin_unlock(&stack->lock, key);
	}

}
80004784:	01812403          	lw	s0,24(sp)
	thread->base.swap_data = data;
80004788:	01492a23          	sw	s4,20(s2)
8000478c:	06092623          	sw	zero,108(s2)
80004790:	01c12083          	lw	ra,28(sp)
80004794:	01412483          	lw	s1,20(sp)
80004798:	01012903          	lw	s2,16(sp)
8000479c:	00812a03          	lw	s4,8(sp)
		z_reschedule(&stack->lock, key);
800047a0:	00098513          	mv	a0,s3
}
800047a4:	00c12983          	lw	s3,12(sp)
800047a8:	02010113          	addi	sp,sp,32
		z_reschedule(&stack->lock, key);
800047ac:	9e1fe06f          	j	8000318c <z_reschedule>
		*(stack->next) = data;
800047b0:	0104a783          	lw	a5,16(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800047b4:	00098513          	mv	a0,s3
800047b8:	0147a023          	sw	s4,0(a5)
		stack->next++;
800047bc:	00478793          	addi	a5,a5,4
800047c0:	00f4a823          	sw	a5,16(s1)
800047c4:	334000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800047c8:	02051e63          	bnez	a0,80004804 <z_impl_k_stack_push+0x170>
800047cc:	800064b7          	lui	s1,0x80006
800047d0:	800065b7          	lui	a1,0x80006
800047d4:	80006537          	lui	a0,0x80006
800047d8:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800047dc:	06100693          	li	a3,97
800047e0:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800047e4:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800047e8:	985fd0ef          	jal	ra,8000216c <printk>
800047ec:	80006537          	lui	a0,0x80006
800047f0:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800047f4:	979fd0ef          	jal	ra,8000216c <printk>
800047f8:	06100593          	li	a1,97
800047fc:	64848513          	addi	a0,s1,1608
80004800:	9a9fd0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004804:	30042473          	csrrs	s0,mstatus,s0
}
80004808:	01c12083          	lw	ra,28(sp)
8000480c:	01812403          	lw	s0,24(sp)
80004810:	01412483          	lw	s1,20(sp)
80004814:	01012903          	lw	s2,16(sp)
80004818:	00c12983          	lw	s3,12(sp)
8000481c:	00812a03          	lw	s4,8(sp)
80004820:	02010113          	addi	sp,sp,32
80004824:	00008067          	ret

80004828 <z_impl_k_stack_pop>:
	return 0;
}
#endif

int z_impl_k_stack_pop(struct k_stack *stack, u32_t *data, s32_t timeout)
{
80004828:	fe010113          	addi	sp,sp,-32
8000482c:	00812c23          	sw	s0,24(sp)
80004830:	00912a23          	sw	s1,20(sp)
80004834:	01212823          	sw	s2,16(sp)
80004838:	01312623          	sw	s3,12(sp)
8000483c:	01412423          	sw	s4,8(sp)
80004840:	00112e23          	sw	ra,28(sp)
80004844:	01512223          	sw	s5,4(sp)
80004848:	00050913          	mv	s2,a0
8000484c:	00058993          	mv	s3,a1
80004850:	00060a13          	mv	s4,a2
	k_spinlock_key_t key;
	int result;

	key = k_spin_lock(&stack->lock);
80004854:	00850493          	addi	s1,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004858:	00800413          	li	s0,8
8000485c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004860:	00048513          	mv	a0,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80004864:	00847413          	andi	s0,s0,8
80004868:	268000ef          	jal	ra,80004ad0 <z_spin_lock_valid>
8000486c:	02051e63          	bnez	a0,800048a8 <z_impl_k_stack_pop+0x80>
80004870:	80006ab7          	lui	s5,0x80006
80004874:	800065b7          	lui	a1,0x80006
80004878:	80006537          	lui	a0,0x80006
8000487c:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80004880:	04e00693          	li	a3,78
80004884:	648a8613          	addi	a2,s5,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004888:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
8000488c:	8e1fd0ef          	jal	ra,8000216c <printk>
80004890:	80006537          	lui	a0,0x80006
80004894:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80004898:	8d5fd0ef          	jal	ra,8000216c <printk>
8000489c:	04e00593          	li	a1,78
800048a0:	648a8513          	addi	a0,s5,1608
800048a4:	905fd0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800048a8:	00048513          	mv	a0,s1
800048ac:	27c000ef          	jal	ra,80004b28 <z_spin_lock_set_owner>

	if (likely(stack->next > stack->base)) {
800048b0:	01092783          	lw	a5,16(s2)
800048b4:	00c92703          	lw	a4,12(s2)
800048b8:	06f77263          	bgeu	a4,a5,8000491c <z_impl_k_stack_pop+0xf4>
		stack->next--;
800048bc:	ffc78713          	addi	a4,a5,-4
		*data = *(stack->next);
800048c0:	ffc7a783          	lw	a5,-4(a5)
		stack->next--;
800048c4:	00e92823          	sw	a4,16(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800048c8:	00048513          	mv	a0,s1
		*data = *(stack->next);
800048cc:	00f9a023          	sw	a5,0(s3)
800048d0:	228000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800048d4:	02051e63          	bnez	a0,80004910 <z_impl_k_stack_pop+0xe8>
800048d8:	800064b7          	lui	s1,0x80006
800048dc:	800065b7          	lui	a1,0x80006
800048e0:	80006537          	lui	a0,0x80006
800048e4:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800048e8:	06100693          	li	a3,97
800048ec:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800048f0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800048f4:	879fd0ef          	jal	ra,8000216c <printk>
800048f8:	80006537          	lui	a0,0x80006
800048fc:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80004900:	86dfd0ef          	jal	ra,8000216c <printk>
80004904:	06100593          	li	a1,97
80004908:	64848513          	addi	a0,s1,1608
8000490c:	89dfd0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004910:	30042473          	csrrs	s0,mstatus,s0
	if (result == -EAGAIN) {
		return -EAGAIN;
	}

	*data = (u32_t)_current->base.swap_data;
	return 0;
80004914:	00000513          	li	a0,0
80004918:	0540006f          	j	8000496c <z_impl_k_stack_pop+0x144>
	if (timeout == K_NO_WAIT) {
8000491c:	060a1a63          	bnez	s4,80004990 <z_impl_k_stack_pop+0x168>
80004920:	00048513          	mv	a0,s1
80004924:	1d4000ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80004928:	02051e63          	bnez	a0,80004964 <z_impl_k_stack_pop+0x13c>
8000492c:	800064b7          	lui	s1,0x80006
80004930:	800065b7          	lui	a1,0x80006
80004934:	80006537          	lui	a0,0x80006
80004938:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
8000493c:	06100693          	li	a3,97
80004940:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004944:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004948:	825fd0ef          	jal	ra,8000216c <printk>
8000494c:	80006537          	lui	a0,0x80006
80004950:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80004954:	819fd0ef          	jal	ra,8000216c <printk>
80004958:	06100593          	li	a1,97
8000495c:	64848513          	addi	a0,s1,1608
80004960:	849fd0ef          	jal	ra,800021a8 <assert_post_action>
80004964:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80004968:	ff000513          	li	a0,-16
}
8000496c:	01c12083          	lw	ra,28(sp)
80004970:	01812403          	lw	s0,24(sp)
80004974:	01412483          	lw	s1,20(sp)
80004978:	01012903          	lw	s2,16(sp)
8000497c:	00c12983          	lw	s3,12(sp)
80004980:	00812a03          	lw	s4,8(sp)
80004984:	00412a83          	lw	s5,4(sp)
80004988:	02010113          	addi	sp,sp,32
8000498c:	00008067          	ret
	result = z_pend_curr(&stack->lock, key, &stack->wait_q, timeout);
80004990:	000a0693          	mv	a3,s4
80004994:	00090613          	mv	a2,s2
80004998:	00040593          	mv	a1,s0
8000499c:	00048513          	mv	a0,s1
800049a0:	db0ff0ef          	jal	ra,80003f50 <z_pend_curr>
	if (result == -EAGAIN) {
800049a4:	ff500793          	li	a5,-11
800049a8:	fcf502e3          	beq	a0,a5,8000496c <z_impl_k_stack_pop+0x144>
	*data = (u32_t)_current->base.swap_data;
800049ac:	800077b7          	lui	a5,0x80007
800049b0:	0147a783          	lw	a5,20(a5) # 80007014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007015>
800049b4:	0147a783          	lw	a5,20(a5)
800049b8:	00f9a023          	sw	a5,0(s3)
800049bc:	f59ff06f          	j	80004914 <z_impl_k_stack_pop+0xec>

800049c0 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800049c0:	00d54783          	lbu	a5,13(a0)
800049c4:	01f7f793          	andi	a5,a5,31
800049c8:	00079863          	bnez	a5,800049d8 <z_is_thread_ready+0x18>
800049cc:	01852503          	lw	a0,24(a0)
800049d0:	00153513          	seqz	a0,a0
800049d4:	00008067          	ret
800049d8:	00000513          	li	a0,0
}
800049dc:	00008067          	ret

800049e0 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800049e0:	800077b7          	lui	a5,0x80007
800049e4:	00c7a503          	lw	a0,12(a5) # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
}
800049e8:	00a03533          	snez	a0,a0
800049ec:	00008067          	ret

800049f0 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800049f0:	800077b7          	lui	a5,0x80007
800049f4:	0147a783          	lw	a5,20(a5) # 80007014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007015>
800049f8:	00c7c503          	lbu	a0,12(a5)
}
800049fc:	00157513          	andi	a0,a0,1
80004a00:	00008067          	ret

80004a04 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004a04:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004a08:	02012303          	lw	t1,32(sp)
{
80004a0c:	00812c23          	sw	s0,24(sp)
80004a10:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004a14:	00612023          	sw	t1,0(sp)
{
80004a18:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004a1c:	fd8fc0ef          	jal	ra,800011f4 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004a20:	800077b7          	lui	a5,0x80007
80004a24:	0147a783          	lw	a5,20(a5) # 80007014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007015>
	sys_trace_thread_create(new_thread);
}
80004a28:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004a2c:	0687a783          	lw	a5,104(a5)
80004a30:	06f42423          	sw	a5,104(s0)
}
80004a34:	01812403          	lw	s0,24(sp)
80004a38:	02010113          	addi	sp,sp,32
80004a3c:	00008067          	ret

80004a40 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004a40:	06052783          	lw	a5,96(a0)
{
80004a44:	ff010113          	addi	sp,sp,-16
80004a48:	00812423          	sw	s0,8(sp)
80004a4c:	00112623          	sw	ra,12(sp)
80004a50:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004a54:	00078463          	beqz	a5,80004a5c <z_thread_single_abort+0x1c>
		thread->fn_abort();
80004a58:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80004a5c:	00040513          	mv	a0,s0
80004a60:	f61ff0ef          	jal	ra,800049c0 <z_is_thread_ready>
80004a64:	02050463          	beqz	a0,80004a8c <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80004a68:	00040513          	mv	a0,s0
80004a6c:	a74ff0ef          	jal	ra,80003ce0 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80004a70:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004a74:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004a78:	0087e793          	ori	a5,a5,8
80004a7c:	00f406a3          	sb	a5,13(s0)
}
80004a80:	00812403          	lw	s0,8(sp)
80004a84:	01010113          	addi	sp,sp,16
80004a88:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004a8c:	00d44783          	lbu	a5,13(s0)
80004a90:	0027f793          	andi	a5,a5,2
80004a94:	00078663          	beqz	a5,80004aa0 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80004a98:	00040513          	mv	a0,s0
80004a9c:	df4fe0ef          	jal	ra,80003090 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80004aa0:	01842783          	lw	a5,24(s0)
80004aa4:	fc0786e3          	beqz	a5,80004a70 <z_thread_single_abort+0x30>
80004aa8:	01840513          	addi	a0,s0,24
80004aac:	798000ef          	jal	ra,80005244 <z_abort_timeout>
80004ab0:	fc1ff06f          	j	80004a70 <z_thread_single_abort+0x30>

80004ab4 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80004ab4:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80004ab8:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004abc:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004ac0:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004ac4:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80004ac8:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004acc:	00008067          	ret

80004ad0 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004ad0:	00052503          	lw	a0,0(a0)
80004ad4:	00050e63          	beqz	a0,80004af0 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80004ad8:	800077b7          	lui	a5,0x80007
80004adc:	0207c783          	lbu	a5,32(a5) # 80007020 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007021>
80004ae0:	00357513          	andi	a0,a0,3
80004ae4:	40f50533          	sub	a0,a0,a5
80004ae8:	00a03533          	snez	a0,a0
80004aec:	00008067          	ret
			return false;
		}
	}
	return true;
80004af0:	00100513          	li	a0,1
}
80004af4:	00008067          	ret

80004af8 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80004af8:	800077b7          	lui	a5,0x80007
80004afc:	00c78793          	addi	a5,a5,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80004b00:	0147c703          	lbu	a4,20(a5)
80004b04:	0087a783          	lw	a5,8(a5)
80004b08:	00e7e7b3          	or	a5,a5,a4
80004b0c:	00052703          	lw	a4,0(a0)
80004b10:	00f71863          	bne	a4,a5,80004b20 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004b14:	00052023          	sw	zero,0(a0)
	return true;
80004b18:	00100513          	li	a0,1
80004b1c:	00008067          	ret
		return false;
80004b20:	00000513          	li	a0,0
}
80004b24:	00008067          	ret

80004b28 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004b28:	800077b7          	lui	a5,0x80007
80004b2c:	00c78793          	addi	a5,a5,12 # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
80004b30:	0147c703          	lbu	a4,20(a5)
80004b34:	0087a783          	lw	a5,8(a5)
80004b38:	00e7e7b3          	or	a5,a5,a4
80004b3c:	00f52023          	sw	a5,0(a0)
}
80004b40:	00008067          	ret

80004b44 <z_impl_k_thread_start>:
{
80004b44:	fe010113          	addi	sp,sp,-32
80004b48:	00812c23          	sw	s0,24(sp)
80004b4c:	01212823          	sw	s2,16(sp)
80004b50:	00112e23          	sw	ra,28(sp)
80004b54:	00912a23          	sw	s1,20(sp)
80004b58:	01312623          	sw	s3,12(sp)
80004b5c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b60:	00800413          	li	s0,8
80004b64:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b68:	800074b7          	lui	s1,0x80007
80004b6c:	cf048513          	addi	a0,s1,-784 # 80006cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004b70:	00847413          	andi	s0,s0,8
80004b74:	f5dff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80004b78:	02051e63          	bnez	a0,80004bb4 <z_impl_k_thread_start+0x70>
80004b7c:	800069b7          	lui	s3,0x80006
80004b80:	800065b7          	lui	a1,0x80006
80004b84:	80006537          	lui	a0,0x80006
80004b88:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80004b8c:	04e00693          	li	a3,78
80004b90:	64898613          	addi	a2,s3,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004b94:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004b98:	dd4fd0ef          	jal	ra,8000216c <printk>
80004b9c:	80006537          	lui	a0,0x80006
80004ba0:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80004ba4:	dc8fd0ef          	jal	ra,8000216c <printk>
80004ba8:	04e00593          	li	a1,78
80004bac:	64898513          	addi	a0,s3,1608
80004bb0:	df8fd0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004bb4:	cf048513          	addi	a0,s1,-784
80004bb8:	f71ff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004bbc:	00d94783          	lbu	a5,13(s2)
80004bc0:	0047f713          	andi	a4,a5,4
80004bc4:	06071463          	bnez	a4,80004c2c <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004bc8:	cf048513          	addi	a0,s1,-784
80004bcc:	f2dff0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80004bd0:	02051e63          	bnez	a0,80004c0c <z_impl_k_thread_start+0xc8>
80004bd4:	800064b7          	lui	s1,0x80006
80004bd8:	800065b7          	lui	a1,0x80006
80004bdc:	80006537          	lui	a0,0x80006
80004be0:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80004be4:	06100693          	li	a3,97
80004be8:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004bec:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004bf0:	d7cfd0ef          	jal	ra,8000216c <printk>
80004bf4:	80006537          	lui	a0,0x80006
80004bf8:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80004bfc:	d70fd0ef          	jal	ra,8000216c <printk>
80004c00:	06100593          	li	a1,97
80004c04:	64848513          	addi	a0,s1,1608
80004c08:	da0fd0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004c0c:	30042473          	csrrs	s0,mstatus,s0
}
80004c10:	01c12083          	lw	ra,28(sp)
80004c14:	01812403          	lw	s0,24(sp)
80004c18:	01412483          	lw	s1,20(sp)
80004c1c:	01012903          	lw	s2,16(sp)
80004c20:	00c12983          	lw	s3,12(sp)
80004c24:	02010113          	addi	sp,sp,32
80004c28:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004c2c:	ffb7f793          	andi	a5,a5,-5
80004c30:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004c34:	00090513          	mv	a0,s2
80004c38:	d89ff0ef          	jal	ra,800049c0 <z_is_thread_ready>
80004c3c:	00050663          	beqz	a0,80004c48 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004c40:	00090513          	mv	a0,s2
80004c44:	b95fe0ef          	jal	ra,800037d8 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80004c48:	00040593          	mv	a1,s0
}
80004c4c:	01812403          	lw	s0,24(sp)
80004c50:	01c12083          	lw	ra,28(sp)
80004c54:	01012903          	lw	s2,16(sp)
80004c58:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004c5c:	cf048513          	addi	a0,s1,-784
}
80004c60:	01412483          	lw	s1,20(sp)
80004c64:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004c68:	d24fe06f          	j	8000318c <z_reschedule>

80004c6c <schedule_new_thread>:
	if (delay == 0) {
80004c6c:	00059463          	bnez	a1,80004c74 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004c70:	ed5ff06f          	j	80004b44 <z_impl_k_thread_start>
{
80004c74:	ff010113          	addi	sp,sp,-16
80004c78:	00812423          	sw	s0,8(sp)
80004c7c:	00050413          	mv	s0,a0
80004c80:	00058513          	mv	a0,a1
80004c84:	00950513          	addi	a0,a0,9
80004c88:	00a00593          	li	a1,10
80004c8c:	00112623          	sw	ra,12(sp)
80004c90:	c29fb0ef          	jal	ra,800008b8 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004c94:	00150613          	addi	a2,a0,1
80004c98:	01840513          	addi	a0,s0,24
}
80004c9c:	00812403          	lw	s0,8(sp)
80004ca0:	00c12083          	lw	ra,12(sp)
80004ca4:	800045b7          	lui	a1,0x80004
80004ca8:	96858593          	addi	a1,a1,-1688 # 80003968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003969>
80004cac:	01010113          	addi	sp,sp,16
80004cb0:	3680006f          	j	80005018 <z_add_timeout>

80004cb4 <z_impl_k_thread_create>:
{
80004cb4:	fc010113          	addi	sp,sp,-64
80004cb8:	03512223          	sw	s5,36(sp)
80004cbc:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004cc0:	800076b7          	lui	a3,0x80007
80004cc4:	00c6a683          	lw	a3,12(a3) # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
{
80004cc8:	02812c23          	sw	s0,56(sp)
80004ccc:	02912a23          	sw	s1,52(sp)
80004cd0:	03312623          	sw	s3,44(sp)
80004cd4:	03412423          	sw	s4,40(sp)
80004cd8:	02112e23          	sw	ra,60(sp)
80004cdc:	03212823          	sw	s2,48(sp)
80004ce0:	00050413          	mv	s0,a0
80004ce4:	00058993          	mv	s3,a1
80004ce8:	00060a13          	mv	s4,a2
80004cec:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004cf0:	04068e63          	beqz	a3,80004d4c <z_impl_k_thread_create+0x98>
80004cf4:	80007937          	lui	s2,0x80007
80004cf8:	800075b7          	lui	a1,0x80007
80004cfc:	80006537          	lui	a0,0x80006
80004d00:	1b200693          	li	a3,434
80004d04:	a3490613          	addi	a2,s2,-1484 # 80006a34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a35>
80004d08:	85858593          	addi	a1,a1,-1960 # 80006858 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006859>
80004d0c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004d10:	01112e23          	sw	a7,28(sp)
80004d14:	01012c23          	sw	a6,24(sp)
80004d18:	00f12a23          	sw	a5,20(sp)
80004d1c:	00e12823          	sw	a4,16(sp)
80004d20:	c4cfd0ef          	jal	ra,8000216c <printk>
80004d24:	80007537          	lui	a0,0x80007
80004d28:	a4850513          	addi	a0,a0,-1464 # 80006a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a49>
80004d2c:	c40fd0ef          	jal	ra,8000216c <printk>
80004d30:	1b200593          	li	a1,434
80004d34:	a3490513          	addi	a0,s2,-1484
80004d38:	c70fd0ef          	jal	ra,800021a8 <assert_post_action>
80004d3c:	01c12883          	lw	a7,28(sp)
80004d40:	01812803          	lw	a6,24(sp)
80004d44:	01412783          	lw	a5,20(sp)
80004d48:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004d4c:	04012683          	lw	a3,64(sp)
80004d50:	00012223          	sw	zero,4(sp)
80004d54:	000a0613          	mv	a2,s4
80004d58:	00d12023          	sw	a3,0(sp)
80004d5c:	00098593          	mv	a1,s3
80004d60:	000a8693          	mv	a3,s5
80004d64:	00040513          	mv	a0,s0
80004d68:	c9dff0ef          	jal	ra,80004a04 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004d6c:	fff00793          	li	a5,-1
80004d70:	00f48863          	beq	s1,a5,80004d80 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80004d74:	00048593          	mv	a1,s1
80004d78:	00040513          	mv	a0,s0
80004d7c:	ef1ff0ef          	jal	ra,80004c6c <schedule_new_thread>
}
80004d80:	00040513          	mv	a0,s0
80004d84:	03c12083          	lw	ra,60(sp)
80004d88:	03812403          	lw	s0,56(sp)
80004d8c:	03412483          	lw	s1,52(sp)
80004d90:	03012903          	lw	s2,48(sp)
80004d94:	02c12983          	lw	s3,44(sp)
80004d98:	02812a03          	lw	s4,40(sp)
80004d9c:	02412a83          	lw	s5,36(sp)
80004da0:	04010113          	addi	sp,sp,64
80004da4:	00008067          	ret

80004da8 <z_init_static_threads>:
{
80004da8:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004dac:	800077b7          	lui	a5,0x80007
{
80004db0:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004db4:	80007937          	lui	s2,0x80007
{
80004db8:	00812c23          	sw	s0,24(sp)
80004dbc:	00912a23          	sw	s1,20(sp)
80004dc0:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004dc4:	c4478413          	addi	s0,a5,-956 # 80006c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c45>
80004dc8:	c4478493          	addi	s1,a5,-956
80004dcc:	c4490913          	addi	s2,s2,-956 # 80006c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c45>
80004dd0:	03246663          	bltu	s0,s2,80004dfc <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004dd4:	00048413          	mv	s0,s1
	k_sched_lock();
80004dd8:	cb4fe0ef          	jal	ra,8000328c <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004ddc:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004de0:	07246063          	bltu	s0,s2,80004e40 <z_init_static_threads+0x98>
}
80004de4:	01812403          	lw	s0,24(sp)
80004de8:	01c12083          	lw	ra,28(sp)
80004dec:	01412483          	lw	s1,20(sp)
80004df0:	01012903          	lw	s2,16(sp)
80004df4:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80004df8:	861fe06f          	j	80003658 <k_sched_unlock>
		z_setup_new_thread(
80004dfc:	02c42783          	lw	a5,44(s0)
80004e00:	00f12223          	sw	a5,4(sp)
80004e04:	02042783          	lw	a5,32(s0)
80004e08:	00f12023          	sw	a5,0(sp)
80004e0c:	01442783          	lw	a5,20(s0)
80004e10:	01c42883          	lw	a7,28(s0)
80004e14:	01842803          	lw	a6,24(s0)
80004e18:	01042703          	lw	a4,16(s0)
80004e1c:	00c42683          	lw	a3,12(s0)
80004e20:	00842603          	lw	a2,8(s0)
80004e24:	00442583          	lw	a1,4(s0)
80004e28:	00042503          	lw	a0,0(s0)
80004e2c:	bd9ff0ef          	jal	ra,80004a04 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004e30:	00042783          	lw	a5,0(s0)
80004e34:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80004e38:	03040413          	addi	s0,s0,48
80004e3c:	f95ff06f          	j	80004dd0 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004e40:	02442583          	lw	a1,36(s0)
80004e44:	00958663          	beq	a1,s1,80004e50 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
80004e48:	00042503          	lw	a0,0(s0)
80004e4c:	e21ff0ef          	jal	ra,80004c6c <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004e50:	03040413          	addi	s0,s0,48
80004e54:	f8dff06f          	j	80004de0 <z_init_static_threads+0x38>

80004e58 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80004e58:	fe010113          	addi	sp,sp,-32
80004e5c:	00812c23          	sw	s0,24(sp)
80004e60:	00912a23          	sw	s1,20(sp)
80004e64:	00112e23          	sw	ra,28(sp)
80004e68:	01212823          	sw	s2,16(sp)
80004e6c:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004e70:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e74:	00800413          	li	s0,8
80004e78:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e7c:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004e80:	00847413          	andi	s0,s0,8
80004e84:	c4dff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80004e88:	02051e63          	bnez	a0,80004ec4 <z_impl_k_thread_abort+0x6c>
80004e8c:	80006937          	lui	s2,0x80006
80004e90:	800065b7          	lui	a1,0x80006
80004e94:	80006537          	lui	a0,0x80006
80004e98:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80004e9c:	04e00693          	li	a3,78
80004ea0:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80004ea4:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004ea8:	ac4fd0ef          	jal	ra,8000216c <printk>
80004eac:	80006537          	lui	a0,0x80006
80004eb0:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80004eb4:	ab8fd0ef          	jal	ra,8000216c <printk>
80004eb8:	04e00593          	li	a1,78
80004ebc:	64890513          	addi	a0,s2,1608
80004ec0:	ae8fd0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ec4:	00c10513          	addi	a0,sp,12
80004ec8:	c61ff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004ecc:	00c4c783          	lbu	a5,12(s1)
80004ed0:	0017f793          	andi	a5,a5,1
80004ed4:	02078e63          	beqz	a5,80004f10 <z_impl_k_thread_abort+0xb8>
80004ed8:	80007937          	lui	s2,0x80007
80004edc:	800075b7          	lui	a1,0x80007
80004ee0:	80006537          	lui	a0,0x80006
80004ee4:	a8858593          	addi	a1,a1,-1400 # 80006a88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a89>
80004ee8:	02900693          	li	a3,41
80004eec:	a7090613          	addi	a2,s2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80004ef0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80004ef4:	a78fd0ef          	jal	ra,8000216c <printk>
80004ef8:	80007537          	lui	a0,0x80007
80004efc:	abc50513          	addi	a0,a0,-1348 # 80006abc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006abd>
80004f00:	a6cfd0ef          	jal	ra,8000216c <printk>
80004f04:	02900593          	li	a1,41
80004f08:	a7090513          	addi	a0,s2,-1424
80004f0c:	a9cfd0ef          	jal	ra,800021a8 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004f10:	00048513          	mv	a0,s1
80004f14:	b2dff0ef          	jal	ra,80004a40 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80004f18:	00040593          	mv	a1,s0
80004f1c:	00c10513          	addi	a0,sp,12
80004f20:	a6cfe0ef          	jal	ra,8000318c <z_reschedule>
}
80004f24:	01c12083          	lw	ra,28(sp)
80004f28:	01812403          	lw	s0,24(sp)
80004f2c:	01412483          	lw	s1,20(sp)
80004f30:	01012903          	lw	s2,16(sp)
80004f34:	02010113          	addi	sp,sp,32
80004f38:	00008067          	ret

80004f3c <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004f3c:	800077b7          	lui	a5,0x80007
80004f40:	cf47a783          	lw	a5,-780(a5) # 80006cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf5>
80004f44:	00079463          	bnez	a5,80004f4c <elapsed+0x10>
80004f48:	ee0fd06f          	j	80002628 <z_clock_elapsed>
}
80004f4c:	00000513          	li	a0,0
80004f50:	00008067          	ret

80004f54 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004f54:	00052783          	lw	a5,0(a0)
80004f58:	02050263          	beqz	a0,80004f7c <remove_timeout+0x28>
80004f5c:	80007737          	lui	a4,0x80007
	return (node == list->tail) ? NULL : node->next;
80004f60:	c0872703          	lw	a4,-1016(a4) # 80006c08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c09>
80004f64:	00e50c63          	beq	a0,a4,80004f7c <remove_timeout+0x28>
	if (next(t) != NULL) {
80004f68:	00078a63          	beqz	a5,80004f7c <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80004f6c:	0087a703          	lw	a4,8(a5)
80004f70:	00852683          	lw	a3,8(a0)
80004f74:	00d70733          	add	a4,a4,a3
80004f78:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80004f7c:	00452703          	lw	a4,4(a0)
80004f80:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004f84:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80004f88:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004f8c:	00052223          	sw	zero,4(a0)
}
80004f90:	00008067          	ret

80004f94 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004f94:	800077b7          	lui	a5,0x80007
80004f98:	d007c783          	lbu	a5,-768(a5) # 80006d00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d01>
{
80004f9c:	ff010113          	addi	sp,sp,-16
80004fa0:	00112623          	sw	ra,12(sp)
80004fa4:	00812423          	sw	s0,8(sp)
80004fa8:	00912223          	sw	s1,4(sp)
80004fac:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004fb0:	00079663          	bnez	a5,80004fbc <next_timeout+0x28>
80004fb4:	80000537          	lui	a0,0x80000
80004fb8:	fff54513          	not	a0,a0
	return list->head == list;
80004fbc:	800077b7          	lui	a5,0x80007
80004fc0:	c0478793          	addi	a5,a5,-1020 # 80006c04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c05>
80004fc4:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004fc8:	02f40463          	beq	s0,a5,80004ff0 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004fcc:	02040263          	beqz	s0,80004ff0 <next_timeout+0x5c>
80004fd0:	00842483          	lw	s1,8(s0)
80004fd4:	f69ff0ef          	jal	ra,80004f3c <elapsed>
80004fd8:	40a484b3          	sub	s1,s1,a0
80004fdc:	00000513          	li	a0,0
80004fe0:	0004c863          	bltz	s1,80004ff0 <next_timeout+0x5c>
80004fe4:	00842403          	lw	s0,8(s0)
80004fe8:	f55ff0ef          	jal	ra,80004f3c <elapsed>
80004fec:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004ff0:	800077b7          	lui	a5,0x80007
80004ff4:	01c7a783          	lw	a5,28(a5) # 8000701c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000701d>
80004ff8:	00078663          	beqz	a5,80005004 <next_timeout+0x70>
80004ffc:	00a7d463          	bge	a5,a0,80005004 <next_timeout+0x70>
80005000:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80005004:	00c12083          	lw	ra,12(sp)
80005008:	00812403          	lw	s0,8(sp)
8000500c:	00412483          	lw	s1,4(sp)
80005010:	01010113          	addi	sp,sp,16
80005014:	00008067          	ret

80005018 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005018:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
8000501c:	fd010113          	addi	sp,sp,-48
80005020:	02812423          	sw	s0,40(sp)
80005024:	02912223          	sw	s1,36(sp)
80005028:	01312e23          	sw	s3,28(sp)
8000502c:	02112623          	sw	ra,44(sp)
80005030:	03212023          	sw	s2,32(sp)
80005034:	01412c23          	sw	s4,24(sp)
80005038:	01512a23          	sw	s5,20(sp)
8000503c:	01612823          	sw	s6,16(sp)
80005040:	01712623          	sw	s7,12(sp)
80005044:	01812423          	sw	s8,8(sp)
80005048:	00050413          	mv	s0,a0
8000504c:	00058993          	mv	s3,a1
80005050:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005054:	02078e63          	beqz	a5,80005090 <z_add_timeout+0x78>
80005058:	80007937          	lui	s2,0x80007
8000505c:	800075b7          	lui	a1,0x80007
80005060:	80006537          	lui	a0,0x80006
80005064:	aec58593          	addi	a1,a1,-1300 # 80006aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006aed>
80005068:	04d00693          	li	a3,77
8000506c:	ad890613          	addi	a2,s2,-1320 # 80006ad8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ad9>
80005070:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005074:	8f8fd0ef          	jal	ra,8000216c <printk>
80005078:	80006537          	lui	a0,0x80006
8000507c:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
80005080:	8ecfd0ef          	jal	ra,8000216c <printk>
80005084:	04d00593          	li	a1,77
80005088:	ad890513          	addi	a0,s2,-1320
8000508c:	91cfd0ef          	jal	ra,800021a8 <assert_post_action>
	to->fn = fn;
80005090:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80005094:	00904463          	bgtz	s1,8000509c <z_add_timeout+0x84>
80005098:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000509c:	00800993          	li	s3,8
800050a0:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800050a4:	80007a37          	lui	s4,0x80007
800050a8:	cf8a0513          	addi	a0,s4,-776 # 80006cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf9>
	key = (mstatus & SOC_MSTATUS_IEN);
800050ac:	0089f993          	andi	s3,s3,8
800050b0:	a21ff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
800050b4:	02051e63          	bnez	a0,800050f0 <z_add_timeout+0xd8>
800050b8:	80006937          	lui	s2,0x80006
800050bc:	800065b7          	lui	a1,0x80006
800050c0:	80006537          	lui	a0,0x80006
800050c4:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800050c8:	04e00693          	li	a3,78
800050cc:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800050d0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800050d4:	898fd0ef          	jal	ra,8000216c <printk>
800050d8:	80006537          	lui	a0,0x80006
800050dc:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
800050e0:	88cfd0ef          	jal	ra,8000216c <printk>
800050e4:	04e00593          	li	a1,78
800050e8:	64890513          	addi	a0,s2,1608
800050ec:	8bcfd0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800050f0:	cf8a0513          	addi	a0,s4,-776
800050f4:	a35ff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
800050f8:	e45ff0ef          	jal	ra,80004f3c <elapsed>
800050fc:	00950533          	add	a0,a0,s1
	return list->head == list;
80005100:	800074b7          	lui	s1,0x80007
80005104:	c044a903          	lw	s2,-1020(s1) # 80006c04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c05>
80005108:	00a42423          	sw	a0,8(s0)
8000510c:	c0448493          	addi	s1,s1,-1020
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005110:	00990c63          	beq	s2,s1,80005128 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80005114:	80007ab7          	lui	s5,0x80007
80005118:	80007b37          	lui	s6,0x80007
8000511c:	80006bb7          	lui	s7,0x80006
80005120:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
80005124:	02091063          	bnez	s2,80005144 <z_add_timeout+0x12c>
	node->prev = list->tail;
80005128:	0044a783          	lw	a5,4(s1)
	node->next = list;
8000512c:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80005130:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80005134:	0044a783          	lw	a5,4(s1)
80005138:	0087a023          	sw	s0,0(a5)
	list->tail = node;
8000513c:	0084a223          	sw	s0,4(s1)
80005140:	05c0006f          	j	8000519c <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80005144:	00892783          	lw	a5,8(s2)
80005148:	0207d663          	bgez	a5,80005174 <z_add_timeout+0x15c>
8000514c:	b0cb0593          	addi	a1,s6,-1268 # 80006b0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b0d>
80005150:	05600693          	li	a3,86
80005154:	ad8a8613          	addi	a2,s5,-1320 # 80006ad8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ad9>
80005158:	57cb8513          	addi	a0,s7,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
8000515c:	810fd0ef          	jal	ra,8000216c <printk>
80005160:	600c0513          	addi	a0,s8,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
80005164:	808fd0ef          	jal	ra,8000216c <printk>
80005168:	05600593          	li	a1,86
8000516c:	ad8a8513          	addi	a0,s5,-1320
80005170:	838fd0ef          	jal	ra,800021a8 <assert_post_action>

			if (t->dticks > to->dticks) {
80005174:	00892703          	lw	a4,8(s2)
80005178:	00842783          	lw	a5,8(s0)
8000517c:	0ae7d863          	bge	a5,a4,8000522c <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80005180:	40f707b3          	sub	a5,a4,a5
80005184:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80005188:	00492783          	lw	a5,4(s2)
	node->next = successor;
8000518c:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80005190:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80005194:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80005198:	00892223          	sw	s0,4(s2)
	return list->head == list;
8000519c:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800051a0:	00978a63          	beq	a5,s1,800051b4 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
800051a4:	00f41863          	bne	s0,a5,800051b4 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
800051a8:	dedff0ef          	jal	ra,80004f94 <next_timeout>
800051ac:	00000593          	li	a1,0
800051b0:	ad0fd0ef          	jal	ra,80002480 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800051b4:	cf8a0513          	addi	a0,s4,-776
800051b8:	941ff0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800051bc:	02051e63          	bnez	a0,800051f8 <z_add_timeout+0x1e0>
800051c0:	80006437          	lui	s0,0x80006
800051c4:	800065b7          	lui	a1,0x80006
800051c8:	80006537          	lui	a0,0x80006
800051cc:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800051d0:	06100693          	li	a3,97
800051d4:	64840613          	addi	a2,s0,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800051d8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800051dc:	f91fc0ef          	jal	ra,8000216c <printk>
800051e0:	80006537          	lui	a0,0x80006
800051e4:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800051e8:	f85fc0ef          	jal	ra,8000216c <printk>
800051ec:	06100593          	li	a1,97
800051f0:	64840513          	addi	a0,s0,1608
800051f4:	fb5fc0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800051f8:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
800051fc:	02c12083          	lw	ra,44(sp)
80005200:	02812403          	lw	s0,40(sp)
80005204:	02412483          	lw	s1,36(sp)
80005208:	02012903          	lw	s2,32(sp)
8000520c:	01c12983          	lw	s3,28(sp)
80005210:	01812a03          	lw	s4,24(sp)
80005214:	01412a83          	lw	s5,20(sp)
80005218:	01012b03          	lw	s6,16(sp)
8000521c:	00c12b83          	lw	s7,12(sp)
80005220:	00812c03          	lw	s8,8(sp)
80005224:	03010113          	addi	sp,sp,48
80005228:	00008067          	ret
			to->dticks -= t->dticks;
8000522c:	40e787b3          	sub	a5,a5,a4
80005230:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80005234:	0044a783          	lw	a5,4(s1)
80005238:	ef2788e3          	beq	a5,s2,80005128 <z_add_timeout+0x110>
8000523c:	00092903          	lw	s2,0(s2)
80005240:	ee5ff06f          	j	80005124 <z_add_timeout+0x10c>

80005244 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80005244:	fe010113          	addi	sp,sp,-32
80005248:	00812c23          	sw	s0,24(sp)
8000524c:	01312623          	sw	s3,12(sp)
80005250:	00112e23          	sw	ra,28(sp)
80005254:	00912a23          	sw	s1,20(sp)
80005258:	01212823          	sw	s2,16(sp)
8000525c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005260:	00800413          	li	s0,8
80005264:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005268:	800074b7          	lui	s1,0x80007
8000526c:	cf848513          	addi	a0,s1,-776 # 80006cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005270:	00847413          	andi	s0,s0,8
80005274:	85dff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80005278:	02051e63          	bnez	a0,800052b4 <z_abort_timeout+0x70>
8000527c:	80006937          	lui	s2,0x80006
80005280:	800065b7          	lui	a1,0x80006
80005284:	80006537          	lui	a0,0x80006
80005288:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
8000528c:	04e00693          	li	a3,78
80005290:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80005294:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005298:	ed5fc0ef          	jal	ra,8000216c <printk>
8000529c:	80006537          	lui	a0,0x80006
800052a0:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
800052a4:	ec9fc0ef          	jal	ra,8000216c <printk>
800052a8:	04e00593          	li	a1,78
800052ac:	64890513          	addi	a0,s2,1608
800052b0:	ef9fc0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800052b4:	cf848513          	addi	a0,s1,-776
800052b8:	871ff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
800052bc:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
800052c0:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
800052c4:	00078863          	beqz	a5,800052d4 <z_abort_timeout+0x90>
			remove_timeout(to);
800052c8:	00098513          	mv	a0,s3
800052cc:	c89ff0ef          	jal	ra,80004f54 <remove_timeout>
			ret = 0;
800052d0:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800052d4:	cf848513          	addi	a0,s1,-776
800052d8:	821ff0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800052dc:	02051e63          	bnez	a0,80005318 <z_abort_timeout+0xd4>
800052e0:	800064b7          	lui	s1,0x80006
800052e4:	800065b7          	lui	a1,0x80006
800052e8:	80006537          	lui	a0,0x80006
800052ec:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800052f0:	06100693          	li	a3,97
800052f4:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800052f8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800052fc:	e71fc0ef          	jal	ra,8000216c <printk>
80005300:	80006537          	lui	a0,0x80006
80005304:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80005308:	e65fc0ef          	jal	ra,8000216c <printk>
8000530c:	06100593          	li	a1,97
80005310:	64848513          	addi	a0,s1,1608
80005314:	e95fc0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005318:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
8000531c:	01c12083          	lw	ra,28(sp)
80005320:	01812403          	lw	s0,24(sp)
80005324:	00090513          	mv	a0,s2
80005328:	01412483          	lw	s1,20(sp)
8000532c:	01012903          	lw	s2,16(sp)
80005330:	00c12983          	lw	s3,12(sp)
80005334:	02010113          	addi	sp,sp,32
80005338:	00008067          	ret

8000533c <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
8000533c:	ff010113          	addi	sp,sp,-16
80005340:	00812423          	sw	s0,8(sp)
80005344:	00112623          	sw	ra,12(sp)
80005348:	00912223          	sw	s1,4(sp)
8000534c:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005350:	00800413          	li	s0,8
80005354:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005358:	800074b7          	lui	s1,0x80007
8000535c:	cf848513          	addi	a0,s1,-776 # 80006cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005360:	00847413          	andi	s0,s0,8
80005364:	f6cff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80005368:	02051e63          	bnez	a0,800053a4 <z_get_next_timeout_expiry+0x68>
8000536c:	80006937          	lui	s2,0x80006
80005370:	800065b7          	lui	a1,0x80006
80005374:	80006537          	lui	a0,0x80006
80005378:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
8000537c:	04e00693          	li	a3,78
80005380:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80005384:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005388:	de5fc0ef          	jal	ra,8000216c <printk>
8000538c:	80006537          	lui	a0,0x80006
80005390:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80005394:	dd9fc0ef          	jal	ra,8000216c <printk>
80005398:	04e00593          	li	a1,78
8000539c:	64890513          	addi	a0,s2,1608
800053a0:	e09fc0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800053a4:	cf848513          	addi	a0,s1,-776
800053a8:	f80ff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
800053ac:	be9ff0ef          	jal	ra,80004f94 <next_timeout>
800053b0:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800053b4:	cf848513          	addi	a0,s1,-776
800053b8:	f40ff0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800053bc:	02051e63          	bnez	a0,800053f8 <z_get_next_timeout_expiry+0xbc>
800053c0:	800064b7          	lui	s1,0x80006
800053c4:	800065b7          	lui	a1,0x80006
800053c8:	80006537          	lui	a0,0x80006
800053cc:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800053d0:	06100693          	li	a3,97
800053d4:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800053d8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800053dc:	d91fc0ef          	jal	ra,8000216c <printk>
800053e0:	80006537          	lui	a0,0x80006
800053e4:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800053e8:	d85fc0ef          	jal	ra,8000216c <printk>
800053ec:	06100593          	li	a1,97
800053f0:	64848513          	addi	a0,s1,1608
800053f4:	db5fc0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800053f8:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800053fc:	00c12083          	lw	ra,12(sp)
80005400:	00812403          	lw	s0,8(sp)
80005404:	00090513          	mv	a0,s2
80005408:	00412483          	lw	s1,4(sp)
8000540c:	00012903          	lw	s2,0(sp)
80005410:	01010113          	addi	sp,sp,16
80005414:	00008067          	ret

80005418 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80005418:	fe010113          	addi	sp,sp,-32
8000541c:	00812c23          	sw	s0,24(sp)
80005420:	01212823          	sw	s2,16(sp)
80005424:	01412423          	sw	s4,8(sp)
80005428:	00112e23          	sw	ra,28(sp)
8000542c:	00912a23          	sw	s1,20(sp)
80005430:	01312623          	sw	s3,12(sp)
80005434:	00050913          	mv	s2,a0
80005438:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000543c:	00800413          	li	s0,8
80005440:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005444:	800074b7          	lui	s1,0x80007
80005448:	cf848513          	addi	a0,s1,-776 # 80006cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf9>
	key = (mstatus & SOC_MSTATUS_IEN);
8000544c:	00847413          	andi	s0,s0,8
80005450:	e80ff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80005454:	02051e63          	bnez	a0,80005490 <z_set_timeout_expiry+0x78>
80005458:	800069b7          	lui	s3,0x80006
8000545c:	800065b7          	lui	a1,0x80006
80005460:	80006537          	lui	a0,0x80006
80005464:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80005468:	04e00693          	li	a3,78
8000546c:	64898613          	addi	a2,s3,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80005470:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005474:	cf9fc0ef          	jal	ra,8000216c <printk>
80005478:	80006537          	lui	a0,0x80006
8000547c:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80005480:	cedfc0ef          	jal	ra,8000216c <printk>
80005484:	04e00593          	li	a1,78
80005488:	64898513          	addi	a0,s3,1608
8000548c:	d1dfc0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005490:	cf848513          	addi	a0,s1,-776
80005494:	e94ff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80005498:	afdff0ef          	jal	ra,80004f94 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
8000549c:	00a95c63          	bge	s2,a0,800054b4 <z_set_timeout_expiry+0x9c>
800054a0:	00100793          	li	a5,1
800054a4:	00a7d863          	bge	a5,a0,800054b4 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
800054a8:	000a0593          	mv	a1,s4
800054ac:	00090513          	mv	a0,s2
800054b0:	fd1fc0ef          	jal	ra,80002480 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800054b4:	cf848513          	addi	a0,s1,-776
800054b8:	e40ff0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800054bc:	02051e63          	bnez	a0,800054f8 <z_set_timeout_expiry+0xe0>
800054c0:	800064b7          	lui	s1,0x80006
800054c4:	800065b7          	lui	a1,0x80006
800054c8:	80006537          	lui	a0,0x80006
800054cc:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800054d0:	06100693          	li	a3,97
800054d4:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800054d8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800054dc:	c91fc0ef          	jal	ra,8000216c <printk>
800054e0:	80006537          	lui	a0,0x80006
800054e4:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
800054e8:	c85fc0ef          	jal	ra,8000216c <printk>
800054ec:	06100593          	li	a1,97
800054f0:	64848513          	addi	a0,s1,1608
800054f4:	cb5fc0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800054f8:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800054fc:	01c12083          	lw	ra,28(sp)
80005500:	01812403          	lw	s0,24(sp)
80005504:	01412483          	lw	s1,20(sp)
80005508:	01012903          	lw	s2,16(sp)
8000550c:	00c12983          	lw	s3,12(sp)
80005510:	00812a03          	lw	s4,8(sp)
80005514:	02010113          	addi	sp,sp,32
80005518:	00008067          	ret

8000551c <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
8000551c:	fd010113          	addi	sp,sp,-48
80005520:	02812423          	sw	s0,40(sp)
80005524:	01412c23          	sw	s4,24(sp)
80005528:	02112623          	sw	ra,44(sp)
8000552c:	02912223          	sw	s1,36(sp)
80005530:	03212023          	sw	s2,32(sp)
80005534:	01312e23          	sw	s3,28(sp)
80005538:	01512a23          	sw	s5,20(sp)
8000553c:	01612823          	sw	s6,16(sp)
80005540:	01712623          	sw	s7,12(sp)
80005544:	01812423          	sw	s8,8(sp)
80005548:	01912223          	sw	s9,4(sp)
8000554c:	01a12023          	sw	s10,0(sp)
80005550:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005554:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80005558:	f10fe0ef          	jal	ra,80003c68 <z_time_slice>
8000555c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005560:	80007937          	lui	s2,0x80007
80005564:	cf890513          	addi	a0,s2,-776 # 80006cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005568:	00847413          	andi	s0,s0,8
8000556c:	d64ff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80005570:	02051e63          	bnez	a0,800055ac <z_clock_announce+0x90>
80005574:	800064b7          	lui	s1,0x80006
80005578:	800065b7          	lui	a1,0x80006
8000557c:	80006537          	lui	a0,0x80006
80005580:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80005584:	04e00693          	li	a3,78
80005588:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
8000558c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005590:	bddfc0ef          	jal	ra,8000216c <printk>
80005594:	80006537          	lui	a0,0x80006
80005598:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
8000559c:	bd1fc0ef          	jal	ra,8000216c <printk>
800055a0:	04e00593          	li	a1,78
800055a4:	64848513          	addi	a0,s1,1608
800055a8:	c01fc0ef          	jal	ra,800021a8 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
800055ac:	800079b7          	lui	s3,0x80007
	z_spin_lock_set_owner(l);
800055b0:	cf890513          	addi	a0,s2,-776
800055b4:	d74ff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
800055b8:	800074b7          	lui	s1,0x80007
800055bc:	cf49aa23          	sw	s4,-780(s3) # 80006cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf5>
	return list->head == list;
800055c0:	80007a37          	lui	s4,0x80007
800055c4:	cf498993          	addi	s3,s3,-780
800055c8:	c04a0a13          	addi	s4,s4,-1020 # 80006c04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c05>
800055cc:	cb848493          	addi	s1,s1,-840 # 80006cb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb9>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800055d0:	80006ab7          	lui	s5,0x80006
800055d4:	80006bb7          	lui	s7,0x80006
800055d8:	80006b37          	lui	s6,0x80006
800055dc:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800055e0:	80006cb7          	lui	s9,0x80006
800055e4:	000a2d03          	lw	s10,0(s4)
800055e8:	0009a783          	lw	a5,0(s3)
800055ec:	0004a683          	lw	a3,0(s1)
800055f0:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800055f4:	014d0c63          	beq	s10,s4,8000560c <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
800055f8:	000d0a63          	beqz	s10,8000560c <z_clock_announce+0xf0>
800055fc:	008d2703          	lw	a4,8(s10)
80005600:	0ae7dc63          	bge	a5,a4,800056b8 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80005604:	40f70733          	sub	a4,a4,a5
80005608:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
8000560c:	00d786b3          	add	a3,a5,a3
80005610:	41f7d713          	srai	a4,a5,0x1f
80005614:	00a70733          	add	a4,a4,a0
80005618:	00f6b7b3          	sltu	a5,a3,a5
8000561c:	00e787b3          	add	a5,a5,a4
80005620:	00d4a023          	sw	a3,0(s1)
80005624:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005628:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
8000562c:	969ff0ef          	jal	ra,80004f94 <next_timeout>
80005630:	00000593          	li	a1,0
80005634:	e4dfc0ef          	jal	ra,80002480 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005638:	cf890513          	addi	a0,s2,-776
8000563c:	cbcff0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80005640:	02051e63          	bnez	a0,8000567c <z_clock_announce+0x160>
80005644:	800064b7          	lui	s1,0x80006
80005648:	800065b7          	lui	a1,0x80006
8000564c:	80006537          	lui	a0,0x80006
80005650:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80005654:	06100693          	li	a3,97
80005658:	64848613          	addi	a2,s1,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
8000565c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005660:	b0dfc0ef          	jal	ra,8000216c <printk>
80005664:	80006537          	lui	a0,0x80006
80005668:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
8000566c:	b01fc0ef          	jal	ra,8000216c <printk>
80005670:	06100593          	li	a1,97
80005674:	64848513          	addi	a0,s1,1608
80005678:	b31fc0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000567c:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80005680:	02c12083          	lw	ra,44(sp)
80005684:	02812403          	lw	s0,40(sp)
80005688:	02412483          	lw	s1,36(sp)
8000568c:	02012903          	lw	s2,32(sp)
80005690:	01c12983          	lw	s3,28(sp)
80005694:	01812a03          	lw	s4,24(sp)
80005698:	01412a83          	lw	s5,20(sp)
8000569c:	01012b03          	lw	s6,16(sp)
800056a0:	00c12b83          	lw	s7,12(sp)
800056a4:	00812c03          	lw	s8,8(sp)
800056a8:	00412c83          	lw	s9,4(sp)
800056ac:	00012d03          	lw	s10,0(sp)
800056b0:	03010113          	addi	sp,sp,48
800056b4:	00008067          	ret
		curr_tick += dt;
800056b8:	00d706b3          	add	a3,a4,a3
800056bc:	41f75593          	srai	a1,a4,0x1f
800056c0:	00a585b3          	add	a1,a1,a0
800056c4:	00e6b633          	sltu	a2,a3,a4
800056c8:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
800056cc:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
800056d0:	000d0513          	mv	a0,s10
		t->dticks = 0;
800056d4:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
800056d8:	00d4a023          	sw	a3,0(s1)
800056dc:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
800056e0:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
800056e4:	871ff0ef          	jal	ra,80004f54 <remove_timeout>
800056e8:	cf890513          	addi	a0,s2,-776
800056ec:	c0cff0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
800056f0:	02051663          	bnez	a0,8000571c <z_clock_announce+0x200>
800056f4:	690b8593          	addi	a1,s7,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
800056f8:	06100693          	li	a3,97
800056fc:	648a8613          	addi	a2,s5,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80005700:	57cb0513          	addi	a0,s6,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005704:	a69fc0ef          	jal	ra,8000216c <printk>
80005708:	6a8c0513          	addi	a0,s8,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
8000570c:	a61fc0ef          	jal	ra,8000216c <printk>
80005710:	06100593          	li	a1,97
80005714:	648a8513          	addi	a0,s5,1608
80005718:	a91fc0ef          	jal	ra,800021a8 <assert_post_action>
8000571c:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80005720:	00cd2783          	lw	a5,12(s10)
80005724:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005728:	00800413          	li	s0,8
8000572c:	000780e7          	jalr	a5
80005730:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005734:	cf890513          	addi	a0,s2,-776
	key = (mstatus & SOC_MSTATUS_IEN);
80005738:	00847413          	andi	s0,s0,8
8000573c:	b94ff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80005740:	02051863          	bnez	a0,80005770 <z_clock_announce+0x254>
80005744:	660c8593          	addi	a1,s9,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80005748:	04e00693          	li	a3,78
8000574c:	648a8613          	addi	a2,s5,1608
80005750:	57cb0513          	addi	a0,s6,1404
80005754:	a19fc0ef          	jal	ra,8000216c <printk>
80005758:	80006537          	lui	a0,0x80006
8000575c:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80005760:	a0dfc0ef          	jal	ra,8000216c <printk>
80005764:	04e00593          	li	a1,78
80005768:	648a8513          	addi	a0,s5,1608
8000576c:	a3dfc0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005770:	cf890513          	addi	a0,s2,-776
80005774:	bb4ff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	return k;
80005778:	e6dff06f          	j	800055e4 <z_clock_announce+0xc8>

8000577c <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
8000577c:	fe010113          	addi	sp,sp,-32
80005780:	00912a23          	sw	s1,20(sp)
80005784:	00112e23          	sw	ra,28(sp)
80005788:	00812c23          	sw	s0,24(sp)
8000578c:	01212823          	sw	s2,16(sp)
80005790:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005794:	00800493          	li	s1,8
80005798:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000579c:	80007937          	lui	s2,0x80007
800057a0:	cf890513          	addi	a0,s2,-776 # 80006cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cf9>
	key = (mstatus & SOC_MSTATUS_IEN);
800057a4:	0084f493          	andi	s1,s1,8
800057a8:	b28ff0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
800057ac:	02051e63          	bnez	a0,800057e8 <z_tick_get+0x6c>
800057b0:	80006437          	lui	s0,0x80006
800057b4:	800065b7          	lui	a1,0x80006
800057b8:	80006537          	lui	a0,0x80006
800057bc:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
800057c0:	04e00693          	li	a3,78
800057c4:	64840613          	addi	a2,s0,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
800057c8:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
800057cc:	9a1fc0ef          	jal	ra,8000216c <printk>
800057d0:	80006537          	lui	a0,0x80006
800057d4:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
800057d8:	995fc0ef          	jal	ra,8000216c <printk>
800057dc:	04e00593          	li	a1,78
800057e0:	64840513          	addi	a0,s0,1608
800057e4:	9c5fc0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
800057e8:	cf890513          	addi	a0,s2,-776
800057ec:	b3cff0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
800057f0:	e39fc0ef          	jal	ra,80002628 <z_clock_elapsed>
800057f4:	800077b7          	lui	a5,0x80007
800057f8:	cb878793          	addi	a5,a5,-840 # 80006cb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb9>
800057fc:	0007a983          	lw	s3,0(a5)
80005800:	0047a403          	lw	s0,4(a5)
80005804:	013509b3          	add	s3,a0,s3
80005808:	00a9b533          	sltu	a0,s3,a0
8000580c:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005810:	cf890513          	addi	a0,s2,-776
80005814:	ae4ff0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80005818:	02051e63          	bnez	a0,80005854 <z_tick_get+0xd8>
8000581c:	80006937          	lui	s2,0x80006
80005820:	800065b7          	lui	a1,0x80006
80005824:	80006537          	lui	a0,0x80006
80005828:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
8000582c:	06100693          	li	a3,97
80005830:	64890613          	addi	a2,s2,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80005834:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005838:	935fc0ef          	jal	ra,8000216c <printk>
8000583c:	80006537          	lui	a0,0x80006
80005840:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80005844:	929fc0ef          	jal	ra,8000216c <printk>
80005848:	06100593          	li	a1,97
8000584c:	64890513          	addi	a0,s2,1608
80005850:	959fc0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005854:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80005858:	00040593          	mv	a1,s0
8000585c:	01c12083          	lw	ra,28(sp)
80005860:	01812403          	lw	s0,24(sp)
80005864:	00098513          	mv	a0,s3
80005868:	01412483          	lw	s1,20(sp)
8000586c:	01012903          	lw	s2,16(sp)
80005870:	00c12983          	lw	s3,12(sp)
80005874:	02010113          	addi	sp,sp,32
80005878:	00008067          	ret

8000587c <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
8000587c:	ff010113          	addi	sp,sp,-16
80005880:	00812423          	sw	s0,8(sp)
80005884:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005888:	80007437          	lui	s0,0x80007
8000588c:	800074b7          	lui	s1,0x80007
{
80005890:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80005894:	c4440413          	addi	s0,s0,-956 # 80006c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c45>
80005898:	c6048493          	addi	s1,s1,-928 # 80006c60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c61>
8000589c:	00946e63          	bltu	s0,s1,800058b8 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
800058a0:	00c12083          	lw	ra,12(sp)
800058a4:	00812403          	lw	s0,8(sp)
800058a8:	00412483          	lw	s1,4(sp)
800058ac:	00000513          	li	a0,0
800058b0:	01010113          	addi	sp,sp,16
800058b4:	00008067          	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
800058b8:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
800058bc:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
800058c0:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
800058c4:	00f42c23          	sw	a5,24(s0)
800058c8:	b15fb0ef          	jal	ra,800013dc <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800058cc:	01c40413          	addi	s0,s0,28
800058d0:	fcdff06f          	j	8000589c <init_static_pools+0x20>

800058d4 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800058d4:	800077b7          	lui	a5,0x80007
800058d8:	00c7a783          	lw	a5,12(a5) # 8000700c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000700d>
{
800058dc:	fb010113          	addi	sp,sp,-80
800058e0:	04812423          	sw	s0,72(sp)
800058e4:	04912223          	sw	s1,68(sp)
800058e8:	03312e23          	sw	s3,60(sp)
800058ec:	03612823          	sw	s6,48(sp)
800058f0:	04112623          	sw	ra,76(sp)
800058f4:	05212023          	sw	s2,64(sp)
800058f8:	03412c23          	sw	s4,56(sp)
800058fc:	03512a23          	sw	s5,52(sp)
80005900:	03712623          	sw	s7,44(sp)
80005904:	03812423          	sw	s8,40(sp)
80005908:	03912223          	sw	s9,36(sp)
8000590c:	03a12023          	sw	s10,32(sp)
80005910:	01b12e23          	sw	s11,28(sp)
80005914:	00050993          	mv	s3,a0
80005918:	00058493          	mv	s1,a1
8000591c:	00060b13          	mv	s6,a2
80005920:	00068413          	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80005924:	16078263          	beqz	a5,80005a88 <k_mem_pool_alloc+0x1b4>
80005928:	12069463          	bnez	a3,80005a50 <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
8000592c:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80005930:	80007537          	lui	a0,0x80007
80005934:	c4450513          	addi	a0,a0,-956 # 80006c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c45>
80005938:	40a98533          	sub	a0,s3,a0
8000593c:	b6db75b7          	lui	a1,0xb6db7
80005940:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
80005944:	40255513          	srai	a0,a0,0x2
80005948:	f4dfa0ef          	jal	ra,80000894 <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
8000594c:	fffffa37          	lui	s4,0xfffff
		block->id.block = block_num;
80005950:	00001ab7          	lui	s5,0x1
		block->id.pool = pool_id(p);
80005954:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
80005958:	ff500b93          	li	s7,-11
			ret = -ENOMEM;
8000595c:	ff400c93          	li	s9,-12
		block->id.level = level_num;
80005960:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80005964:	fffa8a93          	addi	s5,s5,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005968:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
8000596c:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80005970:	00048713          	mv	a4,s1
80005974:	00c10693          	addi	a3,sp,12
80005978:	00810613          	addi	a2,sp,8
8000597c:	000b0593          	mv	a1,s6
80005980:	00098513          	mv	a0,s3
80005984:	ba1fb0ef          	jal	ra,80001524 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80005988:	03751263          	bne	a0,s7,800059ac <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
8000598c:	00048713          	mv	a4,s1
80005990:	00c10693          	addi	a3,sp,12
80005994:	00810613          	addi	a2,sp,8
80005998:	000b0593          	mv	a1,s6
8000599c:	00098513          	mv	a0,s3
800059a0:	b85fb0ef          	jal	ra,80001524 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
800059a4:	01751463          	bne	a0,s7,800059ac <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
800059a8:	ff400513          	li	a0,-12
		block->id.level = level_num;
800059ac:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
800059b0:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
800059b4:	00f7f793          	andi	a5,a5,15
800059b8:	00879713          	slli	a4,a5,0x8
800059bc:	0044a783          	lw	a5,4(s1)
800059c0:	0147f7b3          	and	a5,a5,s4
800059c4:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
800059c8:	00c12703          	lw	a4,12(sp)
800059cc:	0157f7b3          	and	a5,a5,s5
800059d0:	00c71713          	slli	a4,a4,0xc
800059d4:	00e7e7b3          	or	a5,a5,a4
800059d8:	00f4a223          	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
800059dc:	02050c63          	beqz	a0,80005a14 <k_mem_pool_alloc+0x140>
800059e0:	02040a63          	beqz	s0,80005a14 <k_mem_pool_alloc+0x140>
800059e4:	03951863          	bne	a0,s9,80005a14 <k_mem_pool_alloc+0x140>
800059e8:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
800059ec:	00040613          	mv	a2,s0
800059f0:	000d8593          	mv	a1,s11
800059f4:	00857513          	andi	a0,a0,8
800059f8:	d28fe0ef          	jal	ra,80003f20 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
800059fc:	fff00793          	li	a5,-1
80005a00:	f6f408e3          	beq	s0,a5,80005970 <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
80005a04:	d79ff0ef          	jal	ra,8000577c <z_tick_get>
80005a08:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
80005a0c:	f60452e3          	bgez	s0,80005970 <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
80005a10:	ff500513          	li	a0,-11
}
80005a14:	04c12083          	lw	ra,76(sp)
80005a18:	04812403          	lw	s0,72(sp)
80005a1c:	04412483          	lw	s1,68(sp)
80005a20:	04012903          	lw	s2,64(sp)
80005a24:	03c12983          	lw	s3,60(sp)
80005a28:	03812a03          	lw	s4,56(sp)
80005a2c:	03412a83          	lw	s5,52(sp)
80005a30:	03012b03          	lw	s6,48(sp)
80005a34:	02c12b83          	lw	s7,44(sp)
80005a38:	02812c03          	lw	s8,40(sp)
80005a3c:	02412c83          	lw	s9,36(sp)
80005a40:	02012d03          	lw	s10,32(sp)
80005a44:	01c12d83          	lw	s11,28(sp)
80005a48:	05010113          	addi	sp,sp,80
80005a4c:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80005a50:	80007937          	lui	s2,0x80007
80005a54:	800075b7          	lui	a1,0x80007
80005a58:	80006537          	lui	a0,0x80006
80005a5c:	b3058593          	addi	a1,a1,-1232 # 80006b30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b31>
80005a60:	03900693          	li	a3,57
80005a64:	b1c90613          	addi	a2,s2,-1252 # 80006b1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b1d>
80005a68:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005a6c:	f00fc0ef          	jal	ra,8000216c <printk>
80005a70:	80006537          	lui	a0,0x80006
80005a74:	60050513          	addi	a0,a0,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
80005a78:	ef4fc0ef          	jal	ra,8000216c <printk>
80005a7c:	03900593          	li	a1,57
80005a80:	b1c90513          	addi	a0,s2,-1252
80005a84:	f24fc0ef          	jal	ra,800021a8 <assert_post_action>
	if (timeout > 0) {
80005a88:	ea8052e3          	blez	s0,8000592c <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80005a8c:	cf1ff0ef          	jal	ra,8000577c <z_tick_get>
80005a90:	00050913          	mv	s2,a0
80005a94:	00a00593          	li	a1,10
80005a98:	00940513          	addi	a0,s0,9
80005a9c:	e1dfa0ef          	jal	ra,800008b8 <__divsi3>
80005aa0:	01250933          	add	s2,a0,s2
80005aa4:	e8dff06f          	j	80005930 <k_mem_pool_alloc+0x5c>

80005aa8 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005aa8:	00054783          	lbu	a5,0(a0)
{
80005aac:	fe010113          	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005ab0:	00052603          	lw	a2,0(a0)
{
80005ab4:	00812c23          	sw	s0,24(sp)
80005ab8:	00379413          	slli	s0,a5,0x3
80005abc:	01212823          	sw	s2,16(sp)
80005ac0:	40f40433          	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005ac4:	80007937          	lui	s2,0x80007
80005ac8:	00241413          	slli	s0,s0,0x2
80005acc:	00865593          	srli	a1,a2,0x8
80005ad0:	c4490513          	addi	a0,s2,-956 # 80006c44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c45>
80005ad4:	00c65613          	srli	a2,a2,0xc
80005ad8:	00f5f593          	andi	a1,a1,15
80005adc:	00850533          	add	a0,a0,s0
{
80005ae0:	00112e23          	sw	ra,28(sp)
80005ae4:	00912a23          	sw	s1,20(sp)
80005ae8:	01312623          	sw	s3,12(sp)
80005aec:	01412423          	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80005af0:	d15fb0ef          	jal	ra,80001804 <z_sys_mem_pool_block_free>
80005af4:	00800593          	li	a1,8
80005af8:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005afc:	800074b7          	lui	s1,0x80007
80005b00:	cfc48513          	addi	a0,s1,-772 # 80006cfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cfd>
	key = (mstatus & SOC_MSTATUS_IEN);
80005b04:	0085f993          	andi	s3,a1,8
80005b08:	fc9fe0ef          	jal	ra,80004ad0 <z_spin_lock_valid>
80005b0c:	c4490913          	addi	s2,s2,-956
80005b10:	02051e63          	bnez	a0,80005b4c <k_mem_pool_free_id+0xa4>
80005b14:	80006a37          	lui	s4,0x80006
80005b18:	800065b7          	lui	a1,0x80006
80005b1c:	80006537          	lui	a0,0x80006
80005b20:	66058593          	addi	a1,a1,1632 # 80006660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006661>
80005b24:	04e00693          	li	a3,78
80005b28:	648a0613          	addi	a2,s4,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80005b2c:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005b30:	e3cfc0ef          	jal	ra,8000216c <printk>
80005b34:	80006537          	lui	a0,0x80006
80005b38:	67850513          	addi	a0,a0,1656 # 80006678 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006679>
80005b3c:	e30fc0ef          	jal	ra,8000216c <printk>
80005b40:	04e00593          	li	a1,78
80005b44:	648a0513          	addi	a0,s4,1608
80005b48:	e60fc0ef          	jal	ra,800021a8 <assert_post_action>
	z_spin_lock_set_owner(l);
80005b4c:	cfc48513          	addi	a0,s1,-772
80005b50:	fd9fe0ef          	jal	ra,80004b28 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80005b54:	01440513          	addi	a0,s0,20
80005b58:	00a90533          	add	a0,s2,a0
80005b5c:	e34fe0ef          	jal	ra,80004190 <z_unpend_all>

	if (need_sched != 0) {
80005b60:	02050663          	beqz	a0,80005b8c <k_mem_pool_free_id+0xe4>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
80005b64:	01812403          	lw	s0,24(sp)
80005b68:	01c12083          	lw	ra,28(sp)
80005b6c:	01012903          	lw	s2,16(sp)
80005b70:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80005b74:	00098593          	mv	a1,s3
80005b78:	cfc48513          	addi	a0,s1,-772
}
80005b7c:	00c12983          	lw	s3,12(sp)
80005b80:	01412483          	lw	s1,20(sp)
80005b84:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80005b88:	e04fd06f          	j	8000318c <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005b8c:	cfc48513          	addi	a0,s1,-772
80005b90:	f69fe0ef          	jal	ra,80004af8 <z_spin_unlock_valid>
80005b94:	02051e63          	bnez	a0,80005bd0 <k_mem_pool_free_id+0x128>
80005b98:	80006437          	lui	s0,0x80006
80005b9c:	800065b7          	lui	a1,0x80006
80005ba0:	80006537          	lui	a0,0x80006
80005ba4:	69058593          	addi	a1,a1,1680 # 80006690 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006691>
80005ba8:	06100693          	li	a3,97
80005bac:	64840613          	addi	a2,s0,1608 # 80006648 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006649>
80005bb0:	57c50513          	addi	a0,a0,1404 # 8000657c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000657d>
80005bb4:	db8fc0ef          	jal	ra,8000216c <printk>
80005bb8:	80006537          	lui	a0,0x80006
80005bbc:	6a850513          	addi	a0,a0,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80005bc0:	dacfc0ef          	jal	ra,8000216c <printk>
80005bc4:	06100593          	li	a1,97
80005bc8:	64840513          	addi	a0,s0,1608
80005bcc:	ddcfc0ef          	jal	ra,800021a8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005bd0:	3009a5f3          	csrrs	a1,mstatus,s3
}
80005bd4:	01c12083          	lw	ra,28(sp)
80005bd8:	01812403          	lw	s0,24(sp)
80005bdc:	01412483          	lw	s1,20(sp)
80005be0:	01012903          	lw	s2,16(sp)
80005be4:	00c12983          	lw	s3,12(sp)
80005be8:	00812a03          	lw	s4,8(sp)
80005bec:	02010113          	addi	sp,sp,32
80005bf0:	00008067          	ret

80005bf4 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
80005bf4:	00458613          	addi	a2,a1,4
80005bf8:	00b67e63          	bgeu	a2,a1,80005c14 <k_mem_pool_malloc+0x20>
				   &size)) {
		return NULL;
80005bfc:	00000513          	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
80005c00:	00008067          	ret
		return NULL;
80005c04:	00000513          	li	a0,0
}
80005c08:	01c12083          	lw	ra,28(sp)
80005c0c:	02010113          	addi	sp,sp,32
80005c10:	00008067          	ret
{
80005c14:	fe010113          	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80005c18:	00000693          	li	a3,0
80005c1c:	00810593          	addi	a1,sp,8
{
80005c20:	00112e23          	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80005c24:	cb1ff0ef          	jal	ra,800058d4 <k_mem_pool_alloc>
80005c28:	fc051ee3          	bnez	a0,80005c04 <k_mem_pool_malloc+0x10>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
80005c2c:	00812503          	lw	a0,8(sp)
80005c30:	00400613          	li	a2,4
80005c34:	00c10593          	addi	a1,sp,12
80005c38:	b09fc0ef          	jal	ra,80002740 <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80005c3c:	00812503          	lw	a0,8(sp)
80005c40:	00450513          	addi	a0,a0,4
80005c44:	fc5ff06f          	j	80005c08 <k_mem_pool_malloc+0x14>

80005c48 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
80005c48:	00050663          	beqz	a0,80005c54 <k_free+0xc>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
80005c4c:	ffc50513          	addi	a0,a0,-4
80005c50:	e59ff06f          	j	80005aa8 <k_mem_pool_free_id>
	}
}
80005c54:	00008067          	ret

80005c58 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
80005c58:	800077b7          	lui	a5,0x80007
80005c5c:	0147a783          	lw	a5,20(a5) # 80007014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007015>
{
80005c60:	00050593          	mv	a1,a0
	if (_current->resource_pool != NULL) {
80005c64:	0687a503          	lw	a0,104(a5)
80005c68:	00050463          	beqz	a0,80005c70 <z_thread_malloc+0x18>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80005c6c:	f89ff06f          	j	80005bf4 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
80005c70:	00000513          	li	a0,0
80005c74:	00008067          	ret

80005c78 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80005c78:	00008067          	ret
