# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['simple_ddl_parser']

package_data = \
{'': ['*']}

install_requires = \
['ply>=3.11,<4.0']

setup_kwargs = {
    'name': 'simple-ddl-parser',
    'version': '0.2.1a1',
    'description': 'Simple DDL Parser to parse SQL & HQL ddl files to json/python dict with full information about columns: types, defaults, primary keys, etc.',
    'long_description': '\nSimple DDL Parser\n-----------------\n\n\n.. image:: https://img.shields.io/pypi/v/simple-ddl-parser\n   :target: https://img.shields.io/pypi/v/simple-ddl-parser\n   :alt: badge1\n \n.. image:: https://img.shields.io/pypi/l/simple-ddl-parser\n   :target: https://img.shields.io/pypi/l/simple-ddl-parser\n   :alt: badge2\n \n.. image:: https://img.shields.io/pypi/pyversions/simple-ddl-parser\n   :target: https://img.shields.io/pypi/pyversions/simple-ddl-parser\n   :alt: badge3\n \n\nParser tested on DDL for PostgreSQL & Hive.\n\nIf you have samples that cause an error - please open the issue, I will be glad to fix it.\n\nThis parser take as input SQL DDL statements or files, for example like this:\n\n.. code-block:: sql\n\n\n       create table prod.super_table\n   (\n       data_sync_id bigint not null,\n       sync_count bigint not null,\n       sync_mark timestamp  not  null,\n       sync_start timestamp  not null,\n       sync_end timestamp  not null,\n       message varchar(2000) null,\n       primary key (data_sync_id, sync_start)\n   );\n\nAnd produce output like this (information about table name, schema, columns, types and properties):\n\n.. code-block:: python\n\n\n       [{\n       \'columns\': [\n           {\'name\': \'data_sync_id\', \'type\': \'bigint\', \'mode\': False, \'size\': None, \'default\': None}, \n           {\'name\': \'sync_count\', \'type\': \'bigint\', \'mode\': False, \'size\': None, \'default\': None}, \n           {\'name\': \'sync_mark\', \'type\': \'timestamp\', \'mode\': False, \'size\': None, \'default\': None}, \n           {\'name\': \'sync_start\', \'type\': \'timestamp\', \'mode\': False, \'size\': None, \'default\': None}, \n           {\'name\': \'sync_end\', \'type\': \'timestamp\', \'mode\': False, \'size\': None, \'default\': None}, \n           {\'name\': \'message\', \'type\': \'varchar\', \'mode\': False, \'size\': 2000, \'default\': None}], \n       \'table_name\': \'super_table\', \'schema\': \'prod\', \n       \'primary_key\': [\'data_sync_id\', \'sync_start\']\n       }]\n\nOr one more example\n\n.. code-block:: sql\n\n\n   CREATE TABLE "paths" (\n     "id" int PRIMARY KEY,\n     "title" varchar NOT NULL,\n     "description" varchar(160),\n     "created_at" timestamp,\n     "updated_at" timestamp\n   );\n\nand result\n\n.. code-block:: python\n\n           [{\n           \'columns\': [\n               {\'name\': \'id\', \'type\': \'int\', \'nullable\': False, \'size\': None, \'default\': None}, \n               {\'name\': \'title\', \'type\': \'varchar\', \'nullable\': False, \'size\': None, \'default\': None}, \n               {\'name\': \'description\', \'type\': \'varchar\', \'nullable\': False, \'size\': 160, \'default\': None}, \n               {\'name\': \'created_at\', \'type\': \'timestamp\', \'nullable\': False, \'size\': None, \'default\': None}, \n               {\'name\': \'updated_at\', \'type\': \'timestamp\', \'nullable\': False, \'size\': None, \'default\': None}], \n           \'primary_key\': [\'id\'], \n           \'table_name\': \'paths\', \'schema\': \'\'\n           }]\n\nIf you pass file or text block with more when 1 CREATE TABLE statement when result will be list of such dicts. For example:\n\nInput:\n\n.. code-block:: sql\n\n\n   CREATE TABLE "countries" (\n     "id" int PRIMARY KEY,\n     "code" varchar(4) NOT NULL,\n     "name" varchar NOT NULL\n   );\n\n   CREATE TABLE "path_owners" (\n     "user_id" int,\n     "path_id" int,\n     "type" int DEFAULT 1\n   );\n\nOutput:\n\n.. code-block:: python\n\n\n       [\n           {\'columns\': [\n               {\'name\': \'id\', \'type\': \'int\', \'size\': None, \'nullable\': False, \'default\': None}, \n               {\'name\': \'code\', \'type\': \'varchar\', \'size\': 4, \'nullable\': False, \'default\': None}, \n               {\'name\': \'name\', \'type\': \'varchar\', \'size\': None, \'nullable\': False, \'default\': None}], \n            \'primary_key\': [\'id\'], \n            \'table_name\': \'countries\', \n            \'schema\': None}, \n           {\'columns\': [\n               {\'name\': \'user_id\', \'type\': \'int\', \'size\': None, \'nullable\': False, \'default\': None}, \n               {\'name\': \'path_id\', \'type\': \'int\', \'size\': None, \'nullable\': False, \'default\': None}, \n               {\'name\': \'type\', \'type\': \'int\', \'size\': None, \'nullable\': False, \'default\': 1}], \n            \'primary_key\': [], \n            \'table_name\': \'path_owners\', \n            \'schema\': None}\n       ]\n\nHow to use\n----------\n\nFrom python code\n^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n       from simple_ddl_parser import DDLParser\n\n\n       parse_results = DDLParser("""create table dev.data_sync_history(\n           data_sync_id bigint not null,\n           sync_count bigint not null,\n           sync_mark timestamp  not  null,\n           sync_start timestamp  not null,\n           sync_end timestamp  not null,\n           message varchar(2000) null,\n           primary key (data_sync_id, sync_start)\n       ); """).run()\n\n       print(parse_results)\n\nTo parse from file\n^^^^^^^^^^^^^^^^^^\n\n.. code-block:: python\n\n\n       from simple_ddl_parser import parse_from_file\n\n       result = parse_from_file(\'tests/test_one_statement.sql\')\n       print(result)\n\nMore examples & tests\n^^^^^^^^^^^^^^^^^^^^^\n\nYou can find in **tests/functional** folder.\n\nDump result in json\n^^^^^^^^^^^^^^^^^^^\n\nTo dump result in json use argument .run(dump=True)\n\nYou also can provide a path where you want to have a dumps with schema with argument\n\nTODO in next Releases\n^^^^^^^^^^^^^^^^^^^^^\n\n\n#. Support for references (Foreigein key) in column defenition\n#. Support for separate ALTER TABLE statements for Foreigein keys like\n\n.. code-block:: sql\n\n\n       ALTER TABLE "material_attachments" ADD FOREIGN KEY ("material_id") REFERENCES "materials" ("id");\n\n\n#. Support for parse CREATE INDEX statements\n#. Add command line\n#. Support ARRAYs\n\nHistorical context\n^^^^^^^^^^^^^^^^^^\n\nThis library is an extracted parser code from https://github.com/xnuinside/fakeme (Library for fake relation data generation, that I used in several work projects, but did not have time to make from it normal open source library)\n\nFor one of the work projects I needed to convert SQL ddl to Python ORM models in auto way and I tried to use https://github.com/andialbrecht/sqlparse but it works not well enough with ddl for my case (for example, if in ddl used lower case - nothing works, primary keys inside ddl are mapped as column name not reserved word and etc.).\nSo I remembered about Parser in Fakeme and just extracted it & improved. \n\nHow to contribute\n-----------------\n\nPlease describe issue that you want to solve and open the PR, I will review it as soon as possible.\n\nAny questions? Ping me in Telegram: https://t.me/xnuinside \n',
    'author': 'Iuliia Volkova',
    'author_email': 'xnuinside@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/xnuinside/simple-ddl-parser',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
