# coding: utf-8


"""
IGNORE:
    Nutanix Prism Versioned APIs

    Task Management, Category Associations, Prism Central DR, Alerts, Alert policies, Events and Audits  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_prism_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.config.EmailConfigurationRule import EmailConfigurationRule  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.config.EmailTemplate import EmailTemplate  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.config.RemoteTunnelDetails import RemoteTunnelDetails  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class EmailConfiguration(ExternalizableAbstractModel):
    """EmailConfiguration - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'default_nutanix_email': 'str',
        'enable': 'bool',
        'enable_default_nutanix_email': 'bool',
        'enable_email_digest': 'bool',
        'skip_empty_alert_email_digest': 'bool',
        'email_config_rules': 'list[prism.v4.config.EmailConfigurationRule]',
        'email_contact_list': 'list[str]',
        'email_template': 'prism.v4.config.EmailTemplate',
        'tunnel_details': 'prism.v4.config.RemoteTunnelDetails',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'default_nutanix_email': 'defaultNutanixEmail',
        'enable': 'enable',
        'enable_default_nutanix_email': 'enableDefaultNutanixEmail',
        'enable_email_digest': 'enableEmailDigest',
        'skip_empty_alert_email_digest': 'skipEmptyAlertEmailDigest',
        'email_config_rules': 'emailConfigRules',
        'email_contact_list': 'emailContactList',
        'email_template': 'emailTemplate',
        'tunnel_details': 'tunnelDetails',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, default_nutanix_email=None, enable=False, enable_default_nutanix_email=False, enable_email_digest=False, skip_empty_alert_email_digest=False, email_config_rules=None, email_contact_list=None, email_template=None, tunnel_details=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """EmailConfiguration - a model defined in Swagger
            
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__default_nutanix_email = None
        self.__enable = None
        self.__enable_default_nutanix_email = None
        self.__enable_email_digest = None
        self.__skip_empty_alert_email_digest = None
        self.__email_config_rules = None
        self.__email_contact_list = None
        self.__email_template = None
        self.__tunnel_details = None
        self.discriminator = None
        if default_nutanix_email is not None:
            self.__default_nutanix_email = default_nutanix_email
        if enable is not None:
            self.__enable = enable
        if enable_default_nutanix_email is not None:
            self.__enable_default_nutanix_email = enable_default_nutanix_email
        if enable_email_digest is not None:
            self.__enable_email_digest = enable_email_digest
        if skip_empty_alert_email_digest is not None:
            self.__skip_empty_alert_email_digest = skip_empty_alert_email_digest
        if email_config_rules is not None:
            self.__email_config_rules = email_config_rules
        if email_contact_list is not None:
            self.__email_contact_list = email_contact_list
        if email_template is not None:
            self.__email_template = email_template
        if tunnel_details is not None:
            self.__tunnel_details = tunnel_details

    def _initialize_object_type(self):
        return 'prism.v4.config.EmailConfiguration'

    def _initialize_fq_object_type(self):
        return 'prism.v4.r0.a1.config.EmailConfiguration'


    @property
    def default_nutanix_email(self):
        """`{ str }`
            \nThe default Nutanix email ID to which alert emails would be sent.
        """ # noqa: E501
        return self.__default_nutanix_email

    @default_nutanix_email.setter
    def default_nutanix_email(self, default_nutanix_email):
        if default_nutanix_email is not None and not re.search('^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$', default_nutanix_email):  # noqa: E501
            raise ValueError(r"Invalid value for `default_nutanix_email`, must be a follow pattern or equal to `/^([a-zA-Z0-9_\\-\\.]+)@([a-zA-Z0-9_\\-\\.]+)\\.([a-zA-Z]{2,5})$/`")  # noqa: E501

        self.__default_nutanix_email = default_nutanix_email

    @property
    def enable(self):
        """`{ bool }`
            \nIndicates whether alert emails should be enabled or not.
        """ # noqa: E501
        return self.__enable

    @enable.setter
    def enable(self, enable):

        self.__enable = enable

    @property
    def enable_default_nutanix_email(self):
        """`{ bool }`
            \nIndicates whether alert emails should be enabled or not on default Nutanix email ID.
        """ # noqa: E501
        return self.__enable_default_nutanix_email

    @enable_default_nutanix_email.setter
    def enable_default_nutanix_email(self, enable_default_nutanix_email):

        self.__enable_default_nutanix_email = enable_default_nutanix_email

    @property
    def enable_email_digest(self):
        """`{ bool }`
            \nIndicates whether alert email digest should be enabled or not.
        """ # noqa: E501
        return self.__enable_email_digest

    @enable_email_digest.setter
    def enable_email_digest(self, enable_email_digest):

        self.__enable_email_digest = enable_email_digest

    @property
    def skip_empty_alert_email_digest(self):
        """`{ bool }`
            \nSend alert email digest only if there are one or more alerts.
        """ # noqa: E501
        return self.__skip_empty_alert_email_digest

    @skip_empty_alert_email_digest.setter
    def skip_empty_alert_email_digest(self, skip_empty_alert_email_digest):

        self.__skip_empty_alert_email_digest = skip_empty_alert_email_digest

    @property
    def email_config_rules(self):
        """`{ list[prism.v4.config.EmailConfigurationRule] }`
            \nRules for email configuration.
        """ # noqa: E501
        return self.__email_config_rules

    @email_config_rules.setter
    def email_config_rules(self, email_config_rules):

        self.__email_config_rules = email_config_rules

    @property
    def email_contact_list(self):
        """`{ list[str] }`
            \nList of email contacts.
        """ # noqa: E501
        return self.__email_contact_list

    @email_contact_list.setter
    def email_contact_list(self, email_contact_list):

        self.__email_contact_list = email_contact_list

    @property
    def email_template(self):
        """`{ prism.v4.config.EmailTemplate }`
            
        """ # noqa: E501
        return self.__email_template

    @email_template.setter
    def email_template(self, email_template):

        self.__email_template = email_template

    @property
    def tunnel_details(self):
        """`{ prism.v4.config.RemoteTunnelDetails }`
            
        """ # noqa: E501
        return self.__tunnel_details

    @tunnel_details.setter
    def tunnel_details(self, tunnel_details):

        self.__tunnel_details = tunnel_details

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EmailConfiguration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EmailConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

