# coding: utf-8


"""
IGNORE:
    Nutanix Prism Versioned APIs

    Task Management, Category Associations, Prism Central DR, Alerts, Alert policies, Events and Audits  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_prism_py_client.Ntnx.common.v1.config.KVPair import KVPair  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.config.EntityReference import EntityReference  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.config.OwnerReference import OwnerReference  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.config.TaskReferenceInternal import TaskReferenceInternal  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.config.TaskStatus import TaskStatus  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.config.TaskStep import TaskStep  # noqa: F401,E501
from ntnx_prism_py_client.Ntnx.prism.v4.error.AppMessage import AppMessage  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class Task(object):
    """Task - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'ext_id': 'str',
        'operation': 'str',
        'operation_description': 'str',
        'parent_task': 'prism.v4.config.TaskReferenceInternal',
        'created_time': 'datetime',
        'started_time': 'datetime',
        'completed_time': 'datetime',
        'status': 'prism.v4.config.TaskStatus',
        'progress_percentage': 'int',
        'entities_affected': 'list[prism.v4.config.EntityReference]',
        'sub_tasks': 'list[prism.v4.config.TaskReferenceInternal]',
        'sub_steps': 'list[prism.v4.config.TaskStep]',
        'is_cancelable': 'bool',
        'owned_by': 'prism.v4.config.OwnerReference',
        'completion_details': 'list[common.v1.config.KVPair]',
        'error_messages': 'list[prism.v4.error.AppMessage]',
        'legacy_error_message': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'ext_id': 'extId',
        'operation': 'operation',
        'operation_description': 'operationDescription',
        'parent_task': 'parentTask',
        'created_time': 'createdTime',
        'started_time': 'startedTime',
        'completed_time': 'completedTime',
        'status': 'status',
        'progress_percentage': 'progressPercentage',
        'entities_affected': 'entitiesAffected',
        'sub_tasks': 'subTasks',
        'sub_steps': 'subSteps',
        'is_cancelable': 'isCancelable',
        'owned_by': 'ownedBy',
        'completion_details': 'completionDetails',
        'error_messages': 'errorMessages',
        'legacy_error_message': 'legacyErrorMessage',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, ext_id=None, operation=None, operation_description=None, parent_task=None, created_time=None, started_time=None, completed_time=None, status=None, progress_percentage=None, entities_affected=None, sub_tasks=None, sub_steps=None, is_cancelable=None, owned_by=None, completion_details=None, error_messages=None, legacy_error_message=None, *args, **kwargs):  # noqa: E501
        """Task - a model defined in Swagger
            \nThe task object tracking an async operation.
        """
        self.__ext_id = None
        self.__operation = None
        self.__operation_description = None
        self.__parent_task = None
        self.__created_time = None
        self.__started_time = None
        self.__completed_time = None
        self.__status = None
        self.__progress_percentage = None
        self.__entities_affected = None
        self.__sub_tasks = None
        self.__sub_steps = None
        self.__is_cancelable = None
        self.__owned_by = None
        self.__completion_details = None
        self.__error_messages = None
        self.__legacy_error_message = None
        self.discriminator = None
        if ext_id is not None:
            self.__ext_id = ext_id
        if operation is not None:
            self.__operation = operation
        if operation_description is not None:
            self.__operation_description = operation_description
        if parent_task is not None:
            self.__parent_task = parent_task
        if created_time is not None:
            self.__created_time = created_time
        if started_time is not None:
            self.__started_time = started_time
        if completed_time is not None:
            self.__completed_time = completed_time
        if status is not None:
            self.__status = status
        if progress_percentage is not None:
            self.__progress_percentage = progress_percentage
        if entities_affected is not None:
            self.__entities_affected = entities_affected
        if sub_tasks is not None:
            self.__sub_tasks = sub_tasks
        if sub_steps is not None:
            self.__sub_steps = sub_steps
        if is_cancelable is not None:
            self.__is_cancelable = is_cancelable
        if owned_by is not None:
            self.__owned_by = owned_by
        if completion_details is not None:
            self.__completion_details = completion_details
        if error_messages is not None:
            self.__error_messages = error_messages
        if legacy_error_message is not None:
            self.__legacy_error_message = legacy_error_message
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'prism.v4.config.Task'

    def _initialize_fq_object_type(self):
        return 'prism.v4.r0.a1.config.Task'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def ext_id(self):
        """`{ str }`
            \nGlobally unique identifier of a task.
        """ # noqa: E501
        return self.__ext_id

    @ext_id.setter
    def ext_id(self, ext_id):
        if ext_id is not None and not re.search('^[a-zA-Z0-9\/+]*={0,2}:[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}', ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `ext_id`, must be a follow pattern or equal to `/^[a-zA-Z0-9\/+]*={0,2}:[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/`")  # noqa: E501

        self.__ext_id = ext_id

    @property
    def operation(self):
        """`{ str }`
            \nOperation being tracked by the task.
        """ # noqa: E501
        return self.__operation

    @operation.setter
    def operation(self, operation):

        self.__operation = operation

    @property
    def operation_description(self):
        """`{ str }`
            \nDescription of the operation being tracked by the task.
        """ # noqa: E501
        return self.__operation_description

    @operation_description.setter
    def operation_description(self, operation_description):

        self.__operation_description = operation_description

    @property
    def parent_task(self):
        """`{ prism.v4.config.TaskReferenceInternal }`
            
        """ # noqa: E501
        return self.__parent_task

    @parent_task.setter
    def parent_task(self, parent_task):

        self.__parent_task = parent_task

    @property
    def created_time(self):
        """`{ datetime }`
            \nUTC date and time in RFC-3339 format when task was created.
        """ # noqa: E501
        return self.__created_time

    @created_time.setter
    def created_time(self, created_time):

        self.__created_time = created_time

    @property
    def started_time(self):
        """`{ datetime }`
            \nUTC date and time in RFC-3339 format when task was started.
        """ # noqa: E501
        return self.__started_time

    @started_time.setter
    def started_time(self, started_time):

        self.__started_time = started_time

    @property
    def completed_time(self):
        """`{ datetime }`
            \nUTC date and time in RFC-3339 format when task was completed.
        """ # noqa: E501
        return self.__completed_time

    @completed_time.setter
    def completed_time(self, completed_time):

        self.__completed_time = completed_time

    @property
    def status(self):
        """`{ prism.v4.config.TaskStatus }`
            
        """ # noqa: E501
        return self.__status

    @status.setter
    def status(self, status):

        self.__status = status

    @property
    def progress_percentage(self):
        """`{ int }`
            \nTask progress expressed as a percentage.
        """ # noqa: E501
        return self.__progress_percentage

    @progress_percentage.setter
    def progress_percentage(self, progress_percentage):
        if progress_percentage is not None and progress_percentage > 100:  # noqa: E501
            raise ValueError("Invalid value for `progress_percentage`, must be a value less than or equal to `100`")  # noqa: E501
        if progress_percentage is not None and progress_percentage < 0:  # noqa: E501
            raise ValueError("Invalid value for `progress_percentage`, must be a value greater than or equal to `0`")  # noqa: E501

        self.__progress_percentage = progress_percentage

    @property
    def entities_affected(self):
        """`{ list[prism.v4.config.EntityReference] }`
            \nReference to entities associated with the task.
        """ # noqa: E501
        return self.__entities_affected

    @entities_affected.setter
    def entities_affected(self, entities_affected):

        self.__entities_affected = entities_affected

    @property
    def sub_tasks(self):
        """`{ list[prism.v4.config.TaskReferenceInternal] }`
            \nReference to tasks spawned as children of current task.
        """ # noqa: E501
        return self.__sub_tasks

    @sub_tasks.setter
    def sub_tasks(self, sub_tasks):

        self.__sub_tasks = sub_tasks

    @property
    def sub_steps(self):
        """`{ list[prism.v4.config.TaskStep] }`
            \nList of steps completed as part of task.
        """ # noqa: E501
        return self.__sub_steps

    @sub_steps.setter
    def sub_steps(self, sub_steps):

        self.__sub_steps = sub_steps

    @property
    def is_cancelable(self):
        """`{ bool }`
            \nSignifies if task can be cancelled.
        """ # noqa: E501
        return self.__is_cancelable

    @is_cancelable.setter
    def is_cancelable(self, is_cancelable):

        self.__is_cancelable = is_cancelable

    @property
    def owned_by(self):
        """`{ prism.v4.config.OwnerReference }`
            
        """ # noqa: E501
        return self.__owned_by

    @owned_by.setter
    def owned_by(self, owned_by):

        self.__owned_by = owned_by

    @property
    def completion_details(self):
        """`{ list[common.v1.config.KVPair] }`
            \nAdditional details post operation completion to guide further actions.
        """ # noqa: E501
        return self.__completion_details

    @completion_details.setter
    def completion_details(self, completion_details):

        self.__completion_details = completion_details

    @property
    def error_messages(self):
        """`{ list[prism.v4.error.AppMessage] }`
            \nError details in case of task failure.
        """ # noqa: E501
        return self.__error_messages

    @error_messages.setter
    def error_messages(self, error_messages):

        self.__error_messages = error_messages

    @property
    def legacy_error_message(self):
        """`{ str }`
            \nProvides the error in the absence of well defined error message for tasks created via legacy APIs.
        """ # noqa: E501
        return self.__legacy_error_message

    @legacy_error_message.setter
    def legacy_error_message(self, legacy_error_message):

        self.__legacy_error_message = legacy_error_message

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Task, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Task):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

