# coding: utf-8


"""
IGNORE:
    Nutanix Prism Versioned APIs

    Task Management, Category Associations, Prism Central DR, Alerts, Alert policies, Events and Audits  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_prism_py_client.api_client import ApiClient


class SystemDefinedPoliciesApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_sda_policies(self, **kwargs):  # noqa: E501
        """Get a list of all system defined alert policies.
        Get a list of all system defined alert policies.

        >>> response = api.get_sda_policies((optional) globalConfig, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sda_policies(async_req=True)
        >>> result = thread.get()

        :param bool globalConfig: Indicates whether the system defined alert policies is a default one or not.
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - alertTypeId
        - title
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - alertTypeId
        - entityUid
        - modifiedTimestamp
        - title
        
        :param bool async_req:
        :return: prism.v4.policies.ListSdaPoliciesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sda_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sda_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sda_policies_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of all system defined alert policies.
        Get a list of all system defined alert policies.

        >>> response = api.get_sda_policies((optional) globalConfig, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sda_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param bool globalConfig: Indicates whether the system defined alert policies is a default one or not.
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource.  Any number out of this range will be set to its nearest bound.  In other words, a page number of less than 0 would be set to 0 and a page number greater than the total available pages would be set to the last page.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will be set to the default maximum number of records, which is 100.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - alertTypeId
        - title
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - alertTypeId
        - entityUid
        - modifiedTimestamp
        - title
        
        :param bool async_req:
        :return: prism.v4.policies.ListSdaPoliciesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['globalConfig', '_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sda_policies" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'globalConfig' in params:
            query_params.append(('globalConfig', params['globalConfig']))  # noqa: E501
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/prism/v4.0.a1/policies/system-defined', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='prism.v4.policies.ListSdaPoliciesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sda_policy_by_id(self, entityUid, **kwargs):  # noqa: E501
        """Get a system defined alert policy based on policy ID.
        Get a system defined alert policy based on policy ID.

        >>> response = api.get_sda_policy_by_id(entityUid, (optional) globalConfig)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sda_policy_by_id(entityUid, async_req=True)
        >>> result = thread.get()

        :param str entityUid: Entity UID. (required)
        :param bool globalConfig: Indicates whether the system defined alert policies is a default one or not.
        :param bool async_req:
        :return: prism.v4.policies.GetSdaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sda_policy_by_id_with_http_info(entityUid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sda_policy_by_id_with_http_info(entityUid, **kwargs)  # noqa: E501
            return data

    def get_sda_policy_by_id_with_http_info(self, entityUid, **kwargs):  # noqa: E501
        """Get a system defined alert policy based on policy ID.
        Get a system defined alert policy based on policy ID.

        >>> response = api.get_sda_policy_by_id(entityUid, (optional) globalConfig)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sda_policy_by_id_with_http_info(entityUid, async_req=True)
        >>> result = thread.get()

        :param str entityUid: Entity UID. (required)
        :param bool globalConfig: Indicates whether the system defined alert policies is a default one or not.
        :param bool async_req:
        :return: prism.v4.policies.GetSdaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entityUid', 'globalConfig']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sda_policy_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entityUid' is set
        if ('entityUid' not in params or
                params['entityUid'] is None):
            raise ValueError("Missing the required parameter `entityUid` when calling `get_sda_policy_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entityUid' in params:
            path_params['entityUid'] = params['entityUid']  # noqa: E501

        query_params = []
        if 'globalConfig' in params:
            query_params.append(('globalConfig', params['globalConfig']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/prism/v4.0.a1/policies/system-defined/{entityUid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='prism.v4.policies.GetSdaPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sda_policy(self, body, entityUid, **kwargs):  # noqa: E501
        """Update a system defined alert policy.
        Update a system defined alert policy.

        >>> response = api.update_sda_policy(body, entityUid)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_sda_policy(body, entityUid, async_req=True)
        >>> result = thread.get()

        :param prism.v4.policies.SystemDefined body: System defined alert policy sent for the update. (required)
        :param str entityUid: Entity UID. (required)
        :param bool async_req:
        :return: prism.v4.policies.UpdateSdaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sda_policy_with_http_info(body, entityUid, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sda_policy_with_http_info(body, entityUid, **kwargs)  # noqa: E501
            return data

    def update_sda_policy_with_http_info(self, body, entityUid, **kwargs):  # noqa: E501
        """Update a system defined alert policy.
        Update a system defined alert policy.

        >>> response = api.update_sda_policy(body, entityUid)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_sda_policy_with_http_info(body, entityUid, async_req=True)
        >>> result = thread.get()

        :param prism.v4.policies.SystemDefined body: System defined alert policy sent for the update. (required)
        :param str entityUid: Entity UID. (required)
        :param bool async_req:
        :return: prism.v4.policies.UpdateSdaPolicyApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'entityUid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sda_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_sda_policy`")  # noqa: E501
        # verify the required parameter 'entityUid' is set
        if ('entityUid' not in params or
                params['entityUid'] is None):
            raise ValueError("Missing the required parameter `entityUid` when calling `update_sda_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entityUid' in params:
            path_params['entityUid'] = params['entityUid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/prism/v4.0.a1/policies/system-defined/{entityUid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='prism.v4.policies.UpdateSdaPolicyApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
