import { IConstruct } from 'constructs';
import { SdkQuery, SdkQueryOptions } from './sdk';
import { Construct } from 'constructs';
/**
 * Represents a deploy time assertion
 */
export interface IAssertion {
    /**
     * The result of the assertion
     */
    readonly result: string;
}
/**
 * Options for DeployAssert
 */
export interface DeployAssertProps {
}
/**
 * Construct that allows for registering a list of assertions
 * that should be performed on a construct
 */
export declare class DeployAssert extends Construct {
    /**
     * Returns whether the construct is a DeployAssert construct
     */
    static isDeployAssert(x: any): x is DeployAssert;
    /**
     * Finds a DeployAssert construct in the given scope
     */
    static of(construct: IConstruct): DeployAssert;
    /** @internal */
    readonly _assertions: IAssertion[];
    constructor(scope: Construct);
    /**
     * Query AWS using JavaScript SDK V2 API calls
     */
    queryAws(options: SdkQueryOptions): SdkQuery;
    /**
     * Register an assertion that should be run as part of the
     * deployment
     */
    registerAssertion(assertion: IAssertion): void;
}
