import { Reference } from 'aws-cdk-lib';
import { IAssertion } from './deploy-assert';
import { Construct } from 'constructs';
/**
 * Options to perform an AWS JavaScript V2 API call
 */
export interface SdkQueryOptions {
    /**
     * The AWS service, i.e. S3
     */
    readonly service: string;
    /**
     * The api call to make, i.e. getBucketLifecycle
     */
    readonly api: string;
    /**
     * Any parameters to pass to the api call
     */
    readonly parameters?: any;
}
/**
 * Options for creating an SDKQuery provider
 */
export interface SdkQueryProps extends SdkQueryOptions {
}
export declare class SdkQuery extends Construct {
    private readonly sdkCallResource;
    private flattenResponse;
    constructor(scope: Construct, id: string, props: SdkQueryProps);
    /**
     * Returns the value of an attribute of the custom resource of an arbitrary
     * type. Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt`. Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getAttString` for string attributes.
     */
    getAtt(attributeName: string): Reference;
    /**
     * Returns the value of an attribute of the custom resource of type string.
     * Attributes are returned from the custom resource provider through the
     * `Data` map where the key is the attribute name.
     *
     * @param attributeName the name of the attribute
     * @returns a token for `Fn::GetAtt` encoded as a string.
     */
    getAttString(attributeName: string): string;
    /**
     * Creates an assertion custom resource that will assert that the response
     * from the SDKQuery equals the 'expected' value
     */
    assertEqual(expected: any, actualAttr?: string): IAssertion;
}
