# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['python_ms']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'python-ms',
    'version': '1.0.0',
    'description': 'A Python equivalent to the JavaScript ms package.',
    'long_description': '# Python-ms\n\nA Python equivalent to the JavaScript ms package.\n\nThis port of the original project supports some additional string-to-ms\nconversions, but otherwise the functionality is identical. This version\nalso uses integers for everything to avoid rounding errors with\nfloating-point numbers when using large values.\n\nUsing the project\'s unit tests as examples is recommended, as they cover\neverything.\n\n|              |   |\n|--------------|---|\n| Tests (main) | [![codecov](https://codecov.io/gh/Diapolo10/python-ms/branch/main/graph/badge.svg?token=zBlgCd32Aq)](https://codecov.io/gh/Diapolo10/python-ms) ![Unit tests](https://github.com/diapolo10/python-ms/workflows/Unit%20tests/badge.svg) ![Pylint](https://github.com/diapolo10/python-ms/workflows/Pylint/badge.svg) ![Flake8](https://github.com/diapolo10/python-ms/workflows/Flake8/badge.svg) |\n| Activity     | ![GitHub contributors](https://img.shields.io/github/contributors/diapolo10/python-ms) ![Last commit](https://img.shields.io/github/last-commit/diapolo10/python-ms?logo=github) ![GitHub all releases](https://img.shields.io/github/downloads/diapolo10/python-ms/total?logo=github) ![GitHub issues](https://img.shields.io/github/issues/diapolo10/python-ms) ![GitHub closed issues](https://img.shields.io/github/issues-closed/diapolo10/python-ms) ![GitHub pull requests](https://img.shields.io/github/issues-pr/diapolo10/python-ms) ![GitHub closed pull requests](https://img.shields.io/github/issues-pr-closed/diapolo10/python-ms) |\n| QA           | [![CodeFactor](https://www.codefactor.io/repository/github/diapolo10/python-ms/badge?logo=codefactor)](https://www.codefactor.io/repository/github/diapolo10/python-ms) |\n| Other        | [![License](https://img.shields.io/github/license/diapolo10/python-ms)](https://opensource.org/licenses/MIT) [![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2FDiapolo10%2Fpython-ms.svg?type=shield)](https://app.fossa.com/projects/git%2Bgithub.com%2FDiapolo10%2Fpython-ms?ref=badge_shield) [![Known Vulnerabilities](https://snyk.io/test/github/diapolo10/python-ms/badge.svg)](https://snyk.io/test/github/diapolo10/python-ms) ![Repository size](https://img.shields.io/github/repo-size/diapolo10/python-ms?logo=github) ![Code size](https://img.shields.io/github/languages/code-size/diapolo10/python-ms?logo=github) ![Lines of code](https://img.shields.io/tokei/lines/github/diapolo10/python-ms?logo=github) |\n\n## Installation\n\nThe project is available via PyPI:\n\n```sh\npip install python_ms\n```\n\n## Examples\n\n### Convert from strings\n\n```python\nimport python_ms as ms\n\nms(\'2 days\')  # 172_800_000\nms(\'1d\')      # 86_400_000\nms(\'10h\')     # 36_000_000\nms(\'2.5 hrs\') # 9_000_000\nms(\'2h\')      # 7_200_000\nms(\'1m\')      # 60_000\nms(\'5s\')      # 5_000\nms(\'1y\')      # 31_557_600_000\nms(\'100\')     # 100\nms(\'-3 days\') # -259_200_000\nms(\'-1h\')     # -3_600_000\nms(\'-200\')    # -200\n```\n\n### Convert from milliseconds\n\n```python\nimport python_ms as ms\n\nms(60_000)          # "1m"\nms(2 * 60_000)      # "2m"\nms(-3 * 60_000)     # "-3m"\nms(ms(\'10 hours\'))  # "10h"\n```\n\n### Time format written out\n\n```python\nimport python_ms as ms\n\nms(60_000, long=True)          # "1 minute"\nms(2 * 60_000, long=True)      # "2 minutes"\nms(-3 * 60_000, long=True)     # "-3 minutes"\nms(ms(\'10 hours\'), long=True)  # "10 hours"\n```\n\n## Features\n\n- Has no dependencies aside from the standard library\n- If a number is supplied to `python_ms`, a string with a unit is returned\n- If a string that contains the number is supplied, it returns it as a number (e.g.: it returns `100` for `\'100\'`)\n- If you pass a string with a number and a valid unit, the number of equivalent milliseconds is returned\n\n## Related Packages\n\n- [ms](https://github.com/vercel/ms) - The original JavaScript `ms` package\n\n## Caught a Bug?\n\n1. [Fork](https://help.github.com/articles/fork-a-repo/) this repository to your own GitHub account and then [clone](https://help.github.com/articles/cloning-a-repository/) it to your local device\n2. Install `poetry` (if it isn\'t alreeady installed)\n3. Run `poetry install` in the project directory. This fetches development dependencies like `pytest` and sets up everything for you to start debugging\n\nAs always, you can run the tests using: `poetry run pytest`\n',
    'author': 'Lari Liuhamo',
    'author_email': 'lari.liuhamo+pypi@gmail.com',
    'maintainer': 'Lari Liuhamo',
    'maintainer_email': 'lari.liuhamo+pypi@gmail.com',
    'url': 'https://pypi.org/project/python-ms/',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
