# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mux_python.api_client import ApiClient
from mux_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class LiveStreamsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_live_stream(self, create_live_stream_request, **kwargs):  # noqa: E501
        """Create a live stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_live_stream(create_live_stream_request, async_req=True)
        >>> result = thread.get()

        :param create_live_stream_request: (required)
        :type create_live_stream_request: CreateLiveStreamRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LiveStreamResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_live_stream_with_http_info(create_live_stream_request, **kwargs)  # noqa: E501

    def create_live_stream_with_http_info(self, create_live_stream_request, **kwargs):  # noqa: E501
        """Create a live stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_live_stream_with_http_info(create_live_stream_request, async_req=True)
        >>> result = thread.get()

        :param create_live_stream_request: (required)
        :type create_live_stream_request: CreateLiveStreamRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LiveStreamResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'create_live_stream_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_live_stream" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_live_stream_request' is set
        if self.api_client.client_side_validation and ('create_live_stream_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_live_stream_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_live_stream_request` when calling `create_live_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_live_stream_request' in local_var_params:
            body_params = local_var_params['create_live_stream_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "LiveStreamResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_live_stream_playback_id(self, live_stream_id, create_playback_id_request, **kwargs):  # noqa: E501
        """Create a live stream playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_live_stream_playback_id(live_stream_id, create_playback_id_request, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param create_playback_id_request: (required)
        :type create_playback_id_request: CreatePlaybackIDRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatePlaybackIDResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_live_stream_playback_id_with_http_info(live_stream_id, create_playback_id_request, **kwargs)  # noqa: E501

    def create_live_stream_playback_id_with_http_info(self, live_stream_id, create_playback_id_request, **kwargs):  # noqa: E501
        """Create a live stream playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_live_stream_playback_id_with_http_info(live_stream_id, create_playback_id_request, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param create_playback_id_request: (required)
        :type create_playback_id_request: CreatePlaybackIDRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatePlaybackIDResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id',
            'create_playback_id_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_live_stream_playback_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `create_live_stream_playback_id`")  # noqa: E501
        # verify the required parameter 'create_playback_id_request' is set
        if self.api_client.client_side_validation and ('create_playback_id_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_playback_id_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_playback_id_request` when calling `create_live_stream_playback_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_playback_id_request' in local_var_params:
            body_params = local_var_params['create_playback_id_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "CreatePlaybackIDResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/playback-ids', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_live_stream_simulcast_target(self, live_stream_id, create_simulcast_target_request, **kwargs):  # noqa: E501
        """Create a live stream simulcast target  # noqa: E501

        Create a simulcast target for the parent live stream. Simulcast target can only be created when the parent live stream is in idle state. Only one simulcast target can be created at a time with this API.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_live_stream_simulcast_target(live_stream_id, create_simulcast_target_request, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param create_simulcast_target_request: (required)
        :type create_simulcast_target_request: CreateSimulcastTargetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SimulcastTargetResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_live_stream_simulcast_target_with_http_info(live_stream_id, create_simulcast_target_request, **kwargs)  # noqa: E501

    def create_live_stream_simulcast_target_with_http_info(self, live_stream_id, create_simulcast_target_request, **kwargs):  # noqa: E501
        """Create a live stream simulcast target  # noqa: E501

        Create a simulcast target for the parent live stream. Simulcast target can only be created when the parent live stream is in idle state. Only one simulcast target can be created at a time with this API.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_live_stream_simulcast_target_with_http_info(live_stream_id, create_simulcast_target_request, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param create_simulcast_target_request: (required)
        :type create_simulcast_target_request: CreateSimulcastTargetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SimulcastTargetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id',
            'create_simulcast_target_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_live_stream_simulcast_target" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `create_live_stream_simulcast_target`")  # noqa: E501
        # verify the required parameter 'create_simulcast_target_request' is set
        if self.api_client.client_side_validation and ('create_simulcast_target_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_simulcast_target_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_simulcast_target_request` when calling `create_live_stream_simulcast_target`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_simulcast_target_request' in local_var_params:
            body_params = local_var_params['create_simulcast_target_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "SimulcastTargetResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_live_stream(self, live_stream_id, **kwargs):  # noqa: E501
        """Delete a live stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_live_stream(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_live_stream_with_http_info(live_stream_id, **kwargs)  # noqa: E501

    def delete_live_stream_with_http_info(self, live_stream_id, **kwargs):  # noqa: E501
        """Delete a live stream  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_live_stream_with_http_info(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_live_stream" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `delete_live_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_live_stream_playback_id(self, live_stream_id, playback_id, **kwargs):  # noqa: E501
        """Delete a live stream playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_live_stream_playback_id(live_stream_id, playback_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param playback_id: The live stream's playback ID. (required)
        :type playback_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_live_stream_playback_id_with_http_info(live_stream_id, playback_id, **kwargs)  # noqa: E501

    def delete_live_stream_playback_id_with_http_info(self, live_stream_id, playback_id, **kwargs):  # noqa: E501
        """Delete a live stream playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_live_stream_playback_id_with_http_info(live_stream_id, playback_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param playback_id: The live stream's playback ID. (required)
        :type playback_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id',
            'playback_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_live_stream_playback_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `delete_live_stream_playback_id`")  # noqa: E501
        # verify the required parameter 'playback_id' is set
        if self.api_client.client_side_validation and ('playback_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_id` when calling `delete_live_stream_playback_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501
        if 'playback_id' in local_var_params:
            path_params['PLAYBACK_ID'] = local_var_params['playback_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/playback-ids/{PLAYBACK_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_live_stream_simulcast_target(self, live_stream_id, simulcast_target_id, **kwargs):  # noqa: E501
        """Delete a Live Stream Simulcast Target  # noqa: E501

        Delete the simulcast target using the simulcast target ID returned when creating the simulcast target. Simulcast Target can only be deleted when the parent live stream is in idle state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_live_stream_simulcast_target(live_stream_id, simulcast_target_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param simulcast_target_id: The ID of the simulcast target. (required)
        :type simulcast_target_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_live_stream_simulcast_target_with_http_info(live_stream_id, simulcast_target_id, **kwargs)  # noqa: E501

    def delete_live_stream_simulcast_target_with_http_info(self, live_stream_id, simulcast_target_id, **kwargs):  # noqa: E501
        """Delete a Live Stream Simulcast Target  # noqa: E501

        Delete the simulcast target using the simulcast target ID returned when creating the simulcast target. Simulcast Target can only be deleted when the parent live stream is in idle state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_live_stream_simulcast_target_with_http_info(live_stream_id, simulcast_target_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param simulcast_target_id: The ID of the simulcast target. (required)
        :type simulcast_target_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id',
            'simulcast_target_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_live_stream_simulcast_target" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `delete_live_stream_simulcast_target`")  # noqa: E501
        # verify the required parameter 'simulcast_target_id' is set
        if self.api_client.client_side_validation and ('simulcast_target_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulcast_target_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulcast_target_id` when calling `delete_live_stream_simulcast_target`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501
        if 'simulcast_target_id' in local_var_params:
            path_params['SIMULCAST_TARGET_ID'] = local_var_params['simulcast_target_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets/{SIMULCAST_TARGET_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def disable_live_stream(self, live_stream_id, **kwargs):  # noqa: E501
        """Disable a live stream  # noqa: E501

        Disables a live stream, making it reject incoming RTMP streams until re-enabled. The API also ends the live stream recording immediately when active. Ending the live stream recording adds the `EXT-X-ENDLIST` tag to the HLS manifest which notifies the player that this live stream is over.  Mux also closes the encoder connection immediately. Any attempt from the encoder to re-establish connection will fail till the live stream is re-enabled.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_live_stream(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DisableLiveStreamResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.disable_live_stream_with_http_info(live_stream_id, **kwargs)  # noqa: E501

    def disable_live_stream_with_http_info(self, live_stream_id, **kwargs):  # noqa: E501
        """Disable a live stream  # noqa: E501

        Disables a live stream, making it reject incoming RTMP streams until re-enabled. The API also ends the live stream recording immediately when active. Ending the live stream recording adds the `EXT-X-ENDLIST` tag to the HLS manifest which notifies the player that this live stream is over.  Mux also closes the encoder connection immediately. Any attempt from the encoder to re-establish connection will fail till the live stream is re-enabled.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.disable_live_stream_with_http_info(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DisableLiveStreamResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_live_stream" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `disable_live_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "DisableLiveStreamResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/disable', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def enable_live_stream(self, live_stream_id, **kwargs):  # noqa: E501
        """Enable a live stream  # noqa: E501

        Enables a live stream, allowing it to accept an incoming RTMP stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_live_stream(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: EnableLiveStreamResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.enable_live_stream_with_http_info(live_stream_id, **kwargs)  # noqa: E501

    def enable_live_stream_with_http_info(self, live_stream_id, **kwargs):  # noqa: E501
        """Enable a live stream  # noqa: E501

        Enables a live stream, allowing it to accept an incoming RTMP stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enable_live_stream_with_http_info(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(EnableLiveStreamResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_live_stream" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `enable_live_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "EnableLiveStreamResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/enable', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_live_stream(self, live_stream_id, **kwargs):  # noqa: E501
        """Retrieve a live stream  # noqa: E501

        Retrieves the details of a live stream that has previously been created. Supply the unique live stream ID that was returned from your previous request, and Mux will return the corresponding live stream information. The same information is returned when creating a live stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_live_stream(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LiveStreamResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_live_stream_with_http_info(live_stream_id, **kwargs)  # noqa: E501

    def get_live_stream_with_http_info(self, live_stream_id, **kwargs):  # noqa: E501
        """Retrieve a live stream  # noqa: E501

        Retrieves the details of a live stream that has previously been created. Supply the unique live stream ID that was returned from your previous request, and Mux will return the corresponding live stream information. The same information is returned when creating a live stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_live_stream_with_http_info(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LiveStreamResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_live_stream" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `get_live_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "LiveStreamResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_live_stream_playback_id(self, live_stream_id, playback_id, **kwargs):  # noqa: E501
        """Retrieve a live stream playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_live_stream_playback_id(live_stream_id, playback_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param playback_id: The live stream's playback ID. (required)
        :type playback_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetLiveStreamPlaybackIDResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_live_stream_playback_id_with_http_info(live_stream_id, playback_id, **kwargs)  # noqa: E501

    def get_live_stream_playback_id_with_http_info(self, live_stream_id, playback_id, **kwargs):  # noqa: E501
        """Retrieve a live stream playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_live_stream_playback_id_with_http_info(live_stream_id, playback_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param playback_id: The live stream's playback ID. (required)
        :type playback_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetLiveStreamPlaybackIDResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id',
            'playback_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_live_stream_playback_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `get_live_stream_playback_id`")  # noqa: E501
        # verify the required parameter 'playback_id' is set
        if self.api_client.client_side_validation and ('playback_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_id` when calling `get_live_stream_playback_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501
        if 'playback_id' in local_var_params:
            path_params['PLAYBACK_ID'] = local_var_params['playback_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "GetLiveStreamPlaybackIDResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/playback-ids/{PLAYBACK_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_live_stream_simulcast_target(self, live_stream_id, simulcast_target_id, **kwargs):  # noqa: E501
        """Retrieve a Live Stream Simulcast Target  # noqa: E501

        Retrieves the details of the simulcast target created for the parent live stream. Supply the unique live stream ID and simulcast target ID that was returned in the response of create simulcast target request, and Mux will return the corresponding information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_live_stream_simulcast_target(live_stream_id, simulcast_target_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param simulcast_target_id: The ID of the simulcast target. (required)
        :type simulcast_target_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SimulcastTargetResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_live_stream_simulcast_target_with_http_info(live_stream_id, simulcast_target_id, **kwargs)  # noqa: E501

    def get_live_stream_simulcast_target_with_http_info(self, live_stream_id, simulcast_target_id, **kwargs):  # noqa: E501
        """Retrieve a Live Stream Simulcast Target  # noqa: E501

        Retrieves the details of the simulcast target created for the parent live stream. Supply the unique live stream ID and simulcast target ID that was returned in the response of create simulcast target request, and Mux will return the corresponding information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_live_stream_simulcast_target_with_http_info(live_stream_id, simulcast_target_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param simulcast_target_id: The ID of the simulcast target. (required)
        :type simulcast_target_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SimulcastTargetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id',
            'simulcast_target_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_live_stream_simulcast_target" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `get_live_stream_simulcast_target`")  # noqa: E501
        # verify the required parameter 'simulcast_target_id' is set
        if self.api_client.client_side_validation and ('simulcast_target_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['simulcast_target_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `simulcast_target_id` when calling `get_live_stream_simulcast_target`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501
        if 'simulcast_target_id' in local_var_params:
            path_params['SIMULCAST_TARGET_ID'] = local_var_params['simulcast_target_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "SimulcastTargetResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets/{SIMULCAST_TARGET_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_live_streams(self, **kwargs):  # noqa: E501
        """List live streams  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_live_streams(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param stream_key: Filter response to return live stream for this stream key only
        :type stream_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListLiveStreamsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_live_streams_with_http_info(**kwargs)  # noqa: E501

    def list_live_streams_with_http_info(self, **kwargs):  # noqa: E501
        """List live streams  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_live_streams_with_http_info(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param stream_key: Filter response to return live stream for this stream key only
        :type stream_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListLiveStreamsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'page',
            'stream_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_live_streams" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'stream_key' in local_var_params and local_var_params['stream_key'] is not None:  # noqa: E501
            query_params.append(('stream_key', local_var_params['stream_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListLiveStreamsResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def reset_stream_key(self, live_stream_id, **kwargs):  # noqa: E501
        """Reset a live stream’s stream key  # noqa: E501

        Reset a live stream key if you want to immediately stop the current stream key from working and create a new stream key that can be used for future broadcasts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_stream_key(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LiveStreamResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.reset_stream_key_with_http_info(live_stream_id, **kwargs)  # noqa: E501

    def reset_stream_key_with_http_info(self, live_stream_id, **kwargs):  # noqa: E501
        """Reset a live stream’s stream key  # noqa: E501

        Reset a live stream key if you want to immediately stop the current stream key from working and create a new stream key that can be used for future broadcasts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_stream_key_with_http_info(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LiveStreamResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_stream_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `reset_stream_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "LiveStreamResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/reset-stream-key', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def signal_live_stream_complete(self, live_stream_id, **kwargs):  # noqa: E501
        """Signal a live stream is finished  # noqa: E501

        (Optional) End the live stream recording immediately instead of waiting for the reconnect_window. `EXT-X-ENDLIST` tag is added to the HLS manifest which notifies the player that this live stream is over.  Mux does not close the encoder connection immediately. Encoders are often configured to re-establish connections immediately which would result in a new recorded asset. For this reason, Mux waits for 60s before closing the connection with the encoder. This 60s timeframe is meant to give encoder operators a chance to disconnect from their end.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.signal_live_stream_complete(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SignalLiveStreamCompleteResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.signal_live_stream_complete_with_http_info(live_stream_id, **kwargs)  # noqa: E501

    def signal_live_stream_complete_with_http_info(self, live_stream_id, **kwargs):  # noqa: E501
        """Signal a live stream is finished  # noqa: E501

        (Optional) End the live stream recording immediately instead of waiting for the reconnect_window. `EXT-X-ENDLIST` tag is added to the HLS manifest which notifies the player that this live stream is over.  Mux does not close the encoder connection immediately. Encoders are often configured to re-establish connections immediately which would result in a new recorded asset. For this reason, Mux waits for 60s before closing the connection with the encoder. This 60s timeframe is meant to give encoder operators a chance to disconnect from their end.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.signal_live_stream_complete_with_http_info(live_stream_id, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SignalLiveStreamCompleteResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method signal_live_stream_complete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `signal_live_stream_complete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "SignalLiveStreamCompleteResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/complete', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_live_stream(self, live_stream_id, update_live_stream_request, **kwargs):  # noqa: E501
        """Update a live stream  # noqa: E501

        Updates the parameters of a previously-created live stream. This currently supports a subset of variables. Supply the live stream ID and the updated parameters and Mux will return the corresponding live stream information. The information returned will be the same after update as for subsequent get live stream requests.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_live_stream(live_stream_id, update_live_stream_request, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param update_live_stream_request: (required)
        :type update_live_stream_request: UpdateLiveStreamRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LiveStreamResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_live_stream_with_http_info(live_stream_id, update_live_stream_request, **kwargs)  # noqa: E501

    def update_live_stream_with_http_info(self, live_stream_id, update_live_stream_request, **kwargs):  # noqa: E501
        """Update a live stream  # noqa: E501

        Updates the parameters of a previously-created live stream. This currently supports a subset of variables. Supply the live stream ID and the updated parameters and Mux will return the corresponding live stream information. The information returned will be the same after update as for subsequent get live stream requests.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_live_stream_with_http_info(live_stream_id, update_live_stream_request, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param update_live_stream_request: (required)
        :type update_live_stream_request: UpdateLiveStreamRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LiveStreamResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id',
            'update_live_stream_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_live_stream" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `update_live_stream`")  # noqa: E501
        # verify the required parameter 'update_live_stream_request' is set
        if self.api_client.client_side_validation and ('update_live_stream_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_live_stream_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_live_stream_request` when calling `update_live_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_live_stream_request' in local_var_params:
            body_params = local_var_params['update_live_stream_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "LiveStreamResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_live_stream_embedded_subtitles(self, live_stream_id, update_live_stream_embedded_subtitles_request, **kwargs):  # noqa: E501
        """Update a live stream's embedded subtitles  # noqa: E501

        Configures a live stream to receive embedded closed captions. The resulting Asset's subtitle text track will have `closed_captions: true` set.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_live_stream_embedded_subtitles(live_stream_id, update_live_stream_embedded_subtitles_request, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param update_live_stream_embedded_subtitles_request: (required)
        :type update_live_stream_embedded_subtitles_request: UpdateLiveStreamEmbeddedSubtitlesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LiveStreamResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_live_stream_embedded_subtitles_with_http_info(live_stream_id, update_live_stream_embedded_subtitles_request, **kwargs)  # noqa: E501

    def update_live_stream_embedded_subtitles_with_http_info(self, live_stream_id, update_live_stream_embedded_subtitles_request, **kwargs):  # noqa: E501
        """Update a live stream's embedded subtitles  # noqa: E501

        Configures a live stream to receive embedded closed captions. The resulting Asset's subtitle text track will have `closed_captions: true` set.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_live_stream_embedded_subtitles_with_http_info(live_stream_id, update_live_stream_embedded_subtitles_request, async_req=True)
        >>> result = thread.get()

        :param live_stream_id: The live stream ID (required)
        :type live_stream_id: str
        :param update_live_stream_embedded_subtitles_request: (required)
        :type update_live_stream_embedded_subtitles_request: UpdateLiveStreamEmbeddedSubtitlesRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LiveStreamResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'live_stream_id',
            'update_live_stream_embedded_subtitles_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_live_stream_embedded_subtitles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'live_stream_id' is set
        if self.api_client.client_side_validation and ('live_stream_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['live_stream_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `live_stream_id` when calling `update_live_stream_embedded_subtitles`")  # noqa: E501
        # verify the required parameter 'update_live_stream_embedded_subtitles_request' is set
        if self.api_client.client_side_validation and ('update_live_stream_embedded_subtitles_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_live_stream_embedded_subtitles_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_live_stream_embedded_subtitles_request` when calling `update_live_stream_embedded_subtitles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'live_stream_id' in local_var_params:
            path_params['LIVE_STREAM_ID'] = local_var_params['live_stream_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_live_stream_embedded_subtitles_request' in local_var_params:
            body_params = local_var_params['update_live_stream_embedded_subtitles_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "LiveStreamResponse",
        }

        return self.api_client.call_api(
            '/video/v1/live-streams/{LIVE_STREAM_ID}/embedded-subtitles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
