"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const pdk_nag_1 = require("../../pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const assertions_1 = require("aws-cdk-lib/assertions");
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
const src_1 = require("../src");
describe("PDK Pipeline Unit Tests", () => {
    it("Defaults", () => {
        const app = pdk_nag_1.PDKNag.app();
        const stack = new aws_cdk_lib_1.Stack(app);
        const pipeline = new src_1.PDKPipeline(stack, "Defaults", {
            primarySynthDirectory: "cdk.out",
            repositoryName: "Defaults",
            synth: {},
            sonarCodeScannerConfig: {
                sonarqubeAuthorizedGroup: "dev",
                sonarqubeDefaultProfileOrGateName: "dev",
                sonarqubeEndpoint: "https://sonar.dev",
                sonarqubeProjectName: "Default",
            },
        });
        const stage = new aws_cdk_lib_1.Stage(app, "Stage");
        const appStack = new aws_cdk_lib_1.Stack(stage, "AppStack");
        new aws_s3_assets_1.Asset(appStack, "Asset", {
            path: path.join(__dirname, "pdk-pipeline.test.ts"),
        });
        pipeline.addStage(stage);
        pipeline.buildPipeline();
        expect(assertions_1.Template.fromStack(stack)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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