from setuptools import setup

name = "types-ibm-db"
description = "Typing stubs for ibm-db"
long_description = '''
## Typing stubs for ibm-db

This is a PEP 561 type stub package for the `ibm-db` package.
It can be used by type-checking tools like mypy, PyCharm, pytype etc. to check code
that uses `ibm-db`. The source for this package can be found at
https://github.com/python/typeshed/tree/main/stubs/ibm-db. All fixes for
types and metadata should be contributed there.

See https://github.com/python/typeshed/blob/main/README.md for more details.
This package was generated from typeshed commit `0c196791fc40171bb9f6dadf9fb19705d82efa77`.
'''.lstrip()

setup(name=name,
      version="3.1.0.0",
      description=description,
      long_description=long_description,
      long_description_content_type="text/markdown",
      url="https://github.com/python/typeshed",
      project_urls={
          "GitHub": "https://github.com/python/typeshed",
          "Changes": "https://github.com/typeshed-internal/stub_uploader/blob/main/data/changelogs/ibm-db.md",
          "Issue tracker": "https://github.com/python/typeshed/issues",
          "Chat": "https://gitter.im/python/typing",
      },
      install_requires=[],
      packages=['ibm_db-stubs'],
      package_data={'ibm_db-stubs': ['__init__.pyi', 'METADATA.toml']},
      license="Apache-2.0 license",
      classifiers=[
          "License :: OSI Approved :: Apache Software License",
          "Programming Language :: Python :: 3",
          "Typing :: Stubs Only",
      ]
)
