# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
try:
    from typing import List, Dict, Any
except ImportError:
    pass


class ReleaseCapacityReservationRequest(TeaModel):
    def __init__(self, region_id=None, private_pool_options=None, dry_run=None):
        self.region_id = region_id      # type: str
        self.private_pool_options = private_pool_options  # type: ReleaseCapacityReservationRequestPrivatePoolOptions
        self.dry_run = dry_run          # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        result['DryRun'] = self.dry_run
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = ReleaseCapacityReservationRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        self.dry_run = map.get('DryRun')
        return self


class ReleaseCapacityReservationRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = {}
        result['Id'] = self.id
        return result

    def from_map(self, map={}):
        self.id = map.get('Id')
        return self


class ReleaseCapacityReservationResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeCapacityReservationsRequest(TeaModel):
    def __init__(self, region_id=None, max_results=None, next_token=None, private_pool_options=None, platform=None,
                 instance_type=None, zone_id=None, instance_charge_type=None):
        self.region_id = region_id      # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token    # type: str
        self.private_pool_options = private_pool_options  # type: DescribeCapacityReservationsRequestPrivatePoolOptions
        self.platform = platform        # type: str
        self.instance_type = instance_type  # type: str
        self.zone_id = zone_id          # type: str
        self.instance_charge_type = instance_charge_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['MaxResults'] = self.max_results
        result['NextToken'] = self.next_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        result['Platform'] = self.platform
        result['InstanceType'] = self.instance_type
        result['ZoneId'] = self.zone_id
        result['InstanceChargeType'] = self.instance_charge_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.max_results = map.get('MaxResults')
        self.next_token = map.get('NextToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = DescribeCapacityReservationsRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        self.platform = map.get('Platform')
        self.instance_type = map.get('InstanceType')
        self.zone_id = map.get('ZoneId')
        self.instance_charge_type = map.get('InstanceChargeType')
        return self


class DescribeCapacityReservationsRequestPrivatePoolOptions(TeaModel):
    def __init__(self, ids=None):
        self.ids = ids                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Ids'] = self.ids
        return result

    def from_map(self, map={}):
        self.ids = map.get('Ids')
        return self


class DescribeCapacityReservationsResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, max_results=None, total_count=None,
                 capacity_reservation_set=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int
        self.total_count = total_count  # type: int
        self.capacity_reservation_set = capacity_reservation_set  # type: DescribeCapacityReservationsResponseCapacityReservationSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.max_results, 'max_results')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.capacity_reservation_set, 'capacity_reservation_set')
        if self.capacity_reservation_set:
            self.capacity_reservation_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NextToken'] = self.next_token
        result['MaxResults'] = self.max_results
        result['TotalCount'] = self.total_count
        if self.capacity_reservation_set is not None:
            result['CapacityReservationSet'] = self.capacity_reservation_set.to_map()
        else:
            result['CapacityReservationSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.next_token = map.get('NextToken')
        self.max_results = map.get('MaxResults')
        self.total_count = map.get('TotalCount')
        if map.get('CapacityReservationSet') is not None:
            temp_model = DescribeCapacityReservationsResponseCapacityReservationSet()
            self.capacity_reservation_set = temp_model.from_map(map['CapacityReservationSet'])
        else:
            self.capacity_reservation_set = None
        return self


class DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource(TeaModel):
    def __init__(self, zone_id=None, instance_type=None, total_amount=None, used_amount=None):
        self.zone_id = zone_id          # type: str
        self.instance_type = instance_type  # type: str
        self.total_amount = total_amount  # type: int
        self.used_amount = used_amount  # type: int

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.used_amount, 'used_amount')

    def to_map(self):
        result = {}
        result['zoneId'] = self.zone_id
        result['InstanceType'] = self.instance_type
        result['TotalAmount'] = self.total_amount
        result['UsedAmount'] = self.used_amount
        return result

    def from_map(self, map={}):
        self.zone_id = map.get('zoneId')
        self.instance_type = map.get('InstanceType')
        self.total_amount = map.get('TotalAmount')
        self.used_amount = map.get('UsedAmount')
        return self


class DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResources(TeaModel):
    def __init__(self, allocated_resource=None):
        self.allocated_resource = allocated_resource  # type: List[DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource]

    def validate(self):
        self.validate_required(self.allocated_resource, 'allocated_resource')
        if self.allocated_resource:
            for k in self.allocated_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AllocatedResource'] = []
        if self.allocated_resource is not None:
            for k in self.allocated_resource:
                result['AllocatedResource'].append(k.to_map() if k else None)
        else:
            result['AllocatedResource'] = None
        return result

    def from_map(self, map={}):
        self.allocated_resource = []
        if map.get('AllocatedResource') is not None:
            for k in map.get('AllocatedResource'):
                temp_model = DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource()
                self.allocated_resource.append(temp_model.from_map(k))
        else:
            self.allocated_resource = None
        return self


class DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItem(TeaModel):
    def __init__(self, private_pool_options_id=None, private_pool_options_name=None, description=None,
                 region_id=None, private_pool_options_match_criteria=None, status=None, start_time=None, end_time=None,
                 end_time_type=None, instance_charge_type=None, platform=None, allocated_resources=None):
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.private_pool_options_name = private_pool_options_name  # type: str
        self.description = description  # type: str
        self.region_id = region_id      # type: str
        self.private_pool_options_match_criteria = private_pool_options_match_criteria  # type: str
        self.status = status            # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.end_time_type = end_time_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.platform = platform        # type: str
        self.allocated_resources = allocated_resources  # type: DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResources

    def validate(self):
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')
        self.validate_required(self.private_pool_options_name, 'private_pool_options_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.private_pool_options_match_criteria, 'private_pool_options_match_criteria')
        self.validate_required(self.status, 'status')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.end_time_type, 'end_time_type')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.platform, 'platform')
        self.validate_required(self.allocated_resources, 'allocated_resources')
        if self.allocated_resources:
            self.allocated_resources.validate()

    def to_map(self):
        result = {}
        result['PrivatePoolOptionsId'] = self.private_pool_options_id
        result['PrivatePoolOptionsName'] = self.private_pool_options_name
        result['Description'] = self.description
        result['RegionId'] = self.region_id
        result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        result['Status'] = self.status
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['EndTimeType'] = self.end_time_type
        result['InstanceChargeType'] = self.instance_charge_type
        result['Platform'] = self.platform
        if self.allocated_resources is not None:
            result['AllocatedResources'] = self.allocated_resources.to_map()
        else:
            result['AllocatedResources'] = None
        return result

    def from_map(self, map={}):
        self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        self.private_pool_options_name = map.get('PrivatePoolOptionsName')
        self.description = map.get('Description')
        self.region_id = map.get('RegionId')
        self.private_pool_options_match_criteria = map.get('PrivatePoolOptionsMatchCriteria')
        self.status = map.get('Status')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.end_time_type = map.get('EndTimeType')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.platform = map.get('Platform')
        if map.get('AllocatedResources') is not None:
            temp_model = DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItemAllocatedResources()
            self.allocated_resources = temp_model.from_map(map['AllocatedResources'])
        else:
            self.allocated_resources = None
        return self


class DescribeCapacityReservationsResponseCapacityReservationSet(TeaModel):
    def __init__(self, capacity_reservation_item=None):
        self.capacity_reservation_item = capacity_reservation_item  # type: List[DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItem]

    def validate(self):
        self.validate_required(self.capacity_reservation_item, 'capacity_reservation_item')
        if self.capacity_reservation_item:
            for k in self.capacity_reservation_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['CapacityReservationItem'] = []
        if self.capacity_reservation_item is not None:
            for k in self.capacity_reservation_item:
                result['CapacityReservationItem'].append(k.to_map() if k else None)
        else:
            result['CapacityReservationItem'] = None
        return result

    def from_map(self, map={}):
        self.capacity_reservation_item = []
        if map.get('CapacityReservationItem') is not None:
            for k in map.get('CapacityReservationItem'):
                temp_model = DescribeCapacityReservationsResponseCapacityReservationSetCapacityReservationItem()
                self.capacity_reservation_item.append(temp_model.from_map(k))
        else:
            self.capacity_reservation_item = None
        return self


class DescribeCapacityReservationInstancesRequest(TeaModel):
    def __init__(self, region_id=None, max_results=None, next_token=None, private_pool_options=None):
        self.region_id = region_id      # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token    # type: str
        self.private_pool_options = private_pool_options  # type: DescribeCapacityReservationInstancesRequestPrivatePoolOptions

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['MaxResults'] = self.max_results
        result['NextToken'] = self.next_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.max_results = map.get('MaxResults')
        self.next_token = map.get('NextToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = DescribeCapacityReservationInstancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        return self


class DescribeCapacityReservationInstancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = {}
        result['Id'] = self.id
        return result

    def from_map(self, map={}):
        self.id = map.get('Id')
        return self


class DescribeCapacityReservationInstancesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, max_results=None, total_count=None,
                 capacity_reservation_item=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int
        self.total_count = total_count  # type: int
        self.capacity_reservation_item = capacity_reservation_item  # type: DescribeCapacityReservationInstancesResponseCapacityReservationItem

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.max_results, 'max_results')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.capacity_reservation_item, 'capacity_reservation_item')
        if self.capacity_reservation_item:
            self.capacity_reservation_item.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NextToken'] = self.next_token
        result['MaxResults'] = self.max_results
        result['TotalCount'] = self.total_count
        if self.capacity_reservation_item is not None:
            result['CapacityReservationItem'] = self.capacity_reservation_item.to_map()
        else:
            result['CapacityReservationItem'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.next_token = map.get('NextToken')
        self.max_results = map.get('MaxResults')
        self.total_count = map.get('TotalCount')
        if map.get('CapacityReservationItem') is not None:
            temp_model = DescribeCapacityReservationInstancesResponseCapacityReservationItem()
            self.capacity_reservation_item = temp_model.from_map(map['CapacityReservationItem'])
        else:
            self.capacity_reservation_item = None
        return self


class DescribeCapacityReservationInstancesResponseCapacityReservationItemInstanceIdSet(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        return self


class DescribeCapacityReservationInstancesResponseCapacityReservationItem(TeaModel):
    def __init__(self, instance_id_set=None):
        self.instance_id_set = instance_id_set  # type: List[DescribeCapacityReservationInstancesResponseCapacityReservationItemInstanceIdSet]

    def validate(self):
        self.validate_required(self.instance_id_set, 'instance_id_set')
        if self.instance_id_set:
            for k in self.instance_id_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceIdSet'] = []
        if self.instance_id_set is not None:
            for k in self.instance_id_set:
                result['InstanceIdSet'].append(k.to_map() if k else None)
        else:
            result['InstanceIdSet'] = None
        return result

    def from_map(self, map={}):
        self.instance_id_set = []
        if map.get('InstanceIdSet') is not None:
            for k in map.get('InstanceIdSet'):
                temp_model = DescribeCapacityReservationInstancesResponseCapacityReservationItemInstanceIdSet()
                self.instance_id_set.append(temp_model.from_map(k))
        else:
            self.instance_id_set = None
        return self


class CreateCapacityReservationRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, zone_id=None, private_pool_options=None, description=None,
                 instance_amount=None, instance_type=None, start_time=None, end_time=None, end_time_type=None, platform=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.zone_id = zone_id          # type: List[str]
        self.private_pool_options = private_pool_options  # type: CreateCapacityReservationRequestPrivatePoolOptions
        self.description = description  # type: str
        self.instance_amount = instance_amount  # type: int
        self.instance_type = instance_type  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.end_time_type = end_time_type  # type: str
        self.platform = platform        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        if self.private_pool_options:
            self.private_pool_options.validate()
        self.validate_required(self.instance_amount, 'instance_amount')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['ZoneId'] = self.zone_id
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        result['Description'] = self.description
        result['InstanceAmount'] = self.instance_amount
        result['InstanceType'] = self.instance_type
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['EndTimeType'] = self.end_time_type
        result['Platform'] = self.platform
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.zone_id = map.get('ZoneId')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = CreateCapacityReservationRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        self.description = map.get('Description')
        self.instance_amount = map.get('InstanceAmount')
        self.instance_type = map.get('InstanceType')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.end_time_type = map.get('EndTimeType')
        self.platform = map.get('Platform')
        return self


class CreateCapacityReservationRequestPrivatePoolOptions(TeaModel):
    def __init__(self, name=None, match_criteria=None):
        self.name = name                # type: str
        self.match_criteria = match_criteria  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Name'] = self.name
        result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, map={}):
        self.name = map.get('Name')
        self.match_criteria = map.get('MatchCriteria')
        return self


class CreateCapacityReservationResponse(TeaModel):
    def __init__(self, request_id=None, private_pool_options_id=None):
        self.request_id = request_id    # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PrivatePoolOptionsId'] = self.private_pool_options_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        return self


class StartElasticityAssuranceRequest(TeaModel):
    def __init__(self, region_id=None, private_pool_options=None):
        self.region_id = region_id      # type: str
        self.private_pool_options = private_pool_options  # type: StartElasticityAssuranceRequestPrivatePoolOptions

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = StartElasticityAssuranceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        return self


class StartElasticityAssuranceRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = {}
        result['Id'] = self.id
        return result

    def from_map(self, map={}):
        self.id = map.get('Id')
        return self


class StartElasticityAssuranceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyInstanceAttachmentAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, private_pool_options=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.private_pool_options = private_pool_options  # type: ModifyInstanceAttachmentAttributesRequestPrivatePoolOptions

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = ModifyInstanceAttachmentAttributesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        return self


class ModifyInstanceAttachmentAttributesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, match_criteria=None, id=None):
        self.match_criteria = match_criteria  # type: str
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.match_criteria, 'match_criteria')

    def to_map(self):
        result = {}
        result['MatchCriteria'] = self.match_criteria
        result['Id'] = self.id
        return result

    def from_map(self, map={}):
        self.match_criteria = map.get('MatchCriteria')
        self.id = map.get('Id')
        return self


class ModifyInstanceAttachmentAttributesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstanceAttachmentAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_ids=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.instance_ids = instance_ids  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceIds'] = self.instance_ids
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_ids = map.get('InstanceIds')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInstanceAttachmentAttributesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, instances=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.instances = instances      # type: DescribeInstanceAttachmentAttributesResponseInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            self.instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        else:
            result['Instances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Instances') is not None:
            temp_model = DescribeInstanceAttachmentAttributesResponseInstances()
            self.instances = temp_model.from_map(map['Instances'])
        else:
            self.instances = None
        return self


class DescribeInstanceAttachmentAttributesResponseInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, private_pool_options_id=None, private_pool_options_match_criteria=None):
        self.instance_id = instance_id  # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.private_pool_options_match_criteria = private_pool_options_match_criteria  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')
        self.validate_required(self.private_pool_options_match_criteria, 'private_pool_options_match_criteria')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['PrivatePoolOptionsId'] = self.private_pool_options_id
        result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        self.private_pool_options_match_criteria = map.get('PrivatePoolOptionsMatchCriteria')
        return self


class DescribeInstanceAttachmentAttributesResponseInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance        # type: List[DescribeInstanceAttachmentAttributesResponseInstancesInstance]

    def validate(self):
        self.validate_required(self.instance, 'instance')
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        else:
            result['Instance'] = None
        return result

    def from_map(self, map={}):
        self.instance = []
        if map.get('Instance') is not None:
            for k in map.get('Instance'):
                temp_model = DescribeInstanceAttachmentAttributesResponseInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        else:
            self.instance = None
        return self


class DescribeElasticityAssurancesRequest(TeaModel):
    def __init__(self, region_id=None, max_results=None, next_token=None, private_pool_options=None, platform=None,
                 instance_type=None, zone_id=None, instance_charge_type=None):
        self.region_id = region_id      # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token    # type: str
        self.private_pool_options = private_pool_options  # type: DescribeElasticityAssurancesRequestPrivatePoolOptions
        self.platform = platform        # type: str
        self.instance_type = instance_type  # type: str
        self.zone_id = zone_id          # type: str
        self.instance_charge_type = instance_charge_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['MaxResults'] = self.max_results
        result['NextToken'] = self.next_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        result['Platform'] = self.platform
        result['InstanceType'] = self.instance_type
        result['ZoneId'] = self.zone_id
        result['InstanceChargeType'] = self.instance_charge_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.max_results = map.get('MaxResults')
        self.next_token = map.get('NextToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = DescribeElasticityAssurancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        self.platform = map.get('Platform')
        self.instance_type = map.get('InstanceType')
        self.zone_id = map.get('ZoneId')
        self.instance_charge_type = map.get('InstanceChargeType')
        return self


class DescribeElasticityAssurancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, ids=None):
        self.ids = ids                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Ids'] = self.ids
        return result

    def from_map(self, map={}):
        self.ids = map.get('Ids')
        return self


class DescribeElasticityAssurancesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, max_results=None, total_count=None,
                 elasticity_assurance_set=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int
        self.total_count = total_count  # type: int
        self.elasticity_assurance_set = elasticity_assurance_set  # type: DescribeElasticityAssurancesResponseElasticityAssuranceSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.max_results, 'max_results')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.elasticity_assurance_set, 'elasticity_assurance_set')
        if self.elasticity_assurance_set:
            self.elasticity_assurance_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NextToken'] = self.next_token
        result['MaxResults'] = self.max_results
        result['TotalCount'] = self.total_count
        if self.elasticity_assurance_set is not None:
            result['ElasticityAssuranceSet'] = self.elasticity_assurance_set.to_map()
        else:
            result['ElasticityAssuranceSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.next_token = map.get('NextToken')
        self.max_results = map.get('MaxResults')
        self.total_count = map.get('TotalCount')
        if map.get('ElasticityAssuranceSet') is not None:
            temp_model = DescribeElasticityAssurancesResponseElasticityAssuranceSet()
            self.elasticity_assurance_set = temp_model.from_map(map['ElasticityAssuranceSet'])
        else:
            self.elasticity_assurance_set = None
        return self


class DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResourcesAllocatedResource(TeaModel):
    def __init__(self, zone_id=None, instance_type=None, total_amount=None, used_amount=None):
        self.zone_id = zone_id          # type: str
        self.instance_type = instance_type  # type: str
        self.total_amount = total_amount  # type: int
        self.used_amount = used_amount  # type: int

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.used_amount, 'used_amount')

    def to_map(self):
        result = {}
        result['zoneId'] = self.zone_id
        result['InstanceType'] = self.instance_type
        result['TotalAmount'] = self.total_amount
        result['UsedAmount'] = self.used_amount
        return result

    def from_map(self, map={}):
        self.zone_id = map.get('zoneId')
        self.instance_type = map.get('InstanceType')
        self.total_amount = map.get('TotalAmount')
        self.used_amount = map.get('UsedAmount')
        return self


class DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResources(TeaModel):
    def __init__(self, allocated_resource=None):
        self.allocated_resource = allocated_resource  # type: List[DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResourcesAllocatedResource]

    def validate(self):
        self.validate_required(self.allocated_resource, 'allocated_resource')
        if self.allocated_resource:
            for k in self.allocated_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AllocatedResource'] = []
        if self.allocated_resource is not None:
            for k in self.allocated_resource:
                result['AllocatedResource'].append(k.to_map() if k else None)
        else:
            result['AllocatedResource'] = None
        return result

    def from_map(self, map={}):
        self.allocated_resource = []
        if map.get('AllocatedResource') is not None:
            for k in map.get('AllocatedResource'):
                temp_model = DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResourcesAllocatedResource()
                self.allocated_resource.append(temp_model.from_map(k))
        else:
            self.allocated_resource = None
        return self


class DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItem(TeaModel):
    def __init__(self, private_pool_options_id=None, private_pool_options_name=None, description=None,
                 region_id=None, private_pool_options_match_criteria=None, used_assurance_times=None,
                 total_assurance_times=None, status=None, start_time=None, end_time=None, latest_start_time=None,
                 allocated_resources=None):
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.private_pool_options_name = private_pool_options_name  # type: str
        self.description = description  # type: str
        self.region_id = region_id      # type: str
        self.private_pool_options_match_criteria = private_pool_options_match_criteria  # type: str
        self.used_assurance_times = used_assurance_times  # type: int
        self.total_assurance_times = total_assurance_times  # type: str
        self.status = status            # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.latest_start_time = latest_start_time  # type: str
        self.allocated_resources = allocated_resources  # type: DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResources

    def validate(self):
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')
        self.validate_required(self.private_pool_options_name, 'private_pool_options_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.private_pool_options_match_criteria, 'private_pool_options_match_criteria')
        self.validate_required(self.used_assurance_times, 'used_assurance_times')
        self.validate_required(self.total_assurance_times, 'total_assurance_times')
        self.validate_required(self.status, 'status')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.latest_start_time, 'latest_start_time')
        self.validate_required(self.allocated_resources, 'allocated_resources')
        if self.allocated_resources:
            self.allocated_resources.validate()

    def to_map(self):
        result = {}
        result['PrivatePoolOptionsId'] = self.private_pool_options_id
        result['PrivatePoolOptionsName'] = self.private_pool_options_name
        result['Description'] = self.description
        result['RegionId'] = self.region_id
        result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        result['UsedAssuranceTimes'] = self.used_assurance_times
        result['TotalAssuranceTimes'] = self.total_assurance_times
        result['Status'] = self.status
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['LatestStartTime'] = self.latest_start_time
        if self.allocated_resources is not None:
            result['AllocatedResources'] = self.allocated_resources.to_map()
        else:
            result['AllocatedResources'] = None
        return result

    def from_map(self, map={}):
        self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        self.private_pool_options_name = map.get('PrivatePoolOptionsName')
        self.description = map.get('Description')
        self.region_id = map.get('RegionId')
        self.private_pool_options_match_criteria = map.get('PrivatePoolOptionsMatchCriteria')
        self.used_assurance_times = map.get('UsedAssuranceTimes')
        self.total_assurance_times = map.get('TotalAssuranceTimes')
        self.status = map.get('Status')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.latest_start_time = map.get('LatestStartTime')
        if map.get('AllocatedResources') is not None:
            temp_model = DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItemAllocatedResources()
            self.allocated_resources = temp_model.from_map(map['AllocatedResources'])
        else:
            self.allocated_resources = None
        return self


class DescribeElasticityAssurancesResponseElasticityAssuranceSet(TeaModel):
    def __init__(self, elasticity_assurance_item=None):
        self.elasticity_assurance_item = elasticity_assurance_item  # type: List[DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItem]

    def validate(self):
        self.validate_required(self.elasticity_assurance_item, 'elasticity_assurance_item')
        if self.elasticity_assurance_item:
            for k in self.elasticity_assurance_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ElasticityAssuranceItem'] = []
        if self.elasticity_assurance_item is not None:
            for k in self.elasticity_assurance_item:
                result['ElasticityAssuranceItem'].append(k.to_map() if k else None)
        else:
            result['ElasticityAssuranceItem'] = None
        return result

    def from_map(self, map={}):
        self.elasticity_assurance_item = []
        if map.get('ElasticityAssuranceItem') is not None:
            for k in map.get('ElasticityAssuranceItem'):
                temp_model = DescribeElasticityAssurancesResponseElasticityAssuranceSetElasticityAssuranceItem()
                self.elasticity_assurance_item.append(temp_model.from_map(k))
        else:
            self.elasticity_assurance_item = None
        return self


class DescribeElasticityAssuranceInstancesRequest(TeaModel):
    def __init__(self, region_id=None, max_results=None, next_token=None, private_pool_options=None):
        self.region_id = region_id      # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token    # type: str
        self.private_pool_options = private_pool_options  # type: DescribeElasticityAssuranceInstancesRequestPrivatePoolOptions

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['MaxResults'] = self.max_results
        result['NextToken'] = self.next_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.max_results = map.get('MaxResults')
        self.next_token = map.get('NextToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = DescribeElasticityAssuranceInstancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        return self


class DescribeElasticityAssuranceInstancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id                    # type: str

    def validate(self):
        self.validate_required(self.id, 'id')

    def to_map(self):
        result = {}
        result['Id'] = self.id
        return result

    def from_map(self, map={}):
        self.id = map.get('Id')
        return self


class DescribeElasticityAssuranceInstancesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, max_results=None, total_count=None,
                 elasticity_assurance_item=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int
        self.total_count = total_count  # type: int
        self.elasticity_assurance_item = elasticity_assurance_item  # type: DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItem

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.max_results, 'max_results')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.elasticity_assurance_item, 'elasticity_assurance_item')
        if self.elasticity_assurance_item:
            self.elasticity_assurance_item.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NextToken'] = self.next_token
        result['MaxResults'] = self.max_results
        result['TotalCount'] = self.total_count
        if self.elasticity_assurance_item is not None:
            result['ElasticityAssuranceItem'] = self.elasticity_assurance_item.to_map()
        else:
            result['ElasticityAssuranceItem'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.next_token = map.get('NextToken')
        self.max_results = map.get('MaxResults')
        self.total_count = map.get('TotalCount')
        if map.get('ElasticityAssuranceItem') is not None:
            temp_model = DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItem()
            self.elasticity_assurance_item = temp_model.from_map(map['ElasticityAssuranceItem'])
        else:
            self.elasticity_assurance_item = None
        return self


class DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItemInstanceIdSet(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        return self


class DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItem(TeaModel):
    def __init__(self, instance_id_set=None):
        self.instance_id_set = instance_id_set  # type: List[DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItemInstanceIdSet]

    def validate(self):
        self.validate_required(self.instance_id_set, 'instance_id_set')
        if self.instance_id_set:
            for k in self.instance_id_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceIdSet'] = []
        if self.instance_id_set is not None:
            for k in self.instance_id_set:
                result['InstanceIdSet'].append(k.to_map() if k else None)
        else:
            result['InstanceIdSet'] = None
        return result

    def from_map(self, map={}):
        self.instance_id_set = []
        if map.get('InstanceIdSet') is not None:
            for k in map.get('InstanceIdSet'):
                temp_model = DescribeElasticityAssuranceInstancesResponseElasticityAssuranceItemInstanceIdSet()
                self.instance_id_set.append(temp_model.from_map(k))
        else:
            self.instance_id_set = None
        return self


class CreateElasticityAssuranceRequest(TeaModel):
    def __init__(self, region_id=None, period=None, period_unit=None, client_token=None, private_pool_options=None,
                 description=None, assurance_times=None, zone_id=None, instance_type=None, instance_amount=None,
                 instance_cpu_core_count=None, start_time=None):
        self.region_id = region_id      # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.client_token = client_token  # type: str
        self.private_pool_options = private_pool_options  # type: CreateElasticityAssuranceRequestPrivatePoolOptions
        self.description = description  # type: str
        self.assurance_times = assurance_times  # type: str
        self.zone_id = zone_id          # type: List[str]
        self.instance_type = instance_type  # type: List[str]
        self.instance_amount = instance_amount  # type: int
        self.instance_cpu_core_count = instance_cpu_core_count  # type: int
        self.start_time = start_time    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.private_pool_options:
            self.private_pool_options.validate()
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['ClientToken'] = self.client_token
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        result['Description'] = self.description
        result['AssuranceTimes'] = self.assurance_times
        result['ZoneId'] = self.zone_id
        result['InstanceType'] = self.instance_type
        result['InstanceAmount'] = self.instance_amount
        result['InstanceCpuCoreCount'] = self.instance_cpu_core_count
        result['StartTime'] = self.start_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.client_token = map.get('ClientToken')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = CreateElasticityAssuranceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        self.description = map.get('Description')
        self.assurance_times = map.get('AssuranceTimes')
        self.zone_id = map.get('ZoneId')
        self.instance_type = map.get('InstanceType')
        self.instance_amount = map.get('InstanceAmount')
        self.instance_cpu_core_count = map.get('InstanceCpuCoreCount')
        self.start_time = map.get('StartTime')
        return self


class CreateElasticityAssuranceRequestPrivatePoolOptions(TeaModel):
    def __init__(self, name=None, match_criteria=None):
        self.name = name                # type: str
        self.match_criteria = match_criteria  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Name'] = self.name
        result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, map={}):
        self.name = map.get('Name')
        self.match_criteria = map.get('MatchCriteria')
        return self


class CreateElasticityAssuranceResponse(TeaModel):
    def __init__(self, request_id=None, private_pool_options_id=None, order_id=None):
        self.request_id = request_id    # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.order_id = order_id        # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.private_pool_options_id, 'private_pool_options_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PrivatePoolOptionsId'] = self.private_pool_options_id
        result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.private_pool_options_id = map.get('PrivatePoolOptionsId')
        self.order_id = map.get('OrderId')
        return self


class SendFileRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, timeout=None, target_dir=None, instance_id=None,
                 content_type=None, content=None, file_owner=None, file_group=None, file_mode=None, overwrite=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.timeout = timeout          # type: int
        self.target_dir = target_dir    # type: str
        self.instance_id = instance_id  # type: List[str]
        self.content_type = content_type  # type: str
        self.content = content          # type: str
        self.file_owner = file_owner    # type: str
        self.file_group = file_group    # type: str
        self.file_mode = file_mode      # type: str
        self.overwrite = overwrite      # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.target_dir, 'target_dir')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.content, 'content')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['Timeout'] = self.timeout
        result['TargetDir'] = self.target_dir
        result['InstanceId'] = self.instance_id
        result['ContentType'] = self.content_type
        result['Content'] = self.content
        result['FileOwner'] = self.file_owner
        result['FileGroup'] = self.file_group
        result['FileMode'] = self.file_mode
        result['Overwrite'] = self.overwrite
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.timeout = map.get('Timeout')
        self.target_dir = map.get('TargetDir')
        self.instance_id = map.get('InstanceId')
        self.content_type = map.get('ContentType')
        self.content = map.get('Content')
        self.file_owner = map.get('FileOwner')
        self.file_group = map.get('FileGroup')
        self.file_mode = map.get('FileMode')
        self.overwrite = map.get('Overwrite')
        return self


class SendFileResponse(TeaModel):
    def __init__(self, request_id=None, invoke_id=None):
        self.request_id = request_id    # type: str
        self.invoke_id = invoke_id      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.invoke_id = map.get('InvokeId')
        return self


class DescribeSendFileResultsRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, name=None, instance_id=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.invoke_id = invoke_id      # type: str
        self.name = name                # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InvokeId'] = self.invoke_id
        result['Name'] = self.name
        result['InstanceId'] = self.instance_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.invoke_id = map.get('InvokeId')
        self.name = map.get('Name')
        self.instance_id = map.get('InstanceId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeSendFileResultsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, invocations=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.invocations = invocations  # type: DescribeSendFileResultsResponseInvocations

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.invocations, 'invocations')
        if self.invocations:
            self.invocations.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.invocations is not None:
            result['Invocations'] = self.invocations.to_map()
        else:
            result['Invocations'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Invocations') is not None:
            temp_model = DescribeSendFileResultsResponseInvocations()
            self.invocations = temp_model.from_map(map['Invocations'])
        else:
            self.invocations = None
        return self


class DescribeSendFileResultsResponseInvocationsInvocationInvokeInstancesInvokeInstance(TeaModel):
    def __init__(self, instance_id=None, invocation_status=None, creation_time=None, start_time=None,
                 finish_time=None, update_time=None, error_code=None, error_info=None):
        self.instance_id = instance_id  # type: str
        self.invocation_status = invocation_status  # type: str
        self.creation_time = creation_time  # type: str
        self.start_time = start_time    # type: str
        self.finish_time = finish_time  # type: str
        self.update_time = update_time  # type: str
        self.error_code = error_code    # type: str
        self.error_info = error_info    # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.finish_time, 'finish_time')
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_info, 'error_info')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['InvocationStatus'] = self.invocation_status
        result['CreationTime'] = self.creation_time
        result['StartTime'] = self.start_time
        result['FinishTime'] = self.finish_time
        result['UpdateTime'] = self.update_time
        result['ErrorCode'] = self.error_code
        result['ErrorInfo'] = self.error_info
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.invocation_status = map.get('InvocationStatus')
        self.creation_time = map.get('CreationTime')
        self.start_time = map.get('StartTime')
        self.finish_time = map.get('FinishTime')
        self.update_time = map.get('UpdateTime')
        self.error_code = map.get('ErrorCode')
        self.error_info = map.get('ErrorInfo')
        return self


class DescribeSendFileResultsResponseInvocationsInvocationInvokeInstances(TeaModel):
    def __init__(self, invoke_instance=None):
        self.invoke_instance = invoke_instance  # type: List[DescribeSendFileResultsResponseInvocationsInvocationInvokeInstancesInvokeInstance]

    def validate(self):
        self.validate_required(self.invoke_instance, 'invoke_instance')
        if self.invoke_instance:
            for k in self.invoke_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InvokeInstance'] = []
        if self.invoke_instance is not None:
            for k in self.invoke_instance:
                result['InvokeInstance'].append(k.to_map() if k else None)
        else:
            result['InvokeInstance'] = None
        return result

    def from_map(self, map={}):
        self.invoke_instance = []
        if map.get('InvokeInstance') is not None:
            for k in map.get('InvokeInstance'):
                temp_model = DescribeSendFileResultsResponseInvocationsInvocationInvokeInstancesInvokeInstance()
                self.invoke_instance.append(temp_model.from_map(k))
        else:
            self.invoke_instance = None
        return self


class DescribeSendFileResultsResponseInvocationsInvocation(TeaModel):
    def __init__(self, invoke_id=None, name=None, description=None, target_dir=None, content_type=None, content=None,
                 file_owner=None, file_group=None, file_mode=None, overwrite=None, vm_count=None, creation_time=None,
                 invocation_status=None, invoke_instances=None):
        self.invoke_id = invoke_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.target_dir = target_dir    # type: str
        self.content_type = content_type  # type: str
        self.content = content          # type: str
        self.file_owner = file_owner    # type: str
        self.file_group = file_group    # type: str
        self.file_mode = file_mode      # type: str
        self.overwrite = overwrite      # type: str
        self.vm_count = vm_count        # type: int
        self.creation_time = creation_time  # type: str
        self.invocation_status = invocation_status  # type: str
        self.invoke_instances = invoke_instances  # type: DescribeSendFileResultsResponseInvocationsInvocationInvokeInstances

    def validate(self):
        self.validate_required(self.invoke_id, 'invoke_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.target_dir, 'target_dir')
        self.validate_required(self.content_type, 'content_type')
        self.validate_required(self.content, 'content')
        self.validate_required(self.file_owner, 'file_owner')
        self.validate_required(self.file_group, 'file_group')
        self.validate_required(self.file_mode, 'file_mode')
        self.validate_required(self.overwrite, 'overwrite')
        self.validate_required(self.vm_count, 'vm_count')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.invoke_instances, 'invoke_instances')
        if self.invoke_instances:
            self.invoke_instances.validate()

    def to_map(self):
        result = {}
        result['InvokeId'] = self.invoke_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['TargetDir'] = self.target_dir
        result['ContentType'] = self.content_type
        result['Content'] = self.content
        result['FileOwner'] = self.file_owner
        result['FileGroup'] = self.file_group
        result['FileMode'] = self.file_mode
        result['Overwrite'] = self.overwrite
        result['VmCount'] = self.vm_count
        result['CreationTime'] = self.creation_time
        result['InvocationStatus'] = self.invocation_status
        if self.invoke_instances is not None:
            result['InvokeInstances'] = self.invoke_instances.to_map()
        else:
            result['InvokeInstances'] = None
        return result

    def from_map(self, map={}):
        self.invoke_id = map.get('InvokeId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.target_dir = map.get('TargetDir')
        self.content_type = map.get('ContentType')
        self.content = map.get('Content')
        self.file_owner = map.get('FileOwner')
        self.file_group = map.get('FileGroup')
        self.file_mode = map.get('FileMode')
        self.overwrite = map.get('Overwrite')
        self.vm_count = map.get('VmCount')
        self.creation_time = map.get('CreationTime')
        self.invocation_status = map.get('InvocationStatus')
        if map.get('InvokeInstances') is not None:
            temp_model = DescribeSendFileResultsResponseInvocationsInvocationInvokeInstances()
            self.invoke_instances = temp_model.from_map(map['InvokeInstances'])
        else:
            self.invoke_instances = None
        return self


class DescribeSendFileResultsResponseInvocations(TeaModel):
    def __init__(self, invocation=None):
        self.invocation = invocation    # type: List[DescribeSendFileResultsResponseInvocationsInvocation]

    def validate(self):
        self.validate_required(self.invocation, 'invocation')
        if self.invocation:
            for k in self.invocation:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Invocation'] = []
        if self.invocation is not None:
            for k in self.invocation:
                result['Invocation'].append(k.to_map() if k else None)
        else:
            result['Invocation'] = None
        return result

    def from_map(self, map={}):
        self.invocation = []
        if map.get('Invocation') is not None:
            for k in map.get('Invocation'):
                temp_model = DescribeSendFileResultsResponseInvocationsInvocation()
                self.invocation.append(temp_model.from_map(k))
        else:
            self.invocation = None
        return self


class ModifyDedicatedHostClusterAttributeRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_cluster_id=None, dedicated_host_cluster_name=None,
                 description=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        self.dedicated_host_cluster_name = map.get('DedicatedHostClusterName')
        self.description = map.get('Description')
        return self


class ModifyDedicatedHostClusterAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeDedicatedHostClustersRequest(TeaModel):
    def __init__(self, status=None, lock_reason=None, tag=None, resource_group_id=None, region_id=None, zone_id=None,
                 dedicated_host_cluster_ids=None, dedicated_host_cluster_name=None, page_number=None, page_size=None):
        self.status = status            # type: str
        self.lock_reason = lock_reason  # type: str
        self.tag = tag                  # type: List[DescribeDedicatedHostClustersRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_cluster_ids = dedicated_host_cluster_ids  # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['Status'] = self.status
        result['LockReason'] = self.lock_reason
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostClusterIds'] = self.dedicated_host_cluster_ids
        result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.status = map.get('Status')
        self.lock_reason = map.get('LockReason')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_cluster_ids = map.get('DedicatedHostClusterIds')
        self.dedicated_host_cluster_name = map.get('DedicatedHostClusterName')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeDedicatedHostClustersRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeDedicatedHostClustersResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 dedicated_host_clusters=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.dedicated_host_clusters = dedicated_host_clusters  # type: DescribeDedicatedHostClustersResponseDedicatedHostClusters

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.dedicated_host_clusters, 'dedicated_host_clusters')
        if self.dedicated_host_clusters:
            self.dedicated_host_clusters.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.dedicated_host_clusters is not None:
            result['DedicatedHostClusters'] = self.dedicated_host_clusters.to_map()
        else:
            result['DedicatedHostClusters'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('DedicatedHostClusters') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClusters()
            self.dedicated_host_clusters = temp_model.from_map(map['DedicatedHostClusters'])
        else:
            self.dedicated_host_clusters = None
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity(TeaModel):
    def __init__(self, total_disk=None, available_disk=None, data_disk_category=None):
        self.total_disk = total_disk    # type: int
        self.available_disk = available_disk  # type: int
        self.data_disk_category = data_disk_category  # type: str

    def validate(self):
        self.validate_required(self.total_disk, 'total_disk')
        self.validate_required(self.available_disk, 'available_disk')
        self.validate_required(self.data_disk_category, 'data_disk_category')

    def to_map(self):
        result = {}
        result['TotalDisk'] = self.total_disk
        result['AvailableDisk'] = self.available_disk
        result['DataDiskCategory'] = self.data_disk_category
        return result

    def from_map(self, map={}):
        self.total_disk = map.get('TotalDisk')
        self.available_disk = map.get('AvailableDisk')
        self.data_disk_category = map.get('DataDiskCategory')
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities(TeaModel):
    def __init__(self, local_storage_capacity=None):
        self.local_storage_capacity = local_storage_capacity  # type: List[DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity]

    def validate(self):
        self.validate_required(self.local_storage_capacity, 'local_storage_capacity')
        if self.local_storage_capacity:
            for k in self.local_storage_capacity:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LocalStorageCapacity'] = []
        if self.local_storage_capacity is not None:
            for k in self.local_storage_capacity:
                result['LocalStorageCapacity'].append(k.to_map() if k else None)
        else:
            result['LocalStorageCapacity'] = None
        return result

    def from_map(self, map={}):
        self.local_storage_capacity = []
        if map.get('LocalStorageCapacity') is not None:
            for k in map.get('LocalStorageCapacity'):
                temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity()
                self.local_storage_capacity.append(temp_model.from_map(k))
        else:
            self.local_storage_capacity = None
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity(TeaModel):
    def __init__(self, total_vcpus=None, available_vcpus=None, total_memory=None, available_memory=None,
                 local_storage_capacities=None):
        self.total_vcpus = total_vcpus  # type: int
        self.available_vcpus = available_vcpus  # type: int
        self.total_memory = total_memory  # type: int
        self.available_memory = available_memory  # type: int
        self.local_storage_capacities = local_storage_capacities  # type: DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities

    def validate(self):
        self.validate_required(self.total_vcpus, 'total_vcpus')
        self.validate_required(self.available_vcpus, 'available_vcpus')
        self.validate_required(self.total_memory, 'total_memory')
        self.validate_required(self.available_memory, 'available_memory')
        self.validate_required(self.local_storage_capacities, 'local_storage_capacities')
        if self.local_storage_capacities:
            self.local_storage_capacities.validate()

    def to_map(self):
        result = {}
        result['TotalVcpus'] = self.total_vcpus
        result['AvailableVcpus'] = self.available_vcpus
        result['TotalMemory'] = self.total_memory
        result['AvailableMemory'] = self.available_memory
        if self.local_storage_capacities is not None:
            result['LocalStorageCapacities'] = self.local_storage_capacities.to_map()
        else:
            result['LocalStorageCapacities'] = None
        return result

    def from_map(self, map={}):
        self.total_vcpus = map.get('TotalVcpus')
        self.available_vcpus = map.get('AvailableVcpus')
        self.total_memory = map.get('TotalMemory')
        self.available_memory = map.get('AvailableMemory')
        if map.get('LocalStorageCapacities') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities()
            self.local_storage_capacities = temp_model.from_map(map['LocalStorageCapacities'])
        else:
            self.local_storage_capacities = None
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostIds(TeaModel):
    def __init__(self, dedicated_host_id=None):
        # DedicatedHostId
        self.dedicated_host_id = dedicated_host_id  # type: List[str]

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostCluster(TeaModel):
    def __init__(self, dedicated_host_cluster_id=None, region_id=None, zone_id=None,
                 dedicated_host_cluster_name=None, description=None, resource_group_id=None, tags=None, dedicated_host_cluster_capacity=None,
                 dedicated_host_ids=None):
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.description = description  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tags = tags                # type: DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTags
        self.dedicated_host_cluster_capacity = dedicated_host_cluster_capacity  # type: DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity
        self.dedicated_host_ids = dedicated_host_ids  # type: DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostIds

    def validate(self):
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.dedicated_host_cluster_name, 'dedicated_host_cluster_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.dedicated_host_cluster_capacity, 'dedicated_host_cluster_capacity')
        if self.dedicated_host_cluster_capacity:
            self.dedicated_host_cluster_capacity.validate()
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        if self.dedicated_host_ids:
            self.dedicated_host_ids.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        result['Description'] = self.description
        result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.dedicated_host_cluster_capacity is not None:
            result['DedicatedHostClusterCapacity'] = self.dedicated_host_cluster_capacity.to_map()
        else:
            result['DedicatedHostClusterCapacity'] = None
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids.to_map()
        else:
            result['DedicatedHostIds'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_cluster_name = map.get('DedicatedHostClusterName')
        self.description = map.get('Description')
        self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Tags') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('DedicatedHostClusterCapacity') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity()
            self.dedicated_host_cluster_capacity = temp_model.from_map(map['DedicatedHostClusterCapacity'])
        else:
            self.dedicated_host_cluster_capacity = None
        if map.get('DedicatedHostIds') is not None:
            temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostClusterDedicatedHostIds()
            self.dedicated_host_ids = temp_model.from_map(map['DedicatedHostIds'])
        else:
            self.dedicated_host_ids = None
        return self


class DescribeDedicatedHostClustersResponseDedicatedHostClusters(TeaModel):
    def __init__(self, dedicated_host_cluster=None):
        self.dedicated_host_cluster = dedicated_host_cluster  # type: List[DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostCluster]

    def validate(self):
        self.validate_required(self.dedicated_host_cluster, 'dedicated_host_cluster')
        if self.dedicated_host_cluster:
            for k in self.dedicated_host_cluster:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostCluster'] = []
        if self.dedicated_host_cluster is not None:
            for k in self.dedicated_host_cluster:
                result['DedicatedHostCluster'].append(k.to_map() if k else None)
        else:
            result['DedicatedHostCluster'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_cluster = []
        if map.get('DedicatedHostCluster') is not None:
            for k in map.get('DedicatedHostCluster'):
                temp_model = DescribeDedicatedHostClustersResponseDedicatedHostClustersDedicatedHostCluster()
                self.dedicated_host_cluster.append(temp_model.from_map(k))
        else:
            self.dedicated_host_cluster = None
        return self


class DeleteDedicatedHostClusterRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_cluster_id=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        return self


class DeleteDedicatedHostClusterResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateDedicatedHostClusterRequest(TeaModel):
    def __init__(self, region_id=None, dry_run=None, tag=None, resource_group_id=None, zone_id=None,
                 dedicated_host_cluster_name=None, description=None):
        self.region_id = region_id      # type: str
        self.dry_run = dry_run          # type: bool
        self.tag = tag                  # type: List[CreateDedicatedHostClusterRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DryRun'] = self.dry_run
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dry_run = map.get('DryRun')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateDedicatedHostClusterRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_cluster_name = map.get('DedicatedHostClusterName')
        self.description = map.get('Description')
        return self


class CreateDedicatedHostClusterRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CreateDedicatedHostClusterResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_cluster_id=None):
        self.request_id = request_id    # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        return self


class DescribeDeploymentSetSupportedInstanceTypeFamilyRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        return self


class DescribeDeploymentSetSupportedInstanceTypeFamilyResponse(TeaModel):
    def __init__(self, request_id=None, instance_type_families=None):
        self.request_id = request_id    # type: str
        self.instance_type_families = instance_type_families  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_type_families, 'instance_type_families')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InstanceTypeFamilies'] = self.instance_type_families
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.instance_type_families = map.get('InstanceTypeFamilies')
        return self


class DescribeNetworkInterfaceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, network_interface_id=None, attribute=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[DescribeNetworkInterfaceAttributeRequestTag]
        self.network_interface_id = network_interface_id  # type: str
        self.attribute = attribute      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Attribute'] = self.attribute
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfaceAttributeRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.attribute = map.get('Attribute')
        return self


class DescribeNetworkInterfaceAttributeRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeNetworkInterfaceAttributeResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_id=None, status=None, type=None, vpc_id=None,
                 v_switch_id=None, zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None,
                 description=None, instance_id=None, creation_time=None, resource_group_id=None, service_id=None,
                 service_managed=None, queue_number=None, owner_id=None, private_ip_sets=None, ipv_6sets=None, tags=None,
                 associated_public_ip=None, attachment=None, security_group_ids=None):
        self.request_id = request_id    # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.status = status            # type: str
        self.type = type                # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.zone_id = zone_id          # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.mac_address = mac_address  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str
        self.creation_time = creation_time  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.service_id = service_id    # type: int
        self.service_managed = service_managed  # type: bool
        self.queue_number = queue_number  # type: int
        self.owner_id = owner_id        # type: str
        self.private_ip_sets = private_ip_sets  # type: DescribeNetworkInterfaceAttributeResponsePrivateIpSets
        self.ipv_6sets = ipv_6sets      # type: DescribeNetworkInterfaceAttributeResponseIpv6Sets
        self.tags = tags                # type: DescribeNetworkInterfaceAttributeResponseTags
        self.associated_public_ip = associated_public_ip  # type: DescribeNetworkInterfaceAttributeResponseAssociatedPublicIp
        self.attachment = attachment    # type: DescribeNetworkInterfaceAttributeResponseAttachment
        self.security_group_ids = security_group_ids  # type: DescribeNetworkInterfaceAttributeResponseSecurityGroupIds

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.queue_number, 'queue_number')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.ipv_6sets, 'ipv_6sets')
        if self.ipv_6sets:
            self.ipv_6sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()
        self.validate_required(self.attachment, 'attachment')
        if self.attachment:
            self.attachment.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Status'] = self.status
        result['Type'] = self.type
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['ZoneId'] = self.zone_id
        result['PrivateIpAddress'] = self.private_ip_address
        result['MacAddress'] = self.mac_address
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['InstanceId'] = self.instance_id
        result['CreationTime'] = self.creation_time
        result['ResourceGroupId'] = self.resource_group_id
        result['ServiceID'] = self.service_id
        result['ServiceManaged'] = self.service_managed
        result['QueueNumber'] = self.queue_number
        result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        else:
            result['PrivateIpSets'] = None
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        else:
            result['Ipv6Sets'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        else:
            result['AssociatedPublicIp'] = None
        if self.attachment is not None:
            result['Attachment'] = self.attachment.to_map()
        else:
            result['Attachment'] = None
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        else:
            result['SecurityGroupIds'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.status = map.get('Status')
        self.type = map.get('Type')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.zone_id = map.get('ZoneId')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.mac_address = map.get('MacAddress')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.instance_id = map.get('InstanceId')
        self.creation_time = map.get('CreationTime')
        self.resource_group_id = map.get('ResourceGroupId')
        self.service_id = map.get('ServiceID')
        self.service_managed = map.get('ServiceManaged')
        self.queue_number = map.get('QueueNumber')
        self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        else:
            self.private_ip_sets = None
        if map.get('Ipv6Sets') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseIpv6Sets()
            self.ipv_6sets = temp_model.from_map(map['Ipv6Sets'])
        else:
            self.ipv_6sets = None
        if map.get('Tags') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        else:
            self.associated_public_ip = None
        if map.get('Attachment') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAttachment()
            self.attachment = temp_model.from_map(map['Attachment'])
        else:
            self.attachment = None
        if map.get('SecurityGroupIds') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        else:
            self.security_group_ids = None
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address  # type: str
        self.allocation_id = allocation_id  # type: str

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        result['PublicIpAddress'] = self.public_ip_address
        result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        self.public_ip_address = map.get('PublicIpAddress')
        self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None, associated_public_ip=None):
        self.private_ip_address = private_ip_address  # type: str
        self.primary = primary          # type: bool
        self.associated_public_ip = associated_public_ip  # type: DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSetAssociatedPublicIp

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()

    def to_map(self):
        result = {}
        result['PrivateIpAddress'] = self.private_ip_address
        result['Primary'] = self.primary
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        else:
            result['AssociatedPublicIp'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_address = map.get('PrivateIpAddress')
        self.primary = map.get('Primary')
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        else:
            self.associated_public_ip = None
        return self


class DescribeNetworkInterfaceAttributeResponsePrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set  # type: List[DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSet]

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        else:
            result['PrivateIpSet'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = DescribeNetworkInterfaceAttributeResponsePrivateIpSetsPrivateIpSet()
                self.private_ip_set.append(temp_model.from_map(k))
        else:
            self.private_ip_set = None
        return self


class DescribeNetworkInterfaceAttributeResponseIpv6SetsIpv6Set(TeaModel):
    def __init__(self, ipv_6address=None):
        self.ipv_6address = ipv_6address  # type: str

    def validate(self):
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, map={}):
        self.ipv_6address = map.get('Ipv6Address')
        return self


class DescribeNetworkInterfaceAttributeResponseIpv6Sets(TeaModel):
    def __init__(self, ipv_6set=None):
        self.ipv_6set = ipv_6set        # type: List[DescribeNetworkInterfaceAttributeResponseIpv6SetsIpv6Set]

    def validate(self):
        self.validate_required(self.ipv_6set, 'ipv_6set')
        if self.ipv_6set:
            for k in self.ipv_6set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Ipv6Set'] = []
        if self.ipv_6set is not None:
            for k in self.ipv_6set:
                result['Ipv6Set'].append(k.to_map() if k else None)
        else:
            result['Ipv6Set'] = None
        return result

    def from_map(self, map={}):
        self.ipv_6set = []
        if map.get('Ipv6Set') is not None:
            for k in map.get('Ipv6Set'):
                temp_model = DescribeNetworkInterfaceAttributeResponseIpv6SetsIpv6Set()
                self.ipv_6set.append(temp_model.from_map(k))
        else:
            self.ipv_6set = None
        return self


class DescribeNetworkInterfaceAttributeResponseTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeNetworkInterfaceAttributeResponseTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeNetworkInterfaceAttributeResponseTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfaceAttributeResponseTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeNetworkInterfaceAttributeResponseAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address  # type: str
        self.allocation_id = allocation_id  # type: str

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        result['PublicIpAddress'] = self.public_ip_address
        result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        self.public_ip_address = map.get('PublicIpAddress')
        self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfaceAttributeResponseAttachmentMemberNetworkInterfaceIds(TeaModel):
    def __init__(self, member_network_interface_id=None):
        # MemberNetworkInterfaceId
        self.member_network_interface_id = member_network_interface_id  # type: List[str]

    def validate(self):
        self.validate_required(self.member_network_interface_id, 'member_network_interface_id')

    def to_map(self):
        result = {}
        result['MemberNetworkInterfaceId'] = self.member_network_interface_id
        return result

    def from_map(self, map={}):
        self.member_network_interface_id = map.get('MemberNetworkInterfaceId')
        return self


class DescribeNetworkInterfaceAttributeResponseAttachment(TeaModel):
    def __init__(self, instance_id=None, trunk_network_interface_id=None, device_index=None,
                 member_network_interface_ids=None):
        self.instance_id = instance_id  # type: str
        self.trunk_network_interface_id = trunk_network_interface_id  # type: str
        self.device_index = device_index  # type: int
        self.member_network_interface_ids = member_network_interface_ids  # type: DescribeNetworkInterfaceAttributeResponseAttachmentMemberNetworkInterfaceIds

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.trunk_network_interface_id, 'trunk_network_interface_id')
        self.validate_required(self.device_index, 'device_index')
        self.validate_required(self.member_network_interface_ids, 'member_network_interface_ids')
        if self.member_network_interface_ids:
            self.member_network_interface_ids.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['TrunkNetworkInterfaceId'] = self.trunk_network_interface_id
        result['DeviceIndex'] = self.device_index
        if self.member_network_interface_ids is not None:
            result['MemberNetworkInterfaceIds'] = self.member_network_interface_ids.to_map()
        else:
            result['MemberNetworkInterfaceIds'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.trunk_network_interface_id = map.get('TrunkNetworkInterfaceId')
        self.device_index = map.get('DeviceIndex')
        if map.get('MemberNetworkInterfaceIds') is not None:
            temp_model = DescribeNetworkInterfaceAttributeResponseAttachmentMemberNetworkInterfaceIds()
            self.member_network_interface_ids = temp_model.from_map(map['MemberNetworkInterfaceIds'])
        else:
            self.member_network_interface_ids = None
        return self


class DescribeNetworkInterfaceAttributeResponseSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id  # type: List[str]

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        self.security_group_id = map.get('SecurityGroupId')
        return self


class CopySnapshotRequest(TeaModel):
    def __init__(self, tag=None, resource_group_id=None, region_id=None, destination_region_id=None,
                 snapshot_id=None, destination_snapshot_name=None, destination_snapshot_description=None, retention_days=None):
        self.tag = tag                  # type: List[CopySnapshotRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.region_id = region_id      # type: str
        self.destination_region_id = destination_region_id  # type: str
        self.snapshot_id = snapshot_id  # type: str
        self.destination_snapshot_name = destination_snapshot_name  # type: str
        self.destination_snapshot_description = destination_snapshot_description  # type: str
        self.retention_days = retention_days  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.destination_region_id, 'destination_region_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.destination_snapshot_name, 'destination_snapshot_name')
        self.validate_required(self.destination_snapshot_description, 'destination_snapshot_description')

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['RegionId'] = self.region_id
        result['DestinationRegionId'] = self.destination_region_id
        result['SnapshotId'] = self.snapshot_id
        result['DestinationSnapshotName'] = self.destination_snapshot_name
        result['DestinationSnapshotDescription'] = self.destination_snapshot_description
        result['RetentionDays'] = self.retention_days
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CopySnapshotRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.region_id = map.get('RegionId')
        self.destination_region_id = map.get('DestinationRegionId')
        self.snapshot_id = map.get('SnapshotId')
        self.destination_snapshot_name = map.get('DestinationSnapshotName')
        self.destination_snapshot_description = map.get('DestinationSnapshotDescription')
        self.retention_days = map.get('RetentionDays')
        return self


class CopySnapshotRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CopySnapshotResponse(TeaModel):
    def __init__(self, request_id=None, snapshot_id=None):
        self.request_id = request_id    # type: str
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.snapshot_id = map.get('SnapshotId')
        return self


class ModifyDedicatedHostsChargeTypeRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, period=None, period_unit=None, dry_run=None,
                 auto_pay=None, dedicated_host_charge_type=None, client_token=None, detail_fee=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.region_id = region_id      # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.dry_run = dry_run          # type: bool
        self.auto_pay = auto_pay        # type: bool
        self.dedicated_host_charge_type = dedicated_host_charge_type  # type: str
        self.client_token = client_token  # type: str
        self.detail_fee = detail_fee    # type: bool

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['RegionId'] = self.region_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['DryRun'] = self.dry_run
        result['AutoPay'] = self.auto_pay
        result['DedicatedHostChargeType'] = self.dedicated_host_charge_type
        result['ClientToken'] = self.client_token
        result['DetailFee'] = self.detail_fee
        return result

    def from_map(self, map={}):
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.region_id = map.get('RegionId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.dry_run = map.get('DryRun')
        self.auto_pay = map.get('AutoPay')
        self.dedicated_host_charge_type = map.get('DedicatedHostChargeType')
        self.client_token = map.get('ClientToken')
        self.detail_fee = map.get('DetailFee')
        return self


class ModifyDedicatedHostsChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, fee_of_instances=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str
        self.fee_of_instances = fee_of_instances  # type: ModifyDedicatedHostsChargeTypeResponseFeeOfInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.fee_of_instances, 'fee_of_instances')
        if self.fee_of_instances:
            self.fee_of_instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        if self.fee_of_instances is not None:
            result['FeeOfInstances'] = self.fee_of_instances.to_map()
        else:
            result['FeeOfInstances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        if map.get('FeeOfInstances') is not None:
            temp_model = ModifyDedicatedHostsChargeTypeResponseFeeOfInstances()
            self.fee_of_instances = temp_model.from_map(map['FeeOfInstances'])
        else:
            self.fee_of_instances = None
        return self


class ModifyDedicatedHostsChargeTypeResponseFeeOfInstancesFeeOfInstance(TeaModel):
    def __init__(self, instance_id=None, fee=None, currency=None):
        self.instance_id = instance_id  # type: str
        self.fee = fee                  # type: str
        self.currency = currency        # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.fee, 'fee')
        self.validate_required(self.currency, 'currency')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Fee'] = self.fee
        result['Currency'] = self.currency
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.fee = map.get('Fee')
        self.currency = map.get('Currency')
        return self


class ModifyDedicatedHostsChargeTypeResponseFeeOfInstances(TeaModel):
    def __init__(self, fee_of_instance=None):
        self.fee_of_instance = fee_of_instance  # type: List[ModifyDedicatedHostsChargeTypeResponseFeeOfInstancesFeeOfInstance]

    def validate(self):
        self.validate_required(self.fee_of_instance, 'fee_of_instance')
        if self.fee_of_instance:
            for k in self.fee_of_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['FeeOfInstance'] = []
        if self.fee_of_instance is not None:
            for k in self.fee_of_instance:
                result['FeeOfInstance'].append(k.to_map() if k else None)
        else:
            result['FeeOfInstance'] = None
        return result

    def from_map(self, map={}):
        self.fee_of_instance = []
        if map.get('FeeOfInstance') is not None:
            for k in map.get('FeeOfInstance'):
                temp_model = ModifyDedicatedHostsChargeTypeResponseFeeOfInstancesFeeOfInstance()
                self.fee_of_instance.append(temp_model.from_map(k))
        else:
            self.fee_of_instance = None
        return self


class ModifyInstanceMetadataOptionsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, http_endpoint=None, http_tokens=None,
                 http_put_response_hop_limit=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.http_endpoint = http_endpoint  # type: str
        self.http_tokens = http_tokens  # type: str
        self.http_put_response_hop_limit = http_put_response_hop_limit  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.http_endpoint, 'http_endpoint')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['HttpEndpoint'] = self.http_endpoint
        result['HttpTokens'] = self.http_tokens
        result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.http_endpoint = map.get('HttpEndpoint')
        self.http_tokens = map.get('HttpTokens')
        self.http_put_response_hop_limit = map.get('HttpPutResponseHopLimit')
        return self


class ModifyInstanceMetadataOptionsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeImageFromFamilyRequest(TeaModel):
    def __init__(self, region_id=None, image_family=None):
        self.region_id = region_id      # type: str
        self.image_family = image_family  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.image_family, 'image_family')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ImageFamily'] = self.image_family
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.image_family = map.get('ImageFamily')
        return self


class DescribeImageFromFamilyResponse(TeaModel):
    def __init__(self, request_id=None, image=None):
        self.request_id = request_id    # type: str
        self.image = image              # type: DescribeImageFromFamilyResponseImage

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.image, 'image')
        if self.image:
            self.image.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.image is not None:
            result['Image'] = self.image.to_map()
        else:
            result['Image'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Image') is not None:
            temp_model = DescribeImageFromFamilyResponseImage()
            self.image = temp_model.from_map(map['Image'])
        else:
            self.image = None
        return self


class DescribeImageFromFamilyResponseImageDiskDeviceMappingsDiskDeviceMapping(TeaModel):
    def __init__(self, snapshot_id=None, size=None, device=None, type=None, format=None, import_ossbucket=None,
                 import_ossobject=None):
        self.snapshot_id = snapshot_id  # type: str
        self.size = size                # type: str
        self.device = device            # type: str
        self.type = type                # type: str
        self.format = format            # type: str
        self.import_ossbucket = import_ossbucket  # type: str
        self.import_ossobject = import_ossobject  # type: str

    def validate(self):
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.size, 'size')
        self.validate_required(self.device, 'device')
        self.validate_required(self.type, 'type')
        self.validate_required(self.format, 'format')
        self.validate_required(self.import_ossbucket, 'import_ossbucket')
        self.validate_required(self.import_ossobject, 'import_ossobject')

    def to_map(self):
        result = {}
        result['SnapshotId'] = self.snapshot_id
        result['Size'] = self.size
        result['Device'] = self.device
        result['Type'] = self.type
        result['Format'] = self.format
        result['ImportOSSBucket'] = self.import_ossbucket
        result['ImportOSSObject'] = self.import_ossobject
        return result

    def from_map(self, map={}):
        self.snapshot_id = map.get('SnapshotId')
        self.size = map.get('Size')
        self.device = map.get('Device')
        self.type = map.get('Type')
        self.format = map.get('Format')
        self.import_ossbucket = map.get('ImportOSSBucket')
        self.import_ossobject = map.get('ImportOSSObject')
        return self


class DescribeImageFromFamilyResponseImageDiskDeviceMappings(TeaModel):
    def __init__(self, disk_device_mapping=None):
        self.disk_device_mapping = disk_device_mapping  # type: List[DescribeImageFromFamilyResponseImageDiskDeviceMappingsDiskDeviceMapping]

    def validate(self):
        self.validate_required(self.disk_device_mapping, 'disk_device_mapping')
        if self.disk_device_mapping:
            for k in self.disk_device_mapping:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskDeviceMapping'] = []
        if self.disk_device_mapping is not None:
            for k in self.disk_device_mapping:
                result['DiskDeviceMapping'].append(k.to_map() if k else None)
        else:
            result['DiskDeviceMapping'] = None
        return result

    def from_map(self, map={}):
        self.disk_device_mapping = []
        if map.get('DiskDeviceMapping') is not None:
            for k in map.get('DiskDeviceMapping'):
                temp_model = DescribeImageFromFamilyResponseImageDiskDeviceMappingsDiskDeviceMapping()
                self.disk_device_mapping.append(temp_model.from_map(k))
        else:
            self.disk_device_mapping = None
        return self


class DescribeImageFromFamilyResponseImageTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeImageFromFamilyResponseImageTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeImageFromFamilyResponseImageTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeImageFromFamilyResponseImageTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeImageFromFamilyResponseImage(TeaModel):
    def __init__(self, progress=None, image_id=None, image_name=None, image_family=None, image_version=None,
                 description=None, size=None, image_owner_alias=None, is_support_io_optimized=None, is_support_cloudinit=None,
                 osname=None, architecture=None, status=None, product_code=None, is_subscribed=None, creation_time=None,
                 is_self_shared=None, ostype=None, platform=None, usage=None, is_copied=None, disk_device_mappings=None, tags=None):
        self.progress = progress        # type: str
        self.image_id = image_id        # type: str
        self.image_name = image_name    # type: str
        self.image_family = image_family  # type: str
        self.image_version = image_version  # type: str
        self.description = description  # type: str
        self.size = size                # type: int
        self.image_owner_alias = image_owner_alias  # type: str
        self.is_support_io_optimized = is_support_io_optimized  # type: bool
        self.is_support_cloudinit = is_support_cloudinit  # type: bool
        self.osname = osname            # type: str
        self.architecture = architecture  # type: str
        self.status = status            # type: str
        self.product_code = product_code  # type: str
        self.is_subscribed = is_subscribed  # type: bool
        self.creation_time = creation_time  # type: str
        self.is_self_shared = is_self_shared  # type: str
        self.ostype = ostype            # type: str
        self.platform = platform        # type: str
        self.usage = usage              # type: str
        self.is_copied = is_copied      # type: bool
        self.disk_device_mappings = disk_device_mappings  # type: DescribeImageFromFamilyResponseImageDiskDeviceMappings
        self.tags = tags                # type: DescribeImageFromFamilyResponseImageTags

    def validate(self):
        self.validate_required(self.progress, 'progress')
        self.validate_required(self.image_id, 'image_id')
        self.validate_required(self.image_name, 'image_name')
        self.validate_required(self.image_family, 'image_family')
        self.validate_required(self.image_version, 'image_version')
        self.validate_required(self.description, 'description')
        self.validate_required(self.size, 'size')
        self.validate_required(self.image_owner_alias, 'image_owner_alias')
        self.validate_required(self.is_support_io_optimized, 'is_support_io_optimized')
        self.validate_required(self.is_support_cloudinit, 'is_support_cloudinit')
        self.validate_required(self.osname, 'osname')
        self.validate_required(self.architecture, 'architecture')
        self.validate_required(self.status, 'status')
        self.validate_required(self.product_code, 'product_code')
        self.validate_required(self.is_subscribed, 'is_subscribed')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.is_self_shared, 'is_self_shared')
        self.validate_required(self.ostype, 'ostype')
        self.validate_required(self.platform, 'platform')
        self.validate_required(self.usage, 'usage')
        self.validate_required(self.is_copied, 'is_copied')
        self.validate_required(self.disk_device_mappings, 'disk_device_mappings')
        if self.disk_device_mappings:
            self.disk_device_mappings.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['Progress'] = self.progress
        result['ImageId'] = self.image_id
        result['ImageName'] = self.image_name
        result['ImageFamily'] = self.image_family
        result['ImageVersion'] = self.image_version
        result['Description'] = self.description
        result['Size'] = self.size
        result['ImageOwnerAlias'] = self.image_owner_alias
        result['IsSupportIoOptimized'] = self.is_support_io_optimized
        result['IsSupportCloudinit'] = self.is_support_cloudinit
        result['OSName'] = self.osname
        result['Architecture'] = self.architecture
        result['Status'] = self.status
        result['ProductCode'] = self.product_code
        result['IsSubscribed'] = self.is_subscribed
        result['CreationTime'] = self.creation_time
        result['IsSelfShared'] = self.is_self_shared
        result['OSType'] = self.ostype
        result['Platform'] = self.platform
        result['Usage'] = self.usage
        result['IsCopied'] = self.is_copied
        if self.disk_device_mappings is not None:
            result['DiskDeviceMappings'] = self.disk_device_mappings.to_map()
        else:
            result['DiskDeviceMappings'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.progress = map.get('Progress')
        self.image_id = map.get('ImageId')
        self.image_name = map.get('ImageName')
        self.image_family = map.get('ImageFamily')
        self.image_version = map.get('ImageVersion')
        self.description = map.get('Description')
        self.size = map.get('Size')
        self.image_owner_alias = map.get('ImageOwnerAlias')
        self.is_support_io_optimized = map.get('IsSupportIoOptimized')
        self.is_support_cloudinit = map.get('IsSupportCloudinit')
        self.osname = map.get('OSName')
        self.architecture = map.get('Architecture')
        self.status = map.get('Status')
        self.product_code = map.get('ProductCode')
        self.is_subscribed = map.get('IsSubscribed')
        self.creation_time = map.get('CreationTime')
        self.is_self_shared = map.get('IsSelfShared')
        self.ostype = map.get('OSType')
        self.platform = map.get('Platform')
        self.usage = map.get('Usage')
        self.is_copied = map.get('IsCopied')
        if map.get('DiskDeviceMappings') is not None:
            temp_model = DescribeImageFromFamilyResponseImageDiskDeviceMappings()
            self.disk_device_mappings = temp_model.from_map(map['DiskDeviceMappings'])
        else:
            self.disk_device_mappings = None
        if map.get('Tags') is not None:
            temp_model = DescribeImageFromFamilyResponseImageTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class StopInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, force_stop=None, stopped_mode=None,
                 batch_optimization=None):
        self.dry_run = dry_run          # type: bool
        self.instance_id = instance_id  # type: List[str]
        self.region_id = region_id      # type: str
        self.force_stop = force_stop    # type: bool
        self.stopped_mode = stopped_mode  # type: str
        self.batch_optimization = batch_optimization  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DryRun'] = self.dry_run
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['ForceStop'] = self.force_stop
        result['StoppedMode'] = self.stopped_mode
        result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        self.dry_run = map.get('DryRun')
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.force_stop = map.get('ForceStop')
        self.stopped_mode = map.get('StoppedMode')
        self.batch_optimization = map.get('BatchOptimization')
        return self


class StopInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id    # type: str
        self.instance_responses = instance_responses  # type: StopInstancesResponseInstanceResponses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        else:
            result['InstanceResponses'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = StopInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        else:
            self.instance_responses = None
        return self


class StopInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.previous_status = previous_status  # type: str
        self.current_status = current_status  # type: str
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['PreviousStatus'] = self.previous_status
        result['CurrentStatus'] = self.current_status
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.previous_status = map.get('PreviousStatus')
        self.current_status = map.get('CurrentStatus')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class StopInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response  # type: List[StopInstancesResponseInstanceResponsesInstanceResponse]

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        else:
            result['InstanceResponse'] = None
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = StopInstancesResponseInstanceResponsesInstanceResponse()
                self.instance_response.append(temp_model.from_map(k))
        else:
            self.instance_response = None
        return self


class StartInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, batch_optimization=None):
        self.dry_run = dry_run          # type: bool
        self.instance_id = instance_id  # type: List[str]
        self.region_id = region_id      # type: str
        self.batch_optimization = batch_optimization  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DryRun'] = self.dry_run
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        self.dry_run = map.get('DryRun')
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.batch_optimization = map.get('BatchOptimization')
        return self


class StartInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id    # type: str
        self.instance_responses = instance_responses  # type: StartInstancesResponseInstanceResponses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        else:
            result['InstanceResponses'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = StartInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        else:
            self.instance_responses = None
        return self


class StartInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.previous_status = previous_status  # type: str
        self.current_status = current_status  # type: str
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['PreviousStatus'] = self.previous_status
        result['CurrentStatus'] = self.current_status
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.previous_status = map.get('PreviousStatus')
        self.current_status = map.get('CurrentStatus')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class StartInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response  # type: List[StartInstancesResponseInstanceResponsesInstanceResponse]

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        else:
            result['InstanceResponse'] = None
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = StartInstancesResponseInstanceResponsesInstanceResponse()
                self.instance_response.append(temp_model.from_map(k))
        else:
            self.instance_response = None
        return self


class RebootInstancesRequest(TeaModel):
    def __init__(self, dry_run=None, instance_id=None, region_id=None, force_reboot=None, batch_optimization=None):
        self.dry_run = dry_run          # type: bool
        self.instance_id = instance_id  # type: List[str]
        self.region_id = region_id      # type: str
        self.force_reboot = force_reboot  # type: bool
        self.batch_optimization = batch_optimization  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DryRun'] = self.dry_run
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['ForceReboot'] = self.force_reboot
        result['BatchOptimization'] = self.batch_optimization
        return result

    def from_map(self, map={}):
        self.dry_run = map.get('DryRun')
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.force_reboot = map.get('ForceReboot')
        self.batch_optimization = map.get('BatchOptimization')
        return self


class RebootInstancesResponse(TeaModel):
    def __init__(self, request_id=None, instance_responses=None):
        self.request_id = request_id    # type: str
        self.instance_responses = instance_responses  # type: RebootInstancesResponseInstanceResponses

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_responses, 'instance_responses')
        if self.instance_responses:
            self.instance_responses.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_responses is not None:
            result['InstanceResponses'] = self.instance_responses.to_map()
        else:
            result['InstanceResponses'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceResponses') is not None:
            temp_model = RebootInstancesResponseInstanceResponses()
            self.instance_responses = temp_model.from_map(map['InstanceResponses'])
        else:
            self.instance_responses = None
        return self


class RebootInstancesResponseInstanceResponsesInstanceResponse(TeaModel):
    def __init__(self, instance_id=None, previous_status=None, current_status=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.previous_status = previous_status  # type: str
        self.current_status = current_status  # type: str
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.previous_status, 'previous_status')
        self.validate_required(self.current_status, 'current_status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['PreviousStatus'] = self.previous_status
        result['CurrentStatus'] = self.current_status
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.previous_status = map.get('PreviousStatus')
        self.current_status = map.get('CurrentStatus')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class RebootInstancesResponseInstanceResponses(TeaModel):
    def __init__(self, instance_response=None):
        self.instance_response = instance_response  # type: List[RebootInstancesResponseInstanceResponsesInstanceResponse]

    def validate(self):
        self.validate_required(self.instance_response, 'instance_response')
        if self.instance_response:
            for k in self.instance_response:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceResponse'] = []
        if self.instance_response is not None:
            for k in self.instance_response:
                result['InstanceResponse'].append(k.to_map() if k else None)
        else:
            result['InstanceResponse'] = None
        return result

    def from_map(self, map={}):
        self.instance_response = []
        if map.get('InstanceResponse') is not None:
            for k in map.get('InstanceResponse'):
                temp_model = RebootInstancesResponseInstanceResponsesInstanceResponse()
                self.instance_response.append(temp_model.from_map(k))
        else:
            self.instance_response = None
        return self


class RedeployDedicatedHostRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class RedeployDedicatedHostResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyInstanceMaintenanceAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, maintenance_window=None, action_on_maintenance=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.maintenance_window = maintenance_window  # type: List[ModifyInstanceMaintenanceAttributesRequestMaintenanceWindow]
        self.action_on_maintenance = action_on_maintenance  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.maintenance_window:
            for k in self.maintenance_window:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['MaintenanceWindow'] = []
        if self.maintenance_window is not None:
            for k in self.maintenance_window:
                result['MaintenanceWindow'].append(k.to_map() if k else None)
        else:
            result['MaintenanceWindow'] = None
        result['ActionOnMaintenance'] = self.action_on_maintenance
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.maintenance_window = []
        if map.get('MaintenanceWindow') is not None:
            for k in map.get('MaintenanceWindow'):
                temp_model = ModifyInstanceMaintenanceAttributesRequestMaintenanceWindow()
                self.maintenance_window.append(temp_model.from_map(k))
        else:
            self.maintenance_window = None
        self.action_on_maintenance = map.get('ActionOnMaintenance')
        return self


class ModifyInstanceMaintenanceAttributesRequestMaintenanceWindow(TeaModel):
    def __init__(self, start_time=None, end_time=None):
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class ModifyInstanceMaintenanceAttributesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstanceMaintenanceAttributesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInstanceMaintenanceAttributesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 maintenance_attributes=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.maintenance_attributes = maintenance_attributes  # type: DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.maintenance_attributes, 'maintenance_attributes')
        if self.maintenance_attributes:
            self.maintenance_attributes.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.maintenance_attributes is not None:
            result['MaintenanceAttributes'] = self.maintenance_attributes.to_map()
        else:
            result['MaintenanceAttributes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('MaintenanceAttributes') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributes()
            self.maintenance_attributes = temp_model.from_map(map['MaintenanceAttributes'])
        else:
            self.maintenance_attributes = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow(TeaModel):
    def __init__(self, start_time=None, end_time=None):
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindows(TeaModel):
    def __init__(self, maintenance_window=None):
        self.maintenance_window = maintenance_window  # type: List[DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow]

    def validate(self):
        self.validate_required(self.maintenance_window, 'maintenance_window')
        if self.maintenance_window:
            for k in self.maintenance_window:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['MaintenanceWindow'] = []
        if self.maintenance_window is not None:
            for k in self.maintenance_window:
                result['MaintenanceWindow'].append(k.to_map() if k else None)
        else:
            result['MaintenanceWindow'] = None
        return result

    def from_map(self, map={}):
        self.maintenance_window = []
        if map.get('MaintenanceWindow') is not None:
            for k in map.get('MaintenanceWindow'):
                temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindowsMaintenanceWindow()
                self.maintenance_window.append(temp_model.from_map(k))
        else:
            self.maintenance_window = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues(TeaModel):
    def __init__(self, supported_value=None):
        # SupportedValue
        self.supported_value = supported_value  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_value, 'supported_value')

    def to_map(self):
        result = {}
        result['SupportedValue'] = self.supported_value
        return result

    def from_map(self, map={}):
        self.supported_value = map.get('SupportedValue')
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenance(TeaModel):
    def __init__(self, value=None, default_value=None, supported_values=None):
        self.value = value              # type: str
        self.default_value = default_value  # type: str
        self.supported_values = supported_values  # type: DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.default_value, 'default_value')
        self.validate_required(self.supported_values, 'supported_values')
        if self.supported_values:
            self.supported_values.validate()

    def to_map(self):
        result = {}
        result['Value'] = self.value
        result['DefaultValue'] = self.default_value
        if self.supported_values is not None:
            result['SupportedValues'] = self.supported_values.to_map()
        else:
            result['SupportedValues'] = None
        return result

    def from_map(self, map={}):
        self.value = map.get('Value')
        self.default_value = map.get('DefaultValue')
        if map.get('SupportedValues') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenanceSupportedValues()
            self.supported_values = temp_model.from_map(map['SupportedValues'])
        else:
            self.supported_values = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttribute(TeaModel):
    def __init__(self, instance_id=None, maintenance_windows=None, action_on_maintenance=None):
        self.instance_id = instance_id  # type: str
        self.maintenance_windows = maintenance_windows  # type: DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindows
        self.action_on_maintenance = action_on_maintenance  # type: DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenance

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.maintenance_windows, 'maintenance_windows')
        if self.maintenance_windows:
            self.maintenance_windows.validate()
        self.validate_required(self.action_on_maintenance, 'action_on_maintenance')
        if self.action_on_maintenance:
            self.action_on_maintenance.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        if self.maintenance_windows is not None:
            result['MaintenanceWindows'] = self.maintenance_windows.to_map()
        else:
            result['MaintenanceWindows'] = None
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance.to_map()
        else:
            result['ActionOnMaintenance'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        if map.get('MaintenanceWindows') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeMaintenanceWindows()
            self.maintenance_windows = temp_model.from_map(map['MaintenanceWindows'])
        else:
            self.maintenance_windows = None
        if map.get('ActionOnMaintenance') is not None:
            temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttributeActionOnMaintenance()
            self.action_on_maintenance = temp_model.from_map(map['ActionOnMaintenance'])
        else:
            self.action_on_maintenance = None
        return self


class DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributes(TeaModel):
    def __init__(self, maintenance_attribute=None):
        self.maintenance_attribute = maintenance_attribute  # type: List[DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttribute]

    def validate(self):
        self.validate_required(self.maintenance_attribute, 'maintenance_attribute')
        if self.maintenance_attribute:
            for k in self.maintenance_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['MaintenanceAttribute'] = []
        if self.maintenance_attribute is not None:
            for k in self.maintenance_attribute:
                result['MaintenanceAttribute'].append(k.to_map() if k else None)
        else:
            result['MaintenanceAttribute'] = None
        return result

    def from_map(self, map={}):
        self.maintenance_attribute = []
        if map.get('MaintenanceAttribute') is not None:
            for k in map.get('MaintenanceAttribute'):
                temp_model = DescribeInstanceMaintenanceAttributesResponseMaintenanceAttributesMaintenanceAttribute()
                self.maintenance_attribute.append(temp_model.from_map(k))
        else:
            self.maintenance_attribute = None
        return self


class ModifyDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, demand_id=None, demand_name=None,
                 demand_description=None, instance_type=None, amount=None, instance_charge_type=None, period=None, period_unit=None,
                 start_time=None, end_time=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.demand_id = demand_id      # type: str
        self.demand_name = demand_name  # type: str
        self.demand_description = demand_description  # type: str
        self.instance_type = instance_type  # type: str
        self.amount = amount            # type: int
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DemandId'] = self.demand_id
        result['DemandName'] = self.demand_name
        result['DemandDescription'] = self.demand_description
        result['InstanceType'] = self.instance_type
        result['Amount'] = self.amount
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.demand_id = map.get('DemandId')
        self.demand_name = map.get('DemandName')
        self.demand_description = map.get('DemandDescription')
        self.instance_type = map.get('InstanceType')
        self.amount = map.get('Amount')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class ModifyDemandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeleteDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, demand_id=None, reason=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.demand_id = demand_id      # type: str
        self.reason = reason            # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['DemandId'] = self.demand_id
        result['Reason'] = self.reason
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.demand_id = map.get('DemandId')
        self.reason = map.get('Reason')
        return self


class DeleteDemandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateDemandRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, demand_name=None, demand_description=None,
                 instance_type=None, amount=None, instance_charge_type=None, period=None, period_unit=None, start_time=None,
                 end_time=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.demand_name = demand_name  # type: str
        self.demand_description = demand_description  # type: str
        self.instance_type = instance_type  # type: str
        self.amount = amount            # type: int
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.period, 'period')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DemandName'] = self.demand_name
        result['DemandDescription'] = self.demand_description
        result['InstanceType'] = self.instance_type
        result['Amount'] = self.amount
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.demand_name = map.get('DemandName')
        self.demand_description = map.get('DemandDescription')
        self.instance_type = map.get('InstanceType')
        self.amount = map.get('Amount')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class CreateDemandResponse(TeaModel):
    def __init__(self, request_id=None, demand_id=None):
        self.request_id = request_id    # type: str
        self.demand_id = demand_id      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.demand_id, 'demand_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['DemandId'] = self.demand_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.demand_id = map.get('DemandId')
        return self


class PurchaseStorageCapacityUnitRequest(TeaModel):
    def __init__(self, region_id=None, name=None, capacity=None, description=None, start_time=None, period=None,
                 period_unit=None, from_app=None, client_token=None, amount=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.capacity = capacity        # type: int
        self.description = description  # type: str
        self.start_time = start_time    # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.from_app = from_app        # type: str
        self.client_token = client_token  # type: str
        self.amount = amount            # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.capacity, 'capacity')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Capacity'] = self.capacity
        result['Description'] = self.description
        result['StartTime'] = self.start_time
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['FromApp'] = self.from_app
        result['ClientToken'] = self.client_token
        result['Amount'] = self.amount
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.capacity = map.get('Capacity')
        self.description = map.get('Description')
        self.start_time = map.get('StartTime')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.from_app = map.get('FromApp')
        self.client_token = map.get('ClientToken')
        self.amount = map.get('Amount')
        return self


class PurchaseStorageCapacityUnitResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, storage_capacity_unit_ids=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str
        self.storage_capacity_unit_ids = storage_capacity_unit_ids  # type: PurchaseStorageCapacityUnitResponseStorageCapacityUnitIds

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.storage_capacity_unit_ids, 'storage_capacity_unit_ids')
        if self.storage_capacity_unit_ids:
            self.storage_capacity_unit_ids.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        if self.storage_capacity_unit_ids is not None:
            result['StorageCapacityUnitIds'] = self.storage_capacity_unit_ids.to_map()
        else:
            result['StorageCapacityUnitIds'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        if map.get('StorageCapacityUnitIds') is not None:
            temp_model = PurchaseStorageCapacityUnitResponseStorageCapacityUnitIds()
            self.storage_capacity_unit_ids = temp_model.from_map(map['StorageCapacityUnitIds'])
        else:
            self.storage_capacity_unit_ids = None
        return self


class PurchaseStorageCapacityUnitResponseStorageCapacityUnitIds(TeaModel):
    def __init__(self, storage_capacity_unit_id=None):
        self.storage_capacity_unit_id = storage_capacity_unit_id  # type: List[str]

    def validate(self):
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')

    def to_map(self):
        result = {}
        result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        return result

    def from_map(self, map={}):
        self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        return self


class ModifyStorageCapacityUnitAttributeRequest(TeaModel):
    def __init__(self, region_id=None, storage_capacity_unit_id=None, name=None, description=None):
        self.region_id = region_id      # type: str
        self.storage_capacity_unit_id = storage_capacity_unit_id  # type: str
        self.name = name                # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        result['Name'] = self.name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        return self


class ModifyStorageCapacityUnitAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeStorageCapacityUnitsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, name=None, capacity=None,
                 storage_capacity_unit_id=None, status=None, allocation_type=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.name = name                # type: str
        self.capacity = capacity        # type: int
        self.storage_capacity_unit_id = storage_capacity_unit_id  # type: List[str]
        self.status = status            # type: List[str]
        self.allocation_type = allocation_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Name'] = self.name
        result['Capacity'] = self.capacity
        result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        result['Status'] = self.status
        result['AllocationType'] = self.allocation_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.name = map.get('Name')
        self.capacity = map.get('Capacity')
        self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        self.status = map.get('Status')
        self.allocation_type = map.get('AllocationType')
        return self


class DescribeStorageCapacityUnitsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 storage_capacity_units=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.storage_capacity_units = storage_capacity_units  # type: DescribeStorageCapacityUnitsResponseStorageCapacityUnits

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.storage_capacity_units, 'storage_capacity_units')
        if self.storage_capacity_units:
            self.storage_capacity_units.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.storage_capacity_units is not None:
            result['StorageCapacityUnits'] = self.storage_capacity_units.to_map()
        else:
            result['StorageCapacityUnits'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('StorageCapacityUnits') is not None:
            temp_model = DescribeStorageCapacityUnitsResponseStorageCapacityUnits()
            self.storage_capacity_units = temp_model.from_map(map['StorageCapacityUnits'])
        else:
            self.storage_capacity_units = None
        return self


class DescribeStorageCapacityUnitsResponseStorageCapacityUnitsStorageCapacityUnit(TeaModel):
    def __init__(self, region_id=None, storage_capacity_unit_id=None, name=None, capacity=None, status=None,
                 creation_time=None, expired_time=None, start_time=None, description=None, allocation_status=None):
        self.region_id = region_id      # type: str
        self.storage_capacity_unit_id = storage_capacity_unit_id  # type: str
        self.name = name                # type: str
        self.capacity = capacity        # type: int
        self.status = status            # type: str
        self.creation_time = creation_time  # type: str
        self.expired_time = expired_time  # type: str
        self.start_time = start_time    # type: str
        self.description = description  # type: str
        self.allocation_status = allocation_status  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_capacity_unit_id, 'storage_capacity_unit_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.capacity, 'capacity')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.description, 'description')
        self.validate_required(self.allocation_status, 'allocation_status')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['StorageCapacityUnitId'] = self.storage_capacity_unit_id
        result['Name'] = self.name
        result['Capacity'] = self.capacity
        result['Status'] = self.status
        result['CreationTime'] = self.creation_time
        result['ExpiredTime'] = self.expired_time
        result['StartTime'] = self.start_time
        result['Description'] = self.description
        result['AllocationStatus'] = self.allocation_status
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.storage_capacity_unit_id = map.get('StorageCapacityUnitId')
        self.name = map.get('Name')
        self.capacity = map.get('Capacity')
        self.status = map.get('Status')
        self.creation_time = map.get('CreationTime')
        self.expired_time = map.get('ExpiredTime')
        self.start_time = map.get('StartTime')
        self.description = map.get('Description')
        self.allocation_status = map.get('AllocationStatus')
        return self


class DescribeStorageCapacityUnitsResponseStorageCapacityUnits(TeaModel):
    def __init__(self, storage_capacity_unit=None):
        self.storage_capacity_unit = storage_capacity_unit  # type: List[DescribeStorageCapacityUnitsResponseStorageCapacityUnitsStorageCapacityUnit]

    def validate(self):
        self.validate_required(self.storage_capacity_unit, 'storage_capacity_unit')
        if self.storage_capacity_unit:
            for k in self.storage_capacity_unit:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['StorageCapacityUnit'] = []
        if self.storage_capacity_unit is not None:
            for k in self.storage_capacity_unit:
                result['StorageCapacityUnit'].append(k.to_map() if k else None)
        else:
            result['StorageCapacityUnit'] = None
        return result

    def from_map(self, map={}):
        self.storage_capacity_unit = []
        if map.get('StorageCapacityUnit') is not None:
            for k in map.get('StorageCapacityUnit'):
                temp_model = DescribeStorageCapacityUnitsResponseStorageCapacityUnitsStorageCapacityUnit()
                self.storage_capacity_unit.append(temp_model.from_map(k))
        else:
            self.storage_capacity_unit = None
        return self


class RunCommandRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, type=None, command_content=None,
                 working_dir=None, timeout=None, enable_parameter=None, timed=None, frequency=None, instance_id=None,
                 parameters=None, keep_command=None, content_encoding=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.type = type                # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int
        self.enable_parameter = enable_parameter  # type: bool
        self.timed = timed              # type: bool
        self.frequency = frequency      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.parameters = parameters    # type: Dict[str, Any]
        self.keep_command = keep_command  # type: bool
        self.content_encoding = content_encoding  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['Type'] = self.type
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        result['EnableParameter'] = self.enable_parameter
        result['Timed'] = self.timed
        result['Frequency'] = self.frequency
        result['InstanceId'] = self.instance_id
        result['Parameters'] = self.parameters
        result['KeepCommand'] = self.keep_command
        result['ContentEncoding'] = self.content_encoding
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.type = map.get('Type')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        self.enable_parameter = map.get('EnableParameter')
        self.timed = map.get('Timed')
        self.frequency = map.get('Frequency')
        self.instance_id = map.get('InstanceId')
        self.parameters = map.get('Parameters')
        self.keep_command = map.get('KeepCommand')
        self.content_encoding = map.get('ContentEncoding')
        return self


class RunCommandShrinkRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, type=None, command_content=None,
                 working_dir=None, timeout=None, enable_parameter=None, timed=None, frequency=None, instance_id=None,
                 parameters_shrink=None, keep_command=None, content_encoding=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.type = type                # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int
        self.enable_parameter = enable_parameter  # type: bool
        self.timed = timed              # type: bool
        self.frequency = frequency      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.parameters_shrink = parameters_shrink  # type: str
        self.keep_command = keep_command  # type: bool
        self.content_encoding = content_encoding  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.type, 'type')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['Type'] = self.type
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        result['EnableParameter'] = self.enable_parameter
        result['Timed'] = self.timed
        result['Frequency'] = self.frequency
        result['InstanceId'] = self.instance_id
        result['Parameters'] = self.parameters_shrink
        result['KeepCommand'] = self.keep_command
        result['ContentEncoding'] = self.content_encoding
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.type = map.get('Type')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        self.enable_parameter = map.get('EnableParameter')
        self.timed = map.get('Timed')
        self.frequency = map.get('Frequency')
        self.instance_id = map.get('InstanceId')
        self.parameters_shrink = map.get('Parameters')
        self.keep_command = map.get('KeepCommand')
        self.content_encoding = map.get('ContentEncoding')
        return self


class RunCommandResponse(TeaModel):
    def __init__(self, request_id=None, command_id=None, invoke_id=None):
        self.request_id = request_id    # type: str
        self.command_id = command_id    # type: str
        self.invoke_id = invoke_id      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['CommandId'] = self.command_id
        result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.command_id = map.get('CommandId')
        self.invoke_id = map.get('InvokeId')
        return self


class DeleteInstancesRequest(TeaModel):
    def __init__(self, instance_id=None, dry_run=None, force=None, terminate_subscription=None, client_token=None,
                 region_id=None):
        self.instance_id = instance_id  # type: List[str]
        self.dry_run = dry_run          # type: bool
        self.force = force              # type: bool
        self.terminate_subscription = terminate_subscription  # type: bool
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['DryRun'] = self.dry_run
        result['Force'] = self.force
        result['TerminateSubscription'] = self.terminate_subscription
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.dry_run = map.get('DryRun')
        self.force = map.get('Force')
        self.terminate_subscription = map.get('TerminateSubscription')
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        return self


class DeleteInstancesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyStorageSetAttributeRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None, storage_set_name=None,
                 description=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_name = storage_set_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['StorageSetId'] = self.storage_set_id
        result['StorageSetName'] = self.storage_set_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.storage_set_id = map.get('StorageSetId')
        self.storage_set_name = map.get('StorageSetName')
        self.description = map.get('Description')
        return self


class ModifyStorageSetAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeStorageSetsRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_ids=None, zone_id=None, storage_set_name=None,
                 page_number=None, page_size=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.storage_set_ids = storage_set_ids  # type: str
        self.zone_id = zone_id          # type: str
        self.storage_set_name = storage_set_name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['StorageSetIds'] = self.storage_set_ids
        result['ZoneId'] = self.zone_id
        result['StorageSetName'] = self.storage_set_name
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.storage_set_ids = map.get('StorageSetIds')
        self.zone_id = map.get('ZoneId')
        self.storage_set_name = map.get('StorageSetName')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeStorageSetsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, storage_sets=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.storage_sets = storage_sets  # type: DescribeStorageSetsResponseStorageSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.storage_sets, 'storage_sets')
        if self.storage_sets:
            self.storage_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.storage_sets is not None:
            result['StorageSets'] = self.storage_sets.to_map()
        else:
            result['StorageSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('StorageSets') is not None:
            temp_model = DescribeStorageSetsResponseStorageSets()
            self.storage_sets = temp_model.from_map(map['StorageSets'])
        else:
            self.storage_sets = None
        return self


class DescribeStorageSetsResponseStorageSetsStorageSet(TeaModel):
    def __init__(self, storage_set_id=None, creation_time=None, storage_set_name=None, description=None,
                 storage_set_partition_number=None, region_id=None, zone_id=None):
        self.storage_set_id = storage_set_id  # type: str
        self.creation_time = creation_time  # type: str
        self.storage_set_name = storage_set_name  # type: str
        self.description = description  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str

    def validate(self):
        self.validate_required(self.storage_set_id, 'storage_set_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.storage_set_name, 'storage_set_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.storage_set_partition_number, 'storage_set_partition_number')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        result['StorageSetId'] = self.storage_set_id
        result['CreationTime'] = self.creation_time
        result['StorageSetName'] = self.storage_set_name
        result['Description'] = self.description
        result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        return result

    def from_map(self, map={}):
        self.storage_set_id = map.get('StorageSetId')
        self.creation_time = map.get('CreationTime')
        self.storage_set_name = map.get('StorageSetName')
        self.description = map.get('Description')
        self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        return self


class DescribeStorageSetsResponseStorageSets(TeaModel):
    def __init__(self, storage_set=None):
        self.storage_set = storage_set  # type: List[DescribeStorageSetsResponseStorageSetsStorageSet]

    def validate(self):
        self.validate_required(self.storage_set, 'storage_set')
        if self.storage_set:
            for k in self.storage_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['StorageSet'] = []
        if self.storage_set is not None:
            for k in self.storage_set:
                result['StorageSet'].append(k.to_map() if k else None)
        else:
            result['StorageSet'] = None
        return result

    def from_map(self, map={}):
        self.storage_set = []
        if map.get('StorageSet') is not None:
            for k in map.get('StorageSet'):
                temp_model = DescribeStorageSetsResponseStorageSetsStorageSet()
                self.storage_set.append(temp_model.from_map(k))
        else:
            self.storage_set = None
        return self


class DescribeStorageSetDetailsRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None, storage_set_partition_number=None,
                 disk_ids=None, page_number=None, page_size=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.disk_ids = disk_ids        # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['StorageSetId'] = self.storage_set_id
        result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['DiskIds'] = self.disk_ids
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.storage_set_id = map.get('StorageSetId')
        self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        self.disk_ids = map.get('DiskIds')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeStorageSetDetailsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, disks=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.disks = disks              # type: DescribeStorageSetDetailsResponseDisks

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.disks, 'disks')
        if self.disks:
            self.disks.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.disks is not None:
            result['Disks'] = self.disks.to_map()
        else:
            result['Disks'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Disks') is not None:
            temp_model = DescribeStorageSetDetailsResponseDisks()
            self.disks = temp_model.from_map(map['Disks'])
        else:
            self.disks = None
        return self


class DescribeStorageSetDetailsResponseDisksDisk(TeaModel):
    def __init__(self, disk_id=None, disk_name=None, category=None, storage_set_id=None, creation_time=None,
                 storage_set_partition_number=None, region_id=None, zone_id=None):
        self.disk_id = disk_id          # type: str
        self.disk_name = disk_name      # type: str
        self.category = category        # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.creation_time = creation_time  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.category, 'category')
        self.validate_required(self.storage_set_id, 'storage_set_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.storage_set_partition_number, 'storage_set_partition_number')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['DiskName'] = self.disk_name
        result['Category'] = self.category
        result['StorageSetId'] = self.storage_set_id
        result['CreationTime'] = self.creation_time
        result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.disk_name = map.get('DiskName')
        self.category = map.get('Category')
        self.storage_set_id = map.get('StorageSetId')
        self.creation_time = map.get('CreationTime')
        self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        return self


class DescribeStorageSetDetailsResponseDisks(TeaModel):
    def __init__(self, disk=None):
        self.disk = disk                # type: List[DescribeStorageSetDetailsResponseDisksDisk]

    def validate(self):
        self.validate_required(self.disk, 'disk')
        if self.disk:
            for k in self.disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Disk'] = []
        if self.disk is not None:
            for k in self.disk:
                result['Disk'].append(k.to_map() if k else None)
        else:
            result['Disk'] = None
        return result

    def from_map(self, map={}):
        self.disk = []
        if map.get('Disk') is not None:
            for k in map.get('Disk'):
                temp_model = DescribeStorageSetDetailsResponseDisksDisk()
                self.disk.append(temp_model.from_map(k))
        else:
            self.disk = None
        return self


class DeleteStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, storage_set_id=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.storage_set_id = storage_set_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.storage_set_id = map.get('StorageSetId')
        return self


class DeleteStorageSetResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, region_id=None, zone_id=None, storage_set_name=None, description=None,
                 max_partition_number=None):
        self.client_token = client_token  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.storage_set_name = storage_set_name  # type: str
        self.description = description  # type: str
        self.max_partition_number = max_partition_number  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')

    def to_map(self):
        result = {}
        result['ClientToken'] = self.client_token
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['StorageSetName'] = self.storage_set_name
        result['Description'] = self.description
        result['MaxPartitionNumber'] = self.max_partition_number
        return result

    def from_map(self, map={}):
        self.client_token = map.get('ClientToken')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.storage_set_name = map.get('StorageSetName')
        self.description = map.get('Description')
        self.max_partition_number = map.get('MaxPartitionNumber')
        return self


class CreateStorageSetResponse(TeaModel):
    def __init__(self, request_id=None, storage_set_id=None):
        self.request_id = request_id    # type: str
        self.storage_set_id = storage_set_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.storage_set_id, 'storage_set_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.storage_set_id = map.get('StorageSetId')
        return self


class ModifyDiskSpecRequest(TeaModel):
    def __init__(self, disk_id=None, performance_level=None, disk_category=None, dry_run=None):
        self.disk_id = disk_id          # type: str
        self.performance_level = performance_level  # type: str
        self.disk_category = disk_category  # type: str
        self.dry_run = dry_run          # type: bool

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['PerformanceLevel'] = self.performance_level
        result['DiskCategory'] = self.disk_category
        result['DryRun'] = self.dry_run
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.performance_level = map.get('PerformanceLevel')
        self.disk_category = map.get('DiskCategory')
        self.dry_run = map.get('DryRun')
        return self


class ModifyDiskSpecResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id    # type: str
        self.task_id = task_id          # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        return self


class ModifyAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, auto_provisioning_group_id=None, excess_capacity_termination_policy=None,
                 default_target_capacity_type=None, terminate_instances_with_expiration=None, max_spot_price=None, total_target_capacity=None,
                 pay_as_you_go_target_capacity=None, spot_target_capacity=None, auto_provisioning_group_name=None):
        self.region_id = region_id      # type: str
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.excess_capacity_termination_policy = excess_capacity_termination_policy  # type: str
        self.default_target_capacity_type = default_target_capacity_type  # type: str
        self.terminate_instances_with_expiration = terminate_instances_with_expiration  # type: bool
        self.max_spot_price = max_spot_price  # type: float
        self.total_target_capacity = total_target_capacity  # type: str
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity  # type: str
        self.spot_target_capacity = spot_target_capacity  # type: str
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        result['MaxSpotPrice'] = self.max_spot_price
        result['TotalTargetCapacity'] = self.total_target_capacity
        result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        result['SpotTargetCapacity'] = self.spot_target_capacity
        result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        self.max_spot_price = map.get('MaxSpotPrice')
        self.total_target_capacity = map.get('TotalTargetCapacity')
        self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        self.spot_target_capacity = map.get('SpotTargetCapacity')
        self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        return self


class ModifyAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeAutoProvisioningGroupsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_id=None, auto_provisioning_group_status=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: List[str]
        self.auto_provisioning_group_status = auto_provisioning_group_status  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['AutoProvisioningGroupStatus'] = self.auto_provisioning_group_status
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.auto_provisioning_group_status = map.get('AutoProvisioningGroupStatus')
        return self


class DescribeAutoProvisioningGroupsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 auto_provisioning_groups=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_groups = auto_provisioning_groups  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroups

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.auto_provisioning_groups, 'auto_provisioning_groups')
        if self.auto_provisioning_groups:
            self.auto_provisioning_groups.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.auto_provisioning_groups is not None:
            result['AutoProvisioningGroups'] = self.auto_provisioning_groups.to_map()
        else:
            result['AutoProvisioningGroups'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroups') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroups()
            self.auto_provisioning_groups = temp_model.from_map(map['AutoProvisioningGroups'])
        else:
            self.auto_provisioning_groups = None
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig(TeaModel):
    def __init__(self, instance_type=None, max_price=None, v_switch_id=None, weighted_capacity=None, priority=None):
        self.instance_type = instance_type  # type: str
        self.max_price = max_price      # type: float
        self.v_switch_id = v_switch_id  # type: str
        self.weighted_capacity = weighted_capacity  # type: float
        self.priority = priority        # type: float

    def validate(self):
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.max_price, 'max_price')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.weighted_capacity, 'weighted_capacity')
        self.validate_required(self.priority, 'priority')

    def to_map(self):
        result = {}
        result['InstanceType'] = self.instance_type
        result['MaxPrice'] = self.max_price
        result['VSwitchId'] = self.v_switch_id
        result['WeightedCapacity'] = self.weighted_capacity
        result['Priority'] = self.priority
        return result

    def from_map(self, map={}):
        self.instance_type = map.get('InstanceType')
        self.max_price = map.get('MaxPrice')
        self.v_switch_id = map.get('VSwitchId')
        self.weighted_capacity = map.get('WeightedCapacity')
        self.priority = map.get('Priority')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs(TeaModel):
    def __init__(self, launch_template_config=None):
        self.launch_template_config = launch_template_config  # type: List[DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig]

    def validate(self):
        self.validate_required(self.launch_template_config, 'launch_template_config')
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        else:
            result['LaunchTemplateConfig'] = None
        return result

    def from_map(self, map={}):
        self.launch_template_config = []
        if map.get('LaunchTemplateConfig') is not None:
            for k in map.get('LaunchTemplateConfig'):
                temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig()
                self.launch_template_config.append(temp_model.from_map(k))
        else:
            self.launch_template_config = None
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupSpotOptions(TeaModel):
    def __init__(self, allocation_strategy=None, instance_interruption_behavior=None,
                 instance_pools_to_use_count=None):
        self.allocation_strategy = allocation_strategy  # type: str
        self.instance_interruption_behavior = instance_interruption_behavior  # type: str
        self.instance_pools_to_use_count = instance_pools_to_use_count  # type: int

    def validate(self):
        self.validate_required(self.allocation_strategy, 'allocation_strategy')
        self.validate_required(self.instance_interruption_behavior, 'instance_interruption_behavior')
        self.validate_required(self.instance_pools_to_use_count, 'instance_pools_to_use_count')

    def to_map(self):
        result = {}
        result['AllocationStrategy'] = self.allocation_strategy
        result['InstanceInterruptionBehavior'] = self.instance_interruption_behavior
        result['InstancePoolsToUseCount'] = self.instance_pools_to_use_count
        return result

    def from_map(self, map={}):
        self.allocation_strategy = map.get('AllocationStrategy')
        self.instance_interruption_behavior = map.get('InstanceInterruptionBehavior')
        self.instance_pools_to_use_count = map.get('InstancePoolsToUseCount')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions(TeaModel):
    def __init__(self, allocation_strategy=None):
        self.allocation_strategy = allocation_strategy  # type: str

    def validate(self):
        self.validate_required(self.allocation_strategy, 'allocation_strategy')

    def to_map(self):
        result = {}
        result['AllocationStrategy'] = self.allocation_strategy
        return result

    def from_map(self, map={}):
        self.allocation_strategy = map.get('AllocationStrategy')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification(TeaModel):
    def __init__(self, total_target_capacity=None, pay_as_you_go_target_capacity=None, spot_target_capacity=None,
                 default_target_capacity_type=None):
        self.total_target_capacity = total_target_capacity  # type: float
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity  # type: float
        self.spot_target_capacity = spot_target_capacity  # type: float
        self.default_target_capacity_type = default_target_capacity_type  # type: str

    def validate(self):
        self.validate_required(self.total_target_capacity, 'total_target_capacity')
        self.validate_required(self.pay_as_you_go_target_capacity, 'pay_as_you_go_target_capacity')
        self.validate_required(self.spot_target_capacity, 'spot_target_capacity')
        self.validate_required(self.default_target_capacity_type, 'default_target_capacity_type')

    def to_map(self):
        result = {}
        result['TotalTargetCapacity'] = self.total_target_capacity
        result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        result['SpotTargetCapacity'] = self.spot_target_capacity
        result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        return result

    def from_map(self, map={}):
        self.total_target_capacity = map.get('TotalTargetCapacity')
        self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        self.spot_target_capacity = map.get('SpotTargetCapacity')
        self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroup(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_type=None, status=None, state=None, region_id=None, valid_from=None, valid_until=None,
                 excess_capacity_termination_policy=None, max_spot_price=None, launch_template_id=None, launch_template_version=None,
                 terminate_instances=None, terminate_instances_with_expiration=None, creation_time=None, launch_template_configs=None,
                 spot_options=None, pay_as_you_go_options=None, target_capacity_specification=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_type = auto_provisioning_group_type  # type: str
        self.status = status            # type: str
        self.state = state              # type: str
        self.region_id = region_id      # type: str
        self.valid_from = valid_from    # type: str
        self.valid_until = valid_until  # type: str
        self.excess_capacity_termination_policy = excess_capacity_termination_policy  # type: str
        self.max_spot_price = max_spot_price  # type: float
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_version = launch_template_version  # type: str
        self.terminate_instances = terminate_instances  # type: bool
        self.terminate_instances_with_expiration = terminate_instances_with_expiration  # type: bool
        self.creation_time = creation_time  # type: str
        self.launch_template_configs = launch_template_configs  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs
        self.spot_options = spot_options  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupSpotOptions
        self.pay_as_you_go_options = pay_as_you_go_options  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions
        self.target_capacity_specification = target_capacity_specification  # type: DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification

    def validate(self):
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')
        self.validate_required(self.auto_provisioning_group_name, 'auto_provisioning_group_name')
        self.validate_required(self.auto_provisioning_group_type, 'auto_provisioning_group_type')
        self.validate_required(self.status, 'status')
        self.validate_required(self.state, 'state')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.valid_from, 'valid_from')
        self.validate_required(self.valid_until, 'valid_until')
        self.validate_required(self.excess_capacity_termination_policy, 'excess_capacity_termination_policy')
        self.validate_required(self.max_spot_price, 'max_spot_price')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_version, 'launch_template_version')
        self.validate_required(self.terminate_instances, 'terminate_instances')
        self.validate_required(self.terminate_instances_with_expiration, 'terminate_instances_with_expiration')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.launch_template_configs, 'launch_template_configs')
        if self.launch_template_configs:
            self.launch_template_configs.validate()
        self.validate_required(self.spot_options, 'spot_options')
        if self.spot_options:
            self.spot_options.validate()
        self.validate_required(self.pay_as_you_go_options, 'pay_as_you_go_options')
        if self.pay_as_you_go_options:
            self.pay_as_you_go_options.validate()
        self.validate_required(self.target_capacity_specification, 'target_capacity_specification')
        if self.target_capacity_specification:
            self.target_capacity_specification.validate()

    def to_map(self):
        result = {}
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        result['Status'] = self.status
        result['State'] = self.state
        result['RegionId'] = self.region_id
        result['ValidFrom'] = self.valid_from
        result['ValidUntil'] = self.valid_until
        result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        result['MaxSpotPrice'] = self.max_spot_price
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateVersion'] = self.launch_template_version
        result['TerminateInstances'] = self.terminate_instances
        result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        result['CreationTime'] = self.creation_time
        if self.launch_template_configs is not None:
            result['LaunchTemplateConfigs'] = self.launch_template_configs.to_map()
        else:
            result['LaunchTemplateConfigs'] = None
        if self.spot_options is not None:
            result['SpotOptions'] = self.spot_options.to_map()
        else:
            result['SpotOptions'] = None
        if self.pay_as_you_go_options is not None:
            result['PayAsYouGoOptions'] = self.pay_as_you_go_options.to_map()
        else:
            result['PayAsYouGoOptions'] = None
        if self.target_capacity_specification is not None:
            result['TargetCapacitySpecification'] = self.target_capacity_specification.to_map()
        else:
            result['TargetCapacitySpecification'] = None
        return result

    def from_map(self, map={}):
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        self.auto_provisioning_group_type = map.get('AutoProvisioningGroupType')
        self.status = map.get('Status')
        self.state = map.get('State')
        self.region_id = map.get('RegionId')
        self.valid_from = map.get('ValidFrom')
        self.valid_until = map.get('ValidUntil')
        self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        self.max_spot_price = map.get('MaxSpotPrice')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_version = map.get('LaunchTemplateVersion')
        self.terminate_instances = map.get('TerminateInstances')
        self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        self.creation_time = map.get('CreationTime')
        if map.get('LaunchTemplateConfigs') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs()
            self.launch_template_configs = temp_model.from_map(map['LaunchTemplateConfigs'])
        else:
            self.launch_template_configs = None
        if map.get('SpotOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupSpotOptions()
            self.spot_options = temp_model.from_map(map['SpotOptions'])
        else:
            self.spot_options = None
        if map.get('PayAsYouGoOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions()
            self.pay_as_you_go_options = temp_model.from_map(map['PayAsYouGoOptions'])
        else:
            self.pay_as_you_go_options = None
        if map.get('TargetCapacitySpecification') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification()
            self.target_capacity_specification = temp_model.from_map(map['TargetCapacitySpecification'])
        else:
            self.target_capacity_specification = None
        return self


class DescribeAutoProvisioningGroupsResponseAutoProvisioningGroups(TeaModel):
    def __init__(self, auto_provisioning_group=None):
        self.auto_provisioning_group = auto_provisioning_group  # type: List[DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroup]

    def validate(self):
        self.validate_required(self.auto_provisioning_group, 'auto_provisioning_group')
        if self.auto_provisioning_group:
            for k in self.auto_provisioning_group:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AutoProvisioningGroup'] = []
        if self.auto_provisioning_group is not None:
            for k in self.auto_provisioning_group:
                result['AutoProvisioningGroup'].append(k.to_map() if k else None)
        else:
            result['AutoProvisioningGroup'] = None
        return result

    def from_map(self, map={}):
        self.auto_provisioning_group = []
        if map.get('AutoProvisioningGroup') is not None:
            for k in map.get('AutoProvisioningGroup'):
                temp_model = DescribeAutoProvisioningGroupsResponseAutoProvisioningGroupsAutoProvisioningGroup()
                self.auto_provisioning_group.append(temp_model.from_map(k))
        else:
            self.auto_provisioning_group = None
        return self


class DescribeAutoProvisioningGroupInstancesRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_id=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        return self


class DescribeAutoProvisioningGroupInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, instances=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.instances = instances      # type: DescribeAutoProvisioningGroupInstancesResponseInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            self.instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        else:
            result['Instances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Instances') is not None:
            temp_model = DescribeAutoProvisioningGroupInstancesResponseInstances()
            self.instances = temp_model.from_map(map['Instances'])
        else:
            self.instances = None
        return self


class DescribeAutoProvisioningGroupInstancesResponseInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, status=None, region_id=None, zone_id=None, cpu=None, memory=None,
                 instance_type=None, is_spot=None, io_optimized=None, network_type=None, os_type=None, creation_time=None):
        self.instance_id = instance_id  # type: str
        self.status = status            # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.cpu = cpu                  # type: int
        self.memory = memory            # type: int
        self.instance_type = instance_type  # type: str
        self.is_spot = is_spot          # type: bool
        self.io_optimized = io_optimized  # type: bool
        self.network_type = network_type  # type: str
        self.os_type = os_type          # type: str
        self.creation_time = creation_time  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.cpu, 'cpu')
        self.validate_required(self.memory, 'memory')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.is_spot, 'is_spot')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.os_type, 'os_type')
        self.validate_required(self.creation_time, 'creation_time')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Status'] = self.status
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['CPU'] = self.cpu
        result['Memory'] = self.memory
        result['InstanceType'] = self.instance_type
        result['IsSpot'] = self.is_spot
        result['IoOptimized'] = self.io_optimized
        result['NetworkType'] = self.network_type
        result['OsType'] = self.os_type
        result['CreationTime'] = self.creation_time
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.status = map.get('Status')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.cpu = map.get('CPU')
        self.memory = map.get('Memory')
        self.instance_type = map.get('InstanceType')
        self.is_spot = map.get('IsSpot')
        self.io_optimized = map.get('IoOptimized')
        self.network_type = map.get('NetworkType')
        self.os_type = map.get('OsType')
        self.creation_time = map.get('CreationTime')
        return self


class DescribeAutoProvisioningGroupInstancesResponseInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance        # type: List[DescribeAutoProvisioningGroupInstancesResponseInstancesInstance]

    def validate(self):
        self.validate_required(self.instance, 'instance')
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        else:
            result['Instance'] = None
        return result

    def from_map(self, map={}):
        self.instance = []
        if map.get('Instance') is not None:
            for k in map.get('Instance'):
                temp_model = DescribeAutoProvisioningGroupInstancesResponseInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        else:
            self.instance = None
        return self


class DeleteAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, auto_provisioning_group_id=None, terminate_instances=None):
        self.region_id = region_id      # type: str
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.terminate_instances = terminate_instances  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')
        self.validate_required(self.terminate_instances, 'terminate_instances')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['TerminateInstances'] = self.terminate_instances
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.terminate_instances = map.get('TerminateInstances')
        return self


class DeleteAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, region_id=None, resource_group_id=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_type=None, spot_allocation_strategy=None, spot_instance_interruption_behavior=None,
                 spot_instance_pools_to_use_count=None, pay_as_you_go_allocation_strategy=None, excess_capacity_termination_policy=None,
                 valid_from=None, valid_until=None, terminate_instances_with_expiration=None, terminate_instances=None,
                 max_spot_price=None, total_target_capacity=None, pay_as_you_go_target_capacity=None, spot_target_capacity=None,
                 default_target_capacity_type=None, launch_template_id=None, launch_template_version=None, launch_template_config=None,
                 description=None):
        self.region_id = region_id      # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_type = auto_provisioning_group_type  # type: str
        self.spot_allocation_strategy = spot_allocation_strategy  # type: str
        self.spot_instance_interruption_behavior = spot_instance_interruption_behavior  # type: str
        self.spot_instance_pools_to_use_count = spot_instance_pools_to_use_count  # type: int
        self.pay_as_you_go_allocation_strategy = pay_as_you_go_allocation_strategy  # type: str
        self.excess_capacity_termination_policy = excess_capacity_termination_policy  # type: str
        self.valid_from = valid_from    # type: str
        self.valid_until = valid_until  # type: str
        self.terminate_instances_with_expiration = terminate_instances_with_expiration  # type: bool
        self.terminate_instances = terminate_instances  # type: bool
        self.max_spot_price = max_spot_price  # type: float
        self.total_target_capacity = total_target_capacity  # type: str
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity  # type: str
        self.spot_target_capacity = spot_target_capacity  # type: str
        self.default_target_capacity_type = default_target_capacity_type  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_version = launch_template_version  # type: str
        self.launch_template_config = launch_template_config  # type: List[CreateAutoProvisioningGroupRequestLaunchTemplateConfig]
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_target_capacity, 'total_target_capacity')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceGroupId'] = self.resource_group_id
        result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        result['SpotAllocationStrategy'] = self.spot_allocation_strategy
        result['SpotInstanceInterruptionBehavior'] = self.spot_instance_interruption_behavior
        result['SpotInstancePoolsToUseCount'] = self.spot_instance_pools_to_use_count
        result['PayAsYouGoAllocationStrategy'] = self.pay_as_you_go_allocation_strategy
        result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        result['ValidFrom'] = self.valid_from
        result['ValidUntil'] = self.valid_until
        result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        result['TerminateInstances'] = self.terminate_instances
        result['MaxSpotPrice'] = self.max_spot_price
        result['TotalTargetCapacity'] = self.total_target_capacity
        result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        result['SpotTargetCapacity'] = self.spot_target_capacity
        result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateVersion'] = self.launch_template_version
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        else:
            result['LaunchTemplateConfig'] = None
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_group_id = map.get('ResourceGroupId')
        self.auto_provisioning_group_name = map.get('AutoProvisioningGroupName')
        self.auto_provisioning_group_type = map.get('AutoProvisioningGroupType')
        self.spot_allocation_strategy = map.get('SpotAllocationStrategy')
        self.spot_instance_interruption_behavior = map.get('SpotInstanceInterruptionBehavior')
        self.spot_instance_pools_to_use_count = map.get('SpotInstancePoolsToUseCount')
        self.pay_as_you_go_allocation_strategy = map.get('PayAsYouGoAllocationStrategy')
        self.excess_capacity_termination_policy = map.get('ExcessCapacityTerminationPolicy')
        self.valid_from = map.get('ValidFrom')
        self.valid_until = map.get('ValidUntil')
        self.terminate_instances_with_expiration = map.get('TerminateInstancesWithExpiration')
        self.terminate_instances = map.get('TerminateInstances')
        self.max_spot_price = map.get('MaxSpotPrice')
        self.total_target_capacity = map.get('TotalTargetCapacity')
        self.pay_as_you_go_target_capacity = map.get('PayAsYouGoTargetCapacity')
        self.spot_target_capacity = map.get('SpotTargetCapacity')
        self.default_target_capacity_type = map.get('DefaultTargetCapacityType')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_version = map.get('LaunchTemplateVersion')
        self.launch_template_config = []
        if map.get('LaunchTemplateConfig') is not None:
            for k in map.get('LaunchTemplateConfig'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchTemplateConfig()
                self.launch_template_config.append(temp_model.from_map(k))
        else:
            self.launch_template_config = None
        self.description = map.get('Description')
        return self


class CreateAutoProvisioningGroupRequestLaunchTemplateConfig(TeaModel):
    def __init__(self, instance_type=None, max_price=None, v_switch_id=None, weighted_capacity=None, priority=None):
        self.instance_type = instance_type  # type: str
        self.max_price = max_price      # type: float
        self.v_switch_id = v_switch_id  # type: str
        self.weighted_capacity = weighted_capacity  # type: float
        self.priority = priority        # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['InstanceType'] = self.instance_type
        result['MaxPrice'] = self.max_price
        result['VSwitchId'] = self.v_switch_id
        result['WeightedCapacity'] = self.weighted_capacity
        result['Priority'] = self.priority
        return result

    def from_map(self, map={}):
        self.instance_type = map.get('InstanceType')
        self.max_price = map.get('MaxPrice')
        self.v_switch_id = map.get('VSwitchId')
        self.weighted_capacity = map.get('WeightedCapacity')
        self.priority = map.get('Priority')
        return self


class CreateAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, request_id=None, auto_provisioning_group_id=None):
        self.request_id = request_id    # type: str
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        return self


class DescribeAutoProvisioningGroupHistoryRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, auto_provisioning_group_id=None,
                 start_time=None, end_time=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_provisioning_group_id, 'auto_provisioning_group_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.auto_provisioning_group_id = map.get('AutoProvisioningGroupId')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class DescribeAutoProvisioningGroupHistoryResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 auto_provisioning_group_histories=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_provisioning_group_histories = auto_provisioning_group_histories  # type: DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistories

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.auto_provisioning_group_histories, 'auto_provisioning_group_histories')
        if self.auto_provisioning_group_histories:
            self.auto_provisioning_group_histories.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.auto_provisioning_group_histories is not None:
            result['AutoProvisioningGroupHistories'] = self.auto_provisioning_group_histories.to_map()
        else:
            result['AutoProvisioningGroupHistories'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('AutoProvisioningGroupHistories') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistories()
            self.auto_provisioning_group_histories = temp_model.from_map(map['AutoProvisioningGroupHistories'])
        else:
            self.auto_provisioning_group_histories = None
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail(TeaModel):
    def __init__(self, detail=None, status=None):
        self.detail = detail            # type: str
        self.status = status            # type: str

    def validate(self):
        self.validate_required(self.detail, 'detail')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = {}
        result['Detail'] = self.detail
        result['Status'] = self.status
        return result

    def from_map(self, map={}):
        self.detail = map.get('Detail')
        self.status = map.get('Status')
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails(TeaModel):
    def __init__(self, activity_detail=None):
        self.activity_detail = activity_detail  # type: List[DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail]

    def validate(self):
        self.validate_required(self.activity_detail, 'activity_detail')
        if self.activity_detail:
            for k in self.activity_detail:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ActivityDetail'] = []
        if self.activity_detail is not None:
            for k in self.activity_detail:
                result['ActivityDetail'].append(k.to_map() if k else None)
        else:
            result['ActivityDetail'] = None
        return result

    def from_map(self, map={}):
        self.activity_detail = []
        if map.get('ActivityDetail') is not None:
            for k in map.get('ActivityDetail'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail()
                self.activity_detail.append(temp_model.from_map(k))
        else:
            self.activity_detail = None
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory(TeaModel):
    def __init__(self, task_id=None, status=None, last_event_time=None, start_time=None, activity_details=None):
        self.task_id = task_id          # type: str
        self.status = status            # type: str
        self.last_event_time = last_event_time  # type: str
        self.start_time = start_time    # type: str
        self.activity_details = activity_details  # type: DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails

    def validate(self):
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.last_event_time, 'last_event_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.activity_details, 'activity_details')
        if self.activity_details:
            self.activity_details.validate()

    def to_map(self):
        result = {}
        result['TaskId'] = self.task_id
        result['Status'] = self.status
        result['LastEventTime'] = self.last_event_time
        result['StartTime'] = self.start_time
        if self.activity_details is not None:
            result['ActivityDetails'] = self.activity_details.to_map()
        else:
            result['ActivityDetails'] = None
        return result

    def from_map(self, map={}):
        self.task_id = map.get('TaskId')
        self.status = map.get('Status')
        self.last_event_time = map.get('LastEventTime')
        self.start_time = map.get('StartTime')
        if map.get('ActivityDetails') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails()
            self.activity_details = temp_model.from_map(map['ActivityDetails'])
        else:
            self.activity_details = None
        return self


class DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistories(TeaModel):
    def __init__(self, auto_provisioning_group_history=None):
        self.auto_provisioning_group_history = auto_provisioning_group_history  # type: List[DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory]

    def validate(self):
        self.validate_required(self.auto_provisioning_group_history, 'auto_provisioning_group_history')
        if self.auto_provisioning_group_history:
            for k in self.auto_provisioning_group_history:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AutoProvisioningGroupHistory'] = []
        if self.auto_provisioning_group_history is not None:
            for k in self.auto_provisioning_group_history:
                result['AutoProvisioningGroupHistory'].append(k.to_map() if k else None)
        else:
            result['AutoProvisioningGroupHistory'] = None
        return result

    def from_map(self, map={}):
        self.auto_provisioning_group_history = []
        if map.get('AutoProvisioningGroupHistory') is not None:
            for k in map.get('AutoProvisioningGroupHistory'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory()
                self.auto_provisioning_group_history.append(temp_model.from_map(k))
        else:
            self.auto_provisioning_group_history = None
        return self


class ReportInstancesStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, disk_id=None, device=None, reason=None, description=None,
                 start_time=None, end_time=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.disk_id = disk_id          # type: List[str]
        self.device = device            # type: List[str]
        self.reason = reason            # type: str
        self.description = description  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['DiskId'] = self.disk_id
        result['Device'] = self.device
        result['Reason'] = self.reason
        result['Description'] = self.description
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.disk_id = map.get('DiskId')
        self.device = map.get('Device')
        self.reason = map.get('Reason')
        self.description = map.get('Description')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        return self


class ReportInstancesStatusResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyReservedInstanceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, reserved_instance_id=None, reserved_instance_name=None, description=None):
        self.region_id = region_id      # type: str
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ReservedInstanceId'] = self.reserved_instance_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.reserved_instance_id = map.get('ReservedInstanceId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.description = map.get('Description')
        return self


class ModifyReservedInstanceAttributeResponse(TeaModel):
    def __init__(self, request_id=None, code=None, message=None, http_status_code=None):
        self.request_id = request_id    # type: str
        self.code = code                # type: str
        self.message = message          # type: str
        self.http_status_code = http_status_code  # type: int

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.http_status_code, 'http_status_code')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['Code'] = self.code
        result['Message'] = self.message
        result['HttpStatusCode'] = self.http_status_code
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.code = map.get('Code')
        self.message = map.get('Message')
        self.http_status_code = map.get('HttpStatusCode')
        return self


class PurchaseReservedInstancesOfferingRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, zone_id=None, reserved_instance_name=None,
                 instance_type=None, scope=None, instance_amount=None, offering_type=None, description=None, platform=None,
                 period=None, period_unit=None, client_token=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[PurchaseReservedInstancesOfferingRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.zone_id = zone_id          # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.scope = scope              # type: str
        self.instance_amount = instance_amount  # type: int
        self.offering_type = offering_type  # type: str
        self.description = description  # type: str
        self.platform = platform        # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['ZoneId'] = self.zone_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['InstanceType'] = self.instance_type
        result['Scope'] = self.scope
        result['InstanceAmount'] = self.instance_amount
        result['OfferingType'] = self.offering_type
        result['Description'] = self.description
        result['Platform'] = self.platform
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = PurchaseReservedInstancesOfferingRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.zone_id = map.get('ZoneId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.instance_type = map.get('InstanceType')
        self.scope = map.get('Scope')
        self.instance_amount = map.get('InstanceAmount')
        self.offering_type = map.get('OfferingType')
        self.description = map.get('Description')
        self.platform = map.get('Platform')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.client_token = map.get('ClientToken')
        return self


class PurchaseReservedInstancesOfferingRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class PurchaseReservedInstancesOfferingResponse(TeaModel):
    def __init__(self, request_id=None, reserved_instance_id_sets=None):
        self.request_id = request_id    # type: str
        self.reserved_instance_id_sets = reserved_instance_id_sets  # type: PurchaseReservedInstancesOfferingResponseReservedInstanceIdSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.reserved_instance_id_sets, 'reserved_instance_id_sets')
        if self.reserved_instance_id_sets:
            self.reserved_instance_id_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.reserved_instance_id_sets is not None:
            result['ReservedInstanceIdSets'] = self.reserved_instance_id_sets.to_map()
        else:
            result['ReservedInstanceIdSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('ReservedInstanceIdSets') is not None:
            temp_model = PurchaseReservedInstancesOfferingResponseReservedInstanceIdSets()
            self.reserved_instance_id_sets = temp_model.from_map(map['ReservedInstanceIdSets'])
        else:
            self.reserved_instance_id_sets = None
        return self


class PurchaseReservedInstancesOfferingResponseReservedInstanceIdSets(TeaModel):
    def __init__(self, reserved_instance_id=None):
        self.reserved_instance_id = reserved_instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        result['ReservedInstanceId'] = self.reserved_instance_id
        return result

    def from_map(self, map={}):
        self.reserved_instance_id = map.get('ReservedInstanceId')
        return self


class ModifyReservedInstancesRequest(TeaModel):
    def __init__(self, region_id=None, reserved_instance_id=None, configuration=None):
        self.region_id = region_id      # type: str
        self.reserved_instance_id = reserved_instance_id  # type: List[str]
        self.configuration = configuration  # type: List[ModifyReservedInstancesRequestConfiguration]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')
        if self.configuration:
            for k in self.configuration:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ReservedInstanceId'] = self.reserved_instance_id
        result['Configuration'] = []
        if self.configuration is not None:
            for k in self.configuration:
                result['Configuration'].append(k.to_map() if k else None)
        else:
            result['Configuration'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.reserved_instance_id = map.get('ReservedInstanceId')
        self.configuration = []
        if map.get('Configuration') is not None:
            for k in map.get('Configuration'):
                temp_model = ModifyReservedInstancesRequestConfiguration()
                self.configuration.append(temp_model.from_map(k))
        else:
            self.configuration = None
        return self


class ModifyReservedInstancesRequestConfiguration(TeaModel):
    def __init__(self, zone_id=None, reserved_instance_name=None, instance_type=None, scope=None,
                 instance_amount=None):
        self.zone_id = zone_id          # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.scope = scope              # type: str
        self.instance_amount = instance_amount  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['ZoneId'] = self.zone_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['InstanceType'] = self.instance_type
        result['Scope'] = self.scope
        result['InstanceAmount'] = self.instance_amount
        return result

    def from_map(self, map={}):
        self.zone_id = map.get('ZoneId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.instance_type = map.get('InstanceType')
        self.scope = map.get('Scope')
        self.instance_amount = map.get('InstanceAmount')
        return self


class ModifyReservedInstancesResponse(TeaModel):
    def __init__(self, request_id=None, reserved_instance_id_sets=None):
        self.request_id = request_id    # type: str
        self.reserved_instance_id_sets = reserved_instance_id_sets  # type: ModifyReservedInstancesResponseReservedInstanceIdSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.reserved_instance_id_sets, 'reserved_instance_id_sets')
        if self.reserved_instance_id_sets:
            self.reserved_instance_id_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.reserved_instance_id_sets is not None:
            result['ReservedInstanceIdSets'] = self.reserved_instance_id_sets.to_map()
        else:
            result['ReservedInstanceIdSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('ReservedInstanceIdSets') is not None:
            temp_model = ModifyReservedInstancesResponseReservedInstanceIdSets()
            self.reserved_instance_id_sets = temp_model.from_map(map['ReservedInstanceIdSets'])
        else:
            self.reserved_instance_id_sets = None
        return self


class ModifyReservedInstancesResponseReservedInstanceIdSets(TeaModel):
    def __init__(self, reserved_instance_id=None):
        self.reserved_instance_id = reserved_instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')

    def to_map(self):
        result = {}
        result['ReservedInstanceId'] = self.reserved_instance_id
        return result

    def from_map(self, map={}):
        self.reserved_instance_id = map.get('ReservedInstanceId')
        return self


class DescribeReservedInstancesRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, page_number=None, page_size=None, zone_id=None,
                 reserved_instance_id=None, reserved_instance_name=None, status=None, lock_reason=None, instance_type=None,
                 instance_type_family=None, scope=None, offering_type=None, allocation_type=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[DescribeReservedInstancesRequestTag]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.zone_id = zone_id          # type: str
        self.reserved_instance_id = reserved_instance_id  # type: List[str]
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.status = status            # type: List[str]
        self.lock_reason = lock_reason  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.scope = scope              # type: str
        self.offering_type = offering_type  # type: str
        self.allocation_type = allocation_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['ZoneId'] = self.zone_id
        result['ReservedInstanceId'] = self.reserved_instance_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['Status'] = self.status
        result['LockReason'] = self.lock_reason
        result['InstanceType'] = self.instance_type
        result['InstanceTypeFamily'] = self.instance_type_family
        result['Scope'] = self.scope
        result['OfferingType'] = self.offering_type
        result['AllocationType'] = self.allocation_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeReservedInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.zone_id = map.get('ZoneId')
        self.reserved_instance_id = map.get('ReservedInstanceId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.status = map.get('Status')
        self.lock_reason = map.get('LockReason')
        self.instance_type = map.get('InstanceType')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.scope = map.get('Scope')
        self.offering_type = map.get('OfferingType')
        self.allocation_type = map.get('AllocationType')
        return self


class DescribeReservedInstancesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeReservedInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, reserved_instances=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.reserved_instances = reserved_instances  # type: DescribeReservedInstancesResponseReservedInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.reserved_instances, 'reserved_instances')
        if self.reserved_instances:
            self.reserved_instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.reserved_instances is not None:
            result['ReservedInstances'] = self.reserved_instances.to_map()
        else:
            result['ReservedInstances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('ReservedInstances') is not None:
            temp_model = DescribeReservedInstancesResponseReservedInstances()
            self.reserved_instances = temp_model.from_map(map['ReservedInstances'])
        else:
            self.reserved_instances = None
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocksOperationLock(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason  # type: str

    def validate(self):
        self.validate_required(self.lock_reason, 'lock_reason')

    def to_map(self):
        result = {}
        result['LockReason'] = self.lock_reason
        return result

    def from_map(self, map={}):
        self.lock_reason = map.get('LockReason')
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocks(TeaModel):
    def __init__(self, operation_lock=None):
        self.operation_lock = operation_lock  # type: List[DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocksOperationLock]

    def validate(self):
        self.validate_required(self.operation_lock, 'operation_lock')
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        else:
            result['OperationLock'] = None
        return result

    def from_map(self, map={}):
        self.operation_lock = []
        if map.get('OperationLock') is not None:
            for k in map.get('OperationLock'):
                temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocksOperationLock()
                self.operation_lock.append(temp_model.from_map(k))
        else:
            self.operation_lock = None
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstanceTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeReservedInstancesResponseReservedInstancesReservedInstanceTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeReservedInstancesResponseReservedInstancesReservedInstance(TeaModel):
    def __init__(self, reserved_instance_id=None, region_id=None, zone_id=None, reserved_instance_name=None,
                 description=None, instance_type=None, scope=None, offering_type=None, platform=None, instance_amount=None,
                 status=None, creation_time=None, expired_time=None, start_time=None, resource_group_id=None,
                 allocation_status=None, operation_locks=None, tags=None):
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.reserved_instance_name = reserved_instance_name  # type: str
        self.description = description  # type: str
        self.instance_type = instance_type  # type: str
        self.scope = scope              # type: str
        self.offering_type = offering_type  # type: str
        self.platform = platform        # type: str
        self.instance_amount = instance_amount  # type: int
        self.status = status            # type: str
        self.creation_time = creation_time  # type: str
        self.expired_time = expired_time  # type: str
        self.start_time = start_time    # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.allocation_status = allocation_status  # type: str
        self.operation_locks = operation_locks  # type: DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocks
        self.tags = tags                # type: DescribeReservedInstancesResponseReservedInstancesReservedInstanceTags

    def validate(self):
        self.validate_required(self.reserved_instance_id, 'reserved_instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.reserved_instance_name, 'reserved_instance_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.scope, 'scope')
        self.validate_required(self.offering_type, 'offering_type')
        self.validate_required(self.platform, 'platform')
        self.validate_required(self.instance_amount, 'instance_amount')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.allocation_status, 'allocation_status')
        self.validate_required(self.operation_locks, 'operation_locks')
        if self.operation_locks:
            self.operation_locks.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['ReservedInstanceId'] = self.reserved_instance_id
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['ReservedInstanceName'] = self.reserved_instance_name
        result['Description'] = self.description
        result['InstanceType'] = self.instance_type
        result['Scope'] = self.scope
        result['OfferingType'] = self.offering_type
        result['Platform'] = self.platform
        result['InstanceAmount'] = self.instance_amount
        result['Status'] = self.status
        result['CreationTime'] = self.creation_time
        result['ExpiredTime'] = self.expired_time
        result['StartTime'] = self.start_time
        result['ResourceGroupId'] = self.resource_group_id
        result['AllocationStatus'] = self.allocation_status
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        else:
            result['OperationLocks'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.reserved_instance_id = map.get('ReservedInstanceId')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.reserved_instance_name = map.get('ReservedInstanceName')
        self.description = map.get('Description')
        self.instance_type = map.get('InstanceType')
        self.scope = map.get('Scope')
        self.offering_type = map.get('OfferingType')
        self.platform = map.get('Platform')
        self.instance_amount = map.get('InstanceAmount')
        self.status = map.get('Status')
        self.creation_time = map.get('CreationTime')
        self.expired_time = map.get('ExpiredTime')
        self.start_time = map.get('StartTime')
        self.resource_group_id = map.get('ResourceGroupId')
        self.allocation_status = map.get('AllocationStatus')
        if map.get('OperationLocks') is not None:
            temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceOperationLocks()
            self.operation_locks = temp_model.from_map(map['OperationLocks'])
        else:
            self.operation_locks = None
        if map.get('Tags') is not None:
            temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstanceTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeReservedInstancesResponseReservedInstances(TeaModel):
    def __init__(self, reserved_instance=None):
        self.reserved_instance = reserved_instance  # type: List[DescribeReservedInstancesResponseReservedInstancesReservedInstance]

    def validate(self):
        self.validate_required(self.reserved_instance, 'reserved_instance')
        if self.reserved_instance:
            for k in self.reserved_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ReservedInstance'] = []
        if self.reserved_instance is not None:
            for k in self.reserved_instance:
                result['ReservedInstance'].append(k.to_map() if k else None)
        else:
            result['ReservedInstance'] = None
        return result

    def from_map(self, map={}):
        self.reserved_instance = []
        if map.get('ReservedInstance') is not None:
            for k in map.get('ReservedInstance'):
                temp_model = DescribeReservedInstancesResponseReservedInstancesReservedInstance()
                self.reserved_instance.append(temp_model.from_map(k))
        else:
            self.reserved_instance = None
        return self


class DescribeDemandsRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, page_number=None, page_size=None, dry_run=None, zone_id=None,
                 demand_id=None, instance_type_family=None, instance_type=None, instance_charge_type=None, demand_type=None,
                 demand_status=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[DescribeDemandsRequestTag]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.dry_run = dry_run          # type: bool
        self.zone_id = zone_id          # type: str
        self.demand_id = demand_id      # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.demand_type = demand_type  # type: str
        self.demand_status = demand_status  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['DryRun'] = self.dry_run
        result['ZoneId'] = self.zone_id
        result['DemandId'] = self.demand_id
        result['InstanceTypeFamily'] = self.instance_type_family
        result['InstanceType'] = self.instance_type
        result['InstanceChargeType'] = self.instance_charge_type
        result['DemandType'] = self.demand_type
        result['DemandStatus'] = self.demand_status
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDemandsRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.dry_run = map.get('DryRun')
        self.zone_id = map.get('ZoneId')
        self.demand_id = map.get('DemandId')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.instance_type = map.get('InstanceType')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.demand_type = map.get('DemandType')
        self.demand_status = map.get('DemandStatus')
        return self


class DescribeDemandsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeDemandsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, region_id=None,
                 demands=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.region_id = region_id      # type: str
        self.demands = demands          # type: DescribeDemandsResponseDemands

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.demands, 'demands')
        if self.demands:
            self.demands.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['RegionId'] = self.region_id
        if self.demands is not None:
            result['Demands'] = self.demands.to_map()
        else:
            result['Demands'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.region_id = map.get('RegionId')
        if map.get('Demands') is not None:
            temp_model = DescribeDemandsResponseDemands()
            self.demands = temp_model.from_map(map['Demands'])
        else:
            self.demands = None
        return self


class DescribeDemandsResponseDemandsDemandSupplyInfosSupplyInfo(TeaModel):
    def __init__(self, amount=None, supply_status=None, supply_start_time=None, supply_end_time=None):
        self.amount = amount            # type: int
        self.supply_status = supply_status  # type: str
        self.supply_start_time = supply_start_time  # type: str
        self.supply_end_time = supply_end_time  # type: str

    def validate(self):
        self.validate_required(self.amount, 'amount')
        self.validate_required(self.supply_status, 'supply_status')
        self.validate_required(self.supply_start_time, 'supply_start_time')
        self.validate_required(self.supply_end_time, 'supply_end_time')

    def to_map(self):
        result = {}
        result['Amount'] = self.amount
        result['SupplyStatus'] = self.supply_status
        result['SupplyStartTime'] = self.supply_start_time
        result['SupplyEndTime'] = self.supply_end_time
        return result

    def from_map(self, map={}):
        self.amount = map.get('Amount')
        self.supply_status = map.get('SupplyStatus')
        self.supply_start_time = map.get('SupplyStartTime')
        self.supply_end_time = map.get('SupplyEndTime')
        return self


class DescribeDemandsResponseDemandsDemandSupplyInfos(TeaModel):
    def __init__(self, supply_info=None):
        self.supply_info = supply_info  # type: List[DescribeDemandsResponseDemandsDemandSupplyInfosSupplyInfo]

    def validate(self):
        self.validate_required(self.supply_info, 'supply_info')
        if self.supply_info:
            for k in self.supply_info:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupplyInfo'] = []
        if self.supply_info is not None:
            for k in self.supply_info:
                result['SupplyInfo'].append(k.to_map() if k else None)
        else:
            result['SupplyInfo'] = None
        return result

    def from_map(self, map={}):
        self.supply_info = []
        if map.get('SupplyInfo') is not None:
            for k in map.get('SupplyInfo'):
                temp_model = DescribeDemandsResponseDemandsDemandSupplyInfosSupplyInfo()
                self.supply_info.append(temp_model.from_map(k))
        else:
            self.supply_info = None
        return self


class DescribeDemandsResponseDemandsDemand(TeaModel):
    def __init__(self, zone_id=None, demand_time=None, instance_type_family=None, demand_id=None, demand_name=None,
                 comment=None, demand_description=None, instance_type=None, instance_charge_type=None, period=None,
                 period_unit=None, start_time=None, end_time=None, demand_status=None, total_amount=None, available_amount=None,
                 used_amount=None, delivering_amount=None, supply_infos=None):
        self.zone_id = zone_id          # type: str
        self.demand_time = demand_time  # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.demand_id = demand_id      # type: str
        self.demand_name = demand_name  # type: str
        self.comment = comment          # type: str
        self.demand_description = demand_description  # type: str
        self.instance_type = instance_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.demand_status = demand_status  # type: str
        self.total_amount = total_amount  # type: int
        self.available_amount = available_amount  # type: int
        self.used_amount = used_amount  # type: int
        self.delivering_amount = delivering_amount  # type: int
        self.supply_infos = supply_infos  # type: DescribeDemandsResponseDemandsDemandSupplyInfos

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.demand_time, 'demand_time')
        self.validate_required(self.instance_type_family, 'instance_type_family')
        self.validate_required(self.demand_id, 'demand_id')
        self.validate_required(self.demand_name, 'demand_name')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.demand_description, 'demand_description')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.period, 'period')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.demand_status, 'demand_status')
        self.validate_required(self.total_amount, 'total_amount')
        self.validate_required(self.available_amount, 'available_amount')
        self.validate_required(self.used_amount, 'used_amount')
        self.validate_required(self.delivering_amount, 'delivering_amount')
        self.validate_required(self.supply_infos, 'supply_infos')
        if self.supply_infos:
            self.supply_infos.validate()

    def to_map(self):
        result = {}
        result['ZoneId'] = self.zone_id
        result['DemandTime'] = self.demand_time
        result['InstanceTypeFamily'] = self.instance_type_family
        result['DemandId'] = self.demand_id
        result['DemandName'] = self.demand_name
        result['Comment'] = self.comment
        result['DemandDescription'] = self.demand_description
        result['InstanceType'] = self.instance_type
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['DemandStatus'] = self.demand_status
        result['TotalAmount'] = self.total_amount
        result['AvailableAmount'] = self.available_amount
        result['UsedAmount'] = self.used_amount
        result['DeliveringAmount'] = self.delivering_amount
        if self.supply_infos is not None:
            result['SupplyInfos'] = self.supply_infos.to_map()
        else:
            result['SupplyInfos'] = None
        return result

    def from_map(self, map={}):
        self.zone_id = map.get('ZoneId')
        self.demand_time = map.get('DemandTime')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.demand_id = map.get('DemandId')
        self.demand_name = map.get('DemandName')
        self.comment = map.get('Comment')
        self.demand_description = map.get('DemandDescription')
        self.instance_type = map.get('InstanceType')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.demand_status = map.get('DemandStatus')
        self.total_amount = map.get('TotalAmount')
        self.available_amount = map.get('AvailableAmount')
        self.used_amount = map.get('UsedAmount')
        self.delivering_amount = map.get('DeliveringAmount')
        if map.get('SupplyInfos') is not None:
            temp_model = DescribeDemandsResponseDemandsDemandSupplyInfos()
            self.supply_infos = temp_model.from_map(map['SupplyInfos'])
        else:
            self.supply_infos = None
        return self


class DescribeDemandsResponseDemands(TeaModel):
    def __init__(self, demand=None):
        self.demand = demand            # type: List[DescribeDemandsResponseDemandsDemand]

    def validate(self):
        self.validate_required(self.demand, 'demand')
        if self.demand:
            for k in self.demand:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Demand'] = []
        if self.demand is not None:
            for k in self.demand:
                result['Demand'].append(k.to_map() if k else None)
        else:
            result['Demand'] = None
        return result

    def from_map(self, map={}):
        self.demand = []
        if map.get('Demand') is not None:
            for k in map.get('Demand'):
                temp_model = DescribeDemandsResponseDemandsDemand()
                self.demand.append(temp_model.from_map(k))
        else:
            self.demand = None
        return self


class ImportSnapshotRequest(TeaModel):
    def __init__(self, snapshot_name=None, region_id=None, oss_bucket=None, oss_object=None, role_name=None):
        self.snapshot_name = snapshot_name  # type: str
        self.region_id = region_id      # type: str
        self.oss_bucket = oss_bucket    # type: str
        self.oss_object = oss_object    # type: str
        self.role_name = role_name      # type: str

    def validate(self):
        self.validate_required(self.snapshot_name, 'snapshot_name')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.oss_bucket, 'oss_bucket')
        self.validate_required(self.oss_object, 'oss_object')

    def to_map(self):
        result = {}
        result['SnapshotName'] = self.snapshot_name
        result['RegionId'] = self.region_id
        result['OssBucket'] = self.oss_bucket
        result['OssObject'] = self.oss_object
        result['RoleName'] = self.role_name
        return result

    def from_map(self, map={}):
        self.snapshot_name = map.get('SnapshotName')
        self.region_id = map.get('RegionId')
        self.oss_bucket = map.get('OssBucket')
        self.oss_object = map.get('OssObject')
        self.role_name = map.get('RoleName')
        return self


class ImportSnapshotResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None, snapshot_id=None):
        self.request_id = request_id    # type: str
        self.task_id = task_id          # type: str
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')
        self.validate_required(self.snapshot_id, 'snapshot_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        self.snapshot_id = map.get('SnapshotId')
        return self


class ExportSnapshotRequest(TeaModel):
    def __init__(self, snapshot_id=None, region_id=None, oss_bucket=None, role_name=None):
        self.snapshot_id = snapshot_id  # type: str
        self.region_id = region_id      # type: str
        self.oss_bucket = oss_bucket    # type: str
        self.role_name = role_name      # type: str

    def validate(self):
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.oss_bucket, 'oss_bucket')

    def to_map(self):
        result = {}
        result['SnapshotId'] = self.snapshot_id
        result['RegionId'] = self.region_id
        result['OssBucket'] = self.oss_bucket
        result['RoleName'] = self.role_name
        return result

    def from_map(self, map={}):
        self.snapshot_id = map.get('SnapshotId')
        self.region_id = map.get('RegionId')
        self.oss_bucket = map.get('OssBucket')
        self.role_name = map.get('RoleName')
        return self


class ExportSnapshotResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id    # type: str
        self.task_id = task_id          # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        return self


class UntagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, resource_type=None, tag_key=None, all=None):
        self.region_id = region_id      # type: str
        self.resource_id = resource_id  # type: List[str]
        self.resource_type = resource_type  # type: str
        self.tag_key = tag_key          # type: List[str]
        self.all = all                  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.resource_type, 'resource_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceId'] = self.resource_id
        result['ResourceType'] = self.resource_type
        result['TagKey'] = self.tag_key
        result['All'] = self.all
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_id = map.get('ResourceId')
        self.resource_type = map.get('ResourceType')
        self.tag_key = map.get('TagKey')
        self.all = map.get('All')
        return self


class UntagResourcesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class TagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_type=None, resource_id=None, tag=None):
        self.region_id = region_id      # type: str
        self.resource_type = resource_type  # type: str
        self.resource_id = resource_id  # type: List[str]
        self.tag = tag                  # type: List[TagResourcesRequestTag]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceType'] = self.resource_type
        result['ResourceId'] = self.resource_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_type = map.get('ResourceType')
        self.resource_id = map.get('ResourceId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = TagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class TagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class TagResourcesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ListTagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, tag=None, tag_filter=None, next_token=None,
                 resource_type=None):
        self.region_id = region_id      # type: str
        self.resource_id = resource_id  # type: List[str]
        self.tag = tag                  # type: List[ListTagResourcesRequestTag]
        self.tag_filter = tag_filter    # type: List[ListTagResourcesRequestTagFilter]
        self.next_token = next_token    # type: str
        self.resource_type = resource_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.tag_filter:
            for k in self.tag_filter:
                if k:
                    k.validate()
        self.validate_required(self.resource_type, 'resource_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceId'] = self.resource_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['TagFilter'] = []
        if self.tag_filter is not None:
            for k in self.tag_filter:
                result['TagFilter'].append(k.to_map() if k else None)
        else:
            result['TagFilter'] = None
        result['NextToken'] = self.next_token
        result['ResourceType'] = self.resource_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_id = map.get('ResourceId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = ListTagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.tag_filter = []
        if map.get('TagFilter') is not None:
            for k in map.get('TagFilter'):
                temp_model = ListTagResourcesRequestTagFilter()
                self.tag_filter.append(temp_model.from_map(k))
        else:
            self.tag_filter = None
        self.next_token = map.get('NextToken')
        self.resource_type = map.get('ResourceType')
        return self


class ListTagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class ListTagResourcesRequestTagFilter(TeaModel):
    def __init__(self, tag_key=None, tag_values=None):
        self.tag_key = tag_key          # type: str
        self.tag_values = tag_values    # type: List[str]

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValues'] = self.tag_values
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_values = map.get('TagValues')
        return self


class ListTagResourcesResponse(TeaModel):
    def __init__(self, request_id=None, next_token=None, tag_resources=None):
        self.request_id = request_id    # type: str
        self.next_token = next_token    # type: str
        self.tag_resources = tag_resources  # type: ListTagResourcesResponseTagResources

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.tag_resources, 'tag_resources')
        if self.tag_resources:
            self.tag_resources.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NextToken'] = self.next_token
        if self.tag_resources is not None:
            result['TagResources'] = self.tag_resources.to_map()
        else:
            result['TagResources'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.next_token = map.get('NextToken')
        if map.get('TagResources') is not None:
            temp_model = ListTagResourcesResponseTagResources()
            self.tag_resources = temp_model.from_map(map['TagResources'])
        else:
            self.tag_resources = None
        return self


class ListTagResourcesResponseTagResourcesTagResource(TeaModel):
    def __init__(self, resource_type=None, resource_id=None, tag_key=None, tag_value=None):
        self.resource_type = resource_type  # type: str
        self.resource_id = resource_id  # type: str
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.resource_type, 'resource_type')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['ResourceType'] = self.resource_type
        result['ResourceId'] = self.resource_id
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.resource_type = map.get('ResourceType')
        self.resource_id = map.get('ResourceId')
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class ListTagResourcesResponseTagResources(TeaModel):
    def __init__(self, tag_resource=None):
        self.tag_resource = tag_resource  # type: List[ListTagResourcesResponseTagResourcesTagResource]

    def validate(self):
        self.validate_required(self.tag_resource, 'tag_resource')
        if self.tag_resource:
            for k in self.tag_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['TagResource'] = []
        if self.tag_resource is not None:
            for k in self.tag_resource:
                result['TagResource'].append(k.to_map() if k else None)
        else:
            result['TagResource'] = None
        return result

    def from_map(self, map={}):
        self.tag_resource = []
        if map.get('TagResource') is not None:
            for k in map.get('TagResource'):
                temp_model = ListTagResourcesResponseTagResourcesTagResource()
                self.tag_resource.append(temp_model.from_map(k))
        else:
            self.tag_resource = None
        return self


class AcceptInquiredSystemEventRequest(TeaModel):
    def __init__(self, region_id=None, event_id=None):
        self.region_id = region_id      # type: str
        self.event_id = event_id        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['EventId'] = self.event_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.event_id = map.get('EventId')
        return self


class AcceptInquiredSystemEventResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class RedeployInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, force_stop=None):
        self.instance_id = instance_id  # type: str
        self.force_stop = force_stop    # type: bool

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['ForceStop'] = self.force_stop
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.force_stop = map.get('ForceStop')
        return self


class RedeployInstanceResponse(TeaModel):
    def __init__(self, request_id=None, task_id=None):
        self.request_id = request_id    # type: str
        self.task_id = task_id          # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.task_id, 'task_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TaskId'] = self.task_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.task_id = map.get('TaskId')
        return self


class UnassignIpv6AddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, ipv_6address=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.ipv_6address = ipv_6address  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.ipv_6address = map.get('Ipv6Address')
        return self


class UnassignIpv6AddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class AssignIpv6AddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, ipv_6address=None, ipv_6address_count=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.ipv_6address = ipv_6address  # type: List[str]
        self.ipv_6address_count = ipv_6address_count  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Ipv6Address'] = self.ipv_6address
        result['Ipv6AddressCount'] = self.ipv_6address_count
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.ipv_6address = map.get('Ipv6Address')
        self.ipv_6address_count = map.get('Ipv6AddressCount')
        return self


class AssignIpv6AddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstanceTopologyRequest(TeaModel):
    def __init__(self, region_id=None, instance_ids=None):
        self.region_id = region_id      # type: str
        self.instance_ids = instance_ids  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_ids = map.get('InstanceIds')
        return self


class DescribeInstanceTopologyResponse(TeaModel):
    def __init__(self, request_id=None, topologys=None):
        self.request_id = request_id    # type: str
        self.topologys = topologys      # type: DescribeInstanceTopologyResponseTopologys

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.topologys, 'topologys')
        if self.topologys:
            self.topologys.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.topologys is not None:
            result['Topologys'] = self.topologys.to_map()
        else:
            result['Topologys'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Topologys') is not None:
            temp_model = DescribeInstanceTopologyResponseTopologys()
            self.topologys = temp_model.from_map(map['Topologys'])
        else:
            self.topologys = None
        return self


class DescribeInstanceTopologyResponseTopologysTopology(TeaModel):
    def __init__(self, instance_id=None, host_id=None):
        self.instance_id = instance_id  # type: str
        self.host_id = host_id          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.host_id, 'host_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['HostId'] = self.host_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.host_id = map.get('HostId')
        return self


class DescribeInstanceTopologyResponseTopologys(TeaModel):
    def __init__(self, topology=None):
        self.topology = topology        # type: List[DescribeInstanceTopologyResponseTopologysTopology]

    def validate(self):
        self.validate_required(self.topology, 'topology')
        if self.topology:
            for k in self.topology:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Topology'] = []
        if self.topology is not None:
            for k in self.topology:
                result['Topology'].append(k.to_map() if k else None)
        else:
            result['Topology'] = None
        return result

    def from_map(self, map={}):
        self.topology = []
        if map.get('Topology') is not None:
            for k in map.get('Topology'):
                temp_model = DescribeInstanceTopologyResponseTopologysTopology()
                self.topology.append(temp_model.from_map(k))
        else:
            self.topology = None
        return self


class RenewDedicatedHostsRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, period=None, period_unit=None, client_token=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.region_id = region_id      # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.period, 'period')

    def to_map(self):
        result = {}
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['RegionId'] = self.region_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.region_id = map.get('RegionId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.client_token = map.get('ClientToken')
        return self


class RenewDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ReleaseDedicatedHostRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class ReleaseDedicatedHostResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyInstanceDeploymentRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, dedicated_host_id=None, deployment_set_id=None,
                 deployment_set_group_no=None, force=None, affinity=None, tenancy=None, migration_type=None, instance_type=None,
                 dedicated_host_cluster_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.deployment_set_id = deployment_set_id  # type: str
        self.deployment_set_group_no = deployment_set_group_no  # type: int
        self.force = force              # type: bool
        self.affinity = affinity        # type: str
        self.tenancy = tenancy          # type: str
        self.migration_type = migration_type  # type: str
        self.instance_type = instance_type  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['DedicatedHostId'] = self.dedicated_host_id
        result['DeploymentSetId'] = self.deployment_set_id
        result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        result['Force'] = self.force
        result['Affinity'] = self.affinity
        result['Tenancy'] = self.tenancy
        result['MigrationType'] = self.migration_type
        result['InstanceType'] = self.instance_type
        result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.deployment_set_id = map.get('DeploymentSetId')
        self.deployment_set_group_no = map.get('DeploymentSetGroupNo')
        self.force = map.get('Force')
        self.affinity = map.get('Affinity')
        self.tenancy = map.get('Tenancy')
        self.migration_type = map.get('MigrationType')
        self.instance_type = map.get('InstanceType')
        self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        return self


class ModifyInstanceDeploymentResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAutoRenewAttributeRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None, duration=None, period_unit=None, auto_renew=None,
                 renewal_status=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.region_id = region_id      # type: str
        self.duration = duration        # type: int
        self.period_unit = period_unit  # type: str
        self.auto_renew = auto_renew    # type: bool
        self.renewal_status = renewal_status  # type: str

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['RegionId'] = self.region_id
        result['Duration'] = self.duration
        result['PeriodUnit'] = self.period_unit
        result['AutoRenew'] = self.auto_renew
        result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, map={}):
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.region_id = map.get('RegionId')
        self.duration = map.get('Duration')
        self.period_unit = map.get('PeriodUnit')
        self.auto_renew = map.get('AutoRenew')
        self.renewal_status = map.get('RenewalStatus')
        return self


class ModifyDedicatedHostAutoRenewAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAutoReleaseTimeRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None, auto_release_time=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.auto_release_time = auto_release_time  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostId'] = self.dedicated_host_id
        result['AutoReleaseTime'] = self.auto_release_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.auto_release_time = map.get('AutoReleaseTime')
        return self


class ModifyDedicatedHostAutoReleaseTimeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyDedicatedHostAttributeRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_id=None, dedicated_host_name=None, description=None,
                 action_on_maintenance=None, network_attributes=None, auto_placement=None, dedicated_host_cluster_id=None,
                 cpu_over_commit_ratio=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.description = description  # type: str
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.network_attributes = network_attributes  # type: ModifyDedicatedHostAttributeRequestNetworkAttributes
        self.auto_placement = auto_placement  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        if self.network_attributes:
            self.network_attributes.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostId'] = self.dedicated_host_id
        result['DedicatedHostName'] = self.dedicated_host_name
        result['Description'] = self.description
        result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        else:
            result['NetworkAttributes'] = None
        result['AutoPlacement'] = self.auto_placement
        result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.dedicated_host_name = map.get('DedicatedHostName')
        self.description = map.get('Description')
        self.action_on_maintenance = map.get('ActionOnMaintenance')
        if map.get('NetworkAttributes') is not None:
            temp_model = ModifyDedicatedHostAttributeRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        else:
            self.network_attributes = None
        self.auto_placement = map.get('AutoPlacement')
        self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        self.cpu_over_commit_ratio = map.get('CpuOverCommitRatio')
        return self


class ModifyDedicatedHostAttributeRequestNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['SlbUdpTimeout'] = self.slb_udp_timeout
        result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        self.slb_udp_timeout = map.get('SlbUdpTimeout')
        self.udp_timeout = map.get('UdpTimeout')
        return self


class ModifyDedicatedHostAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeDedicatedHostsRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, dedicated_host_ids=None, dedicated_host_name=None, status=None,
                 dedicated_host_type=None, lock_reason=None, page_number=None, page_size=None, tag=None, resource_group_id=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.status = status            # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.lock_reason = lock_reason  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.tag = tag                  # type: List[DescribeDedicatedHostsRequestTag]
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['DedicatedHostName'] = self.dedicated_host_name
        result['Status'] = self.status
        result['DedicatedHostType'] = self.dedicated_host_type
        result['LockReason'] = self.lock_reason
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.dedicated_host_name = map.get('DedicatedHostName')
        self.status = map.get('Status')
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.lock_reason = map.get('LockReason')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class DescribeDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, dedicated_hosts=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.dedicated_hosts = dedicated_hosts  # type: DescribeDedicatedHostsResponseDedicatedHosts

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.dedicated_hosts, 'dedicated_hosts')
        if self.dedicated_hosts:
            self.dedicated_hosts.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.dedicated_hosts is not None:
            result['DedicatedHosts'] = self.dedicated_hosts.to_map()
        else:
            result['DedicatedHosts'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('DedicatedHosts') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHosts()
            self.dedicated_hosts = temp_model.from_map(map['DedicatedHosts'])
        else:
            self.dedicated_hosts = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstancesInstance(TeaModel):
    def __init__(self, instance_id=None, instance_type=None):
        self.instance_id = instance_id  # type: str
        self.instance_type = instance_type  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['InstanceType'] = self.instance_type
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.instance_type = map.get('InstanceType')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance        # type: List[DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstancesInstance]

    def validate(self):
        self.validate_required(self.instance, 'instance')
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        else:
            result['Instance'] = None
        return result

    def from_map(self, map={}):
        self.instance = []
        if map.get('Instance') is not None:
            for k in map.get('Instance'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        else:
            self.instance = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocksOperationLock(TeaModel):
    def __init__(self, lock_reason=None):
        self.lock_reason = lock_reason  # type: str

    def validate(self):
        self.validate_required(self.lock_reason, 'lock_reason')

    def to_map(self):
        result = {}
        result['LockReason'] = self.lock_reason
        return result

    def from_map(self, map={}):
        self.lock_reason = map.get('LockReason')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocks(TeaModel):
    def __init__(self, operation_lock=None):
        self.operation_lock = operation_lock  # type: List[DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocksOperationLock]

    def validate(self):
        self.validate_required(self.operation_lock, 'operation_lock')
        if self.operation_lock:
            for k in self.operation_lock:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['OperationLock'] = []
        if self.operation_lock is not None:
            for k in self.operation_lock:
                result['OperationLock'].append(k.to_map() if k else None)
        else:
            result['OperationLock'] = None
        return result

    def from_map(self, map={}):
        self.operation_lock = []
        if map.get('OperationLock') is not None:
            for k in map.get('OperationLock'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocksOperationLock()
                self.operation_lock.append(temp_model.from_map(k))
        else:
            self.operation_lock = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostCapacity(TeaModel):
    def __init__(self, total_vcpus=None, available_vcpus=None, total_vgpus=None, available_vgpus=None,
                 total_memory=None, available_memory=None, total_local_storage=None, available_local_storage=None,
                 local_storage_category=None):
        self.total_vcpus = total_vcpus  # type: int
        self.available_vcpus = available_vcpus  # type: int
        self.total_vgpus = total_vgpus  # type: int
        self.available_vgpus = available_vgpus  # type: int
        self.total_memory = total_memory  # type: float
        self.available_memory = available_memory  # type: float
        self.total_local_storage = total_local_storage  # type: int
        self.available_local_storage = available_local_storage  # type: int
        self.local_storage_category = local_storage_category  # type: str

    def validate(self):
        self.validate_required(self.total_vcpus, 'total_vcpus')
        self.validate_required(self.available_vcpus, 'available_vcpus')
        self.validate_required(self.total_vgpus, 'total_vgpus')
        self.validate_required(self.available_vgpus, 'available_vgpus')
        self.validate_required(self.total_memory, 'total_memory')
        self.validate_required(self.available_memory, 'available_memory')
        self.validate_required(self.total_local_storage, 'total_local_storage')
        self.validate_required(self.available_local_storage, 'available_local_storage')
        self.validate_required(self.local_storage_category, 'local_storage_category')

    def to_map(self):
        result = {}
        result['TotalVcpus'] = self.total_vcpus
        result['AvailableVcpus'] = self.available_vcpus
        result['TotalVgpus'] = self.total_vgpus
        result['AvailableVgpus'] = self.available_vgpus
        result['TotalMemory'] = self.total_memory
        result['AvailableMemory'] = self.available_memory
        result['TotalLocalStorage'] = self.total_local_storage
        result['AvailableLocalStorage'] = self.available_local_storage
        result['LocalStorageCategory'] = self.local_storage_category
        return result

    def from_map(self, map={}):
        self.total_vcpus = map.get('TotalVcpus')
        self.available_vcpus = map.get('AvailableVcpus')
        self.total_vgpus = map.get('TotalVgpus')
        self.available_vgpus = map.get('AvailableVgpus')
        self.total_memory = map.get('TotalMemory')
        self.available_memory = map.get('AvailableMemory')
        self.total_local_storage = map.get('TotalLocalStorage')
        self.available_local_storage = map.get('AvailableLocalStorage')
        self.local_storage_category = map.get('LocalStorageCategory')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        self.validate_required(self.slb_udp_timeout, 'slb_udp_timeout')
        self.validate_required(self.udp_timeout, 'udp_timeout')

    def to_map(self):
        result = {}
        result['SlbUdpTimeout'] = self.slb_udp_timeout
        result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        self.slb_udp_timeout = map.get('SlbUdpTimeout')
        self.udp_timeout = map.get('UdpTimeout')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_instance_type_family=None):
        # SupportedInstanceTypeFamily
        self.supported_instance_type_family = supported_instance_type_family  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_instance_type_family, 'supported_instance_type_family')

    def to_map(self):
        result = {}
        result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, map={}):
        self.supported_instance_type_family = map.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_custom_instance_type_family=None):
        # SupportedCustomInstanceTypeFamily
        self.supported_custom_instance_type_family = supported_custom_instance_type_family  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_custom_instance_type_family, 'supported_custom_instance_type_family')

    def to_map(self):
        result = {}
        result['SupportedCustomInstanceTypeFamily'] = self.supported_custom_instance_type_family
        return result

    def from_map(self, map={}):
        self.supported_custom_instance_type_family = map.get('SupportedCustomInstanceTypeFamily')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypesList(TeaModel):
    def __init__(self, supported_instance_types_list=None):
        # SupportedInstanceTypesList
        self.supported_instance_types_list = supported_instance_types_list  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')

    def to_map(self):
        result = {}
        result['SupportedInstanceTypesList'] = self.supported_instance_types_list
        return result

    def from_map(self, map={}):
        self.supported_instance_types_list = map.get('SupportedInstanceTypesList')
        return self


class DescribeDedicatedHostsResponseDedicatedHostsDedicatedHost(TeaModel):
    def __init__(self, dedicated_host_id=None, auto_placement=None, region_id=None, zone_id=None,
                 dedicated_host_name=None, machine_id=None, description=None, dedicated_host_type=None, sockets=None, cores=None,
                 physical_gpus=None, gpuspec=None, action_on_maintenance=None, status=None, creation_time=None, charge_type=None,
                 sale_cycle=None, expired_time=None, auto_release_time=None, resource_group_id=None,
                 dedicated_host_cluster_id=None, cpu_over_commit_ratio=None, instances=None, operation_locks=None, tags=None, capacity=None,
                 network_attributes=None, supported_instance_type_families=None, supported_custom_instance_type_families=None,
                 supported_instance_types_list=None):
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.auto_placement = auto_placement  # type: str
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.machine_id = machine_id    # type: str
        self.description = description  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.sockets = sockets          # type: int
        self.cores = cores              # type: int
        self.physical_gpus = physical_gpus  # type: int
        self.gpuspec = gpuspec          # type: str
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.status = status            # type: str
        self.creation_time = creation_time  # type: str
        self.charge_type = charge_type  # type: str
        self.sale_cycle = sale_cycle    # type: str
        self.expired_time = expired_time  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float
        self.instances = instances      # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstances
        self.operation_locks = operation_locks  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocks
        self.tags = tags                # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTags
        self.capacity = capacity        # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostCapacity
        self.network_attributes = network_attributes  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostNetworkAttributes
        self.supported_instance_type_families = supported_instance_type_families  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies
        self.supported_custom_instance_type_families = supported_custom_instance_type_families  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies
        self.supported_instance_types_list = supported_instance_types_list  # type: DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypesList

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        self.validate_required(self.auto_placement, 'auto_placement')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.dedicated_host_name, 'dedicated_host_name')
        self.validate_required(self.machine_id, 'machine_id')
        self.validate_required(self.description, 'description')
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        self.validate_required(self.sockets, 'sockets')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.physical_gpus, 'physical_gpus')
        self.validate_required(self.gpuspec, 'gpuspec')
        self.validate_required(self.action_on_maintenance, 'action_on_maintenance')
        self.validate_required(self.status, 'status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.charge_type, 'charge_type')
        self.validate_required(self.sale_cycle, 'sale_cycle')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.auto_release_time, 'auto_release_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.dedicated_host_cluster_id, 'dedicated_host_cluster_id')
        self.validate_required(self.cpu_over_commit_ratio, 'cpu_over_commit_ratio')
        self.validate_required(self.instances, 'instances')
        if self.instances:
            self.instances.validate()
        self.validate_required(self.operation_locks, 'operation_locks')
        if self.operation_locks:
            self.operation_locks.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.capacity, 'capacity')
        if self.capacity:
            self.capacity.validate()
        self.validate_required(self.network_attributes, 'network_attributes')
        if self.network_attributes:
            self.network_attributes.validate()
        self.validate_required(self.supported_instance_type_families, 'supported_instance_type_families')
        if self.supported_instance_type_families:
            self.supported_instance_type_families.validate()
        self.validate_required(self.supported_custom_instance_type_families, 'supported_custom_instance_type_families')
        if self.supported_custom_instance_type_families:
            self.supported_custom_instance_type_families.validate()
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')
        if self.supported_instance_types_list:
            self.supported_instance_types_list.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostId'] = self.dedicated_host_id
        result['AutoPlacement'] = self.auto_placement
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostName'] = self.dedicated_host_name
        result['MachineId'] = self.machine_id
        result['Description'] = self.description
        result['DedicatedHostType'] = self.dedicated_host_type
        result['Sockets'] = self.sockets
        result['Cores'] = self.cores
        result['PhysicalGpus'] = self.physical_gpus
        result['GPUSpec'] = self.gpuspec
        result['ActionOnMaintenance'] = self.action_on_maintenance
        result['Status'] = self.status
        result['CreationTime'] = self.creation_time
        result['ChargeType'] = self.charge_type
        result['SaleCycle'] = self.sale_cycle
        result['ExpiredTime'] = self.expired_time
        result['AutoReleaseTime'] = self.auto_release_time
        result['ResourceGroupId'] = self.resource_group_id
        result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        else:
            result['Instances'] = None
        if self.operation_locks is not None:
            result['OperationLocks'] = self.operation_locks.to_map()
        else:
            result['OperationLocks'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.capacity is not None:
            result['Capacity'] = self.capacity.to_map()
        else:
            result['Capacity'] = None
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        else:
            result['NetworkAttributes'] = None
        if self.supported_instance_type_families is not None:
            result['SupportedInstanceTypeFamilies'] = self.supported_instance_type_families.to_map()
        else:
            result['SupportedInstanceTypeFamilies'] = None
        if self.supported_custom_instance_type_families is not None:
            result['SupportedCustomInstanceTypeFamilies'] = self.supported_custom_instance_type_families.to_map()
        else:
            result['SupportedCustomInstanceTypeFamilies'] = None
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list.to_map()
        else:
            result['SupportedInstanceTypesList'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.auto_placement = map.get('AutoPlacement')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_name = map.get('DedicatedHostName')
        self.machine_id = map.get('MachineId')
        self.description = map.get('Description')
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.sockets = map.get('Sockets')
        self.cores = map.get('Cores')
        self.physical_gpus = map.get('PhysicalGpus')
        self.gpuspec = map.get('GPUSpec')
        self.action_on_maintenance = map.get('ActionOnMaintenance')
        self.status = map.get('Status')
        self.creation_time = map.get('CreationTime')
        self.charge_type = map.get('ChargeType')
        self.sale_cycle = map.get('SaleCycle')
        self.expired_time = map.get('ExpiredTime')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.resource_group_id = map.get('ResourceGroupId')
        self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        self.cpu_over_commit_ratio = map.get('CpuOverCommitRatio')
        if map.get('Instances') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostInstances()
            self.instances = temp_model.from_map(map['Instances'])
        else:
            self.instances = None
        if map.get('OperationLocks') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostOperationLocks()
            self.operation_locks = temp_model.from_map(map['OperationLocks'])
        else:
            self.operation_locks = None
        if map.get('Tags') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('Capacity') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostCapacity()
            self.capacity = temp_model.from_map(map['Capacity'])
        else:
            self.capacity = None
        if map.get('NetworkAttributes') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        else:
            self.network_attributes = None
        if map.get('SupportedInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypeFamilies()
            self.supported_instance_type_families = temp_model.from_map(map['SupportedInstanceTypeFamilies'])
        else:
            self.supported_instance_type_families = None
        if map.get('SupportedCustomInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedCustomInstanceTypeFamilies()
            self.supported_custom_instance_type_families = temp_model.from_map(map['SupportedCustomInstanceTypeFamilies'])
        else:
            self.supported_custom_instance_type_families = None
        if map.get('SupportedInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHostSupportedInstanceTypesList()
            self.supported_instance_types_list = temp_model.from_map(map['SupportedInstanceTypesList'])
        else:
            self.supported_instance_types_list = None
        return self


class DescribeDedicatedHostsResponseDedicatedHosts(TeaModel):
    def __init__(self, dedicated_host=None):
        self.dedicated_host = dedicated_host  # type: List[DescribeDedicatedHostsResponseDedicatedHostsDedicatedHost]

    def validate(self):
        self.validate_required(self.dedicated_host, 'dedicated_host')
        if self.dedicated_host:
            for k in self.dedicated_host:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHost'] = []
        if self.dedicated_host is not None:
            for k in self.dedicated_host:
                result['DedicatedHost'].append(k.to_map() if k else None)
        else:
            result['DedicatedHost'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host = []
        if map.get('DedicatedHost') is not None:
            for k in map.get('DedicatedHost'):
                temp_model = DescribeDedicatedHostsResponseDedicatedHostsDedicatedHost()
                self.dedicated_host.append(temp_model.from_map(k))
        else:
            self.dedicated_host = None
        return self


class DescribeDedicatedHostTypesRequest(TeaModel):
    def __init__(self, region_id=None, dedicated_host_type=None, supported_instance_type_family=None):
        self.region_id = region_id      # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.supported_instance_type_family = supported_instance_type_family  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DedicatedHostType'] = self.dedicated_host_type
        result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.supported_instance_type_family = map.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_types=None):
        self.request_id = request_id    # type: str
        self.dedicated_host_types = dedicated_host_types  # type: DescribeDedicatedHostTypesResponseDedicatedHostTypes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_types, 'dedicated_host_types')
        if self.dedicated_host_types:
            self.dedicated_host_types.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.dedicated_host_types is not None:
            result['DedicatedHostTypes'] = self.dedicated_host_types.to_map()
        else:
            result['DedicatedHostTypes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('DedicatedHostTypes') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypes()
            self.dedicated_host_types = temp_model.from_map(map['DedicatedHostTypes'])
        else:
            self.dedicated_host_types = None
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies(TeaModel):
    def __init__(self, supported_instance_type_family=None):
        # SupportedInstanceTypeFamily
        self.supported_instance_type_family = supported_instance_type_family  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_instance_type_family, 'supported_instance_type_family')

    def to_map(self):
        result = {}
        result['SupportedInstanceTypeFamily'] = self.supported_instance_type_family
        return result

    def from_map(self, map={}):
        self.supported_instance_type_family = map.get('SupportedInstanceTypeFamily')
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList(TeaModel):
    def __init__(self, supported_instance_types_list=None):
        # SupportedInstanceTypesList
        self.supported_instance_types_list = supported_instance_types_list  # type: List[str]

    def validate(self):
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')

    def to_map(self):
        result = {}
        result['SupportedInstanceTypesList'] = self.supported_instance_types_list
        return result

    def from_map(self, map={}):
        self.supported_instance_types_list = map.get('SupportedInstanceTypesList')
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostType(TeaModel):
    def __init__(self, dedicated_host_type=None, sockets=None, total_vcpus=None, total_vgpus=None, cores=None,
                 physical_gpus=None, memory_size=None, local_storage_capacity=None, local_storage_amount=None,
                 local_storage_category=None, gpuspec=None, support_cpu_over_commit_ratio=None, cpu_over_commit_ratio_range=None,
                 supported_instance_type_families=None, supported_instance_types_list=None):
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.sockets = sockets          # type: int
        self.total_vcpus = total_vcpus  # type: int
        self.total_vgpus = total_vgpus  # type: int
        self.cores = cores              # type: int
        self.physical_gpus = physical_gpus  # type: int
        self.memory_size = memory_size  # type: float
        self.local_storage_capacity = local_storage_capacity  # type: int
        self.local_storage_amount = local_storage_amount  # type: int
        self.local_storage_category = local_storage_category  # type: str
        self.gpuspec = gpuspec          # type: str
        self.support_cpu_over_commit_ratio = support_cpu_over_commit_ratio  # type: bool
        self.cpu_over_commit_ratio_range = cpu_over_commit_ratio_range  # type: str
        self.supported_instance_type_families = supported_instance_type_families  # type: DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies
        self.supported_instance_types_list = supported_instance_types_list  # type: DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList

    def validate(self):
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        self.validate_required(self.sockets, 'sockets')
        self.validate_required(self.total_vcpus, 'total_vcpus')
        self.validate_required(self.total_vgpus, 'total_vgpus')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.physical_gpus, 'physical_gpus')
        self.validate_required(self.memory_size, 'memory_size')
        self.validate_required(self.local_storage_capacity, 'local_storage_capacity')
        self.validate_required(self.local_storage_amount, 'local_storage_amount')
        self.validate_required(self.local_storage_category, 'local_storage_category')
        self.validate_required(self.gpuspec, 'gpuspec')
        self.validate_required(self.support_cpu_over_commit_ratio, 'support_cpu_over_commit_ratio')
        self.validate_required(self.cpu_over_commit_ratio_range, 'cpu_over_commit_ratio_range')
        self.validate_required(self.supported_instance_type_families, 'supported_instance_type_families')
        if self.supported_instance_type_families:
            self.supported_instance_type_families.validate()
        self.validate_required(self.supported_instance_types_list, 'supported_instance_types_list')
        if self.supported_instance_types_list:
            self.supported_instance_types_list.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostType'] = self.dedicated_host_type
        result['Sockets'] = self.sockets
        result['TotalVcpus'] = self.total_vcpus
        result['TotalVgpus'] = self.total_vgpus
        result['Cores'] = self.cores
        result['PhysicalGpus'] = self.physical_gpus
        result['MemorySize'] = self.memory_size
        result['LocalStorageCapacity'] = self.local_storage_capacity
        result['LocalStorageAmount'] = self.local_storage_amount
        result['LocalStorageCategory'] = self.local_storage_category
        result['GPUSpec'] = self.gpuspec
        result['SupportCpuOverCommitRatio'] = self.support_cpu_over_commit_ratio
        result['CpuOverCommitRatioRange'] = self.cpu_over_commit_ratio_range
        if self.supported_instance_type_families is not None:
            result['SupportedInstanceTypeFamilies'] = self.supported_instance_type_families.to_map()
        else:
            result['SupportedInstanceTypeFamilies'] = None
        if self.supported_instance_types_list is not None:
            result['SupportedInstanceTypesList'] = self.supported_instance_types_list.to_map()
        else:
            result['SupportedInstanceTypesList'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.sockets = map.get('Sockets')
        self.total_vcpus = map.get('TotalVcpus')
        self.total_vgpus = map.get('TotalVgpus')
        self.cores = map.get('Cores')
        self.physical_gpus = map.get('PhysicalGpus')
        self.memory_size = map.get('MemorySize')
        self.local_storage_capacity = map.get('LocalStorageCapacity')
        self.local_storage_amount = map.get('LocalStorageAmount')
        self.local_storage_category = map.get('LocalStorageCategory')
        self.gpuspec = map.get('GPUSpec')
        self.support_cpu_over_commit_ratio = map.get('SupportCpuOverCommitRatio')
        self.cpu_over_commit_ratio_range = map.get('CpuOverCommitRatioRange')
        if map.get('SupportedInstanceTypeFamilies') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypeFamilies()
            self.supported_instance_type_families = temp_model.from_map(map['SupportedInstanceTypeFamilies'])
        else:
            self.supported_instance_type_families = None
        if map.get('SupportedInstanceTypesList') is not None:
            temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostTypeSupportedInstanceTypesList()
            self.supported_instance_types_list = temp_model.from_map(map['SupportedInstanceTypesList'])
        else:
            self.supported_instance_types_list = None
        return self


class DescribeDedicatedHostTypesResponseDedicatedHostTypes(TeaModel):
    def __init__(self, dedicated_host_type=None):
        self.dedicated_host_type = dedicated_host_type  # type: List[DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostType]

    def validate(self):
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        if self.dedicated_host_type:
            for k in self.dedicated_host_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostType'] = []
        if self.dedicated_host_type is not None:
            for k in self.dedicated_host_type:
                result['DedicatedHostType'].append(k.to_map() if k else None)
        else:
            result['DedicatedHostType'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_type = []
        if map.get('DedicatedHostType') is not None:
            for k in map.get('DedicatedHostType'):
                temp_model = DescribeDedicatedHostTypesResponseDedicatedHostTypesDedicatedHostType()
                self.dedicated_host_type.append(temp_model.from_map(k))
        else:
            self.dedicated_host_type = None
        return self


class DescribeDedicatedHostAutoRenewRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, region_id=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.dedicated_host_ids, 'dedicated_host_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DedicatedHostIds'] = self.dedicated_host_ids
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.dedicated_host_ids = map.get('DedicatedHostIds')
        self.region_id = map.get('RegionId')
        return self


class DescribeDedicatedHostAutoRenewResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_renew_attributes=None):
        self.request_id = request_id    # type: str
        self.dedicated_host_renew_attributes = dedicated_host_renew_attributes  # type: DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_renew_attributes, 'dedicated_host_renew_attributes')
        if self.dedicated_host_renew_attributes:
            self.dedicated_host_renew_attributes.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.dedicated_host_renew_attributes is not None:
            result['DedicatedHostRenewAttributes'] = self.dedicated_host_renew_attributes.to_map()
        else:
            result['DedicatedHostRenewAttributes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('DedicatedHostRenewAttributes') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributes()
            self.dedicated_host_renew_attributes = temp_model.from_map(map['DedicatedHostRenewAttributes'])
        else:
            self.dedicated_host_renew_attributes = None
        return self


class DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributesDedicatedHostRenewAttribute(TeaModel):
    def __init__(self, dedicated_host_id=None, auto_renew_enabled=None, duration=None, period_unit=None,
                 renewal_status=None):
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.auto_renew_enabled = auto_renew_enabled  # type: bool
        self.duration = duration        # type: int
        self.period_unit = period_unit  # type: str
        self.renewal_status = renewal_status  # type: str

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')
        self.validate_required(self.auto_renew_enabled, 'auto_renew_enabled')
        self.validate_required(self.duration, 'duration')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.renewal_status, 'renewal_status')

    def to_map(self):
        result = {}
        result['DedicatedHostId'] = self.dedicated_host_id
        result['AutoRenewEnabled'] = self.auto_renew_enabled
        result['Duration'] = self.duration
        result['PeriodUnit'] = self.period_unit
        result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, map={}):
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.auto_renew_enabled = map.get('AutoRenewEnabled')
        self.duration = map.get('Duration')
        self.period_unit = map.get('PeriodUnit')
        self.renewal_status = map.get('RenewalStatus')
        return self


class DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributes(TeaModel):
    def __init__(self, dedicated_host_renew_attribute=None):
        self.dedicated_host_renew_attribute = dedicated_host_renew_attribute  # type: List[DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributesDedicatedHostRenewAttribute]

    def validate(self):
        self.validate_required(self.dedicated_host_renew_attribute, 'dedicated_host_renew_attribute')
        if self.dedicated_host_renew_attribute:
            for k in self.dedicated_host_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DedicatedHostRenewAttribute'] = []
        if self.dedicated_host_renew_attribute is not None:
            for k in self.dedicated_host_renew_attribute:
                result['DedicatedHostRenewAttribute'].append(k.to_map() if k else None)
        else:
            result['DedicatedHostRenewAttribute'] = None
        return result

    def from_map(self, map={}):
        self.dedicated_host_renew_attribute = []
        if map.get('DedicatedHostRenewAttribute') is not None:
            for k in map.get('DedicatedHostRenewAttribute'):
                temp_model = DescribeDedicatedHostAutoRenewResponseDedicatedHostRenewAttributesDedicatedHostRenewAttribute()
                self.dedicated_host_renew_attribute.append(temp_model.from_map(k))
        else:
            self.dedicated_host_renew_attribute = None
        return self


class AllocateDedicatedHostsRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, zone_id=None, dedicated_host_name=None,
                 dedicated_host_cluster_id=None, dedicated_host_type=None, action_on_maintenance=None, network_attributes=None,
                 description=None, auto_placement=None, cpu_over_commit_ratio=None, charge_type=None, quantity=None,
                 period=None, period_unit=None, auto_renew=None, auto_renew_period=None, auto_release_time=None,
                 client_token=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[AllocateDedicatedHostsRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.zone_id = zone_id          # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.network_attributes = network_attributes  # type: AllocateDedicatedHostsRequestNetworkAttributes
        self.description = description  # type: str
        self.auto_placement = auto_placement  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float
        self.charge_type = charge_type  # type: str
        self.quantity = quantity        # type: int
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.auto_renew = auto_renew    # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.auto_release_time = auto_release_time  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.dedicated_host_type, 'dedicated_host_type')
        if self.network_attributes:
            self.network_attributes.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['ZoneId'] = self.zone_id
        result['DedicatedHostName'] = self.dedicated_host_name
        result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        result['DedicatedHostType'] = self.dedicated_host_type
        result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        else:
            result['NetworkAttributes'] = None
        result['Description'] = self.description
        result['AutoPlacement'] = self.auto_placement
        result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        result['ChargeType'] = self.charge_type
        result['Quantity'] = self.quantity
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['AutoRenew'] = self.auto_renew
        result['AutoRenewPeriod'] = self.auto_renew_period
        result['AutoReleaseTime'] = self.auto_release_time
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = AllocateDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.zone_id = map.get('ZoneId')
        self.dedicated_host_name = map.get('DedicatedHostName')
        self.dedicated_host_cluster_id = map.get('DedicatedHostClusterId')
        self.dedicated_host_type = map.get('DedicatedHostType')
        self.action_on_maintenance = map.get('ActionOnMaintenance')
        if map.get('NetworkAttributes') is not None:
            temp_model = AllocateDedicatedHostsRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(map['NetworkAttributes'])
        else:
            self.network_attributes = None
        self.description = map.get('Description')
        self.auto_placement = map.get('AutoPlacement')
        self.cpu_over_commit_ratio = map.get('CpuOverCommitRatio')
        self.charge_type = map.get('ChargeType')
        self.quantity = map.get('Quantity')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.auto_renew = map.get('AutoRenew')
        self.auto_renew_period = map.get('AutoRenewPeriod')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.client_token = map.get('ClientToken')
        return self


class AllocateDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class AllocateDedicatedHostsRequestNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['SlbUdpTimeout'] = self.slb_udp_timeout
        result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, map={}):
        self.slb_udp_timeout = map.get('SlbUdpTimeout')
        self.udp_timeout = map.get('UdpTimeout')
        return self


class AllocateDedicatedHostsResponse(TeaModel):
    def __init__(self, request_id=None, dedicated_host_id_sets=None):
        self.request_id = request_id    # type: str
        self.dedicated_host_id_sets = dedicated_host_id_sets  # type: AllocateDedicatedHostsResponseDedicatedHostIdSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.dedicated_host_id_sets, 'dedicated_host_id_sets')
        if self.dedicated_host_id_sets:
            self.dedicated_host_id_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.dedicated_host_id_sets is not None:
            result['DedicatedHostIdSets'] = self.dedicated_host_id_sets.to_map()
        else:
            result['DedicatedHostIdSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('DedicatedHostIdSets') is not None:
            temp_model = AllocateDedicatedHostsResponseDedicatedHostIdSets()
            self.dedicated_host_id_sets = temp_model.from_map(map['DedicatedHostIdSets'])
        else:
            self.dedicated_host_id_sets = None
        return self


class AllocateDedicatedHostsResponseDedicatedHostIdSets(TeaModel):
    def __init__(self, dedicated_host_id=None):
        self.dedicated_host_id = dedicated_host_id  # type: List[str]

    def validate(self):
        self.validate_required(self.dedicated_host_id, 'dedicated_host_id')

    def to_map(self):
        result = {}
        result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, map={}):
        self.dedicated_host_id = map.get('DedicatedHostId')
        return self


class CreateSimulatedSystemEventsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_type=None, not_before=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.event_type = event_type    # type: str
        self.not_before = not_before    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.event_type, 'event_type')
        self.validate_required(self.not_before, 'not_before')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['EventType'] = self.event_type
        result['NotBefore'] = self.not_before
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.event_type = map.get('EventType')
        self.not_before = map.get('NotBefore')
        return self


class CreateSimulatedSystemEventsResponse(TeaModel):
    def __init__(self, request_id=None, event_id_set=None):
        self.request_id = request_id    # type: str
        self.event_id_set = event_id_set  # type: CreateSimulatedSystemEventsResponseEventIdSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.event_id_set, 'event_id_set')
        if self.event_id_set:
            self.event_id_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.event_id_set is not None:
            result['EventIdSet'] = self.event_id_set.to_map()
        else:
            result['EventIdSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('EventIdSet') is not None:
            temp_model = CreateSimulatedSystemEventsResponseEventIdSet()
            self.event_id_set = temp_model.from_map(map['EventIdSet'])
        else:
            self.event_id_set = None
        return self


class CreateSimulatedSystemEventsResponseEventIdSet(TeaModel):
    def __init__(self, event_id=None):
        self.event_id = event_id        # type: List[str]

    def validate(self):
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        result['EventId'] = self.event_id
        return result

    def from_map(self, map={}):
        self.event_id = map.get('EventId')
        return self


class CancelSimulatedSystemEventsRequest(TeaModel):
    def __init__(self, region_id=None, event_id=None):
        self.region_id = region_id      # type: str
        self.event_id = event_id        # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.event_id, 'event_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['EventId'] = self.event_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.event_id = map.get('EventId')
        return self


class CancelSimulatedSystemEventsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeEniMonitorDataRequest(TeaModel):
    def __init__(self, eni_id=None, region_id=None, instance_id=None, start_time=None, end_time=None, period=None):
        self.eni_id = eni_id            # type: str
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.period = period            # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['EniId'] = self.eni_id
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['Period'] = self.period
        return result

    def from_map(self, map={}):
        self.eni_id = map.get('EniId')
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.period = map.get('Period')
        return self


class DescribeEniMonitorDataResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, monitor_data=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.monitor_data = monitor_data  # type: DescribeEniMonitorDataResponseMonitorData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.monitor_data, 'monitor_data')
        if self.monitor_data:
            self.monitor_data.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        if self.monitor_data is not None:
            result['MonitorData'] = self.monitor_data.to_map()
        else:
            result['MonitorData'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        if map.get('MonitorData') is not None:
            temp_model = DescribeEniMonitorDataResponseMonitorData()
            self.monitor_data = temp_model.from_map(map['MonitorData'])
        else:
            self.monitor_data = None
        return self


class DescribeEniMonitorDataResponseMonitorDataEniMonitorData(TeaModel):
    def __init__(self, eni_id=None, time_stamp=None, packet_tx=None, packet_rx=None, intranet_tx=None,
                 intranet_rx=None, drop_packet_tx=None, drop_packet_rx=None):
        self.eni_id = eni_id            # type: str
        self.time_stamp = time_stamp    # type: str
        self.packet_tx = packet_tx      # type: str
        self.packet_rx = packet_rx      # type: str
        self.intranet_tx = intranet_tx  # type: str
        self.intranet_rx = intranet_rx  # type: str
        self.drop_packet_tx = drop_packet_tx  # type: str
        self.drop_packet_rx = drop_packet_rx  # type: str

    def validate(self):
        self.validate_required(self.eni_id, 'eni_id')
        self.validate_required(self.time_stamp, 'time_stamp')
        self.validate_required(self.packet_tx, 'packet_tx')
        self.validate_required(self.packet_rx, 'packet_rx')
        self.validate_required(self.intranet_tx, 'intranet_tx')
        self.validate_required(self.intranet_rx, 'intranet_rx')
        self.validate_required(self.drop_packet_tx, 'drop_packet_tx')
        self.validate_required(self.drop_packet_rx, 'drop_packet_rx')

    def to_map(self):
        result = {}
        result['EniId'] = self.eni_id
        result['TimeStamp'] = self.time_stamp
        result['PacketTx'] = self.packet_tx
        result['PacketRx'] = self.packet_rx
        result['IntranetTx'] = self.intranet_tx
        result['IntranetRx'] = self.intranet_rx
        result['DropPacketTx'] = self.drop_packet_tx
        result['DropPacketRx'] = self.drop_packet_rx
        return result

    def from_map(self, map={}):
        self.eni_id = map.get('EniId')
        self.time_stamp = map.get('TimeStamp')
        self.packet_tx = map.get('PacketTx')
        self.packet_rx = map.get('PacketRx')
        self.intranet_tx = map.get('IntranetTx')
        self.intranet_rx = map.get('IntranetRx')
        self.drop_packet_tx = map.get('DropPacketTx')
        self.drop_packet_rx = map.get('DropPacketRx')
        return self


class DescribeEniMonitorDataResponseMonitorData(TeaModel):
    def __init__(self, eni_monitor_data=None):
        self.eni_monitor_data = eni_monitor_data  # type: List[DescribeEniMonitorDataResponseMonitorDataEniMonitorData]

    def validate(self):
        self.validate_required(self.eni_monitor_data, 'eni_monitor_data')
        if self.eni_monitor_data:
            for k in self.eni_monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['EniMonitorData'] = []
        if self.eni_monitor_data is not None:
            for k in self.eni_monitor_data:
                result['EniMonitorData'].append(k.to_map() if k else None)
        else:
            result['EniMonitorData'] = None
        return result

    def from_map(self, map={}):
        self.eni_monitor_data = []
        if map.get('EniMonitorData') is not None:
            for k in map.get('EniMonitorData'):
                temp_model = DescribeEniMonitorDataResponseMonitorDataEniMonitorData()
                self.eni_monitor_data.append(temp_model.from_map(k))
        else:
            self.eni_monitor_data = None
        return self


class DescribeAccountAttributesRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, attribute_name=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.attribute_name = attribute_name  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['AttributeName'] = self.attribute_name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.attribute_name = map.get('AttributeName')
        return self


class DescribeAccountAttributesResponse(TeaModel):
    def __init__(self, request_id=None, account_attribute_items=None):
        self.request_id = request_id    # type: str
        self.account_attribute_items = account_attribute_items  # type: DescribeAccountAttributesResponseAccountAttributeItems

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.account_attribute_items, 'account_attribute_items')
        if self.account_attribute_items:
            self.account_attribute_items.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.account_attribute_items is not None:
            result['AccountAttributeItems'] = self.account_attribute_items.to_map()
        else:
            result['AccountAttributeItems'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('AccountAttributeItems') is not None:
            temp_model = DescribeAccountAttributesResponseAccountAttributeItems()
            self.account_attribute_items = temp_model.from_map(map['AccountAttributeItems'])
        else:
            self.account_attribute_items = None
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem(TeaModel):
    def __init__(self, value=None, expired_time=None, zone_id=None, instance_charge_type=None, instance_type=None,
                 count=None, disk_category=None):
        self.value = value              # type: str
        self.expired_time = expired_time  # type: str
        self.zone_id = zone_id          # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.count = count              # type: int
        self.disk_category = disk_category  # type: str

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.expired_time, 'expired_time')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.count, 'count')
        self.validate_required(self.disk_category, 'disk_category')

    def to_map(self):
        result = {}
        result['Value'] = self.value
        result['ExpiredTime'] = self.expired_time
        result['ZoneId'] = self.zone_id
        result['InstanceChargeType'] = self.instance_charge_type
        result['InstanceType'] = self.instance_type
        result['Count'] = self.count
        result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, map={}):
        self.value = map.get('Value')
        self.expired_time = map.get('ExpiredTime')
        self.zone_id = map.get('ZoneId')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.instance_type = map.get('InstanceType')
        self.count = map.get('Count')
        self.disk_category = map.get('DiskCategory')
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValues(TeaModel):
    def __init__(self, value_item=None):
        self.value_item = value_item    # type: List[DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem]

    def validate(self):
        self.validate_required(self.value_item, 'value_item')
        if self.value_item:
            for k in self.value_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ValueItem'] = []
        if self.value_item is not None:
            for k in self.value_item:
                result['ValueItem'].append(k.to_map() if k else None)
        else:
            result['ValueItem'] = None
        return result

    def from_map(self, map={}):
        self.value_item = []
        if map.get('ValueItem') is not None:
            for k in map.get('ValueItem'):
                temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem()
                self.value_item.append(temp_model.from_map(k))
        else:
            self.value_item = None
        return self


class DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItem(TeaModel):
    def __init__(self, attribute_name=None, attribute_values=None):
        self.attribute_name = attribute_name  # type: str
        self.attribute_values = attribute_values  # type: DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValues

    def validate(self):
        self.validate_required(self.attribute_name, 'attribute_name')
        self.validate_required(self.attribute_values, 'attribute_values')
        if self.attribute_values:
            self.attribute_values.validate()

    def to_map(self):
        result = {}
        result['AttributeName'] = self.attribute_name
        if self.attribute_values is not None:
            result['AttributeValues'] = self.attribute_values.to_map()
        else:
            result['AttributeValues'] = None
        return result

    def from_map(self, map={}):
        self.attribute_name = map.get('AttributeName')
        if map.get('AttributeValues') is not None:
            temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItemAttributeValues()
            self.attribute_values = temp_model.from_map(map['AttributeValues'])
        else:
            self.attribute_values = None
        return self


class DescribeAccountAttributesResponseAccountAttributeItems(TeaModel):
    def __init__(self, account_attribute_item=None):
        self.account_attribute_item = account_attribute_item  # type: List[DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItem]

    def validate(self):
        self.validate_required(self.account_attribute_item, 'account_attribute_item')
        if self.account_attribute_item:
            for k in self.account_attribute_item:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AccountAttributeItem'] = []
        if self.account_attribute_item is not None:
            for k in self.account_attribute_item:
                result['AccountAttributeItem'].append(k.to_map() if k else None)
        else:
            result['AccountAttributeItem'] = None
        return result

    def from_map(self, map={}):
        self.account_attribute_item = []
        if map.get('AccountAttributeItem') is not None:
            for k in map.get('AccountAttributeItem'):
                temp_model = DescribeAccountAttributesResponseAccountAttributeItemsAccountAttributeItem()
                self.account_attribute_item.append(temp_model.from_map(k))
        else:
            self.account_attribute_item = None
        return self


class ModifyLaunchTemplateDefaultVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 default_version_number=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.default_version_number = default_version_number  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.default_version_number, 'default_version_number')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['DefaultVersionNumber'] = self.default_version_number
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.default_version_number = map.get('DefaultVersionNumber')
        return self


class ModifyLaunchTemplateDefaultVersionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeLaunchTemplatesRequest(TeaModel):
    def __init__(self, region_id=None, template_tag=None, launch_template_id=None, launch_template_name=None,
                 page_number=None, page_size=None, template_resource_group_id=None):
        self.region_id = region_id      # type: str
        self.template_tag = template_tag  # type: List[DescribeLaunchTemplatesRequestTemplateTag]
        self.launch_template_id = launch_template_id  # type: List[str]
        self.launch_template_name = launch_template_name  # type: List[str]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.template_resource_group_id = template_resource_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        else:
            result['TemplateTag'] = None
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TemplateResourceGroupId'] = self.template_resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.template_tag = []
        if map.get('TemplateTag') is not None:
            for k in map.get('TemplateTag'):
                temp_model = DescribeLaunchTemplatesRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        else:
            self.template_tag = None
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.template_resource_group_id = map.get('TemplateResourceGroupId')
        return self


class DescribeLaunchTemplatesRequestTemplateTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeLaunchTemplatesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 launch_template_sets=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.launch_template_sets = launch_template_sets  # type: DescribeLaunchTemplatesResponseLaunchTemplateSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.launch_template_sets, 'launch_template_sets')
        if self.launch_template_sets:
            self.launch_template_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.launch_template_sets is not None:
            result['LaunchTemplateSets'] = self.launch_template_sets.to_map()
        else:
            result['LaunchTemplateSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('LaunchTemplateSets') is not None:
            temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSets()
            self.launch_template_sets = temp_model.from_map(map['LaunchTemplateSets'])
        else:
            self.launch_template_sets = None
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSet(TeaModel):
    def __init__(self, create_time=None, modified_time=None, launch_template_id=None, launch_template_name=None,
                 default_version_number=None, latest_version_number=None, created_by=None, resource_group_id=None, tags=None):
        self.create_time = create_time  # type: str
        self.modified_time = modified_time  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.default_version_number = default_version_number  # type: int
        self.latest_version_number = latest_version_number  # type: int
        self.created_by = created_by    # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tags = tags                # type: DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTags

    def validate(self):
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_name, 'launch_template_name')
        self.validate_required(self.default_version_number, 'default_version_number')
        self.validate_required(self.latest_version_number, 'latest_version_number')
        self.validate_required(self.created_by, 'created_by')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['CreateTime'] = self.create_time
        result['ModifiedTime'] = self.modified_time
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['DefaultVersionNumber'] = self.default_version_number
        result['LatestVersionNumber'] = self.latest_version_number
        result['CreatedBy'] = self.created_by
        result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.create_time = map.get('CreateTime')
        self.modified_time = map.get('ModifiedTime')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.default_version_number = map.get('DefaultVersionNumber')
        self.latest_version_number = map.get('LatestVersionNumber')
        self.created_by = map.get('CreatedBy')
        self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Tags') is not None:
            temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSetTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeLaunchTemplatesResponseLaunchTemplateSets(TeaModel):
    def __init__(self, launch_template_set=None):
        self.launch_template_set = launch_template_set  # type: List[DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSet]

    def validate(self):
        self.validate_required(self.launch_template_set, 'launch_template_set')
        if self.launch_template_set:
            for k in self.launch_template_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateSet'] = []
        if self.launch_template_set is not None:
            for k in self.launch_template_set:
                result['LaunchTemplateSet'].append(k.to_map() if k else None)
        else:
            result['LaunchTemplateSet'] = None
        return result

    def from_map(self, map={}):
        self.launch_template_set = []
        if map.get('LaunchTemplateSet') is not None:
            for k in map.get('LaunchTemplateSet'):
                temp_model = DescribeLaunchTemplatesResponseLaunchTemplateSetsLaunchTemplateSet()
                self.launch_template_set.append(temp_model.from_map(k))
        else:
            self.launch_template_set = None
        return self


class DescribeLaunchTemplateVersionsRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 launch_template_version=None, min_version=None, max_version=None, default_version=None, detail_flag=None, page_number=None,
                 page_size=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.launch_template_version = launch_template_version  # type: List[int]
        self.min_version = min_version  # type: int
        self.max_version = max_version  # type: int
        self.default_version = default_version  # type: bool
        self.detail_flag = detail_flag  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['LaunchTemplateVersion'] = self.launch_template_version
        result['MinVersion'] = self.min_version
        result['MaxVersion'] = self.max_version
        result['DefaultVersion'] = self.default_version
        result['DetailFlag'] = self.detail_flag
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.launch_template_version = map.get('LaunchTemplateVersion')
        self.min_version = map.get('MinVersion')
        self.max_version = map.get('MaxVersion')
        self.default_version = map.get('DefaultVersion')
        self.detail_flag = map.get('DetailFlag')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeLaunchTemplateVersionsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 launch_template_version_sets=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.launch_template_version_sets = launch_template_version_sets  # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.launch_template_version_sets, 'launch_template_version_sets')
        if self.launch_template_version_sets:
            self.launch_template_version_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.launch_template_version_sets is not None:
            result['LaunchTemplateVersionSets'] = self.launch_template_version_sets.to_map()
        else:
            result['LaunchTemplateVersionSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('LaunchTemplateVersionSets') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSets()
            self.launch_template_version_sets = temp_model.from_map(map['LaunchTemplateVersionSets'])
        else:
            self.launch_template_version_sets = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataSystemDisk(TeaModel):
    def __init__(self, size=None, category=None, disk_name=None, description=None, iops=None):
        self.size = size                # type: int
        self.category = category        # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.iops = iops                # type: int

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.category, 'category')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.iops, 'iops')

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['Category'] = self.category
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.category = map.get('Category')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.iops = map.get('Iops')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisksDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size                # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.category = category        # type: str
        self.encrypted = encrypted      # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.device = device            # type: str

    def validate(self):
        self.validate_required(self.size, 'size')
        self.validate_required(self.snapshot_id, 'snapshot_id')
        self.validate_required(self.category, 'category')
        self.validate_required(self.encrypted, 'encrypted')
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.delete_with_instance, 'delete_with_instance')
        self.validate_required(self.device, 'device')

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['SnapshotId'] = self.snapshot_id
        result['Category'] = self.category
        result['Encrypted'] = self.encrypted
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['DeleteWithInstance'] = self.delete_with_instance
        result['Device'] = self.device
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.snapshot_id = map.get('SnapshotId')
        self.category = map.get('Category')
        self.encrypted = map.get('Encrypted')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.delete_with_instance = map.get('DeleteWithInstance')
        self.device = map.get('Device')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisks(TeaModel):
    def __init__(self, data_disk=None):
        self.data_disk = data_disk      # type: List[DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisksDataDisk]

    def validate(self):
        self.validate_required(self.data_disk, 'data_disk')
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        return result

    def from_map(self, map={}):
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisksDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        else:
            self.data_disk = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfacesNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.primary_ip_address, 'primary_ip_address')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['VSwitchId'] = self.v_switch_id
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.v_switch_id = map.get('VSwitchId')
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfaces(TeaModel):
    def __init__(self, network_interface=None):
        self.network_interface = network_interface  # type: List[DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfacesNetworkInterface]

    def validate(self):
        self.validate_required(self.network_interface, 'network_interface')
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        else:
            result['NetworkInterface'] = None
        return result

    def from_map(self, map={}):
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfacesNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        else:
            self.network_interface = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTagsInstanceTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.value, 'value')

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTags(TeaModel):
    def __init__(self, instance_tag=None):
        self.instance_tag = instance_tag  # type: List[DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTagsInstanceTag]

    def validate(self):
        self.validate_required(self.instance_tag, 'instance_tag')
        if self.instance_tag:
            for k in self.instance_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceTag'] = []
        if self.instance_tag is not None:
            for k in self.instance_tag:
                result['InstanceTag'].append(k.to_map() if k else None)
        else:
            result['InstanceTag'] = None
        return result

    def from_map(self, map={}):
        self.instance_tag = []
        if map.get('InstanceTag') is not None:
            for k in map.get('InstanceTag'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTagsInstanceTag()
                self.instance_tag.append(temp_model.from_map(k))
        else:
            self.instance_tag = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateData(TeaModel):
    def __init__(self, image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None,
                 security_group_id=None, vpc_id=None, v_switch_id=None, instance_name=None, description=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, host_name=None, zone_id=None, io_optimized=None,
                 instance_charge_type=None, period=None, internet_charge_type=None, enable_vm_os_config=None, network_type=None,
                 user_data=None, key_pair_name=None, ram_role_name=None, auto_release_time=None, spot_strategy=None,
                 spot_price_limit=None, spot_duration=None, resource_group_id=None, security_enhancement_strategy=None,
                 system_disk=None, data_disks=None, network_interfaces=None, tags=None):
        self.image_id = image_id        # type: str
        self.image_owner_alias = image_owner_alias  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.instance_type = instance_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.instance_name = instance_name  # type: str
        self.description = description  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.host_name = host_name      # type: str
        self.zone_id = zone_id          # type: str
        self.io_optimized = io_optimized  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.internet_charge_type = internet_charge_type  # type: str
        self.enable_vm_os_config = enable_vm_os_config  # type: bool
        self.network_type = network_type  # type: str
        self.user_data = user_data      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_duration = spot_duration  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.system_disk = system_disk  # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataSystemDisk
        self.data_disks = data_disks    # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisks
        self.network_interfaces = network_interfaces  # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfaces
        self.tags = tags                # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTags

    def validate(self):
        self.validate_required(self.image_id, 'image_id')
        self.validate_required(self.image_owner_alias, 'image_owner_alias')
        self.validate_required(self.password_inherit, 'password_inherit')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.instance_name, 'instance_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.internet_max_bandwidth_in, 'internet_max_bandwidth_in')
        self.validate_required(self.internet_max_bandwidth_out, 'internet_max_bandwidth_out')
        self.validate_required(self.host_name, 'host_name')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.period, 'period')
        self.validate_required(self.internet_charge_type, 'internet_charge_type')
        self.validate_required(self.enable_vm_os_config, 'enable_vm_os_config')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.user_data, 'user_data')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.auto_release_time, 'auto_release_time')
        self.validate_required(self.spot_strategy, 'spot_strategy')
        self.validate_required(self.spot_price_limit, 'spot_price_limit')
        self.validate_required(self.spot_duration, 'spot_duration')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.security_enhancement_strategy, 'security_enhancement_strategy')
        self.validate_required(self.system_disk, 'system_disk')
        if self.system_disk:
            self.system_disk.validate()
        self.validate_required(self.data_disks, 'data_disks')
        if self.data_disks:
            self.data_disks.validate()
        self.validate_required(self.network_interfaces, 'network_interfaces')
        if self.network_interfaces:
            self.network_interfaces.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['ImageId'] = self.image_id
        result['ImageOwnerAlias'] = self.image_owner_alias
        result['PasswordInherit'] = self.password_inherit
        result['InstanceType'] = self.instance_type
        result['SecurityGroupId'] = self.security_group_id
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['InstanceName'] = self.instance_name
        result['Description'] = self.description
        result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        result['HostName'] = self.host_name
        result['ZoneId'] = self.zone_id
        result['IoOptimized'] = self.io_optimized
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['InternetChargeType'] = self.internet_charge_type
        result['EnableVmOsConfig'] = self.enable_vm_os_config
        result['NetworkType'] = self.network_type
        result['UserData'] = self.user_data
        result['KeyPairName'] = self.key_pair_name
        result['RamRoleName'] = self.ram_role_name
        result['AutoReleaseTime'] = self.auto_release_time
        result['SpotStrategy'] = self.spot_strategy
        result['SpotPriceLimit'] = self.spot_price_limit
        result['SpotDuration'] = self.spot_duration
        result['ResourceGroupId'] = self.resource_group_id
        result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        if self.data_disks is not None:
            result['DataDisks'] = self.data_disks.to_map()
        else:
            result['DataDisks'] = None
        if self.network_interfaces is not None:
            result['NetworkInterfaces'] = self.network_interfaces.to_map()
        else:
            result['NetworkInterfaces'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.image_id = map.get('ImageId')
        self.image_owner_alias = map.get('ImageOwnerAlias')
        self.password_inherit = map.get('PasswordInherit')
        self.instance_type = map.get('InstanceType')
        self.security_group_id = map.get('SecurityGroupId')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.instance_name = map.get('InstanceName')
        self.description = map.get('Description')
        self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        self.host_name = map.get('HostName')
        self.zone_id = map.get('ZoneId')
        self.io_optimized = map.get('IoOptimized')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.internet_charge_type = map.get('InternetChargeType')
        self.enable_vm_os_config = map.get('EnableVmOsConfig')
        self.network_type = map.get('NetworkType')
        self.user_data = map.get('UserData')
        self.key_pair_name = map.get('KeyPairName')
        self.ram_role_name = map.get('RamRoleName')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_price_limit = map.get('SpotPriceLimit')
        self.spot_duration = map.get('SpotDuration')
        self.resource_group_id = map.get('ResourceGroupId')
        self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        if map.get('SystemDisk') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        if map.get('DataDisks') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataDataDisks()
            self.data_disks = temp_model.from_map(map['DataDisks'])
        else:
            self.data_disks = None
        if map.get('NetworkInterfaces') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataNetworkInterfaces()
            self.network_interfaces = temp_model.from_map(map['NetworkInterfaces'])
        else:
            self.network_interfaces = None
        if map.get('Tags') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateDataTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSet(TeaModel):
    def __init__(self, create_time=None, modified_time=None, launch_template_id=None, launch_template_name=None,
                 default_version=None, version_number=None, version_description=None, created_by=None, launch_template_data=None):
        self.create_time = create_time  # type: str
        self.modified_time = modified_time  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.default_version = default_version  # type: bool
        self.version_number = version_number  # type: int
        self.version_description = version_description  # type: str
        self.created_by = created_by    # type: str
        self.launch_template_data = launch_template_data  # type: DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateData

    def validate(self):
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.modified_time, 'modified_time')
        self.validate_required(self.launch_template_id, 'launch_template_id')
        self.validate_required(self.launch_template_name, 'launch_template_name')
        self.validate_required(self.default_version, 'default_version')
        self.validate_required(self.version_number, 'version_number')
        self.validate_required(self.version_description, 'version_description')
        self.validate_required(self.created_by, 'created_by')
        self.validate_required(self.launch_template_data, 'launch_template_data')
        if self.launch_template_data:
            self.launch_template_data.validate()

    def to_map(self):
        result = {}
        result['CreateTime'] = self.create_time
        result['ModifiedTime'] = self.modified_time
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['DefaultVersion'] = self.default_version
        result['VersionNumber'] = self.version_number
        result['VersionDescription'] = self.version_description
        result['CreatedBy'] = self.created_by
        if self.launch_template_data is not None:
            result['LaunchTemplateData'] = self.launch_template_data.to_map()
        else:
            result['LaunchTemplateData'] = None
        return result

    def from_map(self, map={}):
        self.create_time = map.get('CreateTime')
        self.modified_time = map.get('ModifiedTime')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.default_version = map.get('DefaultVersion')
        self.version_number = map.get('VersionNumber')
        self.version_description = map.get('VersionDescription')
        self.created_by = map.get('CreatedBy')
        if map.get('LaunchTemplateData') is not None:
            temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSetLaunchTemplateData()
            self.launch_template_data = temp_model.from_map(map['LaunchTemplateData'])
        else:
            self.launch_template_data = None
        return self


class DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSets(TeaModel):
    def __init__(self, launch_template_version_set=None):
        self.launch_template_version_set = launch_template_version_set  # type: List[DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSet]

    def validate(self):
        self.validate_required(self.launch_template_version_set, 'launch_template_version_set')
        if self.launch_template_version_set:
            for k in self.launch_template_version_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['LaunchTemplateVersionSet'] = []
        if self.launch_template_version_set is not None:
            for k in self.launch_template_version_set:
                result['LaunchTemplateVersionSet'].append(k.to_map() if k else None)
        else:
            result['LaunchTemplateVersionSet'] = None
        return result

    def from_map(self, map={}):
        self.launch_template_version_set = []
        if map.get('LaunchTemplateVersionSet') is not None:
            for k in map.get('LaunchTemplateVersionSet'):
                temp_model = DescribeLaunchTemplateVersionsResponseLaunchTemplateVersionSetsLaunchTemplateVersionSet()
                self.launch_template_version_set.append(temp_model.from_map(k))
        else:
            self.launch_template_version_set = None
        return self


class DeleteLaunchTemplateVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None, delete_version=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.delete_version = delete_version  # type: List[int]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.delete_version, 'delete_version')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['DeleteVersion'] = self.delete_version
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.delete_version = map.get('DeleteVersion')
        return self


class DeleteLaunchTemplateVersionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeleteLaunchTemplateRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        return self


class DeleteLaunchTemplateResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateLaunchTemplateVersionRequest(TeaModel):
    def __init__(self, region_id=None, launch_template_id=None, launch_template_name=None,
                 version_description=None, image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None,
                 security_group_id=None, vpc_id=None, v_switch_id=None, instance_name=None, description=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, host_name=None, zone_id=None, system_disk=None,
                 data_disk=None, io_optimized=None, network_interface=None, instance_charge_type=None, period=None,
                 internet_charge_type=None, enable_vm_os_config=None, network_type=None, user_data=None, key_pair_name=None,
                 ram_role_name=None, auto_release_time=None, spot_strategy=None, spot_price_limit=None, spot_duration=None,
                 resource_group_id=None, security_enhancement_strategy=None, tag=None):
        self.region_id = region_id      # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.version_description = version_description  # type: str
        self.image_id = image_id        # type: str
        self.image_owner_alias = image_owner_alias  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.instance_type = instance_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.instance_name = instance_name  # type: str
        self.description = description  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.host_name = host_name      # type: str
        self.zone_id = zone_id          # type: str
        self.system_disk = system_disk  # type: CreateLaunchTemplateVersionRequestSystemDisk
        self.data_disk = data_disk      # type: List[CreateLaunchTemplateVersionRequestDataDisk]
        self.io_optimized = io_optimized  # type: str
        self.network_interface = network_interface  # type: List[CreateLaunchTemplateVersionRequestNetworkInterface]
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.internet_charge_type = internet_charge_type  # type: str
        self.enable_vm_os_config = enable_vm_os_config  # type: bool
        self.network_type = network_type  # type: str
        self.user_data = user_data      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_duration = spot_duration  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.tag = tag                  # type: List[CreateLaunchTemplateVersionRequestTag]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['VersionDescription'] = self.version_description
        result['ImageId'] = self.image_id
        result['ImageOwnerAlias'] = self.image_owner_alias
        result['PasswordInherit'] = self.password_inherit
        result['InstanceType'] = self.instance_type
        result['SecurityGroupId'] = self.security_group_id
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['InstanceName'] = self.instance_name
        result['Description'] = self.description
        result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        result['HostName'] = self.host_name
        result['ZoneId'] = self.zone_id
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        else:
            result['NetworkInterface'] = None
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['InternetChargeType'] = self.internet_charge_type
        result['EnableVmOsConfig'] = self.enable_vm_os_config
        result['NetworkType'] = self.network_type
        result['UserData'] = self.user_data
        result['KeyPairName'] = self.key_pair_name
        result['RamRoleName'] = self.ram_role_name
        result['AutoReleaseTime'] = self.auto_release_time
        result['SpotStrategy'] = self.spot_strategy
        result['SpotPriceLimit'] = self.spot_price_limit
        result['SpotDuration'] = self.spot_duration
        result['ResourceGroupId'] = self.resource_group_id
        result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.version_description = map.get('VersionDescription')
        self.image_id = map.get('ImageId')
        self.image_owner_alias = map.get('ImageOwnerAlias')
        self.password_inherit = map.get('PasswordInherit')
        self.instance_type = map.get('InstanceType')
        self.security_group_id = map.get('SecurityGroupId')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.instance_name = map.get('InstanceName')
        self.description = map.get('Description')
        self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        self.host_name = map.get('HostName')
        self.zone_id = map.get('ZoneId')
        if map.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateVersionRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = CreateLaunchTemplateVersionRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        else:
            self.data_disk = None
        self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateVersionRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        else:
            self.network_interface = None
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.internet_charge_type = map.get('InternetChargeType')
        self.enable_vm_os_config = map.get('EnableVmOsConfig')
        self.network_type = map.get('NetworkType')
        self.user_data = map.get('UserData')
        self.key_pair_name = map.get('KeyPairName')
        self.ram_role_name = map.get('RamRoleName')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_price_limit = map.get('SpotPriceLimit')
        self.spot_duration = map.get('SpotDuration')
        self.resource_group_id = map.get('ResourceGroupId')
        self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateLaunchTemplateVersionRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class CreateLaunchTemplateVersionRequestSystemDisk(TeaModel):
    def __init__(self, category=None, size=None, disk_name=None, description=None, iops=None):
        self.category = category        # type: str
        self.size = size                # type: int
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.iops = iops                # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Category'] = self.category
        result['Size'] = self.size
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        self.category = map.get('Category')
        self.size = map.get('Size')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.iops = map.get('Iops')
        return self


class CreateLaunchTemplateVersionRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size                # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.category = category        # type: str
        self.encrypted = encrypted      # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.device = device            # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['SnapshotId'] = self.snapshot_id
        result['Category'] = self.category
        result['Encrypted'] = self.encrypted
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['DeleteWithInstance'] = self.delete_with_instance
        result['Device'] = self.device
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.snapshot_id = map.get('SnapshotId')
        self.category = map.get('Category')
        self.encrypted = map.get('Encrypted')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.delete_with_instance = map.get('DeleteWithInstance')
        self.device = map.get('Device')
        return self


class CreateLaunchTemplateVersionRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['VSwitchId'] = self.v_switch_id
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.v_switch_id = map.get('VSwitchId')
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        return self


class CreateLaunchTemplateVersionRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CreateLaunchTemplateVersionResponse(TeaModel):
    def __init__(self, request_id=None, launch_template_version_number=None):
        self.request_id = request_id    # type: str
        self.launch_template_version_number = launch_template_version_number  # type: int

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.launch_template_version_number, 'launch_template_version_number')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['LaunchTemplateVersionNumber'] = self.launch_template_version_number
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.launch_template_version_number = map.get('LaunchTemplateVersionNumber')
        return self


class CreateLaunchTemplateRequest(TeaModel):
    def __init__(self, region_id=None, template_tag=None, launch_template_name=None, version_description=None,
                 image_id=None, image_owner_alias=None, password_inherit=None, instance_type=None, security_group_id=None,
                 vpc_id=None, v_switch_id=None, instance_name=None, description=None, internet_max_bandwidth_in=None,
                 internet_max_bandwidth_out=None, host_name=None, zone_id=None, system_disk=None, data_disk=None, io_optimized=None,
                 network_interface=None, instance_charge_type=None, period=None, internet_charge_type=None, enable_vm_os_config=None,
                 network_type=None, user_data=None, key_pair_name=None, ram_role_name=None, auto_release_time=None,
                 spot_strategy=None, spot_price_limit=None, spot_duration=None, resource_group_id=None,
                 template_resource_group_id=None, security_enhancement_strategy=None, tag=None):
        self.region_id = region_id      # type: str
        self.template_tag = template_tag  # type: List[CreateLaunchTemplateRequestTemplateTag]
        self.launch_template_name = launch_template_name  # type: str
        self.version_description = version_description  # type: str
        self.image_id = image_id        # type: str
        self.image_owner_alias = image_owner_alias  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.instance_type = instance_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.instance_name = instance_name  # type: str
        self.description = description  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.host_name = host_name      # type: str
        self.zone_id = zone_id          # type: str
        self.system_disk = system_disk  # type: CreateLaunchTemplateRequestSystemDisk
        self.data_disk = data_disk      # type: List[CreateLaunchTemplateRequestDataDisk]
        self.io_optimized = io_optimized  # type: str
        self.network_interface = network_interface  # type: List[CreateLaunchTemplateRequestNetworkInterface]
        self.instance_charge_type = instance_charge_type  # type: str
        self.period = period            # type: int
        self.internet_charge_type = internet_charge_type  # type: str
        self.enable_vm_os_config = enable_vm_os_config  # type: bool
        self.network_type = network_type  # type: str
        self.user_data = user_data      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_duration = spot_duration  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.template_resource_group_id = template_resource_group_id  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.tag = tag                  # type: List[CreateLaunchTemplateRequestTag]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()
        self.validate_required(self.launch_template_name, 'launch_template_name')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        else:
            result['TemplateTag'] = None
        result['LaunchTemplateName'] = self.launch_template_name
        result['VersionDescription'] = self.version_description
        result['ImageId'] = self.image_id
        result['ImageOwnerAlias'] = self.image_owner_alias
        result['PasswordInherit'] = self.password_inherit
        result['InstanceType'] = self.instance_type
        result['SecurityGroupId'] = self.security_group_id
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['InstanceName'] = self.instance_name
        result['Description'] = self.description
        result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        result['HostName'] = self.host_name
        result['ZoneId'] = self.zone_id
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        else:
            result['NetworkInterface'] = None
        result['InstanceChargeType'] = self.instance_charge_type
        result['Period'] = self.period
        result['InternetChargeType'] = self.internet_charge_type
        result['EnableVmOsConfig'] = self.enable_vm_os_config
        result['NetworkType'] = self.network_type
        result['UserData'] = self.user_data
        result['KeyPairName'] = self.key_pair_name
        result['RamRoleName'] = self.ram_role_name
        result['AutoReleaseTime'] = self.auto_release_time
        result['SpotStrategy'] = self.spot_strategy
        result['SpotPriceLimit'] = self.spot_price_limit
        result['SpotDuration'] = self.spot_duration
        result['ResourceGroupId'] = self.resource_group_id
        result['TemplateResourceGroupId'] = self.template_resource_group_id
        result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.template_tag = []
        if map.get('TemplateTag') is not None:
            for k in map.get('TemplateTag'):
                temp_model = CreateLaunchTemplateRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        else:
            self.template_tag = None
        self.launch_template_name = map.get('LaunchTemplateName')
        self.version_description = map.get('VersionDescription')
        self.image_id = map.get('ImageId')
        self.image_owner_alias = map.get('ImageOwnerAlias')
        self.password_inherit = map.get('PasswordInherit')
        self.instance_type = map.get('InstanceType')
        self.security_group_id = map.get('SecurityGroupId')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.instance_name = map.get('InstanceName')
        self.description = map.get('Description')
        self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        self.host_name = map.get('HostName')
        self.zone_id = map.get('ZoneId')
        if map.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = CreateLaunchTemplateRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        else:
            self.data_disk = None
        self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        else:
            self.network_interface = None
        self.instance_charge_type = map.get('InstanceChargeType')
        self.period = map.get('Period')
        self.internet_charge_type = map.get('InternetChargeType')
        self.enable_vm_os_config = map.get('EnableVmOsConfig')
        self.network_type = map.get('NetworkType')
        self.user_data = map.get('UserData')
        self.key_pair_name = map.get('KeyPairName')
        self.ram_role_name = map.get('RamRoleName')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_price_limit = map.get('SpotPriceLimit')
        self.spot_duration = map.get('SpotDuration')
        self.resource_group_id = map.get('ResourceGroupId')
        self.template_resource_group_id = map.get('TemplateResourceGroupId')
        self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateLaunchTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class CreateLaunchTemplateRequestTemplateTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CreateLaunchTemplateRequestSystemDisk(TeaModel):
    def __init__(self, category=None, size=None, disk_name=None, description=None, iops=None):
        self.category = category        # type: str
        self.size = size                # type: int
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.iops = iops                # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Category'] = self.category
        result['Size'] = self.size
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['Iops'] = self.iops
        return result

    def from_map(self, map={}):
        self.category = map.get('Category')
        self.size = map.get('Size')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.iops = map.get('Iops')
        return self


class CreateLaunchTemplateRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, disk_name=None, description=None,
                 delete_with_instance=None, device=None):
        self.size = size                # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.category = category        # type: str
        self.encrypted = encrypted      # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.device = device            # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['SnapshotId'] = self.snapshot_id
        result['Category'] = self.category
        result['Encrypted'] = self.encrypted
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['DeleteWithInstance'] = self.delete_with_instance
        result['Device'] = self.device
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.snapshot_id = map.get('SnapshotId')
        self.category = map.get('Category')
        self.encrypted = map.get('Encrypted')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.delete_with_instance = map.get('DeleteWithInstance')
        self.device = map.get('Device')
        return self


class CreateLaunchTemplateRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None,
                 network_interface_name=None, description=None):
        self.primary_ip_address = primary_ip_address  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['VSwitchId'] = self.v_switch_id
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.v_switch_id = map.get('VSwitchId')
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        return self


class CreateLaunchTemplateRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CreateLaunchTemplateResponse(TeaModel):
    def __init__(self, request_id=None, launch_template_id=None):
        self.request_id = request_id    # type: str
        self.launch_template_id = launch_template_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.launch_template_id, 'launch_template_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['LaunchTemplateId'] = self.launch_template_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.launch_template_id = map.get('LaunchTemplateId')
        return self


class InstallCloudAssistantRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        return self


class InstallCloudAssistantResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeCloudAssistantStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        return self


class DescribeCloudAssistantStatusResponse(TeaModel):
    def __init__(self, request_id=None, instance_cloud_assistant_status_set=None):
        self.request_id = request_id    # type: str
        self.instance_cloud_assistant_status_set = instance_cloud_assistant_status_set  # type: DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_cloud_assistant_status_set, 'instance_cloud_assistant_status_set')
        if self.instance_cloud_assistant_status_set:
            self.instance_cloud_assistant_status_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.instance_cloud_assistant_status_set is not None:
            result['InstanceCloudAssistantStatusSet'] = self.instance_cloud_assistant_status_set.to_map()
        else:
            result['InstanceCloudAssistantStatusSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('InstanceCloudAssistantStatusSet') is not None:
            temp_model = DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSet()
            self.instance_cloud_assistant_status_set = temp_model.from_map(map['InstanceCloudAssistantStatusSet'])
        else:
            self.instance_cloud_assistant_status_set = None
        return self


class DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus(TeaModel):
    def __init__(self, instance_id=None, cloud_assistant_status=None, cloud_assistant_version=None):
        self.instance_id = instance_id  # type: str
        self.cloud_assistant_status = cloud_assistant_status  # type: str
        self.cloud_assistant_version = cloud_assistant_version  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.cloud_assistant_status, 'cloud_assistant_status')
        self.validate_required(self.cloud_assistant_version, 'cloud_assistant_version')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['CloudAssistantStatus'] = self.cloud_assistant_status
        result['CloudAssistantVersion'] = self.cloud_assistant_version
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.cloud_assistant_status = map.get('CloudAssistantStatus')
        self.cloud_assistant_version = map.get('CloudAssistantVersion')
        return self


class DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSet(TeaModel):
    def __init__(self, instance_cloud_assistant_status=None):
        self.instance_cloud_assistant_status = instance_cloud_assistant_status  # type: List[DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus]

    def validate(self):
        self.validate_required(self.instance_cloud_assistant_status, 'instance_cloud_assistant_status')
        if self.instance_cloud_assistant_status:
            for k in self.instance_cloud_assistant_status:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceCloudAssistantStatus'] = []
        if self.instance_cloud_assistant_status is not None:
            for k in self.instance_cloud_assistant_status:
                result['InstanceCloudAssistantStatus'].append(k.to_map() if k else None)
        else:
            result['InstanceCloudAssistantStatus'] = None
        return result

    def from_map(self, map={}):
        self.instance_cloud_assistant_status = []
        if map.get('InstanceCloudAssistantStatus') is not None:
            for k in map.get('InstanceCloudAssistantStatus'):
                temp_model = DescribeCloudAssistantStatusResponseInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus()
                self.instance_cloud_assistant_status.append(temp_model.from_map(k))
        else:
            self.instance_cloud_assistant_status = None
        return self


class UnassignPrivateIpAddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, private_ip_address=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.private_ip_address = private_ip_address  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['PrivateIpAddress'] = self.private_ip_address
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.private_ip_address = map.get('PrivateIpAddress')
        return self


class UnassignPrivateIpAddressesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class AssignPrivateIpAddressesRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, private_ip_address=None,
                 secondary_private_ip_address_count=None, client_token=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.private_ip_address = private_ip_address  # type: List[str]
        self.secondary_private_ip_address_count = secondary_private_ip_address_count  # type: int
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['PrivateIpAddress'] = self.private_ip_address
        result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.secondary_private_ip_address_count = map.get('SecondaryPrivateIpAddressCount')
        self.client_token = map.get('ClientToken')
        return self


class AssignPrivateIpAddressesResponse(TeaModel):
    def __init__(self, request_id=None, assigned_private_ip_addresses_set=None):
        self.request_id = request_id    # type: str
        self.assigned_private_ip_addresses_set = assigned_private_ip_addresses_set  # type: AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.assigned_private_ip_addresses_set, 'assigned_private_ip_addresses_set')
        if self.assigned_private_ip_addresses_set:
            self.assigned_private_ip_addresses_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.assigned_private_ip_addresses_set is not None:
            result['AssignedPrivateIpAddressesSet'] = self.assigned_private_ip_addresses_set.to_map()
        else:
            result['AssignedPrivateIpAddressesSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('AssignedPrivateIpAddressesSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSet()
            self.assigned_private_ip_addresses_set = temp_model.from_map(map['AssignedPrivateIpAddressesSet'])
        else:
            self.assigned_private_ip_addresses_set = None
        return self


class AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSetPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None):
        # PrivateIpAddress
        self.private_ip_address = private_ip_address  # type: List[str]

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')

    def to_map(self):
        result = {}
        result['PrivateIpAddress'] = self.private_ip_address
        return result

    def from_map(self, map={}):
        self.private_ip_address = map.get('PrivateIpAddress')
        return self


class AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSet(TeaModel):
    def __init__(self, network_interface_id=None, private_ip_set=None):
        self.network_interface_id = network_interface_id  # type: str
        self.private_ip_set = private_ip_set  # type: AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSetPrivateIpSet

    def validate(self):
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            self.private_ip_set.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_set is not None:
            result['PrivateIpSet'] = self.private_ip_set.to_map()
        else:
            result['PrivateIpSet'] = None
        return result

    def from_map(self, map={}):
        self.network_interface_id = map.get('NetworkInterfaceId')
        if map.get('PrivateIpSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseAssignedPrivateIpAddressesSetPrivateIpSet()
            self.private_ip_set = temp_model.from_map(map['PrivateIpSet'])
        else:
            self.private_ip_set = None
        return self


class DescribeNetworkInterfacePermissionsRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, network_interface_permission_id=None,
                 page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: List[str]
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeNetworkInterfacePermissionsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 network_interface_permissions=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.network_interface_permissions = network_interface_permissions  # type: DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissions

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.network_interface_permissions, 'network_interface_permissions')
        if self.network_interface_permissions:
            self.network_interface_permissions.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.network_interface_permissions is not None:
            result['NetworkInterfacePermissions'] = self.network_interface_permissions.to_map()
        else:
            result['NetworkInterfacePermissions'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('NetworkInterfacePermissions') is not None:
            temp_model = DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissions()
            self.network_interface_permissions = temp_model.from_map(map['NetworkInterfacePermissions'])
        else:
            self.network_interface_permissions = None
        return self


class DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsNetworkInterfacePermission(TeaModel):
    def __init__(self, account_id=None, service_name=None, network_interface_id=None,
                 network_interface_permission_id=None, permission=None, permission_state=None):
        self.account_id = account_id    # type: int
        self.service_name = service_name  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: str
        self.permission = permission    # type: str
        self.permission_state = permission_state  # type: str

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.service_name, 'service_name')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')
        self.validate_required(self.permission, 'permission')
        self.validate_required(self.permission_state, 'permission_state')

    def to_map(self):
        result = {}
        result['AccountId'] = self.account_id
        result['ServiceName'] = self.service_name
        result['NetworkInterfaceId'] = self.network_interface_id
        result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        result['Permission'] = self.permission
        result['PermissionState'] = self.permission_state
        return result

    def from_map(self, map={}):
        self.account_id = map.get('AccountId')
        self.service_name = map.get('ServiceName')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        self.permission = map.get('Permission')
        self.permission_state = map.get('PermissionState')
        return self


class DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissions(TeaModel):
    def __init__(self, network_interface_permission=None):
        self.network_interface_permission = network_interface_permission  # type: List[DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsNetworkInterfacePermission]

    def validate(self):
        self.validate_required(self.network_interface_permission, 'network_interface_permission')
        if self.network_interface_permission:
            for k in self.network_interface_permission:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfacePermission'] = []
        if self.network_interface_permission is not None:
            for k in self.network_interface_permission:
                result['NetworkInterfacePermission'].append(k.to_map() if k else None)
        else:
            result['NetworkInterfacePermission'] = None
        return result

    def from_map(self, map={}):
        self.network_interface_permission = []
        if map.get('NetworkInterfacePermission') is not None:
            for k in map.get('NetworkInterfacePermission'):
                temp_model = DescribeNetworkInterfacePermissionsResponseNetworkInterfacePermissionsNetworkInterfacePermission()
                self.network_interface_permission.append(temp_model.from_map(k))
        else:
            self.network_interface_permission = None
        return self


class DeleteNetworkInterfacePermissionRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_permission_id=None, force=None):
        self.region_id = region_id      # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: str
        self.force = force              # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        result['Force'] = self.force
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        self.force = map.get('Force')
        return self


class DeleteNetworkInterfacePermissionResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateNetworkInterfacePermissionRequest(TeaModel):
    def __init__(self, region_id=None, account_id=None, network_interface_id=None, permission=None):
        self.region_id = region_id      # type: str
        self.account_id = account_id    # type: int
        self.network_interface_id = network_interface_id  # type: str
        self.permission = permission    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.permission, 'permission')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AccountId'] = self.account_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Permission'] = self.permission
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.account_id = map.get('AccountId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.permission = map.get('Permission')
        return self


class CreateNetworkInterfacePermissionResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_permission=None):
        self.request_id = request_id    # type: str
        self.network_interface_permission = network_interface_permission  # type: CreateNetworkInterfacePermissionResponseNetworkInterfacePermission

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_permission, 'network_interface_permission')
        if self.network_interface_permission:
            self.network_interface_permission.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.network_interface_permission is not None:
            result['NetworkInterfacePermission'] = self.network_interface_permission.to_map()
        else:
            result['NetworkInterfacePermission'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('NetworkInterfacePermission') is not None:
            temp_model = CreateNetworkInterfacePermissionResponseNetworkInterfacePermission()
            self.network_interface_permission = temp_model.from_map(map['NetworkInterfacePermission'])
        else:
            self.network_interface_permission = None
        return self


class CreateNetworkInterfacePermissionResponseNetworkInterfacePermission(TeaModel):
    def __init__(self, account_id=None, service_name=None, network_interface_id=None,
                 network_interface_permission_id=None, permission=None, permission_state=None):
        self.account_id = account_id    # type: int
        self.service_name = service_name  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: str
        self.permission = permission    # type: str
        self.permission_state = permission_state  # type: str

    def validate(self):
        self.validate_required(self.account_id, 'account_id')
        self.validate_required(self.service_name, 'service_name')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.network_interface_permission_id, 'network_interface_permission_id')
        self.validate_required(self.permission, 'permission')
        self.validate_required(self.permission_state, 'permission_state')

    def to_map(self):
        result = {}
        result['AccountId'] = self.account_id
        result['ServiceName'] = self.service_name
        result['NetworkInterfaceId'] = self.network_interface_id
        result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        result['Permission'] = self.permission
        result['PermissionState'] = self.permission_state
        return result

    def from_map(self, map={}):
        self.account_id = map.get('AccountId')
        self.service_name = map.get('ServiceName')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.network_interface_permission_id = map.get('NetworkInterfacePermissionId')
        self.permission = map.get('Permission')
        self.permission_state = map.get('PermissionState')
        return self


class GetInstanceScreenshotRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, wake_up=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.wake_up = wake_up          # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['WakeUp'] = self.wake_up
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.wake_up = map.get('WakeUp')
        return self


class GetInstanceScreenshotResponse(TeaModel):
    def __init__(self, request_id=None, instance_id=None, screenshot=None):
        self.request_id = request_id    # type: str
        self.instance_id = instance_id  # type: str
        self.screenshot = screenshot    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.screenshot, 'screenshot')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InstanceId'] = self.instance_id
        result['Screenshot'] = self.screenshot
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.instance_id = map.get('InstanceId')
        self.screenshot = map.get('Screenshot')
        return self


class GetInstanceConsoleOutputRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, remove_symbols=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.remove_symbols = remove_symbols  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['RemoveSymbols'] = self.remove_symbols
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.remove_symbols = map.get('RemoveSymbols')
        return self


class GetInstanceConsoleOutputResponse(TeaModel):
    def __init__(self, request_id=None, instance_id=None, console_output=None, last_update_time=None):
        self.request_id = request_id    # type: str
        self.instance_id = instance_id  # type: str
        self.console_output = console_output  # type: str
        self.last_update_time = last_update_time  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.console_output, 'console_output')
        self.validate_required(self.last_update_time, 'last_update_time')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InstanceId'] = self.instance_id
        result['ConsoleOutput'] = self.console_output
        result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.instance_id = map.get('InstanceId')
        self.console_output = map.get('ConsoleOutput')
        self.last_update_time = map.get('LastUpdateTime')
        return self


class DescribeResourcesModificationRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, migrate_across_zone=None, destination_resource=None,
                 operation_type=None, instance_type=None, cores=None, memory=None):
        self.region_id = region_id      # type: str
        self.resource_id = resource_id  # type: str
        self.migrate_across_zone = migrate_across_zone  # type: bool
        self.destination_resource = destination_resource  # type: str
        self.operation_type = operation_type  # type: str
        self.instance_type = instance_type  # type: str
        self.cores = cores              # type: int
        self.memory = memory            # type: float

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_id, 'resource_id')
        self.validate_required(self.destination_resource, 'destination_resource')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceId'] = self.resource_id
        result['MigrateAcrossZone'] = self.migrate_across_zone
        result['DestinationResource'] = self.destination_resource
        result['OperationType'] = self.operation_type
        result['InstanceType'] = self.instance_type
        result['Cores'] = self.cores
        result['Memory'] = self.memory
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_id = map.get('ResourceId')
        self.migrate_across_zone = map.get('MigrateAcrossZone')
        self.destination_resource = map.get('DestinationResource')
        self.operation_type = map.get('OperationType')
        self.instance_type = map.get('InstanceType')
        self.cores = map.get('Cores')
        self.memory = map.get('Memory')
        return self


class DescribeResourcesModificationResponse(TeaModel):
    def __init__(self, request_id=None, available_zones=None):
        self.request_id = request_id    # type: str
        self.available_zones = available_zones  # type: DescribeResourcesModificationResponseAvailableZones

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.available_zones, 'available_zones')
        if self.available_zones:
            self.available_zones.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones.to_map()
        else:
            result['AvailableZones'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('AvailableZones') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZones()
            self.available_zones = temp_model.from_map(map['AvailableZones'])
        else:
            self.available_zones = None
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource(TeaModel):
    def __init__(self, value=None, status=None, status_category=None, min=None, max=None, unit=None):
        self.value = value              # type: str
        self.status = status            # type: str
        self.status_category = status_category  # type: str
        self.min = min                  # type: int
        self.max = max                  # type: int
        self.unit = unit                # type: str

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        result['Value'] = self.value
        result['Status'] = self.status
        result['StatusCategory'] = self.status_category
        result['Min'] = self.min
        result['Max'] = self.max
        result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        self.value = map.get('Value')
        self.status = map.get('Status')
        self.status_category = map.get('StatusCategory')
        self.min = map.get('Min')
        self.max = map.get('Max')
        self.unit = map.get('Unit')
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources(TeaModel):
    def __init__(self, supported_resource=None):
        self.supported_resource = supported_resource  # type: List[DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource]

    def validate(self):
        self.validate_required(self.supported_resource, 'supported_resource')
        if self.supported_resource:
            for k in self.supported_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupportedResource'] = []
        if self.supported_resource is not None:
            for k in self.supported_resource:
                result['SupportedResource'].append(k.to_map() if k else None)
        else:
            result['SupportedResource'] = None
        return result

    def from_map(self, map={}):
        self.supported_resource = []
        if map.get('SupportedResource') is not None:
            for k in map.get('SupportedResource'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource()
                self.supported_resource.append(temp_model.from_map(k))
        else:
            self.supported_resource = None
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource(TeaModel):
    def __init__(self, type=None, supported_resources=None):
        self.type = type                # type: str
        self.supported_resources = supported_resources  # type: DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.supported_resources, 'supported_resources')
        if self.supported_resources:
            self.supported_resources.validate()

    def to_map(self):
        result = {}
        result['Type'] = self.type
        if self.supported_resources is not None:
            result['SupportedResources'] = self.supported_resources.to_map()
        else:
            result['SupportedResources'] = None
        return result

    def from_map(self, map={}):
        self.type = map.get('Type')
        if map.get('SupportedResources') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources()
            self.supported_resources = temp_model.from_map(map['SupportedResources'])
        else:
            self.supported_resources = None
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResources(TeaModel):
    def __init__(self, available_resource=None):
        self.available_resource = available_resource  # type: List[DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource]

    def validate(self):
        self.validate_required(self.available_resource, 'available_resource')
        if self.available_resource:
            for k in self.available_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableResource'] = []
        if self.available_resource is not None:
            for k in self.available_resource:
                result['AvailableResource'].append(k.to_map() if k else None)
        else:
            result['AvailableResource'] = None
        return result

    def from_map(self, map={}):
        self.available_resource = []
        if map.get('AvailableResource') is not None:
            for k in map.get('AvailableResource'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource()
                self.available_resource.append(temp_model.from_map(k))
        else:
            self.available_resource = None
        return self


class DescribeResourcesModificationResponseAvailableZonesAvailableZone(TeaModel):
    def __init__(self, region_id=None, zone_id=None, status=None, status_category=None, available_resources=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.status = status            # type: str
        self.status_category = status_category  # type: str
        self.available_resources = available_resources  # type: DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResources

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.available_resources, 'available_resources')
        if self.available_resources:
            self.available_resources.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['Status'] = self.status
        result['StatusCategory'] = self.status_category
        if self.available_resources is not None:
            result['AvailableResources'] = self.available_resources.to_map()
        else:
            result['AvailableResources'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.status = map.get('Status')
        self.status_category = map.get('StatusCategory')
        if map.get('AvailableResources') is not None:
            temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZoneAvailableResources()
            self.available_resources = temp_model.from_map(map['AvailableResources'])
        else:
            self.available_resources = None
        return self


class DescribeResourcesModificationResponseAvailableZones(TeaModel):
    def __init__(self, available_zone=None):
        self.available_zone = available_zone  # type: List[DescribeResourcesModificationResponseAvailableZonesAvailableZone]

    def validate(self):
        self.validate_required(self.available_zone, 'available_zone')
        if self.available_zone:
            for k in self.available_zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableZone'] = []
        if self.available_zone is not None:
            for k in self.available_zone:
                result['AvailableZone'].append(k.to_map() if k else None)
        else:
            result['AvailableZone'] = None
        return result

    def from_map(self, map={}):
        self.available_zone = []
        if map.get('AvailableZone') is not None:
            for k in map.get('AvailableZone'):
                temp_model = DescribeResourcesModificationResponseAvailableZonesAvailableZone()
                self.available_zone.append(temp_model.from_map(k))
        else:
            self.available_zone = None
        return self


class DescribeBandwidthLimitationRequest(TeaModel):
    def __init__(self, region_id=None, instance_charge_type=None, spot_strategy=None, instance_type=None,
                 resource_id=None, operation_type=None):
        self.region_id = region_id      # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.instance_type = instance_type  # type: str
        self.resource_id = resource_id  # type: str
        self.operation_type = operation_type  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceChargeType'] = self.instance_charge_type
        result['SpotStrategy'] = self.spot_strategy
        result['InstanceType'] = self.instance_type
        result['ResourceId'] = self.resource_id
        result['OperationType'] = self.operation_type
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.spot_strategy = map.get('SpotStrategy')
        self.instance_type = map.get('InstanceType')
        self.resource_id = map.get('ResourceId')
        self.operation_type = map.get('OperationType')
        return self


class DescribeBandwidthLimitationResponse(TeaModel):
    def __init__(self, request_id=None, bandwidths=None):
        self.request_id = request_id    # type: str
        self.bandwidths = bandwidths    # type: DescribeBandwidthLimitationResponseBandwidths

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.bandwidths, 'bandwidths')
        if self.bandwidths:
            self.bandwidths.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.bandwidths is not None:
            result['Bandwidths'] = self.bandwidths.to_map()
        else:
            result['Bandwidths'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Bandwidths') is not None:
            temp_model = DescribeBandwidthLimitationResponseBandwidths()
            self.bandwidths = temp_model.from_map(map['Bandwidths'])
        else:
            self.bandwidths = None
        return self


class DescribeBandwidthLimitationResponseBandwidthsBandwidth(TeaModel):
    def __init__(self, internet_charge_type=None, min=None, max=None, unit=None):
        self.internet_charge_type = internet_charge_type  # type: str
        self.min = min                  # type: int
        self.max = max                  # type: int
        self.unit = unit                # type: str

    def validate(self):
        self.validate_required(self.internet_charge_type, 'internet_charge_type')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        result['InternetChargeType'] = self.internet_charge_type
        result['Min'] = self.min
        result['Max'] = self.max
        result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        self.internet_charge_type = map.get('InternetChargeType')
        self.min = map.get('Min')
        self.max = map.get('Max')
        self.unit = map.get('Unit')
        return self


class DescribeBandwidthLimitationResponseBandwidths(TeaModel):
    def __init__(self, bandwidth=None):
        self.bandwidth = bandwidth      # type: List[DescribeBandwidthLimitationResponseBandwidthsBandwidth]

    def validate(self):
        self.validate_required(self.bandwidth, 'bandwidth')
        if self.bandwidth:
            for k in self.bandwidth:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Bandwidth'] = []
        if self.bandwidth is not None:
            for k in self.bandwidth:
                result['Bandwidth'].append(k.to_map() if k else None)
        else:
            result['Bandwidth'] = None
        return result

    def from_map(self, map={}):
        self.bandwidth = []
        if map.get('Bandwidth') is not None:
            for k in map.get('Bandwidth'):
                temp_model = DescribeBandwidthLimitationResponseBandwidthsBandwidth()
                self.bandwidth.append(temp_model.from_map(k))
        else:
            self.bandwidth = None
        return self


class DescribeAvailableResourceRequest(TeaModel):
    def __init__(self, region_id=None, instance_charge_type=None, spot_strategy=None, spot_duration=None,
                 destination_resource=None, zone_id=None, io_optimized=None, dedicated_host_id=None, instance_type=None,
                 system_disk_category=None, data_disk_category=None, network_category=None, cores=None, memory=None, resource_type=None,
                 scope=None):
        self.region_id = region_id      # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_duration = spot_duration  # type: int
        self.destination_resource = destination_resource  # type: str
        self.zone_id = zone_id          # type: str
        self.io_optimized = io_optimized  # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.instance_type = instance_type  # type: str
        self.system_disk_category = system_disk_category  # type: str
        self.data_disk_category = data_disk_category  # type: str
        self.network_category = network_category  # type: str
        self.cores = cores              # type: int
        self.memory = memory            # type: float
        self.resource_type = resource_type  # type: str
        self.scope = scope              # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.destination_resource, 'destination_resource')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceChargeType'] = self.instance_charge_type
        result['SpotStrategy'] = self.spot_strategy
        result['SpotDuration'] = self.spot_duration
        result['DestinationResource'] = self.destination_resource
        result['ZoneId'] = self.zone_id
        result['IoOptimized'] = self.io_optimized
        result['DedicatedHostId'] = self.dedicated_host_id
        result['InstanceType'] = self.instance_type
        result['SystemDiskCategory'] = self.system_disk_category
        result['DataDiskCategory'] = self.data_disk_category
        result['NetworkCategory'] = self.network_category
        result['Cores'] = self.cores
        result['Memory'] = self.memory
        result['ResourceType'] = self.resource_type
        result['Scope'] = self.scope
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_duration = map.get('SpotDuration')
        self.destination_resource = map.get('DestinationResource')
        self.zone_id = map.get('ZoneId')
        self.io_optimized = map.get('IoOptimized')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.instance_type = map.get('InstanceType')
        self.system_disk_category = map.get('SystemDiskCategory')
        self.data_disk_category = map.get('DataDiskCategory')
        self.network_category = map.get('NetworkCategory')
        self.cores = map.get('Cores')
        self.memory = map.get('Memory')
        self.resource_type = map.get('ResourceType')
        self.scope = map.get('Scope')
        return self


class DescribeAvailableResourceResponse(TeaModel):
    def __init__(self, request_id=None, available_zones=None):
        self.request_id = request_id    # type: str
        self.available_zones = available_zones  # type: DescribeAvailableResourceResponseAvailableZones

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.available_zones, 'available_zones')
        if self.available_zones:
            self.available_zones.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones.to_map()
        else:
            result['AvailableZones'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('AvailableZones') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZones()
            self.available_zones = temp_model.from_map(map['AvailableZones'])
        else:
            self.available_zones = None
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource(TeaModel):
    def __init__(self, value=None, status=None, status_category=None, min=None, max=None, unit=None):
        self.value = value              # type: str
        self.status = status            # type: str
        self.status_category = status_category  # type: str
        self.min = min                  # type: int
        self.max = max                  # type: int
        self.unit = unit                # type: str

    def validate(self):
        self.validate_required(self.value, 'value')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.min, 'min')
        self.validate_required(self.max, 'max')
        self.validate_required(self.unit, 'unit')

    def to_map(self):
        result = {}
        result['Value'] = self.value
        result['Status'] = self.status
        result['StatusCategory'] = self.status_category
        result['Min'] = self.min
        result['Max'] = self.max
        result['Unit'] = self.unit
        return result

    def from_map(self, map={}):
        self.value = map.get('Value')
        self.status = map.get('Status')
        self.status_category = map.get('StatusCategory')
        self.min = map.get('Min')
        self.max = map.get('Max')
        self.unit = map.get('Unit')
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources(TeaModel):
    def __init__(self, supported_resource=None):
        self.supported_resource = supported_resource  # type: List[DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource]

    def validate(self):
        self.validate_required(self.supported_resource, 'supported_resource')
        if self.supported_resource:
            for k in self.supported_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SupportedResource'] = []
        if self.supported_resource is not None:
            for k in self.supported_resource:
                result['SupportedResource'].append(k.to_map() if k else None)
        else:
            result['SupportedResource'] = None
        return result

    def from_map(self, map={}):
        self.supported_resource = []
        if map.get('SupportedResource') is not None:
            for k in map.get('SupportedResource'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource()
                self.supported_resource.append(temp_model.from_map(k))
        else:
            self.supported_resource = None
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource(TeaModel):
    def __init__(self, type=None, supported_resources=None):
        self.type = type                # type: str
        self.supported_resources = supported_resources  # type: DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.supported_resources, 'supported_resources')
        if self.supported_resources:
            self.supported_resources.validate()

    def to_map(self):
        result = {}
        result['Type'] = self.type
        if self.supported_resources is not None:
            result['SupportedResources'] = self.supported_resources.to_map()
        else:
            result['SupportedResources'] = None
        return result

    def from_map(self, map={}):
        self.type = map.get('Type')
        if map.get('SupportedResources') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources()
            self.supported_resources = temp_model.from_map(map['SupportedResources'])
        else:
            self.supported_resources = None
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResources(TeaModel):
    def __init__(self, available_resource=None):
        self.available_resource = available_resource  # type: List[DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource]

    def validate(self):
        self.validate_required(self.available_resource, 'available_resource')
        if self.available_resource:
            for k in self.available_resource:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableResource'] = []
        if self.available_resource is not None:
            for k in self.available_resource:
                result['AvailableResource'].append(k.to_map() if k else None)
        else:
            result['AvailableResource'] = None
        return result

    def from_map(self, map={}):
        self.available_resource = []
        if map.get('AvailableResource') is not None:
            for k in map.get('AvailableResource'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResourcesAvailableResource()
                self.available_resource.append(temp_model.from_map(k))
        else:
            self.available_resource = None
        return self


class DescribeAvailableResourceResponseAvailableZonesAvailableZone(TeaModel):
    def __init__(self, region_id=None, zone_id=None, status=None, status_category=None, available_resources=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.status = status            # type: str
        self.status_category = status_category  # type: str
        self.available_resources = available_resources  # type: DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResources

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.status_category, 'status_category')
        self.validate_required(self.available_resources, 'available_resources')
        if self.available_resources:
            self.available_resources.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['Status'] = self.status
        result['StatusCategory'] = self.status_category
        if self.available_resources is not None:
            result['AvailableResources'] = self.available_resources.to_map()
        else:
            result['AvailableResources'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.status = map.get('Status')
        self.status_category = map.get('StatusCategory')
        if map.get('AvailableResources') is not None:
            temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZoneAvailableResources()
            self.available_resources = temp_model.from_map(map['AvailableResources'])
        else:
            self.available_resources = None
        return self


class DescribeAvailableResourceResponseAvailableZones(TeaModel):
    def __init__(self, available_zone=None):
        self.available_zone = available_zone  # type: List[DescribeAvailableResourceResponseAvailableZonesAvailableZone]

    def validate(self):
        self.validate_required(self.available_zone, 'available_zone')
        if self.available_zone:
            for k in self.available_zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AvailableZone'] = []
        if self.available_zone is not None:
            for k in self.available_zone:
                result['AvailableZone'].append(k.to_map() if k else None)
        else:
            result['AvailableZone'] = None
        return result

    def from_map(self, map={}):
        self.available_zone = []
        if map.get('AvailableZone') is not None:
            for k in map.get('AvailableZone'):
                temp_model = DescribeAvailableResourceResponseAvailableZonesAvailableZone()
                self.available_zone.append(temp_model.from_map(k))
        else:
            self.available_zone = None
        return self


class ReActivateInstancesRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        return self


class ReActivateInstancesResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstancesFullStatusRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_id=None, status=None, health_status=None,
                 instance_event_type=None, event_type=None, not_before=None, event_publish_time=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.event_id = event_id        # type: List[str]
        self.status = status            # type: str
        self.health_status = health_status  # type: str
        self.instance_event_type = instance_event_type  # type: List[str]
        self.event_type = event_type    # type: str
        self.not_before = not_before    # type: DescribeInstancesFullStatusRequestNotBefore
        self.event_publish_time = event_publish_time  # type: DescribeInstancesFullStatusRequestEventPublishTime
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.not_before:
            self.not_before.validate()
        if self.event_publish_time:
            self.event_publish_time.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['EventId'] = self.event_id
        result['Status'] = self.status
        result['HealthStatus'] = self.health_status
        result['InstanceEventType'] = self.instance_event_type
        result['EventType'] = self.event_type
        if self.not_before is not None:
            result['NotBefore'] = self.not_before.to_map()
        else:
            result['NotBefore'] = None
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time.to_map()
        else:
            result['EventPublishTime'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.event_id = map.get('EventId')
        self.status = map.get('Status')
        self.health_status = map.get('HealthStatus')
        self.instance_event_type = map.get('InstanceEventType')
        self.event_type = map.get('EventType')
        if map.get('NotBefore') is not None:
            temp_model = DescribeInstancesFullStatusRequestNotBefore()
            self.not_before = temp_model.from_map(map['NotBefore'])
        else:
            self.not_before = None
        if map.get('EventPublishTime') is not None:
            temp_model = DescribeInstancesFullStatusRequestEventPublishTime()
            self.event_publish_time = temp_model.from_map(map['EventPublishTime'])
        else:
            self.event_publish_time = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInstancesFullStatusRequestNotBefore(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self


class DescribeInstancesFullStatusRequestEventPublishTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self


class DescribeInstancesFullStatusResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 instance_full_status_set=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.instance_full_status_set = instance_full_status_set  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instance_full_status_set, 'instance_full_status_set')
        if self.instance_full_status_set:
            self.instance_full_status_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.instance_full_status_set is not None:
            result['InstanceFullStatusSet'] = self.instance_full_status_set.to_map()
        else:
            result['InstanceFullStatusSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('InstanceFullStatusSet') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSet()
            self.instance_full_status_set = temp_model.from_map(map['InstanceFullStatusSet'])
        else:
            self.instance_full_status_set = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventCycleStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk(TeaModel):
    def __init__(self, creation_time=None, release_time=None, device_type=None, device_category=None,
                 device_size=None):
        self.creation_time = creation_time  # type: str
        self.release_time = release_time  # type: str
        self.device_type = device_type  # type: str
        self.device_category = device_category  # type: str
        self.device_size = device_size  # type: str

    def validate(self):
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.release_time, 'release_time')
        self.validate_required(self.device_type, 'device_type')
        self.validate_required(self.device_category, 'device_category')
        self.validate_required(self.device_size, 'device_size')

    def to_map(self):
        result = {}
        result['CreationTime'] = self.creation_time
        result['ReleaseTime'] = self.release_time
        result['DeviceType'] = self.device_type
        result['DeviceCategory'] = self.device_category
        result['DeviceSize'] = self.device_size
        return result

    def from_map(self, map={}):
        self.creation_time = map.get('CreationTime')
        self.release_time = map.get('ReleaseTime')
        self.device_type = map.get('DeviceType')
        self.device_category = map.get('DeviceCategory')
        self.device_size = map.get('DeviceSize')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisks(TeaModel):
    def __init__(self, inactive_disk=None):
        self.inactive_disk = inactive_disk  # type: List[DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk]

    def validate(self):
        self.validate_required(self.inactive_disk, 'inactive_disk')
        if self.inactive_disk:
            for k in self.inactive_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InactiveDisk'] = []
        if self.inactive_disk is not None:
            for k in self.inactive_disk:
                result['InactiveDisk'].append(k.to_map() if k else None)
        else:
            result['InactiveDisk'] = None
        return result

    def from_map(self, map={}):
        self.inactive_disk = []
        if map.get('InactiveDisk') is not None:
            for k in map.get('InactiveDisk'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk()
                self.inactive_disk.append(temp_model.from_map(k))
        else:
            self.inactive_disk = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttribute(TeaModel):
    def __init__(self, disk_id=None, device=None, inactive_disks=None):
        self.disk_id = disk_id          # type: str
        self.device = device            # type: str
        self.inactive_disks = inactive_disks  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisks

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.inactive_disks, 'inactive_disks')
        if self.inactive_disks:
            self.inactive_disks.validate()

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['Device'] = self.device
        if self.inactive_disks is not None:
            result['InactiveDisks'] = self.inactive_disks.to_map()
        else:
            result['InactiveDisks'] = None
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.device = map.get('Device')
        if map.get('InactiveDisks') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttributeInactiveDisks()
            self.inactive_disks = temp_model.from_map(map['InactiveDisks'])
        else:
            self.inactive_disks = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventType(TeaModel):
    def __init__(self, event_id=None, event_publish_time=None, not_before=None, reason=None, impact_level=None,
                 event_cycle_status=None, event_type=None, extended_attribute=None):
        self.event_id = event_id        # type: str
        self.event_publish_time = event_publish_time  # type: str
        self.not_before = not_before    # type: str
        self.reason = reason            # type: str
        self.impact_level = impact_level  # type: str
        self.event_cycle_status = event_cycle_status  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventCycleStatus
        self.event_type = event_type    # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventType
        self.extended_attribute = extended_attribute  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttribute

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_publish_time, 'event_publish_time')
        self.validate_required(self.not_before, 'not_before')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_cycle_status, 'event_cycle_status')
        if self.event_cycle_status:
            self.event_cycle_status.validate()
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()
        self.validate_required(self.extended_attribute, 'extended_attribute')
        if self.extended_attribute:
            self.extended_attribute.validate()

    def to_map(self):
        result = {}
        result['EventId'] = self.event_id
        result['EventPublishTime'] = self.event_publish_time
        result['NotBefore'] = self.not_before
        result['Reason'] = self.reason
        result['ImpactLevel'] = self.impact_level
        if self.event_cycle_status is not None:
            result['EventCycleStatus'] = self.event_cycle_status.to_map()
        else:
            result['EventCycleStatus'] = None
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        else:
            result['EventType'] = None
        if self.extended_attribute is not None:
            result['ExtendedAttribute'] = self.extended_attribute.to_map()
        else:
            result['ExtendedAttribute'] = None
        return result

    def from_map(self, map={}):
        self.event_id = map.get('EventId')
        self.event_publish_time = map.get('EventPublishTime')
        self.not_before = map.get('NotBefore')
        self.reason = map.get('Reason')
        self.impact_level = map.get('ImpactLevel')
        if map.get('EventCycleStatus') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventCycleStatus()
            self.event_cycle_status = temp_model.from_map(map['EventCycleStatus'])
        else:
            self.event_cycle_status = None
        if map.get('EventType') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        else:
            self.event_type = None
        if map.get('ExtendedAttribute') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventTypeExtendedAttribute()
            self.extended_attribute = temp_model.from_map(map['ExtendedAttribute'])
        else:
            self.extended_attribute = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSet(TeaModel):
    def __init__(self, scheduled_system_event_type=None):
        self.scheduled_system_event_type = scheduled_system_event_type  # type: List[DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventType]

    def validate(self):
        self.validate_required(self.scheduled_system_event_type, 'scheduled_system_event_type')
        if self.scheduled_system_event_type:
            for k in self.scheduled_system_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ScheduledSystemEventType'] = []
        if self.scheduled_system_event_type is not None:
            for k in self.scheduled_system_event_type:
                result['ScheduledSystemEventType'].append(k.to_map() if k else None)
        else:
            result['ScheduledSystemEventType'] = None
        return result

    def from_map(self, map={}):
        self.scheduled_system_event_type = []
        if map.get('ScheduledSystemEventType') is not None:
            for k in map.get('ScheduledSystemEventType'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSetScheduledSystemEventType()
                self.scheduled_system_event_type.append(temp_model.from_map(k))
        else:
            self.scheduled_system_event_type = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeHealthStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusType(TeaModel):
    def __init__(self, instance_id=None, scheduled_system_event_set=None, status=None, health_status=None):
        self.instance_id = instance_id  # type: str
        self.scheduled_system_event_set = scheduled_system_event_set  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSet
        self.status = status            # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeStatus
        self.health_status = health_status  # type: DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeHealthStatus

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.scheduled_system_event_set, 'scheduled_system_event_set')
        if self.scheduled_system_event_set:
            self.scheduled_system_event_set.validate()
        self.validate_required(self.status, 'status')
        if self.status:
            self.status.validate()
        self.validate_required(self.health_status, 'health_status')
        if self.health_status:
            self.health_status.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        if self.scheduled_system_event_set is not None:
            result['ScheduledSystemEventSet'] = self.scheduled_system_event_set.to_map()
        else:
            result['ScheduledSystemEventSet'] = None
        if self.status is not None:
            result['Status'] = self.status.to_map()
        else:
            result['Status'] = None
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status.to_map()
        else:
            result['HealthStatus'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        if map.get('ScheduledSystemEventSet') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeScheduledSystemEventSet()
            self.scheduled_system_event_set = temp_model.from_map(map['ScheduledSystemEventSet'])
        else:
            self.scheduled_system_event_set = None
        if map.get('Status') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeStatus()
            self.status = temp_model.from_map(map['Status'])
        else:
            self.status = None
        if map.get('HealthStatus') is not None:
            temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusTypeHealthStatus()
            self.health_status = temp_model.from_map(map['HealthStatus'])
        else:
            self.health_status = None
        return self


class DescribeInstancesFullStatusResponseInstanceFullStatusSet(TeaModel):
    def __init__(self, instance_full_status_type=None):
        self.instance_full_status_type = instance_full_status_type  # type: List[DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusType]

    def validate(self):
        self.validate_required(self.instance_full_status_type, 'instance_full_status_type')
        if self.instance_full_status_type:
            for k in self.instance_full_status_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceFullStatusType'] = []
        if self.instance_full_status_type is not None:
            for k in self.instance_full_status_type:
                result['InstanceFullStatusType'].append(k.to_map() if k else None)
        else:
            result['InstanceFullStatusType'] = None
        return result

    def from_map(self, map={}):
        self.instance_full_status_type = []
        if map.get('InstanceFullStatusType') is not None:
            for k in map.get('InstanceFullStatusType'):
                temp_model = DescribeInstancesFullStatusResponseInstanceFullStatusSetInstanceFullStatusType()
                self.instance_full_status_type.append(temp_model.from_map(k))
        else:
            self.instance_full_status_type = None
        return self


class DescribeInstanceHistoryEventsRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, event_id=None, instance_event_cycle_status=None,
                 event_cycle_status=None, instance_event_type=None, event_type=None, not_before=None, event_publish_time=None,
                 impact_level=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.event_id = event_id        # type: List[str]
        self.instance_event_cycle_status = instance_event_cycle_status  # type: List[str]
        self.event_cycle_status = event_cycle_status  # type: str
        self.instance_event_type = instance_event_type  # type: List[str]
        self.event_type = event_type    # type: str
        self.not_before = not_before    # type: DescribeInstanceHistoryEventsRequestNotBefore
        self.event_publish_time = event_publish_time  # type: DescribeInstanceHistoryEventsRequestEventPublishTime
        self.impact_level = impact_level  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.not_before:
            self.not_before.validate()
        if self.event_publish_time:
            self.event_publish_time.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['EventId'] = self.event_id
        result['InstanceEventCycleStatus'] = self.instance_event_cycle_status
        result['EventCycleStatus'] = self.event_cycle_status
        result['InstanceEventType'] = self.instance_event_type
        result['EventType'] = self.event_type
        if self.not_before is not None:
            result['NotBefore'] = self.not_before.to_map()
        else:
            result['NotBefore'] = None
        if self.event_publish_time is not None:
            result['EventPublishTime'] = self.event_publish_time.to_map()
        else:
            result['EventPublishTime'] = None
        result['ImpactLevel'] = self.impact_level
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.event_id = map.get('EventId')
        self.instance_event_cycle_status = map.get('InstanceEventCycleStatus')
        self.event_cycle_status = map.get('EventCycleStatus')
        self.instance_event_type = map.get('InstanceEventType')
        self.event_type = map.get('EventType')
        if map.get('NotBefore') is not None:
            temp_model = DescribeInstanceHistoryEventsRequestNotBefore()
            self.not_before = temp_model.from_map(map['NotBefore'])
        else:
            self.not_before = None
        if map.get('EventPublishTime') is not None:
            temp_model = DescribeInstanceHistoryEventsRequestEventPublishTime()
            self.event_publish_time = temp_model.from_map(map['EventPublishTime'])
        else:
            self.event_publish_time = None
        self.impact_level = map.get('ImpactLevel')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInstanceHistoryEventsRequestNotBefore(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self


class DescribeInstanceHistoryEventsRequestEventPublishTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self


class DescribeInstanceHistoryEventsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 instance_system_event_set=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.instance_system_event_set = instance_system_event_set  # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.instance_system_event_set, 'instance_system_event_set')
        if self.instance_system_event_set:
            self.instance_system_event_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.instance_system_event_set is not None:
            result['InstanceSystemEventSet'] = self.instance_system_event_set.to_map()
        else:
            result['InstanceSystemEventSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('InstanceSystemEventSet') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSet()
            self.instance_system_event_set = temp_model.from_map(map['InstanceSystemEventSet'])
        else:
            self.instance_system_event_set = None
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventCycleStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk(TeaModel):
    def __init__(self, creation_time=None, release_time=None, device_type=None, device_category=None,
                 device_size=None):
        self.creation_time = creation_time  # type: str
        self.release_time = release_time  # type: str
        self.device_type = device_type  # type: str
        self.device_category = device_category  # type: str
        self.device_size = device_size  # type: str

    def validate(self):
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.release_time, 'release_time')
        self.validate_required(self.device_type, 'device_type')
        self.validate_required(self.device_category, 'device_category')
        self.validate_required(self.device_size, 'device_size')

    def to_map(self):
        result = {}
        result['CreationTime'] = self.creation_time
        result['ReleaseTime'] = self.release_time
        result['DeviceType'] = self.device_type
        result['DeviceCategory'] = self.device_category
        result['DeviceSize'] = self.device_size
        return result

    def from_map(self, map={}):
        self.creation_time = map.get('CreationTime')
        self.release_time = map.get('ReleaseTime')
        self.device_type = map.get('DeviceType')
        self.device_category = map.get('DeviceCategory')
        self.device_size = map.get('DeviceSize')
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisks(TeaModel):
    def __init__(self, inactive_disk=None):
        self.inactive_disk = inactive_disk  # type: List[DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk]

    def validate(self):
        self.validate_required(self.inactive_disk, 'inactive_disk')
        if self.inactive_disk:
            for k in self.inactive_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InactiveDisk'] = []
        if self.inactive_disk is not None:
            for k in self.inactive_disk:
                result['InactiveDisk'].append(k.to_map() if k else None)
        else:
            result['InactiveDisk'] = None
        return result

    def from_map(self, map={}):
        self.inactive_disk = []
        if map.get('InactiveDisk') is not None:
            for k in map.get('InactiveDisk'):
                temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisksInactiveDisk()
                self.inactive_disk.append(temp_model.from_map(k))
        else:
            self.inactive_disk = None
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttribute(TeaModel):
    def __init__(self, disk_id=None, device=None, inactive_disks=None):
        self.disk_id = disk_id          # type: str
        self.device = device            # type: str
        self.inactive_disks = inactive_disks  # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisks

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.inactive_disks, 'inactive_disks')
        if self.inactive_disks:
            self.inactive_disks.validate()

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['Device'] = self.device
        if self.inactive_disks is not None:
            result['InactiveDisks'] = self.inactive_disks.to_map()
        else:
            result['InactiveDisks'] = None
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.device = map.get('Device')
        if map.get('InactiveDisks') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttributeInactiveDisks()
            self.inactive_disks = temp_model.from_map(map['InactiveDisks'])
        else:
            self.inactive_disks = None
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventType(TeaModel):
    def __init__(self, instance_id=None, event_id=None, event_publish_time=None, not_before=None,
                 event_finish_time=None, reason=None, impact_level=None, event_type=None, event_cycle_status=None,
                 extended_attribute=None):
        self.instance_id = instance_id  # type: str
        self.event_id = event_id        # type: str
        self.event_publish_time = event_publish_time  # type: str
        self.not_before = not_before    # type: str
        self.event_finish_time = event_finish_time  # type: str
        self.reason = reason            # type: str
        self.impact_level = impact_level  # type: str
        self.event_type = event_type    # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventType
        self.event_cycle_status = event_cycle_status  # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventCycleStatus
        self.extended_attribute = extended_attribute  # type: DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttribute

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_publish_time, 'event_publish_time')
        self.validate_required(self.not_before, 'not_before')
        self.validate_required(self.event_finish_time, 'event_finish_time')
        self.validate_required(self.reason, 'reason')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()
        self.validate_required(self.event_cycle_status, 'event_cycle_status')
        if self.event_cycle_status:
            self.event_cycle_status.validate()
        self.validate_required(self.extended_attribute, 'extended_attribute')
        if self.extended_attribute:
            self.extended_attribute.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['EventId'] = self.event_id
        result['EventPublishTime'] = self.event_publish_time
        result['NotBefore'] = self.not_before
        result['EventFinishTime'] = self.event_finish_time
        result['Reason'] = self.reason
        result['ImpactLevel'] = self.impact_level
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        else:
            result['EventType'] = None
        if self.event_cycle_status is not None:
            result['EventCycleStatus'] = self.event_cycle_status.to_map()
        else:
            result['EventCycleStatus'] = None
        if self.extended_attribute is not None:
            result['ExtendedAttribute'] = self.extended_attribute.to_map()
        else:
            result['ExtendedAttribute'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.event_id = map.get('EventId')
        self.event_publish_time = map.get('EventPublishTime')
        self.not_before = map.get('NotBefore')
        self.event_finish_time = map.get('EventFinishTime')
        self.reason = map.get('Reason')
        self.impact_level = map.get('ImpactLevel')
        if map.get('EventType') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        else:
            self.event_type = None
        if map.get('EventCycleStatus') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeEventCycleStatus()
            self.event_cycle_status = temp_model.from_map(map['EventCycleStatus'])
        else:
            self.event_cycle_status = None
        if map.get('ExtendedAttribute') is not None:
            temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventTypeExtendedAttribute()
            self.extended_attribute = temp_model.from_map(map['ExtendedAttribute'])
        else:
            self.extended_attribute = None
        return self


class DescribeInstanceHistoryEventsResponseInstanceSystemEventSet(TeaModel):
    def __init__(self, instance_system_event_type=None):
        self.instance_system_event_type = instance_system_event_type  # type: List[DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventType]

    def validate(self):
        self.validate_required(self.instance_system_event_type, 'instance_system_event_type')
        if self.instance_system_event_type:
            for k in self.instance_system_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceSystemEventType'] = []
        if self.instance_system_event_type is not None:
            for k in self.instance_system_event_type:
                result['InstanceSystemEventType'].append(k.to_map() if k else None)
        else:
            result['InstanceSystemEventType'] = None
        return result

    def from_map(self, map={}):
        self.instance_system_event_type = []
        if map.get('InstanceSystemEventType') is not None:
            for k in map.get('InstanceSystemEventType'):
                temp_model = DescribeInstanceHistoryEventsResponseInstanceSystemEventSetInstanceSystemEventType()
                self.instance_system_event_type.append(temp_model.from_map(k))
        else:
            self.instance_system_event_type = None
        return self


class DescribeDisksFullStatusRequest(TeaModel):
    def __init__(self, region_id=None, disk_id=None, event_id=None, status=None, health_status=None, event_type=None,
                 event_time=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.disk_id = disk_id          # type: List[str]
        self.event_id = event_id        # type: List[str]
        self.status = status            # type: str
        self.health_status = health_status  # type: str
        self.event_type = event_type    # type: str
        self.event_time = event_time    # type: DescribeDisksFullStatusRequestEventTime
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.event_time:
            self.event_time.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DiskId'] = self.disk_id
        result['EventId'] = self.event_id
        result['Status'] = self.status
        result['HealthStatus'] = self.health_status
        result['EventType'] = self.event_type
        if self.event_time is not None:
            result['EventTime'] = self.event_time.to_map()
        else:
            result['EventTime'] = None
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.disk_id = map.get('DiskId')
        self.event_id = map.get('EventId')
        self.status = map.get('Status')
        self.health_status = map.get('HealthStatus')
        self.event_type = map.get('EventType')
        if map.get('EventTime') is not None:
            temp_model = DescribeDisksFullStatusRequestEventTime()
            self.event_time = temp_model.from_map(map['EventTime'])
        else:
            self.event_time = None
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeDisksFullStatusRequestEventTime(TeaModel):
    def __init__(self, start=None, end=None):
        self.start = start              # type: str
        self.end = end                  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Start'] = self.start
        result['End'] = self.end
        return result

    def from_map(self, map={}):
        self.start = map.get('Start')
        self.end = map.get('End')
        return self


class DescribeDisksFullStatusResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 disk_full_status_set=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.disk_full_status_set = disk_full_status_set  # type: DescribeDisksFullStatusResponseDiskFullStatusSet

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.disk_full_status_set, 'disk_full_status_set')
        if self.disk_full_status_set:
            self.disk_full_status_set.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.disk_full_status_set is not None:
            result['DiskFullStatusSet'] = self.disk_full_status_set.to_map()
        else:
            result['DiskFullStatusSet'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('DiskFullStatusSet') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSet()
            self.disk_full_status_set = temp_model.from_map(map['DiskFullStatusSet'])
        else:
            self.disk_full_status_set = None
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventTypeEventType(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventType(TeaModel):
    def __init__(self, event_id=None, event_time=None, event_end_time=None, impact_level=None, event_type=None):
        self.event_id = event_id        # type: str
        self.event_time = event_time    # type: str
        self.event_end_time = event_end_time  # type: str
        self.impact_level = impact_level  # type: str
        self.event_type = event_type    # type: DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventTypeEventType

    def validate(self):
        self.validate_required(self.event_id, 'event_id')
        self.validate_required(self.event_time, 'event_time')
        self.validate_required(self.event_end_time, 'event_end_time')
        self.validate_required(self.impact_level, 'impact_level')
        self.validate_required(self.event_type, 'event_type')
        if self.event_type:
            self.event_type.validate()

    def to_map(self):
        result = {}
        result['EventId'] = self.event_id
        result['EventTime'] = self.event_time
        result['EventEndTime'] = self.event_end_time
        result['ImpactLevel'] = self.impact_level
        if self.event_type is not None:
            result['EventType'] = self.event_type.to_map()
        else:
            result['EventType'] = None
        return result

    def from_map(self, map={}):
        self.event_id = map.get('EventId')
        self.event_time = map.get('EventTime')
        self.event_end_time = map.get('EventEndTime')
        self.impact_level = map.get('ImpactLevel')
        if map.get('EventType') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventTypeEventType()
            self.event_type = temp_model.from_map(map['EventType'])
        else:
            self.event_type = None
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSet(TeaModel):
    def __init__(self, disk_event_type=None):
        self.disk_event_type = disk_event_type  # type: List[DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventType]

    def validate(self):
        self.validate_required(self.disk_event_type, 'disk_event_type')
        if self.disk_event_type:
            for k in self.disk_event_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskEventType'] = []
        if self.disk_event_type is not None:
            for k in self.disk_event_type:
                result['DiskEventType'].append(k.to_map() if k else None)
        else:
            result['DiskEventType'] = None
        return result

    def from_map(self, map={}):
        self.disk_event_type = []
        if map.get('DiskEventType') is not None:
            for k in map.get('DiskEventType'):
                temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSetDiskEventType()
                self.disk_event_type.append(temp_model.from_map(k))
        else:
            self.disk_event_type = None
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeHealthStatus(TeaModel):
    def __init__(self, code=None, name=None):
        self.code = code                # type: int
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['Code'] = self.code
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.code = map.get('Code')
        self.name = map.get('Name')
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusType(TeaModel):
    def __init__(self, disk_id=None, instance_id=None, device=None, disk_event_set=None, status=None,
                 health_status=None):
        self.disk_id = disk_id          # type: str
        self.instance_id = instance_id  # type: str
        self.device = device            # type: str
        self.disk_event_set = disk_event_set  # type: DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSet
        self.status = status            # type: DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeStatus
        self.health_status = health_status  # type: DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeHealthStatus

    def validate(self):
        self.validate_required(self.disk_id, 'disk_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.device, 'device')
        self.validate_required(self.disk_event_set, 'disk_event_set')
        if self.disk_event_set:
            self.disk_event_set.validate()
        self.validate_required(self.status, 'status')
        if self.status:
            self.status.validate()
        self.validate_required(self.health_status, 'health_status')
        if self.health_status:
            self.health_status.validate()

    def to_map(self):
        result = {}
        result['DiskId'] = self.disk_id
        result['InstanceId'] = self.instance_id
        result['Device'] = self.device
        if self.disk_event_set is not None:
            result['DiskEventSet'] = self.disk_event_set.to_map()
        else:
            result['DiskEventSet'] = None
        if self.status is not None:
            result['Status'] = self.status.to_map()
        else:
            result['Status'] = None
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status.to_map()
        else:
            result['HealthStatus'] = None
        return result

    def from_map(self, map={}):
        self.disk_id = map.get('DiskId')
        self.instance_id = map.get('InstanceId')
        self.device = map.get('Device')
        if map.get('DiskEventSet') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeDiskEventSet()
            self.disk_event_set = temp_model.from_map(map['DiskEventSet'])
        else:
            self.disk_event_set = None
        if map.get('Status') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeStatus()
            self.status = temp_model.from_map(map['Status'])
        else:
            self.status = None
        if map.get('HealthStatus') is not None:
            temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusTypeHealthStatus()
            self.health_status = temp_model.from_map(map['HealthStatus'])
        else:
            self.health_status = None
        return self


class DescribeDisksFullStatusResponseDiskFullStatusSet(TeaModel):
    def __init__(self, disk_full_status_type=None):
        self.disk_full_status_type = disk_full_status_type  # type: List[DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusType]

    def validate(self):
        self.validate_required(self.disk_full_status_type, 'disk_full_status_type')
        if self.disk_full_status_type:
            for k in self.disk_full_status_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DiskFullStatusType'] = []
        if self.disk_full_status_type is not None:
            for k in self.disk_full_status_type:
                result['DiskFullStatusType'].append(k.to_map() if k else None)
        else:
            result['DiskFullStatusType'] = None
        return result

    def from_map(self, map={}):
        self.disk_full_status_type = []
        if map.get('DiskFullStatusType') is not None:
            for k in map.get('DiskFullStatusType'):
                temp_model = DescribeDisksFullStatusResponseDiskFullStatusSetDiskFullStatusType()
                self.disk_full_status_type.append(temp_model.from_map(k))
        else:
            self.disk_full_status_type = None
        return self


class ModifyUserBusinessBehaviorRequest(TeaModel):
    def __init__(self, region_id=None, status_key=None, status_value=None):
        self.region_id = region_id      # type: str
        self.status_key = status_key    # type: str
        self.status_value = status_value  # type: str

    def validate(self):
        self.validate_required(self.status_key, 'status_key')
        self.validate_required(self.status_value, 'status_value')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['statusKey'] = self.status_key
        result['statusValue'] = self.status_value
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.status_key = map.get('statusKey')
        self.status_value = map.get('statusValue')
        return self


class ModifyUserBusinessBehaviorResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeUserBusinessBehaviorRequest(TeaModel):
    def __init__(self, region_id=None, status_key=None):
        self.region_id = region_id      # type: str
        self.status_key = status_key    # type: str

    def validate(self):
        self.validate_required(self.status_key, 'status_key')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['statusKey'] = self.status_key
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.status_key = map.get('statusKey')
        return self


class DescribeUserBusinessBehaviorResponse(TeaModel):
    def __init__(self, request_id=None, status_value=None):
        self.request_id = request_id    # type: str
        self.status_value = status_value  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.status_value, 'status_value')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['StatusValue'] = self.status_value
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.status_value = map.get('StatusValue')
        return self


class RunInstancesRequest(TeaModel):
    def __init__(self, region_id=None, image_id=None, image_family=None, instance_type=None, security_group_id=None,
                 security_group_ids=None, v_switch_id=None, instance_name=None, description=None, internet_max_bandwidth_in=None,
                 internet_max_bandwidth_out=None, host_name=None, unique_suffix=None, password=None, password_inherit=None, zone_id=None,
                 internet_charge_type=None, system_disk=None, data_disk=None, arn=None, io_optimized=None, network_interface=None,
                 user_data=None, key_pair_name=None, ram_role_name=None, amount=None, min_amount=None, auto_release_time=None,
                 spot_strategy=None, spot_duration=None, spot_price_limit=None, spot_interruption_behavior=None,
                 security_enhancement_strategy=None, client_token=None, tag=None, hpc_cluster_id=None, dry_run=None, dedicated_host_id=None,
                 launch_template_id=None, launch_template_name=None, launch_template_version=None, resource_group_id=None,
                 period=None, period_unit=None, auto_renew=None, auto_renew_period=None, instance_charge_type=None,
                 deployment_set_id=None, deployment_set_group_no=None, private_ip_address=None, credit_specification=None,
                 ipv_6address=None, ipv_6address_count=None, network_interface_queue_number=None, deletion_protection=None,
                 affinity=None, tenancy=None, storage_set_id=None, storage_set_partition_number=None, cpu_options=None,
                 http_endpoint=None, http_tokens=None, http_put_response_hop_limit=None, private_pool_options=None, isp=None):
        self.region_id = region_id      # type: str
        self.image_id = image_id        # type: str
        self.image_family = image_family  # type: str
        self.instance_type = instance_type  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: List[str]
        self.v_switch_id = v_switch_id  # type: str
        self.instance_name = instance_name  # type: str
        self.description = description  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.host_name = host_name      # type: str
        self.unique_suffix = unique_suffix  # type: bool
        self.password = password        # type: str
        self.password_inherit = password_inherit  # type: bool
        self.zone_id = zone_id          # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.system_disk = system_disk  # type: RunInstancesRequestSystemDisk
        self.data_disk = data_disk      # type: List[RunInstancesRequestDataDisk]
        self.arn = arn                  # type: List[RunInstancesRequestArn]
        self.io_optimized = io_optimized  # type: str
        self.network_interface = network_interface  # type: List[RunInstancesRequestNetworkInterface]
        self.user_data = user_data      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.amount = amount            # type: int
        self.min_amount = min_amount    # type: int
        self.auto_release_time = auto_release_time  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.spot_duration = spot_duration  # type: int
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_interruption_behavior = spot_interruption_behavior  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.client_token = client_token  # type: str
        self.tag = tag                  # type: List[RunInstancesRequestTag]
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.dry_run = dry_run          # type: bool
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.launch_template_version = launch_template_version  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.auto_renew = auto_renew    # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.instance_charge_type = instance_charge_type  # type: str
        self.deployment_set_id = deployment_set_id  # type: str
        self.deployment_set_group_no = deployment_set_group_no  # type: int
        self.private_ip_address = private_ip_address  # type: str
        self.credit_specification = credit_specification  # type: str
        self.ipv_6address = ipv_6address  # type: List[str]
        self.ipv_6address_count = ipv_6address_count  # type: int
        self.network_interface_queue_number = network_interface_queue_number  # type: int
        self.deletion_protection = deletion_protection  # type: bool
        self.affinity = affinity        # type: str
        self.tenancy = tenancy          # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.cpu_options = cpu_options  # type: RunInstancesRequestCpuOptions
        self.http_endpoint = http_endpoint  # type: str
        self.http_tokens = http_tokens  # type: str
        self.http_put_response_hop_limit = http_put_response_hop_limit  # type: int
        self.private_pool_options = private_pool_options  # type: RunInstancesRequestPrivatePoolOptions
        self.isp = isp                  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.cpu_options:
            self.cpu_options.validate()
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ImageId'] = self.image_id
        result['ImageFamily'] = self.image_family
        result['InstanceType'] = self.instance_type
        result['SecurityGroupId'] = self.security_group_id
        result['SecurityGroupIds'] = self.security_group_ids
        result['VSwitchId'] = self.v_switch_id
        result['InstanceName'] = self.instance_name
        result['Description'] = self.description
        result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        result['HostName'] = self.host_name
        result['UniqueSuffix'] = self.unique_suffix
        result['Password'] = self.password
        result['PasswordInherit'] = self.password_inherit
        result['ZoneId'] = self.zone_id
        result['InternetChargeType'] = self.internet_charge_type
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        else:
            result['Arn'] = None
        result['IoOptimized'] = self.io_optimized
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        else:
            result['NetworkInterface'] = None
        result['UserData'] = self.user_data
        result['KeyPairName'] = self.key_pair_name
        result['RamRoleName'] = self.ram_role_name
        result['Amount'] = self.amount
        result['MinAmount'] = self.min_amount
        result['AutoReleaseTime'] = self.auto_release_time
        result['SpotStrategy'] = self.spot_strategy
        result['SpotDuration'] = self.spot_duration
        result['SpotPriceLimit'] = self.spot_price_limit
        result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        result['ClientToken'] = self.client_token
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['HpcClusterId'] = self.hpc_cluster_id
        result['DryRun'] = self.dry_run
        result['DedicatedHostId'] = self.dedicated_host_id
        result['LaunchTemplateId'] = self.launch_template_id
        result['LaunchTemplateName'] = self.launch_template_name
        result['LaunchTemplateVersion'] = self.launch_template_version
        result['ResourceGroupId'] = self.resource_group_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['AutoRenew'] = self.auto_renew
        result['AutoRenewPeriod'] = self.auto_renew_period
        result['InstanceChargeType'] = self.instance_charge_type
        result['DeploymentSetId'] = self.deployment_set_id
        result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        result['PrivateIpAddress'] = self.private_ip_address
        result['CreditSpecification'] = self.credit_specification
        result['Ipv6Address'] = self.ipv_6address
        result['Ipv6AddressCount'] = self.ipv_6address_count
        result['NetworkInterfaceQueueNumber'] = self.network_interface_queue_number
        result['DeletionProtection'] = self.deletion_protection
        result['Affinity'] = self.affinity
        result['Tenancy'] = self.tenancy
        result['StorageSetId'] = self.storage_set_id
        result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        if self.cpu_options is not None:
            result['CpuOptions'] = self.cpu_options.to_map()
        else:
            result['CpuOptions'] = None
        result['HttpEndpoint'] = self.http_endpoint
        result['HttpTokens'] = self.http_tokens
        result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        else:
            result['PrivatePoolOptions'] = None
        result['Isp'] = self.isp
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.image_id = map.get('ImageId')
        self.image_family = map.get('ImageFamily')
        self.instance_type = map.get('InstanceType')
        self.security_group_id = map.get('SecurityGroupId')
        self.security_group_ids = map.get('SecurityGroupIds')
        self.v_switch_id = map.get('VSwitchId')
        self.instance_name = map.get('InstanceName')
        self.description = map.get('Description')
        self.internet_max_bandwidth_in = map.get('InternetMaxBandwidthIn')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        self.host_name = map.get('HostName')
        self.unique_suffix = map.get('UniqueSuffix')
        self.password = map.get('Password')
        self.password_inherit = map.get('PasswordInherit')
        self.zone_id = map.get('ZoneId')
        self.internet_charge_type = map.get('InternetChargeType')
        if map.get('SystemDisk') is not None:
            temp_model = RunInstancesRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = RunInstancesRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        else:
            self.data_disk = None
        self.arn = []
        if map.get('Arn') is not None:
            for k in map.get('Arn'):
                temp_model = RunInstancesRequestArn()
                self.arn.append(temp_model.from_map(k))
        else:
            self.arn = None
        self.io_optimized = map.get('IoOptimized')
        self.network_interface = []
        if map.get('NetworkInterface') is not None:
            for k in map.get('NetworkInterface'):
                temp_model = RunInstancesRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        else:
            self.network_interface = None
        self.user_data = map.get('UserData')
        self.key_pair_name = map.get('KeyPairName')
        self.ram_role_name = map.get('RamRoleName')
        self.amount = map.get('Amount')
        self.min_amount = map.get('MinAmount')
        self.auto_release_time = map.get('AutoReleaseTime')
        self.spot_strategy = map.get('SpotStrategy')
        self.spot_duration = map.get('SpotDuration')
        self.spot_price_limit = map.get('SpotPriceLimit')
        self.spot_interruption_behavior = map.get('SpotInterruptionBehavior')
        self.security_enhancement_strategy = map.get('SecurityEnhancementStrategy')
        self.client_token = map.get('ClientToken')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = RunInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.hpc_cluster_id = map.get('HpcClusterId')
        self.dry_run = map.get('DryRun')
        self.dedicated_host_id = map.get('DedicatedHostId')
        self.launch_template_id = map.get('LaunchTemplateId')
        self.launch_template_name = map.get('LaunchTemplateName')
        self.launch_template_version = map.get('LaunchTemplateVersion')
        self.resource_group_id = map.get('ResourceGroupId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.auto_renew = map.get('AutoRenew')
        self.auto_renew_period = map.get('AutoRenewPeriod')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.deployment_set_id = map.get('DeploymentSetId')
        self.deployment_set_group_no = map.get('DeploymentSetGroupNo')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.credit_specification = map.get('CreditSpecification')
        self.ipv_6address = map.get('Ipv6Address')
        self.ipv_6address_count = map.get('Ipv6AddressCount')
        self.network_interface_queue_number = map.get('NetworkInterfaceQueueNumber')
        self.deletion_protection = map.get('DeletionProtection')
        self.affinity = map.get('Affinity')
        self.tenancy = map.get('Tenancy')
        self.storage_set_id = map.get('StorageSetId')
        self.storage_set_partition_number = map.get('StorageSetPartitionNumber')
        if map.get('CpuOptions') is not None:
            temp_model = RunInstancesRequestCpuOptions()
            self.cpu_options = temp_model.from_map(map['CpuOptions'])
        else:
            self.cpu_options = None
        self.http_endpoint = map.get('HttpEndpoint')
        self.http_tokens = map.get('HttpTokens')
        self.http_put_response_hop_limit = map.get('HttpPutResponseHopLimit')
        if map.get('PrivatePoolOptions') is not None:
            temp_model = RunInstancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(map['PrivatePoolOptions'])
        else:
            self.private_pool_options = None
        self.isp = map.get('Isp')
        return self


class RunInstancesRequestSystemDisk(TeaModel):
    def __init__(self, size=None, category=None, disk_name=None, description=None, performance_level=None,
                 auto_snapshot_policy_id=None):
        self.size = size                # type: str
        self.category = category        # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.performance_level = performance_level  # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['Category'] = self.category
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['PerformanceLevel'] = self.performance_level
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.category = map.get('Category')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.performance_level = map.get('PerformanceLevel')
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        return self


class RunInstancesRequestDataDisk(TeaModel):
    def __init__(self, size=None, snapshot_id=None, category=None, encrypted=None, kmskey_id=None, disk_name=None,
                 description=None, device=None, delete_with_instance=None, performance_level=None,
                 auto_snapshot_policy_id=None, encrypt_algorithm=None):
        self.size = size                # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.category = category        # type: str
        self.encrypted = encrypted      # type: str
        self.kmskey_id = kmskey_id      # type: str
        self.disk_name = disk_name      # type: str
        self.description = description  # type: str
        self.device = device            # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.performance_level = performance_level  # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.encrypt_algorithm = encrypt_algorithm  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['SnapshotId'] = self.snapshot_id
        result['Category'] = self.category
        result['Encrypted'] = self.encrypted
        result['KMSKeyId'] = self.kmskey_id
        result['DiskName'] = self.disk_name
        result['Description'] = self.description
        result['Device'] = self.device
        result['DeleteWithInstance'] = self.delete_with_instance
        result['PerformanceLevel'] = self.performance_level
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['EncryptAlgorithm'] = self.encrypt_algorithm
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.snapshot_id = map.get('SnapshotId')
        self.category = map.get('Category')
        self.encrypted = map.get('Encrypted')
        self.kmskey_id = map.get('KMSKeyId')
        self.disk_name = map.get('DiskName')
        self.description = map.get('Description')
        self.device = map.get('Device')
        self.delete_with_instance = map.get('DeleteWithInstance')
        self.performance_level = map.get('PerformanceLevel')
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        self.encrypt_algorithm = map.get('EncryptAlgorithm')
        return self


class RunInstancesRequestArn(TeaModel):
    def __init__(self, assume_role_for=None, rolearn=None, role_type=None):
        self.assume_role_for = assume_role_for  # type: int
        self.rolearn = rolearn          # type: str
        self.role_type = role_type      # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['AssumeRoleFor'] = self.assume_role_for
        result['Rolearn'] = self.rolearn
        result['RoleType'] = self.role_type
        return result

    def from_map(self, map={}):
        self.assume_role_for = map.get('AssumeRoleFor')
        self.rolearn = map.get('Rolearn')
        self.role_type = map.get('RoleType')
        return self


class RunInstancesRequestNetworkInterface(TeaModel):
    def __init__(self, primary_ip_address=None, v_switch_id=None, security_group_id=None, security_group_ids=None,
                 network_interface_name=None, description=None, queue_number=None):
        self.primary_ip_address = primary_ip_address  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: List[str]
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.queue_number = queue_number  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['VSwitchId'] = self.v_switch_id
        result['SecurityGroupId'] = self.security_group_id
        result['SecurityGroupIds'] = self.security_group_ids
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['QueueNumber'] = self.queue_number
        return result

    def from_map(self, map={}):
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.v_switch_id = map.get('VSwitchId')
        self.security_group_id = map.get('SecurityGroupId')
        self.security_group_ids = map.get('SecurityGroupIds')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.queue_number = map.get('QueueNumber')
        return self


class RunInstancesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class RunInstancesRequestCpuOptions(TeaModel):
    def __init__(self, core=None, threads_per_core=None, numa=None):
        self.core = core                # type: int
        self.threads_per_core = threads_per_core  # type: int
        self.numa = numa                # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Core'] = self.core
        result['ThreadsPerCore'] = self.threads_per_core
        result['Numa'] = self.numa
        return result

    def from_map(self, map={}):
        self.core = map.get('Core')
        self.threads_per_core = map.get('ThreadsPerCore')
        self.numa = map.get('Numa')
        return self


class RunInstancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, match_criteria=None, id=None):
        self.match_criteria = match_criteria  # type: str
        self.id = id                    # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['MatchCriteria'] = self.match_criteria
        result['Id'] = self.id
        return result

    def from_map(self, map={}):
        self.match_criteria = map.get('MatchCriteria')
        self.id = map.get('Id')
        return self


class RunInstancesResponse(TeaModel):
    def __init__(self, request_id=None, trade_price=None, instance_id_sets=None):
        self.request_id = request_id    # type: str
        self.trade_price = trade_price  # type: float
        self.instance_id_sets = instance_id_sets  # type: RunInstancesResponseInstanceIdSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.instance_id_sets, 'instance_id_sets')
        if self.instance_id_sets:
            self.instance_id_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TradePrice'] = self.trade_price
        if self.instance_id_sets is not None:
            result['InstanceIdSets'] = self.instance_id_sets.to_map()
        else:
            result['InstanceIdSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.trade_price = map.get('TradePrice')
        if map.get('InstanceIdSets') is not None:
            temp_model = RunInstancesResponseInstanceIdSets()
            self.instance_id_sets = temp_model.from_map(map['InstanceIdSets'])
        else:
            self.instance_id_sets = None
        return self


class RunInstancesResponseInstanceIdSets(TeaModel):
    def __init__(self, instance_id_set=None):
        self.instance_id_set = instance_id_set  # type: List[str]

    def validate(self):
        self.validate_required(self.instance_id_set, 'instance_id_set')

    def to_map(self):
        result = {}
        result['InstanceIdSet'] = self.instance_id_set
        return result

    def from_map(self, map={}):
        self.instance_id_set = map.get('InstanceIdSet')
        return self


class ConvertNatPublicIpToEipRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        return self


class ConvertNatPublicIpToEipResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyHpcClusterAttributeRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_id=None, description=None, name=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.description = description  # type: str
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['HpcClusterId'] = self.hpc_cluster_id
        result['Description'] = self.description
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.hpc_cluster_id = map.get('HpcClusterId')
        self.description = map.get('Description')
        self.name = map.get('Name')
        return self


class ModifyHpcClusterAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeHpcClustersRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_ids=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.hpc_cluster_ids = hpc_cluster_ids  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['HpcClusterIds'] = self.hpc_cluster_ids
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.hpc_cluster_ids = map.get('HpcClusterIds')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeHpcClustersResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, hpc_clusters=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.hpc_clusters = hpc_clusters  # type: DescribeHpcClustersResponseHpcClusters

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.hpc_clusters, 'hpc_clusters')
        if self.hpc_clusters:
            self.hpc_clusters.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.hpc_clusters is not None:
            result['HpcClusters'] = self.hpc_clusters.to_map()
        else:
            result['HpcClusters'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('HpcClusters') is not None:
            temp_model = DescribeHpcClustersResponseHpcClusters()
            self.hpc_clusters = temp_model.from_map(map['HpcClusters'])
        else:
            self.hpc_clusters = None
        return self


class DescribeHpcClustersResponseHpcClustersHpcCluster(TeaModel):
    def __init__(self, hpc_cluster_id=None, name=None, description=None):
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.name = name                # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['HpcClusterId'] = self.hpc_cluster_id
        result['Name'] = self.name
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.hpc_cluster_id = map.get('HpcClusterId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        return self


class DescribeHpcClustersResponseHpcClusters(TeaModel):
    def __init__(self, hpc_cluster=None):
        self.hpc_cluster = hpc_cluster  # type: List[DescribeHpcClustersResponseHpcClustersHpcCluster]

    def validate(self):
        self.validate_required(self.hpc_cluster, 'hpc_cluster')
        if self.hpc_cluster:
            for k in self.hpc_cluster:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['HpcCluster'] = []
        if self.hpc_cluster is not None:
            for k in self.hpc_cluster:
                result['HpcCluster'].append(k.to_map() if k else None)
        else:
            result['HpcCluster'] = None
        return result

    def from_map(self, map={}):
        self.hpc_cluster = []
        if map.get('HpcCluster') is not None:
            for k in map.get('HpcCluster'):
                temp_model = DescribeHpcClustersResponseHpcClustersHpcCluster()
                self.hpc_cluster.append(temp_model.from_map(k))
        else:
            self.hpc_cluster = None
        return self


class DeleteHpcClusterRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, hpc_cluster_id=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.hpc_cluster_id = hpc_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['HpcClusterId'] = self.hpc_cluster_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.hpc_cluster_id = map.get('HpcClusterId')
        return self


class DeleteHpcClusterResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateHpcClusterRequest(TeaModel):
    def __init__(self, region_id=None, client_token=None, description=None, name=None):
        self.region_id = region_id      # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.name = name                # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ClientToken'] = self.client_token
        result['Description'] = self.description
        result['Name'] = self.name
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.client_token = map.get('ClientToken')
        self.description = map.get('Description')
        self.name = map.get('Name')
        return self


class CreateHpcClusterResponse(TeaModel):
    def __init__(self, request_id=None, hpc_cluster_id=None):
        self.request_id = request_id    # type: str
        self.hpc_cluster_id = hpc_cluster_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.hpc_cluster_id, 'hpc_cluster_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['HpcClusterId'] = self.hpc_cluster_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.hpc_cluster_id = map.get('HpcClusterId')
        return self


class DescribeSnapshotsUsageRequest(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        return self


class DescribeSnapshotsUsageResponse(TeaModel):
    def __init__(self, request_id=None, snapshot_count=None, snapshot_size=None):
        self.request_id = request_id    # type: str
        self.snapshot_count = snapshot_count  # type: int
        self.snapshot_size = snapshot_size  # type: int

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.snapshot_count, 'snapshot_count')
        self.validate_required(self.snapshot_size, 'snapshot_size')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['SnapshotCount'] = self.snapshot_count
        result['SnapshotSize'] = self.snapshot_size
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.snapshot_count = map.get('SnapshotCount')
        self.snapshot_size = map.get('SnapshotSize')
        return self


class DescribeSpotPriceHistoryRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None, network_type=None, instance_type=None, spot_duration=None,
                 io_optimized=None, start_time=None, end_time=None, ostype=None, offset=None):
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.network_type = network_type  # type: str
        self.instance_type = instance_type  # type: str
        self.spot_duration = spot_duration  # type: int
        self.io_optimized = io_optimized  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.ostype = ostype            # type: str
        self.offset = offset            # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.instance_type, 'instance_type')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['NetworkType'] = self.network_type
        result['InstanceType'] = self.instance_type
        result['SpotDuration'] = self.spot_duration
        result['IoOptimized'] = self.io_optimized
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['OSType'] = self.ostype
        result['Offset'] = self.offset
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.network_type = map.get('NetworkType')
        self.instance_type = map.get('InstanceType')
        self.spot_duration = map.get('SpotDuration')
        self.io_optimized = map.get('IoOptimized')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.ostype = map.get('OSType')
        self.offset = map.get('Offset')
        return self


class DescribeSpotPriceHistoryResponse(TeaModel):
    def __init__(self, request_id=None, next_offset=None, currency=None, spot_prices=None):
        self.request_id = request_id    # type: str
        self.next_offset = next_offset  # type: int
        self.currency = currency        # type: str
        self.spot_prices = spot_prices  # type: DescribeSpotPriceHistoryResponseSpotPrices

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.next_offset, 'next_offset')
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.spot_prices, 'spot_prices')
        if self.spot_prices:
            self.spot_prices.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NextOffset'] = self.next_offset
        result['Currency'] = self.currency
        if self.spot_prices is not None:
            result['SpotPrices'] = self.spot_prices.to_map()
        else:
            result['SpotPrices'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.next_offset = map.get('NextOffset')
        self.currency = map.get('Currency')
        if map.get('SpotPrices') is not None:
            temp_model = DescribeSpotPriceHistoryResponseSpotPrices()
            self.spot_prices = temp_model.from_map(map['SpotPrices'])
        else:
            self.spot_prices = None
        return self


class DescribeSpotPriceHistoryResponseSpotPricesSpotPriceType(TeaModel):
    def __init__(self, zone_id=None, instance_type=None, io_optimized=None, timestamp=None, network_type=None,
                 spot_price=None, origin_price=None):
        self.zone_id = zone_id          # type: str
        self.instance_type = instance_type  # type: str
        self.io_optimized = io_optimized  # type: str
        self.timestamp = timestamp      # type: str
        self.network_type = network_type  # type: str
        self.spot_price = spot_price    # type: float
        self.origin_price = origin_price  # type: float

    def validate(self):
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.io_optimized, 'io_optimized')
        self.validate_required(self.timestamp, 'timestamp')
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.spot_price, 'spot_price')
        self.validate_required(self.origin_price, 'origin_price')

    def to_map(self):
        result = {}
        result['ZoneId'] = self.zone_id
        result['InstanceType'] = self.instance_type
        result['IoOptimized'] = self.io_optimized
        result['Timestamp'] = self.timestamp
        result['NetworkType'] = self.network_type
        result['SpotPrice'] = self.spot_price
        result['OriginPrice'] = self.origin_price
        return result

    def from_map(self, map={}):
        self.zone_id = map.get('ZoneId')
        self.instance_type = map.get('InstanceType')
        self.io_optimized = map.get('IoOptimized')
        self.timestamp = map.get('Timestamp')
        self.network_type = map.get('NetworkType')
        self.spot_price = map.get('SpotPrice')
        self.origin_price = map.get('OriginPrice')
        return self


class DescribeSpotPriceHistoryResponseSpotPrices(TeaModel):
    def __init__(self, spot_price_type=None):
        self.spot_price_type = spot_price_type  # type: List[DescribeSpotPriceHistoryResponseSpotPricesSpotPriceType]

    def validate(self):
        self.validate_required(self.spot_price_type, 'spot_price_type')
        if self.spot_price_type:
            for k in self.spot_price_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SpotPriceType'] = []
        if self.spot_price_type is not None:
            for k in self.spot_price_type:
                result['SpotPriceType'].append(k.to_map() if k else None)
        else:
            result['SpotPriceType'] = None
        return result

    def from_map(self, map={}):
        self.spot_price_type = []
        if map.get('SpotPriceType') is not None:
            for k in map.get('SpotPriceType'):
                temp_model = DescribeSpotPriceHistoryResponseSpotPricesSpotPriceType()
                self.spot_price_type.append(temp_model.from_map(k))
        else:
            self.spot_price_type = None
        return self


class StopInvocationRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.invoke_id = invoke_id      # type: str
        self.instance_id = instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InvokeId'] = self.invoke_id
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.invoke_id = map.get('InvokeId')
        self.instance_id = map.get('InstanceId')
        return self


class StopInvocationResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, name=None, description=None, command_content=None,
                 working_dir=None, timeout=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        return self


class ModifyCommandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class InvokeCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, timed=None, frequency=None, instance_id=None,
                 parameters=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str
        self.timed = timed              # type: bool
        self.frequency = frequency      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.parameters = parameters    # type: Dict[str, Any]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        result['Timed'] = self.timed
        result['Frequency'] = self.frequency
        result['InstanceId'] = self.instance_id
        result['Parameters'] = self.parameters
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        self.timed = map.get('Timed')
        self.frequency = map.get('Frequency')
        self.instance_id = map.get('InstanceId')
        self.parameters = map.get('Parameters')
        return self


class InvokeCommandShrinkRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, timed=None, frequency=None, instance_id=None,
                 parameters_shrink=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str
        self.timed = timed              # type: bool
        self.frequency = frequency      # type: str
        self.instance_id = instance_id  # type: List[str]
        self.parameters_shrink = parameters_shrink  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        result['Timed'] = self.timed
        result['Frequency'] = self.frequency
        result['InstanceId'] = self.instance_id
        result['Parameters'] = self.parameters_shrink
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        self.timed = map.get('Timed')
        self.frequency = map.get('Frequency')
        self.instance_id = map.get('InstanceId')
        self.parameters_shrink = map.get('Parameters')
        return self


class InvokeCommandResponse(TeaModel):
    def __init__(self, request_id=None, invoke_id=None):
        self.request_id = request_id    # type: str
        self.invoke_id = invoke_id      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.invoke_id, 'invoke_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['InvokeId'] = self.invoke_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.invoke_id = map.get('InvokeId')
        return self


class DescribeInvocationsRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, command_id=None, command_name=None, command_type=None,
                 timed=None, invoke_status=None, instance_id=None, content_encoding=None, include_output=None,
                 page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.invoke_id = invoke_id      # type: str
        self.command_id = command_id    # type: str
        self.command_name = command_name  # type: str
        self.command_type = command_type  # type: str
        self.timed = timed              # type: bool
        self.invoke_status = invoke_status  # type: str
        self.instance_id = instance_id  # type: str
        self.content_encoding = content_encoding  # type: str
        self.include_output = include_output  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InvokeId'] = self.invoke_id
        result['CommandId'] = self.command_id
        result['CommandName'] = self.command_name
        result['CommandType'] = self.command_type
        result['Timed'] = self.timed
        result['InvokeStatus'] = self.invoke_status
        result['InstanceId'] = self.instance_id
        result['ContentEncoding'] = self.content_encoding
        result['IncludeOutput'] = self.include_output
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.invoke_id = map.get('InvokeId')
        self.command_id = map.get('CommandId')
        self.command_name = map.get('CommandName')
        self.command_type = map.get('CommandType')
        self.timed = map.get('Timed')
        self.invoke_status = map.get('InvokeStatus')
        self.instance_id = map.get('InstanceId')
        self.content_encoding = map.get('ContentEncoding')
        self.include_output = map.get('IncludeOutput')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInvocationsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, invocations=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.invocations = invocations  # type: DescribeInvocationsResponseInvocations

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.invocations, 'invocations')
        if self.invocations:
            self.invocations.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.invocations is not None:
            result['Invocations'] = self.invocations.to_map()
        else:
            result['Invocations'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Invocations') is not None:
            temp_model = DescribeInvocationsResponseInvocations()
            self.invocations = temp_model.from_map(map['Invocations'])
        else:
            self.invocations = None
        return self


class DescribeInvocationsResponseInvocationsInvocationInvokeInstancesInvokeInstance(TeaModel):
    def __init__(self, instance_id=None, repeats=None, instance_invoke_status=None, invocation_status=None,
                 output=None, exit_code=None, dropped=None, error_code=None, error_info=None, creation_time=None,
                 start_time=None, stop_time=None, finish_time=None, update_time=None):
        self.instance_id = instance_id  # type: str
        self.repeats = repeats          # type: int
        self.instance_invoke_status = instance_invoke_status  # type: str
        self.invocation_status = invocation_status  # type: str
        self.output = output            # type: str
        self.exit_code = exit_code      # type: int
        self.dropped = dropped          # type: int
        self.error_code = error_code    # type: str
        self.error_info = error_info    # type: str
        self.creation_time = creation_time  # type: str
        self.start_time = start_time    # type: str
        self.stop_time = stop_time      # type: str
        self.finish_time = finish_time  # type: str
        self.update_time = update_time  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.repeats, 'repeats')
        self.validate_required(self.instance_invoke_status, 'instance_invoke_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.output, 'output')
        self.validate_required(self.exit_code, 'exit_code')
        self.validate_required(self.dropped, 'dropped')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_info, 'error_info')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.stop_time, 'stop_time')
        self.validate_required(self.finish_time, 'finish_time')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Repeats'] = self.repeats
        result['InstanceInvokeStatus'] = self.instance_invoke_status
        result['InvocationStatus'] = self.invocation_status
        result['Output'] = self.output
        result['ExitCode'] = self.exit_code
        result['Dropped'] = self.dropped
        result['ErrorCode'] = self.error_code
        result['ErrorInfo'] = self.error_info
        result['CreationTime'] = self.creation_time
        result['StartTime'] = self.start_time
        result['StopTime'] = self.stop_time
        result['FinishTime'] = self.finish_time
        result['UpdateTime'] = self.update_time
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.repeats = map.get('Repeats')
        self.instance_invoke_status = map.get('InstanceInvokeStatus')
        self.invocation_status = map.get('InvocationStatus')
        self.output = map.get('Output')
        self.exit_code = map.get('ExitCode')
        self.dropped = map.get('Dropped')
        self.error_code = map.get('ErrorCode')
        self.error_info = map.get('ErrorInfo')
        self.creation_time = map.get('CreationTime')
        self.start_time = map.get('StartTime')
        self.stop_time = map.get('StopTime')
        self.finish_time = map.get('FinishTime')
        self.update_time = map.get('UpdateTime')
        return self


class DescribeInvocationsResponseInvocationsInvocationInvokeInstances(TeaModel):
    def __init__(self, invoke_instance=None):
        self.invoke_instance = invoke_instance  # type: List[DescribeInvocationsResponseInvocationsInvocationInvokeInstancesInvokeInstance]

    def validate(self):
        self.validate_required(self.invoke_instance, 'invoke_instance')
        if self.invoke_instance:
            for k in self.invoke_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InvokeInstance'] = []
        if self.invoke_instance is not None:
            for k in self.invoke_instance:
                result['InvokeInstance'].append(k.to_map() if k else None)
        else:
            result['InvokeInstance'] = None
        return result

    def from_map(self, map={}):
        self.invoke_instance = []
        if map.get('InvokeInstance') is not None:
            for k in map.get('InvokeInstance'):
                temp_model = DescribeInvocationsResponseInvocationsInvocationInvokeInstancesInvokeInstance()
                self.invoke_instance.append(temp_model.from_map(k))
        else:
            self.invoke_instance = None
        return self


class DescribeInvocationsResponseInvocationsInvocation(TeaModel):
    def __init__(self, invoke_id=None, creation_time=None, command_id=None, command_type=None, command_name=None,
                 command_content=None, frequency=None, timed=None, invoke_status=None, invocation_status=None, parameters=None,
                 invoke_instances=None):
        self.invoke_id = invoke_id      # type: str
        self.creation_time = creation_time  # type: str
        self.command_id = command_id    # type: str
        self.command_type = command_type  # type: str
        self.command_name = command_name  # type: str
        self.command_content = command_content  # type: str
        self.frequency = frequency      # type: str
        self.timed = timed              # type: bool
        self.invoke_status = invoke_status  # type: str
        self.invocation_status = invocation_status  # type: str
        self.parameters = parameters    # type: str
        self.invoke_instances = invoke_instances  # type: DescribeInvocationsResponseInvocationsInvocationInvokeInstances

    def validate(self):
        self.validate_required(self.invoke_id, 'invoke_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.command_type, 'command_type')
        self.validate_required(self.command_name, 'command_name')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.frequency, 'frequency')
        self.validate_required(self.timed, 'timed')
        self.validate_required(self.invoke_status, 'invoke_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.parameters, 'parameters')
        self.validate_required(self.invoke_instances, 'invoke_instances')
        if self.invoke_instances:
            self.invoke_instances.validate()

    def to_map(self):
        result = {}
        result['InvokeId'] = self.invoke_id
        result['CreationTime'] = self.creation_time
        result['CommandId'] = self.command_id
        result['CommandType'] = self.command_type
        result['CommandName'] = self.command_name
        result['CommandContent'] = self.command_content
        result['Frequency'] = self.frequency
        result['Timed'] = self.timed
        result['InvokeStatus'] = self.invoke_status
        result['InvocationStatus'] = self.invocation_status
        result['Parameters'] = self.parameters
        if self.invoke_instances is not None:
            result['InvokeInstances'] = self.invoke_instances.to_map()
        else:
            result['InvokeInstances'] = None
        return result

    def from_map(self, map={}):
        self.invoke_id = map.get('InvokeId')
        self.creation_time = map.get('CreationTime')
        self.command_id = map.get('CommandId')
        self.command_type = map.get('CommandType')
        self.command_name = map.get('CommandName')
        self.command_content = map.get('CommandContent')
        self.frequency = map.get('Frequency')
        self.timed = map.get('Timed')
        self.invoke_status = map.get('InvokeStatus')
        self.invocation_status = map.get('InvocationStatus')
        self.parameters = map.get('Parameters')
        if map.get('InvokeInstances') is not None:
            temp_model = DescribeInvocationsResponseInvocationsInvocationInvokeInstances()
            self.invoke_instances = temp_model.from_map(map['InvokeInstances'])
        else:
            self.invoke_instances = None
        return self


class DescribeInvocationsResponseInvocations(TeaModel):
    def __init__(self, invocation=None):
        self.invocation = invocation    # type: List[DescribeInvocationsResponseInvocationsInvocation]

    def validate(self):
        self.validate_required(self.invocation, 'invocation')
        if self.invocation:
            for k in self.invocation:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Invocation'] = []
        if self.invocation is not None:
            for k in self.invocation:
                result['Invocation'].append(k.to_map() if k else None)
        else:
            result['Invocation'] = None
        return result

    def from_map(self, map={}):
        self.invocation = []
        if map.get('Invocation') is not None:
            for k in map.get('Invocation'):
                temp_model = DescribeInvocationsResponseInvocationsInvocation()
                self.invocation.append(temp_model.from_map(k))
        else:
            self.invocation = None
        return self


class DescribeInvocationResultsRequest(TeaModel):
    def __init__(self, region_id=None, invoke_id=None, instance_id=None, command_id=None, invoke_record_status=None,
                 include_history=None, content_encoding=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.invoke_id = invoke_id      # type: str
        self.instance_id = instance_id  # type: str
        self.command_id = command_id    # type: str
        self.invoke_record_status = invoke_record_status  # type: str
        self.include_history = include_history  # type: bool
        self.content_encoding = content_encoding  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InvokeId'] = self.invoke_id
        result['InstanceId'] = self.instance_id
        result['CommandId'] = self.command_id
        result['InvokeRecordStatus'] = self.invoke_record_status
        result['IncludeHistory'] = self.include_history
        result['ContentEncoding'] = self.content_encoding
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.invoke_id = map.get('InvokeId')
        self.instance_id = map.get('InstanceId')
        self.command_id = map.get('CommandId')
        self.invoke_record_status = map.get('InvokeRecordStatus')
        self.include_history = map.get('IncludeHistory')
        self.content_encoding = map.get('ContentEncoding')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeInvocationResultsResponse(TeaModel):
    def __init__(self, request_id=None, invocation=None):
        self.request_id = request_id    # type: str
        self.invocation = invocation    # type: DescribeInvocationResultsResponseInvocation

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.invocation, 'invocation')
        if self.invocation:
            self.invocation.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.invocation is not None:
            result['Invocation'] = self.invocation.to_map()
        else:
            result['Invocation'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Invocation') is not None:
            temp_model = DescribeInvocationResultsResponseInvocation()
            self.invocation = temp_model.from_map(map['Invocation'])
        else:
            self.invocation = None
        return self


class DescribeInvocationResultsResponseInvocationInvocationResultsInvocationResult(TeaModel):
    def __init__(self, command_id=None, invoke_id=None, instance_id=None, start_time=None, stop_time=None,
                 finished_time=None, repeats=None, output=None, dropped=None, invoke_record_status=None, invocation_status=None,
                 exit_code=None, error_code=None, error_info=None):
        self.command_id = command_id    # type: str
        self.invoke_id = invoke_id      # type: str
        self.instance_id = instance_id  # type: str
        self.start_time = start_time    # type: str
        self.stop_time = stop_time      # type: str
        self.finished_time = finished_time  # type: str
        self.repeats = repeats          # type: int
        self.output = output            # type: str
        self.dropped = dropped          # type: int
        self.invoke_record_status = invoke_record_status  # type: str
        self.invocation_status = invocation_status  # type: str
        self.exit_code = exit_code      # type: int
        self.error_code = error_code    # type: str
        self.error_info = error_info    # type: str

    def validate(self):
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.invoke_id, 'invoke_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.stop_time, 'stop_time')
        self.validate_required(self.finished_time, 'finished_time')
        self.validate_required(self.repeats, 'repeats')
        self.validate_required(self.output, 'output')
        self.validate_required(self.dropped, 'dropped')
        self.validate_required(self.invoke_record_status, 'invoke_record_status')
        self.validate_required(self.invocation_status, 'invocation_status')
        self.validate_required(self.exit_code, 'exit_code')
        self.validate_required(self.error_code, 'error_code')
        self.validate_required(self.error_info, 'error_info')

    def to_map(self):
        result = {}
        result['CommandId'] = self.command_id
        result['InvokeId'] = self.invoke_id
        result['InstanceId'] = self.instance_id
        result['StartTime'] = self.start_time
        result['StopTime'] = self.stop_time
        result['FinishedTime'] = self.finished_time
        result['Repeats'] = self.repeats
        result['Output'] = self.output
        result['Dropped'] = self.dropped
        result['InvokeRecordStatus'] = self.invoke_record_status
        result['InvocationStatus'] = self.invocation_status
        result['ExitCode'] = self.exit_code
        result['ErrorCode'] = self.error_code
        result['ErrorInfo'] = self.error_info
        return result

    def from_map(self, map={}):
        self.command_id = map.get('CommandId')
        self.invoke_id = map.get('InvokeId')
        self.instance_id = map.get('InstanceId')
        self.start_time = map.get('StartTime')
        self.stop_time = map.get('StopTime')
        self.finished_time = map.get('FinishedTime')
        self.repeats = map.get('Repeats')
        self.output = map.get('Output')
        self.dropped = map.get('Dropped')
        self.invoke_record_status = map.get('InvokeRecordStatus')
        self.invocation_status = map.get('InvocationStatus')
        self.exit_code = map.get('ExitCode')
        self.error_code = map.get('ErrorCode')
        self.error_info = map.get('ErrorInfo')
        return self


class DescribeInvocationResultsResponseInvocationInvocationResults(TeaModel):
    def __init__(self, invocation_result=None):
        self.invocation_result = invocation_result  # type: List[DescribeInvocationResultsResponseInvocationInvocationResultsInvocationResult]

    def validate(self):
        self.validate_required(self.invocation_result, 'invocation_result')
        if self.invocation_result:
            for k in self.invocation_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InvocationResult'] = []
        if self.invocation_result is not None:
            for k in self.invocation_result:
                result['InvocationResult'].append(k.to_map() if k else None)
        else:
            result['InvocationResult'] = None
        return result

    def from_map(self, map={}):
        self.invocation_result = []
        if map.get('InvocationResult') is not None:
            for k in map.get('InvocationResult'):
                temp_model = DescribeInvocationResultsResponseInvocationInvocationResultsInvocationResult()
                self.invocation_result.append(temp_model.from_map(k))
        else:
            self.invocation_result = None
        return self


class DescribeInvocationResultsResponseInvocation(TeaModel):
    def __init__(self, page_size=None, page_number=None, total_count=None, invocation_results=None):
        self.page_size = page_size      # type: int
        self.page_number = page_number  # type: int
        self.total_count = total_count  # type: int
        self.invocation_results = invocation_results  # type: DescribeInvocationResultsResponseInvocationInvocationResults

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.invocation_results, 'invocation_results')
        if self.invocation_results:
            self.invocation_results.validate()

    def to_map(self):
        result = {}
        result['PageSize'] = self.page_size
        result['PageNumber'] = self.page_number
        result['TotalCount'] = self.total_count
        if self.invocation_results is not None:
            result['InvocationResults'] = self.invocation_results.to_map()
        else:
            result['InvocationResults'] = None
        return result

    def from_map(self, map={}):
        self.page_size = map.get('PageSize')
        self.page_number = map.get('PageNumber')
        self.total_count = map.get('TotalCount')
        if map.get('InvocationResults') is not None:
            temp_model = DescribeInvocationResultsResponseInvocationInvocationResults()
            self.invocation_results = temp_model.from_map(map['InvocationResults'])
        else:
            self.invocation_results = None
        return self


class DescribeCommandsRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None, name=None, description=None, type=None,
                 content_encoding=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.type = type                # type: str
        self.content_encoding = content_encoding  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['Type'] = self.type
        result['ContentEncoding'] = self.content_encoding
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.type = map.get('Type')
        self.content_encoding = map.get('ContentEncoding')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeCommandsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, commands=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.commands = commands        # type: DescribeCommandsResponseCommands

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.commands, 'commands')
        if self.commands:
            self.commands.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.commands is not None:
            result['Commands'] = self.commands.to_map()
        else:
            result['Commands'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Commands') is not None:
            temp_model = DescribeCommandsResponseCommands()
            self.commands = temp_model.from_map(map['Commands'])
        else:
            self.commands = None
        return self


class DescribeCommandsResponseCommandsCommandParameterNames(TeaModel):
    def __init__(self, parameter_name=None):
        # ParameterName
        self.parameter_name = parameter_name  # type: List[str]

    def validate(self):
        self.validate_required(self.parameter_name, 'parameter_name')

    def to_map(self):
        result = {}
        result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, map={}):
        self.parameter_name = map.get('ParameterName')
        return self


class DescribeCommandsResponseCommandsCommand(TeaModel):
    def __init__(self, command_id=None, name=None, type=None, description=None, command_content=None,
                 working_dir=None, timeout=None, invoke_times=None, creation_time=None, enable_parameter=None,
                 parameter_names=None):
        self.command_id = command_id    # type: str
        self.name = name                # type: str
        self.type = type                # type: str
        self.description = description  # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int
        self.invoke_times = invoke_times  # type: int
        self.creation_time = creation_time  # type: str
        self.enable_parameter = enable_parameter  # type: bool
        self.parameter_names = parameter_names  # type: DescribeCommandsResponseCommandsCommandParameterNames

    def validate(self):
        self.validate_required(self.command_id, 'command_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.description, 'description')
        self.validate_required(self.command_content, 'command_content')
        self.validate_required(self.working_dir, 'working_dir')
        self.validate_required(self.timeout, 'timeout')
        self.validate_required(self.invoke_times, 'invoke_times')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.enable_parameter, 'enable_parameter')
        self.validate_required(self.parameter_names, 'parameter_names')
        if self.parameter_names:
            self.parameter_names.validate()

    def to_map(self):
        result = {}
        result['CommandId'] = self.command_id
        result['Name'] = self.name
        result['Type'] = self.type
        result['Description'] = self.description
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        result['InvokeTimes'] = self.invoke_times
        result['CreationTime'] = self.creation_time
        result['EnableParameter'] = self.enable_parameter
        if self.parameter_names is not None:
            result['ParameterNames'] = self.parameter_names.to_map()
        else:
            result['ParameterNames'] = None
        return result

    def from_map(self, map={}):
        self.command_id = map.get('CommandId')
        self.name = map.get('Name')
        self.type = map.get('Type')
        self.description = map.get('Description')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        self.invoke_times = map.get('InvokeTimes')
        self.creation_time = map.get('CreationTime')
        self.enable_parameter = map.get('EnableParameter')
        if map.get('ParameterNames') is not None:
            temp_model = DescribeCommandsResponseCommandsCommandParameterNames()
            self.parameter_names = temp_model.from_map(map['ParameterNames'])
        else:
            self.parameter_names = None
        return self


class DescribeCommandsResponseCommands(TeaModel):
    def __init__(self, command=None):
        self.command = command          # type: List[DescribeCommandsResponseCommandsCommand]

    def validate(self):
        self.validate_required(self.command, 'command')
        if self.command:
            for k in self.command:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Command'] = []
        if self.command is not None:
            for k in self.command:
                result['Command'].append(k.to_map() if k else None)
        else:
            result['Command'] = None
        return result

    def from_map(self, map={}):
        self.command = []
        if map.get('Command') is not None:
            for k in map.get('Command'):
                temp_model = DescribeCommandsResponseCommandsCommand()
                self.command.append(temp_model.from_map(k))
        else:
            self.command = None
        return self


class DeleteCommandRequest(TeaModel):
    def __init__(self, region_id=None, command_id=None):
        self.region_id = region_id      # type: str
        self.command_id = command_id    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommandId'] = self.command_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.command_id = map.get('CommandId')
        return self


class DeleteCommandResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateCommandRequest(TeaModel):
    def __init__(self, region_id=None, name=None, description=None, type=None, command_content=None,
                 working_dir=None, timeout=None, enable_parameter=None):
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.type = type                # type: str
        self.command_content = command_content  # type: str
        self.working_dir = working_dir  # type: str
        self.timeout = timeout          # type: int
        self.enable_parameter = enable_parameter  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.type, 'type')
        self.validate_required(self.command_content, 'command_content')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['Type'] = self.type
        result['CommandContent'] = self.command_content
        result['WorkingDir'] = self.working_dir
        result['Timeout'] = self.timeout
        result['EnableParameter'] = self.enable_parameter
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.type = map.get('Type')
        self.command_content = map.get('CommandContent')
        self.working_dir = map.get('WorkingDir')
        self.timeout = map.get('Timeout')
        self.enable_parameter = map.get('EnableParameter')
        return self


class CreateCommandResponse(TeaModel):
    def __init__(self, request_id=None, command_id=None):
        self.request_id = request_id    # type: str
        self.command_id = command_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.command_id, 'command_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['CommandId'] = self.command_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.command_id = map.get('CommandId')
        return self


class ModifySecurityGroupEgressRuleRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None, ip_protocol=None, port_range=None,
                 dest_group_id=None, dest_group_owner_id=None, dest_group_owner_account=None, dest_cidr_ip=None,
                 ipv_6dest_cidr_ip=None, source_cidr_ip=None, ipv_6source_cidr_ip=None, source_port_range=None, policy=None,
                 priority=None, nic_type=None, client_token=None, description=None):
        self.region_id = region_id      # type: str
        self.security_group_id = security_group_id  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.port_range = port_range    # type: str
        self.dest_group_id = dest_group_id  # type: str
        self.dest_group_owner_id = dest_group_owner_id  # type: int
        self.dest_group_owner_account = dest_group_owner_account  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.source_port_range = source_port_range  # type: str
        self.policy = policy            # type: str
        self.priority = priority        # type: str
        self.nic_type = nic_type        # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.ip_protocol, 'ip_protocol')
        self.validate_required(self.port_range, 'port_range')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['SecurityGroupId'] = self.security_group_id
        result['IpProtocol'] = self.ip_protocol
        result['PortRange'] = self.port_range
        result['DestGroupId'] = self.dest_group_id
        result['DestGroupOwnerId'] = self.dest_group_owner_id
        result['DestGroupOwnerAccount'] = self.dest_group_owner_account
        result['DestCidrIp'] = self.dest_cidr_ip
        result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        result['SourceCidrIp'] = self.source_cidr_ip
        result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        result['SourcePortRange'] = self.source_port_range
        result['Policy'] = self.policy
        result['Priority'] = self.priority
        result['NicType'] = self.nic_type
        result['ClientToken'] = self.client_token
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.security_group_id = map.get('SecurityGroupId')
        self.ip_protocol = map.get('IpProtocol')
        self.port_range = map.get('PortRange')
        self.dest_group_id = map.get('DestGroupId')
        self.dest_group_owner_id = map.get('DestGroupOwnerId')
        self.dest_group_owner_account = map.get('DestGroupOwnerAccount')
        self.dest_cidr_ip = map.get('DestCidrIp')
        self.ipv_6dest_cidr_ip = map.get('Ipv6DestCidrIp')
        self.source_cidr_ip = map.get('SourceCidrIp')
        self.ipv_6source_cidr_ip = map.get('Ipv6SourceCidrIp')
        self.source_port_range = map.get('SourcePortRange')
        self.policy = map.get('Policy')
        self.priority = map.get('Priority')
        self.nic_type = map.get('NicType')
        self.client_token = map.get('ClientToken')
        self.description = map.get('Description')
        return self


class ModifySecurityGroupEgressRuleResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyDiskChargeTypeRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, disk_ids=None, auto_pay=None, client_token=None,
                 disk_charge_type=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id      # type: str
        self.disk_ids = disk_ids        # type: str
        self.auto_pay = auto_pay        # type: bool
        self.client_token = client_token  # type: str
        self.disk_charge_type = disk_charge_type  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.disk_ids, 'disk_ids')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['DiskIds'] = self.disk_ids
        result['AutoPay'] = self.auto_pay
        result['ClientToken'] = self.client_token
        result['DiskChargeType'] = self.disk_charge_type
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.disk_ids = map.get('DiskIds')
        self.auto_pay = map.get('AutoPay')
        self.client_token = map.get('ClientToken')
        self.disk_charge_type = map.get('DiskChargeType')
        return self


class ModifyDiskChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        return self


class ModifyNetworkInterfaceAttributeRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None, network_interface_name=None,
                 network_interface_id=None, queue_number=None, description=None):
        self.region_id = region_id      # type: str
        self.security_group_id = security_group_id  # type: List[str]
        self.network_interface_name = network_interface_name  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.queue_number = queue_number  # type: int
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['NetworkInterfaceId'] = self.network_interface_id
        result['QueueNumber'] = self.queue_number
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.queue_number = map.get('QueueNumber')
        self.description = map.get('Description')
        return self


class ModifyNetworkInterfaceAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DetachNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, instance_id=None, trunk_network_instance_id=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.instance_id = instance_id  # type: str
        self.trunk_network_instance_id = trunk_network_instance_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['InstanceId'] = self.instance_id
        result['TrunkNetworkInstanceId'] = self.trunk_network_instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.instance_id = map.get('InstanceId')
        self.trunk_network_instance_id = map.get('TrunkNetworkInstanceId')
        return self


class DetachNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeNetworkInterfacesRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, v_switch_id=None, vpc_id=None,
                 primary_ip_address=None, private_ip_address=None, security_group_id=None, network_interface_name=None, type=None,
                 instance_id=None, network_interface_id=None, service_managed=None, status=None, page_number=None,
                 page_size=None, next_token=None, max_results=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[DescribeNetworkInterfacesRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.primary_ip_address = primary_ip_address  # type: str
        self.private_ip_address = private_ip_address  # type: List[str]
        self.security_group_id = security_group_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.type = type                # type: str
        self.instance_id = instance_id  # type: str
        self.network_interface_id = network_interface_id  # type: List[str]
        self.service_managed = service_managed  # type: bool
        self.status = status            # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.next_token = next_token    # type: str
        self.max_results = max_results  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['VSwitchId'] = self.v_switch_id
        result['VpcId'] = self.vpc_id
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['PrivateIpAddress'] = self.private_ip_address
        result['SecurityGroupId'] = self.security_group_id
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Type'] = self.type
        result['InstanceId'] = self.instance_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['ServiceManaged'] = self.service_managed
        result['Status'] = self.status
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['NextToken'] = self.next_token
        result['MaxResults'] = self.max_results
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfacesRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.v_switch_id = map.get('VSwitchId')
        self.vpc_id = map.get('VpcId')
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.security_group_id = map.get('SecurityGroupId')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.type = map.get('Type')
        self.instance_id = map.get('InstanceId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.service_managed = map.get('ServiceManaged')
        self.status = map.get('Status')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.next_token = map.get('NextToken')
        self.max_results = map.get('MaxResults')
        return self


class DescribeNetworkInterfacesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeNetworkInterfacesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, next_token=None,
                 network_interface_sets=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.next_token = next_token    # type: str
        self.network_interface_sets = network_interface_sets  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.next_token, 'next_token')
        self.validate_required(self.network_interface_sets, 'network_interface_sets')
        if self.network_interface_sets:
            self.network_interface_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['NextToken'] = self.next_token
        if self.network_interface_sets is not None:
            result['NetworkInterfaceSets'] = self.network_interface_sets.to_map()
        else:
            result['NetworkInterfaceSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.next_token = map.get('NextToken')
        if map.get('NetworkInterfaceSets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSets()
            self.network_interface_sets = temp_model.from_map(map['NetworkInterfaceSets'])
        else:
            self.network_interface_sets = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address  # type: str
        self.allocation_id = allocation_id  # type: str

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        result['PublicIpAddress'] = self.public_ip_address
        result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        self.public_ip_address = map.get('PublicIpAddress')
        self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None, associated_public_ip=None):
        self.private_ip_address = private_ip_address  # type: str
        self.primary = primary          # type: bool
        self.associated_public_ip = associated_public_ip  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSetAssociatedPublicIp

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()

    def to_map(self):
        result = {}
        result['PrivateIpAddress'] = self.private_ip_address
        result['Primary'] = self.primary
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        else:
            result['AssociatedPublicIp'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_address = map.get('PrivateIpAddress')
        self.primary = map.get('Primary')
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        else:
            self.associated_public_ip = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set  # type: List[DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSet]

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        else:
            result['PrivateIpSet'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSetsPrivateIpSet()
                self.private_ip_set.append(temp_model.from_map(k))
        else:
            self.private_ip_set = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6SetsIpv6Set(TeaModel):
    def __init__(self, ipv_6address=None):
        self.ipv_6address = ipv_6address  # type: str

    def validate(self):
        self.validate_required(self.ipv_6address, 'ipv_6address')

    def to_map(self):
        result = {}
        result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, map={}):
        self.ipv_6address = map.get('Ipv6Address')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6Sets(TeaModel):
    def __init__(self, ipv_6set=None):
        self.ipv_6set = ipv_6set        # type: List[DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6SetsIpv6Set]

    def validate(self):
        self.validate_required(self.ipv_6set, 'ipv_6set')
        if self.ipv_6set:
            for k in self.ipv_6set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Ipv6Set'] = []
        if self.ipv_6set is not None:
            for k in self.ipv_6set:
                result['Ipv6Set'].append(k.to_map() if k else None)
        else:
            result['Ipv6Set'] = None
        return result

    def from_map(self, map={}):
        self.ipv_6set = []
        if map.get('Ipv6Set') is not None:
            for k in map.get('Ipv6Set'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6SetsIpv6Set()
                self.ipv_6set.append(temp_model.from_map(k))
        else:
            self.ipv_6set = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAssociatedPublicIp(TeaModel):
    def __init__(self, public_ip_address=None, allocation_id=None):
        self.public_ip_address = public_ip_address  # type: str
        self.allocation_id = allocation_id  # type: str

    def validate(self):
        self.validate_required(self.public_ip_address, 'public_ip_address')
        self.validate_required(self.allocation_id, 'allocation_id')

    def to_map(self):
        result = {}
        result['PublicIpAddress'] = self.public_ip_address
        result['AllocationId'] = self.allocation_id
        return result

    def from_map(self, map={}):
        self.public_ip_address = map.get('PublicIpAddress')
        self.allocation_id = map.get('AllocationId')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAttachment(TeaModel):
    def __init__(self, instance_id=None, trunk_network_interface_id=None, device_index=None):
        self.instance_id = instance_id  # type: str
        self.trunk_network_interface_id = trunk_network_interface_id  # type: str
        self.device_index = device_index  # type: int

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.trunk_network_interface_id, 'trunk_network_interface_id')
        self.validate_required(self.device_index, 'device_index')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['TrunkNetworkInterfaceId'] = self.trunk_network_interface_id
        result['DeviceIndex'] = self.device_index
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.trunk_network_interface_id = map.get('TrunkNetworkInterfaceId')
        self.device_index = map.get('DeviceIndex')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        # SecurityGroupId
        self.security_group_id = security_group_id  # type: List[str]

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        self.security_group_id = map.get('SecurityGroupId')
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSet(TeaModel):
    def __init__(self, network_interface_id=None, status=None, type=None, vpc_id=None, v_switch_id=None,
                 zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None, description=None,
                 instance_id=None, creation_time=None, resource_group_id=None, service_id=None, service_managed=None,
                 queue_number=None, owner_id=None, private_ip_sets=None, ipv_6sets=None, tags=None, associated_public_ip=None,
                 attachment=None, security_group_ids=None):
        self.network_interface_id = network_interface_id  # type: str
        self.status = status            # type: str
        self.type = type                # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.zone_id = zone_id          # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.mac_address = mac_address  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.instance_id = instance_id  # type: str
        self.creation_time = creation_time  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.service_id = service_id    # type: int
        self.service_managed = service_managed  # type: bool
        self.queue_number = queue_number  # type: int
        self.owner_id = owner_id        # type: str
        self.private_ip_sets = private_ip_sets  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSets
        self.ipv_6sets = ipv_6sets      # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6Sets
        self.tags = tags                # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTags
        self.associated_public_ip = associated_public_ip  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAssociatedPublicIp
        self.attachment = attachment    # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAttachment
        self.security_group_ids = security_group_ids  # type: DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetSecurityGroupIds

    def validate(self):
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.queue_number, 'queue_number')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.ipv_6sets, 'ipv_6sets')
        if self.ipv_6sets:
            self.ipv_6sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.associated_public_ip, 'associated_public_ip')
        if self.associated_public_ip:
            self.associated_public_ip.validate()
        self.validate_required(self.attachment, 'attachment')
        if self.attachment:
            self.attachment.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Status'] = self.status
        result['Type'] = self.type
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['ZoneId'] = self.zone_id
        result['PrivateIpAddress'] = self.private_ip_address
        result['MacAddress'] = self.mac_address
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['InstanceId'] = self.instance_id
        result['CreationTime'] = self.creation_time
        result['ResourceGroupId'] = self.resource_group_id
        result['ServiceID'] = self.service_id
        result['ServiceManaged'] = self.service_managed
        result['QueueNumber'] = self.queue_number
        result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        else:
            result['PrivateIpSets'] = None
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        else:
            result['Ipv6Sets'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.associated_public_ip is not None:
            result['AssociatedPublicIp'] = self.associated_public_ip.to_map()
        else:
            result['AssociatedPublicIp'] = None
        if self.attachment is not None:
            result['Attachment'] = self.attachment.to_map()
        else:
            result['Attachment'] = None
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        else:
            result['SecurityGroupIds'] = None
        return result

    def from_map(self, map={}):
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.status = map.get('Status')
        self.type = map.get('Type')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.zone_id = map.get('ZoneId')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.mac_address = map.get('MacAddress')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.instance_id = map.get('InstanceId')
        self.creation_time = map.get('CreationTime')
        self.resource_group_id = map.get('ResourceGroupId')
        self.service_id = map.get('ServiceID')
        self.service_managed = map.get('ServiceManaged')
        self.queue_number = map.get('QueueNumber')
        self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetPrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        else:
            self.private_ip_sets = None
        if map.get('Ipv6Sets') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetIpv6Sets()
            self.ipv_6sets = temp_model.from_map(map['Ipv6Sets'])
        else:
            self.ipv_6sets = None
        if map.get('Tags') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('AssociatedPublicIp') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAssociatedPublicIp()
            self.associated_public_ip = temp_model.from_map(map['AssociatedPublicIp'])
        else:
            self.associated_public_ip = None
        if map.get('Attachment') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetAttachment()
            self.attachment = temp_model.from_map(map['Attachment'])
        else:
            self.attachment = None
        if map.get('SecurityGroupIds') is not None:
            temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSetSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        else:
            self.security_group_ids = None
        return self


class DescribeNetworkInterfacesResponseNetworkInterfaceSets(TeaModel):
    def __init__(self, network_interface_set=None):
        self.network_interface_set = network_interface_set  # type: List[DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSet]

    def validate(self):
        self.validate_required(self.network_interface_set, 'network_interface_set')
        if self.network_interface_set:
            for k in self.network_interface_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NetworkInterfaceSet'] = []
        if self.network_interface_set is not None:
            for k in self.network_interface_set:
                result['NetworkInterfaceSet'].append(k.to_map() if k else None)
        else:
            result['NetworkInterfaceSet'] = None
        return result

    def from_map(self, map={}):
        self.network_interface_set = []
        if map.get('NetworkInterfaceSet') is not None:
            for k in map.get('NetworkInterfaceSet'):
                temp_model = DescribeNetworkInterfacesResponseNetworkInterfaceSetsNetworkInterfaceSet()
                self.network_interface_set.append(temp_model.from_map(k))
        else:
            self.network_interface_set = None
        return self


class DeleteNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        return self


class DeleteNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, tag=None, resource_group_id=None, v_switch_id=None, primary_ip_address=None,
                 security_group_id=None, security_group_ids=None, network_interface_name=None, description=None, visible=None,
                 instance_type=None, business_type=None, private_ip_address=None, secondary_private_ip_address_count=None,
                 queue_number=None, client_token=None):
        self.region_id = region_id      # type: str
        self.tag = tag                  # type: List[CreateNetworkInterfaceRequestTag]
        self.resource_group_id = resource_group_id  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.primary_ip_address = primary_ip_address  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: List[str]
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.visible = visible          # type: bool
        self.instance_type = instance_type  # type: str
        self.business_type = business_type  # type: str
        self.private_ip_address = private_ip_address  # type: List[str]
        self.secondary_private_ip_address_count = secondary_private_ip_address_count  # type: int
        self.queue_number = queue_number  # type: int
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        self.validate_required(self.v_switch_id, 'v_switch_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        result['VSwitchId'] = self.v_switch_id
        result['PrimaryIpAddress'] = self.primary_ip_address
        result['SecurityGroupId'] = self.security_group_id
        result['SecurityGroupIds'] = self.security_group_ids
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['Visible'] = self.visible
        result['InstanceType'] = self.instance_type
        result['BusinessType'] = self.business_type
        result['PrivateIpAddress'] = self.private_ip_address
        result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        result['QueueNumber'] = self.queue_number
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateNetworkInterfaceRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        self.v_switch_id = map.get('VSwitchId')
        self.primary_ip_address = map.get('PrimaryIpAddress')
        self.security_group_id = map.get('SecurityGroupId')
        self.security_group_ids = map.get('SecurityGroupIds')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.visible = map.get('Visible')
        self.instance_type = map.get('InstanceType')
        self.business_type = map.get('BusinessType')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.secondary_private_ip_address_count = map.get('SecondaryPrivateIpAddressCount')
        self.queue_number = map.get('QueueNumber')
        self.client_token = map.get('ClientToken')
        return self


class CreateNetworkInterfaceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CreateNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None, network_interface_id=None, status=None, type=None, vpc_id=None,
                 v_switch_id=None, zone_id=None, private_ip_address=None, mac_address=None, network_interface_name=None,
                 description=None, resource_group_id=None, service_id=None, service_managed=None, owner_id=None,
                 private_ip_sets=None, tags=None, security_group_ids=None):
        self.request_id = request_id    # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.status = status            # type: str
        self.type = type                # type: str
        self.vpc_id = vpc_id            # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.zone_id = zone_id          # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.mac_address = mac_address  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.description = description  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.service_id = service_id    # type: int
        self.service_managed = service_managed  # type: bool
        self.owner_id = owner_id        # type: str
        self.private_ip_sets = private_ip_sets  # type: CreateNetworkInterfaceResponsePrivateIpSets
        self.tags = tags                # type: CreateNetworkInterfaceResponseTags
        self.security_group_ids = security_group_ids  # type: CreateNetworkInterfaceResponseSecurityGroupIds

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.v_switch_id, 'v_switch_id')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.mac_address, 'mac_address')
        self.validate_required(self.network_interface_name, 'network_interface_name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.service_id, 'service_id')
        self.validate_required(self.service_managed, 'service_managed')
        self.validate_required(self.owner_id, 'owner_id')
        self.validate_required(self.private_ip_sets, 'private_ip_sets')
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()
        self.validate_required(self.security_group_ids, 'security_group_ids')
        if self.security_group_ids:
            self.security_group_ids.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['Status'] = self.status
        result['Type'] = self.type
        result['VpcId'] = self.vpc_id
        result['VSwitchId'] = self.v_switch_id
        result['ZoneId'] = self.zone_id
        result['PrivateIpAddress'] = self.private_ip_address
        result['MacAddress'] = self.mac_address
        result['NetworkInterfaceName'] = self.network_interface_name
        result['Description'] = self.description
        result['ResourceGroupId'] = self.resource_group_id
        result['ServiceID'] = self.service_id
        result['ServiceManaged'] = self.service_managed
        result['OwnerId'] = self.owner_id
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        else:
            result['PrivateIpSets'] = None
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        else:
            result['SecurityGroupIds'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.status = map.get('Status')
        self.type = map.get('Type')
        self.vpc_id = map.get('VpcId')
        self.v_switch_id = map.get('VSwitchId')
        self.zone_id = map.get('ZoneId')
        self.private_ip_address = map.get('PrivateIpAddress')
        self.mac_address = map.get('MacAddress')
        self.network_interface_name = map.get('NetworkInterfaceName')
        self.description = map.get('Description')
        self.resource_group_id = map.get('ResourceGroupId')
        self.service_id = map.get('ServiceID')
        self.service_managed = map.get('ServiceManaged')
        self.owner_id = map.get('OwnerId')
        if map.get('PrivateIpSets') is not None:
            temp_model = CreateNetworkInterfaceResponsePrivateIpSets()
            self.private_ip_sets = temp_model.from_map(map['PrivateIpSets'])
        else:
            self.private_ip_sets = None
        if map.get('Tags') is not None:
            temp_model = CreateNetworkInterfaceResponseTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        if map.get('SecurityGroupIds') is not None:
            temp_model = CreateNetworkInterfaceResponseSecurityGroupIds()
            self.security_group_ids = temp_model.from_map(map['SecurityGroupIds'])
        else:
            self.security_group_ids = None
        return self


class CreateNetworkInterfaceResponsePrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None, primary=None):
        self.private_ip_address = private_ip_address  # type: str
        self.primary = primary          # type: bool

    def validate(self):
        self.validate_required(self.private_ip_address, 'private_ip_address')
        self.validate_required(self.primary, 'primary')

    def to_map(self):
        result = {}
        result['PrivateIpAddress'] = self.private_ip_address
        result['Primary'] = self.primary
        return result

    def from_map(self, map={}):
        self.private_ip_address = map.get('PrivateIpAddress')
        self.primary = map.get('Primary')
        return self


class CreateNetworkInterfaceResponsePrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set  # type: List[CreateNetworkInterfaceResponsePrivateIpSetsPrivateIpSet]

    def validate(self):
        self.validate_required(self.private_ip_set, 'private_ip_set')
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        else:
            result['PrivateIpSet'] = None
        return result

    def from_map(self, map={}):
        self.private_ip_set = []
        if map.get('PrivateIpSet') is not None:
            for k in map.get('PrivateIpSet'):
                temp_model = CreateNetworkInterfaceResponsePrivateIpSetsPrivateIpSet()
                self.private_ip_set.append(temp_model.from_map(k))
        else:
            self.private_ip_set = None
        return self


class CreateNetworkInterfaceResponseTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class CreateNetworkInterfaceResponseTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[CreateNetworkInterfaceResponseTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateNetworkInterfaceResponseTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class CreateNetworkInterfaceResponseSecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id  # type: List[str]

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        self.security_group_id = map.get('SecurityGroupId')
        return self


class AttachNetworkInterfaceRequest(TeaModel):
    def __init__(self, region_id=None, network_interface_id=None, instance_id=None, trunk_network_instance_id=None,
                 wait_for_network_configuration_ready=None):
        self.region_id = region_id      # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.instance_id = instance_id  # type: str
        self.trunk_network_instance_id = trunk_network_instance_id  # type: str
        self.wait_for_network_configuration_ready = wait_for_network_configuration_ready  # type: bool

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.network_interface_id, 'network_interface_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NetworkInterfaceId'] = self.network_interface_id
        result['InstanceId'] = self.instance_id
        result['TrunkNetworkInstanceId'] = self.trunk_network_instance_id
        result['WaitForNetworkConfigurationReady'] = self.wait_for_network_configuration_ready
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.network_interface_id = map.get('NetworkInterfaceId')
        self.instance_id = map.get('InstanceId')
        self.trunk_network_instance_id = map.get('TrunkNetworkInstanceId')
        self.wait_for_network_configuration_ready = map.get('WaitForNetworkConfigurationReady')
        return self


class AttachNetworkInterfaceResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeRecommendInstanceTypeRequest(TeaModel):
    def __init__(self, cores=None, memory=None, instance_family_level=None, instance_type=None, network_type=None,
                 instance_charge_type=None, spot_strategy=None, io_optimized=None, instance_type_family=None, priority_strategy=None,
                 max_price=None, region_id=None, zone_id=None, system_disk_category=None, scene=None):
        self.cores = cores              # type: int
        self.memory = memory            # type: float
        self.instance_family_level = instance_family_level  # type: str
        self.instance_type = instance_type  # type: str
        self.network_type = network_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.io_optimized = io_optimized  # type: str
        self.instance_type_family = instance_type_family  # type: List[str]
        self.priority_strategy = priority_strategy  # type: str
        self.max_price = max_price      # type: float
        self.region_id = region_id      # type: str
        self.zone_id = zone_id          # type: str
        self.system_disk_category = system_disk_category  # type: str
        self.scene = scene              # type: str

    def validate(self):
        self.validate_required(self.network_type, 'network_type')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['Cores'] = self.cores
        result['Memory'] = self.memory
        result['InstanceFamilyLevel'] = self.instance_family_level
        result['InstanceType'] = self.instance_type
        result['NetworkType'] = self.network_type
        result['InstanceChargeType'] = self.instance_charge_type
        result['SpotStrategy'] = self.spot_strategy
        result['IoOptimized'] = self.io_optimized
        result['InstanceTypeFamily'] = self.instance_type_family
        result['PriorityStrategy'] = self.priority_strategy
        result['MaxPrice'] = self.max_price
        result['RegionId'] = self.region_id
        result['ZoneId'] = self.zone_id
        result['SystemDiskCategory'] = self.system_disk_category
        result['Scene'] = self.scene
        return result

    def from_map(self, map={}):
        self.cores = map.get('Cores')
        self.memory = map.get('Memory')
        self.instance_family_level = map.get('InstanceFamilyLevel')
        self.instance_type = map.get('InstanceType')
        self.network_type = map.get('NetworkType')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.spot_strategy = map.get('SpotStrategy')
        self.io_optimized = map.get('IoOptimized')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.priority_strategy = map.get('PriorityStrategy')
        self.max_price = map.get('MaxPrice')
        self.region_id = map.get('RegionId')
        self.zone_id = map.get('ZoneId')
        self.system_disk_category = map.get('SystemDiskCategory')
        self.scene = map.get('Scene')
        return self


class DescribeRecommendInstanceTypeResponse(TeaModel):
    def __init__(self, request_id=None, data=None):
        self.request_id = request_id    # type: str
        self.data = data                # type: DescribeRecommendInstanceTypeResponseData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        else:
            result['Data'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('Data') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseData()
            self.data = temp_model.from_map(map['Data'])
        else:
            self.data = None
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZoneNetworkTypes(TeaModel):
    def __init__(self, network_type=None):
        # NetworkType
        self.network_type = network_type  # type: List[str]

    def validate(self):
        self.validate_required(self.network_type, 'network_type')

    def to_map(self):
        result = {}
        result['NetworkType'] = self.network_type
        return result

    def from_map(self, map={}):
        self.network_type = map.get('NetworkType')
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZone(TeaModel):
    def __init__(self, zone_no=None, network_types=None):
        self.zone_no = zone_no          # type: str
        self.network_types = network_types  # type: DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZoneNetworkTypes

    def validate(self):
        self.validate_required(self.zone_no, 'zone_no')
        self.validate_required(self.network_types, 'network_types')
        if self.network_types:
            self.network_types.validate()

    def to_map(self):
        result = {}
        result['ZoneNo'] = self.zone_no
        if self.network_types is not None:
            result['NetworkTypes'] = self.network_types.to_map()
        else:
            result['NetworkTypes'] = None
        return result

    def from_map(self, map={}):
        self.zone_no = map.get('ZoneNo')
        if map.get('NetworkTypes') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZoneNetworkTypes()
            self.network_types = temp_model.from_map(map['NetworkTypes'])
        else:
            self.network_types = None
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZones(TeaModel):
    def __init__(self, zone=None):
        self.zone = zone                # type: List[DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZone]

    def validate(self):
        self.validate_required(self.zone, 'zone')
        if self.zone:
            for k in self.zone:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['zone'] = []
        if self.zone is not None:
            for k in self.zone:
                result['zone'].append(k.to_map() if k else None)
        else:
            result['zone'] = None
        return result

    def from_map(self, map={}):
        self.zone = []
        if map.get('zone') is not None:
            for k in map.get('zone'):
                temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZonesZone()
                self.zone.append(temp_model.from_map(k))
        else:
            self.zone = None
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeInstanceType(TeaModel):
    def __init__(self, generation=None, instance_type_family=None, instance_type=None, support_io_optimized=None,
                 cores=None, memory=None):
        self.generation = generation    # type: str
        self.instance_type_family = instance_type_family  # type: str
        self.instance_type = instance_type  # type: str
        self.support_io_optimized = support_io_optimized  # type: str
        self.cores = cores              # type: int
        self.memory = memory            # type: int

    def validate(self):
        self.validate_required(self.generation, 'generation')
        self.validate_required(self.instance_type_family, 'instance_type_family')
        self.validate_required(self.instance_type, 'instance_type')
        self.validate_required(self.support_io_optimized, 'support_io_optimized')
        self.validate_required(self.cores, 'cores')
        self.validate_required(self.memory, 'memory')

    def to_map(self):
        result = {}
        result['Generation'] = self.generation
        result['InstanceTypeFamily'] = self.instance_type_family
        result['InstanceType'] = self.instance_type
        result['SupportIoOptimized'] = self.support_io_optimized
        result['Cores'] = self.cores
        result['Memory'] = self.memory
        return result

    def from_map(self, map={}):
        self.generation = map.get('Generation')
        self.instance_type_family = map.get('InstanceTypeFamily')
        self.instance_type = map.get('InstanceType')
        self.support_io_optimized = map.get('SupportIoOptimized')
        self.cores = map.get('Cores')
        self.memory = map.get('Memory')
        return self


class DescribeRecommendInstanceTypeResponseDataRecommendInstanceType(TeaModel):
    def __init__(self, region_id=None, commodity_code=None, scene=None, instance_charge_type=None,
                 spot_strategy=None, priority=None, zones=None, instance_type=None):
        self.region_id = region_id      # type: str
        self.commodity_code = commodity_code  # type: str
        self.scene = scene              # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.priority = priority        # type: int
        self.zones = zones              # type: DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZones
        self.instance_type = instance_type  # type: DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeInstanceType

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.commodity_code, 'commodity_code')
        self.validate_required(self.scene, 'scene')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.spot_strategy, 'spot_strategy')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.zones, 'zones')
        if self.zones:
            self.zones.validate()
        self.validate_required(self.instance_type, 'instance_type')
        if self.instance_type:
            self.instance_type.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['CommodityCode'] = self.commodity_code
        result['Scene'] = self.scene
        result['InstanceChargeType'] = self.instance_charge_type
        result['SpotStrategy'] = self.spot_strategy
        result['Priority'] = self.priority
        if self.zones is not None:
            result['Zones'] = self.zones.to_map()
        else:
            result['Zones'] = None
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type.to_map()
        else:
            result['InstanceType'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.commodity_code = map.get('CommodityCode')
        self.scene = map.get('Scene')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.spot_strategy = map.get('SpotStrategy')
        self.priority = map.get('Priority')
        if map.get('Zones') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeZones()
            self.zones = temp_model.from_map(map['Zones'])
        else:
            self.zones = None
        if map.get('InstanceType') is not None:
            temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceTypeInstanceType()
            self.instance_type = temp_model.from_map(map['InstanceType'])
        else:
            self.instance_type = None
        return self


class DescribeRecommendInstanceTypeResponseData(TeaModel):
    def __init__(self, recommend_instance_type=None):
        self.recommend_instance_type = recommend_instance_type  # type: List[DescribeRecommendInstanceTypeResponseDataRecommendInstanceType]

    def validate(self):
        self.validate_required(self.recommend_instance_type, 'recommend_instance_type')
        if self.recommend_instance_type:
            for k in self.recommend_instance_type:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RecommendInstanceType'] = []
        if self.recommend_instance_type is not None:
            for k in self.recommend_instance_type:
                result['RecommendInstanceType'].append(k.to_map() if k else None)
        else:
            result['RecommendInstanceType'] = None
        return result

    def from_map(self, map={}):
        self.recommend_instance_type = []
        if map.get('RecommendInstanceType') is not None:
            for k in map.get('RecommendInstanceType'):
                temp_model = DescribeRecommendInstanceTypeResponseDataRecommendInstanceType()
                self.recommend_instance_type.append(temp_model.from_map(k))
        else:
            self.recommend_instance_type = None
        return self


class ModifyPrepayInstanceSpecRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, instance_type=None, operator_type=None, client_token=None,
                 auto_pay=None, migrate_across_zone=None, system_disk=None, reboot_time=None, end_time=None,
                 reboot_when_finished=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id      # type: str
        self.instance_type = instance_type  # type: str
        self.operator_type = operator_type  # type: str
        self.client_token = client_token  # type: str
        self.auto_pay = auto_pay        # type: bool
        self.migrate_across_zone = migrate_across_zone  # type: bool
        self.system_disk = system_disk  # type: ModifyPrepayInstanceSpecRequestSystemDisk
        self.reboot_time = reboot_time  # type: str
        self.end_time = end_time        # type: str
        self.reboot_when_finished = reboot_when_finished  # type: bool

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_type, 'instance_type')
        if self.system_disk:
            self.system_disk.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['InstanceType'] = self.instance_type
        result['OperatorType'] = self.operator_type
        result['ClientToken'] = self.client_token
        result['AutoPay'] = self.auto_pay
        result['MigrateAcrossZone'] = self.migrate_across_zone
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['RebootTime'] = self.reboot_time
        result['EndTime'] = self.end_time
        result['RebootWhenFinished'] = self.reboot_when_finished
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.instance_type = map.get('InstanceType')
        self.operator_type = map.get('OperatorType')
        self.client_token = map.get('ClientToken')
        self.auto_pay = map.get('AutoPay')
        self.migrate_across_zone = map.get('MigrateAcrossZone')
        if map.get('SystemDisk') is not None:
            temp_model = ModifyPrepayInstanceSpecRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.reboot_time = map.get('RebootTime')
        self.end_time = map.get('EndTime')
        self.reboot_when_finished = map.get('RebootWhenFinished')
        return self


class ModifyPrepayInstanceSpecRequestSystemDisk(TeaModel):
    def __init__(self, category=None):
        self.category = category        # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Category'] = self.category
        return result

    def from_map(self, map={}):
        self.category = map.get('Category')
        return self


class ModifyPrepayInstanceSpecResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        return self


class ModifyInstanceChargeTypeRequest(TeaModel):
    def __init__(self, instance_ids=None, region_id=None, period=None, period_unit=None, include_data_disks=None,
                 dry_run=None, auto_pay=None, instance_charge_type=None, client_token=None, is_detail_fee=None):
        self.instance_ids = instance_ids  # type: str
        self.region_id = region_id      # type: str
        self.period = period            # type: int
        self.period_unit = period_unit  # type: str
        self.include_data_disks = include_data_disks  # type: bool
        self.dry_run = dry_run          # type: bool
        self.auto_pay = auto_pay        # type: bool
        self.instance_charge_type = instance_charge_type  # type: str
        self.client_token = client_token  # type: str
        self.is_detail_fee = is_detail_fee  # type: bool

    def validate(self):
        self.validate_required(self.instance_ids, 'instance_ids')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceIds'] = self.instance_ids
        result['RegionId'] = self.region_id
        result['Period'] = self.period
        result['PeriodUnit'] = self.period_unit
        result['IncludeDataDisks'] = self.include_data_disks
        result['DryRun'] = self.dry_run
        result['AutoPay'] = self.auto_pay
        result['InstanceChargeType'] = self.instance_charge_type
        result['ClientToken'] = self.client_token
        result['IsDetailFee'] = self.is_detail_fee
        return result

    def from_map(self, map={}):
        self.instance_ids = map.get('InstanceIds')
        self.region_id = map.get('RegionId')
        self.period = map.get('Period')
        self.period_unit = map.get('PeriodUnit')
        self.include_data_disks = map.get('IncludeDataDisks')
        self.dry_run = map.get('DryRun')
        self.auto_pay = map.get('AutoPay')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.client_token = map.get('ClientToken')
        self.is_detail_fee = map.get('IsDetailFee')
        return self


class ModifyInstanceChargeTypeResponse(TeaModel):
    def __init__(self, request_id=None, order_id=None, fee_of_instances=None):
        self.request_id = request_id    # type: str
        self.order_id = order_id        # type: str
        self.fee_of_instances = fee_of_instances  # type: ModifyInstanceChargeTypeResponseFeeOfInstances

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.order_id, 'order_id')
        self.validate_required(self.fee_of_instances, 'fee_of_instances')
        if self.fee_of_instances:
            self.fee_of_instances.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['OrderId'] = self.order_id
        if self.fee_of_instances is not None:
            result['FeeOfInstances'] = self.fee_of_instances.to_map()
        else:
            result['FeeOfInstances'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.order_id = map.get('OrderId')
        if map.get('FeeOfInstances') is not None:
            temp_model = ModifyInstanceChargeTypeResponseFeeOfInstances()
            self.fee_of_instances = temp_model.from_map(map['FeeOfInstances'])
        else:
            self.fee_of_instances = None
        return self


class ModifyInstanceChargeTypeResponseFeeOfInstancesFeeOfInstance(TeaModel):
    def __init__(self, instance_id=None, fee=None, currency=None):
        self.instance_id = instance_id  # type: str
        self.fee = fee                  # type: str
        self.currency = currency        # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.fee, 'fee')
        self.validate_required(self.currency, 'currency')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Fee'] = self.fee
        result['Currency'] = self.currency
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.fee = map.get('Fee')
        self.currency = map.get('Currency')
        return self


class ModifyInstanceChargeTypeResponseFeeOfInstances(TeaModel):
    def __init__(self, fee_of_instance=None):
        self.fee_of_instance = fee_of_instance  # type: List[ModifyInstanceChargeTypeResponseFeeOfInstancesFeeOfInstance]

    def validate(self):
        self.validate_required(self.fee_of_instance, 'fee_of_instance')
        if self.fee_of_instance:
            for k in self.fee_of_instance:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['FeeOfInstance'] = []
        if self.fee_of_instance is not None:
            for k in self.fee_of_instance:
                result['FeeOfInstance'].append(k.to_map() if k else None)
        else:
            result['FeeOfInstance'] = None
        return result

    def from_map(self, map={}):
        self.fee_of_instance = []
        if map.get('FeeOfInstance') is not None:
            for k in map.get('FeeOfInstance'):
                temp_model = ModifyInstanceChargeTypeResponseFeeOfInstancesFeeOfInstance()
                self.fee_of_instance.append(temp_model.from_map(k))
        else:
            self.fee_of_instance = None
        return self


class JoinResourceGroupRequest(TeaModel):
    def __init__(self, resource_type=None, resource_id=None, region_id=None, resource_group_id=None):
        self.resource_type = resource_type  # type: str
        self.resource_id = resource_id  # type: str
        self.region_id = region_id      # type: str
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['ResourceType'] = self.resource_type
        result['ResourceId'] = self.resource_id
        result['RegionId'] = self.region_id
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.resource_type = map.get('ResourceType')
        self.resource_id = map.get('ResourceId')
        self.region_id = map.get('RegionId')
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class JoinResourceGroupResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifySecurityGroupPolicyRequest(TeaModel):
    def __init__(self, security_group_id=None, region_id=None, inner_access_policy=None, client_token=None):
        self.security_group_id = security_group_id  # type: str
        self.region_id = region_id      # type: str
        self.inner_access_policy = inner_access_policy  # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.inner_access_policy, 'inner_access_policy')

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = self.security_group_id
        result['RegionId'] = self.region_id
        result['InnerAccessPolicy'] = self.inner_access_policy
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.security_group_id = map.get('SecurityGroupId')
        self.region_id = map.get('RegionId')
        self.inner_access_policy = map.get('InnerAccessPolicy')
        self.client_token = map.get('ClientToken')
        return self


class ModifySecurityGroupPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeSecurityGroupReferencesRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None):
        self.region_id = region_id      # type: str
        self.security_group_id = security_group_id  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.security_group_id = map.get('SecurityGroupId')
        return self


class DescribeSecurityGroupReferencesResponse(TeaModel):
    def __init__(self, request_id=None, security_group_references=None):
        self.request_id = request_id    # type: str
        self.security_group_references = security_group_references  # type: DescribeSecurityGroupReferencesResponseSecurityGroupReferences

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.security_group_references, 'security_group_references')
        if self.security_group_references:
            self.security_group_references.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.security_group_references is not None:
            result['SecurityGroupReferences'] = self.security_group_references.to_map()
        else:
            result['SecurityGroupReferences'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('SecurityGroupReferences') is not None:
            temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferences()
            self.security_group_references = temp_model.from_map(map['SecurityGroupReferences'])
        else:
            self.security_group_references = None
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroupsReferencingSecurityGroup(TeaModel):
    def __init__(self, ali_uid=None, security_group_id=None):
        self.ali_uid = ali_uid          # type: str
        self.security_group_id = security_group_id  # type: str

    def validate(self):
        self.validate_required(self.ali_uid, 'ali_uid')
        self.validate_required(self.security_group_id, 'security_group_id')

    def to_map(self):
        result = {}
        result['AliUid'] = self.ali_uid
        result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, map={}):
        self.ali_uid = map.get('AliUid')
        self.security_group_id = map.get('SecurityGroupId')
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroups(TeaModel):
    def __init__(self, referencing_security_group=None):
        self.referencing_security_group = referencing_security_group  # type: List[DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroupsReferencingSecurityGroup]

    def validate(self):
        self.validate_required(self.referencing_security_group, 'referencing_security_group')
        if self.referencing_security_group:
            for k in self.referencing_security_group:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ReferencingSecurityGroup'] = []
        if self.referencing_security_group is not None:
            for k in self.referencing_security_group:
                result['ReferencingSecurityGroup'].append(k.to_map() if k else None)
        else:
            result['ReferencingSecurityGroup'] = None
        return result

    def from_map(self, map={}):
        self.referencing_security_group = []
        if map.get('ReferencingSecurityGroup') is not None:
            for k in map.get('ReferencingSecurityGroup'):
                temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroupsReferencingSecurityGroup()
                self.referencing_security_group.append(temp_model.from_map(k))
        else:
            self.referencing_security_group = None
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReference(TeaModel):
    def __init__(self, security_group_id=None, referencing_security_groups=None):
        self.security_group_id = security_group_id  # type: str
        self.referencing_security_groups = referencing_security_groups  # type: DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroups

    def validate(self):
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.referencing_security_groups, 'referencing_security_groups')
        if self.referencing_security_groups:
            self.referencing_security_groups.validate()

    def to_map(self):
        result = {}
        result['SecurityGroupId'] = self.security_group_id
        if self.referencing_security_groups is not None:
            result['ReferencingSecurityGroups'] = self.referencing_security_groups.to_map()
        else:
            result['ReferencingSecurityGroups'] = None
        return result

    def from_map(self, map={}):
        self.security_group_id = map.get('SecurityGroupId')
        if map.get('ReferencingSecurityGroups') is not None:
            temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReferenceReferencingSecurityGroups()
            self.referencing_security_groups = temp_model.from_map(map['ReferencingSecurityGroups'])
        else:
            self.referencing_security_groups = None
        return self


class DescribeSecurityGroupReferencesResponseSecurityGroupReferences(TeaModel):
    def __init__(self, security_group_reference=None):
        self.security_group_reference = security_group_reference  # type: List[DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReference]

    def validate(self):
        self.validate_required(self.security_group_reference, 'security_group_reference')
        if self.security_group_reference:
            for k in self.security_group_reference:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SecurityGroupReference'] = []
        if self.security_group_reference is not None:
            for k in self.security_group_reference:
                result['SecurityGroupReference'].append(k.to_map() if k else None)
        else:
            result['SecurityGroupReference'] = None
        return result

    def from_map(self, map={}):
        self.security_group_reference = []
        if map.get('SecurityGroupReference') is not None:
            for k in map.get('SecurityGroupReference'):
                temp_model = DescribeSecurityGroupReferencesResponseSecurityGroupReferencesSecurityGroupReference()
                self.security_group_reference.append(temp_model.from_map(k))
        else:
            self.security_group_reference = None
        return self


class DetachClassicLinkVpcRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, vpc_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.vpc_id = vpc_id            # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.vpc_id = map.get('VpcId')
        return self


class DetachClassicLinkVpcResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeClassicLinkInstancesRequest(TeaModel):
    def __init__(self, region_id=None, vpc_id=None, instance_id=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.vpc_id = vpc_id            # type: str
        self.instance_id = instance_id  # type: str
        self.page_number = page_number  # type: str
        self.page_size = page_size      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['VpcId'] = self.vpc_id
        result['InstanceId'] = self.instance_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.vpc_id = map.get('VpcId')
        self.instance_id = map.get('InstanceId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeClassicLinkInstancesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, links=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.links = links              # type: DescribeClassicLinkInstancesResponseLinks

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.links, 'links')
        if self.links:
            self.links.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.links is not None:
            result['Links'] = self.links.to_map()
        else:
            result['Links'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('Links') is not None:
            temp_model = DescribeClassicLinkInstancesResponseLinks()
            self.links = temp_model.from_map(map['Links'])
        else:
            self.links = None
        return self


class DescribeClassicLinkInstancesResponseLinksLink(TeaModel):
    def __init__(self, instance_id=None, vpc_id=None):
        self.instance_id = instance_id  # type: str
        self.vpc_id = vpc_id            # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.vpc_id = map.get('VpcId')
        return self


class DescribeClassicLinkInstancesResponseLinks(TeaModel):
    def __init__(self, link=None):
        self.link = link                # type: List[DescribeClassicLinkInstancesResponseLinksLink]

    def validate(self):
        self.validate_required(self.link, 'link')
        if self.link:
            for k in self.link:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Link'] = []
        if self.link is not None:
            for k in self.link:
                result['Link'].append(k.to_map() if k else None)
        else:
            result['Link'] = None
        return result

    def from_map(self, map={}):
        self.link = []
        if map.get('Link') is not None:
            for k in map.get('Link'):
                temp_model = DescribeClassicLinkInstancesResponseLinksLink()
                self.link.append(temp_model.from_map(k))
        else:
            self.link = None
        return self


class AttachClassicLinkVpcRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, vpc_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.vpc_id = vpc_id            # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.vpc_id, 'vpc_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['VpcId'] = self.vpc_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.vpc_id = map.get('VpcId')
        return self


class AttachClassicLinkVpcResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DetachInstanceRamRoleRequest(TeaModel):
    def __init__(self, region_id=None, ram_role_name=None, instance_ids=None):
        self.region_id = region_id      # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.instance_ids = instance_ids  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RamRoleName'] = self.ram_role_name
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.ram_role_name = map.get('RamRoleName')
        self.instance_ids = map.get('InstanceIds')
        return self


class DetachInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, ram_role_name=None,
                 detach_instance_ram_role_results=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.fail_count = fail_count    # type: int
        self.ram_role_name = ram_role_name  # type: str
        self.detach_instance_ram_role_results = detach_instance_ram_role_results  # type: DetachInstanceRamRoleResponseDetachInstanceRamRoleResults

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.detach_instance_ram_role_results, 'detach_instance_ram_role_results')
        if self.detach_instance_ram_role_results:
            self.detach_instance_ram_role_results.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['FailCount'] = self.fail_count
        result['RamRoleName'] = self.ram_role_name
        if self.detach_instance_ram_role_results is not None:
            result['DetachInstanceRamRoleResults'] = self.detach_instance_ram_role_results.to_map()
        else:
            result['DetachInstanceRamRoleResults'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.fail_count = map.get('FailCount')
        self.ram_role_name = map.get('RamRoleName')
        if map.get('DetachInstanceRamRoleResults') is not None:
            temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResults()
            self.detach_instance_ram_role_results = temp_model.from_map(map['DetachInstanceRamRoleResults'])
        else:
            self.detach_instance_ram_role_results = None
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSetsInstanceRamRoleSet(TeaModel):
    def __init__(self, instance_id=None, ram_role_name=None):
        self.instance_id = instance_id  # type: str
        self.ram_role_name = ram_role_name  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.ram_role_name = map.get('RamRoleName')
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSets(TeaModel):
    def __init__(self, instance_ram_role_set=None):
        self.instance_ram_role_set = instance_ram_role_set  # type: List[DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSetsInstanceRamRoleSet]

    def validate(self):
        self.validate_required(self.instance_ram_role_set, 'instance_ram_role_set')
        if self.instance_ram_role_set:
            for k in self.instance_ram_role_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceRamRoleSet'] = []
        if self.instance_ram_role_set is not None:
            for k in self.instance_ram_role_set:
                result['InstanceRamRoleSet'].append(k.to_map() if k else None)
        else:
            result['InstanceRamRoleSet'] = None
        return result

    def from_map(self, map={}):
        self.instance_ram_role_set = []
        if map.get('InstanceRamRoleSet') is not None:
            for k in map.get('InstanceRamRoleSet'):
                temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSetsInstanceRamRoleSet()
                self.instance_ram_role_set.append(temp_model.from_map(k))
        else:
            self.instance_ram_role_set = None
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None, instance_ram_role_sets=None):
        self.instance_id = instance_id  # type: str
        self.success = success          # type: bool
        self.code = code                # type: str
        self.message = message          # type: str
        self.instance_ram_role_sets = instance_ram_role_sets  # type: DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSets

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.instance_ram_role_sets, 'instance_ram_role_sets')
        if self.instance_ram_role_sets:
            self.instance_ram_role_sets.validate()

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Success'] = self.success
        result['Code'] = self.code
        result['Message'] = self.message
        if self.instance_ram_role_sets is not None:
            result['InstanceRamRoleSets'] = self.instance_ram_role_sets.to_map()
        else:
            result['InstanceRamRoleSets'] = None
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.success = map.get('Success')
        self.code = map.get('Code')
        self.message = map.get('Message')
        if map.get('InstanceRamRoleSets') is not None:
            temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResultInstanceRamRoleSets()
            self.instance_ram_role_sets = temp_model.from_map(map['InstanceRamRoleSets'])
        else:
            self.instance_ram_role_sets = None
        return self


class DetachInstanceRamRoleResponseDetachInstanceRamRoleResults(TeaModel):
    def __init__(self, detach_instance_ram_role_result=None):
        self.detach_instance_ram_role_result = detach_instance_ram_role_result  # type: List[DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResult]

    def validate(self):
        self.validate_required(self.detach_instance_ram_role_result, 'detach_instance_ram_role_result')
        if self.detach_instance_ram_role_result:
            for k in self.detach_instance_ram_role_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DetachInstanceRamRoleResult'] = []
        if self.detach_instance_ram_role_result is not None:
            for k in self.detach_instance_ram_role_result:
                result['DetachInstanceRamRoleResult'].append(k.to_map() if k else None)
        else:
            result['DetachInstanceRamRoleResult'] = None
        return result

    def from_map(self, map={}):
        self.detach_instance_ram_role_result = []
        if map.get('DetachInstanceRamRoleResult') is not None:
            for k in map.get('DetachInstanceRamRoleResult'):
                temp_model = DetachInstanceRamRoleResponseDetachInstanceRamRoleResultsDetachInstanceRamRoleResult()
                self.detach_instance_ram_role_result.append(temp_model.from_map(k))
        else:
            self.detach_instance_ram_role_result = None
        return self


class DescribeInstanceRamRoleRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None, instance_ids=None, ram_role_name=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.region_id = region_id      # type: str
        self.instance_ids = instance_ids  # type: str
        self.ram_role_name = ram_role_name  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['RegionId'] = self.region_id
        result['InstanceIds'] = self.instance_ids
        result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.region_id = map.get('RegionId')
        self.instance_ids = map.get('InstanceIds')
        self.ram_role_name = map.get('RamRoleName')
        return self


class DescribeInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, total_count=None, instance_ram_role_sets=None):
        self.request_id = request_id    # type: str
        self.region_id = region_id      # type: str
        self.total_count = total_count  # type: int
        self.instance_ram_role_sets = instance_ram_role_sets  # type: DescribeInstanceRamRoleResponseInstanceRamRoleSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.instance_ram_role_sets, 'instance_ram_role_sets')
        if self.instance_ram_role_sets:
            self.instance_ram_role_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RegionId'] = self.region_id
        result['TotalCount'] = self.total_count
        if self.instance_ram_role_sets is not None:
            result['InstanceRamRoleSets'] = self.instance_ram_role_sets.to_map()
        else:
            result['InstanceRamRoleSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.region_id = map.get('RegionId')
        self.total_count = map.get('TotalCount')
        if map.get('InstanceRamRoleSets') is not None:
            temp_model = DescribeInstanceRamRoleResponseInstanceRamRoleSets()
            self.instance_ram_role_sets = temp_model.from_map(map['InstanceRamRoleSets'])
        else:
            self.instance_ram_role_sets = None
        return self


class DescribeInstanceRamRoleResponseInstanceRamRoleSetsInstanceRamRoleSet(TeaModel):
    def __init__(self, instance_id=None, ram_role_name=None):
        self.instance_id = instance_id  # type: str
        self.ram_role_name = ram_role_name  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RamRoleName'] = self.ram_role_name
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.ram_role_name = map.get('RamRoleName')
        return self


class DescribeInstanceRamRoleResponseInstanceRamRoleSets(TeaModel):
    def __init__(self, instance_ram_role_set=None):
        self.instance_ram_role_set = instance_ram_role_set  # type: List[DescribeInstanceRamRoleResponseInstanceRamRoleSetsInstanceRamRoleSet]

    def validate(self):
        self.validate_required(self.instance_ram_role_set, 'instance_ram_role_set')
        if self.instance_ram_role_set:
            for k in self.instance_ram_role_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceRamRoleSet'] = []
        if self.instance_ram_role_set is not None:
            for k in self.instance_ram_role_set:
                result['InstanceRamRoleSet'].append(k.to_map() if k else None)
        else:
            result['InstanceRamRoleSet'] = None
        return result

    def from_map(self, map={}):
        self.instance_ram_role_set = []
        if map.get('InstanceRamRoleSet') is not None:
            for k in map.get('InstanceRamRoleSet'):
                temp_model = DescribeInstanceRamRoleResponseInstanceRamRoleSetsInstanceRamRoleSet()
                self.instance_ram_role_set.append(temp_model.from_map(k))
        else:
            self.instance_ram_role_set = None
        return self


class AttachInstanceRamRoleRequest(TeaModel):
    def __init__(self, region_id=None, ram_role_name=None, instance_ids=None):
        self.region_id = region_id      # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.instance_ids = instance_ids  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['RamRoleName'] = self.ram_role_name
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.ram_role_name = map.get('RamRoleName')
        self.instance_ids = map.get('InstanceIds')
        return self


class AttachInstanceRamRoleResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, ram_role_name=None,
                 attach_instance_ram_role_results=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.fail_count = fail_count    # type: int
        self.ram_role_name = ram_role_name  # type: str
        self.attach_instance_ram_role_results = attach_instance_ram_role_results  # type: AttachInstanceRamRoleResponseAttachInstanceRamRoleResults

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.ram_role_name, 'ram_role_name')
        self.validate_required(self.attach_instance_ram_role_results, 'attach_instance_ram_role_results')
        if self.attach_instance_ram_role_results:
            self.attach_instance_ram_role_results.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['FailCount'] = self.fail_count
        result['RamRoleName'] = self.ram_role_name
        if self.attach_instance_ram_role_results is not None:
            result['AttachInstanceRamRoleResults'] = self.attach_instance_ram_role_results.to_map()
        else:
            result['AttachInstanceRamRoleResults'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.fail_count = map.get('FailCount')
        self.ram_role_name = map.get('RamRoleName')
        if map.get('AttachInstanceRamRoleResults') is not None:
            temp_model = AttachInstanceRamRoleResponseAttachInstanceRamRoleResults()
            self.attach_instance_ram_role_results = temp_model.from_map(map['AttachInstanceRamRoleResults'])
        else:
            self.attach_instance_ram_role_results = None
        return self


class AttachInstanceRamRoleResponseAttachInstanceRamRoleResultsAttachInstanceRamRoleResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.success = success          # type: bool
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Success'] = self.success
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.success = map.get('Success')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class AttachInstanceRamRoleResponseAttachInstanceRamRoleResults(TeaModel):
    def __init__(self, attach_instance_ram_role_result=None):
        self.attach_instance_ram_role_result = attach_instance_ram_role_result  # type: List[AttachInstanceRamRoleResponseAttachInstanceRamRoleResultsAttachInstanceRamRoleResult]

    def validate(self):
        self.validate_required(self.attach_instance_ram_role_result, 'attach_instance_ram_role_result')
        if self.attach_instance_ram_role_result:
            for k in self.attach_instance_ram_role_result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AttachInstanceRamRoleResult'] = []
        if self.attach_instance_ram_role_result is not None:
            for k in self.attach_instance_ram_role_result:
                result['AttachInstanceRamRoleResult'].append(k.to_map() if k else None)
        else:
            result['AttachInstanceRamRoleResult'] = None
        return result

    def from_map(self, map={}):
        self.attach_instance_ram_role_result = []
        if map.get('AttachInstanceRamRoleResult') is not None:
            for k in map.get('AttachInstanceRamRoleResult'):
                temp_model = AttachInstanceRamRoleResponseAttachInstanceRamRoleResultsAttachInstanceRamRoleResult()
                self.attach_instance_ram_role_result.append(temp_model.from_map(k))
        else:
            self.attach_instance_ram_role_result = None
        return self


class DescribeSnapshotPackageRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_id=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.region_id = map.get('RegionId')
        return self


class DescribeSnapshotPackageResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, snapshot_packages=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.snapshot_packages = snapshot_packages  # type: DescribeSnapshotPackageResponseSnapshotPackages

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.snapshot_packages, 'snapshot_packages')
        if self.snapshot_packages:
            self.snapshot_packages.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.snapshot_packages is not None:
            result['SnapshotPackages'] = self.snapshot_packages.to_map()
        else:
            result['SnapshotPackages'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('SnapshotPackages') is not None:
            temp_model = DescribeSnapshotPackageResponseSnapshotPackages()
            self.snapshot_packages = temp_model.from_map(map['SnapshotPackages'])
        else:
            self.snapshot_packages = None
        return self


class DescribeSnapshotPackageResponseSnapshotPackagesSnapshotPackage(TeaModel):
    def __init__(self, start_time=None, end_time=None, init_capacity=None, display_name=None):
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.init_capacity = init_capacity  # type: int
        self.display_name = display_name  # type: str

    def validate(self):
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')
        self.validate_required(self.init_capacity, 'init_capacity')
        self.validate_required(self.display_name, 'display_name')

    def to_map(self):
        result = {}
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['InitCapacity'] = self.init_capacity
        result['DisplayName'] = self.display_name
        return result

    def from_map(self, map={}):
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.init_capacity = map.get('InitCapacity')
        self.display_name = map.get('DisplayName')
        return self


class DescribeSnapshotPackageResponseSnapshotPackages(TeaModel):
    def __init__(self, snapshot_package=None):
        self.snapshot_package = snapshot_package  # type: List[DescribeSnapshotPackageResponseSnapshotPackagesSnapshotPackage]

    def validate(self):
        self.validate_required(self.snapshot_package, 'snapshot_package')
        if self.snapshot_package:
            for k in self.snapshot_package:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SnapshotPackage'] = []
        if self.snapshot_package is not None:
            for k in self.snapshot_package:
                result['SnapshotPackage'].append(k.to_map() if k else None)
        else:
            result['SnapshotPackage'] = None
        return result

    def from_map(self, map={}):
        self.snapshot_package = []
        if map.get('SnapshotPackage') is not None:
            for k in map.get('SnapshotPackage'):
                temp_model = DescribeSnapshotPackageResponseSnapshotPackagesSnapshotPackage()
                self.snapshot_package.append(temp_model.from_map(k))
        else:
            self.snapshot_package = None
        return self


class ModifySecurityGroupRuleRequest(TeaModel):
    def __init__(self, region_id=None, security_group_id=None, ip_protocol=None, port_range=None,
                 source_group_id=None, source_group_owner_id=None, source_group_owner_account=None, source_cidr_ip=None,
                 ipv_6source_cidr_ip=None, source_port_range=None, dest_cidr_ip=None, ipv_6dest_cidr_ip=None, policy=None,
                 priority=None, nic_type=None, client_token=None, description=None):
        self.region_id = region_id      # type: str
        self.security_group_id = security_group_id  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.port_range = port_range    # type: str
        self.source_group_id = source_group_id  # type: str
        self.source_group_owner_id = source_group_owner_id  # type: int
        self.source_group_owner_account = source_group_owner_account  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.source_port_range = source_port_range  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.policy = policy            # type: str
        self.priority = priority        # type: str
        self.nic_type = nic_type        # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.security_group_id, 'security_group_id')
        self.validate_required(self.ip_protocol, 'ip_protocol')
        self.validate_required(self.port_range, 'port_range')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['SecurityGroupId'] = self.security_group_id
        result['IpProtocol'] = self.ip_protocol
        result['PortRange'] = self.port_range
        result['SourceGroupId'] = self.source_group_id
        result['SourceGroupOwnerId'] = self.source_group_owner_id
        result['SourceGroupOwnerAccount'] = self.source_group_owner_account
        result['SourceCidrIp'] = self.source_cidr_ip
        result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        result['SourcePortRange'] = self.source_port_range
        result['DestCidrIp'] = self.dest_cidr_ip
        result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        result['Policy'] = self.policy
        result['Priority'] = self.priority
        result['NicType'] = self.nic_type
        result['ClientToken'] = self.client_token
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.security_group_id = map.get('SecurityGroupId')
        self.ip_protocol = map.get('IpProtocol')
        self.port_range = map.get('PortRange')
        self.source_group_id = map.get('SourceGroupId')
        self.source_group_owner_id = map.get('SourceGroupOwnerId')
        self.source_group_owner_account = map.get('SourceGroupOwnerAccount')
        self.source_cidr_ip = map.get('SourceCidrIp')
        self.ipv_6source_cidr_ip = map.get('Ipv6SourceCidrIp')
        self.source_port_range = map.get('SourcePortRange')
        self.dest_cidr_ip = map.get('DestCidrIp')
        self.ipv_6dest_cidr_ip = map.get('Ipv6DestCidrIp')
        self.policy = map.get('Policy')
        self.priority = map.get('Priority')
        self.nic_type = map.get('NicType')
        self.client_token = map.get('ClientToken')
        self.description = map.get('Description')
        return self


class ModifySecurityGroupRuleResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeSnapshotMonitorDataRequest(TeaModel):
    def __init__(self, region_id=None, start_time=None, end_time=None, period=None, category=None):
        self.region_id = region_id      # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.period = period            # type: int
        self.category = category        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['Period'] = self.period
        result['Category'] = self.category
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.period = map.get('Period')
        self.category = map.get('Category')
        return self


class DescribeSnapshotMonitorDataResponse(TeaModel):
    def __init__(self, request_id=None, monitor_data=None):
        self.request_id = request_id    # type: str
        self.monitor_data = monitor_data  # type: DescribeSnapshotMonitorDataResponseMonitorData

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.monitor_data, 'monitor_data')
        if self.monitor_data:
            self.monitor_data.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.monitor_data is not None:
            result['MonitorData'] = self.monitor_data.to_map()
        else:
            result['MonitorData'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('MonitorData') is not None:
            temp_model = DescribeSnapshotMonitorDataResponseMonitorData()
            self.monitor_data = temp_model.from_map(map['MonitorData'])
        else:
            self.monitor_data = None
        return self


class DescribeSnapshotMonitorDataResponseMonitorDataDataPoint(TeaModel):
    def __init__(self, time_stamp=None, size=None):
        self.time_stamp = time_stamp    # type: str
        self.size = size                # type: int

    def validate(self):
        self.validate_required(self.time_stamp, 'time_stamp')
        self.validate_required(self.size, 'size')

    def to_map(self):
        result = {}
        result['TimeStamp'] = self.time_stamp
        result['Size'] = self.size
        return result

    def from_map(self, map={}):
        self.time_stamp = map.get('TimeStamp')
        self.size = map.get('Size')
        return self


class DescribeSnapshotMonitorDataResponseMonitorData(TeaModel):
    def __init__(self, data_point=None):
        self.data_point = data_point    # type: List[DescribeSnapshotMonitorDataResponseMonitorDataDataPoint]

    def validate(self):
        self.validate_required(self.data_point, 'data_point')
        if self.data_point:
            for k in self.data_point:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DataPoint'] = []
        if self.data_point is not None:
            for k in self.data_point:
                result['DataPoint'].append(k.to_map() if k else None)
        else:
            result['DataPoint'] = None
        return result

    def from_map(self, map={}):
        self.data_point = []
        if map.get('DataPoint') is not None:
            for k in map.get('DataPoint'):
                temp_model = DescribeSnapshotMonitorDataResponseMonitorDataDataPoint()
                self.data_point.append(temp_model.from_map(k))
        else:
            self.data_point = None
        return self


class DescribeRenewalPriceRequest(TeaModel):
    def __init__(self, region_id=None, resource_type=None, resource_id=None, period=None, price_unit=None):
        self.region_id = region_id      # type: str
        self.resource_type = resource_type  # type: str
        self.resource_id = resource_id  # type: str
        self.period = period            # type: int
        self.price_unit = price_unit    # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.resource_id, 'resource_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceType'] = self.resource_type
        result['ResourceId'] = self.resource_id
        result['Period'] = self.period
        result['PriceUnit'] = self.price_unit
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_type = map.get('ResourceType')
        self.resource_id = map.get('ResourceId')
        self.period = map.get('Period')
        self.price_unit = map.get('PriceUnit')
        return self


class DescribeRenewalPriceResponse(TeaModel):
    def __init__(self, request_id=None, price_info=None):
        self.request_id = request_id    # type: str
        self.price_info = price_info    # type: DescribeRenewalPriceResponsePriceInfo

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.price_info, 'price_info')
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        else:
            result['PriceInfo'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('PriceInfo') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfo()
            self.price_info = temp_model.from_map(map['PriceInfo'])
        else:
            self.price_info = None
        return self


class DescribeRenewalPriceResponsePriceInfoRulesRule(TeaModel):
    def __init__(self, rule_id=None, description=None):
        self.rule_id = rule_id          # type: int
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RuleId'] = self.rule_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.rule_id = map.get('RuleId')
        self.description = map.get('Description')
        return self


class DescribeRenewalPriceResponsePriceInfoRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule                # type: List[DescribeRenewalPriceResponsePriceInfoRulesRule]

    def validate(self):
        self.validate_required(self.rule, 'rule')
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        else:
            result['Rule'] = None
        return result

    def from_map(self, map={}):
        self.rule = []
        if map.get('Rule') is not None:
            for k in map.get('Rule'):
                temp_model = DescribeRenewalPriceResponsePriceInfoRulesRule()
                self.rule.append(temp_model.from_map(k))
        else:
            self.rule = None
        return self


class DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule(TeaModel):
    def __init__(self, rule_id=None, description=None):
        self.rule_id = rule_id          # type: int
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RuleId'] = self.rule_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.rule_id = map.get('RuleId')
        self.description = map.get('Description')
        return self


class DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule                # type: List[DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule]

    def validate(self):
        self.validate_required(self.rule, 'rule')
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        else:
            result['Rule'] = None
        return result

    def from_map(self, map={}):
        self.rule = []
        if map.get('Rule') is not None:
            for k in map.get('Rule'):
                temp_model = DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule()
                self.rule.append(temp_model.from_map(k))
        else:
            self.rule = None
        return self


class DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModel(TeaModel):
    def __init__(self, resource=None, original_price=None, discount_price=None, trade_price=None, sub_rules=None):
        self.resource = resource        # type: str
        self.original_price = original_price  # type: float
        self.discount_price = discount_price  # type: float
        self.trade_price = trade_price  # type: float
        self.sub_rules = sub_rules      # type: DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules

    def validate(self):
        self.validate_required(self.resource, 'resource')
        self.validate_required(self.original_price, 'original_price')
        self.validate_required(self.discount_price, 'discount_price')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.sub_rules, 'sub_rules')
        if self.sub_rules:
            self.sub_rules.validate()

    def to_map(self):
        result = {}
        result['Resource'] = self.resource
        result['OriginalPrice'] = self.original_price
        result['DiscountPrice'] = self.discount_price
        result['TradePrice'] = self.trade_price
        if self.sub_rules is not None:
            result['SubRules'] = self.sub_rules.to_map()
        else:
            result['SubRules'] = None
        return result

    def from_map(self, map={}):
        self.resource = map.get('Resource')
        self.original_price = map.get('OriginalPrice')
        self.discount_price = map.get('DiscountPrice')
        self.trade_price = map.get('TradePrice')
        if map.get('SubRules') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules()
            self.sub_rules = temp_model.from_map(map['SubRules'])
        else:
            self.sub_rules = None
        return self


class DescribeRenewalPriceResponsePriceInfoPriceDetailInfos(TeaModel):
    def __init__(self, resource_price_model=None):
        self.resource_price_model = resource_price_model  # type: List[DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModel]

    def validate(self):
        self.validate_required(self.resource_price_model, 'resource_price_model')
        if self.resource_price_model:
            for k in self.resource_price_model:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ResourcePriceModel'] = []
        if self.resource_price_model is not None:
            for k in self.resource_price_model:
                result['ResourcePriceModel'].append(k.to_map() if k else None)
        else:
            result['ResourcePriceModel'] = None
        return result

    def from_map(self, map={}):
        self.resource_price_model = []
        if map.get('ResourcePriceModel') is not None:
            for k in map.get('ResourcePriceModel'):
                temp_model = DescribeRenewalPriceResponsePriceInfoPriceDetailInfosResourcePriceModel()
                self.resource_price_model.append(temp_model.from_map(k))
        else:
            self.resource_price_model = None
        return self


class DescribeRenewalPriceResponsePriceInfoPrice(TeaModel):
    def __init__(self, original_price=None, discount_price=None, trade_price=None, currency=None, detail_infos=None):
        self.original_price = original_price  # type: float
        self.discount_price = discount_price  # type: float
        self.trade_price = trade_price  # type: float
        self.currency = currency        # type: str
        self.detail_infos = detail_infos  # type: DescribeRenewalPriceResponsePriceInfoPriceDetailInfos

    def validate(self):
        self.validate_required(self.original_price, 'original_price')
        self.validate_required(self.discount_price, 'discount_price')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.detail_infos, 'detail_infos')
        if self.detail_infos:
            self.detail_infos.validate()

    def to_map(self):
        result = {}
        result['OriginalPrice'] = self.original_price
        result['DiscountPrice'] = self.discount_price
        result['TradePrice'] = self.trade_price
        result['Currency'] = self.currency
        if self.detail_infos is not None:
            result['DetailInfos'] = self.detail_infos.to_map()
        else:
            result['DetailInfos'] = None
        return result

    def from_map(self, map={}):
        self.original_price = map.get('OriginalPrice')
        self.discount_price = map.get('DiscountPrice')
        self.trade_price = map.get('TradePrice')
        self.currency = map.get('Currency')
        if map.get('DetailInfos') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfoPriceDetailInfos()
            self.detail_infos = temp_model.from_map(map['DetailInfos'])
        else:
            self.detail_infos = None
        return self


class DescribeRenewalPriceResponsePriceInfo(TeaModel):
    def __init__(self, rules=None, price=None):
        self.rules = rules              # type: DescribeRenewalPriceResponsePriceInfoRules
        self.price = price              # type: DescribeRenewalPriceResponsePriceInfoPrice

    def validate(self):
        self.validate_required(self.rules, 'rules')
        if self.rules:
            self.rules.validate()
        self.validate_required(self.price, 'price')
        if self.price:
            self.price.validate()

    def to_map(self):
        result = {}
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        else:
            result['Rules'] = None
        if self.price is not None:
            result['Price'] = self.price.to_map()
        else:
            result['Price'] = None
        return result

    def from_map(self, map={}):
        if map.get('Rules') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfoRules()
            self.rules = temp_model.from_map(map['Rules'])
        else:
            self.rules = None
        if map.get('Price') is not None:
            temp_model = DescribeRenewalPriceResponsePriceInfoPrice()
            self.price = temp_model.from_map(map['Price'])
        else:
            self.price = None
        return self


class DescribePriceRequest(TeaModel):
    def __init__(self, region_id=None, resource_type=None, image_id=None, instance_type=None, io_optimized=None,
                 instance_network_type=None, internet_charge_type=None, internet_max_bandwidth_out=None, system_disk=None,
                 data_disk=None, period=None, price_unit=None, amount=None, offering_type=None, instance_amount=None,
                 scope=None, platform=None, capacity=None, assurance_times=None, instance_cpu_core_count=None,
                 instance_type_list=None, isp=None):
        self.region_id = region_id      # type: str
        self.resource_type = resource_type  # type: str
        self.image_id = image_id        # type: str
        self.instance_type = instance_type  # type: str
        self.io_optimized = io_optimized  # type: str
        self.instance_network_type = instance_network_type  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.system_disk = system_disk  # type: DescribePriceRequestSystemDisk
        self.data_disk = data_disk      # type: List[DescribePriceRequestDataDisk]
        self.period = period            # type: int
        self.price_unit = price_unit    # type: str
        self.amount = amount            # type: int
        self.offering_type = offering_type  # type: str
        self.instance_amount = instance_amount  # type: int
        self.scope = scope              # type: str
        self.platform = platform        # type: str
        self.capacity = capacity        # type: int
        self.assurance_times = assurance_times  # type: str
        self.instance_cpu_core_count = instance_cpu_core_count  # type: int
        self.instance_type_list = instance_type_list  # type: List[str]
        self.isp = isp                  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ResourceType'] = self.resource_type
        result['ImageId'] = self.image_id
        result['InstanceType'] = self.instance_type
        result['IoOptimized'] = self.io_optimized
        result['InstanceNetworkType'] = self.instance_network_type
        result['InternetChargeType'] = self.internet_charge_type
        result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        else:
            result['SystemDisk'] = None
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        else:
            result['DataDisk'] = None
        result['Period'] = self.period
        result['PriceUnit'] = self.price_unit
        result['Amount'] = self.amount
        result['OfferingType'] = self.offering_type
        result['InstanceAmount'] = self.instance_amount
        result['Scope'] = self.scope
        result['Platform'] = self.platform
        result['Capacity'] = self.capacity
        result['AssuranceTimes'] = self.assurance_times
        result['InstanceCpuCoreCount'] = self.instance_cpu_core_count
        result['InstanceTypeList'] = self.instance_type_list
        result['Isp'] = self.isp
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.resource_type = map.get('ResourceType')
        self.image_id = map.get('ImageId')
        self.instance_type = map.get('InstanceType')
        self.io_optimized = map.get('IoOptimized')
        self.instance_network_type = map.get('InstanceNetworkType')
        self.internet_charge_type = map.get('InternetChargeType')
        self.internet_max_bandwidth_out = map.get('InternetMaxBandwidthOut')
        if map.get('SystemDisk') is not None:
            temp_model = DescribePriceRequestSystemDisk()
            self.system_disk = temp_model.from_map(map['SystemDisk'])
        else:
            self.system_disk = None
        self.data_disk = []
        if map.get('DataDisk') is not None:
            for k in map.get('DataDisk'):
                temp_model = DescribePriceRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        else:
            self.data_disk = None
        self.period = map.get('Period')
        self.price_unit = map.get('PriceUnit')
        self.amount = map.get('Amount')
        self.offering_type = map.get('OfferingType')
        self.instance_amount = map.get('InstanceAmount')
        self.scope = map.get('Scope')
        self.platform = map.get('Platform')
        self.capacity = map.get('Capacity')
        self.assurance_times = map.get('AssuranceTimes')
        self.instance_cpu_core_count = map.get('InstanceCpuCoreCount')
        self.instance_type_list = map.get('InstanceTypeList')
        self.isp = map.get('Isp')
        return self


class DescribePriceRequestSystemDisk(TeaModel):
    def __init__(self, category=None, size=None, performance_level=None):
        self.category = category        # type: str
        self.size = size                # type: int
        self.performance_level = performance_level  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Category'] = self.category
        result['Size'] = self.size
        result['PerformanceLevel'] = self.performance_level
        return result

    def from_map(self, map={}):
        self.category = map.get('Category')
        self.size = map.get('Size')
        self.performance_level = map.get('PerformanceLevel')
        return self


class DescribePriceRequestDataDisk(TeaModel):
    def __init__(self, size=None, category=None, performance_level=None):
        self.size = size                # type: int
        self.category = category        # type: str
        self.performance_level = performance_level  # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Size'] = self.size
        result['Category'] = self.category
        result['PerformanceLevel'] = self.performance_level
        return result

    def from_map(self, map={}):
        self.size = map.get('Size')
        self.category = map.get('Category')
        self.performance_level = map.get('PerformanceLevel')
        return self


class DescribePriceResponse(TeaModel):
    def __init__(self, request_id=None, price_info=None):
        self.request_id = request_id    # type: str
        self.price_info = price_info    # type: DescribePriceResponsePriceInfo

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.price_info, 'price_info')
        if self.price_info:
            self.price_info.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.price_info is not None:
            result['PriceInfo'] = self.price_info.to_map()
        else:
            result['PriceInfo'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('PriceInfo') is not None:
            temp_model = DescribePriceResponsePriceInfo()
            self.price_info = temp_model.from_map(map['PriceInfo'])
        else:
            self.price_info = None
        return self


class DescribePriceResponsePriceInfoRulesRule(TeaModel):
    def __init__(self, rule_id=None, description=None):
        self.rule_id = rule_id          # type: int
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RuleId'] = self.rule_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.rule_id = map.get('RuleId')
        self.description = map.get('Description')
        return self


class DescribePriceResponsePriceInfoRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule                # type: List[DescribePriceResponsePriceInfoRulesRule]

    def validate(self):
        self.validate_required(self.rule, 'rule')
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        else:
            result['Rule'] = None
        return result

    def from_map(self, map={}):
        self.rule = []
        if map.get('Rule') is not None:
            for k in map.get('Rule'):
                temp_model = DescribePriceResponsePriceInfoRulesRule()
                self.rule.append(temp_model.from_map(k))
        else:
            self.rule = None
        return self


class DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule(TeaModel):
    def __init__(self, rule_id=None, description=None):
        self.rule_id = rule_id          # type: int
        self.description = description  # type: str

    def validate(self):
        self.validate_required(self.rule_id, 'rule_id')
        self.validate_required(self.description, 'description')

    def to_map(self):
        result = {}
        result['RuleId'] = self.rule_id
        result['Description'] = self.description
        return result

    def from_map(self, map={}):
        self.rule_id = map.get('RuleId')
        self.description = map.get('Description')
        return self


class DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules(TeaModel):
    def __init__(self, rule=None):
        self.rule = rule                # type: List[DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule]

    def validate(self):
        self.validate_required(self.rule, 'rule')
        if self.rule:
            for k in self.rule:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Rule'] = []
        if self.rule is not None:
            for k in self.rule:
                result['Rule'].append(k.to_map() if k else None)
        else:
            result['Rule'] = None
        return result

    def from_map(self, map={}):
        self.rule = []
        if map.get('Rule') is not None:
            for k in map.get('Rule'):
                temp_model = DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRulesRule()
                self.rule.append(temp_model.from_map(k))
        else:
            self.rule = None
        return self


class DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModel(TeaModel):
    def __init__(self, resource=None, original_price=None, discount_price=None, trade_price=None, sub_rules=None):
        self.resource = resource        # type: str
        self.original_price = original_price  # type: float
        self.discount_price = discount_price  # type: float
        self.trade_price = trade_price  # type: float
        self.sub_rules = sub_rules      # type: DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules

    def validate(self):
        self.validate_required(self.resource, 'resource')
        self.validate_required(self.original_price, 'original_price')
        self.validate_required(self.discount_price, 'discount_price')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.sub_rules, 'sub_rules')
        if self.sub_rules:
            self.sub_rules.validate()

    def to_map(self):
        result = {}
        result['Resource'] = self.resource
        result['OriginalPrice'] = self.original_price
        result['DiscountPrice'] = self.discount_price
        result['TradePrice'] = self.trade_price
        if self.sub_rules is not None:
            result['SubRules'] = self.sub_rules.to_map()
        else:
            result['SubRules'] = None
        return result

    def from_map(self, map={}):
        self.resource = map.get('Resource')
        self.original_price = map.get('OriginalPrice')
        self.discount_price = map.get('DiscountPrice')
        self.trade_price = map.get('TradePrice')
        if map.get('SubRules') is not None:
            temp_model = DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModelSubRules()
            self.sub_rules = temp_model.from_map(map['SubRules'])
        else:
            self.sub_rules = None
        return self


class DescribePriceResponsePriceInfoPriceDetailInfos(TeaModel):
    def __init__(self, resource_price_model=None):
        self.resource_price_model = resource_price_model  # type: List[DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModel]

    def validate(self):
        self.validate_required(self.resource_price_model, 'resource_price_model')
        if self.resource_price_model:
            for k in self.resource_price_model:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ResourcePriceModel'] = []
        if self.resource_price_model is not None:
            for k in self.resource_price_model:
                result['ResourcePriceModel'].append(k.to_map() if k else None)
        else:
            result['ResourcePriceModel'] = None
        return result

    def from_map(self, map={}):
        self.resource_price_model = []
        if map.get('ResourcePriceModel') is not None:
            for k in map.get('ResourcePriceModel'):
                temp_model = DescribePriceResponsePriceInfoPriceDetailInfosResourcePriceModel()
                self.resource_price_model.append(temp_model.from_map(k))
        else:
            self.resource_price_model = None
        return self


class DescribePriceResponsePriceInfoPrice(TeaModel):
    def __init__(self, original_price=None, discount_price=None, trade_price=None,
                 reserved_instance_hour_price=None, currency=None, detail_infos=None):
        self.original_price = original_price  # type: float
        self.discount_price = discount_price  # type: float
        self.trade_price = trade_price  # type: float
        self.reserved_instance_hour_price = reserved_instance_hour_price  # type: float
        self.currency = currency        # type: str
        self.detail_infos = detail_infos  # type: DescribePriceResponsePriceInfoPriceDetailInfos

    def validate(self):
        self.validate_required(self.original_price, 'original_price')
        self.validate_required(self.discount_price, 'discount_price')
        self.validate_required(self.trade_price, 'trade_price')
        self.validate_required(self.reserved_instance_hour_price, 'reserved_instance_hour_price')
        self.validate_required(self.currency, 'currency')
        self.validate_required(self.detail_infos, 'detail_infos')
        if self.detail_infos:
            self.detail_infos.validate()

    def to_map(self):
        result = {}
        result['OriginalPrice'] = self.original_price
        result['DiscountPrice'] = self.discount_price
        result['TradePrice'] = self.trade_price
        result['ReservedInstanceHourPrice'] = self.reserved_instance_hour_price
        result['Currency'] = self.currency
        if self.detail_infos is not None:
            result['DetailInfos'] = self.detail_infos.to_map()
        else:
            result['DetailInfos'] = None
        return result

    def from_map(self, map={}):
        self.original_price = map.get('OriginalPrice')
        self.discount_price = map.get('DiscountPrice')
        self.trade_price = map.get('TradePrice')
        self.reserved_instance_hour_price = map.get('ReservedInstanceHourPrice')
        self.currency = map.get('Currency')
        if map.get('DetailInfos') is not None:
            temp_model = DescribePriceResponsePriceInfoPriceDetailInfos()
            self.detail_infos = temp_model.from_map(map['DetailInfos'])
        else:
            self.detail_infos = None
        return self


class DescribePriceResponsePriceInfo(TeaModel):
    def __init__(self, rules=None, price=None):
        self.rules = rules              # type: DescribePriceResponsePriceInfoRules
        self.price = price              # type: DescribePriceResponsePriceInfoPrice

    def validate(self):
        self.validate_required(self.rules, 'rules')
        if self.rules:
            self.rules.validate()
        self.validate_required(self.price, 'price')
        if self.price:
            self.price.validate()

    def to_map(self):
        result = {}
        if self.rules is not None:
            result['Rules'] = self.rules.to_map()
        else:
            result['Rules'] = None
        if self.price is not None:
            result['Price'] = self.price.to_map()
        else:
            result['Price'] = None
        return result

    def from_map(self, map={}):
        if map.get('Rules') is not None:
            temp_model = DescribePriceResponsePriceInfoRules()
            self.rules = temp_model.from_map(map['Rules'])
        else:
            self.rules = None
        if map.get('Price') is not None:
            temp_model = DescribePriceResponsePriceInfoPrice()
            self.price = temp_model.from_map(map['Price'])
        else:
            self.price = None
        return self


class ModifyDeploymentSetAttributeRequest(TeaModel):
    def __init__(self, deployment_set_id=None, description=None, deployment_set_name=None, region_id=None):
        self.deployment_set_id = deployment_set_id  # type: str
        self.description = description  # type: str
        self.deployment_set_name = deployment_set_name  # type: str
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.deployment_set_id, 'deployment_set_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['DeploymentSetId'] = self.deployment_set_id
        result['Description'] = self.description
        result['DeploymentSetName'] = self.deployment_set_name
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.deployment_set_id = map.get('DeploymentSetId')
        self.description = map.get('Description')
        self.deployment_set_name = map.get('DeploymentSetName')
        self.region_id = map.get('RegionId')
        return self


class ModifyDeploymentSetAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeDeploymentSetsRequest(TeaModel):
    def __init__(self, region_id=None, page_number=None, page_size=None, deployment_set_ids=None, network_type=None,
                 strategy=None, deployment_set_name=None, granularity=None, domain=None):
        self.region_id = region_id      # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.deployment_set_ids = deployment_set_ids  # type: str
        self.network_type = network_type  # type: str
        self.strategy = strategy        # type: str
        self.deployment_set_name = deployment_set_name  # type: str
        self.granularity = granularity  # type: str
        self.domain = domain            # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['DeploymentSetIds'] = self.deployment_set_ids
        result['NetworkType'] = self.network_type
        result['Strategy'] = self.strategy
        result['DeploymentSetName'] = self.deployment_set_name
        result['Granularity'] = self.granularity
        result['Domain'] = self.domain
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.deployment_set_ids = map.get('DeploymentSetIds')
        self.network_type = map.get('NetworkType')
        self.strategy = map.get('Strategy')
        self.deployment_set_name = map.get('DeploymentSetName')
        self.granularity = map.get('Granularity')
        self.domain = map.get('Domain')
        return self


class DescribeDeploymentSetsResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, total_count=None, page_number=None, page_size=None,
                 deployment_sets=None):
        self.request_id = request_id    # type: str
        self.region_id = region_id      # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.deployment_sets = deployment_sets  # type: DescribeDeploymentSetsResponseDeploymentSets

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.deployment_sets, 'deployment_sets')
        if self.deployment_sets:
            self.deployment_sets.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RegionId'] = self.region_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.deployment_sets is not None:
            result['DeploymentSets'] = self.deployment_sets.to_map()
        else:
            result['DeploymentSets'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.region_id = map.get('RegionId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('DeploymentSets') is not None:
            temp_model = DescribeDeploymentSetsResponseDeploymentSets()
            self.deployment_sets = temp_model.from_map(map['DeploymentSets'])
        else:
            self.deployment_sets = None
        return self


class DescribeDeploymentSetsResponseDeploymentSetsDeploymentSetInstanceIds(TeaModel):
    def __init__(self, instance_id=None):
        # InstanceId
        self.instance_id = instance_id  # type: List[str]

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        return self


class DescribeDeploymentSetsResponseDeploymentSetsDeploymentSet(TeaModel):
    def __init__(self, deployment_set_id=None, deployment_set_description=None, deployment_set_name=None,
                 strategy=None, deployment_strategy=None, domain=None, granularity=None, group_count=None,
                 instance_amount=None, creation_time=None, instance_ids=None):
        self.deployment_set_id = deployment_set_id  # type: str
        self.deployment_set_description = deployment_set_description  # type: str
        self.deployment_set_name = deployment_set_name  # type: str
        self.strategy = strategy        # type: str
        self.deployment_strategy = deployment_strategy  # type: str
        self.domain = domain            # type: str
        self.granularity = granularity  # type: str
        self.group_count = group_count  # type: int
        self.instance_amount = instance_amount  # type: int
        self.creation_time = creation_time  # type: str
        self.instance_ids = instance_ids  # type: DescribeDeploymentSetsResponseDeploymentSetsDeploymentSetInstanceIds

    def validate(self):
        self.validate_required(self.deployment_set_id, 'deployment_set_id')
        self.validate_required(self.deployment_set_description, 'deployment_set_description')
        self.validate_required(self.deployment_set_name, 'deployment_set_name')
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.deployment_strategy, 'deployment_strategy')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.granularity, 'granularity')
        self.validate_required(self.group_count, 'group_count')
        self.validate_required(self.instance_amount, 'instance_amount')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.instance_ids, 'instance_ids')
        if self.instance_ids:
            self.instance_ids.validate()

    def to_map(self):
        result = {}
        result['DeploymentSetId'] = self.deployment_set_id
        result['DeploymentSetDescription'] = self.deployment_set_description
        result['DeploymentSetName'] = self.deployment_set_name
        result['Strategy'] = self.strategy
        result['DeploymentStrategy'] = self.deployment_strategy
        result['Domain'] = self.domain
        result['Granularity'] = self.granularity
        result['GroupCount'] = self.group_count
        result['InstanceAmount'] = self.instance_amount
        result['CreationTime'] = self.creation_time
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids.to_map()
        else:
            result['InstanceIds'] = None
        return result

    def from_map(self, map={}):
        self.deployment_set_id = map.get('DeploymentSetId')
        self.deployment_set_description = map.get('DeploymentSetDescription')
        self.deployment_set_name = map.get('DeploymentSetName')
        self.strategy = map.get('Strategy')
        self.deployment_strategy = map.get('DeploymentStrategy')
        self.domain = map.get('Domain')
        self.granularity = map.get('Granularity')
        self.group_count = map.get('GroupCount')
        self.instance_amount = map.get('InstanceAmount')
        self.creation_time = map.get('CreationTime')
        if map.get('InstanceIds') is not None:
            temp_model = DescribeDeploymentSetsResponseDeploymentSetsDeploymentSetInstanceIds()
            self.instance_ids = temp_model.from_map(map['InstanceIds'])
        else:
            self.instance_ids = None
        return self


class DescribeDeploymentSetsResponseDeploymentSets(TeaModel):
    def __init__(self, deployment_set=None):
        self.deployment_set = deployment_set  # type: List[DescribeDeploymentSetsResponseDeploymentSetsDeploymentSet]

    def validate(self):
        self.validate_required(self.deployment_set, 'deployment_set')
        if self.deployment_set:
            for k in self.deployment_set:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['DeploymentSet'] = []
        if self.deployment_set is not None:
            for k in self.deployment_set:
                result['DeploymentSet'].append(k.to_map() if k else None)
        else:
            result['DeploymentSet'] = None
        return result

    def from_map(self, map={}):
        self.deployment_set = []
        if map.get('DeploymentSet') is not None:
            for k in map.get('DeploymentSet'):
                temp_model = DescribeDeploymentSetsResponseDeploymentSetsDeploymentSet()
                self.deployment_set.append(temp_model.from_map(k))
        else:
            self.deployment_set = None
        return self


class DeleteDeploymentSetRequest(TeaModel):
    def __init__(self, region_id=None, deployment_set_id=None):
        self.region_id = region_id      # type: str
        self.deployment_set_id = deployment_set_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.deployment_set_id, 'deployment_set_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['DeploymentSetId'] = self.deployment_set_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.deployment_set_id = map.get('DeploymentSetId')
        return self


class DeleteDeploymentSetResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateDeploymentSetRequest(TeaModel):
    def __init__(self, region_id=None, on_unable_to_redeploy_failed_instance=None, description=None,
                 client_token=None, deployment_set_name=None, domain=None, granularity=None, strategy=None, group_count=None):
        self.region_id = region_id      # type: str
        self.on_unable_to_redeploy_failed_instance = on_unable_to_redeploy_failed_instance  # type: str
        self.description = description  # type: str
        self.client_token = client_token  # type: str
        self.deployment_set_name = deployment_set_name  # type: str
        self.domain = domain            # type: str
        self.granularity = granularity  # type: str
        self.strategy = strategy        # type: str
        self.group_count = group_count  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['OnUnableToRedeployFailedInstance'] = self.on_unable_to_redeploy_failed_instance
        result['Description'] = self.description
        result['ClientToken'] = self.client_token
        result['DeploymentSetName'] = self.deployment_set_name
        result['Domain'] = self.domain
        result['Granularity'] = self.granularity
        result['Strategy'] = self.strategy
        result['GroupCount'] = self.group_count
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.on_unable_to_redeploy_failed_instance = map.get('OnUnableToRedeployFailedInstance')
        self.description = map.get('Description')
        self.client_token = map.get('ClientToken')
        self.deployment_set_name = map.get('DeploymentSetName')
        self.domain = map.get('Domain')
        self.granularity = map.get('Granularity')
        self.strategy = map.get('Strategy')
        self.group_count = map.get('GroupCount')
        return self


class CreateDeploymentSetResponse(TeaModel):
    def __init__(self, request_id=None, deployment_set_id=None):
        self.request_id = request_id    # type: str
        self.deployment_set_id = deployment_set_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.deployment_set_id, 'deployment_set_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['DeploymentSetId'] = self.deployment_set_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.deployment_set_id = map.get('DeploymentSetId')
        return self


class ImportKeyPairRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, public_key_body=None, tag=None, resource_group_id=None):
        self.region_id = region_id      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.public_key_body = public_key_body  # type: str
        self.tag = tag                  # type: List[ImportKeyPairRequestTag]
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.public_key_body, 'public_key_body')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['PublicKeyBody'] = self.public_key_body
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.public_key_body = map.get('PublicKeyBody')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = ImportKeyPairRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class ImportKeyPairRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class ImportKeyPairResponse(TeaModel):
    def __init__(self, request_id=None, key_pair_name=None, key_pair_finger_print=None):
        self.request_id = request_id    # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.key_pair_finger_print = key_pair_finger_print  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.key_pair_finger_print, 'key_pair_finger_print')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['KeyPairName'] = self.key_pair_name
        result['KeyPairFingerPrint'] = self.key_pair_finger_print
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.key_pair_name = map.get('KeyPairName')
        self.key_pair_finger_print = map.get('KeyPairFingerPrint')
        return self


class DetachKeyPairRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, instance_ids=None):
        self.region_id = region_id      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.instance_ids = instance_ids  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.instance_ids = map.get('InstanceIds')
        return self


class DetachKeyPairResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, key_pair_name=None, results=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: str
        self.fail_count = fail_count    # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.results = results          # type: DetachKeyPairResponseResults

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.results, 'results')
        if self.results:
            self.results.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['FailCount'] = self.fail_count
        result['KeyPairName'] = self.key_pair_name
        if self.results is not None:
            result['Results'] = self.results.to_map()
        else:
            result['Results'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.fail_count = map.get('FailCount')
        self.key_pair_name = map.get('KeyPairName')
        if map.get('Results') is not None:
            temp_model = DetachKeyPairResponseResults()
            self.results = temp_model.from_map(map['Results'])
        else:
            self.results = None
        return self


class DetachKeyPairResponseResultsResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.success = success          # type: str
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Success'] = self.success
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.success = map.get('Success')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class DetachKeyPairResponseResults(TeaModel):
    def __init__(self, result=None):
        self.result = result            # type: List[DetachKeyPairResponseResultsResult]

    def validate(self):
        self.validate_required(self.result, 'result')
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        else:
            result['Result'] = None
        return result

    def from_map(self, map={}):
        self.result = []
        if map.get('Result') is not None:
            for k in map.get('Result'):
                temp_model = DetachKeyPairResponseResultsResult()
                self.result.append(temp_model.from_map(k))
        else:
            self.result = None
        return self


class DescribeKeyPairsRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, key_pair_finger_print=None, page_number=None,
                 page_size=None, tag=None, resource_group_id=None):
        self.region_id = region_id      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.key_pair_finger_print = key_pair_finger_print  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.tag = tag                  # type: List[DescribeKeyPairsRequestTag]
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['KeyPairFingerPrint'] = self.key_pair_finger_print
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.key_pair_finger_print = map.get('KeyPairFingerPrint')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeKeyPairsRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class DescribeKeyPairsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeKeyPairsResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, key_pairs=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.key_pairs = key_pairs      # type: DescribeKeyPairsResponseKeyPairs

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.key_pairs, 'key_pairs')
        if self.key_pairs:
            self.key_pairs.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.key_pairs is not None:
            result['KeyPairs'] = self.key_pairs.to_map()
        else:
            result['KeyPairs'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('KeyPairs') is not None:
            temp_model = DescribeKeyPairsResponseKeyPairs()
            self.key_pairs = temp_model.from_map(map['KeyPairs'])
        else:
            self.key_pairs = None
        return self


class DescribeKeyPairsResponseKeyPairsKeyPairTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeKeyPairsResponseKeyPairsKeyPairTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeKeyPairsResponseKeyPairsKeyPairTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeKeyPairsResponseKeyPairsKeyPairTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeKeyPairsResponseKeyPairsKeyPair(TeaModel):
    def __init__(self, key_pair_name=None, key_pair_finger_print=None, creation_time=None, resource_group_id=None,
                 tags=None):
        self.key_pair_name = key_pair_name  # type: str
        self.key_pair_finger_print = key_pair_finger_print  # type: str
        self.creation_time = creation_time  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tags = tags                # type: DescribeKeyPairsResponseKeyPairsKeyPairTags

    def validate(self):
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.key_pair_finger_print, 'key_pair_finger_print')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.resource_group_id, 'resource_group_id')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['KeyPairName'] = self.key_pair_name
        result['KeyPairFingerPrint'] = self.key_pair_finger_print
        result['CreationTime'] = self.creation_time
        result['ResourceGroupId'] = self.resource_group_id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.key_pair_name = map.get('KeyPairName')
        self.key_pair_finger_print = map.get('KeyPairFingerPrint')
        self.creation_time = map.get('CreationTime')
        self.resource_group_id = map.get('ResourceGroupId')
        if map.get('Tags') is not None:
            temp_model = DescribeKeyPairsResponseKeyPairsKeyPairTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeKeyPairsResponseKeyPairs(TeaModel):
    def __init__(self, key_pair=None):
        self.key_pair = key_pair        # type: List[DescribeKeyPairsResponseKeyPairsKeyPair]

    def validate(self):
        self.validate_required(self.key_pair, 'key_pair')
        if self.key_pair:
            for k in self.key_pair:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['KeyPair'] = []
        if self.key_pair is not None:
            for k in self.key_pair:
                result['KeyPair'].append(k.to_map() if k else None)
        else:
            result['KeyPair'] = None
        return result

    def from_map(self, map={}):
        self.key_pair = []
        if map.get('KeyPair') is not None:
            for k in map.get('KeyPair'):
                temp_model = DescribeKeyPairsResponseKeyPairsKeyPair()
                self.key_pair.append(temp_model.from_map(k))
        else:
            self.key_pair = None
        return self


class DeleteKeyPairsRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_names=None):
        self.region_id = region_id      # type: str
        self.key_pair_names = key_pair_names  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_names, 'key_pair_names')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairNames'] = self.key_pair_names
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_names = map.get('KeyPairNames')
        return self


class DeleteKeyPairsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateKeyPairRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, tag=None, resource_group_id=None):
        self.region_id = region_id      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.tag = tag                  # type: List[CreateKeyPairRequestTag]
        self.resource_group_id = resource_group_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateKeyPairRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        self.resource_group_id = map.get('ResourceGroupId')
        return self


class CreateKeyPairRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CreateKeyPairResponse(TeaModel):
    def __init__(self, request_id=None, key_pair_id=None, key_pair_name=None, key_pair_finger_print=None,
                 private_key_body=None):
        self.request_id = request_id    # type: str
        self.key_pair_id = key_pair_id  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.key_pair_finger_print = key_pair_finger_print  # type: str
        self.private_key_body = private_key_body  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.key_pair_id, 'key_pair_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.key_pair_finger_print, 'key_pair_finger_print')
        self.validate_required(self.private_key_body, 'private_key_body')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['KeyPairId'] = self.key_pair_id
        result['KeyPairName'] = self.key_pair_name
        result['KeyPairFingerPrint'] = self.key_pair_finger_print
        result['PrivateKeyBody'] = self.private_key_body
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.key_pair_id = map.get('KeyPairId')
        self.key_pair_name = map.get('KeyPairName')
        self.key_pair_finger_print = map.get('KeyPairFingerPrint')
        self.private_key_body = map.get('PrivateKeyBody')
        return self


class AttachKeyPairRequest(TeaModel):
    def __init__(self, region_id=None, key_pair_name=None, instance_ids=None):
        self.region_id = region_id      # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.instance_ids = instance_ids  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.instance_ids, 'instance_ids')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['KeyPairName'] = self.key_pair_name
        result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.key_pair_name = map.get('KeyPairName')
        self.instance_ids = map.get('InstanceIds')
        return self


class AttachKeyPairResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, fail_count=None, key_pair_name=None, results=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: str
        self.fail_count = fail_count    # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.results = results          # type: AttachKeyPairResponseResults

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.fail_count, 'fail_count')
        self.validate_required(self.key_pair_name, 'key_pair_name')
        self.validate_required(self.results, 'results')
        if self.results:
            self.results.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['FailCount'] = self.fail_count
        result['KeyPairName'] = self.key_pair_name
        if self.results is not None:
            result['Results'] = self.results.to_map()
        else:
            result['Results'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.fail_count = map.get('FailCount')
        self.key_pair_name = map.get('KeyPairName')
        if map.get('Results') is not None:
            temp_model = AttachKeyPairResponseResults()
            self.results = temp_model.from_map(map['Results'])
        else:
            self.results = None
        return self


class AttachKeyPairResponseResultsResult(TeaModel):
    def __init__(self, instance_id=None, success=None, code=None, message=None):
        self.instance_id = instance_id  # type: str
        self.success = success          # type: str
        self.code = code                # type: str
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.success, 'success')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['Success'] = self.success
        result['Code'] = self.code
        result['Message'] = self.message
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.success = map.get('Success')
        self.code = map.get('Code')
        self.message = map.get('Message')
        return self


class AttachKeyPairResponseResults(TeaModel):
    def __init__(self, result=None):
        self.result = result            # type: List[AttachKeyPairResponseResultsResult]

    def validate(self):
        self.validate_required(self.result, 'result')
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        else:
            result['Result'] = None
        return result

    def from_map(self, map={}):
        self.result = []
        if map.get('Result') is not None:
            for k in map.get('Result'):
                temp_model = AttachKeyPairResponseResultsResult()
                self.result.append(temp_model.from_map(k))
        else:
            self.result = None
        return self


class ModifyInstanceAutoRenewAttributeRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, duration=None, auto_renew=None, renewal_status=None,
                 period_unit=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id      # type: str
        self.duration = duration        # type: int
        self.auto_renew = auto_renew    # type: bool
        self.renewal_status = renewal_status  # type: str
        self.period_unit = period_unit  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['Duration'] = self.duration
        result['AutoRenew'] = self.auto_renew
        result['RenewalStatus'] = self.renewal_status
        result['PeriodUnit'] = self.period_unit
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.duration = map.get('Duration')
        self.auto_renew = map.get('AutoRenew')
        self.renewal_status = map.get('RenewalStatus')
        self.period_unit = map.get('PeriodUnit')
        return self


class ModifyInstanceAutoRenewAttributeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeInstanceAutoRenewAttributeRequest(TeaModel):
    def __init__(self, instance_id=None, region_id=None, renewal_status=None, page_size=None, page_number=None):
        self.instance_id = instance_id  # type: str
        self.region_id = region_id      # type: str
        self.renewal_status = renewal_status  # type: str
        self.page_size = page_size      # type: str
        self.page_number = page_number  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['RegionId'] = self.region_id
        result['RenewalStatus'] = self.renewal_status
        result['PageSize'] = self.page_size
        result['PageNumber'] = self.page_number
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.region_id = map.get('RegionId')
        self.renewal_status = map.get('RenewalStatus')
        self.page_size = map.get('PageSize')
        self.page_number = map.get('PageNumber')
        return self


class DescribeInstanceAutoRenewAttributeResponse(TeaModel):
    def __init__(self, request_id=None, page_number=None, page_size=None, total_count=None,
                 instance_renew_attributes=None):
        self.request_id = request_id    # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.total_count = total_count  # type: int
        self.instance_renew_attributes = instance_renew_attributes  # type: DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributes

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.instance_renew_attributes, 'instance_renew_attributes')
        if self.instance_renew_attributes:
            self.instance_renew_attributes.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['TotalCount'] = self.total_count
        if self.instance_renew_attributes is not None:
            result['InstanceRenewAttributes'] = self.instance_renew_attributes.to_map()
        else:
            result['InstanceRenewAttributes'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.total_count = map.get('TotalCount')
        if map.get('InstanceRenewAttributes') is not None:
            temp_model = DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributes()
            self.instance_renew_attributes = temp_model.from_map(map['InstanceRenewAttributes'])
        else:
            self.instance_renew_attributes = None
        return self


class DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributesInstanceRenewAttribute(TeaModel):
    def __init__(self, instance_id=None, auto_renew_enabled=None, duration=None, period_unit=None,
                 renewal_status=None):
        self.instance_id = instance_id  # type: str
        self.auto_renew_enabled = auto_renew_enabled  # type: bool
        self.duration = duration        # type: int
        self.period_unit = period_unit  # type: str
        self.renewal_status = renewal_status  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.auto_renew_enabled, 'auto_renew_enabled')
        self.validate_required(self.duration, 'duration')
        self.validate_required(self.period_unit, 'period_unit')
        self.validate_required(self.renewal_status, 'renewal_status')

    def to_map(self):
        result = {}
        result['InstanceId'] = self.instance_id
        result['AutoRenewEnabled'] = self.auto_renew_enabled
        result['Duration'] = self.duration
        result['PeriodUnit'] = self.period_unit
        result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, map={}):
        self.instance_id = map.get('InstanceId')
        self.auto_renew_enabled = map.get('AutoRenewEnabled')
        self.duration = map.get('Duration')
        self.period_unit = map.get('PeriodUnit')
        self.renewal_status = map.get('RenewalStatus')
        return self


class DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributes(TeaModel):
    def __init__(self, instance_renew_attribute=None):
        self.instance_renew_attribute = instance_renew_attribute  # type: List[DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributesInstanceRenewAttribute]

    def validate(self):
        self.validate_required(self.instance_renew_attribute, 'instance_renew_attribute')
        if self.instance_renew_attribute:
            for k in self.instance_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['InstanceRenewAttribute'] = []
        if self.instance_renew_attribute is not None:
            for k in self.instance_renew_attribute:
                result['InstanceRenewAttribute'].append(k.to_map() if k else None)
        else:
            result['InstanceRenewAttribute'] = None
        return result

    def from_map(self, map={}):
        self.instance_renew_attribute = []
        if map.get('InstanceRenewAttribute') is not None:
            for k in map.get('InstanceRenewAttribute'):
                temp_model = DescribeInstanceAutoRenewAttributeResponseInstanceRenewAttributesInstanceRenewAttribute()
                self.instance_renew_attribute.append(temp_model.from_map(k))
        else:
            self.instance_renew_attribute = None
        return self


class DescribeSnapshotLinksRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, disk_ids=None, snapshot_link_ids=None, page_number=None,
                 page_size=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.disk_ids = disk_ids        # type: str
        self.snapshot_link_ids = snapshot_link_ids  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['DiskIds'] = self.disk_ids
        result['SnapshotLinkIds'] = self.snapshot_link_ids
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.disk_ids = map.get('DiskIds')
        self.snapshot_link_ids = map.get('SnapshotLinkIds')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeSnapshotLinksResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, snapshot_links=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.snapshot_links = snapshot_links  # type: DescribeSnapshotLinksResponseSnapshotLinks

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.snapshot_links, 'snapshot_links')
        if self.snapshot_links:
            self.snapshot_links.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.snapshot_links is not None:
            result['SnapshotLinks'] = self.snapshot_links.to_map()
        else:
            result['SnapshotLinks'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('SnapshotLinks') is not None:
            temp_model = DescribeSnapshotLinksResponseSnapshotLinks()
            self.snapshot_links = temp_model.from_map(map['SnapshotLinks'])
        else:
            self.snapshot_links = None
        return self


class DescribeSnapshotLinksResponseSnapshotLinksSnapshotLink(TeaModel):
    def __init__(self, snapshot_link_id=None, region_id=None, instance_id=None, instance_name=None,
                 source_disk_id=None, source_disk_name=None, source_disk_size=None, source_disk_type=None, category=None,
                 total_size=None, total_count=None):
        self.snapshot_link_id = snapshot_link_id  # type: str
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.source_disk_id = source_disk_id  # type: str
        self.source_disk_name = source_disk_name  # type: str
        self.source_disk_size = source_disk_size  # type: int
        self.source_disk_type = source_disk_type  # type: str
        self.category = category        # type: str
        self.total_size = total_size    # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        self.validate_required(self.snapshot_link_id, 'snapshot_link_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.instance_name, 'instance_name')
        self.validate_required(self.source_disk_id, 'source_disk_id')
        self.validate_required(self.source_disk_name, 'source_disk_name')
        self.validate_required(self.source_disk_size, 'source_disk_size')
        self.validate_required(self.source_disk_type, 'source_disk_type')
        self.validate_required(self.category, 'category')
        self.validate_required(self.total_size, 'total_size')
        self.validate_required(self.total_count, 'total_count')

    def to_map(self):
        result = {}
        result['SnapshotLinkId'] = self.snapshot_link_id
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['InstanceName'] = self.instance_name
        result['SourceDiskId'] = self.source_disk_id
        result['SourceDiskName'] = self.source_disk_name
        result['SourceDiskSize'] = self.source_disk_size
        result['SourceDiskType'] = self.source_disk_type
        result['Category'] = self.category
        result['TotalSize'] = self.total_size
        result['TotalCount'] = self.total_count
        return result

    def from_map(self, map={}):
        self.snapshot_link_id = map.get('SnapshotLinkId')
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.instance_name = map.get('InstanceName')
        self.source_disk_id = map.get('SourceDiskId')
        self.source_disk_name = map.get('SourceDiskName')
        self.source_disk_size = map.get('SourceDiskSize')
        self.source_disk_type = map.get('SourceDiskType')
        self.category = map.get('Category')
        self.total_size = map.get('TotalSize')
        self.total_count = map.get('TotalCount')
        return self


class DescribeSnapshotLinksResponseSnapshotLinks(TeaModel):
    def __init__(self, snapshot_link=None):
        self.snapshot_link = snapshot_link  # type: List[DescribeSnapshotLinksResponseSnapshotLinksSnapshotLink]

    def validate(self):
        self.validate_required(self.snapshot_link, 'snapshot_link')
        if self.snapshot_link:
            for k in self.snapshot_link:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['SnapshotLink'] = []
        if self.snapshot_link is not None:
            for k in self.snapshot_link:
                result['SnapshotLink'].append(k.to_map() if k else None)
        else:
            result['SnapshotLink'] = None
        return result

    def from_map(self, map={}):
        self.snapshot_link = []
        if map.get('SnapshotLink') is not None:
            for k in map.get('SnapshotLink'):
                temp_model = DescribeSnapshotLinksResponseSnapshotLinksSnapshotLink()
                self.snapshot_link.append(temp_model.from_map(k))
        else:
            self.snapshot_link = None
        return self


class ModifyInstanceAutoReleaseTimeRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None, auto_release_time=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.auto_release_time = auto_release_time  # type: str

    def validate(self):
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['AutoReleaseTime'] = self.auto_release_time
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.auto_release_time = map.get('AutoReleaseTime')
        return self


class ModifyInstanceAutoReleaseTimeResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeNewProjectEipMonitorDataRequest(TeaModel):
    def __init__(self, region_id=None, allocation_id=None, start_time=None, end_time=None, period=None):
        self.region_id = region_id      # type: str
        self.allocation_id = allocation_id  # type: str
        self.start_time = start_time    # type: str
        self.end_time = end_time        # type: str
        self.period = period            # type: int

    def validate(self):
        self.validate_required(self.allocation_id, 'allocation_id')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.end_time, 'end_time')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AllocationId'] = self.allocation_id
        result['StartTime'] = self.start_time
        result['EndTime'] = self.end_time
        result['Period'] = self.period
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.allocation_id = map.get('AllocationId')
        self.start_time = map.get('StartTime')
        self.end_time = map.get('EndTime')
        self.period = map.get('Period')
        return self


class DescribeNewProjectEipMonitorDataResponse(TeaModel):
    def __init__(self, request_id=None, eip_monitor_datas=None):
        self.request_id = request_id    # type: str
        self.eip_monitor_datas = eip_monitor_datas  # type: DescribeNewProjectEipMonitorDataResponseEipMonitorDatas

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.eip_monitor_datas, 'eip_monitor_datas')
        if self.eip_monitor_datas:
            self.eip_monitor_datas.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        if self.eip_monitor_datas is not None:
            result['EipMonitorDatas'] = self.eip_monitor_datas.to_map()
        else:
            result['EipMonitorDatas'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        if map.get('EipMonitorDatas') is not None:
            temp_model = DescribeNewProjectEipMonitorDataResponseEipMonitorDatas()
            self.eip_monitor_datas = temp_model.from_map(map['EipMonitorDatas'])
        else:
            self.eip_monitor_datas = None
        return self


class DescribeNewProjectEipMonitorDataResponseEipMonitorDatasEipMonitorData(TeaModel):
    def __init__(self, eip_rx=None, eip_tx=None, eip_flow=None, eip_bandwidth=None, eip_packets=None,
                 time_stamp=None):
        self.eip_rx = eip_rx            # type: int
        self.eip_tx = eip_tx            # type: int
        self.eip_flow = eip_flow        # type: int
        self.eip_bandwidth = eip_bandwidth  # type: int
        self.eip_packets = eip_packets  # type: int
        self.time_stamp = time_stamp    # type: str

    def validate(self):
        self.validate_required(self.eip_rx, 'eip_rx')
        self.validate_required(self.eip_tx, 'eip_tx')
        self.validate_required(self.eip_flow, 'eip_flow')
        self.validate_required(self.eip_bandwidth, 'eip_bandwidth')
        self.validate_required(self.eip_packets, 'eip_packets')
        self.validate_required(self.time_stamp, 'time_stamp')

    def to_map(self):
        result = {}
        result['EipRX'] = self.eip_rx
        result['EipTX'] = self.eip_tx
        result['EipFlow'] = self.eip_flow
        result['EipBandwidth'] = self.eip_bandwidth
        result['EipPackets'] = self.eip_packets
        result['TimeStamp'] = self.time_stamp
        return result

    def from_map(self, map={}):
        self.eip_rx = map.get('EipRX')
        self.eip_tx = map.get('EipTX')
        self.eip_flow = map.get('EipFlow')
        self.eip_bandwidth = map.get('EipBandwidth')
        self.eip_packets = map.get('EipPackets')
        self.time_stamp = map.get('TimeStamp')
        return self


class DescribeNewProjectEipMonitorDataResponseEipMonitorDatas(TeaModel):
    def __init__(self, eip_monitor_data=None):
        self.eip_monitor_data = eip_monitor_data  # type: List[DescribeNewProjectEipMonitorDataResponseEipMonitorDatasEipMonitorData]

    def validate(self):
        self.validate_required(self.eip_monitor_data, 'eip_monitor_data')
        if self.eip_monitor_data:
            for k in self.eip_monitor_data:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['EipMonitorData'] = []
        if self.eip_monitor_data is not None:
            for k in self.eip_monitor_data:
                result['EipMonitorData'].append(k.to_map() if k else None)
        else:
            result['EipMonitorData'] = None
        return result

    def from_map(self, map={}):
        self.eip_monitor_data = []
        if map.get('EipMonitorData') is not None:
            for k in map.get('EipMonitorData'):
                temp_model = DescribeNewProjectEipMonitorDataResponseEipMonitorDatasEipMonitorData()
                self.eip_monitor_data.append(temp_model.from_map(k))
        else:
            self.eip_monitor_data = None
        return self


class DescribeUserDataRequest(TeaModel):
    def __init__(self, region_id=None, instance_id=None):
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        return self


class DescribeUserDataResponse(TeaModel):
    def __init__(self, request_id=None, region_id=None, instance_id=None, user_data=None):
        self.request_id = request_id    # type: str
        self.region_id = region_id      # type: str
        self.instance_id = instance_id  # type: str
        self.user_data = user_data      # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.instance_id, 'instance_id')
        self.validate_required(self.user_data, 'user_data')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['RegionId'] = self.region_id
        result['InstanceId'] = self.instance_id
        result['UserData'] = self.user_data
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.region_id = map.get('RegionId')
        self.instance_id = map.get('InstanceId')
        self.user_data = map.get('UserData')
        return self


class RemoveBandwidthPackageIpsRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None, client_token=None, removed_ip_addresses=None):
        self.region_id = region_id      # type: str
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.client_token = client_token  # type: str
        self.removed_ip_addresses = removed_ip_addresses  # type: List[str]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')
        self.validate_required(self.removed_ip_addresses, 'removed_ip_addresses')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['ClientToken'] = self.client_token
        result['RemovedIpAddresses'] = self.removed_ip_addresses
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.client_token = map.get('ClientToken')
        self.removed_ip_addresses = map.get('RemovedIpAddresses')
        return self


class RemoveBandwidthPackageIpsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyForwardEntryRequest(TeaModel):
    def __init__(self, forward_table_id=None, forward_entry_id=None, external_ip=None, external_port=None,
                 internal_ip=None, internal_port=None, ip_protocol=None, region_id=None):
        self.forward_table_id = forward_table_id  # type: str
        self.forward_entry_id = forward_entry_id  # type: str
        self.external_ip = external_ip  # type: str
        self.external_port = external_port  # type: str
        self.internal_ip = internal_ip  # type: str
        self.internal_port = internal_port  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.region_id = region_id      # type: str

    def validate(self):
        self.validate_required(self.forward_table_id, 'forward_table_id')
        self.validate_required(self.forward_entry_id, 'forward_entry_id')
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['ForwardTableId'] = self.forward_table_id
        result['ForwardEntryId'] = self.forward_entry_id
        result['ExternalIp'] = self.external_ip
        result['ExternalPort'] = self.external_port
        result['InternalIp'] = self.internal_ip
        result['InternalPort'] = self.internal_port
        result['IpProtocol'] = self.ip_protocol
        result['RegionId'] = self.region_id
        return result

    def from_map(self, map={}):
        self.forward_table_id = map.get('ForwardTableId')
        self.forward_entry_id = map.get('ForwardEntryId')
        self.external_ip = map.get('ExternalIp')
        self.external_port = map.get('ExternalPort')
        self.internal_ip = map.get('InternalIp')
        self.internal_port = map.get('InternalPort')
        self.ip_protocol = map.get('IpProtocol')
        self.region_id = map.get('RegionId')
        return self


class ModifyForwardEntryResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ModifyBandwidthPackageSpecRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None, bandwidth=None):
        self.region_id = region_id      # type: str
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.bandwidth = bandwidth      # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')
        self.validate_required(self.bandwidth, 'bandwidth')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['Bandwidth'] = self.bandwidth
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.bandwidth = map.get('Bandwidth')
        return self


class ModifyBandwidthPackageSpecResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeNatGatewaysRequest(TeaModel):
    def __init__(self, region_id=None, nat_gateway_id=None, vpc_id=None, page_number=None, page_size=None):
        self.region_id = region_id      # type: str
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.vpc_id = vpc_id            # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NatGatewayId'] = self.nat_gateway_id
        result['VpcId'] = self.vpc_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.nat_gateway_id = map.get('NatGatewayId')
        self.vpc_id = map.get('VpcId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeNatGatewaysResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, nat_gateways=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.nat_gateways = nat_gateways  # type: DescribeNatGatewaysResponseNatGateways

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.nat_gateways, 'nat_gateways')
        if self.nat_gateways:
            self.nat_gateways.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.nat_gateways is not None:
            result['NatGateways'] = self.nat_gateways.to_map()
        else:
            result['NatGateways'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('NatGateways') is not None:
            temp_model = DescribeNatGatewaysResponseNatGateways()
            self.nat_gateways = temp_model.from_map(map['NatGateways'])
        else:
            self.nat_gateways = None
        return self


class DescribeNatGatewaysResponseNatGatewaysNatGatewayForwardTableIds(TeaModel):
    def __init__(self, forward_table_id=None):
        # ForwardTableId
        self.forward_table_id = forward_table_id  # type: List[str]

    def validate(self):
        self.validate_required(self.forward_table_id, 'forward_table_id')

    def to_map(self):
        result = {}
        result['ForwardTableId'] = self.forward_table_id
        return result

    def from_map(self, map={}):
        self.forward_table_id = map.get('ForwardTableId')
        return self


class DescribeNatGatewaysResponseNatGatewaysNatGatewayBandwidthPackageIds(TeaModel):
    def __init__(self, bandwidth_package_id=None):
        # BandwidthPackageId
        self.bandwidth_package_id = bandwidth_package_id  # type: List[str]

    def validate(self):
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')

    def to_map(self):
        result = {}
        result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, map={}):
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        return self


class DescribeNatGatewaysResponseNatGatewaysNatGateway(TeaModel):
    def __init__(self, nat_gateway_id=None, region_id=None, name=None, description=None, vpc_id=None, spec=None,
                 instance_charge_type=None, business_status=None, creation_time=None, status=None, forward_table_ids=None,
                 bandwidth_package_ids=None):
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.vpc_id = vpc_id            # type: str
        self.spec = spec                # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.business_status = business_status  # type: str
        self.creation_time = creation_time  # type: str
        self.status = status            # type: str
        self.forward_table_ids = forward_table_ids  # type: DescribeNatGatewaysResponseNatGatewaysNatGatewayForwardTableIds
        self.bandwidth_package_ids = bandwidth_package_ids  # type: DescribeNatGatewaysResponseNatGatewaysNatGatewayBandwidthPackageIds

    def validate(self):
        self.validate_required(self.nat_gateway_id, 'nat_gateway_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.spec, 'spec')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.business_status, 'business_status')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.forward_table_ids, 'forward_table_ids')
        if self.forward_table_ids:
            self.forward_table_ids.validate()
        self.validate_required(self.bandwidth_package_ids, 'bandwidth_package_ids')
        if self.bandwidth_package_ids:
            self.bandwidth_package_ids.validate()

    def to_map(self):
        result = {}
        result['NatGatewayId'] = self.nat_gateway_id
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['VpcId'] = self.vpc_id
        result['Spec'] = self.spec
        result['InstanceChargeType'] = self.instance_charge_type
        result['BusinessStatus'] = self.business_status
        result['CreationTime'] = self.creation_time
        result['Status'] = self.status
        if self.forward_table_ids is not None:
            result['ForwardTableIds'] = self.forward_table_ids.to_map()
        else:
            result['ForwardTableIds'] = None
        if self.bandwidth_package_ids is not None:
            result['BandwidthPackageIds'] = self.bandwidth_package_ids.to_map()
        else:
            result['BandwidthPackageIds'] = None
        return result

    def from_map(self, map={}):
        self.nat_gateway_id = map.get('NatGatewayId')
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.vpc_id = map.get('VpcId')
        self.spec = map.get('Spec')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.business_status = map.get('BusinessStatus')
        self.creation_time = map.get('CreationTime')
        self.status = map.get('Status')
        if map.get('ForwardTableIds') is not None:
            temp_model = DescribeNatGatewaysResponseNatGatewaysNatGatewayForwardTableIds()
            self.forward_table_ids = temp_model.from_map(map['ForwardTableIds'])
        else:
            self.forward_table_ids = None
        if map.get('BandwidthPackageIds') is not None:
            temp_model = DescribeNatGatewaysResponseNatGatewaysNatGatewayBandwidthPackageIds()
            self.bandwidth_package_ids = temp_model.from_map(map['BandwidthPackageIds'])
        else:
            self.bandwidth_package_ids = None
        return self


class DescribeNatGatewaysResponseNatGateways(TeaModel):
    def __init__(self, nat_gateway=None):
        self.nat_gateway = nat_gateway  # type: List[DescribeNatGatewaysResponseNatGatewaysNatGateway]

    def validate(self):
        self.validate_required(self.nat_gateway, 'nat_gateway')
        if self.nat_gateway:
            for k in self.nat_gateway:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['NatGateway'] = []
        if self.nat_gateway is not None:
            for k in self.nat_gateway:
                result['NatGateway'].append(k.to_map() if k else None)
        else:
            result['NatGateway'] = None
        return result

    def from_map(self, map={}):
        self.nat_gateway = []
        if map.get('NatGateway') is not None:
            for k in map.get('NatGateway'):
                temp_model = DescribeNatGatewaysResponseNatGatewaysNatGateway()
                self.nat_gateway.append(temp_model.from_map(k))
        else:
            self.nat_gateway = None
        return self


class DescribeForwardTableEntriesRequest(TeaModel):
    def __init__(self, region_id=None, forward_table_id=None, forward_entry_id=None, page_number=None,
                 page_size=None):
        self.region_id = region_id      # type: str
        self.forward_table_id = forward_table_id  # type: str
        self.forward_entry_id = forward_entry_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.forward_table_id, 'forward_table_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ForwardTableId'] = self.forward_table_id
        result['ForwardEntryId'] = self.forward_entry_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.forward_table_id = map.get('ForwardTableId')
        self.forward_entry_id = map.get('ForwardEntryId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeForwardTableEntriesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 forward_table_entries=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.forward_table_entries = forward_table_entries  # type: DescribeForwardTableEntriesResponseForwardTableEntries

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.forward_table_entries, 'forward_table_entries')
        if self.forward_table_entries:
            self.forward_table_entries.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.forward_table_entries is not None:
            result['ForwardTableEntries'] = self.forward_table_entries.to_map()
        else:
            result['ForwardTableEntries'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('ForwardTableEntries') is not None:
            temp_model = DescribeForwardTableEntriesResponseForwardTableEntries()
            self.forward_table_entries = temp_model.from_map(map['ForwardTableEntries'])
        else:
            self.forward_table_entries = None
        return self


class DescribeForwardTableEntriesResponseForwardTableEntriesForwardTableEntry(TeaModel):
    def __init__(self, forward_table_id=None, forward_entry_id=None, external_ip=None, external_port=None,
                 ip_protocol=None, internal_ip=None, internal_port=None, status=None):
        self.forward_table_id = forward_table_id  # type: str
        self.forward_entry_id = forward_entry_id  # type: str
        self.external_ip = external_ip  # type: str
        self.external_port = external_port  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.internal_ip = internal_ip  # type: str
        self.internal_port = internal_port  # type: str
        self.status = status            # type: str

    def validate(self):
        self.validate_required(self.forward_table_id, 'forward_table_id')
        self.validate_required(self.forward_entry_id, 'forward_entry_id')
        self.validate_required(self.external_ip, 'external_ip')
        self.validate_required(self.external_port, 'external_port')
        self.validate_required(self.ip_protocol, 'ip_protocol')
        self.validate_required(self.internal_ip, 'internal_ip')
        self.validate_required(self.internal_port, 'internal_port')
        self.validate_required(self.status, 'status')

    def to_map(self):
        result = {}
        result['ForwardTableId'] = self.forward_table_id
        result['ForwardEntryId'] = self.forward_entry_id
        result['ExternalIp'] = self.external_ip
        result['ExternalPort'] = self.external_port
        result['IpProtocol'] = self.ip_protocol
        result['InternalIp'] = self.internal_ip
        result['InternalPort'] = self.internal_port
        result['Status'] = self.status
        return result

    def from_map(self, map={}):
        self.forward_table_id = map.get('ForwardTableId')
        self.forward_entry_id = map.get('ForwardEntryId')
        self.external_ip = map.get('ExternalIp')
        self.external_port = map.get('ExternalPort')
        self.ip_protocol = map.get('IpProtocol')
        self.internal_ip = map.get('InternalIp')
        self.internal_port = map.get('InternalPort')
        self.status = map.get('Status')
        return self


class DescribeForwardTableEntriesResponseForwardTableEntries(TeaModel):
    def __init__(self, forward_table_entry=None):
        self.forward_table_entry = forward_table_entry  # type: List[DescribeForwardTableEntriesResponseForwardTableEntriesForwardTableEntry]

    def validate(self):
        self.validate_required(self.forward_table_entry, 'forward_table_entry')
        if self.forward_table_entry:
            for k in self.forward_table_entry:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['ForwardTableEntry'] = []
        if self.forward_table_entry is not None:
            for k in self.forward_table_entry:
                result['ForwardTableEntry'].append(k.to_map() if k else None)
        else:
            result['ForwardTableEntry'] = None
        return result

    def from_map(self, map={}):
        self.forward_table_entry = []
        if map.get('ForwardTableEntry') is not None:
            for k in map.get('ForwardTableEntry'):
                temp_model = DescribeForwardTableEntriesResponseForwardTableEntriesForwardTableEntry()
                self.forward_table_entry.append(temp_model.from_map(k))
        else:
            self.forward_table_entry = None
        return self


class DescribeBandwidthPackagesRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None, nat_gateway_id=None, page_number=None,
                 page_size=None):
        self.region_id = region_id      # type: str
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['NatGatewayId'] = self.nat_gateway_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.nat_gateway_id = map.get('NatGatewayId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        return self


class DescribeBandwidthPackagesResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None, bandwidth_packages=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.bandwidth_packages = bandwidth_packages  # type: DescribeBandwidthPackagesResponseBandwidthPackages

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.bandwidth_packages, 'bandwidth_packages')
        if self.bandwidth_packages:
            self.bandwidth_packages.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.bandwidth_packages is not None:
            result['BandwidthPackages'] = self.bandwidth_packages.to_map()
        else:
            result['BandwidthPackages'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('BandwidthPackages') is not None:
            temp_model = DescribeBandwidthPackagesResponseBandwidthPackages()
            self.bandwidth_packages = temp_model.from_map(map['BandwidthPackages'])
        else:
            self.bandwidth_packages = None
        return self


class DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse(TeaModel):
    def __init__(self, allocation_id=None, ip_address=None):
        self.allocation_id = allocation_id  # type: str
        self.ip_address = ip_address    # type: str

    def validate(self):
        self.validate_required(self.allocation_id, 'allocation_id')
        self.validate_required(self.ip_address, 'ip_address')

    def to_map(self):
        result = {}
        result['AllocationId'] = self.allocation_id
        result['IpAddress'] = self.ip_address
        return result

    def from_map(self, map={}):
        self.allocation_id = map.get('AllocationId')
        self.ip_address = map.get('IpAddress')
        return self


class DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddresses(TeaModel):
    def __init__(self, public_ip_addresse=None):
        self.public_ip_addresse = public_ip_addresse  # type: List[DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse]

    def validate(self):
        self.validate_required(self.public_ip_addresse, 'public_ip_addresse')
        if self.public_ip_addresse:
            for k in self.public_ip_addresse:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['PublicIpAddresse'] = []
        if self.public_ip_addresse is not None:
            for k in self.public_ip_addresse:
                result['PublicIpAddresse'].append(k.to_map() if k else None)
        else:
            result['PublicIpAddresse'] = None
        return result

    def from_map(self, map={}):
        self.public_ip_addresse = []
        if map.get('PublicIpAddresse') is not None:
            for k in map.get('PublicIpAddresse'):
                temp_model = DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse()
                self.public_ip_addresse.append(temp_model.from_map(k))
        else:
            self.public_ip_addresse = None
        return self


class DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackage(TeaModel):
    def __init__(self, bandwidth_package_id=None, region_id=None, name=None, description=None, zone_id=None,
                 nat_gateway_id=None, bandwidth=None, instance_charge_type=None, internet_charge_type=None, business_status=None,
                 ip_count=None, isp=None, creation_time=None, status=None, public_ip_addresses=None):
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.region_id = region_id      # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.zone_id = zone_id          # type: str
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.bandwidth = bandwidth      # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.business_status = business_status  # type: str
        self.ip_count = ip_count        # type: str
        self.isp = isp                  # type: str
        self.creation_time = creation_time  # type: str
        self.status = status            # type: str
        self.public_ip_addresses = public_ip_addresses  # type: DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddresses

    def validate(self):
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.name, 'name')
        self.validate_required(self.description, 'description')
        self.validate_required(self.zone_id, 'zone_id')
        self.validate_required(self.nat_gateway_id, 'nat_gateway_id')
        self.validate_required(self.bandwidth, 'bandwidth')
        self.validate_required(self.instance_charge_type, 'instance_charge_type')
        self.validate_required(self.internet_charge_type, 'internet_charge_type')
        self.validate_required(self.business_status, 'business_status')
        self.validate_required(self.ip_count, 'ip_count')
        self.validate_required(self.isp, 'isp')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.public_ip_addresses, 'public_ip_addresses')
        if self.public_ip_addresses:
            self.public_ip_addresses.validate()

    def to_map(self):
        result = {}
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['RegionId'] = self.region_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['ZoneId'] = self.zone_id
        result['NatGatewayId'] = self.nat_gateway_id
        result['Bandwidth'] = self.bandwidth
        result['InstanceChargeType'] = self.instance_charge_type
        result['InternetChargeType'] = self.internet_charge_type
        result['BusinessStatus'] = self.business_status
        result['IpCount'] = self.ip_count
        result['ISP'] = self.isp
        result['CreationTime'] = self.creation_time
        result['Status'] = self.status
        if self.public_ip_addresses is not None:
            result['PublicIpAddresses'] = self.public_ip_addresses.to_map()
        else:
            result['PublicIpAddresses'] = None
        return result

    def from_map(self, map={}):
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.region_id = map.get('RegionId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.zone_id = map.get('ZoneId')
        self.nat_gateway_id = map.get('NatGatewayId')
        self.bandwidth = map.get('Bandwidth')
        self.instance_charge_type = map.get('InstanceChargeType')
        self.internet_charge_type = map.get('InternetChargeType')
        self.business_status = map.get('BusinessStatus')
        self.ip_count = map.get('IpCount')
        self.isp = map.get('ISP')
        self.creation_time = map.get('CreationTime')
        self.status = map.get('Status')
        if map.get('PublicIpAddresses') is not None:
            temp_model = DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackagePublicIpAddresses()
            self.public_ip_addresses = temp_model.from_map(map['PublicIpAddresses'])
        else:
            self.public_ip_addresses = None
        return self


class DescribeBandwidthPackagesResponseBandwidthPackages(TeaModel):
    def __init__(self, bandwidth_package=None):
        self.bandwidth_package = bandwidth_package  # type: List[DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackage]

    def validate(self):
        self.validate_required(self.bandwidth_package, 'bandwidth_package')
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        else:
            result['BandwidthPackage'] = None
        return result

    def from_map(self, map={}):
        self.bandwidth_package = []
        if map.get('BandwidthPackage') is not None:
            for k in map.get('BandwidthPackage'):
                temp_model = DescribeBandwidthPackagesResponseBandwidthPackagesBandwidthPackage()
                self.bandwidth_package.append(temp_model.from_map(k))
        else:
            self.bandwidth_package = None
        return self


class DeleteNatGatewayRequest(TeaModel):
    def __init__(self, region_id=None, nat_gateway_id=None):
        self.region_id = region_id      # type: str
        self.nat_gateway_id = nat_gateway_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.nat_gateway_id, 'nat_gateway_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['NatGatewayId'] = self.nat_gateway_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.nat_gateway_id = map.get('NatGatewayId')
        return self


class DeleteNatGatewayResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeleteForwardEntryRequest(TeaModel):
    def __init__(self, region_id=None, forward_table_id=None, forward_entry_id=None):
        self.region_id = region_id      # type: str
        self.forward_table_id = forward_table_id  # type: str
        self.forward_entry_id = forward_entry_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.forward_table_id, 'forward_table_id')
        self.validate_required(self.forward_entry_id, 'forward_entry_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ForwardTableId'] = self.forward_table_id
        result['ForwardEntryId'] = self.forward_entry_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.forward_table_id = map.get('ForwardTableId')
        self.forward_entry_id = map.get('ForwardEntryId')
        return self


class DeleteForwardEntryResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DeleteBandwidthPackageRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None):
        self.region_id = region_id      # type: str
        self.bandwidth_package_id = bandwidth_package_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        return self


class DeleteBandwidthPackageResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateNatGatewayRequest(TeaModel):
    def __init__(self, region_id=None, vpc_id=None, name=None, description=None, client_token=None,
                 bandwidth_package=None):
        self.region_id = region_id      # type: str
        self.vpc_id = vpc_id            # type: str
        self.name = name                # type: str
        self.description = description  # type: str
        self.client_token = client_token  # type: str
        self.bandwidth_package = bandwidth_package  # type: List[CreateNatGatewayRequestBandwidthPackage]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.vpc_id, 'vpc_id')
        self.validate_required(self.bandwidth_package, 'bandwidth_package')
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['VpcId'] = self.vpc_id
        result['Name'] = self.name
        result['Description'] = self.description
        result['ClientToken'] = self.client_token
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        else:
            result['BandwidthPackage'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.vpc_id = map.get('VpcId')
        self.name = map.get('Name')
        self.description = map.get('Description')
        self.client_token = map.get('ClientToken')
        self.bandwidth_package = []
        if map.get('BandwidthPackage') is not None:
            for k in map.get('BandwidthPackage'):
                temp_model = CreateNatGatewayRequestBandwidthPackage()
                self.bandwidth_package.append(temp_model.from_map(k))
        else:
            self.bandwidth_package = None
        return self


class CreateNatGatewayRequestBandwidthPackage(TeaModel):
    def __init__(self, ip_count=None, bandwidth=None, zone=None):
        self.ip_count = ip_count        # type: int
        self.bandwidth = bandwidth      # type: int
        self.zone = zone                # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['IpCount'] = self.ip_count
        result['Bandwidth'] = self.bandwidth
        result['Zone'] = self.zone
        return result

    def from_map(self, map={}):
        self.ip_count = map.get('IpCount')
        self.bandwidth = map.get('Bandwidth')
        self.zone = map.get('Zone')
        return self


class CreateNatGatewayResponse(TeaModel):
    def __init__(self, request_id=None, nat_gateway_id=None, forward_table_ids=None, bandwidth_package_ids=None):
        self.request_id = request_id    # type: str
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.forward_table_ids = forward_table_ids  # type: CreateNatGatewayResponseForwardTableIds
        self.bandwidth_package_ids = bandwidth_package_ids  # type: CreateNatGatewayResponseBandwidthPackageIds

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.nat_gateway_id, 'nat_gateway_id')
        self.validate_required(self.forward_table_ids, 'forward_table_ids')
        if self.forward_table_ids:
            self.forward_table_ids.validate()
        self.validate_required(self.bandwidth_package_ids, 'bandwidth_package_ids')
        if self.bandwidth_package_ids:
            self.bandwidth_package_ids.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['NatGatewayId'] = self.nat_gateway_id
        if self.forward_table_ids is not None:
            result['ForwardTableIds'] = self.forward_table_ids.to_map()
        else:
            result['ForwardTableIds'] = None
        if self.bandwidth_package_ids is not None:
            result['BandwidthPackageIds'] = self.bandwidth_package_ids.to_map()
        else:
            result['BandwidthPackageIds'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.nat_gateway_id = map.get('NatGatewayId')
        if map.get('ForwardTableIds') is not None:
            temp_model = CreateNatGatewayResponseForwardTableIds()
            self.forward_table_ids = temp_model.from_map(map['ForwardTableIds'])
        else:
            self.forward_table_ids = None
        if map.get('BandwidthPackageIds') is not None:
            temp_model = CreateNatGatewayResponseBandwidthPackageIds()
            self.bandwidth_package_ids = temp_model.from_map(map['BandwidthPackageIds'])
        else:
            self.bandwidth_package_ids = None
        return self


class CreateNatGatewayResponseForwardTableIds(TeaModel):
    def __init__(self, forward_table_id=None):
        self.forward_table_id = forward_table_id  # type: List[str]

    def validate(self):
        self.validate_required(self.forward_table_id, 'forward_table_id')

    def to_map(self):
        result = {}
        result['ForwardTableId'] = self.forward_table_id
        return result

    def from_map(self, map={}):
        self.forward_table_id = map.get('ForwardTableId')
        return self


class CreateNatGatewayResponseBandwidthPackageIds(TeaModel):
    def __init__(self, bandwidth_package_id=None):
        self.bandwidth_package_id = bandwidth_package_id  # type: List[str]

    def validate(self):
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')

    def to_map(self):
        result = {}
        result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, map={}):
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        return self


class CreateForwardEntryRequest(TeaModel):
    def __init__(self, region_id=None, forward_table_id=None, external_ip=None, external_port=None,
                 internal_ip=None, internal_port=None, ip_protocol=None):
        self.region_id = region_id      # type: str
        self.forward_table_id = forward_table_id  # type: str
        self.external_ip = external_ip  # type: str
        self.external_port = external_port  # type: str
        self.internal_ip = internal_ip  # type: str
        self.internal_port = internal_port  # type: str
        self.ip_protocol = ip_protocol  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.forward_table_id, 'forward_table_id')
        self.validate_required(self.external_ip, 'external_ip')
        self.validate_required(self.external_port, 'external_port')
        self.validate_required(self.internal_ip, 'internal_ip')
        self.validate_required(self.internal_port, 'internal_port')
        self.validate_required(self.ip_protocol, 'ip_protocol')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['ForwardTableId'] = self.forward_table_id
        result['ExternalIp'] = self.external_ip
        result['ExternalPort'] = self.external_port
        result['InternalIp'] = self.internal_ip
        result['InternalPort'] = self.internal_port
        result['IpProtocol'] = self.ip_protocol
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.forward_table_id = map.get('ForwardTableId')
        self.external_ip = map.get('ExternalIp')
        self.external_port = map.get('ExternalPort')
        self.internal_ip = map.get('InternalIp')
        self.internal_port = map.get('InternalPort')
        self.ip_protocol = map.get('IpProtocol')
        return self


class CreateForwardEntryResponse(TeaModel):
    def __init__(self, request_id=None, forward_entry_id=None):
        self.request_id = request_id    # type: str
        self.forward_entry_id = forward_entry_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.forward_entry_id, 'forward_entry_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['ForwardEntryId'] = self.forward_entry_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.forward_entry_id = map.get('ForwardEntryId')
        return self


class AddBandwidthPackageIpsRequest(TeaModel):
    def __init__(self, region_id=None, bandwidth_package_id=None, ip_count=None, client_token=None):
        self.region_id = region_id      # type: str
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.ip_count = ip_count        # type: str
        self.client_token = client_token  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.bandwidth_package_id, 'bandwidth_package_id')
        self.validate_required(self.ip_count, 'ip_count')

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['BandwidthPackageId'] = self.bandwidth_package_id
        result['IpCount'] = self.ip_count
        result['ClientToken'] = self.client_token
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.bandwidth_package_id = map.get('BandwidthPackageId')
        self.ip_count = map.get('IpCount')
        self.client_token = map.get('ClientToken')
        return self


class AddBandwidthPackageIpsResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class EipFillProductRequest(TeaModel):
    def __init__(self, data=None, client_token=None, user_cidr=None):
        self.data = data                # type: str
        self.client_token = client_token  # type: str
        self.user_cidr = user_cidr      # type: str

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = {}
        result['data'] = self.data
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.data = map.get('data')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class EipFillProductResponse(TeaModel):
    def __init__(self, request_id=None, data=None, code=None, success=None, message=None):
        self.request_id = request_id    # type: str
        self.data = data                # type: str
        self.code = code                # type: str
        self.success = success          # type: bool
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        self.validate_required(self.code, 'code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['requestId'] = self.request_id
        result['data'] = self.data
        result['code'] = self.code
        result['success'] = self.success
        result['message'] = self.message
        return result

    def from_map(self, map={}):
        self.request_id = map.get('requestId')
        self.data = map.get('data')
        self.code = map.get('code')
        self.success = map.get('success')
        self.message = map.get('message')
        return self


class EipNotifyPaidRequest(TeaModel):
    def __init__(self, data=None, client_token=None, user_cidr=None):
        self.data = data                # type: str
        self.client_token = client_token  # type: str
        self.user_cidr = user_cidr      # type: str

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = {}
        result['data'] = self.data
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.data = map.get('data')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class EipNotifyPaidResponse(TeaModel):
    def __init__(self, request_id=None, data=None, code=None, message=None, success=None):
        self.request_id = request_id    # type: str
        self.data = data                # type: str
        self.code = code                # type: str
        self.message = message          # type: str
        self.success = success          # type: bool

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.success, 'success')

    def to_map(self):
        result = {}
        result['requestId'] = self.request_id
        result['data'] = self.data
        result['code'] = self.code
        result['message'] = self.message
        result['success'] = self.success
        return result

    def from_map(self, map={}):
        self.request_id = map.get('requestId')
        self.data = map.get('data')
        self.code = map.get('code')
        self.message = map.get('message')
        self.success = map.get('success')
        return self


class EipFillParamsRequest(TeaModel):
    def __init__(self, data=None, client_token=None, user_cidr=None):
        self.data = data                # type: str
        self.client_token = client_token  # type: str
        self.user_cidr = user_cidr      # type: str

    def validate(self):
        self.validate_required(self.data, 'data')

    def to_map(self):
        result = {}
        result['data'] = self.data
        result['ClientToken'] = self.client_token
        result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, map={}):
        self.data = map.get('data')
        self.client_token = map.get('ClientToken')
        self.user_cidr = map.get('UserCidr')
        return self


class EipFillParamsResponse(TeaModel):
    def __init__(self, request_id=None, data=None, code=None, success=None, message=None):
        self.request_id = request_id    # type: str
        self.data = data                # type: str
        self.code = code                # type: str
        self.success = success          # type: bool
        self.message = message          # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        self.validate_required(self.code, 'code')
        self.validate_required(self.success, 'success')
        self.validate_required(self.message, 'message')

    def to_map(self):
        result = {}
        result['requestId'] = self.request_id
        result['data'] = self.data
        result['code'] = self.code
        result['success'] = self.success
        result['message'] = self.message
        return result

    def from_map(self, map={}):
        self.request_id = map.get('requestId')
        self.data = map.get('data')
        self.code = map.get('code')
        self.success = map.get('success')
        self.message = map.get('message')
        return self


class ModifyAutoSnapshotPolicyExRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_id=None, auto_snapshot_policy_name=None,
                 time_points=None, repeat_weekdays=None, retention_days=None, enable_cross_region_copy=None,
                 target_copy_regions=None, copied_snapshots_retention_days=None):
        self.region_id = region_id      # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.auto_snapshot_policy_name = auto_snapshot_policy_name  # type: str
        self.time_points = time_points  # type: str
        self.repeat_weekdays = repeat_weekdays  # type: str
        self.retention_days = retention_days  # type: int
        self.enable_cross_region_copy = enable_cross_region_copy  # type: bool
        self.target_copy_regions = target_copy_regions  # type: str
        self.copied_snapshots_retention_days = copied_snapshots_retention_days  # type: int

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['autoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        result['timePoints'] = self.time_points
        result['repeatWeekdays'] = self.repeat_weekdays
        result['retentionDays'] = self.retention_days
        result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        result['TargetCopyRegions'] = self.target_copy_regions
        result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.auto_snapshot_policy_id = map.get('autoSnapshotPolicyId')
        self.auto_snapshot_policy_name = map.get('autoSnapshotPolicyName')
        self.time_points = map.get('timePoints')
        self.repeat_weekdays = map.get('repeatWeekdays')
        self.retention_days = map.get('retentionDays')
        self.enable_cross_region_copy = map.get('EnableCrossRegionCopy')
        self.target_copy_regions = map.get('TargetCopyRegions')
        self.copied_snapshots_retention_days = map.get('CopiedSnapshotsRetentionDays')
        return self


class ModifyAutoSnapshotPolicyExResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeAutoSnapshotPolicyExRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_id=None, page_number=None, page_size=None, tag=None):
        self.region_id = region_id      # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.tag = tag                  # type: List[DescribeAutoSnapshotPolicyExRequestTag]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['RegionId'] = self.region_id
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('RegionId')
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeAutoSnapshotPolicyExRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeAutoSnapshotPolicyExRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class DescribeAutoSnapshotPolicyExResponse(TeaModel):
    def __init__(self, request_id=None, total_count=None, page_number=None, page_size=None,
                 auto_snapshot_policies=None):
        self.request_id = request_id    # type: str
        self.total_count = total_count  # type: int
        self.page_number = page_number  # type: int
        self.page_size = page_size      # type: int
        self.auto_snapshot_policies = auto_snapshot_policies  # type: DescribeAutoSnapshotPolicyExResponseAutoSnapshotPolicies

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.page_number, 'page_number')
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.auto_snapshot_policies, 'auto_snapshot_policies')
        if self.auto_snapshot_policies:
            self.auto_snapshot_policies.validate()

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['TotalCount'] = self.total_count
        result['PageNumber'] = self.page_number
        result['PageSize'] = self.page_size
        if self.auto_snapshot_policies is not None:
            result['AutoSnapshotPolicies'] = self.auto_snapshot_policies.to_map()
        else:
            result['AutoSnapshotPolicies'] = None
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.total_count = map.get('TotalCount')
        self.page_number = map.get('PageNumber')
        self.page_size = map.get('PageSize')
        if map.get('AutoSnapshotPolicies') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseAutoSnapshotPolicies()
            self.auto_snapshot_policies = temp_model.from_map(map['AutoSnapshotPolicies'])
        else:
            self.auto_snapshot_policies = None
        return self


class DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key          # type: str
        self.tag_value = tag_value      # type: str

    def validate(self):
        self.validate_required(self.tag_key, 'tag_key')
        self.validate_required(self.tag_value, 'tag_value')

    def to_map(self):
        result = {}
        result['TagKey'] = self.tag_key
        result['TagValue'] = self.tag_value
        return result

    def from_map(self, map={}):
        self.tag_key = map.get('TagKey')
        self.tag_value = map.get('TagValue')
        return self


class DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag                  # type: List[DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag]

    def validate(self):
        self.validate_required(self.tag, 'tag')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicy(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, region_id=None, auto_snapshot_policy_name=None,
                 time_points=None, repeat_weekdays=None, retention_days=None, disk_nums=None, volume_nums=None,
                 creation_time=None, status=None, enable_cross_region_copy=None, target_copy_regions=None,
                 copied_snapshots_retention_days=None, tags=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.region_id = region_id      # type: str
        self.auto_snapshot_policy_name = auto_snapshot_policy_name  # type: str
        self.time_points = time_points  # type: str
        self.repeat_weekdays = repeat_weekdays  # type: str
        self.retention_days = retention_days  # type: int
        self.disk_nums = disk_nums      # type: int
        self.volume_nums = volume_nums  # type: int
        self.creation_time = creation_time  # type: str
        self.status = status            # type: str
        self.enable_cross_region_copy = enable_cross_region_copy  # type: bool
        self.target_copy_regions = target_copy_regions  # type: str
        self.copied_snapshots_retention_days = copied_snapshots_retention_days  # type: int
        self.tags = tags                # type: DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTags

    def validate(self):
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_snapshot_policy_name, 'auto_snapshot_policy_name')
        self.validate_required(self.time_points, 'time_points')
        self.validate_required(self.repeat_weekdays, 'repeat_weekdays')
        self.validate_required(self.retention_days, 'retention_days')
        self.validate_required(self.disk_nums, 'disk_nums')
        self.validate_required(self.volume_nums, 'volume_nums')
        self.validate_required(self.creation_time, 'creation_time')
        self.validate_required(self.status, 'status')
        self.validate_required(self.enable_cross_region_copy, 'enable_cross_region_copy')
        self.validate_required(self.target_copy_regions, 'target_copy_regions')
        self.validate_required(self.copied_snapshots_retention_days, 'copied_snapshots_retention_days')
        self.validate_required(self.tags, 'tags')
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = {}
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['RegionId'] = self.region_id
        result['AutoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        result['TimePoints'] = self.time_points
        result['RepeatWeekdays'] = self.repeat_weekdays
        result['RetentionDays'] = self.retention_days
        result['DiskNums'] = self.disk_nums
        result['VolumeNums'] = self.volume_nums
        result['CreationTime'] = self.creation_time
        result['Status'] = self.status
        result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        result['TargetCopyRegions'] = self.target_copy_regions
        result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        else:
            result['Tags'] = None
        return result

    def from_map(self, map={}):
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        self.region_id = map.get('RegionId')
        self.auto_snapshot_policy_name = map.get('AutoSnapshotPolicyName')
        self.time_points = map.get('TimePoints')
        self.repeat_weekdays = map.get('RepeatWeekdays')
        self.retention_days = map.get('RetentionDays')
        self.disk_nums = map.get('DiskNums')
        self.volume_nums = map.get('VolumeNums')
        self.creation_time = map.get('CreationTime')
        self.status = map.get('Status')
        self.enable_cross_region_copy = map.get('EnableCrossRegionCopy')
        self.target_copy_regions = map.get('TargetCopyRegions')
        self.copied_snapshots_retention_days = map.get('CopiedSnapshotsRetentionDays')
        if map.get('Tags') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicyTags()
            self.tags = temp_model.from_map(map['Tags'])
        else:
            self.tags = None
        return self


class DescribeAutoSnapshotPolicyExResponseAutoSnapshotPolicies(TeaModel):
    def __init__(self, auto_snapshot_policy=None):
        self.auto_snapshot_policy = auto_snapshot_policy  # type: List[DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicy]

    def validate(self):
        self.validate_required(self.auto_snapshot_policy, 'auto_snapshot_policy')
        if self.auto_snapshot_policy:
            for k in self.auto_snapshot_policy:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['AutoSnapshotPolicy'] = []
        if self.auto_snapshot_policy is not None:
            for k in self.auto_snapshot_policy:
                result['AutoSnapshotPolicy'].append(k.to_map() if k else None)
        else:
            result['AutoSnapshotPolicy'] = None
        return result

    def from_map(self, map={}):
        self.auto_snapshot_policy = []
        if map.get('AutoSnapshotPolicy') is not None:
            for k in map.get('AutoSnapshotPolicy'):
                temp_model = DescribeAutoSnapshotPolicyExResponseAutoSnapshotPoliciesAutoSnapshotPolicy()
                self.auto_snapshot_policy.append(temp_model.from_map(k))
        else:
            self.auto_snapshot_policy = None
        return self


class DeleteAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_id=None):
        self.region_id = region_id      # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.auto_snapshot_policy_id = map.get('autoSnapshotPolicyId')
        return self


class DeleteAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class CreateAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_name=None, time_points=None, repeat_weekdays=None,
                 retention_days=None, enable_cross_region_copy=None, target_copy_regions=None,
                 copied_snapshots_retention_days=None, tag=None):
        self.region_id = region_id      # type: str
        self.auto_snapshot_policy_name = auto_snapshot_policy_name  # type: str
        self.time_points = time_points  # type: str
        self.repeat_weekdays = repeat_weekdays  # type: str
        self.retention_days = retention_days  # type: int
        self.enable_cross_region_copy = enable_cross_region_copy  # type: bool
        self.target_copy_regions = target_copy_regions  # type: str
        self.copied_snapshots_retention_days = copied_snapshots_retention_days  # type: int
        self.tag = tag                  # type: List[CreateAutoSnapshotPolicyRequestTag]

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.time_points, 'time_points')
        self.validate_required(self.repeat_weekdays, 'repeat_weekdays')
        self.validate_required(self.retention_days, 'retention_days')
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['autoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        result['timePoints'] = self.time_points
        result['repeatWeekdays'] = self.repeat_weekdays
        result['retentionDays'] = self.retention_days
        result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        result['TargetCopyRegions'] = self.target_copy_regions
        result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        else:
            result['Tag'] = None
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.auto_snapshot_policy_name = map.get('autoSnapshotPolicyName')
        self.time_points = map.get('timePoints')
        self.repeat_weekdays = map.get('repeatWeekdays')
        self.retention_days = map.get('retentionDays')
        self.enable_cross_region_copy = map.get('EnableCrossRegionCopy')
        self.target_copy_regions = map.get('TargetCopyRegions')
        self.copied_snapshots_retention_days = map.get('CopiedSnapshotsRetentionDays')
        self.tag = []
        if map.get('Tag') is not None:
            for k in map.get('Tag'):
                temp_model = CreateAutoSnapshotPolicyRequestTag()
                self.tag.append(temp_model.from_map(k))
        else:
            self.tag = None
        return self


class CreateAutoSnapshotPolicyRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key                  # type: str
        self.value = value              # type: str

    def validate(self):
        pass

    def to_map(self):
        result = {}
        result['Key'] = self.key
        result['Value'] = self.value
        return result

    def from_map(self, map={}):
        self.key = map.get('Key')
        self.value = map.get('Value')
        return self


class CreateAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, request_id=None, auto_snapshot_policy_id=None):
        self.request_id = request_id    # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        self.auto_snapshot_policy_id = map.get('AutoSnapshotPolicyId')
        return self


class CancelAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, region_id=None, disk_ids=None):
        self.region_id = region_id      # type: str
        self.disk_ids = disk_ids        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.disk_ids, 'disk_ids')

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['diskIds'] = self.disk_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.disk_ids = map.get('diskIds')
        return self


class CancelAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class ApplyAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, region_id=None, auto_snapshot_policy_id=None, disk_ids=None):
        self.region_id = region_id      # type: str
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.disk_ids = disk_ids        # type: str

    def validate(self):
        self.validate_required(self.region_id, 'region_id')
        self.validate_required(self.auto_snapshot_policy_id, 'auto_snapshot_policy_id')
        self.validate_required(self.disk_ids, 'disk_ids')

    def to_map(self):
        result = {}
        result['regionId'] = self.region_id
        result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        result['diskIds'] = self.disk_ids
        return result

    def from_map(self, map={}):
        self.region_id = map.get('regionId')
        self.auto_snapshot_policy_id = map.get('autoSnapshotPolicyId')
        self.disk_ids = map.get('diskIds')
        return self


class ApplyAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id    # type: str

    def validate(self):
        self.validate_required(self.request_id, 'request_id')

    def to_map(self):
        result = {}
        result['RequestId'] = self.request_id
        return result

    def from_map(self, map={}):
        self.request_id = map.get('RequestId')
        return self


class DescribeImageSupportInstanceTypesRequest(TeaModel):
    def __init__(self, region_id=None, image_id=None, action_type=None, filter=None):
        self.region_id = region_id      # type: str
        self.image_id = image_id        # type: str
        self.action_type = action_type  # type: str
        self.filter = filter            # type: List[DescribeImageSupportInstanceTypesRequestFilter]

    def validate(self):
        self.validate_required(self.region_id, 'regi