# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class AddClusterServiceRequestService(TeaModel):
    def __init__(
        self,
        service_version: str = None,
        service_name: str = None,
    ):
        self.service_version = service_version
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class AddClusterServiceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        comment: str = None,
        cluster_id: str = None,
        service: List[AddClusterServiceRequestService] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.comment = comment
        self.cluster_id = cluster_id
        self.service = service

    def validate(self):
        if self.service:
            for k in self.service:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        result['Service'] = []
        if self.service is not None:
            for k in self.service:
                result['Service'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        self.service = []
        if m.get('Service') is not None:
            for k in m.get('Service'):
                temp_model = AddClusterServiceRequestService()
                self.service.append(temp_model.from_map(k))
        return self


class AddClusterServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddClusterServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddClusterServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddClusterServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddScalingConfigItemV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        scaling_group_biz_id: str = None,
        config_item_type: str = None,
        config_item_information: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.config_item_type = config_item_type
        self.config_item_information = config_item_information

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        return self


class AddScalingConfigItemV2ResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class AddScalingConfigItemV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddScalingConfigItemV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddScalingConfigItemV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeSecurityGroupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        biz_type: str = None,
        biz_content: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.biz_type = biz_type
        self.biz_content = biz_content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.biz_content is not None:
            result['BizContent'] = self.biz_content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('BizContent') is not None:
            self.biz_content = m.get('BizContent')
        return self


class AuthorizeSecurityGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeSecurityGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AuthorizeSecurityGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AuthorizeSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOrderRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CancelOrderResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cluster_id: str = None,
    ):
        self.request_id = request_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        return self


class CancelOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneFlowRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CloneFlowResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CloneFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloneFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloneFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneFlowJobRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        name: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.name = name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CloneFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CloneFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloneFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloneFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        backup_plan_id: str = None,
        metadata_type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.backup_plan_id = backup_plan_id
        self.metadata_type = metadata_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.backup_plan_id is not None:
            result['BackupPlanId'] = self.backup_plan_id
        if self.metadata_type is not None:
            result['MetadataType'] = self.metadata_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BackupPlanId') is not None:
            self.backup_plan_id = m.get('BackupPlanId')
        if m.get('MetadataType') is not None:
            self.metadata_type = m.get('MetadataType')
        return self


class CreateBackupResponseBody(TeaModel):
    def __init__(
        self,
        trigger_type: str = None,
        end_time: int = None,
        request_id: str = None,
        gmt_modified: int = None,
        start_time: int = None,
        task_status: str = None,
        task_detail: str = None,
        trigger_user: str = None,
        gmt_create: int = None,
        task_process: int = None,
        cluster_biz_id: str = None,
        task_type: str = None,
        biz_id: str = None,
        data_source_id: int = None,
        host_name: str = None,
        ecm_task_id: int = None,
        task_result_detail: str = None,
    ):
        self.trigger_type = trigger_type
        self.end_time = end_time
        self.request_id = request_id
        self.gmt_modified = gmt_modified
        self.start_time = start_time
        self.task_status = task_status
        self.task_detail = task_detail
        self.trigger_user = trigger_user
        self.gmt_create = gmt_create
        self.task_process = task_process
        self.cluster_biz_id = cluster_biz_id
        self.task_type = task_type
        self.biz_id = biz_id
        self.data_source_id = data_source_id
        self.host_name = host_name
        self.ecm_task_id = ecm_task_id
        self.task_result_detail = task_result_detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.trigger_type is not None:
            result['TriggerType'] = self.trigger_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_detail is not None:
            result['TaskDetail'] = self.task_detail
        if self.trigger_user is not None:
            result['TriggerUser'] = self.trigger_user
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.task_process is not None:
            result['TaskProcess'] = self.task_process
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.data_source_id is not None:
            result['DataSourceId'] = self.data_source_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.ecm_task_id is not None:
            result['EcmTaskId'] = self.ecm_task_id
        if self.task_result_detail is not None:
            result['TaskResultDetail'] = self.task_result_detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TriggerType') is not None:
            self.trigger_type = m.get('TriggerType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskDetail') is not None:
            self.task_detail = m.get('TaskDetail')
        if m.get('TriggerUser') is not None:
            self.trigger_user = m.get('TriggerUser')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('TaskProcess') is not None:
            self.task_process = m.get('TaskProcess')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('DataSourceId') is not None:
            self.data_source_id = m.get('DataSourceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('EcmTaskId') is not None:
            self.ecm_task_id = m.get('EcmTaskId')
        if m.get('TaskResultDetail') is not None:
            self.task_result_detail = m.get('TaskResultDetail')
        return self


class CreateBackupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBackupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupPlanRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        name: str = None,
        description: str = None,
        cluster_id: str = None,
        root_path: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.name = name
        self.description = description
        self.cluster_id = cluster_id
        self.root_path = root_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.root_path is not None:
            result['RootPath'] = self.root_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RootPath') is not None:
            self.root_path = m.get('RootPath')
        return self


class CreateBackupPlanResponseBody(TeaModel):
    def __init__(
        self,
        root_path: str = None,
        description: str = None,
        request_id: str = None,
        cluster_id: str = None,
        id: str = None,
        name: str = None,
    ):
        self.root_path = root_path
        self.description = description
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.root_path is not None:
            result['RootPath'] = self.root_path
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RootPath') is not None:
            self.root_path = m.get('RootPath')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateBackupPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBackupPlanResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBackupPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterBootstrapActionRequestBootstrapAction(TeaModel):
    def __init__(
        self,
        execution_fail_strategy: str = None,
        arg: str = None,
        path: str = None,
        execution_target: str = None,
        execution_moment: str = None,
        name: str = None,
    ):
        self.execution_fail_strategy = execution_fail_strategy
        self.arg = arg
        self.path = path
        self.execution_target = execution_target
        self.execution_moment = execution_moment
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_fail_strategy is not None:
            result['ExecutionFailStrategy'] = self.execution_fail_strategy
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.execution_target is not None:
            result['ExecutionTarget'] = self.execution_target
        if self.execution_moment is not None:
            result['ExecutionMoment'] = self.execution_moment
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecutionFailStrategy') is not None:
            self.execution_fail_strategy = m.get('ExecutionFailStrategy')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('ExecutionTarget') is not None:
            self.execution_target = m.get('ExecutionTarget')
        if m.get('ExecutionMoment') is not None:
            self.execution_moment = m.get('ExecutionMoment')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateClusterBootstrapActionRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        bootstrap_action: List[CreateClusterBootstrapActionRequestBootstrapAction] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = CreateClusterBootstrapActionRequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class CreateClusterBootstrapActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateClusterBootstrapActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterBootstrapActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterBootstrapActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterTemplateRequestHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        comment: str = None,
        multi_instance_types: str = None,
        sys_disk_type: str = None,
        auto_renew: bool = None,
        charge_type: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        disk_count: int = None,
        create_type: str = None,
        period: int = None,
        disk_capacity: int = None,
        v_switch_id: str = None,
        node_count: int = None,
        host_group_name: str = None,
        cluster_id: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.comment = comment
        self.multi_instance_types = multi_instance_types
        self.sys_disk_type = sys_disk_type
        self.auto_renew = auto_renew
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.create_type = create_type
        self.period = period
        self.disk_capacity = disk_capacity
        self.v_switch_id = v_switch_id
        self.node_count = node_count
        self.host_group_name = host_group_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CreateClusterTemplateRequestBootstrapAction(TeaModel):
    def __init__(
        self,
        execution_fail_strategy: str = None,
        arg: str = None,
        path: str = None,
        execution_target: str = None,
        execution_moment: str = None,
        name: str = None,
    ):
        self.execution_fail_strategy = execution_fail_strategy
        self.arg = arg
        self.path = path
        self.execution_target = execution_target
        self.execution_moment = execution_moment
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_fail_strategy is not None:
            result['ExecutionFailStrategy'] = self.execution_fail_strategy
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.execution_target is not None:
            result['ExecutionTarget'] = self.execution_target
        if self.execution_moment is not None:
            result['ExecutionMoment'] = self.execution_moment
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecutionFailStrategy') is not None:
            self.execution_fail_strategy = m.get('ExecutionFailStrategy')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('ExecutionTarget') is not None:
            self.execution_target = m.get('ExecutionTarget')
        if m.get('ExecutionMoment') is not None:
            self.execution_moment = m.get('ExecutionMoment')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateClusterTemplateRequestConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class CreateClusterTemplateRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateClusterTemplateRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        template_name: str = None,
        region_id: str = None,
        zone_id: str = None,
        log_path: str = None,
        security_group_id: str = None,
        is_open_public_ip: bool = None,
        security_group_name: str = None,
        period: int = None,
        auto_renew: bool = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        net_type: str = None,
        user_defined_emr_ecs_role: str = None,
        emr_ver: str = None,
        cluster_type: str = None,
        high_availability_enable: bool = None,
        use_local_meta_db: bool = None,
        io_optimized: bool = None,
        ssh_enable: bool = None,
        instance_generation: str = None,
        master_pwd: str = None,
        key_pair_name: str = None,
        meta_store_type: str = None,
        meta_store_conf: str = None,
        configurations: str = None,
        eas_enable: bool = None,
        deposit_type: str = None,
        machine_type: str = None,
        use_custom_hive_meta_db: bool = None,
        init_custom_hive_meta_db: bool = None,
        resource_group_id: str = None,
        option_soft_ware_list: List[str] = None,
        host_group: List[CreateClusterTemplateRequestHostGroup] = None,
        bootstrap_action: List[CreateClusterTemplateRequestBootstrapAction] = None,
        config: List[CreateClusterTemplateRequestConfig] = None,
        tag: List[CreateClusterTemplateRequestTag] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.template_name = template_name
        self.region_id = region_id
        self.zone_id = zone_id
        self.log_path = log_path
        self.security_group_id = security_group_id
        self.is_open_public_ip = is_open_public_ip
        self.security_group_name = security_group_name
        self.period = period
        self.auto_renew = auto_renew
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.net_type = net_type
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.high_availability_enable = high_availability_enable
        self.use_local_meta_db = use_local_meta_db
        self.io_optimized = io_optimized
        self.ssh_enable = ssh_enable
        self.instance_generation = instance_generation
        self.master_pwd = master_pwd
        self.key_pair_name = key_pair_name
        self.meta_store_type = meta_store_type
        self.meta_store_conf = meta_store_conf
        self.configurations = configurations
        self.eas_enable = eas_enable
        self.deposit_type = deposit_type
        self.machine_type = machine_type
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.resource_group_id = resource_group_id
        self.option_soft_ware_list = option_soft_ware_list
        self.host_group = host_group
        self.bootstrap_action = bootstrap_action
        self.config = config
        self.tag = tag

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.period is not None:
            result['Period'] = self.period
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.ssh_enable is not None:
            result['SshEnable'] = self.ssh_enable
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.option_soft_ware_list is not None:
            result['OptionSoftWareList'] = self.option_soft_ware_list
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('SshEnable') is not None:
            self.ssh_enable = m.get('SshEnable')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('OptionSoftWareList') is not None:
            self.option_soft_ware_list = m.get('OptionSoftWareList')
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = CreateClusterTemplateRequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = CreateClusterTemplateRequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateClusterTemplateRequestConfig()
                self.config.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateClusterTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateClusterTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cluster_template_id: str = None,
    ):
        self.request_id = request_id
        self.cluster_template_id = cluster_template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_template_id is not None:
            result['ClusterTemplateId'] = self.cluster_template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterTemplateId') is not None:
            self.cluster_template_id = m.get('ClusterTemplateId')
        return self


class CreateClusterTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterV2RequestUserInfo(TeaModel):
    def __init__(
        self,
        password: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.password = password
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateClusterV2RequestHostComponentInfo(TeaModel):
    def __init__(
        self,
        component_name_list: List[str] = None,
        host_name: str = None,
        service_name: str = None,
    ):
        self.component_name_list = component_name_list
        self.host_name = host_name
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_name_list is not None:
            result['ComponentNameList'] = self.component_name_list
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentNameList') is not None:
            self.component_name_list = m.get('ComponentNameList')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CreateClusterV2RequestServiceInfo(TeaModel):
    def __init__(
        self,
        service_version: str = None,
        service_name: str = None,
    ):
        self.service_version = service_version
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CreateClusterV2RequestPromotionInfo(TeaModel):
    def __init__(
        self,
        promotion_option_no: str = None,
        promotion_option_code: str = None,
        product_code: str = None,
    ):
        self.promotion_option_no = promotion_option_no
        self.promotion_option_code = promotion_option_code
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.promotion_option_no is not None:
            result['PromotionOptionNo'] = self.promotion_option_no
        if self.promotion_option_code is not None:
            result['PromotionOptionCode'] = self.promotion_option_code
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PromotionOptionNo') is not None:
            self.promotion_option_no = m.get('PromotionOptionNo')
        if m.get('PromotionOptionCode') is not None:
            self.promotion_option_code = m.get('PromotionOptionCode')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class CreateClusterV2RequestHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        comment: str = None,
        sys_disk_type: str = None,
        auto_renew: bool = None,
        charge_type: str = None,
        gpu_driver: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        disk_count: int = None,
        create_type: str = None,
        period: int = None,
        disk_capacity: int = None,
        v_switch_id: str = None,
        node_count: int = None,
        host_group_name: str = None,
        cluster_id: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.comment = comment
        self.sys_disk_type = sys_disk_type
        self.auto_renew = auto_renew
        self.charge_type = charge_type
        self.gpu_driver = gpu_driver
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.create_type = create_type
        self.period = period
        self.disk_capacity = disk_capacity
        self.v_switch_id = v_switch_id
        self.node_count = node_count
        self.host_group_name = host_group_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.gpu_driver is not None:
            result['GpuDriver'] = self.gpu_driver
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('GpuDriver') is not None:
            self.gpu_driver = m.get('GpuDriver')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CreateClusterV2RequestBootstrapAction(TeaModel):
    def __init__(
        self,
        execution_fail_strategy: str = None,
        arg: str = None,
        path: str = None,
        execution_target: str = None,
        execution_moment: str = None,
        name: str = None,
    ):
        self.execution_fail_strategy = execution_fail_strategy
        self.arg = arg
        self.path = path
        self.execution_target = execution_target
        self.execution_moment = execution_moment
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_fail_strategy is not None:
            result['ExecutionFailStrategy'] = self.execution_fail_strategy
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.execution_target is not None:
            result['ExecutionTarget'] = self.execution_target
        if self.execution_moment is not None:
            result['ExecutionMoment'] = self.execution_moment
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecutionFailStrategy') is not None:
            self.execution_fail_strategy = m.get('ExecutionFailStrategy')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('ExecutionTarget') is not None:
            self.execution_target = m.get('ExecutionTarget')
        if m.get('ExecutionMoment') is not None:
            self.execution_moment = m.get('ExecutionMoment')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateClusterV2RequestConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class CreateClusterV2RequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateClusterV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        name: str = None,
        region_id: str = None,
        zone_id: str = None,
        log_path: str = None,
        security_group_id: str = None,
        is_open_public_ip: bool = None,
        security_group_name: str = None,
        charge_type: str = None,
        period: int = None,
        auto_renew: bool = None,
        auto_pay_order: bool = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        net_type: str = None,
        user_defined_emr_ecs_role: str = None,
        emr_ver: str = None,
        cluster_type: str = None,
        high_availability_enable: bool = None,
        use_local_meta_db: bool = None,
        io_optimized: bool = None,
        ssh_enable: bool = None,
        instance_generation: str = None,
        master_pwd: str = None,
        key_pair_name: str = None,
        meta_store_type: str = None,
        meta_store_conf: str = None,
        click_house_conf: str = None,
        extra_attributes: str = None,
        deposit_type: str = None,
        machine_type: str = None,
        use_custom_hive_meta_db: bool = None,
        init_custom_hive_meta_db: bool = None,
        configurations: str = None,
        eas_enable: bool = None,
        related_cluster_id: str = None,
        white_list_type: str = None,
        authorize_content: str = None,
        resource_group_id: str = None,
        option_soft_ware_list: List[str] = None,
        user_info: List[CreateClusterV2RequestUserInfo] = None,
        host_component_info: List[CreateClusterV2RequestHostComponentInfo] = None,
        service_info: List[CreateClusterV2RequestServiceInfo] = None,
        promotion_info: List[CreateClusterV2RequestPromotionInfo] = None,
        host_group: List[CreateClusterV2RequestHostGroup] = None,
        bootstrap_action: List[CreateClusterV2RequestBootstrapAction] = None,
        config: List[CreateClusterV2RequestConfig] = None,
        tag: List[CreateClusterV2RequestTag] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.name = name
        self.region_id = region_id
        self.zone_id = zone_id
        self.log_path = log_path
        self.security_group_id = security_group_id
        self.is_open_public_ip = is_open_public_ip
        self.security_group_name = security_group_name
        self.charge_type = charge_type
        self.period = period
        self.auto_renew = auto_renew
        self.auto_pay_order = auto_pay_order
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.net_type = net_type
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.high_availability_enable = high_availability_enable
        self.use_local_meta_db = use_local_meta_db
        self.io_optimized = io_optimized
        self.ssh_enable = ssh_enable
        self.instance_generation = instance_generation
        self.master_pwd = master_pwd
        self.key_pair_name = key_pair_name
        self.meta_store_type = meta_store_type
        self.meta_store_conf = meta_store_conf
        self.click_house_conf = click_house_conf
        self.extra_attributes = extra_attributes
        self.deposit_type = deposit_type
        self.machine_type = machine_type
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.configurations = configurations
        self.eas_enable = eas_enable
        self.related_cluster_id = related_cluster_id
        self.white_list_type = white_list_type
        self.authorize_content = authorize_content
        self.resource_group_id = resource_group_id
        self.option_soft_ware_list = option_soft_ware_list
        self.user_info = user_info
        self.host_component_info = host_component_info
        self.service_info = service_info
        self.promotion_info = promotion_info
        self.host_group = host_group
        self.bootstrap_action = bootstrap_action
        self.config = config
        self.tag = tag

    def validate(self):
        if self.user_info:
            for k in self.user_info:
                if k:
                    k.validate()
        if self.host_component_info:
            for k in self.host_component_info:
                if k:
                    k.validate()
        if self.service_info:
            for k in self.service_info:
                if k:
                    k.validate()
        if self.promotion_info:
            for k in self.promotion_info:
                if k:
                    k.validate()
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_pay_order is not None:
            result['AutoPayOrder'] = self.auto_pay_order
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.ssh_enable is not None:
            result['SshEnable'] = self.ssh_enable
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.click_house_conf is not None:
            result['ClickHouseConf'] = self.click_house_conf
        if self.extra_attributes is not None:
            result['ExtraAttributes'] = self.extra_attributes
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDB'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDB'] = self.init_custom_hive_meta_db
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.related_cluster_id is not None:
            result['RelatedClusterId'] = self.related_cluster_id
        if self.white_list_type is not None:
            result['WhiteListType'] = self.white_list_type
        if self.authorize_content is not None:
            result['AuthorizeContent'] = self.authorize_content
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.option_soft_ware_list is not None:
            result['OptionSoftWareList'] = self.option_soft_ware_list
        result['UserInfo'] = []
        if self.user_info is not None:
            for k in self.user_info:
                result['UserInfo'].append(k.to_map() if k else None)
        result['HostComponentInfo'] = []
        if self.host_component_info is not None:
            for k in self.host_component_info:
                result['HostComponentInfo'].append(k.to_map() if k else None)
        result['ServiceInfo'] = []
        if self.service_info is not None:
            for k in self.service_info:
                result['ServiceInfo'].append(k.to_map() if k else None)
        result['PromotionInfo'] = []
        if self.promotion_info is not None:
            for k in self.promotion_info:
                result['PromotionInfo'].append(k.to_map() if k else None)
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoPayOrder') is not None:
            self.auto_pay_order = m.get('AutoPayOrder')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('SshEnable') is not None:
            self.ssh_enable = m.get('SshEnable')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('ClickHouseConf') is not None:
            self.click_house_conf = m.get('ClickHouseConf')
        if m.get('ExtraAttributes') is not None:
            self.extra_attributes = m.get('ExtraAttributes')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseCustomHiveMetaDB') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDB')
        if m.get('InitCustomHiveMetaDB') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDB')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('RelatedClusterId') is not None:
            self.related_cluster_id = m.get('RelatedClusterId')
        if m.get('WhiteListType') is not None:
            self.white_list_type = m.get('WhiteListType')
        if m.get('AuthorizeContent') is not None:
            self.authorize_content = m.get('AuthorizeContent')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('OptionSoftWareList') is not None:
            self.option_soft_ware_list = m.get('OptionSoftWareList')
        self.user_info = []
        if m.get('UserInfo') is not None:
            for k in m.get('UserInfo'):
                temp_model = CreateClusterV2RequestUserInfo()
                self.user_info.append(temp_model.from_map(k))
        self.host_component_info = []
        if m.get('HostComponentInfo') is not None:
            for k in m.get('HostComponentInfo'):
                temp_model = CreateClusterV2RequestHostComponentInfo()
                self.host_component_info.append(temp_model.from_map(k))
        self.service_info = []
        if m.get('ServiceInfo') is not None:
            for k in m.get('ServiceInfo'):
                temp_model = CreateClusterV2RequestServiceInfo()
                self.service_info.append(temp_model.from_map(k))
        self.promotion_info = []
        if m.get('PromotionInfo') is not None:
            for k in m.get('PromotionInfo'):
                temp_model = CreateClusterV2RequestPromotionInfo()
                self.promotion_info.append(temp_model.from_map(k))
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = CreateClusterV2RequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = CreateClusterV2RequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateClusterV2RequestConfig()
                self.config.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateClusterV2RequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateClusterV2ResponseBody(TeaModel):
    def __init__(
        self,
        master_order_id: str = None,
        core_order_id: str = None,
        request_id: str = None,
        emr_order_id: str = None,
        cluster_id: str = None,
    ):
        self.master_order_id = master_order_id
        self.core_order_id = core_order_id
        self.request_id = request_id
        self.emr_order_id = emr_order_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_order_id is not None:
            result['MasterOrderId'] = self.master_order_id
        if self.core_order_id is not None:
            result['CoreOrderId'] = self.core_order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.emr_order_id is not None:
            result['EmrOrderId'] = self.emr_order_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MasterOrderId') is not None:
            self.master_order_id = m.get('MasterOrderId')
        if m.get('CoreOrderId') is not None:
            self.core_order_id = m.get('CoreOrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EmrOrderId') is not None:
            self.emr_order_id = m.get('EmrOrderId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CreateClusterV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterWithTemplateRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        template_biz_id: str = None,
        unique_tag: str = None,
        cluster_name: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.template_biz_id = template_biz_id
        self.unique_tag = unique_tag
        self.cluster_name = cluster_name
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_biz_id is not None:
            result['TemplateBizId'] = self.template_biz_id
        if self.unique_tag is not None:
            result['UniqueTag'] = self.unique_tag
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateBizId') is not None:
            self.template_biz_id = m.get('TemplateBizId')
        if m.get('UniqueTag') is not None:
            self.unique_tag = m.get('UniqueTag')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateClusterWithTemplateResponseBody(TeaModel):
    def __init__(
        self,
        master_order_id: str = None,
        core_order_id: str = None,
        request_id: str = None,
        emr_order_id: str = None,
        cluster_id: str = None,
    ):
        self.master_order_id = master_order_id
        self.core_order_id = core_order_id
        self.request_id = request_id
        self.emr_order_id = emr_order_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_order_id is not None:
            result['MasterOrderId'] = self.master_order_id
        if self.core_order_id is not None:
            result['CoreOrderId'] = self.core_order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.emr_order_id is not None:
            result['EmrOrderId'] = self.emr_order_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MasterOrderId') is not None:
            self.master_order_id = m.get('MasterOrderId')
        if m.get('CoreOrderId') is not None:
            self.core_order_id = m.get('CoreOrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EmrOrderId') is not None:
            self.emr_order_id = m.get('EmrOrderId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CreateClusterWithTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterWithTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterWithTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataSourceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        name: str = None,
        source_type: str = None,
        description: str = None,
        conf: str = None,
        cluster_id: str = None,
        nav_parent_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.name = name
        self.source_type = source_type
        self.description = description
        self.conf = conf
        self.cluster_id = cluster_id
        self.nav_parent_id = nav_parent_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.description is not None:
            result['Description'] = self.description
        if self.conf is not None:
            result['Conf'] = self.conf
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.nav_parent_id is not None:
            result['NavParentId'] = self.nav_parent_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Conf') is not None:
            self.conf = m.get('Conf')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('NavParentId') is not None:
            self.nav_parent_id = m.get('NavParentId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateExecutionPlanRequestEcsOrder(TeaModel):
    def __init__(
        self,
        index: int = None,
        disk_capacity: int = None,
        node_type: str = None,
        node_count: int = None,
        disk_type: str = None,
        instance_type: str = None,
        disk_count: int = None,
    ):
        self.index = index
        self.disk_capacity = disk_capacity
        self.node_type = node_type
        self.node_count = node_count
        self.disk_type = disk_type
        self.instance_type = instance_type
        self.disk_count = disk_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        return self


class CreateExecutionPlanRequestBootstrapAction(TeaModel):
    def __init__(
        self,
        execution_fail_strategy: str = None,
        arg: str = None,
        path: str = None,
        execution_target: str = None,
        execution_moment: str = None,
        name: str = None,
    ):
        self.execution_fail_strategy = execution_fail_strategy
        self.arg = arg
        self.path = path
        self.execution_target = execution_target
        self.execution_moment = execution_moment
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_fail_strategy is not None:
            result['ExecutionFailStrategy'] = self.execution_fail_strategy
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.execution_target is not None:
            result['ExecutionTarget'] = self.execution_target
        if self.execution_moment is not None:
            result['ExecutionMoment'] = self.execution_moment
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExecutionFailStrategy') is not None:
            self.execution_fail_strategy = m.get('ExecutionFailStrategy')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('ExecutionTarget') is not None:
            self.execution_target = m.get('ExecutionTarget')
        if m.get('ExecutionMoment') is not None:
            self.execution_moment = m.get('ExecutionMoment')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateExecutionPlanRequestConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class CreateExecutionPlanRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        name: str = None,
        strategy: str = None,
        time_interval: int = None,
        start_time: int = None,
        time_unit: str = None,
        day_of_week: str = None,
        day_of_month: str = None,
        cluster_id: str = None,
        create_cluster_on_demand: bool = None,
        cluster_name: str = None,
        zone_id: str = None,
        log_enable: bool = None,
        log_path: str = None,
        security_group_id: str = None,
        is_open_public_ip: bool = None,
        emr_ver: str = None,
        cluster_type: str = None,
        high_availability_enable: bool = None,
        use_local_meta_db: bool = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        net_type: str = None,
        user_defined_emr_ecs_role: str = None,
        io_optimized: bool = None,
        instance_generation: str = None,
        use_custom_hive_meta_db: bool = None,
        init_custom_hive_meta_db: bool = None,
        configurations: str = None,
        eas_enable: bool = None,
        workflow_definition: str = None,
        job_id_list: List[str] = None,
        option_soft_ware_list: List[str] = None,
        ecs_order: List[CreateExecutionPlanRequestEcsOrder] = None,
        bootstrap_action: List[CreateExecutionPlanRequestBootstrapAction] = None,
        config: List[CreateExecutionPlanRequestConfig] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.name = name
        self.strategy = strategy
        self.time_interval = time_interval
        self.start_time = start_time
        self.time_unit = time_unit
        self.day_of_week = day_of_week
        self.day_of_month = day_of_month
        self.cluster_id = cluster_id
        self.create_cluster_on_demand = create_cluster_on_demand
        self.cluster_name = cluster_name
        self.zone_id = zone_id
        self.log_enable = log_enable
        self.log_path = log_path
        self.security_group_id = security_group_id
        self.is_open_public_ip = is_open_public_ip
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.high_availability_enable = high_availability_enable
        self.use_local_meta_db = use_local_meta_db
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.net_type = net_type
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.io_optimized = io_optimized
        self.instance_generation = instance_generation
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.configurations = configurations
        self.eas_enable = eas_enable
        self.workflow_definition = workflow_definition
        self.job_id_list = job_id_list
        self.option_soft_ware_list = option_soft_ware_list
        self.ecs_order = ecs_order
        self.bootstrap_action = bootstrap_action
        self.config = config

    def validate(self):
        if self.ecs_order:
            for k in self.ecs_order:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.time_unit is not None:
            result['TimeUnit'] = self.time_unit
        if self.day_of_week is not None:
            result['DayOfWeek'] = self.day_of_week
        if self.day_of_month is not None:
            result['DayOfMonth'] = self.day_of_month
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.create_cluster_on_demand is not None:
            result['CreateClusterOnDemand'] = self.create_cluster_on_demand
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDB'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDB'] = self.init_custom_hive_meta_db
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.workflow_definition is not None:
            result['WorkflowDefinition'] = self.workflow_definition
        if self.job_id_list is not None:
            result['JobIdList'] = self.job_id_list
        if self.option_soft_ware_list is not None:
            result['OptionSoftWareList'] = self.option_soft_ware_list
        result['EcsOrder'] = []
        if self.ecs_order is not None:
            for k in self.ecs_order:
                result['EcsOrder'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TimeUnit') is not None:
            self.time_unit = m.get('TimeUnit')
        if m.get('DayOfWeek') is not None:
            self.day_of_week = m.get('DayOfWeek')
        if m.get('DayOfMonth') is not None:
            self.day_of_month = m.get('DayOfMonth')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CreateClusterOnDemand') is not None:
            self.create_cluster_on_demand = m.get('CreateClusterOnDemand')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('UseCustomHiveMetaDB') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDB')
        if m.get('InitCustomHiveMetaDB') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDB')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('WorkflowDefinition') is not None:
            self.workflow_definition = m.get('WorkflowDefinition')
        if m.get('JobIdList') is not None:
            self.job_id_list = m.get('JobIdList')
        if m.get('OptionSoftWareList') is not None:
            self.option_soft_ware_list = m.get('OptionSoftWareList')
        self.ecs_order = []
        if m.get('EcsOrder') is not None:
            for k in m.get('EcsOrder'):
                temp_model = CreateExecutionPlanRequestEcsOrder()
                self.ecs_order.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = CreateExecutionPlanRequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateExecutionPlanRequestConfig()
                self.config.append(temp_model.from_map(k))
        return self


class CreateExecutionPlanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateExecutionPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateExecutionPlanResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateExecutionPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        name: str = None,
        description: str = None,
        start_schedule: int = None,
        end_schedule: int = None,
        cron_expr: str = None,
        create_cluster: bool = None,
        cluster_id: str = None,
        host_name: str = None,
        namespace: str = None,
        log_archive_location: str = None,
        lifecycle: str = None,
        application: str = None,
        alert_conf: str = None,
        alert_user_group_biz_id: str = None,
        alert_ding_ding_group_biz_id: str = None,
        parent_flow_list: str = None,
        parent_category: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.name = name
        self.description = description
        self.start_schedule = start_schedule
        self.end_schedule = end_schedule
        self.cron_expr = cron_expr
        self.create_cluster = create_cluster
        self.cluster_id = cluster_id
        self.host_name = host_name
        self.namespace = namespace
        self.log_archive_location = log_archive_location
        self.lifecycle = lifecycle
        self.application = application
        self.alert_conf = alert_conf
        self.alert_user_group_biz_id = alert_user_group_biz_id
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id
        self.parent_flow_list = parent_flow_list
        self.parent_category = parent_category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.log_archive_location is not None:
            result['LogArchiveLocation'] = self.log_archive_location
        if self.lifecycle is not None:
            result['Lifecycle'] = self.lifecycle
        if self.application is not None:
            result['Application'] = self.application
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('LogArchiveLocation') is not None:
            self.log_archive_location = m.get('LogArchiveLocation')
        if m.get('Lifecycle') is not None:
            self.lifecycle = m.get('Lifecycle')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('ParentFlowList') is not None:
            self.parent_flow_list = m.get('ParentFlowList')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        return self


class CreateFlowResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowCategoryRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        name: str = None,
        type: str = None,
        parent_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.name = name
        self.type = type
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class CreateFlowCategoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateFlowCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowForWebRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        name: str = None,
        description: str = None,
        start_schedule: int = None,
        end_schedule: int = None,
        cron_expr: str = None,
        create_cluster: bool = None,
        cluster_id: str = None,
        host_name: str = None,
        namespace: str = None,
        log_archive_location: str = None,
        lifecycle: str = None,
        graph: str = None,
        alert_conf: str = None,
        alert_user_group_biz_id: str = None,
        alert_ding_ding_group_biz_id: str = None,
        parent_flow_list: str = None,
        parent_category: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.name = name
        self.description = description
        self.start_schedule = start_schedule
        self.end_schedule = end_schedule
        self.cron_expr = cron_expr
        self.create_cluster = create_cluster
        self.cluster_id = cluster_id
        self.host_name = host_name
        self.namespace = namespace
        self.log_archive_location = log_archive_location
        self.lifecycle = lifecycle
        self.graph = graph
        self.alert_conf = alert_conf
        self.alert_user_group_biz_id = alert_user_group_biz_id
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id
        self.parent_flow_list = parent_flow_list
        self.parent_category = parent_category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.log_archive_location is not None:
            result['LogArchiveLocation'] = self.log_archive_location
        if self.lifecycle is not None:
            result['Lifecycle'] = self.lifecycle
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('LogArchiveLocation') is not None:
            self.log_archive_location = m.get('LogArchiveLocation')
        if m.get('Lifecycle') is not None:
            self.lifecycle = m.get('Lifecycle')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('ParentFlowList') is not None:
            self.parent_flow_list = m.get('ParentFlowList')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        return self


class CreateFlowForWebResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateFlowForWebResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowForWebResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowForWebResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowJobRequestResourceList(TeaModel):
    def __init__(
        self,
        path: str = None,
        alias: str = None,
    ):
        self.path = path
        self.alias = alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class CreateFlowJobRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        name: str = None,
        description: str = None,
        type: str = None,
        fail_act: str = None,
        max_retry: int = None,
        retry_policy: str = None,
        max_running_time_sec: int = None,
        retry_interval: int = None,
        params: str = None,
        param_conf: str = None,
        custom_variables: str = None,
        env_conf: str = None,
        run_conf: str = None,
        monitor_conf: str = None,
        mode: str = None,
        parent_category: str = None,
        adhoc: bool = None,
        cluster_id: str = None,
        alert_conf: str = None,
        resource_list: List[CreateFlowJobRequestResourceList] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.name = name
        self.description = description
        self.type = type
        self.fail_act = fail_act
        self.max_retry = max_retry
        self.retry_policy = retry_policy
        self.max_running_time_sec = max_running_time_sec
        self.retry_interval = retry_interval
        self.params = params
        self.param_conf = param_conf
        self.custom_variables = custom_variables
        self.env_conf = env_conf
        self.run_conf = run_conf
        self.monitor_conf = monitor_conf
        self.mode = mode
        self.parent_category = parent_category
        self.adhoc = adhoc
        self.cluster_id = cluster_id
        self.alert_conf = alert_conf
        self.resource_list = resource_list

    def validate(self):
        if self.resource_list:
            for k in self.resource_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.max_running_time_sec is not None:
            result['MaxRunningTimeSec'] = self.max_running_time_sec
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.params is not None:
            result['Params'] = self.params
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        result['ResourceList'] = []
        if self.resource_list is not None:
            for k in self.resource_list:
                result['ResourceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('MaxRunningTimeSec') is not None:
            self.max_running_time_sec = m.get('MaxRunningTimeSec')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        self.resource_list = []
        if m.get('ResourceList') is not None:
            for k in m.get('ResourceList'):
                temp_model = CreateFlowJobRequestResourceList()
                self.resource_list.append(temp_model.from_map(k))
        return self


class CreateFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectRequest(TeaModel):
    def __init__(
        self,
        product_type: str = None,
        region_id: str = None,
        name: str = None,
        description: str = None,
        resource_group_id: str = None,
    ):
        self.product_type = product_type
        self.region_id = region_id
        self.name = name
        self.description = description
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateFlowProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateFlowProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectClusterSettingRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        cluster_id: str = None,
        default_user: str = None,
        default_queue: str = None,
        user_list: List[str] = None,
        queue_list: List[str] = None,
        host_list: List[str] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.cluster_id = cluster_id
        self.default_user = default_user
        self.default_queue = default_queue
        self.user_list = user_list
        self.queue_list = queue_list
        self.host_list = host_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.user_list is not None:
            result['UserList'] = self.user_list
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list
        if self.host_list is not None:
            result['HostList'] = self.host_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        if m.get('QueueList') is not None:
            self.queue_list = m.get('QueueList')
        if m.get('HostList') is not None:
            self.host_list = m.get('HostList')
        return self


class CreateFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateFlowProjectClusterSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowProjectClusterSettingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectUserRequestUser(TeaModel):
    def __init__(
        self,
        user_id: str = None,
        user_name: str = None,
    ):
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateFlowProjectUserRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        user: List[CreateFlowProjectUserRequestUser] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.user = user

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = CreateFlowProjectUserRequestUser()
                self.user.append(temp_model.from_map(k))
        return self


class CreateFlowProjectUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateFlowProjectUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowProjectUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJobRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        name: str = None,
        region_id: str = None,
        type: str = None,
        run_parameter: str = None,
        fail_act: str = None,
        max_retry: int = None,
        retry_interval: int = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.name = name
        self.region_id = region_id
        self.type = type
        self.run_parameter = run_parameter
        self.fail_act = fail_act
        self.max_retry = max_retry
        self.retry_interval = retry_interval
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.run_parameter is not None:
            result['RunParameter'] = self.run_parameter
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('RunParameter') is not None:
            self.run_parameter = m.get('RunParameter')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class CreateJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLibraryRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        type: str = None,
        name: str = None,
        library_version: str = None,
        source_type: str = None,
        source_location: str = None,
        scope: str = None,
        properties: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.type = type
        self.name = name
        self.library_version = library_version
        self.source_type = source_type
        self.source_location = source_location
        self.scope = scope
        self.properties = properties

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.library_version is not None:
            result['LibraryVersion'] = self.library_version
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_location is not None:
            result['SourceLocation'] = self.source_location
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.properties is not None:
            result['Properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('LibraryVersion') is not None:
            self.library_version = m.get('LibraryVersion')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceLocation') is not None:
            self.source_location = m.get('SourceLocation')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Properties') is not None:
            self.properties = m.get('Properties')
        return self


class CreateLibraryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateLibraryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLibraryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLibraryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetaTablePreviewTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        database_id: str = None,
        table_id: str = None,
        user: str = None,
        password: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.database_id = database_id
        self.table_id = table_id
        self.user = user
        self.password = password
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_id is not None:
            result['DatabaseId'] = self.database_id
        if self.table_id is not None:
            result['TableId'] = self.table_id
        if self.user is not None:
            result['User'] = self.user
        if self.password is not None:
            result['Password'] = self.password
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseId') is not None:
            self.database_id = m.get('DatabaseId')
        if m.get('TableId') is not None:
            self.table_id = m.get('TableId')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateMetaTablePreviewTaskResponseBody(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        request_id: str = None,
    ):
        self.task_id = task_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMetaTablePreviewTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMetaTablePreviewTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMetaTablePreviewTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateResourcePoolRequestConfig(TeaModel):
    def __init__(
        self,
        config_type: str = None,
        config_value: str = None,
        target_id: str = None,
        note: str = None,
        category: str = None,
        config_key: str = None,
    ):
        self.config_type = config_type
        self.config_value = config_value
        self.target_id = target_id
        self.note = note
        self.category = category
        self.config_key = config_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_type is not None:
            result['configType'] = self.config_type
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.note is not None:
            result['Note'] = self.note
        if self.category is not None:
            result['Category'] = self.category
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configType') is not None:
            self.config_type = m.get('configType')
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        return self


class CreateResourcePoolRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        name: str = None,
        cluster_id: str = None,
        pool_type: str = None,
        active: bool = None,
        note: str = None,
        yarn_site_config: str = None,
        config: List[CreateResourcePoolRequestConfig] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.name = name
        self.cluster_id = cluster_id
        self.pool_type = pool_type
        self.active = active
        self.note = note
        self.yarn_site_config = yarn_site_config
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.pool_type is not None:
            result['PoolType'] = self.pool_type
        if self.active is not None:
            result['Active'] = self.active
        if self.note is not None:
            result['Note'] = self.note
        if self.yarn_site_config is not None:
            result['YarnSiteConfig'] = self.yarn_site_config
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PoolType') is not None:
            self.pool_type = m.get('PoolType')
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('YarnSiteConfig') is not None:
            self.yarn_site_config = m.get('YarnSiteConfig')
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateResourcePoolRequestConfig()
                self.config.append(temp_model.from_map(k))
        return self


class CreateResourcePoolResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateResourcePoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateResourcePoolResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateResourcePoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateResourceQueueRequestConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        note: str = None,
        category: str = None,
        config_key: str = None,
    ):
        self.config_value = config_value
        self.note = note
        self.category = category
        self.config_key = config_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.note is not None:
            result['Note'] = self.note
        if self.category is not None:
            result['Category'] = self.category
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        return self


class CreateResourceQueueRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        name: str = None,
        qualified_name: str = None,
        cluster_id: str = None,
        parent_queue_id: int = None,
        leaf: bool = None,
        resource_pool_id: int = None,
        config: List[CreateResourceQueueRequestConfig] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.name = name
        self.qualified_name = qualified_name
        self.cluster_id = cluster_id
        self.parent_queue_id = parent_queue_id
        self.leaf = leaf
        self.resource_pool_id = resource_pool_id
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.qualified_name is not None:
            result['QualifiedName'] = self.qualified_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.parent_queue_id is not None:
            result['ParentQueueId'] = self.parent_queue_id
        if self.leaf is not None:
            result['Leaf'] = self.leaf
        if self.resource_pool_id is not None:
            result['ResourcePoolId'] = self.resource_pool_id
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QualifiedName') is not None:
            self.qualified_name = m.get('QualifiedName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ParentQueueId') is not None:
            self.parent_queue_id = m.get('ParentQueueId')
        if m.get('Leaf') is not None:
            self.leaf = m.get('Leaf')
        if m.get('ResourcePoolId') is not None:
            self.resource_pool_id = m.get('ResourcePoolId')
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateResourceQueueRequestConfig()
                self.config.append(temp_model.from_map(k))
        return self


class CreateResourceQueueResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateResourceQueueResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateResourceQueueResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateResourceQueueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScalingGroupV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        name: str = None,
        description: str = None,
        host_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.name = name
        self.description = description
        self.host_group_id = host_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        return self


class CreateScalingGroupV2ResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateScalingGroupV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateScalingGroupV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScalingGroupV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScalingRuleRequestSchedulerTrigger(TeaModel):
    def __init__(
        self,
        launch_expiration_time: int = None,
        recurrence_value: str = None,
        recurrence_type: str = None,
        recurrence_end_time: str = None,
        launch_time: str = None,
    ):
        self.launch_expiration_time = launch_expiration_time
        self.recurrence_value = recurrence_value
        self.recurrence_type = recurrence_type
        self.recurrence_end_time = recurrence_end_time
        self.launch_time = launch_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        return self


class CreateScalingRuleRequestCloudWatchTrigger(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        evaluation_count: str = None,
        threshold: str = None,
        period: int = None,
        statistics: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.metric_name = metric_name
        self.evaluation_count = evaluation_count
        self.threshold = threshold
        self.period = period
        self.statistics = statistics

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        return self


class CreateScalingRuleRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_group_id: str = None,
        rule_category: str = None,
        rule_name: str = None,
        adjustment_type: str = None,
        adjustment_value: int = None,
        cooldown: int = None,
        launch_time: str = None,
        launch_expiration_time: int = None,
        recurrence_type: str = None,
        recurrence_value: str = None,
        recurrence_end_time: str = None,
        with_grace: bool = None,
        timeout_with_grace: int = None,
        scheduler_trigger: List[CreateScalingRuleRequestSchedulerTrigger] = None,
        cloud_watch_trigger: List[CreateScalingRuleRequestCloudWatchTrigger] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_group_id = host_group_id
        self.rule_category = rule_category
        self.rule_name = rule_name
        self.adjustment_type = adjustment_type
        self.adjustment_value = adjustment_value
        self.cooldown = cooldown
        self.launch_time = launch_time
        self.launch_expiration_time = launch_expiration_time
        self.recurrence_type = recurrence_type
        self.recurrence_value = recurrence_value
        self.recurrence_end_time = recurrence_end_time
        self.with_grace = with_grace
        self.timeout_with_grace = timeout_with_grace
        self.scheduler_trigger = scheduler_trigger
        self.cloud_watch_trigger = cloud_watch_trigger

    def validate(self):
        if self.scheduler_trigger:
            for k in self.scheduler_trigger:
                if k:
                    k.validate()
        if self.cloud_watch_trigger:
            for k in self.cloud_watch_trigger:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.rule_category is not None:
            result['RuleCategory'] = self.rule_category
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.adjustment_type is not None:
            result['AdjustmentType'] = self.adjustment_type
        if self.adjustment_value is not None:
            result['AdjustmentValue'] = self.adjustment_value
        if self.cooldown is not None:
            result['Cooldown'] = self.cooldown
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        if self.with_grace is not None:
            result['WithGrace'] = self.with_grace
        if self.timeout_with_grace is not None:
            result['TimeoutWithGrace'] = self.timeout_with_grace
        result['SchedulerTrigger'] = []
        if self.scheduler_trigger is not None:
            for k in self.scheduler_trigger:
                result['SchedulerTrigger'].append(k.to_map() if k else None)
        result['CloudWatchTrigger'] = []
        if self.cloud_watch_trigger is not None:
            for k in self.cloud_watch_trigger:
                result['CloudWatchTrigger'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('RuleCategory') is not None:
            self.rule_category = m.get('RuleCategory')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('AdjustmentType') is not None:
            self.adjustment_type = m.get('AdjustmentType')
        if m.get('AdjustmentValue') is not None:
            self.adjustment_value = m.get('AdjustmentValue')
        if m.get('Cooldown') is not None:
            self.cooldown = m.get('Cooldown')
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        if m.get('WithGrace') is not None:
            self.with_grace = m.get('WithGrace')
        if m.get('TimeoutWithGrace') is not None:
            self.timeout_with_grace = m.get('TimeoutWithGrace')
        self.scheduler_trigger = []
        if m.get('SchedulerTrigger') is not None:
            for k in m.get('SchedulerTrigger'):
                temp_model = CreateScalingRuleRequestSchedulerTrigger()
                self.scheduler_trigger.append(temp_model.from_map(k))
        self.cloud_watch_trigger = []
        if m.get('CloudWatchTrigger') is not None:
            for k in m.get('CloudWatchTrigger'):
                temp_model = CreateScalingRuleRequestCloudWatchTrigger()
                self.cloud_watch_trigger.append(temp_model.from_map(k))
        return self


class CreateScalingRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_rule_id: str = None,
    ):
        self.request_id = request_id
        self.scaling_rule_id = scaling_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_rule_id is not None:
            result['ScalingRuleId'] = self.scaling_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingRuleId') is not None:
            self.scaling_rule_id = m.get('ScalingRuleId')
        return self


class CreateScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateScalingRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScalingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTagRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: int = None,
        name: str = None,
        category: str = None,
        description: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id
        self.name = name
        self.category = category
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreateTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateTagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUserRequestUserAccountParamList(TeaModel):
    def __init__(
        self,
        auth_type: str = None,
        account_password: str = None,
        account_type: str = None,
    ):
        self.auth_type = auth_type
        self.account_password = account_password
        self.account_type = account_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        return self


class CreateUserRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        aliyun_user_id: str = None,
        user_name: str = None,
        user_type: str = None,
        status: str = None,
        description: str = None,
        role_id_list: List[int] = None,
        group_id_list: List[int] = None,
        user_account_param_list: List[CreateUserRequestUserAccountParamList] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.aliyun_user_id = aliyun_user_id
        self.user_name = user_name
        self.user_type = user_type
        self.status = status
        self.description = description
        self.role_id_list = role_id_list
        self.group_id_list = group_id_list
        self.user_account_param_list = user_account_param_list

    def validate(self):
        if self.user_account_param_list:
            for k in self.user_account_param_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.aliyun_user_id is not None:
            result['AliyunUserId'] = self.aliyun_user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.user_type is not None:
            result['UserType'] = self.user_type
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.role_id_list is not None:
            result['RoleIdList'] = self.role_id_list
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        result['UserAccountParamList'] = []
        if self.user_account_param_list is not None:
            for k in self.user_account_param_list:
                result['UserAccountParamList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('AliyunUserId') is not None:
            self.aliyun_user_id = m.get('AliyunUserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RoleIdList') is not None:
            self.role_id_list = m.get('RoleIdList')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        self.user_account_param_list = []
        if m.get('UserAccountParamList') is not None:
            for k in m.get('UserAccountParamList'):
                temp_model = CreateUserRequestUserAccountParamList()
                self.user_account_param_list.append(temp_model.from_map(k))
        return self


class CreateUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        paging: bool = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.paging = paging
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.paging is not None:
            result['Paging'] = self.paging
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Paging') is not None:
            self.paging = m.get('Paging')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUsersRequestUserInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.type = type
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateUsersRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        user_info: List[CreateUsersRequestUserInfo] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.user_info = user_info

    def validate(self):
        if self.user_info:
            for k in self.user_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        result['UserInfo'] = []
        if self.user_info is not None:
            for k in self.user_info:
                result['UserInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        self.user_info = []
        if m.get('UserInfo') is not None:
            for k in m.get('UserInfo'):
                temp_model = CreateUsersRequestUserInfo()
                self.user_info.append(temp_model.from_map(k))
        return self


class CreateUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateUsersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DecommissionHostComponentRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_instance_id: str = None,
        service_name: str = None,
        component_name: str = None,
        timeout_seconds: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_instance_id = host_instance_id
        self.service_name = service_name
        self.component_name = component_name
        self.timeout_seconds = timeout_seconds

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class DecommissionHostComponentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DecommissionHostComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DecommissionHostComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DecommissionHostComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClusterTemplateRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        biz_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.biz_id = biz_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DeleteClusterTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteClusterTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteClusterTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteExecutionPlanRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteExecutionPlanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteExecutionPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteExecutionPlanResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteExecutionPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        project_id: str = None,
        region_id: str = None,
    ):
        self.id = id
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteFlowResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowCategoryRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        region_id: str = None,
        project_id: str = None,
    ):
        self.id = id
        self.region_id = region_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteFlowCategoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteFlowCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowJobRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DeleteFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteFlowProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteFlowProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectClusterSettingRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        cluster_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DeleteFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteFlowProjectClusterSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowProjectClusterSettingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectUserRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        user_name: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DeleteFlowProjectUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteFlowProjectUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowProjectUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        id: str = None,
        region_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.id = id
        self.region_id = region_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DeleteJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLibrariesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        library_biz_id_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.library_biz_id_list = library_biz_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.library_biz_id_list is not None:
            result['LibraryBizIdList'] = self.library_biz_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('LibraryBizIdList') is not None:
            self.library_biz_id_list = m.get('LibraryBizIdList')
        return self


class DeleteLibrariesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteLibrariesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLibrariesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteResourcePoolRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        resource_pool_id: str = None,
        cluster_id: str = None,
        region_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.resource_pool_id = resource_pool_id
        self.cluster_id = cluster_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_pool_id is not None:
            result['ResourcePoolId'] = self.resource_pool_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourcePoolId') is not None:
            self.resource_pool_id = m.get('ResourcePoolId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteResourcePoolResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteResourcePoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteResourcePoolResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteResourcePoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteResourceQueueRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        resource_queue_id: str = None,
        cluster_id: str = None,
        region_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.resource_queue_id = resource_queue_id
        self.cluster_id = cluster_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_queue_id is not None:
            result['ResourceQueueId'] = self.resource_queue_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceQueueId') is not None:
            self.resource_queue_id = m.get('ResourceQueueId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteResourceQueueResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteResourceQueueResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteResourceQueueResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteResourceQueueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteScalingRuleRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_group_id: str = None,
        scaling_rule_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_group_id = host_group_id
        self.scaling_rule_id = scaling_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.scaling_rule_id is not None:
            result['ScalingRuleId'] = self.scaling_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('ScalingRuleId') is not None:
            self.scaling_rule_id = m.get('ScalingRuleId')
        return self


class DeleteScalingRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteScalingRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteScalingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: int = None,
        name: str = None,
        category: str = None,
        description: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id
        self.name = name
        self.category = category
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DeleteTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DeleteTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        user_id: str = None,
        type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.user_id = user_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterBasicInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoRelateClusterInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        cluster_type: str = None,
        cluster_name: str = None,
        cluster_id: str = None,
    ):
        self.status = status
        self.cluster_type = cluster_type
        self.cluster_name = cluster_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoFailReason(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_msg: str = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_msg = error_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        start_tpe: int = None,
        version: str = None,
        only_display: bool = None,
        name: str = None,
    ):
        self.display_name = display_name
        self.start_tpe = start_tpe
        self.version = version
        self.only_display = only_display
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.start_tpe is not None:
            result['StartTpe'] = self.start_tpe
        if self.version is not None:
            result['Version'] = self.version
        if self.only_display is not None:
            result['OnlyDisplay'] = self.only_display
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('StartTpe') is not None:
            self.start_tpe = m.get('StartTpe')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('OnlyDisplay') is not None:
            self.only_display = m.get('OnlyDisplay')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfoSoftwares(TeaModel):
    def __init__(
        self,
        software: List[DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware] = None,
    ):
        self.software = software

    def validate(self):
        if self.software:
            for k in self.software:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Software'] = []
        if self.software is not None:
            for k in self.software:
                result['Software'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.software = []
        if m.get('Software') is not None:
            for k in m.get('Software'):
                temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware()
                self.software.append(temp_model.from_map(k))
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfo(TeaModel):
    def __init__(
        self,
        emr_ver: str = None,
        cluster_type: str = None,
        softwares: DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfoSoftwares = None,
    ):
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.softwares = softwares

    def validate(self):
        if self.softwares:
            self.softwares.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.softwares is not None:
            result['Softwares'] = self.softwares.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('Softwares') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfoSoftwares()
            self.softwares = temp_model.from_map(m['Softwares'])
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfoZKLinksZKLink(TeaModel):
    def __init__(
        self,
        link: str = None,
        port: str = None,
    ):
        self.link = link
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.link is not None:
            result['Link'] = self.link
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfoZKLinks(TeaModel):
    def __init__(
        self,
        zklink: List[DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfoZKLinksZKLink] = None,
    ):
        self.zklink = zklink

    def validate(self):
        if self.zklink:
            for k in self.zklink:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ZKLink'] = []
        if self.zklink is not None:
            for k in self.zklink:
                result['ZKLink'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.zklink = []
        if m.get('ZKLink') is not None:
            for k in m.get('ZKLink'):
                temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfoZKLinksZKLink()
                self.zklink.append(temp_model.from_map(k))
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfo(TeaModel):
    def __init__(
        self,
        zklinks: DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfoZKLinks = None,
    ):
        self.zklinks = zklinks

    def validate(self):
        if self.zklinks:
            self.zklinks.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zklinks is not None:
            result['ZKLinks'] = self.zklinks.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZKLinks') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfoZKLinks()
            self.zklinks = temp_model.from_map(m['ZKLinks'])
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(
        self,
        arg: str = None,
        path: str = None,
        name: str = None,
    ):
        self.arg = arg
        self.path = path
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoBootstrapActionList(TeaModel):
    def __init__(
        self,
        bootstrap_action: List[DescribeClusterBasicInfoResponseBodyClusterInfoBootstrapActionListBootstrapAction] = None,
    ):
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        cluster_name: str = None,
        cluster_id: str = None,
    ):
        self.status = status
        self.cluster_name = cluster_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoGatewayClusterInfoList(TeaModel):
    def __init__(
        self,
        gateway_cluster_info: List[DescribeClusterBasicInfoResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo] = None,
    ):
        self.gateway_cluster_info = gateway_cluster_info

    def validate(self):
        if self.gateway_cluster_info:
            for k in self.gateway_cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GatewayClusterInfo'] = []
        if self.gateway_cluster_info is not None:
            for k in self.gateway_cluster_info:
                result['GatewayClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.gateway_cluster_info = []
        if m.get('GatewayClusterInfo') is not None:
            for k in m.get('GatewayClusterInfo'):
                temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo()
                self.gateway_cluster_info.append(temp_model.from_map(k))
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfoHostPoolInfo(TeaModel):
    def __init__(
        self,
        hp_biz_id: str = None,
        hp_name: str = None,
    ):
        self.hp_biz_id = hp_biz_id
        self.hp_name = hp_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hp_biz_id is not None:
            result['HpBizId'] = self.hp_biz_id
        if self.hp_name is not None:
            result['HpName'] = self.hp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HpBizId') is not None:
            self.hp_biz_id = m.get('HpBizId')
        if m.get('HpName') is not None:
            self.hp_name = m.get('HpName')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfo(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        log_enable: bool = None,
        task_node_in_service: int = None,
        auto_scaling_spot_with_limit_allowed: bool = None,
        charge_type: str = None,
        user_id: str = None,
        stop_time: int = None,
        create_type: str = None,
        deposit_type: str = None,
        relate_cluster_info: DescribeClusterBasicInfoResponseBodyClusterInfoRelateClusterInfo = None,
        relate_cluster_id: str = None,
        security_group_name: str = None,
        resize_disk_enable: bool = None,
        image_id: str = None,
        fail_reason: DescribeClusterBasicInfoResponseBodyClusterInfoFailReason = None,
        cluster_id: str = None,
        user_defined_emr_ecs_role: str = None,
        meta_store_type: str = None,
        software_info: DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfo = None,
        start_time: int = None,
        configurations: str = None,
        log_path: str = None,
        auto_scaling_version: str = None,
        net_type: str = None,
        zone_id: str = None,
        access_info: DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfo = None,
        create_resource: str = None,
        status: str = None,
        running_time: int = None,
        high_availability_enable: bool = None,
        security_group_id: str = None,
        auto_scaling_allowed: bool = None,
        master_node_in_service: int = None,
        auto_scaling_enable: bool = None,
        operation_id: str = None,
        auto_scaling_with_grace_allowed: bool = None,
        show_software_interface: bool = None,
        core_node_in_service: int = None,
        auto_scaling_by_load_allowed: bool = None,
        k_8s_cluster_id: str = None,
        local_meta_db: bool = None,
        bootstrap_action_list: DescribeClusterBasicInfoResponseBodyClusterInfoBootstrapActionList = None,
        gateway_cluster_info_list: DescribeClusterBasicInfoResponseBodyClusterInfoGatewayClusterInfoList = None,
        instance_generation: str = None,
        name: str = None,
        eas_enable: bool = None,
        machine_type: str = None,
        host_pool_info: DescribeClusterBasicInfoResponseBodyClusterInfoHostPoolInfo = None,
        master_node_total: int = None,
        region_id: str = None,
        period: int = None,
        extra_info: str = None,
        io_optimized: bool = None,
        v_switch_id: str = None,
        expired_time: int = None,
        core_node_total: int = None,
        gateway_cluster_ids: str = None,
        bootstrap_failed: bool = None,
        task_node_total: int = None,
    ):
        self.vpc_id = vpc_id
        self.log_enable = log_enable
        self.task_node_in_service = task_node_in_service
        self.auto_scaling_spot_with_limit_allowed = auto_scaling_spot_with_limit_allowed
        self.charge_type = charge_type
        self.user_id = user_id
        self.stop_time = stop_time
        self.create_type = create_type
        self.deposit_type = deposit_type
        self.relate_cluster_info = relate_cluster_info
        self.relate_cluster_id = relate_cluster_id
        self.security_group_name = security_group_name
        self.resize_disk_enable = resize_disk_enable
        self.image_id = image_id
        self.fail_reason = fail_reason
        self.cluster_id = cluster_id
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.meta_store_type = meta_store_type
        self.software_info = software_info
        self.start_time = start_time
        self.configurations = configurations
        self.log_path = log_path
        self.auto_scaling_version = auto_scaling_version
        self.net_type = net_type
        self.zone_id = zone_id
        self.access_info = access_info
        self.create_resource = create_resource
        self.status = status
        self.running_time = running_time
        self.high_availability_enable = high_availability_enable
        self.security_group_id = security_group_id
        self.auto_scaling_allowed = auto_scaling_allowed
        self.master_node_in_service = master_node_in_service
        self.auto_scaling_enable = auto_scaling_enable
        self.operation_id = operation_id
        self.auto_scaling_with_grace_allowed = auto_scaling_with_grace_allowed
        self.show_software_interface = show_software_interface
        self.core_node_in_service = core_node_in_service
        self.auto_scaling_by_load_allowed = auto_scaling_by_load_allowed
        self.k_8s_cluster_id = k_8s_cluster_id
        self.local_meta_db = local_meta_db
        self.bootstrap_action_list = bootstrap_action_list
        self.gateway_cluster_info_list = gateway_cluster_info_list
        self.instance_generation = instance_generation
        self.name = name
        self.eas_enable = eas_enable
        self.machine_type = machine_type
        self.host_pool_info = host_pool_info
        self.master_node_total = master_node_total
        self.region_id = region_id
        self.period = period
        self.extra_info = extra_info
        self.io_optimized = io_optimized
        self.v_switch_id = v_switch_id
        self.expired_time = expired_time
        self.core_node_total = core_node_total
        self.gateway_cluster_ids = gateway_cluster_ids
        self.bootstrap_failed = bootstrap_failed
        self.task_node_total = task_node_total

    def validate(self):
        if self.relate_cluster_info:
            self.relate_cluster_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()
        if self.software_info:
            self.software_info.validate()
        if self.access_info:
            self.access_info.validate()
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.gateway_cluster_info_list:
            self.gateway_cluster_info_list.validate()
        if self.host_pool_info:
            self.host_pool_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.task_node_in_service is not None:
            result['TaskNodeInService'] = self.task_node_in_service
        if self.auto_scaling_spot_with_limit_allowed is not None:
            result['AutoScalingSpotWithLimitAllowed'] = self.auto_scaling_spot_with_limit_allowed
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.relate_cluster_info is not None:
            result['RelateClusterInfo'] = self.relate_cluster_info.to_map()
        if self.relate_cluster_id is not None:
            result['RelateClusterId'] = self.relate_cluster_id
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.resize_disk_enable is not None:
            result['ResizeDiskEnable'] = self.resize_disk_enable
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.auto_scaling_version is not None:
            result['AutoScalingVersion'] = self.auto_scaling_version
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.access_info is not None:
            result['AccessInfo'] = self.access_info.to_map()
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.auto_scaling_allowed is not None:
            result['AutoScalingAllowed'] = self.auto_scaling_allowed
        if self.master_node_in_service is not None:
            result['MasterNodeInService'] = self.master_node_in_service
        if self.auto_scaling_enable is not None:
            result['AutoScalingEnable'] = self.auto_scaling_enable
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.auto_scaling_with_grace_allowed is not None:
            result['AutoScalingWithGraceAllowed'] = self.auto_scaling_with_grace_allowed
        if self.show_software_interface is not None:
            result['ShowSoftwareInterface'] = self.show_software_interface
        if self.core_node_in_service is not None:
            result['CoreNodeInService'] = self.core_node_in_service
        if self.auto_scaling_by_load_allowed is not None:
            result['AutoScalingByLoadAllowed'] = self.auto_scaling_by_load_allowed
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.local_meta_db is not None:
            result['LocalMetaDb'] = self.local_meta_db
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.gateway_cluster_info_list is not None:
            result['GatewayClusterInfoList'] = self.gateway_cluster_info_list.to_map()
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.name is not None:
            result['Name'] = self.name
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.host_pool_info is not None:
            result['HostPoolInfo'] = self.host_pool_info.to_map()
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.period is not None:
            result['Period'] = self.period
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.core_node_total is not None:
            result['CoreNodeTotal'] = self.core_node_total
        if self.gateway_cluster_ids is not None:
            result['GatewayClusterIds'] = self.gateway_cluster_ids
        if self.bootstrap_failed is not None:
            result['BootstrapFailed'] = self.bootstrap_failed
        if self.task_node_total is not None:
            result['TaskNodeTotal'] = self.task_node_total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('TaskNodeInService') is not None:
            self.task_node_in_service = m.get('TaskNodeInService')
        if m.get('AutoScalingSpotWithLimitAllowed') is not None:
            self.auto_scaling_spot_with_limit_allowed = m.get('AutoScalingSpotWithLimitAllowed')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('RelateClusterInfo') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoRelateClusterInfo()
            self.relate_cluster_info = temp_model.from_map(m['RelateClusterInfo'])
        if m.get('RelateClusterId') is not None:
            self.relate_cluster_id = m.get('RelateClusterId')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ResizeDiskEnable') is not None:
            self.resize_disk_enable = m.get('ResizeDiskEnable')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('FailReason') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('SoftwareInfo') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoSoftwareInfo()
            self.software_info = temp_model.from_map(m['SoftwareInfo'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('AutoScalingVersion') is not None:
            self.auto_scaling_version = m.get('AutoScalingVersion')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('AccessInfo') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoAccessInfo()
            self.access_info = temp_model.from_map(m['AccessInfo'])
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('AutoScalingAllowed') is not None:
            self.auto_scaling_allowed = m.get('AutoScalingAllowed')
        if m.get('MasterNodeInService') is not None:
            self.master_node_in_service = m.get('MasterNodeInService')
        if m.get('AutoScalingEnable') is not None:
            self.auto_scaling_enable = m.get('AutoScalingEnable')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('AutoScalingWithGraceAllowed') is not None:
            self.auto_scaling_with_grace_allowed = m.get('AutoScalingWithGraceAllowed')
        if m.get('ShowSoftwareInterface') is not None:
            self.show_software_interface = m.get('ShowSoftwareInterface')
        if m.get('CoreNodeInService') is not None:
            self.core_node_in_service = m.get('CoreNodeInService')
        if m.get('AutoScalingByLoadAllowed') is not None:
            self.auto_scaling_by_load_allowed = m.get('AutoScalingByLoadAllowed')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('LocalMetaDb') is not None:
            self.local_meta_db = m.get('LocalMetaDb')
        if m.get('BootstrapActionList') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('GatewayClusterInfoList') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoGatewayClusterInfoList()
            self.gateway_cluster_info_list = temp_model.from_map(m['GatewayClusterInfoList'])
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('HostPoolInfo') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfoHostPoolInfo()
            self.host_pool_info = temp_model.from_map(m['HostPoolInfo'])
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CoreNodeTotal') is not None:
            self.core_node_total = m.get('CoreNodeTotal')
        if m.get('GatewayClusterIds') is not None:
            self.gateway_cluster_ids = m.get('GatewayClusterIds')
        if m.get('BootstrapFailed') is not None:
            self.bootstrap_failed = m.get('BootstrapFailed')
        if m.get('TaskNodeTotal') is not None:
            self.task_node_total = m.get('TaskNodeTotal')
        return self


class DescribeClusterBasicInfoResponseBody(TeaModel):
    def __init__(
        self,
        cluster_info: DescribeClusterBasicInfoResponseBodyClusterInfo = None,
        request_id: str = None,
    ):
        self.cluster_info = cluster_info
        self.request_id = request_id

    def validate(self):
        if self.cluster_info:
            self.cluster_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_info is not None:
            result['ClusterInfo'] = self.cluster_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterInfo') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfo()
            self.cluster_info = temp_model.from_map(m['ClusterInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterBasicInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterBasicInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterBasicInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterMetaCollectRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterMetaCollectResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        request_id: str = None,
        cluster_id: str = None,
        meta_store_type: str = None,
    ):
        self.status = status
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.meta_store_type = meta_store_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        return self


class DescribeClusterMetaCollectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterMetaCollectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterMetaCollectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterOperationHostTaskLogRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        operation_id: str = None,
        host_id: str = None,
        task_id: str = None,
        status: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.operation_id = operation_id
        self.host_id = host_id
        self.task_id = task_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeClusterOperationHostTaskLogResponseBody(TeaModel):
    def __init__(
        self,
        stderr: str = None,
        request_id: str = None,
        stdout: str = None,
    ):
        self.stderr = stderr
        self.request_id = request_id
        self.stdout = stdout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stderr is not None:
            result['Stderr'] = self.stderr
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stdout is not None:
            result['Stdout'] = self.stdout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Stderr') is not None:
            self.stderr = m.get('Stderr')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Stdout') is not None:
            self.stdout = m.get('Stdout')
        return self


class DescribeClusterOperationHostTaskLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterOperationHostTaskLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterOperationHostTaskLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterResourcePoolSchedulerTypeRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterResourcePoolSchedulerTypeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        current_scheduler_type: str = None,
        support_scheduler_type: str = None,
        default_scheduler_type: str = None,
    ):
        self.request_id = request_id
        self.current_scheduler_type = current_scheduler_type
        self.support_scheduler_type = support_scheduler_type
        self.default_scheduler_type = default_scheduler_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.current_scheduler_type is not None:
            result['CurrentSchedulerType'] = self.current_scheduler_type
        if self.support_scheduler_type is not None:
            result['SupportSchedulerType'] = self.support_scheduler_type
        if self.default_scheduler_type is not None:
            result['DefaultSchedulerType'] = self.default_scheduler_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('CurrentSchedulerType') is not None:
            self.current_scheduler_type = m.get('CurrentSchedulerType')
        if m.get('SupportSchedulerType') is not None:
            self.support_scheduler_type = m.get('SupportSchedulerType')
        if m.get('DefaultSchedulerType') is not None:
            self.default_scheduler_type = m.get('DefaultSchedulerType')
        return self


class DescribeClusterResourcePoolSchedulerTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterResourcePoolSchedulerTypeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterResourcePoolSchedulerTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterServiceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList(TeaModel):
    def __init__(
        self,
        service: List[str] = None,
    ):
        self.service = service

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service is not None:
            result['Service'] = self.service
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Service') is not None:
            self.service = m.get('Service')
        return self


class DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary(TeaModel):
    def __init__(
        self,
        key: str = None,
        display_name: str = None,
        status: str = None,
        type: str = None,
        value: str = None,
        desired_stopped_value: int = None,
        alert_info: str = None,
        category: str = None,
    ):
        self.key = key
        self.display_name = display_name
        self.status = status
        self.type = type
        self.value = value
        self.desired_stopped_value = desired_stopped_value
        self.alert_info = alert_info
        self.category = category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.desired_stopped_value is not None:
            result['DesiredStoppedValue'] = self.desired_stopped_value
        if self.alert_info is not None:
            result['AlertInfo'] = self.alert_info
        if self.category is not None:
            result['Category'] = self.category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('DesiredStoppedValue') is not None:
            self.desired_stopped_value = m.get('DesiredStoppedValue')
        if m.get('AlertInfo') is not None:
            self.alert_info = m.get('AlertInfo')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        return self


class DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList(TeaModel):
    def __init__(
        self,
        cluster_service_summary: List[DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary] = None,
    ):
        self.cluster_service_summary = cluster_service_summary

    def validate(self):
        if self.cluster_service_summary:
            for k in self.cluster_service_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterServiceSummary'] = []
        if self.cluster_service_summary is not None:
            for k in self.cluster_service_summary:
                result['ClusterServiceSummary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_service_summary = []
        if m.get('ClusterServiceSummary') is not None:
            for k in m.get('ClusterServiceSummary'):
                temp_model = DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary()
                self.cluster_service_summary.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        component_name: str = None,
        command: str = None,
        action_name: str = None,
        service_name: str = None,
    ):
        self.display_name = display_name
        self.component_name = component_name
        self.command = command
        self.action_name = action_name
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.command is not None:
            result['Command'] = self.command
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeClusterServiceResponseBodyServiceInfoServiceActionList(TeaModel):
    def __init__(
        self,
        service_action: List[DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction] = None,
    ):
        self.service_action = service_action

    def validate(self):
        if self.service_action:
            for k in self.service_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ServiceAction'] = []
        if self.service_action is not None:
            for k in self.service_action:
                result['ServiceAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.service_action = []
        if m.get('ServiceAction') is not None:
            for k in m.get('ServiceAction'):
                temp_model = DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction()
                self.service_action.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList(TeaModel):
    def __init__(
        self,
        service: List[str] = None,
    ):
        self.service = service

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service is not None:
            result['Service'] = self.service
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Service') is not None:
            self.service = m.get('Service')
        return self


class DescribeClusterServiceResponseBodyServiceInfo(TeaModel):
    def __init__(
        self,
        need_restart_info: str = None,
        need_restart_host_id_list: DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList = None,
        cluster_service_summary_list: DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList = None,
        service_action_list: DescribeClusterServiceResponseBodyServiceInfoServiceActionList = None,
        need_restart_num: int = None,
        need_restart_component_name_list: DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList = None,
        service_version: str = None,
        service_status: str = None,
        service_name: str = None,
    ):
        self.need_restart_info = need_restart_info
        self.need_restart_host_id_list = need_restart_host_id_list
        self.cluster_service_summary_list = cluster_service_summary_list
        self.service_action_list = service_action_list
        self.need_restart_num = need_restart_num
        self.need_restart_component_name_list = need_restart_component_name_list
        self.service_version = service_version
        self.service_status = service_status
        self.service_name = service_name

    def validate(self):
        if self.need_restart_host_id_list:
            self.need_restart_host_id_list.validate()
        if self.cluster_service_summary_list:
            self.cluster_service_summary_list.validate()
        if self.service_action_list:
            self.service_action_list.validate()
        if self.need_restart_component_name_list:
            self.need_restart_component_name_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_restart_info is not None:
            result['NeedRestartInfo'] = self.need_restart_info
        if self.need_restart_host_id_list is not None:
            result['NeedRestartHostIdList'] = self.need_restart_host_id_list.to_map()
        if self.cluster_service_summary_list is not None:
            result['ClusterServiceSummaryList'] = self.cluster_service_summary_list.to_map()
        if self.service_action_list is not None:
            result['ServiceActionList'] = self.service_action_list.to_map()
        if self.need_restart_num is not None:
            result['NeedRestartNum'] = self.need_restart_num
        if self.need_restart_component_name_list is not None:
            result['NeedRestartComponentNameList'] = self.need_restart_component_name_list.to_map()
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NeedRestartInfo') is not None:
            self.need_restart_info = m.get('NeedRestartInfo')
        if m.get('NeedRestartHostIdList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList()
            self.need_restart_host_id_list = temp_model.from_map(m['NeedRestartHostIdList'])
        if m.get('ClusterServiceSummaryList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList()
            self.cluster_service_summary_list = temp_model.from_map(m['ClusterServiceSummaryList'])
        if m.get('ServiceActionList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoServiceActionList()
            self.service_action_list = temp_model.from_map(m['ServiceActionList'])
        if m.get('NeedRestartNum') is not None:
            self.need_restart_num = m.get('NeedRestartNum')
        if m.get('NeedRestartComponentNameList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList()
            self.need_restart_component_name_list = temp_model.from_map(m['NeedRestartComponentNameList'])
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeClusterServiceResponseBody(TeaModel):
    def __init__(
        self,
        service_info: DescribeClusterServiceResponseBodyServiceInfo = None,
        request_id: str = None,
    ):
        self.service_info = service_info
        self.request_id = request_id

    def validate(self):
        if self.service_info:
            self.service_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_info is not None:
            result['ServiceInfo'] = self.service_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceInfo') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfo()
            self.service_info = temp_model.from_map(m['ServiceInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterServiceConfigRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        config_version: str = None,
        group_id: str = None,
        host_instance_id: str = None,
        tag_value: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.config_version = config_version
        self.group_id = group_id
        self.host_instance_id = host_instance_id
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue(TeaModel):
    def __init__(
        self,
        value: str = None,
        description: str = None,
        item_name: str = None,
        is_custom: bool = None,
    ):
        self.value = value
        self.description = description
        self.item_name = item_name
        self.is_custom = is_custom

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.description is not None:
            result['Description'] = self.description
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.is_custom is not None:
            result['IsCustom'] = self.is_custom
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('IsCustom') is not None:
            self.is_custom = m.get('IsCustom')
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList(TeaModel):
    def __init__(
        self,
        config_item_value: List[DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue] = None,
    ):
        self.config_item_value = config_item_value

    def validate(self):
        if self.config_item_value:
            for k in self.config_item_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigItemValue'] = []
        if self.config_item_value is not None:
            for k in self.config_item_value:
                result['ConfigItemValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_item_value = []
        if m.get('ConfigItemValue') is not None:
            for k in m.get('ConfigItemValue'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue()
                self.config_item_value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue(TeaModel):
    def __init__(
        self,
        config_name: str = None,
        scope_id: int = None,
        config_item_value_list: DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList = None,
        allow_custom: bool = None,
        scope: str = None,
    ):
        self.config_name = config_name
        self.scope_id = scope_id
        self.config_item_value_list = config_item_value_list
        self.allow_custom = allow_custom
        self.scope = scope

    def validate(self):
        if self.config_item_value_list:
            self.config_item_value_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.scope_id is not None:
            result['ScopeId'] = self.scope_id
        if self.config_item_value_list is not None:
            result['ConfigItemValueList'] = self.config_item_value_list.to_map()
        if self.allow_custom is not None:
            result['AllowCustom'] = self.allow_custom
        if self.scope is not None:
            result['Scope'] = self.scope
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ScopeId') is not None:
            self.scope_id = m.get('ScopeId')
        if m.get('ConfigItemValueList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList()
            self.config_item_value_list = temp_model.from_map(m['ConfigItemValueList'])
        if m.get('AllowCustom') is not None:
            self.allow_custom = m.get('AllowCustom')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueList(TeaModel):
    def __init__(
        self,
        config_value: List[DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue] = None,
    ):
        self.config_value = config_value

    def validate(self):
        if self.config_value:
            for k in self.config_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigValue'] = []
        if self.config_value is not None:
            for k in self.config_value:
                result['ConfigValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_value = []
        if m.get('ConfigValue') is not None:
            for k in m.get('ConfigValue'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue()
                self.config_value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes(TeaModel):
    def __init__(
        self,
        property_type: List[str] = None,
    ):
        self.property_type = property_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.property_type is not None:
            result['propertyType'] = self.property_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('propertyType') is not None:
            self.property_type = m.get('propertyType')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay(TeaModel):
    def __init__(
        self,
        effect_type: str = None,
        invoke_service_name: str = None,
    ):
        self.effect_type = effect_type
        self.invoke_service_name = invoke_service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect_type is not None:
            result['EffectType'] = self.effect_type
        if self.invoke_service_name is not None:
            result['InvokeServiceName'] = self.invoke_service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectType') is not None:
            self.effect_type = m.get('EffectType')
        if m.get('InvokeServiceName') is not None:
            self.invoke_service_name = m.get('InvokeServiceName')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo(TeaModel):
    def __init__(
        self,
        value: str = None,
        description: str = None,
        label: str = None,
    ):
        self.value = value
        self.description = description
        self.label = label

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.description is not None:
            result['Description'] = self.description
        if self.label is not None:
            result['Label'] = self.label
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries(TeaModel):
    def __init__(
        self,
        value_entry_info: List[DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo] = None,
    ):
        self.value_entry_info = value_entry_info

    def validate(self):
        if self.value_entry_info:
            for k in self.value_entry_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ValueEntryInfo'] = []
        if self.value_entry_info is not None:
            for k in self.value_entry_info:
                result['ValueEntryInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.value_entry_info = []
        if m.get('ValueEntryInfo') is not None:
            for k in m.get('ValueEntryInfo'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo()
                self.value_entry_info.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes(TeaModel):
    def __init__(
        self,
        type: str = None,
        maximum: str = None,
        unit: str = None,
        hidden: bool = None,
        incrememt_step: str = None,
        read_only: bool = None,
        entries: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries = None,
        mimimum: str = None,
    ):
        self.type = type
        self.maximum = maximum
        self.unit = unit
        self.hidden = hidden
        self.incrememt_step = incrememt_step
        self.read_only = read_only
        self.entries = entries
        self.mimimum = mimimum

    def validate(self):
        if self.entries:
            self.entries.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.maximum is not None:
            result['Maximum'] = self.maximum
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.hidden is not None:
            result['Hidden'] = self.hidden
        if self.incrememt_step is not None:
            result['IncrememtStep'] = self.incrememt_step
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.entries is not None:
            result['Entries'] = self.entries.to_map()
        if self.mimimum is not None:
            result['Mimimum'] = self.mimimum
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Maximum') is not None:
            self.maximum = m.get('Maximum')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Hidden') is not None:
            self.hidden = m.get('Hidden')
        if m.get('IncrememtStep') is not None:
            self.incrememt_step = m.get('IncrememtStep')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('Entries') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries()
            self.entries = temp_model.from_map(m['Entries'])
        if m.get('Mimimum') is not None:
            self.mimimum = m.get('Mimimum')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        value: str = None,
        property_types: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes = None,
        description: str = None,
        effect_way: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay = None,
        component: str = None,
        property_value_attributes: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes = None,
        file_name: str = None,
        name: str = None,
        service_name: str = None,
    ):
        self.display_name = display_name
        self.value = value
        self.property_types = property_types
        self.description = description
        self.effect_way = effect_way
        self.component = component
        self.property_value_attributes = property_value_attributes
        self.file_name = file_name
        self.name = name
        self.service_name = service_name

    def validate(self):
        if self.property_types:
            self.property_types.validate()
        if self.effect_way:
            self.effect_way.validate()
        if self.property_value_attributes:
            self.property_value_attributes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.value is not None:
            result['Value'] = self.value
        if self.property_types is not None:
            result['PropertyTypes'] = self.property_types.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.effect_way is not None:
            result['EffectWay'] = self.effect_way.to_map()
        if self.component is not None:
            result['Component'] = self.component
        if self.property_value_attributes is not None:
            result['PropertyValueAttributes'] = self.property_value_attributes.to_map()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.name is not None:
            result['Name'] = self.name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('PropertyTypes') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes()
            self.property_types = temp_model.from_map(m['PropertyTypes'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EffectWay') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay()
            self.effect_way = temp_model.from_map(m['EffectWay'])
        if m.get('Component') is not None:
            self.component = m.get('Component')
        if m.get('PropertyValueAttributes') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes()
            self.property_value_attributes = temp_model.from_map(m['PropertyValueAttributes'])
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList(TeaModel):
    def __init__(
        self,
        property_info: List[DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo] = None,
    ):
        self.property_info = property_info

    def validate(self):
        if self.property_info:
            for k in self.property_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PropertyInfo'] = []
        if self.property_info is not None:
            for k in self.property_info:
                result['PropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property_info = []
        if m.get('PropertyInfo') is not None:
            for k in m.get('PropertyInfo'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo()
                self.property_info.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfig(TeaModel):
    def __init__(
        self,
        applied: str = None,
        comment: str = None,
        create_time: str = None,
        config_version: str = None,
        config_value_list: DescribeClusterServiceConfigResponseBodyConfigConfigValueList = None,
        author: str = None,
        property_info_list: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList = None,
        service_name: str = None,
    ):
        self.applied = applied
        self.comment = comment
        self.create_time = create_time
        self.config_version = config_version
        self.config_value_list = config_value_list
        self.author = author
        self.property_info_list = property_info_list
        self.service_name = service_name

    def validate(self):
        if self.config_value_list:
            self.config_value_list.validate()
        if self.property_info_list:
            self.property_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applied is not None:
            result['Applied'] = self.applied
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.config_value_list is not None:
            result['ConfigValueList'] = self.config_value_list.to_map()
        if self.author is not None:
            result['Author'] = self.author
        if self.property_info_list is not None:
            result['PropertyInfoList'] = self.property_info_list.to_map()
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Applied') is not None:
            self.applied = m.get('Applied')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('ConfigValueList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueList()
            self.config_value_list = temp_model.from_map(m['ConfigValueList'])
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('PropertyInfoList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList()
            self.property_info_list = temp_model.from_map(m['PropertyInfoList'])
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeClusterServiceConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        config: DescribeClusterServiceConfigResponseBodyConfig = None,
    ):
        self.request_id = request_id
        self.config = config

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Config') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class DescribeClusterServiceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterServiceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterServiceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterServiceConfigHistoryRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        config_version: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.config_version = config_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        return self


class DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue(TeaModel):
    def __init__(
        self,
        value: str = None,
        old_value: str = None,
        item_name: str = None,
        change_type: str = None,
    ):
        self.value = value
        self.old_value = old_value
        self.item_name = item_name
        self.change_type = change_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.old_value is not None:
            result['OldValue'] = self.old_value
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.change_type is not None:
            result['ChangeType'] = self.change_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('OldValue') is not None:
            self.old_value = m.get('OldValue')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ChangeType') is not None:
            self.change_type = m.get('ChangeType')
        return self


class DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValueConfigItemValueList(TeaModel):
    def __init__(
        self,
        config_item_value: List[DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue] = None,
    ):
        self.config_item_value = config_item_value

    def validate(self):
        if self.config_item_value:
            for k in self.config_item_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigItemValue'] = []
        if self.config_item_value is not None:
            for k in self.config_item_value:
                result['ConfigItemValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_item_value = []
        if m.get('ConfigItemValue') is not None:
            for k in m.get('ConfigItemValue'):
                temp_model = DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue()
                self.config_item_value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValue(TeaModel):
    def __init__(
        self,
        config_name: str = None,
        config_item_value_list: DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValueConfigItemValueList = None,
    ):
        self.config_name = config_name
        self.config_item_value_list = config_item_value_list

    def validate(self):
        if self.config_item_value_list:
            self.config_item_value_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.config_item_value_list is not None:
            result['ConfigItemValueList'] = self.config_item_value_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ConfigItemValueList') is not None:
            temp_model = DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValueConfigItemValueList()
            self.config_item_value_list = temp_model.from_map(m['ConfigItemValueList'])
        return self


class DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueList(TeaModel):
    def __init__(
        self,
        config_value: List[DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValue] = None,
    ):
        self.config_value = config_value

    def validate(self):
        if self.config_value:
            for k in self.config_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigValue'] = []
        if self.config_value is not None:
            for k in self.config_value:
                result['ConfigValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_value = []
        if m.get('ConfigValue') is not None:
            for k in m.get('ConfigValue'):
                temp_model = DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueListConfigValue()
                self.config_value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigHistoryResponseBodyConfig(TeaModel):
    def __init__(
        self,
        applied: bool = None,
        comment: str = None,
        create_time: str = None,
        config_version: str = None,
        config_value_list: DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueList = None,
        author: str = None,
        service_name: str = None,
    ):
        self.applied = applied
        self.comment = comment
        self.create_time = create_time
        self.config_version = config_version
        self.config_value_list = config_value_list
        self.author = author
        self.service_name = service_name

    def validate(self):
        if self.config_value_list:
            self.config_value_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applied is not None:
            result['Applied'] = self.applied
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.config_value_list is not None:
            result['ConfigValueList'] = self.config_value_list.to_map()
        if self.author is not None:
            result['Author'] = self.author
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Applied') is not None:
            self.applied = m.get('Applied')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('ConfigValueList') is not None:
            temp_model = DescribeClusterServiceConfigHistoryResponseBodyConfigConfigValueList()
            self.config_value_list = temp_model.from_map(m['ConfigValueList'])
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeClusterServiceConfigHistoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        config: DescribeClusterServiceConfigHistoryResponseBodyConfig = None,
    ):
        self.request_id = request_id
        self.config = config

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Config') is not None:
            temp_model = DescribeClusterServiceConfigHistoryResponseBodyConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class DescribeClusterServiceConfigHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterServiceConfigHistoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterServiceConfigHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterServiceConfigTagRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        config_tag: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.config_tag = config_tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_tag is not None:
            result['ConfigTag'] = self.config_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigTag') is not None:
            self.config_tag = m.get('ConfigTag')
        return self


class DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTagValueListValue(TeaModel):
    def __init__(
        self,
        value: str = None,
        value_desc: str = None,
    ):
        self.value = value
        self.value_desc = value_desc

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.value_desc is not None:
            result['ValueDesc'] = self.value_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueDesc') is not None:
            self.value_desc = m.get('ValueDesc')
        return self


class DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTagValueList(TeaModel):
    def __init__(
        self,
        value: List[DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTagValueListValue] = None,
    ):
        self.value = value

    def validate(self):
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.value = []
        if m.get('Value') is not None:
            for k in m.get('Value'):
                temp_model = DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTagValueListValue()
                self.value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTag(TeaModel):
    def __init__(
        self,
        value_list: DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTagValueList = None,
        tag: str = None,
        tag_desc: str = None,
    ):
        self.value_list = value_list
        self.tag = tag
        self.tag_desc = tag_desc

    def validate(self):
        if self.value_list:
            self.value_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value_list is not None:
            result['ValueList'] = self.value_list.to_map()
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_desc is not None:
            result['TagDesc'] = self.tag_desc
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ValueList') is not None:
            temp_model = DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTagValueList()
            self.value_list = temp_model.from_map(m['ValueList'])
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagDesc') is not None:
            self.tag_desc = m.get('TagDesc')
        return self


class DescribeClusterServiceConfigTagResponseBodyConfigTagList(TeaModel):
    def __init__(
        self,
        config_tag: List[DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTag] = None,
    ):
        self.config_tag = config_tag

    def validate(self):
        if self.config_tag:
            for k in self.config_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigTag'] = []
        if self.config_tag is not None:
            for k in self.config_tag:
                result['ConfigTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_tag = []
        if m.get('ConfigTag') is not None:
            for k in m.get('ConfigTag'):
                temp_model = DescribeClusterServiceConfigTagResponseBodyConfigTagListConfigTag()
                self.config_tag.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigTagResponseBody(TeaModel):
    def __init__(
        self,
        config_tag_list: DescribeClusterServiceConfigTagResponseBodyConfigTagList = None,
        request_id: str = None,
    ):
        self.config_tag_list = config_tag_list
        self.request_id = request_id

    def validate(self):
        if self.config_tag_list:
            self.config_tag_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_tag_list is not None:
            result['ConfigTagList'] = self.config_tag_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigTagList') is not None:
            temp_model = DescribeClusterServiceConfigTagResponseBodyConfigTagList()
            self.config_tag_list = temp_model.from_map(m['ConfigTagList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterServiceConfigTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterServiceConfigTagResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterServiceConfigTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterTemplateRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        biz_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.biz_id = biz_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        sys_disk_type: str = None,
        multi_instance_types: str = None,
        charge_type: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        disk_count: int = None,
        period: str = None,
        disk_capacity: int = None,
        node_count: int = None,
        host_group_name: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.sys_disk_type = sys_disk_type
        self.multi_instance_types = multi_instance_types
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.period = period
        self.disk_capacity = disk_capacity
        self.node_count = node_count
        self.host_group_name = host_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList(TeaModel):
    def __init__(
        self,
        host_group: List[DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup] = None,
    ):
        self.host_group = host_group

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeClusterTemplateResponseBodyTemplateInfoTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoConfigList(TeaModel):
    def __init__(
        self,
        config: List[DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(
        self,
        arg: str = None,
        path: str = None,
        name: str = None,
    ):
        self.arg = arg
        self.path = path
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList(TeaModel):
    def __init__(
        self,
        bootstrap_action: List[DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction] = None,
    ):
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList(TeaModel):
    def __init__(
        self,
        software_info: List[str] = None,
    ):
        self.software_info = software_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SoftwareInfo') is not None:
            self.software_info = m.get('SoftwareInfo')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfo(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        key_pair_name: str = None,
        log_enable: bool = None,
        ssh_enable: bool = None,
        high_availability_enable: bool = None,
        security_group_id: str = None,
        master_pwd: str = None,
        user_id: str = None,
        host_group_list: DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList = None,
        tags: DescribeClusterTemplateResponseBodyTemplateInfoTags = None,
        gmt_modified: int = None,
        template_name: str = None,
        allow_notebook: bool = None,
        is_open_public_ip: bool = None,
        deposit_type: str = None,
        security_group_name: str = None,
        config_list: DescribeClusterTemplateResponseBodyTemplateInfoConfigList = None,
        bootstrap_action_list: DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList = None,
        software_info_list: DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList = None,
        instance_generation: str = None,
        create_source: str = None,
        eas_enable: bool = None,
        use_custom_hive_meta_db: bool = None,
        user_defined_emr_ecs_role: str = None,
        meta_store_type: str = None,
        machine_type: str = None,
        use_local_meta_db: bool = None,
        master_node_total: int = None,
        init_custom_hive_meta_db: bool = None,
        io_optimized: bool = None,
        meta_store_conf: str = None,
        v_switch_id: str = None,
        configurations: str = None,
        emr_ver: str = None,
        log_path: str = None,
        cluster_type: str = None,
        net_type: str = None,
        zone_id: str = None,
        gmt_create: int = None,
        id: str = None,
    ):
        self.vpc_id = vpc_id
        self.key_pair_name = key_pair_name
        self.log_enable = log_enable
        self.ssh_enable = ssh_enable
        self.high_availability_enable = high_availability_enable
        self.security_group_id = security_group_id
        self.master_pwd = master_pwd
        self.user_id = user_id
        self.host_group_list = host_group_list
        self.tags = tags
        self.gmt_modified = gmt_modified
        self.template_name = template_name
        self.allow_notebook = allow_notebook
        self.is_open_public_ip = is_open_public_ip
        self.deposit_type = deposit_type
        self.security_group_name = security_group_name
        self.config_list = config_list
        self.bootstrap_action_list = bootstrap_action_list
        self.software_info_list = software_info_list
        self.instance_generation = instance_generation
        self.create_source = create_source
        self.eas_enable = eas_enable
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.meta_store_type = meta_store_type
        self.machine_type = machine_type
        self.use_local_meta_db = use_local_meta_db
        self.master_node_total = master_node_total
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.io_optimized = io_optimized
        self.meta_store_conf = meta_store_conf
        self.v_switch_id = v_switch_id
        self.configurations = configurations
        self.emr_ver = emr_ver
        self.log_path = log_path
        self.cluster_type = cluster_type
        self.net_type = net_type
        self.zone_id = zone_id
        self.gmt_create = gmt_create
        self.id = id

    def validate(self):
        if self.host_group_list:
            self.host_group_list.validate()
        if self.tags:
            self.tags.validate()
        if self.config_list:
            self.config_list.validate()
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.software_info_list:
            self.software_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.ssh_enable is not None:
            result['SshEnable'] = self.ssh_enable
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.allow_notebook is not None:
            result['AllowNotebook'] = self.allow_notebook
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.software_info_list is not None:
            result['SoftwareInfoList'] = self.software_info_list.to_map()
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('SshEnable') is not None:
            self.ssh_enable = m.get('SshEnable')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('HostGroupList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        if m.get('Tags') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('AllowNotebook') is not None:
            self.allow_notebook = m.get('AllowNotebook')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ConfigList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        if m.get('BootstrapActionList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('SoftwareInfoList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList()
            self.software_info_list = temp_model.from_map(m['SoftwareInfoList'])
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeClusterTemplateResponseBody(TeaModel):
    def __init__(
        self,
        template_info: DescribeClusterTemplateResponseBodyTemplateInfo = None,
        request_id: str = None,
    ):
        self.template_info = template_info
        self.request_id = request_id

    def validate(self):
        if self.template_info:
            self.template_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template_info is not None:
            result['TemplateInfo'] = self.template_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TemplateInfo') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfo()
            self.template_info = temp_model.from_map(m['TemplateInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        cluster_type: str = None,
        cluster_name: str = None,
        cluster_id: str = None,
    ):
        self.status = status
        self.cluster_type = cluster_type
        self.cluster_name = cluster_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoFailReason(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_msg: str = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_msg = error_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        start_tpe: int = None,
        version: str = None,
        only_display: bool = None,
        name: str = None,
    ):
        self.display_name = display_name
        self.start_tpe = start_tpe
        self.version = version
        self.only_display = only_display
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.start_tpe is not None:
            result['StartTpe'] = self.start_tpe
        if self.version is not None:
            result['Version'] = self.version
        if self.only_display is not None:
            result['OnlyDisplay'] = self.only_display
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('StartTpe') is not None:
            self.start_tpe = m.get('StartTpe')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('OnlyDisplay') is not None:
            self.only_display = m.get('OnlyDisplay')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares(TeaModel):
    def __init__(
        self,
        software: List[DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware] = None,
    ):
        self.software = software

    def validate(self):
        if self.software:
            for k in self.software:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Software'] = []
        if self.software is not None:
            for k in self.software:
                result['Software'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.software = []
        if m.get('Software') is not None:
            for k in m.get('Software'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware()
                self.software.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo(TeaModel):
    def __init__(
        self,
        emr_ver: str = None,
        cluster_type: str = None,
        softwares: DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares = None,
    ):
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.softwares = softwares

    def validate(self):
        if self.softwares:
            self.softwares.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.softwares is not None:
            result['Softwares'] = self.softwares.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('Softwares') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares()
            self.softwares = temp_model.from_map(m['Softwares'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink(TeaModel):
    def __init__(
        self,
        link: str = None,
        port: str = None,
    ):
        self.link = link
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.link is not None:
            result['Link'] = self.link
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks(TeaModel):
    def __init__(
        self,
        zklink: List[DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink] = None,
    ):
        self.zklink = zklink

    def validate(self):
        if self.zklink:
            for k in self.zklink:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ZKLink'] = []
        if self.zklink is not None:
            for k in self.zklink:
                result['ZKLink'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.zklink = []
        if m.get('ZKLink') is not None:
            for k in m.get('ZKLink'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink()
                self.zklink.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfo(TeaModel):
    def __init__(
        self,
        zklinks: DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks = None,
    ):
        self.zklinks = zklinks

    def validate(self):
        if self.zklinks:
            self.zklinks.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zklinks is not None:
            result['ZKLinks'] = self.zklinks.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZKLinks') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks()
            self.zklinks = temp_model.from_map(m['ZKLinks'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        size: int = None,
        device: str = None,
        disk_name: str = None,
        disk_id: str = None,
    ):
        self.type = type
        self.size = size
        self.device = device
        self.disk_name = disk_name
        self.disk_id = disk_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos(TeaModel):
    def __init__(
        self,
        disk_info: List[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo] = None,
    ):
        self.disk_info = disk_info

    def validate(self):
        if self.disk_info:
            for k in self.disk_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiskInfo'] = []
        if self.disk_info is not None:
            for k in self.disk_info:
                result['DiskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disk_info = []
        if m.get('DiskInfo') is not None:
            for k in m.get('DiskInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo()
                self.disk_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos(TeaModel):
    def __init__(
        self,
        daemon_info: List[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo] = None,
    ):
        self.daemon_info = daemon_info

    def validate(self):
        if self.daemon_info:
            for k in self.daemon_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DaemonInfo'] = []
        if self.daemon_info is not None:
            for k in self.daemon_info:
                result['DaemonInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.daemon_info = []
        if m.get('DaemonInfo') is not None:
            for k in m.get('DaemonInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo()
                self.daemon_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode(TeaModel):
    def __init__(
        self,
        status: str = None,
        support_ip_v6: bool = None,
        inner_ip: str = None,
        expired_time: str = None,
        create_time: str = None,
        zone_id: str = None,
        instance_id: str = None,
        disk_infos: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos = None,
        emr_expired_time: str = None,
        pub_ip: str = None,
        daemon_infos: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos = None,
    ):
        self.status = status
        self.support_ip_v6 = support_ip_v6
        self.inner_ip = inner_ip
        self.expired_time = expired_time
        self.create_time = create_time
        self.zone_id = zone_id
        self.instance_id = instance_id
        self.disk_infos = disk_infos
        self.emr_expired_time = emr_expired_time
        self.pub_ip = pub_ip
        self.daemon_infos = daemon_infos

    def validate(self):
        if self.disk_infos:
            self.disk_infos.validate()
        if self.daemon_infos:
            self.daemon_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.support_ip_v6 is not None:
            result['SupportIpV6'] = self.support_ip_v6
        if self.inner_ip is not None:
            result['InnerIp'] = self.inner_ip
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.disk_infos is not None:
            result['DiskInfos'] = self.disk_infos.to_map()
        if self.emr_expired_time is not None:
            result['EmrExpiredTime'] = self.emr_expired_time
        if self.pub_ip is not None:
            result['PubIp'] = self.pub_ip
        if self.daemon_infos is not None:
            result['DaemonInfos'] = self.daemon_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SupportIpV6') is not None:
            self.support_ip_v6 = m.get('SupportIpV6')
        if m.get('InnerIp') is not None:
            self.inner_ip = m.get('InnerIp')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DiskInfos') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos()
            self.disk_infos = temp_model.from_map(m['DiskInfos'])
        if m.get('EmrExpiredTime') is not None:
            self.emr_expired_time = m.get('EmrExpiredTime')
        if m.get('PubIp') is not None:
            self.pub_ip = m.get('PubIp')
        if m.get('DaemonInfos') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos()
            self.daemon_infos = temp_model.from_map(m['DaemonInfos'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes(TeaModel):
    def __init__(
        self,
        node: List[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode] = None,
    ):
        self.node = node

    def validate(self):
        if self.node:
            for k in self.node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Node'] = []
        if self.node is not None:
            for k in self.node:
                result['Node'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node = []
        if m.get('Node') is not None:
            for k in m.get('Node'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode()
                self.node.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup(TeaModel):
    def __init__(
        self,
        nodes: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes = None,
        lock_type: str = None,
        host_group_type: str = None,
        host_group_sub_type: str = None,
        host_group_change_status: str = None,
        charge_type: str = None,
        disk_type: str = None,
        lock_reason: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        band_width: str = None,
        disk_count: int = None,
        period: str = None,
        disk_capacity: int = None,
        cpu_core: int = None,
        memory_capacity: int = None,
        node_count: int = None,
        host_group_change_type: str = None,
        host_group_name: str = None,
    ):
        self.nodes = nodes
        self.lock_type = lock_type
        self.host_group_type = host_group_type
        self.host_group_sub_type = host_group_sub_type
        self.host_group_change_status = host_group_change_status
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.lock_reason = lock_reason
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.band_width = band_width
        self.disk_count = disk_count
        self.period = period
        self.disk_capacity = disk_capacity
        self.cpu_core = cpu_core
        self.memory_capacity = memory_capacity
        self.node_count = node_count
        self.host_group_change_type = host_group_change_type
        self.host_group_name = host_group_name

    def validate(self):
        if self.nodes:
            self.nodes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nodes is not None:
            result['Nodes'] = self.nodes.to_map()
        if self.lock_type is not None:
            result['LockType'] = self.lock_type
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.host_group_sub_type is not None:
            result['HostGroupSubType'] = self.host_group_sub_type
        if self.host_group_change_status is not None:
            result['HostGroupChangeStatus'] = self.host_group_change_status
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.band_width is not None:
            result['BandWidth'] = self.band_width
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.cpu_core is not None:
            result['CpuCore'] = self.cpu_core
        if self.memory_capacity is not None:
            result['MemoryCapacity'] = self.memory_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_change_type is not None:
            result['HostGroupChangeType'] = self.host_group_change_type
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Nodes') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes()
            self.nodes = temp_model.from_map(m['Nodes'])
        if m.get('LockType') is not None:
            self.lock_type = m.get('LockType')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('HostGroupSubType') is not None:
            self.host_group_sub_type = m.get('HostGroupSubType')
        if m.get('HostGroupChangeStatus') is not None:
            self.host_group_change_status = m.get('HostGroupChangeStatus')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('BandWidth') is not None:
            self.band_width = m.get('BandWidth')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('CpuCore') is not None:
            self.cpu_core = m.get('CpuCore')
        if m.get('MemoryCapacity') is not None:
            self.memory_capacity = m.get('MemoryCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupChangeType') is not None:
            self.host_group_change_type = m.get('HostGroupChangeType')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupList(TeaModel):
    def __init__(
        self,
        host_group: List[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup] = None,
    ):
        self.host_group = host_group

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(
        self,
        arg: str = None,
        path: str = None,
        name: str = None,
    ):
        self.arg = arg
        self.path = path
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList(TeaModel):
    def __init__(
        self,
        bootstrap_action: List[DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction] = None,
    ):
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo(TeaModel):
    def __init__(
        self,
        status: str = None,
        cluster_name: str = None,
        cluster_id: str = None,
    ):
        self.status = status
        self.cluster_name = cluster_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList(TeaModel):
    def __init__(
        self,
        gateway_cluster_info: List[DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo] = None,
    ):
        self.gateway_cluster_info = gateway_cluster_info

    def validate(self):
        if self.gateway_cluster_info:
            for k in self.gateway_cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GatewayClusterInfo'] = []
        if self.gateway_cluster_info is not None:
            for k in self.gateway_cluster_info:
                result['GatewayClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.gateway_cluster_info = []
        if m.get('GatewayClusterInfo') is not None:
            for k in m.get('GatewayClusterInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo()
                self.gateway_cluster_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo(TeaModel):
    def __init__(
        self,
        hp_biz_id: str = None,
        hp_name: str = None,
    ):
        self.hp_biz_id = hp_biz_id
        self.hp_name = hp_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hp_biz_id is not None:
            result['HpBizId'] = self.hp_biz_id
        if self.hp_name is not None:
            result['HpName'] = self.hp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HpBizId') is not None:
            self.hp_biz_id = m.get('HpBizId')
        if m.get('HpName') is not None:
            self.hp_name = m.get('HpName')
        return self


class DescribeClusterV2ResponseBodyClusterInfo(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        log_enable: bool = None,
        task_node_in_service: int = None,
        auto_scaling_spot_with_limit_allowed: bool = None,
        charge_type: str = None,
        user_id: str = None,
        stop_time: int = None,
        create_type: str = None,
        deposit_type: str = None,
        relate_cluster_info: DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo = None,
        relate_cluster_id: str = None,
        security_group_name: str = None,
        resize_disk_enable: bool = None,
        image_id: str = None,
        fail_reason: DescribeClusterV2ResponseBodyClusterInfoFailReason = None,
        user_defined_emr_ecs_role: str = None,
        meta_store_type: str = None,
        software_info: DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo = None,
        start_time: int = None,
        configurations: str = None,
        log_path: str = None,
        auto_scaling_version: str = None,
        net_type: str = None,
        zone_id: str = None,
        access_info: DescribeClusterV2ResponseBodyClusterInfoAccessInfo = None,
        create_resource: str = None,
        status: str = None,
        running_time: int = None,
        high_availability_enable: bool = None,
        security_group_id: str = None,
        auto_scaling_allowed: bool = None,
        host_group_list: DescribeClusterV2ResponseBodyClusterInfoHostGroupList = None,
        master_node_in_service: int = None,
        auto_scaling_enable: bool = None,
        auto_scaling_with_grace_allowed: bool = None,
        show_software_interface: bool = None,
        core_node_in_service: int = None,
        auto_scaling_by_load_allowed: bool = None,
        k_8s_cluster_id: str = None,
        local_meta_db: bool = None,
        bootstrap_action_list: DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList = None,
        gateway_cluster_info_list: DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList = None,
        instance_generation: str = None,
        name: str = None,
        eas_enable: bool = None,
        machine_type: str = None,
        host_pool_info: DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo = None,
        master_node_total: int = None,
        region_id: str = None,
        period: int = None,
        extra_info: str = None,
        io_optimized: bool = None,
        v_switch_id: str = None,
        expired_time: int = None,
        core_node_total: int = None,
        gateway_cluster_ids: str = None,
        bootstrap_failed: bool = None,
        id: str = None,
        task_node_total: int = None,
    ):
        self.vpc_id = vpc_id
        self.log_enable = log_enable
        self.task_node_in_service = task_node_in_service
        self.auto_scaling_spot_with_limit_allowed = auto_scaling_spot_with_limit_allowed
        self.charge_type = charge_type
        self.user_id = user_id
        self.stop_time = stop_time
        self.create_type = create_type
        self.deposit_type = deposit_type
        self.relate_cluster_info = relate_cluster_info
        self.relate_cluster_id = relate_cluster_id
        self.security_group_name = security_group_name
        self.resize_disk_enable = resize_disk_enable
        self.image_id = image_id
        self.fail_reason = fail_reason
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.meta_store_type = meta_store_type
        self.software_info = software_info
        self.start_time = start_time
        self.configurations = configurations
        self.log_path = log_path
        self.auto_scaling_version = auto_scaling_version
        self.net_type = net_type
        self.zone_id = zone_id
        self.access_info = access_info
        self.create_resource = create_resource
        self.status = status
        self.running_time = running_time
        self.high_availability_enable = high_availability_enable
        self.security_group_id = security_group_id
        self.auto_scaling_allowed = auto_scaling_allowed
        self.host_group_list = host_group_list
        self.master_node_in_service = master_node_in_service
        self.auto_scaling_enable = auto_scaling_enable
        self.auto_scaling_with_grace_allowed = auto_scaling_with_grace_allowed
        self.show_software_interface = show_software_interface
        self.core_node_in_service = core_node_in_service
        self.auto_scaling_by_load_allowed = auto_scaling_by_load_allowed
        self.k_8s_cluster_id = k_8s_cluster_id
        self.local_meta_db = local_meta_db
        self.bootstrap_action_list = bootstrap_action_list
        self.gateway_cluster_info_list = gateway_cluster_info_list
        self.instance_generation = instance_generation
        self.name = name
        self.eas_enable = eas_enable
        self.machine_type = machine_type
        self.host_pool_info = host_pool_info
        self.master_node_total = master_node_total
        self.region_id = region_id
        self.period = period
        self.extra_info = extra_info
        self.io_optimized = io_optimized
        self.v_switch_id = v_switch_id
        self.expired_time = expired_time
        self.core_node_total = core_node_total
        self.gateway_cluster_ids = gateway_cluster_ids
        self.bootstrap_failed = bootstrap_failed
        self.id = id
        self.task_node_total = task_node_total

    def validate(self):
        if self.relate_cluster_info:
            self.relate_cluster_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()
        if self.software_info:
            self.software_info.validate()
        if self.access_info:
            self.access_info.validate()
        if self.host_group_list:
            self.host_group_list.validate()
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.gateway_cluster_info_list:
            self.gateway_cluster_info_list.validate()
        if self.host_pool_info:
            self.host_pool_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.task_node_in_service is not None:
            result['TaskNodeInService'] = self.task_node_in_service
        if self.auto_scaling_spot_with_limit_allowed is not None:
            result['AutoScalingSpotWithLimitAllowed'] = self.auto_scaling_spot_with_limit_allowed
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.relate_cluster_info is not None:
            result['RelateClusterInfo'] = self.relate_cluster_info.to_map()
        if self.relate_cluster_id is not None:
            result['RelateClusterId'] = self.relate_cluster_id
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.resize_disk_enable is not None:
            result['ResizeDiskEnable'] = self.resize_disk_enable
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info.to_map()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.auto_scaling_version is not None:
            result['AutoScalingVersion'] = self.auto_scaling_version
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.access_info is not None:
            result['AccessInfo'] = self.access_info.to_map()
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.auto_scaling_allowed is not None:
            result['AutoScalingAllowed'] = self.auto_scaling_allowed
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.master_node_in_service is not None:
            result['MasterNodeInService'] = self.master_node_in_service
        if self.auto_scaling_enable is not None:
            result['AutoScalingEnable'] = self.auto_scaling_enable
        if self.auto_scaling_with_grace_allowed is not None:
            result['AutoScalingWithGraceAllowed'] = self.auto_scaling_with_grace_allowed
        if self.show_software_interface is not None:
            result['ShowSoftwareInterface'] = self.show_software_interface
        if self.core_node_in_service is not None:
            result['CoreNodeInService'] = self.core_node_in_service
        if self.auto_scaling_by_load_allowed is not None:
            result['AutoScalingByLoadAllowed'] = self.auto_scaling_by_load_allowed
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.local_meta_db is not None:
            result['LocalMetaDb'] = self.local_meta_db
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.gateway_cluster_info_list is not None:
            result['GatewayClusterInfoList'] = self.gateway_cluster_info_list.to_map()
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.name is not None:
            result['Name'] = self.name
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.host_pool_info is not None:
            result['HostPoolInfo'] = self.host_pool_info.to_map()
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.period is not None:
            result['Period'] = self.period
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.core_node_total is not None:
            result['CoreNodeTotal'] = self.core_node_total
        if self.gateway_cluster_ids is not None:
            result['GatewayClusterIds'] = self.gateway_cluster_ids
        if self.bootstrap_failed is not None:
            result['BootstrapFailed'] = self.bootstrap_failed
        if self.id is not None:
            result['Id'] = self.id
        if self.task_node_total is not None:
            result['TaskNodeTotal'] = self.task_node_total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('TaskNodeInService') is not None:
            self.task_node_in_service = m.get('TaskNodeInService')
        if m.get('AutoScalingSpotWithLimitAllowed') is not None:
            self.auto_scaling_spot_with_limit_allowed = m.get('AutoScalingSpotWithLimitAllowed')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('RelateClusterInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo()
            self.relate_cluster_info = temp_model.from_map(m['RelateClusterInfo'])
        if m.get('RelateClusterId') is not None:
            self.relate_cluster_id = m.get('RelateClusterId')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ResizeDiskEnable') is not None:
            self.resize_disk_enable = m.get('ResizeDiskEnable')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('FailReason') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('SoftwareInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo()
            self.software_info = temp_model.from_map(m['SoftwareInfo'])
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('AutoScalingVersion') is not None:
            self.auto_scaling_version = m.get('AutoScalingVersion')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('AccessInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfo()
            self.access_info = temp_model.from_map(m['AccessInfo'])
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('AutoScalingAllowed') is not None:
            self.auto_scaling_allowed = m.get('AutoScalingAllowed')
        if m.get('HostGroupList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        if m.get('MasterNodeInService') is not None:
            self.master_node_in_service = m.get('MasterNodeInService')
        if m.get('AutoScalingEnable') is not None:
            self.auto_scaling_enable = m.get('AutoScalingEnable')
        if m.get('AutoScalingWithGraceAllowed') is not None:
            self.auto_scaling_with_grace_allowed = m.get('AutoScalingWithGraceAllowed')
        if m.get('ShowSoftwareInterface') is not None:
            self.show_software_interface = m.get('ShowSoftwareInterface')
        if m.get('CoreNodeInService') is not None:
            self.core_node_in_service = m.get('CoreNodeInService')
        if m.get('AutoScalingByLoadAllowed') is not None:
            self.auto_scaling_by_load_allowed = m.get('AutoScalingByLoadAllowed')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('LocalMetaDb') is not None:
            self.local_meta_db = m.get('LocalMetaDb')
        if m.get('BootstrapActionList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('GatewayClusterInfoList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList()
            self.gateway_cluster_info_list = temp_model.from_map(m['GatewayClusterInfoList'])
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('HostPoolInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo()
            self.host_pool_info = temp_model.from_map(m['HostPoolInfo'])
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CoreNodeTotal') is not None:
            self.core_node_total = m.get('CoreNodeTotal')
        if m.get('GatewayClusterIds') is not None:
            self.gateway_cluster_ids = m.get('GatewayClusterIds')
        if m.get('BootstrapFailed') is not None:
            self.bootstrap_failed = m.get('BootstrapFailed')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TaskNodeTotal') is not None:
            self.task_node_total = m.get('TaskNodeTotal')
        return self


class DescribeClusterV2ResponseBody(TeaModel):
    def __init__(
        self,
        cluster_info: DescribeClusterV2ResponseBodyClusterInfo = None,
        request_id: str = None,
    ):
        self.cluster_info = cluster_info
        self.request_id = request_id

    def validate(self):
        if self.cluster_info:
            self.cluster_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_info is not None:
            result['ClusterInfo'] = self.cluster_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfo()
            self.cluster_info = temp_model.from_map(m['ClusterInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataSourceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeDataSourceResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        category_id: str = None,
        description: str = None,
        conf: str = None,
        request_id: str = None,
        cluster_id: str = None,
        source_type: str = None,
        gmt_modified: int = None,
        creator: str = None,
        create_from: str = None,
        name: str = None,
        gmt_create: int = None,
        id: str = None,
        modifier: str = None,
    ):
        self.status = status
        self.category_id = category_id
        self.description = description
        self.conf = conf
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.source_type = source_type
        self.gmt_modified = gmt_modified
        self.creator = creator
        self.create_from = create_from
        self.name = name
        self.gmt_create = gmt_create
        self.id = id
        self.modifier = modifier

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.description is not None:
            result['Description'] = self.description
        if self.conf is not None:
            result['Conf'] = self.conf
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.create_from is not None:
            result['CreateFrom'] = self.create_from
        if self.name is not None:
            result['Name'] = self.name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.modifier is not None:
            result['Modifier'] = self.modifier
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Conf') is not None:
            self.conf = m.get('Conf')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('CreateFrom') is not None:
            self.create_from = m.get('CreateFrom')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Modifier') is not None:
            self.modifier = m.get('Modifier')
        return self


class DescribeDataSourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDataSourceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDataSourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExecutionPlanRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeExecutionPlanResponseBodyJobInfoListJobInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        fail_act: str = None,
        name: str = None,
        run_parameter: str = None,
        id: str = None,
    ):
        self.type = type
        self.fail_act = fail_act
        self.name = name
        self.run_parameter = run_parameter
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.name is not None:
            result['Name'] = self.name
        if self.run_parameter is not None:
            result['RunParameter'] = self.run_parameter
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RunParameter') is not None:
            self.run_parameter = m.get('RunParameter')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeExecutionPlanResponseBodyJobInfoList(TeaModel):
    def __init__(
        self,
        job_info: List[DescribeExecutionPlanResponseBodyJobInfoListJobInfo] = None,
    ):
        self.job_info = job_info

    def validate(self):
        if self.job_info:
            for k in self.job_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['JobInfo'] = []
        if self.job_info is not None:
            for k in self.job_info:
                result['JobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job_info = []
        if m.get('JobInfo') is not None:
            for k in m.get('JobInfo'):
                temp_model = DescribeExecutionPlanResponseBodyJobInfoListJobInfo()
                self.job_info.append(temp_model.from_map(k))
        return self


class DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        start_tpe: int = None,
        version: str = None,
        only_display: bool = None,
        optional: bool = None,
        name: str = None,
    ):
        self.display_name = display_name
        self.start_tpe = start_tpe
        self.version = version
        self.only_display = only_display
        self.optional = optional
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.start_tpe is not None:
            result['StartTpe'] = self.start_tpe
        if self.version is not None:
            result['Version'] = self.version
        if self.only_display is not None:
            result['OnlyDisplay'] = self.only_display
        if self.optional is not None:
            result['Optional'] = self.optional
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('StartTpe') is not None:
            self.start_tpe = m.get('StartTpe')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('OnlyDisplay') is not None:
            self.only_display = m.get('OnlyDisplay')
        if m.get('Optional') is not None:
            self.optional = m.get('Optional')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfoSoftwares(TeaModel):
    def __init__(
        self,
        software: List[DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware] = None,
    ):
        self.software = software

    def validate(self):
        if self.software:
            for k in self.software:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Software'] = []
        if self.software is not None:
            for k in self.software:
                result['Software'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.software = []
        if m.get('Software') is not None:
            for k in m.get('Software'):
                temp_model = DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware()
                self.software.append(temp_model.from_map(k))
        return self


class DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfo(TeaModel):
    def __init__(
        self,
        emr_ver: str = None,
        cluster_type: str = None,
        softwares: DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfoSoftwares = None,
    ):
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.softwares = softwares

    def validate(self):
        if self.softwares:
            self.softwares.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.softwares is not None:
            result['Softwares'] = self.softwares.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('Softwares') is not None:
            temp_model = DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfoSoftwares()
            self.softwares = temp_model.from_map(m['Softwares'])
        return self


class DescribeExecutionPlanResponseBodyClusterInfoEcsOrdersEcsOrderInfo(TeaModel):
    def __init__(
        self,
        index: int = None,
        disk_capacity: int = None,
        node_type: str = None,
        node_count: int = None,
        disk_type: str = None,
        instance_type: str = None,
        disk_count: int = None,
    ):
        self.index = index
        self.disk_capacity = disk_capacity
        self.node_type = node_type
        self.node_count = node_count
        self.disk_type = disk_type
        self.instance_type = instance_type
        self.disk_count = disk_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.index is not None:
            result['Index'] = self.index
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        return self


class DescribeExecutionPlanResponseBodyClusterInfoEcsOrders(TeaModel):
    def __init__(
        self,
        ecs_order_info: List[DescribeExecutionPlanResponseBodyClusterInfoEcsOrdersEcsOrderInfo] = None,
    ):
        self.ecs_order_info = ecs_order_info

    def validate(self):
        if self.ecs_order_info:
            for k in self.ecs_order_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EcsOrderInfo'] = []
        if self.ecs_order_info is not None:
            for k in self.ecs_order_info:
                result['EcsOrderInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ecs_order_info = []
        if m.get('EcsOrderInfo') is not None:
            for k in m.get('EcsOrderInfo'):
                temp_model = DescribeExecutionPlanResponseBodyClusterInfoEcsOrdersEcsOrderInfo()
                self.ecs_order_info.append(temp_model.from_map(k))
        return self


class DescribeExecutionPlanResponseBodyClusterInfoConfigListConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class DescribeExecutionPlanResponseBodyClusterInfoConfigList(TeaModel):
    def __init__(
        self,
        config: List[DescribeExecutionPlanResponseBodyClusterInfoConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = DescribeExecutionPlanResponseBodyClusterInfoConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class DescribeExecutionPlanResponseBodyClusterInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(
        self,
        arg: str = None,
        path: str = None,
        name: str = None,
    ):
        self.arg = arg
        self.path = path
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeExecutionPlanResponseBodyClusterInfoBootstrapActionList(TeaModel):
    def __init__(
        self,
        bootstrap_action: List[DescribeExecutionPlanResponseBodyClusterInfoBootstrapActionListBootstrapAction] = None,
    ):
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = DescribeExecutionPlanResponseBodyClusterInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class DescribeExecutionPlanResponseBodyClusterInfo(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        use_custom_hive_meta_db: bool = None,
        log_enable: bool = None,
        user_defined_emr_ecs_role: str = None,
        high_availability_enable: bool = None,
        security_group_id: str = None,
        use_local_meta_db: bool = None,
        software_info: DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfo = None,
        io_optimized: bool = None,
        v_switch_id: str = None,
        configurations: str = None,
        ecs_orders: DescribeExecutionPlanResponseBodyClusterInfoEcsOrders = None,
        emr_ver: str = None,
        log_path: str = None,
        cluster_type: str = None,
        init_custom_hive_meta_db: bool = None,
        net_type: str = None,
        zone_id: str = None,
        config_list: DescribeExecutionPlanResponseBodyClusterInfoConfigList = None,
        bootstrap_action_list: DescribeExecutionPlanResponseBodyClusterInfoBootstrapActionList = None,
        instance_generation: str = None,
        name: str = None,
        eas_enable: bool = None,
    ):
        self.vpc_id = vpc_id
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.log_enable = log_enable
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.high_availability_enable = high_availability_enable
        self.security_group_id = security_group_id
        self.use_local_meta_db = use_local_meta_db
        self.software_info = software_info
        self.io_optimized = io_optimized
        self.v_switch_id = v_switch_id
        self.configurations = configurations
        self.ecs_orders = ecs_orders
        self.emr_ver = emr_ver
        self.log_path = log_path
        self.cluster_type = cluster_type
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.net_type = net_type
        self.zone_id = zone_id
        self.config_list = config_list
        self.bootstrap_action_list = bootstrap_action_list
        self.instance_generation = instance_generation
        self.name = name
        self.eas_enable = eas_enable

    def validate(self):
        if self.software_info:
            self.software_info.validate()
        if self.ecs_orders:
            self.ecs_orders.validate()
        if self.config_list:
            self.config_list.validate()
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDB'] = self.use_custom_hive_meta_db
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info.to_map()
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.ecs_orders is not None:
            result['EcsOrders'] = self.ecs_orders.to_map()
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDB'] = self.init_custom_hive_meta_db
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.name is not None:
            result['Name'] = self.name
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('UseCustomHiveMetaDB') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDB')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('SoftwareInfo') is not None:
            temp_model = DescribeExecutionPlanResponseBodyClusterInfoSoftwareInfo()
            self.software_info = temp_model.from_map(m['SoftwareInfo'])
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EcsOrders') is not None:
            temp_model = DescribeExecutionPlanResponseBodyClusterInfoEcsOrders()
            self.ecs_orders = temp_model.from_map(m['EcsOrders'])
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('InitCustomHiveMetaDB') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDB')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('ConfigList') is not None:
            temp_model = DescribeExecutionPlanResponseBodyClusterInfoConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        if m.get('BootstrapActionList') is not None:
            temp_model = DescribeExecutionPlanResponseBodyClusterInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        return self


class DescribeExecutionPlanResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        workflow_app: str = None,
        day_of_week: str = None,
        time_interval: int = None,
        request_id: str = None,
        cluster_id: str = None,
        day_of_month: str = None,
        execution_plan_version: int = None,
        start_time: int = None,
        name: str = None,
        job_info_list: DescribeExecutionPlanResponseBodyJobInfoList = None,
        cluster_info: DescribeExecutionPlanResponseBodyClusterInfo = None,
        time_unit: str = None,
        strategy: str = None,
        cluster_name: str = None,
        id: str = None,
        create_cluster_on_demand: bool = None,
    ):
        self.status = status
        self.workflow_app = workflow_app
        self.day_of_week = day_of_week
        self.time_interval = time_interval
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.day_of_month = day_of_month
        self.execution_plan_version = execution_plan_version
        self.start_time = start_time
        self.name = name
        self.job_info_list = job_info_list
        self.cluster_info = cluster_info
        self.time_unit = time_unit
        self.strategy = strategy
        self.cluster_name = cluster_name
        self.id = id
        self.create_cluster_on_demand = create_cluster_on_demand

    def validate(self):
        if self.job_info_list:
            self.job_info_list.validate()
        if self.cluster_info:
            self.cluster_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.workflow_app is not None:
            result['WorkflowApp'] = self.workflow_app
        if self.day_of_week is not None:
            result['DayOfWeek'] = self.day_of_week
        if self.time_interval is not None:
            result['TimeInterval'] = self.time_interval
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.day_of_month is not None:
            result['DayOfMonth'] = self.day_of_month
        if self.execution_plan_version is not None:
            result['ExecutionPlanVersion'] = self.execution_plan_version
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.name is not None:
            result['Name'] = self.name
        if self.job_info_list is not None:
            result['JobInfoList'] = self.job_info_list.to_map()
        if self.cluster_info is not None:
            result['ClusterInfo'] = self.cluster_info.to_map()
        if self.time_unit is not None:
            result['TimeUnit'] = self.time_unit
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.id is not None:
            result['Id'] = self.id
        if self.create_cluster_on_demand is not None:
            result['CreateClusterOnDemand'] = self.create_cluster_on_demand
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('WorkflowApp') is not None:
            self.workflow_app = m.get('WorkflowApp')
        if m.get('DayOfWeek') is not None:
            self.day_of_week = m.get('DayOfWeek')
        if m.get('TimeInterval') is not None:
            self.time_interval = m.get('TimeInterval')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DayOfMonth') is not None:
            self.day_of_month = m.get('DayOfMonth')
        if m.get('ExecutionPlanVersion') is not None:
            self.execution_plan_version = m.get('ExecutionPlanVersion')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('JobInfoList') is not None:
            temp_model = DescribeExecutionPlanResponseBodyJobInfoList()
            self.job_info_list = temp_model.from_map(m['JobInfoList'])
        if m.get('ClusterInfo') is not None:
            temp_model = DescribeExecutionPlanResponseBodyClusterInfo()
            self.cluster_info = temp_model.from_map(m['ClusterInfo'])
        if m.get('TimeUnit') is not None:
            self.time_unit = m.get('TimeUnit')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('CreateClusterOnDemand') is not None:
            self.create_cluster_on_demand = m.get('CreateClusterOnDemand')
        return self


class DescribeExecutionPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExecutionPlanResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExecutionPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowResponseBodyParentFlowListParentFlow(TeaModel):
    def __init__(
        self,
        project_name: str = None,
        project_id: str = None,
        parent_flow_name: str = None,
        parent_flow_id: str = None,
    ):
        self.project_name = project_name
        self.project_id = project_id
        self.parent_flow_name = parent_flow_name
        self.parent_flow_id = parent_flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.parent_flow_name is not None:
            result['ParentFlowName'] = self.parent_flow_name
        if self.parent_flow_id is not None:
            result['ParentFlowId'] = self.parent_flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ParentFlowName') is not None:
            self.parent_flow_name = m.get('ParentFlowName')
        if m.get('ParentFlowId') is not None:
            self.parent_flow_id = m.get('ParentFlowId')
        return self


class DescribeFlowResponseBodyParentFlowList(TeaModel):
    def __init__(
        self,
        parent_flow: List[DescribeFlowResponseBodyParentFlowListParentFlow] = None,
    ):
        self.parent_flow = parent_flow

    def validate(self):
        if self.parent_flow:
            for k in self.parent_flow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParentFlow'] = []
        if self.parent_flow is not None:
            for k in self.parent_flow:
                result['ParentFlow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parent_flow = []
        if m.get('ParentFlow') is not None:
            for k in m.get('ParentFlow'):
                temp_model = DescribeFlowResponseBodyParentFlowListParentFlow()
                self.parent_flow.append(temp_model.from_map(k))
        return self


class DescribeFlowResponseBody(TeaModel):
    def __init__(
        self,
        category_id: str = None,
        description: str = None,
        gmt_modified: int = None,
        periodic: bool = None,
        cron_expr: str = None,
        alert_ding_ding_group_biz_id: str = None,
        name: str = None,
        alert_user_group_biz_id: str = None,
        log_archive_location: str = None,
        end_schedule: int = None,
        host_name: str = None,
        status: str = None,
        start_schedule: int = None,
        request_id: str = None,
        cluster_id: str = None,
        lifecycle: str = None,
        edit_lock_detail: str = None,
        namespace: str = None,
        type: str = None,
        gmt_create: int = None,
        graph: str = None,
        id: str = None,
        application: str = None,
        create_cluster: bool = None,
        alert_conf: str = None,
        parent_flow_list: DescribeFlowResponseBodyParentFlowList = None,
    ):
        self.category_id = category_id
        self.description = description
        self.gmt_modified = gmt_modified
        self.periodic = periodic
        self.cron_expr = cron_expr
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id
        self.name = name
        self.alert_user_group_biz_id = alert_user_group_biz_id
        self.log_archive_location = log_archive_location
        self.end_schedule = end_schedule
        self.host_name = host_name
        self.status = status
        self.start_schedule = start_schedule
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.lifecycle = lifecycle
        self.edit_lock_detail = edit_lock_detail
        self.namespace = namespace
        self.type = type
        self.gmt_create = gmt_create
        self.graph = graph
        self.id = id
        self.application = application
        self.create_cluster = create_cluster
        self.alert_conf = alert_conf
        self.parent_flow_list = parent_flow_list

    def validate(self):
        if self.parent_flow_list:
            self.parent_flow_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.name is not None:
            result['Name'] = self.name
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.log_archive_location is not None:
            result['LogArchiveLocation'] = self.log_archive_location
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.status is not None:
            result['Status'] = self.status
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.lifecycle is not None:
            result['Lifecycle'] = self.lifecycle
        if self.edit_lock_detail is not None:
            result['EditLockDetail'] = self.edit_lock_detail
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.id is not None:
            result['Id'] = self.id
        if self.application is not None:
            result['Application'] = self.application
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('LogArchiveLocation') is not None:
            self.log_archive_location = m.get('LogArchiveLocation')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Lifecycle') is not None:
            self.lifecycle = m.get('Lifecycle')
        if m.get('EditLockDetail') is not None:
            self.edit_lock_detail = m.get('EditLockDetail')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ParentFlowList') is not None:
            temp_model = DescribeFlowResponseBodyParentFlowList()
            self.parent_flow_list = temp_model.from_map(m['ParentFlowList'])
        return self


class DescribeFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowCategoryRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowCategoryResponseBody(TeaModel):
    def __init__(
        self,
        parent_id: str = None,
        object_type: str = None,
        type: str = None,
        gmt_create: int = None,
        request_id: str = None,
        object_id: str = None,
        project_id: str = None,
        gmt_modified: int = None,
        category_type: str = None,
        id: str = None,
        name: str = None,
    ):
        self.parent_id = parent_id
        self.object_type = object_type
        self.type = type
        self.gmt_create = gmt_create
        self.request_id = request_id
        self.object_id = object_id
        self.project_id = project_id
        self.gmt_modified = gmt_modified
        self.category_type = category_type
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.object_type is not None:
            result['ObjectType'] = self.object_type
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.object_id is not None:
            result['ObjectId'] = self.object_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.category_type is not None:
            result['CategoryType'] = self.category_type
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ObjectType') is not None:
            self.object_type = m.get('ObjectType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ObjectId') is not None:
            self.object_id = m.get('ObjectId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('CategoryType') is not None:
            self.category_type = m.get('CategoryType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeFlowCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowCategoryTreeRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
        type: str = None,
        mode: str = None,
        keyword: str = None,
        category_id: str = None,
    ):
        self.project_id = project_id
        self.region_id = region_id
        self.type = type
        self.mode = mode
        self.keyword = keyword
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class DescribeFlowCategoryTreeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class DescribeFlowCategoryTreeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowCategoryTreeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowCategoryTreeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance(TeaModel):
    def __init__(
        self,
        type: str = None,
        status: str = None,
        fail_act: str = None,
        retry_interval: str = None,
        project_id: str = None,
        job_type: str = None,
        host_name: str = None,
        gmt_modified: int = None,
        external_info: str = None,
        retries: int = None,
        end_time: int = None,
        start_time: int = None,
        external_status: str = None,
        job_name: str = None,
        node_name: str = None,
        job_id: str = None,
        gmt_create: int = None,
        external_id: str = None,
        duration: int = None,
        id: str = None,
        pending: bool = None,
        cluster_id: str = None,
        max_retry: str = None,
    ):
        self.type = type
        self.status = status
        self.fail_act = fail_act
        self.retry_interval = retry_interval
        self.project_id = project_id
        self.job_type = job_type
        self.host_name = host_name
        self.gmt_modified = gmt_modified
        self.external_info = external_info
        self.retries = retries
        self.end_time = end_time
        self.start_time = start_time
        self.external_status = external_status
        self.job_name = job_name
        self.node_name = node_name
        self.job_id = job_id
        self.gmt_create = gmt_create
        self.external_id = external_id
        self.duration = duration
        self.id = id
        self.pending = pending
        self.cluster_id = cluster_id
        self.max_retry = max_retry

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info
        if self.retries is not None:
            result['Retries'] = self.retries
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.external_status is not None:
            result['ExternalStatus'] = self.external_status
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        if self.pending is not None:
            result['Pending'] = self.pending
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ExternalInfo') is not None:
            self.external_info = m.get('ExternalInfo')
        if m.get('Retries') is not None:
            self.retries = m.get('Retries')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ExternalStatus') is not None:
            self.external_status = m.get('ExternalStatus')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Pending') is not None:
            self.pending = m.get('Pending')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        return self


class DescribeFlowInstanceResponseBodyNodeInstance(TeaModel):
    def __init__(
        self,
        node_instance: List[DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance] = None,
    ):
        self.node_instance = node_instance

    def validate(self):
        if self.node_instance:
            for k in self.node_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeInstance'] = []
        if self.node_instance is not None:
            for k in self.node_instance:
                result['NodeInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_instance = []
        if m.get('NodeInstance') is not None:
            for k in m.get('NodeInstance'):
                temp_model = DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance()
                self.node_instance.append(temp_model.from_map(k))
        return self


class DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow(TeaModel):
    def __init__(
        self,
        schedule_key: str = None,
        biz_date: int = None,
        dependency_instance_id: str = None,
        dependency_flow_id: str = None,
        meet: bool = None,
        flow_instance_id: str = None,
        project_id: str = None,
        flow_id: str = None,
    ):
        self.schedule_key = schedule_key
        self.biz_date = biz_date
        self.dependency_instance_id = dependency_instance_id
        self.dependency_flow_id = dependency_flow_id
        self.meet = meet
        self.flow_instance_id = flow_instance_id
        self.project_id = project_id
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_key is not None:
            result['ScheduleKey'] = self.schedule_key
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.dependency_instance_id is not None:
            result['DependencyInstanceId'] = self.dependency_instance_id
        if self.dependency_flow_id is not None:
            result['DependencyFlowId'] = self.dependency_flow_id
        if self.meet is not None:
            result['Meet'] = self.meet
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleKey') is not None:
            self.schedule_key = m.get('ScheduleKey')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DependencyInstanceId') is not None:
            self.dependency_instance_id = m.get('DependencyInstanceId')
        if m.get('DependencyFlowId') is not None:
            self.dependency_flow_id = m.get('DependencyFlowId')
        if m.get('Meet') is not None:
            self.meet = m.get('Meet')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class DescribeFlowInstanceResponseBodyDependencyFlowList(TeaModel):
    def __init__(
        self,
        parent_flow: List[DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow] = None,
    ):
        self.parent_flow = parent_flow

    def validate(self):
        if self.parent_flow:
            for k in self.parent_flow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParentFlow'] = []
        if self.parent_flow is not None:
            for k in self.parent_flow:
                result['ParentFlow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parent_flow = []
        if m.get('ParentFlow') is not None:
            for k in m.get('ParentFlow'):
                temp_model = DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow()
                self.parent_flow.append(temp_model.from_map(k))
        return self


class DescribeFlowInstanceResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        has_node_failed: bool = None,
        end_time: int = None,
        request_id: str = None,
        cluster_id: str = None,
        lifecycle: str = None,
        project_id: str = None,
        gmt_modified: int = None,
        start_time: int = None,
        duration: int = None,
        namespace: str = None,
        flow_id: str = None,
        gmt_create: int = None,
        graph: str = None,
        schedule_time: int = None,
        flow_name: str = None,
        cron_expression: str = None,
        log_archive_location: str = None,
        id: str = None,
        node_instance: DescribeFlowInstanceResponseBodyNodeInstance = None,
        dependency_flow_list: DescribeFlowInstanceResponseBodyDependencyFlowList = None,
    ):
        self.status = status
        self.has_node_failed = has_node_failed
        self.end_time = end_time
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.lifecycle = lifecycle
        self.project_id = project_id
        self.gmt_modified = gmt_modified
        self.start_time = start_time
        self.duration = duration
        self.namespace = namespace
        self.flow_id = flow_id
        self.gmt_create = gmt_create
        self.graph = graph
        self.schedule_time = schedule_time
        self.flow_name = flow_name
        self.cron_expression = cron_expression
        self.log_archive_location = log_archive_location
        self.id = id
        self.node_instance = node_instance
        self.dependency_flow_list = dependency_flow_list

    def validate(self):
        if self.node_instance:
            self.node_instance.validate()
        if self.dependency_flow_list:
            self.dependency_flow_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.has_node_failed is not None:
            result['HasNodeFailed'] = self.has_node_failed
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.lifecycle is not None:
            result['Lifecycle'] = self.lifecycle
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.log_archive_location is not None:
            result['LogArchiveLocation'] = self.log_archive_location
        if self.id is not None:
            result['Id'] = self.id
        if self.node_instance is not None:
            result['NodeInstance'] = self.node_instance.to_map()
        if self.dependency_flow_list is not None:
            result['DependencyFlowList'] = self.dependency_flow_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('HasNodeFailed') is not None:
            self.has_node_failed = m.get('HasNodeFailed')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Lifecycle') is not None:
            self.lifecycle = m.get('Lifecycle')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('LogArchiveLocation') is not None:
            self.log_archive_location = m.get('LogArchiveLocation')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('NodeInstance') is not None:
            temp_model = DescribeFlowInstanceResponseBodyNodeInstance()
            self.node_instance = temp_model.from_map(m['NodeInstance'])
        if m.get('DependencyFlowList') is not None:
            temp_model = DescribeFlowInstanceResponseBodyDependencyFlowList()
            self.dependency_flow_list = temp_model.from_map(m['DependencyFlowList'])
        return self


class DescribeFlowInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowJobRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowJobResponseBodyResourceListResource(TeaModel):
    def __init__(
        self,
        path: str = None,
        alias: str = None,
    ):
        self.path = path
        self.alias = alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class DescribeFlowJobResponseBodyResourceList(TeaModel):
    def __init__(
        self,
        resource: List[DescribeFlowJobResponseBodyResourceListResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeFlowJobResponseBodyResourceListResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        fail_act: str = None,
        category_id: str = None,
        description: str = None,
        gmt_modified: int = None,
        name: str = None,
        param_conf: str = None,
        mode: str = None,
        adhoc: str = None,
        request_id: str = None,
        last_instance_id: str = None,
        params: str = None,
        max_retry: int = None,
        max_running_time_sec: int = None,
        edit_lock_detail: str = None,
        type: str = None,
        gmt_create: int = None,
        resource_list: DescribeFlowJobResponseBodyResourceList = None,
        env_conf: str = None,
        monitor_conf: str = None,
        retry_interval: int = None,
        run_conf: str = None,
        id: str = None,
        retry_policy: str = None,
        custom_variables: str = None,
        alert_conf: str = None,
    ):
        self.fail_act = fail_act
        self.category_id = category_id
        self.description = description
        self.gmt_modified = gmt_modified
        self.name = name
        self.param_conf = param_conf
        self.mode = mode
        self.adhoc = adhoc
        self.request_id = request_id
        self.last_instance_id = last_instance_id
        self.params = params
        self.max_retry = max_retry
        self.max_running_time_sec = max_running_time_sec
        self.edit_lock_detail = edit_lock_detail
        self.type = type
        self.gmt_create = gmt_create
        self.resource_list = resource_list
        self.env_conf = env_conf
        self.monitor_conf = monitor_conf
        self.retry_interval = retry_interval
        self.run_conf = run_conf
        self.id = id
        self.retry_policy = retry_policy
        self.custom_variables = custom_variables
        self.alert_conf = alert_conf

    def validate(self):
        if self.resource_list:
            self.resource_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.mode is not None:
            result['mode'] = self.mode
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.last_instance_id is not None:
            result['LastInstanceId'] = self.last_instance_id
        if self.params is not None:
            result['Params'] = self.params
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.max_running_time_sec is not None:
            result['MaxRunningTimeSec'] = self.max_running_time_sec
        if self.edit_lock_detail is not None:
            result['EditLockDetail'] = self.edit_lock_detail
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.resource_list is not None:
            result['ResourceList'] = self.resource_list.to_map()
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.id is not None:
            result['Id'] = self.id
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LastInstanceId') is not None:
            self.last_instance_id = m.get('LastInstanceId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('MaxRunningTimeSec') is not None:
            self.max_running_time_sec = m.get('MaxRunningTimeSec')
        if m.get('EditLockDetail') is not None:
            self.edit_lock_detail = m.get('EditLockDetail')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ResourceList') is not None:
            temp_model = DescribeFlowJobResponseBodyResourceList()
            self.resource_list = temp_model.from_map(m['ResourceList'])
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        return self


class DescribeFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        fail_act: str = None,
        end_time: int = None,
        node_name: str = None,
        gmt_modified: int = None,
        job_name: str = None,
        external_status: str = None,
        param_conf: str = None,
        flow_id: str = None,
        external_info: str = None,
        retries: int = None,
        cluster_name: str = None,
        adhoc: bool = None,
        job_params: str = None,
        host_name: str = None,
        job_id: str = None,
        status: str = None,
        request_id: str = None,
        cluster_id: str = None,
        mode: str = None,
        external_id: str = None,
        project_id: str = None,
        start_time: int = None,
        flow_instance_id: str = None,
        duration: int = None,
        max_retry: str = None,
        external_sub_id: str = None,
        type: str = None,
        gmt_create: int = None,
        env_conf: str = None,
        job_type: str = None,
        external_child_ids: str = None,
        monitor_conf: str = None,
        retry_interval: str = None,
        run_conf: str = None,
        id: str = None,
        retry_policy: str = None,
        pending: bool = None,
    ):
        self.fail_act = fail_act
        self.end_time = end_time
        self.node_name = node_name
        self.gmt_modified = gmt_modified
        self.job_name = job_name
        self.external_status = external_status
        self.param_conf = param_conf
        self.flow_id = flow_id
        self.external_info = external_info
        self.retries = retries
        self.cluster_name = cluster_name
        self.adhoc = adhoc
        self.job_params = job_params
        self.host_name = host_name
        self.job_id = job_id
        self.status = status
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.mode = mode
        self.external_id = external_id
        self.project_id = project_id
        self.start_time = start_time
        self.flow_instance_id = flow_instance_id
        self.duration = duration
        self.max_retry = max_retry
        self.external_sub_id = external_sub_id
        self.type = type
        self.gmt_create = gmt_create
        self.env_conf = env_conf
        self.job_type = job_type
        self.external_child_ids = external_child_ids
        self.monitor_conf = monitor_conf
        self.retry_interval = retry_interval
        self.run_conf = run_conf
        self.id = id
        self.retry_policy = retry_policy
        self.pending = pending

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.external_status is not None:
            result['ExternalStatus'] = self.external_status
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info
        if self.retries is not None:
            result['Retries'] = self.retries
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.status is not None:
            result['Status'] = self.status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.external_sub_id is not None:
            result['ExternalSubId'] = self.external_sub_id
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.external_child_ids is not None:
            result['ExternalChildIds'] = self.external_child_ids
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.id is not None:
            result['Id'] = self.id
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.pending is not None:
            result['Pending'] = self.pending
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('ExternalStatus') is not None:
            self.external_status = m.get('ExternalStatus')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('ExternalInfo') is not None:
            self.external_info = m.get('ExternalInfo')
        if m.get('Retries') is not None:
            self.retries = m.get('Retries')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('ExternalSubId') is not None:
            self.external_sub_id = m.get('ExternalSubId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('ExternalChildIds') is not None:
            self.external_child_ids = m.get('ExternalChildIds')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Pending') is not None:
            self.pending = m.get('Pending')
        return self


class DescribeFlowNodeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowNodeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceContainerLogRequest(TeaModel):
    def __init__(
        self,
        offset: int = None,
        length: int = None,
        node_instance_id: str = None,
        app_id: str = None,
        container_id: str = None,
        log_name: str = None,
        project_id: str = None,
        region_id: str = None,
    ):
        self.offset = offset
        self.length = length
        self.node_instance_id = node_instance_id
        self.app_id = app_id
        self.container_id = container_id
        self.log_name = log_name
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.length is not None:
            result['Length'] = self.length
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.log_name is not None:
            result['LogName'] = self.log_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('LogName') is not None:
            self.log_name = m.get('LogName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry(TeaModel):
    def __init__(
        self,
        content: str = None,
    ):
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys(TeaModel):
    def __init__(
        self,
        log_entry: List[DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry] = None,
    ):
        self.log_entry = log_entry

    def validate(self):
        if self.log_entry:
            for k in self.log_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogEntry'] = []
        if self.log_entry is not None:
            for k in self.log_entry:
                result['LogEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.log_entry = []
        if m.get('LogEntry') is not None:
            for k in m.get('LogEntry'):
                temp_model = DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry()
                self.log_entry.append(temp_model.from_map(k))
        return self


class DescribeFlowNodeInstanceContainerLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        log_end: bool = None,
        log_entrys: DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys = None,
    ):
        self.request_id = request_id
        self.log_end = log_end
        self.log_entrys = log_entrys

    def validate(self):
        if self.log_entrys:
            self.log_entrys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_end is not None:
            result['LogEnd'] = self.log_end
        if self.log_entrys is not None:
            result['LogEntrys'] = self.log_entrys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LogEnd') is not None:
            self.log_end = m.get('LogEnd')
        if m.get('LogEntrys') is not None:
            temp_model = DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys()
            self.log_entrys = temp_model.from_map(m['LogEntrys'])
        return self


class DescribeFlowNodeInstanceContainerLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowNodeInstanceContainerLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceContainerLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceLauncherLogRequest(TeaModel):
    def __init__(
        self,
        start: int = None,
        lines: int = None,
        offset: int = None,
        length: int = None,
        reverse: bool = None,
        start_time: int = None,
        end_time: int = None,
        node_instance_id: str = None,
        project_id: str = None,
        region_id: str = None,
    ):
        self.start = start
        self.lines = lines
        self.offset = offset
        self.length = length
        self.reverse = reverse
        self.start_time = start_time
        self.end_time = end_time
        self.node_instance_id = node_instance_id
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.lines is not None:
            result['Lines'] = self.lines
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.length is not None:
            result['Length'] = self.length
        if self.reverse is not None:
            result['Reverse'] = self.reverse
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Lines') is not None:
            self.lines = m.get('Lines')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('Reverse') is not None:
            self.reverse = m.get('Reverse')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry(TeaModel):
    def __init__(
        self,
        content: str = None,
    ):
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys(TeaModel):
    def __init__(
        self,
        log_entry: List[DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry] = None,
    ):
        self.log_entry = log_entry

    def validate(self):
        if self.log_entry:
            for k in self.log_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogEntry'] = []
        if self.log_entry is not None:
            for k in self.log_entry:
                result['LogEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.log_entry = []
        if m.get('LogEntry') is not None:
            for k in m.get('LogEntry'):
                temp_model = DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry()
                self.log_entry.append(temp_model.from_map(k))
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        log_end: bool = None,
        log_entrys: DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys = None,
    ):
        self.request_id = request_id
        self.log_end = log_end
        self.log_entrys = log_entrys

    def validate(self):
        if self.log_entrys:
            self.log_entrys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_end is not None:
            result['LogEnd'] = self.log_end
        if self.log_entrys is not None:
            result['LogEntrys'] = self.log_entrys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LogEnd') is not None:
            self.log_end = m.get('LogEnd')
        if m.get('LogEntrys') is not None:
            temp_model = DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys()
            self.log_entrys = temp_model.from_map(m['LogEntrys'])
        return self


class DescribeFlowNodeInstanceLauncherLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowNodeInstanceLauncherLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceLauncherLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowProjectResponseBody(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        description: str = None,
        request_id: str = None,
        user_id: str = None,
        gmt_modified: int = None,
        id: str = None,
        name: str = None,
    ):
        self.gmt_create = gmt_create
        self.description = description
        self.request_id = request_id
        self.user_id = user_id
        self.gmt_modified = gmt_modified
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.description is not None:
            result['Description'] = self.description
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeFlowProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowProjectClusterSettingRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
        cluster_id: str = None,
    ):
        self.project_id = project_id
        self.region_id = region_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeFlowProjectClusterSettingResponseBodyHostList(TeaModel):
    def __init__(
        self,
        host: List[str] = None,
    ):
        self.host = host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        return self


class DescribeFlowProjectClusterSettingResponseBodyUserList(TeaModel):
    def __init__(
        self,
        user: List[str] = None,
    ):
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeFlowProjectClusterSettingResponseBodyQueueList(TeaModel):
    def __init__(
        self,
        queue: List[str] = None,
    ):
        self.queue = queue

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class DescribeFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(
        self,
        gmt_create: int = None,
        default_user: str = None,
        request_id: str = None,
        default_queue: str = None,
        cluster_id: str = None,
        project_id: str = None,
        gmt_modified: int = None,
        host_list: DescribeFlowProjectClusterSettingResponseBodyHostList = None,
        user_list: DescribeFlowProjectClusterSettingResponseBodyUserList = None,
        k_8s_cluster_id: str = None,
        queue_list: DescribeFlowProjectClusterSettingResponseBodyQueueList = None,
    ):
        self.gmt_create = gmt_create
        self.default_user = default_user
        self.request_id = request_id
        self.default_queue = default_queue
        self.cluster_id = cluster_id
        self.project_id = project_id
        self.gmt_modified = gmt_modified
        self.host_list = host_list
        self.user_list = user_list
        self.k_8s_cluster_id = k_8s_cluster_id
        self.queue_list = queue_list

    def validate(self):
        if self.host_list:
            self.host_list.validate()
        if self.user_list:
            self.user_list.validate()
        if self.queue_list:
            self.queue_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HostList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        if m.get('UserList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('QueueList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyQueueList()
            self.queue_list = temp_model.from_map(m['QueueList'])
        return self


class DescribeFlowProjectClusterSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowProjectClusterSettingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeJobRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        id: str = None,
        region_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.id = id
        self.region_id = region_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeJobResponseBody(TeaModel):
    def __init__(
        self,
        fail_act: str = None,
        type: str = None,
        run_parameter: str = None,
        request_id: str = None,
        retry_interval: int = None,
        id: str = None,
        max_retry: int = None,
        name: str = None,
    ):
        self.fail_act = fail_act
        self.type = type
        self.run_parameter = run_parameter
        self.request_id = request_id
        self.retry_interval = retry_interval
        self.id = id
        self.max_retry = max_retry
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.type is not None:
            result['Type'] = self.type
        if self.run_parameter is not None:
            result['RunParameter'] = self.run_parameter
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.id is not None:
            result['Id'] = self.id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('RunParameter') is not None:
            self.run_parameter = m.get('RunParameter')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLibraryDetailRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        library_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.library_biz_id = library_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        return self


class DescribeLibraryDetailResponseBody(TeaModel):
    def __init__(
        self,
        source_location: str = None,
        type: str = None,
        request_id: str = None,
        scope: str = None,
        user_id: str = None,
        create_time: int = None,
        source_type: str = None,
        library_version: str = None,
        properties: str = None,
        biz_id: str = None,
        name: str = None,
    ):
        self.source_location = source_location
        self.type = type
        self.request_id = request_id
        self.scope = scope
        self.user_id = user_id
        self.create_time = create_time
        self.source_type = source_type
        self.library_version = library_version
        self.properties = properties
        self.biz_id = biz_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_location is not None:
            result['SourceLocation'] = self.source_location
        if self.type is not None:
            result['Type'] = self.type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.library_version is not None:
            result['LibraryVersion'] = self.library_version
        if self.properties is not None:
            result['Properties'] = self.properties
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceLocation') is not None:
            self.source_location = m.get('SourceLocation')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('LibraryVersion') is not None:
            self.library_version = m.get('LibraryVersion')
        if m.get('Properties') is not None:
            self.properties = m.get('Properties')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeLibraryDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLibraryDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLibraryDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLibraryInstallTaskDetailRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        task_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.task_biz_id = task_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_biz_id is not None:
            result['TaskBizId'] = self.task_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskBizId') is not None:
            self.task_biz_id = m.get('TaskBizId')
        return self


class DescribeLibraryInstallTaskDetailResponseBody(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        end_time: int = None,
        request_id: str = None,
        task_group_id: str = None,
        execute_time: int = None,
        hostname: str = None,
        start_time: int = None,
        task_status: str = None,
        library_biz_id: str = None,
        task_process: int = None,
        cluster_biz_id: str = None,
        task_type: str = None,
        detail: str = None,
    ):
        self.task_id = task_id
        self.end_time = end_time
        self.request_id = request_id
        self.task_group_id = task_group_id
        self.execute_time = execute_time
        self.hostname = hostname
        self.start_time = start_time
        self.task_status = task_status
        self.library_biz_id = library_biz_id
        self.task_process = task_process
        self.cluster_biz_id = cluster_biz_id
        self.task_type = task_type
        self.detail = detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_group_id is not None:
            result['TaskGroupId'] = self.task_group_id
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        if self.task_process is not None:
            result['TaskProcess'] = self.task_process
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.detail is not None:
            result['Detail'] = self.detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskGroupId') is not None:
            self.task_group_id = m.get('TaskGroupId')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        if m.get('TaskProcess') is not None:
            self.task_process = m.get('TaskProcess')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        return self


class DescribeLibraryInstallTaskDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLibraryInstallTaskDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLibraryInstallTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetaTablePreviewTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        task_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.task_id = task_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns(TeaModel):
    def __init__(
        self,
        column: List[str] = None,
    ):
        self.column = column

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column is not None:
            result['Column'] = self.column
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Column') is not None:
            self.column = m.get('Column')
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRowsRow(TeaModel):
    def __init__(
        self,
        columns: DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns = None,
    ):
        self.columns = columns

    def validate(self):
        if self.columns:
            self.columns.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.columns is not None:
            result['Columns'] = self.columns.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Columns') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns()
            self.columns = temp_model.from_map(m['Columns'])
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRows(TeaModel):
    def __init__(
        self,
        row: List[DescribeMetaTablePreviewTaskResponseBodyDataRowsRow] = None,
    ):
        self.row = row

    def validate(self):
        if self.row:
            for k in self.row:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Row'] = []
        if self.row is not None:
            for k in self.row:
                result['Row'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.row = []
        if m.get('Row') is not None:
            for k in m.get('Row'):
                temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRowsRow()
                self.row.append(temp_model.from_map(k))
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataHeaders(TeaModel):
    def __init__(
        self,
        header: List[str] = None,
    ):
        self.header = header

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header is not None:
            result['Header'] = self.header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Header') is not None:
            self.header = m.get('Header')
        return self


class DescribeMetaTablePreviewTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        rows: DescribeMetaTablePreviewTaskResponseBodyDataRows = None,
        headers: DescribeMetaTablePreviewTaskResponseBodyDataHeaders = None,
    ):
        self.rows = rows
        self.headers = headers

    def validate(self):
        if self.rows:
            self.rows.validate()
        if self.headers:
            self.headers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rows is not None:
            result['Rows'] = self.rows.to_map()
        if self.headers is not None:
            result['Headers'] = self.headers.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Rows') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRows()
            self.rows = temp_model.from_map(m['Rows'])
        if m.get('Headers') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataHeaders()
            self.headers = temp_model.from_map(m['Headers'])
        return self


class DescribeMetaTablePreviewTaskResponseBody(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        end_time: int = None,
        request_id: str = None,
        task_process: int = None,
        execute_time: int = None,
        start_time: int = None,
        data: DescribeMetaTablePreviewTaskResponseBodyData = None,
        task_status: str = None,
    ):
        self.task_id = task_id
        self.end_time = end_time
        self.request_id = request_id
        self.task_process = task_process
        self.execute_time = execute_time
        self.start_time = start_time
        self.data = data
        self.task_status = task_status

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_process is not None:
            result['TaskProcess'] = self.task_process
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskProcess') is not None:
            self.task_process = m.get('TaskProcess')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Data') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeMetaTablePreviewTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeMetaTablePreviewTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingActivityRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_group_id: str = None,
        scaling_activity_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_group_id = host_group_id
        self.scaling_activity_id = scaling_activity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.scaling_activity_id is not None:
            result['ScalingActivityId'] = self.scaling_activity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('ScalingActivityId') is not None:
            self.scaling_activity_id = m.get('ScalingActivityId')
        return self


class DescribeScalingActivityResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        description: str = None,
        end_time: int = None,
        request_id: str = None,
        expect_num: int = None,
        cause: str = None,
        start_time: int = None,
        scaling_rule_id: str = None,
        transition: str = None,
        total_capacity: int = None,
        instance_ids: str = None,
        biz_id: str = None,
    ):
        self.status = status
        self.description = description
        self.end_time = end_time
        self.request_id = request_id
        self.expect_num = expect_num
        self.cause = cause
        self.start_time = start_time
        self.scaling_rule_id = scaling_rule_id
        self.transition = transition
        self.total_capacity = total_capacity
        self.instance_ids = instance_ids
        self.biz_id = biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.expect_num is not None:
            result['ExpectNum'] = self.expect_num
        if self.cause is not None:
            result['Cause'] = self.cause
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.scaling_rule_id is not None:
            result['ScalingRuleId'] = self.scaling_rule_id
        if self.transition is not None:
            result['Transition'] = self.transition
        if self.total_capacity is not None:
            result['TotalCapacity'] = self.total_capacity
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ExpectNum') is not None:
            self.expect_num = m.get('ExpectNum')
        if m.get('Cause') is not None:
            self.cause = m.get('Cause')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ScalingRuleId') is not None:
            self.scaling_rule_id = m.get('ScalingRuleId')
        if m.get('Transition') is not None:
            self.transition = m.get('Transition')
        if m.get('TotalCapacity') is not None:
            self.total_capacity = m.get('TotalCapacity')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        return self


class DescribeScalingActivityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingActivityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingActivityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingCommonConfigRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeScalingCommonConfigResponseBody(TeaModel):
    def __init__(
        self,
        auto_scaling_hook_heartbeat_default_time: int = None,
        auto_scaling_rule_alarm_delay_limit: int = None,
        request_id: str = None,
        auto_scaling_group_max_size_limit: int = None,
        auto_scaling_mnsscaling_thread_sleep_time: int = None,
        auto_scaling_config_decommission_query_interval: int = None,
        auto_scaling_cool_down_time: int = None,
        auto_scaling_rule_min_delay_limit: int = None,
        auto_scaling_rule_alarm_silent_time: int = None,
        auto_scaling_config_system_disk_size: int = None,
        auto_scaling_group_min_size_limit: int = None,
    ):
        self.auto_scaling_hook_heartbeat_default_time = auto_scaling_hook_heartbeat_default_time
        self.auto_scaling_rule_alarm_delay_limit = auto_scaling_rule_alarm_delay_limit
        self.request_id = request_id
        self.auto_scaling_group_max_size_limit = auto_scaling_group_max_size_limit
        self.auto_scaling_mnsscaling_thread_sleep_time = auto_scaling_mnsscaling_thread_sleep_time
        self.auto_scaling_config_decommission_query_interval = auto_scaling_config_decommission_query_interval
        self.auto_scaling_cool_down_time = auto_scaling_cool_down_time
        self.auto_scaling_rule_min_delay_limit = auto_scaling_rule_min_delay_limit
        self.auto_scaling_rule_alarm_silent_time = auto_scaling_rule_alarm_silent_time
        self.auto_scaling_config_system_disk_size = auto_scaling_config_system_disk_size
        self.auto_scaling_group_min_size_limit = auto_scaling_group_min_size_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_scaling_hook_heartbeat_default_time is not None:
            result['AutoScalingHookHeartbeatDefaultTime'] = self.auto_scaling_hook_heartbeat_default_time
        if self.auto_scaling_rule_alarm_delay_limit is not None:
            result['AutoScalingRuleAlarmDelayLimit'] = self.auto_scaling_rule_alarm_delay_limit
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.auto_scaling_group_max_size_limit is not None:
            result['AutoScalingGroupMaxSizeLimit'] = self.auto_scaling_group_max_size_limit
        if self.auto_scaling_mnsscaling_thread_sleep_time is not None:
            result['AutoScalingMNSScalingThreadSleepTime'] = self.auto_scaling_mnsscaling_thread_sleep_time
        if self.auto_scaling_config_decommission_query_interval is not None:
            result['AutoScalingConfigDecommissionQueryInterval'] = self.auto_scaling_config_decommission_query_interval
        if self.auto_scaling_cool_down_time is not None:
            result['AutoScalingCoolDownTime'] = self.auto_scaling_cool_down_time
        if self.auto_scaling_rule_min_delay_limit is not None:
            result['AutoScalingRuleMinDelayLimit'] = self.auto_scaling_rule_min_delay_limit
        if self.auto_scaling_rule_alarm_silent_time is not None:
            result['AutoScalingRuleAlarmSilentTime'] = self.auto_scaling_rule_alarm_silent_time
        if self.auto_scaling_config_system_disk_size is not None:
            result['AutoScalingConfigSystemDiskSize'] = self.auto_scaling_config_system_disk_size
        if self.auto_scaling_group_min_size_limit is not None:
            result['AutoScalingGroupMinSizeLimit'] = self.auto_scaling_group_min_size_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoScalingHookHeartbeatDefaultTime') is not None:
            self.auto_scaling_hook_heartbeat_default_time = m.get('AutoScalingHookHeartbeatDefaultTime')
        if m.get('AutoScalingRuleAlarmDelayLimit') is not None:
            self.auto_scaling_rule_alarm_delay_limit = m.get('AutoScalingRuleAlarmDelayLimit')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AutoScalingGroupMaxSizeLimit') is not None:
            self.auto_scaling_group_max_size_limit = m.get('AutoScalingGroupMaxSizeLimit')
        if m.get('AutoScalingMNSScalingThreadSleepTime') is not None:
            self.auto_scaling_mnsscaling_thread_sleep_time = m.get('AutoScalingMNSScalingThreadSleepTime')
        if m.get('AutoScalingConfigDecommissionQueryInterval') is not None:
            self.auto_scaling_config_decommission_query_interval = m.get('AutoScalingConfigDecommissionQueryInterval')
        if m.get('AutoScalingCoolDownTime') is not None:
            self.auto_scaling_cool_down_time = m.get('AutoScalingCoolDownTime')
        if m.get('AutoScalingRuleMinDelayLimit') is not None:
            self.auto_scaling_rule_min_delay_limit = m.get('AutoScalingRuleMinDelayLimit')
        if m.get('AutoScalingRuleAlarmSilentTime') is not None:
            self.auto_scaling_rule_alarm_silent_time = m.get('AutoScalingRuleAlarmSilentTime')
        if m.get('AutoScalingConfigSystemDiskSize') is not None:
            self.auto_scaling_config_system_disk_size = m.get('AutoScalingConfigSystemDiskSize')
        if m.get('AutoScalingGroupMinSizeLimit') is not None:
            self.auto_scaling_group_min_size_limit = m.get('AutoScalingGroupMinSizeLimit')
        return self


class DescribeScalingCommonConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingCommonConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingCommonConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingConfigItemV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        scaling_group_biz_id: str = None,
        config_item_type: str = None,
        scaling_config_item_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.config_item_type = config_item_type
        self.scaling_config_item_id = scaling_config_item_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.scaling_config_item_id is not None:
            result['ScalingConfigItemId'] = self.scaling_config_item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ScalingConfigItemId') is not None:
            self.scaling_config_item_id = m.get('ScalingConfigItemId')
        return self


class DescribeScalingConfigItemV2ResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_config_item_biz_id: str = None,
        scaling_group_biz_id: str = None,
        config_item_information: str = None,
        config_item_type: str = None,
    ):
        self.request_id = request_id
        self.scaling_config_item_biz_id = scaling_config_item_biz_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.config_item_information = config_item_information
        self.config_item_type = config_item_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_config_item_biz_id is not None:
            result['ScalingConfigItemBizId'] = self.scaling_config_item_biz_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingConfigItemBizId') is not None:
            self.scaling_config_item_biz_id = m.get('ScalingConfigItemBizId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        return self


class DescribeScalingConfigItemV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingConfigItemV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingConfigItemV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingGroupInstanceV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        scaling_group_biz_id: str = None,
        host_group_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.host_group_biz_id = host_group_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        return self


class DescribeScalingGroupInstanceV2ResponseBodyScalingConfigInstanceTypeList(TeaModel):
    def __init__(
        self,
        instance_type: List[str] = None,
    ):
        self.instance_type = instance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class DescribeScalingGroupInstanceV2ResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimit(TeaModel):
    def __init__(
        self,
        price_limit: float = None,
        instance_type: str = None,
    ):
        self.price_limit = price_limit
        self.instance_type = instance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_limit is not None:
            result['PriceLimit'] = self.price_limit
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PriceLimit') is not None:
            self.price_limit = m.get('PriceLimit')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class DescribeScalingGroupInstanceV2ResponseBodyScalingConfigSpotPriceLimits(TeaModel):
    def __init__(
        self,
        spot_price_limit: List[DescribeScalingGroupInstanceV2ResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimit] = None,
    ):
        self.spot_price_limit = spot_price_limit

    def validate(self):
        if self.spot_price_limit:
            for k in self.spot_price_limit:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SpotPriceLimit'] = []
        if self.spot_price_limit is not None:
            for k in self.spot_price_limit:
                result['SpotPriceLimit'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.spot_price_limit = []
        if m.get('SpotPriceLimit') is not None:
            for k in m.get('SpotPriceLimit'):
                temp_model = DescribeScalingGroupInstanceV2ResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimit()
                self.spot_price_limit.append(temp_model.from_map(k))
        return self


class DescribeScalingGroupInstanceV2ResponseBodyScalingConfig(TeaModel):
    def __init__(
        self,
        data_disk_category: str = None,
        data_disk_count: int = None,
        instance_type_list: DescribeScalingGroupInstanceV2ResponseBodyScalingConfigInstanceTypeList = None,
        pay_type: str = None,
        data_disk_size: int = None,
        sys_disk_category: str = None,
        spot_price_limits: DescribeScalingGroupInstanceV2ResponseBodyScalingConfigSpotPriceLimits = None,
        spot_strategy: str = None,
        sys_disk_size: int = None,
    ):
        self.data_disk_category = data_disk_category
        self.data_disk_count = data_disk_count
        self.instance_type_list = instance_type_list
        self.pay_type = pay_type
        self.data_disk_size = data_disk_size
        self.sys_disk_category = sys_disk_category
        self.spot_price_limits = spot_price_limits
        self.spot_strategy = spot_strategy
        self.sys_disk_size = sys_disk_size

    def validate(self):
        if self.instance_type_list:
            self.instance_type_list.validate()
        if self.spot_price_limits:
            self.spot_price_limits.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_count is not None:
            result['DataDiskCount'] = self.data_disk_count
        if self.instance_type_list is not None:
            result['InstanceTypeList'] = self.instance_type_list.to_map()
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.sys_disk_category is not None:
            result['SysDiskCategory'] = self.sys_disk_category
        if self.spot_price_limits is not None:
            result['SpotPriceLimits'] = self.spot_price_limits.to_map()
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.sys_disk_size is not None:
            result['SysDiskSize'] = self.sys_disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskCount') is not None:
            self.data_disk_count = m.get('DataDiskCount')
        if m.get('InstanceTypeList') is not None:
            temp_model = DescribeScalingGroupInstanceV2ResponseBodyScalingConfigInstanceTypeList()
            self.instance_type_list = temp_model.from_map(m['InstanceTypeList'])
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('SysDiskCategory') is not None:
            self.sys_disk_category = m.get('SysDiskCategory')
        if m.get('SpotPriceLimits') is not None:
            temp_model = DescribeScalingGroupInstanceV2ResponseBodyScalingConfigSpotPriceLimits()
            self.spot_price_limits = temp_model.from_map(m['SpotPriceLimits'])
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('SysDiskSize') is not None:
            self.sys_disk_size = m.get('SysDiskSize')
        return self


class DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRuleCloudWatchTrigger(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        evaluation_count: str = None,
        unit: str = None,
        metric_display_name: str = None,
        threshold: str = None,
        period: int = None,
        statistics: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.metric_name = metric_name
        self.evaluation_count = evaluation_count
        self.unit = unit
        self.metric_display_name = metric_display_name
        self.threshold = threshold
        self.period = period
        self.statistics = statistics

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.metric_display_name is not None:
            result['MetricDisplayName'] = self.metric_display_name
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('MetricDisplayName') is not None:
            self.metric_display_name = m.get('MetricDisplayName')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        return self


class DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRuleSchedulerTrigger(TeaModel):
    def __init__(
        self,
        launch_expiration_time: int = None,
        recurrence_value: str = None,
        recurrence_type: str = None,
        recurrence_end_time: int = None,
        launch_time: int = None,
    ):
        self.launch_expiration_time = launch_expiration_time
        self.recurrence_value = recurrence_value
        self.recurrence_type = recurrence_type
        self.recurrence_end_time = recurrence_end_time
        self.launch_time = launch_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        return self


class DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRule(TeaModel):
    def __init__(
        self,
        cloud_watch_trigger: DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRuleCloudWatchTrigger = None,
        status: str = None,
        adjustment_type: str = None,
        recurrence_value: str = None,
        recurrence_type: str = None,
        timeout_with_grace: int = None,
        recurrence_end_time: str = None,
        rule_name: str = None,
        scaling_group_id: int = None,
        rule_category: str = None,
        launch_expiration_time: int = None,
        cooldown: int = None,
        adjustment_value: int = None,
        scheduler_trigger: DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRuleSchedulerTrigger = None,
        launch_time: str = None,
        with_grace: bool = None,
        ess_scaling_rule_id: str = None,
    ):
        self.cloud_watch_trigger = cloud_watch_trigger
        self.status = status
        self.adjustment_type = adjustment_type
        self.recurrence_value = recurrence_value
        self.recurrence_type = recurrence_type
        self.timeout_with_grace = timeout_with_grace
        self.recurrence_end_time = recurrence_end_time
        self.rule_name = rule_name
        self.scaling_group_id = scaling_group_id
        self.rule_category = rule_category
        self.launch_expiration_time = launch_expiration_time
        self.cooldown = cooldown
        self.adjustment_value = adjustment_value
        self.scheduler_trigger = scheduler_trigger
        self.launch_time = launch_time
        self.with_grace = with_grace
        self.ess_scaling_rule_id = ess_scaling_rule_id

    def validate(self):
        if self.cloud_watch_trigger:
            self.cloud_watch_trigger.validate()
        if self.scheduler_trigger:
            self.scheduler_trigger.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cloud_watch_trigger is not None:
            result['CloudWatchTrigger'] = self.cloud_watch_trigger.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.adjustment_type is not None:
            result['AdjustmentType'] = self.adjustment_type
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.timeout_with_grace is not None:
            result['TimeoutWithGrace'] = self.timeout_with_grace
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.rule_category is not None:
            result['RuleCategory'] = self.rule_category
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.cooldown is not None:
            result['Cooldown'] = self.cooldown
        if self.adjustment_value is not None:
            result['AdjustmentValue'] = self.adjustment_value
        if self.scheduler_trigger is not None:
            result['SchedulerTrigger'] = self.scheduler_trigger.to_map()
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        if self.with_grace is not None:
            result['WithGrace'] = self.with_grace
        if self.ess_scaling_rule_id is not None:
            result['EssScalingRuleId'] = self.ess_scaling_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CloudWatchTrigger') is not None:
            temp_model = DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRuleCloudWatchTrigger()
            self.cloud_watch_trigger = temp_model.from_map(m['CloudWatchTrigger'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('AdjustmentType') is not None:
            self.adjustment_type = m.get('AdjustmentType')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('TimeoutWithGrace') is not None:
            self.timeout_with_grace = m.get('TimeoutWithGrace')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('RuleCategory') is not None:
            self.rule_category = m.get('RuleCategory')
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('Cooldown') is not None:
            self.cooldown = m.get('Cooldown')
        if m.get('AdjustmentValue') is not None:
            self.adjustment_value = m.get('AdjustmentValue')
        if m.get('SchedulerTrigger') is not None:
            temp_model = DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRuleSchedulerTrigger()
            self.scheduler_trigger = temp_model.from_map(m['SchedulerTrigger'])
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        if m.get('WithGrace') is not None:
            self.with_grace = m.get('WithGrace')
        if m.get('EssScalingRuleId') is not None:
            self.ess_scaling_rule_id = m.get('EssScalingRuleId')
        return self


class DescribeScalingGroupInstanceV2ResponseBodyScalingRuleList(TeaModel):
    def __init__(
        self,
        scaling_rule: List[DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRule] = None,
    ):
        self.scaling_rule = scaling_rule

    def validate(self):
        if self.scaling_rule:
            for k in self.scaling_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ScalingRule'] = []
        if self.scaling_rule is not None:
            for k in self.scaling_rule:
                result['ScalingRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.scaling_rule = []
        if m.get('ScalingRule') is not None:
            for k in m.get('ScalingRule'):
                temp_model = DescribeScalingGroupInstanceV2ResponseBodyScalingRuleListScalingRule()
                self.scaling_rule.append(temp_model.from_map(k))
        return self


class DescribeScalingGroupInstanceV2ResponseBody(TeaModel):
    def __init__(
        self,
        scaling_config: DescribeScalingGroupInstanceV2ResponseBodyScalingConfig = None,
        active_rule_category: str = None,
        request_id: str = None,
        timeout_with_grace: int = None,
        scaling_group_id: str = None,
        max_size: int = None,
        multi_available_policy_param: str = None,
        min_size: int = None,
        default_cooldown: int = None,
        host_group_id: str = None,
        with_grace: bool = None,
        multi_available_policy: str = None,
        scaling_rule_list: DescribeScalingGroupInstanceV2ResponseBodyScalingRuleList = None,
    ):
        self.scaling_config = scaling_config
        self.active_rule_category = active_rule_category
        self.request_id = request_id
        self.timeout_with_grace = timeout_with_grace
        self.scaling_group_id = scaling_group_id
        self.max_size = max_size
        self.multi_available_policy_param = multi_available_policy_param
        self.min_size = min_size
        self.default_cooldown = default_cooldown
        self.host_group_id = host_group_id
        self.with_grace = with_grace
        self.multi_available_policy = multi_available_policy
        self.scaling_rule_list = scaling_rule_list

    def validate(self):
        if self.scaling_config:
            self.scaling_config.validate()
        if self.scaling_rule_list:
            self.scaling_rule_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scaling_config is not None:
            result['ScalingConfig'] = self.scaling_config.to_map()
        if self.active_rule_category is not None:
            result['ActiveRuleCategory'] = self.active_rule_category
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.timeout_with_grace is not None:
            result['TimeoutWithGrace'] = self.timeout_with_grace
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.max_size is not None:
            result['MaxSize'] = self.max_size
        if self.multi_available_policy_param is not None:
            result['MultiAvailablePolicyParam'] = self.multi_available_policy_param
        if self.min_size is not None:
            result['MinSize'] = self.min_size
        if self.default_cooldown is not None:
            result['DefaultCooldown'] = self.default_cooldown
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.with_grace is not None:
            result['WithGrace'] = self.with_grace
        if self.multi_available_policy is not None:
            result['MultiAvailablePolicy'] = self.multi_available_policy
        if self.scaling_rule_list is not None:
            result['ScalingRuleList'] = self.scaling_rule_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScalingConfig') is not None:
            temp_model = DescribeScalingGroupInstanceV2ResponseBodyScalingConfig()
            self.scaling_config = temp_model.from_map(m['ScalingConfig'])
        if m.get('ActiveRuleCategory') is not None:
            self.active_rule_category = m.get('ActiveRuleCategory')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeoutWithGrace') is not None:
            self.timeout_with_grace = m.get('TimeoutWithGrace')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('MaxSize') is not None:
            self.max_size = m.get('MaxSize')
        if m.get('MultiAvailablePolicyParam') is not None:
            self.multi_available_policy_param = m.get('MultiAvailablePolicyParam')
        if m.get('MinSize') is not None:
            self.min_size = m.get('MinSize')
        if m.get('DefaultCooldown') is not None:
            self.default_cooldown = m.get('DefaultCooldown')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('WithGrace') is not None:
            self.with_grace = m.get('WithGrace')
        if m.get('MultiAvailablePolicy') is not None:
            self.multi_available_policy = m.get('MultiAvailablePolicy')
        if m.get('ScalingRuleList') is not None:
            temp_model = DescribeScalingGroupInstanceV2ResponseBodyScalingRuleList()
            self.scaling_rule_list = temp_model.from_map(m['ScalingRuleList'])
        return self


class DescribeScalingGroupInstanceV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingGroupInstanceV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingGroupInstanceV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingGroupV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        scaling_group_biz_id: str = None,
        host_group_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.host_group_biz_id = host_group_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        return self


class DescribeScalingGroupV2ResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        host_group_biz_id: str = None,
        request_id: str = None,
        config_state: str = None,
        scaling_in_mode: str = None,
        scaling_group_id: str = None,
        scaling_max_size: int = None,
        scaling_min_size: int = None,
        name: str = None,
        active_status: str = None,
    ):
        self.description = description
        self.host_group_biz_id = host_group_biz_id
        self.request_id = request_id
        self.config_state = config_state
        self.scaling_in_mode = scaling_in_mode
        self.scaling_group_id = scaling_group_id
        self.scaling_max_size = scaling_max_size
        self.scaling_min_size = scaling_min_size
        self.name = name
        self.active_status = active_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.config_state is not None:
            result['ConfigState'] = self.config_state
        if self.scaling_in_mode is not None:
            result['ScalingInMode'] = self.scaling_in_mode
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.scaling_max_size is not None:
            result['ScalingMaxSize'] = self.scaling_max_size
        if self.scaling_min_size is not None:
            result['ScalingMinSize'] = self.scaling_min_size
        if self.name is not None:
            result['Name'] = self.name
        if self.active_status is not None:
            result['ActiveStatus'] = self.active_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConfigState') is not None:
            self.config_state = m.get('ConfigState')
        if m.get('ScalingInMode') is not None:
            self.scaling_in_mode = m.get('ScalingInMode')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('ScalingMaxSize') is not None:
            self.scaling_max_size = m.get('ScalingMaxSize')
        if m.get('ScalingMinSize') is not None:
            self.scaling_min_size = m.get('ScalingMinSize')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ActiveStatus') is not None:
            self.active_status = m.get('ActiveStatus')
        return self


class DescribeScalingGroupV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingGroupV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingGroupV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingRuleRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_group_id: str = None,
        scaling_rule_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_group_id = host_group_id
        self.scaling_rule_id = scaling_rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.scaling_rule_id is not None:
            result['ScalingRuleId'] = self.scaling_rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('ScalingRuleId') is not None:
            self.scaling_rule_id = m.get('ScalingRuleId')
        return self


class DescribeScalingRuleResponseBodyCloudWatchTrigger(TeaModel):
    def __init__(
        self,
        comparison_operator: str = None,
        metric_name: str = None,
        evaluation_count: str = None,
        unit: str = None,
        metric_display_name: str = None,
        threshold: str = None,
        period: int = None,
        statistics: str = None,
    ):
        self.comparison_operator = comparison_operator
        self.metric_name = metric_name
        self.evaluation_count = evaluation_count
        self.unit = unit
        self.metric_display_name = metric_display_name
        self.threshold = threshold
        self.period = period
        self.statistics = statistics

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.metric_display_name is not None:
            result['MetricDisplayName'] = self.metric_display_name
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('MetricDisplayName') is not None:
            self.metric_display_name = m.get('MetricDisplayName')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        return self


class DescribeScalingRuleResponseBodySchedulerTrigger(TeaModel):
    def __init__(
        self,
        launch_expiration_time: int = None,
        recurrence_value: str = None,
        recurrence_type: str = None,
        recurrence_end_time: int = None,
        launch_time: int = None,
    ):
        self.launch_expiration_time = launch_expiration_time
        self.recurrence_value = recurrence_value
        self.recurrence_type = recurrence_type
        self.recurrence_end_time = recurrence_end_time
        self.launch_time = launch_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        return self


class DescribeScalingRuleResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        timeout_with_grace: int = None,
        request_id: str = None,
        cooldown: int = None,
        cloud_watch_trigger: DescribeScalingRuleResponseBodyCloudWatchTrigger = None,
        gmt_modified: str = None,
        adjustment_type: str = None,
        gmt_create: str = None,
        adjustment_value: int = None,
        scheduler_trigger: DescribeScalingRuleResponseBodySchedulerTrigger = None,
        with_grace: bool = None,
        id: str = None,
        rule_name: str = None,
        rule_category: str = None,
    ):
        self.status = status
        self.timeout_with_grace = timeout_with_grace
        self.request_id = request_id
        self.cooldown = cooldown
        self.cloud_watch_trigger = cloud_watch_trigger
        self.gmt_modified = gmt_modified
        self.adjustment_type = adjustment_type
        self.gmt_create = gmt_create
        self.adjustment_value = adjustment_value
        self.scheduler_trigger = scheduler_trigger
        self.with_grace = with_grace
        self.id = id
        self.rule_name = rule_name
        self.rule_category = rule_category

    def validate(self):
        if self.cloud_watch_trigger:
            self.cloud_watch_trigger.validate()
        if self.scheduler_trigger:
            self.scheduler_trigger.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.timeout_with_grace is not None:
            result['TimeoutWithGrace'] = self.timeout_with_grace
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cooldown is not None:
            result['Cooldown'] = self.cooldown
        if self.cloud_watch_trigger is not None:
            result['CloudWatchTrigger'] = self.cloud_watch_trigger.to_map()
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.adjustment_type is not None:
            result['AdjustmentType'] = self.adjustment_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.adjustment_value is not None:
            result['AdjustmentValue'] = self.adjustment_value
        if self.scheduler_trigger is not None:
            result['SchedulerTrigger'] = self.scheduler_trigger.to_map()
        if self.with_grace is not None:
            result['WithGrace'] = self.with_grace
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_category is not None:
            result['RuleCategory'] = self.rule_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TimeoutWithGrace') is not None:
            self.timeout_with_grace = m.get('TimeoutWithGrace')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Cooldown') is not None:
            self.cooldown = m.get('Cooldown')
        if m.get('CloudWatchTrigger') is not None:
            temp_model = DescribeScalingRuleResponseBodyCloudWatchTrigger()
            self.cloud_watch_trigger = temp_model.from_map(m['CloudWatchTrigger'])
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('AdjustmentType') is not None:
            self.adjustment_type = m.get('AdjustmentType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('AdjustmentValue') is not None:
            self.adjustment_value = m.get('AdjustmentValue')
        if m.get('SchedulerTrigger') is not None:
            temp_model = DescribeScalingRuleResponseBodySchedulerTrigger()
            self.scheduler_trigger = temp_model.from_map(m['SchedulerTrigger'])
        if m.get('WithGrace') is not None:
            self.with_grace = m.get('WithGrace')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleCategory') is not None:
            self.rule_category = m.get('RuleCategory')
        return self


class DescribeScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityGroupAttributeRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeSecurityGroupAttributeResponseBodyAvailableGroupListSecurityGroup(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        creation_time: str = None,
        description: str = None,
        security_group_id: str = None,
        security_group_name: str = None,
        ecs_count: int = None,
        available_instance_amount: int = None,
    ):
        self.vpc_id = vpc_id
        self.creation_time = creation_time
        self.description = description
        self.security_group_id = security_group_id
        self.security_group_name = security_group_name
        self.ecs_count = ecs_count
        self.available_instance_amount = available_instance_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.ecs_count is not None:
            result['EcsCount'] = self.ecs_count
        if self.available_instance_amount is not None:
            result['AvailableInstanceAmount'] = self.available_instance_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('EcsCount') is not None:
            self.ecs_count = m.get('EcsCount')
        if m.get('AvailableInstanceAmount') is not None:
            self.available_instance_amount = m.get('AvailableInstanceAmount')
        return self


class DescribeSecurityGroupAttributeResponseBodyAvailableGroupList(TeaModel):
    def __init__(
        self,
        security_group: List[DescribeSecurityGroupAttributeResponseBodyAvailableGroupListSecurityGroup] = None,
    ):
        self.security_group = security_group

    def validate(self):
        if self.security_group:
            for k in self.security_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SecurityGroup'] = []
        if self.security_group is not None:
            for k in self.security_group:
                result['SecurityGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.security_group = []
        if m.get('SecurityGroup') is not None:
            for k in m.get('SecurityGroup'):
                temp_model = DescribeSecurityGroupAttributeResponseBodyAvailableGroupListSecurityGroup()
                self.security_group.append(temp_model.from_map(k))
        return self


class DescribeSecurityGroupAttributeResponseBodySecurityGroupAttributeListSecurityGroupAttribute(TeaModel):
    def __init__(
        self,
        biz_content: str = None,
        biz_type: str = None,
    ):
        self.biz_content = biz_content
        self.biz_type = biz_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_content is not None:
            result['BizContent'] = self.biz_content
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizContent') is not None:
            self.biz_content = m.get('BizContent')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        return self


class DescribeSecurityGroupAttributeResponseBodySecurityGroupAttributeList(TeaModel):
    def __init__(
        self,
        security_group_attribute: List[DescribeSecurityGroupAttributeResponseBodySecurityGroupAttributeListSecurityGroupAttribute] = None,
    ):
        self.security_group_attribute = security_group_attribute

    def validate(self):
        if self.security_group_attribute:
            for k in self.security_group_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SecurityGroupAttribute'] = []
        if self.security_group_attribute is not None:
            for k in self.security_group_attribute:
                result['SecurityGroupAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.security_group_attribute = []
        if m.get('SecurityGroupAttribute') is not None:
            for k in m.get('SecurityGroupAttribute'):
                temp_model = DescribeSecurityGroupAttributeResponseBodySecurityGroupAttributeListSecurityGroupAttribute()
                self.security_group_attribute.append(temp_model.from_map(k))
        return self


class DescribeSecurityGroupAttributeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        available_group_list: DescribeSecurityGroupAttributeResponseBodyAvailableGroupList = None,
        security_group_attribute_list: DescribeSecurityGroupAttributeResponseBodySecurityGroupAttributeList = None,
    ):
        self.request_id = request_id
        self.available_group_list = available_group_list
        self.security_group_attribute_list = security_group_attribute_list

    def validate(self):
        if self.available_group_list:
            self.available_group_list.validate()
        if self.security_group_attribute_list:
            self.security_group_attribute_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.available_group_list is not None:
            result['AvailableGroupList'] = self.available_group_list.to_map()
        if self.security_group_attribute_list is not None:
            result['SecurityGroupAttributeList'] = self.security_group_attribute_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('AvailableGroupList') is not None:
            temp_model = DescribeSecurityGroupAttributeResponseBodyAvailableGroupList()
            self.available_group_list = temp_model.from_map(m['AvailableGroupList'])
        if m.get('SecurityGroupAttributeList') is not None:
            temp_model = DescribeSecurityGroupAttributeResponseBodySecurityGroupAttributeList()
            self.security_group_attribute_list = temp_model.from_map(m['SecurityGroupAttributeList'])
        return self


class DescribeSecurityGroupAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityGroupAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityGroupAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachAndReleaseClusterEniRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        target_cluster_id: str = None,
        vswitch_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.target_cluster_id = target_cluster_id
        self.vswitch_id = vswitch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_cluster_id is not None:
            result['TargetClusterId'] = self.target_cluster_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetClusterId') is not None:
            self.target_cluster_id = m.get('TargetClusterId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class DetachAndReleaseClusterEniResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachAndReleaseClusterEniResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DetachAndReleaseClusterEniResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DetachAndReleaseClusterEniResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHdfsCapacityStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        return self


class GetHdfsCapacityStatisticInfoResponseBodyHdfsCapacityListClusterStatHdfsCapacity(TeaModel):
    def __init__(
        self,
        capacity_used_non_dfs: int = None,
        capacity_total: int = None,
        capacity_total_gb: int = None,
        capacity_remaining: int = None,
        capacity_used: int = None,
        cluster_biz_id: str = None,
        capacity_used_gb: int = None,
        date_time: str = None,
        capacity_remaining_gb: int = None,
    ):
        self.capacity_used_non_dfs = capacity_used_non_dfs
        self.capacity_total = capacity_total
        self.capacity_total_gb = capacity_total_gb
        self.capacity_remaining = capacity_remaining
        self.capacity_used = capacity_used
        self.cluster_biz_id = cluster_biz_id
        self.capacity_used_gb = capacity_used_gb
        self.date_time = date_time
        self.capacity_remaining_gb = capacity_remaining_gb

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_used_non_dfs is not None:
            result['CapacityUsedNonDfs'] = self.capacity_used_non_dfs
        if self.capacity_total is not None:
            result['CapacityTotal'] = self.capacity_total
        if self.capacity_total_gb is not None:
            result['CapacityTotalGB'] = self.capacity_total_gb
        if self.capacity_remaining is not None:
            result['CapacityRemaining'] = self.capacity_remaining
        if self.capacity_used is not None:
            result['CapacityUsed'] = self.capacity_used
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.capacity_used_gb is not None:
            result['CapacityUsedGB'] = self.capacity_used_gb
        if self.date_time is not None:
            result['DateTime'] = self.date_time
        if self.capacity_remaining_gb is not None:
            result['CapacityRemainingGB'] = self.capacity_remaining_gb
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CapacityUsedNonDfs') is not None:
            self.capacity_used_non_dfs = m.get('CapacityUsedNonDfs')
        if m.get('CapacityTotal') is not None:
            self.capacity_total = m.get('CapacityTotal')
        if m.get('CapacityTotalGB') is not None:
            self.capacity_total_gb = m.get('CapacityTotalGB')
        if m.get('CapacityRemaining') is not None:
            self.capacity_remaining = m.get('CapacityRemaining')
        if m.get('CapacityUsed') is not None:
            self.capacity_used = m.get('CapacityUsed')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('CapacityUsedGB') is not None:
            self.capacity_used_gb = m.get('CapacityUsedGB')
        if m.get('DateTime') is not None:
            self.date_time = m.get('DateTime')
        if m.get('CapacityRemainingGB') is not None:
            self.capacity_remaining_gb = m.get('CapacityRemainingGB')
        return self


class GetHdfsCapacityStatisticInfoResponseBodyHdfsCapacityList(TeaModel):
    def __init__(
        self,
        cluster_stat_hdfs_capacity: List[GetHdfsCapacityStatisticInfoResponseBodyHdfsCapacityListClusterStatHdfsCapacity] = None,
    ):
        self.cluster_stat_hdfs_capacity = cluster_stat_hdfs_capacity

    def validate(self):
        if self.cluster_stat_hdfs_capacity:
            for k in self.cluster_stat_hdfs_capacity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatHdfsCapacity'] = []
        if self.cluster_stat_hdfs_capacity is not None:
            for k in self.cluster_stat_hdfs_capacity:
                result['ClusterStatHdfsCapacity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_hdfs_capacity = []
        if m.get('ClusterStatHdfsCapacity') is not None:
            for k in m.get('ClusterStatHdfsCapacity'):
                temp_model = GetHdfsCapacityStatisticInfoResponseBodyHdfsCapacityListClusterStatHdfsCapacity()
                self.cluster_stat_hdfs_capacity.append(temp_model.from_map(k))
        return self


class GetHdfsCapacityStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        hdfs_capacity_list: GetHdfsCapacityStatisticInfoResponseBodyHdfsCapacityList = None,
    ):
        self.request_id = request_id
        self.hdfs_capacity_list = hdfs_capacity_list

    def validate(self):
        if self.hdfs_capacity_list:
            self.hdfs_capacity_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.hdfs_capacity_list is not None:
            result['HdfsCapacityList'] = self.hdfs_capacity_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HdfsCapacityList') is not None:
            temp_model = GetHdfsCapacityStatisticInfoResponseBodyHdfsCapacityList()
            self.hdfs_capacity_list = temp_model.from_map(m['HdfsCapacityList'])
        return self


class GetHdfsCapacityStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetHdfsCapacityStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetHdfsCapacityStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobInputStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class GetJobInputStatisticInfoResponseBodyJobInputListClusterStatJobInput(TeaModel):
    def __init__(
        self,
        start_time: int = None,
        finish_time: int = None,
        state: str = None,
        bytes_input: int = None,
        job_id: str = None,
        user: str = None,
        queue: str = None,
        name: str = None,
        application_id: str = None,
    ):
        self.start_time = start_time
        self.finish_time = finish_time
        self.state = state
        self.bytes_input = bytes_input
        self.job_id = job_id
        self.user = user
        self.queue = queue
        self.name = name
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.bytes_input is not None:
            result['BytesInput'] = self.bytes_input
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user is not None:
            result['User'] = self.user
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.name is not None:
            result['Name'] = self.name
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('BytesInput') is not None:
            self.bytes_input = m.get('BytesInput')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetJobInputStatisticInfoResponseBodyJobInputList(TeaModel):
    def __init__(
        self,
        cluster_stat_job_input: List[GetJobInputStatisticInfoResponseBodyJobInputListClusterStatJobInput] = None,
    ):
        self.cluster_stat_job_input = cluster_stat_job_input

    def validate(self):
        if self.cluster_stat_job_input:
            for k in self.cluster_stat_job_input:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatJobInput'] = []
        if self.cluster_stat_job_input is not None:
            for k in self.cluster_stat_job_input:
                result['ClusterStatJobInput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_job_input = []
        if m.get('ClusterStatJobInput') is not None:
            for k in m.get('ClusterStatJobInput'):
                temp_model = GetJobInputStatisticInfoResponseBodyJobInputListClusterStatJobInput()
                self.cluster_stat_job_input.append(temp_model.from_map(k))
        return self


class GetJobInputStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        job_input_list: GetJobInputStatisticInfoResponseBodyJobInputList = None,
        total: int = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.job_input_list = job_input_list
        self.total = total

    def validate(self):
        if self.job_input_list:
            self.job_input_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.job_input_list is not None:
            result['JobInputList'] = self.job_input_list.to_map()
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('JobInputList') is not None:
            temp_model = GetJobInputStatisticInfoResponseBodyJobInputList()
            self.job_input_list = temp_model.from_map(m['JobInputList'])
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetJobInputStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetJobInputStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobInputStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobOutputStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class GetJobOutputStatisticInfoResponseBodyJobOutputListClusterStatJobOutput(TeaModel):
    def __init__(
        self,
        start_time: int = None,
        finish_time: int = None,
        state: str = None,
        job_id: str = None,
        user: str = None,
        queue: str = None,
        bytes_output: int = None,
        name: str = None,
        application_id: str = None,
    ):
        self.start_time = start_time
        self.finish_time = finish_time
        self.state = state
        self.job_id = job_id
        self.user = user
        self.queue = queue
        self.bytes_output = bytes_output
        self.name = name
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user is not None:
            result['User'] = self.user
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.bytes_output is not None:
            result['BytesOutput'] = self.bytes_output
        if self.name is not None:
            result['Name'] = self.name
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('BytesOutput') is not None:
            self.bytes_output = m.get('BytesOutput')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetJobOutputStatisticInfoResponseBodyJobOutputList(TeaModel):
    def __init__(
        self,
        cluster_stat_job_output: List[GetJobOutputStatisticInfoResponseBodyJobOutputListClusterStatJobOutput] = None,
    ):
        self.cluster_stat_job_output = cluster_stat_job_output

    def validate(self):
        if self.cluster_stat_job_output:
            for k in self.cluster_stat_job_output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatJobOutput'] = []
        if self.cluster_stat_job_output is not None:
            for k in self.cluster_stat_job_output:
                result['ClusterStatJobOutput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_job_output = []
        if m.get('ClusterStatJobOutput') is not None:
            for k in m.get('ClusterStatJobOutput'):
                temp_model = GetJobOutputStatisticInfoResponseBodyJobOutputListClusterStatJobOutput()
                self.cluster_stat_job_output.append(temp_model.from_map(k))
        return self


class GetJobOutputStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total: int = None,
        job_output_list: GetJobOutputStatisticInfoResponseBodyJobOutputList = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total = total
        self.job_output_list = job_output_list

    def validate(self):
        if self.job_output_list:
            self.job_output_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total is not None:
            result['Total'] = self.total
        if self.job_output_list is not None:
            result['JobOutputList'] = self.job_output_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('JobOutputList') is not None:
            temp_model = GetJobOutputStatisticInfoResponseBodyJobOutputList()
            self.job_output_list = temp_model.from_map(m['JobOutputList'])
        return self


class GetJobOutputStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetJobOutputStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobOutputStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetJobRunningTimeStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
        page_size: int = None,
        page_number: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime
        self.page_size = page_size
        self.page_number = page_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class GetJobRunningTimeStatisticInfoResponseBodyRunningTimeListClusterStatJobRunningTime(TeaModel):
    def __init__(
        self,
        start_time: int = None,
        running_time: int = None,
        finish_time: int = None,
        state: str = None,
        job_id: str = None,
        user: str = None,
        queue: str = None,
        name: str = None,
        application_id: str = None,
    ):
        self.start_time = start_time
        self.running_time = running_time
        self.finish_time = finish_time
        self.state = state
        self.job_id = job_id
        self.user = user
        self.queue = queue
        self.name = name
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.state is not None:
            result['State'] = self.state
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.user is not None:
            result['User'] = self.user
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.name is not None:
            result['Name'] = self.name
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class GetJobRunningTimeStatisticInfoResponseBodyRunningTimeList(TeaModel):
    def __init__(
        self,
        cluster_stat_job_running_time: List[GetJobRunningTimeStatisticInfoResponseBodyRunningTimeListClusterStatJobRunningTime] = None,
    ):
        self.cluster_stat_job_running_time = cluster_stat_job_running_time

    def validate(self):
        if self.cluster_stat_job_running_time:
            for k in self.cluster_stat_job_running_time:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatJobRunningTime'] = []
        if self.cluster_stat_job_running_time is not None:
            for k in self.cluster_stat_job_running_time:
                result['ClusterStatJobRunningTime'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_job_running_time = []
        if m.get('ClusterStatJobRunningTime') is not None:
            for k in m.get('ClusterStatJobRunningTime'):
                temp_model = GetJobRunningTimeStatisticInfoResponseBodyRunningTimeListClusterStatJobRunningTime()
                self.cluster_stat_job_running_time.append(temp_model.from_map(k))
        return self


class GetJobRunningTimeStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total: int = None,
        running_time_list: GetJobRunningTimeStatisticInfoResponseBodyRunningTimeList = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total = total
        self.running_time_list = running_time_list

    def validate(self):
        if self.running_time_list:
            self.running_time_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total is not None:
            result['Total'] = self.total
        if self.running_time_list is not None:
            result['RunningTimeList'] = self.running_time_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('RunningTimeList') is not None:
            temp_model = GetJobRunningTimeStatisticInfoResponseBodyRunningTimeList()
            self.running_time_list = temp_model.from_map(m['RunningTimeList'])
        return self


class GetJobRunningTimeStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetJobRunningTimeStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetJobRunningTimeStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueueInputStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        return self


class GetQueueInputStatisticInfoResponseBodyQueueInputListClusterStatQueueInput(TeaModel):
    def __init__(
        self,
        bytes_input: int = None,
        queue: str = None,
    ):
        self.bytes_input = bytes_input
        self.queue = queue

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes_input is not None:
            result['BytesInput'] = self.bytes_input
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BytesInput') is not None:
            self.bytes_input = m.get('BytesInput')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class GetQueueInputStatisticInfoResponseBodyQueueInputList(TeaModel):
    def __init__(
        self,
        cluster_stat_queue_input: List[GetQueueInputStatisticInfoResponseBodyQueueInputListClusterStatQueueInput] = None,
    ):
        self.cluster_stat_queue_input = cluster_stat_queue_input

    def validate(self):
        if self.cluster_stat_queue_input:
            for k in self.cluster_stat_queue_input:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatQueueInput'] = []
        if self.cluster_stat_queue_input is not None:
            for k in self.cluster_stat_queue_input:
                result['ClusterStatQueueInput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_queue_input = []
        if m.get('ClusterStatQueueInput') is not None:
            for k in m.get('ClusterStatQueueInput'):
                temp_model = GetQueueInputStatisticInfoResponseBodyQueueInputListClusterStatQueueInput()
                self.cluster_stat_queue_input.append(temp_model.from_map(k))
        return self


class GetQueueInputStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        queue_input_list: GetQueueInputStatisticInfoResponseBodyQueueInputList = None,
    ):
        self.request_id = request_id
        self.queue_input_list = queue_input_list

    def validate(self):
        if self.queue_input_list:
            self.queue_input_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.queue_input_list is not None:
            result['QueueInputList'] = self.queue_input_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('QueueInputList') is not None:
            temp_model = GetQueueInputStatisticInfoResponseBodyQueueInputList()
            self.queue_input_list = temp_model.from_map(m['QueueInputList'])
        return self


class GetQueueInputStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQueueInputStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQueueInputStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueueOutputStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        return self


class GetQueueOutputStatisticInfoResponseBodyQueueOutputListClusterStatQueueOutput(TeaModel):
    def __init__(
        self,
        queue: str = None,
        bytes_output: int = None,
    ):
        self.queue = queue
        self.bytes_output = bytes_output

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.bytes_output is not None:
            result['BytesOutput'] = self.bytes_output
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('BytesOutput') is not None:
            self.bytes_output = m.get('BytesOutput')
        return self


class GetQueueOutputStatisticInfoResponseBodyQueueOutputList(TeaModel):
    def __init__(
        self,
        cluster_stat_queue_output: List[GetQueueOutputStatisticInfoResponseBodyQueueOutputListClusterStatQueueOutput] = None,
    ):
        self.cluster_stat_queue_output = cluster_stat_queue_output

    def validate(self):
        if self.cluster_stat_queue_output:
            for k in self.cluster_stat_queue_output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatQueueOutput'] = []
        if self.cluster_stat_queue_output is not None:
            for k in self.cluster_stat_queue_output:
                result['ClusterStatQueueOutput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_queue_output = []
        if m.get('ClusterStatQueueOutput') is not None:
            for k in m.get('ClusterStatQueueOutput'):
                temp_model = GetQueueOutputStatisticInfoResponseBodyQueueOutputListClusterStatQueueOutput()
                self.cluster_stat_queue_output.append(temp_model.from_map(k))
        return self


class GetQueueOutputStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        queue_output_list: GetQueueOutputStatisticInfoResponseBodyQueueOutputList = None,
    ):
        self.request_id = request_id
        self.queue_output_list = queue_output_list

    def validate(self):
        if self.queue_output_list:
            self.queue_output_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.queue_output_list is not None:
            result['QueueOutputList'] = self.queue_output_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('QueueOutputList') is not None:
            temp_model = GetQueueOutputStatisticInfoResponseBodyQueueOutputList()
            self.queue_output_list = temp_model.from_map(m['QueueOutputList'])
        return self


class GetQueueOutputStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQueueOutputStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQueueOutputStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueueSubmissionStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
        application_type: str = None,
        final_status: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime
        self.application_type = application_type
        self.final_status = final_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.final_status is not None:
            result['FinalStatus'] = self.final_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('FinalStatus') is not None:
            self.final_status = m.get('FinalStatus')
        return self


class GetQueueSubmissionStatisticInfoResponseBodyQueueSubmissionListClusterStatQueueSubmission(TeaModel):
    def __init__(
        self,
        submission: int = None,
        queue: str = None,
    ):
        self.submission = submission
        self.queue = queue

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.submission is not None:
            result['Submission'] = self.submission
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Submission') is not None:
            self.submission = m.get('Submission')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class GetQueueSubmissionStatisticInfoResponseBodyQueueSubmissionList(TeaModel):
    def __init__(
        self,
        cluster_stat_queue_submission: List[GetQueueSubmissionStatisticInfoResponseBodyQueueSubmissionListClusterStatQueueSubmission] = None,
    ):
        self.cluster_stat_queue_submission = cluster_stat_queue_submission

    def validate(self):
        if self.cluster_stat_queue_submission:
            for k in self.cluster_stat_queue_submission:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatQueueSubmission'] = []
        if self.cluster_stat_queue_submission is not None:
            for k in self.cluster_stat_queue_submission:
                result['ClusterStatQueueSubmission'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_queue_submission = []
        if m.get('ClusterStatQueueSubmission') is not None:
            for k in m.get('ClusterStatQueueSubmission'):
                temp_model = GetQueueSubmissionStatisticInfoResponseBodyQueueSubmissionListClusterStatQueueSubmission()
                self.cluster_stat_queue_submission.append(temp_model.from_map(k))
        return self


class GetQueueSubmissionStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        queue_submission_list: GetQueueSubmissionStatisticInfoResponseBodyQueueSubmissionList = None,
    ):
        self.request_id = request_id
        self.queue_submission_list = queue_submission_list

    def validate(self):
        if self.queue_submission_list:
            self.queue_submission_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.queue_submission_list is not None:
            result['QueueSubmissionList'] = self.queue_submission_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('QueueSubmissionList') is not None:
            temp_model = GetQueueSubmissionStatisticInfoResponseBodyQueueSubmissionList()
            self.queue_submission_list = temp_model.from_map(m['QueueSubmissionList'])
        return self


class GetQueueSubmissionStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQueueSubmissionStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQueueSubmissionStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserInputStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        return self


class GetUserInputStatisticInfoResponseBodyUserInputListClusterStatUserInput(TeaModel):
    def __init__(
        self,
        bytes_input: int = None,
        user: str = None,
    ):
        self.bytes_input = bytes_input
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bytes_input is not None:
            result['BytesInput'] = self.bytes_input
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BytesInput') is not None:
            self.bytes_input = m.get('BytesInput')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class GetUserInputStatisticInfoResponseBodyUserInputList(TeaModel):
    def __init__(
        self,
        cluster_stat_user_input: List[GetUserInputStatisticInfoResponseBodyUserInputListClusterStatUserInput] = None,
    ):
        self.cluster_stat_user_input = cluster_stat_user_input

    def validate(self):
        if self.cluster_stat_user_input:
            for k in self.cluster_stat_user_input:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatUserInput'] = []
        if self.cluster_stat_user_input is not None:
            for k in self.cluster_stat_user_input:
                result['ClusterStatUserInput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_user_input = []
        if m.get('ClusterStatUserInput') is not None:
            for k in m.get('ClusterStatUserInput'):
                temp_model = GetUserInputStatisticInfoResponseBodyUserInputListClusterStatUserInput()
                self.cluster_stat_user_input.append(temp_model.from_map(k))
        return self


class GetUserInputStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_input_list: GetUserInputStatisticInfoResponseBodyUserInputList = None,
    ):
        self.request_id = request_id
        self.user_input_list = user_input_list

    def validate(self):
        if self.user_input_list:
            self.user_input_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_input_list is not None:
            result['UserInputList'] = self.user_input_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserInputList') is not None:
            temp_model = GetUserInputStatisticInfoResponseBodyUserInputList()
            self.user_input_list = temp_model.from_map(m['UserInputList'])
        return self


class GetUserInputStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetUserInputStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetUserInputStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserOutputStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        return self


class GetUserOutputStatisticInfoResponseBodyUserOutputListClusterStatUserOutput(TeaModel):
    def __init__(
        self,
        user: str = None,
        bytes_output: int = None,
    ):
        self.user = user
        self.bytes_output = bytes_output

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user is not None:
            result['User'] = self.user
        if self.bytes_output is not None:
            result['BytesOutput'] = self.bytes_output
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('BytesOutput') is not None:
            self.bytes_output = m.get('BytesOutput')
        return self


class GetUserOutputStatisticInfoResponseBodyUserOutputList(TeaModel):
    def __init__(
        self,
        cluster_stat_user_output: List[GetUserOutputStatisticInfoResponseBodyUserOutputListClusterStatUserOutput] = None,
    ):
        self.cluster_stat_user_output = cluster_stat_user_output

    def validate(self):
        if self.cluster_stat_user_output:
            for k in self.cluster_stat_user_output:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatUserOutput'] = []
        if self.cluster_stat_user_output is not None:
            for k in self.cluster_stat_user_output:
                result['ClusterStatUserOutput'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_user_output = []
        if m.get('ClusterStatUserOutput') is not None:
            for k in m.get('ClusterStatUserOutput'):
                temp_model = GetUserOutputStatisticInfoResponseBodyUserOutputListClusterStatUserOutput()
                self.cluster_stat_user_output.append(temp_model.from_map(k))
        return self


class GetUserOutputStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_output_list: GetUserOutputStatisticInfoResponseBodyUserOutputList = None,
    ):
        self.request_id = request_id
        self.user_output_list = user_output_list

    def validate(self):
        if self.user_output_list:
            self.user_output_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_output_list is not None:
            result['UserOutputList'] = self.user_output_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserOutputList') is not None:
            temp_model = GetUserOutputStatisticInfoResponseBodyUserOutputList()
            self.user_output_list = temp_model.from_map(m['UserOutputList'])
        return self


class GetUserOutputStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetUserOutputStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetUserOutputStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetUserSubmissionStatisticInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        from_datetime: str = None,
        to_datetime: str = None,
        application_type: str = None,
        final_status: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.from_datetime = from_datetime
        self.to_datetime = to_datetime
        self.application_type = application_type
        self.final_status = final_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.from_datetime is not None:
            result['FromDatetime'] = self.from_datetime
        if self.to_datetime is not None:
            result['ToDatetime'] = self.to_datetime
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.final_status is not None:
            result['FinalStatus'] = self.final_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FromDatetime') is not None:
            self.from_datetime = m.get('FromDatetime')
        if m.get('ToDatetime') is not None:
            self.to_datetime = m.get('ToDatetime')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('FinalStatus') is not None:
            self.final_status = m.get('FinalStatus')
        return self


class GetUserSubmissionStatisticInfoResponseBodyUserSubmissionListClusterStatUserSubmission(TeaModel):
    def __init__(
        self,
        submission: int = None,
        user: str = None,
    ):
        self.submission = submission
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.submission is not None:
            result['Submission'] = self.submission
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Submission') is not None:
            self.submission = m.get('Submission')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class GetUserSubmissionStatisticInfoResponseBodyUserSubmissionList(TeaModel):
    def __init__(
        self,
        cluster_stat_user_submission: List[GetUserSubmissionStatisticInfoResponseBodyUserSubmissionListClusterStatUserSubmission] = None,
    ):
        self.cluster_stat_user_submission = cluster_stat_user_submission

    def validate(self):
        if self.cluster_stat_user_submission:
            for k in self.cluster_stat_user_submission:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterStatUserSubmission'] = []
        if self.cluster_stat_user_submission is not None:
            for k in self.cluster_stat_user_submission:
                result['ClusterStatUserSubmission'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_stat_user_submission = []
        if m.get('ClusterStatUserSubmission') is not None:
            for k in m.get('ClusterStatUserSubmission'):
                temp_model = GetUserSubmissionStatisticInfoResponseBodyUserSubmissionListClusterStatUserSubmission()
                self.cluster_stat_user_submission.append(temp_model.from_map(k))
        return self


class GetUserSubmissionStatisticInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_submission_list: GetUserSubmissionStatisticInfoResponseBodyUserSubmissionList = None,
    ):
        self.request_id = request_id
        self.user_submission_list = user_submission_list

    def validate(self):
        if self.user_submission_list:
            self.user_submission_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_submission_list is not None:
            result['UserSubmissionList'] = self.user_submission_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserSubmissionList') is not None:
            temp_model = GetUserSubmissionStatisticInfoResponseBodyUserSubmissionList()
            self.user_submission_list = temp_model.from_map(m['UserSubmissionList'])
        return self


class GetUserSubmissionStatisticInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetUserSubmissionStatisticInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetUserSubmissionStatisticInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InstallLibrariesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        library_biz_id: str = None,
        cluster_biz_id_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.library_biz_id = library_biz_id
        self.cluster_biz_id_list = cluster_biz_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        if self.cluster_biz_id_list is not None:
            result['ClusterBizIdList'] = self.cluster_biz_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        if m.get('ClusterBizIdList') is not None:
            self.cluster_biz_id_list = m.get('ClusterBizIdList')
        return self


class InstallLibrariesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class InstallLibrariesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InstallLibrariesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InstallLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class JoinResourceGroupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_type: str = None,
        resource_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class JoinResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class JoinResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: JoinResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = JoinResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class KillFlowJobRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        job_instance_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.job_instance_id = job_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_instance_id is not None:
            result['JobInstanceId'] = self.job_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobInstanceId') is not None:
            self.job_instance_id = m.get('JobInstanceId')
        return self


class KillFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        self.request_id = request_id
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class KillFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: KillFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = KillFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAdviceActionRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        component: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.component = component
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.component is not None:
            result['Component'] = self.component
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Component') is not None:
            self.component = m.get('Component')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListAdviceActionResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        hostgroup_name: str = None,
        config_name: str = None,
        action_type: str = None,
        command: str = None,
        gmt_create: int = None,
        component: str = None,
        config_item_key: str = None,
        gmt_modified: int = None,
        service_name: str = None,
        cluster_id: str = None,
    ):
        self.hostgroup_name = hostgroup_name
        self.config_name = config_name
        self.action_type = action_type
        self.command = command
        self.gmt_create = gmt_create
        self.component = component
        self.config_item_key = config_item_key
        self.gmt_modified = gmt_modified
        self.service_name = service_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostgroup_name is not None:
            result['HostgroupName'] = self.hostgroup_name
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.command is not None:
            result['Command'] = self.command
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.component is not None:
            result['Component'] = self.component
        if self.config_item_key is not None:
            result['ConfigItemKey'] = self.config_item_key
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostgroupName') is not None:
            self.hostgroup_name = m.get('HostgroupName')
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Component') is not None:
            self.component = m.get('Component')
        if m.get('ConfigItemKey') is not None:
            self.config_item_key = m.get('ConfigItemKey')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ListAdviceActionResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[ListAdviceActionResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListAdviceActionResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListAdviceActionResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
        items: ListAdviceActionResponseBodyItems = None,
    ):
        self.total_count = total_count
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Items') is not None:
            temp_model = ListAdviceActionResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListAdviceActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAdviceActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAdviceActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListApmApplicationRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        start_time_from: int = None,
        start_time_to: int = None,
        end_time_from: int = None,
        end_time_to: int = None,
        cluster_id: str = None,
        app_id: str = None,
        state: str = None,
        final_status: str = None,
        user: str = None,
        queue: str = None,
        name: str = None,
        job_type: str = None,
        order_by: str = None,
        diagnose_result: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.start_time_from = start_time_from
        self.start_time_to = start_time_to
        self.end_time_from = end_time_from
        self.end_time_to = end_time_to
        self.cluster_id = cluster_id
        self.app_id = app_id
        self.state = state
        self.final_status = final_status
        self.user = user
        self.queue = queue
        self.name = name
        self.job_type = job_type
        self.order_by = order_by
        self.diagnose_result = diagnose_result
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time_from is not None:
            result['StartTimeFrom'] = self.start_time_from
        if self.start_time_to is not None:
            result['StartTimeTo'] = self.start_time_to
        if self.end_time_from is not None:
            result['EndTimeFrom'] = self.end_time_from
        if self.end_time_to is not None:
            result['EndTimeTo'] = self.end_time_to
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.state is not None:
            result['State'] = self.state
        if self.final_status is not None:
            result['FinalStatus'] = self.final_status
        if self.user is not None:
            result['User'] = self.user
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.name is not None:
            result['Name'] = self.name
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.diagnose_result is not None:
            result['DiagnoseResult'] = self.diagnose_result
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTimeFrom') is not None:
            self.start_time_from = m.get('StartTimeFrom')
        if m.get('StartTimeTo') is not None:
            self.start_time_to = m.get('StartTimeTo')
        if m.get('EndTimeFrom') is not None:
            self.end_time_from = m.get('EndTimeFrom')
        if m.get('EndTimeTo') is not None:
            self.end_time_to = m.get('EndTimeTo')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('FinalStatus') is not None:
            self.final_status = m.get('FinalStatus')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('DiagnoseResult') is not None:
            self.diagnose_result = m.get('DiagnoseResult')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListApmApplicationResponseBodyApmAppInfoListApmAppInfo(TeaModel):
    def __init__(
        self,
        vcore_seconds: int = None,
        diagnostics: str = None,
        queue: str = None,
        diagnose_code: str = None,
        final_status: str = None,
        allocated_vcore: int = None,
        queue_usage_percent: float = None,
        name: str = None,
        resource_requests: str = None,
        progress: float = None,
        state: str = None,
        cluster_usage_percent: float = None,
        running_containers: int = None,
        application_type: str = None,
        user: str = None,
        allocated_memory: int = None,
        running_duration: int = None,
        memory_seconds: int = None,
        start_time: int = None,
        diagnose_result: str = None,
        finished_time: int = None,
        duration: int = None,
        cluster_biz_id: str = None,
        application_id: str = None,
        submit_time: int = None,
    ):
        self.vcore_seconds = vcore_seconds
        self.diagnostics = diagnostics
        self.queue = queue
        self.diagnose_code = diagnose_code
        self.final_status = final_status
        self.allocated_vcore = allocated_vcore
        self.queue_usage_percent = queue_usage_percent
        self.name = name
        self.resource_requests = resource_requests
        self.progress = progress
        self.state = state
        self.cluster_usage_percent = cluster_usage_percent
        self.running_containers = running_containers
        self.application_type = application_type
        self.user = user
        self.allocated_memory = allocated_memory
        self.running_duration = running_duration
        self.memory_seconds = memory_seconds
        self.start_time = start_time
        self.diagnose_result = diagnose_result
        self.finished_time = finished_time
        self.duration = duration
        self.cluster_biz_id = cluster_biz_id
        self.application_id = application_id
        self.submit_time = submit_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vcore_seconds is not None:
            result['VcoreSeconds'] = self.vcore_seconds
        if self.diagnostics is not None:
            result['Diagnostics'] = self.diagnostics
        if self.queue is not None:
            result['Queue'] = self.queue
        if self.diagnose_code is not None:
            result['DiagnoseCode'] = self.diagnose_code
        if self.final_status is not None:
            result['FinalStatus'] = self.final_status
        if self.allocated_vcore is not None:
            result['AllocatedVcore'] = self.allocated_vcore
        if self.queue_usage_percent is not None:
            result['QueueUsagePercent'] = self.queue_usage_percent
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_requests is not None:
            result['ResourceRequests'] = self.resource_requests
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.state is not None:
            result['State'] = self.state
        if self.cluster_usage_percent is not None:
            result['ClusterUsagePercent'] = self.cluster_usage_percent
        if self.running_containers is not None:
            result['RunningContainers'] = self.running_containers
        if self.application_type is not None:
            result['ApplicationType'] = self.application_type
        if self.user is not None:
            result['User'] = self.user
        if self.allocated_memory is not None:
            result['AllocatedMemory'] = self.allocated_memory
        if self.running_duration is not None:
            result['RunningDuration'] = self.running_duration
        if self.memory_seconds is not None:
            result['MemorySeconds'] = self.memory_seconds
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.diagnose_result is not None:
            result['DiagnoseResult'] = self.diagnose_result
        if self.finished_time is not None:
            result['FinishedTime'] = self.finished_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.submit_time is not None:
            result['SubmitTime'] = self.submit_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VcoreSeconds') is not None:
            self.vcore_seconds = m.get('VcoreSeconds')
        if m.get('Diagnostics') is not None:
            self.diagnostics = m.get('Diagnostics')
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        if m.get('DiagnoseCode') is not None:
            self.diagnose_code = m.get('DiagnoseCode')
        if m.get('FinalStatus') is not None:
            self.final_status = m.get('FinalStatus')
        if m.get('AllocatedVcore') is not None:
            self.allocated_vcore = m.get('AllocatedVcore')
        if m.get('QueueUsagePercent') is not None:
            self.queue_usage_percent = m.get('QueueUsagePercent')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceRequests') is not None:
            self.resource_requests = m.get('ResourceRequests')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('ClusterUsagePercent') is not None:
            self.cluster_usage_percent = m.get('ClusterUsagePercent')
        if m.get('RunningContainers') is not None:
            self.running_containers = m.get('RunningContainers')
        if m.get('ApplicationType') is not None:
            self.application_type = m.get('ApplicationType')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('AllocatedMemory') is not None:
            self.allocated_memory = m.get('AllocatedMemory')
        if m.get('RunningDuration') is not None:
            self.running_duration = m.get('RunningDuration')
        if m.get('MemorySeconds') is not None:
            self.memory_seconds = m.get('MemorySeconds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('DiagnoseResult') is not None:
            self.diagnose_result = m.get('DiagnoseResult')
        if m.get('FinishedTime') is not None:
            self.finished_time = m.get('FinishedTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('SubmitTime') is not None:
            self.submit_time = m.get('SubmitTime')
        return self


class ListApmApplicationResponseBodyApmAppInfoList(TeaModel):
    def __init__(
        self,
        apm_app_info: List[ListApmApplicationResponseBodyApmAppInfoListApmAppInfo] = None,
    ):
        self.apm_app_info = apm_app_info

    def validate(self):
        if self.apm_app_info:
            for k in self.apm_app_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApmAppInfo'] = []
        if self.apm_app_info is not None:
            for k in self.apm_app_info:
                result['ApmAppInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apm_app_info = []
        if m.get('ApmAppInfo') is not None:
            for k in m.get('ApmAppInfo'):
                temp_model = ListApmApplicationResponseBodyApmAppInfoListApmAppInfo()
                self.apm_app_info.append(temp_model.from_map(k))
        return self


class ListApmApplicationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_size: int = None,
        apm_app_info_list: ListApmApplicationResponseBodyApmAppInfoList = None,
        page_number: int = None,
        total: int = None,
    ):
        self.request_id = request_id
        self.page_size = page_size
        self.apm_app_info_list = apm_app_info_list
        self.page_number = page_number
        self.total = total

    def validate(self):
        if self.apm_app_info_list:
            self.apm_app_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.apm_app_info_list is not None:
            result['ApmAppInfoList'] = self.apm_app_info_list.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ApmAppInfoList') is not None:
            temp_model = ListApmApplicationResponseBodyApmAppInfoList()
            self.apm_app_info_list = temp_model.from_map(m['ApmAppInfoList'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListApmApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListApmApplicationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListApmApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListBackupsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        limit: int = None,
        page_number: int = None,
        page_size: int = None,
        current_size: int = None,
        page_count: int = None,
        order_mode: str = None,
        id: int = None,
        biz_id: str = None,
        metadata_type: str = None,
        service_name: str = None,
        backup_plan_id: str = None,
        cluster_id: str = None,
        status: str = None,
        backup_id: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.limit = limit
        self.page_number = page_number
        self.page_size = page_size
        self.current_size = current_size
        self.page_count = page_count
        self.order_mode = order_mode
        self.id = id
        self.biz_id = biz_id
        self.metadata_type = metadata_type
        self.service_name = service_name
        self.backup_plan_id = backup_plan_id
        self.cluster_id = cluster_id
        self.status = status
        self.backup_id = backup_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.id is not None:
            result['Id'] = self.id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.metadata_type is not None:
            result['MetadataType'] = self.metadata_type
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.backup_plan_id is not None:
            result['BackupPlanId'] = self.backup_plan_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.status is not None:
            result['Status'] = self.status
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('MetadataType') is not None:
            self.metadata_type = m.get('MetadataType')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('BackupPlanId') is not None:
            self.backup_plan_id = m.get('BackupPlanId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        return self


class ListBackupsResponseBodyItemsItemMetadataInfo(TeaModel):
    def __init__(
        self,
        metadata_type: str = None,
        properties: str = None,
    ):
        self.metadata_type = metadata_type
        self.properties = properties

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metadata_type is not None:
            result['MetadataType'] = self.metadata_type
        if self.properties is not None:
            result['Properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetadataType') is not None:
            self.metadata_type = m.get('MetadataType')
        if m.get('Properties') is not None:
            self.properties = m.get('Properties')
        return self


class ListBackupsResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        status: str = None,
        tar_file_name: str = None,
        store_path: str = None,
        create_time: int = None,
        md_5: str = None,
        backup_plan_id: str = None,
        metadata_info: ListBackupsResponseBodyItemsItemMetadataInfo = None,
        id: str = None,
        cluster_id: str = None,
    ):
        self.status = status
        self.tar_file_name = tar_file_name
        self.store_path = store_path
        self.create_time = create_time
        self.md_5 = md_5
        self.backup_plan_id = backup_plan_id
        self.metadata_info = metadata_info
        self.id = id
        self.cluster_id = cluster_id

    def validate(self):
        if self.metadata_info:
            self.metadata_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.tar_file_name is not None:
            result['TarFileName'] = self.tar_file_name
        if self.store_path is not None:
            result['StorePath'] = self.store_path
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.backup_plan_id is not None:
            result['BackupPlanId'] = self.backup_plan_id
        if self.metadata_info is not None:
            result['MetadataInfo'] = self.metadata_info.to_map()
        if self.id is not None:
            result['Id'] = self.id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TarFileName') is not None:
            self.tar_file_name = m.get('TarFileName')
        if m.get('StorePath') is not None:
            self.store_path = m.get('StorePath')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('BackupPlanId') is not None:
            self.backup_plan_id = m.get('BackupPlanId')
        if m.get('MetadataInfo') is not None:
            temp_model = ListBackupsResponseBodyItemsItemMetadataInfo()
            self.metadata_info = temp_model.from_map(m['MetadataInfo'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ListBackupsResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[ListBackupsResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListBackupsResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListBackupsResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
        items: ListBackupsResponseBodyItems = None,
    ):
        self.total_count = total_count
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Items') is not None:
            temp_model = ListBackupsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListBackupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListBackupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListBackupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterHostRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_instance_id: str = None,
        host_group_id: str = None,
        host_name: str = None,
        private_ip: str = None,
        public_ip: str = None,
        group_type: str = None,
        component_name: str = None,
        page_number: int = None,
        page_size: int = None,
        status_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_instance_id = host_instance_id
        self.host_group_id = host_group_id
        self.host_name = host_name
        self.private_ip = private_ip
        self.public_ip = public_ip
        self.group_type = group_type
        self.component_name = component_name
        self.page_number = page_number
        self.page_size = page_size
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class ListClusterHostResponseBodyHostListHostDiskListDisk(TeaModel):
    def __init__(
        self,
        type: str = None,
        disk_mount_point: str = None,
        block_mount_point: str = None,
        device: str = None,
        disk_size: int = None,
        event: str = None,
        disk_type: str = None,
        disk_id: str = None,
    ):
        self.type = type
        self.disk_mount_point = disk_mount_point
        self.block_mount_point = block_mount_point
        self.device = device
        self.disk_size = disk_size
        self.event = event
        self.disk_type = disk_type
        self.disk_id = disk_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.disk_mount_point is not None:
            result['DiskMountPoint'] = self.disk_mount_point
        if self.block_mount_point is not None:
            result['BlockMountPoint'] = self.block_mount_point
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.event is not None:
            result['Event'] = self.event
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DiskMountPoint') is not None:
            self.disk_mount_point = m.get('DiskMountPoint')
        if m.get('BlockMountPoint') is not None:
            self.block_mount_point = m.get('BlockMountPoint')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('Event') is not None:
            self.event = m.get('Event')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        return self


class ListClusterHostResponseBodyHostListHostDiskList(TeaModel):
    def __init__(
        self,
        disk: List[ListClusterHostResponseBodyHostListHostDiskListDisk] = None,
    ):
        self.disk = disk

    def validate(self):
        if self.disk:
            for k in self.disk:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Disk'] = []
        if self.disk is not None:
            for k in self.disk:
                result['Disk'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disk = []
        if m.get('Disk') is not None:
            for k in m.get('Disk'):
                temp_model = ListClusterHostResponseBodyHostListHostDiskListDisk()
                self.disk.append(temp_model.from_map(k))
        return self


class ListClusterHostResponseBodyHostListHost(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        serial_number: str = None,
        private_ip: str = None,
        disk_list: ListClusterHostResponseBodyHostListHostDiskList = None,
        create_time: str = None,
        charge_type: str = None,
        host_name: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        host_instance_id: str = None,
        support_ip_v6: bool = None,
        cpu: int = None,
        expired_time: int = None,
        zone_id: str = None,
        public_ip: str = None,
        instance_status: str = None,
        memory: int = None,
        emr_expired_time: str = None,
        role: str = None,
    ):
        self.status = status
        self.type = type
        self.serial_number = serial_number
        self.private_ip = private_ip
        self.disk_list = disk_list
        self.create_time = create_time
        self.charge_type = charge_type
        self.host_name = host_name
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.host_instance_id = host_instance_id
        self.support_ip_v6 = support_ip_v6
        self.cpu = cpu
        self.expired_time = expired_time
        self.zone_id = zone_id
        self.public_ip = public_ip
        self.instance_status = instance_status
        self.memory = memory
        self.emr_expired_time = emr_expired_time
        self.role = role

    def validate(self):
        if self.disk_list:
            self.disk_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.disk_list is not None:
            result['DiskList'] = self.disk_list.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.support_ip_v6 is not None:
            result['SupportIpV6'] = self.support_ip_v6
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.instance_status is not None:
            result['InstanceStatus'] = self.instance_status
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.emr_expired_time is not None:
            result['EmrExpiredTime'] = self.emr_expired_time
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('DiskList') is not None:
            temp_model = ListClusterHostResponseBodyHostListHostDiskList()
            self.disk_list = temp_model.from_map(m['DiskList'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('SupportIpV6') is not None:
            self.support_ip_v6 = m.get('SupportIpV6')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('InstanceStatus') is not None:
            self.instance_status = m.get('InstanceStatus')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('EmrExpiredTime') is not None:
            self.emr_expired_time = m.get('EmrExpiredTime')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class ListClusterHostResponseBodyHostList(TeaModel):
    def __init__(
        self,
        host: List[ListClusterHostResponseBodyHostListHost] = None,
    ):
        self.host = host

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = ListClusterHostResponseBodyHostListHost()
                self.host.append(temp_model.from_map(k))
        return self


class ListClusterHostResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
        total: int = None,
        host_list: ListClusterHostResponseBodyHostList = None,
    ):
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number
        self.total = total
        self.host_list = host_list

    def validate(self):
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total is not None:
            result['Total'] = self.total
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('HostList') is not None:
            temp_model = ListClusterHostResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListClusterHostResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterHostResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterHostComponentRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_instance_id: str = None,
        host_name: str = None,
        service_name: str = None,
        component_name: str = None,
        component_status: str = None,
        host_role: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_instance_id = host_instance_id
        self.host_name = host_name
        self.service_name = service_name
        self.component_name = component_name
        self.component_status = component_status
        self.host_role = host_role
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_status is not None:
            result['ComponentStatus'] = self.component_status
        if self.host_role is not None:
            result['HostRole'] = self.host_role
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentStatus') is not None:
            self.component_status = m.get('ComponentStatus')
        if m.get('HostRole') is not None:
            self.host_role = m.get('HostRole')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterHostComponentResponseBodyComponentListComponent(TeaModel):
    def __init__(
        self,
        service_display_name: str = None,
        status: str = None,
        serial_number: str = None,
        server_status: str = None,
        private_ip: str = None,
        component_name: str = None,
        commission_status: str = None,
        host_name: str = None,
        need_restart: bool = None,
        instance_type: str = None,
        host_id: str = None,
        host_instance_id: str = None,
        cpu: int = None,
        component_display_name: str = None,
        public_ip: str = None,
        memory: int = None,
        role: str = None,
        service_name: str = None,
    ):
        self.service_display_name = service_display_name
        self.status = status
        self.serial_number = serial_number
        self.server_status = server_status
        self.private_ip = private_ip
        self.component_name = component_name
        self.commission_status = commission_status
        self.host_name = host_name
        self.need_restart = need_restart
        self.instance_type = instance_type
        self.host_id = host_id
        self.host_instance_id = host_instance_id
        self.cpu = cpu
        self.component_display_name = component_display_name
        self.public_ip = public_ip
        self.memory = memory
        self.role = role
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.status is not None:
            result['Status'] = self.status
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.server_status is not None:
            result['ServerStatus'] = self.server_status
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.commission_status is not None:
            result['CommissionStatus'] = self.commission_status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.need_restart is not None:
            result['NeedRestart'] = self.need_restart
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.component_display_name is not None:
            result['ComponentDisplayName'] = self.component_display_name
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.role is not None:
            result['Role'] = self.role
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('ServerStatus') is not None:
            self.server_status = m.get('ServerStatus')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('CommissionStatus') is not None:
            self.commission_status = m.get('CommissionStatus')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('NeedRestart') is not None:
            self.need_restart = m.get('NeedRestart')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('ComponentDisplayName') is not None:
            self.component_display_name = m.get('ComponentDisplayName')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListClusterHostComponentResponseBodyComponentList(TeaModel):
    def __init__(
        self,
        component: List[ListClusterHostComponentResponseBodyComponentListComponent] = None,
    ):
        self.component = component

    def validate(self):
        if self.component:
            for k in self.component:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Component'] = []
        if self.component is not None:
            for k in self.component:
                result['Component'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.component = []
        if m.get('Component') is not None:
            for k in m.get('Component'):
                temp_model = ListClusterHostComponentResponseBodyComponentListComponent()
                self.component.append(temp_model.from_map(k))
        return self


class ListClusterHostComponentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
        total: int = None,
        component_list: ListClusterHostComponentResponseBodyComponentList = None,
    ):
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number
        self.total = total
        self.component_list = component_list

    def validate(self):
        if self.component_list:
            self.component_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total is not None:
            result['Total'] = self.total
        if self.component_list is not None:
            result['ComponentList'] = self.component_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('ComponentList') is not None:
            temp_model = ListClusterHostComponentResponseBodyComponentList()
            self.component_list = temp_model.from_map(m['ComponentList'])
        return self


class ListClusterHostComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterHostComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterHostComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterHostGroupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_group_id: str = None,
        host_group_name: str = None,
        host_group_type: str = None,
        page_number: int = None,
        page_size: int = None,
        status_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_group_id = host_group_id
        self.host_group_name = host_group_name
        self.host_group_type = host_group_type
        self.page_number = page_number
        self.page_size = page_size
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class ListClusterHostGroupResponseBodyHostGroupListHostGroup(TeaModel):
    def __init__(
        self,
        status: str = None,
        host_group_sub_type: str = None,
        host_group_type: str = None,
        comment: str = None,
        scaling_group_min_node: int = None,
        vswitch_id: str = None,
        security_group_id: str = None,
        host_group_change_status: str = None,
        charge_type: str = None,
        pay_type: str = None,
        data_disk_type: str = None,
        system_disk_count: int = None,
        system_disk_size: int = None,
        scaling_group_biz_id: str = None,
        gmt_modified: str = None,
        memory: int = None,
        scaling_group_max_node: int = None,
        host_group_change_type: str = None,
        lock_type: str = None,
        scaling_in_mode: str = None,
        cost_saving_percent: float = None,
        data_disk_size: int = None,
        lock_reason: str = None,
        host_group_id: str = None,
        gmt_create: str = None,
        instance_type: str = None,
        cpu: int = None,
        data_disk_count: int = None,
        scaling_group_active_status: str = None,
        node_count: int = None,
        system_disk_type: str = None,
        scaling_group_config_state: str = None,
        host_group_name: str = None,
    ):
        self.status = status
        self.host_group_sub_type = host_group_sub_type
        self.host_group_type = host_group_type
        self.comment = comment
        self.scaling_group_min_node = scaling_group_min_node
        self.vswitch_id = vswitch_id
        self.security_group_id = security_group_id
        self.host_group_change_status = host_group_change_status
        self.charge_type = charge_type
        self.pay_type = pay_type
        self.data_disk_type = data_disk_type
        self.system_disk_count = system_disk_count
        self.system_disk_size = system_disk_size
        self.scaling_group_biz_id = scaling_group_biz_id
        self.gmt_modified = gmt_modified
        self.memory = memory
        self.scaling_group_max_node = scaling_group_max_node
        self.host_group_change_type = host_group_change_type
        self.lock_type = lock_type
        self.scaling_in_mode = scaling_in_mode
        self.cost_saving_percent = cost_saving_percent
        self.data_disk_size = data_disk_size
        self.lock_reason = lock_reason
        self.host_group_id = host_group_id
        self.gmt_create = gmt_create
        self.instance_type = instance_type
        self.cpu = cpu
        self.data_disk_count = data_disk_count
        self.scaling_group_active_status = scaling_group_active_status
        self.node_count = node_count
        self.system_disk_type = system_disk_type
        self.scaling_group_config_state = scaling_group_config_state
        self.host_group_name = host_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.host_group_sub_type is not None:
            result['HostGroupSubType'] = self.host_group_sub_type
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.scaling_group_min_node is not None:
            result['ScalingGroupMinNode'] = self.scaling_group_min_node
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.host_group_change_status is not None:
            result['HostGroupChangeStatus'] = self.host_group_change_status
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.data_disk_type is not None:
            result['DataDiskType'] = self.data_disk_type
        if self.system_disk_count is not None:
            result['SystemDiskCount'] = self.system_disk_count
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.gmt_modified is not None:
            result['gmtModified'] = self.gmt_modified
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.scaling_group_max_node is not None:
            result['ScalingGroupMaxNode'] = self.scaling_group_max_node
        if self.host_group_change_type is not None:
            result['HostGroupChangeType'] = self.host_group_change_type
        if self.lock_type is not None:
            result['LockType'] = self.lock_type
        if self.scaling_in_mode is not None:
            result['ScalingInMode'] = self.scaling_in_mode
        if self.cost_saving_percent is not None:
            result['CostSavingPercent'] = self.cost_saving_percent
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.gmt_create is not None:
            result['gmtCreate'] = self.gmt_create
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.data_disk_count is not None:
            result['DataDiskCount'] = self.data_disk_count
        if self.scaling_group_active_status is not None:
            result['ScalingGroupActiveStatus'] = self.scaling_group_active_status
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.system_disk_type is not None:
            result['SystemDiskType'] = self.system_disk_type
        if self.scaling_group_config_state is not None:
            result['ScalingGroupConfigState'] = self.scaling_group_config_state
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('HostGroupSubType') is not None:
            self.host_group_sub_type = m.get('HostGroupSubType')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ScalingGroupMinNode') is not None:
            self.scaling_group_min_node = m.get('ScalingGroupMinNode')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('HostGroupChangeStatus') is not None:
            self.host_group_change_status = m.get('HostGroupChangeStatus')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('DataDiskType') is not None:
            self.data_disk_type = m.get('DataDiskType')
        if m.get('SystemDiskCount') is not None:
            self.system_disk_count = m.get('SystemDiskCount')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('gmtModified') is not None:
            self.gmt_modified = m.get('gmtModified')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('ScalingGroupMaxNode') is not None:
            self.scaling_group_max_node = m.get('ScalingGroupMaxNode')
        if m.get('HostGroupChangeType') is not None:
            self.host_group_change_type = m.get('HostGroupChangeType')
        if m.get('LockType') is not None:
            self.lock_type = m.get('LockType')
        if m.get('ScalingInMode') is not None:
            self.scaling_in_mode = m.get('ScalingInMode')
        if m.get('CostSavingPercent') is not None:
            self.cost_saving_percent = m.get('CostSavingPercent')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('gmtCreate') is not None:
            self.gmt_create = m.get('gmtCreate')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('DataDiskCount') is not None:
            self.data_disk_count = m.get('DataDiskCount')
        if m.get('ScalingGroupActiveStatus') is not None:
            self.scaling_group_active_status = m.get('ScalingGroupActiveStatus')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('SystemDiskType') is not None:
            self.system_disk_type = m.get('SystemDiskType')
        if m.get('ScalingGroupConfigState') is not None:
            self.scaling_group_config_state = m.get('ScalingGroupConfigState')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListClusterHostGroupResponseBodyHostGroupList(TeaModel):
    def __init__(
        self,
        host_group: List[ListClusterHostGroupResponseBodyHostGroupListHostGroup] = None,
    ):
        self.host_group = host_group

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = ListClusterHostGroupResponseBodyHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class ListClusterHostGroupResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        cluster_id: str = None,
        total: int = None,
        host_group_list: ListClusterHostGroupResponseBodyHostGroupList = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.cluster_id = cluster_id
        self.total = total
        self.host_group_list = host_group_list

    def validate(self):
        if self.host_group_list:
            self.host_group_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.total is not None:
            result['Total'] = self.total
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('HostGroupList') is not None:
            temp_model = ListClusterHostGroupResponseBodyHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        return self


class ListClusterHostGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterHostGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterHostGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterInstalledServiceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        component_name: str = None,
        command: str = None,
        action_name: str = None,
        service_name: str = None,
    ):
        self.display_name = display_name
        self.component_name = component_name
        self.command = command
        self.action_name = action_name
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.command is not None:
            result['Command'] = self.command
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList(TeaModel):
    def __init__(
        self,
        service_action: List[ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction] = None,
    ):
        self.service_action = service_action

    def validate(self):
        if self.service_action:
            for k in self.service_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ServiceAction'] = []
        if self.service_action is not None:
            for k in self.service_action:
                result['ServiceAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.service_action = []
        if m.get('ServiceAction') is not None:
            for k in m.get('ServiceAction'):
                temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction()
                self.service_action.append(temp_model.from_map(k))
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService(TeaModel):
    def __init__(
        self,
        service_ecm_version: str = None,
        service_display_name: str = None,
        service_action_list: ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList = None,
        not_started_num: int = None,
        service_version: str = None,
        comment: str = None,
        abnormal_num: int = None,
        service_name: str = None,
        only_client: bool = None,
        service_status: str = None,
        need_restart_num: int = None,
    ):
        self.service_ecm_version = service_ecm_version
        self.service_display_name = service_display_name
        self.service_action_list = service_action_list
        self.not_started_num = not_started_num
        self.service_version = service_version
        self.comment = comment
        self.abnormal_num = abnormal_num
        self.service_name = service_name
        self.only_client = only_client
        self.service_status = service_status
        self.need_restart_num = need_restart_num

    def validate(self):
        if self.service_action_list:
            self.service_action_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_ecm_version is not None:
            result['ServiceEcmVersion'] = self.service_ecm_version
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.service_action_list is not None:
            result['ServiceActionList'] = self.service_action_list.to_map()
        if self.not_started_num is not None:
            result['notStartedNum'] = self.not_started_num
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.comment is not None:
            result['comment'] = self.comment
        if self.abnormal_num is not None:
            result['abnormalNum'] = self.abnormal_num
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.only_client is not None:
            result['onlyClient'] = self.only_client
        if self.service_status is not None:
            result['serviceStatus'] = self.service_status
        if self.need_restart_num is not None:
            result['needRestartNum'] = self.need_restart_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceEcmVersion') is not None:
            self.service_ecm_version = m.get('ServiceEcmVersion')
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('ServiceActionList') is not None:
            temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList()
            self.service_action_list = temp_model.from_map(m['ServiceActionList'])
        if m.get('notStartedNum') is not None:
            self.not_started_num = m.get('notStartedNum')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        if m.get('abnormalNum') is not None:
            self.abnormal_num = m.get('abnormalNum')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('onlyClient') is not None:
            self.only_client = m.get('onlyClient')
        if m.get('serviceStatus') is not None:
            self.service_status = m.get('serviceStatus')
        if m.get('needRestartNum') is not None:
            self.need_restart_num = m.get('needRestartNum')
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceList(TeaModel):
    def __init__(
        self,
        cluster_installed_service: List[ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService] = None,
    ):
        self.cluster_installed_service = cluster_installed_service

    def validate(self):
        if self.cluster_installed_service:
            for k in self.cluster_installed_service:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInstalledService'] = []
        if self.cluster_installed_service is not None:
            for k in self.cluster_installed_service:
                result['ClusterInstalledService'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_installed_service = []
        if m.get('ClusterInstalledService') is not None:
            for k in m.get('ClusterInstalledService'):
                temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService()
                self.cluster_installed_service.append(temp_model.from_map(k))
        return self


class ListClusterInstalledServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cluster_installed_service_list: ListClusterInstalledServiceResponseBodyClusterInstalledServiceList = None,
    ):
        self.request_id = request_id
        self.cluster_installed_service_list = cluster_installed_service_list

    def validate(self):
        if self.cluster_installed_service_list:
            self.cluster_installed_service_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_installed_service_list is not None:
            result['ClusterInstalledServiceList'] = self.cluster_installed_service_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterInstalledServiceList') is not None:
            temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceList()
            self.cluster_installed_service_list = temp_model.from_map(m['ClusterInstalledServiceList'])
        return self


class ListClusterInstalledServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterInstalledServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterInstalledServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        operation_id: str = None,
        service_name: str = None,
        status: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.operation_id = operation_id
        self.service_name = service_name
        self.status = status
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationResponseBodyClusterOperationListClusterOperation(TeaModel):
    def __init__(
        self,
        status: str = None,
        start_time: str = None,
        comment: str = None,
        operation_name: str = None,
        operation_id: str = None,
        duration: str = None,
        percentage: str = None,
    ):
        self.status = status
        self.start_time = start_time
        self.comment = comment
        self.operation_name = operation_name
        self.operation_id = operation_id
        self.duration = duration
        self.percentage = percentage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.operation_name is not None:
            result['OperationName'] = self.operation_name
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OperationName') is not None:
            self.operation_name = m.get('OperationName')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        return self


class ListClusterOperationResponseBodyClusterOperationList(TeaModel):
    def __init__(
        self,
        cluster_operation: List[ListClusterOperationResponseBodyClusterOperationListClusterOperation] = None,
    ):
        self.cluster_operation = cluster_operation

    def validate(self):
        if self.cluster_operation:
            for k in self.cluster_operation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperation'] = []
        if self.cluster_operation is not None:
            for k in self.cluster_operation:
                result['ClusterOperation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_operation = []
        if m.get('ClusterOperation') is not None:
            for k in m.get('ClusterOperation'):
                temp_model = ListClusterOperationResponseBodyClusterOperationListClusterOperation()
                self.cluster_operation.append(temp_model.from_map(k))
        return self


class ListClusterOperationResponseBody(TeaModel):
    def __init__(
        self,
        cluster_operation_list: ListClusterOperationResponseBodyClusterOperationList = None,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
    ):
        self.cluster_operation_list = cluster_operation_list
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number

    def validate(self):
        if self.cluster_operation_list:
            self.cluster_operation_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_operation_list is not None:
            result['ClusterOperationList'] = self.cluster_operation_list.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterOperationList') is not None:
            temp_model = ListClusterOperationResponseBodyClusterOperationList()
            self.cluster_operation_list = temp_model.from_map(m['ClusterOperationList'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListClusterOperationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationHostRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        operation_id: str = None,
        status: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.operation_id = operation_id
        self.status = status
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost(TeaModel):
    def __init__(
        self,
        status: str = None,
        host_name: str = None,
        percentage: str = None,
        host_id: str = None,
    ):
        self.status = status
        self.host_name = host_name
        self.percentage = percentage
        self.host_id = host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.host_id is not None:
            result['HostId'] = self.host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        return self


class ListClusterOperationHostResponseBodyClusterOperationHostList(TeaModel):
    def __init__(
        self,
        cluster_operation_host: List[ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost] = None,
    ):
        self.cluster_operation_host = cluster_operation_host

    def validate(self):
        if self.cluster_operation_host:
            for k in self.cluster_operation_host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperationHost'] = []
        if self.cluster_operation_host is not None:
            for k in self.cluster_operation_host:
                result['ClusterOperationHost'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_operation_host = []
        if m.get('ClusterOperationHost') is not None:
            for k in m.get('ClusterOperationHost'):
                temp_model = ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost()
                self.cluster_operation_host.append(temp_model.from_map(k))
        return self


class ListClusterOperationHostResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        cluster_operation_host_list: ListClusterOperationHostResponseBodyClusterOperationHostList = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.cluster_operation_host_list = cluster_operation_host_list

    def validate(self):
        if self.cluster_operation_host_list:
            self.cluster_operation_host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.cluster_operation_host_list is not None:
            result['ClusterOperationHostList'] = self.cluster_operation_host_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ClusterOperationHostList') is not None:
            temp_model = ListClusterOperationHostResponseBodyClusterOperationHostList()
            self.cluster_operation_host_list = temp_model.from_map(m['ClusterOperationHostList'])
        return self


class ListClusterOperationHostResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationHostResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationHostTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        operation_id: str = None,
        host_id: str = None,
        status: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.operation_id = operation_id
        self.host_id = host_id
        self.status = status
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask(TeaModel):
    def __init__(
        self,
        status: str = None,
        task_name: str = None,
        percentage: str = None,
        task_id: str = None,
    ):
        self.status = status
        self.task_name = task_name
        self.percentage = percentage
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList(TeaModel):
    def __init__(
        self,
        cluster_operation_host_task: List[ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask] = None,
    ):
        self.cluster_operation_host_task = cluster_operation_host_task

    def validate(self):
        if self.cluster_operation_host_task:
            for k in self.cluster_operation_host_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperationHostTask'] = []
        if self.cluster_operation_host_task is not None:
            for k in self.cluster_operation_host_task:
                result['ClusterOperationHostTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_operation_host_task = []
        if m.get('ClusterOperationHostTask') is not None:
            for k in m.get('ClusterOperationHostTask'):
                temp_model = ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask()
                self.cluster_operation_host_task.append(temp_model.from_map(k))
        return self


class ListClusterOperationHostTaskResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        cluster_operation_host_task_list: ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.cluster_operation_host_task_list = cluster_operation_host_task_list

    def validate(self):
        if self.cluster_operation_host_task_list:
            self.cluster_operation_host_task_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.cluster_operation_host_task_list is not None:
            result['ClusterOperationHostTaskList'] = self.cluster_operation_host_task_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ClusterOperationHostTaskList') is not None:
            temp_model = ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList()
            self.cluster_operation_host_task_list = temp_model.from_map(m['ClusterOperationHostTaskList'])
        return self


class ListClusterOperationHostTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationHostTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationHostTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        operation_id: str = None,
        status: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.operation_id = operation_id
        self.status = status
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationTaskResponseBodyClusterOperationTaskListClusterOperationTask(TeaModel):
    def __init__(
        self,
        status: str = None,
        task_name: str = None,
        percentage: str = None,
        task_id: str = None,
    ):
        self.status = status
        self.task_name = task_name
        self.percentage = percentage
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListClusterOperationTaskResponseBodyClusterOperationTaskList(TeaModel):
    def __init__(
        self,
        cluster_operation_task: List[ListClusterOperationTaskResponseBodyClusterOperationTaskListClusterOperationTask] = None,
    ):
        self.cluster_operation_task = cluster_operation_task

    def validate(self):
        if self.cluster_operation_task:
            for k in self.cluster_operation_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperationTask'] = []
        if self.cluster_operation_task is not None:
            for k in self.cluster_operation_task:
                result['ClusterOperationTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_operation_task = []
        if m.get('ClusterOperationTask') is not None:
            for k in m.get('ClusterOperationTask'):
                temp_model = ListClusterOperationTaskResponseBodyClusterOperationTaskListClusterOperationTask()
                self.cluster_operation_task.append(temp_model.from_map(k))
        return self


class ListClusterOperationTaskResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        cluster_operation_task_list: ListClusterOperationTaskResponseBodyClusterOperationTaskList = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.cluster_operation_task_list = cluster_operation_task_list

    def validate(self):
        if self.cluster_operation_task_list:
            self.cluster_operation_task_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.cluster_operation_task_list is not None:
            result['ClusterOperationTaskList'] = self.cluster_operation_task_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ClusterOperationTaskList') is not None:
            temp_model = ListClusterOperationTaskResponseBodyClusterOperationTaskList()
            self.cluster_operation_task_list = temp_model.from_map(m['ClusterOperationTaskList'])
        return self


class ListClusterOperationTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClustersRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListClustersRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        create_type: str = None,
        machine_type: str = None,
        is_desc: bool = None,
        deposit_type: str = None,
        page_number: int = None,
        page_size: int = None,
        default_status: bool = None,
        name: str = None,
        vpc_id: str = None,
        resource_group_id: str = None,
        cluster_type_list: List[str] = None,
        status_list: List[str] = None,
        tag: List[ListClustersRequestTag] = None,
        expired_tag_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.create_type = create_type
        self.machine_type = machine_type
        self.is_desc = is_desc
        self.deposit_type = deposit_type
        self.page_number = page_number
        self.page_size = page_size
        self.default_status = default_status
        self.name = name
        self.vpc_id = vpc_id
        self.resource_group_id = resource_group_id
        self.cluster_type_list = cluster_type_list
        self.status_list = status_list
        self.tag = tag
        self.expired_tag_list = expired_tag_list

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.is_desc is not None:
            result['IsDesc'] = self.is_desc
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.default_status is not None:
            result['DefaultStatus'] = self.default_status
        if self.name is not None:
            result['Name'] = self.name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.cluster_type_list is not None:
            result['ClusterTypeList'] = self.cluster_type_list
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.expired_tag_list is not None:
            result['ExpiredTagList'] = self.expired_tag_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('IsDesc') is not None:
            self.is_desc = m.get('IsDesc')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('DefaultStatus') is not None:
            self.default_status = m.get('DefaultStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClusterTypeList') is not None:
            self.cluster_type_list = m.get('ClusterTypeList')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ExpiredTagList') is not None:
            self.expired_tag_list = m.get('ExpiredTagList')
        return self


class ListClustersResponseBodyClustersClusterInfoTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class ListClustersResponseBodyClustersClusterInfoTags(TeaModel):
    def __init__(
        self,
        tag: List[ListClustersResponseBodyClustersClusterInfoTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListClustersResponseBodyClustersClusterInfoTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ListClustersResponseBodyClustersClusterInfoOrderTaskInfo(TeaModel):
    def __init__(
        self,
        current_count: int = None,
        order_id_list: str = None,
        target_count: int = None,
    ):
        self.current_count = current_count
        self.order_id_list = order_id_list
        self.target_count = target_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.order_id_list is not None:
            result['OrderIdList'] = self.order_id_list
        if self.target_count is not None:
            result['TargetCount'] = self.target_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('OrderIdList') is not None:
            self.order_id_list = m.get('OrderIdList')
        if m.get('TargetCount') is not None:
            self.target_count = m.get('TargetCount')
        return self


class ListClustersResponseBodyClustersClusterInfoFailReason(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        error_code: str = None,
        error_msg: str = None,
    ):
        self.request_id = request_id
        self.error_code = error_code
        self.error_msg = error_msg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        return self


class ListClustersResponseBodyClustersClusterInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        status: str = None,
        running_time: int = None,
        machine_type: str = None,
        order_list: str = None,
        meta_store_type: str = None,
        create_time: int = None,
        charge_type: str = None,
        tags: ListClustersResponseBodyClustersClusterInfoTags = None,
        operation_id: int = None,
        deposit_type: str = None,
        period: int = None,
        k_8s_cluster_id: str = None,
        expired_time: int = None,
        has_uncompleted_order: bool = None,
        order_task_info: ListClustersResponseBodyClustersClusterInfoOrderTaskInfo = None,
        name: str = None,
        create_resource: str = None,
        id: str = None,
        fail_reason: ListClustersResponseBodyClustersClusterInfoFailReason = None,
    ):
        self.type = type
        self.status = status
        self.running_time = running_time
        self.machine_type = machine_type
        self.order_list = order_list
        self.meta_store_type = meta_store_type
        self.create_time = create_time
        self.charge_type = charge_type
        self.tags = tags
        self.operation_id = operation_id
        self.deposit_type = deposit_type
        self.period = period
        self.k_8s_cluster_id = k_8s_cluster_id
        self.expired_time = expired_time
        self.has_uncompleted_order = has_uncompleted_order
        self.order_task_info = order_task_info
        self.name = name
        self.create_resource = create_resource
        self.id = id
        self.fail_reason = fail_reason

    def validate(self):
        if self.tags:
            self.tags.validate()
        if self.order_task_info:
            self.order_task_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.order_list is not None:
            result['OrderList'] = self.order_list
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.period is not None:
            result['Period'] = self.period
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.has_uncompleted_order is not None:
            result['HasUncompletedOrder'] = self.has_uncompleted_order
        if self.order_task_info is not None:
            result['OrderTaskInfo'] = self.order_task_info.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.id is not None:
            result['Id'] = self.id
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('OrderList') is not None:
            self.order_list = m.get('OrderList')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Tags') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('HasUncompletedOrder')
        if m.get('OrderTaskInfo') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoOrderTaskInfo()
            self.order_task_info = temp_model.from_map(m['OrderTaskInfo'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('FailReason') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        return self


class ListClustersResponseBodyClusters(TeaModel):
    def __init__(
        self,
        cluster_info: List[ListClustersResponseBodyClustersClusterInfo] = None,
    ):
        self.cluster_info = cluster_info

    def validate(self):
        if self.cluster_info:
            for k in self.cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInfo'] = []
        if self.cluster_info is not None:
            for k in self.cluster_info:
                result['ClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_info = []
        if m.get('ClusterInfo') is not None:
            for k in m.get('ClusterInfo'):
                temp_model = ListClustersResponseBodyClustersClusterInfo()
                self.cluster_info.append(temp_model.from_map(k))
        return self


class ListClustersResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        clusters: ListClustersResponseBodyClusters = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.clusters = clusters

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Clusters') is not None:
            temp_model = ListClustersResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        return self


class ListClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClustersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterServiceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterServiceResponseBodyClusterServiceListClusterServiceServiceActionListServiceAction(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        component_name: str = None,
        command: str = None,
        action_name: str = None,
        service_name: str = None,
    ):
        self.display_name = display_name
        self.component_name = component_name
        self.command = command
        self.action_name = action_name
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.command is not None:
            result['Command'] = self.command
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListClusterServiceResponseBodyClusterServiceListClusterServiceServiceActionList(TeaModel):
    def __init__(
        self,
        service_action: List[ListClusterServiceResponseBodyClusterServiceListClusterServiceServiceActionListServiceAction] = None,
    ):
        self.service_action = service_action

    def validate(self):
        if self.service_action:
            for k in self.service_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ServiceAction'] = []
        if self.service_action is not None:
            for k in self.service_action:
                result['ServiceAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.service_action = []
        if m.get('ServiceAction') is not None:
            for k in m.get('ServiceAction'):
                temp_model = ListClusterServiceResponseBodyClusterServiceListClusterServiceServiceActionListServiceAction()
                self.service_action.append(temp_model.from_map(k))
        return self


class ListClusterServiceResponseBodyClusterServiceListClusterService(TeaModel):
    def __init__(
        self,
        service_display_name: str = None,
        not_start_info: str = None,
        client_type: bool = None,
        install_status: bool = None,
        service_action_list: ListClusterServiceResponseBodyClusterServiceListClusterServiceServiceActionList = None,
        need_restart_num: int = None,
        service_status: str = None,
        health_status: str = None,
        need_restart_info: str = None,
        stopped_num: int = None,
        service_version: str = None,
        service_name: str = None,
        abnormal_num: int = None,
    ):
        self.service_display_name = service_display_name
        self.not_start_info = not_start_info
        self.client_type = client_type
        self.install_status = install_status
        self.service_action_list = service_action_list
        self.need_restart_num = need_restart_num
        self.service_status = service_status
        self.health_status = health_status
        self.need_restart_info = need_restart_info
        self.stopped_num = stopped_num
        self.service_version = service_version
        self.service_name = service_name
        self.abnormal_num = abnormal_num

    def validate(self):
        if self.service_action_list:
            self.service_action_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.not_start_info is not None:
            result['NotStartInfo'] = self.not_start_info
        if self.client_type is not None:
            result['ClientType'] = self.client_type
        if self.install_status is not None:
            result['InstallStatus'] = self.install_status
        if self.service_action_list is not None:
            result['ServiceActionList'] = self.service_action_list.to_map()
        if self.need_restart_num is not None:
            result['NeedRestartNum'] = self.need_restart_num
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.need_restart_info is not None:
            result['NeedRestartInfo'] = self.need_restart_info
        if self.stopped_num is not None:
            result['StoppedNum'] = self.stopped_num
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.abnormal_num is not None:
            result['AbnormalNum'] = self.abnormal_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('NotStartInfo') is not None:
            self.not_start_info = m.get('NotStartInfo')
        if m.get('ClientType') is not None:
            self.client_type = m.get('ClientType')
        if m.get('InstallStatus') is not None:
            self.install_status = m.get('InstallStatus')
        if m.get('ServiceActionList') is not None:
            temp_model = ListClusterServiceResponseBodyClusterServiceListClusterServiceServiceActionList()
            self.service_action_list = temp_model.from_map(m['ServiceActionList'])
        if m.get('NeedRestartNum') is not None:
            self.need_restart_num = m.get('NeedRestartNum')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('NeedRestartInfo') is not None:
            self.need_restart_info = m.get('NeedRestartInfo')
        if m.get('StoppedNum') is not None:
            self.stopped_num = m.get('StoppedNum')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('AbnormalNum') is not None:
            self.abnormal_num = m.get('AbnormalNum')
        return self


class ListClusterServiceResponseBodyClusterServiceList(TeaModel):
    def __init__(
        self,
        cluster_service: List[ListClusterServiceResponseBodyClusterServiceListClusterService] = None,
    ):
        self.cluster_service = cluster_service

    def validate(self):
        if self.cluster_service:
            for k in self.cluster_service:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterService'] = []
        if self.cluster_service is not None:
            for k in self.cluster_service:
                result['ClusterService'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_service = []
        if m.get('ClusterService') is not None:
            for k in m.get('ClusterService'):
                temp_model = ListClusterServiceResponseBodyClusterServiceListClusterService()
                self.cluster_service.append(temp_model.from_map(k))
        return self


class ListClusterServiceResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        cluster_service_list: ListClusterServiceResponseBodyClusterServiceList = None,
    ):
        self.total_count = total_count
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.cluster_service_list = cluster_service_list

    def validate(self):
        if self.cluster_service_list:
            self.cluster_service_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.cluster_service_list is not None:
            result['ClusterServiceList'] = self.cluster_service_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('ClusterServiceList') is not None:
            temp_model = ListClusterServiceResponseBodyClusterServiceList()
            self.cluster_service_list = temp_model.from_map(m['ClusterServiceList'])
        return self


class ListClusterServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterServiceComponentRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        pod_name: str = None,
        service_name: str = None,
        component_name: str = None,
        component_status: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.pod_name = pod_name
        self.service_name = service_name
        self.component_name = component_name
        self.component_status = component_status
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.pod_name is not None:
            result['PodName'] = self.pod_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_status is not None:
            result['ComponentStatus'] = self.component_status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PodName') is not None:
            self.pod_name = m.get('PodName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentStatus') is not None:
            self.component_status = m.get('ComponentStatus')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterServiceComponentResponseBodyComponentListComponent(TeaModel):
    def __init__(
        self,
        status: str = None,
        service_display_name: str = None,
        private_ip: str = None,
        server_status: str = None,
        pod_name: str = None,
        component_name: str = None,
        commission_status: str = None,
        namespace: str = None,
        need_restart: bool = None,
        workload_type: str = None,
        workload_name: str = None,
        component_display_name: str = None,
        public_ip: str = None,
        service_name: str = None,
        role: str = None,
        desired_count: int = None,
    ):
        self.status = status
        self.service_display_name = service_display_name
        self.private_ip = private_ip
        self.server_status = server_status
        self.pod_name = pod_name
        self.component_name = component_name
        self.commission_status = commission_status
        self.namespace = namespace
        self.need_restart = need_restart
        self.workload_type = workload_type
        self.workload_name = workload_name
        self.component_display_name = component_display_name
        self.public_ip = public_ip
        self.service_name = service_name
        self.role = role
        self.desired_count = desired_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.server_status is not None:
            result['ServerStatus'] = self.server_status
        if self.pod_name is not None:
            result['PodName'] = self.pod_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.commission_status is not None:
            result['CommissionStatus'] = self.commission_status
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.need_restart is not None:
            result['NeedRestart'] = self.need_restart
        if self.workload_type is not None:
            result['WorkloadType'] = self.workload_type
        if self.workload_name is not None:
            result['WorkloadName'] = self.workload_name
        if self.component_display_name is not None:
            result['ComponentDisplayName'] = self.component_display_name
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.role is not None:
            result['Role'] = self.role
        if self.desired_count is not None:
            result['DesiredCount'] = self.desired_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('ServerStatus') is not None:
            self.server_status = m.get('ServerStatus')
        if m.get('PodName') is not None:
            self.pod_name = m.get('PodName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('CommissionStatus') is not None:
            self.commission_status = m.get('CommissionStatus')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NeedRestart') is not None:
            self.need_restart = m.get('NeedRestart')
        if m.get('WorkloadType') is not None:
            self.workload_type = m.get('WorkloadType')
        if m.get('WorkloadName') is not None:
            self.workload_name = m.get('WorkloadName')
        if m.get('ComponentDisplayName') is not None:
            self.component_display_name = m.get('ComponentDisplayName')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('DesiredCount') is not None:
            self.desired_count = m.get('DesiredCount')
        return self


class ListClusterServiceComponentResponseBodyComponentList(TeaModel):
    def __init__(
        self,
        component: List[ListClusterServiceComponentResponseBodyComponentListComponent] = None,
    ):
        self.component = component

    def validate(self):
        if self.component:
            for k in self.component:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Component'] = []
        if self.component is not None:
            for k in self.component:
                result['Component'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.component = []
        if m.get('Component') is not None:
            for k in m.get('Component'):
                temp_model = ListClusterServiceComponentResponseBodyComponentListComponent()
                self.component.append(temp_model.from_map(k))
        return self


class ListClusterServiceComponentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_size: int = None,
        page_number: int = None,
        total: int = None,
        component_list: ListClusterServiceComponentResponseBodyComponentList = None,
    ):
        self.request_id = request_id
        self.page_size = page_size
        self.page_number = page_number
        self.total = total
        self.component_list = component_list

    def validate(self):
        if self.component_list:
            self.component_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total is not None:
            result['Total'] = self.total
        if self.component_list is not None:
            result['ComponentList'] = self.component_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('ComponentList') is not None:
            temp_model = ListClusterServiceComponentResponseBodyComponentList()
            self.component_list = temp_model.from_map(m['ComponentList'])
        return self


class ListClusterServiceComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterServiceComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterServiceComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterServiceComponentHealthInfoRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailListHealthDetailHealthRuleParam(TeaModel):
    def __init__(
        self,
        service: str = None,
        pass_: str = None,
        component: str = None,
        host_names: str = None,
        rule_title: str = None,
        rule_description: str = None,
        rule_id: str = None,
    ):
        self.service = service
        self.pass_ = pass_
        self.component = component
        self.host_names = host_names
        self.rule_title = rule_title
        self.rule_description = rule_description
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service is not None:
            result['Service'] = self.service
        if self.pass_ is not None:
            result['Pass'] = self.pass_
        if self.component is not None:
            result['Component'] = self.component
        if self.host_names is not None:
            result['HostNames'] = self.host_names
        if self.rule_title is not None:
            result['RuleTitle'] = self.rule_title
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Service') is not None:
            self.service = m.get('Service')
        if m.get('Pass') is not None:
            self.pass_ = m.get('Pass')
        if m.get('Component') is not None:
            self.component = m.get('Component')
        if m.get('HostNames') is not None:
            self.host_names = m.get('HostNames')
        if m.get('RuleTitle') is not None:
            self.rule_title = m.get('RuleTitle')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailListHealthDetail(TeaModel):
    def __init__(
        self,
        code: str = None,
        health_rule_param: ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailListHealthDetailHealthRuleParam = None,
    ):
        self.code = code
        self.health_rule_param = health_rule_param

    def validate(self):
        if self.health_rule_param:
            self.health_rule_param.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.health_rule_param is not None:
            result['HealthRuleParam'] = self.health_rule_param.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('HealthRuleParam') is not None:
            temp_model = ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailListHealthDetailHealthRuleParam()
            self.health_rule_param = temp_model.from_map(m['HealthRuleParam'])
        return self


class ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailList(TeaModel):
    def __init__(
        self,
        health_detail: List[ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailListHealthDetail] = None,
    ):
        self.health_detail = health_detail

    def validate(self):
        if self.health_detail:
            for k in self.health_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HealthDetail'] = []
        if self.health_detail is not None:
            for k in self.health_detail:
                result['HealthDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.health_detail = []
        if m.get('HealthDetail') is not None:
            for k in m.get('HealthDetail'):
                temp_model = ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailListHealthDetail()
                self.health_detail.append(temp_model.from_map(k))
        return self


class ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfo(TeaModel):
    def __init__(
        self,
        health_level: str = None,
        health_detail_list: ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailList = None,
        component_name: str = None,
        normal_num: int = None,
        manual_stopped_num: int = None,
        stopped_num: int = None,
        agent_heart_beat_lost_num: int = None,
        total_num: int = None,
        service_name: str = None,
        created_time: int = None,
    ):
        self.health_level = health_level
        self.health_detail_list = health_detail_list
        self.component_name = component_name
        self.normal_num = normal_num
        self.manual_stopped_num = manual_stopped_num
        self.stopped_num = stopped_num
        self.agent_heart_beat_lost_num = agent_heart_beat_lost_num
        self.total_num = total_num
        self.service_name = service_name
        self.created_time = created_time

    def validate(self):
        if self.health_detail_list:
            self.health_detail_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.health_level is not None:
            result['HealthLevel'] = self.health_level
        if self.health_detail_list is not None:
            result['HealthDetailList'] = self.health_detail_list.to_map()
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.normal_num is not None:
            result['NormalNum'] = self.normal_num
        if self.manual_stopped_num is not None:
            result['ManualStoppedNum'] = self.manual_stopped_num
        if self.stopped_num is not None:
            result['StoppedNum'] = self.stopped_num
        if self.agent_heart_beat_lost_num is not None:
            result['AgentHeartBeatLostNum'] = self.agent_heart_beat_lost_num
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HealthLevel') is not None:
            self.health_level = m.get('HealthLevel')
        if m.get('HealthDetailList') is not None:
            temp_model = ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfoHealthDetailList()
            self.health_detail_list = temp_model.from_map(m['HealthDetailList'])
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('NormalNum') is not None:
            self.normal_num = m.get('NormalNum')
        if m.get('ManualStoppedNum') is not None:
            self.manual_stopped_num = m.get('ManualStoppedNum')
        if m.get('StoppedNum') is not None:
            self.stopped_num = m.get('StoppedNum')
        if m.get('AgentHeartBeatLostNum') is not None:
            self.agent_heart_beat_lost_num = m.get('AgentHeartBeatLostNum')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        return self


class ListClusterServiceComponentHealthInfoResponseBodyHealthInfoList(TeaModel):
    def __init__(
        self,
        health_info: List[ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfo] = None,
    ):
        self.health_info = health_info

    def validate(self):
        if self.health_info:
            for k in self.health_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HealthInfo'] = []
        if self.health_info is not None:
            for k in self.health_info:
                result['HealthInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.health_info = []
        if m.get('HealthInfo') is not None:
            for k in m.get('HealthInfo'):
                temp_model = ListClusterServiceComponentHealthInfoResponseBodyHealthInfoListHealthInfo()
                self.health_info.append(temp_model.from_map(k))
        return self


class ListClusterServiceComponentHealthInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cluster_id: str = None,
        health_info_list: ListClusterServiceComponentHealthInfoResponseBodyHealthInfoList = None,
    ):
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.health_info_list = health_info_list

    def validate(self):
        if self.health_info_list:
            self.health_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.health_info_list is not None:
            result['HealthInfoList'] = self.health_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HealthInfoList') is not None:
            temp_model = ListClusterServiceComponentHealthInfoResponseBodyHealthInfoList()
            self.health_info_list = temp_model.from_map(m['HealthInfoList'])
        return self


class ListClusterServiceComponentHealthInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterServiceComponentHealthInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterServiceComponentHealthInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterServiceConfigHistoryRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        config_version: str = None,
        host_group_id: str = None,
        host_instance_id: str = None,
        config_file_name: str = None,
        config_item_key: str = None,
        author: str = None,
        comment: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.config_version = config_version
        self.host_group_id = host_group_id
        self.host_instance_id = host_instance_id
        self.config_file_name = config_file_name
        self.config_item_key = config_item_key
        self.author = author
        self.comment = comment
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.config_file_name is not None:
            result['ConfigFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['ConfigItemKey'] = self.config_item_key
        if self.author is not None:
            result['Author'] = self.author
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ConfigFileName') is not None:
            self.config_file_name = m.get('ConfigFileName')
        if m.get('ConfigItemKey') is not None:
            self.config_item_key = m.get('ConfigItemKey')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory(TeaModel):
    def __init__(
        self,
        old_value: str = None,
        comment: str = None,
        create_time: int = None,
        author: str = None,
        host_name: str = None,
        config_item_name: str = None,
        host_group_id: str = None,
        new_value: str = None,
        host_instance_id: str = None,
        config_file_name: str = None,
        applied: bool = None,
        config_version: str = None,
        service_name: str = None,
        host_group_name: str = None,
    ):
        self.old_value = old_value
        self.comment = comment
        self.create_time = create_time
        self.author = author
        self.host_name = host_name
        self.config_item_name = config_item_name
        self.host_group_id = host_group_id
        self.new_value = new_value
        self.host_instance_id = host_instance_id
        self.config_file_name = config_file_name
        self.applied = applied
        self.config_version = config_version
        self.service_name = service_name
        self.host_group_name = host_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.old_value is not None:
            result['OldValue'] = self.old_value
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.author is not None:
            result['Author'] = self.author
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.config_item_name is not None:
            result['ConfigItemName'] = self.config_item_name
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.new_value is not None:
            result['NewValue'] = self.new_value
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.config_file_name is not None:
            result['ConfigFileName'] = self.config_file_name
        if self.applied is not None:
            result['Applied'] = self.applied
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OldValue') is not None:
            self.old_value = m.get('OldValue')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ConfigItemName') is not None:
            self.config_item_name = m.get('ConfigItemName')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('NewValue') is not None:
            self.new_value = m.get('NewValue')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ConfigFileName') is not None:
            self.config_file_name = m.get('ConfigFileName')
        if m.get('Applied') is not None:
            self.applied = m.get('Applied')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListClusterServiceConfigHistoryResponseBodyConfigHistoryList(TeaModel):
    def __init__(
        self,
        config_history: List[ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory] = None,
    ):
        self.config_history = config_history

    def validate(self):
        if self.config_history:
            for k in self.config_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigHistory'] = []
        if self.config_history is not None:
            for k in self.config_history:
                result['ConfigHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_history = []
        if m.get('ConfigHistory') is not None:
            for k in m.get('ConfigHistory'):
                temp_model = ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory()
                self.config_history.append(temp_model.from_map(k))
        return self


class ListClusterServiceConfigHistoryResponseBody(TeaModel):
    def __init__(
        self,
        total_count: int = None,
        config_history_list: ListClusterServiceConfigHistoryResponseBodyConfigHistoryList = None,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
    ):
        self.total_count = total_count
        self.config_history_list = config_history_list
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number

    def validate(self):
        if self.config_history_list:
            self.config_history_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.config_history_list is not None:
            result['ConfigHistoryList'] = self.config_history_list.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ConfigHistoryList') is not None:
            temp_model = ListClusterServiceConfigHistoryResponseBodyConfigHistoryList()
            self.config_history_list = temp_model.from_map(m['ConfigHistoryList'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        return self


class ListClusterServiceConfigHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterServiceConfigHistoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterServiceConfigHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterServiceQuickLinkRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        direct_type: bool = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.direct_type = direct_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.direct_type is not None:
            result['DirectType'] = self.direct_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('DirectType') is not None:
            self.direct_type = m.get('DirectType')
        return self


class ListClusterServiceQuickLinkResponseBodyQuickLinkListQuickLink(TeaModel):
    def __init__(
        self,
        service_display_name: str = None,
        type: str = None,
        protocol: str = None,
        service_name: str = None,
        quick_link_address: str = None,
        port: str = None,
    ):
        self.service_display_name = service_display_name
        self.type = type
        self.protocol = protocol
        self.service_name = service_name
        self.quick_link_address = quick_link_address
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.type is not None:
            result['Type'] = self.type
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.quick_link_address is not None:
            result['QuickLinkAddress'] = self.quick_link_address
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('QuickLinkAddress') is not None:
            self.quick_link_address = m.get('QuickLinkAddress')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class ListClusterServiceQuickLinkResponseBodyQuickLinkList(TeaModel):
    def __init__(
        self,
        quick_link: List[ListClusterServiceQuickLinkResponseBodyQuickLinkListQuickLink] = None,
    ):
        self.quick_link = quick_link

    def validate(self):
        if self.quick_link:
            for k in self.quick_link:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['QuickLink'] = []
        if self.quick_link is not None:
            for k in self.quick_link:
                result['QuickLink'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.quick_link = []
        if m.get('QuickLink') is not None:
            for k in m.get('QuickLink'):
                temp_model = ListClusterServiceQuickLinkResponseBodyQuickLinkListQuickLink()
                self.quick_link.append(temp_model.from_map(k))
        return self


class ListClusterServiceQuickLinkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        quick_link_list: ListClusterServiceQuickLinkResponseBodyQuickLinkList = None,
    ):
        self.request_id = request_id
        self.quick_link_list = quick_link_list

    def validate(self):
        if self.quick_link_list:
            self.quick_link_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.quick_link_list is not None:
            result['QuickLinkList'] = self.quick_link_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('QuickLinkList') is not None:
            temp_model = ListClusterServiceQuickLinkResponseBodyQuickLinkList()
            self.quick_link_list = temp_model.from_map(m['QuickLinkList'])
        return self


class ListClusterServiceQuickLinkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterServiceQuickLinkResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterServiceQuickLinkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterTemplatesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        biz_id: str = None,
        page_number: int = None,
        page_size: int = None,
        product_type: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.biz_id = biz_id
        self.page_number = page_number
        self.page_size = page_size
        self.product_type = product_type
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        sys_disk_type: str = None,
        multi_instance_types: str = None,
        charge_type: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        disk_count: int = None,
        period: str = None,
        disk_capacity: int = None,
        node_count: int = None,
        host_group_name: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.sys_disk_type = sys_disk_type
        self.multi_instance_types = multi_instance_types
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.period = period
        self.disk_capacity = disk_capacity
        self.node_count = node_count
        self.host_group_name = host_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList(TeaModel):
    def __init__(
        self,
        host_group: List[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup] = None,
    ):
        self.host_group = host_group

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList(TeaModel):
    def __init__(
        self,
        config: List[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(
        self,
        arg: str = None,
        path: str = None,
        name: str = None,
    ):
        self.arg = arg
        self.path = path
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList(TeaModel):
    def __init__(
        self,
        bootstrap_action: List[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction] = None,
    ):
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList(TeaModel):
    def __init__(
        self,
        software_info: List[str] = None,
    ):
        self.software_info = software_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SoftwareInfo') is not None:
            self.software_info = m.get('SoftwareInfo')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfo(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        key_pair_name: str = None,
        log_enable: bool = None,
        ssh_enable: bool = None,
        high_availability_enable: bool = None,
        security_group_id: str = None,
        user_id: str = None,
        host_group_list: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList = None,
        is_open_public_ip: bool = None,
        allow_notebook: bool = None,
        gmt_modified: int = None,
        template_name: str = None,
        deposit_type: str = None,
        security_group_name: str = None,
        config_list: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList = None,
        bootstrap_action_list: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList = None,
        software_info_list: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList = None,
        instance_generation: str = None,
        create_source: str = None,
        eas_enable: bool = None,
        use_custom_hive_meta_db: bool = None,
        user_defined_emr_ecs_role: str = None,
        machine_type: str = None,
        meta_store_type: str = None,
        use_local_meta_db: bool = None,
        master_node_total: int = None,
        init_custom_hive_meta_db: bool = None,
        io_optimized: bool = None,
        meta_store_conf: str = None,
        v_switch_id: str = None,
        configurations: str = None,
        log_path: str = None,
        cluster_type: str = None,
        net_type: str = None,
        zone_id: str = None,
        gmt_create: int = None,
        id: str = None,
    ):
        self.vpc_id = vpc_id
        self.key_pair_name = key_pair_name
        self.log_enable = log_enable
        self.ssh_enable = ssh_enable
        self.high_availability_enable = high_availability_enable
        self.security_group_id = security_group_id
        self.user_id = user_id
        self.host_group_list = host_group_list
        self.is_open_public_ip = is_open_public_ip
        self.allow_notebook = allow_notebook
        self.gmt_modified = gmt_modified
        self.template_name = template_name
        self.deposit_type = deposit_type
        self.security_group_name = security_group_name
        self.config_list = config_list
        self.bootstrap_action_list = bootstrap_action_list
        self.software_info_list = software_info_list
        self.instance_generation = instance_generation
        self.create_source = create_source
        self.eas_enable = eas_enable
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.machine_type = machine_type
        self.meta_store_type = meta_store_type
        self.use_local_meta_db = use_local_meta_db
        self.master_node_total = master_node_total
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.io_optimized = io_optimized
        self.meta_store_conf = meta_store_conf
        self.v_switch_id = v_switch_id
        self.configurations = configurations
        self.log_path = log_path
        self.cluster_type = cluster_type
        self.net_type = net_type
        self.zone_id = zone_id
        self.gmt_create = gmt_create
        self.id = id

    def validate(self):
        if self.host_group_list:
            self.host_group_list.validate()
        if self.config_list:
            self.config_list.validate()
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.software_info_list:
            self.software_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.ssh_enable is not None:
            result['SshEnable'] = self.ssh_enable
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.allow_notebook is not None:
            result['AllowNotebook'] = self.allow_notebook
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.software_info_list is not None:
            result['SoftwareInfoList'] = self.software_info_list.to_map()
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m