"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Isolation = exports.ConstructHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const _limited_internet_access_1 = require("./_limited-internet-access");
const backend_1 = require("./backend");
const backend_dashboard_1 = require("./backend-dashboard");
const inventory_1 = require("./backend/inventory");
const license_list_1 = require("./backend/license-list");
const orchestration_1 = require("./backend/orchestration");
const package_stats_1 = require("./backend/package-stats");
const constants_1 = require("./backend/shared/constants");
const version_tracker_1 = require("./backend/version-tracker");
const repository_1 = require("./codeartifact/repository");
const domain_redirect_1 = require("./domain-redirect");
const monitoring_1 = require("./monitoring");
const package_sources_1 = require("./package-sources");
const storage_1 = require("./s3/storage");
const spdx_license_1 = require("./spdx-license");
const webapp_1 = require("./webapp");
/**
 * (experimental) Construct Hub.
 *
 * @experimental
 */
class ConstructHub extends core_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        super(scope, id);
        if (props.isolateSensitiveTasks != null && props.sensitiveTaskIsolation != null) {
            throw new Error('Supplying both isolateSensitiveTasks and sensitiveTaskIsolation is not supported. Remove usage of isolateSensitiveTasks.');
        }
        const storageFactory = storage_1.S3StorageFactory.getOrCreate(this, {
            failover: props.failoverStorage,
        });
        const monitoring = new monitoring_1.Monitoring(this, 'Monitoring', {
            alarmActions: props.alarmActions,
        });
        const packageData = storageFactory.newBucket(this, 'PackageData', {
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            enforceSSL: true,
            encryption: s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                // Abort multi-part uploads after 1 day
                { abortIncompleteMultipartUploadAfter: core_1.Duration.days(1) },
                // Transition non-current object versions to IA after 1 month
                {
                    noncurrentVersionTransitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: core_1.Duration.days(31),
                        },
                    ],
                },
                // Permanently delete non-current object versions after 3 months
                {
                    noncurrentVersionExpiration: core_1.Duration.days(90),
                    expiredObjectDeleteMarker: true,
                },
                // Permanently delete non-current versions of catalog.json earlier
                { noncurrentVersionExpiration: core_1.Duration.days(7), prefix: constants_1.CATALOG_KEY },
            ],
            versioned: true,
        });
        const isolation = (_b = props.sensitiveTaskIsolation) !== null && _b !== void 0 ? _b : (props.isolateSensitiveTasks ? Isolation.NO_INTERNET_ACCESS : Isolation.UNLIMITED_INTERNET_ACCESS);
        // Create an internal CodeArtifact repository if we run in network-controlled mode, or if a domain is provided.
        const codeArtifact = isolation === Isolation.NO_INTERNET_ACCESS || props.codeArtifactDomain != null
            ? new repository_1.Repository(this, 'CodeArtifact', {
                description: 'Proxy to npmjs.com for ConstructHub',
                domainName: (_c = props.codeArtifactDomain) === null || _c === void 0 ? void 0 : _c.name,
                domainExists: props.codeArtifactDomain != null,
                upstreams: (_d = props.codeArtifactDomain) === null || _d === void 0 ? void 0 : _d.upstreams,
            })
            : undefined;
        const { vpc, vpcEndpoints, vpcSubnets, vpcSecurityGroups } = this.createVpc(isolation, codeArtifact);
        const denyList = new backend_1.DenyList(this, 'DenyList', {
            rules: (_e = props.denyList) !== null && _e !== void 0 ? _e : [],
            packageDataBucket: packageData,
            packageDataKeyPrefix: constants_1.STORAGE_KEY_PREFIX,
            monitoring: monitoring,
        });
        // disable fetching package stats by default if a different package
        // source is configured
        const fetchPackageStats = (_f = props.fetchPackageStats) !== null && _f !== void 0 ? _f : (props.packageSources ? false : true);
        let packageStats;
        const statsKey = 'stats.json';
        if (fetchPackageStats) {
            packageStats = new package_stats_1.PackageStats(this, 'Stats', {
                bucket: packageData,
                monitoring,
                logRetention: props.logRetention,
                objectKey: statsKey,
            });
        }
        const versionTracker = new version_tracker_1.VersionTracker(this, 'VersionTracker', {
            bucket: packageData,
            monitoring,
            logRetention: props.logRetention,
        });
        const orchestration = new orchestration_1.Orchestration(this, 'Orchestration', {
            bucket: packageData,
            codeArtifact,
            denyList,
            logRetention: props.logRetention,
            monitoring,
            vpc,
            vpcEndpoints,
            vpcSubnets,
            vpcSecurityGroups,
        });
        // rebuild the catalog when the deny list changes.
        denyList.prune.onChangeInvoke(orchestration.catalogBuilder.function);
        const packageTagsSerialized = (_h = (_g = props.packageTags) === null || _g === void 0 ? void 0 : _g.map((config) => {
            return {
                ...config,
                condition: config.condition.bind(),
            };
        })) !== null && _h !== void 0 ? _h : [];
        this.ingestion = new backend_1.Ingestion(this, 'Ingestion', {
            bucket: packageData,
            codeArtifact,
            orchestration,
            logRetention: props.logRetention,
            monitoring,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            reprocessFrequency: props.reprocessFrequency,
        });
        const licenseList = new license_list_1.LicenseList(this, 'LicenseList', {
            licenses: (_j = props.allowedLicenses) !== null && _j !== void 0 ? _j : [
                ...spdx_license_1.SpdxLicense.apache(),
                ...spdx_license_1.SpdxLicense.bsd(),
                ...spdx_license_1.SpdxLicense.cddl(),
                ...spdx_license_1.SpdxLicense.epl(),
                spdx_license_1.SpdxLicense.ISC,
                ...spdx_license_1.SpdxLicense.mit(),
                spdx_license_1.SpdxLicense.MPL_2_0,
            ],
        });
        const webApp = new webapp_1.WebApp(this, 'WebApp', {
            domain: props.domain,
            monitoring,
            packageData,
            packageLinks: props.packageLinks,
            packageTags: packageTagsSerialized,
            featuredPackages: props.featuredPackages,
            packageStats,
            featureFlags: props.featureFlags,
            categories: props.categories,
            preloadScript: props.preloadScript,
        });
        const sources = new core_1.Construct(this, 'Sources');
        const packageSources = ((_k = props.packageSources) !== null && _k !== void 0 ? _k : [new package_sources_1.NpmJs()]).map((source) => source.bind(sources, {
            baseUrl: webApp.baseUrl,
            denyList,
            ingestion: this.ingestion,
            licenseList,
            monitoring,
            queue: this.ingestion.queue,
            repository: codeArtifact,
        }));
        const inventory = new inventory_1.Inventory(this, 'InventoryCanary', { bucket: packageData, logRetention: props.logRetention, monitoring });
        new backend_dashboard_1.BackendDashboard(this, 'BackendDashboard', {
            packageData,
            dashboardName: props.backendDashboardName,
            packageSources,
            ingestion: this.ingestion,
            inventory,
            orchestration,
            denyList,
            packageStats,
            versionTracker,
        });
        // add domain redirects
        if (props.domain) {
            for (const redirctSource of (_l = props.additionalDomains) !== null && _l !== void 0 ? _l : []) {
                new domain_redirect_1.DomainRedirect(this, `Redirect-${redirctSource.hostedZone.zoneName}`, {
                    source: redirctSource,
                    targetDomainName: (_m = props.domain) === null || _m === void 0 ? void 0 : _m.zone.zoneName,
                });
            }
        }
        else {
            if (props.additionalDomains && props.additionalDomains.length > 0) {
                throw new Error('Cannot specify "domainRedirects" if a domain is not specified');
            }
        }
    }
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    get grantPrincipal() {
        return this.ingestion.grantPrincipal;
    }
    /**
     * @experimental
     */
    get ingestionQueue() {
        return this.ingestion.queue;
    }
    createVpc(isolation, codeArtifact) {
        if (isolation === Isolation.UNLIMITED_INTERNET_ACCESS) {
            return { vpc: undefined, vpcEndpoints: undefined, vpcSubnets: undefined };
        }
        const subnetType = isolation === Isolation.NO_INTERNET_ACCESS
            ? ec2.SubnetType.ISOLATED
            : ec2.SubnetType.PRIVATE_WITH_NAT;
        const vpcSubnets = { subnetType };
        const vpc = new ec2.Vpc(this, 'VPC', {
            enableDnsHostnames: true,
            enableDnsSupport: true,
            // Provision no NAT gateways if we are running ISOLATED (we wouldn't have a public subnet)
            natGateways: subnetType === ec2.SubnetType.ISOLATED ? 0 : undefined,
            // Pre-allocating PUBLIC / PRIVATE / INTERNAL subnets, regardless of use, so we don't create
            // a whole new VPC if we ever need to introduce subnets of these types.
            subnetConfiguration: [
                // If there is a PRIVATE subnet, there must also have a PUBLIC subnet (for NAT gateways).
                { name: 'Public', subnetType: ec2.SubnetType.PUBLIC, reserved: subnetType === ec2.SubnetType.ISOLATED },
                { name: 'Private', subnetType: ec2.SubnetType.PRIVATE_WITH_NAT, reserved: subnetType === ec2.SubnetType.ISOLATED },
                { name: 'Isolated', subnetType: ec2.SubnetType.ISOLATED, reserved: subnetType !== ec2.SubnetType.ISOLATED },
            ],
        });
        core_1.Tags.of(vpc.node.defaultChild).add('Name', vpc.node.path);
        const securityGroups = subnetType === ec2.SubnetType.PRIVATE_WITH_NAT
            ? _limited_internet_access_1.createRestrictedSecurityGroups(this, vpc)
            : undefined;
        // Creating the CodeArtifact endpoints only if a repository is present.
        const codeArtifactEndpoints = codeArtifact && {
            codeArtifactApi: vpc.addInterfaceEndpoint('CodeArtifact.API', {
                privateDnsEnabled: false,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.api'),
                subnets: vpcSubnets,
                securityGroups,
            }),
            codeArtifact: vpc.addInterfaceEndpoint('CodeArtifact', {
                privateDnsEnabled: true,
                service: new ec2.InterfaceVpcEndpointAwsService('codeartifact.repositories'),
                subnets: vpcSubnets,
                securityGroups,
            }),
        };
        // We'll only use VPC endpoints if we are configured to run in an ISOLATED subnet.
        const vpcEndpoints = {
            ...codeArtifactEndpoints,
            // This is needed so that ECS workloads can use the awslogs driver
            cloudWatchLogs: vpc.addInterfaceEndpoint('CloudWatch.Logs', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH_LOGS,
                subnets: vpcSubnets,
                securityGroups,
            }),
            // These are needed for ECS workloads to be able to pull images
            ecrApi: vpc.addInterfaceEndpoint('ECR.API', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR,
                subnets: vpcSubnets,
                securityGroups,
            }),
            ecr: vpc.addInterfaceEndpoint('ECR.Docker', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER,
                subnets: vpcSubnets,
                securityGroups,
            }),
            // This is needed (among others) for CodeArtifact registry usage
            s3: vpc.addGatewayEndpoint('S3', {
                service: ec2.GatewayVpcEndpointAwsService.S3,
                subnets: [vpcSubnets],
            }),
            // This is useful for getting results from ECS tasks within workflows
            stepFunctions: vpc.addInterfaceEndpoint('StepFunctions', {
                privateDnsEnabled: true,
                service: ec2.InterfaceVpcEndpointAwsService.STEP_FUNCTIONS,
                subnets: vpcSubnets,
                securityGroups,
            }),
        };
        // The S3 access is necessary for the CodeArtifact Repository and ECR Docker
        // endpoints to be used (they serve objects from S3).
        vpcEndpoints.s3.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['s3:GetObject'],
            resources: [
                // The in-region CodeArtifact S3 Bucket
                ...codeArtifact ? [`${codeArtifact.s3BucketArn}/*`] : [],
                // The in-region ECR layer bucket
                `arn:aws:s3:::prod-${core_1.Stack.of(this).region}-starport-layer-bucket/*`,
            ],
            // It doesn't seem we can constrain principals for these grants (unclear
            // which principal those calls are made from, or if that is something we
            // could name here).
            principals: [new aws_iam_1.AnyPrincipal()],
            sid: 'Allow-CodeArtifact-and-ECR',
        }));
        return { vpc, vpcEndpoints, vpcSubnets, vpcSecurityGroups: securityGroups };
    }
}
exports.ConstructHub = ConstructHub;
_a = JSII_RTTI_SYMBOL_1;
ConstructHub[_a] = { fqn: "construct-hub.ConstructHub", version: "0.3.178" };
/**
 * (experimental) How possibly risky operations (such as doc-generation, which requires installing the indexed packages in order to trans-literate sample code) are isolated to mitigate possible arbitrary code execution vulnerabilities in and around `npm install` or the transliterator's use of the TypeScript compiler.
 *
 * @experimental
 */
var Isolation;
(function (Isolation) {
    Isolation[Isolation["UNLIMITED_INTERNET_ACCESS"] = 0] = "UNLIMITED_INTERNET_ACCESS";
    Isolation[Isolation["LIMITED_INTERNET_ACCESS"] = 1] = "LIMITED_INTERNET_ACCESS";
    Isolation[Isolation["NO_INTERNET_ACCESS"] = 2] = "NO_INTERNET_ACCESS";
})(Isolation = exports.Isolation || (exports.Isolation = {}));
//# sourceMappingURL=data:application/json;base64,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