"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebappConfig = void 0;
const path_1 = require("path");
const temp_file_1 = require("../temp-file");
class WebappConfig {
    constructor(props) {
        this.props = props;
        this.file = new temp_file_1.TempFile('config.json', JSON.stringify(this.frontendConfig));
    }
    get frontendConfig() {
        var _a;
        return {
            packageLinks: this.packageLinks,
            packageTags: this.packageTags,
            featuredPackages: this.featuredPackages,
            packageStats: (_a = this.props.showPackageStats) !== null && _a !== void 0 ? _a : true,
            featureFlags: this.props.featureFlags,
            categories: this.props.categories,
            debugInfo: this.debugInfo,
        };
    }
    get packageLinks() {
        var _a;
        const packageLinks = (_a = this.props.packageLinks) !== null && _a !== void 0 ? _a : [];
        // remove allowed domains from frontend config
        return packageLinks.map(({ allowedDomains, ...rest }) => rest);
    }
    get packageTags() {
        var _a;
        const packageTags = (_a = this.props.packageTags) !== null && _a !== void 0 ? _a : [];
        // remove conditional logic from frontend config
        return packageTags.map(({ condition, ...rest }) => rest);
    }
    get featuredPackages() {
        var _a;
        const config = (_a = this.props.featuredPackages) !== null && _a !== void 0 ? _a : {
            sections: [
                {
                    name: 'Recently updated',
                    showLastUpdated: 10,
                },
            ],
        };
        for (const section of config.sections) {
            if ((section.showPackages !== undefined && section.showLastUpdated !== undefined) ||
                (section.showPackages === undefined && section.showLastUpdated === undefined)) {
                throw new Error('Exactly one of \'showPackages\' and \'showPackages\' should be provided.');
            }
        }
        return config;
    }
    get debugInfo() {
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        const packageJson = require(path_1.join('..', '..', 'package.json'));
        return {
            constructHubVersion: packageJson.version,
            constructHubWebappVersion: packageJson.devDependencies['construct-hub-webapp'],
        };
    }
}
exports.WebappConfig = WebappConfig;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uZmlnLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3dlYmFwcC9jb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQTRCO0FBRzVCLDRDQUF3QztBQWtGeEMsTUFBYSxZQUFZO0lBRXZCLFlBQW9DLEtBQXdCO1FBQXhCLFVBQUssR0FBTCxLQUFLLENBQW1CO1FBQzFELElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxvQkFBUSxDQUFDLGFBQWEsRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQy9FLENBQUM7SUFFRCxJQUFZLGNBQWM7O1FBQ3hCLE9BQU87WUFDTCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDL0IsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsWUFBWSxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLG1DQUFJLElBQUk7WUFDakQsWUFBWSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWTtZQUNyQyxVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVO1lBQ2pDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUztTQUMxQixDQUFDO0lBQ0osQ0FBQztJQUVELElBQVksWUFBWTs7UUFDdEIsTUFBTSxZQUFZLFNBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLG1DQUFJLEVBQUUsQ0FBQztRQUNuRCw4Q0FBOEM7UUFDOUMsT0FBTyxZQUFZLENBQUMsR0FBRyxDQUFDLENBQUMsRUFBRSxjQUFjLEVBQUUsR0FBRyxJQUFJLEVBQUUsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDakUsQ0FBQztJQUVELElBQVksV0FBVzs7UUFDckIsTUFBTSxXQUFXLFNBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLG1DQUFJLEVBQUUsQ0FBQztRQUNqRCxnREFBZ0Q7UUFDaEQsT0FBTyxXQUFXLENBQUMsR0FBRyxDQUFDLENBQUMsRUFBRSxTQUFTLEVBQUUsR0FBRyxJQUFJLEVBQUUsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUVELElBQVksZ0JBQWdCOztRQUMxQixNQUFNLE1BQU0sU0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixtQ0FBSTtZQUM1QyxRQUFRLEVBQUU7Z0JBQ1I7b0JBQ0UsSUFBSSxFQUFFLGtCQUFrQjtvQkFDeEIsZUFBZSxFQUFFLEVBQUU7aUJBQ3BCO2FBQ0Y7U0FDRixDQUFDO1FBQ0YsS0FBSyxNQUFNLE9BQU8sSUFBSSxNQUFNLENBQUMsUUFBUSxFQUFFO1lBQ3JDLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxLQUFLLFNBQVMsSUFBSSxPQUFPLENBQUMsZUFBZSxLQUFLLFNBQVMsQ0FBQztnQkFDN0UsQ0FBQyxPQUFPLENBQUMsWUFBWSxLQUFLLFNBQVMsSUFBSSxPQUFPLENBQUMsZUFBZSxLQUFLLFNBQVMsQ0FBQyxFQUFFO2dCQUNqRixNQUFNLElBQUksS0FBSyxDQUFDLDBFQUEwRSxDQUFDLENBQUM7YUFDN0Y7U0FDRjtRQUNELE9BQU8sTUFBTSxDQUFDO0lBQ2hCLENBQUM7SUFFRCxJQUFZLFNBQVM7UUFDbkIsaUVBQWlFO1FBQ2pFLE1BQU0sV0FBVyxHQUFHLE9BQU8sQ0FBQyxXQUFJLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxjQUFjLENBQUMsQ0FBQyxDQUFDO1FBQzlELE9BQU87WUFDTCxtQkFBbUIsRUFBRSxXQUFXLENBQUMsT0FBTztZQUN4Qyx5QkFBeUIsRUFBRSxXQUFXLENBQUMsZUFBZSxDQUFDLHNCQUFzQixDQUFDO1NBQy9FLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUF4REQsb0NBd0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgam9pbiB9IGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgQ2F0ZWdvcnksIEZlYXR1cmVkUGFja2FnZXMsIEZlYXR1cmVGbGFncywgUGFja2FnZUxpbmtDb25maWcgfSBmcm9tICcuJztcbmltcG9ydCB7IFBhY2thZ2VUYWdDb25maWcgfSBmcm9tICcuLi9wYWNrYWdlLXRhZyc7XG5pbXBvcnQgeyBUZW1wRmlsZSB9IGZyb20gJy4uL3RlbXAtZmlsZSc7XG5cbmludGVyZmFjZSBGcm9udGVuZFBhY2thZ2VMaW5rQ29uZmlnIHtcbiAgbGlua0xhYmVsOiBzdHJpbmc7XG4gIGNvbmZpZ0tleTogc3RyaW5nO1xuICBsaW5rVGV4dD86IHN0cmluZztcbn1cblxuaW50ZXJmYWNlIEZyb250ZW5kUGFja2FnZVRhZ0NvbmZpZ0Jhc2Uge1xuICBsYWJlbDogc3RyaW5nO1xuICBjb2xvcj86IHN0cmluZztcbn1cblxuaW50ZXJmYWNlIEZyb250ZW5kUGFja2FnZVRhZ0hpZ2hsaWdodENvbmZpZyBleHRlbmRzIEZyb250ZW5kUGFja2FnZVRhZ0NvbmZpZ0Jhc2V7XG4gIGljb24/OiBzdHJpbmc7XG59XG5cbmludGVyZmFjZSBGcm9udGVuZFBhY2thZ2VUYWdTZWFyY2hGaWx0ZXJDb25maWcge1xuICBkaXNwbGF5OiBzdHJpbmc7XG4gIGdyb3VwQnk6IHN0cmluZztcbn1cblxuaW50ZXJmYWNlIEZyb250ZW5kUGFja2FnZVRhZ0NvbmZpZyB7XG4gIGlkOiBzdHJpbmc7XG4gIGtleXdvcmQ/OiBGcm9udGVuZFBhY2thZ2VUYWdDb25maWdCYXNlO1xuICBoaWdobGlnaHQ/OiBGcm9udGVuZFBhY2thZ2VUYWdIaWdobGlnaHRDb25maWc7XG4gIHNlYXJjaEZpbHRlcj86IEZyb250ZW5kUGFja2FnZVRhZ1NlYXJjaEZpbHRlckNvbmZpZztcbn1cblxudHlwZSBGcm9udGVuZEZlYXR1cmVkUGFja2FnZXNDb25maWcgPSBGZWF0dXJlZFBhY2thZ2VzO1xuXG5pbnRlcmZhY2UgRnJvbnRlbmREZWJ1Z0luZm8ge1xuICBjb25zdHJ1Y3RIdWJWZXJzaW9uOiBzdHJpbmc7XG4gIGNvbnN0cnVjdEh1YldlYmFwcFZlcnNpb246IHN0cmluZztcbn1cblxuaW50ZXJmYWNlIEZyb250ZW5kQ29uZmlnIHtcbiAgcGFja2FnZUxpbmtzPzogRnJvbnRlbmRQYWNrYWdlTGlua0NvbmZpZ1tdO1xuICBwYWNrYWdlVGFncz86IEZyb250ZW5kUGFja2FnZVRhZ0NvbmZpZ1tdO1xuICBmZWF0dXJlZFBhY2thZ2VzPzogRnJvbnRlbmRGZWF0dXJlZFBhY2thZ2VzQ29uZmlnO1xuICBwYWNrYWdlU3RhdHM/OiBib29sZWFuO1xuICBmZWF0dXJlRmxhZ3M/OiBGZWF0dXJlRmxhZ3M7XG4gIGNhdGVnb3JpZXM/OiBDYXRlZ29yeVtdO1xuICBkZWJ1Z0luZm8/OiBGcm9udGVuZERlYnVnSW5mbztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBXZWJhcHBDb25maWdQcm9wcyB7XG4gIC8qKlxuICAgKiBDb25maWd1cmF0aW9uIGZvciBjdXN0b20gcGFja2FnZSBwYWdlIGxpbmtzLlxuICAgKi9cbiAgcmVhZG9ubHkgcGFja2FnZUxpbmtzPzogUGFja2FnZUxpbmtDb25maWdbXTtcblxuICAvKipcbiAgICogQ29uZmlndXJhdGlvbiBmb3IgY3VzdG9tIGNvbXB1dGVkIHRhZ3MuXG4gICAqL1xuICByZWFkb25seSBwYWNrYWdlVGFncz86IFBhY2thZ2VUYWdDb25maWdbXTtcblxuICAvKipcbiAgICogQ29uZmlndXJhdGlvbiBmb3IgcGFja2FnZXMgdG8gZmVhdHVyZSBvbiB0aGUgaG9tZSBwYWdlLlxuICAgKiBAZGVmYXVsdCAtIERpc3BsYXkgdGhlIDEwIG1vc3QgcmVjZW50bHkgdXBkYXRlZCBwYWNrYWdlc1xuICAgKi9cbiAgcmVhZG9ubHkgZmVhdHVyZWRQYWNrYWdlcz86IEZlYXR1cmVkUGFja2FnZXM7XG5cbiAgLyoqXG4gICAqIENvbmZpZ3VyZSBmZWF0dXJlIGZsYWdzIGZvciB0aGUgd2ViIGFwcC5cbiAgICovXG4gIHJlYWRvbmx5IGZlYXR1cmVGbGFncz86IEZlYXR1cmVGbGFncztcblxuICAvKipcbiAgICogV2hldGhlciB0byBkaXNwbGF5IHBhY2thZ2Ugc3RhdHMgZnJvbSBgc3RhdHMuanNvbmAgb25cbiAgICogcGFja2FnZSBjYXJkcy5cbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgc2hvd1BhY2thZ2VTdGF0cz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEJyb3dzZSBjYXRlZ29yaWVzLiBFYWNoIGNhdGVnb3J5IHdpbGwgYXBwZWFyIGluIHRoZSBob21lIHBhZ2UgYXMgYSBidXR0b25cbiAgICogd2l0aCBhIGxpbmsgdG8gdGhlIHJlbGV2YW50IHNlYXJjaCBxdWVyeS5cbiAgICovXG4gIHJlYWRvbmx5IGNhdGVnb3JpZXM/OiBDYXRlZ29yeVtdO1xufVxuXG5leHBvcnQgY2xhc3MgV2ViYXBwQ29uZmlnIHtcbiAgcHVibGljIHJlYWRvbmx5IGZpbGU6IFRlbXBGaWxlO1xuICBwdWJsaWMgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogV2ViYXBwQ29uZmlnUHJvcHMpIHtcbiAgICB0aGlzLmZpbGUgPSBuZXcgVGVtcEZpbGUoJ2NvbmZpZy5qc29uJywgSlNPTi5zdHJpbmdpZnkodGhpcy5mcm9udGVuZENvbmZpZykpO1xuICB9XG5cbiAgcHJpdmF0ZSBnZXQgZnJvbnRlbmRDb25maWcoKTogRnJvbnRlbmRDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBwYWNrYWdlTGlua3M6IHRoaXMucGFja2FnZUxpbmtzLFxuICAgICAgcGFja2FnZVRhZ3M6IHRoaXMucGFja2FnZVRhZ3MsXG4gICAgICBmZWF0dXJlZFBhY2thZ2VzOiB0aGlzLmZlYXR1cmVkUGFja2FnZXMsXG4gICAgICBwYWNrYWdlU3RhdHM6IHRoaXMucHJvcHMuc2hvd1BhY2thZ2VTdGF0cyA/PyB0cnVlLFxuICAgICAgZmVhdHVyZUZsYWdzOiB0aGlzLnByb3BzLmZlYXR1cmVGbGFncyxcbiAgICAgIGNhdGVnb3JpZXM6IHRoaXMucHJvcHMuY2F0ZWdvcmllcyxcbiAgICAgIGRlYnVnSW5mbzogdGhpcy5kZWJ1Z0luZm8sXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgZ2V0IHBhY2thZ2VMaW5rcygpOiBGcm9udGVuZFBhY2thZ2VMaW5rQ29uZmlnW10ge1xuICAgIGNvbnN0IHBhY2thZ2VMaW5rcyA9IHRoaXMucHJvcHMucGFja2FnZUxpbmtzID8/IFtdO1xuICAgIC8vIHJlbW92ZSBhbGxvd2VkIGRvbWFpbnMgZnJvbSBmcm9udGVuZCBjb25maWdcbiAgICByZXR1cm4gcGFja2FnZUxpbmtzLm1hcCgoeyBhbGxvd2VkRG9tYWlucywgLi4ucmVzdCB9KSA9PiByZXN0KTtcbiAgfVxuXG4gIHByaXZhdGUgZ2V0IHBhY2thZ2VUYWdzKCk6IEZyb250ZW5kUGFja2FnZVRhZ0NvbmZpZ1tdIHtcbiAgICBjb25zdCBwYWNrYWdlVGFncyA9IHRoaXMucHJvcHMucGFja2FnZVRhZ3MgPz8gW107XG4gICAgLy8gcmVtb3ZlIGNvbmRpdGlvbmFsIGxvZ2ljIGZyb20gZnJvbnRlbmQgY29uZmlnXG4gICAgcmV0dXJuIHBhY2thZ2VUYWdzLm1hcCgoeyBjb25kaXRpb24sIC4uLnJlc3QgfSkgPT4gcmVzdCk7XG4gIH1cblxuICBwcml2YXRlIGdldCBmZWF0dXJlZFBhY2thZ2VzKCk6IEZyb250ZW5kRmVhdHVyZWRQYWNrYWdlc0NvbmZpZyB7XG4gICAgY29uc3QgY29uZmlnID0gdGhpcy5wcm9wcy5mZWF0dXJlZFBhY2thZ2VzID8/IHtcbiAgICAgIHNlY3Rpb25zOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBuYW1lOiAnUmVjZW50bHkgdXBkYXRlZCcsXG4gICAgICAgICAgc2hvd0xhc3RVcGRhdGVkOiAxMCxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfTtcbiAgICBmb3IgKGNvbnN0IHNlY3Rpb24gb2YgY29uZmlnLnNlY3Rpb25zKSB7XG4gICAgICBpZiAoKHNlY3Rpb24uc2hvd1BhY2thZ2VzICE9PSB1bmRlZmluZWQgJiYgc2VjdGlvbi5zaG93TGFzdFVwZGF0ZWQgIT09IHVuZGVmaW5lZCkgfHxcbiAgICAgICAgICAoc2VjdGlvbi5zaG93UGFja2FnZXMgPT09IHVuZGVmaW5lZCAmJiBzZWN0aW9uLnNob3dMYXN0VXBkYXRlZCA9PT0gdW5kZWZpbmVkKSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0V4YWN0bHkgb25lIG9mIFxcJ3Nob3dQYWNrYWdlc1xcJyBhbmQgXFwnc2hvd1BhY2thZ2VzXFwnIHNob3VsZCBiZSBwcm92aWRlZC4nKTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIGNvbmZpZztcbiAgfVxuXG4gIHByaXZhdGUgZ2V0IGRlYnVnSW5mbygpOiBGcm9udGVuZERlYnVnSW5mbyB7XG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby1yZXF1aXJlLWltcG9ydHNcbiAgICBjb25zdCBwYWNrYWdlSnNvbiA9IHJlcXVpcmUoam9pbignLi4nLCAnLi4nLCAncGFja2FnZS5qc29uJykpO1xuICAgIHJldHVybiB7XG4gICAgICBjb25zdHJ1Y3RIdWJWZXJzaW9uOiBwYWNrYWdlSnNvbi52ZXJzaW9uLFxuICAgICAgY29uc3RydWN0SHViV2ViYXBwVmVyc2lvbjogcGFja2FnZUpzb24uZGV2RGVwZW5kZW5jaWVzWydjb25zdHJ1Y3QtaHViLXdlYmFwcCddLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==