# Generated by Django 2.2rc1 on 2019-03-20 11:24

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('is_read', models.BooleanField(default=False, verbose_name='is read')),
                ('is_triggered', models.BooleanField(default=False, verbose_name='is triggered')),
                ('recipient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                related_name='notifications', to=settings.AUTH_USER_MODEL,
                                                verbose_name='recipient')),
            ],
            options={
                'verbose_name': 'notification',
                'verbose_name_plural': 'notifications',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='NotificationTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('title', models.CharField(max_length=200, verbose_name='title')),
                ('text', models.TextField(blank=True, null=True, verbose_name='text')),
                ('trigger_action', models.CharField(blank=True, max_length=2500, null=True,
                                                    verbose_name='trigger action')),
                ('slug', models.SlugField(blank=True, max_length=200, null=True, unique=True, verbose_name='slug')),
            ],
            options={
                'verbose_name': 'notification template',
                'verbose_name_plural': 'notification templates',
            },
        ),
        migrations.CreateModel(
            name='NotificationRelatedObject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('name', models.CharField(max_length=200, verbose_name='name')),
                ('object_id', models.TextField(db_index=True, verbose_name='object ID')),
                ('content_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL,
                                                   to='contenttypes.ContentType', verbose_name='content type')),
                ('notification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                   related_name='related_objects', to='pynotify.Notification',
                                                   verbose_name='notification')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='notification',
            name='template',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='notifications',
                                    to='pynotify.NotificationTemplate', verbose_name='template'),
        ),
    ]
