"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @experimental
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        this.serviceAccountName = (_b = options === null || options === void 0 ? void 0 : options.serviceAccountName) !== null && _b !== void 0 ? _b : 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_c = options === null || options === void 0 ? void 0 : options.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        this.createServiceAccount = (_d = options === null || options === void 0 ? void 0 : options.createServiceAccount) !== null && _d !== void 0 ? _d : true;
        this.certManager = (_e = options === null || options === void 0 ? void 0 : options.certManager) !== null && _e !== void 0 ? _e : true;
        if (this.certManager === true) {
            new cdk8s.Include(this, 'certificate-manager', {
                url: 'https://raw.githubusercontent.com/Hunter-Thompson/my-etcd/main/cert-manager-v1.0.2.yaml',
            });
        }
        new cdk8s.Include(this, 'alb-crds', {
            url: path.join(__dirname, '../crds.yaml'),
        });
        const webhookAnnotations = options.argoCertIgnore ? { 'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert', 'argocd.argoproj.io/compare-options': 'IgnoreExtraneous' } : { 'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert' };
        new k8s.KubeMutatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-webhook', {
            metadata: {
                annotations: webhookAnnotations,
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-v1-pod',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mpod.elbv2.k8s.aws',
                    namespaceSelector: {
                        matchExpressions: [
                            {
                                key: 'elbv2.k8s.aws/pod-readiness-gate-inject',
                                operator: 'In',
                                values: ['enabled'],
                            },
                        ],
                    },
                    rules: [{
                            apiGroups: [''],
                            apiVersions: ['v1'],
                            operations: [
                                'CREATE',
                            ],
                            resources: ['pods'],
                        }],
                    sideEffects: 'None',
                },
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
        if (options.createServiceAccount === true) {
            new k8s.KubeServiceAccount(this, 'aws-load-balancer-controller-sa', {
                metadata: {
                    labels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            });
        }
        new k8s.KubeRole(this, 'aws-load-balancer-controller-leader-election-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-role',
                namespace: this.namespace,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    verbs: ['create'],
                }, {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    resourceNames: ['aws-load-balancer-controller-leader'],
                    verbs: ['get', 'update', 'patch'],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'leader-cluster-role', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'ClusterRole',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: `${this.serviceAccountName}-role`,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['endpoints'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['events'],
                    verbs: [
                        'create',
                        'patch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['namespaces'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['nodes'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['pods'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['secrets'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['services'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['services/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['ingressclassparams'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings'],
                    verbs: [
                        'create',
                        'delete',
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingressclasses'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
            ],
        });
        new k8s.KubeRoleBinding(this, 'aws-load-balancer-controller-leader-election-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-rolebinding',
                namespace: this.namespace,
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'Role',
                name: 'aws-load-balancer-controller-leader-election-role',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new k8s.KubeClusterRoleBinding(this, 'aws-load-balancer-controller-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-rolebinding',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: `${this.serviceAccountName}-role`,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    namespace: this.namespace,
                    name: this.serviceAccountName,
                },
            ],
        });
        new k8s.KubeService(this, 'aws-load-balancer-webhook-service', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook-service',
                namespace: this.namespace,
            },
            spec: {
                ports: [
                    {
                        port: 443,
                        targetPort: 9443,
                    },
                ],
                selector: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
            },
        });
        new k8s.KubeDeployment(this, 'aws-load-balancer-controller-deployment', {
            metadata: {
                labels: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                namespace: this.namespace,
                name: this.deploymentName,
            },
            spec: {
                replicas: (_f = options === null || options === void 0 ? void 0 : options.replicas) !== null && _f !== void 0 ? _f : 1,
                selector: {
                    matchLabels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            'app.kubernetes.io/component': 'controller',
                            'app.kubernetes.io/name': this.serviceAccountName,
                            ...options.labels,
                        },
                    },
                    spec: {
                        containers: [{
                                name: 'controller',
                                image: (_g = options === null || options === void 0 ? void 0 : options.image) !== null && _g !== void 0 ? _g : 'amazon/aws-alb-ingress-controller:v2.2.0',
                                args: this.argsFunc(options.args),
                                env: this.envFunc(options.env),
                                livenessProbe: {
                                    failureThreshold: 2,
                                    httpGet: {
                                        path: '/healthz',
                                        port: 61779,
                                        scheme: 'HTTP',
                                    },
                                    initialDelaySeconds: 30,
                                    timeoutSeconds: 10,
                                },
                                ports: [
                                    {
                                        containerPort: 9443,
                                        name: 'webhook-server',
                                        protocol: 'TCP',
                                    },
                                ],
                                resources: {
                                    limits: {
                                        cpu: '200m',
                                        memory: '500Mi',
                                    },
                                    requests: {
                                        cpu: '100m',
                                        memory: '200Mi',
                                    },
                                },
                                securityContext: {
                                    allowPrivilegeEscalation: false,
                                    readOnlyRootFilesystem: true,
                                    runAsNonRoot: true,
                                },
                                volumeMounts: [
                                    {
                                        mountPath: '/tmp/k8s-webhook-server/serving-certs',
                                        name: 'cert',
                                        readOnly: true,
                                    },
                                ],
                            }],
                        securityContext: {
                            fsGroup: 1337,
                        },
                        serviceAccountName: `${this.serviceAccountName}`,
                        terminationGracePeriodSeconds: 10,
                        priorityClassName: 'system-cluster-critical',
                        volumes: [{
                                name: 'cert',
                                secret: {
                                    defaultMode: 420,
                                    secretName: 'aws-load-balancer-webhook-tls',
                                },
                            }],
                    },
                },
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-serving-cert', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Certificate',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-serving-cert',
                namespace: this.namespace,
            },
            spec: {
                dnsNames: [
                    'aws-load-balancer-webhook-service.kube-system.svc',
                    'aws-load-balancer-webhook-service.kube-system.svc.cluster.local',
                ],
                issuerRef: {
                    kind: 'Issuer',
                    name: 'aws-load-balancer-selfsigned-issuer',
                },
                secretName: 'aws-load-balancer-webhook-tls',
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-selfsigned-issuer', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Issuer',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-selfsigned-issuer',
                namespace: this.namespace,
            },
            spec: {
                selfSigned: {},
            },
        });
        new k8s.KubeValidatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-selfsigned-issuer-valid', {
            metadata: {
                annotations: webhookAnnotations,
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/validate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'vtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--ingress-class=alb', `--cluster-name=${this.clusterName}`];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
    envFunc(envSet) {
        return envSet;
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "@opencdk8s/cdk8s-aws-lb-controller.AwsLoadBalancerController", version: "0.2.3" };
//# sourceMappingURL=data:application/json;base64,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